<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Console;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use WebVision\CustomDataSearch\Model\CustomSearcManage;

class IndexAll extends Command
{
    /**
     * @var CustomSearcManage
     */
    protected $customSearcManage;

    /**
     * @param CustomSearcManage $customSearcManage
     */
    public function __construct(
        CustomSearcManage $customSearcManage
    ) {
        $this->customSearcManage = $customSearcManage;
        parent::__construct();
    }

    protected function configure()
    {
        $this->setName('indexer:manufacturers:sync');
        $this->setDescription('It will reindex all manfacture categories');

        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->customSearcManage->processAllSku();
        $output->writeln('<info>Manufacturers are updated successfully, Please reindex Custom Data Search Indexing ( elasticsuite_customdata_fulltext )</info>');
        return \Magento\Framework\Console\Cli::RETURN_SUCCESS;
    }
}