<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */

namespace WebVision\CustomDataSearch\Controller\Adminhtml\Index;

use WebVision\CustomDataSearch\Helper\Data;

class Index extends \Magento\Backend\App\Action
{
    protected $resultPageFactory;

    protected $customDataHelper;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \WebVision\CustomDataSearch\Helper\Data $customDataHelper,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->customDataHelper = $customDataHelper;
        $this->resultPageFactory = $resultPageFactory;
    }

    public function execute()
    {
        // Check Module status
        if(!$this->customDataHelper->getCustomDataSearchStatus()){
            $this->messageManager->addNotice("Please enable it from the store configuration.");
        }

        $resultPage = $this->resultPageFactory->create();
        $resultPage->getConfig()->getTitle()->prepend(__('Manufacture Search Manager'));
        return $resultPage;
    }
}
