<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */

namespace WebVision\CustomDataSearch\Controller\Adminhtml\Index;

use Magento\Framework\Controller\ResultFactory;
use WebVision\CustomDataSearch\Model\CustomSearcManage;
use Magento\Backend\App\Action;
use WebVision\CustomDataSearch\Api\Data\CustomDataInterface;
use Magento\Ui\Component\MassAction\Filter;

class MasssSync extends Action
{
    /**
     * @var Filter
     */
    protected $customSearcManage;

    /**
     * @var Filter
     */
    protected $filter;

    /**
     * @param Action\Context $context
     * @param CustomSearcManage $customSearcManage
     */
    public function __construct(
        Action\Context $context,
        Filter $filter,
        CustomSearcManage $customSearcManage
    ) {
        parent::__construct($context);
        $this->filter = $filter;
        $this->customSearcManage = $customSearcManage;
    }

    /**
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        try {
            $searchData = $this->customSearcManage->getCustomSearchModal()->getCollection();
            $selectedData = $this->filter->getCollection($searchData);
            foreach($selectedData as $search) {
                $this->customSearcManage->addStatus($search->getId(), CustomDataInterface::PROCESS_STATUS);
            }
            $this->messageManager->addSuccess(__('The sync selected record are updated and now in the queue.'));
        } catch (\Exception $e) {
            $this->messageManager->addError($e->getMessage());
        }

        return $resultRedirect->setPath('*/*/');
    }
}
