<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */

namespace WebVision\CustomDataSearch\Controller\Adminhtml\Index;

use Magento\Framework\Controller\ResultFactory;
use WebVision\CustomDataSearch\Model\CustomSearcManage;
use Magento\Backend\App\Action;
use WebVision\CustomDataSearch\Api\Data\CustomDataInterface;

class Reset extends Action
{
    /**
     * @var CustomSearcManage
     */
    protected $customSearcManage;

    /**
     * @param Action\Context $context
     * @param CustomSearcManage $customSearcManage
     */
    public function __construct(
        Action\Context $context,
        CustomSearcManage $customSearcManage
    ) {
        parent::__construct($context);
        $this->customSearcManage = $customSearcManage;
    }

    /**
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        try {
            // Reset Processing
            if($this->customSearcManage->resetRunningProcess()){
                $this->messageManager->addSuccess(__('The running processes have been reset and are now in the queue.'));
            } else {
                $this->messageManager->addWarning(__('Currently, there are no running processes.'));
            }
        } catch (\Exception $e) {
            $this->messageManager->addError($e->getMessage());
        }

        return $resultRedirect->setPath('*/*/');
    }
}
