<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use WebVision\CustomDataSearch\Model\CustomDataSearchFactory;
use WebVision\CustomDataSearch\Api\Data\CustomDataInterface;

class Save extends \Magento\Backend\App\Action
{
    protected $customSearchDataModel;

    public function __construct(
        Action\Context $context,
        CustomDataSearchFactory $customSearchDataModel
    ) {
        parent::__construct($context);
        $this->customSearchDataModel = $customSearchDataModel;
    }

    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        $resultRedirect = $this->resultRedirectFactory->create();

        if ($data) {
            $id = $this->getRequest()->getParam(CustomDataInterface::ID);

            $customSearchDataModel = $this->customSearchDataModel->create();
            if ($id) {
                $customSearchDataModel->load($id);
            }

            try {
                $customSearchDataModel->setData($data);
                $customSearchDataModel->save();
                $this->messageManager->addSuccess(__('The data has been saved.'));
                if ($this->getRequest()->getParam('back')) {
                    if ($this->getRequest()->getParam('back') == 'add') {
                        return $resultRedirect->setPath('*/*/add');
                    } else {
                        return $resultRedirect->setPath(
                            '*/*/edit',
                            [
                                CustomDataInterface::ID => $customSearchDataModel->getId(),
                                '_current' => true
                            ]
                        );
                    }
                }
                return $resultRedirect->setPath('*/*/');
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\RuntimeException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addException($e, __('Something went wrong while saving the data.'));
            }

            return $resultRedirect->setPath(
                '*/*/edit',
                [
                    CustomDataInterface::ID => $this->getRequest()->getParam(CustomDataInterface::ID)
                ]
            );
        }

        return $resultRedirect->setPath('*/*/');
    }
}
