<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Controller\Adminhtml\Index;

use Magento\Framework\Controller\ResultFactory;
use WebVision\CustomDataSearch\Model\CustomSearcManage;
use Magento\Backend\App\Action;
use WebVision\CustomDataSearch\Api\Data\CustomDataInterface;

class Sync extends Action
{
    protected $customSearcManage;

    /**
     * @param Action\Context $context
     * @param CustomSearcManage $customSearcManage
     */
    public function __construct(
        Action\Context $context,
        CustomSearcManage $customSearcManage
    ) {
        parent::__construct($context);
        $this->customSearcManage = $customSearcManage;
    }

    /**
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam(CustomDataInterface::ID);
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                if($this->customSearcManage->addStatus($id, CustomDataInterface::PROCESS_STATUS)){
                    $this->messageManager->addSuccess(__('The sync for this record is updated and now in the queue.'));
                } else {
                    $this->messageManager->addError(__('Something went wrong while updating the sync status.'));
                }

                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', [CustomDataInterface::ID => $id]);
            }
        }

        $this->messageManager->addError(__('Record does not exist'));
        return $resultRedirect->setPath('*/*/');
    }
}
