<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Cron;

use WebVision\CustomDataSearch\Logger\Logger;
use Extendware\AdvanceUrl\Helper\Data;
use WebVision\CustomDataSearch\Model\CustomSearcManage;
use WebVision\CustomDataSearch\Model\Indexer\Fulltext;

class SyncSearchData
{
    /**
     * @var Logger
     */
    protected $logger;

    protected $customSearcManage;

     /**
      * Constructor
      *
      * @param Logger $logger
      * @param Data $advanceUrlHelper
      */
    public function __construct(
        Logger $logger,
        CustomSearcManage $customSearcManage
    ) {
        $this->logger = $logger;
        $this->customSearcManage = $customSearcManage;
    }

    /**
     * Execute the cron job to sync new categories
     *
     * @return void|bool
     */
    public function execute()
    {
        // Sync data into search
        if($this->customSearcManage->getCustomDataSearchStatus()){
            $this->customSearcManage->syncCustomData([Fulltext::INDEXER_ID]);
        }
    }
}
