<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Model\Autocomplete\Typo3;

use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\UrlInterface;
use WebVision\CustomDataSearch\Helper\Data;
use WebVision\CustomDataSearch\Api\Data\CustomDataInterface as CustomData;
use WebVision\CustomDataSearch\Model\CustomSearcManage;

class ItemFactory extends \Magento\Search\Model\Autocomplete\ItemFactory
{
    /**
     * @var UrlInterfacee
     */
    private $urlBuilder;

    /**
     * @var Data
     */
    private $customdataHelper;

    /**
     * @var CustomSearcManage
     */
    private $customSearcManage;

    /**
     * ItemFactory constructor.
     *
     * @param ObjectManagerInterface $objectManager    The Object Manager
     * @param UrlInterface           $urlBuilder       The Url Builder
     */
    public function __construct(
        ObjectManagerInterface $objectManager,
        UrlInterface $urlBuilder,
        Data $customdataHelper,
        CustomSearcManage $customSearcManage
    ) {
        parent::__construct($objectManager);
        $this->urlBuilder = $urlBuilder;
        $this->customdataHelper = $customdataHelper;
        $this->customSearcManage = $customSearcManage;
    }

    /**
     * {@inheritDoc}
     */
    public function create(array $data)
    {
        $data = $this->addCategoryData($data);
        unset($data['customdata']);

        return parent::create($data);
    }

    /**
     * Load customdata Pages data and append them to the original data.
     *
     * @param array $data Autocomplete item data.
     *
     * @return array
     */
    private function addCategoryData($data)
    {
        $customdataData = $data['customdata'];
        $title = $customdataData->getData(CustomData::TITLE) ?? '';
        $url = $this->customSearcManage->getCategoryUrl($customdataData->getData(CustomData::CAT_ID));

        $categoryData = [
            'title' => $title,
            'url' => $url,
        ];

        $data = array_merge($data, $categoryData);

        return $data;
    }

    /**
     * Retrieve customdata page Url
     *
     * @param string $slug
     *
     * @return string
     */
    public function getPageUrl($slug)
    {
        $slug = ltrim($slug, '/');
        $slug = $this->urlBuilder->getDirectUrl($slug ?? '');
        $slug .= $this->customdataHelper->getCategoryUrlSuffix();

        return $slug;
    }
}
