<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Model\Indexer\Fulltext\Action;

use WebVision\CustomDataSearch\Helper\Data;
use WebVision\CustomDataSearch\Model\ResourceModel\Typo3\Indexer\Fulltext\Action\Full as ResourceModel;
use WebVision\CustomDataSearch\Api\Data\CustomDataInterface as CustomData;
use WebVision\CustomDataSearch\Model\CustomSearcManage;

class Full
{
    /**
     * @var ResourceModel
     */
    private $resourceModel;

    /**
     * @var Data
     */
    private $customdataHelper;

    private $customSearcManage;

    /**
     * Constructor.
     *
     * @param ResourceModel $resourceModel Indexer resource model.
     */
    public function __construct(
        ResourceModel $resourceModel,
        Data $customdataHelper,
        CustomSearcManage $customSearcManage
    ) {
        $this->resourceModel = $resourceModel;
        $this->customdataHelper = $customdataHelper;
        $this->customSearcManage = $customSearcManage;
    }

    /**
     * Get data for a list of pages in a store id.
     * If the product list ids is null, all pages data will be loaded.
     *
     * @param int    $storeId     Store id.
     * @param array|null $pageIds List of category ids.
     *
     * @return \Traversable
     */
    public function rebuildStoreIndex($storeId, $pageIds = null)
    {
        if ($this->customdataHelper->getCustomDataSearchStatus()) {
            $lastpageId = 0;
            $pages = $this->getSearchablePages($storeId, $pageIds, $lastpageId);
            foreach ($pages as $pagesData) {
                if (isset($pagesData[CustomData::ID])) {
                    $lastpageId = (int) $pagesData[CustomData::ID];
                    yield $lastpageId => $pagesData;
                    $this->customSearcManage->addStatus($pagesData[CustomData::ID], CustomData::READY_STATUS);
                }
            }
        }
    }

    /**
     * Load a bulk of page data.
     *
     * @param int     $storeId     Store id.
     * @param string  $pageIds     Pages ids filter.
     * @param int $fromId      Load product with id greater than.
     * @param int $limit       Number of product to get loaded.
     *
     * @return array
     */
    private function getSearchablePages($storeId, $pageIds = null, $fromId = 0, $limit = 100)
    {
        return $this->resourceModel->getSearchablePages($storeId, $pageIds, $fromId, $limit);
    }
}
