<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Model\ResourceModel\Typo3\Indexer\Fulltext\Action;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\EntityManager\MetadataPool;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Stdlib\DateTime\DateTime;
use Magento\Store\Model\StoreManagerInterface;
use Smile\ElasticsuiteCatalog\Model\ResourceModel\Eav\Indexer\Indexer;
use WebVision\CustomDataSearch\Helper\Data as CustomDataHelper;
use WebVision\CustomDataSearch\Model\ResourceModel\CustomDataSearch\CollectionFactory as CustomDataCollectionFactory;
use WebVision\CustomDataSearch\Api\Data\CustomDataInterface as CustomData;

class Full extends Indexer
{
    /**
     * @var \WebVision\CustomDataSearch\Model\ResourceModel\CustomDataSearch\CollectionFactory
     */
    private $customDataCollectionFactory;

    /**
     * @var CustomDataHelper
     */
    private $customdatahelper;

    /**
     * @var DateTime
     */
    protected $dateTime;

    /**
     * Constructor.
     *
     * @param ResourceConnection $resource Resource connection.
     * @param StoreManagerInterface $storeManager Store manager.
     * @param MetadataPool $metadataPool Metadata pool.
     * @param CustomDataCollectionFactory $customDataCollectionFactory Page collection factory.
     */
    public function __construct(
        ResourceConnection $resource,
        StoreManagerInterface $storeManager,
        MetadataPool $metadataPool,
        CustomDataCollectionFactory $customDataCollectionFactory,
        CustomDataHelper $customdatahelper,
        DateTime $dateTime
    ) {
        parent::__construct($resource, $storeManager, $metadataPool);
        $this->customDataCollectionFactory = $customDataCollectionFactory;
        $this->customdatahelper = $customdatahelper;
        $this->dateTime = $dateTime;
    }

    /**
     * Load a bulk of Page data.
     *
     * @param int     $storeId     Store id.
     * @param string  $categoryIds Product ids filter.
     * @param int $fromId      Load product with id greater than.
     * @param int $limit       Number of product to get loaded.
     *
     * @return array
     */
    public function getSearchablePages($storeId, $categoryIds = null, $fromId = 0, $limit = 100): array
    {
        $showPagesData = [];

        try {
            /**
             * @var \WebVision\CustomDataSearch\Model\ResourceModel\CustomDataSearch\CollectionFactory $pagesCollection
             */
            $pagesCollection = $this->customDataCollectionFactory->create();
            $pagesCollection->addFieldToSelect([CustomData::TITLE , CustomData::CONTENT, CustomData::STORE_ID, CustomData::SUB_CATEGORIES]);
            $pagesCollection->addFieldToFilter('status', ['in' => [CustomData::SUCCESS_STATUS, CustomData::READY_STATUS]]);
            $pagesCollection->addFieldToFilter('store_id', ['eq' => $storeId]);

            $select = $pagesCollection->getSelect();
            $pagesCollection->getSelect()->where(CustomData::ID . ' > ?', $fromId)->order(CustomData::ID)->query();

            $pageData = $pagesCollection->toArray();

            if (isset($pageData['items'])) {
                foreach ($pageData['items'] as $pageKey => $pageVal) {
                    $showPagesData[] = $pageVal;
                }
            }
        } catch (\Exception $e) {
            throw new InputException(__($e->getMessage()));
        }

        return $showPagesData;
    }
}
