<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomDataSearch\Ui\Component\Listing\Column;

use WebVision\CustomDataSearch\Api\Data\CustomDataInterface;

class CustomDataSearchActions extends \Magento\Ui\Component\Listing\Columns\Column
{
    const URL_EDIT_PATH = 'customdatasearch/index/edit';
    const URL_DELETE_PATH = 'customdatasearch/index/delete';
    const URL_SYNC_PATH = 'customdatasearch/index/sync';

    /**
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;

    /**
     * CustomDataSearchActions constructor.
     *
     * @param \Magento\Framework\UrlInterface $urlBuilder
     * @param \Magento\Framework\View\Element\UiComponent\ContextInterface $context
     * @param \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory
     * @param array $components
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\UrlInterface $urlBuilder,
        \Magento\Framework\View\Element\UiComponent\ContextInterface $context,
        \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory,
        array $components = [],
        array $data = []
    ) {
        $this->urlBuilder = $urlBuilder;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare data source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                if (isset($item[CustomDataInterface::ID])) {
                    $item[$this->getData('name')] = [
                        'edit' => [
                            'href' => $this->urlBuilder->getUrl(
                                static::URL_EDIT_PATH,
                                [
                                    CustomDataInterface::ID => $item[CustomDataInterface::ID]
                                ]
                            ),
                            'label' => __('Show')
                        ],
                        'run' => [
                            'href' => $this->urlBuilder->getUrl(
                                static::URL_SYNC_PATH,
                                [
                                    CustomDataInterface::ID => $item[CustomDataInterface::ID]
                                ]
                            ),
                            'label' => __('Sync')
                        ]
                    ];
                }
            }
        }

        return $dataSource;
    }
}
