<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
declare(strict_types=1);
namespace WebVision\CustomDataSearch\Ui\Component\Listing\Column;

use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\Stdlib\DateTime\TimezoneInterface;
use WebVision\CustomDataSearch\Model\CustomSearcManage;
use WebVision\CustomDataSearch\Api\Data\CustomDataInterface;

class DateTimeUpdate extends Column
{
    /**
     * @var CustomSearcManage
     */
    private $customSearcManage;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        CustomSearcManage $customSearcManage,
        array $components = [],
        array $data = []
    ) {
        $this->customSearcManage = $customSearcManage;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return void
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $name = $this->getData('name');
                if (isset($item[$name])) {
                    $item[$name] = $this->customSearcManage->formateDateWithoutTimeZone(
                        CustomDataInterface::NEW_DATETIME_FORMATE,
                        $item[$name]
                    );
                }
            }
        }

        return $dataSource;
    }
}
