<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomRedirection\Api\Data;

interface CustomRedirectionInterface
{
    /**
     * Constants for keys
     */
    const TABLE_NAME = 'custom_redirection_main';
    const HISTORY_TABLE_NAME = 'custom_redirection_main';

    const ID = 'id';
    const MAIN_ID = 'main_id';
    const STATUS = 'status';
    const STORE_ID = 'store_id';
    const FILE_NAME = 'file_name';
    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';

    const PROCESS_QUEUED = 0;
    const PROCESS_RUNNING = 1;
    const PROCESS_COMPLETED = 2;
    const PROCESS_FAIELD = 3;

    const HISTORY_COMPLETED = 1;
    const HISTORY_FAIELD = 0;

    const DEFAULT_DATETIME_FORMATE = 'Y-m-d H:i:s';
    const NEW_DATETIME_FORMATE = 'l, F j, Y \a\t g:i:s A';
    const HISTORY_DATETIME_FORMATE = 'Y-m-d-H-i-s';

    /**
     * Get Id.
     *
     * @return int
     */
    public function getId();

    /**
     * Set Id.
     *
     * @param mixed $id
     */
    public function setId($id);

    /**
     * Get main Id.
     *
     * @return int
     */
    public function getMainId();

    /**
     * Set main Id.
     *
     * @param mixed $mainId
     */
    public function setMainId($mainId);

    /**
     * Get Status
     *
     * @return varchar
     */
    public function getStatus();

    /**
     * Set Status
     *
     * @param mixed $status
     */
    public function setStatus($status);

    /**
    * Get Store Id.
    *
    * @param mixed $storeId
    *
    * @return varchar
    */
    public function getStoreId($storeId);

    /**
     * Set Store Id
     *
     * @param mixed $storeId
     */
    public function setStoreId($storeId);

    /**
    * Get File Name
    *
    * @param mixed $fileName
    *
    * @return varchar
    */
    public function getFileName($fileName);

    /**
     * Set File Name
     *
     * @param mixed $fileName
     */
    public function setFileName($fileName);

    /**
    * Get Created Date
    *
    * @param mixed $createdAt
    *
    * @return varchar
    */
    public function getCreatedAt($createdAt);

    /**
     * Set Created Date
     *
     * @param mixed $createdAt
     */
    public function setCreatedAt($createdAt);

    /**
    * Get Updated Date
    *
    * @param mixed $updatedAt
    *
    * @return varchar
    */
    public function getUpdatedAt($updatedAt);

    /**
     * Set Updated Date
     *
     * @param mixed $updatedAt
     */
    public function setUpdatedAt($updatedAt);
}
