<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomRedirection\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use WebVision\CustomRedirection\Api\Data\CustomRedirectionInterface;
use WebVision\CustomRedirection\Helper\Data as RedirectionHelper;
use WebVision\CustomRedirection\Model\CustomRedirectionFactory;

class Add extends \Magento\Backend\App\Action
{
    /**
     * @var CustomRedirectionFactory
     */
    protected $customRedirectionModel;

    /**
     * @var RedirectionHelper
     */
    protected $redirectionHelper;

    /**
     * Constructor
     *
     * @param Action\Context $context
     * @param CustomRedirectionFactory $customRedirectionModel
     * @param RedirectionHelper $redirectionHelper
     */
    public function __construct(
        Action\Context $context,
        CustomRedirectionFactory $customRedirectionModel,
        RedirectionHelper $redirectionHelper
    ) {
        parent::__construct($context);
        $this->customRedirectionModel = $customRedirectionModel;
        $this->redirectionHelper = $redirectionHelper;
    }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $customRedirectionModel = $this->customRedirectionModel->create();
        $customRedirectionCollection = $this->customRedirectionModel->create()->getCollection();
        $customRedirectionCollection->addFieldToFilter(
            CustomRedirectionInterface::STATUS,
            [
                'in' => [
                    CustomRedirectionInterface::PROCESS_QUEUED,
                    CustomRedirectionInterface::PROCESS_RUNNING,
                    ],
                ]
        );
        // Check Existing process
        if ($customRedirectionCollection->getSize()) {
            $this->messageManager->addWarning(__('Please wait for the current process to finish before adding a new custom redirection.'));

            return $resultRedirect->setPath('*/*/');
        }

        try {
            // Check process file is exist or not
            $filePath = $this->redirectionHelper->getFilePath();
            $fileDiver = $this->redirectionHelper->getFileDriver();
            if (!$fileDiver->isExists($filePath)) {
                $this->messageManager->addWarning(__('Please add the mentioned file in the correct location. Right now, it does not exist at the specified path: ' . $filePath));

                return $resultRedirect->setPath('*/*/');
            }

            // Add new file for custom redirection
            $fileName = $this->redirectionHelper->getFileName();
            $customRedirectionModel->setData(
                [
                    CustomRedirectionInterface::STATUS => CustomRedirectionInterface::PROCESS_QUEUED,
                    CustomRedirectionInterface::FILE_NAME => $fileName,
                ]
            );
            $customRedirectionModel->save();

            // Publish Custom Redirection to Message queue
            $this->redirectionHelper->publish($filePath, $customRedirectionModel->getId());

            $this->messageManager->addSuccess(__('The custom redirection file is added to the queue and will be processed soon.'));
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            $this->messageManager->addError($e->getMessage());
        } catch (\RuntimeException $e) {
            $this->messageManager->addError($e->getMessage());
        } catch (\Exception $e) {
            $this->messageManager->addException($e, __('Something went wrong while saving the data.'));
        }

        return $resultRedirect->setPath('*/*/');
    }
}
