<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomRedirection\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use WebVision\CustomRedirection\Helper\Data as RedirectionHelper;

class Reset extends \Magento\Backend\App\Action
{
    /**
     * @var RedirectionHelper
     */
    protected $redirectionHelper;

    /**
     * Constructor
     *
     * @param Action\Context $context
     * @param RedirectionHelper $redirectionHelper
     */
    public function __construct(
        Action\Context $context,
        RedirectionHelper $redirectionHelper
    ) {
        parent::__construct($context);
        $this->redirectionHelper = $redirectionHelper;
    }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();

        try {
            // Check process file is exist or not
            $this->redirectionHelper->deleteAll();
            $this->messageManager->addSuccess(__('All lock files have been removed.'));
        } catch (\Exception $e) {
            $this->messageManager->addException($e, __('Something went wrong while removing the data.'));
        }

        return $resultRedirect->setPath('*/*/');
    }
}
