<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomRedirection\Model;

use Magento\Framework\Model\AbstractModel;
use WebVision\CustomRedirection\Model\ResourceModel\RedirectionHistory as RedirectionHistoryResourceModel;

class RedirectionHistory extends AbstractModel
{
    const CACHE_TAG = 'webvision_custom_redirection_history_model';

    /**
     * Entity code.
     * Can be used as part of method name for entity processing
     */
    public const ENTITY = 'custom_redirection_history';

    /**
     * @var string
     */
    protected $_eventPrefix = 'custom_redirection_history';

    /**
     * @var string
     */
    protected $_eventObject = 'customredirection_history';

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init(RedirectionHistoryResourceModel::class);
    }
}
