# Custom Redirection via Custom Module using Message Queue

## Overview
This Magento module allows users to add custom redirections via a CSV file. Users can specify the CSV file path and manage the redirections using a dedicated user interface.

## CSV File Location
Users should place the CSV file at the following path:
```
var/import/redirection/RedirectUrls.csv
```
By default, the module uses `RedirectUrls.csv` as the filename. However, users can change the filename via the store configuration settings.

Your CSV file format uses a semicolon (`;`) as a delimiter. Based on this, here’s the correct sample format for your **Custom Redirection** module:

```
old_url;new_url;store_id
product-old-url.html;product-new-url.html;2
product-old-url.html;product-new-url.html;1
```

### Explanation of Columns:
- **old_url**: The original URL that needs to be redirected.
- **new_url**: The destination URL where the user should be redirected.
- **store_id**: The store view ID where the redirection applies.

### Important Notes:
- Ensure the file is **semicolon-separated (`;`)**, not comma-separated.
- Save the file in **UTF-8 encoding** to prevent special character issues.
- The **store_id** should match the Magento store view where the redirection is needed.

## User Interface
Once the CSV file is added and the module configuration is set up, users can manage the redirections via:
```
Marketing -> Web-Vision Custom Redirection -> Custom Redirection Manager
```

### Available Actions:
1. **Remove Lock File** - If a lock file exists, users can remove it using this button or manually.
2. **Add New** - Clicking this button will upload the specified CSV file to the message queue. Once the operation is completed, users can view the status by clicking the "Show" link on the grid. The history will display details on successfully created custom redirections and any failed entries.

## Store Configuration
The module settings can be configured via:
```
Stores -> Configuration -> Web Vision -> Custom Redirection -> General Configuration
```
### Configuration Options:
- **Module Enable** - Enable or disable the module functionality.
- **File Name** - Specify the filename for processing.
- **Batch Count** - Define the batch size to split the main CSV file into smaller parts for faster processing.

## Logging
The module maintains a separate log file named `CustomRedirection.log`, which can be used for debugging.

## Checking the Consumer Cron
To verify the consumer cron process, run the following command:
```
ps aux | grep webvision_custom_redirection.process
```

## Conclusion
This module simplifies the management of custom redirections using Magento's message queue system. Ensure that the CSV file is correctly formatted and placed in the specified directory before processing.
