<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomRedirection\Ui\Component\Listing\Column;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use WebVision\CustomRedirection\Api\Data\CustomRedirectionInterface;
use WebVision\CustomRedirection\Helper\Data as RedirectionHelper;

class DateTimeUpdate extends Column
{
    /**
     * @var CustomSearcManage
     */
    private $redirectionHelper;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        RedirectionHelper $redirectionHelper,
        array $components = [],
        array $data = []
    ) {
        $this->redirectionHelper = $redirectionHelper;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return void
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $name = $this->getData('name');
                if (isset($item[$name])) {
                    $item[$name] = $this->redirectionHelper->formateDateWithoutTimeZone(
                        CustomRedirectionInterface::NEW_DATETIME_FORMATE,
                        $item[$name]
                    );
                }
            }
        }

        return $dataSource;
    }
}
