<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\CustomRedirection\Ui\Component\Listing\Column;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\UrlInterface;
use WebVision\CustomRedirection\Helper\Data;
use Magento\Store\Model\StoreManagerInterface;

class DownloadFile extends Column
{
    /**
     * @var Data
     */
    protected $redirectionHelper;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        Data $redirectionHelper,
        StoreManagerInterface $storeManager,
        array $components = [],
        array $data = []
    ) {
        $this->redirectionHelper = $redirectionHelper;
        $this->storeManager = $storeManager;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    public function prepareDataSource(array $dataSource): array
    {
        if (empty($dataSource['data']['items'])) {
            return $dataSource; // Early return to avoid unnecessary processing
        }
    
        $name = $this->getData('name'); // Fetch only once to avoid redundant calls
        $fileDriver = $this->redirectionHelper->getFileDriver(); // Fetch once
        $mediaBaseUrl = $this->storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_MEDIA) . 'CustomRedirection/';
    
        foreach ($dataSource['data']['items'] as &$item) {
            if (!isset($item[$name])) {
                continue; // Skip iteration if key is missing
            }
    
            $filename = "{$item['id']}-{$item[$name]}";
            $filePath = $this->redirectionHelper->getMediaPath($filename);
    
            if ($fileDriver->isExists($filePath)) {
                $mediaUrl = $mediaBaseUrl . $filename;
                $item[$name] = "<a href=\"{$mediaUrl}\">" . htmlspecialchars_decode($item[$name]) . "</a>";
            }
        }
    
        return $dataSource;
    }
}