<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\LayoutRender\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;

class Data extends AbstractHelper
{
    public const LAYOUT_RENDER_STATUS = 'webvision_unity/layout_render/enabled';

    public const CATEGORY_PRODUCTS_LAYOUT_NAME = 'webvision_unity/layout_render/category_products';

    public const PRODUCT_LINES_LAYOUT_NAME = 'webvision_unity/layout_render/product_lines';

    public const CONTACT_SECTION_LAYOUT_NAME = 'webvision_unity/layout_render/contact_section';

    public const BREADCRUMBS_LAYOUT_NAME = 'webvision_unity/layout_render/breadcrumbs';

    public const PRODUCT_CATEGORIES_LAYOUT_NAME = 'webvision_unity/layout_render/product_categories';

    /**
     * @var ScopeConfigInterface
     */
    public $scopeConfig;

    /**
     * @param Context $context
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
        parent::__construct($context);
    }

    /**
     * Get layout render status
     *
     * @return string
     */
    public function getLayoutRenderStatus()
    {
        return $this->scopeConfig->getValue(self::LAYOUT_RENDER_STATUS);
    }

    /**
     * Get category product layout name
     *
     * @return string
     */
    public function getCategoryProductLayout()
    {
        return $this->scopeConfig->getValue(self::CATEGORY_PRODUCTS_LAYOUT_NAME);
    }

    /**
     * Get product lines layout name
     *
     * @return string
     */
    public function getProductLinesLayout()
    {
        return $this->scopeConfig->getValue(self::PRODUCT_LINES_LAYOUT_NAME);
    }

    /**
     * Get product categories layout name
     *
     * @return string
     */
    public function getProductCategoriesLayout()
    {
        return $this->scopeConfig->getValue(self::PRODUCT_CATEGORIES_LAYOUT_NAME);
    }

    /**
     * Get contact section layout name
     *
     * @return string
     */
    public function getContactSectionLayout()
    {
        return $this->scopeConfig->getValue(self::CONTACT_SECTION_LAYOUT_NAME);
    }

    /**
     * Get breadcrumbs layout name
     *
     * @return string
     */
    public function getBreadcrumbsLayout()
    {
        return $this->scopeConfig->getValue(self::BREADCRUMBS_LAYOUT_NAME);
    }
}
