<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2024 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\LayoutRender\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use WebVision\LayoutRender\Helper\Data;

class UpdateLayoutObserver implements ObserverInterface
{
    /**
     * @var Data
     */
    protected $layoutRenderHelper;

    /**
     * @param Data $layoutRenderHelper
     */
    public function __construct(
        Data $layoutRenderHelper
    ) {
        $this->layoutRenderHelper = $layoutRenderHelper;
    }

    /**
     * Execute.
     *
     * @param Observer $observer
     *
     * @return $this
     */
    public function execute(Observer $observer)
    {
        $layout = $observer->getData('layout');
        $layoutRenderStatus = $this->layoutRenderHelper->getLayoutRenderStatus();
        if (($observer->getFullActionName() == "catalog_category_view") && ($layoutRenderStatus)) {
            $layout->getUpdate()->addHandle('typo3_category');
        }

        return $this;
    }
}