<?php
namespace WebVision\SocialLinks\ViewModel;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class Social implements ArgumentInterface
{
    /**
     * Social links path
     */
    const XML_PATH_SOCIAL_PATH = 'social/links/';

    /**
     * Copyright links path
     */
    const XML_COPYRIGHT_PATH = 'social/copyrightlinks/';

    public function __construct(
        protected ScopeConfigInterface $scopeConfig,
        array $data = []
    ) {
    }

    public function getLinks($social)
    {
        $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;

        return $this->scopeConfig->getValue(self::XML_PATH_SOCIAL_PATH . $social, $storeScope);
    }

    public function getCopyrightLinks($fieldLink)
    {
        $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;

        return $this->scopeConfig->getValue(self::XML_COPYRIGHT_PATH . $fieldLink, $storeScope);
    }
}
