<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\UnityElasticSearch\Block\Adminhtml\System\Config;

use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\DataObject;
use WebVision\UnityElasticSearch\Block\Adminhtml\System\Config\Field\ConditionList;

class DynamicFieldData extends AbstractFieldArray
{
    /**
     * @var ConditionList
     */
    private $showConditionRenderer;

    /**
     * @inheritdoc
     */
    protected function _prepareToRender()
    {
        $this->addColumn(
            'attr_code',
            [
                'label' => __('Field Name'),
                'class' => 'required-entry',
                'style' => 'width:300px',
            ]
        );

        $this->addColumn(
            'attr_condition',
            [
                'label' => __('Condition'),
                'renderer' => $this->getConditionList(),
                'name' => 'show_label',
                'class' => 'attr_condition_options',
                'style' => 'width:300px',
            ]
        );

        $this->addColumn(
            'attr_val',
            [
                'label' => __('Filter Value'),
                'class' => 'required-entry',
                'style' => 'width:300px',
            ]
        );

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add More Filter');
    }

    /**
     * @inheritdoc
     */
    protected function _prepareArrayRow(DataObject $row)
    {
        $options = [];
        $countryList = $row->getAttrCondition();
        if ($countryList !== null) {
            $options['option_' . $this->getConditionList()->calcOptionHash($countryList)] = 'selected="selected"';
        }
        $row->setData('option_extra_attrs', $options);
    }

    /**
     * Get condition list
     *
     * @return array
     */
    private function getConditionList()
    {
        if (!$this->showConditionRenderer) {
            $this->showConditionRenderer = $this->getLayout()->createBlock(
                ConditionList::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }

        return $this->showConditionRenderer;
    }
}
