<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\UnityElasticSearch\Block\Adminhtml\System\Config\Field;

use Magento\Framework\View\Element\Html\Select;

class ConditionList extends Select
{
    /**
     * Set input name
     *
     * @param string $value
     *
     * @return string
     */
    public function setInputName($value)
    {
        return $this->setName($value);
    }

    /**
     * Set input id
     *
     * @param string $value
     *
     * @return string
     */
    public function setInputId($value)
    {
        return $this->setId($value);
    }

    /**
     * @inheritdoc
     */
    public function _toHtml()
    {
        if (!$this->getOptions()) {
            $this->setOptions($this->getSourceOptions());
        }

        return parent::_toHtml();
    }

    /**
     * get source options data`
     *
     * @return array
     */
    private function getSourceOptions()
    {
        return [
            ['label' => 'EQUAL TO (=)', 'value' => 'eq'],
            ['label' => 'NOT EQUAL TO (!=)', 'value' => 'neq'],
        ];
    }
}
