<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\UnityElasticSearch\Block;

use Magento\Framework\View\Element\Template;

class SearchableCategories extends Template
{
    /**
     * @var \Smile\ElasticsuiteCatalog\Model\Autocomplete\Category\DataProvider
     */
    protected $searchableCategory;

    /**
     * @var \WebVision\UnityElasticSearch\Helper\Data
     */
    protected $typo3Helper;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Smile\ElasticsuiteCatalog\Model\Autocomplete\Category\DataProvider $searchableCategory
     * @param \WebVision\UnityElasticSearch\Helper\Data $typo3Helper
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Smile\ElasticsuiteCatalog\Model\Autocomplete\Category\DataProvider $searchableCategory,
        \WebVision\UnityElasticSearch\Helper\Data $typo3Helper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->searchableCategory = $searchableCategory;
        $this->typo3Helper = $typo3Helper;
    }

    /**
     * Get typo3 data collection
     *
     * @return \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\DataProvider
     */
    public function getSearchableCategories()
    {
        $categoryColl = null;
        $typo3Status = $this->typo3Helper->getTypo3SearchStatus();
        $showcategoryStatus = $this->typo3Helper->getSeachableCategoryStatus();

        if (($typo3Status) && ($showcategoryStatus)) {
            $categoryColl = $this->searchableCategory->getItems();
        }

        return $categoryColl;
    }

    public function getTypo3Helper()
    {
        return $this->typo3Helper;
    }
}
