<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\UnityElasticSearch\Block;

class Typo3AllPages extends Typo3Pages
{
    public const PAGES_MINIMUM_PAGE_SHOW = 5;

    /**
     * @var \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\DataProvider
     */
    protected $itemFactory;

    /**
     * @var \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\ItemFactory
     */
    protected $typo3Pages;

    /**
     * @var \WebVision\UnityElasticSearch\Helper\Data
     */
    protected $typo3Helper;

    /**
     * @var \Magento\CatalogSearch\Block\Result
     */
    protected $searchPageResult;

    /**
     * @var \WebVision\UnityElasticSearch\Model\PagesFactory
     */
    protected $typo3PagesFactory;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\DataProvider $typo3Pages
     * @param \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\ItemFactory $itemFactory
     * @param \WebVision\UnityElasticSearch\Helper\Data $typo3Helper
     * @param \Magento\CatalogSearch\Block\Result $searchPageResult
     * @param \WebVision\UnityElasticSearch\Model\PagesFactory $typo3PagesFactory
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\DataProvider $typo3Pages,
        \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\ItemFactory $itemFactory,
        \WebVision\UnityElasticSearch\Helper\Data $typo3Helper,
        \Magento\CatalogSearch\Block\Result $searchPageResult,
        \WebVision\UnityElasticSearch\Model\PagesFactory $typo3PagesFactory,
        array $data = []
    ) {
        $this->typo3Pages = $typo3Pages;
        $this->itemFactory = $itemFactory;
        $this->typo3Helper = $typo3Helper;
        $this->searchPageResult = $searchPageResult;
        $this->typo3PagesFactory = $typo3PagesFactory;
        parent::__construct(
            $context,
            $typo3Pages,
            $itemFactory,
            $typo3Helper,
            $searchPageResult,
            $data
        );
    }

    /**
     * @inheritDoc
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        $page_size = $this->getPagerCount();
        $page_data = $this->getAllPageData();
        if ($this->getAllPageData()) {
            $pager = $this->getLayout()->createBlock(
                \Magento\Theme\Block\Html\Pager::class,
                'typo3.page.pager'
            )
                ->setAvailableLimit($page_size)
                ->setPageVarName('tp')
                ->setShowPerPage(true)
                ->setCollection($page_data);
            $this->setChild('pager', $pager);
            $this->getAllPageData()->load();
        }

        return $this;
    }

    /**
     * get pager html
     *
     * @return string
     */
    public function getPagerHtml()
    {
        return $this->getChildHtml('pager');
    }

    /**
     * get all pages data
     *
     * @return object
     */
    public function getAllPageData()
    {
        // get param values
        $page = ($this->getRequest()->getParam('tp')) ? $this->getRequest()->getParam('tp') : 1;
        $pageSize = ($this->getRequest()->getParam('limit')) ? $this->getRequest()->getParam('limit') : self::PAGES_MINIMUM_PAGE_SHOW;

        // get typo3 page collection
        $primaryKey = $this->typo3Helper->getTypo3PrimaryKey();
        $dataIds = $this->getTypo3Collection(false)->getColumnValues($primaryKey);
        $collection = $this->typo3PagesFactory->create()->getCollection();
        $collection->addFieldToFilter($primaryKey, ['in' => $dataIds ]);
        $collection->setPageSize($pageSize);
        $collection->setCurPage($page);
        // Set Score value based sorting of result
        $fieldList = implode(',', array_map(function ($id) {
            return is_numeric($id) ? (int)$id : "'" . addslashes($id) . "'";
        }, $dataIds));
        $fieldOrder = "FIELD(`main_table`.`uid`, $fieldList)";
        $collection->getSelect()->order($fieldOrder);

        return $collection;
    }

    /**
     * get per page dynamic count
     *
     * @return object
     */
    public function getPagerCount()
    {
        $minimumShow = self::PAGES_MINIMUM_PAGE_SHOW;
        $pageArray = [];
        if($listData = $this->getTypo3Collection()) {
            $listCount = ceil(count($listData->getData()));
            $showCount = $minimumShow + 1;
            if (count($listData->getData()) >= $showCount) {
                $listCount = $listCount / $minimumShow;
                $pageNumber = $total = $minimumShow;
                $pageArray[$minimumShow] = $minimumShow;
                for ($x = 0; $x <= $listCount; $x++) {
                    $total = $total + $pageNumber;
                    $pageArray[$total] = $total;
                }
            } else {
                $pageArray[$minimumShow] = $minimumShow;
                $minimumShow = $minimumShow + $minimumShow;
                $pageArray[$minimumShow] = $minimumShow;
            }
        }

        return $pageArray;
    }

    /**
     * Undocumented function
     *
     * @return string
     */
    public function getPageLimit() {
        $limit = $this->getRequest()->getParam('limit') ?? self::PAGES_MINIMUM_PAGE_SHOW;
        $page = $this->getRequest()->getParam('tp') ?? 0;
        $pageLimit = ($page ? $limit * $page - $limit : 0) + 1;

        return $pageLimit;
    }
}