<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\UnityElasticSearch\Block;

use Magento\Framework\View\Element\Template;

class Typo3Pages extends Template
{
    /**
     * @var \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\DataProvider
     */
    protected $itemFactory;

    /**
     * @var \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\ItemFactory
     */
    protected $typo3Pages;

    /**
     * @var \WebVision\UnityElasticSearch\Helper\Data
     */
    protected $typo3Helper;

    /**
     * @var \Magento\CatalogSearch\Block\Result
     */
    protected $searchPageResult;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\DataProvider $typo3Pages
     * @param \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\ItemFactory $itemFactory
     * @param \WebVision\UnityElasticSearch\Helper\Data $typo3Helper
     * @param \Magento\CatalogSearch\Block\Result $searchPageResult
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\DataProvider $typo3Pages,
        \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\ItemFactory $itemFactory,
        \WebVision\UnityElasticSearch\Helper\Data $typo3Helper,
        \Magento\CatalogSearch\Block\Result $searchPageResult,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->typo3Pages = $typo3Pages;
        $this->itemFactory = $itemFactory;
        $this->typo3Helper = $typo3Helper;
        $this->searchPageResult = $searchPageResult;
    }

    /**
     * Get typo3 data collection
     *
     * @param bool $size
     *
     * @return \WebVision\UnityElasticSearch\Model\Autocomplete\Typo3\DataProvider
     */
    public function getTypo3Collection($size = true)
    {
        $typo3Coll = null;
        $typo3Status = $this->typo3Helper->getTypo3SearchStatus();
        $typo3SearchPageStatus = $this->typo3Helper->getTypo3SearchPageStatus();

        if (($typo3Status) && ($typo3SearchPageStatus)) {
            $typo3Coll = $this->typo3Pages->getTypo3Collection($size);
        }

        return $typo3Coll;
    }

    /**
     * Get typo3 page url
     *
     * @param mixed $url
     *
     * @return string
     */
    public function getPageUrl($url)
    {
        return $this->itemFactory->getPageUrl($url);
    }

    /**
     * Get typo3 helper class
     *
     * @return \WebVision\UnityElasticSearch\Helper\Data
     */
    public function getTypo3Helper()
    {
        return $this->typo3Helper;
    }

    /**
     * Get product result count value
     *
     * @return string
     */
    public function getSearchPageProductCount()
    {
        return $this->searchPageResult->getResultCount();
    }
}
