<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\UnityElasticSearch\Model\Autocomplete\Typo3;

use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\UrlInterface;
use WebVision\UnityElasticSearch\Helper\Data;

class ItemFactory extends \Magento\Search\Model\Autocomplete\ItemFactory
{
    /**
     * @var UrlInterfacee
     */
    private $urlBuilder;

    /**
     * @var Data
     */
    private $typo3Helper;

    /**
     * ItemFactory constructor.
     *
     * @param ObjectManagerInterface $objectManager    The Object Manager
     * @param UrlInterface           $urlBuilder       The Url Builder
     */
    public function __construct(
        ObjectManagerInterface $objectManager,
        UrlInterface $urlBuilder,
        Data $typo3Helper
    ) {
        parent::__construct($objectManager);
        $this->urlBuilder = $urlBuilder;
        $this->typo3Helper = $typo3Helper;
    }

    /**
     * {@inheritDoc}
     */
    public function create(array $data)
    {
        $data = $this->addCategoryData($data);
        unset($data['typo3']);

        return parent::create($data);
    }

    /**
     * Load typo3 Pages data and append them to the original data.
     *
     * @param array $data Autocomplete item data.
     *
     * @return array
     */
    private function addCategoryData($data)
    {
        $typo3Data = $data['typo3'];
        $title = $typo3Data->getData($this->typo3Helper->getTypo3TitleColumn()) ?? '';

        $categoryData = [
            'title' => $title,
            'url' => $this->getPageUrl($typo3Data->getData($this->typo3Helper->getTypo3UrlColumn())),
        ];

        $data = array_merge($data, $categoryData);

        return $data;
    }

    /**
     * Retrieve typo3 page Url
     *
     * @param string $slug
     *
     * @return string
     */
    public function getPageUrl($slug)
    {
        $slug = ltrim($slug ?? '', '/');
        $slug = $this->urlBuilder->getDirectUrl($slug ?? '');
        $slug .= $this->typo3Helper->getCategoryUrlSuffix();

        return $slug;
    }
}
