<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\UnityElasticSearch\Model\Indexer\Fulltext\Action;

use WebVision\UnityElasticSearch\Helper\Data;
use WebVision\UnityElasticSearch\Model\ResourceModel\Typo3\Indexer\Fulltext\Action\Full as ResourceModel;

class Full
{
    /**
     * @var ResourceModel
     */
    private $resourceModel;

    /**
     * @var Data
     */
    private $typo3Helper;

    /**
     * Constructor.
     *
     * @param ResourceModel $resourceModel Indexer resource model.
     */
    public function __construct(
        ResourceModel $resourceModel,
        Data $typo3Helper
    ) {
        $this->resourceModel = $resourceModel;
        $this->typo3Helper = $typo3Helper;
    }

    /**
     * Get data for a list of pages in a store id.
     * If the product list ids is null, all pages data will be loaded.
     *
     * @param int    $storeId     Store id.
     * @param array|null $pageIds List of category ids.
     *
     * @return \Traversable
     */
    public function rebuildStoreIndex($storeId, $pageIds = null)
    {
        if ($this->typo3Helper->getTypo3SearchStatus()) {
            $lastpageId = 0;
            $primaryKey = $this->typo3Helper->getTypo3PrimaryKey();
            $pages = $this->getSearchablePages($storeId, $pageIds, $lastpageId);
            foreach ($pages as $pagesData) {
                if (isset($pagesData[$primaryKey])) {
                    $lastpageId = (int) $pagesData[$primaryKey];
                    yield $lastpageId => $pagesData;
                }
            }
        }
    }

    /**
     * Load a bulk of page data.
     *
     * @param int     $storeId     Store id.
     * @param string  $pageIds     Pages ids filter.
     * @param int $fromId      Load product with id greater than.
     * @param int $limit       Number of product to get loaded.
     *
     * @return array
     */
    private function getSearchablePages($storeId, $pageIds = null, $fromId = 0, $limit = 100)
    {
        return $this->resourceModel->getSearchablePages($storeId, $pageIds, $fromId, $limit);
    }
}
