<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    WebVision
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace WebVision\UnityElasticSearch\Model\ResourceModel;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class Pages extends AbstractDb
{
    /**
     * @var string
     */
    public $connectionName = 'default';

    /**
     * @var \WebVision\UnityElasticSearch\Helper\Data
     */
    public $typo3helper;

    /**
     * @var string
     */
    public $typo3PrimaryKey;

    /**
     * @var string
     */
    public $typo3TableName;

    /**
     * Constructor
     *
     * @param \Magento\Framework\Model\ResourceModel\Db\Context $context
     * @param string $connectionName
     */
    public function __construct(
        \Magento\Framework\Model\ResourceModel\Db\Context $context,
        \WebVision\UnityElasticSearch\Helper\Data $typo3helper,
        $connectionName = null
    ) {
        $this->transactionManager = $context->getTransactionManager();
        $this->_resources = $context->getResources();
        $this->objectRelationProcessor = $context->getObjectRelationProcessor();

        $this->typo3helper = $typo3helper;
        $this->connectionName = $this->typo3helper->getTypo3ConnectionName();
        $this->typo3PrimaryKey = $this->typo3helper->getTypo3PrimaryKey();
        $this->typo3TableName = $this->typo3helper->getTypo3TableName();
        if ($connectionName !== null) {
            $this->connectionName = $connectionName;
        }

        parent::__construct($context, $connectionName);
    }

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init($this->typo3TableName, $this->typo3PrimaryKey);
    }

    /**
     * Get connection
     *
     * @return \Magento\Framework\DB\Adapter\AdapterInterface|false
     */
    public function getConnection()
    {
        $fullResourceName = ($this->connectionName ? $this->connectionName : ResourceConnection::DEFAULT_CONNECTION);

        return $this->_resources->getConnection($fullResourceName);
    }

    /**
     * Get real table name for db table, validated by db adapter
     *
     * @param string $tableName
     *
     * @return string
     */
    public function getTable($tableName)
    {
        if (is_array($tableName)) {
            $cacheName = join('@', $tableName);
            list($tableName, $entitySuffix) = $tableName;
        } else {
            $cacheName = $tableName;
            $entitySuffix = null;
        }

        if ($entitySuffix !== null) {
            $tableName .= '_' . $entitySuffix;
        }

        if (!isset($this->_tables[$cacheName])) {
            $connectionName = $this->connectionName;
            $this->_tables[$cacheName] = $this->_resources->getTableName($tableName, $connectionName);
        }

        return $this->_tables[$cacheName];
    }
}
