"use strict";var e,o,a=require("@csstools/css-tokenizer"),n=require("@csstools/color-helpers"),t=require("@csstools/css-parser-algorithms"),r=require("@csstools/css-calc");function colorData_to_XYZ_D50(e){switch(e.colorNotation){case exports.ColorNotation.HEX:case exports.ColorNotation.RGB:case exports.ColorNotation.sRGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.sRGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Linear_sRGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.lin_sRGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Display_P3:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.P3_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Rec2020:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.rec_2020_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.A98_RGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.a98_RGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.ProPhoto_RGB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.ProPhoto_RGB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.HSL:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.HSL_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.HWB:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.HWB_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.Lab:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.Lab_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.OKLab:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.OKLab_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.LCH:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.LCH_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.OKLCH:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.OKLCH_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.XYZ_D50:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.XYZ_D50_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};case exports.ColorNotation.XYZ_D65:return{...e,colorNotation:exports.ColorNotation.XYZ_D50,channels:n.XYZ_D65_to_XYZ_D50(e.channels.map((e=>Number.isNaN(e)?0:e)))};default:throw new Error("Unsupported color notation")}}exports.ColorNotation=void 0,(e=exports.ColorNotation||(exports.ColorNotation={})).A98_RGB="a98-rgb",e.Display_P3="display-p3",e.HEX="hex",e.HSL="hsl",e.HWB="hwb",e.LCH="lch",e.Lab="lab",e.Linear_sRGB="srgb-linear",e.OKLCH="oklch",e.OKLab="oklab",e.ProPhoto_RGB="prophoto-rgb",e.RGB="rgb",e.sRGB="srgb",e.Rec2020="rec2020",e.XYZ_D50="xyz-d50",e.XYZ_D65="xyz-d65",exports.SyntaxFlag=void 0,(o=exports.SyntaxFlag||(exports.SyntaxFlag={})).ColorKeyword="color-keyword",o.HasAlpha="has-alpha",o.HasDimensionValues="has-dimension-values",o.HasNoneKeywords="has-none-keywords",o.HasNumberValues="has-number-values",o.HasPercentageAlpha="has-percentage-alpha",o.HasPercentageValues="has-percentage-values",o.HasVariableAlpha="has-variable-alpha",o.Hex="hex",o.LegacyHSL="legacy-hsl",o.LegacyRGB="legacy-rgb",o.NamedColor="named-color",o.RelativeColorSyntax="relative-color-syntax",o.ColorMix="color-mix",o.Experimental="experimental";const l=new Set([exports.ColorNotation.A98_RGB,exports.ColorNotation.Display_P3,exports.ColorNotation.HEX,exports.ColorNotation.Linear_sRGB,exports.ColorNotation.ProPhoto_RGB,exports.ColorNotation.RGB,exports.ColorNotation.sRGB,exports.ColorNotation.Rec2020,exports.ColorNotation.XYZ_D50,exports.ColorNotation.XYZ_D65]);function colorDataTo(e,o){const a={...e};if(e.colorNotation!==o){const e=colorData_to_XYZ_D50(a);switch(o){case exports.ColorNotation.HEX:case exports.ColorNotation.RGB:a.colorNotation=exports.ColorNotation.RGB,a.channels=n.XYZ_D50_to_sRGB(e.channels);break;case exports.ColorNotation.sRGB:a.colorNotation=exports.ColorNotation.sRGB,a.channels=n.XYZ_D50_to_sRGB(e.channels);break;case exports.ColorNotation.Linear_sRGB:a.colorNotation=exports.ColorNotation.Linear_sRGB,a.channels=n.XYZ_D50_to_lin_sRGB(e.channels);break;case exports.ColorNotation.Display_P3:a.colorNotation=exports.ColorNotation.Display_P3,a.channels=n.XYZ_D50_to_P3(e.channels);break;case exports.ColorNotation.Rec2020:a.colorNotation=exports.ColorNotation.Rec2020,a.channels=n.XYZ_D50_to_rec_2020(e.channels);break;case exports.ColorNotation.ProPhoto_RGB:a.colorNotation=exports.ColorNotation.ProPhoto_RGB,a.channels=n.XYZ_D50_to_ProPhoto(e.channels);break;case exports.ColorNotation.A98_RGB:a.colorNotation=exports.ColorNotation.A98_RGB,a.channels=n.XYZ_D50_to_a98_RGB(e.channels);break;case exports.ColorNotation.HSL:a.colorNotation=exports.ColorNotation.HSL,a.channels=n.XYZ_D50_to_HSL(e.channels);break;case exports.ColorNotation.HWB:a.colorNotation=exports.ColorNotation.HWB,a.channels=n.XYZ_D50_to_HWB(e.channels);break;case exports.ColorNotation.Lab:a.colorNotation=exports.ColorNotation.Lab,a.channels=n.XYZ_D50_to_Lab(e.channels);break;case exports.ColorNotation.LCH:a.colorNotation=exports.ColorNotation.LCH,a.channels=n.XYZ_D50_to_LCH(e.channels);break;case exports.ColorNotation.OKLCH:a.colorNotation=exports.ColorNotation.OKLCH,a.channels=n.XYZ_D50_to_OKLCH(e.channels);break;case exports.ColorNotation.OKLab:a.colorNotation=exports.ColorNotation.OKLab,a.channels=n.XYZ_D50_to_OKLab(e.channels);break;case exports.ColorNotation.XYZ_D50:a.colorNotation=exports.ColorNotation.XYZ_D50,a.channels=n.XYZ_D50_to_XYZ_D50(e.channels);break;case exports.ColorNotation.XYZ_D65:a.colorNotation=exports.ColorNotation.XYZ_D65,a.channels=n.XYZ_D50_to_XYZ_D65(e.channels);break;default:throw new Error("Unsupported color notation")}}else a.channels=e.channels.map((e=>Number.isNaN(e)?0:e));if(o===e.colorNotation)a.channels=carryForwardMissingComponents(e.channels,[0,1,2],a.channels,[0,1,2]);else if(l.has(o)&&l.has(e.colorNotation))a.channels=carryForwardMissingComponents(e.channels,[0,1,2],a.channels,[0,1,2]);else switch(o){case exports.ColorNotation.HSL:switch(e.colorNotation){case exports.ColorNotation.HWB:a.channels=carryForwardMissingComponents(e.channels,[0],a.channels,[0]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:a.channels=carryForwardMissingComponents(e.channels,[2],a.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:a.channels=carryForwardMissingComponents(e.channels,[0,1,2],a.channels,[2,1,0])}break;case exports.ColorNotation.HWB:switch(e.colorNotation){case exports.ColorNotation.HSL:a.channels=carryForwardMissingComponents(e.channels,[0],a.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:a.channels=carryForwardMissingComponents(e.channels,[0],a.channels,[2])}break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:switch(e.colorNotation){case exports.ColorNotation.HSL:a.channels=carryForwardMissingComponents(e.channels,[0],a.channels,[2]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:a.channels=carryForwardMissingComponents(e.channels,[0,1,2],a.channels,[0,1,2]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:a.channels=carryForwardMissingComponents(e.channels,[0],a.channels,[0])}break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:switch(e.colorNotation){case exports.ColorNotation.HSL:a.channels=carryForwardMissingComponents(e.channels,[0,1,2],a.channels,[2,1,0]);break;case exports.ColorNotation.HWB:a.channels=carryForwardMissingComponents(e.channels,[0],a.channels,[2]);break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:a.channels=carryForwardMissingComponents(e.channels,[0],a.channels,[0]);break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:a.channels=carryForwardMissingComponents(e.channels,[0,1,2],a.channels,[0,1,2])}}return a.channels=convertPowerlessComponentsToMissingComponents(a.channels,o),a}function convertPowerlessComponentsToMissingComponents(e,o){const a=[...e];switch(o){case exports.ColorNotation.HSL:reducePrecision(a[1],4)<=0&&(a[0]=NaN);break;case exports.ColorNotation.HWB:Math.max(0,reducePrecision(a[1],4))+Math.max(0,reducePrecision(a[2],4))>=100&&(a[0]=NaN);break;case exports.ColorNotation.LCH:reducePrecision(a[1],4)<=0&&(a[2]=NaN);break;case exports.ColorNotation.OKLCH:reducePrecision(a[1],6)<=0&&(a[2]=NaN)}return a}function convertPowerlessComponentsToZeroValuesForDisplay(e,o){const a=[...e];switch(o){case exports.ColorNotation.HSL:(reducePrecision(a[2])<=0||reducePrecision(a[2])>=100)&&(a[0]=NaN,a[1]=NaN),reducePrecision(a[1])<=0&&(a[0]=NaN);break;case exports.ColorNotation.HWB:Math.max(0,reducePrecision(a[1]))+Math.max(0,reducePrecision(a[2]))>=100&&(a[0]=NaN);break;case exports.ColorNotation.Lab:(reducePrecision(a[0])<=0||reducePrecision(a[0])>=100)&&(a[1]=NaN,a[2]=NaN);break;case exports.ColorNotation.LCH:reducePrecision(a[1])<=0&&(a[2]=NaN),(reducePrecision(a[0])<=0||reducePrecision(a[0])>=100)&&(a[1]=NaN,a[2]=NaN);break;case exports.ColorNotation.OKLab:(reducePrecision(a[0])<=0||reducePrecision(a[0])>=1)&&(a[1]=NaN,a[2]=NaN);break;case exports.ColorNotation.OKLCH:reducePrecision(a[1])<=0&&(a[2]=NaN),(reducePrecision(a[0])<=0||reducePrecision(a[0])>=1)&&(a[1]=NaN,a[2]=NaN)}return a}function carryForwardMissingComponents(e,o,a,n){const t=[...a];for(const a of o)Number.isNaN(e[o[a]])&&(t[n[a]]=NaN);return t}function normalizeRelativeColorDataChannels(e){const o=new Map;switch(e.colorNotation){case exports.ColorNotation.RGB:case exports.ColorNotation.HEX:o.set("r",dummyNumberToken(255*e.channels[0])),o.set("g",dummyNumberToken(255*e.channels[1])),o.set("b",dummyNumberToken(255*e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.HSL:o.set("h",dummyNumberToken(e.channels[0])),o.set("s",dummyNumberToken(e.channels[1])),o.set("l",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.HWB:o.set("h",dummyNumberToken(e.channels[0])),o.set("w",dummyNumberToken(e.channels[1])),o.set("b",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.Lab:case exports.ColorNotation.OKLab:o.set("l",dummyNumberToken(e.channels[0])),o.set("a",dummyNumberToken(e.channels[1])),o.set("b",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.LCH:case exports.ColorNotation.OKLCH:o.set("l",dummyNumberToken(e.channels[0])),o.set("c",dummyNumberToken(e.channels[1])),o.set("h",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.sRGB:case exports.ColorNotation.A98_RGB:case exports.ColorNotation.Display_P3:case exports.ColorNotation.Rec2020:case exports.ColorNotation.Linear_sRGB:case exports.ColorNotation.ProPhoto_RGB:o.set("r",dummyNumberToken(e.channels[0])),o.set("g",dummyNumberToken(e.channels[1])),o.set("b",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha));break;case exports.ColorNotation.XYZ_D50:case exports.ColorNotation.XYZ_D65:o.set("x",dummyNumberToken(e.channels[0])),o.set("y",dummyNumberToken(e.channels[1])),o.set("z",dummyNumberToken(e.channels[2])),"number"==typeof e.alpha&&o.set("alpha",dummyNumberToken(e.alpha))}return o}function noneToZeroInRelativeColorDataChannels(e){const o=new Map(e);for(const[a,n]of e)Number.isNaN(n[4].value)&&o.set(a,dummyNumberToken(0));return o}function dummyNumberToken(e){return[a.TokenType.Number,e.toString(),-1,-1,{value:e,type:a.NumberType.Number}]}function reducePrecision(e,o=7){if(Number.isNaN(e))return 0;const a=Math.pow(10,o);return Math.round(e*a)/a}function normalize(e,o,a,n){return Math.min(Math.max(e/o,a),n)}const s=/[A-Z]/g;function toLowerCaseAZ(e){return e.replace(s,(e=>String.fromCharCode(e.charCodeAt(0)+32)))}function normalize_Color_ChannelValues(e,o,n){if(e[0]===a.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return n.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[a.TokenType.Number,"none",e[2],e[3],{value:NaN,type:a.NumberType.Number}];if(e[0]===a.TokenType.Percentage){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,100,-1/0,1/0);return 3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,-1/0,1/0);return 3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}const i=new Set(["srgb","srgb-linear","display-p3","a98-rgb","prophoto-rgb","rec2020","xyz","xyz-d50","xyz-d65"]);function color$1(e,o){const n=[],l=[],s=[],u=[];let c,p,N=!1,m=!1;const h={colorNotation:exports.ColorNotation.sRGB,channels:[0,0,0],alpha:1,syntaxFlags:new Set([])};let y=n;for(let x=0;x<e.value.length;x++){let T=e.value[x];if(t.isWhitespaceNode(T)||t.isCommentNode(T))for(;t.isWhitespaceNode(e.value[x+1])||t.isCommentNode(e.value[x+1]);)x++;else if(y===n&&n.length&&(y=l),y===l&&l.length&&(y=s),t.isTokenNode(T)&&T.value[0]===a.TokenType.Delim&&"/"===T.value[4].value){if(y===u)return!1;y=u}else{if(t.isFunctionNode(T)){if(y===u&&"var"===toLowerCaseAZ(T.getName())){h.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),y.push(T);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(T.getName())))return!1;const[[e]]=r.calcFromComponentValues([[T]],{toCanonicalUnits:!0,precision:100,globals:p});if(!e||!t.isTokenNode(e)||(e.value[0]===a.TokenType.Percentage||e.value[0]===a.TokenType.Number||e.value[0]===a.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;T=e}if(y===n&&0===n.length&&t.isTokenNode(T)&&T.value[0]===a.TokenType.Ident&&i.has(toLowerCaseAZ(T.value[4].value))){if(N)return!1;N=toLowerCaseAZ(T.value[4].value),h.colorNotation=colorSpaceNameToColorNotation(N),m&&(m.colorNotation!==h.colorNotation&&(m=colorDataTo(m,h.colorNotation)),c=normalizeRelativeColorDataChannels(m),p=noneToZeroInRelativeColorDataChannels(c))}else if(y===n&&0===n.length&&t.isTokenNode(T)&&T.value[0]===a.TokenType.Ident&&"from"===toLowerCaseAZ(T.value[4].value)){if(m)return!1;if(N)return!1;for(;t.isWhitespaceNode(e.value[x+1])||t.isCommentNode(e.value[x+1]);)x++;if(x++,T=e.value[x],m=o(T),!1===m)return!1;m.syntaxFlags.has(exports.SyntaxFlag.Experimental)&&h.syntaxFlags.add(exports.SyntaxFlag.Experimental),h.syntaxFlags.add(exports.SyntaxFlag.RelativeColorSyntax)}else{if(!t.isTokenNode(T))return!1;if(T.value[0]===a.TokenType.Ident&&c&&c.has(toLowerCaseAZ(T.value[4].value))){y.push(new t.TokenNode(c.get(toLowerCaseAZ(T.value[4].value))));continue}y.push(T)}}}if(!N)return!1;if(1!==y.length)return!1;if(1!==n.length||1!==l.length||1!==s.length)return!1;if(!t.isTokenNode(n[0])||!t.isTokenNode(l[0])||!t.isTokenNode(s[0]))return!1;if(c&&!c.has("alpha"))return!1;const x=normalize_Color_ChannelValues(n[0].value,0,h);if(!x||x[0]!==a.TokenType.Number)return!1;const T=normalize_Color_ChannelValues(l[0].value,1,h);if(!T||T[0]!==a.TokenType.Number)return!1;const b=normalize_Color_ChannelValues(s[0].value,2,h);if(!b||b[0]!==a.TokenType.Number)return!1;const C=[x,T,b];if(1===u.length)if(h.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(u[0])){const e=normalize_Color_ChannelValues(u[0].value,3,h);if(!e||e[0]!==a.TokenType.Number)return!1;C.push(e)}else h.alpha=u[0];else if(c&&c.has("alpha")){const e=normalize_Color_ChannelValues(c.get("alpha"),3,h);if(!e||e[0]!==a.TokenType.Number)return!1;C.push(e)}return h.channels=[C[0][4].value,C[1][4].value,C[2][4].value],4===C.length&&(h.alpha=C[3][4].value),h}function colorSpaceNameToColorNotation(e){switch(e){case"srgb":return exports.ColorNotation.sRGB;case"srgb-linear":return exports.ColorNotation.Linear_sRGB;case"display-p3":return exports.ColorNotation.Display_P3;case"a98-rgb":return exports.ColorNotation.A98_RGB;case"prophoto-rgb":return exports.ColorNotation.ProPhoto_RGB;case"rec2020":return exports.ColorNotation.Rec2020;case"xyz":case"xyz-d65":return exports.ColorNotation.XYZ_D65;case"xyz-d50":return exports.ColorNotation.XYZ_D50;default:throw new Error("Unknown color space name: "+e)}}const u=new Set(["srgb","srgb-linear","lab","oklab","xyz","xyz-d50","xyz-d65"]),c=new Set(["hsl","hwb","lch","oklch"]),p=new Set(["shorter","longer","increasing","decreasing"]);function colorMix(e,o){let n=null,r=null,l=null,s=!1;for(let i=0;i<e.value.length;i++){const N=e.value[i];if(!t.isWhitespaceNode(N)&&!t.isCommentNode(N)){if(t.isTokenNode(N)&&N.value[0]===a.TokenType.Ident){if(!n&&"in"===toLowerCaseAZ(N.value[4].value)){n=N;continue}if(n&&!r){r=toLowerCaseAZ(N.value[4].value);continue}if(n&&r&&!l&&c.has(r)){l=toLowerCaseAZ(N.value[4].value);continue}if(n&&r&&l&&!s&&"hue"===toLowerCaseAZ(N.value[4].value)){s=!0;continue}return!1}return!(!t.isTokenNode(N)||N.value[0]!==a.TokenType.Comma)&&(!!r&&(l||s?!!(r&&l&&s&&c.has(r)&&p.has(l))&&colorMixPolar(r,l,colorMixComponents(e.value.slice(i+1),o)):u.has(r)?colorMixRectangular(r,colorMixComponents(e.value.slice(i+1),o)):!!c.has(r)&&colorMixPolar(r,"shorter",colorMixComponents(e.value.slice(i+1),o))))}}return!1}function colorMixComponents(e,o){const n=[];let l=1,s=!1,i=!1;for(let l=0;l<e.length;l++){let u=e[l];if(!t.isWhitespaceNode(u)&&!t.isCommentNode(u)){if(!t.isTokenNode(u)||u.value[0]!==a.TokenType.Comma){if(!s){const e=o(u);if(e){s=e;continue}}if(!i){if(t.isFunctionNode(u)&&r.mathFunctionNames.has(toLowerCaseAZ(u.getName()))&&([[u]]=r.calcFromComponentValues([[u]],{toCanonicalUnits:!0,precision:100}),!u||!t.isTokenNode(u)||(u.value[0]===a.TokenType.Percentage||u.value[0]===a.TokenType.Number||u.value[0]===a.TokenType.Dimension)&&Number.isNaN(u.value[4].value)))return!1;if(t.isTokenNode(u)&&u.value[0]===a.TokenType.Percentage&&u.value[4].value>=0){i=u.value[4].value;continue}}return!1}if(!s)return!1;n.push({color:s,percentage:i}),s=!1,i=!1}}if(s&&n.push({color:s,percentage:i}),2!==n.length)return!1;let u=n[0].percentage,c=n[1].percentage;return(!1===u||!(u<0||u>100))&&((!1===c||!(c<0||c>100))&&(!1===u&&!1===c?(u=50,c=50):!1!==u&&!1===c?c=100-u:!1===u&&!1!==c&&(u=100-c),(0!==u||0!==c)&&(!1!==u&&!1!==c&&(u+c>100&&(u=u/(u+c)*100,c=c/(u+c)*100),u+c<100&&(l=(u+c)/100,u=u/(u+c)*100,c=c/(u+c)*100),{a:{color:n[0].color,percentage:u},b:{color:n[1].color,percentage:c},alphaMultiplier:l}))))}function colorMixRectangular(e,o){if(!o)return!1;const a=o.a.color,n=o.b.color,t=o.a.percentage/100;let r=a.channels,l=n.channels,s=exports.ColorNotation.RGB,i=a.alpha;if("number"!=typeof i)return!1;let u=n.alpha;if("number"!=typeof u)return!1;switch(i=Number.isNaN(i)?u:i,u=Number.isNaN(u)?i:u,e){case"srgb":s=exports.ColorNotation.RGB;break;case"srgb-linear":s=exports.ColorNotation.Linear_sRGB;break;case"lab":s=exports.ColorNotation.Lab;break;case"oklab":s=exports.ColorNotation.OKLab;break;case"xyz-d50":s=exports.ColorNotation.XYZ_D50;break;case"xyz":case"xyz-d65":s=exports.ColorNotation.XYZ_D65}r=colorDataTo(a,s).channels,l=colorDataTo(n,s).channels,r[0]=fillInMissingComponent(r[0],l[0]),l[0]=fillInMissingComponent(l[0],r[0]),r[1]=fillInMissingComponent(r[1],l[1]),l[1]=fillInMissingComponent(l[1],r[1]),r[2]=fillInMissingComponent(r[2],l[2]),l[2]=fillInMissingComponent(l[2],r[2]),r[0]=premultiply(r[0],i),r[1]=premultiply(r[1],i),r[2]=premultiply(r[2],i),l[0]=premultiply(l[0],u),l[1]=premultiply(l[1],u),l[2]=premultiply(l[2],u);const c=interpolate(i,u,t),p={colorNotation:s,channels:[un_premultiply(interpolate(r[0],l[0],t),c),un_premultiply(interpolate(r[1],l[1],t),c),un_premultiply(interpolate(r[2],l[2],t),c)],alpha:c*o.alphaMultiplier,syntaxFlags:new Set([exports.SyntaxFlag.ColorMix])};return(o.a.color.syntaxFlags.has(exports.SyntaxFlag.Experimental)||o.b.color.syntaxFlags.has(exports.SyntaxFlag.Experimental))&&p.syntaxFlags.add(exports.SyntaxFlag.Experimental),p}function colorMixPolar(e,o,a){if(!a)return!1;const n=a.a.color,t=a.b.color,r=a.a.percentage/100;let l=n.channels,s=t.channels,i=0,u=0,c=0,p=0,N=0,m=0,h=exports.ColorNotation.RGB,y=n.alpha;if("number"!=typeof y)return!1;let x=t.alpha;if("number"!=typeof x)return!1;switch(y=Number.isNaN(y)?x:y,x=Number.isNaN(x)?y:x,e){case"hsl":h=exports.ColorNotation.HSL;break;case"hwb":h=exports.ColorNotation.HWB;break;case"lch":h=exports.ColorNotation.LCH;break;case"oklch":h=exports.ColorNotation.OKLCH}switch(l=colorDataTo(n,h).channels,s=colorDataTo(t,h).channels,e){case"hsl":case"hwb":i=l[0],u=s[0],c=l[1],p=s[1],N=l[2],m=s[2];break;case"lch":case"oklch":c=l[0],p=s[0],N=l[1],m=s[1],i=l[2],u=s[2]}i=fillInMissingComponent(i,u),Number.isNaN(i)&&(i=0),u=fillInMissingComponent(u,i),Number.isNaN(u)&&(u=0),c=fillInMissingComponent(c,p),p=fillInMissingComponent(p,c),N=fillInMissingComponent(N,m),m=fillInMissingComponent(m,N);const T=u-i;switch(o){case"shorter":T>180?i+=360:T<-180&&(u+=360);break;case"longer":-180<T&&T<180&&(T>0?i+=360:u+=360);break;case"increasing":T<0&&(u+=360);break;case"decreasing":T>0&&(i+=360);break;default:throw new Error("Unknown hue interpolation method")}c=premultiply(c,y),N=premultiply(N,y),p=premultiply(p,x),m=premultiply(m,x);let b=[0,0,0];const C=interpolate(y,x,r);switch(e){case"hsl":case"hwb":b=[interpolate(i,u,r),un_premultiply(interpolate(c,p,r),C),un_premultiply(interpolate(N,m,r),C)];break;case"lch":case"oklch":b=[un_premultiply(interpolate(c,p,r),C),un_premultiply(interpolate(N,m,r),C),interpolate(i,u,r)]}const d={colorNotation:h,channels:b,alpha:C*a.alphaMultiplier,syntaxFlags:new Set([exports.SyntaxFlag.ColorMix])};return(a.a.color.syntaxFlags.has(exports.SyntaxFlag.Experimental)||a.b.color.syntaxFlags.has(exports.SyntaxFlag.Experimental))&&d.syntaxFlags.add(exports.SyntaxFlag.Experimental),d}function fillInMissingComponent(e,o){return Number.isNaN(e)?o:e}function interpolate(e,o,a){return e*a+o*(1-a)}function premultiply(e,o){return Number.isNaN(o)?e:Number.isNaN(e)?NaN:e*o}function un_premultiply(e,o){return 0===o||Number.isNaN(o)?e:Number.isNaN(e)?NaN:e/o}function hex(e){const o=toLowerCaseAZ(e[4].value);if(o.match(/[^a-f0-9]/))return!1;const a={colorNotation:exports.ColorNotation.HEX,channels:[0,0,0],alpha:1,syntaxFlags:new Set([exports.SyntaxFlag.Hex])},n=o.length;if(3===n){const e=o[0],n=o[1],t=o[2];return a.channels=[parseInt(e+e,16)/255,parseInt(n+n,16)/255,parseInt(t+t,16)/255],a}if(6===n){const e=o[0]+o[1],n=o[2]+o[3],t=o[4]+o[5];return a.channels=[parseInt(e,16)/255,parseInt(n,16)/255,parseInt(t,16)/255],a}if(4===n){const e=o[0],n=o[1],t=o[2],r=o[3];return a.channels=[parseInt(e+e,16)/255,parseInt(n+n,16)/255,parseInt(t+t,16)/255],a.alpha=parseInt(r+r,16)/255,a.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),a}if(8===n){const e=o[0]+o[1],n=o[2]+o[3],t=o[4]+o[5],r=o[6]+o[7];return a.channels=[parseInt(e,16)/255,parseInt(n,16)/255,parseInt(t,16)/255],a.alpha=parseInt(r,16)/255,a.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),a}return!1}function normalizeHue(e){if(e[0]===a.TokenType.Number)return e[4].value=e[4].value%360,e[1]=e[4].value.toString(),e;if(e[0]===a.TokenType.Dimension){let o=e[4].value;switch(toLowerCaseAZ(e[4].unit)){case"deg":break;case"rad":o=180*e[4].value/Math.PI;break;case"grad":o=.9*e[4].value;break;case"turn":o=360*e[4].value;break;default:return!1}return o%=360,[a.TokenType.Number,o.toString(),e[2],e[3],{value:o,type:a.NumberType.Number}]}return!1}function normalize_legacy_HSL_ChannelValues(e,o,n){if(0===o){const o=normalizeHue(e);return!1!==o&&(e[0]===a.TokenType.Dimension&&n.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===a.TokenType.Percentage){3===o?n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,1,0,100);return 3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){if(3!==o)return!1;let n=normalize(e[4].value,1,0,100);return 3===o&&(n=normalize(e[4].value,1,0,1)),[a.TokenType.Number,n.toString(),e[2],e[3],{value:n,type:a.NumberType.Number}]}return!1}function normalize_modern_HSL_ChannelValues(e,o,n){if(e[0]===a.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return n.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[a.TokenType.Number,"none",e[2],e[3],{value:NaN,type:a.NumberType.Number}];if(0===o){const o=normalizeHue(e);return!1!==o&&(e[0]===a.TokenType.Dimension&&n.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===a.TokenType.Percentage){3===o?n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=e[4].value;return 3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=e[4].value;return 3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}function threeChannelLegacySyntax(e,o,n,l){const s=[],i=[],u=[],c=[],p={colorNotation:n,channels:[0,0,0],alpha:1,syntaxFlags:new Set(l)};let N=s;for(let o=0;o<e.value.length;o++){let n=e.value[o];if(!t.isWhitespaceNode(n)&&!t.isCommentNode(n)){if(t.isTokenNode(n)&&n.value[0]===a.TokenType.Comma){if(N===s){N=i;continue}if(N===i){N=u;continue}if(N===u){N=c;continue}if(N===c)return!1}if(t.isFunctionNode(n)){if(N===c&&"var"===toLowerCaseAZ(n.getName())){p.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),N.push(n);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(n.getName())))return!1;const[[e]]=r.calcFromComponentValues([[n]],{toCanonicalUnits:!0,precision:100});if(!e||!t.isTokenNode(e)||(e.value[0]===a.TokenType.Percentage||e.value[0]===a.TokenType.Number||e.value[0]===a.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;n=e}if(!t.isTokenNode(n))return!1;N.push(n)}}if(1!==N.length)return!1;if(1!==s.length||1!==i.length||1!==u.length)return!1;if(!t.isTokenNode(s[0])||!t.isTokenNode(i[0])||!t.isTokenNode(u[0]))return!1;const m=o(s[0].value,0,p);if(!m||m[0]!==a.TokenType.Number)return!1;const h=o(i[0].value,1,p);if(!h||h[0]!==a.TokenType.Number)return!1;const y=o(u[0].value,2,p);if(!y||y[0]!==a.TokenType.Number)return!1;const x=[m,h,y];if(1===c.length)if(p.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(c[0])){const e=o(c[0].value,3,p);if(!e||e[0]!==a.TokenType.Number)return!1;x.push(e)}else p.alpha=c[0];return p.channels=[x[0][4].value,x[1][4].value,x[2][4].value],4===x.length&&(p.alpha=x[3][4].value),p}function threeChannelSpaceSeparated(e,o,n,l,s){const i=toLowerCaseAZ(e.getName()),u=[],c=[],p=[],N=[];let m,h,y=!1;const x={colorNotation:n,channels:[0,0,0],alpha:1,syntaxFlags:new Set(l)};let T=u;for(let o=0;o<e.value.length;o++){let l=e.value[o];if(t.isWhitespaceNode(l)||t.isCommentNode(l))for(;t.isWhitespaceNode(e.value[o+1])||t.isCommentNode(e.value[o+1]);)o++;else if(T===u&&u.length&&(T=c),T===c&&c.length&&(T=p),t.isTokenNode(l)&&l.value[0]===a.TokenType.Delim&&"/"===l.value[4].value){if(T===N)return!1;T=N}else{if(t.isFunctionNode(l)){if(T===N&&"var"===toLowerCaseAZ(l.getName())){x.syntaxFlags.add(exports.SyntaxFlag.HasVariableAlpha),T.push(l);continue}if(!r.mathFunctionNames.has(toLowerCaseAZ(l.getName())))return!1;const[[e]]=r.calcFromComponentValues([[l]],{toCanonicalUnits:!0,precision:100,globals:h});if(!e||!t.isTokenNode(e)||(e.value[0]===a.TokenType.Percentage||e.value[0]===a.TokenType.Number||e.value[0]===a.TokenType.Dimension)&&Number.isNaN(e.value[4].value))return!1;l=e}if(T===u&&0===u.length&&t.isTokenNode(l)&&l.value[0]===a.TokenType.Ident&&"from"===toLowerCaseAZ(l.value[4].value)&&"hsla"!==i&&"rgba"!==i){if(y)return!1;for(;t.isWhitespaceNode(e.value[o+1])||t.isCommentNode(e.value[o+1]);)o++;if(o++,l=e.value[o],y=s(l),!1===y)return!1;y.syntaxFlags.has(exports.SyntaxFlag.Experimental)&&x.syntaxFlags.add(exports.SyntaxFlag.Experimental),x.syntaxFlags.add(exports.SyntaxFlag.RelativeColorSyntax),y.colorNotation!==n&&(y=colorDataTo(y,n)),m=normalizeRelativeColorDataChannels(y),h=noneToZeroInRelativeColorDataChannels(m)}else{if(!t.isTokenNode(l))return!1;if(l.value[0]===a.TokenType.Ident&&m&&m.has(toLowerCaseAZ(l.value[4].value))){T.push(new t.TokenNode(m.get(toLowerCaseAZ(l.value[4].value))));continue}T.push(l)}}}if(1!==T.length)return!1;if(1!==u.length||1!==c.length||1!==p.length)return!1;if(!t.isTokenNode(u[0])||!t.isTokenNode(c[0])||!t.isTokenNode(p[0]))return!1;if(m&&!m.has("alpha"))return!1;const b=o(u[0].value,0,x);if(!b||b[0]!==a.TokenType.Number)return!1;const C=o(c[0].value,1,x);if(!C||C[0]!==a.TokenType.Number)return!1;const d=o(p[0].value,2,x);if(!d||d[0]!==a.TokenType.Number)return!1;const g=[b,C,d];if(1===N.length)if(x.syntaxFlags.add(exports.SyntaxFlag.HasAlpha),t.isTokenNode(N[0])){const e=o(N[0].value,3,x);if(!e||e[0]!==a.TokenType.Number)return!1;g.push(e)}else x.alpha=N[0];else if(m&&m.has("alpha")){const e=o(m.get("alpha"),3,x);if(!e||e[0]!==a.TokenType.Number)return!1;g.push(e)}return x.channels=[g[0][4].value,g[1][4].value,g[2][4].value],4===g.length&&(x.alpha=g[3][4].value),x}function hsl(e,o){if(e.value.some((e=>t.isTokenNode(e)&&e.value[0]===a.TokenType.Comma))){const o=hslCommaSeparated(e);if(!1!==o)return o}{const a=hslSpaceSeparated(e,o);if(!1!==a)return a}return!1}function hslCommaSeparated(e){return threeChannelLegacySyntax(e,normalize_legacy_HSL_ChannelValues,exports.ColorNotation.HSL,[exports.SyntaxFlag.LegacyHSL])}function hslSpaceSeparated(e,o){return threeChannelSpaceSeparated(e,normalize_modern_HSL_ChannelValues,exports.ColorNotation.HSL,[],o)}function normalize_HWB_ChannelValues(e,o,n){if(e[0]===a.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return n.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[a.TokenType.Number,"none",e[2],e[3],{value:NaN,type:a.NumberType.Number}];if(0===o){const o=normalizeHue(e);return!1!==o&&(e[0]===a.TokenType.Dimension&&n.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===a.TokenType.Percentage){3===o?n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=e[4].value;return 3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=e[4].value;return 3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}function normalize_Lab_ChannelValues(e,o,n){if(e[0]===a.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return n.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[a.TokenType.Number,"none",e[2],e[3],{value:NaN,type:a.NumberType.Number}];if(e[0]===a.TokenType.Percentage){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,1,0,100);return 1===o||2===o?t=normalize(e[4].value,.8,-1/0,1/0):3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,0,100);return 1===o||2===o?t=normalize(e[4].value,1,-1/0,1/0):3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}function lab(e,o){return threeChannelSpaceSeparated(e,normalize_Lab_ChannelValues,exports.ColorNotation.Lab,[],o)}function normalize_LCH_ChannelValues(e,o,n){if(e[0]===a.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return n.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[a.TokenType.Number,"none",e[2],e[3],{value:NaN,type:a.NumberType.Number}];if(2===o){const o=normalizeHue(e);return!1!==o&&(e[0]===a.TokenType.Dimension&&n.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===a.TokenType.Percentage){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,1,0,100);return 1===o?t=normalize(e[4].value,100/150,0,1/0):3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,0,100);return 1===o?t=normalize(e[4].value,1,0,1/0):3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}function lch(e,o){return threeChannelSpaceSeparated(e,normalize_LCH_ChannelValues,exports.ColorNotation.LCH,[],o)}const N=new Map;for(const[e,o]of Object.entries(n.namedColors))N.set(e,o);function namedColor(e){const o=N.get(toLowerCaseAZ(e));return!!o&&{colorNotation:exports.ColorNotation.RGB,channels:[o[0]/255,o[1]/255,o[2]/255],alpha:1,syntaxFlags:new Set([exports.SyntaxFlag.ColorKeyword,exports.SyntaxFlag.NamedColor])}}function normalize_OKLab_ChannelValues(e,o,n){if(e[0]===a.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return n.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[a.TokenType.Number,"none",e[2],e[3],{value:NaN,type:a.NumberType.Number}];if(e[0]===a.TokenType.Percentage){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,100,0,1);return 1===o||2===o?t=normalize(e[4].value,250,-1/0,1/0):3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,0,1);return 1===o||2===o?t=normalize(e[4].value,1,-1/0,1/0):3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}function oklab(e,o){return threeChannelSpaceSeparated(e,normalize_OKLab_ChannelValues,exports.ColorNotation.OKLab,[],o)}function normalize_OKLCH_ChannelValues(e,o,n){if(e[0]===a.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return n.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[a.TokenType.Number,"none",e[2],e[3],{value:NaN,type:a.NumberType.Number}];if(2===o){const o=normalizeHue(e);return!1!==o&&(e[0]===a.TokenType.Dimension&&n.syntaxFlags.add(exports.SyntaxFlag.HasDimensionValues),o)}if(e[0]===a.TokenType.Percentage){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,100,0,1);return 1===o?t=normalize(e[4].value,250,0,1/0):3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,1,0,1);return 1===o?t=normalize(e[4].value,1,0,1/0):3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}function oklch(e,o){return threeChannelSpaceSeparated(e,normalize_OKLCH_ChannelValues,exports.ColorNotation.OKLCH,[],o)}function normalize_legacy_sRGB_ChannelValues(e,o,n){if(e[0]===a.TokenType.Percentage){3===o?n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageAlpha):n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);const t=normalize(e[4].value,100,0,1);return[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,255,0,1);return 3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}function normalize_modern_sRGB_ChannelValues(e,o,n){if(e[0]===a.TokenType.Ident&&"none"===toLowerCaseAZ(e[4].value))return n.syntaxFlags.add(exports.SyntaxFlag.HasNoneKeywords),[a.TokenType.Number,"none",e[2],e[3],{value:NaN,type:a.NumberType.Number}];if(e[0]===a.TokenType.Percentage){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasPercentageValues);let t=normalize(e[4].value,100,-1/0,1/0);return 3===o&&(t=normalize(e[4].value,100,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}if(e[0]===a.TokenType.Number){3!==o&&n.syntaxFlags.add(exports.SyntaxFlag.HasNumberValues);let t=normalize(e[4].value,255,-1/0,1/0);return 3===o&&(t=normalize(e[4].value,1,0,1)),[a.TokenType.Number,t.toString(),e[2],e[3],{value:t,type:a.NumberType.Number}]}return!1}function rgb(e,o){if(e.value.some((e=>t.isTokenNode(e)&&e.value[0]===a.TokenType.Comma))){const o=rgbCommaSeparated(e);if(!1!==o)return(!o.syntaxFlags.has(exports.SyntaxFlag.HasNumberValues)||!o.syntaxFlags.has(exports.SyntaxFlag.HasPercentageValues))&&o}else{const a=rgbSpaceSeparated(e,o);if(!1!==a)return a}return!1}function rgbCommaSeparated(e){return threeChannelLegacySyntax(e,normalize_legacy_sRGB_ChannelValues,exports.ColorNotation.RGB,[exports.SyntaxFlag.LegacyRGB])}function rgbSpaceSeparated(e,o){return threeChannelSpaceSeparated(e,normalize_modern_sRGB_ChannelValues,exports.ColorNotation.RGB,[],o)}function toPrecision(e,o=7){e=+e,o=+o;const a=(Math.floor(e)+"").length;if(o>a)return+e.toFixed(o-a);{const n=10**(a-o);return Math.round(e/n)*n}}function XYZ_D50_to_P3_Gamut(e){const o=n.XYZ_D50_to_P3(e);if(n.inGamut(o))return n.clip(o);let a=e.slice();return a=n.XYZ_D50_to_OKLCH(a),a[0]<1e-6&&(a=[0,0,0]),a[0]>.999999&&(a=[1,0,0]),n.mapGamut(a,(e=>(e=n.OKLCH_to_OKLab(e),e=n.OKLab_to_XYZ(e),e=n.XYZ_to_lin_P3(e),n.gam_P3(e))),(e=>(e=n.lin_P3(e),e=n.lin_P3_to_XYZ(e),e=n.XYZ_to_OKLab(e),n.OKLab_to_OKLCH(e))))}function serializeWithAlpha(e,o,n,r){const l=[a.TokenType.CloseParen,")",-1,-1,void 0];if("number"==typeof e.alpha){const s=Math.min(1,Math.max(0,toPrecision(Number.isNaN(e.alpha)?0:e.alpha)));return 1===toPrecision(s,4)?new t.FunctionNode(o,l,r):new t.FunctionNode(o,l,[...r,new t.WhitespaceNode([n]),new t.TokenNode([a.TokenType.Delim,"/",-1,-1,{value:"/"}]),new t.WhitespaceNode([n]),new t.TokenNode([a.TokenType.Number,toPrecision(s,4).toString(),-1,-1,{value:e.alpha,type:a.NumberType.Integer}])])}return new t.FunctionNode(o,l,[...r,new t.WhitespaceNode([n]),new t.TokenNode([a.TokenType.Delim,"/",-1,-1,{value:"/"}]),new t.WhitespaceNode([n]),e.alpha])}function XYZ_D50_to_sRGB_Gamut(e){const o=n.XYZ_D50_to_sRGB(e);if(n.inGamut(o))return n.clip(o);let a=e.slice();return a=n.XYZ_D50_to_OKLCH(a),a[0]<1e-6&&(a=[0,0,0]),a[0]>.999999&&(a=[1,0,0]),n.mapGamut(a,(e=>(e=n.OKLCH_to_OKLab(e),e=n.OKLab_to_XYZ(e),e=n.XYZ_to_lin_sRGB(e),n.gam_sRGB(e))),(e=>(e=n.lin_sRGB(e),e=n.lin_sRGB_to_XYZ(e),e=n.XYZ_to_OKLab(e),n.OKLab_to_OKLCH(e))))}exports.color=function color(e){if(t.isFunctionNode(e)){switch(toLowerCaseAZ(e.getName())){case"rgb":case"rgba":return rgb(e,color);case"hsl":case"hsla":return hsl(e,color);case"hwb":return o=color,threeChannelSpaceSeparated(e,normalize_HWB_ChannelValues,exports.ColorNotation.HWB,[],o);case"lab":return lab(e,color);case"lch":return lch(e,color);case"oklab":return oklab(e,color);case"oklch":return oklch(e,color);case"color":return color$1(e,color);case"color-mix":return colorMix(e,color)}}var o;if(t.isTokenNode(e)){if(e.value[0]===a.TokenType.Hash)return hex(e.value);if(e.value[0]===a.TokenType.Ident){const o=namedColor(e.value[4].value);return!1!==o?o:"transparent"===toLowerCaseAZ(e.value[4].value)&&{colorNotation:exports.ColorNotation.RGB,channels:[0,0,0],alpha:0,syntaxFlags:new Set([exports.SyntaxFlag.ColorKeyword])}}}return!1},exports.colorDataFitsDisplayP3_Gamut=function colorDataFitsDisplayP3_Gamut(e){const o={...e,channels:[...e.channels]};return o.channels=convertPowerlessComponentsToZeroValuesForDisplay(o.channels,o.colorNotation),!colorDataTo(o,exports.ColorNotation.Display_P3).channels.find((e=>e<-1e-5||e>1.00001))},exports.colorDataFitsRGB_Gamut=function colorDataFitsRGB_Gamut(e){const o={...e,channels:[...e.channels]};return o.channels=convertPowerlessComponentsToZeroValuesForDisplay(o.channels,o.colorNotation),!colorDataTo(o,exports.ColorNotation.RGB).channels.find((e=>e<-1e-5||e>1.00001))},exports.colorDataTo=colorDataTo,exports.serializeHSL=function serializeHSL(e,o=!0){e.channels=convertPowerlessComponentsToZeroValuesForDisplay(e.channels,e.colorNotation);let r=e.channels.map((e=>Number.isNaN(e)?0:e));r=o?n.XYZ_D50_to_HSL(n.sRGB_to_XYZ_D50(XYZ_D50_to_sRGB_Gamut(colorData_to_XYZ_D50(e).channels))):n.XYZ_D50_to_HSL(colorData_to_XYZ_D50(e).channels),r=r.map((e=>Number.isNaN(e)?0:e));const l=Math.min(360,Math.max(0,Math.round(toPrecision(r[0])))),s=Math.min(100,Math.max(0,Math.round(toPrecision(r[1])))),i=Math.min(100,Math.max(0,Math.round(toPrecision(r[2])))),u=[a.TokenType.CloseParen,")",-1,-1,void 0],c=[a.TokenType.Whitespace," ",-1,-1,void 0],p=[a.TokenType.Comma,",",-1,-1,void 0],N=[new t.TokenNode([a.TokenType.Number,l.toString(),-1,-1,{value:r[0],type:a.NumberType.Integer}]),new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Percentage,s.toString()+"%",-1,-1,{value:r[1]}]),new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Percentage,i.toString()+"%",-1,-1,{value:r[2]}])];if("number"==typeof e.alpha){const o=Math.min(1,Math.max(0,toPrecision(Number.isNaN(e.alpha)?0:e.alpha)));return 1===toPrecision(o,4)?new t.FunctionNode([a.TokenType.Function,"hsl(",-1,-1,{value:"hsl"}],u,N):new t.FunctionNode([a.TokenType.Function,"hsla(",-1,-1,{value:"hsla"}],u,[...N,new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Number,toPrecision(o,4).toString(),-1,-1,{value:e.alpha,type:a.NumberType.Number}])])}return new t.FunctionNode([a.TokenType.Function,"hsla(",-1,-1,{value:"hsla"}],u,[...N,new t.TokenNode(p),new t.WhitespaceNode([c]),e.alpha])},exports.serializeOKLCH=function serializeOKLCH(e){e.channels=convertPowerlessComponentsToZeroValuesForDisplay(e.channels,e.colorNotation);let o=e.channels.map((e=>Number.isNaN(e)?0:e));e.colorNotation!==exports.ColorNotation.OKLCH&&(o=n.XYZ_D50_to_OKLCH(colorData_to_XYZ_D50(e).channels));const r=toPrecision(o[0],6),l=toPrecision(o[1],6),s=toPrecision(o[2],6),i=[a.TokenType.Function,"oklch(",-1,-1,{value:"oklch"}],u=[a.TokenType.Whitespace," ",-1,-1,void 0];return serializeWithAlpha(e,i,u,[new t.TokenNode([a.TokenType.Number,r.toString(),-1,-1,{value:o[0],type:a.NumberType.Number}]),new t.WhitespaceNode([u]),new t.TokenNode([a.TokenType.Number,l.toString(),-1,-1,{value:o[1],type:a.NumberType.Number}]),new t.WhitespaceNode([u]),new t.TokenNode([a.TokenType.Number,s.toString(),-1,-1,{value:o[2],type:a.NumberType.Number}])])},exports.serializeP3=function serializeP3(e,o=!0){e.channels=convertPowerlessComponentsToZeroValuesForDisplay(e.channels,e.colorNotation);let r=e.channels.map((e=>Number.isNaN(e)?0:e));e.colorNotation!==exports.ColorNotation.Display_P3&&(r=o?XYZ_D50_to_P3_Gamut(colorData_to_XYZ_D50(e).channels):n.XYZ_D50_to_P3(colorData_to_XYZ_D50(e).channels));const l=toPrecision(r[0],6),s=toPrecision(r[1],6),i=toPrecision(r[2],6),u=[a.TokenType.Function,"color(",-1,-1,{value:"color"}],c=[a.TokenType.Whitespace," ",-1,-1,void 0];return serializeWithAlpha(e,u,c,[new t.TokenNode([a.TokenType.Ident,"display-p3",-1,-1,{value:"display-p3"}]),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Number,l.toString(),-1,-1,{value:r[0],type:a.NumberType.Number}]),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Number,s.toString(),-1,-1,{value:r[1],type:a.NumberType.Number}]),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Number,i.toString(),-1,-1,{value:r[2],type:a.NumberType.Number}])])},exports.serializeRGB=function serializeRGB(e,o=!0){e.channels=convertPowerlessComponentsToZeroValuesForDisplay(e.channels,e.colorNotation);let r=e.channels.map((e=>Number.isNaN(e)?0:e));r=o?XYZ_D50_to_sRGB_Gamut(colorData_to_XYZ_D50(e).channels):n.XYZ_D50_to_sRGB(colorData_to_XYZ_D50(e).channels);const l=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[0])))),s=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[1])))),i=Math.min(255,Math.max(0,Math.round(255*toPrecision(r[2])))),u=[a.TokenType.CloseParen,")",-1,-1,void 0],c=[a.TokenType.Whitespace," ",-1,-1,void 0],p=[a.TokenType.Comma,",",-1,-1,void 0],N=[new t.TokenNode([a.TokenType.Number,l.toString(),-1,-1,{value:r[0],type:a.NumberType.Integer}]),new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Number,s.toString(),-1,-1,{value:r[1],type:a.NumberType.Integer}]),new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Number,i.toString(),-1,-1,{value:r[2],type:a.NumberType.Integer}])];if("number"==typeof e.alpha){const o=Math.min(1,Math.max(0,toPrecision(Number.isNaN(e.alpha)?0:e.alpha)));return 1===toPrecision(o,4)?new t.FunctionNode([a.TokenType.Function,"rgb(",-1,-1,{value:"rgb"}],u,N):new t.FunctionNode([a.TokenType.Function,"rgba(",-1,-1,{value:"rgba"}],u,[...N,new t.TokenNode(p),new t.WhitespaceNode([c]),new t.TokenNode([a.TokenType.Number,toPrecision(o,4).toString(),-1,-1,{value:e.alpha,type:a.NumberType.Number}])])}return new t.FunctionNode([a.TokenType.Function,"rgba(",-1,-1,{value:"rgba"}],u,[...N,new t.TokenNode(p),new t.WhitespaceNode([c]),e.alpha])};
