const {
    spacing
} = require('tailwindcss/defaultTheme');

const colors = require('tailwindcss/colors');

const hyvaModules = require('@hyva-themes/hyva-modules');

module.exports = hyvaModules.mergeTailwindConfig({
    theme: {
        extend: {
            screens: {
                'xs': '470px',
                // => @media (min-width: 470px) { ... }
                'sm': '640px',
                // => @media (min-width: 640px) { ... }
                'md': '768px',
                // => @media (min-width: 768px) { ... }
                'lg': '1024px',
                // => @media (min-width: 1024px) { ... }
                'xl': '1280px',
                // => @media (min-width: 1280px) { ... }
                '2xl': '1536px',
                // => @media (min-width: 1536px) { ... }
            },
            colors: {
                primary: {
                    lighter: colors.blue['300'],
                    "DEFAULT": colors.blue['800'],
                    darker: colors.blue['900'],
                },
                secondary: {
                    lighter: colors.blue['100'],
                    "DEFAULT": colors.blue['200'],
                    darker: colors.blue['300'],
                },
                background: {
                    lighter: colors.blue['100'],
                    "DEFAULT": colors.blue['200'],
                    darker: colors.blue['300'],
                },
                red: {
                    150: '#E2001A',
                    250: '#ff1631',
                    275: '#dd002e',
                    615: '#D10202',
                },
                blue: {
                    150: '#007AC5',
                    175: '#5A96FA',
                    250: '#3395d1',
                    775: '#006599',
                    197: '#1974a3',
                    225: '#7db1ce',
                    750: '#006587'
                },
                gray: {
                    50: '#F2F2F2',
                    85: '#dae4ed',
                    115: '#EFF2F7',
                },
                brown: {
                    25: '#f2e7d7',
                },
            },
            textColor: {
                orange: colors.orange,
                primary: {
                    lighter: colors.gray['700'],
                    "DEFAULT": colors.gray['800'],
                    darker: colors.gray['900'],
                },
                secondary: {
                    lighter: colors.gray['400'],
                    "DEFAULT": colors.gray['600'],
                    darker: colors.gray['800'],
                },
                blue: {
                    450: '#60A5FA',
                    775: '#006599',
                },
                gray: {
                    775: '#333333',
                    825: '#999999',
                }
            },
            backgroundColor: {
                primary: {
                    lighter: colors.blue['600'],
                    "DEFAULT": colors.blue['700'],
                    darker: colors.blue['800'],
                },
                secondary: {
                    lighter: colors.blue['100'],
                    "DEFAULT": colors.blue['200'],
                    darker: colors.blue['300'],
                },
                container: {
                    lighter: '#ffffff',
                    "DEFAULT": '#fafafa',
                    darker: '#f5f5f5',
                },
                gray: {
                    25: '#eeeeee',
                    75: '#666666',
                    125: '#E2EDEF',
                    150: '#dddddd',
                    250: '#c7dfe3',
                    350: '#9ea3af',
                    450: '#9c968c',
                },
                blue: {
                    125: '#007AC5',
                    775: '#006599',
                    197: '#1974a3',
                },
                red: {
                    575: '#EC3232',
                    615: '#D10202',
                },
            },
            borderColor: {
                primary: {
                    lighter: colors.blue['600'],
                    "DEFAULT": colors.blue['700'],
                    darker: colors.blue['800'],
                },
                secondary: {
                    lighter: colors.blue['100'],
                    "DEFAULT": colors.blue['200'],
                    darker: colors.blue['300'],
                },
                container: {
                    lighter: '#f5f5f5',
                    "DEFAULT": '#e7e7e7',
                    darker: '#b6b6b6',
                },
                blue: {
                    775: '#006599',
                    197: '#1974a3',
                },
                gray: {
                    'ccc': '#CCCCCC',
                },
                red: {
                    275: '#dd002e',
                },
            },
            borderWidth: {
                '0.5': '0.5px',
                '3': '3px',
                '20': '20px',
            },
            minWidth: {
                8: spacing["8"],
                20: spacing["20"],
                40: spacing["40"],
                48: spacing["48"],
                '25%': '25%',
                '1/3': '33%',
                '107': '428px',
                'stickylg': '977px',
                'stickyxl': '1232px',
                'sticky2xl': '1490px',
            },
            maxWidth: {
                '12.5': '50px',
                '22': '88px',
                '29': '116px',
                '36': '144px',
                '62': '248px',
                '512px': '512px',
                '1/3': '33.333333%',
                '2/3': '66.666666%',
                '1/2': '50%',
                '90vw': '90vw',
                '8xl': '1536px',
            },
            minHeight: {
                14: spacing["14"],
                'screen-25': '25vh',
                'screen-50': '50vh',
                'screen-75': '75vh',
                '8': '32px',
                '11': '44px',
                '16':'64px',
                '18': '72px',
                '30': '120px',
                '33.75': '135px',
                '40': '160px',
                '41': "164px",
                '50': '200px',
                '53': '214px',
                '55': '223px',
                '57': '236px',
                '60.75': '243px',
                '61': '245px',
                '61.75': '247px',
                '62': '248px',
                '65': '260px',
                '69': '268px',
                '69.5': '276px',
                '70.75': '283px',
                '75' : '300px',
                '75.75': '303px',
                '78': '308px',
                '100': '400px',
            },
            maxHeight: {
                '0': '0',
                'screen-25': '25vh',
                'screen-50': '50vh',
                'screen-75': '75vh',
                '90vh': '90vh',
                '11.75': '45px',
                '22.5': '90px',
                '59': '236px',
                '62': '248px',
                '90': '360px',
                '115': '460px',
                '120': '480px',
                '127': '508px',
                '150': '600px'
            },
            width: {
                'slide-custom-1': 'calc(25%-30px)',
                'slide-custom-2': 'calc(33.33%-18px)',
                'slide-custom-3': 'calc(50%-10px)',
                '9px': '9px',
                '7.5': '30px',
                '9.5': '38px',
                '11.5': '46px',
                '72px': '72px',
                '176.8px': '176.8px',
                '320': '320px',
                '213': '852px',
                '40vw': '40vw',
            },
            height: {
                '9px': '9px',
                '23px': '23px',
                '7.5': '30px',
                '11': '44px',
                '23': '92px',
                '100': '400px',
                'screen-10': '10vw',
                'screen-15': '15vw'
            },
            boxShadow: {
                'white': '0 0 3px white',
                'blue': '3px 3px 0 #016499',
                'red-8': '8px 8px 0 #DD002E',
                'red-24': '24px 24px 0 #DD002E',
                'blue-4': '0 4px 0 0 #007AC5',
                'gray-all': '0px 0px 10px 1px #DCDCDC',
                'gray-1': '0 .5px 3px .5px #D4D4D4',
            },
            container: {
                center: true,
                padding: '1.5rem'
            },
            gridTemplateColumns: {
                '1fr-max': '1fr max-content',
                '15': 'repeat(15, minmax(0, 1fr))',
                'custom1': '40% 60%',
                'custom2': '14% 40% 13% 33%',
                'custom3': '25% 75%',
                'custom4': '66.66% 33.33%',
                'custom5': '1fr 2.5fr 1fr',
                'custom6': '15% 37.5% 15% 32.5%',
                'custom7': '20% 45% 35%',
                'custom8': '15% 50% 35%',
                'custom9': '75% 25%',
                'custom10': '33.33% 66.66%',
                'custom11': '60% 40%',
                'custom12': '20% 30% 20% 30%',
            },
            inset: {
                '1px': '1px',
                '1': '4px',
                '10.5': '42px',
                '14.5': '58px',
                '15': '60px',
                '18': '72px',
                '26.5': '106px',
                '10.5px': '10.5px',
                '63px': '63px',
                '1.6p': '1.6%',
                '2.2p': '2.2%',
            },
            fontFamily: {
                'nunito': ['Nunito', 'sans-serif'],
            },
            fontSize: {
                '15px': '15px',
                '22px': "22px",
                '26px': '26px',
                '28px': '28px'
            },
            scale: {
                '-1': '-1',
                '120': '1.2',
            },
            transitionDuration: {
                '2000': '2000ms',
                '400': '400ms',
            },
            transitionTimingFunction: {
                'leave': 'cubic-bezier(.4, -0.04, .2, .99)',
            },
            margin: {
                '-0.25': '-1px',
                '0.25': '1px',
                '-1.25': '-5px',
                '0.75': '3px',
                '5.5': '22px'
            },
            spacing: {
                '0.25': '1px',
                '0.5': '2px',
                '1.25': '5px',
                '1.38': '5.5px',
                '1.5': '6px',
                '1.75': '7px',
                '2.25': '9px',
                '2.5': '10px',
                '3.5': '14px',
                '3.75': '15px',
                '4.75': '18px',
                '5.5': '22px',
                '6.5': '26px',
                '7.5': '30px',
                '9.5': '36px',
                '12.5': '50px',
                '13': '52px',
                '13.5': '54px',
                '14': '56px',
                '14.5': '58px',
                '18': '72px',
                '21': '84px',
                '22.5': '90px',
                '26': '104px',
                '30': '120px',
                '35': '140px',
                '36.75': '147px',
                '37': '148px',
                '37.5': '150px',
                '50': '200px',
                '53': '212px',
                '54': '216px',
                '65': '260px',
                '75': '300px',
                '200p': '200%',
                '300p': '300%',
                'custom1': 'calc(50% - 50vw)',
                '1/6': '17%',
            }
        },
    },
    plugins: [
        require('@tailwindcss/forms'),
        require('@tailwindcss/typography'),
        function ({ addVariant }) {
            addVariant('*', '& > *');
            addVariant('*:hover', '& > *:hover');
        }
    ],
    future: {
        hoverOnlyWhenSupported: true,
    },
    content: [
        './tailwind-safelist.txt',
        './tailwind-safelist-t3.txt',
        // this theme's phtml and layout XML files
        '../../**/*.phtml',
        '../../*/layout/*.xml',
        '../../*/page_layout/override/base/*.xml',
        // parent theme in Vendor (if this is a child-theme)
        '../../../../../../../vendor/hyva-themes/magento2-default-theme/**/*.phtml',
        '../../../../../../../vendor/hyva-themes/magento2-default-theme/*/layout/*.xml',
        '../../../../../../../vendor/hyva-themes/magento2-default-theme/*/page_layout/override/base/*.xml',
        // app/code phtml files (if need tailwind classes from app/code modules)
        // '../../../../../../../app/code/**/*.phtml',
        '../../../../../../../app/code/WebVision/BannerSlider/**/*.phtml',
        '../../../../../../../app/code/Mzat/CustomCheckoutData/**/*.phtml',
        '../../../../../../../app/code/WebVision/ScrollToTop/**/*.phtml',
        // widget block classes from app/code
        //'../../../../../../../app/code/**/Block/Widget/**/*.php'
        // react app src files (if React Checkout is installed in app/code)
        // '../../../../../../../app/code/**/src/**/*.jsx',
        // react app src files in vendor (If React Checkout is installed in vendor)
        // '../../../../../../../vendor/hyva-themes/magento2-react-checkout/src/reactapp/src/**/*.jsx',
        // '../../../../../../../vendor/hyva-themes/magento2-react-checkout/src/view/frontend/templates/react-container.phtml',
    ]
});
