<?php

if (function_exists('readEnvVarOrDie')) {
    return;
}

function readEnvVarOrDie(string $varName) {
    $value = getenv($varName);

    if ($value === false || $value === '') {
        if (strpos($_SERVER['argv'][0], 'composer') !== false) {
            return '--not available in Composer--';
        }
        echo 'Environment variable "' . $varName . '" must be set';
        exit(2);
    }

    return $value;
}
