<?php

namespace Deployer;

require_once 'deployment/rsync.php';
require_once 'recipe/magento2.php';

set('application', 'mz-at.de');

set('bin/php', function () {
    return '/opt/plesk/php/8.2/bin/php';
});

set('bin/npm', function () {
    return '/opt/plesk/node/16/bin/npm';
});

set('composer_options', implode(' ', [
    '{{composer_action}}',
    '--no-dev',
    '--ansi',
    '--no-interaction',
    '--prefer-dist',
    '--optimize-autoloader',
    '--ignore-platform-reqs'
]));

host('production')
    ->hostname('85.14.241.144')
    ->user('prelive.mz-at.de')
    ->addSshOption('UserKnownHostsFile', __DIR__ . '/.ssh/known_hosts')
    ->addSshOption('StrictHostKeyChecking', 'no')
    ->stage('master')
    ->forwardAgent(false)
    ->set('deploy_path', '/var/www/vhosts/mz-at.de/sites/production')
    ->set('branch', 'master')
    ->set('http_user', 'nginx');

host('stage')
    ->hostname('cte2cd2e32.web-vision.io')
    ->user('mz-upgrade.web-vision.io')
    ->addSshOption('UserKnownHostsFile', __DIR__ . '/.ssh/known_hosts')
    ->addSshOption('StrictHostKeyChecking', 'no')
    ->stage('stage')
    ->forwardAgent(false)
    ->set('deploy_path', '/var/www/vhosts/stage.mz-at.de/sites/stage')
    ->set('branch', 'stage')
    ->set('http_user', 'nginx');

// Data is transferred via rsync because we run the build on the Bamboo agent, not on the final system
set('rsync_src', __DIR__);
set('rsync_dest', '{{release_path}}');
set('rsync', [
    'exclude' => [
        '.git',
        'deploy.php',
    ],
    'exclude-file' => false,
    'include' => [],
    'include-file' => false,
    'filter' => [],
    'filter-file' => false,
    'filter-perdir' => false,
    // use "a" instead of "r" to get symlinks transferred
    'flags' => 'az',
    'options' => ['delete'],
    'timeout' => 1800,
]);

// Set timeout
set('default_timeout', 1800);

set('shared_dirs', array_merge(
    get('shared_dirs'),
    [
        // this folder is used for uploads by the client
        'var/cache',
        'var/import',
        'var/page_cache',
        'mhsi/bin'
    ]
));

set('shared_files', [
    '.env',
    'app/etc/config.php',
    'pub/.htaccess',
    'pub/.user.ini',
    'var/Redirections.csv',
    'var/.maintenance.ip',
]);

task('magento:compile', function () {
    run('{{bin/php}} -d memory_limit=-1 {{release_path}}/bin/magento setup:di:compile');
});

task('magento:deploy:assets', function () {
    run("{{bin/php}} -d memory_limit=-1 {{release_path}}/bin/magento setup:static-content:deploy -f --jobs 8");
});

task('magento:mode-set', function () {
    run('{{bin/php}} -d memory_limit=-1 {{release_path}}/bin/magento deploy:mode:set production -s');
});


task('magento:reindex', function () {
    run('{{bin/php}} -d memory_limit=-1 {{release_path}}/bin/magento indexer:reindex');
});

task('magento:upgrade', function () {
    run('{{bin/php}} -d memory_limit=-1 {{release_path}}/bin/magento config:set dev/static/sign 0');
    run('{{bin/php}} -d memory_limit=-1 {{release_path}}/bin/magento setup:upgrade');
});

task('vendors', function() {
    run('composer clear-cache');
    run('composer -vvv {{composer_options}}');
})->local();

task('style:build', function () {
    run('npm --prefix app/design/frontend/Mz-at/default/web/tailwind install');
    run('npm --prefix app/design/frontend/Mz-at/default/web/tailwind run build-prod');
})->local();

task('react:build', function () {
    run('pwd');
    run('npm -v');
    run('npm --prefix {{release_path}}/app/code/Mzat/ReactCheckout/reactapp install');
    run('{{release_path}}/app/code/Mzat/ReactCheckout/reactapp/node_modules/prettier/bin-prettier.js -w {{release_path}}/app/code/Mzat/ReactCheckout/reactapp/src/components');
    run('npm --prefix {{release_path}}/app/code/Mzat/ReactCheckout/reactapp run build');
});

task('magento:init-deployment-config', function () {
    if (!test('[ -s {{deploy_path}}/shared/app/etc/config.php ]')) {
        run('{{bin/php}} {{release_path}}/bin/magento module:enable --all');
    }
});

task('magento:crontab-update', function () {
    if (test('[ -L {{deploy_path}}/current ]')) {
        run("{{bin/php}} {{current_path}}/bin/magento cron:remove");
    }
    run("{{bin/php}} {{release_path}}/bin/magento cron:install --force");
});

task('mhsi:link', function () {
    $releasePath = '{{release_path}}';
    $sharedPath = '{{deploy_path}}/shared';

    run("rm -rf $releasePath/var/cache");
    run("mkdir -p `dirname $releasePath/var/cache`");
    run("ln -nfs --relative $sharedPath/var/cache $releasePath/var/cache");

    run('ln -s {{release_path}}/mhsi/  {{release_path}}/pub/mhsi');
});

task('ariba:link', function () {
   run('mkdir -p {{release_path}}/pub/downloads');
   run('ln -s {{deploy_path}}/shared/pub/downloads/ariba  {{release_path}}/pub/downloads/ariba');
});

task('deploy:magento', [
    'magento:init-deployment-config',
    //'react:build',
    'magento:mode-set',
    'magento:upgrade',
    'magento:compile',
    'magento:deploy:assets',
    //'magento:cron-jobs:kill-running',
    'magento:crontab-update',
    'magento:cache:flush'
])->desc('Magento2 deployment operations');

task('deploy', [
    'deploy:info',
    'deploy:prepare',
    'deploy:lock',
    'deploy:release',
    'vendors',
    'style:build',
    'rsync',
    'deploy:shared',
    'deploy:writable',
    'deploy:clear_paths',
    'deploy:magento',
    'deploy:symlink',
    'mhsi:link',
    'ariba:link',
    'deploy:unlock',
    'cleanup',
    'success'
])->desc('Deploy your project');
after('deploy', 'success');

fail('deploy', 'deploy:failed');

after('deploy:failed', 'deploy:unlock');
