<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @copyright   Copyright (c) 2022-2023 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */

 /* Fix Default Value select for DE store issue */

use Magento\Framework\AppInterface;

require_once __DIR__ . '/app/bootstrap.php';

$bootstrap = \Magento\Framework\App\Bootstrap::create(BP, $_SERVER);
$objectManager = $bootstrap->getObjectManager();

$appState = $objectManager->get('\Magento\Framework\App\State');
$appState->setAreaCode('frontend');

$resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
$connection = $resource->getConnection();

// get removed store id
$sql = "Select store_id FROM  store where code = 'de'";
$storeResult = $connection->fetchRow($sql);
if(isset($storeResult['store_id'])) {
    // get category attributes with skip values
    $skipAttr = implode(',',['name', 'url_key']);
    $eavSql = "select * from eav_attribute where entity_type_id = 3 and attribute_code NOT IN ('name', 'url_key')";
    $eavResults = $connection->fetchAll($eavSql);
    $storeId =  $storeResult['store_id'];
    foreach($eavResults as $eavKey => $eavResult){
        // Check attribute table and remove it's value
        switch ($eavResult['backend_type']) {
            case 'text':
                $sqlEntityText = "DELETE FROM `catalog_category_entity_text` where  attribute_id = ".$eavResult['attribute_id']." and store_id = ".$storeId;
                $connection->query($sqlEntityText);
                break;

            case 'int':
                $sqlEntityInt = "DELETE FROM `catalog_category_entity_int` where  attribute_id = ".$eavResult['attribute_id']." and store_id = ".$storeId;
                $connection->query($sqlEntityInt);
                break;

            case 'static':
                $sqlEntityStatic = "DELETE FROM `catalog_category_entity_".$eavResult['frontend_input']."` where  attribute_id = ".$eavResult['attribute_id']." and store_id = ".$storeId;
                $connection->query($sqlEntityStatic);
                break;

            case 'varchar':
                $sqlEntityVarchar = "DELETE FROM `catalog_category_entity_varchar` where  attribute_id = ".$eavResult['attribute_id']." and store_id = ".$storeId;
                $connection->query($sqlEntityVarchar);
                break;

            case 'datetime':
                $sqlEntityDatetime = "DELETE FROM `catalog_category_entity_datetime` where  attribute_id = ".$eavResult['attribute_id']." and store_id = ".$storeId;
                $connection->query($sqlEntityDatetime);
                break;

            case 'decimal':
                $sqlEntityDecimal = "DELETE FROM `catalog_category_entity_decimal` where  attribute_id = ".$eavResult['attribute_id']." and store_id = ".$storeId;
                $connection->query($sqlEntityDecimal);
                break;

            default:
                echo "No Action for CODE: ".$eavResult['attribute_code'];
                break;
        }
    }
}