<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @copyright   Copyright (c) 2022-2023 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */

 /* Fix The wrong order history issue */

use Magento\Framework\AppInterface;

require_once __DIR__ . '/app/bootstrap.php';

$bootstrap = \Magento\Framework\App\Bootstrap::create(BP, $_SERVER);
$objectManager = $bootstrap->getObjectManager();
$appState = $objectManager->get('\Magento\Framework\App\State');
$appState->setAreaCode('frontend');

// get all order collection
$orderCollections = $objectManager->create('Magento\Sales\Model\ResourceModel\Order\Collection');
$orderCollections->addFieldToSelect(['entity_id','increment_id','customer_is_guest']);
$orderCollections->addAttributeToFilter('customer_is_guest', 0);

foreach ($orderCollections as  $orderCollection) {
    // Checking every order
    try {
        $orderId = $orderCollection->getEntityId();
        $order = $objectManager->create('\Magento\Sales\Model\OrderRepository')->get($orderId);

        // get website id
        $websiteId = 1;

        // get order customer by email
        $customerModel = $objectManager->create('Magento\Customer\Model\Customer');
        $customerModel->setWebsiteId($websiteId);
        $customerModel->loadByEmail($order->getCustomerEmail());

        // check current customer has correct or not
        if($customerModel->getEntityId() != $order->getCustomerId()) {
            echo "\nOrder : #".$order->getIncrementId()." processing..\n";

            // get new updated customer
            $customerRepository = $objectManager->create('Magento\Customer\Api\CustomerRepositoryInterface');
            $customer = $customerRepository->getById($customerModel->getEntityId());

            $customerAssigment = $objectManager->create('Magento\Sales\Model\Order\CustomerAssignment');
            $customerAssigment->execute($order, $customer);

            // Update Customer Order grid section
            $orderGridUpdate = $objectManager->create('Magento\Sales\Model\ResourceModel\GridPool');
            $orderGridUpdate->refreshByOrderId($order->getId());

            echo "\nOrder : #".$order->getIncrementId()." updated the customer info\n";
        }
    } catch (\Magento\Framework\Exception\NoSuchEntityException $e) {
        echo "** Error Order : #".$orderCollection->getIncrementId()." -> ".$e->getMessage();
    }
}
