<?php
namespace Smile\ElasticsuiteCore\Api\Client\ClientInterface;

/**
 * Proxy class for @see \Smile\ElasticsuiteCore\Api\Client\ClientInterface
 */
class Proxy implements \Smile\ElasticsuiteCore\Api\Client\ClientInterface, \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Smile\ElasticsuiteCore\Api\Client\ClientInterface
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Smile\\ElasticsuiteCore\\Api\\Client\\ClientInterface', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        if ($this->_subject) {
            $this->_subject = clone $this->_getSubject();
        }
    }

    /**
     * Debug proxied instance
     */
    public function __debugInfo()
    {
        return ['i' => $this->_subject];
    }

    /**
     * Get proxied instance
     *
     * @return \Smile\ElasticsuiteCore\Api\Client\ClientInterface
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function info()
    {
        return $this->_getSubject()->info();
    }

    /**
     * {@inheritdoc}
     */
    public function nodes()
    {
        return $this->_getSubject()->nodes();
    }

    /**
     * {@inheritdoc}
     */
    public function cluster()
    {
        return $this->_getSubject()->cluster();
    }

    /**
     * {@inheritdoc}
     */
    public function ping()
    {
        return $this->_getSubject()->ping();
    }

    /**
     * {@inheritdoc}
     */
    public function createIndex($indexName, $indexSettings)
    {
        return $this->_getSubject()->createIndex($indexName, $indexSettings);
    }

    /**
     * {@inheritdoc}
     */
    public function deleteIndex($indexName)
    {
        return $this->_getSubject()->deleteIndex($indexName);
    }

    /**
     * {@inheritdoc}
     */
    public function indexExists($indexName)
    {
        return $this->_getSubject()->indexExists($indexName);
    }

    /**
     * {@inheritdoc}
     */
    public function putIndexSettings($indexName, $indexSettings)
    {
        return $this->_getSubject()->putIndexSettings($indexName, $indexSettings);
    }

    /**
     * {@inheritdoc}
     */
    public function putMapping($indexName, $mapping)
    {
        return $this->_getSubject()->putMapping($indexName, $mapping);
    }

    /**
     * {@inheritdoc}
     */
    public function getMapping($indexName)
    {
        return $this->_getSubject()->getMapping($indexName);
    }

    /**
     * {@inheritdoc}
     */
    public function getSettings($indexName)
    {
        return $this->_getSubject()->getSettings($indexName);
    }

    /**
     * {@inheritdoc}
     */
    public function forceMerge($indexName)
    {
        return $this->_getSubject()->forceMerge($indexName);
    }

    /**
     * {@inheritdoc}
     */
    public function refreshIndex($indexName)
    {
        return $this->_getSubject()->refreshIndex($indexName);
    }

    /**
     * {@inheritdoc}
     */
    public function getIndicesNameByAlias($indexAlias)
    {
        return $this->_getSubject()->getIndicesNameByAlias($indexAlias);
    }

    /**
     * {@inheritdoc}
     */
    public function updateAliases($aliasActions)
    {
        return $this->_getSubject()->updateAliases($aliasActions);
    }

    /**
     * {@inheritdoc}
     */
    public function bulk($bulkParams)
    {
        return $this->_getSubject()->bulk($bulkParams);
    }

    /**
     * {@inheritdoc}
     */
    public function search($params)
    {
        return $this->_getSubject()->search($params);
    }

    /**
     * {@inheritdoc}
     */
    public function analyze($params)
    {
        return $this->_getSubject()->analyze($params);
    }

    /**
     * {@inheritdoc}
     */
    public function indexStats($indexName)
    {
        return $this->_getSubject()->indexStats($indexName);
    }

    /**
     * {@inheritdoc}
     */
    public function termvectors($params)
    {
        return $this->_getSubject()->termvectors($params);
    }

    /**
     * {@inheritdoc}
     */
    public function mtermvectors($params)
    {
        return $this->_getSubject()->mtermvectors($params);
    }

    /**
     * {@inheritdoc}
     */
    public function reindex(array $params) : array
    {
        return $this->_getSubject()->reindex($params);
    }

    /**
     * {@inheritdoc}
     */
    public function deleteByQuery(array $params) : array
    {
        return $this->_getSubject()->deleteByQuery($params);
    }

    /**
     * {@inheritdoc}
     */
    public function updateByQuery(array $params) : array
    {
        return $this->_getSubject()->updateByQuery($params);
    }

    /**
     * {@inheritdoc}
     */
    public function putPipeline(array $params) : array
    {
        return $this->_getSubject()->putPipeline($params);
    }

    /**
     * {@inheritdoc}
     */
    public function getPipeline(string $name) : array
    {
        return $this->_getSubject()->getPipeline($name);
    }
}
