<?php
namespace Smile\ElasticsuiteCore\Api\Index\IndexOperationInterface;

/**
 * Proxy class for @see \Smile\ElasticsuiteCore\Api\Index\IndexOperationInterface
 */
class Proxy implements \Smile\ElasticsuiteCore\Api\Index\IndexOperationInterface, \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Smile\ElasticsuiteCore\Api\Index\IndexOperationInterface
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Smile\\ElasticsuiteCore\\Api\\Index\\IndexOperationInterface', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        if ($this->_subject) {
            $this->_subject = clone $this->_getSubject();
        }
    }

    /**
     * Debug proxied instance
     */
    public function __debugInfo()
    {
        return ['i' => $this->_subject];
    }

    /**
     * Get proxied instance
     *
     * @return \Smile\ElasticsuiteCore\Api\Index\IndexOperationInterface
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function isAvailable()
    {
        return $this->_getSubject()->isAvailable();
    }

    /**
     * {@inheritdoc}
     */
    public function getIndexByName($indexIdentifier, $store)
    {
        return $this->_getSubject()->getIndexByName($indexIdentifier, $store);
    }

    /**
     * {@inheritdoc}
     */
    public function indexExists($indexIdentifier, $store)
    {
        return $this->_getSubject()->indexExists($indexIdentifier, $store);
    }

    /**
     * {@inheritdoc}
     */
    public function createIndex($indexIdentifier, $store)
    {
        return $this->_getSubject()->createIndex($indexIdentifier, $store);
    }

    /**
     * {@inheritdoc}
     */
    public function updateMapping($indexIdentifier, $store, $fields = [])
    {
        return $this->_getSubject()->updateMapping($indexIdentifier, $store, $fields);
    }

    /**
     * {@inheritdoc}
     */
    public function installIndex(\Smile\ElasticsuiteCore\Api\Index\IndexInterface $index, $store)
    {
        return $this->_getSubject()->installIndex($index, $store);
    }

    /**
     * {@inheritdoc}
     */
    public function createBulk()
    {
        return $this->_getSubject()->createBulk();
    }

    /**
     * {@inheritdoc}
     */
    public function executeBulk(\Smile\ElasticsuiteCore\Api\Index\Bulk\BulkRequestInterface $bulk)
    {
        return $this->_getSubject()->executeBulk($bulk);
    }

    /**
     * {@inheritdoc}
     */
    public function refreshIndex(\Smile\ElasticsuiteCore\Api\Index\IndexInterface $index)
    {
        return $this->_getSubject()->refreshIndex($index);
    }

    /**
     * {@inheritdoc}
     */
    public function getBatchIndexingSize()
    {
        return $this->_getSubject()->getBatchIndexingSize();
    }

    /**
     * {@inheritdoc}
     */
    public function proceedIndexInstall($indexName, $indexAlias)
    {
        return $this->_getSubject()->proceedIndexInstall($indexName, $indexAlias);
    }

    /**
     * {@inheritdoc}
     */
    public function reindex(array $sourceIndices, string $destIndex, array $bodyParams = [], array $sourceParams = [], array $destParams = []) : array
    {
        return $this->_getSubject()->reindex($sourceIndices, $destIndex, $bodyParams, $sourceParams, $destParams);
    }
}
