<?php

class Concatenate extends Fci_Objects_AbstractProcessor
{
    /**
     * Preprocess product data
     *
     * @param array $productArray
     * @param string $profile
     *
     */

    // Define attribute set IDs
    const ATTRIBUTE_SET = [
        "Accessories" => 10,
        "Bulk Media" => 13,
        "Chemicals" => 16,
        "Default" => 4,
        "GC Columns" => 9,
        "HPLC Columns" => 12,
        "SEC/GPC Columns" => 17,
        "SPE Cartridges" => 11,
        "Syringe Filters" => 15,
        "Syringes" => 14,
    ];
    const DEFAULT_ATTR_SET_ID = 4;

    public function pre(&$productArray, $profile)
    {
        foreach ($productArray as $key => $item) {
            if ($productArray[$key] === "") {
                unset($productArray[$key]);
            }

        }

        // If default quantity is not set, then create a new column "qty" and fill it with 0
        if (!isset($productArray["qty"])) {
            $productArray["qty"] = 0;
        }

        // If there are related or up-sell products columns, create appropriate columns for them
        if (isset($productArray["_related_sku"])) {
            $productArray["related"] = $productArray["_related_sku"];
        }
        if (isset($productArray["_upsell_sku"])) {
            $productArray["up_sell"] = $productArray["_upsell_sku"];
        }

        /* Comment code for create new category */
        // Convert "categories" column to "category_ids" and convert separator "|" with ","
        // if (isset($productArray["categories"]))  {
        //     $productArray["category_ids"] = str_replace("|", ",", $productArray["categories"]);
        //     unset($productArray["categories"]);
        // }

        // Replace "|" with "," in category_ids column
        // if (isset($productArray["category_ids"]))  {
        //     $productArray["category_ids"] = str_replace("|", ",", $productArray["category_ids"]);
        // }

        // If URL key contains invalid characters, replace them with characters provided in the $forbiddenChars array
        if (isset($productArray["url_key"])) {
            $forbiddenChars = [
                ',' => '-',
                'µ' => 'my',
                '/' => '-',
                'Å' => 'a',
                ' ' => '-',
                'π' => 'pi',
                '~' => '-',
                '²' => '2',
                '%' => '',
                '"' => '',
                '’' => '',
                '(' => '',
                ')' => '',
                '{' => '',
                '}' => '',
                '°' => '',
                '©' => '',
                '®' => '',
                '™' => '',
                'ä' => 'ae',
                'ü' => 'ue',
                'ö' => 'oe',
                'ß' => 'ss',
                'Ä' => 'ae',
                'Ü' => 'ue',
                'Ö' => 'oe',
                '_' => '-',
            ];
            $productArray["url_key"] = strtr(strtolower($productArray["url_key"]), $forbiddenChars);
        }

        // Set attribute ID using values from ATTRIBUTE_SET
        if ((isset($productArray["attribute_set_code"])) && (isset(self::ATTRIBUTE_SET[$productArray["attribute_set_code"]]))) {
            $productArray["attribute_set_id"] = self::ATTRIBUTE_SET[$productArray["attribute_set_code"]] ?? self::DEFAULT_ATTR_SET_ID;
        } else {
            $productArray["attribute_set_id"] = self::DEFAULT_ATTR_SET_ID;
        }

        // For Product Page category list
        if(isset($productArray['ew_category_exclude'])) {
            $productArray["ew_category_exclude"] = trim(str_replace('|', ',', $productArray['ew_category_exclude'] ?? ''));
        }

        // For related Product
        if(isset($productArray['products_related'])) {
            $productArray["related"] = trim(str_replace('|', ',', $productArray['products_related'] ?? ''));
        }

        // For Up sell Product
        if(isset($productArray['products_affiliate'])) {
            $productArray["up_sell"] = trim(str_replace('|', ',', $productArray['products_affiliate'] ?? ''));
        }

        // For SKU to clean invisible character
        if(isset($productArray['sku'])) {
            $productArray['sku'] = trim(preg_replace('/\x{A0}/u', '', $productArray['sku']));
        }
    }

    /**
     * After process product data
     *
     * @param Fci_Model_AbstractEntity $product
     * @param string $profile
     *
     */

    public function post(Fci_Model_AbstractEntity $product, $profile)
    {
        // TODO: Implement post() method.
    }
}
