import { faker } from '@faker-js/faker';
import express from 'express';

const app = express();

faker.setLocale('de');
const success = (data) => ({ success: true, data });
const error = (error = 'Error') => ({ success: false, error });

app.get('/cms/v0/test/', function (req, res) {
    const length = faker.random.numeric({ min: 1, max: 5 });
    res.json(
        Array.from({ length }).map((_, i) => ({
            test: "Testing",
        }))
    );
});

app.get('/cms/v0/content/', function (req, res) {
    faker.seed(Number(req.params.id) || 0);

    const length = faker.random.numeric({ min: 4, max: 32 });
    const types = Array.from({ length: faker.random.numeric(2) }).map(() => faker.lorem.word());

    res.json(
        Array.from({ length }).map((_, i) => ({
            imageUri: faker.image.avatar(),
            title: faker.lorem.words(2),
            shortDescription: faker.lorem.paragraph(6),
            description: faker.lorem.words(10),
            uri: './',
            memberCount: faker.random.numeric(2),
            type: types[i % types.length],
        }))
    );
});


app.get('/cms/v0/content:colPos?', function (req, res) {
    faker.seed(Number(req.params.colPos) || 0);

    res.json(
        {
            colPos: req.query.colPos,
            uid: req.query.uid,
            title: faker.lorem.words(2),
            shortDescription: faker.lorem.paragraph(6),
            description: faker.lorem.words(10),
            imageUri: faker.image.animals(),
            link: "/",
            active: true,
        }
    );
});

app.get('/cms/v0/categories/', function (req, res) {

    let categories = ['Default', 'Second', 'Third'];
    let category = Array.from(categories).map((item, i) => (
        {
            uid: i + 1,
            name: categories[i],
            created: new Date(Date.now()),
        }
    ));

    res.json(
        success(category)
    );
});

app.get('*', function (req, res) {
    res.json(error(`Cannot GET route '${req.url}', try restarting the 'mockapi' service`));
});

app.listen(4000, function () {
    console.log('Mock API running ...');
});
