/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Extendware
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
requirejs([
    'jquery', 'mage/url'
], function ($, urlBuilder) {
    'use strict';
    (function ($) {
        $.fn.tablesorter = function () {
            var $table = this;
            this.find('th').click(function () {
                var idx = $(this).index();
                var direction = $(this).hasClass('sort_asc');
                $table.tablesortby(idx, direction);
            });
            return this;
        };
        $.fn.tablesortby = function (idx, direction) {
            var $rows = this.find('tbody tr');

            function elementToVal(a) {
                var $a_elem = $(a).find('td:nth-child(' + (idx + 1) + ')');
                var a_val = $a_elem.attr('data-sort') || $a_elem.text();
                return (a_val == parseInt(a_val) ? parseInt(a_val) : a_val);
            }

            $rows.sort(function (a, b) {
                var a_val = elementToVal(a), b_val = elementToVal(b);
                return (a_val > b_val ? 1 : (a_val == b_val ? 0 : -1)) * (direction ? 1 : -1);
            })
            this.find('th').removeClass('sort_asc sort_desc');
            $(this).find('thead th:nth-child(' + (idx + 1) + ')').addClass(direction ? 'sort_desc' : 'sort_asc');
            for (var i = 0; i < $rows.length; i++)
                this.append($rows[i]);
            this.settablesortmarkers();
            return this;
        }
        $.fn.retablesort = function () {
            var $e = this.find('thead th.sort_asc, thead th.sort_desc');
            if ($e.length)
                this.tablesortby($e.index(), $e.hasClass('sort_desc'));

            return this;
        }
        $.fn.settablesortmarkers = function () {
            this.find('thead th span.indicator').remove();
            this.find('thead th.sort_asc').append('<span class="indicator">&darr;<span>');
            this.find('thead th.sort_desc').append('<span class="indicator">&uarr;<span>');
            return this;
        }
    })(jQuery);

    var MAX_UPLOAD_SIZE = $("#max_upload_size").data("value");
    var $tbody = $('#list');
    $('#table').tablesorter();
    $(document).ready(function () {
        list();
    });
    $('#table_attchemnet').on('click', '.delete_attchemnet', function (data) {
        var closest_tr = $(this).closest("tr");
        var attchement_id = $(this).data("id");
        var attchemnetdelete = window.attchemnetdelete
        $.ajax({
            showLoader: true,
            url: attchemnetdelete,
            data: {'type': 'delete', 'attchement_id': attchement_id},
            type: "GET",
            cache: false,
            dataType: 'json',
            success: function (response) {
                if (response) {
                    closest_tr.remove();
                    list();
                } else {
                    $message = 'Something Went Wrong in the Atachemnet Delte.'
                }
            }
        });
    });
    $('#table').on('click', '.delete', function (data) {
        var closest_tr = $(this).closest("tr");
        var resourcePath = $(this).data("file");
        filedelete(resourcePath);
        closest_tr.remove();
    });
    $('#table').on('click', '.download', function (data) {
        var resourcePath = $(this).data("file");
        var basename = $(this).data("basename");
        filedownload(resourcePath, basename);
    });
    $('#table').on('click', '.name', function (data) {
        var type = $(this).data("type");
        if (type == 'is_dir') {
            list($(this).data("path"));
        }
    });
    $('#breadcrumb').on('click', '.breadcrumbs-dir', function (data) {
        var type = $(this).data("type");
        if (type == 'is_dir') {
            list($(this).data("path"));
        }
    });
    $('#mkdir').submit(function (e) {
        var dir = $("#dirname").val();
        var hashval = $("#breadcrumb_des_path").data("value");
        e.preventDefault();
        mkdir(dir, hashval);
        $("#dirname").val('');
    });
    $('#file_drop_target').on('dragover', function () {
        $(this).addClass('drag_over');
        return false;
    }).on('dragend', function () {
        $(this).removeClass('drag_over');
        return false;
    }).on('drop', function (e) {
        e.preventDefault();
        var hashval = $("#breadcrumb_des_path").data("value");
        var files = e.originalEvent.dataTransfer.files;
        uploadFile(files, hashval);
        $(this).removeClass('drag_over');
    });
    $('input[type=file]').change(function (e) {
        e.preventDefault();
        var hashval = $("#breadcrumb_des_path").data("value");
        uploadFile(this.files, hashval);
    });

    function list(path) {
        var linkUrl = urlBuilder.build('extendware_attachmentrules/rules_file/filelist');
        var filelist = window.filelist;
        $.ajax({
            showLoader: true,
            url: filelist,
            data: {'type': 'list', 'path': path,},
            type: "GET",
            cache: false,
            dataType: 'json',
            success: function (response) {
                var $tbody = $('#list');
                if (typeof path != 'undefined') {
                    var hashval = path;
                } else {
                    var hashval = $('#home_dir').data("path");
                }
                $tbody.empty();
                $('#breadcrumb').empty().html(renderBreadcrumbs(hashval));
                if (response) {
                    $.each(response.results, function (k, v) {
                        $tbody.append(renderFileRow(v));
                    });
                    !response.results.length && $tbody.append('<tr><td class="empty" colspan=5>This folder is empty</td></tr>')
                    response.is_writable ? $('body').removeClass('no_write') : $('body').addClass('no_write');
                } else {
                    console.warn(response.error.msg);
                }
                $('#table').retablesort();
            }
        });
    }

    function filedelete(resourcePath) {
        var filedelete = window.filedelete;
        $.ajax({
            showLoader: true,
            url: filedelete,
            data: {'type': 'delete', 'resourcePath': resourcePath},
            type: "GET",
            cache: false,
            dataType: 'json',
            success: function (response) {
                if (response) {
                } else {
                }
                $('#table').retablesort();
            }
        });
    }

    function filedownload(resourcePath, basename) {
        var filedownload = window.filedownload;
        $.ajax({
            showLoader: true,
            url: filedownload,
            data: {'type': 'download', 'resourcePath': resourcePath},
            type: "GET",
            cache: false,
            xhrFields: {
                responseType: 'blob'
            },
            success: function (blob) {
                var link = document.createElement('a');
                link.href = window.URL.createObjectURL(blob);
                link.download = basename;
                link.click();
            }
        });
    }

    function mkdir(dir_name, path) {
        var filemkdir = window.filemkdir;
        $.ajax({
            showLoader: true,
            url: filemkdir,
            data: {'type': 'mkdir', 'dir_name': dir_name, 'path': path},
            type: "GET",
            cache: false,
            dataType: 'json',
            success: function (response) {
                list(path);
                if (response) {
                } else {
                }
                $('#table').retablesort();
            }
        });
    }

    function renderBreadcrumbs(path) {
        var file_manager_path = $("#file_manager_path").data("value");
        var base = "",
            $html = $('<div></div>');
        $html.append($('<input type="hidden" id="breadcrumb_des_path" name="breadcrumb_des_path" data-value="' + path + '">'));
        $html.append($('<a class="breadcrumbs-dir" id="home_dir" data-type="is_dir" href="javascript:void(0)" data-path="' + file_manager_path + '">Home</a></div>'));
        $.each(path.split('/'), function (k, v) {
            if (v) {
                var v_as_text = decodeURIComponent(v);
                $html.append($('<span></span>').text(' ▸ '))
                    .append($('<a class="breadcrumbs-dir" data-type="is_dir"/>').attr('href', "javascript:void(0)").text(v_as_text).attr('data-path', '/' + base + v));
                base += v + '/';
            }
        });
        return $html;
    }

    function renderFileRow(data) {
        var cherry_pic = $('<input type="checkbox" name="cherry_pic[]" value="' + data.path + '"/"' + data.name + '">');
        var $link = $('<a class="name" />')
            .attr('href', "javascript:void(0)")
            .text(data.name)
            .attr('data-id', data.base_path)
            .attr('data-path', data.path)
            .attr('data-type', data.is_dir ? 'is_dir' : 'is_file');
        var allow_direct_link = $("#allow_direct_link").data("value");
        if (!data.is_dir && !allow_direct_link) $link.css('pointer-events', 'none');
        var $dl_link = $('<a href="#"/>').attr('data-file', data.path).attr('data-basename', data.base_path).addClass('download').text('download');
        var $delete_link = $('<a href="#" />').attr('data-file', data.path).addClass('delete').text('delete');
        var perms = [];
        if (data.is_readable) perms.push('read');
        if (data.is_writable) perms.push('write');
        if (data.is_executable) perms.push('exec');
        var $html = $('<tr></tr>')
            .append($('<td class="cherry"></td>').append(cherry_pic))
            .addClass(data.is_dir ? 'is_dir' : '')
            .append($('<td class="first"></td>').append($link))
            .append($('<td></td>').attr('data-sort', data.is_dir ? -1 : data.size)
                .html($('<span class="size"></span>').text(formatFileSize(data.size))))
            .append($('<td></td>').attr('data-sort', data.mtime).text(formatTimestamp(data.mtime)))
            .append($('<td></td>').text(perms.join('+')))
            .append($('<td></td>').append($dl_link).append(data.is_deleteable ? $delete_link : ''))
        return $html;
    }

    function formatTimestamp(unix_timestamp) {
        var m = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
        var d = new Date(unix_timestamp * 1000);
        return [m[d.getMonth()], ' ', d.getDate(), ', ', d.getFullYear(), " ",
            (d.getHours() % 12 || 12), ":", (d.getMinutes() < 10 ? '0' : '') + d.getMinutes(),
            " ", d.getHours() >= 12 ? 'PM' : 'AM'].join('');
    }

    function formatFileSize(bytes) {
        var s = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB'];
        for (var pos = 0; bytes >= 1000; pos++, bytes /= 1024) ;
        var d = Math.round(bytes * 10);
        return pos ? [parseInt(d / 10), ".", d % 10, " ", s[pos]].join('') : bytes + ' bytes';
    }

    function uploadFile(files, path) {
        var fileupload = window.fileupload;
        var formData = new FormData();
        formData.append("form_key", window.FORM_KEY);
        //Get File Value
        formData.append('filelength', files.length);
        formData.append('path', path);
        if (files.length > 0) {
            for (var i = 0; i < files.length; i++) {
                formData.append('file' + i, files[i]);
            }
        }
        var folder = window.location.hash.substr(1);
        $.ajax({
            url: fileupload,
            type: 'POST',
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success: function (response) {
                list(path);
            }
        });
    }

    function renderFileUploadRow(file, folder) {
        return $row = $('<div></div>')
            .append($('<span class="fileuploadname"></span>').text((folder ? folder + '/' : '') + file.name))
            .append($('<div class="progress_track"><div class="progress"></div></div>'))
            .append($('<span class="size"></span>').text(formatFileSize(file.size)))
    };

    function renderFileSizeErrorRow(file, folder) {
        return $row = $('<div class="error"></div>')
            .append($('<span class="fileuploadname"></span>').text('Error: ' + (folder ? folder + '/' : '') + file.name))
            .append($('<span></span>').html(' file size - <b>' + formatFileSize(file.size) + '</b>'
                + ' exceeds max upload size of <b>' + formatFileSize(MAX_UPLOAD_SIZE) + '</b>'));
    }

});
