define([
    'mageUtils',
    'Magento_Ui/js/form/element/abstract'
], function (utils, Abstract) {
    'use strict';

    return Abstract.extend({
        defaults: {
            links: {
                value: ''
            }
        },
        initialize: function () {
            this._super()
                .initFormId();

            return this;
        },

        initConfig: function () {

            var uid = utils.uniqueid(),
                name,
                scope;

            this._super();

            scope   = this.dataScope,
                name    = scope.split('.').slice(1);

            _.extend(this, {
                uid: uid,
                noticeId: 'notice-' + uid,
                inputName: name[1]
            });

            return this;
        },
        initFormId: function () {
            var namespace;

            if (this.formId) {
                return this;
            }

            namespace   = this.name.split('.');
            this.formId = namespace[0];

            return this;
        }
    });
});
