require.config({"config": {
        "jsbuild":{"Smile_ElasticsuiteCore/js/lib/chart.js":"/*!\n * Chart.js v3.3.2\n * https://www.chartjs.org\n * (c) 2021 Chart.js Contributors\n * Released under the MIT License\n */\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.Chart = factory());\n}(this, (function () { 'use strict';\n\n    function fontString(pixelSize, fontStyle, fontFamily) {\n        return fontStyle + ' ' + pixelSize + 'px ' + fontFamily;\n    }\n    const requestAnimFrame = (function() {\n        if (typeof window === 'undefined') {\n            return function(callback) {\n                return callback();\n            };\n        }\n        return window.requestAnimationFrame;\n    }());\n    function throttled(fn, thisArg, updateFn) {\n        const updateArgs = updateFn || ((args) => Array.prototype.slice.call(args));\n        let ticking = false;\n        let args = [];\n        return function(...rest) {\n            args = updateArgs(rest);\n            if (!ticking) {\n                ticking = true;\n                requestAnimFrame.call(window, () => {\n                    ticking = false;\n                    fn.apply(thisArg, args);\n                });\n            }\n        };\n    }\n    function debounce(fn, delay) {\n        let timeout;\n        return function() {\n            if (delay) {\n                clearTimeout(timeout);\n                timeout = setTimeout(fn, delay);\n            } else {\n                fn();\n            }\n            return delay;\n        };\n    }\n    const _toLeftRightCenter = (align) => align === 'start' ? 'left' : align === 'end' ? 'right' : 'center';\n    const _alignStartEnd = (align, start, end) => align === 'start' ? start : align === 'end' ? end : (start + end) / 2;\n    const _textX = (align, left, right) => align === 'right' ? right : align === 'center' ? (left + right) / 2 : left;\n\n    class Animator {\n        constructor() {\n            this._request = null;\n            this._charts = new Map();\n            this._running = false;\n            this._lastDate = undefined;\n        }\n        _notify(chart, anims, date, type) {\n            const callbacks = anims.listeners[type];\n            const numSteps = anims.duration;\n            callbacks.forEach(fn => fn({\n                chart,\n                initial: anims.initial,\n                numSteps,\n                currentStep: Math.min(date - anims.start, numSteps)\n            }));\n        }\n        _refresh() {\n            const me = this;\n            if (me._request) {\n                return;\n            }\n            me._running = true;\n            me._request = requestAnimFrame.call(window, () => {\n                me._update();\n                me._request = null;\n                if (me._running) {\n                    me._refresh();\n                }\n            });\n        }\n        _update(date = Date.now()) {\n            const me = this;\n            let remaining = 0;\n            me._charts.forEach((anims, chart) => {\n                if (!anims.running || !anims.items.length) {\n                    return;\n                }\n                const items = anims.items;\n                let i = items.length - 1;\n                let draw = false;\n                let item;\n                for (; i >= 0; --i) {\n                    item = items[i];\n                    if (item._active) {\n                        if (item._total > anims.duration) {\n                            anims.duration = item._total;\n                        }\n                        item.tick(date);\n                        draw = true;\n                    } else {\n                        items[i] = items[items.length - 1];\n                        items.pop();\n                    }\n                }\n                if (draw) {\n                    chart.draw();\n                    me._notify(chart, anims, date, 'progress');\n                }\n                if (!items.length) {\n                    anims.running = false;\n                    me._notify(chart, anims, date, 'complete');\n                    anims.initial = false;\n                }\n                remaining += items.length;\n            });\n            me._lastDate = date;\n            if (remaining === 0) {\n                me._running = false;\n            }\n        }\n        _getAnims(chart) {\n            const charts = this._charts;\n            let anims = charts.get(chart);\n            if (!anims) {\n                anims = {\n                    running: false,\n                    initial: true,\n                    items: [],\n                    listeners: {\n                        complete: [],\n                        progress: []\n                    }\n                };\n                charts.set(chart, anims);\n            }\n            return anims;\n        }\n        listen(chart, event, cb) {\n            this._getAnims(chart).listeners[event].push(cb);\n        }\n        add(chart, items) {\n            if (!items || !items.length) {\n                return;\n            }\n            this._getAnims(chart).items.push(...items);\n        }\n        has(chart) {\n            return this._getAnims(chart).items.length > 0;\n        }\n        start(chart) {\n            const anims = this._charts.get(chart);\n            if (!anims) {\n                return;\n            }\n            anims.running = true;\n            anims.start = Date.now();\n            anims.duration = anims.items.reduce((acc, cur) => Math.max(acc, cur._duration), 0);\n            this._refresh();\n        }\n        running(chart) {\n            if (!this._running) {\n                return false;\n            }\n            const anims = this._charts.get(chart);\n            if (!anims || !anims.running || !anims.items.length) {\n                return false;\n            }\n            return true;\n        }\n        stop(chart) {\n            const anims = this._charts.get(chart);\n            if (!anims || !anims.items.length) {\n                return;\n            }\n            const items = anims.items;\n            let i = items.length - 1;\n            for (; i >= 0; --i) {\n                items[i].cancel();\n            }\n            anims.items = [];\n            this._notify(chart, anims, Date.now(), 'complete');\n        }\n        remove(chart) {\n            return this._charts.delete(chart);\n        }\n    }\n    var animator = new Animator();\n\n    /*!\n * @kurkle/color v0.1.9\n * https://github.com/kurkle/color#readme\n * (c) 2020 Jukka Kurkela\n * Released under the MIT License\n */\n    const map = {0: 0, 1: 1, 2: 2, 3: 3, 4: 4, 5: 5, 6: 6, 7: 7, 8: 8, 9: 9, A: 10, B: 11, C: 12, D: 13, E: 14, F: 15, a: 10, b: 11, c: 12, d: 13, e: 14, f: 15};\n    const hex = '0123456789ABCDEF';\n    const h1 = (b) => hex[b & 0xF];\n    const h2 = (b) => hex[(b & 0xF0) >> 4] + hex[b & 0xF];\n    const eq = (b) => (((b & 0xF0) >> 4) === (b & 0xF));\n    function isShort(v) {\n        return eq(v.r) && eq(v.g) && eq(v.b) && eq(v.a);\n    }\n    function hexParse(str) {\n        var len = str.length;\n        var ret;\n        if (str[0] === '#') {\n            if (len === 4 || len === 5) {\n                ret = {\n                    r: 255 & map[str[1]] * 17,\n                    g: 255 & map[str[2]] * 17,\n                    b: 255 & map[str[3]] * 17,\n                    a: len === 5 ? map[str[4]] * 17 : 255\n                };\n            } else if (len === 7 || len === 9) {\n                ret = {\n                    r: map[str[1]] << 4 | map[str[2]],\n                    g: map[str[3]] << 4 | map[str[4]],\n                    b: map[str[5]] << 4 | map[str[6]],\n                    a: len === 9 ? (map[str[7]] << 4 | map[str[8]]) : 255\n                };\n            }\n        }\n        return ret;\n    }\n    function hexString(v) {\n        var f = isShort(v) ? h1 : h2;\n        return v\n            ? '#' + f(v.r) + f(v.g) + f(v.b) + (v.a < 255 ? f(v.a) : '')\n            : v;\n    }\n    function round(v) {\n        return v + 0.5 | 0;\n    }\n    const lim = (v, l, h) => Math.max(Math.min(v, h), l);\n    function p2b(v) {\n        return lim(round(v * 2.55), 0, 255);\n    }\n    function n2b(v) {\n        return lim(round(v * 255), 0, 255);\n    }\n    function b2n(v) {\n        return lim(round(v / 2.55) / 100, 0, 1);\n    }\n    function n2p(v) {\n        return lim(round(v * 100), 0, 100);\n    }\n    const RGB_RE = /^rgba?\\(\\s*([-+.\\d]+)(%)?[\\s,]+([-+.e\\d]+)(%)?[\\s,]+([-+.e\\d]+)(%)?(?:[\\s,/]+([-+.e\\d]+)(%)?)?\\s*\\)$/;\n    function rgbParse(str) {\n        const m = RGB_RE.exec(str);\n        let a = 255;\n        let r, g, b;\n        if (!m) {\n            return;\n        }\n        if (m[7] !== r) {\n            const v = +m[7];\n            a = 255 & (m[8] ? p2b(v) : v * 255);\n        }\n        r = +m[1];\n        g = +m[3];\n        b = +m[5];\n        r = 255 & (m[2] ? p2b(r) : r);\n        g = 255 & (m[4] ? p2b(g) : g);\n        b = 255 & (m[6] ? p2b(b) : b);\n        return {\n            r: r,\n            g: g,\n            b: b,\n            a: a\n        };\n    }\n    function rgbString(v) {\n        return v && (\n            v.a < 255\n                ? `rgba(${v.r}, ${v.g}, ${v.b}, ${b2n(v.a)})`\n                : `rgb(${v.r}, ${v.g}, ${v.b})`\n        );\n    }\n    const HUE_RE = /^(hsla?|hwb|hsv)\\(\\s*([-+.e\\d]+)(?:deg)?[\\s,]+([-+.e\\d]+)%[\\s,]+([-+.e\\d]+)%(?:[\\s,]+([-+.e\\d]+)(%)?)?\\s*\\)$/;\n    function hsl2rgbn(h, s, l) {\n        const a = s * Math.min(l, 1 - l);\n        const f = (n, k = (n + h / 30) % 12) => l - a * Math.max(Math.min(k - 3, 9 - k, 1), -1);\n        return [f(0), f(8), f(4)];\n    }\n    function hsv2rgbn(h, s, v) {\n        const f = (n, k = (n + h / 60) % 6) => v - v * s * Math.max(Math.min(k, 4 - k, 1), 0);\n        return [f(5), f(3), f(1)];\n    }\n    function hwb2rgbn(h, w, b) {\n        const rgb = hsl2rgbn(h, 1, 0.5);\n        let i;\n        if (w + b > 1) {\n            i = 1 / (w + b);\n            w *= i;\n            b *= i;\n        }\n        for (i = 0; i < 3; i++) {\n            rgb[i] *= 1 - w - b;\n            rgb[i] += w;\n        }\n        return rgb;\n    }\n    function rgb2hsl(v) {\n        const range = 255;\n        const r = v.r / range;\n        const g = v.g / range;\n        const b = v.b / range;\n        const max = Math.max(r, g, b);\n        const min = Math.min(r, g, b);\n        const l = (max + min) / 2;\n        let h, s, d;\n        if (max !== min) {\n            d = max - min;\n            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n            h = max === r\n                ? ((g - b) / d) + (g < b ? 6 : 0)\n                : max === g\n                    ? (b - r) / d + 2\n                    : (r - g) / d + 4;\n            h = h * 60 + 0.5;\n        }\n        return [h | 0, s || 0, l];\n    }\n    function calln(f, a, b, c) {\n        return (\n            Array.isArray(a)\n                ? f(a[0], a[1], a[2])\n                : f(a, b, c)\n        ).map(n2b);\n    }\n    function hsl2rgb(h, s, l) {\n        return calln(hsl2rgbn, h, s, l);\n    }\n    function hwb2rgb(h, w, b) {\n        return calln(hwb2rgbn, h, w, b);\n    }\n    function hsv2rgb(h, s, v) {\n        return calln(hsv2rgbn, h, s, v);\n    }\n    function hue(h) {\n        return (h % 360 + 360) % 360;\n    }\n    function hueParse(str) {\n        const m = HUE_RE.exec(str);\n        let a = 255;\n        let v;\n        if (!m) {\n            return;\n        }\n        if (m[5] !== v) {\n            a = m[6] ? p2b(+m[5]) : n2b(+m[5]);\n        }\n        const h = hue(+m[2]);\n        const p1 = +m[3] / 100;\n        const p2 = +m[4] / 100;\n        if (m[1] === 'hwb') {\n            v = hwb2rgb(h, p1, p2);\n        } else if (m[1] === 'hsv') {\n            v = hsv2rgb(h, p1, p2);\n        } else {\n            v = hsl2rgb(h, p1, p2);\n        }\n        return {\n            r: v[0],\n            g: v[1],\n            b: v[2],\n            a: a\n        };\n    }\n    function rotate(v, deg) {\n        var h = rgb2hsl(v);\n        h[0] = hue(h[0] + deg);\n        h = hsl2rgb(h);\n        v.r = h[0];\n        v.g = h[1];\n        v.b = h[2];\n    }\n    function hslString(v) {\n        if (!v) {\n            return;\n        }\n        const a = rgb2hsl(v);\n        const h = a[0];\n        const s = n2p(a[1]);\n        const l = n2p(a[2]);\n        return v.a < 255\n            ? `hsla(${h}, ${s}%, ${l}%, ${b2n(v.a)})`\n            : `hsl(${h}, ${s}%, ${l}%)`;\n    }\n    const map$1 = {\n        x: 'dark',\n        Z: 'light',\n        Y: 're',\n        X: 'blu',\n        W: 'gr',\n        V: 'medium',\n        U: 'slate',\n        A: 'ee',\n        T: 'ol',\n        S: 'or',\n        B: 'ra',\n        C: 'lateg',\n        D: 'ights',\n        R: 'in',\n        Q: 'turquois',\n        E: 'hi',\n        P: 'ro',\n        O: 'al',\n        N: 'le',\n        M: 'de',\n        L: 'yello',\n        F: 'en',\n        K: 'ch',\n        G: 'arks',\n        H: 'ea',\n        I: 'ightg',\n        J: 'wh'\n    };\n    const names = {\n        OiceXe: 'f0f8ff',\n        antiquewEte: 'faebd7',\n        aqua: 'ffff',\n        aquamarRe: '7fffd4',\n        azuY: 'f0ffff',\n        beige: 'f5f5dc',\n        bisque: 'ffe4c4',\n        black: '0',\n        blanKedOmond: 'ffebcd',\n        Xe: 'ff',\n        XeviTet: '8a2be2',\n        bPwn: 'a52a2a',\n        burlywood: 'deb887',\n        caMtXe: '5f9ea0',\n        KartYuse: '7fff00',\n        KocTate: 'd2691e',\n        cSO: 'ff7f50',\n        cSnflowerXe: '6495ed',\n        cSnsilk: 'fff8dc',\n        crimson: 'dc143c',\n        cyan: 'ffff',\n        xXe: '8b',\n        xcyan: '8b8b',\n        xgTMnPd: 'b8860b',\n        xWay: 'a9a9a9',\n        xgYF: '6400',\n        xgYy: 'a9a9a9',\n        xkhaki: 'bdb76b',\n        xmagFta: '8b008b',\n        xTivegYF: '556b2f',\n        xSange: 'ff8c00',\n        xScEd: '9932cc',\n        xYd: '8b0000',\n        xsOmon: 'e9967a',\n        xsHgYF: '8fbc8f',\n        xUXe: '483d8b',\n        xUWay: '2f4f4f',\n        xUgYy: '2f4f4f',\n        xQe: 'ced1',\n        xviTet: '9400d3',\n        dAppRk: 'ff1493',\n        dApskyXe: 'bfff',\n        dimWay: '696969',\n        dimgYy: '696969',\n        dodgerXe: '1e90ff',\n        fiYbrick: 'b22222',\n        flSOwEte: 'fffaf0',\n        foYstWAn: '228b22',\n        fuKsia: 'ff00ff',\n        gaRsbSo: 'dcdcdc',\n        ghostwEte: 'f8f8ff',\n        gTd: 'ffd700',\n        gTMnPd: 'daa520',\n        Way: '808080',\n        gYF: '8000',\n        gYFLw: 'adff2f',\n        gYy: '808080',\n        honeyMw: 'f0fff0',\n        hotpRk: 'ff69b4',\n        RdianYd: 'cd5c5c',\n        Rdigo: '4b0082',\n        ivSy: 'fffff0',\n        khaki: 'f0e68c',\n        lavFMr: 'e6e6fa',\n        lavFMrXsh: 'fff0f5',\n        lawngYF: '7cfc00',\n        NmoncEffon: 'fffacd',\n        ZXe: 'add8e6',\n        ZcSO: 'f08080',\n        Zcyan: 'e0ffff',\n        ZgTMnPdLw: 'fafad2',\n        ZWay: 'd3d3d3',\n        ZgYF: '90ee90',\n        ZgYy: 'd3d3d3',\n        ZpRk: 'ffb6c1',\n        ZsOmon: 'ffa07a',\n        ZsHgYF: '20b2aa',\n        ZskyXe: '87cefa',\n        ZUWay: '778899',\n        ZUgYy: '778899',\n        ZstAlXe: 'b0c4de',\n        ZLw: 'ffffe0',\n        lime: 'ff00',\n        limegYF: '32cd32',\n        lRF: 'faf0e6',\n        magFta: 'ff00ff',\n        maPon: '800000',\n        VaquamarRe: '66cdaa',\n        VXe: 'cd',\n        VScEd: 'ba55d3',\n        VpurpN: '9370db',\n        VsHgYF: '3cb371',\n        VUXe: '7b68ee',\n        VsprRggYF: 'fa9a',\n        VQe: '48d1cc',\n        VviTetYd: 'c71585',\n        midnightXe: '191970',\n        mRtcYam: 'f5fffa',\n        mistyPse: 'ffe4e1',\n        moccasR: 'ffe4b5',\n        navajowEte: 'ffdead',\n        navy: '80',\n        Tdlace: 'fdf5e6',\n        Tive: '808000',\n        TivedBb: '6b8e23',\n        Sange: 'ffa500',\n        SangeYd: 'ff4500',\n        ScEd: 'da70d6',\n        pOegTMnPd: 'eee8aa',\n        pOegYF: '98fb98',\n        pOeQe: 'afeeee',\n        pOeviTetYd: 'db7093',\n        papayawEp: 'ffefd5',\n        pHKpuff: 'ffdab9',\n        peru: 'cd853f',\n        pRk: 'ffc0cb',\n        plum: 'dda0dd',\n        powMrXe: 'b0e0e6',\n        purpN: '800080',\n        YbeccapurpN: '663399',\n        Yd: 'ff0000',\n        Psybrown: 'bc8f8f',\n        PyOXe: '4169e1',\n        saddNbPwn: '8b4513',\n        sOmon: 'fa8072',\n        sandybPwn: 'f4a460',\n        sHgYF: '2e8b57',\n        sHshell: 'fff5ee',\n        siFna: 'a0522d',\n        silver: 'c0c0c0',\n        skyXe: '87ceeb',\n        UXe: '6a5acd',\n        UWay: '708090',\n        UgYy: '708090',\n        snow: 'fffafa',\n        sprRggYF: 'ff7f',\n        stAlXe: '4682b4',\n        tan: 'd2b48c',\n        teO: '8080',\n        tEstN: 'd8bfd8',\n        tomato: 'ff6347',\n        Qe: '40e0d0',\n        viTet: 'ee82ee',\n        JHt: 'f5deb3',\n        wEte: 'ffffff',\n        wEtesmoke: 'f5f5f5',\n        Lw: 'ffff00',\n        LwgYF: '9acd32'\n    };\n    function unpack() {\n        const unpacked = {};\n        const keys = Object.keys(names);\n        const tkeys = Object.keys(map$1);\n        let i, j, k, ok, nk;\n        for (i = 0; i < keys.length; i++) {\n            ok = nk = keys[i];\n            for (j = 0; j < tkeys.length; j++) {\n                k = tkeys[j];\n                nk = nk.replace(k, map$1[k]);\n            }\n            k = parseInt(names[ok], 16);\n            unpacked[nk] = [k >> 16 & 0xFF, k >> 8 & 0xFF, k & 0xFF];\n        }\n        return unpacked;\n    }\n    let names$1;\n    function nameParse(str) {\n        if (!names$1) {\n            names$1 = unpack();\n            names$1.transparent = [0, 0, 0, 0];\n        }\n        const a = names$1[str.toLowerCase()];\n        return a && {\n            r: a[0],\n            g: a[1],\n            b: a[2],\n            a: a.length === 4 ? a[3] : 255\n        };\n    }\n    function modHSL(v, i, ratio) {\n        if (v) {\n            let tmp = rgb2hsl(v);\n            tmp[i] = Math.max(0, Math.min(tmp[i] + tmp[i] * ratio, i === 0 ? 360 : 1));\n            tmp = hsl2rgb(tmp);\n            v.r = tmp[0];\n            v.g = tmp[1];\n            v.b = tmp[2];\n        }\n    }\n    function clone$1(v, proto) {\n        return v ? Object.assign(proto || {}, v) : v;\n    }\n    function fromObject(input) {\n        var v = {r: 0, g: 0, b: 0, a: 255};\n        if (Array.isArray(input)) {\n            if (input.length >= 3) {\n                v = {r: input[0], g: input[1], b: input[2], a: 255};\n                if (input.length > 3) {\n                    v.a = n2b(input[3]);\n                }\n            }\n        } else {\n            v = clone$1(input, {r: 0, g: 0, b: 0, a: 1});\n            v.a = n2b(v.a);\n        }\n        return v;\n    }\n    function functionParse(str) {\n        if (str.charAt(0) === 'r') {\n            return rgbParse(str);\n        }\n        return hueParse(str);\n    }\n    class Color {\n        constructor(input) {\n            if (input instanceof Color) {\n                return input;\n            }\n            const type = typeof input;\n            let v;\n            if (type === 'object') {\n                v = fromObject(input);\n            } else if (type === 'string') {\n                v = hexParse(input) || nameParse(input) || functionParse(input);\n            }\n            this._rgb = v;\n            this._valid = !!v;\n        }\n        get valid() {\n            return this._valid;\n        }\n        get rgb() {\n            var v = clone$1(this._rgb);\n            if (v) {\n                v.a = b2n(v.a);\n            }\n            return v;\n        }\n        set rgb(obj) {\n            this._rgb = fromObject(obj);\n        }\n        rgbString() {\n            return this._valid ? rgbString(this._rgb) : this._rgb;\n        }\n        hexString() {\n            return this._valid ? hexString(this._rgb) : this._rgb;\n        }\n        hslString() {\n            return this._valid ? hslString(this._rgb) : this._rgb;\n        }\n        mix(color, weight) {\n            const me = this;\n            if (color) {\n                const c1 = me.rgb;\n                const c2 = color.rgb;\n                let w2;\n                const p = weight === w2 ? 0.5 : weight;\n                const w = 2 * p - 1;\n                const a = c1.a - c2.a;\n                const w1 = ((w * a === -1 ? w : (w + a) / (1 + w * a)) + 1) / 2.0;\n                w2 = 1 - w1;\n                c1.r = 0xFF & w1 * c1.r + w2 * c2.r + 0.5;\n                c1.g = 0xFF & w1 * c1.g + w2 * c2.g + 0.5;\n                c1.b = 0xFF & w1 * c1.b + w2 * c2.b + 0.5;\n                c1.a = p * c1.a + (1 - p) * c2.a;\n                me.rgb = c1;\n            }\n            return me;\n        }\n        clone() {\n            return new Color(this.rgb);\n        }\n        alpha(a) {\n            this._rgb.a = n2b(a);\n            return this;\n        }\n        clearer(ratio) {\n            const rgb = this._rgb;\n            rgb.a *= 1 - ratio;\n            return this;\n        }\n        greyscale() {\n            const rgb = this._rgb;\n            const val = round(rgb.r * 0.3 + rgb.g * 0.59 + rgb.b * 0.11);\n            rgb.r = rgb.g = rgb.b = val;\n            return this;\n        }\n        opaquer(ratio) {\n            const rgb = this._rgb;\n            rgb.a *= 1 + ratio;\n            return this;\n        }\n        negate() {\n            const v = this._rgb;\n            v.r = 255 - v.r;\n            v.g = 255 - v.g;\n            v.b = 255 - v.b;\n            return this;\n        }\n        lighten(ratio) {\n            modHSL(this._rgb, 2, ratio);\n            return this;\n        }\n        darken(ratio) {\n            modHSL(this._rgb, 2, -ratio);\n            return this;\n        }\n        saturate(ratio) {\n            modHSL(this._rgb, 1, ratio);\n            return this;\n        }\n        desaturate(ratio) {\n            modHSL(this._rgb, 1, -ratio);\n            return this;\n        }\n        rotate(deg) {\n            rotate(this._rgb, deg);\n            return this;\n        }\n    }\n    function index_esm(input) {\n        return new Color(input);\n    }\n\n    const isPatternOrGradient = (value) => value instanceof CanvasGradient || value instanceof CanvasPattern;\n    function color(value) {\n        return isPatternOrGradient(value) ? value : index_esm(value);\n    }\n    function getHoverColor(value) {\n        return isPatternOrGradient(value)\n            ? value\n            : index_esm(value).saturate(0.5).darken(0.1).hexString();\n    }\n\n    function noop() {}\n    const uid = (function() {\n        let id = 0;\n        return function() {\n            return id++;\n        };\n    }());\n    function isNullOrUndef(value) {\n        return value === null || typeof value === 'undefined';\n    }\n    function isArray(value) {\n        if (Array.isArray && Array.isArray(value)) {\n            return true;\n        }\n        const type = Object.prototype.toString.call(value);\n        if (type.substr(0, 7) === '[object' && type.substr(-6) === 'Array]') {\n            return true;\n        }\n        return false;\n    }\n    function isObject(value) {\n        return value !== null && Object.prototype.toString.call(value) === '[object Object]';\n    }\n    const isNumberFinite = (value) => (typeof value === 'number' || value instanceof Number) && isFinite(+value);\n    function finiteOrDefault(value, defaultValue) {\n        return isNumberFinite(value) ? value : defaultValue;\n    }\n    function valueOrDefault(value, defaultValue) {\n        return typeof value === 'undefined' ? defaultValue : value;\n    }\n    const toPercentage = (value, dimension) =>\n        typeof value === 'string' && value.endsWith('%') ?\n            parseFloat(value) / 100\n            : value / dimension;\n    const toDimension = (value, dimension) =>\n        typeof value === 'string' && value.endsWith('%') ?\n            parseFloat(value) / 100 * dimension\n            : +value;\n    function callback(fn, args, thisArg) {\n        if (fn && typeof fn.call === 'function') {\n            return fn.apply(thisArg, args);\n        }\n    }\n    function each(loopable, fn, thisArg, reverse) {\n        let i, len, keys;\n        if (isArray(loopable)) {\n            len = loopable.length;\n            if (reverse) {\n                for (i = len - 1; i >= 0; i--) {\n                    fn.call(thisArg, loopable[i], i);\n                }\n            } else {\n                for (i = 0; i < len; i++) {\n                    fn.call(thisArg, loopable[i], i);\n                }\n            }\n        } else if (isObject(loopable)) {\n            keys = Object.keys(loopable);\n            len = keys.length;\n            for (i = 0; i < len; i++) {\n                fn.call(thisArg, loopable[keys[i]], keys[i]);\n            }\n        }\n    }\n    function _elementsEqual(a0, a1) {\n        let i, ilen, v0, v1;\n        if (!a0 || !a1 || a0.length !== a1.length) {\n            return false;\n        }\n        for (i = 0, ilen = a0.length; i < ilen; ++i) {\n            v0 = a0[i];\n            v1 = a1[i];\n            if (v0.datasetIndex !== v1.datasetIndex || v0.index !== v1.index) {\n                return false;\n            }\n        }\n        return true;\n    }\n    function clone(source) {\n        if (isArray(source)) {\n            return source.map(clone);\n        }\n        if (isObject(source)) {\n            const target = Object.create(null);\n            const keys = Object.keys(source);\n            const klen = keys.length;\n            let k = 0;\n            for (; k < klen; ++k) {\n                target[keys[k]] = clone(source[keys[k]]);\n            }\n            return target;\n        }\n        return source;\n    }\n    function isValidKey(key) {\n        return ['__proto__', 'prototype', 'constructor'].indexOf(key) === -1;\n    }\n    function _merger(key, target, source, options) {\n        if (!isValidKey(key)) {\n            return;\n        }\n        const tval = target[key];\n        const sval = source[key];\n        if (isObject(tval) && isObject(sval)) {\n            merge(tval, sval, options);\n        } else {\n            target[key] = clone(sval);\n        }\n    }\n    function merge(target, source, options) {\n        const sources = isArray(source) ? source : [source];\n        const ilen = sources.length;\n        if (!isObject(target)) {\n            return target;\n        }\n        options = options || {};\n        const merger = options.merger || _merger;\n        for (let i = 0; i < ilen; ++i) {\n            source = sources[i];\n            if (!isObject(source)) {\n                continue;\n            }\n            const keys = Object.keys(source);\n            for (let k = 0, klen = keys.length; k < klen; ++k) {\n                merger(keys[k], target, source, options);\n            }\n        }\n        return target;\n    }\n    function mergeIf(target, source) {\n        return merge(target, source, {merger: _mergerIf});\n    }\n    function _mergerIf(key, target, source) {\n        if (!isValidKey(key)) {\n            return;\n        }\n        const tval = target[key];\n        const sval = source[key];\n        if (isObject(tval) && isObject(sval)) {\n            mergeIf(tval, sval);\n        } else if (!Object.prototype.hasOwnProperty.call(target, key)) {\n            target[key] = clone(sval);\n        }\n    }\n    function _deprecated(scope, value, previous, current) {\n        if (value !== undefined) {\n            console.warn(scope + ': \"' + previous +\n                '\" is deprecated. Please use \"' + current + '\" instead');\n        }\n    }\n    const emptyString = '';\n    const dot = '.';\n    function indexOfDotOrLength(key, start) {\n        const idx = key.indexOf(dot, start);\n        return idx === -1 ? key.length : idx;\n    }\n    function resolveObjectKey(obj, key) {\n        if (key === emptyString) {\n            return obj;\n        }\n        let pos = 0;\n        let idx = indexOfDotOrLength(key, pos);\n        while (obj && idx > pos) {\n            obj = obj[key.substr(pos, idx - pos)];\n            pos = idx + 1;\n            idx = indexOfDotOrLength(key, pos);\n        }\n        return obj;\n    }\n    function _capitalize(str) {\n        return str.charAt(0).toUpperCase() + str.slice(1);\n    }\n    const defined = (value) => typeof value !== 'undefined';\n    const isFunction = (value) => typeof value === 'function';\n    const setsEqual = (a, b) => {\n        if (a.size !== b.size) {\n            return false;\n        }\n        for (const item of a) {\n            if (!b.has(item)) {\n                return false;\n            }\n        }\n        return true;\n    };\n\n    const overrides = Object.create(null);\n    const descriptors = Object.create(null);\n    function getScope$1(node, key) {\n        if (!key) {\n            return node;\n        }\n        const keys = key.split('.');\n        for (let i = 0, n = keys.length; i < n; ++i) {\n            const k = keys[i];\n            node = node[k] || (node[k] = Object.create(null));\n        }\n        return node;\n    }\n    function set(root, scope, values) {\n        if (typeof scope === 'string') {\n            return merge(getScope$1(root, scope), values);\n        }\n        return merge(getScope$1(root, ''), scope);\n    }\n    class Defaults {\n        constructor(_descriptors) {\n            this.animation = undefined;\n            this.backgroundColor = 'rgba(0,0,0,0.1)';\n            this.borderColor = 'rgba(0,0,0,0.1)';\n            this.color = '#666';\n            this.datasets = {};\n            this.devicePixelRatio = (context) => context.chart.platform.getDevicePixelRatio();\n            this.elements = {};\n            this.events = [\n                'mousemove',\n                'mouseout',\n                'click',\n                'touchstart',\n                'touchmove'\n            ];\n            this.font = {\n                family: \"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif\",\n                size: 12,\n                style: 'normal',\n                lineHeight: 1.2,\n                weight: null\n            };\n            this.hover = {};\n            this.hoverBackgroundColor = (ctx, options) => getHoverColor(options.backgroundColor);\n            this.hoverBorderColor = (ctx, options) => getHoverColor(options.borderColor);\n            this.hoverColor = (ctx, options) => getHoverColor(options.color);\n            this.indexAxis = 'x';\n            this.interaction = {\n                mode: 'nearest',\n                intersect: true\n            };\n            this.maintainAspectRatio = true;\n            this.onHover = null;\n            this.onClick = null;\n            this.parsing = true;\n            this.plugins = {};\n            this.responsive = true;\n            this.scale = undefined;\n            this.scales = {};\n            this.showLine = true;\n            this.describe(_descriptors);\n        }\n        set(scope, values) {\n            return set(this, scope, values);\n        }\n        get(scope) {\n            return getScope$1(this, scope);\n        }\n        describe(scope, values) {\n            return set(descriptors, scope, values);\n        }\n        override(scope, values) {\n            return set(overrides, scope, values);\n        }\n        route(scope, name, targetScope, targetName) {\n            const scopeObject = getScope$1(this, scope);\n            const targetScopeObject = getScope$1(this, targetScope);\n            const privateName = '_' + name;\n            Object.defineProperties(scopeObject, {\n                [privateName]: {\n                    value: scopeObject[name],\n                    writable: true\n                },\n                [name]: {\n                    enumerable: true,\n                    get() {\n                        const local = this[privateName];\n                        const target = targetScopeObject[targetName];\n                        if (isObject(local)) {\n                            return Object.assign({}, target, local);\n                        }\n                        return valueOrDefault(local, target);\n                    },\n                    set(value) {\n                        this[privateName] = value;\n                    }\n                }\n            });\n        }\n    }\n    var defaults = new Defaults({\n        _scriptable: (name) => !name.startsWith('on'),\n        _indexable: (name) => name !== 'events',\n        hover: {\n            _fallback: 'interaction'\n        },\n        interaction: {\n            _scriptable: false,\n            _indexable: false,\n        }\n    });\n\n    const PI = Math.PI;\n    const TAU = 2 * PI;\n    const PITAU = TAU + PI;\n    const INFINITY = Number.POSITIVE_INFINITY;\n    const RAD_PER_DEG = PI / 180;\n    const HALF_PI = PI / 2;\n    const QUARTER_PI = PI / 4;\n    const TWO_THIRDS_PI = PI * 2 / 3;\n    const log10 = Math.log10;\n    const sign = Math.sign;\n    function niceNum(range) {\n        const niceRange = Math.pow(10, Math.floor(log10(range)));\n        const fraction = range / niceRange;\n        const niceFraction = fraction <= 1 ? 1 : fraction <= 2 ? 2 : fraction <= 5 ? 5 : 10;\n        return niceFraction * niceRange;\n    }\n    function _factorize(value) {\n        const result = [];\n        const sqrt = Math.sqrt(value);\n        let i;\n        for (i = 1; i < sqrt; i++) {\n            if (value % i === 0) {\n                result.push(i);\n                result.push(value / i);\n            }\n        }\n        if (sqrt === (sqrt | 0)) {\n            result.push(sqrt);\n        }\n        result.sort((a, b) => a - b).pop();\n        return result;\n    }\n    function isNumber(n) {\n        return !isNaN(parseFloat(n)) && isFinite(n);\n    }\n    function almostEquals(x, y, epsilon) {\n        return Math.abs(x - y) < epsilon;\n    }\n    function almostWhole(x, epsilon) {\n        const rounded = Math.round(x);\n        return ((rounded - epsilon) <= x) && ((rounded + epsilon) >= x);\n    }\n    function _setMinAndMaxByKey(array, target, property) {\n        let i, ilen, value;\n        for (i = 0, ilen = array.length; i < ilen; i++) {\n            value = array[i][property];\n            if (!isNaN(value)) {\n                target.min = Math.min(target.min, value);\n                target.max = Math.max(target.max, value);\n            }\n        }\n    }\n    function toRadians(degrees) {\n        return degrees * (PI / 180);\n    }\n    function toDegrees(radians) {\n        return radians * (180 / PI);\n    }\n    function _decimalPlaces(x) {\n        if (!isNumberFinite(x)) {\n            return;\n        }\n        let e = 1;\n        let p = 0;\n        while (Math.round(x * e) / e !== x) {\n            e *= 10;\n            p++;\n        }\n        return p;\n    }\n    function getAngleFromPoint(centrePoint, anglePoint) {\n        const distanceFromXCenter = anglePoint.x - centrePoint.x;\n        const distanceFromYCenter = anglePoint.y - centrePoint.y;\n        const radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);\n        let angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);\n        if (angle < (-0.5 * PI)) {\n            angle += TAU;\n        }\n        return {\n            angle,\n            distance: radialDistanceFromCenter\n        };\n    }\n    function distanceBetweenPoints(pt1, pt2) {\n        return Math.sqrt(Math.pow(pt2.x - pt1.x, 2) + Math.pow(pt2.y - pt1.y, 2));\n    }\n    function _angleDiff(a, b) {\n        return (a - b + PITAU) % TAU - PI;\n    }\n    function _normalizeAngle(a) {\n        return (a % TAU + TAU) % TAU;\n    }\n    function _angleBetween(angle, start, end, sameAngleIsFullCircle) {\n        const a = _normalizeAngle(angle);\n        const s = _normalizeAngle(start);\n        const e = _normalizeAngle(end);\n        const angleToStart = _normalizeAngle(s - a);\n        const angleToEnd = _normalizeAngle(e - a);\n        const startToAngle = _normalizeAngle(a - s);\n        const endToAngle = _normalizeAngle(a - e);\n        return a === s || a === e || (sameAngleIsFullCircle && s === e)\n            || (angleToStart > angleToEnd && startToAngle < endToAngle);\n    }\n    function _limitValue(value, min, max) {\n        return Math.max(min, Math.min(max, value));\n    }\n    function _int16Range(value) {\n        return _limitValue(value, -32768, 32767);\n    }\n\n    function toFontString(font) {\n        if (!font || isNullOrUndef(font.size) || isNullOrUndef(font.family)) {\n            return null;\n        }\n        return (font.style ? font.style + ' ' : '')\n            + (font.weight ? font.weight + ' ' : '')\n            + font.size + 'px '\n            + font.family;\n    }\n    function _measureText(ctx, data, gc, longest, string) {\n        let textWidth = data[string];\n        if (!textWidth) {\n            textWidth = data[string] = ctx.measureText(string).width;\n            gc.push(string);\n        }\n        if (textWidth > longest) {\n            longest = textWidth;\n        }\n        return longest;\n    }\n    function _longestText(ctx, font, arrayOfThings, cache) {\n        cache = cache || {};\n        let data = cache.data = cache.data || {};\n        let gc = cache.garbageCollect = cache.garbageCollect || [];\n        if (cache.font !== font) {\n            data = cache.data = {};\n            gc = cache.garbageCollect = [];\n            cache.font = font;\n        }\n        ctx.save();\n        ctx.font = font;\n        let longest = 0;\n        const ilen = arrayOfThings.length;\n        let i, j, jlen, thing, nestedThing;\n        for (i = 0; i < ilen; i++) {\n            thing = arrayOfThings[i];\n            if (thing !== undefined && thing !== null && isArray(thing) !== true) {\n                longest = _measureText(ctx, data, gc, longest, thing);\n            } else if (isArray(thing)) {\n                for (j = 0, jlen = thing.length; j < jlen; j++) {\n                    nestedThing = thing[j];\n                    if (nestedThing !== undefined && nestedThing !== null && !isArray(nestedThing)) {\n                        longest = _measureText(ctx, data, gc, longest, nestedThing);\n                    }\n                }\n            }\n        }\n        ctx.restore();\n        const gcLen = gc.length / 2;\n        if (gcLen > arrayOfThings.length) {\n            for (i = 0; i < gcLen; i++) {\n                delete data[gc[i]];\n            }\n            gc.splice(0, gcLen);\n        }\n        return longest;\n    }\n    function _alignPixel(chart, pixel, width) {\n        const devicePixelRatio = chart.currentDevicePixelRatio;\n        const halfWidth = width !== 0 ? Math.max(width / 2, 0.5) : 0;\n        return Math.round((pixel - halfWidth) * devicePixelRatio) / devicePixelRatio + halfWidth;\n    }\n    function clearCanvas(canvas, ctx) {\n        ctx = ctx || canvas.getContext('2d');\n        ctx.save();\n        ctx.resetTransform();\n        ctx.clearRect(0, 0, canvas.width, canvas.height);\n        ctx.restore();\n    }\n    function drawPoint(ctx, options, x, y) {\n        let type, xOffset, yOffset, size, cornerRadius;\n        const style = options.pointStyle;\n        const rotation = options.rotation;\n        const radius = options.radius;\n        let rad = (rotation || 0) * RAD_PER_DEG;\n        if (style && typeof style === 'object') {\n            type = style.toString();\n            if (type === '[object HTMLImageElement]' || type === '[object HTMLCanvasElement]') {\n                ctx.save();\n                ctx.translate(x, y);\n                ctx.rotate(rad);\n                ctx.drawImage(style, -style.width / 2, -style.height / 2, style.width, style.height);\n                ctx.restore();\n                return;\n            }\n        }\n        if (isNaN(radius) || radius <= 0) {\n            return;\n        }\n        ctx.beginPath();\n        switch (style) {\n            default:\n                ctx.arc(x, y, radius, 0, TAU);\n                ctx.closePath();\n                break;\n            case 'triangle':\n                ctx.moveTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);\n                rad += TWO_THIRDS_PI;\n                ctx.lineTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);\n                rad += TWO_THIRDS_PI;\n                ctx.lineTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);\n                ctx.closePath();\n                break;\n            case 'rectRounded':\n                cornerRadius = radius * 0.516;\n                size = radius - cornerRadius;\n                xOffset = Math.cos(rad + QUARTER_PI) * size;\n                yOffset = Math.sin(rad + QUARTER_PI) * size;\n                ctx.arc(x - xOffset, y - yOffset, cornerRadius, rad - PI, rad - HALF_PI);\n                ctx.arc(x + yOffset, y - xOffset, cornerRadius, rad - HALF_PI, rad);\n                ctx.arc(x + xOffset, y + yOffset, cornerRadius, rad, rad + HALF_PI);\n                ctx.arc(x - yOffset, y + xOffset, cornerRadius, rad + HALF_PI, rad + PI);\n                ctx.closePath();\n                break;\n            case 'rect':\n                if (!rotation) {\n                    size = Math.SQRT1_2 * radius;\n                    ctx.rect(x - size, y - size, 2 * size, 2 * size);\n                    break;\n                }\n                rad += QUARTER_PI;\n            case 'rectRot':\n                xOffset = Math.cos(rad) * radius;\n                yOffset = Math.sin(rad) * radius;\n                ctx.moveTo(x - xOffset, y - yOffset);\n                ctx.lineTo(x + yOffset, y - xOffset);\n                ctx.lineTo(x + xOffset, y + yOffset);\n                ctx.lineTo(x - yOffset, y + xOffset);\n                ctx.closePath();\n                break;\n            case 'crossRot':\n                rad += QUARTER_PI;\n            case 'cross':\n                xOffset = Math.cos(rad) * radius;\n                yOffset = Math.sin(rad) * radius;\n                ctx.moveTo(x - xOffset, y - yOffset);\n                ctx.lineTo(x + xOffset, y + yOffset);\n                ctx.moveTo(x + yOffset, y - xOffset);\n                ctx.lineTo(x - yOffset, y + xOffset);\n                break;\n            case 'star':\n                xOffset = Math.cos(rad) * radius;\n                yOffset = Math.sin(rad) * radius;\n                ctx.moveTo(x - xOffset, y - yOffset);\n                ctx.lineTo(x + xOffset, y + yOffset);\n                ctx.moveTo(x + yOffset, y - xOffset);\n                ctx.lineTo(x - yOffset, y + xOffset);\n                rad += QUARTER_PI;\n                xOffset = Math.cos(rad) * radius;\n                yOffset = Math.sin(rad) * radius;\n                ctx.moveTo(x - xOffset, y - yOffset);\n                ctx.lineTo(x + xOffset, y + yOffset);\n                ctx.moveTo(x + yOffset, y - xOffset);\n                ctx.lineTo(x - yOffset, y + xOffset);\n                break;\n            case 'line':\n                xOffset = Math.cos(rad) * radius;\n                yOffset = Math.sin(rad) * radius;\n                ctx.moveTo(x - xOffset, y - yOffset);\n                ctx.lineTo(x + xOffset, y + yOffset);\n                break;\n            case 'dash':\n                ctx.moveTo(x, y);\n                ctx.lineTo(x + Math.cos(rad) * radius, y + Math.sin(rad) * radius);\n                break;\n        }\n        ctx.fill();\n        if (options.borderWidth > 0) {\n            ctx.stroke();\n        }\n    }\n    function _isPointInArea(point, area, margin) {\n        margin = margin || 0.5;\n        return point && point.x > area.left - margin && point.x < area.right + margin &&\n            point.y > area.top - margin && point.y < area.bottom + margin;\n    }\n    function clipArea(ctx, area) {\n        ctx.save();\n        ctx.beginPath();\n        ctx.rect(area.left, area.top, area.right - area.left, area.bottom - area.top);\n        ctx.clip();\n    }\n    function unclipArea(ctx) {\n        ctx.restore();\n    }\n    function _steppedLineTo(ctx, previous, target, flip, mode) {\n        if (!previous) {\n            return ctx.lineTo(target.x, target.y);\n        }\n        if (mode === 'middle') {\n            const midpoint = (previous.x + target.x) / 2.0;\n            ctx.lineTo(midpoint, previous.y);\n            ctx.lineTo(midpoint, target.y);\n        } else if (mode === 'after' !== !!flip) {\n            ctx.lineTo(previous.x, target.y);\n        } else {\n            ctx.lineTo(target.x, previous.y);\n        }\n        ctx.lineTo(target.x, target.y);\n    }\n    function _bezierCurveTo(ctx, previous, target, flip) {\n        if (!previous) {\n            return ctx.lineTo(target.x, target.y);\n        }\n        ctx.bezierCurveTo(\n            flip ? previous.cp1x : previous.cp2x,\n            flip ? previous.cp1y : previous.cp2y,\n            flip ? target.cp2x : target.cp1x,\n            flip ? target.cp2y : target.cp1y,\n            target.x,\n            target.y);\n    }\n    function renderText(ctx, text, x, y, font, opts = {}) {\n        const lines = isArray(text) ? text : [text];\n        const stroke = opts.strokeWidth > 0 && opts.strokeColor !== '';\n        let i, line;\n        ctx.save();\n        if (opts.translation) {\n            ctx.translate(opts.translation[0], opts.translation[1]);\n        }\n        if (!isNullOrUndef(opts.rotation)) {\n            ctx.rotate(opts.rotation);\n        }\n        ctx.font = font.string;\n        if (opts.color) {\n            ctx.fillStyle = opts.color;\n        }\n        if (opts.textAlign) {\n            ctx.textAlign = opts.textAlign;\n        }\n        if (opts.textBaseline) {\n            ctx.textBaseline = opts.textBaseline;\n        }\n        for (i = 0; i < lines.length; ++i) {\n            line = lines[i];\n            if (stroke) {\n                if (opts.strokeColor) {\n                    ctx.strokeStyle = opts.strokeColor;\n                }\n                if (!isNullOrUndef(opts.strokeWidth)) {\n                    ctx.lineWidth = opts.strokeWidth;\n                }\n                ctx.strokeText(line, x, y, opts.maxWidth);\n            }\n            ctx.fillText(line, x, y, opts.maxWidth);\n            if (opts.strikethrough || opts.underline) {\n                const metrics = ctx.measureText(line);\n                const left = x - metrics.actualBoundingBoxLeft;\n                const right = x + metrics.actualBoundingBoxRight;\n                const top = y - metrics.actualBoundingBoxAscent;\n                const bottom = y + metrics.actualBoundingBoxDescent;\n                const yDecoration = opts.strikethrough ? (top + bottom) / 2 : bottom;\n                ctx.strokeStyle = ctx.fillStyle;\n                ctx.beginPath();\n                ctx.lineWidth = opts.decorationWidth || 2;\n                ctx.moveTo(left, yDecoration);\n                ctx.lineTo(right, yDecoration);\n                ctx.stroke();\n            }\n            y += font.lineHeight;\n        }\n        ctx.restore();\n    }\n    function addRoundedRectPath(ctx, rect) {\n        const {x, y, w, h, radius} = rect;\n        ctx.arc(x + radius.topLeft, y + radius.topLeft, radius.topLeft, -HALF_PI, PI, true);\n        ctx.lineTo(x, y + h - radius.bottomLeft);\n        ctx.arc(x + radius.bottomLeft, y + h - radius.bottomLeft, radius.bottomLeft, PI, HALF_PI, true);\n        ctx.lineTo(x + w - radius.bottomRight, y + h);\n        ctx.arc(x + w - radius.bottomRight, y + h - radius.bottomRight, radius.bottomRight, HALF_PI, 0, true);\n        ctx.lineTo(x + w, y + radius.topRight);\n        ctx.arc(x + w - radius.topRight, y + radius.topRight, radius.topRight, 0, -HALF_PI, true);\n        ctx.lineTo(x + radius.topLeft, y);\n    }\n\n    function _lookup(table, value, cmp) {\n        cmp = cmp || ((index) => table[index] < value);\n        let hi = table.length - 1;\n        let lo = 0;\n        let mid;\n        while (hi - lo > 1) {\n            mid = (lo + hi) >> 1;\n            if (cmp(mid)) {\n                lo = mid;\n            } else {\n                hi = mid;\n            }\n        }\n        return {lo, hi};\n    }\n    const _lookupByKey = (table, key, value) =>\n        _lookup(table, value, index => table[index][key] < value);\n    const _rlookupByKey = (table, key, value) =>\n        _lookup(table, value, index => table[index][key] >= value);\n    function _filterBetween(values, min, max) {\n        let start = 0;\n        let end = values.length;\n        while (start < end && values[start] < min) {\n            start++;\n        }\n        while (end > start && values[end - 1] > max) {\n            end--;\n        }\n        return start > 0 || end < values.length\n            ? values.slice(start, end)\n            : values;\n    }\n    const arrayEvents = ['push', 'pop', 'shift', 'splice', 'unshift'];\n    function listenArrayEvents(array, listener) {\n        if (array._chartjs) {\n            array._chartjs.listeners.push(listener);\n            return;\n        }\n        Object.defineProperty(array, '_chartjs', {\n            configurable: true,\n            enumerable: false,\n            value: {\n                listeners: [listener]\n            }\n        });\n        arrayEvents.forEach((key) => {\n            const method = '_onData' + _capitalize(key);\n            const base = array[key];\n            Object.defineProperty(array, key, {\n                configurable: true,\n                enumerable: false,\n                value(...args) {\n                    const res = base.apply(this, args);\n                    array._chartjs.listeners.forEach((object) => {\n                        if (typeof object[method] === 'function') {\n                            object[method](...args);\n                        }\n                    });\n                    return res;\n                }\n            });\n        });\n    }\n    function unlistenArrayEvents(array, listener) {\n        const stub = array._chartjs;\n        if (!stub) {\n            return;\n        }\n        const listeners = stub.listeners;\n        const index = listeners.indexOf(listener);\n        if (index !== -1) {\n            listeners.splice(index, 1);\n        }\n        if (listeners.length > 0) {\n            return;\n        }\n        arrayEvents.forEach((key) => {\n            delete array[key];\n        });\n        delete array._chartjs;\n    }\n    function _arrayUnique(items) {\n        const set = new Set();\n        let i, ilen;\n        for (i = 0, ilen = items.length; i < ilen; ++i) {\n            set.add(items[i]);\n        }\n        if (set.size === ilen) {\n            return items;\n        }\n        const result = [];\n        set.forEach(item => {\n            result.push(item);\n        });\n        return result;\n    }\n\n    function _getParentNode(domNode) {\n        let parent = domNode.parentNode;\n        if (parent && parent.toString() === '[object ShadowRoot]') {\n            parent = parent.host;\n        }\n        return parent;\n    }\n    function parseMaxStyle(styleValue, node, parentProperty) {\n        let valueInPixels;\n        if (typeof styleValue === 'string') {\n            valueInPixels = parseInt(styleValue, 10);\n            if (styleValue.indexOf('%') !== -1) {\n                valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];\n            }\n        } else {\n            valueInPixels = styleValue;\n        }\n        return valueInPixels;\n    }\n    const getComputedStyle = (element) => window.getComputedStyle(element, null);\n    function getStyle(el, property) {\n        return getComputedStyle(el).getPropertyValue(property);\n    }\n    const positions = ['top', 'right', 'bottom', 'left'];\n    function getPositionedStyle(styles, style, suffix) {\n        const result = {};\n        suffix = suffix ? '-' + suffix : '';\n        for (let i = 0; i < 4; i++) {\n            const pos = positions[i];\n            result[pos] = parseFloat(styles[style + '-' + pos + suffix]) || 0;\n        }\n        result.width = result.left + result.right;\n        result.height = result.top + result.bottom;\n        return result;\n    }\n    const useOffsetPos = (x, y, target) => (x > 0 || y > 0) && (!target || !target.shadowRoot);\n    function getCanvasPosition(evt, canvas) {\n        const e = evt.native || evt;\n        const touches = e.touches;\n        const source = touches && touches.length ? touches[0] : e;\n        const {offsetX, offsetY} = source;\n        let box = false;\n        let x, y;\n        if (useOffsetPos(offsetX, offsetY, e.target)) {\n            x = offsetX;\n            y = offsetY;\n        } else {\n            const rect = canvas.getBoundingClientRect();\n            x = source.clientX - rect.left;\n            y = source.clientY - rect.top;\n            box = true;\n        }\n        return {x, y, box};\n    }\n    function getRelativePosition$1(evt, chart) {\n        const {canvas, currentDevicePixelRatio} = chart;\n        const style = getComputedStyle(canvas);\n        const borderBox = style.boxSizing === 'border-box';\n        const paddings = getPositionedStyle(style, 'padding');\n        const borders = getPositionedStyle(style, 'border', 'width');\n        const {x, y, box} = getCanvasPosition(evt, canvas);\n        const xOffset = paddings.left + (box && borders.left);\n        const yOffset = paddings.top + (box && borders.top);\n        let {width, height} = chart;\n        if (borderBox) {\n            width -= paddings.width + borders.width;\n            height -= paddings.height + borders.height;\n        }\n        return {\n            x: Math.round((x - xOffset) / width * canvas.width / currentDevicePixelRatio),\n            y: Math.round((y - yOffset) / height * canvas.height / currentDevicePixelRatio)\n        };\n    }\n    function getContainerSize(canvas, width, height) {\n        let maxWidth, maxHeight;\n        if (width === undefined || height === undefined) {\n            const container = _getParentNode(canvas);\n            if (!container) {\n                width = canvas.clientWidth;\n                height = canvas.clientHeight;\n            } else {\n                const rect = container.getBoundingClientRect();\n                const containerStyle = getComputedStyle(container);\n                const containerBorder = getPositionedStyle(containerStyle, 'border', 'width');\n                const containerPadding = getPositionedStyle(containerStyle, 'padding');\n                width = rect.width - containerPadding.width - containerBorder.width;\n                height = rect.height - containerPadding.height - containerBorder.height;\n                maxWidth = parseMaxStyle(containerStyle.maxWidth, container, 'clientWidth');\n                maxHeight = parseMaxStyle(containerStyle.maxHeight, container, 'clientHeight');\n            }\n        }\n        return {\n            width,\n            height,\n            maxWidth: maxWidth || INFINITY,\n            maxHeight: maxHeight || INFINITY\n        };\n    }\n    const round1 = v => Math.round(v * 10) / 10;\n    function getMaximumSize(canvas, bbWidth, bbHeight, aspectRatio) {\n        const style = getComputedStyle(canvas);\n        const margins = getPositionedStyle(style, 'margin');\n        const maxWidth = parseMaxStyle(style.maxWidth, canvas, 'clientWidth') || INFINITY;\n        const maxHeight = parseMaxStyle(style.maxHeight, canvas, 'clientHeight') || INFINITY;\n        const containerSize = getContainerSize(canvas, bbWidth, bbHeight);\n        let {width, height} = containerSize;\n        if (style.boxSizing === 'content-box') {\n            const borders = getPositionedStyle(style, 'border', 'width');\n            const paddings = getPositionedStyle(style, 'padding');\n            width -= paddings.width + borders.width;\n            height -= paddings.height + borders.height;\n        }\n        width = Math.max(0, width - margins.width);\n        height = Math.max(0, aspectRatio ? Math.floor(width / aspectRatio) : height - margins.height);\n        width = round1(Math.min(width, maxWidth, containerSize.maxWidth));\n        height = round1(Math.min(height, maxHeight, containerSize.maxHeight));\n        if (width && !height) {\n            height = round1(width / 2);\n        }\n        return {\n            width,\n            height\n        };\n    }\n    function retinaScale(chart, forceRatio, forceStyle) {\n        const pixelRatio = forceRatio || 1;\n        const deviceHeight = Math.floor(chart.height * pixelRatio);\n        const deviceWidth = Math.floor(chart.width * pixelRatio);\n        chart.height = deviceHeight / pixelRatio;\n        chart.width = deviceWidth / pixelRatio;\n        const canvas = chart.canvas;\n        if (canvas.style && (forceStyle || (!canvas.style.height && !canvas.style.width))) {\n            canvas.style.height = `${chart.height}px`;\n            canvas.style.width = `${chart.width}px`;\n        }\n        if (chart.currentDevicePixelRatio !== pixelRatio\n            || canvas.height !== deviceHeight\n            || canvas.width !== deviceWidth) {\n            chart.currentDevicePixelRatio = pixelRatio;\n            canvas.height = deviceHeight;\n            canvas.width = deviceWidth;\n            chart.ctx.setTransform(pixelRatio, 0, 0, pixelRatio, 0, 0);\n            return true;\n        }\n        return false;\n    }\n    const supportsEventListenerOptions = (function() {\n        let passiveSupported = false;\n        try {\n            const options = {\n                get passive() {\n                    passiveSupported = true;\n                    return false;\n                }\n            };\n            window.addEventListener('test', null, options);\n            window.removeEventListener('test', null, options);\n        } catch (e) {\n        }\n        return passiveSupported;\n    }());\n    function readUsedSize(element, property) {\n        const value = getStyle(element, property);\n        const matches = value && value.match(/^(\\d+)(\\.\\d+)?px$/);\n        return matches ? +matches[1] : undefined;\n    }\n\n    function getRelativePosition(e, chart) {\n        if ('native' in e) {\n            return {\n                x: e.x,\n                y: e.y\n            };\n        }\n        return getRelativePosition$1(e, chart);\n    }\n    function evaluateAllVisibleItems(chart, handler) {\n        const metasets = chart.getSortedVisibleDatasetMetas();\n        let index, data, element;\n        for (let i = 0, ilen = metasets.length; i < ilen; ++i) {\n            ({index, data} = metasets[i]);\n            for (let j = 0, jlen = data.length; j < jlen; ++j) {\n                element = data[j];\n                if (!element.skip) {\n                    handler(element, index, j);\n                }\n            }\n        }\n    }\n    function binarySearch(metaset, axis, value, intersect) {\n        const {controller, data, _sorted} = metaset;\n        const iScale = controller._cachedMeta.iScale;\n        if (iScale && axis === iScale.axis && _sorted && data.length) {\n            const lookupMethod = iScale._reversePixels ? _rlookupByKey : _lookupByKey;\n            if (!intersect) {\n                return lookupMethod(data, axis, value);\n            } else if (controller._sharedOptions) {\n                const el = data[0];\n                const range = typeof el.getRange === 'function' && el.getRange(axis);\n                if (range) {\n                    const start = lookupMethod(data, axis, value - range);\n                    const end = lookupMethod(data, axis, value + range);\n                    return {lo: start.lo, hi: end.hi};\n                }\n            }\n        }\n        return {lo: 0, hi: data.length - 1};\n    }\n    function optimizedEvaluateItems(chart, axis, position, handler, intersect) {\n        const metasets = chart.getSortedVisibleDatasetMetas();\n        const value = position[axis];\n        for (let i = 0, ilen = metasets.length; i < ilen; ++i) {\n            const {index, data} = metasets[i];\n            const {lo, hi} = binarySearch(metasets[i], axis, value, intersect);\n            for (let j = lo; j <= hi; ++j) {\n                const element = data[j];\n                if (!element.skip) {\n                    handler(element, index, j);\n                }\n            }\n        }\n    }\n    function getDistanceMetricForAxis(axis) {\n        const useX = axis.indexOf('x') !== -1;\n        const useY = axis.indexOf('y') !== -1;\n        return function(pt1, pt2) {\n            const deltaX = useX ? Math.abs(pt1.x - pt2.x) : 0;\n            const deltaY = useY ? Math.abs(pt1.y - pt2.y) : 0;\n            return Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));\n        };\n    }\n    function getIntersectItems(chart, position, axis, useFinalPosition) {\n        const items = [];\n        if (!_isPointInArea(position, chart.chartArea, chart._minPadding)) {\n            return items;\n        }\n        const evaluationFunc = function(element, datasetIndex, index) {\n            if (element.inRange(position.x, position.y, useFinalPosition)) {\n                items.push({element, datasetIndex, index});\n            }\n        };\n        optimizedEvaluateItems(chart, axis, position, evaluationFunc, true);\n        return items;\n    }\n    function getNearestItems(chart, position, axis, intersect, useFinalPosition) {\n        const distanceMetric = getDistanceMetricForAxis(axis);\n        let minDistance = Number.POSITIVE_INFINITY;\n        let items = [];\n        if (!_isPointInArea(position, chart.chartArea, chart._minPadding)) {\n            return items;\n        }\n        const evaluationFunc = function(element, datasetIndex, index) {\n            if (intersect && !element.inRange(position.x, position.y, useFinalPosition)) {\n                return;\n            }\n            const center = element.getCenterPoint(useFinalPosition);\n            if (!_isPointInArea(center, chart.chartArea, chart._minPadding)) {\n                return;\n            }\n            const distance = distanceMetric(position, center);\n            if (distance < minDistance) {\n                items = [{element, datasetIndex, index}];\n                minDistance = distance;\n            } else if (distance === minDistance) {\n                items.push({element, datasetIndex, index});\n            }\n        };\n        optimizedEvaluateItems(chart, axis, position, evaluationFunc);\n        return items;\n    }\n    function getAxisItems(chart, e, options, useFinalPosition) {\n        const position = getRelativePosition(e, chart);\n        const items = [];\n        const axis = options.axis;\n        const rangeMethod = axis === 'x' ? 'inXRange' : 'inYRange';\n        let intersectsItem = false;\n        evaluateAllVisibleItems(chart, (element, datasetIndex, index) => {\n            if (element[rangeMethod](position[axis], useFinalPosition)) {\n                items.push({element, datasetIndex, index});\n            }\n            if (element.inRange(position.x, position.y, useFinalPosition)) {\n                intersectsItem = true;\n            }\n        });\n        if (options.intersect && !intersectsItem) {\n            return [];\n        }\n        return items;\n    }\n    var Interaction = {\n        modes: {\n            index(chart, e, options, useFinalPosition) {\n                const position = getRelativePosition(e, chart);\n                const axis = options.axis || 'x';\n                const items = options.intersect\n                    ? getIntersectItems(chart, position, axis, useFinalPosition)\n                    : getNearestItems(chart, position, axis, false, useFinalPosition);\n                const elements = [];\n                if (!items.length) {\n                    return [];\n                }\n                chart.getSortedVisibleDatasetMetas().forEach((meta) => {\n                    const index = items[0].index;\n                    const element = meta.data[index];\n                    if (element && !element.skip) {\n                        elements.push({element, datasetIndex: meta.index, index});\n                    }\n                });\n                return elements;\n            },\n            dataset(chart, e, options, useFinalPosition) {\n                const position = getRelativePosition(e, chart);\n                const axis = options.axis || 'xy';\n                let items = options.intersect\n                    ? getIntersectItems(chart, position, axis, useFinalPosition) :\n                    getNearestItems(chart, position, axis, false, useFinalPosition);\n                if (items.length > 0) {\n                    const datasetIndex = items[0].datasetIndex;\n                    const data = chart.getDatasetMeta(datasetIndex).data;\n                    items = [];\n                    for (let i = 0; i < data.length; ++i) {\n                        items.push({element: data[i], datasetIndex, index: i});\n                    }\n                }\n                return items;\n            },\n            point(chart, e, options, useFinalPosition) {\n                const position = getRelativePosition(e, chart);\n                const axis = options.axis || 'xy';\n                return getIntersectItems(chart, position, axis, useFinalPosition);\n            },\n            nearest(chart, e, options, useFinalPosition) {\n                const position = getRelativePosition(e, chart);\n                const axis = options.axis || 'xy';\n                return getNearestItems(chart, position, axis, options.intersect, useFinalPosition);\n            },\n            x(chart, e, options, useFinalPosition) {\n                options.axis = 'x';\n                return getAxisItems(chart, e, options, useFinalPosition);\n            },\n            y(chart, e, options, useFinalPosition) {\n                options.axis = 'y';\n                return getAxisItems(chart, e, options, useFinalPosition);\n            }\n        }\n    };\n\n    const LINE_HEIGHT = new RegExp(/^(normal|(\\d+(?:\\.\\d+)?)(px|em|%)?)$/);\n    const FONT_STYLE = new RegExp(/^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/);\n    function toLineHeight(value, size) {\n        const matches = ('' + value).match(LINE_HEIGHT);\n        if (!matches || matches[1] === 'normal') {\n            return size * 1.2;\n        }\n        value = +matches[2];\n        switch (matches[3]) {\n            case 'px':\n                return value;\n            case '%':\n                value /= 100;\n                break;\n        }\n        return size * value;\n    }\n    const numberOrZero$1 = v => +v || 0;\n    function _readValueToProps(value, props) {\n        const ret = {};\n        const objProps = isObject(props);\n        const keys = objProps ? Object.keys(props) : props;\n        const read = isObject(value)\n            ? objProps\n                ? prop => valueOrDefault(value[prop], value[props[prop]])\n                : prop => value[prop]\n            : () => value;\n        for (const prop of keys) {\n            ret[prop] = numberOrZero$1(read(prop));\n        }\n        return ret;\n    }\n    function toTRBL(value) {\n        return _readValueToProps(value, {top: 'y', right: 'x', bottom: 'y', left: 'x'});\n    }\n    function toTRBLCorners(value) {\n        return _readValueToProps(value, ['topLeft', 'topRight', 'bottomLeft', 'bottomRight']);\n    }\n    function toPadding(value) {\n        const obj = toTRBL(value);\n        obj.width = obj.left + obj.right;\n        obj.height = obj.top + obj.bottom;\n        return obj;\n    }\n    function toFont(options, fallback) {\n        options = options || {};\n        fallback = fallback || defaults.font;\n        let size = valueOrDefault(options.size, fallback.size);\n        if (typeof size === 'string') {\n            size = parseInt(size, 10);\n        }\n        let style = valueOrDefault(options.style, fallback.style);\n        if (style && !('' + style).match(FONT_STYLE)) {\n            console.warn('Invalid font style specified: \"' + style + '\"');\n            style = '';\n        }\n        const font = {\n            family: valueOrDefault(options.family, fallback.family),\n            lineHeight: toLineHeight(valueOrDefault(options.lineHeight, fallback.lineHeight), size),\n            size,\n            style,\n            weight: valueOrDefault(options.weight, fallback.weight),\n            string: ''\n        };\n        font.string = toFontString(font);\n        return font;\n    }\n    function resolve(inputs, context, index, info) {\n        let cacheable = true;\n        let i, ilen, value;\n        for (i = 0, ilen = inputs.length; i < ilen; ++i) {\n            value = inputs[i];\n            if (value === undefined) {\n                continue;\n            }\n            if (context !== undefined && typeof value === 'function') {\n                value = value(context);\n                cacheable = false;\n            }\n            if (index !== undefined && isArray(value)) {\n                value = value[index % value.length];\n                cacheable = false;\n            }\n            if (value !== undefined) {\n                if (info && !cacheable) {\n                    info.cacheable = false;\n                }\n                return value;\n            }\n        }\n    }\n    function _addGrace(minmax, grace) {\n        const {min, max} = minmax;\n        return {\n            min: min - Math.abs(toDimension(grace, min)),\n            max: max + toDimension(grace, max)\n        };\n    }\n\n    const STATIC_POSITIONS = ['left', 'top', 'right', 'bottom'];\n    function filterByPosition(array, position) {\n        return array.filter(v => v.pos === position);\n    }\n    function filterDynamicPositionByAxis(array, axis) {\n        return array.filter(v => STATIC_POSITIONS.indexOf(v.pos) === -1 && v.box.axis === axis);\n    }\n    function sortByWeight(array, reverse) {\n        return array.sort((a, b) => {\n            const v0 = reverse ? b : a;\n            const v1 = reverse ? a : b;\n            return v0.weight === v1.weight ?\n                v0.index - v1.index :\n                v0.weight - v1.weight;\n        });\n    }\n    function wrapBoxes(boxes) {\n        const layoutBoxes = [];\n        let i, ilen, box;\n        for (i = 0, ilen = (boxes || []).length; i < ilen; ++i) {\n            box = boxes[i];\n            layoutBoxes.push({\n                index: i,\n                box,\n                pos: box.position,\n                horizontal: box.isHorizontal(),\n                weight: box.weight\n            });\n        }\n        return layoutBoxes;\n    }\n    function setLayoutDims(layouts, params) {\n        let i, ilen, layout;\n        for (i = 0, ilen = layouts.length; i < ilen; ++i) {\n            layout = layouts[i];\n            if (layout.horizontal) {\n                layout.width = layout.box.fullSize && params.availableWidth;\n                layout.height = params.hBoxMaxHeight;\n            } else {\n                layout.width = params.vBoxMaxWidth;\n                layout.height = layout.box.fullSize && params.availableHeight;\n            }\n        }\n    }\n    function buildLayoutBoxes(boxes) {\n        const layoutBoxes = wrapBoxes(boxes);\n        const fullSize = sortByWeight(layoutBoxes.filter(wrap => wrap.box.fullSize), true);\n        const left = sortByWeight(filterByPosition(layoutBoxes, 'left'), true);\n        const right = sortByWeight(filterByPosition(layoutBoxes, 'right'));\n        const top = sortByWeight(filterByPosition(layoutBoxes, 'top'), true);\n        const bottom = sortByWeight(filterByPosition(layoutBoxes, 'bottom'));\n        const centerHorizontal = filterDynamicPositionByAxis(layoutBoxes, 'x');\n        const centerVertical = filterDynamicPositionByAxis(layoutBoxes, 'y');\n        return {\n            fullSize,\n            leftAndTop: left.concat(top),\n            rightAndBottom: right.concat(centerVertical).concat(bottom).concat(centerHorizontal),\n            chartArea: filterByPosition(layoutBoxes, 'chartArea'),\n            vertical: left.concat(right).concat(centerVertical),\n            horizontal: top.concat(bottom).concat(centerHorizontal)\n        };\n    }\n    function getCombinedMax(maxPadding, chartArea, a, b) {\n        return Math.max(maxPadding[a], chartArea[a]) + Math.max(maxPadding[b], chartArea[b]);\n    }\n    function updateMaxPadding(maxPadding, boxPadding) {\n        maxPadding.top = Math.max(maxPadding.top, boxPadding.top);\n        maxPadding.left = Math.max(maxPadding.left, boxPadding.left);\n        maxPadding.bottom = Math.max(maxPadding.bottom, boxPadding.bottom);\n        maxPadding.right = Math.max(maxPadding.right, boxPadding.right);\n    }\n    function updateDims(chartArea, params, layout) {\n        const box = layout.box;\n        const maxPadding = chartArea.maxPadding;\n        if (!isObject(layout.pos)) {\n            if (layout.size) {\n                chartArea[layout.pos] -= layout.size;\n            }\n            layout.size = layout.horizontal ? box.height : box.width;\n            chartArea[layout.pos] += layout.size;\n        }\n        if (box.getPadding) {\n            updateMaxPadding(maxPadding, box.getPadding());\n        }\n        const newWidth = Math.max(0, params.outerWidth - getCombinedMax(maxPadding, chartArea, 'left', 'right'));\n        const newHeight = Math.max(0, params.outerHeight - getCombinedMax(maxPadding, chartArea, 'top', 'bottom'));\n        const widthChanged = newWidth !== chartArea.w;\n        const heightChanged = newHeight !== chartArea.h;\n        chartArea.w = newWidth;\n        chartArea.h = newHeight;\n        return layout.horizontal\n            ? {same: widthChanged, other: heightChanged}\n            : {same: heightChanged, other: widthChanged};\n    }\n    function handleMaxPadding(chartArea) {\n        const maxPadding = chartArea.maxPadding;\n        function updatePos(pos) {\n            const change = Math.max(maxPadding[pos] - chartArea[pos], 0);\n            chartArea[pos] += change;\n            return change;\n        }\n        chartArea.y += updatePos('top');\n        chartArea.x += updatePos('left');\n        updatePos('right');\n        updatePos('bottom');\n    }\n    function getMargins(horizontal, chartArea) {\n        const maxPadding = chartArea.maxPadding;\n        function marginForPositions(positions) {\n            const margin = {left: 0, top: 0, right: 0, bottom: 0};\n            positions.forEach((pos) => {\n                margin[pos] = Math.max(chartArea[pos], maxPadding[pos]);\n            });\n            return margin;\n        }\n        return horizontal\n            ? marginForPositions(['left', 'right'])\n            : marginForPositions(['top', 'bottom']);\n    }\n    function fitBoxes(boxes, chartArea, params) {\n        const refitBoxes = [];\n        let i, ilen, layout, box, refit, changed;\n        for (i = 0, ilen = boxes.length, refit = 0; i < ilen; ++i) {\n            layout = boxes[i];\n            box = layout.box;\n            box.update(\n                layout.width || chartArea.w,\n                layout.height || chartArea.h,\n                getMargins(layout.horizontal, chartArea)\n            );\n            const {same, other} = updateDims(chartArea, params, layout);\n            refit |= same && refitBoxes.length;\n            changed = changed || other;\n            if (!box.fullSize) {\n                refitBoxes.push(layout);\n            }\n        }\n        return refit && fitBoxes(refitBoxes, chartArea, params) || changed;\n    }\n    function placeBoxes(boxes, chartArea, params) {\n        const userPadding = params.padding;\n        let x = chartArea.x;\n        let y = chartArea.y;\n        let i, ilen, layout, box;\n        for (i = 0, ilen = boxes.length; i < ilen; ++i) {\n            layout = boxes[i];\n            box = layout.box;\n            if (layout.horizontal) {\n                box.left = box.fullSize ? userPadding.left : chartArea.left;\n                box.right = box.fullSize ? params.outerWidth - userPadding.right : chartArea.left + chartArea.w;\n                box.top = y;\n                box.bottom = y + box.height;\n                box.width = box.right - box.left;\n                y = box.bottom;\n            } else {\n                box.left = x;\n                box.right = x + box.width;\n                box.top = box.fullSize ? userPadding.top : chartArea.top;\n                box.bottom = box.fullSize ? params.outerHeight - userPadding.right : chartArea.top + chartArea.h;\n                box.height = box.bottom - box.top;\n                x = box.right;\n            }\n        }\n        chartArea.x = x;\n        chartArea.y = y;\n    }\n    defaults.set('layout', {\n        padding: {\n            top: 0,\n            right: 0,\n            bottom: 0,\n            left: 0\n        }\n    });\n    var layouts = {\n        addBox(chart, item) {\n            if (!chart.boxes) {\n                chart.boxes = [];\n            }\n            item.fullSize = item.fullSize || false;\n            item.position = item.position || 'top';\n            item.weight = item.weight || 0;\n            item._layers = item._layers || function() {\n                return [{\n                    z: 0,\n                    draw(chartArea) {\n                        item.draw(chartArea);\n                    }\n                }];\n            };\n            chart.boxes.push(item);\n        },\n        removeBox(chart, layoutItem) {\n            const index = chart.boxes ? chart.boxes.indexOf(layoutItem) : -1;\n            if (index !== -1) {\n                chart.boxes.splice(index, 1);\n            }\n        },\n        configure(chart, item, options) {\n            item.fullSize = options.fullSize;\n            item.position = options.position;\n            item.weight = options.weight;\n        },\n        update(chart, width, height, minPadding) {\n            if (!chart) {\n                return;\n            }\n            const padding = toPadding(chart.options.layout.padding);\n            const availableWidth = Math.max(width - padding.width, 0);\n            const availableHeight = Math.max(height - padding.height, 0);\n            const boxes = buildLayoutBoxes(chart.boxes);\n            const verticalBoxes = boxes.vertical;\n            const horizontalBoxes = boxes.horizontal;\n            each(chart.boxes, box => {\n                if (typeof box.beforeLayout === 'function') {\n                    box.beforeLayout();\n                }\n            });\n            const visibleVerticalBoxCount = verticalBoxes.reduce((total, wrap) =>\n                wrap.box.options && wrap.box.options.display === false ? total : total + 1, 0) || 1;\n            const params = Object.freeze({\n                outerWidth: width,\n                outerHeight: height,\n                padding,\n                availableWidth,\n                availableHeight,\n                vBoxMaxWidth: availableWidth / 2 / visibleVerticalBoxCount,\n                hBoxMaxHeight: availableHeight / 2\n            });\n            const maxPadding = Object.assign({}, padding);\n            updateMaxPadding(maxPadding, toPadding(minPadding));\n            const chartArea = Object.assign({\n                maxPadding,\n                w: availableWidth,\n                h: availableHeight,\n                x: padding.left,\n                y: padding.top\n            }, padding);\n            setLayoutDims(verticalBoxes.concat(horizontalBoxes), params);\n            fitBoxes(boxes.fullSize, chartArea, params);\n            fitBoxes(verticalBoxes, chartArea, params);\n            if (fitBoxes(horizontalBoxes, chartArea, params)) {\n                fitBoxes(verticalBoxes, chartArea, params);\n            }\n            handleMaxPadding(chartArea);\n            placeBoxes(boxes.leftAndTop, chartArea, params);\n            chartArea.x += chartArea.w;\n            chartArea.y += chartArea.h;\n            placeBoxes(boxes.rightAndBottom, chartArea, params);\n            chart.chartArea = {\n                left: chartArea.left,\n                top: chartArea.top,\n                right: chartArea.left + chartArea.w,\n                bottom: chartArea.top + chartArea.h,\n                height: chartArea.h,\n                width: chartArea.w,\n            };\n            each(boxes.chartArea, (layout) => {\n                const box = layout.box;\n                Object.assign(box, chart.chartArea);\n                box.update(chartArea.w, chartArea.h);\n            });\n        }\n    };\n\n    class BasePlatform {\n        acquireContext(canvas, aspectRatio) {}\n        releaseContext(context) {\n            return false;\n        }\n        addEventListener(chart, type, listener) {}\n        removeEventListener(chart, type, listener) {}\n        getDevicePixelRatio() {\n            return 1;\n        }\n        getMaximumSize(element, width, height, aspectRatio) {\n            width = Math.max(0, width || element.width);\n            height = height || element.height;\n            return {\n                width,\n                height: Math.max(0, aspectRatio ? Math.floor(width / aspectRatio) : height)\n            };\n        }\n        isAttached(canvas) {\n            return true;\n        }\n    }\n\n    class BasicPlatform extends BasePlatform {\n        acquireContext(item) {\n            return item && item.getContext && item.getContext('2d') || null;\n        }\n    }\n\n    const EXPANDO_KEY = '$chartjs';\n    const EVENT_TYPES = {\n        touchstart: 'mousedown',\n        touchmove: 'mousemove',\n        touchend: 'mouseup',\n        pointerenter: 'mouseenter',\n        pointerdown: 'mousedown',\n        pointermove: 'mousemove',\n        pointerup: 'mouseup',\n        pointerleave: 'mouseout',\n        pointerout: 'mouseout'\n    };\n    const isNullOrEmpty = value => value === null || value === '';\n    function initCanvas(canvas, aspectRatio) {\n        const style = canvas.style;\n        const renderHeight = canvas.getAttribute('height');\n        const renderWidth = canvas.getAttribute('width');\n        canvas[EXPANDO_KEY] = {\n            initial: {\n                height: renderHeight,\n                width: renderWidth,\n                style: {\n                    display: style.display,\n                    height: style.height,\n                    width: style.width\n                }\n            }\n        };\n        style.display = style.display || 'block';\n        style.boxSizing = style.boxSizing || 'border-box';\n        if (isNullOrEmpty(renderWidth)) {\n            const displayWidth = readUsedSize(canvas, 'width');\n            if (displayWidth !== undefined) {\n                canvas.width = displayWidth;\n            }\n        }\n        if (isNullOrEmpty(renderHeight)) {\n            if (canvas.style.height === '') {\n                canvas.height = canvas.width / (aspectRatio || 2);\n            } else {\n                const displayHeight = readUsedSize(canvas, 'height');\n                if (displayHeight !== undefined) {\n                    canvas.height = displayHeight;\n                }\n            }\n        }\n        return canvas;\n    }\n    const eventListenerOptions = supportsEventListenerOptions ? {passive: true} : false;\n    function addListener(node, type, listener) {\n        node.addEventListener(type, listener, eventListenerOptions);\n    }\n    function removeListener(chart, type, listener) {\n        chart.canvas.removeEventListener(type, listener, eventListenerOptions);\n    }\n    function fromNativeEvent(event, chart) {\n        const type = EVENT_TYPES[event.type] || event.type;\n        const {x, y} = getRelativePosition$1(event, chart);\n        return {\n            type,\n            chart,\n            native: event,\n            x: x !== undefined ? x : null,\n            y: y !== undefined ? y : null,\n        };\n    }\n    function createAttachObserver(chart, type, listener) {\n        const canvas = chart.canvas;\n        const container = canvas && _getParentNode(canvas);\n        const element = container || canvas;\n        const observer = new MutationObserver(entries => {\n            const parent = _getParentNode(element);\n            entries.forEach(entry => {\n                for (let i = 0; i < entry.addedNodes.length; i++) {\n                    const added = entry.addedNodes[i];\n                    if (added === element || added === parent) {\n                        listener(entry.target);\n                    }\n                }\n            });\n        });\n        observer.observe(document, {childList: true, subtree: true});\n        return observer;\n    }\n    function createDetachObserver(chart, type, listener) {\n        const canvas = chart.canvas;\n        const container = canvas && _getParentNode(canvas);\n        if (!container) {\n            return;\n        }\n        const observer = new MutationObserver(entries => {\n            entries.forEach(entry => {\n                for (let i = 0; i < entry.removedNodes.length; i++) {\n                    if (entry.removedNodes[i] === canvas) {\n                        listener();\n                        break;\n                    }\n                }\n            });\n        });\n        observer.observe(container, {childList: true});\n        return observer;\n    }\n    const drpListeningCharts = new Map();\n    let oldDevicePixelRatio = 0;\n    function onWindowResize() {\n        const dpr = window.devicePixelRatio;\n        if (dpr === oldDevicePixelRatio) {\n            return;\n        }\n        oldDevicePixelRatio = dpr;\n        drpListeningCharts.forEach((resize, chart) => {\n            if (chart.currentDevicePixelRatio !== dpr) {\n                resize();\n            }\n        });\n    }\n    function listenDevicePixelRatioChanges(chart, resize) {\n        if (!drpListeningCharts.size) {\n            window.addEventListener('resize', onWindowResize);\n        }\n        drpListeningCharts.set(chart, resize);\n    }\n    function unlistenDevicePixelRatioChanges(chart) {\n        drpListeningCharts.delete(chart);\n        if (!drpListeningCharts.size) {\n            window.removeEventListener('resize', onWindowResize);\n        }\n    }\n    function createResizeObserver(chart, type, listener) {\n        const canvas = chart.canvas;\n        const container = canvas && _getParentNode(canvas);\n        if (!container) {\n            return;\n        }\n        const resize = throttled((width, height) => {\n            const w = container.clientWidth;\n            listener(width, height);\n            if (w < container.clientWidth) {\n                listener();\n            }\n        }, window);\n        const observer = new ResizeObserver(entries => {\n            const entry = entries[0];\n            const width = entry.contentRect.width;\n            const height = entry.contentRect.height;\n            if (width === 0 && height === 0) {\n                return;\n            }\n            resize(width, height);\n        });\n        observer.observe(container);\n        listenDevicePixelRatioChanges(chart, resize);\n        return observer;\n    }\n    function releaseObserver(chart, type, observer) {\n        if (observer) {\n            observer.disconnect();\n        }\n        if (type === 'resize') {\n            unlistenDevicePixelRatioChanges(chart);\n        }\n    }\n    function createProxyAndListen(chart, type, listener) {\n        const canvas = chart.canvas;\n        const proxy = throttled((event) => {\n            if (chart.ctx !== null) {\n                listener(fromNativeEvent(event, chart));\n            }\n        }, chart, (args) => {\n            const event = args[0];\n            return [event, event.offsetX, event.offsetY];\n        });\n        addListener(canvas, type, proxy);\n        return proxy;\n    }\n    class DomPlatform extends BasePlatform {\n        acquireContext(canvas, aspectRatio) {\n            const context = canvas && canvas.getContext && canvas.getContext('2d');\n            if (context && context.canvas === canvas) {\n                initCanvas(canvas, aspectRatio);\n                return context;\n            }\n            return null;\n        }\n        releaseContext(context) {\n            const canvas = context.canvas;\n            if (!canvas[EXPANDO_KEY]) {\n                return false;\n            }\n            const initial = canvas[EXPANDO_KEY].initial;\n            ['height', 'width'].forEach((prop) => {\n                const value = initial[prop];\n                if (isNullOrUndef(value)) {\n                    canvas.removeAttribute(prop);\n                } else {\n                    canvas.setAttribute(prop, value);\n                }\n            });\n            const style = initial.style || {};\n            Object.keys(style).forEach((key) => {\n                canvas.style[key] = style[key];\n            });\n            canvas.width = canvas.width;\n            delete canvas[EXPANDO_KEY];\n            return true;\n        }\n        addEventListener(chart, type, listener) {\n            this.removeEventListener(chart, type);\n            const proxies = chart.$proxies || (chart.$proxies = {});\n            const handlers = {\n                attach: createAttachObserver,\n                detach: createDetachObserver,\n                resize: createResizeObserver\n            };\n            const handler = handlers[type] || createProxyAndListen;\n            proxies[type] = handler(chart, type, listener);\n        }\n        removeEventListener(chart, type) {\n            const proxies = chart.$proxies || (chart.$proxies = {});\n            const proxy = proxies[type];\n            if (!proxy) {\n                return;\n            }\n            const handlers = {\n                attach: releaseObserver,\n                detach: releaseObserver,\n                resize: releaseObserver\n            };\n            const handler = handlers[type] || removeListener;\n            handler(chart, type, proxy);\n            proxies[type] = undefined;\n        }\n        getDevicePixelRatio() {\n            return window.devicePixelRatio;\n        }\n        getMaximumSize(canvas, width, height, aspectRatio) {\n            return getMaximumSize(canvas, width, height, aspectRatio);\n        }\n        isAttached(canvas) {\n            const container = _getParentNode(canvas);\n            return !!(container && _getParentNode(container));\n        }\n    }\n\n    var platforms = /*#__PURE__*/Object.freeze({\n        __proto__: null,\n        BasePlatform: BasePlatform,\n        BasicPlatform: BasicPlatform,\n        DomPlatform: DomPlatform\n    });\n\n    const atEdge = (t) => t === 0 || t === 1;\n    const elasticIn = (t, s, p) => -(Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * TAU / p));\n    const elasticOut = (t, s, p) => Math.pow(2, -10 * t) * Math.sin((t - s) * TAU / p) + 1;\n    const effects = {\n        linear: t => t,\n        easeInQuad: t => t * t,\n        easeOutQuad: t => -t * (t - 2),\n        easeInOutQuad: t => ((t /= 0.5) < 1)\n            ? 0.5 * t * t\n            : -0.5 * ((--t) * (t - 2) - 1),\n        easeInCubic: t => t * t * t,\n        easeOutCubic: t => (t -= 1) * t * t + 1,\n        easeInOutCubic: t => ((t /= 0.5) < 1)\n            ? 0.5 * t * t * t\n            : 0.5 * ((t -= 2) * t * t + 2),\n        easeInQuart: t => t * t * t * t,\n        easeOutQuart: t => -((t -= 1) * t * t * t - 1),\n        easeInOutQuart: t => ((t /= 0.5) < 1)\n            ? 0.5 * t * t * t * t\n            : -0.5 * ((t -= 2) * t * t * t - 2),\n        easeInQuint: t => t * t * t * t * t,\n        easeOutQuint: t => (t -= 1) * t * t * t * t + 1,\n        easeInOutQuint: t => ((t /= 0.5) < 1)\n            ? 0.5 * t * t * t * t * t\n            : 0.5 * ((t -= 2) * t * t * t * t + 2),\n        easeInSine: t => -Math.cos(t * HALF_PI) + 1,\n        easeOutSine: t => Math.sin(t * HALF_PI),\n        easeInOutSine: t => -0.5 * (Math.cos(PI * t) - 1),\n        easeInExpo: t => (t === 0) ? 0 : Math.pow(2, 10 * (t - 1)),\n        easeOutExpo: t => (t === 1) ? 1 : -Math.pow(2, -10 * t) + 1,\n        easeInOutExpo: t => atEdge(t) ? t : t < 0.5\n            ? 0.5 * Math.pow(2, 10 * (t * 2 - 1))\n            : 0.5 * (-Math.pow(2, -10 * (t * 2 - 1)) + 2),\n        easeInCirc: t => (t >= 1) ? t : -(Math.sqrt(1 - t * t) - 1),\n        easeOutCirc: t => Math.sqrt(1 - (t -= 1) * t),\n        easeInOutCirc: t => ((t /= 0.5) < 1)\n            ? -0.5 * (Math.sqrt(1 - t * t) - 1)\n            : 0.5 * (Math.sqrt(1 - (t -= 2) * t) + 1),\n        easeInElastic: t => atEdge(t) ? t : elasticIn(t, 0.075, 0.3),\n        easeOutElastic: t => atEdge(t) ? t : elasticOut(t, 0.075, 0.3),\n        easeInOutElastic(t) {\n            const s = 0.1125;\n            const p = 0.45;\n            return atEdge(t) ? t :\n                t < 0.5\n                    ? 0.5 * elasticIn(t * 2, s, p)\n                    : 0.5 + 0.5 * elasticOut(t * 2 - 1, s, p);\n        },\n        easeInBack(t) {\n            const s = 1.70158;\n            return t * t * ((s + 1) * t - s);\n        },\n        easeOutBack(t) {\n            const s = 1.70158;\n            return (t -= 1) * t * ((s + 1) * t + s) + 1;\n        },\n        easeInOutBack(t) {\n            let s = 1.70158;\n            if ((t /= 0.5) < 1) {\n                return 0.5 * (t * t * (((s *= (1.525)) + 1) * t - s));\n            }\n            return 0.5 * ((t -= 2) * t * (((s *= (1.525)) + 1) * t + s) + 2);\n        },\n        easeInBounce: t => 1 - effects.easeOutBounce(1 - t),\n        easeOutBounce(t) {\n            const m = 7.5625;\n            const d = 2.75;\n            if (t < (1 / d)) {\n                return m * t * t;\n            }\n            if (t < (2 / d)) {\n                return m * (t -= (1.5 / d)) * t + 0.75;\n            }\n            if (t < (2.5 / d)) {\n                return m * (t -= (2.25 / d)) * t + 0.9375;\n            }\n            return m * (t -= (2.625 / d)) * t + 0.984375;\n        },\n        easeInOutBounce: t => (t < 0.5)\n            ? effects.easeInBounce(t * 2) * 0.5\n            : effects.easeOutBounce(t * 2 - 1) * 0.5 + 0.5,\n    };\n\n    const transparent = 'transparent';\n    const interpolators = {\n        boolean(from, to, factor) {\n            return factor > 0.5 ? to : from;\n        },\n        color(from, to, factor) {\n            const c0 = color(from || transparent);\n            const c1 = c0.valid && color(to || transparent);\n            return c1 && c1.valid\n                ? c1.mix(c0, factor).hexString()\n                : to;\n        },\n        number(from, to, factor) {\n            return from + (to - from) * factor;\n        }\n    };\n    class Animation {\n        constructor(cfg, target, prop, to) {\n            const currentValue = target[prop];\n            to = resolve([cfg.to, to, currentValue, cfg.from]);\n            const from = resolve([cfg.from, currentValue, to]);\n            this._active = true;\n            this._fn = cfg.fn || interpolators[cfg.type || typeof from];\n            this._easing = effects[cfg.easing] || effects.linear;\n            this._start = Math.floor(Date.now() + (cfg.delay || 0));\n            this._duration = this._total = Math.floor(cfg.duration);\n            this._loop = !!cfg.loop;\n            this._target = target;\n            this._prop = prop;\n            this._from = from;\n            this._to = to;\n            this._promises = undefined;\n        }\n        active() {\n            return this._active;\n        }\n        update(cfg, to, date) {\n            const me = this;\n            if (me._active) {\n                me._notify(false);\n                const currentValue = me._target[me._prop];\n                const elapsed = date - me._start;\n                const remain = me._duration - elapsed;\n                me._start = date;\n                me._duration = Math.floor(Math.max(remain, cfg.duration));\n                me._total += elapsed;\n                me._loop = !!cfg.loop;\n                me._to = resolve([cfg.to, to, currentValue, cfg.from]);\n                me._from = resolve([cfg.from, currentValue, to]);\n            }\n        }\n        cancel() {\n            const me = this;\n            if (me._active) {\n                me.tick(Date.now());\n                me._active = false;\n                me._notify(false);\n            }\n        }\n        tick(date) {\n            const me = this;\n            const elapsed = date - me._start;\n            const duration = me._duration;\n            const prop = me._prop;\n            const from = me._from;\n            const loop = me._loop;\n            const to = me._to;\n            let factor;\n            me._active = from !== to && (loop || (elapsed < duration));\n            if (!me._active) {\n                me._target[prop] = to;\n                me._notify(true);\n                return;\n            }\n            if (elapsed < 0) {\n                me._target[prop] = from;\n                return;\n            }\n            factor = (elapsed / duration) % 2;\n            factor = loop && factor > 1 ? 2 - factor : factor;\n            factor = me._easing(Math.min(1, Math.max(0, factor)));\n            me._target[prop] = me._fn(from, to, factor);\n        }\n        wait() {\n            const promises = this._promises || (this._promises = []);\n            return new Promise((res, rej) => {\n                promises.push({res, rej});\n            });\n        }\n        _notify(resolved) {\n            const method = resolved ? 'res' : 'rej';\n            const promises = this._promises || [];\n            for (let i = 0; i < promises.length; i++) {\n                promises[i][method]();\n            }\n        }\n    }\n\n    const numbers = ['x', 'y', 'borderWidth', 'radius', 'tension'];\n    const colors = ['color', 'borderColor', 'backgroundColor'];\n    defaults.set('animation', {\n        delay: undefined,\n        duration: 1000,\n        easing: 'easeOutQuart',\n        fn: undefined,\n        from: undefined,\n        loop: undefined,\n        to: undefined,\n        type: undefined,\n    });\n    const animationOptions = Object.keys(defaults.animation);\n    defaults.describe('animation', {\n        _fallback: false,\n        _indexable: false,\n        _scriptable: (name) => name !== 'onProgress' && name !== 'onComplete' && name !== 'fn',\n    });\n    defaults.set('animations', {\n        colors: {\n            type: 'color',\n            properties: colors\n        },\n        numbers: {\n            type: 'number',\n            properties: numbers\n        },\n    });\n    defaults.describe('animations', {\n        _fallback: 'animation',\n    });\n    defaults.set('transitions', {\n        active: {\n            animation: {\n                duration: 400\n            }\n        },\n        resize: {\n            animation: {\n                duration: 0\n            }\n        },\n        show: {\n            animations: {\n                colors: {\n                    from: 'transparent'\n                },\n                visible: {\n                    type: 'boolean',\n                    duration: 0\n                },\n            }\n        },\n        hide: {\n            animations: {\n                colors: {\n                    to: 'transparent'\n                },\n                visible: {\n                    type: 'boolean',\n                    easing: 'linear',\n                    fn: v => v | 0\n                },\n            }\n        }\n    });\n    class Animations {\n        constructor(chart, config) {\n            this._chart = chart;\n            this._properties = new Map();\n            this.configure(config);\n        }\n        configure(config) {\n            if (!isObject(config)) {\n                return;\n            }\n            const animatedProps = this._properties;\n            Object.getOwnPropertyNames(config).forEach(key => {\n                const cfg = config[key];\n                if (!isObject(cfg)) {\n                    return;\n                }\n                const resolved = {};\n                for (const option of animationOptions) {\n                    resolved[option] = cfg[option];\n                }\n                (isArray(cfg.properties) && cfg.properties || [key]).forEach((prop) => {\n                    if (prop === key || !animatedProps.has(prop)) {\n                        animatedProps.set(prop, resolved);\n                    }\n                });\n            });\n        }\n        _animateOptions(target, values) {\n            const newOptions = values.options;\n            const options = resolveTargetOptions(target, newOptions);\n            if (!options) {\n                return [];\n            }\n            const animations = this._createAnimations(options, newOptions);\n            if (newOptions.$shared) {\n                awaitAll(target.options.$animations, newOptions).then(() => {\n                    target.options = newOptions;\n                }, () => {\n                });\n            }\n            return animations;\n        }\n        _createAnimations(target, values) {\n            const animatedProps = this._properties;\n            const animations = [];\n            const running = target.$animations || (target.$animations = {});\n            const props = Object.keys(values);\n            const date = Date.now();\n            let i;\n            for (i = props.length - 1; i >= 0; --i) {\n                const prop = props[i];\n                if (prop.charAt(0) === '$') {\n                    continue;\n                }\n                if (prop === 'options') {\n                    animations.push(...this._animateOptions(target, values));\n                    continue;\n                }\n                const value = values[prop];\n                let animation = running[prop];\n                const cfg = animatedProps.get(prop);\n                if (animation) {\n                    if (cfg && animation.active()) {\n                        animation.update(cfg, value, date);\n                        continue;\n                    } else {\n                        animation.cancel();\n                    }\n                }\n                if (!cfg || !cfg.duration) {\n                    target[prop] = value;\n                    continue;\n                }\n                running[prop] = animation = new Animation(cfg, target, prop, value);\n                animations.push(animation);\n            }\n            return animations;\n        }\n        update(target, values) {\n            if (this._properties.size === 0) {\n                Object.assign(target, values);\n                return;\n            }\n            const animations = this._createAnimations(target, values);\n            if (animations.length) {\n                animator.add(this._chart, animations);\n                return true;\n            }\n        }\n    }\n    function awaitAll(animations, properties) {\n        const running = [];\n        const keys = Object.keys(properties);\n        for (let i = 0; i < keys.length; i++) {\n            const anim = animations[keys[i]];\n            if (anim && anim.active()) {\n                running.push(anim.wait());\n            }\n        }\n        return Promise.all(running);\n    }\n    function resolveTargetOptions(target, newOptions) {\n        if (!newOptions) {\n            return;\n        }\n        let options = target.options;\n        if (!options) {\n            target.options = newOptions;\n            return;\n        }\n        if (options.$shared) {\n            target.options = options = Object.assign({}, options, {$shared: false, $animations: {}});\n        }\n        return options;\n    }\n\n    function scaleClip(scale, allowedOverflow) {\n        const opts = scale && scale.options || {};\n        const reverse = opts.reverse;\n        const min = opts.min === undefined ? allowedOverflow : 0;\n        const max = opts.max === undefined ? allowedOverflow : 0;\n        return {\n            start: reverse ? max : min,\n            end: reverse ? min : max\n        };\n    }\n    function defaultClip(xScale, yScale, allowedOverflow) {\n        if (allowedOverflow === false) {\n            return false;\n        }\n        const x = scaleClip(xScale, allowedOverflow);\n        const y = scaleClip(yScale, allowedOverflow);\n        return {\n            top: y.end,\n            right: x.end,\n            bottom: y.start,\n            left: x.start\n        };\n    }\n    function toClip(value) {\n        let t, r, b, l;\n        if (isObject(value)) {\n            t = value.top;\n            r = value.right;\n            b = value.bottom;\n            l = value.left;\n        } else {\n            t = r = b = l = value;\n        }\n        return {\n            top: t,\n            right: r,\n            bottom: b,\n            left: l\n        };\n    }\n    function getSortedDatasetIndices(chart, filterVisible) {\n        const keys = [];\n        const metasets = chart._getSortedDatasetMetas(filterVisible);\n        let i, ilen;\n        for (i = 0, ilen = metasets.length; i < ilen; ++i) {\n            keys.push(metasets[i].index);\n        }\n        return keys;\n    }\n    function applyStack(stack, value, dsIndex, options) {\n        const keys = stack.keys;\n        const singleMode = options.mode === 'single';\n        let i, ilen, datasetIndex, otherValue;\n        if (value === null) {\n            return;\n        }\n        for (i = 0, ilen = keys.length; i < ilen; ++i) {\n            datasetIndex = +keys[i];\n            if (datasetIndex === dsIndex) {\n                if (options.all) {\n                    continue;\n                }\n                break;\n            }\n            otherValue = stack.values[datasetIndex];\n            if (isNumberFinite(otherValue) && (singleMode || (value === 0 || sign(value) === sign(otherValue)))) {\n                value += otherValue;\n            }\n        }\n        return value;\n    }\n    function convertObjectDataToArray(data) {\n        const keys = Object.keys(data);\n        const adata = new Array(keys.length);\n        let i, ilen, key;\n        for (i = 0, ilen = keys.length; i < ilen; ++i) {\n            key = keys[i];\n            adata[i] = {\n                x: key,\n                y: data[key]\n            };\n        }\n        return adata;\n    }\n    function isStacked(scale, meta) {\n        const stacked = scale && scale.options.stacked;\n        return stacked || (stacked === undefined && meta.stack !== undefined);\n    }\n    function getStackKey(indexScale, valueScale, meta) {\n        return `${indexScale.id}.${valueScale.id}.${meta.stack || meta.type}`;\n    }\n    function getUserBounds(scale) {\n        const {min, max, minDefined, maxDefined} = scale.getUserBounds();\n        return {\n            min: minDefined ? min : Number.NEGATIVE_INFINITY,\n            max: maxDefined ? max : Number.POSITIVE_INFINITY\n        };\n    }\n    function getOrCreateStack(stacks, stackKey, indexValue) {\n        const subStack = stacks[stackKey] || (stacks[stackKey] = {});\n        return subStack[indexValue] || (subStack[indexValue] = {});\n    }\n    function getLastIndexInStack(stack, vScale, positive) {\n        for (const meta of vScale.getMatchingVisibleMetas('bar').reverse()) {\n            const value = stack[meta.index];\n            if ((positive && value > 0) || (!positive && value < 0)) {\n                return meta.index;\n            }\n        }\n        return null;\n    }\n    function updateStacks(controller, parsed) {\n        const {chart, _cachedMeta: meta} = controller;\n        const stacks = chart._stacks || (chart._stacks = {});\n        const {iScale, vScale, index: datasetIndex} = meta;\n        const iAxis = iScale.axis;\n        const vAxis = vScale.axis;\n        const key = getStackKey(iScale, vScale, meta);\n        const ilen = parsed.length;\n        let stack;\n        for (let i = 0; i < ilen; ++i) {\n            const item = parsed[i];\n            const {[iAxis]: index, [vAxis]: value} = item;\n            const itemStacks = item._stacks || (item._stacks = {});\n            stack = itemStacks[vAxis] = getOrCreateStack(stacks, key, index);\n            stack[datasetIndex] = value;\n            stack._top = getLastIndexInStack(stack, vScale, true);\n            stack._bottom = getLastIndexInStack(stack, vScale, false);\n        }\n    }\n    function getFirstScaleId(chart, axis) {\n        const scales = chart.scales;\n        return Object.keys(scales).filter(key => scales[key].axis === axis).shift();\n    }\n    function createDatasetContext(parent, index) {\n        return Object.assign(Object.create(parent),\n            {\n                active: false,\n                dataset: undefined,\n                datasetIndex: index,\n                index,\n                mode: 'default',\n                type: 'dataset'\n            }\n        );\n    }\n    function createDataContext(parent, index, element) {\n        return Object.assign(Object.create(parent), {\n            active: false,\n            dataIndex: index,\n            parsed: undefined,\n            raw: undefined,\n            element,\n            index,\n            mode: 'default',\n            type: 'data'\n        });\n    }\n    function clearStacks(meta, items) {\n        const axis = meta.vScale && meta.vScale.axis;\n        if (!axis) {\n            return;\n        }\n        items = items || meta._parsed;\n        for (const parsed of items) {\n            const stacks = parsed._stacks;\n            if (!stacks || stacks[axis] === undefined || stacks[axis][meta.index] === undefined) {\n                return;\n            }\n            delete stacks[axis][meta.index];\n        }\n    }\n    const isDirectUpdateMode = (mode) => mode === 'reset' || mode === 'none';\n    const cloneIfNotShared = (cached, shared) => shared ? cached : Object.assign({}, cached);\n    class DatasetController {\n        constructor(chart, datasetIndex) {\n            this.chart = chart;\n            this._ctx = chart.ctx;\n            this.index = datasetIndex;\n            this._cachedDataOpts = {};\n            this._cachedMeta = this.getMeta();\n            this._type = this._cachedMeta.type;\n            this.options = undefined;\n            this._parsing = false;\n            this._data = undefined;\n            this._objectData = undefined;\n            this._sharedOptions = undefined;\n            this._drawStart = undefined;\n            this._drawCount = undefined;\n            this.enableOptionSharing = false;\n            this.$context = undefined;\n            this._syncList = [];\n            this.initialize();\n        }\n        initialize() {\n            const me = this;\n            const meta = me._cachedMeta;\n            me.configure();\n            me.linkScales();\n            meta._stacked = isStacked(meta.vScale, meta);\n            me.addElements();\n        }\n        updateIndex(datasetIndex) {\n            if (this.index !== datasetIndex) {\n                clearStacks(this._cachedMeta);\n            }\n            this.index = datasetIndex;\n        }\n        linkScales() {\n            const me = this;\n            const chart = me.chart;\n            const meta = me._cachedMeta;\n            const dataset = me.getDataset();\n            const chooseId = (axis, x, y, r) => axis === 'x' ? x : axis === 'r' ? r : y;\n            const xid = meta.xAxisID = valueOrDefault(dataset.xAxisID, getFirstScaleId(chart, 'x'));\n            const yid = meta.yAxisID = valueOrDefault(dataset.yAxisID, getFirstScaleId(chart, 'y'));\n            const rid = meta.rAxisID = valueOrDefault(dataset.rAxisID, getFirstScaleId(chart, 'r'));\n            const indexAxis = meta.indexAxis;\n            const iid = meta.iAxisID = chooseId(indexAxis, xid, yid, rid);\n            const vid = meta.vAxisID = chooseId(indexAxis, yid, xid, rid);\n            meta.xScale = me.getScaleForId(xid);\n            meta.yScale = me.getScaleForId(yid);\n            meta.rScale = me.getScaleForId(rid);\n            meta.iScale = me.getScaleForId(iid);\n            meta.vScale = me.getScaleForId(vid);\n        }\n        getDataset() {\n            return this.chart.data.datasets[this.index];\n        }\n        getMeta() {\n            return this.chart.getDatasetMeta(this.index);\n        }\n        getScaleForId(scaleID) {\n            return this.chart.scales[scaleID];\n        }\n        _getOtherScale(scale) {\n            const meta = this._cachedMeta;\n            return scale === meta.iScale\n                ? meta.vScale\n                : meta.iScale;\n        }\n        reset() {\n            this._update('reset');\n        }\n        _destroy() {\n            const meta = this._cachedMeta;\n            if (this._data) {\n                unlistenArrayEvents(this._data, this);\n            }\n            if (meta._stacked) {\n                clearStacks(meta);\n            }\n        }\n        _dataCheck() {\n            const me = this;\n            const dataset = me.getDataset();\n            const data = dataset.data || (dataset.data = []);\n            const _data = me._data;\n            if (isObject(data)) {\n                me._data = convertObjectDataToArray(data);\n            } else if (_data !== data) {\n                if (_data) {\n                    unlistenArrayEvents(_data, me);\n                    const meta = me._cachedMeta;\n                    clearStacks(meta);\n                    meta._parsed = [];\n                }\n                if (data && Object.isExtensible(data)) {\n                    listenArrayEvents(data, me);\n                }\n                me._syncList = [];\n                me._data = data;\n            }\n        }\n        addElements() {\n            const me = this;\n            const meta = me._cachedMeta;\n            me._dataCheck();\n            if (me.datasetElementType) {\n                meta.dataset = new me.datasetElementType();\n            }\n        }\n        buildOrUpdateElements(resetNewElements) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const dataset = me.getDataset();\n            let stackChanged = false;\n            me._dataCheck();\n            const oldStacked = meta._stacked;\n            meta._stacked = isStacked(meta.vScale, meta);\n            if (meta.stack !== dataset.stack) {\n                stackChanged = true;\n                clearStacks(meta);\n                meta.stack = dataset.stack;\n            }\n            me._resyncElements(resetNewElements);\n            if (stackChanged || oldStacked !== meta._stacked) {\n                updateStacks(me, meta._parsed);\n            }\n        }\n        configure() {\n            const me = this;\n            const config = me.chart.config;\n            const scopeKeys = config.datasetScopeKeys(me._type);\n            const scopes = config.getOptionScopes(me.getDataset(), scopeKeys, true);\n            me.options = config.createResolver(scopes, me.getContext());\n            me._parsing = me.options.parsing;\n        }\n        parse(start, count) {\n            const me = this;\n            const {_cachedMeta: meta, _data: data} = me;\n            const {iScale, _stacked} = meta;\n            const iAxis = iScale.axis;\n            let sorted = start === 0 && count === data.length ? true : meta._sorted;\n            let prev = start > 0 && meta._parsed[start - 1];\n            let i, cur, parsed;\n            if (me._parsing === false) {\n                meta._parsed = data;\n                meta._sorted = true;\n                parsed = data;\n            } else {\n                if (isArray(data[start])) {\n                    parsed = me.parseArrayData(meta, data, start, count);\n                } else if (isObject(data[start])) {\n                    parsed = me.parseObjectData(meta, data, start, count);\n                } else {\n                    parsed = me.parsePrimitiveData(meta, data, start, count);\n                }\n                const isNotInOrderComparedToPrev = () => cur[iAxis] === null || (prev && cur[iAxis] < prev[iAxis]);\n                for (i = 0; i < count; ++i) {\n                    meta._parsed[i + start] = cur = parsed[i];\n                    if (sorted) {\n                        if (isNotInOrderComparedToPrev()) {\n                            sorted = false;\n                        }\n                        prev = cur;\n                    }\n                }\n                meta._sorted = sorted;\n            }\n            if (_stacked) {\n                updateStacks(me, parsed);\n            }\n        }\n        parsePrimitiveData(meta, data, start, count) {\n            const {iScale, vScale} = meta;\n            const iAxis = iScale.axis;\n            const vAxis = vScale.axis;\n            const labels = iScale.getLabels();\n            const singleScale = iScale === vScale;\n            const parsed = new Array(count);\n            let i, ilen, index;\n            for (i = 0, ilen = count; i < ilen; ++i) {\n                index = i + start;\n                parsed[i] = {\n                    [iAxis]: singleScale || iScale.parse(labels[index], index),\n                    [vAxis]: vScale.parse(data[index], index)\n                };\n            }\n            return parsed;\n        }\n        parseArrayData(meta, data, start, count) {\n            const {xScale, yScale} = meta;\n            const parsed = new Array(count);\n            let i, ilen, index, item;\n            for (i = 0, ilen = count; i < ilen; ++i) {\n                index = i + start;\n                item = data[index];\n                parsed[i] = {\n                    x: xScale.parse(item[0], index),\n                    y: yScale.parse(item[1], index)\n                };\n            }\n            return parsed;\n        }\n        parseObjectData(meta, data, start, count) {\n            const {xScale, yScale} = meta;\n            const {xAxisKey = 'x', yAxisKey = 'y'} = this._parsing;\n            const parsed = new Array(count);\n            let i, ilen, index, item;\n            for (i = 0, ilen = count; i < ilen; ++i) {\n                index = i + start;\n                item = data[index];\n                parsed[i] = {\n                    x: xScale.parse(resolveObjectKey(item, xAxisKey), index),\n                    y: yScale.parse(resolveObjectKey(item, yAxisKey), index)\n                };\n            }\n            return parsed;\n        }\n        getParsed(index) {\n            return this._cachedMeta._parsed[index];\n        }\n        getDataElement(index) {\n            return this._cachedMeta.data[index];\n        }\n        applyStack(scale, parsed, mode) {\n            const chart = this.chart;\n            const meta = this._cachedMeta;\n            const value = parsed[scale.axis];\n            const stack = {\n                keys: getSortedDatasetIndices(chart, true),\n                values: parsed._stacks[scale.axis]\n            };\n            return applyStack(stack, value, meta.index, {mode});\n        }\n        updateRangeFromParsed(range, scale, parsed, stack) {\n            const parsedValue = parsed[scale.axis];\n            let value = parsedValue === null ? NaN : parsedValue;\n            const values = stack && parsed._stacks[scale.axis];\n            if (stack && values) {\n                stack.values = values;\n                range.min = Math.min(range.min, value);\n                range.max = Math.max(range.max, value);\n                value = applyStack(stack, parsedValue, this._cachedMeta.index, {all: true});\n            }\n            range.min = Math.min(range.min, value);\n            range.max = Math.max(range.max, value);\n        }\n        getMinMax(scale, canStack) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const _parsed = meta._parsed;\n            const sorted = meta._sorted && scale === meta.iScale;\n            const ilen = _parsed.length;\n            const otherScale = me._getOtherScale(scale);\n            const stack = canStack && meta._stacked && {keys: getSortedDatasetIndices(me.chart, true), values: null};\n            const range = {min: Number.POSITIVE_INFINITY, max: Number.NEGATIVE_INFINITY};\n            const {min: otherMin, max: otherMax} = getUserBounds(otherScale);\n            let i, value, parsed, otherValue;\n            function _skip() {\n                parsed = _parsed[i];\n                value = parsed[scale.axis];\n                otherValue = parsed[otherScale.axis];\n                return !isNumberFinite(value) || otherMin > otherValue || otherMax < otherValue;\n            }\n            for (i = 0; i < ilen; ++i) {\n                if (_skip()) {\n                    continue;\n                }\n                me.updateRangeFromParsed(range, scale, parsed, stack);\n                if (sorted) {\n                    break;\n                }\n            }\n            if (sorted) {\n                for (i = ilen - 1; i >= 0; --i) {\n                    if (_skip()) {\n                        continue;\n                    }\n                    me.updateRangeFromParsed(range, scale, parsed, stack);\n                    break;\n                }\n            }\n            return range;\n        }\n        getAllParsedValues(scale) {\n            const parsed = this._cachedMeta._parsed;\n            const values = [];\n            let i, ilen, value;\n            for (i = 0, ilen = parsed.length; i < ilen; ++i) {\n                value = parsed[i][scale.axis];\n                if (isNumberFinite(value)) {\n                    values.push(value);\n                }\n            }\n            return values;\n        }\n        getMaxOverflow() {\n            return false;\n        }\n        getLabelAndValue(index) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const iScale = meta.iScale;\n            const vScale = meta.vScale;\n            const parsed = me.getParsed(index);\n            return {\n                label: iScale ? '' + iScale.getLabelForValue(parsed[iScale.axis]) : '',\n                value: vScale ? '' + vScale.getLabelForValue(parsed[vScale.axis]) : ''\n            };\n        }\n        _update(mode) {\n            const me = this;\n            const meta = me._cachedMeta;\n            me.configure();\n            me._cachedDataOpts = {};\n            me.update(mode || 'default');\n            meta._clip = toClip(valueOrDefault(me.options.clip, defaultClip(meta.xScale, meta.yScale, me.getMaxOverflow())));\n        }\n        update(mode) {}\n        draw() {\n            const me = this;\n            const ctx = me._ctx;\n            const chart = me.chart;\n            const meta = me._cachedMeta;\n            const elements = meta.data || [];\n            const area = chart.chartArea;\n            const active = [];\n            const start = me._drawStart || 0;\n            const count = me._drawCount || (elements.length - start);\n            let i;\n            if (meta.dataset) {\n                meta.dataset.draw(ctx, area, start, count);\n            }\n            for (i = start; i < start + count; ++i) {\n                const element = elements[i];\n                if (element.active) {\n                    active.push(element);\n                } else {\n                    element.draw(ctx, area);\n                }\n            }\n            for (i = 0; i < active.length; ++i) {\n                active[i].draw(ctx, area);\n            }\n        }\n        getStyle(index, active) {\n            const mode = active ? 'active' : 'default';\n            return index === undefined && this._cachedMeta.dataset\n                ? this.resolveDatasetElementOptions(mode)\n                : this.resolveDataElementOptions(index || 0, mode);\n        }\n        getContext(index, active, mode) {\n            const me = this;\n            const dataset = me.getDataset();\n            let context;\n            if (index >= 0 && index < me._cachedMeta.data.length) {\n                const element = me._cachedMeta.data[index];\n                context = element.$context ||\n                    (element.$context = createDataContext(me.getContext(), index, element));\n                context.parsed = me.getParsed(index);\n                context.raw = dataset.data[index];\n                context.index = context.dataIndex = index;\n            } else {\n                context = me.$context ||\n                    (me.$context = createDatasetContext(me.chart.getContext(), me.index));\n                context.dataset = dataset;\n                context.index = context.datasetIndex = me.index;\n            }\n            context.active = !!active;\n            context.mode = mode;\n            return context;\n        }\n        resolveDatasetElementOptions(mode) {\n            return this._resolveElementOptions(this.datasetElementType.id, mode);\n        }\n        resolveDataElementOptions(index, mode) {\n            return this._resolveElementOptions(this.dataElementType.id, mode, index);\n        }\n        _resolveElementOptions(elementType, mode = 'default', index) {\n            const me = this;\n            const active = mode === 'active';\n            const cache = me._cachedDataOpts;\n            const cacheKey = elementType + '-' + mode;\n            const cached = cache[cacheKey];\n            const sharing = me.enableOptionSharing && defined(index);\n            if (cached) {\n                return cloneIfNotShared(cached, sharing);\n            }\n            const config = me.chart.config;\n            const scopeKeys = config.datasetElementScopeKeys(me._type, elementType);\n            const prefixes = active ? [`${elementType}Hover`, 'hover', elementType, ''] : [elementType, ''];\n            const scopes = config.getOptionScopes(me.getDataset(), scopeKeys);\n            const names = Object.keys(defaults.elements[elementType]);\n            const context = () => me.getContext(index, active);\n            const values = config.resolveNamedOptions(scopes, names, context, prefixes);\n            if (values.$shared) {\n                values.$shared = sharing;\n                cache[cacheKey] = Object.freeze(cloneIfNotShared(values, sharing));\n            }\n            return values;\n        }\n        _resolveAnimations(index, transition, active) {\n            const me = this;\n            const chart = me.chart;\n            const cache = me._cachedDataOpts;\n            const cacheKey = `animation-${transition}`;\n            const cached = cache[cacheKey];\n            if (cached) {\n                return cached;\n            }\n            let options;\n            if (chart.options.animation !== false) {\n                const config = me.chart.config;\n                const scopeKeys = config.datasetAnimationScopeKeys(me._type, transition);\n                const scopes = config.getOptionScopes(me.getDataset(), scopeKeys);\n                options = config.createResolver(scopes, me.getContext(index, active, transition));\n            }\n            const animations = new Animations(chart, options && options.animations);\n            if (options && options._cacheable) {\n                cache[cacheKey] = Object.freeze(animations);\n            }\n            return animations;\n        }\n        getSharedOptions(options) {\n            if (!options.$shared) {\n                return;\n            }\n            return this._sharedOptions || (this._sharedOptions = Object.assign({}, options));\n        }\n        includeOptions(mode, sharedOptions) {\n            return !sharedOptions || isDirectUpdateMode(mode) || this.chart._animationsDisabled;\n        }\n        updateElement(element, index, properties, mode) {\n            if (isDirectUpdateMode(mode)) {\n                Object.assign(element, properties);\n            } else {\n                this._resolveAnimations(index, mode).update(element, properties);\n            }\n        }\n        updateSharedOptions(sharedOptions, mode, newOptions) {\n            if (sharedOptions && !isDirectUpdateMode(mode)) {\n                this._resolveAnimations(undefined, mode).update(sharedOptions, newOptions);\n            }\n        }\n        _setStyle(element, index, mode, active) {\n            element.active = active;\n            const options = this.getStyle(index, active);\n            this._resolveAnimations(index, mode, active).update(element, {\n                options: (!active && this.getSharedOptions(options)) || options\n            });\n        }\n        removeHoverStyle(element, datasetIndex, index) {\n            this._setStyle(element, index, 'active', false);\n        }\n        setHoverStyle(element, datasetIndex, index) {\n            this._setStyle(element, index, 'active', true);\n        }\n        _removeDatasetHoverStyle() {\n            const element = this._cachedMeta.dataset;\n            if (element) {\n                this._setStyle(element, undefined, 'active', false);\n            }\n        }\n        _setDatasetHoverStyle() {\n            const element = this._cachedMeta.dataset;\n            if (element) {\n                this._setStyle(element, undefined, 'active', true);\n            }\n        }\n        _resyncElements(resetNewElements) {\n            const me = this;\n            const data = me._data;\n            const elements = me._cachedMeta.data;\n            for (const [method, arg1, arg2] of me._syncList) {\n                me[method](arg1, arg2);\n            }\n            me._syncList = [];\n            const numMeta = elements.length;\n            const numData = data.length;\n            const count = Math.min(numData, numMeta);\n            if (count) {\n                me.parse(0, count);\n            }\n            if (numData > numMeta) {\n                me._insertElements(numMeta, numData - numMeta, resetNewElements);\n            } else if (numData < numMeta) {\n                me._removeElements(numData, numMeta - numData);\n            }\n        }\n        _insertElements(start, count, resetNewElements = true) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const data = meta.data;\n            const end = start + count;\n            let i;\n            const move = (arr) => {\n                arr.length += count;\n                for (i = arr.length - 1; i >= end; i--) {\n                    arr[i] = arr[i - count];\n                }\n            };\n            move(data);\n            for (i = start; i < end; ++i) {\n                data[i] = new me.dataElementType();\n            }\n            if (me._parsing) {\n                move(meta._parsed);\n            }\n            me.parse(start, count);\n            if (resetNewElements) {\n                me.updateElements(data, start, count, 'reset');\n            }\n        }\n        updateElements(element, start, count, mode) {}\n        _removeElements(start, count) {\n            const me = this;\n            const meta = me._cachedMeta;\n            if (me._parsing) {\n                const removed = meta._parsed.splice(start, count);\n                if (meta._stacked) {\n                    clearStacks(meta, removed);\n                }\n            }\n            meta.data.splice(start, count);\n        }\n        _onDataPush() {\n            const count = arguments.length;\n            this._syncList.push(['_insertElements', this.getDataset().data.length - count, count]);\n        }\n        _onDataPop() {\n            this._syncList.push(['_removeElements', this._cachedMeta.data.length - 1, 1]);\n        }\n        _onDataShift() {\n            this._syncList.push(['_removeElements', 0, 1]);\n        }\n        _onDataSplice(start, count) {\n            this._syncList.push(['_removeElements', start, count]);\n            this._syncList.push(['_insertElements', start, arguments.length - 2]);\n        }\n        _onDataUnshift() {\n            this._syncList.push(['_insertElements', 0, arguments.length]);\n        }\n    }\n    DatasetController.defaults = {};\n    DatasetController.prototype.datasetElementType = null;\n    DatasetController.prototype.dataElementType = null;\n\n    class Element {\n        constructor() {\n            this.x = undefined;\n            this.y = undefined;\n            this.active = false;\n            this.options = undefined;\n            this.$animations = undefined;\n        }\n        tooltipPosition(useFinalPosition) {\n            const {x, y} = this.getProps(['x', 'y'], useFinalPosition);\n            return {x, y};\n        }\n        hasValue() {\n            return isNumber(this.x) && isNumber(this.y);\n        }\n        getProps(props, final) {\n            const me = this;\n            const anims = this.$animations;\n            if (!final || !anims) {\n                return me;\n            }\n            const ret = {};\n            props.forEach(prop => {\n                ret[prop] = anims[prop] && anims[prop].active() ? anims[prop]._to : me[prop];\n            });\n            return ret;\n        }\n    }\n    Element.defaults = {};\n    Element.defaultRoutes = undefined;\n\n    const intlCache = new Map();\n    function getNumberFormat(locale, options) {\n        options = options || {};\n        const cacheKey = locale + JSON.stringify(options);\n        let formatter = intlCache.get(cacheKey);\n        if (!formatter) {\n            formatter = new Intl.NumberFormat(locale, options);\n            intlCache.set(cacheKey, formatter);\n        }\n        return formatter;\n    }\n    function formatNumber(num, locale, options) {\n        return getNumberFormat(locale, options).format(num);\n    }\n\n    const formatters = {\n        values(value) {\n            return isArray(value) ? value : '' + value;\n        },\n        numeric(tickValue, index, ticks) {\n            if (tickValue === 0) {\n                return '0';\n            }\n            const locale = this.chart.options.locale;\n            let notation;\n            let delta = tickValue;\n            if (ticks.length > 1) {\n                const maxTick = Math.max(Math.abs(ticks[0].value), Math.abs(ticks[ticks.length - 1].value));\n                if (maxTick < 1e-4 || maxTick > 1e+15) {\n                    notation = 'scientific';\n                }\n                delta = calculateDelta(tickValue, ticks);\n            }\n            const logDelta = log10(Math.abs(delta));\n            const numDecimal = Math.max(Math.min(-1 * Math.floor(logDelta), 20), 0);\n            const options = {notation, minimumFractionDigits: numDecimal, maximumFractionDigits: numDecimal};\n            Object.assign(options, this.options.ticks.format);\n            return formatNumber(tickValue, locale, options);\n        },\n        logarithmic(tickValue, index, ticks) {\n            if (tickValue === 0) {\n                return '0';\n            }\n            const remain = tickValue / (Math.pow(10, Math.floor(log10(tickValue))));\n            if (remain === 1 || remain === 2 || remain === 5) {\n                return formatters.numeric.call(this, tickValue, index, ticks);\n            }\n            return '';\n        }\n    };\n    function calculateDelta(tickValue, ticks) {\n        let delta = ticks.length > 3 ? ticks[2].value - ticks[1].value : ticks[1].value - ticks[0].value;\n        if (Math.abs(delta) >= 1 && tickValue !== Math.floor(tickValue)) {\n            delta = tickValue - Math.floor(tickValue);\n        }\n        return delta;\n    }\n    var Ticks = {formatters};\n\n    defaults.set('scale', {\n        display: true,\n        offset: false,\n        reverse: false,\n        beginAtZero: false,\n        bounds: 'ticks',\n        grace: 0,\n        grid: {\n            display: true,\n            lineWidth: 1,\n            drawBorder: true,\n            drawOnChartArea: true,\n            drawTicks: true,\n            tickLength: 8,\n            tickWidth: (_ctx, options) => options.lineWidth,\n            tickColor: (_ctx, options) => options.color,\n            offset: false,\n            borderDash: [],\n            borderDashOffset: 0.0,\n            borderWidth: 1\n        },\n        title: {\n            display: false,\n            text: '',\n            padding: {\n                top: 4,\n                bottom: 4\n            }\n        },\n        ticks: {\n            minRotation: 0,\n            maxRotation: 50,\n            mirror: false,\n            textStrokeWidth: 0,\n            textStrokeColor: '',\n            padding: 3,\n            display: true,\n            autoSkip: true,\n            autoSkipPadding: 3,\n            labelOffset: 0,\n            callback: Ticks.formatters.values,\n            minor: {},\n            major: {},\n            align: 'center',\n            crossAlign: 'near',\n            showLabelBackdrop: false,\n            backdropColor: 'rgba(255, 255, 255, 0.75)',\n            backdropPadding: 2,\n        }\n    });\n    defaults.route('scale.ticks', 'color', '', 'color');\n    defaults.route('scale.grid', 'color', '', 'borderColor');\n    defaults.route('scale.grid', 'borderColor', '', 'borderColor');\n    defaults.route('scale.title', 'color', '', 'color');\n    defaults.describe('scale', {\n        _fallback: false,\n        _scriptable: (name) => !name.startsWith('before') && !name.startsWith('after') && name !== 'callback' && name !== 'parser',\n        _indexable: (name) => name !== 'borderDash' && name !== 'tickBorderDash',\n    });\n    defaults.describe('scales', {\n        _fallback: 'scale',\n    });\n\n    function autoSkip(scale, ticks) {\n        const tickOpts = scale.options.ticks;\n        const ticksLimit = tickOpts.maxTicksLimit || determineMaxTicks(scale);\n        const majorIndices = tickOpts.major.enabled ? getMajorIndices(ticks) : [];\n        const numMajorIndices = majorIndices.length;\n        const first = majorIndices[0];\n        const last = majorIndices[numMajorIndices - 1];\n        const newTicks = [];\n        if (numMajorIndices > ticksLimit) {\n            skipMajors(ticks, newTicks, majorIndices, numMajorIndices / ticksLimit);\n            return newTicks;\n        }\n        const spacing = calculateSpacing(majorIndices, ticks, ticksLimit);\n        if (numMajorIndices > 0) {\n            let i, ilen;\n            const avgMajorSpacing = numMajorIndices > 1 ? Math.round((last - first) / (numMajorIndices - 1)) : null;\n            skip(ticks, newTicks, spacing, isNullOrUndef(avgMajorSpacing) ? 0 : first - avgMajorSpacing, first);\n            for (i = 0, ilen = numMajorIndices - 1; i < ilen; i++) {\n                skip(ticks, newTicks, spacing, majorIndices[i], majorIndices[i + 1]);\n            }\n            skip(ticks, newTicks, spacing, last, isNullOrUndef(avgMajorSpacing) ? ticks.length : last + avgMajorSpacing);\n            return newTicks;\n        }\n        skip(ticks, newTicks, spacing);\n        return newTicks;\n    }\n    function determineMaxTicks(scale) {\n        const offset = scale.options.offset;\n        const tickLength = scale._tickSize();\n        const maxScale = scale._length / tickLength + (offset ? 0 : 1);\n        const maxChart = scale._maxLength / tickLength;\n        return Math.floor(Math.min(maxScale, maxChart));\n    }\n    function calculateSpacing(majorIndices, ticks, ticksLimit) {\n        const evenMajorSpacing = getEvenSpacing(majorIndices);\n        const spacing = ticks.length / ticksLimit;\n        if (!evenMajorSpacing) {\n            return Math.max(spacing, 1);\n        }\n        const factors = _factorize(evenMajorSpacing);\n        for (let i = 0, ilen = factors.length - 1; i < ilen; i++) {\n            const factor = factors[i];\n            if (factor > spacing) {\n                return factor;\n            }\n        }\n        return Math.max(spacing, 1);\n    }\n    function getMajorIndices(ticks) {\n        const result = [];\n        let i, ilen;\n        for (i = 0, ilen = ticks.length; i < ilen; i++) {\n            if (ticks[i].major) {\n                result.push(i);\n            }\n        }\n        return result;\n    }\n    function skipMajors(ticks, newTicks, majorIndices, spacing) {\n        let count = 0;\n        let next = majorIndices[0];\n        let i;\n        spacing = Math.ceil(spacing);\n        for (i = 0; i < ticks.length; i++) {\n            if (i === next) {\n                newTicks.push(ticks[i]);\n                count++;\n                next = majorIndices[count * spacing];\n            }\n        }\n    }\n    function skip(ticks, newTicks, spacing, majorStart, majorEnd) {\n        const start = valueOrDefault(majorStart, 0);\n        const end = Math.min(valueOrDefault(majorEnd, ticks.length), ticks.length);\n        let count = 0;\n        let length, i, next;\n        spacing = Math.ceil(spacing);\n        if (majorEnd) {\n            length = majorEnd - majorStart;\n            spacing = length / Math.floor(length / spacing);\n        }\n        next = start;\n        while (next < 0) {\n            count++;\n            next = Math.round(start + count * spacing);\n        }\n        for (i = Math.max(start, 0); i < end; i++) {\n            if (i === next) {\n                newTicks.push(ticks[i]);\n                count++;\n                next = Math.round(start + count * spacing);\n            }\n        }\n    }\n    function getEvenSpacing(arr) {\n        const len = arr.length;\n        let i, diff;\n        if (len < 2) {\n            return false;\n        }\n        for (diff = arr[0], i = 1; i < len; ++i) {\n            if (arr[i] - arr[i - 1] !== diff) {\n                return false;\n            }\n        }\n        return diff;\n    }\n\n    const reverseAlign = (align) => align === 'left' ? 'right' : align === 'right' ? 'left' : align;\n    const offsetFromEdge = (scale, edge, offset) => edge === 'top' || edge === 'left' ? scale[edge] + offset : scale[edge] - offset;\n    function sample(arr, numItems) {\n        const result = [];\n        const increment = arr.length / numItems;\n        const len = arr.length;\n        let i = 0;\n        for (; i < len; i += increment) {\n            result.push(arr[Math.floor(i)]);\n        }\n        return result;\n    }\n    function getPixelForGridLine(scale, index, offsetGridLines) {\n        const length = scale.ticks.length;\n        const validIndex = Math.min(index, length - 1);\n        const start = scale._startPixel;\n        const end = scale._endPixel;\n        const epsilon = 1e-6;\n        let lineValue = scale.getPixelForTick(validIndex);\n        let offset;\n        if (offsetGridLines) {\n            if (length === 1) {\n                offset = Math.max(lineValue - start, end - lineValue);\n            } else if (index === 0) {\n                offset = (scale.getPixelForTick(1) - lineValue) / 2;\n            } else {\n                offset = (lineValue - scale.getPixelForTick(validIndex - 1)) / 2;\n            }\n            lineValue += validIndex < index ? offset : -offset;\n            if (lineValue < start - epsilon || lineValue > end + epsilon) {\n                return;\n            }\n        }\n        return lineValue;\n    }\n    function garbageCollect(caches, length) {\n        each(caches, (cache) => {\n            const gc = cache.gc;\n            const gcLen = gc.length / 2;\n            let i;\n            if (gcLen > length) {\n                for (i = 0; i < gcLen; ++i) {\n                    delete cache.data[gc[i]];\n                }\n                gc.splice(0, gcLen);\n            }\n        });\n    }\n    function getTickMarkLength(options) {\n        return options.drawTicks ? options.tickLength : 0;\n    }\n    function getTitleHeight(options, fallback) {\n        if (!options.display) {\n            return 0;\n        }\n        const font = toFont(options.font, fallback);\n        const padding = toPadding(options.padding);\n        const lines = isArray(options.text) ? options.text.length : 1;\n        return (lines * font.lineHeight) + padding.height;\n    }\n    function createScaleContext(parent, scale) {\n        return Object.assign(Object.create(parent), {\n            scale,\n            type: 'scale'\n        });\n    }\n    function createTickContext(parent, index, tick) {\n        return Object.assign(Object.create(parent), {\n            tick,\n            index,\n            type: 'tick'\n        });\n    }\n    function titleAlign(align, position, reverse) {\n        let ret = _toLeftRightCenter(align);\n        if ((reverse && position !== 'right') || (!reverse && position === 'right')) {\n            ret = reverseAlign(ret);\n        }\n        return ret;\n    }\n    function titleArgs(scale, offset, position, align) {\n        const {top, left, bottom, right} = scale;\n        let rotation = 0;\n        let maxWidth, titleX, titleY;\n        if (scale.isHorizontal()) {\n            titleX = _alignStartEnd(align, left, right);\n            titleY = offsetFromEdge(scale, position, offset);\n            maxWidth = right - left;\n        } else {\n            titleX = offsetFromEdge(scale, position, offset);\n            titleY = _alignStartEnd(align, bottom, top);\n            rotation = position === 'left' ? -HALF_PI : HALF_PI;\n        }\n        return {titleX, titleY, maxWidth, rotation};\n    }\n    class Scale extends Element {\n        constructor(cfg) {\n            super();\n            this.id = cfg.id;\n            this.type = cfg.type;\n            this.options = undefined;\n            this.ctx = cfg.ctx;\n            this.chart = cfg.chart;\n            this.top = undefined;\n            this.bottom = undefined;\n            this.left = undefined;\n            this.right = undefined;\n            this.width = undefined;\n            this.height = undefined;\n            this._margins = {\n                left: 0,\n                right: 0,\n                top: 0,\n                bottom: 0\n            };\n            this.maxWidth = undefined;\n            this.maxHeight = undefined;\n            this.paddingTop = undefined;\n            this.paddingBottom = undefined;\n            this.paddingLeft = undefined;\n            this.paddingRight = undefined;\n            this.axis = undefined;\n            this.labelRotation = undefined;\n            this.min = undefined;\n            this.max = undefined;\n            this._range = undefined;\n            this.ticks = [];\n            this._gridLineItems = null;\n            this._labelItems = null;\n            this._labelSizes = null;\n            this._length = 0;\n            this._maxLength = 0;\n            this._longestTextCache = {};\n            this._startPixel = undefined;\n            this._endPixel = undefined;\n            this._reversePixels = false;\n            this._userMax = undefined;\n            this._userMin = undefined;\n            this._suggestedMax = undefined;\n            this._suggestedMin = undefined;\n            this._ticksLength = 0;\n            this._borderValue = 0;\n            this._cache = {};\n            this._dataLimitsCached = false;\n            this.$context = undefined;\n        }\n        init(options) {\n            const me = this;\n            me.options = options.setContext(me.getContext());\n            me.axis = options.axis;\n            me._userMin = me.parse(options.min);\n            me._userMax = me.parse(options.max);\n            me._suggestedMin = me.parse(options.suggestedMin);\n            me._suggestedMax = me.parse(options.suggestedMax);\n        }\n        parse(raw, index) {\n            return raw;\n        }\n        getUserBounds() {\n            let {_userMin, _userMax, _suggestedMin, _suggestedMax} = this;\n            _userMin = finiteOrDefault(_userMin, Number.POSITIVE_INFINITY);\n            _userMax = finiteOrDefault(_userMax, Number.NEGATIVE_INFINITY);\n            _suggestedMin = finiteOrDefault(_suggestedMin, Number.POSITIVE_INFINITY);\n            _suggestedMax = finiteOrDefault(_suggestedMax, Number.NEGATIVE_INFINITY);\n            return {\n                min: finiteOrDefault(_userMin, _suggestedMin),\n                max: finiteOrDefault(_userMax, _suggestedMax),\n                minDefined: isNumberFinite(_userMin),\n                maxDefined: isNumberFinite(_userMax)\n            };\n        }\n        getMinMax(canStack) {\n            const me = this;\n            let {min, max, minDefined, maxDefined} = me.getUserBounds();\n            let range;\n            if (minDefined && maxDefined) {\n                return {min, max};\n            }\n            const metas = me.getMatchingVisibleMetas();\n            for (let i = 0, ilen = metas.length; i < ilen; ++i) {\n                range = metas[i].controller.getMinMax(me, canStack);\n                if (!minDefined) {\n                    min = Math.min(min, range.min);\n                }\n                if (!maxDefined) {\n                    max = Math.max(max, range.max);\n                }\n            }\n            return {\n                min: finiteOrDefault(min, finiteOrDefault(max, min)),\n                max: finiteOrDefault(max, finiteOrDefault(min, max))\n            };\n        }\n        getPadding() {\n            const me = this;\n            return {\n                left: me.paddingLeft || 0,\n                top: me.paddingTop || 0,\n                right: me.paddingRight || 0,\n                bottom: me.paddingBottom || 0\n            };\n        }\n        getTicks() {\n            return this.ticks;\n        }\n        getLabels() {\n            const data = this.chart.data;\n            return this.options.labels || (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels || [];\n        }\n        beforeLayout() {\n            this._cache = {};\n            this._dataLimitsCached = false;\n        }\n        beforeUpdate() {\n            callback(this.options.beforeUpdate, [this]);\n        }\n        update(maxWidth, maxHeight, margins) {\n            const me = this;\n            const tickOpts = me.options.ticks;\n            const sampleSize = tickOpts.sampleSize;\n            me.beforeUpdate();\n            me.maxWidth = maxWidth;\n            me.maxHeight = maxHeight;\n            me._margins = margins = Object.assign({\n                left: 0,\n                right: 0,\n                top: 0,\n                bottom: 0\n            }, margins);\n            me.ticks = null;\n            me._labelSizes = null;\n            me._gridLineItems = null;\n            me._labelItems = null;\n            me.beforeSetDimensions();\n            me.setDimensions();\n            me.afterSetDimensions();\n            me._maxLength = me.isHorizontal()\n                ? me.width + margins.left + margins.right\n                : me.height + margins.top + margins.bottom;\n            if (!me._dataLimitsCached) {\n                me.beforeDataLimits();\n                me.determineDataLimits();\n                me.afterDataLimits();\n                me._range = _addGrace(me, me.options.grace);\n                me._dataLimitsCached = true;\n            }\n            me.beforeBuildTicks();\n            me.ticks = me.buildTicks() || [];\n            me.afterBuildTicks();\n            const samplingEnabled = sampleSize < me.ticks.length;\n            me._convertTicksToLabels(samplingEnabled ? sample(me.ticks, sampleSize) : me.ticks);\n            me.configure();\n            me.beforeCalculateLabelRotation();\n            me.calculateLabelRotation();\n            me.afterCalculateLabelRotation();\n            if (tickOpts.display && (tickOpts.autoSkip || tickOpts.source === 'auto')) {\n                me.ticks = autoSkip(me, me.ticks);\n                me._labelSizes = null;\n            }\n            if (samplingEnabled) {\n                me._convertTicksToLabels(me.ticks);\n            }\n            me.beforeFit();\n            me.fit();\n            me.afterFit();\n            me.afterUpdate();\n        }\n        configure() {\n            const me = this;\n            let reversePixels = me.options.reverse;\n            let startPixel, endPixel;\n            if (me.isHorizontal()) {\n                startPixel = me.left;\n                endPixel = me.right;\n            } else {\n                startPixel = me.top;\n                endPixel = me.bottom;\n                reversePixels = !reversePixels;\n            }\n            me._startPixel = startPixel;\n            me._endPixel = endPixel;\n            me._reversePixels = reversePixels;\n            me._length = endPixel - startPixel;\n            me._alignToPixels = me.options.alignToPixels;\n        }\n        afterUpdate() {\n            callback(this.options.afterUpdate, [this]);\n        }\n        beforeSetDimensions() {\n            callback(this.options.beforeSetDimensions, [this]);\n        }\n        setDimensions() {\n            const me = this;\n            if (me.isHorizontal()) {\n                me.width = me.maxWidth;\n                me.left = 0;\n                me.right = me.width;\n            } else {\n                me.height = me.maxHeight;\n                me.top = 0;\n                me.bottom = me.height;\n            }\n            me.paddingLeft = 0;\n            me.paddingTop = 0;\n            me.paddingRight = 0;\n            me.paddingBottom = 0;\n        }\n        afterSetDimensions() {\n            callback(this.options.afterSetDimensions, [this]);\n        }\n        _callHooks(name) {\n            const me = this;\n            me.chart.notifyPlugins(name, me.getContext());\n            callback(me.options[name], [me]);\n        }\n        beforeDataLimits() {\n            this._callHooks('beforeDataLimits');\n        }\n        determineDataLimits() {}\n        afterDataLimits() {\n            this._callHooks('afterDataLimits');\n        }\n        beforeBuildTicks() {\n            this._callHooks('beforeBuildTicks');\n        }\n        buildTicks() {\n            return [];\n        }\n        afterBuildTicks() {\n            this._callHooks('afterBuildTicks');\n        }\n        beforeTickToLabelConversion() {\n            callback(this.options.beforeTickToLabelConversion, [this]);\n        }\n        generateTickLabels(ticks) {\n            const me = this;\n            const tickOpts = me.options.ticks;\n            let i, ilen, tick;\n            for (i = 0, ilen = ticks.length; i < ilen; i++) {\n                tick = ticks[i];\n                tick.label = callback(tickOpts.callback, [tick.value, i, ticks], me);\n            }\n            for (i = 0; i < ilen; i++) {\n                if (isNullOrUndef(ticks[i].label)) {\n                    ticks.splice(i, 1);\n                    ilen--;\n                    i--;\n                }\n            }\n        }\n        afterTickToLabelConversion() {\n            callback(this.options.afterTickToLabelConversion, [this]);\n        }\n        beforeCalculateLabelRotation() {\n            callback(this.options.beforeCalculateLabelRotation, [this]);\n        }\n        calculateLabelRotation() {\n            const me = this;\n            const options = me.options;\n            const tickOpts = options.ticks;\n            const numTicks = me.ticks.length;\n            const minRotation = tickOpts.minRotation || 0;\n            const maxRotation = tickOpts.maxRotation;\n            let labelRotation = minRotation;\n            let tickWidth, maxHeight, maxLabelDiagonal;\n            if (!me._isVisible() || !tickOpts.display || minRotation >= maxRotation || numTicks <= 1 || !me.isHorizontal()) {\n                me.labelRotation = minRotation;\n                return;\n            }\n            const labelSizes = me._getLabelSizes();\n            const maxLabelWidth = labelSizes.widest.width;\n            const maxLabelHeight = labelSizes.highest.height;\n            const maxWidth = _limitValue(me.chart.width - maxLabelWidth, 0, me.maxWidth);\n            tickWidth = options.offset ? me.maxWidth / numTicks : maxWidth / (numTicks - 1);\n            if (maxLabelWidth + 6 > tickWidth) {\n                tickWidth = maxWidth / (numTicks - (options.offset ? 0.5 : 1));\n                maxHeight = me.maxHeight - getTickMarkLength(options.grid)\n                    - tickOpts.padding - getTitleHeight(options.title, me.chart.options.font);\n                maxLabelDiagonal = Math.sqrt(maxLabelWidth * maxLabelWidth + maxLabelHeight * maxLabelHeight);\n                labelRotation = toDegrees(Math.min(\n                    Math.asin(Math.min((labelSizes.highest.height + 6) / tickWidth, 1)),\n                    Math.asin(Math.min(maxHeight / maxLabelDiagonal, 1)) - Math.asin(maxLabelHeight / maxLabelDiagonal)\n                ));\n                labelRotation = Math.max(minRotation, Math.min(maxRotation, labelRotation));\n            }\n            me.labelRotation = labelRotation;\n        }\n        afterCalculateLabelRotation() {\n            callback(this.options.afterCalculateLabelRotation, [this]);\n        }\n        beforeFit() {\n            callback(this.options.beforeFit, [this]);\n        }\n        fit() {\n            const me = this;\n            const minSize = {\n                width: 0,\n                height: 0\n            };\n            const {chart, options: {ticks: tickOpts, title: titleOpts, grid: gridOpts}} = me;\n            const display = me._isVisible();\n            const isHorizontal = me.isHorizontal();\n            if (display) {\n                const titleHeight = getTitleHeight(titleOpts, chart.options.font);\n                if (isHorizontal) {\n                    minSize.width = me.maxWidth;\n                    minSize.height = getTickMarkLength(gridOpts) + titleHeight;\n                } else {\n                    minSize.height = me.maxHeight;\n                    minSize.width = getTickMarkLength(gridOpts) + titleHeight;\n                }\n                if (tickOpts.display && me.ticks.length) {\n                    const {first, last, widest, highest} = me._getLabelSizes();\n                    const tickPadding = tickOpts.padding * 2;\n                    const angleRadians = toRadians(me.labelRotation);\n                    const cos = Math.cos(angleRadians);\n                    const sin = Math.sin(angleRadians);\n                    if (isHorizontal) {\n                        const labelHeight = tickOpts.mirror ? 0 : sin * widest.width + cos * highest.height;\n                        minSize.height = Math.min(me.maxHeight, minSize.height + labelHeight + tickPadding);\n                    } else {\n                        const labelWidth = tickOpts.mirror ? 0 : cos * widest.width + sin * highest.height;\n                        minSize.width = Math.min(me.maxWidth, minSize.width + labelWidth + tickPadding);\n                    }\n                    me._calculatePadding(first, last, sin, cos);\n                }\n            }\n            me._handleMargins();\n            if (isHorizontal) {\n                me.width = me._length = chart.width - me._margins.left - me._margins.right;\n                me.height = minSize.height;\n            } else {\n                me.width = minSize.width;\n                me.height = me._length = chart.height - me._margins.top - me._margins.bottom;\n            }\n        }\n        _calculatePadding(first, last, sin, cos) {\n            const me = this;\n            const {ticks: {align, padding}, position} = me.options;\n            const isRotated = me.labelRotation !== 0;\n            const labelsBelowTicks = position !== 'top' && me.axis === 'x';\n            if (me.isHorizontal()) {\n                const offsetLeft = me.getPixelForTick(0) - me.left;\n                const offsetRight = me.right - me.getPixelForTick(me.ticks.length - 1);\n                let paddingLeft = 0;\n                let paddingRight = 0;\n                if (isRotated) {\n                    if (labelsBelowTicks) {\n                        paddingLeft = cos * first.width;\n                        paddingRight = sin * last.height;\n                    } else {\n                        paddingLeft = sin * first.height;\n                        paddingRight = cos * last.width;\n                    }\n                } else if (align === 'start') {\n                    paddingRight = last.width;\n                } else if (align === 'end') {\n                    paddingLeft = first.width;\n                } else {\n                    paddingLeft = first.width / 2;\n                    paddingRight = last.width / 2;\n                }\n                me.paddingLeft = Math.max((paddingLeft - offsetLeft + padding) * me.width / (me.width - offsetLeft), 0);\n                me.paddingRight = Math.max((paddingRight - offsetRight + padding) * me.width / (me.width - offsetRight), 0);\n            } else {\n                let paddingTop = last.height / 2;\n                let paddingBottom = first.height / 2;\n                if (align === 'start') {\n                    paddingTop = 0;\n                    paddingBottom = first.height;\n                } else if (align === 'end') {\n                    paddingTop = last.height;\n                    paddingBottom = 0;\n                }\n                me.paddingTop = paddingTop + padding;\n                me.paddingBottom = paddingBottom + padding;\n            }\n        }\n        _handleMargins() {\n            const me = this;\n            if (me._margins) {\n                me._margins.left = Math.max(me.paddingLeft, me._margins.left);\n                me._margins.top = Math.max(me.paddingTop, me._margins.top);\n                me._margins.right = Math.max(me.paddingRight, me._margins.right);\n                me._margins.bottom = Math.max(me.paddingBottom, me._margins.bottom);\n            }\n        }\n        afterFit() {\n            callback(this.options.afterFit, [this]);\n        }\n        isHorizontal() {\n            const {axis, position} = this.options;\n            return position === 'top' || position === 'bottom' || axis === 'x';\n        }\n        isFullSize() {\n            return this.options.fullSize;\n        }\n        _convertTicksToLabels(ticks) {\n            const me = this;\n            me.beforeTickToLabelConversion();\n            me.generateTickLabels(ticks);\n            me.afterTickToLabelConversion();\n        }\n        _getLabelSizes() {\n            const me = this;\n            let labelSizes = me._labelSizes;\n            if (!labelSizes) {\n                const sampleSize = me.options.ticks.sampleSize;\n                let ticks = me.ticks;\n                if (sampleSize < ticks.length) {\n                    ticks = sample(ticks, sampleSize);\n                }\n                me._labelSizes = labelSizes = me._computeLabelSizes(ticks, ticks.length);\n            }\n            return labelSizes;\n        }\n        _computeLabelSizes(ticks, length) {\n            const {ctx, _longestTextCache: caches} = this;\n            const widths = [];\n            const heights = [];\n            let widestLabelSize = 0;\n            let highestLabelSize = 0;\n            let i, j, jlen, label, tickFont, fontString, cache, lineHeight, width, height, nestedLabel;\n            for (i = 0; i < length; ++i) {\n                label = ticks[i].label;\n                tickFont = this._resolveTickFontOptions(i);\n                ctx.font = fontString = tickFont.string;\n                cache = caches[fontString] = caches[fontString] || {data: {}, gc: []};\n                lineHeight = tickFont.lineHeight;\n                width = height = 0;\n                if (!isNullOrUndef(label) && !isArray(label)) {\n                    width = _measureText(ctx, cache.data, cache.gc, width, label);\n                    height = lineHeight;\n                } else if (isArray(label)) {\n                    for (j = 0, jlen = label.length; j < jlen; ++j) {\n                        nestedLabel = label[j];\n                        if (!isNullOrUndef(nestedLabel) && !isArray(nestedLabel)) {\n                            width = _measureText(ctx, cache.data, cache.gc, width, nestedLabel);\n                            height += lineHeight;\n                        }\n                    }\n                }\n                widths.push(width);\n                heights.push(height);\n                widestLabelSize = Math.max(width, widestLabelSize);\n                highestLabelSize = Math.max(height, highestLabelSize);\n            }\n            garbageCollect(caches, length);\n            const widest = widths.indexOf(widestLabelSize);\n            const highest = heights.indexOf(highestLabelSize);\n            const valueAt = (idx) => ({width: widths[idx] || 0, height: heights[idx] || 0});\n            return {\n                first: valueAt(0),\n                last: valueAt(length - 1),\n                widest: valueAt(widest),\n                highest: valueAt(highest),\n                widths,\n                heights,\n            };\n        }\n        getLabelForValue(value) {\n            return value;\n        }\n        getPixelForValue(value, index) {\n            return NaN;\n        }\n        getValueForPixel(pixel) {}\n        getPixelForTick(index) {\n            const ticks = this.ticks;\n            if (index < 0 || index > ticks.length - 1) {\n                return null;\n            }\n            return this.getPixelForValue(ticks[index].value);\n        }\n        getPixelForDecimal(decimal) {\n            const me = this;\n            if (me._reversePixels) {\n                decimal = 1 - decimal;\n            }\n            const pixel = me._startPixel + decimal * me._length;\n            return _int16Range(me._alignToPixels ? _alignPixel(me.chart, pixel, 0) : pixel);\n        }\n        getDecimalForPixel(pixel) {\n            const decimal = (pixel - this._startPixel) / this._length;\n            return this._reversePixels ? 1 - decimal : decimal;\n        }\n        getBasePixel() {\n            return this.getPixelForValue(this.getBaseValue());\n        }\n        getBaseValue() {\n            const {min, max} = this;\n            return min < 0 && max < 0 ? max :\n                min > 0 && max > 0 ? min :\n                    0;\n        }\n        getContext(index) {\n            const me = this;\n            const ticks = me.ticks || [];\n            if (index >= 0 && index < ticks.length) {\n                const tick = ticks[index];\n                return tick.$context ||\n                    (tick.$context = createTickContext(me.getContext(), index, tick));\n            }\n            return me.$context ||\n                (me.$context = createScaleContext(me.chart.getContext(), me));\n        }\n        _tickSize() {\n            const me = this;\n            const optionTicks = me.options.ticks;\n            const rot = toRadians(me.labelRotation);\n            const cos = Math.abs(Math.cos(rot));\n            const sin = Math.abs(Math.sin(rot));\n            const labelSizes = me._getLabelSizes();\n            const padding = optionTicks.autoSkipPadding || 0;\n            const w = labelSizes ? labelSizes.widest.width + padding : 0;\n            const h = labelSizes ? labelSizes.highest.height + padding : 0;\n            return me.isHorizontal()\n                ? h * cos > w * sin ? w / cos : h / sin\n                : h * sin < w * cos ? h / cos : w / sin;\n        }\n        _isVisible() {\n            const display = this.options.display;\n            if (display !== 'auto') {\n                return !!display;\n            }\n            return this.getMatchingVisibleMetas().length > 0;\n        }\n        _computeGridLineItems(chartArea) {\n            const me = this;\n            const axis = me.axis;\n            const chart = me.chart;\n            const options = me.options;\n            const {grid, position} = options;\n            const offset = grid.offset;\n            const isHorizontal = me.isHorizontal();\n            const ticks = me.ticks;\n            const ticksLength = ticks.length + (offset ? 1 : 0);\n            const tl = getTickMarkLength(grid);\n            const items = [];\n            const borderOpts = grid.setContext(me.getContext());\n            const axisWidth = borderOpts.drawBorder ? borderOpts.borderWidth : 0;\n            const axisHalfWidth = axisWidth / 2;\n            const alignBorderValue = function(pixel) {\n                return _alignPixel(chart, pixel, axisWidth);\n            };\n            let borderValue, i, lineValue, alignedLineValue;\n            let tx1, ty1, tx2, ty2, x1, y1, x2, y2;\n            if (position === 'top') {\n                borderValue = alignBorderValue(me.bottom);\n                ty1 = me.bottom - tl;\n                ty2 = borderValue - axisHalfWidth;\n                y1 = alignBorderValue(chartArea.top) + axisHalfWidth;\n                y2 = chartArea.bottom;\n            } else if (position === 'bottom') {\n                borderValue = alignBorderValue(me.top);\n                y1 = chartArea.top;\n                y2 = alignBorderValue(chartArea.bottom) - axisHalfWidth;\n                ty1 = borderValue + axisHalfWidth;\n                ty2 = me.top + tl;\n            } else if (position === 'left') {\n                borderValue = alignBorderValue(me.right);\n                tx1 = me.right - tl;\n                tx2 = borderValue - axisHalfWidth;\n                x1 = alignBorderValue(chartArea.left) + axisHalfWidth;\n                x2 = chartArea.right;\n            } else if (position === 'right') {\n                borderValue = alignBorderValue(me.left);\n                x1 = chartArea.left;\n                x2 = alignBorderValue(chartArea.right) - axisHalfWidth;\n                tx1 = borderValue + axisHalfWidth;\n                tx2 = me.left + tl;\n            } else if (axis === 'x') {\n                if (position === 'center') {\n                    borderValue = alignBorderValue((chartArea.top + chartArea.bottom) / 2 + 0.5);\n                } else if (isObject(position)) {\n                    const positionAxisID = Object.keys(position)[0];\n                    const value = position[positionAxisID];\n                    borderValue = alignBorderValue(me.chart.scales[positionAxisID].getPixelForValue(value));\n                }\n                y1 = chartArea.top;\n                y2 = chartArea.bottom;\n                ty1 = borderValue + axisHalfWidth;\n                ty2 = ty1 + tl;\n            } else if (axis === 'y') {\n                if (position === 'center') {\n                    borderValue = alignBorderValue((chartArea.left + chartArea.right) / 2);\n                } else if (isObject(position)) {\n                    const positionAxisID = Object.keys(position)[0];\n                    const value = position[positionAxisID];\n                    borderValue = alignBorderValue(me.chart.scales[positionAxisID].getPixelForValue(value));\n                }\n                tx1 = borderValue - axisHalfWidth;\n                tx2 = tx1 - tl;\n                x1 = chartArea.left;\n                x2 = chartArea.right;\n            }\n            for (i = 0; i < ticksLength; ++i) {\n                const optsAtIndex = grid.setContext(me.getContext(i));\n                const lineWidth = optsAtIndex.lineWidth;\n                const lineColor = optsAtIndex.color;\n                const borderDash = grid.borderDash || [];\n                const borderDashOffset = optsAtIndex.borderDashOffset;\n                const tickWidth = optsAtIndex.tickWidth;\n                const tickColor = optsAtIndex.tickColor;\n                const tickBorderDash = optsAtIndex.tickBorderDash || [];\n                const tickBorderDashOffset = optsAtIndex.tickBorderDashOffset;\n                lineValue = getPixelForGridLine(me, i, offset);\n                if (lineValue === undefined) {\n                    continue;\n                }\n                alignedLineValue = _alignPixel(chart, lineValue, lineWidth);\n                if (isHorizontal) {\n                    tx1 = tx2 = x1 = x2 = alignedLineValue;\n                } else {\n                    ty1 = ty2 = y1 = y2 = alignedLineValue;\n                }\n                items.push({\n                    tx1,\n                    ty1,\n                    tx2,\n                    ty2,\n                    x1,\n                    y1,\n                    x2,\n                    y2,\n                    width: lineWidth,\n                    color: lineColor,\n                    borderDash,\n                    borderDashOffset,\n                    tickWidth,\n                    tickColor,\n                    tickBorderDash,\n                    tickBorderDashOffset,\n                });\n            }\n            me._ticksLength = ticksLength;\n            me._borderValue = borderValue;\n            return items;\n        }\n        _computeLabelItems(chartArea) {\n            const me = this;\n            const axis = me.axis;\n            const options = me.options;\n            const {position, ticks: optionTicks} = options;\n            const isHorizontal = me.isHorizontal();\n            const ticks = me.ticks;\n            const {align, crossAlign, padding, mirror} = optionTicks;\n            const tl = getTickMarkLength(options.grid);\n            const tickAndPadding = tl + padding;\n            const hTickAndPadding = mirror ? -padding : tickAndPadding;\n            const rotation = -toRadians(me.labelRotation);\n            const items = [];\n            let i, ilen, tick, label, x, y, textAlign, pixel, font, lineHeight, lineCount, textOffset;\n            let textBaseline = 'middle';\n            if (position === 'top') {\n                y = me.bottom - hTickAndPadding;\n                textAlign = me._getXAxisLabelAlignment();\n            } else if (position === 'bottom') {\n                y = me.top + hTickAndPadding;\n                textAlign = me._getXAxisLabelAlignment();\n            } else if (position === 'left') {\n                const ret = me._getYAxisLabelAlignment(tl);\n                textAlign = ret.textAlign;\n                x = ret.x;\n            } else if (position === 'right') {\n                const ret = me._getYAxisLabelAlignment(tl);\n                textAlign = ret.textAlign;\n                x = ret.x;\n            } else if (axis === 'x') {\n                if (position === 'center') {\n                    y = ((chartArea.top + chartArea.bottom) / 2) + tickAndPadding;\n                } else if (isObject(position)) {\n                    const positionAxisID = Object.keys(position)[0];\n                    const value = position[positionAxisID];\n                    y = me.chart.scales[positionAxisID].getPixelForValue(value) + tickAndPadding;\n                }\n                textAlign = me._getXAxisLabelAlignment();\n            } else if (axis === 'y') {\n                if (position === 'center') {\n                    x = ((chartArea.left + chartArea.right) / 2) - tickAndPadding;\n                } else if (isObject(position)) {\n                    const positionAxisID = Object.keys(position)[0];\n                    const value = position[positionAxisID];\n                    x = me.chart.scales[positionAxisID].getPixelForValue(value);\n                }\n                textAlign = me._getYAxisLabelAlignment(tl).textAlign;\n            }\n            if (axis === 'y') {\n                if (align === 'start') {\n                    textBaseline = 'top';\n                } else if (align === 'end') {\n                    textBaseline = 'bottom';\n                }\n            }\n            const labelSizes = me._getLabelSizes();\n            for (i = 0, ilen = ticks.length; i < ilen; ++i) {\n                tick = ticks[i];\n                label = tick.label;\n                const optsAtIndex = optionTicks.setContext(me.getContext(i));\n                pixel = me.getPixelForTick(i) + optionTicks.labelOffset;\n                font = me._resolveTickFontOptions(i);\n                lineHeight = font.lineHeight;\n                lineCount = isArray(label) ? label.length : 1;\n                const halfCount = lineCount / 2;\n                const color = optsAtIndex.color;\n                const strokeColor = optsAtIndex.textStrokeColor;\n                const strokeWidth = optsAtIndex.textStrokeWidth;\n                if (isHorizontal) {\n                    x = pixel;\n                    if (position === 'top') {\n                        if (crossAlign === 'near' || rotation !== 0) {\n                            textOffset = -lineCount * lineHeight + lineHeight / 2;\n                        } else if (crossAlign === 'center') {\n                            textOffset = -labelSizes.highest.height / 2 - halfCount * lineHeight + lineHeight;\n                        } else {\n                            textOffset = -labelSizes.highest.height + lineHeight / 2;\n                        }\n                    } else {\n                        if (crossAlign === 'near' || rotation !== 0) {\n                            textOffset = lineHeight / 2;\n                        } else if (crossAlign === 'center') {\n                            textOffset = labelSizes.highest.height / 2 - halfCount * lineHeight;\n                        } else {\n                            textOffset = labelSizes.highest.height - lineCount * lineHeight;\n                        }\n                    }\n                    if (mirror) {\n                        textOffset *= -1;\n                    }\n                } else {\n                    y = pixel;\n                    textOffset = (1 - lineCount) * lineHeight / 2;\n                }\n                let backdrop;\n                if (optsAtIndex.showLabelBackdrop) {\n                    const labelPadding = toPadding(optsAtIndex.backdropPadding);\n                    const height = labelSizes.heights[i];\n                    const width = labelSizes.widths[i];\n                    let top = y + textOffset - labelPadding.top;\n                    let left = x - labelPadding.left;\n                    switch (textBaseline) {\n                        case 'middle':\n                            top -= height / 2;\n                            break;\n                        case 'bottom':\n                            top -= height;\n                            break;\n                    }\n                    switch (textAlign) {\n                        case 'center':\n                            left -= width / 2;\n                            break;\n                        case 'right':\n                            left -= width;\n                            break;\n                    }\n                    backdrop = {\n                        left,\n                        top,\n                        width: width + labelPadding.width,\n                        height: height + labelPadding.height,\n                        color: optsAtIndex.backdropColor,\n                    };\n                }\n                items.push({\n                    rotation,\n                    label,\n                    font,\n                    color,\n                    strokeColor,\n                    strokeWidth,\n                    textOffset,\n                    textAlign,\n                    textBaseline,\n                    translation: [x, y],\n                    backdrop,\n                });\n            }\n            return items;\n        }\n        _getXAxisLabelAlignment() {\n            const me = this;\n            const {position, ticks} = me.options;\n            const rotation = -toRadians(me.labelRotation);\n            if (rotation) {\n                return position === 'top' ? 'left' : 'right';\n            }\n            let align = 'center';\n            if (ticks.align === 'start') {\n                align = 'left';\n            } else if (ticks.align === 'end') {\n                align = 'right';\n            }\n            return align;\n        }\n        _getYAxisLabelAlignment(tl) {\n            const me = this;\n            const {position, ticks: {crossAlign, mirror, padding}} = me.options;\n            const labelSizes = me._getLabelSizes();\n            const tickAndPadding = tl + padding;\n            const widest = labelSizes.widest.width;\n            let textAlign;\n            let x;\n            if (position === 'left') {\n                if (mirror) {\n                    textAlign = 'left';\n                    x = me.right + padding;\n                } else {\n                    x = me.right - tickAndPadding;\n                    if (crossAlign === 'near') {\n                        textAlign = 'right';\n                    } else if (crossAlign === 'center') {\n                        textAlign = 'center';\n                        x -= (widest / 2);\n                    } else {\n                        textAlign = 'left';\n                        x = me.left;\n                    }\n                }\n            } else if (position === 'right') {\n                if (mirror) {\n                    textAlign = 'right';\n                    x = me.left + padding;\n                } else {\n                    x = me.left + tickAndPadding;\n                    if (crossAlign === 'near') {\n                        textAlign = 'left';\n                    } else if (crossAlign === 'center') {\n                        textAlign = 'center';\n                        x += widest / 2;\n                    } else {\n                        textAlign = 'right';\n                        x = me.right;\n                    }\n                }\n            } else {\n                textAlign = 'right';\n            }\n            return {textAlign, x};\n        }\n        _computeLabelArea() {\n            const me = this;\n            if (me.options.ticks.mirror) {\n                return;\n            }\n            const chart = me.chart;\n            const position = me.options.position;\n            if (position === 'left' || position === 'right') {\n                return {top: 0, left: me.left, bottom: chart.height, right: me.right};\n            } if (position === 'top' || position === 'bottom') {\n                return {top: me.top, left: 0, bottom: me.bottom, right: chart.width};\n            }\n        }\n        drawBackground() {\n            const {ctx, options: {backgroundColor}, left, top, width, height} = this;\n            if (backgroundColor) {\n                ctx.save();\n                ctx.fillStyle = backgroundColor;\n                ctx.fillRect(left, top, width, height);\n                ctx.restore();\n            }\n        }\n        getLineWidthForValue(value) {\n            const me = this;\n            const grid = me.options.grid;\n            if (!me._isVisible() || !grid.display) {\n                return 0;\n            }\n            const ticks = me.ticks;\n            const index = ticks.findIndex(t => t.value === value);\n            if (index >= 0) {\n                const opts = grid.setContext(me.getContext(index));\n                return opts.lineWidth;\n            }\n            return 0;\n        }\n        drawGrid(chartArea) {\n            const me = this;\n            const grid = me.options.grid;\n            const ctx = me.ctx;\n            const items = me._gridLineItems || (me._gridLineItems = me._computeGridLineItems(chartArea));\n            let i, ilen;\n            const drawLine = (p1, p2, style) => {\n                if (!style.width || !style.color) {\n                    return;\n                }\n                ctx.save();\n                ctx.lineWidth = style.width;\n                ctx.strokeStyle = style.color;\n                ctx.setLineDash(style.borderDash || []);\n                ctx.lineDashOffset = style.borderDashOffset;\n                ctx.beginPath();\n                ctx.moveTo(p1.x, p1.y);\n                ctx.lineTo(p2.x, p2.y);\n                ctx.stroke();\n                ctx.restore();\n            };\n            if (grid.display) {\n                for (i = 0, ilen = items.length; i < ilen; ++i) {\n                    const item = items[i];\n                    if (grid.drawOnChartArea) {\n                        drawLine(\n                            {x: item.x1, y: item.y1},\n                            {x: item.x2, y: item.y2},\n                            item\n                        );\n                    }\n                    if (grid.drawTicks) {\n                        drawLine(\n                            {x: item.tx1, y: item.ty1},\n                            {x: item.tx2, y: item.ty2},\n                            {\n                                color: item.tickColor,\n                                width: item.tickWidth,\n                                borderDash: item.tickBorderDash,\n                                borderDashOffset: item.tickBorderDashOffset\n                            }\n                        );\n                    }\n                }\n            }\n        }\n        drawBorder() {\n            const me = this;\n            const {chart, ctx, options: {grid}} = me;\n            const borderOpts = grid.setContext(me.getContext());\n            const axisWidth = grid.drawBorder ? borderOpts.borderWidth : 0;\n            if (!axisWidth) {\n                return;\n            }\n            const lastLineWidth = grid.setContext(me.getContext(0)).lineWidth;\n            const borderValue = me._borderValue;\n            let x1, x2, y1, y2;\n            if (me.isHorizontal()) {\n                x1 = _alignPixel(chart, me.left, axisWidth) - axisWidth / 2;\n                x2 = _alignPixel(chart, me.right, lastLineWidth) + lastLineWidth / 2;\n                y1 = y2 = borderValue;\n            } else {\n                y1 = _alignPixel(chart, me.top, axisWidth) - axisWidth / 2;\n                y2 = _alignPixel(chart, me.bottom, lastLineWidth) + lastLineWidth / 2;\n                x1 = x2 = borderValue;\n            }\n            ctx.save();\n            ctx.lineWidth = borderOpts.borderWidth;\n            ctx.strokeStyle = borderOpts.borderColor;\n            ctx.beginPath();\n            ctx.moveTo(x1, y1);\n            ctx.lineTo(x2, y2);\n            ctx.stroke();\n            ctx.restore();\n        }\n        drawLabels(chartArea) {\n            const me = this;\n            const optionTicks = me.options.ticks;\n            if (!optionTicks.display) {\n                return;\n            }\n            const ctx = me.ctx;\n            const area = me._computeLabelArea();\n            if (area) {\n                clipArea(ctx, area);\n            }\n            const items = me._labelItems || (me._labelItems = me._computeLabelItems(chartArea));\n            let i, ilen;\n            for (i = 0, ilen = items.length; i < ilen; ++i) {\n                const item = items[i];\n                const tickFont = item.font;\n                const label = item.label;\n                if (item.backdrop) {\n                    ctx.fillStyle = item.backdrop.color;\n                    ctx.fillRect(item.backdrop.left, item.backdrop.top, item.backdrop.width, item.backdrop.height);\n                }\n                let y = item.textOffset;\n                renderText(ctx, label, 0, y, tickFont, item);\n            }\n            if (area) {\n                unclipArea(ctx);\n            }\n        }\n        drawTitle() {\n            const {ctx, options: {position, title, reverse}} = this;\n            if (!title.display) {\n                return;\n            }\n            const font = toFont(title.font);\n            const padding = toPadding(title.padding);\n            const align = title.align;\n            let offset = font.lineHeight / 2;\n            if (position === 'bottom') {\n                offset += padding.bottom;\n                if (isArray(title.text)) {\n                    offset += font.lineHeight * (title.text.length - 1);\n                }\n            } else {\n                offset += padding.top;\n            }\n            const {titleX, titleY, maxWidth, rotation} = titleArgs(this, offset, position, align);\n            renderText(ctx, title.text, 0, 0, font, {\n                color: title.color,\n                maxWidth,\n                rotation,\n                textAlign: titleAlign(align, position, reverse),\n                textBaseline: 'middle',\n                translation: [titleX, titleY],\n            });\n        }\n        draw(chartArea) {\n            const me = this;\n            if (!me._isVisible()) {\n                return;\n            }\n            me.drawBackground();\n            me.drawGrid(chartArea);\n            me.drawBorder();\n            me.drawTitle();\n            me.drawLabels(chartArea);\n        }\n        _layers() {\n            const me = this;\n            const opts = me.options;\n            const tz = opts.ticks && opts.ticks.z || 0;\n            const gz = opts.grid && opts.grid.z || 0;\n            if (!me._isVisible() || me.draw !== Scale.prototype.draw) {\n                return [{\n                    z: tz,\n                    draw(chartArea) {\n                        me.draw(chartArea);\n                    }\n                }];\n            }\n            return [{\n                z: gz,\n                draw(chartArea) {\n                    me.drawBackground();\n                    me.drawGrid(chartArea);\n                    me.drawTitle();\n                }\n            }, {\n                z: gz + 1,\n                draw() {\n                    me.drawBorder();\n                }\n            }, {\n                z: tz,\n                draw(chartArea) {\n                    me.drawLabels(chartArea);\n                }\n            }];\n        }\n        getMatchingVisibleMetas(type) {\n            const me = this;\n            const metas = me.chart.getSortedVisibleDatasetMetas();\n            const axisID = me.axis + 'AxisID';\n            const result = [];\n            let i, ilen;\n            for (i = 0, ilen = metas.length; i < ilen; ++i) {\n                const meta = metas[i];\n                if (meta[axisID] === me.id && (!type || meta.type === type)) {\n                    result.push(meta);\n                }\n            }\n            return result;\n        }\n        _resolveTickFontOptions(index) {\n            const opts = this.options.ticks.setContext(this.getContext(index));\n            return toFont(opts.font);\n        }\n        _maxDigits() {\n            const me = this;\n            const fontSize = me._resolveTickFontOptions(0).lineHeight;\n            return (me.isHorizontal() ? me.width : me.height) / fontSize;\n        }\n    }\n\n    function _createResolver(scopes, prefixes = [''], rootScopes = scopes, fallback, getTarget = () => scopes[0]) {\n        if (!defined(fallback)) {\n            fallback = _resolve('_fallback', scopes);\n        }\n        const cache = {\n            [Symbol.toStringTag]: 'Object',\n            _cacheable: true,\n            _scopes: scopes,\n            _rootScopes: rootScopes,\n            _fallback: fallback,\n            _getTarget: getTarget,\n            override: (scope) => _createResolver([scope, ...scopes], prefixes, rootScopes, fallback),\n        };\n        return new Proxy(cache, {\n            deleteProperty(target, prop) {\n                delete target[prop];\n                delete target._keys;\n                delete scopes[0][prop];\n                return true;\n            },\n            get(target, prop) {\n                return _cached(target, prop,\n                    () => _resolveWithPrefixes(prop, prefixes, scopes, target));\n            },\n            getOwnPropertyDescriptor(target, prop) {\n                return Reflect.getOwnPropertyDescriptor(target._scopes[0], prop);\n            },\n            getPrototypeOf() {\n                return Reflect.getPrototypeOf(scopes[0]);\n            },\n            has(target, prop) {\n                return getKeysFromAllScopes(target).includes(prop);\n            },\n            ownKeys(target) {\n                return getKeysFromAllScopes(target);\n            },\n            set(target, prop, value) {\n                const storage = target._storage || (target._storage = getTarget());\n                storage[prop] = value;\n                delete target[prop];\n                delete target._keys;\n                return true;\n            }\n        });\n    }\n    function _attachContext(proxy, context, subProxy, descriptorDefaults) {\n        const cache = {\n            _cacheable: false,\n            _proxy: proxy,\n            _context: context,\n            _subProxy: subProxy,\n            _stack: new Set(),\n            _descriptors: _descriptors(proxy, descriptorDefaults),\n            setContext: (ctx) => _attachContext(proxy, ctx, subProxy, descriptorDefaults),\n            override: (scope) => _attachContext(proxy.override(scope), context, subProxy, descriptorDefaults)\n        };\n        return new Proxy(cache, {\n            deleteProperty(target, prop) {\n                delete target[prop];\n                delete proxy[prop];\n                return true;\n            },\n            get(target, prop, receiver) {\n                return _cached(target, prop,\n                    () => _resolveWithContext(target, prop, receiver));\n            },\n            getOwnPropertyDescriptor(target, prop) {\n                return target._descriptors.allKeys\n                    ? Reflect.has(proxy, prop) ? {enumerable: true, configurable: true} : undefined\n                    : Reflect.getOwnPropertyDescriptor(proxy, prop);\n            },\n            getPrototypeOf() {\n                return Reflect.getPrototypeOf(proxy);\n            },\n            has(target, prop) {\n                return Reflect.has(proxy, prop);\n            },\n            ownKeys() {\n                return Reflect.ownKeys(proxy);\n            },\n            set(target, prop, value) {\n                proxy[prop] = value;\n                delete target[prop];\n                return true;\n            }\n        });\n    }\n    function _descriptors(proxy, defaults = {scriptable: true, indexable: true}) {\n        const {_scriptable = defaults.scriptable, _indexable = defaults.indexable, _allKeys = defaults.allKeys} = proxy;\n        return {\n            allKeys: _allKeys,\n            scriptable: _scriptable,\n            indexable: _indexable,\n            isScriptable: isFunction(_scriptable) ? _scriptable : () => _scriptable,\n            isIndexable: isFunction(_indexable) ? _indexable : () => _indexable\n        };\n    }\n    const readKey = (prefix, name) => prefix ? prefix + _capitalize(name) : name;\n    const needsSubResolver = (prop, value) => isObject(value) && prop !== 'adapters';\n    function _cached(target, prop, resolve) {\n        let value = target[prop];\n        if (defined(value)) {\n            return value;\n        }\n        value = resolve();\n        if (defined(value)) {\n            target[prop] = value;\n        }\n        return value;\n    }\n    function _resolveWithContext(target, prop, receiver) {\n        const {_proxy, _context, _subProxy, _descriptors: descriptors} = target;\n        let value = _proxy[prop];\n        if (isFunction(value) && descriptors.isScriptable(prop)) {\n            value = _resolveScriptable(prop, value, target, receiver);\n        }\n        if (isArray(value) && value.length) {\n            value = _resolveArray(prop, value, target, descriptors.isIndexable);\n        }\n        if (needsSubResolver(prop, value)) {\n            value = _attachContext(value, _context, _subProxy && _subProxy[prop], descriptors);\n        }\n        return value;\n    }\n    function _resolveScriptable(prop, value, target, receiver) {\n        const {_proxy, _context, _subProxy, _stack} = target;\n        if (_stack.has(prop)) {\n            throw new Error('Recursion detected: ' + [..._stack].join('->') + '->' + prop);\n        }\n        _stack.add(prop);\n        value = value(_context, _subProxy || receiver);\n        _stack.delete(prop);\n        if (isObject(value)) {\n            value = createSubResolver(_proxy._scopes, _proxy, prop, value);\n        }\n        return value;\n    }\n    function _resolveArray(prop, value, target, isIndexable) {\n        const {_proxy, _context, _subProxy, _descriptors: descriptors} = target;\n        if (defined(_context.index) && isIndexable(prop)) {\n            value = value[_context.index % value.length];\n        } else if (isObject(value[0])) {\n            const arr = value;\n            const scopes = _proxy._scopes.filter(s => s !== arr);\n            value = [];\n            for (const item of arr) {\n                const resolver = createSubResolver(scopes, _proxy, prop, item);\n                value.push(_attachContext(resolver, _context, _subProxy && _subProxy[prop], descriptors));\n            }\n        }\n        return value;\n    }\n    function resolveFallback(fallback, prop, value) {\n        return isFunction(fallback) ? fallback(prop, value) : fallback;\n    }\n    const getScope = (key, parent) => key === true ? parent\n        : typeof key === 'string' ? resolveObjectKey(parent, key) : undefined;\n    function addScopes(set, parentScopes, key, parentFallback) {\n        for (const parent of parentScopes) {\n            const scope = getScope(key, parent);\n            if (scope) {\n                set.add(scope);\n                const fallback = resolveFallback(scope._fallback, key, scope);\n                if (defined(fallback) && fallback !== key && fallback !== parentFallback) {\n                    return fallback;\n                }\n            } else if (scope === false && defined(parentFallback) && key !== parentFallback) {\n                return null;\n            }\n        }\n        return false;\n    }\n    function createSubResolver(parentScopes, resolver, prop, value) {\n        const rootScopes = resolver._rootScopes;\n        const fallback = resolveFallback(resolver._fallback, prop, value);\n        const allScopes = [...parentScopes, ...rootScopes];\n        const set = new Set();\n        set.add(value);\n        let key = addScopesFromKey(set, allScopes, prop, fallback || prop);\n        if (key === null) {\n            return false;\n        }\n        if (defined(fallback) && fallback !== prop) {\n            key = addScopesFromKey(set, allScopes, fallback, key);\n            if (key === null) {\n                return false;\n            }\n        }\n        return _createResolver([...set], [''], rootScopes, fallback,\n            () => subGetTarget(resolver, prop, value));\n    }\n    function addScopesFromKey(set, allScopes, key, fallback) {\n        while (key) {\n            key = addScopes(set, allScopes, key, fallback);\n        }\n        return key;\n    }\n    function subGetTarget(resolver, prop, value) {\n        const parent = resolver._getTarget();\n        if (!(prop in parent)) {\n            parent[prop] = {};\n        }\n        const target = parent[prop];\n        if (isArray(target) && isObject(value)) {\n            return value;\n        }\n        return target;\n    }\n    function _resolveWithPrefixes(prop, prefixes, scopes, proxy) {\n        let value;\n        for (const prefix of prefixes) {\n            value = _resolve(readKey(prefix, prop), scopes);\n            if (defined(value)) {\n                return needsSubResolver(prop, value)\n                    ? createSubResolver(scopes, proxy, prop, value)\n                    : value;\n            }\n        }\n    }\n    function _resolve(key, scopes) {\n        for (const scope of scopes) {\n            if (!scope) {\n                continue;\n            }\n            const value = scope[key];\n            if (defined(value)) {\n                return value;\n            }\n        }\n    }\n    function getKeysFromAllScopes(target) {\n        let keys = target._keys;\n        if (!keys) {\n            keys = target._keys = resolveKeysFromAllScopes(target._scopes);\n        }\n        return keys;\n    }\n    function resolveKeysFromAllScopes(scopes) {\n        const set = new Set();\n        for (const scope of scopes) {\n            for (const key of Object.keys(scope).filter(k => !k.startsWith('_'))) {\n                set.add(key);\n            }\n        }\n        return [...set];\n    }\n\n    const EPSILON = Number.EPSILON || 1e-14;\n    const getPoint = (points, i) => i < points.length && !points[i].skip && points[i];\n    const getValueAxis = (indexAxis) => indexAxis === 'x' ? 'y' : 'x';\n    function splineCurve(firstPoint, middlePoint, afterPoint, t) {\n        const previous = firstPoint.skip ? middlePoint : firstPoint;\n        const current = middlePoint;\n        const next = afterPoint.skip ? middlePoint : afterPoint;\n        const d01 = distanceBetweenPoints(current, previous);\n        const d12 = distanceBetweenPoints(next, current);\n        let s01 = d01 / (d01 + d12);\n        let s12 = d12 / (d01 + d12);\n        s01 = isNaN(s01) ? 0 : s01;\n        s12 = isNaN(s12) ? 0 : s12;\n        const fa = t * s01;\n        const fb = t * s12;\n        return {\n            previous: {\n                x: current.x - fa * (next.x - previous.x),\n                y: current.y - fa * (next.y - previous.y)\n            },\n            next: {\n                x: current.x + fb * (next.x - previous.x),\n                y: current.y + fb * (next.y - previous.y)\n            }\n        };\n    }\n    function monotoneAdjust(points, deltaK, mK) {\n        const pointsLen = points.length;\n        let alphaK, betaK, tauK, squaredMagnitude, pointCurrent;\n        let pointAfter = getPoint(points, 0);\n        for (let i = 0; i < pointsLen - 1; ++i) {\n            pointCurrent = pointAfter;\n            pointAfter = getPoint(points, i + 1);\n            if (!pointCurrent || !pointAfter) {\n                continue;\n            }\n            if (almostEquals(deltaK[i], 0, EPSILON)) {\n                mK[i] = mK[i + 1] = 0;\n                continue;\n            }\n            alphaK = mK[i] / deltaK[i];\n            betaK = mK[i + 1] / deltaK[i];\n            squaredMagnitude = Math.pow(alphaK, 2) + Math.pow(betaK, 2);\n            if (squaredMagnitude <= 9) {\n                continue;\n            }\n            tauK = 3 / Math.sqrt(squaredMagnitude);\n            mK[i] = alphaK * tauK * deltaK[i];\n            mK[i + 1] = betaK * tauK * deltaK[i];\n        }\n    }\n    function monotoneCompute(points, mK, indexAxis = 'x') {\n        const valueAxis = getValueAxis(indexAxis);\n        const pointsLen = points.length;\n        let delta, pointBefore, pointCurrent;\n        let pointAfter = getPoint(points, 0);\n        for (let i = 0; i < pointsLen; ++i) {\n            pointBefore = pointCurrent;\n            pointCurrent = pointAfter;\n            pointAfter = getPoint(points, i + 1);\n            if (!pointCurrent) {\n                continue;\n            }\n            const iPixel = pointCurrent[indexAxis];\n            const vPixel = pointCurrent[valueAxis];\n            if (pointBefore) {\n                delta = (iPixel - pointBefore[indexAxis]) / 3;\n                pointCurrent[`cp1${indexAxis}`] = iPixel - delta;\n                pointCurrent[`cp1${valueAxis}`] = vPixel - delta * mK[i];\n            }\n            if (pointAfter) {\n                delta = (pointAfter[indexAxis] - iPixel) / 3;\n                pointCurrent[`cp2${indexAxis}`] = iPixel + delta;\n                pointCurrent[`cp2${valueAxis}`] = vPixel + delta * mK[i];\n            }\n        }\n    }\n    function splineCurveMonotone(points, indexAxis = 'x') {\n        const valueAxis = getValueAxis(indexAxis);\n        const pointsLen = points.length;\n        const deltaK = Array(pointsLen).fill(0);\n        const mK = Array(pointsLen);\n        let i, pointBefore, pointCurrent;\n        let pointAfter = getPoint(points, 0);\n        for (i = 0; i < pointsLen; ++i) {\n            pointBefore = pointCurrent;\n            pointCurrent = pointAfter;\n            pointAfter = getPoint(points, i + 1);\n            if (!pointCurrent) {\n                continue;\n            }\n            if (pointAfter) {\n                const slopeDelta = pointAfter[indexAxis] - pointCurrent[indexAxis];\n                deltaK[i] = slopeDelta !== 0 ? (pointAfter[valueAxis] - pointCurrent[valueAxis]) / slopeDelta : 0;\n            }\n            mK[i] = !pointBefore ? deltaK[i]\n                : !pointAfter ? deltaK[i - 1]\n                    : (sign(deltaK[i - 1]) !== sign(deltaK[i])) ? 0\n                        : (deltaK[i - 1] + deltaK[i]) / 2;\n        }\n        monotoneAdjust(points, deltaK, mK);\n        monotoneCompute(points, mK, indexAxis);\n    }\n    function capControlPoint(pt, min, max) {\n        return Math.max(Math.min(pt, max), min);\n    }\n    function capBezierPoints(points, area) {\n        let i, ilen, point, inArea, inAreaPrev;\n        let inAreaNext = _isPointInArea(points[0], area);\n        for (i = 0, ilen = points.length; i < ilen; ++i) {\n            inAreaPrev = inArea;\n            inArea = inAreaNext;\n            inAreaNext = i < ilen - 1 && _isPointInArea(points[i + 1], area);\n            if (!inArea) {\n                continue;\n            }\n            point = points[i];\n            if (inAreaPrev) {\n                point.cp1x = capControlPoint(point.cp1x, area.left, area.right);\n                point.cp1y = capControlPoint(point.cp1y, area.top, area.bottom);\n            }\n            if (inAreaNext) {\n                point.cp2x = capControlPoint(point.cp2x, area.left, area.right);\n                point.cp2y = capControlPoint(point.cp2y, area.top, area.bottom);\n            }\n        }\n    }\n    function _updateBezierControlPoints(points, options, area, loop, indexAxis) {\n        let i, ilen, point, controlPoints;\n        if (options.spanGaps) {\n            points = points.filter((pt) => !pt.skip);\n        }\n        if (options.cubicInterpolationMode === 'monotone') {\n            splineCurveMonotone(points, indexAxis);\n        } else {\n            let prev = loop ? points[points.length - 1] : points[0];\n            for (i = 0, ilen = points.length; i < ilen; ++i) {\n                point = points[i];\n                controlPoints = splineCurve(\n                    prev,\n                    point,\n                    points[Math.min(i + 1, ilen - (loop ? 0 : 1)) % ilen],\n                    options.tension\n                );\n                point.cp1x = controlPoints.previous.x;\n                point.cp1y = controlPoints.previous.y;\n                point.cp2x = controlPoints.next.x;\n                point.cp2y = controlPoints.next.y;\n                prev = point;\n            }\n        }\n        if (options.capBezierPoints) {\n            capBezierPoints(points, area);\n        }\n    }\n\n    function _pointInLine(p1, p2, t, mode) {\n        return {\n            x: p1.x + t * (p2.x - p1.x),\n            y: p1.y + t * (p2.y - p1.y)\n        };\n    }\n    function _steppedInterpolation(p1, p2, t, mode) {\n        return {\n            x: p1.x + t * (p2.x - p1.x),\n            y: mode === 'middle' ? t < 0.5 ? p1.y : p2.y\n                : mode === 'after' ? t < 1 ? p1.y : p2.y\n                    : t > 0 ? p2.y : p1.y\n        };\n    }\n    function _bezierInterpolation(p1, p2, t, mode) {\n        const cp1 = {x: p1.cp2x, y: p1.cp2y};\n        const cp2 = {x: p2.cp1x, y: p2.cp1y};\n        const a = _pointInLine(p1, cp1, t);\n        const b = _pointInLine(cp1, cp2, t);\n        const c = _pointInLine(cp2, p2, t);\n        const d = _pointInLine(a, b, t);\n        const e = _pointInLine(b, c, t);\n        return _pointInLine(d, e, t);\n    }\n\n    const getRightToLeftAdapter = function(rectX, width) {\n        return {\n            x(x) {\n                return rectX + rectX + width - x;\n            },\n            setWidth(w) {\n                width = w;\n            },\n            textAlign(align) {\n                if (align === 'center') {\n                    return align;\n                }\n                return align === 'right' ? 'left' : 'right';\n            },\n            xPlus(x, value) {\n                return x - value;\n            },\n            leftForLtr(x, itemWidth) {\n                return x - itemWidth;\n            },\n        };\n    };\n    const getLeftToRightAdapter = function() {\n        return {\n            x(x) {\n                return x;\n            },\n            setWidth(w) {\n            },\n            textAlign(align) {\n                return align;\n            },\n            xPlus(x, value) {\n                return x + value;\n            },\n            leftForLtr(x, _itemWidth) {\n                return x;\n            },\n        };\n    };\n    function getRtlAdapter(rtl, rectX, width) {\n        return rtl ? getRightToLeftAdapter(rectX, width) : getLeftToRightAdapter();\n    }\n    function overrideTextDirection(ctx, direction) {\n        let style, original;\n        if (direction === 'ltr' || direction === 'rtl') {\n            style = ctx.canvas.style;\n            original = [\n                style.getPropertyValue('direction'),\n                style.getPropertyPriority('direction'),\n            ];\n            style.setProperty('direction', direction, 'important');\n            ctx.prevTextDirection = original;\n        }\n    }\n    function restoreTextDirection(ctx, original) {\n        if (original !== undefined) {\n            delete ctx.prevTextDirection;\n            ctx.canvas.style.setProperty('direction', original[0], original[1]);\n        }\n    }\n\n    function propertyFn(property) {\n        if (property === 'angle') {\n            return {\n                between: _angleBetween,\n                compare: _angleDiff,\n                normalize: _normalizeAngle,\n            };\n        }\n        return {\n            between: (n, s, e) => n >= Math.min(s, e) && n <= Math.max(e, s),\n            compare: (a, b) => a - b,\n            normalize: x => x\n        };\n    }\n    function normalizeSegment({start, end, count, loop, style}) {\n        return {\n            start: start % count,\n            end: end % count,\n            loop: loop && (end - start + 1) % count === 0,\n            style\n        };\n    }\n    function getSegment(segment, points, bounds) {\n        const {property, start: startBound, end: endBound} = bounds;\n        const {between, normalize} = propertyFn(property);\n        const count = points.length;\n        let {start, end, loop} = segment;\n        let i, ilen;\n        if (loop) {\n            start += count;\n            end += count;\n            for (i = 0, ilen = count; i < ilen; ++i) {\n                if (!between(normalize(points[start % count][property]), startBound, endBound)) {\n                    break;\n                }\n                start--;\n                end--;\n            }\n            start %= count;\n            end %= count;\n        }\n        if (end < start) {\n            end += count;\n        }\n        return {start, end, loop, style: segment.style};\n    }\n    function _boundSegment(segment, points, bounds) {\n        if (!bounds) {\n            return [segment];\n        }\n        const {property, start: startBound, end: endBound} = bounds;\n        const count = points.length;\n        const {compare, between, normalize} = propertyFn(property);\n        const {start, end, loop, style} = getSegment(segment, points, bounds);\n        const result = [];\n        let inside = false;\n        let subStart = null;\n        let value, point, prevValue;\n        const startIsBefore = () => between(startBound, prevValue, value) && compare(startBound, prevValue) !== 0;\n        const endIsBefore = () => compare(endBound, value) === 0 || between(endBound, prevValue, value);\n        const shouldStart = () => inside || startIsBefore();\n        const shouldStop = () => !inside || endIsBefore();\n        for (let i = start, prev = start; i <= end; ++i) {\n            point = points[i % count];\n            if (point.skip) {\n                continue;\n            }\n            value = normalize(point[property]);\n            if (value === prevValue) {\n                continue;\n            }\n            inside = between(value, startBound, endBound);\n            if (subStart === null && shouldStart()) {\n                subStart = compare(value, startBound) === 0 ? i : prev;\n            }\n            if (subStart !== null && shouldStop()) {\n                result.push(normalizeSegment({start: subStart, end: i, loop, count, style}));\n                subStart = null;\n            }\n            prev = i;\n            prevValue = value;\n        }\n        if (subStart !== null) {\n            result.push(normalizeSegment({start: subStart, end, loop, count, style}));\n        }\n        return result;\n    }\n    function _boundSegments(line, bounds) {\n        const result = [];\n        const segments = line.segments;\n        for (let i = 0; i < segments.length; i++) {\n            const sub = _boundSegment(segments[i], line.points, bounds);\n            if (sub.length) {\n                result.push(...sub);\n            }\n        }\n        return result;\n    }\n    function findStartAndEnd(points, count, loop, spanGaps) {\n        let start = 0;\n        let end = count - 1;\n        if (loop && !spanGaps) {\n            while (start < count && !points[start].skip) {\n                start++;\n            }\n        }\n        while (start < count && points[start].skip) {\n            start++;\n        }\n        start %= count;\n        if (loop) {\n            end += start;\n        }\n        while (end > start && points[end % count].skip) {\n            end--;\n        }\n        end %= count;\n        return {start, end};\n    }\n    function solidSegments(points, start, max, loop) {\n        const count = points.length;\n        const result = [];\n        let last = start;\n        let prev = points[start];\n        let end;\n        for (end = start + 1; end <= max; ++end) {\n            const cur = points[end % count];\n            if (cur.skip || cur.stop) {\n                if (!prev.skip) {\n                    loop = false;\n                    result.push({start: start % count, end: (end - 1) % count, loop});\n                    start = last = cur.stop ? end : null;\n                }\n            } else {\n                last = end;\n                if (prev.skip) {\n                    start = end;\n                }\n            }\n            prev = cur;\n        }\n        if (last !== null) {\n            result.push({start: start % count, end: last % count, loop});\n        }\n        return result;\n    }\n    function _computeSegments(line, segmentOptions) {\n        const points = line.points;\n        const spanGaps = line.options.spanGaps;\n        const count = points.length;\n        if (!count) {\n            return [];\n        }\n        const loop = !!line._loop;\n        const {start, end} = findStartAndEnd(points, count, loop, spanGaps);\n        if (spanGaps === true) {\n            return splitByStyles([{start, end, loop}], points, segmentOptions);\n        }\n        const max = end < start ? end + count : end;\n        const completeLoop = !!line._fullLoop && start === 0 && end === count - 1;\n        return splitByStyles(solidSegments(points, start, max, completeLoop), points, segmentOptions);\n    }\n    function splitByStyles(segments, points, segmentOptions) {\n        if (!segmentOptions || !segmentOptions.setContext || !points) {\n            return segments;\n        }\n        return doSplitByStyles(segments, points, segmentOptions);\n    }\n    function doSplitByStyles(segments, points, segmentOptions) {\n        const count = points.length;\n        const result = [];\n        let start = segments[0].start;\n        let i = start;\n        for (const segment of segments) {\n            let prevStyle, style;\n            let prev = points[start % count];\n            for (i = start + 1; i <= segment.end; i++) {\n                const pt = points[i % count];\n                style = readStyle(segmentOptions.setContext({type: 'segment', p0: prev, p1: pt}));\n                if (styleChanged(style, prevStyle)) {\n                    result.push({start: start, end: i - 1, loop: segment.loop, style: prevStyle});\n                    prevStyle = style;\n                    start = i - 1;\n                }\n                prev = pt;\n                prevStyle = style;\n            }\n            if (start < i - 1) {\n                result.push({start, end: i - 1, loop: segment.loop, style});\n                start = i - 1;\n            }\n        }\n        return result;\n    }\n    function readStyle(options) {\n        return {\n            backgroundColor: options.backgroundColor,\n            borderCapStyle: options.borderCapStyle,\n            borderDash: options.borderDash,\n            borderDashOffset: options.borderDashOffset,\n            borderJoinStyle: options.borderJoinStyle,\n            borderWidth: options.borderWidth,\n            borderColor: options.borderColor\n        };\n    }\n    function styleChanged(style, prevStyle) {\n        return prevStyle && JSON.stringify(style) !== JSON.stringify(prevStyle);\n    }\n\n    var helpers = /*#__PURE__*/Object.freeze({\n        __proto__: null,\n        easingEffects: effects,\n        color: color,\n        getHoverColor: getHoverColor,\n        noop: noop,\n        uid: uid,\n        isNullOrUndef: isNullOrUndef,\n        isArray: isArray,\n        isObject: isObject,\n        isFinite: isNumberFinite,\n        finiteOrDefault: finiteOrDefault,\n        valueOrDefault: valueOrDefault,\n        toPercentage: toPercentage,\n        toDimension: toDimension,\n        callback: callback,\n        each: each,\n        _elementsEqual: _elementsEqual,\n        clone: clone,\n        _merger: _merger,\n        merge: merge,\n        mergeIf: mergeIf,\n        _mergerIf: _mergerIf,\n        _deprecated: _deprecated,\n        resolveObjectKey: resolveObjectKey,\n        _capitalize: _capitalize,\n        defined: defined,\n        isFunction: isFunction,\n        setsEqual: setsEqual,\n        toFontString: toFontString,\n        _measureText: _measureText,\n        _longestText: _longestText,\n        _alignPixel: _alignPixel,\n        clearCanvas: clearCanvas,\n        drawPoint: drawPoint,\n        _isPointInArea: _isPointInArea,\n        clipArea: clipArea,\n        unclipArea: unclipArea,\n        _steppedLineTo: _steppedLineTo,\n        _bezierCurveTo: _bezierCurveTo,\n        renderText: renderText,\n        addRoundedRectPath: addRoundedRectPath,\n        _lookup: _lookup,\n        _lookupByKey: _lookupByKey,\n        _rlookupByKey: _rlookupByKey,\n        _filterBetween: _filterBetween,\n        listenArrayEvents: listenArrayEvents,\n        unlistenArrayEvents: unlistenArrayEvents,\n        _arrayUnique: _arrayUnique,\n        _createResolver: _createResolver,\n        _attachContext: _attachContext,\n        _descriptors: _descriptors,\n        splineCurve: splineCurve,\n        splineCurveMonotone: splineCurveMonotone,\n        _updateBezierControlPoints: _updateBezierControlPoints,\n        _getParentNode: _getParentNode,\n        getStyle: getStyle,\n        getRelativePosition: getRelativePosition$1,\n        getMaximumSize: getMaximumSize,\n        retinaScale: retinaScale,\n        supportsEventListenerOptions: supportsEventListenerOptions,\n        readUsedSize: readUsedSize,\n        fontString: fontString,\n        requestAnimFrame: requestAnimFrame,\n        throttled: throttled,\n        debounce: debounce,\n        _toLeftRightCenter: _toLeftRightCenter,\n        _alignStartEnd: _alignStartEnd,\n        _textX: _textX,\n        _pointInLine: _pointInLine,\n        _steppedInterpolation: _steppedInterpolation,\n        _bezierInterpolation: _bezierInterpolation,\n        formatNumber: formatNumber,\n        toLineHeight: toLineHeight,\n        _readValueToProps: _readValueToProps,\n        toTRBL: toTRBL,\n        toTRBLCorners: toTRBLCorners,\n        toPadding: toPadding,\n        toFont: toFont,\n        resolve: resolve,\n        _addGrace: _addGrace,\n        PI: PI,\n        TAU: TAU,\n        PITAU: PITAU,\n        INFINITY: INFINITY,\n        RAD_PER_DEG: RAD_PER_DEG,\n        HALF_PI: HALF_PI,\n        QUARTER_PI: QUARTER_PI,\n        TWO_THIRDS_PI: TWO_THIRDS_PI,\n        log10: log10,\n        sign: sign,\n        niceNum: niceNum,\n        _factorize: _factorize,\n        isNumber: isNumber,\n        almostEquals: almostEquals,\n        almostWhole: almostWhole,\n        _setMinAndMaxByKey: _setMinAndMaxByKey,\n        toRadians: toRadians,\n        toDegrees: toDegrees,\n        _decimalPlaces: _decimalPlaces,\n        getAngleFromPoint: getAngleFromPoint,\n        distanceBetweenPoints: distanceBetweenPoints,\n        _angleDiff: _angleDiff,\n        _normalizeAngle: _normalizeAngle,\n        _angleBetween: _angleBetween,\n        _limitValue: _limitValue,\n        _int16Range: _int16Range,\n        getRtlAdapter: getRtlAdapter,\n        overrideTextDirection: overrideTextDirection,\n        restoreTextDirection: restoreTextDirection,\n        _boundSegment: _boundSegment,\n        _boundSegments: _boundSegments,\n        _computeSegments: _computeSegments\n    });\n\n    class TypedRegistry {\n        constructor(type, scope, override) {\n            this.type = type;\n            this.scope = scope;\n            this.override = override;\n            this.items = Object.create(null);\n        }\n        isForType(type) {\n            return Object.prototype.isPrototypeOf.call(this.type.prototype, type.prototype);\n        }\n        register(item) {\n            const me = this;\n            const proto = Object.getPrototypeOf(item);\n            let parentScope;\n            if (isIChartComponent(proto)) {\n                parentScope = me.register(proto);\n            }\n            const items = me.items;\n            const id = item.id;\n            const scope = me.scope + '.' + id;\n            if (!id) {\n                throw new Error('class does not have id: ' + item);\n            }\n            if (id in items) {\n                return scope;\n            }\n            items[id] = item;\n            registerDefaults(item, scope, parentScope);\n            if (me.override) {\n                defaults.override(item.id, item.overrides);\n            }\n            return scope;\n        }\n        get(id) {\n            return this.items[id];\n        }\n        unregister(item) {\n            const items = this.items;\n            const id = item.id;\n            const scope = this.scope;\n            if (id in items) {\n                delete items[id];\n            }\n            if (scope && id in defaults[scope]) {\n                delete defaults[scope][id];\n                if (this.override) {\n                    delete overrides[id];\n                }\n            }\n        }\n    }\n    function registerDefaults(item, scope, parentScope) {\n        const itemDefaults = merge(Object.create(null), [\n            parentScope ? defaults.get(parentScope) : {},\n            defaults.get(scope),\n            item.defaults\n        ]);\n        defaults.set(scope, itemDefaults);\n        if (item.defaultRoutes) {\n            routeDefaults(scope, item.defaultRoutes);\n        }\n        if (item.descriptors) {\n            defaults.describe(scope, item.descriptors);\n        }\n    }\n    function routeDefaults(scope, routes) {\n        Object.keys(routes).forEach(property => {\n            const propertyParts = property.split('.');\n            const sourceName = propertyParts.pop();\n            const sourceScope = [scope].concat(propertyParts).join('.');\n            const parts = routes[property].split('.');\n            const targetName = parts.pop();\n            const targetScope = parts.join('.');\n            defaults.route(sourceScope, sourceName, targetScope, targetName);\n        });\n    }\n    function isIChartComponent(proto) {\n        return 'id' in proto && 'defaults' in proto;\n    }\n\n    class Registry {\n        constructor() {\n            this.controllers = new TypedRegistry(DatasetController, 'datasets', true);\n            this.elements = new TypedRegistry(Element, 'elements');\n            this.plugins = new TypedRegistry(Object, 'plugins');\n            this.scales = new TypedRegistry(Scale, 'scales');\n            this._typedRegistries = [this.controllers, this.scales, this.elements];\n        }\n        add(...args) {\n            this._each('register', args);\n        }\n        remove(...args) {\n            this._each('unregister', args);\n        }\n        addControllers(...args) {\n            this._each('register', args, this.controllers);\n        }\n        addElements(...args) {\n            this._each('register', args, this.elements);\n        }\n        addPlugins(...args) {\n            this._each('register', args, this.plugins);\n        }\n        addScales(...args) {\n            this._each('register', args, this.scales);\n        }\n        getController(id) {\n            return this._get(id, this.controllers, 'controller');\n        }\n        getElement(id) {\n            return this._get(id, this.elements, 'element');\n        }\n        getPlugin(id) {\n            return this._get(id, this.plugins, 'plugin');\n        }\n        getScale(id) {\n            return this._get(id, this.scales, 'scale');\n        }\n        removeControllers(...args) {\n            this._each('unregister', args, this.controllers);\n        }\n        removeElements(...args) {\n            this._each('unregister', args, this.elements);\n        }\n        removePlugins(...args) {\n            this._each('unregister', args, this.plugins);\n        }\n        removeScales(...args) {\n            this._each('unregister', args, this.scales);\n        }\n        _each(method, args, typedRegistry) {\n            const me = this;\n            [...args].forEach(arg => {\n                const reg = typedRegistry || me._getRegistryForType(arg);\n                if (typedRegistry || reg.isForType(arg) || (reg === me.plugins && arg.id)) {\n                    me._exec(method, reg, arg);\n                } else {\n                    each(arg, item => {\n                        const itemReg = typedRegistry || me._getRegistryForType(item);\n                        me._exec(method, itemReg, item);\n                    });\n                }\n            });\n        }\n        _exec(method, registry, component) {\n            const camelMethod = _capitalize(method);\n            callback(component['before' + camelMethod], [], component);\n            registry[method](component);\n            callback(component['after' + camelMethod], [], component);\n        }\n        _getRegistryForType(type) {\n            for (let i = 0; i < this._typedRegistries.length; i++) {\n                const reg = this._typedRegistries[i];\n                if (reg.isForType(type)) {\n                    return reg;\n                }\n            }\n            return this.plugins;\n        }\n        _get(id, typedRegistry, type) {\n            const item = typedRegistry.get(id);\n            if (item === undefined) {\n                throw new Error('\"' + id + '\" is not a registered ' + type + '.');\n            }\n            return item;\n        }\n    }\n    var registry = new Registry();\n\n    class PluginService {\n        constructor() {\n            this._init = [];\n        }\n        notify(chart, hook, args, filter) {\n            const me = this;\n            if (hook === 'beforeInit') {\n                me._init = me._createDescriptors(chart, true);\n                me._notify(me._init, chart, 'install');\n            }\n            const descriptors = filter ? me._descriptors(chart).filter(filter) : me._descriptors(chart);\n            const result = me._notify(descriptors, chart, hook, args);\n            if (hook === 'destroy') {\n                me._notify(descriptors, chart, 'stop');\n                me._notify(me._init, chart, 'uninstall');\n            }\n            return result;\n        }\n        _notify(descriptors, chart, hook, args) {\n            args = args || {};\n            for (const descriptor of descriptors) {\n                const plugin = descriptor.plugin;\n                const method = plugin[hook];\n                const params = [chart, args, descriptor.options];\n                if (callback(method, params, plugin) === false && args.cancelable) {\n                    return false;\n                }\n            }\n            return true;\n        }\n        invalidate() {\n            if (!isNullOrUndef(this._cache)) {\n                this._oldCache = this._cache;\n                this._cache = undefined;\n            }\n        }\n        _descriptors(chart) {\n            if (this._cache) {\n                return this._cache;\n            }\n            const descriptors = this._cache = this._createDescriptors(chart);\n            this._notifyStateChanges(chart);\n            return descriptors;\n        }\n        _createDescriptors(chart, all) {\n            const config = chart && chart.config;\n            const options = valueOrDefault(config.options && config.options.plugins, {});\n            const plugins = allPlugins(config);\n            return options === false && !all ? [] : createDescriptors(chart, plugins, options, all);\n        }\n        _notifyStateChanges(chart) {\n            const previousDescriptors = this._oldCache || [];\n            const descriptors = this._cache;\n            const diff = (a, b) => a.filter(x => !b.some(y => x.plugin.id === y.plugin.id));\n            this._notify(diff(previousDescriptors, descriptors), chart, 'stop');\n            this._notify(diff(descriptors, previousDescriptors), chart, 'start');\n        }\n    }\n    function allPlugins(config) {\n        const plugins = [];\n        const keys = Object.keys(registry.plugins.items);\n        for (let i = 0; i < keys.length; i++) {\n            plugins.push(registry.getPlugin(keys[i]));\n        }\n        const local = config.plugins || [];\n        for (let i = 0; i < local.length; i++) {\n            const plugin = local[i];\n            if (plugins.indexOf(plugin) === -1) {\n                plugins.push(plugin);\n            }\n        }\n        return plugins;\n    }\n    function getOpts(options, all) {\n        if (!all && options === false) {\n            return null;\n        }\n        if (options === true) {\n            return {};\n        }\n        return options;\n    }\n    function createDescriptors(chart, plugins, options, all) {\n        const result = [];\n        const context = chart.getContext();\n        for (let i = 0; i < plugins.length; i++) {\n            const plugin = plugins[i];\n            const id = plugin.id;\n            const opts = getOpts(options[id], all);\n            if (opts === null) {\n                continue;\n            }\n            result.push({\n                plugin,\n                options: pluginOpts(chart.config, plugin, opts, context)\n            });\n        }\n        return result;\n    }\n    function pluginOpts(config, plugin, opts, context) {\n        const keys = config.pluginScopeKeys(plugin);\n        const scopes = config.getOptionScopes(opts, keys);\n        return config.createResolver(scopes, context, [''], {scriptable: false, indexable: false, allKeys: true});\n    }\n\n    function getIndexAxis(type, options) {\n        const datasetDefaults = defaults.datasets[type] || {};\n        const datasetOptions = (options.datasets || {})[type] || {};\n        return datasetOptions.indexAxis || options.indexAxis || datasetDefaults.indexAxis || 'x';\n    }\n    function getAxisFromDefaultScaleID(id, indexAxis) {\n        let axis = id;\n        if (id === '_index_') {\n            axis = indexAxis;\n        } else if (id === '_value_') {\n            axis = indexAxis === 'x' ? 'y' : 'x';\n        }\n        return axis;\n    }\n    function getDefaultScaleIDFromAxis(axis, indexAxis) {\n        return axis === indexAxis ? '_index_' : '_value_';\n    }\n    function axisFromPosition(position) {\n        if (position === 'top' || position === 'bottom') {\n            return 'x';\n        }\n        if (position === 'left' || position === 'right') {\n            return 'y';\n        }\n    }\n    function determineAxis(id, scaleOptions) {\n        if (id === 'x' || id === 'y') {\n            return id;\n        }\n        return scaleOptions.axis || axisFromPosition(scaleOptions.position) || id.charAt(0).toLowerCase();\n    }\n    function mergeScaleConfig(config, options) {\n        const chartDefaults = overrides[config.type] || {scales: {}};\n        const configScales = options.scales || {};\n        const chartIndexAxis = getIndexAxis(config.type, options);\n        const firstIDs = Object.create(null);\n        const scales = Object.create(null);\n        Object.keys(configScales).forEach(id => {\n            const scaleConf = configScales[id];\n            const axis = determineAxis(id, scaleConf);\n            const defaultId = getDefaultScaleIDFromAxis(axis, chartIndexAxis);\n            const defaultScaleOptions = chartDefaults.scales || {};\n            firstIDs[axis] = firstIDs[axis] || id;\n            scales[id] = mergeIf(Object.create(null), [{axis}, scaleConf, defaultScaleOptions[axis], defaultScaleOptions[defaultId]]);\n        });\n        config.data.datasets.forEach(dataset => {\n            const type = dataset.type || config.type;\n            const indexAxis = dataset.indexAxis || getIndexAxis(type, options);\n            const datasetDefaults = overrides[type] || {};\n            const defaultScaleOptions = datasetDefaults.scales || {};\n            Object.keys(defaultScaleOptions).forEach(defaultID => {\n                const axis = getAxisFromDefaultScaleID(defaultID, indexAxis);\n                const id = dataset[axis + 'AxisID'] || firstIDs[axis] || axis;\n                scales[id] = scales[id] || Object.create(null);\n                mergeIf(scales[id], [{axis}, configScales[id], defaultScaleOptions[defaultID]]);\n            });\n        });\n        Object.keys(scales).forEach(key => {\n            const scale = scales[key];\n            mergeIf(scale, [defaults.scales[scale.type], defaults.scale]);\n        });\n        return scales;\n    }\n    function initOptions(config) {\n        const options = config.options || (config.options = {});\n        options.plugins = valueOrDefault(options.plugins, {});\n        options.scales = mergeScaleConfig(config, options);\n    }\n    function initData(data) {\n        data = data || {};\n        data.datasets = data.datasets || [];\n        data.labels = data.labels || [];\n        return data;\n    }\n    function initConfig(config) {\n        config = config || {};\n        config.data = initData(config.data);\n        initOptions(config);\n        return config;\n    }\n    const keyCache = new Map();\n    const keysCached = new Set();\n    function cachedKeys(cacheKey, generate) {\n        let keys = keyCache.get(cacheKey);\n        if (!keys) {\n            keys = generate();\n            keyCache.set(cacheKey, keys);\n            keysCached.add(keys);\n        }\n        return keys;\n    }\n    const addIfFound = (set, obj, key) => {\n        const opts = resolveObjectKey(obj, key);\n        if (opts !== undefined) {\n            set.add(opts);\n        }\n    };\n    class Config {\n        constructor(config) {\n            this._config = initConfig(config);\n            this._scopeCache = new Map();\n            this._resolverCache = new Map();\n        }\n        get type() {\n            return this._config.type;\n        }\n        set type(type) {\n            this._config.type = type;\n        }\n        get data() {\n            return this._config.data;\n        }\n        set data(data) {\n            this._config.data = initData(data);\n        }\n        get options() {\n            return this._config.options;\n        }\n        set options(options) {\n            this._config.options = options;\n        }\n        get plugins() {\n            return this._config.plugins;\n        }\n        update() {\n            const config = this._config;\n            this.clearCache();\n            initOptions(config);\n        }\n        clearCache() {\n            this._scopeCache.clear();\n            this._resolverCache.clear();\n        }\n        datasetScopeKeys(datasetType) {\n            return cachedKeys(datasetType,\n                () => [[\n                    `datasets.${datasetType}`,\n                    ''\n                ]]);\n        }\n        datasetAnimationScopeKeys(datasetType, transition) {\n            return cachedKeys(`${datasetType}.transition.${transition}`,\n                () => [\n                    [\n                        `datasets.${datasetType}.transitions.${transition}`,\n                        `transitions.${transition}`,\n                    ],\n                    [\n                        `datasets.${datasetType}`,\n                        ''\n                    ]\n                ]);\n        }\n        datasetElementScopeKeys(datasetType, elementType) {\n            return cachedKeys(`${datasetType}-${elementType}`,\n                () => [[\n                    `datasets.${datasetType}.elements.${elementType}`,\n                    `datasets.${datasetType}`,\n                    `elements.${elementType}`,\n                    ''\n                ]]);\n        }\n        pluginScopeKeys(plugin) {\n            const id = plugin.id;\n            const type = this.type;\n            return cachedKeys(`${type}-plugin-${id}`,\n                () => [[\n                    `plugins.${id}`,\n                    ...plugin.additionalOptionScopes || [],\n                ]]);\n        }\n        _cachedScopes(mainScope, resetCache) {\n            const _scopeCache = this._scopeCache;\n            let cache = _scopeCache.get(mainScope);\n            if (!cache || resetCache) {\n                cache = new Map();\n                _scopeCache.set(mainScope, cache);\n            }\n            return cache;\n        }\n        getOptionScopes(mainScope, keyLists, resetCache) {\n            const {options, type} = this;\n            const cache = this._cachedScopes(mainScope, resetCache);\n            const cached = cache.get(keyLists);\n            if (cached) {\n                return cached;\n            }\n            const scopes = new Set();\n            keyLists.forEach(keys => {\n                if (mainScope) {\n                    scopes.add(mainScope);\n                    keys.forEach(key => addIfFound(scopes, mainScope, key));\n                }\n                keys.forEach(key => addIfFound(scopes, options, key));\n                keys.forEach(key => addIfFound(scopes, overrides[type] || {}, key));\n                keys.forEach(key => addIfFound(scopes, defaults, key));\n                keys.forEach(key => addIfFound(scopes, descriptors, key));\n            });\n            const array = [...scopes];\n            if (keysCached.has(keyLists)) {\n                cache.set(keyLists, array);\n            }\n            return array;\n        }\n        chartOptionScopes() {\n            const {options, type} = this;\n            return [\n                options,\n                overrides[type] || {},\n                defaults.datasets[type] || {},\n                {type},\n                defaults,\n                descriptors\n            ];\n        }\n        resolveNamedOptions(scopes, names, context, prefixes = ['']) {\n            const result = {$shared: true};\n            const {resolver, subPrefixes} = getResolver(this._resolverCache, scopes, prefixes);\n            let options = resolver;\n            if (needContext(resolver, names)) {\n                result.$shared = false;\n                context = isFunction(context) ? context() : context;\n                const subResolver = this.createResolver(scopes, context, subPrefixes);\n                options = _attachContext(resolver, context, subResolver);\n            }\n            for (const prop of names) {\n                result[prop] = options[prop];\n            }\n            return result;\n        }\n        createResolver(scopes, context, prefixes = [''], descriptorDefaults) {\n            const {resolver} = getResolver(this._resolverCache, scopes, prefixes);\n            return isObject(context)\n                ? _attachContext(resolver, context, undefined, descriptorDefaults)\n                : resolver;\n        }\n    }\n    function getResolver(resolverCache, scopes, prefixes) {\n        let cache = resolverCache.get(scopes);\n        if (!cache) {\n            cache = new Map();\n            resolverCache.set(scopes, cache);\n        }\n        const cacheKey = prefixes.join();\n        let cached = cache.get(cacheKey);\n        if (!cached) {\n            const resolver = _createResolver(scopes, prefixes);\n            cached = {\n                resolver,\n                subPrefixes: prefixes.filter(p => !p.toLowerCase().includes('hover'))\n            };\n            cache.set(cacheKey, cached);\n        }\n        return cached;\n    }\n    function needContext(proxy, names) {\n        const {isScriptable, isIndexable} = _descriptors(proxy);\n        for (const prop of names) {\n            if ((isScriptable(prop) && isFunction(proxy[prop]))\n                || (isIndexable(prop) && isArray(proxy[prop]))) {\n                return true;\n            }\n        }\n        return false;\n    }\n\n    var version = \"3.3.2\";\n\n    const KNOWN_POSITIONS = ['top', 'bottom', 'left', 'right', 'chartArea'];\n    function positionIsHorizontal(position, axis) {\n        return position === 'top' || position === 'bottom' || (KNOWN_POSITIONS.indexOf(position) === -1 && axis === 'x');\n    }\n    function compare2Level(l1, l2) {\n        return function(a, b) {\n            return a[l1] === b[l1]\n                ? a[l2] - b[l2]\n                : a[l1] - b[l1];\n        };\n    }\n    function onAnimationsComplete(context) {\n        const chart = context.chart;\n        const animationOptions = chart.options.animation;\n        chart.notifyPlugins('afterRender');\n        callback(animationOptions && animationOptions.onComplete, [context], chart);\n    }\n    function onAnimationProgress(context) {\n        const chart = context.chart;\n        const animationOptions = chart.options.animation;\n        callback(animationOptions && animationOptions.onProgress, [context], chart);\n    }\n    function isDomSupported() {\n        return typeof window !== 'undefined' && typeof document !== 'undefined';\n    }\n    function getCanvas(item) {\n        if (isDomSupported() && typeof item === 'string') {\n            item = document.getElementById(item);\n        } else if (item && item.length) {\n            item = item[0];\n        }\n        if (item && item.canvas) {\n            item = item.canvas;\n        }\n        return item;\n    }\n    const instances = {};\n    const getChart = (key) => {\n        const canvas = getCanvas(key);\n        return Object.values(instances).filter((c) => c.canvas === canvas).pop();\n    };\n    class Chart {\n        constructor(item, config) {\n            const me = this;\n            this.config = config = new Config(config);\n            const initialCanvas = getCanvas(item);\n            const existingChart = getChart(initialCanvas);\n            if (existingChart) {\n                throw new Error(\n                    'Canvas is already in use. Chart with ID \\'' + existingChart.id + '\\'' +\n                    ' must be destroyed before the canvas can be reused.'\n                );\n            }\n            const options = config.createResolver(config.chartOptionScopes(), me.getContext());\n            this.platform = me._initializePlatform(initialCanvas, config);\n            const context = me.platform.acquireContext(initialCanvas, options.aspectRatio);\n            const canvas = context && context.canvas;\n            const height = canvas && canvas.height;\n            const width = canvas && canvas.width;\n            this.id = uid();\n            this.ctx = context;\n            this.canvas = canvas;\n            this.width = width;\n            this.height = height;\n            this._options = options;\n            this._aspectRatio = this.aspectRatio;\n            this._layers = [];\n            this._metasets = [];\n            this._stacks = undefined;\n            this.boxes = [];\n            this.currentDevicePixelRatio = undefined;\n            this.chartArea = undefined;\n            this._active = [];\n            this._lastEvent = undefined;\n            this._listeners = {};\n            this._responsiveListeners = undefined;\n            this._sortedMetasets = [];\n            this.scales = {};\n            this.scale = undefined;\n            this._plugins = new PluginService();\n            this.$proxies = {};\n            this._hiddenIndices = {};\n            this.attached = false;\n            this._animationsDisabled = undefined;\n            this.$context = undefined;\n            this._doResize = debounce(() => this.update('resize'), options.resizeDelay || 0);\n            instances[me.id] = me;\n            if (!context || !canvas) {\n                console.error(\"Failed to create chart: can't acquire context from the given item\");\n                return;\n            }\n            animator.listen(me, 'complete', onAnimationsComplete);\n            animator.listen(me, 'progress', onAnimationProgress);\n            me._initialize();\n            if (me.attached) {\n                me.update();\n            }\n        }\n        get aspectRatio() {\n            const {options: {aspectRatio, maintainAspectRatio}, width, height, _aspectRatio} = this;\n            if (!isNullOrUndef(aspectRatio)) {\n                return aspectRatio;\n            }\n            if (maintainAspectRatio && _aspectRatio) {\n                return _aspectRatio;\n            }\n            return height ? width / height : null;\n        }\n        get data() {\n            return this.config.data;\n        }\n        set data(data) {\n            this.config.data = data;\n        }\n        get options() {\n            return this._options;\n        }\n        set options(options) {\n            this.config.options = options;\n        }\n        _initialize() {\n            const me = this;\n            me.notifyPlugins('beforeInit');\n            if (me.options.responsive) {\n                me.resize();\n            } else {\n                retinaScale(me, me.options.devicePixelRatio);\n            }\n            me.bindEvents();\n            me.notifyPlugins('afterInit');\n            return me;\n        }\n        _initializePlatform(canvas, config) {\n            if (config.platform) {\n                return new config.platform();\n            } else if (!isDomSupported() || (typeof OffscreenCanvas !== 'undefined' && canvas instanceof OffscreenCanvas)) {\n                return new BasicPlatform();\n            }\n            return new DomPlatform();\n        }\n        clear() {\n            clearCanvas(this.canvas, this.ctx);\n            return this;\n        }\n        stop() {\n            animator.stop(this);\n            return this;\n        }\n        resize(width, height) {\n            if (!animator.running(this)) {\n                this._resize(width, height);\n            } else {\n                this._resizeBeforeDraw = {width, height};\n            }\n        }\n        _resize(width, height) {\n            const me = this;\n            const options = me.options;\n            const canvas = me.canvas;\n            const aspectRatio = options.maintainAspectRatio && me.aspectRatio;\n            const newSize = me.platform.getMaximumSize(canvas, width, height, aspectRatio);\n            const newRatio = options.devicePixelRatio || me.platform.getDevicePixelRatio();\n            me.width = newSize.width;\n            me.height = newSize.height;\n            me._aspectRatio = me.aspectRatio;\n            if (!retinaScale(me, newRatio, true)) {\n                return;\n            }\n            me.notifyPlugins('resize', {size: newSize});\n            callback(options.onResize, [me, newSize], me);\n            if (me.attached) {\n                if (me._doResize()) {\n                    me.render();\n                }\n            }\n        }\n        ensureScalesHaveIDs() {\n            const options = this.options;\n            const scalesOptions = options.scales || {};\n            each(scalesOptions, (axisOptions, axisID) => {\n                axisOptions.id = axisID;\n            });\n        }\n        buildOrUpdateScales() {\n            const me = this;\n            const options = me.options;\n            const scaleOpts = options.scales;\n            const scales = me.scales;\n            const updated = Object.keys(scales).reduce((obj, id) => {\n                obj[id] = false;\n                return obj;\n            }, {});\n            let items = [];\n            if (scaleOpts) {\n                items = items.concat(\n                    Object.keys(scaleOpts).map((id) => {\n                        const scaleOptions = scaleOpts[id];\n                        const axis = determineAxis(id, scaleOptions);\n                        const isRadial = axis === 'r';\n                        const isHorizontal = axis === 'x';\n                        return {\n                            options: scaleOptions,\n                            dposition: isRadial ? 'chartArea' : isHorizontal ? 'bottom' : 'left',\n                            dtype: isRadial ? 'radialLinear' : isHorizontal ? 'category' : 'linear'\n                        };\n                    })\n                );\n            }\n            each(items, (item) => {\n                const scaleOptions = item.options;\n                const id = scaleOptions.id;\n                const axis = determineAxis(id, scaleOptions);\n                const scaleType = valueOrDefault(scaleOptions.type, item.dtype);\n                if (scaleOptions.position === undefined || positionIsHorizontal(scaleOptions.position, axis) !== positionIsHorizontal(item.dposition)) {\n                    scaleOptions.position = item.dposition;\n                }\n                updated[id] = true;\n                let scale = null;\n                if (id in scales && scales[id].type === scaleType) {\n                    scale = scales[id];\n                } else {\n                    const scaleClass = registry.getScale(scaleType);\n                    scale = new scaleClass({\n                        id,\n                        type: scaleType,\n                        ctx: me.ctx,\n                        chart: me\n                    });\n                    scales[scale.id] = scale;\n                }\n                scale.init(scaleOptions, options);\n            });\n            each(updated, (hasUpdated, id) => {\n                if (!hasUpdated) {\n                    delete scales[id];\n                }\n            });\n            each(scales, (scale) => {\n                layouts.configure(me, scale, scale.options);\n                layouts.addBox(me, scale);\n            });\n        }\n        _updateMetasets() {\n            const me = this;\n            const metasets = me._metasets;\n            const numData = me.data.datasets.length;\n            const numMeta = metasets.length;\n            metasets.sort((a, b) => a.index - b.index);\n            if (numMeta > numData) {\n                for (let i = numData; i < numMeta; ++i) {\n                    me._destroyDatasetMeta(i);\n                }\n                metasets.splice(numData, numMeta - numData);\n            }\n            me._sortedMetasets = metasets.slice(0).sort(compare2Level('order', 'index'));\n        }\n        _removeUnreferencedMetasets() {\n            const me = this;\n            const {_metasets: metasets, data: {datasets}} = me;\n            if (metasets.length > datasets.length) {\n                delete me._stacks;\n            }\n            metasets.forEach((meta, index) => {\n                if (datasets.filter(x => x === meta._dataset).length === 0) {\n                    me._destroyDatasetMeta(index);\n                }\n            });\n        }\n        buildOrUpdateControllers() {\n            const me = this;\n            const newControllers = [];\n            const datasets = me.data.datasets;\n            let i, ilen;\n            me._removeUnreferencedMetasets();\n            for (i = 0, ilen = datasets.length; i < ilen; i++) {\n                const dataset = datasets[i];\n                let meta = me.getDatasetMeta(i);\n                const type = dataset.type || me.config.type;\n                if (meta.type && meta.type !== type) {\n                    me._destroyDatasetMeta(i);\n                    meta = me.getDatasetMeta(i);\n                }\n                meta.type = type;\n                meta.indexAxis = dataset.indexAxis || getIndexAxis(type, me.options);\n                meta.order = dataset.order || 0;\n                meta.index = i;\n                meta.label = '' + dataset.label;\n                meta.visible = me.isDatasetVisible(i);\n                if (meta.controller) {\n                    meta.controller.updateIndex(i);\n                    meta.controller.linkScales();\n                } else {\n                    const ControllerClass = registry.getController(type);\n                    const {datasetElementType, dataElementType} = defaults.datasets[type];\n                    Object.assign(ControllerClass.prototype, {\n                        dataElementType: registry.getElement(dataElementType),\n                        datasetElementType: datasetElementType && registry.getElement(datasetElementType)\n                    });\n                    meta.controller = new ControllerClass(me, i);\n                    newControllers.push(meta.controller);\n                }\n            }\n            me._updateMetasets();\n            return newControllers;\n        }\n        _resetElements() {\n            const me = this;\n            each(me.data.datasets, (dataset, datasetIndex) => {\n                me.getDatasetMeta(datasetIndex).controller.reset();\n            }, me);\n        }\n        reset() {\n            this._resetElements();\n            this.notifyPlugins('reset');\n        }\n        update(mode) {\n            const me = this;\n            const config = me.config;\n            config.update();\n            me._options = config.createResolver(config.chartOptionScopes(), me.getContext());\n            each(me.scales, (scale) => {\n                layouts.removeBox(me, scale);\n            });\n            const animsDisabled = me._animationsDisabled = !me.options.animation;\n            me.ensureScalesHaveIDs();\n            me.buildOrUpdateScales();\n            const existingEvents = new Set(Object.keys(me._listeners));\n            const newEvents = new Set(me.options.events);\n            if (!setsEqual(existingEvents, newEvents) || !!this._responsiveListeners !== me.options.responsive) {\n                me.unbindEvents();\n                me.bindEvents();\n            }\n            me._plugins.invalidate();\n            if (me.notifyPlugins('beforeUpdate', {mode, cancelable: true}) === false) {\n                return;\n            }\n            const newControllers = me.buildOrUpdateControllers();\n            me.notifyPlugins('beforeElementsUpdate');\n            let minPadding = 0;\n            for (let i = 0, ilen = me.data.datasets.length; i < ilen; i++) {\n                const {controller} = me.getDatasetMeta(i);\n                const reset = !animsDisabled && newControllers.indexOf(controller) === -1;\n                controller.buildOrUpdateElements(reset);\n                minPadding = Math.max(+controller.getMaxOverflow(), minPadding);\n            }\n            me._minPadding = minPadding;\n            me._updateLayout(minPadding);\n            if (!animsDisabled) {\n                each(newControllers, (controller) => {\n                    controller.reset();\n                });\n            }\n            me._updateDatasets(mode);\n            me.notifyPlugins('afterUpdate', {mode});\n            me._layers.sort(compare2Level('z', '_idx'));\n            if (me._lastEvent) {\n                me._eventHandler(me._lastEvent, true);\n            }\n            me.render();\n        }\n        _updateLayout(minPadding) {\n            const me = this;\n            if (me.notifyPlugins('beforeLayout', {cancelable: true}) === false) {\n                return;\n            }\n            layouts.update(me, me.width, me.height, minPadding);\n            const area = me.chartArea;\n            const noArea = area.width <= 0 || area.height <= 0;\n            me._layers = [];\n            each(me.boxes, (box) => {\n                if (noArea && box.position === 'chartArea') {\n                    return;\n                }\n                if (box.configure) {\n                    box.configure();\n                }\n                me._layers.push(...box._layers());\n            }, me);\n            me._layers.forEach((item, index) => {\n                item._idx = index;\n            });\n            me.notifyPlugins('afterLayout');\n        }\n        _updateDatasets(mode) {\n            const me = this;\n            const isFunction = typeof mode === 'function';\n            if (me.notifyPlugins('beforeDatasetsUpdate', {mode, cancelable: true}) === false) {\n                return;\n            }\n            for (let i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {\n                me._updateDataset(i, isFunction ? mode({datasetIndex: i}) : mode);\n            }\n            me.notifyPlugins('afterDatasetsUpdate', {mode});\n        }\n        _updateDataset(index, mode) {\n            const me = this;\n            const meta = me.getDatasetMeta(index);\n            const args = {meta, index, mode, cancelable: true};\n            if (me.notifyPlugins('beforeDatasetUpdate', args) === false) {\n                return;\n            }\n            meta.controller._update(mode);\n            args.cancelable = false;\n            me.notifyPlugins('afterDatasetUpdate', args);\n        }\n        render() {\n            const me = this;\n            if (me.notifyPlugins('beforeRender', {cancelable: true}) === false) {\n                return;\n            }\n            if (animator.has(me)) {\n                if (me.attached && !animator.running(me)) {\n                    animator.start(me);\n                }\n            } else {\n                me.draw();\n                onAnimationsComplete({chart: me});\n            }\n        }\n        draw() {\n            const me = this;\n            let i;\n            if (me._resizeBeforeDraw) {\n                const {width, height} = me._resizeBeforeDraw;\n                me._resize(width, height);\n                me._resizeBeforeDraw = null;\n            }\n            me.clear();\n            if (me.width <= 0 || me.height <= 0) {\n                return;\n            }\n            if (me.notifyPlugins('beforeDraw', {cancelable: true}) === false) {\n                return;\n            }\n            const layers = me._layers;\n            for (i = 0; i < layers.length && layers[i].z <= 0; ++i) {\n                layers[i].draw(me.chartArea);\n            }\n            me._drawDatasets();\n            for (; i < layers.length; ++i) {\n                layers[i].draw(me.chartArea);\n            }\n            me.notifyPlugins('afterDraw');\n        }\n        _getSortedDatasetMetas(filterVisible) {\n            const me = this;\n            const metasets = me._sortedMetasets;\n            const result = [];\n            let i, ilen;\n            for (i = 0, ilen = metasets.length; i < ilen; ++i) {\n                const meta = metasets[i];\n                if (!filterVisible || meta.visible) {\n                    result.push(meta);\n                }\n            }\n            return result;\n        }\n        getSortedVisibleDatasetMetas() {\n            return this._getSortedDatasetMetas(true);\n        }\n        _drawDatasets() {\n            const me = this;\n            if (me.notifyPlugins('beforeDatasetsDraw', {cancelable: true}) === false) {\n                return;\n            }\n            const metasets = me.getSortedVisibleDatasetMetas();\n            for (let i = metasets.length - 1; i >= 0; --i) {\n                me._drawDataset(metasets[i]);\n            }\n            me.notifyPlugins('afterDatasetsDraw');\n        }\n        _drawDataset(meta) {\n            const me = this;\n            const ctx = me.ctx;\n            const clip = meta._clip;\n            const area = me.chartArea;\n            const args = {\n                meta,\n                index: meta.index,\n                cancelable: true\n            };\n            if (me.notifyPlugins('beforeDatasetDraw', args) === false) {\n                return;\n            }\n            clipArea(ctx, {\n                left: clip.left === false ? 0 : area.left - clip.left,\n                right: clip.right === false ? me.width : area.right + clip.right,\n                top: clip.top === false ? 0 : area.top - clip.top,\n                bottom: clip.bottom === false ? me.height : area.bottom + clip.bottom\n            });\n            meta.controller.draw();\n            unclipArea(ctx);\n            args.cancelable = false;\n            me.notifyPlugins('afterDatasetDraw', args);\n        }\n        getElementsAtEventForMode(e, mode, options, useFinalPosition) {\n            const method = Interaction.modes[mode];\n            if (typeof method === 'function') {\n                return method(this, e, options, useFinalPosition);\n            }\n            return [];\n        }\n        getDatasetMeta(datasetIndex) {\n            const me = this;\n            const dataset = me.data.datasets[datasetIndex];\n            const metasets = me._metasets;\n            let meta = metasets.filter(x => x && x._dataset === dataset).pop();\n            if (!meta) {\n                meta = {\n                    type: null,\n                    data: [],\n                    dataset: null,\n                    controller: null,\n                    hidden: null,\n                    xAxisID: null,\n                    yAxisID: null,\n                    order: dataset && dataset.order || 0,\n                    index: datasetIndex,\n                    _dataset: dataset,\n                    _parsed: [],\n                    _sorted: false\n                };\n                metasets.push(meta);\n            }\n            return meta;\n        }\n        getContext() {\n            return this.$context || (this.$context = {chart: this, type: 'chart'});\n        }\n        getVisibleDatasetCount() {\n            return this.getSortedVisibleDatasetMetas().length;\n        }\n        isDatasetVisible(datasetIndex) {\n            const dataset = this.data.datasets[datasetIndex];\n            if (!dataset) {\n                return false;\n            }\n            const meta = this.getDatasetMeta(datasetIndex);\n            return typeof meta.hidden === 'boolean' ? !meta.hidden : !dataset.hidden;\n        }\n        setDatasetVisibility(datasetIndex, visible) {\n            const meta = this.getDatasetMeta(datasetIndex);\n            meta.hidden = !visible;\n        }\n        toggleDataVisibility(index) {\n            this._hiddenIndices[index] = !this._hiddenIndices[index];\n        }\n        getDataVisibility(index) {\n            return !this._hiddenIndices[index];\n        }\n        _updateDatasetVisibility(datasetIndex, visible) {\n            const me = this;\n            const mode = visible ? 'show' : 'hide';\n            const meta = me.getDatasetMeta(datasetIndex);\n            const anims = meta.controller._resolveAnimations(undefined, mode);\n            me.setDatasetVisibility(datasetIndex, visible);\n            anims.update(meta, {visible});\n            me.update((ctx) => ctx.datasetIndex === datasetIndex ? mode : undefined);\n        }\n        hide(datasetIndex) {\n            this._updateDatasetVisibility(datasetIndex, false);\n        }\n        show(datasetIndex) {\n            this._updateDatasetVisibility(datasetIndex, true);\n        }\n        _destroyDatasetMeta(datasetIndex) {\n            const me = this;\n            const meta = me._metasets && me._metasets[datasetIndex];\n            if (meta && meta.controller) {\n                meta.controller._destroy();\n                delete me._metasets[datasetIndex];\n            }\n        }\n        destroy() {\n            const me = this;\n            const {canvas, ctx} = me;\n            let i, ilen;\n            me.stop();\n            animator.remove(me);\n            for (i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {\n                me._destroyDatasetMeta(i);\n            }\n            me.config.clearCache();\n            if (canvas) {\n                me.unbindEvents();\n                clearCanvas(canvas, ctx);\n                me.platform.releaseContext(ctx);\n                me.canvas = null;\n                me.ctx = null;\n            }\n            me.notifyPlugins('destroy');\n            delete instances[me.id];\n        }\n        toBase64Image(...args) {\n            return this.canvas.toDataURL(...args);\n        }\n        bindEvents() {\n            this.bindUserEvents();\n            if (this.options.responsive) {\n                this.bindResponsiveEvents();\n            } else {\n                this.attached = true;\n            }\n        }\n        bindUserEvents() {\n            const me = this;\n            const listeners = me._listeners;\n            const platform = me.platform;\n            const _add = (type, listener) => {\n                platform.addEventListener(me, type, listener);\n                listeners[type] = listener;\n            };\n            const listener = function(e, x, y) {\n                e.offsetX = x;\n                e.offsetY = y;\n                me._eventHandler(e);\n            };\n            each(me.options.events, (type) => _add(type, listener));\n        }\n        bindResponsiveEvents() {\n            const me = this;\n            if (!me._responsiveListeners) {\n                me._responsiveListeners = {};\n            }\n            const listeners = me._responsiveListeners;\n            const platform = me.platform;\n            const _add = (type, listener) => {\n                platform.addEventListener(me, type, listener);\n                listeners[type] = listener;\n            };\n            const _remove = (type, listener) => {\n                if (listeners[type]) {\n                    platform.removeEventListener(me, type, listener);\n                    delete listeners[type];\n                }\n            };\n            const listener = (width, height) => {\n                if (me.canvas) {\n                    me.resize(width, height);\n                }\n            };\n            let detached;\n            const attached = () => {\n                _remove('attach', attached);\n                me.attached = true;\n                me.resize();\n                _add('resize', listener);\n                _add('detach', detached);\n            };\n            detached = () => {\n                me.attached = false;\n                _remove('resize', listener);\n                _add('attach', attached);\n            };\n            if (platform.isAttached(me.canvas)) {\n                attached();\n            } else {\n                detached();\n            }\n        }\n        unbindEvents() {\n            const me = this;\n            each(me._listeners, (listener, type) => {\n                me.platform.removeEventListener(me, type, listener);\n            });\n            me._listeners = {};\n            each(me._responsiveListeners, (listener, type) => {\n                me.platform.removeEventListener(me, type, listener);\n            });\n            me._responsiveListeners = undefined;\n        }\n        updateHoverStyle(items, mode, enabled) {\n            const prefix = enabled ? 'set' : 'remove';\n            let meta, item, i, ilen;\n            if (mode === 'dataset') {\n                meta = this.getDatasetMeta(items[0].datasetIndex);\n                meta.controller['_' + prefix + 'DatasetHoverStyle']();\n            }\n            for (i = 0, ilen = items.length; i < ilen; ++i) {\n                item = items[i];\n                const controller = item && this.getDatasetMeta(item.datasetIndex).controller;\n                if (controller) {\n                    controller[prefix + 'HoverStyle'](item.element, item.datasetIndex, item.index);\n                }\n            }\n        }\n        getActiveElements() {\n            return this._active || [];\n        }\n        setActiveElements(activeElements) {\n            const me = this;\n            const lastActive = me._active || [];\n            const active = activeElements.map(({datasetIndex, index}) => {\n                const meta = me.getDatasetMeta(datasetIndex);\n                if (!meta) {\n                    throw new Error('No dataset found at index ' + datasetIndex);\n                }\n                return {\n                    datasetIndex,\n                    element: meta.data[index],\n                    index,\n                };\n            });\n            const changed = !_elementsEqual(active, lastActive);\n            if (changed) {\n                me._active = active;\n                me._updateHoverStyles(active, lastActive);\n            }\n        }\n        notifyPlugins(hook, args, filter) {\n            return this._plugins.notify(this, hook, args, filter);\n        }\n        _updateHoverStyles(active, lastActive, replay) {\n            const me = this;\n            const hoverOptions = me.options.hover;\n            const diff = (a, b) => a.filter(x => !b.some(y => x.datasetIndex === y.datasetIndex && x.index === y.index));\n            const deactivated = diff(lastActive, active);\n            const activated = replay ? active : diff(active, lastActive);\n            if (deactivated.length) {\n                me.updateHoverStyle(deactivated, hoverOptions.mode, false);\n            }\n            if (activated.length && hoverOptions.mode) {\n                me.updateHoverStyle(activated, hoverOptions.mode, true);\n            }\n        }\n        _eventHandler(e, replay) {\n            const me = this;\n            const args = {event: e, replay, cancelable: true};\n            const eventFilter = (plugin) => (plugin.options.events || this.options.events).includes(e.type);\n            if (me.notifyPlugins('beforeEvent', args, eventFilter) === false) {\n                return;\n            }\n            const changed = me._handleEvent(e, replay);\n            args.cancelable = false;\n            me.notifyPlugins('afterEvent', args, eventFilter);\n            if (changed || args.changed) {\n                me.render();\n            }\n            return me;\n        }\n        _handleEvent(e, replay) {\n            const me = this;\n            const {_active: lastActive = [], options} = me;\n            const hoverOptions = options.hover;\n            const useFinalPosition = replay;\n            let active = [];\n            let changed = false;\n            let lastEvent = null;\n            if (e.type !== 'mouseout') {\n                active = me.getElementsAtEventForMode(e, hoverOptions.mode, hoverOptions, useFinalPosition);\n                lastEvent = e.type === 'click' ? me._lastEvent : e;\n            }\n            me._lastEvent = null;\n            if (_isPointInArea(e, me.chartArea, me._minPadding)) {\n                callback(options.onHover, [e, active, me], me);\n                if (e.type === 'mouseup' || e.type === 'click' || e.type === 'contextmenu') {\n                    callback(options.onClick, [e, active, me], me);\n                }\n            }\n            changed = !_elementsEqual(active, lastActive);\n            if (changed || replay) {\n                me._active = active;\n                me._updateHoverStyles(active, lastActive, replay);\n            }\n            me._lastEvent = lastEvent;\n            return changed;\n        }\n    }\n    const invalidatePlugins = () => each(Chart.instances, (chart) => chart._plugins.invalidate());\n    const enumerable = true;\n    Object.defineProperties(Chart, {\n        defaults: {\n            enumerable,\n            value: defaults\n        },\n        instances: {\n            enumerable,\n            value: instances\n        },\n        overrides: {\n            enumerable,\n            value: overrides\n        },\n        registry: {\n            enumerable,\n            value: registry\n        },\n        version: {\n            enumerable,\n            value: version\n        },\n        getChart: {\n            enumerable,\n            value: getChart\n        },\n        register: {\n            enumerable,\n            value: (...items) => {\n                registry.add(...items);\n                invalidatePlugins();\n            }\n        },\n        unregister: {\n            enumerable,\n            value: (...items) => {\n                registry.remove(...items);\n                invalidatePlugins();\n            }\n        }\n    });\n\n    function abstract() {\n        throw new Error('This method is not implemented: Check that a complete date adapter is provided.');\n    }\n    class DateAdapter {\n        constructor(options) {\n            this.options = options || {};\n        }\n        formats() {\n            return abstract();\n        }\n        parse(value, format) {\n            return abstract();\n        }\n        format(timestamp, format) {\n            return abstract();\n        }\n        add(timestamp, amount, unit) {\n            return abstract();\n        }\n        diff(a, b, unit) {\n            return abstract();\n        }\n        startOf(timestamp, unit, weekday) {\n            return abstract();\n        }\n        endOf(timestamp, unit) {\n            return abstract();\n        }\n    }\n    DateAdapter.override = function(members) {\n        Object.assign(DateAdapter.prototype, members);\n    };\n    var _adapters = {\n        _date: DateAdapter\n    };\n\n    function getAllScaleValues(scale) {\n        if (!scale._cache.$bar) {\n            const metas = scale.getMatchingVisibleMetas('bar');\n            let values = [];\n            for (let i = 0, ilen = metas.length; i < ilen; i++) {\n                values = values.concat(metas[i].controller.getAllParsedValues(scale));\n            }\n            scale._cache.$bar = _arrayUnique(values.sort((a, b) => a - b));\n        }\n        return scale._cache.$bar;\n    }\n    function computeMinSampleSize(scale) {\n        const values = getAllScaleValues(scale);\n        let min = scale._length;\n        let i, ilen, curr, prev;\n        const updateMinAndPrev = () => {\n            if (curr === 32767 || curr === -32768) {\n                return;\n            }\n            if (defined(prev)) {\n                min = Math.min(min, Math.abs(curr - prev) || min);\n            }\n            prev = curr;\n        };\n        for (i = 0, ilen = values.length; i < ilen; ++i) {\n            curr = scale.getPixelForValue(values[i]);\n            updateMinAndPrev();\n        }\n        prev = undefined;\n        for (i = 0, ilen = scale.ticks.length; i < ilen; ++i) {\n            curr = scale.getPixelForTick(i);\n            updateMinAndPrev();\n        }\n        return min;\n    }\n    function computeFitCategoryTraits(index, ruler, options, stackCount) {\n        const thickness = options.barThickness;\n        let size, ratio;\n        if (isNullOrUndef(thickness)) {\n            size = ruler.min * options.categoryPercentage;\n            ratio = options.barPercentage;\n        } else {\n            size = thickness * stackCount;\n            ratio = 1;\n        }\n        return {\n            chunk: size / stackCount,\n            ratio,\n            start: ruler.pixels[index] - (size / 2)\n        };\n    }\n    function computeFlexCategoryTraits(index, ruler, options, stackCount) {\n        const pixels = ruler.pixels;\n        const curr = pixels[index];\n        let prev = index > 0 ? pixels[index - 1] : null;\n        let next = index < pixels.length - 1 ? pixels[index + 1] : null;\n        const percent = options.categoryPercentage;\n        if (prev === null) {\n            prev = curr - (next === null ? ruler.end - ruler.start : next - curr);\n        }\n        if (next === null) {\n            next = curr + curr - prev;\n        }\n        const start = curr - (curr - Math.min(prev, next)) / 2 * percent;\n        const size = Math.abs(next - prev) / 2 * percent;\n        return {\n            chunk: size / stackCount,\n            ratio: options.barPercentage,\n            start\n        };\n    }\n    function parseFloatBar(entry, item, vScale, i) {\n        const startValue = vScale.parse(entry[0], i);\n        const endValue = vScale.parse(entry[1], i);\n        const min = Math.min(startValue, endValue);\n        const max = Math.max(startValue, endValue);\n        let barStart = min;\n        let barEnd = max;\n        if (Math.abs(min) > Math.abs(max)) {\n            barStart = max;\n            barEnd = min;\n        }\n        item[vScale.axis] = barEnd;\n        item._custom = {\n            barStart,\n            barEnd,\n            start: startValue,\n            end: endValue,\n            min,\n            max\n        };\n    }\n    function parseValue(entry, item, vScale, i) {\n        if (isArray(entry)) {\n            parseFloatBar(entry, item, vScale, i);\n        } else {\n            item[vScale.axis] = vScale.parse(entry, i);\n        }\n        return item;\n    }\n    function parseArrayOrPrimitive(meta, data, start, count) {\n        const iScale = meta.iScale;\n        const vScale = meta.vScale;\n        const labels = iScale.getLabels();\n        const singleScale = iScale === vScale;\n        const parsed = [];\n        let i, ilen, item, entry;\n        for (i = start, ilen = start + count; i < ilen; ++i) {\n            entry = data[i];\n            item = {};\n            item[iScale.axis] = singleScale || iScale.parse(labels[i], i);\n            parsed.push(parseValue(entry, item, vScale, i));\n        }\n        return parsed;\n    }\n    function isFloatBar(custom) {\n        return custom && custom.barStart !== undefined && custom.barEnd !== undefined;\n    }\n    class BarController extends DatasetController {\n        parsePrimitiveData(meta, data, start, count) {\n            return parseArrayOrPrimitive(meta, data, start, count);\n        }\n        parseArrayData(meta, data, start, count) {\n            return parseArrayOrPrimitive(meta, data, start, count);\n        }\n        parseObjectData(meta, data, start, count) {\n            const {iScale, vScale} = meta;\n            const {xAxisKey = 'x', yAxisKey = 'y'} = this._parsing;\n            const iAxisKey = iScale.axis === 'x' ? xAxisKey : yAxisKey;\n            const vAxisKey = vScale.axis === 'x' ? xAxisKey : yAxisKey;\n            const parsed = [];\n            let i, ilen, item, obj;\n            for (i = start, ilen = start + count; i < ilen; ++i) {\n                obj = data[i];\n                item = {};\n                item[iScale.axis] = iScale.parse(resolveObjectKey(obj, iAxisKey), i);\n                parsed.push(parseValue(resolveObjectKey(obj, vAxisKey), item, vScale, i));\n            }\n            return parsed;\n        }\n        updateRangeFromParsed(range, scale, parsed, stack) {\n            super.updateRangeFromParsed(range, scale, parsed, stack);\n            const custom = parsed._custom;\n            if (custom && scale === this._cachedMeta.vScale) {\n                range.min = Math.min(range.min, custom.min);\n                range.max = Math.max(range.max, custom.max);\n            }\n        }\n        getLabelAndValue(index) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const {iScale, vScale} = meta;\n            const parsed = me.getParsed(index);\n            const custom = parsed._custom;\n            const value = isFloatBar(custom)\n                ? '[' + custom.start + ', ' + custom.end + ']'\n                : '' + vScale.getLabelForValue(parsed[vScale.axis]);\n            return {\n                label: '' + iScale.getLabelForValue(parsed[iScale.axis]),\n                value\n            };\n        }\n        initialize() {\n            const me = this;\n            me.enableOptionSharing = true;\n            super.initialize();\n            const meta = me._cachedMeta;\n            meta.stack = me.getDataset().stack;\n        }\n        update(mode) {\n            const me = this;\n            const meta = me._cachedMeta;\n            me.updateElements(meta.data, 0, meta.data.length, mode);\n        }\n        updateElements(bars, start, count, mode) {\n            const me = this;\n            const reset = mode === 'reset';\n            const vScale = me._cachedMeta.vScale;\n            const base = vScale.getBasePixel();\n            const horizontal = vScale.isHorizontal();\n            const ruler = me._getRuler();\n            const firstOpts = me.resolveDataElementOptions(start, mode);\n            const sharedOptions = me.getSharedOptions(firstOpts);\n            const includeOptions = me.includeOptions(mode, sharedOptions);\n            me.updateSharedOptions(sharedOptions, mode, firstOpts);\n            for (let i = start; i < start + count; i++) {\n                const parsed = me.getParsed(i);\n                const vpixels = reset || isNullOrUndef(parsed[vScale.axis]) ? {base, head: base} : me._calculateBarValuePixels(i);\n                const ipixels = me._calculateBarIndexPixels(i, ruler);\n                const stack = (parsed._stacks || {})[vScale.axis];\n                const properties = {\n                    horizontal,\n                    base: vpixels.base,\n                    enableBorderRadius: !stack || isFloatBar(parsed._custom) || (me.index === stack._top || me.index === stack._bottom),\n                    x: horizontal ? vpixels.head : ipixels.center,\n                    y: horizontal ? ipixels.center : vpixels.head,\n                    height: horizontal ? ipixels.size : undefined,\n                    width: horizontal ? undefined : ipixels.size\n                };\n                if (includeOptions) {\n                    properties.options = sharedOptions || me.resolveDataElementOptions(i, mode);\n                }\n                me.updateElement(bars[i], i, properties, mode);\n            }\n        }\n        _getStacks(last, dataIndex) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const iScale = meta.iScale;\n            const metasets = iScale.getMatchingVisibleMetas(me._type);\n            const stacked = iScale.options.stacked;\n            const ilen = metasets.length;\n            const stacks = [];\n            let i, item;\n            for (i = 0; i < ilen; ++i) {\n                item = metasets[i];\n                if (typeof dataIndex !== 'undefined') {\n                    const val = item.controller.getParsed(dataIndex)[\n                        item.controller._cachedMeta.vScale.axis\n                        ];\n                    if (isNullOrUndef(val) || isNaN(val)) {\n                        continue;\n                    }\n                }\n                if (stacked === false || stacks.indexOf(item.stack) === -1 ||\n                    (stacked === undefined && item.stack === undefined)) {\n                    stacks.push(item.stack);\n                }\n                if (item.index === last) {\n                    break;\n                }\n            }\n            if (!stacks.length) {\n                stacks.push(undefined);\n            }\n            return stacks;\n        }\n        _getStackCount(index) {\n            return this._getStacks(undefined, index).length;\n        }\n        _getStackIndex(datasetIndex, name, dataIndex) {\n            const stacks = this._getStacks(datasetIndex, dataIndex);\n            const index = (name !== undefined)\n                ? stacks.indexOf(name)\n                : -1;\n            return (index === -1)\n                ? stacks.length - 1\n                : index;\n        }\n        _getRuler() {\n            const me = this;\n            const opts = me.options;\n            const meta = me._cachedMeta;\n            const iScale = meta.iScale;\n            const pixels = [];\n            let i, ilen;\n            for (i = 0, ilen = meta.data.length; i < ilen; ++i) {\n                pixels.push(iScale.getPixelForValue(me.getParsed(i)[iScale.axis], i));\n            }\n            const barThickness = opts.barThickness;\n            const min = barThickness || computeMinSampleSize(iScale);\n            return {\n                min,\n                pixels,\n                start: iScale._startPixel,\n                end: iScale._endPixel,\n                stackCount: me._getStackCount(),\n                scale: iScale,\n                grouped: opts.grouped,\n                ratio: barThickness ? 1 : opts.categoryPercentage * opts.barPercentage\n            };\n        }\n        _calculateBarValuePixels(index) {\n            const me = this;\n            const {vScale, _stacked} = me._cachedMeta;\n            const {base: baseValue, minBarLength} = me.options;\n            const parsed = me.getParsed(index);\n            const custom = parsed._custom;\n            const floating = isFloatBar(custom);\n            let value = parsed[vScale.axis];\n            let start = 0;\n            let length = _stacked ? me.applyStack(vScale, parsed, _stacked) : value;\n            let head, size;\n            if (length !== value) {\n                start = length - value;\n                length = value;\n            }\n            if (floating) {\n                value = custom.barStart;\n                length = custom.barEnd - custom.barStart;\n                if (value !== 0 && sign(value) !== sign(custom.barEnd)) {\n                    start = 0;\n                }\n                start += value;\n            }\n            const startValue = !isNullOrUndef(baseValue) && !floating ? baseValue : start;\n            let base = vScale.getPixelForValue(startValue);\n            if (this.chart.getDataVisibility(index)) {\n                head = vScale.getPixelForValue(start + length);\n            } else {\n                head = base;\n            }\n            size = head - base;\n            if (minBarLength !== undefined && Math.abs(size) < minBarLength) {\n                size = size < 0 ? -minBarLength : minBarLength;\n                if (value === 0) {\n                    base -= size / 2;\n                }\n                head = base + size;\n            }\n            const actualBase = baseValue || 0;\n            if (base === vScale.getPixelForValue(actualBase)) {\n                const halfGrid = vScale.getLineWidthForValue(actualBase) / 2;\n                if (size > 0) {\n                    base += halfGrid;\n                    size -= halfGrid;\n                } else if (size < 0) {\n                    base -= halfGrid;\n                    size += halfGrid;\n                }\n            }\n            return {\n                size,\n                base,\n                head,\n                center: head + size / 2\n            };\n        }\n        _calculateBarIndexPixels(index, ruler) {\n            const me = this;\n            const scale = ruler.scale;\n            const options = me.options;\n            const skipNull = options.skipNull;\n            const maxBarThickness = valueOrDefault(options.maxBarThickness, Infinity);\n            let center, size;\n            if (ruler.grouped) {\n                const stackCount = skipNull ? me._getStackCount(index) : ruler.stackCount;\n                const range = options.barThickness === 'flex'\n                    ? computeFlexCategoryTraits(index, ruler, options, stackCount)\n                    : computeFitCategoryTraits(index, ruler, options, stackCount);\n                const stackIndex = me._getStackIndex(me.index, me._cachedMeta.stack, skipNull ? index : undefined);\n                center = range.start + (range.chunk * stackIndex) + (range.chunk / 2);\n                size = Math.min(maxBarThickness, range.chunk * range.ratio);\n            } else {\n                center = scale.getPixelForValue(me.getParsed(index)[scale.axis], index);\n                size = Math.min(maxBarThickness, ruler.min * ruler.ratio);\n            }\n            return {\n                base: center - size / 2,\n                head: center + size / 2,\n                center,\n                size\n            };\n        }\n        draw() {\n            const me = this;\n            const chart = me.chart;\n            const meta = me._cachedMeta;\n            const vScale = meta.vScale;\n            const rects = meta.data;\n            const ilen = rects.length;\n            let i = 0;\n            clipArea(chart.ctx, chart.chartArea);\n            for (; i < ilen; ++i) {\n                if (me.getParsed(i)[vScale.axis] !== null) {\n                    rects[i].draw(me._ctx);\n                }\n            }\n            unclipArea(chart.ctx);\n        }\n    }\n    BarController.id = 'bar';\n    BarController.defaults = {\n        datasetElementType: false,\n        dataElementType: 'bar',\n        categoryPercentage: 0.8,\n        barPercentage: 0.9,\n        grouped: true,\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: ['x', 'y', 'base', 'width', 'height']\n            }\n        }\n    };\n    BarController.overrides = {\n        interaction: {\n            mode: 'index'\n        },\n        scales: {\n            _index_: {\n                type: 'category',\n                offset: true,\n                grid: {\n                    offset: true\n                }\n            },\n            _value_: {\n                type: 'linear',\n                beginAtZero: true,\n            }\n        }\n    };\n\n    class BubbleController extends DatasetController {\n        initialize() {\n            this.enableOptionSharing = true;\n            super.initialize();\n        }\n        parseObjectData(meta, data, start, count) {\n            const {xScale, yScale} = meta;\n            const {xAxisKey = 'x', yAxisKey = 'y'} = this._parsing;\n            const parsed = [];\n            let i, ilen, item;\n            for (i = start, ilen = start + count; i < ilen; ++i) {\n                item = data[i];\n                parsed.push({\n                    x: xScale.parse(resolveObjectKey(item, xAxisKey), i),\n                    y: yScale.parse(resolveObjectKey(item, yAxisKey), i),\n                    _custom: item && item.r && +item.r\n                });\n            }\n            return parsed;\n        }\n        getMaxOverflow() {\n            const {data, _parsed} = this._cachedMeta;\n            let max = 0;\n            for (let i = data.length - 1; i >= 0; --i) {\n                max = Math.max(max, data[i].size() / 2, _parsed[i]._custom);\n            }\n            return max > 0 && max;\n        }\n        getLabelAndValue(index) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const {xScale, yScale} = meta;\n            const parsed = me.getParsed(index);\n            const x = xScale.getLabelForValue(parsed.x);\n            const y = yScale.getLabelForValue(parsed.y);\n            const r = parsed._custom;\n            return {\n                label: meta.label,\n                value: '(' + x + ', ' + y + (r ? ', ' + r : '') + ')'\n            };\n        }\n        update(mode) {\n            const me = this;\n            const points = me._cachedMeta.data;\n            me.updateElements(points, 0, points.length, mode);\n        }\n        updateElements(points, start, count, mode) {\n            const me = this;\n            const reset = mode === 'reset';\n            const {iScale, vScale} = me._cachedMeta;\n            const firstOpts = me.resolveDataElementOptions(start, mode);\n            const sharedOptions = me.getSharedOptions(firstOpts);\n            const includeOptions = me.includeOptions(mode, sharedOptions);\n            const iAxis = iScale.axis;\n            const vAxis = vScale.axis;\n            for (let i = start; i < start + count; i++) {\n                const point = points[i];\n                const parsed = !reset && me.getParsed(i);\n                const properties = {};\n                const iPixel = properties[iAxis] = reset ? iScale.getPixelForDecimal(0.5) : iScale.getPixelForValue(parsed[iAxis]);\n                const vPixel = properties[vAxis] = reset ? vScale.getBasePixel() : vScale.getPixelForValue(parsed[vAxis]);\n                properties.skip = isNaN(iPixel) || isNaN(vPixel);\n                if (includeOptions) {\n                    properties.options = me.resolveDataElementOptions(i, mode);\n                    if (reset) {\n                        properties.options.radius = 0;\n                    }\n                }\n                me.updateElement(point, i, properties, mode);\n            }\n            me.updateSharedOptions(sharedOptions, mode, firstOpts);\n        }\n        resolveDataElementOptions(index, mode) {\n            const parsed = this.getParsed(index);\n            let values = super.resolveDataElementOptions(index, mode);\n            if (values.$shared) {\n                values = Object.assign({}, values, {$shared: false});\n            }\n            const radius = values.radius;\n            if (mode !== 'active') {\n                values.radius = 0;\n            }\n            values.radius += valueOrDefault(parsed && parsed._custom, radius);\n            return values;\n        }\n    }\n    BubbleController.id = 'bubble';\n    BubbleController.defaults = {\n        datasetElementType: false,\n        dataElementType: 'point',\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: ['x', 'y', 'borderWidth', 'radius']\n            }\n        }\n    };\n    BubbleController.overrides = {\n        scales: {\n            x: {\n                type: 'linear'\n            },\n            y: {\n                type: 'linear'\n            }\n        },\n        plugins: {\n            tooltip: {\n                callbacks: {\n                    title() {\n                        return '';\n                    }\n                }\n            }\n        }\n    };\n\n    function getRatioAndOffset(rotation, circumference, cutout) {\n        let ratioX = 1;\n        let ratioY = 1;\n        let offsetX = 0;\n        let offsetY = 0;\n        if (circumference < TAU) {\n            const startAngle = rotation;\n            const endAngle = startAngle + circumference;\n            const startX = Math.cos(startAngle);\n            const startY = Math.sin(startAngle);\n            const endX = Math.cos(endAngle);\n            const endY = Math.sin(endAngle);\n            const calcMax = (angle, a, b) => _angleBetween(angle, startAngle, endAngle, true) ? 1 : Math.max(a, a * cutout, b, b * cutout);\n            const calcMin = (angle, a, b) => _angleBetween(angle, startAngle, endAngle, true) ? -1 : Math.min(a, a * cutout, b, b * cutout);\n            const maxX = calcMax(0, startX, endX);\n            const maxY = calcMax(HALF_PI, startY, endY);\n            const minX = calcMin(PI, startX, endX);\n            const minY = calcMin(PI + HALF_PI, startY, endY);\n            ratioX = (maxX - minX) / 2;\n            ratioY = (maxY - minY) / 2;\n            offsetX = -(maxX + minX) / 2;\n            offsetY = -(maxY + minY) / 2;\n        }\n        return {ratioX, ratioY, offsetX, offsetY};\n    }\n    class DoughnutController extends DatasetController {\n        constructor(chart, datasetIndex) {\n            super(chart, datasetIndex);\n            this.enableOptionSharing = true;\n            this.innerRadius = undefined;\n            this.outerRadius = undefined;\n            this.offsetX = undefined;\n            this.offsetY = undefined;\n        }\n        linkScales() {}\n        parse(start, count) {\n            const data = this.getDataset().data;\n            const meta = this._cachedMeta;\n            let i, ilen;\n            for (i = start, ilen = start + count; i < ilen; ++i) {\n                meta._parsed[i] = +data[i];\n            }\n        }\n        _getRotation() {\n            return toRadians(this.options.rotation - 90);\n        }\n        _getCircumference() {\n            return toRadians(this.options.circumference);\n        }\n        _getRotationExtents() {\n            let min = TAU;\n            let max = -TAU;\n            const me = this;\n            for (let i = 0; i < me.chart.data.datasets.length; ++i) {\n                if (me.chart.isDatasetVisible(i)) {\n                    const controller = me.chart.getDatasetMeta(i).controller;\n                    const rotation = controller._getRotation();\n                    const circumference = controller._getCircumference();\n                    min = Math.min(min, rotation);\n                    max = Math.max(max, rotation + circumference);\n                }\n            }\n            return {\n                rotation: min,\n                circumference: max - min,\n            };\n        }\n        update(mode) {\n            const me = this;\n            const chart = me.chart;\n            const {chartArea} = chart;\n            const meta = me._cachedMeta;\n            const arcs = meta.data;\n            const spacing = me.getMaxBorderWidth() + me.getMaxOffset(arcs);\n            const maxSize = Math.max((Math.min(chartArea.width, chartArea.height) - spacing) / 2, 0);\n            const cutout = Math.min(toPercentage(me.options.cutout, maxSize), 1);\n            const chartWeight = me._getRingWeight(me.index);\n            const {circumference, rotation} = me._getRotationExtents();\n            const {ratioX, ratioY, offsetX, offsetY} = getRatioAndOffset(rotation, circumference, cutout);\n            const maxWidth = (chartArea.width - spacing) / ratioX;\n            const maxHeight = (chartArea.height - spacing) / ratioY;\n            const maxRadius = Math.max(Math.min(maxWidth, maxHeight) / 2, 0);\n            const outerRadius = toDimension(me.options.radius, maxRadius);\n            const innerRadius = Math.max(outerRadius * cutout, 0);\n            const radiusLength = (outerRadius - innerRadius) / me._getVisibleDatasetWeightTotal();\n            me.offsetX = offsetX * outerRadius;\n            me.offsetY = offsetY * outerRadius;\n            meta.total = me.calculateTotal();\n            me.outerRadius = outerRadius - radiusLength * me._getRingWeightOffset(me.index);\n            me.innerRadius = Math.max(me.outerRadius - radiusLength * chartWeight, 0);\n            me.updateElements(arcs, 0, arcs.length, mode);\n        }\n        _circumference(i, reset) {\n            const me = this;\n            const opts = me.options;\n            const meta = me._cachedMeta;\n            const circumference = me._getCircumference();\n            if ((reset && opts.animation.animateRotate) || !this.chart.getDataVisibility(i) || meta._parsed[i] === null) {\n                return 0;\n            }\n            return me.calculateCircumference(meta._parsed[i] * circumference / TAU);\n        }\n        updateElements(arcs, start, count, mode) {\n            const me = this;\n            const reset = mode === 'reset';\n            const chart = me.chart;\n            const chartArea = chart.chartArea;\n            const opts = chart.options;\n            const animationOpts = opts.animation;\n            const centerX = (chartArea.left + chartArea.right) / 2;\n            const centerY = (chartArea.top + chartArea.bottom) / 2;\n            const animateScale = reset && animationOpts.animateScale;\n            const innerRadius = animateScale ? 0 : me.innerRadius;\n            const outerRadius = animateScale ? 0 : me.outerRadius;\n            const firstOpts = me.resolveDataElementOptions(start, mode);\n            const sharedOptions = me.getSharedOptions(firstOpts);\n            const includeOptions = me.includeOptions(mode, sharedOptions);\n            let startAngle = me._getRotation();\n            let i;\n            for (i = 0; i < start; ++i) {\n                startAngle += me._circumference(i, reset);\n            }\n            for (i = start; i < start + count; ++i) {\n                const circumference = me._circumference(i, reset);\n                const arc = arcs[i];\n                const properties = {\n                    x: centerX + me.offsetX,\n                    y: centerY + me.offsetY,\n                    startAngle,\n                    endAngle: startAngle + circumference,\n                    circumference,\n                    outerRadius,\n                    innerRadius\n                };\n                if (includeOptions) {\n                    properties.options = sharedOptions || me.resolveDataElementOptions(i, mode);\n                }\n                startAngle += circumference;\n                me.updateElement(arc, i, properties, mode);\n            }\n            me.updateSharedOptions(sharedOptions, mode, firstOpts);\n        }\n        calculateTotal() {\n            const meta = this._cachedMeta;\n            const metaData = meta.data;\n            let total = 0;\n            let i;\n            for (i = 0; i < metaData.length; i++) {\n                const value = meta._parsed[i];\n                if (value !== null && !isNaN(value) && this.chart.getDataVisibility(i)) {\n                    total += Math.abs(value);\n                }\n            }\n            return total;\n        }\n        calculateCircumference(value) {\n            const total = this._cachedMeta.total;\n            if (total > 0 && !isNaN(value)) {\n                return TAU * (Math.abs(value) / total);\n            }\n            return 0;\n        }\n        getLabelAndValue(index) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const chart = me.chart;\n            const labels = chart.data.labels || [];\n            const value = formatNumber(meta._parsed[index], chart.options.locale);\n            return {\n                label: labels[index] || '',\n                value,\n            };\n        }\n        getMaxBorderWidth(arcs) {\n            const me = this;\n            let max = 0;\n            const chart = me.chart;\n            let i, ilen, meta, controller, options;\n            if (!arcs) {\n                for (i = 0, ilen = chart.data.datasets.length; i < ilen; ++i) {\n                    if (chart.isDatasetVisible(i)) {\n                        meta = chart.getDatasetMeta(i);\n                        arcs = meta.data;\n                        controller = meta.controller;\n                        if (controller !== me) {\n                            controller.configure();\n                        }\n                        break;\n                    }\n                }\n            }\n            if (!arcs) {\n                return 0;\n            }\n            for (i = 0, ilen = arcs.length; i < ilen; ++i) {\n                options = controller.resolveDataElementOptions(i);\n                if (options.borderAlign !== 'inner') {\n                    max = Math.max(max, options.borderWidth || 0, options.hoverBorderWidth || 0);\n                }\n            }\n            return max;\n        }\n        getMaxOffset(arcs) {\n            let max = 0;\n            for (let i = 0, ilen = arcs.length; i < ilen; ++i) {\n                const options = this.resolveDataElementOptions(i);\n                max = Math.max(max, options.offset || 0, options.hoverOffset || 0);\n            }\n            return max;\n        }\n        _getRingWeightOffset(datasetIndex) {\n            let ringWeightOffset = 0;\n            for (let i = 0; i < datasetIndex; ++i) {\n                if (this.chart.isDatasetVisible(i)) {\n                    ringWeightOffset += this._getRingWeight(i);\n                }\n            }\n            return ringWeightOffset;\n        }\n        _getRingWeight(datasetIndex) {\n            return Math.max(valueOrDefault(this.chart.data.datasets[datasetIndex].weight, 1), 0);\n        }\n        _getVisibleDatasetWeightTotal() {\n            return this._getRingWeightOffset(this.chart.data.datasets.length) || 1;\n        }\n    }\n    DoughnutController.id = 'doughnut';\n    DoughnutController.defaults = {\n        datasetElementType: false,\n        dataElementType: 'arc',\n        animation: {\n            animateRotate: true,\n            animateScale: false\n        },\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: ['circumference', 'endAngle', 'innerRadius', 'outerRadius', 'startAngle', 'x', 'y', 'offset', 'borderWidth']\n            },\n        },\n        cutout: '50%',\n        rotation: 0,\n        circumference: 360,\n        radius: '100%',\n        indexAxis: 'r',\n    };\n    DoughnutController.overrides = {\n        aspectRatio: 1,\n        plugins: {\n            legend: {\n                labels: {\n                    generateLabels(chart) {\n                        const data = chart.data;\n                        if (data.labels.length && data.datasets.length) {\n                            return data.labels.map((label, i) => {\n                                const meta = chart.getDatasetMeta(0);\n                                const style = meta.controller.getStyle(i);\n                                return {\n                                    text: label,\n                                    fillStyle: style.backgroundColor,\n                                    strokeStyle: style.borderColor,\n                                    lineWidth: style.borderWidth,\n                                    hidden: !chart.getDataVisibility(i),\n                                    index: i\n                                };\n                            });\n                        }\n                        return [];\n                    }\n                },\n                onClick(e, legendItem, legend) {\n                    legend.chart.toggleDataVisibility(legendItem.index);\n                    legend.chart.update();\n                }\n            },\n            tooltip: {\n                callbacks: {\n                    title() {\n                        return '';\n                    },\n                    label(tooltipItem) {\n                        let dataLabel = tooltipItem.label;\n                        const value = ': ' + tooltipItem.formattedValue;\n                        if (isArray(dataLabel)) {\n                            dataLabel = dataLabel.slice();\n                            dataLabel[0] += value;\n                        } else {\n                            dataLabel += value;\n                        }\n                        return dataLabel;\n                    }\n                }\n            }\n        }\n    };\n\n    class LineController extends DatasetController {\n        initialize() {\n            this.enableOptionSharing = true;\n            super.initialize();\n        }\n        update(mode) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const {dataset: line, data: points = [], _dataset} = meta;\n            const animationsDisabled = me.chart._animationsDisabled;\n            let {start, count} = getStartAndCountOfVisiblePoints(meta, points, animationsDisabled);\n            me._drawStart = start;\n            me._drawCount = count;\n            if (scaleRangesChanged(meta)) {\n                start = 0;\n                count = points.length;\n            }\n            line._decimated = !!_dataset._decimated;\n            line.points = points;\n            const options = me.resolveDatasetElementOptions(mode);\n            if (!me.options.showLine) {\n                options.borderWidth = 0;\n            }\n            options.segment = me.options.segment;\n            me.updateElement(line, undefined, {\n                animated: !animationsDisabled,\n                options\n            }, mode);\n            me.updateElements(points, start, count, mode);\n        }\n        updateElements(points, start, count, mode) {\n            const me = this;\n            const reset = mode === 'reset';\n            const {iScale, vScale, _stacked} = me._cachedMeta;\n            const firstOpts = me.resolveDataElementOptions(start, mode);\n            const sharedOptions = me.getSharedOptions(firstOpts);\n            const includeOptions = me.includeOptions(mode, sharedOptions);\n            const iAxis = iScale.axis;\n            const vAxis = vScale.axis;\n            const spanGaps = me.options.spanGaps;\n            const maxGapLength = isNumber(spanGaps) ? spanGaps : Number.POSITIVE_INFINITY;\n            const directUpdate = me.chart._animationsDisabled || reset || mode === 'none';\n            let prevParsed = start > 0 && me.getParsed(start - 1);\n            for (let i = start; i < start + count; ++i) {\n                const point = points[i];\n                const parsed = me.getParsed(i);\n                const properties = directUpdate ? point : {};\n                const nullData = isNullOrUndef(parsed[vAxis]);\n                const iPixel = properties[iAxis] = iScale.getPixelForValue(parsed[iAxis], i);\n                const vPixel = properties[vAxis] = reset || nullData ? vScale.getBasePixel() : vScale.getPixelForValue(_stacked ? me.applyStack(vScale, parsed, _stacked) : parsed[vAxis], i);\n                properties.skip = isNaN(iPixel) || isNaN(vPixel) || nullData;\n                properties.stop = i > 0 && (parsed[iAxis] - prevParsed[iAxis]) > maxGapLength;\n                properties.parsed = parsed;\n                if (includeOptions) {\n                    properties.options = sharedOptions || me.resolveDataElementOptions(i, mode);\n                }\n                if (!directUpdate) {\n                    me.updateElement(point, i, properties, mode);\n                }\n                prevParsed = parsed;\n            }\n            me.updateSharedOptions(sharedOptions, mode, firstOpts);\n        }\n        getMaxOverflow() {\n            const me = this;\n            const meta = me._cachedMeta;\n            const dataset = meta.dataset;\n            const border = dataset.options && dataset.options.borderWidth || 0;\n            const data = meta.data || [];\n            if (!data.length) {\n                return border;\n            }\n            const firstPoint = data[0].size(me.resolveDataElementOptions(0));\n            const lastPoint = data[data.length - 1].size(me.resolveDataElementOptions(data.length - 1));\n            return Math.max(border, firstPoint, lastPoint) / 2;\n        }\n        draw() {\n            const meta = this._cachedMeta;\n            meta.dataset.updateControlPoints(this.chart.chartArea, meta.iScale.axis);\n            super.draw();\n        }\n    }\n    LineController.id = 'line';\n    LineController.defaults = {\n        datasetElementType: 'line',\n        dataElementType: 'point',\n        showLine: true,\n        spanGaps: false,\n    };\n    LineController.overrides = {\n        scales: {\n            _index_: {\n                type: 'category',\n            },\n            _value_: {\n                type: 'linear',\n            },\n        }\n    };\n    function getStartAndCountOfVisiblePoints(meta, points, animationsDisabled) {\n        const pointCount = points.length;\n        let start = 0;\n        let count = pointCount;\n        if (meta._sorted) {\n            const {iScale, _parsed} = meta;\n            const axis = iScale.axis;\n            const {min, max, minDefined, maxDefined} = iScale.getUserBounds();\n            if (minDefined) {\n                start = _limitValue(Math.min(\n                    _lookupByKey(_parsed, iScale.axis, min).lo,\n                    animationsDisabled ? pointCount : _lookupByKey(points, axis, iScale.getPixelForValue(min)).lo),\n                    0, pointCount - 1);\n            }\n            if (maxDefined) {\n                count = _limitValue(Math.max(\n                    _lookupByKey(_parsed, iScale.axis, max).hi + 1,\n                    animationsDisabled ? 0 : _lookupByKey(points, axis, iScale.getPixelForValue(max)).hi + 1),\n                    start, pointCount) - start;\n            } else {\n                count = pointCount - start;\n            }\n        }\n        return {start, count};\n    }\n    function scaleRangesChanged(meta) {\n        const {xScale, yScale, _scaleRanges} = meta;\n        const newRanges = {\n            xmin: xScale.min,\n            xmax: xScale.max,\n            ymin: yScale.min,\n            ymax: yScale.max\n        };\n        if (!_scaleRanges) {\n            meta._scaleRanges = newRanges;\n            return true;\n        }\n        const changed = _scaleRanges.xmin !== xScale.min\n            || _scaleRanges.xmax !== xScale.max\n            || _scaleRanges.ymin !== yScale.min\n            || _scaleRanges.ymax !== yScale.max;\n        Object.assign(_scaleRanges, newRanges);\n        return changed;\n    }\n\n    class PolarAreaController extends DatasetController {\n        constructor(chart, datasetIndex) {\n            super(chart, datasetIndex);\n            this.innerRadius = undefined;\n            this.outerRadius = undefined;\n        }\n        getLabelAndValue(index) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const chart = me.chart;\n            const labels = chart.data.labels || [];\n            const value = formatNumber(meta._parsed[index].r, chart.options.locale);\n            return {\n                label: labels[index] || '',\n                value,\n            };\n        }\n        update(mode) {\n            const arcs = this._cachedMeta.data;\n            this._updateRadius();\n            this.updateElements(arcs, 0, arcs.length, mode);\n        }\n        _updateRadius() {\n            const me = this;\n            const chart = me.chart;\n            const chartArea = chart.chartArea;\n            const opts = chart.options;\n            const minSize = Math.min(chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);\n            const outerRadius = Math.max(minSize / 2, 0);\n            const innerRadius = Math.max(opts.cutoutPercentage ? (outerRadius / 100) * (opts.cutoutPercentage) : 1, 0);\n            const radiusLength = (outerRadius - innerRadius) / chart.getVisibleDatasetCount();\n            me.outerRadius = outerRadius - (radiusLength * me.index);\n            me.innerRadius = me.outerRadius - radiusLength;\n        }\n        updateElements(arcs, start, count, mode) {\n            const me = this;\n            const reset = mode === 'reset';\n            const chart = me.chart;\n            const dataset = me.getDataset();\n            const opts = chart.options;\n            const animationOpts = opts.animation;\n            const scale = me._cachedMeta.rScale;\n            const centerX = scale.xCenter;\n            const centerY = scale.yCenter;\n            const datasetStartAngle = scale.getIndexAngle(0) - 0.5 * PI;\n            let angle = datasetStartAngle;\n            let i;\n            const defaultAngle = 360 / me.countVisibleElements();\n            for (i = 0; i < start; ++i) {\n                angle += me._computeAngle(i, mode, defaultAngle);\n            }\n            for (i = start; i < start + count; i++) {\n                const arc = arcs[i];\n                let startAngle = angle;\n                let endAngle = angle + me._computeAngle(i, mode, defaultAngle);\n                let outerRadius = chart.getDataVisibility(i) ? scale.getDistanceFromCenterForValue(dataset.data[i]) : 0;\n                angle = endAngle;\n                if (reset) {\n                    if (animationOpts.animateScale) {\n                        outerRadius = 0;\n                    }\n                    if (animationOpts.animateRotate) {\n                        startAngle = endAngle = datasetStartAngle;\n                    }\n                }\n                const properties = {\n                    x: centerX,\n                    y: centerY,\n                    innerRadius: 0,\n                    outerRadius,\n                    startAngle,\n                    endAngle,\n                    options: me.resolveDataElementOptions(i, mode)\n                };\n                me.updateElement(arc, i, properties, mode);\n            }\n        }\n        countVisibleElements() {\n            const dataset = this.getDataset();\n            const meta = this._cachedMeta;\n            let count = 0;\n            meta.data.forEach((element, index) => {\n                if (!isNaN(dataset.data[index]) && this.chart.getDataVisibility(index)) {\n                    count++;\n                }\n            });\n            return count;\n        }\n        _computeAngle(index, mode, defaultAngle) {\n            return this.chart.getDataVisibility(index)\n                ? toRadians(this.resolveDataElementOptions(index, mode).angle || defaultAngle)\n                : 0;\n        }\n    }\n    PolarAreaController.id = 'polarArea';\n    PolarAreaController.defaults = {\n        dataElementType: 'arc',\n        animation: {\n            animateRotate: true,\n            animateScale: true\n        },\n        animations: {\n            numbers: {\n                type: 'number',\n                properties: ['x', 'y', 'startAngle', 'endAngle', 'innerRadius', 'outerRadius']\n            },\n        },\n        indexAxis: 'r',\n        startAngle: 0,\n    };\n    PolarAreaController.overrides = {\n        aspectRatio: 1,\n        plugins: {\n            legend: {\n                labels: {\n                    generateLabels(chart) {\n                        const data = chart.data;\n                        if (data.labels.length && data.datasets.length) {\n                            return data.labels.map((label, i) => {\n                                const meta = chart.getDatasetMeta(0);\n                                const style = meta.controller.getStyle(i);\n                                return {\n                                    text: label,\n                                    fillStyle: style.backgroundColor,\n                                    strokeStyle: style.borderColor,\n                                    lineWidth: style.borderWidth,\n                                    hidden: !chart.getDataVisibility(i),\n                                    index: i\n                                };\n                            });\n                        }\n                        return [];\n                    }\n                },\n                onClick(e, legendItem, legend) {\n                    legend.chart.toggleDataVisibility(legendItem.index);\n                    legend.chart.update();\n                }\n            },\n            tooltip: {\n                callbacks: {\n                    title() {\n                        return '';\n                    },\n                    label(context) {\n                        return context.chart.data.labels[context.dataIndex] + ': ' + context.formattedValue;\n                    }\n                }\n            }\n        },\n        scales: {\n            r: {\n                type: 'radialLinear',\n                angleLines: {\n                    display: false\n                },\n                beginAtZero: true,\n                grid: {\n                    circular: true\n                },\n                pointLabels: {\n                    display: false\n                },\n                startAngle: 0\n            }\n        }\n    };\n\n    class PieController extends DoughnutController {\n    }\n    PieController.id = 'pie';\n    PieController.defaults = {\n        cutout: 0,\n        rotation: 0,\n        circumference: 360,\n        radius: '100%'\n    };\n\n    class RadarController extends DatasetController {\n        getLabelAndValue(index) {\n            const me = this;\n            const vScale = me._cachedMeta.vScale;\n            const parsed = me.getParsed(index);\n            return {\n                label: vScale.getLabels()[index],\n                value: '' + vScale.getLabelForValue(parsed[vScale.axis])\n            };\n        }\n        update(mode) {\n            const me = this;\n            const meta = me._cachedMeta;\n            const line = meta.dataset;\n            const points = meta.data || [];\n            const labels = meta.iScale.getLabels();\n            line.points = points;\n            if (mode !== 'resize') {\n                const options = me.resolveDatasetElementOptions(mode);\n                if (!me.options.showLine) {\n                    options.borderWidth = 0;\n                }\n                const properties = {\n                    _loop: true,\n                    _fullLoop: labels.length === points.length,\n                    options\n                };\n                me.updateElement(line, undefined, properties, mode);\n            }\n            me.updateElements(points, 0, points.length, mode);\n        }\n        updateElements(points, start, count, mode) {\n            const me = this;\n            const dataset = me.getDataset();\n            const scale = me._cachedMeta.rScale;\n            const reset = mode === 'reset';\n            for (let i = start; i < start + count; i++) {\n                const point = points[i];\n                const options = me.resolveDataElementOptions(i, mode);\n                const pointPosition = scale.getPointPositionForValue(i, dataset.data[i]);\n                const x = reset ? scale.xCenter : pointPosition.x;\n                const y = reset ? scale.yCenter : pointPosition.y;\n                const properties = {\n                    x,\n                    y,\n                    angle: pointPosition.angle,\n                    skip: isNaN(x) || isNaN(y),\n                    options\n                };\n                me.updateElement(point, i, properties, mode);\n            }\n        }\n    }\n    RadarController.id = 'radar';\n    RadarController.defaults = {\n        datasetElementType: 'line',\n        dataElementType: 'point',\n        indexAxis: 'r',\n        showLine: true,\n        elements: {\n            line: {\n                fill: 'start'\n            }\n        },\n    };\n    RadarController.overrides = {\n        aspectRatio: 1,\n        scales: {\n            r: {\n                type: 'radialLinear',\n            }\n        }\n    };\n\n    class ScatterController extends LineController {\n    }\n    ScatterController.id = 'scatter';\n    ScatterController.defaults = {\n        showLine: false,\n        fill: false\n    };\n    ScatterController.overrides = {\n        interaction: {\n            mode: 'point'\n        },\n        plugins: {\n            tooltip: {\n                callbacks: {\n                    title() {\n                        return '';\n                    },\n                    label(item) {\n                        return '(' + item.label + ', ' + item.formattedValue + ')';\n                    }\n                }\n            }\n        },\n        scales: {\n            x: {\n                type: 'linear'\n            },\n            y: {\n                type: 'linear'\n            }\n        }\n    };\n\n    var controllers = /*#__PURE__*/Object.freeze({\n        __proto__: null,\n        BarController: BarController,\n        BubbleController: BubbleController,\n        DoughnutController: DoughnutController,\n        LineController: LineController,\n        PolarAreaController: PolarAreaController,\n        PieController: PieController,\n        RadarController: RadarController,\n        ScatterController: ScatterController\n    });\n\n    function clipArc(ctx, element, endAngle) {\n        const {startAngle, pixelMargin, x, y, outerRadius, innerRadius} = element;\n        let angleMargin = pixelMargin / outerRadius;\n        ctx.beginPath();\n        ctx.arc(x, y, outerRadius, startAngle - angleMargin, endAngle + angleMargin);\n        if (innerRadius > pixelMargin) {\n            angleMargin = pixelMargin / innerRadius;\n            ctx.arc(x, y, innerRadius, endAngle + angleMargin, startAngle - angleMargin, true);\n        } else {\n            ctx.arc(x, y, pixelMargin, endAngle + HALF_PI, startAngle - HALF_PI);\n        }\n        ctx.closePath();\n        ctx.clip();\n    }\n    function toRadiusCorners(value) {\n        return _readValueToProps(value, ['outerStart', 'outerEnd', 'innerStart', 'innerEnd']);\n    }\n    function parseBorderRadius$1(arc, innerRadius, outerRadius, angleDelta) {\n        const o = toRadiusCorners(arc.options.borderRadius);\n        const halfThickness = (outerRadius - innerRadius) / 2;\n        const innerLimit = Math.min(halfThickness, angleDelta * innerRadius / 2);\n        const computeOuterLimit = (val) => {\n            const outerArcLimit = (outerRadius - Math.min(halfThickness, val)) * angleDelta / 2;\n            return _limitValue(val, 0, Math.min(halfThickness, outerArcLimit));\n        };\n        return {\n            outerStart: computeOuterLimit(o.outerStart),\n            outerEnd: computeOuterLimit(o.outerEnd),\n            innerStart: _limitValue(o.innerStart, 0, innerLimit),\n            innerEnd: _limitValue(o.innerEnd, 0, innerLimit),\n        };\n    }\n    function rThetaToXY(r, theta, x, y) {\n        return {\n            x: x + r * Math.cos(theta),\n            y: y + r * Math.sin(theta),\n        };\n    }\n    function pathArc(ctx, element, offset, end) {\n        const {x, y, startAngle: start, pixelMargin, innerRadius: innerR} = element;\n        const outerRadius = Math.max(element.outerRadius + offset - pixelMargin, 0);\n        const innerRadius = innerR > 0 ? innerR + offset + pixelMargin : 0;\n        const alpha = end - start;\n        const beta = Math.max(0.001, alpha * outerRadius - offset / PI) / outerRadius;\n        const angleOffset = (alpha - beta) / 2;\n        const startAngle = start + angleOffset;\n        const endAngle = end - angleOffset;\n        const {outerStart, outerEnd, innerStart, innerEnd} = parseBorderRadius$1(element, innerRadius, outerRadius, endAngle - startAngle);\n        const outerStartAdjustedRadius = outerRadius - outerStart;\n        const outerEndAdjustedRadius = outerRadius - outerEnd;\n        const outerStartAdjustedAngle = startAngle + outerStart / outerStartAdjustedRadius;\n        const outerEndAdjustedAngle = endAngle - outerEnd / outerEndAdjustedRadius;\n        const innerStartAdjustedRadius = innerRadius + innerStart;\n        const innerEndAdjustedRadius = innerRadius + innerEnd;\n        const innerStartAdjustedAngle = startAngle + innerStart / innerStartAdjustedRadius;\n        const innerEndAdjustedAngle = endAngle - innerEnd / innerEndAdjustedRadius;\n        ctx.beginPath();\n        ctx.arc(x, y, outerRadius, outerStartAdjustedAngle, outerEndAdjustedAngle);\n        if (outerEnd > 0) {\n            const pCenter = rThetaToXY(outerEndAdjustedRadius, outerEndAdjustedAngle, x, y);\n            ctx.arc(pCenter.x, pCenter.y, outerEnd, outerEndAdjustedAngle, endAngle + HALF_PI);\n        }\n        const p4 = rThetaToXY(innerEndAdjustedRadius, endAngle, x, y);\n        ctx.lineTo(p4.x, p4.y);\n        if (innerEnd > 0) {\n            const pCenter = rThetaToXY(innerEndAdjustedRadius, innerEndAdjustedAngle, x, y);\n            ctx.arc(pCenter.x, pCenter.y, innerEnd, endAngle + HALF_PI, innerEndAdjustedAngle + Math.PI);\n        }\n        ctx.arc(x, y, innerRadius, endAngle - (innerEnd / innerRadius), startAngle + (innerStart / innerRadius), true);\n        if (innerStart > 0) {\n            const pCenter = rThetaToXY(innerStartAdjustedRadius, innerStartAdjustedAngle, x, y);\n            ctx.arc(pCenter.x, pCenter.y, innerStart, innerStartAdjustedAngle + Math.PI, startAngle - HALF_PI);\n        }\n        const p8 = rThetaToXY(outerStartAdjustedRadius, startAngle, x, y);\n        ctx.lineTo(p8.x, p8.y);\n        if (outerStart > 0) {\n            const pCenter = rThetaToXY(outerStartAdjustedRadius, outerStartAdjustedAngle, x, y);\n            ctx.arc(pCenter.x, pCenter.y, outerStart, startAngle - HALF_PI, outerStartAdjustedAngle);\n        }\n        ctx.closePath();\n    }\n    function drawArc(ctx, element, offset) {\n        const {fullCircles, startAngle, circumference} = element;\n        let endAngle = element.endAngle;\n        if (fullCircles) {\n            pathArc(ctx, element, offset, startAngle + TAU);\n            for (let i = 0; i < fullCircles; ++i) {\n                ctx.fill();\n            }\n            if (!isNaN(circumference)) {\n                endAngle = startAngle + circumference % TAU;\n                if (circumference % TAU === 0) {\n                    endAngle += TAU;\n                }\n            }\n        }\n        pathArc(ctx, element, offset, endAngle);\n        ctx.fill();\n        return endAngle;\n    }\n    function drawFullCircleBorders(ctx, element, inner) {\n        const {x, y, startAngle, pixelMargin, fullCircles} = element;\n        const outerRadius = Math.max(element.outerRadius - pixelMargin, 0);\n        const innerRadius = element.innerRadius + pixelMargin;\n        let i;\n        if (inner) {\n            clipArc(ctx, element, startAngle + TAU);\n        }\n        ctx.beginPath();\n        ctx.arc(x, y, innerRadius, startAngle + TAU, startAngle, true);\n        for (i = 0; i < fullCircles; ++i) {\n            ctx.stroke();\n        }\n        ctx.beginPath();\n        ctx.arc(x, y, outerRadius, startAngle, startAngle + TAU);\n        for (i = 0; i < fullCircles; ++i) {\n            ctx.stroke();\n        }\n    }\n    function drawBorder(ctx, element, offset, endAngle) {\n        const {options} = element;\n        const inner = options.borderAlign === 'inner';\n        if (!options.borderWidth) {\n            return;\n        }\n        if (inner) {\n            ctx.lineWidth = options.borderWidth * 2;\n            ctx.lineJoin = 'round';\n        } else {\n            ctx.lineWidth = options.borderWidth;\n            ctx.lineJoin = 'bevel';\n        }\n        if (element.fullCircles) {\n            drawFullCircleBorders(ctx, element, inner);\n        }\n        if (inner) {\n            clipArc(ctx, element, endAngle);\n        }\n        pathArc(ctx, element, offset, endAngle);\n        ctx.stroke();\n    }\n    class ArcElement extends Element {\n        constructor(cfg) {\n            super();\n            this.options = undefined;\n            this.circumference = undefined;\n            this.startAngle = undefined;\n            this.endAngle = undefined;\n            this.innerRadius = undefined;\n            this.outerRadius = undefined;\n            this.pixelMargin = 0;\n            this.fullCircles = 0;\n            if (cfg) {\n                Object.assign(this, cfg);\n            }\n        }\n        inRange(chartX, chartY, useFinalPosition) {\n            const point = this.getProps(['x', 'y'], useFinalPosition);\n            const {angle, distance} = getAngleFromPoint(point, {x: chartX, y: chartY});\n            const {startAngle, endAngle, innerRadius, outerRadius, circumference} = this.getProps([\n                'startAngle',\n                'endAngle',\n                'innerRadius',\n                'outerRadius',\n                'circumference'\n            ], useFinalPosition);\n            const betweenAngles = circumference >= TAU || _angleBetween(angle, startAngle, endAngle);\n            const withinRadius = (distance >= innerRadius && distance <= outerRadius);\n            return (betweenAngles && withinRadius);\n        }\n        getCenterPoint(useFinalPosition) {\n            const {x, y, startAngle, endAngle, innerRadius, outerRadius} = this.getProps([\n                'x',\n                'y',\n                'startAngle',\n                'endAngle',\n                'innerRadius',\n                'outerRadius',\n                'circumference'\n            ], useFinalPosition);\n            const halfAngle = (startAngle + endAngle) / 2;\n            const halfRadius = (innerRadius + outerRadius) / 2;\n            return {\n                x: x + Math.cos(halfAngle) * halfRadius,\n                y: y + Math.sin(halfAngle) * halfRadius\n            };\n        }\n        tooltipPosition(useFinalPosition) {\n            return this.getCenterPoint(useFinalPosition);\n        }\n        draw(ctx) {\n            const me = this;\n            const {options, circumference} = me;\n            const offset = (options.offset || 0) / 2;\n            me.pixelMargin = (options.borderAlign === 'inner') ? 0.33 : 0;\n            me.fullCircles = circumference > TAU ? Math.floor(circumference / TAU) : 0;\n            if (circumference === 0 || me.innerRadius < 0 || me.outerRadius < 0) {\n                return;\n            }\n            ctx.save();\n            let radiusOffset = 0;\n            if (offset) {\n                radiusOffset = offset / 2;\n                const halfAngle = (me.startAngle + me.endAngle) / 2;\n                ctx.translate(Math.cos(halfAngle) * radiusOffset, Math.sin(halfAngle) * radiusOffset);\n                if (me.circumference >= PI) {\n                    radiusOffset = offset;\n                }\n            }\n            ctx.fillStyle = options.backgroundColor;\n            ctx.strokeStyle = options.borderColor;\n            const endAngle = drawArc(ctx, me, radiusOffset);\n            drawBorder(ctx, me, radiusOffset, endAngle);\n            ctx.restore();\n        }\n    }\n    ArcElement.id = 'arc';\n    ArcElement.defaults = {\n        borderAlign: 'center',\n        borderColor: '#fff',\n        borderRadius: 0,\n        borderWidth: 2,\n        offset: 0,\n        angle: undefined,\n    };\n    ArcElement.defaultRoutes = {\n        backgroundColor: 'backgroundColor'\n    };\n\n    function setStyle(ctx, options, style = options) {\n        ctx.lineCap = valueOrDefault(style.borderCapStyle, options.borderCapStyle);\n        ctx.setLineDash(valueOrDefault(style.borderDash, options.borderDash));\n        ctx.lineDashOffset = valueOrDefault(style.borderDashOffset, options.borderDashOffset);\n        ctx.lineJoin = valueOrDefault(style.borderJoinStyle, options.borderJoinStyle);\n        ctx.lineWidth = valueOrDefault(style.borderWidth, options.borderWidth);\n        ctx.strokeStyle = valueOrDefault(style.borderColor, options.borderColor);\n    }\n    function lineTo(ctx, previous, target) {\n        ctx.lineTo(target.x, target.y);\n    }\n    function getLineMethod(options) {\n        if (options.stepped) {\n            return _steppedLineTo;\n        }\n        if (options.tension || options.cubicInterpolationMode === 'monotone') {\n            return _bezierCurveTo;\n        }\n        return lineTo;\n    }\n    function pathVars(points, segment, params = {}) {\n        const count = points.length;\n        const {start: paramsStart = 0, end: paramsEnd = count - 1} = params;\n        const {start: segmentStart, end: segmentEnd} = segment;\n        const start = Math.max(paramsStart, segmentStart);\n        const end = Math.min(paramsEnd, segmentEnd);\n        const outside = paramsStart < segmentStart && paramsEnd < segmentStart || paramsStart > segmentEnd && paramsEnd > segmentEnd;\n        return {\n            count,\n            start,\n            loop: segment.loop,\n            ilen: end < start && !outside ? count + end - start : end - start\n        };\n    }\n    function pathSegment(ctx, line, segment, params) {\n        const {points, options} = line;\n        const {count, start, loop, ilen} = pathVars(points, segment, params);\n        const lineMethod = getLineMethod(options);\n        let {move = true, reverse} = params || {};\n        let i, point, prev;\n        for (i = 0; i <= ilen; ++i) {\n            point = points[(start + (reverse ? ilen - i : i)) % count];\n            if (point.skip) {\n                continue;\n            } else if (move) {\n                ctx.moveTo(point.x, point.y);\n                move = false;\n            } else {\n                lineMethod(ctx, prev, point, reverse, options.stepped);\n            }\n            prev = point;\n        }\n        if (loop) {\n            point = points[(start + (reverse ? ilen : 0)) % count];\n            lineMethod(ctx, prev, point, reverse, options.stepped);\n        }\n        return !!loop;\n    }\n    function fastPathSegment(ctx, line, segment, params) {\n        const points = line.points;\n        const {count, start, ilen} = pathVars(points, segment, params);\n        const {move = true, reverse} = params || {};\n        let avgX = 0;\n        let countX = 0;\n        let i, point, prevX, minY, maxY, lastY;\n        const pointIndex = (index) => (start + (reverse ? ilen - index : index)) % count;\n        const drawX = () => {\n            if (minY !== maxY) {\n                ctx.lineTo(avgX, maxY);\n                ctx.lineTo(avgX, minY);\n                ctx.lineTo(avgX, lastY);\n            }\n        };\n        if (move) {\n            point = points[pointIndex(0)];\n            ctx.moveTo(point.x, point.y);\n        }\n        for (i = 0; i <= ilen; ++i) {\n            point = points[pointIndex(i)];\n            if (point.skip) {\n                continue;\n            }\n            const x = point.x;\n            const y = point.y;\n            const truncX = x | 0;\n            if (truncX === prevX) {\n                if (y < minY) {\n                    minY = y;\n                } else if (y > maxY) {\n                    maxY = y;\n                }\n                avgX = (countX * avgX + x) / ++countX;\n            } else {\n                drawX();\n                ctx.lineTo(x, y);\n                prevX = truncX;\n                countX = 0;\n                minY = maxY = y;\n            }\n            lastY = y;\n        }\n        drawX();\n    }\n    function _getSegmentMethod(line) {\n        const opts = line.options;\n        const borderDash = opts.borderDash && opts.borderDash.length;\n        const useFastPath = !line._decimated && !line._loop && !opts.tension && opts.cubicInterpolationMode !== 'monotone' && !opts.stepped && !borderDash;\n        return useFastPath ? fastPathSegment : pathSegment;\n    }\n    function _getInterpolationMethod(options) {\n        if (options.stepped) {\n            return _steppedInterpolation;\n        }\n        if (options.tension || options.cubicInterpolationMode === 'monotone') {\n            return _bezierInterpolation;\n        }\n        return _pointInLine;\n    }\n    function strokePathWithCache(ctx, line, start, count) {\n        let path = line._path;\n        if (!path) {\n            path = line._path = new Path2D();\n            if (line.path(path, start, count)) {\n                path.closePath();\n            }\n        }\n        setStyle(ctx, line.options);\n        ctx.stroke(path);\n    }\n    function strokePathDirect(ctx, line, start, count) {\n        const {segments, options} = line;\n        const segmentMethod = _getSegmentMethod(line);\n        for (const segment of segments) {\n            setStyle(ctx, options, segment.style);\n            ctx.beginPath();\n            if (segmentMethod(ctx, line, segment, {start, end: start + count - 1})) {\n                ctx.closePath();\n            }\n            ctx.stroke();\n        }\n    }\n    const usePath2D = typeof Path2D === 'function';\n    function draw(ctx, line, start, count) {\n        if (usePath2D && line.segments.length === 1) {\n            strokePathWithCache(ctx, line, start, count);\n        } else {\n            strokePathDirect(ctx, line, start, count);\n        }\n    }\n    class LineElement extends Element {\n        constructor(cfg) {\n            super();\n            this.animated = true;\n            this.options = undefined;\n            this._loop = undefined;\n            this._fullLoop = undefined;\n            this._path = undefined;\n            this._points = undefined;\n            this._segments = undefined;\n            this._decimated = false;\n            this._pointsUpdated = false;\n            if (cfg) {\n                Object.assign(this, cfg);\n            }\n        }\n        updateControlPoints(chartArea, indexAxis) {\n            const me = this;\n            const options = me.options;\n            if ((options.tension || options.cubicInterpolationMode === 'monotone') && !options.stepped && !me._pointsUpdated) {\n                const loop = options.spanGaps ? me._loop : me._fullLoop;\n                _updateBezierControlPoints(me._points, options, chartArea, loop, indexAxis);\n                me._pointsUpdated = true;\n            }\n        }\n        set points(points) {\n            const me = this;\n            me._points = points;\n            delete me._segments;\n            delete me._path;\n            me._pointsUpdated = false;\n        }\n        get points() {\n            return this._points;\n        }\n        get segments() {\n            return this._segments || (this._segments = _computeSegments(this, this.options.segment));\n        }\n        first() {\n            const segments = this.segments;\n            const points = this.points;\n            return segments.length && points[segments[0].start];\n        }\n        last() {\n            const segments = this.segments;\n            const points = this.points;\n            const count = segments.length;\n            return count && points[segments[count - 1].end];\n        }\n        interpolate(point, property) {\n            const me = this;\n            const options = me.options;\n            const value = point[property];\n            const points = me.points;\n            const segments = _boundSegments(me, {property, start: value, end: value});\n            if (!segments.length) {\n                return;\n            }\n            const result = [];\n            const _interpolate = _getInterpolationMethod(options);\n            let i, ilen;\n            for (i = 0, ilen = segments.length; i < ilen; ++i) {\n                const {start, end} = segments[i];\n                const p1 = points[start];\n                const p2 = points[end];\n                if (p1 === p2) {\n                    result.push(p1);\n                    continue;\n                }\n                const t = Math.abs((value - p1[property]) / (p2[property] - p1[property]));\n                const interpolated = _interpolate(p1, p2, t, options.stepped);\n                interpolated[property] = point[property];\n                result.push(interpolated);\n            }\n            return result.length === 1 ? result[0] : result;\n        }\n        pathSegment(ctx, segment, params) {\n            const segmentMethod = _getSegmentMethod(this);\n            return segmentMethod(ctx, this, segment, params);\n        }\n        path(ctx, start, count) {\n            const me = this;\n            const segments = me.segments;\n            const segmentMethod = _getSegmentMethod(me);\n            let loop = me._loop;\n            start = start || 0;\n            count = count || (me.points.length - start);\n            for (const segment of segments) {\n                loop &= segmentMethod(ctx, me, segment, {start, end: start + count - 1});\n            }\n            return !!loop;\n        }\n        draw(ctx, chartArea, start, count) {\n            const me = this;\n            const options = me.options || {};\n            const points = me.points || [];\n            if (!points.length || !options.borderWidth) {\n                return;\n            }\n            ctx.save();\n            draw(ctx, me, start, count);\n            ctx.restore();\n            if (me.animated) {\n                me._pointsUpdated = false;\n                me._path = undefined;\n            }\n        }\n    }\n    LineElement.id = 'line';\n    LineElement.defaults = {\n        borderCapStyle: 'butt',\n        borderDash: [],\n        borderDashOffset: 0,\n        borderJoinStyle: 'miter',\n        borderWidth: 3,\n        capBezierPoints: true,\n        cubicInterpolationMode: 'default',\n        fill: false,\n        spanGaps: false,\n        stepped: false,\n        tension: 0,\n    };\n    LineElement.defaultRoutes = {\n        backgroundColor: 'backgroundColor',\n        borderColor: 'borderColor'\n    };\n    LineElement.descriptors = {\n        _scriptable: true,\n        _indexable: (name) => name !== 'borderDash' && name !== 'fill',\n    };\n\n    function inRange$1(el, pos, axis, useFinalPosition) {\n        const options = el.options;\n        const {[axis]: value} = el.getProps([axis], useFinalPosition);\n        return (Math.abs(pos - value) < options.radius + options.hitRadius);\n    }\n    class PointElement extends Element {\n        constructor(cfg) {\n            super();\n            this.options = undefined;\n            this.parsed = undefined;\n            this.skip = undefined;\n            this.stop = undefined;\n            if (cfg) {\n                Object.assign(this, cfg);\n            }\n        }\n        inRange(mouseX, mouseY, useFinalPosition) {\n            const options = this.options;\n            const {x, y} = this.getProps(['x', 'y'], useFinalPosition);\n            return ((Math.pow(mouseX - x, 2) + Math.pow(mouseY - y, 2)) < Math.pow(options.hitRadius + options.radius, 2));\n        }\n        inXRange(mouseX, useFinalPosition) {\n            return inRange$1(this, mouseX, 'x', useFinalPosition);\n        }\n        inYRange(mouseY, useFinalPosition) {\n            return inRange$1(this, mouseY, 'y', useFinalPosition);\n        }\n        getCenterPoint(useFinalPosition) {\n            const {x, y} = this.getProps(['x', 'y'], useFinalPosition);\n            return {x, y};\n        }\n        size(options) {\n            options = options || this.options || {};\n            let radius = options.radius || 0;\n            radius = Math.max(radius, radius && options.hoverRadius || 0);\n            const borderWidth = radius && options.borderWidth || 0;\n            return (radius + borderWidth) * 2;\n        }\n        draw(ctx) {\n            const me = this;\n            const options = me.options;\n            if (me.skip || options.radius < 0.1) {\n                return;\n            }\n            ctx.strokeStyle = options.borderColor;\n            ctx.lineWidth = options.borderWidth;\n            ctx.fillStyle = options.backgroundColor;\n            drawPoint(ctx, options, me.x, me.y);\n        }\n        getRange() {\n            const options = this.options || {};\n            return options.radius + options.hitRadius;\n        }\n    }\n    PointElement.id = 'point';\n    PointElement.defaults = {\n        borderWidth: 1,\n        hitRadius: 1,\n        hoverBorderWidth: 1,\n        hoverRadius: 4,\n        pointStyle: 'circle',\n        radius: 3,\n        rotation: 0\n    };\n    PointElement.defaultRoutes = {\n        backgroundColor: 'backgroundColor',\n        borderColor: 'borderColor'\n    };\n\n    function getBarBounds(bar, useFinalPosition) {\n        const {x, y, base, width, height} = bar.getProps(['x', 'y', 'base', 'width', 'height'], useFinalPosition);\n        let left, right, top, bottom, half;\n        if (bar.horizontal) {\n            half = height / 2;\n            left = Math.min(x, base);\n            right = Math.max(x, base);\n            top = y - half;\n            bottom = y + half;\n        } else {\n            half = width / 2;\n            left = x - half;\n            right = x + half;\n            top = Math.min(y, base);\n            bottom = Math.max(y, base);\n        }\n        return {left, top, right, bottom};\n    }\n    function parseBorderSkipped(bar) {\n        let edge = bar.options.borderSkipped;\n        const res = {};\n        if (!edge) {\n            return res;\n        }\n        edge = bar.horizontal\n            ? parseEdge(edge, 'left', 'right', bar.base > bar.x)\n            : parseEdge(edge, 'bottom', 'top', bar.base < bar.y);\n        res[edge] = true;\n        return res;\n    }\n    function parseEdge(edge, a, b, reverse) {\n        if (reverse) {\n            edge = swap(edge, a, b);\n            edge = startEnd(edge, b, a);\n        } else {\n            edge = startEnd(edge, a, b);\n        }\n        return edge;\n    }\n    function swap(orig, v1, v2) {\n        return orig === v1 ? v2 : orig === v2 ? v1 : orig;\n    }\n    function startEnd(v, start, end) {\n        return v === 'start' ? start : v === 'end' ? end : v;\n    }\n    function skipOrLimit(skip, value, min, max) {\n        return skip ? 0 : Math.max(Math.min(value, max), min);\n    }\n    function parseBorderWidth(bar, maxW, maxH) {\n        const value = bar.options.borderWidth;\n        const skip = parseBorderSkipped(bar);\n        const o = toTRBL(value);\n        return {\n            t: skipOrLimit(skip.top, o.top, 0, maxH),\n            r: skipOrLimit(skip.right, o.right, 0, maxW),\n            b: skipOrLimit(skip.bottom, o.bottom, 0, maxH),\n            l: skipOrLimit(skip.left, o.left, 0, maxW)\n        };\n    }\n    function parseBorderRadius(bar, maxW, maxH) {\n        const {enableBorderRadius} = bar.getProps(['enableBorderRadius']);\n        const value = bar.options.borderRadius;\n        const o = toTRBLCorners(value);\n        const maxR = Math.min(maxW, maxH);\n        const skip = parseBorderSkipped(bar);\n        const enableBorder = enableBorderRadius || isObject(value);\n        return {\n            topLeft: skipOrLimit(!enableBorder || skip.top || skip.left, o.topLeft, 0, maxR),\n            topRight: skipOrLimit(!enableBorder || skip.top || skip.right, o.topRight, 0, maxR),\n            bottomLeft: skipOrLimit(!enableBorder || skip.bottom || skip.left, o.bottomLeft, 0, maxR),\n            bottomRight: skipOrLimit(!enableBorder || skip.bottom || skip.right, o.bottomRight, 0, maxR)\n        };\n    }\n    function boundingRects(bar) {\n        const bounds = getBarBounds(bar);\n        const width = bounds.right - bounds.left;\n        const height = bounds.bottom - bounds.top;\n        const border = parseBorderWidth(bar, width / 2, height / 2);\n        const radius = parseBorderRadius(bar, width / 2, height / 2);\n        return {\n            outer: {\n                x: bounds.left,\n                y: bounds.top,\n                w: width,\n                h: height,\n                radius\n            },\n            inner: {\n                x: bounds.left + border.l,\n                y: bounds.top + border.t,\n                w: width - border.l - border.r,\n                h: height - border.t - border.b,\n                radius: {\n                    topLeft: Math.max(0, radius.topLeft - Math.max(border.t, border.l)),\n                    topRight: Math.max(0, radius.topRight - Math.max(border.t, border.r)),\n                    bottomLeft: Math.max(0, radius.bottomLeft - Math.max(border.b, border.l)),\n                    bottomRight: Math.max(0, radius.bottomRight - Math.max(border.b, border.r)),\n                }\n            }\n        };\n    }\n    function inRange(bar, x, y, useFinalPosition) {\n        const skipX = x === null;\n        const skipY = y === null;\n        const skipBoth = skipX && skipY;\n        const bounds = bar && !skipBoth && getBarBounds(bar, useFinalPosition);\n        return bounds\n            && (skipX || x >= bounds.left && x <= bounds.right)\n            && (skipY || y >= bounds.top && y <= bounds.bottom);\n    }\n    function hasRadius(radius) {\n        return radius.topLeft || radius.topRight || radius.bottomLeft || radius.bottomRight;\n    }\n    function addNormalRectPath(ctx, rect) {\n        ctx.rect(rect.x, rect.y, rect.w, rect.h);\n    }\n    class BarElement extends Element {\n        constructor(cfg) {\n            super();\n            this.options = undefined;\n            this.horizontal = undefined;\n            this.base = undefined;\n            this.width = undefined;\n            this.height = undefined;\n            if (cfg) {\n                Object.assign(this, cfg);\n            }\n        }\n        draw(ctx) {\n            const options = this.options;\n            const {inner, outer} = boundingRects(this);\n            const addRectPath = hasRadius(outer.radius) ? addRoundedRectPath : addNormalRectPath;\n            ctx.save();\n            if (outer.w !== inner.w || outer.h !== inner.h) {\n                ctx.beginPath();\n                addRectPath(ctx, outer);\n                ctx.clip();\n                addRectPath(ctx, inner);\n                ctx.fillStyle = options.borderColor;\n                ctx.fill('evenodd');\n            }\n            ctx.beginPath();\n            addRectPath(ctx, inner);\n            ctx.fillStyle = options.backgroundColor;\n            ctx.fill();\n            ctx.restore();\n        }\n        inRange(mouseX, mouseY, useFinalPosition) {\n            return inRange(this, mouseX, mouseY, useFinalPosition);\n        }\n        inXRange(mouseX, useFinalPosition) {\n            return inRange(this, mouseX, null, useFinalPosition);\n        }\n        inYRange(mouseY, useFinalPosition) {\n            return inRange(this, null, mouseY, useFinalPosition);\n        }\n        getCenterPoint(useFinalPosition) {\n            const {x, y, base, horizontal} = this.getProps(['x', 'y', 'base', 'horizontal'], useFinalPosition);\n            return {\n                x: horizontal ? (x + base) / 2 : x,\n                y: horizontal ? y : (y + base) / 2\n            };\n        }\n        getRange(axis) {\n            return axis === 'x' ? this.width / 2 : this.height / 2;\n        }\n    }\n    BarElement.id = 'bar';\n    BarElement.defaults = {\n        borderSkipped: 'start',\n        borderWidth: 0,\n        borderRadius: 0,\n        enableBorderRadius: true,\n        pointStyle: undefined\n    };\n    BarElement.defaultRoutes = {\n        backgroundColor: 'backgroundColor',\n        borderColor: 'borderColor'\n    };\n\n    var elements = /*#__PURE__*/Object.freeze({\n        __proto__: null,\n        ArcElement: ArcElement,\n        LineElement: LineElement,\n        PointElement: PointElement,\n        BarElement: BarElement\n    });\n\n    function lttbDecimation(data, start, count, availableWidth, options) {\n        const samples = options.samples || availableWidth;\n        if (samples >= count) {\n            return data.slice(start, start + count);\n        }\n        const decimated = [];\n        const bucketWidth = (count - 2) / (samples - 2);\n        let sampledIndex = 0;\n        const endIndex = start + count - 1;\n        let a = start;\n        let i, maxAreaPoint, maxArea, area, nextA;\n        decimated[sampledIndex++] = data[a];\n        for (i = 0; i < samples - 2; i++) {\n            let avgX = 0;\n            let avgY = 0;\n            let j;\n            const avgRangeStart = Math.floor((i + 1) * bucketWidth) + 1 + start;\n            const avgRangeEnd = Math.min(Math.floor((i + 2) * bucketWidth) + 1, count) + start;\n            const avgRangeLength = avgRangeEnd - avgRangeStart;\n            for (j = avgRangeStart; j < avgRangeEnd; j++) {\n                avgX += data[j].x;\n                avgY += data[j].y;\n            }\n            avgX /= avgRangeLength;\n            avgY /= avgRangeLength;\n            const rangeOffs = Math.floor(i * bucketWidth) + 1 + start;\n            const rangeTo = Math.floor((i + 1) * bucketWidth) + 1 + start;\n            const {x: pointAx, y: pointAy} = data[a];\n            maxArea = area = -1;\n            for (j = rangeOffs; j < rangeTo; j++) {\n                area = 0.5 * Math.abs(\n                    (pointAx - avgX) * (data[j].y - pointAy) -\n                    (pointAx - data[j].x) * (avgY - pointAy)\n                );\n                if (area > maxArea) {\n                    maxArea = area;\n                    maxAreaPoint = data[j];\n                    nextA = j;\n                }\n            }\n            decimated[sampledIndex++] = maxAreaPoint;\n            a = nextA;\n        }\n        decimated[sampledIndex++] = data[endIndex];\n        return decimated;\n    }\n    function minMaxDecimation(data, start, count, availableWidth) {\n        let avgX = 0;\n        let countX = 0;\n        let i, point, x, y, prevX, minIndex, maxIndex, startIndex, minY, maxY;\n        const decimated = [];\n        const endIndex = start + count - 1;\n        const xMin = data[start].x;\n        const xMax = data[endIndex].x;\n        const dx = xMax - xMin;\n        for (i = start; i < start + count; ++i) {\n            point = data[i];\n            x = (point.x - xMin) / dx * availableWidth;\n            y = point.y;\n            const truncX = x | 0;\n            if (truncX === prevX) {\n                if (y < minY) {\n                    minY = y;\n                    minIndex = i;\n                } else if (y > maxY) {\n                    maxY = y;\n                    maxIndex = i;\n                }\n                avgX = (countX * avgX + point.x) / ++countX;\n            } else {\n                const lastIndex = i - 1;\n                if (!isNullOrUndef(minIndex) && !isNullOrUndef(maxIndex)) {\n                    const intermediateIndex1 = Math.min(minIndex, maxIndex);\n                    const intermediateIndex2 = Math.max(minIndex, maxIndex);\n                    if (intermediateIndex1 !== startIndex && intermediateIndex1 !== lastIndex) {\n                        decimated.push({\n                            ...data[intermediateIndex1],\n                            x: avgX,\n                        });\n                    }\n                    if (intermediateIndex2 !== startIndex && intermediateIndex2 !== lastIndex) {\n                        decimated.push({\n                            ...data[intermediateIndex2],\n                            x: avgX\n                        });\n                    }\n                }\n                if (i > 0 && lastIndex !== startIndex) {\n                    decimated.push(data[lastIndex]);\n                }\n                decimated.push(point);\n                prevX = truncX;\n                countX = 0;\n                minY = maxY = y;\n                minIndex = maxIndex = startIndex = i;\n            }\n        }\n        return decimated;\n    }\n    function cleanDecimatedDataset(dataset) {\n        if (dataset._decimated) {\n            const data = dataset._data;\n            delete dataset._decimated;\n            delete dataset._data;\n            Object.defineProperty(dataset, 'data', {value: data});\n        }\n    }\n    function cleanDecimatedData(chart) {\n        chart.data.datasets.forEach((dataset) => {\n            cleanDecimatedDataset(dataset);\n        });\n    }\n    function getStartAndCountOfVisiblePointsSimplified(meta, points) {\n        const pointCount = points.length;\n        let start = 0;\n        let count;\n        const {iScale} = meta;\n        const {min, max, minDefined, maxDefined} = iScale.getUserBounds();\n        if (minDefined) {\n            start = _limitValue(_lookupByKey(points, iScale.axis, min).lo, 0, pointCount - 1);\n        }\n        if (maxDefined) {\n            count = _limitValue(_lookupByKey(points, iScale.axis, max).hi + 1, start, pointCount) - start;\n        } else {\n            count = pointCount - start;\n        }\n        return {start, count};\n    }\n    var plugin_decimation = {\n        id: 'decimation',\n        defaults: {\n            algorithm: 'min-max',\n            enabled: false,\n        },\n        beforeElementsUpdate: (chart, args, options) => {\n            if (!options.enabled) {\n                cleanDecimatedData(chart);\n                return;\n            }\n            const availableWidth = chart.width;\n            chart.data.datasets.forEach((dataset, datasetIndex) => {\n                const {_data, indexAxis} = dataset;\n                const meta = chart.getDatasetMeta(datasetIndex);\n                const data = _data || dataset.data;\n                if (resolve([indexAxis, chart.options.indexAxis]) === 'y') {\n                    return;\n                }\n                if (meta.type !== 'line') {\n                    return;\n                }\n                const xAxis = chart.scales[meta.xAxisID];\n                if (xAxis.type !== 'linear' && xAxis.type !== 'time') {\n                    return;\n                }\n                if (chart.options.parsing) {\n                    return;\n                }\n                let {start, count} = getStartAndCountOfVisiblePointsSimplified(meta, data);\n                if (count <= 4 * availableWidth) {\n                    cleanDecimatedDataset(dataset);\n                    return;\n                }\n                if (isNullOrUndef(_data)) {\n                    dataset._data = data;\n                    delete dataset.data;\n                    Object.defineProperty(dataset, 'data', {\n                        configurable: true,\n                        enumerable: true,\n                        get: function() {\n                            return this._decimated;\n                        },\n                        set: function(d) {\n                            this._data = d;\n                        }\n                    });\n                }\n                let decimated;\n                switch (options.algorithm) {\n                    case 'lttb':\n                        decimated = lttbDecimation(data, start, count, availableWidth, options);\n                        break;\n                    case 'min-max':\n                        decimated = minMaxDecimation(data, start, count, availableWidth);\n                        break;\n                    default:\n                        throw new Error(`Unsupported decimation algorithm '${options.algorithm}'`);\n                }\n                dataset._decimated = decimated;\n            });\n        },\n        destroy(chart) {\n            cleanDecimatedData(chart);\n        }\n    };\n\n    function getLineByIndex(chart, index) {\n        const meta = chart.getDatasetMeta(index);\n        const visible = meta && chart.isDatasetVisible(index);\n        return visible ? meta.dataset : null;\n    }\n    function parseFillOption(line) {\n        const options = line.options;\n        const fillOption = options.fill;\n        let fill = valueOrDefault(fillOption && fillOption.target, fillOption);\n        if (fill === undefined) {\n            fill = !!options.backgroundColor;\n        }\n        if (fill === false || fill === null) {\n            return false;\n        }\n        if (fill === true) {\n            return 'origin';\n        }\n        return fill;\n    }\n    function decodeFill(line, index, count) {\n        const fill = parseFillOption(line);\n        if (isObject(fill)) {\n            return isNaN(fill.value) ? false : fill;\n        }\n        let target = parseFloat(fill);\n        if (isNumberFinite(target) && Math.floor(target) === target) {\n            if (fill[0] === '-' || fill[0] === '+') {\n                target = index + target;\n            }\n            if (target === index || target < 0 || target >= count) {\n                return false;\n            }\n            return target;\n        }\n        return ['origin', 'start', 'end', 'stack'].indexOf(fill) >= 0 && fill;\n    }\n    function computeLinearBoundary(source) {\n        const {scale = {}, fill} = source;\n        let target = null;\n        let horizontal;\n        if (fill === 'start') {\n            target = scale.bottom;\n        } else if (fill === 'end') {\n            target = scale.top;\n        } else if (isObject(fill)) {\n            target = scale.getPixelForValue(fill.value);\n        } else if (scale.getBasePixel) {\n            target = scale.getBasePixel();\n        }\n        if (isNumberFinite(target)) {\n            horizontal = scale.isHorizontal();\n            return {\n                x: horizontal ? target : null,\n                y: horizontal ? null : target\n            };\n        }\n        return null;\n    }\n    class simpleArc {\n        constructor(opts) {\n            this.x = opts.x;\n            this.y = opts.y;\n            this.radius = opts.radius;\n        }\n        pathSegment(ctx, bounds, opts) {\n            const {x, y, radius} = this;\n            bounds = bounds || {start: 0, end: TAU};\n            ctx.arc(x, y, radius, bounds.end, bounds.start, true);\n            return !opts.bounds;\n        }\n        interpolate(point) {\n            const {x, y, radius} = this;\n            const angle = point.angle;\n            return {\n                x: x + Math.cos(angle) * radius,\n                y: y + Math.sin(angle) * radius,\n                angle\n            };\n        }\n    }\n    function computeCircularBoundary(source) {\n        const {scale, fill} = source;\n        const options = scale.options;\n        const length = scale.getLabels().length;\n        const target = [];\n        const start = options.reverse ? scale.max : scale.min;\n        const end = options.reverse ? scale.min : scale.max;\n        let i, center, value;\n        if (fill === 'start') {\n            value = start;\n        } else if (fill === 'end') {\n            value = end;\n        } else if (isObject(fill)) {\n            value = fill.value;\n        } else {\n            value = scale.getBaseValue();\n        }\n        if (options.grid.circular) {\n            center = scale.getPointPositionForValue(0, start);\n            return new simpleArc({\n                x: center.x,\n                y: center.y,\n                radius: scale.getDistanceFromCenterForValue(value)\n            });\n        }\n        for (i = 0; i < length; ++i) {\n            target.push(scale.getPointPositionForValue(i, value));\n        }\n        return target;\n    }\n    function computeBoundary(source) {\n        const scale = source.scale || {};\n        if (scale.getPointPositionForValue) {\n            return computeCircularBoundary(source);\n        }\n        return computeLinearBoundary(source);\n    }\n    function pointsFromSegments(boundary, line) {\n        const {x = null, y = null} = boundary || {};\n        const linePoints = line.points;\n        const points = [];\n        line.segments.forEach((segment) => {\n            const first = linePoints[segment.start];\n            const last = linePoints[segment.end];\n            if (y !== null) {\n                points.push({x: first.x, y});\n                points.push({x: last.x, y});\n            } else if (x !== null) {\n                points.push({x, y: first.y});\n                points.push({x, y: last.y});\n            }\n        });\n        return points;\n    }\n    function buildStackLine(source) {\n        const {chart, scale, index, line} = source;\n        const points = [];\n        const segments = line.segments;\n        const sourcePoints = line.points;\n        const linesBelow = getLinesBelow(chart, index);\n        linesBelow.push(createBoundaryLine({x: null, y: scale.bottom}, line));\n        for (let i = 0; i < segments.length; i++) {\n            const segment = segments[i];\n            for (let j = segment.start; j <= segment.end; j++) {\n                addPointsBelow(points, sourcePoints[j], linesBelow);\n            }\n        }\n        return new LineElement({points, options: {}});\n    }\n    const isLineAndNotInHideAnimation = (meta) => meta.type === 'line' && !meta.hidden;\n    function getLinesBelow(chart, index) {\n        const below = [];\n        const metas = chart.getSortedVisibleDatasetMetas();\n        for (let i = 0; i < metas.length; i++) {\n            const meta = metas[i];\n            if (meta.index === index) {\n                break;\n            }\n            if (isLineAndNotInHideAnimation(meta)) {\n                below.unshift(meta.dataset);\n            }\n        }\n        return below;\n    }\n    function addPointsBelow(points, sourcePoint, linesBelow) {\n        const postponed = [];\n        for (let j = 0; j < linesBelow.length; j++) {\n            const line = linesBelow[j];\n            const {first, last, point} = findPoint(line, sourcePoint, 'x');\n            if (!point || (first && last)) {\n                continue;\n            }\n            if (first) {\n                postponed.unshift(point);\n            } else {\n                points.push(point);\n                if (!last) {\n                    break;\n                }\n            }\n        }\n        points.push(...postponed);\n    }\n    function findPoint(line, sourcePoint, property) {\n        const point = line.interpolate(sourcePoint, property);\n        if (!point) {\n            return {};\n        }\n        const pointValue = point[property];\n        const segments = line.segments;\n        const linePoints = line.points;\n        let first = false;\n        let last = false;\n        for (let i = 0; i < segments.length; i++) {\n            const segment = segments[i];\n            const firstValue = linePoints[segment.start][property];\n            const lastValue = linePoints[segment.end][property];\n            if (pointValue >= firstValue && pointValue <= lastValue) {\n                first = pointValue === firstValue;\n                last = pointValue === lastValue;\n                break;\n            }\n        }\n        return {first, last, point};\n    }\n    function getTarget(source) {\n        const {chart, fill, line} = source;\n        if (isNumberFinite(fill)) {\n            return getLineByIndex(chart, fill);\n        }\n        if (fill === 'stack') {\n            return buildStackLine(source);\n        }\n        const boundary = computeBoundary(source);\n        if (boundary instanceof simpleArc) {\n            return boundary;\n        }\n        return createBoundaryLine(boundary, line);\n    }\n    function createBoundaryLine(boundary, line) {\n        let points = [];\n        let _loop = false;\n        if (isArray(boundary)) {\n            _loop = true;\n            points = boundary;\n        } else {\n            points = pointsFromSegments(boundary, line);\n        }\n        return points.length ? new LineElement({\n            points,\n            options: {tension: 0},\n            _loop,\n            _fullLoop: _loop\n        }) : null;\n    }\n    function resolveTarget(sources, index, propagate) {\n        const source = sources[index];\n        let fill = source.fill;\n        const visited = [index];\n        let target;\n        if (!propagate) {\n            return fill;\n        }\n        while (fill !== false && visited.indexOf(fill) === -1) {\n            if (!isNumberFinite(fill)) {\n                return fill;\n            }\n            target = sources[fill];\n            if (!target) {\n                return false;\n            }\n            if (target.visible) {\n                return fill;\n            }\n            visited.push(fill);\n            fill = target.fill;\n        }\n        return false;\n    }\n    function _clip(ctx, target, clipY) {\n        ctx.beginPath();\n        target.path(ctx);\n        ctx.lineTo(target.last().x, clipY);\n        ctx.lineTo(target.first().x, clipY);\n        ctx.closePath();\n        ctx.clip();\n    }\n    function getBounds(property, first, last, loop) {\n        if (loop) {\n            return;\n        }\n        let start = first[property];\n        let end = last[property];\n        if (property === 'angle') {\n            start = _normalizeAngle(start);\n            end = _normalizeAngle(end);\n        }\n        return {property, start, end};\n    }\n    function _getEdge(a, b, prop, fn) {\n        if (a && b) {\n            return fn(a[prop], b[prop]);\n        }\n        return a ? a[prop] : b ? b[prop] : 0;\n    }\n    function _segments(line, target, property) {\n        const segments = line.segments;\n        const points = line.points;\n        const tpoints = target.points;\n        const parts = [];\n        for (const segment of segments) {\n            const bounds = getBounds(property, points[segment.start], points[segment.end], segment.loop);\n            if (!target.segments) {\n                parts.push({\n                    source: segment,\n                    target: bounds,\n                    start: points[segment.start],\n                    end: points[segment.end]\n                });\n                continue;\n            }\n            const targetSegments = _boundSegments(target, bounds);\n            for (const tgt of targetSegments) {\n                const subBounds = getBounds(property, tpoints[tgt.start], tpoints[tgt.end], tgt.loop);\n                const fillSources = _boundSegment(segment, points, subBounds);\n                for (const fillSource of fillSources) {\n                    parts.push({\n                        source: fillSource,\n                        target: tgt,\n                        start: {\n                            [property]: _getEdge(bounds, subBounds, 'start', Math.max)\n                        },\n                        end: {\n                            [property]: _getEdge(bounds, subBounds, 'end', Math.min)\n                        }\n                    });\n                }\n            }\n        }\n        return parts;\n    }\n    function clipBounds(ctx, scale, bounds) {\n        const {top, bottom} = scale.chart.chartArea;\n        const {property, start, end} = bounds || {};\n        if (property === 'x') {\n            ctx.beginPath();\n            ctx.rect(start, top, end - start, bottom - top);\n            ctx.clip();\n        }\n    }\n    function interpolatedLineTo(ctx, target, point, property) {\n        const interpolatedPoint = target.interpolate(point, property);\n        if (interpolatedPoint) {\n            ctx.lineTo(interpolatedPoint.x, interpolatedPoint.y);\n        }\n    }\n    function _fill(ctx, cfg) {\n        const {line, target, property, color, scale} = cfg;\n        const segments = _segments(line, target, property);\n        for (const {source: src, target: tgt, start, end} of segments) {\n            const {style: {backgroundColor = color} = {}} = src;\n            ctx.save();\n            ctx.fillStyle = backgroundColor;\n            clipBounds(ctx, scale, getBounds(property, start, end));\n            ctx.beginPath();\n            const lineLoop = !!line.pathSegment(ctx, src);\n            if (lineLoop) {\n                ctx.closePath();\n            } else {\n                interpolatedLineTo(ctx, target, end, property);\n            }\n            const targetLoop = !!target.pathSegment(ctx, tgt, {move: lineLoop, reverse: true});\n            const loop = lineLoop && targetLoop;\n            if (!loop) {\n                interpolatedLineTo(ctx, target, start, property);\n            }\n            ctx.closePath();\n            ctx.fill(loop ? 'evenodd' : 'nonzero');\n            ctx.restore();\n        }\n    }\n    function doFill(ctx, cfg) {\n        const {line, target, above, below, area, scale} = cfg;\n        const property = line._loop ? 'angle' : cfg.axis;\n        ctx.save();\n        if (property === 'x' && below !== above) {\n            _clip(ctx, target, area.top);\n            _fill(ctx, {line, target, color: above, scale, property});\n            ctx.restore();\n            ctx.save();\n            _clip(ctx, target, area.bottom);\n        }\n        _fill(ctx, {line, target, color: below, scale, property});\n        ctx.restore();\n    }\n    function drawfill(ctx, source, area) {\n        const target = getTarget(source);\n        const {line, scale, axis} = source;\n        const lineOpts = line.options;\n        const fillOption = lineOpts.fill;\n        const color = lineOpts.backgroundColor;\n        const {above = color, below = color} = fillOption || {};\n        if (target && line.points.length) {\n            clipArea(ctx, area);\n            doFill(ctx, {line, target, above, below, area, scale, axis});\n            unclipArea(ctx);\n        }\n    }\n    var plugin_filler = {\n        id: 'filler',\n        afterDatasetsUpdate(chart, _args, options) {\n            const count = (chart.data.datasets || []).length;\n            const sources = [];\n            let meta, i, line, source;\n            for (i = 0; i < count; ++i) {\n                meta = chart.getDatasetMeta(i);\n                line = meta.dataset;\n                source = null;\n                if (line && line.options && line instanceof LineElement) {\n                    source = {\n                        visible: chart.isDatasetVisible(i),\n                        index: i,\n                        fill: decodeFill(line, i, count),\n                        chart,\n                        axis: meta.controller.options.indexAxis,\n                        scale: meta.vScale,\n                        line,\n                    };\n                }\n                meta.$filler = source;\n                sources.push(source);\n            }\n            for (i = 0; i < count; ++i) {\n                source = sources[i];\n                if (!source || source.fill === false) {\n                    continue;\n                }\n                source.fill = resolveTarget(sources, i, options.propagate);\n            }\n        },\n        beforeDraw(chart, _args, options) {\n            const draw = options.drawTime === 'beforeDraw';\n            const metasets = chart.getSortedVisibleDatasetMetas();\n            const area = chart.chartArea;\n            for (let i = metasets.length - 1; i >= 0; --i) {\n                const source = metasets[i].$filler;\n                if (!source) {\n                    continue;\n                }\n                source.line.updateControlPoints(area, source.axis);\n                if (draw) {\n                    drawfill(chart.ctx, source, area);\n                }\n            }\n        },\n        beforeDatasetsDraw(chart, _args, options) {\n            if (options.drawTime !== 'beforeDatasetsDraw') {\n                return;\n            }\n            const metasets = chart.getSortedVisibleDatasetMetas();\n            for (let i = metasets.length - 1; i >= 0; --i) {\n                const source = metasets[i].$filler;\n                if (source) {\n                    drawfill(chart.ctx, source, chart.chartArea);\n                }\n            }\n        },\n        beforeDatasetDraw(chart, args, options) {\n            const source = args.meta.$filler;\n            if (!source || source.fill === false || options.drawTime !== 'beforeDatasetDraw') {\n                return;\n            }\n            drawfill(chart.ctx, source, chart.chartArea);\n        },\n        defaults: {\n            propagate: true,\n            drawTime: 'beforeDatasetDraw'\n        }\n    };\n\n    const getBoxSize = (labelOpts, fontSize) => {\n        let {boxHeight = fontSize, boxWidth = fontSize} = labelOpts;\n        if (labelOpts.usePointStyle) {\n            boxHeight = Math.min(boxHeight, fontSize);\n            boxWidth = Math.min(boxWidth, fontSize);\n        }\n        return {\n            boxWidth,\n            boxHeight,\n            itemHeight: Math.max(fontSize, boxHeight)\n        };\n    };\n    const itemsEqual = (a, b) => a !== null && b !== null && a.datasetIndex === b.datasetIndex && a.index === b.index;\n    class Legend extends Element {\n        constructor(config) {\n            super();\n            this._added = false;\n            this.legendHitBoxes = [];\n            this._hoveredItem = null;\n            this.doughnutMode = false;\n            this.chart = config.chart;\n            this.options = config.options;\n            this.ctx = config.ctx;\n            this.legendItems = undefined;\n            this.columnSizes = undefined;\n            this.lineWidths = undefined;\n            this.maxHeight = undefined;\n            this.maxWidth = undefined;\n            this.top = undefined;\n            this.bottom = undefined;\n            this.left = undefined;\n            this.right = undefined;\n            this.height = undefined;\n            this.width = undefined;\n            this._margins = undefined;\n            this.position = undefined;\n            this.weight = undefined;\n            this.fullSize = undefined;\n        }\n        update(maxWidth, maxHeight, margins) {\n            const me = this;\n            me.maxWidth = maxWidth;\n            me.maxHeight = maxHeight;\n            me._margins = margins;\n            me.setDimensions();\n            me.buildLabels();\n            me.fit();\n        }\n        setDimensions() {\n            const me = this;\n            if (me.isHorizontal()) {\n                me.width = me.maxWidth;\n                me.left = 0;\n                me.right = me.width;\n            } else {\n                me.height = me.maxHeight;\n                me.top = 0;\n                me.bottom = me.height;\n            }\n        }\n        buildLabels() {\n            const me = this;\n            const labelOpts = me.options.labels || {};\n            let legendItems = callback(labelOpts.generateLabels, [me.chart], me) || [];\n            if (labelOpts.filter) {\n                legendItems = legendItems.filter((item) => labelOpts.filter(item, me.chart.data));\n            }\n            if (labelOpts.sort) {\n                legendItems = legendItems.sort((a, b) => labelOpts.sort(a, b, me.chart.data));\n            }\n            if (me.options.reverse) {\n                legendItems.reverse();\n            }\n            me.legendItems = legendItems;\n        }\n        fit() {\n            const me = this;\n            const {options, ctx} = me;\n            if (!options.display) {\n                me.width = me.height = 0;\n                return;\n            }\n            const labelOpts = options.labels;\n            const labelFont = toFont(labelOpts.font);\n            const fontSize = labelFont.size;\n            const titleHeight = me._computeTitleHeight();\n            const {boxWidth, itemHeight} = getBoxSize(labelOpts, fontSize);\n            let width, height;\n            ctx.font = labelFont.string;\n            if (me.isHorizontal()) {\n                width = me.maxWidth;\n                height = me._fitRows(titleHeight, fontSize, boxWidth, itemHeight) + 10;\n            } else {\n                height = me.maxHeight;\n                width = me._fitCols(titleHeight, fontSize, boxWidth, itemHeight) + 10;\n            }\n            me.width = Math.min(width, options.maxWidth || me.maxWidth);\n            me.height = Math.min(height, options.maxHeight || me.maxHeight);\n        }\n        _fitRows(titleHeight, fontSize, boxWidth, itemHeight) {\n            const me = this;\n            const {ctx, maxWidth, options: {labels: {padding}}} = me;\n            const hitboxes = me.legendHitBoxes = [];\n            const lineWidths = me.lineWidths = [0];\n            const lineHeight = itemHeight + padding;\n            let totalHeight = titleHeight;\n            ctx.textAlign = 'left';\n            ctx.textBaseline = 'middle';\n            let row = -1;\n            let top = -lineHeight;\n            me.legendItems.forEach((legendItem, i) => {\n                const itemWidth = boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;\n                if (i === 0 || lineWidths[lineWidths.length - 1] + itemWidth + 2 * padding > maxWidth) {\n                    totalHeight += lineHeight;\n                    lineWidths[lineWidths.length - (i > 0 ? 0 : 1)] = 0;\n                    top += lineHeight;\n                    row++;\n                }\n                hitboxes[i] = {left: 0, top, row, width: itemWidth, height: itemHeight};\n                lineWidths[lineWidths.length - 1] += itemWidth + padding;\n            });\n            return totalHeight;\n        }\n        _fitCols(titleHeight, fontSize, boxWidth, itemHeight) {\n            const me = this;\n            const {ctx, maxHeight, options: {labels: {padding}}} = me;\n            const hitboxes = me.legendHitBoxes = [];\n            const columnSizes = me.columnSizes = [];\n            const heightLimit = maxHeight - titleHeight;\n            let totalWidth = padding;\n            let currentColWidth = 0;\n            let currentColHeight = 0;\n            let left = 0;\n            let top = 0;\n            let col = 0;\n            me.legendItems.forEach((legendItem, i) => {\n                const itemWidth = boxWidth + (fontSize / 2) + ctx.measureText(legendItem.text).width;\n                if (i > 0 && currentColHeight + fontSize + 2 * padding > heightLimit) {\n                    totalWidth += currentColWidth + padding;\n                    columnSizes.push({width: currentColWidth, height: currentColHeight});\n                    left += currentColWidth + padding;\n                    col++;\n                    top = 0;\n                    currentColWidth = currentColHeight = 0;\n                }\n                currentColWidth = Math.max(currentColWidth, itemWidth);\n                currentColHeight += fontSize + padding;\n                hitboxes[i] = {left, top, col, width: itemWidth, height: itemHeight};\n                top += itemHeight + padding;\n            });\n            totalWidth += currentColWidth;\n            columnSizes.push({width: currentColWidth, height: currentColHeight});\n            return totalWidth;\n        }\n        adjustHitBoxes() {\n            const me = this;\n            if (!me.options.display) {\n                return;\n            }\n            const titleHeight = me._computeTitleHeight();\n            const {legendHitBoxes: hitboxes, options: {align, labels: {padding}}} = me;\n            if (this.isHorizontal()) {\n                let row = 0;\n                let left = _alignStartEnd(align, me.left + padding, me.right - me.lineWidths[row]);\n                for (const hitbox of hitboxes) {\n                    if (row !== hitbox.row) {\n                        row = hitbox.row;\n                        left = _alignStartEnd(align, me.left + padding, me.right - me.lineWidths[row]);\n                    }\n                    hitbox.top += me.top + titleHeight + padding;\n                    hitbox.left = left;\n                    left += hitbox.width + padding;\n                }\n            } else {\n                let col = 0;\n                let top = _alignStartEnd(align, me.top + titleHeight + padding, me.bottom - me.columnSizes[col].height);\n                for (const hitbox of hitboxes) {\n                    if (hitbox.col !== col) {\n                        col = hitbox.col;\n                        top = _alignStartEnd(align, me.top + titleHeight + padding, me.bottom - me.columnSizes[col].height);\n                    }\n                    hitbox.top = top;\n                    hitbox.left += me.left + padding;\n                    top += hitbox.height + padding;\n                }\n            }\n        }\n        isHorizontal() {\n            return this.options.position === 'top' || this.options.position === 'bottom';\n        }\n        draw() {\n            const me = this;\n            if (me.options.display) {\n                const ctx = me.ctx;\n                clipArea(ctx, me);\n                me._draw();\n                unclipArea(ctx);\n            }\n        }\n        _draw() {\n            const me = this;\n            const {options: opts, columnSizes, lineWidths, ctx} = me;\n            const {align, labels: labelOpts} = opts;\n            const defaultColor = defaults.color;\n            const rtlHelper = getRtlAdapter(opts.rtl, me.left, me.width);\n            const labelFont = toFont(labelOpts.font);\n            const {color: fontColor, padding} = labelOpts;\n            const fontSize = labelFont.size;\n            const halfFontSize = fontSize / 2;\n            let cursor;\n            me.drawTitle();\n            ctx.textAlign = rtlHelper.textAlign('left');\n            ctx.textBaseline = 'middle';\n            ctx.lineWidth = 0.5;\n            ctx.font = labelFont.string;\n            const {boxWidth, boxHeight, itemHeight} = getBoxSize(labelOpts, fontSize);\n            const drawLegendBox = function(x, y, legendItem) {\n                if (isNaN(boxWidth) || boxWidth <= 0 || isNaN(boxHeight) || boxHeight < 0) {\n                    return;\n                }\n                ctx.save();\n                const lineWidth = valueOrDefault(legendItem.lineWidth, 1);\n                ctx.fillStyle = valueOrDefault(legendItem.fillStyle, defaultColor);\n                ctx.lineCap = valueOrDefault(legendItem.lineCap, 'butt');\n                ctx.lineDashOffset = valueOrDefault(legendItem.lineDashOffset, 0);\n                ctx.lineJoin = valueOrDefault(legendItem.lineJoin, 'miter');\n                ctx.lineWidth = lineWidth;\n                ctx.strokeStyle = valueOrDefault(legendItem.strokeStyle, defaultColor);\n                ctx.setLineDash(valueOrDefault(legendItem.lineDash, []));\n                if (labelOpts.usePointStyle) {\n                    const drawOptions = {\n                        radius: boxWidth * Math.SQRT2 / 2,\n                        pointStyle: legendItem.pointStyle,\n                        rotation: legendItem.rotation,\n                        borderWidth: lineWidth\n                    };\n                    const centerX = rtlHelper.xPlus(x, boxWidth / 2);\n                    const centerY = y + halfFontSize;\n                    drawPoint(ctx, drawOptions, centerX, centerY);\n                } else {\n                    const yBoxTop = y + Math.max((fontSize - boxHeight) / 2, 0);\n                    const xBoxLeft = rtlHelper.leftForLtr(x, boxWidth);\n                    const borderRadius = toTRBLCorners(legendItem.borderRadius);\n                    ctx.beginPath();\n                    if (Object.values(borderRadius).some(v => v !== 0)) {\n                        addRoundedRectPath(ctx, {\n                            x: xBoxLeft,\n                            y: yBoxTop,\n                            w: boxWidth,\n                            h: boxHeight,\n                            radius: borderRadius,\n                        });\n                    } else {\n                        ctx.rect(xBoxLeft, yBoxTop, boxWidth, boxHeight);\n                    }\n                    ctx.fill();\n                    if (lineWidth !== 0) {\n                        ctx.stroke();\n                    }\n                }\n                ctx.restore();\n            };\n            const fillText = function(x, y, legendItem) {\n                renderText(ctx, legendItem.text, x, y + (itemHeight / 2), labelFont, {\n                    strikethrough: legendItem.hidden,\n                    textAlign: legendItem.textAlign\n                });\n            };\n            const isHorizontal = me.isHorizontal();\n            const titleHeight = this._computeTitleHeight();\n            if (isHorizontal) {\n                cursor = {\n                    x: _alignStartEnd(align, me.left + padding, me.right - lineWidths[0]),\n                    y: me.top + padding + titleHeight,\n                    line: 0\n                };\n            } else {\n                cursor = {\n                    x: me.left + padding,\n                    y: _alignStartEnd(align, me.top + titleHeight + padding, me.bottom - columnSizes[0].height),\n                    line: 0\n                };\n            }\n            overrideTextDirection(me.ctx, opts.textDirection);\n            const lineHeight = itemHeight + padding;\n            me.legendItems.forEach((legendItem, i) => {\n                ctx.strokeStyle = legendItem.fontColor || fontColor;\n                ctx.fillStyle = legendItem.fontColor || fontColor;\n                const textWidth = ctx.measureText(legendItem.text).width;\n                const textAlign = rtlHelper.textAlign(legendItem.textAlign || (legendItem.textAlign = labelOpts.textAlign));\n                const width = boxWidth + (fontSize / 2) + textWidth;\n                let x = cursor.x;\n                let y = cursor.y;\n                rtlHelper.setWidth(me.width);\n                if (isHorizontal) {\n                    if (i > 0 && x + width + padding > me.right) {\n                        y = cursor.y += lineHeight;\n                        cursor.line++;\n                        x = cursor.x = _alignStartEnd(align, me.left + padding, me.right - lineWidths[cursor.line]);\n                    }\n                } else if (i > 0 && y + lineHeight > me.bottom) {\n                    x = cursor.x = x + columnSizes[cursor.line].width + padding;\n                    cursor.line++;\n                    y = cursor.y = _alignStartEnd(align, me.top + titleHeight + padding, me.bottom - columnSizes[cursor.line].height);\n                }\n                const realX = rtlHelper.x(x);\n                drawLegendBox(realX, y, legendItem);\n                x = _textX(textAlign, x + boxWidth + halfFontSize, me.right);\n                fillText(rtlHelper.x(x), y, legendItem);\n                if (isHorizontal) {\n                    cursor.x += width + padding;\n                } else {\n                    cursor.y += lineHeight;\n                }\n            });\n            restoreTextDirection(me.ctx, opts.textDirection);\n        }\n        drawTitle() {\n            const me = this;\n            const opts = me.options;\n            const titleOpts = opts.title;\n            const titleFont = toFont(titleOpts.font);\n            const titlePadding = toPadding(titleOpts.padding);\n            if (!titleOpts.display) {\n                return;\n            }\n            const rtlHelper = getRtlAdapter(opts.rtl, me.left, me.width);\n            const ctx = me.ctx;\n            const position = titleOpts.position;\n            const halfFontSize = titleFont.size / 2;\n            const topPaddingPlusHalfFontSize = titlePadding.top + halfFontSize;\n            let y;\n            let left = me.left;\n            let maxWidth = me.width;\n            if (this.isHorizontal()) {\n                maxWidth = Math.max(...me.lineWidths);\n                y = me.top + topPaddingPlusHalfFontSize;\n                left = _alignStartEnd(opts.align, left, me.right - maxWidth);\n            } else {\n                const maxHeight = me.columnSizes.reduce((acc, size) => Math.max(acc, size.height), 0);\n                y = topPaddingPlusHalfFontSize + _alignStartEnd(opts.align, me.top, me.bottom - maxHeight - opts.labels.padding - me._computeTitleHeight());\n            }\n            const x = _alignStartEnd(position, left, left + maxWidth);\n            ctx.textAlign = rtlHelper.textAlign(_toLeftRightCenter(position));\n            ctx.textBaseline = 'middle';\n            ctx.strokeStyle = titleOpts.color;\n            ctx.fillStyle = titleOpts.color;\n            ctx.font = titleFont.string;\n            renderText(ctx, titleOpts.text, x, y, titleFont);\n        }\n        _computeTitleHeight() {\n            const titleOpts = this.options.title;\n            const titleFont = toFont(titleOpts.font);\n            const titlePadding = toPadding(titleOpts.padding);\n            return titleOpts.display ? titleFont.lineHeight + titlePadding.height : 0;\n        }\n        _getLegendItemAt(x, y) {\n            const me = this;\n            let i, hitBox, lh;\n            if (x >= me.left && x <= me.right && y >= me.top && y <= me.bottom) {\n                lh = me.legendHitBoxes;\n                for (i = 0; i < lh.length; ++i) {\n                    hitBox = lh[i];\n                    if (x >= hitBox.left && x <= hitBox.left + hitBox.width && y >= hitBox.top && y <= hitBox.top + hitBox.height) {\n                        return me.legendItems[i];\n                    }\n                }\n            }\n            return null;\n        }\n        handleEvent(e) {\n            const me = this;\n            const opts = me.options;\n            if (!isListened(e.type, opts)) {\n                return;\n            }\n            const hoveredItem = me._getLegendItemAt(e.x, e.y);\n            if (e.type === 'mousemove') {\n                const previous = me._hoveredItem;\n                const sameItem = itemsEqual(previous, hoveredItem);\n                if (previous && !sameItem) {\n                    callback(opts.onLeave, [e, previous, me], me);\n                }\n                me._hoveredItem = hoveredItem;\n                if (hoveredItem && !sameItem) {\n                    callback(opts.onHover, [e, hoveredItem, me], me);\n                }\n            } else if (hoveredItem) {\n                callback(opts.onClick, [e, hoveredItem, me], me);\n            }\n        }\n    }\n    function isListened(type, opts) {\n        if (type === 'mousemove' && (opts.onHover || opts.onLeave)) {\n            return true;\n        }\n        if (opts.onClick && (type === 'click' || type === 'mouseup')) {\n            return true;\n        }\n        return false;\n    }\n    var plugin_legend = {\n        id: 'legend',\n        _element: Legend,\n        start(chart, _args, options) {\n            const legend = chart.legend = new Legend({ctx: chart.ctx, options, chart});\n            layouts.configure(chart, legend, options);\n            layouts.addBox(chart, legend);\n        },\n        stop(chart) {\n            layouts.removeBox(chart, chart.legend);\n            delete chart.legend;\n        },\n        beforeUpdate(chart, _args, options) {\n            const legend = chart.legend;\n            layouts.configure(chart, legend, options);\n            legend.options = options;\n        },\n        afterUpdate(chart) {\n            const legend = chart.legend;\n            legend.buildLabels();\n            legend.adjustHitBoxes();\n        },\n        afterEvent(chart, args) {\n            if (!args.replay) {\n                chart.legend.handleEvent(args.event);\n            }\n        },\n        defaults: {\n            display: true,\n            position: 'top',\n            align: 'center',\n            fullSize: true,\n            reverse: false,\n            weight: 1000,\n            onClick(e, legendItem, legend) {\n                const index = legendItem.datasetIndex;\n                const ci = legend.chart;\n                if (ci.isDatasetVisible(index)) {\n                    ci.hide(index);\n                    legendItem.hidden = true;\n                } else {\n                    ci.show(index);\n                    legendItem.hidden = false;\n                }\n            },\n            onHover: null,\n            onLeave: null,\n            labels: {\n                color: (ctx) => ctx.chart.options.color,\n                boxWidth: 40,\n                padding: 10,\n                generateLabels(chart) {\n                    const datasets = chart.data.datasets;\n                    const {labels: {usePointStyle, pointStyle, textAlign, color}} = chart.legend.options;\n                    return chart._getSortedDatasetMetas().map((meta) => {\n                        const style = meta.controller.getStyle(usePointStyle ? 0 : undefined);\n                        const borderWidth = toPadding(style.borderWidth);\n                        return {\n                            text: datasets[meta.index].label,\n                            fillStyle: style.backgroundColor,\n                            fontColor: color,\n                            hidden: !meta.visible,\n                            lineCap: style.borderCapStyle,\n                            lineDash: style.borderDash,\n                            lineDashOffset: style.borderDashOffset,\n                            lineJoin: style.borderJoinStyle,\n                            lineWidth: (borderWidth.width + borderWidth.height) / 4,\n                            strokeStyle: style.borderColor,\n                            pointStyle: pointStyle || style.pointStyle,\n                            rotation: style.rotation,\n                            textAlign: textAlign || style.textAlign,\n                            borderRadius: 0,\n                            datasetIndex: meta.index\n                        };\n                    }, this);\n                }\n            },\n            title: {\n                color: (ctx) => ctx.chart.options.color,\n                display: false,\n                position: 'center',\n                text: '',\n            }\n        },\n        descriptors: {\n            _scriptable: (name) => !name.startsWith('on'),\n            labels: {\n                _scriptable: (name) => !['generateLabels', 'filter', 'sort'].includes(name),\n            }\n        },\n    };\n\n    class Title extends Element {\n        constructor(config) {\n            super();\n            this.chart = config.chart;\n            this.options = config.options;\n            this.ctx = config.ctx;\n            this._padding = undefined;\n            this.top = undefined;\n            this.bottom = undefined;\n            this.left = undefined;\n            this.right = undefined;\n            this.width = undefined;\n            this.height = undefined;\n            this.position = undefined;\n            this.weight = undefined;\n            this.fullSize = undefined;\n        }\n        update(maxWidth, maxHeight) {\n            const me = this;\n            const opts = me.options;\n            me.left = 0;\n            me.top = 0;\n            if (!opts.display) {\n                me.width = me.height = me.right = me.bottom = 0;\n                return;\n            }\n            me.width = me.right = maxWidth;\n            me.height = me.bottom = maxHeight;\n            const lineCount = isArray(opts.text) ? opts.text.length : 1;\n            me._padding = toPadding(opts.padding);\n            const textSize = lineCount * toFont(opts.font).lineHeight + me._padding.height;\n            if (me.isHorizontal()) {\n                me.height = textSize;\n            } else {\n                me.width = textSize;\n            }\n        }\n        isHorizontal() {\n            const pos = this.options.position;\n            return pos === 'top' || pos === 'bottom';\n        }\n        _drawArgs(offset) {\n            const {top, left, bottom, right, options} = this;\n            const align = options.align;\n            let rotation = 0;\n            let maxWidth, titleX, titleY;\n            if (this.isHorizontal()) {\n                titleX = _alignStartEnd(align, left, right);\n                titleY = top + offset;\n                maxWidth = right - left;\n            } else {\n                if (options.position === 'left') {\n                    titleX = left + offset;\n                    titleY = _alignStartEnd(align, bottom, top);\n                    rotation = PI * -0.5;\n                } else {\n                    titleX = right - offset;\n                    titleY = _alignStartEnd(align, top, bottom);\n                    rotation = PI * 0.5;\n                }\n                maxWidth = bottom - top;\n            }\n            return {titleX, titleY, maxWidth, rotation};\n        }\n        draw() {\n            const me = this;\n            const ctx = me.ctx;\n            const opts = me.options;\n            if (!opts.display) {\n                return;\n            }\n            const fontOpts = toFont(opts.font);\n            const lineHeight = fontOpts.lineHeight;\n            const offset = lineHeight / 2 + me._padding.top;\n            const {titleX, titleY, maxWidth, rotation} = me._drawArgs(offset);\n            renderText(ctx, opts.text, 0, 0, fontOpts, {\n                color: opts.color,\n                maxWidth,\n                rotation,\n                textAlign: _toLeftRightCenter(opts.align),\n                textBaseline: 'middle',\n                translation: [titleX, titleY],\n            });\n        }\n    }\n    function createTitle(chart, titleOpts) {\n        const title = new Title({\n            ctx: chart.ctx,\n            options: titleOpts,\n            chart\n        });\n        layouts.configure(chart, title, titleOpts);\n        layouts.addBox(chart, title);\n        chart.titleBlock = title;\n    }\n    var plugin_title = {\n        id: 'title',\n        _element: Title,\n        start(chart, _args, options) {\n            createTitle(chart, options);\n        },\n        stop(chart) {\n            const titleBlock = chart.titleBlock;\n            layouts.removeBox(chart, titleBlock);\n            delete chart.titleBlock;\n        },\n        beforeUpdate(chart, _args, options) {\n            const title = chart.titleBlock;\n            layouts.configure(chart, title, options);\n            title.options = options;\n        },\n        defaults: {\n            align: 'center',\n            display: false,\n            font: {\n                weight: 'bold',\n            },\n            fullSize: true,\n            padding: 10,\n            position: 'top',\n            text: '',\n            weight: 2000\n        },\n        defaultRoutes: {\n            color: 'color'\n        },\n        descriptors: {\n            _scriptable: true,\n            _indexable: false,\n        },\n    };\n\n    const positioners = {\n        average(items) {\n            if (!items.length) {\n                return false;\n            }\n            let i, len;\n            let x = 0;\n            let y = 0;\n            let count = 0;\n            for (i = 0, len = items.length; i < len; ++i) {\n                const el = items[i].element;\n                if (el && el.hasValue()) {\n                    const pos = el.tooltipPosition();\n                    x += pos.x;\n                    y += pos.y;\n                    ++count;\n                }\n            }\n            return {\n                x: x / count,\n                y: y / count\n            };\n        },\n        nearest(items, eventPosition) {\n            if (!items.length) {\n                return false;\n            }\n            let x = eventPosition.x;\n            let y = eventPosition.y;\n            let minDistance = Number.POSITIVE_INFINITY;\n            let i, len, nearestElement;\n            for (i = 0, len = items.length; i < len; ++i) {\n                const el = items[i].element;\n                if (el && el.hasValue()) {\n                    const center = el.getCenterPoint();\n                    const d = distanceBetweenPoints(eventPosition, center);\n                    if (d < minDistance) {\n                        minDistance = d;\n                        nearestElement = el;\n                    }\n                }\n            }\n            if (nearestElement) {\n                const tp = nearestElement.tooltipPosition();\n                x = tp.x;\n                y = tp.y;\n            }\n            return {\n                x,\n                y\n            };\n        }\n    };\n    function pushOrConcat(base, toPush) {\n        if (toPush) {\n            if (isArray(toPush)) {\n                Array.prototype.push.apply(base, toPush);\n            } else {\n                base.push(toPush);\n            }\n        }\n        return base;\n    }\n    function splitNewlines(str) {\n        if ((typeof str === 'string' || str instanceof String) && str.indexOf('\\n') > -1) {\n            return str.split('\\n');\n        }\n        return str;\n    }\n    function createTooltipItem(chart, item) {\n        const {element, datasetIndex, index} = item;\n        const controller = chart.getDatasetMeta(datasetIndex).controller;\n        const {label, value} = controller.getLabelAndValue(index);\n        return {\n            chart,\n            label,\n            parsed: controller.getParsed(index),\n            raw: chart.data.datasets[datasetIndex].data[index],\n            formattedValue: value,\n            dataset: controller.getDataset(),\n            dataIndex: index,\n            datasetIndex,\n            element\n        };\n    }\n    function getTooltipSize(tooltip, options) {\n        const ctx = tooltip._chart.ctx;\n        const {body, footer, title} = tooltip;\n        const {boxWidth, boxHeight} = options;\n        const bodyFont = toFont(options.bodyFont);\n        const titleFont = toFont(options.titleFont);\n        const footerFont = toFont(options.footerFont);\n        const titleLineCount = title.length;\n        const footerLineCount = footer.length;\n        const bodyLineItemCount = body.length;\n        const padding = toPadding(options.padding);\n        let height = padding.height;\n        let width = 0;\n        let combinedBodyLength = body.reduce((count, bodyItem) => count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length, 0);\n        combinedBodyLength += tooltip.beforeBody.length + tooltip.afterBody.length;\n        if (titleLineCount) {\n            height += titleLineCount * titleFont.lineHeight\n                + (titleLineCount - 1) * options.titleSpacing\n                + options.titleMarginBottom;\n        }\n        if (combinedBodyLength) {\n            const bodyLineHeight = options.displayColors ? Math.max(boxHeight, bodyFont.lineHeight) : bodyFont.lineHeight;\n            height += bodyLineItemCount * bodyLineHeight\n                + (combinedBodyLength - bodyLineItemCount) * bodyFont.lineHeight\n                + (combinedBodyLength - 1) * options.bodySpacing;\n        }\n        if (footerLineCount) {\n            height += options.footerMarginTop\n                + footerLineCount * footerFont.lineHeight\n                + (footerLineCount - 1) * options.footerSpacing;\n        }\n        let widthPadding = 0;\n        const maxLineWidth = function(line) {\n            width = Math.max(width, ctx.measureText(line).width + widthPadding);\n        };\n        ctx.save();\n        ctx.font = titleFont.string;\n        each(tooltip.title, maxLineWidth);\n        ctx.font = bodyFont.string;\n        each(tooltip.beforeBody.concat(tooltip.afterBody), maxLineWidth);\n        widthPadding = options.displayColors ? (boxWidth + 2) : 0;\n        each(body, (bodyItem) => {\n            each(bodyItem.before, maxLineWidth);\n            each(bodyItem.lines, maxLineWidth);\n            each(bodyItem.after, maxLineWidth);\n        });\n        widthPadding = 0;\n        ctx.font = footerFont.string;\n        each(tooltip.footer, maxLineWidth);\n        ctx.restore();\n        width += padding.width;\n        return {width, height};\n    }\n    function determineYAlign(chart, size) {\n        const {y, height} = size;\n        if (y < height / 2) {\n            return 'top';\n        } else if (y > (chart.height - height / 2)) {\n            return 'bottom';\n        }\n        return 'center';\n    }\n    function doesNotFitWithAlign(xAlign, chart, options, size) {\n        const {x, width} = size;\n        const caret = options.caretSize + options.caretPadding;\n        if (xAlign === 'left' && x + width + caret > chart.width) {\n            return true;\n        }\n        if (xAlign === 'right' && x - width - caret < 0) {\n            return true;\n        }\n    }\n    function determineXAlign(chart, options, size, yAlign) {\n        const {x, width} = size;\n        const {width: chartWidth, chartArea: {left, right}} = chart;\n        let xAlign = 'center';\n        if (yAlign === 'center') {\n            xAlign = x <= (left + right) / 2 ? 'left' : 'right';\n        } else if (x <= width / 2) {\n            xAlign = 'left';\n        } else if (x >= chartWidth - width / 2) {\n            xAlign = 'right';\n        }\n        if (doesNotFitWithAlign(xAlign, chart, options, size)) {\n            xAlign = 'center';\n        }\n        return xAlign;\n    }\n    function determineAlignment(chart, options, size) {\n        const yAlign = options.yAlign || determineYAlign(chart, size);\n        return {\n            xAlign: options.xAlign || determineXAlign(chart, options, size, yAlign),\n            yAlign\n        };\n    }\n    function alignX(size, xAlign) {\n        let {x, width} = size;\n        if (xAlign === 'right') {\n            x -= width;\n        } else if (xAlign === 'center') {\n            x -= (width / 2);\n        }\n        return x;\n    }\n    function alignY(size, yAlign, paddingAndSize) {\n        let {y, height} = size;\n        if (yAlign === 'top') {\n            y += paddingAndSize;\n        } else if (yAlign === 'bottom') {\n            y -= height + paddingAndSize;\n        } else {\n            y -= (height / 2);\n        }\n        return y;\n    }\n    function getBackgroundPoint(options, size, alignment, chart) {\n        const {caretSize, caretPadding, cornerRadius} = options;\n        const {xAlign, yAlign} = alignment;\n        const paddingAndSize = caretSize + caretPadding;\n        const radiusAndPadding = cornerRadius + caretPadding;\n        let x = alignX(size, xAlign);\n        const y = alignY(size, yAlign, paddingAndSize);\n        if (yAlign === 'center') {\n            if (xAlign === 'left') {\n                x += paddingAndSize;\n            } else if (xAlign === 'right') {\n                x -= paddingAndSize;\n            }\n        } else if (xAlign === 'left') {\n            x -= radiusAndPadding;\n        } else if (xAlign === 'right') {\n            x += radiusAndPadding;\n        }\n        return {\n            x: _limitValue(x, 0, chart.width - size.width),\n            y: _limitValue(y, 0, chart.height - size.height)\n        };\n    }\n    function getAlignedX(tooltip, align, options) {\n        const padding = toPadding(options.padding);\n        return align === 'center'\n            ? tooltip.x + tooltip.width / 2\n            : align === 'right'\n                ? tooltip.x + tooltip.width - padding.right\n                : tooltip.x + padding.left;\n    }\n    function getBeforeAfterBodyLines(callback) {\n        return pushOrConcat([], splitNewlines(callback));\n    }\n    function createTooltipContext(parent, tooltip, tooltipItems) {\n        return Object.assign(Object.create(parent), {\n            tooltip,\n            tooltipItems,\n            type: 'tooltip'\n        });\n    }\n    function overrideCallbacks(callbacks, context) {\n        const override = context && context.dataset && context.dataset.tooltip && context.dataset.tooltip.callbacks;\n        return override ? callbacks.override(override) : callbacks;\n    }\n    class Tooltip extends Element {\n        constructor(config) {\n            super();\n            this.opacity = 0;\n            this._active = [];\n            this._chart = config._chart;\n            this._eventPosition = undefined;\n            this._size = undefined;\n            this._cachedAnimations = undefined;\n            this._tooltipItems = [];\n            this.$animations = undefined;\n            this.$context = undefined;\n            this.options = config.options;\n            this.dataPoints = undefined;\n            this.title = undefined;\n            this.beforeBody = undefined;\n            this.body = undefined;\n            this.afterBody = undefined;\n            this.footer = undefined;\n            this.xAlign = undefined;\n            this.yAlign = undefined;\n            this.x = undefined;\n            this.y = undefined;\n            this.height = undefined;\n            this.width = undefined;\n            this.caretX = undefined;\n            this.caretY = undefined;\n            this.labelColors = undefined;\n            this.labelPointStyles = undefined;\n            this.labelTextColors = undefined;\n        }\n        initialize(options) {\n            this.options = options;\n            this._cachedAnimations = undefined;\n            this.$context = undefined;\n        }\n        _resolveAnimations() {\n            const me = this;\n            const cached = me._cachedAnimations;\n            if (cached) {\n                return cached;\n            }\n            const chart = me._chart;\n            const options = me.options.setContext(me.getContext());\n            const opts = options.enabled && chart.options.animation && options.animations;\n            const animations = new Animations(me._chart, opts);\n            if (opts._cacheable) {\n                me._cachedAnimations = Object.freeze(animations);\n            }\n            return animations;\n        }\n        getContext() {\n            const me = this;\n            return me.$context ||\n                (me.$context = createTooltipContext(me._chart.getContext(), me, me._tooltipItems));\n        }\n        getTitle(context, options) {\n            const me = this;\n            const {callbacks} = options;\n            const beforeTitle = callbacks.beforeTitle.apply(me, [context]);\n            const title = callbacks.title.apply(me, [context]);\n            const afterTitle = callbacks.afterTitle.apply(me, [context]);\n            let lines = [];\n            lines = pushOrConcat(lines, splitNewlines(beforeTitle));\n            lines = pushOrConcat(lines, splitNewlines(title));\n            lines = pushOrConcat(lines, splitNewlines(afterTitle));\n            return lines;\n        }\n        getBeforeBody(tooltipItems, options) {\n            return getBeforeAfterBodyLines(options.callbacks.beforeBody.apply(this, [tooltipItems]));\n        }\n        getBody(tooltipItems, options) {\n            const me = this;\n            const {callbacks} = options;\n            const bodyItems = [];\n            each(tooltipItems, (context) => {\n                const bodyItem = {\n                    before: [],\n                    lines: [],\n                    after: []\n                };\n                const scoped = overrideCallbacks(callbacks, context);\n                pushOrConcat(bodyItem.before, splitNewlines(scoped.beforeLabel.call(me, context)));\n                pushOrConcat(bodyItem.lines, scoped.label.call(me, context));\n                pushOrConcat(bodyItem.after, splitNewlines(scoped.afterLabel.call(me, context)));\n                bodyItems.push(bodyItem);\n            });\n            return bodyItems;\n        }\n        getAfterBody(tooltipItems, options) {\n            return getBeforeAfterBodyLines(options.callbacks.afterBody.apply(this, [tooltipItems]));\n        }\n        getFooter(tooltipItems, options) {\n            const me = this;\n            const {callbacks} = options;\n            const beforeFooter = callbacks.beforeFooter.apply(me, [tooltipItems]);\n            const footer = callbacks.footer.apply(me, [tooltipItems]);\n            const afterFooter = callbacks.afterFooter.apply(me, [tooltipItems]);\n            let lines = [];\n            lines = pushOrConcat(lines, splitNewlines(beforeFooter));\n            lines = pushOrConcat(lines, splitNewlines(footer));\n            lines = pushOrConcat(lines, splitNewlines(afterFooter));\n            return lines;\n        }\n        _createItems(options) {\n            const me = this;\n            const active = me._active;\n            const data = me._chart.data;\n            const labelColors = [];\n            const labelPointStyles = [];\n            const labelTextColors = [];\n            let tooltipItems = [];\n            let i, len;\n            for (i = 0, len = active.length; i < len; ++i) {\n                tooltipItems.push(createTooltipItem(me._chart, active[i]));\n            }\n            if (options.filter) {\n                tooltipItems = tooltipItems.filter((element, index, array) => options.filter(element, index, array, data));\n            }\n            if (options.itemSort) {\n                tooltipItems = tooltipItems.sort((a, b) => options.itemSort(a, b, data));\n            }\n            each(tooltipItems, (context) => {\n                const scoped = overrideCallbacks(options.callbacks, context);\n                labelColors.push(scoped.labelColor.call(me, context));\n                labelPointStyles.push(scoped.labelPointStyle.call(me, context));\n                labelTextColors.push(scoped.labelTextColor.call(me, context));\n            });\n            me.labelColors = labelColors;\n            me.labelPointStyles = labelPointStyles;\n            me.labelTextColors = labelTextColors;\n            me.dataPoints = tooltipItems;\n            return tooltipItems;\n        }\n        update(changed, replay) {\n            const me = this;\n            const options = me.options.setContext(me.getContext());\n            const active = me._active;\n            let properties;\n            let tooltipItems = [];\n            if (!active.length) {\n                if (me.opacity !== 0) {\n                    properties = {\n                        opacity: 0\n                    };\n                }\n            } else {\n                const position = positioners[options.position].call(me, active, me._eventPosition);\n                tooltipItems = me._createItems(options);\n                me.title = me.getTitle(tooltipItems, options);\n                me.beforeBody = me.getBeforeBody(tooltipItems, options);\n                me.body = me.getBody(tooltipItems, options);\n                me.afterBody = me.getAfterBody(tooltipItems, options);\n                me.footer = me.getFooter(tooltipItems, options);\n                const size = me._size = getTooltipSize(me, options);\n                const positionAndSize = Object.assign({}, position, size);\n                const alignment = determineAlignment(me._chart, options, positionAndSize);\n                const backgroundPoint = getBackgroundPoint(options, positionAndSize, alignment, me._chart);\n                me.xAlign = alignment.xAlign;\n                me.yAlign = alignment.yAlign;\n                properties = {\n                    opacity: 1,\n                    x: backgroundPoint.x,\n                    y: backgroundPoint.y,\n                    width: size.width,\n                    height: size.height,\n                    caretX: position.x,\n                    caretY: position.y\n                };\n            }\n            me._tooltipItems = tooltipItems;\n            me.$context = undefined;\n            if (properties) {\n                me._resolveAnimations().update(me, properties);\n            }\n            if (changed && options.external) {\n                options.external.call(me, {chart: me._chart, tooltip: me, replay});\n            }\n        }\n        drawCaret(tooltipPoint, ctx, size, options) {\n            const caretPosition = this.getCaretPosition(tooltipPoint, size, options);\n            ctx.lineTo(caretPosition.x1, caretPosition.y1);\n            ctx.lineTo(caretPosition.x2, caretPosition.y2);\n            ctx.lineTo(caretPosition.x3, caretPosition.y3);\n        }\n        getCaretPosition(tooltipPoint, size, options) {\n            const {xAlign, yAlign} = this;\n            const {cornerRadius, caretSize} = options;\n            const {x: ptX, y: ptY} = tooltipPoint;\n            const {width, height} = size;\n            let x1, x2, x3, y1, y2, y3;\n            if (yAlign === 'center') {\n                y2 = ptY + (height / 2);\n                if (xAlign === 'left') {\n                    x1 = ptX;\n                    x2 = x1 - caretSize;\n                    y1 = y2 + caretSize;\n                    y3 = y2 - caretSize;\n                } else {\n                    x1 = ptX + width;\n                    x2 = x1 + caretSize;\n                    y1 = y2 - caretSize;\n                    y3 = y2 + caretSize;\n                }\n                x3 = x1;\n            } else {\n                if (xAlign === 'left') {\n                    x2 = ptX + cornerRadius + (caretSize);\n                } else if (xAlign === 'right') {\n                    x2 = ptX + width - cornerRadius - caretSize;\n                } else {\n                    x2 = this.caretX;\n                }\n                if (yAlign === 'top') {\n                    y1 = ptY;\n                    y2 = y1 - caretSize;\n                    x1 = x2 - caretSize;\n                    x3 = x2 + caretSize;\n                } else {\n                    y1 = ptY + height;\n                    y2 = y1 + caretSize;\n                    x1 = x2 + caretSize;\n                    x3 = x2 - caretSize;\n                }\n                y3 = y1;\n            }\n            return {x1, x2, x3, y1, y2, y3};\n        }\n        drawTitle(pt, ctx, options) {\n            const me = this;\n            const title = me.title;\n            const length = title.length;\n            let titleFont, titleSpacing, i;\n            if (length) {\n                const rtlHelper = getRtlAdapter(options.rtl, me.x, me.width);\n                pt.x = getAlignedX(me, options.titleAlign, options);\n                ctx.textAlign = rtlHelper.textAlign(options.titleAlign);\n                ctx.textBaseline = 'middle';\n                titleFont = toFont(options.titleFont);\n                titleSpacing = options.titleSpacing;\n                ctx.fillStyle = options.titleColor;\n                ctx.font = titleFont.string;\n                for (i = 0; i < length; ++i) {\n                    ctx.fillText(title[i], rtlHelper.x(pt.x), pt.y + titleFont.lineHeight / 2);\n                    pt.y += titleFont.lineHeight + titleSpacing;\n                    if (i + 1 === length) {\n                        pt.y += options.titleMarginBottom - titleSpacing;\n                    }\n                }\n            }\n        }\n        _drawColorBox(ctx, pt, i, rtlHelper, options) {\n            const me = this;\n            const labelColors = me.labelColors[i];\n            const labelPointStyle = me.labelPointStyles[i];\n            const {boxHeight, boxWidth} = options;\n            const bodyFont = toFont(options.bodyFont);\n            const colorX = getAlignedX(me, 'left', options);\n            const rtlColorX = rtlHelper.x(colorX);\n            const yOffSet = boxHeight < bodyFont.lineHeight ? (bodyFont.lineHeight - boxHeight) / 2 : 0;\n            const colorY = pt.y + yOffSet;\n            if (options.usePointStyle) {\n                const drawOptions = {\n                    radius: Math.min(boxWidth, boxHeight) / 2,\n                    pointStyle: labelPointStyle.pointStyle,\n                    rotation: labelPointStyle.rotation,\n                    borderWidth: 1\n                };\n                const centerX = rtlHelper.leftForLtr(rtlColorX, boxWidth) + boxWidth / 2;\n                const centerY = colorY + boxHeight / 2;\n                ctx.strokeStyle = options.multiKeyBackground;\n                ctx.fillStyle = options.multiKeyBackground;\n                drawPoint(ctx, drawOptions, centerX, centerY);\n                ctx.strokeStyle = labelColors.borderColor;\n                ctx.fillStyle = labelColors.backgroundColor;\n                drawPoint(ctx, drawOptions, centerX, centerY);\n            } else {\n                ctx.lineWidth = labelColors.borderWidth || 1;\n                ctx.strokeStyle = labelColors.borderColor;\n                ctx.setLineDash(labelColors.borderDash || []);\n                ctx.lineDashOffset = labelColors.borderDashOffset || 0;\n                const outerX = rtlHelper.leftForLtr(rtlColorX, boxWidth);\n                const innerX = rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX, 1), boxWidth - 2);\n                const borderRadius = toTRBLCorners(labelColors.borderRadius);\n                if (Object.values(borderRadius).some(v => v !== 0)) {\n                    ctx.beginPath();\n                    ctx.fillStyle = options.multiKeyBackground;\n                    addRoundedRectPath(ctx, {\n                        x: outerX,\n                        y: colorY,\n                        w: boxWidth,\n                        h: boxHeight,\n                        radius: borderRadius,\n                    });\n                    ctx.fill();\n                    ctx.stroke();\n                    ctx.fillStyle = labelColors.backgroundColor;\n                    ctx.beginPath();\n                    addRoundedRectPath(ctx, {\n                        x: innerX,\n                        y: colorY + 1,\n                        w: boxWidth - 2,\n                        h: boxHeight - 2,\n                        radius: borderRadius,\n                    });\n                    ctx.fill();\n                } else {\n                    ctx.fillStyle = options.multiKeyBackground;\n                    ctx.fillRect(outerX, colorY, boxWidth, boxHeight);\n                    ctx.strokeRect(outerX, colorY, boxWidth, boxHeight);\n                    ctx.fillStyle = labelColors.backgroundColor;\n                    ctx.fillRect(innerX, colorY + 1, boxWidth - 2, boxHeight - 2);\n                }\n            }\n            ctx.fillStyle = me.labelTextColors[i];\n        }\n        drawBody(pt, ctx, options) {\n            const me = this;\n            const {body} = me;\n            const {bodySpacing, bodyAlign, displayColors, boxHeight, boxWidth} = options;\n            const bodyFont = toFont(options.bodyFont);\n            let bodyLineHeight = bodyFont.lineHeight;\n            let xLinePadding = 0;\n            const rtlHelper = getRtlAdapter(options.rtl, me.x, me.width);\n            const fillLineOfText = function(line) {\n                ctx.fillText(line, rtlHelper.x(pt.x + xLinePadding), pt.y + bodyLineHeight / 2);\n                pt.y += bodyLineHeight + bodySpacing;\n            };\n            const bodyAlignForCalculation = rtlHelper.textAlign(bodyAlign);\n            let bodyItem, textColor, lines, i, j, ilen, jlen;\n            ctx.textAlign = bodyAlign;\n            ctx.textBaseline = 'middle';\n            ctx.font = bodyFont.string;\n            pt.x = getAlignedX(me, bodyAlignForCalculation, options);\n            ctx.fillStyle = options.bodyColor;\n            each(me.beforeBody, fillLineOfText);\n            xLinePadding = displayColors && bodyAlignForCalculation !== 'right'\n                ? bodyAlign === 'center' ? (boxWidth / 2 + 1) : (boxWidth + 2)\n                : 0;\n            for (i = 0, ilen = body.length; i < ilen; ++i) {\n                bodyItem = body[i];\n                textColor = me.labelTextColors[i];\n                ctx.fillStyle = textColor;\n                each(bodyItem.before, fillLineOfText);\n                lines = bodyItem.lines;\n                if (displayColors && lines.length) {\n                    me._drawColorBox(ctx, pt, i, rtlHelper, options);\n                    bodyLineHeight = Math.max(bodyFont.lineHeight, boxHeight);\n                }\n                for (j = 0, jlen = lines.length; j < jlen; ++j) {\n                    fillLineOfText(lines[j]);\n                    bodyLineHeight = bodyFont.lineHeight;\n                }\n                each(bodyItem.after, fillLineOfText);\n            }\n            xLinePadding = 0;\n            bodyLineHeight = bodyFont.lineHeight;\n            each(me.afterBody, fillLineOfText);\n            pt.y -= bodySpacing;\n        }\n        drawFooter(pt, ctx, options) {\n            const me = this;\n            const footer = me.footer;\n            const length = footer.length;\n            let footerFont, i;\n            if (length) {\n                const rtlHelper = getRtlAdapter(options.rtl, me.x, me.width);\n                pt.x = getAlignedX(me, options.footerAlign, options);\n                pt.y += options.footerMarginTop;\n                ctx.textAlign = rtlHelper.textAlign(options.footerAlign);\n                ctx.textBaseline = 'middle';\n                footerFont = toFont(options.footerFont);\n                ctx.fillStyle = options.footerColor;\n                ctx.font = footerFont.string;\n                for (i = 0; i < length; ++i) {\n                    ctx.fillText(footer[i], rtlHelper.x(pt.x), pt.y + footerFont.lineHeight / 2);\n                    pt.y += footerFont.lineHeight + options.footerSpacing;\n                }\n            }\n        }\n        drawBackground(pt, ctx, tooltipSize, options) {\n            const {xAlign, yAlign} = this;\n            const {x, y} = pt;\n            const {width, height} = tooltipSize;\n            const radius = options.cornerRadius;\n            ctx.fillStyle = options.backgroundColor;\n            ctx.strokeStyle = options.borderColor;\n            ctx.lineWidth = options.borderWidth;\n            ctx.beginPath();\n            ctx.moveTo(x + radius, y);\n            if (yAlign === 'top') {\n                this.drawCaret(pt, ctx, tooltipSize, options);\n            }\n            ctx.lineTo(x + width - radius, y);\n            ctx.quadraticCurveTo(x + width, y, x + width, y + radius);\n            if (yAlign === 'center' && xAlign === 'right') {\n                this.drawCaret(pt, ctx, tooltipSize, options);\n            }\n            ctx.lineTo(x + width, y + height - radius);\n            ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);\n            if (yAlign === 'bottom') {\n                this.drawCaret(pt, ctx, tooltipSize, options);\n            }\n            ctx.lineTo(x + radius, y + height);\n            ctx.quadraticCurveTo(x, y + height, x, y + height - radius);\n            if (yAlign === 'center' && xAlign === 'left') {\n                this.drawCaret(pt, ctx, tooltipSize, options);\n            }\n            ctx.lineTo(x, y + radius);\n            ctx.quadraticCurveTo(x, y, x + radius, y);\n            ctx.closePath();\n            ctx.fill();\n            if (options.borderWidth > 0) {\n                ctx.stroke();\n            }\n        }\n        _updateAnimationTarget(options) {\n            const me = this;\n            const chart = me._chart;\n            const anims = me.$animations;\n            const animX = anims && anims.x;\n            const animY = anims && anims.y;\n            if (animX || animY) {\n                const position = positioners[options.position].call(me, me._active, me._eventPosition);\n                if (!position) {\n                    return;\n                }\n                const size = me._size = getTooltipSize(me, options);\n                const positionAndSize = Object.assign({}, position, me._size);\n                const alignment = determineAlignment(chart, options, positionAndSize);\n                const point = getBackgroundPoint(options, positionAndSize, alignment, chart);\n                if (animX._to !== point.x || animY._to !== point.y) {\n                    me.xAlign = alignment.xAlign;\n                    me.yAlign = alignment.yAlign;\n                    me.width = size.width;\n                    me.height = size.height;\n                    me.caretX = position.x;\n                    me.caretY = position.y;\n                    me._resolveAnimations().update(me, point);\n                }\n            }\n        }\n        draw(ctx) {\n            const me = this;\n            const options = me.options.setContext(me.getContext());\n            let opacity = me.opacity;\n            if (!opacity) {\n                return;\n            }\n            me._updateAnimationTarget(options);\n            const tooltipSize = {\n                width: me.width,\n                height: me.height\n            };\n            const pt = {\n                x: me.x,\n                y: me.y\n            };\n            opacity = Math.abs(opacity) < 1e-3 ? 0 : opacity;\n            const padding = toPadding(options.padding);\n            const hasTooltipContent = me.title.length || me.beforeBody.length || me.body.length || me.afterBody.length || me.footer.length;\n            if (options.enabled && hasTooltipContent) {\n                ctx.save();\n                ctx.globalAlpha = opacity;\n                me.drawBackground(pt, ctx, tooltipSize, options);\n                overrideTextDirection(ctx, options.textDirection);\n                pt.y += padding.top;\n                me.drawTitle(pt, ctx, options);\n                me.drawBody(pt, ctx, options);\n                me.drawFooter(pt, ctx, options);\n                restoreTextDirection(ctx, options.textDirection);\n                ctx.restore();\n            }\n        }\n        getActiveElements() {\n            return this._active || [];\n        }\n        setActiveElements(activeElements, eventPosition) {\n            const me = this;\n            const lastActive = me._active;\n            const active = activeElements.map(({datasetIndex, index}) => {\n                const meta = me._chart.getDatasetMeta(datasetIndex);\n                if (!meta) {\n                    throw new Error('Cannot find a dataset at index ' + datasetIndex);\n                }\n                return {\n                    datasetIndex,\n                    element: meta.data[index],\n                    index,\n                };\n            });\n            const changed = !_elementsEqual(lastActive, active);\n            const positionChanged = me._positionChanged(active, eventPosition);\n            if (changed || positionChanged) {\n                me._active = active;\n                me._eventPosition = eventPosition;\n                me.update(true);\n            }\n        }\n        handleEvent(e, replay) {\n            const me = this;\n            const options = me.options;\n            const lastActive = me._active || [];\n            let changed = false;\n            let active = [];\n            if (e.type !== 'mouseout') {\n                active = me._chart.getElementsAtEventForMode(e, options.mode, options, replay);\n                if (options.reverse) {\n                    active.reverse();\n                }\n            }\n            const positionChanged = me._positionChanged(active, e);\n            changed = replay || !_elementsEqual(active, lastActive) || positionChanged;\n            if (changed) {\n                me._active = active;\n                if (options.enabled || options.external) {\n                    me._eventPosition = {\n                        x: e.x,\n                        y: e.y\n                    };\n                    me.update(true, replay);\n                }\n            }\n            return changed;\n        }\n        _positionChanged(active, e) {\n            const {caretX, caretY, options} = this;\n            const position = positioners[options.position].call(this, active, e);\n            return position !== false && (caretX !== position.x || caretY !== position.y);\n        }\n    }\n    Tooltip.positioners = positioners;\n    var plugin_tooltip = {\n        id: 'tooltip',\n        _element: Tooltip,\n        positioners,\n        afterInit(chart, _args, options) {\n            if (options) {\n                chart.tooltip = new Tooltip({_chart: chart, options});\n            }\n        },\n        beforeUpdate(chart, _args, options) {\n            if (chart.tooltip) {\n                chart.tooltip.initialize(options);\n            }\n        },\n        reset(chart, _args, options) {\n            if (chart.tooltip) {\n                chart.tooltip.initialize(options);\n            }\n        },\n        afterDraw(chart) {\n            const tooltip = chart.tooltip;\n            const args = {\n                tooltip\n            };\n            if (chart.notifyPlugins('beforeTooltipDraw', args) === false) {\n                return;\n            }\n            if (tooltip) {\n                tooltip.draw(chart.ctx);\n            }\n            chart.notifyPlugins('afterTooltipDraw', args);\n        },\n        afterEvent(chart, args) {\n            if (chart.tooltip) {\n                const useFinalPosition = args.replay;\n                if (chart.tooltip.handleEvent(args.event, useFinalPosition)) {\n                    args.changed = true;\n                }\n            }\n        },\n        defaults: {\n            enabled: true,\n            external: null,\n            position: 'average',\n            backgroundColor: 'rgba(0,0,0,0.8)',\n            titleColor: '#fff',\n            titleFont: {\n                weight: 'bold',\n            },\n            titleSpacing: 2,\n            titleMarginBottom: 6,\n            titleAlign: 'left',\n            bodyColor: '#fff',\n            bodySpacing: 2,\n            bodyFont: {\n            },\n            bodyAlign: 'left',\n            footerColor: '#fff',\n            footerSpacing: 2,\n            footerMarginTop: 6,\n            footerFont: {\n                weight: 'bold',\n            },\n            footerAlign: 'left',\n            padding: 6,\n            caretPadding: 2,\n            caretSize: 5,\n            cornerRadius: 6,\n            boxHeight: (ctx, opts) => opts.bodyFont.size,\n            boxWidth: (ctx, opts) => opts.bodyFont.size,\n            multiKeyBackground: '#fff',\n            displayColors: true,\n            borderColor: 'rgba(0,0,0,0)',\n            borderWidth: 0,\n            animation: {\n                duration: 400,\n                easing: 'easeOutQuart',\n            },\n            animations: {\n                numbers: {\n                    type: 'number',\n                    properties: ['x', 'y', 'width', 'height', 'caretX', 'caretY'],\n                },\n                opacity: {\n                    easing: 'linear',\n                    duration: 200\n                }\n            },\n            callbacks: {\n                beforeTitle: noop,\n                title(tooltipItems) {\n                    if (tooltipItems.length > 0) {\n                        const item = tooltipItems[0];\n                        const labels = item.chart.data.labels;\n                        const labelCount = labels ? labels.length : 0;\n                        if (this && this.options && this.options.mode === 'dataset') {\n                            return item.dataset.label || '';\n                        } else if (item.label) {\n                            return item.label;\n                        } else if (labelCount > 0 && item.dataIndex < labelCount) {\n                            return labels[item.dataIndex];\n                        }\n                    }\n                    return '';\n                },\n                afterTitle: noop,\n                beforeBody: noop,\n                beforeLabel: noop,\n                label(tooltipItem) {\n                    if (this && this.options && this.options.mode === 'dataset') {\n                        return tooltipItem.label + ': ' + tooltipItem.formattedValue || tooltipItem.formattedValue;\n                    }\n                    let label = tooltipItem.dataset.label || '';\n                    if (label) {\n                        label += ': ';\n                    }\n                    const value = tooltipItem.formattedValue;\n                    if (!isNullOrUndef(value)) {\n                        label += value;\n                    }\n                    return label;\n                },\n                labelColor(tooltipItem) {\n                    const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);\n                    const options = meta.controller.getStyle(tooltipItem.dataIndex);\n                    return {\n                        borderColor: options.borderColor,\n                        backgroundColor: options.backgroundColor,\n                        borderWidth: options.borderWidth,\n                        borderDash: options.borderDash,\n                        borderDashOffset: options.borderDashOffset,\n                        borderRadius: 0,\n                    };\n                },\n                labelTextColor() {\n                    return this.options.bodyColor;\n                },\n                labelPointStyle(tooltipItem) {\n                    const meta = tooltipItem.chart.getDatasetMeta(tooltipItem.datasetIndex);\n                    const options = meta.controller.getStyle(tooltipItem.dataIndex);\n                    return {\n                        pointStyle: options.pointStyle,\n                        rotation: options.rotation,\n                    };\n                },\n                afterLabel: noop,\n                afterBody: noop,\n                beforeFooter: noop,\n                footer: noop,\n                afterFooter: noop\n            }\n        },\n        defaultRoutes: {\n            bodyFont: 'font',\n            footerFont: 'font',\n            titleFont: 'font'\n        },\n        descriptors: {\n            _scriptable: (name) => name !== 'filter' && name !== 'itemSort' && name !== 'external',\n            _indexable: false,\n            callbacks: {\n                _scriptable: false,\n                _indexable: false,\n            },\n            animation: {\n                _fallback: false\n            },\n            animations: {\n                _fallback: 'animation'\n            }\n        },\n        additionalOptionScopes: ['interaction']\n    };\n\n    var plugins = /*#__PURE__*/Object.freeze({\n        __proto__: null,\n        Decimation: plugin_decimation,\n        Filler: plugin_filler,\n        Legend: plugin_legend,\n        Title: plugin_title,\n        Tooltip: plugin_tooltip\n    });\n\n    const addIfString = (labels, raw, index) => typeof raw === 'string'\n        ? labels.push(raw) - 1\n        : isNaN(raw) ? null : index;\n    function findOrAddLabel(labels, raw, index) {\n        const first = labels.indexOf(raw);\n        if (first === -1) {\n            return addIfString(labels, raw, index);\n        }\n        const last = labels.lastIndexOf(raw);\n        return first !== last ? index : first;\n    }\n    const validIndex = (index, max) => index === null ? null : _limitValue(Math.round(index), 0, max);\n    class CategoryScale extends Scale {\n        constructor(cfg) {\n            super(cfg);\n            this._startValue = undefined;\n            this._valueRange = 0;\n        }\n        parse(raw, index) {\n            if (isNullOrUndef(raw)) {\n                return null;\n            }\n            const labels = this.getLabels();\n            index = isFinite(index) && labels[index] === raw ? index\n                : findOrAddLabel(labels, raw, valueOrDefault(index, raw));\n            return validIndex(index, labels.length - 1);\n        }\n        determineDataLimits() {\n            const me = this;\n            const {minDefined, maxDefined} = me.getUserBounds();\n            let {min, max} = me.getMinMax(true);\n            if (me.options.bounds === 'ticks') {\n                if (!minDefined) {\n                    min = 0;\n                }\n                if (!maxDefined) {\n                    max = me.getLabels().length - 1;\n                }\n            }\n            me.min = min;\n            me.max = max;\n        }\n        buildTicks() {\n            const me = this;\n            const min = me.min;\n            const max = me.max;\n            const offset = me.options.offset;\n            const ticks = [];\n            let labels = me.getLabels();\n            labels = (min === 0 && max === labels.length - 1) ? labels : labels.slice(min, max + 1);\n            me._valueRange = Math.max(labels.length - (offset ? 0 : 1), 1);\n            me._startValue = me.min - (offset ? 0.5 : 0);\n            for (let value = min; value <= max; value++) {\n                ticks.push({value});\n            }\n            return ticks;\n        }\n        getLabelForValue(value) {\n            const me = this;\n            const labels = me.getLabels();\n            if (value >= 0 && value < labels.length) {\n                return labels[value];\n            }\n            return value;\n        }\n        configure() {\n            const me = this;\n            super.configure();\n            if (!me.isHorizontal()) {\n                me._reversePixels = !me._reversePixels;\n            }\n        }\n        getPixelForValue(value) {\n            const me = this;\n            if (typeof value !== 'number') {\n                value = me.parse(value);\n            }\n            return value === null ? NaN : me.getPixelForDecimal((value - me._startValue) / me._valueRange);\n        }\n        getPixelForTick(index) {\n            const me = this;\n            const ticks = me.ticks;\n            if (index < 0 || index > ticks.length - 1) {\n                return null;\n            }\n            return me.getPixelForValue(ticks[index].value);\n        }\n        getValueForPixel(pixel) {\n            const me = this;\n            return Math.round(me._startValue + me.getDecimalForPixel(pixel) * me._valueRange);\n        }\n        getBasePixel() {\n            return this.bottom;\n        }\n    }\n    CategoryScale.id = 'category';\n    CategoryScale.defaults = {\n        ticks: {\n            callback: CategoryScale.prototype.getLabelForValue\n        }\n    };\n\n    function generateTicks$1(generationOptions, dataRange) {\n        const ticks = [];\n        const MIN_SPACING = 1e-14;\n        const {bounds, step, min, max, precision, count, maxTicks, maxDigits, includeBounds} = generationOptions;\n        const unit = step || 1;\n        const maxSpaces = maxTicks - 1;\n        const {min: rmin, max: rmax} = dataRange;\n        const minDefined = !isNullOrUndef(min);\n        const maxDefined = !isNullOrUndef(max);\n        const countDefined = !isNullOrUndef(count);\n        const minSpacing = (rmax - rmin) / (maxDigits + 1);\n        let spacing = niceNum((rmax - rmin) / maxSpaces / unit) * unit;\n        let factor, niceMin, niceMax, numSpaces;\n        if (spacing < MIN_SPACING && !minDefined && !maxDefined) {\n            return [{value: rmin}, {value: rmax}];\n        }\n        numSpaces = Math.ceil(rmax / spacing) - Math.floor(rmin / spacing);\n        if (numSpaces > maxSpaces) {\n            spacing = niceNum(numSpaces * spacing / maxSpaces / unit) * unit;\n        }\n        if (!isNullOrUndef(precision)) {\n            factor = Math.pow(10, precision);\n            spacing = Math.ceil(spacing * factor) / factor;\n        }\n        if (bounds === 'ticks') {\n            niceMin = Math.floor(rmin / spacing) * spacing;\n            niceMax = Math.ceil(rmax / spacing) * spacing;\n        } else {\n            niceMin = rmin;\n            niceMax = rmax;\n        }\n        if (minDefined && maxDefined && step && almostWhole((max - min) / step, spacing / 1000)) {\n            numSpaces = Math.min((max - min) / spacing, maxTicks);\n            spacing = (max - min) / numSpaces;\n            niceMin = min;\n            niceMax = max;\n        } else if (countDefined) {\n            niceMin = minDefined ? min : niceMin;\n            niceMax = maxDefined ? max : niceMax;\n            numSpaces = count - 1;\n            spacing = (niceMax - niceMin) / numSpaces;\n        } else {\n            numSpaces = (niceMax - niceMin) / spacing;\n            if (almostEquals(numSpaces, Math.round(numSpaces), spacing / 1000)) {\n                numSpaces = Math.round(numSpaces);\n            } else {\n                numSpaces = Math.ceil(numSpaces);\n            }\n        }\n        const decimalPlaces = Math.max(\n            _decimalPlaces(spacing),\n            _decimalPlaces(niceMin),\n        );\n        factor = Math.pow(10, isNullOrUndef(precision) ? decimalPlaces : precision);\n        niceMin = Math.round(niceMin * factor) / factor;\n        niceMax = Math.round(niceMax * factor) / factor;\n        let j = 0;\n        if (minDefined) {\n            if (includeBounds && niceMin !== min) {\n                ticks.push({value: min});\n                if (niceMin < min) {\n                    j++;\n                }\n                if (almostEquals(Math.round((niceMin + j * spacing) * factor) / factor, min, relativeLabelSize(min, minSpacing, generationOptions))) {\n                    j++;\n                }\n            } else if (niceMin < min) {\n                j++;\n            }\n        }\n        for (; j < numSpaces; ++j) {\n            ticks.push({value: Math.round((niceMin + j * spacing) * factor) / factor});\n        }\n        if (maxDefined && includeBounds && niceMax !== max) {\n            if (almostEquals(ticks[ticks.length - 1].value, max, relativeLabelSize(max, minSpacing, generationOptions))) {\n                ticks[ticks.length - 1].value = max;\n            } else {\n                ticks.push({value: max});\n            }\n        } else if (!maxDefined || niceMax === max) {\n            ticks.push({value: niceMax});\n        }\n        return ticks;\n    }\n    function relativeLabelSize(value, minSpacing, {horizontal, minRotation}) {\n        const rad = toRadians(minRotation);\n        const ratio = (horizontal ? Math.sin(rad) : Math.cos(rad)) || 0.001;\n        const length = 0.75 * minSpacing * ('' + value).length;\n        return Math.min(minSpacing / ratio, length);\n    }\n    class LinearScaleBase extends Scale {\n        constructor(cfg) {\n            super(cfg);\n            this.start = undefined;\n            this.end = undefined;\n            this._startValue = undefined;\n            this._endValue = undefined;\n            this._valueRange = 0;\n        }\n        parse(raw, index) {\n            if (isNullOrUndef(raw)) {\n                return null;\n            }\n            if ((typeof raw === 'number' || raw instanceof Number) && !isFinite(+raw)) {\n                return null;\n            }\n            return +raw;\n        }\n        handleTickRangeOptions() {\n            const me = this;\n            const {beginAtZero} = me.options;\n            const {minDefined, maxDefined} = me.getUserBounds();\n            let {min, max} = me;\n            const setMin = v => (min = minDefined ? min : v);\n            const setMax = v => (max = maxDefined ? max : v);\n            if (beginAtZero) {\n                const minSign = sign(min);\n                const maxSign = sign(max);\n                if (minSign < 0 && maxSign < 0) {\n                    setMax(0);\n                } else if (minSign > 0 && maxSign > 0) {\n                    setMin(0);\n                }\n            }\n            if (min === max) {\n                setMax(max + 1);\n                if (!beginAtZero) {\n                    setMin(min - 1);\n                }\n            }\n            me.min = min;\n            me.max = max;\n        }\n        getTickLimit() {\n            const me = this;\n            const tickOpts = me.options.ticks;\n            let {maxTicksLimit, stepSize} = tickOpts;\n            let maxTicks;\n            if (stepSize) {\n                maxTicks = Math.ceil(me.max / stepSize) - Math.floor(me.min / stepSize) + 1;\n            } else {\n                maxTicks = me.computeTickLimit();\n                maxTicksLimit = maxTicksLimit || 11;\n            }\n            if (maxTicksLimit) {\n                maxTicks = Math.min(maxTicksLimit, maxTicks);\n            }\n            return maxTicks;\n        }\n        computeTickLimit() {\n            return Number.POSITIVE_INFINITY;\n        }\n        buildTicks() {\n            const me = this;\n            const opts = me.options;\n            const tickOpts = opts.ticks;\n            let maxTicks = me.getTickLimit();\n            maxTicks = Math.max(2, maxTicks);\n            const numericGeneratorOptions = {\n                maxTicks,\n                bounds: opts.bounds,\n                min: opts.min,\n                max: opts.max,\n                precision: tickOpts.precision,\n                step: tickOpts.stepSize,\n                count: tickOpts.count,\n                maxDigits: me._maxDigits(),\n                horizontal: me.isHorizontal(),\n                minRotation: tickOpts.minRotation || 0,\n                includeBounds: tickOpts.includeBounds !== false\n            };\n            const dataRange = me._range || me;\n            const ticks = generateTicks$1(numericGeneratorOptions, dataRange);\n            if (opts.bounds === 'ticks') {\n                _setMinAndMaxByKey(ticks, me, 'value');\n            }\n            if (opts.reverse) {\n                ticks.reverse();\n                me.start = me.max;\n                me.end = me.min;\n            } else {\n                me.start = me.min;\n                me.end = me.max;\n            }\n            return ticks;\n        }\n        configure() {\n            const me = this;\n            const ticks = me.ticks;\n            let start = me.min;\n            let end = me.max;\n            super.configure();\n            if (me.options.offset && ticks.length) {\n                const offset = (end - start) / Math.max(ticks.length - 1, 1) / 2;\n                start -= offset;\n                end += offset;\n            }\n            me._startValue = start;\n            me._endValue = end;\n            me._valueRange = end - start;\n        }\n        getLabelForValue(value) {\n            return formatNumber(value, this.chart.options.locale);\n        }\n    }\n\n    class LinearScale extends LinearScaleBase {\n        determineDataLimits() {\n            const me = this;\n            const {min, max} = me.getMinMax(true);\n            me.min = isNumberFinite(min) ? min : 0;\n            me.max = isNumberFinite(max) ? max : 1;\n            me.handleTickRangeOptions();\n        }\n        computeTickLimit() {\n            const me = this;\n            const horizontal = me.isHorizontal();\n            const length = horizontal ? me.width : me.height;\n            const minRotation = toRadians(me.options.ticks.minRotation);\n            const ratio = (horizontal ? Math.sin(minRotation) : Math.cos(minRotation)) || 0.001;\n            const tickFont = me._resolveTickFontOptions(0);\n            return Math.ceil(length / Math.min(40, tickFont.lineHeight / ratio));\n        }\n        getPixelForValue(value) {\n            return value === null ? NaN : this.getPixelForDecimal((value - this._startValue) / this._valueRange);\n        }\n        getValueForPixel(pixel) {\n            return this._startValue + this.getDecimalForPixel(pixel) * this._valueRange;\n        }\n    }\n    LinearScale.id = 'linear';\n    LinearScale.defaults = {\n        ticks: {\n            callback: Ticks.formatters.numeric\n        }\n    };\n\n    function isMajor(tickVal) {\n        const remain = tickVal / (Math.pow(10, Math.floor(log10(tickVal))));\n        return remain === 1;\n    }\n    function generateTicks(generationOptions, dataRange) {\n        const endExp = Math.floor(log10(dataRange.max));\n        const endSignificand = Math.ceil(dataRange.max / Math.pow(10, endExp));\n        const ticks = [];\n        let tickVal = finiteOrDefault(generationOptions.min, Math.pow(10, Math.floor(log10(dataRange.min))));\n        let exp = Math.floor(log10(tickVal));\n        let significand = Math.floor(tickVal / Math.pow(10, exp));\n        let precision = exp < 0 ? Math.pow(10, Math.abs(exp)) : 1;\n        do {\n            ticks.push({value: tickVal, major: isMajor(tickVal)});\n            ++significand;\n            if (significand === 10) {\n                significand = 1;\n                ++exp;\n                precision = exp >= 0 ? 1 : precision;\n            }\n            tickVal = Math.round(significand * Math.pow(10, exp) * precision) / precision;\n        } while (exp < endExp || (exp === endExp && significand < endSignificand));\n        const lastTick = finiteOrDefault(generationOptions.max, tickVal);\n        ticks.push({value: lastTick, major: isMajor(tickVal)});\n        return ticks;\n    }\n    class LogarithmicScale extends Scale {\n        constructor(cfg) {\n            super(cfg);\n            this.start = undefined;\n            this.end = undefined;\n            this._startValue = undefined;\n            this._valueRange = 0;\n        }\n        parse(raw, index) {\n            const value = LinearScaleBase.prototype.parse.apply(this, [raw, index]);\n            if (value === 0) {\n                this._zero = true;\n                return undefined;\n            }\n            return isNumberFinite(value) && value > 0 ? value : null;\n        }\n        determineDataLimits() {\n            const me = this;\n            const {min, max} = me.getMinMax(true);\n            me.min = isNumberFinite(min) ? Math.max(0, min) : null;\n            me.max = isNumberFinite(max) ? Math.max(0, max) : null;\n            if (me.options.beginAtZero) {\n                me._zero = true;\n            }\n            me.handleTickRangeOptions();\n        }\n        handleTickRangeOptions() {\n            const me = this;\n            const {minDefined, maxDefined} = me.getUserBounds();\n            let min = me.min;\n            let max = me.max;\n            const setMin = v => (min = minDefined ? min : v);\n            const setMax = v => (max = maxDefined ? max : v);\n            const exp = (v, m) => Math.pow(10, Math.floor(log10(v)) + m);\n            if (min === max) {\n                if (min <= 0) {\n                    setMin(1);\n                    setMax(10);\n                } else {\n                    setMin(exp(min, -1));\n                    setMax(exp(max, +1));\n                }\n            }\n            if (min <= 0) {\n                setMin(exp(max, -1));\n            }\n            if (max <= 0) {\n                setMax(exp(min, +1));\n            }\n            if (me._zero && me.min !== me._suggestedMin && min === exp(me.min, 0)) {\n                setMin(exp(min, -1));\n            }\n            me.min = min;\n            me.max = max;\n        }\n        buildTicks() {\n            const me = this;\n            const opts = me.options;\n            const generationOptions = {\n                min: me._userMin,\n                max: me._userMax\n            };\n            const ticks = generateTicks(generationOptions, me);\n            if (opts.bounds === 'ticks') {\n                _setMinAndMaxByKey(ticks, me, 'value');\n            }\n            if (opts.reverse) {\n                ticks.reverse();\n                me.start = me.max;\n                me.end = me.min;\n            } else {\n                me.start = me.min;\n                me.end = me.max;\n            }\n            return ticks;\n        }\n        getLabelForValue(value) {\n            return value === undefined ? '0' : formatNumber(value, this.chart.options.locale);\n        }\n        configure() {\n            const me = this;\n            const start = me.min;\n            super.configure();\n            me._startValue = log10(start);\n            me._valueRange = log10(me.max) - log10(start);\n        }\n        getPixelForValue(value) {\n            const me = this;\n            if (value === undefined || value === 0) {\n                value = me.min;\n            }\n            if (value === null || isNaN(value)) {\n                return NaN;\n            }\n            return me.getPixelForDecimal(value === me.min\n                ? 0\n                : (log10(value) - me._startValue) / me._valueRange);\n        }\n        getValueForPixel(pixel) {\n            const me = this;\n            const decimal = me.getDecimalForPixel(pixel);\n            return Math.pow(10, me._startValue + decimal * me._valueRange);\n        }\n    }\n    LogarithmicScale.id = 'logarithmic';\n    LogarithmicScale.defaults = {\n        ticks: {\n            callback: Ticks.formatters.logarithmic,\n            major: {\n                enabled: true\n            }\n        }\n    };\n\n    function getTickBackdropHeight(opts) {\n        const tickOpts = opts.ticks;\n        if (tickOpts.display && opts.display) {\n            const padding = toPadding(tickOpts.backdropPadding);\n            return valueOrDefault(tickOpts.font && tickOpts.font.size, defaults.font.size) + padding.height;\n        }\n        return 0;\n    }\n    function measureLabelSize(ctx, lineHeight, label) {\n        if (isArray(label)) {\n            return {\n                w: _longestText(ctx, ctx.font, label),\n                h: label.length * lineHeight\n            };\n        }\n        return {\n            w: ctx.measureText(label).width,\n            h: lineHeight\n        };\n    }\n    function determineLimits(angle, pos, size, min, max) {\n        if (angle === min || angle === max) {\n            return {\n                start: pos - (size / 2),\n                end: pos + (size / 2)\n            };\n        } else if (angle < min || angle > max) {\n            return {\n                start: pos - size,\n                end: pos\n            };\n        }\n        return {\n            start: pos,\n            end: pos + size\n        };\n    }\n    function fitWithPointLabels(scale) {\n        const furthestLimits = {\n            l: 0,\n            r: scale.width,\n            t: 0,\n            b: scale.height - scale.paddingTop\n        };\n        const furthestAngles = {};\n        let i, textSize, pointPosition;\n        const labelSizes = [];\n        const padding = [];\n        const valueCount = scale.getLabels().length;\n        for (i = 0; i < valueCount; i++) {\n            const opts = scale.options.pointLabels.setContext(scale.getContext(i));\n            padding[i] = opts.padding;\n            pointPosition = scale.getPointPosition(i, scale.drawingArea + padding[i]);\n            const plFont = toFont(opts.font);\n            scale.ctx.font = plFont.string;\n            textSize = measureLabelSize(scale.ctx, plFont.lineHeight, scale._pointLabels[i]);\n            labelSizes[i] = textSize;\n            const angleRadians = scale.getIndexAngle(i);\n            const angle = toDegrees(angleRadians);\n            const hLimits = determineLimits(angle, pointPosition.x, textSize.w, 0, 180);\n            const vLimits = determineLimits(angle, pointPosition.y, textSize.h, 90, 270);\n            if (hLimits.start < furthestLimits.l) {\n                furthestLimits.l = hLimits.start;\n                furthestAngles.l = angleRadians;\n            }\n            if (hLimits.end > furthestLimits.r) {\n                furthestLimits.r = hLimits.end;\n                furthestAngles.r = angleRadians;\n            }\n            if (vLimits.start < furthestLimits.t) {\n                furthestLimits.t = vLimits.start;\n                furthestAngles.t = angleRadians;\n            }\n            if (vLimits.end > furthestLimits.b) {\n                furthestLimits.b = vLimits.end;\n                furthestAngles.b = angleRadians;\n            }\n        }\n        scale._setReductions(scale.drawingArea, furthestLimits, furthestAngles);\n        scale._pointLabelItems = [];\n        const opts = scale.options;\n        const tickBackdropHeight = getTickBackdropHeight(opts);\n        const outerDistance = scale.getDistanceFromCenterForValue(opts.ticks.reverse ? scale.min : scale.max);\n        for (i = 0; i < valueCount; i++) {\n            const extra = (i === 0 ? tickBackdropHeight / 2 : 0);\n            const pointLabelPosition = scale.getPointPosition(i, outerDistance + extra + padding[i]);\n            const angle = toDegrees(scale.getIndexAngle(i));\n            const size = labelSizes[i];\n            adjustPointPositionForLabelHeight(angle, size, pointLabelPosition);\n            const textAlign = getTextAlignForAngle(angle);\n            let left;\n            if (textAlign === 'left') {\n                left = pointLabelPosition.x;\n            } else if (textAlign === 'center') {\n                left = pointLabelPosition.x - (size.w / 2);\n            } else {\n                left = pointLabelPosition.x - size.w;\n            }\n            const right = left + size.w;\n            scale._pointLabelItems[i] = {\n                x: pointLabelPosition.x,\n                y: pointLabelPosition.y,\n                textAlign,\n                left,\n                top: pointLabelPosition.y,\n                right,\n                bottom: pointLabelPosition.y + size.h,\n            };\n        }\n    }\n    function getTextAlignForAngle(angle) {\n        if (angle === 0 || angle === 180) {\n            return 'center';\n        } else if (angle < 180) {\n            return 'left';\n        }\n        return 'right';\n    }\n    function adjustPointPositionForLabelHeight(angle, textSize, position) {\n        if (angle === 90 || angle === 270) {\n            position.y -= (textSize.h / 2);\n        } else if (angle > 270 || angle < 90) {\n            position.y -= textSize.h;\n        }\n    }\n    function drawPointLabels(scale, labelCount) {\n        const {ctx, options: {pointLabels}} = scale;\n        for (let i = labelCount - 1; i >= 0; i--) {\n            const optsAtIndex = pointLabels.setContext(scale.getContext(i));\n            const plFont = toFont(optsAtIndex.font);\n            const {x, y, textAlign, left, top, right, bottom} = scale._pointLabelItems[i];\n            const {backdropColor} = optsAtIndex;\n            if (!isNullOrUndef(backdropColor)) {\n                const padding = toPadding(optsAtIndex.backdropPadding);\n                ctx.fillStyle = backdropColor;\n                ctx.fillRect(left - padding.left, top - padding.top, right - left + padding.width, bottom - top + padding.height);\n            }\n            renderText(\n                ctx,\n                scale._pointLabels[i],\n                x,\n                y + (plFont.lineHeight / 2),\n                plFont,\n                {\n                    color: optsAtIndex.color,\n                    textAlign: textAlign,\n                    textBaseline: 'middle'\n                }\n            );\n        }\n    }\n    function pathRadiusLine(scale, radius, circular, labelCount) {\n        const {ctx} = scale;\n        if (circular) {\n            ctx.arc(scale.xCenter, scale.yCenter, radius, 0, TAU);\n        } else {\n            let pointPosition = scale.getPointPosition(0, radius);\n            ctx.moveTo(pointPosition.x, pointPosition.y);\n            for (let i = 1; i < labelCount; i++) {\n                pointPosition = scale.getPointPosition(i, radius);\n                ctx.lineTo(pointPosition.x, pointPosition.y);\n            }\n        }\n    }\n    function drawRadiusLine(scale, gridLineOpts, radius, labelCount) {\n        const ctx = scale.ctx;\n        const circular = gridLineOpts.circular;\n        const {color, lineWidth} = gridLineOpts;\n        if ((!circular && !labelCount) || !color || !lineWidth || radius < 0) {\n            return;\n        }\n        ctx.save();\n        ctx.strokeStyle = color;\n        ctx.lineWidth = lineWidth;\n        ctx.setLineDash(gridLineOpts.borderDash);\n        ctx.lineDashOffset = gridLineOpts.borderDashOffset;\n        ctx.beginPath();\n        pathRadiusLine(scale, radius, circular, labelCount);\n        ctx.closePath();\n        ctx.stroke();\n        ctx.restore();\n    }\n    function numberOrZero(param) {\n        return isNumber(param) ? param : 0;\n    }\n    class RadialLinearScale extends LinearScaleBase {\n        constructor(cfg) {\n            super(cfg);\n            this.xCenter = undefined;\n            this.yCenter = undefined;\n            this.drawingArea = undefined;\n            this._pointLabels = [];\n            this._pointLabelItems = [];\n        }\n        setDimensions() {\n            const me = this;\n            me.width = me.maxWidth;\n            me.height = me.maxHeight;\n            me.paddingTop = getTickBackdropHeight(me.options) / 2;\n            me.xCenter = Math.floor(me.width / 2);\n            me.yCenter = Math.floor((me.height - me.paddingTop) / 2);\n            me.drawingArea = Math.min(me.height - me.paddingTop, me.width) / 2;\n        }\n        determineDataLimits() {\n            const me = this;\n            const {min, max} = me.getMinMax(false);\n            me.min = isNumberFinite(min) && !isNaN(min) ? min : 0;\n            me.max = isNumberFinite(max) && !isNaN(max) ? max : 0;\n            me.handleTickRangeOptions();\n        }\n        computeTickLimit() {\n            return Math.ceil(this.drawingArea / getTickBackdropHeight(this.options));\n        }\n        generateTickLabels(ticks) {\n            const me = this;\n            LinearScaleBase.prototype.generateTickLabels.call(me, ticks);\n            me._pointLabels = me.getLabels().map((value, index) => {\n                const label = callback(me.options.pointLabels.callback, [value, index], me);\n                return label || label === 0 ? label : '';\n            });\n        }\n        fit() {\n            const me = this;\n            const opts = me.options;\n            if (opts.display && opts.pointLabels.display) {\n                fitWithPointLabels(me);\n            } else {\n                me.setCenterPoint(0, 0, 0, 0);\n            }\n        }\n        _setReductions(largestPossibleRadius, furthestLimits, furthestAngles) {\n            const me = this;\n            let radiusReductionLeft = furthestLimits.l / Math.sin(furthestAngles.l);\n            let radiusReductionRight = Math.max(furthestLimits.r - me.width, 0) / Math.sin(furthestAngles.r);\n            let radiusReductionTop = -furthestLimits.t / Math.cos(furthestAngles.t);\n            let radiusReductionBottom = -Math.max(furthestLimits.b - (me.height - me.paddingTop), 0) / Math.cos(furthestAngles.b);\n            radiusReductionLeft = numberOrZero(radiusReductionLeft);\n            radiusReductionRight = numberOrZero(radiusReductionRight);\n            radiusReductionTop = numberOrZero(radiusReductionTop);\n            radiusReductionBottom = numberOrZero(radiusReductionBottom);\n            me.drawingArea = Math.max(largestPossibleRadius / 2, Math.min(\n                Math.floor(largestPossibleRadius - (radiusReductionLeft + radiusReductionRight) / 2),\n                Math.floor(largestPossibleRadius - (radiusReductionTop + radiusReductionBottom) / 2)));\n            me.setCenterPoint(radiusReductionLeft, radiusReductionRight, radiusReductionTop, radiusReductionBottom);\n        }\n        setCenterPoint(leftMovement, rightMovement, topMovement, bottomMovement) {\n            const me = this;\n            const maxRight = me.width - rightMovement - me.drawingArea;\n            const maxLeft = leftMovement + me.drawingArea;\n            const maxTop = topMovement + me.drawingArea;\n            const maxBottom = (me.height - me.paddingTop) - bottomMovement - me.drawingArea;\n            me.xCenter = Math.floor(((maxLeft + maxRight) / 2) + me.left);\n            me.yCenter = Math.floor(((maxTop + maxBottom) / 2) + me.top + me.paddingTop);\n        }\n        getIndexAngle(index) {\n            const angleMultiplier = TAU / this.getLabels().length;\n            const startAngle = this.options.startAngle || 0;\n            return _normalizeAngle(index * angleMultiplier + toRadians(startAngle));\n        }\n        getDistanceFromCenterForValue(value) {\n            const me = this;\n            if (isNullOrUndef(value)) {\n                return NaN;\n            }\n            const scalingFactor = me.drawingArea / (me.max - me.min);\n            if (me.options.reverse) {\n                return (me.max - value) * scalingFactor;\n            }\n            return (value - me.min) * scalingFactor;\n        }\n        getValueForDistanceFromCenter(distance) {\n            if (isNullOrUndef(distance)) {\n                return NaN;\n            }\n            const me = this;\n            const scaledDistance = distance / (me.drawingArea / (me.max - me.min));\n            return me.options.reverse ? me.max - scaledDistance : me.min + scaledDistance;\n        }\n        getPointPosition(index, distanceFromCenter) {\n            const me = this;\n            const angle = me.getIndexAngle(index) - HALF_PI;\n            return {\n                x: Math.cos(angle) * distanceFromCenter + me.xCenter,\n                y: Math.sin(angle) * distanceFromCenter + me.yCenter,\n                angle\n            };\n        }\n        getPointPositionForValue(index, value) {\n            return this.getPointPosition(index, this.getDistanceFromCenterForValue(value));\n        }\n        getBasePosition(index) {\n            return this.getPointPositionForValue(index || 0, this.getBaseValue());\n        }\n        getPointLabelPosition(index) {\n            const {left, top, right, bottom} = this._pointLabelItems[index];\n            return {\n                left,\n                top,\n                right,\n                bottom,\n            };\n        }\n        drawBackground() {\n            const me = this;\n            const {backgroundColor, grid: {circular}} = me.options;\n            if (backgroundColor) {\n                const ctx = me.ctx;\n                ctx.save();\n                ctx.beginPath();\n                pathRadiusLine(me, me.getDistanceFromCenterForValue(me._endValue), circular, me.getLabels().length);\n                ctx.closePath();\n                ctx.fillStyle = backgroundColor;\n                ctx.fill();\n                ctx.restore();\n            }\n        }\n        drawGrid() {\n            const me = this;\n            const ctx = me.ctx;\n            const opts = me.options;\n            const {angleLines, grid} = opts;\n            const labelCount = me.getLabels().length;\n            let i, offset, position;\n            if (opts.pointLabels.display) {\n                drawPointLabels(me, labelCount);\n            }\n            if (grid.display) {\n                me.ticks.forEach((tick, index) => {\n                    if (index !== 0) {\n                        offset = me.getDistanceFromCenterForValue(tick.value);\n                        const optsAtIndex = grid.setContext(me.getContext(index - 1));\n                        drawRadiusLine(me, optsAtIndex, offset, labelCount);\n                    }\n                });\n            }\n            if (angleLines.display) {\n                ctx.save();\n                for (i = me.getLabels().length - 1; i >= 0; i--) {\n                    const optsAtIndex = angleLines.setContext(me.getContext(i));\n                    const {color, lineWidth} = optsAtIndex;\n                    if (!lineWidth || !color) {\n                        continue;\n                    }\n                    ctx.lineWidth = lineWidth;\n                    ctx.strokeStyle = color;\n                    ctx.setLineDash(optsAtIndex.borderDash);\n                    ctx.lineDashOffset = optsAtIndex.borderDashOffset;\n                    offset = me.getDistanceFromCenterForValue(opts.ticks.reverse ? me.min : me.max);\n                    position = me.getPointPosition(i, offset);\n                    ctx.beginPath();\n                    ctx.moveTo(me.xCenter, me.yCenter);\n                    ctx.lineTo(position.x, position.y);\n                    ctx.stroke();\n                }\n                ctx.restore();\n            }\n        }\n        drawBorder() {}\n        drawLabels() {\n            const me = this;\n            const ctx = me.ctx;\n            const opts = me.options;\n            const tickOpts = opts.ticks;\n            if (!tickOpts.display) {\n                return;\n            }\n            const startAngle = me.getIndexAngle(0);\n            let offset, width;\n            ctx.save();\n            ctx.translate(me.xCenter, me.yCenter);\n            ctx.rotate(startAngle);\n            ctx.textAlign = 'center';\n            ctx.textBaseline = 'middle';\n            me.ticks.forEach((tick, index) => {\n                if (index === 0 && !opts.reverse) {\n                    return;\n                }\n                const optsAtIndex = tickOpts.setContext(me.getContext(index));\n                const tickFont = toFont(optsAtIndex.font);\n                offset = me.getDistanceFromCenterForValue(me.ticks[index].value);\n                if (optsAtIndex.showLabelBackdrop) {\n                    width = ctx.measureText(tick.label).width;\n                    ctx.fillStyle = optsAtIndex.backdropColor;\n                    const padding = toPadding(optsAtIndex.backdropPadding);\n                    ctx.fillRect(\n                        -width / 2 - padding.left,\n                        -offset - tickFont.size / 2 - padding.top,\n                        width + padding.width,\n                        tickFont.size + padding.height\n                    );\n                }\n                renderText(ctx, tick.label, 0, -offset, tickFont, {\n                    color: optsAtIndex.color,\n                });\n            });\n            ctx.restore();\n        }\n        drawTitle() {}\n    }\n    RadialLinearScale.id = 'radialLinear';\n    RadialLinearScale.defaults = {\n        display: true,\n        animate: true,\n        position: 'chartArea',\n        angleLines: {\n            display: true,\n            lineWidth: 1,\n            borderDash: [],\n            borderDashOffset: 0.0\n        },\n        grid: {\n            circular: false\n        },\n        startAngle: 0,\n        ticks: {\n            showLabelBackdrop: true,\n            callback: Ticks.formatters.numeric\n        },\n        pointLabels: {\n            backdropColor: undefined,\n            backdropPadding: 2,\n            display: true,\n            font: {\n                size: 10\n            },\n            callback(label) {\n                return label;\n            },\n            padding: 5\n        }\n    };\n    RadialLinearScale.defaultRoutes = {\n        'angleLines.color': 'borderColor',\n        'pointLabels.color': 'color',\n        'ticks.color': 'color'\n    };\n    RadialLinearScale.descriptors = {\n        angleLines: {\n            _fallback: 'grid'\n        }\n    };\n\n    const INTERVALS = {\n        millisecond: {common: true, size: 1, steps: 1000},\n        second: {common: true, size: 1000, steps: 60},\n        minute: {common: true, size: 60000, steps: 60},\n        hour: {common: true, size: 3600000, steps: 24},\n        day: {common: true, size: 86400000, steps: 30},\n        week: {common: false, size: 604800000, steps: 4},\n        month: {common: true, size: 2.628e9, steps: 12},\n        quarter: {common: false, size: 7.884e9, steps: 4},\n        year: {common: true, size: 3.154e10}\n    };\n    const UNITS = (Object.keys(INTERVALS));\n    function sorter(a, b) {\n        return a - b;\n    }\n    function parse(scale, input) {\n        if (isNullOrUndef(input)) {\n            return null;\n        }\n        const adapter = scale._adapter;\n        const {parser, round, isoWeekday} = scale._parseOpts;\n        let value = input;\n        if (typeof parser === 'function') {\n            value = parser(value);\n        }\n        if (!isNumberFinite(value)) {\n            value = typeof parser === 'string'\n                ? adapter.parse(value, parser)\n                : adapter.parse(value);\n        }\n        if (value === null) {\n            return null;\n        }\n        if (round) {\n            value = round === 'week' && (isNumber(isoWeekday) || isoWeekday === true)\n                ? adapter.startOf(value, 'isoWeek', isoWeekday)\n                : adapter.startOf(value, round);\n        }\n        return +value;\n    }\n    function determineUnitForAutoTicks(minUnit, min, max, capacity) {\n        const ilen = UNITS.length;\n        for (let i = UNITS.indexOf(minUnit); i < ilen - 1; ++i) {\n            const interval = INTERVALS[UNITS[i]];\n            const factor = interval.steps ? interval.steps : Number.MAX_SAFE_INTEGER;\n            if (interval.common && Math.ceil((max - min) / (factor * interval.size)) <= capacity) {\n                return UNITS[i];\n            }\n        }\n        return UNITS[ilen - 1];\n    }\n    function determineUnitForFormatting(scale, numTicks, minUnit, min, max) {\n        for (let i = UNITS.length - 1; i >= UNITS.indexOf(minUnit); i--) {\n            const unit = UNITS[i];\n            if (INTERVALS[unit].common && scale._adapter.diff(max, min, unit) >= numTicks - 1) {\n                return unit;\n            }\n        }\n        return UNITS[minUnit ? UNITS.indexOf(minUnit) : 0];\n    }\n    function determineMajorUnit(unit) {\n        for (let i = UNITS.indexOf(unit) + 1, ilen = UNITS.length; i < ilen; ++i) {\n            if (INTERVALS[UNITS[i]].common) {\n                return UNITS[i];\n            }\n        }\n    }\n    function addTick(ticks, time, timestamps) {\n        if (!timestamps) {\n            ticks[time] = true;\n        } else if (timestamps.length) {\n            const {lo, hi} = _lookup(timestamps, time);\n            const timestamp = timestamps[lo] >= time ? timestamps[lo] : timestamps[hi];\n            ticks[timestamp] = true;\n        }\n    }\n    function setMajorTicks(scale, ticks, map, majorUnit) {\n        const adapter = scale._adapter;\n        const first = +adapter.startOf(ticks[0].value, majorUnit);\n        const last = ticks[ticks.length - 1].value;\n        let major, index;\n        for (major = first; major <= last; major = +adapter.add(major, 1, majorUnit)) {\n            index = map[major];\n            if (index >= 0) {\n                ticks[index].major = true;\n            }\n        }\n        return ticks;\n    }\n    function ticksFromTimestamps(scale, values, majorUnit) {\n        const ticks = [];\n        const map = {};\n        const ilen = values.length;\n        let i, value;\n        for (i = 0; i < ilen; ++i) {\n            value = values[i];\n            map[value] = i;\n            ticks.push({\n                value,\n                major: false\n            });\n        }\n        return (ilen === 0 || !majorUnit) ? ticks : setMajorTicks(scale, ticks, map, majorUnit);\n    }\n    class TimeScale extends Scale {\n        constructor(props) {\n            super(props);\n            this._cache = {\n                data: [],\n                labels: [],\n                all: []\n            };\n            this._unit = 'day';\n            this._majorUnit = undefined;\n            this._offsets = {};\n            this._normalized = false;\n            this._parseOpts = undefined;\n        }\n        init(scaleOpts, opts) {\n            const time = scaleOpts.time || (scaleOpts.time = {});\n            const adapter = this._adapter = new _adapters._date(scaleOpts.adapters.date);\n            mergeIf(time.displayFormats, adapter.formats());\n            this._parseOpts = {\n                parser: time.parser,\n                round: time.round,\n                isoWeekday: time.isoWeekday\n            };\n            super.init(scaleOpts);\n            this._normalized = opts.normalized;\n        }\n        parse(raw, index) {\n            if (raw === undefined) {\n                return null;\n            }\n            return parse(this, raw);\n        }\n        beforeLayout() {\n            super.beforeLayout();\n            this._cache = {\n                data: [],\n                labels: [],\n                all: []\n            };\n        }\n        determineDataLimits() {\n            const me = this;\n            const options = me.options;\n            const adapter = me._adapter;\n            const unit = options.time.unit || 'day';\n            let {min, max, minDefined, maxDefined} = me.getUserBounds();\n            function _applyBounds(bounds) {\n                if (!minDefined && !isNaN(bounds.min)) {\n                    min = Math.min(min, bounds.min);\n                }\n                if (!maxDefined && !isNaN(bounds.max)) {\n                    max = Math.max(max, bounds.max);\n                }\n            }\n            if (!minDefined || !maxDefined) {\n                _applyBounds(me._getLabelBounds());\n                if (options.bounds !== 'ticks' || options.ticks.source !== 'labels') {\n                    _applyBounds(me.getMinMax(false));\n                }\n            }\n            min = isNumberFinite(min) && !isNaN(min) ? min : +adapter.startOf(Date.now(), unit);\n            max = isNumberFinite(max) && !isNaN(max) ? max : +adapter.endOf(Date.now(), unit) + 1;\n            me.min = Math.min(min, max - 1);\n            me.max = Math.max(min + 1, max);\n        }\n        _getLabelBounds() {\n            const arr = this.getLabelTimestamps();\n            let min = Number.POSITIVE_INFINITY;\n            let max = Number.NEGATIVE_INFINITY;\n            if (arr.length) {\n                min = arr[0];\n                max = arr[arr.length - 1];\n            }\n            return {min, max};\n        }\n        buildTicks() {\n            const me = this;\n            const options = me.options;\n            const timeOpts = options.time;\n            const tickOpts = options.ticks;\n            const timestamps = tickOpts.source === 'labels' ? me.getLabelTimestamps() : me._generate();\n            if (options.bounds === 'ticks' && timestamps.length) {\n                me.min = me._userMin || timestamps[0];\n                me.max = me._userMax || timestamps[timestamps.length - 1];\n            }\n            const min = me.min;\n            const max = me.max;\n            const ticks = _filterBetween(timestamps, min, max);\n            me._unit = timeOpts.unit || (tickOpts.autoSkip\n                ? determineUnitForAutoTicks(timeOpts.minUnit, me.min, me.max, me._getLabelCapacity(min))\n                : determineUnitForFormatting(me, ticks.length, timeOpts.minUnit, me.min, me.max));\n            me._majorUnit = !tickOpts.major.enabled || me._unit === 'year' ? undefined\n                : determineMajorUnit(me._unit);\n            me.initOffsets(timestamps);\n            if (options.reverse) {\n                ticks.reverse();\n            }\n            return ticksFromTimestamps(me, ticks, me._majorUnit);\n        }\n        initOffsets(timestamps) {\n            const me = this;\n            let start = 0;\n            let end = 0;\n            let first, last;\n            if (me.options.offset && timestamps.length) {\n                first = me.getDecimalForValue(timestamps[0]);\n                if (timestamps.length === 1) {\n                    start = 1 - first;\n                } else {\n                    start = (me.getDecimalForValue(timestamps[1]) - first) / 2;\n                }\n                last = me.getDecimalForValue(timestamps[timestamps.length - 1]);\n                if (timestamps.length === 1) {\n                    end = last;\n                } else {\n                    end = (last - me.getDecimalForValue(timestamps[timestamps.length - 2])) / 2;\n                }\n            }\n            const limit = timestamps.length < 3 ? 0.5 : 0.25;\n            start = _limitValue(start, 0, limit);\n            end = _limitValue(end, 0, limit);\n            me._offsets = {start, end, factor: 1 / (start + 1 + end)};\n        }\n        _generate() {\n            const me = this;\n            const adapter = me._adapter;\n            const min = me.min;\n            const max = me.max;\n            const options = me.options;\n            const timeOpts = options.time;\n            const minor = timeOpts.unit || determineUnitForAutoTicks(timeOpts.minUnit, min, max, me._getLabelCapacity(min));\n            const stepSize = valueOrDefault(timeOpts.stepSize, 1);\n            const weekday = minor === 'week' ? timeOpts.isoWeekday : false;\n            const hasWeekday = isNumber(weekday) || weekday === true;\n            const ticks = {};\n            let first = min;\n            let time, count;\n            if (hasWeekday) {\n                first = +adapter.startOf(first, 'isoWeek', weekday);\n            }\n            first = +adapter.startOf(first, hasWeekday ? 'day' : minor);\n            if (adapter.diff(max, min, minor) > 100000 * stepSize) {\n                throw new Error(min + ' and ' + max + ' are too far apart with stepSize of ' + stepSize + ' ' + minor);\n            }\n            const timestamps = options.ticks.source === 'data' && me.getDataTimestamps();\n            for (time = first, count = 0; time < max; time = +adapter.add(time, stepSize, minor), count++) {\n                addTick(ticks, time, timestamps);\n            }\n            if (time === max || options.bounds === 'ticks' || count === 1) {\n                addTick(ticks, time, timestamps);\n            }\n            return Object.keys(ticks).sort((a, b) => a - b).map(x => +x);\n        }\n        getLabelForValue(value) {\n            const me = this;\n            const adapter = me._adapter;\n            const timeOpts = me.options.time;\n            if (timeOpts.tooltipFormat) {\n                return adapter.format(value, timeOpts.tooltipFormat);\n            }\n            return adapter.format(value, timeOpts.displayFormats.datetime);\n        }\n        _tickFormatFunction(time, index, ticks, format) {\n            const me = this;\n            const options = me.options;\n            const formats = options.time.displayFormats;\n            const unit = me._unit;\n            const majorUnit = me._majorUnit;\n            const minorFormat = unit && formats[unit];\n            const majorFormat = majorUnit && formats[majorUnit];\n            const tick = ticks[index];\n            const major = majorUnit && majorFormat && tick && tick.major;\n            const label = me._adapter.format(time, format || (major ? majorFormat : minorFormat));\n            const formatter = options.ticks.callback;\n            return formatter ? callback(formatter, [label, index, ticks], me) : label;\n        }\n        generateTickLabels(ticks) {\n            let i, ilen, tick;\n            for (i = 0, ilen = ticks.length; i < ilen; ++i) {\n                tick = ticks[i];\n                tick.label = this._tickFormatFunction(tick.value, i, ticks);\n            }\n        }\n        getDecimalForValue(value) {\n            const me = this;\n            return value === null ? NaN : (value - me.min) / (me.max - me.min);\n        }\n        getPixelForValue(value) {\n            const me = this;\n            const offsets = me._offsets;\n            const pos = me.getDecimalForValue(value);\n            return me.getPixelForDecimal((offsets.start + pos) * offsets.factor);\n        }\n        getValueForPixel(pixel) {\n            const me = this;\n            const offsets = me._offsets;\n            const pos = me.getDecimalForPixel(pixel) / offsets.factor - offsets.end;\n            return me.min + pos * (me.max - me.min);\n        }\n        _getLabelSize(label) {\n            const me = this;\n            const ticksOpts = me.options.ticks;\n            const tickLabelWidth = me.ctx.measureText(label).width;\n            const angle = toRadians(me.isHorizontal() ? ticksOpts.maxRotation : ticksOpts.minRotation);\n            const cosRotation = Math.cos(angle);\n            const sinRotation = Math.sin(angle);\n            const tickFontSize = me._resolveTickFontOptions(0).size;\n            return {\n                w: (tickLabelWidth * cosRotation) + (tickFontSize * sinRotation),\n                h: (tickLabelWidth * sinRotation) + (tickFontSize * cosRotation)\n            };\n        }\n        _getLabelCapacity(exampleTime) {\n            const me = this;\n            const timeOpts = me.options.time;\n            const displayFormats = timeOpts.displayFormats;\n            const format = displayFormats[timeOpts.unit] || displayFormats.millisecond;\n            const exampleLabel = me._tickFormatFunction(exampleTime, 0, ticksFromTimestamps(me, [exampleTime], me._majorUnit), format);\n            const size = me._getLabelSize(exampleLabel);\n            const capacity = Math.floor(me.isHorizontal() ? me.width / size.w : me.height / size.h) - 1;\n            return capacity > 0 ? capacity : 1;\n        }\n        getDataTimestamps() {\n            const me = this;\n            let timestamps = me._cache.data || [];\n            let i, ilen;\n            if (timestamps.length) {\n                return timestamps;\n            }\n            const metas = me.getMatchingVisibleMetas();\n            if (me._normalized && metas.length) {\n                return (me._cache.data = metas[0].controller.getAllParsedValues(me));\n            }\n            for (i = 0, ilen = metas.length; i < ilen; ++i) {\n                timestamps = timestamps.concat(metas[i].controller.getAllParsedValues(me));\n            }\n            return (me._cache.data = me.normalize(timestamps));\n        }\n        getLabelTimestamps() {\n            const me = this;\n            const timestamps = me._cache.labels || [];\n            let i, ilen;\n            if (timestamps.length) {\n                return timestamps;\n            }\n            const labels = me.getLabels();\n            for (i = 0, ilen = labels.length; i < ilen; ++i) {\n                timestamps.push(parse(me, labels[i]));\n            }\n            return (me._cache.labels = me._normalized ? timestamps : me.normalize(timestamps));\n        }\n        normalize(values) {\n            return _arrayUnique(values.sort(sorter));\n        }\n    }\n    TimeScale.id = 'time';\n    TimeScale.defaults = {\n        bounds: 'data',\n        adapters: {},\n        time: {\n            parser: false,\n            unit: false,\n            round: false,\n            isoWeekday: false,\n            minUnit: 'millisecond',\n            displayFormats: {}\n        },\n        ticks: {\n            source: 'auto',\n            major: {\n                enabled: false\n            }\n        }\n    };\n\n    function interpolate(table, val, reverse) {\n        let prevSource, nextSource, prevTarget, nextTarget;\n        if (reverse) {\n            prevSource = Math.floor(val);\n            nextSource = Math.ceil(val);\n            prevTarget = table[prevSource];\n            nextTarget = table[nextSource];\n        } else {\n            const result = _lookup(table, val);\n            prevTarget = result.lo;\n            nextTarget = result.hi;\n            prevSource = table[prevTarget];\n            nextSource = table[nextTarget];\n        }\n        const span = nextSource - prevSource;\n        return span ? prevTarget + (nextTarget - prevTarget) * (val - prevSource) / span : prevTarget;\n    }\n    class TimeSeriesScale extends TimeScale {\n        constructor(props) {\n            super(props);\n            this._table = [];\n            this._maxIndex = undefined;\n        }\n        initOffsets() {\n            const me = this;\n            const timestamps = me._getTimestampsForTable();\n            me._table = me.buildLookupTable(timestamps);\n            me._maxIndex = me._table.length - 1;\n            super.initOffsets(timestamps);\n        }\n        buildLookupTable(timestamps) {\n            const me = this;\n            const {min, max} = me;\n            if (!timestamps.length) {\n                return [\n                    {time: min, pos: 0},\n                    {time: max, pos: 1}\n                ];\n            }\n            const items = [min];\n            let i, ilen, curr;\n            for (i = 0, ilen = timestamps.length; i < ilen; ++i) {\n                curr = timestamps[i];\n                if (curr > min && curr < max) {\n                    items.push(curr);\n                }\n            }\n            items.push(max);\n            return items;\n        }\n        _getTimestampsForTable() {\n            const me = this;\n            let timestamps = me._cache.all || [];\n            if (timestamps.length) {\n                return timestamps;\n            }\n            const data = me.getDataTimestamps();\n            const label = me.getLabelTimestamps();\n            if (data.length && label.length) {\n                timestamps = me.normalize(data.concat(label));\n            } else {\n                timestamps = data.length ? data : label;\n            }\n            timestamps = me._cache.all = timestamps;\n            return timestamps;\n        }\n        getPixelForValue(value, index) {\n            const me = this;\n            const offsets = me._offsets;\n            const pos = me._normalized && me._maxIndex > 0 && !isNullOrUndef(index)\n                ? index / me._maxIndex : me.getDecimalForValue(value);\n            return me.getPixelForDecimal((offsets.start + pos) * offsets.factor);\n        }\n        getDecimalForValue(value) {\n            return interpolate(this._table, value) / this._maxIndex;\n        }\n        getValueForPixel(pixel) {\n            const me = this;\n            const offsets = me._offsets;\n            const decimal = me.getDecimalForPixel(pixel) / offsets.factor - offsets.end;\n            return interpolate(me._table, decimal * this._maxIndex, true);\n        }\n    }\n    TimeSeriesScale.id = 'timeseries';\n    TimeSeriesScale.defaults = TimeScale.defaults;\n\n    var scales = /*#__PURE__*/Object.freeze({\n        __proto__: null,\n        CategoryScale: CategoryScale,\n        LinearScale: LinearScale,\n        LogarithmicScale: LogarithmicScale,\n        RadialLinearScale: RadialLinearScale,\n        TimeScale: TimeScale,\n        TimeSeriesScale: TimeSeriesScale\n    });\n\n    Chart.register(controllers, scales, elements, plugins);\n    Chart.helpers = {...helpers};\n    Chart._adapters = _adapters;\n    Chart.Animation = Animation;\n    Chart.Animations = Animations;\n    Chart.animator = animator;\n    Chart.controllers = registry.controllers.items;\n    Chart.DatasetController = DatasetController;\n    Chart.Element = Element;\n    Chart.elements = elements;\n    Chart.Interaction = Interaction;\n    Chart.layouts = layouts;\n    Chart.platforms = platforms;\n    Chart.Scale = Scale;\n    Chart.Ticks = Ticks;\n    Object.assign(Chart, controllers, scales, elements, plugins, platforms);\n    Chart.Chart = Chart;\n    if (typeof window !== 'undefined') {\n        window.Chart = Chart;\n    }\n\n    return Chart;\n\n})));\n","Smile_ElasticsuiteCore/js/validation/validator-mixin.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCore\n * @author    Botis <botis@smile.fr>\n * @copyright 2021 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (validator) {\n        validator.addRule(\n            'not-zero',\n            function (value, element) {\n                return parseInt(value) !== 0;\n            },\n            $.mage.__('The value should be different to zero.')\n        );\n\n        return validator;\n    }\n});\n\n","Hyva_Theme/js/form/element/validator-rules-mixin.js":"/**\n * Hyv\u00e4 Themes - https://hyva.io\n * Copyright \u00a9 Hyv\u00e4 Themes 2020-present. All rights reserved.\n * This product is licensed per Magento install\n * See https://hyva.io/license\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/lib/validation/utils'\n], function ($, _, utils) {\n    'use strict';\n\n    /**\n     * Validate string could be a TailwindCSS class\n     *\n     * This function overrides the original PageBuilder CSS class validator to allow TailwindCSS classes with : # . [] and more\n     *\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateTailwindCssClass(str) {\n        return (/^[a-zA-Z0-9 _(),.:![\\]#\\-\\d\\/%]+$/i).test(str);\n    }\n\n\n    /**\n     * Override the original PageBuilder validate-css-class validator to allow TailwindCSS classes\n     *\n     * @param {Function} validator\n     * @param {String} ruleName\n     */\n    return function (validator) {\n\n        validator.addRule(\n            'validate-css-class',\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                return validateTailwindCssClass(value);\n            },\n            $.mage.__('Please enter a valid CSS class.')\n        );\n        return validator;\n    };\n});\n","Hyva_Theme/js/pagebuilder/form/element/background-lazy-loading-toggle.js":"/**\n * Hyv\u00e4 Themes - https://hyva.io\n * Copyright \u00a9 Hyv\u00e4 Themes 2020-present. All rights reserved.\n * This product is licensed per Magento install\n * See https://hyva.io/license\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_PageBuilder/js/config',\n    'uiRegistry'\n], function (SingleCheckbox, pageBuilderConfig, registry) {\n    'use strict';\n\n    return SingleCheckbox.extend({\n        initialize(options) {\n            this._super(options);\n\n            // The regular configured default value from pagebuilder_base_form_with_background_attributes.xml is\n            // overridden by ko listeners, so they don't take effect.\n\n            // If this is a new element, enforce the default value after the listeners are initialized.\n            const dataProvider = registry.get(options.provider);\n            if (dataProvider && dataProvider.data.background_lazy_load === '') {\n                this.default = pageBuilderConfig.getConfig('background_lazy_load_default')\n                    ? this.valueMap.true\n                    : this.valueMap.false\n                this.value(this.default);\n                this.initialValue = this.default;\n                this.checked(this.getReverseValueMap(this.default));\n                this.initialChecked = this.checked();\n            }\n        }\n    });\n});\n","Hyva_Theme/js/pagebuilder/form/element/image-dimension-input.js":"/**\n * Hyv\u00e4 Themes - https://hyva.io\n * Copyright \u00a9 Hyv\u00e4 Themes 2020-present. All rights reserved.\n * This product is licensed per Magento install\n * See https://hyva.io/license\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Input) {\n    'use strict';\n\n    return Input.extend({\n        initObservable() {\n            this._super();\n\n            // Reset value to \"\" when native_dimensions toggle is set to true\n            this.visible.subscribe(isVisible => {\n                if (! isVisible) {\n                    this.value('');\n                }\n            });\n\n            return this;\n        }\n    });\n});\n","Hyva_Theme/js/pagebuilder/form/element/image-dimensions-toggle.js":"/**\n * Hyv\u00e4 Themes - https://hyva.io\n * Copyright \u00a9 Hyv\u00e4 Themes 2020-present. All rights reserved.\n * This product is licensed per Magento install\n * See https://hyva.io/license\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (SingleCheckbox) {\n    'use strict';\n\n    return SingleCheckbox.extend({\n        initialize(options) {\n            this._super(options);\n\n            this.showRelatedElement(this.value());\n\n            return this;\n        },\n\n        initObservable() {\n            this._super();\n\n            // Expose boolean properties so other fields can be shown/hidden depending on the toggle state\n            this.observe('useNativeDimensions');\n            this.observe('useManualDimensions');\n\n            return this;\n        },\n\n        onUpdate(value) {\n            this.showRelatedElement(value);\n\n            return this._super();\n        },\n\n        showRelatedElement: function (value) {\n            this.useNativeDimensions(value === this.valueMap.true);\n            this.useManualDimensions(value !== this.valueMap.true);\n\n            return this;\n        }\n    });\n});\n","js/theme.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine('globalNavigationScroll', [\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var win = $(window),\n        subMenuClass = '.submenu',\n        fixedClassName = '_fixed',\n        menu = $('.menu-wrapper'),\n        content = $('.page-wrapper'),\n        menuItems = $('#nav').children('li'),\n        winHeight,\n        menuHeight = menu.height(),\n        menuScrollMax = 0,\n        submenuHeight = 0,\n        contentHeight,\n        winTop = 0,\n        winTopLast = 0,\n        scrollStep = 0,\n        nextTop = 0;\n\n    /**\n     * Check if menu is fixed\n     * @returns {Boolean}\n     */\n    function isMenuFixed() {\n        return menuHeight < contentHeight && contentHeight > winHeight;\n    }\n\n    /**\n     * Check if class exist than add or do nothing\n     * @param {jQuery} el\n     * @param {String} $class\n     */\n    function checkAddClass(el, $class) {\n        if (!el.hasClass($class)) {\n            el.addClass($class);\n        }\n    }\n\n    /**\n     * Check if class exist than remove or do nothing\n     * @param {jQuery} el\n     * @param {String} $class\n     */\n    function checkRemoveClass(el, $class) {\n        if (el.hasClass($class)) {\n            el.removeClass($class);\n        }\n    }\n\n    /**\n     * Calculate and apply menu position\n     */\n    function positionMenu() {\n\n        //  Spotting positions and heights\n        winHeight = win.height();\n        contentHeight = content.height();\n        winTop = win.scrollTop();\n        scrollStep = winTop - winTopLast;\n\n        if (isMenuFixed()) { // fixed menu cases\n\n            checkAddClass(menu, fixedClassName);\n\n            if (menuHeight > winHeight) { // smart scroll cases\n\n                if (winTop > winTopLast) { //eslint-disable-line max-depth\n\n                    menuScrollMax = menuHeight - winHeight;\n\n                    nextTop < menuScrollMax - scrollStep ?\n                        nextTop += scrollStep : nextTop = menuScrollMax;\n\n                    menu.css('top', -nextTop);\n\n                } else if (winTop <= winTopLast) { // scroll up\n\n                    nextTop > -scrollStep ?\n                        nextTop += scrollStep : nextTop = 0;\n\n                    menu.css('top', -nextTop);\n\n                }\n\n            }\n\n        } else { // static menu cases\n            checkRemoveClass(menu, fixedClassName);\n            menu.css('top', 'auto');\n        }\n\n        //  Save previous window scrollTop\n        winTopLast = winTop;\n\n    }\n\n    positionMenu(); // page start calculation\n\n    //  Change position on scroll\n    win.on('scroll', function () {\n        positionMenu();\n    });\n\n    win.on('resize', function () {\n\n        winHeight = win.height();\n\n        //  Reset position if fixed and out of smart scroll\n        if (menuHeight < contentHeight && menuHeight <= winHeight) {\n            menu.removeAttr('style');\n            menuItems.off();\n        }\n\n    });\n\n    //  Add event to menuItems to check submenu overlap\n    menuItems.on('click', function () {\n\n        var submenu = $(this).children(subMenuClass),\n            delta,\n            logo = $('.logo')[0].offsetHeight;\n\n        submenuHeight = submenu.height();\n\n        if (submenuHeight > menuHeight && menuHeight + logo > winHeight) {\n            menu.height(submenuHeight - logo);\n            delta = -menu.position().top;\n            window.scrollTo(0, 0);\n            positionMenu();\n            window.scrollTo(0, delta);\n            positionMenu();\n            menuHeight = submenuHeight;\n        }\n    });\n\n});\n\ndefine('globalNavigation', [\n    'jquery',\n    'jquery/ui',\n    'globalNavigationScroll'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.globalNavigation', {\n        options: {\n            selectors: {\n                menu: '#nav',\n                currentItem: '._current',\n                topLevelItem: '.level-0',\n                topLevelHref: '> a',\n                subMenu: '> .submenu',\n                closeSubmenuBtn: '[data-role=\"close-submenu\"]'\n            },\n            overlayTmpl: '<div class=\"admin__menu-overlay\"></div>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var selectors = this.options.selectors;\n\n            this.menu = this.element;\n            this.menuLinks = $(selectors.topLevelHref, selectors.topLevelItem);\n            this.closeActions = $(selectors.closeSubmenuBtn);\n\n            this._initOverlay()\n                ._bind();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initOverlay: function () {\n            this.overlay = $(this.options.overlayTmpl).appendTo('body').hide(0);\n\n            return this;\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            var focus = this._focus.bind(this),\n                open = this._open.bind(this),\n                blur = this._blur.bind(this),\n                keyboard = this._keyboard.bind(this);\n\n            this.menuLinks\n                .on('focus', focus)\n                .on('click', open);\n\n            this.menuLinks.last().on('blur', blur);\n\n            this.closeActions.on('keydown', keyboard);\n        },\n\n        /**\n         * Remove active class from current menu item\n         * Turn back active class to current page menu item\n         */\n        _blur: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem),\n                currentItem = $(selectors.menu).find(selectors.currentItem);\n\n            menuItem.removeClass('_active');\n            currentItem.addClass('_active');\n        },\n\n        /**\n         * Add focus to active menu item\n         */\n        _keyboard: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem);\n\n            if (e.which === 13) {\n                this._close(e);\n                $(selectors.topLevelHref, menuItem).trigger('focus');\n            }\n        },\n\n        /**\n         * Toggle active state on focus\n         */\n        _focus: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = $(e.target).closest(selectors.topLevelItem);\n\n            menuItem.addClass('_active')\n                .siblings(selectors.topLevelItem)\n                .removeClass('_active');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _closeSubmenu: function (e) {\n            var selectors = this.options.selectors,\n                currentItem = $(selectors.menu).find(selectors.currentItem);\n\n            this._close(e);\n\n            currentItem.addClass('_active');\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _open: function (e) {\n            var selectors = this.options.selectors,\n                menuItemSelector = selectors.topLevelItem,\n                menuItem = $(e.target).closest(menuItemSelector),\n                subMenu = $(selectors.subMenu, menuItem),\n                close = this._closeSubmenu.bind(this),\n                closeBtn = subMenu.find(selectors.closeSubmenuBtn);\n\n            if (subMenu.length) {\n                e.preventDefault();\n            }\n            closeBtn.on('click', close);\n\n            if ($(menuItem).hasClass('_show')) {\n                closeBtn.trigger('click');\n            } else {\n                menuItem.addClass('_show')\n                    .siblings(menuItemSelector)\n                    .removeClass('_show');\n                subMenu.attr('aria-expanded', 'true');\n                this.overlay.show(0).on('click', close);\n                this.menuLinks.last().off('blur');\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} e\n         * @private\n         */\n        _close: function (e) {\n            var selectors = this.options.selectors,\n                menuItem = this.menu.find(selectors.topLevelItem + '._show'),\n                subMenu = $(selectors.subMenu, menuItem),\n                closeBtn = subMenu.find(selectors.closeSubmenuBtn),\n                blur = this._blur.bind(this);\n\n            e.preventDefault();\n\n            this.overlay.hide(0).off('click');\n\n            this.menuLinks.last().on('blur', blur);\n\n            closeBtn.off('click');\n\n            subMenu.attr('aria-expanded', 'false');\n\n            menuItem.removeClass('_show _active');\n        }\n    });\n\n    return $.mage.globalNavigation;\n});\n\ndefine('globalSearch', [\n    'jquery',\n    'Magento_Ui/js/lib/key-codes',\n    'jquery-ui-modules/widget'\n], function ($, keyCodes) {\n    'use strict';\n\n    $.widget('mage.globalSearch', {\n        options: {\n            field: '.search-global-field',\n            fieldActiveClass: '_active',\n            input: '#search-global'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.field = $(this.options.field);\n            this.input = $(this.options.input);\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.input.on('blur.resetGlobalSearchForm', function () {\n                if (!self.input.val()) {\n                    self.field.removeClass(self.options.fieldActiveClass);\n                }\n            });\n\n            this.input.on('focus.activateGlobalSearchForm', function () {\n                self.field.addClass(self.options.fieldActiveClass);\n            });\n\n            $(document).on('keydown.activateGlobalSearchForm', function (event) {\n                var inputs = [\n                    'input',\n                    'select',\n                    'textarea'\n                ];\n\n                if (keyCodes[event.which] !== 'forwardSlashKey' ||\n                    inputs.indexOf(event.target.tagName.toLowerCase()) !== -1 ||\n                    event.target.isContentEditable\n                ) {\n                    return;\n                }\n\n                event.preventDefault();\n\n                self.input.focus();\n            });\n        }\n    });\n\n    return $.mage.globalSearch;\n});\n\ndefine('modalPopup', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.modalPopup', {\n        options: {\n            popup: '.popup',\n            btnDismiss: '[data-dismiss=\"popup\"]',\n            btnHide: '[data-hide=\"popup\"]'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.fade = this.element;\n            this.popup = $(this.options.popup, this.fade);\n            this.btnDismiss = $(this.options.btnDismiss, this.popup);\n            this.btnHide = $(this.options.btnHide, this.popup);\n\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.btnDismiss\n                .on('click.dismissModalPopup', function () {\n                    self.fade.remove();\n                });\n\n            this.btnHide\n                .on('click.hideModalPopup', function () {\n                    self.fade.hide();\n                });\n        }\n    });\n\n    return $.mage.modalPopup;\n});\n\ndefine('useDefault', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.useDefault', {\n        options: {\n            field: '.field',\n            useDefault: '.use-default',\n            checkbox: '.use-default-control',\n            label: '.use-default-label'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.el = this.element;\n            this.field = $(this.el).closest(this.options.field);\n            this.useDefault = $(this.options.useDefault, this.field);\n            this.checkbox = $(this.options.checkbox, this.useDefault);\n            this.label = $(this.options.label, this.useDefault);\n            this.origValue = this.el.attr('data-store-label');\n\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.el.on(\n                    'change.toggleUseDefaultVisibility keyup.toggleUseDefaultVisibility',\n                    $.proxy(this._toggleUseDefaultVisibility, this)\n                ).trigger('change.toggleUseDefaultVisibility');\n\n            this.checkboxon('change.setOrigValue', function () {\n                if ($(this).prop('checked')) {\n                    self.el\n                        .val(self.origValue)\n                        .trigger('change.toggleUseDefaultVisibility');\n\n                    $(this).prop('checked', false);\n                }\n            });\n        },\n\n        /**\n         * @private\n         */\n        _toggleUseDefaultVisibility: function () {\n            var curValue = this.el.val(),\n                origValue = this.origValue;\n\n            this[curValue != origValue ? '_show' : '_hide'](); //eslint-disable-line eqeqeq\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            this.useDefault.show();\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            this.useDefault.hide();\n        }\n    });\n\n    return $.mage.useDefault;\n});\n\ndefine('loadingPopup', [\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.loadingPopup', {\n        options: {\n            message: 'Please wait...',\n            timeout: 5000,\n            timeoutId: null,\n            callback: null,\n            template: null\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.template =\n                '<div class=\"popup popup-loading\">' +\n                '<div class=\"popup-inner\">' + this.options.message + '</div>' +\n                '</div>';\n\n            this.popup = $(this.template);\n\n            this._show();\n            this._events();\n        },\n\n        /**\n         * @private\n         */\n        _events: function () {\n            var self = this;\n\n            this.element\n                .on('showLoadingPopup', function () {\n                    self._show();\n                })\n                .on('hideLoadingPopup', function () {\n                    self._hide();\n                });\n        },\n\n        /**\n         * @private\n         */\n        _show: function () {\n            var options = this.options,\n                timeout = options.timeout;\n\n            $('body').trigger('processStart');\n\n            if (timeout) {\n                options.timeoutId = setTimeout(this._delayedHide.bind(this), timeout);\n            }\n        },\n\n        /**\n         * @private\n         */\n        _hide: function () {\n            $('body').trigger('processStop');\n        },\n\n        /**\n         * @private\n         */\n        _delayedHide: function () {\n            this._hide();\n\n            this.options.callback && this.options.callback();\n\n            this.options.timeoutId && clearTimeout(this.options.timeoutId);\n        }\n    });\n\n    return $.mage.loadingPopup;\n});\n\ndefine('collapsable', [\n    'jquery',\n    'jquery/ui',\n    'jquery/jquery.tabs'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.collapsable', {\n        options: {\n            parent: null,\n            openedClass: 'opened',\n            wrapper: '.fieldset-wrapper'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._events();\n        },\n\n        /** @inheritdoc */\n        _events: function () {\n            var self = this;\n\n            this.element\n                .on('show.bs.collapse', function (e) {\n                    var fieldsetWrapper = $(this).closest(self.options.wrapper);\n\n                    fieldsetWrapper.addClass(self.options.openedClass);\n                    e.stopPropagation();\n                })\n                .on('hide.bs.collapse', function (e) {\n                    var fieldsetWrapper = $(this).closest(self.options.wrapper);\n\n                    fieldsetWrapper.removeClass(self.options.openedClass);\n                    e.stopPropagation();\n                });\n        }\n    });\n\n    return $.mage.collapsable;\n});\n\ndefine('js/theme', [\n    'jquery',\n    'mage/smart-keyboard-handler',\n    'collapsable',\n    'domReady!'\n], function ($, keyboardHandler) {\n    'use strict';\n\n    /* @TODO refactor collapsible as widget and avoid logic binding with such a general selectors */\n    $('.collapse').collapsable();\n\n    $.each($('.entry-edit'), function (i, entry) {\n        $('.collapse:first', entry).filter(function () {\n            return $(this).data('collapsed') !== true;\n        }).collapse('show');\n    });\n\n    keyboardHandler.apply();\n});\n","MagePal_GmailSmtpApp/js/validate-config.js":"/**\n * Copyright \u00a9 MagePal LLC. All rights reserved.\n * See COPYING.txt for license details.\n * http://www.magepal.com | support@magepal.com\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert'\n], function ($, alert) {\n\n    var formSubmit = function (config) {\n        var postData = {\n            form_key: FORM_KEY\n        };\n\n        /** global var configForm **/\n        configForm.find('[id^=system_gmailsmtpapp]').find(':input').serializeArray().map(function (field) {\n            var name = field.name.match(/groups\\[gmailsmtpapp\\]?(\\[groups\\]\\[debug\\])?\\[fields\\]\\[(.*)\\]\\[value]/);\n\n            /**\n             * groups[gmailsmtpapp][groups][debug][fields][email][value]\n             * groups[gmailsmtpapp][fields][password][value]\n             */\n\n            if (name && name.length === 3) {\n                postData[name[2]] = field.value;\n            }\n        });\n\n        $.ajax({\n            url: config.postUrl,\n            type: 'post',\n            dataType: 'html',\n            data: postData,\n            showLoader: true\n        }).done(function (response) {\n            if (typeof response === 'object') {\n                if (response.error) {\n                    alert({ title: 'Error', content: response.message });\n                } else if (response.ajaxExpired) {\n                    window.location.href = response.ajaxRedirect;\n                }\n            } else {\n                alert({\n                    title:'',\n                    content:response,\n                    buttons: []\n                });\n            }\n        });\n    };\n\n    return function (config, element) {\n        $(element).on('click', function () {\n            formSubmit(config);\n        });\n    }\n});\n","Magento_Email/js/variables.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Variables, updateElementAtCursor */\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'prototype'\n], function (jQuery, $t) {\n    'use strict';\n\n    window.Variables = {\n        textareaElementId: null,\n        variablesContent: null,\n        dialogWindow: null,\n        dialogWindowId: 'variables-chooser',\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n        insertFunction: 'Variables.insertVariable',\n        variablesValue: [],\n\n        /**\n         * @param {*} textareaElementId\n         * @param {Function} insertFunction\n         */\n        init: function (textareaElementId, insertFunction) {\n            if ($(textareaElementId)) {\n                this.textareaElementId = textareaElementId;\n            }\n\n            if (insertFunction) {\n                this.insertFunction = insertFunction;\n            }\n        },\n\n        /**\n         * reset data.\n         */\n        resetData: function () {\n            this.variablesContent = null;\n            this.dialogWindow = null;\n        },\n\n        /**\n         * @param {Object} variables\n         */\n        openVariableChooser: function (variables) {\n            if (this.variablesContent == null && variables) {\n                this.variablesContent = '<ul class=\"insert-variable\">';\n                variables.each(function (variableGroup) {\n                    if (variableGroup.label && variableGroup.value) {\n                        this.variablesContent += '<li><b>' + variableGroup.label.escapeHTML() + '</b></li>';\n                        variableGroup.value.each(function (variable) {\n                            if (variable.value && variable.label) {\n                                this.variablesValue.push(variable.value);\n                                this.variablesContent += '<li>' +\n                                    this.prepareVariableRow(this.variablesValue.length, variable.label) + '</li>';\n                            }\n                        }.bind(this));\n                    }\n                }.bind(this));\n                this.variablesContent += '</ul>';\n            }\n\n            if (this.variablesContent) {\n                this.openDialogWindow(this.variablesContent);\n            }\n        },\n\n        /**\n         * @param {*} variablesContent\n         */\n        openDialogWindow: function (variablesContent) {\n            var windowId = this.dialogWindowId;\n\n            jQuery('<div id=\"' + windowId + '\">' + variablesContent + '</div>').modal({\n                title: $t('Insert Variable...'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                }\n            });\n\n            jQuery('#' + windowId).modal('openModal');\n        },\n\n        /**\n         * Close dialog window.\n         */\n        closeDialogWindow: function () {\n            jQuery('#' + this.dialogWindowId).modal('closeModal');\n        },\n\n        /**\n         * @param {Number} index\n         * @param {*} varLabel\n         * @return {String}\n         */\n        prepareVariableRow: function (index, varLabel) {\n            return '<a href=\"#\" onclick=\"' +\n                this.insertFunction +\n                '(' +\n                index +\n                ');return false;\">' +\n                varLabel.escapeHTML() +\n                '</a>';\n        },\n\n        /**\n         * @param {*} variable\n         */\n        insertVariable: function (variable) {\n            var windowId = this.dialogWindowId,\n                textareaElm, scrollPos;\n\n            jQuery('#' + windowId).modal('closeModal');\n            textareaElm = $(this.textareaElementId);\n\n            if (textareaElm) {\n                scrollPos = textareaElm.scrollTop;\n\n                if (!isNaN(variable)) {\n                    updateElementAtCursor(textareaElm, Variables.variablesValue[variable - 1]);\n                } else {\n                    updateElementAtCursor(textareaElm, variable);\n                }\n                textareaElm.focus();\n                textareaElm.scrollTop = scrollPos;\n                jQuery(textareaElm).trigger('change');\n                textareaElm = null;\n            }\n        }\n    };\n\n    window.MagentovariablePlugin = {\n        editor: null,\n        variables: null,\n        textareaId: null,\n\n        /**\n         * @param {*} editor\n         */\n        setEditor: function (editor) {\n            this.editor = editor;\n        },\n\n        /**\n         * @param {String} url\n         * @param {*} textareaId\n         */\n        loadChooser: function (url, textareaId) {\n            this.textareaId = textareaId;\n\n            if (this.variables == null) {\n                new Ajax.Request(url, {\n                    parameters: {},\n                    onComplete: function (transport) {\n                        if (transport.responseText.isJSON()) {\n                            Variables.init(null, 'MagentovariablePlugin.insertVariable');\n                            this.variables = transport.responseText.evalJSON();\n                            this.openChooser(this.variables);\n                        }\n                    }.bind(this)\n                });\n            } else {\n                this.openChooser(this.variables);\n            }\n        },\n\n        /**\n         * @param {*} variables\n         */\n        openChooser: function (variables) {\n            Variables.openVariableChooser(variables);\n        },\n\n        /**\n         * @param {*} value\n         */\n        insertVariable: function (value) {\n            if (this.textareaId) {\n                Variables.init(this.textareaId);\n                Variables.insertVariable(value);\n            } else {\n                Variables.closeDialogWindow();\n                this.editor.execCommand('mceInsertContent', false, value);\n            }\n        }\n    };\n});\n","Magento_Vault/js/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/* @api */\ndefine([\n    'jquery',\n    'uiComponent'\n], function ($, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            fieldset: '',\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this,\n                paymentSelector = '[name=\"payment[method]\"][value=\"' + this.getCode() + '\"]:checked';\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe(['active']);\n\n            if (self.$selector.find(paymentSelector).length !== 0) {\n                this.active(true);\n            }\n\n            $('#' + self.fieldset).find('[name=\"payment[token_switcher]\"]')\n                .on('click', this.rememberTokenSwitcher.bind(this));\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.getCode())\n                .on('changePaymentMethod.' + this.getCode(), this.changePaymentMethod.bind(this));\n\n            if (this.active()) {\n                this.chooseTokenSwitcher();\n            }\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.getCode());\n\n            return this;\n        },\n\n        /**\n         * Save last chosen token switcher\n         * @param {Object} event\n         * @returns {exports.rememberTokenSwitcher}\n         */\n        rememberTokenSwitcher: function (event) {\n            $('#' + this.selector).data('lastTokenSwitcherId', event.target.id);\n\n            return this;\n        },\n\n        /**\n         * Select token switcher\n         * @returns {exports.chooseTokenSwitcher}\n         */\n        chooseTokenSwitcher: function () {\n            var lastTokenSwitcherId = $('#' + this.selector).data('lastTokenSwitcherId');\n\n            if (lastTokenSwitcherId) {\n                $('#' + lastTokenSwitcherId).trigger('click');\n            } else {\n                $('#' + this.fieldset + ' input:radio:first').trigger('click');\n            }\n\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.trigger('setVaultNotActive.' + this.getCode());\n\n                return;\n            }\n            this.chooseTokenSwitcher();\n            window.order.addExcludedPaymentMethod(this.getCode());\n        },\n\n        /**\n         * Get payment method code\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        }\n    });\n});\n","jquery/jquery.storageapi.min.js":"/* jQuery Storage API Plugin 1.7.3 https://github.com/julien-maurel/jQuery-Storage-API */\n!function(e){\"function\"==typeof define&&define.amd?define([\"jquery\", \"jquery/jquery.cookie\"],e):e(\"object\"==typeof exports?require(\"jquery\"):jQuery)}(function(e){function t(t){var r,i,n,o=arguments.length,s=window[t],a=arguments,u=a[1];if(2>o)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(u)){i={};for(var f in u){r=u[f];try{i[r]=JSON.parse(s.getItem(r))}catch(c){i[r]=s.getItem(r)}}return i}if(2!=o){try{i=JSON.parse(s.getItem(u))}catch(c){throw new ReferenceError(u+\" is not defined in this storage\")}for(var f=2;o-1>f;f++)if(i=i[a[f]],void 0===i)throw new ReferenceError([].slice.call(a,1,f+1).join(\".\")+\" is not defined in this storage\");if(e.isArray(a[f])){n=i,i={};for(var m in a[f])i[a[f][m]]=n[a[f][m]];return i}return i[a[f]]}try{return JSON.parse(s.getItem(u))}catch(c){return s.getItem(u)}}function r(t){var r,i,n=arguments.length,o=window[t],s=arguments,a=s[1],u=s[2],f={};if(2>n||!e.isPlainObject(a)&&3>n)throw Error(\"Minimum 3 arguments must be given or second parameter must be an object\");if(e.isPlainObject(a)){for(var c in a)r=a[c],e.isPlainObject(r)?o.setItem(c,JSON.stringify(r)):o.setItem(c,r);return a}if(3==n)return\"object\"==typeof u?o.setItem(a,JSON.stringify(u)):o.setItem(a,u),u;try{i=o.getItem(a),null!=i&&(f=JSON.parse(i))}catch(m){}i=f;for(var c=2;n-2>c;c++)r=s[c],i[r]&&e.isPlainObject(i[r])||(i[r]={}),i=i[r];return i[s[c]]=s[c+1],o.setItem(a,JSON.stringify(f)),f}function i(t){var r,i,n=arguments.length,o=window[t],s=arguments,a=s[1];if(2>n)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(a)){for(var u in a)o.removeItem(a[u]);return!0}if(2==n)return o.removeItem(a),!0;try{r=i=JSON.parse(o.getItem(a))}catch(f){throw new ReferenceError(a+\" is not defined in this storage\")}for(var u=2;n-1>u;u++)if(i=i[s[u]],void 0===i)throw new ReferenceError([].slice.call(s,1,u).join(\".\")+\" is not defined in this storage\");if(e.isArray(s[u]))for(var c in s[u])delete i[s[u][c]];else delete i[s[u]];return o.setItem(a,JSON.stringify(r)),!0}function n(t,r){var n=a(t);for(var o in n)i(t,n[o]);if(r)for(var o in e.namespaceStorages)u(o)}function o(r){var i=arguments.length,n=arguments,s=(window[r],n[1]);if(1==i)return 0==a(r).length;if(e.isArray(s)){for(var u=0;u<s.length;u++)if(!o(r,s[u]))return!1;return!0}try{var f=t.apply(this,arguments);e.isArray(n[i-1])||(f={totest:f});for(var u in f)if(!(e.isPlainObject(f[u])&&e.isEmptyObject(f[u])||e.isArray(f[u])&&!f[u].length)&&f[u])return!1;return!0}catch(c){return!0}}function s(r){var i=arguments.length,n=arguments,o=(window[r],n[1]);if(2>i)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(o)){for(var a=0;a<o.length;a++)if(!s(r,o[a]))return!1;return!0}try{var u=t.apply(this,arguments);e.isArray(n[i-1])||(u={totest:u});for(var a in u)if(void 0===u[a]||null===u[a])return!1;return!0}catch(f){return!1}}function a(r){var i=arguments.length,n=window[r],o=arguments,s=(o[1],[]),a={};if(a=i>1?t.apply(this,o):n,a._cookie)for(var u in e.cookie())\"\"!=u&&s.push(u.replace(a._prefix,\"\"));else for(var f in a)s.push(f);return s}function u(t){if(!t||\"string\"!=typeof t)throw Error(\"First parameter must be a string\");g?(window.localStorage.getItem(t)||window.localStorage.setItem(t,\"{}\"),window.sessionStorage.getItem(t)||window.sessionStorage.setItem(t,\"{}\")):(window.localCookieStorage.getItem(t)||window.localCookieStorage.setItem(t,\"{}\"),window.sessionCookieStorage.getItem(t)||window.sessionCookieStorage.setItem(t,\"{}\"));var r={localStorage:e.extend({},e.localStorage,{_ns:t}),sessionStorage:e.extend({},e.sessionStorage,{_ns:t})};return e.cookie&&(window.cookieStorage.getItem(t)||window.cookieStorage.setItem(t,\"{}\"),r.cookieStorage=e.extend({},e.cookieStorage,{_ns:t})),e.namespaceStorages[t]=r,r}function f(e){if(!window[e])return!1;var t=\"jsapi\";try{return window[e].setItem(t,t),window[e].removeItem(t),!0}catch(r){return!1}}var c=\"ls_\",m=\"ss_\",g=f(\"localStorage\"),h={_type:\"\",_ns:\"\",_callMethod:function(e,t){var r=[this._type],t=Array.prototype.slice.call(t),i=t[0];return this._ns&&r.push(this._ns),\"string\"==typeof i&&-1!==i.indexOf(\".\")&&(t.shift(),[].unshift.apply(t,i.split(\".\"))),[].push.apply(r,t),e.apply(this,r)},get:function(){return this._callMethod(t,arguments)},set:function(){var t=arguments.length,i=arguments,n=i[0];if(1>t||!e.isPlainObject(n)&&2>t)throw Error(\"Minimum 2 arguments must be given or first parameter must be an object\");if(e.isPlainObject(n)&&this._ns){for(var o in n)r(this._type,this._ns,o,n[o]);return n}var s=this._callMethod(r,i);return this._ns?s[n.split(\".\")[0]]:s},remove:function(){if(arguments.length<1)throw Error(\"Minimum 1 argument must be given\");return this._callMethod(i,arguments)},removeAll:function(e){return this._ns?(r(this._type,this._ns,{}),!0):n(this._type,e)},isEmpty:function(){return this._callMethod(o,arguments)},isSet:function(){if(arguments.length<1)throw Error(\"Minimum 1 argument must be given\");return this._callMethod(s,arguments)},keys:function(){return this._callMethod(a,arguments)}};if(e.cookie){window.name||(window.name=Math.floor(1e8*Math.random()));var l={_cookie:!0,_prefix:\"\",_expires:null,_path:null,_domain:null,setItem:function(t,r){e.cookie(this._prefix+t,r,{expires:this._expires,path:this._path,domain:this._domain})},getItem:function(t){return e.cookie(this._prefix+t)},removeItem:function(t){return e.removeCookie(this._prefix+t)},clear:function(){for(var t in e.cookie())\"\"!=t&&(!this._prefix&&-1===t.indexOf(c)&&-1===t.indexOf(m)||this._prefix&&0===t.indexOf(this._prefix))&&e.removeCookie(t)},setExpires:function(e){return this._expires=e,this},setPath:function(e){return this._path=e,this},setDomain:function(e){return this._domain=e,this},setConf:function(e){return e.path&&(this._path=e.path),e.domain&&(this._domain=e.domain),e.expires&&(this._expires=e.expires),this},setDefaultConf:function(){this._path=this._domain=this._expires=null}};g||(window.localCookieStorage=e.extend({},l,{_prefix:c,_expires:3650}),window.sessionCookieStorage=e.extend({},l,{_prefix:m+window.name+\"_\"})),window.cookieStorage=e.extend({},l),e.cookieStorage=e.extend({},h,{_type:\"cookieStorage\",setExpires:function(e){return window.cookieStorage.setExpires(e),this},setPath:function(e){return window.cookieStorage.setPath(e),this},setDomain:function(e){return window.cookieStorage.setDomain(e),this},setConf:function(e){return window.cookieStorage.setConf(e),this},setDefaultConf:function(){return window.cookieStorage.setDefaultConf(),this}})}e.initNamespaceStorage=function(e){return u(e)},g?(e.localStorage=e.extend({},h,{_type:\"localStorage\"}),e.sessionStorage=e.extend({},h,{_type:\"sessionStorage\"})):(e.localStorage=e.extend({},h,{_type:\"localCookieStorage\"}),e.sessionStorage=e.extend({},h,{_type:\"sessionCookieStorage\"})),e.namespaceStorages={},e.removeAllStorages=function(t){e.localStorage.removeAll(t),e.sessionStorage.removeAll(t),e.cookieStorage&&e.cookieStorage.removeAll(t),t||(e.namespaceStorages={})}});\n","jquery/jquery.validate.js":"/*!\n * jQuery Validation Plugin v1.19.5\n *\n * https://jqueryvalidation.org/\n *\n * Copyright (c) 2022 J\u00f6rn Zaefferer\n * Released under the MIT license\n */\n(function( factory ) {\n    if ( typeof define === \"function\" && define.amd ) {\n        define( [\"jquery\", \"jquery/jquery.metadata\"], factory );\n    } else if (typeof module === \"object\" && module.exports) {\n        module.exports = factory( require( \"jquery\" ) );\n    } else {\n        factory( jQuery );\n    }\n}(function( $ ) {\n\n    $.extend( $.fn, {\n\n        // https://jqueryvalidation.org/validate/\n        validate: function( options ) {\n\n            // If nothing is selected, return nothing; can't chain anyway\n            if ( !this.length ) {\n                if ( options && options.debug && window.console ) {\n                    console.warn( \"Nothing selected, can't validate, returning nothing.\" );\n                }\n                return;\n            }\n\n            // Check if a validator for this form was already created\n            var validator = $.data( this[ 0 ], \"validator\" );\n            if ( validator ) {\n                return validator;\n            }\n\n            // Add novalidate tag if HTML5.\n            this.attr( \"novalidate\", \"novalidate\" );\n\n            validator = new $.validator( options, this[ 0 ] );\n            $.data( this[ 0 ], \"validator\", validator );\n\n            if ( validator.settings.onsubmit ) {\n\n                this.on( \"click.validate\", \":submit\", function( event ) {\n\n                    // Track the used submit button to properly handle scripted\n                    // submits later.\n                    validator.submitButton = event.currentTarget;\n\n                    // Allow suppressing validation by adding a cancel class to the submit button\n                    if ( $( this ).hasClass( \"cancel\" ) ) {\n                        validator.cancelSubmit = true;\n                    }\n\n                    // Allow suppressing validation by adding the html5 formnovalidate attribute to the submit button\n                    if ( $( this ).attr( \"formnovalidate\" ) !== undefined ) {\n                        validator.cancelSubmit = true;\n                    }\n                } );\n\n                // Validate the form on submit\n                this.on( \"submit.validate\", function( event ) {\n                    if ( validator.settings.debug ) {\n\n                        // Prevent form submit to be able to see console output\n                        event.preventDefault();\n                    }\n\n                    function handle() {\n                        var hidden, result;\n\n                        // Insert a hidden input as a replacement for the missing submit button\n                        // The hidden input is inserted in two cases:\n                        //   - A user defined a `submitHandler`\n                        //   - There was a pending request due to `remote` method and `stopRequest()`\n                        //     was called to submit the form in case it's valid\n                        if ( validator.submitButton && ( validator.settings.submitHandler || validator.formSubmitted ) ) {\n                            hidden = $( \"<input type='hidden'/>\" )\n                                .attr( \"name\", validator.submitButton.name )\n                                .val( $( validator.submitButton ).val() )\n                                .appendTo( validator.currentForm );\n                        }\n\n                        if ( validator.settings.submitHandler && !validator.settings.debug ) {\n                            result = validator.settings.submitHandler.call( validator, validator.currentForm, event );\n                            if ( hidden ) {\n\n                                // And clean up afterwards; thanks to no-block-scope, hidden can be referenced\n                                hidden.remove();\n                            }\n                            if ( result !== undefined ) {\n                                return result;\n                            }\n                            return false;\n                        }\n                        return true;\n                    }\n\n                    // Prevent submit for invalid forms or custom submit handlers\n                    if ( validator.cancelSubmit ) {\n                        validator.cancelSubmit = false;\n                        return handle();\n                    }\n                    if ( validator.form() ) {\n                        if ( validator.pendingRequest ) {\n                            validator.formSubmitted = true;\n                            return false;\n                        }\n                        return handle();\n                    } else {\n                        validator.focusInvalid();\n                        return false;\n                    }\n                } );\n            }\n\n            return validator;\n        },\n\n        // https://jqueryvalidation.org/valid/\n        valid: function() {\n            var valid, validator, errorList;\n\n            if ( $( this[ 0 ] ).is( \"form\" ) ) {\n                valid = this.validate().form();\n            } else {\n                errorList = [];\n                valid = true;\n                validator = $( this[ 0 ].form ).validate();\n                this.each( function() {\n                    valid = validator.element( this ) && valid;\n                    if ( !valid ) {\n                        errorList = errorList.concat( validator.errorList );\n                    }\n                } );\n                validator.errorList = errorList;\n            }\n            return valid;\n        },\n\n        // https://jqueryvalidation.org/rules/\n        rules: function( command, argument ) {\n            var element = this[ 0 ],\n                isContentEditable = typeof this.attr( \"contenteditable\" ) !== \"undefined\" && this.attr( \"contenteditable\" ) !== \"false\",\n                settings, staticRules, existingRules, data, param, filtered;\n\n            // If nothing is selected, return empty object; can't chain anyway\n            if ( element == null ) {\n                return;\n            }\n\n            if ( !element.form && isContentEditable ) {\n                element.form = this.closest( \"form\" )[ 0 ];\n                element.name = this.attr( \"name\" );\n            }\n\n            if ( element.form == null ) {\n                return;\n            }\n\n            if ( command ) {\n                settings = $.data( element.form, \"validator\" ).settings;\n                staticRules = settings.rules;\n                existingRules = $.validator.staticRules( element );\n                switch ( command ) {\n                    case \"add\":\n                        $.extend( existingRules, $.validator.normalizeRule( argument ) );\n\n                        // Remove messages from rules, but allow them to be set separately\n                        delete existingRules.messages;\n                        staticRules[ element.name ] = existingRules;\n                        if ( argument.messages ) {\n                            settings.messages[ element.name ] = $.extend( settings.messages[ element.name ], argument.messages );\n                        }\n                        break;\n                    case \"remove\":\n                        if ( !argument ) {\n                            delete staticRules[ element.name ];\n                            return existingRules;\n                        }\n                        filtered = {};\n                        $.each( argument.split( /\\s/ ), function( index, method ) {\n                            filtered[ method ] = existingRules[ method ];\n                            delete existingRules[ method ];\n                        } );\n                        return filtered;\n                }\n            }\n\n            data = $.validator.normalizeRules(\n                $.extend(\n                    {},\n                    $.validator.metadataRules(element),\n                    $.validator.classRules( element ),\n                    $.validator.attributeRules( element ),\n                    $.validator.dataRules( element ),\n                    $.validator.staticRules( element )\n                ), element );\n\n            // Make sure required is at front\n            if ( data.required ) {\n                param = data.required;\n                delete data.required;\n                data = $.extend( { required: param }, data );\n            }\n\n            // Make sure remote is at back\n            if ( data.remote ) {\n                param = data.remote;\n                delete data.remote;\n                data = $.extend( data, { remote: param } );\n            }\n\n            return data;\n        }\n    } );\n\n// JQuery trim is deprecated, provide a trim method based on String.prototype.trim\n    var trim = function( str ) {\n\n        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/trim#Polyfill\n        return str.replace( /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, \"\" );\n    };\n\n// Custom selectors\n    $.extend( $.expr.pseudos || $.expr[ \":\" ], {\t\t// '|| $.expr[ \":\" ]' here enables backwards compatibility to jQuery 1.7. Can be removed when dropping jQ 1.7.x support\n\n        // https://jqueryvalidation.org/blank-selector/\n        blank: function( a ) {\n            return !trim( \"\" + $( a ).val() );\n        },\n\n        // https://jqueryvalidation.org/filled-selector/\n        filled: function( a ) {\n            var val = $( a ).val();\n            return val !== null && !!trim( \"\" + val );\n        },\n\n        // https://jqueryvalidation.org/unchecked-selector/\n        unchecked: function( a ) {\n            return !$( a ).prop( \"checked\" );\n        }\n    } );\n\n// Constructor for validator\n    $.validator = function( options, form ) {\n        this.settings = $.extend( true, {}, $.validator.defaults, options );\n        this.currentForm = form;\n        this.init();\n    };\n\n// https://jqueryvalidation.org/jQuery.validator.format/\n    $.validator.format = function( source, params ) {\n        if ( arguments.length === 1 ) {\n            return function() {\n                var args = $.makeArray( arguments );\n                args.unshift( source );\n                return $.validator.format.apply( this, args );\n            };\n        }\n        if ( params === undefined ) {\n            return source;\n        }\n        if ( arguments.length > 2 && params.constructor !== Array  ) {\n            params = $.makeArray( arguments ).slice( 1 );\n        }\n        if ( params.constructor !== Array ) {\n            params = [ params ];\n        }\n        $.each( params, function( i, n ) {\n            source = source.replace( new RegExp( \"\\\\{\" + i + \"\\\\}\", \"g\" ), function() {\n                return n;\n            } );\n        } );\n        return source;\n    };\n\n    $.extend( $.validator, {\n\n        defaults: {\n            messages: {},\n            groups: {},\n            rules: {},\n            errorClass: \"error\",\n            pendingClass: \"pending\",\n            validClass: \"valid\",\n            errorElement: \"label\",\n            focusCleanup: false,\n            focusInvalid: true,\n            errorContainer: $( [] ),\n            errorLabelContainer: $( [] ),\n            onsubmit: true,\n            ignore: \":hidden\",\n            ignoreTitle: false,\n            onfocusin: function( element ) {\n                this.lastActive = element;\n\n                // Hide error label and remove error class on focus if enabled\n                if ( this.settings.focusCleanup ) {\n                    if ( this.settings.unhighlight ) {\n                        this.settings.unhighlight.call( this, element, this.settings.errorClass, this.settings.validClass );\n                    }\n                    this.hideThese( this.errorsFor( element ) );\n                }\n            },\n            onfocusout: function( element ) {\n                if ( !this.checkable( element ) && ( element.name in this.submitted || !this.optional( element ) ) ) {\n                    this.element( element );\n                }\n            },\n            onkeyup: function( element, event ) {\n\n                // Avoid revalidate the field when pressing one of the following keys\n                // Shift       => 16\n                // Ctrl        => 17\n                // Alt         => 18\n                // Caps lock   => 20\n                // End         => 35\n                // Home        => 36\n                // Left arrow  => 37\n                // Up arrow    => 38\n                // Right arrow => 39\n                // Down arrow  => 40\n                // Insert      => 45\n                // Num lock    => 144\n                // AltGr key   => 225\n                var excludedKeys = [\n                    16, 17, 18, 20, 35, 36, 37,\n                    38, 39, 40, 45, 144, 225\n                ];\n\n                if ( event.which === 9 && this.elementValue( element ) === \"\" || $.inArray( event.keyCode, excludedKeys ) !== -1 ) {\n                    return;\n                } else if ( element.name in this.submitted || element.name in this.invalid ) {\n                    this.element( element );\n                }\n            },\n            onclick: function( element ) {\n\n                // Click on selects, radiobuttons and checkboxes\n                if ( element.name in this.submitted ) {\n                    this.element( element );\n\n                    // Or option elements, check parent select in that case\n                } else if ( element.parentNode.name in this.submitted ) {\n                    this.element( element.parentNode );\n                }\n            },\n            highlight: function( element, errorClass, validClass ) {\n                if ( element.type === \"radio\" ) {\n                    this.findByName( element.name ).addClass( errorClass ).removeClass( validClass );\n                } else {\n                    $( element ).addClass( errorClass ).removeClass( validClass );\n                }\n            },\n            unhighlight: function( element, errorClass, validClass ) {\n                if ( element.type === \"radio\" ) {\n                    this.findByName( element.name ).removeClass( errorClass ).addClass( validClass );\n                } else {\n                    $( element ).removeClass( errorClass ).addClass( validClass );\n                }\n            }\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.setDefaults/\n        setDefaults: function( settings ) {\n            $.extend( $.validator.defaults, settings );\n        },\n\n        messages: {\n            required: \"This field is required.\",\n            remote: \"Please fix this field.\",\n            email: \"Please enter a valid email address.\",\n            url: \"Please enter a valid URL.\",\n            date: \"Please enter a valid date.\",\n            dateISO: \"Please enter a valid date (ISO).\",\n            number: \"Please enter a valid number.\",\n            digits: \"Please enter only digits.\",\n            equalTo: \"Please enter the same value again.\",\n            maxlength: $.validator.format( \"Please enter no more than {0} characters.\" ),\n            minlength: $.validator.format( \"Please enter at least {0} characters.\" ),\n            rangelength: $.validator.format( \"Please enter a value between {0} and {1} characters long.\" ),\n            range: $.validator.format( \"Please enter a value between {0} and {1}.\" ),\n            max: $.validator.format( \"Please enter a value less than or equal to {0}.\" ),\n            min: $.validator.format( \"Please enter a value greater than or equal to {0}.\" ),\n            step: $.validator.format( \"Please enter a multiple of {0}.\" )\n        },\n\n        autoCreateRanges: false,\n\n        prototype: {\n\n            init: function() {\n                this.labelContainer = $( this.settings.errorLabelContainer );\n                this.errorContext = this.labelContainer.length && this.labelContainer || $( this.currentForm );\n                this.containers = $( this.settings.errorContainer ).add( this.settings.errorLabelContainer );\n                this.submitted = {};\n                this.valueCache = {};\n                this.pendingRequest = 0;\n                this.pending = {};\n                this.invalid = {};\n                this.reset();\n\n                var currentForm = this.currentForm,\n                    groups = ( this.groups = {} ),\n                    rules;\n                $.each( this.settings.groups, function( key, value ) {\n                    if ( typeof value === \"string\" ) {\n                        value = value.split( /\\s/ );\n                    }\n                    $.each( value, function( index, name ) {\n                        groups[ name ] = key;\n                    } );\n                } );\n                rules = this.settings.rules;\n                $.each( rules, function( key, value ) {\n                    rules[ key ] = $.validator.normalizeRule( value );\n                } );\n\n                function delegate( event ) {\n                    var isContentEditable = typeof $( this ).attr( \"contenteditable\" ) !== \"undefined\" && $( this ).attr( \"contenteditable\" ) !== \"false\";\n\n                    // Set form expando on contenteditable\n                    if ( !this.form && isContentEditable ) {\n                        this.form = $( this ).closest( \"form\" )[ 0 ];\n                        this.name = $( this ).attr( \"name\" );\n                    }\n\n                    // Ignore the element if it belongs to another form. This will happen mainly\n                    // when setting the `form` attribute of an input to the id of another form.\n                    if ( currentForm !== this.form ) {\n                        return;\n                    }\n\n                    var validator = $.data( this.form, \"validator\" ),\n                        eventType = \"on\" + event.type.replace( /^validate/, \"\" ),\n                        settings = validator.settings;\n                    if ( settings[ eventType ] && !$( this ).is( settings.ignore ) ) {\n                        settings[ eventType ].call( validator, this, event );\n                    }\n                }\n\n                $( this.currentForm )\n                    .on( \"focusin.validate focusout.validate keyup.validate\",\n                        \":text, [type='password'], [type='file'], select, textarea, [type='number'], [type='search'], \" +\n                        \"[type='tel'], [type='url'], [type='email'], [type='datetime'], [type='date'], [type='month'], \" +\n                        \"[type='week'], [type='time'], [type='datetime-local'], [type='range'], [type='color'], \" +\n                        \"[type='radio'], [type='checkbox'], [contenteditable], [type='button']\", delegate )\n\n                    // Support: Chrome, oldIE\n                    // \"select\" is provided as event.target when clicking a option\n                    .on( \"click.validate\", \"select, option, [type='radio'], [type='checkbox']\", delegate );\n\n                if ( this.settings.invalidHandler ) {\n                    $( this.currentForm ).on( \"invalid-form.validate\", this.settings.invalidHandler );\n                }\n            },\n\n            // https://jqueryvalidation.org/Validator.form/\n            form: function() {\n                this.checkForm();\n                $.extend( this.submitted, this.errorMap );\n                this.invalid = $.extend( {}, this.errorMap );\n                if ( !this.valid() ) {\n                    $( this.currentForm ).triggerHandler( \"invalid-form\", [ this ] );\n                }\n                this.showErrors();\n                return this.valid();\n            },\n\n            checkForm: function() {\n                this.prepareForm();\n                for ( var i = 0, elements = ( this.currentElements = this.elements() ); elements[ i ]; i++ ) {\n                    this.check( elements[ i ] );\n                }\n                return this.valid();\n            },\n\n            // https://jqueryvalidation.org/Validator.element/\n            element: function( element ) {\n                var cleanElement = this.clean( element ),\n                    checkElement = this.validationTargetFor( cleanElement ),\n                    v = this,\n                    result = true,\n                    rs, group;\n\n                if ( checkElement === undefined ) {\n                    delete this.invalid[ cleanElement.name ];\n                } else {\n                    this.prepareElement( checkElement );\n                    this.currentElements = $( checkElement );\n\n                    // If this element is grouped, then validate all group elements already\n                    // containing a value\n                    group = this.groups[ checkElement.name ];\n                    if ( group ) {\n                        $.each( this.groups, function( name, testgroup ) {\n                            if ( testgroup === group && name !== checkElement.name ) {\n                                cleanElement = v.validationTargetFor( v.clean( v.findByName( name ) ) );\n                                if ( cleanElement && cleanElement.name in v.invalid ) {\n                                    v.currentElements.push( cleanElement );\n                                    result = v.check( cleanElement ) && result;\n                                }\n                            }\n                        } );\n                    }\n\n                    rs = this.check( checkElement ) !== false;\n                    result = result && rs;\n                    if ( rs ) {\n                        this.invalid[ checkElement.name ] = false;\n                    } else {\n                        this.invalid[ checkElement.name ] = true;\n                    }\n\n                    if ( !this.numberOfInvalids() ) {\n\n                        // Hide error containers on last error\n                        this.toHide = this.toHide.add( this.containers );\n                    }\n                    this.showErrors();\n\n                    // Add aria-invalid status for screen readers\n                    $( element ).attr( \"aria-invalid\", !rs );\n                }\n\n                return result;\n            },\n\n            // https://jqueryvalidation.org/Validator.showErrors/\n            showErrors: function( errors ) {\n                if ( errors ) {\n                    var validator = this;\n\n                    // Add items to error list and map\n                    $.extend( this.errorMap, errors );\n                    this.errorList = $.map( this.errorMap, function( message, name ) {\n                        return {\n                            message: message,\n                            element: validator.findByName( name )[ 0 ]\n                        };\n                    } );\n\n                    // Remove items from success list\n                    this.successList = $.grep( this.successList, function( element ) {\n                        return !( element.name in errors );\n                    } );\n                }\n                if ( this.settings.showErrors ) {\n                    this.settings.showErrors.call( this, this.errorMap, this.errorList );\n                } else {\n                    this.defaultShowErrors();\n                }\n            },\n\n            // https://jqueryvalidation.org/Validator.resetForm/\n            resetForm: function() {\n                if ( $.fn.resetForm ) {\n                    $( this.currentForm ).resetForm();\n                }\n                this.invalid = {};\n                this.submitted = {};\n                this.prepareForm();\n                this.hideErrors();\n                var elements = this.elements()\n                    .removeData( \"previousValue\" )\n                    .removeAttr( \"aria-invalid\" );\n\n                this.resetElements( elements );\n            },\n\n            resetElements: function( elements ) {\n                var i;\n\n                if ( this.settings.unhighlight ) {\n                    for ( i = 0; elements[ i ]; i++ ) {\n                        this.settings.unhighlight.call( this, elements[ i ],\n                            this.settings.errorClass, \"\" );\n                        this.findByName( elements[ i ].name ).removeClass( this.settings.validClass );\n                    }\n                } else {\n                    elements\n                        .removeClass( this.settings.errorClass )\n                        .removeClass( this.settings.validClass );\n                }\n            },\n\n            numberOfInvalids: function() {\n                return this.objectLength( this.invalid );\n            },\n\n            objectLength: function( obj ) {\n                /* jshint unused: false */\n                var count = 0,\n                    i;\n                for ( i in obj ) {\n\n                    // This check allows counting elements with empty error\n                    // message as invalid elements\n                    if ( obj[ i ] !== undefined && obj[ i ] !== null && obj[ i ] !== false ) {\n                        count++;\n                    }\n                }\n                return count;\n            },\n\n            hideErrors: function() {\n                this.hideThese( this.toHide );\n            },\n\n            hideThese: function( errors ) {\n                errors.not( this.containers ).text( \"\" );\n                this.addWrapper( errors ).hide();\n            },\n\n            valid: function() {\n                return this.size() === 0;\n            },\n\n            size: function() {\n                return this.errorList.length;\n            },\n\n            focusInvalid: function() {\n                if ( this.settings.focusInvalid ) {\n                    try {\n                        $( this.findLastActive() || this.errorList.length && this.errorList[ 0 ].element || [] )\n                            .filter( \":visible\" )\n                            .trigger( \"focus\" )\n\n                            // Manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find\n                            .trigger( \"focusin\" );\n                    } catch ( e ) {\n\n                        // Ignore IE throwing errors when focusing hidden elements\n                    }\n                }\n            },\n\n            findLastActive: function() {\n                var lastActive = this.lastActive;\n                return lastActive && $.grep( this.errorList, function( n ) {\n                    return n.element.name === lastActive.name;\n                } ).length === 1 && lastActive;\n            },\n\n            elements: function() {\n                var validator = this,\n                    rulesCache = {};\n\n                // Select all valid inputs inside the form (no submit or reset buttons)\n                return $( this.currentForm )\n                    .find( \"input, select, textarea, [contenteditable]\" )\n                    .not( \":submit, :reset, :image, :disabled\" )\n                    .not( this.settings.ignore )\n                    .filter( function() {\n                        var name = this.name || $( this ).attr( \"name\" ); // For contenteditable\n                        var isContentEditable = typeof $( this ).attr( \"contenteditable\" ) !== \"undefined\" && $( this ).attr( \"contenteditable\" ) !== \"false\";\n\n                        if ( !name && validator.settings.debug && window.console ) {\n                            console.error( \"%o has no name assigned\", this );\n                        }\n\n                        // Set form expando on contenteditable\n                        if ( isContentEditable ) {\n                            this.form = $( this ).closest( \"form\" )[ 0 ];\n                            this.name = name;\n                        }\n\n                        // Ignore elements that belong to other/nested forms\n                        if ( this.form !== validator.currentForm ) {\n                            return false;\n                        }\n\n                        // Select only the first element for each name, and only those with rules specified\n                        if ( name in rulesCache || !validator.objectLength( $( this ).rules() ) ) {\n                            return false;\n                        }\n\n                        rulesCache[ name ] = true;\n                        return true;\n                    } );\n            },\n\n            clean: function( selector ) {\n                return $( selector )[ 0 ];\n            },\n\n            errors: function() {\n                var errorClass = this.settings.errorClass.split( \" \" ).join( \".\" );\n                return $( this.settings.errorElement + \".\" + errorClass, this.errorContext );\n            },\n\n            resetInternals: function() {\n                this.successList = [];\n                this.errorList = [];\n                this.errorMap = {};\n                this.toShow = $( [] );\n                this.toHide = $( [] );\n            },\n\n            reset: function() {\n                this.resetInternals();\n                this.currentElements = $( [] );\n            },\n\n            prepareForm: function() {\n                this.reset();\n                this.toHide = this.errors().add( this.containers );\n            },\n\n            prepareElement: function( element ) {\n                this.reset();\n                this.toHide = this.errorsFor( element );\n            },\n\n            elementValue: function( element ) {\n                var $element = $( element ),\n                    type = element.type,\n                    isContentEditable = typeof $element.attr( \"contenteditable\" ) !== \"undefined\" && $element.attr( \"contenteditable\" ) !== \"false\",\n                    val, idx;\n\n                if ( type === \"radio\" || type === \"checkbox\" ) {\n                    return this.findByName( element.name ).filter( \":checked\" ).val();\n                } else if ( type === \"number\" && typeof element.validity !== \"undefined\" ) {\n                    return element.validity.badInput ? \"NaN\" : $element.val();\n                }\n\n                if ( isContentEditable ) {\n                    val = $element.text();\n                } else {\n                    val = $element.val();\n                }\n\n                if ( type === \"file\" ) {\n\n                    // Modern browser (chrome & safari)\n                    if ( val.substr( 0, 12 ) === \"C:\\\\fakepath\\\\\" ) {\n                        return val.substr( 12 );\n                    }\n\n                    // Legacy browsers\n                    // Unix-based path\n                    idx = val.lastIndexOf( \"/\" );\n                    if ( idx >= 0 ) {\n                        return val.substr( idx + 1 );\n                    }\n\n                    // Windows-based path\n                    idx = val.lastIndexOf( \"\\\\\" );\n                    if ( idx >= 0 ) {\n                        return val.substr( idx + 1 );\n                    }\n\n                    // Just the file name\n                    return val;\n                }\n\n                if ( typeof val === \"string\" ) {\n                    return val.replace( /\\r/g, \"\" );\n                }\n                return val;\n            },\n\n            check: function( element ) {\n                element = this.validationTargetFor( this.clean( element ) );\n\n                var rules = $( element ).rules(),\n                    rulesCount = $.map( rules, function( n, i ) {\n                        return i;\n                    } ).length,\n                    dependencyMismatch = false,\n                    val = this.elementValue( element ),\n                    result, method, rule, normalizer;\n\n                // Prioritize the local normalizer defined for this element over the global one\n                // if the former exists, otherwise user the global one in case it exists.\n                if ( typeof rules.normalizer === \"function\" ) {\n                    normalizer = rules.normalizer;\n                } else if (\ttypeof this.settings.normalizer === \"function\" ) {\n                    normalizer = this.settings.normalizer;\n                }\n\n                // If normalizer is defined, then call it to the changed value instead\n                // of using the real one.\n                // Note that `this` in the normalizer is `element`.\n                if ( normalizer ) {\n                    val = normalizer.call( element, val );\n\n                    // Delete the normalizer from rules to avoid treating it as a pre-defined method.\n                    delete rules.normalizer;\n                }\n\n                for ( method in rules ) {\n                    rule = { method: method, parameters: rules[ method ] };\n                    try {\n                        result = $.validator.methods[ method ].call( this, val, element, rule.parameters );\n\n                        // If a method indicates that the field is optional and therefore valid,\n                        // don't mark it as valid when there are no other rules\n                        if ( result === \"dependency-mismatch\" && rulesCount === 1 ) {\n                            dependencyMismatch = true;\n                            continue;\n                        }\n                        dependencyMismatch = false;\n\n                        if ( result === \"pending\" ) {\n                            this.toHide = this.toHide.not( this.errorsFor( element ) );\n                            return;\n                        }\n\n                        if ( !result ) {\n                            this.formatAndAdd( element, rule );\n                            return false;\n                        }\n                    } catch ( e ) {\n                        if ( this.settings.debug && window.console ) {\n                            console.log( \"Exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method.\", e );\n                        }\n                        if ( e instanceof TypeError ) {\n                            e.message += \".  Exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method.\";\n                        }\n\n                        throw e;\n                    }\n                }\n                if ( dependencyMismatch ) {\n                    return;\n                }\n                if ( this.objectLength( rules ) ) {\n                    this.successList.push( element );\n                }\n                return true;\n            },\n\n            // Return the custom message for the given element and validation method\n            // specified in the element's HTML5 data attribute\n            // return the generic message if present and no method specific message is present\n            customDataMessage: function( element, method ) {\n                return $( element ).data( \"msg\" + method.charAt( 0 ).toUpperCase() +\n                    method.substring( 1 ).toLowerCase() ) || $( element ).data( \"msg\" );\n            },\n\n            // Return the custom message for the given element name and validation method\n            customMessage: function( name, method ) {\n                var m = this.settings.messages[ name ];\n                return m && ( m.constructor === String ? m : m[ method ] );\n            },\n\n            // Return the first defined argument, allowing empty strings\n            findDefined: function() {\n                for ( var i = 0; i < arguments.length; i++ ) {\n                    if ( arguments[ i ] !== undefined ) {\n                        return arguments[ i ];\n                    }\n                }\n                return undefined;\n            },\n\n            // The second parameter 'rule' used to be a string, and extended to an object literal\n            // of the following form:\n            // rule = {\n            //     method: \"method name\",\n            //     parameters: \"the given method parameters\"\n            // }\n            //\n            // The old behavior still supported, kept to maintain backward compatibility with\n            // old code, and will be removed in the next major release.\n            defaultMessage: function( element, rule ) {\n                if ( typeof rule === \"string\" ) {\n                    rule = { method: rule };\n                }\n\n                var message = this.findDefined(\n                        this.customMessage( element.name, rule.method ),\n                        this.customDataMessage( element, rule.method ),\n\n                        // 'title' is never undefined, so handle empty string as undefined\n                        !this.settings.ignoreTitle && element.title || undefined,\n                        $.validator.messages[ rule.method ],\n                        \"<strong>Warning: No message defined for \" + element.name + \"</strong>\"\n                    ),\n                    theregex = /\\$?\\{(\\d+)\\}/g;\n                if ( typeof message === \"function\" ) {\n                    message = message.call( this, rule.parameters, element );\n                } else if ( theregex.test( message ) ) {\n                    message = $.validator.format( message.replace( theregex, \"{$1}\" ), rule.parameters );\n                }\n\n                return message;\n            },\n\n            formatAndAdd: function( element, rule ) {\n                var message = this.defaultMessage( element, rule );\n\n                this.errorList.push( {\n                    message: message,\n                    element: element,\n                    method: rule.method\n                } );\n\n                this.errorMap[ element.name ] = message;\n                this.submitted[ element.name ] = message;\n            },\n\n            addWrapper: function( toToggle ) {\n                if ( this.settings.wrapper ) {\n                    toToggle = toToggle.add( toToggle.parent( this.settings.wrapper ) );\n                }\n                return toToggle;\n            },\n\n            defaultShowErrors: function() {\n                var i, elements, error;\n                for ( i = 0; this.errorList[ i ]; i++ ) {\n                    error = this.errorList[ i ];\n                    if ( this.settings.highlight ) {\n                        this.settings.highlight.call( this, error.element, this.settings.errorClass, this.settings.validClass );\n                    }\n                    this.showLabel( error.element, error.message );\n                }\n                if ( this.errorList.length ) {\n                    this.toShow = this.toShow.add( this.containers );\n                }\n                if ( this.settings.success ) {\n                    for ( i = 0; this.successList[ i ]; i++ ) {\n                        this.showLabel( this.successList[ i ] );\n                    }\n                }\n                if ( this.settings.unhighlight ) {\n                    for ( i = 0, elements = this.validElements(); elements[ i ]; i++ ) {\n                        this.settings.unhighlight.call( this, elements[ i ], this.settings.errorClass, this.settings.validClass );\n                    }\n                }\n                this.toHide = this.toHide.not( this.toShow );\n                this.hideErrors();\n                this.addWrapper( this.toShow ).show();\n            },\n\n            validElements: function() {\n                return this.currentElements.not( this.invalidElements() );\n            },\n\n            invalidElements: function() {\n                return $( this.errorList ).map( function() {\n                    return this.element;\n                } );\n            },\n\n            showLabel: function( element, message ) {\n                var place, group, errorID, v,\n                    error = this.errorsFor( element ),\n                    elementID = this.idOrName( element ),\n                    describedBy = $( element ).attr( \"aria-describedby\" );\n\n                if ( error.length ) {\n\n                    // Refresh error/success class\n                    error.removeClass( this.settings.validClass ).addClass( this.settings.errorClass );\n\n                    // Replace message on existing label\n                    error.html( message );\n                } else {\n\n                    // Create error element\n                    error = $( \"<\" + this.settings.errorElement + \">\" )\n                        .attr( \"id\", elementID + \"-error\" )\n                        .addClass( this.settings.errorClass )\n                        .html( message || \"\" );\n\n                    // Maintain reference to the element to be placed into the DOM\n                    place = error;\n                    if ( this.settings.wrapper ) {\n\n                        // Make sure the element is visible, even in IE\n                        // actually showing the wrapped element is handled elsewhere\n                        place = error.hide().show().wrap( \"<\" + this.settings.wrapper + \"/>\" ).parent();\n                    }\n                    if ( this.labelContainer.length ) {\n                        this.labelContainer.append( place );\n                    } else if ( this.settings.errorPlacement ) {\n                        this.settings.errorPlacement.call( this, place, $( element ) );\n                    } else {\n                        place.insertAfter( element );\n                    }\n\n                    // Link error back to the element\n                    if ( error.is( \"label\" ) ) {\n\n                        // If the error is a label, then associate using 'for'\n                        error.attr( \"for\", elementID );\n\n                        // If the element is not a child of an associated label, then it's necessary\n                        // to explicitly apply aria-describedby\n                    } else if ( error.parents( \"label[for='\" + this.escapeCssMeta( elementID ) + \"']\" ).length === 0 ) {\n                        errorID = error.attr( \"id\" );\n\n                        // Respect existing non-error aria-describedby\n                        if ( !describedBy ) {\n                            describedBy = errorID;\n                        } else if ( !describedBy.match( new RegExp( \"\\\\b\" + this.escapeCssMeta( errorID ) + \"\\\\b\" ) ) ) {\n\n                            // Add to end of list if not already present\n                            describedBy += \" \" + errorID;\n                        }\n                        $( element ).attr( \"aria-describedby\", describedBy );\n\n                        // If this element is grouped, then assign to all elements in the same group\n                        group = this.groups[ element.name ];\n                        if ( group ) {\n                            v = this;\n                            $.each( v.groups, function( name, testgroup ) {\n                                if ( testgroup === group ) {\n                                    $( \"[name='\" + v.escapeCssMeta( name ) + \"']\", v.currentForm )\n                                        .attr( \"aria-describedby\", error.attr( \"id\" ) );\n                                }\n                            } );\n                        }\n                    }\n                }\n                if ( !message && this.settings.success ) {\n                    error.text( \"\" );\n                    if ( typeof this.settings.success === \"string\" ) {\n                        error.addClass( this.settings.success );\n                    } else {\n                        this.settings.success( error, element );\n                    }\n                }\n                this.toShow = this.toShow.add( error );\n            },\n\n            errorsFor: function( element ) {\n                var name = this.escapeCssMeta( this.idOrName( element ) ),\n                    describer = $( element ).attr( \"aria-describedby\" ),\n                    selector = \"label[for='\" + name + \"'], label[for='\" + name + \"'] *\";\n\n                // 'aria-describedby' should directly reference the error element\n                if ( describer ) {\n                    selector = selector + \", #\" + this.escapeCssMeta( describer )\n                        .replace( /\\s+/g, \", #\" ) + \":visible\";\n                }\n\n                return this\n                    .errors()\n                    .filter( selector );\n            },\n\n            // See https://api.jquery.com/category/selectors/, for CSS\n            // meta-characters that should be escaped in order to be used with JQuery\n            // as a literal part of a name/id or any selector.\n            escapeCssMeta: function( string ) {\n                if ( string === undefined ) {\n                    return \"\";\n                }\n\n                return string.replace( /([\\\\!\"#$%&'()*+,./:;<=>?@\\[\\]^`{|}~])/g, \"\\\\$1\" );\n            },\n\n            idOrName: function( element ) {\n                return this.groups[ element.name ] || ( this.checkable( element ) ? element.name : element.id || element.name );\n            },\n\n            validationTargetFor: function( element ) {\n\n                // If radio/checkbox, validate first element in group instead\n                if ( this.checkable( element ) ) {\n                    element = this.findByName( element.name );\n                }\n\n                // Always apply ignore filter\n                return $( element ).not( this.settings.ignore )[ 0 ];\n            },\n\n            checkable: function( element ) {\n                return ( /radio|checkbox/i ).test( element.type );\n            },\n\n            findByName: function( name ) {\n                return $( this.currentForm ).find( \"[name='\" + this.escapeCssMeta( name ) + \"']\" );\n            },\n\n            getLength: function( value, element ) {\n                switch ( element.nodeName.toLowerCase() ) {\n                    case \"select\":\n                        return $( \"option:selected\", element ).length;\n                    case \"input\":\n                        if ( this.checkable( element ) ) {\n                            return this.findByName( element.name ).filter( \":checked\" ).length;\n                        }\n                }\n                return value.length;\n            },\n\n            depend: function( param, element ) {\n                return this.dependTypes[ typeof param ] ? this.dependTypes[ typeof param ]( param, element ) : true;\n            },\n\n            dependTypes: {\n                \"boolean\": function( param ) {\n                    return param;\n                },\n                \"string\": function( param, element ) {\n                    return !!$( param, element.form ).length;\n                },\n                \"function\": function( param, element ) {\n                    return param( element );\n                }\n            },\n\n            optional: function( element ) {\n                var val = this.elementValue( element );\n                return !$.validator.methods.required.call( this, val, element ) && \"dependency-mismatch\";\n            },\n\n            startRequest: function( element ) {\n                if ( !this.pending[ element.name ] ) {\n                    this.pendingRequest++;\n                    $( element ).addClass( this.settings.pendingClass );\n                    this.pending[ element.name ] = true;\n                }\n            },\n\n            stopRequest: function( element, valid ) {\n                this.pendingRequest--;\n\n                // Sometimes synchronization fails, make sure pendingRequest is never < 0\n                if ( this.pendingRequest < 0 ) {\n                    this.pendingRequest = 0;\n                }\n                delete this.pending[ element.name ];\n                $( element ).removeClass( this.settings.pendingClass );\n                if ( valid && this.pendingRequest === 0 && this.formSubmitted && this.form() && this.pendingRequest === 0 ) {\n                    $( this.currentForm ).trigger( \"submit\" );\n\n                    // Remove the hidden input that was used as a replacement for the\n                    // missing submit button. The hidden input is added by `handle()`\n                    // to ensure that the value of the used submit button is passed on\n                    // for scripted submits triggered by this method\n                    if ( this.submitButton ) {\n                        $( \"input:hidden[name='\" + this.submitButton.name + \"']\", this.currentForm ).remove();\n                    }\n\n                    this.formSubmitted = false;\n                } else if ( !valid && this.pendingRequest === 0 && this.formSubmitted ) {\n                    $( this.currentForm ).triggerHandler( \"invalid-form\", [ this ] );\n                    this.formSubmitted = false;\n                }\n            },\n\n            previousValue: function( element, method ) {\n                method = typeof method === \"string\" && method || \"remote\";\n\n                return $.data( element, \"previousValue\" ) || $.data( element, \"previousValue\", {\n                    old: null,\n                    valid: true,\n                    message: this.defaultMessage( element, { method: method } )\n                } );\n            },\n\n            // Cleans up all forms and elements, removes validator-specific events\n            destroy: function() {\n                this.resetForm();\n\n                $( this.currentForm )\n                    .off( \".validate\" )\n                    .removeData( \"validator\" )\n                    .find( \".validate-equalTo-blur\" )\n                    .off( \".validate-equalTo\" )\n                    .removeClass( \"validate-equalTo-blur\" )\n                    .find( \".validate-lessThan-blur\" )\n                    .off( \".validate-lessThan\" )\n                    .removeClass( \"validate-lessThan-blur\" )\n                    .find( \".validate-lessThanEqual-blur\" )\n                    .off( \".validate-lessThanEqual\" )\n                    .removeClass( \"validate-lessThanEqual-blur\" )\n                    .find( \".validate-greaterThanEqual-blur\" )\n                    .off( \".validate-greaterThanEqual\" )\n                    .removeClass( \"validate-greaterThanEqual-blur\" )\n                    .find( \".validate-greaterThan-blur\" )\n                    .off( \".validate-greaterThan\" )\n                    .removeClass( \"validate-greaterThan-blur\" );\n            }\n\n        },\n\n        classRuleSettings: {\n            required: { required: true },\n            email: { email: true },\n            url: { url: true },\n            date: { date: true },\n            dateISO: { dateISO: true },\n            number: { number: true },\n            digits: { digits: true },\n            creditcard: { creditcard: true }\n        },\n\n        addClassRules: function( className, rules ) {\n            if ( className.constructor === String ) {\n                this.classRuleSettings[ className ] = rules;\n            } else {\n                $.extend( this.classRuleSettings, className );\n            }\n        },\n\n        classRules: function( element ) {\n            var rules = {},\n                classes = $( element ).attr( \"class\" );\n\n            if ( classes ) {\n                $.each( classes.split( \" \" ), function() {\n                    if ( this in $.validator.classRuleSettings ) {\n                        $.extend( rules, $.validator.classRuleSettings[ this ] );\n                    }\n                } );\n            }\n            return rules;\n        },\n\n        normalizeAttributeRule: function( rules, type, method, value ) {\n\n            // Convert the value to a number for number inputs, and for text for backwards compability\n            // allows type=\"date\" and others to be compared as strings\n            if ( /min|max|step/.test( method ) && ( type === null || /number|range|text/.test( type ) ) ) {\n                value = Number( value );\n\n                // Support Opera Mini, which returns NaN for undefined minlength\n                if ( isNaN( value ) ) {\n                    value = undefined;\n                }\n            }\n\n            if ( value || value === 0 ) {\n                rules[ method ] = value;\n            } else if ( type === method && type !== \"range\" ) {\n\n                // Exception: the jquery validate 'range' method\n                // does not test for the html5 'range' type\n                rules[ type === \"date\" ? \"dateISO\" : method ] = true;\n            }\n        },\n\n        attributeRules: function( element ) {\n            var rules = {},\n                $element = $( element ),\n                type = element.getAttribute( \"type\" ),\n                method, value;\n\n            for ( method in $.validator.methods ) {\n\n                // Support for <input required> in both html5 and older browsers\n                if ( method === \"required\" ) {\n                    value = element.getAttribute( method );\n\n                    // Some browsers return an empty string for the required attribute\n                    // and non-HTML5 browsers might have required=\"\" markup\n                    if ( value === \"\" ) {\n                        value = true;\n                    }\n\n                    // Force non-HTML5 browsers to return bool\n                    value = !!value;\n                } else {\n                    value = $element.attr( method );\n                }\n\n                this.normalizeAttributeRule( rules, type, method, value );\n            }\n\n            // 'maxlength' may be returned as -1, 2147483647 ( IE ) and 524288 ( safari ) for text inputs\n            if ( rules.maxlength && /-1|2147483647|524288/.test( rules.maxlength ) ) {\n                delete rules.maxlength;\n            }\n\n            return rules;\n        },\n\n        metadataRules: function (element) {\n            if (!$.metadata) {\n                return {};\n            }\n\n            var meta = $.data(element.form, 'validator').settings.meta;\n            return meta ?\n                $(element).metadata()[meta] :\n                $(element).metadata();\n        },\n        \n        dataRules: function( element ) {\n            var rules = {},\n                $element = $( element ),\n                type = element.getAttribute( \"type\" ),\n                method, value;\n\n            for ( method in $.validator.methods ) {\n                value = $element.data( \"rule\" + method.charAt( 0 ).toUpperCase() + method.substring( 1 ).toLowerCase() );\n\n                // Cast empty attributes like `data-rule-required` to `true`\n                if ( value === \"\" ) {\n                    value = true;\n                }\n\n                this.normalizeAttributeRule( rules, type, method, value );\n            }\n            return rules;\n        },\n\n        staticRules: function( element ) {\n            var rules = {},\n                validator = $.data( element.form, \"validator\" );\n\n            if ( validator.settings.rules ) {\n                rules = $.validator.normalizeRule( validator.settings.rules[ element.name ] ) || {};\n            }\n            return rules;\n        },\n\n        normalizeRules: function( rules, element ) {\n\n            // Handle dependency check\n            $.each( rules, function( prop, val ) {\n\n                // Ignore rule when param is explicitly false, eg. required:false\n                if ( val === false ) {\n                    delete rules[ prop ];\n                    return;\n                }\n                if ( val.param || val.depends ) {\n                    var keepRule = true;\n                    switch ( typeof val.depends ) {\n                        case \"string\":\n                            keepRule = !!$( val.depends, element.form ).length;\n                            break;\n                        case \"function\":\n                            keepRule = val.depends.call( element, element );\n                            break;\n                    }\n                    if ( keepRule ) {\n                        rules[ prop ] = val.param !== undefined ? val.param : true;\n                    } else {\n                        $.data( element.form, \"validator\" ).resetElements( $( element ) );\n                        delete rules[ prop ];\n                    }\n                }\n            } );\n\n            // Evaluate parameters\n            $.each( rules, function( rule, parameter ) {\n                rules[ rule ] = typeof parameter === \"function\" && rule !== \"normalizer\" ? parameter( element ) : parameter;\n            } );\n\n            // Clean number parameters\n            $.each( [ \"minlength\", \"maxlength\" ], function() {\n                if ( rules[ this ] ) {\n                    rules[ this ] = Number( rules[ this ] );\n                }\n            } );\n            $.each( [ \"rangelength\", \"range\" ], function() {\n                var parts;\n                if ( rules[ this ] ) {\n                    if ( Array.isArray( rules[ this ] ) ) {\n                        rules[ this ] = [ Number( rules[ this ][ 0 ] ), Number( rules[ this ][ 1 ] ) ];\n                    } else if ( typeof rules[ this ] === \"string\" ) {\n                        parts = rules[ this ].replace( /[\\[\\]]/g, \"\" ).split( /[\\s,]+/ );\n                        rules[ this ] = [ Number( parts[ 0 ] ), Number( parts[ 1 ] ) ];\n                    }\n                }\n            } );\n\n            if ( $.validator.autoCreateRanges ) {\n\n                // Auto-create ranges\n                if ( rules.min != null && rules.max != null ) {\n                    rules.range = [ rules.min, rules.max ];\n                    delete rules.min;\n                    delete rules.max;\n                }\n                if ( rules.minlength != null && rules.maxlength != null ) {\n                    rules.rangelength = [ rules.minlength, rules.maxlength ];\n                    delete rules.minlength;\n                    delete rules.maxlength;\n                }\n            }\n\n            return rules;\n        },\n\n        // Converts a simple string to a {string: true} rule, e.g., \"required\" to {required:true}\n        normalizeRule: function( data ) {\n            if ( typeof data === \"string\" ) {\n                var transformed = {};\n                $.each( data.split( /\\s/ ), function() {\n                    transformed[ this ] = true;\n                } );\n                data = transformed;\n            }\n            return data;\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.addMethod/\n        addMethod: function( name, method, message ) {\n            $.validator.methods[ name ] = method;\n            $.validator.messages[ name ] = message !== undefined ? message : $.validator.messages[ name ];\n            if ( method.length < 3 ) {\n                $.validator.addClassRules( name, $.validator.normalizeRule( name ) );\n            }\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.methods/\n        methods: {\n\n            // https://jqueryvalidation.org/required-method/\n            required: function( value, element, param ) {\n\n                // Check if dependency is met\n                if ( !this.depend( param, element ) ) {\n                    return \"dependency-mismatch\";\n                }\n                if ( element.nodeName.toLowerCase() === \"select\" ) {\n\n                    // Could be an array for select-multiple or a string, both are fine this way\n                    var val = $( element ).val();\n                    return val && val.length > 0;\n                }\n                if ( this.checkable( element ) ) {\n                    return this.getLength( value, element ) > 0;\n                }\n                return value !== undefined && value !== null && value.length > 0;\n            },\n\n            // https://jqueryvalidation.org/email-method/\n            email: function( value, element ) {\n\n                // From https://html.spec.whatwg.org/multipage/forms.html#valid-e-mail-address\n                // Retrieved 2014-01-14\n                // If you have a problem with this implementation, report a bug against the above spec\n                // Or use custom methods to implement your own email validation\n                return this.optional( element ) || /^[a-zA-Z0-9.!#$%&'*+\\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/url-method/\n            url: function( value, element ) {\n\n                // Copyright (c) 2010-2013 Diego Perini, MIT licensed\n                // https://gist.github.com/dperini/729294\n                // see also https://mathiasbynens.be/demo/url-regex\n                // modified to allow protocol-relative URLs\n                return this.optional( element ) || /^(?:(?:(?:https?|ftp):)?\\/\\/)(?:(?:[^\\]\\[?\\/<~#`!@$^&*()+=}|:\";',>{ ]|%[0-9A-Fa-f]{2})+(?::(?:[^\\]\\[?\\/<~#`!@$^&*()+=}|:\";',>{ ]|%[0-9A-Fa-f]{2})*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z0-9\\u00a1-\\uffff][a-z0-9\\u00a1-\\uffff_-]{0,62})?[a-z0-9\\u00a1-\\uffff]\\.)+(?:[a-z\\u00a1-\\uffff]{2,}\\.?))(?::\\d{2,5})?(?:[/?#]\\S*)?$/i.test( value );\n            },\n\n            // https://jqueryvalidation.org/date-method/\n            date: ( function() {\n                var called = false;\n\n                return function( value, element ) {\n                    if ( !called ) {\n                        called = true;\n                        if ( this.settings.debug && window.console ) {\n                            console.warn(\n                                \"The `date` method is deprecated and will be removed in version '2.0.0'.\\n\" +\n                                \"Please don't use it, since it relies on the Date constructor, which\\n\" +\n                                \"behaves very differently across browsers and locales. Use `dateISO`\\n\" +\n                                \"instead or one of the locale specific methods in `localizations/`\\n\" +\n                                \"and `additional-methods.js`.\"\n                            );\n                        }\n                    }\n\n                    return this.optional( element ) || !/Invalid|NaN/.test( new Date( value ).toString() );\n                };\n            }() ),\n\n            // https://jqueryvalidation.org/dateISO-method/\n            dateISO: function( value, element ) {\n                return this.optional( element ) || /^\\d{4}[\\/\\-](0?[1-9]|1[012])[\\/\\-](0?[1-9]|[12][0-9]|3[01])$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/number-method/\n            number: function( value, element ) {\n                return this.optional( element ) || /^(?:-?\\d+|-?\\d{1,3}(?:,\\d{3})+)?(?:\\.\\d+)?$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/digits-method/\n            digits: function( value, element ) {\n                return this.optional( element ) || /^\\d+$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/minlength-method/\n            minlength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || length >= param;\n            },\n\n            // https://jqueryvalidation.org/maxlength-method/\n            maxlength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || length <= param;\n            },\n\n            // https://jqueryvalidation.org/rangelength-method/\n            rangelength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || ( length >= param[ 0 ] && length <= param[ 1 ] );\n            },\n\n            // https://jqueryvalidation.org/min-method/\n            min: function( value, element, param ) {\n                return this.optional( element ) || value >= param;\n            },\n\n            // https://jqueryvalidation.org/max-method/\n            max: function( value, element, param ) {\n                return this.optional( element ) || value <= param;\n            },\n\n            // https://jqueryvalidation.org/range-method/\n            range: function( value, element, param ) {\n                return this.optional( element ) || ( value >= param[ 0 ] && value <= param[ 1 ] );\n            },\n\n            // https://jqueryvalidation.org/step-method/\n            step: function( value, element, param ) {\n                var type = $( element ).attr( \"type\" ),\n                    errorMessage = \"Step attribute on input type \" + type + \" is not supported.\",\n                    supportedTypes = [ \"text\", \"number\", \"range\" ],\n                    re = new RegExp( \"\\\\b\" + type + \"\\\\b\" ),\n                    notSupported = type && !re.test( supportedTypes.join() ),\n                    decimalPlaces = function( num ) {\n                        var match = ( \"\" + num ).match( /(?:\\.(\\d+))?$/ );\n                        if ( !match ) {\n                            return 0;\n                        }\n\n                        // Number of digits right of decimal point.\n                        return match[ 1 ] ? match[ 1 ].length : 0;\n                    },\n                    toInt = function( num ) {\n                        return Math.round( num * Math.pow( 10, decimals ) );\n                    },\n                    valid = true,\n                    decimals;\n\n                // Works only for text, number and range input types\n                // TODO find a way to support input types date, datetime, datetime-local, month, time and week\n                if ( notSupported ) {\n                    throw new Error( errorMessage );\n                }\n\n                decimals = decimalPlaces( param );\n\n                // Value can't have too many decimals\n                if ( decimalPlaces( value ) > decimals || toInt( value ) % toInt( param ) !== 0 ) {\n                    valid = false;\n                }\n\n                return this.optional( element ) || valid;\n            },\n\n            // https://jqueryvalidation.org/equalTo-method/\n            equalTo: function( value, element, param ) {\n\n                // Bind to the blur event of the target in order to revalidate whenever the target field is updated\n                var target = $( param );\n                if ( this.settings.onfocusout && target.not( \".validate-equalTo-blur\" ).length ) {\n                    target.addClass( \"validate-equalTo-blur\" ).on( \"blur.validate-equalTo\", function() {\n                        $( element ).valid();\n                    } );\n                }\n                return value === target.val();\n            },\n\n            // https://jqueryvalidation.org/remote-method/\n            remote: function( value, element, param, method ) {\n                if ( this.optional( element ) ) {\n                    return \"dependency-mismatch\";\n                }\n\n                method = typeof method === \"string\" && method || \"remote\";\n\n                var previous = this.previousValue( element, method ),\n                    validator, data, optionDataString;\n\n                if ( !this.settings.messages[ element.name ] ) {\n                    this.settings.messages[ element.name ] = {};\n                }\n                previous.originalMessage = previous.originalMessage || this.settings.messages[ element.name ][ method ];\n                this.settings.messages[ element.name ][ method ] = previous.message;\n\n                param = typeof param === \"string\" && { url: param } || param;\n                optionDataString = $.param( $.extend( { data: value }, param.data ) );\n                if ( previous.old === optionDataString ) {\n                    return previous.valid;\n                }\n\n                previous.old = optionDataString;\n                validator = this;\n                this.startRequest( element );\n                data = {};\n                data[ element.name ] = value;\n                $.ajax( $.extend( true, {\n                    mode: \"abort\",\n                    port: \"validate\" + element.name,\n                    dataType: \"json\",\n                    data: data,\n                    context: validator.currentForm,\n                    success: function( response ) {\n                        var valid = response === true || response === \"true\",\n                            errors, message, submitted;\n\n                        validator.settings.messages[ element.name ][ method ] = previous.originalMessage;\n                        if ( valid ) {\n                            submitted = validator.formSubmitted;\n                            validator.resetInternals();\n                            validator.toHide = validator.errorsFor( element );\n                            validator.formSubmitted = submitted;\n                            validator.successList.push( element );\n                            validator.invalid[ element.name ] = false;\n                            validator.showErrors();\n                        } else {\n                            errors = {};\n                            message = response || validator.defaultMessage( element, { method: method, parameters: value } );\n                            errors[ element.name ] = previous.message = message;\n                            validator.invalid[ element.name ] = true;\n                            validator.showErrors( errors );\n                        }\n                        previous.valid = valid;\n                        validator.stopRequest( element, valid );\n                    }\n                }, param ) );\n                return \"pending\";\n            }\n        }\n\n    } );\n\n// Ajax mode: abort\n// usage: $.ajax({ mode: \"abort\"[, port: \"uniqueport\"]});\n// if mode:\"abort\" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()\n\n    var pendingRequests = {},\n        ajax;\n\n// Use a prefilter if available (1.5+)\n    if ( $.ajaxPrefilter ) {\n        $.ajaxPrefilter( function( settings, _, xhr ) {\n            var port = settings.port;\n            if ( settings.mode === \"abort\" ) {\n                if ( pendingRequests[ port ] ) {\n                    pendingRequests[ port ].abort();\n                }\n                pendingRequests[ port ] = xhr;\n            }\n        } );\n    } else {\n\n        // Proxy ajax\n        ajax = $.ajax;\n        $.ajax = function( settings ) {\n            var mode = ( \"mode\" in settings ? settings : $.ajaxSettings ).mode,\n                port = ( \"port\" in settings ? settings : $.ajaxSettings ).port;\n            if ( mode === \"abort\" ) {\n                if ( pendingRequests[ port ] ) {\n                    pendingRequests[ port ].abort();\n                }\n                pendingRequests[ port ] = ajax.apply( this, arguments );\n                return pendingRequests[ port ];\n            }\n            return ajax.apply( this, arguments );\n        };\n    }\n    return $;\n}));\n","jquery/jquery.tabs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    \"jquery\",\n    \"jquery/bootstrap/tab\",\n    \"jquery/bootstrap/collapse\",\n], function () {\n\n});\n","jquery/compat.js":"// Import every plugin under the sun. Bad for performance,\n// but prevents the store from breaking in situations\n// where a dependency was missed during the migration from\n// a monolith build of jQueryUI to a modular one\n\ndefine([\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/accordion',\n    'jquery-ui-modules/autocomplete',\n    'jquery-ui-modules/button',\n    'jquery-ui-modules/datepicker',\n    'jquery-ui-modules/dialog',\n    'jquery-ui-modules/draggable',\n    'jquery-ui-modules/droppable',\n    'jquery-ui-modules/effect-blind',\n    'jquery-ui-modules/effect-bounce',\n    'jquery-ui-modules/effect-clip',\n    'jquery-ui-modules/effect-drop',\n    'jquery-ui-modules/effect-explode',\n    'jquery-ui-modules/effect-fade',\n    'jquery-ui-modules/effect-fold',\n    'jquery-ui-modules/effect-highlight',\n    'jquery-ui-modules/effect-scale',\n    'jquery-ui-modules/effect-pulsate',\n    'jquery-ui-modules/effect-shake',\n    'jquery-ui-modules/effect-slide',\n    'jquery-ui-modules/effect-transfer',\n    'jquery-ui-modules/effect',\n    'jquery-ui-modules/menu',\n    'jquery-ui-modules/mouse',\n    'jquery-ui-modules/position',\n    'jquery-ui-modules/progressbar',\n    'jquery-ui-modules/resizable',\n    'jquery-ui-modules/selectable',\n    'jquery-ui-modules/slider',\n    'jquery-ui-modules/sortable',\n    'jquery-ui-modules/spinner',\n    'jquery-ui-modules/tabs',\n    'jquery-ui-modules/timepicker',\n    'jquery-ui-modules/tooltip',\n    'jquery-ui-modules/widget'\n], function() {\n    console.warn(\n        'Fallback to JQueryUI Compat activated. ' +\n        'Your store is missing a dependency for a ' +\n        'jQueryUI widget. Identifying and addressing the dependency ' +\n        'will drastically improve the performance of your site.'\n    );\n});\n","jquery/jquery-migrate.js":"/*!\n * jQuery Migrate - v3.3.2 - 2020-11-17T23:22Z\n * Copyright OpenJS Foundation and other contributors\n */\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\" ], function( jQuery ) {\n            return factory( jQuery, window );\n        } );\n    } else if ( typeof module === \"object\" && module.exports ) {\n\n        // Node/CommonJS\n        // eslint-disable-next-line no-undef\n        module.exports = factory( require( \"jquery\" ), window );\n    } else {\n\n        // Browser globals\n        factory( jQuery, window );\n    }\n} )( function( jQuery, window ) {\n    \"use strict\";\n\n    jQuery.migrateVersion = \"3.3.2\";\n\n// Returns 0 if v1 == v2, -1 if v1 < v2, 1 if v1 > v2\n    function compareVersions( v1, v2 ) {\n        var i,\n            rVersionParts = /^(\\d+)\\.(\\d+)\\.(\\d+)/,\n            v1p = rVersionParts.exec( v1 ) || [ ],\n            v2p = rVersionParts.exec( v2 ) || [ ];\n\n        for ( i = 1; i <= 3; i++ ) {\n            if ( +v1p[ i ] > +v2p[ i ] ) {\n                return 1;\n            }\n            if ( +v1p[ i ] < +v2p[ i ] ) {\n                return -1;\n            }\n        }\n        return 0;\n    }\n\n    function jQueryVersionSince( version ) {\n        return compareVersions( jQuery.fn.jquery, version ) >= 0;\n    }\n\n    ( function() {\n\n        // Support: IE9 only\n        // IE9 only creates console object when dev tools are first opened\n        // IE9 console is a host object, callable but doesn't have .apply()\n        if ( !window.console || !window.console.log ) {\n            return;\n        }\n\n        // Need jQuery 3.0.0+ and no older Migrate loaded\n        if ( !jQuery || !jQueryVersionSince( \"3.0.0\" ) ) {\n            window.console.log( \"JQMIGRATE: jQuery 3.0.0+ REQUIRED\" );\n        }\n        if ( jQuery.migrateWarnings ) {\n            window.console.log( \"JQMIGRATE: Migrate plugin loaded multiple times\" );\n        }\n\n        // Show a message on the console so devs know we're active\n        window.console.log( \"JQMIGRATE: Migrate is installed\" +\n            ( jQuery.migrateMute ? \"\" : \" with logging active\" ) +\n            \", version \" + jQuery.migrateVersion );\n\n    } )();\n\n    var warnedAbout = {};\n\n// By default each warning is only reported once.\n    jQuery.migrateDeduplicateWarnings = true;\n\n// List of warnings already given; public read only\n    jQuery.migrateWarnings = [];\n\n// Set to false to disable traces that appear with warnings\n    if ( jQuery.migrateTrace === undefined ) {\n        jQuery.migrateTrace = true;\n    }\n\n// Forget any warnings we've already given; public\n    jQuery.migrateReset = function() {\n        warnedAbout = {};\n        jQuery.migrateWarnings.length = 0;\n    };\n\n    function migrateWarn( msg ) {\n        var console = window.console;\n        if ( !jQuery.migrateDeduplicateWarnings || !warnedAbout[ msg ] ) {\n            warnedAbout[ msg ] = true;\n            jQuery.migrateWarnings.push( msg );\n            if ( console && console.warn && !jQuery.migrateMute ) {\n                console.warn( \"JQMIGRATE: \" + msg );\n                if ( jQuery.migrateTrace && console.trace ) {\n                    console.trace();\n                }\n            }\n        }\n    }\n\n    function migrateWarnProp( obj, prop, value, msg ) {\n        Object.defineProperty( obj, prop, {\n            configurable: true,\n            enumerable: true,\n            get: function() {\n                migrateWarn( msg );\n                return value;\n            },\n            set: function( newValue ) {\n                migrateWarn( msg );\n                value = newValue;\n            }\n        } );\n    }\n\n    function migrateWarnFunc( obj, prop, newFunc, msg ) {\n        obj[ prop ] = function() {\n            migrateWarn( msg );\n            return newFunc.apply( this, arguments );\n        };\n    }\n\n    if ( window.document.compatMode === \"BackCompat\" ) {\n\n        // JQuery has never supported or tested Quirks Mode\n        migrateWarn( \"jQuery is not compatible with Quirks Mode\" );\n    }\n\n    var findProp,\n        class2type = {},\n        oldInit = jQuery.fn.init,\n        oldFind = jQuery.find,\n\n        rattrHashTest = /\\[(\\s*[-\\w]+\\s*)([~|^$*]?=)\\s*([-\\w#]*?#[-\\w#]*)\\s*\\]/,\n        rattrHashGlob = /\\[(\\s*[-\\w]+\\s*)([~|^$*]?=)\\s*([-\\w#]*?#[-\\w#]*)\\s*\\]/g,\n\n        // Support: Android <=4.0 only\n        // Make sure we trim BOM and NBSP\n        rtrim = /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g;\n\n    jQuery.fn.init = function( arg1 ) {\n        var args = Array.prototype.slice.call( arguments );\n\n        if ( typeof arg1 === \"string\" && arg1 === \"#\" ) {\n\n            // JQuery( \"#\" ) is a bogus ID selector, but it returned an empty set before jQuery 3.0\n            migrateWarn( \"jQuery( '#' ) is not a valid selector\" );\n            args[ 0 ] = [];\n        }\n\n        return oldInit.apply( this, args );\n    };\n    jQuery.fn.init.prototype = jQuery.fn;\n\n    jQuery.find = function( selector ) {\n        var args = Array.prototype.slice.call( arguments );\n\n        // Support: PhantomJS 1.x\n        // String#match fails to match when used with a //g RegExp, only on some strings\n        if ( typeof selector === \"string\" && rattrHashTest.test( selector ) ) {\n\n            // The nonstandard and undocumented unquoted-hash was removed in jQuery 1.12.0\n            // First see if qS thinks it's a valid selector, if so avoid a false positive\n            try {\n                window.document.querySelector( selector );\n            } catch ( err1 ) {\n\n                // Didn't *look* valid to qSA, warn and try quoting what we think is the value\n                selector = selector.replace( rattrHashGlob, function( _, attr, op, value ) {\n                    return \"[\" + attr + op + \"\\\"\" + value + \"\\\"]\";\n                } );\n\n                // If the regexp *may* have created an invalid selector, don't update it\n                // Note that there may be false alarms if selector uses jQuery extensions\n                try {\n                    window.document.querySelector( selector );\n                    migrateWarn( \"Attribute selector with '#' must be quoted: \" + args[ 0 ] );\n                    args[ 0 ] = selector;\n                } catch ( err2 ) {\n                    migrateWarn( \"Attribute selector with '#' was not fixed: \" + args[ 0 ] );\n                }\n            }\n        }\n\n        return oldFind.apply( this, args );\n    };\n\n// Copy properties attached to original jQuery.find method (e.g. .attr, .isXML)\n    for ( findProp in oldFind ) {\n        if ( Object.prototype.hasOwnProperty.call( oldFind, findProp ) ) {\n            jQuery.find[ findProp ] = oldFind[ findProp ];\n        }\n    }\n\n// The number of elements contained in the matched element set\n    migrateWarnFunc( jQuery.fn, \"size\", function() {\n            return this.length;\n        },\n        \"jQuery.fn.size() is deprecated and removed; use the .length property\" );\n\n    migrateWarnFunc( jQuery, \"parseJSON\", function() {\n            return JSON.parse.apply( null, arguments );\n        },\n        \"jQuery.parseJSON is deprecated; use JSON.parse\" );\n\n    migrateWarnFunc( jQuery, \"holdReady\", jQuery.holdReady,\n        \"jQuery.holdReady is deprecated\" );\n\n    migrateWarnFunc( jQuery, \"unique\", jQuery.uniqueSort,\n        \"jQuery.unique is deprecated; use jQuery.uniqueSort\" );\n\n// Now jQuery.expr.pseudos is the standard incantation\n    migrateWarnProp( jQuery.expr, \"filters\", jQuery.expr.pseudos,\n        \"jQuery.expr.filters is deprecated; use jQuery.expr.pseudos\" );\n    migrateWarnProp( jQuery.expr, \":\", jQuery.expr.pseudos,\n        \"jQuery.expr[':'] is deprecated; use jQuery.expr.pseudos\" );\n\n// Prior to jQuery 3.1.1 there were internal refs so we don't warn there\n    if ( jQueryVersionSince( \"3.1.1\" ) ) {\n        migrateWarnFunc( jQuery, \"trim\", function( text ) {\n                return text == null ?\n                    \"\" :\n                    ( text + \"\" ).replace( rtrim, \"\" );\n            },\n            \"jQuery.trim is deprecated; use String.prototype.trim\" );\n    }\n\n// Prior to jQuery 3.2 there were internal refs so we don't warn there\n    if ( jQueryVersionSince( \"3.2.0\" ) ) {\n        migrateWarnFunc( jQuery, \"nodeName\", function( elem, name ) {\n                return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n            },\n            \"jQuery.nodeName is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isArray\", Array.isArray,\n            \"jQuery.isArray is deprecated; use Array.isArray\"\n        );\n    }\n\n    if ( jQueryVersionSince( \"3.3.0\" ) ) {\n\n        migrateWarnFunc( jQuery, \"isNumeric\", function( obj ) {\n\n                // As of jQuery 3.0, isNumeric is limited to\n                // strings and numbers (primitives or objects)\n                // that can be coerced to finite numbers (gh-2662)\n                var type = typeof obj;\n                return ( type === \"number\" || type === \"string\" ) &&\n\n                    // parseFloat NaNs numeric-cast false positives (\"\")\n                    // ...but misinterprets leading-number strings, e.g. hex literals (\"0x...\")\n                    // subtraction forces infinities to NaN\n                    !isNaN( obj - parseFloat( obj ) );\n            },\n            \"jQuery.isNumeric() is deprecated\"\n        );\n\n        // Populate the class2type map\n        jQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".\n            split( \" \" ),\n            function( _, name ) {\n                class2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n            } );\n\n        migrateWarnFunc( jQuery, \"type\", function( obj ) {\n                if ( obj == null ) {\n                    return obj + \"\";\n                }\n\n                // Support: Android <=2.3 only (functionish RegExp)\n                return typeof obj === \"object\" || typeof obj === \"function\" ?\n                    class2type[ Object.prototype.toString.call( obj ) ] || \"object\" :\n                    typeof obj;\n            },\n            \"jQuery.type is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isFunction\",\n            function( obj ) {\n                return typeof obj === \"function\";\n            },\n            \"jQuery.isFunction() is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isWindow\",\n            function( obj ) {\n                return obj != null && obj === obj.window;\n            },\n            \"jQuery.isWindow() is deprecated\"\n        );\n    }\n\n// Support jQuery slim which excludes the ajax module\n    if ( jQuery.ajax ) {\n\n        var oldAjax = jQuery.ajax,\n            rjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n        jQuery.ajax = function( ) {\n            var jQXHR = oldAjax.apply( this, arguments );\n\n            // Be sure we got a jQXHR (e.g., not sync)\n            if ( jQXHR.promise ) {\n                migrateWarnFunc( jQXHR, \"success\", jQXHR.done,\n                    \"jQXHR.success is deprecated and removed\" );\n                migrateWarnFunc( jQXHR, \"error\", jQXHR.fail,\n                    \"jQXHR.error is deprecated and removed\" );\n                migrateWarnFunc( jQXHR, \"complete\", jQXHR.always,\n                    \"jQXHR.complete is deprecated and removed\" );\n            }\n\n            return jQXHR;\n        };\n\n// Only trigger the logic in jQuery <4 as the JSON-to-JSONP auto-promotion\n// behavior is gone in jQuery 4.0 and as it has security implications, we don't\n// want to restore the legacy behavior.\n        if ( !jQueryVersionSince( \"4.0.0\" ) ) {\n\n            // Register this prefilter before the jQuery one. Otherwise, a promoted\n            // request is transformed into one with the script dataType and we can't\n            // catch it anymore.\n            jQuery.ajaxPrefilter( \"+json\", function( s ) {\n\n                // Warn if JSON-to-JSONP auto-promotion happens.\n                if ( s.jsonp !== false && ( rjsonp.test( s.url ) ||\n                    typeof s.data === \"string\" &&\n                    ( s.contentType || \"\" )\n                        .indexOf( \"application/x-www-form-urlencoded\" ) === 0 &&\n                    rjsonp.test( s.data )\n                ) ) {\n                    migrateWarn( \"JSON-to-JSONP auto-promotion is deprecated\" );\n                }\n            } );\n        }\n\n    }\n\n    var oldRemoveAttr = jQuery.fn.removeAttr,\n        oldToggleClass = jQuery.fn.toggleClass,\n        rmatchNonSpace = /\\S+/g;\n\n    jQuery.fn.removeAttr = function( name ) {\n        var self = this;\n\n        jQuery.each( name.match( rmatchNonSpace ), function( _i, attr ) {\n            if ( jQuery.expr.match.bool.test( attr ) ) {\n                migrateWarn( \"jQuery.fn.removeAttr no longer sets boolean properties: \" + attr );\n                self.prop( attr, false );\n            }\n        } );\n\n        return oldRemoveAttr.apply( this, arguments );\n    };\n\n    jQuery.fn.toggleClass = function( state ) {\n\n        // Only deprecating no-args or single boolean arg\n        if ( state !== undefined && typeof state !== \"boolean\" ) {\n            return oldToggleClass.apply( this, arguments );\n        }\n\n        migrateWarn( \"jQuery.fn.toggleClass( boolean ) is deprecated\" );\n\n        // Toggle entire class name of each element\n        return this.each( function() {\n            var className = this.getAttribute && this.getAttribute( \"class\" ) || \"\";\n\n            if ( className ) {\n                jQuery.data( this, \"__className__\", className );\n            }\n\n            // If the element has a class name or if we're passed `false`,\n            // then remove the whole classname (if there was one, the above saved it).\n            // Otherwise bring back whatever was previously saved (if anything),\n            // falling back to the empty string if nothing was stored.\n            if ( this.setAttribute ) {\n                this.setAttribute( \"class\",\n                    className || state === false ?\n                        \"\" :\n                        jQuery.data( this, \"__className__\" ) || \"\"\n                );\n            }\n        } );\n    };\n\n    function camelCase( string ) {\n        return string.replace( /-([a-z])/g, function( _, letter ) {\n            return letter.toUpperCase();\n        } );\n    }\n\n    var oldFnCss,\n        internalSwapCall = false,\n        ralphaStart = /^[a-z]/,\n\n        // The regex visualized:\n        //\n        //                         /----------\\\n        //                        |            |    /-------\\\n        //                        |  / Top  \\  |   |         |\n        //         /--- Border ---+-| Right  |-+---+- Width -+---\\\n        //        |                 | Bottom |                    |\n        //        |                  \\ Left /                     |\n        //        |                                               |\n        //        |                              /----------\\     |\n        //        |          /-------------\\    |            |    |- END\n        //        |         |               |   |  / Top  \\  |    |\n        //        |         |  / Margin  \\  |   | | Right  | |    |\n        //        |---------+-|           |-+---+-| Bottom |-+----|\n        //        |            \\ Padding /         \\ Left /       |\n        // BEGIN -|                                               |\n        //        |                /---------\\                    |\n        //        |               |           |                   |\n        //        |               |  / Min \\  |    / Width  \\     |\n        //         \\--------------+-|       |-+---|          |---/\n        //                           \\ Max /       \\ Height /\n        rautoPx = /^(?:Border(?:Top|Right|Bottom|Left)?(?:Width|)|(?:Margin|Padding)?(?:Top|Right|Bottom|Left)?|(?:Min|Max)?(?:Width|Height))$/;\n\n// If this version of jQuery has .swap(), don't false-alarm on internal uses\n    if ( jQuery.swap ) {\n        jQuery.each( [ \"height\", \"width\", \"reliableMarginRight\" ], function( _, name ) {\n            var oldHook = jQuery.cssHooks[ name ] && jQuery.cssHooks[ name ].get;\n\n            if ( oldHook ) {\n                jQuery.cssHooks[ name ].get = function() {\n                    var ret;\n\n                    internalSwapCall = true;\n                    ret = oldHook.apply( this, arguments );\n                    internalSwapCall = false;\n                    return ret;\n                };\n            }\n        } );\n    }\n\n    jQuery.swap = function( elem, options, callback, args ) {\n        var ret, name,\n            old = {};\n\n        if ( !internalSwapCall ) {\n            migrateWarn( \"jQuery.swap() is undocumented and deprecated\" );\n        }\n\n        // Remember the old values, and insert the new ones\n        for ( name in options ) {\n            old[ name ] = elem.style[ name ];\n            elem.style[ name ] = options[ name ];\n        }\n\n        ret = callback.apply( elem, args || [] );\n\n        // Revert the old values\n        for ( name in options ) {\n            elem.style[ name ] = old[ name ];\n        }\n\n        return ret;\n    };\n\n    if ( jQueryVersionSince( \"3.4.0\" ) && typeof Proxy !== \"undefined\" ) {\n\n        jQuery.cssProps = new Proxy( jQuery.cssProps || {}, {\n            set: function() {\n                migrateWarn( \"JQMIGRATE: jQuery.cssProps is deprecated\" );\n                return Reflect.set.apply( this, arguments );\n            }\n        } );\n    }\n\n// Create a dummy jQuery.cssNumber if missing. It won't be used by jQuery but\n// it will prevent code adding new keys to it unconditionally from crashing.\n    if ( !jQuery.cssNumber ) {\n        jQuery.cssNumber = {};\n    }\n\n    function isAutoPx( prop ) {\n\n        // The first test is used to ensure that:\n        // 1. The prop starts with a lowercase letter (as we uppercase it for the second regex).\n        // 2. The prop is not empty.\n        return ralphaStart.test( prop ) &&\n            rautoPx.test( prop[ 0 ].toUpperCase() + prop.slice( 1 ) );\n    }\n\n    oldFnCss = jQuery.fn.css;\n\n    jQuery.fn.css = function( name, value ) {\n        var camelName,\n            origThis = this;\n        if ( name && typeof name === \"object\" && !Array.isArray( name ) ) {\n            jQuery.each( name, function( n, v ) {\n                jQuery.fn.css.call( origThis, n, v );\n            } );\n            return this;\n        }\n        if ( typeof value === \"number\" ) {\n            camelName = camelCase( name );\n            if ( !isAutoPx( camelName ) && !jQuery.cssNumber[ camelName ] ) {\n                migrateWarn( \"Number-typed values are deprecated for jQuery.fn.css( \\\"\" +\n                    name + \"\\\", value )\" );\n            }\n        }\n\n        return oldFnCss.apply( this, arguments );\n    };\n\n    var oldData = jQuery.data;\n\n    jQuery.data = function( elem, name, value ) {\n        var curData, sameKeys, key;\n\n        // Name can be an object, and each entry in the object is meant to be set as data\n        if ( name && typeof name === \"object\" && arguments.length === 2 ) {\n            curData = jQuery.hasData( elem ) && oldData.call( this, elem );\n            sameKeys = {};\n            for ( key in name ) {\n                if ( key !== camelCase( key ) ) {\n                    migrateWarn( \"jQuery.data() always sets/gets camelCased names: \" + key );\n                    curData[ key ] = name[ key ];\n                } else {\n                    sameKeys[ key ] = name[ key ];\n                }\n            }\n\n            oldData.call( this, elem, sameKeys );\n\n            return name;\n        }\n\n        // If the name is transformed, look for the un-transformed name in the data object\n        if ( name && typeof name === \"string\" && name !== camelCase( name ) ) {\n            curData = jQuery.hasData( elem ) && oldData.call( this, elem );\n            if ( curData && name in curData ) {\n                migrateWarn( \"jQuery.data() always sets/gets camelCased names: \" + name );\n                if ( arguments.length > 2 ) {\n                    curData[ name ] = value;\n                }\n                return curData[ name ];\n            }\n        }\n\n        return oldData.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the effects module\n    if ( jQuery.fx ) {\n\n        var intervalValue, intervalMsg,\n            oldTweenRun = jQuery.Tween.prototype.run,\n            linearEasing = function( pct ) {\n                return pct;\n            };\n\n        jQuery.Tween.prototype.run = function( ) {\n            if ( jQuery.easing[ this.easing ].length > 1 ) {\n                migrateWarn(\n                    \"'jQuery.easing.\" + this.easing.toString() + \"' should use only one argument\"\n                );\n\n                jQuery.easing[ this.easing ] = linearEasing;\n            }\n\n            oldTweenRun.apply( this, arguments );\n        };\n\n        intervalValue = jQuery.fx.interval || 13;\n        intervalMsg = \"jQuery.fx.interval is deprecated\";\n\n// Support: IE9, Android <=4.4\n// Avoid false positives on browsers that lack rAF\n// Don't warn if document is hidden, jQuery uses setTimeout (#292)\n        if ( window.requestAnimationFrame ) {\n            Object.defineProperty( jQuery.fx, \"interval\", {\n                configurable: true,\n                enumerable: true,\n                get: function() {\n                    if ( !window.document.hidden ) {\n                        migrateWarn( intervalMsg );\n                    }\n                    return intervalValue;\n                },\n                set: function( newValue ) {\n                    migrateWarn( intervalMsg );\n                    intervalValue = newValue;\n                }\n            } );\n        }\n\n    }\n\n    var oldLoad = jQuery.fn.load,\n        oldEventAdd = jQuery.event.add,\n        originalFix = jQuery.event.fix;\n\n    jQuery.event.props = [];\n    jQuery.event.fixHooks = {};\n\n    migrateWarnProp( jQuery.event.props, \"concat\", jQuery.event.props.concat,\n        \"jQuery.event.props.concat() is deprecated and removed\" );\n\n    jQuery.event.fix = function( originalEvent ) {\n        var event,\n            type = originalEvent.type,\n            fixHook = this.fixHooks[ type ],\n            props = jQuery.event.props;\n\n        if ( props.length ) {\n            migrateWarn( \"jQuery.event.props are deprecated and removed: \" + props.join() );\n            while ( props.length ) {\n                jQuery.event.addProp( props.pop() );\n            }\n        }\n\n        if ( fixHook && !fixHook._migrated_ ) {\n            fixHook._migrated_ = true;\n            migrateWarn( \"jQuery.event.fixHooks are deprecated and removed: \" + type );\n            if ( ( props = fixHook.props ) && props.length ) {\n                while ( props.length ) {\n                    jQuery.event.addProp( props.pop() );\n                }\n            }\n        }\n\n        event = originalFix.call( this, originalEvent );\n\n        return fixHook && fixHook.filter ? fixHook.filter( event, originalEvent ) : event;\n    };\n\n    jQuery.event.add = function( elem, types ) {\n\n        // This misses the multiple-types case but that seems awfully rare\n        if ( elem === window && types === \"load\" && window.document.readyState === \"complete\" ) {\n            migrateWarn( \"jQuery(window).on('load'...) called after load event occurred\" );\n        }\n        return oldEventAdd.apply( this, arguments );\n    };\n\n    jQuery.each( [ \"load\", \"unload\", \"error\" ], function( _, name ) {\n\n        jQuery.fn[ name ] = function() {\n            var args = Array.prototype.slice.call( arguments, 0 );\n\n            // If this is an ajax load() the first arg should be the string URL;\n            // technically this could also be the \"Anything\" arg of the event .load()\n            // which just goes to show why this dumb signature has been deprecated!\n            // jQuery custom builds that exclude the Ajax module justifiably die here.\n            if ( name === \"load\" && typeof args[ 0 ] === \"string\" ) {\n                return oldLoad.apply( this, args );\n            }\n\n            migrateWarn( \"jQuery.fn.\" + name + \"() is deprecated\" );\n\n            args.splice( 0, 0, name );\n            if ( arguments.length ) {\n                return this.on.apply( this, args );\n            }\n\n            // Use .triggerHandler here because:\n            // - load and unload events don't need to bubble, only applied to window or image\n            // - error event should not bubble to window, although it does pre-1.7\n            // See http://bugs.jquery.com/ticket/11820\n            this.triggerHandler.apply( this, args );\n            return this;\n        };\n\n    } );\n\n    jQuery.each( ( \"blur focus focusin focusout resize scroll click dblclick \" +\n            \"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n            \"change select submit keydown keypress keyup contextmenu\" ).split( \" \" ),\n        function( _i, name ) {\n\n            // Handle event binding\n            jQuery.fn[ name ] = function( data, fn ) {\n                migrateWarn( \"jQuery.fn.\" + name + \"() event shorthand is deprecated\" );\n                return arguments.length > 0 ?\n                    this.on( name, null, data, fn ) :\n                    this.trigger( name );\n            };\n        } );\n\n// Trigger \"ready\" event only once, on document ready\n    jQuery( function() {\n        jQuery( window.document ).triggerHandler( \"ready\" );\n    } );\n\n    jQuery.event.special.ready = {\n        setup: function() {\n            if ( this === window.document ) {\n                migrateWarn( \"'ready' event is deprecated\" );\n            }\n        }\n    };\n\n    jQuery.fn.extend( {\n\n        bind: function( types, data, fn ) {\n            migrateWarn( \"jQuery.fn.bind() is deprecated\" );\n            return this.on( types, null, data, fn );\n        },\n        unbind: function( types, fn ) {\n            migrateWarn( \"jQuery.fn.unbind() is deprecated\" );\n            return this.off( types, null, fn );\n        },\n        delegate: function( selector, types, data, fn ) {\n            migrateWarn( \"jQuery.fn.delegate() is deprecated\" );\n            return this.on( types, selector, data, fn );\n        },\n        undelegate: function( selector, types, fn ) {\n            migrateWarn( \"jQuery.fn.undelegate() is deprecated\" );\n            return arguments.length === 1 ?\n                this.off( selector, \"**\" ) :\n                this.off( types, selector || \"**\", fn );\n        },\n        hover: function( fnOver, fnOut ) {\n            migrateWarn( \"jQuery.fn.hover() is deprecated\" );\n            return this.on( \"mouseenter\", fnOver ).on( \"mouseleave\", fnOut || fnOver );\n        }\n    } );\n\n    var rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\\/\\0>\\x20\\t\\r\\n\\f]*)[^>]*)\\/>/gi,\n        origHtmlPrefilter = jQuery.htmlPrefilter,\n        makeMarkup = function( html ) {\n            var doc = window.document.implementation.createHTMLDocument( \"\" );\n            doc.body.innerHTML = html;\n            return doc.body && doc.body.innerHTML;\n        },\n        warnIfChanged = function( html ) {\n            var changed = html.replace( rxhtmlTag, \"<$1></$2>\" );\n            if ( changed !== html && makeMarkup( html ) !== makeMarkup( changed ) ) {\n                migrateWarn( \"HTML tags must be properly nested and closed: \" + html );\n            }\n        };\n\n    jQuery.UNSAFE_restoreLegacyHtmlPrefilter = function() {\n        jQuery.htmlPrefilter = function( html ) {\n            warnIfChanged( html );\n            return html.replace( rxhtmlTag, \"<$1></$2>\" );\n        };\n    };\n\n    jQuery.htmlPrefilter = function( html ) {\n        warnIfChanged( html );\n        return origHtmlPrefilter( html );\n    };\n\n    var oldOffset = jQuery.fn.offset;\n\n    jQuery.fn.offset = function() {\n        var elem = this[ 0 ];\n\n        if ( elem && ( !elem.nodeType || !elem.getBoundingClientRect ) ) {\n            migrateWarn( \"jQuery.fn.offset() requires a valid DOM element\" );\n            return arguments.length ? this : undefined;\n        }\n\n        return oldOffset.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the ajax module\n// The jQuery.param patch is about respecting `jQuery.ajaxSettings.traditional`\n// so it doesn't make sense for the slim build.\n    if ( jQuery.ajax ) {\n\n        var oldParam = jQuery.param;\n\n        jQuery.param = function( data, traditional ) {\n            var ajaxTraditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;\n\n            if ( traditional === undefined && ajaxTraditional ) {\n\n                migrateWarn( \"jQuery.param() no longer uses jQuery.ajaxSettings.traditional\" );\n                traditional = ajaxTraditional;\n            }\n\n            return oldParam.call( this, data, traditional );\n        };\n\n    }\n\n    var oldSelf = jQuery.fn.andSelf || jQuery.fn.addBack;\n\n    jQuery.fn.andSelf = function() {\n        migrateWarn( \"jQuery.fn.andSelf() is deprecated and removed, use jQuery.fn.addBack()\" );\n        return oldSelf.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the deferred module in jQuery 4.0+\n    if ( jQuery.Deferred ) {\n\n        var oldDeferred = jQuery.Deferred,\n            tuples = [\n\n                // Action, add listener, callbacks, .then handlers, final state\n                [ \"resolve\", \"done\", jQuery.Callbacks( \"once memory\" ),\n                    jQuery.Callbacks( \"once memory\" ), \"resolved\" ],\n                [ \"reject\", \"fail\", jQuery.Callbacks( \"once memory\" ),\n                    jQuery.Callbacks( \"once memory\" ), \"rejected\" ],\n                [ \"notify\", \"progress\", jQuery.Callbacks( \"memory\" ),\n                    jQuery.Callbacks( \"memory\" ) ]\n            ];\n\n        jQuery.Deferred = function( func ) {\n            var deferred = oldDeferred(),\n                promise = deferred.promise();\n\n            deferred.pipe = promise.pipe = function( /* fnDone, fnFail, fnProgress */ ) {\n                var fns = arguments;\n\n                migrateWarn( \"deferred.pipe() is deprecated\" );\n\n                return jQuery.Deferred( function( newDefer ) {\n                    jQuery.each( tuples, function( i, tuple ) {\n                        var fn = typeof fns[ i ] === \"function\" && fns[ i ];\n\n                        // Deferred.done(function() { bind to newDefer or newDefer.resolve })\n                        // deferred.fail(function() { bind to newDefer or newDefer.reject })\n                        // deferred.progress(function() { bind to newDefer or newDefer.notify })\n                        deferred[ tuple[ 1 ] ]( function() {\n                            var returned = fn && fn.apply( this, arguments );\n                            if ( returned && typeof returned.promise === \"function\" ) {\n                                returned.promise()\n                                    .done( newDefer.resolve )\n                                    .fail( newDefer.reject )\n                                    .progress( newDefer.notify );\n                            } else {\n                                newDefer[ tuple[ 0 ] + \"With\" ](\n                                    this === promise ? newDefer.promise() : this,\n                                    fn ? [ returned ] : arguments\n                                );\n                            }\n                        } );\n                    } );\n                    fns = null;\n                } ).promise();\n\n            };\n\n            if ( func ) {\n                func.call( deferred, deferred );\n            }\n\n            return deferred;\n        };\n\n// Preserve handler of uncaught exceptions in promise chains\n        jQuery.Deferred.exceptionHook = oldDeferred.exceptionHook;\n\n    }\n\n    return jQuery;\n} );\n","jquery/timepicker.js":"/*! jQuery Timepicker Addon - v1.6.3 - 2016-04-20\n* http://trentrichardson.com/examples/timepicker\n* Copyright (c) 2016 Trent Richardson; Licensed MIT */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery', 'jquery-ui-modules/datepicker', 'jquery-ui-modules/slider'], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n    /*\n    * Lets not redefine timepicker, Prevent \"Uncaught RangeError: Maximum call stack size exceeded\"\n    */\n    $.ui.timepicker = $.ui.timepicker || {};\n    if ($.ui.timepicker.version) {\n        return;\n    }\n\n    /*\n    * Extend jQueryUI, get it started with our version number\n    */\n    $.extend($.ui, {\n        timepicker: {\n            version: \"1.6.3\"\n        }\n    });\n\n    /*\n    * Timepicker manager.\n    * Use the singleton instance of this class, $.timepicker, to interact with the time picker.\n    * Settings for (groups of) time pickers are maintained in an instance object,\n    * allowing multiple different settings on the same page.\n    */\n    var Timepicker = function () {\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[''] = { // Default regional settings\n            currentText: 'Now',\n            closeText: 'Done',\n            amNames: ['AM', 'A'],\n            pmNames: ['PM', 'P'],\n            timeFormat: 'HH:mm',\n            timeSuffix: '',\n            timeOnlyTitle: 'Choose Time',\n            timeText: 'Time',\n            hourText: 'Hour',\n            minuteText: 'Minute',\n            secondText: 'Second',\n            millisecText: 'Millisecond',\n            microsecText: 'Microsecond',\n            timezoneText: 'Time Zone',\n            isRTL: false\n        };\n        this._defaults = { // Global defaults for all the datetime picker instances\n            showButtonPanel: true,\n            timeOnly: false,\n            timeOnlyShowDate: false,\n            showHour: null,\n            showMinute: null,\n            showSecond: null,\n            showMillisec: null,\n            showMicrosec: null,\n            showTimezone: null,\n            showTime: true,\n            stepHour: 1,\n            stepMinute: 1,\n            stepSecond: 1,\n            stepMillisec: 1,\n            stepMicrosec: 1,\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null,\n            hourMin: 0,\n            minuteMin: 0,\n            secondMin: 0,\n            millisecMin: 0,\n            microsecMin: 0,\n            hourMax: 23,\n            minuteMax: 59,\n            secondMax: 59,\n            millisecMax: 999,\n            microsecMax: 999,\n            minDateTime: null,\n            maxDateTime: null,\n            maxTime: null,\n            minTime: null,\n            onSelect: null,\n            hourGrid: 0,\n            minuteGrid: 0,\n            secondGrid: 0,\n            millisecGrid: 0,\n            microsecGrid: 0,\n            alwaysSetTime: true,\n            separator: ' ',\n            altFieldTimeOnly: true,\n            altTimeFormat: null,\n            altSeparator: null,\n            altTimeSuffix: null,\n            altRedirectFocus: true,\n            pickerTimeFormat: null,\n            pickerTimeSuffix: null,\n            showTimepicker: true,\n            timezoneList: null,\n            addSliderAccess: false,\n            sliderAccessArgs: null,\n            controlType: 'slider',\n            oneLine: false,\n            defaultValue: null,\n            parse: 'strict',\n            afterInject: null\n        };\n        $.extend(this._defaults, this.regional['']);\n    };\n\n    $.extend(Timepicker.prototype, {\n        $input: null,\n        $altInput: null,\n        $timeObj: null,\n        inst: null,\n        hour_slider: null,\n        minute_slider: null,\n        second_slider: null,\n        millisec_slider: null,\n        microsec_slider: null,\n        timezone_select: null,\n        maxTime: null,\n        minTime: null,\n        hour: 0,\n        minute: 0,\n        second: 0,\n        millisec: 0,\n        microsec: 0,\n        timezone: null,\n        hourMinOriginal: null,\n        minuteMinOriginal: null,\n        secondMinOriginal: null,\n        millisecMinOriginal: null,\n        microsecMinOriginal: null,\n        hourMaxOriginal: null,\n        minuteMaxOriginal: null,\n        secondMaxOriginal: null,\n        millisecMaxOriginal: null,\n        microsecMaxOriginal: null,\n        ampm: '',\n        formattedDate: '',\n        formattedTime: '',\n        formattedDateTime: '',\n        timezoneList: null,\n        units: ['hour', 'minute', 'second', 'millisec', 'microsec'],\n        support: {},\n        control: null,\n\n        /*\n        * Override the default settings for all instances of the time picker.\n        * @param  {Object} settings  object - the new settings to use as defaults (anonymous object)\n        * @return {Object} the manager object\n        */\n        setDefaults: function (settings) {\n            extendRemove(this._defaults, settings || {});\n            return this;\n        },\n\n        /*\n        * Create a new Timepicker instance\n        */\n        _newInst: function ($input, opts) {\n            var tp_inst = new Timepicker(),\n                inlineSettings = {},\n                fns = {},\n                overrides, i;\n\n            for (var attrName in this._defaults) {\n                if (this._defaults.hasOwnProperty(attrName)) {\n                    var attrValue = $input.attr('time:' + attrName);\n                    if (attrValue) {\n                        try {\n                            inlineSettings[attrName] = eval(attrValue);\n                        } catch (err) {\n                            inlineSettings[attrName] = attrValue;\n                        }\n                    }\n                }\n            }\n\n            overrides = {\n                beforeShow: function (input, dp_inst) {\n                    if ($.isFunction(tp_inst._defaults.evnts.beforeShow)) {\n                        return tp_inst._defaults.evnts.beforeShow.call($input[0], input, dp_inst, tp_inst);\n                    }\n                },\n                onChangeMonthYear: function (year, month, dp_inst) {\n                    // Update the time as well : this prevents the time from disappearing from the $input field.\n                    // tp_inst._updateDateTime(dp_inst);\n                    if ($.isFunction(tp_inst._defaults.evnts.onChangeMonthYear)) {\n                        tp_inst._defaults.evnts.onChangeMonthYear.call($input[0], year, month, dp_inst, tp_inst);\n                    }\n                },\n                onClose: function (dateText, dp_inst) {\n                    if (tp_inst.timeDefined === true && $input.val() !== '') {\n                        tp_inst._updateDateTime(dp_inst);\n                    }\n                    if ($.isFunction(tp_inst._defaults.evnts.onClose)) {\n                        tp_inst._defaults.evnts.onClose.call($input[0], dateText, dp_inst, tp_inst);\n                    }\n                }\n            };\n            for (i in overrides) {\n                if (overrides.hasOwnProperty(i)) {\n                    fns[i] = opts[i] || this._defaults[i] || null;\n                }\n            }\n\n            tp_inst._defaults = $.extend({}, this._defaults, inlineSettings, opts, overrides, {\n                evnts: fns,\n                timepicker: tp_inst // add timepicker as a property of datepicker: $.datepicker._get(dp_inst, 'timepicker');\n            });\n            tp_inst.amNames = $.map(tp_inst._defaults.amNames, function (val) {\n                return val.toUpperCase();\n            });\n            tp_inst.pmNames = $.map(tp_inst._defaults.pmNames, function (val) {\n                return val.toUpperCase();\n            });\n\n            // detect which units are supported\n            tp_inst.support = detectSupport(\n                tp_inst._defaults.timeFormat +\n                (tp_inst._defaults.pickerTimeFormat ? tp_inst._defaults.pickerTimeFormat : '') +\n                (tp_inst._defaults.altTimeFormat ? tp_inst._defaults.altTimeFormat : ''));\n\n            // controlType is string - key to our this._controls\n            if (typeof(tp_inst._defaults.controlType) === 'string') {\n                if (tp_inst._defaults.controlType === 'slider' && typeof($.ui.slider) === 'undefined') {\n                    tp_inst._defaults.controlType = 'select';\n                }\n                tp_inst.control = tp_inst._controls[tp_inst._defaults.controlType];\n            }\n            // controlType is an object and must implement create, options, value methods\n            else {\n                tp_inst.control = tp_inst._defaults.controlType;\n            }\n\n            // prep the timezone options\n            var timezoneList = [-720, -660, -600, -570, -540, -480, -420, -360, -300, -270, -240, -210, -180, -120, -60,\n                0, 60, 120, 180, 210, 240, 270, 300, 330, 345, 360, 390, 420, 480, 525, 540, 570, 600, 630, 660, 690, 720, 765, 780, 840];\n            if (tp_inst._defaults.timezoneList !== null) {\n                timezoneList = tp_inst._defaults.timezoneList;\n            }\n            var tzl = timezoneList.length, tzi = 0, tzv = null;\n            if (tzl > 0 && typeof timezoneList[0] !== 'object') {\n                for (; tzi < tzl; tzi++) {\n                    tzv = timezoneList[tzi];\n                    timezoneList[tzi] = { value: tzv, label: $.timepicker.timezoneOffsetString(tzv, tp_inst.support.iso8601) };\n                }\n            }\n            tp_inst._defaults.timezoneList = timezoneList;\n\n            // set the default units\n            tp_inst.timezone = tp_inst._defaults.timezone !== null ? $.timepicker.timezoneOffsetNumber(tp_inst._defaults.timezone) :\n                ((new Date()).getTimezoneOffset() * -1);\n            tp_inst.hour = tp_inst._defaults.hour < tp_inst._defaults.hourMin ? tp_inst._defaults.hourMin :\n                tp_inst._defaults.hour > tp_inst._defaults.hourMax ? tp_inst._defaults.hourMax : tp_inst._defaults.hour;\n            tp_inst.minute = tp_inst._defaults.minute < tp_inst._defaults.minuteMin ? tp_inst._defaults.minuteMin :\n                tp_inst._defaults.minute > tp_inst._defaults.minuteMax ? tp_inst._defaults.minuteMax : tp_inst._defaults.minute;\n            tp_inst.second = tp_inst._defaults.second < tp_inst._defaults.secondMin ? tp_inst._defaults.secondMin :\n                tp_inst._defaults.second > tp_inst._defaults.secondMax ? tp_inst._defaults.secondMax : tp_inst._defaults.second;\n            tp_inst.millisec = tp_inst._defaults.millisec < tp_inst._defaults.millisecMin ? tp_inst._defaults.millisecMin :\n                tp_inst._defaults.millisec > tp_inst._defaults.millisecMax ? tp_inst._defaults.millisecMax : tp_inst._defaults.millisec;\n            tp_inst.microsec = tp_inst._defaults.microsec < tp_inst._defaults.microsecMin ? tp_inst._defaults.microsecMin :\n                tp_inst._defaults.microsec > tp_inst._defaults.microsecMax ? tp_inst._defaults.microsecMax : tp_inst._defaults.microsec;\n            tp_inst.ampm = '';\n            tp_inst.$input = $input;\n\n            if (tp_inst._defaults.altField) {\n                tp_inst.$altInput = $(tp_inst._defaults.altField);\n                if (tp_inst._defaults.altRedirectFocus === true) {\n                    tp_inst.$altInput.css({\n                        cursor: 'pointer'\n                    }).focus(function () {\n                        $input.trigger(\"focus\");\n                    });\n                }\n            }\n\n            if (tp_inst._defaults.minDate === 0 || tp_inst._defaults.minDateTime === 0) {\n                tp_inst._defaults.minDate = new Date();\n            }\n            if (tp_inst._defaults.maxDate === 0 || tp_inst._defaults.maxDateTime === 0) {\n                tp_inst._defaults.maxDate = new Date();\n            }\n\n            // datepicker needs minDate/maxDate, timepicker needs minDateTime/maxDateTime..\n            if (tp_inst._defaults.minDate !== undefined && tp_inst._defaults.minDate instanceof Date) {\n                tp_inst._defaults.minDateTime = new Date(tp_inst._defaults.minDate.getTime());\n            }\n            if (tp_inst._defaults.minDateTime !== undefined && tp_inst._defaults.minDateTime instanceof Date) {\n                tp_inst._defaults.minDate = new Date(tp_inst._defaults.minDateTime.getTime());\n            }\n            if (tp_inst._defaults.maxDate !== undefined && tp_inst._defaults.maxDate instanceof Date) {\n                tp_inst._defaults.maxDateTime = new Date(tp_inst._defaults.maxDate.getTime());\n            }\n            if (tp_inst._defaults.maxDateTime !== undefined && tp_inst._defaults.maxDateTime instanceof Date) {\n                tp_inst._defaults.maxDate = new Date(tp_inst._defaults.maxDateTime.getTime());\n            }\n            tp_inst.$input.bind('focus', function () {\n                tp_inst._onFocus();\n            });\n\n            return tp_inst;\n        },\n\n        /*\n        * add our sliders to the calendar\n        */\n        _addTimePicker: function (dp_inst) {\n            var currDT = $.trim((this.$altInput && this._defaults.altFieldTimeOnly) ? this.$input.val() + ' ' + this.$altInput.val() : this.$input.val());\n\n            this.timeDefined = this._parseTime(currDT);\n            this._limitMinMaxDateTime(dp_inst, false);\n            this._injectTimePicker();\n            this._afterInject();\n        },\n\n        /*\n        * parse the time string from input value or _setTime\n        */\n        _parseTime: function (timeString, withDate) {\n            if (!this.inst) {\n                this.inst = $.datepicker._getInst(this.$input[0]);\n            }\n\n            if (withDate || !this._defaults.timeOnly) {\n                var dp_dateFormat = $.datepicker._get(this.inst, 'dateFormat');\n                try {\n                    var parseRes = parseDateTimeInternal(dp_dateFormat, this._defaults.timeFormat, timeString, $.datepicker._getFormatConfig(this.inst), this._defaults);\n                    if (!parseRes.timeObj) {\n                        return false;\n                    }\n                    $.extend(this, parseRes.timeObj);\n                } catch (err) {\n                    $.timepicker.log(\"Error parsing the date/time string: \" + err +\n                        \"\\ndate/time string = \" + timeString +\n                        \"\\ntimeFormat = \" + this._defaults.timeFormat +\n                        \"\\ndateFormat = \" + dp_dateFormat);\n                    return false;\n                }\n                return true;\n            } else {\n                var timeObj = $.datepicker.parseTime(this._defaults.timeFormat, timeString, this._defaults);\n                if (!timeObj) {\n                    return false;\n                }\n                $.extend(this, timeObj);\n                return true;\n            }\n        },\n\n        /*\n        * Handle callback option after injecting timepicker\n        */\n        _afterInject: function() {\n            var o = this.inst.settings;\n            if ($.isFunction(o.afterInject)) {\n                o.afterInject.call(this);\n            }\n        },\n\n        /*\n        * generate and inject html for timepicker into ui datepicker\n        */\n        _injectTimePicker: function () {\n            var $dp = this.inst.dpDiv,\n                o = this.inst.settings,\n                tp_inst = this,\n                litem = '',\n                uitem = '',\n                show = null,\n                max = {},\n                gridSize = {},\n                size = null,\n                i = 0,\n                l = 0;\n\n            // Prevent displaying twice\n            if ($dp.find(\"div.ui-timepicker-div\").length === 0 && o.showTimepicker) {\n                var noDisplay = ' ui_tpicker_unit_hide',\n                    html = '<div class=\"ui-timepicker-div' + (o.isRTL ? ' ui-timepicker-rtl' : '') + (o.oneLine && o.controlType === 'select' ? ' ui-timepicker-oneLine' : '') + '\"><dl>' + '<dt class=\"ui_tpicker_time_label' + ((o.showTime) ? '' : noDisplay) + '\">' + o.timeText + '</dt>' +\n                        '<dd class=\"ui_tpicker_time '+ ((o.showTime) ? '' : noDisplay) + '\"><input class=\"ui_tpicker_time_input\" ' + (o.timeInput ? '' : 'disabled') + '/></dd>';\n\n                // Create the markup\n                for (i = 0, l = this.units.length; i < l; i++) {\n                    litem = this.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // Added by Peter Medeiros:\n                    // - Figure out what the hour/minute/second max should be based on the step values.\n                    // - Example: if stepMinute is 15, then minMax is 45.\n                    max[litem] = parseInt((o[litem + 'Max'] - ((o[litem + 'Max'] - o[litem + 'Min']) % o['step' + uitem])), 10);\n                    gridSize[litem] = 0;\n\n                    html += '<dt class=\"ui_tpicker_' + litem + '_label' + (show ? '' : noDisplay) + '\">' + o[litem + 'Text'] + '</dt>' +\n                        '<dd class=\"ui_tpicker_' + litem + (show ? '' : noDisplay) + '\"><div class=\"ui_tpicker_' + litem + '_slider' + (show ? '' : noDisplay) + '\"></div>';\n\n                    if (show && o[litem + 'Grid'] > 0) {\n                        html += '<div style=\"padding-left: 1px\"><table class=\"ui-tpicker-grid-label\"><tr>';\n\n                        if (litem === 'hour') {\n                            for (var h = o[litem + 'Min']; h <= max[litem]; h += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                var tmph = $.datepicker.formatTime(this.support.ampm ? 'hht' : 'HH', {hour: h}, o);\n                                html += '<td data-for=\"' + litem + '\">' + tmph + '</td>';\n                            }\n                        }\n                        else {\n                            for (var m = o[litem + 'Min']; m <= max[litem]; m += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                html += '<td data-for=\"' + litem + '\">' + ((m < 10) ? '0' : '') + m + '</td>';\n                            }\n                        }\n\n                        html += '</tr></table></div>';\n                    }\n                    html += '</dd>';\n                }\n\n                // Timezone\n                var showTz = o.showTimezone !== null ? o.showTimezone : this.support.timezone;\n                html += '<dt class=\"ui_tpicker_timezone_label' + (showTz ? '' : noDisplay) + '\">' + o.timezoneText + '</dt>';\n                html += '<dd class=\"ui_tpicker_timezone' + (showTz ? '' : noDisplay) + '\"></dd>';\n\n                // Create the elements from string\n                html += '</dl></div>';\n                var $tp = $(html);\n\n                // if we only want time picker...\n                if (o.timeOnly === true) {\n                    $tp.prepend('<div class=\"ui-widget-header ui-helper-clearfix ui-corner-all\">' + '<div class=\"ui-datepicker-title\">' + o.timeOnlyTitle + '</div>' + '</div>');\n                    $dp.find('.ui-datepicker-header, .ui-datepicker-calendar').hide();\n                }\n\n                // add sliders, adjust grids, add events\n                for (i = 0, l = tp_inst.units.length; i < l; i++) {\n                    litem = tp_inst.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // add the slider\n                    tp_inst[litem + '_slider'] = tp_inst.control.create(tp_inst, $tp.find('.ui_tpicker_' + litem + '_slider'), litem, tp_inst[litem], o[litem + 'Min'], max[litem], o['step' + uitem]);\n\n                    // adjust the grid and add click event\n                    if (show && o[litem + 'Grid'] > 0) {\n                        size = 100 * gridSize[litem] * o[litem + 'Grid'] / (max[litem] - o[litem + 'Min']);\n                        $tp.find('.ui_tpicker_' + litem + ' table').css({\n                            width: size + \"%\",\n                            marginLeft: o.isRTL ? '0' : ((size / (-2 * gridSize[litem])) + \"%\"),\n                            marginRight: o.isRTL ? ((size / (-2 * gridSize[litem])) + \"%\") : '0',\n                            borderCollapse: 'collapse'\n                        }).find(\"td\").click(function (e) {\n                            var $t = $(this),\n                                h = $t.html(),\n                                n = parseInt(h.replace(/[^0-9]/g), 10),\n                                ap = h.replace(/[^apm]/ig),\n                                f = $t.data('for'); // loses scope, so we use data-for\n\n                            if (f === 'hour') {\n                                if (ap.indexOf('p') !== -1 && n < 12) {\n                                    n += 12;\n                                }\n                                else {\n                                    if (ap.indexOf('a') !== -1 && n === 12) {\n                                        n = 0;\n                                    }\n                                }\n                            }\n\n                            tp_inst.control.value(tp_inst, tp_inst[f + '_slider'], litem, n);\n\n                            tp_inst._onTimeChange();\n                            tp_inst._onSelectHandler();\n                        }).css({\n                            cursor: 'pointer',\n                            width: (100 / gridSize[litem]) + '%',\n                            textAlign: 'center',\n                            overflow: 'hidden'\n                        });\n                    } // end if grid > 0\n                } // end for loop\n\n                // Add timezone options\n                this.timezone_select = $tp.find('.ui_tpicker_timezone').append('<select></select>').find(\"select\");\n                $.fn.append.apply(this.timezone_select,\n                    $.map(o.timezoneList, function (val, idx) {\n                        return $(\"<option />\").val(typeof val === \"object\" ? val.value : val).text(typeof val === \"object\" ? val.label : val);\n                    }));\n                if (typeof(this.timezone) !== \"undefined\" && this.timezone !== null && this.timezone !== \"\") {\n                    var local_timezone = (new Date(this.inst.selectedYear, this.inst.selectedMonth, this.inst.selectedDay, 12)).getTimezoneOffset() * -1;\n                    if (local_timezone === this.timezone) {\n                        selectLocalTimezone(tp_inst);\n                    } else {\n                        this.timezone_select.val(this.timezone);\n                    }\n                } else {\n                    if (typeof(this.hour) !== \"undefined\" && this.hour !== null && this.hour !== \"\") {\n                        this.timezone_select.val(o.timezone);\n                    } else {\n                        selectLocalTimezone(tp_inst);\n                    }\n                }\n                this.timezone_select.change(function () {\n                    tp_inst._onTimeChange();\n                    tp_inst._onSelectHandler();\n                    tp_inst._afterInject();\n                });\n                // End timezone options\n\n                // inject timepicker into datepicker\n                var $buttonPanel = $dp.find('.ui-datepicker-buttonpane');\n                if ($buttonPanel.length) {\n                    $buttonPanel.before($tp);\n                } else {\n                    $dp.append($tp);\n                }\n\n                this.$timeObj = $tp.find('.ui_tpicker_time_input');\n                this.$timeObj.change(function () {\n                    var timeFormat = tp_inst.inst.settings.timeFormat;\n                    var parsedTime = $.datepicker.parseTime(timeFormat, this.value);\n                    var update = new Date();\n                    if (parsedTime) {\n                        update.setHours(parsedTime.hour);\n                        update.setMinutes(parsedTime.minute);\n                        update.setSeconds(parsedTime.second);\n                        $.datepicker._setTime(tp_inst.inst, update);\n                    } else {\n                        this.value = tp_inst.formattedTime;\n                        this.blur();\n                    }\n                });\n\n                if (this.inst !== null) {\n                    var timeDefined = this.timeDefined;\n                    this._onTimeChange();\n                    this.timeDefined = timeDefined;\n                }\n\n                // slideAccess integration: http://trentrichardson.com/2011/11/11/jquery-ui-sliders-and-touch-accessibility/\n                if (this._defaults.addSliderAccess) {\n                    var sliderAccessArgs = this._defaults.sliderAccessArgs,\n                        rtl = this._defaults.isRTL;\n                    sliderAccessArgs.isRTL = rtl;\n\n                    setTimeout(function () { // fix for inline mode\n                        if ($tp.find('.ui-slider-access').length === 0) {\n                            $tp.find('.ui-slider:visible').sliderAccess(sliderAccessArgs);\n\n                            // fix any grids since sliders are shorter\n                            var sliderAccessWidth = $tp.find('.ui-slider-access:eq(0)').outerWidth(true);\n                            if (sliderAccessWidth) {\n                                $tp.find('table:visible').each(function () {\n                                    var $g = $(this),\n                                        oldWidth = $g.outerWidth(),\n                                        oldMarginLeft = $g.css(rtl ? 'marginRight' : 'marginLeft').toString().replace('%', ''),\n                                        newWidth = oldWidth - sliderAccessWidth,\n                                        newMarginLeft = ((oldMarginLeft * newWidth) / oldWidth) + '%',\n                                        css = { width: newWidth, marginRight: 0, marginLeft: 0 };\n                                    css[rtl ? 'marginRight' : 'marginLeft'] = newMarginLeft;\n                                    $g.css(css);\n                                });\n                            }\n                        }\n                    }, 10);\n                }\n                // end slideAccess integration\n\n                tp_inst._limitMinMaxDateTime(this.inst, true);\n            }\n        },\n\n        /*\n        * This function tries to limit the ability to go outside the\n        * min/max date range\n        */\n        _limitMinMaxDateTime: function (dp_inst, adjustSliders) {\n            var o = this._defaults,\n                dp_date = new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay);\n\n            if (!this._defaults.showTimepicker) {\n                return;\n            } // No time so nothing to check here\n\n            if ($.datepicker._get(dp_inst, 'minDateTime') !== null && $.datepicker._get(dp_inst, 'minDateTime') !== undefined && dp_date) {\n                var minDateTime = $.datepicker._get(dp_inst, 'minDateTime'),\n                    minDateTimeDate = new Date(minDateTime.getFullYear(), minDateTime.getMonth(), minDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMinOriginal === null || this.minuteMinOriginal === null || this.secondMinOriginal === null || this.millisecMinOriginal === null || this.microsecMinOriginal === null) {\n                    this.hourMinOriginal = o.hourMin;\n                    this.minuteMinOriginal = o.minuteMin;\n                    this.secondMinOriginal = o.secondMin;\n                    this.millisecMinOriginal = o.millisecMin;\n                    this.microsecMinOriginal = o.microsecMin;\n                }\n\n                if (dp_inst.settings.timeOnly || minDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMin = minDateTime.getHours();\n                    if (this.hour <= this._defaults.hourMin) {\n                        this.hour = this._defaults.hourMin;\n                        this._defaults.minuteMin = minDateTime.getMinutes();\n                        if (this.minute <= this._defaults.minuteMin) {\n                            this.minute = this._defaults.minuteMin;\n                            this._defaults.secondMin = minDateTime.getSeconds();\n                            if (this.second <= this._defaults.secondMin) {\n                                this.second = this._defaults.secondMin;\n                                this._defaults.millisecMin = minDateTime.getMilliseconds();\n                                if (this.millisec <= this._defaults.millisecMin) {\n                                    this.millisec = this._defaults.millisecMin;\n                                    this._defaults.microsecMin = minDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec < this._defaults.microsecMin) {\n                                        this.microsec = this._defaults.microsecMin;\n                                    }\n                                    this._defaults.microsecMin = this.microsecMinOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMin = this.millisecMinOriginal;\n                                this._defaults.microsecMin = this.microsecMinOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMin = this.secondMinOriginal;\n                            this._defaults.millisecMin = this.millisecMinOriginal;\n                            this._defaults.microsecMin = this.microsecMinOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMin = this.minuteMinOriginal;\n                        this._defaults.secondMin = this.secondMinOriginal;\n                        this._defaults.millisecMin = this.millisecMinOriginal;\n                        this._defaults.microsecMin = this.microsecMinOriginal;\n                    }\n                } else {\n                    this._defaults.hourMin = this.hourMinOriginal;\n                    this._defaults.minuteMin = this.minuteMinOriginal;\n                    this._defaults.secondMin = this.secondMinOriginal;\n                    this._defaults.millisecMin = this.millisecMinOriginal;\n                    this._defaults.microsecMin = this.microsecMinOriginal;\n                }\n            }\n\n            if ($.datepicker._get(dp_inst, 'maxDateTime') !== null && $.datepicker._get(dp_inst, 'maxDateTime') !== undefined && dp_date) {\n                var maxDateTime = $.datepicker._get(dp_inst, 'maxDateTime'),\n                    maxDateTimeDate = new Date(maxDateTime.getFullYear(), maxDateTime.getMonth(), maxDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMaxOriginal === null || this.minuteMaxOriginal === null || this.secondMaxOriginal === null || this.millisecMaxOriginal === null) {\n                    this.hourMaxOriginal = o.hourMax;\n                    this.minuteMaxOriginal = o.minuteMax;\n                    this.secondMaxOriginal = o.secondMax;\n                    this.millisecMaxOriginal = o.millisecMax;\n                    this.microsecMaxOriginal = o.microsecMax;\n                }\n\n                if (dp_inst.settings.timeOnly || maxDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMax = maxDateTime.getHours();\n                    if (this.hour >= this._defaults.hourMax) {\n                        this.hour = this._defaults.hourMax;\n                        this._defaults.minuteMax = maxDateTime.getMinutes();\n                        if (this.minute >= this._defaults.minuteMax) {\n                            this.minute = this._defaults.minuteMax;\n                            this._defaults.secondMax = maxDateTime.getSeconds();\n                            if (this.second >= this._defaults.secondMax) {\n                                this.second = this._defaults.secondMax;\n                                this._defaults.millisecMax = maxDateTime.getMilliseconds();\n                                if (this.millisec >= this._defaults.millisecMax) {\n                                    this.millisec = this._defaults.millisecMax;\n                                    this._defaults.microsecMax = maxDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec > this._defaults.microsecMax) {\n                                        this.microsec = this._defaults.microsecMax;\n                                    }\n                                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMax = this.millisecMaxOriginal;\n                                this._defaults.microsecMax = this.microsecMaxOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMax = this.secondMaxOriginal;\n                            this._defaults.millisecMax = this.millisecMaxOriginal;\n                            this._defaults.microsecMax = this.microsecMaxOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMax = this.minuteMaxOriginal;\n                        this._defaults.secondMax = this.secondMaxOriginal;\n                        this._defaults.millisecMax = this.millisecMaxOriginal;\n                        this._defaults.microsecMax = this.microsecMaxOriginal;\n                    }\n                } else {\n                    this._defaults.hourMax = this.hourMaxOriginal;\n                    this._defaults.minuteMax = this.minuteMaxOriginal;\n                    this._defaults.secondMax = this.secondMaxOriginal;\n                    this._defaults.millisecMax = this.millisecMaxOriginal;\n                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                }\n            }\n\n            if (dp_inst.settings.minTime!==null) {\n                var tempMinTime=new Date(\"01/01/1970 \" + dp_inst.settings.minTime);\n                if (this.hour<tempMinTime.getHours()) {\n                    this.hour=this._defaults.hourMin=tempMinTime.getHours();\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else if (this.hour===tempMinTime.getHours() && this.minute<tempMinTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMin<tempMinTime.getHours()) {\n                        this._defaults.hourMin=tempMinTime.getHours();\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else if (this._defaults.hourMin===tempMinTime.getHours()===this.hour && this._defaults.minuteMin<tempMinTime.getMinutes()) {\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMin=0;\n                    }\n                }\n            }\n\n            if (dp_inst.settings.maxTime!==null) {\n                var tempMaxTime=new Date(\"01/01/1970 \" + dp_inst.settings.maxTime);\n                if (this.hour>tempMaxTime.getHours()) {\n                    this.hour=this._defaults.hourMax=tempMaxTime.getHours();\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else if (this.hour===tempMaxTime.getHours() && this.minute>tempMaxTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMax>tempMaxTime.getHours()) {\n                        this._defaults.hourMax=tempMaxTime.getHours();\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else if (this._defaults.hourMax===tempMaxTime.getHours()===this.hour && this._defaults.minuteMax>tempMaxTime.getMinutes()) {\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMax=59;\n                    }\n                }\n            }\n\n            if (adjustSliders !== undefined && adjustSliders === true) {\n                var hourMax = parseInt((this._defaults.hourMax - ((this._defaults.hourMax - this._defaults.hourMin) % this._defaults.stepHour)), 10),\n                    minMax = parseInt((this._defaults.minuteMax - ((this._defaults.minuteMax - this._defaults.minuteMin) % this._defaults.stepMinute)), 10),\n                    secMax = parseInt((this._defaults.secondMax - ((this._defaults.secondMax - this._defaults.secondMin) % this._defaults.stepSecond)), 10),\n                    millisecMax = parseInt((this._defaults.millisecMax - ((this._defaults.millisecMax - this._defaults.millisecMin) % this._defaults.stepMillisec)), 10),\n                    microsecMax = parseInt((this._defaults.microsecMax - ((this._defaults.microsecMax - this._defaults.microsecMin) % this._defaults.stepMicrosec)), 10);\n\n                if (this.hour_slider) {\n                    this.control.options(this, this.hour_slider, 'hour', { min: this._defaults.hourMin, max: hourMax, step: this._defaults.stepHour });\n                    this.control.value(this, this.hour_slider, 'hour', this.hour - (this.hour % this._defaults.stepHour));\n                }\n                if (this.minute_slider) {\n                    this.control.options(this, this.minute_slider, 'minute', { min: this._defaults.minuteMin, max: minMax, step: this._defaults.stepMinute });\n                    this.control.value(this, this.minute_slider, 'minute', this.minute - (this.minute % this._defaults.stepMinute));\n                }\n                if (this.second_slider) {\n                    this.control.options(this, this.second_slider, 'second', { min: this._defaults.secondMin, max: secMax, step: this._defaults.stepSecond });\n                    this.control.value(this, this.second_slider, 'second', this.second - (this.second % this._defaults.stepSecond));\n                }\n                if (this.millisec_slider) {\n                    this.control.options(this, this.millisec_slider, 'millisec', { min: this._defaults.millisecMin, max: millisecMax, step: this._defaults.stepMillisec });\n                    this.control.value(this, this.millisec_slider, 'millisec', this.millisec - (this.millisec % this._defaults.stepMillisec));\n                }\n                if (this.microsec_slider) {\n                    this.control.options(this, this.microsec_slider, 'microsec', { min: this._defaults.microsecMin, max: microsecMax, step: this._defaults.stepMicrosec });\n                    this.control.value(this, this.microsec_slider, 'microsec', this.microsec - (this.microsec % this._defaults.stepMicrosec));\n                }\n            }\n\n        },\n\n        /*\n        * when a slider moves, set the internal time...\n        * on time change is also called when the time is updated in the text field\n        */\n        _onTimeChange: function () {\n            if (!this._defaults.showTimepicker) {\n                return;\n            }\n            var hour = (this.hour_slider) ? this.control.value(this, this.hour_slider, 'hour') : false,\n                minute = (this.minute_slider) ? this.control.value(this, this.minute_slider, 'minute') : false,\n                second = (this.second_slider) ? this.control.value(this, this.second_slider, 'second') : false,\n                millisec = (this.millisec_slider) ? this.control.value(this, this.millisec_slider, 'millisec') : false,\n                microsec = (this.microsec_slider) ? this.control.value(this, this.microsec_slider, 'microsec') : false,\n                timezone = (this.timezone_select) ? this.timezone_select.val() : false,\n                o = this._defaults,\n                pickerTimeFormat = o.pickerTimeFormat || o.timeFormat,\n                pickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;\n\n            if (typeof(hour) === 'object') {\n                hour = false;\n            }\n            if (typeof(minute) === 'object') {\n                minute = false;\n            }\n            if (typeof(second) === 'object') {\n                second = false;\n            }\n            if (typeof(millisec) === 'object') {\n                millisec = false;\n            }\n            if (typeof(microsec) === 'object') {\n                microsec = false;\n            }\n            if (typeof(timezone) === 'object') {\n                timezone = false;\n            }\n\n            if (hour !== false) {\n                hour = parseInt(hour, 10);\n            }\n            if (minute !== false) {\n                minute = parseInt(minute, 10);\n            }\n            if (second !== false) {\n                second = parseInt(second, 10);\n            }\n            if (millisec !== false) {\n                millisec = parseInt(millisec, 10);\n            }\n            if (microsec !== false) {\n                microsec = parseInt(microsec, 10);\n            }\n            if (timezone !== false) {\n                timezone = timezone.toString();\n            }\n\n            var ampm = o[hour < 12 ? 'amNames' : 'pmNames'][0];\n\n            // If the update was done in the input field, the input field should not be updated.\n            // If the update was done using the sliders, update the input field.\n            var hasChanged = (\n                hour !== parseInt(this.hour,10) || // sliders should all be numeric\n                minute !== parseInt(this.minute,10) ||\n                second !== parseInt(this.second,10) ||\n                millisec !== parseInt(this.millisec,10) ||\n                microsec !== parseInt(this.microsec,10) ||\n                (this.ampm.length > 0 && (hour < 12) !== ($.inArray(this.ampm.toUpperCase(), this.amNames) !== -1)) ||\n                (this.timezone !== null && timezone !== this.timezone.toString()) // could be numeric or \"EST\" format, so use toString()\n            );\n\n            if (hasChanged) {\n\n                if (hour !== false) {\n                    this.hour = hour;\n                }\n                if (minute !== false) {\n                    this.minute = minute;\n                }\n                if (second !== false) {\n                    this.second = second;\n                }\n                if (millisec !== false) {\n                    this.millisec = millisec;\n                }\n                if (microsec !== false) {\n                    this.microsec = microsec;\n                }\n                if (timezone !== false) {\n                    this.timezone = timezone;\n                }\n\n                if (!this.inst) {\n                    this.inst = $.datepicker._getInst(this.$input[0]);\n                }\n\n                this._limitMinMaxDateTime(this.inst, true);\n            }\n            if (this.support.ampm) {\n                this.ampm = ampm;\n            }\n\n            // Updates the time within the timepicker\n            this.formattedTime = $.datepicker.formatTime(o.timeFormat, this, o);\n            if (this.$timeObj) {\n                if (pickerTimeFormat === o.timeFormat) {\n                    this.$timeObj.val(this.formattedTime + pickerTimeSuffix);\n                }\n                else {\n                    this.$timeObj.val($.datepicker.formatTime(pickerTimeFormat, this, o) + pickerTimeSuffix);\n                }\n                if (this.$timeObj[0].setSelectionRange) {\n                    var sPos = this.$timeObj[0].selectionStart;\n                    var ePos = this.$timeObj[0].selectionEnd;\n                    this.$timeObj[0].setSelectionRange(sPos, ePos);\n                }\n            }\n\n            this.timeDefined = true;\n            if (hasChanged) {\n                this._updateDateTime();\n                //this.$input.focus(); // may automatically open the picker on setDate\n            }\n        },\n\n        /*\n        * call custom onSelect.\n        * bind to sliders slidestop, and grid click.\n        */\n        _onSelectHandler: function () {\n            var onSelect = this._defaults.onSelect || this.inst.settings.onSelect;\n            var inputEl = this.$input ? this.$input[0] : null;\n            if (onSelect && inputEl) {\n                onSelect.apply(inputEl, [this.formattedDateTime, this]);\n            }\n        },\n\n        /*\n        * update our input with the new date time..\n        */\n        _updateDateTime: function (dp_inst) {\n            dp_inst = this.inst || dp_inst;\n            var dtTmp = (dp_inst.currentYear > 0?\n                new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay) :\n                new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                dt = $.datepicker._daylightSavingAdjust(dtTmp),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay)),\n                dateFmt = $.datepicker._get(dp_inst, 'dateFormat'),\n                formatCfg = $.datepicker._getFormatConfig(dp_inst),\n                timeAvailable = dt !== null && this.timeDefined;\n            this.formattedDate = $.datepicker.formatDate(dateFmt, (dt === null ? new Date() : dt), formatCfg);\n            var formattedDateTime = this.formattedDate;\n\n            // if a slider was changed but datepicker doesn't have a value yet, set it\n            if (dp_inst.lastVal === \"\") {\n                dp_inst.currentYear = dp_inst.selectedYear;\n                dp_inst.currentMonth = dp_inst.selectedMonth;\n                dp_inst.currentDay = dp_inst.selectedDay;\n            }\n\n            /*\n            * remove following lines to force every changes in date picker to change the input value\n            * Bug descriptions: when an input field has a default value, and click on the field to pop up the date picker.\n            * If the user manually empty the value in the input field, the date picker will never change selected value.\n            */\n            //if (dp_inst.lastVal !== undefined && (dp_inst.lastVal.length > 0 && this.$input.val().length === 0)) {\n            //\treturn;\n            //}\n\n            if (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === false) {\n                formattedDateTime = this.formattedTime;\n            } else if ((this._defaults.timeOnly !== true && (this._defaults.alwaysSetTime || timeAvailable)) || (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === true)) {\n                formattedDateTime += this._defaults.separator + this.formattedTime + this._defaults.timeSuffix;\n            }\n\n            this.formattedDateTime = formattedDateTime;\n\n            if (!this._defaults.showTimepicker) {\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput && this._defaults.timeOnly === false && this._defaults.altFieldTimeOnly === true) {\n                this.$altInput.val(this.formattedTime);\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput) {\n                this.$input.val(formattedDateTime);\n                var altFormattedDateTime = '',\n                    altSeparator = this._defaults.altSeparator !== null ? this._defaults.altSeparator : this._defaults.separator,\n                    altTimeSuffix = this._defaults.altTimeSuffix !== null ? this._defaults.altTimeSuffix : this._defaults.timeSuffix;\n\n                if (!this._defaults.timeOnly) {\n                    if (this._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(this._defaults.altFormat, (dt === null ? new Date() : dt), formatCfg);\n                    }\n                    else {\n                        altFormattedDateTime = this.formattedDate;\n                    }\n\n                    if (altFormattedDateTime) {\n                        altFormattedDateTime += altSeparator;\n                    }\n                }\n\n                if (this._defaults.altTimeFormat !== null) {\n                    altFormattedDateTime += $.datepicker.formatTime(this._defaults.altTimeFormat, this, this._defaults) + altTimeSuffix;\n                }\n                else {\n                    altFormattedDateTime += this.formattedTime + altTimeSuffix;\n                }\n                this.$altInput.val(altFormattedDateTime);\n            } else {\n                this.$input.val(formattedDateTime);\n            }\n\n            this.$input.trigger(\"change\");\n        },\n\n        _onFocus: function () {\n            if (!this.$input.val() && this._defaults.defaultValue) {\n                this.$input.val(this._defaults.defaultValue);\n                var inst = $.datepicker._getInst(this.$input.get(0)),\n                    tp_inst = $.datepicker._get(inst, 'timepicker');\n                if (tp_inst) {\n                    if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                        try {\n                            $.datepicker._updateDatepicker(inst);\n                        } catch (err) {\n                            $.timepicker.log(err);\n                        }\n                    }\n                }\n            }\n        },\n\n        /*\n        * Small abstraction to control types\n        * We can add more, just be sure to follow the pattern: create, options, value\n        */\n        _controls: {\n            // slider methods\n            slider: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var rtl = tp_inst._defaults.isRTL; // if rtl go -60->0 instead of 0->60\n                    return obj.prop('slide', null).slider({\n                        orientation: \"horizontal\",\n                        value: rtl ? val * -1 : val,\n                        min: rtl ? max * -1 : min,\n                        max: rtl ? min * -1 : max,\n                        step: step,\n                        slide: function (event, ui) {\n                            tp_inst.control.value(tp_inst, $(this), unit, rtl ? ui.value * -1 : ui.value);\n                            tp_inst._onTimeChange();\n                        },\n                        stop: function (event, ui) {\n                            tp_inst._onSelectHandler();\n                        }\n                    });\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (typeof(opts) === 'string') {\n                            if (opts === 'min' || opts === 'max') {\n                                if (val !== undefined) {\n                                    return obj.slider(opts, val * -1);\n                                }\n                                return Math.abs(obj.slider(opts));\n                            }\n                            return obj.slider(opts);\n                        }\n                        var min = opts.min,\n                            max = opts.max;\n                        opts.min = opts.max = null;\n                        if (min !== undefined) {\n                            opts.max = min * -1;\n                        }\n                        if (max !== undefined) {\n                            opts.min = max * -1;\n                        }\n                        return obj.slider(opts);\n                    }\n                    if (typeof(opts) === 'string' && val !== undefined) {\n                        return obj.slider(opts, val);\n                    }\n                    return obj.slider(opts);\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (val !== undefined) {\n                            return obj.slider('value', val * -1);\n                        }\n                        return Math.abs(obj.slider('value'));\n                    }\n                    if (val !== undefined) {\n                        return obj.slider('value', val);\n                    }\n                    return obj.slider('value');\n                }\n            },\n            // select methods\n            select: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var sel = '<select class=\"ui-timepicker-select ui-state-default ui-corner-all\" data-unit=\"' + unit + '\" data-min=\"' + min + '\" data-max=\"' + max + '\" data-step=\"' + step + '\">',\n                        format = tp_inst._defaults.pickerTimeFormat || tp_inst._defaults.timeFormat;\n\n                    for (var i = min; i <= max; i += step) {\n                        sel += '<option value=\"' + i + '\"' + (i === val ? ' selected' : '') + '>';\n                        if (unit === 'hour') {\n                            sel += $.datepicker.formatTime($.trim(format.replace(/[^ht ]/ig, '')), {hour: i}, tp_inst._defaults);\n                        }\n                        else if (unit === 'millisec' || unit === 'microsec' || i >= 10) { sel += i; }\n                        else {sel += '0' + i.toString(); }\n                        sel += '</option>';\n                    }\n                    sel += '</select>';\n\n                    obj.children('select').remove();\n\n                    $(sel).appendTo(obj).change(function (e) {\n                        tp_inst._onTimeChange();\n                        tp_inst._onSelectHandler();\n                        tp_inst._afterInject();\n                    });\n\n                    return obj;\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    var o = {},\n                        $t = obj.children('select');\n                    if (typeof(opts) === 'string') {\n                        if (val === undefined) {\n                            return $t.data(opts);\n                        }\n                        o[opts] = val;\n                    }\n                    else { o = opts; }\n                    return tp_inst.control.create(tp_inst, obj, $t.data('unit'), $t.val(), o.min>=0 ? o.min : $t.data('min'), o.max || $t.data('max'), o.step || $t.data('step'));\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    var $t = obj.children('select');\n                    if (val !== undefined) {\n                        return $t.val(val);\n                    }\n                    return $t.val();\n                }\n            }\n        } // end _controls\n\n    });\n\n    $.fn.extend({\n        /*\n        * shorthand just to use timepicker.\n        */\n        timepicker: function (o) {\n            o = o || {};\n            var tmp_args = Array.prototype.slice.call(arguments);\n\n            if (typeof o === 'object') {\n                tmp_args[0] = $.extend(o, {\n                    timeOnly: true\n                });\n            }\n\n            return $(this).each(function () {\n                $.fn.datetimepicker.apply($(this), tmp_args);\n            });\n        },\n\n        /*\n        * extend timepicker to datepicker\n        */\n        datetimepicker: function (o) {\n            o = o || {};\n            var tmp_args = arguments;\n\n            if (typeof(o) === 'string') {\n                if (o === 'getDate'  || (o === 'option' && tmp_args.length === 2 && typeof (tmp_args[1]) === 'string')) {\n                    return $.fn.datepicker.apply($(this[0]), tmp_args);\n                } else {\n                    return this.each(function () {\n                        var $t = $(this);\n                        $t.datepicker.apply($t, tmp_args);\n                    });\n                }\n            } else {\n                return this.each(function () {\n                    var $t = $(this);\n                    $t.datepicker($.timepicker._newInst($t, o)._defaults);\n                });\n            }\n        }\n    });\n\n    /*\n    * Public Utility to parse date and time\n    */\n    $.datepicker.parseDateTime = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var parseRes = parseDateTimeInternal(dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings);\n        if (parseRes.timeObj) {\n            var t = parseRes.timeObj;\n            parseRes.date.setHours(t.hour, t.minute, t.second, t.millisec);\n            parseRes.date.setMicroseconds(t.microsec);\n        }\n\n        return parseRes.date;\n    };\n\n    /*\n    * Public utility to parse time\n    */\n    $.datepicker.parseTime = function (timeFormat, timeString, options) {\n        var o = extendRemove(extendRemove({}, $.timepicker._defaults), options || {}),\n            iso8601 = (timeFormat.replace(/\\'.*?\\'/g, '').indexOf('Z') !== -1);\n\n        // Strict parse requires the timeString to match the timeFormat exactly\n        var strictParse = function (f, s, o) {\n\n            // pattern for standard and localized AM/PM markers\n            var getPatternAmpm = function (amNames, pmNames) {\n                var markers = [];\n                if (amNames) {\n                    $.merge(markers, amNames);\n                }\n                if (pmNames) {\n                    $.merge(markers, pmNames);\n                }\n                markers = $.map(markers, function (val) {\n                    return val.replace(/[.*+?|()\\[\\]{}\\\\]/g, '\\\\$&');\n                });\n                return '(' + markers.join('|') + ')?';\n            };\n\n            // figure out position of time elements.. cause js cant do named captures\n            var getFormatPositions = function (timeFormat) {\n                var finds = timeFormat.toLowerCase().match(/(h{1,2}|m{1,2}|s{1,2}|l{1}|c{1}|t{1,2}|z|'.*?')/g),\n                    orders = {\n                        h: -1,\n                        m: -1,\n                        s: -1,\n                        l: -1,\n                        c: -1,\n                        t: -1,\n                        z: -1\n                    };\n\n                if (finds) {\n                    for (var i = 0; i < finds.length; i++) {\n                        if (orders[finds[i].toString().charAt(0)] === -1) {\n                            orders[finds[i].toString().charAt(0)] = i + 1;\n                        }\n                    }\n                }\n                return orders;\n            };\n\n            var regstr = '^' + f.toString()\n                    .replace(/([hH]{1,2}|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n                        var ml = match.length;\n                        switch (match.charAt(0).toLowerCase()) {\n                            case 'h':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'm':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 's':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'l':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'c':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'z':\n                                return '(z|[-+]\\\\d\\\\d:?\\\\d\\\\d|\\\\S+)?';\n                            case 't':\n                                return getPatternAmpm(o.amNames, o.pmNames);\n                            default:    // literal escaped in quotes\n                                return '(' + match.replace(/\\'/g, \"\").replace(/(\\.|\\$|\\^|\\\\|\\/|\\(|\\)|\\[|\\]|\\?|\\+|\\*)/g, function (m) { return \"\\\\\" + m; }) + ')?';\n                        }\n                    })\n                    .replace(/\\s/g, '\\\\s?') +\n                o.timeSuffix + '$',\n                order = getFormatPositions(f),\n                ampm = '',\n                treg;\n\n            treg = s.match(new RegExp(regstr, 'i'));\n\n            var resTime = {\n                hour: 0,\n                minute: 0,\n                second: 0,\n                millisec: 0,\n                microsec: 0\n            };\n\n            if (treg) {\n                if (order.t !== -1) {\n                    if (treg[order.t] === undefined || treg[order.t].length === 0) {\n                        ampm = '';\n                        resTime.ampm = '';\n                    } else {\n                        ampm = $.inArray(treg[order.t].toUpperCase(), $.map(o.amNames, function (x,i) { return x.toUpperCase(); })) !== -1 ? 'AM' : 'PM';\n                        resTime.ampm = o[ampm === 'AM' ? 'amNames' : 'pmNames'][0];\n                    }\n                }\n\n                if (order.h !== -1) {\n                    if (ampm === 'AM' && treg[order.h] === '12') {\n                        resTime.hour = 0; // 12am = 0 hour\n                    } else {\n                        if (ampm === 'PM' && treg[order.h] !== '12') {\n                            resTime.hour = parseInt(treg[order.h], 10) + 12; // 12pm = 12 hour, any other pm = hour + 12\n                        } else {\n                            resTime.hour = Number(treg[order.h]);\n                        }\n                    }\n                }\n\n                if (order.m !== -1) {\n                    resTime.minute = Number(treg[order.m]);\n                }\n                if (order.s !== -1) {\n                    resTime.second = Number(treg[order.s]);\n                }\n                if (order.l !== -1) {\n                    resTime.millisec = Number(treg[order.l]);\n                }\n                if (order.c !== -1) {\n                    resTime.microsec = Number(treg[order.c]);\n                }\n                if (order.z !== -1 && treg[order.z] !== undefined) {\n                    resTime.timezone = $.timepicker.timezoneOffsetNumber(treg[order.z]);\n                }\n\n\n                return resTime;\n            }\n            return false;\n        };// end strictParse\n\n        // First try JS Date, if that fails, use strictParse\n        var looseParse = function (f, s, o) {\n            try {\n                var d = new Date('2012-01-01 ' + s);\n                if (isNaN(d.getTime())) {\n                    d = new Date('2012-01-01T' + s);\n                    if (isNaN(d.getTime())) {\n                        d = new Date('01/01/2012 ' + s);\n                        if (isNaN(d.getTime())) {\n                            throw \"Unable to parse time with native Date: \" + s;\n                        }\n                    }\n                }\n\n                return {\n                    hour: d.getHours(),\n                    minute: d.getMinutes(),\n                    second: d.getSeconds(),\n                    millisec: d.getMilliseconds(),\n                    microsec: d.getMicroseconds(),\n                    timezone: d.getTimezoneOffset() * -1\n                };\n            }\n            catch (err) {\n                try {\n                    return strictParse(f, s, o);\n                }\n                catch (err2) {\n                    $.timepicker.log(\"Unable to parse \\ntimeString: \" + s + \"\\ntimeFormat: \" + f);\n                }\n            }\n            return false;\n        }; // end looseParse\n\n        if (typeof o.parse === \"function\") {\n            return o.parse(timeFormat, timeString, o);\n        }\n        if (o.parse === 'loose') {\n            return looseParse(timeFormat, timeString, o);\n        }\n        return strictParse(timeFormat, timeString, o);\n    };\n\n    /**\n     * Public utility to format the time\n     * @param {string} format format of the time\n     * @param {Object} time Object not a Date for timezones\n     * @param {Object} [options] essentially the regional[].. amNames, pmNames, ampm\n     * @returns {string} the formatted time\n     */\n    $.datepicker.formatTime = function (format, time, options) {\n        options = options || {};\n        options = $.extend({}, $.timepicker._defaults, options);\n        time = $.extend({\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null\n        }, time);\n\n        var tmptime = format,\n            ampmName = options.amNames[0],\n            hour = parseInt(time.hour, 10);\n\n        if (hour > 11) {\n            ampmName = options.pmNames[0];\n        }\n\n        tmptime = tmptime.replace(/(?:HH?|hh?|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n            switch (match) {\n                case 'HH':\n                    return ('0' + hour).slice(-2);\n                case 'H':\n                    return hour;\n                case 'hh':\n                    return ('0' + convert24to12(hour)).slice(-2);\n                case 'h':\n                    return convert24to12(hour);\n                case 'mm':\n                    return ('0' + time.minute).slice(-2);\n                case 'm':\n                    return time.minute;\n                case 'ss':\n                    return ('0' + time.second).slice(-2);\n                case 's':\n                    return time.second;\n                case 'l':\n                    return ('00' + time.millisec).slice(-3);\n                case 'c':\n                    return ('00' + time.microsec).slice(-3);\n                case 'z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, false);\n                case 'Z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, true);\n                case 'T':\n                    return ampmName.charAt(0).toUpperCase();\n                case 'TT':\n                    return ampmName.toUpperCase();\n                case 't':\n                    return ampmName.charAt(0).toLowerCase();\n                case 'tt':\n                    return ampmName.toLowerCase();\n                default:\n                    return match.replace(/'/g, \"\");\n            }\n        });\n\n        return tmptime;\n    };\n\n    /*\n    * the bad hack :/ override datepicker so it doesn't close on select\n    // inspired: http://stackoverflow.com/questions/1252512/jquery-datepicker-prevent-closing-picker-when-clicking-a-date/1762378#1762378\n    */\n    $.datepicker._base_selectDate = $.datepicker._selectDate;\n    $.datepicker._selectDate = function (id, dateStr) {\n        var inst = this._getInst($(id)[0]),\n            tp_inst = this._get(inst, 'timepicker'),\n            was_inline;\n\n        if (tp_inst && inst.settings.showTimepicker) {\n            tp_inst._limitMinMaxDateTime(inst, true);\n            was_inline = inst.inline;\n            inst.inline = inst.stay_open = true;\n            //This way the onSelect handler called from calendarpicker get the full dateTime\n            this._base_selectDate(id, dateStr);\n            inst.inline = was_inline;\n            inst.stay_open = false;\n            this._notifyChange(inst);\n            this._updateDatepicker(inst);\n        } else {\n            this._base_selectDate(id, dateStr);\n        }\n    };\n\n    /*\n    * second bad hack :/ override datepicker so it triggers an event when changing the input field\n    * and does not redraw the datepicker on every selectDate event\n    */\n    $.datepicker._base_updateDatepicker = $.datepicker._updateDatepicker;\n    $.datepicker._updateDatepicker = function (inst) {\n\n        // don't popup the datepicker if there is another instance already opened\n        var input = inst.input[0];\n        if ($.datepicker._curInst && $.datepicker._curInst !== inst && $.datepicker._datepickerShowing && $.datepicker._lastInput !== input) {\n            return;\n        }\n\n        if (typeof(inst.stay_open) !== 'boolean' || inst.stay_open === false) {\n\n            this._base_updateDatepicker(inst);\n\n            // Reload the time control when changing something in the input text field.\n            var tp_inst = this._get(inst, 'timepicker');\n            if (tp_inst) {\n                tp_inst._addTimePicker(inst);\n            }\n        }\n    };\n\n    /*\n    * third bad hack :/ override datepicker so it allows spaces and colon in the input field\n    */\n    $.datepicker._base_doKeyPress = $.datepicker._doKeyPress;\n    $.datepicker._doKeyPress = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if ($.datepicker._get(inst, 'constrainInput')) {\n                var ampm = tp_inst.support.ampm,\n                    tz = tp_inst._defaults.showTimezone !== null ? tp_inst._defaults.showTimezone : tp_inst.support.timezone,\n                    dateChars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat')),\n                    datetimeChars = tp_inst._defaults.timeFormat.toString()\n                            .replace(/[hms]/g, '')\n                            .replace(/TT/g, ampm ? 'APM' : '')\n                            .replace(/Tt/g, ampm ? 'AaPpMm' : '')\n                            .replace(/tT/g, ampm ? 'AaPpMm' : '')\n                            .replace(/T/g, ampm ? 'AP' : '')\n                            .replace(/tt/g, ampm ? 'apm' : '')\n                            .replace(/t/g, ampm ? 'ap' : '') +\n                        \" \" + tp_inst._defaults.separator +\n                        tp_inst._defaults.timeSuffix +\n                        (tz ? tp_inst._defaults.timezoneList.join('') : '') +\n                        (tp_inst._defaults.amNames.join('')) + (tp_inst._defaults.pmNames.join('')) +\n                        dateChars,\n                    chr = String.fromCharCode(event.charCode === undefined ? event.keyCode : event.charCode);\n                return event.ctrlKey || (chr < ' ' || !dateChars || datetimeChars.indexOf(chr) > -1);\n            }\n        }\n\n        return $.datepicker._base_doKeyPress(event);\n    };\n\n    /*\n    * Fourth bad hack :/ override _updateAlternate function used in inline mode to init altField\n    * Update any alternate field to synchronise with the main field.\n    */\n    $.datepicker._base_updateAlternate = $.datepicker._updateAlternate;\n    $.datepicker._updateAlternate = function (inst) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var altField = tp_inst._defaults.altField;\n            if (altField) { // update alternate field too\n                var altFormat = tp_inst._defaults.altFormat || tp_inst._defaults.dateFormat,\n                    date = this._getDate(inst),\n                    formatCfg = $.datepicker._getFormatConfig(inst),\n                    altFormattedDateTime = '',\n                    altSeparator = tp_inst._defaults.altSeparator ? tp_inst._defaults.altSeparator : tp_inst._defaults.separator,\n                    altTimeSuffix = tp_inst._defaults.altTimeSuffix ? tp_inst._defaults.altTimeSuffix : tp_inst._defaults.timeSuffix,\n                    altTimeFormat = tp_inst._defaults.altTimeFormat !== null ? tp_inst._defaults.altTimeFormat : tp_inst._defaults.timeFormat;\n\n                altFormattedDateTime += $.datepicker.formatTime(altTimeFormat, tp_inst, tp_inst._defaults) + altTimeSuffix;\n                if (!tp_inst._defaults.timeOnly && !tp_inst._defaults.altFieldTimeOnly && date !== null) {\n                    if (tp_inst._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(tp_inst._defaults.altFormat, date, formatCfg) + altSeparator + altFormattedDateTime;\n                    }\n                    else {\n                        altFormattedDateTime = tp_inst.formattedDate + altSeparator + altFormattedDateTime;\n                    }\n                }\n                $(altField).val( inst.input.val() ? altFormattedDateTime : \"\");\n            }\n        }\n        else {\n            $.datepicker._base_updateAlternate(inst);\n        }\n    };\n\n    /*\n    * Override key up event to sync manual input changes.\n    */\n    $.datepicker._base_doKeyUp = $.datepicker._doKeyUp;\n    $.datepicker._doKeyUp = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                try {\n                    $.datepicker._updateDatepicker(inst);\n                } catch (err) {\n                    $.timepicker.log(err);\n                }\n            }\n        }\n\n        return $.datepicker._base_doKeyUp(event);\n    };\n\n    /*\n    * override \"Today\" button to also grab the time and set it to input field.\n    */\n    $.datepicker._base_gotoToday = $.datepicker._gotoToday;\n    $.datepicker._gotoToday = function (id) {\n        var inst = this._getInst($(id)[0]);\n        this._base_gotoToday(id);\n        var tp_inst = this._get(inst, 'timepicker');\n        if (!tp_inst) {\n            return;\n        }\n\n        var tzoffset = $.timepicker.timezoneOffsetNumber(tp_inst.timezone);\n        var now = new Date();\n        now.setMinutes(now.getMinutes() + now.getTimezoneOffset() + parseInt(tzoffset, 10));\n        this._setTime(inst, now);\n        this._setDate(inst, now);\n        tp_inst._onSelectHandler();\n    };\n\n    /*\n    * Disable & enable the Time in the datetimepicker\n    */\n    $.datepicker._disableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = false;\n            tp_inst._defaults.showTimepicker = false;\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    $.datepicker._enableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = true;\n            tp_inst._defaults.showTimepicker = true;\n            tp_inst._addTimePicker(inst); // Could be disabled on page load\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create our own set time function\n    */\n    $.datepicker._setTime = function (inst, date) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var defaults = tp_inst._defaults;\n\n            // calling _setTime with no date sets time to defaults\n            tp_inst.hour = date ? date.getHours() : defaults.hour;\n            tp_inst.minute = date ? date.getMinutes() : defaults.minute;\n            tp_inst.second = date ? date.getSeconds() : defaults.second;\n            tp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;\n            tp_inst.microsec = date ? date.getMicroseconds() : defaults.microsec;\n\n            //check if within min/max times..\n            tp_inst._limitMinMaxDateTime(inst, true);\n\n            tp_inst._onTimeChange();\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create new public method to set only time, callable as $().datepicker('setTime', date)\n    */\n    $.datepicker._setTimeDatepicker = function (target, date, withDate) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            this._setDateFromField(inst);\n            var tp_date;\n            if (date) {\n                if (typeof date === \"string\") {\n                    tp_inst._parseTime(date, withDate);\n                    tp_date = new Date();\n                    tp_date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                    tp_date.setMicroseconds(tp_inst.microsec);\n                } else {\n                    tp_date = new Date(date.getTime());\n                    tp_date.setMicroseconds(date.getMicroseconds());\n                }\n                if (tp_date.toString() === 'Invalid Date') {\n                    tp_date = undefined;\n                }\n                this._setTime(inst, tp_date);\n            }\n        }\n\n    };\n\n    /*\n    * override setDate() to allow setting time too within Date object\n    */\n    $.datepicker._base_setDateDatepicker = $.datepicker._setDateDatepicker;\n    $.datepicker._setDateDatepicker = function (target, _date) {\n        var inst = this._getInst(target);\n        var date = _date;\n        if (!inst) {\n            return;\n        }\n\n        if (typeof(_date) === 'string') {\n            date = new Date(_date);\n            if (!date.getTime()) {\n                this._base_setDateDatepicker.apply(this, arguments);\n                date = $(target).datepicker('getDate');\n            }\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        var tp_date;\n        if (date instanceof Date) {\n            tp_date = new Date(date.getTime());\n            tp_date.setMicroseconds(date.getMicroseconds());\n        } else {\n            tp_date = date;\n        }\n\n        // This is important if you are using the timezone option, javascript's Date\n        // object will only return the timezone offset for the current locale, so we\n        // adjust it accordingly.  If not using timezone option this won't matter..\n        // If a timezone is different in tp, keep the timezone as is\n        if (tp_inst && tp_date) {\n            // look out for DST if tz wasn't specified\n            if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                tp_inst.timezone = tp_date.getTimezoneOffset() * -1;\n            }\n            date = $.timepicker.timezoneAdjust(date, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()), tp_inst.timezone);\n            tp_date = $.timepicker.timezoneAdjust(tp_date, $.timepicker.timezoneOffsetString(-tp_date.getTimezoneOffset()), tp_inst.timezone);\n        }\n\n        this._updateDatepicker(inst);\n        this._base_setDateDatepicker.apply(this, arguments);\n        this._setTimeDatepicker(target, tp_date, true);\n    };\n\n    /*\n    * override getDate() to allow getting time too within Date object\n    */\n    $.datepicker._base_getDateDatepicker = $.datepicker._getDateDatepicker;\n    $.datepicker._getDateDatepicker = function (target, noDefault) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            // if it hasn't yet been defined, grab from field\n            if (inst.lastVal === undefined) {\n                this._setDateFromField(inst, noDefault);\n            }\n\n            var date = this._getDate(inst);\n\n            var currDT = null;\n\n            if (tp_inst.$altInput && tp_inst._defaults.altFieldTimeOnly) {\n                currDT = tp_inst.$input.val() + ' ' + tp_inst.$altInput.val();\n            }\n            else if (tp_inst.$input.get(0).tagName !== 'INPUT' && tp_inst.$altInput) {\n                /**\n                 * in case the datetimepicker has been applied to a non-input tag for inline UI,\n                 * and the user has not configured the plugin to display only time in altInput,\n                 * pick current date time from the altInput (and hope for the best, for now, until \"ER1\" is applied)\n                 *\n                 * @todo ER1. Since altInput can have a totally difference format, convert it to standard format by reading input format from \"altFormat\" and \"altTimeFormat\" option values\n                 */\n                currDT = tp_inst.$altInput.val();\n            }\n            else {\n                currDT = tp_inst.$input.val();\n            }\n\n            if (date && tp_inst._parseTime(currDT, !inst.settings.timeOnly)) {\n                date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                date.setMicroseconds(tp_inst.microsec);\n\n                // This is important if you are using the timezone option, javascript's Date\n                // object will only return the timezone offset for the current locale, so we\n                // adjust it accordingly.  If not using timezone option this won't matter..\n                if (tp_inst.timezone != null) {\n                    // look out for DST if tz wasn't specified\n                    if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                        tp_inst.timezone = date.getTimezoneOffset() * -1;\n                    }\n                    date = $.timepicker.timezoneAdjust(date, tp_inst.timezone, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()));\n                }\n            }\n            return date;\n        }\n        return this._base_getDateDatepicker(target, noDefault);\n    };\n\n    /*\n    * override parseDate() because UI 1.8.14 throws an error about \"Extra characters\"\n    * An option in datapicker to ignore extra format characters would be nicer.\n    */\n    $.datepicker._base_parseDate = $.datepicker.parseDate;\n    $.datepicker.parseDate = function (format, value, settings) {\n        var date;\n        try {\n            date = this._base_parseDate(format, value, settings);\n        } catch (err) {\n            // Hack!  The error message ends with a colon, a space, and\n            // the \"extra\" characters.  We rely on that instead of\n            // attempting to perfectly reproduce the parsing algorithm.\n            if (err.indexOf(\":\") >= 0) {\n                date = this._base_parseDate(format, value.substring(0, value.length - (err.length - err.indexOf(':') - 2)), settings);\n                $.timepicker.log(\"Error parsing the date string: \" + err + \"\\ndate string = \" + value + \"\\ndate format = \" + format);\n            } else {\n                throw err;\n            }\n        }\n        return date;\n    };\n\n    /*\n    * override formatDate to set date with time to the input\n    */\n    $.datepicker._base_formatDate = $.datepicker._formatDate;\n    $.datepicker._formatDate = function (inst, day, month, year) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            tp_inst._updateDateTime(inst);\n            return tp_inst.$input.val();\n        }\n        return this._base_formatDate(inst);\n    };\n\n    /*\n    * override options setter to add time to maxDate(Time) and minDate(Time). MaxDate\n    */\n    $.datepicker._base_optionDatepicker = $.datepicker._optionDatepicker;\n    $.datepicker._optionDatepicker = function (target, name, value) {\n        var inst = this._getInst(target),\n            name_clone;\n        if (!inst) {\n            return null;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var min = null,\n                max = null,\n                onselect = null,\n                overrides = tp_inst._defaults.evnts,\n                fns = {},\n                prop,\n                ret,\n                oldVal,\n                $target;\n            if (typeof name === 'string') { // if min/max was set with the string\n                if (name === 'minDate' || name === 'minDateTime') {\n                    min = value;\n                } else if (name === 'maxDate' || name === 'maxDateTime') {\n                    max = value;\n                } else if (name === 'onSelect') {\n                    onselect = value;\n                } else if (overrides.hasOwnProperty(name)) {\n                    if (typeof (value) === 'undefined') {\n                        return overrides[name];\n                    }\n                    fns[name] = value;\n                    name_clone = {}; //empty results in exiting function after overrides updated\n                }\n            } else if (typeof name === 'object') { //if min/max was set with the JSON\n                if (name.minDate) {\n                    min = name.minDate;\n                } else if (name.minDateTime) {\n                    min = name.minDateTime;\n                } else if (name.maxDate) {\n                    max = name.maxDate;\n                } else if (name.maxDateTime) {\n                    max = name.maxDateTime;\n                }\n                for (prop in overrides) {\n                    if (overrides.hasOwnProperty(prop) && name[prop]) {\n                        fns[prop] = name[prop];\n                    }\n                }\n            }\n            for (prop in fns) {\n                if (fns.hasOwnProperty(prop)) {\n                    overrides[prop] = fns[prop];\n                    if (!name_clone) { name_clone = $.extend({}, name); }\n                    delete name_clone[prop];\n                }\n            }\n            if (name_clone && isEmptyObject(name_clone)) { return; }\n            if (min) { //if min was set\n                if (min === 0) {\n                    min = new Date();\n                } else {\n                    min = new Date(min);\n                }\n                tp_inst._defaults.minDate = min;\n                tp_inst._defaults.minDateTime = min;\n            } else if (max) { //if max was set\n                if (max === 0) {\n                    max = new Date();\n                } else {\n                    max = new Date(max);\n                }\n                tp_inst._defaults.maxDate = max;\n                tp_inst._defaults.maxDateTime = max;\n            } else if (onselect) {\n                tp_inst._defaults.onSelect = onselect;\n            }\n\n            // Datepicker will override our date when we call _base_optionDatepicker when\n            // calling minDate/maxDate, so we will first grab the value, call\n            // _base_optionDatepicker, then set our value back.\n            if(min || max){\n                $target = $(target);\n                oldVal = $target.datetimepicker('getDate');\n                ret = this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n                $target.datetimepicker('setDate', oldVal);\n                return ret;\n            }\n        }\n        if (value === undefined) {\n            return this._base_optionDatepicker.call($.datepicker, target, name);\n        }\n        return this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n    };\n\n    /*\n    * jQuery isEmptyObject does not check hasOwnProperty - if someone has added to the object prototype,\n    * it will return false for all objects\n    */\n    var isEmptyObject = function (obj) {\n        var prop;\n        for (prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                return false;\n            }\n        }\n        return true;\n    };\n\n    /*\n    * jQuery extend now ignores nulls!\n    */\n    var extendRemove = function (target, props) {\n        $.extend(target, props);\n        for (var name in props) {\n            if (props[name] === null || props[name] === undefined) {\n                target[name] = props[name];\n            }\n        }\n        return target;\n    };\n\n    /*\n    * Determine by the time format which units are supported\n    * Returns an object of booleans for each unit\n    */\n    var detectSupport = function (timeFormat) {\n        var tf = timeFormat.replace(/'.*?'/g, '').toLowerCase(), // removes literals\n            isIn = function (f, t) { // does the format contain the token?\n                return f.indexOf(t) !== -1 ? true : false;\n            };\n        return {\n            hour: isIn(tf, 'h'),\n            minute: isIn(tf, 'm'),\n            second: isIn(tf, 's'),\n            millisec: isIn(tf, 'l'),\n            microsec: isIn(tf, 'c'),\n            timezone: isIn(tf, 'z'),\n            ampm: isIn(tf, 't') && isIn(timeFormat, 'h'),\n            iso8601: isIn(timeFormat, 'Z')\n        };\n    };\n\n    /*\n    * Converts 24 hour format into 12 hour\n    * Returns 12 hour without leading 0\n    */\n    var convert24to12 = function (hour) {\n        hour %= 12;\n\n        if (hour === 0) {\n            hour = 12;\n        }\n\n        return String(hour);\n    };\n\n    var computeEffectiveSetting = function (settings, property) {\n        return settings && settings[property] ? settings[property] : $.timepicker._defaults[property];\n    };\n\n    /*\n    * Splits datetime string into date and time substrings.\n    * Throws exception when date can't be parsed\n    * Returns {dateString: dateString, timeString: timeString}\n    */\n    var splitDateTime = function (dateTimeString, timeSettings) {\n        // The idea is to get the number separator occurrences in datetime and the time format requested (since time has\n        // fewer unknowns, mostly numbers and am/pm). We will use the time pattern to split.\n        var separator = computeEffectiveSetting(timeSettings, 'separator'),\n            format = computeEffectiveSetting(timeSettings, 'timeFormat'),\n            timeParts = format.split(separator), // how many occurrences of separator may be in our format?\n            timePartsLen = timeParts.length,\n            allParts = dateTimeString.split(separator),\n            allPartsLen = allParts.length;\n\n        if (allPartsLen > 1) {\n            return {\n                dateString: allParts.splice(0, allPartsLen - timePartsLen).join(separator),\n                timeString: allParts.splice(0, timePartsLen).join(separator)\n            };\n        }\n\n        return {\n            dateString: dateTimeString,\n            timeString: ''\n        };\n    };\n\n    /*\n    * Internal function to parse datetime interval\n    * Returns: {date: Date, timeObj: Object}, where\n    *   date - parsed date without time (type Date)\n    *   timeObj = {hour: , minute: , second: , millisec: , microsec: } - parsed time. Optional\n    */\n    var parseDateTimeInternal = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var date,\n            parts,\n            parsedTime;\n\n        parts = splitDateTime(dateTimeString, timeSettings);\n        date = $.datepicker._base_parseDate(dateFormat, parts.dateString, dateSettings);\n\n        if (parts.timeString === '') {\n            return {\n                date: date\n            };\n        }\n\n        parsedTime = $.datepicker.parseTime(timeFormat, parts.timeString, timeSettings);\n\n        if (!parsedTime) {\n            throw 'Wrong time format';\n        }\n\n        return {\n            date: date,\n            timeObj: parsedTime\n        };\n    };\n\n    /*\n    * Internal function to set timezone_select to the local timezone\n    */\n    var selectLocalTimezone = function (tp_inst, date) {\n        if (tp_inst && tp_inst.timezone_select) {\n            var now = date || new Date();\n            tp_inst.timezone_select.val(-now.getTimezoneOffset());\n        }\n    };\n\n    /*\n    * Create a Singleton Instance\n    */\n    $.timepicker = new Timepicker();\n\n    /**\n     * Get the timezone offset as string from a date object (eg '+0530' for UTC+5.5)\n     * @param {number} tzMinutes if not a number, less than -720 (-1200), or greater than 840 (+1400) this value is returned\n     * @param {boolean} iso8601 if true formats in accordance to iso8601 \"+12:45\"\n     * @return {string}\n     */\n    $.timepicker.timezoneOffsetString = function (tzMinutes, iso8601) {\n        if (isNaN(tzMinutes) || tzMinutes > 840 || tzMinutes < -720) {\n            return tzMinutes;\n        }\n\n        var off = tzMinutes,\n            minutes = off % 60,\n            hours = (off - minutes) / 60,\n            iso = iso8601 ? ':' : '',\n            tz = (off >= 0 ? '+' : '-') + ('0' + Math.abs(hours)).slice(-2) + iso + ('0' + Math.abs(minutes)).slice(-2);\n\n        if (tz === '+00:00') {\n            return 'Z';\n        }\n        return tz;\n    };\n\n    /**\n     * Get the number in minutes that represents a timezone string\n     * @param  {string} tzString formatted like \"+0500\", \"-1245\", \"Z\"\n     * @return {number} the offset minutes or the original string if it doesn't match expectations\n     */\n    $.timepicker.timezoneOffsetNumber = function (tzString) {\n        var normalized = tzString.toString().replace(':', ''); // excuse any iso8601, end up with \"+1245\"\n\n        if (normalized.toUpperCase() === 'Z') { // if iso8601 with Z, its 0 minute offset\n            return 0;\n        }\n\n        if (!/^(\\-|\\+)\\d{4}$/.test(normalized)) { // possibly a user defined tz, so just give it back\n            return parseInt(tzString, 10);\n        }\n\n        return ((normalized.substr(0, 1) === '-' ? -1 : 1) * // plus or minus\n            ((parseInt(normalized.substr(1, 2), 10) * 60) + // hours (converted to minutes)\n                parseInt(normalized.substr(3, 2), 10))); // minutes\n    };\n\n    /**\n     * No way to set timezone in js Date, so we must adjust the minutes to compensate. (think setDate, getDate)\n     * @param  {Date} date\n     * @param  {string} fromTimezone formatted like \"+0500\", \"-1245\"\n     * @param  {string} toTimezone formatted like \"+0500\", \"-1245\"\n     * @return {Date}\n     */\n    $.timepicker.timezoneAdjust = function (date, fromTimezone, toTimezone) {\n        var fromTz = $.timepicker.timezoneOffsetNumber(fromTimezone);\n        var toTz = $.timepicker.timezoneOffsetNumber(toTimezone);\n        if (!isNaN(toTz)) {\n            date.setMinutes(date.getMinutes() + (-fromTz) - (-toTz));\n        }\n        return date;\n    };\n\n    /**\n     * Calls `timepicker()` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * n.b. The input value must be correctly formatted (reformatting is not supported)\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the timepicker() call\n     * @return {jQuery}\n     */\n    $.timepicker.timeRange = function (startTime, endTime, options) {\n        return $.timepicker.handleRange('timepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datetimepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @return {jQuery}\n     */\n    $.timepicker.datetimeRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datetimepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.dateRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `method` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.handleRange = function (method, startTime, endTime, options) {\n        options = $.extend({}, {\n            minInterval: 0, // min allowed interval in milliseconds\n            maxInterval: 0, // max allowed interval in milliseconds\n            start: {},      // options for start picker\n            end: {}         // options for end picker\n        }, options);\n\n        // for the mean time this fixes an issue with calling getDate with timepicker()\n        var timeOnly = false;\n        if(method === 'timepicker'){\n            timeOnly = true;\n            method = 'datetimepicker';\n        }\n\n        function checkDates(changed, other) {\n            var startdt = startTime[method]('getDate'),\n                enddt = endTime[method]('getDate'),\n                changeddt = changed[method]('getDate');\n\n            if (startdt !== null) {\n                var minDate = new Date(startdt.getTime()),\n                    maxDate = new Date(startdt.getTime());\n\n                minDate.setMilliseconds(minDate.getMilliseconds() + options.minInterval);\n                maxDate.setMilliseconds(maxDate.getMilliseconds() + options.maxInterval);\n\n                if (options.minInterval > 0 && minDate > enddt) { // minInterval check\n                    endTime[method]('setDate', minDate);\n                }\n                else if (options.maxInterval > 0 && maxDate < enddt) { // max interval check\n                    endTime[method]('setDate', maxDate);\n                }\n                else if (startdt > enddt) {\n                    other[method]('setDate', changeddt);\n                }\n            }\n        }\n\n        function selected(changed, other, option) {\n            if (!changed.val()) {\n                return;\n            }\n            var date = changed[method].call(changed, 'getDate');\n            if (date !== null && options.minInterval > 0) {\n                if (option === 'minDate') {\n                    date.setMilliseconds(date.getMilliseconds() + options.minInterval);\n                }\n                if (option === 'maxDate') {\n                    date.setMilliseconds(date.getMilliseconds() - options.minInterval);\n                }\n            }\n\n            if (date.getTime) {\n                other[method].call(other, 'option', option, date);\n            }\n        }\n\n        $.fn[method].call(startTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), endTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), endTime, 'minDate');\n            }\n        }, options, options.start));\n        $.fn[method].call(endTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), startTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), startTime, 'maxDate');\n            }\n        }, options, options.end));\n\n        checkDates(startTime, endTime);\n\n        selected(startTime, endTime, 'minDate');\n        selected(endTime, startTime, 'maxDate');\n\n        return $([startTime.get(0), endTime.get(0)]);\n    };\n\n    /**\n     * Log error or data to the console during error or debugging\n     * @param  {Object} err pass any type object to log to the console during error or debugging\n     * @return {void}\n     */\n    $.timepicker.log = function () {\n        // Older IE (9, maybe 10) throw error on accessing `window.console.log.apply`, so check first.\n        if (window.console && window.console.log && window.console.log.apply) {\n            window.console.log.apply(window.console, Array.prototype.slice.call(arguments));\n        }\n    };\n\n    /*\n     * Add util object to allow access to private methods for testability.\n     */\n    $.timepicker._util = {\n        _extendRemove: extendRemove,\n        _isEmptyObject: isEmptyObject,\n        _convert24to12: convert24to12,\n        _detectSupport: detectSupport,\n        _selectLocalTimezone: selectLocalTimezone,\n        _computeEffectiveSetting: computeEffectiveSetting,\n        _splitDateTime: splitDateTime,\n        _parseDateTimeInternal: parseDateTimeInternal\n    };\n\n    /*\n    * Microsecond support\n    */\n    if (!Date.prototype.getMicroseconds) {\n        Date.prototype.microseconds = 0;\n        Date.prototype.getMicroseconds = function () { return this.microseconds; };\n        Date.prototype.setMicroseconds = function (m) {\n            this.setMilliseconds(this.getMilliseconds() + Math.floor(m / 1000));\n            this.microseconds = m % 1000;\n            return this;\n        };\n    }\n\n    /*\n    * Keep up with the version\n    */\n    $.timepicker.version = \"1.6.3\";\n\n}));\n","jquery/jquery.cookie.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-cookie/cookie-wrapper'\n], function () {\n\n});\n","jquery/jquery-ui-timepicker-addon.js":"/*! jQuery Timepicker Addon - v1.6.3 - 2016-04-20\n* http://trentrichardson.com/examples/timepicker\n* Copyright (c) 2016 Trent Richardson; Licensed MIT */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery', 'jquery/ui'], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n    /*\n    * Lets not redefine timepicker, Prevent \"Uncaught RangeError: Maximum call stack size exceeded\"\n    */\n    $.ui.timepicker = $.ui.timepicker || {};\n    if ($.ui.timepicker.version) {\n        return;\n    }\n\n    /*\n    * Extend jQueryUI, get it started with our version number\n    */\n    $.extend($.ui, {\n        timepicker: {\n            version: \"1.6.3\"\n        }\n    });\n\n    /*\n    * Timepicker manager.\n    * Use the singleton instance of this class, $.timepicker, to interact with the time picker.\n    * Settings for (groups of) time pickers are maintained in an instance object,\n    * allowing multiple different settings on the same page.\n    */\n    var Timepicker = function () {\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[''] = { // Default regional settings\n            currentText: 'Now',\n            closeText: 'Done',\n            amNames: ['AM', 'A'],\n            pmNames: ['PM', 'P'],\n            timeFormat: 'HH:mm',\n            timeSuffix: '',\n            timeOnlyTitle: 'Choose Time',\n            timeText: 'Time',\n            hourText: 'Hour',\n            minuteText: 'Minute',\n            secondText: 'Second',\n            millisecText: 'Millisecond',\n            microsecText: 'Microsecond',\n            timezoneText: 'Time Zone',\n            isRTL: false\n        };\n        this._defaults = { // Global defaults for all the datetime picker instances\n            showButtonPanel: true,\n            timeOnly: false,\n            timeOnlyShowDate: false,\n            showHour: null,\n            showMinute: null,\n            showSecond: null,\n            showMillisec: null,\n            showMicrosec: null,\n            showTimezone: null,\n            showTime: true,\n            stepHour: 1,\n            stepMinute: 1,\n            stepSecond: 1,\n            stepMillisec: 1,\n            stepMicrosec: 1,\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null,\n            hourMin: 0,\n            minuteMin: 0,\n            secondMin: 0,\n            millisecMin: 0,\n            microsecMin: 0,\n            hourMax: 23,\n            minuteMax: 59,\n            secondMax: 59,\n            millisecMax: 999,\n            microsecMax: 999,\n            minDateTime: null,\n            maxDateTime: null,\n            maxTime: null,\n            minTime: null,\n            onSelect: null,\n            hourGrid: 0,\n            minuteGrid: 0,\n            secondGrid: 0,\n            millisecGrid: 0,\n            microsecGrid: 0,\n            alwaysSetTime: true,\n            separator: ' ',\n            altFieldTimeOnly: true,\n            altTimeFormat: null,\n            altSeparator: null,\n            altTimeSuffix: null,\n            altRedirectFocus: true,\n            pickerTimeFormat: null,\n            pickerTimeSuffix: null,\n            showTimepicker: true,\n            timezoneList: null,\n            addSliderAccess: false,\n            sliderAccessArgs: null,\n            controlType: 'slider',\n            oneLine: false,\n            defaultValue: null,\n            parse: 'strict',\n            afterInject: null\n        };\n        $.extend(this._defaults, this.regional['']);\n    };\n\n    $.extend(Timepicker.prototype, {\n        $input: null,\n        $altInput: null,\n        $timeObj: null,\n        inst: null,\n        hour_slider: null,\n        minute_slider: null,\n        second_slider: null,\n        millisec_slider: null,\n        microsec_slider: null,\n        timezone_select: null,\n        maxTime: null,\n        minTime: null,\n        hour: 0,\n        minute: 0,\n        second: 0,\n        millisec: 0,\n        microsec: 0,\n        timezone: null,\n        hourMinOriginal: null,\n        minuteMinOriginal: null,\n        secondMinOriginal: null,\n        millisecMinOriginal: null,\n        microsecMinOriginal: null,\n        hourMaxOriginal: null,\n        minuteMaxOriginal: null,\n        secondMaxOriginal: null,\n        millisecMaxOriginal: null,\n        microsecMaxOriginal: null,\n        ampm: '',\n        formattedDate: '',\n        formattedTime: '',\n        formattedDateTime: '',\n        timezoneList: null,\n        units: ['hour', 'minute', 'second', 'millisec', 'microsec'],\n        support: {},\n        control: null,\n\n        /*\n        * Override the default settings for all instances of the time picker.\n        * @param  {Object} settings  object - the new settings to use as defaults (anonymous object)\n        * @return {Object} the manager object\n        */\n        setDefaults: function (settings) {\n            extendRemove(this._defaults, settings || {});\n            return this;\n        },\n\n        /*\n        * Create a new Timepicker instance\n        */\n        _newInst: function ($input, opts) {\n            var tp_inst = new Timepicker(),\n                inlineSettings = {},\n                fns = {},\n                overrides, i;\n\n            for (var attrName in this._defaults) {\n                if (this._defaults.hasOwnProperty(attrName)) {\n                    var attrValue = $input.attr('time:' + attrName);\n                    if (attrValue) {\n                        try {\n                            inlineSettings[attrName] = eval(attrValue);\n                        } catch (err) {\n                            inlineSettings[attrName] = attrValue;\n                        }\n                    }\n                }\n            }\n\n            overrides = {\n                beforeShow: function (input, dp_inst) {\n                    if ($.isFunction(tp_inst._defaults.evnts.beforeShow)) {\n                        return tp_inst._defaults.evnts.beforeShow.call($input[0], input, dp_inst, tp_inst);\n                    }\n                },\n                onChangeMonthYear: function (year, month, dp_inst) {\n                    // Update the time as well : this prevents the time from disappearing from the $input field.\n                    // tp_inst._updateDateTime(dp_inst);\n                    if ($.isFunction(tp_inst._defaults.evnts.onChangeMonthYear)) {\n                        tp_inst._defaults.evnts.onChangeMonthYear.call($input[0], year, month, dp_inst, tp_inst);\n                    }\n                },\n                onClose: function (dateText, dp_inst) {\n                    if (tp_inst.timeDefined === true && $input.val() !== '') {\n                        tp_inst._updateDateTime(dp_inst);\n                    }\n                    if ($.isFunction(tp_inst._defaults.evnts.onClose)) {\n                        tp_inst._defaults.evnts.onClose.call($input[0], dateText, dp_inst, tp_inst);\n                    }\n                }\n            };\n            for (i in overrides) {\n                if (overrides.hasOwnProperty(i)) {\n                    fns[i] = opts[i] || this._defaults[i] || null;\n                }\n            }\n\n            tp_inst._defaults = $.extend({}, this._defaults, inlineSettings, opts, overrides, {\n                evnts: fns,\n                timepicker: tp_inst // add timepicker as a property of datepicker: $.datepicker._get(dp_inst, 'timepicker');\n            });\n            tp_inst.amNames = $.map(tp_inst._defaults.amNames, function (val) {\n                return val.toUpperCase();\n            });\n            tp_inst.pmNames = $.map(tp_inst._defaults.pmNames, function (val) {\n                return val.toUpperCase();\n            });\n\n            // detect which units are supported\n            tp_inst.support = detectSupport(\n                tp_inst._defaults.timeFormat +\n                (tp_inst._defaults.pickerTimeFormat ? tp_inst._defaults.pickerTimeFormat : '') +\n                (tp_inst._defaults.altTimeFormat ? tp_inst._defaults.altTimeFormat : ''));\n\n            // controlType is string - key to our this._controls\n            if (typeof(tp_inst._defaults.controlType) === 'string') {\n                if (tp_inst._defaults.controlType === 'slider' && typeof($.ui.slider) === 'undefined') {\n                    tp_inst._defaults.controlType = 'select';\n                }\n                tp_inst.control = tp_inst._controls[tp_inst._defaults.controlType];\n            }\n            // controlType is an object and must implement create, options, value methods\n            else {\n                tp_inst.control = tp_inst._defaults.controlType;\n            }\n\n            // prep the timezone options\n            var timezoneList = [-720, -660, -600, -570, -540, -480, -420, -360, -300, -270, -240, -210, -180, -120, -60,\n                0, 60, 120, 180, 210, 240, 270, 300, 330, 345, 360, 390, 420, 480, 525, 540, 570, 600, 630, 660, 690, 720, 765, 780, 840];\n            if (tp_inst._defaults.timezoneList !== null) {\n                timezoneList = tp_inst._defaults.timezoneList;\n            }\n            var tzl = timezoneList.length, tzi = 0, tzv = null;\n            if (tzl > 0 && typeof timezoneList[0] !== 'object') {\n                for (; tzi < tzl; tzi++) {\n                    tzv = timezoneList[tzi];\n                    timezoneList[tzi] = { value: tzv, label: $.timepicker.timezoneOffsetString(tzv, tp_inst.support.iso8601) };\n                }\n            }\n            tp_inst._defaults.timezoneList = timezoneList;\n\n            // set the default units\n            tp_inst.timezone = tp_inst._defaults.timezone !== null ? $.timepicker.timezoneOffsetNumber(tp_inst._defaults.timezone) :\n                ((new Date()).getTimezoneOffset() * -1);\n            tp_inst.hour = tp_inst._defaults.hour < tp_inst._defaults.hourMin ? tp_inst._defaults.hourMin :\n                tp_inst._defaults.hour > tp_inst._defaults.hourMax ? tp_inst._defaults.hourMax : tp_inst._defaults.hour;\n            tp_inst.minute = tp_inst._defaults.minute < tp_inst._defaults.minuteMin ? tp_inst._defaults.minuteMin :\n                tp_inst._defaults.minute > tp_inst._defaults.minuteMax ? tp_inst._defaults.minuteMax : tp_inst._defaults.minute;\n            tp_inst.second = tp_inst._defaults.second < tp_inst._defaults.secondMin ? tp_inst._defaults.secondMin :\n                tp_inst._defaults.second > tp_inst._defaults.secondMax ? tp_inst._defaults.secondMax : tp_inst._defaults.second;\n            tp_inst.millisec = tp_inst._defaults.millisec < tp_inst._defaults.millisecMin ? tp_inst._defaults.millisecMin :\n                tp_inst._defaults.millisec > tp_inst._defaults.millisecMax ? tp_inst._defaults.millisecMax : tp_inst._defaults.millisec;\n            tp_inst.microsec = tp_inst._defaults.microsec < tp_inst._defaults.microsecMin ? tp_inst._defaults.microsecMin :\n                tp_inst._defaults.microsec > tp_inst._defaults.microsecMax ? tp_inst._defaults.microsecMax : tp_inst._defaults.microsec;\n            tp_inst.ampm = '';\n            tp_inst.$input = $input;\n\n            if (tp_inst._defaults.altField) {\n                tp_inst.$altInput = $(tp_inst._defaults.altField);\n                if (tp_inst._defaults.altRedirectFocus === true) {\n                    tp_inst.$altInput.css({\n                        cursor: 'pointer'\n                    }).focus(function () {\n                        $input.trigger(\"focus\");\n                    });\n                }\n            }\n\n            if (tp_inst._defaults.minDate === 0 || tp_inst._defaults.minDateTime === 0) {\n                tp_inst._defaults.minDate = new Date();\n            }\n            if (tp_inst._defaults.maxDate === 0 || tp_inst._defaults.maxDateTime === 0) {\n                tp_inst._defaults.maxDate = new Date();\n            }\n\n            // datepicker needs minDate/maxDate, timepicker needs minDateTime/maxDateTime..\n            if (tp_inst._defaults.minDate !== undefined && tp_inst._defaults.minDate instanceof Date) {\n                tp_inst._defaults.minDateTime = new Date(tp_inst._defaults.minDate.getTime());\n            }\n            if (tp_inst._defaults.minDateTime !== undefined && tp_inst._defaults.minDateTime instanceof Date) {\n                tp_inst._defaults.minDate = new Date(tp_inst._defaults.minDateTime.getTime());\n            }\n            if (tp_inst._defaults.maxDate !== undefined && tp_inst._defaults.maxDate instanceof Date) {\n                tp_inst._defaults.maxDateTime = new Date(tp_inst._defaults.maxDate.getTime());\n            }\n            if (tp_inst._defaults.maxDateTime !== undefined && tp_inst._defaults.maxDateTime instanceof Date) {\n                tp_inst._defaults.maxDate = new Date(tp_inst._defaults.maxDateTime.getTime());\n            }\n            tp_inst.$input.bind('focus', function () {\n                tp_inst._onFocus();\n            });\n\n            return tp_inst;\n        },\n\n        /*\n        * add our sliders to the calendar\n        */\n        _addTimePicker: function (dp_inst) {\n            var currDT = $.trim((this.$altInput && this._defaults.altFieldTimeOnly) ? this.$input.val() + ' ' + this.$altInput.val() : this.$input.val());\n\n            this.timeDefined = this._parseTime(currDT);\n            this._limitMinMaxDateTime(dp_inst, false);\n            this._injectTimePicker();\n            this._afterInject();\n        },\n\n        /*\n        * parse the time string from input value or _setTime\n        */\n        _parseTime: function (timeString, withDate) {\n            if (!this.inst) {\n                this.inst = $.datepicker._getInst(this.$input[0]);\n            }\n\n            if (withDate || !this._defaults.timeOnly) {\n                var dp_dateFormat = $.datepicker._get(this.inst, 'dateFormat');\n                try {\n                    var parseRes = parseDateTimeInternal(dp_dateFormat, this._defaults.timeFormat, timeString, $.datepicker._getFormatConfig(this.inst), this._defaults);\n                    if (!parseRes.timeObj) {\n                        return false;\n                    }\n                    $.extend(this, parseRes.timeObj);\n                } catch (err) {\n                    $.timepicker.log(\"Error parsing the date/time string: \" + err +\n                        \"\\ndate/time string = \" + timeString +\n                        \"\\ntimeFormat = \" + this._defaults.timeFormat +\n                        \"\\ndateFormat = \" + dp_dateFormat);\n                    return false;\n                }\n                return true;\n            } else {\n                var timeObj = $.datepicker.parseTime(this._defaults.timeFormat, timeString, this._defaults);\n                if (!timeObj) {\n                    return false;\n                }\n                $.extend(this, timeObj);\n                return true;\n            }\n        },\n\n        /*\n        * Handle callback option after injecting timepicker\n        */\n        _afterInject: function() {\n            var o = this.inst.settings;\n            if ($.isFunction(o.afterInject)) {\n                o.afterInject.call(this);\n            }\n        },\n\n        /*\n        * generate and inject html for timepicker into ui datepicker\n        */\n        _injectTimePicker: function () {\n            var $dp = this.inst.dpDiv,\n                o = this.inst.settings,\n                tp_inst = this,\n                litem = '',\n                uitem = '',\n                show = null,\n                max = {},\n                gridSize = {},\n                size = null,\n                i = 0,\n                l = 0;\n\n            // Prevent displaying twice\n            if ($dp.find(\"div.ui-timepicker-div\").length === 0 && o.showTimepicker) {\n                var noDisplay = ' ui_tpicker_unit_hide',\n                    html = '<div class=\"ui-timepicker-div' + (o.isRTL ? ' ui-timepicker-rtl' : '') + (o.oneLine && o.controlType === 'select' ? ' ui-timepicker-oneLine' : '') + '\"><dl>' + '<dt class=\"ui_tpicker_time_label' + ((o.showTime) ? '' : noDisplay) + '\">' + o.timeText + '</dt>' +\n                        '<dd class=\"ui_tpicker_time '+ ((o.showTime) ? '' : noDisplay) + '\"><input class=\"ui_tpicker_time_input\" ' + (o.timeInput ? '' : 'disabled') + '/></dd>';\n\n                // Create the markup\n                for (i = 0, l = this.units.length; i < l; i++) {\n                    litem = this.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // Added by Peter Medeiros:\n                    // - Figure out what the hour/minute/second max should be based on the step values.\n                    // - Example: if stepMinute is 15, then minMax is 45.\n                    max[litem] = parseInt((o[litem + 'Max'] - ((o[litem + 'Max'] - o[litem + 'Min']) % o['step' + uitem])), 10);\n                    gridSize[litem] = 0;\n\n                    html += '<dt class=\"ui_tpicker_' + litem + '_label' + (show ? '' : noDisplay) + '\">' + o[litem + 'Text'] + '</dt>' +\n                        '<dd class=\"ui_tpicker_' + litem + (show ? '' : noDisplay) + '\"><div class=\"ui_tpicker_' + litem + '_slider' + (show ? '' : noDisplay) + '\"></div>';\n\n                    if (show && o[litem + 'Grid'] > 0) {\n                        html += '<div style=\"padding-left: 1px\"><table class=\"ui-tpicker-grid-label\"><tr>';\n\n                        if (litem === 'hour') {\n                            for (var h = o[litem + 'Min']; h <= max[litem]; h += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                var tmph = $.datepicker.formatTime(this.support.ampm ? 'hht' : 'HH', {hour: h}, o);\n                                html += '<td data-for=\"' + litem + '\">' + tmph + '</td>';\n                            }\n                        }\n                        else {\n                            for (var m = o[litem + 'Min']; m <= max[litem]; m += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                html += '<td data-for=\"' + litem + '\">' + ((m < 10) ? '0' : '') + m + '</td>';\n                            }\n                        }\n\n                        html += '</tr></table></div>';\n                    }\n                    html += '</dd>';\n                }\n\n                // Timezone\n                var showTz = o.showTimezone !== null ? o.showTimezone : this.support.timezone;\n                html += '<dt class=\"ui_tpicker_timezone_label' + (showTz ? '' : noDisplay) + '\">' + o.timezoneText + '</dt>';\n                html += '<dd class=\"ui_tpicker_timezone' + (showTz ? '' : noDisplay) + '\"></dd>';\n\n                // Create the elements from string\n                html += '</dl></div>';\n                var $tp = $(html);\n\n                // if we only want time picker...\n                if (o.timeOnly === true) {\n                    $tp.prepend('<div class=\"ui-widget-header ui-helper-clearfix ui-corner-all\">' + '<div class=\"ui-datepicker-title\">' + o.timeOnlyTitle + '</div>' + '</div>');\n                    $dp.find('.ui-datepicker-header, .ui-datepicker-calendar').hide();\n                }\n\n                // add sliders, adjust grids, add events\n                for (i = 0, l = tp_inst.units.length; i < l; i++) {\n                    litem = tp_inst.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // add the slider\n                    tp_inst[litem + '_slider'] = tp_inst.control.create(tp_inst, $tp.find('.ui_tpicker_' + litem + '_slider'), litem, tp_inst[litem], o[litem + 'Min'], max[litem], o['step' + uitem]);\n\n                    // adjust the grid and add click event\n                    if (show && o[litem + 'Grid'] > 0) {\n                        size = 100 * gridSize[litem] * o[litem + 'Grid'] / (max[litem] - o[litem + 'Min']);\n                        $tp.find('.ui_tpicker_' + litem + ' table').css({\n                            width: size + \"%\",\n                            marginLeft: o.isRTL ? '0' : ((size / (-2 * gridSize[litem])) + \"%\"),\n                            marginRight: o.isRTL ? ((size / (-2 * gridSize[litem])) + \"%\") : '0',\n                            borderCollapse: 'collapse'\n                        }).find(\"td\").click(function (e) {\n                            var $t = $(this),\n                                h = $t.html(),\n                                n = parseInt(h.replace(/[^0-9]/g), 10),\n                                ap = h.replace(/[^apm]/ig),\n                                f = $t.data('for'); // loses scope, so we use data-for\n\n                            if (f === 'hour') {\n                                if (ap.indexOf('p') !== -1 && n < 12) {\n                                    n += 12;\n                                }\n                                else {\n                                    if (ap.indexOf('a') !== -1 && n === 12) {\n                                        n = 0;\n                                    }\n                                }\n                            }\n\n                            tp_inst.control.value(tp_inst, tp_inst[f + '_slider'], litem, n);\n\n                            tp_inst._onTimeChange();\n                            tp_inst._onSelectHandler();\n                        }).css({\n                            cursor: 'pointer',\n                            width: (100 / gridSize[litem]) + '%',\n                            textAlign: 'center',\n                            overflow: 'hidden'\n                        });\n                    } // end if grid > 0\n                } // end for loop\n\n                // Add timezone options\n                this.timezone_select = $tp.find('.ui_tpicker_timezone').append('<select></select>').find(\"select\");\n                $.fn.append.apply(this.timezone_select,\n                    $.map(o.timezoneList, function (val, idx) {\n                        return $(\"<option />\").val(typeof val === \"object\" ? val.value : val).text(typeof val === \"object\" ? val.label : val);\n                    }));\n                if (typeof(this.timezone) !== \"undefined\" && this.timezone !== null && this.timezone !== \"\") {\n                    var local_timezone = (new Date(this.inst.selectedYear, this.inst.selectedMonth, this.inst.selectedDay, 12)).getTimezoneOffset() * -1;\n                    if (local_timezone === this.timezone) {\n                        selectLocalTimezone(tp_inst);\n                    } else {\n                        this.timezone_select.val(this.timezone);\n                    }\n                } else {\n                    if (typeof(this.hour) !== \"undefined\" && this.hour !== null && this.hour !== \"\") {\n                        this.timezone_select.val(o.timezone);\n                    } else {\n                        selectLocalTimezone(tp_inst);\n                    }\n                }\n                this.timezone_select.change(function () {\n                    tp_inst._onTimeChange();\n                    tp_inst._onSelectHandler();\n                    tp_inst._afterInject();\n                });\n                // End timezone options\n\n                // inject timepicker into datepicker\n                var $buttonPanel = $dp.find('.ui-datepicker-buttonpane');\n                if ($buttonPanel.length) {\n                    $buttonPanel.before($tp);\n                } else {\n                    $dp.append($tp);\n                }\n\n                this.$timeObj = $tp.find('.ui_tpicker_time_input');\n                this.$timeObj.change(function () {\n                    var timeFormat = tp_inst.inst.settings.timeFormat;\n                    var parsedTime = $.datepicker.parseTime(timeFormat, this.value);\n                    var update = new Date();\n                    if (parsedTime) {\n                        update.setHours(parsedTime.hour);\n                        update.setMinutes(parsedTime.minute);\n                        update.setSeconds(parsedTime.second);\n                        $.datepicker._setTime(tp_inst.inst, update);\n                    } else {\n                        this.value = tp_inst.formattedTime;\n                        this.blur();\n                    }\n                });\n\n                if (this.inst !== null) {\n                    var timeDefined = this.timeDefined;\n                    this._onTimeChange();\n                    this.timeDefined = timeDefined;\n                }\n\n                // slideAccess integration: http://trentrichardson.com/2011/11/11/jquery-ui-sliders-and-touch-accessibility/\n                if (this._defaults.addSliderAccess) {\n                    var sliderAccessArgs = this._defaults.sliderAccessArgs,\n                        rtl = this._defaults.isRTL;\n                    sliderAccessArgs.isRTL = rtl;\n\n                    setTimeout(function () { // fix for inline mode\n                        if ($tp.find('.ui-slider-access').length === 0) {\n                            $tp.find('.ui-slider:visible').sliderAccess(sliderAccessArgs);\n\n                            // fix any grids since sliders are shorter\n                            var sliderAccessWidth = $tp.find('.ui-slider-access:eq(0)').outerWidth(true);\n                            if (sliderAccessWidth) {\n                                $tp.find('table:visible').each(function () {\n                                    var $g = $(this),\n                                        oldWidth = $g.outerWidth(),\n                                        oldMarginLeft = $g.css(rtl ? 'marginRight' : 'marginLeft').toString().replace('%', ''),\n                                        newWidth = oldWidth - sliderAccessWidth,\n                                        newMarginLeft = ((oldMarginLeft * newWidth) / oldWidth) + '%',\n                                        css = { width: newWidth, marginRight: 0, marginLeft: 0 };\n                                    css[rtl ? 'marginRight' : 'marginLeft'] = newMarginLeft;\n                                    $g.css(css);\n                                });\n                            }\n                        }\n                    }, 10);\n                }\n                // end slideAccess integration\n\n                tp_inst._limitMinMaxDateTime(this.inst, true);\n            }\n        },\n\n        /*\n        * This function tries to limit the ability to go outside the\n        * min/max date range\n        */\n        _limitMinMaxDateTime: function (dp_inst, adjustSliders) {\n            var o = this._defaults,\n                dp_date = new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay);\n\n            if (!this._defaults.showTimepicker) {\n                return;\n            } // No time so nothing to check here\n\n            if ($.datepicker._get(dp_inst, 'minDateTime') !== null && $.datepicker._get(dp_inst, 'minDateTime') !== undefined && dp_date) {\n                var minDateTime = $.datepicker._get(dp_inst, 'minDateTime'),\n                    minDateTimeDate = new Date(minDateTime.getFullYear(), minDateTime.getMonth(), minDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMinOriginal === null || this.minuteMinOriginal === null || this.secondMinOriginal === null || this.millisecMinOriginal === null || this.microsecMinOriginal === null) {\n                    this.hourMinOriginal = o.hourMin;\n                    this.minuteMinOriginal = o.minuteMin;\n                    this.secondMinOriginal = o.secondMin;\n                    this.millisecMinOriginal = o.millisecMin;\n                    this.microsecMinOriginal = o.microsecMin;\n                }\n\n                if (dp_inst.settings.timeOnly || minDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMin = minDateTime.getHours();\n                    if (this.hour <= this._defaults.hourMin) {\n                        this.hour = this._defaults.hourMin;\n                        this._defaults.minuteMin = minDateTime.getMinutes();\n                        if (this.minute <= this._defaults.minuteMin) {\n                            this.minute = this._defaults.minuteMin;\n                            this._defaults.secondMin = minDateTime.getSeconds();\n                            if (this.second <= this._defaults.secondMin) {\n                                this.second = this._defaults.secondMin;\n                                this._defaults.millisecMin = minDateTime.getMilliseconds();\n                                if (this.millisec <= this._defaults.millisecMin) {\n                                    this.millisec = this._defaults.millisecMin;\n                                    this._defaults.microsecMin = minDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec < this._defaults.microsecMin) {\n                                        this.microsec = this._defaults.microsecMin;\n                                    }\n                                    this._defaults.microsecMin = this.microsecMinOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMin = this.millisecMinOriginal;\n                                this._defaults.microsecMin = this.microsecMinOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMin = this.secondMinOriginal;\n                            this._defaults.millisecMin = this.millisecMinOriginal;\n                            this._defaults.microsecMin = this.microsecMinOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMin = this.minuteMinOriginal;\n                        this._defaults.secondMin = this.secondMinOriginal;\n                        this._defaults.millisecMin = this.millisecMinOriginal;\n                        this._defaults.microsecMin = this.microsecMinOriginal;\n                    }\n                } else {\n                    this._defaults.hourMin = this.hourMinOriginal;\n                    this._defaults.minuteMin = this.minuteMinOriginal;\n                    this._defaults.secondMin = this.secondMinOriginal;\n                    this._defaults.millisecMin = this.millisecMinOriginal;\n                    this._defaults.microsecMin = this.microsecMinOriginal;\n                }\n            }\n\n            if ($.datepicker._get(dp_inst, 'maxDateTime') !== null && $.datepicker._get(dp_inst, 'maxDateTime') !== undefined && dp_date) {\n                var maxDateTime = $.datepicker._get(dp_inst, 'maxDateTime'),\n                    maxDateTimeDate = new Date(maxDateTime.getFullYear(), maxDateTime.getMonth(), maxDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMaxOriginal === null || this.minuteMaxOriginal === null || this.secondMaxOriginal === null || this.millisecMaxOriginal === null) {\n                    this.hourMaxOriginal = o.hourMax;\n                    this.minuteMaxOriginal = o.minuteMax;\n                    this.secondMaxOriginal = o.secondMax;\n                    this.millisecMaxOriginal = o.millisecMax;\n                    this.microsecMaxOriginal = o.microsecMax;\n                }\n\n                if (dp_inst.settings.timeOnly || maxDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMax = maxDateTime.getHours();\n                    if (this.hour >= this._defaults.hourMax) {\n                        this.hour = this._defaults.hourMax;\n                        this._defaults.minuteMax = maxDateTime.getMinutes();\n                        if (this.minute >= this._defaults.minuteMax) {\n                            this.minute = this._defaults.minuteMax;\n                            this._defaults.secondMax = maxDateTime.getSeconds();\n                            if (this.second >= this._defaults.secondMax) {\n                                this.second = this._defaults.secondMax;\n                                this._defaults.millisecMax = maxDateTime.getMilliseconds();\n                                if (this.millisec >= this._defaults.millisecMax) {\n                                    this.millisec = this._defaults.millisecMax;\n                                    this._defaults.microsecMax = maxDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec > this._defaults.microsecMax) {\n                                        this.microsec = this._defaults.microsecMax;\n                                    }\n                                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMax = this.millisecMaxOriginal;\n                                this._defaults.microsecMax = this.microsecMaxOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMax = this.secondMaxOriginal;\n                            this._defaults.millisecMax = this.millisecMaxOriginal;\n                            this._defaults.microsecMax = this.microsecMaxOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMax = this.minuteMaxOriginal;\n                        this._defaults.secondMax = this.secondMaxOriginal;\n                        this._defaults.millisecMax = this.millisecMaxOriginal;\n                        this._defaults.microsecMax = this.microsecMaxOriginal;\n                    }\n                } else {\n                    this._defaults.hourMax = this.hourMaxOriginal;\n                    this._defaults.minuteMax = this.minuteMaxOriginal;\n                    this._defaults.secondMax = this.secondMaxOriginal;\n                    this._defaults.millisecMax = this.millisecMaxOriginal;\n                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                }\n            }\n\n            if (dp_inst.settings.minTime!==null) {\n                var tempMinTime=new Date(\"01/01/1970 \" + dp_inst.settings.minTime);\n                if (this.hour<tempMinTime.getHours()) {\n                    this.hour=this._defaults.hourMin=tempMinTime.getHours();\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else if (this.hour===tempMinTime.getHours() && this.minute<tempMinTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMin<tempMinTime.getHours()) {\n                        this._defaults.hourMin=tempMinTime.getHours();\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else if (this._defaults.hourMin===tempMinTime.getHours()===this.hour && this._defaults.minuteMin<tempMinTime.getMinutes()) {\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMin=0;\n                    }\n                }\n            }\n\n            if (dp_inst.settings.maxTime!==null) {\n                var tempMaxTime=new Date(\"01/01/1970 \" + dp_inst.settings.maxTime);\n                if (this.hour>tempMaxTime.getHours()) {\n                    this.hour=this._defaults.hourMax=tempMaxTime.getHours();\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else if (this.hour===tempMaxTime.getHours() && this.minute>tempMaxTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMax>tempMaxTime.getHours()) {\n                        this._defaults.hourMax=tempMaxTime.getHours();\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else if (this._defaults.hourMax===tempMaxTime.getHours()===this.hour && this._defaults.minuteMax>tempMaxTime.getMinutes()) {\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMax=59;\n                    }\n                }\n            }\n\n            if (adjustSliders !== undefined && adjustSliders === true) {\n                var hourMax = parseInt((this._defaults.hourMax - ((this._defaults.hourMax - this._defaults.hourMin) % this._defaults.stepHour)), 10),\n                    minMax = parseInt((this._defaults.minuteMax - ((this._defaults.minuteMax - this._defaults.minuteMin) % this._defaults.stepMinute)), 10),\n                    secMax = parseInt((this._defaults.secondMax - ((this._defaults.secondMax - this._defaults.secondMin) % this._defaults.stepSecond)), 10),\n                    millisecMax = parseInt((this._defaults.millisecMax - ((this._defaults.millisecMax - this._defaults.millisecMin) % this._defaults.stepMillisec)), 10),\n                    microsecMax = parseInt((this._defaults.microsecMax - ((this._defaults.microsecMax - this._defaults.microsecMin) % this._defaults.stepMicrosec)), 10);\n\n                if (this.hour_slider) {\n                    this.control.options(this, this.hour_slider, 'hour', { min: this._defaults.hourMin, max: hourMax, step: this._defaults.stepHour });\n                    this.control.value(this, this.hour_slider, 'hour', this.hour - (this.hour % this._defaults.stepHour));\n                }\n                if (this.minute_slider) {\n                    this.control.options(this, this.minute_slider, 'minute', { min: this._defaults.minuteMin, max: minMax, step: this._defaults.stepMinute });\n                    this.control.value(this, this.minute_slider, 'minute', this.minute - (this.minute % this._defaults.stepMinute));\n                }\n                if (this.second_slider) {\n                    this.control.options(this, this.second_slider, 'second', { min: this._defaults.secondMin, max: secMax, step: this._defaults.stepSecond });\n                    this.control.value(this, this.second_slider, 'second', this.second - (this.second % this._defaults.stepSecond));\n                }\n                if (this.millisec_slider) {\n                    this.control.options(this, this.millisec_slider, 'millisec', { min: this._defaults.millisecMin, max: millisecMax, step: this._defaults.stepMillisec });\n                    this.control.value(this, this.millisec_slider, 'millisec', this.millisec - (this.millisec % this._defaults.stepMillisec));\n                }\n                if (this.microsec_slider) {\n                    this.control.options(this, this.microsec_slider, 'microsec', { min: this._defaults.microsecMin, max: microsecMax, step: this._defaults.stepMicrosec });\n                    this.control.value(this, this.microsec_slider, 'microsec', this.microsec - (this.microsec % this._defaults.stepMicrosec));\n                }\n            }\n\n        },\n\n        /*\n        * when a slider moves, set the internal time...\n        * on time change is also called when the time is updated in the text field\n        */\n        _onTimeChange: function () {\n            if (!this._defaults.showTimepicker) {\n                return;\n            }\n            var hour = (this.hour_slider) ? this.control.value(this, this.hour_slider, 'hour') : false,\n                minute = (this.minute_slider) ? this.control.value(this, this.minute_slider, 'minute') : false,\n                second = (this.second_slider) ? this.control.value(this, this.second_slider, 'second') : false,\n                millisec = (this.millisec_slider) ? this.control.value(this, this.millisec_slider, 'millisec') : false,\n                microsec = (this.microsec_slider) ? this.control.value(this, this.microsec_slider, 'microsec') : false,\n                timezone = (this.timezone_select) ? this.timezone_select.val() : false,\n                o = this._defaults,\n                pickerTimeFormat = o.pickerTimeFormat || o.timeFormat,\n                pickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;\n\n            if (typeof(hour) === 'object') {\n                hour = false;\n            }\n            if (typeof(minute) === 'object') {\n                minute = false;\n            }\n            if (typeof(second) === 'object') {\n                second = false;\n            }\n            if (typeof(millisec) === 'object') {\n                millisec = false;\n            }\n            if (typeof(microsec) === 'object') {\n                microsec = false;\n            }\n            if (typeof(timezone) === 'object') {\n                timezone = false;\n            }\n\n            if (hour !== false) {\n                hour = parseInt(hour, 10);\n            }\n            if (minute !== false) {\n                minute = parseInt(minute, 10);\n            }\n            if (second !== false) {\n                second = parseInt(second, 10);\n            }\n            if (millisec !== false) {\n                millisec = parseInt(millisec, 10);\n            }\n            if (microsec !== false) {\n                microsec = parseInt(microsec, 10);\n            }\n            if (timezone !== false) {\n                timezone = timezone.toString();\n            }\n\n            var ampm = o[hour < 12 ? 'amNames' : 'pmNames'][0];\n\n            // If the update was done in the input field, the input field should not be updated.\n            // If the update was done using the sliders, update the input field.\n            var hasChanged = (\n                hour !== parseInt(this.hour,10) || // sliders should all be numeric\n                minute !== parseInt(this.minute,10) ||\n                second !== parseInt(this.second,10) ||\n                millisec !== parseInt(this.millisec,10) ||\n                microsec !== parseInt(this.microsec,10) ||\n                (this.ampm.length > 0 && (hour < 12) !== ($.inArray(this.ampm.toUpperCase(), this.amNames) !== -1)) ||\n                (this.timezone !== null && timezone !== this.timezone.toString()) // could be numeric or \"EST\" format, so use toString()\n            );\n\n            if (hasChanged) {\n\n                if (hour !== false) {\n                    this.hour = hour;\n                }\n                if (minute !== false) {\n                    this.minute = minute;\n                }\n                if (second !== false) {\n                    this.second = second;\n                }\n                if (millisec !== false) {\n                    this.millisec = millisec;\n                }\n                if (microsec !== false) {\n                    this.microsec = microsec;\n                }\n                if (timezone !== false) {\n                    this.timezone = timezone;\n                }\n\n                if (!this.inst) {\n                    this.inst = $.datepicker._getInst(this.$input[0]);\n                }\n\n                this._limitMinMaxDateTime(this.inst, true);\n            }\n            if (this.support.ampm) {\n                this.ampm = ampm;\n            }\n\n            // Updates the time within the timepicker\n            this.formattedTime = $.datepicker.formatTime(o.timeFormat, this, o);\n            if (this.$timeObj) {\n                if (pickerTimeFormat === o.timeFormat) {\n                    this.$timeObj.val(this.formattedTime + pickerTimeSuffix);\n                }\n                else {\n                    this.$timeObj.val($.datepicker.formatTime(pickerTimeFormat, this, o) + pickerTimeSuffix);\n                }\n                if (this.$timeObj[0].setSelectionRange) {\n                    var sPos = this.$timeObj[0].selectionStart;\n                    var ePos = this.$timeObj[0].selectionEnd;\n                    this.$timeObj[0].setSelectionRange(sPos, ePos);\n                }\n            }\n\n            this.timeDefined = true;\n            if (hasChanged) {\n                this._updateDateTime();\n                //this.$input.focus(); // may automatically open the picker on setDate\n            }\n        },\n\n        /*\n        * call custom onSelect.\n        * bind to sliders slidestop, and grid click.\n        */\n        _onSelectHandler: function () {\n            var onSelect = this._defaults.onSelect || this.inst.settings.onSelect;\n            var inputEl = this.$input ? this.$input[0] : null;\n            if (onSelect && inputEl) {\n                onSelect.apply(inputEl, [this.formattedDateTime, this]);\n            }\n        },\n\n        /*\n        * update our input with the new date time..\n        */\n        _updateDateTime: function (dp_inst) {\n            dp_inst = this.inst || dp_inst;\n            var dtTmp = (dp_inst.currentYear > 0?\n                new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay) :\n                new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                dt = $.datepicker._daylightSavingAdjust(dtTmp),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay)),\n                dateFmt = $.datepicker._get(dp_inst, 'dateFormat'),\n                formatCfg = $.datepicker._getFormatConfig(dp_inst),\n                timeAvailable = dt !== null && this.timeDefined;\n            this.formattedDate = $.datepicker.formatDate(dateFmt, (dt === null ? new Date() : dt), formatCfg);\n            var formattedDateTime = this.formattedDate;\n\n            // if a slider was changed but datepicker doesn't have a value yet, set it\n            if (dp_inst.lastVal === \"\") {\n                dp_inst.currentYear = dp_inst.selectedYear;\n                dp_inst.currentMonth = dp_inst.selectedMonth;\n                dp_inst.currentDay = dp_inst.selectedDay;\n            }\n\n            /*\n            * remove following lines to force every changes in date picker to change the input value\n            * Bug descriptions: when an input field has a default value, and click on the field to pop up the date picker.\n            * If the user manually empty the value in the input field, the date picker will never change selected value.\n            */\n            //if (dp_inst.lastVal !== undefined && (dp_inst.lastVal.length > 0 && this.$input.val().length === 0)) {\n            //\treturn;\n            //}\n\n            if (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === false) {\n                formattedDateTime = this.formattedTime;\n            } else if ((this._defaults.timeOnly !== true && (this._defaults.alwaysSetTime || timeAvailable)) || (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === true)) {\n                formattedDateTime += this._defaults.separator + this.formattedTime + this._defaults.timeSuffix;\n            }\n\n            this.formattedDateTime = formattedDateTime;\n\n            if (!this._defaults.showTimepicker) {\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput && this._defaults.timeOnly === false && this._defaults.altFieldTimeOnly === true) {\n                this.$altInput.val(this.formattedTime);\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput) {\n                this.$input.val(formattedDateTime);\n                var altFormattedDateTime = '',\n                    altSeparator = this._defaults.altSeparator !== null ? this._defaults.altSeparator : this._defaults.separator,\n                    altTimeSuffix = this._defaults.altTimeSuffix !== null ? this._defaults.altTimeSuffix : this._defaults.timeSuffix;\n\n                if (!this._defaults.timeOnly) {\n                    if (this._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(this._defaults.altFormat, (dt === null ? new Date() : dt), formatCfg);\n                    }\n                    else {\n                        altFormattedDateTime = this.formattedDate;\n                    }\n\n                    if (altFormattedDateTime) {\n                        altFormattedDateTime += altSeparator;\n                    }\n                }\n\n                if (this._defaults.altTimeFormat !== null) {\n                    altFormattedDateTime += $.datepicker.formatTime(this._defaults.altTimeFormat, this, this._defaults) + altTimeSuffix;\n                }\n                else {\n                    altFormattedDateTime += this.formattedTime + altTimeSuffix;\n                }\n                this.$altInput.val(altFormattedDateTime);\n            } else {\n                this.$input.val(formattedDateTime);\n            }\n\n            this.$input.trigger(\"change\");\n        },\n\n        _onFocus: function () {\n            if (!this.$input.val() && this._defaults.defaultValue) {\n                this.$input.val(this._defaults.defaultValue);\n                var inst = $.datepicker._getInst(this.$input.get(0)),\n                    tp_inst = $.datepicker._get(inst, 'timepicker');\n                if (tp_inst) {\n                    if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                        try {\n                            $.datepicker._updateDatepicker(inst);\n                        } catch (err) {\n                            $.timepicker.log(err);\n                        }\n                    }\n                }\n            }\n        },\n\n        /*\n        * Small abstraction to control types\n        * We can add more, just be sure to follow the pattern: create, options, value\n        */\n        _controls: {\n            // slider methods\n            slider: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var rtl = tp_inst._defaults.isRTL; // if rtl go -60->0 instead of 0->60\n                    return obj.prop('slide', null).slider({\n                        orientation: \"horizontal\",\n                        value: rtl ? val * -1 : val,\n                        min: rtl ? max * -1 : min,\n                        max: rtl ? min * -1 : max,\n                        step: step,\n                        slide: function (event, ui) {\n                            tp_inst.control.value(tp_inst, $(this), unit, rtl ? ui.value * -1 : ui.value);\n                            tp_inst._onTimeChange();\n                        },\n                        stop: function (event, ui) {\n                            tp_inst._onSelectHandler();\n                        }\n                    });\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (typeof(opts) === 'string') {\n                            if (opts === 'min' || opts === 'max') {\n                                if (val !== undefined) {\n                                    return obj.slider(opts, val * -1);\n                                }\n                                return Math.abs(obj.slider(opts));\n                            }\n                            return obj.slider(opts);\n                        }\n                        var min = opts.min,\n                            max = opts.max;\n                        opts.min = opts.max = null;\n                        if (min !== undefined) {\n                            opts.max = min * -1;\n                        }\n                        if (max !== undefined) {\n                            opts.min = max * -1;\n                        }\n                        return obj.slider(opts);\n                    }\n                    if (typeof(opts) === 'string' && val !== undefined) {\n                        return obj.slider(opts, val);\n                    }\n                    return obj.slider(opts);\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (val !== undefined) {\n                            return obj.slider('value', val * -1);\n                        }\n                        return Math.abs(obj.slider('value'));\n                    }\n                    if (val !== undefined) {\n                        return obj.slider('value', val);\n                    }\n                    return obj.slider('value');\n                }\n            },\n            // select methods\n            select: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var sel = '<select class=\"ui-timepicker-select ui-state-default ui-corner-all\" data-unit=\"' + unit + '\" data-min=\"' + min + '\" data-max=\"' + max + '\" data-step=\"' + step + '\">',\n                        format = tp_inst._defaults.pickerTimeFormat || tp_inst._defaults.timeFormat;\n\n                    for (var i = min; i <= max; i += step) {\n                        sel += '<option value=\"' + i + '\"' + (i === val ? ' selected' : '') + '>';\n                        if (unit === 'hour') {\n                            sel += $.datepicker.formatTime($.trim(format.replace(/[^ht ]/ig, '')), {hour: i}, tp_inst._defaults);\n                        }\n                        else if (unit === 'millisec' || unit === 'microsec' || i >= 10) { sel += i; }\n                        else {sel += '0' + i.toString(); }\n                        sel += '</option>';\n                    }\n                    sel += '</select>';\n\n                    obj.children('select').remove();\n\n                    $(sel).appendTo(obj).change(function (e) {\n                        tp_inst._onTimeChange();\n                        tp_inst._onSelectHandler();\n                        tp_inst._afterInject();\n                    });\n\n                    return obj;\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    var o = {},\n                        $t = obj.children('select');\n                    if (typeof(opts) === 'string') {\n                        if (val === undefined) {\n                            return $t.data(opts);\n                        }\n                        o[opts] = val;\n                    }\n                    else { o = opts; }\n                    return tp_inst.control.create(tp_inst, obj, $t.data('unit'), $t.val(), o.min>=0 ? o.min : $t.data('min'), o.max || $t.data('max'), o.step || $t.data('step'));\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    var $t = obj.children('select');\n                    if (val !== undefined) {\n                        return $t.val(val);\n                    }\n                    return $t.val();\n                }\n            }\n        } // end _controls\n\n    });\n\n    $.fn.extend({\n        /*\n        * shorthand just to use timepicker.\n        */\n        timepicker: function (o) {\n            o = o || {};\n            var tmp_args = Array.prototype.slice.call(arguments);\n\n            if (typeof o === 'object') {\n                tmp_args[0] = $.extend(o, {\n                    timeOnly: true\n                });\n            }\n\n            return $(this).each(function () {\n                $.fn.datetimepicker.apply($(this), tmp_args);\n            });\n        },\n\n        /*\n        * extend timepicker to datepicker\n        */\n        datetimepicker: function (o) {\n            o = o || {};\n            var tmp_args = arguments;\n\n            if (typeof(o) === 'string') {\n                if (o === 'getDate'  || (o === 'option' && tmp_args.length === 2 && typeof (tmp_args[1]) === 'string')) {\n                    return $.fn.datepicker.apply($(this[0]), tmp_args);\n                } else {\n                    return this.each(function () {\n                        var $t = $(this);\n                        $t.datepicker.apply($t, tmp_args);\n                    });\n                }\n            } else {\n                return this.each(function () {\n                    var $t = $(this);\n                    $t.datepicker($.timepicker._newInst($t, o)._defaults);\n                });\n            }\n        }\n    });\n\n    /*\n    * Public Utility to parse date and time\n    */\n    $.datepicker.parseDateTime = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var parseRes = parseDateTimeInternal(dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings);\n        if (parseRes.timeObj) {\n            var t = parseRes.timeObj;\n            parseRes.date.setHours(t.hour, t.minute, t.second, t.millisec);\n            parseRes.date.setMicroseconds(t.microsec);\n        }\n\n        return parseRes.date;\n    };\n\n    /*\n    * Public utility to parse time\n    */\n    $.datepicker.parseTime = function (timeFormat, timeString, options) {\n        var o = extendRemove(extendRemove({}, $.timepicker._defaults), options || {}),\n            iso8601 = (timeFormat.replace(/\\'.*?\\'/g, '').indexOf('Z') !== -1);\n\n        // Strict parse requires the timeString to match the timeFormat exactly\n        var strictParse = function (f, s, o) {\n\n            // pattern for standard and localized AM/PM markers\n            var getPatternAmpm = function (amNames, pmNames) {\n                var markers = [];\n                if (amNames) {\n                    $.merge(markers, amNames);\n                }\n                if (pmNames) {\n                    $.merge(markers, pmNames);\n                }\n                markers = $.map(markers, function (val) {\n                    return val.replace(/[.*+?|()\\[\\]{}\\\\]/g, '\\\\$&');\n                });\n                return '(' + markers.join('|') + ')?';\n            };\n\n            // figure out position of time elements.. cause js cant do named captures\n            var getFormatPositions = function (timeFormat) {\n                var finds = timeFormat.toLowerCase().match(/(h{1,2}|m{1,2}|s{1,2}|l{1}|c{1}|t{1,2}|z|'.*?')/g),\n                    orders = {\n                        h: -1,\n                        m: -1,\n                        s: -1,\n                        l: -1,\n                        c: -1,\n                        t: -1,\n                        z: -1\n                    };\n\n                if (finds) {\n                    for (var i = 0; i < finds.length; i++) {\n                        if (orders[finds[i].toString().charAt(0)] === -1) {\n                            orders[finds[i].toString().charAt(0)] = i + 1;\n                        }\n                    }\n                }\n                return orders;\n            };\n\n            var regstr = '^' + f.toString()\n                    .replace(/([hH]{1,2}|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n                        var ml = match.length;\n                        switch (match.charAt(0).toLowerCase()) {\n                            case 'h':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'm':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 's':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'l':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'c':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'z':\n                                return '(z|[-+]\\\\d\\\\d:?\\\\d\\\\d|\\\\S+)?';\n                            case 't':\n                                return getPatternAmpm(o.amNames, o.pmNames);\n                            default:    // literal escaped in quotes\n                                return '(' + match.replace(/\\'/g, \"\").replace(/(\\.|\\$|\\^|\\\\|\\/|\\(|\\)|\\[|\\]|\\?|\\+|\\*)/g, function (m) { return \"\\\\\" + m; }) + ')?';\n                        }\n                    })\n                    .replace(/\\s/g, '\\\\s?') +\n                o.timeSuffix + '$',\n                order = getFormatPositions(f),\n                ampm = '',\n                treg;\n\n            treg = s.match(new RegExp(regstr, 'i'));\n\n            var resTime = {\n                hour: 0,\n                minute: 0,\n                second: 0,\n                millisec: 0,\n                microsec: 0\n            };\n\n            if (treg) {\n                if (order.t !== -1) {\n                    if (treg[order.t] === undefined || treg[order.t].length === 0) {\n                        ampm = '';\n                        resTime.ampm = '';\n                    } else {\n                        ampm = $.inArray(treg[order.t].toUpperCase(), $.map(o.amNames, function (x,i) { return x.toUpperCase(); })) !== -1 ? 'AM' : 'PM';\n                        resTime.ampm = o[ampm === 'AM' ? 'amNames' : 'pmNames'][0];\n                    }\n                }\n\n                if (order.h !== -1) {\n                    if (ampm === 'AM' && treg[order.h] === '12') {\n                        resTime.hour = 0; // 12am = 0 hour\n                    } else {\n                        if (ampm === 'PM' && treg[order.h] !== '12') {\n                            resTime.hour = parseInt(treg[order.h], 10) + 12; // 12pm = 12 hour, any other pm = hour + 12\n                        } else {\n                            resTime.hour = Number(treg[order.h]);\n                        }\n                    }\n                }\n\n                if (order.m !== -1) {\n                    resTime.minute = Number(treg[order.m]);\n                }\n                if (order.s !== -1) {\n                    resTime.second = Number(treg[order.s]);\n                }\n                if (order.l !== -1) {\n                    resTime.millisec = Number(treg[order.l]);\n                }\n                if (order.c !== -1) {\n                    resTime.microsec = Number(treg[order.c]);\n                }\n                if (order.z !== -1 && treg[order.z] !== undefined) {\n                    resTime.timezone = $.timepicker.timezoneOffsetNumber(treg[order.z]);\n                }\n\n\n                return resTime;\n            }\n            return false;\n        };// end strictParse\n\n        // First try JS Date, if that fails, use strictParse\n        var looseParse = function (f, s, o) {\n            try {\n                var d = new Date('2012-01-01 ' + s);\n                if (isNaN(d.getTime())) {\n                    d = new Date('2012-01-01T' + s);\n                    if (isNaN(d.getTime())) {\n                        d = new Date('01/01/2012 ' + s);\n                        if (isNaN(d.getTime())) {\n                            throw \"Unable to parse time with native Date: \" + s;\n                        }\n                    }\n                }\n\n                return {\n                    hour: d.getHours(),\n                    minute: d.getMinutes(),\n                    second: d.getSeconds(),\n                    millisec: d.getMilliseconds(),\n                    microsec: d.getMicroseconds(),\n                    timezone: d.getTimezoneOffset() * -1\n                };\n            }\n            catch (err) {\n                try {\n                    return strictParse(f, s, o);\n                }\n                catch (err2) {\n                    $.timepicker.log(\"Unable to parse \\ntimeString: \" + s + \"\\ntimeFormat: \" + f);\n                }\n            }\n            return false;\n        }; // end looseParse\n\n        if (typeof o.parse === \"function\") {\n            return o.parse(timeFormat, timeString, o);\n        }\n        if (o.parse === 'loose') {\n            return looseParse(timeFormat, timeString, o);\n        }\n        return strictParse(timeFormat, timeString, o);\n    };\n\n    /**\n     * Public utility to format the time\n     * @param {string} format format of the time\n     * @param {Object} time Object not a Date for timezones\n     * @param {Object} [options] essentially the regional[].. amNames, pmNames, ampm\n     * @returns {string} the formatted time\n     */\n    $.datepicker.formatTime = function (format, time, options) {\n        options = options || {};\n        options = $.extend({}, $.timepicker._defaults, options);\n        time = $.extend({\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null\n        }, time);\n\n        var tmptime = format,\n            ampmName = options.amNames[0],\n            hour = parseInt(time.hour, 10);\n\n        if (hour > 11) {\n            ampmName = options.pmNames[0];\n        }\n\n        tmptime = tmptime.replace(/(?:HH?|hh?|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n            switch (match) {\n                case 'HH':\n                    return ('0' + hour).slice(-2);\n                case 'H':\n                    return hour;\n                case 'hh':\n                    return ('0' + convert24to12(hour)).slice(-2);\n                case 'h':\n                    return convert24to12(hour);\n                case 'mm':\n                    return ('0' + time.minute).slice(-2);\n                case 'm':\n                    return time.minute;\n                case 'ss':\n                    return ('0' + time.second).slice(-2);\n                case 's':\n                    return time.second;\n                case 'l':\n                    return ('00' + time.millisec).slice(-3);\n                case 'c':\n                    return ('00' + time.microsec).slice(-3);\n                case 'z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, false);\n                case 'Z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, true);\n                case 'T':\n                    return ampmName.charAt(0).toUpperCase();\n                case 'TT':\n                    return ampmName.toUpperCase();\n                case 't':\n                    return ampmName.charAt(0).toLowerCase();\n                case 'tt':\n                    return ampmName.toLowerCase();\n                default:\n                    return match.replace(/'/g, \"\");\n            }\n        });\n\n        return tmptime;\n    };\n\n    /*\n    * the bad hack :/ override datepicker so it doesn't close on select\n    // inspired: http://stackoverflow.com/questions/1252512/jquery-datepicker-prevent-closing-picker-when-clicking-a-date/1762378#1762378\n    */\n    $.datepicker._base_selectDate = $.datepicker._selectDate;\n    $.datepicker._selectDate = function (id, dateStr) {\n        var inst = this._getInst($(id)[0]),\n            tp_inst = this._get(inst, 'timepicker'),\n            was_inline;\n\n        if (tp_inst && inst.settings.showTimepicker) {\n            tp_inst._limitMinMaxDateTime(inst, true);\n            was_inline = inst.inline;\n            inst.inline = inst.stay_open = true;\n            //This way the onSelect handler called from calendarpicker get the full dateTime\n            this._base_selectDate(id, dateStr);\n            inst.inline = was_inline;\n            inst.stay_open = false;\n            this._notifyChange(inst);\n            this._updateDatepicker(inst);\n        } else {\n            this._base_selectDate(id, dateStr);\n        }\n    };\n\n    /*\n    * second bad hack :/ override datepicker so it triggers an event when changing the input field\n    * and does not redraw the datepicker on every selectDate event\n    */\n    $.datepicker._base_updateDatepicker = $.datepicker._updateDatepicker;\n    $.datepicker._updateDatepicker = function (inst) {\n\n        // don't popup the datepicker if there is another instance already opened\n        var input = inst.input[0];\n        if ($.datepicker._curInst && $.datepicker._curInst !== inst && $.datepicker._datepickerShowing && $.datepicker._lastInput !== input) {\n            return;\n        }\n\n        if (typeof(inst.stay_open) !== 'boolean' || inst.stay_open === false) {\n\n            this._base_updateDatepicker(inst);\n\n            // Reload the time control when changing something in the input text field.\n            var tp_inst = this._get(inst, 'timepicker');\n            if (tp_inst) {\n                tp_inst._addTimePicker(inst);\n            }\n        }\n    };\n\n    /*\n    * third bad hack :/ override datepicker so it allows spaces and colon in the input field\n    */\n    $.datepicker._base_doKeyPress = $.datepicker._doKeyPress;\n    $.datepicker._doKeyPress = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if ($.datepicker._get(inst, 'constrainInput')) {\n                var ampm = tp_inst.support.ampm,\n                    tz = tp_inst._defaults.showTimezone !== null ? tp_inst._defaults.showTimezone : tp_inst.support.timezone,\n                    dateChars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat')),\n                    datetimeChars = tp_inst._defaults.timeFormat.toString()\n                            .replace(/[hms]/g, '')\n                            .replace(/TT/g, ampm ? 'APM' : '')\n                            .replace(/Tt/g, ampm ? 'AaPpMm' : '')\n                            .replace(/tT/g, ampm ? 'AaPpMm' : '')\n                            .replace(/T/g, ampm ? 'AP' : '')\n                            .replace(/tt/g, ampm ? 'apm' : '')\n                            .replace(/t/g, ampm ? 'ap' : '') +\n                        \" \" + tp_inst._defaults.separator +\n                        tp_inst._defaults.timeSuffix +\n                        (tz ? tp_inst._defaults.timezoneList.join('') : '') +\n                        (tp_inst._defaults.amNames.join('')) + (tp_inst._defaults.pmNames.join('')) +\n                        dateChars,\n                    chr = String.fromCharCode(event.charCode === undefined ? event.keyCode : event.charCode);\n                return event.ctrlKey || (chr < ' ' || !dateChars || datetimeChars.indexOf(chr) > -1);\n            }\n        }\n\n        return $.datepicker._base_doKeyPress(event);\n    };\n\n    /*\n    * Fourth bad hack :/ override _updateAlternate function used in inline mode to init altField\n    * Update any alternate field to synchronise with the main field.\n    */\n    $.datepicker._base_updateAlternate = $.datepicker._updateAlternate;\n    $.datepicker._updateAlternate = function (inst) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var altField = tp_inst._defaults.altField;\n            if (altField) { // update alternate field too\n                var altFormat = tp_inst._defaults.altFormat || tp_inst._defaults.dateFormat,\n                    date = this._getDate(inst),\n                    formatCfg = $.datepicker._getFormatConfig(inst),\n                    altFormattedDateTime = '',\n                    altSeparator = tp_inst._defaults.altSeparator ? tp_inst._defaults.altSeparator : tp_inst._defaults.separator,\n                    altTimeSuffix = tp_inst._defaults.altTimeSuffix ? tp_inst._defaults.altTimeSuffix : tp_inst._defaults.timeSuffix,\n                    altTimeFormat = tp_inst._defaults.altTimeFormat !== null ? tp_inst._defaults.altTimeFormat : tp_inst._defaults.timeFormat;\n\n                altFormattedDateTime += $.datepicker.formatTime(altTimeFormat, tp_inst, tp_inst._defaults) + altTimeSuffix;\n                if (!tp_inst._defaults.timeOnly && !tp_inst._defaults.altFieldTimeOnly && date !== null) {\n                    if (tp_inst._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(tp_inst._defaults.altFormat, date, formatCfg) + altSeparator + altFormattedDateTime;\n                    }\n                    else {\n                        altFormattedDateTime = tp_inst.formattedDate + altSeparator + altFormattedDateTime;\n                    }\n                }\n                $(altField).val( inst.input.val() ? altFormattedDateTime : \"\");\n            }\n        }\n        else {\n            $.datepicker._base_updateAlternate(inst);\n        }\n    };\n\n    /*\n    * Override key up event to sync manual input changes.\n    */\n    $.datepicker._base_doKeyUp = $.datepicker._doKeyUp;\n    $.datepicker._doKeyUp = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                try {\n                    $.datepicker._updateDatepicker(inst);\n                } catch (err) {\n                    $.timepicker.log(err);\n                }\n            }\n        }\n\n        return $.datepicker._base_doKeyUp(event);\n    };\n\n    /*\n    * override \"Today\" button to also grab the time and set it to input field.\n    */\n    $.datepicker._base_gotoToday = $.datepicker._gotoToday;\n    $.datepicker._gotoToday = function (id) {\n        var inst = this._getInst($(id)[0]);\n        this._base_gotoToday(id);\n        var tp_inst = this._get(inst, 'timepicker');\n        if (!tp_inst) {\n            return;\n        }\n\n        var tzoffset = $.timepicker.timezoneOffsetNumber(tp_inst.timezone);\n        var now = new Date();\n        now.setMinutes(now.getMinutes() + now.getTimezoneOffset() + parseInt(tzoffset, 10));\n        this._setTime(inst, now);\n        this._setDate(inst, now);\n        tp_inst._onSelectHandler();\n    };\n\n    /*\n    * Disable & enable the Time in the datetimepicker\n    */\n    $.datepicker._disableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = false;\n            tp_inst._defaults.showTimepicker = false;\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    $.datepicker._enableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = true;\n            tp_inst._defaults.showTimepicker = true;\n            tp_inst._addTimePicker(inst); // Could be disabled on page load\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create our own set time function\n    */\n    $.datepicker._setTime = function (inst, date) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var defaults = tp_inst._defaults;\n\n            // calling _setTime with no date sets time to defaults\n            tp_inst.hour = date ? date.getHours() : defaults.hour;\n            tp_inst.minute = date ? date.getMinutes() : defaults.minute;\n            tp_inst.second = date ? date.getSeconds() : defaults.second;\n            tp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;\n            tp_inst.microsec = date ? date.getMicroseconds() : defaults.microsec;\n\n            //check if within min/max times..\n            tp_inst._limitMinMaxDateTime(inst, true);\n\n            tp_inst._onTimeChange();\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create new public method to set only time, callable as $().datepicker('setTime', date)\n    */\n    $.datepicker._setTimeDatepicker = function (target, date, withDate) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            this._setDateFromField(inst);\n            var tp_date;\n            if (date) {\n                if (typeof date === \"string\") {\n                    tp_inst._parseTime(date, withDate);\n                    tp_date = new Date();\n                    tp_date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                    tp_date.setMicroseconds(tp_inst.microsec);\n                } else {\n                    tp_date = new Date(date.getTime());\n                    tp_date.setMicroseconds(date.getMicroseconds());\n                }\n                if (tp_date.toString() === 'Invalid Date') {\n                    tp_date = undefined;\n                }\n                this._setTime(inst, tp_date);\n            }\n        }\n\n    };\n\n    /*\n    * override setDate() to allow setting time too within Date object\n    */\n    $.datepicker._base_setDateDatepicker = $.datepicker._setDateDatepicker;\n    $.datepicker._setDateDatepicker = function (target, _date) {\n        var inst = this._getInst(target);\n        var date = _date;\n        if (!inst) {\n            return;\n        }\n\n        if (typeof(_date) === 'string') {\n            date = new Date(_date);\n            if (!date.getTime()) {\n                this._base_setDateDatepicker.apply(this, arguments);\n                date = $(target).datepicker('getDate');\n            }\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        var tp_date;\n        if (date instanceof Date) {\n            tp_date = new Date(date.getTime());\n            tp_date.setMicroseconds(date.getMicroseconds());\n        } else {\n            tp_date = date;\n        }\n\n        // This is important if you are using the timezone option, javascript's Date\n        // object will only return the timezone offset for the current locale, so we\n        // adjust it accordingly.  If not using timezone option this won't matter..\n        // If a timezone is different in tp, keep the timezone as is\n        if (tp_inst && tp_date) {\n            // look out for DST if tz wasn't specified\n            if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                tp_inst.timezone = tp_date.getTimezoneOffset() * -1;\n            }\n            date = $.timepicker.timezoneAdjust(date, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()), tp_inst.timezone);\n            tp_date = $.timepicker.timezoneAdjust(tp_date, $.timepicker.timezoneOffsetString(-tp_date.getTimezoneOffset()), tp_inst.timezone);\n        }\n\n        this._updateDatepicker(inst);\n        this._base_setDateDatepicker.apply(this, arguments);\n        this._setTimeDatepicker(target, tp_date, true);\n    };\n\n    /*\n    * override getDate() to allow getting time too within Date object\n    */\n    $.datepicker._base_getDateDatepicker = $.datepicker._getDateDatepicker;\n    $.datepicker._getDateDatepicker = function (target, noDefault) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            // if it hasn't yet been defined, grab from field\n            if (inst.lastVal === undefined) {\n                this._setDateFromField(inst, noDefault);\n            }\n\n            var date = this._getDate(inst);\n\n            var currDT = null;\n\n            if (tp_inst.$altInput && tp_inst._defaults.altFieldTimeOnly) {\n                currDT = tp_inst.$input.val() + ' ' + tp_inst.$altInput.val();\n            }\n            else if (tp_inst.$input.get(0).tagName !== 'INPUT' && tp_inst.$altInput) {\n                /**\n                 * in case the datetimepicker has been applied to a non-input tag for inline UI,\n                 * and the user has not configured the plugin to display only time in altInput,\n                 * pick current date time from the altInput (and hope for the best, for now, until \"ER1\" is applied)\n                 *\n                 * @todo ER1. Since altInput can have a totally difference format, convert it to standard format by reading input format from \"altFormat\" and \"altTimeFormat\" option values\n                 */\n                currDT = tp_inst.$altInput.val();\n            }\n            else {\n                currDT = tp_inst.$input.val();\n            }\n\n            if (date && tp_inst._parseTime(currDT, !inst.settings.timeOnly)) {\n                date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                date.setMicroseconds(tp_inst.microsec);\n\n                // This is important if you are using the timezone option, javascript's Date\n                // object will only return the timezone offset for the current locale, so we\n                // adjust it accordingly.  If not using timezone option this won't matter..\n                if (tp_inst.timezone != null) {\n                    // look out for DST if tz wasn't specified\n                    if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                        tp_inst.timezone = date.getTimezoneOffset() * -1;\n                    }\n                    date = $.timepicker.timezoneAdjust(date, tp_inst.timezone, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()));\n                }\n            }\n            return date;\n        }\n        return this._base_getDateDatepicker(target, noDefault);\n    };\n\n    /*\n    * override parseDate() because UI 1.8.14 throws an error about \"Extra characters\"\n    * An option in datapicker to ignore extra format characters would be nicer.\n    */\n    $.datepicker._base_parseDate = $.datepicker.parseDate;\n    $.datepicker.parseDate = function (format, value, settings) {\n        var date;\n        try {\n            date = this._base_parseDate(format, value, settings);\n        } catch (err) {\n            // Hack!  The error message ends with a colon, a space, and\n            // the \"extra\" characters.  We rely on that instead of\n            // attempting to perfectly reproduce the parsing algorithm.\n            if (err.indexOf(\":\") >= 0) {\n                date = this._base_parseDate(format, value.substring(0, value.length - (err.length - err.indexOf(':') - 2)), settings);\n                $.timepicker.log(\"Error parsing the date string: \" + err + \"\\ndate string = \" + value + \"\\ndate format = \" + format);\n            } else {\n                throw err;\n            }\n        }\n        return date;\n    };\n\n    /*\n    * override formatDate to set date with time to the input\n    */\n    $.datepicker._base_formatDate = $.datepicker._formatDate;\n    $.datepicker._formatDate = function (inst, day, month, year) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            tp_inst._updateDateTime(inst);\n            return tp_inst.$input.val();\n        }\n        return this._base_formatDate(inst);\n    };\n\n    /*\n    * override options setter to add time to maxDate(Time) and minDate(Time). MaxDate\n    */\n    $.datepicker._base_optionDatepicker = $.datepicker._optionDatepicker;\n    $.datepicker._optionDatepicker = function (target, name, value) {\n        var inst = this._getInst(target),\n            name_clone;\n        if (!inst) {\n            return null;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var min = null,\n                max = null,\n                onselect = null,\n                overrides = tp_inst._defaults.evnts,\n                fns = {},\n                prop,\n                ret,\n                oldVal,\n                $target;\n            if (typeof name === 'string') { // if min/max was set with the string\n                if (name === 'minDate' || name === 'minDateTime') {\n                    min = value;\n                } else if (name === 'maxDate' || name === 'maxDateTime') {\n                    max = value;\n                } else if (name === 'onSelect') {\n                    onselect = value;\n                } else if (overrides.hasOwnProperty(name)) {\n                    if (typeof (value) === 'undefined') {\n                        return overrides[name];\n                    }\n                    fns[name] = value;\n                    name_clone = {}; //empty results in exiting function after overrides updated\n                }\n            } else if (typeof name === 'object') { //if min/max was set with the JSON\n                if (name.minDate) {\n                    min = name.minDate;\n                } else if (name.minDateTime) {\n                    min = name.minDateTime;\n                } else if (name.maxDate) {\n                    max = name.maxDate;\n                } else if (name.maxDateTime) {\n                    max = name.maxDateTime;\n                }\n                for (prop in overrides) {\n                    if (overrides.hasOwnProperty(prop) && name[prop]) {\n                        fns[prop] = name[prop];\n                    }\n                }\n            }\n            for (prop in fns) {\n                if (fns.hasOwnProperty(prop)) {\n                    overrides[prop] = fns[prop];\n                    if (!name_clone) { name_clone = $.extend({}, name); }\n                    delete name_clone[prop];\n                }\n            }\n            if (name_clone && isEmptyObject(name_clone)) { return; }\n            if (min) { //if min was set\n                if (min === 0) {\n                    min = new Date();\n                } else {\n                    min = new Date(min);\n                }\n                tp_inst._defaults.minDate = min;\n                tp_inst._defaults.minDateTime = min;\n            } else if (max) { //if max was set\n                if (max === 0) {\n                    max = new Date();\n                } else {\n                    max = new Date(max);\n                }\n                tp_inst._defaults.maxDate = max;\n                tp_inst._defaults.maxDateTime = max;\n            } else if (onselect) {\n                tp_inst._defaults.onSelect = onselect;\n            }\n\n            // Datepicker will override our date when we call _base_optionDatepicker when\n            // calling minDate/maxDate, so we will first grab the value, call\n            // _base_optionDatepicker, then set our value back.\n            if(min || max){\n                $target = $(target);\n                oldVal = $target.datetimepicker('getDate');\n                ret = this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n                $target.datetimepicker('setDate', oldVal);\n                return ret;\n            }\n        }\n        if (value === undefined) {\n            return this._base_optionDatepicker.call($.datepicker, target, name);\n        }\n        return this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n    };\n\n    /*\n    * jQuery isEmptyObject does not check hasOwnProperty - if someone has added to the object prototype,\n    * it will return false for all objects\n    */\n    var isEmptyObject = function (obj) {\n        var prop;\n        for (prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                return false;\n            }\n        }\n        return true;\n    };\n\n    /*\n    * jQuery extend now ignores nulls!\n    */\n    var extendRemove = function (target, props) {\n        $.extend(target, props);\n        for (var name in props) {\n            if (props[name] === null || props[name] === undefined) {\n                target[name] = props[name];\n            }\n        }\n        return target;\n    };\n\n    /*\n    * Determine by the time format which units are supported\n    * Returns an object of booleans for each unit\n    */\n    var detectSupport = function (timeFormat) {\n        var tf = timeFormat.replace(/'.*?'/g, '').toLowerCase(), // removes literals\n            isIn = function (f, t) { // does the format contain the token?\n                return f.indexOf(t) !== -1 ? true : false;\n            };\n        return {\n            hour: isIn(tf, 'h'),\n            minute: isIn(tf, 'm'),\n            second: isIn(tf, 's'),\n            millisec: isIn(tf, 'l'),\n            microsec: isIn(tf, 'c'),\n            timezone: isIn(tf, 'z'),\n            ampm: isIn(tf, 't') && isIn(timeFormat, 'h'),\n            iso8601: isIn(timeFormat, 'Z')\n        };\n    };\n\n    /*\n    * Converts 24 hour format into 12 hour\n    * Returns 12 hour without leading 0\n    */\n    var convert24to12 = function (hour) {\n        hour %= 12;\n\n        if (hour === 0) {\n            hour = 12;\n        }\n\n        return String(hour);\n    };\n\n    var computeEffectiveSetting = function (settings, property) {\n        return settings && settings[property] ? settings[property] : $.timepicker._defaults[property];\n    };\n\n    /*\n    * Splits datetime string into date and time substrings.\n    * Throws exception when date can't be parsed\n    * Returns {dateString: dateString, timeString: timeString}\n    */\n    var splitDateTime = function (dateTimeString, timeSettings) {\n        // The idea is to get the number separator occurrences in datetime and the time format requested (since time has\n        // fewer unknowns, mostly numbers and am/pm). We will use the time pattern to split.\n        var separator = computeEffectiveSetting(timeSettings, 'separator'),\n            format = computeEffectiveSetting(timeSettings, 'timeFormat'),\n            timeParts = format.split(separator), // how many occurrences of separator may be in our format?\n            timePartsLen = timeParts.length,\n            allParts = dateTimeString.split(separator),\n            allPartsLen = allParts.length;\n\n        if (allPartsLen > 1) {\n            return {\n                dateString: allParts.splice(0, allPartsLen - timePartsLen).join(separator),\n                timeString: allParts.splice(0, timePartsLen).join(separator)\n            };\n        }\n\n        return {\n            dateString: dateTimeString,\n            timeString: ''\n        };\n    };\n\n    /*\n    * Internal function to parse datetime interval\n    * Returns: {date: Date, timeObj: Object}, where\n    *   date - parsed date without time (type Date)\n    *   timeObj = {hour: , minute: , second: , millisec: , microsec: } - parsed time. Optional\n    */\n    var parseDateTimeInternal = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var date,\n            parts,\n            parsedTime;\n\n        parts = splitDateTime(dateTimeString, timeSettings);\n        date = $.datepicker._base_parseDate(dateFormat, parts.dateString, dateSettings);\n\n        if (parts.timeString === '') {\n            return {\n                date: date\n            };\n        }\n\n        parsedTime = $.datepicker.parseTime(timeFormat, parts.timeString, timeSettings);\n\n        if (!parsedTime) {\n            throw 'Wrong time format';\n        }\n\n        return {\n            date: date,\n            timeObj: parsedTime\n        };\n    };\n\n    /*\n    * Internal function to set timezone_select to the local timezone\n    */\n    var selectLocalTimezone = function (tp_inst, date) {\n        if (tp_inst && tp_inst.timezone_select) {\n            var now = date || new Date();\n            tp_inst.timezone_select.val(-now.getTimezoneOffset());\n        }\n    };\n\n    /*\n    * Create a Singleton Instance\n    */\n    $.timepicker = new Timepicker();\n\n    /**\n     * Get the timezone offset as string from a date object (eg '+0530' for UTC+5.5)\n     * @param {number} tzMinutes if not a number, less than -720 (-1200), or greater than 840 (+1400) this value is returned\n     * @param {boolean} iso8601 if true formats in accordance to iso8601 \"+12:45\"\n     * @return {string}\n     */\n    $.timepicker.timezoneOffsetString = function (tzMinutes, iso8601) {\n        if (isNaN(tzMinutes) || tzMinutes > 840 || tzMinutes < -720) {\n            return tzMinutes;\n        }\n\n        var off = tzMinutes,\n            minutes = off % 60,\n            hours = (off - minutes) / 60,\n            iso = iso8601 ? ':' : '',\n            tz = (off >= 0 ? '+' : '-') + ('0' + Math.abs(hours)).slice(-2) + iso + ('0' + Math.abs(minutes)).slice(-2);\n\n        if (tz === '+00:00') {\n            return 'Z';\n        }\n        return tz;\n    };\n\n    /**\n     * Get the number in minutes that represents a timezone string\n     * @param  {string} tzString formatted like \"+0500\", \"-1245\", \"Z\"\n     * @return {number} the offset minutes or the original string if it doesn't match expectations\n     */\n    $.timepicker.timezoneOffsetNumber = function (tzString) {\n        var normalized = tzString.toString().replace(':', ''); // excuse any iso8601, end up with \"+1245\"\n\n        if (normalized.toUpperCase() === 'Z') { // if iso8601 with Z, its 0 minute offset\n            return 0;\n        }\n\n        if (!/^(\\-|\\+)\\d{4}$/.test(normalized)) { // possibly a user defined tz, so just give it back\n            return parseInt(tzString, 10);\n        }\n\n        return ((normalized.substr(0, 1) === '-' ? -1 : 1) * // plus or minus\n            ((parseInt(normalized.substr(1, 2), 10) * 60) + // hours (converted to minutes)\n                parseInt(normalized.substr(3, 2), 10))); // minutes\n    };\n\n    /**\n     * No way to set timezone in js Date, so we must adjust the minutes to compensate. (think setDate, getDate)\n     * @param  {Date} date\n     * @param  {string} fromTimezone formatted like \"+0500\", \"-1245\"\n     * @param  {string} toTimezone formatted like \"+0500\", \"-1245\"\n     * @return {Date}\n     */\n    $.timepicker.timezoneAdjust = function (date, fromTimezone, toTimezone) {\n        var fromTz = $.timepicker.timezoneOffsetNumber(fromTimezone);\n        var toTz = $.timepicker.timezoneOffsetNumber(toTimezone);\n        if (!isNaN(toTz)) {\n            date.setMinutes(date.getMinutes() + (-fromTz) - (-toTz));\n        }\n        return date;\n    };\n\n    /**\n     * Calls `timepicker()` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * n.b. The input value must be correctly formatted (reformatting is not supported)\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the timepicker() call\n     * @return {jQuery}\n     */\n    $.timepicker.timeRange = function (startTime, endTime, options) {\n        return $.timepicker.handleRange('timepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datetimepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @return {jQuery}\n     */\n    $.timepicker.datetimeRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datetimepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.dateRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `method` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.handleRange = function (method, startTime, endTime, options) {\n        options = $.extend({}, {\n            minInterval: 0, // min allowed interval in milliseconds\n            maxInterval: 0, // max allowed interval in milliseconds\n            start: {},      // options for start picker\n            end: {}         // options for end picker\n        }, options);\n\n        // for the mean time this fixes an issue with calling getDate with timepicker()\n        var timeOnly = false;\n        if(method === 'timepicker'){\n            timeOnly = true;\n            method = 'datetimepicker';\n        }\n\n        function checkDates(changed, other) {\n            var startdt = startTime[method]('getDate'),\n                enddt = endTime[method]('getDate'),\n                changeddt = changed[method]('getDate');\n\n            if (startdt !== null) {\n                var minDate = new Date(startdt.getTime()),\n                    maxDate = new Date(startdt.getTime());\n\n                minDate.setMilliseconds(minDate.getMilliseconds() + options.minInterval);\n                maxDate.setMilliseconds(maxDate.getMilliseconds() + options.maxInterval);\n\n                if (options.minInterval > 0 && minDate > enddt) { // minInterval check\n                    endTime[method]('setDate', minDate);\n                }\n                else if (options.maxInterval > 0 && maxDate < enddt) { // max interval check\n                    endTime[method]('setDate', maxDate);\n                }\n                else if (startdt > enddt) {\n                    other[method]('setDate', changeddt);\n                }\n            }\n        }\n\n        function selected(changed, other, option) {\n            if (!changed.val()) {\n                return;\n            }\n            var date = changed[method].call(changed, 'getDate');\n            if (date !== null && options.minInterval > 0) {\n                if (option === 'minDate') {\n                    date.setMilliseconds(date.getMilliseconds() + options.minInterval);\n                }\n                if (option === 'maxDate') {\n                    date.setMilliseconds(date.getMilliseconds() - options.minInterval);\n                }\n            }\n\n            if (date.getTime) {\n                other[method].call(other, 'option', option, date);\n            }\n        }\n\n        $.fn[method].call(startTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), endTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), endTime, 'minDate');\n            }\n        }, options, options.start));\n        $.fn[method].call(endTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), startTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), startTime, 'maxDate');\n            }\n        }, options, options.end));\n\n        checkDates(startTime, endTime);\n\n        selected(startTime, endTime, 'minDate');\n        selected(endTime, startTime, 'maxDate');\n\n        return $([startTime.get(0), endTime.get(0)]);\n    };\n\n    /**\n     * Log error or data to the console during error or debugging\n     * @param  {Object} err pass any type object to log to the console during error or debugging\n     * @return {void}\n     */\n    $.timepicker.log = function () {\n        // Older IE (9, maybe 10) throw error on accessing `window.console.log.apply`, so check first.\n        if (window.console && window.console.log && window.console.log.apply) {\n            window.console.log.apply(window.console, Array.prototype.slice.call(arguments));\n        }\n    };\n\n    /*\n     * Add util object to allow access to private methods for testability.\n     */\n    $.timepicker._util = {\n        _extendRemove: extendRemove,\n        _isEmptyObject: isEmptyObject,\n        _convert24to12: convert24to12,\n        _detectSupport: detectSupport,\n        _selectLocalTimezone: selectLocalTimezone,\n        _computeEffectiveSetting: computeEffectiveSetting,\n        _splitDateTime: splitDateTime,\n        _parseDateTimeInternal: parseDateTimeInternal\n    };\n\n    /*\n    * Microsecond support\n    */\n    if (!Date.prototype.getMicroseconds) {\n        Date.prototype.microseconds = 0;\n        Date.prototype.getMicroseconds = function () { return this.microseconds; };\n        Date.prototype.setMicroseconds = function (m) {\n            this.setMilliseconds(this.getMilliseconds() + Math.floor(m / 1000));\n            this.microseconds = m % 1000;\n            return this;\n        };\n    }\n\n    /*\n    * Keep up with the version\n    */\n    $.timepicker.version = \"1.6.3\";\n\n}));\n","jquery/z-index.js":"/*!\n * zIndex plugin from jQuery UI Core - v1.10.4\n * http://jqueryui.com\n *\n * Copyright 2014 jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/category/ui-core/\n */\ndefine([\n    'jquery'\n], function ($, undefined) {\n\n// plugins\n    $.fn.extend({\n        zIndex: function (zIndex) {\n            if (zIndex !== undefined) {\n                return this.css(\"zIndex\", zIndex);\n            }\n\n            if (this.length) {\n                var elem = $(this[0]), position, value;\n                while (elem.length && elem[0] !== document) {\n                    // Ignore z-index if position is set to a value where z-index is ignored by the browser\n                    // This makes behavior of this function consistent across browsers\n                    // WebKit always returns auto if the element is positioned\n                    position = elem.css(\"position\");\n                    if (position === \"absolute\" || position === \"relative\" || position === \"fixed\") {\n                        // IE returns 0 when zIndex is not specified\n                        // other browsers return a string\n                        // we ignore the case of nested elements with an explicit value of 0\n                        // <div style=\"z-index: -10;\"><div style=\"z-index: 0;\"></div></div>\n                        value = parseInt(elem.css(\"zIndex\"), 10);\n                        if (!isNaN(value) && value !== 0) {\n                            return value;\n                        }\n                    }\n                    elem = elem.parent();\n                }\n            }\n\n            return 0;\n        }\n    });\n});\n","jquery/jquery.metadata.js":"/*\n * Metadata - jQuery plugin for parsing metadata from elements\n *\n * Copyright (c) 2006 John Resig, Yehuda Katz, J\u00ef\u00bf\u00bd\u00c3\u00b6rn Zaefferer, Paul McLanahan\n *\n * Dual licensed under the MIT and GPL licenses:\n *   http://www.opensource.org/licenses/mit-license.php\n *   http://www.gnu.org/licenses/gpl.html\n *\n * Revision: $Id: jquery.metadata.js 3640 2007-10-11 18:34:38Z pmclanahan $\n *\n */\n\n/**\n * Sets the type of metadata to use. Metadata is encoded in JSON, and each property\n * in the JSON will become a property of the element itself.\n *\n * There are four supported types of metadata storage:\n *\n *   attr:  Inside an attribute. The name parameter indicates *which* attribute.\n *\n *   class: Inside the class attribute, wrapped in curly braces: { }\n *\n *   elem:  Inside a child element (e.g. a script tag). The\n *          name parameter indicates *which* element.\n *   html5: Values are stored in data-* attributes.\n *\n * The metadata for an element is loaded the first time the element is accessed via jQuery.\n *\n * As a result, you can define the metadata type, use $(expr) to load the metadata into the elements\n * matched by expr, then redefine the metadata type and run another $(expr) for other elements.\n *\n * @name $.metadata.setType\n *\n * @example <p id=\"one\" class=\"some_class {item_id: 1, item_label: 'Label'}\">This is a p</p>\n * @before $.metadata.setType(\"class\")\n * @after $(\"#one\").metadata().item_id == 1; $(\"#one\").metadata().item_label == \"Label\"\n * @desc Reads metadata from the class attribute\n *\n * @example <p id=\"one\" class=\"some_class\" data=\"{item_id: 1, item_label: 'Label'}\">This is a p</p>\n * @before $.metadata.setType(\"attr\", \"data\")\n * @after $(\"#one\").metadata().item_id == 1; $(\"#one\").metadata().item_label == \"Label\"\n * @desc Reads metadata from a \"data\" attribute\n *\n * @example <p id=\"one\" class=\"some_class\"><script>{item_id: 1, item_label: 'Label'}</script>This is a p</p>\n * @before $.metadata.setType(\"elem\", \"script\")\n * @after $(\"#one\").metadata().item_id == 1; $(\"#one\").metadata().item_label == \"Label\"\n * @desc Reads metadata from a nested script element\n *\n * @example <p id=\"one\" class=\"some_class\" data-item_id=\"1\" data-item_label=\"Label\">This is a p</p>\n * @before $.metadata.setType(\"html5\")\n * @after $(\"#one\").metadata().item_id == 1; $(\"#one\").metadata().item_label == \"Label\"\n * @desc Reads metadata from a series of data-* attributes\n *\n * @param String type The encoding type\n * @param String name The name of the attribute to be used to get metadata (optional)\n * @cat Plugins/Metadata\n * @descr Sets the type of encoding to be used when loading metadata for the first time\n * @type undefined\n * @see metadata()\n */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define([\"jquery\"], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n\n    $.extend({\n        metadata : {\n            defaults : {\n                type: 'class',\n                name: 'metadata',\n                cre: /({.*})/,\n                single: 'metadata',\n                meta:'validate'\n            },\n            setType: function( type, name ){\n                this.defaults.type = type;\n                this.defaults.name = name;\n            },\n            get: function( elem, opts ){\n                var settings = $.extend({},this.defaults,opts);\n                // check for empty string in single property\n                if (!settings.single.length) {\n                    settings.single = 'metadata';\n                }\n                if (!settings.meta.length) {\n                    settings.meta = 'validate';\n                }\n\n                var data = $.data(elem, settings.single);\n                // returned cached data if it already exists\n                if ( data ) return data;\n\n                data = \"{}\";\n\n                var getData = function(data) {\n                    if(typeof data != \"string\") return data;\n\n                    if( data.indexOf('{') < 0 ) {\n                        data = eval(\"(\" + data + \")\");\n                    }\n                }\n\n                var getObject = function(data) {\n                    if(typeof data != \"string\") return data;\n\n                    data = eval(\"(\" + data + \")\");\n                    return data;\n                }\n\n                if ( settings.type == \"html5\" ) {\n                    var object = {};\n                    $( elem.attributes ).each(function() {\n                        var name = this.nodeName;\n                        if (name.indexOf('data-' + settings.meta) === 0) {\n                            name = name.replace(/^data-/, '');\n                        }\n                        else {\n                            return true;\n                        }\n                        object[name] = getObject(this.value);\n                    });\n                } else {\n                    if ( settings.type == \"class\" ) {\n                        var m = settings.cre.exec( elem.className );\n                        if ( m )\n                            data = m[1];\n                    } else if ( settings.type == \"elem\" ) {\n                        if( !elem.getElementsByTagName ) return;\n                        var e = elem.getElementsByTagName(settings.name);\n                        if ( e.length )\n                            data = $.trim(e[0].innerHTML);\n                    } else if ( elem.getAttribute != undefined ) {\n                        var attr = elem.getAttribute( settings.name );\n                        if ( attr )\n                            data = attr;\n                    }\n                    object = getObject(data.indexOf(\"{\") < 0 ? \"{\" + data + \"}\" : data);\n                }\n\n                $.data( elem, settings.single, object );\n                return object;\n            }\n        }\n    });\n\n    /**\n     * Returns the metadata object for the first member of the jQuery object.\n     *\n     * @name metadata\n     * @descr Returns element's metadata object\n     * @param Object opts An object contianing settings to override the defaults\n     * @type jQuery\n     * @cat Plugins/Metadata\n     */\n    $.fn.metadata = function( opts ){\n        return $.metadata.get( this[0], opts );\n    };\n\n}));","jquery/editableMultiselect/js/jquery.multiselect.js":"define([\n    \"jquery\"\n], function($){\n\n    /*\n     * jQuery.multiselect plugin\n     *\n     * Form control: allow select several values from list and add new value(s) to list\n     *\n     * Licensed under the BSD License:\n     *   http://www.opensource.org/licenses/bsd-license\n     *\n     * Version: 0.9.0\n     *\n     * @author Dmitry (dio) Levashov, dio@std42.ru\n     * @example\n     *  html: <select name=\"my-select\" multiple=\"on\"><option .... </select>\n     * js   : $('select[name=\"my-select\"]').multiselect()\n     *  or\n     * var opts = { ... };\n     * $('select[name=\"my-select\"]').multiselect(opts);\n     */\n    $.fn.multiselect = function(opts) {\n        var o = $.extend({\n            mselectHiddenClass: 'mselect-hidden',\n            mselectItemNotEditableClass: 'mselect-list-item-not-editable',\n            mselectItemNotRemovableClass: 'mselect-list-item-not-removable',\n            mselectListClass: 'mselect-list',\n            mselectItemsWrapperClass: 'mselect-items-wrapper',\n            mselectButtonAddClass: 'mselect-button-add',\n            mselectInputContainerClass: 'mselect-input-container',\n            mselectInputClass: 'mselect-input',\n            mselectButtonCancelClass: 'mselect-cancel',\n            mselectButtonSaveClass: 'mselect-save',\n            mselectListItemClass: 'mselect-list-item',\n            mselectItemsWrapperOverflowClass: 'mselect-fixed',\n            mselectDisabledClass: 'mselect-disabled',\n            mselectCheckedClass: 'mselect-checked',\n            layout: '<section class=\"block %mselectListClass%\">'\n                +'<div class=\"block-content\"><div class=\"%mselectItemsWrapperClass%\">'\n                +'%items%'\n                +'</div></div>'\n                +'<footer class=\"block-footer\">'\n                +'<span class=\"action-add %mselectButtonAddClass%\">%addText%</span>'\n                +'</footer>'\n                +'<div class=\"%mselectInputContainerClass%\">'\n                +'<input type=\"text\" class=\"%mselectInputClass%\" title=\"%inputTitle%\"/>'\n                +'<span class=\"%mselectButtonCancelClass%\" title=\"%cancelText%\"></span>'\n                +'<span class=\"%mselectButtonSaveClass%\" title=\"Add\"></span>'\n                +'</div>'\n                +'</section>',\n            item : '<div  class=\"%mselectListItemClass% %mselectDisabledClass% %iseditable% %isremovable%\"><label><input type=\"checkbox\" class=\"%mselectCheckedClass%\" value=\"%value%\" %checked% %disabled% /><span>%label%</span></label>' +\n                '<span class=\"mselect-edit\" title=\"Edit\">Edit</span>' +\n                '<span class=\"mselect-delete\" title=\"Delete\">Delete</span> ' +\n                '</div>',\n            addText: 'Add new value',\n            cancelText: 'Cancel',\n            inputTitle: 'Enter new option',\n            size: 5,\n            keyCodes: {\n                Enter: 13,\n                Esc: 27\n            },\n            toggleAddButton: true,\n            // New option for callback\n            mselectInputSubmitCallback: null,\n            parse : function(v) { return v.split(/\\s*,\\s*/); }\n        }, opts||{});\n\n        return this.filter('select[multiple]:not(.' + o.mselectHiddenClass + ')').each(function() {\n            var select = $(this).addClass(o.mselectHiddenClass).hide(),\n                size = select.attr('size') > 0 ? select.attr('size') : o.size,\n                items = (function() {\n                    var str = '';\n\n                    select.children('option').each(function(i, option) {\n                        option = $(option);\n\n                        str += o.item\n                            .replace(/%value%/gi,  option.val())\n                            .replace(/%checked%/gi, option.prop('selected') ? 'checked' : '')\n                            .replace(/%mselectCheckedClass%/gi, option.prop('selected') ? ''+o.mselectCheckedClass+'' : '')\n                            .replace(/%disabled%/gi, option.prop('disabled') ? 'disabled' : '')\n                            .replace(/%mselectDisabledClass%/gi, option.prop('disabled') ? ''+o.mselectDisabledClass+'' : '')\n                            .replace(/%mselectListItemClass%/gi, o.mselectListItemClass)\n                            .replace(/%iseditable%/gi, option.attr('data-is-editable') ? ''+o.mselectItemNotEditableClass+'' : '')\n                            .replace(/%isremovable%/i, option.attr('data-is-removable') ? ''+o.mselectItemNotRemovableClass+'' : '')\n                            .replace(/%label%/gi,  option.html());\n                    });\n\n                    return str;\n                })(),\n                html = o.layout\n                    .replace(/%items%/gi, items)\n                    .replace(/%mselectListClass%/gi, o.mselectListClass)\n                    .replace(/%mselectButtonAddClass%/gi, o.mselectButtonAddClass)\n                    .replace(/%mselectButtonSaveClass%/gi, o.mselectButtonSaveClass)\n                    .replace(/%mselectButtonCancelClass%/gi, o.mselectButtonCancelClass)\n                    .replace(/%mselectItemsWrapperClass%/gi, o.mselectItemsWrapperClass)\n                    .replace(/%mselectInputContainerClass%/gi, o.mselectInputContainerClass)\n                    .replace(/%mselectInputClass%/gi, o.mselectInputClass)\n                    .replace(/%addText%/gi, o.addText)\n                    .replace(/%cancelText%/gi, o.cancelText)\n                    .replace(/%inputTitle%/gi, o.inputTitle),\n                widget = $(html)\n                    .insertAfter(this)\n                    .on('change.mselectCheck', '[type=checkbox]', function() {\n                        var checkbox = $(this),\n                            index = checkbox.closest('.' + o.mselectListItemClass + '').index();\n\n                        select.find('option').eq(index).prop('selected', !!checkbox.prop('checked'));\n                    }),\n                list = widget.find('.' + o.mselectItemsWrapperClass + ''),\n                buttonAdd = widget.find('.' + o.mselectButtonAddClass + '')\n                    .on('click.mselectAdd', function(e) {\n                        e.preventDefault();\n                        o.toggleAddButton && buttonAdd.hide();\n                        container.show();\n                        input.trigger('focus');\n                        if (input.parents(o.mselectListClass).length) {\n                            list.scrollTop(list.height());\n                        }\n                    }),\n                container = widget.find('.' + o.mselectInputContainerClass + ''),\n                input = container.find('[type=text].' + o.mselectInputClass + '')\n                    .on('blur.mselectReset', function() {\n                        reset();\n                    })\n                    .on('keydown.mselectAddNewOption', function(e) {\n                        var c = e.keyCode;\n\n                        if (c == o.keyCodes.Enter || c == o.keyCodes.Esc) {\n                            e.preventDefault();\n                            c == o.keyCodes.Enter ? append(input.val())  : reset();\n                        }\n                    }),\n                buttonSave = container.find('.' + o.mselectButtonSaveClass + '')\n                    .on('mousedown.mselectSave', function(e) {\n                        append(input.val());\n                    }),\n                buttonCancel = container.find('.' + o.mselectButtonCancelClass + '')\n                    .on('mousedown.mdelectCancel', function(e) {\n                        input.val('');\n                    }),\n                append = function(v) {\n                    // Add ability to define custom handler for adding new values\n                    if ($.isFunction(o.mselectInputSubmitCallback)) {\n                        o.mselectInputSubmitCallback(v, o);\n                        return;\n                    }\n                    // end of callback implementation\n                    $.each(typeof(o.parse) == 'function' ? o.parse(v) : [$.trim(v)], function(i, v) {\n                        var item;\n\n                        if (v && !select.children('[value=\"' + v + '\"]').length) {\n                            item = $(o.item.replace(/%value%|%label%/gi, v)\n                                .replace(/%mselectDisabledClass%|%iseditable%|%isremovable%/gi,'')\n                                .replace(/%mselectListItemClass%/gi,o.mselectListItemClass))\n                                .find('[type=checkbox]')\n                                .addClass(o.mselectCheckedClass)\n                                .prop('checked', true)\n                                .end();\n\n                            list.children('.' + o.mselectListItemClass + '').length\n                                ? list.children('.' + o.mselectListItemClas ).last().after(item)\n                                : list.prepend(item);\n\n                            select.append('<option value=\"' + v + '\" selected=\"selected\">' + v + '</option>');\n                        }\n                    });\n\n                    reset();\n                    list.scrollTop(list.height());\n                },\n                reset = function() {\n                    var ch = select.children();\n\n                    input.val('');\n                    container.hide();\n                    buttonAdd.show();\n                    list[list.children().length ? 'show' : 'hide']();\n\n                    if (ch.length >= size && !list.hasClass(o.mselectItemsWrapperOverflowClass)) {\n                        list.height(list.children('.' + o.mselectListItemClass)\n                            .first()\n                            .outerHeight(true) * size)\n                            .addClass(o.mselectItemsWrapperOverflowClass);\n                    }\n                };\n            reset();\n        }).end();\n    };\n});\n","jquery/editableMultiselect/js/jquery.editable.js":"/**\n * @file Jeditable - jQuery in place edit plugin\n * @home https://github.com/NicolasCARPi/jquery_jeditable\n * @author Mika Tuupola, Dylan Verheul, Nicolas CARPi\n * @copyright \u00a9 2006 Mika Tuupola, Dylan Verheul, Nicolas CARPi\n * @licence MIT (see LICENCE file)\n * @name Jquery-jeditable\n * @type  jQuery\n *\n * @param {String|Function} target - URL or Function to send edited content to. Can also be 'disable', 'enable', or 'destroy'\n * @param {Object} [options] - Additional options\n * @param {Object} [options.ajaxoptions] - jQuery Ajax options. See https://api.jquery.com/jQuery.ajax/\n * @param {Function} [options.before] - Function to be executed before going into edit mode\n * @param {Function} [options.callback] - function(result, settings, submitdata) Function to run after submitting edited content\n * @param {String} [options.cancel] - Cancel button value, empty means no button\n * @param {String} [options.cancelcssclass] - CSS class to apply to cancel button\n * @param {Number} [options.cols] - Number of columns if using textarea\n * @param {String} [options.cssclass] - CSS class to apply to input form; use 'inherit' to copy from parent\n * @param {String} [options.inputcssclass] - CSS class to apply to input. 'inherit' to copy from parent\n * @param {Function} [options.intercept] - Intercept the returned data so you have a chance to process it before returning it in the page\n * @param {String|Function} [options.data] - Content loaded in the form\n * @param {String} [options.event='click'] - jQuery event such as 'click' or 'dblclick'. See https://api.jquery.com/category/events/\n * @param {String} [options.formid] - Give an id to the form that is produced\n * @param {String|Number} [options.height='auto'] - Height of the element in pixels or 'auto' or 'none'\n * @param {String} [options.id='id'] - POST parameter name of edited div id\n * @param {String} [options.indicator] - Indicator html to show when saving\n * @param {String} [options.label] - Label for the form\n * @param {String} [options.list] - HTML5 attribute for text input. Will suggest from a datalist with id of the list option\n * @param {String|Function} [options.loaddata] - Extra parameters to pass when fetching content before editing\n * @param {String} [options.loadtext='Loading\u2026'] - Text to display while loading external content\n * @param {String} [options.loadtype='GET'] - Request type for loadurl (GET or POST)\n * @param {String} [options.loadurl] - URL to fetch input content before editing\n * @param {Number} [options.max] - Maximum value for number type\n * @param {String} [options.maxlength] - The maximum number of character in the text field\n * @param {String} [options.method] - Method to use to send edited content (POST or PUT)\n * @param {Number} [options.min] - Minimum value for number type\n * @param {Boolean} [options.multiple] - Allow multiple selections in a select input\n * @param {String} [options.name='value'] - POST parameter name of edited content\n * @param {String|Function} [options.onblur='cancel'] - Use 'cancel', 'submit', 'ignore' or function. If function returns false, the form is cancelled.\n * @param {Function} [options.onedit] - function triggered upon edition; will cancel edition if it returns false\n * @param {Function} [options.onerror] - function(settings, original, xhr) { ... } called on error\n * @param {Function} [options.onreset] - function(settings, original) { ... } called before reset\n * @param {Function} [options.onsubmit] - function(settings, original) { ... } called before submit\n * @param {String} [options.pattern] - HTML5 attribute for text or URL input\n * @param {String} [options.placeholder='Click to edit'] - Placeholder text or html to insert when element is empty\n * @param {Number} [options.rows] - number of rows if using textarea\n * @param {Boolean} [options.select] - When true text is selected\n * @param {Function} [options.showfn]- Function that can animate the element when switching to edit mode\n * @param {String} [options.size] - The size of the text field\n * @param {String} [options.sortselectoptions] - Sort the options of a select form\n * @param {Number} [options.step] - Step size for number type\n * @param {String} [options.style] - Style to apply to input form; 'inherit' to copy from parent\n * @param {String} [options.submit] - submit button value, empty means no button\n * @param {String} [options.submitcssclass] - CSS class to apply to submit button\n * @param {Object|Function} [options.submitdata] - Extra parameters to send when submitting edited content. function(revert, settings, submitdata)\n * @param {String} [options.tooltip] - Tooltip text that appears on hover (via title attribute)\n * @param {String} [options.type='text'] - text, textarea, select, email, number, url (or any 3rd party input type)\n * @param {String|Number} [options.width='auto'] - The width of the element in pixels or 'auto' or 'none'\n *\n * @example <caption>Simple usage example:</caption>\n * $(\".editable\").editable(\"save.php\", {\n *     cancel : 'Cancel',\n *     submit : 'Save',\n *     tooltip : \"Click to edit...\",\n * });\n */\n(function($) {\n\n    'use strict';\n\n    // Keyboard accessibility/WAI-ARIA - allow users to navigate to an editable element using TAB/Shift+TAB\n    $.fn.editableAriaShim = function () {\n        this.attr({\n            role: 'button',\n            tabindex: 0\n        });\n        return this; // <-- object chaining.\n    };\n\n    // EDITABLE function\n    $.fn.editable = function(target, options) {\n\n        if ('disable' === target) {\n            $(this).data('disabled.editable', true);\n            return;\n        }\n        if ('enable' === target) {\n            $(this).data('disabled.editable', false);\n            return;\n        }\n        if ('destroy' === target) {\n            $(this)\n                .off($(this).data('event.editable'))\n                .removeData('disabled.editable')\n                .removeData('event.editable');\n            return;\n        }\n        var settings = $.extend({}, $.fn.editable.defaults, {target:target}, options);\n\n        /* setup some functions */\n        var plugin   = $.editable.types[settings.type].plugin || function() { };\n        var submit   = $.editable.types[settings.type].submit || function() { };\n        var buttons  = $.editable.types[settings.type].buttons || $.editable.types.defaults.buttons;\n        var content  = $.editable.types[settings.type].content || $.editable.types.defaults.content;\n        var element  = $.editable.types[settings.type].element || $.editable.types.defaults.element;\n        var reset    = $.editable.types[settings.type].reset || $.editable.types.defaults.reset;\n        var destroy  = $.editable.types[settings.type].destroy || $.editable.types.defaults.destroy;\n        var callback = settings.callback || function() { };\n        var intercept = settings.intercept || function(s) { return s; };\n        var onedit   = settings.onedit   || function() { };\n        var onsubmit = settings.onsubmit || function() { };\n        var onreset  = settings.onreset  || function() { };\n        var onerror  = settings.onerror  || reset;\n        var before   = settings.before || false;\n\n        // TOOLTIP\n        if (settings.tooltip) {\n            $(this).attr('title', settings.tooltip);\n        }\n\n        return this.each(function() {\n\n            /* Save this to self because this changes when scope changes. */\n            var self = this;\n\n            /* Save so it can be later used by $.editable('destroy') */\n            $(this).data('event.editable', settings.event);\n\n            /* If element is empty add something clickable (if requested) */\n            if (!$(this).html().trim()) {\n                $(this).html(settings.placeholder);\n            }\n\n            if ('destroy' === target) {\n                destroy.apply($(this).find('form'), [settings, self]);\n                return;\n            }\n\n            // EVENT IS FIRED\n            $(this).on(settings.event, function(e) {\n\n                /* Abort if element is disabled. */\n                if (true === $(this).data('disabled.editable')) {\n                    return;\n                }\n\n                // do nothing if user press Tab again, just go to next element, not into edit mode\n                if (e.which === 9) {\n                    return;\n                }\n\n                /* Prevent throwing an exception if edit field is clicked again. */\n                if (self.editing) {\n                    return;\n                }\n\n                /* Abort if onedit hook returns false. */\n                if (false === onedit.apply(this, [settings, self, e])) {\n                    return;\n                }\n\n                /* execute the before function if any was specified */\n                if (settings.before && (typeof settings.before === 'function')) {\n                    settings.before(e);\n                } else if (settings.before && !(typeof settings.before === 'function')) {\n                    throw \"The 'before' option needs to be provided as a function!\";\n                }\n\n                /* Prevent default action and bubbling. */\n                e.preventDefault();\n                e.stopPropagation();\n\n                /* Remove tooltip. */\n                if (settings.tooltip) {\n                    $(self).removeAttr('title');\n                }\n\n                /* Remove placeholder text, replace is here because of IE. */\n                if ($(this).html().toLowerCase().replace(/(;|\"|\\/)/g, '') ===\n                    settings.placeholder.toLowerCase().replace(/(;|\"|\\/)/g, '')) {\n                    $(this).html('');\n                }\n\n                self.editing    = true;\n                self.revert     = $(self).text();\n                $(self).html('');\n\n                /* Create the form object. */\n                var form = $('<form />');\n\n                /* Apply css or style or both. */\n                if (settings.cssclass) {\n                    if ('inherit' === settings.cssclass) {\n                        form.attr('class', $(self).attr('class'));\n                    } else {\n                        form.attr('class', settings.cssclass);\n                    }\n                }\n\n                if (settings.style) {\n                    if ('inherit' === settings.style) {\n                        form.attr('style', $(self).attr('style'));\n                        /* IE needs the second line or display won't be inherited. */\n                        form.css('display', $(self).css('display'));\n                    } else {\n                        form.attr('style', settings.style);\n                    }\n                }\n\n                // add a label if it exists\n                if (settings.label) {\n                    form.append('<label>' + settings.label + '</label>');\n                }\n\n                // add an ID to the form\n                if (settings.formid) {\n                    form.attr('id', settings.formid);\n                }\n\n                /* Add main input element to form and store it in input. */\n                var input = element.apply(form, [settings, self]);\n\n                if (settings.inputcssclass) {\n                    if ('inherit' === settings.inputcssclass) {\n                        input.attr('class', $(self).attr('class'));\n                    } else {\n                        input.attr('class', settings.inputcssclass);\n                    }\n                }\n\n                /* Set input content via POST, GET, given data or existing value. */\n                var input_content;\n\n                // timeout function\n                var t;\n                var isSubmitting = false;\n\n                if (settings.loadurl) {\n                    t = self.setTimeout(function() {\n                        input.disabled = true;\n                    }, 100);\n                    $(self).html(settings.loadtext);\n\n                    var loaddata = {};\n                    loaddata[settings.id] = self.id;\n                    if (typeof settings.loaddata === 'function') {\n                        $.extend(loaddata, settings.loaddata.apply(self, [self.revert, settings]));\n                    } else {\n                        $.extend(loaddata, settings.loaddata);\n                    }\n                    $.ajax({\n                        type : settings.loadtype,\n                        url  : settings.loadurl,\n                        data : loaddata,\n                        async: false,\n                        cache : false,\n                        success: function(result) {\n                            self.clearTimeout(t);\n                            input_content = result;\n                            input.disabled = false;\n                        }\n                    });\n                } else if (settings.data) {\n                    input_content = settings.data;\n                    if (typeof settings.data === 'function') {\n                        input_content = settings.data.apply(self, [self.revert, settings]);\n                    }\n                } else {\n                    input_content = self.revert;\n                }\n                content.apply(form, [input_content, settings, self]);\n\n                input.attr('name', settings.name);\n\n                /* adjust the width of the element to account for the margin/padding/border */\n                if (settings.width !== 'none') {\n                    var adj_width = settings.width - (input.outerWidth(true) - settings.width);\n                    input.width(adj_width);\n                }\n\n                /* Add buttons to the form. */\n                buttons.apply(form, [settings, self]);\n\n                /* Add created form to self. */\n                if (settings.showfn && (typeof settings.showfn === 'function')) {\n                    form.hide();\n                }\n\n                // clear the loadtext that we put here before\n                $(self).html('');\n\n                $(self).append(form);\n\n                // execute the showfn\n                if (settings.showfn && (typeof settings.showfn === 'function')) {\n                    settings.showfn(form);\n                }\n\n                /* Attach 3rd party plugin if requested. */\n                plugin.apply(form, [settings, self]);\n\n                /* Focus to first visible form element. */\n                form.find(':input:visible:enabled:first').trigger('focus');\n\n                /* Highlight input contents when requested. */\n                if (settings.select) {\n                    input.trigger('select');\n                }\n\n                /* discard changes if pressing esc */\n                $(this).on('keydown', function(e) {\n                    if (e.which === 27) {\n                        e.preventDefault();\n                        reset.apply(form, [settings, self]);\n                        /* allow shift+enter to submit form (required for textarea) */\n                    } else if (e.which == 13 && e.shiftKey){\n                        e.preventDefault();\n                        form.trigger('submit');\n                    }\n                });\n\n                /* Discard, submit or nothing with changes when clicking outside. */\n                /* Do nothing is usable when navigating with tab. */\n                if ('cancel' === settings.onblur) {\n                    input.on('blur', function(e) {\n                        /* Prevent canceling if submit was clicked. */\n                        t = self.setTimeout(function() {\n                            reset.apply(form, [settings, self]);\n                        }, 500);\n                    });\n                } else if ('submit' === settings.onblur) {\n                    input.on('blur', function(e) {\n                        /* Prevent double submit if submit was clicked. */\n                        t = self.setTimeout(function() {\n                            form.trigger('submit');\n                        }, 200);\n                    });\n                } else if (typeof settings.onblur === 'function') {\n                    input.on('blur', function(e) {\n                        // reset the form if the onblur function returns false\n                        if (false === settings.onblur.apply(self, [input.val(), settings, form])) {\n                            reset.apply(form, [settings, self]);\n                        }\n                    });\n                }\n\n                form.on('submit', function(e) {\n\n                    /* Do no submit. */\n                    e.preventDefault();\n                    e.stopPropagation();\n\n                    if (isSubmitting) {\n                        // we are already submitting! Stop right here.\n                        return false;\n                    } else {\n                        isSubmitting = true;\n                    }\n\n                    if (t) {\n                        self.clearTimeout(t);\n                    }\n\n                    /* Call before submit hook. */\n                    /* If it returns false abort submitting. */\n                    isSubmitting = false !== onsubmit.apply(form, [settings, self]);\n                    if (isSubmitting) {\n                        /* Custom inputs call before submit hook. */\n                        /* If it returns false abort submitting. */\n                        isSubmitting = false !== submit.apply(form, [settings, self]);\n                        if (isSubmitting) {\n\n                            /* Check if given target is function */\n                            if (typeof settings.target === 'function') {\n                                /* Callback function to handle the target response */\n                                var responseHandler = function(value, complete) {\n                                    isSubmitting = false;\n                                    if (false !== complete) {\n                                        $(self).html(value);\n                                        self.editing = false;\n                                        callback.apply(self, [self.innerText, settings]);\n                                        if (!$(self).html().trim()) {\n                                            $(self).html(settings.placeholder);\n                                        }\n                                    }\n                                };\n                                /* Call the user target function */\n                                var userTarget = settings.target.apply(self, [input.val(), settings, responseHandler]);\n                                /* Handle the target function return for compatibility */\n                                if (false !== userTarget && undefined !== userTarget) {\n                                    responseHandler(userTarget, userTarget);\n                                }\n\n                            } else {\n                                /* Add edited content and id of edited element to POST. */\n                                var submitdata = {};\n                                submitdata[settings.name] = input.val();\n                                submitdata[settings.id] = self.id;\n                                /* Add extra data to be POST:ed. */\n                                if (typeof settings.submitdata === 'function') {\n                                    $.extend(submitdata, settings.submitdata.apply(self, [self.revert, settings, submitdata]));\n                                } else {\n                                    $.extend(submitdata, settings.submitdata);\n                                }\n\n                                /* Quick and dirty PUT support. */\n                                if ('PUT' === settings.method) {\n                                    submitdata._method = 'put';\n                                }\n\n                                // SHOW INDICATOR\n                                $(self).html(settings.indicator);\n\n                                /* Defaults for ajaxoptions. */\n                                var ajaxoptions = {\n                                    type    : 'POST',\n                                    complete: function (xhr, status) {\n                                        isSubmitting = false;\n                                    },\n                                    data    : submitdata,\n                                    dataType: 'html',\n                                    url     : settings.target,\n                                    success : function(result, status) {\n\n                                        // INTERCEPT\n                                        result = intercept.apply(self, [result, status]);\n\n                                        if (ajaxoptions.dataType === 'html') {\n                                            $(self).html(result);\n                                        }\n                                        self.editing = false;\n                                        callback.apply(self, [result, settings, submitdata]);\n                                        if (!$(self).html().trim()) {\n                                            $(self).html(settings.placeholder);\n                                        }\n                                    },\n                                    error   : function(xhr, status, error) {\n                                        onerror.apply(form, [settings, self, xhr]);\n                                    }\n                                };\n\n                                /* Override with what is given in settings.ajaxoptions. */\n                                $.extend(ajaxoptions, settings.ajaxoptions);\n                                $.ajax(ajaxoptions);\n                            }\n                        }\n                    }\n\n                    /* Show tooltip again. */\n                    $(self).attr('title', settings.tooltip);\n                    return false;\n                });\n            });\n\n            // PRIVILEGED METHODS\n\n            // RESET\n            self.reset = function(form) {\n                /* Prevent calling reset twice when blurring. */\n                if (self.editing) {\n                    /* Before reset hook, if it returns false abort resetting. */\n                    if (false !== onreset.apply(form, [settings, self])) {\n                        $(self).text(self.revert);\n                        self.editing   = false;\n                        if (!$(self).html().trim()) {\n                            $(self).html(settings.placeholder);\n                        }\n                        /* Show tooltip again. */\n                        if (settings.tooltip) {\n                            $(self).attr('title', settings.tooltip);\n                        }\n                    }\n                }\n            };\n\n            // DESTROY\n            self.destroy = function(form) {\n                $(self)\n                    .off($(self).data('event.editable'))\n                    .removeData('disabled.editable')\n                    .removeData('event.editable');\n\n                self.clearTimeouts();\n\n                if (self.editing) {\n                    reset.apply(form, [settings, self]);\n                }\n            };\n\n            // CLEARTIMEOUT\n            self.clearTimeout = function(t) {\n                var timeouts = $(self).data('timeouts');\n                clearTimeout(t);\n                if(timeouts) {\n                    var i = timeouts.indexOf(t);\n                    if(i > -1) {\n                        timeouts.splice(i, 1);\n                        if(timeouts.length <= 0) {\n                            $(self).removeData('timeouts');\n                        }\n                    } else {\n                        console.warn('jeditable clearTimeout could not find timeout '+t);\n                    }\n                }\n            };\n\n            // CLEAR ALL TIMEOUTS\n            self.clearTimeouts = function () {\n                var timeouts = $(self).data('timeouts');\n                if(timeouts) {\n                    for(var i = 0, n = timeouts.length; i < n; ++i) {\n                        clearTimeout(timeouts[i]);\n                    }\n                    timeouts.length = 0;\n                    $(self).removeData('timeouts');\n                }\n            };\n\n            // SETTIMEOUT\n            self.setTimeout = function(callback, time) {\n                var timeouts = $(self).data('timeouts');\n                var t = setTimeout(function() {\n                    callback();\n                    self.clearTimeout(t);\n                }, time);\n                if(!timeouts) {\n                    timeouts = [];\n                    $(self).data('timeouts', timeouts);\n                }\n                timeouts.push(t);\n                return t;\n            };\n        });\n    };\n\n    var _supportInType = function (type) {\n        var i = document.createElement('input');\n        i.setAttribute('type', type);\n        return i.type !== 'text' ? type : 'text';\n    };\n\n\n    $.editable = {\n        types: {\n            defaults: {\n                element : function(settings, original) {\n                    var input = $('<input type=\"hidden\"></input>');\n                    $(this).append(input);\n                    return(input);\n                },\n                content : function(string, settings, original) {\n                    $(this).find(':input:first').val(string);\n                },\n                reset : function(settings, original) {\n                    original.reset(this);\n                },\n                destroy: function(settings, original) {\n                    original.destroy(this);\n                },\n                buttons : function(settings, original) {\n                    var form = this;\n                    var submit;\n                    if (settings.submit) {\n                        /* If given html string use that. */\n                        if (settings.submit.match(/>$/)) {\n                            submit = $(settings.submit).on('click', function() {\n                                if (submit.attr('type') !== 'submit') {\n                                    form.trigger('submit');\n                                }\n                            });\n                            /* Otherwise use button with given string as text. */\n                        } else {\n                            submit = $('<button type=\"submit\" />');\n                            submit.html(settings.submit);\n                            if (settings.submitcssclass) {\n                                submit.addClass(settings.submitcssclass);\n                            }\n                        }\n                        $(this).append(submit);\n                    }\n                    if (settings.cancel) {\n                        var cancel;\n                        /* If given html string use that. */\n                        if (settings.cancel.match(/>$/)) {\n                            cancel = $(settings.cancel);\n                            /* otherwise use button with given string as text */\n                        } else {\n                            cancel = $('<button type=\"cancel\" />');\n                            cancel.html(settings.cancel);\n                            if (settings.cancelcssclass) {\n                                cancel.addClass(settings.cancelcssclass);\n                            }\n                        }\n                        $(this).append(cancel);\n\n                        $(cancel).on('click', function(event) {\n                            var reset;\n                            if (typeof $.editable.types[settings.type].reset === 'function') {\n                                reset = $.editable.types[settings.type].reset;\n                            } else {\n                                reset = $.editable.types.defaults.reset;\n                            }\n                            reset.apply(form, [settings, original]);\n                            return false;\n                        });\n                    }\n                }\n            },\n            text: {\n                element : function(settings, original) {\n                    var input = $('<input />').attr({\n                        autocomplete: 'off',\n                        list: settings.list,\n                        maxlength: settings.maxlength,\n                        pattern: settings.pattern,\n                        placeholder: settings.placeholder,\n                        tooltip: settings.tooltip,\n                        type: 'text'\n                    });\n\n                    if (settings.width  !== 'none') {\n                        input.css('width', settings.width);\n                    }\n\n                    if (settings.height !== 'none') {\n                        input.css('height', settings.height);\n                    }\n\n                    if (settings.size) {\n                        input.attr('size', settings.size);\n                    }\n\n                    if (settings.maxlength) {\n                        input.attr('maxlength', settings.maxlength);\n                    }\n\n                    $(this).append(input);\n                    return(input);\n                }\n            },\n\n            // TEXTAREA\n            textarea: {\n                element : function(settings, original) {\n                    var textarea = $('<textarea></textarea>');\n                    if (settings.rows) {\n                        textarea.attr('rows', settings.rows);\n                    } else if (settings.height !== 'none') {\n                        textarea.height(settings.height);\n                    }\n                    if (settings.cols) {\n                        textarea.attr('cols', settings.cols);\n                    } else if (settings.width !== 'none') {\n                        textarea.width(settings.width);\n                    }\n\n                    if (settings.maxlength) {\n                        textarea.attr('maxlength', settings.maxlength);\n                    }\n\n                    $(this).append(textarea);\n                    return(textarea);\n                }\n            },\n\n            // SELECT\n            select: {\n                element : function(settings, original) {\n                    var select = $('<select />');\n\n                    if (settings.multiple) {\n                        select.attr('multiple', 'multiple');\n                    }\n\n                    $(this).append(select);\n                    return(select);\n                },\n                content : function(data, settings, original) {\n                    var json;\n                    // If it is string assume it is json\n                    if (String === data.constructor) {\n                        json = JSON.parse(data);\n                    } else {\n                        // Otherwise assume it is a hash already\n                        json = data;\n                    }\n\n                    // Create tuples for sorting\n                    var tuples = [];\n                    var key;\n\n                    if (Array.isArray(json) && json.every(Array.isArray)) {\n                        // Process list of tuples\n                        tuples = json // JSON already contains list of [key, value]\n                        json = {};\n                        tuples.forEach(function(e) {\n                            json[e[0]] = e[1]; // Recreate json object to comply with following code\n                        });\n                    } else {\n                        // Process object\n                        for (key in json) {\n                            tuples.push([key, json[key]]); // Store: [key, value]\n                        }\n                    }\n\n                    if (settings.sortselectoptions) {\n                        // sort it\n                        tuples.sort(function (a, b) {\n                            a = a[1];\n                            b = b[1];\n                            return a < b ? -1 : (a > b ? 1 : 0);\n                        });\n                    }\n                    // now add the options to our select\n                    var option;\n                    for (var i = 0; i < tuples.length; i++) {\n                        key = tuples[i][0];\n                        var value = tuples[i][1];\n\n                        if (!json.hasOwnProperty(key)) {\n                            continue;\n                        }\n\n                        if (key !== 'selected') {\n                            option = $('<option />').val(key).append(value);\n\n                            // add the selected prop if it's the same as original or if the key is 'selected'\n                            if (json.selected === key || key === String.prototype.trim.call(original.revert == null ? \"\" : original.revert)) {\n                                $(option).prop('selected', 'selected');\n                            }\n\n                            $(this).find('select').append(option);\n                        }\n                    }\n\n                    // submit on change if no submit button defined\n                    if (!settings.submit) {\n                        var form = this;\n                        $(this).find('select').change(function() {\n                            form.trigger('submit');\n                        });\n                    }\n                }\n            },\n\n            // NUMBER\n            number: {\n                element: function (settings, original) {\n                    var input = $('<input />').attr({\n                        maxlength: settings.maxlength,\n                        placeholder: settings.placeholder,\n                        min : settings.min,\n                        max : settings.max,\n                        step: settings.step,\n                        tooltip: settings.tooltip,\n                        type: _supportInType('number')\n                    });\n                    if (settings.width  !== 'none') {\n                        input.css('width', settings.width);\n                    }\n                    $(this).append(input);\n                    return input;\n                }\n            },\n\n            // EMAIL\n            email: {\n                element: function (settings, original) {\n                    var input = $('<input />').attr({\n                        maxlength: settings.maxlength,\n                        placeholder: settings.placeholder,\n                        tooltip: settings.tooltip,\n                        type: _supportInType('email')\n                    });\n                    if (settings.width  !== 'none') {\n                        input.css('width', settings.width);\n                    }\n                    $(this).append(input);\n                    return input;\n                }\n            },\n\n            // URL\n            url: {\n                element: function (settings, original) {\n                    var input = $('<input />').attr({\n                        maxlength: settings.maxlength,\n                        pattern: settings.pattern,\n                        placeholder: settings.placeholder,\n                        tooltip: settings.tooltip,\n                        type: _supportInType('url')\n                    });\n                    if (settings.width  !== 'none') {\n                        input.css('width', settings.width);\n                    }\n                    $(this).append(input);\n                    return input;\n                }\n            }\n        },\n\n        // add new input type\n        addInputType: function(name, input) {\n            $.editable.types[name] = input;\n        }\n    };\n\n    /* Publicly accessible defaults. */\n    $.fn.editable.defaults = {\n        name       : 'value',\n        id         : 'id',\n        type       : 'text',\n        width      : 'auto',\n        height     : 'auto',\n        // Keyboard accessibility - use mouse click OR press any key to enable editing\n        event      : 'click.editable keydown.editable',\n        onblur     : 'cancel',\n        tooltip    : 'Click to edit',\n        loadtype   : 'GET',\n        loadtext   : 'Loading...',\n        placeholder: 'Click to edit',\n        sortselectoptions: false,\n        loaddata   : {},\n        submitdata : {},\n        ajaxoptions: {}\n    };\n\n})(jQuery);\n","jquery/bootstrap/collapse.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): collapse.js and base-component.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([\n    \"jquery\",\n    \"./util/index\",\n    \"./dom/data\",\n    \"./dom/event-handler\",\n    \"./dom/manipulator\",\n    \"./dom/selector-engine\"\n], function($, Util, Data, EventHandler, Manipulator, SelectorEngine) {\n    'use strict';\n\n    const defineJQueryPlugin = Util.defineJQueryPlugin;\n    const executeAfterTransition = Util.executeAfterTransition;\n    const getElement = Util.getElement;\n    const getSelectorFromElement = Util.getSelectorFromElement;\n    const getElementFromSelector = Util.getElementFromSelector;\n    const reflow = Util.reflow;\n    const typeCheckConfig = Util.typeCheckConfig;\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const VERSION = '5.1.3';\n    const NAME = 'collapse';\n    const DATA_KEY = 'bs.collapse';\n    const EVENT_KEY = `.${DATA_KEY}`;\n    const DATA_API_KEY = '.data-api';\n\n    const Default = {\n        toggle: true,\n        parent: null\n    };\n\n    const DefaultType = {\n        toggle: 'boolean',\n        parent: '(null|element)'\n    };\n\n    const EVENT_SHOW = `show${EVENT_KEY}`;\n    const EVENT_SHOWN = `shown${EVENT_KEY}`;\n    const EVENT_HIDE = `hide${EVENT_KEY}`;\n    const EVENT_HIDDEN = `hidden${EVENT_KEY}`;\n    const EVENT_CLICK_DATA_API = `click${EVENT_KEY}${DATA_API_KEY}`;\n\n    const CLASS_NAME_SHOW = 'show';\n    const CLASS_NAME_COLLAPSE = 'collapse';\n    const CLASS_NAME_COLLAPSING = 'collapsing';\n    const CLASS_NAME_COLLAPSED = 'collapsed';\n    const CLASS_NAME_DEEPER_CHILDREN = `:scope .${CLASS_NAME_COLLAPSE} .${CLASS_NAME_COLLAPSE}`;\n    const CLASS_NAME_HORIZONTAL = 'collapse-horizontal';\n\n    const WIDTH = 'width';\n    const HEIGHT = 'height';\n\n    const SELECTOR_ACTIVES = '.collapse.show, .collapse.collapsing';\n    const SELECTOR_DATA_TOGGLE = '[data-bs-toggle=\"collapse\"]';\n\n    /**\n     * ------------------------------------------------------------------------\n     * Class Definition\n     * ------------------------------------------------------------------------\n     */\n\n    var Collapse = function(element, config) {\n        element = getElement(element);\n\n        if (!element) {\n            return;\n        }\n\n        this._element = element;\n        Data.set(this._element, DATA_KEY, this);\n\n        this._isTransitioning = false;\n        this._config = this._getConfig(config);\n        this._triggerArray = [];\n\n        const toggleList = SelectorEngine.find(SELECTOR_DATA_TOGGLE);\n\n        for (let i = 0, len = toggleList.length; i < len; i++) {\n            const elem = toggleList[i];\n            const selector = getSelectorFromElement(elem);\n            const filterElement = SelectorEngine.find(selector)\n                .filter(foundElem => foundElem === this._element);\n\n            if (selector !== null && filterElement.length) {\n                this._selector = selector;\n                this._triggerArray.push(elem);\n            }\n        }\n\n        this._initializeChildren();\n\n        if (!this._config.parent) {\n            this._addAriaAndCollapsedClass(this._triggerArray, this._isShown());\n        }\n\n        if (this._config.toggle) {\n            this.toggle();\n        }\n    }\n\n    // Getters\n\n    Collapse.VERSION = VERSION;\n\n    Collapse.Default = Default;\n\n    Collapse.NAME = NAME;\n\n    Collapse.DATA_KEY = 'bs.' + Collapse.NAME;\n\n    Collapse.EVENT_KEY = '.' + Collapse.DATA_KEY;\n\n    // Public\n\n    Collapse.prototype.dispose = function() {\n        Data.remove(this._element, this.constructor.DATA_KEY);\n        EventHandler.off(this._element, this.constructor.EVENT_KEY);\n\n        Object.getOwnPropertyNames(this).forEach(propertyName => {\n            this[propertyName] = null;\n        })\n    }\n\n    Collapse.prototype._queueCallback = function(callback, element, isAnimated = true) {\n        executeAfterTransition(callback, element, isAnimated);\n    }\n\n    Collapse.prototype.toggle = function() {\n        if (this._isShown()) {\n            this.hide();\n        } else {\n            this.show();\n        }\n    }\n\n    Collapse.prototype.show = function() {\n        if (this._isTransitioning || this._isShown()) {\n            return;\n        }\n\n        let actives = [];\n        let activesData;\n\n        if (this._config.parent) {\n            const children = SelectorEngine.find(CLASS_NAME_DEEPER_CHILDREN, this._config.parent);\n            actives = SelectorEngine.find(SELECTOR_ACTIVES, this._config.parent).filter(elem => !children.includes(elem)); // remove children if greater depth\n        }\n\n        const container = SelectorEngine.findOne(this._selector);\n        if (actives.length) {\n            const tempActiveData = actives.find(elem => container !== elem);\n            activesData = tempActiveData ? Collapse.getInstance(tempActiveData) : null;\n\n            if (activesData && activesData._isTransitioning) {\n                return;\n            }\n        }\n\n        const startEvent = EventHandler.trigger(this._element, EVENT_SHOW);\n        if (startEvent.defaultPrevented) {\n            return;\n        }\n\n        actives.forEach(elemActive => {\n            if (container !== elemActive) {\n                Collapse.getOrCreateInstance(elemActive, {toggle: false}).hide();\n            }\n\n            if (!activesData) {\n                Data.set(elemActive, DATA_KEY, null);\n            }\n        })\n\n        const dimension = this._getDimension();\n\n        this._element.classList.remove(CLASS_NAME_COLLAPSE);\n        this._element.classList.add(CLASS_NAME_COLLAPSING);\n\n        this._element.style[dimension] = 0;\n\n        this._addAriaAndCollapsedClass(this._triggerArray, true);\n        this._isTransitioning = true;\n\n        const complete = () => {\n            this._isTransitioning = false;\n\n            this._element.classList.remove(CLASS_NAME_COLLAPSING);\n            this._element.classList.add(CLASS_NAME_COLLAPSE, CLASS_NAME_SHOW);\n\n            this._element.style[dimension] = '';\n\n            EventHandler.trigger(this._element, EVENT_SHOWN);\n        };\n\n        const capitalizedDimension = dimension[0].toUpperCase() + dimension.slice(1);\n        const scrollSize = `scroll${capitalizedDimension}`;\n\n        this._queueCallback(complete, this._element, true);\n        this._element.style[dimension] = `${this._element[scrollSize]}px`;\n    }\n\n    Collapse.prototype.hide = function() {\n        if (this._isTransitioning || !this._isShown()) {\n            return;\n        }\n\n        const startEvent = EventHandler.trigger(this._element, EVENT_HIDE);\n        if (startEvent.defaultPrevented) {\n            return;\n        }\n\n        const dimension = this._getDimension();\n\n        this._element.style[dimension] = `${this._element.getBoundingClientRect()[dimension]}px`;\n\n        reflow(this._element);\n\n        this._element.classList.add(CLASS_NAME_COLLAPSING);\n        this._element.classList.remove(CLASS_NAME_COLLAPSE, CLASS_NAME_SHOW);\n\n        const triggerArrayLength = this._triggerArray.length;\n        for (let i = 0; i < triggerArrayLength; i++) {\n            const trigger = this._triggerArray[i];\n            const elem = getElementFromSelector(trigger);\n\n            if (elem && !this._isShown(elem)) {\n                this._addAriaAndCollapsedClass([trigger], false);\n            }\n        }\n\n        this._isTransitioning = true;\n\n        const complete = () => {\n            this._isTransitioning = false;\n            this._element.classList.remove(CLASS_NAME_COLLAPSING);\n            this._element.classList.add(CLASS_NAME_COLLAPSE);\n            EventHandler.trigger(this._element, EVENT_HIDDEN);\n        };\n\n        this._element.style[dimension] = '';\n\n        this._queueCallback(complete, this._element, true);\n    }\n\n    Collapse.prototype._isShown = function(element = this._element) {\n        return element.classList.contains(CLASS_NAME_SHOW);\n    }\n\n    // Private\n\n    Collapse.prototype._getConfig = function(config) {\n        config = {\n            ...Default,\n            ...Manipulator.getDataAttributes(this._element),\n            ...config\n        };\n        config.toggle = Boolean(config.toggle); // Coerce string values\n        config.parent = getElement(config.parent);\n        typeCheckConfig(NAME, config, DefaultType);\n        return config;\n    }\n\n    Collapse.prototype._getDimension = function() {\n        return this._element.classList.contains(CLASS_NAME_HORIZONTAL) ? WIDTH : HEIGHT;\n    }\n\n    Collapse.prototype._initializeChildren = function() {\n        if (!this._config.parent) {\n            return;\n        }\n\n        const children = SelectorEngine.find(CLASS_NAME_DEEPER_CHILDREN, this._config.parent);\n        SelectorEngine.find(SELECTOR_DATA_TOGGLE, this._config.parent).filter(elem => !children.includes(elem))\n            .forEach(element => {\n                const selected = getElementFromSelector(element);\n\n                if (selected) {\n                    this._addAriaAndCollapsedClass([element], this._isShown(selected));\n                }\n            })\n    }\n\n    Collapse.prototype._addAriaAndCollapsedClass = function(triggerArray, isOpen) {\n        if (!triggerArray.length) {\n            return;\n        }\n\n        triggerArray.forEach(elem => {\n            if (isOpen) {\n                elem.classList.remove(CLASS_NAME_COLLAPSED);\n            } else {\n                elem.classList.add(CLASS_NAME_COLLAPSED);\n            }\n\n            elem.setAttribute('aria-expanded', isOpen);\n        })\n    }\n\n    // Static\n\n    Collapse.getInstance = function(element) {\n        return Data.get(getElement(element), this.DATA_KEY);\n    }\n\n    Collapse.getOrCreateInstance = function(element, config = {}) {\n        return this.getInstance(element) || new this(element, typeof config === 'object' ? config : null);\n    }\n\n    Collapse.jQueryInterface = function(config) {\n        return this.each(function () {\n            const _config = {};\n            if (typeof config === 'string' && /show|hide/.test(config)) {\n                _config.toggle = false;\n            }\n\n            const data = Collapse.getOrCreateInstance(this, _config);\n\n            if (typeof config === 'string') {\n                if (typeof data[config] === 'undefined') {\n                    throw new TypeError(`No method named \"${config}\"`);\n                }\n\n                data[config]();\n            }\n        })\n    }\n\n    /**\n     * ------------------------------------------------------------------------\n     * Data Api implementation\n     * ------------------------------------------------------------------------\n     */\n\n    EventHandler.on(document, EVENT_CLICK_DATA_API, SELECTOR_DATA_TOGGLE, function (event) {\n        // preventDefault only for <a> elements (which change the URL) not inside the collapsible element\n        if (event.target.tagName === 'A' || (event.delegateTarget && event.delegateTarget.tagName === 'A')) {\n            event.preventDefault();\n        }\n\n        const selector = getSelectorFromElement(this);\n        const selectorElements = SelectorEngine.find(selector);\n\n        selectorElements.forEach(element => {\n            Collapse.getOrCreateInstance(element, {toggle: false}).toggle();\n        })\n    })\n\n    /**\n     * ------------------------------------------------------------------------\n     * jQuery\n     * ------------------------------------------------------------------------\n     * add .Collapse to jQuery only if jQuery is present\n     */\n\n    defineJQueryPlugin(Collapse);\n\n    return Collapse;\n});\n","jquery/bootstrap/tab.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): tab.js and base-component.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([\n    \"./util/index\",\n    \"./dom/event-handler\",\n    \"./dom/selector-engine\"\n], function(Util, EventHandler, SelectorEngine) {\n    'use strict';\n\n    const defineJQueryPlugin = Util.defineJQueryPlugin;\n    const executeAfterTransition = Util.executeAfterTransition;\n    const getElement = Util.getElement;\n    const getElementFromSelector = Util.getElementFromSelector;\n    const isDisabled = Util.isDisabled;\n    const reflow = Util.reflow;\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const VERSION = '5.1.3';\n    const NAME = 'tab';\n    const DATA_KEY = 'bs.tab';\n    const EVENT_KEY = `.${DATA_KEY}`;\n    const DATA_API_KEY = '.data-api';\n\n    const EVENT_HIDE = `hide${EVENT_KEY}`;\n    const EVENT_HIDDEN = `hidden${EVENT_KEY}`;\n    const EVENT_SHOW = `show${EVENT_KEY}`;\n    const EVENT_SHOWN = `shown${EVENT_KEY}`;\n    const EVENT_CLICK_DATA_API = `click${EVENT_KEY}${DATA_API_KEY}`;\n\n    const CLASS_NAME_DROPDOWN_MENU = 'dropdown-menu';\n    const CLASS_NAME_ACTIVE = 'active';\n    const CLASS_NAME_FADE = 'fade';\n    const CLASS_NAME_SHOW = 'show';\n\n    const SELECTOR_DROPDOWN = '.dropdown';\n    const SELECTOR_NAV_LIST_GROUP = '.nav, .list-group';\n    const SELECTOR_ACTIVE = '.active';\n    const SELECTOR_ACTIVE_UL = ':scope > li > .active';\n    const SELECTOR_DATA_TOGGLE = '[data-bs-toggle=\"tab\"], [data-bs-toggle=\"pill\"], [data-bs-toggle=\"list\"]';\n    const SELECTOR_DROPDOWN_TOGGLE = '.dropdown-toggle';\n    const SELECTOR_DROPDOWN_ACTIVE_CHILD = ':scope > .dropdown-menu .active';\n\n    /**\n     * ------------------------------------------------------------------------\n     * Class Definition\n     * ------------------------------------------------------------------------\n     */\n\n    function Tab(element) {\n        element = getElement(element);\n\n        if (!element) {\n            return;\n        }\n\n        this._element = element;\n        Data.set(this._element, DATA_KEY, this);\n    }\n\n    // Getters\n\n    Tab.VERSION = VERSION;\n\n    Tab.NAME = NAME;\n\n    Tab.DATA_KEY = 'bs.' + Tab.NAME;\n\n    Tab.EVENT_KEY = '.' + Tab.DATA_KEY;\n\n    // Public\n\n    Tab.prototype.dispose = function() {\n        Data.remove(this._element, this.constructor.DATA_KEY);\n        EventHandler.off(this._element, this.constructor.EVENT_KEY);\n\n        Object.getOwnPropertyNames(this).forEach(propertyName => {\n            this[propertyName] = null;\n        })\n    }\n\n    Tab.prototype._queueCallback = function(callback, element, isAnimated = true) {\n        executeAfterTransition(callback, element, isAnimated);\n    }\n\n    Tab.prototype.show = function() {\n        if ((this._element.parentNode &&\n            this._element.parentNode.nodeType === Node.ELEMENT_NODE &&\n            this._element.classList.contains(CLASS_NAME_ACTIVE))) {\n            return;\n        }\n\n        let previous;\n        const target = getElementFromSelector(this._element);\n        const listElement = this._element.closest(SELECTOR_NAV_LIST_GROUP);\n\n        if (listElement) {\n            const itemSelector = listElement.nodeName === 'UL' || listElement.nodeName === 'OL' ? SELECTOR_ACTIVE_UL : SELECTOR_ACTIVE;\n            previous = SelectorEngine.find(itemSelector, listElement);\n            previous = previous[previous.length - 1];\n        }\n\n        const hideEvent = previous ?\n            EventHandler.trigger(previous, EVENT_HIDE, {\n                relatedTarget: this._element\n            }) :\n            null;\n\n        const showEvent = EventHandler.trigger(this._element, EVENT_SHOW, {\n            relatedTarget: previous\n        });\n\n        if (showEvent.defaultPrevented || (hideEvent !== null && hideEvent.defaultPrevented)) {\n            return;\n        }\n\n        this._activate(this._element, listElement);\n\n        const complete = () => {\n            EventHandler.trigger(previous, EVENT_HIDDEN, {\n                relatedTarget: this._element\n            });\n            EventHandler.trigger(this._element, EVENT_SHOWN, {\n                relatedTarget: previous\n            });\n        };\n\n        if (target) {\n            this._activate(target, target.parentNode, complete);\n        } else {\n            complete();\n        }\n    }\n\n    // Private\n\n    Tab.prototype._activate = function(element, container, callback) {\n        const activeElements = container && (container.nodeName === 'UL' || container.nodeName === 'OL') ?\n            SelectorEngine.find(SELECTOR_ACTIVE_UL, container) :\n            SelectorEngine.children(container, SELECTOR_ACTIVE);\n\n        const active = activeElements[0];\n        const isTransitioning = callback && (active && active.classList.contains(CLASS_NAME_FADE));\n\n        const complete = () => this._transitionComplete(element, active, callback);\n\n        if (active && isTransitioning) {\n            active.classList.remove(CLASS_NAME_SHOW);\n            this._queueCallback(complete, element, true);\n        } else {\n            complete();\n        }\n    }\n\n    Tab.prototype._transitionComplete = function(element, active, callback) {\n        if (active) {\n            active.classList.remove(CLASS_NAME_ACTIVE);\n\n            const dropdownChild = SelectorEngine.findOne(SELECTOR_DROPDOWN_ACTIVE_CHILD, active.parentNode);\n\n            if (dropdownChild) {\n                dropdownChild.classList.remove(CLASS_NAME_ACTIVE);\n            }\n\n            if (active.getAttribute('role') === 'tab') {\n                active.setAttribute('aria-selected', false);\n            }\n        }\n\n        element.classList.add(CLASS_NAME_ACTIVE);\n        if (element.getAttribute('role') === 'tab') {\n            element.setAttribute('aria-selected', true);\n        }\n\n        reflow(element);\n\n        if (element.classList.contains(CLASS_NAME_FADE)) {\n            element.classList.add(CLASS_NAME_SHOW);\n        }\n\n        let parent = element.parentNode;\n        if (parent && parent.nodeName === 'LI') {\n            parent = parent.parentNode;\n        }\n\n        if (parent && parent.classList.contains(CLASS_NAME_DROPDOWN_MENU)) {\n            const dropdownElement = element.closest(SELECTOR_DROPDOWN);\n\n            if (dropdownElement) {\n                SelectorEngine.find(SELECTOR_DROPDOWN_TOGGLE, dropdownElement)\n                    .forEach(dropdown => dropdown.classList.add(CLASS_NAME_ACTIVE));\n            }\n\n            element.setAttribute('aria-expanded', true);\n        }\n\n        if (callback) {\n            callback();\n        }\n    }\n\n    // Static\n\n    Tab.getInstance = function(element) {\n        return Data.get(getElement(element), this.DATA_KEY);\n    }\n\n    Tab.getOrCreateInstance = function(element, config = {}) {\n        return this.getInstance(element) || new this(element, typeof config === 'object' ? config : null);\n    }\n\n    Tab.jQueryInterface = function(config) {\n        return this.each(function () {\n            const data = Tab.getOrCreateInstance(this);\n\n            if (typeof config === 'string') {\n                if (typeof data[config] === 'undefined') {\n                    throw new TypeError(`No method named \"${config}\"`);\n                }\n\n                data[config]();\n            }\n        })\n    }\n\n    /**\n     * ------------------------------------------------------------------------\n     * Data Api implementation\n     * ------------------------------------------------------------------------\n     */\n\n    EventHandler.on(document, EVENT_CLICK_DATA_API, SELECTOR_DATA_TOGGLE, function (event) {\n        if (['A', 'AREA'].includes(this.tagName)) {\n            event.preventDefault();\n        }\n\n        if (isDisabled(this)) {\n            return;\n        }\n\n        const data = Tab.getOrCreateInstance(this);\n        data.show();\n    })\n\n    /**\n     * ------------------------------------------------------------------------\n     * jQuery\n     * ------------------------------------------------------------------------\n     * add .Tab to jQuery only if jQuery is present\n     */\n\n    defineJQueryPlugin(Tab);\n\n    return Tab;\n});\n","jquery/bootstrap/util/index.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): util/index.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\n\ndefine([\n    \"jquery\",\n    'domReady!'\n], function() {\n    'use strict';\n\n    const MAX_UID = 1000000;\n    const MILLISECONDS_MULTIPLIER = 1000;\n    const TRANSITION_END = 'transitionend';\n\n    // Shoutout AngusCroll (https://goo.gl/pxwQGp)\n    const toType = obj => {\n        if (obj === null || obj === undefined) {\n            return `${obj}`\n        }\n\n        return {}.toString.call(obj).match(/\\s([a-z]+)/i)[1].toLowerCase()\n    };\n\n    /**\n     * --------------------------------------------------------------------------\n     * Public Util Api\n     * --------------------------------------------------------------------------\n     */\n\n    const getUID = prefix => {\n        do {\n            prefix += Math.floor(Math.random() * MAX_UID)\n        } while (document.getElementById(prefix))\n\n        return prefix\n    };\n\n    const getSelector = element => {\n        let selector = element.getAttribute('data-bs-target');\n\n        if (!selector || selector === '#') {\n            let hrefAttr = element.getAttribute('href');\n\n            // The only valid content that could double as a selector are IDs or classes,\n            // so everything starting with `#` or `.`. If a \"real\" URL is used as the selector,\n            // `document.querySelector` will rightfully complain it is invalid.\n            // See https://github.com/twbs/bootstrap/issues/32273\n            if (!hrefAttr || (!hrefAttr.includes('#') && !hrefAttr.startsWith('.'))) {\n                return null\n            }\n\n            // Just in case some CMS puts out a full URL with the anchor appended\n            if (hrefAttr.includes('#') && !hrefAttr.startsWith('#')) {\n                hrefAttr = `#${hrefAttr.split('#')[1]}`\n            }\n\n            selector = hrefAttr && hrefAttr !== '#' ? hrefAttr.trim() : null\n        }\n\n        return selector\n    };\n\n    const getSelectorFromElement = element => {\n        const selector = getSelector(element);\n\n        if (selector) {\n            return document.querySelector(selector) ? selector : null\n        }\n\n        return null\n    };\n\n    const getElementFromSelector = element => {\n        const selector = getSelector(element);\n\n        return selector ? document.querySelector(selector) : null\n    };\n\n    const getTransitionDurationFromElement = element => {\n        if (!element) {\n            return 0\n        }\n\n        // Get transition-duration of the element\n        let {transitionDuration, transitionDelay} = window.getComputedStyle(element);\n\n        const floatTransitionDuration = Number.parseFloat(transitionDuration);\n        const floatTransitionDelay = Number.parseFloat(transitionDelay);\n\n        // Return 0 if element or transition duration is not found\n        if (!floatTransitionDuration && !floatTransitionDelay) {\n            return 0\n        }\n\n        // If multiple durations are defined, take the first\n        transitionDuration = transitionDuration.split(',')[0]\n        transitionDelay = transitionDelay.split(',')[0]\n\n        return (Number.parseFloat(transitionDuration) + Number.parseFloat(transitionDelay)) * MILLISECONDS_MULTIPLIER\n    };\n\n    const triggerTransitionEnd = element => {\n        element.dispatchEvent(new Event(TRANSITION_END))\n    };\n\n    const isElement = obj => {\n        if (!obj || typeof obj !== 'object') {\n            return false\n        }\n\n        if (typeof obj.jquery !== 'undefined') {\n            obj = obj[0]\n        }\n\n        return typeof obj.nodeType !== 'undefined'\n    };\n\n    const getElement = obj => {\n        if (isElement(obj)) { // it's a jQuery object or a node element\n            return obj.jquery ? obj[0] : obj\n        }\n\n        if (typeof obj === 'string' && obj.length > 0) {\n            return document.querySelector(obj)\n        }\n\n        return null\n    };\n\n    const typeCheckConfig = (componentName, config, configTypes) => {\n        Object.keys(configTypes).forEach(property => {\n            const expectedTypes = configTypes[property];\n            const value = config[property];\n            const valueType = value && isElement(value) ? 'element' : toType(value);\n\n            if (!new RegExp(expectedTypes).test(valueType)) {\n                throw new TypeError(\n                    `${componentName.toUpperCase()}: Option \"${property}\" provided type \"${valueType}\" but expected type \"${expectedTypes}\".`\n                )\n            }\n        })\n    };\n\n    const isVisible = element => {\n        if (!isElement(element) || element.getClientRects().length === 0) {\n            return false\n        }\n\n        return getComputedStyle(element).getPropertyValue('visibility') === 'visible'\n    };\n\n    const isDisabled = element => {\n        if (!element || element.nodeType !== Node.ELEMENT_NODE) {\n            return true\n        }\n\n        if (element.classList.contains('disabled')) {\n            return true\n        }\n\n        if (typeof element.disabled !== 'undefined') {\n            return element.disabled\n        }\n\n        return element.hasAttribute('disabled') && element.getAttribute('disabled') !== 'false'\n    };\n\n    const findShadowRoot = element => {\n        if (!document.documentElement.attachShadow) {\n            return null\n        }\n\n        // Can find the shadow root otherwise it'll return the document\n        if (typeof element.getRootNode === 'function') {\n            const root = element.getRootNode();\n            return root instanceof ShadowRoot ? root : null\n        }\n\n        if (element instanceof ShadowRoot) {\n            return element\n        }\n\n        // when we don't find a shadow root\n        if (!element.parentNode) {\n            return null\n        }\n\n        return findShadowRoot(element.parentNode)\n    };\n\n    const noop = () => {};\n\n    /**\n     * Trick to restart an element's animation\n     *\n     * @param {HTMLElement} element\n     * @return void\n     *\n     * @see https://www.charistheo.io/blog/2021/02/restart-a-css-animation-with-javascript/#restarting-a-css-animation\n     */\n    const reflow = element => {\n        // eslint-disable-next-line no-unused-expressions\n        element.offsetHeight\n    };\n\n    const getjQuery = () => {\n        const {jQuery} = window;\n\n        if (jQuery && !document.body.hasAttribute('data-bs-no-jquery')) {\n            return jQuery\n        }\n\n        return null\n    };\n\n    const DOMContentLoadedCallbacks = [];\n\n    const onDOMContentLoaded = callback => {\n        if (document.readyState === 'loading') {\n            // add listener on the first call when the document is in loading state\n            if (!DOMContentLoadedCallbacks.length) {\n                document.addEventListener('DOMContentLoaded', () => {\n                    DOMContentLoadedCallbacks.forEach(callback => callback())\n                })\n            }\n\n            DOMContentLoadedCallbacks.push(callback)\n        } else {\n            callback()\n        }\n    };\n\n    const isRTL = () => document.documentElement.dir === 'rtl';\n\n    const defineJQueryPlugin = plugin => {\n        onDOMContentLoaded(() => {\n            const $ = getjQuery();\n            /* istanbul ignore if */\n            if ($) {\n                const name = plugin.NAME;\n                const JQUERY_NO_CONFLICT = $.fn[name];\n                $.fn[name] = plugin.jQueryInterface\n                $.fn[name].Constructor = plugin\n                $.fn[name].noConflict = () => {\n                    $.fn[name] = JQUERY_NO_CONFLICT\n                    return plugin.jQueryInterface\n                }\n            }\n        })\n    };\n\n    const execute = callback => {\n        if (typeof callback === 'function') {\n            callback()\n        }\n    };\n\n    const executeAfterTransition = (callback, transitionElement, waitForTransition = true) => {\n        if (!waitForTransition) {\n            execute(callback)\n            return\n        }\n\n        const durationPadding = 5;\n        const emulatedDuration = getTransitionDurationFromElement(transitionElement) + durationPadding;\n\n        let called = false;\n\n        const handler = ({ target }) => {\n            if (target !== transitionElement) {\n                return\n            }\n\n            called = true\n            transitionElement.removeEventListener(TRANSITION_END, handler)\n            execute(callback)\n        };\n\n        transitionElement.addEventListener(TRANSITION_END, handler)\n        setTimeout(() => {\n            if (!called) {\n                triggerTransitionEnd(transitionElement)\n            }\n        }, emulatedDuration)\n    };\n\n    /**\n     * Return the previous/next element of a list.\n     *\n     * @param {array} list    The list of elements\n     * @param activeElement   The active element\n     * @param shouldGetNext   Choose to get next or previous element\n     * @param isCycleAllowed\n     * @return {Element|elem} The proper element\n     */\n    const getNextActiveElement = (list, activeElement, shouldGetNext, isCycleAllowed) => {\n        let index = list.indexOf(activeElement);\n\n        // if the element does not exist in the list return an element depending on the direction and if cycle is allowed\n        if (index === -1) {\n            return list[!shouldGetNext && isCycleAllowed ? list.length - 1 : 0]\n        }\n\n        const listLength = list.length;\n\n        index += shouldGetNext ? 1 : -1\n\n        if (isCycleAllowed) {\n            index = (index + listLength) % listLength\n        }\n\n        return list[Math.max(0, Math.min(index, listLength - 1))]\n    };\n\n    return {\n        getElement,\n        getUID,\n        getSelectorFromElement,\n        getElementFromSelector,\n        getTransitionDurationFromElement,\n        triggerTransitionEnd,\n        isElement,\n        typeCheckConfig,\n        isVisible,\n        isDisabled,\n        findShadowRoot,\n        noop,\n        getNextActiveElement,\n        reflow,\n        getjQuery,\n        onDOMContentLoaded,\n        isRTL,\n        defineJQueryPlugin,\n        execute,\n        executeAfterTransition\n    };\n});\n","jquery/bootstrap/dom/manipulator.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): dom/manipulator.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([], function() {\n    'use strict';\n\n    function normalizeData(val) {\n        if (val === 'true') {\n            return true\n        }\n\n        if (val === 'false') {\n            return false\n        }\n\n        if (val === Number(val).toString()) {\n            return Number(val)\n        }\n\n        if (val === '' || val === 'null') {\n            return null\n        }\n\n        return val\n    }\n\n    function normalizeDataKey(key) {\n        return key.replace(/[A-Z]/g, chr => `-${chr.toLowerCase()}`)\n    }\n\n    return {\n        setDataAttribute: function(element, key, value) {\n            element.setAttribute(`data-bs-${normalizeDataKey(key)}`, value)\n        },\n\n        removeDataAttribute: function(element, key) {\n            element.removeAttribute(`data-bs-${normalizeDataKey(key)}`)\n        },\n\n        getDataAttributes: function(element) {\n            if (!element) {\n                return {}\n            }\n\n            const attributes = {};\n\n            Object.keys(element.dataset)\n                .filter(key => key.startsWith('bs'))\n                .forEach(key => {\n                    let pureKey = key.replace(/^bs/, '');\n                    pureKey = pureKey.charAt(0).toLowerCase() + pureKey.slice(1, pureKey.length)\n                    attributes[pureKey] = normalizeData(element.dataset[key])\n                })\n\n            return attributes\n        },\n\n        getDataAttribute: function(element, key) {\n            return normalizeData(element.getAttribute(`data-bs-${normalizeDataKey(key)}`))\n        },\n\n        offset: function(element) {\n            const rect = element.getBoundingClientRect();\n\n            return {\n                top: rect.top + window.pageYOffset,\n                left: rect.left + window.pageXOffset\n            }\n        },\n\n        position: function(element) {\n            return {\n                top: element.offsetTop,\n                left: element.offsetLeft\n            }\n        }\n    }\n});\n","jquery/bootstrap/dom/event-handler.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): dom/event-handler.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([\n    \"../util/index\"\n], function(Util) {\n    'use strict';\n\n    const getjQuery = Util.getjQuery;\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const namespaceRegex = /[^.]*(?=\\..*)\\.|.*/;\n    const stripNameRegex = /\\..*/;\n    const stripUidRegex = /::\\d+$/;\n    const eventRegistry = {}; // Events storage\n    let uidEvent = 1;\n    const customEvents = {\n        mouseenter: 'mouseover',\n        mouseleave: 'mouseout'\n    };\n    const customEventsRegex = /^(mouseenter|mouseleave)/i;\n    const nativeEvents = new Set([\n        'click',\n        'dblclick',\n        'mouseup',\n        'mousedown',\n        'contextmenu',\n        'mousewheel',\n        'DOMMouseScroll',\n        'mouseover',\n        'mouseout',\n        'mousemove',\n        'selectstart',\n        'selectend',\n        'keydown',\n        'keypress',\n        'keyup',\n        'orientationchange',\n        'touchstart',\n        'touchmove',\n        'touchend',\n        'touchcancel',\n        'pointerdown',\n        'pointermove',\n        'pointerup',\n        'pointerleave',\n        'pointercancel',\n        'gesturestart',\n        'gesturechange',\n        'gestureend',\n        'focus',\n        'blur',\n        'change',\n        'reset',\n        'select',\n        'submit',\n        'focusin',\n        'focusout',\n        'load',\n        'unload',\n        'beforeunload',\n        'resize',\n        'move',\n        'DOMContentLoaded',\n        'readystatechange',\n        'error',\n        'abort',\n        'scroll'\n    ]);\n\n    /**\n     * ------------------------------------------------------------------------\n     * Private methods\n     * ------------------------------------------------------------------------\n     */\n\n    function getUidEvent(element, uid) {\n        return (uid && `${uid}::${uidEvent++}`) || element.uidEvent || uidEvent++\n    }\n\n    function getEvent(element) {\n        const uid = getUidEvent(element);\n\n        element.uidEvent = uid\n        eventRegistry[uid] = eventRegistry[uid] || {}\n\n        return eventRegistry[uid]\n    }\n\n    function bootstrapHandler(element, fn) {\n        return function handler(event) {\n            event.delegateTarget = element\n\n            if (handler.oneOff) {\n                EventHandler.off(element, event.type, fn)\n            }\n\n            return fn.apply(element, [event])\n        }\n    }\n\n    function bootstrapDelegationHandler(element, selector, fn) {\n        return function handler(event) {\n            const domElements = element.querySelectorAll(selector);\n\n            for (let {target} = event; target && target !== this; target = target.parentNode) {\n                for (let i = domElements.length; i--;) {\n                    if (domElements[i] === target) {\n                        event.delegateTarget = target\n\n                        if (handler.oneOff) {\n                            EventHandler.off(element, event.type, selector, fn)\n                        }\n\n                        return fn.apply(target, [event])\n                    }\n                }\n            }\n\n            // To please ESLint\n            return null\n        }\n    }\n\n    function findHandler(events, handler, delegationSelector = null) {\n        const uidEventList = Object.keys(events);\n\n        for (let i = 0, len = uidEventList.length; i < len; i++) {\n            const event = events[uidEventList[i]];\n\n            if (event.originalHandler === handler && event.delegationSelector === delegationSelector) {\n                return event\n            }\n        }\n\n        return null\n    }\n\n    function normalizeParams(originalTypeEvent, handler, delegationFn) {\n        const delegation = typeof handler === 'string';\n        const originalHandler = delegation ? delegationFn : handler;\n\n        let typeEvent = getTypeEvent(originalTypeEvent);\n        const isNative = nativeEvents.has(typeEvent);\n\n        if (!isNative) {\n            typeEvent = originalTypeEvent\n        }\n\n        return [delegation, originalHandler, typeEvent]\n    }\n\n    function addHandler(element, originalTypeEvent, handler, delegationFn, oneOff) {\n        if (typeof originalTypeEvent !== 'string' || !element) {\n            return\n        }\n\n        if (!handler) {\n            handler = delegationFn\n            delegationFn = null\n        }\n\n        // in case of mouseenter or mouseleave wrap the handler within a function that checks for its DOM position\n        // this prevents the handler from being dispatched the same way as mouseover or mouseout does\n        if (customEventsRegex.test(originalTypeEvent)) {\n            const wrapFn = fn => {\n                return function (event) {\n                    if (!event.relatedTarget || (event.relatedTarget !== event.delegateTarget && !event.delegateTarget.contains(event.relatedTarget))) {\n                        return fn.call(this, event)\n                    }\n                }\n            };\n\n            if (delegationFn) {\n                delegationFn = wrapFn(delegationFn)\n            } else {\n                handler = wrapFn(handler)\n            }\n        }\n\n        const [delegation, originalHandler, typeEvent] = normalizeParams(originalTypeEvent, handler, delegationFn);\n        const events = getEvent(element);\n        const handlers = events[typeEvent] || (events[typeEvent] = {});\n        const previousFn = findHandler(handlers, originalHandler, delegation ? handler : null);\n\n        if (previousFn) {\n            previousFn.oneOff = previousFn.oneOff && oneOff\n\n            return\n        }\n\n        const uid = getUidEvent(originalHandler, originalTypeEvent.replace(namespaceRegex, ''));\n        const fn = delegation ?\n            bootstrapDelegationHandler(element, handler, delegationFn) :\n            bootstrapHandler(element, handler);\n\n        fn.delegationSelector = delegation ? handler : null\n        fn.originalHandler = originalHandler\n        fn.oneOff = oneOff\n        fn.uidEvent = uid\n        handlers[uid] = fn\n\n        element.addEventListener(typeEvent, fn, delegation)\n    }\n\n    function removeHandler(element, events, typeEvent, handler, delegationSelector) {\n        const fn = findHandler(events[typeEvent], handler, delegationSelector);\n\n        if (!fn) {\n            return\n        }\n\n        element.removeEventListener(typeEvent, fn, Boolean(delegationSelector))\n        delete events[typeEvent][fn.uidEvent]\n    }\n\n    function removeNamespacedHandlers(element, events, typeEvent, namespace) {\n        const storeElementEvent = events[typeEvent] || {};\n\n        Object.keys(storeElementEvent).forEach(handlerKey => {\n            if (handlerKey.includes(namespace)) {\n                const event = storeElementEvent[handlerKey];\n\n                removeHandler(element, events, typeEvent, event.originalHandler, event.delegationSelector)\n            }\n        })\n    }\n\n    function getTypeEvent(event) {\n        // allow to get the native events from namespaced events ('click.bs.button' --> 'click')\n        event = event.replace(stripNameRegex, '')\n        return customEvents[event] || event\n    }\n\n    return {\n        on: function(element, event, handler, delegationFn) {\n            addHandler(element, event, handler, delegationFn, false)\n        },\n\n        one: function(element, event, handler, delegationFn) {\n            addHandler(element, event, handler, delegationFn, true)\n        },\n\n        off: function(element, originalTypeEvent, handler, delegationFn) {\n            if (typeof originalTypeEvent !== 'string' || !element) {\n                return\n            }\n\n            const [delegation, originalHandler, typeEvent] = normalizeParams(originalTypeEvent, handler, delegationFn);\n            const inNamespace = typeEvent !== originalTypeEvent;\n            const events = getEvent(element);\n            const isNamespace = originalTypeEvent.startsWith('.');\n\n            if (typeof originalHandler !== 'undefined') {\n                // Simplest case: handler is passed, remove that listener ONLY.\n                if (!events || !events[typeEvent]) {\n                    return\n                }\n\n                removeHandler(element, events, typeEvent, originalHandler, delegation ? handler : null)\n                return\n            }\n\n            if (isNamespace) {\n                Object.keys(events).forEach(elementEvent => {\n                    removeNamespacedHandlers(element, events, elementEvent, originalTypeEvent.slice(1))\n                })\n            }\n\n            const storeElementEvent = events[typeEvent] || {};\n            Object.keys(storeElementEvent).forEach(keyHandlers => {\n                const handlerKey = keyHandlers.replace(stripUidRegex, '');\n\n                if (!inNamespace || originalTypeEvent.includes(handlerKey)) {\n                    const event = storeElementEvent[keyHandlers];\n\n                    removeHandler(element, events, typeEvent, event.originalHandler, event.delegationSelector)\n                }\n            })\n        },\n\n        trigger: function(element, event, args) {\n            if (typeof event !== 'string' || !element) {\n                return null\n            }\n\n            const $ = getjQuery();\n            const typeEvent = getTypeEvent(event);\n            const inNamespace = event !== typeEvent;\n            const isNative = nativeEvents.has(typeEvent);\n\n            let jQueryEvent;\n            let bubbles = true;\n            let nativeDispatch = true;\n            let defaultPrevented = false;\n            let evt = null;\n\n            if (inNamespace && $) {\n                jQueryEvent = $.Event(event, args)\n\n                $(element).trigger(jQueryEvent)\n                bubbles = !jQueryEvent.isPropagationStopped()\n                nativeDispatch = !jQueryEvent.isImmediatePropagationStopped()\n                defaultPrevented = jQueryEvent.isDefaultPrevented()\n            }\n\n            if (isNative) {\n                evt = document.createEvent('HTMLEvents')\n                evt.initEvent(typeEvent, bubbles, true)\n            } else {\n                evt = new CustomEvent(event, {\n                    bubbles,\n                    cancelable: true\n                })\n            }\n\n            // merge custom information in our event\n            if (typeof args !== 'undefined') {\n                Object.keys(args).forEach(key => {\n                    Object.defineProperty(evt, key, {\n                        get() {\n                            return args[key]\n                        }\n                    })\n                })\n            }\n\n            if (defaultPrevented) {\n                evt.preventDefault()\n            }\n\n            if (nativeDispatch) {\n                element.dispatchEvent(evt)\n            }\n\n            if (evt.defaultPrevented && typeof jQueryEvent !== 'undefined') {\n                jQueryEvent.preventDefault()\n            }\n\n            return evt\n        }\n    }\n});\n","jquery/bootstrap/dom/selector-engine.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): dom/selector-engine.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([\n    \"../util/index\"\n], function(Util) {\n    'use strict';\n\n    const isDisabled = Util.isDisabled;\n    const isVisible = Util.isVisible;\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const NODE_TEXT = 3;\n\n    return {\n        find: function(selector, element = document.documentElement) {\n            return [].concat(...Element.prototype.querySelectorAll.call(element, selector))\n        },\n\n        findOne: function(selector, element = document.documentElement) {\n            return Element.prototype.querySelector.call(element, selector)\n        },\n\n        children: function(element, selector) {\n            return [].concat(...element.children)\n                .filter(child => child.matches(selector))\n        },\n\n        parents: function(element, selector) {\n            const parents = [];\n\n            let ancestor = element.parentNode;\n\n            while (ancestor && ancestor.nodeType === Node.ELEMENT_NODE && ancestor.nodeType !== NODE_TEXT) {\n                if (ancestor.matches(selector)) {\n                    parents.push(ancestor)\n                }\n\n                ancestor = ancestor.parentNode\n            }\n\n            return parents\n        },\n\n        prev: function(element, selector) {\n            let previous = element.previousElementSibling;\n\n            while (previous) {\n                if (previous.matches(selector)) {\n                    return [previous]\n                }\n\n                previous = previous.previousElementSibling\n            }\n\n            return []\n        },\n\n        next: function(element, selector) {\n            let next = element.nextElementSibling;\n\n            while (next) {\n                if (next.matches(selector)) {\n                    return [next]\n                }\n\n                next = next.nextElementSibling\n            }\n\n            return []\n        },\n\n        focusableChildren: function(element) {\n            const focusables = [\n                'a',\n                'button',\n                'input',\n                'textarea',\n                'select',\n                'details',\n                '[tabindex]',\n                '[contenteditable=\"true\"]'\n            ].map(selector => `${selector}:not([tabindex^=\"-\"])`).join(', ');\n\n            return this.find(focusables, element).filter(el => !isDisabled(el) && isVisible(el))\n        }\n    }\n});\n","jquery/bootstrap/dom/data.js":"/**\n * --------------------------------------------------------------------------\n * Bootstrap (v5.1.3): dom/data.js\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)\n * --------------------------------------------------------------------------\n */\n\ndefine([], function() {\n    'use strict';\n\n    /**\n     * ------------------------------------------------------------------------\n     * Constants\n     * ------------------------------------------------------------------------\n     */\n\n    const elementMap = new Map();\n\n    return {\n        set: function (element, key, instance) {\n            if (!elementMap.has(element)) {\n                elementMap.set(element, new Map())\n            }\n\n            const instanceMap = elementMap.get(element);\n\n            // make it clear we only want one instance per element\n            // can be removed later when multiple key/instances are fine to be used\n            if (!instanceMap.has(key) && instanceMap.size !== 0) {\n                // eslint-disable-next-line no-console\n                console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(instanceMap.keys())[0]}.`)\n                return\n            }\n\n            instanceMap.set(key, instance)\n        },\n\n        get: function (element, key) {\n            if (elementMap.has(element)) {\n                return elementMap.get(element).get(key) || null\n            }\n\n            return null\n        },\n\n        remove: function (element, key) {\n            if (!elementMap.has(element)) {\n                return\n            }\n\n            const instanceMap = elementMap.get(element);\n\n            instanceMap.delete(key)\n\n            // free up element references if there are no instances left for an element\n            if (instanceMap.size === 0) {\n                elementMap.delete(element)\n            }\n        }\n    }\n});\n"}
}});
