require.config({"config": {
        "jsbuild":{"underscore.js":"(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define('underscore', factory) :\n            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, (function () {\n                var current = global._;\n                var exports = global._ = factory();\n                exports.noConflict = function () { global._ = current; return exports; };\n            }()));\n}(this, (function () {\n    //     Underscore.js 1.13.6\n    //     https://underscorejs.org\n    //     (c) 2009-2022 Jeremy Ashkenas, Julian Gonggrijp, and DocumentCloud and Investigative Reporters & Editors\n    //     Underscore may be freely distributed under the MIT license.\n\n    // Current version.\n    var VERSION = '1.13.6';\n\n    // Establish the root object, `window` (`self`) in the browser, `global`\n    // on the server, or `this` in some virtual machines. We use `self`\n    // instead of `window` for `WebWorker` support.\n    var root = (typeof self == 'object' && self.self === self && self) ||\n        (typeof global == 'object' && global.global === global && global) ||\n        Function('return this')() ||\n        {};\n\n    // Save bytes in the minified (but not gzipped) version:\n    var ArrayProto = Array.prototype, ObjProto = Object.prototype;\n    var SymbolProto = typeof Symbol !== 'undefined' ? Symbol.prototype : null;\n\n    // Create quick reference variables for speed access to core prototypes.\n    var push = ArrayProto.push,\n        slice = ArrayProto.slice,\n        toString = ObjProto.toString,\n        hasOwnProperty = ObjProto.hasOwnProperty;\n\n    // Modern feature detection.\n    var supportsArrayBuffer = typeof ArrayBuffer !== 'undefined',\n        supportsDataView = typeof DataView !== 'undefined';\n\n    // All **ECMAScript 5+** native function implementations that we hope to use\n    // are declared here.\n    var nativeIsArray = Array.isArray,\n        nativeKeys = Object.keys,\n        nativeCreate = Object.create,\n        nativeIsView = supportsArrayBuffer && ArrayBuffer.isView;\n\n    // Create references to these builtin functions because we override them.\n    var _isNaN = isNaN,\n        _isFinite = isFinite;\n\n    // Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.\n    var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');\n    var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',\n        'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];\n\n    // The largest integer that can be represented exactly.\n    var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;\n\n    // Some functions take a variable number of arguments, or a few expected\n    // arguments at the beginning and then a variable number of values to operate\n    // on. This helper accumulates all remaining arguments past the function\u2019s\n    // argument length (or an explicit `startIndex`), into an array that becomes\n    // the last argument. Similar to ES6\u2019s \"rest parameter\".\n    function restArguments(func, startIndex) {\n        startIndex = startIndex == null ? func.length - 1 : +startIndex;\n        return function() {\n            var length = Math.max(arguments.length - startIndex, 0),\n                rest = Array(length),\n                index = 0;\n            for (; index < length; index++) {\n                rest[index] = arguments[index + startIndex];\n            }\n            switch (startIndex) {\n                case 0: return func.call(this, rest);\n                case 1: return func.call(this, arguments[0], rest);\n                case 2: return func.call(this, arguments[0], arguments[1], rest);\n            }\n            var args = Array(startIndex + 1);\n            for (index = 0; index < startIndex; index++) {\n                args[index] = arguments[index];\n            }\n            args[startIndex] = rest;\n            return func.apply(this, args);\n        };\n    }\n\n    // Is a given variable an object?\n    function isObject(obj) {\n        var type = typeof obj;\n        return type === 'function' || (type === 'object' && !!obj);\n    }\n\n    // Is a given value equal to null?\n    function isNull(obj) {\n        return obj === null;\n    }\n\n    // Is a given variable undefined?\n    function isUndefined(obj) {\n        return obj === void 0;\n    }\n\n    // Is a given value a boolean?\n    function isBoolean(obj) {\n        return obj === true || obj === false || toString.call(obj) === '[object Boolean]';\n    }\n\n    // Is a given value a DOM element?\n    function isElement(obj) {\n        return !!(obj && obj.nodeType === 1);\n    }\n\n    // Internal function for creating a `toString`-based type tester.\n    function tagTester(name) {\n        var tag = '[object ' + name + ']';\n        return function(obj) {\n            return toString.call(obj) === tag;\n        };\n    }\n\n    var isString = tagTester('String');\n\n    var isNumber = tagTester('Number');\n\n    var isDate = tagTester('Date');\n\n    var isRegExp = tagTester('RegExp');\n\n    var isError = tagTester('Error');\n\n    var isSymbol = tagTester('Symbol');\n\n    var isArrayBuffer = tagTester('ArrayBuffer');\n\n    var isFunction = tagTester('Function');\n\n    // Optimize `isFunction` if appropriate. Work around some `typeof` bugs in old\n    // v8, IE 11 (#1621), Safari 8 (#1929), and PhantomJS (#2236).\n    var nodelist = root.document && root.document.childNodes;\n    if (typeof /./ != 'function' && typeof Int8Array != 'object' && typeof nodelist != 'function') {\n        isFunction = function(obj) {\n            return typeof obj == 'function' || false;\n        };\n    }\n\n    var isFunction$1 = isFunction;\n\n    var hasObjectTag = tagTester('Object');\n\n    // In IE 10 - Edge 13, `DataView` has string tag `'[object Object]'`.\n    // In IE 11, the most common among them, this problem also applies to\n    // `Map`, `WeakMap` and `Set`.\n    var hasStringTagBug = (\n            supportsDataView && hasObjectTag(new DataView(new ArrayBuffer(8)))\n        ),\n        isIE11 = (typeof Map !== 'undefined' && hasObjectTag(new Map));\n\n    var isDataView = tagTester('DataView');\n\n    // In IE 10 - Edge 13, we need a different heuristic\n    // to determine whether an object is a `DataView`.\n    function ie10IsDataView(obj) {\n        return obj != null && isFunction$1(obj.getInt8) && isArrayBuffer(obj.buffer);\n    }\n\n    var isDataView$1 = (hasStringTagBug ? ie10IsDataView : isDataView);\n\n    // Is a given value an array?\n    // Delegates to ECMA5's native `Array.isArray`.\n    var isArray = nativeIsArray || tagTester('Array');\n\n    // Internal function to check whether `key` is an own property name of `obj`.\n    function has$1(obj, key) {\n        return obj != null && hasOwnProperty.call(obj, key);\n    }\n\n    var isArguments = tagTester('Arguments');\n\n    // Define a fallback version of the method in browsers (ahem, IE < 9), where\n    // there isn't any inspectable \"Arguments\" type.\n    (function() {\n        if (!isArguments(arguments)) {\n            isArguments = function(obj) {\n                return has$1(obj, 'callee');\n            };\n        }\n    }());\n\n    var isArguments$1 = isArguments;\n\n    // Is a given object a finite number?\n    function isFinite$1(obj) {\n        return !isSymbol(obj) && _isFinite(obj) && !isNaN(parseFloat(obj));\n    }\n\n    // Is the given value `NaN`?\n    function isNaN$1(obj) {\n        return isNumber(obj) && _isNaN(obj);\n    }\n\n    // Predicate-generating function. Often useful outside of Underscore.\n    function constant(value) {\n        return function() {\n            return value;\n        };\n    }\n\n    // Common internal logic for `isArrayLike` and `isBufferLike`.\n    function createSizePropertyCheck(getSizeProperty) {\n        return function(collection) {\n            var sizeProperty = getSizeProperty(collection);\n            return typeof sizeProperty == 'number' && sizeProperty >= 0 && sizeProperty <= MAX_ARRAY_INDEX;\n        }\n    }\n\n    // Internal helper to generate a function to obtain property `key` from `obj`.\n    function shallowProperty(key) {\n        return function(obj) {\n            return obj == null ? void 0 : obj[key];\n        };\n    }\n\n    // Internal helper to obtain the `byteLength` property of an object.\n    var getByteLength = shallowProperty('byteLength');\n\n    // Internal helper to determine whether we should spend extensive checks against\n    // `ArrayBuffer` et al.\n    var isBufferLike = createSizePropertyCheck(getByteLength);\n\n    // Is a given value a typed array?\n    var typedArrayPattern = /\\[object ((I|Ui)nt(8|16|32)|Float(32|64)|Uint8Clamped|Big(I|Ui)nt64)Array\\]/;\n    function isTypedArray(obj) {\n        // `ArrayBuffer.isView` is the most future-proof, so use it when available.\n        // Otherwise, fall back on the above regular expression.\n        return nativeIsView ? (nativeIsView(obj) && !isDataView$1(obj)) :\n            isBufferLike(obj) && typedArrayPattern.test(toString.call(obj));\n    }\n\n    var isTypedArray$1 = supportsArrayBuffer ? isTypedArray : constant(false);\n\n    // Internal helper to obtain the `length` property of an object.\n    var getLength = shallowProperty('length');\n\n    // Internal helper to create a simple lookup structure.\n    // `collectNonEnumProps` used to depend on `_.contains`, but this led to\n    // circular imports. `emulatedSet` is a one-off solution that only works for\n    // arrays of strings.\n    function emulatedSet(keys) {\n        var hash = {};\n        for (var l = keys.length, i = 0; i < l; ++i) hash[keys[i]] = true;\n        return {\n            contains: function(key) { return hash[key] === true; },\n            push: function(key) {\n                hash[key] = true;\n                return keys.push(key);\n            }\n        };\n    }\n\n    // Internal helper. Checks `keys` for the presence of keys in IE < 9 that won't\n    // be iterated by `for key in ...` and thus missed. Extends `keys` in place if\n    // needed.\n    function collectNonEnumProps(obj, keys) {\n        keys = emulatedSet(keys);\n        var nonEnumIdx = nonEnumerableProps.length;\n        var constructor = obj.constructor;\n        var proto = (isFunction$1(constructor) && constructor.prototype) || ObjProto;\n\n        // Constructor is a special case.\n        var prop = 'constructor';\n        if (has$1(obj, prop) && !keys.contains(prop)) keys.push(prop);\n\n        while (nonEnumIdx--) {\n            prop = nonEnumerableProps[nonEnumIdx];\n            if (prop in obj && obj[prop] !== proto[prop] && !keys.contains(prop)) {\n                keys.push(prop);\n            }\n        }\n    }\n\n    // Retrieve the names of an object's own properties.\n    // Delegates to **ECMAScript 5**'s native `Object.keys`.\n    function keys(obj) {\n        if (!isObject(obj)) return [];\n        if (nativeKeys) return nativeKeys(obj);\n        var keys = [];\n        for (var key in obj) if (has$1(obj, key)) keys.push(key);\n        // Ahem, IE < 9.\n        if (hasEnumBug) collectNonEnumProps(obj, keys);\n        return keys;\n    }\n\n    // Is a given array, string, or object empty?\n    // An \"empty\" object has no enumerable own-properties.\n    function isEmpty(obj) {\n        if (obj == null) return true;\n        // Skip the more expensive `toString`-based type checks if `obj` has no\n        // `.length`.\n        var length = getLength(obj);\n        if (typeof length == 'number' && (\n            isArray(obj) || isString(obj) || isArguments$1(obj)\n        )) return length === 0;\n        return getLength(keys(obj)) === 0;\n    }\n\n    // Returns whether an object has a given set of `key:value` pairs.\n    function isMatch(object, attrs) {\n        var _keys = keys(attrs), length = _keys.length;\n        if (object == null) return !length;\n        var obj = Object(object);\n        for (var i = 0; i < length; i++) {\n            var key = _keys[i];\n            if (attrs[key] !== obj[key] || !(key in obj)) return false;\n        }\n        return true;\n    }\n\n    // If Underscore is called as a function, it returns a wrapped object that can\n    // be used OO-style. This wrapper holds altered versions of all functions added\n    // through `_.mixin`. Wrapped objects may be chained.\n    function _$1(obj) {\n        if (obj instanceof _$1) return obj;\n        if (!(this instanceof _$1)) return new _$1(obj);\n        this._wrapped = obj;\n    }\n\n    _$1.VERSION = VERSION;\n\n    // Extracts the result from a wrapped and chained object.\n    _$1.prototype.value = function() {\n        return this._wrapped;\n    };\n\n    // Provide unwrapping proxies for some methods used in engine operations\n    // such as arithmetic and JSON stringification.\n    _$1.prototype.valueOf = _$1.prototype.toJSON = _$1.prototype.value;\n\n    _$1.prototype.toString = function() {\n        return String(this._wrapped);\n    };\n\n    // Internal function to wrap or shallow-copy an ArrayBuffer,\n    // typed array or DataView to a new view, reusing the buffer.\n    function toBufferView(bufferSource) {\n        return new Uint8Array(\n            bufferSource.buffer || bufferSource,\n            bufferSource.byteOffset || 0,\n            getByteLength(bufferSource)\n        );\n    }\n\n    // We use this string twice, so give it a name for minification.\n    var tagDataView = '[object DataView]';\n\n    // Internal recursive comparison function for `_.isEqual`.\n    function eq(a, b, aStack, bStack) {\n        // Identical objects are equal. `0 === -0`, but they aren't identical.\n        // See the [Harmony `egal` proposal](https://wiki.ecmascript.org/doku.php?id=harmony:egal).\n        if (a === b) return a !== 0 || 1 / a === 1 / b;\n        // `null` or `undefined` only equal to itself (strict comparison).\n        if (a == null || b == null) return false;\n        // `NaN`s are equivalent, but non-reflexive.\n        if (a !== a) return b !== b;\n        // Exhaust primitive checks\n        var type = typeof a;\n        if (type !== 'function' && type !== 'object' && typeof b != 'object') return false;\n        return deepEq(a, b, aStack, bStack);\n    }\n\n    // Internal recursive comparison function for `_.isEqual`.\n    function deepEq(a, b, aStack, bStack) {\n        // Unwrap any wrapped objects.\n        if (a instanceof _$1) a = a._wrapped;\n        if (b instanceof _$1) b = b._wrapped;\n        // Compare `[[Class]]` names.\n        var className = toString.call(a);\n        if (className !== toString.call(b)) return false;\n        // Work around a bug in IE 10 - Edge 13.\n        if (hasStringTagBug && className == '[object Object]' && isDataView$1(a)) {\n            if (!isDataView$1(b)) return false;\n            className = tagDataView;\n        }\n        switch (className) {\n            // These types are compared by value.\n            case '[object RegExp]':\n            // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')\n            case '[object String]':\n                // Primitives and their corresponding object wrappers are equivalent; thus, `\"5\"` is\n                // equivalent to `new String(\"5\")`.\n                return '' + a === '' + b;\n            case '[object Number]':\n                // `NaN`s are equivalent, but non-reflexive.\n                // Object(NaN) is equivalent to NaN.\n                if (+a !== +a) return +b !== +b;\n                // An `egal` comparison is performed for other numeric values.\n                return +a === 0 ? 1 / +a === 1 / b : +a === +b;\n            case '[object Date]':\n            case '[object Boolean]':\n                // Coerce dates and booleans to numeric primitive values. Dates are compared by their\n                // millisecond representations. Note that invalid dates with millisecond representations\n                // of `NaN` are not equivalent.\n                return +a === +b;\n            case '[object Symbol]':\n                return SymbolProto.valueOf.call(a) === SymbolProto.valueOf.call(b);\n            case '[object ArrayBuffer]':\n            case tagDataView:\n                // Coerce to typed array so we can fall through.\n                return deepEq(toBufferView(a), toBufferView(b), aStack, bStack);\n        }\n\n        var areArrays = className === '[object Array]';\n        if (!areArrays && isTypedArray$1(a)) {\n            var byteLength = getByteLength(a);\n            if (byteLength !== getByteLength(b)) return false;\n            if (a.buffer === b.buffer && a.byteOffset === b.byteOffset) return true;\n            areArrays = true;\n        }\n        if (!areArrays) {\n            if (typeof a != 'object' || typeof b != 'object') return false;\n\n            // Objects with different constructors are not equivalent, but `Object`s or `Array`s\n            // from different frames are.\n            var aCtor = a.constructor, bCtor = b.constructor;\n            if (aCtor !== bCtor && !(isFunction$1(aCtor) && aCtor instanceof aCtor &&\n                    isFunction$1(bCtor) && bCtor instanceof bCtor)\n                && ('constructor' in a && 'constructor' in b)) {\n                return false;\n            }\n        }\n        // Assume equality for cyclic structures. The algorithm for detecting cyclic\n        // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.\n\n        // Initializing stack of traversed objects.\n        // It's done here since we only need them for objects and arrays comparison.\n        aStack = aStack || [];\n        bStack = bStack || [];\n        var length = aStack.length;\n        while (length--) {\n            // Linear search. Performance is inversely proportional to the number of\n            // unique nested structures.\n            if (aStack[length] === a) return bStack[length] === b;\n        }\n\n        // Add the first object to the stack of traversed objects.\n        aStack.push(a);\n        bStack.push(b);\n\n        // Recursively compare objects and arrays.\n        if (areArrays) {\n            // Compare array lengths to determine if a deep comparison is necessary.\n            length = a.length;\n            if (length !== b.length) return false;\n            // Deep compare the contents, ignoring non-numeric properties.\n            while (length--) {\n                if (!eq(a[length], b[length], aStack, bStack)) return false;\n            }\n        } else {\n            // Deep compare objects.\n            var _keys = keys(a), key;\n            length = _keys.length;\n            // Ensure that both objects contain the same number of properties before comparing deep equality.\n            if (keys(b).length !== length) return false;\n            while (length--) {\n                // Deep compare each member\n                key = _keys[length];\n                if (!(has$1(b, key) && eq(a[key], b[key], aStack, bStack))) return false;\n            }\n        }\n        // Remove the first object from the stack of traversed objects.\n        aStack.pop();\n        bStack.pop();\n        return true;\n    }\n\n    // Perform a deep comparison to check if two objects are equal.\n    function isEqual(a, b) {\n        return eq(a, b);\n    }\n\n    // Retrieve all the enumerable property names of an object.\n    function allKeys(obj) {\n        if (!isObject(obj)) return [];\n        var keys = [];\n        for (var key in obj) keys.push(key);\n        // Ahem, IE < 9.\n        if (hasEnumBug) collectNonEnumProps(obj, keys);\n        return keys;\n    }\n\n    // Since the regular `Object.prototype.toString` type tests don't work for\n    // some types in IE 11, we use a fingerprinting heuristic instead, based\n    // on the methods. It's not great, but it's the best we got.\n    // The fingerprint method lists are defined below.\n    function ie11fingerprint(methods) {\n        var length = getLength(methods);\n        return function(obj) {\n            if (obj == null) return false;\n            // `Map`, `WeakMap` and `Set` have no enumerable keys.\n            var keys = allKeys(obj);\n            if (getLength(keys)) return false;\n            for (var i = 0; i < length; i++) {\n                if (!isFunction$1(obj[methods[i]])) return false;\n            }\n            // If we are testing against `WeakMap`, we need to ensure that\n            // `obj` doesn't have a `forEach` method in order to distinguish\n            // it from a regular `Map`.\n            return methods !== weakMapMethods || !isFunction$1(obj[forEachName]);\n        };\n    }\n\n    // In the interest of compact minification, we write\n    // each string in the fingerprints only once.\n    var forEachName = 'forEach',\n        hasName = 'has',\n        commonInit = ['clear', 'delete'],\n        mapTail = ['get', hasName, 'set'];\n\n    // `Map`, `WeakMap` and `Set` each have slightly different\n    // combinations of the above sublists.\n    var mapMethods = commonInit.concat(forEachName, mapTail),\n        weakMapMethods = commonInit.concat(mapTail),\n        setMethods = ['add'].concat(commonInit, forEachName, hasName);\n\n    var isMap = isIE11 ? ie11fingerprint(mapMethods) : tagTester('Map');\n\n    var isWeakMap = isIE11 ? ie11fingerprint(weakMapMethods) : tagTester('WeakMap');\n\n    var isSet = isIE11 ? ie11fingerprint(setMethods) : tagTester('Set');\n\n    var isWeakSet = tagTester('WeakSet');\n\n    // Retrieve the values of an object's properties.\n    function values(obj) {\n        var _keys = keys(obj);\n        var length = _keys.length;\n        var values = Array(length);\n        for (var i = 0; i < length; i++) {\n            values[i] = obj[_keys[i]];\n        }\n        return values;\n    }\n\n    // Convert an object into a list of `[key, value]` pairs.\n    // The opposite of `_.object` with one argument.\n    function pairs(obj) {\n        var _keys = keys(obj);\n        var length = _keys.length;\n        var pairs = Array(length);\n        for (var i = 0; i < length; i++) {\n            pairs[i] = [_keys[i], obj[_keys[i]]];\n        }\n        return pairs;\n    }\n\n    // Invert the keys and values of an object. The values must be serializable.\n    function invert(obj) {\n        var result = {};\n        var _keys = keys(obj);\n        for (var i = 0, length = _keys.length; i < length; i++) {\n            result[obj[_keys[i]]] = _keys[i];\n        }\n        return result;\n    }\n\n    // Return a sorted list of the function names available on the object.\n    function functions(obj) {\n        var names = [];\n        for (var key in obj) {\n            if (isFunction$1(obj[key])) names.push(key);\n        }\n        return names.sort();\n    }\n\n    // An internal function for creating assigner functions.\n    function createAssigner(keysFunc, defaults) {\n        return function(obj) {\n            var length = arguments.length;\n            if (defaults) obj = Object(obj);\n            if (length < 2 || obj == null) return obj;\n            for (var index = 1; index < length; index++) {\n                var source = arguments[index],\n                    keys = keysFunc(source),\n                    l = keys.length;\n                for (var i = 0; i < l; i++) {\n                    var key = keys[i];\n                    if (!defaults || obj[key] === void 0) obj[key] = source[key];\n                }\n            }\n            return obj;\n        };\n    }\n\n    // Extend a given object with all the properties in passed-in object(s).\n    var extend = createAssigner(allKeys);\n\n    // Assigns a given object with all the own properties in the passed-in\n    // object(s).\n    // (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)\n    var extendOwn = createAssigner(keys);\n\n    // Fill in a given object with default properties.\n    var defaults = createAssigner(allKeys, true);\n\n    // Create a naked function reference for surrogate-prototype-swapping.\n    function ctor() {\n        return function(){};\n    }\n\n    // An internal function for creating a new object that inherits from another.\n    function baseCreate(prototype) {\n        if (!isObject(prototype)) return {};\n        if (nativeCreate) return nativeCreate(prototype);\n        var Ctor = ctor();\n        Ctor.prototype = prototype;\n        var result = new Ctor;\n        Ctor.prototype = null;\n        return result;\n    }\n\n    // Creates an object that inherits from the given prototype object.\n    // If additional properties are provided then they will be added to the\n    // created object.\n    function create(prototype, props) {\n        var result = baseCreate(prototype);\n        if (props) extendOwn(result, props);\n        return result;\n    }\n\n    // Create a (shallow-cloned) duplicate of an object.\n    function clone(obj) {\n        if (!isObject(obj)) return obj;\n        return isArray(obj) ? obj.slice() : extend({}, obj);\n    }\n\n    // Invokes `interceptor` with the `obj` and then returns `obj`.\n    // The primary purpose of this method is to \"tap into\" a method chain, in\n    // order to perform operations on intermediate results within the chain.\n    function tap(obj, interceptor) {\n        interceptor(obj);\n        return obj;\n    }\n\n    // Normalize a (deep) property `path` to array.\n    // Like `_.iteratee`, this function can be customized.\n    function toPath$1(path) {\n        return isArray(path) ? path : [path];\n    }\n    _$1.toPath = toPath$1;\n\n    // Internal wrapper for `_.toPath` to enable minification.\n    // Similar to `cb` for `_.iteratee`.\n    function toPath(path) {\n        return _$1.toPath(path);\n    }\n\n    // Internal function to obtain a nested property in `obj` along `path`.\n    function deepGet(obj, path) {\n        var length = path.length;\n        for (var i = 0; i < length; i++) {\n            if (obj == null) return void 0;\n            obj = obj[path[i]];\n        }\n        return length ? obj : void 0;\n    }\n\n    // Get the value of the (deep) property on `path` from `object`.\n    // If any property in `path` does not exist or if the value is\n    // `undefined`, return `defaultValue` instead.\n    // The `path` is normalized through `_.toPath`.\n    function get(object, path, defaultValue) {\n        var value = deepGet(object, toPath(path));\n        return isUndefined(value) ? defaultValue : value;\n    }\n\n    // Shortcut function for checking if an object has a given property directly on\n    // itself (in other words, not on a prototype). Unlike the internal `has`\n    // function, this public version can also traverse nested properties.\n    function has(obj, path) {\n        path = toPath(path);\n        var length = path.length;\n        for (var i = 0; i < length; i++) {\n            var key = path[i];\n            if (!has$1(obj, key)) return false;\n            obj = obj[key];\n        }\n        return !!length;\n    }\n\n    // Keep the identity function around for default iteratees.\n    function identity(value) {\n        return value;\n    }\n\n    // Returns a predicate for checking whether an object has a given set of\n    // `key:value` pairs.\n    function matcher(attrs) {\n        attrs = extendOwn({}, attrs);\n        return function(obj) {\n            return isMatch(obj, attrs);\n        };\n    }\n\n    // Creates a function that, when passed an object, will traverse that object\u2019s\n    // properties down the given `path`, specified as an array of keys or indices.\n    function property(path) {\n        path = toPath(path);\n        return function(obj) {\n            return deepGet(obj, path);\n        };\n    }\n\n    // Internal function that returns an efficient (for current engines) version\n    // of the passed-in callback, to be repeatedly applied in other Underscore\n    // functions.\n    function optimizeCb(func, context, argCount) {\n        if (context === void 0) return func;\n        switch (argCount == null ? 3 : argCount) {\n            case 1: return function(value) {\n                return func.call(context, value);\n            };\n            // The 2-argument case is omitted because we\u2019re not using it.\n            case 3: return function(value, index, collection) {\n                return func.call(context, value, index, collection);\n            };\n            case 4: return function(accumulator, value, index, collection) {\n                return func.call(context, accumulator, value, index, collection);\n            };\n        }\n        return function() {\n            return func.apply(context, arguments);\n        };\n    }\n\n    // An internal function to generate callbacks that can be applied to each\n    // element in a collection, returning the desired result \u2014 either `_.identity`,\n    // an arbitrary callback, a property matcher, or a property accessor.\n    function baseIteratee(value, context, argCount) {\n        if (value == null) return identity;\n        if (isFunction$1(value)) return optimizeCb(value, context, argCount);\n        if (isObject(value) && !isArray(value)) return matcher(value);\n        return property(value);\n    }\n\n    // External wrapper for our callback generator. Users may customize\n    // `_.iteratee` if they want additional predicate/iteratee shorthand styles.\n    // This abstraction hides the internal-only `argCount` argument.\n    function iteratee(value, context) {\n        return baseIteratee(value, context, Infinity);\n    }\n    _$1.iteratee = iteratee;\n\n    // The function we call internally to generate a callback. It invokes\n    // `_.iteratee` if overridden, otherwise `baseIteratee`.\n    function cb(value, context, argCount) {\n        if (_$1.iteratee !== iteratee) return _$1.iteratee(value, context);\n        return baseIteratee(value, context, argCount);\n    }\n\n    // Returns the results of applying the `iteratee` to each element of `obj`.\n    // In contrast to `_.map` it returns an object.\n    function mapObject(obj, iteratee, context) {\n        iteratee = cb(iteratee, context);\n        var _keys = keys(obj),\n            length = _keys.length,\n            results = {};\n        for (var index = 0; index < length; index++) {\n            var currentKey = _keys[index];\n            results[currentKey] = iteratee(obj[currentKey], currentKey, obj);\n        }\n        return results;\n    }\n\n    // Predicate-generating function. Often useful outside of Underscore.\n    function noop(){}\n\n    // Generates a function for a given object that returns a given property.\n    function propertyOf(obj) {\n        if (obj == null) return noop;\n        return function(path) {\n            return get(obj, path);\n        };\n    }\n\n    // Run a function **n** times.\n    function times(n, iteratee, context) {\n        var accum = Array(Math.max(0, n));\n        iteratee = optimizeCb(iteratee, context, 1);\n        for (var i = 0; i < n; i++) accum[i] = iteratee(i);\n        return accum;\n    }\n\n    // Return a random integer between `min` and `max` (inclusive).\n    function random(min, max) {\n        if (max == null) {\n            max = min;\n            min = 0;\n        }\n        return min + Math.floor(Math.random() * (max - min + 1));\n    }\n\n    // A (possibly faster) way to get the current timestamp as an integer.\n    var now = Date.now || function() {\n        return new Date().getTime();\n    };\n\n    // Internal helper to generate functions for escaping and unescaping strings\n    // to/from HTML interpolation.\n    function createEscaper(map) {\n        var escaper = function(match) {\n            return map[match];\n        };\n        // Regexes for identifying a key that needs to be escaped.\n        var source = '(?:' + keys(map).join('|') + ')';\n        var testRegexp = RegExp(source);\n        var replaceRegexp = RegExp(source, 'g');\n        return function(string) {\n            string = string == null ? '' : '' + string;\n            return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;\n        };\n    }\n\n    // Internal list of HTML entities for escaping.\n    var escapeMap = {\n        '&': '&amp;',\n        '<': '&lt;',\n        '>': '&gt;',\n        '\"': '&quot;',\n        \"'\": '&#x27;',\n        '`': '&#x60;'\n    };\n\n    // Function for escaping strings to HTML interpolation.\n    var _escape = createEscaper(escapeMap);\n\n    // Internal list of HTML entities for unescaping.\n    var unescapeMap = invert(escapeMap);\n\n    // Function for unescaping strings from HTML interpolation.\n    var _unescape = createEscaper(unescapeMap);\n\n    // By default, Underscore uses ERB-style template delimiters. Change the\n    // following template settings to use alternative delimiters.\n    var templateSettings = _$1.templateSettings = {\n        evaluate: /<%([\\s\\S]+?)%>/g,\n        interpolate: /<%=([\\s\\S]+?)%>/g,\n        escape: /<%-([\\s\\S]+?)%>/g\n    };\n\n    // When customizing `_.templateSettings`, if you don't want to define an\n    // interpolation, evaluation or escaping regex, we need one that is\n    // guaranteed not to match.\n    var noMatch = /(.)^/;\n\n    // Certain characters need to be escaped so that they can be put into a\n    // string literal.\n    var escapes = {\n        \"'\": \"'\",\n        '\\\\': '\\\\',\n        '\\r': 'r',\n        '\\n': 'n',\n        '\\u2028': 'u2028',\n        '\\u2029': 'u2029'\n    };\n\n    var escapeRegExp = /\\\\|'|\\r|\\n|\\u2028|\\u2029/g;\n\n    function escapeChar(match) {\n        return '\\\\' + escapes[match];\n    }\n\n    // In order to prevent third-party code injection through\n    // `_.templateSettings.variable`, we test it against the following regular\n    // expression. It is intentionally a bit more liberal than just matching valid\n    // identifiers, but still prevents possible loopholes through defaults or\n    // destructuring assignment.\n    var bareIdentifier = /^\\s*(\\w|\\$)+\\s*$/;\n\n    // JavaScript micro-templating, similar to John Resig's implementation.\n    // Underscore templating handles arbitrary delimiters, preserves whitespace,\n    // and correctly escapes quotes within interpolated code.\n    // NB: `oldSettings` only exists for backwards compatibility.\n    function template(text, settings, oldSettings) {\n        if (!settings && oldSettings) settings = oldSettings;\n        settings = defaults({}, settings, _$1.templateSettings);\n\n        // Combine delimiters into one regular expression via alternation.\n        var matcher = RegExp([\n            (settings.escape || noMatch).source,\n            (settings.interpolate || noMatch).source,\n            (settings.evaluate || noMatch).source\n        ].join('|') + '|$', 'g');\n\n        // Compile the template source, escaping string literals appropriately.\n        var index = 0;\n        var source = \"__p+='\";\n        text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {\n            source += text.slice(index, offset).replace(escapeRegExp, escapeChar);\n            index = offset + match.length;\n\n            if (escape) {\n                source += \"'+\\n((__t=(\" + escape + \"))==null?'':_.escape(__t))+\\n'\";\n            } else if (interpolate) {\n                source += \"'+\\n((__t=(\" + interpolate + \"))==null?'':__t)+\\n'\";\n            } else if (evaluate) {\n                source += \"';\\n\" + evaluate + \"\\n__p+='\";\n            }\n\n            // Adobe VMs need the match returned to produce the correct offset.\n            return match;\n        });\n        source += \"';\\n\";\n\n        var argument = settings.variable;\n        if (argument) {\n            // Insure against third-party code injection. (CVE-2021-23358)\n            if (!bareIdentifier.test(argument)) throw new Error(\n                'variable is not a bare identifier: ' + argument\n            );\n        } else {\n            // If a variable is not specified, place data values in local scope.\n            source = 'with(obj||{}){\\n' + source + '}\\n';\n            argument = 'obj';\n        }\n\n        source = \"var __t,__p='',__j=Array.prototype.join,\" +\n            \"print=function(){__p+=__j.call(arguments,'');};\\n\" +\n            source + 'return __p;\\n';\n\n        var render;\n        try {\n            render = new Function(argument, '_', source);\n        } catch (e) {\n            e.source = source;\n            throw e;\n        }\n\n        var template = function(data) {\n            return render.call(this, data, _$1);\n        };\n\n        // Provide the compiled source as a convenience for precompilation.\n        template.source = 'function(' + argument + '){\\n' + source + '}';\n\n        return template;\n    }\n\n    // Traverses the children of `obj` along `path`. If a child is a function, it\n    // is invoked with its parent as context. Returns the value of the final\n    // child, or `fallback` if any child is undefined.\n    function result(obj, path, fallback) {\n        path = toPath(path);\n        var length = path.length;\n        if (!length) {\n            return isFunction$1(fallback) ? fallback.call(obj) : fallback;\n        }\n        for (var i = 0; i < length; i++) {\n            var prop = obj == null ? void 0 : obj[path[i]];\n            if (prop === void 0) {\n                prop = fallback;\n                i = length; // Ensure we don't continue iterating.\n            }\n            obj = isFunction$1(prop) ? prop.call(obj) : prop;\n        }\n        return obj;\n    }\n\n    // Generate a unique integer id (unique within the entire client session).\n    // Useful for temporary DOM ids.\n    var idCounter = 0;\n    function uniqueId(prefix) {\n        var id = ++idCounter + '';\n        return prefix ? prefix + id : id;\n    }\n\n    // Start chaining a wrapped Underscore object.\n    function chain(obj) {\n        var instance = _$1(obj);\n        instance._chain = true;\n        return instance;\n    }\n\n    // Internal function to execute `sourceFunc` bound to `context` with optional\n    // `args`. Determines whether to execute a function as a constructor or as a\n    // normal function.\n    function executeBound(sourceFunc, boundFunc, context, callingContext, args) {\n        if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);\n        var self = baseCreate(sourceFunc.prototype);\n        var result = sourceFunc.apply(self, args);\n        if (isObject(result)) return result;\n        return self;\n    }\n\n    // Partially apply a function by creating a version that has had some of its\n    // arguments pre-filled, without changing its dynamic `this` context. `_` acts\n    // as a placeholder by default, allowing any combination of arguments to be\n    // pre-filled. Set `_.partial.placeholder` for a custom placeholder argument.\n    var partial = restArguments(function(func, boundArgs) {\n        var placeholder = partial.placeholder;\n        var bound = function() {\n            var position = 0, length = boundArgs.length;\n            var args = Array(length);\n            for (var i = 0; i < length; i++) {\n                args[i] = boundArgs[i] === placeholder ? arguments[position++] : boundArgs[i];\n            }\n            while (position < arguments.length) args.push(arguments[position++]);\n            return executeBound(func, bound, this, this, args);\n        };\n        return bound;\n    });\n\n    partial.placeholder = _$1;\n\n    // Create a function bound to a given object (assigning `this`, and arguments,\n    // optionally).\n    var bind = restArguments(function(func, context, args) {\n        if (!isFunction$1(func)) throw new TypeError('Bind must be called on a function');\n        var bound = restArguments(function(callArgs) {\n            return executeBound(func, bound, context, this, args.concat(callArgs));\n        });\n        return bound;\n    });\n\n    // Internal helper for collection methods to determine whether a collection\n    // should be iterated as an array or as an object.\n    // Related: https://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength\n    // Avoids a very nasty iOS 8 JIT bug on ARM-64. #2094\n    var isArrayLike = createSizePropertyCheck(getLength);\n\n    // Internal implementation of a recursive `flatten` function.\n    function flatten$1(input, depth, strict, output) {\n        output = output || [];\n        if (!depth && depth !== 0) {\n            depth = Infinity;\n        } else if (depth <= 0) {\n            return output.concat(input);\n        }\n        var idx = output.length;\n        for (var i = 0, length = getLength(input); i < length; i++) {\n            var value = input[i];\n            if (isArrayLike(value) && (isArray(value) || isArguments$1(value))) {\n                // Flatten current level of array or arguments object.\n                if (depth > 1) {\n                    flatten$1(value, depth - 1, strict, output);\n                    idx = output.length;\n                } else {\n                    var j = 0, len = value.length;\n                    while (j < len) output[idx++] = value[j++];\n                }\n            } else if (!strict) {\n                output[idx++] = value;\n            }\n        }\n        return output;\n    }\n\n    // Bind a number of an object's methods to that object. Remaining arguments\n    // are the method names to be bound. Useful for ensuring that all callbacks\n    // defined on an object belong to it.\n    var bindAll = restArguments(function(obj, keys) {\n        keys = flatten$1(keys, false, false);\n        var index = keys.length;\n        if (index < 1) throw new Error('bindAll must be passed function names');\n        while (index--) {\n            var key = keys[index];\n            obj[key] = bind(obj[key], obj);\n        }\n        return obj;\n    });\n\n    // Memoize an expensive function by storing its results.\n    function memoize(func, hasher) {\n        var memoize = function(key) {\n            var cache = memoize.cache;\n            var address = '' + (hasher ? hasher.apply(this, arguments) : key);\n            if (!has$1(cache, address)) cache[address] = func.apply(this, arguments);\n            return cache[address];\n        };\n        memoize.cache = {};\n        return memoize;\n    }\n\n    // Delays a function for the given number of milliseconds, and then calls\n    // it with the arguments supplied.\n    var delay = restArguments(function(func, wait, args) {\n        return setTimeout(function() {\n            return func.apply(null, args);\n        }, wait);\n    });\n\n    // Defers a function, scheduling it to run after the current call stack has\n    // cleared.\n    var defer = partial(delay, _$1, 1);\n\n    // Returns a function, that, when invoked, will only be triggered at most once\n    // during a given window of time. Normally, the throttled function will run\n    // as much as it can, without ever going more than once per `wait` duration;\n    // but if you'd like to disable the execution on the leading edge, pass\n    // `{leading: false}`. To disable execution on the trailing edge, ditto.\n    function throttle(func, wait, options) {\n        var timeout, context, args, result;\n        var previous = 0;\n        if (!options) options = {};\n\n        var later = function() {\n            previous = options.leading === false ? 0 : now();\n            timeout = null;\n            result = func.apply(context, args);\n            if (!timeout) context = args = null;\n        };\n\n        var throttled = function() {\n            var _now = now();\n            if (!previous && options.leading === false) previous = _now;\n            var remaining = wait - (_now - previous);\n            context = this;\n            args = arguments;\n            if (remaining <= 0 || remaining > wait) {\n                if (timeout) {\n                    clearTimeout(timeout);\n                    timeout = null;\n                }\n                previous = _now;\n                result = func.apply(context, args);\n                if (!timeout) context = args = null;\n            } else if (!timeout && options.trailing !== false) {\n                timeout = setTimeout(later, remaining);\n            }\n            return result;\n        };\n\n        throttled.cancel = function() {\n            clearTimeout(timeout);\n            previous = 0;\n            timeout = context = args = null;\n        };\n\n        return throttled;\n    }\n\n    // When a sequence of calls of the returned function ends, the argument\n    // function is triggered. The end of a sequence is defined by the `wait`\n    // parameter. If `immediate` is passed, the argument function will be\n    // triggered at the beginning of the sequence instead of at the end.\n    function debounce(func, wait, immediate) {\n        var timeout, previous, args, result, context;\n\n        var later = function() {\n            var passed = now() - previous;\n            if (wait > passed) {\n                timeout = setTimeout(later, wait - passed);\n            } else {\n                timeout = null;\n                if (!immediate) result = func.apply(context, args);\n                // This check is needed because `func` can recursively invoke `debounced`.\n                if (!timeout) args = context = null;\n            }\n        };\n\n        var debounced = restArguments(function(_args) {\n            context = this;\n            args = _args;\n            previous = now();\n            if (!timeout) {\n                timeout = setTimeout(later, wait);\n                if (immediate) result = func.apply(context, args);\n            }\n            return result;\n        });\n\n        debounced.cancel = function() {\n            clearTimeout(timeout);\n            timeout = args = context = null;\n        };\n\n        return debounced;\n    }\n\n    // Returns the first function passed as an argument to the second,\n    // allowing you to adjust arguments, run code before and after, and\n    // conditionally execute the original function.\n    function wrap(func, wrapper) {\n        return partial(wrapper, func);\n    }\n\n    // Returns a negated version of the passed-in predicate.\n    function negate(predicate) {\n        return function() {\n            return !predicate.apply(this, arguments);\n        };\n    }\n\n    // Returns a function that is the composition of a list of functions, each\n    // consuming the return value of the function that follows.\n    function compose() {\n        var args = arguments;\n        var start = args.length - 1;\n        return function() {\n            var i = start;\n            var result = args[start].apply(this, arguments);\n            while (i--) result = args[i].call(this, result);\n            return result;\n        };\n    }\n\n    // Returns a function that will only be executed on and after the Nth call.\n    function after(times, func) {\n        return function() {\n            if (--times < 1) {\n                return func.apply(this, arguments);\n            }\n        };\n    }\n\n    // Returns a function that will only be executed up to (but not including) the\n    // Nth call.\n    function before(times, func) {\n        var memo;\n        return function() {\n            if (--times > 0) {\n                memo = func.apply(this, arguments);\n            }\n            if (times <= 1) func = null;\n            return memo;\n        };\n    }\n\n    // Returns a function that will be executed at most one time, no matter how\n    // often you call it. Useful for lazy initialization.\n    var once = partial(before, 2);\n\n    // Returns the first key on an object that passes a truth test.\n    function findKey(obj, predicate, context) {\n        predicate = cb(predicate, context);\n        var _keys = keys(obj), key;\n        for (var i = 0, length = _keys.length; i < length; i++) {\n            key = _keys[i];\n            if (predicate(obj[key], key, obj)) return key;\n        }\n    }\n\n    // Internal function to generate `_.findIndex` and `_.findLastIndex`.\n    function createPredicateIndexFinder(dir) {\n        return function(array, predicate, context) {\n            predicate = cb(predicate, context);\n            var length = getLength(array);\n            var index = dir > 0 ? 0 : length - 1;\n            for (; index >= 0 && index < length; index += dir) {\n                if (predicate(array[index], index, array)) return index;\n            }\n            return -1;\n        };\n    }\n\n    // Returns the first index on an array-like that passes a truth test.\n    var findIndex = createPredicateIndexFinder(1);\n\n    // Returns the last index on an array-like that passes a truth test.\n    var findLastIndex = createPredicateIndexFinder(-1);\n\n    // Use a comparator function to figure out the smallest index at which\n    // an object should be inserted so as to maintain order. Uses binary search.\n    function sortedIndex(array, obj, iteratee, context) {\n        iteratee = cb(iteratee, context, 1);\n        var value = iteratee(obj);\n        var low = 0, high = getLength(array);\n        while (low < high) {\n            var mid = Math.floor((low + high) / 2);\n            if (iteratee(array[mid]) < value) low = mid + 1; else high = mid;\n        }\n        return low;\n    }\n\n    // Internal function to generate the `_.indexOf` and `_.lastIndexOf` functions.\n    function createIndexFinder(dir, predicateFind, sortedIndex) {\n        return function(array, item, idx) {\n            var i = 0, length = getLength(array);\n            if (typeof idx == 'number') {\n                if (dir > 0) {\n                    i = idx >= 0 ? idx : Math.max(idx + length, i);\n                } else {\n                    length = idx >= 0 ? Math.min(idx + 1, length) : idx + length + 1;\n                }\n            } else if (sortedIndex && idx && length) {\n                idx = sortedIndex(array, item);\n                return array[idx] === item ? idx : -1;\n            }\n            if (item !== item) {\n                idx = predicateFind(slice.call(array, i, length), isNaN$1);\n                return idx >= 0 ? idx + i : -1;\n            }\n            for (idx = dir > 0 ? i : length - 1; idx >= 0 && idx < length; idx += dir) {\n                if (array[idx] === item) return idx;\n            }\n            return -1;\n        };\n    }\n\n    // Return the position of the first occurrence of an item in an array,\n    // or -1 if the item is not included in the array.\n    // If the array is large and already in sort order, pass `true`\n    // for **isSorted** to use binary search.\n    var indexOf = createIndexFinder(1, findIndex, sortedIndex);\n\n    // Return the position of the last occurrence of an item in an array,\n    // or -1 if the item is not included in the array.\n    var lastIndexOf = createIndexFinder(-1, findLastIndex);\n\n    // Return the first value which passes a truth test.\n    function find(obj, predicate, context) {\n        var keyFinder = isArrayLike(obj) ? findIndex : findKey;\n        var key = keyFinder(obj, predicate, context);\n        if (key !== void 0 && key !== -1) return obj[key];\n    }\n\n    // Convenience version of a common use case of `_.find`: getting the first\n    // object containing specific `key:value` pairs.\n    function findWhere(obj, attrs) {\n        return find(obj, matcher(attrs));\n    }\n\n    // The cornerstone for collection functions, an `each`\n    // implementation, aka `forEach`.\n    // Handles raw objects in addition to array-likes. Treats all\n    // sparse array-likes as if they were dense.\n    function each(obj, iteratee, context) {\n        iteratee = optimizeCb(iteratee, context);\n        var i, length;\n        if (isArrayLike(obj)) {\n            for (i = 0, length = obj.length; i < length; i++) {\n                iteratee(obj[i], i, obj);\n            }\n        } else {\n            var _keys = keys(obj);\n            for (i = 0, length = _keys.length; i < length; i++) {\n                iteratee(obj[_keys[i]], _keys[i], obj);\n            }\n        }\n        return obj;\n    }\n\n    // Return the results of applying the iteratee to each element.\n    function map(obj, iteratee, context) {\n        iteratee = cb(iteratee, context);\n        var _keys = !isArrayLike(obj) && keys(obj),\n            length = (_keys || obj).length,\n            results = Array(length);\n        for (var index = 0; index < length; index++) {\n            var currentKey = _keys ? _keys[index] : index;\n            results[index] = iteratee(obj[currentKey], currentKey, obj);\n        }\n        return results;\n    }\n\n    // Internal helper to create a reducing function, iterating left or right.\n    function createReduce(dir) {\n        // Wrap code that reassigns argument variables in a separate function than\n        // the one that accesses `arguments.length` to avoid a perf hit. (#1991)\n        var reducer = function(obj, iteratee, memo, initial) {\n            var _keys = !isArrayLike(obj) && keys(obj),\n                length = (_keys || obj).length,\n                index = dir > 0 ? 0 : length - 1;\n            if (!initial) {\n                memo = obj[_keys ? _keys[index] : index];\n                index += dir;\n            }\n            for (; index >= 0 && index < length; index += dir) {\n                var currentKey = _keys ? _keys[index] : index;\n                memo = iteratee(memo, obj[currentKey], currentKey, obj);\n            }\n            return memo;\n        };\n\n        return function(obj, iteratee, memo, context) {\n            var initial = arguments.length >= 3;\n            return reducer(obj, optimizeCb(iteratee, context, 4), memo, initial);\n        };\n    }\n\n    // **Reduce** builds up a single result from a list of values, aka `inject`,\n    // or `foldl`.\n    var reduce = createReduce(1);\n\n    // The right-associative version of reduce, also known as `foldr`.\n    var reduceRight = createReduce(-1);\n\n    // Return all the elements that pass a truth test.\n    function filter(obj, predicate, context) {\n        var results = [];\n        predicate = cb(predicate, context);\n        each(obj, function(value, index, list) {\n            if (predicate(value, index, list)) results.push(value);\n        });\n        return results;\n    }\n\n    // Return all the elements for which a truth test fails.\n    function reject(obj, predicate, context) {\n        return filter(obj, negate(cb(predicate)), context);\n    }\n\n    // Determine whether all of the elements pass a truth test.\n    function every(obj, predicate, context) {\n        predicate = cb(predicate, context);\n        var _keys = !isArrayLike(obj) && keys(obj),\n            length = (_keys || obj).length;\n        for (var index = 0; index < length; index++) {\n            var currentKey = _keys ? _keys[index] : index;\n            if (!predicate(obj[currentKey], currentKey, obj)) return false;\n        }\n        return true;\n    }\n\n    // Determine if at least one element in the object passes a truth test.\n    function some(obj, predicate, context) {\n        predicate = cb(predicate, context);\n        var _keys = !isArrayLike(obj) && keys(obj),\n            length = (_keys || obj).length;\n        for (var index = 0; index < length; index++) {\n            var currentKey = _keys ? _keys[index] : index;\n            if (predicate(obj[currentKey], currentKey, obj)) return true;\n        }\n        return false;\n    }\n\n    // Determine if the array or object contains a given item (using `===`).\n    function contains(obj, item, fromIndex, guard) {\n        if (!isArrayLike(obj)) obj = values(obj);\n        if (typeof fromIndex != 'number' || guard) fromIndex = 0;\n        return indexOf(obj, item, fromIndex) >= 0;\n    }\n\n    // Invoke a method (with arguments) on every item in a collection.\n    var invoke = restArguments(function(obj, path, args) {\n        var contextPath, func;\n        if (isFunction$1(path)) {\n            func = path;\n        } else {\n            path = toPath(path);\n            contextPath = path.slice(0, -1);\n            path = path[path.length - 1];\n        }\n        return map(obj, function(context) {\n            var method = func;\n            if (!method) {\n                if (contextPath && contextPath.length) {\n                    context = deepGet(context, contextPath);\n                }\n                if (context == null) return void 0;\n                method = context[path];\n            }\n            return method == null ? method : method.apply(context, args);\n        });\n    });\n\n    // Convenience version of a common use case of `_.map`: fetching a property.\n    function pluck(obj, key) {\n        return map(obj, property(key));\n    }\n\n    // Convenience version of a common use case of `_.filter`: selecting only\n    // objects containing specific `key:value` pairs.\n    function where(obj, attrs) {\n        return filter(obj, matcher(attrs));\n    }\n\n    // Return the maximum element (or element-based computation).\n    function max(obj, iteratee, context) {\n        var result = -Infinity, lastComputed = -Infinity,\n            value, computed;\n        if (iteratee == null || (typeof iteratee == 'number' && typeof obj[0] != 'object' && obj != null)) {\n            obj = isArrayLike(obj) ? obj : values(obj);\n            for (var i = 0, length = obj.length; i < length; i++) {\n                value = obj[i];\n                if (value != null && value > result) {\n                    result = value;\n                }\n            }\n        } else {\n            iteratee = cb(iteratee, context);\n            each(obj, function(v, index, list) {\n                computed = iteratee(v, index, list);\n                if (computed > lastComputed || (computed === -Infinity && result === -Infinity)) {\n                    result = v;\n                    lastComputed = computed;\n                }\n            });\n        }\n        return result;\n    }\n\n    // Return the minimum element (or element-based computation).\n    function min(obj, iteratee, context) {\n        var result = Infinity, lastComputed = Infinity,\n            value, computed;\n        if (iteratee == null || (typeof iteratee == 'number' && typeof obj[0] != 'object' && obj != null)) {\n            obj = isArrayLike(obj) ? obj : values(obj);\n            for (var i = 0, length = obj.length; i < length; i++) {\n                value = obj[i];\n                if (value != null && value < result) {\n                    result = value;\n                }\n            }\n        } else {\n            iteratee = cb(iteratee, context);\n            each(obj, function(v, index, list) {\n                computed = iteratee(v, index, list);\n                if (computed < lastComputed || (computed === Infinity && result === Infinity)) {\n                    result = v;\n                    lastComputed = computed;\n                }\n            });\n        }\n        return result;\n    }\n\n    // Safely create a real, live array from anything iterable.\n    var reStrSymbol = /[^\\ud800-\\udfff]|[\\ud800-\\udbff][\\udc00-\\udfff]|[\\ud800-\\udfff]/g;\n    function toArray(obj) {\n        if (!obj) return [];\n        if (isArray(obj)) return slice.call(obj);\n        if (isString(obj)) {\n            // Keep surrogate pair characters together.\n            return obj.match(reStrSymbol);\n        }\n        if (isArrayLike(obj)) return map(obj, identity);\n        return values(obj);\n    }\n\n    // Sample **n** random values from a collection using the modern version of the\n    // [Fisher-Yates shuffle](https://en.wikipedia.org/wiki/Fisher\u2013Yates_shuffle).\n    // If **n** is not specified, returns a single random element.\n    // The internal `guard` argument allows it to work with `_.map`.\n    function sample(obj, n, guard) {\n        if (n == null || guard) {\n            if (!isArrayLike(obj)) obj = values(obj);\n            return obj[random(obj.length - 1)];\n        }\n        var sample = toArray(obj);\n        var length = getLength(sample);\n        n = Math.max(Math.min(n, length), 0);\n        var last = length - 1;\n        for (var index = 0; index < n; index++) {\n            var rand = random(index, last);\n            var temp = sample[index];\n            sample[index] = sample[rand];\n            sample[rand] = temp;\n        }\n        return sample.slice(0, n);\n    }\n\n    // Shuffle a collection.\n    function shuffle(obj) {\n        return sample(obj, Infinity);\n    }\n\n    // Sort the object's values by a criterion produced by an iteratee.\n    function sortBy(obj, iteratee, context) {\n        var index = 0;\n        iteratee = cb(iteratee, context);\n        return pluck(map(obj, function(value, key, list) {\n            return {\n                value: value,\n                index: index++,\n                criteria: iteratee(value, key, list)\n            };\n        }).sort(function(left, right) {\n            var a = left.criteria;\n            var b = right.criteria;\n            if (a !== b) {\n                if (a > b || a === void 0) return 1;\n                if (a < b || b === void 0) return -1;\n            }\n            return left.index - right.index;\n        }), 'value');\n    }\n\n    // An internal function used for aggregate \"group by\" operations.\n    function group(behavior, partition) {\n        return function(obj, iteratee, context) {\n            var result = partition ? [[], []] : {};\n            iteratee = cb(iteratee, context);\n            each(obj, function(value, index) {\n                var key = iteratee(value, index, obj);\n                behavior(result, value, key);\n            });\n            return result;\n        };\n    }\n\n    // Groups the object's values by a criterion. Pass either a string attribute\n    // to group by, or a function that returns the criterion.\n    var groupBy = group(function(result, value, key) {\n        if (has$1(result, key)) result[key].push(value); else result[key] = [value];\n    });\n\n    // Indexes the object's values by a criterion, similar to `_.groupBy`, but for\n    // when you know that your index values will be unique.\n    var indexBy = group(function(result, value, key) {\n        result[key] = value;\n    });\n\n    // Counts instances of an object that group by a certain criterion. Pass\n    // either a string attribute to count by, or a function that returns the\n    // criterion.\n    var countBy = group(function(result, value, key) {\n        if (has$1(result, key)) result[key]++; else result[key] = 1;\n    });\n\n    // Split a collection into two arrays: one whose elements all pass the given\n    // truth test, and one whose elements all do not pass the truth test.\n    var partition = group(function(result, value, pass) {\n        result[pass ? 0 : 1].push(value);\n    }, true);\n\n    // Return the number of elements in a collection.\n    function size(obj) {\n        if (obj == null) return 0;\n        return isArrayLike(obj) ? obj.length : keys(obj).length;\n    }\n\n    // Internal `_.pick` helper function to determine whether `key` is an enumerable\n    // property name of `obj`.\n    function keyInObj(value, key, obj) {\n        return key in obj;\n    }\n\n    // Return a copy of the object only containing the allowed properties.\n    var pick = restArguments(function(obj, keys) {\n        var result = {}, iteratee = keys[0];\n        if (obj == null) return result;\n        if (isFunction$1(iteratee)) {\n            if (keys.length > 1) iteratee = optimizeCb(iteratee, keys[1]);\n            keys = allKeys(obj);\n        } else {\n            iteratee = keyInObj;\n            keys = flatten$1(keys, false, false);\n            obj = Object(obj);\n        }\n        for (var i = 0, length = keys.length; i < length; i++) {\n            var key = keys[i];\n            var value = obj[key];\n            if (iteratee(value, key, obj)) result[key] = value;\n        }\n        return result;\n    });\n\n    // Return a copy of the object without the disallowed properties.\n    var omit = restArguments(function(obj, keys) {\n        var iteratee = keys[0], context;\n        if (isFunction$1(iteratee)) {\n            iteratee = negate(iteratee);\n            if (keys.length > 1) context = keys[1];\n        } else {\n            keys = map(flatten$1(keys, false, false), String);\n            iteratee = function(value, key) {\n                return !contains(keys, key);\n            };\n        }\n        return pick(obj, iteratee, context);\n    });\n\n    // Returns everything but the last entry of the array. Especially useful on\n    // the arguments object. Passing **n** will return all the values in\n    // the array, excluding the last N.\n    function initial(array, n, guard) {\n        return slice.call(array, 0, Math.max(0, array.length - (n == null || guard ? 1 : n)));\n    }\n\n    // Get the first element of an array. Passing **n** will return the first N\n    // values in the array. The **guard** check allows it to work with `_.map`.\n    function first(array, n, guard) {\n        if (array == null || array.length < 1) return n == null || guard ? void 0 : [];\n        if (n == null || guard) return array[0];\n        return initial(array, array.length - n);\n    }\n\n    // Returns everything but the first entry of the `array`. Especially useful on\n    // the `arguments` object. Passing an **n** will return the rest N values in the\n    // `array`.\n    function rest(array, n, guard) {\n        return slice.call(array, n == null || guard ? 1 : n);\n    }\n\n    // Get the last element of an array. Passing **n** will return the last N\n    // values in the array.\n    function last(array, n, guard) {\n        if (array == null || array.length < 1) return n == null || guard ? void 0 : [];\n        if (n == null || guard) return array[array.length - 1];\n        return rest(array, Math.max(0, array.length - n));\n    }\n\n    // Trim out all falsy values from an array.\n    function compact(array) {\n        return filter(array, Boolean);\n    }\n\n    // Flatten out an array, either recursively (by default), or up to `depth`.\n    // Passing `true` or `false` as `depth` means `1` or `Infinity`, respectively.\n    function flatten(array, depth) {\n        return flatten$1(array, depth, false);\n    }\n\n    // Take the difference between one array and a number of other arrays.\n    // Only the elements present in just the first array will remain.\n    var difference = restArguments(function(array, rest) {\n        rest = flatten$1(rest, true, true);\n        return filter(array, function(value){\n            return !contains(rest, value);\n        });\n    });\n\n    // Return a version of the array that does not contain the specified value(s).\n    var without = restArguments(function(array, otherArrays) {\n        return difference(array, otherArrays);\n    });\n\n    // Produce a duplicate-free version of the array. If the array has already\n    // been sorted, you have the option of using a faster algorithm.\n    // The faster algorithm will not work with an iteratee if the iteratee\n    // is not a one-to-one function, so providing an iteratee will disable\n    // the faster algorithm.\n    function uniq(array, isSorted, iteratee, context) {\n        if (!isBoolean(isSorted)) {\n            context = iteratee;\n            iteratee = isSorted;\n            isSorted = false;\n        }\n        if (iteratee != null) iteratee = cb(iteratee, context);\n        var result = [];\n        var seen = [];\n        for (var i = 0, length = getLength(array); i < length; i++) {\n            var value = array[i],\n                computed = iteratee ? iteratee(value, i, array) : value;\n            if (isSorted && !iteratee) {\n                if (!i || seen !== computed) result.push(value);\n                seen = computed;\n            } else if (iteratee) {\n                if (!contains(seen, computed)) {\n                    seen.push(computed);\n                    result.push(value);\n                }\n            } else if (!contains(result, value)) {\n                result.push(value);\n            }\n        }\n        return result;\n    }\n\n    // Produce an array that contains the union: each distinct element from all of\n    // the passed-in arrays.\n    var union = restArguments(function(arrays) {\n        return uniq(flatten$1(arrays, true, true));\n    });\n\n    // Produce an array that contains every item shared between all the\n    // passed-in arrays.\n    function intersection(array) {\n        var result = [];\n        var argsLength = arguments.length;\n        for (var i = 0, length = getLength(array); i < length; i++) {\n            var item = array[i];\n            if (contains(result, item)) continue;\n            var j;\n            for (j = 1; j < argsLength; j++) {\n                if (!contains(arguments[j], item)) break;\n            }\n            if (j === argsLength) result.push(item);\n        }\n        return result;\n    }\n\n    // Complement of zip. Unzip accepts an array of arrays and groups\n    // each array's elements on shared indices.\n    function unzip(array) {\n        var length = (array && max(array, getLength).length) || 0;\n        var result = Array(length);\n\n        for (var index = 0; index < length; index++) {\n            result[index] = pluck(array, index);\n        }\n        return result;\n    }\n\n    // Zip together multiple lists into a single array -- elements that share\n    // an index go together.\n    var zip = restArguments(unzip);\n\n    // Converts lists into objects. Pass either a single array of `[key, value]`\n    // pairs, or two parallel arrays of the same length -- one of keys, and one of\n    // the corresponding values. Passing by pairs is the reverse of `_.pairs`.\n    function object(list, values) {\n        var result = {};\n        for (var i = 0, length = getLength(list); i < length; i++) {\n            if (values) {\n                result[list[i]] = values[i];\n            } else {\n                result[list[i][0]] = list[i][1];\n            }\n        }\n        return result;\n    }\n\n    // Generate an integer Array containing an arithmetic progression. A port of\n    // the native Python `range()` function. See\n    // [the Python documentation](https://docs.python.org/library/functions.html#range).\n    function range(start, stop, step) {\n        if (stop == null) {\n            stop = start || 0;\n            start = 0;\n        }\n        if (!step) {\n            step = stop < start ? -1 : 1;\n        }\n\n        var length = Math.max(Math.ceil((stop - start) / step), 0);\n        var range = Array(length);\n\n        for (var idx = 0; idx < length; idx++, start += step) {\n            range[idx] = start;\n        }\n\n        return range;\n    }\n\n    // Chunk a single array into multiple arrays, each containing `count` or fewer\n    // items.\n    function chunk(array, count) {\n        if (count == null || count < 1) return [];\n        var result = [];\n        var i = 0, length = array.length;\n        while (i < length) {\n            result.push(slice.call(array, i, i += count));\n        }\n        return result;\n    }\n\n    // Helper function to continue chaining intermediate results.\n    function chainResult(instance, obj) {\n        return instance._chain ? _$1(obj).chain() : obj;\n    }\n\n    // Add your own custom functions to the Underscore object.\n    function mixin(obj) {\n        each(functions(obj), function(name) {\n            var func = _$1[name] = obj[name];\n            _$1.prototype[name] = function() {\n                var args = [this._wrapped];\n                push.apply(args, arguments);\n                return chainResult(this, func.apply(_$1, args));\n            };\n        });\n        return _$1;\n    }\n\n    // Add all mutator `Array` functions to the wrapper.\n    each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {\n        var method = ArrayProto[name];\n        _$1.prototype[name] = function() {\n            var obj = this._wrapped;\n            if (obj != null) {\n                method.apply(obj, arguments);\n                if ((name === 'shift' || name === 'splice') && obj.length === 0) {\n                    delete obj[0];\n                }\n            }\n            return chainResult(this, obj);\n        };\n    });\n\n    // Add all accessor `Array` functions to the wrapper.\n    each(['concat', 'join', 'slice'], function(name) {\n        var method = ArrayProto[name];\n        _$1.prototype[name] = function() {\n            var obj = this._wrapped;\n            if (obj != null) obj = method.apply(obj, arguments);\n            return chainResult(this, obj);\n        };\n    });\n\n    // Named Exports\n\n    var allExports = {\n        __proto__: null,\n        VERSION: VERSION,\n        restArguments: restArguments,\n        isObject: isObject,\n        isNull: isNull,\n        isUndefined: isUndefined,\n        isBoolean: isBoolean,\n        isElement: isElement,\n        isString: isString,\n        isNumber: isNumber,\n        isDate: isDate,\n        isRegExp: isRegExp,\n        isError: isError,\n        isSymbol: isSymbol,\n        isArrayBuffer: isArrayBuffer,\n        isDataView: isDataView$1,\n        isArray: isArray,\n        isFunction: isFunction$1,\n        isArguments: isArguments$1,\n        isFinite: isFinite$1,\n        isNaN: isNaN$1,\n        isTypedArray: isTypedArray$1,\n        isEmpty: isEmpty,\n        isMatch: isMatch,\n        isEqual: isEqual,\n        isMap: isMap,\n        isWeakMap: isWeakMap,\n        isSet: isSet,\n        isWeakSet: isWeakSet,\n        keys: keys,\n        allKeys: allKeys,\n        values: values,\n        pairs: pairs,\n        invert: invert,\n        functions: functions,\n        methods: functions,\n        extend: extend,\n        extendOwn: extendOwn,\n        assign: extendOwn,\n        defaults: defaults,\n        create: create,\n        clone: clone,\n        tap: tap,\n        get: get,\n        has: has,\n        mapObject: mapObject,\n        identity: identity,\n        constant: constant,\n        noop: noop,\n        toPath: toPath$1,\n        property: property,\n        propertyOf: propertyOf,\n        matcher: matcher,\n        matches: matcher,\n        times: times,\n        random: random,\n        now: now,\n        escape: _escape,\n        unescape: _unescape,\n        templateSettings: templateSettings,\n        template: template,\n        result: result,\n        uniqueId: uniqueId,\n        chain: chain,\n        iteratee: iteratee,\n        partial: partial,\n        bind: bind,\n        bindAll: bindAll,\n        memoize: memoize,\n        delay: delay,\n        defer: defer,\n        throttle: throttle,\n        debounce: debounce,\n        wrap: wrap,\n        negate: negate,\n        compose: compose,\n        after: after,\n        before: before,\n        once: once,\n        findKey: findKey,\n        findIndex: findIndex,\n        findLastIndex: findLastIndex,\n        sortedIndex: sortedIndex,\n        indexOf: indexOf,\n        lastIndexOf: lastIndexOf,\n        find: find,\n        detect: find,\n        findWhere: findWhere,\n        each: each,\n        forEach: each,\n        map: map,\n        collect: map,\n        reduce: reduce,\n        foldl: reduce,\n        inject: reduce,\n        reduceRight: reduceRight,\n        foldr: reduceRight,\n        filter: filter,\n        select: filter,\n        reject: reject,\n        every: every,\n        all: every,\n        some: some,\n        any: some,\n        contains: contains,\n        includes: contains,\n        include: contains,\n        invoke: invoke,\n        pluck: pluck,\n        where: where,\n        max: max,\n        min: min,\n        shuffle: shuffle,\n        sample: sample,\n        sortBy: sortBy,\n        groupBy: groupBy,\n        indexBy: indexBy,\n        countBy: countBy,\n        partition: partition,\n        toArray: toArray,\n        size: size,\n        pick: pick,\n        omit: omit,\n        first: first,\n        head: first,\n        take: first,\n        initial: initial,\n        last: last,\n        rest: rest,\n        tail: rest,\n        drop: rest,\n        compact: compact,\n        flatten: flatten,\n        without: without,\n        uniq: uniq,\n        unique: uniq,\n        union: union,\n        intersection: intersection,\n        difference: difference,\n        unzip: unzip,\n        transpose: unzip,\n        zip: zip,\n        object: object,\n        range: range,\n        chunk: chunk,\n        mixin: mixin,\n        'default': _$1\n    };\n\n    // Default Export\n\n    // Add all of the Underscore functions to the wrapper object.\n    var _ = mixin(allExports);\n    // Legacy Node.js API.\n    _._ = _;\n\n    return _;\n\n})));\n//# sourceMappingURL=underscore-umd.js.map\n","moment.js":"//! moment.js\n//! version : 2.29.4\n//! authors : Tim Wood, Iskren Chernev, Moment.js contributors\n//! license : MIT\n//! momentjs.com\n/* jscs:disable */\n/* eslint-disable */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):e.moment=t()}(this,function(){\"use strict\";var H;function f(){return H.apply(null,arguments)}function a(e){return e instanceof Array||\"[object Array]\"===Object.prototype.toString.call(e)}function F(e){return null!=e&&\"[object Object]\"===Object.prototype.toString.call(e)}function c(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function L(e){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(e).length;for(var t in e)if(c(e,t))return;return 1}function o(e){return void 0===e}function u(e){return\"number\"==typeof e||\"[object Number]\"===Object.prototype.toString.call(e)}function V(e){return e instanceof Date||\"[object Date]\"===Object.prototype.toString.call(e)}function G(e,t){for(var n=[],s=e.length,i=0;i<s;++i)n.push(t(e[i],i));return n}function E(e,t){for(var n in t)c(t,n)&&(e[n]=t[n]);return c(t,\"toString\")&&(e.toString=t.toString),c(t,\"valueOf\")&&(e.valueOf=t.valueOf),e}function l(e,t,n,s){return Pt(e,t,n,s,!0).utc()}function m(e){return null==e._pf&&(e._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidEra:null,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],era:null,meridiem:null,rfc2822:!1,weekdayMismatch:!1}),e._pf}function A(e){if(null==e._isValid){var t=m(e),n=j.call(t.parsedDateParts,function(e){return null!=e}),n=!isNaN(e._d.getTime())&&t.overflow<0&&!t.empty&&!t.invalidEra&&!t.invalidMonth&&!t.invalidWeekday&&!t.weekdayMismatch&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&n);if(e._strict&&(n=n&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour),null!=Object.isFrozen&&Object.isFrozen(e))return n;e._isValid=n}return e._isValid}function I(e){var t=l(NaN);return null!=e?E(m(t),e):m(t).userInvalidated=!0,t}var j=Array.prototype.some||function(e){for(var t=Object(this),n=t.length>>>0,s=0;s<n;s++)if(s in t&&e.call(this,t[s],s,t))return!0;return!1},Z=f.momentProperties=[],z=!1;function $(e,t){var n,s,i,r=Z.length;if(o(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),o(t._i)||(e._i=t._i),o(t._f)||(e._f=t._f),o(t._l)||(e._l=t._l),o(t._strict)||(e._strict=t._strict),o(t._tzm)||(e._tzm=t._tzm),o(t._isUTC)||(e._isUTC=t._isUTC),o(t._offset)||(e._offset=t._offset),o(t._pf)||(e._pf=m(t)),o(t._locale)||(e._locale=t._locale),0<r)for(n=0;n<r;n++)o(i=t[s=Z[n]])||(e[s]=i);return e}function q(e){$(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===z&&(z=!0,f.updateOffset(this),z=!1)}function h(e){return e instanceof q||null!=e&&null!=e._isAMomentObject}function B(e){!1===f.suppressDeprecationWarnings&&\"undefined\"!=typeof console&&console.warn&&console.warn(\"Deprecation warning: \"+e)}function e(r,a){var o=!0;return E(function(){if(null!=f.deprecationHandler&&f.deprecationHandler(null,r),o){for(var e,t,n=[],s=arguments.length,i=0;i<s;i++){if(e=\"\",\"object\"==typeof arguments[i]){for(t in e+=\"\\n[\"+i+\"] \",arguments[0])c(arguments[0],t)&&(e+=t+\": \"+arguments[0][t]+\", \");e=e.slice(0,-2)}else e=arguments[i];n.push(e)}B(r+\"\\nArguments: \"+Array.prototype.slice.call(n).join(\"\")+\"\\n\"+(new Error).stack),o=!1}return a.apply(this,arguments)},a)}var J={};function Q(e,t){null!=f.deprecationHandler&&f.deprecationHandler(e,t),J[e]||(B(t),J[e]=!0)}function d(e){return\"undefined\"!=typeof Function&&e instanceof Function||\"[object Function]\"===Object.prototype.toString.call(e)}function X(e,t){var n,s=E({},e);for(n in t)c(t,n)&&(F(e[n])&&F(t[n])?(s[n]={},E(s[n],e[n]),E(s[n],t[n])):null!=t[n]?s[n]=t[n]:delete s[n]);for(n in e)c(e,n)&&!c(t,n)&&F(e[n])&&(s[n]=E({},s[n]));return s}function K(e){null!=e&&this.set(e)}f.suppressDeprecationWarnings=!1,f.deprecationHandler=null;var ee=Object.keys||function(e){var t,n=[];for(t in e)c(e,t)&&n.push(t);return n};function r(e,t,n){var s=\"\"+Math.abs(e);return(0<=e?n?\"+\":\"\":\"-\")+Math.pow(10,Math.max(0,t-s.length)).toString().substr(1)+s}var te=/(\\[[^\\[]*\\])|(\\\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,ne=/(\\[[^\\[]*\\])|(\\\\)?(LTS|LT|LL?L?L?|l{1,4})/g,se={},ie={};function s(e,t,n,s){var i=\"string\"==typeof s?function(){return this[s]()}:s;e&&(ie[e]=i),t&&(ie[t[0]]=function(){return r(i.apply(this,arguments),t[1],t[2])}),n&&(ie[n]=function(){return this.localeData().ordinal(i.apply(this,arguments),e)})}function re(e,t){return e.isValid()?(t=ae(t,e.localeData()),se[t]=se[t]||function(s){for(var e,i=s.match(te),t=0,r=i.length;t<r;t++)ie[i[t]]?i[t]=ie[i[t]]:i[t]=(e=i[t]).match(/\\[[\\s\\S]/)?e.replace(/^\\[|\\]$/g,\"\"):e.replace(/\\\\/g,\"\");return function(e){for(var t=\"\",n=0;n<r;n++)t+=d(i[n])?i[n].call(e,s):i[n];return t}}(t),se[t](e)):e.localeData().invalidDate()}function ae(e,t){var n=5;function s(e){return t.longDateFormat(e)||e}for(ne.lastIndex=0;0<=n&&ne.test(e);)e=e.replace(ne,s),ne.lastIndex=0,--n;return e}var oe={};function t(e,t){var n=e.toLowerCase();oe[n]=oe[n+\"s\"]=oe[t]=e}function _(e){return\"string\"==typeof e?oe[e]||oe[e.toLowerCase()]:void 0}function ue(e){var t,n,s={};for(n in e)c(e,n)&&(t=_(n))&&(s[t]=e[n]);return s}var le={};function n(e,t){le[e]=t}function he(e){return e%4==0&&e%100!=0||e%400==0}function y(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function g(e){var e=+e,t=0;return t=0!=e&&isFinite(e)?y(e):t}function de(t,n){return function(e){return null!=e?(fe(this,t,e),f.updateOffset(this,n),this):ce(this,t)}}function ce(e,t){return e.isValid()?e._d[\"get\"+(e._isUTC?\"UTC\":\"\")+t]():NaN}function fe(e,t,n){e.isValid()&&!isNaN(n)&&(\"FullYear\"===t&&he(e.year())&&1===e.month()&&29===e.date()?(n=g(n),e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+t](n,e.month(),We(n,e.month()))):e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+t](n))}var i=/\\d/,w=/\\d\\d/,me=/\\d{3}/,_e=/\\d{4}/,ye=/[+-]?\\d{6}/,p=/\\d\\d?/,ge=/\\d\\d\\d\\d?/,we=/\\d\\d\\d\\d\\d\\d?/,pe=/\\d{1,3}/,ke=/\\d{1,4}/,ve=/[+-]?\\d{1,6}/,Me=/\\d+/,De=/[+-]?\\d+/,Se=/Z|[+-]\\d\\d:?\\d\\d/gi,Ye=/Z|[+-]\\d\\d(?::?\\d\\d)?/gi,k=/[0-9]{0,256}['a-z\\u00A0-\\u05FF\\u0700-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFF07\\uFF10-\\uFFEF]{1,256}|[\\u0600-\\u06FF\\/]{1,256}(\\s*?[\\u0600-\\u06FF]{1,256}){1,2}/i;function v(e,n,s){be[e]=d(n)?n:function(e,t){return e&&s?s:n}}function Oe(e,t){return c(be,e)?be[e](t._strict,t._locale):new RegExp(M(e.replace(\"\\\\\",\"\").replace(/\\\\(\\[)|\\\\(\\])|\\[([^\\]\\[]*)\\]|\\\\(.)/g,function(e,t,n,s,i){return t||n||s||i})))}function M(e){return e.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g,\"\\\\$&\")}var be={},xe={};function D(e,n){var t,s,i=n;for(\"string\"==typeof e&&(e=[e]),u(n)&&(i=function(e,t){t[n]=g(e)}),s=e.length,t=0;t<s;t++)xe[e[t]]=i}function Te(e,i){D(e,function(e,t,n,s){n._w=n._w||{},i(e,n._w,n,s)})}var S,Y=0,O=1,b=2,x=3,T=4,N=5,Ne=6,Pe=7,Re=8;function We(e,t){if(isNaN(e)||isNaN(t))return NaN;var n=(t%(n=12)+n)%n;return e+=(t-n)/12,1==n?he(e)?29:28:31-n%7%2}S=Array.prototype.indexOf||function(e){for(var t=0;t<this.length;++t)if(this[t]===e)return t;return-1},s(\"M\",[\"MM\",2],\"Mo\",function(){return this.month()+1}),s(\"MMM\",0,0,function(e){return this.localeData().monthsShort(this,e)}),s(\"MMMM\",0,0,function(e){return this.localeData().months(this,e)}),t(\"month\",\"M\"),n(\"month\",8),v(\"M\",p),v(\"MM\",p,w),v(\"MMM\",function(e,t){return t.monthsShortRegex(e)}),v(\"MMMM\",function(e,t){return t.monthsRegex(e)}),D([\"M\",\"MM\"],function(e,t){t[O]=g(e)-1}),D([\"MMM\",\"MMMM\"],function(e,t,n,s){s=n._locale.monthsParse(e,s,n._strict);null!=s?t[O]=s:m(n).invalidMonth=e});var Ce=\"January_February_March_April_May_June_July_August_September_October_November_December\".split(\"_\"),Ue=\"Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec\".split(\"_\"),He=/D[oD]?(\\[[^\\[\\]]*\\]|\\s)+MMMM?/,Fe=k,Le=k;function Ve(e,t){var n;if(e.isValid()){if(\"string\"==typeof t)if(/^\\d+$/.test(t))t=g(t);else if(!u(t=e.localeData().monthsParse(t)))return;n=Math.min(e.date(),We(e.year(),t)),e._d[\"set\"+(e._isUTC?\"UTC\":\"\")+\"Month\"](t,n)}}function Ge(e){return null!=e?(Ve(this,e),f.updateOffset(this,!0),this):ce(this,\"Month\")}function Ee(){function e(e,t){return t.length-e.length}for(var t,n=[],s=[],i=[],r=0;r<12;r++)t=l([2e3,r]),n.push(this.monthsShort(t,\"\")),s.push(this.months(t,\"\")),i.push(this.months(t,\"\")),i.push(this.monthsShort(t,\"\"));for(n.sort(e),s.sort(e),i.sort(e),r=0;r<12;r++)n[r]=M(n[r]),s[r]=M(s[r]);for(r=0;r<24;r++)i[r]=M(i[r]);this._monthsRegex=new RegExp(\"^(\"+i.join(\"|\")+\")\",\"i\"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp(\"^(\"+s.join(\"|\")+\")\",\"i\"),this._monthsShortStrictRegex=new RegExp(\"^(\"+n.join(\"|\")+\")\",\"i\")}function Ae(e){return he(e)?366:365}s(\"Y\",0,0,function(){var e=this.year();return e<=9999?r(e,4):\"+\"+e}),s(0,[\"YY\",2],0,function(){return this.year()%100}),s(0,[\"YYYY\",4],0,\"year\"),s(0,[\"YYYYY\",5],0,\"year\"),s(0,[\"YYYYYY\",6,!0],0,\"year\"),t(\"year\",\"y\"),n(\"year\",1),v(\"Y\",De),v(\"YY\",p,w),v(\"YYYY\",ke,_e),v(\"YYYYY\",ve,ye),v(\"YYYYYY\",ve,ye),D([\"YYYYY\",\"YYYYYY\"],Y),D(\"YYYY\",function(e,t){t[Y]=2===e.length?f.parseTwoDigitYear(e):g(e)}),D(\"YY\",function(e,t){t[Y]=f.parseTwoDigitYear(e)}),D(\"Y\",function(e,t){t[Y]=parseInt(e,10)}),f.parseTwoDigitYear=function(e){return g(e)+(68<g(e)?1900:2e3)};var Ie=de(\"FullYear\",!0);function je(e,t,n,s,i,r,a){var o;return e<100&&0<=e?(o=new Date(e+400,t,n,s,i,r,a),isFinite(o.getFullYear())&&o.setFullYear(e)):o=new Date(e,t,n,s,i,r,a),o}function Ze(e){var t;return e<100&&0<=e?((t=Array.prototype.slice.call(arguments))[0]=e+400,t=new Date(Date.UTC.apply(null,t)),isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e)):t=new Date(Date.UTC.apply(null,arguments)),t}function ze(e,t,n){n=7+t-n;return n-(7+Ze(e,0,n).getUTCDay()-t)%7-1}function $e(e,t,n,s,i){var r,t=1+7*(t-1)+(7+n-s)%7+ze(e,s,i),n=t<=0?Ae(r=e-1)+t:t>Ae(e)?(r=e+1,t-Ae(e)):(r=e,t);return{year:r,dayOfYear:n}}function qe(e,t,n){var s,i,r=ze(e.year(),t,n),r=Math.floor((e.dayOfYear()-r-1)/7)+1;return r<1?s=r+P(i=e.year()-1,t,n):r>P(e.year(),t,n)?(s=r-P(e.year(),t,n),i=e.year()+1):(i=e.year(),s=r),{week:s,year:i}}function P(e,t,n){var s=ze(e,t,n),t=ze(e+1,t,n);return(Ae(e)-s+t)/7}s(\"w\",[\"ww\",2],\"wo\",\"week\"),s(\"W\",[\"WW\",2],\"Wo\",\"isoWeek\"),t(\"week\",\"w\"),t(\"isoWeek\",\"W\"),n(\"week\",5),n(\"isoWeek\",5),v(\"w\",p),v(\"ww\",p,w),v(\"W\",p),v(\"WW\",p,w),Te([\"w\",\"ww\",\"W\",\"WW\"],function(e,t,n,s){t[s.substr(0,1)]=g(e)});function Be(e,t){return e.slice(t,7).concat(e.slice(0,t))}s(\"d\",0,\"do\",\"day\"),s(\"dd\",0,0,function(e){return this.localeData().weekdaysMin(this,e)}),s(\"ddd\",0,0,function(e){return this.localeData().weekdaysShort(this,e)}),s(\"dddd\",0,0,function(e){return this.localeData().weekdays(this,e)}),s(\"e\",0,0,\"weekday\"),s(\"E\",0,0,\"isoWeekday\"),t(\"day\",\"d\"),t(\"weekday\",\"e\"),t(\"isoWeekday\",\"E\"),n(\"day\",11),n(\"weekday\",11),n(\"isoWeekday\",11),v(\"d\",p),v(\"e\",p),v(\"E\",p),v(\"dd\",function(e,t){return t.weekdaysMinRegex(e)}),v(\"ddd\",function(e,t){return t.weekdaysShortRegex(e)}),v(\"dddd\",function(e,t){return t.weekdaysRegex(e)}),Te([\"dd\",\"ddd\",\"dddd\"],function(e,t,n,s){s=n._locale.weekdaysParse(e,s,n._strict);null!=s?t.d=s:m(n).invalidWeekday=e}),Te([\"d\",\"e\",\"E\"],function(e,t,n,s){t[s]=g(e)});var Je=\"Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday\".split(\"_\"),Qe=\"Sun_Mon_Tue_Wed_Thu_Fri_Sat\".split(\"_\"),Xe=\"Su_Mo_Tu_We_Th_Fr_Sa\".split(\"_\"),Ke=k,et=k,tt=k;function nt(){function e(e,t){return t.length-e.length}for(var t,n,s,i=[],r=[],a=[],o=[],u=0;u<7;u++)s=l([2e3,1]).day(u),t=M(this.weekdaysMin(s,\"\")),n=M(this.weekdaysShort(s,\"\")),s=M(this.weekdays(s,\"\")),i.push(t),r.push(n),a.push(s),o.push(t),o.push(n),o.push(s);i.sort(e),r.sort(e),a.sort(e),o.sort(e),this._weekdaysRegex=new RegExp(\"^(\"+o.join(\"|\")+\")\",\"i\"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp(\"^(\"+a.join(\"|\")+\")\",\"i\"),this._weekdaysShortStrictRegex=new RegExp(\"^(\"+r.join(\"|\")+\")\",\"i\"),this._weekdaysMinStrictRegex=new RegExp(\"^(\"+i.join(\"|\")+\")\",\"i\")}function st(){return this.hours()%12||12}function it(e,t){s(e,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)})}function rt(e,t){return t._meridiemParse}s(\"H\",[\"HH\",2],0,\"hour\"),s(\"h\",[\"hh\",2],0,st),s(\"k\",[\"kk\",2],0,function(){return this.hours()||24}),s(\"hmm\",0,0,function(){return\"\"+st.apply(this)+r(this.minutes(),2)}),s(\"hmmss\",0,0,function(){return\"\"+st.apply(this)+r(this.minutes(),2)+r(this.seconds(),2)}),s(\"Hmm\",0,0,function(){return\"\"+this.hours()+r(this.minutes(),2)}),s(\"Hmmss\",0,0,function(){return\"\"+this.hours()+r(this.minutes(),2)+r(this.seconds(),2)}),it(\"a\",!0),it(\"A\",!1),t(\"hour\",\"h\"),n(\"hour\",13),v(\"a\",rt),v(\"A\",rt),v(\"H\",p),v(\"h\",p),v(\"k\",p),v(\"HH\",p,w),v(\"hh\",p,w),v(\"kk\",p,w),v(\"hmm\",ge),v(\"hmmss\",we),v(\"Hmm\",ge),v(\"Hmmss\",we),D([\"H\",\"HH\"],x),D([\"k\",\"kk\"],function(e,t,n){e=g(e);t[x]=24===e?0:e}),D([\"a\",\"A\"],function(e,t,n){n._isPm=n._locale.isPM(e),n._meridiem=e}),D([\"h\",\"hh\"],function(e,t,n){t[x]=g(e),m(n).bigHour=!0}),D(\"hmm\",function(e,t,n){var s=e.length-2;t[x]=g(e.substr(0,s)),t[T]=g(e.substr(s)),m(n).bigHour=!0}),D(\"hmmss\",function(e,t,n){var s=e.length-4,i=e.length-2;t[x]=g(e.substr(0,s)),t[T]=g(e.substr(s,2)),t[N]=g(e.substr(i)),m(n).bigHour=!0}),D(\"Hmm\",function(e,t,n){var s=e.length-2;t[x]=g(e.substr(0,s)),t[T]=g(e.substr(s))}),D(\"Hmmss\",function(e,t,n){var s=e.length-4,i=e.length-2;t[x]=g(e.substr(0,s)),t[T]=g(e.substr(s,2)),t[N]=g(e.substr(i))});k=de(\"Hours\",!0);var at,ot={calendar:{sameDay:\"[Today at] LT\",nextDay:\"[Tomorrow at] LT\",nextWeek:\"dddd [at] LT\",lastDay:\"[Yesterday at] LT\",lastWeek:\"[Last] dddd [at] LT\",sameElse:\"L\"},longDateFormat:{LTS:\"h:mm:ss A\",LT:\"h:mm A\",L:\"MM/DD/YYYY\",LL:\"MMMM D, YYYY\",LLL:\"MMMM D, YYYY h:mm A\",LLLL:\"dddd, MMMM D, YYYY h:mm A\"},invalidDate:\"Invalid date\",ordinal:\"%d\",dayOfMonthOrdinalParse:/\\d{1,2}/,relativeTime:{future:\"in %s\",past:\"%s ago\",s:\"a few seconds\",ss:\"%d seconds\",m:\"a minute\",mm:\"%d minutes\",h:\"an hour\",hh:\"%d hours\",d:\"a day\",dd:\"%d days\",w:\"a week\",ww:\"%d weeks\",M:\"a month\",MM:\"%d months\",y:\"a year\",yy:\"%d years\"},months:Ce,monthsShort:Ue,week:{dow:0,doy:6},weekdays:Je,weekdaysMin:Xe,weekdaysShort:Qe,meridiemParse:/[ap]\\.?m?\\.?/i},R={},ut={};function lt(e){return e&&e.toLowerCase().replace(\"_\",\"-\")}function ht(e){for(var t,n,s,i,r=0;r<e.length;){for(t=(i=lt(e[r]).split(\"-\")).length,n=(n=lt(e[r+1]))?n.split(\"-\"):null;0<t;){if(s=dt(i.slice(0,t).join(\"-\")))return s;if(n&&n.length>=t&&function(e,t){for(var n=Math.min(e.length,t.length),s=0;s<n;s+=1)if(e[s]!==t[s])return s;return n}(i,n)>=t-1)break;t--}r++}return at}function dt(t){var e;if(void 0===R[t]&&\"undefined\"!=typeof module&&module&&module.exports&&null!=t.match(\"^[^/\\\\\\\\]*$\"))try{e=at._abbr,require(\"./locale/\"+t),ct(e)}catch(e){R[t]=null}return R[t]}function ct(e,t){return e&&((t=o(t)?mt(e):ft(e,t))?at=t:\"undefined\"!=typeof console&&console.warn&&console.warn(\"Locale \"+e+\" not found. Did you forget to load it?\")),at._abbr}function ft(e,t){if(null===t)return delete R[e],null;var n,s=ot;if(t.abbr=e,null!=R[e])Q(\"defineLocaleOverride\",\"use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info.\"),s=R[e]._config;else if(null!=t.parentLocale)if(null!=R[t.parentLocale])s=R[t.parentLocale]._config;else{if(null==(n=dt(t.parentLocale)))return ut[t.parentLocale]||(ut[t.parentLocale]=[]),ut[t.parentLocale].push({name:e,config:t}),null;s=n._config}return R[e]=new K(X(s,t)),ut[e]&&ut[e].forEach(function(e){ft(e.name,e.config)}),ct(e),R[e]}function mt(e){var t;if(!(e=e&&e._locale&&e._locale._abbr?e._locale._abbr:e))return at;if(!a(e)){if(t=dt(e))return t;e=[e]}return ht(e)}function _t(e){var t=e._a;return t&&-2===m(e).overflow&&(t=t[O]<0||11<t[O]?O:t[b]<1||t[b]>We(t[Y],t[O])?b:t[x]<0||24<t[x]||24===t[x]&&(0!==t[T]||0!==t[N]||0!==t[Ne])?x:t[T]<0||59<t[T]?T:t[N]<0||59<t[N]?N:t[Ne]<0||999<t[Ne]?Ne:-1,m(e)._overflowDayOfYear&&(t<Y||b<t)&&(t=b),m(e)._overflowWeeks&&-1===t&&(t=Pe),m(e)._overflowWeekday&&-1===t&&(t=Re),m(e).overflow=t),e}var yt=/^\\s*((?:[+-]\\d{6}|\\d{4})-(?:\\d\\d-\\d\\d|W\\d\\d-\\d|W\\d\\d|\\d\\d\\d|\\d\\d))(?:(T| )(\\d\\d(?::\\d\\d(?::\\d\\d(?:[.,]\\d+)?)?)?)([+-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,gt=/^\\s*((?:[+-]\\d{6}|\\d{4})(?:\\d\\d\\d\\d|W\\d\\d\\d|W\\d\\d|\\d\\d\\d|\\d\\d|))(?:(T| )(\\d\\d(?:\\d\\d(?:\\d\\d(?:[.,]\\d+)?)?)?)([+-]\\d\\d(?::?\\d\\d)?|\\s*Z)?)?$/,wt=/Z|[+-]\\d\\d(?::?\\d\\d)?/,pt=[[\"YYYYYY-MM-DD\",/[+-]\\d{6}-\\d\\d-\\d\\d/],[\"YYYY-MM-DD\",/\\d{4}-\\d\\d-\\d\\d/],[\"GGGG-[W]WW-E\",/\\d{4}-W\\d\\d-\\d/],[\"GGGG-[W]WW\",/\\d{4}-W\\d\\d/,!1],[\"YYYY-DDD\",/\\d{4}-\\d{3}/],[\"YYYY-MM\",/\\d{4}-\\d\\d/,!1],[\"YYYYYYMMDD\",/[+-]\\d{10}/],[\"YYYYMMDD\",/\\d{8}/],[\"GGGG[W]WWE\",/\\d{4}W\\d{3}/],[\"GGGG[W]WW\",/\\d{4}W\\d{2}/,!1],[\"YYYYDDD\",/\\d{7}/],[\"YYYYMM\",/\\d{6}/,!1],[\"YYYY\",/\\d{4}/,!1]],kt=[[\"HH:mm:ss.SSSS\",/\\d\\d:\\d\\d:\\d\\d\\.\\d+/],[\"HH:mm:ss,SSSS\",/\\d\\d:\\d\\d:\\d\\d,\\d+/],[\"HH:mm:ss\",/\\d\\d:\\d\\d:\\d\\d/],[\"HH:mm\",/\\d\\d:\\d\\d/],[\"HHmmss.SSSS\",/\\d\\d\\d\\d\\d\\d\\.\\d+/],[\"HHmmss,SSSS\",/\\d\\d\\d\\d\\d\\d,\\d+/],[\"HHmmss\",/\\d\\d\\d\\d\\d\\d/],[\"HHmm\",/\\d\\d\\d\\d/],[\"HH\",/\\d\\d/]],vt=/^\\/?Date\\((-?\\d+)/i,Mt=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\\s)?(\\d{1,2})\\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s(\\d{2,4})\\s(\\d\\d):(\\d\\d)(?::(\\d\\d))?\\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\\d{4}))$/,Dt={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function St(e){var t,n,s,i,r,a,o=e._i,u=yt.exec(o)||gt.exec(o),o=pt.length,l=kt.length;if(u){for(m(e).iso=!0,t=0,n=o;t<n;t++)if(pt[t][1].exec(u[1])){i=pt[t][0],s=!1!==pt[t][2];break}if(null==i)e._isValid=!1;else{if(u[3]){for(t=0,n=l;t<n;t++)if(kt[t][1].exec(u[3])){r=(u[2]||\" \")+kt[t][0];break}if(null==r)return void(e._isValid=!1)}if(s||null==r){if(u[4]){if(!wt.exec(u[4]))return void(e._isValid=!1);a=\"Z\"}e._f=i+(r||\"\")+(a||\"\"),Tt(e)}else e._isValid=!1}}else e._isValid=!1}function Yt(e,t,n,s,i,r){e=[function(e){e=parseInt(e,10);{if(e<=49)return 2e3+e;if(e<=999)return 1900+e}return e}(e),Ue.indexOf(t),parseInt(n,10),parseInt(s,10),parseInt(i,10)];return r&&e.push(parseInt(r,10)),e}function Ot(e){var t,n,s,i,r=Mt.exec(e._i.replace(/\\([^()]*\\)|[\\n\\t]/g,\" \").replace(/(\\s\\s+)/g,\" \").replace(/^\\s\\s*/,\"\").replace(/\\s\\s*$/,\"\"));r?(t=Yt(r[4],r[3],r[2],r[5],r[6],r[7]),n=r[1],s=t,i=e,n&&Qe.indexOf(n)!==new Date(s[0],s[1],s[2]).getDay()?(m(i).weekdayMismatch=!0,i._isValid=!1):(e._a=t,e._tzm=(n=r[8],s=r[9],i=r[10],n?Dt[n]:s?0:60*(((n=parseInt(i,10))-(s=n%100))/100)+s),e._d=Ze.apply(null,e._a),e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),m(e).rfc2822=!0)):e._isValid=!1}function bt(e,t,n){return null!=e?e:null!=t?t:n}function xt(e){var t,n,s,i,r,a,o,u,l,h,d,c=[];if(!e._d){for(s=e,i=new Date(f.now()),n=s._useUTC?[i.getUTCFullYear(),i.getUTCMonth(),i.getUTCDate()]:[i.getFullYear(),i.getMonth(),i.getDate()],e._w&&null==e._a[b]&&null==e._a[O]&&(null!=(i=(s=e)._w).GG||null!=i.W||null!=i.E?(u=1,l=4,r=bt(i.GG,s._a[Y],qe(W(),1,4).year),a=bt(i.W,1),((o=bt(i.E,1))<1||7<o)&&(h=!0)):(u=s._locale._week.dow,l=s._locale._week.doy,d=qe(W(),u,l),r=bt(i.gg,s._a[Y],d.year),a=bt(i.w,d.week),null!=i.d?((o=i.d)<0||6<o)&&(h=!0):null!=i.e?(o=i.e+u,(i.e<0||6<i.e)&&(h=!0)):o=u),a<1||a>P(r,u,l)?m(s)._overflowWeeks=!0:null!=h?m(s)._overflowWeekday=!0:(d=$e(r,a,o,u,l),s._a[Y]=d.year,s._dayOfYear=d.dayOfYear)),null!=e._dayOfYear&&(i=bt(e._a[Y],n[Y]),(e._dayOfYear>Ae(i)||0===e._dayOfYear)&&(m(e)._overflowDayOfYear=!0),h=Ze(i,0,e._dayOfYear),e._a[O]=h.getUTCMonth(),e._a[b]=h.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=c[t]=n[t];for(;t<7;t++)e._a[t]=c[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[x]&&0===e._a[T]&&0===e._a[N]&&0===e._a[Ne]&&(e._nextDay=!0,e._a[x]=0),e._d=(e._useUTC?Ze:je).apply(null,c),r=e._useUTC?e._d.getUTCDay():e._d.getDay(),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[x]=24),e._w&&void 0!==e._w.d&&e._w.d!==r&&(m(e).weekdayMismatch=!0)}}function Tt(e){if(e._f===f.ISO_8601)St(e);else if(e._f===f.RFC_2822)Ot(e);else{e._a=[],m(e).empty=!0;for(var t,n,s,i,r,a=\"\"+e._i,o=a.length,u=0,l=ae(e._f,e._locale).match(te)||[],h=l.length,d=0;d<h;d++)n=l[d],(t=(a.match(Oe(n,e))||[])[0])&&(0<(s=a.substr(0,a.indexOf(t))).length&&m(e).unusedInput.push(s),a=a.slice(a.indexOf(t)+t.length),u+=t.length),ie[n]?(t?m(e).empty=!1:m(e).unusedTokens.push(n),s=n,r=e,null!=(i=t)&&c(xe,s)&&xe[s](i,r._a,r,s)):e._strict&&!t&&m(e).unusedTokens.push(n);m(e).charsLeftOver=o-u,0<a.length&&m(e).unusedInput.push(a),e._a[x]<=12&&!0===m(e).bigHour&&0<e._a[x]&&(m(e).bigHour=void 0),m(e).parsedDateParts=e._a.slice(0),m(e).meridiem=e._meridiem,e._a[x]=function(e,t,n){if(null==n)return t;return null!=e.meridiemHour?e.meridiemHour(t,n):null!=e.isPM?((e=e.isPM(n))&&t<12&&(t+=12),t=e||12!==t?t:0):t}(e._locale,e._a[x],e._meridiem),null!==(o=m(e).era)&&(e._a[Y]=e._locale.erasConvertYear(o,e._a[Y])),xt(e),_t(e)}}function Nt(e){var t,n,s,i=e._i,r=e._f;if(e._locale=e._locale||mt(e._l),null===i||void 0===r&&\"\"===i)return I({nullInput:!0});if(\"string\"==typeof i&&(e._i=i=e._locale.preparse(i)),h(i))return new q(_t(i));if(V(i))e._d=i;else if(a(r))!function(e){var t,n,s,i,r,a,o=!1,u=e._f.length;if(0===u)return m(e).invalidFormat=!0,e._d=new Date(NaN);for(i=0;i<u;i++)r=0,a=!1,t=$({},e),null!=e._useUTC&&(t._useUTC=e._useUTC),t._f=e._f[i],Tt(t),A(t)&&(a=!0),r=(r+=m(t).charsLeftOver)+10*m(t).unusedTokens.length,m(t).score=r,o?r<s&&(s=r,n=t):(null==s||r<s||a)&&(s=r,n=t,a&&(o=!0));E(e,n||t)}(e);else if(r)Tt(e);else if(o(r=(i=e)._i))i._d=new Date(f.now());else V(r)?i._d=new Date(r.valueOf()):\"string\"==typeof r?(n=i,null!==(t=vt.exec(n._i))?n._d=new Date(+t[1]):(St(n),!1===n._isValid&&(delete n._isValid,Ot(n),!1===n._isValid&&(delete n._isValid,n._strict?n._isValid=!1:f.createFromInputFallback(n))))):a(r)?(i._a=G(r.slice(0),function(e){return parseInt(e,10)}),xt(i)):F(r)?(t=i)._d||(s=void 0===(n=ue(t._i)).day?n.date:n.day,t._a=G([n.year,n.month,s,n.hour,n.minute,n.second,n.millisecond],function(e){return e&&parseInt(e,10)}),xt(t)):u(r)?i._d=new Date(r):f.createFromInputFallback(i);return A(e)||(e._d=null),e}function Pt(e,t,n,s,i){var r={};return!0!==t&&!1!==t||(s=t,t=void 0),!0!==n&&!1!==n||(s=n,n=void 0),(F(e)&&L(e)||a(e)&&0===e.length)&&(e=void 0),r._isAMomentObject=!0,r._useUTC=r._isUTC=i,r._l=n,r._i=e,r._f=t,r._strict=s,(i=new q(_t(Nt(i=r))))._nextDay&&(i.add(1,\"d\"),i._nextDay=void 0),i}function W(e,t,n,s){return Pt(e,t,n,s,!1)}f.createFromInputFallback=e(\"value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.\",function(e){e._d=new Date(e._i+(e._useUTC?\" UTC\":\"\"))}),f.ISO_8601=function(){},f.RFC_2822=function(){};ge=e(\"moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var e=W.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:I()}),we=e(\"moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/\",function(){var e=W.apply(null,arguments);return this.isValid()&&e.isValid()?this<e?this:e:I()});function Rt(e,t){var n,s;if(!(t=1===t.length&&a(t[0])?t[0]:t).length)return W();for(n=t[0],s=1;s<t.length;++s)t[s].isValid()&&!t[s][e](n)||(n=t[s]);return n}var Wt=[\"year\",\"quarter\",\"month\",\"week\",\"day\",\"hour\",\"minute\",\"second\",\"millisecond\"];function Ct(e){var e=ue(e),t=e.year||0,n=e.quarter||0,s=e.month||0,i=e.week||e.isoWeek||0,r=e.day||0,a=e.hour||0,o=e.minute||0,u=e.second||0,l=e.millisecond||0;this._isValid=function(e){var t,n,s=!1,i=Wt.length;for(t in e)if(c(e,t)&&(-1===S.call(Wt,t)||null!=e[t]&&isNaN(e[t])))return!1;for(n=0;n<i;++n)if(e[Wt[n]]){if(s)return!1;parseFloat(e[Wt[n]])!==g(e[Wt[n]])&&(s=!0)}return!0}(e),this._milliseconds=+l+1e3*u+6e4*o+1e3*a*60*60,this._days=+r+7*i,this._months=+s+3*n+12*t,this._data={},this._locale=mt(),this._bubble()}function Ut(e){return e instanceof Ct}function Ht(e){return e<0?-1*Math.round(-1*e):Math.round(e)}function Ft(e,n){s(e,0,0,function(){var e=this.utcOffset(),t=\"+\";return e<0&&(e=-e,t=\"-\"),t+r(~~(e/60),2)+n+r(~~e%60,2)})}Ft(\"Z\",\":\"),Ft(\"ZZ\",\"\"),v(\"Z\",Ye),v(\"ZZ\",Ye),D([\"Z\",\"ZZ\"],function(e,t,n){n._useUTC=!0,n._tzm=Vt(Ye,e)});var Lt=/([\\+\\-]|\\d\\d)/gi;function Vt(e,t){var t=(t||\"\").match(e);return null===t?null:0===(t=60*(e=((t[t.length-1]||[])+\"\").match(Lt)||[\"-\",0,0])[1]+g(e[2]))?0:\"+\"===e[0]?t:-t}function Gt(e,t){var n;return t._isUTC?(t=t.clone(),n=(h(e)||V(e)?e:W(e)).valueOf()-t.valueOf(),t._d.setTime(t._d.valueOf()+n),f.updateOffset(t,!1),t):W(e).local()}function Et(e){return-Math.round(e._d.getTimezoneOffset())}function At(){return!!this.isValid()&&(this._isUTC&&0===this._offset)}f.updateOffset=function(){};var It=/^(-|\\+)?(?:(\\d*)[. ])?(\\d+):(\\d+)(?::(\\d+)(\\.\\d*)?)?$/,jt=/^(-|\\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function C(e,t){var n,s=e,i=null;return Ut(e)?s={ms:e._milliseconds,d:e._days,M:e._months}:u(e)||!isNaN(+e)?(s={},t?s[t]=+e:s.milliseconds=+e):(i=It.exec(e))?(n=\"-\"===i[1]?-1:1,s={y:0,d:g(i[b])*n,h:g(i[x])*n,m:g(i[T])*n,s:g(i[N])*n,ms:g(Ht(1e3*i[Ne]))*n}):(i=jt.exec(e))?(n=\"-\"===i[1]?-1:1,s={y:Zt(i[2],n),M:Zt(i[3],n),w:Zt(i[4],n),d:Zt(i[5],n),h:Zt(i[6],n),m:Zt(i[7],n),s:Zt(i[8],n)}):null==s?s={}:\"object\"==typeof s&&(\"from\"in s||\"to\"in s)&&(t=function(e,t){var n;if(!e.isValid()||!t.isValid())return{milliseconds:0,months:0};t=Gt(t,e),e.isBefore(t)?n=zt(e,t):((n=zt(t,e)).milliseconds=-n.milliseconds,n.months=-n.months);return n}(W(s.from),W(s.to)),(s={}).ms=t.milliseconds,s.M=t.months),i=new Ct(s),Ut(e)&&c(e,\"_locale\")&&(i._locale=e._locale),Ut(e)&&c(e,\"_isValid\")&&(i._isValid=e._isValid),i}function Zt(e,t){e=e&&parseFloat(e.replace(\",\",\".\"));return(isNaN(e)?0:e)*t}function zt(e,t){var n={};return n.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(n.months,\"M\").isAfter(t)&&--n.months,n.milliseconds=+t-+e.clone().add(n.months,\"M\"),n}function $t(s,i){return function(e,t){var n;return null===t||isNaN(+t)||(Q(i,\"moment().\"+i+\"(period, number) is deprecated. Please use moment().\"+i+\"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.\"),n=e,e=t,t=n),qt(this,C(e,t),s),this}}function qt(e,t,n,s){var i=t._milliseconds,r=Ht(t._days),t=Ht(t._months);e.isValid()&&(s=null==s||s,t&&Ve(e,ce(e,\"Month\")+t*n),r&&fe(e,\"Date\",ce(e,\"Date\")+r*n),i&&e._d.setTime(e._d.valueOf()+i*n),s&&f.updateOffset(e,r||t))}C.fn=Ct.prototype,C.invalid=function(){return C(NaN)};Ce=$t(1,\"add\"),Je=$t(-1,\"subtract\");function Bt(e){return\"string\"==typeof e||e instanceof String}function Jt(e){return h(e)||V(e)||Bt(e)||u(e)||function(t){var e=a(t),n=!1;e&&(n=0===t.filter(function(e){return!u(e)&&Bt(t)}).length);return e&&n}(e)||function(e){var t,n,s=F(e)&&!L(e),i=!1,r=[\"years\",\"year\",\"y\",\"months\",\"month\",\"M\",\"days\",\"day\",\"d\",\"dates\",\"date\",\"D\",\"hours\",\"hour\",\"h\",\"minutes\",\"minute\",\"m\",\"seconds\",\"second\",\"s\",\"milliseconds\",\"millisecond\",\"ms\"],a=r.length;for(t=0;t<a;t+=1)n=r[t],i=i||c(e,n);return s&&i}(e)||null==e}function Qt(e,t){if(e.date()<t.date())return-Qt(t,e);var n=12*(t.year()-e.year())+(t.month()-e.month()),s=e.clone().add(n,\"months\"),t=t-s<0?(t-s)/(s-e.clone().add(n-1,\"months\")):(t-s)/(e.clone().add(1+n,\"months\")-s);return-(n+t)||0}function Xt(e){return void 0===e?this._locale._abbr:(null!=(e=mt(e))&&(this._locale=e),this)}f.defaultFormat=\"YYYY-MM-DDTHH:mm:ssZ\",f.defaultFormatUtc=\"YYYY-MM-DDTHH:mm:ss[Z]\";Xe=e(\"moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.\",function(e){return void 0===e?this.localeData():this.locale(e)});function Kt(){return this._locale}var en=126227808e5;function tn(e,t){return(e%t+t)%t}function nn(e,t,n){return e<100&&0<=e?new Date(e+400,t,n)-en:new Date(e,t,n).valueOf()}function sn(e,t,n){return e<100&&0<=e?Date.UTC(e+400,t,n)-en:Date.UTC(e,t,n)}function rn(e,t){return t.erasAbbrRegex(e)}function an(){for(var e=[],t=[],n=[],s=[],i=this.eras(),r=0,a=i.length;r<a;++r)t.push(M(i[r].name)),e.push(M(i[r].abbr)),n.push(M(i[r].narrow)),s.push(M(i[r].name)),s.push(M(i[r].abbr)),s.push(M(i[r].narrow));this._erasRegex=new RegExp(\"^(\"+s.join(\"|\")+\")\",\"i\"),this._erasNameRegex=new RegExp(\"^(\"+t.join(\"|\")+\")\",\"i\"),this._erasAbbrRegex=new RegExp(\"^(\"+e.join(\"|\")+\")\",\"i\"),this._erasNarrowRegex=new RegExp(\"^(\"+n.join(\"|\")+\")\",\"i\")}function on(e,t){s(0,[e,e.length],0,t)}function un(e,t,n,s,i){var r;return null==e?qe(this,s,i).year:(r=P(e,s,i),function(e,t,n,s,i){e=$e(e,t,n,s,i),t=Ze(e.year,0,e.dayOfYear);return this.year(t.getUTCFullYear()),this.month(t.getUTCMonth()),this.date(t.getUTCDate()),this}.call(this,e,t=r<t?r:t,n,s,i))}s(\"N\",0,0,\"eraAbbr\"),s(\"NN\",0,0,\"eraAbbr\"),s(\"NNN\",0,0,\"eraAbbr\"),s(\"NNNN\",0,0,\"eraName\"),s(\"NNNNN\",0,0,\"eraNarrow\"),s(\"y\",[\"y\",1],\"yo\",\"eraYear\"),s(\"y\",[\"yy\",2],0,\"eraYear\"),s(\"y\",[\"yyy\",3],0,\"eraYear\"),s(\"y\",[\"yyyy\",4],0,\"eraYear\"),v(\"N\",rn),v(\"NN\",rn),v(\"NNN\",rn),v(\"NNNN\",function(e,t){return t.erasNameRegex(e)}),v(\"NNNNN\",function(e,t){return t.erasNarrowRegex(e)}),D([\"N\",\"NN\",\"NNN\",\"NNNN\",\"NNNNN\"],function(e,t,n,s){s=n._locale.erasParse(e,s,n._strict);s?m(n).era=s:m(n).invalidEra=e}),v(\"y\",Me),v(\"yy\",Me),v(\"yyy\",Me),v(\"yyyy\",Me),v(\"yo\",function(e,t){return t._eraYearOrdinalRegex||Me}),D([\"y\",\"yy\",\"yyy\",\"yyyy\"],Y),D([\"yo\"],function(e,t,n,s){var i;n._locale._eraYearOrdinalRegex&&(i=e.match(n._locale._eraYearOrdinalRegex)),n._locale.eraYearOrdinalParse?t[Y]=n._locale.eraYearOrdinalParse(e,i):t[Y]=parseInt(e,10)}),s(0,[\"gg\",2],0,function(){return this.weekYear()%100}),s(0,[\"GG\",2],0,function(){return this.isoWeekYear()%100}),on(\"gggg\",\"weekYear\"),on(\"ggggg\",\"weekYear\"),on(\"GGGG\",\"isoWeekYear\"),on(\"GGGGG\",\"isoWeekYear\"),t(\"weekYear\",\"gg\"),t(\"isoWeekYear\",\"GG\"),n(\"weekYear\",1),n(\"isoWeekYear\",1),v(\"G\",De),v(\"g\",De),v(\"GG\",p,w),v(\"gg\",p,w),v(\"GGGG\",ke,_e),v(\"gggg\",ke,_e),v(\"GGGGG\",ve,ye),v(\"ggggg\",ve,ye),Te([\"gggg\",\"ggggg\",\"GGGG\",\"GGGGG\"],function(e,t,n,s){t[s.substr(0,2)]=g(e)}),Te([\"gg\",\"GG\"],function(e,t,n,s){t[s]=f.parseTwoDigitYear(e)}),s(\"Q\",0,\"Qo\",\"quarter\"),t(\"quarter\",\"Q\"),n(\"quarter\",7),v(\"Q\",i),D(\"Q\",function(e,t){t[O]=3*(g(e)-1)}),s(\"D\",[\"DD\",2],\"Do\",\"date\"),t(\"date\",\"D\"),n(\"date\",9),v(\"D\",p),v(\"DD\",p,w),v(\"Do\",function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient}),D([\"D\",\"DD\"],b),D(\"Do\",function(e,t){t[b]=g(e.match(p)[0])});ke=de(\"Date\",!0);s(\"DDD\",[\"DDDD\",3],\"DDDo\",\"dayOfYear\"),t(\"dayOfYear\",\"DDD\"),n(\"dayOfYear\",4),v(\"DDD\",pe),v(\"DDDD\",me),D([\"DDD\",\"DDDD\"],function(e,t,n){n._dayOfYear=g(e)}),s(\"m\",[\"mm\",2],0,\"minute\"),t(\"minute\",\"m\"),n(\"minute\",14),v(\"m\",p),v(\"mm\",p,w),D([\"m\",\"mm\"],T);var ln,_e=de(\"Minutes\",!1),ve=(s(\"s\",[\"ss\",2],0,\"second\"),t(\"second\",\"s\"),n(\"second\",15),v(\"s\",p),v(\"ss\",p,w),D([\"s\",\"ss\"],N),de(\"Seconds\",!1));for(s(\"S\",0,0,function(){return~~(this.millisecond()/100)}),s(0,[\"SS\",2],0,function(){return~~(this.millisecond()/10)}),s(0,[\"SSS\",3],0,\"millisecond\"),s(0,[\"SSSS\",4],0,function(){return 10*this.millisecond()}),s(0,[\"SSSSS\",5],0,function(){return 100*this.millisecond()}),s(0,[\"SSSSSS\",6],0,function(){return 1e3*this.millisecond()}),s(0,[\"SSSSSSS\",7],0,function(){return 1e4*this.millisecond()}),s(0,[\"SSSSSSSS\",8],0,function(){return 1e5*this.millisecond()}),s(0,[\"SSSSSSSSS\",9],0,function(){return 1e6*this.millisecond()}),t(\"millisecond\",\"ms\"),n(\"millisecond\",16),v(\"S\",pe,i),v(\"SS\",pe,w),v(\"SSS\",pe,me),ln=\"SSSS\";ln.length<=9;ln+=\"S\")v(ln,Me);function hn(e,t){t[Ne]=g(1e3*(\"0.\"+e))}for(ln=\"S\";ln.length<=9;ln+=\"S\")D(ln,hn);ye=de(\"Milliseconds\",!1),s(\"z\",0,0,\"zoneAbbr\"),s(\"zz\",0,0,\"zoneName\");i=q.prototype;function dn(e){return e}i.add=Ce,i.calendar=function(e,t){1===arguments.length&&(arguments[0]?Jt(arguments[0])?(e=arguments[0],t=void 0):function(e){for(var t=F(e)&&!L(e),n=!1,s=[\"sameDay\",\"nextDay\",\"lastDay\",\"nextWeek\",\"lastWeek\",\"sameElse\"],i=0;i<s.length;i+=1)n=n||c(e,s[i]);return t&&n}(arguments[0])&&(t=arguments[0],e=void 0):t=e=void 0);var e=e||W(),n=Gt(e,this).startOf(\"day\"),n=f.calendarFormat(this,n)||\"sameElse\",t=t&&(d(t[n])?t[n].call(this,e):t[n]);return this.format(t||this.localeData().calendar(n,this,W(e)))},i.clone=function(){return new q(this)},i.diff=function(e,t,n){var s,i,r;if(!this.isValid())return NaN;if(!(s=Gt(e,this)).isValid())return NaN;switch(i=6e4*(s.utcOffset()-this.utcOffset()),t=_(t)){case\"year\":r=Qt(this,s)/12;break;case\"month\":r=Qt(this,s);break;case\"quarter\":r=Qt(this,s)/3;break;case\"second\":r=(this-s)/1e3;break;case\"minute\":r=(this-s)/6e4;break;case\"hour\":r=(this-s)/36e5;break;case\"day\":r=(this-s-i)/864e5;break;case\"week\":r=(this-s-i)/6048e5;break;default:r=this-s}return n?r:y(r)},i.endOf=function(e){var t,n;if(void 0===(e=_(e))||\"millisecond\"===e||!this.isValid())return this;switch(n=this._isUTC?sn:nn,e){case\"year\":t=n(this.year()+1,0,1)-1;break;case\"quarter\":t=n(this.year(),this.month()-this.month()%3+3,1)-1;break;case\"month\":t=n(this.year(),this.month()+1,1)-1;break;case\"week\":t=n(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case\"isoWeek\":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case\"day\":case\"date\":t=n(this.year(),this.month(),this.date()+1)-1;break;case\"hour\":t=this._d.valueOf(),t+=36e5-tn(t+(this._isUTC?0:6e4*this.utcOffset()),36e5)-1;break;case\"minute\":t=this._d.valueOf(),t+=6e4-tn(t,6e4)-1;break;case\"second\":t=this._d.valueOf(),t+=1e3-tn(t,1e3)-1;break}return this._d.setTime(t),f.updateOffset(this,!0),this},i.format=function(e){return e=e||(this.isUtc()?f.defaultFormatUtc:f.defaultFormat),e=re(this,e),this.localeData().postformat(e)},i.from=function(e,t){return this.isValid()&&(h(e)&&e.isValid()||W(e).isValid())?C({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},i.fromNow=function(e){return this.from(W(),e)},i.to=function(e,t){return this.isValid()&&(h(e)&&e.isValid()||W(e).isValid())?C({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},i.toNow=function(e){return this.to(W(),e)},i.get=function(e){return d(this[e=_(e)])?this[e]():this},i.invalidAt=function(){return m(this).overflow},i.isAfter=function(e,t){return e=h(e)?e:W(e),!(!this.isValid()||!e.isValid())&&(\"millisecond\"===(t=_(t)||\"millisecond\")?this.valueOf()>e.valueOf():e.valueOf()<this.clone().startOf(t).valueOf())},i.isBefore=function(e,t){return e=h(e)?e:W(e),!(!this.isValid()||!e.isValid())&&(\"millisecond\"===(t=_(t)||\"millisecond\")?this.valueOf()<e.valueOf():this.clone().endOf(t).valueOf()<e.valueOf())},i.isBetween=function(e,t,n,s){return e=h(e)?e:W(e),t=h(t)?t:W(t),!!(this.isValid()&&e.isValid()&&t.isValid())&&((\"(\"===(s=s||\"()\")[0]?this.isAfter(e,n):!this.isBefore(e,n))&&(\")\"===s[1]?this.isBefore(t,n):!this.isAfter(t,n)))},i.isSame=function(e,t){var e=h(e)?e:W(e);return!(!this.isValid()||!e.isValid())&&(\"millisecond\"===(t=_(t)||\"millisecond\")?this.valueOf()===e.valueOf():(e=e.valueOf(),this.clone().startOf(t).valueOf()<=e&&e<=this.clone().endOf(t).valueOf()))},i.isSameOrAfter=function(e,t){return this.isSame(e,t)||this.isAfter(e,t)},i.isSameOrBefore=function(e,t){return this.isSame(e,t)||this.isBefore(e,t)},i.isValid=function(){return A(this)},i.lang=Xe,i.locale=Xt,i.localeData=Kt,i.max=we,i.min=ge,i.parsingFlags=function(){return E({},m(this))},i.set=function(e,t){if(\"object\"==typeof e)for(var n=function(e){var t,n=[];for(t in e)c(e,t)&&n.push({unit:t,priority:le[t]});return n.sort(function(e,t){return e.priority-t.priority}),n}(e=ue(e)),s=n.length,i=0;i<s;i++)this[n[i].unit](e[n[i].unit]);else if(d(this[e=_(e)]))return this[e](t);return this},i.startOf=function(e){var t,n;if(void 0===(e=_(e))||\"millisecond\"===e||!this.isValid())return this;switch(n=this._isUTC?sn:nn,e){case\"year\":t=n(this.year(),0,1);break;case\"quarter\":t=n(this.year(),this.month()-this.month()%3,1);break;case\"month\":t=n(this.year(),this.month(),1);break;case\"week\":t=n(this.year(),this.month(),this.date()-this.weekday());break;case\"isoWeek\":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case\"day\":case\"date\":t=n(this.year(),this.month(),this.date());break;case\"hour\":t=this._d.valueOf(),t-=tn(t+(this._isUTC?0:6e4*this.utcOffset()),36e5);break;case\"minute\":t=this._d.valueOf(),t-=tn(t,6e4);break;case\"second\":t=this._d.valueOf(),t-=tn(t,1e3);break}return this._d.setTime(t),f.updateOffset(this,!0),this},i.subtract=Je,i.toArray=function(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]},i.toObject=function(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}},i.toDate=function(){return new Date(this.valueOf())},i.toISOString=function(e){if(!this.isValid())return null;var t=(e=!0!==e)?this.clone().utc():this;return t.year()<0||9999<t.year()?re(t,e?\"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]\":\"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ\"):d(Date.prototype.toISOString)?e?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace(\"Z\",re(t,\"Z\")):re(t,e?\"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]\":\"YYYY-MM-DD[T]HH:mm:ss.SSSZ\")},i.inspect=function(){if(!this.isValid())return\"moment.invalid(/* \"+this._i+\" */)\";var e,t=\"moment\",n=\"\";return this.isLocal()||(t=0===this.utcOffset()?\"moment.utc\":\"moment.parseZone\",n=\"Z\"),t=\"[\"+t+'(\"]',e=0<=this.year()&&this.year()<=9999?\"YYYY\":\"YYYYYY\",this.format(t+e+\"-MM-DD[T]HH:mm:ss.SSS\"+(n+'[\")]'))},\"undefined\"!=typeof Symbol&&null!=Symbol.for&&(i[Symbol.for(\"nodejs.util.inspect.custom\")]=function(){return\"Moment<\"+this.format()+\">\"}),i.toJSON=function(){return this.isValid()?this.toISOString():null},i.toString=function(){return this.clone().locale(\"en\").format(\"ddd MMM DD YYYY HH:mm:ss [GMT]ZZ\")},i.unix=function(){return Math.floor(this.valueOf()/1e3)},i.valueOf=function(){return this._d.valueOf()-6e4*(this._offset||0)},i.creationData=function(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}},i.eraName=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf(\"day\").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].name;if(t[n].until<=e&&e<=t[n].since)return t[n].name}return\"\"},i.eraNarrow=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf(\"day\").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].narrow;if(t[n].until<=e&&e<=t[n].since)return t[n].narrow}return\"\"},i.eraAbbr=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf(\"day\").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].abbr;if(t[n].until<=e&&e<=t[n].since)return t[n].abbr}return\"\"},i.eraYear=function(){for(var e,t,n=this.localeData().eras(),s=0,i=n.length;s<i;++s)if(e=n[s].since<=n[s].until?1:-1,t=this.clone().startOf(\"day\").valueOf(),n[s].since<=t&&t<=n[s].until||n[s].until<=t&&t<=n[s].since)return(this.year()-f(n[s].since).year())*e+n[s].offset;return this.year()},i.year=Ie,i.isLeapYear=function(){return he(this.year())},i.weekYear=function(e){return un.call(this,e,this.week(),this.weekday(),this.localeData()._week.dow,this.localeData()._week.doy)},i.isoWeekYear=function(e){return un.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)},i.quarter=i.quarters=function(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)},i.month=Ge,i.daysInMonth=function(){return We(this.year(),this.month())},i.week=i.weeks=function(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),\"d\")},i.isoWeek=i.isoWeeks=function(e){var t=qe(this,1,4).week;return null==e?t:this.add(7*(e-t),\"d\")},i.weeksInYear=function(){var e=this.localeData()._week;return P(this.year(),e.dow,e.doy)},i.weeksInWeekYear=function(){var e=this.localeData()._week;return P(this.weekYear(),e.dow,e.doy)},i.isoWeeksInYear=function(){return P(this.year(),1,4)},i.isoWeeksInISOWeekYear=function(){return P(this.isoWeekYear(),1,4)},i.date=ke,i.day=i.days=function(e){if(!this.isValid())return null!=e?this:NaN;var t,n,s=this._isUTC?this._d.getUTCDay():this._d.getDay();return null!=e?(t=e,n=this.localeData(),e=\"string\"!=typeof t?t:isNaN(t)?\"number\"==typeof(t=n.weekdaysParse(t))?t:null:parseInt(t,10),this.add(e-s,\"d\")):s},i.weekday=function(e){if(!this.isValid())return null!=e?this:NaN;var t=(this.day()+7-this.localeData()._week.dow)%7;return null==e?t:this.add(e-t,\"d\")},i.isoWeekday=function(e){return this.isValid()?null!=e?(t=e,n=this.localeData(),n=\"string\"==typeof t?n.weekdaysParse(t)%7||7:isNaN(t)?null:t,this.day(this.day()%7?n:n-7)):this.day()||7:null!=e?this:NaN;var t,n},i.dayOfYear=function(e){var t=Math.round((this.clone().startOf(\"day\")-this.clone().startOf(\"year\"))/864e5)+1;return null==e?t:this.add(e-t,\"d\")},i.hour=i.hours=k,i.minute=i.minutes=_e,i.second=i.seconds=ve,i.millisecond=i.milliseconds=ye,i.utcOffset=function(e,t,n){var s,i=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null==e)return this._isUTC?i:Et(this);if(\"string\"==typeof e){if(null===(e=Vt(Ye,e)))return this}else Math.abs(e)<16&&!n&&(e*=60);return!this._isUTC&&t&&(s=Et(this)),this._offset=e,this._isUTC=!0,null!=s&&this.add(s,\"m\"),i!==e&&(!t||this._changeInProgress?qt(this,C(e-i,\"m\"),1,!1):this._changeInProgress||(this._changeInProgress=!0,f.updateOffset(this,!0),this._changeInProgress=null)),this},i.utc=function(e){return this.utcOffset(0,e)},i.local=function(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e&&this.subtract(Et(this),\"m\")),this},i.parseZone=function(){var e;return null!=this._tzm?this.utcOffset(this._tzm,!1,!0):\"string\"==typeof this._i&&(null!=(e=Vt(Se,this._i))?this.utcOffset(e):this.utcOffset(0,!0)),this},i.hasAlignedHourOffset=function(e){return!!this.isValid()&&(e=e?W(e).utcOffset():0,(this.utcOffset()-e)%60==0)},i.isDST=function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()},i.isLocal=function(){return!!this.isValid()&&!this._isUTC},i.isUtcOffset=function(){return!!this.isValid()&&this._isUTC},i.isUtc=At,i.isUTC=At,i.zoneAbbr=function(){return this._isUTC?\"UTC\":\"\"},i.zoneName=function(){return this._isUTC?\"Coordinated Universal Time\":\"\"},i.dates=e(\"dates accessor is deprecated. Use date instead.\",ke),i.months=e(\"months accessor is deprecated. Use month instead\",Ge),i.years=e(\"years accessor is deprecated. Use year instead\",Ie),i.zone=e(\"moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/\",function(e,t){return null!=e?(this.utcOffset(e=\"string\"!=typeof e?-e:e,t),this):-this.utcOffset()}),i.isDSTShifted=e(\"isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information\",function(){if(!o(this._isDSTShifted))return this._isDSTShifted;var e,t={};return $(t,this),(t=Nt(t))._a?(e=(t._isUTC?l:W)(t._a),this._isDSTShifted=this.isValid()&&0<function(e,t,n){for(var s=Math.min(e.length,t.length),i=Math.abs(e.length-t.length),r=0,a=0;a<s;a++)(n&&e[a]!==t[a]||!n&&g(e[a])!==g(t[a]))&&r++;return r+i}(t._a,e.toArray())):this._isDSTShifted=!1,this._isDSTShifted});w=K.prototype;function cn(e,t,n,s){var i=mt(),s=l().set(s,t);return i[n](s,e)}function fn(e,t,n){if(u(e)&&(t=e,e=void 0),e=e||\"\",null!=t)return cn(e,t,n,\"month\");for(var s=[],i=0;i<12;i++)s[i]=cn(e,i,n,\"month\");return s}function mn(e,t,n,s){t=(\"boolean\"==typeof e?u(t)&&(n=t,t=void 0):(t=e,e=!1,u(n=t)&&(n=t,t=void 0)),t||\"\");var i,r=mt(),a=e?r._week.dow:0,o=[];if(null!=n)return cn(t,(n+a)%7,s,\"day\");for(i=0;i<7;i++)o[i]=cn(t,(i+a)%7,s,\"day\");return o}w.calendar=function(e,t,n){return d(e=this._calendar[e]||this._calendar.sameElse)?e.call(t,n):e},w.longDateFormat=function(e){var t=this._longDateFormat[e],n=this._longDateFormat[e.toUpperCase()];return t||!n?t:(this._longDateFormat[e]=n.match(te).map(function(e){return\"MMMM\"===e||\"MM\"===e||\"DD\"===e||\"dddd\"===e?e.slice(1):e}).join(\"\"),this._longDateFormat[e])},w.invalidDate=function(){return this._invalidDate},w.ordinal=function(e){return this._ordinal.replace(\"%d\",e)},w.preparse=dn,w.postformat=dn,w.relativeTime=function(e,t,n,s){var i=this._relativeTime[n];return d(i)?i(e,t,n,s):i.replace(/%d/i,e)},w.pastFuture=function(e,t){return d(e=this._relativeTime[0<e?\"future\":\"past\"])?e(t):e.replace(/%s/i,t)},w.set=function(e){var t,n;for(n in e)c(e,n)&&(d(t=e[n])?this[n]=t:this[\"_\"+n]=t);this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+\"|\"+/\\d{1,2}/.source)},w.eras=function(e,t){for(var n,s=this._eras||mt(\"en\")._eras,i=0,r=s.length;i<r;++i){switch(typeof s[i].since){case\"string\":n=f(s[i].since).startOf(\"day\"),s[i].since=n.valueOf();break}switch(typeof s[i].until){case\"undefined\":s[i].until=1/0;break;case\"string\":n=f(s[i].until).startOf(\"day\").valueOf(),s[i].until=n.valueOf();break}}return s},w.erasParse=function(e,t,n){var s,i,r,a,o,u=this.eras();for(e=e.toUpperCase(),s=0,i=u.length;s<i;++s)if(r=u[s].name.toUpperCase(),a=u[s].abbr.toUpperCase(),o=u[s].narrow.toUpperCase(),n)switch(t){case\"N\":case\"NN\":case\"NNN\":if(a===e)return u[s];break;case\"NNNN\":if(r===e)return u[s];break;case\"NNNNN\":if(o===e)return u[s];break}else if(0<=[r,a,o].indexOf(e))return u[s]},w.erasConvertYear=function(e,t){var n=e.since<=e.until?1:-1;return void 0===t?f(e.since).year():f(e.since).year()+(t-e.offset)*n},w.erasAbbrRegex=function(e){return c(this,\"_erasAbbrRegex\")||an.call(this),e?this._erasAbbrRegex:this._erasRegex},w.erasNameRegex=function(e){return c(this,\"_erasNameRegex\")||an.call(this),e?this._erasNameRegex:this._erasRegex},w.erasNarrowRegex=function(e){return c(this,\"_erasNarrowRegex\")||an.call(this),e?this._erasNarrowRegex:this._erasRegex},w.months=function(e,t){return e?(a(this._months)?this._months:this._months[(this._months.isFormat||He).test(t)?\"format\":\"standalone\"])[e.month()]:a(this._months)?this._months:this._months.standalone},w.monthsShort=function(e,t){return e?(a(this._monthsShort)?this._monthsShort:this._monthsShort[He.test(t)?\"format\":\"standalone\"])[e.month()]:a(this._monthsShort)?this._monthsShort:this._monthsShort.standalone},w.monthsParse=function(e,t,n){var s,i;if(this._monthsParseExact)return function(e,t,n){var s,i,r,e=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],s=0;s<12;++s)r=l([2e3,s]),this._shortMonthsParse[s]=this.monthsShort(r,\"\").toLocaleLowerCase(),this._longMonthsParse[s]=this.months(r,\"\").toLocaleLowerCase();return n?\"MMM\"===t?-1!==(i=S.call(this._shortMonthsParse,e))?i:null:-1!==(i=S.call(this._longMonthsParse,e))?i:null:\"MMM\"===t?-1!==(i=S.call(this._shortMonthsParse,e))||-1!==(i=S.call(this._longMonthsParse,e))?i:null:-1!==(i=S.call(this._longMonthsParse,e))||-1!==(i=S.call(this._shortMonthsParse,e))?i:null}.call(this,e,t,n);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),s=0;s<12;s++){if(i=l([2e3,s]),n&&!this._longMonthsParse[s]&&(this._longMonthsParse[s]=new RegExp(\"^\"+this.months(i,\"\").replace(\".\",\"\")+\"$\",\"i\"),this._shortMonthsParse[s]=new RegExp(\"^\"+this.monthsShort(i,\"\").replace(\".\",\"\")+\"$\",\"i\")),n||this._monthsParse[s]||(i=\"^\"+this.months(i,\"\")+\"|^\"+this.monthsShort(i,\"\"),this._monthsParse[s]=new RegExp(i.replace(\".\",\"\"),\"i\")),n&&\"MMMM\"===t&&this._longMonthsParse[s].test(e))return s;if(n&&\"MMM\"===t&&this._shortMonthsParse[s].test(e))return s;if(!n&&this._monthsParse[s].test(e))return s}},w.monthsRegex=function(e){return this._monthsParseExact?(c(this,\"_monthsRegex\")||Ee.call(this),e?this._monthsStrictRegex:this._monthsRegex):(c(this,\"_monthsRegex\")||(this._monthsRegex=Le),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)},w.monthsShortRegex=function(e){return this._monthsParseExact?(c(this,\"_monthsRegex\")||Ee.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(c(this,\"_monthsShortRegex\")||(this._monthsShortRegex=Fe),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)},w.week=function(e){return qe(e,this._week.dow,this._week.doy).week},w.firstDayOfYear=function(){return this._week.doy},w.firstDayOfWeek=function(){return this._week.dow},w.weekdays=function(e,t){return t=a(this._weekdays)?this._weekdays:this._weekdays[e&&!0!==e&&this._weekdays.isFormat.test(t)?\"format\":\"standalone\"],!0===e?Be(t,this._week.dow):e?t[e.day()]:t},w.weekdaysMin=function(e){return!0===e?Be(this._weekdaysMin,this._week.dow):e?this._weekdaysMin[e.day()]:this._weekdaysMin},w.weekdaysShort=function(e){return!0===e?Be(this._weekdaysShort,this._week.dow):e?this._weekdaysShort[e.day()]:this._weekdaysShort},w.weekdaysParse=function(e,t,n){var s,i;if(this._weekdaysParseExact)return function(e,t,n){var s,i,r,e=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],s=0;s<7;++s)r=l([2e3,1]).day(s),this._minWeekdaysParse[s]=this.weekdaysMin(r,\"\").toLocaleLowerCase(),this._shortWeekdaysParse[s]=this.weekdaysShort(r,\"\").toLocaleLowerCase(),this._weekdaysParse[s]=this.weekdays(r,\"\").toLocaleLowerCase();return n?\"dddd\"===t?-1!==(i=S.call(this._weekdaysParse,e))?i:null:\"ddd\"===t?-1!==(i=S.call(this._shortWeekdaysParse,e))?i:null:-1!==(i=S.call(this._minWeekdaysParse,e))?i:null:\"dddd\"===t?-1!==(i=S.call(this._weekdaysParse,e))||-1!==(i=S.call(this._shortWeekdaysParse,e))||-1!==(i=S.call(this._minWeekdaysParse,e))?i:null:\"ddd\"===t?-1!==(i=S.call(this._shortWeekdaysParse,e))||-1!==(i=S.call(this._weekdaysParse,e))||-1!==(i=S.call(this._minWeekdaysParse,e))?i:null:-1!==(i=S.call(this._minWeekdaysParse,e))||-1!==(i=S.call(this._weekdaysParse,e))||-1!==(i=S.call(this._shortWeekdaysParse,e))?i:null}.call(this,e,t,n);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),s=0;s<7;s++){if(i=l([2e3,1]).day(s),n&&!this._fullWeekdaysParse[s]&&(this._fullWeekdaysParse[s]=new RegExp(\"^\"+this.weekdays(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\"),this._shortWeekdaysParse[s]=new RegExp(\"^\"+this.weekdaysShort(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\"),this._minWeekdaysParse[s]=new RegExp(\"^\"+this.weekdaysMin(i,\"\").replace(\".\",\"\\\\.?\")+\"$\",\"i\")),this._weekdaysParse[s]||(i=\"^\"+this.weekdays(i,\"\")+\"|^\"+this.weekdaysShort(i,\"\")+\"|^\"+this.weekdaysMin(i,\"\"),this._weekdaysParse[s]=new RegExp(i.replace(\".\",\"\"),\"i\")),n&&\"dddd\"===t&&this._fullWeekdaysParse[s].test(e))return s;if(n&&\"ddd\"===t&&this._shortWeekdaysParse[s].test(e))return s;if(n&&\"dd\"===t&&this._minWeekdaysParse[s].test(e))return s;if(!n&&this._weekdaysParse[s].test(e))return s}},w.weekdaysRegex=function(e){return this._weekdaysParseExact?(c(this,\"_weekdaysRegex\")||nt.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(c(this,\"_weekdaysRegex\")||(this._weekdaysRegex=Ke),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)},w.weekdaysShortRegex=function(e){return this._weekdaysParseExact?(c(this,\"_weekdaysRegex\")||nt.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(c(this,\"_weekdaysShortRegex\")||(this._weekdaysShortRegex=et),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)},w.weekdaysMinRegex=function(e){return this._weekdaysParseExact?(c(this,\"_weekdaysRegex\")||nt.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(c(this,\"_weekdaysMinRegex\")||(this._weekdaysMinRegex=tt),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)},w.isPM=function(e){return\"p\"===(e+\"\").toLowerCase().charAt(0)},w.meridiem=function(e,t,n){return 11<e?n?\"pm\":\"PM\":n?\"am\":\"AM\"},ct(\"en\",{eras:[{since:\"0001-01-01\",until:1/0,offset:1,name:\"Anno Domini\",narrow:\"AD\",abbr:\"AD\"},{since:\"0000-12-31\",until:-1/0,offset:1,name:\"Before Christ\",narrow:\"BC\",abbr:\"BC\"}],dayOfMonthOrdinalParse:/\\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1===g(e%100/10)?\"th\":1==t?\"st\":2==t?\"nd\":3==t?\"rd\":\"th\")}}),f.lang=e(\"moment.lang is deprecated. Use moment.locale instead.\",ct),f.langData=e(\"moment.langData is deprecated. Use moment.localeData instead.\",mt);var _n=Math.abs;function yn(e,t,n,s){t=C(t,n);return e._milliseconds+=s*t._milliseconds,e._days+=s*t._days,e._months+=s*t._months,e._bubble()}function gn(e){return e<0?Math.floor(e):Math.ceil(e)}function wn(e){return 4800*e/146097}function pn(e){return 146097*e/4800}function kn(e){return function(){return this.as(e)}}pe=kn(\"ms\"),me=kn(\"s\"),Ce=kn(\"m\"),we=kn(\"h\"),ge=kn(\"d\"),Je=kn(\"w\"),k=kn(\"M\"),_e=kn(\"Q\"),ve=kn(\"y\");function vn(e){return function(){return this.isValid()?this._data[e]:NaN}}var ye=vn(\"milliseconds\"),ke=vn(\"seconds\"),Ie=vn(\"minutes\"),w=vn(\"hours\"),Mn=vn(\"days\"),Dn=vn(\"months\"),Sn=vn(\"years\");var Yn=Math.round,On={ss:44,s:45,m:45,h:22,d:26,w:null,M:11};function bn(e,t,n,s){var i=C(e).abs(),r=Yn(i.as(\"s\")),a=Yn(i.as(\"m\")),o=Yn(i.as(\"h\")),u=Yn(i.as(\"d\")),l=Yn(i.as(\"M\")),h=Yn(i.as(\"w\")),i=Yn(i.as(\"y\")),r=(r<=n.ss?[\"s\",r]:r<n.s&&[\"ss\",r])||a<=1&&[\"m\"]||a<n.m&&[\"mm\",a]||o<=1&&[\"h\"]||o<n.h&&[\"hh\",o]||u<=1&&[\"d\"]||u<n.d&&[\"dd\",u];return(r=(r=null!=n.w?r||h<=1&&[\"w\"]||h<n.w&&[\"ww\",h]:r)||l<=1&&[\"M\"]||l<n.M&&[\"MM\",l]||i<=1&&[\"y\"]||[\"yy\",i])[2]=t,r[3]=0<+e,r[4]=s,function(e,t,n,s,i){return i.relativeTime(t||1,!!n,e,s)}.apply(null,r)}var xn=Math.abs;function Tn(e){return(0<e)-(e<0)||+e}function Nn(){if(!this.isValid())return this.localeData().invalidDate();var e,t,n,s,i,r,a,o=xn(this._milliseconds)/1e3,u=xn(this._days),l=xn(this._months),h=this.asSeconds();return h?(e=y(o/60),t=y(e/60),o%=60,e%=60,n=y(l/12),l%=12,s=o?o.toFixed(3).replace(/\\.?0+$/,\"\"):\"\",i=Tn(this._months)!==Tn(h)?\"-\":\"\",r=Tn(this._days)!==Tn(h)?\"-\":\"\",a=Tn(this._milliseconds)!==Tn(h)?\"-\":\"\",(h<0?\"-\":\"\")+\"P\"+(n?i+n+\"Y\":\"\")+(l?i+l+\"M\":\"\")+(u?r+u+\"D\":\"\")+(t||e||o?\"T\":\"\")+(t?a+t+\"H\":\"\")+(e?a+e+\"M\":\"\")+(o?a+s+\"S\":\"\")):\"P0D\"}var U=Ct.prototype;return U.isValid=function(){return this._isValid},U.abs=function(){var e=this._data;return this._milliseconds=_n(this._milliseconds),this._days=_n(this._days),this._months=_n(this._months),e.milliseconds=_n(e.milliseconds),e.seconds=_n(e.seconds),e.minutes=_n(e.minutes),e.hours=_n(e.hours),e.months=_n(e.months),e.years=_n(e.years),this},U.add=function(e,t){return yn(this,e,t,1)},U.subtract=function(e,t){return yn(this,e,t,-1)},U.as=function(e){if(!this.isValid())return NaN;var t,n,s=this._milliseconds;if(\"month\"===(e=_(e))||\"quarter\"===e||\"year\"===e)switch(t=this._days+s/864e5,n=this._months+wn(t),e){case\"month\":return n;case\"quarter\":return n/3;case\"year\":return n/12}else switch(t=this._days+Math.round(pn(this._months)),e){case\"week\":return t/7+s/6048e5;case\"day\":return t+s/864e5;case\"hour\":return 24*t+s/36e5;case\"minute\":return 1440*t+s/6e4;case\"second\":return 86400*t+s/1e3;case\"millisecond\":return Math.floor(864e5*t)+s;default:throw new Error(\"Unknown unit \"+e)}},U.asMilliseconds=pe,U.asSeconds=me,U.asMinutes=Ce,U.asHours=we,U.asDays=ge,U.asWeeks=Je,U.asMonths=k,U.asQuarters=_e,U.asYears=ve,U.valueOf=function(){return this.isValid()?this._milliseconds+864e5*this._days+this._months%12*2592e6+31536e6*g(this._months/12):NaN},U._bubble=function(){var e=this._milliseconds,t=this._days,n=this._months,s=this._data;return 0<=e&&0<=t&&0<=n||e<=0&&t<=0&&n<=0||(e+=864e5*gn(pn(n)+t),n=t=0),s.milliseconds=e%1e3,e=y(e/1e3),s.seconds=e%60,e=y(e/60),s.minutes=e%60,e=y(e/60),s.hours=e%24,t+=y(e/24),n+=e=y(wn(t)),t-=gn(pn(e)),e=y(n/12),n%=12,s.days=t,s.months=n,s.years=e,this},U.clone=function(){return C(this)},U.get=function(e){return e=_(e),this.isValid()?this[e+\"s\"]():NaN},U.milliseconds=ye,U.seconds=ke,U.minutes=Ie,U.hours=w,U.days=Mn,U.weeks=function(){return y(this.days()/7)},U.months=Dn,U.years=Sn,U.humanize=function(e,t){if(!this.isValid())return this.localeData().invalidDate();var n=!1,s=On;return\"object\"==typeof e&&(t=e,e=!1),\"boolean\"==typeof e&&(n=e),\"object\"==typeof t&&(s=Object.assign({},On,t),null!=t.s&&null==t.ss&&(s.ss=t.s-1)),e=this.localeData(),t=bn(this,!n,s,e),n&&(t=e.pastFuture(+this,t)),e.postformat(t)},U.toISOString=Nn,U.toString=Nn,U.toJSON=Nn,U.locale=Xt,U.localeData=Kt,U.toIsoString=e(\"toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)\",Nn),U.lang=Xe,s(\"X\",0,0,\"unix\"),s(\"x\",0,0,\"valueOf\"),v(\"x\",De),v(\"X\",/[+-]?\\d+(\\.\\d{1,3})?/),D(\"X\",function(e,t,n){n._d=new Date(1e3*parseFloat(e))}),D(\"x\",function(e,t,n){n._d=new Date(g(e))}),f.version=\"2.29.4\",H=W,f.fn=i,f.min=function(){return Rt(\"isBefore\",[].slice.call(arguments,0))},f.max=function(){return Rt(\"isAfter\",[].slice.call(arguments,0))},f.now=function(){return Date.now?Date.now():+new Date},f.utc=l,f.unix=function(e){return W(1e3*e)},f.months=function(e,t){return fn(e,t,\"months\")},f.isDate=V,f.locale=ct,f.invalid=I,f.duration=C,f.isMoment=h,f.weekdays=function(e,t,n){return mn(e,t,n,\"weekdays\")},f.parseZone=function(){return W.apply(null,arguments).parseZone()},f.localeData=mt,f.isDuration=Ut,f.monthsShort=function(e,t){return fn(e,t,\"monthsShort\")},f.weekdaysMin=function(e,t,n){return mn(e,t,n,\"weekdaysMin\")},f.defineLocale=ft,f.updateLocale=function(e,t){var n,s;return null!=t?(s=ot,null!=R[e]&&null!=R[e].parentLocale?R[e].set(X(R[e]._config,t)):(t=X(s=null!=(n=dt(e))?n._config:s,t),null==n&&(t.abbr=e),(s=new K(t)).parentLocale=R[e],R[e]=s),ct(e)):null!=R[e]&&(null!=R[e].parentLocale?(R[e]=R[e].parentLocale,e===ct()&&ct(e)):null!=R[e]&&delete R[e]),R[e]},f.locales=function(){return ee(R)},f.weekdaysShort=function(e,t,n){return mn(e,t,n,\"weekdaysShort\")},f.normalizeUnits=_,f.relativeTimeRounding=function(e){return void 0===e?Yn:\"function\"==typeof e&&(Yn=e,!0)},f.relativeTimeThreshold=function(e,t){return void 0!==On[e]&&(void 0===t?On[e]:(On[e]=t,\"s\"===e&&(On.ss=t-1),!0))},f.calendarFormat=function(e,t){return(e=e.diff(t,\"days\",!0))<-6?\"sameElse\":e<-1?\"lastWeek\":e<0?\"lastDay\":e<1?\"sameDay\":e<2?\"nextDay\":e<7?\"nextWeek\":\"sameElse\"},f.prototype=i,f.HTML5_FMT={DATETIME_LOCAL:\"YYYY-MM-DDTHH:mm\",DATETIME_LOCAL_SECONDS:\"YYYY-MM-DDTHH:mm:ss\",DATETIME_LOCAL_MS:\"YYYY-MM-DDTHH:mm:ss.SSS\",DATE:\"YYYY-MM-DD\",TIME:\"HH:mm\",TIME_SECONDS:\"HH:mm:ss\",TIME_MS:\"HH:mm:ss.SSS\",WEEK:\"GGGG-[W]WW\",MONTH:\"YYYY-MM\"},f});\n/* jscs:disable */\n/* eslint:disable */\n","moment-timezone-with-data.js":"//! moment-timezone.js\n//! version : 0.5.43\n//! Copyright (c) JS Foundation and other contributors\n//! license : MIT\n//! github.com/moment/moment-timezone\n\n(function (root, factory) {\n    \"use strict\";\n\n    /*global define*/\n    if (typeof module === 'object' && module.exports) {\n        module.exports = factory(require('moment')); // Node\n    } else if (typeof define === 'function' && define.amd) {\n        define(['moment'], factory);                 // AMD\n    } else {\n        factory(root.moment);                        // Browser\n    }\n}(this, function (moment) {\n    \"use strict\";\n\n    // Resolves es6 module loading issue\n    if (moment.version === undefined && moment.default) {\n        moment = moment.default;\n    }\n\n    // Do not load moment-timezone a second time.\n    // if (moment.tz !== undefined) {\n    // \tlogError('Moment Timezone ' + moment.tz.version + ' was already loaded ' + (moment.tz.dataVersion ? 'with data from ' : 'without any data') + moment.tz.dataVersion);\n    // \treturn moment;\n    // }\n\n    var VERSION = \"0.5.43\",\n        zones = {},\n        links = {},\n        countries = {},\n        names = {},\n        guesses = {},\n        cachedGuess;\n\n    if (!moment || typeof moment.version !== 'string') {\n        logError('Moment Timezone requires Moment.js. See https://momentjs.com/timezone/docs/#/use-it/browser/');\n    }\n\n    var momentVersion = moment.version.split('.'),\n        major = +momentVersion[0],\n        minor = +momentVersion[1];\n\n    // Moment.js version check\n    if (major < 2 || (major === 2 && minor < 6)) {\n        logError('Moment Timezone requires Moment.js >= 2.6.0. You are using Moment.js ' + moment.version + '. See momentjs.com');\n    }\n\n    /************************************\n     Unpacking\n     ************************************/\n\n    function charCodeToInt(charCode) {\n        if (charCode > 96) {\n            return charCode - 87;\n        } else if (charCode > 64) {\n            return charCode - 29;\n        }\n        return charCode - 48;\n    }\n\n    function unpackBase60(string) {\n        var i = 0,\n            parts = string.split('.'),\n            whole = parts[0],\n            fractional = parts[1] || '',\n            multiplier = 1,\n            num,\n            out = 0,\n            sign = 1;\n\n        // handle negative numbers\n        if (string.charCodeAt(0) === 45) {\n            i = 1;\n            sign = -1;\n        }\n\n        // handle digits before the decimal\n        for (i; i < whole.length; i++) {\n            num = charCodeToInt(whole.charCodeAt(i));\n            out = 60 * out + num;\n        }\n\n        // handle digits after the decimal\n        for (i = 0; i < fractional.length; i++) {\n            multiplier = multiplier / 60;\n            num = charCodeToInt(fractional.charCodeAt(i));\n            out += num * multiplier;\n        }\n\n        return out * sign;\n    }\n\n    function arrayToInt (array) {\n        for (var i = 0; i < array.length; i++) {\n            array[i] = unpackBase60(array[i]);\n        }\n    }\n\n    function intToUntil (array, length) {\n        for (var i = 0; i < length; i++) {\n            array[i] = Math.round((array[i - 1] || 0) + (array[i] * 60000)); // minutes to milliseconds\n        }\n\n        array[length - 1] = Infinity;\n    }\n\n    function mapIndices (source, indices) {\n        var out = [], i;\n\n        for (i = 0; i < indices.length; i++) {\n            out[i] = source[indices[i]];\n        }\n\n        return out;\n    }\n\n    function unpack (string) {\n        var data = string.split('|'),\n            offsets = data[2].split(' '),\n            indices = data[3].split(''),\n            untils  = data[4].split(' ');\n\n        arrayToInt(offsets);\n        arrayToInt(indices);\n        arrayToInt(untils);\n\n        intToUntil(untils, indices.length);\n\n        return {\n            name       : data[0],\n            abbrs      : mapIndices(data[1].split(' '), indices),\n            offsets    : mapIndices(offsets, indices),\n            untils     : untils,\n            population : data[5] | 0\n        };\n    }\n\n    /************************************\n     Zone object\n     ************************************/\n\n    function Zone (packedString) {\n        if (packedString) {\n            this._set(unpack(packedString));\n        }\n    }\n\n    Zone.prototype = {\n        _set : function (unpacked) {\n            this.name       = unpacked.name;\n            this.abbrs      = unpacked.abbrs;\n            this.untils     = unpacked.untils;\n            this.offsets    = unpacked.offsets;\n            this.population = unpacked.population;\n        },\n\n        _index : function (timestamp) {\n            var target = +timestamp,\n                untils = this.untils,\n                i;\n\n            for (i = 0; i < untils.length; i++) {\n                if (target < untils[i]) {\n                    return i;\n                }\n            }\n        },\n\n        countries : function () {\n            var zone_name = this.name;\n            return Object.keys(countries).filter(function (country_code) {\n                return countries[country_code].zones.indexOf(zone_name) !== -1;\n            });\n        },\n\n        parse : function (timestamp) {\n            var target  = +timestamp,\n                offsets = this.offsets,\n                untils  = this.untils,\n                max     = untils.length - 1,\n                offset, offsetNext, offsetPrev, i;\n\n            for (i = 0; i < max; i++) {\n                offset     = offsets[i];\n                offsetNext = offsets[i + 1];\n                offsetPrev = offsets[i ? i - 1 : i];\n\n                if (offset < offsetNext && tz.moveAmbiguousForward) {\n                    offset = offsetNext;\n                } else if (offset > offsetPrev && tz.moveInvalidForward) {\n                    offset = offsetPrev;\n                }\n\n                if (target < untils[i] - (offset * 60000)) {\n                    return offsets[i];\n                }\n            }\n\n            return offsets[max];\n        },\n\n        abbr : function (mom) {\n            return this.abbrs[this._index(mom)];\n        },\n\n        offset : function (mom) {\n            logError(\"zone.offset has been deprecated in favor of zone.utcOffset\");\n            return this.offsets[this._index(mom)];\n        },\n\n        utcOffset : function (mom) {\n            return this.offsets[this._index(mom)];\n        }\n    };\n\n    /************************************\n     Country object\n     ************************************/\n\n    function Country (country_name, zone_names) {\n        this.name = country_name;\n        this.zones = zone_names;\n    }\n\n    /************************************\n     Current Timezone\n     ************************************/\n\n    function OffsetAt(at) {\n        var timeString = at.toTimeString();\n        var abbr = timeString.match(/\\([a-z ]+\\)/i);\n        if (abbr && abbr[0]) {\n            // 17:56:31 GMT-0600 (CST)\n            // 17:56:31 GMT-0600 (Central Standard Time)\n            abbr = abbr[0].match(/[A-Z]/g);\n            abbr = abbr ? abbr.join('') : undefined;\n        } else {\n            // 17:56:31 CST\n            // 17:56:31 GMT+0800 (\u53f0\u5317\u6a19\u6e96\u6642\u9593)\n            abbr = timeString.match(/[A-Z]{3,5}/g);\n            abbr = abbr ? abbr[0] : undefined;\n        }\n\n        if (abbr === 'GMT') {\n            abbr = undefined;\n        }\n\n        this.at = +at;\n        this.abbr = abbr;\n        this.offset = at.getTimezoneOffset();\n    }\n\n    function ZoneScore(zone) {\n        this.zone = zone;\n        this.offsetScore = 0;\n        this.abbrScore = 0;\n    }\n\n    ZoneScore.prototype.scoreOffsetAt = function (offsetAt) {\n        this.offsetScore += Math.abs(this.zone.utcOffset(offsetAt.at) - offsetAt.offset);\n        if (this.zone.abbr(offsetAt.at).replace(/[^A-Z]/g, '') !== offsetAt.abbr) {\n            this.abbrScore++;\n        }\n    };\n\n    function findChange(low, high) {\n        var mid, diff;\n\n        while ((diff = ((high.at - low.at) / 12e4 | 0) * 6e4)) {\n            mid = new OffsetAt(new Date(low.at + diff));\n            if (mid.offset === low.offset) {\n                low = mid;\n            } else {\n                high = mid;\n            }\n        }\n\n        return low;\n    }\n\n    function userOffsets() {\n        var startYear = new Date().getFullYear() - 2,\n            last = new OffsetAt(new Date(startYear, 0, 1)),\n            offsets = [last],\n            change, next, i;\n\n        for (i = 1; i < 48; i++) {\n            next = new OffsetAt(new Date(startYear, i, 1));\n            if (next.offset !== last.offset) {\n                change = findChange(last, next);\n                offsets.push(change);\n                offsets.push(new OffsetAt(new Date(change.at + 6e4)));\n            }\n            last = next;\n        }\n\n        for (i = 0; i < 4; i++) {\n            offsets.push(new OffsetAt(new Date(startYear + i, 0, 1)));\n            offsets.push(new OffsetAt(new Date(startYear + i, 6, 1)));\n        }\n\n        return offsets;\n    }\n\n    function sortZoneScores (a, b) {\n        if (a.offsetScore !== b.offsetScore) {\n            return a.offsetScore - b.offsetScore;\n        }\n        if (a.abbrScore !== b.abbrScore) {\n            return a.abbrScore - b.abbrScore;\n        }\n        if (a.zone.population !== b.zone.population) {\n            return b.zone.population - a.zone.population;\n        }\n        return b.zone.name.localeCompare(a.zone.name);\n    }\n\n    function addToGuesses (name, offsets) {\n        var i, offset;\n        arrayToInt(offsets);\n        for (i = 0; i < offsets.length; i++) {\n            offset = offsets[i];\n            guesses[offset] = guesses[offset] || {};\n            guesses[offset][name] = true;\n        }\n    }\n\n    function guessesForUserOffsets (offsets) {\n        var offsetsLength = offsets.length,\n            filteredGuesses = {},\n            out = [],\n            i, j, guessesOffset;\n\n        for (i = 0; i < offsetsLength; i++) {\n            guessesOffset = guesses[offsets[i].offset] || {};\n            for (j in guessesOffset) {\n                if (guessesOffset.hasOwnProperty(j)) {\n                    filteredGuesses[j] = true;\n                }\n            }\n        }\n\n        for (i in filteredGuesses) {\n            if (filteredGuesses.hasOwnProperty(i)) {\n                out.push(names[i]);\n            }\n        }\n\n        return out;\n    }\n\n    function rebuildGuess () {\n\n        // use Intl API when available and returning valid time zone\n        try {\n            var intlName = Intl.DateTimeFormat().resolvedOptions().timeZone;\n            if (intlName && intlName.length > 3) {\n                var name = names[normalizeName(intlName)];\n                if (name) {\n                    return name;\n                }\n                logError(\"Moment Timezone found \" + intlName + \" from the Intl api, but did not have that data loaded.\");\n            }\n        } catch (e) {\n            // Intl unavailable, fall back to manual guessing.\n        }\n\n        var offsets = userOffsets(),\n            offsetsLength = offsets.length,\n            guesses = guessesForUserOffsets(offsets),\n            zoneScores = [],\n            zoneScore, i, j;\n\n        for (i = 0; i < guesses.length; i++) {\n            zoneScore = new ZoneScore(getZone(guesses[i]), offsetsLength);\n            for (j = 0; j < offsetsLength; j++) {\n                zoneScore.scoreOffsetAt(offsets[j]);\n            }\n            zoneScores.push(zoneScore);\n        }\n\n        zoneScores.sort(sortZoneScores);\n\n        return zoneScores.length > 0 ? zoneScores[0].zone.name : undefined;\n    }\n\n    function guess (ignoreCache) {\n        if (!cachedGuess || ignoreCache) {\n            cachedGuess = rebuildGuess();\n        }\n        return cachedGuess;\n    }\n\n    /************************************\n     Global Methods\n     ************************************/\n\n    function normalizeName (name) {\n        return (name || '').toLowerCase().replace(/\\//g, '_');\n    }\n\n    function addZone (packed) {\n        var i, name, split, normalized;\n\n        if (typeof packed === \"string\") {\n            packed = [packed];\n        }\n\n        for (i = 0; i < packed.length; i++) {\n            split = packed[i].split('|');\n            name = split[0];\n            normalized = normalizeName(name);\n            zones[normalized] = packed[i];\n            names[normalized] = name;\n            addToGuesses(normalized, split[2].split(' '));\n        }\n    }\n\n    function getZone (name, caller) {\n\n        name = normalizeName(name);\n\n        var zone = zones[name];\n        var link;\n\n        if (zone instanceof Zone) {\n            return zone;\n        }\n\n        if (typeof zone === 'string') {\n            zone = new Zone(zone);\n            zones[name] = zone;\n            return zone;\n        }\n\n        // Pass getZone to prevent recursion more than 1 level deep\n        if (links[name] && caller !== getZone && (link = getZone(links[name], getZone))) {\n            zone = zones[name] = new Zone();\n            zone._set(link);\n            zone.name = names[name];\n            return zone;\n        }\n\n        return null;\n    }\n\n    function getNames () {\n        var i, out = [];\n\n        for (i in names) {\n            if (names.hasOwnProperty(i) && (zones[i] || zones[links[i]]) && names[i]) {\n                out.push(names[i]);\n            }\n        }\n\n        return out.sort();\n    }\n\n    function getCountryNames () {\n        return Object.keys(countries);\n    }\n\n    function addLink (aliases) {\n        var i, alias, normal0, normal1;\n\n        if (typeof aliases === \"string\") {\n            aliases = [aliases];\n        }\n\n        for (i = 0; i < aliases.length; i++) {\n            alias = aliases[i].split('|');\n\n            normal0 = normalizeName(alias[0]);\n            normal1 = normalizeName(alias[1]);\n\n            links[normal0] = normal1;\n            names[normal0] = alias[0];\n\n            links[normal1] = normal0;\n            names[normal1] = alias[1];\n        }\n    }\n\n    function addCountries (data) {\n        var i, country_code, country_zones, split;\n        if (!data || !data.length) return;\n        for (i = 0; i < data.length; i++) {\n            split = data[i].split('|');\n            country_code = split[0].toUpperCase();\n            country_zones = split[1].split(' ');\n            countries[country_code] = new Country(\n                country_code,\n                country_zones\n            );\n        }\n    }\n\n    function getCountry (name) {\n        name = name.toUpperCase();\n        return countries[name] || null;\n    }\n\n    function zonesForCountry(country, with_offset) {\n        country = getCountry(country);\n\n        if (!country) return null;\n\n        var zones = country.zones.sort();\n\n        if (with_offset) {\n            return zones.map(function (zone_name) {\n                var zone = getZone(zone_name);\n                return {\n                    name: zone_name,\n                    offset: zone.utcOffset(new Date())\n                };\n            });\n        }\n\n        return zones;\n    }\n\n    function loadData (data) {\n        addZone(data.zones);\n        addLink(data.links);\n        addCountries(data.countries);\n        tz.dataVersion = data.version;\n    }\n\n    function zoneExists (name) {\n        if (!zoneExists.didShowError) {\n            zoneExists.didShowError = true;\n            logError(\"moment.tz.zoneExists('\" + name + \"') has been deprecated in favor of !moment.tz.zone('\" + name + \"')\");\n        }\n        return !!getZone(name);\n    }\n\n    function needsOffset (m) {\n        var isUnixTimestamp = (m._f === 'X' || m._f === 'x');\n        return !!(m._a && (m._tzm === undefined) && !isUnixTimestamp);\n    }\n\n    function logError (message) {\n        if (typeof console !== 'undefined' && typeof console.error === 'function') {\n            console.error(message);\n        }\n    }\n\n    /************************************\n     moment.tz namespace\n     ************************************/\n\n    function tz (input) {\n        var args = Array.prototype.slice.call(arguments, 0, -1),\n            name = arguments[arguments.length - 1],\n            zone = getZone(name),\n            out  = moment.utc.apply(null, args);\n\n        if (zone && !moment.isMoment(input) && needsOffset(out)) {\n            out.add(zone.parse(out), 'minutes');\n        }\n\n        out.tz(name);\n\n        return out;\n    }\n\n    tz.version      = VERSION;\n    tz.dataVersion  = '';\n    tz._zones       = zones;\n    tz._links       = links;\n    tz._names       = names;\n    tz._countries\t= countries;\n    tz.add          = addZone;\n    tz.link         = addLink;\n    tz.load         = loadData;\n    tz.zone         = getZone;\n    tz.zoneExists   = zoneExists; // deprecated in 0.1.0\n    tz.guess        = guess;\n    tz.names        = getNames;\n    tz.Zone         = Zone;\n    tz.unpack       = unpack;\n    tz.unpackBase60 = unpackBase60;\n    tz.needsOffset  = needsOffset;\n    tz.moveInvalidForward   = true;\n    tz.moveAmbiguousForward = false;\n    tz.countries    = getCountryNames;\n    tz.zonesForCountry = zonesForCountry;\n\n    /************************************\n     Interface with Moment.js\n     ************************************/\n\n    var fn = moment.fn;\n\n    moment.tz = tz;\n\n    moment.defaultZone = null;\n\n    moment.updateOffset = function (mom, keepTime) {\n        var zone = moment.defaultZone,\n            offset;\n\n        if (mom._z === undefined) {\n            if (zone && needsOffset(mom) && !mom._isUTC) {\n                mom._d = moment.utc(mom._a)._d;\n                mom.utc().add(zone.parse(mom), 'minutes');\n            }\n            mom._z = zone;\n        }\n        if (mom._z) {\n            offset = mom._z.utcOffset(mom);\n            if (Math.abs(offset) < 16) {\n                offset = offset / 60;\n            }\n            if (mom.utcOffset !== undefined) {\n                var z = mom._z;\n                mom.utcOffset(-offset, keepTime);\n                mom._z = z;\n            } else {\n                mom.zone(offset, keepTime);\n            }\n        }\n    };\n\n    fn.tz = function (name, keepTime) {\n        if (name) {\n            if (typeof name !== 'string') {\n                throw new Error('Time zone name must be a string, got ' + name + ' [' + typeof name + ']');\n            }\n            this._z = getZone(name);\n            if (this._z) {\n                moment.updateOffset(this, keepTime);\n            } else {\n                logError(\"Moment Timezone has no data for \" + name + \". See http://momentjs.com/timezone/docs/#/data-loading/.\");\n            }\n            return this;\n        }\n        if (this._z) { return this._z.name; }\n    };\n\n    function abbrWrap (old) {\n        return function () {\n            if (this._z) { return this._z.abbr(this); }\n            return old.call(this);\n        };\n    }\n\n    function resetZoneWrap (old) {\n        return function () {\n            this._z = null;\n            return old.apply(this, arguments);\n        };\n    }\n\n    function resetZoneWrap2 (old) {\n        return function () {\n            if (arguments.length > 0) this._z = null;\n            return old.apply(this, arguments);\n        };\n    }\n\n    fn.zoneName  = abbrWrap(fn.zoneName);\n    fn.zoneAbbr  = abbrWrap(fn.zoneAbbr);\n    fn.utc       = resetZoneWrap(fn.utc);\n    fn.local     = resetZoneWrap(fn.local);\n    fn.utcOffset = resetZoneWrap2(fn.utcOffset);\n\n    moment.tz.setDefault = function(name) {\n        if (major < 2 || (major === 2 && minor < 9)) {\n            logError('Moment Timezone setDefault() requires Moment.js >= 2.9.0. You are using Moment.js ' + moment.version + '.');\n        }\n        moment.defaultZone = name ? getZone(name) : null;\n        return moment;\n    };\n\n    // Cloning a moment should include the _z property.\n    var momentProperties = moment.momentProperties;\n    if (Object.prototype.toString.call(momentProperties) === '[object Array]') {\n        // moment 2.8.1+\n        momentProperties.push('_z');\n        momentProperties.push('_a');\n    } else if (momentProperties) {\n        // moment 2.7.0\n        momentProperties._z = null;\n    }\n\n    loadData({\n        \"version\": \"2023c\",\n        \"zones\": [\n            \"Africa/Abidjan|GMT|0|0||48e5\",\n            \"Africa/Nairobi|EAT|-30|0||47e5\",\n            \"Africa/Algiers|WET WEST CET CEST|0 -10 -10 -20|01012320102|3bX0 11A0 dDd0 17b0 11B0 1cN0 2Dy0 1cN0 1fB0 1cL0|26e5\",\n            \"Africa/Lagos|WAT|-10|0||17e6\",\n            \"Africa/Bissau|-01 GMT|10 0|01|cap0|39e4\",\n            \"Africa/Maputo|CAT|-20|0||26e5\",\n            \"Africa/Cairo|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|LX0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1WL0 rd0 1Rz0 wp0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1qL0 Xd0 1oL0 11d0 1oL0 11d0 1pb0 11d0 1oL0 11d0 1oL0 11d0 1ny0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 11z0 1o10 11z0 1o10 WL0 1qN0 Rb0 1wp0 On0 1zd0 Lz0 1EN0 Fb0 c10 8n0 8Nd0 gL0 e10 mn0 kSp0 1cL0 1cN0 1fz0 1a10 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0|15e6\",\n            \"Africa/Casablanca|+00 +01|0 -10|01010101010101010101010101010101010101010101010101010101010101010101010|aS00 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4mn0 SyN0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600|32e5\",\n            \"Africa/Ceuta|WET WEST CET CEST|0 -10 -10 -20|0101010102323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|aS00 rz0 43d0 AL0 1Nd0 XX0 1Cp0 pz0 dEp0 4VB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|85e3\",\n            \"Africa/El_Aaiun|-01 +00 +01|10 0 -10|01212121212121212121212121212121212121212121212121212121212121212121|fi10 6L0 AL0 1Nd0 XX0 1Cp0 pz0 1cBB0 AL0 1Nd0 wn0 1FB0 Db0 1zd0 Lz0 1Nf0 wM0 co0 go0 1o00 s00 dA0 vc0 11A0 A00 e00 y00 11A0 uM0 e00 Dc0 11A0 s00 e00 IM0 WM0 mo0 gM0 LA0 WM0 jA0 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 28M0 e00 2600 gM0 2600 e00 2600 gM0 2600|20e4\",\n            \"Africa/Johannesburg|SAST|-20|0||84e5\",\n            \"Africa/Juba|CAT CAST EAT|-20 -30 -30|01010101010101010101010101010101020|LW0 16L0 1iN0 17b0 1jd0 17b0 1ip0 17z0 1i10 17X0 1hB0 18n0 1hd0 19b0 1gp0 19z0 1iN0 17b0 1ip0 17z0 1i10 18n0 1hd0 18L0 1gN0 19b0 1gp0 19z0 1iN0 17z0 1i10 17X0 yGd0 PeX0|\",\n            \"Africa/Khartoum|CAT CAST EAT|-20 -30 -30|01010101010101010101010101010101020|LW0 16L0 1iN0 17b0 1jd0 17b0 1ip0 17z0 1i10 17X0 1hB0 18n0 1hd0 19b0 1gp0 19z0 1iN0 17b0 1ip0 17z0 1i10 18n0 1hd0 18L0 1gN0 19b0 1gp0 19z0 1iN0 17z0 1i10 17X0 yGd0 HjL0|51e5\",\n            \"Africa/Monrovia|MMT GMT|I.u 0|01|4SoI.u|11e5\",\n            \"Africa/Ndjamena|WAT WAST|-10 -20|010|nNb0 Wn0|13e5\",\n            \"Africa/Sao_Tome|GMT WAT|0 -10|010|1UQN0 2q00|\",\n            \"Africa/Tripoli|EET CET CEST|-20 -10 -20|0121212121212121210120120|tda0 A10 1db0 1cN0 1db0 1dd0 1db0 1eN0 1bb0 1e10 1cL0 1c10 1db0 1dd0 1db0 1cN0 1db0 1q10 fAn0 1ep0 1db0 AKq0 TA0 1o00|11e5\",\n            \"Africa/Tunis|CET CEST|-10 -20|0101010101010101010|hOn0 WM0 1rA0 11c0 nwo0 Ko0 1cM0 1cM0 1rA0 10M0 zuM0 10N0 1aN0 1qM0 WM0 1qM0 11A0 1o00|20e5\",\n            \"Africa/Windhoek|SAST CAT WAT|-20 -20 -10|01212121212121212121212121212121212121212121212121|Ndy0 9Io0 16P0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0|32e4\",\n            \"America/Adak|BST BDT AHST HST HDT|b0 a0 a0 a0 90|0101010101010101010101010101234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|Kd0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|326\",\n            \"America/Anchorage|AHST AHDT YST AKST AKDT|a0 90 90 90 80|0101010101010101010101010101234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|Kc0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cm0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|30e4\",\n            \"America/Puerto_Rico|AST|40|0||24e5\",\n            \"America/Araguaina|-03 -02|30 20|01010101010101010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 ny10 Lz0|14e4\",\n            \"America/Argentina/Buenos_Aires|-03 -02|30 20|01010101010101010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 A4p0 uL0 1qN0 WL0|\",\n            \"America/Argentina/Catamarca|-03 -02 -04|30 20 40|01010101210102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 rlB0 7B0 8zb0 uL0|\",\n            \"America/Argentina/Cordoba|-03 -02 -04|30 20 40|01010101210101010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 A4p0 uL0 1qN0 WL0|\",\n            \"America/Argentina/Jujuy|-03 -02 -04|30 20 40|010101202101010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1ze0 TX0 1ld0 WK0 1wp0 TX0 A4p0 uL0|\",\n            \"America/Argentina/La_Rioja|-03 -02 -04|30 20 40|010101012010102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 rlB0 7B0 8zb0 uL0|\",\n            \"America/Argentina/Mendoza|-03 -02 -04|30 20 40|01010120202102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1u20 SL0 1vd0 Tb0 1wp0 TW0 ri10 Op0 7TX0 uL0|\",\n            \"America/Argentina/Rio_Gallegos|-03 -02 -04|30 20 40|01010101010102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 rlB0 7B0 8zb0 uL0|\",\n            \"America/Argentina/Salta|-03 -02 -04|30 20 40|010101012101010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 A4p0 uL0|\",\n            \"America/Argentina/San_Juan|-03 -02 -04|30 20 40|010101012010102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Qn0 qO0 16n0 Rb0 1wp0 TX0 rld0 m10 8lb0 uL0|\",\n            \"America/Argentina/San_Luis|-03 -02 -04|30 20 40|010101202020102020|9Rf0 Db0 zvd0 Bz0 1tB0 XX0 1q20 SL0 AN0 vDb0 m10 8lb0 8L0 jd0 1qN0 WL0 1qN0|\",\n            \"America/Argentina/Tucuman|-03 -02 -04|30 20 40|0101010121010201010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wq0 Ra0 1wp0 TX0 rlB0 4N0 8BX0 uL0 1qN0 WL0|\",\n            \"America/Argentina/Ushuaia|-03 -02 -04|30 20 40|01010101010102010|9Rf0 Db0 zvd0 Bz0 1tB0 TX0 1wp0 Rb0 1wp0 Rb0 1wp0 TX0 rkN0 8p0 8zb0 uL0|\",\n            \"America/Asuncion|-04 -03|40 30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|6FE0 3CL0 3Dd0 10L0 1pB0 10n0 1pB0 10n0 1pB0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1dd0 1cL0 1dd0 1cL0 1dd0 1db0 1dd0 1cL0 1lB0 14n0 1dd0 1cL0 1fd0 WL0 1rd0 1aL0 1dB0 Xz0 1qp0 Xb0 1qN0 10L0 1rB0 TX0 1tB0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 1cL0 WN0 1qL0 11B0 1nX0 1ip0 WL0 1qN0 WL0 1qN0 WL0 1tB0 TX0 1tB0 TX0 1tB0 19X0 1a10 1fz0 1a10 1fz0 1cN0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1fB0 19X0 1fB0 19X0 1ip0 17b0 1ip0|28e5\",\n            \"America/Panama|EST|50|0||15e5\",\n            \"America/Bahia_Banderas|PST MST MDT CDT CST|80 70 60 50 60|01212121212121212121212121212134343434343434343434343434|80 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nW0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|84e3\",\n            \"America/Bahia|-03 -02|30 20|010101010101010101010101010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 l5B0 Rb0|27e5\",\n            \"America/Barbados|AST ADT|40 30|010101010|i7G0 IL0 1ip0 17b0 1ip0 17b0 1ld0 13b0|28e4\",\n            \"America/Belem|-03 -02|30 20|0101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0|20e5\",\n            \"America/Belize|CST CDT|60 50|01010|9xG0 qn0 lxB0 mn0|57e3\",\n            \"America/Boa_Vista|-04 -03|40 30|01010101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 smp0 WL0 1tB0 2L0|62e2\",\n            \"America/Bogota|-05 -04|50 40|010|Snh0 1PX0|90e5\",\n            \"America/Boise|MST MDT|70 60|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 Dd0 1Kn0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e4\",\n            \"America/Cambridge_Bay|MST MDT CST CDT EST|70 60 60 50 50|010101010101010101010101010101010101010101010101010101012342101010101010101010101010101010101010101010101010101010101010|5E90 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11A0 1nX0 2K0 WQ0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e2\",\n            \"America/Campo_Grande|-04 -03|40 30|010101010101010101010101010101010101010101010101010101010101010101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1HB0 FX0|77e4\",\n            \"America/Cancun|CST EST EDT CDT|60 50 40 50|012121230303030303030303030303030303030301|t9G0 yLB0 1lb0 14p0 1lb0 14p0 Lz0 xB0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 Dd0|63e4\",\n            \"America/Caracas|-04 -0430|40 4u|010|1wmv0 kqo0|29e5\",\n            \"America/Cayenne|-03|30|0||58e3\",\n            \"America/Chicago|CST CDT|60 50|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K80 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|92e5\",\n            \"America/Chihuahua|CST CDT MDT MST|60 50 60 70|0101023232323232323232323232323232323232323232323232320|13Vk0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|81e4\",\n            \"America/Ciudad_Juarez|CST CDT MDT MST|60 50 60 70|010102323232323232323232323232323232323232323232323232032323232323232323|13Vk0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1wn0 cm0 EP0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Costa_Rica|CST CDT|60 50|010101010|mgS0 Db0 1Kp0 Db0 pRB0 15b0 1kp0 mL0|12e5\",\n            \"America/Phoenix|MST|70|0||42e5\",\n            \"America/Cuiaba|-04 -03|40 30|0101010101010101010101010101010101010101010101010101010101010101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 4a10 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1HB0 FX0|54e4\",\n            \"America/Danmarkshavn|-03 -02 GMT|30 20 0|0101010101010101010101010101010102|oXh0 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 DC0|8\",\n            \"America/Dawson_Creek|PST PDT MST|80 70 70|0101012|Ka0 1cL0 1cN0 1fz0 1cN0 ML0|12e3\",\n            \"America/Dawson|YST PST PDT MST|90 80 70 70|012121212121212121212121212121212121212121212121212121212121212121212121212121212123|9ix0 fNd0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1z90|13e2\",\n            \"America/Denver|MST MDT|70 60|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e5\",\n            \"America/Detroit|EST EDT|50 40|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|85H0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e5\",\n            \"America/Edmonton|MST MDT|70 60|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|5E90 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|10e5\",\n            \"America/Eirunepe|-05 -04|50 40|01010101010|CxF0 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0 yTd0 d5X0|31e3\",\n            \"America/El_Salvador|CST CDT|60 50|01010|Gcu0 WL0 1qN0 WL0|11e5\",\n            \"America/Tijuana|PST PDT|80 70|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|fmy0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|20e5\",\n            \"America/Fort_Nelson|PST PDT MST|80 70 70|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010102|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0|39e2\",\n            \"America/Fort_Wayne|EST EDT|50 40|01010101010101010101010101010101010101010101010101010|K70 1cL0 1qhd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Fortaleza|-03 -02|30 20|01010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 5z0 2mN0 On0|34e5\",\n            \"America/Glace_Bay|AST ADT|40 30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|5E60 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|19e3\",\n            \"America/Godthab|-03 -02 -01|30 20 10|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010121212121212121|oXh0 19U0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 2so0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|17e3\",\n            \"America/Goose_Bay|AST ADT ADDT|40 30 20|010101010101010101010101010101010101020101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K60 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|76e2\",\n            \"America/Grand_Turk|EST EDT AST|50 40 40|0101010101010101010101010101010101010101010101010101010101010101010101010210101010101010101010101010|mG70 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 7jA0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|37e2\",\n            \"America/Guatemala|CST CDT|60 50|010101010|9tG0 An0 mtd0 Nz0 ifB0 17b0 zDB0 11z0|13e5\",\n            \"America/Guayaquil|-05 -04|50 40|010|TKR0 rz0|27e5\",\n            \"America/Guyana|-0345 -03 -04|3J 30 40|012|dzfJ Ey0f|80e4\",\n            \"America/Halifax|AST ADT|40 30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K60 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|39e4\",\n            \"America/Havana|CST CDT|50 40|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K50 1cL0 1cN0 1fz0 1cN0 14n0 1ld0 14L0 1kN0 15b0 1kp0 1cL0 1cN0 1fz0 1a10 1fz0 1fB0 11z0 14p0 1nX0 11B0 1nX0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 1a10 1in0 1a10 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 17c0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 11A0 6i00 Rc0 1wo0 U00 1tA0 Rc0 1wo0 U00 1wo0 U00 1zc0 U00 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0|21e5\",\n            \"America/Hermosillo|PST MST MDT|80 70 60|01212121|80 13Vd0 1lb0 14p0 1lb0 14p0 1lb0|64e4\",\n            \"America/Indiana/Knox|CST CDT EST|60 50 50|01010101010101010101010101010101010101010101210101010101010101010101010101010101010101010101010|K80 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 z8o0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Marengo|EST EDT CDT|50 40 50|010101010201010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1e6p0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Petersburg|CST CDT EST EDT|60 50 50 40|0101010101010101210123232323232323232323232323232323232323232323232|K80 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 19co0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Tell_City|EST EDT CDT CST|50 40 50 60|01023232323232323232323232323232323232323232323232323|K70 1cL0 1qhd0 1o00 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Vevay|EST EDT|50 40|010101010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1lnd0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Vincennes|EST EDT CDT CST|50 40 50 60|01023201010101010101010101010101010101010101010101010|K70 1cL0 1qhd0 1o00 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Indiana/Winamac|EST EDT CDT CST|50 40 50 60|01023101010101010101010101010101010101010101010101010|K70 1cL0 1qhd0 1o00 Rd0 1za0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Inuvik|PST PDT MDT MST|80 70 60 70|01010101010101023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323|5Ea0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cK0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|35e2\",\n            \"America/Iqaluit|EST EDT CST CDT|50 40 60 50|01010101010101010101010101010101010101010101010101010101230101010101010101010101010101010101010101010101010101010101010|5E70 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11C0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|67e2\",\n            \"America/Jamaica|EST EDT|50 40|010101010101010101010|9Kv0 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0|94e4\",\n            \"America/Juneau|PST PDT YDT YST AKST AKDT|80 70 80 90 90 80|0101010101010101010102010101345454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cM0 1cM0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|33e3\",\n            \"America/Kentucky/Louisville|EST EDT CDT|50 40 50|010101010201010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1VA0 LA0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Kentucky/Monticello|CST CDT EST EDT|60 50 50 40|010101010101010101010101010101010101010101010101010101010101012323232323232323232323232323232323232323232323232323232323232|K80 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11A0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/La_Paz|-04|40|0||19e5\",\n            \"America/Lima|-05 -04|50 40|010101010|CVF0 zX0 1O10 zX0 6Gp0 zX0 98p0 zX0|11e6\",\n            \"America/Los_Angeles|PST PDT|80 70|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|15e6\",\n            \"America/Maceio|-03 -02|30 20|0101010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 dMN0 Lz0 8Q10 WL0 1tB0 5z0 2mN0 On0|93e4\",\n            \"America/Managua|CST EST CDT|60 50 50|010202010102020|86u0 4mn0 9Up0 Dz0 1K10 Dz0 s3F0 1KH0 DB0 9In0 k8p0 19X0 1o30 11y0|22e5\",\n            \"America/Manaus|-04 -03|40 30|010101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 dPB0 On0|19e5\",\n            \"America/Martinique|AST ADT|40 30|010|oXg0 19X0|39e4\",\n            \"America/Matamoros|CST CDT|60 50|0101010101010101010101010101010101010101010101010101010101010101010101010|IqU0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|45e4\",\n            \"America/Mazatlan|PST MST MDT|80 70 60|01212121212121212121212121212121212121212121212121212121|80 13Vd0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|44e4\",\n            \"America/Menominee|EST CDT CST|50 50 60|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212|85H0 1cM0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|85e2\",\n            \"America/Merida|CST EST CDT|60 50 50|010202020202020202020202020202020202020202020202020202020|t9G0 2hz0 wu30 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|11e5\",\n            \"America/Metlakatla|PST PDT AKST AKDT|80 70 90 80|0101010101010101010101010101023232302323232323232323232323232|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1hU10 Rd0 1zb0 Op0 1zb0 Op0 1zb0 uM0 jB0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|14e2\",\n            \"America/Mexico_City|CST CDT|60 50|0101010101010101010101010101010101010101010101010101010|13Vk0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|20e6\",\n            \"America/Miquelon|AST -03 -02|40 30 20|012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|p9g0 gQ10 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|61e2\",\n            \"America/Moncton|AST ADT|40 30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K60 1cL0 1cN0 1fz0 1cN0 1cL0 3Cp0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14n1 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 ReX 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|64e3\",\n            \"America/Monterrey|CST CDT|60 50|010101010101010101010101010101010101010101010101010101010|IqU0 1nX0 i6p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0|41e5\",\n            \"America/Montevideo|-03 -02 -0130 -0230|30 20 1u 2u|0101023010101010101010101010101010101010101010101010|JD0 jX0 4vB0 xz0 3Cp0 mmu 1a10 IMu Db0 4c10 uL0 1Nd0 An0 1SN0 uL0 mp0 28L0 iPB0 un0 1SN0 xz0 1zd0 Lz0 1zd0 Rb0 1zd0 On0 1wp0 Rb0 s8p0 1fB0 1ip0 11z0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 14n0 1ld0 14n0 1ld0 14n0 1o10 11z0 1o10 11z0 1o10 11z0|17e5\",\n            \"America/Toronto|EST EDT|50 40|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e5\",\n            \"America/New_York|EST EDT|50 40|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K70 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|21e6\",\n            \"America/Nome|BST BDT YST AKST AKDT|b0 a0 90 90 80|0101010101010101010101010101234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|Kd0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cl0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|38e2\",\n            \"America/Noronha|-02 -01|20 10|01010101010101010|CxC0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|30e2\",\n            \"America/North_Dakota/Beulah|MST MDT CST CDT|70 60 60 50|010101010101010101010101010101010101010101010101010101010101010101010101010101010123232323232323232323232323232323232323232|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Oo0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/North_Dakota/Center|MST MDT CST CDT|70 60 60 50|010101010101010101010101010101010101010101010123232323232323232323232323232323232323232323232323232323232323232323232323232|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/North_Dakota/New_Salem|MST MDT CST CDT|70 60 60 50|010101010101010101010101010101010101010101010101010101010101010101012323232323232323232323232323232323232323232323232323232|K90 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14o0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|\",\n            \"America/Ojinaga|CST CDT MDT MST|60 50 60 70|01010232323232323232323232323232323232323232323232323201010101010101010|13Vk0 1lb0 14p0 1lb0 14q0 1lb0 14p0 1nX0 11B0 1nX0 1fB0 WL0 1fB0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 U10 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1wn0 Rc0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e3\",\n            \"America/Paramaribo|-0330 -03|3u 30|01|zSPu|24e4\",\n            \"America/Port-au-Prince|EST EDT|50 40|01010101010101010101010101010101010101010101010101010101010101010101010|wu50 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14q0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 i6n0 1nX0 11B0 1nX0 d430 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 3iN0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\n            \"America/Rio_Branco|-05 -04|50 40|010101010|CxF0 Rb0 1tB0 IL0 1Fd0 FX0 NBd0 d5X0|31e4\",\n            \"America/Porto_Velho|-04 -03|40 30|0101010|CxE0 Rb0 1tB0 IL0 1Fd0 FX0|37e4\",\n            \"America/Punta_Arenas|-03 -04|30 40|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|yP0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0|\",\n            \"America/Winnipeg|CST CDT|60 50|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K80 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1a00 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1o00 14o0 1lc0 14o0 1lc0 14o0 1o00 11A0 1o00 11A0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|66e4\",\n            \"America/Rankin_Inlet|CST CDT EST|60 50 50|01010101010101010101010101010101010101010101010101010101012101010101010101010101010101010101010101010101010101010101010|5E80 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|26e2\",\n            \"America/Recife|-03 -02|30 20|01010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 nsp0 WL0 1tB0 2L0 2pB0 On0|33e5\",\n            \"America/Regina|CST|60|0||19e4\",\n            \"America/Resolute|CST CDT EST|60 50 50|01010101010101010101010101010101010101010101010101010101012101010101012101010101010101010101010101010101010101010101010|5E80 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|229\",\n            \"America/Santarem|-04 -03|40 30|01010101|CxE0 Rb0 1tB0 IL0 1Fd0 FX0 NBd0|21e4\",\n            \"America/Santiago|-03 -04|30 40|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|yP0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1zb0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0|62e5\",\n            \"America/Santo_Domingo|-0430 EST AST|4u 50 40|0101010101212|ksu 1Cou yLu 1RAu wLu 1QMu xzu 1Q0u xXu 1PAu 13jB0 e00|29e5\",\n            \"America/Sao_Paulo|-03 -02|30 20|010101010101010101010101010101010101010101010101010101010101010101010|CxD0 Rb0 1tB0 IL0 1Fd0 FX0 1EN0 FX0 1HB0 Lz0 1EN0 Lz0 1C10 IL0 1HB0 Db0 1HB0 On0 1zd0 On0 1zd0 Lz0 1zd0 Rb0 1wN0 Wn0 1tB0 Rb0 1tB0 WL0 1tB0 Rb0 1zd0 On0 1HB0 FX0 1C10 Lz0 1Ip0 HX0 1zd0 On0 1HB0 IL0 1wp0 On0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 Rb0 1zd0 Lz0 1C10 Lz0 1C10 On0 1zd0 On0 1zd0 On0 1zd0 On0 1HB0 FX0|20e6\",\n            \"America/Scoresbysund|-02 -01 +00|20 10 0|0102121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121|oXg0 1a00 1cK0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|452\",\n            \"America/Sitka|PST PDT YST AKST AKDT|80 70 90 90 80|0101010101010101010101010101234343434343434343434343434343434343434343434343434343434343434343434343434343434343434343434343|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 co0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|90e2\",\n            \"America/St_Johns|NST NDT NDDT|3u 2u 1u|010101010101010101010101010101010101020101010101010101010101010101010101010101010101010101010101010101010101010101010101010|K5u 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14n1 1lb0 14p0 1nW0 11C0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zcX Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|11e4\",\n            \"America/Swift_Current|MST CST|70 60|01|5E90|16e3\",\n            \"America/Tegucigalpa|CST CDT|60 50|0101010|Gcu0 WL0 1qN0 WL0 GRd0 AL0|11e5\",\n            \"America/Thule|AST ADT|40 30|010101010101010101010101010101010101010101010101010101010101010101010101010101010|PHG0 1cL0 1cN0 1cL0 1fB0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|656\",\n            \"America/Vancouver|PST PDT|80 70|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|Ka0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|23e5\",\n            \"America/Whitehorse|PST PDT MST|80 70 70|01010101010101010101010101010101010101010101010101010101010101010101010101010101012|p7K0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1z90|23e3\",\n            \"America/Yakutat|YST YDT AKST AKDT|90 80 90 80|0101010101010101010101010101023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232|Kb0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 s10 1Vz0 LB0 1BX0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 cn0 10q0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|642\",\n            \"Antarctica/Casey|+08 +11|-80 -b0|010101010101|1ARS0 T90 40P0 KL0 blz0 3m10 1o30 14k0 1kr0 12l0 1o01|10\",\n            \"Antarctica/Davis|+07 +05|-70 -50|01010|1ART0 VB0 3Wn0 KN0|70\",\n            \"Pacific/Port_Moresby|+10|-a0|0||25e4\",\n            \"Antarctica/Macquarie|AEDT AEST|-b0 -a0|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|qg0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 3Co0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|1\",\n            \"Antarctica/Mawson|+06 +05|-60 -50|01|1ARU0|60\",\n            \"Pacific/Auckland|NZST NZDT|-c0 -d0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|bKC0 IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00|14e5\",\n            \"Antarctica/Palmer|-03 -02 -04|30 20 40|01020202020202020202020202020202020202020202020202020202020202020202020|9Rf0 Db0 jsN0 14N0 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0|40\",\n            \"Antarctica/Rothera|-00 -03|0 30|01|gOo0|130\",\n            \"Asia/Riyadh|+03|-30|0||57e5\",\n            \"Antarctica/Troll|-00 +00 +02|0 0 -20|012121212121212121212121212121212121212121212121212121|1puo0 hd0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|40\",\n            \"Asia/Urumqi|+06|-60|0||32e5\",\n            \"Europe/Berlin|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|oXd0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|41e5\",\n            \"Asia/Almaty|+06 +07 +05|-60 -70 -50|0101010101010101010102010101010101010101010101010|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|15e5\",\n            \"Asia/Amman|EET EEST +03|-20 -30 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101012|8kK0 KL0 1oN0 11b0 1oN0 11b0 1pd0 1dz0 1cp0 11b0 1op0 11b0 fO10 1db0 1e10 1cL0 1cN0 1cL0 1cN0 1fz0 1pd0 10n0 1ld0 14n0 1hB0 15b0 1ip0 19X0 1cN0 1cL0 1cN0 17b0 1ld0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1So0 y00 1fc0 1dc0 1co0 1dc0 1cM0 1cM0 1cM0 1o00 11A0 1lc0 17c0 1cM0 1cM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 4bX0 Dd0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 LA0 1C00|25e5\",\n            \"Asia/Anadyr|+13 +14 +12 +11|-d0 -e0 -c0 -b0|010202020202020202023202020202020202020202020202020202020232|rmX0 1db0 2q10 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|13e3\",\n            \"Asia/Aqtau|+05 +06 +04|-50 -60 -40|0101010101010101010201010120202020202020202020|sAj0 2pX0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|15e4\",\n            \"Asia/Aqtobe|+05 +06 +04|-50 -60 -40|01010101010101010102010101010101010101010101010|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0|27e4\",\n            \"Asia/Ashgabat|+05 +06 +04|-50 -60 -40|01010101010101010101020|rn70 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0|41e4\",\n            \"Asia/Atyrau|+05 +06 +04|-50 -60 -40|010101010101010101020101010101010102020202020|sAj0 2pX0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 2sp0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|\",\n            \"Asia/Baghdad|+03 +04|-30 -40|01010101010101010101010101010101010101010101010101010|u190 11b0 1cp0 1dz0 1dd0 1db0 1cN0 1cp0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1de0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0 1dc0 1dc0 1cM0 1dc0 1cM0 1dc0 1cM0 1dc0|66e5\",\n            \"Asia/Qatar|+04 +03|-40 -30|01|5QI0|96e4\",\n            \"Asia/Baku|+04 +05 +03|-40 -50 -30|010101010101010101010201010101010101010101010101010101010101010|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 1cM0 9Je0 1o00 11z0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00|27e5\",\n            \"Asia/Bangkok|+07|-70|0||15e6\",\n            \"Asia/Barnaul|+07 +08 +06|-70 -80 -60|01010101010101010101020101010102020202020202020202020202020202020|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 p90 LE0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|\",\n            \"Asia/Beirut|EET EEST|-20 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|61a0 En0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1op0 11b0 dA10 17b0 1iN0 17b0 1iN0 17b0 1iN0 17b0 1vB0 SL0 1mp0 13z0 1iN0 17b0 1iN0 17b0 1jd0 12n0 1a10 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0|22e5\",\n            \"Asia/Bishkek|+06 +07 +05|-60 -70 -50|0101010101010101010102020202020202020202020202020|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2e00 1tX0 17b0 1ip0 17b0 1ip0 17b0 1ip0 17b0 1ip0 19X0 1cPu 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0|87e4\",\n            \"Asia/Brunei|+08|-80|0||42e4\",\n            \"Asia/Kolkata|IST|-5u|0||15e6\",\n            \"Asia/Chita|+09 +10 +08|-90 -a0 -80|0101010101010101010102010101010101010101010101010101010101010120|rn30 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3re0|33e4\",\n            \"Asia/Choibalsan|+07 +08 +10 +09|-70 -80 -a0 -90|012323232323232323232323232323232323232323232313131|jsF0 cKn0 1da0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 3Db0 h1f0 1cJ0 1cP0 1cJ0|38e3\",\n            \"Asia/Shanghai|CST CDT|-80 -90|0101010101010|DKG0 Rb0 1o10 11z0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0|23e6\",\n            \"Asia/Colombo|+0530 +0630 +06|-5u -6u -60|0120|14giu 11zu n3cu|22e5\",\n            \"Asia/Dhaka|+06 +07|-60 -70|010|1A5R0 1i00|16e6\",\n            \"Asia/Damascus|EET EEST +03|-20 -30 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101012|M00 11b0 1oN0 11b0 1pd0 11b0 1oN0 11b0 1oN0 11b0 1oN0 11b0 1pd0 11b0 1oN0 Nb0 1AN0 Nb0 bcp0 19X0 1gp0 19X0 3ld0 1xX0 Vd0 1Bz0 Sp0 1vX0 10p0 1dz0 1cN0 1cL0 1db0 1db0 1g10 1an0 1ap0 1db0 1fd0 1db0 1cN0 1db0 1dd0 1db0 1cp0 1dz0 1c10 1dX0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 1db0 1cN0 1db0 1dd0 1db0 1cN0 1db0 1cN0 19z0 1fB0 1qL0 11B0 1on0 Wp0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0|26e5\",\n            \"Asia/Dili|+09 +08|-90 -80|010|fpr0 Xld0|19e4\",\n            \"Asia/Dubai|+04|-40|0||39e5\",\n            \"Asia/Dushanbe|+06 +07 +05|-60 -70 -50|0101010101010101010102|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2hB0|76e4\",\n            \"Asia/Famagusta|EET EEST +03|-20 -30 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101012010101010101010101010101010|cPa0 1cL0 1qp0 Xz0 19B0 19X0 1fB0 1db0 1cp0 1cL0 1fB0 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1o30 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 15U0 2Ks0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|\",\n            \"Asia/Gaza|IST IDT EET EEST|-20 -30 -20 -30|010101010101010101010101010101023232323232323232323232323232323232323232323232323232323232323232323232|aXa0 Db0 1fB0 Rb0 bXB0 gM0 8Q00 IM0 1wo0 TX0 1HB0 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 11z0 1o10 14o0 1lA1 SKX 1xd1 MKX 1AN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nA0 1210 1qL0 WN0 1qL0 WN0 1qL0 11c0 1on0 11B0 1o00 11A0 1qo0 XA0 1qp0 1cN0 1cL0 17d0 1in0 14p0 1lb0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0|18e5\",\n            \"Asia/Hebron|IST IDT EET EEST|-20 -30 -20 -30|01010101010101010101010101010102323232323232323232323232323232323232323232323232323232323232323232323232|aXa0 Db0 1fB0 Rb0 bXB0 gM0 8Q00 IM0 1wo0 TX0 1HB0 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 M10 C00 17c0 1io0 17c0 1io0 17c0 1o00 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 17c0 1io0 18N0 1bz0 19z0 1gp0 1610 1iL0 12L0 1mN0 14o0 1lc0 Tb0 1xd1 MKX bB0 cn0 1cN0 1a00 1fA0 1cL0 1cN0 1nX0 1210 1nA0 1210 1qL0 WN0 1qL0 WN0 1qL0 11c0 1on0 11B0 1o00 11A0 1qo0 XA0 1qp0 1cN0 1cL0 17d0 1in0 14p0 1lb0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0|25e4\",\n            \"Asia/Ho_Chi_Minh|+08 +07|-80 -70|01|dfs0|90e5\",\n            \"Asia/Hong_Kong|HKT HKST|-80 -90|01010101010101010|H7u 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1cL0 6fd0 14n0|73e5\",\n            \"Asia/Hovd|+06 +07 +08|-60 -70 -80|01212121212121212121212121212121212121212121212121|jsG0 cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0|81e3\",\n            \"Asia/Irkutsk|+08 +09 +07|-80 -90 -70|010101010101010101010201010101010101010101010101010101010101010|rn40 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\n            \"Europe/Istanbul|EET EEST +03 +04|-20 -30 -30 -40|01010101010123201010101010101010101010101010101010101010101010101010101010101012|8jz0 11A0 WN0 1qL0 TB0 1tX0 U10 1tz0 11B0 1in0 17d0 z90 cne0 pb0 2Cp0 1800 14o0 1dc0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1a00 1fA0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WO0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 Xc0 1qo0 WM0 1qM0 11A0 1o00 1200 1nA0 11A0 1tA0 U00 15w0|13e6\",\n            \"Asia/Jakarta|WIB|-70|0||31e6\",\n            \"Asia/Jayapura|WIT|-90|0||26e4\",\n            \"Asia/Jerusalem|IST IDT|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|aXa0 Db0 1fB0 Rb0 bXB0 gM0 8Q00 IM0 1wo0 TX0 1HB0 IL0 1s10 10n0 1o10 WL0 1zd0 On0 1ld0 11z0 1o10 14n0 1o10 14n0 1nd0 12n0 1nd0 Xz0 1q10 12n0 1hB0 1dX0 1ep0 1aL0 1eN0 17X0 1nf0 11z0 1tB0 19W0 1e10 17b0 1ep0 1gL0 18N0 1fz0 1eN0 17b0 1gq0 1gn0 19d0 1dz0 1c10 17X0 1hB0 1gn0 19d0 1dz0 1c10 17X0 1kp0 1dz0 1c10 1aL0 1eN0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0 10N0 1oL0 10N0 1oL0 10N0 1rz0 W10 1rz0 W10 1rz0 10N0 1oL0|81e4\",\n            \"Asia/Kabul|+0430|-4u|0||46e5\",\n            \"Asia/Kamchatka|+12 +13 +11|-c0 -d0 -b0|0101010101010101010102010101010101010101010101010101010101020|rn00 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|18e4\",\n            \"Asia/Karachi|+05 PKT PKST|-50 -50 -60|01212121|2Xv0 1fy00 1cL0 dK10 11b0 1610 1jX0|24e6\",\n            \"Asia/Kathmandu|+0530 +0545|-5u -5J|01|CVuu|12e5\",\n            \"Asia/Khandyga|+09 +10 +08 +11|-90 -a0 -80 -b0|01010101010101010101020101010101010101010101010131313131313131310|rn30 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 qK0 yN0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|66e2\",\n            \"Asia/Krasnoyarsk|+07 +08 +06|-70 -80 -60|010101010101010101010201010101010101010101010101010101010101010|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|10e5\",\n            \"Asia/Kuala_Lumpur|+0730 +08|-7u -80|01|td40|71e5\",\n            \"Asia/Macau|CST CDT|-80 -90|01010101010101010|H7u 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 s10 1Vz0 1cN0 1cL0 1cN0 1cL0 6fd0 14n0|57e4\",\n            \"Asia/Magadan|+11 +12 +10|-b0 -c0 -a0|0101010101010101010102010101010101010101010101010101010101010120|rn10 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Cq0|95e3\",\n            \"Asia/Makassar|WITA|-80|0||15e5\",\n            \"Asia/Manila|PST PDT|-80 -90|010|k0E0 1db0|24e6\",\n            \"Asia/Nicosia|EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|cPa0 1cL0 1qp0 Xz0 19B0 19X0 1fB0 1db0 1cp0 1cL0 1fB0 19X0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1o30 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|32e4\",\n            \"Asia/Novokuznetsk|+07 +08 +06|-70 -80 -60|0101010101010101010102010101010101010101010101010101010101020|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|55e4\",\n            \"Asia/Novosibirsk|+07 +08 +06|-70 -80 -60|01010101010101010101020101020202020202020202020202020202020202020|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 ml0 Os0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 4eN0|15e5\",\n            \"Asia/Omsk|+06 +07 +05|-60 -70 -50|010101010101010101010201010101010101010101010101010101010101010|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|12e5\",\n            \"Asia/Oral|+05 +06 +04|-50 -60 -40|010101010101010202020202020202020202020202020|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 1cM0 IM0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|27e4\",\n            \"Asia/Pontianak|WITA WIB|-80 -70|01|HNs0|23e4\",\n            \"Asia/Pyongyang|KST KST|-90 -8u|010|1P4D0 6BA0|29e5\",\n            \"Asia/Qostanay|+05 +06 +04|-50 -60 -40|0101010101010101010201010101010101010101010101|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0|\",\n            \"Asia/Qyzylorda|+05 +06|-50 -60|010101010101010101010101010101010101010101010|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 3ao0 1EM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 zQl0|73e4\",\n            \"Asia/Rangoon|+0630|-6u|0||48e5\",\n            \"Asia/Sakhalin|+11 +12 +10|-b0 -c0 -a0|010101010101010101010201010101010202020202020202020202020202020|rn10 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 2pB0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|58e4\",\n            \"Asia/Samarkand|+05 +06|-50 -60|010101010101010101010|rn70 3Db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|36e4\",\n            \"Asia/Seoul|KST KDT|-90 -a0|01010|Gf50 11A0 1o00 11A0|23e6\",\n            \"Asia/Srednekolymsk|+11 +12 +10|-b0 -c0 -a0|010101010101010101010201010101010101010101010101010101010101010|rn10 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|35e2\",\n            \"Asia/Taipei|CST CDT|-80 -90|0101010|akg0 1db0 1cN0 1db0 97B0 AL0|74e5\",\n            \"Asia/Tashkent|+06 +07 +05|-60 -70 -50|0101010101010101010102|rn60 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0|23e5\",\n            \"Asia/Tbilisi|+04 +05 +03|-40 -50 -30|01010101010101010101020202010101010101010101020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 1cK0 1cL0 1cN0 1cL0 1cN0 2pz0 1cL0 1fB0 3Nz0 11B0 1nX0 11B0 1qL0 WN0 1qL0 WN0 1qL0 11B0 1nX0 11B0 1nX0 11B0 An0 Os0 WM0|11e5\",\n            \"Asia/Tehran|+0330 +0430 +04 +05|-3u -4u -40 -50|0123201010101010101010101010101010101010101010101010101010101010101010|hyHu 1pc0 120u Rc0 XA0 Wou JX0 1dB0 1en0 pNB0 UL0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 64p0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0 1cp0 1dz0 1cp0 1dz0 1cN0 1dz0 1cp0 1dz0|14e6\",\n            \"Asia/Thimphu|+0530 +06|-5u -60|01|HcGu|79e3\",\n            \"Asia/Tokyo|JST|-90|0||38e6\",\n            \"Asia/Tomsk|+07 +08 +06|-70 -80 -60|01010101010101010101020101010101010101010101020202020202020202020|rn50 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 co0 1bB0 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3Qp0|10e5\",\n            \"Asia/Ulaanbaatar|+07 +08 +09|-70 -80 -90|01212121212121212121212121212121212121212121212121|jsF0 cKn0 1db0 1dd0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 6hD0 11z0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 kEp0 1cJ0 1cP0 1cJ0|12e5\",\n            \"Asia/Ust-Nera|+09 +12 +11 +10|-90 -c0 -b0 -a0|0121212121212121212123212121212121212121212121212121212121212123|rn30 1d90 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 17V0 7zD0|65e2\",\n            \"Asia/Vladivostok|+10 +11 +09|-a0 -b0 -90|010101010101010101010201010101010101010101010101010101010101010|rn20 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|60e4\",\n            \"Asia/Yakutsk|+09 +10 +08|-90 -a0 -80|010101010101010101010201010101010101010101010101010101010101010|rn30 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|28e4\",\n            \"Asia/Yekaterinburg|+05 +06 +04|-50 -60 -40|010101010101010101010201010101010101010101010101010101010101010|rn70 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|14e5\",\n            \"Asia/Yerevan|+04 +05 +03|-40 -50 -30|01010101010101010101020202020101010101010101010101010101010|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 2pB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 4RX0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0|13e5\",\n            \"Atlantic/Azores|-01 +00 WET|10 0 0|0101010101010101010101010101010121010101010101010101010101010101010101010101010101010101010101010101010101010|hAN0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cL0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|25e4\",\n            \"Atlantic/Bermuda|AST ADT|40 30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|avi0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1fz0 1a10 1fz0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 14p0 1lb0 14p0 1nX0 11B0 1nX0 11B0 1nX0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0 Rd0 1zb0 Op0 1zb0 Op0 1zb0 Op0 1zb0|65e3\",\n            \"Atlantic/Canary|WET WEST|0 -10|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|oXc0 1a10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|54e4\",\n            \"Atlantic/Cape_Verde|-02 -01|20 10|01|elE0|50e4\",\n            \"Atlantic/Faroe|WET WEST|0 -10|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|rm10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|49e3\",\n            \"Atlantic/Madeira|WET WEST|0 -10|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hAM0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|27e4\",\n            \"Atlantic/South_Georgia|-02|20|0||30\",\n            \"Atlantic/Stanley|-04 -03 -02|40 30 20|01212101010101010101010101010101010101010101010101010101|wrg0 WL0 1qL0 U10 1tz0 2mN0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 U10 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1tz0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qL0 WN0 1qN0 U10 1wn0 Rd0 1wn0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1tz0 U10 1wn0 U10 1tz0 U10 1tz0 U10|21e2\",\n            \"Australia/Sydney|AEST AEDT|-a0 -b0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4r40 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|40e5\",\n            \"Australia/Adelaide|ACST ACDT|-9u -au|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4r4u LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 WM0 1qM0 Rc0 1zc0 U00 1tA0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|11e5\",\n            \"Australia/Brisbane|AEST AEDT|-a0 -b0|010101010|4r40 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0|20e5\",\n            \"Australia/Broken_Hill|ACST ACDT|-9u -au|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4r4u LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 14o0 1o00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1tA0 WM0 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|18e3\",\n            \"Australia/Hobart|AEDT AEST|-b0 -a0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|qg0 1wo0 U00 1wo0 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 11A0 1qM0 WM0 1qM0 Oo0 1zc0 Oo0 1zc0 Oo0 1wo0 WM0 1tA0 WM0 1tA0 U00 1tA0 U00 1tA0 11A0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 11A0 1o00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1cM0 1a00 1io0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|21e4\",\n            \"Australia/Darwin|ACST|-9u|0||12e4\",\n            \"Australia/Eucla|+0845 +0945|-8J -9J|0101010101010|bHRf Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|368\",\n            \"Australia/Lord_Howe|AEST +1030 +1130 +11|-a0 -au -bu -b0|01212121213131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313|raC0 1zdu Rb0 1zd0 On0 1zd0 On0 1zd0 On0 1zd0 TXu 1qMu WLu 1tAu WLu 1tAu TXu 1tAu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu 11zu 1o0u 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 11Au 1nXu 1qMu 11zu 1o0u 11zu 1o0u 11zu 1qMu WLu 1qMu 11zu 1o0u WLu 1qMu 14nu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1fzu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1cMu 1cLu 1fAu 1cLu 1cMu|347\",\n            \"Australia/Lindeman|AEST AEDT|-a0 -b0|0101010101010|4r40 LA0 H1A0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0|10\",\n            \"Australia/Melbourne|AEST AEDT|-a0 -b0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4r40 LA0 1C00 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 U00 1qM0 WM0 1qM0 11A0 1tA0 U00 1tA0 U00 1tA0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 11A0 1o00 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 WM0 1qM0 14o0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|39e5\",\n            \"Australia/Perth|AWST AWDT|-80 -90|0101010101010|bHS0 Oo0 l5A0 Oo0 iJA0 G00 zU00 IM0 1qM0 11A0 1o00 11A0|18e5\",\n            \"Europe/Brussels|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|21e5\",\n            \"Pacific/Easter|-06 -07 -05|60 70 50|010101010101010101010101020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202|yP0 1ip0 11z0 1o10 11z0 1qN0 WL0 1ld0 14n0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 2pA0 11z0 1o10 11z0 1qN0 WL0 1qN0 WL0 1qN0 1cL0 1cN0 11z0 1o10 11z0 1qN0 WL0 1fB0 19X0 1qN0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1ip0 1fz0 1fB0 11z0 1qN0 WL0 1qN0 WL0 1qN0 WL0 1qN0 11z0 1o10 11z0 1o10 11z0 1qN0 WL0 1qN0 17b0 1ip0 11z0 1o10 19X0 1fB0 1nX0 G10 1EL0 Op0 1zb0 Rd0 1wn0 Rd0 46n0 Ap0 1Nb0 Ap0 1Nb0 Ap0 1zb0 11B0 1nX0 11B0 1nX0 11B0 1nX0 14p0 1lb0 11B0 1qL0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1nX0 11B0 1qL0 WN0 1qL0 11B0|30e2\",\n            \"EET|EET EEST|-20 -30|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|\",\n            \"Europe/Dublin|IST GMT|-10 0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4re0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|12e5\",\n            \"Etc/GMT-1|+01|-10|0||\",\n            \"Pacific/Guadalcanal|+11|-b0|0||11e4\",\n            \"Pacific/Tarawa|+12|-c0|0||29e3\",\n            \"Etc/GMT-13|+13|-d0|0||\",\n            \"Etc/GMT-14|+14|-e0|0||\",\n            \"Etc/GMT-2|+02|-20|0||\",\n            \"Indian/Maldives|+05|-50|0||35e4\",\n            \"Pacific/Palau|+09|-90|0||21e3\",\n            \"Etc/GMT+1|-01|10|0||\",\n            \"Pacific/Tahiti|-10|a0|0||18e4\",\n            \"Pacific/Niue|-11|b0|0||12e2\",\n            \"Etc/GMT+12|-12|c0|0||\",\n            \"Etc/GMT+5|-05|50|0||\",\n            \"Etc/GMT+6|-06|60|0||\",\n            \"Etc/GMT+7|-07|70|0||\",\n            \"Etc/GMT+8|-08|80|0||\",\n            \"Pacific/Gambier|-09|90|0||125\",\n            \"Etc/UTC|UTC|0|0||\",\n            \"Europe/Andorra|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|B7d0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|79e3\",\n            \"Europe/Astrakhan|+04 +05 +03|-40 -50 -30|0101010101010101020202020202020202020202020202020202020202020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|10e5\",\n            \"Europe/Athens|EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|cOK0 1vc0 SO0 1cM0 1a00 1ao0 1fc0 1a10 1fG0 1cg0 1dX0 1bX0 1cQ0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|35e5\",\n            \"Europe/London|BST GMT|-10 0|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|4re0 U00 1tA0 U00 1tA0 U00 1tA0 U00 1tA0 WM0 1qM0 WM0 1qM0 WM0 1tA0 U00 1tA0 U00 1tA0 11z0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1o00 14o0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|10e6\",\n            \"Europe/Belgrade|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|wdd0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|12e5\",\n            \"Europe/Prague|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|muN0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|13e5\",\n            \"Europe/Bucharest|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|mRa0 On0 1fA0 1a10 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|19e5\",\n            \"Europe/Budapest|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|oXb0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cO0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|17e5\",\n            \"Europe/Zurich|CET CEST|-10 -20|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|rm10 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|38e4\",\n            \"Europe/Chisinau|MSK MSD EEST EET|-30 -40 -30 -20|010101010101010101012323232323232323232323232323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 gL0 WO0 1cM0 1cM0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11D0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|67e4\",\n            \"Europe/Gibraltar|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|tLB0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|30e3\",\n            \"Europe/Helsinki|EET EEST|-20 -30|01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|rm00 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|12e5\",\n            \"Europe/Kaliningrad|MSK MSD EEST EET +03|-30 -40 -30 -20 -30|010101010101010102323232323232323232323232323232323232323232343|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|44e4\",\n            \"Europe/Kiev|MSK MSD EEST EET|-30 -40 -30 -20|0101010101010101010123232323232323232323232323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 Db0 3220 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o10 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|34e5\",\n            \"Europe/Kirov|+04 +05 MSD MSK MSK|-40 -50 -40 -30 -40|01010101010101010232302323232323232323232323232323232323232343|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 2pz0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|48e4\",\n            \"Europe/Lisbon|CET WET WEST CEST|-10 0 -10 -20|01212121212121212121212121212121203030302121212121212121212121212121212121212121212121212121212121212121212121|go00 1cM0 1cM0 1fA0 1cM0 1cM0 1cN0 1cL0 1cN0 1cM0 1cM0 1cM0 1cM0 1cN0 1cL0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|27e5\",\n            \"Europe/Madrid|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|apy0 1a10 1fz0 1a10 19X0 1cN0 1fz0 1a10 1fC0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|62e5\",\n            \"Europe/Malta|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|XX0 LA0 1zc0 Oo0 1C00 Oo0 1co0 1cM0 1lA0 Xc0 1qq0 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1o10 11z0 1iN0 19z0 1fB0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|42e4\",\n            \"Europe/Minsk|MSK MSD EEST EET +03|-30 -40 -30 -20 -30|010101010101010101023232323232323232323232323232323232323234|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 3Fc0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0|19e5\",\n            \"Europe/Paris|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|fbc0 1cL0 1fC0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|11e6\",\n            \"Europe/Moscow|MSK MSD EEST EET MSK|-30 -40 -30 -20 -40|0101010101010101010102301010101010101010101010101010101010101040|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0|16e6\",\n            \"Europe/Riga|MSK MSD EEST EET|-30 -40 -30 -20|010101010101010102323232323232323232323232323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cN0 1o00 11A0 1o00 11A0 1qM0 3oo0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|64e4\",\n            \"Europe/Rome|CET CEST|-10 -20|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|XX0 LA0 1zc0 Oo0 1C00 Oo0 1C00 LA0 1zc0 Oo0 1C00 LA0 1C00 LA0 1zc0 Oo0 1C00 Oo0 1zc0 Oo0 1fC0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|39e5\",\n            \"Europe/Samara|+04 +05 +03|-40 -50 -30|01010101010101010202010101010101010101010101010101010101020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 2y10 14m0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 2sp0 WM0|12e5\",\n            \"Europe/Saratov|+04 +05 +03|-40 -50 -30|0101010101010102020202020202020202020202020202020202020202020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1cM0 1cM0 1fA0 1cM0 3Co0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 5810|\",\n            \"Europe/Simferopol|MSK MSD EET EEST MSK|-30 -40 -20 -30 -40|0101010101010101010232323101010323232323232323232323232323232323240|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1Q00 4eN0 1cM0 1cM0 1cM0 1cM0 dV0 WO0 1cM0 1cM0 1fy0 1o30 11B0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11z0 1nW0|33e4\",\n            \"Europe/Sofia|EET EEST|-20 -30|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|muJ0 1dd0 1fb0 1ap0 1fb0 1a20 1fy0 1a30 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cK0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 1nX0 11E0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|12e5\",\n            \"Europe/Tallinn|MSK MSD EEST EET|-30 -40 -30 -20|0101010101010101023232323232323232323232323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o10 11A0 1qM0 5QM0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|41e4\",\n            \"Europe/Tirane|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|axz0 10n0 1op0 11z0 1pd0 11z0 1qN0 WL0 1qp0 Xb0 1qp0 Xb0 1qp0 11z0 1lB0 11z0 1qN0 11z0 1iN0 16n0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|42e4\",\n            \"Europe/Ulyanovsk|+04 +05 +03 +02|-40 -50 -30 -20|010101010101010102023202020202020202020202020202020202020202020|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 2pB0 1cM0 1fA0 2pB0 IM0 rX0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 3rd0|13e5\",\n            \"Europe/Vienna|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|oXb0 19X0 1cP0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|18e5\",\n            \"Europe/Vilnius|MSK MSD EEST EET CEST CET|-30 -40 -30 -20 -20 -10|01010101010101010232323232323232323454323232323232323232323232323232323232323232323232323232323|rn90 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11B0 1o00 11A0 1qM0 8io0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|54e4\",\n            \"Europe/Volgograd|+04 +05 MSD MSK MSK|-40 -50 -40 -30 -40|0101010101010102323230232323232323232323232323232323232323234303|rn80 1db0 1cN0 1db0 1cN0 1db0 1dd0 1cO0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1fA0 1cM0 2pz0 1cN0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 8Hz0 9Jd0 5gn0|10e5\",\n            \"Europe/Warsaw|CET CEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDA0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cN0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|17e5\",\n            \"Pacific/Honolulu|HST|a0|0||37e4\",\n            \"Indian/Chagos|+05 +06|-50 -60|01|13ij0|30e2\",\n            \"Indian/Mauritius|+04 +05|-40 -50|01010|v5U0 14L0 12kr0 11z0|15e4\",\n            \"Pacific/Kwajalein|-12 +12|c0 -c0|01|Vxo0|14e3\",\n            \"MET|MET MEST|-10 -20|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|\",\n            \"Pacific/Chatham|+1245 +1345|-cJ -dJ|010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101|bKC0 IM0 1C00 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Oo0 1zc0 Rc0 1zc0 Oo0 1qM0 14o0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1lc0 14o0 1lc0 14o0 1lc0 17c0 1io0 17c0 1io0 17c0 1io0 17c0 1io0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1io0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00|600\",\n            \"Pacific/Apia|-11 -10 +14 +13|b0 a0 -e0 -d0|010123232323232323232323|1Dbn0 1ff0 1a00 CI0 AQ0 1cM0 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1a00 1fA0 1cM0 1fA0 1a00 1fA0 1a00 1fA0|37e3\",\n            \"Pacific/Bougainville|+10 +11|-a0 -b0|01|1NwE0|18e4\",\n            \"Pacific/Efate|+11 +12|-b0 -c0|01010101010101010101010|9EA0 Dc0 n610 1cL0 1cN0 1cL0 1fB0 19X0 1fB0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1cN0 1cL0 1fB0 Lz0 1Nd0 An0|66e3\",\n            \"Pacific/Enderbury|-12 -11 +13|c0 b0 -d0|012|nIc0 B7X0|1\",\n            \"Pacific/Fakaofo|-11 +13|b0 -d0|01|1Gfn0|483\",\n            \"Pacific/Fiji|+12 +13|-c0 -d0|01010101010101010101010101010|1ace0 LA0 1EM0 IM0 nJc0 LA0 1o00 Rc0 1wo0 Ao0 1Nc0 Ao0 1Q00 xz0 1SN0 uM0 1SM0 uM0 1VA0 s00 1VA0 s00 1VA0 s00 20o0 pc0 2hc0 bc0|88e4\",\n            \"Pacific/Galapagos|-05 -06|50 60|0101|CVF0 gNd0 rz0|25e3\",\n            \"Pacific/Guam|GST GDT ChST|-a0 -b0 -a0|010101010102|JQ0 Rb0 1wp0 Rb0 5xd0 rX0 5sN0 zb1 1C0X On0 ULb0|17e4\",\n            \"Pacific/Kiritimati|-1040 -10 +14|aE a0 -e0|012|nIaE B7Xk|51e2\",\n            \"Pacific/Kosrae|+12 +11|-c0 -b0|01|1aAA0|66e2\",\n            \"Pacific/Marquesas|-0930|9u|0||86e2\",\n            \"Pacific/Pago_Pago|SST|b0|0||37e2\",\n            \"Pacific/Nauru|+1130 +12|-bu -c0|01|maCu|10e3\",\n            \"Pacific/Norfolk|+1130 +1230 +11 +12|-bu -cu -b0 -c0|010232323232323232323232323|bHOu Oo0 1COo0 9Jcu 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0|25e4\",\n            \"Pacific/Noumea|+11 +12|-b0 -c0|0101010|jhp0 xX0 1PB0 yn0 HeP0 Ao0|98e3\",\n            \"Pacific/Pitcairn|-0830 -08|8u 80|01|18Vku|56\",\n            \"Pacific/Rarotonga|-1030 -0930 -10|au 9u a0|012121212121212121212121212|lyWu IL0 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Onu 1zcu Rbu 1zcu Onu 1zcu Onu 1zcu Onu|13e3\",\n            \"Pacific/Tongatapu|+13 +14|-d0 -e0|010101010|1csd0 15A0 1wo0 xz0 1Q10 xz0 zWN0 s00|75e3\",\n            \"WET|WET WEST|0 -10|0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010|hDB0 1a00 1fA0 1cM0 1cM0 1cM0 1fA0 1a00 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1cM0 1fA0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00 11A0 1o00 11A0 1o00 11A0 1qM0 WM0 1qM0 WM0 1qM0 11A0 1o00|\"\n        ],\n        \"links\": [\n            \"Africa/Abidjan|Africa/Accra\",\n            \"Africa/Abidjan|Africa/Bamako\",\n            \"Africa/Abidjan|Africa/Banjul\",\n            \"Africa/Abidjan|Africa/Conakry\",\n            \"Africa/Abidjan|Africa/Dakar\",\n            \"Africa/Abidjan|Africa/Freetown\",\n            \"Africa/Abidjan|Africa/Lome\",\n            \"Africa/Abidjan|Africa/Nouakchott\",\n            \"Africa/Abidjan|Africa/Ouagadougou\",\n            \"Africa/Abidjan|Africa/Timbuktu\",\n            \"Africa/Abidjan|Atlantic/Reykjavik\",\n            \"Africa/Abidjan|Atlantic/St_Helena\",\n            \"Africa/Abidjan|Etc/GMT\",\n            \"Africa/Abidjan|Etc/GMT+0\",\n            \"Africa/Abidjan|Etc/GMT-0\",\n            \"Africa/Abidjan|Etc/GMT0\",\n            \"Africa/Abidjan|Etc/Greenwich\",\n            \"Africa/Abidjan|GMT\",\n            \"Africa/Abidjan|GMT+0\",\n            \"Africa/Abidjan|GMT-0\",\n            \"Africa/Abidjan|GMT0\",\n            \"Africa/Abidjan|Greenwich\",\n            \"Africa/Abidjan|Iceland\",\n            \"Africa/Cairo|Egypt\",\n            \"Africa/Johannesburg|Africa/Maseru\",\n            \"Africa/Johannesburg|Africa/Mbabane\",\n            \"Africa/Lagos|Africa/Bangui\",\n            \"Africa/Lagos|Africa/Brazzaville\",\n            \"Africa/Lagos|Africa/Douala\",\n            \"Africa/Lagos|Africa/Kinshasa\",\n            \"Africa/Lagos|Africa/Libreville\",\n            \"Africa/Lagos|Africa/Luanda\",\n            \"Africa/Lagos|Africa/Malabo\",\n            \"Africa/Lagos|Africa/Niamey\",\n            \"Africa/Lagos|Africa/Porto-Novo\",\n            \"Africa/Maputo|Africa/Blantyre\",\n            \"Africa/Maputo|Africa/Bujumbura\",\n            \"Africa/Maputo|Africa/Gaborone\",\n            \"Africa/Maputo|Africa/Harare\",\n            \"Africa/Maputo|Africa/Kigali\",\n            \"Africa/Maputo|Africa/Lubumbashi\",\n            \"Africa/Maputo|Africa/Lusaka\",\n            \"Africa/Nairobi|Africa/Addis_Ababa\",\n            \"Africa/Nairobi|Africa/Asmara\",\n            \"Africa/Nairobi|Africa/Asmera\",\n            \"Africa/Nairobi|Africa/Dar_es_Salaam\",\n            \"Africa/Nairobi|Africa/Djibouti\",\n            \"Africa/Nairobi|Africa/Kampala\",\n            \"Africa/Nairobi|Africa/Mogadishu\",\n            \"Africa/Nairobi|Indian/Antananarivo\",\n            \"Africa/Nairobi|Indian/Comoro\",\n            \"Africa/Nairobi|Indian/Mayotte\",\n            \"Africa/Tripoli|Libya\",\n            \"America/Adak|America/Atka\",\n            \"America/Adak|US/Aleutian\",\n            \"America/Anchorage|US/Alaska\",\n            \"America/Argentina/Buenos_Aires|America/Buenos_Aires\",\n            \"America/Argentina/Catamarca|America/Argentina/ComodRivadavia\",\n            \"America/Argentina/Catamarca|America/Catamarca\",\n            \"America/Argentina/Cordoba|America/Cordoba\",\n            \"America/Argentina/Cordoba|America/Rosario\",\n            \"America/Argentina/Jujuy|America/Jujuy\",\n            \"America/Argentina/Mendoza|America/Mendoza\",\n            \"America/Cayenne|Etc/GMT+3\",\n            \"America/Chicago|CST6CDT\",\n            \"America/Chicago|US/Central\",\n            \"America/Denver|America/Shiprock\",\n            \"America/Denver|MST7MDT\",\n            \"America/Denver|Navajo\",\n            \"America/Denver|US/Mountain\",\n            \"America/Detroit|US/Michigan\",\n            \"America/Edmonton|America/Yellowknife\",\n            \"America/Edmonton|Canada/Mountain\",\n            \"America/Fort_Wayne|America/Indiana/Indianapolis\",\n            \"America/Fort_Wayne|America/Indianapolis\",\n            \"America/Fort_Wayne|US/East-Indiana\",\n            \"America/Godthab|America/Nuuk\",\n            \"America/Halifax|Canada/Atlantic\",\n            \"America/Havana|Cuba\",\n            \"America/Indiana/Knox|America/Knox_IN\",\n            \"America/Indiana/Knox|US/Indiana-Starke\",\n            \"America/Iqaluit|America/Pangnirtung\",\n            \"America/Jamaica|Jamaica\",\n            \"America/Kentucky/Louisville|America/Louisville\",\n            \"America/La_Paz|Etc/GMT+4\",\n            \"America/Los_Angeles|PST8PDT\",\n            \"America/Los_Angeles|US/Pacific\",\n            \"America/Manaus|Brazil/West\",\n            \"America/Mazatlan|Mexico/BajaSur\",\n            \"America/Mexico_City|Mexico/General\",\n            \"America/New_York|EST5EDT\",\n            \"America/New_York|US/Eastern\",\n            \"America/Noronha|Brazil/DeNoronha\",\n            \"America/Panama|America/Atikokan\",\n            \"America/Panama|America/Cayman\",\n            \"America/Panama|America/Coral_Harbour\",\n            \"America/Panama|EST\",\n            \"America/Phoenix|America/Creston\",\n            \"America/Phoenix|MST\",\n            \"America/Phoenix|US/Arizona\",\n            \"America/Puerto_Rico|America/Anguilla\",\n            \"America/Puerto_Rico|America/Antigua\",\n            \"America/Puerto_Rico|America/Aruba\",\n            \"America/Puerto_Rico|America/Blanc-Sablon\",\n            \"America/Puerto_Rico|America/Curacao\",\n            \"America/Puerto_Rico|America/Dominica\",\n            \"America/Puerto_Rico|America/Grenada\",\n            \"America/Puerto_Rico|America/Guadeloupe\",\n            \"America/Puerto_Rico|America/Kralendijk\",\n            \"America/Puerto_Rico|America/Lower_Princes\",\n            \"America/Puerto_Rico|America/Marigot\",\n            \"America/Puerto_Rico|America/Montserrat\",\n            \"America/Puerto_Rico|America/Port_of_Spain\",\n            \"America/Puerto_Rico|America/St_Barthelemy\",\n            \"America/Puerto_Rico|America/St_Kitts\",\n            \"America/Puerto_Rico|America/St_Lucia\",\n            \"America/Puerto_Rico|America/St_Thomas\",\n            \"America/Puerto_Rico|America/St_Vincent\",\n            \"America/Puerto_Rico|America/Tortola\",\n            \"America/Puerto_Rico|America/Virgin\",\n            \"America/Regina|Canada/Saskatchewan\",\n            \"America/Rio_Branco|America/Porto_Acre\",\n            \"America/Rio_Branco|Brazil/Acre\",\n            \"America/Santiago|Chile/Continental\",\n            \"America/Sao_Paulo|Brazil/East\",\n            \"America/St_Johns|Canada/Newfoundland\",\n            \"America/Tijuana|America/Ensenada\",\n            \"America/Tijuana|America/Santa_Isabel\",\n            \"America/Tijuana|Mexico/BajaNorte\",\n            \"America/Toronto|America/Montreal\",\n            \"America/Toronto|America/Nassau\",\n            \"America/Toronto|America/Nipigon\",\n            \"America/Toronto|America/Thunder_Bay\",\n            \"America/Toronto|Canada/Eastern\",\n            \"America/Vancouver|Canada/Pacific\",\n            \"America/Whitehorse|Canada/Yukon\",\n            \"America/Winnipeg|America/Rainy_River\",\n            \"America/Winnipeg|Canada/Central\",\n            \"Asia/Ashgabat|Asia/Ashkhabad\",\n            \"Asia/Bangkok|Asia/Phnom_Penh\",\n            \"Asia/Bangkok|Asia/Vientiane\",\n            \"Asia/Bangkok|Etc/GMT-7\",\n            \"Asia/Bangkok|Indian/Christmas\",\n            \"Asia/Brunei|Asia/Kuching\",\n            \"Asia/Brunei|Etc/GMT-8\",\n            \"Asia/Dhaka|Asia/Dacca\",\n            \"Asia/Dubai|Asia/Muscat\",\n            \"Asia/Dubai|Etc/GMT-4\",\n            \"Asia/Dubai|Indian/Mahe\",\n            \"Asia/Dubai|Indian/Reunion\",\n            \"Asia/Ho_Chi_Minh|Asia/Saigon\",\n            \"Asia/Hong_Kong|Hongkong\",\n            \"Asia/Jerusalem|Asia/Tel_Aviv\",\n            \"Asia/Jerusalem|Israel\",\n            \"Asia/Kathmandu|Asia/Katmandu\",\n            \"Asia/Kolkata|Asia/Calcutta\",\n            \"Asia/Kuala_Lumpur|Asia/Singapore\",\n            \"Asia/Kuala_Lumpur|Singapore\",\n            \"Asia/Macau|Asia/Macao\",\n            \"Asia/Makassar|Asia/Ujung_Pandang\",\n            \"Asia/Nicosia|Europe/Nicosia\",\n            \"Asia/Qatar|Asia/Bahrain\",\n            \"Asia/Rangoon|Asia/Yangon\",\n            \"Asia/Rangoon|Indian/Cocos\",\n            \"Asia/Riyadh|Antarctica/Syowa\",\n            \"Asia/Riyadh|Asia/Aden\",\n            \"Asia/Riyadh|Asia/Kuwait\",\n            \"Asia/Riyadh|Etc/GMT-3\",\n            \"Asia/Seoul|ROK\",\n            \"Asia/Shanghai|Asia/Chongqing\",\n            \"Asia/Shanghai|Asia/Chungking\",\n            \"Asia/Shanghai|Asia/Harbin\",\n            \"Asia/Shanghai|PRC\",\n            \"Asia/Taipei|ROC\",\n            \"Asia/Tehran|Iran\",\n            \"Asia/Thimphu|Asia/Thimbu\",\n            \"Asia/Tokyo|Japan\",\n            \"Asia/Ulaanbaatar|Asia/Ulan_Bator\",\n            \"Asia/Urumqi|Antarctica/Vostok\",\n            \"Asia/Urumqi|Asia/Kashgar\",\n            \"Asia/Urumqi|Etc/GMT-6\",\n            \"Atlantic/Faroe|Atlantic/Faeroe\",\n            \"Atlantic/South_Georgia|Etc/GMT+2\",\n            \"Australia/Adelaide|Australia/South\",\n            \"Australia/Brisbane|Australia/Queensland\",\n            \"Australia/Broken_Hill|Australia/Yancowinna\",\n            \"Australia/Darwin|Australia/North\",\n            \"Australia/Hobart|Australia/Currie\",\n            \"Australia/Hobart|Australia/Tasmania\",\n            \"Australia/Lord_Howe|Australia/LHI\",\n            \"Australia/Melbourne|Australia/Victoria\",\n            \"Australia/Perth|Australia/West\",\n            \"Australia/Sydney|Australia/ACT\",\n            \"Australia/Sydney|Australia/Canberra\",\n            \"Australia/Sydney|Australia/NSW\",\n            \"Etc/UTC|Etc/UCT\",\n            \"Etc/UTC|Etc/Universal\",\n            \"Etc/UTC|Etc/Zulu\",\n            \"Etc/UTC|UCT\",\n            \"Etc/UTC|UTC\",\n            \"Etc/UTC|Universal\",\n            \"Etc/UTC|Zulu\",\n            \"Europe/Belgrade|Europe/Ljubljana\",\n            \"Europe/Belgrade|Europe/Podgorica\",\n            \"Europe/Belgrade|Europe/Sarajevo\",\n            \"Europe/Belgrade|Europe/Skopje\",\n            \"Europe/Belgrade|Europe/Zagreb\",\n            \"Europe/Berlin|Arctic/Longyearbyen\",\n            \"Europe/Berlin|Atlantic/Jan_Mayen\",\n            \"Europe/Berlin|Europe/Copenhagen\",\n            \"Europe/Berlin|Europe/Oslo\",\n            \"Europe/Berlin|Europe/Stockholm\",\n            \"Europe/Brussels|CET\",\n            \"Europe/Brussels|Europe/Amsterdam\",\n            \"Europe/Brussels|Europe/Luxembourg\",\n            \"Europe/Chisinau|Europe/Tiraspol\",\n            \"Europe/Dublin|Eire\",\n            \"Europe/Helsinki|Europe/Mariehamn\",\n            \"Europe/Istanbul|Asia/Istanbul\",\n            \"Europe/Istanbul|Turkey\",\n            \"Europe/Kiev|Europe/Kyiv\",\n            \"Europe/Kiev|Europe/Uzhgorod\",\n            \"Europe/Kiev|Europe/Zaporozhye\",\n            \"Europe/Lisbon|Portugal\",\n            \"Europe/London|Europe/Belfast\",\n            \"Europe/London|Europe/Guernsey\",\n            \"Europe/London|Europe/Isle_of_Man\",\n            \"Europe/London|Europe/Jersey\",\n            \"Europe/London|GB\",\n            \"Europe/London|GB-Eire\",\n            \"Europe/Moscow|W-SU\",\n            \"Europe/Paris|Europe/Monaco\",\n            \"Europe/Prague|Europe/Bratislava\",\n            \"Europe/Rome|Europe/San_Marino\",\n            \"Europe/Rome|Europe/Vatican\",\n            \"Europe/Warsaw|Poland\",\n            \"Europe/Zurich|Europe/Busingen\",\n            \"Europe/Zurich|Europe/Vaduz\",\n            \"Indian/Maldives|Etc/GMT-5\",\n            \"Indian/Maldives|Indian/Kerguelen\",\n            \"Pacific/Auckland|Antarctica/McMurdo\",\n            \"Pacific/Auckland|Antarctica/South_Pole\",\n            \"Pacific/Auckland|NZ\",\n            \"Pacific/Chatham|NZ-CHAT\",\n            \"Pacific/Easter|Chile/EasterIsland\",\n            \"Pacific/Enderbury|Pacific/Kanton\",\n            \"Pacific/Gambier|Etc/GMT+9\",\n            \"Pacific/Guadalcanal|Etc/GMT-11\",\n            \"Pacific/Guadalcanal|Pacific/Pohnpei\",\n            \"Pacific/Guadalcanal|Pacific/Ponape\",\n            \"Pacific/Guam|Pacific/Saipan\",\n            \"Pacific/Honolulu|HST\",\n            \"Pacific/Honolulu|Pacific/Johnston\",\n            \"Pacific/Honolulu|US/Hawaii\",\n            \"Pacific/Kwajalein|Kwajalein\",\n            \"Pacific/Niue|Etc/GMT+11\",\n            \"Pacific/Pago_Pago|Pacific/Midway\",\n            \"Pacific/Pago_Pago|Pacific/Samoa\",\n            \"Pacific/Pago_Pago|US/Samoa\",\n            \"Pacific/Palau|Etc/GMT-9\",\n            \"Pacific/Port_Moresby|Antarctica/DumontDUrville\",\n            \"Pacific/Port_Moresby|Etc/GMT-10\",\n            \"Pacific/Port_Moresby|Pacific/Chuuk\",\n            \"Pacific/Port_Moresby|Pacific/Truk\",\n            \"Pacific/Port_Moresby|Pacific/Yap\",\n            \"Pacific/Tahiti|Etc/GMT+10\",\n            \"Pacific/Tarawa|Etc/GMT-12\",\n            \"Pacific/Tarawa|Pacific/Funafuti\",\n            \"Pacific/Tarawa|Pacific/Majuro\",\n            \"Pacific/Tarawa|Pacific/Wake\",\n            \"Pacific/Tarawa|Pacific/Wallis\"\n        ],\n        \"countries\": [\n            \"AD|Europe/Andorra\",\n            \"AE|Asia/Dubai\",\n            \"AF|Asia/Kabul\",\n            \"AG|America/Puerto_Rico America/Antigua\",\n            \"AI|America/Puerto_Rico America/Anguilla\",\n            \"AL|Europe/Tirane\",\n            \"AM|Asia/Yerevan\",\n            \"AO|Africa/Lagos Africa/Luanda\",\n            \"AQ|Antarctica/Casey Antarctica/Davis Antarctica/Mawson Antarctica/Palmer Antarctica/Rothera Antarctica/Troll Asia/Urumqi Pacific/Auckland Pacific/Port_Moresby Asia/Riyadh Antarctica/McMurdo Antarctica/DumontDUrville Antarctica/Syowa Antarctica/Vostok\",\n            \"AR|America/Argentina/Buenos_Aires America/Argentina/Cordoba America/Argentina/Salta America/Argentina/Jujuy America/Argentina/Tucuman America/Argentina/Catamarca America/Argentina/La_Rioja America/Argentina/San_Juan America/Argentina/Mendoza America/Argentina/San_Luis America/Argentina/Rio_Gallegos America/Argentina/Ushuaia\",\n            \"AS|Pacific/Pago_Pago\",\n            \"AT|Europe/Vienna\",\n            \"AU|Australia/Lord_Howe Antarctica/Macquarie Australia/Hobart Australia/Melbourne Australia/Sydney Australia/Broken_Hill Australia/Brisbane Australia/Lindeman Australia/Adelaide Australia/Darwin Australia/Perth Australia/Eucla\",\n            \"AW|America/Puerto_Rico America/Aruba\",\n            \"AX|Europe/Helsinki Europe/Mariehamn\",\n            \"AZ|Asia/Baku\",\n            \"BA|Europe/Belgrade Europe/Sarajevo\",\n            \"BB|America/Barbados\",\n            \"BD|Asia/Dhaka\",\n            \"BE|Europe/Brussels\",\n            \"BF|Africa/Abidjan Africa/Ouagadougou\",\n            \"BG|Europe/Sofia\",\n            \"BH|Asia/Qatar Asia/Bahrain\",\n            \"BI|Africa/Maputo Africa/Bujumbura\",\n            \"BJ|Africa/Lagos Africa/Porto-Novo\",\n            \"BL|America/Puerto_Rico America/St_Barthelemy\",\n            \"BM|Atlantic/Bermuda\",\n            \"BN|Asia/Kuching Asia/Brunei\",\n            \"BO|America/La_Paz\",\n            \"BQ|America/Puerto_Rico America/Kralendijk\",\n            \"BR|America/Noronha America/Belem America/Fortaleza America/Recife America/Araguaina America/Maceio America/Bahia America/Sao_Paulo America/Campo_Grande America/Cuiaba America/Santarem America/Porto_Velho America/Boa_Vista America/Manaus America/Eirunepe America/Rio_Branco\",\n            \"BS|America/Toronto America/Nassau\",\n            \"BT|Asia/Thimphu\",\n            \"BW|Africa/Maputo Africa/Gaborone\",\n            \"BY|Europe/Minsk\",\n            \"BZ|America/Belize\",\n            \"CA|America/St_Johns America/Halifax America/Glace_Bay America/Moncton America/Goose_Bay America/Toronto America/Iqaluit America/Winnipeg America/Resolute America/Rankin_Inlet America/Regina America/Swift_Current America/Edmonton America/Cambridge_Bay America/Inuvik America/Dawson_Creek America/Fort_Nelson America/Whitehorse America/Dawson America/Vancouver America/Panama America/Puerto_Rico America/Phoenix America/Blanc-Sablon America/Atikokan America/Creston\",\n            \"CC|Asia/Yangon Indian/Cocos\",\n            \"CD|Africa/Maputo Africa/Lagos Africa/Kinshasa Africa/Lubumbashi\",\n            \"CF|Africa/Lagos Africa/Bangui\",\n            \"CG|Africa/Lagos Africa/Brazzaville\",\n            \"CH|Europe/Zurich\",\n            \"CI|Africa/Abidjan\",\n            \"CK|Pacific/Rarotonga\",\n            \"CL|America/Santiago America/Punta_Arenas Pacific/Easter\",\n            \"CM|Africa/Lagos Africa/Douala\",\n            \"CN|Asia/Shanghai Asia/Urumqi\",\n            \"CO|America/Bogota\",\n            \"CR|America/Costa_Rica\",\n            \"CU|America/Havana\",\n            \"CV|Atlantic/Cape_Verde\",\n            \"CW|America/Puerto_Rico America/Curacao\",\n            \"CX|Asia/Bangkok Indian/Christmas\",\n            \"CY|Asia/Nicosia Asia/Famagusta\",\n            \"CZ|Europe/Prague\",\n            \"DE|Europe/Zurich Europe/Berlin Europe/Busingen\",\n            \"DJ|Africa/Nairobi Africa/Djibouti\",\n            \"DK|Europe/Berlin Europe/Copenhagen\",\n            \"DM|America/Puerto_Rico America/Dominica\",\n            \"DO|America/Santo_Domingo\",\n            \"DZ|Africa/Algiers\",\n            \"EC|America/Guayaquil Pacific/Galapagos\",\n            \"EE|Europe/Tallinn\",\n            \"EG|Africa/Cairo\",\n            \"EH|Africa/El_Aaiun\",\n            \"ER|Africa/Nairobi Africa/Asmara\",\n            \"ES|Europe/Madrid Africa/Ceuta Atlantic/Canary\",\n            \"ET|Africa/Nairobi Africa/Addis_Ababa\",\n            \"FI|Europe/Helsinki\",\n            \"FJ|Pacific/Fiji\",\n            \"FK|Atlantic/Stanley\",\n            \"FM|Pacific/Kosrae Pacific/Port_Moresby Pacific/Guadalcanal Pacific/Chuuk Pacific/Pohnpei\",\n            \"FO|Atlantic/Faroe\",\n            \"FR|Europe/Paris\",\n            \"GA|Africa/Lagos Africa/Libreville\",\n            \"GB|Europe/London\",\n            \"GD|America/Puerto_Rico America/Grenada\",\n            \"GE|Asia/Tbilisi\",\n            \"GF|America/Cayenne\",\n            \"GG|Europe/London Europe/Guernsey\",\n            \"GH|Africa/Abidjan Africa/Accra\",\n            \"GI|Europe/Gibraltar\",\n            \"GL|America/Nuuk America/Danmarkshavn America/Scoresbysund America/Thule\",\n            \"GM|Africa/Abidjan Africa/Banjul\",\n            \"GN|Africa/Abidjan Africa/Conakry\",\n            \"GP|America/Puerto_Rico America/Guadeloupe\",\n            \"GQ|Africa/Lagos Africa/Malabo\",\n            \"GR|Europe/Athens\",\n            \"GS|Atlantic/South_Georgia\",\n            \"GT|America/Guatemala\",\n            \"GU|Pacific/Guam\",\n            \"GW|Africa/Bissau\",\n            \"GY|America/Guyana\",\n            \"HK|Asia/Hong_Kong\",\n            \"HN|America/Tegucigalpa\",\n            \"HR|Europe/Belgrade Europe/Zagreb\",\n            \"HT|America/Port-au-Prince\",\n            \"HU|Europe/Budapest\",\n            \"ID|Asia/Jakarta Asia/Pontianak Asia/Makassar Asia/Jayapura\",\n            \"IE|Europe/Dublin\",\n            \"IL|Asia/Jerusalem\",\n            \"IM|Europe/London Europe/Isle_of_Man\",\n            \"IN|Asia/Kolkata\",\n            \"IO|Indian/Chagos\",\n            \"IQ|Asia/Baghdad\",\n            \"IR|Asia/Tehran\",\n            \"IS|Africa/Abidjan Atlantic/Reykjavik\",\n            \"IT|Europe/Rome\",\n            \"JE|Europe/London Europe/Jersey\",\n            \"JM|America/Jamaica\",\n            \"JO|Asia/Amman\",\n            \"JP|Asia/Tokyo\",\n            \"KE|Africa/Nairobi\",\n            \"KG|Asia/Bishkek\",\n            \"KH|Asia/Bangkok Asia/Phnom_Penh\",\n            \"KI|Pacific/Tarawa Pacific/Kanton Pacific/Kiritimati\",\n            \"KM|Africa/Nairobi Indian/Comoro\",\n            \"KN|America/Puerto_Rico America/St_Kitts\",\n            \"KP|Asia/Pyongyang\",\n            \"KR|Asia/Seoul\",\n            \"KW|Asia/Riyadh Asia/Kuwait\",\n            \"KY|America/Panama America/Cayman\",\n            \"KZ|Asia/Almaty Asia/Qyzylorda Asia/Qostanay Asia/Aqtobe Asia/Aqtau Asia/Atyrau Asia/Oral\",\n            \"LA|Asia/Bangkok Asia/Vientiane\",\n            \"LB|Asia/Beirut\",\n            \"LC|America/Puerto_Rico America/St_Lucia\",\n            \"LI|Europe/Zurich Europe/Vaduz\",\n            \"LK|Asia/Colombo\",\n            \"LR|Africa/Monrovia\",\n            \"LS|Africa/Johannesburg Africa/Maseru\",\n            \"LT|Europe/Vilnius\",\n            \"LU|Europe/Brussels Europe/Luxembourg\",\n            \"LV|Europe/Riga\",\n            \"LY|Africa/Tripoli\",\n            \"MA|Africa/Casablanca\",\n            \"MC|Europe/Paris Europe/Monaco\",\n            \"MD|Europe/Chisinau\",\n            \"ME|Europe/Belgrade Europe/Podgorica\",\n            \"MF|America/Puerto_Rico America/Marigot\",\n            \"MG|Africa/Nairobi Indian/Antananarivo\",\n            \"MH|Pacific/Tarawa Pacific/Kwajalein Pacific/Majuro\",\n            \"MK|Europe/Belgrade Europe/Skopje\",\n            \"ML|Africa/Abidjan Africa/Bamako\",\n            \"MM|Asia/Yangon\",\n            \"MN|Asia/Ulaanbaatar Asia/Hovd Asia/Choibalsan\",\n            \"MO|Asia/Macau\",\n            \"MP|Pacific/Guam Pacific/Saipan\",\n            \"MQ|America/Martinique\",\n            \"MR|Africa/Abidjan Africa/Nouakchott\",\n            \"MS|America/Puerto_Rico America/Montserrat\",\n            \"MT|Europe/Malta\",\n            \"MU|Indian/Mauritius\",\n            \"MV|Indian/Maldives\",\n            \"MW|Africa/Maputo Africa/Blantyre\",\n            \"MX|America/Mexico_City America/Cancun America/Merida America/Monterrey America/Matamoros America/Chihuahua America/Ciudad_Juarez America/Ojinaga America/Mazatlan America/Bahia_Banderas America/Hermosillo America/Tijuana\",\n            \"MY|Asia/Kuching Asia/Singapore Asia/Kuala_Lumpur\",\n            \"MZ|Africa/Maputo\",\n            \"NA|Africa/Windhoek\",\n            \"NC|Pacific/Noumea\",\n            \"NE|Africa/Lagos Africa/Niamey\",\n            \"NF|Pacific/Norfolk\",\n            \"NG|Africa/Lagos\",\n            \"NI|America/Managua\",\n            \"NL|Europe/Brussels Europe/Amsterdam\",\n            \"NO|Europe/Berlin Europe/Oslo\",\n            \"NP|Asia/Kathmandu\",\n            \"NR|Pacific/Nauru\",\n            \"NU|Pacific/Niue\",\n            \"NZ|Pacific/Auckland Pacific/Chatham\",\n            \"OM|Asia/Dubai Asia/Muscat\",\n            \"PA|America/Panama\",\n            \"PE|America/Lima\",\n            \"PF|Pacific/Tahiti Pacific/Marquesas Pacific/Gambier\",\n            \"PG|Pacific/Port_Moresby Pacific/Bougainville\",\n            \"PH|Asia/Manila\",\n            \"PK|Asia/Karachi\",\n            \"PL|Europe/Warsaw\",\n            \"PM|America/Miquelon\",\n            \"PN|Pacific/Pitcairn\",\n            \"PR|America/Puerto_Rico\",\n            \"PS|Asia/Gaza Asia/Hebron\",\n            \"PT|Europe/Lisbon Atlantic/Madeira Atlantic/Azores\",\n            \"PW|Pacific/Palau\",\n            \"PY|America/Asuncion\",\n            \"QA|Asia/Qatar\",\n            \"RE|Asia/Dubai Indian/Reunion\",\n            \"RO|Europe/Bucharest\",\n            \"RS|Europe/Belgrade\",\n            \"RU|Europe/Kaliningrad Europe/Moscow Europe/Simferopol Europe/Kirov Europe/Volgograd Europe/Astrakhan Europe/Saratov Europe/Ulyanovsk Europe/Samara Asia/Yekaterinburg Asia/Omsk Asia/Novosibirsk Asia/Barnaul Asia/Tomsk Asia/Novokuznetsk Asia/Krasnoyarsk Asia/Irkutsk Asia/Chita Asia/Yakutsk Asia/Khandyga Asia/Vladivostok Asia/Ust-Nera Asia/Magadan Asia/Sakhalin Asia/Srednekolymsk Asia/Kamchatka Asia/Anadyr\",\n            \"RW|Africa/Maputo Africa/Kigali\",\n            \"SA|Asia/Riyadh\",\n            \"SB|Pacific/Guadalcanal\",\n            \"SC|Asia/Dubai Indian/Mahe\",\n            \"SD|Africa/Khartoum\",\n            \"SE|Europe/Berlin Europe/Stockholm\",\n            \"SG|Asia/Singapore\",\n            \"SH|Africa/Abidjan Atlantic/St_Helena\",\n            \"SI|Europe/Belgrade Europe/Ljubljana\",\n            \"SJ|Europe/Berlin Arctic/Longyearbyen\",\n            \"SK|Europe/Prague Europe/Bratislava\",\n            \"SL|Africa/Abidjan Africa/Freetown\",\n            \"SM|Europe/Rome Europe/San_Marino\",\n            \"SN|Africa/Abidjan Africa/Dakar\",\n            \"SO|Africa/Nairobi Africa/Mogadishu\",\n            \"SR|America/Paramaribo\",\n            \"SS|Africa/Juba\",\n            \"ST|Africa/Sao_Tome\",\n            \"SV|America/El_Salvador\",\n            \"SX|America/Puerto_Rico America/Lower_Princes\",\n            \"SY|Asia/Damascus\",\n            \"SZ|Africa/Johannesburg Africa/Mbabane\",\n            \"TC|America/Grand_Turk\",\n            \"TD|Africa/Ndjamena\",\n            \"TF|Asia/Dubai Indian/Maldives Indian/Kerguelen\",\n            \"TG|Africa/Abidjan Africa/Lome\",\n            \"TH|Asia/Bangkok\",\n            \"TJ|Asia/Dushanbe\",\n            \"TK|Pacific/Fakaofo\",\n            \"TL|Asia/Dili\",\n            \"TM|Asia/Ashgabat\",\n            \"TN|Africa/Tunis\",\n            \"TO|Pacific/Tongatapu\",\n            \"TR|Europe/Istanbul\",\n            \"TT|America/Puerto_Rico America/Port_of_Spain\",\n            \"TV|Pacific/Tarawa Pacific/Funafuti\",\n            \"TW|Asia/Taipei\",\n            \"TZ|Africa/Nairobi Africa/Dar_es_Salaam\",\n            \"UA|Europe/Simferopol Europe/Kyiv\",\n            \"UG|Africa/Nairobi Africa/Kampala\",\n            \"UM|Pacific/Pago_Pago Pacific/Tarawa Pacific/Midway Pacific/Wake\",\n            \"US|America/New_York America/Detroit America/Kentucky/Louisville America/Kentucky/Monticello America/Indiana/Indianapolis America/Indiana/Vincennes America/Indiana/Winamac America/Indiana/Marengo America/Indiana/Petersburg America/Indiana/Vevay America/Chicago America/Indiana/Tell_City America/Indiana/Knox America/Menominee America/North_Dakota/Center America/North_Dakota/New_Salem America/North_Dakota/Beulah America/Denver America/Boise America/Phoenix America/Los_Angeles America/Anchorage America/Juneau America/Sitka America/Metlakatla America/Yakutat America/Nome America/Adak Pacific/Honolulu\",\n            \"UY|America/Montevideo\",\n            \"UZ|Asia/Samarkand Asia/Tashkent\",\n            \"VA|Europe/Rome Europe/Vatican\",\n            \"VC|America/Puerto_Rico America/St_Vincent\",\n            \"VE|America/Caracas\",\n            \"VG|America/Puerto_Rico America/Tortola\",\n            \"VI|America/Puerto_Rico America/St_Thomas\",\n            \"VN|Asia/Bangkok Asia/Ho_Chi_Minh\",\n            \"VU|Pacific/Efate\",\n            \"WF|Pacific/Tarawa Pacific/Wallis\",\n            \"WS|Pacific/Apia\",\n            \"YE|Asia/Riyadh Asia/Aden\",\n            \"YT|Africa/Nairobi Indian/Mayotte\",\n            \"ZA|Africa/Johannesburg\",\n            \"ZM|Africa/Maputo Africa/Lusaka\",\n            \"ZW|Africa/Maputo Africa/Harare\"\n        ]\n    });\n\n\n    return moment;\n}));\n","requirejs-min-resolver.js":"    (function () {\n        var ctx = require.s.contexts._,\n            origNameToUrl = ctx.nameToUrl,\n            baseUrl = ctx.config.baseUrl;\n\n        ctx.nameToUrl = function() {\n            var url = origNameToUrl.apply(ctx, arguments);\n            if (url.indexOf(baseUrl)===0&&!url.match(/\\/tiny_mce\\//)&&!url.match(/\\/v1\\/songbird/)&&!url.match(/Xtento_ProductExport\\/js\\/ace\\/mode-xml/)&&!url.match(/Xtento_ProductExport\\/js\\/ace\\/theme-eclipse/)&&!url.match(/js.mollie.com/)&&!url.match(/\\/pay.google.com\\//)) {\n                url = url.replace(/(\\.min)?\\.js$/, '.min.js');\n            }\n            return url;\n        };\n    })();","legacy-build.min.js":"var Prototype={Version:\"1.7.3\",Browser:(function(){var d=navigator.userAgent;var b=Object.prototype.toString.call(window.opera)==\"[object Opera]\";return{IE:!!window.attachEvent&&!b,Opera:b,WebKit:d.indexOf(\"AppleWebKit/\")>-1,Gecko:d.indexOf(\"Gecko\")>-1&&d.indexOf(\"KHTML\")===-1,MobileSafari:/Apple.*Mobile/.test(d)}})(),BrowserFeatures:{XPath:!!document.evaluate,SelectorsAPI:!!document.querySelector,ElementExtensions:(function(){var b=window.Element||window.HTMLElement;return !!(b&&b.prototype)})(),SpecificElementExtensions:(function(){if(typeof window.HTMLDivElement!==\"undefined\"){return true}var e=document.createElement(\"div\"),d=document.createElement(\"form\"),b=false;if(e.__proto__&&(e.__proto__!==d.__proto__)){b=true}e=d=null;return b})()},ScriptFragment:\"<script[^>]*>([\\\\S\\\\s]*?)<\\/script\\\\s*>\",JSONFilter:/^\\/\\*-secure-([\\s\\S]*)\\*\\/\\s*$/,emptyFunction:function(){},K:function(b){return b}};if(Prototype.Browser.MobileSafari){Prototype.BrowserFeatures.SpecificElementExtensions=false}var Class=(function(){var f=(function(){for(var g in {toString:1}){if(g===\"toString\"){return false}}return true})();function b(){}function d(){var n=null,l=$A(arguments);if(Object.isFunction(l[0])){n=l.shift()}function g(){this.initialize.apply(this,arguments)}Object.extend(g,Class.Methods);g.superclass=n;g.subclasses=[];if(n){b.prototype=n.prototype;g.prototype=new b;n.subclasses.push(g)}for(var h=0,o=l.length;h<o;h++){g.addMethods(l[h])}if(!g.prototype.initialize){g.prototype.initialize=Prototype.emptyFunction}g.prototype.constructor=g;return g}function e(q){var l=this.superclass&&this.superclass.prototype,h=Object.keys(q);if(f){if(q.toString!=Object.prototype.toString){h.push(\"toString\")}if(q.valueOf!=Object.prototype.valueOf){h.push(\"valueOf\")}}for(var g=0,n=h.length;g<n;g++){var p=h[g],o=q[p];if(l&&Object.isFunction(o)&&o.argumentNames()[0]==\"$super\"){var r=o;o=(function(s){return function(){return l[s].apply(this,arguments)}})(p).wrap(r);o.valueOf=(function(s){return function(){return s.valueOf.call(s)}})(r);o.toString=(function(s){return function(){return s.toString.call(s)}})(r)}this.prototype[p]=o}return this}return{create:d,Methods:{addMethods:e}}})();(function(){var F=Object.prototype.toString,q=Object.prototype.hasOwnProperty,G=\"Null\",I=\"Undefined\",R=\"Boolean\",D=\"Number\",C=\"String\",P=\"Object\",o=\"[object Function]\",f=\"[object Boolean]\",p=\"[object Number]\",h=\"[object String]\",d=\"[object Array]\",O=\"[object Date]\",g=window.JSON&&typeof JSON.stringify===\"function\"&&JSON.stringify(0)===\"0\"&&typeof JSON.stringify(Prototype.K)===\"undefined\";var w=[\"toString\",\"toLocaleString\",\"valueOf\",\"hasOwnProperty\",\"isPrototypeOf\",\"propertyIsEnumerable\",\"constructor\"];var b=(function(){for(var S in {toString:1}){if(S===\"toString\"){return false}}return true})();function K(T){switch(T){case null:return G;case (void 0):return I}var S=typeof T;switch(S){case\"boolean\":return R;case\"number\":return D;case\"string\":return C}return P}function n(S,U){for(var T in U){S[T]=U[T]}return S}function r(S){try{if(u(S)){return\"undefined\"}if(S===null){return\"null\"}return S.inspect?S.inspect():String(S)}catch(T){if(T instanceof RangeError){return\"...\"}throw T}}function H(S){return s(\"\",{\"\":S},[])}function s(ab,Y,Z){var aa=Y[ab];if(K(aa)===P&&typeof aa.toJSON===\"function\"){aa=aa.toJSON(ab)}var U=F.call(aa);switch(U){case p:case f:case h:aa=aa.valueOf()}switch(aa){case null:return\"null\";case true:return\"true\";case false:return\"false\"}var X=typeof aa;switch(X){case\"string\":return aa.inspect(true);case\"number\":return isFinite(aa)?String(aa):\"null\";case\"object\":for(var T=0,S=Z.length;T<S;T++){if(Z[T]===aa){throw new TypeError(\"Cyclic reference to '\"+aa+\"' in object\")}}Z.push(aa);var W=[];if(U===d){for(var T=0,S=aa.length;T<S;T++){var V=s(T,aa,Z);W.push(typeof V===\"undefined\"?\"null\":V)}W=\"[\"+W.join(\",\")+\"]\"}else{var ac=Object.keys(aa);for(var T=0,S=ac.length;T<S;T++){var ab=ac[T],V=s(ab,aa,Z);if(typeof V!==\"undefined\"){W.push(ab.inspect(true)+\":\"+V)}}W=\"{\"+W.join(\",\")+\"}\"}Z.pop();return W}}function Q(S){return JSON.stringify(S)}function J(S){return $H(S).toQueryString()}function v(S){return S&&S.toHTML?S.toHTML():String.interpret(S)}function E(S){if(K(S)!==P){throw new TypeError()}var U=[];for(var V in S){if(q.call(S,V)){U.push(V)}}if(b){for(var T=0;V=w[T];T++){if(q.call(S,V)){U.push(V)}}}return U}function N(S){var T=[];for(var U in S){T.push(S[U])}return T}function z(S){return n({},S)}function L(S){return !!(S&&S.nodeType==1)}function B(S){return F.call(S)===d}var e=(typeof Array.isArray==\"function\")&&Array.isArray([])&&!Array.isArray({});if(e){B=Array.isArray}function y(S){return S instanceof Hash}function t(S){return F.call(S)===o}function l(S){return F.call(S)===h}function M(S){return F.call(S)===p}function A(S){return F.call(S)===O}function u(S){return typeof S===\"undefined\"}n(Object,{extend:n,inspect:r,toJSON:g?Q:H,toQueryString:J,toHTML:v,keys:Object.keys||E,values:N,clone:z,isElement:L,isArray:B,isHash:y,isFunction:t,isString:l,isNumber:M,isDate:A,isUndefined:u})})();Object.extend(Function.prototype,(function(){var r=Array.prototype.slice;function f(v,s){var u=v.length,t=s.length;while(t--){v[u+t]=s[t]}return v}function p(t,s){t=r.call(t,0);return f(t,s)}function l(){var s=this.toString().match(/^[\\s\\(]*function[^(]*\\(([^)]*)\\)/)[1].replace(/\\/\\/.*?[\\r\\n]|\\/\\*(?:.|[\\r\\n])*?\\*\\//g,\"\").replace(/\\s+/g,\"\").split(\",\");return s.length==1&&!s[0]?[]:s}function n(u){if(arguments.length<2&&Object.isUndefined(arguments[0])){return this}if(!Object.isFunction(this)){throw new TypeError(\"The object is not callable.\")}var w=function(){};var s=this,t=r.call(arguments,1);var v=function(){var y=p(t,arguments);var z=this instanceof v?this:u;return s.apply(z,y)};w.prototype=this.prototype;v.prototype=new w();return v}function h(u){var s=this,t=r.call(arguments,1);return function(w){var v=f([w||window.event],t);return s.apply(u,v)}}function q(){if(!arguments.length){return this}var s=this,t=r.call(arguments,0);return function(){var u=p(t,arguments);return s.apply(this,u)}}function g(u){var s=this,t=r.call(arguments,1);u=u*1000;return window.setTimeout(function(){return s.apply(s,t)},u)}function b(){var s=f([0.01],arguments);return this.delay.apply(this,s)}function e(t){var s=this;return function(){var u=f([s.bind(this)],arguments);return t.apply(this,u)}}function d(){if(this._methodized){return this._methodized}var s=this;return this._methodized=function(){var t=f([this],arguments);return s.apply(null,t)}}var o={argumentNames:l,bindAsEventListener:h,curry:q,delay:g,defer:b,wrap:e,methodize:d};if(!Function.prototype.bind){o.bind=n}return o})());(function(e){function d(){return this.getUTCFullYear()+\"-\"+(this.getUTCMonth()+1).toPaddedString(2)+\"-\"+this.getUTCDate().toPaddedString(2)+\"T\"+this.getUTCHours().toPaddedString(2)+\":\"+this.getUTCMinutes().toPaddedString(2)+\":\"+this.getUTCSeconds().toPaddedString(2)+\"Z\"}function b(){return this.toISOString()}if(!e.toISOString){e.toISOString=d}if(!e.toJSON){e.toJSON=b}})(Date.prototype);RegExp.prototype.match=RegExp.prototype.test;RegExp.escape=function(b){return String(b).replace(/([.*+?^=!:${}()|[\\]\\/\\\\])/g,\"\\\\$1\")};var PeriodicalExecuter=Class.create({initialize:function(d,b){this.callback=d;this.frequency=b;this.currentlyExecuting=false;this.registerCallback()},registerCallback:function(){this.timer=setInterval(this.onTimerEvent.bind(this),this.frequency*1000)},execute:function(){this.callback(this)},stop:function(){if(!this.timer){return}clearInterval(this.timer);this.timer=null},onTimerEvent:function(){if(!this.currentlyExecuting){try{this.currentlyExecuting=true;this.execute();this.currentlyExecuting=false}catch(b){this.currentlyExecuting=false;throw b}}}});Object.extend(String,{interpret:function(b){return b==null?\"\":String(b)},specialChar:{\"\\b\":\"\\\\b\",\"\\t\":\"\\\\t\",\"\\n\":\"\\\\n\",\"\\f\":\"\\\\f\",\"\\r\":\"\\\\r\",\"\\\\\":\"\\\\\\\\\"}});Object.extend(String.prototype,(function(){var NATIVE_JSON_PARSE_SUPPORT=window.JSON&&typeof JSON.parse===\"function\"&&JSON.parse('{\"test\": true}').test;function prepareReplacement(replacement){if(Object.isFunction(replacement)){return replacement}var template=new Template(replacement);return function(match){return template.evaluate(match)}}function isNonEmptyRegExp(regexp){return regexp.source&&regexp.source!==\"(?:)\"}function gsub(pattern,replacement){var result=\"\",source=this,match;replacement=prepareReplacement(replacement);if(Object.isString(pattern)){pattern=RegExp.escape(pattern)}if(!(pattern.length||isNonEmptyRegExp(pattern))){replacement=replacement(\"\");return replacement+source.split(\"\").join(replacement)+replacement}while(source.length>0){match=source.match(pattern);if(match&&match[0].length>0){result+=source.slice(0,match.index);result+=String.interpret(replacement(match));source=source.slice(match.index+match[0].length)}else{result+=source,source=\"\"}}return result}function sub(pattern,replacement,count){replacement=prepareReplacement(replacement);count=Object.isUndefined(count)?1:count;return this.gsub(pattern,function(match){if(--count<0){return match[0]}return replacement(match)})}function scan(pattern,iterator){this.gsub(pattern,iterator);return String(this)}function truncate(length,truncation){length=length||30;truncation=Object.isUndefined(truncation)?\"...\":truncation;return this.length>length?this.slice(0,length-truncation.length)+truncation:String(this)}function strip(){return this.replace(/^\\s+/,\"\").replace(/\\s+$/,\"\")}function stripTags(){return this.replace(/<\\w+(\\s+(\"[^\"]*\"|'[^']*'|[^>'\"])+)?\\s*(\"[^\">]*|'[^'>])?(\\/)?>|<\\/\\w+>/gi, '')}function stripScripts(){return this.replace(new RegExp(Prototype.ScriptFragment,\"img\"),\"\")}function extractScripts(){var matchAll=new RegExp(Prototype.ScriptFragment,\"img\"),matchOne=new RegExp(Prototype.ScriptFragment,\"im\");return(this.match(matchAll)||[]).map(function(scriptTag){return(scriptTag.match(matchOne)||[\"\",\"\"])[1]})}function evalScripts(){return this.extractScripts().map(function(script){return eval(script)})}function escapeHTML(){return this.replace(/&/g,\"&amp;\").replace(/</g,\"&lt;\").replace(/>/g,\"&gt;\")}function unescapeHTML(){return this.stripTags().replace(/&lt;/g,\"<\").replace(/&gt;/g,\">\").replace(/&amp;/g,\"&\")}function toQueryParams(separator){var match=this.strip().match(/([^?#]*)(#.*)?$/);if(!match){return{}}return match[1].split(separator||\"&\").inject({},function(hash,pair){if((pair=pair.split(\"=\"))[0]){var key=decodeURIComponent(pair.shift()),value=pair.length>1?pair.join(\"=\"):pair[0];if(value!=undefined){value=value.gsub(\"+\",\" \");value=decodeURIComponent(value)}if(key in hash){if(!Object.isArray(hash[key])){hash[key]=[hash[key]]}hash[key].push(value)}else{hash[key]=value}}return hash})}function toArray(){return this.split(\"\")}function succ(){return this.slice(0,this.length-1)+String.fromCharCode(this.charCodeAt(this.length-1)+1)}function times(count){return count<1?\"\":new Array(count+1).join(this)}function camelize(){return this.replace(/-+(.)?/g,function(match,chr){return chr?chr.toUpperCase():\"\"})}function capitalize(){return this.charAt(0).toUpperCase()+this.substring(1).toLowerCase()}function underscore(){return this.replace(/::/g,\"/\").replace(/([A-Z]+)([A-Z][a-z])/g,\"$1_$2\").replace(/([a-z\\d])([A-Z])/g,\"$1_$2\").replace(/-/g,\"_\").toLowerCase()}function dasherize(){return this.replace(/_/g,\"-\")}function inspect(useDoubleQuotes){var escapedString=this.replace(/[\\x00-\\x1f\\\\]/g,function(character){if(character in String.specialChar){return String.specialChar[character]}return\"\\\\u00\"+character.charCodeAt().toPaddedString(2,16)});if(useDoubleQuotes){return'\"'+escapedString.replace(/\"/g,'\\\\\"')+'\"'}return\"'\"+escapedString.replace(/'/g,\"\\\\'\")+\"'\"}function unfilterJSON(filter){return this.replace(filter||Prototype.JSONFilter,\"$1\")}function isJSON(){var str=this;if(str.blank()){return false}str=str.replace(/\\\\(?:[\"\\\\\\/bfnrt]|u[0-9a-fA-F]{4})/g,\"@\");str=str.replace(/\"[^\"\\\\\\n\\r]*\"|true|false|null|-?\\d+(?:\\.\\d*)?(?:[eE][+\\-]?\\d+)?/g,\"]\");str=str.replace(/(?:^|:|,)(?:\\s*\\[)+/g,\"\");return(/^[\\],:{}\\s]*$/).test(str)}function evalJSON(sanitize){var json=this.unfilterJSON(),cx=/[\\u00ad\\u0600-\\u0604\\u070f\\u17b4\\u17b5\\u200c-\\u200f\\u2028-\\u202f\\u2060-\\u206f\\ufeff\\ufff0-\\uffff\\u0000]/g;if(cx.test(json)){json=json.replace(cx,function(a){return\"\\\\u\"+(\"0000\"+a.charCodeAt(0).toString(16)).slice(-4)})}try{if(!sanitize||json.isJSON()){return eval(\"(\"+json+\")\")}}catch(e){}throw new SyntaxError(\"Badly formed JSON string: \"+this.inspect())}function parseJSON(){var json=this.unfilterJSON();return JSON.parse(json)}function include(pattern){return this.indexOf(pattern)>-1}function startsWith(pattern,position){position=Object.isNumber(position)?position:0;return this.lastIndexOf(pattern,position)===position}function endsWith(pattern,position){pattern=String(pattern);position=Object.isNumber(position)?position:this.length;if(position<0){position=0}if(position>this.length){position=this.length}var d=position-pattern.length;return d>=0&&this.indexOf(pattern,d)===d}function empty(){return this==\"\"}function blank(){return/^\\s*$/.test(this)}function interpolate(object,pattern){return new Template(this,pattern).evaluate(object)}return{gsub:gsub,sub:sub,scan:scan,truncate:truncate,strip:String.prototype.trim||strip,stripTags:stripTags,stripScripts:stripScripts,extractScripts:extractScripts,evalScripts:evalScripts,escapeHTML:escapeHTML,unescapeHTML:unescapeHTML,toQueryParams:toQueryParams,parseQuery:toQueryParams,toArray:toArray,succ:succ,times:times,camelize:camelize,capitalize:capitalize,underscore:underscore,dasherize:dasherize,inspect:inspect,unfilterJSON:unfilterJSON,isJSON:isJSON,evalJSON:NATIVE_JSON_PARSE_SUPPORT?parseJSON:evalJSON,include:include,startsWith:String.prototype.startsWith||startsWith,endsWith:String.prototype.endsWith||endsWith,empty:empty,blank:blank,interpolate:interpolate}})());var Template=Class.create({initialize:function(b,d){this.template=b.toString();this.pattern=d||Template.Pattern},evaluate:function(b){if(b&&Object.isFunction(b.toTemplateReplacements)){b=b.toTemplateReplacements()}return this.template.gsub(this.pattern,function(f){if(b==null){return(f[1]+\"\")}var h=f[1]||\"\";if(h==\"\\\\\"){return f[2]}var d=b,l=f[3],g=/^([^.[]+|\\[((?:.*?[^\\\\])?)\\])(\\.|\\[|$)/;f=g.exec(l);if(f==null){return h}while(f!=null){var e=f[1].startsWith(\"[\")?f[2].replace(/\\\\\\\\]/g,\"]\"):f[1];d=d[e];if(null==d||\"\"==f[3]){break}l=l.substring(\"[\"==f[3]?f[1].length:f[0].length);f=g.exec(l)}return h+String.interpret(d)})}});Template.Pattern=/(^|.|\\r|\\n)(#\\{(.*?)\\})/;var $break={};var Enumerable=(function(){function e(E,D){try{this._each(E,D)}catch(F){if(F!=$break){throw F}}return this}function y(G,F,E){var D=-G,H=[],I=this.toArray();if(G<1){return I}while((D+=G)<I.length){H.push(I.slice(D,D+G))}return H.collect(F,E)}function d(F,E){F=F||Prototype.K;var D=true;this.each(function(H,G){D=D&&!!F.call(E,H,G,this);if(!D){throw $break}},this);return D}function o(F,E){F=F||Prototype.K;var D=false;this.each(function(H,G){if(D=!!F.call(E,H,G,this)){throw $break}},this);return D}function p(F,E){F=F||Prototype.K;var D=[];this.each(function(H,G){D.push(F.call(E,H,G,this))},this);return D}function A(F,E){var D;this.each(function(H,G){if(F.call(E,H,G,this)){D=H;throw $break}},this);return D}function n(F,E){var D=[];this.each(function(H,G){if(F.call(E,H,G,this)){D.push(H)}},this);return D}function l(G,F,E){F=F||Prototype.K;var D=[];if(Object.isString(G)){G=new RegExp(RegExp.escape(G))}this.each(function(I,H){if(G.match(I)){D.push(F.call(E,I,H,this))}},this);return D}function b(D){if(Object.isFunction(this.indexOf)&&this.indexOf(D)!=-1){return true}var E=false;this.each(function(F){if(F==D){E=true;throw $break}});return E}function w(E,D){D=Object.isUndefined(D)?null:D;return this.eachSlice(E,function(F){while(F.length<E){F.push(D)}return F})}function r(D,F,E){this.each(function(H,G){D=F.call(E,D,H,G,this)},this);return D}function C(E){var D=$A(arguments).slice(1);return this.map(function(F){return F[E].apply(F,D)})}function v(F,E){F=F||Prototype.K;var D;this.each(function(H,G){H=F.call(E,H,G,this);if(D==null||H>=D){D=H}},this);return D}function t(F,E){F=F||Prototype.K;var D;this.each(function(H,G){H=F.call(E,H,G,this);if(D==null||H<D){D=H}},this);return D}function g(G,E){G=G||Prototype.K;var F=[],D=[];this.each(function(I,H){(G.call(E,I,H,this)?F:D).push(I)},this);return[F,D]}function h(E){var D=[];this.each(function(F){D.push(F[E])});return D}function f(F,E){var D=[];this.each(function(H,G){if(!F.call(E,H,G,this)){D.push(H)}},this);return D}function s(E,D){return this.map(function(G,F){return{value:G,criteria:E.call(D,G,F,this)}},this).sort(function(I,H){var G=I.criteria,F=H.criteria;return G<F?-1:G>F?1:0}).pluck(\"value\")}function u(){return this.map()}function z(){var E=Prototype.K,D=$A(arguments);if(Object.isFunction(D.last())){E=D.pop()}var F=[this].concat(D).map($A);return this.map(function(H,G){return E(F.pluck(G))})}function q(){return this.toArray().length}function B(){return\"#<Enumerable:\"+this.toArray().inspect()+\">\"}return{each:e,eachSlice:y,all:d,every:d,any:o,some:o,collect:p,map:p,detect:A,findAll:n,select:n,filter:n,grep:l,include:b,member:b,inGroupsOf:w,inject:r,invoke:C,max:v,min:t,partition:g,pluck:h,reject:f,sortBy:s,toArray:u,entries:u,zip:z,size:q,inspect:B,find:A}})();function $A(e){if(!e){return[]}if(\"toArray\" in Object(e)){return e.toArray()}var d=e.length||0,b=new Array(d);while(d--){b[d]=e[d]}return b}function $w(b){if(!Object.isString(b)){return[]}b=b.strip();return b?b.split(/\\s+/):[]}Array.from=Array.from||$A;(function(){var C=Array.prototype,u=C.slice,w=C.forEach;function d(I,H){for(var G=0,J=this.length>>>0;G<J;G++){if(G in this){I.call(H,this[G],G,this)}}}if(!w){w=d}function t(){this.length=0;return this}function f(){return this[0]}function l(){return this[this.length-1]}function q(){return this.select(function(G){return G!=null})}function F(){return this.inject([],function(H,G){if(Object.isArray(G)){return H.concat(G.flatten())}H.push(G);return H})}function p(){var G=u.call(arguments,0);return this.select(function(H){return !G.include(H)})}function h(G){return(G===false?this.toArray():this)._reverse()}function s(G){return this.inject([],function(J,I,H){if(0==H||(G?J.last()!=I:!J.include(I))){J.push(I)}return J})}function y(G){return this.uniq().findAll(function(H){return G.indexOf(H)!==-1})}function A(){return u.call(this,0)}function r(){return this.length}function D(){return\"[\"+this.map(Object.inspect).join(\", \")+\"]\"}function b(J,H){if(this==null){throw new TypeError()}var K=Object(this),I=K.length>>>0;if(I===0){return -1}H=Number(H);if(isNaN(H)){H=0}else{if(H!==0&&isFinite(H)){H=(H>0?1:-1)*Math.floor(Math.abs(H))}}if(H>I){return -1}var G=H>=0?H:Math.max(I-Math.abs(H),0);for(;G<I;G++){if(G in K&&K[G]===J){return G}}return -1}function v(J,H){if(this==null){throw new TypeError()}var K=Object(this),I=K.length>>>0;if(I===0){return -1}if(!Object.isUndefined(H)){H=Number(H);if(isNaN(H)){H=0}else{if(H!==0&&isFinite(H)){H=(H>0?1:-1)*Math.floor(Math.abs(H))}}}else{H=I}var G=H>=0?Math.min(H,I-1):I-Math.abs(H);for(;G>=0;G--){if(G in K&&K[G]===J){return G}}return -1}function e(N){var L=[],M=u.call(arguments,0),O,H=0;M.unshift(this);for(var K=0,G=M.length;K<G;K++){O=M[K];if(Object.isArray(O)&&!(\"callee\" in O)){for(var J=0,I=O.length;J<I;J++){if(J in O){L[H]=O[J]}H++}}else{L[H++]=O}}L.length=H;return L}function z(G){return function(){if(arguments.length===0){return G.call(this,Prototype.K)}else{if(arguments[0]===undefined){var H=u.call(arguments,1);H.unshift(Prototype.K);return G.apply(this,H)}else{return G.apply(this,arguments)}}}}function B(K){if(this==null){throw new TypeError()}K=K||Prototype.K;var G=Object(this);var J=[],I=arguments[1],M=0;for(var H=0,L=G.length>>>0;H<L;H++){if(H in G){J[M]=K.call(I,G[H],H,G)}M++}J.length=M;return J}if(C.map){B=z(Array.prototype.map)}function n(K){if(this==null||!Object.isFunction(K)){throw new TypeError()}var G=Object(this);var J=[],I=arguments[1],M;for(var H=0,L=G.length>>>0;H<L;H++){if(H in G){M=G[H];if(K.call(I,M,H,G)){J.push(M)}}}return J}if(C.filter){n=Array.prototype.filter}function o(J){if(this==null){throw new TypeError()}J=J||Prototype.K;var I=arguments[1];var G=Object(this);for(var H=0,K=G.length>>>0;H<K;H++){if(H in G&&J.call(I,G[H],H,G)){return true}}return false}if(C.some){o=z(Array.prototype.some)}function E(J){if(this==null){throw new TypeError()}J=J||Prototype.K;var I=arguments[1];var G=Object(this);for(var H=0,K=G.length>>>0;H<K;H++){if(H in G&&!J.call(I,G[H],H,G)){return false}}return true}if(C.every){E=z(Array.prototype.every)}Object.extend(C,Enumerable);if(C.entries===Enumerable.entries){delete C.entries}if(!C._reverse){C._reverse=C.reverse}Object.extend(C,{_each:w,map:B,collect:B,select:n,filter:n,findAll:n,some:o,any:o,every:E,all:E,clear:t,first:f,last:l,compact:q,flatten:F,without:p,reverse:h,uniq:s,intersect:y,clone:A,toArray:A,size:r,inspect:D});var g=(function(){return[].concat(arguments)[0][0]!==1})(1,2);if(g){C.concat=e}if(!C.indexOf){C.indexOf=b}if(!C.lastIndexOf){C.lastIndexOf=v}})();function $H(b){return new Hash(b)}var Hash=Class.create(Enumerable,(function(){function g(v){this._object=Object.isHash(v)?v.toObject():Object.clone(v)}function h(z,y){var w=0;for(var v in this._object){var A=this._object[v],B=[v,A];B.key=v;B.value=A;z.call(y,B,w);w++}}function p(v,w){return this._object[v]=w}function e(v){if(this._object[v]!==Object.prototype[v]){return this._object[v]}}function s(v){var w=this._object[v];delete this._object[v];return w}function u(){return Object.clone(this._object)}function t(){return this.pluck(\"key\")}function r(){return this.pluck(\"value\")}function l(w){var v=this.detect(function(y){return y.value===w});return v&&v.key}function o(v){return this.clone().update(v)}function f(v){return new Hash(v).inject(this,function(w,y){w.set(y.key,y.value);return w})}function d(v,w){if(Object.isUndefined(w)){return v}w=String.interpret(w);w=w.gsub(/(\\r)?\\n/,\"\\r\\n\");w=encodeURIComponent(w);w=w.gsub(/%20/,\"+\");return v+\"=\"+w}function b(){return this.inject([],function(A,D){var z=encodeURIComponent(D.key),w=D.value;if(w&&typeof w==\"object\"){if(Object.isArray(w)){var C=[];for(var y=0,v=w.length,B;y<v;y++){B=w[y];C.push(d(z,B))}return A.concat(C)}}else{A.push(d(z,w))}return A}).join(\"&\")}function q(){return\"#<Hash:{\"+this.map(function(v){return v.map(Object.inspect).join(\": \")}).join(\", \")+\"}>\"}function n(){return new Hash(this)}return{initialize:g,_each:h,set:p,get:e,unset:s,toObject:u,toTemplateReplacements:u,keys:t,values:r,index:l,merge:o,update:f,toQueryString:b,inspect:q,toJSON:u,clone:n}})());Hash.from=$H;Object.extend(Number.prototype,(function(){function f(){return this.toPaddedString(2,16)}function d(){return this+1}function n(p,o){$R(0,this,true).each(p,o);return this}function l(q,p){var o=this.toString(p||10);return\"0\".times(q-o.length)+o}function b(){return Math.abs(this)}function e(){return Math.round(this)}function g(){return Math.ceil(this)}function h(){return Math.floor(this)}return{toColorPart:f,succ:d,times:n,toPaddedString:l,abs:b,round:e,ceil:g,floor:h}})());function $R(e,b,d){return new ObjectRange(e,b,d)}var ObjectRange=Class.create(Enumerable,(function(){function d(h,f,g){this.start=h;this.end=f;this.exclusive=g}function e(h,g){var l=this.start,f;for(f=0;this.include(l);f++){h.call(g,l,f);l=l.succ()}}function b(f){if(f<this.start){return false}if(this.exclusive){return f<this.end}return f<=this.end}return{initialize:d,_each:e,include:b}})());var Abstract={};var Try={these:function(){var f;for(var d=0,g=arguments.length;d<g;d++){var b=arguments[d];try{f=b();break}catch(h){}}return f}};var Ajax={getTransport:function(){return Try.these(function(){return new XMLHttpRequest()},function(){return new ActiveXObject(\"Msxml2.XMLHTTP\")},function(){return new ActiveXObject(\"Microsoft.XMLHTTP\")})||false},activeRequestCount:0};Ajax.Responders={responders:[],_each:function(d,b){this.responders._each(d,b)},register:function(b){if(!this.include(b)){this.responders.push(b)}},unregister:function(b){this.responders=this.responders.without(b)},dispatch:function(f,d,e,b){this.each(function(g){if(Object.isFunction(g[f])){try{g[f].apply(g,[d,e,b])}catch(h){}}})}};Object.extend(Ajax.Responders,Enumerable);Ajax.Responders.register({onCreate:function(){Ajax.activeRequestCount++},onComplete:function(){Ajax.activeRequestCount--}});Ajax.Base=Class.create({initialize:function(b){this.options={method:\"post\",asynchronous:true,contentType:\"application/x-www-form-urlencoded\",encoding:\"UTF-8\",parameters:\"\",evalJSON:true,evalJS:true};Object.extend(this.options,b||{});this.options.method=this.options.method.toLowerCase();if(Object.isHash(this.options.parameters)){this.options.parameters=this.options.parameters.toObject()}}});Ajax.Request=Class.create(Ajax.Base,{_complete:false,initialize:function($super,d,b){$super(b);this.transport=Ajax.getTransport();this.request(d)},request:function(d){this.url=d;this.method=this.options.method;var g=Object.isString(this.options.parameters)?this.options.parameters:Object.toQueryString(this.options.parameters);if(![\"get\",\"post\"].include(this.method)){g+=(g?\"&\":\"\")+\"_method=\"+this.method;this.method=\"post\"}if(g&&this.method===\"get\"){this.url+=(this.url.include(\"?\")?\"&\":\"?\")+g}this.parameters=g.toQueryParams();try{var b=new Ajax.Response(this);if(this.options.onCreate){this.options.onCreate(b)}Ajax.Responders.dispatch(\"onCreate\",this,b);this.transport.open(this.method.toUpperCase(),this.url,this.options.asynchronous);if(this.options.asynchronous){this.respondToReadyState.bind(this).defer(1)}this.transport.onreadystatechange=this.onStateChange.bind(this);this.setRequestHeaders();this.body=this.method==\"post\"?(this.options.postBody||g):null;this.transport.send(this.body);if(!this.options.asynchronous&&this.transport.overrideMimeType){this.onStateChange()}}catch(f){this.dispatchException(f)}},onStateChange:function(){var b=this.transport.readyState;if(b>1&&!((b==4)&&this._complete)){this.respondToReadyState(this.transport.readyState)}},setRequestHeaders:function(){var g={\"X-Requested-With\":\"XMLHttpRequest\",\"X-Prototype-Version\":Prototype.Version,Accept:\"text/javascript, text/html, application/xml, text/xml, */*\"};if(this.method==\"post\"){g[\"Content-type\"]=this.options.contentType+(this.options.encoding?\"; charset=\"+this.options.encoding:\"\");if(this.transport.overrideMimeType&&(navigator.userAgent.match(/Gecko\\/(\\d{4})/)||[0,2005])[1]<2005){g.Connection=\"close\"}}if(typeof this.options.requestHeaders==\"object\"){var e=this.options.requestHeaders;if(Object.isFunction(e.push)){for(var d=0,f=e.length;d<f;d+=2){g[e[d]]=e[d+1]}}else{$H(e).each(function(h){g[h.key]=h.value})}}for(var b in g){if(g[b]!=null){this.transport.setRequestHeader(b,g[b])}}},success:function(){var b=this.getStatus();return !b||(b>=200&&b<300)||b==304},getStatus:function(){try{if(this.transport.status===1223){return 204}return this.transport.status||0}catch(b){return 0}},respondToReadyState:function(b){var f=Ajax.Request.Events[b],d=new Ajax.Response(this);if(f==\"Complete\"){try{this._complete=true;(this.options[\"on\"+d.status]||this.options[\"on\"+(this.success()?\"Success\":\"Failure\")]||Prototype.emptyFunction)(d,d.headerJSON)}catch(g){this.dispatchException(g)}var h=d.getHeader(\"Content-type\");if(this.options.evalJS==\"force\"||(this.options.evalJS&&this.isSameOrigin()&&h&&h.match(/^\\s*(text|application)\\/(x-)?(java|ecma)script(;.*)?\\s*$/i))){this.evalResponse()}}try{(this.options[\"on\"+f]||Prototype.emptyFunction)(d,d.headerJSON);Ajax.Responders.dispatch(\"on\"+f,this,d,d.headerJSON)}catch(g){this.dispatchException(g)}if(f==\"Complete\"){this.transport.onreadystatechange=Prototype.emptyFunction}},isSameOrigin:function(){var b=this.url.match(/^\\s*https?:\\/\\/[^\\/]*/);return !b||(b[0]==\"#{protocol}//#{domain}#{port}\".interpolate({protocol:location.protocol,domain:document.domain,port:location.port?\":\"+location.port:\"\"}))},getHeader:function(b){try{return this.transport.getResponseHeader(b)||null}catch(d){return null}},evalResponse:function(){try{return eval((this.transport.responseText||\"\").unfilterJSON())}catch(e){this.dispatchException(e)}},dispatchException:function(b){(this.options.onException||Prototype.emptyFunction)(this,b);Ajax.Responders.dispatch(\"onException\",this,b)}});Ajax.Request.Events=[\"Uninitialized\",\"Loading\",\"Loaded\",\"Interactive\",\"Complete\"];Ajax.Response=Class.create({initialize:function(e){this.request=e;var f=this.transport=e.transport,b=this.readyState=f.readyState;if((b>2&&!Prototype.Browser.IE)||b==4){this.status=this.getStatus();this.statusText=this.getStatusText();this.responseText=String.interpret(f.responseText);this.headerJSON=this._getHeaderJSON()}if(b==4){var d=f.responseXML;this.responseXML=Object.isUndefined(d)?null:d;this.responseJSON=this._getResponseJSON()}},status:0,statusText:\"\",getStatus:Ajax.Request.prototype.getStatus,getStatusText:function(){try{return this.transport.statusText||\"\"}catch(b){return\"\"}},getHeader:Ajax.Request.prototype.getHeader,getAllHeaders:function(){try{return this.getAllResponseHeaders()}catch(b){return null}},getResponseHeader:function(b){return this.transport.getResponseHeader(b)},getAllResponseHeaders:function(){return this.transport.getAllResponseHeaders()},_getHeaderJSON:function(){var b=this.getHeader(\"X-JSON\");if(!b){return null}try{b=decodeURIComponent(escape(b))}catch(d){}try{return b.evalJSON(this.request.options.sanitizeJSON||!this.request.isSameOrigin())}catch(d){this.request.dispatchException(d)}},_getResponseJSON:function(){var b=this.request.options;if(!b.evalJSON||(b.evalJSON!=\"force\"&&!(this.getHeader(\"Content-type\")||\"\").include(\"application/json\"))||this.responseText.blank()){return null}try{return this.responseText.evalJSON(b.sanitizeJSON||!this.request.isSameOrigin())}catch(d){this.request.dispatchException(d)}}});Ajax.Updater=Class.create(Ajax.Request,{initialize:function($super,b,e,d){this.container={success:(b.success||b),failure:(b.failure||(b.success?null:b))};d=Object.clone(d);var f=d.onComplete;d.onComplete=(function(g,h){this.updateContent(g.responseText);if(Object.isFunction(f)){f(g,h)}}).bind(this);$super(e,d)},updateContent:function(f){var e=this.container[this.success()?\"success\":\"failure\"],b=this.options;if(!b.evalScripts){f=f.stripScripts()}if(e=$(e)){if(b.insertion){if(Object.isString(b.insertion)){var d={};d[b.insertion]=f;e.insert(d)}else{b.insertion(e,f)}}else{e.update(f)}}}});Ajax.PeriodicalUpdater=Class.create(Ajax.Base,{initialize:function($super,b,e,d){$super(d);this.onComplete=this.options.onComplete;this.frequency=(this.options.frequency||2);this.decay=(this.options.decay||1);this.updater={};this.container=b;this.url=e;this.start()},start:function(){this.options.onComplete=this.updateComplete.bind(this);this.onTimerEvent()},stop:function(){this.updater.options.onComplete=undefined;clearTimeout(this.timer);(this.onComplete||Prototype.emptyFunction).apply(this,arguments)},updateComplete:function(b){if(this.options.decay){this.decay=(b.responseText==this.lastText?this.decay*this.options.decay:1);this.lastText=b.responseText}this.timer=this.onTimerEvent.bind(this).delay(this.decay*this.frequency)},onTimerEvent:function(){this.updater=new Ajax.Updater(this.container,this.url,this.options)}});(function(be){var aK;var a7=Array.prototype.slice;var aB=document.createElement(\"div\");function a5(bv){if(arguments.length>1){for(var F=0,bx=[],bw=arguments.length;F<bw;F++){bx.push(a5(arguments[F]))}return bx}if(Object.isString(bv)){bv=document.getElementById(bv)}return aL.extend(bv)}be.$=a5;if(!be.Node){be.Node={}}if(!be.Node.ELEMENT_NODE){Object.extend(be.Node,{ELEMENT_NODE:1,ATTRIBUTE_NODE:2,TEXT_NODE:3,CDATA_SECTION_NODE:4,ENTITY_REFERENCE_NODE:5,ENTITY_NODE:6,PROCESSING_INSTRUCTION_NODE:7,COMMENT_NODE:8,DOCUMENT_NODE:9,DOCUMENT_TYPE_NODE:10,DOCUMENT_FRAGMENT_NODE:11,NOTATION_NODE:12})}var w={};function aW(bv,F){if(bv===\"select\"){return false}if(\"type\" in F){return false}return true}var f=(function(){try{var F=document.createElement('<input name=\"x\">');return F.tagName.toLowerCase()===\"input\"&&F.name===\"x\"}catch(bv){return false}})();var aO=be.Element;function aL(bv,F){F=F||{};bv=bv.toLowerCase();if(f&&F.name){bv=\"<\"+bv+' name=\"'+F.name+'\">';delete F.name;return aL.writeAttribute(document.createElement(bv),F)}if(!w[bv]){w[bv]=aL.extend(document.createElement(bv))}var bw=aW(bv,F)?w[bv].cloneNode(false):document.createElement(bv);return aL.writeAttribute(bw,F)}be.Element=aL;Object.extend(be.Element,aO||{});if(aO){be.Element.prototype=aO.prototype}aL.Methods={ByTag:{},Simulated:{}};var a9={};var N={id:\"id\",className:\"class\"};function bg(bv){bv=a5(bv);var F=\"<\"+bv.tagName.toLowerCase();var bw,by;for(var bx in N){bw=N[bx];by=(bv[bx]||\"\").toString();if(by){F+=\" \"+bw+\"=\"+by.inspect(true)}}return F+\">\"}a9.inspect=bg;function B(F){return a5(F).getStyle(\"display\")!==\"none\"}function aD(bv,F){bv=a5(bv);if(typeof F!==\"boolean\"){F=!aL.visible(bv)}aL[F?\"show\":\"hide\"](bv);return bv}function aN(F){F=a5(F);F.style.display=\"none\";return F}function o(F){F=a5(F);F.style.display=\"\";return F}Object.extend(a9,{visible:B,toggle:aD,hide:aN,show:o});function aj(F){F=a5(F);F.parentNode&&F.parentNode.removeChild(F);return F}var aZ=(function(){var F=document.createElement(\"select\"),bv=true;F.innerHTML='<option value=\"test\">test</option>';if(F.options&&F.options[0]){bv=F.options[0].nodeName.toUpperCase()!==\"OPTION\"}F=null;return bv})();var O=(function(){try{var F=document.createElement(\"table\");if(F&&F.tBodies){F.innerHTML=\"<tbody><tr><td>test</td></tr></tbody>\";var bw=typeof F.tBodies[0]==\"undefined\";F=null;return bw}}catch(bv){return true}})();var a8=(function(){try{var F=document.createElement(\"div\");F.innerHTML=\"<link />\";var bw=(F.childNodes.length===0);F=null;return bw}catch(bv){return true}})();var D=aZ||O||a8;var ax=(function(){var F=document.createElement(\"script\"),bw=false;try{F.appendChild(document.createTextNode(\"\"));bw=!F.firstChild||F.firstChild&&F.firstChild.nodeType!==3}catch(bv){bw=true}F=null;return bw})();function U(bx,bz){bx=a5(bx);var bA=bx.getElementsByTagName(\"*\"),bw=bA.length;while(bw--){af(bA[bw])}if(bz&&bz.toElement){bz=bz.toElement()}if(Object.isElement(bz)){return bx.update().insert(bz)}bz=Object.toHTML(bz);var bv=bx.tagName.toUpperCase();if(bv===\"SCRIPT\"&&ax){bx.text=bz;return bx}if(D){if(bv in R.tags){while(bx.firstChild){bx.removeChild(bx.firstChild)}var F=z(bv,bz.stripScripts());for(var bw=0,by;by=F[bw];bw++){bx.appendChild(by)}}else{if(a8&&Object.isString(bz)&&bz.indexOf(\"<link\")>-1){while(bx.firstChild){bx.removeChild(bx.firstChild)}var F=z(bv,bz.stripScripts(),true);for(var bw=0,by;by=F[bw];bw++){bx.appendChild(by)}}else{bx.innerHTML=bz.stripScripts()}}}else{bx.innerHTML=bz.stripScripts()}bz.evalScripts.bind(bz).defer();return bx}function an(bv,bw){bv=a5(bv);if(bw&&bw.toElement){bw=bw.toElement()}else{if(!Object.isElement(bw)){bw=Object.toHTML(bw);var F=bv.ownerDocument.createRange();F.selectNode(bv);bw.evalScripts.bind(bw).defer();bw=F.createContextualFragment(bw.stripScripts())}}bv.parentNode.replaceChild(bw,bv);return bv}var R={before:function(F,bv){F.parentNode.insertBefore(bv,F)},top:function(F,bv){F.insertBefore(bv,F.firstChild)},bottom:function(F,bv){F.appendChild(bv)},after:function(F,bv){F.parentNode.insertBefore(bv,F.nextSibling)},tags:{TABLE:[\"<table>\",\"</table>\",1],TBODY:[\"<table><tbody>\",\"</tbody></table>\",2],TR:[\"<table><tbody><tr>\",\"</tr></tbody></table>\",3],TD:[\"<table><tbody><tr><td>\",\"</td></tr></tbody></table>\",4],SELECT:[\"<select>\",\"</select>\",1]}};var aP=R.tags;Object.extend(aP,{THEAD:aP.TBODY,TFOOT:aP.TBODY,TH:aP.TD});function av(bw,bz){bw=a5(bw);if(bz&&bz.toElement){bz=bz.toElement()}if(Object.isElement(bz)){bw.parentNode.replaceChild(bz,bw);return bw}bz=Object.toHTML(bz);var by=bw.parentNode,bv=by.tagName.toUpperCase();if(bv in R.tags){var bA=aL.next(bw);var F=z(bv,bz.stripScripts());by.removeChild(bw);var bx;if(bA){bx=function(bB){by.insertBefore(bB,bA)}}else{bx=function(bB){by.appendChild(bB)}}F.each(bx)}else{bw.outerHTML=bz.stripScripts()}bz.evalScripts.bind(bz).defer();return bw}if(\"outerHTML\" in document.documentElement){an=av}function bd(F){if(Object.isUndefined(F)||F===null){return false}if(Object.isString(F)||Object.isNumber(F)){return true}if(Object.isElement(F)){return true}if(F.toElement||F.toHTML){return true}return false}function bt(bx,bz,F){F=F.toLowerCase();var bB=R[F];if(bz&&bz.toElement){bz=bz.toElement()}if(Object.isElement(bz)){bB(bx,bz);return bx}bz=Object.toHTML(bz);var bw=((F===\"before\"||F===\"after\")?bx.parentNode:bx).tagName.toUpperCase();var bA=z(bw,bz.stripScripts());if(F===\"top\"||F===\"after\"){bA.reverse()}for(var bv=0,by;by=bA[bv];bv++){bB(bx,by)}bz.evalScripts.bind(bz).defer()}function W(bv,bw){bv=a5(bv);if(bd(bw)){bw={bottom:bw}}for(var F in bw){bt(bv,bw[F],F)}return bv}function A(bv,bw,F){bv=a5(bv);if(Object.isElement(bw)){a5(bw).writeAttribute(F||{})}else{if(Object.isString(bw)){bw=new aL(bw,F)}else{bw=new aL(\"div\",bw)}}if(bv.parentNode){bv.parentNode.replaceChild(bw,bv)}bw.appendChild(bv);return bw}function C(bv){bv=a5(bv);var bw=bv.firstChild;while(bw){var F=bw.nextSibling;if(bw.nodeType===Node.TEXT_NODE&&!/\\S/.test(bw.nodeValue)){bv.removeChild(bw)}bw=F}return bv}function ba(F){return a5(F).innerHTML.blank()}function z(by,bx,bz){var bw=R.tags[by],bA=aB;var F=!!bw;if(!F&&bz){F=true;bw=[\"\",\"\",0]}if(F){bA.innerHTML=\"&#160;\"+bw[0]+bx+bw[1];bA.removeChild(bA.firstChild);for(var bv=bw[2];bv--;){bA=bA.firstChild}}else{bA.innerHTML=bx}return $A(bA.childNodes)}function L(bw,F){if(!(bw=a5(bw))){return}var by=bw.cloneNode(F);if(!a4){by._prototypeUID=aK;if(F){var bx=aL.select(by,\"*\"),bv=bx.length;while(bv--){bx[bv]._prototypeUID=aK}}}return aL.extend(by)}function af(bv){var F=S(bv);if(F){aL.stopObserving(bv);if(!a4){bv._prototypeUID=aK}delete aL.Storage[F]}}function br(bv){var F=bv.length;while(F--){af(bv[F])}}function az(bx){var bw=bx.length,bv,F;while(bw--){bv=bx[bw];F=S(bv);delete aL.Storage[F];delete Event.cache[F]}}if(a4){br=az}function r(bv){if(!(bv=a5(bv))){return}af(bv);var bw=bv.getElementsByTagName(\"*\"),F=bw.length;while(F--){af(bw[F])}return null}Object.extend(a9,{remove:aj,update:U,replace:an,insert:W,wrap:A,cleanWhitespace:C,empty:ba,clone:L,purge:r});function at(F,bw,bx){F=a5(F);bx=bx||-1;var bv=[];while(F=F[bw]){if(F.nodeType===Node.ELEMENT_NODE){bv.push(aL.extend(F))}if(bv.length===bx){break}}return bv}function aR(F){return at(F,\"parentNode\")}function bs(F){return aL.select(F,\"*\")}function ad(F){F=a5(F).firstChild;while(F&&F.nodeType!==Node.ELEMENT_NODE){F=F.nextSibling}return a5(F)}function bo(bv){var F=[],bw=a5(bv).firstChild;while(bw){if(bw.nodeType===Node.ELEMENT_NODE){F.push(aL.extend(bw))}bw=bw.nextSibling}return F}function u(F){return at(F,\"previousSibling\")}function bn(F){return at(F,\"nextSibling\")}function a1(F){F=a5(F);var bw=u(F),bv=bn(F);return bw.reverse().concat(bv)}function aX(bv,F){bv=a5(bv);if(Object.isString(F)){return Prototype.Selector.match(bv,F)}return F.match(bv)}function a2(bv,bw,bx,F){bv=a5(bv),bx=bx||0,F=F||0;if(Object.isNumber(bx)){F=bx,bx=null}while(bv=bv[bw]){if(bv.nodeType!==1){continue}if(bx&&!Prototype.Selector.match(bv,bx)){continue}if(--F>=0){continue}return aL.extend(bv)}}function ag(bv,bw,F){bv=a5(bv);if(arguments.length===1){return a5(bv.parentNode)}return a2(bv,\"parentNode\",bw,F)}function E(bv,bx,F){if(arguments.length===1){return ad(bv)}bv=a5(bv),bx=bx||0,F=F||0;if(Object.isNumber(bx)){F=bx,bx=\"*\"}var bw=Prototype.Selector.select(bx,bv)[F];return aL.extend(bw)}function n(bv,bw,F){return a2(bv,\"previousSibling\",bw,F)}function aH(bv,bw,F){return a2(bv,\"nextSibling\",bw,F)}function bh(F){F=a5(F);var bv=a7.call(arguments,1).join(\", \");return Prototype.Selector.select(bv,F)}function aJ(bw){bw=a5(bw);var by=a7.call(arguments,1).join(\", \");var bz=aL.siblings(bw),bv=[];for(var F=0,bx;bx=bz[F];F++){if(Prototype.Selector.match(bx,by)){bv.push(bx)}}return bv}function K(bv,F){bv=a5(bv),F=a5(F);if(!bv||!F){return false}while(bv=bv.parentNode){if(bv===F){return true}}return false}function I(bv,F){bv=a5(bv),F=a5(F);if(!bv||!F){return false}if(!F.contains){return K(bv,F)}return F.contains(bv)&&F!==bv}function P(bv,F){bv=a5(bv),F=a5(F);if(!bv||!F){return false}return(bv.compareDocumentPosition(F)&8)===8}var aS;if(aB.compareDocumentPosition){aS=P}else{if(aB.contains){aS=I}else{aS=K}}Object.extend(a9,{recursivelyCollect:at,ancestors:aR,descendants:bs,firstDescendant:ad,immediateDescendants:bo,previousSiblings:u,nextSiblings:bn,siblings:a1,match:aX,up:ag,down:E,previous:n,next:aH,select:bh,adjacent:aJ,descendantOf:aS,getElementsBySelector:bh,childElements:bo});var Z=1;function a0(F){F=a5(F);var bv=aL.readAttribute(F,\"id\");if(bv){return bv}do{bv=\"anonymous_element_\"+Z++}while(a5(bv));aL.writeAttribute(F,\"id\",bv);return bv}function bf(bv,F){return a5(bv).getAttribute(F)}function Q(bv,F){bv=a5(bv);var bw=aM.read;if(bw.values[F]){return bw.values[F](bv,F)}if(bw.names[F]){F=bw.names[F]}if(F.include(\":\")){if(!bv.attributes||!bv.attributes[F]){return null}return bv.attributes[F].value}return bv.getAttribute(F)}function g(bv,F){if(F===\"title\"){return bv.title}return bv.getAttribute(F)}var aa=(function(){aB.setAttribute(\"onclick\",[]);var F=aB.getAttribute(\"onclick\");var bv=Object.isArray(F);aB.removeAttribute(\"onclick\");return bv});if(Prototype.Browser.IE&&aa()){bf=Q}else{if(Prototype.Browser.Opera){bf=g}}function a6(bx,bw,bz){bx=a5(bx);var bv={},by=aM.write;if(typeof bw===\"object\"){bv=bw}else{bv[bw]=Object.isUndefined(bz)?true:bz}for(var F in bv){bw=by.names[F]||F;bz=bv[F];if(by.values[F]){bz=by.values[F](bx,bz);if(Object.isUndefined(bz)){continue}}if(bz===false||bz===null){bx.removeAttribute(bw)}else{if(bz===true){bx.setAttribute(bw,bw)}else{bx.setAttribute(bw,bz)}}}return bx}var b=(function(){if(!f){return false}var bv=document.createElement('<input type=\"checkbox\">');bv.checked=true;var F=bv.getAttributeNode(\"checked\");return !F||!F.specified})();function ae(F,bw){bw=aM.has[bw]||bw;var bv=a5(F).getAttributeNode(bw);return !!(bv&&bv.specified)}function bm(F,bv){if(bv===\"checked\"){return F.checked}return ae(F,bv)}be.Element.Methods.Simulated.hasAttribute=b?bm:ae;function p(F){return new aL.ClassNames(F)}var ab={};function h(bv){if(ab[bv]){return ab[bv]}var F=new RegExp(\"(^|\\\\s+)\"+bv+\"(\\\\s+|$)\");ab[bv]=F;return F}function ar(F,bv){if(!(F=a5(F))){return}var bw=F.className;if(bw.length===0){return false}if(bw===bv){return true}return h(bv).test(bw)}function t(F,bv){if(!(F=a5(F))){return}if(!ar(F,bv)){F.className+=(F.className?\" \":\"\")+bv}return F}function aA(F,bv){if(!(F=a5(F))){return}F.className=F.className.replace(h(bv),\" \").strip();return F}function ak(bv,bw,F){if(!(bv=a5(bv))){return}if(Object.isUndefined(F)){F=!ar(bv,bw)}var bx=aL[F?\"addClassName\":\"removeClassName\"];return bx(bv,bw)}var aM={};var aV=\"className\",ay=\"for\";aB.setAttribute(aV,\"x\");if(aB.className!==\"x\"){aB.setAttribute(\"class\",\"x\");if(aB.className===\"x\"){aV=\"class\"}}var aQ=document.createElement(\"label\");aQ.setAttribute(ay,\"x\");if(aQ.htmlFor!==\"x\"){aQ.setAttribute(\"htmlFor\",\"x\");if(aQ.htmlFor===\"x\"){ay=\"htmlFor\"}}aQ=null;function ai(F,bv){return F.getAttribute(bv)}function l(F,bv){return F.getAttribute(bv,2)}function H(F,bw){var bv=F.getAttributeNode(bw);return bv?bv.value:\"\"}function bp(F,bv){return a5(F).hasAttribute(bv)?bv:null}aB.onclick=Prototype.emptyFunction;var V=aB.getAttribute(\"onclick\");var aC;if(String(V).indexOf(\"{\")>-1){aC=function(F,bv){var bw=F.getAttribute(bv);if(!bw){return null}bw=bw.toString();bw=bw.split(\"{\")[1];bw=bw.split(\"}\")[0];return bw.strip()}}else{if(V===\"\"){aC=function(F,bv){var bw=F.getAttribute(bv);if(!bw){return null}return bw.strip()}}}aM.read={names:{\"class\":aV,className:aV,\"for\":ay,htmlFor:ay},values:{style:function(F){return F.style.cssText.toLowerCase()},title:function(F){return F.title}}};aM.write={names:{className:\"class\",htmlFor:\"for\",cellpadding:\"cellPadding\",cellspacing:\"cellSpacing\"},values:{checked:function(F,bv){bv=!!bv;F.checked=bv;return bv?\"checked\":null},style:function(F,bv){F.style.cssText=bv?bv:\"\"}}};aM.has={names:{}};Object.extend(aM.write.names,aM.read.names);var bc=$w(\"colSpan rowSpan vAlign dateTime accessKey tabIndex encType maxLength readOnly longDesc frameBorder\");for(var al=0,am;am=bc[al];al++){aM.write.names[am.toLowerCase()]=am;aM.has.names[am.toLowerCase()]=am}Object.extend(aM.read.values,{href:l,src:l,type:ai,action:H,disabled:bp,checked:bp,readonly:bp,multiple:bp,onload:aC,onunload:aC,onclick:aC,ondblclick:aC,onmousedown:aC,onmouseup:aC,onmouseover:aC,onmousemove:aC,onmouseout:aC,onfocus:aC,onblur:aC,onkeypress:aC,onkeydown:aC,onkeyup:aC,onsubmit:aC,onreset:aC,onselect:aC,onchange:aC});Object.extend(a9,{identify:a0,readAttribute:bf,writeAttribute:a6,classNames:p,hasClassName:ar,addClassName:t,removeClassName:aA,toggleClassName:ak});function ac(F){if(F===\"float\"||F===\"styleFloat\"){return\"cssFloat\"}return F.camelize()}function bu(F){if(F===\"float\"||F===\"cssFloat\"){return\"styleFloat\"}return F.camelize()}function J(bw,bx){bw=a5(bw);var bA=bw.style,bv;if(Object.isString(bx)){bA.cssText+=\";\"+bx;if(bx.include(\"opacity\")){var F=bx.match(/opacity:\\s*(\\d?\\.?\\d*)/)[1];aL.setOpacity(bw,F)}return bw}for(var bz in bx){if(bz===\"opacity\"){aL.setOpacity(bw,bx[bz])}else{var by=bx[bz];if(bz===\"float\"||bz===\"cssFloat\"){bz=Object.isUndefined(bA.styleFloat)?\"cssFloat\":\"styleFloat\"}bA[bz]=by}}return bw}function aU(bv,bw){bv=a5(bv);bw=ac(bw);var bx=bv.style[bw];if(!bx||bx===\"auto\"){var F=document.defaultView.getComputedStyle(bv,null);bx=F?F[bw]:null}if(bw===\"opacity\"){return bx?parseFloat(bx):1}return bx===\"auto\"?null:bx}function y(F,bv){switch(bv){case\"height\":case\"width\":if(!aL.visible(F)){return null}var bw=parseInt(aU(F,bv),10);if(bw!==F[\"offset\"+bv.capitalize()]){return bw+\"px\"}return aL.measure(F,bv);default:return aU(F,bv)}}function ap(F,bv){F=a5(F);bv=bu(bv);var bw=F.style[bv];if(!bw&&F.currentStyle){bw=F.currentStyle[bv]}if(bv===\"opacity\"){if(!T){return bk(F)}else{return bw?parseFloat(bw):1}}if(bw===\"auto\"){if((bv===\"width\"||bv===\"height\")&&aL.visible(F)){return aL.measure(F,bv)+\"px\"}return null}return bw}function aG(F){return(F||\"\").replace(/alpha\\([^\\)]*\\)/gi,\"\")}function ah(F){if(!F.currentStyle||!F.currentStyle.hasLayout){F.style.zoom=1}return F}var T=(function(){aB.style.cssText=\"opacity:.55\";return/^0.55/.test(aB.style.opacity)})();function G(F,bv){F=a5(F);if(bv==1||bv===\"\"){bv=\"\"}else{if(bv<0.00001){bv=0}}F.style.opacity=bv;return F}function bl(F,bx){if(T){return G(F,bx)}F=ah(a5(F));var bw=aL.getStyle(F,\"filter\"),bv=F.style;if(bx==1||bx===\"\"){bw=aG(bw);if(bw){bv.filter=bw}else{bv.removeAttribute(\"filter\")}return F}if(bx<0.00001){bx=0}bv.filter=aG(bw)+\" alpha(opacity=\"+(bx*100)+\")\";return F}function bj(F){return aL.getStyle(F,\"opacity\")}function bk(bv){if(T){return bj(bv)}var bw=aL.getStyle(bv,\"filter\");if(bw.length===0){return 1}var F=(bw||\"\").match(/alpha\\(opacity=(.*)\\)/i);if(F&&F[1]){return parseFloat(F[1])/100}return 1}Object.extend(a9,{setStyle:J,getStyle:aU,setOpacity:G,getOpacity:bj});if(\"styleFloat\" in aB.style){a9.getStyle=ap;a9.setOpacity=bl;a9.getOpacity=bk}var q=0;be.Element.Storage={UID:1};function S(F){if(F===window){return 0}if(typeof F._prototypeUID===\"undefined\"){F._prototypeUID=aL.Storage.UID++}return F._prototypeUID}function e(F){if(F===window){return 0}if(F==document){return 1}return F.uniqueID}var a4=(\"uniqueID\" in aB);if(a4){S=e}function d(bv){if(!(bv=a5(bv))){return}var F=S(bv);if(!aL.Storage[F]){aL.Storage[F]=$H()}return aL.Storage[F]}function bb(bv,F,bw){if(!(bv=a5(bv))){return}var bx=d(bv);if(arguments.length===2){bx.update(F)}else{bx.set(F,bw)}return bv}function aT(bw,bv,F){if(!(bw=a5(bw))){return}var by=d(bw),bx=by.get(bv);if(Object.isUndefined(bx)){by.set(bv,F);bx=F}return bx}Object.extend(a9,{getStorage:d,store:bb,retrieve:aT});var au={},a3=aL.Methods.ByTag,aI=Prototype.BrowserFeatures;if(!aI.ElementExtensions&&(\"__proto__\" in aB)){be.HTMLElement={};be.HTMLElement.prototype=aB.__proto__;aI.ElementExtensions=true}function bi(F){if(typeof window.Element===\"undefined\"){return false}if(!f){return false}var bw=window.Element.prototype;if(bw){var by=\"_\"+(Math.random()+\"\").slice(2),bv=document.createElement(F);bw[by]=\"x\";var bx=(bv[by]!==\"x\");delete bw[by];bv=null;return bx}return false}var aw=bi(\"object\");function aq(bv,F){for(var bx in F){var bw=F[bx];if(Object.isFunction(bw)&&!(bx in bv)){bv[bx]=bw.methodize()}}}var bq={};function aE(bv){var F=S(bv);return(F in bq)}function aF(bw){if(!bw||aE(bw)){return bw}if(bw.nodeType!==Node.ELEMENT_NODE||bw==window){return bw}var F=Object.clone(au),bv=bw.tagName.toUpperCase();if(a3[bv]){Object.extend(F,a3[bv])}aq(bw,F);bq[S(bw)]=true;return bw}function aY(bv){if(!bv||aE(bv)){return bv}var F=bv.tagName;if(F&&(/^(?:object|applet|embed)$/i.test(F))){aq(bv,aL.Methods);aq(bv,aL.Methods.Simulated);aq(bv,aL.Methods.ByTag[F.toUpperCase()])}return bv}if(aI.SpecificElementExtensions){aF=aw?aY:Prototype.K}function Y(bv,F){bv=bv.toUpperCase();if(!a3[bv]){a3[bv]={}}Object.extend(a3[bv],F)}function v(bv,bw,F){if(Object.isUndefined(F)){F=false}for(var by in bw){var bx=bw[by];if(!Object.isFunction(bx)){continue}if(!F||!(by in bv)){bv[by]=bx.methodize()}}}function ao(bx){var F;var bw={OPTGROUP:\"OptGroup\",TEXTAREA:\"TextArea\",P:\"Paragraph\",FIELDSET:\"FieldSet\",UL:\"UList\",OL:\"OList\",DL:\"DList\",DIR:\"Directory\",H1:\"Heading\",H2:\"Heading\",H3:\"Heading\",H4:\"Heading\",H5:\"Heading\",H6:\"Heading\",Q:\"Quote\",INS:\"Mod\",DEL:\"Mod\",A:\"Anchor\",IMG:\"Image\",CAPTION:\"TableCaption\",COL:\"TableCol\",COLGROUP:\"TableCol\",THEAD:\"TableSection\",TFOOT:\"TableSection\",TBODY:\"TableSection\",TR:\"TableRow\",TH:\"TableCell\",TD:\"TableCell\",FRAMESET:\"FrameSet\",IFRAME:\"IFrame\"};if(bw[bx]){F=\"HTML\"+bw[bx]+\"Element\"}if(window[F]){return window[F]}F=\"HTML\"+bx+\"Element\";if(window[F]){return window[F]}F=\"HTML\"+bx.capitalize()+\"Element\";if(window[F]){return window[F]}var bv=document.createElement(bx),by=bv.__proto__||bv.constructor.prototype;bv=null;return by}function X(bx){if(arguments.length===0){M()}if(arguments.length===2){var bz=bx;bx=arguments[1]}if(!bz){Object.extend(aL.Methods,bx||{})}else{if(Object.isArray(bz)){for(var by=0,bw;bw=bz[by];by++){Y(bw,bx)}}else{Y(bz,bx)}}var bv=window.HTMLElement?HTMLElement.prototype:aL.prototype;if(aI.ElementExtensions){v(bv,aL.Methods);v(bv,aL.Methods.Simulated,true)}if(aI.SpecificElementExtensions){for(var bw in aL.Methods.ByTag){var F=ao(bw);if(Object.isUndefined(F)){continue}v(F.prototype,a3[bw])}}Object.extend(aL,aL.Methods);Object.extend(aL,aL.Methods.Simulated);delete aL.ByTag;delete aL.Simulated;aL.extend.refresh();w={}}Object.extend(be.Element,{extend:aF,addMethods:X});if(aF===Prototype.K){be.Element.extend.refresh=Prototype.emptyFunction}else{be.Element.extend.refresh=function(){if(Prototype.BrowserFeatures.ElementExtensions){return}Object.extend(au,aL.Methods);Object.extend(au,aL.Methods.Simulated);bq={}}}function M(){Object.extend(Form,Form.Methods);Object.extend(Form.Element,Form.Element.Methods);Object.extend(aL.Methods.ByTag,{FORM:Object.clone(Form.Methods),INPUT:Object.clone(Form.Element.Methods),SELECT:Object.clone(Form.Element.Methods),TEXTAREA:Object.clone(Form.Element.Methods),BUTTON:Object.clone(Form.Element.Methods)})}aL.addMethods(a9);function s(){aB=null;w=null}if(window.attachEvent){window.attachEvent(\"onunload\",s)}})(this);(function(){function q(N){var M=N.match(/^(\\d+)%?$/i);if(!M){return null}return(Number(M[1])/100)}function F(N,O){N=$(N);var P=N.style[O];if(!P||P===\"auto\"){var M=document.defaultView.getComputedStyle(N,null);P=M?M[O]:null}if(O===\"opacity\"){return P?parseFloat(P):1}return P===\"auto\"?null:P}function I(M,N){var O=M.style[N];if(!O&&M.currentStyle){O=M.currentStyle[N]}return O}function y(O,N){var Q=O.offsetWidth;var S=B(O,\"borderLeftWidth\",N)||0;var M=B(O,\"borderRightWidth\",N)||0;var P=B(O,\"paddingLeft\",N)||0;var R=B(O,\"paddingRight\",N)||0;return Q-S-M-P-R}if(!Object.isUndefined(document.documentElement.currentStyle)&&!Prototype.Browser.Opera){F=I}function B(W,X,N){var Q=null;if(Object.isElement(W)){Q=W;W=F(Q,X)}if(W===null||Object.isUndefined(W)){return null}if((/^(?:-)?\\d+(\\.\\d+)?(px)?$/i).test(W)){return window.parseFloat(W)}var R=W.include(\"%\"),O=(N===document.viewport);if(/\\d/.test(W)&&Q&&Q.runtimeStyle&&!(R&&O)){var M=Q.style.left,V=Q.runtimeStyle.left;Q.runtimeStyle.left=Q.currentStyle.left;Q.style.left=W||0;W=Q.style.pixelLeft;Q.style.left=M;Q.runtimeStyle.left=V;return W}if(Q&&R){N=N||Q.parentNode;var P=q(W),S=null;var U=X.include(\"left\")||X.include(\"right\")||X.include(\"width\");var T=X.include(\"top\")||X.include(\"bottom\")||X.include(\"height\");if(N===document.viewport){if(U){S=document.viewport.getWidth()}else{if(T){S=document.viewport.getHeight()}}}else{if(U){S=$(N).measure(\"width\")}else{if(T){S=$(N).measure(\"height\")}}}return(S===null)?0:S*P}return 0}function p(M){if(Object.isString(M)&&M.endsWith(\"px\")){return M}return M+\"px\"}function s(M){while(M&&M.parentNode){var N=M.getStyle(\"display\");if(N===\"none\"){return false}M=$(M.parentNode)}return true}var l=Prototype.K;if(\"currentStyle\" in document.documentElement){l=function(M){if(!M.currentStyle.hasLayout){M.style.zoom=1}return M}}function o(M){if(M.include(\"border\")){M=M+\"-width\"}return M.camelize()}Element.Layout=Class.create(Hash,{initialize:function($super,N,M){$super();this.element=$(N);Element.Layout.PROPERTIES.each(function(O){this._set(O,null)},this);if(M){this._preComputing=true;this._begin();Element.Layout.PROPERTIES.each(this._compute,this);this._end();this._preComputing=false}},_set:function(N,M){return Hash.prototype.set.call(this,N,M)},set:function(N,M){throw\"Properties of Element.Layout are read-only.\"},get:function($super,N){var M=$super(N);return M===null?this._compute(N):M},_begin:function(){if(this._isPrepared()){return}var Q=this.element;if(s(Q)){this._setPrepared(true);return}var S={position:Q.style.position||\"\",width:Q.style.width||\"\",visibility:Q.style.visibility||\"\",display:Q.style.display||\"\"};Q.store(\"prototype_original_styles\",S);var T=F(Q,\"position\"),M=Q.offsetWidth;if(M===0||M===null){Q.style.display=\"block\";M=Q.offsetWidth}var N=(T===\"fixed\")?document.viewport:Q.parentNode;var U={visibility:\"hidden\",display:\"block\"};if(T!==\"fixed\"){U.position=\"absolute\"}Q.setStyle(U);var O=Q.offsetWidth,P;if(M&&(O===M)){P=y(Q,N)}else{if(T===\"absolute\"||T===\"fixed\"){P=y(Q,N)}else{var V=Q.parentNode,R=$(V).getLayout();P=R.get(\"width\")-this.get(\"margin-left\")-this.get(\"border-left\")-this.get(\"padding-left\")-this.get(\"padding-right\")-this.get(\"border-right\")-this.get(\"margin-right\")}}Q.setStyle({width:P+\"px\"});this._setPrepared(true)},_end:function(){var N=this.element;var M=N.retrieve(\"prototype_original_styles\");N.store(\"prototype_original_styles\",null);N.setStyle(M);this._setPrepared(false)},_compute:function(N){var M=Element.Layout.COMPUTATIONS;if(!(N in M)){throw\"Property not found.\"}return this._set(N,M[N].call(this,this.element))},_isPrepared:function(){return this.element.retrieve(\"prototype_element_layout_prepared\",false)},_setPrepared:function(M){return this.element.store(\"prototype_element_layout_prepared\",M)},toObject:function(){var M=$A(arguments);var N=(M.length===0)?Element.Layout.PROPERTIES:M.join(\" \").split(\" \");var O={};N.each(function(P){if(!Element.Layout.PROPERTIES.include(P)){return}var Q=this.get(P);if(Q!=null){O[P]=Q}},this);return O},toHash:function(){var M=this.toObject.apply(this,arguments);return new Hash(M)},toCSS:function(){var M=$A(arguments);var O=(M.length===0)?Element.Layout.PROPERTIES:M.join(\" \").split(\" \");var N={};O.each(function(P){if(!Element.Layout.PROPERTIES.include(P)){return}if(Element.Layout.COMPOSITE_PROPERTIES.include(P)){return}var Q=this.get(P);if(Q!=null){N[o(P)]=Q+\"px\"}},this);return N},inspect:function(){return\"#<Element.Layout>\"}});Object.extend(Element.Layout,{PROPERTIES:$w(\"height width top left right bottom border-left border-right border-top border-bottom padding-left padding-right padding-top padding-bottom margin-top margin-bottom margin-left margin-right padding-box-width padding-box-height border-box-width border-box-height margin-box-width margin-box-height\"),COMPOSITE_PROPERTIES:$w(\"padding-box-width padding-box-height margin-box-width margin-box-height border-box-width border-box-height\"),COMPUTATIONS:{height:function(O){if(!this._preComputing){this._begin()}var M=this.get(\"border-box-height\");if(M<=0){if(!this._preComputing){this._end()}return 0}var P=this.get(\"border-top\"),N=this.get(\"border-bottom\");var R=this.get(\"padding-top\"),Q=this.get(\"padding-bottom\");if(!this._preComputing){this._end()}return M-P-N-R-Q},width:function(O){if(!this._preComputing){this._begin()}var N=this.get(\"border-box-width\");if(N<=0){if(!this._preComputing){this._end()}return 0}var R=this.get(\"border-left\"),M=this.get(\"border-right\");var P=this.get(\"padding-left\"),Q=this.get(\"padding-right\");if(!this._preComputing){this._end()}return N-R-M-P-Q},\"padding-box-height\":function(N){var M=this.get(\"height\"),P=this.get(\"padding-top\"),O=this.get(\"padding-bottom\");return M+P+O},\"padding-box-width\":function(M){var N=this.get(\"width\"),O=this.get(\"padding-left\"),P=this.get(\"padding-right\");return N+O+P},\"border-box-height\":function(N){if(!this._preComputing){this._begin()}var M=N.offsetHeight;if(!this._preComputing){this._end()}return M},\"border-box-width\":function(M){if(!this._preComputing){this._begin()}var N=M.offsetWidth;if(!this._preComputing){this._end()}return N},\"margin-box-height\":function(N){var M=this.get(\"border-box-height\"),O=this.get(\"margin-top\"),P=this.get(\"margin-bottom\");if(M<=0){return 0}return M+O+P},\"margin-box-width\":function(O){var N=this.get(\"border-box-width\"),P=this.get(\"margin-left\"),M=this.get(\"margin-right\");if(N<=0){return 0}return N+P+M},top:function(M){var N=M.positionedOffset();return N.top},bottom:function(M){var P=M.positionedOffset(),N=M.getOffsetParent(),O=N.measure(\"height\");var Q=this.get(\"border-box-height\");return O-Q-P.top},left:function(M){var N=M.positionedOffset();return N.left},right:function(O){var Q=O.positionedOffset(),P=O.getOffsetParent(),M=P.measure(\"width\");var N=this.get(\"border-box-width\");return M-N-Q.left},\"padding-top\":function(M){return B(M,\"paddingTop\")},\"padding-bottom\":function(M){return B(M,\"paddingBottom\")},\"padding-left\":function(M){return B(M,\"paddingLeft\")},\"padding-right\":function(M){return B(M,\"paddingRight\")},\"border-top\":function(M){return B(M,\"borderTopWidth\")},\"border-bottom\":function(M){return B(M,\"borderBottomWidth\")},\"border-left\":function(M){return B(M,\"borderLeftWidth\")},\"border-right\":function(M){return B(M,\"borderRightWidth\")},\"margin-top\":function(M){return B(M,\"marginTop\")},\"margin-bottom\":function(M){return B(M,\"marginBottom\")},\"margin-left\":function(M){return B(M,\"marginLeft\")},\"margin-right\":function(M){return B(M,\"marginRight\")}}});if(\"getBoundingClientRect\" in document.documentElement){Object.extend(Element.Layout.COMPUTATIONS,{right:function(N){var O=l(N.getOffsetParent());var P=N.getBoundingClientRect(),M=O.getBoundingClientRect();return(M.right-P.right).round()},bottom:function(N){var O=l(N.getOffsetParent());var P=N.getBoundingClientRect(),M=O.getBoundingClientRect();return(M.bottom-P.bottom).round()}})}Element.Offset=Class.create({initialize:function(N,M){this.left=N.round();this.top=M.round();this[0]=this.left;this[1]=this.top},relativeTo:function(M){return new Element.Offset(this.left-M.left,this.top-M.top)},inspect:function(){return\"#<Element.Offset left: #{left} top: #{top}>\".interpolate(this)},toString:function(){return\"[#{left}, #{top}]\".interpolate(this)},toArray:function(){return[this.left,this.top]}});function G(N,M){return new Element.Layout(N,M)}function f(M,N){return $(M).getLayout().get(N)}function w(M){return Element.getDimensions(M).height}function e(M){return Element.getDimensions(M).width}function z(N){N=$(N);var R=Element.getStyle(N,\"display\");if(R&&R!==\"none\"){return{width:N.offsetWidth,height:N.offsetHeight}}var O=N.style;var M={visibility:O.visibility,position:O.position,display:O.display};var Q={visibility:\"hidden\",display:\"block\"};if(M.position!==\"fixed\"){Q.position=\"absolute\"}Element.setStyle(N,Q);var P={width:N.offsetWidth,height:N.offsetHeight};Element.setStyle(N,M);return P}function v(M){M=$(M);function O(P){return t(P)?$(document.body):$(P)}if(n(M)||h(M)||u(M)||t(M)){return $(document.body)}var N=(Element.getStyle(M,\"display\")===\"inline\");if(!N&&M.offsetParent){return O(M.offsetParent)}while((M=M.parentNode)&&M!==document.body){if(Element.getStyle(M,\"position\")!==\"static\"){return O(M)}}return $(document.body)}function J(N){N=$(N);var M=0,O=0;if(N.parentNode){do{M+=N.offsetTop||0;O+=N.offsetLeft||0;N=N.offsetParent}while(N)}return new Element.Offset(O,M)}function D(N){N=$(N);var O=N.getLayout();var M=0,Q=0;do{M+=N.offsetTop||0;Q+=N.offsetLeft||0;N=N.offsetParent;if(N){if(u(N)){break}var P=Element.getStyle(N,\"position\");if(P!==\"static\"){break}}}while(N);Q-=O.get(\"margin-left\");M-=O.get(\"margin-top\");return new Element.Offset(Q,M)}function d(N){var M=0,O=0;do{if(N===document.body){var P=document.documentElement||document.body.parentNode||document.body;M+=!Object.isUndefined(window.pageYOffset)?window.pageYOffset:P.scrollTop||0;O+=!Object.isUndefined(window.pageXOffset)?window.pageXOffset:P.scrollLeft||0;break}else{M+=N.scrollTop||0;O+=N.scrollLeft||0;N=N.parentNode}}while(N);return new Element.Offset(O,M)}function H(Q){var M=0,P=0,O=document.body;Q=$(Q);var N=Q;do{M+=N.offsetTop||0;P+=N.offsetLeft||0;if(N.offsetParent==O&&Element.getStyle(N,\"position\")==\"absolute\"){break}}while(N=N.offsetParent);N=Q;do{if(N!=O){M-=N.scrollTop||0;P-=N.scrollLeft||0}}while(N=N.parentNode);return new Element.Offset(P,M)}function E(M){M=$(M);if(Element.getStyle(M,\"position\")===\"absolute\"){return M}var Q=v(M);var P=M.viewportOffset(),N=Q.viewportOffset();var R=P.relativeTo(N);var O=M.getLayout();M.store(\"prototype_absolutize_original_styles\",{position:M.getStyle(\"position\"),left:M.getStyle(\"left\"),top:M.getStyle(\"top\"),width:M.getStyle(\"width\"),height:M.getStyle(\"height\")});M.setStyle({position:\"absolute\",top:R.top+\"px\",left:R.left+\"px\",width:O.get(\"width\")+\"px\",height:O.get(\"height\")+\"px\"});return M}function r(N){N=$(N);if(Element.getStyle(N,\"position\")===\"relative\"){return N}var M=N.retrieve(\"prototype_absolutize_original_styles\");if(M){N.setStyle(M)}return N}function b(M){M=$(M);var N=Element.cumulativeOffset(M);window.scrollTo(N.left,N.top);return M}function C(N){N=$(N);var M=Element.getStyle(N,\"position\"),O={};if(M===\"static\"||!M){O.position=\"relative\";if(Prototype.Browser.Opera){O.top=0;O.left=0}Element.setStyle(N,O);Element.store(N,\"prototype_made_positioned\",true)}return N}function A(M){M=$(M);var O=Element.getStorage(M),N=O.get(\"prototype_made_positioned\");if(N){O.unset(\"prototype_made_positioned\");Element.setStyle(M,{position:\"\",top:\"\",bottom:\"\",left:\"\",right:\"\"})}return M}function g(N){N=$(N);var P=Element.getStorage(N),M=P.get(\"prototype_made_clipping\");if(Object.isUndefined(M)){var O=Element.getStyle(N,\"overflow\");P.set(\"prototype_made_clipping\",O);if(O!==\"hidden\"){N.style.overflow=\"hidden\"}}return N}function K(M){M=$(M);var O=Element.getStorage(M),N=O.get(\"prototype_made_clipping\");if(!Object.isUndefined(N)){O.unset(\"prototype_made_clipping\");M.style.overflow=N||\"\"}return M}function L(P,M,X){X=Object.extend({setLeft:true,setTop:true,setWidth:true,setHeight:true,offsetTop:0,offsetLeft:0},X||{});var O=document.documentElement;M=$(M);P=$(P);var N,V,R,W={};if(X.setLeft||X.setTop){N=Element.viewportOffset(M);V=[0,0];if(Element.getStyle(P,\"position\")===\"absolute\"){var U=Element.getOffsetParent(P);if(U!==document.body){V=Element.viewportOffset(U)}}}function S(){var Y=0,Z=0;if(Object.isNumber(window.pageXOffset)){Y=window.pageXOffset;Z=window.pageYOffset}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){Y=document.body.scrollLeft;Z=document.body.scrollTop}else{if(O&&(O.scrollLeft||O.scrollTop)){Y=O.scrollLeft;Z=O.scrollTop}}}return{x:Y,y:Z}}var Q=S();if(X.setWidth||X.setHeight){R=Element.getLayout(M)}if(X.setLeft){W.left=(N[0]+Q.x-V[0]+X.offsetLeft)+\"px\"}if(X.setTop){W.top=(N[1]+Q.y-V[1]+X.offsetTop)+\"px\"}var T=P.getLayout();if(X.setWidth){W.width=R.get(\"width\")+\"px\"}if(X.setHeight){W.height=R.get(\"height\")+\"px\"}return Element.setStyle(P,W)}if(Prototype.Browser.IE){v=v.wrap(function(O,N){N=$(N);if(n(N)||h(N)||u(N)||t(N)){return $(document.body)}var M=N.getStyle(\"position\");if(M!==\"static\"){return O(N)}N.setStyle({position:\"relative\"});var P=O(N);N.setStyle({position:M});return P});D=D.wrap(function(P,N){N=$(N);if(!N.parentNode){return new Element.Offset(0,0)}var M=N.getStyle(\"position\");if(M!==\"static\"){return P(N)}var O=N.getOffsetParent();if(O&&O.getStyle(\"position\")===\"fixed\"){l(O)}N.setStyle({position:\"relative\"});var Q=P(N);N.setStyle({position:M});return Q})}else{if(Prototype.Browser.Webkit){J=function(N){N=$(N);var M=0,O=0;do{M+=N.offsetTop||0;O+=N.offsetLeft||0;if(N.offsetParent==document.body){if(Element.getStyle(N,\"position\")==\"absolute\"){break}}N=N.offsetParent}while(N);return new Element.Offset(O,M)}}}Element.addMethods({getLayout:G,measure:f,getWidth:e,getHeight:w,getDimensions:z,getOffsetParent:v,cumulativeOffset:J,positionedOffset:D,cumulativeScrollOffset:d,viewportOffset:H,absolutize:E,relativize:r,scrollTo:b,makePositioned:C,undoPositioned:A,makeClipping:g,undoClipping:K,clonePosition:L});function u(M){return M.nodeName.toUpperCase()===\"BODY\"}function t(M){return M.nodeName.toUpperCase()===\"HTML\"}function n(M){return M.nodeType===Node.DOCUMENT_NODE}function h(M){return M!==document.body&&!Element.descendantOf(M,document.body)}if(\"getBoundingClientRect\" in document.documentElement){Element.addMethods({viewportOffset:function(M){M=$(M);if(h(M)){return new Element.Offset(0,0)}var N=M.getBoundingClientRect(),O=document.documentElement;return new Element.Offset(N.left-O.clientLeft,N.top-O.clientTop)}})}})();(function(){var e=Prototype.Browser.Opera&&(window.parseFloat(window.opera.version())<9.5);var h=null;function d(){if(h){return h}h=e?document.body:document.documentElement;return h}function f(){return{width:this.getWidth(),height:this.getHeight()}}function b(){return d().clientWidth}function l(){return d().clientHeight}function g(){var n=window.pageXOffset||document.documentElement.scrollLeft||document.body.scrollLeft;var o=window.pageYOffset||document.documentElement.scrollTop||document.body.scrollTop;return new Element.Offset(n,o)}document.viewport={getDimensions:f,getWidth:b,getHeight:l,getScrollOffsets:g}})();window.$$=function(){var b=$A(arguments).join(\", \");return Prototype.Selector.select(b,document)};Prototype.Selector=(function(){function b(){throw new Error('Method \"Prototype.Selector.select\" must be defined.')}function e(){throw new Error('Method \"Prototype.Selector.match\" must be defined.')}function f(q,r,n){n=n||0;var l=Prototype.Selector.match,p=q.length,h=0,o;for(o=0;o<p;o++){if(l(q[o],r)&&n==h++){return Element.extend(q[o])}}}function g(n){for(var h=0,l=n.length;h<l;h++){Element.extend(n[h])}return n}var d=Prototype.K;return{select:b,match:e,find:f,extendElements:(Element.extend===d)?d:g,extendElement:Element.extend}})();Prototype._original_property=window.Sizzle;(function(){function b(d){Prototype._actual_sizzle=d()}b.amd=true;if(typeof define!==\"undefined\"&&define.amd){Prototype._original_define=define;Prototype._actual_sizzle=null;window.define=b}})();\n/*!\n * Sizzle CSS Selector Engine v1.10.18\n * http://sizzlejs.com/\n *\n * Copyright 2013 jQuery Foundation, Inc. and other contributors\n * Released under the MIT license\n * http://jquery.org/license\n *\n * Date: 2014-02-05\n */\n(function(aB){var J,aE,z,S,V,ah,aD,aI,T,ai,ak,N,A,au,ao,aC,p,Q,aw=\"sizzle\"+-(new Date()),U=aB.document,aF=0,ap=0,g=L(),av=L(),R=L(),P=function(aJ,e){if(aJ===e){ai=true}return 0},aA=typeof undefined,ab=1<<31,Z=({}).hasOwnProperty,ay=[],az=ay.pop,X=ay.push,d=ay.push,y=ay.slice,o=ay.indexOf||function(aK){var aJ=0,e=this.length;for(;aJ<e;aJ++){if(this[aJ]===aK){return aJ}}return -1},f=\"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped\",B=\"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",b=\"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",W=b.replace(\"w\",\"w#\"),ar=\"\\\\[\"+B+\"*(\"+b+\")\"+B+\"*(?:([*^$|!~]?=)\"+B+\"*(?:(['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|(\"+W+\")|)|)\"+B+\"*\\\\]\",v=\":(\"+b+\")(?:\\\\(((['\\\"])((?:\\\\\\\\.|[^\\\\\\\\])*?)\\\\3|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\"+ar.replace(3,8)+\")*)|.*)\\\\)|)\",D=new RegExp(\"^\"+B+\"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\"+B+\"+$\",\"g\"),G=new RegExp(\"^\"+B+\"*,\"+B+\"*\"),M=new RegExp(\"^\"+B+\"*([>+~]|\"+B+\")\"+B+\"*\"),F=new RegExp(\"=\"+B+\"*([^\\\\]'\\\"]*?)\"+B+\"*\\\\]\",\"g\"),ad=new RegExp(v),af=new RegExp(\"^\"+W+\"$\"),an={ID:new RegExp(\"^#(\"+b+\")\"),CLASS:new RegExp(\"^\\\\.(\"+b+\")\"),TAG:new RegExp(\"^(\"+b.replace(\"w\",\"w*\")+\")\"),ATTR:new RegExp(\"^\"+ar),PSEUDO:new RegExp(\"^\"+v),CHILD:new RegExp(\"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\"+B+\"*(even|odd|(([+-]|)(\\\\d*)n|)\"+B+\"*(?:([+-]|)\"+B+\"*(\\\\d+)|))\"+B+\"*\\\\)|)\",\"i\"),bool:new RegExp(\"^(?:\"+f+\")$\",\"i\"),needsContext:new RegExp(\"^\"+B+\"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\"+B+\"*((?:-\\\\d)?\\\\d*)\"+B+\"*\\\\)|)(?=[^-]|$)\",\"i\")},n=/^(?:input|select|textarea|button)$/i,w=/^h\\d$/i,aa=/^[^{]+\\{\\s*\\[native \\w/,ac=/^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,am=/[+~]/,Y=/'|\\\\/g,E=new RegExp(\"\\\\\\\\([\\\\da-f]{1,6}\"+B+\"?|(\"+B+\")|.)\",\"ig\"),aq=function(e,aL,aJ){var aK=\"0x\"+aL-65536;return aK!==aK||aJ?aL:aK<0?String.fromCharCode(aK+65536):String.fromCharCode(aK>>10|55296,aK&1023|56320)};try{d.apply((ay=y.call(U.childNodes)),U.childNodes);ay[U.childNodes.length].nodeType}catch(O){d={apply:ay.length?function(aJ,e){X.apply(aJ,y.call(e))}:function(aL,aK){var e=aL.length,aJ=0;while((aL[e++]=aK[aJ++])){}aL.length=e-1}}}function H(aQ,aJ,aU,aW){var aV,aN,aO,aS,aT,aM,aL,e,aK,aR;if((aJ?aJ.ownerDocument||aJ:U)!==N){ak(aJ)}aJ=aJ||N;aU=aU||[];if(!aQ||typeof aQ!==\"string\"){return aU}if((aS=aJ.nodeType)!==1&&aS!==9){return[]}if(au&&!aW){if((aV=ac.exec(aQ))){if((aO=aV[1])){if(aS===9){aN=aJ.getElementById(aO);if(aN&&aN.parentNode){if(aN.id===aO){aU.push(aN);return aU}}else{return aU}}else{if(aJ.ownerDocument&&(aN=aJ.ownerDocument.getElementById(aO))&&Q(aJ,aN)&&aN.id===aO){aU.push(aN);return aU}}}else{if(aV[2]){d.apply(aU,aJ.getElementsByTagName(aQ));return aU}else{if((aO=aV[3])&&aE.getElementsByClassName&&aJ.getElementsByClassName){d.apply(aU,aJ.getElementsByClassName(aO));return aU}}}}if(aE.qsa&&(!ao||!ao.test(aQ))){e=aL=aw;aK=aJ;aR=aS===9&&aQ;if(aS===1&&aJ.nodeName.toLowerCase()!==\"object\"){aM=s(aQ);if((aL=aJ.getAttribute(\"id\"))){e=aL.replace(Y,\"\\\\$&\")}else{aJ.setAttribute(\"id\",e)}e=\"[id='\"+e+\"'] \";aT=aM.length;while(aT--){aM[aT]=e+t(aM[aT])}aK=am.test(aQ)&&ae(aJ.parentNode)||aJ;aR=aM.join(\",\")}if(aR){try{d.apply(aU,aK.querySelectorAll(aR));return aU}catch(aP){}finally{if(!aL){aJ.removeAttribute(\"id\")}}}}}return aD(aQ.replace(D,\"$1\"),aJ,aU,aW)}function L(){var aJ=[];function e(aK,aL){if(aJ.push(aK+\" \")>z.cacheLength){delete e[aJ.shift()]}return(e[aK+\" \"]=aL)}return e}function u(e){e[aw]=true;return e}function q(aJ){var aL=N.createElement(\"div\");try{return !!aJ(aL)}catch(aK){return false}finally{if(aL.parentNode){aL.parentNode.removeChild(aL)}aL=null}}function aG(aJ,aL){var e=aJ.split(\"|\"),aK=aJ.length;while(aK--){z.attrHandle[e[aK]]=aL}}function h(aJ,e){var aL=e&&aJ,aK=aL&&aJ.nodeType===1&&e.nodeType===1&&(~e.sourceIndex||ab)-(~aJ.sourceIndex||ab);if(aK){return aK}if(aL){while((aL=aL.nextSibling)){if(aL===e){return -1}}}return aJ?1:-1}function I(e){return function(aK){var aJ=aK.nodeName.toLowerCase();return aJ===\"input\"&&aK.type===e}}function l(e){return function(aK){var aJ=aK.nodeName.toLowerCase();return(aJ===\"input\"||aJ===\"button\")&&aK.type===e}}function at(e){return u(function(aJ){aJ=+aJ;return u(function(aK,aO){var aM,aL=e([],aK.length,aJ),aN=aL.length;while(aN--){if(aK[(aM=aL[aN])]){aK[aM]=!(aO[aM]=aK[aM])}}})})}function ae(e){return e&&typeof e.getElementsByTagName!==aA&&e}aE=H.support={};V=H.isXML=function(e){var aJ=e&&(e.ownerDocument||e).documentElement;return aJ?aJ.nodeName!==\"HTML\":false};ak=H.setDocument=function(aK){var e,aL=aK?aK.ownerDocument||aK:U,aJ=aL.defaultView;if(aL===N||aL.nodeType!==9||!aL.documentElement){return N}N=aL;A=aL.documentElement;au=!V(aL);if(aJ&&aJ!==aJ.top){if(aJ.addEventListener){aJ.addEventListener(\"unload\",function(){ak()},false)}else{if(aJ.attachEvent){aJ.attachEvent(\"onunload\",function(){ak()})}}}aE.attributes=q(function(aM){aM.className=\"i\";return !aM.getAttribute(\"className\")});aE.getElementsByTagName=q(function(aM){aM.appendChild(aL.createComment(\"\"));return !aM.getElementsByTagName(\"*\").length});aE.getElementsByClassName=aa.test(aL.getElementsByClassName)&&q(function(aM){aM.innerHTML=\"<div class='a'></div><div class='a i'></div>\";aM.firstChild.className=\"i\";return aM.getElementsByClassName(\"i\").length===2});aE.getById=q(function(aM){A.appendChild(aM).id=aw;return !aL.getElementsByName||!aL.getElementsByName(aw).length});if(aE.getById){z.find.ID=function(aO,aN){if(typeof aN.getElementById!==aA&&au){var aM=aN.getElementById(aO);return aM&&aM.parentNode?[aM]:[]}};z.filter.ID=function(aN){var aM=aN.replace(E,aq);return function(aO){return aO.getAttribute(\"id\")===aM}}}else{delete z.find.ID;z.filter.ID=function(aN){var aM=aN.replace(E,aq);return function(aP){var aO=typeof aP.getAttributeNode!==aA&&aP.getAttributeNode(\"id\");return aO&&aO.value===aM}}}z.find.TAG=aE.getElementsByTagName?function(aM,aN){if(typeof aN.getElementsByTagName!==aA){return aN.getElementsByTagName(aM)}}:function(aM,aQ){var aR,aP=[],aO=0,aN=aQ.getElementsByTagName(aM);if(aM===\"*\"){while((aR=aN[aO++])){if(aR.nodeType===1){aP.push(aR)}}return aP}return aN};z.find.CLASS=aE.getElementsByClassName&&function(aN,aM){if(typeof aM.getElementsByClassName!==aA&&au){return aM.getElementsByClassName(aN)}};aC=[];ao=[];if((aE.qsa=aa.test(aL.querySelectorAll))){q(function(aM){aM.innerHTML=\"<select t=''><option selected=''></option></select>\";if(aM.querySelectorAll(\"[t^='']\").length){ao.push(\"[*^$]=\"+B+\"*(?:''|\\\"\\\")\")}if(!aM.querySelectorAll(\"[selected]\").length){ao.push(\"\\\\[\"+B+\"*(?:value|\"+f+\")\")}if(!aM.querySelectorAll(\":checked\").length){ao.push(\":checked\")}});q(function(aN){var aM=aL.createElement(\"input\");aM.setAttribute(\"type\",\"hidden\");aN.appendChild(aM).setAttribute(\"name\",\"D\");if(aN.querySelectorAll(\"[name=d]\").length){ao.push(\"name\"+B+\"*[*^$|!~]?=\")}if(!aN.querySelectorAll(\":enabled\").length){ao.push(\":enabled\",\":disabled\")}aN.querySelectorAll(\"*,:x\");ao.push(\",.*:\")})}if((aE.matchesSelector=aa.test((p=A.webkitMatchesSelector||A.mozMatchesSelector||A.oMatchesSelector||A.msMatchesSelector)))){q(function(aM){aE.disconnectedMatch=p.call(aM,\"div\");p.call(aM,\"[s!='']:x\");aC.push(\"!=\",v)})}ao=ao.length&&new RegExp(ao.join(\"|\"));aC=aC.length&&new RegExp(aC.join(\"|\"));e=aa.test(A.compareDocumentPosition);Q=e||aa.test(A.contains)?function(aN,aM){var aP=aN.nodeType===9?aN.documentElement:aN,aO=aM&&aM.parentNode;return aN===aO||!!(aO&&aO.nodeType===1&&(aP.contains?aP.contains(aO):aN.compareDocumentPosition&&aN.compareDocumentPosition(aO)&16))}:function(aN,aM){if(aM){while((aM=aM.parentNode)){if(aM===aN){return true}}}return false};P=e?function(aN,aM){if(aN===aM){ai=true;return 0}var aO=!aN.compareDocumentPosition-!aM.compareDocumentPosition;if(aO){return aO}aO=(aN.ownerDocument||aN)===(aM.ownerDocument||aM)?aN.compareDocumentPosition(aM):1;if(aO&1||(!aE.sortDetached&&aM.compareDocumentPosition(aN)===aO)){if(aN===aL||aN.ownerDocument===U&&Q(U,aN)){return -1}if(aM===aL||aM.ownerDocument===U&&Q(U,aM)){return 1}return T?(o.call(T,aN)-o.call(T,aM)):0}return aO&4?-1:1}:function(aN,aM){if(aN===aM){ai=true;return 0}var aT,aQ=0,aS=aN.parentNode,aP=aM.parentNode,aO=[aN],aR=[aM];if(!aS||!aP){return aN===aL?-1:aM===aL?1:aS?-1:aP?1:T?(o.call(T,aN)-o.call(T,aM)):0}else{if(aS===aP){return h(aN,aM)}}aT=aN;while((aT=aT.parentNode)){aO.unshift(aT)}aT=aM;while((aT=aT.parentNode)){aR.unshift(aT)}while(aO[aQ]===aR[aQ]){aQ++}return aQ?h(aO[aQ],aR[aQ]):aO[aQ]===U?-1:aR[aQ]===U?1:0};return aL};H.matches=function(aJ,e){return H(aJ,null,null,e)};H.matchesSelector=function(aK,aM){if((aK.ownerDocument||aK)!==N){ak(aK)}aM=aM.replace(F,\"='$1']\");if(aE.matchesSelector&&au&&(!aC||!aC.test(aM))&&(!ao||!ao.test(aM))){try{var aJ=p.call(aK,aM);if(aJ||aE.disconnectedMatch||aK.document&&aK.document.nodeType!==11){return aJ}}catch(aL){}}return H(aM,N,null,[aK]).length>0};H.contains=function(e,aJ){if((e.ownerDocument||e)!==N){ak(e)}return Q(e,aJ)};H.attr=function(aK,e){if((aK.ownerDocument||aK)!==N){ak(aK)}var aJ=z.attrHandle[e.toLowerCase()],aL=aJ&&Z.call(z.attrHandle,e.toLowerCase())?aJ(aK,e,!au):undefined;return aL!==undefined?aL:aE.attributes||!au?aK.getAttribute(e):(aL=aK.getAttributeNode(e))&&aL.specified?aL.value:null};H.error=function(e){throw new Error(\"Syntax error, unrecognized expression: \"+e)};H.uniqueSort=function(aK){var aL,aM=[],e=0,aJ=0;ai=!aE.detectDuplicates;T=!aE.sortStable&&aK.slice(0);aK.sort(P);if(ai){while((aL=aK[aJ++])){if(aL===aK[aJ]){e=aM.push(aJ)}}while(e--){aK.splice(aM[e],1)}}T=null;return aK};S=H.getText=function(aM){var aL,aJ=\"\",aK=0,e=aM.nodeType;if(!e){while((aL=aM[aK++])){aJ+=S(aL)}}else{if(e===1||e===9||e===11){if(typeof aM.textContent===\"string\"){return aM.textContent}else{for(aM=aM.firstChild;aM;aM=aM.nextSibling){aJ+=S(aM)}}}else{if(e===3||e===4){return aM.nodeValue}}}return aJ};z=H.selectors={cacheLength:50,createPseudo:u,match:an,attrHandle:{},find:{},relative:{\">\":{dir:\"parentNode\",first:true},\" \":{dir:\"parentNode\"},\"+\":{dir:\"previousSibling\",first:true},\"~\":{dir:\"previousSibling\"}},preFilter:{ATTR:function(e){e[1]=e[1].replace(E,aq);e[3]=(e[4]||e[5]||\"\").replace(E,aq);if(e[2]===\"~=\"){e[3]=\" \"+e[3]+\" \"}return e.slice(0,4)},CHILD:function(e){e[1]=e[1].toLowerCase();if(e[1].slice(0,3)===\"nth\"){if(!e[3]){H.error(e[0])}e[4]=+(e[4]?e[5]+(e[6]||1):2*(e[3]===\"even\"||e[3]===\"odd\"));e[5]=+((e[7]+e[8])||e[3]===\"odd\")}else{if(e[3]){H.error(e[0])}}return e},PSEUDO:function(aJ){var e,aK=!aJ[5]&&aJ[2];if(an.CHILD.test(aJ[0])){return null}if(aJ[3]&&aJ[4]!==undefined){aJ[2]=aJ[4]}else{if(aK&&ad.test(aK)&&(e=s(aK,true))&&(e=aK.indexOf(\")\",aK.length-e)-aK.length)){aJ[0]=aJ[0].slice(0,e);aJ[2]=aK.slice(0,e)}}return aJ.slice(0,3)}},filter:{TAG:function(aJ){var e=aJ.replace(E,aq).toLowerCase();return aJ===\"*\"?function(){return true}:function(aK){return aK.nodeName&&aK.nodeName.toLowerCase()===e}},CLASS:function(e){var aJ=g[e+\" \"];return aJ||(aJ=new RegExp(\"(^|\"+B+\")\"+e+\"(\"+B+\"|$)\"))&&g(e,function(aK){return aJ.test(typeof aK.className===\"string\"&&aK.className||typeof aK.getAttribute!==aA&&aK.getAttribute(\"class\")||\"\")})},ATTR:function(aK,aJ,e){return function(aM){var aL=H.attr(aM,aK);if(aL==null){return aJ===\"!=\"}if(!aJ){return true}aL+=\"\";return aJ===\"=\"?aL===e:aJ===\"!=\"?aL!==e:aJ===\"^=\"?e&&aL.indexOf(e)===0:aJ===\"*=\"?e&&aL.indexOf(e)>-1:aJ===\"$=\"?e&&aL.slice(-e.length)===e:aJ===\"~=\"?(\" \"+aL+\" \").indexOf(e)>-1:aJ===\"|=\"?aL===e||aL.slice(0,e.length+1)===e+\"-\":false}},CHILD:function(aJ,aM,aL,aN,aK){var aP=aJ.slice(0,3)!==\"nth\",e=aJ.slice(-4)!==\"last\",aO=aM===\"of-type\";return aN===1&&aK===0?function(aQ){return !!aQ.parentNode}:function(aW,aU,aZ){var aQ,a2,aX,a1,aY,aT,aV=aP!==e?\"nextSibling\":\"previousSibling\",a0=aW.parentNode,aS=aO&&aW.nodeName.toLowerCase(),aR=!aZ&&!aO;if(a0){if(aP){while(aV){aX=aW;while((aX=aX[aV])){if(aO?aX.nodeName.toLowerCase()===aS:aX.nodeType===1){return false}}aT=aV=aJ===\"only\"&&!aT&&\"nextSibling\"}return true}aT=[e?a0.firstChild:a0.lastChild];if(e&&aR){a2=a0[aw]||(a0[aw]={});aQ=a2[aJ]||[];aY=aQ[0]===aF&&aQ[1];a1=aQ[0]===aF&&aQ[2];aX=aY&&a0.childNodes[aY];while((aX=++aY&&aX&&aX[aV]||(a1=aY=0)||aT.pop())){if(aX.nodeType===1&&++a1&&aX===aW){a2[aJ]=[aF,aY,a1];break}}}else{if(aR&&(aQ=(aW[aw]||(aW[aw]={}))[aJ])&&aQ[0]===aF){a1=aQ[1]}else{while((aX=++aY&&aX&&aX[aV]||(a1=aY=0)||aT.pop())){if((aO?aX.nodeName.toLowerCase()===aS:aX.nodeType===1)&&++a1){if(aR){(aX[aw]||(aX[aw]={}))[aJ]=[aF,a1]}if(aX===aW){break}}}}}a1-=aK;return a1===aN||(a1%aN===0&&a1/aN>=0)}}},PSEUDO:function(aL,aK){var e,aJ=z.pseudos[aL]||z.setFilters[aL.toLowerCase()]||H.error(\"unsupported pseudo: \"+aL);if(aJ[aw]){return aJ(aK)}if(aJ.length>1){e=[aL,aL,\"\",aK];return z.setFilters.hasOwnProperty(aL.toLowerCase())?u(function(aO,aQ){var aN,aM=aJ(aO,aK),aP=aM.length;while(aP--){aN=o.call(aO,aM[aP]);aO[aN]=!(aQ[aN]=aM[aP])}}):function(aM){return aJ(aM,0,e)}}return aJ}},pseudos:{not:u(function(e){var aJ=[],aK=[],aL=ah(e.replace(D,\"$1\"));return aL[aw]?u(function(aN,aS,aQ,aO){var aR,aM=aL(aN,null,aO,[]),aP=aN.length;while(aP--){if((aR=aM[aP])){aN[aP]=!(aS[aP]=aR)}}}):function(aO,aN,aM){aJ[0]=aO;aL(aJ,null,aM,aK);return !aK.pop()}}),has:u(function(e){return function(aJ){return H(e,aJ).length>0}}),contains:u(function(e){return function(aJ){return(aJ.textContent||aJ.innerText||S(aJ)).indexOf(e)>-1}}),lang:u(function(e){if(!af.test(e||\"\")){H.error(\"unsupported lang: \"+e)}e=e.replace(E,aq).toLowerCase();return function(aK){var aJ;do{if((aJ=au?aK.lang:aK.getAttribute(\"xml:lang\")||aK.getAttribute(\"lang\"))){aJ=aJ.toLowerCase();return aJ===e||aJ.indexOf(e+\"-\")===0}}while((aK=aK.parentNode)&&aK.nodeType===1);return false}}),target:function(e){var aJ=aB.location&&aB.location.hash;return aJ&&aJ.slice(1)===e.id},root:function(e){return e===A},focus:function(e){return e===N.activeElement&&(!N.hasFocus||N.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:function(e){return e.disabled===false},disabled:function(e){return e.disabled===true},checked:function(e){var aJ=e.nodeName.toLowerCase();return(aJ===\"input\"&&!!e.checked)||(aJ===\"option\"&&!!e.selected)},selected:function(e){if(e.parentNode){e.parentNode.selectedIndex}return e.selected===true},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling){if(e.nodeType<6){return false}}return true},parent:function(e){return !z.pseudos.empty(e)},header:function(e){return w.test(e.nodeName)},input:function(e){return n.test(e.nodeName)},button:function(aJ){var e=aJ.nodeName.toLowerCase();return e===\"input\"&&aJ.type===\"button\"||e===\"button\"},text:function(aJ){var e;return aJ.nodeName.toLowerCase()===\"input\"&&aJ.type===\"text\"&&((e=aJ.getAttribute(\"type\"))==null||e.toLowerCase()===\"text\")},first:at(function(){return[0]}),last:at(function(e,aJ){return[aJ-1]}),eq:at(function(e,aK,aJ){return[aJ<0?aJ+aK:aJ]}),even:at(function(e,aK){var aJ=0;for(;aJ<aK;aJ+=2){e.push(aJ)}return e}),odd:at(function(e,aK){var aJ=1;for(;aJ<aK;aJ+=2){e.push(aJ)}return e}),lt:at(function(e,aL,aK){var aJ=aK<0?aK+aL:aK;for(;--aJ>=0;){e.push(aJ)}return e}),gt:at(function(e,aL,aK){var aJ=aK<0?aK+aL:aK;for(;++aJ<aL;){e.push(aJ)}return e})}};z.pseudos.nth=z.pseudos.eq;for(J in {radio:true,checkbox:true,file:true,password:true,image:true}){z.pseudos[J]=I(J)}for(J in {submit:true,reset:true}){z.pseudos[J]=l(J)}function ag(){}ag.prototype=z.filters=z.pseudos;z.setFilters=new ag();function s(aM,aR){var aJ,aN,aP,aQ,aO,aK,e,aL=av[aM+\" \"];if(aL){return aR?0:aL.slice(0)}aO=aM;aK=[];e=z.preFilter;while(aO){if(!aJ||(aN=G.exec(aO))){if(aN){aO=aO.slice(aN[0].length)||aO}aK.push((aP=[]))}aJ=false;if((aN=M.exec(aO))){aJ=aN.shift();aP.push({value:aJ,type:aN[0].replace(D,\" \")});aO=aO.slice(aJ.length)}for(aQ in z.filter){if((aN=an[aQ].exec(aO))&&(!e[aQ]||(aN=e[aQ](aN)))){aJ=aN.shift();aP.push({value:aJ,type:aQ,matches:aN});aO=aO.slice(aJ.length)}}if(!aJ){break}}return aR?aO.length:aO?H.error(aM):av(aM,aK).slice(0)}function t(aL){var aK=0,aJ=aL.length,e=\"\";for(;aK<aJ;aK++){e+=aL[aK].value}return e}function C(aM,aK,aL){var e=aK.dir,aN=aL&&e===\"parentNode\",aJ=ap++;return aK.first?function(aQ,aP,aO){while((aQ=aQ[e])){if(aQ.nodeType===1||aN){return aM(aQ,aP,aO)}}}:function(aS,aQ,aP){var aT,aR,aO=[aF,aJ];if(aP){while((aS=aS[e])){if(aS.nodeType===1||aN){if(aM(aS,aQ,aP)){return true}}}}else{while((aS=aS[e])){if(aS.nodeType===1||aN){aR=aS[aw]||(aS[aw]={});if((aT=aR[e])&&aT[0]===aF&&aT[1]===aJ){return(aO[2]=aT[2])}else{aR[e]=aO;if((aO[2]=aM(aS,aQ,aP))){return true}}}}}}}function aH(e){return e.length>1?function(aM,aL,aJ){var aK=e.length;while(aK--){if(!e[aK](aM,aL,aJ)){return false}}return true}:e[0]}function K(aJ,aM,aL){var aK=0,e=aM.length;for(;aK<e;aK++){H(aJ,aM[aK],aL)}return aL}function al(e,aJ,aK,aL,aO){var aM,aR=[],aN=0,aP=e.length,aQ=aJ!=null;for(;aN<aP;aN++){if((aM=e[aN])){if(!aK||aK(aM,aL,aO)){aR.push(aM);if(aQ){aJ.push(aN)}}}}return aR}function r(aK,aJ,aM,aL,aN,e){if(aL&&!aL[aw]){aL=r(aL)}if(aN&&!aN[aw]){aN=r(aN,e)}return u(function(aY,aV,aQ,aX){var a0,aW,aS,aR=[],aZ=[],aP=aV.length,aO=aY||K(aJ||\"*\",aQ.nodeType?[aQ]:aQ,[]),aT=aK&&(aY||!aJ)?al(aO,aR,aK,aQ,aX):aO,aU=aM?aN||(aY?aK:aP||aL)?[]:aV:aT;if(aM){aM(aT,aU,aQ,aX)}if(aL){a0=al(aU,aZ);aL(a0,[],aQ,aX);aW=a0.length;while(aW--){if((aS=a0[aW])){aU[aZ[aW]]=!(aT[aZ[aW]]=aS)}}}if(aY){if(aN||aK){if(aN){a0=[];aW=aU.length;while(aW--){if((aS=aU[aW])){a0.push((aT[aW]=aS))}}aN(null,(aU=[]),a0,aX)}aW=aU.length;while(aW--){if((aS=aU[aW])&&(a0=aN?o.call(aY,aS):aR[aW])>-1){aY[a0]=!(aV[a0]=aS)}}}}else{aU=al(aU===aV?aU.splice(aP,aU.length):aU);if(aN){aN(null,aV,aU,aX)}else{d.apply(aV,aU)}}})}function ax(aO){var aJ,aM,aK,aN=aO.length,aR=z.relative[aO[0].type],aS=aR||z.relative[\" \"],aL=aR?1:0,aP=C(function(aT){return aT===aJ},aS,true),aQ=C(function(aT){return o.call(aJ,aT)>-1},aS,true),e=[function(aV,aU,aT){return(!aR&&(aT||aU!==aI))||((aJ=aU).nodeType?aP(aV,aU,aT):aQ(aV,aU,aT))}];for(;aL<aN;aL++){if((aM=z.relative[aO[aL].type])){e=[C(aH(e),aM)]}else{aM=z.filter[aO[aL].type].apply(null,aO[aL].matches);if(aM[aw]){aK=++aL;for(;aK<aN;aK++){if(z.relative[aO[aK].type]){break}}return r(aL>1&&aH(e),aL>1&&t(aO.slice(0,aL-1).concat({value:aO[aL-2].type===\" \"?\"*\":\"\"})).replace(D,\"$1\"),aM,aL<aK&&ax(aO.slice(aL,aK)),aK<aN&&ax((aO=aO.slice(aK))),aK<aN&&t(aO))}e.push(aM)}}return aH(e)}function aj(aL,aK){var e=aK.length>0,aM=aL.length>0,aJ=function(aW,aQ,aV,aU,aZ){var aR,aS,aX,a1=0,aT=\"0\",aN=aW&&[],a2=[],a0=aI,aP=aW||aM&&z.find.TAG(\"*\",aZ),aO=(aF+=a0==null?1:Math.random()||0.1),aY=aP.length;if(aZ){aI=aQ!==N&&aQ}for(;aT!==aY&&(aR=aP[aT])!=null;aT++){if(aM&&aR){aS=0;while((aX=aL[aS++])){if(aX(aR,aQ,aV)){aU.push(aR);break}}if(aZ){aF=aO}}if(e){if((aR=!aX&&aR)){a1--}if(aW){aN.push(aR)}}}a1+=aT;if(e&&aT!==a1){aS=0;while((aX=aK[aS++])){aX(aN,a2,aQ,aV)}if(aW){if(a1>0){while(aT--){if(!(aN[aT]||a2[aT])){a2[aT]=az.call(aU)}}}a2=al(a2)}d.apply(aU,a2);if(aZ&&!aW&&a2.length>0&&(a1+aK.length)>1){H.uniqueSort(aU)}}if(aZ){aF=aO;aI=a0}return aN};return e?u(aJ):aJ}ah=H.compile=function(e,aK){var aL,aJ=[],aN=[],aM=R[e+\" \"];if(!aM){if(!aK){aK=s(e)}aL=aK.length;while(aL--){aM=ax(aK[aL]);if(aM[aw]){aJ.push(aM)}else{aN.push(aM)}}aM=R(e,aj(aN,aJ));aM.selector=e}return aM};aD=H.select=function(aK,e,aL,aO){var aM,aR,aJ,aS,aP,aQ=typeof aK===\"function\"&&aK,aN=!aO&&s((aK=aQ.selector||aK));aL=aL||[];if(aN.length===1){aR=aN[0]=aN[0].slice(0);if(aR.length>2&&(aJ=aR[0]).type===\"ID\"&&aE.getById&&e.nodeType===9&&au&&z.relative[aR[1].type]){e=(z.find.ID(aJ.matches[0].replace(E,aq),e)||[])[0];if(!e){return aL}else{if(aQ){e=e.parentNode}}aK=aK.slice(aR.shift().value.length)}aM=an.needsContext.test(aK)?0:aR.length;while(aM--){aJ=aR[aM];if(z.relative[(aS=aJ.type)]){break}if((aP=z.find[aS])){if((aO=aP(aJ.matches[0].replace(E,aq),am.test(aR[0].type)&&ae(e.parentNode)||e))){aR.splice(aM,1);aK=aO.length&&t(aR);if(!aK){d.apply(aL,aO);return aL}break}}}}(aQ||ah(aK,aN))(aO,e,!au,aL,am.test(aK)&&ae(e.parentNode)||e);return aL};aE.sortStable=aw.split(\"\").sort(P).join(\"\")===aw;aE.detectDuplicates=!!ai;ak();aE.sortDetached=q(function(e){return e.compareDocumentPosition(N.createElement(\"div\"))&1});if(!q(function(e){e.innerHTML=\"<a href='#'></a>\";return e.firstChild.getAttribute(\"href\")===\"#\"})){aG(\"type|href|height|width\",function(aJ,e,aK){if(!aK){return aJ.getAttribute(e,e.toLowerCase()===\"type\"?1:2)}})}if(!aE.attributes||!q(function(e){e.innerHTML=\"<input/>\";e.firstChild.setAttribute(\"value\",\"\");return e.firstChild.getAttribute(\"value\")===\"\"})){aG(\"value\",function(aJ,e,aK){if(!aK&&aJ.nodeName.toLowerCase()===\"input\"){return aJ.defaultValue}})}if(!q(function(e){return e.getAttribute(\"disabled\")==null})){aG(f,function(aJ,e,aL){var aK;if(!aL){return aJ[e]===true?e.toLowerCase():(aK=aJ.getAttributeNode(e))&&aK.specified?aK.value:null}})}if(typeof define===\"function\"&&define.amd){define(function(){return H})}else{if(typeof module!==\"undefined\"&&module.exports){module.exports=H}else{aB.Sizzle=H}}})(window);(function(){if(typeof Sizzle!==\"undefined\"){return}if(typeof define!==\"undefined\"&&define.amd){window.Sizzle=Prototype._actual_sizzle;window.define=Prototype._original_define;delete Prototype._actual_sizzle;delete Prototype._original_define}else{if(typeof module!==\"undefined\"&&module.exports){window.Sizzle=module.exports;module.exports={}}}})();(function(e){var f=Prototype.Selector.extendElements;function b(g,h){return f(e(g,h||document))}function d(h,g){return e.matches(g,[h]).length==1}Prototype.Selector.engine=e;Prototype.Selector.select=b;Prototype.Selector.match=d})(Sizzle);window.Sizzle=Prototype._original_property;delete Prototype._original_property;var Form={reset:function(b){b=$(b);b.reset();return b},serializeElements:function(n,f){if(typeof f!=\"object\"){f={hash:!!f}}else{if(Object.isUndefined(f.hash)){f.hash=true}}var g,l,b=false,h=f.submit,d,e;if(f.hash){e={};d=function(o,p,q){if(p in o){if(!Object.isArray(o[p])){o[p]=[o[p]]}o[p]=o[p].concat(q)}else{o[p]=q}return o}}else{e=\"\";d=function(o,q,p){if(!Object.isArray(p)){p=[p]}if(!p.length){return o}var r=encodeURIComponent(q).gsub(/%20/,\"+\");return o+(o?\"&\":\"\")+p.map(function(s){s=s.gsub(/(\\r)?\\n/,\"\\r\\n\");s=encodeURIComponent(s);s=s.gsub(/%20/,\"+\");return r+\"=\"+s}).join(\"&\")}}return n.inject(e,function(o,p){if(!p.disabled&&p.name){g=p.name;l=$(p).getValue();if(l!=null&&p.type!=\"file\"&&(p.type!=\"submit\"||(!b&&h!==false&&(!h||g==h)&&(b=true)))){o=d(o,g,l)}}return o})}};Form.Methods={serialize:function(d,b){return Form.serializeElements(Form.getElements(d),b)},getElements:function(g){var h=$(g).getElementsByTagName(\"*\");var f,e=[],d=Form.Element.Serializers;for(var b=0;f=h[b];b++){if(d[f.tagName.toLowerCase()]){e.push(Element.extend(f))}}return e},getInputs:function(l,e,f){l=$(l);var b=l.getElementsByTagName(\"input\");if(!e&&!f){return $A(b).map(Element.extend)}for(var g=0,n=[],h=b.length;g<h;g++){var d=b[g];if((e&&d.type!=e)||(f&&d.name!=f)){continue}n.push(Element.extend(d))}return n},disable:function(b){b=$(b);Form.getElements(b).invoke(\"disable\");return b},enable:function(b){b=$(b);Form.getElements(b).invoke(\"enable\");return b},findFirstElement:function(d){var e=$(d).getElements().findAll(function(f){return\"hidden\"!=f.type&&!f.disabled});var b=e.findAll(function(f){return f.hasAttribute(\"tabIndex\")&&f.tabIndex>=0}).sortBy(function(f){return f.tabIndex}).first();return b?b:e.find(function(f){return/^(?:input|select|textarea)$/i.test(f.tagName)})},focusFirstElement:function(d){d=$(d);var b=d.findFirstElement();if(b){b.activate()}return d},request:function(d,b){d=$(d),b=Object.clone(b||{});var f=b.parameters,e=d.readAttribute(\"action\")||\"\";if(e.blank()){e=window.location.href}b.parameters=d.serialize(true);if(f){if(Object.isString(f)){f=f.toQueryParams()}Object.extend(b.parameters,f)}if(d.hasAttribute(\"method\")&&!b.method){b.method=d.method}return new Ajax.Request(e,b)}};Form.Element={focus:function(b){$(b).focus();return b},select:function(b){$(b).select();return b}};Form.Element.Methods={serialize:function(b){b=$(b);if(!b.disabled&&b.name){var d=b.getValue();if(d!=undefined){var e={};e[b.name]=d;return Object.toQueryString(e)}}return\"\"},getValue:function(b){b=$(b);var d=b.tagName.toLowerCase();return Form.Element.Serializers[d](b)},setValue:function(b,d){b=$(b);var e=b.tagName.toLowerCase();Form.Element.Serializers[e](b,d);return b},clear:function(b){$(b).value=\"\";return b},present:function(b){return $(b).value!=\"\"},activate:function(b){b=$(b);try{b.focus();if(b.select&&(b.tagName.toLowerCase()!=\"input\"||!(/^(?:button|reset|submit)$/i.test(b.type)))){b.select()}}catch(d){}return b},disable:function(b){b=$(b);b.disabled=true;return b},enable:function(b){b=$(b);b.disabled=false;return b}};var Field=Form.Element;var $F=Form.Element.Methods.getValue;Form.Element.Serializers=(function(){function d(n,o){switch(n.type.toLowerCase()){case\"checkbox\":case\"radio\":return h(n,o);default:return g(n,o)}}function h(n,o){if(Object.isUndefined(o)){return n.checked?n.value:null}else{n.checked=!!o}}function g(n,o){if(Object.isUndefined(o)){return n.value}else{n.value=o}}function b(p,s){if(Object.isUndefined(s)){return(p.type===\"select-one\"?e:f)(p)}var o,q,t=!Object.isArray(s);for(var n=0,r=p.length;n<r;n++){o=p.options[n];q=this.optionValue(o);if(t){if(q==s){o.selected=true;return}}else{o.selected=s.include(q)}}}function e(o){var n=o.selectedIndex;return n>=0?l(o.options[n]):null}function f(q){var n,r=q.length;if(!r){return null}for(var p=0,n=[];p<r;p++){var o=q.options[p];if(o.selected){n.push(l(o))}}return n}function l(n){return Element.hasAttribute(n,\"value\")?n.value:n.text}return{input:d,inputSelector:h,textarea:g,select:b,selectOne:e,selectMany:f,optionValue:l,button:g}})();Abstract.TimedObserver=Class.create(PeriodicalExecuter,{initialize:function($super,b,d,e){$super(e,d);this.element=$(b);this.lastValue=this.getValue()},execute:function(){var b=this.getValue();if(Object.isString(this.lastValue)&&Object.isString(b)?this.lastValue!=b:String(this.lastValue)!=String(b)){this.callback(this.element,b);this.lastValue=b}}});Form.Element.Observer=Class.create(Abstract.TimedObserver,{getValue:function(){return Form.Element.getValue(this.element)}});Form.Observer=Class.create(Abstract.TimedObserver,{getValue:function(){return Form.serialize(this.element)}});Abstract.EventObserver=Class.create({initialize:function(b,d){this.element=$(b);this.callback=d;this.lastValue=this.getValue();if(this.element.tagName.toLowerCase()==\"form\"){this.registerFormCallbacks()}else{this.registerCallback(this.element)}},onElementEvent:function(){var b=this.getValue();if(this.lastValue!=b){this.callback(this.element,b);this.lastValue=b}},registerFormCallbacks:function(){Form.getElements(this.element).each(this.registerCallback,this)},registerCallback:function(b){if(b.type){switch(b.type.toLowerCase()){case\"checkbox\":case\"radio\":Event.observe(b,\"click\",this.onElementEvent.bind(this));break;default:Event.observe(b,\"change\",this.onElementEvent.bind(this));break}}}});Form.Element.EventObserver=Class.create(Abstract.EventObserver,{getValue:function(){return Form.Element.getValue(this.element)}});Form.EventObserver=Class.create(Abstract.EventObserver,{getValue:function(){return Form.serialize(this.element)}});(function(K){var B=document.createElement(\"div\");var f=document.documentElement;var q=\"onmouseenter\" in f&&\"onmouseleave\" in f;var S={KEY_BACKSPACE:8,KEY_TAB:9,KEY_RETURN:13,KEY_ESC:27,KEY_LEFT:37,KEY_UP:38,KEY_RIGHT:39,KEY_DOWN:40,KEY_DELETE:46,KEY_HOME:36,KEY_END:35,KEY_PAGEUP:33,KEY_PAGEDOWN:34,KEY_INSERT:45};var H=function(ae){return false};if(window.attachEvent){if(window.addEventListener){H=function(ae){return !(ae instanceof window.Event)}}else{H=function(ae){return true}}}var V;function T(af,ae){return af.which?(af.which===ae+1):(af.button===ae)}var ad={0:1,1:4,2:2};function Z(af,ae){return af.button===ad[ae]}function W(af,ae){switch(ae){case 0:return af.which==1&&!af.metaKey;case 1:return af.which==2||(af.which==1&&af.metaKey);case 2:return af.which==3;default:return false}}if(window.attachEvent){if(!window.addEventListener){V=Z}else{V=function(af,ae){return H(af)?Z(af,ae):T(af,ae)}}}else{if(Prototype.Browser.WebKit){V=W}else{V=T}}function I(ae){return V(ae,0)}function o(ae){return V(ae,1)}function g(ae){return V(ae,2)}function u(ae){return Element.extend(R(ae))}function R(ag){ag=S.extend(ag);var af=ag.target,ae=ag.type,ah=ag.currentTarget;if(ah&&ah.tagName){if(ae===\"load\"||ae===\"error\"||(ae===\"click\"&&ah.tagName.toLowerCase()===\"input\"&&ah.type===\"radio\")){af=ah}}return af.nodeType==Node.TEXT_NODE?af.parentNode:af}function p(ag,ah){var af=R(ag),ae=Prototype.Selector;if(!ah){return Element.extend(af)}while(af){if(Object.isElement(af)&&ae.match(af,ah)){return Element.extend(af)}af=af.parentNode}}function A(ae){return{x:ab(ae),y:aa(ae)}}function ab(ag){var af=document.documentElement,ae=document.body||{scrollLeft:0};return ag.pageX||(ag.clientX+(af.scrollLeft||ae.scrollLeft)-(af.clientLeft||0))}function aa(ag){var af=document.documentElement,ae=document.body||{scrollTop:0};return ag.pageY||(ag.clientY+(af.scrollTop||ae.scrollTop)-(af.clientTop||0))}function y(ae){S.extend(ae);ae.preventDefault();ae.stopPropagation();ae.stopped=true}S.Methods={isLeftClick:I,isMiddleClick:o,isRightClick:g,element:u,findElement:p,pointer:A,pointerX:ab,pointerY:aa,stop:y};var O=Object.keys(S.Methods).inject({},function(ae,af){ae[af]=S.Methods[af].methodize();return ae});if(window.attachEvent){function ac(af){var ae;switch(af.type){case\"mouseover\":case\"mouseenter\":ae=af.fromElement;break;case\"mouseout\":case\"mouseleave\":ae=af.toElement;break;default:return null}return Element.extend(ae)}var X={stopPropagation:function(){this.cancelBubble=true},preventDefault:function(){this.returnValue=false},inspect:function(){return\"[object Event]\"}};S.extend=function(af,ae){if(!af){return false}if(!H(af)){return af}if(af._extendedByPrototype){return af}af._extendedByPrototype=Prototype.emptyFunction;var ag=S.pointer(af);Object.extend(af,{target:af.srcElement||ae,relatedTarget:ac(af),pageX:ag.x,pageY:ag.y});Object.extend(af,O);Object.extend(af,X);return af}}else{S.extend=Prototype.K}if(window.addEventListener){S.prototype=window.Event.prototype||document.createEvent(\"HTMLEvents\").__proto__;Object.extend(S.prototype,O)}var C={mouseenter:\"mouseover\",mouseleave:\"mouseout\"};function h(ae){return C[ae]||ae}if(q){h=Prototype.K}function Y(ae){if(ae===window){return 0}if(typeof ae._prototypeUID===\"undefined\"){ae._prototypeUID=Element.Storage.UID++}return ae._prototypeUID}function P(ae){if(ae===window){return 0}if(ae==document){return 1}return ae.uniqueID}if(\"uniqueID\" in B){Y=P}function E(ae){return ae.include(\":\")}S._isCustomEvent=E;function G(ag,af){var ae=K.Event.cache;if(Object.isUndefined(af)){af=Y(ag)}if(!ae[af]){ae[af]={element:ag}}return ae[af]}function L(af,ae){if(Object.isUndefined(ae)){ae=Y(af)}delete K.Event.cache[ae]}function n(ag,aj,am){var ae=G(ag);if(!ae[aj]){ae[aj]=[]}var ai=ae[aj];var ah=ai.length;while(ah--){if(ai[ah].handler===am){return null}}var ak=Y(ag);var af=K.Event._createResponder(ak,aj,am);var al={responder:af,handler:am};ai.push(al);return al}function z(aj,ag,ak){var af=G(aj);var ae=af[ag]||[];var ai=ae.length,al;while(ai--){if(ae[ai].handler===ak){al=ae[ai];break}}if(al){var ah=ae.indexOf(al);ae.splice(ah,1)}if(ae.length===0){delete af[ag];if(Object.keys(af).length===1&&(\"element\" in af)){L(aj)}}return al}function e(ag,af,ah){ag=$(ag);var ai=n(ag,af,ah);if(ai===null){return ag}var ae=ai.responder;if(E(af)){v(ag,af,ae)}else{s(ag,af,ae)}return ag}function s(ah,ag,af){var ae=h(ag);if(ah.addEventListener){ah.addEventListener(ae,af,false)}else{ah.attachEvent(\"on\"+ae,af)}}function v(ag,af,ae){if(ag.addEventListener){ag.addEventListener(\"dataavailable\",ae,false)}else{ag.attachEvent(\"ondataavailable\",ae);ag.attachEvent(\"onlosecapture\",ae)}}function Q(af,ae,ag){af=$(af);var ai=!Object.isUndefined(ag),aj=!Object.isUndefined(ae);if(!aj&&!ai){F(af);return af}if(!ai){N(af,ae);return af}var ah=z(af,ae,ag);if(!ah){return af}b(af,ae,ah.responder);return af}function J(ah,ag,af){var ae=h(ag);if(ah.removeEventListener){ah.removeEventListener(ae,af,false)}else{ah.detachEvent(\"on\"+ae,af)}}function d(ag,af,ae){if(ag.removeEventListener){ag.removeEventListener(\"dataavailable\",ae,false)}else{ag.detachEvent(\"ondataavailable\",ae);ag.detachEvent(\"onlosecapture\",ae)}}function F(aj){var ai=Y(aj),ag=K.Event.cache[ai];if(!ag){return}L(aj,ai);var ae,ah;for(var af in ag){if(af===\"element\"){continue}ae=ag[af];ah=ae.length;while(ah--){b(aj,af,ae[ah].responder)}}}function N(aj,ag){var af=G(aj);var ae=af[ag];if(ae){delete af[ag]}ae=ae||[];var ai=ae.length;while(ai--){b(aj,ag,ae[ai].responder)}for(var ah in af){if(ah===\"element\"){continue}return}L(aj)}function b(af,ae,ag){if(E(ae)){d(af,ae,ag)}else{J(af,ae,ag)}}function l(ae){if(ae!==document){return ae}if(document.createEvent&&!ae.dispatchEvent){return document.documentElement}return ae}function D(ah,ag,af,ae){ah=l($(ah));if(Object.isUndefined(ae)){ae=true}af=af||{};var ai=U(ah,ag,af,ae);return S.extend(ai)}function r(ah,ag,af,ae){var ai=document.createEvent(\"HTMLEvents\");ai.initEvent(\"dataavailable\",ae,true);ai.eventName=ag;ai.memo=af;ah.dispatchEvent(ai);return ai}function t(ah,ag,af,ae){var ai=document.createEventObject();ai.eventType=ae?\"ondataavailable\":\"onlosecapture\";ai.eventName=ag;ai.memo=af;ah.fireEvent(ai.eventType,ai);return ai}var U=document.createEvent?r:t;S.Handler=Class.create({initialize:function(ag,af,ae,ah){this.element=$(ag);this.eventName=af;this.selector=ae;this.callback=ah;this.handler=this.handleEvent.bind(this)},start:function(){S.observe(this.element,this.eventName,this.handler);return this},stop:function(){S.stopObserving(this.element,this.eventName,this.handler);return this},handleEvent:function(af){var ae=S.findElement(af,this.selector);if(ae){this.callback.call(this.element,af,ae)}}});function M(ag,af,ae,ah){ag=$(ag);if(Object.isFunction(ae)&&Object.isUndefined(ah)){ah=ae,ae=null}return new S.Handler(ag,af,ae,ah).start()}Object.extend(S,S.Methods);Object.extend(S,{fire:D,observe:e,stopObserving:Q,on:M});Element.addMethods({fire:D,observe:e,stopObserving:Q,on:M});Object.extend(document,{fire:D.methodize(),observe:e.methodize(),stopObserving:Q.methodize(),on:M.methodize(),loaded:false});if(K.Event){Object.extend(window.Event,S)}else{K.Event=S}K.Event.cache={};function w(){K.Event.cache=null}if(window.attachEvent){window.attachEvent(\"onunload\",w)}B=null;f=null})(this);(function(e){var l=document.documentElement;var d=\"onmouseenter\" in l&&\"onmouseleave\" in l;function h(n){return !d&&(n===\"mouseenter\"||n===\"mouseleave\")}function f(o,n,p){if(Event._isCustomEvent(n)){return g(o,n,p)}if(h(n)){return b(o,n,p)}return function(r){if(!Event.cache){return}var q=Event.cache[o].element;Event.extend(r,q);p.call(q,r)}}function g(o,n,p){return function(s){var q=Event.cache[o];var r=q&&q.element;if(Object.isUndefined(s.eventName)){return false}if(s.eventName!==n){return false}Event.extend(s,r);p.call(r,s)}}function b(o,n,p){return function(s){var q=Event.cache[o].element;Event.extend(s,q);var r=s.relatedTarget;while(r&&r!==q){try{r=r.parentNode}catch(t){r=q}}if(r===q){return}p.call(q,s)}}e.Event._createResponder=f;l=null})(this);(function(b){var g;function d(){if(document.loaded){return}if(g){window.clearTimeout(g)}document.loaded=true;document.fire(\"dom:loaded\")}function f(){if(document.readyState===\"complete\"){document.detachEvent(\"onreadystatechange\",f);d()}}function e(){try{document.documentElement.doScroll(\"left\")}catch(h){g=e.defer();return}d()}if(document.readyState===\"complete\"){d();return}if(document.addEventListener){document.addEventListener(\"DOMContentLoaded\",d,false)}else{document.attachEvent(\"onreadystatechange\",f);if(window==top){g=e.defer()}}Event.observe(window,\"load\",d)})(this);Element.addMethods();Hash.toQueryString=Object.toQueryString;var Toggle={display:Element.toggle};Element.addMethods({childOf:Element.Methods.descendantOf});var Insertion={Before:function(b,d){return Element.insert(b,{before:d})},Top:function(b,d){return Element.insert(b,{top:d})},Bottom:function(b,d){return Element.insert(b,{bottom:d})},After:function(b,d){return Element.insert(b,{after:d})}};var $continue=new Error('\"throw $continue\" is deprecated, use \"return\" instead');var Position={includeScrollOffsets:false,prepare:function(){this.deltaX=window.pageXOffset||document.documentElement.scrollLeft||document.body.scrollLeft||0;this.deltaY=window.pageYOffset||document.documentElement.scrollTop||document.body.scrollTop||0},within:function(d,b,e){if(this.includeScrollOffsets){return this.withinIncludingScrolloffsets(d,b,e)}this.xcomp=b;this.ycomp=e;this.offset=Element.cumulativeOffset(d);return(e>=this.offset[1]&&e<this.offset[1]+d.offsetHeight&&b>=this.offset[0]&&b<this.offset[0]+d.offsetWidth)},withinIncludingScrolloffsets:function(d,b,f){var e=Element.cumulativeScrollOffset(d);this.xcomp=b+e[0]-this.deltaX;this.ycomp=f+e[1]-this.deltaY;this.offset=Element.cumulativeOffset(d);return(this.ycomp>=this.offset[1]&&this.ycomp<this.offset[1]+d.offsetHeight&&this.xcomp>=this.offset[0]&&this.xcomp<this.offset[0]+d.offsetWidth)},overlap:function(d,b){if(!d){return 0}if(d==\"vertical\"){return((this.offset[1]+b.offsetHeight)-this.ycomp)/b.offsetHeight}if(d==\"horizontal\"){return((this.offset[0]+b.offsetWidth)-this.xcomp)/b.offsetWidth}},cumulativeOffset:Element.Methods.cumulativeOffset,positionedOffset:Element.Methods.positionedOffset,absolutize:function(b){Position.prepare();return Element.absolutize(b)},relativize:function(b){Position.prepare();return Element.relativize(b)},realOffset:Element.Methods.cumulativeScrollOffset,offsetParent:Element.Methods.getOffsetParent,page:Element.Methods.viewportOffset,clone:function(d,e,b){b=b||{};return Element.clonePosition(e,d,b)}};if(!document.getElementsByClassName){document.getElementsByClassName=function(d){function b(e){return e.blank()?null:\"[contains(concat(' ', @class, ' '), ' \"+e+\" ')]\"}d.getElementsByClassName=Prototype.BrowserFeatures.XPath?function(e,g){g=g.toString().strip();var f=/\\s/.test(g)?$w(g).map(b).join(\"\"):b(g);return f?document._getElementsByXPath(\".//*\"+f,e):[]}:function(g,h){h=h.toString().strip();var l=[],n=(/\\s/.test(h)?$w(h):null);if(!n&&!h){return l}var e=$(g).getElementsByTagName(\"*\");h=\" \"+h+\" \";for(var f=0,p,o;p=e[f];f++){if(p.className&&(o=\" \"+p.className+\" \")&&(o.include(h)||(n&&n.all(function(q){return !q.toString().blank()&&o.include(\" \"+q+\" \")})))){l.push(Element.extend(p))}}return l};return function(f,e){return $(e||document.body).getElementsByClassName(f)}}(Element.Methods)}Element.ClassNames=Class.create();Element.ClassNames.prototype={initialize:function(b){this.element=$(b)},_each:function(d,b){this.element.className.split(/\\s+/).select(function(e){return e.length>0})._each(d,b)},set:function(b){this.element.className=b},add:function(b){if(this.include(b)){return}this.set($A(this).concat(b).join(\" \"))},remove:function(b){if(!this.include(b)){return}this.set($A(this).without(b).join(\" \"))},toString:function(){return $A(this).join(\" \")}};Object.extend(Element.ClassNames.prototype,Enumerable);(function(){window.Selector=Class.create({initialize:function(b){this.expression=b.strip()},findElements:function(b){return Prototype.Selector.select(this.expression,b)},match:function(b){return Prototype.Selector.match(b,this.expression)},toString:function(){return this.expression},inspect:function(){return\"#<Selector: \"+this.expression+\">\"}});Object.extend(Selector,{matchElements:function(h,l){var b=Prototype.Selector.match,f=[];for(var e=0,g=h.length;e<g;e++){var d=h[e];if(b(d,l)){f.push(Element.extend(d))}}return f},findElement:function(h,l,d){d=d||0;var b=0,f;for(var e=0,g=h.length;e<g;e++){f=h[e];if(Prototype.Selector.match(f,l)&&d===b++){return Element.extend(f)}}},findChildElements:function(d,e){var b=e.toArray().join(\", \");return Prototype.Selector.select(b,d||document)}})})();var Window=Class.create();Window.keepMultiModalWindow=false;Window.hasEffectLib=(typeof Effect!=\"undefined\");Window.resizeEffectDuration=0.4;Window.prototype={initialize:function(){var e;var d=0;if(arguments.length>0){if(typeof arguments[0]==\"string\"){e=arguments[0];d=1}else{e=arguments[0]?arguments[0].id:null}}if(!e){e=\"window_\"+new Date().getTime()}if($(e)){alert(\"Window \"+e+\" is already registered in the DOM! Make sure you use setDestroyOnClose() or destroyOnClose: true in the constructor\")}this.options=Object.extend({className:\"dialog\",blurClassName:null,minWidth:100,minHeight:20,resizable:true,closable:true,minimizable:true,maximizable:true,draggable:true,userData:null,showEffect:(Window.hasEffectLib?Effect.Appear:Element.show),hideEffect:(Window.hasEffectLib?Effect.Fade:Element.hide),showEffectOptions:{},hideEffectOptions:{},effectOptions:null,parent:document.body,title:\"&nbsp;\",url:null,onload:Prototype.emptyFunction,width:200,height:300,opacity:1,recenterAuto:true,wiredDrag:false,closeCallback:null,destroyOnClose:false,gridX:1,gridY:1},arguments[d]||{});if(this.options.blurClassName){this.options.focusClassName=this.options.className}if(typeof this.options.top==\"undefined\"&&typeof this.options.bottom==\"undefined\"){this.options.top=this._round(Math.random()*500,this.options.gridY)}if(typeof this.options.left==\"undefined\"&&typeof this.options.right==\"undefined\"){this.options.left=this._round(Math.random()*500,this.options.gridX)}if(this.options.effectOptions){Object.extend(this.options.hideEffectOptions,this.options.effectOptions);Object.extend(this.options.showEffectOptions,this.options.effectOptions);if(this.options.showEffect==Element.Appear){this.options.showEffectOptions.to=this.options.opacity}}if(Window.hasEffectLib){if(this.options.showEffect==Effect.Appear){this.options.showEffectOptions.to=this.options.opacity}if(this.options.hideEffect==Effect.Fade){this.options.hideEffectOptions.from=this.options.opacity}}if(this.options.hideEffect==Element.hide){this.options.hideEffect=function(){Element.hide(this.element);if(this.options.destroyOnClose){this.destroy()}}.bind(this)}if(this.options.parent!=document.body){this.options.parent=$(this.options.parent)}this.element=this._createWindow(e);this.element.win=this;this.eventMouseDown=this._initDrag.bindAsEventListener(this);this.eventMouseUp=this._endDrag.bindAsEventListener(this);this.eventMouseMove=this._updateDrag.bindAsEventListener(this);this.eventOnLoad=this._getWindowBorderSize.bindAsEventListener(this);this.eventMouseDownContent=this.toFront.bindAsEventListener(this);this.eventResize=this._recenter.bindAsEventListener(this);this.topbar=$(this.element.id+\"_top\");this.bottombar=$(this.element.id+\"_bottom\");this.content=$(this.element.id+\"_content\");Event.observe(this.topbar,\"mousedown\",this.eventMouseDown);Event.observe(this.bottombar,\"mousedown\",this.eventMouseDown);Event.observe(this.content,\"mousedown\",this.eventMouseDownContent);Event.observe(window,\"load\",this.eventOnLoad);Event.observe(window,\"resize\",this.eventResize);Event.observe(window,\"scroll\",this.eventResize);Event.observe(this.options.parent,\"scroll\",this.eventResize);if(this.options.draggable){var b=this;[this.topbar,this.topbar.up().previous(),this.topbar.up().next()].each(function(f){f.observe(\"mousedown\",b.eventMouseDown);f.addClassName(\"top_draggable\")});[this.bottombar.up(),this.bottombar.up().previous(),this.bottombar.up().next()].each(function(f){f.observe(\"mousedown\",b.eventMouseDown);f.addClassName(\"bottom_draggable\")})}if(this.options.resizable){this.sizer=$(this.element.id+\"_sizer\");Event.observe(this.sizer,\"mousedown\",this.eventMouseDown)}this.useLeft=null;this.useTop=null;if(typeof this.options.left!=\"undefined\"){this.element.setStyle({left:parseFloat(this.options.left)+\"px\"});this.useLeft=true}else{this.element.setStyle({right:parseFloat(this.options.right)+\"px\"});this.useLeft=false}if(typeof this.options.top!=\"undefined\"){this.element.setStyle({top:parseFloat(this.options.top)+\"px\"});this.useTop=true}else{this.element.setStyle({bottom:parseFloat(this.options.bottom)+\"px\"});this.useTop=false}this.storedLocation=null;this.setOpacity(this.options.opacity);if(this.options.zIndex){this.setZIndex(this.options.zIndex)}if(this.options.destroyOnClose){this.setDestroyOnClose(true)}this._getWindowBorderSize();this.width=this.options.width;this.height=this.options.height;this.visible=false;this.constraint=false;this.constraintPad={top:0,left:0,bottom:0,right:0};if(this.width&&this.height){this.setSize(this.options.width,this.options.height)}this.setTitle(this.options.title);Windows.register(this)},destroy:function(){this._notify(\"onDestroy\");Event.stopObserving(this.topbar,\"mousedown\",this.eventMouseDown);Event.stopObserving(this.bottombar,\"mousedown\",this.eventMouseDown);Event.stopObserving(this.content,\"mousedown\",this.eventMouseDownContent);Event.stopObserving(window,\"load\",this.eventOnLoad);Event.stopObserving(window,\"resize\",this.eventResize);Event.stopObserving(window,\"scroll\",this.eventResize);Event.stopObserving(this.options.parent,\"scroll\",this.eventResize);Event.stopObserving(this.content,\"load\",this.options.onload);if(this._oldParent){var e=this.getContent();var b=null;for(var d=0;d<e.childNodes.length;d++){b=e.childNodes[d];if(b.nodeType==1){break}b=null}if(b){this._oldParent.appendChild(b)}this._oldParent=null}if(this.sizer){Event.stopObserving(this.sizer,\"mousedown\",this.eventMouseDown)}if(this.options.url){this.content.src=null}if(this.wiredElement){this.wiredElement.remove()}if(this.iefix){Element.remove(this.iefix)}Element.remove(this.element);Windows.unregister(this)},setCloseCallback:function(b){this.options.closeCallback=b},getContent:function(){return this.content},setContent:function(n,l,e){var b=$(n);if(null==b){throw\"Unable to find element '\"+n+\"' in DOM\"}this._oldParent=b.parentNode;var h=null;var g=null;if(l){h=Element.getDimensions(b)}if(e){g=Position.cumulativeOffset(b)}var f=this.getContent();this.setHTMLContent(\"\");f=this.getContent();f.appendChild(b);b.show();if(l){this.setSize(h.width,h.height)}if(e){this.setLocation(g[1]-this.heightN,g[0]-this.widthW)}},setHTMLContent:function(b){if(this.options.url){this.content.src=null;this.options.url=null;var d='<div id=\"'+this.getId()+'_content\" class=\"'+this.options.className+'_content\"> </div>';$(this.getId()+\"_table_content\").innerHTML=d;this.content=$(this.element.id+\"_content\")}this.getContent().update(b);return this},setAjaxContent:function(d,b,f,e){this.showFunction=f?\"showCenter\":\"show\";this.showModal=e||false;b=b||{};this.setHTMLContent(\"\");this.onComplete=b.onComplete;if(!this._onCompleteHandler){this._onCompleteHandler=this._setAjaxContent.bind(this)}b.onComplete=this._onCompleteHandler;new Ajax.Request(d,b);b.onComplete=this.onComplete},_setAjaxContent:function(b){Element.update(this.getContent(),b.responseText);if(this.onComplete){this.onComplete(b)}this.onComplete=null;this[this.showFunction](this.showModal)},setURL:function(b){if(this.options.url){this.content.src=null}this.options.url=b;var d=\"<iframe frameborder='0' name='\"+this.getId()+\"_content'  id='\"+this.getId()+\"_content' src='\"+b+\"' width='\"+this.width+\"' height='\"+this.height+\"'> </iframe>\";$(this.getId()+\"_table_content\").innerHTML=d;this.content=$(this.element.id+\"_content\")},getURL:function(){return this.options.url?this.options.url:null},refresh:function(){if(this.options.url){$(this.element.getAttribute(\"id\")+\"_content\").src=this.options.url}},setCookie:function(d,e,t,g,b){d=d||this.element.id;this.cookie=[d,e,t,g,b];var r=WindowUtilities.getCookie(d);if(r){var s=r.split(\",\");var p=s[0].split(\":\");var o=s[1].split(\":\");var q=parseFloat(s[2]),l=parseFloat(s[3]);var n=s[4];var f=s[5];this.setSize(q,l);if(n==\"true\"){this.doMinimize=true}else{if(f==\"true\"){this.doMaximize=true}}this.useLeft=p[0]==\"l\";this.useTop=o[0]==\"t\";this.element.setStyle(this.useLeft?{left:p[1]}:{right:p[1]});this.element.setStyle(this.useTop?{top:o[1]}:{bottom:o[1]})}},getId:function(){return this.element.id},setDestroyOnClose:function(){this.options.destroyOnClose=true},setConstraint:function(b,d){this.constraint=b;this.constraintPad=Object.extend(this.constraintPad,d||{});if(this.useTop&&this.useLeft){this.setLocation(parseFloat(this.element.style.top),parseFloat(this.element.style.left))}},_initDrag:function(d){if(Event.element(d)==this.sizer&&this.isMinimized()){return}if(Event.element(d)!=this.sizer&&this.isMaximized()){return}if(Prototype.Browser.IE&&this.heightN==0){this._getWindowBorderSize()}this.pointer=[this._round(Event.pointerX(d),this.options.gridX),this._round(Event.pointerY(d),this.options.gridY)];if(this.options.wiredDrag){this.currentDrag=this._createWiredElement()}else{this.currentDrag=this.element}if(Event.element(d)==this.sizer){this.doResize=true;this.widthOrg=this.width;this.heightOrg=this.height;this.bottomOrg=parseFloat(this.element.getStyle(\"bottom\"));this.rightOrg=parseFloat(this.element.getStyle(\"right\"));this._notify(\"onStartResize\")}else{this.doResize=false;var b=$(this.getId()+\"_close\");if(b&&Position.within(b,this.pointer[0],this.pointer[1])){this.currentDrag=null;return}this.toFront();if(!this.options.draggable){return}this._notify(\"onStartMove\")}Event.observe(document,\"mouseup\",this.eventMouseUp,false);Event.observe(document,\"mousemove\",this.eventMouseMove,false);WindowUtilities.disableScreen(\"__invisible__\",\"__invisible__\",this.overlayOpacity);document.body.ondrag=function(){return false};document.body.onselectstart=function(){return false};this.currentDrag.show();Event.stop(d)},_round:function(d,b){return b==1?d:d=Math.floor(d/b)*b},_updateDrag:function(d){var b=[this._round(Event.pointerX(d),this.options.gridX),this._round(Event.pointerY(d),this.options.gridY)];var q=b[0]-this.pointer[0];var p=b[1]-this.pointer[1];if(this.doResize){var o=this.widthOrg+q;var f=this.heightOrg+p;q=this.width-this.widthOrg;p=this.height-this.heightOrg;if(this.useLeft){o=this._updateWidthConstraint(o)}else{this.currentDrag.setStyle({right:(this.rightOrg-q)+\"px\"})}if(this.useTop){f=this._updateHeightConstraint(f)}else{this.currentDrag.setStyle({bottom:(this.bottomOrg-p)+\"px\"})}this.setSize(o,f);this._notify(\"onResize\")}else{this.pointer=b;if(this.useLeft){var e=parseFloat(this.currentDrag.getStyle(\"left\"))+q;var n=this._updateLeftConstraint(e);this.pointer[0]+=n-e;this.currentDrag.setStyle({left:n+\"px\"})}else{this.currentDrag.setStyle({right:parseFloat(this.currentDrag.getStyle(\"right\"))-q+\"px\"})}if(this.useTop){var l=parseFloat(this.currentDrag.getStyle(\"top\"))+p;var g=this._updateTopConstraint(l);this.pointer[1]+=g-l;this.currentDrag.setStyle({top:g+\"px\"})}else{this.currentDrag.setStyle({bottom:parseFloat(this.currentDrag.getStyle(\"bottom\"))-p+\"px\"})}this._notify(\"onMove\")}if(this.iefix){this._fixIEOverlapping()}this._removeStoreLocation();Event.stop(d)},_endDrag:function(b){WindowUtilities.enableScreen(\"__invisible__\");if(this.doResize){this._notify(\"onEndResize\")}else{this._notify(\"onEndMove\")}Event.stopObserving(document,\"mouseup\",this.eventMouseUp,false);Event.stopObserving(document,\"mousemove\",this.eventMouseMove,false);Event.stop(b);this._hideWiredElement();this._saveCookie();document.body.ondrag=null;document.body.onselectstart=null},_updateLeftConstraint:function(d){if(this.constraint&&this.useLeft&&this.useTop){var b=this.options.parent==document.body?WindowUtilities.getPageSize().windowWidth:this.options.parent.getDimensions().width;if(d<this.constraintPad.left){d=this.constraintPad.left}if(d+this.width+this.widthE+this.widthW>b-this.constraintPad.right){d=b-this.constraintPad.right-this.width-this.widthE-this.widthW}}return d},_updateTopConstraint:function(e){if(this.constraint&&this.useLeft&&this.useTop){var b=this.options.parent==document.body?WindowUtilities.getPageSize().windowHeight:this.options.parent.getDimensions().height;var d=this.height+this.heightN+this.heightS;if(e<this.constraintPad.top){e=this.constraintPad.top}if(e+d>b-this.constraintPad.bottom){e=b-this.constraintPad.bottom-d}}return e},_updateWidthConstraint:function(b){if(this.constraint&&this.useLeft&&this.useTop){var d=this.options.parent==document.body?WindowUtilities.getPageSize().windowWidth:this.options.parent.getDimensions().width;var e=parseFloat(this.element.getStyle(\"left\"));if(e+b+this.widthE+this.widthW>d-this.constraintPad.right){b=d-this.constraintPad.right-e-this.widthE-this.widthW}}return b},_updateHeightConstraint:function(d){if(this.constraint&&this.useLeft&&this.useTop){var b=this.options.parent==document.body?WindowUtilities.getPageSize().windowHeight:this.options.parent.getDimensions().height;var e=parseFloat(this.element.getStyle(\"top\"));if(e+d+this.heightN+this.heightS>b-this.constraintPad.bottom){d=b-this.constraintPad.bottom-e-this.heightN-this.heightS}}return d},_createWindow:function(b){var h=this.options.className;var f=document.createElement(\"div\");f.setAttribute(\"id\",b);f.className=\"dialog\";var g;if(this.options.url){g='<iframe frameborder=\"0\" name=\"'+b+'_content\"  id=\"'+b+'_content\" src=\"'+this.options.url+'\"> </iframe>'}else{g='<div id=\"'+b+'_content\" class=\"'+h+'_content\"> </div>'}var l=this.options.closable?\"<div class='\"+h+\"_close' id='\"+b+\"_close' onclick='Windows.close(\\\"\"+b+\"\\\", event)'> </div>\":\"\";var n=this.options.minimizable?\"<div class='\"+h+\"_minimize' id='\"+b+\"_minimize' onclick='Windows.minimize(\\\"\"+b+\"\\\", event)'> </div>\":\"\";var o=this.options.maximizable?\"<div class='\"+h+\"_maximize' id='\"+b+\"_maximize' onclick='Windows.maximize(\\\"\"+b+\"\\\", event)'> </div>\":\"\";var e=this.options.resizable?\"class='\"+h+\"_sizer' id='\"+b+\"_sizer'\":\"class='\"+h+\"_se'\";var d=\"../themes/default/blank.gif\";f.innerHTML=l+n+o+\"      <table id='\"+b+\"_row1' class=\\\"top table_window\\\">        <tr>          <td class='\"+h+\"_nw'></td>          <td class='\"+h+\"_n'><div id='\"+b+\"_top' class='\"+h+\"_title title_window'>\"+this.options.title+\"</div></td>          <td class='\"+h+\"_ne'></td>        </tr>      </table>      <table id='\"+b+\"_row2' class=\\\"mid table_window\\\">        <tr>          <td class='\"+h+\"_w'></td>            <td id='\"+b+\"_table_content' class='\"+h+\"_content' valign='top'>\"+g+\"</td>          <td class='\"+h+\"_e'></td>        </tr>      </table>        <table id='\"+b+\"_row3' class=\\\"bot table_window\\\">        <tr>          <td class='\"+h+\"_sw'></td>            <td class='\"+h+\"_s'><div id='\"+b+\"_bottom' class='status_bar'><span style='float:left; width:1px; height:1px'></span></div></td>            <td \"+e+\"></td>        </tr>      </table>    \";Element.hide(f);this.options.parent.insertBefore(f,this.options.parent.firstChild);Event.observe($(b+\"_content\"),\"load\",this.options.onload);return f},changeClassName:function(b){var d=this.options.className;var e=this.getId();$A([\"_close\",\"_minimize\",\"_maximize\",\"_content\"]).each(function(f){this._toggleClassName($(e+f),d+f,b+f)}.bind(this));this._toggleClassName($(e+\"_top\"),d+\"_title\",b+\"_title\");$$(\"#\"+e+\" td\").each(function(f){f.className=f.className.sub(d,b)});this.options.className=b;this._getWindowBorderSize();this.setSize(this.width,this.height)},_toggleClassName:function(e,d,b){if(e){e.removeClassName(d);e.addClassName(b)}},setLocation:function(f,d){f=this._updateTopConstraint(f);d=this._updateLeftConstraint(d);var b=this.currentDrag||this.element;b.setStyle({top:f+\"px\"});b.setStyle({left:d+\"px\"});this.useLeft=true;this.useTop=true},getLocation:function(){var b={};if(this.useTop){b=Object.extend(b,{top:this.element.getStyle(\"top\")})}else{b=Object.extend(b,{bottom:this.element.getStyle(\"bottom\")})}if(this.useLeft){b=Object.extend(b,{left:this.element.getStyle(\"left\")})}else{b=Object.extend(b,{right:this.element.getStyle(\"right\")})}return b},getSize:function(){return{width:this.width,height:this.height}},setSize:function(f,d,b){f=parseFloat(f);d=parseFloat(d);if(!this.minimized&&f<this.options.minWidth){f=this.options.minWidth}if(!this.minimized&&d<this.options.minHeight){d=this.options.minHeight}if(this.options.maxHeight&&d>this.options.maxHeight){d=this.options.maxHeight}if(this.options.maxWidth&&f>this.options.maxWidth){f=this.options.maxWidth}if(this.useTop&&this.useLeft&&Window.hasEffectLib&&Effect.ResizeWindow&&b){new Effect.ResizeWindow(this,null,null,f,d,{duration:Window.resizeEffectDuration})}else{this.width=f;this.height=d;var h=this.currentDrag?this.currentDrag:this.element;h.setStyle({width:f+this.widthW+this.widthE+\"px\"});h.setStyle({height:d+this.heightN+this.heightS+\"px\"});if(!this.currentDrag||this.currentDrag==this.element){var g=$(this.element.id+\"_content\");g.setStyle({height:d+\"px\"});g.setStyle({width:f+\"px\"})}}},updateHeight:function(){this.setSize(this.width,this.content.scrollHeight,true)},updateWidth:function(){this.setSize(this.content.scrollWidth,this.height,true)},toFront:function(){if(this.element.style.zIndex<Windows.maxZIndex){this.setZIndex(Windows.maxZIndex+1)}if(this.iefix){this._fixIEOverlapping()}},getBounds:function(d){if(!this.width||!this.height||!this.visible){this.computeBounds()}var b=this.width;var e=this.height;if(!d){b+=this.widthW+this.widthE;e+=this.heightN+this.heightS}var f=Object.extend(this.getLocation(),{width:b+\"px\",height:e+\"px\"});return f},computeBounds:function(){if(!this.width||!this.height){var b=WindowUtilities._computeSize(this.content.innerHTML,this.content.id,this.width,this.height,0,this.options.className);if(this.height){this.width=b+5}else{this.height=b+5}}this.setSize(this.width,this.height);if(this.centered){this._center(this.centerTop,this.centerLeft)}},show:function(d){this.visible=true;if(d){if(typeof this.overlayOpacity==\"undefined\"){var b=this;setTimeout(function(){b.show(d)},10);return}Windows.addModalWindow(this);this.modal=true;this.setZIndex(Windows.maxZIndex+1);Windows.unsetOverflow(this)}else{if(!this.element.style.zIndex){this.setZIndex(Windows.maxZIndex+1)}}if(this.oldStyle){this.getContent().setStyle({overflow:this.oldStyle})}this.computeBounds();this._notify(\"onBeforeShow\");if(this.options.showEffect!=Element.show&&this.options.showEffectOptions){this.options.showEffect(this.element,this.options.showEffectOptions)}else{this.options.showEffect(this.element)}this._checkIEOverlapping();WindowUtilities.focusedWindow=this;this._notify(\"onShow\")},showCenter:function(b,e,d){this.centered=true;this.centerTop=e;this.centerLeft=d;this.show(b)},isVisible:function(){return this.visible},_center:function(e,d){var f=WindowUtilities.getWindowScroll(this.options.parent);var b=WindowUtilities.getPageSize(this.options.parent);if(typeof e==\"undefined\"){e=(b.windowHeight-(this.height+this.heightN+this.heightS))/2}e+=f.top;if(typeof d==\"undefined\"){d=(b.windowWidth-(this.width+this.widthW+this.widthE))/2}d+=f.left;this.setLocation(e,d);this.toFront()},_recenter:function(d){if(this.centered){var b=WindowUtilities.getPageSize(this.options.parent);var e=WindowUtilities.getWindowScroll(this.options.parent);if(this.pageSize&&this.pageSize.windowWidth==b.windowWidth&&this.pageSize.windowHeight==b.windowHeight&&this.windowScroll.left==e.left&&this.windowScroll.top==e.top){return}this.pageSize=b;this.windowScroll=e;if($(\"overlay_modal\")){$(\"overlay_modal\").setStyle({height:(b.pageHeight+\"px\")})}if(this.options.recenterAuto){this._center(this.centerTop,this.centerLeft)}}},hide:function(){this.visible=false;if(this.modal){Windows.removeModalWindow(this);Windows.resetOverflow()}this.oldStyle=this.getContent().getStyle(\"overflow\")||\"auto\";this.getContent().setStyle({overflow:\"hidden\"});this.options.hideEffect(this.element,this.options.hideEffectOptions);if(this.iefix){this.iefix.hide()}if(!this.doNotNotifyHide){this._notify(\"onHide\")}},close:function(){if(this.visible){if(this.options.closeCallback&&!this.options.closeCallback(this)){return}if(this.options.destroyOnClose){var b=this.destroy.bind(this);if(this.options.hideEffectOptions.afterFinish){var d=this.options.hideEffectOptions.afterFinish;this.options.hideEffectOptions.afterFinish=function(){d();b()}}else{this.options.hideEffectOptions.afterFinish=function(){b()}}}Windows.updateFocusedWindow();this.doNotNotifyHide=true;this.hide();this.doNotNotifyHide=false;this._notify(\"onClose\")}},minimize:function(){if(this.isMaximized()||this.resizing){return}if(this.minimized){this.restore();return}var b=$(this.getId()+\"_row2\");this.minimized=true;var f=b.getDimensions().height;this.r2Height=f;var e=this.element.getHeight()-f;if(this.useLeft&&this.useTop&&Window.hasEffectLib&&Effect.ResizeWindow){new Effect.ResizeWindow(this,null,null,null,this.height-f,{duration:Window.resizeEffectDuration})}else{this.height-=f;this.element.setStyle({height:e+\"px\"});b.hide()}if(!this.useTop){var d=parseFloat(this.element.getStyle(\"bottom\"));this.element.setStyle({bottom:(d+f)+\"px\"})}this._notify(\"onMinimize\");this._saveCookie()},restore:function(){if(!this.minimized||this.resizing){return}var b=$(this.getId()+\"_row2\");this.minimized=false;var f=this.r2Height;this.r2Height=null;if(this.useLeft&&this.useTop&&Window.hasEffectLib&&Effect.ResizeWindow){new Effect.ResizeWindow(this,null,null,null,this.height+f,{duration:Window.resizeEffectDuration})}else{var e=this.element.getHeight()+f;this.height+=f;this.element.setStyle({height:e+\"px\"});b.show()}if(!this.useTop){var d=parseFloat(this.element.getStyle(\"bottom\"));this.element.setStyle({bottom:(d-f)+\"px\"})}this.toFront();this._saveCookie()},maximize:function(){if(this.isMinimized()||this.resizing){return}if(Prototype.Browser.IE&&this.heightN==0){this._getWindowBorderSize()}if(this.storedLocation!=null){this._restoreLocation();if(this.iefix){this.iefix.hide()}}else{this._storeLocation();Windows.unsetOverflow(this);var l=WindowUtilities.getWindowScroll(this.options.parent);var d=WindowUtilities.getPageSize(this.options.parent);var h=l.left;var g=l.top;if(this.options.parent!=document.body){l={top:0,left:0,bottom:0,right:0};var f=this.options.parent.getDimensions();d.windowWidth=f.width;d.windowHeight=f.height;g=0;h=0}if(this.constraint){d.windowWidth-=Math.max(0,this.constraintPad.left)+Math.max(0,this.constraintPad.right);d.windowHeight-=Math.max(0,this.constraintPad.top)+Math.max(0,this.constraintPad.bottom);h+=Math.max(0,this.constraintPad.left);g+=Math.max(0,this.constraintPad.top)}var e=d.windowWidth-this.widthW-this.widthE;var b=d.windowHeight-this.heightN-this.heightS;if(this.useLeft&&this.useTop&&Window.hasEffectLib&&Effect.ResizeWindow){new Effect.ResizeWindow(this,g,h,e,b,{duration:Window.resizeEffectDuration})}else{this.setSize(e,b);this.element.setStyle(this.useLeft?{left:h+\"px\"}:{right:h+\"px\"});this.element.setStyle(this.useTop?{top:g+\"px\"}:{bottom:g+\"px\"})}this.toFront();if(this.iefix){this._fixIEOverlapping()}}this._notify(\"onMaximize\");this._saveCookie()},isMinimized:function(){return this.minimized},isMaximized:function(){return(this.storedLocation!=null)},setOpacity:function(b){if(Element.setOpacity){Element.setOpacity(this.element,b)}},setZIndex:function(b){this.element.setStyle({zIndex:b});Windows.updateZindex(b,this)},setTitle:function(b){if(!b||b==\"\"){b=\"&nbsp;\"}Element.update(this.element.id+\"_top\",b)},getTitle:function(){return $(this.element.id+\"_top\").innerHTML},setStatusBar:function(d){var b=$(this.getId()+\"_bottom\");if(typeof(d)==\"object\"){if(this.bottombar.firstChild){this.bottombar.replaceChild(d,this.bottombar.firstChild)}else{this.bottombar.appendChild(d)}}else{this.bottombar.innerHTML=d}},_checkIEOverlapping:function(){if(!this.iefix&&(navigator.appVersion.indexOf(\"MSIE\")>0)&&(navigator.userAgent.indexOf(\"Opera\")<0)&&(this.element.getStyle(\"position\")==\"absolute\")){new Insertion.After(this.element.id,'<iframe id=\"'+this.element.id+'_iefix\" style=\"display:none;position:absolute;filter:progid:DXImageTransform.Microsoft.Alpha(opacity=0);\" src=\"javascript:false;\" frameborder=\"0\" scrolling=\"no\"></iframe>');this.iefix=$(this.element.id+\"_iefix\")}if(this.iefix){setTimeout(this._fixIEOverlapping.bind(this),50)}},_fixIEOverlapping:function(){Position.clone(this.element,this.iefix);this.iefix.style.zIndex=this.element.style.zIndex-1;this.iefix.show()},_getWindowBorderSize:function(d){var e=this._createHiddenDiv(this.options.className+\"_n\");this.heightN=Element.getDimensions(e).height;e.parentNode.removeChild(e);var e=this._createHiddenDiv(this.options.className+\"_s\");this.heightS=Element.getDimensions(e).height;e.parentNode.removeChild(e);var e=this._createHiddenDiv(this.options.className+\"_e\");this.widthE=Element.getDimensions(e).width;e.parentNode.removeChild(e);var e=this._createHiddenDiv(this.options.className+\"_w\");this.widthW=Element.getDimensions(e).width;e.parentNode.removeChild(e);var e=document.createElement(\"div\");e.className=\"overlay_\"+this.options.className;document.body.appendChild(e);var b=this;setTimeout(function(){b.overlayOpacity=($(e).getStyle(\"opacity\"));e.parentNode.removeChild(e)},10);if(Prototype.Browser.IE){this.heightS=$(this.getId()+\"_row3\").getDimensions().height;this.heightN=$(this.getId()+\"_row1\").getDimensions().height}if(Prototype.Browser.WebKit&&Prototype.Browser.WebKitVersion<420){this.setSize(this.width,this.height)}if(this.doMaximize){this.maximize()}if(this.doMinimize){this.minimize()}},_createHiddenDiv:function(d){var b=document.body;var e=document.createElement(\"div\");e.setAttribute(\"id\",this.element.id+\"_tmp\");e.className=d;e.style.display=\"none\";e.innerHTML=\"\";b.insertBefore(e,b.firstChild);return e},_storeLocation:function(){if(this.storedLocation==null){this.storedLocation={useTop:this.useTop,useLeft:this.useLeft,top:this.element.getStyle(\"top\"),bottom:this.element.getStyle(\"bottom\"),left:this.element.getStyle(\"left\"),right:this.element.getStyle(\"right\"),width:this.width,height:this.height}}},_restoreLocation:function(){if(this.storedLocation!=null){this.useLeft=this.storedLocation.useLeft;this.useTop=this.storedLocation.useTop;if(this.useLeft&&this.useTop&&Window.hasEffectLib&&Effect.ResizeWindow){new Effect.ResizeWindow(this,this.storedLocation.top,this.storedLocation.left,this.storedLocation.width,this.storedLocation.height,{duration:Window.resizeEffectDuration})}else{this.element.setStyle(this.useLeft?{left:this.storedLocation.left}:{right:this.storedLocation.right});this.element.setStyle(this.useTop?{top:this.storedLocation.top}:{bottom:this.storedLocation.bottom});this.setSize(this.storedLocation.width,this.storedLocation.height)}Windows.resetOverflow();this._removeStoreLocation()}},_removeStoreLocation:function(){this.storedLocation=null},_saveCookie:function(){if(this.cookie){var b=\"\";if(this.useLeft){b+=\"l:\"+(this.storedLocation?this.storedLocation.left:this.element.getStyle(\"left\"))}else{b+=\"r:\"+(this.storedLocation?this.storedLocation.right:this.element.getStyle(\"right\"))}if(this.useTop){b+=\",t:\"+(this.storedLocation?this.storedLocation.top:this.element.getStyle(\"top\"))}else{b+=\",b:\"+(this.storedLocation?this.storedLocation.bottom:this.element.getStyle(\"bottom\"))}b+=\",\"+(this.storedLocation?this.storedLocation.width:this.width);b+=\",\"+(this.storedLocation?this.storedLocation.height:this.height);b+=\",\"+this.isMinimized();b+=\",\"+this.isMaximized();WindowUtilities.setCookie(b,this.cookie)}},_createWiredElement:function(){if(!this.wiredElement){if(Prototype.Browser.IE){this._getWindowBorderSize()}var d=document.createElement(\"div\");d.className=\"wired_frame \"+this.options.className+\"_wired_frame\";d.style.position=\"absolute\";this.options.parent.insertBefore(d,this.options.parent.firstChild);this.wiredElement=$(d)}if(this.useLeft){this.wiredElement.setStyle({left:this.element.getStyle(\"left\")})}else{this.wiredElement.setStyle({right:this.element.getStyle(\"right\")})}if(this.useTop){this.wiredElement.setStyle({top:this.element.getStyle(\"top\")})}else{this.wiredElement.setStyle({bottom:this.element.getStyle(\"bottom\")})}var b=this.element.getDimensions();this.wiredElement.setStyle({width:b.width+\"px\",height:b.height+\"px\"});this.wiredElement.setStyle({zIndex:Windows.maxZIndex+30});return this.wiredElement},_hideWiredElement:function(){if(!this.wiredElement||!this.currentDrag){return}if(this.currentDrag==this.element){this.currentDrag=null}else{if(this.useLeft){this.element.setStyle({left:this.currentDrag.getStyle(\"left\")})}else{this.element.setStyle({right:this.currentDrag.getStyle(\"right\")})}if(this.useTop){this.element.setStyle({top:this.currentDrag.getStyle(\"top\")})}else{this.element.setStyle({bottom:this.currentDrag.getStyle(\"bottom\")})}this.currentDrag.hide();this.currentDrag=null;if(this.doResize){this.setSize(this.width,this.height)}}},_notify:function(b){if(this.options[b]){this.options[b](this)}else{Windows.notify(b,this)}}};var Windows={windows:[],modalWindows:[],observers:[],focusedWindow:null,maxZIndex:0,overlayShowEffectOptions:{duration:0.5},overlayHideEffectOptions:{duration:0.5},addObserver:function(b){this.removeObserver(b);this.observers.push(b)},removeObserver:function(b){this.observers=this.observers.reject(function(d){return d==b})},notify:function(b,d){this.observers.each(function(e){if(e[b]){e[b](b,d)}})},getWindow:function(b){return this.windows.detect(function(e){return e.getId()==b})},getFocusedWindow:function(){return this.focusedWindow},updateFocusedWindow:function(){this.focusedWindow=this.windows.length>=2?this.windows[this.windows.length-2]:null},addModalWindow:function(b){if(this.modalWindows.length==0){WindowUtilities.disableScreen(b.options.className,\"overlay_modal\",b.overlayOpacity,b.getId(),b.options.parent)}else{if(Window.keepMultiModalWindow){$(\"overlay_modal\").style.zIndex=Windows.maxZIndex+1;Windows.maxZIndex+=1;WindowUtilities._hideSelect(this.modalWindows.last().getId())}else{this.modalWindows.last().element.hide()}WindowUtilities._showSelect(b.getId())}this.modalWindows.push(b)},removeModalWindow:function(b){this.modalWindows.pop();if(this.modalWindows.length==0){WindowUtilities.enableScreen()}else{if(Window.keepMultiModalWindow){this.modalWindows.last().toFront();WindowUtilities._showSelect(this.modalWindows.last().getId())}else{this.modalWindows.last().element.show()}}},register:function(b){this.windows.push(b)},unregister:function(b){this.windows=this.windows.reject(function(e){return e==b})},closeAll:function(){this.windows.each(function(b){Windows.close(b.getId())})},closeAllModalWindows:function(){WindowUtilities.enableScreen();this.modalWindows.each(function(b){if(b){b.close()}})},minimize:function(e,b){var d=this.getWindow(e);if(d&&d.visible){d.minimize()}Event.stop(b)},maximize:function(e,b){var d=this.getWindow(e);if(d&&d.visible){d.maximize()}Event.stop(b)},close:function(e,b){var d=this.getWindow(e);if(d){d.close()}if(b){Event.stop(b)}},blur:function(d){var b=this.getWindow(d);if(!b){return}if(b.options.blurClassName){b.changeClassName(b.options.blurClassName)}if(this.focusedWindow==b){this.focusedWindow=null}b._notify(\"onBlur\")},focus:function(d){var b=this.getWindow(d);if(!b){return}if(this.focusedWindow){this.blur(this.focusedWindow.getId())}if(b.options.focusClassName){b.changeClassName(b.options.focusClassName)}this.focusedWindow=b;b._notify(\"onFocus\")},unsetOverflow:function(b){this.windows.each(function(e){e.oldOverflow=e.getContent().getStyle(\"overflow\")||\"auto\";e.getContent().setStyle({overflow:\"hidden\"})});if(b&&b.oldOverflow){b.getContent().setStyle({overflow:b.oldOverflow})}},resetOverflow:function(){this.windows.each(function(b){if(b.oldOverflow){b.getContent().setStyle({overflow:b.oldOverflow})}})},updateZindex:function(b,d){if(b>this.maxZIndex){this.maxZIndex=b;if(this.focusedWindow){this.blur(this.focusedWindow.getId())}}this.focusedWindow=d;if(this.focusedWindow){this.focus(this.focusedWindow.getId())}}};var Dialog={dialogId:null,onCompleteFunc:null,callFunc:null,parameters:null,confirm:function(f,e){if(f&&typeof f!=\"string\"){Dialog._runAjaxRequest(f,e,Dialog.confirm);return}f=f||\"\";e=e||{};var h=e.okLabel?e.okLabel:\"Ok\";var b=e.cancelLabel?e.cancelLabel:\"Cancel\";e=Object.extend(e,e.windowParameters||{});e.windowParameters=e.windowParameters||{};e.className=e.className||\"alert\";var d=\"class ='\"+(e.buttonClass?e.buttonClass+\" \":\"\")+\" ok_button'\";var g=\"class ='\"+(e.buttonClass?e.buttonClass+\" \":\"\")+\" cancel_button'\";var f=\"      <div class='\"+e.className+\"_message'>\"+f+\"</div>        <div class='\"+e.className+\"_buttons'>          <input type='button' value='\"+h+\"' onclick='Dialog.okCallback()' \"+d+\"/>          <input type='button' value='\"+b+\"' onclick='Dialog.cancelCallback()' \"+g+\"/>        </div>    \";return this._openDialog(f,e)},alert:function(e,d){if(e&&typeof e!=\"string\"){Dialog._runAjaxRequest(e,d,Dialog.alert);return}e=e||\"\";d=d||{};var f=d.okLabel?d.okLabel:\"Ok\";d=Object.extend(d,d.windowParameters||{});d.windowParameters=d.windowParameters||{};d.className=d.className||\"alert\";var b=\"class ='\"+(d.buttonClass?d.buttonClass+\" \":\"\")+\" ok_button'\";var e=\"      <div class='\"+d.className+\"_message'>\"+e+\"</div>        <div class='\"+d.className+\"_buttons'>          <input type='button' value='\"+f+\"' onclick='Dialog.okCallback()' \"+b+\"/>        </div>\";return this._openDialog(e,d)},info:function(d,b){if(d&&typeof d!=\"string\"){Dialog._runAjaxRequest(d,b,Dialog.info);return}d=d||\"\";b=b||{};b=Object.extend(b,b.windowParameters||{});b.windowParameters=b.windowParameters||{};b.className=b.className||\"alert\";var d=\"<div id='modal_dialog_message' class='\"+b.className+\"_message'>\"+d+\"</div>\";if(b.showProgress){d+=\"<div id='modal_dialog_progress' class='\"+b.className+\"_progress'>  </div>\"}b.ok=null;b.cancel=null;return this._openDialog(d,b)},setInfoMessage:function(b){$(\"modal_dialog_message\").update(b)},closeInfo:function(){Windows.close(this.dialogId)},_openDialog:function(g,f){var e=f.className;if(!f.height&&!f.width){f.width=WindowUtilities.getPageSize((f.options&&f.options.parent)||document.body).pageWidth/2}if(f.id){this.dialogId=f.id}else{var d=new Date();this.dialogId=\"modal_dialog_\"+d.getTime();f.id=this.dialogId}if(!f.height||!f.width){var b=WindowUtilities._computeSize(g,this.dialogId,f.width,f.height,5,e);if(f.height){f.width=b+5}else{f.height=b+5}}f.effectOptions=f.effectOptions;f.resizable=f.resizable||false;f.minimizable=f.minimizable||false;f.maximizable=f.maximizable||false;f.draggable=f.draggable||false;f.closable=f.closable||false;var h=new Window(f);if(!f.url){h.setHTMLContent(g)}h.showCenter(true,f.top,f.left);h.setDestroyOnClose();h.cancelCallback=f.onCancel||f.cancel;h.okCallback=f.onOk||f.ok;return h},_getAjaxContent:function(b){Dialog.callFunc(b.responseText,Dialog.parameters)},_runAjaxRequest:function(e,d,b){if(e.options==null){e.options={}}Dialog.onCompleteFunc=e.options.onComplete;Dialog.parameters=d;Dialog.callFunc=b;e.options.onComplete=Dialog._getAjaxContent;new Ajax.Request(e.url,e.options)},okCallback:function(){var b=Windows.focusedWindow;if(!b.okCallback||b.okCallback(b)){$$(\"#\"+b.getId()+\" input\").each(function(d){d.onclick=null});b.close()}},cancelCallback:function(){var b=Windows.focusedWindow;$$(\"#\"+b.getId()+\" input\").each(function(d){d.onclick=null});b.close();if(b.cancelCallback){b.cancelCallback(b)}}};if(Prototype.Browser.WebKit){var array=navigator.userAgent.match(new RegExp(/AppleWebKit\\/([\\d\\.\\+]*)/));Prototype.Browser.WebKitVersion=parseFloat(array[1])}var WindowUtilities={getWindowScroll:function(parent){var T,L,W,H;parent=parent||document.body;if(parent!=document.body){T=parent.scrollTop;L=parent.scrollLeft;W=parent.scrollWidth;H=parent.scrollHeight}else{var w=window;with(w.document){if(w.document.documentElement&&documentElement.scrollTop){T=documentElement.scrollTop;L=documentElement.scrollLeft}else{if(w.document.body){T=body.scrollTop;L=body.scrollLeft}}if(w.innerWidth){W=w.innerWidth;H=w.innerHeight}else{if(w.document.documentElement&&documentElement.clientWidth){W=documentElement.clientWidth;H=documentElement.clientHeight}else{W=body.offsetWidth;H=body.offsetHeight}}}}return{top:T,left:L,width:W,height:H}},getPageSize:function(f){f=f||document.body;var e,l;var g,d;if(f!=document.body){e=f.getWidth();l=f.getHeight();d=f.scrollWidth;g=f.scrollHeight}else{var h,b;if(window.innerHeight&&window.scrollMaxY){h=document.body.scrollWidth;b=window.innerHeight+window.scrollMaxY}else{if(document.body.scrollHeight>document.body.offsetHeight){h=document.body.scrollWidth;b=document.body.scrollHeight}else{h=document.body.offsetWidth;b=document.body.offsetHeight}}if(self.innerHeight){e=self.innerWidth;l=self.innerHeight}else{if(document.documentElement&&document.documentElement.clientHeight){e=document.documentElement.clientWidth;l=document.documentElement.clientHeight}else{if(document.body){e=document.body.clientWidth;l=document.body.clientHeight}}}if(b<l){g=l}else{g=b}if(h<e){d=e}else{d=h}}return{pageWidth:d,pageHeight:g,windowWidth:e,windowHeight:l}},disableScreen:function(e,b,f,g,d){WindowUtilities.initLightbox(b,e,function(){this._disableScreen(e,b,f,g)}.bind(this),d||document.body)},_disableScreen:function(e,d,g,h){var f=$(d);var b=WindowUtilities.getPageSize(f.parentNode);if(h&&Prototype.Browser.IE){WindowUtilities._hideSelect();WindowUtilities._showSelect(h)}f.style.height=(b.pageHeight+\"px\");f.style.display=\"none\";if(d==\"overlay_modal\"&&Window.hasEffectLib&&Windows.overlayShowEffectOptions){f.overlayOpacity=g;new Effect.Appear(f,Object.extend({from:0,to:g},Windows.overlayShowEffectOptions))}else{f.style.display=\"block\"}},enableScreen:function(d){d=d||\"overlay_modal\";var b=$(d);if(b){if(d==\"overlay_modal\"&&Window.hasEffectLib&&Windows.overlayHideEffectOptions){new Effect.Fade(b,Object.extend({from:b.overlayOpacity,to:0},Windows.overlayHideEffectOptions))}else{b.style.display=\"none\";b.parentNode.removeChild(b)}if(d!=\"__invisible__\"){WindowUtilities._showSelect()}}},_hideSelect:function(b){if(Prototype.Browser.IE){b=b==null?\"\":\"#\"+b+\" \";$$(b+\"select\").each(function(d){if(!WindowUtilities.isDefined(d.oldVisibility)){d.oldVisibility=d.style.visibility?d.style.visibility:\"visible\";d.style.visibility=\"hidden\"}})}},_showSelect:function(b){if(Prototype.Browser.IE){b=b==null?\"\":\"#\"+b+\" \";$$(b+\"select\").each(function(d){if(WindowUtilities.isDefined(d.oldVisibility)){try{d.style.visibility=d.oldVisibility}catch(f){d.style.visibility=\"visible\"}d.oldVisibility=null}else{if(d.style.visibility){d.style.visibility=\"visible\"}}})}},isDefined:function(b){return typeof(b)!=\"undefined\"&&b!=null},initLightbox:function(g,e,b,d){if($(g)){Element.setStyle(g,{zIndex:Windows.maxZIndex+1});Windows.maxZIndex++;b()}else{var f=document.createElement(\"div\");f.setAttribute(\"id\",g);f.className=\"overlay_\"+e;f.style.display=\"none\";f.style.position=\"absolute\";f.style.top=\"0\";f.style.left=\"0\";f.style.zIndex=Windows.maxZIndex+1;Windows.maxZIndex++;f.style.width=\"100%\";d.insertBefore(f,d.firstChild);if(Prototype.Browser.WebKit&&g==\"overlay_modal\"){setTimeout(function(){b()},10)}else{b()}}},setCookie:function(d,b){document.cookie=b[0]+\"=\"+escape(d)+((b[1])?\"; expires=\"+b[1].toGMTString():\"\")+((b[2])?\"; path=\"+b[2]:\"\")+((b[3])?\"; domain=\"+b[3]:\"\")+((b[4])?\"; secure\":\"\")},getCookie:function(e){var d=document.cookie;var g=e+\"=\";var f=d.indexOf(\"; \"+g);if(f==-1){f=d.indexOf(g);if(f!=0){return null}}else{f+=2}var b=document.cookie.indexOf(\";\",f);if(b==-1){b=d.length}return unescape(d.substring(f+g.length,b))},_computeSize:function(g,b,d,l,f,h){var o=document.body;var e=document.createElement(\"div\");e.setAttribute(\"id\",b);e.className=h+\"_content\";if(l){e.style.height=l+\"px\"}else{e.style.width=d+\"px\"}e.style.position=\"absolute\";e.style.top=\"0\";e.style.left=\"0\";e.style.display=\"none\";e.innerHTML=g.stripScripts();o.insertBefore(e,o.firstChild);var n;if(l){n=$(e).getDimensions().width+f}else{n=$(e).getDimensions().height+f}o.removeChild(e);return n}};var Builder={NODEMAP:{AREA:\"map\",CAPTION:\"table\",COL:\"table\",COLGROUP:\"table\",LEGEND:\"fieldset\",OPTGROUP:\"select\",OPTION:\"select\",PARAM:\"object\",TBODY:\"table\",TD:\"table\",TFOOT:\"table\",TH:\"table\",THEAD:\"table\",TR:\"table\"},node:function(b){b=b.toUpperCase();var l=this.NODEMAP[b]||\"div\";var d=document.createElement(l);try{d.innerHTML=\"<\"+b+\"></\"+b+\">\"}catch(h){}var g=d.firstChild||null;if(g&&(g.tagName.toUpperCase()!=b)){g=g.getElementsByTagName(b)[0]}if(!g){g=document.createElement(b)}if(!g){return}if(arguments[1]){if(this._isStringOrNumber(arguments[1])||(arguments[1] instanceof Array)||arguments[1].tagName){this._children(g,arguments[1])}else{var f=this._attributes(arguments[1]);if(f.length){try{d.innerHTML=\"<\"+b+\" \"+f+\"></\"+b+\">\"}catch(h){}g=d.firstChild||null;if(!g){g=document.createElement(b);for(attr in arguments[1]){g[attr==\"class\"?\"className\":attr]=arguments[1][attr]}}if(g.tagName.toUpperCase()!=b){g=d.getElementsByTagName(b)[0]}}}}if(arguments[2]){this._children(g,arguments[2])}return $(g)},_text:function(b){return document.createTextNode(b)},ATTR_MAP:{className:\"class\",htmlFor:\"for\"},_attributes:function(b){var d=[];for(attribute in b){d.push((attribute in this.ATTR_MAP?this.ATTR_MAP[attribute]:attribute)+'=\"'+b[attribute].toString().escapeHTML().gsub(/\"/,\"&quot;\")+'\"')}return d.join(\" \")},_children:function(d,b){if(b.tagName){d.appendChild(b);return}if(typeof b==\"object\"){b.flatten().each(function(f){if(typeof f==\"object\"){d.appendChild(f)}else{if(Builder._isStringOrNumber(f)){d.appendChild(Builder._text(f))}}})}else{if(Builder._isStringOrNumber(b)){d.appendChild(Builder._text(b))}}},_isStringOrNumber:function(b){return(typeof b==\"string\"||typeof b==\"number\")},build:function(d){var b=this.node(\"div\");$(b).update(d.strip());return b.down()},dump:function(d){if(typeof d!=\"object\"&&typeof d!=\"function\"){d=window}var b=(\"A ABBR ACRONYM ADDRESS APPLET AREA B BASE BASEFONT BDO BIG BLOCKQUOTE BODY BR BUTTON CAPTION CENTER CITE CODE COL COLGROUP DD DEL DFN DIR DIV DL DT EM FIELDSET FONT FORM FRAME FRAMESET H1 H2 H3 H4 H5 H6 HEAD HR HTML I IFRAME IMG INPUT INS ISINDEX KBD LABEL LEGEND LI LINK MAP MENU META NOFRAMES NOSCRIPT OBJECT OL OPTGROUP OPTION P PARAM PRE Q S SAMP SCRIPT SELECT SMALL SPAN STRIKE STRONG STYLE SUB SUP TABLE TBODY TD TEXTAREA TFOOT TH THEAD TITLE TR TT U UL VAR\").split(/\\s+/);b.each(function(e){d[e]=function(){return Builder.node.apply(Builder,[e].concat($A(arguments)))}})}};String.prototype.parseColor=function(){var b=\"#\";if(this.slice(0,4)==\"rgb(\"){var e=this.slice(4,this.length-1).split(\",\");var d=0;do{b+=parseInt(e[d]).toColorPart()}while(++d<3)}else{if(this.slice(0,1)==\"#\"){if(this.length==4){for(var d=1;d<4;d++){b+=(this.charAt(d)+this.charAt(d)).toLowerCase()}}if(this.length==7){b=this.toLowerCase()}}}return(b.length==7?b:(arguments[0]||this))};Element.collectTextNodes=function(b){return $A($(b).childNodes).collect(function(d){return(d.nodeType==3?d.nodeValue:(d.hasChildNodes()?Element.collectTextNodes(d):\"\"))}).flatten().join(\"\")};Element.collectTextNodesIgnoreClass=function(b,d){return $A($(b).childNodes).collect(function(e){return(e.nodeType==3?e.nodeValue:((e.hasChildNodes()&&!Element.hasClassName(e,d))?Element.collectTextNodesIgnoreClass(e,d):\"\"))}).flatten().join(\"\")};Element.setContentZoom=function(b,d){b=$(b);b.setStyle({fontSize:(d/100)+\"em\"});if(Prototype.Browser.WebKit){window.scrollBy(0,0)}return b};Element.getInlineOpacity=function(b){return $(b).style.opacity||\"\"};Element.forceRerendering=function(b){try{b=$(b);var f=document.createTextNode(\" \");b.appendChild(f);b.removeChild(f)}catch(d){}};var Effect={_elementDoesNotExistError:{name:\"ElementDoesNotExistError\",message:\"The specified DOM element does not exist, but is required for this effect to operate\"},Transitions:{linear:Prototype.K,sinoidal:function(b){return(-Math.cos(b*Math.PI)/2)+0.5},reverse:function(b){return 1-b},flicker:function(b){var b=((-Math.cos(b*Math.PI)/4)+0.75)+Math.random()/4;return b>1?1:b},wobble:function(b){return(-Math.cos(b*Math.PI*(9*b))/2)+0.5},pulse:function(d,b){return(-Math.cos((d*((b||5)-0.5)*2)*Math.PI)/2)+0.5},spring:function(b){return 1-(Math.cos(b*4.5*Math.PI)*Math.exp(-b*6))},none:function(b){return 0},full:function(b){return 1}},DefaultOptions:{duration:1,fps:100,sync:false,from:0,to:1,delay:0,queue:\"parallel\"},tagifyText:function(b){var d=\"position:relative\";if(Prototype.Browser.IE){d+=\";zoom:1\"}b=$(b);$A(b.childNodes).each(function(e){if(e.nodeType==3){e.nodeValue.toArray().each(function(f){b.insertBefore(new Element(\"span\",{style:d}).update(f==\" \"?String.fromCharCode(160):f),e)});Element.remove(e)}})},multiple:function(d,e){var g;if(((typeof d==\"object\")||Object.isFunction(d))&&(d.length)){g=d}else{g=$(d).childNodes}var b=Object.extend({speed:0.1,delay:0},arguments[2]||{});var f=b.delay;$A(g).each(function(l,h){new e(l,Object.extend(b,{delay:h*b.speed+f}))})},PAIRS:{slide:[\"SlideDown\",\"SlideUp\"],blind:[\"BlindDown\",\"BlindUp\"],appear:[\"Appear\",\"Fade\"]},toggle:function(d,e,b){d=$(d);e=(e||\"appear\").toLowerCase();return Effect[Effect.PAIRS[e][d.visible()?1:0]](d,Object.extend({queue:{position:\"end\",scope:(d.id||\"global\"),limit:1}},b||{}))}};Effect.DefaultOptions.transition=Effect.Transitions.sinoidal;Effect.ScopedQueue=Class.create(Enumerable,{initialize:function(){this.effects=[];this.interval=null},_each:function(b){this.effects._each(b)},add:function(d){var e=new Date().getTime();var b=Object.isString(d.options.queue)?d.options.queue:d.options.queue.position;switch(b){case\"front\":this.effects.findAll(function(f){return f.state==\"idle\"}).each(function(f){f.startOn+=d.finishOn;f.finishOn+=d.finishOn});break;case\"with-last\":e=this.effects.pluck(\"startOn\").max()||e;break;case\"end\":e=this.effects.pluck(\"finishOn\").max()||e;break}d.startOn+=e;d.finishOn+=e;if(!d.options.queue.limit||(this.effects.length<d.options.queue.limit)){this.effects.push(d)}if(!this.interval){this.interval=setInterval(this.loop.bind(this),15)}},remove:function(b){this.effects=this.effects.reject(function(d){return d==b});if(this.effects.length==0){clearInterval(this.interval);this.interval=null}},loop:function(){var e=new Date().getTime();for(var d=0,b=this.effects.length;d<b;d++){this.effects[d]&&this.effects[d].loop(e)}}});Effect.Queues={instances:$H(),get:function(b){if(!Object.isString(b)){return b}return this.instances.get(b)||this.instances.set(b,new Effect.ScopedQueue())}};Effect.Queue=Effect.Queues.get(\"global\");Effect.Base=Class.create({position:null,start:function(b){if(b&&b.transition===false){b.transition=Effect.Transitions.linear}this.options=Object.extend(Object.extend({},Effect.DefaultOptions),b||{});this.currentFrame=0;this.state=\"idle\";this.startOn=this.options.delay*1000;this.finishOn=this.startOn+(this.options.duration*1000);this.fromToDelta=this.options.to-this.options.from;this.totalTime=this.finishOn-this.startOn;this.totalFrames=this.options.fps*this.options.duration;this.render=(function(){function d(f,e){if(f.options[e+\"Internal\"]){f.options[e+\"Internal\"](f)}if(f.options[e]){f.options[e](f)}}return function(e){if(this.state===\"idle\"){this.state=\"running\";d(this,\"beforeSetup\");if(this.setup){this.setup()}d(this,\"afterSetup\")}if(this.state===\"running\"){e=(this.options.transition(e)*this.fromToDelta)+this.options.from;this.position=e;d(this,\"beforeUpdate\");if(this.update){this.update(e)}d(this,\"afterUpdate\")}}})();this.event(\"beforeStart\");if(!this.options.sync){Effect.Queues.get(Object.isString(this.options.queue)?\"global\":this.options.queue.scope).add(this)}},loop:function(e){if(e>=this.startOn){if(e>=this.finishOn){this.render(1);this.cancel();this.event(\"beforeFinish\");if(this.finish){this.finish()}this.event(\"afterFinish\");return}var d=(e-this.startOn)/this.totalTime,b=(d*this.totalFrames).round();if(b>this.currentFrame){this.render(d);this.currentFrame=b}}},cancel:function(){if(!this.options.sync){Effect.Queues.get(Object.isString(this.options.queue)?\"global\":this.options.queue.scope).remove(this)}this.state=\"finished\"},event:function(b){if(this.options[b+\"Internal\"]){this.options[b+\"Internal\"](this)}if(this.options[b]){this.options[b](this)}},inspect:function(){var b=$H();for(property in this){if(!Object.isFunction(this[property])){b.set(property,this[property])}}return\"#<Effect:\"+b.inspect()+\",options:\"+$H(this.options).inspect()+\">\"}});Effect.Parallel=Class.create(Effect.Base,{initialize:function(b){this.effects=b||[];this.start(arguments[1])},update:function(b){this.effects.invoke(\"render\",b)},finish:function(b){this.effects.each(function(d){d.render(1);d.cancel();d.event(\"beforeFinish\");if(d.finish){d.finish(b)}d.event(\"afterFinish\")})}});Effect.Tween=Class.create(Effect.Base,{initialize:function(e,h,g){e=Object.isString(e)?$(e):e;var d=$A(arguments),f=d.last(),b=d.length==5?d[3]:null;this.method=Object.isFunction(f)?f.bind(e):Object.isFunction(e[f])?e[f].bind(e):function(l){e[f]=l};this.start(Object.extend({from:h,to:g},b||{}))},update:function(b){this.method(b)}});Effect.Event=Class.create(Effect.Base,{initialize:function(){this.start(Object.extend({duration:0},arguments[0]||{}))},update:Prototype.emptyFunction});Effect.Opacity=Class.create(Effect.Base,{initialize:function(d){this.element=$(d);if(!this.element){throw (Effect._elementDoesNotExistError)}if(Prototype.Browser.IE&&(!this.element.currentStyle.hasLayout)){this.element.setStyle({zoom:1})}var b=Object.extend({from:this.element.getOpacity()||0,to:1},arguments[1]||{});this.start(b)},update:function(b){this.element.setOpacity(b)}});Effect.Move=Class.create(Effect.Base,{initialize:function(d){this.element=$(d);if(!this.element){throw (Effect._elementDoesNotExistError)}var b=Object.extend({x:0,y:0,mode:\"relative\"},arguments[1]||{});this.start(b)},setup:function(){this.element.makePositioned();this.originalLeft=parseFloat(this.element.getStyle(\"left\")||\"0\");this.originalTop=parseFloat(this.element.getStyle(\"top\")||\"0\");if(this.options.mode==\"absolute\"){this.options.x=this.options.x-this.originalLeft;this.options.y=this.options.y-this.originalTop}},update:function(b){this.element.setStyle({left:(this.options.x*b+this.originalLeft).round()+\"px\",top:(this.options.y*b+this.originalTop).round()+\"px\"})}});Effect.MoveBy=function(d,b,e){return new Effect.Move(d,Object.extend({x:e,y:b},arguments[3]||{}))};Effect.Scale=Class.create(Effect.Base,{initialize:function(d,e){this.element=$(d);if(!this.element){throw (Effect._elementDoesNotExistError)}var b=Object.extend({scaleX:true,scaleY:true,scaleContent:true,scaleFromCenter:false,scaleMode:\"box\",scaleFrom:100,scaleTo:e},arguments[2]||{});this.start(b)},setup:function(){this.restoreAfterFinish=this.options.restoreAfterFinish||false;this.elementPositioning=this.element.getStyle(\"position\");this.originalStyle={};[\"top\",\"left\",\"width\",\"height\",\"fontSize\"].each(function(d){this.originalStyle[d]=this.element.style[d]}.bind(this));this.originalTop=this.element.offsetTop;this.originalLeft=this.element.offsetLeft;var b=this.element.getStyle(\"font-size\")||\"100%\";[\"em\",\"px\",\"%\",\"pt\"].each(function(d){if(b.indexOf(d)>0){this.fontSize=parseFloat(b);this.fontSizeType=d}}.bind(this));this.factor=(this.options.scaleTo-this.options.scaleFrom)/100;this.dims=null;if(this.options.scaleMode==\"box\"){this.dims=[this.element.offsetHeight,this.element.offsetWidth]}if(/^content/.test(this.options.scaleMode)){this.dims=[this.element.scrollHeight,this.element.scrollWidth]}if(!this.dims){this.dims=[this.options.scaleMode.originalHeight,this.options.scaleMode.originalWidth]}},update:function(b){var d=(this.options.scaleFrom/100)+(this.factor*b);if(this.options.scaleContent&&this.fontSize){this.element.setStyle({fontSize:this.fontSize*d+this.fontSizeType})}this.setDimensions(this.dims[0]*d,this.dims[1]*d)},finish:function(b){if(this.restoreAfterFinish){this.element.setStyle(this.originalStyle)}},setDimensions:function(b,g){var h={};if(this.options.scaleX){h.width=g.round()+\"px\"}if(this.options.scaleY){h.height=b.round()+\"px\"}if(this.options.scaleFromCenter){var f=(b-this.dims[0])/2;var e=(g-this.dims[1])/2;if(this.elementPositioning==\"absolute\"){if(this.options.scaleY){h.top=this.originalTop-f+\"px\"}if(this.options.scaleX){h.left=this.originalLeft-e+\"px\"}}else{if(this.options.scaleY){h.top=-f+\"px\"}if(this.options.scaleX){h.left=-e+\"px\"}}}this.element.setStyle(h)}});Effect.Highlight=Class.create(Effect.Base,{initialize:function(d){this.element=$(d);if(!this.element){throw (Effect._elementDoesNotExistError)}var b=Object.extend({startcolor:\"#ffff99\"},arguments[1]||{});this.start(b)},setup:function(){if(this.element.getStyle(\"display\")==\"none\"){this.cancel();return}this.oldStyle={};if(!this.options.keepBackgroundImage){this.oldStyle.backgroundImage=this.element.getStyle(\"background-image\");this.element.setStyle({backgroundImage:\"none\"})}if(!this.options.endcolor){this.options.endcolor=this.element.getStyle(\"background-color\").parseColor(\"#ffffff\")}if(!this.options.restorecolor){this.options.restorecolor=this.element.getStyle(\"background-color\")}this._base=$R(0,2).map(function(b){return parseInt(this.options.startcolor.slice(b*2+1,b*2+3),16)}.bind(this));this._delta=$R(0,2).map(function(b){return parseInt(this.options.endcolor.slice(b*2+1,b*2+3),16)-this._base[b]}.bind(this))},update:function(b){this.element.setStyle({backgroundColor:$R(0,2).inject(\"#\",function(d,e,f){return d+((this._base[f]+(this._delta[f]*b)).round().toColorPart())}.bind(this))})},finish:function(){this.element.setStyle(Object.extend(this.oldStyle,{backgroundColor:this.options.restorecolor}))}});Effect.ScrollTo=function(e){var d=arguments[1]||{},b=document.viewport.getScrollOffsets(),f=$(e).cumulativeOffset();if(d.offset){f[1]+=d.offset}return new Effect.Tween(null,b.top,f[1],d,function(g){scrollTo(b.left,g.round())})};Effect.Fade=function(e){e=$(e);var b=e.getInlineOpacity();var d=Object.extend({from:e.getOpacity()||1,to:0,afterFinishInternal:function(f){if(f.options.to!=0){return}f.element.hide().setStyle({opacity:b})}},arguments[1]||{});return new Effect.Opacity(e,d)};Effect.Appear=function(d){d=$(d);var b=Object.extend({from:(d.getStyle(\"display\")==\"none\"?0:d.getOpacity()||0),to:1,afterFinishInternal:function(e){e.element.forceRerendering()},beforeSetup:function(e){e.element.setOpacity(e.options.from).show()}},arguments[1]||{});return new Effect.Opacity(d,b)};Effect.Puff=function(d){d=$(d);var b={opacity:d.getInlineOpacity(),position:d.getStyle(\"position\"),top:d.style.top,left:d.style.left,width:d.style.width,height:d.style.height};return new Effect.Parallel([new Effect.Scale(d,200,{sync:true,scaleFromCenter:true,scaleContent:true,restoreAfterFinish:true}),new Effect.Opacity(d,{sync:true,to:0})],Object.extend({duration:1,beforeSetupInternal:function(e){Position.absolutize(e.effects[0].element)},afterFinishInternal:function(e){e.effects[0].element.hide().setStyle(b)}},arguments[1]||{}))};Effect.BlindUp=function(b){b=$(b);b.makeClipping();return new Effect.Scale(b,0,Object.extend({scaleContent:false,scaleX:false,restoreAfterFinish:true,afterFinishInternal:function(d){d.element.hide().undoClipping()}},arguments[1]||{}))};Effect.BlindDown=function(d){d=$(d);var b=d.getDimensions();return new Effect.Scale(d,100,Object.extend({scaleContent:false,scaleX:false,scaleFrom:0,scaleMode:{originalHeight:b.height,originalWidth:b.width},restoreAfterFinish:true,afterSetup:function(e){e.element.makeClipping().setStyle({height:\"0px\"}).show()},afterFinishInternal:function(e){e.element.undoClipping()}},arguments[1]||{}))};Effect.SwitchOff=function(d){d=$(d);var b=d.getInlineOpacity();return new Effect.Appear(d,Object.extend({duration:0.4,from:0,transition:Effect.Transitions.flicker,afterFinishInternal:function(e){new Effect.Scale(e.element,1,{duration:0.3,scaleFromCenter:true,scaleX:false,scaleContent:false,restoreAfterFinish:true,beforeSetup:function(f){f.element.makePositioned().makeClipping()},afterFinishInternal:function(f){f.element.hide().undoClipping().undoPositioned().setStyle({opacity:b})}})}},arguments[1]||{}))};Effect.DropOut=function(d){d=$(d);var b={top:d.getStyle(\"top\"),left:d.getStyle(\"left\"),opacity:d.getInlineOpacity()};return new Effect.Parallel([new Effect.Move(d,{x:0,y:100,sync:true}),new Effect.Opacity(d,{sync:true,to:0})],Object.extend({duration:0.5,beforeSetup:function(e){e.effects[0].element.makePositioned()},afterFinishInternal:function(e){e.effects[0].element.hide().undoPositioned().setStyle(b)}},arguments[1]||{}))};Effect.Shake=function(f){f=$(f);var d=Object.extend({distance:20,duration:0.5},arguments[1]||{});var g=parseFloat(d.distance);var e=parseFloat(d.duration)/10;var b={top:f.getStyle(\"top\"),left:f.getStyle(\"left\")};return new Effect.Move(f,{x:g,y:0,duration:e,afterFinishInternal:function(h){new Effect.Move(h.element,{x:-g*2,y:0,duration:e*2,afterFinishInternal:function(l){new Effect.Move(l.element,{x:g*2,y:0,duration:e*2,afterFinishInternal:function(n){new Effect.Move(n.element,{x:-g*2,y:0,duration:e*2,afterFinishInternal:function(o){new Effect.Move(o.element,{x:g*2,y:0,duration:e*2,afterFinishInternal:function(p){new Effect.Move(p.element,{x:-g,y:0,duration:e,afterFinishInternal:function(q){q.element.undoPositioned().setStyle(b)}})}})}})}})}})}})};Effect.SlideDown=function(e){e=$(e).cleanWhitespace();var b=e.down().getStyle(\"bottom\");var d=e.getDimensions();return new Effect.Scale(e,100,Object.extend({scaleContent:false,scaleX:false,scaleFrom:window.opera?0:1,scaleMode:{originalHeight:d.height,originalWidth:d.width},restoreAfterFinish:true,afterSetup:function(f){f.element.makePositioned();f.element.down().makePositioned();if(window.opera){f.element.setStyle({top:\"\"})}f.element.makeClipping().setStyle({height:\"0px\"}).show()},afterUpdateInternal:function(f){f.element.down().setStyle({bottom:(f.dims[0]-f.element.clientHeight)+\"px\"})},afterFinishInternal:function(f){f.element.undoClipping().undoPositioned();f.element.down().undoPositioned().setStyle({bottom:b})}},arguments[1]||{}))};Effect.SlideUp=function(e){e=$(e).cleanWhitespace();var b=e.down().getStyle(\"bottom\");var d=e.getDimensions();return new Effect.Scale(e,window.opera?0:1,Object.extend({scaleContent:false,scaleX:false,scaleMode:\"box\",scaleFrom:100,scaleMode:{originalHeight:d.height,originalWidth:d.width},restoreAfterFinish:true,afterSetup:function(f){f.element.makePositioned();f.element.down().makePositioned();if(window.opera){f.element.setStyle({top:\"\"})}f.element.makeClipping().show()},afterUpdateInternal:function(f){f.element.down().setStyle({bottom:(f.dims[0]-f.element.clientHeight)+\"px\"})},afterFinishInternal:function(f){f.element.hide().undoClipping().undoPositioned();f.element.down().undoPositioned().setStyle({bottom:b})}},arguments[1]||{}))};Effect.Squish=function(b){return new Effect.Scale(b,window.opera?1:0,{restoreAfterFinish:true,beforeSetup:function(d){d.element.makeClipping()},afterFinishInternal:function(d){d.element.hide().undoClipping()}})};Effect.Grow=function(e){e=$(e);var d=Object.extend({direction:\"center\",moveTransition:Effect.Transitions.sinoidal,scaleTransition:Effect.Transitions.sinoidal,opacityTransition:Effect.Transitions.full},arguments[1]||{});var b={top:e.style.top,left:e.style.left,height:e.style.height,width:e.style.width,opacity:e.getInlineOpacity()};var l=e.getDimensions();var n,h;var g,f;switch(d.direction){case\"top-left\":n=h=g=f=0;break;case\"top-right\":n=l.width;h=f=0;g=-l.width;break;case\"bottom-left\":n=g=0;h=l.height;f=-l.height;break;case\"bottom-right\":n=l.width;h=l.height;g=-l.width;f=-l.height;break;case\"center\":n=l.width/2;h=l.height/2;g=-l.width/2;f=-l.height/2;break}return new Effect.Move(e,{x:n,y:h,duration:0.01,beforeSetup:function(o){o.element.hide().makeClipping().makePositioned()},afterFinishInternal:function(o){new Effect.Parallel([new Effect.Opacity(o.element,{sync:true,to:1,from:0,transition:d.opacityTransition}),new Effect.Move(o.element,{x:g,y:f,sync:true,transition:d.moveTransition}),new Effect.Scale(o.element,100,{scaleMode:{originalHeight:l.height,originalWidth:l.width},sync:true,scaleFrom:window.opera?1:0,transition:d.scaleTransition,restoreAfterFinish:true})],Object.extend({beforeSetup:function(p){p.effects[0].element.setStyle({height:\"0px\"}).show()},afterFinishInternal:function(p){p.effects[0].element.undoClipping().undoPositioned().setStyle(b)}},d))}})};Effect.Shrink=function(e){e=$(e);var d=Object.extend({direction:\"center\",moveTransition:Effect.Transitions.sinoidal,scaleTransition:Effect.Transitions.sinoidal,opacityTransition:Effect.Transitions.none},arguments[1]||{});var b={top:e.style.top,left:e.style.left,height:e.style.height,width:e.style.width,opacity:e.getInlineOpacity()};var h=e.getDimensions();var g,f;switch(d.direction){case\"top-left\":g=f=0;break;case\"top-right\":g=h.width;f=0;break;case\"bottom-left\":g=0;f=h.height;break;case\"bottom-right\":g=h.width;f=h.height;break;case\"center\":g=h.width/2;f=h.height/2;break}return new Effect.Parallel([new Effect.Opacity(e,{sync:true,to:0,from:1,transition:d.opacityTransition}),new Effect.Scale(e,window.opera?1:0,{sync:true,transition:d.scaleTransition,restoreAfterFinish:true}),new Effect.Move(e,{x:g,y:f,sync:true,transition:d.moveTransition})],Object.extend({beforeStartInternal:function(l){l.effects[0].element.makePositioned().makeClipping()},afterFinishInternal:function(l){l.effects[0].element.hide().undoClipping().undoPositioned().setStyle(b)}},d))};Effect.Pulsate=function(e){e=$(e);var d=arguments[1]||{},b=e.getInlineOpacity(),g=d.transition||Effect.Transitions.linear,f=function(h){return 1-g((-Math.cos((h*(d.pulses||5)*2)*Math.PI)/2)+0.5)};return new Effect.Opacity(e,Object.extend(Object.extend({duration:2,from:0,afterFinishInternal:function(h){h.element.setStyle({opacity:b})}},d),{transition:f}))};Effect.Fold=function(d){d=$(d);var b={top:d.style.top,left:d.style.left,width:d.style.width,height:d.style.height};d.makeClipping();return new Effect.Scale(d,5,Object.extend({scaleContent:false,scaleX:false,afterFinishInternal:function(e){new Effect.Scale(d,1,{scaleContent:false,scaleY:false,afterFinishInternal:function(f){f.element.hide().undoClipping().setStyle(b)}})}},arguments[1]||{}))};Effect.Morph=Class.create(Effect.Base,{initialize:function(e){this.element=$(e);if(!this.element){throw (Effect._elementDoesNotExistError)}var b=Object.extend({style:{}},arguments[1]||{});if(!Object.isString(b.style)){this.style=$H(b.style)}else{if(b.style.include(\":\")){this.style=b.style.parseStyle()}else{this.element.addClassName(b.style);this.style=$H(this.element.getStyles());this.element.removeClassName(b.style);var d=this.element.getStyles();this.style=this.style.reject(function(f){return f.value==d[f.key]});b.afterFinishInternal=function(f){f.element.addClassName(f.options.style);f.transforms.each(function(g){f.element.style[g.style]=\"\"})}}}this.start(b)},setup:function(){function b(d){if(!d||[\"rgba(0, 0, 0, 0)\",\"transparent\"].include(d)){d=\"#ffffff\"}d=d.parseColor();return $R(0,2).map(function(e){return parseInt(d.slice(e*2+1,e*2+3),16)})}this.transforms=this.style.map(function(l){var h=l[0],g=l[1],f=null;if(g.parseColor(\"#zzzzzz\")!=\"#zzzzzz\"){g=g.parseColor();f=\"color\"}else{if(h==\"opacity\"){g=parseFloat(g);if(Prototype.Browser.IE&&(!this.element.currentStyle.hasLayout)){this.element.setStyle({zoom:1})}}else{if(Element.CSS_LENGTH.test(g)){var e=g.match(/^([\\+\\-]?[0-9\\.]+)(.*)$/);g=parseFloat(e[1]);f=(e.length==3)?e[2]:null}}}var d=this.element.getStyle(h);return{style:h.camelize(),originalValue:f==\"color\"?b(d):parseFloat(d||0),targetValue:f==\"color\"?b(g):g,unit:f}}.bind(this)).reject(function(d){return((d.originalValue==d.targetValue)||(d.unit!=\"color\"&&(isNaN(d.originalValue)||isNaN(d.targetValue))))})},update:function(b){var f={},d,e=this.transforms.length;while(e--){f[(d=this.transforms[e]).style]=d.unit==\"color\"?\"#\"+(Math.round(d.originalValue[0]+(d.targetValue[0]-d.originalValue[0])*b)).toColorPart()+(Math.round(d.originalValue[1]+(d.targetValue[1]-d.originalValue[1])*b)).toColorPart()+(Math.round(d.originalValue[2]+(d.targetValue[2]-d.originalValue[2])*b)).toColorPart():(d.originalValue+(d.targetValue-d.originalValue)*b).toFixed(3)+(d.unit===null?\"\":d.unit)}this.element.setStyle(f,true)}});Effect.Transform=Class.create({initialize:function(b){this.tracks=[];this.options=arguments[1]||{};this.addTracks(b)},addTracks:function(b){b.each(function(d){d=$H(d);var e=d.values().first();this.tracks.push($H({ids:d.keys().first(),effect:Effect.Morph,options:{style:e}}))}.bind(this));return this},play:function(){return new Effect.Parallel(this.tracks.map(function(b){var f=b.get(\"ids\"),e=b.get(\"effect\"),d=b.get(\"options\");var g=[$(f)||$$(f)].flatten();return g.map(function(h){return new e(h,Object.extend({sync:true},d))})}).flatten(),this.options)}});Element.CSS_PROPERTIES=$w(\"backgroundColor backgroundPosition borderBottomColor borderBottomStyle borderBottomWidth borderLeftColor borderLeftStyle borderLeftWidth borderRightColor borderRightStyle borderRightWidth borderSpacing borderTopColor borderTopStyle borderTopWidth bottom clip color fontSize fontWeight height left letterSpacing lineHeight marginBottom marginLeft marginRight marginTop markerOffset maxHeight maxWidth minHeight minWidth opacity outlineColor outlineOffset outlineWidth paddingBottom paddingLeft paddingRight paddingTop right textIndent top width wordSpacing zIndex\");Element.CSS_LENGTH=/^(([\\+\\-]?[0-9\\.]+)(em|ex|px|in|cm|mm|pt|pc|\\%))|0$/;String.__parseStyleElement=document.createElement(\"div\");String.prototype.parseStyle=function(){var d,b=$H();if(Prototype.Browser.WebKit){d=new Element(\"div\",{style:this}).style}else{String.__parseStyleElement.innerHTML='<div style=\"'+this+'\"></div>';d=String.__parseStyleElement.childNodes[0].style}Element.CSS_PROPERTIES.each(function(e){if(d[e]){b.set(e,d[e])}});if(Prototype.Browser.IE&&this.include(\"opacity\")){b.set(\"opacity\",this.match(/opacity:\\s*((?:0|1)?(?:\\.\\d*)?)/)[1])}return b};if(document.defaultView&&document.defaultView.getComputedStyle){Element.getStyles=function(d){var b=document.defaultView.getComputedStyle($(d),null);return Element.CSS_PROPERTIES.inject({},function(e,f){e[f]=b[f];return e})}}else{Element.getStyles=function(d){d=$(d);var b=d.currentStyle,e;e=Element.CSS_PROPERTIES.inject({},function(f,g){f[g]=b[g];return f});if(!e.opacity){e.opacity=d.getOpacity()}return e}}Effect.Methods={morph:function(b,d){b=$(b);new Effect.Morph(b,Object.extend({style:d},arguments[2]||{}));return b},visualEffect:function(e,g,d){e=$(e);var f=g.dasherize().camelize(),b=f.charAt(0).toUpperCase()+f.substring(1);new Effect[b](e,d);return e},highlight:function(d,b){d=$(d);new Effect.Highlight(d,b);return d}};$w(\"fade appear grow shrink fold blindUp blindDown slideUp slideDown pulsate shake puff squish switchOff dropOut\").each(function(b){Effect.Methods[b]=function(e,d){e=$(e);Effect[b.charAt(0).toUpperCase()+b.substring(1)](e,d);return e}});$w(\"getInlineOpacity forceRerendering setContentZoom collectTextNodes collectTextNodesIgnoreClass getStyles\").each(function(b){Effect.Methods[b]=Element[b]});Element.addMethods(Effect.Methods);function validateCreditCard(e){var d=\"0123456789\";var b=\"\";for(i=0;i<e.length;i++){x=e.charAt(i);if(d.indexOf(x,0)!=-1){b+=x}}j=b.length/2;k=Math.floor(j);m=Math.ceil(j)-k;c=0;for(i=0;i<k;i++){a=b.charAt(i*2+m)*2;c+=a>9?Math.floor(a/10+a%10):a}for(i=0;i<k+m;i++){c+=b.charAt(i*2+1-m)*1}return(c%10==0)}var Validator=Class.create();Validator.prototype={initialize:function(e,d,f,b){if(typeof f==\"function\"){this.options=$H(b);this._test=f}else{this.options=$H(f);this._test=function(){return true}}this.error=d||\"Validation failed.\";this.className=e},test:function(b,d){return(this._test(b,d)&&this.options.all(function(e){return Validator.methods[e.key]?Validator.methods[e.key](b,d,e.value):true}))}};Validator.methods={pattern:function(b,e,d){return Validation.get(\"IsEmpty\").test(b)||d.test(b)},minLength:function(b,e,d){return b.length>=d},maxLength:function(b,e,d){return b.length<=d},min:function(b,e,d){return b>=parseFloat(d)},max:function(b,e,d){return b<=parseFloat(d)},notOneOf:function(b,e,d){return $A(d).all(function(f){return b!=f})},oneOf:function(b,e,d){return $A(d).any(function(f){return b==f})},is:function(b,e,d){return b==d},isNot:function(b,e,d){return b!=d},equalToField:function(b,e,d){return b==$F(d)},notEqualToField:function(b,e,d){return b!=$F(d)},include:function(b,e,d){return $A(d).all(function(f){return Validation.get(f).test(b,e)})}};var Validation=Class.create();Validation.defaultOptions={onSubmit:true,stopOnFirst:false,immediate:false,focusOnError:true,useTitles:false,addClassNameToContainer:false,containerClassName:\".input-box\",onFormValidate:function(b,d){},onElementValidate:function(b,d){}};Validation.prototype={initialize:function(d,b){this.form=$(d);if(!this.form){return}this.options=Object.extend({onSubmit:Validation.defaultOptions.onSubmit,stopOnFirst:Validation.defaultOptions.stopOnFirst,immediate:Validation.defaultOptions.immediate,focusOnError:Validation.defaultOptions.focusOnError,useTitles:Validation.defaultOptions.useTitles,onFormValidate:Validation.defaultOptions.onFormValidate,onElementValidate:Validation.defaultOptions.onElementValidate},b||{});if(this.options.onSubmit){Event.observe(this.form,\"submit\",this.onSubmit.bind(this),false)}if(this.options.immediate){Form.getElements(this.form).each(function(e){if(e.tagName.toLowerCase()==\"select\"){Event.observe(e,\"blur\",this.onChange.bindAsEventListener(this))}if(e.type.toLowerCase()==\"radio\"||e.type.toLowerCase()==\"checkbox\"){Event.observe(e,\"click\",this.onChange.bindAsEventListener(this))}else{Event.observe(e,\"change\",this.onChange.bindAsEventListener(this))}},this)}},onChange:function(b){Validation.isOnChange=true;Validation.validate(Event.element(b),{useTitle:this.options.useTitles,onElementValidate:this.options.onElementValidate});Validation.isOnChange=false},onSubmit:function(b){if(!this.validate()){Event.stop(b)}},validate:function(){var b=false;var d=this.options.useTitles;var g=this.options.onElementValidate;try{if(this.options.stopOnFirst){b=Form.getElements(this.form).all(function(e){if(e.hasClassName(\"local-validation\")&&!this.isElementInForm(e,this.form)){return true}return Validation.validate(e,{useTitle:d,onElementValidate:g})},this)}else{b=Form.getElements(this.form).collect(function(e){if(e.hasClassName(\"local-validation\")&&!this.isElementInForm(e,this.form)){return true}if(e.hasClassName(\"validation-disabled\")){return true}return Validation.validate(e,{useTitle:d,onElementValidate:g})},this).all()}}catch(f){}if(!b&&this.options.focusOnError){try{Form.getElements(this.form).findAll(function(e){return $(e).hasClassName(\"validation-failed\")}).first().focus()}catch(f){}}this.options.onFormValidate(b,this.form);return b},reset:function(){Form.getElements(this.form).each(Validation.reset)},isElementInForm:function(e,d){var b=e.up(\"form\");if(b==d){return true}return false}};Object.extend(Validation,{validate:function(e,b){b=Object.extend({useTitle:false,onElementValidate:function(f,g){}},b||{});e=$(e);var d=$w(e.className);return result=d.all(function(f){var g=Validation.test(f,e,b.useTitle);b.onElementValidate(g,e);return g})},insertAdvice:function(f,d){var b=$(f).up(\".field-row\");if(b){Element.insert(b,{after:d})}else{if(f.up(\"td.value\")){f.up(\"td.value\").insert({bottom:d})}else{if(f.advaiceContainer&&$(f.advaiceContainer)){$(f.advaiceContainer).update(d)}else{switch(f.type.toLowerCase()){case\"checkbox\":case\"radio\":var e=f.parentNode;if(e){Element.insert(e,{bottom:d})}else{Element.insert(f,{after:d})}break;default:Element.insert(f,{after:d})}}}}},showAdvice:function(e,d,b){if(!e.advices){e.advices=new Hash()}else{e.advices.each(function(f){if(!d||f.value.id!=d.id){this.hideAdvice(e,f.value)}}.bind(this))}e.advices.set(b,d);if(typeof Effect==\"undefined\"){d.style.display=\"block\"}else{if(!d._adviceAbsolutize){new Effect.Appear(d,{duration:1})}else{Position.absolutize(d);d.show();d.setStyle({top:d._adviceTop,left:d._adviceLeft,width:d._adviceWidth,\"z-index\":1000});d.addClassName(\"advice-absolute\")}}},hideAdvice:function(d,b){if(b!=null){new Effect.Fade(b,{duration:1,afterFinishInternal:function(){b.hide()}})}},updateCallback:function(elm,status){if(typeof elm.callbackFunction!=\"undefined\"){eval(elm.callbackFunction+\"('\"+elm.id+\"','\"+status+\"')\")}},ajaxError:function(g,f){var e=\"validate-ajax\";var d=Validation.getAdvice(e,g);if(d==null){d=this.createAdvice(e,g,false,f)}this.showAdvice(g,d,\"validate-ajax\");this.updateCallback(g,\"failed\");g.addClassName(\"validation-failed\");g.addClassName(\"validate-ajax\");if(Validation.defaultOptions.addClassNameToContainer&&Validation.defaultOptions.containerClassName!=\"\"){var b=g.up(Validation.defaultOptions.containerClassName);if(b&&this.allowContainerClassName(g)){b.removeClassName(\"validation-passed\");b.addClassName(\"validation-error\")}}},allowContainerClassName:function(b){if(b.type==\"radio\"||b.type==\"checkbox\"){return b.hasClassName(\"change-container-classname\")}return true},test:function(g,o,l){var d=Validation.get(g);var n=\"__advice\"+g.camelize();try{if(Validation.isVisible(o)&&!d.test($F(o),o)){var f=Validation.getAdvice(g,o);if(f==null){f=this.createAdvice(g,o,l)}this.showAdvice(o,f,g);this.updateCallback(o,\"failed\");o[n]=1;if(!o.advaiceContainer){o.removeClassName(\"validation-passed\");o.addClassName(\"validation-failed\")}if(Validation.defaultOptions.addClassNameToContainer&&Validation.defaultOptions.containerClassName!=\"\"){var b=o.up(Validation.defaultOptions.containerClassName);if(b&&this.allowContainerClassName(o)){b.removeClassName(\"validation-passed\");b.addClassName(\"validation-error\")}}return false}else{var f=Validation.getAdvice(g,o);this.hideAdvice(o,f);this.updateCallback(o,\"passed\");o[n]=\"\";o.removeClassName(\"validation-failed\");o.addClassName(\"validation-passed\");if(Validation.defaultOptions.addClassNameToContainer&&Validation.defaultOptions.containerClassName!=\"\"){var b=o.up(Validation.defaultOptions.containerClassName);if(b&&!b.down(\".validation-failed\")&&this.allowContainerClassName(o)){if(!Validation.get(\"IsEmpty\").test(o.value)||!this.isVisible(o)){b.addClassName(\"validation-passed\")}else{b.removeClassName(\"validation-passed\")}b.removeClassName(\"validation-error\")}}return true}}catch(h){throw (h)}},isVisible:function(b){while(b.tagName!=\"BODY\"){if(!$(b).visible()){return false}b=b.parentNode}return true},getAdvice:function(b,d){return $(\"advice-\"+b+\"-\"+Validation.getElmID(d))||$(\"advice-\"+Validation.getElmID(d))},createAdvice:function(e,n,l,d){var b=Validation.get(e);var h=l?((n&&n.title)?n.title:b.error):b.error;if(d){h=d}if(jQuery.mage.__){h=jQuery.mage.__(h)}advice='<div class=\"validation-advice\" id=\"advice-'+e+\"-\"+Validation.getElmID(n)+'\" style=\"display:none\">'+h+\"</div>\";Validation.insertAdvice(n,advice);advice=Validation.getAdvice(e,n);if($(n).hasClassName(\"absolute-advice\")){var g=$(n).getDimensions();var f=Position.cumulativeOffset(n);advice._adviceTop=(f[1]+g.height)+\"px\";advice._adviceLeft=(f[0])+\"px\";advice._adviceWidth=(g.width)+\"px\";advice._adviceAbsolutize=true}return advice},getElmID:function(b){return b.id?b.id:b.name},reset:function(d){d=$(d);var b=$w(d.className);b.each(function(g){var h=\"__advice\"+g.camelize();if(d[h]){var f=Validation.getAdvice(g,d);if(f){f.hide()}d[h]=\"\"}d.removeClassName(\"validation-failed\");d.removeClassName(\"validation-passed\");if(Validation.defaultOptions.addClassNameToContainer&&Validation.defaultOptions.containerClassName!=\"\"){var e=d.up(Validation.defaultOptions.containerClassName);if(e){e.removeClassName(\"validation-passed\");e.removeClassName(\"validation-error\")}}})},add:function(f,e,g,d){var b={};b[f]=new Validator(f,e,g,d);Object.extend(Validation.methods,b)},addAllThese:function(b){var d={};$A(b).each(function(e){d[e[0]]=new Validator(e[0],e[1],e[2],(e.length>3?e[3]:{}))});Object.extend(Validation.methods,d)},get:function(b){return Validation.methods[b]?Validation.methods[b]:Validation.methods._LikeNoIDIEverSaw_},methods:{_LikeNoIDIEverSaw_:new Validator(\"_LikeNoIDIEverSaw_\",\"\",{})}});Validation.add(\"IsEmpty\",\"\",function(b){return(b==\"\"||(b==null)||(b.length==0)||/^\\s+$/.test(b))});Validation.addAllThese([[\"validate-no-html-tags\",\"HTML tags are not allowed\",function(b){return !/<(\\/)?\\w+/.test(b)}],[\"validate-select\",\"Please select an option.\",function(b){return((b!=\"none\")&&(b!=null)&&(b.length!=0))}],[\"required-entry\",\"This is a required field.\",function(b){return !Validation.get(\"IsEmpty\").test(b)}],[\"validate-number\",\"Please enter a valid number in this field.\",function(b){return Validation.get(\"IsEmpty\").test(b)||(!isNaN(parseNumber(b))&&/^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(b))}],[\"validate-number-range\",\"The value is not within the specified range.\",function(e,g){if(Validation.get(\"IsEmpty\").test(e)){return true}var f=parseNumber(e);if(isNaN(f)){return false}var d=/^number-range-(-?[\\d.,]+)?-(-?[\\d.,]+)?$/,b=true;$w(g.className).each(function(l){var h=d.exec(l);if(h){b=b&&(h[1]==null||h[1]==\"\"||f>=parseNumber(h[1]))&&(h[2]==null||h[2]==\"\"||f<=parseNumber(h[2]))}});return b}],[\"validate-digits\",\"Please use numbers only in this field. Please avoid spaces or other characters such as dots or commas.\",function(b){return Validation.get(\"IsEmpty\").test(b)||!/[^\\d]/.test(b)}],[\"validate-digits-range\",\"The value is not within the specified range.\",function(e,g){if(Validation.get(\"IsEmpty\").test(e)){return true}var f=parseNumber(e);if(isNaN(f)){return false}var d=/^digits-range-(-?\\d+)?-(-?\\d+)?$/,b=true;$w(g.className).each(function(l){var h=d.exec(l);if(h){b=b&&(h[1]==null||h[1]==\"\"||f>=parseNumber(h[1]))&&(h[2]==null||h[2]==\"\"||f<=parseNumber(h[2]))}});return b}],[\"validate-range\",\"The value is not within the specified range.\",function(f,l){var g,h;if(Validation.get(\"IsEmpty\").test(f)){return true}else{if(Validation.get(\"validate-digits\").test(f)){g=h=parseNumber(f)}else{var e=/^(-?\\d+)?-(-?\\d+)?$/.exec(f);if(e){g=parseNumber(e[1]);h=parseNumber(e[2]);if(g>h){return false}}else{return false}}}var d=/^range-(-?\\d+)?-(-?\\d+)?$/,b=true;$w(l.className).each(function(n){var q=d.exec(n);if(q){var p=parseNumber(q[1]);var o=parseNumber(q[2]);b=b&&(isNaN(p)||g>=p)&&(isNaN(o)||h<=o)}});return b}],[\"validate-alpha\",\"Please use letters only (a-z or A-Z) in this field.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-zA-Z]+$/.test(b)}],[\"validate-code\",\"Please use only lowercase letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-z]+[a-z0-9_]+$/.test(b)}],[\"validate-alphanum\",\"Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-zA-Z0-9]+$/.test(b)}],[\"validate-alphanum-with-spaces\",\"Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-zA-Z0-9 ]+$/.test(b)}],[\"validate-street\",'Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.',function(b){return Validation.get(\"IsEmpty\").test(b)||/^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(b)}],[\"validate-phoneStrict\",\"Please enter a valid phone number (Ex: 123-456-7890).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(b)}],[\"validate-phoneLax\",\"Please enter a valid phone number (Ex: 123-456-7890).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^((\\d[-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[-. ]?\\d{3}[-. ]?\\d{4}$/.test(b)}],[\"validate-fax\",\"Please enter a valid fax number (Ex: 123-456-7890).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(b)}],[\"validate-date\",\"Please enter a valid date.\",function(b){var d=new Date(b);return Validation.get(\"IsEmpty\").test(b)||!isNaN(d)}],[\"validate-date-range\",\"Make sure the To Date is later than or the same as the From Date.\",function(e,h){var d=/\\bdate-range-(\\w+)-(\\w+)\\b/.exec(h.className);if(!d||d[2]==\"to\"||Validation.get(\"IsEmpty\").test(e)){return true}var f=new Date().getFullYear()+\"\";var b=function(l){l=l.split(/[.\\/]/);if(l[2]&&l[2].length<4){l[2]=f.substr(0,l[2].length)+l[2]}return new Date(l.join(\"/\")).getTime()};var g=Element.select(h.form,\".validate-date-range.date-range-\"+d[1]+\"-to\");return !g.length||Validation.get(\"IsEmpty\").test(g[0].value)||b(e)<=b(g[0].value)}],[\"validate-email\",\"Please enter a valid email address (Ex: johndoe@domain.com).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(b)}],[\"validate-emailSender\",\"Please use only visible characters and spaces.\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[\\S ]+$/.test(b)}],[\"validate-password\",\"Please enter 6 or more characters. Leading and trailing spaces will be ignored.\",function(b){var d=b.strip();return !(d.length>0&&d.length<6)}],[\"validate-admin-password\",\"Please enter 7 or more characters, using both numeric and alphabetic.\",function(b){var d=b.strip();if(0==d.length){return true}if(!(/[a-z]/i.test(b))||!(/[0-9]/.test(b))){return false}return !(d.length<7)}],[\"validate-cpassword\",\"Please make sure your passwords match.\",function(b){var d=$(\"confirmation\")?$(\"confirmation\"):$$(\".validate-cpassword\")[0];var g=false;if($(\"password\")){g=$(\"password\")}var h=$$(\".validate-password\");for(var e=0;e<h.size();e++){var f=h[e];if(f.up(\"form\").id==d.up(\"form\").id){g=f}}if($$(\".validate-admin-password\").size()){g=$$(\".validate-admin-password\")[0]}return(g.value==d.value)}],[\"validate-both-passwords\",\"Please make sure your passwords match.\",function(e,d){var b=$(d.form[d.name==\"password\"?\"confirmation\":\"password\"]),f=d.value==b.value;if(f&&b.hasClassName(\"validation-failed\")){Validation.test(this.className,b)}return b.value==\"\"||f}],[\"validate-url\",\"Please enter a valid URL. Protocol is required (http://, https:// or ftp://)\",function(b){b=(b||\"\").replace(/^\\s+/,\"\").replace(/\\s+$/,\"\");return Validation.get(\"IsEmpty\").test(b)||/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i.test(b)}],[\"validate-clean-url\",'Please enter a valid URL (Ex: \"http://www.example.com\" or \"www.example.com\").',function(b){return Validation.get(\"IsEmpty\").test(b)||/^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(b)||/^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(b)}],[\"validate-identifier\",'Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").',function(b){return Validation.get(\"IsEmpty\").test(b)||/^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(b)}],[\"validate-xml-identifier\",\"Please enter a valid XML-identifier (Ex: something_1, block5, id-4).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^[A-Z][A-Z0-9_\\/-]*$/i.test(b)}],[\"validate-ssn\",\"Please enter a valid social security number (Ex: 123-45-6789).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^\\d{3}-?\\d{2}-?\\d{4}$/.test(b)}],[\"validate-zip-us\",\"Please enter a valid zip code (Ex: 90602 or 90602-1234).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(b)}],[\"validate-zip-international\",\"Please enter a valid zip code.\",function(b){return true}],[\"validate-date-au\",'Please use this date format: dd/mm/yyyy (Ex: \"17/03/2006\" for the 17th of March, 2006).',function(b){if(Validation.get(\"IsEmpty\").test(b)){return true}var e=/^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/;if(!e.test(b)){return false}var f=new Date(b.replace(e,\"$2/$1/$3\"));return(parseInt(RegExp.$2,10)==(1+f.getMonth()))&&(parseInt(RegExp.$1,10)==f.getDate())&&(parseInt(RegExp.$3,10)==f.getFullYear())}],[\"validate-currency-dollar\",\"Please enter a valid $ amount (Ex: $100.00).\",function(b){return Validation.get(\"IsEmpty\").test(b)||/^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(b)}],[\"validate-one-required\",\"Please select one of the options above.\",function(b,f){var e=f.parentNode;var d=e.getElementsByTagName(\"INPUT\");return $A(d).any(function(g){return $F(g)})}],[\"validate-one-required-by-name\",\"Please select one of the options.\",function(d,g){var b=$$('input[name=\"'+g.name.replace(/([\\\\\"])/g,\"\\\\$1\")+'\"]');var e=1;for(var f=0;f<b.length;f++){if((b[f].type==\"checkbox\"||b[f].type==\"radio\")&&b[f].checked==true){e=0}if(Validation.isOnChange&&(b[f].type==\"checkbox\"||b[f].type==\"radio\")){Validation.reset(b[f])}}if(e==0){return true}else{return false}}],[\"validate-not-negative-number\",\"Please enter a number 0 or greater in this field.\",function(b){if(Validation.get(\"IsEmpty\").test(b)){return true}b=parseNumber(b);return !isNaN(b)&&b>=0}],[\"validate-zero-or-greater\",\"Please enter a number 0 or greater in this field.\",function(b){return Validation.get(\"validate-not-negative-number\").test(b)}],[\"validate-greater-than-zero\",\"Please enter a number greater than 0 in this field.\",function(b){if(Validation.get(\"IsEmpty\").test(b)){return true}b=parseNumber(b);return !isNaN(b)&&b>0}],[\"validate-state\",\"Please select State/Province.\",function(b){return(b!=0||b==\"\")}],[\"validate-new-password\",\"Please enter 6 or more characters. Leading and trailing spaces will be ignored.\",function(b){if(!Validation.get(\"validate-password\").test(b)){return false}if(Validation.get(\"IsEmpty\").test(b)&&b!=\"\"){return false}return true}],[\"validate-cc-number\",\"Please enter a valid credit card number.\",function(b,e){var d=$(e.id.substr(0,e.id.indexOf(\"_cc_number\"))+\"_cc_type\");if(d&&typeof Validation.creditCartTypes.get(d.value)!=\"undefined\"&&Validation.creditCartTypes.get(d.value)[2]==false){if(!Validation.get(\"IsEmpty\").test(b)&&Validation.get(\"validate-digits\").test(b)){return true}else{return false}}return validateCreditCard(b)}],[\"validate-cc-type\",\"Credit card number does not match credit card type.\",function(d,g){g.value=removeDelimiters(g.value);d=removeDelimiters(d);var f=$(g.id.substr(0,g.id.indexOf(\"_cc_number\"))+\"_cc_type\");if(!f){return true}var e=f.value;if(typeof Validation.creditCartTypes.get(e)==\"undefined\"){return false}if(Validation.creditCartTypes.get(e)[0]==false){return true}var b=\"\";Validation.creditCartTypes.each(function(h){if(h.value[0]&&d.match(h.value[0])){b=h.key;throw $break}});if(b!=e){return false}if(f.hasClassName(\"validation-failed\")&&Validation.isOnChange){Validation.validate(f)}return true}],[\"validate-cc-type-select\",\"Card type does not match credit card number.\",function(d,e){var b=$(e.id.substr(0,e.id.indexOf(\"_cc_type\"))+\"_cc_number\");if(Validation.isOnChange&&Validation.get(\"IsEmpty\").test(b.value)){return true}if(Validation.get(\"validate-cc-type\").test(b.value,b)){Validation.validate(b)}return Validation.get(\"validate-cc-type\").test(b.value,b)}],[\"validate-cc-exp\",\"Incorrect credit card expiration date.\",function(b,l){var h=b;var g=$(l.id.substr(0,l.id.indexOf(\"_expiration\"))+\"_expiration_yr\").value;var f=new Date();var e=f.getMonth()+1;var d=f.getFullYear();if(h<e&&g==d){return false}return true}],[\"validate-cc-cvn\",\"Please enter a valid credit card verification number.\",function(b,g){var f=$(g.id.substr(0,g.id.indexOf(\"_cc_cid\"))+\"_cc_type\");if(!f){return true}var d=f.value;if(typeof Validation.creditCartTypes.get(d)==\"undefined\"){return false}var e=Validation.creditCartTypes.get(d)[1];if(b.match(e)){return true}return false}],[\"validate-ajax\",\"\",function(b,d){return true}],[\"validate-data\",\"Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.\",function(b){if(b!=\"\"&&b){return/^[A-Za-z]+[A-Za-z0-9_]+$/.test(b)}return true}],[\"validate-css-length\",\"Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).\",function(b){if(b!=\"\"&&b){return/^[0-9\\.]+(px|pt|em|ex|%)?$/.test(b)&&(!(/\\..*\\./.test(b)))&&!(/\\.$/.test(b))}return true}],[\"validate-length\",\"Text length does not meet the specified text range.\",function(d,g){var e=new RegExp(/^maximum-length-[0-9]+$/);var f=new RegExp(/^minimum-length-[0-9]+$/);var b=true;$w(g.className).each(function(l,h){if(l.match(e)&&b){var n=l.split(\"-\")[2];b=(d.length<=n)}if(l.match(f)&&b&&!Validation.get(\"IsEmpty\").test(d)){var n=l.split(\"-\")[2];b=(d.length>=n)}});return b}],[\"validate-percents\",\"Please enter a number lower than 100.\",{max:100}],[\"required-file\",\"Please select a file.\",function(d,e){var b=!Validation.get(\"IsEmpty\").test(d);if(b===false){ovId=e.id+\"_value\";if($(ovId)){b=!Validation.get(\"IsEmpty\").test($(ovId).value)}}return b}],[\"validate-cc-ukss\",\"Please enter issue number or start date for switch/solo card type.\",function(o,g){var b;if(g.id.match(/(.)+_cc_issue$/)){b=g.id.indexOf(\"_cc_issue\")}else{if(g.id.match(/(.)+_start_month$/)){b=g.id.indexOf(\"_start_month\")}else{b=g.id.indexOf(\"_start_year\")}}var f=g.id.substr(0,b);var d=$(f+\"_cc_type\");if(!d){return true}var n=d.value;if([\"SS\",\"SM\",\"SO\"].indexOf(n)==-1){return true}$(f+\"_cc_issue\").advaiceContainer=$(f+\"_start_month\").advaiceContainer=$(f+\"_start_year\").advaiceContainer=$(f+\"_cc_type_ss_div\").down(\".adv-container\");var h=$(f+\"_cc_issue\").value;var l=$(f+\"_start_month\").value;var p=$(f+\"_start_year\").value;var e=(l&&p)?true:false;if(!e&&!h){return false}return true}]]);function removeDelimiters(b){b=b.replace(/\\s/g,\"\");b=b.replace(/\\-/g,\"\");return b}function parseNumber(b){if(typeof b!=\"string\"){return parseFloat(b)}var e=b.indexOf(\".\");var d=b.indexOf(\",\");if(e!=-1&&d!=-1){if(d>e){b=b.replace(\".\",\"\").replace(\",\",\".\")}else{b=b.replace(\",\",\"\")}}else{if(d!=-1){b=b.replace(\",\",\".\")}}return parseFloat(b)}Validation.creditCartTypes=$H({SO:[new RegExp(\"^(6334[5-9]([0-9]{11}|[0-9]{13,14}))|(6767([0-9]{12}|[0-9]{14,15}))$\"),new RegExp(\"^([0-9]{3}|[0-9]{4})?$\"),true],SM:[new RegExp(\"(^(5[0678])[0-9]{11,18}$)|(^(6[^05])[0-9]{11,18}$)|(^(601)[^1][0-9]{9,16}$)|(^(6011)[0-9]{9,11}$)|(^(6011)[0-9]{13,16}$)|(^(65)[0-9]{11,13}$)|(^(65)[0-9]{15,18}$)|(^(49030)[2-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49033)[5-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49110)[1-2]([0-9]{10}$|[0-9]{12,13}$))|(^(49117)[4-9]([0-9]{10}$|[0-9]{12,13}$))|(^(49118)[0-2]([0-9]{10}$|[0-9]{12,13}$))|(^(4936)([0-9]{12}$|[0-9]{14,15}$))\"),new RegExp(\"^([0-9]{3}|[0-9]{4})?$\"),true],VI:[new RegExp(\"^4[0-9]{12}([0-9]{3})?$\"),new RegExp(\"^[0-9]{3}$\"),true],MC:[new RegExp(\"^5[1-5][0-9]{14}$\"),new RegExp(\"^[0-9]{3}$\"),true],AE:[new RegExp(\"^3[47][0-9]{13}$\"),new RegExp(\"^[0-9]{4}$\"),true],DI:[new RegExp(\"^6(011|4[4-9][0-9]|5[0-9]{2})[0-9]{12}$\"),new RegExp(\"^[0-9]{3}$\"),true],JCB:[new RegExp(\"^(3[0-9]{15}|(2131|1800)[0-9]{11})$\"),new RegExp(\"^[0-9]{3,4}$\"),true],OT:[false,new RegExp(\"^([0-9]{3}|[0-9]{4})?$\"),false]});function popWin(d,e,b){var e=window.open(d,e,b);e.focus()}function setLocation(b){window.location.href=b}function setPLocation(d,b){if(b){window.opener.focus()}window.opener.location.href=d}function setLanguageCode(e,f){var b=window.location.href;var h=\"\",g;if(g=b.match(/\\#(.*)$/)){b=b.replace(/\\#(.*)$/,\"\");h=g[0]}if(b.match(/[?]/)){var d=/([?&]store=)[a-z0-9_]*/;if(b.match(d)){b=b.replace(d,\"$1\"+e)}else{b+=\"&store=\"+e}var d=/([?&]from_store=)[a-z0-9_]*/;if(b.match(d)){b=b.replace(d,\"\")}}else{b+=\"?store=\"+e}if(typeof f!=\"undefined\"){b+=\"&from_store=\"+f}b+=h;setLocation(b)}function decorateGeneric(h,e){var l=[\"odd\",\"even\",\"first\",\"last\"];var d={};var g=h.length;if(g){if(typeof e==\"undefined\"){e=l}if(!e.length){return}for(var b in l){d[l[b]]=false}for(var b in e){d[e[b]]=true}if(d.first){Element.addClassName(h[0],\"first\")}if(d.last){Element.addClassName(h[g-1],\"last\")}for(var f=0;f<g;f++){if((f+1)%2==0){if(d.even){Element.addClassName(h[f],\"even\")}}else{if(d.odd){Element.addClassName(h[f],\"odd\")}}}}}function decorateTable(h,e){var h=$(h);if(h){var b={tbody:false,\"tbody tr\":[\"odd\",\"even\",\"first\",\"last\"],\"thead tr\":[\"first\",\"last\"],\"tfoot tr\":[\"first\",\"last\"],\"tr td\":[\"last\"]};if(typeof e!=\"undefined\"){for(var d in e){b[d]=e[d]}}if(b.tbody){decorateGeneric(h.select(\"tbody\"),b.tbody)}if(b[\"tbody tr\"]){decorateGeneric(h.select(\"tbody tr\"),b[\"tbody tr\"])}if(b[\"thead tr\"]){decorateGeneric(h.select(\"thead tr\"),b[\"thead tr\"])}if(b[\"tfoot tr\"]){decorateGeneric(h.select(\"tfoot tr\"),b[\"tfoot tr\"])}if(b[\"tr td\"]){var g=h.select(\"tr\");if(g.length){for(var f=0;f<g.length;f++){decorateGeneric(g[f].getElementsByTagName(\"TD\"),b[\"tr td\"])}}}}}function decorateList(e,d){if($(e)){if(typeof d==\"undefined\"){var b=$(e).select(\"li\")}else{var b=$(e).childElements()}decorateGeneric(b,[\"odd\",\"even\",\"last\"])}}function decorateDataList(b){b=$(b);if(b){decorateGeneric(b.select(\"dt\"),[\"odd\",\"even\",\"last\"]);decorateGeneric(b.select(\"dd\"),[\"odd\",\"even\",\"last\"])}}function parseSidUrl(f,e){var d=f.indexOf(\"/?SID=\");var b=\"\";e=e!=undefined?e:\"\";if(d>-1){b=\"?\"+f.substring(d+2);f=f.substring(0,d+1)}return f+e+b}function formatCurrency(n,q,g){var l=isNaN(q.precision=Math.abs(q.precision))?2:q.precision;var v=isNaN(q.requiredPrecision=Math.abs(q.requiredPrecision))?2:q.requiredPrecision;l=v;var t=isNaN(q.integerRequired=Math.abs(q.integerRequired))?1:q.integerRequired;var p=q.decimalSymbol==undefined?\",\":q.decimalSymbol;var e=q.groupSymbol==undefined?\".\":q.groupSymbol;var d=q.groupLength==undefined?3:q.groupLength;var u=\"\";if(g==undefined||g==true){u=n<0?\"-\":g?\"+\":\"\"}else{if(g==false){u=\"\"}}var h=parseInt(n=Math.abs(+n||0).toFixed(l))+\"\";var f=h.length<t?t-h.length:0;while(f){h=\"0\"+h;f--}j=(j=h.length)>d?j%d:0;re=new RegExp(\"(\\\\d{\"+d+\"})(?=\\\\d)\",\"g\");var b=(j?h.substr(0,j)+e:\"\")+h.substr(j).replace(re,\"$1\"+e)+(l?p+Math.abs(n-h).toFixed(l).replace(/-/,0).slice(2):\"\");var o=\"\";if(q.pattern.indexOf(\"{sign}\")==-1){o=u+q.pattern}else{o=q.pattern.replace(\"{sign}\",u)}return o.replace(\"%s\",b).replace(/^\\s\\s*/,\"\").replace(/\\s\\s*$/,\"\")}function expandDetails(d,b){if(Element.hasClassName(d,\"show-details\")){$$(b).each(function(e){e.hide()});Element.removeClassName(d,\"show-details\")}else{$$(b).each(function(e){e.show()});Element.addClassName(d,\"show-details\")}}var isIE=navigator.appVersion.match(/MSIE/)==\"MSIE\";if(!window.Varien){var Varien=new Object()}Varien.showLoading=function(){var b=$(\"loading-process\");b&&b.show()};Varien.hideLoading=function(){var b=$(\"loading-process\");b&&b.hide()};Varien.GlobalHandlers={onCreate:function(){Varien.showLoading()},onComplete:function(){if(Ajax.activeRequestCount==0){Varien.hideLoading()}}};Ajax.Responders.register(Varien.GlobalHandlers);Varien.searchForm=Class.create();Varien.searchForm.prototype={initialize:function(d,e,b){this.form=$(d);this.field=$(e);this.emptyText=b;Event.observe(this.form,\"submit\",this.submit.bind(this));Event.observe(this.field,\"focus\",this.focus.bind(this));Event.observe(this.field,\"blur\",this.blur.bind(this));this.blur()},submit:function(b){if(this.field.value==this.emptyText||this.field.value==\"\"){Event.stop(b);return false}return true},focus:function(b){if(this.field.value==this.emptyText){this.field.value=\"\"}},blur:function(b){if(this.field.value==\"\"){this.field.value=this.emptyText}}};Varien.DateElement=Class.create();Varien.DateElement.prototype={initialize:function(b,d,f,e){if(b==\"id\"){this.day=$(d+\"day\");this.month=$(d+\"month\");this.year=$(d+\"year\");this.full=$(d+\"full\");this.advice=$(d+\"date-advice\")}else{if(b==\"container\"){this.day=d.day;this.month=d.month;this.year=d.year;this.full=d.full;this.advice=d.advice}else{return}}this.required=f;this.format=e;this.day.addClassName(\"validate-custom\");this.day.validate=this.validate.bind(this);this.month.addClassName(\"validate-custom\");this.month.validate=this.validate.bind(this);this.year.addClassName(\"validate-custom\");this.year.validate=this.validate.bind(this);this.setDateRange(false,false);this.year.setAttribute(\"autocomplete\",\"off\");this.advice.hide()},validate:function(){var l=false,o=parseInt(this.day.value,10)||0,f=parseInt(this.month.value,10)||0,h=parseInt(this.year.value,10)||0;if(this.day.value.strip().empty()&&this.month.value.strip().empty()&&this.year.value.strip().empty()){if(this.required){l=\"Please enter a date.\"}else{this.full.value=\"\"}}else{if(!o||!f||!h){l=\"Please enter a valid full date.\"}else{var d=new Date,n=0,e=null;d.setYear(h);d.setMonth(f-1);d.setDate(32);n=32-d.getDate();if(!n||n>31){n=31}if(o<1||o>n){e=\"day\";l=\"Please enter a valid day (1-%1).\"}else{if(f<1||f>12){e=\"month\";l=\"Please enter a valid month (1-12).\"}else{if(o%10==o){this.day.value=\"0\"+o}if(f%10==f){this.month.value=\"0\"+f}this.full.value=this.format.replace(/%[mb]/i,this.month.value).replace(/%[de]/i,this.day.value).replace(/%y/i,this.year.value);var b=this.month.value+\"/\"+this.day.value+\"/\"+this.year.value;var g=new Date(b);if(isNaN(g)){l=\"Please enter a valid date.\"}else{this.setFullDate(g)}}}var p=false;if(!l&&!this.validateData()){e=this.validateDataErrorType;p=this.validateDataErrorText;l=p}}}if(l!==false){if(jQuery.mage.__){l=jQuery.mage.__(l)}if(!p){this.advice.innerHTML=l.replace(\"%1\",n)}else{this.advice.innerHTML=this.errorTextModifier(l)}this.advice.show();return false}this.day.removeClassName(\"validation-failed\");this.month.removeClassName(\"validation-failed\");this.year.removeClassName(\"validation-failed\");this.advice.hide();return true},validateData:function(){var d=this.fullDate.getFullYear();var b=new Date;this.curyear=b.getFullYear();return d>=1900&&d<=this.curyear},validateDataErrorType:\"year\",validateDataErrorText:\"Please enter a valid year (1900-%1).\",errorTextModifier:function(b){return b.replace(\"%1\",this.curyear)},setDateRange:function(b,d){this.minDate=b;this.maxDate=d},setFullDate:function(b){this.fullDate=b}};Varien.DOB=Class.create();Varien.DOB.prototype={initialize:function(b,g,f){var e=$$(b)[0];var d={};d.day=Element.select(e,\".dob-day input\")[0];d.month=Element.select(e,\".dob-month input\")[0];d.year=Element.select(e,\".dob-year input\")[0];d.full=Element.select(e,\".dob-full input\")[0];d.advice=Element.select(e,\".validation-advice\")[0];new Varien.DateElement(\"container\",d,g,f)}};Varien.dateRangeDate=Class.create();Varien.dateRangeDate.prototype=Object.extend(new Varien.DateElement(),{validateData:function(){var b=true;if(this.minDate||this.maxValue){if(this.minDate){this.minDate=new Date(this.minDate);this.minDate.setHours(0);if(isNaN(this.minDate)){this.minDate=new Date(\"1/1/1900\")}b=b&&this.fullDate>=this.minDate}if(this.maxDate){this.maxDate=new Date(this.maxDate);this.minDate.setHours(0);if(isNaN(this.maxDate)){this.maxDate=new Date()}b=b&&this.fullDate<=this.maxDate}if(this.maxDate&&this.minDate){this.validateDataErrorText=\"Please enter a valid date between %s and %s\"}else{if(this.maxDate){this.validateDataErrorText=\"Please enter a valid date less than or equal to %s\"}else{if(this.minDate){this.validateDataErrorText=\"Please enter a valid date equal to or greater than %s\"}else{this.validateDataErrorText=\"\"}}}}return b},validateDataErrorText:\"Date should be between %s and %s\",errorTextModifier:function(b){if(this.minDate){b=b.sub(\"%s\",this.dateFormat(this.minDate))}if(this.maxDate){b=b.sub(\"%s\",this.dateFormat(this.maxDate))}return b},dateFormat:function(b){return b.getMonth()+1+\"/\"+b.getDate()+\"/\"+b.getFullYear()}});Varien.FileElement=Class.create();Varien.FileElement.prototype={initialize:function(b){this.fileElement=$(b);this.hiddenElement=$(b+\"_value\");this.fileElement.observe(\"change\",this.selectFile.bind(this))},selectFile:function(b){this.hiddenElement.value=this.fileElement.getValue()}};Validation.addAllThese([[\"validate-custom\",\" \",function(b,d){return d.validate()}]]);Element.addMethods({getInnerText:function(b){b=$(b);if(b.innerText&&!Prototype.Browser.Opera){return b.innerText}return b.innerHTML.stripScripts().unescapeHTML().replace(/[\\n\\r\\s]+/g,\" \").strip()}});function fireEvent(d,e){var b=document.createEvent(\"HTMLEvents\");b.initEvent(e,true,true);return d.dispatchEvent(b)}function modulo(b,f){var e=f/10000;var d=b%f;if(Math.abs(d-f)<e||Math.abs(d)<e){d=0}return d}if(typeof Range!=\"undefined\"&&!Range.prototype.createContextualFragment){Range.prototype.createContextualFragment=function(b){var e=document.createDocumentFragment(),d=document.createElement(\"div\");e.appendChild(d);d.outerHTML=b;return e}}var byteConvert=function(b){if(isNaN(b)){return\"\"}var d=[\"bytes\",\"KB\",\"MB\",\"GB\",\"TB\",\"PB\",\"EB\",\"ZB\",\"YB\"];var f=Math.floor(Math.log(b)/Math.log(2));if(f<1){f=0}var e=Math.floor(f/10);b/=Math.pow(2,10*e);if(b.toString().length>b.toFixed(2).toString().length){b=b.toFixed(2)}return b+\" \"+d[e]};var SessionError=Class.create();SessionError.prototype={initialize:function(b){this.errorText=b},toString:function(){return\"Session Error:\"+this.errorText}};Ajax.Request.addMethods({initialize:function($super,d,b){$super(b);this.transport=Ajax.getTransport();if(!d.match(new RegExp(\"[?&]isAjax=true\",\"\"))){d=d.match(new RegExp(\"\\\\?\",\"g\"))?d+\"&isAjax=true\":d+\"?isAjax=true\"}if(Object.isString(this.options.parameters)&&this.options.parameters.indexOf(\"form_key=\")==-1){this.options.parameters+=\"&\"+Object.toQueryString({form_key:FORM_KEY})}else{if(!this.options.parameters){this.options.parameters={form_key:FORM_KEY}}if(!this.options.parameters.form_key){this.options.parameters.form_key=FORM_KEY}}this.request(d)},respondToReadyState:function(b){var g=Ajax.Request.Events[b],d=new Ajax.Response(this);if(g==\"Complete\"){try{this._complete=true;if(d.responseText.isJSON()){var f=d.responseText.evalJSON();if(f.ajaxExpired&&f.ajaxRedirect){window.location.replace(f.ajaxRedirect);throw new SessionError(\"session expired\")}}(this.options[\"on\"+d.status]||this.options[\"on\"+(this.success()?\"Success\":\"Failure\")]||Prototype.emptyFunction)(d,d.headerJSON)}catch(h){this.dispatchException(h);if(h instanceof SessionError){return}}var l=d.getHeader(\"Content-type\");if(this.options.evalJS==\"force\"||this.options.evalJS&&this.isSameOrigin()&&l&&l.match(/^\\s*(text|application)\\/(x-)?(java|ecma)script(;.*)?\\s*$/i)){this.evalResponse()}}try{(this.options[\"on\"+g]||Prototype.emptyFunction)(d,d.headerJSON);Ajax.Responders.dispatch(\"on\"+g,this,d,d.headerJSON)}catch(h){this.dispatchException(h)}if(g==\"Complete\"){this.transport.onreadystatechange=Prototype.emptyFunction}}});Ajax.Updater.respondToReadyState=Ajax.Request.respondToReadyState;var varienLoader=new Class.create();varienLoader.prototype={initialize:function(b){this.callback=false;this.cache=$H();this.caching=b||false;this.url=false},getCache:function(b){if(this.cache.get(b)){return this.cache.get(b)}return false},load:function(b,d,f){this.url=b;this.callback=f;if(this.caching){var e=this.getCache(b);if(e){this.processResult(e);return}}if(typeof d.updaterId!=\"undefined\"){new varienUpdater(d.updaterId,b,{evalScripts:true,onComplete:this.processResult.bind(this),onFailure:this._processFailure.bind(this)})}else{new Ajax.Request(b,{method:\"post\",parameters:d||{},onComplete:this.processResult.bind(this),onFailure:this._processFailure.bind(this)})}},_processFailure:function(b){location.href=BASE_URL},processResult:function(b){if(this.caching){this.cache.set(this.url,b)}if(this.callback){this.callback(b.responseText)}}};if(!window.varienLoaderHandler){var varienLoaderHandler=new Object()}varienLoaderHandler.handler={onCreate:function(b){if(b.options.loaderArea===false){return}jQuery(\"body\").trigger(\"processStart\")},onException:function(b){jQuery(\"body\").trigger(\"processStop\")},onComplete:function(b){jQuery(\"body\").trigger(\"processStop\")}};function setLoaderPosition(){var e=$(\"loading_mask_loader\");if(e&&Prototype.Browser.IE){var d=e.getDimensions();var f=document.viewport.getDimensions();var b=document.viewport.getScrollOffsets();e.style.left=Math.floor(f.width/2+b.left-d.width/2)+\"px\";e.style.top=Math.floor(f.height/2+b.top-d.height/2)+\"px\";e.style.position=\"absolute\"}}function toggleSelectsUnderBlock(f,b){if(Prototype.Browser.IE){var e=document.getElementsByTagName(\"select\");for(var d=0;d<e.length;d++){if(b){if(e[d].needShowOnSuccess){e[d].needShowOnSuccess=false;e[d].style.visibility=\"\"}}else{if(Element.visible(e[d])){e[d].style.visibility=\"hidden\";e[d].needShowOnSuccess=true}}}}}Ajax.Responders.register(varienLoaderHandler.handler);var varienUpdater=Class.create(Ajax.Updater,{updateContent:function($super,b){if(b.isJSON()){var d=b.evalJSON();if(d.ajaxExpired&&d.ajaxRedirect){window.location.replace(d.ajaxRedirect)}}else{$super(b)}}});function setLocation(b){window.location.href=b}function setElementDisable(d,b){if($(d)){$(d).disabled=b}}function toggleParentVis(b){b=$(b).parentNode;if(b.style.display==\"none\"){b.style.display=\"\"}else{b.style.display=\"none\"}}function toggleFieldsetVis(d){id=d;d=$(d);if(d.style.display==\"none\"){d.style.display=\"\"}else{d.style.display=\"none\"}d=d.parentNode.childElements();for(var b=0;b<d.length;b++){if(d[b].id!=undefined&&d[b].id==id&&d[b-1].classNames()==\"entry-edit-head\"){if(d[b-1].style.display==\"none\"){d[b-1].style.display=\"\"}else{d[b-1].style.display=\"none\"}}}}function toggleVis(b){b=$(b);if(b.style.display==\"none\"){b.style.display=\"\"}else{b.style.display=\"none\"}}function imagePreview(b){if($(b)){var d=window.open(\"\",\"preview\",\"width=400,height=400,resizable=1,scrollbars=1\");d.document.open();d.document.write('<body style=\"padding:0;margin:0\"><img src=\"'+$(b).src+'\" id=\"image_preview\"/></body>');d.document.close();Event.observe(d,\"load\",function(){var e=d.document.getElementById(\"image_preview\");d.resizeTo(e.width+40,e.height+80)})}}function checkByProductPriceType(b){if(b.id==\"price_type\"){this.productPriceType=b.value;return false}if(b.id==\"price\"&&this.productPriceType==0){return false}return true}function toggleSeveralValueElements(f,e,b,d){if(e&&f){if(Object.prototype.toString.call(e)!=\"[object Array]\"){e=[e]}e.each(function(g){toggleValueElements(f,g,b,d)})}}function toggleValueElements(l,d,f,h){if(d&&l){var n=[l];if(typeof f!=\"undefined\"){if(Object.prototype.toString.call(f)!=\"[object Array]\"){f=[f]}for(var g=0;g<f.length;g++){n.push(f[g])}}var e=Element.select(d,[\"select\",\"input\",\"textarea\",\"button\",\"img\"]).filter(function(o){return o.readAttribute(\"type\")!=\"hidden\"});var b=h!=undefined?h:l.checked;e.each(function(p){if(checkByProductPriceType(p)){var o=n.length;while(o--&&p!=n[o]){}if(o!=-1){return}p.disabled=b;if(b){p.addClassName(\"disabled\")}else{p.removeClassName(\"disabled\")}if(p.nodeName.toLowerCase()==\"img\"){b?p.hide():p.show()}}})}}function submitAndReloadArea(e,d){if($(e)){var b=$(e).select(\"input\",\"select\",\"textarea\");var f=Form.serializeElements(b,true);d+=d.match(new RegExp(\"\\\\?\"))?\"&isAjax=true\":\"?isAjax=true\";new Ajax.Request(d,{parameters:$H(f),loaderArea:e,onSuccess:function(l){try{if(l.responseText.isJSON()){var g=l.responseText.evalJSON();if(g.error){alert(g.message)}if(g.ajaxExpired&&g.ajaxRedirect){setLocation(g.ajaxRedirect)}}else{$(e).update(l.responseText)}}catch(h){$(e).update(l.responseText)}}})}}function syncOnchangeValue(d,e){var b={baseElem:d,distElem:e};Event.observe(d,\"change\",function(){if($(this.baseElem)&&$(this.distElem)){$(this.distElem).value=$(this.baseElem).value}}.bind(b))}function updateElementAtCursor(e,f,g){if(g==undefined){g=window.self}if(document.selection){e.focus();sel=g.document.selection.createRange();sel.text=f}else{if(e.selectionStart||e.selectionStart==\"0\"){var d=e.selectionStart;var b=e.selectionEnd;e.value=e.value.substring(0,d)+f+e.value.substring(b,e.value.length)}else{e.value+=f}}}function firebugEnabled(){if(window.console&&window.console.firebug){return true}return false}function disableElement(b){b.disabled=true;b.addClassName(\"disabled\")}function enableElement(b){b.disabled=false;b.removeClassName(\"disabled\")}function disableElements(b){$$(\".\"+b).each(disableElement)}function enableElements(b){$$(\".\"+b).each(enableElement)}var Cookie={all:function(){var d=document.cookie.split(\";\");var b={};d.each(function(f,e){var g=f.strip().split(\"=\");b[unescape(g[0])]=unescape(g[1])});return b},read:function(d){var b=this.all();if(b[d]){return b[d]}return null},write:function(l,g,h,f){var b=\"\";if(h){var e=new Date();e.setTime(e.getTime()+h*1000);b=\"; expires=\"+e.toUTCString()}var d=\"/\"+BASE_URL.split(\"/\").slice(3).join(\"/\");f=\"; samesite=\"+(f?f:\"lax\");document.cookie=escape(l)+\"=\"+escape(g)+b+\"; path=\"+d+f},clear:function(b){this.write(b,\"\",-1)}};var Fieldset={cookiePrefix:\"fh-\",applyCollapse:function(b){if($(b+\"-state\")){collapsed=$(b+\"-state\").value==1?0:1}else{collapsed=$(b+\"-head\").collapsed}if(collapsed==1||collapsed===undefined){$(b+\"-head\").removeClassName(\"open\");if($(b+\"-head\").up(\".section-config\")){$(b+\"-head\").up(\".section-config\").removeClassName(\"active\")}$(b).hide()}else{$(b+\"-head\").addClassName(\"open\");if($(b+\"-head\").up(\".section-config\")){$(b+\"-head\").up(\".section-config\").addClassName(\"active\")}$(b).show()}},toggleCollapse:function(b,d){if($(b+\"-state\")){collapsed=$(b+\"-state\").value==1?0:1}else{collapsed=$(b+\"-head\").collapsed}if(collapsed==1||collapsed===undefined){if($(b+\"-state\")){$(b+\"-state\").value=1}$(b+\"-head\").collapsed=0}else{if($(b+\"-state\")){$(b+\"-state\").value=0}$(b+\"-head\").collapsed=1}this.applyCollapse(b);if(typeof d!=\"undefined\"){this.saveState(d,{container:b,value:$(b+\"-state\").value})}},addToPrefix:function(b){this.cookiePrefix+=b+\"-\"},saveState:function(b,d){new Ajax.Request(b,{method:\"post\",parameters:Object.toQueryString(d),loaderArea:false})}};var Base64={_keyStr:\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\",encode:function(e){var b=\"\";var p,n,h,o,l,g,f;var d=0;e=Base64._utf8_encode(e);if(typeof window.btoa===\"function\"){return window.btoa(e)}while(d<e.length){p=e.charCodeAt(d++);n=e.charCodeAt(d++);h=e.charCodeAt(d++);o=p>>2;l=(p&3)<<4|n>>4;g=(n&15)<<2|h>>6;f=h&63;if(isNaN(n)){g=f=64}else{if(isNaN(h)){f=64}}b=b+this._keyStr.charAt(o)+this._keyStr.charAt(l)+this._keyStr.charAt(g)+this._keyStr.charAt(f)}return b},decode:function(e){var b=\"\";var p,n,h;var o,l,g,f;var d=0;if(typeof window.atob===\"function\"){return Base64._utf8_decode(window.atob(e))}e=e.replace(/[^A-Za-z0-9\\+\\/\\=]/g,\"\");while(d<e.length){o=this._keyStr.indexOf(e.charAt(d++));l=this._keyStr.indexOf(e.charAt(d++));g=this._keyStr.indexOf(e.charAt(d++));f=this._keyStr.indexOf(e.charAt(d++));p=o<<2|l>>4;n=(l&15)<<4|g>>2;h=(g&3)<<6|f;b+=String.fromCharCode(p);if(g!=64){b+=String.fromCharCode(n)}if(f!=64){b+=String.fromCharCode(h)}}return Base64._utf8_decode(b)},mageEncode:function(b){return this.encode(b).replace(/\\+/g,\"-\").replace(/\\//g,\"_\").replace(/=/g,\",\")},mageDecode:function(b){b=b.replace(/\\-/g,\"+\").replace(/_/g,\"/\").replace(/,/g,\"=\");return this.decode(b)},idEncode:function(b){return this.encode(b).replace(/\\+/g,\":\").replace(/\\//g,\"_\").replace(/=/g,\"-\")},idDecode:function(b){b=b.replace(/\\-/g,\"=\").replace(/_/g,\"/\").replace(/\\:/g,\"+\");return this.decode(b)},_utf8_encode:function(d){d=d.replace(/\\r\\n/g,\"\\n\");var b=\"\";for(var f=0;f<d.length;f++){var e=d.charCodeAt(f);if(e<128){b+=String.fromCharCode(e)}else{if(e>127&&e<2048){b+=String.fromCharCode(e>>6|192);b+=String.fromCharCode(e&63|128)}else{b+=String.fromCharCode(e>>12|224);b+=String.fromCharCode(e>>6&63|128);b+=String.fromCharCode(e&63|128)}}}return b},_utf8_decode:function(b){var d=\"\";var e=0;var f=c1=c2=0;while(e<b.length){f=b.charCodeAt(e);if(f<128){d+=String.fromCharCode(f);e++}else{if(f>191&&f<224){c2=b.charCodeAt(e+1);d+=String.fromCharCode((f&31)<<6|c2&63);e+=2}else{c2=b.charCodeAt(e+1);c3=b.charCodeAt(e+2);d+=String.fromCharCode((f&15)<<12|(c2&63)<<6|c3&63);e+=3}}}return d}};function sortNumeric(d,b){return d-b}(function(){var globals=[\"Prototype\",\"Abstract\",\"Try\",\"Class\",\"PeriodicalExecuter\",\"Template\",\"$break\",\"Enumerable\",\"$A\",\"$w\",\"$H\",\"Hash\",\"$R\",\"ObjectRange\",\"Ajax\",\"$\",\"Form\",\"Field\",\"$F\",\"Toggle\",\"Insertion\",\"$continue\",\"Position\",\"Windows\",\"Dialog\",\"array\",\"WindowUtilities\",\"Builder\",\"Effect\",\"validateCreditCard\",\"Validator\",\"Validation\",\"removeDelimiters\",\"parseNumber\",\"popWin\",\"setLocation\",\"setPLocation\",\"setLanguageCode\",\"decorateGeneric\",\"decorateTable\",\"decorateList\",\"decorateDataList\",\"parseSidUrl\",\"formatCurrency\",\"expandDetails\",\"isIE\",\"Varien\",\"fireEvent\",\"modulo\",\"byteConvert\",\"SessionError\",\"varienLoader\",\"varienLoaderHandler\",\"setLoaderPosition\",\"toggleSelectsUnderBlock\",\"varienUpdater\",\"setElementDisable\",\"toggleParentVis\",\"toggleFieldsetVis\",\"toggleVis\",\"imagePreview\",\"checkByProductPriceType\",\"toggleSeveralValueElements\",\"toggleValueElements\",\"submitAndReloadArea\",\"syncOnchangeValue\",\"updateElementAtCursor\",\"firebugEnabled\",\"disableElement\",\"enableElement\",\"disableElements\",\"enableElements\",\"Cookie\",\"Fieldset\",\"Base64\",\"sortNumeric\",\"Element\",\"$$\",\"Sizzle\",\"Selector\",\"Window\"];globals.forEach(function(prop){window[prop]=eval(prop)})})();\n","requirejs-config.js":"(function(require){\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_ReleaseNotification/js/modal/component': {\n                'Magento_AdminAnalytics/js/release-notification/modal/component-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            systemMessageDialog: 'Magento_AdminNotification/system/notification',\n            toolbarEntry:   'Magento_AdminNotification/toolbar_entry'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    waitSeconds: 0,\n    map: {\n        '*': {\n            'ko': 'knockoutjs/knockout',\n            'knockout': 'knockoutjs/knockout',\n            'mageUtils': 'mage/utils/main',\n            'rjsResolver': 'mage/requirejs/resolver',\n            'jquery-ui-modules/core': 'jquery/ui-modules/core',\n            'jquery-ui-modules/accordion': 'jquery/ui-modules/widgets/accordion',\n            'jquery-ui-modules/autocomplete': 'jquery/ui-modules/widgets/autocomplete',\n            'jquery-ui-modules/button': 'jquery/ui-modules/widgets/button',\n            'jquery-ui-modules/datepicker': 'jquery/ui-modules/widgets/datepicker',\n            'jquery-ui-modules/dialog': 'jquery/ui-modules/widgets/dialog',\n            'jquery-ui-modules/draggable': 'jquery/ui-modules/widgets/draggable',\n            'jquery-ui-modules/droppable': 'jquery/ui-modules/widgets/droppable',\n            'jquery-ui-modules/effect-blind': 'jquery/ui-modules/effects/effect-blind',\n            'jquery-ui-modules/effect-bounce': 'jquery/ui-modules/effects/effect-bounce',\n            'jquery-ui-modules/effect-clip': 'jquery/ui-modules/effects/effect-clip',\n            'jquery-ui-modules/effect-drop': 'jquery/ui-modules/effects/effect-drop',\n            'jquery-ui-modules/effect-explode': 'jquery/ui-modules/effects/effect-explode',\n            'jquery-ui-modules/effect-fade': 'jquery/ui-modules/effects/effect-fade',\n            'jquery-ui-modules/effect-fold': 'jquery/ui-modules/effects/effect-fold',\n            'jquery-ui-modules/effect-highlight': 'jquery/ui-modules/effects/effect-highlight',\n            'jquery-ui-modules/effect-scale': 'jquery/ui-modules/effects/effect-scale',\n            'jquery-ui-modules/effect-pulsate': 'jquery/ui-modules/effects/effect-pulsate',\n            'jquery-ui-modules/effect-shake': 'jquery/ui-modules/effects/effect-shake',\n            'jquery-ui-modules/effect-slide': 'jquery/ui-modules/effects/effect-slide',\n            'jquery-ui-modules/effect-transfer': 'jquery/ui-modules/effects/effect-transfer',\n            'jquery-ui-modules/effect': 'jquery/ui-modules/effect',\n            'jquery-ui-modules/menu': 'jquery/ui-modules/widgets/menu',\n            'jquery-ui-modules/mouse': 'jquery/ui-modules/widgets/mouse',\n            'jquery-ui-modules/position': 'jquery/ui-modules/position',\n            'jquery-ui-modules/progressbar': 'jquery/ui-modules/widgets/progressbar',\n            'jquery-ui-modules/resizable': 'jquery/ui-modules/widgets/resizable',\n            'jquery-ui-modules/selectable': 'jquery/ui-modules/widgets/selectable',\n            'jquery-ui-modules/selectmenu': 'jquery/ui-modules/widgets/selectmenu',\n            'jquery-ui-modules/slider': 'jquery/ui-modules/widgets/slider',\n            'jquery-ui-modules/sortable': 'jquery/ui-modules/widgets/sortable',\n            'jquery-ui-modules/spinner': 'jquery/ui-modules/widgets/spinner',\n            'jquery-ui-modules/tabs': 'jquery/ui-modules/widgets/tabs',\n            'jquery-ui-modules/tooltip': 'jquery/ui-modules/widgets/tooltip',\n            'jquery-ui-modules/widget': 'jquery/ui-modules/widget',\n            'jquery-ui-modules/timepicker': 'jquery/timepicker',\n            'vimeo': 'vimeo/player',\n            'vimeoWrapper': 'vimeo/vimeo-wrapper'\n        }\n    },\n    shim: {\n        'mage/adminhtml/backup': ['prototype'],\n        'mage/captcha': ['prototype'],\n        'mage/new-gallery': ['jquery'],\n        'jquery/ui': ['jquery'],\n        'matchMedia': {\n            'exports': 'mediaCheck'\n        },\n        'magnifier/magnifier': ['jquery'],\n        'vimeo/player': {\n            'exports': 'Player'\n        }\n    },\n    paths: {\n        'jquery/validate': 'jquery/jquery.validate',\n        'jquery/uppy-core': 'jquery/uppy/dist/uppy.min',\n        'prototype': 'legacy-build.min',\n        'jquery/jquery-storageapi': 'js-storage/storage-wrapper',\n        'text': 'mage/requirejs/text',\n        'domReady': 'requirejs/domReady',\n        'spectrum': 'jquery/spectrum/spectrum',\n        'tinycolor': 'jquery/spectrum/tinycolor',\n        'jquery-ui-modules': 'jquery/ui-modules'\n    },\n    config: {\n        text: {\n            'headers': {\n                'X-Requested-With': 'XMLHttpRequest'\n            }\n        }\n    }\n};\n\nrequire(['jquery'], function ($) {\n    'use strict';\n\n    $.noConflict();\n});\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    'shim': {\n        'extjs/ext-tree': [\n            'prototype'\n        ],\n        'extjs/ext-tree-checkbox': [\n            'extjs/ext-tree',\n            'extjs/defaults'\n        ],\n        'jquery/editableMultiselect/js/jquery.editable': [\n            'jquery'\n        ]\n    },\n    'bundles': {\n        'js/theme': [\n            'globalNavigation',\n            'globalSearch',\n            'modalPopup',\n            'useDefault',\n            'loadingPopup',\n            'collapsable'\n        ]\n    },\n    'map': {\n        '*': {\n            'translateInline':                    'mage/translate-inline',\n            'form':                               'mage/backend/form',\n            'button':                             'mage/backend/button',\n            'accordion':                          'mage/accordion',\n            'actionLink':                         'mage/backend/action-link',\n            'validation':                         'mage/backend/validation',\n            'notification':                       'mage/backend/notification',\n            'loader':                             'mage/loader_old',\n            'loaderAjax':                         'mage/loader_old',\n            'floatingHeader':                     'mage/backend/floating-header',\n            'suggest':                            'mage/backend/suggest',\n            'mediabrowser':                       'jquery/jstree/jquery.jstree',\n            'tabs':                               'mage/backend/tabs',\n            'treeSuggest':                        'mage/backend/tree-suggest',\n            'calendar':                           'mage/calendar',\n            'dropdown':                           'mage/dropdown_old',\n            'collapsible':                        'mage/collapsible',\n            'menu':                               'mage/backend/menu',\n            'jstree':                             'jquery/jstree/jquery.jstree',\n            'jquery-ui-modules/widget':           'jquery/ui',\n            'jquery-ui-modules/core':             'jquery/ui',\n            'jquery-ui-modules/accordion':        'jquery/ui',\n            'jquery-ui-modules/autocomplete':     'jquery/ui',\n            'jquery-ui-modules/button':           'jquery/ui',\n            'jquery-ui-modules/datepicker':       'jquery/ui',\n            'jquery-ui-modules/dialog':           'jquery/ui',\n            'jquery-ui-modules/draggable':        'jquery/ui',\n            'jquery-ui-modules/droppable':        'jquery/ui',\n            'jquery-ui-modules/effect-blind':     'jquery/ui',\n            'jquery-ui-modules/effect-bounce':    'jquery/ui',\n            'jquery-ui-modules/effect-clip':      'jquery/ui',\n            'jquery-ui-modules/effect-drop':      'jquery/ui',\n            'jquery-ui-modules/effect-explode':   'jquery/ui',\n            'jquery-ui-modules/effect-fade':      'jquery/ui',\n            'jquery-ui-modules/effect-fold':      'jquery/ui',\n            'jquery-ui-modules/effect-highlight': 'jquery/ui',\n            'jquery-ui-modules/effect-scale':     'jquery/ui',\n            'jquery-ui-modules/effect-pulsate':   'jquery/ui',\n            'jquery-ui-modules/effect-shake':     'jquery/ui',\n            'jquery-ui-modules/effect-slide':     'jquery/ui',\n            'jquery-ui-modules/effect-transfer':  'jquery/ui',\n            'jquery-ui-modules/effect':           'jquery/ui',\n            'jquery-ui-modules/menu':             'jquery/ui',\n            'jquery-ui-modules/mouse':            'jquery/ui',\n            'jquery-ui-modules/position':         'jquery/ui',\n            'jquery-ui-modules/progressbar':      'jquery/ui',\n            'jquery-ui-modules/resizable':        'jquery/ui',\n            'jquery-ui-modules/selectable':       'jquery/ui',\n            'jquery-ui-modules/slider':           'jquery/ui',\n            'jquery-ui-modules/sortable':         'jquery/ui',\n            'jquery-ui-modules/spinner':          'jquery/ui',\n            'jquery-ui-modules/tabs':             'jquery/ui',\n            'jquery-ui-modules/tooltip':          'jquery/ui'\n        }\n    },\n    'deps': [\n        'js/theme',\n        'mage/backend/bootstrap',\n        'mage/adminhtml/globals'\n    ],\n    'paths': {\n        'jquery/ui': 'jquery/jquery-ui'\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'mediaUploader':  'Magento_Backend/js/media-uploader'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            escaper: 'Magento_Security/js/escaper'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            popupWindow:            'mage/popup-window',\n            confirmRedirect:        'Magento_Security/js/confirm-redirect'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            rolesTree: 'Magento_User/js/roles-tree',\n            deleteUserAccount: 'Magento_User/js/delete-user-account'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            eavInputTypes: 'Magento_Eav/js/input-types'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    paths: {\n        'customer/template': 'Magento_Customer/templates'\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    map: {\n        '*': {\n            loadIcons: 'Magento_AdminAdobeIms/js/loadicons',\n            adobeImsReauth: 'Magento_AdminAdobeIms/js/adobe-ims-reauth'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            folderTree: 'Magento_Cms/js/folder-tree'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            integration: 'Magento_Integration/js/integration'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            priceBox:             'Magento_Catalog/js/price-box',\n            priceOptionDate:      'Magento_Catalog/js/price-option-date',\n            priceOptionFile:      'Magento_Catalog/js/price-option-file',\n            priceOptions:         'Magento_Catalog/js/price-options',\n            priceUtils:           'Magento_Catalog/js/price-utils'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            categoryForm:         'Magento_Catalog/catalog/category/form',\n            newCategoryDialog:    'Magento_Catalog/js/new-category-dialog',\n            categoryTree:         'Magento_Catalog/js/category-tree',\n            productGallery:       'Magento_Catalog/js/product-gallery',\n            baseImage:            'Magento_Catalog/catalog/base-image-uploader',\n            productAttributes:    'Magento_Catalog/catalog/product-attributes',\n            categoryCheckboxTree: 'Magento_Catalog/js/category-checkbox-tree'\n        }\n    },\n    deps: [\n        'Magento_Catalog/catalog/product'\n    ],\n    config: {\n        mixins: {\n            'Magento_Catalog/js/components/use-parent-settings/select': {\n                'Magento_Catalog/js/components/use-parent-settings/toggle-disabled-mixin': true\n            },\n            'Magento_Catalog/js/components/use-parent-settings/textarea': {\n                'Magento_Catalog/js/components/use-parent-settings/toggle-disabled-mixin': true\n            },\n            'Magento_Catalog/js/components/use-parent-settings/single-checkbox': {\n                'Magento_Catalog/js/components/use-parent-settings/toggle-disabled-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            orderEditDialog: 'Magento_Sales/order/edit/message'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            testConnection: 'Magento_AdvancedSearch/js/testconnection'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    deps: [],\n    shim: {\n        'chartjs/chartjs-adapter-moment': ['moment'],\n        'chartjs/es6-shim.min': {},\n        'tiny_mce_6/tinymce.min': {\n            exports: 'tinyMCE'\n        }\n    },\n    paths: {\n        'ui/template': 'Magento_Ui/templates'\n    },\n    map: {\n        '*': {\n            uiElement:      'Magento_Ui/js/lib/core/element/element',\n            uiCollection:   'Magento_Ui/js/lib/core/collection',\n            uiComponent:    'Magento_Ui/js/lib/core/collection',\n            uiClass:        'Magento_Ui/js/lib/core/class',\n            uiEvents:       'Magento_Ui/js/lib/core/events',\n            uiRegistry:     'Magento_Ui/js/lib/registry/registry',\n            consoleLogger:  'Magento_Ui/js/lib/logger/console-logger',\n            uiLayout:       'Magento_Ui/js/core/renderer/layout',\n            buttonAdapter:  'Magento_Ui/js/form/button-adapter',\n            chartJs:        'chartjs/Chart.min',\n            'chart.js':     'chartjs/Chart.min',\n            tinymce:        'tiny_mce_6/tinymce.min',\n            wysiwygAdapter: 'mage/adminhtml/wysiwyg/tiny_mce/tinymceAdapter'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            groupedProduct: 'Magento_GroupedProduct/js/grouped-product'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            'slick': 'Magento_PageBuilder/js/resource/slick/slick',\n            'jarallax': 'Magento_PageBuilder/js/resource/jarallax/jarallax',\n            'jarallaxVideo': 'Magento_PageBuilder/js/resource/jarallax/jarallax-video',\n            'Magento_PageBuilder/js/resource/vimeo/player': 'vimeo/player',\n            'Magento_PageBuilder/js/resource/vimeo/vimeo-wrapper': 'vimeo/vimeo-wrapper',\n            'jarallax-wrapper': 'Magento_PageBuilder/js/resource/jarallax/jarallax-wrapper'\n        }\n    },\n    shim: {\n        'Magento_PageBuilder/js/resource/slick/slick': {\n            deps: ['jquery']\n        },\n        'Magento_PageBuilder/js/resource/jarallax/jarallax-video': {\n            deps: ['jarallax-wrapper', 'vimeoWrapper']\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            /* Include our Knockout Sortable wrapper */\n            'pagebuilder/ko-dropzone': 'Magento_PageBuilder/js/resource/dropzone/knockout-dropzone',\n\n            /* Utilities */\n            'google-map': 'Magento_PageBuilder/js/utils/map',\n            'object-path': 'Magento_PageBuilder/js/resource/object-path',\n            'html2canvas': 'Magento_PageBuilder/js/resource/html2canvas/html2canvas.min',\n            'csso': 'Magento_PageBuilder/js/resource/csso/csso'\n        }\n    },\n    shim: {\n        'pagebuilder/ko-sortable': {\n            deps: ['jquery', 'jquery/ui', 'Magento_PageBuilder/js/resource/jquery-ui/jquery.ui.touch-punch']\n        },\n        'Magento_PageBuilder/js/resource/jquery/ui/jquery.ui.touch-punch': {\n            deps: ['jquery/ui']\n        }\n    },\n    config: {\n        mixins: {\n            'Magento_Ui/js/form/element/abstract': {\n                'Magento_PageBuilder/js/form/element/conditional-disable-mixin': true,\n                'Magento_PageBuilder/js/form/element/dependent-value-mixin': true\n            },\n            'Magento_Ui/js/lib/validation/validator': {\n                'Magento_PageBuilder/js/form/element/validator-rules-mixin': true\n            },\n            'mage/validation': {\n                'Magento_PageBuilder/js/system/config/validator-rules-mixin': true\n            },\n            'Magento_Ui/js/form/form': {\n                'Magento_PageBuilder/js/form/form-mixin': true\n            },\n            'Magento_PageBuilder/js/content-type/row/appearance/default/widget': {\n                'Magento_PageBuilder/js/content-type/row/appearance/default/widget-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            transparent: 'Magento_Payment/js/transparent',\n            'Magento_Payment/transparent': 'Magento_Payment/js/transparent'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            newVideoDialog:  'Magento_ProductVideo/js/new-video-dialog',\n            openVideoModal:  'Magento_ProductVideo/js/video-modal'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_PageBuilder/js/events': {\n                'Magento_PageBuilderAdminAnalytics/js/page-builder/events-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            scriptLoader: 'Magento_PaymentServicesPaypal/js/lib/script-loader-wrapper'\n        }\n    },\n    shim: {\n        'Magento_PaymentServicesPaypal/js/lib/script-loader': {\n            init: function () {\n                'use strict';\n\n                return {\n                    load: window.paypalLoadScript,\n                    loadCustom: window.paypalLoadCustomScript\n                };\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            swatchesProductAttributes: 'Magento_Swatches/js/product-attributes'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            mageTranslationDictionary: 'Magento_Translation/js/mage-translation-dictionary'\n        }\n    },\n    deps: [\n        'mageTranslationDictionary'\n    ]\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nvar config = {\n    map: {\n        '*': {\n            fptAttribute: 'Magento_Weee/js/fpt-attribute'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Ui/js/grid/filters/filters': {\n                'EthanYehuda_CronjobManager/js/grid/filters-mixin': true\n            }\n        }\n    },\n    shim: {\n        'EthanYehuda_CronjobManager/js/timeline/timeline': {\n            'deps': ['EthanYehuda_CronjobManager/js/lib/knockout/bindings/virtual-foreach']\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCore\n * @author    Botis <botis@smile.fr>\n * @copyright 2021 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Ui/js/lib/validation/validator': {\n                'Smile_ElasticsuiteCore/js/validation/validator-mixin': true\n            }\n        }\n    },\n};\n\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCore\n * @author    Botis <botis@smile.fr>\n * @copyright 2021 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\nvar config = {\n    map: {\n        '*': {\n            EsChart: 'Smile_ElasticsuiteCore/js/lib/chart',\n        }\n    }\n};\n\n\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Hyv\u00e4 Themes - https://hyva.io\n * Copyright \u00a9 Hyv\u00e4 Themes 2020-present. All rights reserved.\n * This product is licensed per Magento install\n * See https://hyva.io/license\n */\nvar config = {\n    config: {\n        mixins: {\n            'Magento_Ui/js/lib/validation/validator': {\n                'Hyva_Theme/js/form/element/validator-rules-mixin': true\n            },\n        }\n    }\n}\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    map: {\n        '*': {\n            magePalGmailSmtpAppValidateConfig: 'MagePal_GmailSmtpApp/js/validate-config'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    map: {\n        '*': {\n            hyvaThemesCheckout: 'Hyva_Checkout/js/hyva-themes-checkout'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * Config to pull in all the relevant Braintree JS SDKs\n * @type {\n *  paths: {\n *      braintreePayPalInContextCheckout: string,\n *      braintreePayPalCheckout: string,\n *      braintreeVenmo: string,\n *      braintreeHostedFields: string,\n *      braintreeDataCollector: string,\n *      braintreeThreeDSecure: string,\n *      braintreeGooglePay: string,\n *      braintreeApplePay: string,\n *      braintreeAch: string,\n *      braintreeLpm: string,\n *      googlePayLibrary: string\n * },\n *  map: {\n *      \"*\": {\n *          braintree: string\n *      }\n *  }\n * }\n */\nvar config = {\n    map: {\n        '*': {\n            braintree: 'https://js.braintreegateway.com/web/3.112.0/js/client.min.js'\n        }\n    },\n\n    paths: {\n        'braintreePayPalCheckout': 'https://js.braintreegateway.com/web/3.112.0/js/paypal-checkout.min',\n        'braintreeHostedFields': 'https://js.braintreegateway.com/web/3.112.0/js/hosted-fields.min',\n        'braintreeDataCollector': 'https://js.braintreegateway.com/web/3.112.0/js/data-collector.min',\n        'braintreeThreeDSecure': 'https://js.braintreegateway.com/web/3.112.0/js/three-d-secure.min',\n        'braintreeApplePay': 'https://js.braintreegateway.com/web/3.112.0/js/apple-pay.min',\n        'braintreeGooglePay': 'https://js.braintreegateway.com/web/3.112.0/js/google-payment.min',\n        'braintreeVenmo': 'https://js.braintreegateway.com/web/3.112.0/js/venmo.min',\n        'braintreeAch': 'https://js.braintreegateway.com/web/3.112.0/js/us-bank-account.min',\n        'braintreeLpm': 'https://js.braintreegateway.com/web/3.112.0/js/local-payment.min',\n        'googlePayLibrary': 'https://pay.google.com/gp/p/js/pay',\n        'braintreePayPalInContextCheckout': 'https://www.paypalobjects.com/api/checkout'\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteTracker\n * @author    Richard Bayet <richard.bayet@smile.fr>\n * @copyright 2024 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\nvar config = {\n    map: {\n        '*': {\n            purgeEventQueue: 'Smile_ElasticsuiteTracker/js/purge_event_queue'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteSwatches\n * @author    Richard BAYET <richard.bayet@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\nvar config = {\n    map: {\n        '*': {\n            swatchesProductAttributes: 'Smile_ElasticsuiteSwatches/js/product-attributes'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteIndices\n * @author    Dmytro ANDROSHCHUK <dmand@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\nvar config = {\n    paths: {\n        'jquery.json-viewer' : 'Smile_ElasticsuiteIndices/js/jquery.json-viewer'\n    },\n    shim: {\n        'jquery.json-viewer': {\n            deps: ['jquery']\n        }\n    },\n    map: {\n        '*': {\n            jsonViewer: 'Smile_ElasticsuiteIndices/js/jquery.json-viewer'\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\n/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteVirtualCategories\n * @author    Romain Ruaud <romain.ruaud@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\nvar config = {\n    map: {\n        '*': {\n            'Magento_Catalog/catalog/category/assign-products': 'Smile_ElasticsuiteVirtualCategory/js/component/catalog/category/form/assign-products'\n        }\n    },\n    config: {\n        mixins: {\n            'Magento_PageBuilder/js/form/provider/conditions-data-processor': {\n                'Smile_ElasticsuiteVirtualCategory/js/form/provider/conditions-data-processor-mixin': true\n            },\n            'Magento_VisualMerchandiser/js/merchandiser': {\n                'Smile_ElasticsuiteVirtualCategory/js/merchandiser-mixin': true\n            }\n        }\n    }\n};\n\nrequire.config(config);\n})();\n(function() {\nvar config = {\n    map: {\n        '*': {\n            'jquery/blockUI': 'Xtento_ProductExport/js/jquery/jquery.blockUI',\n            'jquery/fileDownload': 'Xtento_ProductExport/js/jquery/jquery.fileDownload'\n        }\n    }\n};\nrequire.config(config);\n})();\n\n\n\n})(require);","jquery.js":"/*!\n * jQuery JavaScript Library v3.7.1\n * https://jquery.com/\n *\n * Copyright OpenJS Foundation and other contributors\n * Released under the MIT license\n * https://jquery.org/license\n *\n * Date: 2023-08-28T13:37Z\n */\n( function( global, factory ) {\n\n    \"use strict\";\n\n    if ( typeof module === \"object\" && typeof module.exports === \"object\" ) {\n\n        // For CommonJS and CommonJS-like environments where a proper `window`\n        // is present, execute the factory and get jQuery.\n        // For environments that do not have a `window` with a `document`\n        // (such as Node.js), expose a factory as module.exports.\n        // This accentuates the need for the creation of a real `window`.\n        // e.g. var jQuery = require(\"jquery\")(window);\n        // See ticket trac-14549 for more info.\n        module.exports = global.document ?\n            factory( global, true ) :\n            function( w ) {\n                if ( !w.document ) {\n                    throw new Error( \"jQuery requires a window with a document\" );\n                }\n                return factory( w );\n            };\n    } else {\n        factory( global );\n    }\n\n// Pass this if window is not defined yet\n} )( typeof window !== \"undefined\" ? window : this, function( window, noGlobal ) {\n\n// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1\n// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode\n// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common\n// enough that all such attempts are guarded in a try block.\n    \"use strict\";\n\n    var arr = [];\n\n    var getProto = Object.getPrototypeOf;\n\n    var slice = arr.slice;\n\n    var flat = arr.flat ? function( array ) {\n        return arr.flat.call( array );\n    } : function( array ) {\n        return arr.concat.apply( [], array );\n    };\n\n\n    var push = arr.push;\n\n    var indexOf = arr.indexOf;\n\n    var class2type = {};\n\n    var toString = class2type.toString;\n\n    var hasOwn = class2type.hasOwnProperty;\n\n    var fnToString = hasOwn.toString;\n\n    var ObjectFunctionString = fnToString.call( Object );\n\n    var support = {};\n\n    var isFunction = function isFunction( obj ) {\n\n        // Support: Chrome <=57, Firefox <=52\n        // In some browsers, typeof returns \"function\" for HTML <object> elements\n        // (i.e., `typeof document.createElement( \"object\" ) === \"function\"`).\n        // We don't want to classify *any* DOM node as a function.\n        // Support: QtWeb <=3.8.5, WebKit <=534.34, wkhtmltopdf tool <=0.12.5\n        // Plus for old WebKit, typeof returns \"function\" for HTML collections\n        // (e.g., `typeof document.getElementsByTagName(\"div\") === \"function\"`). (gh-4756)\n        return typeof obj === \"function\" && typeof obj.nodeType !== \"number\" &&\n            typeof obj.item !== \"function\";\n    };\n\n\n    var isWindow = function isWindow( obj ) {\n        return obj != null && obj === obj.window;\n    };\n\n\n    var document = window.document;\n\n\n\n    var preservedScriptAttributes = {\n        type: true,\n        src: true,\n        nonce: true,\n        noModule: true\n    };\n\n    function DOMEval( code, node, doc ) {\n        doc = doc || document;\n\n        var i, val,\n            script = doc.createElement( \"script\" );\n\n        script.text = code;\n        if ( node ) {\n            for ( i in preservedScriptAttributes ) {\n\n                // Support: Firefox 64+, Edge 18+\n                // Some browsers don't support the \"nonce\" property on scripts.\n                // On the other hand, just using `getAttribute` is not enough as\n                // the `nonce` attribute is reset to an empty string whenever it\n                // becomes browsing-context connected.\n                // See https://github.com/whatwg/html/issues/2369\n                // See https://html.spec.whatwg.org/#nonce-attributes\n                // The `node.getAttribute` check was added for the sake of\n                // `jQuery.globalEval` so that it can fake a nonce-containing node\n                // via an object.\n                val = node[ i ] || node.getAttribute && node.getAttribute( i );\n                if ( val ) {\n                    script.setAttribute( i, val );\n                }\n            }\n        }\n        doc.head.appendChild( script ).parentNode.removeChild( script );\n    }\n\n\n    function toType( obj ) {\n        if ( obj == null ) {\n            return obj + \"\";\n        }\n\n        // Support: Android <=2.3 only (functionish RegExp)\n        return typeof obj === \"object\" || typeof obj === \"function\" ?\n            class2type[ toString.call( obj ) ] || \"object\" :\n            typeof obj;\n    }\n    /* global Symbol */\n// Defining this global in .eslintrc.json would create a danger of using the global\n// unguarded in another place, it seems safer to define global only for this module\n\n\n\n    var version = \"3.7.1\",\n\n        rhtmlSuffix = /HTML$/i,\n\n        // Define a local copy of jQuery\n        jQuery = function( selector, context ) {\n\n            // The jQuery object is actually just the init constructor 'enhanced'\n            // Need init if jQuery is called (just allow error to be thrown if not included)\n            return new jQuery.fn.init( selector, context );\n        };\n\n    jQuery.fn = jQuery.prototype = {\n\n        // The current version of jQuery being used\n        jquery: version,\n\n        constructor: jQuery,\n\n        // The default length of a jQuery object is 0\n        length: 0,\n\n        toArray: function() {\n            return slice.call( this );\n        },\n\n        // Get the Nth element in the matched element set OR\n        // Get the whole matched element set as a clean array\n        get: function( num ) {\n\n            // Return all the elements in a clean array\n            if ( num == null ) {\n                return slice.call( this );\n            }\n\n            // Return just the one element from the set\n            return num < 0 ? this[ num + this.length ] : this[ num ];\n        },\n\n        // Take an array of elements and push it onto the stack\n        // (returning the new matched element set)\n        pushStack: function( elems ) {\n\n            // Build a new jQuery matched element set\n            var ret = jQuery.merge( this.constructor(), elems );\n\n            // Add the old object onto the stack (as a reference)\n            ret.prevObject = this;\n\n            // Return the newly-formed element set\n            return ret;\n        },\n\n        // Execute a callback for every element in the matched set.\n        each: function( callback ) {\n            return jQuery.each( this, callback );\n        },\n\n        map: function( callback ) {\n            return this.pushStack( jQuery.map( this, function( elem, i ) {\n                return callback.call( elem, i, elem );\n            } ) );\n        },\n\n        slice: function() {\n            return this.pushStack( slice.apply( this, arguments ) );\n        },\n\n        first: function() {\n            return this.eq( 0 );\n        },\n\n        last: function() {\n            return this.eq( -1 );\n        },\n\n        even: function() {\n            return this.pushStack( jQuery.grep( this, function( _elem, i ) {\n                return ( i + 1 ) % 2;\n            } ) );\n        },\n\n        odd: function() {\n            return this.pushStack( jQuery.grep( this, function( _elem, i ) {\n                return i % 2;\n            } ) );\n        },\n\n        eq: function( i ) {\n            var len = this.length,\n                j = +i + ( i < 0 ? len : 0 );\n            return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );\n        },\n\n        end: function() {\n            return this.prevObject || this.constructor();\n        },\n\n        // For internal use only.\n        // Behaves like an Array's method, not like a jQuery method.\n        push: push,\n        sort: arr.sort,\n        splice: arr.splice\n    };\n\n    jQuery.extend = jQuery.fn.extend = function() {\n        var options, name, src, copy, copyIsArray, clone,\n            target = arguments[ 0 ] || {},\n            i = 1,\n            length = arguments.length,\n            deep = false;\n\n        // Handle a deep copy situation\n        if ( typeof target === \"boolean\" ) {\n            deep = target;\n\n            // Skip the boolean and the target\n            target = arguments[ i ] || {};\n            i++;\n        }\n\n        // Handle case when target is a string or something (possible in deep copy)\n        if ( typeof target !== \"object\" && !isFunction( target ) ) {\n            target = {};\n        }\n\n        // Extend jQuery itself if only one argument is passed\n        if ( i === length ) {\n            target = this;\n            i--;\n        }\n\n        for ( ; i < length; i++ ) {\n\n            // Only deal with non-null/undefined values\n            if ( ( options = arguments[ i ] ) != null ) {\n\n                // Extend the base object\n                for ( name in options ) {\n                    copy = options[ name ];\n\n                    // Prevent Object.prototype pollution\n                    // Prevent never-ending loop\n                    if ( name === \"__proto__\" || target === copy ) {\n                        continue;\n                    }\n\n                    // Recurse if we're merging plain objects or arrays\n                    if ( deep && copy && ( jQuery.isPlainObject( copy ) ||\n                        ( copyIsArray = Array.isArray( copy ) ) ) ) {\n                        src = target[ name ];\n\n                        // Ensure proper type for the source value\n                        if ( copyIsArray && !Array.isArray( src ) ) {\n                            clone = [];\n                        } else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {\n                            clone = {};\n                        } else {\n                            clone = src;\n                        }\n                        copyIsArray = false;\n\n                        // Never move original objects, clone them\n                        target[ name ] = jQuery.extend( deep, clone, copy );\n\n                        // Don't bring in undefined values\n                    } else if ( copy !== undefined ) {\n                        target[ name ] = copy;\n                    }\n                }\n            }\n        }\n\n        // Return the modified object\n        return target;\n    };\n\n    jQuery.extend( {\n\n        // Unique for each copy of jQuery on the page\n        expando: \"jQuery\" + ( version + Math.random() ).replace( /\\D/g, \"\" ),\n\n        // Assume jQuery is ready without the ready module\n        isReady: true,\n\n        error: function( msg ) {\n            throw new Error( msg );\n        },\n\n        noop: function() {},\n\n        isPlainObject: function( obj ) {\n            var proto, Ctor;\n\n            // Detect obvious negatives\n            // Use toString instead of jQuery.type to catch host objects\n            if ( !obj || toString.call( obj ) !== \"[object Object]\" ) {\n                return false;\n            }\n\n            proto = getProto( obj );\n\n            // Objects with no prototype (e.g., `Object.create( null )`) are plain\n            if ( !proto ) {\n                return true;\n            }\n\n            // Objects with prototype are plain iff they were constructed by a global Object function\n            Ctor = hasOwn.call( proto, \"constructor\" ) && proto.constructor;\n            return typeof Ctor === \"function\" && fnToString.call( Ctor ) === ObjectFunctionString;\n        },\n\n        isEmptyObject: function( obj ) {\n            var name;\n\n            for ( name in obj ) {\n                return false;\n            }\n            return true;\n        },\n\n        // Evaluates a script in a provided context; falls back to the global one\n        // if not specified.\n        globalEval: function( code, options, doc ) {\n            DOMEval( code, { nonce: options && options.nonce }, doc );\n        },\n\n        each: function( obj, callback ) {\n            var length, i = 0;\n\n            if ( isArrayLike( obj ) ) {\n                length = obj.length;\n                for ( ; i < length; i++ ) {\n                    if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n                        break;\n                    }\n                }\n            } else {\n                for ( i in obj ) {\n                    if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {\n                        break;\n                    }\n                }\n            }\n\n            return obj;\n        },\n\n\n        // Retrieve the text value of an array of DOM nodes\n        text: function( elem ) {\n            var node,\n                ret = \"\",\n                i = 0,\n                nodeType = elem.nodeType;\n\n            if ( !nodeType ) {\n\n                // If no nodeType, this is expected to be an array\n                while ( ( node = elem[ i++ ] ) ) {\n\n                    // Do not traverse comment nodes\n                    ret += jQuery.text( node );\n                }\n            }\n            if ( nodeType === 1 || nodeType === 11 ) {\n                return elem.textContent;\n            }\n            if ( nodeType === 9 ) {\n                return elem.documentElement.textContent;\n            }\n            if ( nodeType === 3 || nodeType === 4 ) {\n                return elem.nodeValue;\n            }\n\n            // Do not include comment or processing instruction nodes\n\n            return ret;\n        },\n\n        // results is for internal usage only\n        makeArray: function( arr, results ) {\n            var ret = results || [];\n\n            if ( arr != null ) {\n                if ( isArrayLike( Object( arr ) ) ) {\n                    jQuery.merge( ret,\n                        typeof arr === \"string\" ?\n                            [ arr ] : arr\n                    );\n                } else {\n                    push.call( ret, arr );\n                }\n            }\n\n            return ret;\n        },\n\n        inArray: function( elem, arr, i ) {\n            return arr == null ? -1 : indexOf.call( arr, elem, i );\n        },\n\n        isXMLDoc: function( elem ) {\n            var namespace = elem && elem.namespaceURI,\n                docElem = elem && ( elem.ownerDocument || elem ).documentElement;\n\n            // Assume HTML when documentElement doesn't yet exist, such as inside\n            // document fragments.\n            return !rhtmlSuffix.test( namespace || docElem && docElem.nodeName || \"HTML\" );\n        },\n\n        // Support: Android <=4.0 only, PhantomJS 1 only\n        // push.apply(_, arraylike) throws on ancient WebKit\n        merge: function( first, second ) {\n            var len = +second.length,\n                j = 0,\n                i = first.length;\n\n            for ( ; j < len; j++ ) {\n                first[ i++ ] = second[ j ];\n            }\n\n            first.length = i;\n\n            return first;\n        },\n\n        grep: function( elems, callback, invert ) {\n            var callbackInverse,\n                matches = [],\n                i = 0,\n                length = elems.length,\n                callbackExpect = !invert;\n\n            // Go through the array, only saving the items\n            // that pass the validator function\n            for ( ; i < length; i++ ) {\n                callbackInverse = !callback( elems[ i ], i );\n                if ( callbackInverse !== callbackExpect ) {\n                    matches.push( elems[ i ] );\n                }\n            }\n\n            return matches;\n        },\n\n        // arg is for internal usage only\n        map: function( elems, callback, arg ) {\n            var length, value,\n                i = 0,\n                ret = [];\n\n            // Go through the array, translating each of the items to their new values\n            if ( isArrayLike( elems ) ) {\n                length = elems.length;\n                for ( ; i < length; i++ ) {\n                    value = callback( elems[ i ], i, arg );\n\n                    if ( value != null ) {\n                        ret.push( value );\n                    }\n                }\n\n                // Go through every key on the object,\n            } else {\n                for ( i in elems ) {\n                    value = callback( elems[ i ], i, arg );\n\n                    if ( value != null ) {\n                        ret.push( value );\n                    }\n                }\n            }\n\n            // Flatten any nested arrays\n            return flat( ret );\n        },\n\n        // A global GUID counter for objects\n        guid: 1,\n\n        // jQuery.support is not used in Core but other projects attach their\n        // properties to it so it needs to exist.\n        support: support\n    } );\n\n    if ( typeof Symbol === \"function\" ) {\n        jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];\n    }\n\n// Populate the class2type map\n    jQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n        function( _i, name ) {\n            class2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n        } );\n\n    function isArrayLike( obj ) {\n\n        // Support: real iOS 8.2 only (not reproducible in simulator)\n        // `in` check used to prevent JIT error (gh-2145)\n        // hasOwn isn't used here due to false negatives\n        // regarding Nodelist length in IE\n        var length = !!obj && \"length\" in obj && obj.length,\n            type = toType( obj );\n\n        if ( isFunction( obj ) || isWindow( obj ) ) {\n            return false;\n        }\n\n        return type === \"array\" || length === 0 ||\n            typeof length === \"number\" && length > 0 && ( length - 1 ) in obj;\n    }\n\n\n    function nodeName( elem, name ) {\n\n        return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n\n    }\n    var pop = arr.pop;\n\n\n    var sort = arr.sort;\n\n\n    var splice = arr.splice;\n\n\n    var whitespace = \"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\";\n\n\n    var rtrimCSS = new RegExp(\n        \"^\" + whitespace + \"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\" + whitespace + \"+$\",\n        \"g\"\n    );\n\n\n\n\n// Note: an element does not contain itself\n    jQuery.contains = function( a, b ) {\n        var bup = b && b.parentNode;\n\n        return a === bup || !!( bup && bup.nodeType === 1 && (\n\n            // Support: IE 9 - 11+\n            // IE doesn't have `contains` on SVG.\n            a.contains ?\n                a.contains( bup ) :\n                a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16\n        ) );\n    };\n\n\n\n\n// CSS string/identifier serialization\n// https://drafts.csswg.org/cssom/#common-serializing-idioms\n    var rcssescape = /([\\0-\\x1f\\x7f]|^-?\\d)|^-$|[^\\x80-\\uFFFF\\w-]/g;\n\n    function fcssescape( ch, asCodePoint ) {\n        if ( asCodePoint ) {\n\n            // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER\n            if ( ch === \"\\0\" ) {\n                return \"\\uFFFD\";\n            }\n\n            // Control characters and (dependent upon position) numbers get escaped as code points\n            return ch.slice( 0, -1 ) + \"\\\\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + \" \";\n        }\n\n        // Other potentially-special ASCII characters get backslash-escaped\n        return \"\\\\\" + ch;\n    }\n\n    jQuery.escapeSelector = function( sel ) {\n        return ( sel + \"\" ).replace( rcssescape, fcssescape );\n    };\n\n\n\n\n    var preferredDoc = document,\n        pushNative = push;\n\n    ( function() {\n\n        var i,\n            Expr,\n            outermostContext,\n            sortInput,\n            hasDuplicate,\n            push = pushNative,\n\n            // Local document vars\n            document,\n            documentElement,\n            documentIsHTML,\n            rbuggyQSA,\n            matches,\n\n            // Instance-specific data\n            expando = jQuery.expando,\n            dirruns = 0,\n            done = 0,\n            classCache = createCache(),\n            tokenCache = createCache(),\n            compilerCache = createCache(),\n            nonnativeSelectorCache = createCache(),\n            sortOrder = function( a, b ) {\n                if ( a === b ) {\n                    hasDuplicate = true;\n                }\n                return 0;\n            },\n\n            booleans = \"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|\" +\n                \"loop|multiple|open|readonly|required|scoped\",\n\n            // Regular expressions\n\n            // https://www.w3.org/TR/css-syntax-3/#ident-token-diagram\n            identifier = \"(?:\\\\\\\\[\\\\da-fA-F]{1,6}\" + whitespace +\n                \"?|\\\\\\\\[^\\\\r\\\\n\\\\f]|[\\\\w-]|[^\\0-\\\\x7f])+\",\n\n            // Attribute selectors: https://www.w3.org/TR/selectors/#attribute-selectors\n            attributes = \"\\\\[\" + whitespace + \"*(\" + identifier + \")(?:\" + whitespace +\n\n                // Operator (capture 2)\n                \"*([*^$|!~]?=)\" + whitespace +\n\n                // \"Attribute values must be CSS identifiers [capture 5] or strings [capture 3 or capture 4]\"\n                \"*(?:'((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\"|(\" + identifier + \"))|)\" +\n                whitespace + \"*\\\\]\",\n\n            pseudos = \":(\" + identifier + \")(?:\\\\((\" +\n\n                // To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:\n                // 1. quoted (capture 3; capture 4 or capture 5)\n                \"('((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\")|\" +\n\n                // 2. simple (capture 6)\n                \"((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\" + attributes + \")*)|\" +\n\n                // 3. anything else (capture 2)\n                \".*\" +\n                \")\\\\)|)\",\n\n            // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter\n            rwhitespace = new RegExp( whitespace + \"+\", \"g\" ),\n\n            rcomma = new RegExp( \"^\" + whitespace + \"*,\" + whitespace + \"*\" ),\n            rleadingCombinator = new RegExp( \"^\" + whitespace + \"*([>+~]|\" + whitespace + \")\" +\n                whitespace + \"*\" ),\n            rdescend = new RegExp( whitespace + \"|>\" ),\n\n            rpseudo = new RegExp( pseudos ),\n            ridentifier = new RegExp( \"^\" + identifier + \"$\" ),\n\n            matchExpr = {\n                ID: new RegExp( \"^#(\" + identifier + \")\" ),\n                CLASS: new RegExp( \"^\\\\.(\" + identifier + \")\" ),\n                TAG: new RegExp( \"^(\" + identifier + \"|[*])\" ),\n                ATTR: new RegExp( \"^\" + attributes ),\n                PSEUDO: new RegExp( \"^\" + pseudos ),\n                CHILD: new RegExp(\n                    \"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\" +\n                    whitespace + \"*(even|odd|(([+-]|)(\\\\d*)n|)\" + whitespace + \"*(?:([+-]|)\" +\n                    whitespace + \"*(\\\\d+)|))\" + whitespace + \"*\\\\)|)\", \"i\" ),\n                bool: new RegExp( \"^(?:\" + booleans + \")$\", \"i\" ),\n\n                // For use in libraries implementing .is()\n                // We use this for POS matching in `select`\n                needsContext: new RegExp( \"^\" + whitespace +\n                    \"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\" + whitespace +\n                    \"*((?:-\\\\d)?\\\\d*)\" + whitespace + \"*\\\\)|)(?=[^-]|$)\", \"i\" )\n            },\n\n            rinputs = /^(?:input|select|textarea|button)$/i,\n            rheader = /^h\\d$/i,\n\n            // Easily-parseable/retrievable ID or TAG or CLASS selectors\n            rquickExpr = /^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,\n\n            rsibling = /[+~]/,\n\n            // CSS escapes\n            // https://www.w3.org/TR/CSS21/syndata.html#escaped-characters\n            runescape = new RegExp( \"\\\\\\\\[\\\\da-fA-F]{1,6}\" + whitespace +\n                \"?|\\\\\\\\([^\\\\r\\\\n\\\\f])\", \"g\" ),\n            funescape = function( escape, nonHex ) {\n                var high = \"0x\" + escape.slice( 1 ) - 0x10000;\n\n                if ( nonHex ) {\n\n                    // Strip the backslash prefix from a non-hex escape sequence\n                    return nonHex;\n                }\n\n                // Replace a hexadecimal escape sequence with the encoded Unicode code point\n                // Support: IE <=11+\n                // For values outside the Basic Multilingual Plane (BMP), manually construct a\n                // surrogate pair\n                return high < 0 ?\n                    String.fromCharCode( high + 0x10000 ) :\n                    String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );\n            },\n\n            // Used for iframes; see `setDocument`.\n            // Support: IE 9 - 11+, Edge 12 - 18+\n            // Removing the function wrapper causes a \"Permission Denied\"\n            // error in IE/Edge.\n            unloadHandler = function() {\n                setDocument();\n            },\n\n            inDisabledFieldset = addCombinator(\n                function( elem ) {\n                    return elem.disabled === true && nodeName( elem, \"fieldset\" );\n                },\n                { dir: \"parentNode\", next: \"legend\" }\n            );\n\n// Support: IE <=9 only\n// Accessing document.activeElement can throw unexpectedly\n// https://bugs.jquery.com/ticket/13393\n        function safeActiveElement() {\n            try {\n                return document.activeElement;\n            } catch ( err ) { }\n        }\n\n// Optimize for push.apply( _, NodeList )\n        try {\n            push.apply(\n                ( arr = slice.call( preferredDoc.childNodes ) ),\n                preferredDoc.childNodes\n            );\n\n            // Support: Android <=4.0\n            // Detect silently failing push.apply\n            // eslint-disable-next-line no-unused-expressions\n            arr[ preferredDoc.childNodes.length ].nodeType;\n        } catch ( e ) {\n            push = {\n                apply: function( target, els ) {\n                    pushNative.apply( target, slice.call( els ) );\n                },\n                call: function( target ) {\n                    pushNative.apply( target, slice.call( arguments, 1 ) );\n                }\n            };\n        }\n\n        function find( selector, context, results, seed ) {\n            var m, i, elem, nid, match, groups, newSelector,\n                newContext = context && context.ownerDocument,\n\n                // nodeType defaults to 9, since context defaults to document\n                nodeType = context ? context.nodeType : 9;\n\n            results = results || [];\n\n            // Return early from calls with invalid selector or context\n            if ( typeof selector !== \"string\" || !selector ||\n                nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {\n\n                return results;\n            }\n\n            // Try to shortcut find operations (as opposed to filters) in HTML documents\n            if ( !seed ) {\n                setDocument( context );\n                context = context || document;\n\n                if ( documentIsHTML ) {\n\n                    // If the selector is sufficiently simple, try using a \"get*By*\" DOM method\n                    // (excepting DocumentFragment context, where the methods don't exist)\n                    if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {\n\n                        // ID selector\n                        if ( ( m = match[ 1 ] ) ) {\n\n                            // Document context\n                            if ( nodeType === 9 ) {\n                                if ( ( elem = context.getElementById( m ) ) ) {\n\n                                    // Support: IE 9 only\n                                    // getElementById can match elements by name instead of ID\n                                    if ( elem.id === m ) {\n                                        push.call( results, elem );\n                                        return results;\n                                    }\n                                } else {\n                                    return results;\n                                }\n\n                                // Element context\n                            } else {\n\n                                // Support: IE 9 only\n                                // getElementById can match elements by name instead of ID\n                                if ( newContext && ( elem = newContext.getElementById( m ) ) &&\n                                    find.contains( context, elem ) &&\n                                    elem.id === m ) {\n\n                                    push.call( results, elem );\n                                    return results;\n                                }\n                            }\n\n                            // Type selector\n                        } else if ( match[ 2 ] ) {\n                            push.apply( results, context.getElementsByTagName( selector ) );\n                            return results;\n\n                            // Class selector\n                        } else if ( ( m = match[ 3 ] ) && context.getElementsByClassName ) {\n                            push.apply( results, context.getElementsByClassName( m ) );\n                            return results;\n                        }\n                    }\n\n                    // Take advantage of querySelectorAll\n                    if ( !nonnativeSelectorCache[ selector + \" \" ] &&\n                        ( !rbuggyQSA || !rbuggyQSA.test( selector ) ) ) {\n\n                        newSelector = selector;\n                        newContext = context;\n\n                        // qSA considers elements outside a scoping root when evaluating child or\n                        // descendant combinators, which is not what we want.\n                        // In such cases, we work around the behavior by prefixing every selector in the\n                        // list with an ID selector referencing the scope context.\n                        // The technique has to be used as well when a leading combinator is used\n                        // as such selectors are not recognized by querySelectorAll.\n                        // Thanks to Andrew Dupont for this technique.\n                        if ( nodeType === 1 &&\n                            ( rdescend.test( selector ) || rleadingCombinator.test( selector ) ) ) {\n\n                            // Expand context for sibling selectors\n                            newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||\n                                context;\n\n                            // We can use :scope instead of the ID hack if the browser\n                            // supports it & if we're not changing the context.\n                            // Support: IE 11+, Edge 17 - 18+\n                            // IE/Edge sometimes throw a \"Permission denied\" error when\n                            // strict-comparing two documents; shallow comparisons work.\n                            // eslint-disable-next-line eqeqeq\n                            if ( newContext != context || !support.scope ) {\n\n                                // Capture the context ID, setting it first if necessary\n                                if ( ( nid = context.getAttribute( \"id\" ) ) ) {\n                                    nid = jQuery.escapeSelector( nid );\n                                } else {\n                                    context.setAttribute( \"id\", ( nid = expando ) );\n                                }\n                            }\n\n                            // Prefix every selector in the list\n                            groups = tokenize( selector );\n                            i = groups.length;\n                            while ( i-- ) {\n                                groups[ i ] = ( nid ? \"#\" + nid : \":scope\" ) + \" \" +\n                                    toSelector( groups[ i ] );\n                            }\n                            newSelector = groups.join( \",\" );\n                        }\n\n                        try {\n                            push.apply( results,\n                                newContext.querySelectorAll( newSelector )\n                            );\n                            return results;\n                        } catch ( qsaError ) {\n                            nonnativeSelectorCache( selector, true );\n                        } finally {\n                            if ( nid === expando ) {\n                                context.removeAttribute( \"id\" );\n                            }\n                        }\n                    }\n                }\n            }\n\n            // All others\n            return select( selector.replace( rtrimCSS, \"$1\" ), context, results, seed );\n        }\n\n        /**\n         * Create key-value caches of limited size\n         * @returns {function(string, object)} Returns the Object data after storing it on itself with\n         *\tproperty name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)\n         *\tdeleting the oldest entry\n         */\n        function createCache() {\n            var keys = [];\n\n            function cache( key, value ) {\n\n                // Use (key + \" \") to avoid collision with native prototype properties\n                // (see https://github.com/jquery/sizzle/issues/157)\n                if ( keys.push( key + \" \" ) > Expr.cacheLength ) {\n\n                    // Only keep the most recent entries\n                    delete cache[ keys.shift() ];\n                }\n                return ( cache[ key + \" \" ] = value );\n            }\n            return cache;\n        }\n\n        /**\n         * Mark a function for special use by jQuery selector module\n         * @param {Function} fn The function to mark\n         */\n        function markFunction( fn ) {\n            fn[ expando ] = true;\n            return fn;\n        }\n\n        /**\n         * Support testing using an element\n         * @param {Function} fn Passed the created element and returns a boolean result\n         */\n        function assert( fn ) {\n            var el = document.createElement( \"fieldset\" );\n\n            try {\n                return !!fn( el );\n            } catch ( e ) {\n                return false;\n            } finally {\n\n                // Remove from its parent by default\n                if ( el.parentNode ) {\n                    el.parentNode.removeChild( el );\n                }\n\n                // release memory in IE\n                el = null;\n            }\n        }\n\n        /**\n         * Returns a function to use in pseudos for input types\n         * @param {String} type\n         */\n        function createInputPseudo( type ) {\n            return function( elem ) {\n                return nodeName( elem, \"input\" ) && elem.type === type;\n            };\n        }\n\n        /**\n         * Returns a function to use in pseudos for buttons\n         * @param {String} type\n         */\n        function createButtonPseudo( type ) {\n            return function( elem ) {\n                return ( nodeName( elem, \"input\" ) || nodeName( elem, \"button\" ) ) &&\n                    elem.type === type;\n            };\n        }\n\n        /**\n         * Returns a function to use in pseudos for :enabled/:disabled\n         * @param {Boolean} disabled true for :disabled; false for :enabled\n         */\n        function createDisabledPseudo( disabled ) {\n\n            // Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable\n            return function( elem ) {\n\n                // Only certain elements can match :enabled or :disabled\n                // https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled\n                // https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled\n                if ( \"form\" in elem ) {\n\n                    // Check for inherited disabledness on relevant non-disabled elements:\n                    // * listed form-associated elements in a disabled fieldset\n                    //   https://html.spec.whatwg.org/multipage/forms.html#category-listed\n                    //   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled\n                    // * option elements in a disabled optgroup\n                    //   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled\n                    // All such elements have a \"form\" property.\n                    if ( elem.parentNode && elem.disabled === false ) {\n\n                        // Option elements defer to a parent optgroup if present\n                        if ( \"label\" in elem ) {\n                            if ( \"label\" in elem.parentNode ) {\n                                return elem.parentNode.disabled === disabled;\n                            } else {\n                                return elem.disabled === disabled;\n                            }\n                        }\n\n                        // Support: IE 6 - 11+\n                        // Use the isDisabled shortcut property to check for disabled fieldset ancestors\n                        return elem.isDisabled === disabled ||\n\n                            // Where there is no isDisabled, check manually\n                            elem.isDisabled !== !disabled &&\n                            inDisabledFieldset( elem ) === disabled;\n                    }\n\n                    return elem.disabled === disabled;\n\n                    // Try to winnow out elements that can't be disabled before trusting the disabled property.\n                    // Some victims get caught in our net (label, legend, menu, track), but it shouldn't\n                    // even exist on them, let alone have a boolean value.\n                } else if ( \"label\" in elem ) {\n                    return elem.disabled === disabled;\n                }\n\n                // Remaining elements are neither :enabled nor :disabled\n                return false;\n            };\n        }\n\n        /**\n         * Returns a function to use in pseudos for positionals\n         * @param {Function} fn\n         */\n        function createPositionalPseudo( fn ) {\n            return markFunction( function( argument ) {\n                argument = +argument;\n                return markFunction( function( seed, matches ) {\n                    var j,\n                        matchIndexes = fn( [], seed.length, argument ),\n                        i = matchIndexes.length;\n\n                    // Match elements found at the specified indexes\n                    while ( i-- ) {\n                        if ( seed[ ( j = matchIndexes[ i ] ) ] ) {\n                            seed[ j ] = !( matches[ j ] = seed[ j ] );\n                        }\n                    }\n                } );\n            } );\n        }\n\n        /**\n         * Checks a node for validity as a jQuery selector context\n         * @param {Element|Object=} context\n         * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value\n         */\n        function testContext( context ) {\n            return context && typeof context.getElementsByTagName !== \"undefined\" && context;\n        }\n\n        /**\n         * Sets document-related variables once based on the current document\n         * @param {Element|Object} [node] An element or document object to use to set the document\n         * @returns {Object} Returns the current document\n         */\n        function setDocument( node ) {\n            var subWindow,\n                doc = node ? node.ownerDocument || node : preferredDoc;\n\n            // Return early if doc is invalid or already selected\n            // Support: IE 11+, Edge 17 - 18+\n            // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n            // two documents; shallow comparisons work.\n            // eslint-disable-next-line eqeqeq\n            if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {\n                return document;\n            }\n\n            // Update global variables\n            document = doc;\n            documentElement = document.documentElement;\n            documentIsHTML = !jQuery.isXMLDoc( document );\n\n            // Support: iOS 7 only, IE 9 - 11+\n            // Older browsers didn't support unprefixed `matches`.\n            matches = documentElement.matches ||\n                documentElement.webkitMatchesSelector ||\n                documentElement.msMatchesSelector;\n\n            // Support: IE 9 - 11+, Edge 12 - 18+\n            // Accessing iframe documents after unload throws \"permission denied\" errors\n            // (see trac-13936).\n            // Limit the fix to IE & Edge Legacy; despite Edge 15+ implementing `matches`,\n            // all IE 9+ and Edge Legacy versions implement `msMatchesSelector` as well.\n            if ( documentElement.msMatchesSelector &&\n\n                // Support: IE 11+, Edge 17 - 18+\n                // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                // two documents; shallow comparisons work.\n                // eslint-disable-next-line eqeqeq\n                preferredDoc != document &&\n                ( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {\n\n                // Support: IE 9 - 11+, Edge 12 - 18+\n                subWindow.addEventListener( \"unload\", unloadHandler );\n            }\n\n            // Support: IE <10\n            // Check if getElementById returns elements by name\n            // The broken getElementById methods don't pick up programmatically-set names,\n            // so use a roundabout getElementsByName test\n            support.getById = assert( function( el ) {\n                documentElement.appendChild( el ).id = jQuery.expando;\n                return !document.getElementsByName ||\n                    !document.getElementsByName( jQuery.expando ).length;\n            } );\n\n            // Support: IE 9 only\n            // Check to see if it's possible to do matchesSelector\n            // on a disconnected node.\n            support.disconnectedMatch = assert( function( el ) {\n                return matches.call( el, \"*\" );\n            } );\n\n            // Support: IE 9 - 11+, Edge 12 - 18+\n            // IE/Edge don't support the :scope pseudo-class.\n            support.scope = assert( function() {\n                return document.querySelectorAll( \":scope\" );\n            } );\n\n            // Support: Chrome 105 - 111 only, Safari 15.4 - 16.3 only\n            // Make sure the `:has()` argument is parsed unforgivingly.\n            // We include `*` in the test to detect buggy implementations that are\n            // _selectively_ forgiving (specifically when the list includes at least\n            // one valid selector).\n            // Note that we treat complete lack of support for `:has()` as if it were\n            // spec-compliant support, which is fine because use of `:has()` in such\n            // environments will fail in the qSA path and fall back to jQuery traversal\n            // anyway.\n            support.cssHas = assert( function() {\n                try {\n                    document.querySelector( \":has(*,:jqfake)\" );\n                    return false;\n                } catch ( e ) {\n                    return true;\n                }\n            } );\n\n            // ID filter and find\n            if ( support.getById ) {\n                Expr.filter.ID = function( id ) {\n                    var attrId = id.replace( runescape, funescape );\n                    return function( elem ) {\n                        return elem.getAttribute( \"id\" ) === attrId;\n                    };\n                };\n                Expr.find.ID = function( id, context ) {\n                    if ( typeof context.getElementById !== \"undefined\" && documentIsHTML ) {\n                        var elem = context.getElementById( id );\n                        return elem ? [ elem ] : [];\n                    }\n                };\n            } else {\n                Expr.filter.ID =  function( id ) {\n                    var attrId = id.replace( runescape, funescape );\n                    return function( elem ) {\n                        var node = typeof elem.getAttributeNode !== \"undefined\" &&\n                            elem.getAttributeNode( \"id\" );\n                        return node && node.value === attrId;\n                    };\n                };\n\n                // Support: IE 6 - 7 only\n                // getElementById is not reliable as a find shortcut\n                Expr.find.ID = function( id, context ) {\n                    if ( typeof context.getElementById !== \"undefined\" && documentIsHTML ) {\n                        var node, i, elems,\n                            elem = context.getElementById( id );\n\n                        if ( elem ) {\n\n                            // Verify the id attribute\n                            node = elem.getAttributeNode( \"id\" );\n                            if ( node && node.value === id ) {\n                                return [ elem ];\n                            }\n\n                            // Fall back on getElementsByName\n                            elems = context.getElementsByName( id );\n                            i = 0;\n                            while ( ( elem = elems[ i++ ] ) ) {\n                                node = elem.getAttributeNode( \"id\" );\n                                if ( node && node.value === id ) {\n                                    return [ elem ];\n                                }\n                            }\n                        }\n\n                        return [];\n                    }\n                };\n            }\n\n            // Tag\n            Expr.find.TAG = function( tag, context ) {\n                if ( typeof context.getElementsByTagName !== \"undefined\" ) {\n                    return context.getElementsByTagName( tag );\n\n                    // DocumentFragment nodes don't have gEBTN\n                } else {\n                    return context.querySelectorAll( tag );\n                }\n            };\n\n            // Class\n            Expr.find.CLASS = function( className, context ) {\n                if ( typeof context.getElementsByClassName !== \"undefined\" && documentIsHTML ) {\n                    return context.getElementsByClassName( className );\n                }\n            };\n\n            /* QSA/matchesSelector\n\t---------------------------------------------------------------------- */\n\n            // QSA and matchesSelector support\n\n            rbuggyQSA = [];\n\n            // Build QSA regex\n            // Regex strategy adopted from Diego Perini\n            assert( function( el ) {\n\n                var input;\n\n                documentElement.appendChild( el ).innerHTML =\n                    \"<a id='\" + expando + \"' href='' disabled='disabled'></a>\" +\n                    \"<select id='\" + expando + \"-\\r\\\\' disabled='disabled'>\" +\n                    \"<option selected=''></option></select>\";\n\n                // Support: iOS <=7 - 8 only\n                // Boolean attributes and \"value\" are not treated correctly in some XML documents\n                if ( !el.querySelectorAll( \"[selected]\" ).length ) {\n                    rbuggyQSA.push( \"\\\\[\" + whitespace + \"*(?:value|\" + booleans + \")\" );\n                }\n\n                // Support: iOS <=7 - 8 only\n                if ( !el.querySelectorAll( \"[id~=\" + expando + \"-]\" ).length ) {\n                    rbuggyQSA.push( \"~=\" );\n                }\n\n                // Support: iOS 8 only\n                // https://bugs.webkit.org/show_bug.cgi?id=136851\n                // In-page `selector#id sibling-combinator selector` fails\n                if ( !el.querySelectorAll( \"a#\" + expando + \"+*\" ).length ) {\n                    rbuggyQSA.push( \".#.+[+~]\" );\n                }\n\n                // Support: Chrome <=105+, Firefox <=104+, Safari <=15.4+\n                // In some of the document kinds, these selectors wouldn't work natively.\n                // This is probably OK but for backwards compatibility we want to maintain\n                // handling them through jQuery traversal in jQuery 3.x.\n                if ( !el.querySelectorAll( \":checked\" ).length ) {\n                    rbuggyQSA.push( \":checked\" );\n                }\n\n                // Support: Windows 8 Native Apps\n                // The type and name attributes are restricted during .innerHTML assignment\n                input = document.createElement( \"input\" );\n                input.setAttribute( \"type\", \"hidden\" );\n                el.appendChild( input ).setAttribute( \"name\", \"D\" );\n\n                // Support: IE 9 - 11+\n                // IE's :disabled selector does not pick up the children of disabled fieldsets\n                // Support: Chrome <=105+, Firefox <=104+, Safari <=15.4+\n                // In some of the document kinds, these selectors wouldn't work natively.\n                // This is probably OK but for backwards compatibility we want to maintain\n                // handling them through jQuery traversal in jQuery 3.x.\n                documentElement.appendChild( el ).disabled = true;\n                if ( el.querySelectorAll( \":disabled\" ).length !== 2 ) {\n                    rbuggyQSA.push( \":enabled\", \":disabled\" );\n                }\n\n                // Support: IE 11+, Edge 15 - 18+\n                // IE 11/Edge don't find elements on a `[name='']` query in some cases.\n                // Adding a temporary attribute to the document before the selection works\n                // around the issue.\n                // Interestingly, IE 10 & older don't seem to have the issue.\n                input = document.createElement( \"input\" );\n                input.setAttribute( \"name\", \"\" );\n                el.appendChild( input );\n                if ( !el.querySelectorAll( \"[name='']\" ).length ) {\n                    rbuggyQSA.push( \"\\\\[\" + whitespace + \"*name\" + whitespace + \"*=\" +\n                        whitespace + \"*(?:''|\\\"\\\")\" );\n                }\n            } );\n\n            if ( !support.cssHas ) {\n\n                // Support: Chrome 105 - 110+, Safari 15.4 - 16.3+\n                // Our regular `try-catch` mechanism fails to detect natively-unsupported\n                // pseudo-classes inside `:has()` (such as `:has(:contains(\"Foo\"))`)\n                // in browsers that parse the `:has()` argument as a forgiving selector list.\n                // https://drafts.csswg.org/selectors/#relational now requires the argument\n                // to be parsed unforgivingly, but browsers have not yet fully adjusted.\n                rbuggyQSA.push( \":has\" );\n            }\n\n            rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( \"|\" ) );\n\n            /* Sorting\n\t---------------------------------------------------------------------- */\n\n            // Document order sorting\n            sortOrder = function( a, b ) {\n\n                // Flag for duplicate removal\n                if ( a === b ) {\n                    hasDuplicate = true;\n                    return 0;\n                }\n\n                // Sort on method existence if only one input has compareDocumentPosition\n                var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;\n                if ( compare ) {\n                    return compare;\n                }\n\n                // Calculate position if both inputs belong to the same document\n                // Support: IE 11+, Edge 17 - 18+\n                // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                // two documents; shallow comparisons work.\n                // eslint-disable-next-line eqeqeq\n                compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?\n                    a.compareDocumentPosition( b ) :\n\n                    // Otherwise we know they are disconnected\n                    1;\n\n                // Disconnected nodes\n                if ( compare & 1 ||\n                    ( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {\n\n                    // Choose the first element that is related to our preferred document\n                    // Support: IE 11+, Edge 17 - 18+\n                    // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                    // two documents; shallow comparisons work.\n                    // eslint-disable-next-line eqeqeq\n                    if ( a === document || a.ownerDocument == preferredDoc &&\n                        find.contains( preferredDoc, a ) ) {\n                        return -1;\n                    }\n\n                    // Support: IE 11+, Edge 17 - 18+\n                    // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                    // two documents; shallow comparisons work.\n                    // eslint-disable-next-line eqeqeq\n                    if ( b === document || b.ownerDocument == preferredDoc &&\n                        find.contains( preferredDoc, b ) ) {\n                        return 1;\n                    }\n\n                    // Maintain original order\n                    return sortInput ?\n                        ( indexOf.call( sortInput, a ) - indexOf.call( sortInput, b ) ) :\n                        0;\n                }\n\n                return compare & 4 ? -1 : 1;\n            };\n\n            return document;\n        }\n\n        find.matches = function( expr, elements ) {\n            return find( expr, null, null, elements );\n        };\n\n        find.matchesSelector = function( elem, expr ) {\n            setDocument( elem );\n\n            if ( documentIsHTML &&\n                !nonnativeSelectorCache[ expr + \" \" ] &&\n                ( !rbuggyQSA || !rbuggyQSA.test( expr ) ) ) {\n\n                try {\n                    var ret = matches.call( elem, expr );\n\n                    // IE 9's matchesSelector returns false on disconnected nodes\n                    if ( ret || support.disconnectedMatch ||\n\n                        // As well, disconnected nodes are said to be in a document\n                        // fragment in IE 9\n                        elem.document && elem.document.nodeType !== 11 ) {\n                        return ret;\n                    }\n                } catch ( e ) {\n                    nonnativeSelectorCache( expr, true );\n                }\n            }\n\n            return find( expr, document, null, [ elem ] ).length > 0;\n        };\n\n        find.contains = function( context, elem ) {\n\n            // Set document vars if needed\n            // Support: IE 11+, Edge 17 - 18+\n            // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n            // two documents; shallow comparisons work.\n            // eslint-disable-next-line eqeqeq\n            if ( ( context.ownerDocument || context ) != document ) {\n                setDocument( context );\n            }\n            return jQuery.contains( context, elem );\n        };\n\n\n        find.attr = function( elem, name ) {\n\n            // Set document vars if needed\n            // Support: IE 11+, Edge 17 - 18+\n            // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n            // two documents; shallow comparisons work.\n            // eslint-disable-next-line eqeqeq\n            if ( ( elem.ownerDocument || elem ) != document ) {\n                setDocument( elem );\n            }\n\n            var fn = Expr.attrHandle[ name.toLowerCase() ],\n\n                // Don't get fooled by Object.prototype properties (see trac-13807)\n                val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?\n                    fn( elem, name, !documentIsHTML ) :\n                    undefined;\n\n            if ( val !== undefined ) {\n                return val;\n            }\n\n            return elem.getAttribute( name );\n        };\n\n        find.error = function( msg ) {\n            throw new Error( \"Syntax error, unrecognized expression: \" + msg );\n        };\n\n        /**\n         * Document sorting and removing duplicates\n         * @param {ArrayLike} results\n         */\n        jQuery.uniqueSort = function( results ) {\n            var elem,\n                duplicates = [],\n                j = 0,\n                i = 0;\n\n            // Unless we *know* we can detect duplicates, assume their presence\n            //\n            // Support: Android <=4.0+\n            // Testing for detecting duplicates is unpredictable so instead assume we can't\n            // depend on duplicate detection in all browsers without a stable sort.\n            hasDuplicate = !support.sortStable;\n            sortInput = !support.sortStable && slice.call( results, 0 );\n            sort.call( results, sortOrder );\n\n            if ( hasDuplicate ) {\n                while ( ( elem = results[ i++ ] ) ) {\n                    if ( elem === results[ i ] ) {\n                        j = duplicates.push( i );\n                    }\n                }\n                while ( j-- ) {\n                    splice.call( results, duplicates[ j ], 1 );\n                }\n            }\n\n            // Clear input after sorting to release objects\n            // See https://github.com/jquery/sizzle/pull/225\n            sortInput = null;\n\n            return results;\n        };\n\n        jQuery.fn.uniqueSort = function() {\n            return this.pushStack( jQuery.uniqueSort( slice.apply( this ) ) );\n        };\n\n        Expr = jQuery.expr = {\n\n            // Can be adjusted by the user\n            cacheLength: 50,\n\n            createPseudo: markFunction,\n\n            match: matchExpr,\n\n            attrHandle: {},\n\n            find: {},\n\n            relative: {\n                \">\": { dir: \"parentNode\", first: true },\n                \" \": { dir: \"parentNode\" },\n                \"+\": { dir: \"previousSibling\", first: true },\n                \"~\": { dir: \"previousSibling\" }\n            },\n\n            preFilter: {\n                ATTR: function( match ) {\n                    match[ 1 ] = match[ 1 ].replace( runescape, funescape );\n\n                    // Move the given value to match[3] whether quoted or unquoted\n                    match[ 3 ] = ( match[ 3 ] || match[ 4 ] || match[ 5 ] || \"\" )\n                        .replace( runescape, funescape );\n\n                    if ( match[ 2 ] === \"~=\" ) {\n                        match[ 3 ] = \" \" + match[ 3 ] + \" \";\n                    }\n\n                    return match.slice( 0, 4 );\n                },\n\n                CHILD: function( match ) {\n\n                    /* matches from matchExpr[\"CHILD\"]\n\t\t\t\t1 type (only|nth|...)\n\t\t\t\t2 what (child|of-type)\n\t\t\t\t3 argument (even|odd|\\d*|\\d*n([+-]\\d+)?|...)\n\t\t\t\t4 xn-component of xn+y argument ([+-]?\\d*n|)\n\t\t\t\t5 sign of xn-component\n\t\t\t\t6 x of xn-component\n\t\t\t\t7 sign of y-component\n\t\t\t\t8 y of y-component\n\t\t\t*/\n                    match[ 1 ] = match[ 1 ].toLowerCase();\n\n                    if ( match[ 1 ].slice( 0, 3 ) === \"nth\" ) {\n\n                        // nth-* requires argument\n                        if ( !match[ 3 ] ) {\n                            find.error( match[ 0 ] );\n                        }\n\n                        // numeric x and y parameters for Expr.filter.CHILD\n                        // remember that false/true cast respectively to 0/1\n                        match[ 4 ] = +( match[ 4 ] ?\n                                match[ 5 ] + ( match[ 6 ] || 1 ) :\n                                2 * ( match[ 3 ] === \"even\" || match[ 3 ] === \"odd\" )\n                        );\n                        match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === \"odd\" );\n\n                        // other types prohibit arguments\n                    } else if ( match[ 3 ] ) {\n                        find.error( match[ 0 ] );\n                    }\n\n                    return match;\n                },\n\n                PSEUDO: function( match ) {\n                    var excess,\n                        unquoted = !match[ 6 ] && match[ 2 ];\n\n                    if ( matchExpr.CHILD.test( match[ 0 ] ) ) {\n                        return null;\n                    }\n\n                    // Accept quoted arguments as-is\n                    if ( match[ 3 ] ) {\n                        match[ 2 ] = match[ 4 ] || match[ 5 ] || \"\";\n\n                        // Strip excess characters from unquoted arguments\n                    } else if ( unquoted && rpseudo.test( unquoted ) &&\n\n                        // Get excess from tokenize (recursively)\n                        ( excess = tokenize( unquoted, true ) ) &&\n\n                        // advance to the next closing parenthesis\n                        ( excess = unquoted.indexOf( \")\", unquoted.length - excess ) - unquoted.length ) ) {\n\n                        // excess is a negative index\n                        match[ 0 ] = match[ 0 ].slice( 0, excess );\n                        match[ 2 ] = unquoted.slice( 0, excess );\n                    }\n\n                    // Return only captures needed by the pseudo filter method (type and argument)\n                    return match.slice( 0, 3 );\n                }\n            },\n\n            filter: {\n\n                TAG: function( nodeNameSelector ) {\n                    var expectedNodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();\n                    return nodeNameSelector === \"*\" ?\n                        function() {\n                            return true;\n                        } :\n                        function( elem ) {\n                            return nodeName( elem, expectedNodeName );\n                        };\n                },\n\n                CLASS: function( className ) {\n                    var pattern = classCache[ className + \" \" ];\n\n                    return pattern ||\n                        ( pattern = new RegExp( \"(^|\" + whitespace + \")\" + className +\n                            \"(\" + whitespace + \"|$)\" ) ) &&\n                        classCache( className, function( elem ) {\n                            return pattern.test(\n                                typeof elem.className === \"string\" && elem.className ||\n                                typeof elem.getAttribute !== \"undefined\" &&\n                                elem.getAttribute( \"class\" ) ||\n                                \"\"\n                            );\n                        } );\n                },\n\n                ATTR: function( name, operator, check ) {\n                    return function( elem ) {\n                        var result = find.attr( elem, name );\n\n                        if ( result == null ) {\n                            return operator === \"!=\";\n                        }\n                        if ( !operator ) {\n                            return true;\n                        }\n\n                        result += \"\";\n\n                        if ( operator === \"=\" ) {\n                            return result === check;\n                        }\n                        if ( operator === \"!=\" ) {\n                            return result !== check;\n                        }\n                        if ( operator === \"^=\" ) {\n                            return check && result.indexOf( check ) === 0;\n                        }\n                        if ( operator === \"*=\" ) {\n                            return check && result.indexOf( check ) > -1;\n                        }\n                        if ( operator === \"$=\" ) {\n                            return check && result.slice( -check.length ) === check;\n                        }\n                        if ( operator === \"~=\" ) {\n                            return ( \" \" + result.replace( rwhitespace, \" \" ) + \" \" )\n                                .indexOf( check ) > -1;\n                        }\n                        if ( operator === \"|=\" ) {\n                            return result === check || result.slice( 0, check.length + 1 ) === check + \"-\";\n                        }\n\n                        return false;\n                    };\n                },\n\n                CHILD: function( type, what, _argument, first, last ) {\n                    var simple = type.slice( 0, 3 ) !== \"nth\",\n                        forward = type.slice( -4 ) !== \"last\",\n                        ofType = what === \"of-type\";\n\n                    return first === 1 && last === 0 ?\n\n                        // Shortcut for :nth-*(n)\n                        function( elem ) {\n                            return !!elem.parentNode;\n                        } :\n\n                        function( elem, _context, xml ) {\n                            var cache, outerCache, node, nodeIndex, start,\n                                dir = simple !== forward ? \"nextSibling\" : \"previousSibling\",\n                                parent = elem.parentNode,\n                                name = ofType && elem.nodeName.toLowerCase(),\n                                useCache = !xml && !ofType,\n                                diff = false;\n\n                            if ( parent ) {\n\n                                // :(first|last|only)-(child|of-type)\n                                if ( simple ) {\n                                    while ( dir ) {\n                                        node = elem;\n                                        while ( ( node = node[ dir ] ) ) {\n                                            if ( ofType ?\n                                                nodeName( node, name ) :\n                                                node.nodeType === 1 ) {\n\n                                                return false;\n                                            }\n                                        }\n\n                                        // Reverse direction for :only-* (if we haven't yet done so)\n                                        start = dir = type === \"only\" && !start && \"nextSibling\";\n                                    }\n                                    return true;\n                                }\n\n                                start = [ forward ? parent.firstChild : parent.lastChild ];\n\n                                // non-xml :nth-child(...) stores cache data on `parent`\n                                if ( forward && useCache ) {\n\n                                    // Seek `elem` from a previously-cached index\n                                    outerCache = parent[ expando ] || ( parent[ expando ] = {} );\n                                    cache = outerCache[ type ] || [];\n                                    nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n                                    diff = nodeIndex && cache[ 2 ];\n                                    node = nodeIndex && parent.childNodes[ nodeIndex ];\n\n                                    while ( ( node = ++nodeIndex && node && node[ dir ] ||\n\n                                        // Fallback to seeking `elem` from the start\n                                        ( diff = nodeIndex = 0 ) || start.pop() ) ) {\n\n                                        // When found, cache indexes on `parent` and break\n                                        if ( node.nodeType === 1 && ++diff && node === elem ) {\n                                            outerCache[ type ] = [ dirruns, nodeIndex, diff ];\n                                            break;\n                                        }\n                                    }\n\n                                } else {\n\n                                    // Use previously-cached element index if available\n                                    if ( useCache ) {\n                                        outerCache = elem[ expando ] || ( elem[ expando ] = {} );\n                                        cache = outerCache[ type ] || [];\n                                        nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];\n                                        diff = nodeIndex;\n                                    }\n\n                                    // xml :nth-child(...)\n                                    // or :nth-last-child(...) or :nth(-last)?-of-type(...)\n                                    if ( diff === false ) {\n\n                                        // Use the same loop as above to seek `elem` from the start\n                                        while ( ( node = ++nodeIndex && node && node[ dir ] ||\n                                            ( diff = nodeIndex = 0 ) || start.pop() ) ) {\n\n                                            if ( ( ofType ?\n                                                    nodeName( node, name ) :\n                                                    node.nodeType === 1 ) &&\n                                                ++diff ) {\n\n                                                // Cache the index of each encountered element\n                                                if ( useCache ) {\n                                                    outerCache = node[ expando ] ||\n                                                        ( node[ expando ] = {} );\n                                                    outerCache[ type ] = [ dirruns, diff ];\n                                                }\n\n                                                if ( node === elem ) {\n                                                    break;\n                                                }\n                                            }\n                                        }\n                                    }\n                                }\n\n                                // Incorporate the offset, then check against cycle size\n                                diff -= last;\n                                return diff === first || ( diff % first === 0 && diff / first >= 0 );\n                            }\n                        };\n                },\n\n                PSEUDO: function( pseudo, argument ) {\n\n                    // pseudo-class names are case-insensitive\n                    // https://www.w3.org/TR/selectors/#pseudo-classes\n                    // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters\n                    // Remember that setFilters inherits from pseudos\n                    var args,\n                        fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||\n                            find.error( \"unsupported pseudo: \" + pseudo );\n\n                    // The user may use createPseudo to indicate that\n                    // arguments are needed to create the filter function\n                    // just as jQuery does\n                    if ( fn[ expando ] ) {\n                        return fn( argument );\n                    }\n\n                    // But maintain support for old signatures\n                    if ( fn.length > 1 ) {\n                        args = [ pseudo, pseudo, \"\", argument ];\n                        return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?\n                            markFunction( function( seed, matches ) {\n                                var idx,\n                                    matched = fn( seed, argument ),\n                                    i = matched.length;\n                                while ( i-- ) {\n                                    idx = indexOf.call( seed, matched[ i ] );\n                                    seed[ idx ] = !( matches[ idx ] = matched[ i ] );\n                                }\n                            } ) :\n                            function( elem ) {\n                                return fn( elem, 0, args );\n                            };\n                    }\n\n                    return fn;\n                }\n            },\n\n            pseudos: {\n\n                // Potentially complex pseudos\n                not: markFunction( function( selector ) {\n\n                    // Trim the selector passed to compile\n                    // to avoid treating leading and trailing\n                    // spaces as combinators\n                    var input = [],\n                        results = [],\n                        matcher = compile( selector.replace( rtrimCSS, \"$1\" ) );\n\n                    return matcher[ expando ] ?\n                        markFunction( function( seed, matches, _context, xml ) {\n                            var elem,\n                                unmatched = matcher( seed, null, xml, [] ),\n                                i = seed.length;\n\n                            // Match elements unmatched by `matcher`\n                            while ( i-- ) {\n                                if ( ( elem = unmatched[ i ] ) ) {\n                                    seed[ i ] = !( matches[ i ] = elem );\n                                }\n                            }\n                        } ) :\n                        function( elem, _context, xml ) {\n                            input[ 0 ] = elem;\n                            matcher( input, null, xml, results );\n\n                            // Don't keep the element\n                            // (see https://github.com/jquery/sizzle/issues/299)\n                            input[ 0 ] = null;\n                            return !results.pop();\n                        };\n                } ),\n\n                has: markFunction( function( selector ) {\n                    return function( elem ) {\n                        return find( selector, elem ).length > 0;\n                    };\n                } ),\n\n                contains: markFunction( function( text ) {\n                    text = text.replace( runescape, funescape );\n                    return function( elem ) {\n                        return ( elem.textContent || jQuery.text( elem ) ).indexOf( text ) > -1;\n                    };\n                } ),\n\n                // \"Whether an element is represented by a :lang() selector\n                // is based solely on the element's language value\n                // being equal to the identifier C,\n                // or beginning with the identifier C immediately followed by \"-\".\n                // The matching of C against the element's language value is performed case-insensitively.\n                // The identifier C does not have to be a valid language name.\"\n                // https://www.w3.org/TR/selectors/#lang-pseudo\n                lang: markFunction( function( lang ) {\n\n                    // lang value must be a valid identifier\n                    if ( !ridentifier.test( lang || \"\" ) ) {\n                        find.error( \"unsupported lang: \" + lang );\n                    }\n                    lang = lang.replace( runescape, funescape ).toLowerCase();\n                    return function( elem ) {\n                        var elemLang;\n                        do {\n                            if ( ( elemLang = documentIsHTML ?\n                                elem.lang :\n                                elem.getAttribute( \"xml:lang\" ) || elem.getAttribute( \"lang\" ) ) ) {\n\n                                elemLang = elemLang.toLowerCase();\n                                return elemLang === lang || elemLang.indexOf( lang + \"-\" ) === 0;\n                            }\n                        } while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );\n                        return false;\n                    };\n                } ),\n\n                // Miscellaneous\n                target: function( elem ) {\n                    var hash = window.location && window.location.hash;\n                    return hash && hash.slice( 1 ) === elem.id;\n                },\n\n                root: function( elem ) {\n                    return elem === documentElement;\n                },\n\n                focus: function( elem ) {\n                    return elem === safeActiveElement() &&\n                        document.hasFocus() &&\n                        !!( elem.type || elem.href || ~elem.tabIndex );\n                },\n\n                // Boolean properties\n                enabled: createDisabledPseudo( false ),\n                disabled: createDisabledPseudo( true ),\n\n                checked: function( elem ) {\n\n                    // In CSS3, :checked should return both checked and selected elements\n                    // https://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked\n                    return ( nodeName( elem, \"input\" ) && !!elem.checked ) ||\n                        ( nodeName( elem, \"option\" ) && !!elem.selected );\n                },\n\n                selected: function( elem ) {\n\n                    // Support: IE <=11+\n                    // Accessing the selectedIndex property\n                    // forces the browser to treat the default option as\n                    // selected when in an optgroup.\n                    if ( elem.parentNode ) {\n                        // eslint-disable-next-line no-unused-expressions\n                        elem.parentNode.selectedIndex;\n                    }\n\n                    return elem.selected === true;\n                },\n\n                // Contents\n                empty: function( elem ) {\n\n                    // https://www.w3.org/TR/selectors/#empty-pseudo\n                    // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),\n                    //   but not by others (comment: 8; processing instruction: 7; etc.)\n                    // nodeType < 6 works because attributes (2) do not appear as children\n                    for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {\n                        if ( elem.nodeType < 6 ) {\n                            return false;\n                        }\n                    }\n                    return true;\n                },\n\n                parent: function( elem ) {\n                    return !Expr.pseudos.empty( elem );\n                },\n\n                // Element/input types\n                header: function( elem ) {\n                    return rheader.test( elem.nodeName );\n                },\n\n                input: function( elem ) {\n                    return rinputs.test( elem.nodeName );\n                },\n\n                button: function( elem ) {\n                    return nodeName( elem, \"input\" ) && elem.type === \"button\" ||\n                        nodeName( elem, \"button\" );\n                },\n\n                text: function( elem ) {\n                    var attr;\n                    return nodeName( elem, \"input\" ) && elem.type === \"text\" &&\n\n                        // Support: IE <10 only\n                        // New HTML5 attribute values (e.g., \"search\") appear\n                        // with elem.type === \"text\"\n                        ( ( attr = elem.getAttribute( \"type\" ) ) == null ||\n                            attr.toLowerCase() === \"text\" );\n                },\n\n                // Position-in-collection\n                first: createPositionalPseudo( function() {\n                    return [ 0 ];\n                } ),\n\n                last: createPositionalPseudo( function( _matchIndexes, length ) {\n                    return [ length - 1 ];\n                } ),\n\n                eq: createPositionalPseudo( function( _matchIndexes, length, argument ) {\n                    return [ argument < 0 ? argument + length : argument ];\n                } ),\n\n                even: createPositionalPseudo( function( matchIndexes, length ) {\n                    var i = 0;\n                    for ( ; i < length; i += 2 ) {\n                        matchIndexes.push( i );\n                    }\n                    return matchIndexes;\n                } ),\n\n                odd: createPositionalPseudo( function( matchIndexes, length ) {\n                    var i = 1;\n                    for ( ; i < length; i += 2 ) {\n                        matchIndexes.push( i );\n                    }\n                    return matchIndexes;\n                } ),\n\n                lt: createPositionalPseudo( function( matchIndexes, length, argument ) {\n                    var i;\n\n                    if ( argument < 0 ) {\n                        i = argument + length;\n                    } else if ( argument > length ) {\n                        i = length;\n                    } else {\n                        i = argument;\n                    }\n\n                    for ( ; --i >= 0; ) {\n                        matchIndexes.push( i );\n                    }\n                    return matchIndexes;\n                } ),\n\n                gt: createPositionalPseudo( function( matchIndexes, length, argument ) {\n                    var i = argument < 0 ? argument + length : argument;\n                    for ( ; ++i < length; ) {\n                        matchIndexes.push( i );\n                    }\n                    return matchIndexes;\n                } )\n            }\n        };\n\n        Expr.pseudos.nth = Expr.pseudos.eq;\n\n// Add button/input type pseudos\n        for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {\n            Expr.pseudos[ i ] = createInputPseudo( i );\n        }\n        for ( i in { submit: true, reset: true } ) {\n            Expr.pseudos[ i ] = createButtonPseudo( i );\n        }\n\n// Easy API for creating new setFilters\n        function setFilters() {}\n        setFilters.prototype = Expr.filters = Expr.pseudos;\n        Expr.setFilters = new setFilters();\n\n        function tokenize( selector, parseOnly ) {\n            var matched, match, tokens, type,\n                soFar, groups, preFilters,\n                cached = tokenCache[ selector + \" \" ];\n\n            if ( cached ) {\n                return parseOnly ? 0 : cached.slice( 0 );\n            }\n\n            soFar = selector;\n            groups = [];\n            preFilters = Expr.preFilter;\n\n            while ( soFar ) {\n\n                // Comma and first run\n                if ( !matched || ( match = rcomma.exec( soFar ) ) ) {\n                    if ( match ) {\n\n                        // Don't consume trailing commas as valid\n                        soFar = soFar.slice( match[ 0 ].length ) || soFar;\n                    }\n                    groups.push( ( tokens = [] ) );\n                }\n\n                matched = false;\n\n                // Combinators\n                if ( ( match = rleadingCombinator.exec( soFar ) ) ) {\n                    matched = match.shift();\n                    tokens.push( {\n                        value: matched,\n\n                        // Cast descendant combinators to space\n                        type: match[ 0 ].replace( rtrimCSS, \" \" )\n                    } );\n                    soFar = soFar.slice( matched.length );\n                }\n\n                // Filters\n                for ( type in Expr.filter ) {\n                    if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||\n                        ( match = preFilters[ type ]( match ) ) ) ) {\n                        matched = match.shift();\n                        tokens.push( {\n                            value: matched,\n                            type: type,\n                            matches: match\n                        } );\n                        soFar = soFar.slice( matched.length );\n                    }\n                }\n\n                if ( !matched ) {\n                    break;\n                }\n            }\n\n            // Return the length of the invalid excess\n            // if we're just parsing\n            // Otherwise, throw an error or return tokens\n            if ( parseOnly ) {\n                return soFar.length;\n            }\n\n            return soFar ?\n                find.error( selector ) :\n\n                // Cache the tokens\n                tokenCache( selector, groups ).slice( 0 );\n        }\n\n        function toSelector( tokens ) {\n            var i = 0,\n                len = tokens.length,\n                selector = \"\";\n            for ( ; i < len; i++ ) {\n                selector += tokens[ i ].value;\n            }\n            return selector;\n        }\n\n        function addCombinator( matcher, combinator, base ) {\n            var dir = combinator.dir,\n                skip = combinator.next,\n                key = skip || dir,\n                checkNonElements = base && key === \"parentNode\",\n                doneName = done++;\n\n            return combinator.first ?\n\n                // Check against closest ancestor/preceding element\n                function( elem, context, xml ) {\n                    while ( ( elem = elem[ dir ] ) ) {\n                        if ( elem.nodeType === 1 || checkNonElements ) {\n                            return matcher( elem, context, xml );\n                        }\n                    }\n                    return false;\n                } :\n\n                // Check against all ancestor/preceding elements\n                function( elem, context, xml ) {\n                    var oldCache, outerCache,\n                        newCache = [ dirruns, doneName ];\n\n                    // We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching\n                    if ( xml ) {\n                        while ( ( elem = elem[ dir ] ) ) {\n                            if ( elem.nodeType === 1 || checkNonElements ) {\n                                if ( matcher( elem, context, xml ) ) {\n                                    return true;\n                                }\n                            }\n                        }\n                    } else {\n                        while ( ( elem = elem[ dir ] ) ) {\n                            if ( elem.nodeType === 1 || checkNonElements ) {\n                                outerCache = elem[ expando ] || ( elem[ expando ] = {} );\n\n                                if ( skip && nodeName( elem, skip ) ) {\n                                    elem = elem[ dir ] || elem;\n                                } else if ( ( oldCache = outerCache[ key ] ) &&\n                                    oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {\n\n                                    // Assign to newCache so results back-propagate to previous elements\n                                    return ( newCache[ 2 ] = oldCache[ 2 ] );\n                                } else {\n\n                                    // Reuse newcache so results back-propagate to previous elements\n                                    outerCache[ key ] = newCache;\n\n                                    // A match means we're done; a fail means we have to keep checking\n                                    if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {\n                                        return true;\n                                    }\n                                }\n                            }\n                        }\n                    }\n                    return false;\n                };\n        }\n\n        function elementMatcher( matchers ) {\n            return matchers.length > 1 ?\n                function( elem, context, xml ) {\n                    var i = matchers.length;\n                    while ( i-- ) {\n                        if ( !matchers[ i ]( elem, context, xml ) ) {\n                            return false;\n                        }\n                    }\n                    return true;\n                } :\n                matchers[ 0 ];\n        }\n\n        function multipleContexts( selector, contexts, results ) {\n            var i = 0,\n                len = contexts.length;\n            for ( ; i < len; i++ ) {\n                find( selector, contexts[ i ], results );\n            }\n            return results;\n        }\n\n        function condense( unmatched, map, filter, context, xml ) {\n            var elem,\n                newUnmatched = [],\n                i = 0,\n                len = unmatched.length,\n                mapped = map != null;\n\n            for ( ; i < len; i++ ) {\n                if ( ( elem = unmatched[ i ] ) ) {\n                    if ( !filter || filter( elem, context, xml ) ) {\n                        newUnmatched.push( elem );\n                        if ( mapped ) {\n                            map.push( i );\n                        }\n                    }\n                }\n            }\n\n            return newUnmatched;\n        }\n\n        function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {\n            if ( postFilter && !postFilter[ expando ] ) {\n                postFilter = setMatcher( postFilter );\n            }\n            if ( postFinder && !postFinder[ expando ] ) {\n                postFinder = setMatcher( postFinder, postSelector );\n            }\n            return markFunction( function( seed, results, context, xml ) {\n                var temp, i, elem, matcherOut,\n                    preMap = [],\n                    postMap = [],\n                    preexisting = results.length,\n\n                    // Get initial elements from seed or context\n                    elems = seed ||\n                        multipleContexts( selector || \"*\",\n                            context.nodeType ? [ context ] : context, [] ),\n\n                    // Prefilter to get matcher input, preserving a map for seed-results synchronization\n                    matcherIn = preFilter && ( seed || !selector ) ?\n                        condense( elems, preMap, preFilter, context, xml ) :\n                        elems;\n\n                if ( matcher ) {\n\n                    // If we have a postFinder, or filtered seed, or non-seed postFilter\n                    // or preexisting results,\n                    matcherOut = postFinder || ( seed ? preFilter : preexisting || postFilter ) ?\n\n                        // ...intermediate processing is necessary\n                        [] :\n\n                        // ...otherwise use results directly\n                        results;\n\n                    // Find primary matches\n                    matcher( matcherIn, matcherOut, context, xml );\n                } else {\n                    matcherOut = matcherIn;\n                }\n\n                // Apply postFilter\n                if ( postFilter ) {\n                    temp = condense( matcherOut, postMap );\n                    postFilter( temp, [], context, xml );\n\n                    // Un-match failing elements by moving them back to matcherIn\n                    i = temp.length;\n                    while ( i-- ) {\n                        if ( ( elem = temp[ i ] ) ) {\n                            matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );\n                        }\n                    }\n                }\n\n                if ( seed ) {\n                    if ( postFinder || preFilter ) {\n                        if ( postFinder ) {\n\n                            // Get the final matcherOut by condensing this intermediate into postFinder contexts\n                            temp = [];\n                            i = matcherOut.length;\n                            while ( i-- ) {\n                                if ( ( elem = matcherOut[ i ] ) ) {\n\n                                    // Restore matcherIn since elem is not yet a final match\n                                    temp.push( ( matcherIn[ i ] = elem ) );\n                                }\n                            }\n                            postFinder( null, ( matcherOut = [] ), temp, xml );\n                        }\n\n                        // Move matched elements from seed to results to keep them synchronized\n                        i = matcherOut.length;\n                        while ( i-- ) {\n                            if ( ( elem = matcherOut[ i ] ) &&\n                                ( temp = postFinder ? indexOf.call( seed, elem ) : preMap[ i ] ) > -1 ) {\n\n                                seed[ temp ] = !( results[ temp ] = elem );\n                            }\n                        }\n                    }\n\n                    // Add elements to results, through postFinder if defined\n                } else {\n                    matcherOut = condense(\n                        matcherOut === results ?\n                            matcherOut.splice( preexisting, matcherOut.length ) :\n                            matcherOut\n                    );\n                    if ( postFinder ) {\n                        postFinder( null, results, matcherOut, xml );\n                    } else {\n                        push.apply( results, matcherOut );\n                    }\n                }\n            } );\n        }\n\n        function matcherFromTokens( tokens ) {\n            var checkContext, matcher, j,\n                len = tokens.length,\n                leadingRelative = Expr.relative[ tokens[ 0 ].type ],\n                implicitRelative = leadingRelative || Expr.relative[ \" \" ],\n                i = leadingRelative ? 1 : 0,\n\n                // The foundational matcher ensures that elements are reachable from top-level context(s)\n                matchContext = addCombinator( function( elem ) {\n                    return elem === checkContext;\n                }, implicitRelative, true ),\n                matchAnyContext = addCombinator( function( elem ) {\n                    return indexOf.call( checkContext, elem ) > -1;\n                }, implicitRelative, true ),\n                matchers = [ function( elem, context, xml ) {\n\n                    // Support: IE 11+, Edge 17 - 18+\n                    // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                    // two documents; shallow comparisons work.\n                    // eslint-disable-next-line eqeqeq\n                    var ret = ( !leadingRelative && ( xml || context != outermostContext ) ) || (\n                        ( checkContext = context ).nodeType ?\n                            matchContext( elem, context, xml ) :\n                            matchAnyContext( elem, context, xml ) );\n\n                    // Avoid hanging onto element\n                    // (see https://github.com/jquery/sizzle/issues/299)\n                    checkContext = null;\n                    return ret;\n                } ];\n\n            for ( ; i < len; i++ ) {\n                if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {\n                    matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];\n                } else {\n                    matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );\n\n                    // Return special upon seeing a positional matcher\n                    if ( matcher[ expando ] ) {\n\n                        // Find the next relative operator (if any) for proper handling\n                        j = ++i;\n                        for ( ; j < len; j++ ) {\n                            if ( Expr.relative[ tokens[ j ].type ] ) {\n                                break;\n                            }\n                        }\n                        return setMatcher(\n                            i > 1 && elementMatcher( matchers ),\n                            i > 1 && toSelector(\n\n                                // If the preceding token was a descendant combinator, insert an implicit any-element `*`\n                                tokens.slice( 0, i - 1 )\n                                    .concat( { value: tokens[ i - 2 ].type === \" \" ? \"*\" : \"\" } )\n                            ).replace( rtrimCSS, \"$1\" ),\n                            matcher,\n                            i < j && matcherFromTokens( tokens.slice( i, j ) ),\n                            j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),\n                            j < len && toSelector( tokens )\n                        );\n                    }\n                    matchers.push( matcher );\n                }\n            }\n\n            return elementMatcher( matchers );\n        }\n\n        function matcherFromGroupMatchers( elementMatchers, setMatchers ) {\n            var bySet = setMatchers.length > 0,\n                byElement = elementMatchers.length > 0,\n                superMatcher = function( seed, context, xml, results, outermost ) {\n                    var elem, j, matcher,\n                        matchedCount = 0,\n                        i = \"0\",\n                        unmatched = seed && [],\n                        setMatched = [],\n                        contextBackup = outermostContext,\n\n                        // We must always have either seed elements or outermost context\n                        elems = seed || byElement && Expr.find.TAG( \"*\", outermost ),\n\n                        // Use integer dirruns iff this is the outermost matcher\n                        dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),\n                        len = elems.length;\n\n                    if ( outermost ) {\n\n                        // Support: IE 11+, Edge 17 - 18+\n                        // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                        // two documents; shallow comparisons work.\n                        // eslint-disable-next-line eqeqeq\n                        outermostContext = context == document || context || outermost;\n                    }\n\n                    // Add elements passing elementMatchers directly to results\n                    // Support: iOS <=7 - 9 only\n                    // Tolerate NodeList properties (IE: \"length\"; Safari: <number>) matching\n                    // elements by id. (see trac-14142)\n                    for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {\n                        if ( byElement && elem ) {\n                            j = 0;\n\n                            // Support: IE 11+, Edge 17 - 18+\n                            // IE/Edge sometimes throw a \"Permission denied\" error when strict-comparing\n                            // two documents; shallow comparisons work.\n                            // eslint-disable-next-line eqeqeq\n                            if ( !context && elem.ownerDocument != document ) {\n                                setDocument( elem );\n                                xml = !documentIsHTML;\n                            }\n                            while ( ( matcher = elementMatchers[ j++ ] ) ) {\n                                if ( matcher( elem, context || document, xml ) ) {\n                                    push.call( results, elem );\n                                    break;\n                                }\n                            }\n                            if ( outermost ) {\n                                dirruns = dirrunsUnique;\n                            }\n                        }\n\n                        // Track unmatched elements for set filters\n                        if ( bySet ) {\n\n                            // They will have gone through all possible matchers\n                            if ( ( elem = !matcher && elem ) ) {\n                                matchedCount--;\n                            }\n\n                            // Lengthen the array for every element, matched or not\n                            if ( seed ) {\n                                unmatched.push( elem );\n                            }\n                        }\n                    }\n\n                    // `i` is now the count of elements visited above, and adding it to `matchedCount`\n                    // makes the latter nonnegative.\n                    matchedCount += i;\n\n                    // Apply set filters to unmatched elements\n                    // NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`\n                    // equals `i`), unless we didn't visit _any_ elements in the above loop because we have\n                    // no element matchers and no seed.\n                    // Incrementing an initially-string \"0\" `i` allows `i` to remain a string only in that\n                    // case, which will result in a \"00\" `matchedCount` that differs from `i` but is also\n                    // numerically zero.\n                    if ( bySet && i !== matchedCount ) {\n                        j = 0;\n                        while ( ( matcher = setMatchers[ j++ ] ) ) {\n                            matcher( unmatched, setMatched, context, xml );\n                        }\n\n                        if ( seed ) {\n\n                            // Reintegrate element matches to eliminate the need for sorting\n                            if ( matchedCount > 0 ) {\n                                while ( i-- ) {\n                                    if ( !( unmatched[ i ] || setMatched[ i ] ) ) {\n                                        setMatched[ i ] = pop.call( results );\n                                    }\n                                }\n                            }\n\n                            // Discard index placeholder values to get only actual matches\n                            setMatched = condense( setMatched );\n                        }\n\n                        // Add matches to results\n                        push.apply( results, setMatched );\n\n                        // Seedless set matches succeeding multiple successful matchers stipulate sorting\n                        if ( outermost && !seed && setMatched.length > 0 &&\n                            ( matchedCount + setMatchers.length ) > 1 ) {\n\n                            jQuery.uniqueSort( results );\n                        }\n                    }\n\n                    // Override manipulation of globals by nested matchers\n                    if ( outermost ) {\n                        dirruns = dirrunsUnique;\n                        outermostContext = contextBackup;\n                    }\n\n                    return unmatched;\n                };\n\n            return bySet ?\n                markFunction( superMatcher ) :\n                superMatcher;\n        }\n\n        function compile( selector, match /* Internal Use Only */ ) {\n            var i,\n                setMatchers = [],\n                elementMatchers = [],\n                cached = compilerCache[ selector + \" \" ];\n\n            if ( !cached ) {\n\n                // Generate a function of recursive functions that can be used to check each element\n                if ( !match ) {\n                    match = tokenize( selector );\n                }\n                i = match.length;\n                while ( i-- ) {\n                    cached = matcherFromTokens( match[ i ] );\n                    if ( cached[ expando ] ) {\n                        setMatchers.push( cached );\n                    } else {\n                        elementMatchers.push( cached );\n                    }\n                }\n\n                // Cache the compiled function\n                cached = compilerCache( selector,\n                    matcherFromGroupMatchers( elementMatchers, setMatchers ) );\n\n                // Save selector and tokenization\n                cached.selector = selector;\n            }\n            return cached;\n        }\n\n        /**\n         * A low-level selection function that works with jQuery's compiled\n         *  selector functions\n         * @param {String|Function} selector A selector or a pre-compiled\n         *  selector function built with jQuery selector compile\n         * @param {Element} context\n         * @param {Array} [results]\n         * @param {Array} [seed] A set of elements to match against\n         */\n        function select( selector, context, results, seed ) {\n            var i, tokens, token, type, find,\n                compiled = typeof selector === \"function\" && selector,\n                match = !seed && tokenize( ( selector = compiled.selector || selector ) );\n\n            results = results || [];\n\n            // Try to minimize operations if there is only one selector in the list and no seed\n            // (the latter of which guarantees us context)\n            if ( match.length === 1 ) {\n\n                // Reduce context if the leading compound selector is an ID\n                tokens = match[ 0 ] = match[ 0 ].slice( 0 );\n                if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === \"ID\" &&\n                    context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {\n\n                    context = ( Expr.find.ID(\n                        token.matches[ 0 ].replace( runescape, funescape ),\n                        context\n                    ) || [] )[ 0 ];\n                    if ( !context ) {\n                        return results;\n\n                        // Precompiled matchers will still verify ancestry, so step up a level\n                    } else if ( compiled ) {\n                        context = context.parentNode;\n                    }\n\n                    selector = selector.slice( tokens.shift().value.length );\n                }\n\n                // Fetch a seed set for right-to-left matching\n                i = matchExpr.needsContext.test( selector ) ? 0 : tokens.length;\n                while ( i-- ) {\n                    token = tokens[ i ];\n\n                    // Abort if we hit a combinator\n                    if ( Expr.relative[ ( type = token.type ) ] ) {\n                        break;\n                    }\n                    if ( ( find = Expr.find[ type ] ) ) {\n\n                        // Search, expanding context for leading sibling combinators\n                        if ( ( seed = find(\n                            token.matches[ 0 ].replace( runescape, funescape ),\n                            rsibling.test( tokens[ 0 ].type ) &&\n                            testContext( context.parentNode ) || context\n                        ) ) ) {\n\n                            // If seed is empty or no tokens remain, we can return early\n                            tokens.splice( i, 1 );\n                            selector = seed.length && toSelector( tokens );\n                            if ( !selector ) {\n                                push.apply( results, seed );\n                                return results;\n                            }\n\n                            break;\n                        }\n                    }\n                }\n            }\n\n            // Compile and execute a filtering function if one is not provided\n            // Provide `match` to avoid retokenization if we modified the selector above\n            ( compiled || compile( selector, match ) )(\n                seed,\n                context,\n                !documentIsHTML,\n                results,\n                !context || rsibling.test( selector ) && testContext( context.parentNode ) || context\n            );\n            return results;\n        }\n\n// One-time assignments\n\n// Support: Android <=4.0 - 4.1+\n// Sort stability\n        support.sortStable = expando.split( \"\" ).sort( sortOrder ).join( \"\" ) === expando;\n\n// Initialize against the default document\n        setDocument();\n\n// Support: Android <=4.0 - 4.1+\n// Detached nodes confoundingly follow *each other*\n        support.sortDetached = assert( function( el ) {\n\n            // Should return 1, but returns 4 (following)\n            return el.compareDocumentPosition( document.createElement( \"fieldset\" ) ) & 1;\n        } );\n\n        jQuery.find = find;\n\n// Deprecated\n        jQuery.expr[ \":\" ] = jQuery.expr.pseudos;\n        jQuery.unique = jQuery.uniqueSort;\n\n// These have always been private, but they used to be documented as part of\n// Sizzle so let's maintain them for now for backwards compatibility purposes.\n        find.compile = compile;\n        find.select = select;\n        find.setDocument = setDocument;\n        find.tokenize = tokenize;\n\n        find.escape = jQuery.escapeSelector;\n        find.getText = jQuery.text;\n        find.isXML = jQuery.isXMLDoc;\n        find.selectors = jQuery.expr;\n        find.support = jQuery.support;\n        find.uniqueSort = jQuery.uniqueSort;\n\n        /* eslint-enable */\n\n    } )();\n\n\n    var dir = function( elem, dir, until ) {\n        var matched = [],\n            truncate = until !== undefined;\n\n        while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {\n            if ( elem.nodeType === 1 ) {\n                if ( truncate && jQuery( elem ).is( until ) ) {\n                    break;\n                }\n                matched.push( elem );\n            }\n        }\n        return matched;\n    };\n\n\n    var siblings = function( n, elem ) {\n        var matched = [];\n\n        for ( ; n; n = n.nextSibling ) {\n            if ( n.nodeType === 1 && n !== elem ) {\n                matched.push( n );\n            }\n        }\n\n        return matched;\n    };\n\n\n    var rneedsContext = jQuery.expr.match.needsContext;\n\n    var rsingleTag = ( /^<([a-z][^\\/\\0>:\\x20\\t\\r\\n\\f]*)[\\x20\\t\\r\\n\\f]*\\/?>(?:<\\/\\1>|)$/i );\n\n\n\n// Implement the identical functionality for filter and not\n    function winnow( elements, qualifier, not ) {\n        if ( isFunction( qualifier ) ) {\n            return jQuery.grep( elements, function( elem, i ) {\n                return !!qualifier.call( elem, i, elem ) !== not;\n            } );\n        }\n\n        // Single element\n        if ( qualifier.nodeType ) {\n            return jQuery.grep( elements, function( elem ) {\n                return ( elem === qualifier ) !== not;\n            } );\n        }\n\n        // Arraylike of elements (jQuery, arguments, Array)\n        if ( typeof qualifier !== \"string\" ) {\n            return jQuery.grep( elements, function( elem ) {\n                return ( indexOf.call( qualifier, elem ) > -1 ) !== not;\n            } );\n        }\n\n        // Filtered directly for both simple and complex selectors\n        return jQuery.filter( qualifier, elements, not );\n    }\n\n    jQuery.filter = function( expr, elems, not ) {\n        var elem = elems[ 0 ];\n\n        if ( not ) {\n            expr = \":not(\" + expr + \")\";\n        }\n\n        if ( elems.length === 1 && elem.nodeType === 1 ) {\n            return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];\n        }\n\n        return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {\n            return elem.nodeType === 1;\n        } ) );\n    };\n\n    jQuery.fn.extend( {\n        find: function( selector ) {\n            var i, ret,\n                len = this.length,\n                self = this;\n\n            if ( typeof selector !== \"string\" ) {\n                return this.pushStack( jQuery( selector ).filter( function() {\n                    for ( i = 0; i < len; i++ ) {\n                        if ( jQuery.contains( self[ i ], this ) ) {\n                            return true;\n                        }\n                    }\n                } ) );\n            }\n\n            ret = this.pushStack( [] );\n\n            for ( i = 0; i < len; i++ ) {\n                jQuery.find( selector, self[ i ], ret );\n            }\n\n            return len > 1 ? jQuery.uniqueSort( ret ) : ret;\n        },\n        filter: function( selector ) {\n            return this.pushStack( winnow( this, selector || [], false ) );\n        },\n        not: function( selector ) {\n            return this.pushStack( winnow( this, selector || [], true ) );\n        },\n        is: function( selector ) {\n            return !!winnow(\n                this,\n\n                // If this is a positional/relative selector, check membership in the returned set\n                // so $(\"p:first\").is(\"p:last\") won't return true for a doc with two \"p\".\n                typeof selector === \"string\" && rneedsContext.test( selector ) ?\n                    jQuery( selector ) :\n                    selector || [],\n                false\n            ).length;\n        }\n    } );\n\n\n// Initialize a jQuery object\n\n\n// A central reference to the root jQuery(document)\n    var rootjQuery,\n\n        // A simple way to check for HTML strings\n        // Prioritize #id over <tag> to avoid XSS via location.hash (trac-9521)\n        // Strict HTML recognition (trac-11290: must start with <)\n        // Shortcut simple #id case for speed\n        rquickExpr = /^(?:\\s*(<[\\w\\W]+>)[^>]*|#([\\w-]+))$/,\n\n        init = jQuery.fn.init = function( selector, context, root ) {\n            var match, elem;\n\n            // HANDLE: $(\"\"), $(null), $(undefined), $(false)\n            if ( !selector ) {\n                return this;\n            }\n\n            // Method init() accepts an alternate rootjQuery\n            // so migrate can support jQuery.sub (gh-2101)\n            root = root || rootjQuery;\n\n            // Handle HTML strings\n            if ( typeof selector === \"string\" ) {\n                if ( selector[ 0 ] === \"<\" &&\n                    selector[ selector.length - 1 ] === \">\" &&\n                    selector.length >= 3 ) {\n\n                    // Assume that strings that start and end with <> are HTML and skip the regex check\n                    match = [ null, selector, null ];\n\n                } else {\n                    match = rquickExpr.exec( selector );\n                }\n\n                // Match html or make sure no context is specified for #id\n                if ( match && ( match[ 1 ] || !context ) ) {\n\n                    // HANDLE: $(html) -> $(array)\n                    if ( match[ 1 ] ) {\n                        context = context instanceof jQuery ? context[ 0 ] : context;\n\n                        // Option to run scripts is true for back-compat\n                        // Intentionally let the error be thrown if parseHTML is not present\n                        jQuery.merge( this, jQuery.parseHTML(\n                            match[ 1 ],\n                            context && context.nodeType ? context.ownerDocument || context : document,\n                            true\n                        ) );\n\n                        // HANDLE: $(html, props)\n                        if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {\n                            for ( match in context ) {\n\n                                // Properties of context are called as methods if possible\n                                if ( isFunction( this[ match ] ) ) {\n                                    this[ match ]( context[ match ] );\n\n                                    // ...and otherwise set as attributes\n                                } else {\n                                    this.attr( match, context[ match ] );\n                                }\n                            }\n                        }\n\n                        return this;\n\n                        // HANDLE: $(#id)\n                    } else {\n                        elem = document.getElementById( match[ 2 ] );\n\n                        if ( elem ) {\n\n                            // Inject the element directly into the jQuery object\n                            this[ 0 ] = elem;\n                            this.length = 1;\n                        }\n                        return this;\n                    }\n\n                    // HANDLE: $(expr, $(...))\n                } else if ( !context || context.jquery ) {\n                    return ( context || root ).find( selector );\n\n                    // HANDLE: $(expr, context)\n                    // (which is just equivalent to: $(context).find(expr)\n                } else {\n                    return this.constructor( context ).find( selector );\n                }\n\n                // HANDLE: $(DOMElement)\n            } else if ( selector.nodeType ) {\n                this[ 0 ] = selector;\n                this.length = 1;\n                return this;\n\n                // HANDLE: $(function)\n                // Shortcut for document ready\n            } else if ( isFunction( selector ) ) {\n                return root.ready !== undefined ?\n                    root.ready( selector ) :\n\n                    // Execute immediately if ready is not present\n                    selector( jQuery );\n            }\n\n            return jQuery.makeArray( selector, this );\n        };\n\n// Give the init function the jQuery prototype for later instantiation\n    init.prototype = jQuery.fn;\n\n// Initialize central reference\n    rootjQuery = jQuery( document );\n\n\n    var rparentsprev = /^(?:parents|prev(?:Until|All))/,\n\n        // Methods guaranteed to produce a unique set when starting from a unique set\n        guaranteedUnique = {\n            children: true,\n            contents: true,\n            next: true,\n            prev: true\n        };\n\n    jQuery.fn.extend( {\n        has: function( target ) {\n            var targets = jQuery( target, this ),\n                l = targets.length;\n\n            return this.filter( function() {\n                var i = 0;\n                for ( ; i < l; i++ ) {\n                    if ( jQuery.contains( this, targets[ i ] ) ) {\n                        return true;\n                    }\n                }\n            } );\n        },\n\n        closest: function( selectors, context ) {\n            var cur,\n                i = 0,\n                l = this.length,\n                matched = [],\n                targets = typeof selectors !== \"string\" && jQuery( selectors );\n\n            // Positional selectors never match, since there's no _selection_ context\n            if ( !rneedsContext.test( selectors ) ) {\n                for ( ; i < l; i++ ) {\n                    for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {\n\n                        // Always skip document fragments\n                        if ( cur.nodeType < 11 && ( targets ?\n                            targets.index( cur ) > -1 :\n\n                            // Don't pass non-elements to jQuery#find\n                            cur.nodeType === 1 &&\n                            jQuery.find.matchesSelector( cur, selectors ) ) ) {\n\n                            matched.push( cur );\n                            break;\n                        }\n                    }\n                }\n            }\n\n            return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );\n        },\n\n        // Determine the position of an element within the set\n        index: function( elem ) {\n\n            // No argument, return index in parent\n            if ( !elem ) {\n                return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;\n            }\n\n            // Index in selector\n            if ( typeof elem === \"string\" ) {\n                return indexOf.call( jQuery( elem ), this[ 0 ] );\n            }\n\n            // Locate the position of the desired element\n            return indexOf.call( this,\n\n                // If it receives a jQuery object, the first element is used\n                elem.jquery ? elem[ 0 ] : elem\n            );\n        },\n\n        add: function( selector, context ) {\n            return this.pushStack(\n                jQuery.uniqueSort(\n                    jQuery.merge( this.get(), jQuery( selector, context ) )\n                )\n            );\n        },\n\n        addBack: function( selector ) {\n            return this.add( selector == null ?\n                this.prevObject : this.prevObject.filter( selector )\n            );\n        }\n    } );\n\n    function sibling( cur, dir ) {\n        while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}\n        return cur;\n    }\n\n    jQuery.each( {\n        parent: function( elem ) {\n            var parent = elem.parentNode;\n            return parent && parent.nodeType !== 11 ? parent : null;\n        },\n        parents: function( elem ) {\n            return dir( elem, \"parentNode\" );\n        },\n        parentsUntil: function( elem, _i, until ) {\n            return dir( elem, \"parentNode\", until );\n        },\n        next: function( elem ) {\n            return sibling( elem, \"nextSibling\" );\n        },\n        prev: function( elem ) {\n            return sibling( elem, \"previousSibling\" );\n        },\n        nextAll: function( elem ) {\n            return dir( elem, \"nextSibling\" );\n        },\n        prevAll: function( elem ) {\n            return dir( elem, \"previousSibling\" );\n        },\n        nextUntil: function( elem, _i, until ) {\n            return dir( elem, \"nextSibling\", until );\n        },\n        prevUntil: function( elem, _i, until ) {\n            return dir( elem, \"previousSibling\", until );\n        },\n        siblings: function( elem ) {\n            return siblings( ( elem.parentNode || {} ).firstChild, elem );\n        },\n        children: function( elem ) {\n            return siblings( elem.firstChild );\n        },\n        contents: function( elem ) {\n            if ( elem.contentDocument != null &&\n\n                // Support: IE 11+\n                // <object> elements with no `data` attribute has an object\n                // `contentDocument` with a `null` prototype.\n                getProto( elem.contentDocument ) ) {\n\n                return elem.contentDocument;\n            }\n\n            // Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only\n            // Treat the template element as a regular one in browsers that\n            // don't support it.\n            if ( nodeName( elem, \"template\" ) ) {\n                elem = elem.content || elem;\n            }\n\n            return jQuery.merge( [], elem.childNodes );\n        }\n    }, function( name, fn ) {\n        jQuery.fn[ name ] = function( until, selector ) {\n            var matched = jQuery.map( this, fn, until );\n\n            if ( name.slice( -5 ) !== \"Until\" ) {\n                selector = until;\n            }\n\n            if ( selector && typeof selector === \"string\" ) {\n                matched = jQuery.filter( selector, matched );\n            }\n\n            if ( this.length > 1 ) {\n\n                // Remove duplicates\n                if ( !guaranteedUnique[ name ] ) {\n                    jQuery.uniqueSort( matched );\n                }\n\n                // Reverse order for parents* and prev-derivatives\n                if ( rparentsprev.test( name ) ) {\n                    matched.reverse();\n                }\n            }\n\n            return this.pushStack( matched );\n        };\n    } );\n    var rnothtmlwhite = ( /[^\\x20\\t\\r\\n\\f]+/g );\n\n\n\n// Convert String-formatted options into Object-formatted ones\n    function createOptions( options ) {\n        var object = {};\n        jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {\n            object[ flag ] = true;\n        } );\n        return object;\n    }\n\n    /*\n * Create a callback list using the following parameters:\n *\n *\toptions: an optional list of space-separated options that will change how\n *\t\t\tthe callback list behaves or a more traditional option object\n *\n * By default a callback list will act like an event callback list and can be\n * \"fired\" multiple times.\n *\n * Possible options:\n *\n *\tonce:\t\t\twill ensure the callback list can only be fired once (like a Deferred)\n *\n *\tmemory:\t\t\twill keep track of previous values and will call any callback added\n *\t\t\t\t\tafter the list has been fired right away with the latest \"memorized\"\n *\t\t\t\t\tvalues (like a Deferred)\n *\n *\tunique:\t\t\twill ensure a callback can only be added once (no duplicate in the list)\n *\n *\tstopOnFalse:\tinterrupt callings when a callback returns false\n *\n */\n    jQuery.Callbacks = function( options ) {\n\n        // Convert options from String-formatted to Object-formatted if needed\n        // (we check in cache first)\n        options = typeof options === \"string\" ?\n            createOptions( options ) :\n            jQuery.extend( {}, options );\n\n        var // Flag to know if list is currently firing\n            firing,\n\n            // Last fire value for non-forgettable lists\n            memory,\n\n            // Flag to know if list was already fired\n            fired,\n\n            // Flag to prevent firing\n            locked,\n\n            // Actual callback list\n            list = [],\n\n            // Queue of execution data for repeatable lists\n            queue = [],\n\n            // Index of currently firing callback (modified by add/remove as needed)\n            firingIndex = -1,\n\n            // Fire callbacks\n            fire = function() {\n\n                // Enforce single-firing\n                locked = locked || options.once;\n\n                // Execute callbacks for all pending executions,\n                // respecting firingIndex overrides and runtime changes\n                fired = firing = true;\n                for ( ; queue.length; firingIndex = -1 ) {\n                    memory = queue.shift();\n                    while ( ++firingIndex < list.length ) {\n\n                        // Run callback and check for early termination\n                        if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&\n                            options.stopOnFalse ) {\n\n                            // Jump to end and forget the data so .add doesn't re-fire\n                            firingIndex = list.length;\n                            memory = false;\n                        }\n                    }\n                }\n\n                // Forget the data if we're done with it\n                if ( !options.memory ) {\n                    memory = false;\n                }\n\n                firing = false;\n\n                // Clean up if we're done firing for good\n                if ( locked ) {\n\n                    // Keep an empty list if we have data for future add calls\n                    if ( memory ) {\n                        list = [];\n\n                        // Otherwise, this object is spent\n                    } else {\n                        list = \"\";\n                    }\n                }\n            },\n\n            // Actual Callbacks object\n            self = {\n\n                // Add a callback or a collection of callbacks to the list\n                add: function() {\n                    if ( list ) {\n\n                        // If we have memory from a past run, we should fire after adding\n                        if ( memory && !firing ) {\n                            firingIndex = list.length - 1;\n                            queue.push( memory );\n                        }\n\n                        ( function add( args ) {\n                            jQuery.each( args, function( _, arg ) {\n                                if ( isFunction( arg ) ) {\n                                    if ( !options.unique || !self.has( arg ) ) {\n                                        list.push( arg );\n                                    }\n                                } else if ( arg && arg.length && toType( arg ) !== \"string\" ) {\n\n                                    // Inspect recursively\n                                    add( arg );\n                                }\n                            } );\n                        } )( arguments );\n\n                        if ( memory && !firing ) {\n                            fire();\n                        }\n                    }\n                    return this;\n                },\n\n                // Remove a callback from the list\n                remove: function() {\n                    jQuery.each( arguments, function( _, arg ) {\n                        var index;\n                        while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {\n                            list.splice( index, 1 );\n\n                            // Handle firing indexes\n                            if ( index <= firingIndex ) {\n                                firingIndex--;\n                            }\n                        }\n                    } );\n                    return this;\n                },\n\n                // Check if a given callback is in the list.\n                // If no argument is given, return whether or not list has callbacks attached.\n                has: function( fn ) {\n                    return fn ?\n                        jQuery.inArray( fn, list ) > -1 :\n                        list.length > 0;\n                },\n\n                // Remove all callbacks from the list\n                empty: function() {\n                    if ( list ) {\n                        list = [];\n                    }\n                    return this;\n                },\n\n                // Disable .fire and .add\n                // Abort any current/pending executions\n                // Clear all callbacks and values\n                disable: function() {\n                    locked = queue = [];\n                    list = memory = \"\";\n                    return this;\n                },\n                disabled: function() {\n                    return !list;\n                },\n\n                // Disable .fire\n                // Also disable .add unless we have memory (since it would have no effect)\n                // Abort any pending executions\n                lock: function() {\n                    locked = queue = [];\n                    if ( !memory && !firing ) {\n                        list = memory = \"\";\n                    }\n                    return this;\n                },\n                locked: function() {\n                    return !!locked;\n                },\n\n                // Call all callbacks with the given context and arguments\n                fireWith: function( context, args ) {\n                    if ( !locked ) {\n                        args = args || [];\n                        args = [ context, args.slice ? args.slice() : args ];\n                        queue.push( args );\n                        if ( !firing ) {\n                            fire();\n                        }\n                    }\n                    return this;\n                },\n\n                // Call all the callbacks with the given arguments\n                fire: function() {\n                    self.fireWith( this, arguments );\n                    return this;\n                },\n\n                // To know if the callbacks have already been called at least once\n                fired: function() {\n                    return !!fired;\n                }\n            };\n\n        return self;\n    };\n\n\n    function Identity( v ) {\n        return v;\n    }\n    function Thrower( ex ) {\n        throw ex;\n    }\n\n    function adoptValue( value, resolve, reject, noValue ) {\n        var method;\n\n        try {\n\n            // Check for promise aspect first to privilege synchronous behavior\n            if ( value && isFunction( ( method = value.promise ) ) ) {\n                method.call( value ).done( resolve ).fail( reject );\n\n                // Other thenables\n            } else if ( value && isFunction( ( method = value.then ) ) ) {\n                method.call( value, resolve, reject );\n\n                // Other non-thenables\n            } else {\n\n                // Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:\n                // * false: [ value ].slice( 0 ) => resolve( value )\n                // * true: [ value ].slice( 1 ) => resolve()\n                resolve.apply( undefined, [ value ].slice( noValue ) );\n            }\n\n            // For Promises/A+, convert exceptions into rejections\n            // Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in\n            // Deferred#then to conditionally suppress rejection.\n        } catch ( value ) {\n\n            // Support: Android 4.0 only\n            // Strict mode functions invoked without .call/.apply get global-object context\n            reject.apply( undefined, [ value ] );\n        }\n    }\n\n    jQuery.extend( {\n\n        Deferred: function( func ) {\n            var tuples = [\n\n                    // action, add listener, callbacks,\n                    // ... .then handlers, argument index, [final state]\n                    [ \"notify\", \"progress\", jQuery.Callbacks( \"memory\" ),\n                        jQuery.Callbacks( \"memory\" ), 2 ],\n                    [ \"resolve\", \"done\", jQuery.Callbacks( \"once memory\" ),\n                        jQuery.Callbacks( \"once memory\" ), 0, \"resolved\" ],\n                    [ \"reject\", \"fail\", jQuery.Callbacks( \"once memory\" ),\n                        jQuery.Callbacks( \"once memory\" ), 1, \"rejected\" ]\n                ],\n                state = \"pending\",\n                promise = {\n                    state: function() {\n                        return state;\n                    },\n                    always: function() {\n                        deferred.done( arguments ).fail( arguments );\n                        return this;\n                    },\n                    \"catch\": function( fn ) {\n                        return promise.then( null, fn );\n                    },\n\n                    // Keep pipe for back-compat\n                    pipe: function( /* fnDone, fnFail, fnProgress */ ) {\n                        var fns = arguments;\n\n                        return jQuery.Deferred( function( newDefer ) {\n                            jQuery.each( tuples, function( _i, tuple ) {\n\n                                // Map tuples (progress, done, fail) to arguments (done, fail, progress)\n                                var fn = isFunction( fns[ tuple[ 4 ] ] ) && fns[ tuple[ 4 ] ];\n\n                                // deferred.progress(function() { bind to newDefer or newDefer.notify })\n                                // deferred.done(function() { bind to newDefer or newDefer.resolve })\n                                // deferred.fail(function() { bind to newDefer or newDefer.reject })\n                                deferred[ tuple[ 1 ] ]( function() {\n                                    var returned = fn && fn.apply( this, arguments );\n                                    if ( returned && isFunction( returned.promise ) ) {\n                                        returned.promise()\n                                            .progress( newDefer.notify )\n                                            .done( newDefer.resolve )\n                                            .fail( newDefer.reject );\n                                    } else {\n                                        newDefer[ tuple[ 0 ] + \"With\" ](\n                                            this,\n                                            fn ? [ returned ] : arguments\n                                        );\n                                    }\n                                } );\n                            } );\n                            fns = null;\n                        } ).promise();\n                    },\n                    then: function( onFulfilled, onRejected, onProgress ) {\n                        var maxDepth = 0;\n                        function resolve( depth, deferred, handler, special ) {\n                            return function() {\n                                var that = this,\n                                    args = arguments,\n                                    mightThrow = function() {\n                                        var returned, then;\n\n                                        // Support: Promises/A+ section 2.3.3.3.3\n                                        // https://promisesaplus.com/#point-59\n                                        // Ignore double-resolution attempts\n                                        if ( depth < maxDepth ) {\n                                            return;\n                                        }\n\n                                        returned = handler.apply( that, args );\n\n                                        // Support: Promises/A+ section 2.3.1\n                                        // https://promisesaplus.com/#point-48\n                                        if ( returned === deferred.promise() ) {\n                                            throw new TypeError( \"Thenable self-resolution\" );\n                                        }\n\n                                        // Support: Promises/A+ sections 2.3.3.1, 3.5\n                                        // https://promisesaplus.com/#point-54\n                                        // https://promisesaplus.com/#point-75\n                                        // Retrieve `then` only once\n                                        then = returned &&\n\n                                            // Support: Promises/A+ section 2.3.4\n                                            // https://promisesaplus.com/#point-64\n                                            // Only check objects and functions for thenability\n                                            ( typeof returned === \"object\" ||\n                                                typeof returned === \"function\" ) &&\n                                            returned.then;\n\n                                        // Handle a returned thenable\n                                        if ( isFunction( then ) ) {\n\n                                            // Special processors (notify) just wait for resolution\n                                            if ( special ) {\n                                                then.call(\n                                                    returned,\n                                                    resolve( maxDepth, deferred, Identity, special ),\n                                                    resolve( maxDepth, deferred, Thrower, special )\n                                                );\n\n                                                // Normal processors (resolve) also hook into progress\n                                            } else {\n\n                                                // ...and disregard older resolution values\n                                                maxDepth++;\n\n                                                then.call(\n                                                    returned,\n                                                    resolve( maxDepth, deferred, Identity, special ),\n                                                    resolve( maxDepth, deferred, Thrower, special ),\n                                                    resolve( maxDepth, deferred, Identity,\n                                                        deferred.notifyWith )\n                                                );\n                                            }\n\n                                            // Handle all other returned values\n                                        } else {\n\n                                            // Only substitute handlers pass on context\n                                            // and multiple values (non-spec behavior)\n                                            if ( handler !== Identity ) {\n                                                that = undefined;\n                                                args = [ returned ];\n                                            }\n\n                                            // Process the value(s)\n                                            // Default process is resolve\n                                            ( special || deferred.resolveWith )( that, args );\n                                        }\n                                    },\n\n                                    // Only normal processors (resolve) catch and reject exceptions\n                                    process = special ?\n                                        mightThrow :\n                                        function() {\n                                            try {\n                                                mightThrow();\n                                            } catch ( e ) {\n\n                                                if ( jQuery.Deferred.exceptionHook ) {\n                                                    jQuery.Deferred.exceptionHook( e,\n                                                        process.error );\n                                                }\n\n                                                // Support: Promises/A+ section 2.3.3.3.4.1\n                                                // https://promisesaplus.com/#point-61\n                                                // Ignore post-resolution exceptions\n                                                if ( depth + 1 >= maxDepth ) {\n\n                                                    // Only substitute handlers pass on context\n                                                    // and multiple values (non-spec behavior)\n                                                    if ( handler !== Thrower ) {\n                                                        that = undefined;\n                                                        args = [ e ];\n                                                    }\n\n                                                    deferred.rejectWith( that, args );\n                                                }\n                                            }\n                                        };\n\n                                // Support: Promises/A+ section 2.3.3.3.1\n                                // https://promisesaplus.com/#point-57\n                                // Re-resolve promises immediately to dodge false rejection from\n                                // subsequent errors\n                                if ( depth ) {\n                                    process();\n                                } else {\n\n                                    // Call an optional hook to record the error, in case of exception\n                                    // since it's otherwise lost when execution goes async\n                                    if ( jQuery.Deferred.getErrorHook ) {\n                                        process.error = jQuery.Deferred.getErrorHook();\n\n                                        // The deprecated alias of the above. While the name suggests\n                                        // returning the stack, not an error instance, jQuery just passes\n                                        // it directly to `console.warn` so both will work; an instance\n                                        // just better cooperates with source maps.\n                                    } else if ( jQuery.Deferred.getStackHook ) {\n                                        process.error = jQuery.Deferred.getStackHook();\n                                    }\n                                    window.setTimeout( process );\n                                }\n                            };\n                        }\n\n                        return jQuery.Deferred( function( newDefer ) {\n\n                            // progress_handlers.add( ... )\n                            tuples[ 0 ][ 3 ].add(\n                                resolve(\n                                    0,\n                                    newDefer,\n                                    isFunction( onProgress ) ?\n                                        onProgress :\n                                        Identity,\n                                    newDefer.notifyWith\n                                )\n                            );\n\n                            // fulfilled_handlers.add( ... )\n                            tuples[ 1 ][ 3 ].add(\n                                resolve(\n                                    0,\n                                    newDefer,\n                                    isFunction( onFulfilled ) ?\n                                        onFulfilled :\n                                        Identity\n                                )\n                            );\n\n                            // rejected_handlers.add( ... )\n                            tuples[ 2 ][ 3 ].add(\n                                resolve(\n                                    0,\n                                    newDefer,\n                                    isFunction( onRejected ) ?\n                                        onRejected :\n                                        Thrower\n                                )\n                            );\n                        } ).promise();\n                    },\n\n                    // Get a promise for this deferred\n                    // If obj is provided, the promise aspect is added to the object\n                    promise: function( obj ) {\n                        return obj != null ? jQuery.extend( obj, promise ) : promise;\n                    }\n                },\n                deferred = {};\n\n            // Add list-specific methods\n            jQuery.each( tuples, function( i, tuple ) {\n                var list = tuple[ 2 ],\n                    stateString = tuple[ 5 ];\n\n                // promise.progress = list.add\n                // promise.done = list.add\n                // promise.fail = list.add\n                promise[ tuple[ 1 ] ] = list.add;\n\n                // Handle state\n                if ( stateString ) {\n                    list.add(\n                        function() {\n\n                            // state = \"resolved\" (i.e., fulfilled)\n                            // state = \"rejected\"\n                            state = stateString;\n                        },\n\n                        // rejected_callbacks.disable\n                        // fulfilled_callbacks.disable\n                        tuples[ 3 - i ][ 2 ].disable,\n\n                        // rejected_handlers.disable\n                        // fulfilled_handlers.disable\n                        tuples[ 3 - i ][ 3 ].disable,\n\n                        // progress_callbacks.lock\n                        tuples[ 0 ][ 2 ].lock,\n\n                        // progress_handlers.lock\n                        tuples[ 0 ][ 3 ].lock\n                    );\n                }\n\n                // progress_handlers.fire\n                // fulfilled_handlers.fire\n                // rejected_handlers.fire\n                list.add( tuple[ 3 ].fire );\n\n                // deferred.notify = function() { deferred.notifyWith(...) }\n                // deferred.resolve = function() { deferred.resolveWith(...) }\n                // deferred.reject = function() { deferred.rejectWith(...) }\n                deferred[ tuple[ 0 ] ] = function() {\n                    deferred[ tuple[ 0 ] + \"With\" ]( this === deferred ? undefined : this, arguments );\n                    return this;\n                };\n\n                // deferred.notifyWith = list.fireWith\n                // deferred.resolveWith = list.fireWith\n                // deferred.rejectWith = list.fireWith\n                deferred[ tuple[ 0 ] + \"With\" ] = list.fireWith;\n            } );\n\n            // Make the deferred a promise\n            promise.promise( deferred );\n\n            // Call given func if any\n            if ( func ) {\n                func.call( deferred, deferred );\n            }\n\n            // All done!\n            return deferred;\n        },\n\n        // Deferred helper\n        when: function( singleValue ) {\n            var\n\n                // count of uncompleted subordinates\n                remaining = arguments.length,\n\n                // count of unprocessed arguments\n                i = remaining,\n\n                // subordinate fulfillment data\n                resolveContexts = Array( i ),\n                resolveValues = slice.call( arguments ),\n\n                // the primary Deferred\n                primary = jQuery.Deferred(),\n\n                // subordinate callback factory\n                updateFunc = function( i ) {\n                    return function( value ) {\n                        resolveContexts[ i ] = this;\n                        resolveValues[ i ] = arguments.length > 1 ? slice.call( arguments ) : value;\n                        if ( !( --remaining ) ) {\n                            primary.resolveWith( resolveContexts, resolveValues );\n                        }\n                    };\n                };\n\n            // Single- and empty arguments are adopted like Promise.resolve\n            if ( remaining <= 1 ) {\n                adoptValue( singleValue, primary.done( updateFunc( i ) ).resolve, primary.reject,\n                    !remaining );\n\n                // Use .then() to unwrap secondary thenables (cf. gh-3000)\n                if ( primary.state() === \"pending\" ||\n                    isFunction( resolveValues[ i ] && resolveValues[ i ].then ) ) {\n\n                    return primary.then();\n                }\n            }\n\n            // Multiple arguments are aggregated like Promise.all array elements\n            while ( i-- ) {\n                adoptValue( resolveValues[ i ], updateFunc( i ), primary.reject );\n            }\n\n            return primary.promise();\n        }\n    } );\n\n\n// These usually indicate a programmer mistake during development,\n// warn about them ASAP rather than swallowing them by default.\n    var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;\n\n// If `jQuery.Deferred.getErrorHook` is defined, `asyncError` is an error\n// captured before the async barrier to get the original error cause\n// which may otherwise be hidden.\n    jQuery.Deferred.exceptionHook = function( error, asyncError ) {\n\n        // Support: IE 8 - 9 only\n        // Console exists when dev tools are open, which can happen at any time\n        if ( window.console && window.console.warn && error && rerrorNames.test( error.name ) ) {\n            window.console.warn( \"jQuery.Deferred exception: \" + error.message,\n                error.stack, asyncError );\n        }\n    };\n\n\n\n\n    jQuery.readyException = function( error ) {\n        window.setTimeout( function() {\n            throw error;\n        } );\n    };\n\n\n\n\n// The deferred used on DOM ready\n    var readyList = jQuery.Deferred();\n\n    jQuery.fn.ready = function( fn ) {\n\n        readyList\n            .then( fn )\n\n            // Wrap jQuery.readyException in a function so that the lookup\n            // happens at the time of error handling instead of callback\n            // registration.\n            .catch( function( error ) {\n                jQuery.readyException( error );\n            } );\n\n        return this;\n    };\n\n    jQuery.extend( {\n\n        // Is the DOM ready to be used? Set to true once it occurs.\n        isReady: false,\n\n        // A counter to track how many items to wait for before\n        // the ready event fires. See trac-6781\n        readyWait: 1,\n\n        // Handle when the DOM is ready\n        ready: function( wait ) {\n\n            // Abort if there are pending holds or we're already ready\n            if ( wait === true ? --jQuery.readyWait : jQuery.isReady ) {\n                return;\n            }\n\n            // Remember that the DOM is ready\n            jQuery.isReady = true;\n\n            // If a normal DOM Ready event fired, decrement, and wait if need be\n            if ( wait !== true && --jQuery.readyWait > 0 ) {\n                return;\n            }\n\n            // If there are functions bound, to execute\n            readyList.resolveWith( document, [ jQuery ] );\n        }\n    } );\n\n    jQuery.ready.then = readyList.then;\n\n// The ready event handler and self cleanup method\n    function completed() {\n        document.removeEventListener( \"DOMContentLoaded\", completed );\n        window.removeEventListener( \"load\", completed );\n        jQuery.ready();\n    }\n\n// Catch cases where $(document).ready() is called\n// after the browser event has already occurred.\n// Support: IE <=9 - 10 only\n// Older IE sometimes signals \"interactive\" too soon\n    if ( document.readyState === \"complete\" ||\n        ( document.readyState !== \"loading\" && !document.documentElement.doScroll ) ) {\n\n        // Handle it asynchronously to allow scripts the opportunity to delay ready\n        window.setTimeout( jQuery.ready );\n\n    } else {\n\n        // Use the handy event callback\n        document.addEventListener( \"DOMContentLoaded\", completed );\n\n        // A fallback to window.onload, that will always work\n        window.addEventListener( \"load\", completed );\n    }\n\n\n\n\n// Multifunctional method to get and set values of a collection\n// The value/s can optionally be executed if it's a function\n    var access = function( elems, fn, key, value, chainable, emptyGet, raw ) {\n        var i = 0,\n            len = elems.length,\n            bulk = key == null;\n\n        // Sets many values\n        if ( toType( key ) === \"object\" ) {\n            chainable = true;\n            for ( i in key ) {\n                access( elems, fn, i, key[ i ], true, emptyGet, raw );\n            }\n\n            // Sets one value\n        } else if ( value !== undefined ) {\n            chainable = true;\n\n            if ( !isFunction( value ) ) {\n                raw = true;\n            }\n\n            if ( bulk ) {\n\n                // Bulk operations run against the entire set\n                if ( raw ) {\n                    fn.call( elems, value );\n                    fn = null;\n\n                    // ...except when executing function values\n                } else {\n                    bulk = fn;\n                    fn = function( elem, _key, value ) {\n                        return bulk.call( jQuery( elem ), value );\n                    };\n                }\n            }\n\n            if ( fn ) {\n                for ( ; i < len; i++ ) {\n                    fn(\n                        elems[ i ], key, raw ?\n                            value :\n                            value.call( elems[ i ], i, fn( elems[ i ], key ) )\n                    );\n                }\n            }\n        }\n\n        if ( chainable ) {\n            return elems;\n        }\n\n        // Gets\n        if ( bulk ) {\n            return fn.call( elems );\n        }\n\n        return len ? fn( elems[ 0 ], key ) : emptyGet;\n    };\n\n\n// Matches dashed string for camelizing\n    var rmsPrefix = /^-ms-/,\n        rdashAlpha = /-([a-z])/g;\n\n// Used by camelCase as callback to replace()\n    function fcamelCase( _all, letter ) {\n        return letter.toUpperCase();\n    }\n\n// Convert dashed to camelCase; used by the css and data modules\n// Support: IE <=9 - 11, Edge 12 - 15\n// Microsoft forgot to hump their vendor prefix (trac-9572)\n    function camelCase( string ) {\n        return string.replace( rmsPrefix, \"ms-\" ).replace( rdashAlpha, fcamelCase );\n    }\n    var acceptData = function( owner ) {\n\n        // Accepts only:\n        //  - Node\n        //    - Node.ELEMENT_NODE\n        //    - Node.DOCUMENT_NODE\n        //  - Object\n        //    - Any\n        return owner.nodeType === 1 || owner.nodeType === 9 || !( +owner.nodeType );\n    };\n\n\n\n\n    function Data() {\n        this.expando = jQuery.expando + Data.uid++;\n    }\n\n    Data.uid = 1;\n\n    Data.prototype = {\n\n        cache: function( owner ) {\n\n            // Check if the owner object already has a cache\n            var value = owner[ this.expando ];\n\n            // If not, create one\n            if ( !value ) {\n                value = {};\n\n                // We can accept data for non-element nodes in modern browsers,\n                // but we should not, see trac-8335.\n                // Always return an empty object.\n                if ( acceptData( owner ) ) {\n\n                    // If it is a node unlikely to be stringify-ed or looped over\n                    // use plain assignment\n                    if ( owner.nodeType ) {\n                        owner[ this.expando ] = value;\n\n                        // Otherwise secure it in a non-enumerable property\n                        // configurable must be true to allow the property to be\n                        // deleted when data is removed\n                    } else {\n                        Object.defineProperty( owner, this.expando, {\n                            value: value,\n                            configurable: true\n                        } );\n                    }\n                }\n            }\n\n            return value;\n        },\n        set: function( owner, data, value ) {\n            var prop,\n                cache = this.cache( owner );\n\n            // Handle: [ owner, key, value ] args\n            // Always use camelCase key (gh-2257)\n            if ( typeof data === \"string\" ) {\n                cache[ camelCase( data ) ] = value;\n\n                // Handle: [ owner, { properties } ] args\n            } else {\n\n                // Copy the properties one-by-one to the cache object\n                for ( prop in data ) {\n                    cache[ camelCase( prop ) ] = data[ prop ];\n                }\n            }\n            return cache;\n        },\n        get: function( owner, key ) {\n            return key === undefined ?\n                this.cache( owner ) :\n\n                // Always use camelCase key (gh-2257)\n                owner[ this.expando ] && owner[ this.expando ][ camelCase( key ) ];\n        },\n        access: function( owner, key, value ) {\n\n            // In cases where either:\n            //\n            //   1. No key was specified\n            //   2. A string key was specified, but no value provided\n            //\n            // Take the \"read\" path and allow the get method to determine\n            // which value to return, respectively either:\n            //\n            //   1. The entire cache object\n            //   2. The data stored at the key\n            //\n            if ( key === undefined ||\n                ( ( key && typeof key === \"string\" ) && value === undefined ) ) {\n\n                return this.get( owner, key );\n            }\n\n            // When the key is not a string, or both a key and value\n            // are specified, set or extend (existing objects) with either:\n            //\n            //   1. An object of properties\n            //   2. A key and value\n            //\n            this.set( owner, key, value );\n\n            // Since the \"set\" path can have two possible entry points\n            // return the expected data based on which path was taken[*]\n            return value !== undefined ? value : key;\n        },\n        remove: function( owner, key ) {\n            var i,\n                cache = owner[ this.expando ];\n\n            if ( cache === undefined ) {\n                return;\n            }\n\n            if ( key !== undefined ) {\n\n                // Support array or space separated string of keys\n                if ( Array.isArray( key ) ) {\n\n                    // If key is an array of keys...\n                    // We always set camelCase keys, so remove that.\n                    key = key.map( camelCase );\n                } else {\n                    key = camelCase( key );\n\n                    // If a key with the spaces exists, use it.\n                    // Otherwise, create an array by matching non-whitespace\n                    key = key in cache ?\n                        [ key ] :\n                        ( key.match( rnothtmlwhite ) || [] );\n                }\n\n                i = key.length;\n\n                while ( i-- ) {\n                    delete cache[ key[ i ] ];\n                }\n            }\n\n            // Remove the expando if there's no more data\n            if ( key === undefined || jQuery.isEmptyObject( cache ) ) {\n\n                // Support: Chrome <=35 - 45\n                // Webkit & Blink performance suffers when deleting properties\n                // from DOM nodes, so set to undefined instead\n                // https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)\n                if ( owner.nodeType ) {\n                    owner[ this.expando ] = undefined;\n                } else {\n                    delete owner[ this.expando ];\n                }\n            }\n        },\n        hasData: function( owner ) {\n            var cache = owner[ this.expando ];\n            return cache !== undefined && !jQuery.isEmptyObject( cache );\n        }\n    };\n    var dataPriv = new Data();\n\n    var dataUser = new Data();\n\n\n\n//\tImplementation Summary\n//\n//\t1. Enforce API surface and semantic compatibility with 1.9.x branch\n//\t2. Improve the module's maintainability by reducing the storage\n//\t\tpaths to a single mechanism.\n//\t3. Use the same single mechanism to support \"private\" and \"user\" data.\n//\t4. _Never_ expose \"private\" data to user code (TODO: Drop _data, _removeData)\n//\t5. Avoid exposing implementation details on user objects (eg. expando properties)\n//\t6. Provide a clear path for implementation upgrade to WeakMap in 2014\n\n    var rbrace = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/,\n        rmultiDash = /[A-Z]/g;\n\n    function getData( data ) {\n        if ( data === \"true\" ) {\n            return true;\n        }\n\n        if ( data === \"false\" ) {\n            return false;\n        }\n\n        if ( data === \"null\" ) {\n            return null;\n        }\n\n        // Only convert to a number if it doesn't change the string\n        if ( data === +data + \"\" ) {\n            return +data;\n        }\n\n        if ( rbrace.test( data ) ) {\n            return JSON.parse( data );\n        }\n\n        return data;\n    }\n\n    function dataAttr( elem, key, data ) {\n        var name;\n\n        // If nothing was found internally, try to fetch any\n        // data from the HTML5 data-* attribute\n        if ( data === undefined && elem.nodeType === 1 ) {\n            name = \"data-\" + key.replace( rmultiDash, \"-$&\" ).toLowerCase();\n            data = elem.getAttribute( name );\n\n            if ( typeof data === \"string\" ) {\n                try {\n                    data = getData( data );\n                } catch ( e ) {}\n\n                // Make sure we set the data so it isn't changed later\n                dataUser.set( elem, key, data );\n            } else {\n                data = undefined;\n            }\n        }\n        return data;\n    }\n\n    jQuery.extend( {\n        hasData: function( elem ) {\n            return dataUser.hasData( elem ) || dataPriv.hasData( elem );\n        },\n\n        data: function( elem, name, data ) {\n            return dataUser.access( elem, name, data );\n        },\n\n        removeData: function( elem, name ) {\n            dataUser.remove( elem, name );\n        },\n\n        // TODO: Now that all calls to _data and _removeData have been replaced\n        // with direct calls to dataPriv methods, these can be deprecated.\n        _data: function( elem, name, data ) {\n            return dataPriv.access( elem, name, data );\n        },\n\n        _removeData: function( elem, name ) {\n            dataPriv.remove( elem, name );\n        }\n    } );\n\n    jQuery.fn.extend( {\n        data: function( key, value ) {\n            var i, name, data,\n                elem = this[ 0 ],\n                attrs = elem && elem.attributes;\n\n            // Gets all values\n            if ( key === undefined ) {\n                if ( this.length ) {\n                    data = dataUser.get( elem );\n\n                    if ( elem.nodeType === 1 && !dataPriv.get( elem, \"hasDataAttrs\" ) ) {\n                        i = attrs.length;\n                        while ( i-- ) {\n\n                            // Support: IE 11 only\n                            // The attrs elements can be null (trac-14894)\n                            if ( attrs[ i ] ) {\n                                name = attrs[ i ].name;\n                                if ( name.indexOf( \"data-\" ) === 0 ) {\n                                    name = camelCase( name.slice( 5 ) );\n                                    dataAttr( elem, name, data[ name ] );\n                                }\n                            }\n                        }\n                        dataPriv.set( elem, \"hasDataAttrs\", true );\n                    }\n                }\n\n                return data;\n            }\n\n            // Sets multiple values\n            if ( typeof key === \"object\" ) {\n                return this.each( function() {\n                    dataUser.set( this, key );\n                } );\n            }\n\n            return access( this, function( value ) {\n                var data;\n\n                // The calling jQuery object (element matches) is not empty\n                // (and therefore has an element appears at this[ 0 ]) and the\n                // `value` parameter was not undefined. An empty jQuery object\n                // will result in `undefined` for elem = this[ 0 ] which will\n                // throw an exception if an attempt to read a data cache is made.\n                if ( elem && value === undefined ) {\n\n                    // Attempt to get data from the cache\n                    // The key will always be camelCased in Data\n                    data = dataUser.get( elem, key );\n                    if ( data !== undefined ) {\n                        return data;\n                    }\n\n                    // Attempt to \"discover\" the data in\n                    // HTML5 custom data-* attrs\n                    data = dataAttr( elem, key );\n                    if ( data !== undefined ) {\n                        return data;\n                    }\n\n                    // We tried really hard, but the data doesn't exist.\n                    return;\n                }\n\n                // Set the data...\n                this.each( function() {\n\n                    // We always store the camelCased key\n                    dataUser.set( this, key, value );\n                } );\n            }, null, value, arguments.length > 1, null, true );\n        },\n\n        removeData: function( key ) {\n            return this.each( function() {\n                dataUser.remove( this, key );\n            } );\n        }\n    } );\n\n\n    jQuery.extend( {\n        queue: function( elem, type, data ) {\n            var queue;\n\n            if ( elem ) {\n                type = ( type || \"fx\" ) + \"queue\";\n                queue = dataPriv.get( elem, type );\n\n                // Speed up dequeue by getting out quickly if this is just a lookup\n                if ( data ) {\n                    if ( !queue || Array.isArray( data ) ) {\n                        queue = dataPriv.access( elem, type, jQuery.makeArray( data ) );\n                    } else {\n                        queue.push( data );\n                    }\n                }\n                return queue || [];\n            }\n        },\n\n        dequeue: function( elem, type ) {\n            type = type || \"fx\";\n\n            var queue = jQuery.queue( elem, type ),\n                startLength = queue.length,\n                fn = queue.shift(),\n                hooks = jQuery._queueHooks( elem, type ),\n                next = function() {\n                    jQuery.dequeue( elem, type );\n                };\n\n            // If the fx queue is dequeued, always remove the progress sentinel\n            if ( fn === \"inprogress\" ) {\n                fn = queue.shift();\n                startLength--;\n            }\n\n            if ( fn ) {\n\n                // Add a progress sentinel to prevent the fx queue from being\n                // automatically dequeued\n                if ( type === \"fx\" ) {\n                    queue.unshift( \"inprogress\" );\n                }\n\n                // Clear up the last queue stop function\n                delete hooks.stop;\n                fn.call( elem, next, hooks );\n            }\n\n            if ( !startLength && hooks ) {\n                hooks.empty.fire();\n            }\n        },\n\n        // Not public - generate a queueHooks object, or return the current one\n        _queueHooks: function( elem, type ) {\n            var key = type + \"queueHooks\";\n            return dataPriv.get( elem, key ) || dataPriv.access( elem, key, {\n                empty: jQuery.Callbacks( \"once memory\" ).add( function() {\n                    dataPriv.remove( elem, [ type + \"queue\", key ] );\n                } )\n            } );\n        }\n    } );\n\n    jQuery.fn.extend( {\n        queue: function( type, data ) {\n            var setter = 2;\n\n            if ( typeof type !== \"string\" ) {\n                data = type;\n                type = \"fx\";\n                setter--;\n            }\n\n            if ( arguments.length < setter ) {\n                return jQuery.queue( this[ 0 ], type );\n            }\n\n            return data === undefined ?\n                this :\n                this.each( function() {\n                    var queue = jQuery.queue( this, type, data );\n\n                    // Ensure a hooks for this queue\n                    jQuery._queueHooks( this, type );\n\n                    if ( type === \"fx\" && queue[ 0 ] !== \"inprogress\" ) {\n                        jQuery.dequeue( this, type );\n                    }\n                } );\n        },\n        dequeue: function( type ) {\n            return this.each( function() {\n                jQuery.dequeue( this, type );\n            } );\n        },\n        clearQueue: function( type ) {\n            return this.queue( type || \"fx\", [] );\n        },\n\n        // Get a promise resolved when queues of a certain type\n        // are emptied (fx is the type by default)\n        promise: function( type, obj ) {\n            var tmp,\n                count = 1,\n                defer = jQuery.Deferred(),\n                elements = this,\n                i = this.length,\n                resolve = function() {\n                    if ( !( --count ) ) {\n                        defer.resolveWith( elements, [ elements ] );\n                    }\n                };\n\n            if ( typeof type !== \"string\" ) {\n                obj = type;\n                type = undefined;\n            }\n            type = type || \"fx\";\n\n            while ( i-- ) {\n                tmp = dataPriv.get( elements[ i ], type + \"queueHooks\" );\n                if ( tmp && tmp.empty ) {\n                    count++;\n                    tmp.empty.add( resolve );\n                }\n            }\n            resolve();\n            return defer.promise( obj );\n        }\n    } );\n    var pnum = ( /[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/ ).source;\n\n    var rcssNum = new RegExp( \"^(?:([+-])=|)(\" + pnum + \")([a-z%]*)$\", \"i\" );\n\n\n    var cssExpand = [ \"Top\", \"Right\", \"Bottom\", \"Left\" ];\n\n    var documentElement = document.documentElement;\n\n\n\n    var isAttached = function( elem ) {\n            return jQuery.contains( elem.ownerDocument, elem );\n        },\n        composed = { composed: true };\n\n    // Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only\n    // Check attachment across shadow DOM boundaries when possible (gh-3504)\n    // Support: iOS 10.0-10.2 only\n    // Early iOS 10 versions support `attachShadow` but not `getRootNode`,\n    // leading to errors. We need to check for `getRootNode`.\n    if ( documentElement.getRootNode ) {\n        isAttached = function( elem ) {\n            return jQuery.contains( elem.ownerDocument, elem ) ||\n                elem.getRootNode( composed ) === elem.ownerDocument;\n        };\n    }\n    var isHiddenWithinTree = function( elem, el ) {\n\n        // isHiddenWithinTree might be called from jQuery#filter function;\n        // in that case, element will be second argument\n        elem = el || elem;\n\n        // Inline style trumps all\n        return elem.style.display === \"none\" ||\n            elem.style.display === \"\" &&\n\n            // Otherwise, check computed style\n            // Support: Firefox <=43 - 45\n            // Disconnected elements can have computed display: none, so first confirm that elem is\n            // in the document.\n            isAttached( elem ) &&\n\n            jQuery.css( elem, \"display\" ) === \"none\";\n    };\n\n\n\n    function adjustCSS( elem, prop, valueParts, tween ) {\n        var adjusted, scale,\n            maxIterations = 20,\n            currentValue = tween ?\n                function() {\n                    return tween.cur();\n                } :\n                function() {\n                    return jQuery.css( elem, prop, \"\" );\n                },\n            initial = currentValue(),\n            unit = valueParts && valueParts[ 3 ] || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" ),\n\n            // Starting value computation is required for potential unit mismatches\n            initialInUnit = elem.nodeType &&\n                ( jQuery.cssNumber[ prop ] || unit !== \"px\" && +initial ) &&\n                rcssNum.exec( jQuery.css( elem, prop ) );\n\n        if ( initialInUnit && initialInUnit[ 3 ] !== unit ) {\n\n            // Support: Firefox <=54\n            // Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)\n            initial = initial / 2;\n\n            // Trust units reported by jQuery.css\n            unit = unit || initialInUnit[ 3 ];\n\n            // Iteratively approximate from a nonzero starting point\n            initialInUnit = +initial || 1;\n\n            while ( maxIterations-- ) {\n\n                // Evaluate and update our best guess (doubling guesses that zero out).\n                // Finish if the scale equals or crosses 1 (making the old*new product non-positive).\n                jQuery.style( elem, prop, initialInUnit + unit );\n                if ( ( 1 - scale ) * ( 1 - ( scale = currentValue() / initial || 0.5 ) ) <= 0 ) {\n                    maxIterations = 0;\n                }\n                initialInUnit = initialInUnit / scale;\n\n            }\n\n            initialInUnit = initialInUnit * 2;\n            jQuery.style( elem, prop, initialInUnit + unit );\n\n            // Make sure we update the tween properties later on\n            valueParts = valueParts || [];\n        }\n\n        if ( valueParts ) {\n            initialInUnit = +initialInUnit || +initial || 0;\n\n            // Apply relative offset (+=/-=) if specified\n            adjusted = valueParts[ 1 ] ?\n                initialInUnit + ( valueParts[ 1 ] + 1 ) * valueParts[ 2 ] :\n                +valueParts[ 2 ];\n            if ( tween ) {\n                tween.unit = unit;\n                tween.start = initialInUnit;\n                tween.end = adjusted;\n            }\n        }\n        return adjusted;\n    }\n\n\n    var defaultDisplayMap = {};\n\n    function getDefaultDisplay( elem ) {\n        var temp,\n            doc = elem.ownerDocument,\n            nodeName = elem.nodeName,\n            display = defaultDisplayMap[ nodeName ];\n\n        if ( display ) {\n            return display;\n        }\n\n        temp = doc.body.appendChild( doc.createElement( nodeName ) );\n        display = jQuery.css( temp, \"display\" );\n\n        temp.parentNode.removeChild( temp );\n\n        if ( display === \"none\" ) {\n            display = \"block\";\n        }\n        defaultDisplayMap[ nodeName ] = display;\n\n        return display;\n    }\n\n    function showHide( elements, show ) {\n        var display, elem,\n            values = [],\n            index = 0,\n            length = elements.length;\n\n        // Determine new display value for elements that need to change\n        for ( ; index < length; index++ ) {\n            elem = elements[ index ];\n            if ( !elem.style ) {\n                continue;\n            }\n\n            display = elem.style.display;\n            if ( show ) {\n\n                // Since we force visibility upon cascade-hidden elements, an immediate (and slow)\n                // check is required in this first loop unless we have a nonempty display value (either\n                // inline or about-to-be-restored)\n                if ( display === \"none\" ) {\n                    values[ index ] = dataPriv.get( elem, \"display\" ) || null;\n                    if ( !values[ index ] ) {\n                        elem.style.display = \"\";\n                    }\n                }\n                if ( elem.style.display === \"\" && isHiddenWithinTree( elem ) ) {\n                    values[ index ] = getDefaultDisplay( elem );\n                }\n            } else {\n                if ( display !== \"none\" ) {\n                    values[ index ] = \"none\";\n\n                    // Remember what we're overwriting\n                    dataPriv.set( elem, \"display\", display );\n                }\n            }\n        }\n\n        // Set the display of the elements in a second loop to avoid constant reflow\n        for ( index = 0; index < length; index++ ) {\n            if ( values[ index ] != null ) {\n                elements[ index ].style.display = values[ index ];\n            }\n        }\n\n        return elements;\n    }\n\n    jQuery.fn.extend( {\n        show: function() {\n            return showHide( this, true );\n        },\n        hide: function() {\n            return showHide( this );\n        },\n        toggle: function( state ) {\n            if ( typeof state === \"boolean\" ) {\n                return state ? this.show() : this.hide();\n            }\n\n            return this.each( function() {\n                if ( isHiddenWithinTree( this ) ) {\n                    jQuery( this ).show();\n                } else {\n                    jQuery( this ).hide();\n                }\n            } );\n        }\n    } );\n    var rcheckableType = ( /^(?:checkbox|radio)$/i );\n\n    var rtagName = ( /<([a-z][^\\/\\0>\\x20\\t\\r\\n\\f]*)/i );\n\n    var rscriptType = ( /^$|^module$|\\/(?:java|ecma)script/i );\n\n\n\n    ( function() {\n        var fragment = document.createDocumentFragment(),\n            div = fragment.appendChild( document.createElement( \"div\" ) ),\n            input = document.createElement( \"input\" );\n\n        // Support: Android 4.0 - 4.3 only\n        // Check state lost if the name is set (trac-11217)\n        // Support: Windows Web Apps (WWA)\n        // `name` and `type` must use .setAttribute for WWA (trac-14901)\n        input.setAttribute( \"type\", \"radio\" );\n        input.setAttribute( \"checked\", \"checked\" );\n        input.setAttribute( \"name\", \"t\" );\n\n        div.appendChild( input );\n\n        // Support: Android <=4.1 only\n        // Older WebKit doesn't clone checked state correctly in fragments\n        support.checkClone = div.cloneNode( true ).cloneNode( true ).lastChild.checked;\n\n        // Support: IE <=11 only\n        // Make sure textarea (and checkbox) defaultValue is properly cloned\n        div.innerHTML = \"<textarea>x</textarea>\";\n        support.noCloneChecked = !!div.cloneNode( true ).lastChild.defaultValue;\n\n        // Support: IE <=9 only\n        // IE <=9 replaces <option> tags with their contents when inserted outside of\n        // the select element.\n        div.innerHTML = \"<option></option>\";\n        support.option = !!div.lastChild;\n    } )();\n\n\n// We have to close these tags to support XHTML (trac-13200)\n    var wrapMap = {\n\n        // XHTML parsers do not magically insert elements in the\n        // same way that tag soup parsers do. So we cannot shorten\n        // this by omitting <tbody> or other required elements.\n        thead: [ 1, \"<table>\", \"</table>\" ],\n        col: [ 2, \"<table><colgroup>\", \"</colgroup></table>\" ],\n        tr: [ 2, \"<table><tbody>\", \"</tbody></table>\" ],\n        td: [ 3, \"<table><tbody><tr>\", \"</tr></tbody></table>\" ],\n\n        _default: [ 0, \"\", \"\" ]\n    };\n\n    wrapMap.tbody = wrapMap.tfoot = wrapMap.colgroup = wrapMap.caption = wrapMap.thead;\n    wrapMap.th = wrapMap.td;\n\n// Support: IE <=9 only\n    if ( !support.option ) {\n        wrapMap.optgroup = wrapMap.option = [ 1, \"<select multiple='multiple'>\", \"</select>\" ];\n    }\n\n\n    function getAll( context, tag ) {\n\n        // Support: IE <=9 - 11 only\n        // Use typeof to avoid zero-argument method invocation on host objects (trac-15151)\n        var ret;\n\n        if ( typeof context.getElementsByTagName !== \"undefined\" ) {\n            ret = context.getElementsByTagName( tag || \"*\" );\n\n        } else if ( typeof context.querySelectorAll !== \"undefined\" ) {\n            ret = context.querySelectorAll( tag || \"*\" );\n\n        } else {\n            ret = [];\n        }\n\n        if ( tag === undefined || tag && nodeName( context, tag ) ) {\n            return jQuery.merge( [ context ], ret );\n        }\n\n        return ret;\n    }\n\n\n// Mark scripts as having already been evaluated\n    function setGlobalEval( elems, refElements ) {\n        var i = 0,\n            l = elems.length;\n\n        for ( ; i < l; i++ ) {\n            dataPriv.set(\n                elems[ i ],\n                \"globalEval\",\n                !refElements || dataPriv.get( refElements[ i ], \"globalEval\" )\n            );\n        }\n    }\n\n\n    var rhtml = /<|&#?\\w+;/;\n\n    function buildFragment( elems, context, scripts, selection, ignored ) {\n        var elem, tmp, tag, wrap, attached, j,\n            fragment = context.createDocumentFragment(),\n            nodes = [],\n            i = 0,\n            l = elems.length;\n\n        for ( ; i < l; i++ ) {\n            elem = elems[ i ];\n\n            if ( elem || elem === 0 ) {\n\n                // Add nodes directly\n                if ( toType( elem ) === \"object\" ) {\n\n                    // Support: Android <=4.0 only, PhantomJS 1 only\n                    // push.apply(_, arraylike) throws on ancient WebKit\n                    jQuery.merge( nodes, elem.nodeType ? [ elem ] : elem );\n\n                    // Convert non-html into a text node\n                } else if ( !rhtml.test( elem ) ) {\n                    nodes.push( context.createTextNode( elem ) );\n\n                    // Convert html into DOM nodes\n                } else {\n                    tmp = tmp || fragment.appendChild( context.createElement( \"div\" ) );\n\n                    // Deserialize a standard representation\n                    tag = ( rtagName.exec( elem ) || [ \"\", \"\" ] )[ 1 ].toLowerCase();\n                    wrap = wrapMap[ tag ] || wrapMap._default;\n                    tmp.innerHTML = wrap[ 1 ] + jQuery.htmlPrefilter( elem ) + wrap[ 2 ];\n\n                    // Descend through wrappers to the right content\n                    j = wrap[ 0 ];\n                    while ( j-- ) {\n                        tmp = tmp.lastChild;\n                    }\n\n                    // Support: Android <=4.0 only, PhantomJS 1 only\n                    // push.apply(_, arraylike) throws on ancient WebKit\n                    jQuery.merge( nodes, tmp.childNodes );\n\n                    // Remember the top-level container\n                    tmp = fragment.firstChild;\n\n                    // Ensure the created nodes are orphaned (trac-12392)\n                    tmp.textContent = \"\";\n                }\n            }\n        }\n\n        // Remove wrapper from fragment\n        fragment.textContent = \"\";\n\n        i = 0;\n        while ( ( elem = nodes[ i++ ] ) ) {\n\n            // Skip elements already in the context collection (trac-4087)\n            if ( selection && jQuery.inArray( elem, selection ) > -1 ) {\n                if ( ignored ) {\n                    ignored.push( elem );\n                }\n                continue;\n            }\n\n            attached = isAttached( elem );\n\n            // Append to fragment\n            tmp = getAll( fragment.appendChild( elem ), \"script\" );\n\n            // Preserve script evaluation history\n            if ( attached ) {\n                setGlobalEval( tmp );\n            }\n\n            // Capture executables\n            if ( scripts ) {\n                j = 0;\n                while ( ( elem = tmp[ j++ ] ) ) {\n                    if ( rscriptType.test( elem.type || \"\" ) ) {\n                        scripts.push( elem );\n                    }\n                }\n            }\n        }\n\n        return fragment;\n    }\n\n\n    var rtypenamespace = /^([^.]*)(?:\\.(.+)|)/;\n\n    function returnTrue() {\n        return true;\n    }\n\n    function returnFalse() {\n        return false;\n    }\n\n    function on( elem, types, selector, data, fn, one ) {\n        var origFn, type;\n\n        // Types can be a map of types/handlers\n        if ( typeof types === \"object\" ) {\n\n            // ( types-Object, selector, data )\n            if ( typeof selector !== \"string\" ) {\n\n                // ( types-Object, data )\n                data = data || selector;\n                selector = undefined;\n            }\n            for ( type in types ) {\n                on( elem, type, selector, data, types[ type ], one );\n            }\n            return elem;\n        }\n\n        if ( data == null && fn == null ) {\n\n            // ( types, fn )\n            fn = selector;\n            data = selector = undefined;\n        } else if ( fn == null ) {\n            if ( typeof selector === \"string\" ) {\n\n                // ( types, selector, fn )\n                fn = data;\n                data = undefined;\n            } else {\n\n                // ( types, data, fn )\n                fn = data;\n                data = selector;\n                selector = undefined;\n            }\n        }\n        if ( fn === false ) {\n            fn = returnFalse;\n        } else if ( !fn ) {\n            return elem;\n        }\n\n        if ( one === 1 ) {\n            origFn = fn;\n            fn = function( event ) {\n\n                // Can use an empty set, since event contains the info\n                jQuery().off( event );\n                return origFn.apply( this, arguments );\n            };\n\n            // Use same guid so caller can remove using origFn\n            fn.guid = origFn.guid || ( origFn.guid = jQuery.guid++ );\n        }\n        return elem.each( function() {\n            jQuery.event.add( this, types, fn, data, selector );\n        } );\n    }\n\n    /*\n * Helper functions for managing events -- not part of the public interface.\n * Props to Dean Edwards' addEvent library for many of the ideas.\n */\n    jQuery.event = {\n\n        global: {},\n\n        add: function( elem, types, handler, data, selector ) {\n\n            var handleObjIn, eventHandle, tmp,\n                events, t, handleObj,\n                special, handlers, type, namespaces, origType,\n                elemData = dataPriv.get( elem );\n\n            // Only attach events to objects that accept data\n            if ( !acceptData( elem ) ) {\n                return;\n            }\n\n            // Caller can pass in an object of custom data in lieu of the handler\n            if ( handler.handler ) {\n                handleObjIn = handler;\n                handler = handleObjIn.handler;\n                selector = handleObjIn.selector;\n            }\n\n            // Ensure that invalid selectors throw exceptions at attach time\n            // Evaluate against documentElement in case elem is a non-element node (e.g., document)\n            if ( selector ) {\n                jQuery.find.matchesSelector( documentElement, selector );\n            }\n\n            // Make sure that the handler has a unique ID, used to find/remove it later\n            if ( !handler.guid ) {\n                handler.guid = jQuery.guid++;\n            }\n\n            // Init the element's event structure and main handler, if this is the first\n            if ( !( events = elemData.events ) ) {\n                events = elemData.events = Object.create( null );\n            }\n            if ( !( eventHandle = elemData.handle ) ) {\n                eventHandle = elemData.handle = function( e ) {\n\n                    // Discard the second event of a jQuery.event.trigger() and\n                    // when an event is called after a page has unloaded\n                    return typeof jQuery !== \"undefined\" && jQuery.event.triggered !== e.type ?\n                        jQuery.event.dispatch.apply( elem, arguments ) : undefined;\n                };\n            }\n\n            // Handle multiple events separated by a space\n            types = ( types || \"\" ).match( rnothtmlwhite ) || [ \"\" ];\n            t = types.length;\n            while ( t-- ) {\n                tmp = rtypenamespace.exec( types[ t ] ) || [];\n                type = origType = tmp[ 1 ];\n                namespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n                // There *must* be a type, no attaching namespace-only handlers\n                if ( !type ) {\n                    continue;\n                }\n\n                // If event changes its type, use the special event handlers for the changed type\n                special = jQuery.event.special[ type ] || {};\n\n                // If selector defined, determine special event api type, otherwise given type\n                type = ( selector ? special.delegateType : special.bindType ) || type;\n\n                // Update special based on newly reset type\n                special = jQuery.event.special[ type ] || {};\n\n                // handleObj is passed to all event handlers\n                handleObj = jQuery.extend( {\n                    type: type,\n                    origType: origType,\n                    data: data,\n                    handler: handler,\n                    guid: handler.guid,\n                    selector: selector,\n                    needsContext: selector && jQuery.expr.match.needsContext.test( selector ),\n                    namespace: namespaces.join( \".\" )\n                }, handleObjIn );\n\n                // Init the event handler queue if we're the first\n                if ( !( handlers = events[ type ] ) ) {\n                    handlers = events[ type ] = [];\n                    handlers.delegateCount = 0;\n\n                    // Only use addEventListener if the special events handler returns false\n                    if ( !special.setup ||\n                        special.setup.call( elem, data, namespaces, eventHandle ) === false ) {\n\n                        if ( elem.addEventListener ) {\n                            elem.addEventListener( type, eventHandle );\n                        }\n                    }\n                }\n\n                if ( special.add ) {\n                    special.add.call( elem, handleObj );\n\n                    if ( !handleObj.handler.guid ) {\n                        handleObj.handler.guid = handler.guid;\n                    }\n                }\n\n                // Add to the element's handler list, delegates in front\n                if ( selector ) {\n                    handlers.splice( handlers.delegateCount++, 0, handleObj );\n                } else {\n                    handlers.push( handleObj );\n                }\n\n                // Keep track of which events have ever been used, for event optimization\n                jQuery.event.global[ type ] = true;\n            }\n\n        },\n\n        // Detach an event or set of events from an element\n        remove: function( elem, types, handler, selector, mappedTypes ) {\n\n            var j, origCount, tmp,\n                events, t, handleObj,\n                special, handlers, type, namespaces, origType,\n                elemData = dataPriv.hasData( elem ) && dataPriv.get( elem );\n\n            if ( !elemData || !( events = elemData.events ) ) {\n                return;\n            }\n\n            // Once for each type.namespace in types; type may be omitted\n            types = ( types || \"\" ).match( rnothtmlwhite ) || [ \"\" ];\n            t = types.length;\n            while ( t-- ) {\n                tmp = rtypenamespace.exec( types[ t ] ) || [];\n                type = origType = tmp[ 1 ];\n                namespaces = ( tmp[ 2 ] || \"\" ).split( \".\" ).sort();\n\n                // Unbind all events (on this namespace, if provided) for the element\n                if ( !type ) {\n                    for ( type in events ) {\n                        jQuery.event.remove( elem, type + types[ t ], handler, selector, true );\n                    }\n                    continue;\n                }\n\n                special = jQuery.event.special[ type ] || {};\n                type = ( selector ? special.delegateType : special.bindType ) || type;\n                handlers = events[ type ] || [];\n                tmp = tmp[ 2 ] &&\n                    new RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" );\n\n                // Remove matching events\n                origCount = j = handlers.length;\n                while ( j-- ) {\n                    handleObj = handlers[ j ];\n\n                    if ( ( mappedTypes || origType === handleObj.origType ) &&\n                        ( !handler || handler.guid === handleObj.guid ) &&\n                        ( !tmp || tmp.test( handleObj.namespace ) ) &&\n                        ( !selector || selector === handleObj.selector ||\n                            selector === \"**\" && handleObj.selector ) ) {\n                        handlers.splice( j, 1 );\n\n                        if ( handleObj.selector ) {\n                            handlers.delegateCount--;\n                        }\n                        if ( special.remove ) {\n                            special.remove.call( elem, handleObj );\n                        }\n                    }\n                }\n\n                // Remove generic event handler if we removed something and no more handlers exist\n                // (avoids potential for endless recursion during removal of special event handlers)\n                if ( origCount && !handlers.length ) {\n                    if ( !special.teardown ||\n                        special.teardown.call( elem, namespaces, elemData.handle ) === false ) {\n\n                        jQuery.removeEvent( elem, type, elemData.handle );\n                    }\n\n                    delete events[ type ];\n                }\n            }\n\n            // Remove data and the expando if it's no longer used\n            if ( jQuery.isEmptyObject( events ) ) {\n                dataPriv.remove( elem, \"handle events\" );\n            }\n        },\n\n        dispatch: function( nativeEvent ) {\n\n            var i, j, ret, matched, handleObj, handlerQueue,\n                args = new Array( arguments.length ),\n\n                // Make a writable jQuery.Event from the native event object\n                event = jQuery.event.fix( nativeEvent ),\n\n                handlers = (\n                    dataPriv.get( this, \"events\" ) || Object.create( null )\n                )[ event.type ] || [],\n                special = jQuery.event.special[ event.type ] || {};\n\n            // Use the fix-ed jQuery.Event rather than the (read-only) native event\n            args[ 0 ] = event;\n\n            for ( i = 1; i < arguments.length; i++ ) {\n                args[ i ] = arguments[ i ];\n            }\n\n            event.delegateTarget = this;\n\n            // Call the preDispatch hook for the mapped type, and let it bail if desired\n            if ( special.preDispatch && special.preDispatch.call( this, event ) === false ) {\n                return;\n            }\n\n            // Determine handlers\n            handlerQueue = jQuery.event.handlers.call( this, event, handlers );\n\n            // Run delegates first; they may want to stop propagation beneath us\n            i = 0;\n            while ( ( matched = handlerQueue[ i++ ] ) && !event.isPropagationStopped() ) {\n                event.currentTarget = matched.elem;\n\n                j = 0;\n                while ( ( handleObj = matched.handlers[ j++ ] ) &&\n                !event.isImmediatePropagationStopped() ) {\n\n                    // If the event is namespaced, then each handler is only invoked if it is\n                    // specially universal or its namespaces are a superset of the event's.\n                    if ( !event.rnamespace || handleObj.namespace === false ||\n                        event.rnamespace.test( handleObj.namespace ) ) {\n\n                        event.handleObj = handleObj;\n                        event.data = handleObj.data;\n\n                        ret = ( ( jQuery.event.special[ handleObj.origType ] || {} ).handle ||\n                            handleObj.handler ).apply( matched.elem, args );\n\n                        if ( ret !== undefined ) {\n                            if ( ( event.result = ret ) === false ) {\n                                event.preventDefault();\n                                event.stopPropagation();\n                            }\n                        }\n                    }\n                }\n            }\n\n            // Call the postDispatch hook for the mapped type\n            if ( special.postDispatch ) {\n                special.postDispatch.call( this, event );\n            }\n\n            return event.result;\n        },\n\n        handlers: function( event, handlers ) {\n            var i, handleObj, sel, matchedHandlers, matchedSelectors,\n                handlerQueue = [],\n                delegateCount = handlers.delegateCount,\n                cur = event.target;\n\n            // Find delegate handlers\n            if ( delegateCount &&\n\n                // Support: IE <=9\n                // Black-hole SVG <use> instance trees (trac-13180)\n                cur.nodeType &&\n\n                // Support: Firefox <=42\n                // Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)\n                // https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click\n                // Support: IE 11 only\n                // ...but not arrow key \"clicks\" of radio inputs, which can have `button` -1 (gh-2343)\n                !( event.type === \"click\" && event.button >= 1 ) ) {\n\n                for ( ; cur !== this; cur = cur.parentNode || this ) {\n\n                    // Don't check non-elements (trac-13208)\n                    // Don't process clicks on disabled elements (trac-6911, trac-8165, trac-11382, trac-11764)\n                    if ( cur.nodeType === 1 && !( event.type === \"click\" && cur.disabled === true ) ) {\n                        matchedHandlers = [];\n                        matchedSelectors = {};\n                        for ( i = 0; i < delegateCount; i++ ) {\n                            handleObj = handlers[ i ];\n\n                            // Don't conflict with Object.prototype properties (trac-13203)\n                            sel = handleObj.selector + \" \";\n\n                            if ( matchedSelectors[ sel ] === undefined ) {\n                                matchedSelectors[ sel ] = handleObj.needsContext ?\n                                    jQuery( sel, this ).index( cur ) > -1 :\n                                    jQuery.find( sel, this, null, [ cur ] ).length;\n                            }\n                            if ( matchedSelectors[ sel ] ) {\n                                matchedHandlers.push( handleObj );\n                            }\n                        }\n                        if ( matchedHandlers.length ) {\n                            handlerQueue.push( { elem: cur, handlers: matchedHandlers } );\n                        }\n                    }\n                }\n            }\n\n            // Add the remaining (directly-bound) handlers\n            cur = this;\n            if ( delegateCount < handlers.length ) {\n                handlerQueue.push( { elem: cur, handlers: handlers.slice( delegateCount ) } );\n            }\n\n            return handlerQueue;\n        },\n\n        addProp: function( name, hook ) {\n            Object.defineProperty( jQuery.Event.prototype, name, {\n                enumerable: true,\n                configurable: true,\n\n                get: isFunction( hook ) ?\n                    function() {\n                        if ( this.originalEvent ) {\n                            return hook( this.originalEvent );\n                        }\n                    } :\n                    function() {\n                        if ( this.originalEvent ) {\n                            return this.originalEvent[ name ];\n                        }\n                    },\n\n                set: function( value ) {\n                    Object.defineProperty( this, name, {\n                        enumerable: true,\n                        configurable: true,\n                        writable: true,\n                        value: value\n                    } );\n                }\n            } );\n        },\n\n        fix: function( originalEvent ) {\n            return originalEvent[ jQuery.expando ] ?\n                originalEvent :\n                new jQuery.Event( originalEvent );\n        },\n\n        special: {\n            load: {\n\n                // Prevent triggered image.load events from bubbling to window.load\n                noBubble: true\n            },\n            click: {\n\n                // Utilize native event to ensure correct state for checkable inputs\n                setup: function( data ) {\n\n                    // For mutual compressibility with _default, replace `this` access with a local var.\n                    // `|| data` is dead code meant only to preserve the variable through minification.\n                    var el = this || data;\n\n                    // Claim the first handler\n                    if ( rcheckableType.test( el.type ) &&\n                        el.click && nodeName( el, \"input\" ) ) {\n\n                        // dataPriv.set( el, \"click\", ... )\n                        leverageNative( el, \"click\", true );\n                    }\n\n                    // Return false to allow normal processing in the caller\n                    return false;\n                },\n                trigger: function( data ) {\n\n                    // For mutual compressibility with _default, replace `this` access with a local var.\n                    // `|| data` is dead code meant only to preserve the variable through minification.\n                    var el = this || data;\n\n                    // Force setup before triggering a click\n                    if ( rcheckableType.test( el.type ) &&\n                        el.click && nodeName( el, \"input\" ) ) {\n\n                        leverageNative( el, \"click\" );\n                    }\n\n                    // Return non-false to allow normal event-path propagation\n                    return true;\n                },\n\n                // For cross-browser consistency, suppress native .click() on links\n                // Also prevent it if we're currently inside a leveraged native-event stack\n                _default: function( event ) {\n                    var target = event.target;\n                    return rcheckableType.test( target.type ) &&\n                        target.click && nodeName( target, \"input\" ) &&\n                        dataPriv.get( target, \"click\" ) ||\n                        nodeName( target, \"a\" );\n                }\n            },\n\n            beforeunload: {\n                postDispatch: function( event ) {\n\n                    // Support: Firefox 20+\n                    // Firefox doesn't alert if the returnValue field is not set.\n                    if ( event.result !== undefined && event.originalEvent ) {\n                        event.originalEvent.returnValue = event.result;\n                    }\n                }\n            }\n        }\n    };\n\n// Ensure the presence of an event listener that handles manually-triggered\n// synthetic events by interrupting progress until reinvoked in response to\n// *native* events that it fires directly, ensuring that state changes have\n// already occurred before other listeners are invoked.\n    function leverageNative( el, type, isSetup ) {\n\n        // Missing `isSetup` indicates a trigger call, which must force setup through jQuery.event.add\n        if ( !isSetup ) {\n            if ( dataPriv.get( el, type ) === undefined ) {\n                jQuery.event.add( el, type, returnTrue );\n            }\n            return;\n        }\n\n        // Register the controller as a special universal handler for all event namespaces\n        dataPriv.set( el, type, false );\n        jQuery.event.add( el, type, {\n            namespace: false,\n            handler: function( event ) {\n                var result,\n                    saved = dataPriv.get( this, type );\n\n                if ( ( event.isTrigger & 1 ) && this[ type ] ) {\n\n                    // Interrupt processing of the outer synthetic .trigger()ed event\n                    if ( !saved ) {\n\n                        // Store arguments for use when handling the inner native event\n                        // There will always be at least one argument (an event object), so this array\n                        // will not be confused with a leftover capture object.\n                        saved = slice.call( arguments );\n                        dataPriv.set( this, type, saved );\n\n                        // Trigger the native event and capture its result\n                        this[ type ]();\n                        result = dataPriv.get( this, type );\n                        dataPriv.set( this, type, false );\n\n                        if ( saved !== result ) {\n\n                            // Cancel the outer synthetic event\n                            event.stopImmediatePropagation();\n                            event.preventDefault();\n\n                            return result;\n                        }\n\n                        // If this is an inner synthetic event for an event with a bubbling surrogate\n                        // (focus or blur), assume that the surrogate already propagated from triggering\n                        // the native event and prevent that from happening again here.\n                        // This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the\n                        // bubbling surrogate propagates *after* the non-bubbling base), but that seems\n                        // less bad than duplication.\n                    } else if ( ( jQuery.event.special[ type ] || {} ).delegateType ) {\n                        event.stopPropagation();\n                    }\n\n                    // If this is a native event triggered above, everything is now in order\n                    // Fire an inner synthetic event with the original arguments\n                } else if ( saved ) {\n\n                    // ...and capture the result\n                    dataPriv.set( this, type, jQuery.event.trigger(\n                        saved[ 0 ],\n                        saved.slice( 1 ),\n                        this\n                    ) );\n\n                    // Abort handling of the native event by all jQuery handlers while allowing\n                    // native handlers on the same element to run. On target, this is achieved\n                    // by stopping immediate propagation just on the jQuery event. However,\n                    // the native event is re-wrapped by a jQuery one on each level of the\n                    // propagation so the only way to stop it for jQuery is to stop it for\n                    // everyone via native `stopPropagation()`. This is not a problem for\n                    // focus/blur which don't bubble, but it does also stop click on checkboxes\n                    // and radios. We accept this limitation.\n                    event.stopPropagation();\n                    event.isImmediatePropagationStopped = returnTrue;\n                }\n            }\n        } );\n    }\n\n    jQuery.removeEvent = function( elem, type, handle ) {\n\n        // This \"if\" is needed for plain objects\n        if ( elem.removeEventListener ) {\n            elem.removeEventListener( type, handle );\n        }\n    };\n\n    jQuery.Event = function( src, props ) {\n\n        // Allow instantiation without the 'new' keyword\n        if ( !( this instanceof jQuery.Event ) ) {\n            return new jQuery.Event( src, props );\n        }\n\n        // Event object\n        if ( src && src.type ) {\n            this.originalEvent = src;\n            this.type = src.type;\n\n            // Events bubbling up the document may have been marked as prevented\n            // by a handler lower down the tree; reflect the correct value.\n            this.isDefaultPrevented = src.defaultPrevented ||\n            src.defaultPrevented === undefined &&\n\n            // Support: Android <=2.3 only\n            src.returnValue === false ?\n                returnTrue :\n                returnFalse;\n\n            // Create target properties\n            // Support: Safari <=6 - 7 only\n            // Target should not be a text node (trac-504, trac-13143)\n            this.target = ( src.target && src.target.nodeType === 3 ) ?\n                src.target.parentNode :\n                src.target;\n\n            this.currentTarget = src.currentTarget;\n            this.relatedTarget = src.relatedTarget;\n\n            // Event type\n        } else {\n            this.type = src;\n        }\n\n        // Put explicitly provided properties onto the event object\n        if ( props ) {\n            jQuery.extend( this, props );\n        }\n\n        // Create a timestamp if incoming event doesn't have one\n        this.timeStamp = src && src.timeStamp || Date.now();\n\n        // Mark it as fixed\n        this[ jQuery.expando ] = true;\n    };\n\n// jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding\n// https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html\n    jQuery.Event.prototype = {\n        constructor: jQuery.Event,\n        isDefaultPrevented: returnFalse,\n        isPropagationStopped: returnFalse,\n        isImmediatePropagationStopped: returnFalse,\n        isSimulated: false,\n\n        preventDefault: function() {\n            var e = this.originalEvent;\n\n            this.isDefaultPrevented = returnTrue;\n\n            if ( e && !this.isSimulated ) {\n                e.preventDefault();\n            }\n        },\n        stopPropagation: function() {\n            var e = this.originalEvent;\n\n            this.isPropagationStopped = returnTrue;\n\n            if ( e && !this.isSimulated ) {\n                e.stopPropagation();\n            }\n        },\n        stopImmediatePropagation: function() {\n            var e = this.originalEvent;\n\n            this.isImmediatePropagationStopped = returnTrue;\n\n            if ( e && !this.isSimulated ) {\n                e.stopImmediatePropagation();\n            }\n\n            this.stopPropagation();\n        }\n    };\n\n// Includes all common event props including KeyEvent and MouseEvent specific props\n    jQuery.each( {\n        altKey: true,\n        bubbles: true,\n        cancelable: true,\n        changedTouches: true,\n        ctrlKey: true,\n        detail: true,\n        eventPhase: true,\n        metaKey: true,\n        pageX: true,\n        pageY: true,\n        shiftKey: true,\n        view: true,\n        \"char\": true,\n        code: true,\n        charCode: true,\n        key: true,\n        keyCode: true,\n        button: true,\n        buttons: true,\n        clientX: true,\n        clientY: true,\n        offsetX: true,\n        offsetY: true,\n        pointerId: true,\n        pointerType: true,\n        screenX: true,\n        screenY: true,\n        targetTouches: true,\n        toElement: true,\n        touches: true,\n        which: true\n    }, jQuery.event.addProp );\n\n    jQuery.each( { focus: \"focusin\", blur: \"focusout\" }, function( type, delegateType ) {\n\n        function focusMappedHandler( nativeEvent ) {\n            if ( document.documentMode ) {\n\n                // Support: IE 11+\n                // Attach a single focusin/focusout handler on the document while someone wants\n                // focus/blur. This is because the former are synchronous in IE while the latter\n                // are async. In other browsers, all those handlers are invoked synchronously.\n\n                // `handle` from private data would already wrap the event, but we need\n                // to change the `type` here.\n                var handle = dataPriv.get( this, \"handle\" ),\n                    event = jQuery.event.fix( nativeEvent );\n                event.type = nativeEvent.type === \"focusin\" ? \"focus\" : \"blur\";\n                event.isSimulated = true;\n\n                // First, handle focusin/focusout\n                handle( nativeEvent );\n\n                // ...then, handle focus/blur\n                //\n                // focus/blur don't bubble while focusin/focusout do; simulate the former by only\n                // invoking the handler at the lower level.\n                if ( event.target === event.currentTarget ) {\n\n                    // The setup part calls `leverageNative`, which, in turn, calls\n                    // `jQuery.event.add`, so event handle will already have been set\n                    // by this point.\n                    handle( event );\n                }\n            } else {\n\n                // For non-IE browsers, attach a single capturing handler on the document\n                // while someone wants focusin/focusout.\n                jQuery.event.simulate( delegateType, nativeEvent.target,\n                    jQuery.event.fix( nativeEvent ) );\n            }\n        }\n\n        jQuery.event.special[ type ] = {\n\n            // Utilize native event if possible so blur/focus sequence is correct\n            setup: function() {\n\n                var attaches;\n\n                // Claim the first handler\n                // dataPriv.set( this, \"focus\", ... )\n                // dataPriv.set( this, \"blur\", ... )\n                leverageNative( this, type, true );\n\n                if ( document.documentMode ) {\n\n                    // Support: IE 9 - 11+\n                    // We use the same native handler for focusin & focus (and focusout & blur)\n                    // so we need to coordinate setup & teardown parts between those events.\n                    // Use `delegateType` as the key as `type` is already used by `leverageNative`.\n                    attaches = dataPriv.get( this, delegateType );\n                    if ( !attaches ) {\n                        this.addEventListener( delegateType, focusMappedHandler );\n                    }\n                    dataPriv.set( this, delegateType, ( attaches || 0 ) + 1 );\n                } else {\n\n                    // Return false to allow normal processing in the caller\n                    return false;\n                }\n            },\n            trigger: function() {\n\n                // Force setup before trigger\n                leverageNative( this, type );\n\n                // Return non-false to allow normal event-path propagation\n                return true;\n            },\n\n            teardown: function() {\n                var attaches;\n\n                if ( document.documentMode ) {\n                    attaches = dataPriv.get( this, delegateType ) - 1;\n                    if ( !attaches ) {\n                        this.removeEventListener( delegateType, focusMappedHandler );\n                        dataPriv.remove( this, delegateType );\n                    } else {\n                        dataPriv.set( this, delegateType, attaches );\n                    }\n                } else {\n\n                    // Return false to indicate standard teardown should be applied\n                    return false;\n                }\n            },\n\n            // Suppress native focus or blur if we're currently inside\n            // a leveraged native-event stack\n            _default: function( event ) {\n                return dataPriv.get( event.target, type );\n            },\n\n            delegateType: delegateType\n        };\n\n        // Support: Firefox <=44\n        // Firefox doesn't have focus(in | out) events\n        // Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787\n        //\n        // Support: Chrome <=48 - 49, Safari <=9.0 - 9.1\n        // focus(in | out) events fire after focus & blur events,\n        // which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order\n        // Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857\n        //\n        // Support: IE 9 - 11+\n        // To preserve relative focusin/focus & focusout/blur event order guaranteed on the 3.x branch,\n        // attach a single handler for both events in IE.\n        jQuery.event.special[ delegateType ] = {\n            setup: function() {\n\n                // Handle: regular nodes (via `this.ownerDocument`), window\n                // (via `this.document`) & document (via `this`).\n                var doc = this.ownerDocument || this.document || this,\n                    dataHolder = document.documentMode ? this : doc,\n                    attaches = dataPriv.get( dataHolder, delegateType );\n\n                // Support: IE 9 - 11+\n                // We use the same native handler for focusin & focus (and focusout & blur)\n                // so we need to coordinate setup & teardown parts between those events.\n                // Use `delegateType` as the key as `type` is already used by `leverageNative`.\n                if ( !attaches ) {\n                    if ( document.documentMode ) {\n                        this.addEventListener( delegateType, focusMappedHandler );\n                    } else {\n                        doc.addEventListener( type, focusMappedHandler, true );\n                    }\n                }\n                dataPriv.set( dataHolder, delegateType, ( attaches || 0 ) + 1 );\n            },\n            teardown: function() {\n                var doc = this.ownerDocument || this.document || this,\n                    dataHolder = document.documentMode ? this : doc,\n                    attaches = dataPriv.get( dataHolder, delegateType ) - 1;\n\n                if ( !attaches ) {\n                    if ( document.documentMode ) {\n                        this.removeEventListener( delegateType, focusMappedHandler );\n                    } else {\n                        doc.removeEventListener( type, focusMappedHandler, true );\n                    }\n                    dataPriv.remove( dataHolder, delegateType );\n                } else {\n                    dataPriv.set( dataHolder, delegateType, attaches );\n                }\n            }\n        };\n    } );\n\n// Create mouseenter/leave events using mouseover/out and event-time checks\n// so that event delegation works in jQuery.\n// Do the same for pointerenter/pointerleave and pointerover/pointerout\n//\n// Support: Safari 7 only\n// Safari sends mouseenter too often; see:\n// https://bugs.chromium.org/p/chromium/issues/detail?id=470258\n// for the description of the bug (it existed in older Chrome versions as well).\n    jQuery.each( {\n        mouseenter: \"mouseover\",\n        mouseleave: \"mouseout\",\n        pointerenter: \"pointerover\",\n        pointerleave: \"pointerout\"\n    }, function( orig, fix ) {\n        jQuery.event.special[ orig ] = {\n            delegateType: fix,\n            bindType: fix,\n\n            handle: function( event ) {\n                var ret,\n                    target = this,\n                    related = event.relatedTarget,\n                    handleObj = event.handleObj;\n\n                // For mouseenter/leave call the handler if related is outside the target.\n                // NB: No relatedTarget if the mouse left/entered the browser window\n                if ( !related || ( related !== target && !jQuery.contains( target, related ) ) ) {\n                    event.type = handleObj.origType;\n                    ret = handleObj.handler.apply( this, arguments );\n                    event.type = fix;\n                }\n                return ret;\n            }\n        };\n    } );\n\n    jQuery.fn.extend( {\n\n        on: function( types, selector, data, fn ) {\n            return on( this, types, selector, data, fn );\n        },\n        one: function( types, selector, data, fn ) {\n            return on( this, types, selector, data, fn, 1 );\n        },\n        off: function( types, selector, fn ) {\n            var handleObj, type;\n            if ( types && types.preventDefault && types.handleObj ) {\n\n                // ( event )  dispatched jQuery.Event\n                handleObj = types.handleObj;\n                jQuery( types.delegateTarget ).off(\n                    handleObj.namespace ?\n                        handleObj.origType + \".\" + handleObj.namespace :\n                        handleObj.origType,\n                    handleObj.selector,\n                    handleObj.handler\n                );\n                return this;\n            }\n            if ( typeof types === \"object\" ) {\n\n                // ( types-object [, selector] )\n                for ( type in types ) {\n                    this.off( type, selector, types[ type ] );\n                }\n                return this;\n            }\n            if ( selector === false || typeof selector === \"function\" ) {\n\n                // ( types [, fn] )\n                fn = selector;\n                selector = undefined;\n            }\n            if ( fn === false ) {\n                fn = returnFalse;\n            }\n            return this.each( function() {\n                jQuery.event.remove( this, types, fn, selector );\n            } );\n        }\n    } );\n\n\n    var\n\n        // Support: IE <=10 - 11, Edge 12 - 13 only\n        // In IE/Edge using regex groups here causes severe slowdowns.\n        // See https://connect.microsoft.com/IE/feedback/details/1736512/\n        rnoInnerhtml = /<script|<style|<link/i,\n\n        // checked=\"checked\" or checked\n        rchecked = /checked\\s*(?:[^=]|=\\s*.checked.)/i,\n\n        rcleanScript = /^\\s*<!\\[CDATA\\[|\\]\\]>\\s*$/g;\n\n// Prefer a tbody over its parent table for containing new rows\n    function manipulationTarget( elem, content ) {\n        if ( nodeName( elem, \"table\" ) &&\n            nodeName( content.nodeType !== 11 ? content : content.firstChild, \"tr\" ) ) {\n\n            return jQuery( elem ).children( \"tbody\" )[ 0 ] || elem;\n        }\n\n        return elem;\n    }\n\n// Replace/restore the type attribute of script elements for safe DOM manipulation\n    function disableScript( elem ) {\n        elem.type = ( elem.getAttribute( \"type\" ) !== null ) + \"/\" + elem.type;\n        return elem;\n    }\n    function restoreScript( elem ) {\n        if ( ( elem.type || \"\" ).slice( 0, 5 ) === \"true/\" ) {\n            elem.type = elem.type.slice( 5 );\n        } else {\n            elem.removeAttribute( \"type\" );\n        }\n\n        return elem;\n    }\n\n    function cloneCopyEvent( src, dest ) {\n        var i, l, type, pdataOld, udataOld, udataCur, events;\n\n        if ( dest.nodeType !== 1 ) {\n            return;\n        }\n\n        // 1. Copy private data: events, handlers, etc.\n        if ( dataPriv.hasData( src ) ) {\n            pdataOld = dataPriv.get( src );\n            events = pdataOld.events;\n\n            if ( events ) {\n                dataPriv.remove( dest, \"handle events\" );\n\n                for ( type in events ) {\n                    for ( i = 0, l = events[ type ].length; i < l; i++ ) {\n                        jQuery.event.add( dest, type, events[ type ][ i ] );\n                    }\n                }\n            }\n        }\n\n        // 2. Copy user data\n        if ( dataUser.hasData( src ) ) {\n            udataOld = dataUser.access( src );\n            udataCur = jQuery.extend( {}, udataOld );\n\n            dataUser.set( dest, udataCur );\n        }\n    }\n\n// Fix IE bugs, see support tests\n    function fixInput( src, dest ) {\n        var nodeName = dest.nodeName.toLowerCase();\n\n        // Fails to persist the checked state of a cloned checkbox or radio button.\n        if ( nodeName === \"input\" && rcheckableType.test( src.type ) ) {\n            dest.checked = src.checked;\n\n            // Fails to return the selected option to the default selected state when cloning options\n        } else if ( nodeName === \"input\" || nodeName === \"textarea\" ) {\n            dest.defaultValue = src.defaultValue;\n        }\n    }\n\n    function domManip( collection, args, callback, ignored ) {\n\n        // Flatten any nested arrays\n        args = flat( args );\n\n        var fragment, first, scripts, hasScripts, node, doc,\n            i = 0,\n            l = collection.length,\n            iNoClone = l - 1,\n            value = args[ 0 ],\n            valueIsFunction = isFunction( value );\n\n        // We can't cloneNode fragments that contain checked, in WebKit\n        if ( valueIsFunction ||\n            ( l > 1 && typeof value === \"string\" &&\n                !support.checkClone && rchecked.test( value ) ) ) {\n            return collection.each( function( index ) {\n                var self = collection.eq( index );\n                if ( valueIsFunction ) {\n                    args[ 0 ] = value.call( this, index, self.html() );\n                }\n                domManip( self, args, callback, ignored );\n            } );\n        }\n\n        if ( l ) {\n            fragment = buildFragment( args, collection[ 0 ].ownerDocument, false, collection, ignored );\n            first = fragment.firstChild;\n\n            if ( fragment.childNodes.length === 1 ) {\n                fragment = first;\n            }\n\n            // Require either new content or an interest in ignored elements to invoke the callback\n            if ( first || ignored ) {\n                scripts = jQuery.map( getAll( fragment, \"script\" ), disableScript );\n                hasScripts = scripts.length;\n\n                // Use the original fragment for the last item\n                // instead of the first because it can end up\n                // being emptied incorrectly in certain situations (trac-8070).\n                for ( ; i < l; i++ ) {\n                    node = fragment;\n\n                    if ( i !== iNoClone ) {\n                        node = jQuery.clone( node, true, true );\n\n                        // Keep references to cloned scripts for later restoration\n                        if ( hasScripts ) {\n\n                            // Support: Android <=4.0 only, PhantomJS 1 only\n                            // push.apply(_, arraylike) throws on ancient WebKit\n                            jQuery.merge( scripts, getAll( node, \"script\" ) );\n                        }\n                    }\n\n                    callback.call( collection[ i ], node, i );\n                }\n\n                if ( hasScripts ) {\n                    doc = scripts[ scripts.length - 1 ].ownerDocument;\n\n                    // Re-enable scripts\n                    jQuery.map( scripts, restoreScript );\n\n                    // Evaluate executable scripts on first document insertion\n                    for ( i = 0; i < hasScripts; i++ ) {\n                        node = scripts[ i ];\n                        if ( rscriptType.test( node.type || \"\" ) &&\n                            !dataPriv.access( node, \"globalEval\" ) &&\n                            jQuery.contains( doc, node ) ) {\n\n                            if ( node.src && ( node.type || \"\" ).toLowerCase()  !== \"module\" ) {\n\n                                // Optional AJAX dependency, but won't run scripts if not present\n                                if ( jQuery._evalUrl && !node.noModule ) {\n                                    jQuery._evalUrl( node.src, {\n                                        nonce: node.nonce || node.getAttribute( \"nonce\" )\n                                    }, doc );\n                                }\n                            } else {\n\n                                // Unwrap a CDATA section containing script contents. This shouldn't be\n                                // needed as in XML documents they're already not visible when\n                                // inspecting element contents and in HTML documents they have no\n                                // meaning but we're preserving that logic for backwards compatibility.\n                                // This will be removed completely in 4.0. See gh-4904.\n                                DOMEval( node.textContent.replace( rcleanScript, \"\" ), node, doc );\n                            }\n                        }\n                    }\n                }\n            }\n        }\n\n        return collection;\n    }\n\n    function remove( elem, selector, keepData ) {\n        var node,\n            nodes = selector ? jQuery.filter( selector, elem ) : elem,\n            i = 0;\n\n        for ( ; ( node = nodes[ i ] ) != null; i++ ) {\n            if ( !keepData && node.nodeType === 1 ) {\n                jQuery.cleanData( getAll( node ) );\n            }\n\n            if ( node.parentNode ) {\n                if ( keepData && isAttached( node ) ) {\n                    setGlobalEval( getAll( node, \"script\" ) );\n                }\n                node.parentNode.removeChild( node );\n            }\n        }\n\n        return elem;\n    }\n\n    jQuery.extend( {\n        htmlPrefilter: function( html ) {\n            return html;\n        },\n\n        clone: function( elem, dataAndEvents, deepDataAndEvents ) {\n            var i, l, srcElements, destElements,\n                clone = elem.cloneNode( true ),\n                inPage = isAttached( elem );\n\n            // Fix IE cloning issues\n            if ( !support.noCloneChecked && ( elem.nodeType === 1 || elem.nodeType === 11 ) &&\n                !jQuery.isXMLDoc( elem ) ) {\n\n                // We eschew jQuery#find here for performance reasons:\n                // https://jsperf.com/getall-vs-sizzle/2\n                destElements = getAll( clone );\n                srcElements = getAll( elem );\n\n                for ( i = 0, l = srcElements.length; i < l; i++ ) {\n                    fixInput( srcElements[ i ], destElements[ i ] );\n                }\n            }\n\n            // Copy the events from the original to the clone\n            if ( dataAndEvents ) {\n                if ( deepDataAndEvents ) {\n                    srcElements = srcElements || getAll( elem );\n                    destElements = destElements || getAll( clone );\n\n                    for ( i = 0, l = srcElements.length; i < l; i++ ) {\n                        cloneCopyEvent( srcElements[ i ], destElements[ i ] );\n                    }\n                } else {\n                    cloneCopyEvent( elem, clone );\n                }\n            }\n\n            // Preserve script evaluation history\n            destElements = getAll( clone, \"script\" );\n            if ( destElements.length > 0 ) {\n                setGlobalEval( destElements, !inPage && getAll( elem, \"script\" ) );\n            }\n\n            // Return the cloned set\n            return clone;\n        },\n\n        cleanData: function( elems ) {\n            var data, elem, type,\n                special = jQuery.event.special,\n                i = 0;\n\n            for ( ; ( elem = elems[ i ] ) !== undefined; i++ ) {\n                if ( acceptData( elem ) ) {\n                    if ( ( data = elem[ dataPriv.expando ] ) ) {\n                        if ( data.events ) {\n                            for ( type in data.events ) {\n                                if ( special[ type ] ) {\n                                    jQuery.event.remove( elem, type );\n\n                                    // This is a shortcut to avoid jQuery.event.remove's overhead\n                                } else {\n                                    jQuery.removeEvent( elem, type, data.handle );\n                                }\n                            }\n                        }\n\n                        // Support: Chrome <=35 - 45+\n                        // Assign undefined instead of using delete, see Data#remove\n                        elem[ dataPriv.expando ] = undefined;\n                    }\n                    if ( elem[ dataUser.expando ] ) {\n\n                        // Support: Chrome <=35 - 45+\n                        // Assign undefined instead of using delete, see Data#remove\n                        elem[ dataUser.expando ] = undefined;\n                    }\n                }\n            }\n        }\n    } );\n\n    jQuery.fn.extend( {\n        detach: function( selector ) {\n            return remove( this, selector, true );\n        },\n\n        remove: function( selector ) {\n            return remove( this, selector );\n        },\n\n        text: function( value ) {\n            return access( this, function( value ) {\n                return value === undefined ?\n                    jQuery.text( this ) :\n                    this.empty().each( function() {\n                        if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n                            this.textContent = value;\n                        }\n                    } );\n            }, null, value, arguments.length );\n        },\n\n        append: function() {\n            return domManip( this, arguments, function( elem ) {\n                if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n                    var target = manipulationTarget( this, elem );\n                    target.appendChild( elem );\n                }\n            } );\n        },\n\n        prepend: function() {\n            return domManip( this, arguments, function( elem ) {\n                if ( this.nodeType === 1 || this.nodeType === 11 || this.nodeType === 9 ) {\n                    var target = manipulationTarget( this, elem );\n                    target.insertBefore( elem, target.firstChild );\n                }\n            } );\n        },\n\n        before: function() {\n            return domManip( this, arguments, function( elem ) {\n                if ( this.parentNode ) {\n                    this.parentNode.insertBefore( elem, this );\n                }\n            } );\n        },\n\n        after: function() {\n            return domManip( this, arguments, function( elem ) {\n                if ( this.parentNode ) {\n                    this.parentNode.insertBefore( elem, this.nextSibling );\n                }\n            } );\n        },\n\n        empty: function() {\n            var elem,\n                i = 0;\n\n            for ( ; ( elem = this[ i ] ) != null; i++ ) {\n                if ( elem.nodeType === 1 ) {\n\n                    // Prevent memory leaks\n                    jQuery.cleanData( getAll( elem, false ) );\n\n                    // Remove any remaining nodes\n                    elem.textContent = \"\";\n                }\n            }\n\n            return this;\n        },\n\n        clone: function( dataAndEvents, deepDataAndEvents ) {\n            dataAndEvents = dataAndEvents == null ? false : dataAndEvents;\n            deepDataAndEvents = deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;\n\n            return this.map( function() {\n                return jQuery.clone( this, dataAndEvents, deepDataAndEvents );\n            } );\n        },\n\n        html: function( value ) {\n            return access( this, function( value ) {\n                var elem = this[ 0 ] || {},\n                    i = 0,\n                    l = this.length;\n\n                if ( value === undefined && elem.nodeType === 1 ) {\n                    return elem.innerHTML;\n                }\n\n                // See if we can take a shortcut and just use innerHTML\n                if ( typeof value === \"string\" && !rnoInnerhtml.test( value ) &&\n                    !wrapMap[ ( rtagName.exec( value ) || [ \"\", \"\" ] )[ 1 ].toLowerCase() ] ) {\n\n                    value = jQuery.htmlPrefilter( value );\n\n                    try {\n                        for ( ; i < l; i++ ) {\n                            elem = this[ i ] || {};\n\n                            // Remove element nodes and prevent memory leaks\n                            if ( elem.nodeType === 1 ) {\n                                jQuery.cleanData( getAll( elem, false ) );\n                                elem.innerHTML = value;\n                            }\n                        }\n\n                        elem = 0;\n\n                        // If using innerHTML throws an exception, use the fallback method\n                    } catch ( e ) {}\n                }\n\n                if ( elem ) {\n                    this.empty().append( value );\n                }\n            }, null, value, arguments.length );\n        },\n\n        replaceWith: function() {\n            var ignored = [];\n\n            // Make the changes, replacing each non-ignored context element with the new content\n            return domManip( this, arguments, function( elem ) {\n                var parent = this.parentNode;\n\n                if ( jQuery.inArray( this, ignored ) < 0 ) {\n                    jQuery.cleanData( getAll( this ) );\n                    if ( parent ) {\n                        parent.replaceChild( elem, this );\n                    }\n                }\n\n                // Force callback invocation\n            }, ignored );\n        }\n    } );\n\n    jQuery.each( {\n        appendTo: \"append\",\n        prependTo: \"prepend\",\n        insertBefore: \"before\",\n        insertAfter: \"after\",\n        replaceAll: \"replaceWith\"\n    }, function( name, original ) {\n        jQuery.fn[ name ] = function( selector ) {\n            var elems,\n                ret = [],\n                insert = jQuery( selector ),\n                last = insert.length - 1,\n                i = 0;\n\n            for ( ; i <= last; i++ ) {\n                elems = i === last ? this : this.clone( true );\n                jQuery( insert[ i ] )[ original ]( elems );\n\n                // Support: Android <=4.0 only, PhantomJS 1 only\n                // .get() because push.apply(_, arraylike) throws on ancient WebKit\n                push.apply( ret, elems.get() );\n            }\n\n            return this.pushStack( ret );\n        };\n    } );\n    var rnumnonpx = new RegExp( \"^(\" + pnum + \")(?!px)[a-z%]+$\", \"i\" );\n\n    var rcustomProp = /^--/;\n\n\n    var getStyles = function( elem ) {\n\n        // Support: IE <=11 only, Firefox <=30 (trac-15098, trac-14150)\n        // IE throws on elements created in popups\n        // FF meanwhile throws on frame elements through \"defaultView.getComputedStyle\"\n        var view = elem.ownerDocument.defaultView;\n\n        if ( !view || !view.opener ) {\n            view = window;\n        }\n\n        return view.getComputedStyle( elem );\n    };\n\n    var swap = function( elem, options, callback ) {\n        var ret, name,\n            old = {};\n\n        // Remember the old values, and insert the new ones\n        for ( name in options ) {\n            old[ name ] = elem.style[ name ];\n            elem.style[ name ] = options[ name ];\n        }\n\n        ret = callback.call( elem );\n\n        // Revert the old values\n        for ( name in options ) {\n            elem.style[ name ] = old[ name ];\n        }\n\n        return ret;\n    };\n\n\n    var rboxStyle = new RegExp( cssExpand.join( \"|\" ), \"i\" );\n\n\n\n    ( function() {\n\n        // Executing both pixelPosition & boxSizingReliable tests require only one layout\n        // so they're executed at the same time to save the second computation.\n        function computeStyleTests() {\n\n            // This is a singleton, we need to execute it only once\n            if ( !div ) {\n                return;\n            }\n\n            container.style.cssText = \"position:absolute;left:-11111px;width:60px;\" +\n                \"margin-top:1px;padding:0;border:0\";\n            div.style.cssText =\n                \"position:relative;display:block;box-sizing:border-box;overflow:scroll;\" +\n                \"margin:auto;border:1px;padding:1px;\" +\n                \"width:60%;top:1%\";\n            documentElement.appendChild( container ).appendChild( div );\n\n            var divStyle = window.getComputedStyle( div );\n            pixelPositionVal = divStyle.top !== \"1%\";\n\n            // Support: Android 4.0 - 4.3 only, Firefox <=3 - 44\n            reliableMarginLeftVal = roundPixelMeasures( divStyle.marginLeft ) === 12;\n\n            // Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3\n            // Some styles come back with percentage values, even though they shouldn't\n            div.style.right = \"60%\";\n            pixelBoxStylesVal = roundPixelMeasures( divStyle.right ) === 36;\n\n            // Support: IE 9 - 11 only\n            // Detect misreporting of content dimensions for box-sizing:border-box elements\n            boxSizingReliableVal = roundPixelMeasures( divStyle.width ) === 36;\n\n            // Support: IE 9 only\n            // Detect overflow:scroll screwiness (gh-3699)\n            // Support: Chrome <=64\n            // Don't get tricked when zoom affects offsetWidth (gh-4029)\n            div.style.position = \"absolute\";\n            scrollboxSizeVal = roundPixelMeasures( div.offsetWidth / 3 ) === 12;\n\n            documentElement.removeChild( container );\n\n            // Nullify the div so it wouldn't be stored in the memory and\n            // it will also be a sign that checks already performed\n            div = null;\n        }\n\n        function roundPixelMeasures( measure ) {\n            return Math.round( parseFloat( measure ) );\n        }\n\n        var pixelPositionVal, boxSizingReliableVal, scrollboxSizeVal, pixelBoxStylesVal,\n            reliableTrDimensionsVal, reliableMarginLeftVal,\n            container = document.createElement( \"div\" ),\n            div = document.createElement( \"div\" );\n\n        // Finish early in limited (non-browser) environments\n        if ( !div.style ) {\n            return;\n        }\n\n        // Support: IE <=9 - 11 only\n        // Style of cloned element affects source element cloned (trac-8908)\n        div.style.backgroundClip = \"content-box\";\n        div.cloneNode( true ).style.backgroundClip = \"\";\n        support.clearCloneStyle = div.style.backgroundClip === \"content-box\";\n\n        jQuery.extend( support, {\n            boxSizingReliable: function() {\n                computeStyleTests();\n                return boxSizingReliableVal;\n            },\n            pixelBoxStyles: function() {\n                computeStyleTests();\n                return pixelBoxStylesVal;\n            },\n            pixelPosition: function() {\n                computeStyleTests();\n                return pixelPositionVal;\n            },\n            reliableMarginLeft: function() {\n                computeStyleTests();\n                return reliableMarginLeftVal;\n            },\n            scrollboxSize: function() {\n                computeStyleTests();\n                return scrollboxSizeVal;\n            },\n\n            // Support: IE 9 - 11+, Edge 15 - 18+\n            // IE/Edge misreport `getComputedStyle` of table rows with width/height\n            // set in CSS while `offset*` properties report correct values.\n            // Behavior in IE 9 is more subtle than in newer versions & it passes\n            // some versions of this test; make sure not to make it pass there!\n            //\n            // Support: Firefox 70+\n            // Only Firefox includes border widths\n            // in computed dimensions. (gh-4529)\n            reliableTrDimensions: function() {\n                var table, tr, trChild, trStyle;\n                if ( reliableTrDimensionsVal == null ) {\n                    table = document.createElement( \"table\" );\n                    tr = document.createElement( \"tr\" );\n                    trChild = document.createElement( \"div\" );\n\n                    table.style.cssText = \"position:absolute;left:-11111px;border-collapse:separate\";\n                    tr.style.cssText = \"box-sizing:content-box;border:1px solid\";\n\n                    // Support: Chrome 86+\n                    // Height set through cssText does not get applied.\n                    // Computed height then comes back as 0.\n                    tr.style.height = \"1px\";\n                    trChild.style.height = \"9px\";\n\n                    // Support: Android 8 Chrome 86+\n                    // In our bodyBackground.html iframe,\n                    // display for all div elements is set to \"inline\",\n                    // which causes a problem only in Android 8 Chrome 86.\n                    // Ensuring the div is `display: block`\n                    // gets around this issue.\n                    trChild.style.display = \"block\";\n\n                    documentElement\n                        .appendChild( table )\n                        .appendChild( tr )\n                        .appendChild( trChild );\n\n                    trStyle = window.getComputedStyle( tr );\n                    reliableTrDimensionsVal = ( parseInt( trStyle.height, 10 ) +\n                        parseInt( trStyle.borderTopWidth, 10 ) +\n                        parseInt( trStyle.borderBottomWidth, 10 ) ) === tr.offsetHeight;\n\n                    documentElement.removeChild( table );\n                }\n                return reliableTrDimensionsVal;\n            }\n        } );\n    } )();\n\n\n    function curCSS( elem, name, computed ) {\n        var width, minWidth, maxWidth, ret,\n            isCustomProp = rcustomProp.test( name ),\n\n            // Support: Firefox 51+\n            // Retrieving style before computed somehow\n            // fixes an issue with getting wrong values\n            // on detached elements\n            style = elem.style;\n\n        computed = computed || getStyles( elem );\n\n        // getPropertyValue is needed for:\n        //   .css('filter') (IE 9 only, trac-12537)\n        //   .css('--customProperty) (gh-3144)\n        if ( computed ) {\n\n            // Support: IE <=9 - 11+\n            // IE only supports `\"float\"` in `getPropertyValue`; in computed styles\n            // it's only available as `\"cssFloat\"`. We no longer modify properties\n            // sent to `.css()` apart from camelCasing, so we need to check both.\n            // Normally, this would create difference in behavior: if\n            // `getPropertyValue` returns an empty string, the value returned\n            // by `.css()` would be `undefined`. This is usually the case for\n            // disconnected elements. However, in IE even disconnected elements\n            // with no styles return `\"none\"` for `getPropertyValue( \"float\" )`\n            ret = computed.getPropertyValue( name ) || computed[ name ];\n\n            if ( isCustomProp && ret ) {\n\n                // Support: Firefox 105+, Chrome <=105+\n                // Spec requires trimming whitespace for custom properties (gh-4926).\n                // Firefox only trims leading whitespace. Chrome just collapses\n                // both leading & trailing whitespace to a single space.\n                //\n                // Fall back to `undefined` if empty string returned.\n                // This collapses a missing definition with property defined\n                // and set to an empty string but there's no standard API\n                // allowing us to differentiate them without a performance penalty\n                // and returning `undefined` aligns with older jQuery.\n                //\n                // rtrimCSS treats U+000D CARRIAGE RETURN and U+000C FORM FEED\n                // as whitespace while CSS does not, but this is not a problem\n                // because CSS preprocessing replaces them with U+000A LINE FEED\n                // (which *is* CSS whitespace)\n                // https://www.w3.org/TR/css-syntax-3/#input-preprocessing\n                ret = ret.replace( rtrimCSS, \"$1\" ) || undefined;\n            }\n\n            if ( ret === \"\" && !isAttached( elem ) ) {\n                ret = jQuery.style( elem, name );\n            }\n\n            // A tribute to the \"awesome hack by Dean Edwards\"\n            // Android Browser returns percentage for some values,\n            // but width seems to be reliably pixels.\n            // This is against the CSSOM draft spec:\n            // https://drafts.csswg.org/cssom/#resolved-values\n            if ( !support.pixelBoxStyles() && rnumnonpx.test( ret ) && rboxStyle.test( name ) ) {\n\n                // Remember the original values\n                width = style.width;\n                minWidth = style.minWidth;\n                maxWidth = style.maxWidth;\n\n                // Put in the new values to get a computed value out\n                style.minWidth = style.maxWidth = style.width = ret;\n                ret = computed.width;\n\n                // Revert the changed values\n                style.width = width;\n                style.minWidth = minWidth;\n                style.maxWidth = maxWidth;\n            }\n        }\n\n        return ret !== undefined ?\n\n            // Support: IE <=9 - 11 only\n            // IE returns zIndex value as an integer.\n            ret + \"\" :\n            ret;\n    }\n\n\n    function addGetHookIf( conditionFn, hookFn ) {\n\n        // Define the hook, we'll check on the first run if it's really needed.\n        return {\n            get: function() {\n                if ( conditionFn() ) {\n\n                    // Hook not needed (or it's not possible to use it due\n                    // to missing dependency), remove it.\n                    delete this.get;\n                    return;\n                }\n\n                // Hook needed; redefine it so that the support test is not executed again.\n                return ( this.get = hookFn ).apply( this, arguments );\n            }\n        };\n    }\n\n\n    var cssPrefixes = [ \"Webkit\", \"Moz\", \"ms\" ],\n        emptyStyle = document.createElement( \"div\" ).style,\n        vendorProps = {};\n\n// Return a vendor-prefixed property or undefined\n    function vendorPropName( name ) {\n\n        // Check for vendor prefixed names\n        var capName = name[ 0 ].toUpperCase() + name.slice( 1 ),\n            i = cssPrefixes.length;\n\n        while ( i-- ) {\n            name = cssPrefixes[ i ] + capName;\n            if ( name in emptyStyle ) {\n                return name;\n            }\n        }\n    }\n\n// Return a potentially-mapped jQuery.cssProps or vendor prefixed property\n    function finalPropName( name ) {\n        var final = jQuery.cssProps[ name ] || vendorProps[ name ];\n\n        if ( final ) {\n            return final;\n        }\n        if ( name in emptyStyle ) {\n            return name;\n        }\n        return vendorProps[ name ] = vendorPropName( name ) || name;\n    }\n\n\n    var\n\n        // Swappable if display is none or starts with table\n        // except \"table\", \"table-cell\", or \"table-caption\"\n        // See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display\n        rdisplayswap = /^(none|table(?!-c[ea]).+)/,\n        cssShow = { position: \"absolute\", visibility: \"hidden\", display: \"block\" },\n        cssNormalTransform = {\n            letterSpacing: \"0\",\n            fontWeight: \"400\"\n        };\n\n    function setPositiveNumber( _elem, value, subtract ) {\n\n        // Any relative (+/-) values have already been\n        // normalized at this point\n        var matches = rcssNum.exec( value );\n        return matches ?\n\n            // Guard against undefined \"subtract\", e.g., when used as in cssHooks\n            Math.max( 0, matches[ 2 ] - ( subtract || 0 ) ) + ( matches[ 3 ] || \"px\" ) :\n            value;\n    }\n\n    function boxModelAdjustment( elem, dimension, box, isBorderBox, styles, computedVal ) {\n        var i = dimension === \"width\" ? 1 : 0,\n            extra = 0,\n            delta = 0,\n            marginDelta = 0;\n\n        // Adjustment may not be necessary\n        if ( box === ( isBorderBox ? \"border\" : \"content\" ) ) {\n            return 0;\n        }\n\n        for ( ; i < 4; i += 2 ) {\n\n            // Both box models exclude margin\n            // Count margin delta separately to only add it after scroll gutter adjustment.\n            // This is needed to make negative margins work with `outerHeight( true )` (gh-3982).\n            if ( box === \"margin\" ) {\n                marginDelta += jQuery.css( elem, box + cssExpand[ i ], true, styles );\n            }\n\n            // If we get here with a content-box, we're seeking \"padding\" or \"border\" or \"margin\"\n            if ( !isBorderBox ) {\n\n                // Add padding\n                delta += jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n\n                // For \"border\" or \"margin\", add border\n                if ( box !== \"padding\" ) {\n                    delta += jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n\n                    // But still keep track of it otherwise\n                } else {\n                    extra += jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n                }\n\n                // If we get here with a border-box (content + padding + border), we're seeking \"content\" or\n                // \"padding\" or \"margin\"\n            } else {\n\n                // For \"content\", subtract padding\n                if ( box === \"content\" ) {\n                    delta -= jQuery.css( elem, \"padding\" + cssExpand[ i ], true, styles );\n                }\n\n                // For \"content\" or \"padding\", subtract border\n                if ( box !== \"margin\" ) {\n                    delta -= jQuery.css( elem, \"border\" + cssExpand[ i ] + \"Width\", true, styles );\n                }\n            }\n        }\n\n        // Account for positive content-box scroll gutter when requested by providing computedVal\n        if ( !isBorderBox && computedVal >= 0 ) {\n\n            // offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border\n            // Assuming integer scroll gutter, subtract the rest and round down\n            delta += Math.max( 0, Math.ceil(\n                elem[ \"offset\" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -\n                computedVal -\n                delta -\n                extra -\n                0.5\n\n                // If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter\n                // Use an explicit zero to avoid NaN (gh-3964)\n            ) ) || 0;\n        }\n\n        return delta + marginDelta;\n    }\n\n    function getWidthOrHeight( elem, dimension, extra ) {\n\n        // Start with computed style\n        var styles = getStyles( elem ),\n\n            // To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).\n            // Fake content-box until we know it's needed to know the true value.\n            boxSizingNeeded = !support.boxSizingReliable() || extra,\n            isBorderBox = boxSizingNeeded &&\n                jQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\",\n            valueIsBorderBox = isBorderBox,\n\n            val = curCSS( elem, dimension, styles ),\n            offsetProp = \"offset\" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 );\n\n        // Support: Firefox <=54\n        // Return a confounding non-pixel value or feign ignorance, as appropriate.\n        if ( rnumnonpx.test( val ) ) {\n            if ( !extra ) {\n                return val;\n            }\n            val = \"auto\";\n        }\n\n\n        // Support: IE 9 - 11 only\n        // Use offsetWidth/offsetHeight for when box sizing is unreliable.\n        // In those cases, the computed value can be trusted to be border-box.\n        if ( ( !support.boxSizingReliable() && isBorderBox ||\n\n                // Support: IE 10 - 11+, Edge 15 - 18+\n                // IE/Edge misreport `getComputedStyle` of table rows with width/height\n                // set in CSS while `offset*` properties report correct values.\n                // Interestingly, in some cases IE 9 doesn't suffer from this issue.\n                !support.reliableTrDimensions() && nodeName( elem, \"tr\" ) ||\n\n                // Fall back to offsetWidth/offsetHeight when value is \"auto\"\n                // This happens for inline elements with no explicit setting (gh-3571)\n                val === \"auto\" ||\n\n                // Support: Android <=4.1 - 4.3 only\n                // Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)\n                !parseFloat( val ) && jQuery.css( elem, \"display\", false, styles ) === \"inline\" ) &&\n\n            // Make sure the element is visible & connected\n            elem.getClientRects().length ) {\n\n            isBorderBox = jQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\";\n\n            // Where available, offsetWidth/offsetHeight approximate border box dimensions.\n            // Where not available (e.g., SVG), assume unreliable box-sizing and interpret the\n            // retrieved value as a content box dimension.\n            valueIsBorderBox = offsetProp in elem;\n            if ( valueIsBorderBox ) {\n                val = elem[ offsetProp ];\n            }\n        }\n\n        // Normalize \"\" and auto\n        val = parseFloat( val ) || 0;\n\n        // Adjust for the element's box model\n        return ( val +\n            boxModelAdjustment(\n                elem,\n                dimension,\n                extra || ( isBorderBox ? \"border\" : \"content\" ),\n                valueIsBorderBox,\n                styles,\n\n                // Provide the current computed size to request scroll gutter calculation (gh-3589)\n                val\n            )\n        ) + \"px\";\n    }\n\n    jQuery.extend( {\n\n        // Add in style property hooks for overriding the default\n        // behavior of getting and setting a style property\n        cssHooks: {\n            opacity: {\n                get: function( elem, computed ) {\n                    if ( computed ) {\n\n                        // We should always get a number back from opacity\n                        var ret = curCSS( elem, \"opacity\" );\n                        return ret === \"\" ? \"1\" : ret;\n                    }\n                }\n            }\n        },\n\n        // Don't automatically add \"px\" to these possibly-unitless properties\n        cssNumber: {\n            animationIterationCount: true,\n            aspectRatio: true,\n            borderImageSlice: true,\n            columnCount: true,\n            flexGrow: true,\n            flexShrink: true,\n            fontWeight: true,\n            gridArea: true,\n            gridColumn: true,\n            gridColumnEnd: true,\n            gridColumnStart: true,\n            gridRow: true,\n            gridRowEnd: true,\n            gridRowStart: true,\n            lineHeight: true,\n            opacity: true,\n            order: true,\n            orphans: true,\n            scale: true,\n            widows: true,\n            zIndex: true,\n            zoom: true,\n\n            // SVG-related\n            fillOpacity: true,\n            floodOpacity: true,\n            stopOpacity: true,\n            strokeMiterlimit: true,\n            strokeOpacity: true\n        },\n\n        // Add in properties whose names you wish to fix before\n        // setting or getting the value\n        cssProps: {},\n\n        // Get and set the style property on a DOM Node\n        style: function( elem, name, value, extra ) {\n\n            // Don't set styles on text and comment nodes\n            if ( !elem || elem.nodeType === 3 || elem.nodeType === 8 || !elem.style ) {\n                return;\n            }\n\n            // Make sure that we're working with the right name\n            var ret, type, hooks,\n                origName = camelCase( name ),\n                isCustomProp = rcustomProp.test( name ),\n                style = elem.style;\n\n            // Make sure that we're working with the right name. We don't\n            // want to query the value if it is a CSS custom property\n            // since they are user-defined.\n            if ( !isCustomProp ) {\n                name = finalPropName( origName );\n            }\n\n            // Gets hook for the prefixed version, then unprefixed version\n            hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n            // Check if we're setting a value\n            if ( value !== undefined ) {\n                type = typeof value;\n\n                // Convert \"+=\" or \"-=\" to relative numbers (trac-7345)\n                if ( type === \"string\" && ( ret = rcssNum.exec( value ) ) && ret[ 1 ] ) {\n                    value = adjustCSS( elem, name, ret );\n\n                    // Fixes bug trac-9237\n                    type = \"number\";\n                }\n\n                // Make sure that null and NaN values aren't set (trac-7116)\n                if ( value == null || value !== value ) {\n                    return;\n                }\n\n                // If a number was passed in, add the unit (except for certain CSS properties)\n                // The isCustomProp check can be removed in jQuery 4.0 when we only auto-append\n                // \"px\" to a few hardcoded values.\n                if ( type === \"number\" && !isCustomProp ) {\n                    value += ret && ret[ 3 ] || ( jQuery.cssNumber[ origName ] ? \"\" : \"px\" );\n                }\n\n                // background-* props affect original clone's values\n                if ( !support.clearCloneStyle && value === \"\" && name.indexOf( \"background\" ) === 0 ) {\n                    style[ name ] = \"inherit\";\n                }\n\n                // If a hook was provided, use that value, otherwise just set the specified value\n                if ( !hooks || !( \"set\" in hooks ) ||\n                    ( value = hooks.set( elem, value, extra ) ) !== undefined ) {\n\n                    if ( isCustomProp ) {\n                        style.setProperty( name, value );\n                    } else {\n                        style[ name ] = value;\n                    }\n                }\n\n            } else {\n\n                // If a hook was provided get the non-computed value from there\n                if ( hooks && \"get\" in hooks &&\n                    ( ret = hooks.get( elem, false, extra ) ) !== undefined ) {\n\n                    return ret;\n                }\n\n                // Otherwise just get the value from the style object\n                return style[ name ];\n            }\n        },\n\n        css: function( elem, name, extra, styles ) {\n            var val, num, hooks,\n                origName = camelCase( name ),\n                isCustomProp = rcustomProp.test( name );\n\n            // Make sure that we're working with the right name. We don't\n            // want to modify the value if it is a CSS custom property\n            // since they are user-defined.\n            if ( !isCustomProp ) {\n                name = finalPropName( origName );\n            }\n\n            // Try prefixed name followed by the unprefixed name\n            hooks = jQuery.cssHooks[ name ] || jQuery.cssHooks[ origName ];\n\n            // If a hook was provided get the computed value from there\n            if ( hooks && \"get\" in hooks ) {\n                val = hooks.get( elem, true, extra );\n            }\n\n            // Otherwise, if a way to get the computed value exists, use that\n            if ( val === undefined ) {\n                val = curCSS( elem, name, styles );\n            }\n\n            // Convert \"normal\" to computed value\n            if ( val === \"normal\" && name in cssNormalTransform ) {\n                val = cssNormalTransform[ name ];\n            }\n\n            // Make numeric if forced or a qualifier was provided and val looks numeric\n            if ( extra === \"\" || extra ) {\n                num = parseFloat( val );\n                return extra === true || isFinite( num ) ? num || 0 : val;\n            }\n\n            return val;\n        }\n    } );\n\n    jQuery.each( [ \"height\", \"width\" ], function( _i, dimension ) {\n        jQuery.cssHooks[ dimension ] = {\n            get: function( elem, computed, extra ) {\n                if ( computed ) {\n\n                    // Certain elements can have dimension info if we invisibly show them\n                    // but it must have a current display style that would benefit\n                    return rdisplayswap.test( jQuery.css( elem, \"display\" ) ) &&\n\n                    // Support: Safari 8+\n                    // Table columns in Safari have non-zero offsetWidth & zero\n                    // getBoundingClientRect().width unless display is changed.\n                    // Support: IE <=11 only\n                    // Running getBoundingClientRect on a disconnected node\n                    // in IE throws an error.\n                    ( !elem.getClientRects().length || !elem.getBoundingClientRect().width ) ?\n                        swap( elem, cssShow, function() {\n                            return getWidthOrHeight( elem, dimension, extra );\n                        } ) :\n                        getWidthOrHeight( elem, dimension, extra );\n                }\n            },\n\n            set: function( elem, value, extra ) {\n                var matches,\n                    styles = getStyles( elem ),\n\n                    // Only read styles.position if the test has a chance to fail\n                    // to avoid forcing a reflow.\n                    scrollboxSizeBuggy = !support.scrollboxSize() &&\n                        styles.position === \"absolute\",\n\n                    // To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)\n                    boxSizingNeeded = scrollboxSizeBuggy || extra,\n                    isBorderBox = boxSizingNeeded &&\n                        jQuery.css( elem, \"boxSizing\", false, styles ) === \"border-box\",\n                    subtract = extra ?\n                        boxModelAdjustment(\n                            elem,\n                            dimension,\n                            extra,\n                            isBorderBox,\n                            styles\n                        ) :\n                        0;\n\n                // Account for unreliable border-box dimensions by comparing offset* to computed and\n                // faking a content-box to get border and padding (gh-3699)\n                if ( isBorderBox && scrollboxSizeBuggy ) {\n                    subtract -= Math.ceil(\n                        elem[ \"offset\" + dimension[ 0 ].toUpperCase() + dimension.slice( 1 ) ] -\n                        parseFloat( styles[ dimension ] ) -\n                        boxModelAdjustment( elem, dimension, \"border\", false, styles ) -\n                        0.5\n                    );\n                }\n\n                // Convert to pixels if value adjustment is needed\n                if ( subtract && ( matches = rcssNum.exec( value ) ) &&\n                    ( matches[ 3 ] || \"px\" ) !== \"px\" ) {\n\n                    elem.style[ dimension ] = value;\n                    value = jQuery.css( elem, dimension );\n                }\n\n                return setPositiveNumber( elem, value, subtract );\n            }\n        };\n    } );\n\n    jQuery.cssHooks.marginLeft = addGetHookIf( support.reliableMarginLeft,\n        function( elem, computed ) {\n            if ( computed ) {\n                return ( parseFloat( curCSS( elem, \"marginLeft\" ) ) ||\n                    elem.getBoundingClientRect().left -\n                    swap( elem, { marginLeft: 0 }, function() {\n                        return elem.getBoundingClientRect().left;\n                    } )\n                ) + \"px\";\n            }\n        }\n    );\n\n// These hooks are used by animate to expand properties\n    jQuery.each( {\n        margin: \"\",\n        padding: \"\",\n        border: \"Width\"\n    }, function( prefix, suffix ) {\n        jQuery.cssHooks[ prefix + suffix ] = {\n            expand: function( value ) {\n                var i = 0,\n                    expanded = {},\n\n                    // Assumes a single number if not a string\n                    parts = typeof value === \"string\" ? value.split( \" \" ) : [ value ];\n\n                for ( ; i < 4; i++ ) {\n                    expanded[ prefix + cssExpand[ i ] + suffix ] =\n                        parts[ i ] || parts[ i - 2 ] || parts[ 0 ];\n                }\n\n                return expanded;\n            }\n        };\n\n        if ( prefix !== \"margin\" ) {\n            jQuery.cssHooks[ prefix + suffix ].set = setPositiveNumber;\n        }\n    } );\n\n    jQuery.fn.extend( {\n        css: function( name, value ) {\n            return access( this, function( elem, name, value ) {\n                var styles, len,\n                    map = {},\n                    i = 0;\n\n                if ( Array.isArray( name ) ) {\n                    styles = getStyles( elem );\n                    len = name.length;\n\n                    for ( ; i < len; i++ ) {\n                        map[ name[ i ] ] = jQuery.css( elem, name[ i ], false, styles );\n                    }\n\n                    return map;\n                }\n\n                return value !== undefined ?\n                    jQuery.style( elem, name, value ) :\n                    jQuery.css( elem, name );\n            }, name, value, arguments.length > 1 );\n        }\n    } );\n\n\n    function Tween( elem, options, prop, end, easing ) {\n        return new Tween.prototype.init( elem, options, prop, end, easing );\n    }\n    jQuery.Tween = Tween;\n\n    Tween.prototype = {\n        constructor: Tween,\n        init: function( elem, options, prop, end, easing, unit ) {\n            this.elem = elem;\n            this.prop = prop;\n            this.easing = easing || jQuery.easing._default;\n            this.options = options;\n            this.start = this.now = this.cur();\n            this.end = end;\n            this.unit = unit || ( jQuery.cssNumber[ prop ] ? \"\" : \"px\" );\n        },\n        cur: function() {\n            var hooks = Tween.propHooks[ this.prop ];\n\n            return hooks && hooks.get ?\n                hooks.get( this ) :\n                Tween.propHooks._default.get( this );\n        },\n        run: function( percent ) {\n            var eased,\n                hooks = Tween.propHooks[ this.prop ];\n\n            if ( this.options.duration ) {\n                this.pos = eased = jQuery.easing[ this.easing ](\n                    percent, this.options.duration * percent, 0, 1, this.options.duration\n                );\n            } else {\n                this.pos = eased = percent;\n            }\n            this.now = ( this.end - this.start ) * eased + this.start;\n\n            if ( this.options.step ) {\n                this.options.step.call( this.elem, this.now, this );\n            }\n\n            if ( hooks && hooks.set ) {\n                hooks.set( this );\n            } else {\n                Tween.propHooks._default.set( this );\n            }\n            return this;\n        }\n    };\n\n    Tween.prototype.init.prototype = Tween.prototype;\n\n    Tween.propHooks = {\n        _default: {\n            get: function( tween ) {\n                var result;\n\n                // Use a property on the element directly when it is not a DOM element,\n                // or when there is no matching style property that exists.\n                if ( tween.elem.nodeType !== 1 ||\n                    tween.elem[ tween.prop ] != null && tween.elem.style[ tween.prop ] == null ) {\n                    return tween.elem[ tween.prop ];\n                }\n\n                // Passing an empty string as a 3rd parameter to .css will automatically\n                // attempt a parseFloat and fallback to a string if the parse fails.\n                // Simple values such as \"10px\" are parsed to Float;\n                // complex values such as \"rotate(1rad)\" are returned as-is.\n                result = jQuery.css( tween.elem, tween.prop, \"\" );\n\n                // Empty strings, null, undefined and \"auto\" are converted to 0.\n                return !result || result === \"auto\" ? 0 : result;\n            },\n            set: function( tween ) {\n\n                // Use step hook for back compat.\n                // Use cssHook if its there.\n                // Use .style if available and use plain properties where available.\n                if ( jQuery.fx.step[ tween.prop ] ) {\n                    jQuery.fx.step[ tween.prop ]( tween );\n                } else if ( tween.elem.nodeType === 1 && (\n                    jQuery.cssHooks[ tween.prop ] ||\n                    tween.elem.style[ finalPropName( tween.prop ) ] != null ) ) {\n                    jQuery.style( tween.elem, tween.prop, tween.now + tween.unit );\n                } else {\n                    tween.elem[ tween.prop ] = tween.now;\n                }\n            }\n        }\n    };\n\n// Support: IE <=9 only\n// Panic based approach to setting things on disconnected nodes\n    Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {\n        set: function( tween ) {\n            if ( tween.elem.nodeType && tween.elem.parentNode ) {\n                tween.elem[ tween.prop ] = tween.now;\n            }\n        }\n    };\n\n    jQuery.easing = {\n        linear: function( p ) {\n            return p;\n        },\n        swing: function( p ) {\n            return 0.5 - Math.cos( p * Math.PI ) / 2;\n        },\n        _default: \"swing\"\n    };\n\n    jQuery.fx = Tween.prototype.init;\n\n// Back compat <1.8 extension point\n    jQuery.fx.step = {};\n\n\n\n\n    var\n        fxNow, inProgress,\n        rfxtypes = /^(?:toggle|show|hide)$/,\n        rrun = /queueHooks$/;\n\n    function schedule() {\n        if ( inProgress ) {\n            if ( document.hidden === false && window.requestAnimationFrame ) {\n                window.requestAnimationFrame( schedule );\n            } else {\n                window.setTimeout( schedule, jQuery.fx.interval );\n            }\n\n            jQuery.fx.tick();\n        }\n    }\n\n// Animations created synchronously will run synchronously\n    function createFxNow() {\n        window.setTimeout( function() {\n            fxNow = undefined;\n        } );\n        return ( fxNow = Date.now() );\n    }\n\n// Generate parameters to create a standard animation\n    function genFx( type, includeWidth ) {\n        var which,\n            i = 0,\n            attrs = { height: type };\n\n        // If we include width, step value is 1 to do all cssExpand values,\n        // otherwise step value is 2 to skip over Left and Right\n        includeWidth = includeWidth ? 1 : 0;\n        for ( ; i < 4; i += 2 - includeWidth ) {\n            which = cssExpand[ i ];\n            attrs[ \"margin\" + which ] = attrs[ \"padding\" + which ] = type;\n        }\n\n        if ( includeWidth ) {\n            attrs.opacity = attrs.width = type;\n        }\n\n        return attrs;\n    }\n\n    function createTween( value, prop, animation ) {\n        var tween,\n            collection = ( Animation.tweeners[ prop ] || [] ).concat( Animation.tweeners[ \"*\" ] ),\n            index = 0,\n            length = collection.length;\n        for ( ; index < length; index++ ) {\n            if ( ( tween = collection[ index ].call( animation, prop, value ) ) ) {\n\n                // We're done with this property\n                return tween;\n            }\n        }\n    }\n\n    function defaultPrefilter( elem, props, opts ) {\n        var prop, value, toggle, hooks, oldfire, propTween, restoreDisplay, display,\n            isBox = \"width\" in props || \"height\" in props,\n            anim = this,\n            orig = {},\n            style = elem.style,\n            hidden = elem.nodeType && isHiddenWithinTree( elem ),\n            dataShow = dataPriv.get( elem, \"fxshow\" );\n\n        // Queue-skipping animations hijack the fx hooks\n        if ( !opts.queue ) {\n            hooks = jQuery._queueHooks( elem, \"fx\" );\n            if ( hooks.unqueued == null ) {\n                hooks.unqueued = 0;\n                oldfire = hooks.empty.fire;\n                hooks.empty.fire = function() {\n                    if ( !hooks.unqueued ) {\n                        oldfire();\n                    }\n                };\n            }\n            hooks.unqueued++;\n\n            anim.always( function() {\n\n                // Ensure the complete handler is called before this completes\n                anim.always( function() {\n                    hooks.unqueued--;\n                    if ( !jQuery.queue( elem, \"fx\" ).length ) {\n                        hooks.empty.fire();\n                    }\n                } );\n            } );\n        }\n\n        // Detect show/hide animations\n        for ( prop in props ) {\n            value = props[ prop ];\n            if ( rfxtypes.test( value ) ) {\n                delete props[ prop ];\n                toggle = toggle || value === \"toggle\";\n                if ( value === ( hidden ? \"hide\" : \"show\" ) ) {\n\n                    // Pretend to be hidden if this is a \"show\" and\n                    // there is still data from a stopped show/hide\n                    if ( value === \"show\" && dataShow && dataShow[ prop ] !== undefined ) {\n                        hidden = true;\n\n                        // Ignore all other no-op show/hide data\n                    } else {\n                        continue;\n                    }\n                }\n                orig[ prop ] = dataShow && dataShow[ prop ] || jQuery.style( elem, prop );\n            }\n        }\n\n        // Bail out if this is a no-op like .hide().hide()\n        propTween = !jQuery.isEmptyObject( props );\n        if ( !propTween && jQuery.isEmptyObject( orig ) ) {\n            return;\n        }\n\n        // Restrict \"overflow\" and \"display\" styles during box animations\n        if ( isBox && elem.nodeType === 1 ) {\n\n            // Support: IE <=9 - 11, Edge 12 - 15\n            // Record all 3 overflow attributes because IE does not infer the shorthand\n            // from identically-valued overflowX and overflowY and Edge just mirrors\n            // the overflowX value there.\n            opts.overflow = [ style.overflow, style.overflowX, style.overflowY ];\n\n            // Identify a display type, preferring old show/hide data over the CSS cascade\n            restoreDisplay = dataShow && dataShow.display;\n            if ( restoreDisplay == null ) {\n                restoreDisplay = dataPriv.get( elem, \"display\" );\n            }\n            display = jQuery.css( elem, \"display\" );\n            if ( display === \"none\" ) {\n                if ( restoreDisplay ) {\n                    display = restoreDisplay;\n                } else {\n\n                    // Get nonempty value(s) by temporarily forcing visibility\n                    showHide( [ elem ], true );\n                    restoreDisplay = elem.style.display || restoreDisplay;\n                    display = jQuery.css( elem, \"display\" );\n                    showHide( [ elem ] );\n                }\n            }\n\n            // Animate inline elements as inline-block\n            if ( display === \"inline\" || display === \"inline-block\" && restoreDisplay != null ) {\n                if ( jQuery.css( elem, \"float\" ) === \"none\" ) {\n\n                    // Restore the original display value at the end of pure show/hide animations\n                    if ( !propTween ) {\n                        anim.done( function() {\n                            style.display = restoreDisplay;\n                        } );\n                        if ( restoreDisplay == null ) {\n                            display = style.display;\n                            restoreDisplay = display === \"none\" ? \"\" : display;\n                        }\n                    }\n                    style.display = \"inline-block\";\n                }\n            }\n        }\n\n        if ( opts.overflow ) {\n            style.overflow = \"hidden\";\n            anim.always( function() {\n                style.overflow = opts.overflow[ 0 ];\n                style.overflowX = opts.overflow[ 1 ];\n                style.overflowY = opts.overflow[ 2 ];\n            } );\n        }\n\n        // Implement show/hide animations\n        propTween = false;\n        for ( prop in orig ) {\n\n            // General show/hide setup for this element animation\n            if ( !propTween ) {\n                if ( dataShow ) {\n                    if ( \"hidden\" in dataShow ) {\n                        hidden = dataShow.hidden;\n                    }\n                } else {\n                    dataShow = dataPriv.access( elem, \"fxshow\", { display: restoreDisplay } );\n                }\n\n                // Store hidden/visible for toggle so `.stop().toggle()` \"reverses\"\n                if ( toggle ) {\n                    dataShow.hidden = !hidden;\n                }\n\n                // Show elements before animating them\n                if ( hidden ) {\n                    showHide( [ elem ], true );\n                }\n\n                /* eslint-disable no-loop-func */\n\n                anim.done( function() {\n\n                    /* eslint-enable no-loop-func */\n\n                    // The final step of a \"hide\" animation is actually hiding the element\n                    if ( !hidden ) {\n                        showHide( [ elem ] );\n                    }\n                    dataPriv.remove( elem, \"fxshow\" );\n                    for ( prop in orig ) {\n                        jQuery.style( elem, prop, orig[ prop ] );\n                    }\n                } );\n            }\n\n            // Per-property setup\n            propTween = createTween( hidden ? dataShow[ prop ] : 0, prop, anim );\n            if ( !( prop in dataShow ) ) {\n                dataShow[ prop ] = propTween.start;\n                if ( hidden ) {\n                    propTween.end = propTween.start;\n                    propTween.start = 0;\n                }\n            }\n        }\n    }\n\n    function propFilter( props, specialEasing ) {\n        var index, name, easing, value, hooks;\n\n        // camelCase, specialEasing and expand cssHook pass\n        for ( index in props ) {\n            name = camelCase( index );\n            easing = specialEasing[ name ];\n            value = props[ index ];\n            if ( Array.isArray( value ) ) {\n                easing = value[ 1 ];\n                value = props[ index ] = value[ 0 ];\n            }\n\n            if ( index !== name ) {\n                props[ name ] = value;\n                delete props[ index ];\n            }\n\n            hooks = jQuery.cssHooks[ name ];\n            if ( hooks && \"expand\" in hooks ) {\n                value = hooks.expand( value );\n                delete props[ name ];\n\n                // Not quite $.extend, this won't overwrite existing keys.\n                // Reusing 'index' because we have the correct \"name\"\n                for ( index in value ) {\n                    if ( !( index in props ) ) {\n                        props[ index ] = value[ index ];\n                        specialEasing[ index ] = easing;\n                    }\n                }\n            } else {\n                specialEasing[ name ] = easing;\n            }\n        }\n    }\n\n    function Animation( elem, properties, options ) {\n        var result,\n            stopped,\n            index = 0,\n            length = Animation.prefilters.length,\n            deferred = jQuery.Deferred().always( function() {\n\n                // Don't match elem in the :animated selector\n                delete tick.elem;\n            } ),\n            tick = function() {\n                if ( stopped ) {\n                    return false;\n                }\n                var currentTime = fxNow || createFxNow(),\n                    remaining = Math.max( 0, animation.startTime + animation.duration - currentTime ),\n\n                    // Support: Android 2.3 only\n                    // Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (trac-12497)\n                    temp = remaining / animation.duration || 0,\n                    percent = 1 - temp,\n                    index = 0,\n                    length = animation.tweens.length;\n\n                for ( ; index < length; index++ ) {\n                    animation.tweens[ index ].run( percent );\n                }\n\n                deferred.notifyWith( elem, [ animation, percent, remaining ] );\n\n                // If there's more to do, yield\n                if ( percent < 1 && length ) {\n                    return remaining;\n                }\n\n                // If this was an empty animation, synthesize a final progress notification\n                if ( !length ) {\n                    deferred.notifyWith( elem, [ animation, 1, 0 ] );\n                }\n\n                // Resolve the animation and report its conclusion\n                deferred.resolveWith( elem, [ animation ] );\n                return false;\n            },\n            animation = deferred.promise( {\n                elem: elem,\n                props: jQuery.extend( {}, properties ),\n                opts: jQuery.extend( true, {\n                    specialEasing: {},\n                    easing: jQuery.easing._default\n                }, options ),\n                originalProperties: properties,\n                originalOptions: options,\n                startTime: fxNow || createFxNow(),\n                duration: options.duration,\n                tweens: [],\n                createTween: function( prop, end ) {\n                    var tween = jQuery.Tween( elem, animation.opts, prop, end,\n                        animation.opts.specialEasing[ prop ] || animation.opts.easing );\n                    animation.tweens.push( tween );\n                    return tween;\n                },\n                stop: function( gotoEnd ) {\n                    var index = 0,\n\n                        // If we are going to the end, we want to run all the tweens\n                        // otherwise we skip this part\n                        length = gotoEnd ? animation.tweens.length : 0;\n                    if ( stopped ) {\n                        return this;\n                    }\n                    stopped = true;\n                    for ( ; index < length; index++ ) {\n                        animation.tweens[ index ].run( 1 );\n                    }\n\n                    // Resolve when we played the last frame; otherwise, reject\n                    if ( gotoEnd ) {\n                        deferred.notifyWith( elem, [ animation, 1, 0 ] );\n                        deferred.resolveWith( elem, [ animation, gotoEnd ] );\n                    } else {\n                        deferred.rejectWith( elem, [ animation, gotoEnd ] );\n                    }\n                    return this;\n                }\n            } ),\n            props = animation.props;\n\n        propFilter( props, animation.opts.specialEasing );\n\n        for ( ; index < length; index++ ) {\n            result = Animation.prefilters[ index ].call( animation, elem, props, animation.opts );\n            if ( result ) {\n                if ( isFunction( result.stop ) ) {\n                    jQuery._queueHooks( animation.elem, animation.opts.queue ).stop =\n                        result.stop.bind( result );\n                }\n                return result;\n            }\n        }\n\n        jQuery.map( props, createTween, animation );\n\n        if ( isFunction( animation.opts.start ) ) {\n            animation.opts.start.call( elem, animation );\n        }\n\n        // Attach callbacks from options\n        animation\n            .progress( animation.opts.progress )\n            .done( animation.opts.done, animation.opts.complete )\n            .fail( animation.opts.fail )\n            .always( animation.opts.always );\n\n        jQuery.fx.timer(\n            jQuery.extend( tick, {\n                elem: elem,\n                anim: animation,\n                queue: animation.opts.queue\n            } )\n        );\n\n        return animation;\n    }\n\n    jQuery.Animation = jQuery.extend( Animation, {\n\n        tweeners: {\n            \"*\": [ function( prop, value ) {\n                var tween = this.createTween( prop, value );\n                adjustCSS( tween.elem, prop, rcssNum.exec( value ), tween );\n                return tween;\n            } ]\n        },\n\n        tweener: function( props, callback ) {\n            if ( isFunction( props ) ) {\n                callback = props;\n                props = [ \"*\" ];\n            } else {\n                props = props.match( rnothtmlwhite );\n            }\n\n            var prop,\n                index = 0,\n                length = props.length;\n\n            for ( ; index < length; index++ ) {\n                prop = props[ index ];\n                Animation.tweeners[ prop ] = Animation.tweeners[ prop ] || [];\n                Animation.tweeners[ prop ].unshift( callback );\n            }\n        },\n\n        prefilters: [ defaultPrefilter ],\n\n        prefilter: function( callback, prepend ) {\n            if ( prepend ) {\n                Animation.prefilters.unshift( callback );\n            } else {\n                Animation.prefilters.push( callback );\n            }\n        }\n    } );\n\n    jQuery.speed = function( speed, easing, fn ) {\n        var opt = speed && typeof speed === \"object\" ? jQuery.extend( {}, speed ) : {\n            complete: fn || !fn && easing ||\n                isFunction( speed ) && speed,\n            duration: speed,\n            easing: fn && easing || easing && !isFunction( easing ) && easing\n        };\n\n        // Go to the end state if fx are off\n        if ( jQuery.fx.off ) {\n            opt.duration = 0;\n\n        } else {\n            if ( typeof opt.duration !== \"number\" ) {\n                if ( opt.duration in jQuery.fx.speeds ) {\n                    opt.duration = jQuery.fx.speeds[ opt.duration ];\n\n                } else {\n                    opt.duration = jQuery.fx.speeds._default;\n                }\n            }\n        }\n\n        // Normalize opt.queue - true/undefined/null -> \"fx\"\n        if ( opt.queue == null || opt.queue === true ) {\n            opt.queue = \"fx\";\n        }\n\n        // Queueing\n        opt.old = opt.complete;\n\n        opt.complete = function() {\n            if ( isFunction( opt.old ) ) {\n                opt.old.call( this );\n            }\n\n            if ( opt.queue ) {\n                jQuery.dequeue( this, opt.queue );\n            }\n        };\n\n        return opt;\n    };\n\n    jQuery.fn.extend( {\n        fadeTo: function( speed, to, easing, callback ) {\n\n            // Show any hidden elements after setting opacity to 0\n            return this.filter( isHiddenWithinTree ).css( \"opacity\", 0 ).show()\n\n                // Animate to the value specified\n                .end().animate( { opacity: to }, speed, easing, callback );\n        },\n        animate: function( prop, speed, easing, callback ) {\n            var empty = jQuery.isEmptyObject( prop ),\n                optall = jQuery.speed( speed, easing, callback ),\n                doAnimation = function() {\n\n                    // Operate on a copy of prop so per-property easing won't be lost\n                    var anim = Animation( this, jQuery.extend( {}, prop ), optall );\n\n                    // Empty animations, or finishing resolves immediately\n                    if ( empty || dataPriv.get( this, \"finish\" ) ) {\n                        anim.stop( true );\n                    }\n                };\n\n            doAnimation.finish = doAnimation;\n\n            return empty || optall.queue === false ?\n                this.each( doAnimation ) :\n                this.queue( optall.queue, doAnimation );\n        },\n        stop: function( type, clearQueue, gotoEnd ) {\n            var stopQueue = function( hooks ) {\n                var stop = hooks.stop;\n                delete hooks.stop;\n                stop( gotoEnd );\n            };\n\n            if ( typeof type !== \"string\" ) {\n                gotoEnd = clearQueue;\n                clearQueue = type;\n                type = undefined;\n            }\n            if ( clearQueue ) {\n                this.queue( type || \"fx\", [] );\n            }\n\n            return this.each( function() {\n                var dequeue = true,\n                    index = type != null && type + \"queueHooks\",\n                    timers = jQuery.timers,\n                    data = dataPriv.get( this );\n\n                if ( index ) {\n                    if ( data[ index ] && data[ index ].stop ) {\n                        stopQueue( data[ index ] );\n                    }\n                } else {\n                    for ( index in data ) {\n                        if ( data[ index ] && data[ index ].stop && rrun.test( index ) ) {\n                            stopQueue( data[ index ] );\n                        }\n                    }\n                }\n\n                for ( index = timers.length; index--; ) {\n                    if ( timers[ index ].elem === this &&\n                        ( type == null || timers[ index ].queue === type ) ) {\n\n                        timers[ index ].anim.stop( gotoEnd );\n                        dequeue = false;\n                        timers.splice( index, 1 );\n                    }\n                }\n\n                // Start the next in the queue if the last step wasn't forced.\n                // Timers currently will call their complete callbacks, which\n                // will dequeue but only if they were gotoEnd.\n                if ( dequeue || !gotoEnd ) {\n                    jQuery.dequeue( this, type );\n                }\n            } );\n        },\n        finish: function( type ) {\n            if ( type !== false ) {\n                type = type || \"fx\";\n            }\n            return this.each( function() {\n                var index,\n                    data = dataPriv.get( this ),\n                    queue = data[ type + \"queue\" ],\n                    hooks = data[ type + \"queueHooks\" ],\n                    timers = jQuery.timers,\n                    length = queue ? queue.length : 0;\n\n                // Enable finishing flag on private data\n                data.finish = true;\n\n                // Empty the queue first\n                jQuery.queue( this, type, [] );\n\n                if ( hooks && hooks.stop ) {\n                    hooks.stop.call( this, true );\n                }\n\n                // Look for any active animations, and finish them\n                for ( index = timers.length; index--; ) {\n                    if ( timers[ index ].elem === this && timers[ index ].queue === type ) {\n                        timers[ index ].anim.stop( true );\n                        timers.splice( index, 1 );\n                    }\n                }\n\n                // Look for any animations in the old queue and finish them\n                for ( index = 0; index < length; index++ ) {\n                    if ( queue[ index ] && queue[ index ].finish ) {\n                        queue[ index ].finish.call( this );\n                    }\n                }\n\n                // Turn off finishing flag\n                delete data.finish;\n            } );\n        }\n    } );\n\n    jQuery.each( [ \"toggle\", \"show\", \"hide\" ], function( _i, name ) {\n        var cssFn = jQuery.fn[ name ];\n        jQuery.fn[ name ] = function( speed, easing, callback ) {\n            return speed == null || typeof speed === \"boolean\" ?\n                cssFn.apply( this, arguments ) :\n                this.animate( genFx( name, true ), speed, easing, callback );\n        };\n    } );\n\n// Generate shortcuts for custom animations\n    jQuery.each( {\n        slideDown: genFx( \"show\" ),\n        slideUp: genFx( \"hide\" ),\n        slideToggle: genFx( \"toggle\" ),\n        fadeIn: { opacity: \"show\" },\n        fadeOut: { opacity: \"hide\" },\n        fadeToggle: { opacity: \"toggle\" }\n    }, function( name, props ) {\n        jQuery.fn[ name ] = function( speed, easing, callback ) {\n            return this.animate( props, speed, easing, callback );\n        };\n    } );\n\n    jQuery.timers = [];\n    jQuery.fx.tick = function() {\n        var timer,\n            i = 0,\n            timers = jQuery.timers;\n\n        fxNow = Date.now();\n\n        for ( ; i < timers.length; i++ ) {\n            timer = timers[ i ];\n\n            // Run the timer and safely remove it when done (allowing for external removal)\n            if ( !timer() && timers[ i ] === timer ) {\n                timers.splice( i--, 1 );\n            }\n        }\n\n        if ( !timers.length ) {\n            jQuery.fx.stop();\n        }\n        fxNow = undefined;\n    };\n\n    jQuery.fx.timer = function( timer ) {\n        jQuery.timers.push( timer );\n        jQuery.fx.start();\n    };\n\n    jQuery.fx.interval = 13;\n    jQuery.fx.start = function() {\n        if ( inProgress ) {\n            return;\n        }\n\n        inProgress = true;\n        schedule();\n    };\n\n    jQuery.fx.stop = function() {\n        inProgress = null;\n    };\n\n    jQuery.fx.speeds = {\n        slow: 600,\n        fast: 200,\n\n        // Default speed\n        _default: 400\n    };\n\n\n// Based off of the plugin by Clint Helfers, with permission.\n    jQuery.fn.delay = function( time, type ) {\n        time = jQuery.fx ? jQuery.fx.speeds[ time ] || time : time;\n        type = type || \"fx\";\n\n        return this.queue( type, function( next, hooks ) {\n            var timeout = window.setTimeout( next, time );\n            hooks.stop = function() {\n                window.clearTimeout( timeout );\n            };\n        } );\n    };\n\n\n    ( function() {\n        var input = document.createElement( \"input\" ),\n            select = document.createElement( \"select\" ),\n            opt = select.appendChild( document.createElement( \"option\" ) );\n\n        input.type = \"checkbox\";\n\n        // Support: Android <=4.3 only\n        // Default value for a checkbox should be \"on\"\n        support.checkOn = input.value !== \"\";\n\n        // Support: IE <=11 only\n        // Must access selectedIndex to make default options select\n        support.optSelected = opt.selected;\n\n        // Support: IE <=11 only\n        // An input loses its value after becoming a radio\n        input = document.createElement( \"input\" );\n        input.value = \"t\";\n        input.type = \"radio\";\n        support.radioValue = input.value === \"t\";\n    } )();\n\n\n    var boolHook,\n        attrHandle = jQuery.expr.attrHandle;\n\n    jQuery.fn.extend( {\n        attr: function( name, value ) {\n            return access( this, jQuery.attr, name, value, arguments.length > 1 );\n        },\n\n        removeAttr: function( name ) {\n            return this.each( function() {\n                jQuery.removeAttr( this, name );\n            } );\n        }\n    } );\n\n    jQuery.extend( {\n        attr: function( elem, name, value ) {\n            var ret, hooks,\n                nType = elem.nodeType;\n\n            // Don't get/set attributes on text, comment and attribute nodes\n            if ( nType === 3 || nType === 8 || nType === 2 ) {\n                return;\n            }\n\n            // Fallback to prop when attributes are not supported\n            if ( typeof elem.getAttribute === \"undefined\" ) {\n                return jQuery.prop( elem, name, value );\n            }\n\n            // Attribute hooks are determined by the lowercase version\n            // Grab necessary hook if one is defined\n            if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n                hooks = jQuery.attrHooks[ name.toLowerCase() ] ||\n                    ( jQuery.expr.match.bool.test( name ) ? boolHook : undefined );\n            }\n\n            if ( value !== undefined ) {\n                if ( value === null ) {\n                    jQuery.removeAttr( elem, name );\n                    return;\n                }\n\n                if ( hooks && \"set\" in hooks &&\n                    ( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n                    return ret;\n                }\n\n                elem.setAttribute( name, value + \"\" );\n                return value;\n            }\n\n            if ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n                return ret;\n            }\n\n            ret = jQuery.find.attr( elem, name );\n\n            // Non-existent attributes return null, we normalize to undefined\n            return ret == null ? undefined : ret;\n        },\n\n        attrHooks: {\n            type: {\n                set: function( elem, value ) {\n                    if ( !support.radioValue && value === \"radio\" &&\n                        nodeName( elem, \"input\" ) ) {\n                        var val = elem.value;\n                        elem.setAttribute( \"type\", value );\n                        if ( val ) {\n                            elem.value = val;\n                        }\n                        return value;\n                    }\n                }\n            }\n        },\n\n        removeAttr: function( elem, value ) {\n            var name,\n                i = 0,\n\n                // Attribute names can contain non-HTML whitespace characters\n                // https://html.spec.whatwg.org/multipage/syntax.html#attributes-2\n                attrNames = value && value.match( rnothtmlwhite );\n\n            if ( attrNames && elem.nodeType === 1 ) {\n                while ( ( name = attrNames[ i++ ] ) ) {\n                    elem.removeAttribute( name );\n                }\n            }\n        }\n    } );\n\n// Hooks for boolean attributes\n    boolHook = {\n        set: function( elem, value, name ) {\n            if ( value === false ) {\n\n                // Remove boolean attributes when set to false\n                jQuery.removeAttr( elem, name );\n            } else {\n                elem.setAttribute( name, name );\n            }\n            return name;\n        }\n    };\n\n    jQuery.each( jQuery.expr.match.bool.source.match( /\\w+/g ), function( _i, name ) {\n        var getter = attrHandle[ name ] || jQuery.find.attr;\n\n        attrHandle[ name ] = function( elem, name, isXML ) {\n            var ret, handle,\n                lowercaseName = name.toLowerCase();\n\n            if ( !isXML ) {\n\n                // Avoid an infinite loop by temporarily removing this function from the getter\n                handle = attrHandle[ lowercaseName ];\n                attrHandle[ lowercaseName ] = ret;\n                ret = getter( elem, name, isXML ) != null ?\n                    lowercaseName :\n                    null;\n                attrHandle[ lowercaseName ] = handle;\n            }\n            return ret;\n        };\n    } );\n\n\n\n\n    var rfocusable = /^(?:input|select|textarea|button)$/i,\n        rclickable = /^(?:a|area)$/i;\n\n    jQuery.fn.extend( {\n        prop: function( name, value ) {\n            return access( this, jQuery.prop, name, value, arguments.length > 1 );\n        },\n\n        removeProp: function( name ) {\n            return this.each( function() {\n                delete this[ jQuery.propFix[ name ] || name ];\n            } );\n        }\n    } );\n\n    jQuery.extend( {\n        prop: function( elem, name, value ) {\n            var ret, hooks,\n                nType = elem.nodeType;\n\n            // Don't get/set properties on text, comment and attribute nodes\n            if ( nType === 3 || nType === 8 || nType === 2 ) {\n                return;\n            }\n\n            if ( nType !== 1 || !jQuery.isXMLDoc( elem ) ) {\n\n                // Fix name and attach hooks\n                name = jQuery.propFix[ name ] || name;\n                hooks = jQuery.propHooks[ name ];\n            }\n\n            if ( value !== undefined ) {\n                if ( hooks && \"set\" in hooks &&\n                    ( ret = hooks.set( elem, value, name ) ) !== undefined ) {\n                    return ret;\n                }\n\n                return ( elem[ name ] = value );\n            }\n\n            if ( hooks && \"get\" in hooks && ( ret = hooks.get( elem, name ) ) !== null ) {\n                return ret;\n            }\n\n            return elem[ name ];\n        },\n\n        propHooks: {\n            tabIndex: {\n                get: function( elem ) {\n\n                    // Support: IE <=9 - 11 only\n                    // elem.tabIndex doesn't always return the\n                    // correct value when it hasn't been explicitly set\n                    // Use proper attribute retrieval (trac-12072)\n                    var tabindex = jQuery.find.attr( elem, \"tabindex\" );\n\n                    if ( tabindex ) {\n                        return parseInt( tabindex, 10 );\n                    }\n\n                    if (\n                        rfocusable.test( elem.nodeName ) ||\n                        rclickable.test( elem.nodeName ) &&\n                        elem.href\n                    ) {\n                        return 0;\n                    }\n\n                    return -1;\n                }\n            }\n        },\n\n        propFix: {\n            \"for\": \"htmlFor\",\n            \"class\": \"className\"\n        }\n    } );\n\n// Support: IE <=11 only\n// Accessing the selectedIndex property\n// forces the browser to respect setting selected\n// on the option\n// The getter ensures a default option is selected\n// when in an optgroup\n// eslint rule \"no-unused-expressions\" is disabled for this code\n// since it considers such accessions noop\n    if ( !support.optSelected ) {\n        jQuery.propHooks.selected = {\n            get: function( elem ) {\n\n                /* eslint no-unused-expressions: \"off\" */\n\n                var parent = elem.parentNode;\n                if ( parent && parent.parentNode ) {\n                    parent.parentNode.selectedIndex;\n                }\n                return null;\n            },\n            set: function( elem ) {\n\n                /* eslint no-unused-expressions: \"off\" */\n\n                var parent = elem.parentNode;\n                if ( parent ) {\n                    parent.selectedIndex;\n\n                    if ( parent.parentNode ) {\n                        parent.parentNode.selectedIndex;\n                    }\n                }\n            }\n        };\n    }\n\n    jQuery.each( [\n        \"tabIndex\",\n        \"readOnly\",\n        \"maxLength\",\n        \"cellSpacing\",\n        \"cellPadding\",\n        \"rowSpan\",\n        \"colSpan\",\n        \"useMap\",\n        \"frameBorder\",\n        \"contentEditable\"\n    ], function() {\n        jQuery.propFix[ this.toLowerCase() ] = this;\n    } );\n\n\n\n\n    // Strip and collapse whitespace according to HTML spec\n    // https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace\n    function stripAndCollapse( value ) {\n        var tokens = value.match( rnothtmlwhite ) || [];\n        return tokens.join( \" \" );\n    }\n\n\n    function getClass( elem ) {\n        return elem.getAttribute && elem.getAttribute( \"class\" ) || \"\";\n    }\n\n    function classesToArray( value ) {\n        if ( Array.isArray( value ) ) {\n            return value;\n        }\n        if ( typeof value === \"string\" ) {\n            return value.match( rnothtmlwhite ) || [];\n        }\n        return [];\n    }\n\n    jQuery.fn.extend( {\n        addClass: function( value ) {\n            var classNames, cur, curValue, className, i, finalValue;\n\n            if ( isFunction( value ) ) {\n                return this.each( function( j ) {\n                    jQuery( this ).addClass( value.call( this, j, getClass( this ) ) );\n                } );\n            }\n\n            classNames = classesToArray( value );\n\n            if ( classNames.length ) {\n                return this.each( function() {\n                    curValue = getClass( this );\n                    cur = this.nodeType === 1 && ( \" \" + stripAndCollapse( curValue ) + \" \" );\n\n                    if ( cur ) {\n                        for ( i = 0; i < classNames.length; i++ ) {\n                            className = classNames[ i ];\n                            if ( cur.indexOf( \" \" + className + \" \" ) < 0 ) {\n                                cur += className + \" \";\n                            }\n                        }\n\n                        // Only assign if different to avoid unneeded rendering.\n                        finalValue = stripAndCollapse( cur );\n                        if ( curValue !== finalValue ) {\n                            this.setAttribute( \"class\", finalValue );\n                        }\n                    }\n                } );\n            }\n\n            return this;\n        },\n\n        removeClass: function( value ) {\n            var classNames, cur, curValue, className, i, finalValue;\n\n            if ( isFunction( value ) ) {\n                return this.each( function( j ) {\n                    jQuery( this ).removeClass( value.call( this, j, getClass( this ) ) );\n                } );\n            }\n\n            if ( !arguments.length ) {\n                return this.attr( \"class\", \"\" );\n            }\n\n            classNames = classesToArray( value );\n\n            if ( classNames.length ) {\n                return this.each( function() {\n                    curValue = getClass( this );\n\n                    // This expression is here for better compressibility (see addClass)\n                    cur = this.nodeType === 1 && ( \" \" + stripAndCollapse( curValue ) + \" \" );\n\n                    if ( cur ) {\n                        for ( i = 0; i < classNames.length; i++ ) {\n                            className = classNames[ i ];\n\n                            // Remove *all* instances\n                            while ( cur.indexOf( \" \" + className + \" \" ) > -1 ) {\n                                cur = cur.replace( \" \" + className + \" \", \" \" );\n                            }\n                        }\n\n                        // Only assign if different to avoid unneeded rendering.\n                        finalValue = stripAndCollapse( cur );\n                        if ( curValue !== finalValue ) {\n                            this.setAttribute( \"class\", finalValue );\n                        }\n                    }\n                } );\n            }\n\n            return this;\n        },\n\n        toggleClass: function( value, stateVal ) {\n            var classNames, className, i, self,\n                type = typeof value,\n                isValidValue = type === \"string\" || Array.isArray( value );\n\n            if ( isFunction( value ) ) {\n                return this.each( function( i ) {\n                    jQuery( this ).toggleClass(\n                        value.call( this, i, getClass( this ), stateVal ),\n                        stateVal\n                    );\n                } );\n            }\n\n            if ( typeof stateVal === \"boolean\" && isValidValue ) {\n                return stateVal ? this.addClass( value ) : this.removeClass( value );\n            }\n\n            classNames = classesToArray( value );\n\n            return this.each( function() {\n                if ( isValidValue ) {\n\n                    // Toggle individual class names\n                    self = jQuery( this );\n\n                    for ( i = 0; i < classNames.length; i++ ) {\n                        className = classNames[ i ];\n\n                        // Check each className given, space separated list\n                        if ( self.hasClass( className ) ) {\n                            self.removeClass( className );\n                        } else {\n                            self.addClass( className );\n                        }\n                    }\n\n                    // Toggle whole class name\n                } else if ( value === undefined || type === \"boolean\" ) {\n                    className = getClass( this );\n                    if ( className ) {\n\n                        // Store className if set\n                        dataPriv.set( this, \"__className__\", className );\n                    }\n\n                    // If the element has a class name or if we're passed `false`,\n                    // then remove the whole classname (if there was one, the above saved it).\n                    // Otherwise bring back whatever was previously saved (if anything),\n                    // falling back to the empty string if nothing was stored.\n                    if ( this.setAttribute ) {\n                        this.setAttribute( \"class\",\n                            className || value === false ?\n                                \"\" :\n                                dataPriv.get( this, \"__className__\" ) || \"\"\n                        );\n                    }\n                }\n            } );\n        },\n\n        hasClass: function( selector ) {\n            var className, elem,\n                i = 0;\n\n            className = \" \" + selector + \" \";\n            while ( ( elem = this[ i++ ] ) ) {\n                if ( elem.nodeType === 1 &&\n                    ( \" \" + stripAndCollapse( getClass( elem ) ) + \" \" ).indexOf( className ) > -1 ) {\n                    return true;\n                }\n            }\n\n            return false;\n        }\n    } );\n\n\n\n\n    var rreturn = /\\r/g;\n\n    jQuery.fn.extend( {\n        val: function( value ) {\n            var hooks, ret, valueIsFunction,\n                elem = this[ 0 ];\n\n            if ( !arguments.length ) {\n                if ( elem ) {\n                    hooks = jQuery.valHooks[ elem.type ] ||\n                        jQuery.valHooks[ elem.nodeName.toLowerCase() ];\n\n                    if ( hooks &&\n                        \"get\" in hooks &&\n                        ( ret = hooks.get( elem, \"value\" ) ) !== undefined\n                    ) {\n                        return ret;\n                    }\n\n                    ret = elem.value;\n\n                    // Handle most common string cases\n                    if ( typeof ret === \"string\" ) {\n                        return ret.replace( rreturn, \"\" );\n                    }\n\n                    // Handle cases where value is null/undef or number\n                    return ret == null ? \"\" : ret;\n                }\n\n                return;\n            }\n\n            valueIsFunction = isFunction( value );\n\n            return this.each( function( i ) {\n                var val;\n\n                if ( this.nodeType !== 1 ) {\n                    return;\n                }\n\n                if ( valueIsFunction ) {\n                    val = value.call( this, i, jQuery( this ).val() );\n                } else {\n                    val = value;\n                }\n\n                // Treat null/undefined as \"\"; convert numbers to string\n                if ( val == null ) {\n                    val = \"\";\n\n                } else if ( typeof val === \"number\" ) {\n                    val += \"\";\n\n                } else if ( Array.isArray( val ) ) {\n                    val = jQuery.map( val, function( value ) {\n                        return value == null ? \"\" : value + \"\";\n                    } );\n                }\n\n                hooks = jQuery.valHooks[ this.type ] || jQuery.valHooks[ this.nodeName.toLowerCase() ];\n\n                // If set returns undefined, fall back to normal setting\n                if ( !hooks || !( \"set\" in hooks ) || hooks.set( this, val, \"value\" ) === undefined ) {\n                    this.value = val;\n                }\n            } );\n        }\n    } );\n\n    jQuery.extend( {\n        valHooks: {\n            option: {\n                get: function( elem ) {\n\n                    var val = jQuery.find.attr( elem, \"value\" );\n                    return val != null ?\n                        val :\n\n                        // Support: IE <=10 - 11 only\n                        // option.text throws exceptions (trac-14686, trac-14858)\n                        // Strip and collapse whitespace\n                        // https://html.spec.whatwg.org/#strip-and-collapse-whitespace\n                        stripAndCollapse( jQuery.text( elem ) );\n                }\n            },\n            select: {\n                get: function( elem ) {\n                    var value, option, i,\n                        options = elem.options,\n                        index = elem.selectedIndex,\n                        one = elem.type === \"select-one\",\n                        values = one ? null : [],\n                        max = one ? index + 1 : options.length;\n\n                    if ( index < 0 ) {\n                        i = max;\n\n                    } else {\n                        i = one ? index : 0;\n                    }\n\n                    // Loop through all the selected options\n                    for ( ; i < max; i++ ) {\n                        option = options[ i ];\n\n                        // Support: IE <=9 only\n                        // IE8-9 doesn't update selected after form reset (trac-2551)\n                        if ( ( option.selected || i === index ) &&\n\n                            // Don't return options that are disabled or in a disabled optgroup\n                            !option.disabled &&\n                            ( !option.parentNode.disabled ||\n                                !nodeName( option.parentNode, \"optgroup\" ) ) ) {\n\n                            // Get the specific value for the option\n                            value = jQuery( option ).val();\n\n                            // We don't need an array for one selects\n                            if ( one ) {\n                                return value;\n                            }\n\n                            // Multi-Selects return an array\n                            values.push( value );\n                        }\n                    }\n\n                    return values;\n                },\n\n                set: function( elem, value ) {\n                    var optionSet, option,\n                        options = elem.options,\n                        values = jQuery.makeArray( value ),\n                        i = options.length;\n\n                    while ( i-- ) {\n                        option = options[ i ];\n\n                        /* eslint-disable no-cond-assign */\n\n                        if ( option.selected =\n                            jQuery.inArray( jQuery.valHooks.option.get( option ), values ) > -1\n                        ) {\n                            optionSet = true;\n                        }\n\n                        /* eslint-enable no-cond-assign */\n                    }\n\n                    // Force browsers to behave consistently when non-matching value is set\n                    if ( !optionSet ) {\n                        elem.selectedIndex = -1;\n                    }\n                    return values;\n                }\n            }\n        }\n    } );\n\n// Radios and checkboxes getter/setter\n    jQuery.each( [ \"radio\", \"checkbox\" ], function() {\n        jQuery.valHooks[ this ] = {\n            set: function( elem, value ) {\n                if ( Array.isArray( value ) ) {\n                    return ( elem.checked = jQuery.inArray( jQuery( elem ).val(), value ) > -1 );\n                }\n            }\n        };\n        if ( !support.checkOn ) {\n            jQuery.valHooks[ this ].get = function( elem ) {\n                return elem.getAttribute( \"value\" ) === null ? \"on\" : elem.value;\n            };\n        }\n    } );\n\n\n\n\n// Return jQuery for attributes-only inclusion\n    var location = window.location;\n\n    var nonce = { guid: Date.now() };\n\n    var rquery = ( /\\?/ );\n\n\n\n// Cross-browser xml parsing\n    jQuery.parseXML = function( data ) {\n        var xml, parserErrorElem;\n        if ( !data || typeof data !== \"string\" ) {\n            return null;\n        }\n\n        // Support: IE 9 - 11 only\n        // IE throws on parseFromString with invalid input.\n        try {\n            xml = ( new window.DOMParser() ).parseFromString( data, \"text/xml\" );\n        } catch ( e ) {}\n\n        parserErrorElem = xml && xml.getElementsByTagName( \"parsererror\" )[ 0 ];\n        if ( !xml || parserErrorElem ) {\n            jQuery.error( \"Invalid XML: \" + (\n                parserErrorElem ?\n                    jQuery.map( parserErrorElem.childNodes, function( el ) {\n                        return el.textContent;\n                    } ).join( \"\\n\" ) :\n                    data\n            ) );\n        }\n        return xml;\n    };\n\n\n    var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,\n        stopPropagationCallback = function( e ) {\n            e.stopPropagation();\n        };\n\n    jQuery.extend( jQuery.event, {\n\n        trigger: function( event, data, elem, onlyHandlers ) {\n\n            var i, cur, tmp, bubbleType, ontype, handle, special, lastElement,\n                eventPath = [ elem || document ],\n                type = hasOwn.call( event, \"type\" ) ? event.type : event,\n                namespaces = hasOwn.call( event, \"namespace\" ) ? event.namespace.split( \".\" ) : [];\n\n            cur = lastElement = tmp = elem = elem || document;\n\n            // Don't do events on text and comment nodes\n            if ( elem.nodeType === 3 || elem.nodeType === 8 ) {\n                return;\n            }\n\n            // focus/blur morphs to focusin/out; ensure we're not firing them right now\n            if ( rfocusMorph.test( type + jQuery.event.triggered ) ) {\n                return;\n            }\n\n            if ( type.indexOf( \".\" ) > -1 ) {\n\n                // Namespaced trigger; create a regexp to match event type in handle()\n                namespaces = type.split( \".\" );\n                type = namespaces.shift();\n                namespaces.sort();\n            }\n            ontype = type.indexOf( \":\" ) < 0 && \"on\" + type;\n\n            // Caller can pass in a jQuery.Event object, Object, or just an event type string\n            event = event[ jQuery.expando ] ?\n                event :\n                new jQuery.Event( type, typeof event === \"object\" && event );\n\n            // Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)\n            event.isTrigger = onlyHandlers ? 2 : 3;\n            event.namespace = namespaces.join( \".\" );\n            event.rnamespace = event.namespace ?\n                new RegExp( \"(^|\\\\.)\" + namespaces.join( \"\\\\.(?:.*\\\\.|)\" ) + \"(\\\\.|$)\" ) :\n                null;\n\n            // Clean up the event in case it is being reused\n            event.result = undefined;\n            if ( !event.target ) {\n                event.target = elem;\n            }\n\n            // Clone any incoming data and prepend the event, creating the handler arg list\n            data = data == null ?\n                [ event ] :\n                jQuery.makeArray( data, [ event ] );\n\n            // Allow special events to draw outside the lines\n            special = jQuery.event.special[ type ] || {};\n            if ( !onlyHandlers && special.trigger && special.trigger.apply( elem, data ) === false ) {\n                return;\n            }\n\n            // Determine event propagation path in advance, per W3C events spec (trac-9951)\n            // Bubble up to document, then to window; watch for a global ownerDocument var (trac-9724)\n            if ( !onlyHandlers && !special.noBubble && !isWindow( elem ) ) {\n\n                bubbleType = special.delegateType || type;\n                if ( !rfocusMorph.test( bubbleType + type ) ) {\n                    cur = cur.parentNode;\n                }\n                for ( ; cur; cur = cur.parentNode ) {\n                    eventPath.push( cur );\n                    tmp = cur;\n                }\n\n                // Only add window if we got to document (e.g., not plain obj or detached DOM)\n                if ( tmp === ( elem.ownerDocument || document ) ) {\n                    eventPath.push( tmp.defaultView || tmp.parentWindow || window );\n                }\n            }\n\n            // Fire handlers on the event path\n            i = 0;\n            while ( ( cur = eventPath[ i++ ] ) && !event.isPropagationStopped() ) {\n                lastElement = cur;\n                event.type = i > 1 ?\n                    bubbleType :\n                    special.bindType || type;\n\n                // jQuery handler\n                handle = ( dataPriv.get( cur, \"events\" ) || Object.create( null ) )[ event.type ] &&\n                    dataPriv.get( cur, \"handle\" );\n                if ( handle ) {\n                    handle.apply( cur, data );\n                }\n\n                // Native handler\n                handle = ontype && cur[ ontype ];\n                if ( handle && handle.apply && acceptData( cur ) ) {\n                    event.result = handle.apply( cur, data );\n                    if ( event.result === false ) {\n                        event.preventDefault();\n                    }\n                }\n            }\n            event.type = type;\n\n            // If nobody prevented the default action, do it now\n            if ( !onlyHandlers && !event.isDefaultPrevented() ) {\n\n                if ( ( !special._default ||\n                        special._default.apply( eventPath.pop(), data ) === false ) &&\n                    acceptData( elem ) ) {\n\n                    // Call a native DOM method on the target with the same name as the event.\n                    // Don't do default actions on window, that's where global variables be (trac-6170)\n                    if ( ontype && isFunction( elem[ type ] ) && !isWindow( elem ) ) {\n\n                        // Don't re-trigger an onFOO event when we call its FOO() method\n                        tmp = elem[ ontype ];\n\n                        if ( tmp ) {\n                            elem[ ontype ] = null;\n                        }\n\n                        // Prevent re-triggering of the same event, since we already bubbled it above\n                        jQuery.event.triggered = type;\n\n                        if ( event.isPropagationStopped() ) {\n                            lastElement.addEventListener( type, stopPropagationCallback );\n                        }\n\n                        elem[ type ]();\n\n                        if ( event.isPropagationStopped() ) {\n                            lastElement.removeEventListener( type, stopPropagationCallback );\n                        }\n\n                        jQuery.event.triggered = undefined;\n\n                        if ( tmp ) {\n                            elem[ ontype ] = tmp;\n                        }\n                    }\n                }\n            }\n\n            return event.result;\n        },\n\n        // Piggyback on a donor event to simulate a different one\n        // Used only for `focus(in | out)` events\n        simulate: function( type, elem, event ) {\n            var e = jQuery.extend(\n                new jQuery.Event(),\n                event,\n                {\n                    type: type,\n                    isSimulated: true\n                }\n            );\n\n            jQuery.event.trigger( e, null, elem );\n        }\n\n    } );\n\n    jQuery.fn.extend( {\n\n        trigger: function( type, data ) {\n            return this.each( function() {\n                jQuery.event.trigger( type, data, this );\n            } );\n        },\n        triggerHandler: function( type, data ) {\n            var elem = this[ 0 ];\n            if ( elem ) {\n                return jQuery.event.trigger( type, data, elem, true );\n            }\n        }\n    } );\n\n\n    var\n        rbracket = /\\[\\]$/,\n        rCRLF = /\\r?\\n/g,\n        rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,\n        rsubmittable = /^(?:input|select|textarea|keygen)/i;\n\n    function buildParams( prefix, obj, traditional, add ) {\n        var name;\n\n        if ( Array.isArray( obj ) ) {\n\n            // Serialize array item.\n            jQuery.each( obj, function( i, v ) {\n                if ( traditional || rbracket.test( prefix ) ) {\n\n                    // Treat each array item as a scalar.\n                    add( prefix, v );\n\n                } else {\n\n                    // Item is non-scalar (array or object), encode its numeric index.\n                    buildParams(\n                        prefix + \"[\" + ( typeof v === \"object\" && v != null ? i : \"\" ) + \"]\",\n                        v,\n                        traditional,\n                        add\n                    );\n                }\n            } );\n\n        } else if ( !traditional && toType( obj ) === \"object\" ) {\n\n            // Serialize object item.\n            for ( name in obj ) {\n                buildParams( prefix + \"[\" + name + \"]\", obj[ name ], traditional, add );\n            }\n\n        } else {\n\n            // Serialize scalar item.\n            add( prefix, obj );\n        }\n    }\n\n// Serialize an array of form elements or a set of\n// key/values into a query string\n    jQuery.param = function( a, traditional ) {\n        var prefix,\n            s = [],\n            add = function( key, valueOrFunction ) {\n\n                // If value is a function, invoke it and use its return value\n                var value = isFunction( valueOrFunction ) ?\n                    valueOrFunction() :\n                    valueOrFunction;\n\n                s[ s.length ] = encodeURIComponent( key ) + \"=\" +\n                    encodeURIComponent( value == null ? \"\" : value );\n            };\n\n        if ( a == null ) {\n            return \"\";\n        }\n\n        // If an array was passed in, assume that it is an array of form elements.\n        if ( Array.isArray( a ) || ( a.jquery && !jQuery.isPlainObject( a ) ) ) {\n\n            // Serialize the form elements\n            jQuery.each( a, function() {\n                add( this.name, this.value );\n            } );\n\n        } else {\n\n            // If traditional, encode the \"old\" way (the way 1.3.2 or older\n            // did it), otherwise encode params recursively.\n            for ( prefix in a ) {\n                buildParams( prefix, a[ prefix ], traditional, add );\n            }\n        }\n\n        // Return the resulting serialization\n        return s.join( \"&\" );\n    };\n\n    jQuery.fn.extend( {\n        serialize: function() {\n            return jQuery.param( this.serializeArray() );\n        },\n        serializeArray: function() {\n            return this.map( function() {\n\n                // Can add propHook for \"elements\" to filter or add form elements\n                var elements = jQuery.prop( this, \"elements\" );\n                return elements ? jQuery.makeArray( elements ) : this;\n            } ).filter( function() {\n                var type = this.type;\n\n                // Use .is( \":disabled\" ) so that fieldset[disabled] works\n                return this.name && !jQuery( this ).is( \":disabled\" ) &&\n                    rsubmittable.test( this.nodeName ) && !rsubmitterTypes.test( type ) &&\n                    ( this.checked || !rcheckableType.test( type ) );\n            } ).map( function( _i, elem ) {\n                var val = jQuery( this ).val();\n\n                if ( val == null ) {\n                    return null;\n                }\n\n                if ( Array.isArray( val ) ) {\n                    return jQuery.map( val, function( val ) {\n                        return { name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n                    } );\n                }\n\n                return { name: elem.name, value: val.replace( rCRLF, \"\\r\\n\" ) };\n            } ).get();\n        }\n    } );\n\n\n    var\n        r20 = /%20/g,\n        rhash = /#.*$/,\n        rantiCache = /([?&])_=[^&]*/,\n        rheaders = /^(.*?):[ \\t]*([^\\r\\n]*)$/mg,\n\n        // trac-7653, trac-8125, trac-8152: local protocol detection\n        rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,\n        rnoContent = /^(?:GET|HEAD)$/,\n        rprotocol = /^\\/\\//,\n\n        /* Prefilters\n\t * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)\n\t * 2) These are called:\n\t *    - BEFORE asking for a transport\n\t *    - AFTER param serialization (s.data is a string if s.processData is true)\n\t * 3) key is the dataType\n\t * 4) the catchall symbol \"*\" can be used\n\t * 5) execution will start with transport dataType and THEN continue down to \"*\" if needed\n\t */\n        prefilters = {},\n\n        /* Transports bindings\n\t * 1) key is the dataType\n\t * 2) the catchall symbol \"*\" can be used\n\t * 3) selection will start with transport dataType and THEN go to \"*\" if needed\n\t */\n        transports = {},\n\n        // Avoid comment-prolog char sequence (trac-10098); must appease lint and evade compression\n        allTypes = \"*/\".concat( \"*\" ),\n\n        // Anchor tag for parsing the document origin\n        originAnchor = document.createElement( \"a\" );\n\n    originAnchor.href = location.href;\n\n// Base \"constructor\" for jQuery.ajaxPrefilter and jQuery.ajaxTransport\n    function addToPrefiltersOrTransports( structure ) {\n\n        // dataTypeExpression is optional and defaults to \"*\"\n        return function( dataTypeExpression, func ) {\n\n            if ( typeof dataTypeExpression !== \"string\" ) {\n                func = dataTypeExpression;\n                dataTypeExpression = \"*\";\n            }\n\n            var dataType,\n                i = 0,\n                dataTypes = dataTypeExpression.toLowerCase().match( rnothtmlwhite ) || [];\n\n            if ( isFunction( func ) ) {\n\n                // For each dataType in the dataTypeExpression\n                while ( ( dataType = dataTypes[ i++ ] ) ) {\n\n                    // Prepend if requested\n                    if ( dataType[ 0 ] === \"+\" ) {\n                        dataType = dataType.slice( 1 ) || \"*\";\n                        ( structure[ dataType ] = structure[ dataType ] || [] ).unshift( func );\n\n                        // Otherwise append\n                    } else {\n                        ( structure[ dataType ] = structure[ dataType ] || [] ).push( func );\n                    }\n                }\n            }\n        };\n    }\n\n// Base inspection function for prefilters and transports\n    function inspectPrefiltersOrTransports( structure, options, originalOptions, jqXHR ) {\n\n        var inspected = {},\n            seekingTransport = ( structure === transports );\n\n        function inspect( dataType ) {\n            var selected;\n            inspected[ dataType ] = true;\n            jQuery.each( structure[ dataType ] || [], function( _, prefilterOrFactory ) {\n                var dataTypeOrTransport = prefilterOrFactory( options, originalOptions, jqXHR );\n                if ( typeof dataTypeOrTransport === \"string\" &&\n                    !seekingTransport && !inspected[ dataTypeOrTransport ] ) {\n\n                    options.dataTypes.unshift( dataTypeOrTransport );\n                    inspect( dataTypeOrTransport );\n                    return false;\n                } else if ( seekingTransport ) {\n                    return !( selected = dataTypeOrTransport );\n                }\n            } );\n            return selected;\n        }\n\n        return inspect( options.dataTypes[ 0 ] ) || !inspected[ \"*\" ] && inspect( \"*\" );\n    }\n\n// A special extend for ajax options\n// that takes \"flat\" options (not to be deep extended)\n// Fixes trac-9887\n    function ajaxExtend( target, src ) {\n        var key, deep,\n            flatOptions = jQuery.ajaxSettings.flatOptions || {};\n\n        for ( key in src ) {\n            if ( src[ key ] !== undefined ) {\n                ( flatOptions[ key ] ? target : ( deep || ( deep = {} ) ) )[ key ] = src[ key ];\n            }\n        }\n        if ( deep ) {\n            jQuery.extend( true, target, deep );\n        }\n\n        return target;\n    }\n\n    /* Handles responses to an ajax request:\n * - finds the right dataType (mediates between content-type and expected dataType)\n * - returns the corresponding response\n */\n    function ajaxHandleResponses( s, jqXHR, responses ) {\n\n        var ct, type, finalDataType, firstDataType,\n            contents = s.contents,\n            dataTypes = s.dataTypes;\n\n        // Remove auto dataType and get content-type in the process\n        while ( dataTypes[ 0 ] === \"*\" ) {\n            dataTypes.shift();\n            if ( ct === undefined ) {\n                ct = s.mimeType || jqXHR.getResponseHeader( \"Content-Type\" );\n            }\n        }\n\n        // Check if we're dealing with a known content-type\n        if ( ct ) {\n            for ( type in contents ) {\n                if ( contents[ type ] && contents[ type ].test( ct ) ) {\n                    dataTypes.unshift( type );\n                    break;\n                }\n            }\n        }\n\n        // Check to see if we have a response for the expected dataType\n        if ( dataTypes[ 0 ] in responses ) {\n            finalDataType = dataTypes[ 0 ];\n        } else {\n\n            // Try convertible dataTypes\n            for ( type in responses ) {\n                if ( !dataTypes[ 0 ] || s.converters[ type + \" \" + dataTypes[ 0 ] ] ) {\n                    finalDataType = type;\n                    break;\n                }\n                if ( !firstDataType ) {\n                    firstDataType = type;\n                }\n            }\n\n            // Or just use first one\n            finalDataType = finalDataType || firstDataType;\n        }\n\n        // If we found a dataType\n        // We add the dataType to the list if needed\n        // and return the corresponding response\n        if ( finalDataType ) {\n            if ( finalDataType !== dataTypes[ 0 ] ) {\n                dataTypes.unshift( finalDataType );\n            }\n            return responses[ finalDataType ];\n        }\n    }\n\n    /* Chain conversions given the request and the original response\n * Also sets the responseXXX fields on the jqXHR instance\n */\n    function ajaxConvert( s, response, jqXHR, isSuccess ) {\n        var conv2, current, conv, tmp, prev,\n            converters = {},\n\n            // Work with a copy of dataTypes in case we need to modify it for conversion\n            dataTypes = s.dataTypes.slice();\n\n        // Create converters map with lowercased keys\n        if ( dataTypes[ 1 ] ) {\n            for ( conv in s.converters ) {\n                converters[ conv.toLowerCase() ] = s.converters[ conv ];\n            }\n        }\n\n        current = dataTypes.shift();\n\n        // Convert to each sequential dataType\n        while ( current ) {\n\n            if ( s.responseFields[ current ] ) {\n                jqXHR[ s.responseFields[ current ] ] = response;\n            }\n\n            // Apply the dataFilter if provided\n            if ( !prev && isSuccess && s.dataFilter ) {\n                response = s.dataFilter( response, s.dataType );\n            }\n\n            prev = current;\n            current = dataTypes.shift();\n\n            if ( current ) {\n\n                // There's only work to do if current dataType is non-auto\n                if ( current === \"*\" ) {\n\n                    current = prev;\n\n                    // Convert response if prev dataType is non-auto and differs from current\n                } else if ( prev !== \"*\" && prev !== current ) {\n\n                    // Seek a direct converter\n                    conv = converters[ prev + \" \" + current ] || converters[ \"* \" + current ];\n\n                    // If none found, seek a pair\n                    if ( !conv ) {\n                        for ( conv2 in converters ) {\n\n                            // If conv2 outputs current\n                            tmp = conv2.split( \" \" );\n                            if ( tmp[ 1 ] === current ) {\n\n                                // If prev can be converted to accepted input\n                                conv = converters[ prev + \" \" + tmp[ 0 ] ] ||\n                                    converters[ \"* \" + tmp[ 0 ] ];\n                                if ( conv ) {\n\n                                    // Condense equivalence converters\n                                    if ( conv === true ) {\n                                        conv = converters[ conv2 ];\n\n                                        // Otherwise, insert the intermediate dataType\n                                    } else if ( converters[ conv2 ] !== true ) {\n                                        current = tmp[ 0 ];\n                                        dataTypes.unshift( tmp[ 1 ] );\n                                    }\n                                    break;\n                                }\n                            }\n                        }\n                    }\n\n                    // Apply converter (if not an equivalence)\n                    if ( conv !== true ) {\n\n                        // Unless errors are allowed to bubble, catch and return them\n                        if ( conv && s.throws ) {\n                            response = conv( response );\n                        } else {\n                            try {\n                                response = conv( response );\n                            } catch ( e ) {\n                                return {\n                                    state: \"parsererror\",\n                                    error: conv ? e : \"No conversion from \" + prev + \" to \" + current\n                                };\n                            }\n                        }\n                    }\n                }\n            }\n        }\n\n        return { state: \"success\", data: response };\n    }\n\n    jQuery.extend( {\n\n        // Counter for holding the number of active queries\n        active: 0,\n\n        // Last-Modified header cache for next request\n        lastModified: {},\n        etag: {},\n\n        ajaxSettings: {\n            url: location.href,\n            type: \"GET\",\n            isLocal: rlocalProtocol.test( location.protocol ),\n            global: true,\n            processData: true,\n            async: true,\n            contentType: \"application/x-www-form-urlencoded; charset=UTF-8\",\n\n            /*\n\t\ttimeout: 0,\n\t\tdata: null,\n\t\tdataType: null,\n\t\tusername: null,\n\t\tpassword: null,\n\t\tcache: null,\n\t\tthrows: false,\n\t\ttraditional: false,\n\t\theaders: {},\n\t\t*/\n\n            accepts: {\n                \"*\": allTypes,\n                text: \"text/plain\",\n                html: \"text/html\",\n                xml: \"application/xml, text/xml\",\n                json: \"application/json, text/javascript\"\n            },\n\n            contents: {\n                xml: /\\bxml\\b/,\n                html: /\\bhtml/,\n                json: /\\bjson\\b/\n            },\n\n            responseFields: {\n                xml: \"responseXML\",\n                text: \"responseText\",\n                json: \"responseJSON\"\n            },\n\n            // Data converters\n            // Keys separate source (or catchall \"*\") and destination types with a single space\n            converters: {\n\n                // Convert anything to text\n                \"* text\": String,\n\n                // Text to html (true = no transformation)\n                \"text html\": true,\n\n                // Evaluate text as a json expression\n                \"text json\": JSON.parse,\n\n                // Parse text as xml\n                \"text xml\": jQuery.parseXML\n            },\n\n            // For options that shouldn't be deep extended:\n            // you can add your own custom options here if\n            // and when you create one that shouldn't be\n            // deep extended (see ajaxExtend)\n            flatOptions: {\n                url: true,\n                context: true\n            }\n        },\n\n        // Creates a full fledged settings object into target\n        // with both ajaxSettings and settings fields.\n        // If target is omitted, writes into ajaxSettings.\n        ajaxSetup: function( target, settings ) {\n            return settings ?\n\n                // Building a settings object\n                ajaxExtend( ajaxExtend( target, jQuery.ajaxSettings ), settings ) :\n\n                // Extending ajaxSettings\n                ajaxExtend( jQuery.ajaxSettings, target );\n        },\n\n        ajaxPrefilter: addToPrefiltersOrTransports( prefilters ),\n        ajaxTransport: addToPrefiltersOrTransports( transports ),\n\n        // Main method\n        ajax: function( url, options ) {\n\n            // If url is an object, simulate pre-1.5 signature\n            if ( typeof url === \"object\" ) {\n                options = url;\n                url = undefined;\n            }\n\n            // Force options to be an object\n            options = options || {};\n\n            var transport,\n\n                // URL without anti-cache param\n                cacheURL,\n\n                // Response headers\n                responseHeadersString,\n                responseHeaders,\n\n                // timeout handle\n                timeoutTimer,\n\n                // Url cleanup var\n                urlAnchor,\n\n                // Request state (becomes false upon send and true upon completion)\n                completed,\n\n                // To know if global events are to be dispatched\n                fireGlobals,\n\n                // Loop variable\n                i,\n\n                // uncached part of the url\n                uncached,\n\n                // Create the final options object\n                s = jQuery.ajaxSetup( {}, options ),\n\n                // Callbacks context\n                callbackContext = s.context || s,\n\n                // Context for global events is callbackContext if it is a DOM node or jQuery collection\n                globalEventContext = s.context &&\n                ( callbackContext.nodeType || callbackContext.jquery ) ?\n                    jQuery( callbackContext ) :\n                    jQuery.event,\n\n                // Deferreds\n                deferred = jQuery.Deferred(),\n                completeDeferred = jQuery.Callbacks( \"once memory\" ),\n\n                // Status-dependent callbacks\n                statusCode = s.statusCode || {},\n\n                // Headers (they are sent all at once)\n                requestHeaders = {},\n                requestHeadersNames = {},\n\n                // Default abort message\n                strAbort = \"canceled\",\n\n                // Fake xhr\n                jqXHR = {\n                    readyState: 0,\n\n                    // Builds headers hashtable if needed\n                    getResponseHeader: function( key ) {\n                        var match;\n                        if ( completed ) {\n                            if ( !responseHeaders ) {\n                                responseHeaders = {};\n                                while ( ( match = rheaders.exec( responseHeadersString ) ) ) {\n                                    responseHeaders[ match[ 1 ].toLowerCase() + \" \" ] =\n                                        ( responseHeaders[ match[ 1 ].toLowerCase() + \" \" ] || [] )\n                                            .concat( match[ 2 ] );\n                                }\n                            }\n                            match = responseHeaders[ key.toLowerCase() + \" \" ];\n                        }\n                        return match == null ? null : match.join( \", \" );\n                    },\n\n                    // Raw string\n                    getAllResponseHeaders: function() {\n                        return completed ? responseHeadersString : null;\n                    },\n\n                    // Caches the header\n                    setRequestHeader: function( name, value ) {\n                        if ( completed == null ) {\n                            name = requestHeadersNames[ name.toLowerCase() ] =\n                                requestHeadersNames[ name.toLowerCase() ] || name;\n                            requestHeaders[ name ] = value;\n                        }\n                        return this;\n                    },\n\n                    // Overrides response content-type header\n                    overrideMimeType: function( type ) {\n                        if ( completed == null ) {\n                            s.mimeType = type;\n                        }\n                        return this;\n                    },\n\n                    // Status-dependent callbacks\n                    statusCode: function( map ) {\n                        var code;\n                        if ( map ) {\n                            if ( completed ) {\n\n                                // Execute the appropriate callbacks\n                                jqXHR.always( map[ jqXHR.status ] );\n                            } else {\n\n                                // Lazy-add the new callbacks in a way that preserves old ones\n                                for ( code in map ) {\n                                    statusCode[ code ] = [ statusCode[ code ], map[ code ] ];\n                                }\n                            }\n                        }\n                        return this;\n                    },\n\n                    // Cancel the request\n                    abort: function( statusText ) {\n                        var finalText = statusText || strAbort;\n                        if ( transport ) {\n                            transport.abort( finalText );\n                        }\n                        done( 0, finalText );\n                        return this;\n                    }\n                };\n\n            // Attach deferreds\n            deferred.promise( jqXHR );\n\n            // Add protocol if not provided (prefilters might expect it)\n            // Handle falsy url in the settings object (trac-10093: consistency with old signature)\n            // We also use the url parameter if available\n            s.url = ( ( url || s.url || location.href ) + \"\" )\n                .replace( rprotocol, location.protocol + \"//\" );\n\n            // Alias method option to type as per ticket trac-12004\n            s.type = options.method || options.type || s.method || s.type;\n\n            // Extract dataTypes list\n            s.dataTypes = ( s.dataType || \"*\" ).toLowerCase().match( rnothtmlwhite ) || [ \"\" ];\n\n            // A cross-domain request is in order when the origin doesn't match the current origin.\n            if ( s.crossDomain == null ) {\n                urlAnchor = document.createElement( \"a\" );\n\n                // Support: IE <=8 - 11, Edge 12 - 15\n                // IE throws exception on accessing the href property if url is malformed,\n                // e.g. http://example.com:80x/\n                try {\n                    urlAnchor.href = s.url;\n\n                    // Support: IE <=8 - 11 only\n                    // Anchor's host property isn't correctly set when s.url is relative\n                    urlAnchor.href = urlAnchor.href;\n                    s.crossDomain = originAnchor.protocol + \"//\" + originAnchor.host !==\n                        urlAnchor.protocol + \"//\" + urlAnchor.host;\n                } catch ( e ) {\n\n                    // If there is an error parsing the URL, assume it is crossDomain,\n                    // it can be rejected by the transport if it is invalid\n                    s.crossDomain = true;\n                }\n            }\n\n            // Convert data if not already a string\n            if ( s.data && s.processData && typeof s.data !== \"string\" ) {\n                s.data = jQuery.param( s.data, s.traditional );\n            }\n\n            // Apply prefilters\n            inspectPrefiltersOrTransports( prefilters, s, options, jqXHR );\n\n            // If request was aborted inside a prefilter, stop there\n            if ( completed ) {\n                return jqXHR;\n            }\n\n            // We can fire global events as of now if asked to\n            // Don't fire events if jQuery.event is undefined in an AMD-usage scenario (trac-15118)\n            fireGlobals = jQuery.event && s.global;\n\n            // Watch for a new set of requests\n            if ( fireGlobals && jQuery.active++ === 0 ) {\n                jQuery.event.trigger( \"ajaxStart\" );\n            }\n\n            // Uppercase the type\n            s.type = s.type.toUpperCase();\n\n            // Determine if request has content\n            s.hasContent = !rnoContent.test( s.type );\n\n            // Save the URL in case we're toying with the If-Modified-Since\n            // and/or If-None-Match header later on\n            // Remove hash to simplify url manipulation\n            cacheURL = s.url.replace( rhash, \"\" );\n\n            // More options handling for requests with no content\n            if ( !s.hasContent ) {\n\n                // Remember the hash so we can put it back\n                uncached = s.url.slice( cacheURL.length );\n\n                // If data is available and should be processed, append data to url\n                if ( s.data && ( s.processData || typeof s.data === \"string\" ) ) {\n                    cacheURL += ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + s.data;\n\n                    // trac-9682: remove data so that it's not used in an eventual retry\n                    delete s.data;\n                }\n\n                // Add or update anti-cache param if needed\n                if ( s.cache === false ) {\n                    cacheURL = cacheURL.replace( rantiCache, \"$1\" );\n                    uncached = ( rquery.test( cacheURL ) ? \"&\" : \"?\" ) + \"_=\" + ( nonce.guid++ ) +\n                        uncached;\n                }\n\n                // Put hash and anti-cache on the URL that will be requested (gh-1732)\n                s.url = cacheURL + uncached;\n\n                // Change '%20' to '+' if this is encoded form body content (gh-2658)\n            } else if ( s.data && s.processData &&\n                ( s.contentType || \"\" ).indexOf( \"application/x-www-form-urlencoded\" ) === 0 ) {\n                s.data = s.data.replace( r20, \"+\" );\n            }\n\n            // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n            if ( s.ifModified ) {\n                if ( jQuery.lastModified[ cacheURL ] ) {\n                    jqXHR.setRequestHeader( \"If-Modified-Since\", jQuery.lastModified[ cacheURL ] );\n                }\n                if ( jQuery.etag[ cacheURL ] ) {\n                    jqXHR.setRequestHeader( \"If-None-Match\", jQuery.etag[ cacheURL ] );\n                }\n            }\n\n            // Set the correct header, if data is being sent\n            if ( s.data && s.hasContent && s.contentType !== false || options.contentType ) {\n                jqXHR.setRequestHeader( \"Content-Type\", s.contentType );\n            }\n\n            // Set the Accepts header for the server, depending on the dataType\n            jqXHR.setRequestHeader(\n                \"Accept\",\n                s.dataTypes[ 0 ] && s.accepts[ s.dataTypes[ 0 ] ] ?\n                    s.accepts[ s.dataTypes[ 0 ] ] +\n                    ( s.dataTypes[ 0 ] !== \"*\" ? \", \" + allTypes + \"; q=0.01\" : \"\" ) :\n                    s.accepts[ \"*\" ]\n            );\n\n            // Check for headers option\n            for ( i in s.headers ) {\n                jqXHR.setRequestHeader( i, s.headers[ i ] );\n            }\n\n            // Allow custom headers/mimetypes and early abort\n            if ( s.beforeSend &&\n                ( s.beforeSend.call( callbackContext, jqXHR, s ) === false || completed ) ) {\n\n                // Abort if not done already and return\n                return jqXHR.abort();\n            }\n\n            // Aborting is no longer a cancellation\n            strAbort = \"abort\";\n\n            // Install callbacks on deferreds\n            completeDeferred.add( s.complete );\n            jqXHR.done( s.success );\n            jqXHR.fail( s.error );\n\n            // Get transport\n            transport = inspectPrefiltersOrTransports( transports, s, options, jqXHR );\n\n            // If no transport, we auto-abort\n            if ( !transport ) {\n                done( -1, \"No Transport\" );\n            } else {\n                jqXHR.readyState = 1;\n\n                // Send global event\n                if ( fireGlobals ) {\n                    globalEventContext.trigger( \"ajaxSend\", [ jqXHR, s ] );\n                }\n\n                // If request was aborted inside ajaxSend, stop there\n                if ( completed ) {\n                    return jqXHR;\n                }\n\n                // Timeout\n                if ( s.async && s.timeout > 0 ) {\n                    timeoutTimer = window.setTimeout( function() {\n                        jqXHR.abort( \"timeout\" );\n                    }, s.timeout );\n                }\n\n                try {\n                    completed = false;\n                    transport.send( requestHeaders, done );\n                } catch ( e ) {\n\n                    // Rethrow post-completion exceptions\n                    if ( completed ) {\n                        throw e;\n                    }\n\n                    // Propagate others as results\n                    done( -1, e );\n                }\n            }\n\n            // Callback for when everything is done\n            function done( status, nativeStatusText, responses, headers ) {\n                var isSuccess, success, error, response, modified,\n                    statusText = nativeStatusText;\n\n                // Ignore repeat invocations\n                if ( completed ) {\n                    return;\n                }\n\n                completed = true;\n\n                // Clear timeout if it exists\n                if ( timeoutTimer ) {\n                    window.clearTimeout( timeoutTimer );\n                }\n\n                // Dereference transport for early garbage collection\n                // (no matter how long the jqXHR object will be used)\n                transport = undefined;\n\n                // Cache response headers\n                responseHeadersString = headers || \"\";\n\n                // Set readyState\n                jqXHR.readyState = status > 0 ? 4 : 0;\n\n                // Determine if successful\n                isSuccess = status >= 200 && status < 300 || status === 304;\n\n                // Get response data\n                if ( responses ) {\n                    response = ajaxHandleResponses( s, jqXHR, responses );\n                }\n\n                // Use a noop converter for missing script but not if jsonp\n                if ( !isSuccess &&\n                    jQuery.inArray( \"script\", s.dataTypes ) > -1 &&\n                    jQuery.inArray( \"json\", s.dataTypes ) < 0 ) {\n                    s.converters[ \"text script\" ] = function() {};\n                }\n\n                // Convert no matter what (that way responseXXX fields are always set)\n                response = ajaxConvert( s, response, jqXHR, isSuccess );\n\n                // If successful, handle type chaining\n                if ( isSuccess ) {\n\n                    // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.\n                    if ( s.ifModified ) {\n                        modified = jqXHR.getResponseHeader( \"Last-Modified\" );\n                        if ( modified ) {\n                            jQuery.lastModified[ cacheURL ] = modified;\n                        }\n                        modified = jqXHR.getResponseHeader( \"etag\" );\n                        if ( modified ) {\n                            jQuery.etag[ cacheURL ] = modified;\n                        }\n                    }\n\n                    // if no content\n                    if ( status === 204 || s.type === \"HEAD\" ) {\n                        statusText = \"nocontent\";\n\n                        // if not modified\n                    } else if ( status === 304 ) {\n                        statusText = \"notmodified\";\n\n                        // If we have data, let's convert it\n                    } else {\n                        statusText = response.state;\n                        success = response.data;\n                        error = response.error;\n                        isSuccess = !error;\n                    }\n                } else {\n\n                    // Extract error from statusText and normalize for non-aborts\n                    error = statusText;\n                    if ( status || !statusText ) {\n                        statusText = \"error\";\n                        if ( status < 0 ) {\n                            status = 0;\n                        }\n                    }\n                }\n\n                // Set data for the fake xhr object\n                jqXHR.status = status;\n                jqXHR.statusText = ( nativeStatusText || statusText ) + \"\";\n\n                // Success/Error\n                if ( isSuccess ) {\n                    deferred.resolveWith( callbackContext, [ success, statusText, jqXHR ] );\n                } else {\n                    deferred.rejectWith( callbackContext, [ jqXHR, statusText, error ] );\n                }\n\n                // Status-dependent callbacks\n                jqXHR.statusCode( statusCode );\n                statusCode = undefined;\n\n                if ( fireGlobals ) {\n                    globalEventContext.trigger( isSuccess ? \"ajaxSuccess\" : \"ajaxError\",\n                        [ jqXHR, s, isSuccess ? success : error ] );\n                }\n\n                // Complete\n                completeDeferred.fireWith( callbackContext, [ jqXHR, statusText ] );\n\n                if ( fireGlobals ) {\n                    globalEventContext.trigger( \"ajaxComplete\", [ jqXHR, s ] );\n\n                    // Handle the global AJAX counter\n                    if ( !( --jQuery.active ) ) {\n                        jQuery.event.trigger( \"ajaxStop\" );\n                    }\n                }\n            }\n\n            return jqXHR;\n        },\n\n        getJSON: function( url, data, callback ) {\n            return jQuery.get( url, data, callback, \"json\" );\n        },\n\n        getScript: function( url, callback ) {\n            return jQuery.get( url, undefined, callback, \"script\" );\n        }\n    } );\n\n    jQuery.each( [ \"get\", \"post\" ], function( _i, method ) {\n        jQuery[ method ] = function( url, data, callback, type ) {\n\n            // Shift arguments if data argument was omitted\n            if ( isFunction( data ) ) {\n                type = type || callback;\n                callback = data;\n                data = undefined;\n            }\n\n            // The url can be an options object (which then must have .url)\n            return jQuery.ajax( jQuery.extend( {\n                url: url,\n                type: method,\n                dataType: type,\n                data: data,\n                success: callback\n            }, jQuery.isPlainObject( url ) && url ) );\n        };\n    } );\n\n    jQuery.ajaxPrefilter( function( s ) {\n        var i;\n        for ( i in s.headers ) {\n            if ( i.toLowerCase() === \"content-type\" ) {\n                s.contentType = s.headers[ i ] || \"\";\n            }\n        }\n    } );\n\n\n    jQuery._evalUrl = function( url, options, doc ) {\n        return jQuery.ajax( {\n            url: url,\n\n            // Make this explicit, since user can override this through ajaxSetup (trac-11264)\n            type: \"GET\",\n            dataType: \"script\",\n            cache: true,\n            async: false,\n            global: false,\n\n            // Only evaluate the response if it is successful (gh-4126)\n            // dataFilter is not invoked for failure responses, so using it instead\n            // of the default converter is kludgy but it works.\n            converters: {\n                \"text script\": function() {}\n            },\n            dataFilter: function( response ) {\n                jQuery.globalEval( response, options, doc );\n            }\n        } );\n    };\n\n\n    jQuery.fn.extend( {\n        wrapAll: function( html ) {\n            var wrap;\n\n            if ( this[ 0 ] ) {\n                if ( isFunction( html ) ) {\n                    html = html.call( this[ 0 ] );\n                }\n\n                // The elements to wrap the target around\n                wrap = jQuery( html, this[ 0 ].ownerDocument ).eq( 0 ).clone( true );\n\n                if ( this[ 0 ].parentNode ) {\n                    wrap.insertBefore( this[ 0 ] );\n                }\n\n                wrap.map( function() {\n                    var elem = this;\n\n                    while ( elem.firstElementChild ) {\n                        elem = elem.firstElementChild;\n                    }\n\n                    return elem;\n                } ).append( this );\n            }\n\n            return this;\n        },\n\n        wrapInner: function( html ) {\n            if ( isFunction( html ) ) {\n                return this.each( function( i ) {\n                    jQuery( this ).wrapInner( html.call( this, i ) );\n                } );\n            }\n\n            return this.each( function() {\n                var self = jQuery( this ),\n                    contents = self.contents();\n\n                if ( contents.length ) {\n                    contents.wrapAll( html );\n\n                } else {\n                    self.append( html );\n                }\n            } );\n        },\n\n        wrap: function( html ) {\n            var htmlIsFunction = isFunction( html );\n\n            return this.each( function( i ) {\n                jQuery( this ).wrapAll( htmlIsFunction ? html.call( this, i ) : html );\n            } );\n        },\n\n        unwrap: function( selector ) {\n            this.parent( selector ).not( \"body\" ).each( function() {\n                jQuery( this ).replaceWith( this.childNodes );\n            } );\n            return this;\n        }\n    } );\n\n\n    jQuery.expr.pseudos.hidden = function( elem ) {\n        return !jQuery.expr.pseudos.visible( elem );\n    };\n    jQuery.expr.pseudos.visible = function( elem ) {\n        return !!( elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length );\n    };\n\n\n\n\n    jQuery.ajaxSettings.xhr = function() {\n        try {\n            return new window.XMLHttpRequest();\n        } catch ( e ) {}\n    };\n\n    var xhrSuccessStatus = {\n\n            // File protocol always yields status code 0, assume 200\n            0: 200,\n\n            // Support: IE <=9 only\n            // trac-1450: sometimes IE returns 1223 when it should be 204\n            1223: 204\n        },\n        xhrSupported = jQuery.ajaxSettings.xhr();\n\n    support.cors = !!xhrSupported && ( \"withCredentials\" in xhrSupported );\n    support.ajax = xhrSupported = !!xhrSupported;\n\n    jQuery.ajaxTransport( function( options ) {\n        var callback, errorCallback;\n\n        // Cross domain only allowed if supported through XMLHttpRequest\n        if ( support.cors || xhrSupported && !options.crossDomain ) {\n            return {\n                send: function( headers, complete ) {\n                    var i,\n                        xhr = options.xhr();\n\n                    xhr.open(\n                        options.type,\n                        options.url,\n                        options.async,\n                        options.username,\n                        options.password\n                    );\n\n                    // Apply custom fields if provided\n                    if ( options.xhrFields ) {\n                        for ( i in options.xhrFields ) {\n                            xhr[ i ] = options.xhrFields[ i ];\n                        }\n                    }\n\n                    // Override mime type if needed\n                    if ( options.mimeType && xhr.overrideMimeType ) {\n                        xhr.overrideMimeType( options.mimeType );\n                    }\n\n                    // X-Requested-With header\n                    // For cross-domain requests, seeing as conditions for a preflight are\n                    // akin to a jigsaw puzzle, we simply never set it to be sure.\n                    // (it can always be set on a per-request basis or even using ajaxSetup)\n                    // For same-domain requests, won't change header if already provided.\n                    if ( !options.crossDomain && !headers[ \"X-Requested-With\" ] ) {\n                        headers[ \"X-Requested-With\" ] = \"XMLHttpRequest\";\n                    }\n\n                    // Set headers\n                    for ( i in headers ) {\n                        xhr.setRequestHeader( i, headers[ i ] );\n                    }\n\n                    // Callback\n                    callback = function( type ) {\n                        return function() {\n                            if ( callback ) {\n                                callback = errorCallback = xhr.onload =\n                                    xhr.onerror = xhr.onabort = xhr.ontimeout =\n                                        xhr.onreadystatechange = null;\n\n                                if ( type === \"abort\" ) {\n                                    xhr.abort();\n                                } else if ( type === \"error\" ) {\n\n                                    // Support: IE <=9 only\n                                    // On a manual native abort, IE9 throws\n                                    // errors on any property access that is not readyState\n                                    if ( typeof xhr.status !== \"number\" ) {\n                                        complete( 0, \"error\" );\n                                    } else {\n                                        complete(\n\n                                            // File: protocol always yields status 0; see trac-8605, trac-14207\n                                            xhr.status,\n                                            xhr.statusText\n                                        );\n                                    }\n                                } else {\n                                    complete(\n                                        xhrSuccessStatus[ xhr.status ] || xhr.status,\n                                        xhr.statusText,\n\n                                        // Support: IE <=9 only\n                                        // IE9 has no XHR2 but throws on binary (trac-11426)\n                                        // For XHR2 non-text, let the caller handle it (gh-2498)\n                                        ( xhr.responseType || \"text\" ) !== \"text\"  ||\n                                        typeof xhr.responseText !== \"string\" ?\n                                            { binary: xhr.response } :\n                                            { text: xhr.responseText },\n                                        xhr.getAllResponseHeaders()\n                                    );\n                                }\n                            }\n                        };\n                    };\n\n                    // Listen to events\n                    xhr.onload = callback();\n                    errorCallback = xhr.onerror = xhr.ontimeout = callback( \"error\" );\n\n                    // Support: IE 9 only\n                    // Use onreadystatechange to replace onabort\n                    // to handle uncaught aborts\n                    if ( xhr.onabort !== undefined ) {\n                        xhr.onabort = errorCallback;\n                    } else {\n                        xhr.onreadystatechange = function() {\n\n                            // Check readyState before timeout as it changes\n                            if ( xhr.readyState === 4 ) {\n\n                                // Allow onerror to be called first,\n                                // but that will not handle a native abort\n                                // Also, save errorCallback to a variable\n                                // as xhr.onerror cannot be accessed\n                                window.setTimeout( function() {\n                                    if ( callback ) {\n                                        errorCallback();\n                                    }\n                                } );\n                            }\n                        };\n                    }\n\n                    // Create the abort callback\n                    callback = callback( \"abort\" );\n\n                    try {\n\n                        // Do send the request (this may raise an exception)\n                        xhr.send( options.hasContent && options.data || null );\n                    } catch ( e ) {\n\n                        // trac-14683: Only rethrow if this hasn't been notified as an error yet\n                        if ( callback ) {\n                            throw e;\n                        }\n                    }\n                },\n\n                abort: function() {\n                    if ( callback ) {\n                        callback();\n                    }\n                }\n            };\n        }\n    } );\n\n\n\n\n// Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)\n    jQuery.ajaxPrefilter( function( s ) {\n        if ( s.crossDomain ) {\n            s.contents.script = false;\n        }\n    } );\n\n// Install script dataType\n    jQuery.ajaxSetup( {\n        accepts: {\n            script: \"text/javascript, application/javascript, \" +\n                \"application/ecmascript, application/x-ecmascript\"\n        },\n        contents: {\n            script: /\\b(?:java|ecma)script\\b/\n        },\n        converters: {\n            \"text script\": function( text ) {\n                jQuery.globalEval( text );\n                return text;\n            }\n        }\n    } );\n\n// Handle cache's special case and crossDomain\n    jQuery.ajaxPrefilter( \"script\", function( s ) {\n        if ( s.cache === undefined ) {\n            s.cache = false;\n        }\n        if ( s.crossDomain ) {\n            s.type = \"GET\";\n        }\n    } );\n\n// Bind script tag hack transport\n    jQuery.ajaxTransport( \"script\", function( s ) {\n\n        // This transport only deals with cross domain or forced-by-attrs requests\n        if ( s.crossDomain || s.scriptAttrs ) {\n            var script, callback;\n            return {\n                send: function( _, complete ) {\n                    script = jQuery( \"<script>\" )\n                        .attr( s.scriptAttrs || {} )\n                        .prop( { charset: s.scriptCharset, src: s.url } )\n                        .on( \"load error\", callback = function( evt ) {\n                            script.remove();\n                            callback = null;\n                            if ( evt ) {\n                                complete( evt.type === \"error\" ? 404 : 200, evt.type );\n                            }\n                        } );\n\n                    // Use native DOM manipulation to avoid our domManip AJAX trickery\n                    document.head.appendChild( script[ 0 ] );\n                },\n                abort: function() {\n                    if ( callback ) {\n                        callback();\n                    }\n                }\n            };\n        }\n    } );\n\n\n\n\n    var oldCallbacks = [],\n        rjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n// Default jsonp settings\n    jQuery.ajaxSetup( {\n        jsonp: \"callback\",\n        jsonpCallback: function() {\n            var callback = oldCallbacks.pop() || ( jQuery.expando + \"_\" + ( nonce.guid++ ) );\n            this[ callback ] = true;\n            return callback;\n        }\n    } );\n\n// Detect, normalize options and install callbacks for jsonp requests\n    jQuery.ajaxPrefilter( \"json jsonp\", function( s, originalSettings, jqXHR ) {\n\n        var callbackName, overwritten, responseContainer,\n            jsonProp = s.jsonp !== false && ( rjsonp.test( s.url ) ?\n                    \"url\" :\n                    typeof s.data === \"string\" &&\n                    ( s.contentType || \"\" )\n                        .indexOf( \"application/x-www-form-urlencoded\" ) === 0 &&\n                    rjsonp.test( s.data ) && \"data\"\n            );\n\n        // Handle iff the expected data type is \"jsonp\" or we have a parameter to set\n        if ( jsonProp || s.dataTypes[ 0 ] === \"jsonp\" ) {\n\n            // Get callback name, remembering preexisting value associated with it\n            callbackName = s.jsonpCallback = isFunction( s.jsonpCallback ) ?\n                s.jsonpCallback() :\n                s.jsonpCallback;\n\n            // Insert callback into url or form data\n            if ( jsonProp ) {\n                s[ jsonProp ] = s[ jsonProp ].replace( rjsonp, \"$1\" + callbackName );\n            } else if ( s.jsonp !== false ) {\n                s.url += ( rquery.test( s.url ) ? \"&\" : \"?\" ) + s.jsonp + \"=\" + callbackName;\n            }\n\n            // Use data converter to retrieve json after script execution\n            s.converters[ \"script json\" ] = function() {\n                if ( !responseContainer ) {\n                    jQuery.error( callbackName + \" was not called\" );\n                }\n                return responseContainer[ 0 ];\n            };\n\n            // Force json dataType\n            s.dataTypes[ 0 ] = \"json\";\n\n            // Install callback\n            overwritten = window[ callbackName ];\n            window[ callbackName ] = function() {\n                responseContainer = arguments;\n            };\n\n            // Clean-up function (fires after converters)\n            jqXHR.always( function() {\n\n                // If previous value didn't exist - remove it\n                if ( overwritten === undefined ) {\n                    jQuery( window ).removeProp( callbackName );\n\n                    // Otherwise restore preexisting value\n                } else {\n                    window[ callbackName ] = overwritten;\n                }\n\n                // Save back as free\n                if ( s[ callbackName ] ) {\n\n                    // Make sure that re-using the options doesn't screw things around\n                    s.jsonpCallback = originalSettings.jsonpCallback;\n\n                    // Save the callback name for future use\n                    oldCallbacks.push( callbackName );\n                }\n\n                // Call if it was a function and we have a response\n                if ( responseContainer && isFunction( overwritten ) ) {\n                    overwritten( responseContainer[ 0 ] );\n                }\n\n                responseContainer = overwritten = undefined;\n            } );\n\n            // Delegate to script\n            return \"script\";\n        }\n    } );\n\n\n\n\n// Support: Safari 8 only\n// In Safari 8 documents created via document.implementation.createHTMLDocument\n// collapse sibling forms: the second one becomes a child of the first one.\n// Because of that, this security measure has to be disabled in Safari 8.\n// https://bugs.webkit.org/show_bug.cgi?id=137337\n    support.createHTMLDocument = ( function() {\n        var body = document.implementation.createHTMLDocument( \"\" ).body;\n        body.innerHTML = \"<form></form><form></form>\";\n        return body.childNodes.length === 2;\n    } )();\n\n\n// Argument \"data\" should be string of html\n// context (optional): If specified, the fragment will be created in this context,\n// defaults to document\n// keepScripts (optional): If true, will include scripts passed in the html string\n    jQuery.parseHTML = function( data, context, keepScripts ) {\n        if ( typeof data !== \"string\" ) {\n            return [];\n        }\n        if ( typeof context === \"boolean\" ) {\n            keepScripts = context;\n            context = false;\n        }\n\n        var base, parsed, scripts;\n\n        if ( !context ) {\n\n            // Stop scripts or inline event handlers from being executed immediately\n            // by using document.implementation\n            if ( support.createHTMLDocument ) {\n                context = document.implementation.createHTMLDocument( \"\" );\n\n                // Set the base href for the created document\n                // so any parsed elements with URLs\n                // are based on the document's URL (gh-2965)\n                base = context.createElement( \"base\" );\n                base.href = document.location.href;\n                context.head.appendChild( base );\n            } else {\n                context = document;\n            }\n        }\n\n        parsed = rsingleTag.exec( data );\n        scripts = !keepScripts && [];\n\n        // Single tag\n        if ( parsed ) {\n            return [ context.createElement( parsed[ 1 ] ) ];\n        }\n\n        parsed = buildFragment( [ data ], context, scripts );\n\n        if ( scripts && scripts.length ) {\n            jQuery( scripts ).remove();\n        }\n\n        return jQuery.merge( [], parsed.childNodes );\n    };\n\n\n    /**\n     * Load a url into a page\n     */\n    jQuery.fn.load = function( url, params, callback ) {\n        var selector, type, response,\n            self = this,\n            off = url.indexOf( \" \" );\n\n        if ( off > -1 ) {\n            selector = stripAndCollapse( url.slice( off ) );\n            url = url.slice( 0, off );\n        }\n\n        // If it's a function\n        if ( isFunction( params ) ) {\n\n            // We assume that it's the callback\n            callback = params;\n            params = undefined;\n\n            // Otherwise, build a param string\n        } else if ( params && typeof params === \"object\" ) {\n            type = \"POST\";\n        }\n\n        // If we have elements to modify, make the request\n        if ( self.length > 0 ) {\n            jQuery.ajax( {\n                url: url,\n\n                // If \"type\" variable is undefined, then \"GET\" method will be used.\n                // Make value of this field explicit since\n                // user can override it through ajaxSetup method\n                type: type || \"GET\",\n                dataType: \"html\",\n                data: params\n            } ).done( function( responseText ) {\n\n                // Save response for use in complete callback\n                response = arguments;\n\n                self.html( selector ?\n\n                    // If a selector was specified, locate the right elements in a dummy div\n                    // Exclude scripts to avoid IE 'Permission Denied' errors\n                    jQuery( \"<div>\" ).append( jQuery.parseHTML( responseText ) ).find( selector ) :\n\n                    // Otherwise use the full result\n                    responseText );\n\n                // If the request succeeds, this function gets \"data\", \"status\", \"jqXHR\"\n                // but they are ignored because response was set above.\n                // If it fails, this function gets \"jqXHR\", \"status\", \"error\"\n            } ).always( callback && function( jqXHR, status ) {\n                self.each( function() {\n                    callback.apply( this, response || [ jqXHR.responseText, status, jqXHR ] );\n                } );\n            } );\n        }\n\n        return this;\n    };\n\n\n\n\n    jQuery.expr.pseudos.animated = function( elem ) {\n        return jQuery.grep( jQuery.timers, function( fn ) {\n            return elem === fn.elem;\n        } ).length;\n    };\n\n\n\n\n    jQuery.offset = {\n        setOffset: function( elem, options, i ) {\n            var curPosition, curLeft, curCSSTop, curTop, curOffset, curCSSLeft, calculatePosition,\n                position = jQuery.css( elem, \"position\" ),\n                curElem = jQuery( elem ),\n                props = {};\n\n            // Set position first, in-case top/left are set even on static elem\n            if ( position === \"static\" ) {\n                elem.style.position = \"relative\";\n            }\n\n            curOffset = curElem.offset();\n            curCSSTop = jQuery.css( elem, \"top\" );\n            curCSSLeft = jQuery.css( elem, \"left\" );\n            calculatePosition = ( position === \"absolute\" || position === \"fixed\" ) &&\n                ( curCSSTop + curCSSLeft ).indexOf( \"auto\" ) > -1;\n\n            // Need to be able to calculate position if either\n            // top or left is auto and position is either absolute or fixed\n            if ( calculatePosition ) {\n                curPosition = curElem.position();\n                curTop = curPosition.top;\n                curLeft = curPosition.left;\n\n            } else {\n                curTop = parseFloat( curCSSTop ) || 0;\n                curLeft = parseFloat( curCSSLeft ) || 0;\n            }\n\n            if ( isFunction( options ) ) {\n\n                // Use jQuery.extend here to allow modification of coordinates argument (gh-1848)\n                options = options.call( elem, i, jQuery.extend( {}, curOffset ) );\n            }\n\n            if ( options.top != null ) {\n                props.top = ( options.top - curOffset.top ) + curTop;\n            }\n            if ( options.left != null ) {\n                props.left = ( options.left - curOffset.left ) + curLeft;\n            }\n\n            if ( \"using\" in options ) {\n                options.using.call( elem, props );\n\n            } else {\n                curElem.css( props );\n            }\n        }\n    };\n\n    jQuery.fn.extend( {\n\n        // offset() relates an element's border box to the document origin\n        offset: function( options ) {\n\n            // Preserve chaining for setter\n            if ( arguments.length ) {\n                return options === undefined ?\n                    this :\n                    this.each( function( i ) {\n                        jQuery.offset.setOffset( this, options, i );\n                    } );\n            }\n\n            var rect, win,\n                elem = this[ 0 ];\n\n            if ( !elem ) {\n                return;\n            }\n\n            // Return zeros for disconnected and hidden (display: none) elements (gh-2310)\n            // Support: IE <=11 only\n            // Running getBoundingClientRect on a\n            // disconnected node in IE throws an error\n            if ( !elem.getClientRects().length ) {\n                return { top: 0, left: 0 };\n            }\n\n            // Get document-relative position by adding viewport scroll to viewport-relative gBCR\n            rect = elem.getBoundingClientRect();\n            win = elem.ownerDocument.defaultView;\n            return {\n                top: rect.top + win.pageYOffset,\n                left: rect.left + win.pageXOffset\n            };\n        },\n\n        // position() relates an element's margin box to its offset parent's padding box\n        // This corresponds to the behavior of CSS absolute positioning\n        position: function() {\n            if ( !this[ 0 ] ) {\n                return;\n            }\n\n            var offsetParent, offset, doc,\n                elem = this[ 0 ],\n                parentOffset = { top: 0, left: 0 };\n\n            // position:fixed elements are offset from the viewport, which itself always has zero offset\n            if ( jQuery.css( elem, \"position\" ) === \"fixed\" ) {\n\n                // Assume position:fixed implies availability of getBoundingClientRect\n                offset = elem.getBoundingClientRect();\n\n            } else {\n                offset = this.offset();\n\n                // Account for the *real* offset parent, which can be the document or its root element\n                // when a statically positioned element is identified\n                doc = elem.ownerDocument;\n                offsetParent = elem.offsetParent || doc.documentElement;\n                while ( offsetParent &&\n                ( offsetParent === doc.body || offsetParent === doc.documentElement ) &&\n                jQuery.css( offsetParent, \"position\" ) === \"static\" ) {\n\n                    offsetParent = offsetParent.parentNode;\n                }\n                if ( offsetParent && offsetParent !== elem && offsetParent.nodeType === 1 ) {\n\n                    // Incorporate borders into its offset, since they are outside its content origin\n                    parentOffset = jQuery( offsetParent ).offset();\n                    parentOffset.top += jQuery.css( offsetParent, \"borderTopWidth\", true );\n                    parentOffset.left += jQuery.css( offsetParent, \"borderLeftWidth\", true );\n                }\n            }\n\n            // Subtract parent offsets and element margins\n            return {\n                top: offset.top - parentOffset.top - jQuery.css( elem, \"marginTop\", true ),\n                left: offset.left - parentOffset.left - jQuery.css( elem, \"marginLeft\", true )\n            };\n        },\n\n        // This method will return documentElement in the following cases:\n        // 1) For the element inside the iframe without offsetParent, this method will return\n        //    documentElement of the parent window\n        // 2) For the hidden or detached element\n        // 3) For body or html element, i.e. in case of the html node - it will return itself\n        //\n        // but those exceptions were never presented as a real life use-cases\n        // and might be considered as more preferable results.\n        //\n        // This logic, however, is not guaranteed and can change at any point in the future\n        offsetParent: function() {\n            return this.map( function() {\n                var offsetParent = this.offsetParent;\n\n                while ( offsetParent && jQuery.css( offsetParent, \"position\" ) === \"static\" ) {\n                    offsetParent = offsetParent.offsetParent;\n                }\n\n                return offsetParent || documentElement;\n            } );\n        }\n    } );\n\n// Create scrollLeft and scrollTop methods\n    jQuery.each( { scrollLeft: \"pageXOffset\", scrollTop: \"pageYOffset\" }, function( method, prop ) {\n        var top = \"pageYOffset\" === prop;\n\n        jQuery.fn[ method ] = function( val ) {\n            return access( this, function( elem, method, val ) {\n\n                // Coalesce documents and windows\n                var win;\n                if ( isWindow( elem ) ) {\n                    win = elem;\n                } else if ( elem.nodeType === 9 ) {\n                    win = elem.defaultView;\n                }\n\n                if ( val === undefined ) {\n                    return win ? win[ prop ] : elem[ method ];\n                }\n\n                if ( win ) {\n                    win.scrollTo(\n                        !top ? val : win.pageXOffset,\n                        top ? val : win.pageYOffset\n                    );\n\n                } else {\n                    elem[ method ] = val;\n                }\n            }, method, val, arguments.length );\n        };\n    } );\n\n// Support: Safari <=7 - 9.1, Chrome <=37 - 49\n// Add the top/left cssHooks using jQuery.fn.position\n// Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084\n// Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347\n// getComputedStyle returns percent when specified for top/left/bottom/right;\n// rather than make the css module depend on the offset module, just check for it here\n    jQuery.each( [ \"top\", \"left\" ], function( _i, prop ) {\n        jQuery.cssHooks[ prop ] = addGetHookIf( support.pixelPosition,\n            function( elem, computed ) {\n                if ( computed ) {\n                    computed = curCSS( elem, prop );\n\n                    // If curCSS returns percentage, fallback to offset\n                    return rnumnonpx.test( computed ) ?\n                        jQuery( elem ).position()[ prop ] + \"px\" :\n                        computed;\n                }\n            }\n        );\n    } );\n\n\n// Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods\n    jQuery.each( { Height: \"height\", Width: \"width\" }, function( name, type ) {\n        jQuery.each( {\n            padding: \"inner\" + name,\n            content: type,\n            \"\": \"outer\" + name\n        }, function( defaultExtra, funcName ) {\n\n            // Margin is only for outerHeight, outerWidth\n            jQuery.fn[ funcName ] = function( margin, value ) {\n                var chainable = arguments.length && ( defaultExtra || typeof margin !== \"boolean\" ),\n                    extra = defaultExtra || ( margin === true || value === true ? \"margin\" : \"border\" );\n\n                return access( this, function( elem, type, value ) {\n                    var doc;\n\n                    if ( isWindow( elem ) ) {\n\n                        // $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)\n                        return funcName.indexOf( \"outer\" ) === 0 ?\n                            elem[ \"inner\" + name ] :\n                            elem.document.documentElement[ \"client\" + name ];\n                    }\n\n                    // Get document width or height\n                    if ( elem.nodeType === 9 ) {\n                        doc = elem.documentElement;\n\n                        // Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],\n                        // whichever is greatest\n                        return Math.max(\n                            elem.body[ \"scroll\" + name ], doc[ \"scroll\" + name ],\n                            elem.body[ \"offset\" + name ], doc[ \"offset\" + name ],\n                            doc[ \"client\" + name ]\n                        );\n                    }\n\n                    return value === undefined ?\n\n                        // Get width or height on the element, requesting but not forcing parseFloat\n                        jQuery.css( elem, type, extra ) :\n\n                        // Set width or height on the element\n                        jQuery.style( elem, type, value, extra );\n                }, type, chainable ? margin : undefined, chainable );\n            };\n        } );\n    } );\n\n\n    jQuery.each( [\n        \"ajaxStart\",\n        \"ajaxStop\",\n        \"ajaxComplete\",\n        \"ajaxError\",\n        \"ajaxSuccess\",\n        \"ajaxSend\"\n    ], function( _i, type ) {\n        jQuery.fn[ type ] = function( fn ) {\n            return this.on( type, fn );\n        };\n    } );\n\n\n\n\n    jQuery.fn.extend( {\n\n        bind: function( types, data, fn ) {\n            return this.on( types, null, data, fn );\n        },\n        unbind: function( types, fn ) {\n            return this.off( types, null, fn );\n        },\n\n        delegate: function( selector, types, data, fn ) {\n            return this.on( types, selector, data, fn );\n        },\n        undelegate: function( selector, types, fn ) {\n\n            // ( namespace ) or ( selector, types [, fn] )\n            return arguments.length === 1 ?\n                this.off( selector, \"**\" ) :\n                this.off( types, selector || \"**\", fn );\n        },\n\n        hover: function( fnOver, fnOut ) {\n            return this\n                .on( \"mouseenter\", fnOver )\n                .on( \"mouseleave\", fnOut || fnOver );\n        }\n    } );\n\n    jQuery.each(\n        ( \"blur focus focusin focusout resize scroll click dblclick \" +\n            \"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n            \"change select submit keydown keypress keyup contextmenu\" ).split( \" \" ),\n        function( _i, name ) {\n\n            // Handle event binding\n            jQuery.fn[ name ] = function( data, fn ) {\n                return arguments.length > 0 ?\n                    this.on( name, null, data, fn ) :\n                    this.trigger( name );\n            };\n        }\n    );\n\n\n\n\n// Support: Android <=4.0 only\n// Make sure we trim BOM and NBSP\n// Require that the \"whitespace run\" starts from a non-whitespace\n// to avoid O(N^2) behavior when the engine would try matching \"\\s+$\" at each space position.\n    var rtrim = /^[\\s\\uFEFF\\xA0]+|([^\\s\\uFEFF\\xA0])[\\s\\uFEFF\\xA0]+$/g;\n\n// Bind a function to a context, optionally partially applying any\n// arguments.\n// jQuery.proxy is deprecated to promote standards (specifically Function#bind)\n// However, it is not slated for removal any time soon\n    jQuery.proxy = function( fn, context ) {\n        var tmp, args, proxy;\n\n        if ( typeof context === \"string\" ) {\n            tmp = fn[ context ];\n            context = fn;\n            fn = tmp;\n        }\n\n        // Quick check to determine if target is callable, in the spec\n        // this throws a TypeError, but we will just return undefined.\n        if ( !isFunction( fn ) ) {\n            return undefined;\n        }\n\n        // Simulated bind\n        args = slice.call( arguments, 2 );\n        proxy = function() {\n            return fn.apply( context || this, args.concat( slice.call( arguments ) ) );\n        };\n\n        // Set the guid of unique handler to the same of original handler, so it can be removed\n        proxy.guid = fn.guid = fn.guid || jQuery.guid++;\n\n        return proxy;\n    };\n\n    jQuery.holdReady = function( hold ) {\n        if ( hold ) {\n            jQuery.readyWait++;\n        } else {\n            jQuery.ready( true );\n        }\n    };\n    jQuery.isArray = Array.isArray;\n    jQuery.parseJSON = JSON.parse;\n    jQuery.nodeName = nodeName;\n    jQuery.isFunction = isFunction;\n    jQuery.isWindow = isWindow;\n    jQuery.camelCase = camelCase;\n    jQuery.type = toType;\n\n    jQuery.now = Date.now;\n\n    jQuery.isNumeric = function( obj ) {\n\n        // As of jQuery 3.0, isNumeric is limited to\n        // strings and numbers (primitives or objects)\n        // that can be coerced to finite numbers (gh-2662)\n        var type = jQuery.type( obj );\n        return ( type === \"number\" || type === \"string\" ) &&\n\n            // parseFloat NaNs numeric-cast false positives (\"\")\n            // ...but misinterprets leading-number strings, particularly hex literals (\"0x...\")\n            // subtraction forces infinities to NaN\n            !isNaN( obj - parseFloat( obj ) );\n    };\n\n    jQuery.trim = function( text ) {\n        return text == null ?\n            \"\" :\n            ( text + \"\" ).replace( rtrim, \"$1\" );\n    };\n\n\n\n// Register as a named AMD module, since jQuery can be concatenated with other\n// files that may use define, but not via a proper concatenation script that\n// understands anonymous AMD modules. A named AMD is safest and most robust\n// way to register. Lowercase jquery is used because AMD module names are\n// derived from file names, and jQuery is normally delivered in a lowercase\n// file name. Do this after creating the global so that if an AMD module wants\n// to call noConflict to hide this version of jQuery, it will work.\n\n// Note that for maximum portability, libraries that are not jQuery should\n// declare themselves as anonymous modules, and avoid setting a global if an\n// AMD loader is present. jQuery is a special case. For more information, see\n// https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon\n\n    if ( typeof define === \"function\" && define.amd ) {\n        define( \"jquery\", [], function() {\n            return jQuery;\n        } );\n    }\n\n\n\n\n    var\n\n        // Map over jQuery in case of overwrite\n        _jQuery = window.jQuery,\n\n        // Map over the $ in case of overwrite\n        _$ = window.$;\n\n    jQuery.noConflict = function( deep ) {\n        if ( window.$ === jQuery ) {\n            window.$ = _$;\n        }\n\n        if ( deep && window.jQuery === jQuery ) {\n            window.jQuery = _jQuery;\n        }\n\n        return jQuery;\n    };\n\n// Expose jQuery and $ identifiers, even in AMD\n// (trac-7102#comment:10, https://github.com/jquery/jquery/pull/557)\n// and CommonJS for browser emulators (trac-13566)\n    if ( typeof noGlobal === \"undefined\" ) {\n        window.jQuery = window.$ = jQuery;\n    }\n\n\n\n\n    return jQuery;\n} );\n","Magento_Translation/js/i18n-config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n(function () {\n    'use strict';\n\n    require.config({\n        config: {\n            'Magento_Ui/js/lib/knockout/bindings/i18n': {\n                inlineTranslation: true\n            }\n        }\n    });\n})();\n","Magento_Translation/js/mage-translation-dictionary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'text!js-translation.json'\n], function (dict) {\n    'use strict';\n\n    return JSON.parse(dict);\n});\n","Magento_CatalogInventory/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: '',\n            disableParent: false,\n            listens: {\n                disabled: 'processState',\n                checked: 'processState onCheckedChanged'\n            },\n            imports: {\n                readOnly: 'ns = ${ $.ns }, index = stock_data:disabled'\n            }\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue', 'disableParent']);\n        },\n\n        /**\n         * Handle checked and disabled changes to calculate disableParent value\n         */\n        processState: function () {\n            this.disableParent(this.checked() || this.readOnly);\n\n            if (this.readOnly) {\n                this.disable();\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/qty-validator-changer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input'\n        },\n\n        /**\n         * Change validator\n         */\n        handleChanges: function (value) {\n            var isDigits = value !== 1;\n\n            this.validation['validate-integer'] = isDigits;\n            this.validation['less-than-equals-to'] = isDigits ? 99999999 : 99999999.9999;\n            this.validate();\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/use-config-min-sale-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'underscore',\n    'uiRegistry'\n], function (checkbox, _, registry) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: ''\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            this.onCheckedChanged(this.checked());\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            var valueFromConfig = this.valueFromConfig();\n\n            if (newChecked && (_.isArray(valueFromConfig) && valueFromConfig.length === 0 || valueFromConfig === 1)) {\n                this.changeVisibleDisabled(this.inputField, true, true, 1);\n            } else if (newChecked && _.isObject(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, false, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, true, true, null);\n            } else if (newChecked && _.isNumber(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, true, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            } else {\n                this.changeVisibleDisabled(this.inputField, true, this.disabled() || false, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * Change visible and disabled\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         * @param {Boolean} disabled\n         * @param {Null|Number} valueFromConfig\n         */\n        changeVisibleDisabled: function (filter, visible, disabled, valueFromConfig) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    var initialValue = currentComponent.initialValue;\n\n                    if (_.isString(initialValue) || initialValue === 0 || valueFromConfig === 1) {\n                        currentComponent.value(1);\n                    } else if (initialValue) {\n                        currentComponent.value(initialValue);\n                    }\n\n                    currentComponent.visible(visible);\n                    currentComponent.disabled(disabled);\n                }\n            );\n        }\n    });\n});\n","Magento_Swatches/js/swatch-renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'mage/smart-keyboard-handler',\n    'mage/translate',\n    'priceUtils',\n    'jquery-ui-modules/widget',\n    'jquery/jquery.parsequery',\n    'mage/validation/validation'\n], function ($, _, mageTemplate, keyboardHandler, $t, priceUtils) {\n    'use strict';\n\n    /**\n     * Extend form validation to support swatch accessibility\n     */\n    $.widget('mage.validation', $.mage.validation, {\n        /**\n         * Handle form with swatches validation. Focus on first invalid swatch block.\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} validation\n         */\n        listenFormValidateHandler: function (event, validation) {\n            var swatchWrapper, firstActive, swatches, swatch, successList, errorList, firstSwatch;\n\n            this._superApply(arguments);\n\n            swatchWrapper = '.swatch-attribute-options';\n            swatches = $(event.target).find(swatchWrapper);\n\n            if (!swatches.length) {\n                return;\n            }\n\n            swatch = '.swatch-attribute';\n            firstActive = $(validation.errorList[0].element || []);\n            successList = validation.successList;\n            errorList = validation.errorList;\n            firstSwatch = $(firstActive).parent(swatch).find(swatchWrapper);\n\n            keyboardHandler.focus(swatches);\n\n            $.each(successList, function (index, item) {\n                $(item).parent(swatch).find(swatchWrapper).attr('aria-invalid', false);\n            });\n\n            $.each(errorList, function (index, item) {\n                $(item.element).parent(swatch).find(swatchWrapper).attr('aria-invalid', true);\n            });\n\n            if (firstSwatch.length) {\n                $(firstSwatch).trigger('focus');\n            }\n        }\n    });\n\n    /**\n     * Render tooltips by attributes (only to up).\n     * Required element attributes:\n     *  - data-option-type (integer, 0-3)\n     *  - data-option-label (string)\n     *  - data-option-tooltip-thumb\n     *  - data-option-tooltip-value\n     *  - data-thumb-width\n     *  - data-thumb-height\n     */\n    $.widget('mage.SwatchRendererTooltip', {\n        options: {\n            delay: 200,                             //how much ms before tooltip to show\n            tooltipClass: 'swatch-option-tooltip'  //configurable, but remember about css\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            var $widget = this,\n                $this = this.element,\n                $element = $('.' + $widget.options.tooltipClass),\n                timer,\n                type = parseInt($this.data('option-type'), 10),\n                label = $this.data('option-label'),\n                thumb = $this.data('option-tooltip-thumb'),\n                value = $this.data('option-tooltip-value'),\n                width = $this.data('thumb-width'),\n                height = $this.data('thumb-height'),\n                $image,\n                $title,\n                $corner;\n\n            if (!$element.length) {\n                $element = $('<div class=\"' +\n                    $widget.options.tooltipClass +\n                    '\"><div class=\"image\"></div><div class=\"title\"></div><div class=\"corner\"></div></div>'\n                );\n                $('body').append($element);\n            }\n\n            $image = $element.find('.image');\n            $title = $element.find('.title');\n            $corner = $element.find('.corner');\n\n            $this.on('mouseenter', function () {\n                if (!$this.hasClass('disabled')) {\n                    timer = setTimeout(\n                        function () {\n                            var leftOpt = null,\n                                leftCorner = 0,\n                                left,\n                                $window;\n\n                            if (type === 2) {\n                                // Image\n                                $image.css({\n                                    'background': 'url(\"' + thumb + '\") no-repeat center', //Background case\n                                    'background-size': 'initial',\n                                    'width': width + 'px',\n                                    'height': height + 'px'\n                                });\n                                $image.show();\n                            } else if (type === 1) {\n                                // Color\n                                $image.css({\n                                    background: value\n                                });\n                                $image.show();\n                            } else if (type === 0 || type === 3) {\n                                // Default\n                                $image.hide();\n                            }\n\n                            $title.text(label);\n\n                            leftOpt = $this.offset().left;\n                            left = leftOpt + $this.width() / 2 - $element.width() / 2;\n                            $window = $(window);\n\n                            // the numbers (5 and 5) is magick constants for offset from left or right page\n                            if (left < 0) {\n                                left = 5;\n                            } else if (left + $element.width() > $window.width()) {\n                                left = $window.width() - $element.width() - 5;\n                            }\n\n                            // the numbers (6,  3 and 18) is magick constants for offset tooltip\n                            leftCorner = 0;\n\n                            if ($element.width() < $this.width()) {\n                                leftCorner = $element.width() / 2 - 3;\n                            } else {\n                                leftCorner = (leftOpt > left ? leftOpt - left : left - leftOpt) + $this.width() / 2 - 6;\n                            }\n\n                            $corner.css({\n                                left: leftCorner\n                            });\n                            $element.css({\n                                left: left,\n                                top: $this.offset().top - $element.height() - $corner.height() - 18\n                            }).show();\n                        },\n                        $widget.options.delay\n                    );\n                }\n            });\n\n            $this.on('mouseleave', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $(document).on('tap', function () {\n                $element.hide();\n                clearTimeout(timer);\n            });\n\n            $this.on('tap', function (event) {\n                event.stopPropagation();\n            });\n        }\n    });\n\n    /**\n     * Render swatch controls with options and use tooltips.\n     * Required two json:\n     *  - jsonConfig (magento's option config)\n     *  - jsonSwatchConfig (swatch's option config)\n     *\n     *  Tuning:\n     *  - numberToShow (show \"more\" button if options are more)\n     *  - onlySwatches (hide selectboxes)\n     *  - moreButtonText (text for \"more\" button)\n     *  - selectorProduct (selector for product container)\n     *  - selectorProductPrice (selector for change price)\n     */\n    $.widget('mage.SwatchRenderer', {\n        options: {\n            classes: {\n                attributeClass: 'swatch-attribute',\n                attributeLabelClass: 'swatch-attribute-label',\n                attributeSelectedOptionLabelClass: 'swatch-attribute-selected-option',\n                attributeOptionsWrapper: 'swatch-attribute-options',\n                attributeInput: 'swatch-input',\n                optionClass: 'swatch-option',\n                selectClass: 'swatch-select',\n                moreButton: 'swatch-more',\n                loader: 'swatch-option-loading'\n            },\n            // option's json config\n            jsonConfig: {},\n\n            // swatch's json config\n            jsonSwatchConfig: {},\n\n            // selector of parental block of prices and swatches (need to know where to seek for price block)\n            selectorProduct: '.product-info-main',\n\n            // selector of price wrapper (need to know where set price)\n            selectorProductPrice: '[data-role=priceBox]',\n\n            //selector of product images gallery wrapper\n            mediaGallerySelector: '[data-gallery-role=gallery-placeholder]',\n\n            // selector of category product tile wrapper\n            selectorProductTile: '.product-item',\n\n            // number of controls to show (false or zero = show all)\n            numberToShow: false,\n\n            // show only swatch controls\n            onlySwatches: false,\n\n            // enable label for control\n            enableControlLabel: true,\n\n            // control label id\n            controlLabelId: '',\n\n            // text for more button\n            moreButtonText: $t('More'),\n\n            // Callback url for media\n            mediaCallback: '',\n\n            // Local media cache\n            mediaCache: {},\n\n            // Cache for BaseProduct images. Needed when option unset\n            mediaGalleryInitial: [{}],\n\n            // Use ajax to get image data\n            useAjax: false,\n\n            /**\n             * Defines the mechanism of how images of a gallery should be\n             * updated when user switches between configurations of a product.\n             *\n             * As for now value of this option can be either 'replace' or 'prepend'.\n             *\n             * @type {String}\n             */\n            gallerySwitchStrategy: 'replace',\n\n            // whether swatches are rendered in product list or on product page\n            inProductList: false,\n\n            // sly-old-price block selector\n            slyOldPriceSelector: '.sly-old-price',\n\n            // tier prise selectors start\n            tierPriceTemplateSelector: '#tier-prices-template',\n            tierPriceBlockSelector: '[data-role=\"tier-price-block\"]',\n            tierPriceTemplate: '',\n            // tier prise selectors end\n\n            // A price label selector\n            normalPriceLabelSelector: '.normal-price .price-label',\n            qtyInfo: '#qty'\n        },\n\n        /**\n         * Get chosen product\n         *\n         * @returns int|null\n         */\n        getProduct: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) ? products[0] : null;\n        },\n\n        /**\n         * Get chosen product id\n         *\n         * @returns int|null\n         */\n        getProductId: function () {\n            var products = this._CalcProducts();\n\n            return _.isArray(products) && products.length === 1 ? products[0] : null;\n        },\n\n        /**\n         * @private\n         */\n        _init: function () {\n            // Don't render the same set of swatches twice\n            if ($(this.element).attr('data-rendered')) {\n                return;\n            }\n\n            $(this.element).attr('data-rendered', true);\n\n            if (_.isEmpty(this.options.jsonConfig.images)) {\n                this.options.useAjax = true;\n                // creates debounced variant of _LoadProductMedia()\n                // to use it in events handlers instead of _LoadProductMedia()\n                this._debouncedLoadProductMedia = _.debounce(this._LoadProductMedia.bind(this), 500);\n            }\n\n            this.options.tierPriceTemplate = $(this.options.tierPriceTemplateSelector).html();\n\n            if (this.options.jsonConfig !== '' && this.options.jsonSwatchConfig !== '') {\n                // store unsorted attributes\n                this.options.jsonConfig.mappedAttributes = _.clone(this.options.jsonConfig.attributes);\n                this._sortAttributes();\n                this._RenderControls();\n                this._setPreSelectedGallery();\n                $(this.element).trigger('swatch.initialized');\n            } else {\n                console.log('SwatchRenderer: No input data received');\n            }\n        },\n\n        /**\n         * @private\n         */\n        _sortAttributes: function () {\n            this.options.jsonConfig.attributes = _.sortBy(this.options.jsonConfig.attributes, function (attribute) {\n                return parseInt(attribute.position, 10);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            var options = this.options,\n                gallery = $('[data-gallery-role=gallery-placeholder]', '.column.main'),\n                productData = this._determineProductData(),\n                $main = productData.isInProductView ?\n                    this.element.parents('.column.main') :\n                    this.element.parents('.product-item-info');\n\n            if (productData.isInProductView) {\n                gallery.data('gallery') ?\n                    this._onGalleryLoaded(gallery) :\n                    gallery.on('gallery:loaded', this._onGalleryLoaded.bind(this, gallery));\n            } else {\n                options.mediaGalleryInitial = [{\n                    'img': $main.find('.product-image-photo').attr('src')\n                }];\n            }\n\n            this.productForm = this.element.parents(this.options.selectorProductTile).find('form:first');\n            this.inProductList = this.productForm.length > 0;\n            $(this.options.qtyInfo).on('input', this._onQtyChanged.bind(this));\n        },\n\n        /**\n         * Determine product id and related data\n         *\n         * @returns {{productId: *, isInProductView: bool}}\n         * @private\n         */\n        _determineProductData: function () {\n            // Check if product is in a list of products.\n            var productId,\n                isInProductView = false;\n\n            productId = this.element.parents('.product-item-details')\n                .find('.price-box.price-final_price').attr('data-product-id');\n\n            if (!productId) {\n                // Check individual product.\n                productId = $('[name=product]').val();\n                isInProductView = productId > 0;\n            }\n\n            return {\n                productId: productId,\n                isInProductView: isInProductView\n            };\n        },\n\n        /**\n         * Render controls\n         *\n         * @private\n         */\n        _RenderControls: function () {\n            var $widget = this,\n                container = this.element,\n                classes = this.options.classes,\n                chooseText = this.options.jsonConfig.chooseText,\n                showTooltip = this.options.showTooltip;\n\n            $widget.optionsMap = {};\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                var item = this,\n                    controlLabelId = 'option-label-' + item.code + '-' + item.id,\n                    options = $widget._RenderSwatchOptions(item, controlLabelId),\n                    select = $widget._RenderSwatchSelect(item, chooseText),\n                    input = $widget._RenderFormInput(item),\n                    listLabel = '',\n                    label = '';\n\n                // Show only swatch controls\n                if ($widget.options.onlySwatches && !$widget.options.jsonSwatchConfig.hasOwnProperty(item.id)) {\n                    return;\n                }\n\n                if ($widget.options.enableControlLabel) {\n                    label +=\n                        '<span id=\"' + controlLabelId + '\" class=\"' + classes.attributeLabelClass + '\">' +\n                        $('<i></i>').text(item.label).html() +\n                        '</span>' +\n                        '<span class=\"' + classes.attributeSelectedOptionLabelClass + '\"></span>';\n                }\n\n                if ($widget.inProductList) {\n                    $widget.productForm.append(input);\n                    input = '';\n                    listLabel = 'aria-label=\"' + $('<i></i>').text(item.label).html() + '\"';\n                } else {\n                    listLabel = 'aria-labelledby=\"' + controlLabelId + '\"';\n                }\n\n                // Create new control\n                container.append(\n                    '<div class=\"' + classes.attributeClass + ' ' + item.code + '\" ' +\n                         'data-attribute-code=\"' + item.code + '\" ' +\n                         'data-attribute-id=\"' + item.id + '\">' +\n                        label +\n                        '<div aria-activedescendant=\"\" ' +\n                             'tabindex=\"0\" ' +\n                             'aria-invalid=\"false\" ' +\n                             'aria-required=\"true\" ' +\n                             'role=\"listbox\" ' + listLabel +\n                             'class=\"' + classes.attributeOptionsWrapper + ' clearfix\">' +\n                            options + select +\n                        '</div>' + input +\n                    '</div>'\n                );\n\n                $widget.optionsMap[item.id] = {};\n\n                // Aggregate options array to hash (key => value)\n                $.each(item.options, function () {\n                    if (this.products.length > 0) {\n                        let salableProducts = this.products;\n\n                        if ($widget.options.jsonConfig.canDisplayShowOutOfStockStatus) {\n                            salableProducts = $widget.options.jsonConfig.salable[item.id][this.id];\n                        }\n                        $widget.optionsMap[item.id][this.id] = {\n                            price: parseInt(\n                                $widget.options.jsonConfig.optionPrices[this.products[0]].finalPrice.amount,\n                                10\n                            ),\n                            products: salableProducts\n                        };\n                    }\n                });\n            });\n\n            if (showTooltip === 1) {\n                // Connect Tooltip\n                container\n                    .find('[data-option-type=\"1\"], [data-option-type=\"2\"],' +\n                        ' [data-option-type=\"0\"], [data-option-type=\"3\"]')\n                    .SwatchRendererTooltip();\n            }\n\n            // Hide all elements below more button\n            $('.' + classes.moreButton).nextAll().hide();\n\n            // Handle events like click or change\n            $widget._EventListener();\n\n            // Rewind options\n            $widget._Rewind(container);\n\n            //Emulate click on all swatches from Request\n            $widget._EmulateSelected($.parseQuery());\n            $widget._EmulateSelected($widget._getSelectedAttributes());\n        },\n\n        disableSwatchForOutOfStockProducts: function () {\n            let $widget = this, container = this.element;\n\n            $.each(this.options.jsonConfig.attributes, function () {\n                let item = this;\n\n                if ($widget.options.jsonConfig.canDisplayShowOutOfStockStatus) {\n                    let salableProducts = $widget.options.jsonConfig.salable[item.id],\n                        swatchOptions = $(container).find(`[data-attribute-id='${item.id}']`).find('.swatch-option');\n\n                    swatchOptions.each(function (key, value) {\n                        let optionId = $(value).data('option-id');\n\n                        if (!salableProducts.hasOwnProperty(optionId)) {\n                            $(value).attr('disabled', true).addClass('disabled');\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Render swatch options by part of config\n         *\n         * @param {Object} config\n         * @param {String} controlId\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchOptions: function (config, controlId) {\n            var optionConfig = this.options.jsonSwatchConfig[config.id],\n                optionClass = this.options.classes.optionClass,\n                sizeConfig = this.options.jsonSwatchImageSizeConfig,\n                moreLimit = parseInt(this.options.numberToShow, 10),\n                moreClass = this.options.classes.moreButton,\n                moreText = this.options.moreButtonText,\n                countAttributes = 0,\n                html = '';\n\n            if (!this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            $.each(config.options, function (index) {\n                var id,\n                    type,\n                    value,\n                    thumb,\n                    label,\n                    width,\n                    height,\n                    attr,\n                    swatchImageWidth,\n                    swatchImageHeight;\n\n                if (!optionConfig.hasOwnProperty(this.id)) {\n                    return '';\n                }\n\n                // Add more button\n                if (moreLimit === countAttributes++) {\n                    html += '<a href=\"#\" class=\"' + moreClass + '\"><span>' + moreText + '</span></a>';\n                }\n\n                id = this.id;\n                type = parseInt(optionConfig[id].type, 10);\n                value = optionConfig[id].hasOwnProperty('value') ?\n                    $('<i></i>').text(optionConfig[id].value).html() : '';\n                thumb = optionConfig[id].hasOwnProperty('thumb') ? optionConfig[id].thumb : '';\n                width = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.width : 110;\n                height = _.has(sizeConfig, 'swatchThumb') ? sizeConfig.swatchThumb.height : 90;\n                label = this.label ? $('<i></i>').text(this.label).html() : '';\n                attr =\n                    ' id=\"' + controlId + '-item-' + id + '\"' +\n                    ' index=\"' + index + '\"' +\n                    ' aria-checked=\"false\"' +\n                    ' aria-describedby=\"' + controlId + '\"' +\n                    ' tabindex=\"0\"' +\n                    ' data-option-type=\"' + type + '\"' +\n                    ' data-option-id=\"' + id + '\"' +\n                    ' data-option-label=\"' + label + '\"' +\n                    ' aria-label=\"' + label + '\"' +\n                    ' role=\"option\"' +\n                    ' data-thumb-width=\"' + width + '\"' +\n                    ' data-thumb-height=\"' + height + '\"';\n\n                attr += thumb !== '' ? ' data-option-tooltip-thumb=\"' + thumb + '\"' : '';\n                attr += value !== '' ? ' data-option-tooltip-value=\"' + value + '\"' : '';\n\n                swatchImageWidth = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.width : 30;\n                swatchImageHeight = _.has(sizeConfig, 'swatchImage') ? sizeConfig.swatchImage.height : 20;\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                if (type === 0) {\n                    // Text\n                    html += '<div class=\"' + optionClass + ' text\" ' + attr + '>' + (value ? value : label) +\n                        '</div>';\n                } else if (type === 1) {\n                    // Color\n                    html += '<div class=\"' + optionClass + ' color\" ' + attr +\n                        ' style=\"background: ' + value +\n                        ' no-repeat center; background-size: initial;\">' + '' +\n                        '</div>';\n                } else if (type === 2) {\n                    // Image\n                    html += '<div class=\"' + optionClass + ' image\" ' + attr +\n                        ' style=\"background: url(' + value + ') no-repeat center; background-size: initial;width:' +\n                        swatchImageWidth + 'px; height:' + swatchImageHeight + 'px\">' + '' +\n                        '</div>';\n                } else if (type === 3) {\n                    // Clear\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '></div>';\n                } else {\n                    // Default\n                    html += '<div class=\"' + optionClass + '\" ' + attr + '>' + label + '</div>';\n                }\n            });\n\n            return html;\n        },\n\n        /**\n         * Render select by part of config\n         *\n         * @param {Object} config\n         * @param {String} chooseText\n         * @returns {String}\n         * @private\n         */\n        _RenderSwatchSelect: function (config, chooseText) {\n            var html;\n\n            if (this.options.jsonSwatchConfig.hasOwnProperty(config.id)) {\n                return '';\n            }\n\n            html =\n                '<select class=\"' + this.options.classes.selectClass + ' ' + config.code + '\">' +\n                '<option value=\"0\" data-option-id=\"0\">' + chooseText + '</option>';\n\n            $.each(config.options, function () {\n                var label = this.label,\n                    attr = ' value=\"' + this.id + '\" data-option-id=\"' + this.id + '\"';\n\n                if (!this.hasOwnProperty('products') || this.products.length <= 0) {\n                    attr += ' data-option-empty=\"true\"';\n                }\n\n                html += '<option ' + attr + '>' + label + '</option>';\n            });\n\n            html += '</select>';\n\n            return html;\n        },\n\n        /**\n         * Input for submit form.\n         * This control shouldn't have \"type=hidden\", \"display: none\" for validation work :(\n         *\n         * @param {Object} config\n         * @private\n         */\n        _RenderFormInput: function (config) {\n            return '<input class=\"' + this.options.classes.attributeInput + ' super-attribute-select\" ' +\n                'name=\"super_attribute[' + config.id + ']\" ' +\n                'type=\"text\" ' +\n                'value=\"\" ' +\n                'data-selector=\"super_attribute[' + config.id + ']\" ' +\n                'data-validate=\"{required: true}\" ' +\n                'aria-required=\"true\" ' +\n                'aria-invalid=\"false\">';\n        },\n\n        /**\n         * Event listener\n         *\n         * @private\n         */\n        _EventListener: function () {\n            var $widget = this,\n                options = this.options.classes,\n                target;\n\n            $widget.element.on('click', '.' + options.optionClass, function () {\n                return $widget._OnClick($(this), $widget);\n            });\n\n            $widget.element.on('change', '.' + options.selectClass, function () {\n                return $widget._OnChange($(this), $widget);\n            });\n\n            $widget.element.on('click', '.' + options.moreButton, function (e) {\n                e.preventDefault();\n\n                return $widget._OnMoreClick($(this));\n            });\n\n            $widget.element.on('keydown', function (e) {\n                if (e.which === 13) {\n                    target = $(e.target);\n\n                    if (target.is('.' + options.optionClass)) {\n                        return $widget._OnClick(target, $widget);\n                    } else if (target.is('.' + options.selectClass)) {\n                        return $widget._OnChange(target, $widget);\n                    } else if (target.is('.' + options.moreButton)) {\n                        e.preventDefault();\n\n                        return $widget._OnMoreClick(target);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Load media gallery using ajax or json config.\n         *\n         * @private\n         */\n        _loadMedia: function () {\n            var $main = this.inProductList ?\n                    this.element.parents('.product-item-info') :\n                    this.element.parents('.column.main'),\n                images;\n\n            if (this.options.useAjax) {\n                this._debouncedLoad