require.config({"config": {
        "jsbuild":{"Magento_Swatches/js/form/element/swatch-visual.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'mage/template',\n    'uiRegistry',\n    'prototype',\n    'Magento_Ui/js/form/element/abstract',\n    'jquery/colorpicker/js/colorpicker',\n    'jquery/ui'\n], function (_, jQuery, mageTemplate, rg, prototype, Abstract) {\n    'use strict';\n\n    /**\n     * Former implementation.\n     *\n     * @param {*} value\n     * @param {Object} container\n     * @param {String} uploadUrl\n     * @param {String} elementName\n     */\n    function oldCode(value, container, uploadUrl, elementName) {\n        var swatchVisualOption = {\n            itemCount: 0,\n            totalItems: 0,\n            rendered: 0,\n            isReadOnly: false,\n\n            /**\n             * Initialize.\n             */\n            initialize: function () {\n                if (_.isEmpty(value)) {\n                    container.addClassName('unavailable');\n                }\n\n                jQuery(container).on(\n                    'click',\n                    '.colorpicker_handler',\n                    this.initColorPicker\n                );\n            },\n\n            /**\n             * ColorPicker initialization process\n             */\n            initColorPicker: function () {\n                var element = this,\n                    hiddenColorPicker = !jQuery(element).data('colorpickerId');\n\n                jQuery(this).ColorPicker({\n\n                    /**\n                     * ColorPicker onShow action\n                     */\n                    onShow: function () {\n                        var color = jQuery(element).parent().parent().prev().prev('input').val(),\n                            menu = jQuery(this).parents('.swatch_sub-menu_container');\n\n                        menu.hide();\n                        jQuery(element).ColorPickerSetColor(color);\n                    },\n\n                    /**\n                     * ColorPicker onSubmit action\n                     *\n                     * @param {String} hsb\n                     * @param {String} hex\n                     * @param {String} rgb\n                     * @param {String} el\n                     */\n                    onSubmit: function (hsb, hex, rgb, el) {\n                        var localContainer = jQuery(el).parent().parent().prev();\n\n                        jQuery(el).ColorPickerHide();\n                        localContainer.parent().removeClass('unavailable');\n                        localContainer.prev('input').val('#' + hex).trigger('change');\n                        localContainer.css('background', '#' + hex);\n                    }\n                });\n\n                if (hiddenColorPicker) {\n                    jQuery(this).ColorPickerShow();\n                }\n            },\n\n            /**\n             * Remove action\n             *\n             * @param {Object} event\n             */\n            remove: function (event) {\n                var element = $(Event.findElement(event, 'tr')),\n                    elementFlags; // !!! Button already have table parent in safari\n\n                // Safari workaround\n                element.ancestors().each(function (parentItem) {\n                    if (parentItem.hasClassName('option-row')) {\n                        element = parentItem;\n                        throw $break;\n                    } else if (parentItem.hasClassName('box')) {\n                        throw $break;\n                    }\n                });\n\n                if (element) {\n                    elementFlags = element.getElementsByClassName('delete-flag');\n\n                    if (elementFlags[0]) {\n                        elementFlags[0].value = 1;\n                    }\n\n                    element.addClassName('no-display');\n                    element.addClassName('template');\n                    element.hide();\n                    this.totalItems--;\n                    this.updateItemsCountField();\n                }\n            },\n\n            /**\n             * Update items count field\n             */\n            updateItemsCountField: function () {\n                $('swatch-visual-option-count-check').value = this.totalItems > 0 ? '1' : '';\n            }\n        };\n\n        //swatchVisualOption.initColorPicker();\n\n        jQuery('body').on('click', function (event) {\n            var element = jQuery(event.target);\n\n            if (\n                element.parents('.swatch_sub-menu_container').length === 1 ||\n                element.next('div.swatch_sub-menu_container').length === 1\n            ) {\n                return true;\n            }\n            jQuery('.swatch_sub-menu_container').hide();\n        });\n\n        jQuery(function ($) {\n\n            var swatchComponents = {\n\n                /**\n                 * div wrapper for to hide all evement\n                 */\n                wrapper: null,\n\n                /**\n                 * iframe component to perform file upload without page reload\n                 */\n                iframe: null,\n\n                /**\n                 * form component for upload image\n                 */\n                form: null,\n\n                /**\n                 * Input file component for upload image\n                 */\n                inputFile: null,\n\n                /**\n                 * Create swatch component for upload files\n                 *\n                 * @this {swatchComponents}\n                 * @public\n                 */\n                create: function () {\n                    this.wrapper = $('<div>').css({\n                        display: 'none'\n                    }).appendTo($('body'));\n\n                    this.iframe = $('<iframe></iframe>', {\n                        name: 'upload_iframe_' + elementName\n                    }).appendTo(this.wrapper);\n\n                    this.form = $('<form></form>', {\n                        name: 'swatch_form_image_upload_' + elementName,\n                        target: 'upload_iframe_' + elementName,\n                        method: 'post',\n                        enctype: 'multipart/form-data',\n                        class: 'ignore-validate',\n                        action: uploadUrl\n                    }).appendTo(this.wrapper);\n\n                    this.inputFile = $('<input />', {\n                        type: 'file',\n                        name: 'datafile',\n                        class: 'swatch_option_file'\n                    }).appendTo(this.form);\n\n                    $('<input />', {\n                        type: 'hidden',\n                        name: 'form_key',\n                        value: FORM_KEY\n                    }).appendTo(this.form);\n                }\n            };\n\n            swatchVisualOption.initialize();\n\n            /**\n             * Create swatch components\n             */\n            swatchComponents.create();\n\n            /**\n             * Register event for swatch input[type=file] change\n             */\n            swatchComponents.inputFile.change(function () {\n                var localContainer = $('.' + $(this).attr('data-called-by')).parents().eq(2).children('.swatch_window'),\n\n                    /**\n                     * @this {iframe}\n                     */\n                    iframeHandler = function () {\n                        var imageParams = $.parseJSON($(this).contents().find('body').html()),\n                            fullMediaUrl = imageParams['swatch_path'] + imageParams['file_path'];\n\n                        localContainer.prev('input').val(imageParams['file_path']).trigger('change');\n                        localContainer.css({\n                            'background-image': 'url(' + fullMediaUrl + ')',\n                            'background-size': 'cover'\n                        });\n                        localContainer.parent().removeClass('unavailable');\n                    };\n\n                swatchComponents.iframe.off('load');\n                swatchComponents.iframe.on('load', iframeHandler);\n                swatchComponents.form.submit();\n                $(this).val('');\n            });\n\n            /**\n             * Register event for choose \"upload image\" option\n             */\n            $(container).on('click', '.btn_choose_file_upload', function () {\n                swatchComponents.inputFile.attr('data-called-by', $(this).data('class'));\n                swatchComponents.inputFile.trigger('click');\n            });\n\n            /**\n             * Register event for remove option\n             */\n            $(container).on('click', '.btn_remove_swatch', function () {\n                var optionPanel = $(this).parents().eq(2);\n\n                optionPanel.children('input').val('').trigger('change');\n                optionPanel.children('.swatch_window').css('background', '');\n                optionPanel.addClass('unavailable');\n                jQuery('.swatch_sub-menu_container').hide();\n            });\n\n            /**\n             * Toggle color upload chooser\n             */\n            $(container).on('click', '.swatch_window', function () {\n                jQuery('.swatch_sub-menu_container').hide();\n                $(this).next('div').toggle();\n            });\n        });\n    }\n\n    return Abstract.extend({\n        defaults: {\n            elementId: 0,\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            value: '',\n            uploadUrl: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Initialize.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initOldCode()\n                .on('value', this.onChangeColor.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Handler function that execute when color changes.\n         *\n         * @param {String} data - color\n         */\n        onChangeColor: function (data) {\n            if (!data) {\n                jQuery('.' + this.elementName).parent().removeClass('unavailable');\n            }\n        },\n\n        /**\n         * Initialize wrapped former implementation.\n         *\n         * @returns {Object} Chainable.\n         */\n        initOldCode: function () {\n            jQuery.async('.' + this.elementName, this.name, function (elem) {\n                oldCode(this.value(), elem.parentElement, this.uploadUrl, this.elementName);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId, prefixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            this.inputName = prefixName + '[' + this.elementName + ']';\n            this.exportDataLink = 'data.' + this.prefixName + '.' + this.elementName;\n            this.exports.value = this.provider + ':' + this.exportDataLink;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n\n            this.source.remove(this.exportDataLink);\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Add new level of nesting.\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        }\n    });\n});\n","Hyva_Checkout/js/hyva-themes-checkout.js":"define([\n    'jquery',\n    'Magento_Ui/js/lib/core/class',\n    'underscore',\n    'jquery/ui'\n], function (\n    $,\n    Class,\n    _\n) {\n    'use strict';\n\n    return Class.extend({\n        initialize: function (config) {\n            this.getFields(config, 'shipping_address', 'eav_attribute_form_fields');\n            this.getFields(config, 'billing_address', 'eav_attribute_form_fields');\n        },\n\n        /**\n         * Get the fields and call actions and set observers.\n         *\n         * @param object config\n         * @param string name\n         */\n        getFields: function (config, group, field) {\n            var fieldString = '#row_hyva_themes_checkout_component_' + group + '_' + field;\n\n            this.addRow(\n                fieldString + ' table td:nth-child(2) input',\n                name,\n                config.fields.merged,\n                this,\n                fieldString + ' table td:first-child input',\n                fieldString + ' table tbody'\n            );\n\n            this.setReadonly(fieldString + ' table td:first-child input');\n\n            this.setChecboxes(fieldString + ' table td:nth-child(3) input:checkbox');\n            this.setChecboxes(fieldString + ' table td:nth-child(4) input:checkbox');\n\n            this.removeButton(\n                fieldString + ' table td:nth-child(7) button',\n                'td:nth-child(2) input',\n                config.fields.merged,\n                this,\n                fieldString + ' table td:first-child input'\n            );\n\n            this.addObserver(\n                fieldString + ' table tfoot button',\n                fieldString + ' table td:first-child input',\n                this\n            );\n\n            this.addSortable(\n                fieldString + ' table tbody',\n                fieldString + ' table td:first-child input',\n                this\n            );\n        },\n\n        /**\n         * Based on selector set readonly on element.\n         *\n         * @param string selector\n         */\n        setReadonly: function (selector) {\n            $(selector).each(function () {\n                $(this).prop('readonly', true);\n            });\n        },\n\n        /**\n         * Based on selector set hidden elements to match real checboxes.\n         *\n         * @param string selector\n         */\n        setChecboxes: function (selector) {\n            $(selector).each(function (index) {\n                var el = $(this),\n                    tmp = el.clone().attr('type', 'hidden').attr('value', '0');\n\n                if (el.val() === \"1\") {\n                    el.prop('checked', true);\n                }\n\n                el.val(\"1\");\n                tmp.insertBefore(el);\n            });\n\n        },\n\n        /**\n         * Based on selector update sort value on element.\n         *\n         * @param string selector\n         */\n        setOrder: function (selector) {\n            $(selector).each(function (index) {\n                $(this).val(index + 1);\n            });\n        },\n\n        /**\n         * Remove a button element from the table.\n         *\n         * @param string selector\n         * @param string search\n         * @param object mergedFields\n         */\n        removeButton: function (\n            selector,\n            search,\n            mergedFields,\n            that,\n            inputSelector\n        ) {\n            $(selector).each(\n                function () {\n                    var inputElem = this.up('tr').select(search).first();\n\n                    var visible = this.up('tr').select(\"td:nth-child(4) input\").first();\n                    if (inputElem) {\n                        if (typeof mergedFields[inputElem.value.split(/[:]+/).pop()] !== 'undefined') {\n                            inputElem.readOnly = true;\n\n                            var required = this.up('tr').select(\"td:nth-child(3) input\").each(\n                                function(requiredElem) {\n                                    requiredElem.readOnly = true;\n                                }\n                            );\n\n                            var visible = this.up('tr').select(\"td:nth-child(4) input\").each(\n                                function(visible) {\n                                    visible.readOnly = true;\n                                }\n                            );\n\n                            this.remove();\n                        } else {\n                            $(this).bind('click', function () {\n                                that.setOrder(inputSelector);\n                            });\n                        }\n                    }\n                }\n            );\n        },\n\n        /**\n         * attach observer functionality to \"add button\"\n         *\n         * @param string selector\n         * @param string inputSelector\n         * @param object that\n         */\n        addObserver: function (selector, inputSelector, that) {\n            $(selector).first().click(function () {\n                that.setReadonly(inputSelector);\n                that.setOrder(inputSelector);\n            });\n        },\n\n        /**\n         * attach sortable functionality to table\n         *\n         * @param string selector\n         * @param string inputSelector\n         * @param object that\n         */\n        addSortable: function (selector, inputSelector, that) {\n            $(selector).sortable({\n                placeholder : 'ui-state-highlight',\n                axis : 'y',\n                cursor : 'move',\n                cursorAt : {\n                    left : 5\n                },\n                update : function (event, ui) {\n                    that.setOrder(inputSelector);\n                }\n\n            });\n        },\n\n        /**\n         * Add a row to table via in page method window[containerElemId].add.\n         *\n         * @param string selector\n         * @param string name\n         * @param object mergedFields\n         */\n        addRow: function (selector, name, mergedFields, that, inputSelector, rowSelector) {\n            var data = $(selector),\n                rowId = $(rowSelector),\n                existing = {},\n                containerElemId = false;\n\n            if (!containerElemId && rowId) {\n                containerElemId = rowId.attr('id');\n            }\n\n            data.each(function () {\n                var value = this.value.split(/[:]+/).pop();\n\n                if (typeof mergedFields[value] !== 'undefined') {\n                    existing[value] = value;\n                }\n            });\n\n            if (containerElemId) {\n                containerElemId = containerElemId.replace('addRow', 'arrayRow');\n\n                var fieldsLength   = Object.keys(mergedFields).length,\n                    existingLength = Object.keys(existing).length;\n\n                if (fieldsLength > existingLength) {\n                    var i = existingLength;\n\n                    $.each(mergedFields, function (key) {\n                        var d  = new Date(),\n                            id = '_' + d.getTime() + '_' + d.getMilliseconds() + '_' + i;\n\n                        if (typeof existing[key] === 'undefined') {\n                            i++;\n\n                            window[containerElemId].add({\n                                'sort_order': '' + i + '',\n                                'attribute_code': '' + key + '',\n                                \"enabled\": \"1\",\n                                \"required\": \"0\",\n                                'length': '2',\n                                'css_class': '',\n                                // 'default_value': '',\n                                'tool_tip': '',\n                                '_id': '' + id + '',\n                                'column_values': {\n                                    \"' + id + '_sort_order\": +i,\n                                    \"' + id + '_attribute_code\": '' + key + '',\n                                    \"' + id + '_enabled\": '1',\n                                    \"' + id + '_required\": '' + mergedFields[key].required + '',\n                                    \"' + id + '_length\": '' + i + '',\n                                    \"' + id + '_css_class\": '',\n                                    // \"' + id + '_default_value\": ''\n                                    \"' + id + '_tool_tip\": ''\n                                }\n                            });\n                        }\n                    });\n                }\n\n                that.setOrder(inputSelector);\n            }\n        }\n    })\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**************************** CONFIGURABLE PRODUCT **************************/\n/* global Product, optionsPrice */\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/translate',\n    'prototype'\n], function (jQuery, mageTemplate) {\n    'use strict';\n\n    if (typeof Product == 'undefined') {\n        window.Product = {};\n    }\n\n    Product.Config = Class.create();\n    Product.Config.prototype = {\n        /**\n         * Initialize function.\n         *\n         * @param {Object} config\n         */\n        initialize: function (config) {\n            var separatorIndex, paramsStr, urlValues, i, childSettings, prevSetting, nextSetting;\n\n            // Magic preprocessing\n            // TODO MAGETWO-31539\n            config.taxConfig = {\n                showBothPrices: false,\n                inclTaxTitle: jQuery.mage.__('Incl. Tax')\n            };\n\n            this.config     = config;\n            this.taxConfig  = this.config.taxConfig;\n\n            if (config.containerId) {\n                this.settings   = $$('#' + config.containerId + ' ' + '.super-attribute-select');\n            } else {\n                this.settings   = $$('.super-attribute-select');\n            }\n            this.state      = new Hash();\n            this.priceTemplate = mageTemplate(this.config.template);\n            this.prices     = config.prices;\n            this.values     = {};\n\n            // Set default values from config\n            if (config.defaultValues) {\n                this.values = config.defaultValues;\n            }\n\n            // Overwrite defaults by url\n            separatorIndex = window.location.href.indexOf('#');\n\n            if (separatorIndex != -1) { //eslint-disable-line eqeqeq\n                paramsStr = window.location.href.substr(separatorIndex + 1);\n                urlValues = paramsStr.toQueryParams();\n\n                for (i in urlValues) { //eslint-disable-line guard-for-in\n                    this.values[i] = urlValues[i];\n                }\n            }\n\n            // Overwrite defaults by inputs values if needed\n            if (config.inputsInitialized) {\n                this.values = {};\n                this.settings.each(function (element) {\n                    var attributeId;\n\n                    if (element.value) {\n                        attributeId = element.id.replace(/[a-z]*/, '');\n                        this.values[attributeId] = element.value;\n                    }\n                }.bind(this));\n            }\n\n            // Put events to check select reloads\n            this.settings.each(function (element) {\n                Event.observe(element, 'change', this.configure.bind(this));\n            }.bind(this));\n\n            // fill state\n            this.settings.each(function (element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.config.attributes[attributeId]) {\n                    element.config = this.config.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.state[attributeId] = false;\n                }\n            }.bind(this));\n\n            // Init settings dropdown\n            childSettings = [];\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                prevSetting = this.settings[i - 1] ? this.settings[i - 1] : false;\n                nextSetting = this.settings[i + 1] ? this.settings[i + 1] : false;\n\n                if (i === 0) {\n                    this.fillSelect(this.settings[i]);\n                } else {\n                    this.settings[i].disabled = true;\n                }\n                $(this.settings[i]).childSettings = childSettings.clone();\n                $(this.settings[i]).prevSetting   = prevSetting;\n                $(this.settings[i]).nextSetting   = nextSetting;\n                childSettings.push(this.settings[i]);\n            }\n\n            // Set values to inputs\n            this.configureForValues();\n            document.observe('dom:loaded', this.configureForValues.bind(this));\n        },\n\n        /**\n         * Configure for values.\n         */\n        configureForValues: function () {\n            if (this.values) {\n                this.settings.each(function (element) {\n                    var attributeId = element.attributeId;\n\n                    element.value = typeof this.values[attributeId] === 'undefined' ? '' : this.values[attributeId];\n                    this.configureElement(element);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Object} event\n         */\n        configure: function (event) {\n            var element = Event.element(event);\n\n            this.configureElement(element);\n        },\n\n        /**\n         * @param {Object} element\n         */\n        configureElement: function (element) {\n            this.reloadOptionLabels(element);\n\n            if (element.value) {\n                this.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this.fillSelect(element.nextSetting);\n                    this.resetChildren(element.nextSetting);\n                }\n            } else {\n                this.resetChildren(element);\n            }\n            this.reloadPrice();\n        },\n\n        /**\n         * @param {Object} element\n         */\n        reloadOptionLabels: function (element) {\n            var selectedPrice = 0,\n                option, i;\n\n            if (element.options[element.selectedIndex] && element.options[element.selectedIndex].config) {\n                option = element.options[element.selectedIndex].config;\n                selectedPrice = parseFloat(this.config.optionPrices[option.allowedProducts[0]].finalPrice.amount);\n            }\n            element.setAttribute('price', selectedPrice);\n\n            for (i = 0; i < element.options.length; i++) {\n                if (element.options[i].config) {\n                    element.options[i].setAttribute('price', selectedPrice);\n                    element.options[i].setAttribute('summarizePrice', 0);\n                    element.options[i].text = this.getOptionLabel(element.options[i].config, selectedPrice);\n                }\n            }\n        },\n\n        /* eslint-disable max-depth */\n        /**\n         * @param {Object} element\n         */\n        resetChildren: function (element) {\n            var i;\n\n            if (element.childSettings) {\n                for (i = 0; i < element.childSettings.length; i++) {\n                    element.childSettings[i].selectedIndex = 0;\n                    element.childSettings[i].disabled = true;\n\n                    if (element.config) {\n                        this.state[element.config.id] = false;\n                    }\n                }\n            }\n        },\n\n        /**\n         * @param {Object} element\n         */\n        fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this.getAttributeOptions(attributeId),\n                prevConfig = false,\n                index = 1,\n                i, j, allowedProducts;\n\n            this.clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.config.chooseText;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (i = 0; i < options.length; i++) {\n                    allowedProducts = [];\n\n                    if (prevConfig) {\n                        for (j = 0; j < options[i].products.length; j++) {\n                            if (prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1\n                            ) {\n                                allowedProducts.push(options[i].products[j]);\n                            }\n                        }\n                    } else {\n                        allowedProducts = options[i].products.clone();\n                    }\n\n                    if (allowedProducts.size() > 0) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this.getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price != 'undefined') {\n                            element.options[index].setAttribute('price', options[i].price);\n                        }\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n                }\n            }\n        },\n\n        //eslint-enable max-depth\n        /**\n         * @param {Object} option\n         */\n        getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * @param {*} price\n         * @param {Boolean} showSign\n         * @return {String}\n         */\n        formatPrice: function (price, showSign) {\n            var str = '',\n                roundedPrice;\n\n            price = parseFloat(price);\n\n            if (showSign) {\n                if (price < 0) {\n                    str += '-';\n                    price = -price;\n                } else {\n                    str += '+';\n                }\n            }\n\n            roundedPrice = Number(Math.round(price + 'e+2') + 'e-2').toString();\n\n            if (this.prices && this.prices[roundedPrice]) {\n                str += this.prices[roundedPrice];\n            } else {\n                str += this.priceTemplate({\n                    data: {\n                        price: price.toFixed(2)\n                    }\n                });\n            }\n\n            return str;\n        },\n\n        /**\n         * @param {Object} element\n         */\n        clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * @param {*} attributeId\n         * @return {*|undefined}\n         */\n        getAttributeOptions: function (attributeId) {\n            if (this.config.attributes[attributeId]) {\n                return this.config.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload price.\n         *\n         * @return {undefined|Number}\n         */\n        reloadPrice: function () {\n            var price = 0,\n                oldPrice = 0,\n                inclTaxPrice = 0,\n                exclTaxPrice = 0,\n                i, selected;\n\n            if (this.config.disablePriceReload) {\n                return undefined;\n            }\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                if (selected.config) {\n                    price += parseFloat(selected.config.price);\n                    oldPrice += parseFloat(selected.config.oldPrice);\n                    inclTaxPrice += parseFloat(selected.config.inclTaxPrice);\n                    exclTaxPrice += parseFloat(selected.config.exclTaxPrice);\n                }\n            }\n\n            optionsPrice.changePrice(\n                'config', {\n                    'price': price,\n                    'oldPrice': oldPrice,\n                    'inclTaxPrice': inclTaxPrice,\n                    'exclTaxPrice': exclTaxPrice\n                }\n            );\n            optionsPrice.reload();\n\n            return price;\n        },\n\n        /**\n         * Reload old price.\n         */\n        reloadOldPrice: function () {\n            var price, i, selected;\n\n            if (this.config.disablePriceReload) {\n                return;\n            }\n\n            if ($('old-price-' + this.config.productId)) {\n\n                price = parseFloat(this.config.oldPrice);\n\n                for (i = this.settings.length - 1; i >= 0; i--) {\n                    selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                    if (selected.config) {\n                        price += parseFloat(selected.config.price);\n                    }\n                }\n\n                if (price < 0) {\n                    price = 0;\n                }\n                price = this.formatPrice(price);\n\n                if ($('old-price-' + this.config.productId)) {\n                    $('old-price-' + this.config.productId).innerHTML = price;\n                }\n\n            }\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/configurable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'collapsible',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'domReady!'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        $block: null,\n        hasVariations: null,\n        configurationSectionMessageHandler: (function () {\n            var title = $('[data-role=\"product-create-configuration-info\"]'),\n                buttons = $('[data-action=\"product-create-configuration-buttons\"]'),\n                newText = 'Configurations cannot be created for a standard product with downloadable files.' +\n                ' To create configurations, first remove all downloadable files.',\n                oldText = title.text();\n\n            return function (change) {\n                if (change) {\n                    title.text(newText);\n                    buttons.hide();\n                } else {\n                    title.text(oldText);\n                    buttons.show();\n                }\n            };\n        }()),\n\n        /**\n         * Set element disabled\n         * @param {Object} $element - jquery instance element\n         * @param {Bool} state\n         * @param {Bool} triggerEvent\n         * @private\n         */\n        _setElementDisabled: function ($element, state, triggerEvent) {\n            if (!$element.is('[data-locked]')) {\n                $element.prop('disabled', state);\n\n                if (triggerEvent) {\n                    $element.trigger('change');\n                }\n            }\n        },\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.configurationSectionMessageHandler(false);\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.configurationSectionMessageHandler(true);\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('changeConfigurableTypeProduct', function (event, isConfigurable) {\n                $(document).trigger('setTypeProduct', isConfigurable ?\n                    'configurable' :\n                    productType.type.init === 'configurable' ? 'simple' : productType.type.init\n                );\n            });\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n\n            /*var suggestContainer = $('#product-template-suggest-container .action-dropdown > .action-toggle');\n\n\n            if (productType.type.current === 'configurable') {\n                this._setElementDisabled(suggestContainer.addClass('disabled'), true);\n                this._setElementDisabled($('#inventory_qty'), true);\n                this._setElementDisabled($('#inventory_stock_availability'), false);\n                this._setElementDisabled($('#qty'), true, true);\n                this._setElementDisabled($('#quantity_and_stock_status'), false, false);\n            } else {\n                this._setElementDisabled(suggestContainer.removeClass('disabled'), false);\n                this._setElementDisabled($('#inventory_qty'), false);\n                this._setElementDisabled($('#inventory_stock_availability'), true);\n                this._setElementDisabled($('#qty'), false, true);\n            }\n            */\n\n            /*if (['simple', 'virtual', 'configurable'].indexOf(productType.type.current) < 0) {\n                this.hide();\n            } else {\n                this.show();\n            }*/\n\n            this.show();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_ConfigurableProduct/js/configurable-type-handler': function (data) {\n            this.$block = $(data.blockId + ' input[name=\"attributes[]\"]');\n            this.hasVariations = data.hasVariations;\n\n            //advancedPricingHandler.init();\n            //priceTypeHandler.init();\n\n            /*if (productType.type.init === 'configurable' && !this.hasVariations) {\n                $(document).trigger('setTypeProduct', 'simple');\n            }*/\n            $(document).trigger('setTypeProduct', 'simple');\n\n            this.bindAll();\n            this._initType();\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/options/price-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'notification',\n    'mage/translate'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        isConfigurable: false,\n        messageInited: false,\n        messageSelector: '[data-role=product-custom-options-content]',\n        isPercentPriceTypeExist: function () {\n            var productOptionsContainer = $('#product_options_container_top');\n\n            return !!productOptionsContainer.length;\n        },\n        showWarning: function () {\n            if (!this.messageInited) {\n                $(this.messageSelector).notification();\n                this.messageInited = true;\n            }\n            this.hideWarning();\n            $(this.messageSelector).notification('add', {\n                message: $.mage.__('Custom options with price type \"percent\" is not available for ' +\n                    'configurable product.'),\n                error: false,\n                messageContainer: this.messageSelector\n            });\n        },\n        hideWarning: function () {\n            $(this.messageSelector).notification('clear');\n        },\n        init: function () {\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n\n            $('#product-edit-form-tabs').on('change', '.opt-type > select', function () {\n                var selected = $('.opt-type > select :selected'),\n                    optGroup = selected.parent().attr('label');\n\n                if (optGroup === 'Select') {\n                    $('#product-edit-form-tabs').on(\n                        'click',\n                        '[data-ui-id=\"admin-product-options-options-box-select-option-type-add-select-row-button\"]',\n                        function () {\n                            this.percentPriceTypeHandler();\n                        }.bind(this)\n                    );\n                } else {\n                    this.percentPriceTypeHandler();\n                }\n            }.bind(this));\n\n            this._initType();\n        },\n        _initType: function () {\n            this.isConfigurable = productType.type.current === 'configurable';\n            if (this.isPercentPriceTypeExist()) {\n                this.percentPriceTypeHandler();\n            }\n        },\n        percentPriceTypeHandler: function () {\n            var priceType = $('[data-attr=\"price-type\"]'),\n                optionPercentPriceType = priceType.find('option[value=\"percent\"]');\n\n            if (this.isConfigurable) {\n                this.showWarning();\n                optionPercentPriceType.hide();\n                optionPercentPriceType.parent().val() === 'percent' ? optionPercentPriceType.parent().val('fixed') : '';\n            } else {\n                $(this.messageSelector).notification();\n                optionPercentPriceType.show();\n                this.hideWarning();\n            }\n        }\n    };\n});\n*/\n","Magento_ConfigurableProduct/js/variations/product-grid.js":"// jscs:disable requireDotNotation\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'underscore',\n    'notification',\n    'mage/translate'\n], function (Component, $, bootstrap, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            productsGridUrl: null,\n            productAttributes: [],\n            productsModal: null,\n            button: '',\n            gridSelector: '[data-grid-id=associated-products-container]',\n            modules: {\n                productsFilter: '${ $.productsFilter }',\n                productsProvider: '${ $.productsProvider }',\n                productsMassAction: '${ $.productsMassAction }',\n                productsColumns: '${ $.productsColumns }',\n                variationsComponent: '${ $.configurableVariations }'\n            },\n            listens: {\n                '${ $.productsProvider }:data': '_showMessageAssociatedGrid _handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect',\n                '${ $.configurableVariations }:productMatrix': '_showButtonAddManual _switchProductType'\n            }\n        },\n\n        /**\n         * Initialize\n         *\n         * @param {Array} options\n         */\n        initialize: function (options) {\n            this._super(options);\n            this.productsModal = $(this.gridSelector).modal({\n                title: $.mage.__('Select Associated Product'),\n                type: 'slide',\n                buttons: [\n                    {\n                        text: $.mage.__('Cancel'),\n\n                        /** Close modal */\n                        click: function () {\n                            this.closeModal();\n                        }\n                    }, {\n                        text: $.mage.__('Done'),\n                        click: this.close.bind(this, null)\n                    }\n                ]\n            });\n\n            this.productsProvider(function () {\n                this.productsModal.notification();\n            }.bind(this));\n            this.variationsComponent(function (variation) {\n                this._showButtonAddManual(variation.productMatrix());\n            }.bind(this));\n\n            this._initGrid = _.once(this._initGrid);\n            this._switchProductType = _.wrap(this._switchProductType.bind(this), function (func, params) {\n                if (!!params.length !== !!this.init) {\n                    this.init = !!params.length;\n                    func(params);\n                }\n            }.bind(this._switchProductType));\n        },\n\n        /**\n         * Initial observerable\n         * @returns {*}\n         */\n        initObservable: function () {\n            this._super().observe('button');\n\n            return this;\n        },\n\n        /**\n         * init Grid\n         * @private\n         */\n        _initGrid: function (filterData) {\n            $.ajax({\n                type: 'GET',\n                url: this._buildGridUrl(filterData),\n                context: $('body')\n            }).done(function (data) {\n                bootstrap(JSON.parse(data));\n            });\n        },\n\n        /**\n         * Select different product in configurations section\n         * @see configurable_associated_product_listing.xml\n         * @param {Integer} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.close(rowIndex);\n        },\n\n        /**\n         * Open\n         * @param {Object} filterData - filter data\n         * @param {Object|*} filterData.filters - attribute name\n         * @param {Object|*} filterData.filters_modifier - modifier value\n         * @param {String} callbackName\n         * @param {Boolean} showMassActionColumn\n         */\n        open: function (filterData, callbackName, showMassActionColumn) {\n            this.callbackName = callbackName;\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = showMassActionColumn;\n                });\n                massActionComponent.visible = showMassActionColumn;\n            }.bind(this));\n            this._setFilter(filterData);\n            this._initGrid(filterData);\n            this.productsModal.trigger('openModal');\n        },\n\n        /**\n         * Close\n         */\n        close: function (rowIndex) {\n            try {\n                if (this.productsMassAction().selected.getLength()) {\n                    this.variationsComponent()[this.callbackName](this.productsMassAction()\n                        .selected.map(this.getProductById.bind(this)));\n                    this.productsMassAction().deselectAll();\n                } else if (!_.isNull(rowIndex)) {\n                    this.variationsComponent()[this.callbackName]([this.getProductByIndex(rowIndex)]);\n                }\n                this.productsModal.trigger('closeModal');\n            } catch (e) {\n                if (e.name === 'UserException') {\n                    this.productsModal.notification('clear');\n                    this.productsModal.notification('add', {\n                        message: e.message,\n                        messageContainer: this.gridSelector\n                    });\n                } else {\n                    throw e;\n                }\n            }\n        },\n\n        /**\n         * Get product by id\n         * @param {Integer} productId\n         * @returns {*}\n         */\n        getProductById: function (productId) {\n            return _.findWhere(this.productsProvider().data.items, {\n                'entity_id': productId\n            });\n        },\n\n        /**\n         * Get product\n         * @param {Integer} rowIndex\n         * @returns {*}\n         */\n        getProductByIndex: function (rowIndex) {\n            return this.productsProvider().data.items[rowIndex];\n        },\n\n        /**\n         * Build grid url\n         * @private\n         */\n        _buildGridUrl: function (filterData) {\n            var params = '?' + $.param({\n                'filters': filterData.filters,\n                'attributes_codes': this._getAttributesCodes(),\n                'filters_modifier': filterData['filters_modifier']\n            });\n\n            return this.productsGridUrl + params;\n        },\n\n        /**\n         * Show button add manual\n         * @param {Array} variations\n         * @returns {*}\n         * @private\n         */\n        _showButtonAddManual: function (variations) {\n            return this.button(variations.length);\n        },\n\n        /**\n         * @param {Array} variations\n         * @private\n         */\n        _switchProductType: function (variations) {\n            $(document).trigger('changeConfigurableTypeProduct', variations.length);\n        },\n\n        /**\n         * Get attributes codes used for configurable\n         * @private\n         */\n        _getAttributesCodes: function () {\n            return this.variationsComponent().attributes.pluck('code');\n        },\n\n        /**\n         * Show data associated grid\n         * @private\n         */\n        _showMessageAssociatedGrid: function (data) {\n            this.productsModal.notification('clear');\n\n            if (data.items.length) {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('Choose a new product to delete and replace the current product configuration.'),\n                    messageContainer: this.gridSelector\n                });\n            } else {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('For better results, add attributes and attribute values to your products.'),\n                    messageContainer: this.gridSelector\n                });\n            }\n        },\n\n        /**\n         * Show manually grid\n         */\n        showManuallyGrid: function () {\n            var filterModifier = _.mapObject(_.object(this._getAttributesCodes(), []), function () {\n                    return {\n                        'condition_type': 'notnull'\n                    };\n                }),\n                usedProductIds = _.values(this.variationsComponent().productAttributesMap);\n\n            if (usedProductIds && usedProductIds.length > 0) {\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n            }\n\n            this.open(\n                {\n                    'filters_modifier': filterModifier\n                },\n                'appendProducts',\n                true\n            );\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                        selectedVariationKeys,\n                        _.pluck(this.variationsComponent().productMatrix(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows, selectedVariationKeys;\n\n            if (this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Object} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            this._variationKeyMap = {};\n\n            _.each(items, function (row) {\n                this._variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return this._variationKeyMap;\n        },\n\n        /**\n         * Set filter\n         * @private\n         */\n        _setFilter: function (filterData) {\n            this.productsProvider(function (provider) {\n                provider.params['filters_modifier'] = filterData['filters_modifier'];\n                provider.params['attributes_codes'] = this._getAttributesCodes();\n            }.bind(this));\n\n            this.productsFilter(function (filter) {\n                filter.set('filters', _.extend({\n                    'filters_modifier': filterData['filters_modifier']\n                }, filterData.filters))\n                    .apply();\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/variations.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'uiRegistry',\n    'mage/translate'\n], function (Component, $, ko, _, alert, registry, $t) {\n    'use strict';\n\n    /**\n     * @param {*} message\n     * @constructor\n     */\n    function UserException(message) {\n        this.message = message;\n        this.name = 'UserException';\n    }\n    UserException.prototype = Object.create(Error.prototype);\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            attributes: [],\n            usedAttributes: [],\n            attributeCodes: [],\n            attributesData: {},\n            productMatrix: [],\n            variations: [],\n            formSaveParams: [],\n            productAttributes: [],\n            disabledAttributes: [],\n            fullAttributes: [],\n            rowIndexToEdit: false,\n            productAttributesMap: null,\n            value: [],\n            modules: {\n                associatedProductGrid: '${ $.configurableProductGrid }',\n                wizardButtonElement: '${ $.wizardModalButtonName }',\n                formElement: '${ $.formName }',\n                attributeSetHandlerModal: '${ $.attributeSetHandler }'\n            },\n            imports: {\n                attributeSetName: '${ $.provider }:configurableNewAttributeSetName',\n                attributeSetId: '${ $.provider }:configurableExistingAttributeSetId',\n                attributeSetSelection: '${ $.provider }:configurableAffectedAttributeSet',\n                productPrice: '${ $.provider }:data.product.price'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScopeVariations }',\n                usedAttributes: '${ $.provider }:${ $.dataScopeAttributes }',\n                attributesData: '${ $.provider }:${ $.dataScopeAttributesData }',\n                attributeCodes: '${ $.provider }:${ $.dataScopeAttributeCodes }',\n                skeletonAttributeSet: '${ $.provider }:data.new-variations-attribute-set-id'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.changeButtonWizard();\n            this.initProductAttributesMap();\n            this.disableConfigurableAttributes(this.productAttributes);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(\n                'actions opened attributes productMatrix value usedAttributes attributesData attributeCodes'\n            );\n\n            return this;\n        },\n\n        /**\n         * @param {Object} product\n         * @return {Object}\n         * @private\n         */\n        _makeProduct: function (product) {\n            var productId = product['entity_id'] || product.productId || null,\n                attributes = _.pick(product, this.attributes.pluck('code')),\n                options = _.map(attributes, function (option, attribute) {\n                    var oldOptions = _.findWhere(this.attributes(), {\n                            code: attribute\n                        }).options,\n                        result;\n\n                    if (_.isFunction(oldOptions)) {\n                        result = oldOptions.findWhere({\n                            value: option\n                        });\n                    } else {\n                        result = _.findWhere(oldOptions, {\n                            value: option\n                        });\n                    }\n\n                    return result;\n                }.bind(this));\n\n            return {\n                attribute: JSON.stringify(attributes),\n                editable: false,\n                images: {\n                    preview: product['thumbnail_src']\n                },\n                name: product.name || product.sku,\n                options: options,\n                price: parseFloat(Math.round(product.price.replace(/[^\\d.]+/g, '') + 'e+4') + 'e-4').toFixed(4),\n                productId: productId,\n                productUrl: this.buildProductUrl(productId),\n                quantity: product.quantity || null,\n                sku: product.sku,\n                status: product.status === undefined ? 1 : parseInt(product.status, 10),\n                variationKey: this.getVariationKey(options),\n                weight: product.weight || null\n            };\n        },\n\n        /**\n         * @param {String} name\n         * @return {String|Number|Array}\n         */\n        getProductValue: function (name) {\n            var value;\n\n            name = name.split('/').join('][');\n            value = $('[name=\"product[' + name + ']\"]:enabled:not(.ignore-validate)', this.productForm).val();\n            if (value === undefined) {\n                value = this.source.get('data.product.' + name);\n            }\n            return value;\n        },\n\n        /**\n         * @param {Object} data\n         * @param {String} field\n         * @return {String}\n         */\n        getRowId: function (data, field) {\n            var key = data.variationKey;\n\n            return 'variations-matrix-' + key + '-' + field;\n        },\n\n        /**\n         * @param {Object} variation\n         * @param {String} field\n         * @return {String}\n         */\n        getVariationRowName: function (variation, field) {\n            var result;\n\n            if (variation.productId) {\n                result = 'configurations[' + variation.productId + '][' + field.split('/').join('][') + ']';\n            } else {\n                result = 'variations-matrix[' + variation.variationKey + '][' + field.split('/').join('][') + ']';\n            }\n\n            return result;\n        },\n\n        /**\n         * @param {*} variations\n         * @param {*} attributes\n         */\n        render: function (variations, attributes) {\n            this.changeButtonWizard();\n            this.populateVariationMatrix(variations);\n            this.attributes(attributes);\n            this.disableConfigurableAttributes(attributes);\n            this.handleValue(variations);\n            this.handleAttributes();\n        },\n\n        /**\n         * Change button wizard.\n         */\n        changeButtonWizard: function () {\n            if (this.variations.length) {\n                this.wizardButtonElement().title(this.wizardModalButtonTitle);\n            }\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        handleValue: function (variations) {\n            var tmpArray = [];\n\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {}),\n                    gallery = {\n                        images: {}\n                    },\n                    types = {};\n\n                _.each(variation.images.images, function (image) {\n                    gallery.images[image['file_id']] = {\n                        position: image.position,\n                        file: image.file,\n                        disabled: image.disabled,\n                        label: image.label || ''\n                    };\n                    _.each(image.galleryTypes, function (type) {\n                        types[type] = image.file;\n                    });\n                }, this);\n\n                tmpArray.push(_.extend(variation, types, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    priceCurrency: this.currencySymbol,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? 0 : 1,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10),\n                    newProduct: variation.productId ? 0 : 1,\n                    'media_gallery': gallery\n                }));\n            }, this);\n\n            this.value(tmpArray);\n        },\n\n        /**\n         * Handle attributes.\n         */\n        handleAttributes: function () {\n            var tmpArray = [],\n                codesArray = [],\n                tmpOptions = {},\n                option = {},\n                position = 0,\n                values = {};\n\n            _.each(this.attributes(), function (attribute) {\n                tmpArray.push(attribute.id);\n                codesArray.push(attribute.code);\n                values = {};\n                _.each(attribute.chosen, function (row) {\n                    values[row.value] = {\n                        'include': '1',\n                        'value_index': row.value\n                    };\n                }, this);\n                option = {\n                    'attribute_id': attribute.id,\n                    'code': attribute.code,\n                    'label': attribute.label,\n                    'position': position,\n                    'values': values\n                };\n                tmpOptions[attribute.id] = option;\n                position++;\n            }, this);\n\n            this.attributesData(tmpOptions);\n            this.usedAttributes(tmpArray);\n            this.attributeCodes(codesArray);\n        },\n\n        /**\n         * Get attributes options\n         * @see use in matrix.phtml\n         *\n         * @returns {Array}\n         */\n        getAttributesOptions: function () {\n            return this.showVariations() ? this.productMatrix()[0].options : [];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        showVariations: function () {\n            return this.productMatrix().length > 0;\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        populateVariationMatrix: function (variations) {\n            this.productMatrix([]);\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {});\n\n                this.productMatrix.push(_.extend(variation, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? !variation.productId : variation.editable,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10)\n                }));\n            }, this);\n        },\n\n        /**\n         * @param {*} productId\n         */\n        buildProductUrl: function (productId) {\n            return this.productUrl.replace('%id%', productId);\n        },\n\n        /**\n         * @param {Object} options\n         * @return {String}\n         */\n        getVariationKey: function (options) {\n            return _.pluck(options, 'value').sort().join('-');\n        },\n\n        /**\n         * @param {*} options\n         * @return {*|null}\n         */\n        getProductIdByOptions: function (options) {\n            return this.productAttributesMap[this.getVariationKey(options)] || null;\n        },\n\n        /**\n         * Init product attributes map\n         */\n        initProductAttributesMap: function () {\n            if (this.productAttributesMap === null) {\n                this.productAttributesMap = {};\n                _.each(this.variations, function (product) {\n                    this.productAttributesMap[this.getVariationKey(product.options)] = product.productId;\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Array} attributes\n         */\n        disableConfigurableAttributes: function (attributes) {\n            var element;\n\n            _.each(this.disabledAttributes, function (attribute) {\n                registry.get('inputName = ' + 'product[' + attribute + ']').disabled(false);\n            });\n            this.disabledAttributes = [];\n\n            _.each(attributes, function (attribute) {\n                element = registry.get('inputName = ' + 'product[' + attribute.code + ']');\n\n                if (!_.isUndefined(element)) {\n                    element.disabled(true);\n                    this.disabledAttributes.push(attribute.code);\n                }\n            }, this);\n        },\n\n        /**\n         * Get currency symbol\n         * @returns {String}\n         */\n        getCurrencySymbol: function () {\n            return this.currencySymbol;\n        },\n\n        /**\n         * Chose action for the form save button\n         */\n        saveFormHandler: function () {\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                this.serializeData();\n            }\n\n            if (this.checkForNewAttributes()) {\n                this.formSaveParams = arguments;\n                this.attributeSetHandlerModal().openModal();\n            } else {\n                if (this.validateForm(this.formElement())) {\n                    this.clearOutdatedData();\n                }\n                this.formElement().save(arguments[0], arguments[1]);\n\n                if (this.formElement().source.get('params.invalid')) {\n                    this.unserializeData();\n                }\n            }\n        },\n\n        /**\n         * @param {Object} formElement\n         *\n         * Validates each form element and returns true, if all elements are valid.\n         */\n        validateForm: function (formElement) {\n            formElement.validate();\n\n            return !formElement.additionalInvalid && !formElement.source.get('params.invalid');\n        },\n\n        /**\n         * Serialize data for specific form fields\n         *\n         * Serializes some complex data fields\n         *\n         * Original fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         *\n         * Serialized fields in request:\n         *   - configurable-matrix-serialized;\n         *   - associated_product_ids_serialized.\n         */\n        serializeData: function () {\n            if (this.source.data['configurable-matrix']) {\n                this.source.data['configurable-matrix-serialized'] =\n                    JSON.stringify(this.source.data['configurable-matrix']);\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                this.source.data['associated_product_ids_serialized'] =\n                    JSON.stringify(this.source.data['associated_product_ids']);\n            }\n        },\n\n        /**\n         * Clear outdated data for specific form fields\n         *\n         * Outdated fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         */\n        clearOutdatedData: function () {\n            if (this.source.data['configurable-matrix']) {\n                delete this.source.data['configurable-matrix'];\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                delete this.source.data['associated_product_ids'];\n            }\n        },\n\n        /**\n         * Unserialize data for specific form fields\n         *\n         * Unserializes some fields that were serialized this.serializeData\n         */\n        unserializeData: function () {\n            if (this.source.data['configurable-matrix-serialized']) {\n                this.source.data['configurable-matrix'] =\n                    JSON.parse(this.source.data['configurable-matrix-serialized']);\n                delete this.source.data['configurable-matrix-serialized'];\n            }\n\n            if (this.source.data['associated_product_ids_serialized']) {\n                this.source.data['associated_product_ids'] =\n                    JSON.parse(this.source.data['associated_product_ids_serialized']);\n                delete this.source.data['associated_product_ids_serialized'];\n            }\n        },\n\n        /**\n         * Check for newly added attributes\n         * @returns {Boolean}\n         */\n        checkForNewAttributes: function () {\n            var element, newAttributes = false;\n\n            _.each(this.source.get('data.attribute_codes'), function (attribute) {\n                element = registry.get('index = ' + attribute);\n\n                if (_.isUndefined(element)) {\n                    newAttributes = true;\n                }\n            }, this);\n\n            return newAttributes;\n        },\n\n        /**\n         * New attributes handler\n         * @returns {Boolean}\n         */\n        addNewAttributeSetHandler: function () {\n            var chosenAttributeSetOption;\n\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                chosenAttributeSetOption = this.attributeSetSelection;\n\n                if (chosenAttributeSetOption === 'new') {\n                    this.createNewAttributeSet();\n\n                    return false;\n                }\n\n                if (chosenAttributeSetOption === 'existing') {\n                    this.set(\n                        'skeletonAttributeSet',\n                        this.attributeSetId\n                    );\n                }\n\n                this.closeDialogAndProcessForm();\n\n                return true;\n            }\n\n            this.unserializeData();\n\n            return false;\n        },\n\n        /**\n         * Handles new attribute set creation\n         * @returns {Boolean}\n         */\n        createNewAttributeSet: function () {\n            var messageBoxElement = registry.get('index = affectedAttributeSetError');\n\n            messageBoxElement.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.attributeSetCreationUrl,\n                data: {\n                    gotoEdit: 1,\n                    'attribute_set_name': this.attributeSetName,\n                    'skeleton_set': this.skeletonAttributeSet,\n                    'return_session_messages_only': 1\n                },\n                dataType: 'json',\n                showLoader: true,\n                context: this\n            }).done(function (data) {\n                if (!data.error) {\n                    this.set(\n                        'skeletonAttributeSet',\n                        data.id\n                    );\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                    this.closeDialogAndProcessForm();\n                } else {\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                }\n\n                return false;\n            }).fail(function (xhr) {\n                if (xhr.statusText === 'abort') {\n                    return;\n                }\n\n                alert({\n                    content: $t('Something went wrong.')\n                });\n            });\n\n            return false;\n        },\n\n        /**\n         * Closes attribute set handler modal and process product form\n         */\n        closeDialogAndProcessForm: function () {\n            this.attributeSetHandlerModal().closeModal();\n            this.formElement().save(this.formSaveParams[0], this.formSaveParams[1]);\n        },\n\n        /**\n         * Retrieves product price\n         * @returns {*}\n         */\n        getProductPrice: function () {\n            return this.productPrice;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes'\n], function (Sizes) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            options: {\n                '20': {\n                    value: 20,\n                    label: 20\n                },\n                '30': {\n                    value: 30,\n                    label: 30\n                },\n                '50': {\n                    value: 50,\n                    label: 50\n                }\n            },\n            value: 20\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\n\n/* global FORM_KEY, byteConvert */\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Catalog/js/product-gallery',\n    'jquery/uppy-core',\n    'mage/translate',\n    'Magento_ConfigurableProduct/js/variations/variations'\n], function (Component, $, ko, _, Collapsible, mageTemplate, alert) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }'\n            },\n            countVariations: 0,\n            attributes: [],\n            sections: {},\n            images: null,\n            price: '',\n            quantity: '',\n            notificationMessage: {\n                text: null,\n                error: null\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe('countVariations attributes sections');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n            this.sections({\n                images: {\n                    label: 'images',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                },\n                price: {\n                    label: 'price',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable(),\n                    currencySymbol: ''\n                },\n                quantity: {\n                    label: 'quantity',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                }\n            });\n\n            this.variationsComponent(function (variationsComponent) {\n                this.sections().price.currencySymbol = variationsComponent.getCurrencySymbol();\n            }.bind(this));\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantity: this.quantity\n                };\n            }.bind(this);\n\n            /**\n             * @param {Object} images\n             * @param {*} typePreview\n             */\n            this.makeImages = function (images, typePreview) {\n                var preview;\n\n                if (!images) {\n                    this.images = [];\n                    this.preview = self.noImage;\n                    this.file = null;\n                } else {\n                    this.images = images;\n                    preview = _.find(this.images, function (image) {\n                        return _.contains(image.galleryTypes, typePreview);\n                    });\n\n                    if (preview) {\n                        this.file = preview.file;\n                        this.preview = preview.url;\n                    } else {\n                        this.file = null;\n                        this.preview = self.noImage;\n                    }\n                }\n            };\n            this.images = new this.makeImages();\n            _.each(this.sections(), function (section) {\n                section.type.subscribe(function () {\n                    this.setWizardNotifyMessageDependOnSectionType();\n                }.bind(this));\n            }, this);\n        },\n        types: ['each', 'single', 'none'],\n\n        /**\n         * Set Wizard notify message depend on section type\n         */\n        setWizardNotifyMessageDependOnSectionType: function () {\n            var flag = false;\n\n            _.each(this.sections(), function (section) {\n                if (section.type() !== 'none') {\n                    flag = true;\n                }\n            }, this);\n\n            if (flag) {\n                this.wizard.setNotificationMessage(\n                    $.mage.__('Choose this option to delete and replace extension data for all past configurations.')\n                );\n            } else {\n                this.wizard.cleanNotificationMessage();\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.attributes(wizard.data.attributes());\n\n            if (this.mode === 'edit') {\n                this.setWizardNotifyMessageDependOnSectionType();\n            }\n            //fill option section data\n            this.attributes.each(function (attribute) {\n                attribute.chosen.each(function (option) {\n                    option.sections = ko.observable(this.makeOptionSections());\n                }, this);\n            }, this);\n            //reset section.attribute\n            _.each(this.sections(), function (section) {\n                section.attribute(null);\n            });\n\n            this.initCountVariations();\n            this.bindGalleries();\n        },\n\n        /**\n         * Init count variations.\n         */\n        initCountVariations: function () {\n            var variations = this.generateVariation(this.attributes()),\n                newVariations = _.map(variations, function (options) {\n                    return this.variationsComponent().getVariationKey(options);\n                }.bind(this)),\n                existingVariations = _.keys(this.variationsComponent().productAttributesMap);\n\n            this.countVariations(_.difference(newVariations, existingVariations).length);\n        },\n\n        /**\n         * @param {Object} attributes - example [['b1', 'b2'],['a1', 'a2', 'a3'],['c1', 'c2', 'c3'],['d1']]\n         * @returns {*} example [['b1','a1','c1','d1'],['b1','a1','c2','d1']...]\n         */\n        generateVariation: function (attributes) {\n            return _.reduce(attributes, function (matrix, attribute) {\n                var tmp = [];\n\n                _.each(matrix, function (variations) {\n                    _.each(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n                        tmp.push(_.union(variations, [option]));\n                    });\n                });\n\n                if (!tmp.length) {\n                    return _.map(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n\n                        return [option];\n                    });\n                }\n\n                return tmp;\n            }, []);\n        },\n\n        /**\n         * @param {*} section\n         * @param {Object} options\n         * @return {*}\n         */\n        getSectionValue: function (section, options) {\n            switch (this.sections()[section].type()) {\n            case 'each':\n                return _.find(this.sections()[section].attribute().chosen, function (chosen) {\n                    return _.find(options, function (option) {\n                        return chosen.id == option.id; //eslint-disable-line eqeqeq\n                    });\n                }).sections()[section];\n\n            case 'single':\n                return this.sections()[section].value();\n\n            case 'none':\n                return this[section];\n            }\n        },\n\n        /**\n         * @param {*} node\n         * @return {Promise|*}\n         */\n        getImageProperty: function (node) {\n            var types = node.find('[data-role=gallery]').productGallery('option').types,\n                images = _.map(node.find('[data-role=image]'), function (image) {\n                    var imageData = $(image).data('imageData'),\n                        positionElement;\n\n                    imageData.galleryTypes = _.pluck(_.filter(types, function (type) {\n                        return type.value === imageData.file;\n                    }), 'code');\n\n                    //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    positionElement =\n                        $(image).find('[name=\"product[media_gallery][images][' + imageData.file_id + '][position]\"]');\n                    //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    if (!_.isEmpty(positionElement.val())) {\n                        imageData.position = positionElement.val();\n                    }\n\n                    return imageData;\n                });\n\n            return _.reject(images, function (image) {\n                return !!image.isRemoved;\n            });\n        },\n\n        /**\n         * Fill images section.\n         */\n        fillImagesSection: function () {\n            switch (this.sections().images.type()) {\n            case 'each':\n                if (this.sections().images.attribute()) {\n                    this.sections().images.attribute().chosen.each(function (option) {\n                        option.sections().images = new this.makeImages(\n                            this.getImageProperty($('[data-role=step-gallery-option-' + option.id + ']')),\n                            'thumbnail'\n                        );\n                    }, this);\n                }\n                break;\n\n            case 'single':\n                this.sections().images.value(new this.makeImages(\n                    this.getImageProperty($('[data-role=step-gallery-single]')),\n                    'thumbnail'\n                ));\n                break;\n\n            default:\n                this.sections().images.value(new this.makeImages());\n                break;\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.fillImagesSection();\n            this.validate();\n            this.validateImage();\n            wizard.data.sections = this.sections;\n            wizard.data.sectionHelper = this.getSectionValue.bind(this);\n            wizard.data.variations = this.generateVariation(this.attributes());\n        },\n\n        /**\n         * Validate.\n         */\n        validate: function () {\n            var formValid;\n\n            _.each(this.sections(), function (section) {\n                switch (section.type()) {\n                case 'each':\n                    if (!section.attribute()) {\n                        throw new Error($.mage.__('Please select attribute for {section} section.')\n                            .replace('{section}', section.label));\n                    }\n                    break;\n\n                case 'single':\n                    if (!section.value()) {\n                        throw new Error($.mage.__('Please fill in the values for {section} section.')\n                            .replace('{section}', section.label));\n                    }\n                    break;\n                }\n            }, this);\n            formValid = true;\n            _.each($('[data-role=attributes-values-form]'), function (form) {\n                formValid = $(form).valid() && formValid;\n            });\n\n            if (!formValid) {\n                throw new Error($.mage.__('Please fill-in correct values.'));\n            }\n        },\n\n        /**\n         * Validate image.\n         */\n        validateImage: function () {\n            switch (this.sections().images.type()) {\n            case 'each':\n                _.each(this.sections().images.attribute().chosen, function (option) {\n                    if (!option.sections().images.images.length) {\n                        throw new Error($.mage.__('Please select image(s) for your attribute.'));\n                    }\n                });\n                break;\n\n            case 'single':\n                if (this.sections().images.value().file == null) {\n                    throw new Error($.mage.__('Please choose image(s).'));\n                }\n                break;\n            }\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n            this.setWizardNotifyMessageDependOnSectionType();\n        },\n\n        /**\n         * Bind galleries.\n         */\n        bindGalleries: function () {\n            $('[data-role=bulk-step] [data-role=gallery]').each(function (index, element) {\n                var gallery = $(element),\n                    uploadInput = $(gallery.find('.uploader'))[0],\n                    uploadUrl = $(gallery.find('.browse-file')).attr('data-url'),\n                    dropZone = $(gallery).find('.image-placeholder')[0];\n\n                if (!gallery.data('gallery-initialized')) {\n                    gallery.mage('productGallery', {\n                        template: '[data-template=gallery-content]',\n                        dialogTemplate: '.dialog-template',\n                        dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n                    });\n\n                    // uppy implementation\n                    let targetElement = uploadInput,\n                        fileId = null,\n                        arrayFromObj = Array.from,\n                        options = {\n                            proudlyDisplayPoweredByUppy: false,\n                            target: targetElement,\n                            hideUploadButton: true,\n                            hideRetryButton: true,\n                            hideCancelButton: true,\n                            inline: true,\n                            debug:true,\n                            showRemoveButtonAfterComplete: true,\n                            showProgressDetails: false,\n                            showSelectedFiles: false,\n                            allowMultipleUploads: false,\n                            hideProgressAfterFinish: true\n                        };\n\n                    gallery.find('.product-image-wrapper').on('click', function () {\n                        gallery.find('.uppy-Dashboard-browse').trigger('click');\n                    });\n\n                    const uppy = new Uppy.Uppy({\n                        autoProceed: true,\n\n                        onBeforeFileAdded: (currentFile) => {\n                            let progressTmpl = mageTemplate('[data-template=uploader]'),\n                                fileSize,\n                                tmpl;\n\n                            fileSize = typeof currentFile.size == 'undefined' ?\n                                $.mage.__('We could not detect a size.') :\n                                byteConvert(currentFile.size);\n\n                            fileId = Math.random().toString(33).substr(2, 18);\n\n                            tmpl = progressTmpl({\n                                data: {\n                                    name: currentFile.name,\n                                    size: fileSize,\n                                    id: fileId\n                                }\n                            });\n\n                            // code to allow duplicate files from same folder\n                            const modifiedFile = {\n                                ...currentFile,\n                                id:  currentFile.id + '-' + fileId,\n                                tempFileId:  fileId\n                            };\n\n                            $(tmpl).appendTo(gallery.find('[data-role=uploader]'));\n                            return modifiedFile;\n                        },\n\n                        meta: {\n                            'form_key': FORM_KEY\n                        }\n                    });\n\n                    // initialize Uppy upload\n                    uppy.use(Uppy.Dashboard, options);\n\n                    // drop area for file upload\n                    uppy.use(Uppy.DropTarget, {\n                        target: dropZone,\n                        onDragOver: () => {\n                            // override Array.from method of legacy-build.min.js file\n                            Array.from = null;\n                        },\n                        onDragLeave: () => {\n                            Array.from = arrayFromObj;\n                        }\n                    });\n\n                    // upload files on server\n                    uppy.use(Uppy.XHRUpload, {\n                        endpoint: uploadUrl,\n                        fieldName: 'image'\n                    });\n\n                    uppy.on('upload-success', (file, response) => {\n                        if (response.body && !response.body.error) {\n                            gallery.trigger('addItem', response.body);\n                        } else {\n                            $('#' + file.tempFileId)\n                                .delay(2000)\n                                .hide('highlight');\n                            alert({\n                                content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                            });\n                        }\n                        $('#' + file.tempFileId).remove();\n                    });\n\n                    uppy.on('upload-progress', (file, progress) => {\n                        let progressWidth = parseInt(progress.bytesUploaded / progress.bytesTotal * 100, 10),\n                            progressSelector = '#' + file.tempFileId + ' .progressbar-container .progressbar';\n\n                        $(progressSelector).css('width', progressWidth + '%');\n                    });\n\n                    uppy.on('upload-error', (error, file) => {\n                        let progressSelector = '#' + file.tempFileId;\n\n                        $(progressSelector).removeClass('upload-progress').addClass('upload-failure')\n                            .delay(2000)\n                            .hide('highlight')\n                            .remove();\n                    });\n\n                    uppy.on('complete', () => {\n                        Array.from = arrayFromObj;\n                    });\n\n                    gallery.data('gallery-initialized', 1);\n                }\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/select_attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'mage/translate'\n], function (Component, $, _) {\n    'use strict';\n\n    /**\n     * @param {Function} provider\n     */\n    var initNewAttributeListener = function (provider) {\n        $('[data-role=product-variations-matrix]').on('add', function () {\n            provider().reload();\n        });\n    };\n\n    return Component.extend({\n        attributesLabels: {},\n        stepInitialized: false,\n        defaults: {\n            modules: {\n                multiselect: '${ $.multiselectName }',\n                attributeProvider: '${ $.providerName }'\n            },\n            listens: {\n                '${ $.multiselectName }:selected': 'doSelectedAttributesLabels',\n                '${ $.multiselectName }:rows': 'doSelectSavedAttributes'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            selectedAttributes: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selected = [];\n\n            initNewAttributeListener(this.attributeProvider);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['selectedAttributes']);\n\n            return this;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Set notification message.\n         */\n        setNotificationMessage: function () {\n            /*eslint-disable max-len*/\n            var msg = $.mage.__('When you remove or add an attribute, we automatically update all configurations and you will need to recreate current configurations manually.');\n\n            /*eslint-enable max-len*/\n\n            if (this.mode === 'edit') {\n                this.wizard.setNotificationMessage(msg);\n            }\n        },\n\n        /**\n         * Do select saved attributes.\n         */\n        doSelectSavedAttributes: function () {\n            if (this.stepInitialized === false) {\n                this.stepInitialized = true;\n                //cache attributes labels, which can be present on the 2nd page\n                _.each(this.initData.attributes, function (attribute) {\n                    this.attributesLabels[attribute.id] = attribute.label;\n                }.bind(this));\n                this.multiselect().selected(_.pluck(this.initData.attributes, 'id'));\n            }\n        },\n\n        /**\n         * @param {*} selected\n         */\n        doSelectedAttributesLabels: function (selected) {\n            var labels = [];\n\n            this.selected = selected;\n            _.each(selected, function (attributeId) {\n                var attribute;\n\n                if (!this.attributesLabels[attributeId]) {\n                    attribute = _.findWhere(this.multiselect().rows(), {\n                        'attribute_id': attributeId\n                    });\n\n                    if (attribute) {\n                        this.attributesLabels[attribute['attribute_id']] = attribute['frontend_label'];\n                    }\n                }\n                labels.push(this.attributesLabels[attributeId]);\n            }.bind(this));\n            this.selectedAttributes(labels.join(', '));\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            wizard.data.attributesIds = this.multiselect().selected;\n\n            if (!wizard.data.attributesIds() || wizard.data.attributesIds().length === 0) {\n                throw new Error($.mage.__('Please select attribute(s).'));\n            }\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/attributes_values.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/translate'\n], function (Component, $, ko, _, utils, Collapsible) {\n    'use strict';\n\n    //connect items with observableArrays\n    ko.bindingHandlers.sortableList = {\n        /** @inheritdoc */\n        init: function (element, valueAccessor) {\n            var list = valueAccessor();\n\n            $(element).sortable({\n                axis: 'y',\n                handle: '[data-role=\"draggable\"]',\n                tolerance: 'pointer',\n\n                /** @inheritdoc */\n                update: function (event, ui) {\n                    var item = ko.contextFor(ui.item[0]).$data,\n                        position = ko.utils.arrayIndexOf(ui.item.parent().children(), ui.item[0]);\n\n                    if (ko.contextFor(ui.item[0]).$index() != position) { //eslint-disable-line eqeqeq\n                        if (position >= 0) {\n                            list.remove(item);\n                            list.splice(position, 0, item);\n                        }\n                        ui.item.remove();\n                    }\n                }\n            });\n        }\n    };\n\n    return Collapsible.extend({\n        defaults: {\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            createOptionsUrl: null,\n            attributes: [],\n            stepInitialized: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.createAttribute = _.wrap(this.createAttribute, function () {\n                var args = _.toArray(arguments),\n                    createAttribute = args.shift();\n\n                return this.doInitSavedOptions(createAttribute.apply(this, args));\n            });\n            this.createAttribute = _.memoize(this.createAttribute.bind(this), _.property('id'));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['attributes']);\n\n            return this;\n        },\n\n        /**\n         * Create option.\n         */\n        createOption: function () {\n            // this - current attribute\n            this.options.push({\n                value: 0,\n                label: '',\n                id: utils.uniqueid(),\n                'attribute_id': this.id,\n                'is_new': true\n            });\n        },\n\n        /**\n         * @param {Object} option\n         */\n        saveOption: function (option) {\n            if (this.isValidOption(option)) {\n                this.options.remove(option);\n                this.options.push(option);\n                this.chosenOptions.push(option.id);\n            }\n        },\n\n        /**\n         * @param {Object} newOption\n         * @return boolean\n         */\n        isValidOption: function (newOption) {\n            var duplicatedOptions = [],\n                errorOption,\n                allOptions = [];\n\n            newOption.label = newOption.label.trim();\n\n            if (_.isEmpty(newOption.label)) {\n                return false;\n            }\n\n            _.each(this.options(), function (option) {\n                if (!_.isUndefined(allOptions[option.label]) && newOption.label === option.label) {\n                    duplicatedOptions.push(option);\n                }\n\n                allOptions[option.label] = option.label;\n            });\n\n            if (duplicatedOptions.length) {\n                _.each(duplicatedOptions, function (duplicatedOption) {\n                    errorOption = $('[data-role=\"' + duplicatedOption.id + '\"]');\n                    errorOption.addClass('_error');\n                });\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * @param {Object} option\n         */\n        removeOption: function (option) {\n            this.options.remove(option);\n        },\n\n        /**\n         * @param {String} attribute\n         */\n        removeAttribute: function (attribute) {\n            this.attributes.remove(attribute);\n            this.wizard.setNotificationMessage(\n                $.mage.__('An attribute has been removed. This attribute will no longer appear in your configurations.')\n            );\n        },\n\n        /**\n         * @param {Object} attribute\n         * @param {*} index\n         * @return {Object}\n         */\n        createAttribute: function (attribute, index) {\n            attribute.chosenOptions = ko.observableArray([]);\n            attribute.options = ko.observableArray(_.map(attribute.options, function (option) {\n                option.id = utils.uniqueid();\n\n                return option;\n            }));\n            attribute.opened = ko.observable(this.initialOpened(index));\n            attribute.collapsible = ko.observable(true);\n            attribute.isValidOption = this.isValidOption;\n\n            return attribute;\n        },\n\n        /**\n         * First 3 attribute panels must be open.\n         *\n         * @param {Number} index\n         * @return {Boolean}\n         */\n        initialOpened: function (index) {\n            return index < 3;\n        },\n\n        /**\n         * Save attribute.\n         */\n        saveAttribute: function () {\n            var errorMessage = $.mage.__('Select options for all attributes or remove unused attributes.');\n\n            if (!this.attributes().length) {\n                throw new Error(errorMessage);\n            }\n\n            _.each(this.attributes(), function (attribute) {\n                attribute.chosen = [];\n\n                if (!attribute.chosenOptions.getLength()) {\n                    throw new Error(errorMessage);\n                }\n                _.each(attribute.chosenOptions(), function (id) {\n                    attribute.chosen.push(attribute.options.findWhere({\n                        id: id\n                    }));\n                });\n            });\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        selectAllAttributes: function (attribute) {\n            this.chosenOptions(_.pluck(attribute.options(), 'id'));\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        deSelectAllAttributes: function (attribute) {\n            attribute.chosenOptions.removeAll();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        saveOptions: function () {\n            var newOptions = [];\n\n            _.each(this.attributes(), function (attribute) {\n                _.each(attribute.options(), function (element) {\n                    var option = attribute.options.findWhere({\n                        id: element.id\n                    });\n\n                    if (option['is_new'] === true) {\n                        if (!attribute.isValidOption(option)) {\n                            throw new Error(\n                                $.mage.__('The value of attribute \"\"%1\"\" must be unique')\n                                    .replace('\"%1\"', attribute.label)\n                            );\n                        }\n\n                        newOptions.push(option);\n                    }\n                });\n            });\n\n            if (!newOptions.length) {\n                return false;\n            }\n\n            $.ajax({\n                type: 'POST',\n                url: this.createOptionsUrl,\n                data: {\n                    options: newOptions\n                },\n                showLoader: true\n            }).done(function (savedOptions) {\n                if (savedOptions.error) {\n                    this.notificationMessage.error = savedOptions.error;\n                    this.notificationMessage.text = savedOptions.message;\n\n                    return;\n                }\n\n                _.each(this.attributes(), function (attribute) {\n                    _.each(savedOptions, function (newOptionId, oldOptionId) {\n                        var option = attribute.options.findWhere({\n                            id: oldOptionId\n                        });\n\n                        if (option) {\n                            attribute.options.remove(option);\n                            option['is_new'] = false;\n                            option.value = newOptionId;\n                            attribute.options.push(option);\n                        }\n                    });\n                });\n\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attributeIds\n         */\n        requestAttributes: function (attributeIds) {\n            $.ajax({\n                type: 'GET',\n                url: this.optionsUrl,\n                data: {\n                    attributes: attributeIds\n                },\n                showLoader: true\n            }).done(function (attributes) {\n                attributes = _.sortBy(attributes, function (attribute) {\n                    return this.wizard.data.attributesIds.indexOf(attribute.id);\n                }.bind(this));\n                this.attributes(_.map(attributes, this.createAttribute));\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attribute\n         * @return {*}\n         */\n        doInitSavedOptions: function (attribute) {\n            var selectedOptions, selectedOptionsIds, selectedAttribute = _.findWhere(this.initData.attributes, {\n                id: attribute.id\n            });\n\n            if (selectedAttribute) {\n                selectedOptions = _.pluck(selectedAttribute.chosen, 'value');\n                selectedOptionsIds = _.pluck(_.filter(attribute.options(), function (option) {\n                    return _.contains(selectedOptions, option.value);\n                }), 'id');\n                attribute.chosenOptions(selectedOptionsIds);\n                this.initData.attributes = _.without(this.initData.attributes, selectedAttribute);\n            }\n\n            return attribute;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.requestAttributes(wizard.data.attributesIds());\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.saveOptions();\n            this.saveAttribute(wizard);\n\n            wizard.data.attributes = this.attributes;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        back: function (wizard) {\n            wizard.data.attributesIds(this.attributes().pluck('id'));\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/paging/paging',\n    'mage/translate'\n], function (Component, $, ko, _, paging) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }',\n                modalComponent: '${ $.modalComponent }',\n                matrixGridComponent: '${ $.matrixGridComponent }'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            gridExisting: [],\n            gridNew: [],\n            gridDeleted: [],\n            variationsExisting: [],\n            variationsNew: [],\n            variationsDeleted: [],\n            pagingExisting: paging({\n                name: 'configurableWizard.pagingExisting',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingExisting_sizes'\n                }\n            }),\n            pagingNew: paging({\n                name: 'configurableWizard.pagingNew',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingNew_sizes'\n                }\n            }),\n            pagingDeleted: paging({\n                name: 'configurableWizard.pagingDeleted',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingDeleted_sizes'\n                }\n            }),\n            attributes: [],\n            attributesName: [$.mage.__('Images'), $.mage.__('SKU'), $.mage.__('Quantity'), $.mage.__('Price')],\n            sections: [],\n            gridTemplate: 'Magento_ConfigurableProduct/variations/steps/summary-grid',\n            quantityFieldName: 'quantity'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            var pagingObservables = {\n                currentNew: ko.getObservable(this.pagingNew, 'current'),\n                currentExisting: ko.getObservable(this.pagingExisting, 'current'),\n                currentDeleted: ko.getObservable(this.pagingDeleted, 'current'),\n                pageSizeNew: ko.getObservable(this.pagingNew, 'pageSize'),\n                pageSizeExisting: ko.getObservable(this.pagingExisting, 'pageSize'),\n                pageSizeDeleted: ko.getObservable(this.pagingDeleted, 'pageSize')\n            };\n\n            this._super().observe('gridExisting gridNew gridDeleted attributes sections');\n            this.gridExisting.columns = ko.observableArray();\n            this.gridNew.columns = ko.observableArray();\n            this.gridDeleted.columns = ko.observableArray();\n\n            _.each(pagingObservables, function (observable) {\n                observable.subscribe(function () {\n                    this.generateGrid();\n                }, this);\n            }, this);\n\n            return this;\n        },\n        nextLabelText: $.mage.__('Generate Products'),\n        variations: [],\n\n        /**\n         * @param {*} variations\n         * @param {Function} getSectionValue\n         */\n        calculate: function (variations, getSectionValue) {\n            var productSku = this.variationsComponent().getProductValue('sku'),\n                productPrice = this.variationsComponent().getProductPrice(),\n                productWeight = this.variationsComponent().getProductValue('weight'),\n                productName = this.variationsComponent().getProductValue('name'),\n                variationsKeys = [],\n                gridExisting = [],\n                gridNew = [],\n                gridDeleted = [],\n                matrixGridData = this.matrixGridComponent() ?\n                    _.indexBy(this.matrixGridComponent().getUnionInsertData(), 'variationKey') : {};\n\n            this.variations = [];\n            _.each(variations, function (options) {\n                var product, images, sku, name, quantity, price, variation,\n                    variationsKey = this.variationsComponent().getVariationKey(options),\n                    productDataFromGrid = matrixGridData[variationsKey] || {},\n                    productDataFromWizard = {},\n                    productId = this.variationsComponent().getProductIdByOptions(options);\n\n                if (productId) {\n                    product = _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    });\n                }\n                images = getSectionValue('images', options);\n                sku = productSku + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                name = productName + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                quantity = getSectionValue(this.quantityFieldName, options);\n\n                if (quantity) {\n                    productDataFromWizard[this.quantityFieldName] = quantity;\n                }\n                price = getSectionValue('price', options);\n\n                if (price) {\n                    productDataFromWizard.price = price;\n                }\n\n                if (productId && !images.file) {\n                    images = product.images;\n                }\n                productDataFromGrid = this.prepareProductDataFromGrid(productDataFromGrid);\n\n                product = _.pick(\n                    product || {},\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    this.quantityFieldName\n                );\n                variation = {\n                    options: options,\n                    images: images,\n                    sku: sku,\n                    name: name,\n                    price: productPrice,\n                    productId: productId,\n                    weight: productWeight,\n                    editable: true\n                };\n                variation[this.quantityFieldName] = quantity;\n                variation = _.extend(variation, product, productDataFromGrid, productDataFromWizard);\n\n                if (productId) {\n                    gridExisting.push(this.prepareRowForGrid(variation));\n                } else {\n                    gridNew.push(this.prepareRowForGrid(variation));\n                }\n                this.variations.push(variation);\n                variationsKeys.push(variationsKey);\n            }, this);\n\n            _.each(_.omit(this.variationsComponent().productAttributesMap, variationsKeys), function (productId) {\n                gridDeleted.push(this.prepareRowForGrid(\n                    _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    })\n                ));\n            }.bind(this));\n\n            this.variationsExisting = gridExisting;\n            this.variationsNew = gridNew;\n            this.variationsDeleted = gridDeleted;\n        },\n\n        /**\n         * Generate grid.\n         */\n        generateGrid: function () {\n            var pageExisting = this.pagingExisting.pageSize * this.pagingExisting.current,\n                pageNew = this.pagingNew.pageSize * this.pagingNew.current,\n                pageDeleted = this.pagingDeleted.pageSize * this.pagingDeleted.current;\n\n            this.pagingExisting.totalRecords = this.variationsExisting.length;\n            this.gridExisting(this.variationsExisting.slice(pageExisting - this.pagingExisting.pageSize, pageExisting));\n\n            this.pagingNew.totalRecords = this.variationsNew.length;\n            this.gridNew(this.variationsNew.slice(pageNew - this.pagingNew.pageSize, pageNew));\n\n            this.pagingDeleted.totalRecords = this.variationsDeleted.length;\n            this.gridDeleted(this.variationsDeleted.slice(pageDeleted - this.pagingDeleted.pageSize, pageDeleted));\n        },\n\n        /**\n         * @param {Object} variation\n         * @return {Array}\n         */\n        prepareRowForGrid: function (variation) {\n            var row = [];\n\n            row.push(_.extend({\n                images: []\n            }, variation.images));\n            row.push(variation.sku);\n            row.push(variation[this.quantityFieldName]);\n            _.each(variation.options, function (option) {\n                row.push(option.label);\n            });\n            row.push(this.variationsComponent().getCurrencySymbol() +  ' ' + variation.price);\n\n            return row;\n        },\n\n        /**\n         * @return {String|*}\n         */\n        getGridTemplate: function () {\n            return this.gridTemplate;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getGridId: function () {\n            return _.uniqueId('grid_');\n        },\n\n        /**\n         * @param {*} attributes\n         * @return {Array}\n         */\n        getColumnsName: function (attributes) {\n            var columns = this.attributesName.slice(0);\n\n            attributes.each(function (attribute, index) {\n                columns.splice(3 + index, 0, attribute.label);\n            }, this);\n\n            return columns;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.sections(wizard.data.sections());\n            this.attributes(wizard.data.attributes());\n            this.gridNew([]);\n            this.gridExisting([]);\n            this.gridDeleted([]);\n            this.gridExisting.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridNew.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridDeleted.columns(this.getColumnsName(this.variationsComponent().productAttributes));\n            this.calculate(wizard.data.variations, wizard.data.sectionHelper);\n            this.generateGrid();\n        },\n\n        /**\n         * Force.\n         */\n        force: function () {\n            this.variationsComponent().render(this.variations, this.attributes());\n            this.modalComponent().closeModal();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        },\n\n        /**\n         * Prepare product data from grid to have all the current fields values\n         *\n         * @param {Object} productDataFromGrid\n         * @return {Object}\n         */\n        prepareProductDataFromGrid: function (productDataFromGrid) {\n            productDataFromGrid = _.pick(\n                productDataFromGrid,\n                'sku',\n                'name',\n                'weight',\n                'status',\n                'price',\n                'qty'\n            );\n\n            if (productDataFromGrid.hasOwnProperty('qty')) {\n                productDataFromGrid[this.quantityFieldName] = productDataFromGrid.qty;\n            }\n\n            delete productDataFromGrid.qty;\n\n            return productDataFromGrid;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader',\n    'underscore'\n], function (Element, _) {\n    'use strict';\n\n    return Element.extend({\n        processedFile: {},\n        actionsListOpened: false,\n        thumbnailUrl: '',\n        thumbnail: null,\n        smallImage: null,\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['processedFile', 'actionsListOpened', 'thumbnailUrl', 'thumbnail', 'smallImage']);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            var value = this.getInitialValue();\n\n            if (!_.isString(value)) {\n                this._super();\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {Object} Chainable.\n         */\n        addFile: function (file) {\n            this.processedFile(this.processFile(file));\n\n            this.value(this.processedFile().file);\n\n            return this;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            } else {\n                this.actionsListOpened(true);\n            }\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @returns {Object} Chainable\n         */\n        closeList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete Image\n         *\n         * @returns {Object} Chainable\n         */\n        deleteImage: function () {\n            this.processedFile({});\n            this.value(null);\n            this.thumbnail(null);\n            this.thumbnailUrl(null);\n            this.smallImage(null);\n\n            return this;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-warning.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            isConfigurable: false\n        },\n\n        /**\n         * Updates component visibility state.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateVisibility: function (variationsEmpty) {\n            var isVisible = this.isConfigurable || !variationsEmpty;\n\n            this.visible(isVisible);\n\n            return isVisible;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/qty-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handleQtyValue(this.isConfigurable);\n\n            /** important to set this listener in initialize because of a different order of processing.\n             * Do not move to defaults->listens section */\n            this.setListeners({\n                isConfigurable: 'handleQtyValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Disable and clear Qty if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handleQtyValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Catalog/js/components/custom-options-price-type'\n], function (_, PriceType) {\n    'use strict';\n\n    return PriceType.extend({\n        defaults: {\n            isConfigurable: false,\n            isFiltered: null,\n            defaultOptions: null,\n            filteredOptions: null,\n            bannedOptions: []\n        },\n\n        /**\n         * Updates options.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateOptions: function (variationsEmpty) {\n            var isFiltered = this.isConfigurable || !variationsEmpty,\n                value;\n\n            if (this.isFiltered !== isFiltered) {\n                value = this.value();\n\n                this.options(isFiltered ? this.getFilteredOptions() : this.getDefaultOptions());\n                this.value(value);\n            }\n\n            return isFiltered;\n        },\n\n        /**\n         * Get default list of options.\n         *\n         * @returns {Array}\n         */\n        getDefaultOptions: function () {\n            if (this.defaultOptions === null) {\n                this.defaultOptions = this.options();\n            }\n\n            return this.defaultOptions;\n        },\n\n        /**\n         * Get filtered list of options.\n         *\n         * @returns {Array}\n         */\n        getFilteredOptions: function () {\n            var defaultOptions;\n\n            if (this.filteredOptions === null) {\n                defaultOptions = this.getDefaultOptions();\n                this.filteredOptions = [];\n\n                _.each(defaultOptions, function (option) {\n                    if (this.bannedOptions.indexOf(option.value) === -1) {\n                        this.filteredOptions.push(option);\n                    }\n                }, this);\n            }\n\n            return this.filteredOptions;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/associated-product-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function (_, insertListing) {\n    'use strict';\n\n    return insertListing.extend({\n        defaults: {\n            gridInitialized: false,\n            paramsUpdated: false,\n            showMassActionColumn: true,\n            currentProductId: 0,\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            typeGrid: '',\n            product: {},\n            rowIndexForChange: undefined,\n            changeProductData: [],\n            modules: {\n                productsProvider: '${ $.productsProvider }',\n                productsColumns: '${ $.productsColumns }',\n                productsMassAction: '${ $.productsMassAction }',\n                modalWithGrid: '${ $.modalWithGrid }',\n                productsFilters: '${ $.productsFilters }'\n            },\n            exports: {\n                externalProviderParams: '${ $.externalProvider }:params'\n            },\n            links: {\n                changeProductData: '${ $.provider }:${ $.changeProductProvider }'\n            },\n            listens: {\n                '${ $.externalProvider }:params': '_setFilters _setVisibilityMassActionColumn',\n                '${ $.productsProvider }:data': '_handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect'\n            }\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(\n                'changeProductData'\n            );\n\n            return this;\n        },\n\n        /**\n         * Get ids of used products.\n         *\n         * @returns {Array}\n         */\n        getUsedProductIds: function () {\n            var usedProductsIds = this.source.get(this.dataScopeAssociatedProduct);\n\n            return usedProductsIds.slice();\n        },\n\n        /**\n         * Request for render content.\n         *\n         * @returns {Object}\n         */\n        doRender: function (showMassActionColumn, typeGrid) {\n            this.typeGrid = typeGrid;\n            this.showMassActionColumn = showMassActionColumn;\n\n            if (this.gridInitialized) {\n                this.paramsUpdated = false;\n                this.productsFilters().clear();\n                this._setFilters(this.externalProviderParams);\n                this._setVisibilityMassActionColumn();\n            }\n\n            return this.render();\n        },\n\n        /**\n         * Show grid with assigned product.\n         *\n         * @returns {Object}\n         */\n        showGridAssignProduct: function () {\n            this.product = {};\n            this.rowIndexForChange = undefined;\n\n            return this.doRender(true, 'assignProduct');\n        },\n\n        /**\n         * Show grid with changed product.\n         *\n         * @param {String} rowIndex\n         * @param {String} product\n         */\n        showGridChangeProduct: function (rowIndex, product) {\n            this.rowIndexForChange = rowIndex;\n            this.product = product;\n            this.doRender(false, 'changeProduct');\n        },\n\n        /**\n         * Select product.\n         *\n         * @param {String} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.changeProductData({\n                rowIndex: this.rowIndexForChange,\n                product: this.productsProvider().data.items[rowIndex]\n            });\n            this.modalWithGrid().closeModal();\n        },\n\n        /**\n         * Set visibility state for mass action column\n         *\n         * @private\n         */\n        _setVisibilityMassActionColumn: function () {\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = this.showMassActionColumn;\n                }, this);\n                massActionComponent.visible = this.showMassActionColumn;\n            }.bind(this));\n        },\n\n        /**\n         * Set filters.\n         *\n         * @param {Object} params\n         * @private\n         */\n        _setFilters: function (params) {\n            var filterModifier = {},\n                attrCodes,\n                usedProductIds,\n                attributes;\n\n            params = _.omit(params);\n\n            if (!this.paramsUpdated) {\n                this.gridInitialized = true;\n                this.paramsUpdated = true;\n\n                attrCodes = this._getAttributesCodes();\n                usedProductIds = this.getUsedProductIds();\n\n                if (this.currentProductId) {\n                    usedProductIds.push(this.currentProductId);\n                }\n\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n                attrCodes.each(function (code) {\n                    filterModifier[code] = {\n                        'condition_type': 'notnull'\n                    };\n                });\n\n                if (this.typeGrid === 'changeProduct') {\n                    attributes = JSON.parse(this.product.attributes);\n\n                    filterModifier = _.extend(filterModifier, _.mapObject(attributes, function (value) {\n                        return {\n                            'condition_type': 'eq',\n                            'value': value\n                        };\n                    }));\n\n                    params.filters = attributes;\n                } else {\n                    params.filters = {};\n                }\n\n                params['attributes_codes'] = attrCodes;\n\n                this.set('externalProviderParams', params);\n                this.set('externalFiltersModifier', filterModifier);\n            }\n        },\n\n        /**\n         * Get attribute codes.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getAttributesCodes: function () {\n            var attrCodes = this.source.get('data.attribute_codes');\n\n            return attrCodes ? attrCodes : [];\n        },\n\n        /**\n         * Get product variations.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getProductVariations: function () {\n            var matrix = this.source.get('data.configurable-matrix');\n\n            return matrix ? matrix : [];\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.typeGrid === 'assignProduct') {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Handle manual selection.\n         *\n         * @param {Array} selected\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows,\n                selectedVariationKeys;\n\n            if (this.typeGrid === 'assignProduct') {\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                    selectedVariationKeys,\n                    _.pluck(this._getProductVariations(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Array} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            var variationKeyMap = {};\n\n            _.each(items, function (row) {\n                variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return variationKeyMap;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/modal-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'underscore'\n], function (Modal, registry, _) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            stepWizard: '',\n            modules: {\n                form: '${ $.formName }'\n            }\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            var stepWizard = {};\n\n            this.form().validate();\n\n            if (this.form().source.get('params.invalid') === false) {\n                stepWizard = registry.get('index = ' + this.stepWizard);\n\n                if (!_.isUndefined(stepWizard)) {\n                    stepWizard.open();\n                }\n\n                this._super();\n            } else {\n                this.form().focusInvalid();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/price-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handlePriceValue(this.isConfigurable);\n            // add listener to track \"configurable\" type\n            this.setListeners({\n                isConfigurable: 'handlePriceValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Disable and clear price if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handlePriceValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n            this.required(!!this.isUseDefault() || !isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'jquery'\n], function (_, registry, dynamicRows, $) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            actionsListOpened: false,\n            canEditField: 'canEdit',\n            newProductField: 'newProduct',\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            dataProviderFromGrid: '',\n            dataProviderChangeFromGrid: '',\n            insertDataFromGrid: [],\n            changeDataFromGrid: [],\n            dataProviderFromWizard: '',\n            insertDataFromWizard: [],\n            map: null,\n            isEmpty: true,\n            isShowAddProductButton: false,\n            cacheGridData: [],\n            unionInsertData: [],\n            deleteProperty: false,\n            dataLength: 0,\n            identificationProperty: 'id',\n            'attribute_set_id': '',\n            attributesTmp: [],\n            changedFlag: 'was_changed',\n            listens: {\n                'insertDataFromGrid': 'processingInsertDataFromGrid',\n                'insertDataFromWizard': 'processingInsertDataFromWizard',\n                'unionInsertData': 'processingUnionInsertData',\n                'changeDataFromGrid': 'processingChangeDataFromGrid',\n                'isEmpty': 'changeVisibility'\n            },\n            imports: {\n                'attribute_set_id': '${$.provider}:data.product.attribute_set_id'\n            },\n            'exports': {\n                'attribute_set_id': '${$.provider}:data.new-variations-attribute-set-id'\n            },\n            modules: {\n                modalWithGrid: '${ $.modalWithGrid }',\n                gridWithProducts: '${ $.gridWithProducts}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super()\n                .changeVisibility(this.isEmpty());\n\n            return this;\n        },\n\n        /**\n         * Change visibility\n         *\n         * When isEmpty = true, then visbible = false\n         *\n         * @param {Boolean} isEmpty\n         */\n        changeVisibility: function (isEmpty) {\n            this.visible(!isEmpty);\n        },\n\n        /**\n         * Open modal with grid.\n         *\n         * @param {String} rowIndex\n         */\n        openModalWithGrid: function (rowIndex) {\n            var productSource = this.source.get(this.dataScope + '.' + this.index + '.' + rowIndex),\n                product = {\n                    'id': productSource.id,\n                    'attributes': productSource['configurable_attribute']\n                };\n\n            this.modalWithGrid().openModal();\n            this.gridWithProducts().showGridChangeProduct(rowIndex, product);\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            var tmpArray = [];\n\n            this.recordData.each(function (recordData) {\n                tmpArray.push(recordData);\n            }, this);\n\n            this.unionInsertData(tmpArray);\n\n            return this;\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         */\n        deleteRecord: function (index) {\n            var tmpArray,\n                lastRecord;\n\n            this.reRender = false;\n            tmpArray = this.getUnionInsertData();\n            tmpArray.splice(index, 1);\n\n            if (!tmpArray.length) {\n                this.attributesTmp = this.source.get('data.attributes');\n                this.source.set('data.attributes', []);\n                this.cacheGridData = [];\n            }\n\n            if (parseInt(this.currentPage(), 10) === this.pages()) {\n                lastRecord =\n                    _.findWhere(this.elems(), {\n                        index: this.startIndex + this.getChildItems().length - 1\n                    }) ||\n                    _.findWhere(this.elems(), {\n                        index: (this.startIndex + this.getChildItems().length - 1).toString()\n                    });\n\n                lastRecord.destroy();\n            }\n\n            this.unionInsertData(tmpArray);\n\n            if (this.pages() < parseInt(this.currentPage(), 10)) {\n                this.currentPage(this.pages());\n            }\n\n            this.reRender = true;\n            this.showSpinner(false);\n        },\n\n        /**\n         * Generate associated products\n         */\n        generateAssociatedProducts: function () {\n            var productsIds = [];\n\n            this.getUnionInsertData().forEach(function (data) {\n                if (data.id !== null) {\n                    productsIds.push(data.id);\n                }\n            });\n\n            this.source.set(this.dataScopeAssociatedProduct, productsIds);\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertDataFromGrid', 'unionInsertData', 'isEmpty', 'isShowAddProductButton', 'actionsListOpened'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get union insert data from source\n         *\n         * @returns {Array}\n         */\n        getUnionInsertData: function () {\n            var source = this.source.get(this.dataScope + '.' + this.index),\n                result = [];\n\n            _.each(source, function (data) {\n                result.push(data);\n            });\n\n            return result;\n        },\n\n        /**\n         * Process union insert data.\n         *\n         * @param {Array} data\n         */\n        processingUnionInsertData: function (data) {\n            var dataCount,\n                elemsCount,\n                tmpData,\n                path,\n                attributeCodes = this.source.get('data.attribute_codes');\n\n            this.isEmpty(data.length === 0);\n            this.isShowAddProductButton(\n                (!attributeCodes || data.length > 0 ? data.length : attributeCodes.length) > 0\n            );\n\n            tmpData = data.slice(this.pageSize * (this.currentPage() - 1),\n                                 this.pageSize * (this.currentPage() - 1) + parseInt(this.pageSize, 10));\n\n            this.source.set(this.dataScope + '.' + this.index, []);\n\n            _.each(tmpData, function (row, index) {\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + index);\n                row.attributes = $('<i></i>').text(row.attributes).html();\n                this.source.set(path, row);\n            }, this);\n\n            this.source.set(this.dataScope + '.' + this.index, data);\n            this.parsePagesData(data);\n\n            // Render\n            dataCount = tmpData.length;\n            elemsCount = this.elems().length;\n\n            if (dataCount > elemsCount) {\n                tmpData.each(function (elemData, index) {\n                    this.addChild(elemData, this.startIndex + index);\n                }, this);\n            } else {\n                for (elemsCount; elemsCount > dataCount; elemsCount--) {\n                    this.elems()[elemsCount - 1].destroy();\n                }\n            }\n\n            this.generateAssociatedProducts();\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            return this;\n        },\n\n        /**\n         * Parsed data\n         *\n         * @param {Array} data - array with data\n         * about selected records\n         */\n        processingInsertDataFromGrid: function (data) {\n            var changes,\n                tmpArray;\n\n            if (!data.length) {\n                return;\n            }\n\n            tmpArray = this.getUnionInsertData();\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            changes.each(function (changedObject) {\n                var mappedData = this.mappingValue(changedObject);\n\n                mappedData[this.canEditField] = 0;\n                mappedData[this.newProductField] = 0;\n                mappedData.variationKey = this._getVariationKey(changedObject);\n                mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n                tmpArray.push(mappedData);\n            }, this);\n\n            // Attributes cannot be changed before regeneration thought wizard\n            if (!this.source.get('data.attributes').length) {\n                this.source.set('data.attributes', this.attributesTmp);\n            }\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Process changes from grid.\n         *\n         * @param {Object} data\n         */\n        processingChangeDataFromGrid: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                mappedData = this.mappingValue(data.product);\n\n            mappedData[this.canEditField] = 0;\n            mappedData[this.newProductField] = 0;\n            mappedData.variationKey = this._getVariationKey(data.product);\n            mappedData['configurable_attribute'] = this._getConfigurableAttribute(data.product);\n            tmpArray[data.rowIndex] = mappedData;\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Get variation key.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getVariationKey: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                key = [];\n\n            attrCodes.each(function (code) {\n                key.push(data[code]);\n            });\n\n            return key.sort().join('-');\n        },\n\n        /**\n         * Get configurable attribute.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getConfigurableAttribute: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                confAttrs = {};\n\n            attrCodes.each(function (code) {\n                confAttrs[code] = data[code];\n            });\n\n            return JSON.stringify(confAttrs);\n        },\n\n        /**\n         * Process data insertion from wizard\n         *\n         * @param {Object} data\n         */\n        processingInsertDataFromWizard: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                productIdsToDelete = this.source.get(this.dataScopeAssociatedProduct),\n                index,\n                product = {};\n\n            tmpArray = this.unsetArrayItem(\n                tmpArray,\n                {\n                    id: null\n                }\n            );\n\n            _.each(data, function (row) {\n                if (row.productId) {\n                    index = _.indexOf(productIdsToDelete, row.productId);\n\n                    if (index > -1) {\n                        productIdsToDelete.splice(index, 1);\n                        tmpArray = this.unsetArrayItem(\n                            tmpArray,\n                            {\n                                id: row.productId\n                            }\n                        );\n                    }\n                }\n                product = this.getProductData(row);\n\n                product[this.changedFlag] = true;\n                product[this.canEditField] = row.editable;\n                product[this.newProductField] = row.newProduct;\n                tmpArray.push(product);\n            }, this);\n\n            _.each(productIdsToDelete, function (id) {\n                tmpArray = this.unsetArrayItem(\n                    tmpArray,\n                    {\n                        id: id\n                    }\n                );\n            }, this);\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         *\n         * @param {Object} row\n         * @returns {Object}\n         */\n        getProductData: function (row) {\n            var product,\n                attributesText = '';\n\n            _.each(row.options, function (attribute) {\n                if (attributesText) {\n                    attributesText += ', ';\n                }\n                attributesText += attribute['attribute_label'] + ': ' + attribute.label;\n            }, this);\n\n            product = {\n                'id': row.productId,\n                'product_link': row.productUrl,\n                'name': row.name,\n                'sku': row.sku,\n                'status': row.status,\n                'price': row.price,\n                'price_currency': row.priceCurrency,\n                'price_string': row.priceCurrency + row.price,\n                'weight': row.weight,\n                'qty': row.quantity,\n                'variationKey': row.variationKey,\n                'configurable_attribute': row.attribute,\n                'thumbnail_image': row.images.preview,\n                'media_gallery': row['media_gallery'],\n                'swatch_image': row['swatch_image'],\n                'small_image': row['small_image'],\n                image: row.image,\n                'thumbnail': row.thumbnail,\n                'attributes': attributesText\n            };\n\n            return product;\n        },\n\n        /**\n         * Remove array items matching condition.\n         *\n         * @param {Array} data\n         * @param {Object} condition\n         * @returns {Array}\n         */\n        unsetArrayItem: function (data, condition) {\n            var objs = _.where(data, condition);\n\n            _.each(objs, function (obj) {\n                var index = _.indexOf(data, obj);\n\n                if (index > -1) {\n                    data.splice(index, 1);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.each(function (record, index) {\n                obj[this.map.id] = record[this.map.id];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Mapped value\n         */\n        mappingValue: function (data) {\n            var result = {};\n\n            _.each(this.map, function (prop, index) {\n                result[index] = data[prop];\n            });\n\n            return result;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function (rowIndex) {\n            var state = false;\n\n            if (rowIndex !== this.actionsListOpened()) {\n                state = rowIndex;\n            }\n            this.actionsListOpened(state);\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable\n         */\n        closeList: function (rowIndex) {\n            if (this.actionsListOpened() === rowIndex) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggle product status.\n         *\n         * @param {Number} rowIndex\n         */\n        toggleStatusProduct: function (rowIndex) {\n            var tmpArray = this.getUnionInsertData(),\n                status = parseInt(tmpArray[rowIndex].status, 10);\n\n            if (status === 1) {\n                tmpArray[rowIndex].status = 2;\n            } else {\n                tmpArray[rowIndex].status = 1;\n            }\n\n            tmpArray[rowIndex][this.changedFlag] = true;\n            this.unionInsertData(tmpArray);\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/container-configurable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.is_downloadable': 'handleProductType'\n            },\n            links: {\n                isDownloadable: '${ $.provider }:data.is_downloadable'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.handleProductType(this.isDownloadable);\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Change content for container and visibility for button\n         *\n         * @param {String} isDownloadable\n         */\n        handleProductType: function (isDownloadable) {\n            if (isDownloadable === '1') {\n                this.content(this.content2);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(false);\n                }\n            } else {\n                this.content(this.content1);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(true);\n                }\n            }\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form',\n    'uiRegistry'\n], function (Insert, registry) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            modalProvider: '${ $.parentName }',\n            titlePrefix: '',\n            imports: {\n                changeModalTitle: '${ $.modalProvider }:state'\n            },\n            listens: {\n                responseData: 'afterRetry'\n            },\n            modules: {\n                modal: '${ $.modalProvider }',\n                notificationListing: '${ $.columnsProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            var modalTitleProvider;\n\n            this._super();\n            modalTitleProvider = this.modalTitleProvider.split(':');\n            this.modalTitleTarget = modalTitleProvider[0];\n            this.modalTitlePath = modalTitleProvider[1];\n        },\n\n        /**\n         * Change modal title.\n         *\n         * @param {Boolean} change\n         */\n        changeModalTitle: function (change) {\n            if (change) {\n                registry.get(this.modalTitleTarget, function (target) {\n                    this.modal().setTitle(this.titlePrefix + target.get(this.modalTitlePath));\n                }.bind(this));\n            } else {\n                this.modal().setTitle('');\n            }\n        },\n\n        /**\n         * Action after retry operation.\n         *\n         * @param {Object} data\n         */\n        afterRetry: function (data) {\n            if (!data.error) {\n                this.modal().closeModal();\n                this.notificationListing().reload();\n            }\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/form/error.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        /** @inheritdoc */\n        onUpdate: function () {\n            this.bubble('update', this.hasChanged());\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_AdminNotification/js/grid/listing',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'underscore',\n    'jquery'\n], function (Listing, uiAlert, $t, _, $) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            isAllowed: true,\n            ajaxSettings: {\n                method: 'POST',\n                data: {},\n                url: '${ $.dismissUrl }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            _.bindAll(this, 'reload', 'onError');\n\n            return this._super();\n        },\n\n        /**\n         * Dismiss all items.\n         */\n        dismissAll: function () {\n            var toDismiss = [];\n\n            _.each(this.rows, function (row) {\n                if (row.dismiss) {\n                    toDismiss.push(row.uuid);\n                }\n            });\n            toDismiss.length && this.dismiss(toDismiss);\n        },\n\n        /**\n         * Dismiss action.\n         *\n         * @param {Array} items\n         */\n        dismiss: function (items) {\n            var config = _.extend({}, this.ajaxSettings);\n\n            config.data.uuid = items;\n            this.showLoader();\n\n            $.ajax(config)\n                .done(this.reload)\n                .fail(this.onError);\n        },\n\n        /**\n         * Success callback for dismiss request.\n         */\n        reload: function () {\n            this.source.reload({\n                refresh: true\n            });\n        },\n\n        /**\n         * Error callback for dismiss request.\n         *\n         * @param {Object} xhr\n         */\n        onError: function (xhr) {\n            this.hideLoader();\n\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            uiAlert({\n                content: $t('Something went wrong.')\n            });\n        }\n    });\n});\n","Magento_Cms/js/folder-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.folderTree', {\n        options: {\n            root: 'root',\n            rootName: 'Root',\n            url: '',\n            currentPath: ['root'],\n            tree: {\n                core: {\n                    themes: {\n                        dots: false\n                    },\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    check_callback: true\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                }\n            }\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var options = this.options,\n                treeOptions = $.extend(\n                    true,\n                    {},\n                    options.tree,\n                    {\n                        core: {\n                            data: {\n                                url: options.url,\n                                type: 'POST',\n                                dataType: 'text',\n                                dataFilter: $.proxy(function (data) {\n                                    return this._convertData(JSON.parse(data));\n                                }, this),\n\n                                /**\n                                 * @param {HTMLElement} node\n                                 * @return {Object}\n                                 */\n                                data: function (node) {\n                                    return {\n                                        node: node.id === 'root' ? null : node.id,\n                                        'form_key': window.FORM_KEY\n                                    };\n                                }\n                            }\n                        }\n                    }\n                );\n\n            this.element.jstree(treeOptions)\n                .on('ready.jstree', $.proxy(this.treeLoaded, this))\n                .on('load_node.jstree', $.proxy(this._createRootNode, this));\n        },\n\n        /**\n         * Tree loaded.\n         */\n        treeLoaded: function () {\n            var path = this.options.currentPath,\n                tree = this.element,\n                lastExistentFolderEl,\n\n                /**\n                 * Recursively open folders specified in path array.\n                 */\n                recursiveOpen = function () {\n                    var folderEl = $('[data-id=\"' + path.pop() + '\"]');\n\n                    // if folder doesn't exist, select the last opened folder\n                    if (!folderEl.length) {\n                        tree.jstree('select_node', lastExistentFolderEl);\n\n                        return;\n                    }\n\n                    lastExistentFolderEl = folderEl;\n\n                    if (path.length) {\n                        tree.jstree('open_node', folderEl, recursiveOpen);\n                    } else {\n                        tree.jstree('open_node', folderEl, function () {\n                            tree.jstree('select_node', folderEl);\n                        });\n                    }\n                };\n\n            recursiveOpen();\n        },\n\n        /**\n         * Create tree root node\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _createRootNode: function (event, data) {\n            var rootNode, children;\n\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if (data.node.id === '#') {\n                rootNode = {\n                    id: this.options.root,\n                    text: this.options.rootName,\n                    li_attr: {\n                        'data-id': this.options.root\n                    }\n                };\n                children = data.node.children;\n\n                data.instance.element.jstree().create_node(null, rootNode, 'first', function () {\n                    data.instance.element.jstree().move_node(children, rootNode.id);\n                });\n            }\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n        },\n\n        /**\n         * @param {*} data\n         * @return {*}\n         * @private\n         */\n        _convertData: function (data) {\n            return $.map(data, function (node) {\n\n                return {\n                    id: node.id,\n                    text: node.text,\n                    path: node.path,\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    li_attr: {\n                        'data-id': node.id\n                    },\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    children: node.children\n                };\n            });\n        }\n    });\n\n    return $.mage.folderTree;\n});\n","js-storage/js.storage.js":"/*\n * JS Storage Plugin\n *\n * Copyright (c) 2019 Julien Maurel\n *\n * Licensed under the MIT license:\n * http://www.opensource.org/licenses/mit-license.php\n *\n * Project home:\n * https://github.com/julien-maurel/js-storage\n *\n * Version: 1.1.0\n */\n(function (factory) {\n    var registeredInModuleLoader = false;\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery', 'jquery/jquery.cookie'], factory);\n        registeredInModuleLoader = true;\n    }\n    if (typeof exports === 'object') {\n        module.exports = factory();\n        registeredInModuleLoader = true;\n    }\n    if (!registeredInModuleLoader) {\n        var OldStorages = window.Storages;\n        var api = window.Storages = factory();\n        api.noConflict = function () {\n            window.Storages = OldStorages;\n            return api;\n        };\n    }\n}(function () {\n    // Variables used by utilities functions (like isPlainObject...)\n    var class2type = {};\n    var toString = class2type.toString;\n    var hasOwn = class2type.hasOwnProperty;\n    var fnToString = hasOwn.toString;\n    var ObjectFunctionString = fnToString.call(Object);\n    var getProto = Object.getPrototypeOf;\n    var apis = {};\n\n    // Prefix to use with cookie fallback\n    var cookie_local_prefix = \"ls_\";\n    var cookie_session_prefix = \"ss_\";\n\n    // Get items from a storage\n    function _get() {\n        var storage = this._type, l = arguments.length, s = window[storage], a = arguments, a0 = a[0], vi, ret, tmp, i, j;\n        if (l < 1) {\n            throw new Error('Minimum 1 argument must be given');\n        } else if (Array.isArray(a0)) {\n            // If second argument is an array, return an object with value of storage for each item in this array\n            ret = {};\n            for (i in a0) {\n                if (a0.hasOwnProperty(i)) {\n                    vi = a0[i];\n                    try {\n                        ret[vi] = JSON.parse(s.getItem(vi));\n                    } catch (e) {\n                        ret[vi] = s.getItem(vi);\n                    }\n                }\n            }\n            return ret;\n        } else if (l == 1) {\n            // If only 1 argument, return value directly\n            try {\n                return JSON.parse(s.getItem(a0));\n            } catch (e) {\n                return s.getItem(a0);\n            }\n        } else {\n            // If more than 1 argument, parse storage to retrieve final value to return it\n            // Get first level\n            try {\n                ret = JSON.parse(s.getItem(a0));\n                if (!ret) {\n                    throw new ReferenceError(a0 + ' is not defined in this storage');\n                }\n            } catch (e) {\n                throw new ReferenceError(a0 + ' is not defined in this storage');\n            }\n            // Parse next levels\n            for (i = 1; i < l - 1; i++) {\n                ret = ret[a[i]];\n                if (ret === undefined) {\n                    throw new ReferenceError([].slice.call(a, 0, i + 1).join('.') + ' is not defined in this storage');\n                }\n            }\n            // If last argument is an array, return an object with value for each item in this array\n            // Else return value normally\n            if (Array.isArray(a[i])) {\n                tmp = ret;\n                ret = {};\n                for (j in a[i]) {\n                    if (a[i].hasOwnProperty(j)) {\n                        ret[a[i][j]] = tmp[a[i][j]];\n                    }\n                }\n                return ret;\n            } else {\n                return ret[a[i]];\n            }\n        }\n    }\n\n    // Set items of a storage\n    function _set() {\n        var storage = this._type, l = arguments.length, s = window[storage], a = arguments, a0 = a[0], a1 = a[1], vi, to_store = isNaN(a1) ? {} : [], type, tmp, i;\n        if (l < 1 || !_isPlainObject(a0) && l < 2) {\n            throw new Error('Minimum 2 arguments must be given or first parameter must be an object');\n        } else if (_isPlainObject(a0)) {\n            // If first argument is an object, set values of storage for each property of this object\n            for (i in a0) {\n                if (a0.hasOwnProperty(i)) {\n                    vi = a0[i];\n                    if (!_isPlainObject(vi) && !this.alwaysUseJson) {\n                        s.setItem(i, vi);\n                    } else {\n                        s.setItem(i, JSON.stringify(vi));\n                    }\n                }\n            }\n            return a0;\n        } else if (l == 2) {\n            // If only 2 arguments, set value of storage directly\n            if (typeof a1 === 'object' || this.alwaysUseJson) {\n                s.setItem(a0, JSON.stringify(a1));\n            } else {\n                s.setItem(a0, a1);\n            }\n            return a1;\n        } else {\n            // If more than 3 arguments, parse storage to retrieve final node and set value\n            // Get first level\n            try {\n                tmp = s.getItem(a0);\n                if (tmp != null) {\n                    to_store = JSON.parse(tmp);\n                }\n            } catch (e) {\n            }\n            tmp = to_store;\n            // Parse next levels and set value\n            for (i = 1; i < l - 2; i++) {\n                vi = a[i];\n                type = isNaN(a[i + 1]) ? \"object\" : \"array\";\n                if (!tmp[vi] || type == \"object\" && !_isPlainObject(tmp[vi]) || type == \"array\" && !Array.isArray(tmp[vi])) {\n                    if (type == \"array\") tmp[vi] = [];\n                    else tmp[vi] = {};\n                }\n                tmp = tmp[vi];\n            }\n            tmp[a[i]] = a[i + 1];\n            s.setItem(a0, JSON.stringify(to_store));\n            return to_store;\n        }\n    }\n\n    // Remove items from a storage\n    function _remove() {\n        var storage = this._type, l = arguments.length, s = window[storage], a = arguments, a0 = a[0], to_store, tmp, i, j;\n        if (l < 1) {\n            throw new Error('Minimum 1 argument must be given');\n        } else if (Array.isArray(a0)) {\n            // If first argument is an array, remove values from storage for each item of this array\n            for (i in a0) {\n                if (a0.hasOwnProperty(i)) {\n                    s.removeItem(a0[i]);\n                }\n            }\n            return true;\n        } else if (l == 1) {\n            // If only 2 arguments, remove value from storage directly\n            s.removeItem(a0);\n            return true;\n        } else {\n            // If more than 2 arguments, parse storage to retrieve final node and remove value\n            // Get first level\n            try {\n                to_store = tmp = JSON.parse(s.getItem(a0));\n            } catch (e) {\n                throw new ReferenceError(a0 + ' is not defined in this storage');\n            }\n            // Parse next levels and remove value\n            for (i = 1; i < l - 1; i++) {\n                tmp = tmp[a[i]];\n                if (tmp === undefined) {\n                    throw new ReferenceError([].slice.call(a, 1, i).join('.') + ' is not defined in this storage');\n                }\n            }\n            // If last argument is an array,remove value for each item in this array\n            // Else remove value normally\n            if (Array.isArray(a[i])) {\n                for (j in a[i]) {\n                    if (a[i].hasOwnProperty(j)) {\n                        delete tmp[a[i][j]];\n                    }\n                }\n            } else {\n                delete tmp[a[i]];\n            }\n            s.setItem(a0, JSON.stringify(to_store));\n            return true;\n        }\n    }\n\n    // Remove all items from a storage\n    function _removeAll(reinit_ns) {\n        var keys = _keys.call(this), i;\n        for (i in keys) {\n            if (keys.hasOwnProperty(i)) {\n                _remove.call(this, keys[i]);\n            }\n        }\n        // Reinitialize all namespace storages\n        if (reinit_ns) {\n            for (i in apis.namespaceStorages) {\n                if (apis.namespaceStorages.hasOwnProperty(i)) {\n                    _createNamespace(i);\n                }\n            }\n        }\n    }\n\n    // Check if items of a storage are empty\n    function _isEmpty() {\n        var l = arguments.length, a = arguments, a0 = a[0], i;\n        if (l == 0) {\n            // If no argument, test if storage is empty\n            return (_keys.call(this).length == 0);\n        } else if (Array.isArray(a0)) {\n            // If first argument is an array, test each item of this array and return true only if all items are empty\n            for (i = 0; i < a0.length; i++) {\n                if (!_isEmpty.call(this, a0[i])) {\n                    return false;\n                }\n            }\n            return true;\n        } else {\n            // If at least 1 argument, try to get value and test it\n            try {\n                var v = _get.apply(this, arguments);\n                // Convert result to an object (if last argument is an array, _get return already an object) and test each item\n                if (!Array.isArray(a[l - 1])) {\n                    v = {'totest': v};\n                }\n                for (i in v) {\n                    if (v.hasOwnProperty(i) && !(\n                        (_isPlainObject(v[i]) && _isEmptyObject(v[i])) ||\n                        (Array.isArray(v[i]) && !v[i].length) ||\n                        (typeof v[i] !== 'boolean' && !v[i])\n                    )) {\n                        return false;\n                    }\n                }\n                return true;\n            } catch (e) {\n                return true;\n            }\n        }\n    }\n\n    // Check if items of a storage exist\n    function _isSet() {\n        var l = arguments.length, a = arguments, a0 = a[0], i;\n        if (l < 1) {\n            throw new Error('Minimum 1 argument must be given');\n        }\n        if (Array.isArray(a0)) {\n            // If first argument is an array, test each item of this array and return true only if all items exist\n            for (i = 0; i < a0.length; i++) {\n                if (!_isSet.call(this, a0[i])) {\n                    return false;\n                }\n            }\n            return true;\n        } else {\n            // For other case, try to get value and test it\n            try {\n                var v = _get.apply(this, arguments);\n                // Convert result to an object (if last argument is an array, _get return already an object) and test each item\n                if (!Array.isArray(a[l - 1])) {\n                    v = {'totest': v};\n                }\n                for (i in v) {\n                    if (v.hasOwnProperty(i) && !(v[i] !== undefined && v[i] !== null)) {\n                        return false;\n                    }\n                }\n                return true;\n            } catch (e) {\n                return false;\n            }\n        }\n    }\n\n    // Get keys of a storage or of an item of the storage\n    function _keys() {\n        var storage = this._type, l = arguments.length, s = window[storage], keys = [], o = {};\n        // If at least 1 argument, get value from storage to retrieve keys\n        // Else, use storage to retrieve keys\n        if (l > 0) {\n            o = _get.apply(this, arguments);\n        } else {\n            o = s;\n        }\n        if (o && o._cookie) {\n            // If storage is a cookie, use js-cookie to retrieve keys\n            var cookies = Cookies.get();\n            for (var key in cookies) {\n                if (cookies.hasOwnProperty(key) && key != '') {\n                    keys.push(key.replace(o._prefix, ''));\n                }\n            }\n        } else {\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    keys.push(i);\n                }\n            }\n        }\n        return keys;\n    }\n\n    // Create new namespace storage\n    function _createNamespace(name) {\n        if (!name || typeof name != \"string\") {\n            throw new Error('First parameter must be a string');\n        }\n        if (storage_available) {\n            if (!window.localStorage.getItem(name)) {\n                window.localStorage.setItem(name, '{}');\n            }\n            if (!window.sessionStorage.getItem(name)) {\n                window.sessionStorage.setItem(name, '{}');\n            }\n        } else {\n            if (!window.localCookieStorage.getItem(name)) {\n                window.localCookieStorage.setItem(name, '{}');\n            }\n            if (!window.sessionCookieStorage.getItem(name)) {\n                window.sessionCookieStorage.setItem(name, '{}');\n            }\n        }\n        var ns = {\n            localStorage: _extend({}, apis.localStorage, {_ns: name}),\n            sessionStorage: _extend({}, apis.sessionStorage, {_ns: name})\n        };\n        if (cookies_available) {\n            if (!window.cookieStorage.getItem(name)) {\n                window.cookieStorage.setItem(name, '{}');\n            }\n            ns.cookieStorage = _extend({}, apis.cookieStorage, {_ns: name});\n        }\n        apis.namespaceStorages[name] = ns;\n        return ns;\n    }\n\n    // Test if storage is natively available on browser\n    function _testStorage(name) {\n        var foo = 'jsapi';\n        try {\n            if (!window[name]) {\n                return false;\n            }\n            window[name].setItem(foo, foo);\n            window[name].removeItem(foo);\n            return true;\n        } catch (e) {\n            return false;\n        }\n    }\n\n    // Test if a variable is a plain object (from jQuery)\n    function _isPlainObject(obj) {\n        var proto, Ctor;\n\n        // Detect obvious negatives\n        // Use toString instead of jQuery.type to catch host objects\n        if (!obj || toString.call(obj) !== \"[object Object]\") {\n            return false;\n        }\n\n        proto = getProto(obj);\n\n        // Objects with no prototype (e.g., `Object.create( null )`) are plain\n        if (!proto) {\n            return true;\n        }\n\n        // Objects with prototype are plain iff they were constructed by a global Object function\n        Ctor = hasOwn.call(proto, \"constructor\") && proto.constructor;\n        return typeof Ctor === \"function\" && fnToString.call(Ctor) === ObjectFunctionString;\n    }\n\n    // Test if a variable is an empty object (from jQuery)\n    function _isEmptyObject(obj) {\n        var name;\n\n        for (name in obj) {\n            return false;\n        }\n        return true;\n    }\n\n    // Merge objects\n    function _extend() {\n        var i = 1;\n        var result = arguments[0];\n        for (; i < arguments.length; i++) {\n            var attributes = arguments[i];\n            for (var key in attributes) {\n                if (attributes.hasOwnProperty(key)) {\n                    result[key] = attributes[key];\n                }\n            }\n        }\n        return result;\n    }\n\n    // Check if storages are natively available on browser and check is js-cookie is present\n    var storage_available = _testStorage('localStorage');\n    var cookies_available = typeof Cookies !== 'undefined';\n\n    // Namespace object\n    var storage = {\n        _type: '',\n        _ns: '',\n        _callMethod: function (f, a) {\n            a = Array.prototype.slice.call(a);\n            var p = [], a0 = a[0];\n            if (this._ns) {\n                p.push(this._ns);\n            }\n            if (typeof a0 === 'string' && a0.indexOf('.') !== -1) {\n                a.shift();\n                [].unshift.apply(a, a0.split('.'));\n            }\n            [].push.apply(p, a);\n            return f.apply(this, p);\n        },\n        // Define if plugin always use JSON to store values (even to store simple values like string, int...) or not\n        alwaysUseJson: false,\n        // Get items. If no parameters and storage have a namespace, return all namespace\n        get: function () {\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_get, arguments);\n        },\n        // Set items\n        set: function () {\n            var l = arguments.length, a = arguments, a0 = a[0];\n            if (l < 1 || !_isPlainObject(a0) && l < 2) {\n                throw new Error('Minimum 2 arguments must be given or first parameter must be an object');\n            }\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            // If first argument is an object and storage is a namespace storage, set values individually\n            if (_isPlainObject(a0) && this._ns) {\n                for (var i in a0) {\n                    if (a0.hasOwnProperty(i)) {\n                        this._callMethod(_set, [i, a0[i]]);\n                    }\n                }\n                return a0;\n            } else {\n                var r = this._callMethod(_set, a);\n                if (this._ns) {\n                    return r[a0.split('.')[0]];\n                } else {\n                    return r;\n                }\n            }\n        },\n        // Delete items\n        remove: function () {\n            if (arguments.length < 1) {\n                throw new Error('Minimum 1 argument must be given');\n            }\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_remove, arguments);\n        },\n        // Delete all items\n        removeAll: function (reinit_ns) {\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            if (this._ns) {\n                this._callMethod(_set, [{}]);\n                return true;\n            } else {\n                return this._callMethod(_removeAll, [reinit_ns]);\n            }\n        },\n        // Items empty\n        isEmpty: function () {\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_isEmpty, arguments);\n        },\n        // Items exists\n        isSet: function () {\n            if (arguments.length < 1) {\n                throw new Error('Minimum 1 argument must be given');\n            }\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_isSet, arguments);\n        },\n        // Get keys of items\n        keys: function () {\n            if (!storage_available && !cookies_available){\n                return null;\n            }\n            return this._callMethod(_keys, arguments);\n        }\n    };\n\n    // Use js-cookie for compatibility with old browsers and give access to cookieStorage\n    if (cookies_available) {\n        // sessionStorage is valid for one window/tab. To simulate that with cookie, we set a name for the window and use it for the name of the cookie\n        if (!window.name) {\n            window.name = Math.floor(Math.random() * 100000000);\n        }\n        var cookie_storage = {\n            _cookie: true,\n            _prefix: '',\n            _expires: null,\n            _path: null,\n            _domain: null,\n            _secure: false,\n            setItem: function (n, v) {\n                Cookies.set(this._prefix + n, v, {expires: this._expires, path: this._path, domain: this._domain, secure: this._secure});\n            },\n            getItem: function (n) {\n                return Cookies.get(this._prefix + n);\n            },\n            removeItem: function (n) {\n                return Cookies.remove(this._prefix + n, {path: this._path});\n            },\n            clear: function () {\n                var cookies = Cookies.get();\n                for (var key in cookies) {\n                    if (cookies.hasOwnProperty(key) && key != '') {\n                        if (!this._prefix && key.indexOf(cookie_local_prefix) === -1 && key.indexOf(cookie_session_prefix) === -1 || this._prefix && key.indexOf(this._prefix) === 0) {\n                            Cookies.remove(key);\n                        }\n                    }\n                }\n            },\n            setExpires: function (e) {\n                this._expires = e;\n                return this;\n            },\n            setPath: function (p) {\n                this._path = p;\n                return this;\n            },\n            setDomain: function (d) {\n                this._domain = d;\n                return this;\n            },\n            setSecure: function (s) {\n                this._secure = s;\n                return this;\n            },\n            setConf: function (c) {\n                if (c.path) {\n                    this._path = c.path;\n                }\n                if (c.domain) {\n                    this._domain = c.domain;\n                }\n                if (c.secure) {\n                    this._secure = c.secure;\n                }\n                if (c.expires) {\n                    this._expires = c.expires;\n                }\n                return this;\n            },\n            setDefaultConf: function () {\n                this._path = this._domain = this._expires = null;\n                this._secure = false;\n            }\n        };\n        if (!storage_available) {\n            window.localCookieStorage = _extend({}, cookie_storage, {\n                _prefix: cookie_local_prefix,\n                _expires: 365 * 10,\n                _secure: true\n            });\n            window.sessionCookieStorage = _extend({}, cookie_storage, {\n                _prefix: cookie_session_prefix + window.name + '_',\n                _secure: true\n            });\n        }\n        window.cookieStorage = _extend({}, cookie_storage);\n        // cookieStorage API\n        apis.cookieStorage = _extend({}, storage, {\n            _type: 'cookieStorage',\n            setExpires: function (e) {\n                window.cookieStorage.setExpires(e);\n                return this;\n            },\n            setPath: function (p) {\n                window.cookieStorage.setPath(p);\n                return this;\n            },\n            setDomain: function (d) {\n                window.cookieStorage.setDomain(d);\n                return this;\n            },\n            setSecure: function (s) {\n                window.cookieStorage.setSecure(s);\n                return this;\n            },\n            setConf: function (c) {\n                window.cookieStorage.setConf(c);\n                return this;\n            },\n            setDefaultConf: function () {\n                window.cookieStorage.setDefaultConf();\n                return this;\n            }\n        });\n    }\n\n    // Get a new API on a namespace\n    apis.initNamespaceStorage = function (ns) {\n        return _createNamespace(ns);\n    };\n    if (storage_available) {\n        // localStorage API\n        apis.localStorage = _extend({}, storage, {_type: 'localStorage'});\n        // sessionStorage API\n        apis.sessionStorage = _extend({}, storage, {_type: 'sessionStorage'});\n    } else {\n        // localStorage API\n        apis.localStorage = _extend({}, storage, {_type: 'localCookieStorage'});\n        // sessionStorage API\n        apis.sessionStorage = _extend({}, storage, {_type: 'sessionCookieStorage'});\n    }\n    // List of all namespace storage\n    apis.namespaceStorages = {};\n    // Remove all items in all storages\n    apis.removeAllStorages = function (reinit_ns) {\n        apis.localStorage.removeAll(reinit_ns);\n        apis.sessionStorage.removeAll(reinit_ns);\n        if (apis.cookieStorage) {\n            apis.cookieStorage.removeAll(reinit_ns);\n        }\n        if (!reinit_ns) {\n            apis.namespaceStorages = {};\n        }\n    };\n    // About alwaysUseJson\n    // By default, all values are string on html storages and the plugin don't use json to store simple values (strings, int, float...)\n    // So by default, if you do storage.setItem('test',2), value in storage will be \"2\", not 2\n    // If you set this property to true, all values set with the plugin will be stored as json to have typed values in any cases\n    apis.alwaysUseJsonInStorage = function (value) {\n        storage.alwaysUseJson = value;\n        apis.localStorage.alwaysUseJson = value;\n        apis.sessionStorage.alwaysUseJson = value;\n        if (apis.cookieStorage) {\n            apis.cookieStorage.alwaysUseJson = value;\n        }\n    };\n\n    return apis;\n}));\n","js-storage/storage-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-storage/js.storage'\n], function ($, storage) {\n    'use strict';\n\n    if (window.cookieStorage) {\n        var cookiesConfig = window.cookiesConfig || {};\n\n        $.extend(window.cookieStorage, {\n            _secure: !!cookiesConfig.secure,\n            _samesite: cookiesConfig.samesite ? cookiesConfig.samesite : 'lax',\n\n            /**\n             * Set value under name\n             * @param {String} name\n             * @param {String} value\n             * @param {Object} [options]\n             */\n            setItem: function (name, value, options) {\n                var _default = {\n                    expires: this._expires,\n                    path: this._path,\n                    domain: this._domain,\n                    secure: this._secure,\n                    samesite: this._samesite\n                };\n\n                $.cookie(this._prefix + name, value, $.extend(_default, options || {}));\n            },\n\n            /**\n             * Set default options\n             * @param {Object} c\n             * @returns {storage}\n             */\n            setConf: function (c) {\n                if (c.path) {\n                    this._path = c.path;\n                }\n\n                if (c.domain) {\n                    this._domain = c.domain;\n                }\n\n                if (c.expires) {\n                    this._expires = c.expires;\n                }\n\n                if (typeof c.secure !== 'undefined') {\n                    this._secure = c.secure;\n                }\n\n                if (typeof c.samesite !== 'undefined') {\n                    this._samesite = c.samesite;\n                }\n\n                return this;\n            }\n        });\n    }\n\n    $.alwaysUseJsonInStorage = $.alwaysUseJsonInStorage || storage.alwaysUseJsonInStorage;\n    $.cookieStorage = $.cookieStorage || storage.cookieStorage;\n    $.initNamespaceStorage = $.initNamespaceStorage || storage.initNamespaceStorage;\n    $.localStorage = $.localStorage || storage.localStorage;\n    $.namespaceStorages = $.namespaceStorages || storage.namespaceStorages;\n    $.removeAllStorages = $.removeAllStorages || storage.removeAllStorages;\n    $.sessionStorage = $.sessionStorage || storage.sessionStorage;\n});\n","Magento_UrlRewrite/js/url-rewrite-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/form',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).form().validation({\n            validationUrl: data.url\n        });\n    };\n});\n","Sendinblue_Sendinblue/js/jquery.livequery.min.js":"/**! Copyright (c) 2008 Brandon Aaron (http://brandonaaron.net)\n* Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)\n* and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.\n*\n* Version: 1.0.3\n* Requires jQuery 1.1.3+\n* Docs: http://docs.jquery.com/Plugins/livequery\n*/\n\nrequire([\n    \"jquery\"\n], function($){$.extend($.fn,{livequery:function(type,fn,fn2){var self=this,q;if($.isFunction(type)){fn2=fn,fn=type,type=undefined;}$.each($.livequery.queries,function(i,query){if(self.selector==query.selector&&self.context==query.context&&type==query.type&&(!fn||fn.$lqguid==query.fn.$lqguid)&&(!fn2||fn2.$lqguid==query.fn2.$lqguid)){return(q=query)&&false;}});q=q||new $.livequery(this.selector,this.context,type,fn,fn2);q.stopped=false;q.run();return this;},expire:function(type,fn,fn2){var self=this;if($.isFunction(type)){fn2=fn,fn=type,type=undefined;}$.each($.livequery.queries,function(i,query){if(self.selector==query.selector&&self.context==query.context&&(!type||type==query.type)&&(!fn||fn.$lqguid==query.fn.$lqguid)&&(!fn2||fn2.$lqguid==query.fn2.$lqguid)&&!this.stopped){$.livequery.stop(query.id);}});return this;}});$.livequery=function(selector,context,type,fn,fn2){this.selector=selector;this.context=context||document;this.type=type;this.fn=fn;this.fn2=fn2;this.elements=[];this.stopped=false;this.id=$.livequery.queries.push(this)-1;fn.$lqguid=fn.$lqguid||$.livequery.guid++;if(fn2){fn2.$lqguid=fn2.$lqguid||$.livequery.guid++;}return this;};$.livequery.prototype={stop:function(){var query=this;if(this.type){this.elements.unbind(this.type,this.fn);}else{if(this.fn2){this.elements.each(function(i,el){query.fn2.apply(el);});}}this.elements=[];this.stopped=true;},run:function(){if(this.stopped){return;}var query=this;var oEls=this.elements,els=$(this.selector,this.context),nEls=els.not(oEls);this.elements=els;if(this.type){nEls.bind(this.type,this.fn);if(oEls.length>0){$.each(oEls,function(i,el){if($.inArray(el,els)<0){$.event.remove(el,query.type,query.fn);}});}}else{nEls.each(function(){query.fn.apply(this);});if(this.fn2&&oEls.length>0){$.each(oEls,function(i,el){if($.inArray(el,els)<0){query.fn2.apply(el);}});}}}};$.extend($.livequery,{guid:0,queries:[],queue:[],running:false,timeout:null,checkQueue:function(){if($.livequery.running&&$.livequery.queue.length){var length=$.livequery.queue.length;while(length--){$.livequery.queries[$.livequery.queue.shift()].run();}}},pause:function(){$.livequery.running=false;},play:function(){$.livequery.running=true;$.livequery.run();},registerPlugin:function(){$.each(arguments,function(i,n){if(!$.fn[n]){return;}var old=$.fn[n];$.fn[n]=function(){var r=old.apply(this,arguments);$.livequery.run();return r;};});},run:function(id){if(id!=undefined){if($.inArray(id,$.livequery.queue)<0){$.livequery.queue.push(id);}}else{$.each($.livequery.queries,function(id){if($.inArray(id,$.livequery.queue)<0){$.livequery.queue.push(id);}});}if($.livequery.timeout){clearTimeout($.livequery.timeout);}$.livequery.timeout=setTimeout($.livequery.checkQueue,20);},stop:function(id){if(id!=undefined){$.livequery.queries[id].stop();}else{$.each($.livequery.queries,function(id){$.livequery.queries[id].stop();});}}});$.livequery.registerPlugin(\"append\",\"prepend\",\"after\",\"before\",\"wrap\",\"attr\",\"removeAttr\",\"addClass\",\"removeClass\",\"toggleClass\",\"empty\",\"remove\");$(function(){$.livequery.play();});var init=$.prototype.init;$.prototype.init=function(a,c){var r=init.apply(this,arguments);if(a&&a.selector){r.context=a.context,r.selector=a.selector;}if(typeof a==\"string\"){r.context=c||document,r.selector=a;}return r;};$.prototype.init.prototype=$.prototype;}) });\n","Sendinblue_Sendinblue/js/chosen-input-plugin.js":"/* Chosen v1.4.2 | (c) 2011-2015 by Harvest | MIT License, https://github.com/harvesthq/chosen/blob/master/LICENSE.md */\n\n(function(){var a,AbstractChosen,Chosen,SelectParser,b,c={}.hasOwnProperty,d=function(a,b){function d(){this.constructor=a}for(var e in b)c.call(b,e)&&(a[e]=b[e]);return d.prototype=b.prototype,a.prototype=new d,a.__super__=b.prototype,a};SelectParser=function(){function SelectParser(){this.options_index=0,this.parsed=[]}return SelectParser.prototype.add_node=function(a){return\"OPTGROUP\"===a.nodeName.toUpperCase()?this.add_group(a):this.add_option(a)},SelectParser.prototype.add_group=function(a){var b,c,d,e,f,g;for(b=this.parsed.length,this.parsed.push({array_index:b,group:!0,label:this.escapeExpression(a.label),title:a.title?a.title:void 0,children:0,disabled:a.disabled,classes:a.className}),f=a.childNodes,g=[],d=0,e=f.length;e>d;d++)c=f[d],g.push(this.add_option(c,b,a.disabled));return g},SelectParser.prototype.add_option=function(a,b,c){return\"OPTION\"===a.nodeName.toUpperCase()?(\"\"!==a.text?(null!=b&&(this.parsed[b].children+=1),this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,value:a.value,text:a.text,html:a.innerHTML,title:a.title?a.title:void 0,selected:a.selected,disabled:c===!0?c:a.disabled,group_array_index:b,group_label:null!=b?this.parsed[b].label:null,classes:a.className,style:a.style.cssText})):this.parsed.push({array_index:this.parsed.length,options_index:this.options_index,empty:!0}),this.options_index+=1):void 0},SelectParser.prototype.escapeExpression=function(a){var b,c;return null==a||a===!1?\"\":/[\\&\\<\\>\\\"\\'\\`]/.test(a)?(b={\"<\":\"&lt;\",\">\":\"&gt;\",'\"':\"&quot;\",\"'\":\"&#x27;\",\"`\":\"&#x60;\"},c=/&(?!\\w+;)|[\\<\\>\\\"\\'\\`]/g,a.replace(c,function(a){return b[a]||\"&amp;\"})):a},SelectParser}(),SelectParser.select_to_array=function(a){var b,c,d,e,f;for(c=new SelectParser,f=a.childNodes,d=0,e=f.length;e>d;d++)b=f[d],c.add_node(b);return c.parsed},AbstractChosen=function(){function AbstractChosen(a,b){this.form_field=a,this.options=null!=b?b:{},AbstractChosen.browser_is_supported()&&(this.is_multiple=this.form_field.multiple,this.set_default_text(),this.set_default_values(),this.setup(),this.set_up_html(),this.register_observers(),this.on_ready())}return AbstractChosen.prototype.set_default_values=function(){var a=this;return this.click_test_action=function(b){return a.test_active_click(b)},this.activate_action=function(b){return a.activate_field(b)},this.active_field=!1,this.mouse_on_container=!1,this.results_showing=!1,this.result_highlighted=null,this.allow_single_deselect=null!=this.options.allow_single_deselect&&null!=this.form_field.options[0]&&\"\"===this.form_field.options[0].text?this.options.allow_single_deselect:!1,this.disable_search_threshold=this.options.disable_search_threshold||0,this.disable_search=this.options.disable_search||!1,this.enable_split_word_search=null!=this.options.enable_split_word_search?this.options.enable_split_word_search:!0,this.group_search=null!=this.options.group_search?this.options.group_search:!0,this.search_contains=this.options.search_contains||!1,this.single_backstroke_delete=null!=this.options.single_backstroke_delete?this.options.single_backstroke_delete:!0,this.max_selected_options=this.options.max_selected_options||1/0,this.inherit_select_classes=this.options.inherit_select_classes||!1,this.display_selected_options=null!=this.options.display_selected_options?this.options.display_selected_options:!0,this.display_disabled_options=null!=this.options.display_disabled_options?this.options.display_disabled_options:!0,this.include_group_label_in_selected=this.options.include_group_label_in_selected||!1},AbstractChosen.prototype.set_default_text=function(){return this.default_text=this.form_field.getAttribute(\"data-placeholder\")?this.form_field.getAttribute(\"data-placeholder\"):this.is_multiple?this.options.placeholder_text_multiple||this.options.placeholder_text||AbstractChosen.default_multiple_text:this.options.placeholder_text_single||this.options.placeholder_text||AbstractChosen.default_single_text,this.results_none_found=this.form_field.getAttribute(\"data-no_results_text\")||this.options.no_results_text||AbstractChosen.default_no_result_text},AbstractChosen.prototype.choice_label=function(a){return this.include_group_label_in_selected&&null!=a.group_label?\"<b class='group-name'>\"+a.group_label+\"</b>\"+a.html:a.html},AbstractChosen.prototype.mouse_enter=function(){return this.mouse_on_container=!0},AbstractChosen.prototype.mouse_leave=function(){return this.mouse_on_container=!1},AbstractChosen.prototype.input_focus=function(){var a=this;if(this.is_multiple){if(!this.active_field)return setTimeout(function(){return a.container_mousedown()},50)}else if(!this.active_field)return this.activate_field()},AbstractChosen.prototype.input_blur=function(){var a=this;return this.mouse_on_container?void 0:(this.active_field=!1,setTimeout(function(){return a.blur_test()},100))},AbstractChosen.prototype.results_option_build=function(a){var b,c,d,e,f;for(b=\"\",f=this.results_data,d=0,e=f.length;e>d;d++)c=f[d],b+=c.group?this.result_add_group(c):this.result_add_option(c),(null!=a?a.first:void 0)&&(c.selected&&this.is_multiple?this.choice_build(c):c.selected&&!this.is_multiple&&this.single_set_selected_text(this.choice_label(c)));return b},AbstractChosen.prototype.result_add_option=function(a){var b,c;return a.search_match?this.include_option_in_results(a)?(b=[],a.disabled||a.selected&&this.is_multiple||b.push(\"active-result\"),!a.disabled||a.selected&&this.is_multiple||b.push(\"disabled-result\"),a.selected&&b.push(\"result-selected\"),null!=a.group_array_index&&b.push(\"group-option\"),\"\"!==a.classes&&b.push(a.classes),c=document.createElement(\"li\"),c.className=b.join(\" \"),c.style.cssText=a.style,c.setAttribute(\"data-option-array-index\",a.array_index),c.innerHTML=a.search_text,a.title&&(c.title=a.title),this.outerHTML(c)):\"\":\"\"},AbstractChosen.prototype.result_add_group=function(a){var b,c;return a.search_match||a.group_match?a.active_options>0?(b=[],b.push(\"group-result\"),a.classes&&b.push(a.classes),c=document.createElement(\"li\"),c.className=b.join(\" \"),c.innerHTML=a.search_text,a.title&&(c.title=a.title),this.outerHTML(c)):\"\":\"\"},AbstractChosen.prototype.results_update_field=function(){return this.set_default_text(),this.is_multiple||this.results_reset_cleanup(),this.result_clear_highlight(),this.results_build(),this.results_showing?this.winnow_results():void 0},AbstractChosen.prototype.reset_single_select_options=function(){var a,b,c,d,e;for(d=this.results_data,e=[],b=0,c=d.length;c>b;b++)a=d[b],a.selected?e.push(a.selected=!1):e.push(void 0);return e},AbstractChosen.prototype.results_toggle=function(){return this.results_showing?this.results_hide():this.results_show()},AbstractChosen.prototype.results_search=function(){return this.results_showing?this.winnow_results():this.results_show()},AbstractChosen.prototype.winnow_results=function(){var a,b,c,d,e,f,g,h,i,j,k,l;for(this.no_results_clear(),d=0,f=this.get_search_text(),a=f.replace(/[-[\\]{}()*+?.,\\\\^$|#\\s]/g,\"\\\\$&\"),i=new RegExp(a,\"i\"),c=this.get_search_regex(a),l=this.results_data,j=0,k=l.length;k>j;j++)b=l[j],b.search_match=!1,e=null,this.include_option_in_results(b)&&(b.group&&(b.group_match=!1,b.active_options=0),null!=b.group_array_index&&this.results_data[b.group_array_index]&&(e=this.results_data[b.group_array_index],0===e.active_options&&e.search_match&&(d+=1),e.active_options+=1),b.search_text=b.group?b.label:b.html,(!b.group||this.group_search)&&(b.search_match=this.search_string_match(b.search_text,c),b.search_match&&!b.group&&(d+=1),b.search_match?(f.length&&(g=b.search_text.search(i),h=b.search_text.substr(0,g+f.length)+\"</em>\"+b.search_text.substr(g+f.length),b.search_text=h.substr(0,g)+\"<em>\"+h.substr(g)),null!=e&&(e.group_match=!0)):null!=b.group_array_index&&this.results_data[b.group_array_index].search_match&&(b.search_match=!0)));return this.result_clear_highlight(),1>d&&f.length?(this.update_results_content(\"\"),this.no_results(f)):(this.update_results_content(this.results_option_build()),this.winnow_results_set_highlight())},AbstractChosen.prototype.get_search_regex=function(a){var b;return b=this.search_contains?\"\":\"^\",new RegExp(b+a,\"i\")},AbstractChosen.prototype.search_string_match=function(a,b){var c,d,e,f;if(b.test(a))return!0;if(this.enable_split_word_search&&(a.indexOf(\" \")>=0||0===a.indexOf(\"[\"))&&(d=a.replace(/\\[|\\]/g,\"\").split(\" \"),d.length))for(e=0,f=d.length;f>e;e++)if(c=d[e],b.test(c))return!0},AbstractChosen.prototype.choices_count=function(){var a,b,c,d;if(null!=this.selected_option_count)return this.selected_option_count;for(this.selected_option_count=0,d=this.form_field.options,b=0,c=d.length;c>b;b++)a=d[b],a.selected&&(this.selected_option_count+=1);return this.selected_option_count},AbstractChosen.prototype.choices_click=function(a){return a.preventDefault(),this.results_showing||this.is_disabled?void 0:this.results_show()},AbstractChosen.prototype.keyup_checker=function(a){var b,c;switch(b=null!=(c=a.which)?c:a.keyCode,this.search_field_scale(),b){case 8:if(this.is_multiple&&this.backstroke_length<1&&this.choices_count()>0)return this.keydown_backstroke();if(!this.pending_backstroke)return this.result_clear_highlight(),this.results_search();break;case 13:if(a.preventDefault(),this.results_showing)return this.result_select(a);break;case 27:return this.results_showing&&this.results_hide(),!0;case 9:case 38:case 40:case 16:case 91:case 17:break;default:return this.results_search()}},AbstractChosen.prototype.clipboard_event_checker=function(){var a=this;return setTimeout(function(){return a.results_search()},50)},AbstractChosen.prototype.container_width=function(){return null!=this.options.width?this.options.width:\"\"+this.form_field.offsetWidth+\"px\"},AbstractChosen.prototype.include_option_in_results=function(a){return this.is_multiple&&!this.display_selected_options&&a.selected?!1:!this.display_disabled_options&&a.disabled?!1:a.empty?!1:!0},AbstractChosen.prototype.search_results_touchstart=function(a){return this.touch_started=!0,this.search_results_mouseover(a)},AbstractChosen.prototype.search_results_touchmove=function(a){return this.touch_started=!1,this.search_results_mouseout(a)},AbstractChosen.prototype.search_results_touchend=function(a){return this.touch_started?this.search_results_mouseup(a):void 0},AbstractChosen.prototype.outerHTML=function(a){var b;return a.outerHTML?a.outerHTML:(b=document.createElement(\"div\"),b.appendChild(a),b.innerHTML)},AbstractChosen.browser_is_supported=function(){return\"Microsoft Internet Explorer\"===window.navigator.appName?document.documentMode>=8:/iP(od|hone)/i.test(window.navigator.userAgent)?!1:/Android/i.test(window.navigator.userAgent)&&/Mobile/i.test(window.navigator.userAgent)?!1:!0},AbstractChosen.default_multiple_text=\"Select Some Options\",AbstractChosen.default_single_text=\"Select an Option\",AbstractChosen.default_no_result_text=\"No results match\",AbstractChosen}(),a=$,a.fn.extend({chosen:function(b){return AbstractChosen.browser_is_supported()?this.each(function(){var c,d;c=a(this),d=c.data(\"chosen\"),\"destroy\"===b&&d instanceof Chosen?d.destroy():d instanceof Chosen||c.data(\"chosen\",new Chosen(this,b))}):this}}),Chosen=function(c){function Chosen(){return b=Chosen.__super__.constructor.apply(this,arguments)}return d(Chosen,c),Chosen.prototype.setup=function(){return this.form_field_jq=a(this.form_field),this.current_selectedIndex=this.form_field.selectedIndex,this.is_rtl=this.form_field_jq.hasClass(\"chosen-rtl\")},Chosen.prototype.set_up_html=function(){var b,c;return b=[\"chosen-container\"],b.push(\"chosen-container-\"+(this.is_multiple?\"multi\":\"single\")),this.inherit_select_classes&&this.form_field.className&&b.push(this.form_field.className),this.is_rtl&&b.push(\"chosen-rtl\"),c={\"class\":b.join(\" \"),style:\"width: \"+this.container_width()+\";\",title:this.form_field.title},this.form_field.id.length&&(c.id=this.form_field.id.replace(/[^\\w]/g,\"_\")+\"_chosen\"),this.container=a(\"<div />\",c),this.is_multiple?this.container.html('<ul class=\"chosen-choices\"><li class=\"search-field\"><input type=\"text\" value=\"'+this.default_text+'\" class=\"default\" autocomplete=\"off\" style=\"width:25px;\" /></li></ul><div class=\"chosen-drop\"><ul class=\"chosen-results\"></ul></div>'):this.container.html('<a class=\"chosen-single chosen-default\" tabindex=\"-1\"><span>'+this.default_text+'</span><div><b></b></div></a><div class=\"chosen-drop\"><div class=\"chosen-search\"><input type=\"text\" autocomplete=\"off\" /></div><ul class=\"chosen-results\"></ul></div>'),this.form_field_jq.hide().after(this.container),this.dropdown=this.container.find(\"div.chosen-drop\").first(),this.search_field=this.container.find(\"input\").first(),this.search_results=this.container.find(\"ul.chosen-results\").first(),this.search_field_scale(),this.search_no_results=this.container.find(\"li.no-results\").first(),this.is_multiple?(this.search_choices=this.container.find(\"ul.chosen-choices\").first(),this.search_container=this.container.find(\"li.search-field\").first()):(this.search_container=this.container.find(\"div.chosen-search\").first(),this.selected_item=this.container.find(\".chosen-single\").first()),this.results_build(),this.set_tab_index(),this.set_label_behavior()},Chosen.prototype.on_ready=function(){return this.form_field_jq.trigger(\"chosen:ready\",{chosen:this})},Chosen.prototype.register_observers=function(){var a=this;return this.container.bind(\"touchstart.chosen\",function(b){return a.container_mousedown(b),b.preventDefault()}),this.container.bind(\"touchend.chosen\",function(b){return a.container_mouseup(b),b.preventDefault()}),this.container.bind(\"mousedown.chosen\",function(b){a.container_mousedown(b)}),this.container.bind(\"mouseup.chosen\",function(b){a.container_mouseup(b)}),this.container.bind(\"mouseenter.chosen\",function(b){a.mouse_enter(b)}),this.container.bind(\"mouseleave.chosen\",function(b){a.mouse_leave(b)}),this.search_results.bind(\"mouseup.chosen\",function(b){a.search_results_mouseup(b)}),this.search_results.bind(\"mouseover.chosen\",function(b){a.search_results_mouseover(b)}),this.search_results.bind(\"mouseout.chosen\",function(b){a.search_results_mouseout(b)}),this.search_results.bind(\"mousewheel.chosen DOMMouseScroll.chosen\",function(b){a.search_results_mousewheel(b)}),this.search_results.bind(\"touchstart.chosen\",function(b){a.search_results_touchstart(b)}),this.search_results.bind(\"touchmove.chosen\",function(b){a.search_results_touchmove(b)}),this.search_results.bind(\"touchend.chosen\",function(b){a.search_results_touchend(b)}),this.form_field_jq.bind(\"chosen:updated.chosen\",function(b){a.results_update_field(b)}),this.form_field_jq.bind(\"chosen:activate.chosen\",function(b){a.activate_field(b)}),this.form_field_jq.bind(\"chosen:open.chosen\",function(b){a.container_mousedown(b)}),this.form_field_jq.bind(\"chosen:close.chosen\",function(b){a.input_blur(b)}),this.search_field.bind(\"blur.chosen\",function(b){a.input_blur(b)}),this.search_field.bind(\"keyup.chosen\",function(b){a.keyup_checker(b)}),this.search_field.bind(\"keydown.chosen\",function(b){a.keydown_checker(b)}),this.search_field.bind(\"focus.chosen\",function(b){a.input_focus(b)}),this.search_field.bind(\"cut.chosen\",function(b){a.clipboard_event_checker(b)}),this.search_field.bind(\"paste.chosen\",function(b){a.clipboard_event_checker(b)}),this.is_multiple?this.search_choices.bind(\"click.chosen\",function(b){a.choices_click(b)}):this.container.bind(\"click.chosen\",function(a){a.preventDefault()})},Chosen.prototype.destroy=function(){return a(this.container[0].ownerDocument).unbind(\"click.chosen\",this.click_test_action),this.search_field[0].tabIndex&&(this.form_field_jq[0].tabIndex=this.search_field[0].tabIndex),this.container.remove(),this.form_field_jq.removeData(\"chosen\"),this.form_field_jq.show()},Chosen.prototype.search_field_disabled=function(){return this.is_disabled=this.form_field_jq[0].disabled,this.is_disabled?(this.container.addClass(\"chosen-disabled\"),this.search_field[0].disabled=!0,this.is_multiple||this.selected_item.unbind(\"focus.chosen\",this.activate_action),this.close_field()):(this.container.removeClass(\"chosen-disabled\"),this.search_field[0].disabled=!1,this.is_multiple?void 0:this.selected_item.bind(\"focus.chosen\",this.activate_action))},Chosen.prototype.container_mousedown=function(b){return this.is_disabled||(b&&\"mousedown\"===b.type&&!this.results_showing&&b.preventDefault(),null!=b&&a(b.target).hasClass(\"search-choice-close\"))?void 0:(this.active_field?this.is_multiple||!b||a(b.target)[0]!==this.selected_item[0]&&!a(b.target).parents(\"a.chosen-single\").length||(b.preventDefault(),this.results_toggle()):(this.is_multiple&&this.search_field.val(\"\"),a(this.container[0].ownerDocument).bind(\"click.chosen\",this.click_test_action),this.results_show()),this.activate_field())},Chosen.prototype.container_mouseup=function(a){return\"ABBR\"!==a.target.nodeName||this.is_disabled?void 0:this.results_reset(a)},Chosen.prototype.search_results_mousewheel=function(a){var b;return a.originalEvent&&(b=a.originalEvent.deltaY||-a.originalEvent.wheelDelta||a.originalEvent.detail),null!=b?(a.preventDefault(),\"DOMMouseScroll\"===a.type&&(b=40*b),this.search_results.scrollTop(b+this.search_results.scrollTop())):void 0},Chosen.prototype.blur_test=function(){return!this.active_field&&this.container.hasClass(\"chosen-container-active\")?this.close_field():void 0},Chosen.prototype.close_field=function(){return a(this.container[0].ownerDocument).unbind(\"click.chosen\",this.click_test_action),this.active_field=!1,this.results_hide(),this.container.removeClass(\"chosen-container-active\"),this.clear_backstroke(),this.show_search_field_default(),this.search_field_scale()},Chosen.prototype.activate_field=function(){return this.container.addClass(\"chosen-container-active\"),this.active_field=!0,this.search_field.val(this.search_field.val()),this.search_field.focus()},Chosen.prototype.test_active_click=function(b){var c;return c=a(b.target).closest(\".chosen-container\"),c.length&&this.container[0]===c[0]?this.active_field=!0:this.close_field()},Chosen.prototype.results_build=function(){return this.parsing=!0,this.selected_option_count=null,this.results_data=SelectParser.select_to_array(this.form_field),this.is_multiple?this.search_choices.find(\"li.search-choice\").remove():this.is_multiple||(this.single_set_selected_text(),this.disable_search||this.form_field.options.length<=this.disable_search_threshold?(this.search_field[0].readOnly=!0,this.container.addClass(\"chosen-container-single-nosearch\")):(this.search_field[0].readOnly=!1,this.container.removeClass(\"chosen-container-single-nosearch\"))),this.update_results_content(this.results_option_build({first:!0})),this.search_field_disabled(),this.show_search_field_default(),this.search_field_scale(),this.parsing=!1},Chosen.prototype.result_do_highlight=function(a){var b,c,d,e,f;if(a.length){if(this.result_clear_highlight(),this.result_highlight=a,this.result_highlight.addClass(\"highlighted\"),d=parseInt(this.search_results.css(\"maxHeight\"),10),f=this.search_results.scrollTop(),e=d+f,c=this.result_highlight.position().top+this.search_results.scrollTop(),b=c+this.result_highlight.outerHeight(),b>=e)return this.search_results.scrollTop(b-d>0?b-d:0);if(f>c)return this.search_results.scrollTop(c)}},Chosen.prototype.result_clear_highlight=function(){return this.result_highlight&&this.result_highlight.removeClass(\"highlighted\"),this.result_highlight=null},Chosen.prototype.results_show=function(){return this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger(\"chosen:maxselected\",{chosen:this}),!1):(this.container.addClass(\"chosen-with-drop\"),this.results_showing=!0,this.search_field.focus(),this.search_field.val(this.search_field.val()),this.winnow_results(),this.form_field_jq.trigger(\"chosen:showing_dropdown\",{chosen:this}))},Chosen.prototype.update_results_content=function(a){return this.search_results.html(a)},Chosen.prototype.results_hide=function(){return this.results_showing&&(this.result_clear_highlight(),this.container.removeClass(\"chosen-with-drop\"),this.form_field_jq.trigger(\"chosen:hiding_dropdown\",{chosen:this})),this.results_showing=!1},Chosen.prototype.set_tab_index=function(){var a;return this.form_field.tabIndex?(a=this.form_field.tabIndex,this.form_field.tabIndex=-1,this.search_field[0].tabIndex=a):void 0},Chosen.prototype.set_label_behavior=function(){var b=this;return this.form_field_label=this.form_field_jq.parents(\"label\"),!this.form_field_label.length&&this.form_field.id.length&&(this.form_field_label=a(\"label[for='\"+this.form_field.id+\"']\")),this.form_field_label.length>0?this.form_field_label.bind(\"click.chosen\",function(a){return b.is_multiple?b.container_mousedown(a):b.activate_field()}):void 0},Chosen.prototype.show_search_field_default=function(){return this.is_multiple&&this.choices_count()<1&&!this.active_field?(this.search_field.val(this.default_text),this.search_field.addClass(\"default\")):(this.search_field.val(\"\"),this.search_field.removeClass(\"default\"))},Chosen.prototype.search_results_mouseup=function(b){var c;return c=a(b.target).hasClass(\"active-result\")?a(b.target):a(b.target).parents(\".active-result\").first(),c.length?(this.result_highlight=c,this.result_select(b),this.search_field.focus()):void 0},Chosen.prototype.search_results_mouseover=function(b){var c;return c=a(b.target).hasClass(\"active-result\")?a(b.target):a(b.target).parents(\".active-result\").first(),c?this.result_do_highlight(c):void 0},Chosen.prototype.search_results_mouseout=function(b){return a(b.target).hasClass(\"active-result\")?this.result_clear_highlight():void 0},Chosen.prototype.choice_build=function(b){var c,d,e=this;return c=a(\"<li />\",{\"class\":\"search-choice\"}).html(\"<span>\"+this.choice_label(b)+\"</span>\"),b.disabled?c.addClass(\"search-choice-disabled\"):(d=a(\"<a />\",{\"class\":\"search-choice-close\",\"data-option-array-index\":b.array_index}),d.bind(\"click.chosen\",function(a){return e.choice_destroy_link_click(a)}),c.append(d)),this.search_container.before(c)},Chosen.prototype.choice_destroy_link_click=function(b){return b.preventDefault(),b.stopPropagation(),this.is_disabled?void 0:this.choice_destroy(a(b.target))},Chosen.prototype.choice_destroy=function(a){return this.result_deselect(a[0].getAttribute(\"data-option-array-index\"))?(this.show_search_field_default(),this.is_multiple&&this.choices_count()>0&&this.search_field.val().length<1&&this.results_hide(),a.parents(\"li\").first().remove(),this.search_field_scale()):void 0},Chosen.prototype.results_reset=function(){return this.reset_single_select_options(),this.form_field.options[0].selected=!0,this.single_set_selected_text(),this.show_search_field_default(),this.results_reset_cleanup(),this.form_field_jq.trigger(\"change\"),this.active_field?this.results_hide():void 0},Chosen.prototype.results_reset_cleanup=function(){return this.current_selectedIndex=this.form_field.selectedIndex,this.selected_item.find(\"abbr\").remove()},Chosen.prototype.result_select=function(a){var b,c;return this.result_highlight?(b=this.result_highlight,this.result_clear_highlight(),this.is_multiple&&this.max_selected_options<=this.choices_count()?(this.form_field_jq.trigger(\"chosen:maxselected\",{chosen:this}),!1):(this.is_multiple?b.removeClass(\"active-result\"):this.reset_single_select_options(),b.addClass(\"result-selected\"),c=this.results_data[b[0].getAttribute(\"data-option-array-index\")],c.selected=!0,this.form_field.options[c.options_index].selected=!0,this.selected_option_count=null,this.is_multiple?this.choice_build(c):this.single_set_selected_text(this.choice_label(c)),(a.metaKey||a.ctrlKey)&&this.is_multiple||this.results_hide(),this.search_field.val(\"\"),(this.is_multiple||this.form_field.selectedIndex!==this.current_selectedIndex)&&this.form_field_jq.trigger(\"change\",{selected:this.form_field.options[c.options_index].value}),this.current_selectedIndex=this.form_field.selectedIndex,a.preventDefault(),this.search_field_scale())):void 0},Chosen.prototype.single_set_selected_text=function(a){return null==a&&(a=this.default_text),a===this.default_text?this.selected_item.addClass(\"chosen-default\"):(this.single_deselect_control_build(),this.selected_item.removeClass(\"chosen-default\")),this.selected_item.find(\"span\").html(a)},Chosen.prototype.result_deselect=function(a){var b;return b=this.results_data[a],this.form_field.options[b.options_index].disabled?!1:(b.selected=!1,this.form_field.options[b.options_index].selected=!1,this.selected_option_count=null,this.result_clear_highlight(),this.results_showing&&this.winnow_results(),this.form_field_jq.trigger(\"change\",{deselected:this.form_field.options[b.options_index].value}),this.search_field_scale(),!0)},Chosen.prototype.single_deselect_control_build=function(){return this.allow_single_deselect?(this.selected_item.find(\"abbr\").length||this.selected_item.find(\"span\").first().after('<abbr class=\"search-choice-close\"></abbr>'),this.selected_item.addClass(\"chosen-single-with-deselect\")):void 0},Chosen.prototype.get_search_text=function(){return a(\"<div/>\").text(a.trim(this.search_field.val())).html()},Chosen.prototype.winnow_results_set_highlight=function(){var a,b;return b=this.is_multiple?[]:this.search_results.find(\".result-selected.active-result\"),a=b.length?b.first():this.search_results.find(\".active-result\").first(),null!=a?this.result_do_highlight(a):void 0},Chosen.prototype.no_results=function(b){var c;return c=a('<li class=\"no-results\">'+this.results_none_found+' \"<span></span>\"</li>'),c.find(\"span\").first().html(b),this.search_results.append(c),this.form_field_jq.trigger(\"chosen:no_results\",{chosen:this})},Chosen.prototype.no_results_clear=function(){return this.search_results.find(\".no-results\").remove()},Chosen.prototype.keydown_arrow=function(){var a;return this.results_showing&&this.result_highlight?(a=this.result_highlight.nextAll(\"li.active-result\").first())?this.result_do_highlight(a):void 0:this.results_show()},Chosen.prototype.keyup_arrow=function(){var a;return this.results_showing||this.is_multiple?this.result_highlight?(a=this.result_highlight.prevAll(\"li.active-result\"),a.length?this.result_do_highlight(a.first()):(this.choices_count()>0&&this.results_hide(),this.result_clear_highlight())):void 0:this.results_show()},Chosen.prototype.keydown_backstroke=function(){var a;return this.pending_backstroke?(this.choice_destroy(this.pending_backstroke.find(\"a\").first()),this.clear_backstroke()):(a=this.search_container.siblings(\"li.search-choice\").last(),a.length&&!a.hasClass(\"search-choice-disabled\")?(this.pending_backstroke=a,this.single_backstroke_delete?this.keydown_backstroke():this.pending_backstroke.addClass(\"search-choice-focus\")):void 0)},Chosen.prototype.clear_backstroke=function(){return this.pending_backstroke&&this.pending_backstroke.removeClass(\"search-choice-focus\"),this.pending_backstroke=null},Chosen.prototype.keydown_checker=function(a){var b,c;switch(b=null!=(c=a.which)?c:a.keyCode,this.search_field_scale(),8!==b&&this.pending_backstroke&&this.clear_backstroke(),b){case 8:this.backstroke_length=this.search_field.val().length;break;case 9:this.results_showing&&!this.is_multiple&&this.result_select(a),this.mouse_on_container=!1;break;case 13:this.results_showing&&a.preventDefault();break;case 32:this.disable_search&&a.preventDefault();break;case 38:a.preventDefault(),this.keyup_arrow();break;case 40:a.preventDefault(),this.keydown_arrow()}},Chosen.prototype.search_field_scale=function(){var b,c,d,e,f,g,h,i,j;if(this.is_multiple){for(d=0,h=0,f=\"position:absolute; left: -1000px; top: -1000px; display:none;\",g=[\"font-size\",\"font-style\",\"font-weight\",\"font-family\",\"line-height\",\"text-transform\",\"letter-spacing\"],i=0,j=g.length;j>i;i++)e=g[i],f+=e+\":\"+this.search_field.css(e)+\";\";return b=a(\"<div />\",{style:f}),b.text(this.search_field.val()),a(\"body\").append(b),h=b.width()+25,b.remove(),c=this.container.outerWidth(),h>c-10&&(h=c-10),this.search_field.css({width:h+\"px\"})}},Chosen}(AbstractChosen)}).call(this);","Sendinblue_Sendinblue/js/jquery-ui.min.js":"/*! jQuery UI - v1.10.2 - 2013-03-14\n* http://jqueryui.com\n* Includes: jquery.ui.core.js, jquery.ui.widget.js, jquery.ui.mouse.js, jquery.ui.draggable.js, jquery.ui.droppable.js, jquery.ui.resizable.js, jquery.ui.selectable.js, jquery.ui.sortable.js, jquery.ui.effect.js, jquery.ui.accordion.js, jquery.ui.autocomplete.js, jquery.ui.button.js, jquery.ui.datepicker.js, jquery.ui.dialog.js, jquery.ui.effect-blind.js, jquery.ui.effect-bounce.js, jquery.ui.effect-clip.js, jquery.ui.effect-drop.js, jquery.ui.effect-explode.js, jquery.ui.effect-fade.js, jquery.ui.effect-fold.js, jquery.ui.effect-highlight.js, jquery.ui.effect-pulsate.js, jquery.ui.effect-scale.js, jquery.ui.effect-shake.js, jquery.ui.effect-slide.js, jquery.ui.effect-transfer.js, jquery.ui.menu.js, jquery.ui.position.js, jquery.ui.progressbar.js, jquery.ui.slider.js, jquery.ui.spinner.js, jquery.ui.tabs.js, jquery.ui.tooltip.js\n* Copyright 2013 jQuery Foundation and other contributors; Licensed MIT */\nrequire([\n    \"jquery\"\n], function($){(function(t,e){function i(e,i){var n,o,a,r=e.nodeName.toLowerCase();return\"area\"===r?(n=e.parentNode,o=n.name,e.href&&o&&\"map\"===n.nodeName.toLowerCase()?(a=t(\"img[usemap=#\"+o+\"]\")[0],!!a&&s(a)):!1):(/input|select|textarea|button|object/.test(r)?!e.disabled:\"a\"===r?e.href||i:i)&&s(e)}function s(e){return t.expr.filters.visible(e)&&!t(e).parents().addBack().filter(function(){return\"hidden\"===t.css(this,\"visibility\")}).length}var n=0,o=/^ui-id-\\d+$/;t.ui=t.ui||{},t.extend(t.ui,{version:\"1.10.2\",keyCode:{BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38}}),t.fn.extend({focus:function(e){return function(i,s){return\"number\"==typeof i?this.each(function(){var e=this;setTimeout(function(){t(e).focus(),s&&s.call(e)},i)}):e.apply(this,arguments)}}(t.fn.focus),scrollParent:function(){var e;return e=t.ui.ie&&/(static|relative)/.test(this.css(\"position\"))||/absolute/.test(this.css(\"position\"))?this.parents().filter(function(){return/(relative|absolute|fixed)/.test(t.css(this,\"position\"))&&/(auto|scroll)/.test(t.css(this,\"overflow\")+t.css(this,\"overflow-y\")+t.css(this,\"overflow-x\"))}).eq(0):this.parents().filter(function(){return/(auto|scroll)/.test(t.css(this,\"overflow\")+t.css(this,\"overflow-y\")+t.css(this,\"overflow-x\"))}).eq(0),/fixed/.test(this.css(\"position\"))||!e.length?t(document):e},zIndex:function(i){if(i!==e)return this.css(\"zIndex\",i);if(this.length)for(var s,n,o=t(this[0]);o.length&&o[0]!==document;){if(s=o.css(\"position\"),(\"absolute\"===s||\"relative\"===s||\"fixed\"===s)&&(n=parseInt(o.css(\"zIndex\"),10),!isNaN(n)&&0!==n))return n;o=o.parent()}return 0},uniqueId:function(){return this.each(function(){this.id||(this.id=\"ui-id-\"+ ++n)})},removeUniqueId:function(){return this.each(function(){o.test(this.id)&&t(this).removeAttr(\"id\")})}}),t.extend(t.expr[\":\"],{data:t.expr.createPseudo?t.expr.createPseudo(function(e){return function(i){return!!t.data(i,e)}}):function(e,i,s){return!!t.data(e,s[3])},focusable:function(e){return i(e,!isNaN(t.attr(e,\"tabindex\")))},tabbable:function(e){var s=t.attr(e,\"tabindex\"),n=isNaN(s);return(n||s>=0)&&i(e,!n)}}),t(\"<a>\").outerWidth(1).jquery||t.each([\"Width\",\"Height\"],function(i,s){function n(e,i,s,n){return t.each(o,function(){i-=parseFloat(t.css(e,\"padding\"+this))||0,s&&(i-=parseFloat(t.css(e,\"border\"+this+\"Width\"))||0),n&&(i-=parseFloat(t.css(e,\"margin\"+this))||0)}),i}var o=\"Width\"===s?[\"Left\",\"Right\"]:[\"Top\",\"Bottom\"],a=s.toLowerCase(),r={innerWidth:t.fn.innerWidth,innerHeight:t.fn.innerHeight,outerWidth:t.fn.outerWidth,outerHeight:t.fn.outerHeight};t.fn[\"inner\"+s]=function(i){return i===e?r[\"inner\"+s].call(this):this.each(function(){t(this).css(a,n(this,i)+\"px\")})},t.fn[\"outer\"+s]=function(e,i){return\"number\"!=typeof e?r[\"outer\"+s].call(this,e):this.each(function(){t(this).css(a,n(this,e,!0,i)+\"px\")})}}),t.fn.addBack||(t.fn.addBack=function(t){return this.add(null==t?this.prevObject:this.prevObject.filter(t))}),t(\"<a>\").data(\"a-b\",\"a\").removeData(\"a-b\").data(\"a-b\")&&(t.fn.removeData=function(e){return function(i){return arguments.length?e.call(this,t.camelCase(i)):e.call(this)}}(t.fn.removeData)),t.ui.ie=!!/msie [\\w.]+/.exec(navigator.userAgent.toLowerCase()),t.support.selectstart=\"onselectstart\"in document.createElement(\"div\"),t.fn.extend({disableSelection:function(){return this.bind((t.support.selectstart?\"selectstart\":\"mousedown\")+\".ui-disableSelection\",function(t){t.preventDefault()})},enableSelection:function(){return this.unbind(\".ui-disableSelection\")}}),t.extend(t.ui,{plugin:{add:function(e,i,s){var n,o=t.ui[e].prototype;for(n in s)o.plugins[n]=o.plugins[n]||[],o.plugins[n].push([i,s[n]])},call:function(t,e,i){var s,n=t.plugins[e];if(n&&t.element[0].parentNode&&11!==t.element[0].parentNode.nodeType)for(s=0;n.length>s;s++)t.options[n[s][0]]&&n[s][1].apply(t.element,i)}},hasScroll:function(e,i){if(\"hidden\"===t(e).css(\"overflow\"))return!1;var s=i&&\"left\"===i?\"scrollLeft\":\"scrollTop\",n=!1;return e[s]>0?!0:(e[s]=1,n=e[s]>0,e[s]=0,n)}})})(jQuery),function(t,e){var i=0,s=Array.prototype.slice,n=t.cleanData;t.cleanData=function(e){for(var i,s=0;null!=(i=e[s]);s++)try{t(i).triggerHandler(\"remove\")}catch(o){}n(e)},t.widget=function(i,s,n){var o,a,r,h,l={},c=i.split(\".\")[0];i=i.split(\".\")[1],o=c+\"-\"+i,n||(n=s,s=t.Widget),t.expr[\":\"][o.toLowerCase()]=function(e){return!!t.data(e,o)},t[c]=t[c]||{},a=t[c][i],r=t[c][i]=function(t,i){return this._createWidget?(arguments.length&&this._createWidget(t,i),e):new r(t,i)},t.extend(r,a,{version:n.version,_proto:t.extend({},n),_childConstructors:[]}),h=new s,h.options=t.widget.extend({},h.options),t.each(n,function(i,n){return t.isFunction(n)?(l[i]=function(){var t=function(){return s.prototype[i].apply(this,arguments)},e=function(t){return s.prototype[i].apply(this,t)};return function(){var i,s=this._super,o=this._superApply;return this._super=t,this._superApply=e,i=n.apply(this,arguments),this._super=s,this._superApply=o,i}}(),e):(l[i]=n,e)}),r.prototype=t.widget.extend(h,{widgetEventPrefix:a?h.widgetEventPrefix:i},l,{constructor:r,namespace:c,widgetName:i,widgetFullName:o}),a?(t.each(a._childConstructors,function(e,i){var s=i.prototype;t.widget(s.namespace+\".\"+s.widgetName,r,i._proto)}),delete a._childConstructors):s._childConstructors.push(r),t.widget.bridge(i,r)},t.widget.extend=function(i){for(var n,o,a=s.call(arguments,1),r=0,h=a.length;h>r;r++)for(n in a[r])o=a[r][n],a[r].hasOwnProperty(n)&&o!==e&&(i[n]=t.isPlainObject(o)?t.isPlainObject(i[n])?t.widget.extend({},i[n],o):t.widget.extend({},o):o);return i},t.widget.bridge=function(i,n){var o=n.prototype.widgetFullName||i;t.fn[i]=function(a){var r=\"string\"==typeof a,h=s.call(arguments,1),l=this;return a=!r&&h.length?t.widget.extend.apply(null,[a].concat(h)):a,r?this.each(function(){var s,n=t.data(this,o);return n?t.isFunction(n[a])&&\"_\"!==a.charAt(0)?(s=n[a].apply(n,h),s!==n&&s!==e?(l=s&&s.jquery?l.pushStack(s.get()):s,!1):e):t.error(\"no such method '\"+a+\"' for \"+i+\" widget instance\"):t.error(\"cannot call methods on \"+i+\" prior to initialization; \"+\"attempted to call method '\"+a+\"'\")}):this.each(function(){var e=t.data(this,o);e?e.option(a||{})._init():t.data(this,o,new n(a,this))}),l}},t.Widget=function(){},t.Widget._childConstructors=[],t.Widget.prototype={widgetName:\"widget\",widgetEventPrefix:\"\",defaultElement:\"<div>\",options:{disabled:!1,create:null},_createWidget:function(e,s){s=t(s||this.defaultElement||this)[0],this.element=t(s),this.uuid=i++,this.eventNamespace=\".\"+this.widgetName+this.uuid,this.options=t.widget.extend({},this.options,this._getCreateOptions(),e),this.bindings=t(),this.hoverable=t(),this.focusable=t(),s!==this&&(t.data(s,this.widgetFullName,this),this._on(!0,this.element,{remove:function(t){t.target===s&&this.destroy()}}),this.document=t(s.style?s.ownerDocument:s.document||s),this.window=t(this.document[0].defaultView||this.document[0].parentWindow)),this._create(),this._trigger(\"create\",null,this._getCreateEventData()),this._init()},_getCreateOptions:t.noop,_getCreateEventData:t.noop,_create:t.noop,_init:t.noop,destroy:function(){this._destroy(),this.element.unbind(this.eventNamespace).removeData(this.widgetName).removeData(this.widgetFullName).removeData(t.camelCase(this.widgetFullName)),this.widget().unbind(this.eventNamespace).removeAttr(\"aria-disabled\").removeClass(this.widgetFullName+\"-disabled \"+\"ui-state-disabled\"),this.bindings.unbind(this.eventNamespace),this.hoverable.removeClass(\"ui-state-hover\"),this.focusable.removeClass(\"ui-state-focus\")},_destroy:t.noop,widget:function(){return this.element},option:function(i,s){var n,o,a,r=i;if(0===arguments.length)return t.widget.extend({},this.options);if(\"string\"==typeof i)if(r={},n=i.split(\".\"),i=n.shift(),n.length){for(o=r[i]=t.widget.extend({},this.options[i]),a=0;n.length-1>a;a++)o[n[a]]=o[n[a]]||{},o=o[n[a]];if(i=n.pop(),s===e)return o[i]===e?null:o[i];o[i]=s}else{if(s===e)return this.options[i]===e?null:this.options[i];r[i]=s}return this._setOptions(r),this},_setOptions:function(t){var e;for(e in t)this._setOption(e,t[e]);return this},_setOption:function(t,e){return this.options[t]=e,\"disabled\"===t&&(this.widget().toggleClass(this.widgetFullName+\"-disabled ui-state-disabled\",!!e).attr(\"aria-disabled\",e),this.hoverable.removeClass(\"ui-state-hover\"),this.focusable.removeClass(\"ui-state-focus\")),this},enable:function(){return this._setOption(\"disabled\",!1)},disable:function(){return this._setOption(\"disabled\",!0)},_on:function(i,s,n){var o,a=this;\"boolean\"!=typeof i&&(n=s,s=i,i=!1),n?(s=o=t(s),this.bindings=this.bindings.add(s)):(n=s,s=this.element,o=this.widget()),t.each(n,function(n,r){function h(){return i||a.options.disabled!==!0&&!t(this).hasClass(\"ui-state-disabled\")?(\"string\"==typeof r?a[r]:r).apply(a,arguments):e}\"string\"!=typeof r&&(h.guid=r.guid=r.guid||h.guid||t.guid++);var l=n.match(/^(\\w+)\\s*(.*)$/),c=l[1]+a.eventNamespace,u=l[2];u?o.delegate(u,c,h):s.bind(c,h)})},_off:function(t,e){e=(e||\"\").split(\" \").join(this.eventNamespace+\" \")+this.eventNamespace,t.unbind(e).undelegate(e)},_delay:function(t,e){function i(){return(\"string\"==typeof t?s[t]:t).apply(s,arguments)}var s=this;return setTimeout(i,e||0)},_hoverable:function(e){this.hoverable=this.hoverable.add(e),this._on(e,{mouseenter:function(e){t(e.currentTarget).addClass(\"ui-state-hover\")},mouseleave:function(e){t(e.currentTarget).removeClass(\"ui-state-hover\")}})},_focusable:function(e){this.focusable=this.focusable.add(e),this._on(e,{focusin:function(e){t(e.currentTarget).addClass(\"ui-state-focus\")},focusout:function(e){t(e.currentTarget).removeClass(\"ui-state-focus\")}})},_trigger:function(e,i,s){var n,o,a=this.options[e];if(s=s||{},i=t.Event(i),i.type=(e===this.widgetEventPrefix?e:this.widgetEventPrefix+e).toLowerCase(),i.target=this.element[0],o=i.originalEvent)for(n in o)n in i||(i[n]=o[n]);return this.element.trigger(i,s),!(t.isFunction(a)&&a.apply(this.element[0],[i].concat(s))===!1||i.isDefaultPrevented())}},t.each({show:\"fadeIn\",hide:\"fadeOut\"},function(e,i){t.Widget.prototype[\"_\"+e]=function(s,n,o){\"string\"==typeof n&&(n={effect:n});var a,r=n?n===!0||\"number\"==typeof n?i:n.effect||i:e;n=n||{},\"number\"==typeof n&&(n={duration:n}),a=!t.isEmptyObject(n),n.complete=o,n.delay&&s.delay(n.delay),a&&t.effects&&t.effects.effect[r]?s[e](n):r!==e&&s[r]?s[r](n.duration,n.easing,o):s.queue(function(i){t(this)[e](),o&&o.call(s[0]),i()})}})}(jQuery),function(t){var e=!1;t(document).mouseup(function(){e=!1}),t.widget(\"ui.mouse\",{version:\"1.10.2\",options:{cancel:\"input,textarea,button,select,option\",distance:1,delay:0},_mouseInit:function(){var e=this;this.element.bind(\"mousedown.\"+this.widgetName,function(t){return e._mouseDown(t)}).bind(\"click.\"+this.widgetName,function(i){return!0===t.data(i.target,e.widgetName+\".preventClickEvent\")?(t.removeData(i.target,e.widgetName+\".preventClickEvent\"),i.stopImmediatePropagation(),!1):undefined}),this.started=!1},_mouseDestroy:function(){this.element.unbind(\".\"+this.widgetName),this._mouseMoveDelegate&&t(document).unbind(\"mousemove.\"+this.widgetName,this._mouseMoveDelegate).unbind(\"mouseup.\"+this.widgetName,this._mouseUpDelegate)},_mouseDown:function(i){if(!e){this._mouseStarted&&this._mouseUp(i),this._mouseDownEvent=i;var s=this,n=1===i.which,o=\"string\"==typeof this.options.cancel&&i.target.nodeName?t(i.target).closest(this.options.cancel).length:!1;return n&&!o&&this._mouseCapture(i)?(this.mouseDelayMet=!this.options.delay,this.mouseDelayMet||(this._mouseDelayTimer=setTimeout(function(){s.mouseDelayMet=!0},this.options.delay)),this._mouseDistanceMet(i)&&this._mouseDelayMet(i)&&(this._mouseStarted=this._mouseStart(i)!==!1,!this._mouseStarted)?(i.preventDefault(),!0):(!0===t.data(i.target,this.widgetName+\".preventClickEvent\")&&t.removeData(i.target,this.widgetName+\".preventClickEvent\"),this._mouseMoveDelegate=function(t){return s._mouseMove(t)},this._mouseUpDelegate=function(t){return s._mouseUp(t)},t(document).bind(\"mousemove.\"+this.widgetName,this._mouseMoveDelegate).bind(\"mouseup.\"+this.widgetName,this._mouseUpDelegate),i.preventDefault(),e=!0,!0)):!0}},_mouseMove:function(e){return t.ui.ie&&(!document.documentMode||9>document.documentMode)&&!e.button?this._mouseUp(e):this._mouseStarted?(this._mouseDrag(e),e.preventDefault()):(this._mouseDistanceMet(e)&&this._mouseDelayMet(e)&&(this._mouseStarted=this._mouseStart(this._mouseDownEvent,e)!==!1,this._mouseStarted?this._mouseDrag(e):this._mouseUp(e)),!this._mouseStarted)},_mouseUp:function(e){return t(document).unbind(\"mousemove.\"+this.widgetName,this._mouseMoveDelegate).unbind(\"mouseup.\"+this.widgetName,this._mouseUpDelegate),this._mouseStarted&&(this._mouseStarted=!1,e.target===this._mouseDownEvent.target&&t.data(e.target,this.widgetName+\".preventClickEvent\",!0),this._mouseStop(e)),!1},_mouseDistanceMet:function(t){return Math.max(Math.abs(this._mouseDownEvent.pageX-t.pageX),Math.abs(this._mouseDownEvent.pageY-t.pageY))>=this.options.distance},_mouseDelayMet:function(){return this.mouseDelayMet},_mouseStart:function(){},_mouseDrag:function(){},_mouseStop:function(){},_mouseCapture:function(){return!0}})}(jQuery),function(t){t.widget(\"ui.draggable\",t.ui.mouse,{version:\"1.10.2\",widgetEventPrefix:\"drag\",options:{addClasses:!0,appendTo:\"parent\",axis:!1,connectToSortable:!1,containment:!1,cursor:\"auto\",cursorAt:!1,grid:!1,handle:!1,helper:\"original\",iframeFix:!1,opacity:!1,refreshPositions:!1,revert:!1,revertDuration:500,scope:\"default\",scroll:!0,scrollSensitivity:20,scrollSpeed:20,snap:!1,snapMode:\"both\",snapTolerance:20,stack:!1,zIndex:!1,drag:null,start:null,stop:null},_create:function(){\"original\"!==this.options.helper||/^(?:r|a|f)/.test(this.element.css(\"position\"))||(this.element[0].style.position=\"relative\"),this.options.addClasses&&this.element.addClass(\"ui-draggable\"),this.options.disabled&&this.element.addClass(\"ui-draggable-disabled\"),this._mouseInit()},_destroy:function(){this.element.removeClass(\"ui-draggable ui-draggable-dragging ui-draggable-disabled\"),this._mouseDestroy()},_mouseCapture:function(e){var i=this.options;return this.helper||i.disabled||t(e.target).closest(\".ui-resizable-handle\").length>0?!1:(this.handle=this._getHandle(e),this.handle?(t(i.iframeFix===!0?\"iframe\":i.iframeFix).each(function(){t(\"<div class='ui-draggable-iframeFix' style='background: #fff;'></div>\").css({width:this.offsetWidth+\"px\",height:this.offsetHeight+\"px\",position:\"absolute\",opacity:\"0.001\",zIndex:1e3}).css(t(this).offset()).appendTo(\"body\")}),!0):!1)},_mouseStart:function(e){var i=this.options;return this.helper=this._createHelper(e),this.helper.addClass(\"ui-draggable-dragging\"),this._cacheHelperProportions(),t.ui.ddmanager&&(t.ui.ddmanager.current=this),this._cacheMargins(),this.cssPosition=this.helper.css(\"position\"),this.scrollParent=this.helper.scrollParent(),this.offset=this.positionAbs=this.element.offset(),this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left},t.extend(this.offset,{click:{left:e.pageX-this.offset.left,top:e.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()}),this.originalPosition=this.position=this._generatePosition(e),this.originalPageX=e.pageX,this.originalPageY=e.pageY,i.cursorAt&&this._adjustOffsetFromHelper(i.cursorAt),i.containment&&this._setContainment(),this._trigger(\"start\",e)===!1?(this._clear(),!1):(this._cacheHelperProportions(),t.ui.ddmanager&&!i.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e),this._mouseDrag(e,!0),t.ui.ddmanager&&t.ui.ddmanager.dragStart(this,e),!0)},_mouseDrag:function(e,i){if(this.position=this._generatePosition(e),this.positionAbs=this._convertPositionTo(\"absolute\"),!i){var s=this._uiHash();if(this._trigger(\"drag\",e,s)===!1)return this._mouseUp({}),!1;this.position=s.position}return this.options.axis&&\"y\"===this.options.axis||(this.helper[0].style.left=this.position.left+\"px\"),this.options.axis&&\"x\"===this.options.axis||(this.helper[0].style.top=this.position.top+\"px\"),t.ui.ddmanager&&t.ui.ddmanager.drag(this,e),!1},_mouseStop:function(e){var i,s=this,n=!1,o=!1;for(t.ui.ddmanager&&!this.options.dropBehaviour&&(o=t.ui.ddmanager.drop(this,e)),this.dropped&&(o=this.dropped,this.dropped=!1),i=this.element[0];i&&(i=i.parentNode);)i===document&&(n=!0);return n||\"original\"!==this.options.helper?(\"invalid\"===this.options.revert&&!o||\"valid\"===this.options.revert&&o||this.options.revert===!0||t.isFunction(this.options.revert)&&this.options.revert.call(this.element,o)?t(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){s._trigger(\"stop\",e)!==!1&&s._clear()}):this._trigger(\"stop\",e)!==!1&&this._clear(),!1):!1},_mouseUp:function(e){return t(\"div.ui-draggable-iframeFix\").each(function(){this.parentNode.removeChild(this)}),t.ui.ddmanager&&t.ui.ddmanager.dragStop(this,e),t.ui.mouse.prototype._mouseUp.call(this,e)},cancel:function(){return this.helper.is(\".ui-draggable-dragging\")?this._mouseUp({}):this._clear(),this},_getHandle:function(e){return this.options.handle?!!t(e.target).closest(this.element.find(this.options.handle)).length:!0},_createHelper:function(e){var i=this.options,s=t.isFunction(i.helper)?t(i.helper.apply(this.element[0],[e])):\"clone\"===i.helper?this.element.clone().removeAttr(\"id\"):this.element;return s.parents(\"body\").length||s.appendTo(\"parent\"===i.appendTo?this.element[0].parentNode:i.appendTo),s[0]===this.element[0]||/(fixed|absolute)/.test(s.css(\"position\"))||s.css(\"position\",\"absolute\"),s},_adjustOffsetFromHelper:function(e){\"string\"==typeof e&&(e=e.split(\" \")),t.isArray(e)&&(e={left:+e[0],top:+e[1]||0}),\"left\"in e&&(this.offset.click.left=e.left+this.margins.left),\"right\"in e&&(this.offset.click.left=this.helperProportions.width-e.right+this.margins.left),\"top\"in e&&(this.offset.click.top=e.top+this.margins.top),\"bottom\"in e&&(this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top)},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var e=this.offsetParent.offset();return\"absolute\"===this.cssPosition&&this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])&&(e.left+=this.scrollParent.scrollLeft(),e.top+=this.scrollParent.scrollTop()),(this.offsetParent[0]===document.body||this.offsetParent[0].tagName&&\"html\"===this.offsetParent[0].tagName.toLowerCase()&&t.ui.ie)&&(e={top:0,left:0}),{top:e.top+(parseInt(this.offsetParent.css(\"borderTopWidth\"),10)||0),left:e.left+(parseInt(this.offsetParent.css(\"borderLeftWidth\"),10)||0)}},_getRelativeOffset:function(){if(\"relative\"===this.cssPosition){var t=this.element.position();return{top:t.top-(parseInt(this.helper.css(\"top\"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css(\"left\"),10)||0)+this.scrollParent.scrollLeft()}}return{top:0,left:0}},_cacheMargins:function(){this.margins={left:parseInt(this.element.css(\"marginLeft\"),10)||0,top:parseInt(this.element.css(\"marginTop\"),10)||0,right:parseInt(this.element.css(\"marginRight\"),10)||0,bottom:parseInt(this.element.css(\"marginBottom\"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e,i,s,n=this.options;if(\"parent\"===n.containment&&(n.containment=this.helper[0].parentNode),(\"document\"===n.containment||\"window\"===n.containment)&&(this.containment=[\"document\"===n.containment?0:t(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,\"document\"===n.containment?0:t(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,(\"document\"===n.containment?0:t(window).scrollLeft())+t(\"document\"===n.containment?document:window).width()-this.helperProportions.width-this.margins.left,(\"document\"===n.containment?0:t(window).scrollTop())+(t(\"document\"===n.containment?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]),/^(document|window|parent)$/.test(n.containment)||n.containment.constructor===Array)n.containment.constructor===Array&&(this.containment=n.containment);else{if(i=t(n.containment),s=i[0],!s)return;e=\"hidden\"!==t(s).css(\"overflow\"),this.containment=[(parseInt(t(s).css(\"borderLeftWidth\"),10)||0)+(parseInt(t(s).css(\"paddingLeft\"),10)||0),(parseInt(t(s).css(\"borderTopWidth\"),10)||0)+(parseInt(t(s).css(\"paddingTop\"),10)||0),(e?Math.max(s.scrollWidth,s.offsetWidth):s.offsetWidth)-(parseInt(t(s).css(\"borderRightWidth\"),10)||0)-(parseInt(t(s).css(\"paddingRight\"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(e?Math.max(s.scrollHeight,s.offsetHeight):s.offsetHeight)-(parseInt(t(s).css(\"borderBottomWidth\"),10)||0)-(parseInt(t(s).css(\"paddingBottom\"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom],this.relative_container=i}},_convertPositionTo:function(e,i){i||(i=this.position);var s=\"absolute\"===e?1:-1,n=\"absolute\"!==this.cssPosition||this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,o=/(html|body)/i.test(n[0].tagName);return{top:i.top+this.offset.relative.top*s+this.offset.parent.top*s-(\"fixed\"===this.cssPosition?-this.scrollParent.scrollTop():o?0:n.scrollTop())*s,left:i.left+this.offset.relative.left*s+this.offset.parent.left*s-(\"fixed\"===this.cssPosition?-this.scrollParent.scrollLeft():o?0:n.scrollLeft())*s}},_generatePosition:function(e){var i,s,n,o,a=this.options,r=\"absolute\"!==this.cssPosition||this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,h=/(html|body)/i.test(r[0].tagName),l=e.pageX,c=e.pageY;return this.originalPosition&&(this.containment&&(this.relative_container?(s=this.relative_container.offset(),i=[this.containment[0]+s.left,this.containment[1]+s.top,this.containment[2]+s.left,this.containment[3]+s.top]):i=this.containment,e.pageX-this.offset.click.left<i[0]&&(l=i[0]+this.offset.click.left),e.pageY-this.offset.click.top<i[1]&&(c=i[1]+this.offset.click.top),e.pageX-this.offset.click.left>i[2]&&(l=i[2]+this.offset.click.left),e.pageY-this.offset.click.top>i[3]&&(c=i[3]+this.offset.click.top)),a.grid&&(n=a.grid[1]?this.originalPageY+Math.round((c-this.originalPageY)/a.grid[1])*a.grid[1]:this.originalPageY,c=i?n-this.offset.click.top>=i[1]||n-this.offset.click.top>i[3]?n:n-this.offset.click.top>=i[1]?n-a.grid[1]:n+a.grid[1]:n,o=a.grid[0]?this.originalPageX+Math.round((l-this.originalPageX)/a.grid[0])*a.grid[0]:this.originalPageX,l=i?o-this.offset.click.left>=i[0]||o-this.offset.click.left>i[2]?o:o-this.offset.click.left>=i[0]?o-a.grid[0]:o+a.grid[0]:o)),{top:c-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+(\"fixed\"===this.cssPosition?-this.scrollParent.scrollTop():h?0:r.scrollTop()),left:l-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+(\"fixed\"===this.cssPosition?-this.scrollParent.scrollLeft():h?0:r.scrollLeft())}},_clear:function(){this.helper.removeClass(\"ui-draggable-dragging\"),this.helper[0]===this.element[0]||this.cancelHelperRemoval||this.helper.remove(),this.helper=null,this.cancelHelperRemoval=!1},_trigger:function(e,i,s){return s=s||this._uiHash(),t.ui.plugin.call(this,e,[i,s]),\"drag\"===e&&(this.positionAbs=this._convertPositionTo(\"absolute\")),t.Widget.prototype._trigger.call(this,e,i,s)},plugins:{},_uiHash:function(){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}}),t.ui.plugin.add(\"draggable\",\"connectToSortable\",{start:function(e,i){var s=t(this).data(\"ui-draggable\"),n=s.options,o=t.extend({},i,{item:s.element});s.sortables=[],t(n.connectToSortable).each(function(){var i=t.data(this,\"ui-sortable\");i&&!i.options.disabled&&(s.sortables.push({instance:i,shouldRevert:i.options.revert}),i.refreshPositions(),i._trigger(\"activate\",e,o))})},stop:function(e,i){var s=t(this).data(\"ui-draggable\"),n=t.extend({},i,{item:s.element});t.each(s.sortables,function(){this.instance.isOver?(this.instance.isOver=0,s.cancelHelperRemoval=!0,this.instance.cancelHelperRemoval=!1,this.shouldRevert&&(this.instance.options.revert=this.shouldRevert),this.instance._mouseStop(e),this.instance.options.helper=this.instance.options._helper,\"original\"===s.options.helper&&this.instance.currentItem.css({top:\"auto\",left:\"auto\"})):(this.instance.cancelHelperRemoval=!1,this.instance._trigger(\"deactivate\",e,n))})},drag:function(e,i){var s=t(this).data(\"ui-draggable\"),n=this;t.each(s.sortables,function(){var o=!1,a=this;this.instance.positionAbs=s.positionAbs,this.instance.helperProportions=s.helperProportions,this.instance.offset.click=s.offset.click,this.instance._intersectsWith(this.instance.containerCache)&&(o=!0,t.each(s.sortables,function(){return this.instance.positionAbs=s.positionAbs,this.instance.helperProportions=s.helperProportions,this.instance.offset.click=s.offset.click,this!==a&&this.instance._intersectsWith(this.instance.containerCache)&&t.contains(a.instance.element[0],this.instance.element[0])&&(o=!1),o})),o?(this.instance.isOver||(this.instance.isOver=1,this.instance.currentItem=t(n).clone().removeAttr(\"id\").appendTo(this.instance.element).data(\"ui-sortable-item\",!0),this.instance.options._helper=this.instance.options.helper,this.instance.options.helper=function(){return i.helper[0]},e.target=this.instance.currentItem[0],this.instance._mouseCapture(e,!0),this.instance._mouseStart(e,!0,!0),this.instance.offset.click.top=s.offset.click.top,this.instance.offset.click.left=s.offset.click.left,this.instance.offset.parent.left-=s.offset.parent.left-this.instance.offset.parent.left,this.instance.offset.parent.top-=s.offset.parent.top-this.instance.offset.parent.top,s._trigger(\"toSortable\",e),s.dropped=this.instance.element,s.currentItem=s.element,this.instance.fromOutside=s),this.instance.currentItem&&this.instance._mouseDrag(e)):this.instance.isOver&&(this.instance.isOver=0,this.instance.cancelHelperRemoval=!0,this.instance.options.revert=!1,this.instance._trigger(\"out\",e,this.instance._uiHash(this.instance)),this.instance._mouseStop(e,!0),this.instance.options.helper=this.instance.options._helper,this.instance.currentItem.remove(),this.instance.placeholder&&this.instance.placeholder.remove(),s._trigger(\"fromSortable\",e),s.dropped=!1)})}}),t.ui.plugin.add(\"draggable\",\"cursor\",{start:function(){var e=t(\"body\"),i=t(this).data(\"ui-draggable\").options;e.css(\"cursor\")&&(i._cursor=e.css(\"cursor\")),e.css(\"cursor\",i.cursor)},stop:function(){var e=t(this).data(\"ui-draggable\").options;e._cursor&&t(\"body\").css(\"cursor\",e._cursor)}}),t.ui.plugin.add(\"draggable\",\"opacity\",{start:function(e,i){var s=t(i.helper),n=t(this).data(\"ui-draggable\").options;s.css(\"opacity\")&&(n._opacity=s.css(\"opacity\")),s.css(\"opacity\",n.opacity)},stop:function(e,i){var s=t(this).data(\"ui-draggable\").options;s._opacity&&t(i.helper).css(\"opacity\",s._opacity)}}),t.ui.plugin.add(\"draggable\",\"scroll\",{start:function(){var e=t(this).data(\"ui-draggable\");e.scrollParent[0]!==document&&\"HTML\"!==e.scrollParent[0].tagName&&(e.overflowOffset=e.scrollParent.offset())},drag:function(e){var i=t(this).data(\"ui-draggable\"),s=i.options,n=!1;i.scrollParent[0]!==document&&\"HTML\"!==i.scrollParent[0].tagName?(s.axis&&\"x\"===s.axis||(i.overflowOffset.top+i.scrollParent[0].offsetHeight-e.pageY<s.scrollSensitivity?i.scrollParent[0].scrollTop=n=i.scrollParent[0].scrollTop+s.scrollSpeed:e.pageY-i.overflowOffset.top<s.scrollSensitivity&&(i.scrollParent[0].scrollTop=n=i.scrollParent[0].scrollTop-s.scrollSpeed)),s.axis&&\"y\"===s.axis||(i.overflowOffset.left+i.scrollParent[0].offsetWidth-e.pageX<s.scrollSensitivity?i.scrollParent[0].scrollLeft=n=i.scrollParent[0].scrollLeft+s.scrollSpeed:e.pageX-i.overflowOffset.left<s.scrollSensitivity&&(i.scrollParent[0].scrollLeft=n=i.scrollParent[0].scrollLeft-s.scrollSpeed))):(s.axis&&\"x\"===s.axis||(e.pageY-t(document).scrollTop()<s.scrollSensitivity?n=t(document).scrollTop(t(document).scrollTop()-s.scrollSpeed):t(window).height()-(e.pageY-t(document).scrollTop())<s.scrollSensitivity&&(n=t(document).scrollTop(t(document).scrollTop()+s.scrollSpeed))),s.axis&&\"y\"===s.axis||(e.pageX-t(document).scrollLeft()<s.scrollSensitivity?n=t(document).scrollLeft(t(document).scrollLeft()-s.scrollSpeed):t(window).width()-(e.pageX-t(document).scrollLeft())<s.scrollSensitivity&&(n=t(document).scrollLeft(t(document).scrollLeft()+s.scrollSpeed)))),n!==!1&&t.ui.ddmanager&&!s.dropBehaviour&&t.ui.ddmanager.prepareOffsets(i,e)}}),t.ui.plugin.add(\"draggable\",\"snap\",{start:function(){var e=t(this).data(\"ui-draggable\"),i=e.options;e.snapElements=[],t(i.snap.constructor!==String?i.snap.items||\":data(ui-draggable)\":i.snap).each(function(){var i=t(this),s=i.offset();this!==e.element[0]&&e.snapElements.push({item:this,width:i.outerWidth(),height:i.outerHeight(),top:s.top,left:s.left})})},drag:function(e,i){var s,n,o,a,r,h,l,c,u,d,p=t(this).data(\"ui-draggable\"),f=p.options,g=f.snapTolerance,m=i.offset.left,v=m+p.helperProportions.width,_=i.offset.top,b=_+p.helperProportions.height;for(u=p.snapElements.length-1;u>=0;u--)r=p.snapElements[u].left,h=r+p.snapElements[u].width,l=p.snapElements[u].top,c=l+p.snapElements[u].height,m>r-g&&h+g>m&&_>l-g&&c+g>_||m>r-g&&h+g>m&&b>l-g&&c+g>b||v>r-g&&h+g>v&&_>l-g&&c+g>_||v>r-g&&h+g>v&&b>l-g&&c+g>b?(\"inner\"!==f.snapMode&&(s=g>=Math.abs(l-b),n=g>=Math.abs(c-_),o=g>=Math.abs(r-v),a=g>=Math.abs(h-m),s&&(i.position.top=p._convertPositionTo(\"relative\",{top:l-p.helperProportions.height,left:0}).top-p.margins.top),n&&(i.position.top=p._convertPositionTo(\"relative\",{top:c,left:0}).top-p.margins.top),o&&(i.position.left=p._convertPositionTo(\"relative\",{top:0,left:r-p.helperProportions.width}).left-p.margins.left),a&&(i.position.left=p._convertPositionTo(\"relative\",{top:0,left:h}).left-p.margins.left)),d=s||n||o||a,\"outer\"!==f.snapMode&&(s=g>=Math.abs(l-_),n=g>=Math.abs(c-b),o=g>=Math.abs(r-m),a=g>=Math.abs(h-v),s&&(i.position.top=p._convertPositionTo(\"relative\",{top:l,left:0}).top-p.margins.top),n&&(i.position.top=p._convertPositionTo(\"relative\",{top:c-p.helperProportions.height,left:0}).top-p.margins.top),o&&(i.position.left=p._convertPositionTo(\"relative\",{top:0,left:r}).left-p.margins.left),a&&(i.position.left=p._convertPositionTo(\"relative\",{top:0,left:h-p.helperProportions.width}).left-p.margins.left)),!p.snapElements[u].snapping&&(s||n||o||a||d)&&p.options.snap.snap&&p.options.snap.snap.call(p.element,e,t.extend(p._uiHash(),{snapItem:p.snapElements[u].item})),p.snapElements[u].snapping=s||n||o||a||d):(p.snapElements[u].snapping&&p.options.snap.release&&p.options.snap.release.call(p.element,e,t.extend(p._uiHash(),{snapItem:p.snapElements[u].item})),p.snapElements[u].snapping=!1)}}),t.ui.plugin.add(\"draggable\",\"stack\",{start:function(){var e,i=this.data(\"ui-draggable\").options,s=t.makeArray(t(i.stack)).sort(function(e,i){return(parseInt(t(e).css(\"zIndex\"),10)||0)-(parseInt(t(i).css(\"zIndex\"),10)||0)});s.length&&(e=parseInt(t(s[0]).css(\"zIndex\"),10)||0,t(s).each(function(i){t(this).css(\"zIndex\",e+i)}),this.css(\"zIndex\",e+s.length))}}),t.ui.plugin.add(\"draggable\",\"zIndex\",{start:function(e,i){var s=t(i.helper),n=t(this).data(\"ui-draggable\").options;s.css(\"zIndex\")&&(n._zIndex=s.css(\"zIndex\")),s.css(\"zIndex\",n.zIndex)},stop:function(e,i){var s=t(this).data(\"ui-draggable\").options;s._zIndex&&t(i.helper).css(\"zIndex\",s._zIndex)}})}(jQuery),function(t){function e(t,e,i){return t>e&&e+i>t}t.widget(\"ui.droppable\",{version:\"1.10.2\",widgetEventPrefix:\"drop\",options:{accept:\"*\",activeClass:!1,addClasses:!0,greedy:!1,hoverClass:!1,scope:\"default\",tolerance:\"intersect\",activate:null,deactivate:null,drop:null,out:null,over:null},_create:function(){var e=this.options,i=e.accept;this.isover=!1,this.isout=!0,this.accept=t.isFunction(i)?i:function(t){return t.is(i)},this.proportions={width:this.element[0].offsetWidth,height:this.element[0].offsetHeight},t.ui.ddmanager.droppables[e.scope]=t.ui.ddmanager.droppables[e.scope]||[],t.ui.ddmanager.droppables[e.scope].push(this),e.addClasses&&this.element.addClass(\"ui-droppable\")\n},_destroy:function(){for(var e=0,i=t.ui.ddmanager.droppables[this.options.scope];i.length>e;e++)i[e]===this&&i.splice(e,1);this.element.removeClass(\"ui-droppable ui-droppable-disabled\")},_setOption:function(e,i){\"accept\"===e&&(this.accept=t.isFunction(i)?i:function(t){return t.is(i)}),t.Widget.prototype._setOption.apply(this,arguments)},_activate:function(e){var i=t.ui.ddmanager.current;this.options.activeClass&&this.element.addClass(this.options.activeClass),i&&this._trigger(\"activate\",e,this.ui(i))},_deactivate:function(e){var i=t.ui.ddmanager.current;this.options.activeClass&&this.element.removeClass(this.options.activeClass),i&&this._trigger(\"deactivate\",e,this.ui(i))},_over:function(e){var i=t.ui.ddmanager.current;i&&(i.currentItem||i.element)[0]!==this.element[0]&&this.accept.call(this.element[0],i.currentItem||i.element)&&(this.options.hoverClass&&this.element.addClass(this.options.hoverClass),this._trigger(\"over\",e,this.ui(i)))},_out:function(e){var i=t.ui.ddmanager.current;i&&(i.currentItem||i.element)[0]!==this.element[0]&&this.accept.call(this.element[0],i.currentItem||i.element)&&(this.options.hoverClass&&this.element.removeClass(this.options.hoverClass),this._trigger(\"out\",e,this.ui(i)))},_drop:function(e,i){var s=i||t.ui.ddmanager.current,n=!1;return s&&(s.currentItem||s.element)[0]!==this.element[0]?(this.element.find(\":data(ui-droppable)\").not(\".ui-draggable-dragging\").each(function(){var e=t.data(this,\"ui-droppable\");return e.options.greedy&&!e.options.disabled&&e.options.scope===s.options.scope&&e.accept.call(e.element[0],s.currentItem||s.element)&&t.ui.intersect(s,t.extend(e,{offset:e.element.offset()}),e.options.tolerance)?(n=!0,!1):undefined}),n?!1:this.accept.call(this.element[0],s.currentItem||s.element)?(this.options.activeClass&&this.element.removeClass(this.options.activeClass),this.options.hoverClass&&this.element.removeClass(this.options.hoverClass),this._trigger(\"drop\",e,this.ui(s)),this.element):!1):!1},ui:function(t){return{draggable:t.currentItem||t.element,helper:t.helper,position:t.position,offset:t.positionAbs}}}),t.ui.intersect=function(t,i,s){if(!i.offset)return!1;var n,o,a=(t.positionAbs||t.position.absolute).left,r=a+t.helperProportions.width,h=(t.positionAbs||t.position.absolute).top,l=h+t.helperProportions.height,c=i.offset.left,u=c+i.proportions.width,d=i.offset.top,p=d+i.proportions.height;switch(s){case\"fit\":return a>=c&&u>=r&&h>=d&&p>=l;case\"intersect\":return a+t.helperProportions.width/2>c&&u>r-t.helperProportions.width/2&&h+t.helperProportions.height/2>d&&p>l-t.helperProportions.height/2;case\"pointer\":return n=(t.positionAbs||t.position.absolute).left+(t.clickOffset||t.offset.click).left,o=(t.positionAbs||t.position.absolute).top+(t.clickOffset||t.offset.click).top,e(o,d,i.proportions.height)&&e(n,c,i.proportions.width);case\"touch\":return(h>=d&&p>=h||l>=d&&p>=l||d>h&&l>p)&&(a>=c&&u>=a||r>=c&&u>=r||c>a&&r>u);default:return!1}},t.ui.ddmanager={current:null,droppables:{\"default\":[]},prepareOffsets:function(e,i){var s,n,o=t.ui.ddmanager.droppables[e.options.scope]||[],a=i?i.type:null,r=(e.currentItem||e.element).find(\":data(ui-droppable)\").addBack();t:for(s=0;o.length>s;s++)if(!(o[s].options.disabled||e&&!o[s].accept.call(o[s].element[0],e.currentItem||e.element))){for(n=0;r.length>n;n++)if(r[n]===o[s].element[0]){o[s].proportions.height=0;continue t}o[s].visible=\"none\"!==o[s].element.css(\"display\"),o[s].visible&&(\"mousedown\"===a&&o[s]._activate.call(o[s],i),o[s].offset=o[s].element.offset(),o[s].proportions={width:o[s].element[0].offsetWidth,height:o[s].element[0].offsetHeight})}},drop:function(e,i){var s=!1;return t.each((t.ui.ddmanager.droppables[e.options.scope]||[]).slice(),function(){this.options&&(!this.options.disabled&&this.visible&&t.ui.intersect(e,this,this.options.tolerance)&&(s=this._drop.call(this,i)||s),!this.options.disabled&&this.visible&&this.accept.call(this.element[0],e.currentItem||e.element)&&(this.isout=!0,this.isover=!1,this._deactivate.call(this,i)))}),s},dragStart:function(e,i){e.element.parentsUntil(\"body\").bind(\"scroll.droppable\",function(){e.options.refreshPositions||t.ui.ddmanager.prepareOffsets(e,i)})},drag:function(e,i){e.options.refreshPositions&&t.ui.ddmanager.prepareOffsets(e,i),t.each(t.ui.ddmanager.droppables[e.options.scope]||[],function(){if(!this.options.disabled&&!this.greedyChild&&this.visible){var s,n,o,a=t.ui.intersect(e,this,this.options.tolerance),r=!a&&this.isover?\"isout\":a&&!this.isover?\"isover\":null;r&&(this.options.greedy&&(n=this.options.scope,o=this.element.parents(\":data(ui-droppable)\").filter(function(){return t.data(this,\"ui-droppable\").options.scope===n}),o.length&&(s=t.data(o[0],\"ui-droppable\"),s.greedyChild=\"isover\"===r)),s&&\"isover\"===r&&(s.isover=!1,s.isout=!0,s._out.call(s,i)),this[r]=!0,this[\"isout\"===r?\"isover\":\"isout\"]=!1,this[\"isover\"===r?\"_over\":\"_out\"].call(this,i),s&&\"isout\"===r&&(s.isout=!1,s.isover=!0,s._over.call(s,i)))}})},dragStop:function(e,i){e.element.parentsUntil(\"body\").unbind(\"scroll.droppable\"),e.options.refreshPositions||t.ui.ddmanager.prepareOffsets(e,i)}}}(jQuery),function(t){function e(t){return parseInt(t,10)||0}function i(t){return!isNaN(parseInt(t,10))}t.widget(\"ui.resizable\",t.ui.mouse,{version:\"1.10.2\",widgetEventPrefix:\"resize\",options:{alsoResize:!1,animate:!1,animateDuration:\"slow\",animateEasing:\"swing\",aspectRatio:!1,autoHide:!1,containment:!1,ghost:!1,grid:!1,handles:\"e,s,se\",helper:!1,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,zIndex:90,resize:null,start:null,stop:null},_create:function(){var e,i,s,n,o,a=this,r=this.options;if(this.element.addClass(\"ui-resizable\"),t.extend(this,{_aspectRatio:!!r.aspectRatio,aspectRatio:r.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:r.helper||r.ghost||r.animate?r.helper||\"ui-resizable-helper\":null}),this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)&&(this.element.wrap(t(\"<div class='ui-wrapper' style='overflow: hidden;'></div>\").css({position:this.element.css(\"position\"),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css(\"top\"),left:this.element.css(\"left\")})),this.element=this.element.parent().data(\"ui-resizable\",this.element.data(\"ui-resizable\")),this.elementIsWrapper=!0,this.element.css({marginLeft:this.originalElement.css(\"marginLeft\"),marginTop:this.originalElement.css(\"marginTop\"),marginRight:this.originalElement.css(\"marginRight\"),marginBottom:this.originalElement.css(\"marginBottom\")}),this.originalElement.css({marginLeft:0,marginTop:0,marginRight:0,marginBottom:0}),this.originalResizeStyle=this.originalElement.css(\"resize\"),this.originalElement.css(\"resize\",\"none\"),this._proportionallyResizeElements.push(this.originalElement.css({position:\"static\",zoom:1,display:\"block\"})),this.originalElement.css({margin:this.originalElement.css(\"margin\")}),this._proportionallyResize()),this.handles=r.handles||(t(\".ui-resizable-handle\",this.element).length?{n:\".ui-resizable-n\",e:\".ui-resizable-e\",s:\".ui-resizable-s\",w:\".ui-resizable-w\",se:\".ui-resizable-se\",sw:\".ui-resizable-sw\",ne:\".ui-resizable-ne\",nw:\".ui-resizable-nw\"}:\"e,s,se\"),this.handles.constructor===String)for(\"all\"===this.handles&&(this.handles=\"n,e,s,w,se,sw,ne,nw\"),e=this.handles.split(\",\"),this.handles={},i=0;e.length>i;i++)s=t.trim(e[i]),o=\"ui-resizable-\"+s,n=t(\"<div class='ui-resizable-handle \"+o+\"'></div>\"),n.css({zIndex:r.zIndex}),\"se\"===s&&n.addClass(\"ui-icon ui-icon-gripsmall-diagonal-se\"),this.handles[s]=\".ui-resizable-\"+s,this.element.append(n);this._renderAxis=function(e){var i,s,n,o;e=e||this.element;for(i in this.handles)this.handles[i].constructor===String&&(this.handles[i]=t(this.handles[i],this.element).show()),this.elementIsWrapper&&this.originalElement[0].nodeName.match(/textarea|input|select|button/i)&&(s=t(this.handles[i],this.element),o=/sw|ne|nw|se|n|s/.test(i)?s.outerHeight():s.outerWidth(),n=[\"padding\",/ne|nw|n/.test(i)?\"Top\":/se|sw|s/.test(i)?\"Bottom\":/^e$/.test(i)?\"Right\":\"Left\"].join(\"\"),e.css(n,o),this._proportionallyResize()),t(this.handles[i]).length},this._renderAxis(this.element),this._handles=t(\".ui-resizable-handle\",this.element).disableSelection(),this._handles.mouseover(function(){a.resizing||(this.className&&(n=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i)),a.axis=n&&n[1]?n[1]:\"se\")}),r.autoHide&&(this._handles.hide(),t(this.element).addClass(\"ui-resizable-autohide\").mouseenter(function(){r.disabled||(t(this).removeClass(\"ui-resizable-autohide\"),a._handles.show())}).mouseleave(function(){r.disabled||a.resizing||(t(this).addClass(\"ui-resizable-autohide\"),a._handles.hide())})),this._mouseInit()},_destroy:function(){this._mouseDestroy();var e,i=function(e){t(e).removeClass(\"ui-resizable ui-resizable-disabled ui-resizable-resizing\").removeData(\"resizable\").removeData(\"ui-resizable\").unbind(\".resizable\").find(\".ui-resizable-handle\").remove()};return this.elementIsWrapper&&(i(this.element),e=this.element,this.originalElement.css({position:e.css(\"position\"),width:e.outerWidth(),height:e.outerHeight(),top:e.css(\"top\"),left:e.css(\"left\")}).insertAfter(e),e.remove()),this.originalElement.css(\"resize\",this.originalResizeStyle),i(this.originalElement),this},_mouseCapture:function(e){var i,s,n=!1;for(i in this.handles)s=t(this.handles[i])[0],(s===e.target||t.contains(s,e.target))&&(n=!0);return!this.options.disabled&&n},_mouseStart:function(i){var s,n,o,a=this.options,r=this.element.position(),h=this.element;return this.resizing=!0,/absolute/.test(h.css(\"position\"))?h.css({position:\"absolute\",top:h.css(\"top\"),left:h.css(\"left\")}):h.is(\".ui-draggable\")&&h.css({position:\"absolute\",top:r.top,left:r.left}),this._renderProxy(),s=e(this.helper.css(\"left\")),n=e(this.helper.css(\"top\")),a.containment&&(s+=t(a.containment).scrollLeft()||0,n+=t(a.containment).scrollTop()||0),this.offset=this.helper.offset(),this.position={left:s,top:n},this.size=this._helper?{width:h.outerWidth(),height:h.outerHeight()}:{width:h.width(),height:h.height()},this.originalSize=this._helper?{width:h.outerWidth(),height:h.outerHeight()}:{width:h.width(),height:h.height()},this.originalPosition={left:s,top:n},this.sizeDiff={width:h.outerWidth()-h.width(),height:h.outerHeight()-h.height()},this.originalMousePosition={left:i.pageX,top:i.pageY},this.aspectRatio=\"number\"==typeof a.aspectRatio?a.aspectRatio:this.originalSize.width/this.originalSize.height||1,o=t(\".ui-resizable-\"+this.axis).css(\"cursor\"),t(\"body\").css(\"cursor\",\"auto\"===o?this.axis+\"-resize\":o),h.addClass(\"ui-resizable-resizing\"),this._propagate(\"start\",i),!0},_mouseDrag:function(e){var i,s=this.helper,n={},o=this.originalMousePosition,a=this.axis,r=this.position.top,h=this.position.left,l=this.size.width,c=this.size.height,u=e.pageX-o.left||0,d=e.pageY-o.top||0,p=this._change[a];return p?(i=p.apply(this,[e,u,d]),this._updateVirtualBoundaries(e.shiftKey),(this._aspectRatio||e.shiftKey)&&(i=this._updateRatio(i,e)),i=this._respectSize(i,e),this._updateCache(i),this._propagate(\"resize\",e),this.position.top!==r&&(n.top=this.position.top+\"px\"),this.position.left!==h&&(n.left=this.position.left+\"px\"),this.size.width!==l&&(n.width=this.size.width+\"px\"),this.size.height!==c&&(n.height=this.size.height+\"px\"),s.css(n),!this._helper&&this._proportionallyResizeElements.length&&this._proportionallyResize(),t.isEmptyObject(n)||this._trigger(\"resize\",e,this.ui()),!1):!1},_mouseStop:function(e){this.resizing=!1;var i,s,n,o,a,r,h,l=this.options,c=this;return this._helper&&(i=this._proportionallyResizeElements,s=i.length&&/textarea/i.test(i[0].nodeName),n=s&&t.ui.hasScroll(i[0],\"left\")?0:c.sizeDiff.height,o=s?0:c.sizeDiff.width,a={width:c.helper.width()-o,height:c.helper.height()-n},r=parseInt(c.element.css(\"left\"),10)+(c.position.left-c.originalPosition.left)||null,h=parseInt(c.element.css(\"top\"),10)+(c.position.top-c.originalPosition.top)||null,l.animate||this.element.css(t.extend(a,{top:h,left:r})),c.helper.height(c.size.height),c.helper.width(c.size.width),this._helper&&!l.animate&&this._proportionallyResize()),t(\"body\").css(\"cursor\",\"auto\"),this.element.removeClass(\"ui-resizable-resizing\"),this._propagate(\"stop\",e),this._helper&&this.helper.remove(),!1},_updateVirtualBoundaries:function(t){var e,s,n,o,a,r=this.options;a={minWidth:i(r.minWidth)?r.minWidth:0,maxWidth:i(r.maxWidth)?r.maxWidth:1/0,minHeight:i(r.minHeight)?r.minHeight:0,maxHeight:i(r.maxHeight)?r.maxHeight:1/0},(this._aspectRatio||t)&&(e=a.minHeight*this.aspectRatio,n=a.minWidth/this.aspectRatio,s=a.maxHeight*this.aspectRatio,o=a.maxWidth/this.aspectRatio,e>a.minWidth&&(a.minWidth=e),n>a.minHeight&&(a.minHeight=n),a.maxWidth>s&&(a.maxWidth=s),a.maxHeight>o&&(a.maxHeight=o)),this._vBoundaries=a},_updateCache:function(t){this.offset=this.helper.offset(),i(t.left)&&(this.position.left=t.left),i(t.top)&&(this.position.top=t.top),i(t.height)&&(this.size.height=t.height),i(t.width)&&(this.size.width=t.width)},_updateRatio:function(t){var e=this.position,s=this.size,n=this.axis;return i(t.height)?t.width=t.height*this.aspectRatio:i(t.width)&&(t.height=t.width/this.aspectRatio),\"sw\"===n&&(t.left=e.left+(s.width-t.width),t.top=null),\"nw\"===n&&(t.top=e.top+(s.height-t.height),t.left=e.left+(s.width-t.width)),t},_respectSize:function(t){var e=this._vBoundaries,s=this.axis,n=i(t.width)&&e.maxWidth&&e.maxWidth<t.width,o=i(t.height)&&e.maxHeight&&e.maxHeight<t.height,a=i(t.width)&&e.minWidth&&e.minWidth>t.width,r=i(t.height)&&e.minHeight&&e.minHeight>t.height,h=this.originalPosition.left+this.originalSize.width,l=this.position.top+this.size.height,c=/sw|nw|w/.test(s),u=/nw|ne|n/.test(s);return a&&(t.width=e.minWidth),r&&(t.height=e.minHeight),n&&(t.width=e.maxWidth),o&&(t.height=e.maxHeight),a&&c&&(t.left=h-e.minWidth),n&&c&&(t.left=h-e.maxWidth),r&&u&&(t.top=l-e.minHeight),o&&u&&(t.top=l-e.maxHeight),t.width||t.height||t.left||!t.top?t.width||t.height||t.top||!t.left||(t.left=null):t.top=null,t},_proportionallyResize:function(){if(this._proportionallyResizeElements.length){var t,e,i,s,n,o=this.helper||this.element;for(t=0;this._proportionallyResizeElements.length>t;t++){if(n=this._proportionallyResizeElements[t],!this.borderDif)for(this.borderDif=[],i=[n.css(\"borderTopWidth\"),n.css(\"borderRightWidth\"),n.css(\"borderBottomWidth\"),n.css(\"borderLeftWidth\")],s=[n.css(\"paddingTop\"),n.css(\"paddingRight\"),n.css(\"paddingBottom\"),n.css(\"paddingLeft\")],e=0;i.length>e;e++)this.borderDif[e]=(parseInt(i[e],10)||0)+(parseInt(s[e],10)||0);n.css({height:o.height()-this.borderDif[0]-this.borderDif[2]||0,width:o.width()-this.borderDif[1]-this.borderDif[3]||0})}}},_renderProxy:function(){var e=this.element,i=this.options;this.elementOffset=e.offset(),this._helper?(this.helper=this.helper||t(\"<div style='overflow:hidden;'></div>\"),this.helper.addClass(this._helper).css({width:this.element.outerWidth()-1,height:this.element.outerHeight()-1,position:\"absolute\",left:this.elementOffset.left+\"px\",top:this.elementOffset.top+\"px\",zIndex:++i.zIndex}),this.helper.appendTo(\"body\").disableSelection()):this.helper=this.element},_change:{e:function(t,e){return{width:this.originalSize.width+e}},w:function(t,e){var i=this.originalSize,s=this.originalPosition;return{left:s.left+e,width:i.width-e}},n:function(t,e,i){var s=this.originalSize,n=this.originalPosition;return{top:n.top+i,height:s.height-i}},s:function(t,e,i){return{height:this.originalSize.height+i}},se:function(e,i,s){return t.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[e,i,s]))},sw:function(e,i,s){return t.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[e,i,s]))},ne:function(e,i,s){return t.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[e,i,s]))},nw:function(e,i,s){return t.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[e,i,s]))}},_propagate:function(e,i){t.ui.plugin.call(this,e,[i,this.ui()]),\"resize\"!==e&&this._trigger(e,i,this.ui())},plugins:{},ui:function(){return{originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition}}}),t.ui.plugin.add(\"resizable\",\"animate\",{stop:function(e){var i=t(this).data(\"ui-resizable\"),s=i.options,n=i._proportionallyResizeElements,o=n.length&&/textarea/i.test(n[0].nodeName),a=o&&t.ui.hasScroll(n[0],\"left\")?0:i.sizeDiff.height,r=o?0:i.sizeDiff.width,h={width:i.size.width-r,height:i.size.height-a},l=parseInt(i.element.css(\"left\"),10)+(i.position.left-i.originalPosition.left)||null,c=parseInt(i.element.css(\"top\"),10)+(i.position.top-i.originalPosition.top)||null;i.element.animate(t.extend(h,c&&l?{top:c,left:l}:{}),{duration:s.animateDuration,easing:s.animateEasing,step:function(){var s={width:parseInt(i.element.css(\"width\"),10),height:parseInt(i.element.css(\"height\"),10),top:parseInt(i.element.css(\"top\"),10),left:parseInt(i.element.css(\"left\"),10)};n&&n.length&&t(n[0]).css({width:s.width,height:s.height}),i._updateCache(s),i._propagate(\"resize\",e)}})}}),t.ui.plugin.add(\"resizable\",\"containment\",{start:function(){var i,s,n,o,a,r,h,l=t(this).data(\"ui-resizable\"),c=l.options,u=l.element,d=c.containment,p=d instanceof t?d.get(0):/parent/.test(d)?u.parent().get(0):d;p&&(l.containerElement=t(p),/document/.test(d)||d===document?(l.containerOffset={left:0,top:0},l.containerPosition={left:0,top:0},l.parentData={element:t(document),left:0,top:0,width:t(document).width(),height:t(document).height()||document.body.parentNode.scrollHeight}):(i=t(p),s=[],t([\"Top\",\"Right\",\"Left\",\"Bottom\"]).each(function(t,n){s[t]=e(i.css(\"padding\"+n))}),l.containerOffset=i.offset(),l.containerPosition=i.position(),l.containerSize={height:i.innerHeight()-s[3],width:i.innerWidth()-s[1]},n=l.containerOffset,o=l.containerSize.height,a=l.containerSize.width,r=t.ui.hasScroll(p,\"left\")?p.scrollWidth:a,h=t.ui.hasScroll(p)?p.scrollHeight:o,l.parentData={element:p,left:n.left,top:n.top,width:r,height:h}))},resize:function(e){var i,s,n,o,a=t(this).data(\"ui-resizable\"),r=a.options,h=a.containerOffset,l=a.position,c=a._aspectRatio||e.shiftKey,u={top:0,left:0},d=a.containerElement;d[0]!==document&&/static/.test(d.css(\"position\"))&&(u=h),l.left<(a._helper?h.left:0)&&(a.size.width=a.size.width+(a._helper?a.position.left-h.left:a.position.left-u.left),c&&(a.size.height=a.size.width/a.aspectRatio),a.position.left=r.helper?h.left:0),l.top<(a._helper?h.top:0)&&(a.size.height=a.size.height+(a._helper?a.position.top-h.top:a.position.top),c&&(a.size.width=a.size.height*a.aspectRatio),a.position.top=a._helper?h.top:0),a.offset.left=a.parentData.left+a.position.left,a.offset.top=a.parentData.top+a.position.top,i=Math.abs((a._helper?a.offset.left-u.left:a.offset.left-u.left)+a.sizeDiff.width),s=Math.abs((a._helper?a.offset.top-u.top:a.offset.top-h.top)+a.sizeDiff.height),n=a.containerElement.get(0)===a.element.parent().get(0),o=/relative|absolute/.test(a.containerElement.css(\"position\")),n&&o&&(i-=a.parentData.left),i+a.size.width>=a.parentData.width&&(a.size.width=a.parentData.width-i,c&&(a.size.height=a.size.width/a.aspectRatio)),s+a.size.height>=a.parentData.height&&(a.size.height=a.parentData.height-s,c&&(a.size.width=a.size.height*a.aspectRatio))},stop:function(){var e=t(this).data(\"ui-resizable\"),i=e.options,s=e.containerOffset,n=e.containerPosition,o=e.containerElement,a=t(e.helper),r=a.offset(),h=a.outerWidth()-e.sizeDiff.width,l=a.outerHeight()-e.sizeDiff.height;e._helper&&!i.animate&&/relative/.test(o.css(\"position\"))&&t(this).css({left:r.left-n.left-s.left,width:h,height:l}),e._helper&&!i.animate&&/static/.test(o.css(\"position\"))&&t(this).css({left:r.left-n.left-s.left,width:h,height:l})}}),t.ui.plugin.add(\"resizable\",\"alsoResize\",{start:function(){var e=t(this).data(\"ui-resizable\"),i=e.options,s=function(e){t(e).each(function(){var e=t(this);e.data(\"ui-resizable-alsoresize\",{width:parseInt(e.width(),10),height:parseInt(e.height(),10),left:parseInt(e.css(\"left\"),10),top:parseInt(e.css(\"top\"),10)})})};\"object\"!=typeof i.alsoResize||i.alsoResize.parentNode?s(i.alsoResize):i.alsoResize.length?(i.alsoResize=i.alsoResize[0],s(i.alsoResize)):t.each(i.alsoResize,function(t){s(t)})},resize:function(e,i){var s=t(this).data(\"ui-resizable\"),n=s.options,o=s.originalSize,a=s.originalPosition,r={height:s.size.height-o.height||0,width:s.size.width-o.width||0,top:s.position.top-a.top||0,left:s.position.left-a.left||0},h=function(e,s){t(e).each(function(){var e=t(this),n=t(this).data(\"ui-resizable-alsoresize\"),o={},a=s&&s.length?s:e.parents(i.originalElement[0]).length?[\"width\",\"height\"]:[\"width\",\"height\",\"top\",\"left\"];t.each(a,function(t,e){var i=(n[e]||0)+(r[e]||0);i&&i>=0&&(o[e]=i||null)}),e.css(o)})};\"object\"!=typeof n.alsoResize||n.alsoResize.nodeType?h(n.alsoResize):t.each(n.alsoResize,function(t,e){h(t,e)})},stop:function(){t(this).removeData(\"resizable-alsoresize\")}}),t.ui.plugin.add(\"resizable\",\"ghost\",{start:function(){var e=t(this).data(\"ui-resizable\"),i=e.options,s=e.size;e.ghost=e.originalElement.clone(),e.ghost.css({opacity:.25,display:\"block\",position:\"relative\",height:s.height,width:s.width,margin:0,left:0,top:0}).addClass(\"ui-resizable-ghost\").addClass(\"string\"==typeof i.ghost?i.ghost:\"\"),e.ghost.appendTo(e.helper)},resize:function(){var e=t(this).data(\"ui-resizable\");e.ghost&&e.ghost.css({position:\"relative\",height:e.size.height,width:e.size.width})},stop:function(){var e=t(this).data(\"ui-resizable\");e.ghost&&e.helper&&e.helper.get(0).removeChild(e.ghost.get(0))}}),t.ui.plugin.add(\"resizable\",\"grid\",{resize:function(){var e=t(this).data(\"ui-resizable\"),i=e.options,s=e.size,n=e.originalSize,o=e.originalPosition,a=e.axis,r=\"number\"==typeof i.grid?[i.grid,i.grid]:i.grid,h=r[0]||1,l=r[1]||1,c=Math.round((s.width-n.width)/h)*h,u=Math.round((s.height-n.height)/l)*l,d=n.width+c,p=n.height+u,f=i.maxWidth&&d>i.maxWidth,g=i.maxHeight&&p>i.maxHeight,m=i.minWidth&&i.minWidth>d,v=i.minHeight&&i.minHeight>p;i.grid=r,m&&(d+=h),v&&(p+=l),f&&(d-=h),g&&(p-=l),/^(se|s|e)$/.test(a)?(e.size.width=d,e.size.height=p):/^(ne)$/.test(a)?(e.size.width=d,e.size.height=p,e.position.top=o.top-u):/^(sw)$/.test(a)?(e.size.width=d,e.size.height=p,e.position.left=o.left-c):(e.size.width=d,e.size.height=p,e.position.top=o.top-u,e.position.left=o.left-c)}})}(jQuery),function(t){t.widget(\"ui.selectable\",t.ui.mouse,{version:\"1.10.2\",options:{appendTo:\"body\",autoRefresh:!0,distance:0,filter:\"*\",tolerance:\"touch\",selected:null,selecting:null,start:null,stop:null,unselected:null,unselecting:null},_create:function(){var e,i=this;this.element.addClass(\"ui-selectable\"),this.dragged=!1,this.refresh=function(){e=t(i.options.filter,i.element[0]),e.addClass(\"ui-selectee\"),e.each(function(){var e=t(this),i=e.offset();t.data(this,\"selectable-item\",{element:this,$element:e,left:i.left,top:i.top,right:i.left+e.outerWidth(),bottom:i.top+e.outerHeight(),startselected:!1,selected:e.hasClass(\"ui-selected\"),selecting:e.hasClass(\"ui-selecting\"),unselecting:e.hasClass(\"ui-unselecting\")})})},this.refresh(),this.selectees=e.addClass(\"ui-selectee\"),this._mouseInit(),this.helper=t(\"<div class='ui-selectable-helper'></div>\")},_destroy:function(){this.selectees.removeClass(\"ui-selectee\").removeData(\"selectable-item\"),this.element.removeClass(\"ui-selectable ui-selectable-disabled\"),this._mouseDestroy()},_mouseStart:function(e){var i=this,s=this.options;this.opos=[e.pageX,e.pageY],this.options.disabled||(this.selectees=t(s.filter,this.element[0]),this._trigger(\"start\",e),t(s.appendTo).append(this.helper),this.helper.css({left:e.pageX,top:e.pageY,width:0,height:0}),s.autoRefresh&&this.refresh(),this.selectees.filter(\".ui-selected\").each(function(){var s=t.data(this,\"selectable-item\");s.startselected=!0,e.metaKey||e.ctrlKey||(s.$element.removeClass(\"ui-selected\"),s.selected=!1,s.$element.addClass(\"ui-unselecting\"),s.unselecting=!0,i._trigger(\"unselecting\",e,{unselecting:s.element}))}),t(e.target).parents().addBack().each(function(){var s,n=t.data(this,\"selectable-item\");return n?(s=!e.metaKey&&!e.ctrlKey||!n.$element.hasClass(\"ui-selected\"),n.$element.removeClass(s?\"ui-unselecting\":\"ui-selected\").addClass(s?\"ui-selecting\":\"ui-unselecting\"),n.unselecting=!s,n.selecting=s,n.selected=s,s?i._trigger(\"selecting\",e,{selecting:n.element}):i._trigger(\"unselecting\",e,{unselecting:n.element}),!1):undefined}))},_mouseDrag:function(e){if(this.dragged=!0,!this.options.disabled){var i,s=this,n=this.options,o=this.opos[0],a=this.opos[1],r=e.pageX,h=e.pageY;return o>r&&(i=r,r=o,o=i),a>h&&(i=h,h=a,a=i),this.helper.css({left:o,top:a,width:r-o,height:h-a}),this.selectees.each(function(){var i=t.data(this,\"selectable-item\"),l=!1;i&&i.element!==s.element[0]&&(\"touch\"===n.tolerance?l=!(i.left>r||o>i.right||i.top>h||a>i.bottom):\"fit\"===n.tolerance&&(l=i.left>o&&r>i.right&&i.top>a&&h>i.bottom),l?(i.selected&&(i.$element.removeClass(\"ui-selected\"),i.selected=!1),i.unselecting&&(i.$element.removeClass(\"ui-unselecting\"),i.unselecting=!1),i.selecting||(i.$element.addClass(\"ui-selecting\"),i.selecting=!0,s._trigger(\"selecting\",e,{selecting:i.element}))):(i.selecting&&((e.metaKey||e.ctrlKey)&&i.startselected?(i.$element.removeClass(\"ui-selecting\"),i.selecting=!1,i.$element.addClass(\"ui-selected\"),i.selected=!0):(i.$element.removeClass(\"ui-selecting\"),i.selecting=!1,i.startselected&&(i.$element.addClass(\"ui-unselecting\"),i.unselecting=!0),s._trigger(\"unselecting\",e,{unselecting:i.element}))),i.selected&&(e.metaKey||e.ctrlKey||i.startselected||(i.$element.removeClass(\"ui-selected\"),i.selected=!1,i.$element.addClass(\"ui-unselecting\"),i.unselecting=!0,s._trigger(\"unselecting\",e,{unselecting:i.element})))))}),!1}},_mouseStop:function(e){var i=this;return this.dragged=!1,t(\".ui-unselecting\",this.element[0]).each(function(){var s=t.data(this,\"selectable-item\");s.$element.removeClass(\"ui-unselecting\"),s.unselecting=!1,s.startselected=!1,i._trigger(\"unselected\",e,{unselected:s.element})}),t(\".ui-selecting\",this.element[0]).each(function(){var s=t.data(this,\"selectable-item\");s.$element.removeClass(\"ui-selecting\").addClass(\"ui-selected\"),s.selecting=!1,s.selected=!0,s.startselected=!0,i._trigger(\"selected\",e,{selected:s.element})}),this._trigger(\"stop\",e),this.helper.remove(),!1}})}(jQuery),function(t){function e(t,e,i){return t>e&&e+i>t}function i(t){return/left|right/.test(t.css(\"float\"))||/inline|table-cell/.test(t.css(\"display\"))}t.widget(\"ui.sortable\",t.ui.mouse,{version:\"1.10.2\",widgetEventPrefix:\"sort\",ready:!1,options:{appendTo:\"parent\",axis:!1,connectWith:!1,containment:!1,cursor:\"auto\",cursorAt:!1,dropOnEmpty:!0,forcePlaceholderSize:!1,forceHelperSize:!1,grid:!1,handle:!1,helper:\"original\",items:\"> *\",opacity:!1,placeholder:!1,revert:!1,scroll:!0,scrollSensitivity:20,scrollSpeed:20,scope:\"default\",tolerance:\"intersect\",zIndex:1e3,activate:null,beforeStop:null,change:null,deactivate:null,out:null,over:null,receive:null,remove:null,sort:null,start:null,stop:null,update:null},_create:function(){var t=this.options;this.containerCache={},this.element.addClass(\"ui-sortable\"),this.refresh(),this.floating=this.items.length?\"x\"===t.axis||i(this.items[0].item):!1,this.offset=this.element.offset(),this._mouseInit(),this.ready=!0},_destroy:function(){this.element.removeClass(\"ui-sortable ui-sortable-disabled\"),this._mouseDestroy();for(var t=this.items.length-1;t>=0;t--)this.items[t].item.removeData(this.widgetName+\"-item\");return this},_setOption:function(e,i){\"disabled\"===e?(this.options[e]=i,this.widget().toggleClass(\"ui-sortable-disabled\",!!i)):t.Widget.prototype._setOption.apply(this,arguments)},_mouseCapture:function(e,i){var s=null,n=!1,o=this;return this.reverting?!1:this.options.disabled||\"static\"===this.options.type?!1:(this._refreshItems(e),t(e.target).parents().each(function(){return t.data(this,o.widgetName+\"-item\")===o?(s=t(this),!1):undefined}),t.data(e.target,o.widgetName+\"-item\")===o&&(s=t(e.target)),s?!this.options.handle||i||(t(this.options.handle,s).find(\"*\").addBack().each(function(){this===e.target&&(n=!0)}),n)?(this.currentItem=s,this._removeCurrentsFromItems(),!0):!1:!1)},_mouseStart:function(e,i,s){var n,o,a=this.options;if(this.currentContainer=this,this.refreshPositions(),this.helper=this._createHelper(e),this._cacheHelperProportions(),this._cacheMargins(),this.scrollParent=this.helper.scrollParent(),this.offset=this.currentItem.offset(),this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left},t.extend(this.offset,{click:{left:e.pageX-this.offset.left,top:e.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()}),this.helper.css(\"position\",\"absolute\"),this.cssPosition=this.helper.css(\"position\"),this.originalPosition=this._generatePosition(e),this.originalPageX=e.pageX,this.originalPageY=e.pageY,a.cursorAt&&this._adjustOffsetFromHelper(a.cursorAt),this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]},this.helper[0]!==this.currentItem[0]&&this.currentItem.hide(),this._createPlaceholder(),a.containment&&this._setContainment(),a.cursor&&\"auto\"!==a.cursor&&(o=this.document.find(\"body\"),this.storedCursor=o.css(\"cursor\"),o.css(\"cursor\",a.cursor),this.storedStylesheet=t(\"<style>*{ cursor: \"+a.cursor+\" !important; }</style>\").appendTo(o)),a.opacity&&(this.helper.css(\"opacity\")&&(this._storedOpacity=this.helper.css(\"opacity\")),this.helper.css(\"opacity\",a.opacity)),a.zIndex&&(this.helper.css(\"zIndex\")&&(this._storedZIndex=this.helper.css(\"zIndex\")),this.helper.css(\"zIndex\",a.zIndex)),this.scrollParent[0]!==document&&\"HTML\"!==this.scrollParent[0].tagName&&(this.overflowOffset=this.scrollParent.offset()),this._trigger(\"start\",e,this._uiHash()),this._preserveHelperProportions||this._cacheHelperProportions(),!s)for(n=this.containers.length-1;n>=0;n--)this.containers[n]._trigger(\"activate\",e,this._uiHash(this));return t.ui.ddmanager&&(t.ui.ddmanager.current=this),t.ui.ddmanager&&!a.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e),this.dragging=!0,this.helper.addClass(\"ui-sortable-helper\"),this._mouseDrag(e),!0},_mouseDrag:function(e){var i,s,n,o,a=this.options,r=!1;for(this.position=this._generatePosition(e),this.positionAbs=this._convertPositionTo(\"absolute\"),this.lastPositionAbs||(this.lastPositionAbs=this.positionAbs),this.options.scroll&&(this.scrollParent[0]!==document&&\"HTML\"!==this.scrollParent[0].tagName?(this.overflowOffset.top+this.scrollParent[0].offsetHeight-e.pageY<a.scrollSensitivity?this.scrollParent[0].scrollTop=r=this.scrollParent[0].scrollTop+a.scrollSpeed:e.pageY-this.overflowOffset.top<a.scrollSensitivity&&(this.scrollParent[0].scrollTop=r=this.scrollParent[0].scrollTop-a.scrollSpeed),this.overflowOffset.left+this.scrollParent[0].offsetWidth-e.pageX<a.scrollSensitivity?this.scrollParent[0].scrollLeft=r=this.scrollParent[0].scrollLeft+a.scrollSpeed:e.pageX-this.overflowOffset.left<a.scrollSensitivity&&(this.scrollParent[0].scrollLeft=r=this.scrollParent[0].scrollLeft-a.scrollSpeed)):(e.pageY-t(document).scrollTop()<a.scrollSensitivity?r=t(document).scrollTop(t(document).scrollTop()-a.scrollSpeed):t(window).height()-(e.pageY-t(document).scrollTop())<a.scrollSensitivity&&(r=t(document).scrollTop(t(document).scrollTop()+a.scrollSpeed)),e.pageX-t(document).scrollLeft()<a.scrollSensitivity?r=t(document).scrollLeft(t(document).scrollLeft()-a.scrollSpeed):t(window).width()-(e.pageX-t(document).scrollLeft())<a.scrollSensitivity&&(r=t(document).scrollLeft(t(document).scrollLeft()+a.scrollSpeed))),r!==!1&&t.ui.ddmanager&&!a.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e)),this.positionAbs=this._convertPositionTo(\"absolute\"),this.options.axis&&\"y\"===this.options.axis||(this.helper[0].style.left=this.position.left+\"px\"),this.options.axis&&\"x\"===this.options.axis||(this.helper[0].style.top=this.position.top+\"px\"),i=this.items.length-1;i>=0;i--)if(s=this.items[i],n=s.item[0],o=this._intersectsWithPointer(s),o&&s.instance===this.currentContainer&&n!==this.currentItem[0]&&this.placeholder[1===o?\"next\":\"prev\"]()[0]!==n&&!t.contains(this.placeholder[0],n)&&(\"semi-dynamic\"===this.options.type?!t.contains(this.element[0],n):!0)){if(this.direction=1===o?\"down\":\"up\",\"pointer\"!==this.options.tolerance&&!this._intersectsWithSides(s))break;\nthis._rearrange(e,s),this._trigger(\"change\",e,this._uiHash());break}return this._contactContainers(e),t.ui.ddmanager&&t.ui.ddmanager.drag(this,e),this._trigger(\"sort\",e,this._uiHash()),this.lastPositionAbs=this.positionAbs,!1},_mouseStop:function(e,i){if(e){if(t.ui.ddmanager&&!this.options.dropBehaviour&&t.ui.ddmanager.drop(this,e),this.options.revert){var s=this,n=this.placeholder.offset(),o=this.options.axis,a={};o&&\"x\"!==o||(a.left=n.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollLeft)),o&&\"y\"!==o||(a.top=n.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollTop)),this.reverting=!0,t(this.helper).animate(a,parseInt(this.options.revert,10)||500,function(){s._clear(e)})}else this._clear(e,i);return!1}},cancel:function(){if(this.dragging){this._mouseUp({target:null}),\"original\"===this.options.helper?this.currentItem.css(this._storedCSS).removeClass(\"ui-sortable-helper\"):this.currentItem.show();for(var e=this.containers.length-1;e>=0;e--)this.containers[e]._trigger(\"deactivate\",null,this._uiHash(this)),this.containers[e].containerCache.over&&(this.containers[e]._trigger(\"out\",null,this._uiHash(this)),this.containers[e].containerCache.over=0)}return this.placeholder&&(this.placeholder[0].parentNode&&this.placeholder[0].parentNode.removeChild(this.placeholder[0]),\"original\"!==this.options.helper&&this.helper&&this.helper[0].parentNode&&this.helper.remove(),t.extend(this,{helper:null,dragging:!1,reverting:!1,_noFinalSort:null}),this.domPosition.prev?t(this.domPosition.prev).after(this.currentItem):t(this.domPosition.parent).prepend(this.currentItem)),this},serialize:function(e){var i=this._getItemsAsjQuery(e&&e.connected),s=[];return e=e||{},t(i).each(function(){var i=(t(e.item||this).attr(e.attribute||\"id\")||\"\").match(e.expression||/(.+)[\\-=_](.+)/);i&&s.push((e.key||i[1]+\"[]\")+\"=\"+(e.key&&e.expression?i[1]:i[2]))}),!s.length&&e.key&&s.push(e.key+\"=\"),s.join(\"&\")},toArray:function(e){var i=this._getItemsAsjQuery(e&&e.connected),s=[];return e=e||{},i.each(function(){s.push(t(e.item||this).attr(e.attribute||\"id\")||\"\")}),s},_intersectsWith:function(t){var e=this.positionAbs.left,i=e+this.helperProportions.width,s=this.positionAbs.top,n=s+this.helperProportions.height,o=t.left,a=o+t.width,r=t.top,h=r+t.height,l=this.offset.click.top,c=this.offset.click.left,u=s+l>r&&h>s+l&&e+c>o&&a>e+c;return\"pointer\"===this.options.tolerance||this.options.forcePointerForContainers||\"pointer\"!==this.options.tolerance&&this.helperProportions[this.floating?\"width\":\"height\"]>t[this.floating?\"width\":\"height\"]?u:e+this.helperProportions.width/2>o&&a>i-this.helperProportions.width/2&&s+this.helperProportions.height/2>r&&h>n-this.helperProportions.height/2},_intersectsWithPointer:function(t){var i=\"x\"===this.options.axis||e(this.positionAbs.top+this.offset.click.top,t.top,t.height),s=\"y\"===this.options.axis||e(this.positionAbs.left+this.offset.click.left,t.left,t.width),n=i&&s,o=this._getDragVerticalDirection(),a=this._getDragHorizontalDirection();return n?this.floating?a&&\"right\"===a||\"down\"===o?2:1:o&&(\"down\"===o?2:1):!1},_intersectsWithSides:function(t){var i=e(this.positionAbs.top+this.offset.click.top,t.top+t.height/2,t.height),s=e(this.positionAbs.left+this.offset.click.left,t.left+t.width/2,t.width),n=this._getDragVerticalDirection(),o=this._getDragHorizontalDirection();return this.floating&&o?\"right\"===o&&s||\"left\"===o&&!s:n&&(\"down\"===n&&i||\"up\"===n&&!i)},_getDragVerticalDirection:function(){var t=this.positionAbs.top-this.lastPositionAbs.top;return 0!==t&&(t>0?\"down\":\"up\")},_getDragHorizontalDirection:function(){var t=this.positionAbs.left-this.lastPositionAbs.left;return 0!==t&&(t>0?\"right\":\"left\")},refresh:function(t){return this._refreshItems(t),this.refreshPositions(),this},_connectWith:function(){var t=this.options;return t.connectWith.constructor===String?[t.connectWith]:t.connectWith},_getItemsAsjQuery:function(e){var i,s,n,o,a=[],r=[],h=this._connectWith();if(h&&e)for(i=h.length-1;i>=0;i--)for(n=t(h[i]),s=n.length-1;s>=0;s--)o=t.data(n[s],this.widgetFullName),o&&o!==this&&!o.options.disabled&&r.push([t.isFunction(o.options.items)?o.options.items.call(o.element):t(o.options.items,o.element).not(\".ui-sortable-helper\").not(\".ui-sortable-placeholder\"),o]);for(r.push([t.isFunction(this.options.items)?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):t(this.options.items,this.element).not(\".ui-sortable-helper\").not(\".ui-sortable-placeholder\"),this]),i=r.length-1;i>=0;i--)r[i][0].each(function(){a.push(this)});return t(a)},_removeCurrentsFromItems:function(){var e=this.currentItem.find(\":data(\"+this.widgetName+\"-item)\");this.items=t.grep(this.items,function(t){for(var i=0;e.length>i;i++)if(e[i]===t.item[0])return!1;return!0})},_refreshItems:function(e){this.items=[],this.containers=[this];var i,s,n,o,a,r,h,l,c=this.items,u=[[t.isFunction(this.options.items)?this.options.items.call(this.element[0],e,{item:this.currentItem}):t(this.options.items,this.element),this]],d=this._connectWith();if(d&&this.ready)for(i=d.length-1;i>=0;i--)for(n=t(d[i]),s=n.length-1;s>=0;s--)o=t.data(n[s],this.widgetFullName),o&&o!==this&&!o.options.disabled&&(u.push([t.isFunction(o.options.items)?o.options.items.call(o.element[0],e,{item:this.currentItem}):t(o.options.items,o.element),o]),this.containers.push(o));for(i=u.length-1;i>=0;i--)for(a=u[i][1],r=u[i][0],s=0,l=r.length;l>s;s++)h=t(r[s]),h.data(this.widgetName+\"-item\",a),c.push({item:h,instance:a,width:0,height:0,left:0,top:0})},refreshPositions:function(e){this.offsetParent&&this.helper&&(this.offset.parent=this._getParentOffset());var i,s,n,o;for(i=this.items.length-1;i>=0;i--)s=this.items[i],s.instance!==this.currentContainer&&this.currentContainer&&s.item[0]!==this.currentItem[0]||(n=this.options.toleranceElement?t(this.options.toleranceElement,s.item):s.item,e||(s.width=n.outerWidth(),s.height=n.outerHeight()),o=n.offset(),s.left=o.left,s.top=o.top);if(this.options.custom&&this.options.custom.refreshContainers)this.options.custom.refreshContainers.call(this);else for(i=this.containers.length-1;i>=0;i--)o=this.containers[i].element.offset(),this.containers[i].containerCache.left=o.left,this.containers[i].containerCache.top=o.top,this.containers[i].containerCache.width=this.containers[i].element.outerWidth(),this.containers[i].containerCache.height=this.containers[i].element.outerHeight();return this},_createPlaceholder:function(e){e=e||this;var i,s=e.options;s.placeholder&&s.placeholder.constructor!==String||(i=s.placeholder,s.placeholder={element:function(){var s=e.currentItem[0].nodeName.toLowerCase(),n=t(e.document[0].createElement(s)).addClass(i||e.currentItem[0].className+\" ui-sortable-placeholder\").removeClass(\"ui-sortable-helper\");return\"tr\"===s?n.append(\"<td colspan='99'>&#160;</td>\"):\"img\"===s&&n.attr(\"src\",e.currentItem.attr(\"src\")),i||n.css(\"visibility\",\"hidden\"),n},update:function(t,n){(!i||s.forcePlaceholderSize)&&(n.height()||n.height(e.currentItem.innerHeight()-parseInt(e.currentItem.css(\"paddingTop\")||0,10)-parseInt(e.currentItem.css(\"paddingBottom\")||0,10)),n.width()||n.width(e.currentItem.innerWidth()-parseInt(e.currentItem.css(\"paddingLeft\")||0,10)-parseInt(e.currentItem.css(\"paddingRight\")||0,10)))}}),e.placeholder=t(s.placeholder.element.call(e.element,e.currentItem)),e.currentItem.after(e.placeholder),s.placeholder.update(e,e.placeholder)},_contactContainers:function(s){var n,o,a,r,h,l,c,u,d,p,f=null,g=null;for(n=this.containers.length-1;n>=0;n--)if(!t.contains(this.currentItem[0],this.containers[n].element[0]))if(this._intersectsWith(this.containers[n].containerCache)){if(f&&t.contains(this.containers[n].element[0],f.element[0]))continue;f=this.containers[n],g=n}else this.containers[n].containerCache.over&&(this.containers[n]._trigger(\"out\",s,this._uiHash(this)),this.containers[n].containerCache.over=0);if(f)if(1===this.containers.length)this.containers[g].containerCache.over||(this.containers[g]._trigger(\"over\",s,this._uiHash(this)),this.containers[g].containerCache.over=1);else{for(a=1e4,r=null,p=f.floating||i(this.currentItem),h=p?\"left\":\"top\",l=p?\"width\":\"height\",c=this.positionAbs[h]+this.offset.click[h],o=this.items.length-1;o>=0;o--)t.contains(this.containers[g].element[0],this.items[o].item[0])&&this.items[o].item[0]!==this.currentItem[0]&&(!p||e(this.positionAbs.top+this.offset.click.top,this.items[o].top,this.items[o].height))&&(u=this.items[o].item.offset()[h],d=!1,Math.abs(u-c)>Math.abs(u+this.items[o][l]-c)&&(d=!0,u+=this.items[o][l]),a>Math.abs(u-c)&&(a=Math.abs(u-c),r=this.items[o],this.direction=d?\"up\":\"down\"));if(!r&&!this.options.dropOnEmpty)return;if(this.currentContainer===this.containers[g])return;r?this._rearrange(s,r,null,!0):this._rearrange(s,null,this.containers[g].element,!0),this._trigger(\"change\",s,this._uiHash()),this.containers[g]._trigger(\"change\",s,this._uiHash(this)),this.currentContainer=this.containers[g],this.options.placeholder.update(this.currentContainer,this.placeholder),this.containers[g]._trigger(\"over\",s,this._uiHash(this)),this.containers[g].containerCache.over=1}},_createHelper:function(e){var i=this.options,s=t.isFunction(i.helper)?t(i.helper.apply(this.element[0],[e,this.currentItem])):\"clone\"===i.helper?this.currentItem.clone():this.currentItem;return s.parents(\"body\").length||t(\"parent\"!==i.appendTo?i.appendTo:this.currentItem[0].parentNode)[0].appendChild(s[0]),s[0]===this.currentItem[0]&&(this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css(\"position\"),top:this.currentItem.css(\"top\"),left:this.currentItem.css(\"left\")}),(!s[0].style.width||i.forceHelperSize)&&s.width(this.currentItem.width()),(!s[0].style.height||i.forceHelperSize)&&s.height(this.currentItem.height()),s},_adjustOffsetFromHelper:function(e){\"string\"==typeof e&&(e=e.split(\" \")),t.isArray(e)&&(e={left:+e[0],top:+e[1]||0}),\"left\"in e&&(this.offset.click.left=e.left+this.margins.left),\"right\"in e&&(this.offset.click.left=this.helperProportions.width-e.right+this.margins.left),\"top\"in e&&(this.offset.click.top=e.top+this.margins.top),\"bottom\"in e&&(this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top)},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var e=this.offsetParent.offset();return\"absolute\"===this.cssPosition&&this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])&&(e.left+=this.scrollParent.scrollLeft(),e.top+=this.scrollParent.scrollTop()),(this.offsetParent[0]===document.body||this.offsetParent[0].tagName&&\"html\"===this.offsetParent[0].tagName.toLowerCase()&&t.ui.ie)&&(e={top:0,left:0}),{top:e.top+(parseInt(this.offsetParent.css(\"borderTopWidth\"),10)||0),left:e.left+(parseInt(this.offsetParent.css(\"borderLeftWidth\"),10)||0)}},_getRelativeOffset:function(){if(\"relative\"===this.cssPosition){var t=this.currentItem.position();return{top:t.top-(parseInt(this.helper.css(\"top\"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css(\"left\"),10)||0)+this.scrollParent.scrollLeft()}}return{top:0,left:0}},_cacheMargins:function(){this.margins={left:parseInt(this.currentItem.css(\"marginLeft\"),10)||0,top:parseInt(this.currentItem.css(\"marginTop\"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e,i,s,n=this.options;\"parent\"===n.containment&&(n.containment=this.helper[0].parentNode),(\"document\"===n.containment||\"window\"===n.containment)&&(this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,t(\"document\"===n.containment?document:window).width()-this.helperProportions.width-this.margins.left,(t(\"document\"===n.containment?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]),/^(document|window|parent)$/.test(n.containment)||(e=t(n.containment)[0],i=t(n.containment).offset(),s=\"hidden\"!==t(e).css(\"overflow\"),this.containment=[i.left+(parseInt(t(e).css(\"borderLeftWidth\"),10)||0)+(parseInt(t(e).css(\"paddingLeft\"),10)||0)-this.margins.left,i.top+(parseInt(t(e).css(\"borderTopWidth\"),10)||0)+(parseInt(t(e).css(\"paddingTop\"),10)||0)-this.margins.top,i.left+(s?Math.max(e.scrollWidth,e.offsetWidth):e.offsetWidth)-(parseInt(t(e).css(\"borderLeftWidth\"),10)||0)-(parseInt(t(e).css(\"paddingRight\"),10)||0)-this.helperProportions.width-this.margins.left,i.top+(s?Math.max(e.scrollHeight,e.offsetHeight):e.offsetHeight)-(parseInt(t(e).css(\"borderTopWidth\"),10)||0)-(parseInt(t(e).css(\"paddingBottom\"),10)||0)-this.helperProportions.height-this.margins.top])},_convertPositionTo:function(e,i){i||(i=this.position);var s=\"absolute\"===e?1:-1,n=\"absolute\"!==this.cssPosition||this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,o=/(html|body)/i.test(n[0].tagName);return{top:i.top+this.offset.relative.top*s+this.offset.parent.top*s-(\"fixed\"===this.cssPosition?-this.scrollParent.scrollTop():o?0:n.scrollTop())*s,left:i.left+this.offset.relative.left*s+this.offset.parent.left*s-(\"fixed\"===this.cssPosition?-this.scrollParent.scrollLeft():o?0:n.scrollLeft())*s}},_generatePosition:function(e){var i,s,n=this.options,o=e.pageX,a=e.pageY,r=\"absolute\"!==this.cssPosition||this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,h=/(html|body)/i.test(r[0].tagName);return\"relative\"!==this.cssPosition||this.scrollParent[0]!==document&&this.scrollParent[0]!==this.offsetParent[0]||(this.offset.relative=this._getRelativeOffset()),this.originalPosition&&(this.containment&&(e.pageX-this.offset.click.left<this.containment[0]&&(o=this.containment[0]+this.offset.click.left),e.pageY-this.offset.click.top<this.containment[1]&&(a=this.containment[1]+this.offset.click.top),e.pageX-this.offset.click.left>this.containment[2]&&(o=this.containment[2]+this.offset.click.left),e.pageY-this.offset.click.top>this.containment[3]&&(a=this.containment[3]+this.offset.click.top)),n.grid&&(i=this.originalPageY+Math.round((a-this.originalPageY)/n.grid[1])*n.grid[1],a=this.containment?i-this.offset.click.top>=this.containment[1]&&i-this.offset.click.top<=this.containment[3]?i:i-this.offset.click.top>=this.containment[1]?i-n.grid[1]:i+n.grid[1]:i,s=this.originalPageX+Math.round((o-this.originalPageX)/n.grid[0])*n.grid[0],o=this.containment?s-this.offset.click.left>=this.containment[0]&&s-this.offset.click.left<=this.containment[2]?s:s-this.offset.click.left>=this.containment[0]?s-n.grid[0]:s+n.grid[0]:s)),{top:a-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+(\"fixed\"===this.cssPosition?-this.scrollParent.scrollTop():h?0:r.scrollTop()),left:o-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+(\"fixed\"===this.cssPosition?-this.scrollParent.scrollLeft():h?0:r.scrollLeft())}},_rearrange:function(t,e,i,s){i?i[0].appendChild(this.placeholder[0]):e.item[0].parentNode.insertBefore(this.placeholder[0],\"down\"===this.direction?e.item[0]:e.item[0].nextSibling),this.counter=this.counter?++this.counter:1;var n=this.counter;this._delay(function(){n===this.counter&&this.refreshPositions(!s)})},_clear:function(t,e){this.reverting=!1;var i,s=[];if(!this._noFinalSort&&this.currentItem.parent().length&&this.placeholder.before(this.currentItem),this._noFinalSort=null,this.helper[0]===this.currentItem[0]){for(i in this._storedCSS)(\"auto\"===this._storedCSS[i]||\"static\"===this._storedCSS[i])&&(this._storedCSS[i]=\"\");this.currentItem.css(this._storedCSS).removeClass(\"ui-sortable-helper\")}else this.currentItem.show();for(this.fromOutside&&!e&&s.push(function(t){this._trigger(\"receive\",t,this._uiHash(this.fromOutside))}),!this.fromOutside&&this.domPosition.prev===this.currentItem.prev().not(\".ui-sortable-helper\")[0]&&this.domPosition.parent===this.currentItem.parent()[0]||e||s.push(function(t){this._trigger(\"update\",t,this._uiHash())}),this!==this.currentContainer&&(e||(s.push(function(t){this._trigger(\"remove\",t,this._uiHash())}),s.push(function(t){return function(e){t._trigger(\"receive\",e,this._uiHash(this))}}.call(this,this.currentContainer)),s.push(function(t){return function(e){t._trigger(\"update\",e,this._uiHash(this))}}.call(this,this.currentContainer)))),i=this.containers.length-1;i>=0;i--)e||s.push(function(t){return function(e){t._trigger(\"deactivate\",e,this._uiHash(this))}}.call(this,this.containers[i])),this.containers[i].containerCache.over&&(s.push(function(t){return function(e){t._trigger(\"out\",e,this._uiHash(this))}}.call(this,this.containers[i])),this.containers[i].containerCache.over=0);if(this.storedCursor&&(this.document.find(\"body\").css(\"cursor\",this.storedCursor),this.storedStylesheet.remove()),this._storedOpacity&&this.helper.css(\"opacity\",this._storedOpacity),this._storedZIndex&&this.helper.css(\"zIndex\",\"auto\"===this._storedZIndex?\"\":this._storedZIndex),this.dragging=!1,this.cancelHelperRemoval){if(!e){for(this._trigger(\"beforeStop\",t,this._uiHash()),i=0;s.length>i;i++)s[i].call(this,t);this._trigger(\"stop\",t,this._uiHash())}return this.fromOutside=!1,!1}if(e||this._trigger(\"beforeStop\",t,this._uiHash()),this.placeholder[0].parentNode.removeChild(this.placeholder[0]),this.helper[0]!==this.currentItem[0]&&this.helper.remove(),this.helper=null,!e){for(i=0;s.length>i;i++)s[i].call(this,t);this._trigger(\"stop\",t,this._uiHash())}return this.fromOutside=!1,!0},_trigger:function(){t.Widget.prototype._trigger.apply(this,arguments)===!1&&this.cancel()},_uiHash:function(e){var i=e||this;return{helper:i.helper,placeholder:i.placeholder||t([]),position:i.position,originalPosition:i.originalPosition,offset:i.positionAbs,item:i.currentItem,sender:e?e.element:null}}})}(jQuery),function(t,e){var i=\"ui-effects-\";t.effects={effect:{}},function(t,e){function i(t,e,i){var s=u[e.type]||{};return null==t?i||!e.def?null:e.def:(t=s.floor?~~t:parseFloat(t),isNaN(t)?e.def:s.mod?(t+s.mod)%s.mod:0>t?0:t>s.max?s.max:t)}function s(i){var s=l(),n=s._rgba=[];return i=i.toLowerCase(),f(h,function(t,o){var a,r=o.re.exec(i),h=r&&o.parse(r),l=o.space||\"rgba\";return h?(a=s[l](h),s[c[l].cache]=a[c[l].cache],n=s._rgba=a._rgba,!1):e}),n.length?(\"0,0,0,0\"===n.join()&&t.extend(n,o.transparent),s):o[i]}function n(t,e,i){return i=(i+1)%1,1>6*i?t+6*(e-t)*i:1>2*i?e:2>3*i?t+6*(e-t)*(2/3-i):t}var o,a=\"backgroundColor borderBottomColor borderLeftColor borderRightColor borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor\",r=/^([\\-+])=\\s*(\\d+\\.?\\d*)/,h=[{re:/rgba?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,parse:function(t){return[t[1],t[2],t[3],t[4]]}},{re:/rgba?\\(\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,parse:function(t){return[2.55*t[1],2.55*t[2],2.55*t[3],t[4]]}},{re:/#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,parse:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/#([a-f0-9])([a-f0-9])([a-f0-9])/,parse:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}},{re:/hsla?\\(\\s*(\\d+(?:\\.\\d+)?)\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,space:\"hsla\",parse:function(t){return[t[1],t[2]/100,t[3]/100,t[4]]}}],l=t.Color=function(e,i,s,n){return new t.Color.fn.parse(e,i,s,n)},c={rgba:{props:{red:{idx:0,type:\"byte\"},green:{idx:1,type:\"byte\"},blue:{idx:2,type:\"byte\"}}},hsla:{props:{hue:{idx:0,type:\"degrees\"},saturation:{idx:1,type:\"percent\"},lightness:{idx:2,type:\"percent\"}}}},u={\"byte\":{floor:!0,max:255},percent:{max:1},degrees:{mod:360,floor:!0}},d=l.support={},p=t(\"<p>\")[0],f=t.each;p.style.cssText=\"background-color:rgba(1,1,1,.5)\",d.rgba=p.style.backgroundColor.indexOf(\"rgba\")>-1,f(c,function(t,e){e.cache=\"_\"+t,e.props.alpha={idx:3,type:\"percent\",def:1}}),l.fn=t.extend(l.prototype,{parse:function(n,a,r,h){if(n===e)return this._rgba=[null,null,null,null],this;(n.jquery||n.nodeType)&&(n=t(n).css(a),a=e);var u=this,d=t.type(n),p=this._rgba=[];return a!==e&&(n=[n,a,r,h],d=\"array\"),\"string\"===d?this.parse(s(n)||o._default):\"array\"===d?(f(c.rgba.props,function(t,e){p[e.idx]=i(n[e.idx],e)}),this):\"object\"===d?(n instanceof l?f(c,function(t,e){n[e.cache]&&(u[e.cache]=n[e.cache].slice())}):f(c,function(e,s){var o=s.cache;f(s.props,function(t,e){if(!u[o]&&s.to){if(\"alpha\"===t||null==n[t])return;u[o]=s.to(u._rgba)}u[o][e.idx]=i(n[t],e,!0)}),u[o]&&0>t.inArray(null,u[o].slice(0,3))&&(u[o][3]=1,s.from&&(u._rgba=s.from(u[o])))}),this):e},is:function(t){var i=l(t),s=!0,n=this;return f(c,function(t,o){var a,r=i[o.cache];return r&&(a=n[o.cache]||o.to&&o.to(n._rgba)||[],f(o.props,function(t,i){return null!=r[i.idx]?s=r[i.idx]===a[i.idx]:e})),s}),s},_space:function(){var t=[],e=this;return f(c,function(i,s){e[s.cache]&&t.push(i)}),t.pop()},transition:function(t,e){var s=l(t),n=s._space(),o=c[n],a=0===this.alpha()?l(\"transparent\"):this,r=a[o.cache]||o.to(a._rgba),h=r.slice();return s=s[o.cache],f(o.props,function(t,n){var o=n.idx,a=r[o],l=s[o],c=u[n.type]||{};null!==l&&(null===a?h[o]=l:(c.mod&&(l-a>c.mod/2?a+=c.mod:a-l>c.mod/2&&(a-=c.mod)),h[o]=i((l-a)*e+a,n)))}),this[n](h)},blend:function(e){if(1===this._rgba[3])return this;var i=this._rgba.slice(),s=i.pop(),n=l(e)._rgba;return l(t.map(i,function(t,e){return(1-s)*n[e]+s*t}))},toRgbaString:function(){var e=\"rgba(\",i=t.map(this._rgba,function(t,e){return null==t?e>2?1:0:t});return 1===i[3]&&(i.pop(),e=\"rgb(\"),e+i.join()+\")\"},toHslaString:function(){var e=\"hsla(\",i=t.map(this.hsla(),function(t,e){return null==t&&(t=e>2?1:0),e&&3>e&&(t=Math.round(100*t)+\"%\"),t});return 1===i[3]&&(i.pop(),e=\"hsl(\"),e+i.join()+\")\"},toHexString:function(e){var i=this._rgba.slice(),s=i.pop();return e&&i.push(~~(255*s)),\"#\"+t.map(i,function(t){return t=(t||0).toString(16),1===t.length?\"0\"+t:t}).join(\"\")},toString:function(){return 0===this._rgba[3]?\"transparent\":this.toRgbaString()}}),l.fn.parse.prototype=l.fn,c.hsla.to=function(t){if(null==t[0]||null==t[1]||null==t[2])return[null,null,null,t[3]];var e,i,s=t[0]/255,n=t[1]/255,o=t[2]/255,a=t[3],r=Math.max(s,n,o),h=Math.min(s,n,o),l=r-h,c=r+h,u=.5*c;return e=h===r?0:s===r?60*(n-o)/l+360:n===r?60*(o-s)/l+120:60*(s-n)/l+240,i=0===l?0:.5>=u?l/c:l/(2-c),[Math.round(e)%360,i,u,null==a?1:a]},c.hsla.from=function(t){if(null==t[0]||null==t[1]||null==t[2])return[null,null,null,t[3]];var e=t[0]/360,i=t[1],s=t[2],o=t[3],a=.5>=s?s*(1+i):s+i-s*i,r=2*s-a;return[Math.round(255*n(r,a,e+1/3)),Math.round(255*n(r,a,e)),Math.round(255*n(r,a,e-1/3)),o]},f(c,function(s,n){var o=n.props,a=n.cache,h=n.to,c=n.from;l.fn[s]=function(s){if(h&&!this[a]&&(this[a]=h(this._rgba)),s===e)return this[a].slice();var n,r=t.type(s),u=\"array\"===r||\"object\"===r?s:arguments,d=this[a].slice();return f(o,function(t,e){var s=u[\"object\"===r?t:e.idx];null==s&&(s=d[e.idx]),d[e.idx]=i(s,e)}),c?(n=l(c(d)),n[a]=d,n):l(d)},f(o,function(e,i){l.fn[e]||(l.fn[e]=function(n){var o,a=t.type(n),h=\"alpha\"===e?this._hsla?\"hsla\":\"rgba\":s,l=this[h](),c=l[i.idx];return\"undefined\"===a?c:(\"function\"===a&&(n=n.call(this,c),a=t.type(n)),null==n&&i.empty?this:(\"string\"===a&&(o=r.exec(n),o&&(n=c+parseFloat(o[2])*(\"+\"===o[1]?1:-1))),l[i.idx]=n,this[h](l)))})})}),l.hook=function(e){var i=e.split(\" \");f(i,function(e,i){t.cssHooks[i]={set:function(e,n){var o,a,r=\"\";if(\"transparent\"!==n&&(\"string\"!==t.type(n)||(o=s(n)))){if(n=l(o||n),!d.rgba&&1!==n._rgba[3]){for(a=\"backgroundColor\"===i?e.parentNode:e;(\"\"===r||\"transparent\"===r)&&a&&a.style;)try{r=t.css(a,\"backgroundColor\"),a=a.parentNode}catch(h){}n=n.blend(r&&\"transparent\"!==r?r:\"_default\")}n=n.toRgbaString()}try{e.style[i]=n}catch(h){}}},t.fx.step[i]=function(e){e.colorInit||(e.start=l(e.elem,i),e.end=l(e.end),e.colorInit=!0),t.cssHooks[i].set(e.elem,e.start.transition(e.end,e.pos))}})},l.hook(a),t.cssHooks.borderColor={expand:function(t){var e={};return f([\"Top\",\"Right\",\"Bottom\",\"Left\"],function(i,s){e[\"border\"+s+\"Color\"]=t}),e}},o=t.Color.names={aqua:\"#00ffff\",black:\"#000000\",blue:\"#0000ff\",fuchsia:\"#ff00ff\",gray:\"#808080\",green:\"#008000\",lime:\"#00ff00\",maroon:\"#800000\",navy:\"#000080\",olive:\"#808000\",purple:\"#800080\",red:\"#ff0000\",silver:\"#c0c0c0\",teal:\"#008080\",white:\"#ffffff\",yellow:\"#ffff00\",transparent:[null,null,null,0],_default:\"#ffffff\"}}(jQuery),function(){function i(e){var i,s,n=e.ownerDocument.defaultView?e.ownerDocument.defaultView.getComputedStyle(e,null):e.currentStyle,o={};if(n&&n.length&&n[0]&&n[n[0]])for(s=n.length;s--;)i=n[s],\"string\"==typeof n[i]&&(o[t.camelCase(i)]=n[i]);else for(i in n)\"string\"==typeof n[i]&&(o[i]=n[i]);return o}function s(e,i){var s,n,a={};for(s in i)n=i[s],e[s]!==n&&(o[s]||(t.fx.step[s]||!isNaN(parseFloat(n)))&&(a[s]=n));return a}var n=[\"add\",\"remove\",\"toggle\"],o={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};t.each([\"borderLeftStyle\",\"borderRightStyle\",\"borderBottomStyle\",\"borderTopStyle\"],function(e,i){t.fx.step[i]=function(t){(\"none\"!==t.end&&!t.setAttr||1===t.pos&&!t.setAttr)&&(jQuery.style(t.elem,i,t.end),t.setAttr=!0)}}),t.fn.addBack||(t.fn.addBack=function(t){return this.add(null==t?this.prevObject:this.prevObject.filter(t))}),t.effects.animateClass=function(e,o,a,r){var h=t.speed(o,a,r);return this.queue(function(){var o,a=t(this),r=a.attr(\"class\")||\"\",l=h.children?a.find(\"*\").addBack():a;l=l.map(function(){var e=t(this);return{el:e,start:i(this)}}),o=function(){t.each(n,function(t,i){e[i]&&a[i+\"Class\"](e[i])})},o(),l=l.map(function(){return this.end=i(this.el[0]),this.diff=s(this.start,this.end),this}),a.attr(\"class\",r),l=l.map(function(){var e=this,i=t.Deferred(),s=t.extend({},h,{queue:!1,complete:function(){i.resolve(e)}});return this.el.animate(this.diff,s),i.promise()}),t.when.apply(t,l.get()).done(function(){o(),t.each(arguments,function(){var e=this.el;t.each(this.diff,function(t){e.css(t,\"\")})}),h.complete.call(a[0])})})},t.fn.extend({addClass:function(e){return function(i,s,n,o){return s?t.effects.animateClass.call(this,{add:i},s,n,o):e.apply(this,arguments)}}(t.fn.addClass),removeClass:function(e){return function(i,s,n,o){return arguments.length>1?t.effects.animateClass.call(this,{remove:i},s,n,o):e.apply(this,arguments)}}(t.fn.removeClass),toggleClass:function(i){return function(s,n,o,a,r){return\"boolean\"==typeof n||n===e?o?t.effects.animateClass.call(this,n?{add:s}:{remove:s},o,a,r):i.apply(this,arguments):t.effects.animateClass.call(this,{toggle:s},n,o,a)}}(t.fn.toggleClass),switchClass:function(e,i,s,n,o){return t.effects.animateClass.call(this,{add:i,remove:e},s,n,o)}})}(),function(){function s(e,i,s,n){return t.isPlainObject(e)&&(i=e,e=e.effect),e={effect:e},null==i&&(i={}),t.isFunction(i)&&(n=i,s=null,i={}),(\"number\"==typeof i||t.fx.speeds[i])&&(n=s,s=i,i={}),t.isFunction(s)&&(n=s,s=null),i&&t.extend(e,i),s=s||i.duration,e.duration=t.fx.off?0:\"number\"==typeof s?s:s in t.fx.speeds?t.fx.speeds[s]:t.fx.speeds._default,e.complete=n||i.complete,e}function n(e){return!e||\"number\"==typeof e||t.fx.speeds[e]?!0:\"string\"!=typeof e||t.effects.effect[e]?t.isFunction(e)?!0:\"object\"!=typeof e||e.effect?!1:!0:!0}t.extend(t.effects,{version:\"1.10.2\",save:function(t,e){for(var s=0;e.length>s;s++)null!==e[s]&&t.data(i+e[s],t[0].style[e[s]])},restore:function(t,s){var n,o;for(o=0;s.length>o;o++)null!==s[o]&&(n=t.data(i+s[o]),n===e&&(n=\"\"),t.css(s[o],n))},setMode:function(t,e){return\"toggle\"===e&&(e=t.is(\":hidden\")?\"show\":\"hide\"),e},getBaseline:function(t,e){var i,s;switch(t[0]){case\"top\":i=0;break;case\"middle\":i=.5;break;case\"bottom\":i=1;break;default:i=t[0]/e.height}switch(t[1]){case\"left\":s=0;break;case\"center\":s=.5;break;case\"right\":s=1;break;default:s=t[1]/e.width}return{x:s,y:i}},createWrapper:function(e){if(e.parent().is(\".ui-effects-wrapper\"))return e.parent();var i={width:e.outerWidth(!0),height:e.outerHeight(!0),\"float\":e.css(\"float\")},s=t(\"<div></div>\").addClass(\"ui-effects-wrapper\").css({fontSize:\"100%\",background:\"transparent\",border:\"none\",margin:0,padding:0}),n={width:e.width(),height:e.height()},o=document.activeElement;try{o.id}catch(a){o=document.body}return e.wrap(s),(e[0]===o||t.contains(e[0],o))&&t(o).focus(),s=e.parent(),\"static\"===e.css(\"position\")?(s.css({position:\"relative\"}),e.css({position:\"relative\"})):(t.extend(i,{position:e.css(\"position\"),zIndex:e.css(\"z-index\")}),t.each([\"top\",\"left\",\"bottom\",\"right\"],function(t,s){i[s]=e.css(s),isNaN(parseInt(i[s],10))&&(i[s]=\"auto\")}),e.css({position:\"relative\",top:0,left:0,right:\"auto\",bottom:\"auto\"})),e.css(n),s.css(i).show()},removeWrapper:function(e){var i=document.activeElement;return e.parent().is(\".ui-effects-wrapper\")&&(e.parent().replaceWith(e),(e[0]===i||t.contains(e[0],i))&&t(i).focus()),e},setTransition:function(e,i,s,n){return n=n||{},t.each(i,function(t,i){var o=e.cssUnit(i);o[0]>0&&(n[i]=o[0]*s+o[1])}),n}}),t.fn.extend({effect:function(){function e(e){function s(){t.isFunction(o)&&o.call(n[0]),t.isFunction(e)&&e()}var n=t(this),o=i.complete,r=i.mode;(n.is(\":hidden\")?\"hide\"===r:\"show\"===r)?(n[r](),s()):a.call(n[0],i,s)}var i=s.apply(this,arguments),n=i.mode,o=i.queue,a=t.effects.effect[i.effect];return t.fx.off||!a?n?this[n](i.duration,i.complete):this.each(function(){i.complete&&i.complete.call(this)}):o===!1?this.each(e):this.queue(o||\"fx\",e)},show:function(t){return function(e){if(n(e))return t.apply(this,arguments);var i=s.apply(this,arguments);return i.mode=\"show\",this.effect.call(this,i)}}(t.fn.show),hide:function(t){return function(e){if(n(e))return t.apply(this,arguments);var i=s.apply(this,arguments);return i.mode=\"hide\",this.effect.call(this,i)}}(t.fn.hide),toggle:function(t){return function(e){if(n(e)||\"boolean\"==typeof e)return t.apply(this,arguments);var i=s.apply(this,arguments);return i.mode=\"toggle\",this.effect.call(this,i)}}(t.fn.toggle),cssUnit:function(e){var i=this.css(e),s=[];return t.each([\"em\",\"px\",\"%\",\"pt\"],function(t,e){i.indexOf(e)>0&&(s=[parseFloat(i),e])}),s}})}(),function(){var e={};t.each([\"Quad\",\"Cubic\",\"Quart\",\"Quint\",\"Expo\"],function(t,i){e[i]=function(e){return Math.pow(e,t+2)}}),t.extend(e,{Sine:function(t){return 1-Math.cos(t*Math.PI/2)},Circ:function(t){return 1-Math.sqrt(1-t*t)},Elastic:function(t){return 0===t||1===t?t:-Math.pow(2,8*(t-1))*Math.sin((80*(t-1)-7.5)*Math.PI/15)},Back:function(t){return t*t*(3*t-2)},Bounce:function(t){for(var e,i=4;((e=Math.pow(2,--i))-1)/11>t;);return 1/Math.pow(4,3-i)-7.5625*Math.pow((3*e-2)/22-t,2)}}),t.each(e,function(e,i){t.easing[\"easeIn\"+e]=i,t.easing[\"easeOut\"+e]=function(t){return 1-i(1-t)},t.easing[\"easeInOut\"+e]=function(t){return.5>t?i(2*t)/2:1-i(-2*t+2)/2}})}()}(jQuery),function(t){var e=0,i={},s={};i.height=i.paddingTop=i.paddingBottom=i.borderTopWidth=i.borderBottomWidth=\"hide\",s.height=s.paddingTop=s.paddingBottom=s.borderTopWidth=s.borderBottomWidth=\"show\",t.widget(\"ui.accordion\",{version:\"1.10.2\",options:{active:0,animate:{},collapsible:!1,event:\"click\",header:\"> li > :first-child,> :not(li):even\",heightStyle:\"auto\",icons:{activeHeader:\"ui-icon-triangle-1-s\",header:\"ui-icon-triangle-1-e\"},activate:null,beforeActivate:null},_create:function(){var e=this.options;this.prevShow=this.prevHide=t(),this.element.addClass(\"ui-accordion ui-widget ui-helper-reset\").attr(\"role\",\"tablist\"),e.collapsible||e.active!==!1&&null!=e.active||(e.active=0),this._processPanels(),0>e.active&&(e.active+=this.headers.length),this._refresh()},_getCreateEventData:function(){return{header:this.active,panel:this.active.length?this.active.next():t(),content:this.active.length?this.active.next():t()}},_createIcons:function(){var e=this.options.icons;e&&(t(\"<span>\").addClass(\"ui-accordion-header-icon ui-icon \"+e.header).prependTo(this.headers),this.active.children(\".ui-accordion-header-icon\").removeClass(e.header).addClass(e.activeHeader),this.headers.addClass(\"ui-accordion-icons\"))},_destroyIcons:function(){this.headers.removeClass(\"ui-accordion-icons\").children(\".ui-accordion-header-icon\").remove()\n},_destroy:function(){var t;this.element.removeClass(\"ui-accordion ui-widget ui-helper-reset\").removeAttr(\"role\"),this.headers.removeClass(\"ui-accordion-header ui-accordion-header-active ui-helper-reset ui-state-default ui-corner-all ui-state-active ui-state-disabled ui-corner-top\").removeAttr(\"role\").removeAttr(\"aria-selected\").removeAttr(\"aria-controls\").removeAttr(\"tabIndex\").each(function(){/^ui-accordion/.test(this.id)&&this.removeAttribute(\"id\")}),this._destroyIcons(),t=this.headers.next().css(\"display\",\"\").removeAttr(\"role\").removeAttr(\"aria-expanded\").removeAttr(\"aria-hidden\").removeAttr(\"aria-labelledby\").removeClass(\"ui-helper-reset ui-widget-content ui-corner-bottom ui-accordion-content ui-accordion-content-active ui-state-disabled\").each(function(){/^ui-accordion/.test(this.id)&&this.removeAttribute(\"id\")}),\"content\"!==this.options.heightStyle&&t.css(\"height\",\"\")},_setOption:function(t,e){return\"active\"===t?(this._activate(e),undefined):(\"event\"===t&&(this.options.event&&this._off(this.headers,this.options.event),this._setupEvents(e)),this._super(t,e),\"collapsible\"!==t||e||this.options.active!==!1||this._activate(0),\"icons\"===t&&(this._destroyIcons(),e&&this._createIcons()),\"disabled\"===t&&this.headers.add(this.headers.next()).toggleClass(\"ui-state-disabled\",!!e),undefined)},_keydown:function(e){if(!e.altKey&&!e.ctrlKey){var i=t.ui.keyCode,s=this.headers.length,n=this.headers.index(e.target),o=!1;switch(e.keyCode){case i.RIGHT:case i.DOWN:o=this.headers[(n+1)%s];break;case i.LEFT:case i.UP:o=this.headers[(n-1+s)%s];break;case i.SPACE:case i.ENTER:this._eventHandler(e);break;case i.HOME:o=this.headers[0];break;case i.END:o=this.headers[s-1]}o&&(t(e.target).attr(\"tabIndex\",-1),t(o).attr(\"tabIndex\",0),o.focus(),e.preventDefault())}},_panelKeyDown:function(e){e.keyCode===t.ui.keyCode.UP&&e.ctrlKey&&t(e.currentTarget).prev().focus()},refresh:function(){var e=this.options;this._processPanels(),(e.active===!1&&e.collapsible===!0||!this.headers.length)&&(e.active=!1,this.active=t()),e.active===!1?this._activate(0):this.active.length&&!t.contains(this.element[0],this.active[0])?this.headers.length===this.headers.find(\".ui-state-disabled\").length?(e.active=!1,this.active=t()):this._activate(Math.max(0,e.active-1)):e.active=this.headers.index(this.active),this._destroyIcons(),this._refresh()},_processPanels:function(){this.headers=this.element.find(this.options.header).addClass(\"ui-accordion-header ui-helper-reset ui-state-default ui-corner-all\"),this.headers.next().addClass(\"ui-accordion-content ui-helper-reset ui-widget-content ui-corner-bottom\").filter(\":not(.ui-accordion-content-active)\").hide()},_refresh:function(){var i,s=this.options,n=s.heightStyle,o=this.element.parent(),a=this.accordionId=\"ui-accordion-\"+(this.element.attr(\"id\")||++e);this.active=this._findActive(s.active).addClass(\"ui-accordion-header-active ui-state-active ui-corner-top\").removeClass(\"ui-corner-all\"),this.active.next().addClass(\"ui-accordion-content-active\").show(),this.headers.attr(\"role\",\"tab\").each(function(e){var i=t(this),s=i.attr(\"id\"),n=i.next(),o=n.attr(\"id\");s||(s=a+\"-header-\"+e,i.attr(\"id\",s)),o||(o=a+\"-panel-\"+e,n.attr(\"id\",o)),i.attr(\"aria-controls\",o),n.attr(\"aria-labelledby\",s)}).next().attr(\"role\",\"tabpanel\"),this.headers.not(this.active).attr({\"aria-selected\":\"false\",tabIndex:-1}).next().attr({\"aria-expanded\":\"false\",\"aria-hidden\":\"true\"}).hide(),this.active.length?this.active.attr({\"aria-selected\":\"true\",tabIndex:0}).next().attr({\"aria-expanded\":\"true\",\"aria-hidden\":\"false\"}):this.headers.eq(0).attr(\"tabIndex\",0),this._createIcons(),this._setupEvents(s.event),\"fill\"===n?(i=o.height(),this.element.siblings(\":visible\").each(function(){var e=t(this),s=e.css(\"position\");\"absolute\"!==s&&\"fixed\"!==s&&(i-=e.outerHeight(!0))}),this.headers.each(function(){i-=t(this).outerHeight(!0)}),this.headers.next().each(function(){t(this).height(Math.max(0,i-t(this).innerHeight()+t(this).height()))}).css(\"overflow\",\"auto\")):\"auto\"===n&&(i=0,this.headers.next().each(function(){i=Math.max(i,t(this).css(\"height\",\"\").height())}).height(i))},_activate:function(e){var i=this._findActive(e)[0];i!==this.active[0]&&(i=i||this.active[0],this._eventHandler({target:i,currentTarget:i,preventDefault:t.noop}))},_findActive:function(e){return\"number\"==typeof e?this.headers.eq(e):t()},_setupEvents:function(e){var i={keydown:\"_keydown\"};e&&t.each(e.split(\" \"),function(t,e){i[e]=\"_eventHandler\"}),this._off(this.headers.add(this.headers.next())),this._on(this.headers,i),this._on(this.headers.next(),{keydown:\"_panelKeyDown\"}),this._hoverable(this.headers),this._focusable(this.headers)},_eventHandler:function(e){var i=this.options,s=this.active,n=t(e.currentTarget),o=n[0]===s[0],a=o&&i.collapsible,r=a?t():n.next(),h=s.next(),l={oldHeader:s,oldPanel:h,newHeader:a?t():n,newPanel:r};e.preventDefault(),o&&!i.collapsible||this._trigger(\"beforeActivate\",e,l)===!1||(i.active=a?!1:this.headers.index(n),this.active=o?t():n,this._toggle(l),s.removeClass(\"ui-accordion-header-active ui-state-active\"),i.icons&&s.children(\".ui-accordion-header-icon\").removeClass(i.icons.activeHeader).addClass(i.icons.header),o||(n.removeClass(\"ui-corner-all\").addClass(\"ui-accordion-header-active ui-state-active ui-corner-top\"),i.icons&&n.children(\".ui-accordion-header-icon\").removeClass(i.icons.header).addClass(i.icons.activeHeader),n.next().addClass(\"ui-accordion-content-active\")))},_toggle:function(e){var i=e.newPanel,s=this.prevShow.length?this.prevShow:e.oldPanel;this.prevShow.add(this.prevHide).stop(!0,!0),this.prevShow=i,this.prevHide=s,this.options.animate?this._animate(i,s,e):(s.hide(),i.show(),this._toggleComplete(e)),s.attr({\"aria-expanded\":\"false\",\"aria-hidden\":\"true\"}),s.prev().attr(\"aria-selected\",\"false\"),i.length&&s.length?s.prev().attr(\"tabIndex\",-1):i.length&&this.headers.filter(function(){return 0===t(this).attr(\"tabIndex\")}).attr(\"tabIndex\",-1),i.attr({\"aria-expanded\":\"true\",\"aria-hidden\":\"false\"}).prev().attr({\"aria-selected\":\"true\",tabIndex:0})},_animate:function(t,e,n){var o,a,r,h=this,l=0,c=t.length&&(!e.length||t.index()<e.index()),u=this.options.animate||{},d=c&&u.down||u,p=function(){h._toggleComplete(n)};return\"number\"==typeof d&&(r=d),\"string\"==typeof d&&(a=d),a=a||d.easing||u.easing,r=r||d.duration||u.duration,e.length?t.length?(o=t.show().outerHeight(),e.animate(i,{duration:r,easing:a,step:function(t,e){e.now=Math.round(t)}}),t.hide().animate(s,{duration:r,easing:a,complete:p,step:function(t,i){i.now=Math.round(t),\"height\"!==i.prop?l+=i.now:\"content\"!==h.options.heightStyle&&(i.now=Math.round(o-e.outerHeight()-l),l=0)}}),undefined):e.animate(i,r,a,p):t.animate(s,r,a,p)},_toggleComplete:function(t){var e=t.oldPanel;e.removeClass(\"ui-accordion-content-active\").prev().removeClass(\"ui-corner-top\").addClass(\"ui-corner-all\"),e.length&&(e.parent()[0].className=e.parent()[0].className),this._trigger(\"activate\",null,t)}})}(jQuery),function(t){var e=0;t.widget(\"ui.autocomplete\",{version:\"1.10.2\",defaultElement:\"<input>\",options:{appendTo:null,autoFocus:!1,delay:300,minLength:1,position:{my:\"left top\",at:\"left bottom\",collision:\"none\"},source:null,change:null,close:null,focus:null,open:null,response:null,search:null,select:null},pending:0,_create:function(){var e,i,s,n=this.element[0].nodeName.toLowerCase(),o=\"textarea\"===n,a=\"input\"===n;this.isMultiLine=o?!0:a?!1:this.element.prop(\"isContentEditable\"),this.valueMethod=this.element[o||a?\"val\":\"text\"],this.isNewMenu=!0,this.element.addClass(\"ui-autocomplete-input\").attr(\"autocomplete\",\"off\"),this._on(this.element,{keydown:function(n){if(this.element.prop(\"readOnly\"))return e=!0,s=!0,i=!0,undefined;e=!1,s=!1,i=!1;var o=t.ui.keyCode;switch(n.keyCode){case o.PAGE_UP:e=!0,this._move(\"previousPage\",n);break;case o.PAGE_DOWN:e=!0,this._move(\"nextPage\",n);break;case o.UP:e=!0,this._keyEvent(\"previous\",n);break;case o.DOWN:e=!0,this._keyEvent(\"next\",n);break;case o.ENTER:case o.NUMPAD_ENTER:this.menu.active&&(e=!0,n.preventDefault(),this.menu.select(n));break;case o.TAB:this.menu.active&&this.menu.select(n);break;case o.ESCAPE:this.menu.element.is(\":visible\")&&(this._value(this.term),this.close(n),n.preventDefault());break;default:i=!0,this._searchTimeout(n)}},keypress:function(s){if(e)return e=!1,s.preventDefault(),undefined;if(!i){var n=t.ui.keyCode;switch(s.keyCode){case n.PAGE_UP:this._move(\"previousPage\",s);break;case n.PAGE_DOWN:this._move(\"nextPage\",s);break;case n.UP:this._keyEvent(\"previous\",s);break;case n.DOWN:this._keyEvent(\"next\",s)}}},input:function(t){return s?(s=!1,t.preventDefault(),undefined):(this._searchTimeout(t),undefined)},focus:function(){this.selectedItem=null,this.previous=this._value()},blur:function(t){return this.cancelBlur?(delete this.cancelBlur,undefined):(clearTimeout(this.searching),this.close(t),this._change(t),undefined)}}),this._initSource(),this.menu=t(\"<ul>\").addClass(\"ui-autocomplete ui-front\").appendTo(this._appendTo()).menu({input:t(),role:null}).hide().data(\"ui-menu\"),this._on(this.menu.element,{mousedown:function(e){e.preventDefault(),this.cancelBlur=!0,this._delay(function(){delete this.cancelBlur});var i=this.menu.element[0];t(e.target).closest(\".ui-menu-item\").length||this._delay(function(){var e=this;this.document.one(\"mousedown\",function(s){s.target===e.element[0]||s.target===i||t.contains(i,s.target)||e.close()})})},menufocus:function(e,i){if(this.isNewMenu&&(this.isNewMenu=!1,e.originalEvent&&/^mouse/.test(e.originalEvent.type)))return this.menu.blur(),this.document.one(\"mousemove\",function(){t(e.target).trigger(e.originalEvent)}),undefined;var s=i.item.data(\"ui-autocomplete-item\");!1!==this._trigger(\"focus\",e,{item:s})?e.originalEvent&&/^key/.test(e.originalEvent.type)&&this._value(s.value):this.liveRegion.text(s.value)},menuselect:function(t,e){var i=e.item.data(\"ui-autocomplete-item\"),s=this.previous;this.element[0]!==this.document[0].activeElement&&(this.element.focus(),this.previous=s,this._delay(function(){this.previous=s,this.selectedItem=i})),!1!==this._trigger(\"select\",t,{item:i})&&this._value(i.value),this.term=this._value(),this.close(t),this.selectedItem=i}}),this.liveRegion=t(\"<span>\",{role:\"status\",\"aria-live\":\"polite\"}).addClass(\"ui-helper-hidden-accessible\").insertAfter(this.element),this._on(this.window,{beforeunload:function(){this.element.removeAttr(\"autocomplete\")}})},_destroy:function(){clearTimeout(this.searching),this.element.removeClass(\"ui-autocomplete-input\").removeAttr(\"autocomplete\"),this.menu.element.remove(),this.liveRegion.remove()},_setOption:function(t,e){this._super(t,e),\"source\"===t&&this._initSource(),\"appendTo\"===t&&this.menu.element.appendTo(this._appendTo()),\"disabled\"===t&&e&&this.xhr&&this.xhr.abort()},_appendTo:function(){var e=this.options.appendTo;return e&&(e=e.jquery||e.nodeType?t(e):this.document.find(e).eq(0)),e||(e=this.element.closest(\".ui-front\")),e.length||(e=this.document[0].body),e},_initSource:function(){var e,i,s=this;t.isArray(this.options.source)?(e=this.options.source,this.source=function(i,s){s(t.ui.autocomplete.filter(e,i.term))}):\"string\"==typeof this.options.source?(i=this.options.source,this.source=function(e,n){s.xhr&&s.xhr.abort(),s.xhr=t.ajax({url:i,data:e,dataType:\"json\",success:function(t){n(t)},error:function(){n([])}})}):this.source=this.options.source},_searchTimeout:function(t){clearTimeout(this.searching),this.searching=this._delay(function(){this.term!==this._value()&&(this.selectedItem=null,this.search(null,t))},this.options.delay)},search:function(t,e){return t=null!=t?t:this._value(),this.term=this._value(),t.length<this.options.minLength?this.close(e):this._trigger(\"search\",e)!==!1?this._search(t):undefined},_search:function(t){this.pending++,this.element.addClass(\"ui-autocomplete-loading\"),this.cancelSearch=!1,this.source({term:t},this._response())},_response:function(){var t=this,i=++e;return function(s){i===e&&t.__response(s),t.pending--,t.pending||t.element.removeClass(\"ui-autocomplete-loading\")}},__response:function(t){t&&(t=this._normalize(t)),this._trigger(\"response\",null,{content:t}),!this.options.disabled&&t&&t.length&&!this.cancelSearch?(this._suggest(t),this._trigger(\"open\")):this._close()},close:function(t){this.cancelSearch=!0,this._close(t)},_close:function(t){this.menu.element.is(\":visible\")&&(this.menu.element.hide(),this.menu.blur(),this.isNewMenu=!0,this._trigger(\"close\",t))},_change:function(t){this.previous!==this._value()&&this._trigger(\"change\",t,{item:this.selectedItem})},_normalize:function(e){return e.length&&e[0].label&&e[0].value?e:t.map(e,function(e){return\"string\"==typeof e?{label:e,value:e}:t.extend({label:e.label||e.value,value:e.value||e.label},e)})},_suggest:function(e){var i=this.menu.element.empty();this._renderMenu(i,e),this.isNewMenu=!0,this.menu.refresh(),i.show(),this._resizeMenu(),i.position(t.extend({of:this.element},this.options.position)),this.options.autoFocus&&this.menu.next()},_resizeMenu:function(){var t=this.menu.element;t.outerWidth(Math.max(t.width(\"\").outerWidth()+1,this.element.outerWidth()))},_renderMenu:function(e,i){var s=this;t.each(i,function(t,i){s._renderItemData(e,i)})},_renderItemData:function(t,e){return this._renderItem(t,e).data(\"ui-autocomplete-item\",e)},_renderItem:function(e,i){return t(\"<li>\").append(t(\"<a>\").text(i.label)).appendTo(e)},_move:function(t,e){return this.menu.element.is(\":visible\")?this.menu.isFirstItem()&&/^previous/.test(t)||this.menu.isLastItem()&&/^next/.test(t)?(this._value(this.term),this.menu.blur(),undefined):(this.menu[t](e),undefined):(this.search(null,e),undefined)},widget:function(){return this.menu.element},_value:function(){return this.valueMethod.apply(this.element,arguments)},_keyEvent:function(t,e){(!this.isMultiLine||this.menu.element.is(\":visible\"))&&(this._move(t,e),e.preventDefault())}}),t.extend(t.ui.autocomplete,{escapeRegex:function(t){return t.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g,\"\\\\$&\")},filter:function(e,i){var s=RegExp(t.ui.autocomplete.escapeRegex(i),\"i\");return t.grep(e,function(t){return s.test(t.label||t.value||t)})}}),t.widget(\"ui.autocomplete\",t.ui.autocomplete,{options:{messages:{noResults:\"No search results.\",results:function(t){return t+(t>1?\" results are\":\" result is\")+\" available, use up and down arrow keys to navigate.\"}}},__response:function(t){var e;this._superApply(arguments),this.options.disabled||this.cancelSearch||(e=t&&t.length?this.options.messages.results(t.length):this.options.messages.noResults,this.liveRegion.text(e))}})}(jQuery),function(t){var e,i,s,n,o=\"ui-button ui-widget ui-state-default ui-corner-all\",a=\"ui-state-hover ui-state-active \",r=\"ui-button-icons-only ui-button-icon-only ui-button-text-icons ui-button-text-icon-primary ui-button-text-icon-secondary ui-button-text-only\",h=function(){var e=t(this).find(\":ui-button\");setTimeout(function(){e.button(\"refresh\")},1)},l=function(e){var i=e.name,s=e.form,n=t([]);return i&&(i=i.replace(/'/g,\"\\\\'\"),n=s?t(s).find(\"[name='\"+i+\"']\"):t(\"[name='\"+i+\"']\",e.ownerDocument).filter(function(){return!this.form})),n};t.widget(\"ui.button\",{version:\"1.10.2\",defaultElement:\"<button>\",options:{disabled:null,text:!0,label:null,icons:{primary:null,secondary:null}},_create:function(){this.element.closest(\"form\").unbind(\"reset\"+this.eventNamespace).bind(\"reset\"+this.eventNamespace,h),\"boolean\"!=typeof this.options.disabled?this.options.disabled=!!this.element.prop(\"disabled\"):this.element.prop(\"disabled\",this.options.disabled),this._determineButtonType(),this.hasTitle=!!this.buttonElement.attr(\"title\");var a=this,r=this.options,c=\"checkbox\"===this.type||\"radio\"===this.type,u=c?\"\":\"ui-state-active\",d=\"ui-state-focus\";null===r.label&&(r.label=\"input\"===this.type?this.buttonElement.val():this.buttonElement.html()),this._hoverable(this.buttonElement),this.buttonElement.addClass(o).attr(\"role\",\"button\").bind(\"mouseenter\"+this.eventNamespace,function(){r.disabled||this===e&&t(this).addClass(\"ui-state-active\")}).bind(\"mouseleave\"+this.eventNamespace,function(){r.disabled||t(this).removeClass(u)}).bind(\"click\"+this.eventNamespace,function(t){r.disabled&&(t.preventDefault(),t.stopImmediatePropagation())}),this.element.bind(\"focus\"+this.eventNamespace,function(){a.buttonElement.addClass(d)}).bind(\"blur\"+this.eventNamespace,function(){a.buttonElement.removeClass(d)}),c&&(this.element.bind(\"change\"+this.eventNamespace,function(){n||a.refresh()}),this.buttonElement.bind(\"mousedown\"+this.eventNamespace,function(t){r.disabled||(n=!1,i=t.pageX,s=t.pageY)}).bind(\"mouseup\"+this.eventNamespace,function(t){r.disabled||(i!==t.pageX||s!==t.pageY)&&(n=!0)})),\"checkbox\"===this.type?this.buttonElement.bind(\"click\"+this.eventNamespace,function(){return r.disabled||n?!1:undefined}):\"radio\"===this.type?this.buttonElement.bind(\"click\"+this.eventNamespace,function(){if(r.disabled||n)return!1;t(this).addClass(\"ui-state-active\"),a.buttonElement.attr(\"aria-pressed\",\"true\");var e=a.element[0];l(e).not(e).map(function(){return t(this).button(\"widget\")[0]}).removeClass(\"ui-state-active\").attr(\"aria-pressed\",\"false\")}):(this.buttonElement.bind(\"mousedown\"+this.eventNamespace,function(){return r.disabled?!1:(t(this).addClass(\"ui-state-active\"),e=this,a.document.one(\"mouseup\",function(){e=null}),undefined)}).bind(\"mouseup\"+this.eventNamespace,function(){return r.disabled?!1:(t(this).removeClass(\"ui-state-active\"),undefined)}).bind(\"keydown\"+this.eventNamespace,function(e){return r.disabled?!1:((e.keyCode===t.ui.keyCode.SPACE||e.keyCode===t.ui.keyCode.ENTER)&&t(this).addClass(\"ui-state-active\"),undefined)}).bind(\"keyup\"+this.eventNamespace+\" blur\"+this.eventNamespace,function(){t(this).removeClass(\"ui-state-active\")}),this.buttonElement.is(\"a\")&&this.buttonElement.keyup(function(e){e.keyCode===t.ui.keyCode.SPACE&&t(this).click()})),this._setOption(\"disabled\",r.disabled),this._resetButton()},_determineButtonType:function(){var t,e,i;this.type=this.element.is(\"[type=checkbox]\")?\"checkbox\":this.element.is(\"[type=radio]\")?\"radio\":this.element.is(\"input\")?\"input\":\"button\",\"checkbox\"===this.type||\"radio\"===this.type?(t=this.element.parents().last(),e=\"label[for='\"+this.element.attr(\"id\")+\"']\",this.buttonElement=t.find(e),this.buttonElement.length||(t=t.length?t.siblings():this.element.siblings(),this.buttonElement=t.filter(e),this.buttonElement.length||(this.buttonElement=t.find(e))),this.element.addClass(\"ui-helper-hidden-accessible\"),i=this.element.is(\":checked\"),i&&this.buttonElement.addClass(\"ui-state-active\"),this.buttonElement.prop(\"aria-pressed\",i)):this.buttonElement=this.element},widget:function(){return this.buttonElement},_destroy:function(){this.element.removeClass(\"ui-helper-hidden-accessible\"),this.buttonElement.removeClass(o+\" \"+a+\" \"+r).removeAttr(\"role\").removeAttr(\"aria-pressed\").html(this.buttonElement.find(\".ui-button-text\").html()),this.hasTitle||this.buttonElement.removeAttr(\"title\")},_setOption:function(t,e){return this._super(t,e),\"disabled\"===t?(e?this.element.prop(\"disabled\",!0):this.element.prop(\"disabled\",!1),undefined):(this._resetButton(),undefined)},refresh:function(){var e=this.element.is(\"input, button\")?this.element.is(\":disabled\"):this.element.hasClass(\"ui-button-disabled\");e!==this.options.disabled&&this._setOption(\"disabled\",e),\"radio\"===this.type?l(this.element[0]).each(function(){t(this).is(\":checked\")?t(this).button(\"widget\").addClass(\"ui-state-active\").attr(\"aria-pressed\",\"true\"):t(this).button(\"widget\").removeClass(\"ui-state-active\").attr(\"aria-pressed\",\"false\")}):\"checkbox\"===this.type&&(this.element.is(\":checked\")?this.buttonElement.addClass(\"ui-state-active\").attr(\"aria-pressed\",\"true\"):this.buttonElement.removeClass(\"ui-state-active\").attr(\"aria-pressed\",\"false\"))},_resetButton:function(){if(\"input\"===this.type)return this.options.label&&this.element.val(this.options.label),undefined;var e=this.buttonElement.removeClass(r),i=t(\"<span></span>\",this.document[0]).addClass(\"ui-button-text\").html(this.options.label).appendTo(e.empty()).text(),s=this.options.icons,n=s.primary&&s.secondary,o=[];s.primary||s.secondary?(this.options.text&&o.push(\"ui-button-text-icon\"+(n?\"s\":s.primary?\"-primary\":\"-secondary\")),s.primary&&e.prepend(\"<span class='ui-button-icon-primary ui-icon \"+s.primary+\"'></span>\"),s.secondary&&e.append(\"<span class='ui-button-icon-secondary ui-icon \"+s.secondary+\"'></span>\"),this.options.text||(o.push(n?\"ui-button-icons-only\":\"ui-button-icon-only\"),this.hasTitle||e.attr(\"title\",t.trim(i)))):o.push(\"ui-button-text-only\"),e.addClass(o.join(\" \"))}}),t.widget(\"ui.buttonset\",{version:\"1.10.2\",options:{items:\"button, input[type=button], input[type=submit], input[type=reset], input[type=checkbox], input[type=radio], a, :data(ui-button)\"},_create:function(){this.element.addClass(\"ui-buttonset\")},_init:function(){this.refresh()},_setOption:function(t,e){\"disabled\"===t&&this.buttons.button(\"option\",t,e),this._super(t,e)},refresh:function(){var e=\"rtl\"===this.element.css(\"direction\");this.buttons=this.element.find(this.options.items).filter(\":ui-button\").button(\"refresh\").end().not(\":ui-button\").button().end().map(function(){return t(this).button(\"widget\")[0]}).removeClass(\"ui-corner-all ui-corner-left ui-corner-right\").filter(\":first\").addClass(e?\"ui-corner-right\":\"ui-corner-left\").end().filter(\":last\").addClass(e?\"ui-corner-left\":\"ui-corner-right\").end().end()},_destroy:function(){this.element.removeClass(\"ui-buttonset\"),this.buttons.map(function(){return t(this).button(\"widget\")[0]}).removeClass(\"ui-corner-left ui-corner-right\").end().button(\"destroy\")}})}(jQuery),function(t,e){function i(){this._curInst=null,this._keyEvent=!1,this._disabledInputs=[],this._datepickerShowing=!1,this._inDialog=!1,this._mainDivId=\"ui-datepicker-div\",this._inlineClass=\"ui-datepicker-inline\",this._appendClass=\"ui-datepicker-append\",this._triggerClass=\"ui-datepicker-trigger\",this._dialogClass=\"ui-datepicker-dialog\",this._disableClass=\"ui-datepicker-disabled\",this._unselectableClass=\"ui-datepicker-unselectable\",this._currentClass=\"ui-datepicker-current-day\",this._dayOverClass=\"ui-datepicker-days-cell-over\",this.regional=[],this.regional[\"\"]={closeText:\"Done\",prevText:\"Prev\",nextText:\"Next\",currentText:\"Today\",monthNames:[\"January\",\"February\",\"March\",\"April\",\"May\",\"June\",\"July\",\"August\",\"September\",\"October\",\"November\",\"December\"],monthNamesShort:[\"Jan\",\"Feb\",\"Mar\",\"Apr\",\"May\",\"Jun\",\"Jul\",\"Aug\",\"Sep\",\"Oct\",\"Nov\",\"Dec\"],dayNames:[\"Sunday\",\"Monday\",\"Tuesday\",\"Wednesday\",\"Thursday\",\"Friday\",\"Saturday\"],dayNamesShort:[\"Sun\",\"Mon\",\"Tue\",\"Wed\",\"Thu\",\"Fri\",\"Sat\"],dayNamesMin:[\"Su\",\"Mo\",\"Tu\",\"We\",\"Th\",\"Fr\",\"Sa\"],weekHeader:\"Wk\",dateFormat:\"mm/dd/yy\",firstDay:0,isRTL:!1,showMonthAfterYear:!1,yearSuffix:\"\"},this._defaults={showOn:\"focus\",showAnim:\"fadeIn\",showOptions:{},defaultDate:null,appendText:\"\",buttonText:\"...\",buttonImage:\"\",buttonImageOnly:!1,hideIfNoPrevNext:!1,navigationAsDateFormat:!1,gotoCurrent:!1,changeMonth:!1,changeYear:!1,yearRange:\"c-10:c+10\",showOtherMonths:!1,selectOtherMonths:!1,showWeek:!1,calculateWeek:this.iso8601Week,shortYearCutoff:\"+10\",minDate:null,maxDate:null,duration:\"fast\",beforeShowDay:null,beforeShow:null,onSelect:null,onChangeMonthYear:null,onClose:null,numberOfMonths:1,showCurrentAtPos:0,stepMonths:1,stepBigMonths:12,altField:\"\",altFormat:\"\",constrainInput:!0,showButtonPanel:!1,autoSize:!1,disabled:!1},t.extend(this._defaults,this.regional[\"\"]),this.dpDiv=s(t(\"<div id='\"+this._mainDivId+\"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\"))}function s(e){var i=\"button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a\";return e.delegate(i,\"mouseout\",function(){t(this).removeClass(\"ui-state-hover\"),-1!==this.className.indexOf(\"ui-datepicker-prev\")&&t(this).removeClass(\"ui-datepicker-prev-hover\"),-1!==this.className.indexOf(\"ui-datepicker-next\")&&t(this).removeClass(\"ui-datepicker-next-hover\")}).delegate(i,\"mouseover\",function(){t.datepicker._isDisabledDatepicker(o.inline?e.parent()[0]:o.input[0])||(t(this).parents(\".ui-datepicker-calendar\").find(\"a\").removeClass(\"ui-state-hover\"),t(this).addClass(\"ui-state-hover\"),-1!==this.className.indexOf(\"ui-datepicker-prev\")&&t(this).addClass(\"ui-datepicker-prev-hover\"),-1!==this.className.indexOf(\"ui-datepicker-next\")&&t(this).addClass(\"ui-datepicker-next-hover\"))})}function n(e,i){t.extend(e,i);for(var s in i)null==i[s]&&(e[s]=i[s]);return e}t.extend(t.ui,{datepicker:{version:\"1.10.2\"}});var o,a=\"datepicker\",r=(new Date).getTime();t.extend(i.prototype,{markerClassName:\"hasDatepicker\",maxRows:4,_widgetDatepicker:function(){return this.dpDiv},setDefaults:function(t){return n(this._defaults,t||{}),this},_attachDatepicker:function(e,i){var s,n,o;s=e.nodeName.toLowerCase(),n=\"div\"===s||\"span\"===s,e.id||(this.uuid+=1,e.id=\"dp\"+this.uuid),o=this._newInst(t(e),n),o.settings=t.extend({},i||{}),\"input\"===s?this._connectDatepicker(e,o):n&&this._inlineDatepicker(e,o)},_newInst:function(e,i){var n=e[0].id.replace(/([^A-Za-z0-9_\\-])/g,\"\\\\\\\\$1\");return{id:n,input:e,selectedDay:0,selectedMonth:0,selectedYear:0,drawMonth:0,drawYear:0,inline:i,dpDiv:i?s(t(\"<div class='\"+this._inlineClass+\" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\")):this.dpDiv}},_connectDatepicker:function(e,i){var s=t(e);i.append=t([]),i.trigger=t([]),s.hasClass(this.markerClassName)||(this._attachments(s,i),s.addClass(this.markerClassName).keydown(this._doKeyDown).keypress(this._doKeyPress).keyup(this._doKeyUp),this._autoSize(i),t.data(e,a,i),i.settings.disabled&&this._disableDatepicker(e))},_attachments:function(e,i){var s,n,o,a=this._get(i,\"appendText\"),r=this._get(i,\"isRTL\");i.append&&i.append.remove(),a&&(i.append=t(\"<span class='\"+this._appendClass+\"'>\"+a+\"</span>\"),e[r?\"before\":\"after\"](i.append)),e.unbind(\"focus\",this._showDatepicker),i.trigger&&i.trigger.remove(),s=this._get(i,\"showOn\"),(\"focus\"===s||\"both\"===s)&&e.focus(this._showDatepicker),(\"button\"===s||\"both\"===s)&&(n=this._get(i,\"buttonText\"),o=this._get(i,\"buttonImage\"),i.trigger=t(this._get(i,\"buttonImageOnly\")?t(\"<img/>\").addClass(this._triggerClass).attr({src:o,alt:n,title:n}):t(\"<button type='button'></button>\").addClass(this._triggerClass).html(o?t(\"<img/>\").attr({src:o,alt:n,title:n}):n)),e[r?\"before\":\"after\"](i.trigger),i.trigger.click(function(){return t.datepicker._datepickerShowing&&t.datepicker._lastInput===e[0]?t.datepicker._hideDatepicker():t.datepicker._datepickerShowing&&t.datepicker._lastInput!==e[0]?(t.datepicker._hideDatepicker(),t.datepicker._showDatepicker(e[0])):t.datepicker._showDatepicker(e[0]),!1}))},_autoSize:function(t){if(this._get(t,\"autoSize\")&&!t.inline){var e,i,s,n,o=new Date(2009,11,20),a=this._get(t,\"dateFormat\");a.match(/[DM]/)&&(e=function(t){for(i=0,s=0,n=0;t.length>n;n++)t[n].length>i&&(i=t[n].length,s=n);return s},o.setMonth(e(this._get(t,a.match(/MM/)?\"monthNames\":\"monthNamesShort\"))),o.setDate(e(this._get(t,a.match(/DD/)?\"dayNames\":\"dayNamesShort\"))+20-o.getDay())),t.input.attr(\"size\",this._formatDate(t,o).length)}},_inlineDatepicker:function(e,i){var s=t(e);s.hasClass(this.markerClassName)||(s.addClass(this.markerClassName).append(i.dpDiv),t.data(e,a,i),this._setDate(i,this._getDefaultDate(i),!0),this._updateDatepicker(i),this._updateAlternate(i),i.settings.disabled&&this._disableDatepicker(e),i.dpDiv.css(\"display\",\"block\"))},_dialogDatepicker:function(e,i,s,o,r){var h,l,c,u,d,p=this._dialogInst;return p||(this.uuid+=1,h=\"dp\"+this.uuid,this._dialogInput=t(\"<input type='text' id='\"+h+\"' style='position: absolute; top: -100px; width: 0px;'/>\"),this._dialogInput.keydown(this._doKeyDown),t(\"body\").append(this._dialogInput),p=this._dialogInst=this._newInst(this._dialogInput,!1),p.settings={},t.data(this._dialogInput[0],a,p)),n(p.settings,o||{}),i=i&&i.constructor===Date?this._formatDate(p,i):i,this._dialogInput.val(i),this._pos=r?r.length?r:[r.pageX,r.pageY]:null,this._pos||(l=document.documentElement.clientWidth,c=document.documentElement.clientHeight,u=document.documentElement.scrollLeft||document.body.scrollLeft,d=document.documentElement.scrollTop||document.body.scrollTop,this._pos=[l/2-100+u,c/2-150+d]),this._dialogInput.css(\"left\",this._pos[0]+20+\"px\").css(\"top\",this._pos[1]+\"px\"),p.settings.onSelect=s,this._inDialog=!0,this.dpDiv.addClass(this._dialogClass),this._showDatepicker(this._dialogInput[0]),t.blockUI&&t.blockUI(this.dpDiv),t.data(this._dialogInput[0],a,p),this},_destroyDatepicker:function(e){var i,s=t(e),n=t.data(e,a);s.hasClass(this.markerClassName)&&(i=e.nodeName.toLowerCase(),t.removeData(e,a),\"input\"===i?(n.append.remove(),n.trigger.remove(),s.removeClass(this.markerClassName).unbind(\"focus\",this._showDatepicker).unbind(\"keydown\",this._doKeyDown).unbind(\"keypress\",this._doKeyPress).unbind(\"keyup\",this._doKeyUp)):(\"div\"===i||\"span\"===i)&&s.removeClass(this.markerClassName).empty())},_enableDatepicker:function(e){var i,s,n=t(e),o=t.data(e,a);n.hasClass(this.markerClassName)&&(i=e.nodeName.toLowerCase(),\"input\"===i?(e.disabled=!1,o.trigger.filter(\"button\").each(function(){this.disabled=!1}).end().filter(\"img\").css({opacity:\"1.0\",cursor:\"\"})):(\"div\"===i||\"span\"===i)&&(s=n.children(\".\"+this._inlineClass),s.children().removeClass(\"ui-state-disabled\"),s.find(\"select.ui-datepicker-month, select.ui-datepicker-year\").prop(\"disabled\",!1)),this._disabledInputs=t.map(this._disabledInputs,function(t){return t===e?null:t}))},_disableDatepicker:function(e){var i,s,n=t(e),o=t.data(e,a);n.hasClass(this.markerClassName)&&(i=e.nodeName.toLowerCase(),\"input\"===i?(e.disabled=!0,o.trigger.filter(\"button\").each(function(){this.disabled=!0}).end().filter(\"img\").css({opacity:\"0.5\",cursor:\"default\"})):(\"div\"===i||\"span\"===i)&&(s=n.children(\".\"+this._inlineClass),s.children().addClass(\"ui-state-disabled\"),s.find(\"select.ui-datepicker-month, select.ui-datepicker-year\").prop(\"disabled\",!0)),this._disabledInputs=t.map(this._disabledInputs,function(t){return t===e?null:t}),this._disabledInputs[this._disabledInputs.length]=e)},_isDisabledDatepicker:function(t){if(!t)return!1;for(var e=0;this._disabledInputs.length>e;e++)if(this._disabledInputs[e]===t)return!0;return!1},_getInst:function(e){try{return t.data(e,a)}catch(i){throw\"Missing instance data for this datepicker\"}},_optionDatepicker:function(i,s,o){var a,r,h,l,c=this._getInst(i);return 2===arguments.length&&\"string\"==typeof s?\"defaults\"===s?t.extend({},t.datepicker._defaults):c?\"all\"===s?t.extend({},c.settings):this._get(c,s):null:(a=s||{},\"string\"==typeof s&&(a={},a[s]=o),c&&(this._curInst===c&&this._hideDatepicker(),r=this._getDateDatepicker(i,!0),h=this._getMinMaxDate(c,\"min\"),l=this._getMinMaxDate(c,\"max\"),n(c.settings,a),null!==h&&a.dateFormat!==e&&a.minDate===e&&(c.settings.minDate=this._formatDate(c,h)),null!==l&&a.dateFormat!==e&&a.maxDate===e&&(c.settings.maxDate=this._formatDate(c,l)),\"disabled\"in a&&(a.disabled?this._disableDatepicker(i):this._enableDatepicker(i)),this._attachments(t(i),c),this._autoSize(c),this._setDate(c,r),this._updateAlternate(c),this._updateDatepicker(c)),e)},_changeDatepicker:function(t,e,i){this._optionDatepicker(t,e,i)},_refreshDatepicker:function(t){var e=this._getInst(t);e&&this._updateDatepicker(e)},_setDateDatepicker:function(t,e){var i=this._getInst(t);i&&(this._setDate(i,e),this._updateDatepicker(i),this._updateAlternate(i))},_getDateDatepicker:function(t,e){var i=this._getInst(t);return i&&!i.inline&&this._setDateFromField(i,e),i?this._getDate(i):null},_doKeyDown:function(e){var i,s,n,o=t.datepicker._getInst(e.target),a=!0,r=o.dpDiv.is(\".ui-datepicker-rtl\");if(o._keyEvent=!0,t.datepicker._datepickerShowing)switch(e.keyCode){case 9:t.datepicker._hideDatepicker(),a=!1;break;case 13:return n=t(\"td.\"+t.datepicker._dayOverClass+\":not(.\"+t.datepicker._currentClass+\")\",o.dpDiv),n[0]&&t.datepicker._selectDay(e.target,o.selectedMonth,o.selectedYear,n[0]),i=t.datepicker._get(o,\"onSelect\"),i?(s=t.datepicker._formatDate(o),i.apply(o.input?o.input[0]:null,[s,o])):t.datepicker._hideDatepicker(),!1;case 27:t.datepicker._hideDatepicker();break;case 33:t.datepicker._adjustDate(e.target,e.ctrlKey?-t.datepicker._get(o,\"stepBigMonths\"):-t.datepicker._get(o,\"stepMonths\"),\"M\");\nbreak;case 34:t.datepicker._adjustDate(e.target,e.ctrlKey?+t.datepicker._get(o,\"stepBigMonths\"):+t.datepicker._get(o,\"stepMonths\"),\"M\");break;case 35:(e.ctrlKey||e.metaKey)&&t.datepicker._clearDate(e.target),a=e.ctrlKey||e.metaKey;break;case 36:(e.ctrlKey||e.metaKey)&&t.datepicker._gotoToday(e.target),a=e.ctrlKey||e.metaKey;break;case 37:(e.ctrlKey||e.metaKey)&&t.datepicker._adjustDate(e.target,r?1:-1,\"D\"),a=e.ctrlKey||e.metaKey,e.originalEvent.altKey&&t.datepicker._adjustDate(e.target,e.ctrlKey?-t.datepicker._get(o,\"stepBigMonths\"):-t.datepicker._get(o,\"stepMonths\"),\"M\");break;case 38:(e.ctrlKey||e.metaKey)&&t.datepicker._adjustDate(e.target,-7,\"D\"),a=e.ctrlKey||e.metaKey;break;case 39:(e.ctrlKey||e.metaKey)&&t.datepicker._adjustDate(e.target,r?-1:1,\"D\"),a=e.ctrlKey||e.metaKey,e.originalEvent.altKey&&t.datepicker._adjustDate(e.target,e.ctrlKey?+t.datepicker._get(o,\"stepBigMonths\"):+t.datepicker._get(o,\"stepMonths\"),\"M\");break;case 40:(e.ctrlKey||e.metaKey)&&t.datepicker._adjustDate(e.target,7,\"D\"),a=e.ctrlKey||e.metaKey;break;default:a=!1}else 36===e.keyCode&&e.ctrlKey?t.datepicker._showDatepicker(this):a=!1;a&&(e.preventDefault(),e.stopPropagation())},_doKeyPress:function(i){var s,n,o=t.datepicker._getInst(i.target);return t.datepicker._get(o,\"constrainInput\")?(s=t.datepicker._possibleChars(t.datepicker._get(o,\"dateFormat\")),n=String.fromCharCode(null==i.charCode?i.keyCode:i.charCode),i.ctrlKey||i.metaKey||\" \">n||!s||s.indexOf(n)>-1):e},_doKeyUp:function(e){var i,s=t.datepicker._getInst(e.target);if(s.input.val()!==s.lastVal)try{i=t.datepicker.parseDate(t.datepicker._get(s,\"dateFormat\"),s.input?s.input.val():null,t.datepicker._getFormatConfig(s)),i&&(t.datepicker._setDateFromField(s),t.datepicker._updateAlternate(s),t.datepicker._updateDatepicker(s))}catch(n){}return!0},_showDatepicker:function(e){if(e=e.target||e,\"input\"!==e.nodeName.toLowerCase()&&(e=t(\"input\",e.parentNode)[0]),!t.datepicker._isDisabledDatepicker(e)&&t.datepicker._lastInput!==e){var i,s,o,a,r,h,l;i=t.datepicker._getInst(e),t.datepicker._curInst&&t.datepicker._curInst!==i&&(t.datepicker._curInst.dpDiv.stop(!0,!0),i&&t.datepicker._datepickerShowing&&t.datepicker._hideDatepicker(t.datepicker._curInst.input[0])),s=t.datepicker._get(i,\"beforeShow\"),o=s?s.apply(e,[e,i]):{},o!==!1&&(n(i.settings,o),i.lastVal=null,t.datepicker._lastInput=e,t.datepicker._setDateFromField(i),t.datepicker._inDialog&&(e.value=\"\"),t.datepicker._pos||(t.datepicker._pos=t.datepicker._findPos(e),t.datepicker._pos[1]+=e.offsetHeight),a=!1,t(e).parents().each(function(){return a|=\"fixed\"===t(this).css(\"position\"),!a}),r={left:t.datepicker._pos[0],top:t.datepicker._pos[1]},t.datepicker._pos=null,i.dpDiv.empty(),i.dpDiv.css({position:\"absolute\",display:\"block\",top:\"-1000px\"}),t.datepicker._updateDatepicker(i),r=t.datepicker._checkOffset(i,r,a),i.dpDiv.css({position:t.datepicker._inDialog&&t.blockUI?\"static\":a?\"fixed\":\"absolute\",display:\"none\",left:r.left+\"px\",top:r.top+\"px\"}),i.inline||(h=t.datepicker._get(i,\"showAnim\"),l=t.datepicker._get(i,\"duration\"),i.dpDiv.zIndex(t(e).zIndex()+1),t.datepicker._datepickerShowing=!0,t.effects&&t.effects.effect[h]?i.dpDiv.show(h,t.datepicker._get(i,\"showOptions\"),l):i.dpDiv[h||\"show\"](h?l:null),i.input.is(\":visible\")&&!i.input.is(\":disabled\")&&i.input.focus(),t.datepicker._curInst=i))}},_updateDatepicker:function(e){this.maxRows=4,o=e,e.dpDiv.empty().append(this._generateHTML(e)),this._attachHandlers(e),e.dpDiv.find(\".\"+this._dayOverClass+\" a\").mouseover();var i,s=this._getNumberOfMonths(e),n=s[1],a=17;e.dpDiv.removeClass(\"ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4\").width(\"\"),n>1&&e.dpDiv.addClass(\"ui-datepicker-multi-\"+n).css(\"width\",a*n+\"em\"),e.dpDiv[(1!==s[0]||1!==s[1]?\"add\":\"remove\")+\"Class\"](\"ui-datepicker-multi\"),e.dpDiv[(this._get(e,\"isRTL\")?\"add\":\"remove\")+\"Class\"](\"ui-datepicker-rtl\"),e===t.datepicker._curInst&&t.datepicker._datepickerShowing&&e.input&&e.input.is(\":visible\")&&!e.input.is(\":disabled\")&&e.input[0]!==document.activeElement&&e.input.focus(),e.yearshtml&&(i=e.yearshtml,setTimeout(function(){i===e.yearshtml&&e.yearshtml&&e.dpDiv.find(\"select.ui-datepicker-year:first\").replaceWith(e.yearshtml),i=e.yearshtml=null},0))},_getBorders:function(t){var e=function(t){return{thin:1,medium:2,thick:3}[t]||t};return[parseFloat(e(t.css(\"border-left-width\"))),parseFloat(e(t.css(\"border-top-width\")))]},_checkOffset:function(e,i,s){var n=e.dpDiv.outerWidth(),o=e.dpDiv.outerHeight(),a=e.input?e.input.outerWidth():0,r=e.input?e.input.outerHeight():0,h=document.documentElement.clientWidth+(s?0:t(document).scrollLeft()),l=document.documentElement.clientHeight+(s?0:t(document).scrollTop());return i.left-=this._get(e,\"isRTL\")?n-a:0,i.left-=s&&i.left===e.input.offset().left?t(document).scrollLeft():0,i.top-=s&&i.top===e.input.offset().top+r?t(document).scrollTop():0,i.left-=Math.min(i.left,i.left+n>h&&h>n?Math.abs(i.left+n-h):0),i.top-=Math.min(i.top,i.top+o>l&&l>o?Math.abs(o+r):0),i},_findPos:function(e){for(var i,s=this._getInst(e),n=this._get(s,\"isRTL\");e&&(\"hidden\"===e.type||1!==e.nodeType||t.expr.filters.hidden(e));)e=e[n?\"previousSibling\":\"nextSibling\"];return i=t(e).offset(),[i.left,i.top]},_hideDatepicker:function(e){var i,s,n,o,r=this._curInst;!r||e&&r!==t.data(e,a)||this._datepickerShowing&&(i=this._get(r,\"showAnim\"),s=this._get(r,\"duration\"),n=function(){t.datepicker._tidyDialog(r)},t.effects&&(t.effects.effect[i]||t.effects[i])?r.dpDiv.hide(i,t.datepicker._get(r,\"showOptions\"),s,n):r.dpDiv[\"slideDown\"===i?\"slideUp\":\"fadeIn\"===i?\"fadeOut\":\"hide\"](i?s:null,n),i||n(),this._datepickerShowing=!1,o=this._get(r,\"onClose\"),o&&o.apply(r.input?r.input[0]:null,[r.input?r.input.val():\"\",r]),this._lastInput=null,this._inDialog&&(this._dialogInput.css({position:\"absolute\",left:\"0\",top:\"-100px\"}),t.blockUI&&(t.unblockUI(),t(\"body\").append(this.dpDiv))),this._inDialog=!1)},_tidyDialog:function(t){t.dpDiv.removeClass(this._dialogClass).unbind(\".ui-datepicker-calendar\")},_checkExternalClick:function(e){if(t.datepicker._curInst){var i=t(e.target),s=t.datepicker._getInst(i[0]);(i[0].id!==t.datepicker._mainDivId&&0===i.parents(\"#\"+t.datepicker._mainDivId).length&&!i.hasClass(t.datepicker.markerClassName)&&!i.closest(\".\"+t.datepicker._triggerClass).length&&t.datepicker._datepickerShowing&&(!t.datepicker._inDialog||!t.blockUI)||i.hasClass(t.datepicker.markerClassName)&&t.datepicker._curInst!==s)&&t.datepicker._hideDatepicker()}},_adjustDate:function(e,i,s){var n=t(e),o=this._getInst(n[0]);this._isDisabledDatepicker(n[0])||(this._adjustInstDate(o,i+(\"M\"===s?this._get(o,\"showCurrentAtPos\"):0),s),this._updateDatepicker(o))},_gotoToday:function(e){var i,s=t(e),n=this._getInst(s[0]);this._get(n,\"gotoCurrent\")&&n.currentDay?(n.selectedDay=n.currentDay,n.drawMonth=n.selectedMonth=n.currentMonth,n.drawYear=n.selectedYear=n.currentYear):(i=new Date,n.selectedDay=i.getDate(),n.drawMonth=n.selectedMonth=i.getMonth(),n.drawYear=n.selectedYear=i.getFullYear()),this._notifyChange(n),this._adjustDate(s)},_selectMonthYear:function(e,i,s){var n=t(e),o=this._getInst(n[0]);o[\"selected\"+(\"M\"===s?\"Month\":\"Year\")]=o[\"draw\"+(\"M\"===s?\"Month\":\"Year\")]=parseInt(i.options[i.selectedIndex].value,10),this._notifyChange(o),this._adjustDate(n)},_selectDay:function(e,i,s,n){var o,a=t(e);t(n).hasClass(this._unselectableClass)||this._isDisabledDatepicker(a[0])||(o=this._getInst(a[0]),o.selectedDay=o.currentDay=t(\"a\",n).html(),o.selectedMonth=o.currentMonth=i,o.selectedYear=o.currentYear=s,this._selectDate(e,this._formatDate(o,o.currentDay,o.currentMonth,o.currentYear)))},_clearDate:function(e){var i=t(e);this._selectDate(i,\"\")},_selectDate:function(e,i){var s,n=t(e),o=this._getInst(n[0]);i=null!=i?i:this._formatDate(o),o.input&&o.input.val(i),this._updateAlternate(o),s=this._get(o,\"onSelect\"),s?s.apply(o.input?o.input[0]:null,[i,o]):o.input&&o.input.trigger(\"change\"),o.inline?this._updateDatepicker(o):(this._hideDatepicker(),this._lastInput=o.input[0],\"object\"!=typeof o.input[0]&&o.input.focus(),this._lastInput=null)},_updateAlternate:function(e){var i,s,n,o=this._get(e,\"altField\");o&&(i=this._get(e,\"altFormat\")||this._get(e,\"dateFormat\"),s=this._getDate(e),n=this.formatDate(i,s,this._getFormatConfig(e)),t(o).each(function(){t(this).val(n)}))},noWeekends:function(t){var e=t.getDay();return[e>0&&6>e,\"\"]},iso8601Week:function(t){var e,i=new Date(t.getTime());return i.setDate(i.getDate()+4-(i.getDay()||7)),e=i.getTime(),i.setMonth(0),i.setDate(1),Math.floor(Math.round((e-i)/864e5)/7)+1},parseDate:function(i,s,n){if(null==i||null==s)throw\"Invalid arguments\";if(s=\"object\"==typeof s?\"\"+s:s+\"\",\"\"===s)return null;var o,a,r,h,l=0,c=(n?n.shortYearCutoff:null)||this._defaults.shortYearCutoff,u=\"string\"!=typeof c?c:(new Date).getFullYear()%100+parseInt(c,10),d=(n?n.dayNamesShort:null)||this._defaults.dayNamesShort,p=(n?n.dayNames:null)||this._defaults.dayNames,f=(n?n.monthNamesShort:null)||this._defaults.monthNamesShort,g=(n?n.monthNames:null)||this._defaults.monthNames,m=-1,v=-1,_=-1,b=-1,y=!1,w=function(t){var e=i.length>o+1&&i.charAt(o+1)===t;return e&&o++,e},k=function(t){var e=w(t),i=\"@\"===t?14:\"!\"===t?20:\"y\"===t&&e?4:\"o\"===t?3:2,n=RegExp(\"^\\\\d{1,\"+i+\"}\"),o=s.substring(l).match(n);if(!o)throw\"Missing number at position \"+l;return l+=o[0].length,parseInt(o[0],10)},x=function(i,n,o){var a=-1,r=t.map(w(i)?o:n,function(t,e){return[[e,t]]}).sort(function(t,e){return-(t[1].length-e[1].length)});if(t.each(r,function(t,i){var n=i[1];return s.substr(l,n.length).toLowerCase()===n.toLowerCase()?(a=i[0],l+=n.length,!1):e}),-1!==a)return a+1;throw\"Unknown name at position \"+l},D=function(){if(s.charAt(l)!==i.charAt(o))throw\"Unexpected literal at position \"+l;l++};for(o=0;i.length>o;o++)if(y)\"'\"!==i.charAt(o)||w(\"'\")?D():y=!1;else switch(i.charAt(o)){case\"d\":_=k(\"d\");break;case\"D\":x(\"D\",d,p);break;case\"o\":b=k(\"o\");break;case\"m\":v=k(\"m\");break;case\"M\":v=x(\"M\",f,g);break;case\"y\":m=k(\"y\");break;case\"@\":h=new Date(k(\"@\")),m=h.getFullYear(),v=h.getMonth()+1,_=h.getDate();break;case\"!\":h=new Date((k(\"!\")-this._ticksTo1970)/1e4),m=h.getFullYear(),v=h.getMonth()+1,_=h.getDate();break;case\"'\":w(\"'\")?D():y=!0;break;default:D()}if(s.length>l&&(r=s.substr(l),!/^\\s+/.test(r)))throw\"Extra/unparsed characters found in date: \"+r;if(-1===m?m=(new Date).getFullYear():100>m&&(m+=(new Date).getFullYear()-(new Date).getFullYear()%100+(u>=m?0:-100)),b>-1)for(v=1,_=b;;){if(a=this._getDaysInMonth(m,v-1),a>=_)break;v++,_-=a}if(h=this._daylightSavingAdjust(new Date(m,v-1,_)),h.getFullYear()!==m||h.getMonth()+1!==v||h.getDate()!==_)throw\"Invalid date\";return h},ATOM:\"yy-mm-dd\",COOKIE:\"D, dd M yy\",ISO_8601:\"yy-mm-dd\",RFC_822:\"D, d M y\",RFC_850:\"DD, dd-M-y\",RFC_1036:\"D, d M y\",RFC_1123:\"D, d M yy\",RFC_2822:\"D, d M yy\",RSS:\"D, d M y\",TICKS:\"!\",TIMESTAMP:\"@\",W3C:\"yy-mm-dd\",_ticksTo1970:1e7*60*60*24*(718685+Math.floor(492.5)-Math.floor(19.7)+Math.floor(4.925)),formatDate:function(t,e,i){if(!e)return\"\";var s,n=(i?i.dayNamesShort:null)||this._defaults.dayNamesShort,o=(i?i.dayNames:null)||this._defaults.dayNames,a=(i?i.monthNamesShort:null)||this._defaults.monthNamesShort,r=(i?i.monthNames:null)||this._defaults.monthNames,h=function(e){var i=t.length>s+1&&t.charAt(s+1)===e;return i&&s++,i},l=function(t,e,i){var s=\"\"+e;if(h(t))for(;i>s.length;)s=\"0\"+s;return s},c=function(t,e,i,s){return h(t)?s[e]:i[e]},u=\"\",d=!1;if(e)for(s=0;t.length>s;s++)if(d)\"'\"!==t.charAt(s)||h(\"'\")?u+=t.charAt(s):d=!1;else switch(t.charAt(s)){case\"d\":u+=l(\"d\",e.getDate(),2);break;case\"D\":u+=c(\"D\",e.getDay(),n,o);break;case\"o\":u+=l(\"o\",Math.round((new Date(e.getFullYear(),e.getMonth(),e.getDate()).getTime()-new Date(e.getFullYear(),0,0).getTime())/864e5),3);break;case\"m\":u+=l(\"m\",e.getMonth()+1,2);break;case\"M\":u+=c(\"M\",e.getMonth(),a,r);break;case\"y\":u+=h(\"y\")?e.getFullYear():(10>e.getYear()%100?\"0\":\"\")+e.getYear()%100;break;case\"@\":u+=e.getTime();break;case\"!\":u+=1e4*e.getTime()+this._ticksTo1970;break;case\"'\":h(\"'\")?u+=\"'\":d=!0;break;default:u+=t.charAt(s)}return u},_possibleChars:function(t){var e,i=\"\",s=!1,n=function(i){var s=t.length>e+1&&t.charAt(e+1)===i;return s&&e++,s};for(e=0;t.length>e;e++)if(s)\"'\"!==t.charAt(e)||n(\"'\")?i+=t.charAt(e):s=!1;else switch(t.charAt(e)){case\"d\":case\"m\":case\"y\":case\"@\":i+=\"0123456789\";break;case\"D\":case\"M\":return null;case\"'\":n(\"'\")?i+=\"'\":s=!0;break;default:i+=t.charAt(e)}return i},_get:function(t,i){return t.settings[i]!==e?t.settings[i]:this._defaults[i]},_setDateFromField:function(t,e){if(t.input.val()!==t.lastVal){var i=this._get(t,\"dateFormat\"),s=t.lastVal=t.input?t.input.val():null,n=this._getDefaultDate(t),o=n,a=this._getFormatConfig(t);try{o=this.parseDate(i,s,a)||n}catch(r){s=e?\"\":s}t.selectedDay=o.getDate(),t.drawMonth=t.selectedMonth=o.getMonth(),t.drawYear=t.selectedYear=o.getFullYear(),t.currentDay=s?o.getDate():0,t.currentMonth=s?o.getMonth():0,t.currentYear=s?o.getFullYear():0,this._adjustInstDate(t)}},_getDefaultDate:function(t){return this._restrictMinMax(t,this._determineDate(t,this._get(t,\"defaultDate\"),new Date))},_determineDate:function(e,i,s){var n=function(t){var e=new Date;return e.setDate(e.getDate()+t),e},o=function(i){try{return t.datepicker.parseDate(t.datepicker._get(e,\"dateFormat\"),i,t.datepicker._getFormatConfig(e))}catch(s){}for(var n=(i.toLowerCase().match(/^c/)?t.datepicker._getDate(e):null)||new Date,o=n.getFullYear(),a=n.getMonth(),r=n.getDate(),h=/([+\\-]?[0-9]+)\\s*(d|D|w|W|m|M|y|Y)?/g,l=h.exec(i);l;){switch(l[2]||\"d\"){case\"d\":case\"D\":r+=parseInt(l[1],10);break;case\"w\":case\"W\":r+=7*parseInt(l[1],10);break;case\"m\":case\"M\":a+=parseInt(l[1],10),r=Math.min(r,t.datepicker._getDaysInMonth(o,a));break;case\"y\":case\"Y\":o+=parseInt(l[1],10),r=Math.min(r,t.datepicker._getDaysInMonth(o,a))}l=h.exec(i)}return new Date(o,a,r)},a=null==i||\"\"===i?s:\"string\"==typeof i?o(i):\"number\"==typeof i?isNaN(i)?s:n(i):new Date(i.getTime());return a=a&&\"Invalid Date\"==\"\"+a?s:a,a&&(a.setHours(0),a.setMinutes(0),a.setSeconds(0),a.setMilliseconds(0)),this._daylightSavingAdjust(a)},_daylightSavingAdjust:function(t){return t?(t.setHours(t.getHours()>12?t.getHours()+2:0),t):null},_setDate:function(t,e,i){var s=!e,n=t.selectedMonth,o=t.selectedYear,a=this._restrictMinMax(t,this._determineDate(t,e,new Date));t.selectedDay=t.currentDay=a.getDate(),t.drawMonth=t.selectedMonth=t.currentMonth=a.getMonth(),t.drawYear=t.selectedYear=t.currentYear=a.getFullYear(),n===t.selectedMonth&&o===t.selectedYear||i||this._notifyChange(t),this._adjustInstDate(t),t.input&&t.input.val(s?\"\":this._formatDate(t))},_getDate:function(t){var e=!t.currentYear||t.input&&\"\"===t.input.val()?null:this._daylightSavingAdjust(new Date(t.currentYear,t.currentMonth,t.currentDay));return e},_attachHandlers:function(e){var i=this._get(e,\"stepMonths\"),s=\"#\"+e.id.replace(/\\\\\\\\/g,\"\\\\\");e.dpDiv.find(\"[data-handler]\").map(function(){var e={prev:function(){window[\"DP_jQuery_\"+r].datepicker._adjustDate(s,-i,\"M\")},next:function(){window[\"DP_jQuery_\"+r].datepicker._adjustDate(s,+i,\"M\")},hide:function(){window[\"DP_jQuery_\"+r].datepicker._hideDatepicker()},today:function(){window[\"DP_jQuery_\"+r].datepicker._gotoToday(s)},selectDay:function(){return window[\"DP_jQuery_\"+r].datepicker._selectDay(s,+this.getAttribute(\"data-month\"),+this.getAttribute(\"data-year\"),this),!1},selectMonth:function(){return window[\"DP_jQuery_\"+r].datepicker._selectMonthYear(s,this,\"M\"),!1},selectYear:function(){return window[\"DP_jQuery_\"+r].datepicker._selectMonthYear(s,this,\"Y\"),!1}};t(this).bind(this.getAttribute(\"data-event\"),e[this.getAttribute(\"data-handler\")])})},_generateHTML:function(t){var e,i,s,n,o,a,r,h,l,c,u,d,p,f,g,m,v,_,b,y,w,k,x,D,C,I,P,T,M,S,z,A,H,N,E,W,O,F,R,j=new Date,L=this._daylightSavingAdjust(new Date(j.getFullYear(),j.getMonth(),j.getDate())),Y=this._get(t,\"isRTL\"),B=this._get(t,\"showButtonPanel\"),V=this._get(t,\"hideIfNoPrevNext\"),K=this._get(t,\"navigationAsDateFormat\"),U=this._getNumberOfMonths(t),q=this._get(t,\"showCurrentAtPos\"),Q=this._get(t,\"stepMonths\"),X=1!==U[0]||1!==U[1],$=this._daylightSavingAdjust(t.currentDay?new Date(t.currentYear,t.currentMonth,t.currentDay):new Date(9999,9,9)),G=this._getMinMaxDate(t,\"min\"),J=this._getMinMaxDate(t,\"max\"),Z=t.drawMonth-q,te=t.drawYear;if(0>Z&&(Z+=12,te--),J)for(e=this._daylightSavingAdjust(new Date(J.getFullYear(),J.getMonth()-U[0]*U[1]+1,J.getDate())),e=G&&G>e?G:e;this._daylightSavingAdjust(new Date(te,Z,1))>e;)Z--,0>Z&&(Z=11,te--);for(t.drawMonth=Z,t.drawYear=te,i=this._get(t,\"prevText\"),i=K?this.formatDate(i,this._daylightSavingAdjust(new Date(te,Z-Q,1)),this._getFormatConfig(t)):i,s=this._canAdjustMonth(t,-1,te,Z)?\"<a class='ui-datepicker-prev ui-corner-all' data-handler='prev' data-event='click' title='\"+i+\"'><span class='ui-icon ui-icon-circle-triangle-\"+(Y?\"e\":\"w\")+\"'>\"+i+\"</span></a>\":V?\"\":\"<a class='ui-datepicker-prev ui-corner-all ui-state-disabled' title='\"+i+\"'><span class='ui-icon ui-icon-circle-triangle-\"+(Y?\"e\":\"w\")+\"'>\"+i+\"</span></a>\",n=this._get(t,\"nextText\"),n=K?this.formatDate(n,this._daylightSavingAdjust(new Date(te,Z+Q,1)),this._getFormatConfig(t)):n,o=this._canAdjustMonth(t,1,te,Z)?\"<a class='ui-datepicker-next ui-corner-all' data-handler='next' data-event='click' title='\"+n+\"'><span class='ui-icon ui-icon-circle-triangle-\"+(Y?\"w\":\"e\")+\"'>\"+n+\"</span></a>\":V?\"\":\"<a class='ui-datepicker-next ui-corner-all ui-state-disabled' title='\"+n+\"'><span class='ui-icon ui-icon-circle-triangle-\"+(Y?\"w\":\"e\")+\"'>\"+n+\"</span></a>\",a=this._get(t,\"currentText\"),r=this._get(t,\"gotoCurrent\")&&t.currentDay?$:L,a=K?this.formatDate(a,r,this._getFormatConfig(t)):a,h=t.inline?\"\":\"<button type='button' class='ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all' data-handler='hide' data-event='click'>\"+this._get(t,\"closeText\")+\"</button>\",l=B?\"<div class='ui-datepicker-buttonpane ui-widget-content'>\"+(Y?h:\"\")+(this._isInRange(t,r)?\"<button type='button' class='ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all' data-handler='today' data-event='click'>\"+a+\"</button>\":\"\")+(Y?\"\":h)+\"</div>\":\"\",c=parseInt(this._get(t,\"firstDay\"),10),c=isNaN(c)?0:c,u=this._get(t,\"showWeek\"),d=this._get(t,\"dayNames\"),p=this._get(t,\"dayNamesMin\"),f=this._get(t,\"monthNames\"),g=this._get(t,\"monthNamesShort\"),m=this._get(t,\"beforeShowDay\"),v=this._get(t,\"showOtherMonths\"),_=this._get(t,\"selectOtherMonths\"),b=this._getDefaultDate(t),y=\"\",k=0;U[0]>k;k++){for(x=\"\",this.maxRows=4,D=0;U[1]>D;D++){if(C=this._daylightSavingAdjust(new Date(te,Z,t.selectedDay)),I=\" ui-corner-all\",P=\"\",X){if(P+=\"<div class='ui-datepicker-group\",U[1]>1)switch(D){case 0:P+=\" ui-datepicker-group-first\",I=\" ui-corner-\"+(Y?\"right\":\"left\");break;case U[1]-1:P+=\" ui-datepicker-group-last\",I=\" ui-corner-\"+(Y?\"left\":\"right\");break;default:P+=\" ui-datepicker-group-middle\",I=\"\"}P+=\"'>\"}for(P+=\"<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix\"+I+\"'>\"+(/all|left/.test(I)&&0===k?Y?o:s:\"\")+(/all|right/.test(I)&&0===k?Y?s:o:\"\")+this._generateMonthYearHeader(t,Z,te,G,J,k>0||D>0,f,g)+\"</div><table class='ui-datepicker-calendar'><thead>\"+\"<tr>\",T=u?\"<th class='ui-datepicker-week-col'>\"+this._get(t,\"weekHeader\")+\"</th>\":\"\",w=0;7>w;w++)M=(w+c)%7,T+=\"<th\"+((w+c+6)%7>=5?\" class='ui-datepicker-week-end'\":\"\")+\">\"+\"<span title='\"+d[M]+\"'>\"+p[M]+\"</span></th>\";for(P+=T+\"</tr></thead><tbody>\",S=this._getDaysInMonth(te,Z),te===t.selectedYear&&Z===t.selectedMonth&&(t.selectedDay=Math.min(t.selectedDay,S)),z=(this._getFirstDayOfMonth(te,Z)-c+7)%7,A=Math.ceil((z+S)/7),H=X?this.maxRows>A?this.maxRows:A:A,this.maxRows=H,N=this._daylightSavingAdjust(new Date(te,Z,1-z)),E=0;H>E;E++){for(P+=\"<tr>\",W=u?\"<td class='ui-datepicker-week-col'>\"+this._get(t,\"calculateWeek\")(N)+\"</td>\":\"\",w=0;7>w;w++)O=m?m.apply(t.input?t.input[0]:null,[N]):[!0,\"\"],F=N.getMonth()!==Z,R=F&&!_||!O[0]||G&&G>N||J&&N>J,W+=\"<td class='\"+((w+c+6)%7>=5?\" ui-datepicker-week-end\":\"\")+(F?\" ui-datepicker-other-month\":\"\")+(N.getTime()===C.getTime()&&Z===t.selectedMonth&&t._keyEvent||b.getTime()===N.getTime()&&b.getTime()===C.getTime()?\" \"+this._dayOverClass:\"\")+(R?\" \"+this._unselectableClass+\" ui-state-disabled\":\"\")+(F&&!v?\"\":\" \"+O[1]+(N.getTime()===$.getTime()?\" \"+this._currentClass:\"\")+(N.getTime()===L.getTime()?\" ui-datepicker-today\":\"\"))+\"'\"+(F&&!v||!O[2]?\"\":\" title='\"+O[2].replace(/'/g,\"&#39;\")+\"'\")+(R?\"\":\" data-handler='selectDay' data-event='click' data-month='\"+N.getMonth()+\"' data-year='\"+N.getFullYear()+\"'\")+\">\"+(F&&!v?\"&#xa0;\":R?\"<span class='ui-state-default'>\"+N.getDate()+\"</span>\":\"<a class='ui-state-default\"+(N.getTime()===L.getTime()?\" ui-state-highlight\":\"\")+(N.getTime()===$.getTime()?\" ui-state-active\":\"\")+(F?\" ui-priority-secondary\":\"\")+\"' href='#'>\"+N.getDate()+\"</a>\")+\"</td>\",N.setDate(N.getDate()+1),N=this._daylightSavingAdjust(N);P+=W+\"</tr>\"}Z++,Z>11&&(Z=0,te++),P+=\"</tbody></table>\"+(X?\"</div>\"+(U[0]>0&&D===U[1]-1?\"<div class='ui-datepicker-row-break'></div>\":\"\"):\"\"),x+=P}y+=x}return y+=l,t._keyEvent=!1,y},_generateMonthYearHeader:function(t,e,i,s,n,o,a,r){var h,l,c,u,d,p,f,g,m=this._get(t,\"changeMonth\"),v=this._get(t,\"changeYear\"),_=this._get(t,\"showMonthAfterYear\"),b=\"<div class='ui-datepicker-title'>\",y=\"\";if(o||!m)y+=\"<span class='ui-datepicker-month'>\"+a[e]+\"</span>\";else{for(h=s&&s.getFullYear()===i,l=n&&n.getFullYear()===i,y+=\"<select class='ui-datepicker-month' data-handler='selectMonth' data-event='change'>\",c=0;12>c;c++)(!h||c>=s.getMonth())&&(!l||n.getMonth()>=c)&&(y+=\"<option value='\"+c+\"'\"+(c===e?\" selected='selected'\":\"\")+\">\"+r[c]+\"</option>\");y+=\"</select>\"}if(_||(b+=y+(!o&&m&&v?\"\":\"&#xa0;\")),!t.yearshtml)if(t.yearshtml=\"\",o||!v)b+=\"<span class='ui-datepicker-year'>\"+i+\"</span>\";else{for(u=this._get(t,\"yearRange\").split(\":\"),d=(new Date).getFullYear(),p=function(t){var e=t.match(/c[+\\-].*/)?i+parseInt(t.substring(1),10):t.match(/[+\\-].*/)?d+parseInt(t,10):parseInt(t,10);return isNaN(e)?d:e},f=p(u[0]),g=Math.max(f,p(u[1]||\"\")),f=s?Math.max(f,s.getFullYear()):f,g=n?Math.min(g,n.getFullYear()):g,t.yearshtml+=\"<select class='ui-datepicker-year' data-handler='selectYear' data-event='change'>\";g>=f;f++)t.yearshtml+=\"<option value='\"+f+\"'\"+(f===i?\" selected='selected'\":\"\")+\">\"+f+\"</option>\";t.yearshtml+=\"</select>\",b+=t.yearshtml,t.yearshtml=null}return b+=this._get(t,\"yearSuffix\"),_&&(b+=(!o&&m&&v?\"\":\"&#xa0;\")+y),b+=\"</div>\"},_adjustInstDate:function(t,e,i){var s=t.drawYear+(\"Y\"===i?e:0),n=t.drawMonth+(\"M\"===i?e:0),o=Math.min(t.selectedDay,this._getDaysInMonth(s,n))+(\"D\"===i?e:0),a=this._restrictMinMax(t,this._daylightSavingAdjust(new Date(s,n,o)));t.selectedDay=a.getDate(),t.drawMonth=t.selectedMonth=a.getMonth(),t.drawYear=t.selectedYear=a.getFullYear(),(\"M\"===i||\"Y\"===i)&&this._notifyChange(t)},_restrictMinMax:function(t,e){var i=this._getMinMaxDate(t,\"min\"),s=this._getMinMaxDate(t,\"max\"),n=i&&i>e?i:e;return s&&n>s?s:n},_notifyChange:function(t){var e=this._get(t,\"onChangeMonthYear\");e&&e.apply(t.input?t.input[0]:null,[t.selectedYear,t.selectedMonth+1,t])},_getNumberOfMonths:function(t){var e=this._get(t,\"numberOfMonths\");return null==e?[1,1]:\"number\"==typeof e?[1,e]:e},_getMinMaxDate:function(t,e){return this._determineDate(t,this._get(t,e+\"Date\"),null)},_getDaysInMonth:function(t,e){return 32-this._daylightSavingAdjust(new Date(t,e,32)).getDate()},_getFirstDayOfMonth:function(t,e){return new Date(t,e,1).getDay()},_canAdjustMonth:function(t,e,i,s){var n=this._getNumberOfMonths(t),o=this._daylightSavingAdjust(new Date(i,s+(0>e?e:n[0]*n[1]),1));return 0>e&&o.setDate(this._getDaysInMonth(o.getFullYear(),o.getMonth())),this._isInRange(t,o)},_isInRange:function(t,e){var i,s,n=this._getMinMaxDate(t,\"min\"),o=this._getMinMaxDate(t,\"max\"),a=null,r=null,h=this._get(t,\"yearRange\");return h&&(i=h.split(\":\"),s=(new Date).getFullYear(),a=parseInt(i[0],10),r=parseInt(i[1],10),i[0].match(/[+\\-].*/)&&(a+=s),i[1].match(/[+\\-].*/)&&(r+=s)),(!n||e.getTime()>=n.getTime())&&(!o||e.getTime()<=o.getTime())&&(!a||e.getFullYear()>=a)&&(!r||r>=e.getFullYear())},_getFormatConfig:function(t){var e=this._get(t,\"shortYearCutoff\");return e=\"string\"!=typeof e?e:(new Date).getFullYear()%100+parseInt(e,10),{shortYearCutoff:e,dayNamesShort:this._get(t,\"dayNamesShort\"),dayNames:this._get(t,\"dayNames\"),monthNamesShort:this._get(t,\"monthNamesShort\"),monthNames:this._get(t,\"monthNames\")}},_formatDate:function(t,e,i,s){e||(t.currentDay=t.selectedDay,t.currentMonth=t.selectedMonth,t.currentYear=t.selectedYear);var n=e?\"object\"==typeof e?e:this._daylightSavingAdjust(new Date(s,i,e)):this._daylightSavingAdjust(new Date(t.currentYear,t.currentMonth,t.currentDay));return this.formatDate(this._get(t,\"dateFormat\"),n,this._getFormatConfig(t))}}),t.fn.datepicker=function(e){if(!this.length)return this;t.datepicker.initialized||(t(document).mousedown(t.datepicker._checkExternalClick),t.datepicker.initialized=!0),0===t(\"#\"+t.datepicker._mainDivId).length&&t(\"body\").append(t.datepicker.dpDiv);var i=Array.prototype.slice.call(arguments,1);return\"string\"!=typeof e||\"isDisabled\"!==e&&\"getDate\"!==e&&\"widget\"!==e?\"option\"===e&&2===arguments.length&&\"string\"==typeof arguments[1]?t.datepicker[\"_\"+e+\"Datepicker\"].apply(t.datepicker,[this[0]].concat(i)):this.each(function(){\"string\"==typeof e?t.datepicker[\"_\"+e+\"Datepicker\"].apply(t.datepicker,[this].concat(i)):t.datepicker._attachDatepicker(this,e)}):t.datepicker[\"_\"+e+\"Datepicker\"].apply(t.datepicker,[this[0]].concat(i))},t.datepicker=new i,t.datepicker.initialized=!1,t.datepicker.uuid=(new Date).getTime(),t.datepicker.version=\"1.10.2\",window[\"DP_jQuery_\"+r]=t}(jQuery),function(t){var e={buttons:!0,height:!0,maxHeight:!0,maxWidth:!0,minHeight:!0,minWidth:!0,width:!0},i={maxHeight:!0,maxWidth:!0,minHeight:!0,minWidth:!0};t.widget(\"ui.dialog\",{version:\"1.10.2\",options:{appendTo:\"body\",autoOpen:!0,buttons:[],closeOnEscape:!0,closeText:\"close\",dialogClass:\"\",draggable:!0,hide:null,height:\"auto\",maxHeight:null,maxWidth:null,minHeight:150,minWidth:150,modal:!1,position:{my:\"center\",at:\"center\",of:window,collision:\"fit\",using:function(e){var i=t(this).css(e).offset().top;0>i&&t(this).css(\"top\",e.top-i)}},resizable:!0,show:null,title:null,width:300,beforeClose:null,close:null,drag:null,dragStart:null,dragStop:null,focus:null,open:null,resize:null,resizeStart:null,resizeStop:null},_create:function(){this.originalCss={display:this.element[0].style.display,width:this.element[0].style.width,minHeight:this.element[0].style.minHeight,maxHeight:this.element[0].style.maxHeight,height:this.element[0].style.height},this.originalPosition={parent:this.element.parent(),index:this.element.parent().children().index(this.element)},this.originalTitle=this.element.attr(\"title\"),this.options.title=this.options.title||this.originalTitle,this._createWrapper(),this.element.show().removeAttr(\"title\").addClass(\"ui-dialog-content ui-widget-content\").appendTo(this.uiDialog),this._createTitlebar(),this._createButtonPane(),this.options.draggable&&t.fn.draggable&&this._makeDraggable(),this.options.resizable&&t.fn.resizable&&this._makeResizable(),this._isOpen=!1},_init:function(){this.options.autoOpen&&this.open()},_appendTo:function(){var e=this.options.appendTo;return e&&(e.jquery||e.nodeType)?t(e):this.document.find(e||\"body\").eq(0)},_destroy:function(){var t,e=this.originalPosition;this._destroyOverlay(),this.element.removeUniqueId().removeClass(\"ui-dialog-content ui-widget-content\").css(this.originalCss).detach(),this.uiDialog.stop(!0,!0).remove(),this.originalTitle&&this.element.attr(\"title\",this.originalTitle),t=e.parent.children().eq(e.index),t.length&&t[0]!==this.element[0]?t.before(this.element):e.parent.append(this.element)},widget:function(){return this.uiDialog},disable:t.noop,enable:t.noop,close:function(e){var i=this;this._isOpen&&this._trigger(\"beforeClose\",e)!==!1&&(this._isOpen=!1,this._destroyOverlay(),this.opener.filter(\":focusable\").focus().length||t(this.document[0].activeElement).blur(),this._hide(this.uiDialog,this.options.hide,function(){i._trigger(\"close\",e)}))},isOpen:function(){return this._isOpen},moveToTop:function(){this._moveToTop()},_moveToTop:function(t,e){var i=!!this.uiDialog.nextAll(\":visible\").insertBefore(this.uiDialog).length;return i&&!e&&this._trigger(\"focus\",t),i},open:function(){var e=this;return this._isOpen?(this._moveToTop()&&this._focusTabbable(),undefined):(this._isOpen=!0,this.opener=t(this.document[0].activeElement),this._size(),this._position(),this._createOverlay(),this._moveToTop(null,!0),this._show(this.uiDialog,this.options.show,function(){e._focusTabbable(),e._trigger(\"focus\")}),this._trigger(\"open\"),undefined)},_focusTabbable:function(){var t=this.element.find(\"[autofocus]\");t.length||(t=this.element.find(\":tabbable\")),t.length||(t=this.uiDialogButtonPane.find(\":tabbable\")),t.length||(t=this.uiDialogTitlebarClose.filter(\":tabbable\")),t.length||(t=this.uiDialog),t.eq(0).focus()},_keepFocus:function(e){function i(){var e=this.document[0].activeElement,i=this.uiDialog[0]===e||t.contains(this.uiDialog[0],e);i||this._focusTabbable()}e.preventDefault(),i.call(this),this._delay(i)},_createWrapper:function(){this.uiDialog=t(\"<div>\").addClass(\"ui-dialog ui-widget ui-widget-content ui-corner-all ui-front \"+this.options.dialogClass).hide().attr({tabIndex:-1,role:\"dialog\"}).appendTo(this._appendTo()),this._on(this.uiDialog,{keydown:function(e){if(this.options.closeOnEscape&&!e.isDefaultPrevented()&&e.keyCode&&e.keyCode===t.ui.keyCode.ESCAPE)return e.preventDefault(),this.close(e),undefined;if(e.keyCode===t.ui.keyCode.TAB){var i=this.uiDialog.find(\":tabbable\"),s=i.filter(\":first\"),n=i.filter(\":last\");e.target!==n[0]&&e.target!==this.uiDialog[0]||e.shiftKey?e.target!==s[0]&&e.target!==this.uiDialog[0]||!e.shiftKey||(n.focus(1),e.preventDefault()):(s.focus(1),e.preventDefault())}},mousedown:function(t){this._moveToTop(t)&&this._focusTabbable()}}),this.element.find(\"[aria-describedby]\").length||this.uiDialog.attr({\"aria-describedby\":this.element.uniqueId().attr(\"id\")})},_createTitlebar:function(){var e;this.uiDialogTitlebar=t(\"<div>\").addClass(\"ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix\").prependTo(this.uiDialog),this._on(this.uiDialogTitlebar,{mousedown:function(e){t(e.target).closest(\".ui-dialog-titlebar-close\")||this.uiDialog.focus()}}),this.uiDialogTitlebarClose=t(\"<button></button>\").button({label:this.options.closeText,icons:{primary:\"ui-icon-closethick\"},text:!1}).addClass(\"ui-dialog-titlebar-close\").appendTo(this.uiDialogTitlebar),this._on(this.uiDialogTitlebarClose,{click:function(t){t.preventDefault(),this.close(t)}}),e=t(\"<span>\").uniqueId().addClass(\"ui-dialog-title\").prependTo(this.uiDialogTitlebar),this._title(e),this.uiDialog.attr({\"aria-labelledby\":e.attr(\"id\")})},_title:function(t){this.options.title||t.html(\"&#160;\"),t.text(this.options.title)},_createButtonPane:function(){this.uiDialogButtonPane=t(\"<div>\").addClass(\"ui-dialog-buttonpane ui-widget-content ui-helper-clearfix\"),this.uiButtonSet=t(\"<div>\").addClass(\"ui-dialog-buttonset\").appendTo(this.uiDialogButtonPane),this._createButtons()},_createButtons:function(){var e=this,i=this.options.buttons;return this.uiDialogButtonPane.remove(),this.uiButtonSet.empty(),t.isEmptyObject(i)||t.isArray(i)&&!i.length?(this.uiDialog.removeClass(\"ui-dialog-buttons\"),undefined):(t.each(i,function(i,s){var n,o;s=t.isFunction(s)?{click:s,text:i}:s,s=t.extend({type:\"button\"},s),n=s.click,s.click=function(){n.apply(e.element[0],arguments)},o={icons:s.icons,text:s.showText},delete s.icons,delete s.showText,t(\"<button></button>\",s).button(o).appendTo(e.uiButtonSet)}),this.uiDialog.addClass(\"ui-dialog-buttons\"),this.uiDialogButtonPane.appendTo(this.uiDialog),undefined)},_makeDraggable:function(){function e(t){return{position:t.position,offset:t.offset}}var i=this,s=this.options;this.uiDialog.draggable({cancel:\".ui-dialog-content, .ui-dialog-titlebar-close\",handle:\".ui-dialog-titlebar\",containment:\"document\",start:function(s,n){t(this).addClass(\"ui-dialog-dragging\"),i._blockFrames(),i._trigger(\"dragStart\",s,e(n))},drag:function(t,s){i._trigger(\"drag\",t,e(s))},stop:function(n,o){s.position=[o.position.left-i.document.scrollLeft(),o.position.top-i.document.scrollTop()],t(this).removeClass(\"ui-dialog-dragging\"),i._unblockFrames(),i._trigger(\"dragStop\",n,e(o))\n}})},_makeResizable:function(){function e(t){return{originalPosition:t.originalPosition,originalSize:t.originalSize,position:t.position,size:t.size}}var i=this,s=this.options,n=s.resizable,o=this.uiDialog.css(\"position\"),a=\"string\"==typeof n?n:\"n,e,s,w,se,sw,ne,nw\";this.uiDialog.resizable({cancel:\".ui-dialog-content\",containment:\"document\",alsoResize:this.element,maxWidth:s.maxWidth,maxHeight:s.maxHeight,minWidth:s.minWidth,minHeight:this._minHeight(),handles:a,start:function(s,n){t(this).addClass(\"ui-dialog-resizing\"),i._blockFrames(),i._trigger(\"resizeStart\",s,e(n))},resize:function(t,s){i._trigger(\"resize\",t,e(s))},stop:function(n,o){s.height=t(this).height(),s.width=t(this).width(),t(this).removeClass(\"ui-dialog-resizing\"),i._unblockFrames(),i._trigger(\"resizeStop\",n,e(o))}}).css(\"position\",o)},_minHeight:function(){var t=this.options;return\"auto\"===t.height?t.minHeight:Math.min(t.minHeight,t.height)},_position:function(){var t=this.uiDialog.is(\":visible\");t||this.uiDialog.show(),this.uiDialog.position(this.options.position),t||this.uiDialog.hide()},_setOptions:function(s){var n=this,o=!1,a={};t.each(s,function(t,s){n._setOption(t,s),t in e&&(o=!0),t in i&&(a[t]=s)}),o&&(this._size(),this._position()),this.uiDialog.is(\":data(ui-resizable)\")&&this.uiDialog.resizable(\"option\",a)},_setOption:function(t,e){var i,s,n=this.uiDialog;\"dialogClass\"===t&&n.removeClass(this.options.dialogClass).addClass(e),\"disabled\"!==t&&(this._super(t,e),\"appendTo\"===t&&this.uiDialog.appendTo(this._appendTo()),\"buttons\"===t&&this._createButtons(),\"closeText\"===t&&this.uiDialogTitlebarClose.button({label:\"\"+e}),\"draggable\"===t&&(i=n.is(\":data(ui-draggable)\"),i&&!e&&n.draggable(\"destroy\"),!i&&e&&this._makeDraggable()),\"position\"===t&&this._position(),\"resizable\"===t&&(s=n.is(\":data(ui-resizable)\"),s&&!e&&n.resizable(\"destroy\"),s&&\"string\"==typeof e&&n.resizable(\"option\",\"handles\",e),s||e===!1||this._makeResizable()),\"title\"===t&&this._title(this.uiDialogTitlebar.find(\".ui-dialog-title\")))},_size:function(){var t,e,i,s=this.options;this.element.show().css({width:\"auto\",minHeight:0,maxHeight:\"none\",height:0}),s.minWidth>s.width&&(s.width=s.minWidth),t=this.uiDialog.css({height:\"auto\",width:s.width}).outerHeight(),e=Math.max(0,s.minHeight-t),i=\"number\"==typeof s.maxHeight?Math.max(0,s.maxHeight-t):\"none\",\"auto\"===s.height?this.element.css({minHeight:e,maxHeight:i,height:\"auto\"}):this.element.height(Math.max(0,s.height-t)),this.uiDialog.is(\":data(ui-resizable)\")&&this.uiDialog.resizable(\"option\",\"minHeight\",this._minHeight())},_blockFrames:function(){this.iframeBlocks=this.document.find(\"iframe\").map(function(){var e=t(this);return t(\"<div>\").css({position:\"absolute\",width:e.outerWidth(),height:e.outerHeight()}).appendTo(e.parent()).offset(e.offset())[0]})},_unblockFrames:function(){this.iframeBlocks&&(this.iframeBlocks.remove(),delete this.iframeBlocks)},_allowInteraction:function(e){return t(e.target).closest(\".ui-dialog\").length?!0:!!t(e.target).closest(\".ui-datepicker\").length},_createOverlay:function(){if(this.options.modal){var e=this,i=this.widgetFullName;t.ui.dialog.overlayInstances||this._delay(function(){t.ui.dialog.overlayInstances&&this.document.bind(\"focusin.dialog\",function(s){e._allowInteraction(s)||(s.preventDefault(),t(\".ui-dialog:visible:last .ui-dialog-content\").data(i)._focusTabbable())})}),this.overlay=t(\"<div>\").addClass(\"ui-widget-overlay ui-front\").appendTo(this._appendTo()),this._on(this.overlay,{mousedown:\"_keepFocus\"}),t.ui.dialog.overlayInstances++}},_destroyOverlay:function(){this.options.modal&&this.overlay&&(t.ui.dialog.overlayInstances--,t.ui.dialog.overlayInstances||this.document.unbind(\"focusin.dialog\"),this.overlay.remove(),this.overlay=null)}}),t.ui.dialog.overlayInstances=0,t.uiBackCompat!==!1&&t.widget(\"ui.dialog\",t.ui.dialog,{_position:function(){var e,i=this.options.position,s=[],n=[0,0];i?((\"string\"==typeof i||\"object\"==typeof i&&\"0\"in i)&&(s=i.split?i.split(\" \"):[i[0],i[1]],1===s.length&&(s[1]=s[0]),t.each([\"left\",\"top\"],function(t,e){+s[t]===s[t]&&(n[t]=s[t],s[t]=e)}),i={my:s[0]+(0>n[0]?n[0]:\"+\"+n[0])+\" \"+s[1]+(0>n[1]?n[1]:\"+\"+n[1]),at:s.join(\" \")}),i=t.extend({},t.ui.dialog.prototype.options.position,i)):i=t.ui.dialog.prototype.options.position,e=this.uiDialog.is(\":visible\"),e||this.uiDialog.show(),this.uiDialog.position(i),e||this.uiDialog.hide()}})}(jQuery),function(t){var e=/up|down|vertical/,i=/up|left|vertical|horizontal/;t.effects.effect.blind=function(s,n){var o,a,r,h=t(this),l=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"height\",\"width\"],c=t.effects.setMode(h,s.mode||\"hide\"),u=s.direction||\"up\",d=e.test(u),p=d?\"height\":\"width\",f=d?\"top\":\"left\",g=i.test(u),m={},v=\"show\"===c;h.parent().is(\".ui-effects-wrapper\")?t.effects.save(h.parent(),l):t.effects.save(h,l),h.show(),o=t.effects.createWrapper(h).css({overflow:\"hidden\"}),a=o[p](),r=parseFloat(o.css(f))||0,m[p]=v?a:0,g||(h.css(d?\"bottom\":\"right\",0).css(d?\"top\":\"left\",\"auto\").css({position:\"absolute\"}),m[f]=v?r:a+r),v&&(o.css(p,0),g||o.css(f,r+a)),o.animate(m,{duration:s.duration,easing:s.easing,queue:!1,complete:function(){\"hide\"===c&&h.hide(),t.effects.restore(h,l),t.effects.removeWrapper(h),n()}})}}(jQuery),function(t){t.effects.effect.bounce=function(e,i){var s,n,o,a=t(this),r=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"height\",\"width\"],h=t.effects.setMode(a,e.mode||\"effect\"),l=\"hide\"===h,c=\"show\"===h,u=e.direction||\"up\",d=e.distance,p=e.times||5,f=2*p+(c||l?1:0),g=e.duration/f,m=e.easing,v=\"up\"===u||\"down\"===u?\"top\":\"left\",_=\"up\"===u||\"left\"===u,b=a.queue(),y=b.length;for((c||l)&&r.push(\"opacity\"),t.effects.save(a,r),a.show(),t.effects.createWrapper(a),d||(d=a[\"top\"===v?\"outerHeight\":\"outerWidth\"]()/3),c&&(o={opacity:1},o[v]=0,a.css(\"opacity\",0).css(v,_?2*-d:2*d).animate(o,g,m)),l&&(d/=Math.pow(2,p-1)),o={},o[v]=0,s=0;p>s;s++)n={},n[v]=(_?\"-=\":\"+=\")+d,a.animate(n,g,m).animate(o,g,m),d=l?2*d:d/2;l&&(n={opacity:0},n[v]=(_?\"-=\":\"+=\")+d,a.animate(n,g,m)),a.queue(function(){l&&a.hide(),t.effects.restore(a,r),t.effects.removeWrapper(a),i()}),y>1&&b.splice.apply(b,[1,0].concat(b.splice(y,f+1))),a.dequeue()}}(jQuery),function(t){t.effects.effect.clip=function(e,i){var s,n,o,a=t(this),r=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"height\",\"width\"],h=t.effects.setMode(a,e.mode||\"hide\"),l=\"show\"===h,c=e.direction||\"vertical\",u=\"vertical\"===c,d=u?\"height\":\"width\",p=u?\"top\":\"left\",f={};t.effects.save(a,r),a.show(),s=t.effects.createWrapper(a).css({overflow:\"hidden\"}),n=\"IMG\"===a[0].tagName?s:a,o=n[d](),l&&(n.css(d,0),n.css(p,o/2)),f[d]=l?o:0,f[p]=l?0:o/2,n.animate(f,{queue:!1,duration:e.duration,easing:e.easing,complete:function(){l||a.hide(),t.effects.restore(a,r),t.effects.removeWrapper(a),i()}})}}(jQuery),function(t){t.effects.effect.drop=function(e,i){var s,n=t(this),o=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"opacity\",\"height\",\"width\"],a=t.effects.setMode(n,e.mode||\"hide\"),r=\"show\"===a,h=e.direction||\"left\",l=\"up\"===h||\"down\"===h?\"top\":\"left\",c=\"up\"===h||\"left\"===h?\"pos\":\"neg\",u={opacity:r?1:0};t.effects.save(n,o),n.show(),t.effects.createWrapper(n),s=e.distance||n[\"top\"===l?\"outerHeight\":\"outerWidth\"](!0)/2,r&&n.css(\"opacity\",0).css(l,\"pos\"===c?-s:s),u[l]=(r?\"pos\"===c?\"+=\":\"-=\":\"pos\"===c?\"-=\":\"+=\")+s,n.animate(u,{queue:!1,duration:e.duration,easing:e.easing,complete:function(){\"hide\"===a&&n.hide(),t.effects.restore(n,o),t.effects.removeWrapper(n),i()}})}}(jQuery),function(t){t.effects.effect.explode=function(e,i){function s(){b.push(this),b.length===u*d&&n()}function n(){p.css({visibility:\"visible\"}),t(b).remove(),g||p.hide(),i()}var o,a,r,h,l,c,u=e.pieces?Math.round(Math.sqrt(e.pieces)):3,d=u,p=t(this),f=t.effects.setMode(p,e.mode||\"hide\"),g=\"show\"===f,m=p.show().css(\"visibility\",\"hidden\").offset(),v=Math.ceil(p.outerWidth()/d),_=Math.ceil(p.outerHeight()/u),b=[];for(o=0;u>o;o++)for(h=m.top+o*_,c=o-(u-1)/2,a=0;d>a;a++)r=m.left+a*v,l=a-(d-1)/2,p.clone().appendTo(\"body\").wrap(\"<div></div>\").css({position:\"absolute\",visibility:\"visible\",left:-a*v,top:-o*_}).parent().addClass(\"ui-effects-explode\").css({position:\"absolute\",overflow:\"hidden\",width:v,height:_,left:r+(g?l*v:0),top:h+(g?c*_:0),opacity:g?0:1}).animate({left:r+(g?0:l*v),top:h+(g?0:c*_),opacity:g?1:0},e.duration||500,e.easing,s)}}(jQuery),function(t){t.effects.effect.fade=function(e,i){var s=t(this),n=t.effects.setMode(s,e.mode||\"toggle\");s.animate({opacity:n},{queue:!1,duration:e.duration,easing:e.easing,complete:i})}}(jQuery),function(t){t.effects.effect.fold=function(e,i){var s,n,o=t(this),a=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"height\",\"width\"],r=t.effects.setMode(o,e.mode||\"hide\"),h=\"show\"===r,l=\"hide\"===r,c=e.size||15,u=/([0-9]+)%/.exec(c),d=!!e.horizFirst,p=h!==d,f=p?[\"width\",\"height\"]:[\"height\",\"width\"],g=e.duration/2,m={},v={};t.effects.save(o,a),o.show(),s=t.effects.createWrapper(o).css({overflow:\"hidden\"}),n=p?[s.width(),s.height()]:[s.height(),s.width()],u&&(c=parseInt(u[1],10)/100*n[l?0:1]),h&&s.css(d?{height:0,width:c}:{height:c,width:0}),m[f[0]]=h?n[0]:c,v[f[1]]=h?n[1]:0,s.animate(m,g,e.easing).animate(v,g,e.easing,function(){l&&o.hide(),t.effects.restore(o,a),t.effects.removeWrapper(o),i()})}}(jQuery),function(t){t.effects.effect.highlight=function(e,i){var s=t(this),n=[\"backgroundImage\",\"backgroundColor\",\"opacity\"],o=t.effects.setMode(s,e.mode||\"show\"),a={backgroundColor:s.css(\"backgroundColor\")};\"hide\"===o&&(a.opacity=0),t.effects.save(s,n),s.show().css({backgroundImage:\"none\",backgroundColor:e.color||\"#ffff99\"}).animate(a,{queue:!1,duration:e.duration,easing:e.easing,complete:function(){\"hide\"===o&&s.hide(),t.effects.restore(s,n),i()}})}}(jQuery),function(t){t.effects.effect.pulsate=function(e,i){var s,n=t(this),o=t.effects.setMode(n,e.mode||\"show\"),a=\"show\"===o,r=\"hide\"===o,h=a||\"hide\"===o,l=2*(e.times||5)+(h?1:0),c=e.duration/l,u=0,d=n.queue(),p=d.length;for((a||!n.is(\":visible\"))&&(n.css(\"opacity\",0).show(),u=1),s=1;l>s;s++)n.animate({opacity:u},c,e.easing),u=1-u;n.animate({opacity:u},c,e.easing),n.queue(function(){r&&n.hide(),i()}),p>1&&d.splice.apply(d,[1,0].concat(d.splice(p,l+1))),n.dequeue()}}(jQuery),function(t){t.effects.effect.puff=function(e,i){var s=t(this),n=t.effects.setMode(s,e.mode||\"hide\"),o=\"hide\"===n,a=parseInt(e.percent,10)||150,r=a/100,h={height:s.height(),width:s.width(),outerHeight:s.outerHeight(),outerWidth:s.outerWidth()};t.extend(e,{effect:\"scale\",queue:!1,fade:!0,mode:n,complete:i,percent:o?a:100,from:o?h:{height:h.height*r,width:h.width*r,outerHeight:h.outerHeight*r,outerWidth:h.outerWidth*r}}),s.effect(e)},t.effects.effect.scale=function(e,i){var s=t(this),n=t.extend(!0,{},e),o=t.effects.setMode(s,e.mode||\"effect\"),a=parseInt(e.percent,10)||(0===parseInt(e.percent,10)?0:\"hide\"===o?0:100),r=e.direction||\"both\",h=e.origin,l={height:s.height(),width:s.width(),outerHeight:s.outerHeight(),outerWidth:s.outerWidth()},c={y:\"horizontal\"!==r?a/100:1,x:\"vertical\"!==r?a/100:1};n.effect=\"size\",n.queue=!1,n.complete=i,\"effect\"!==o&&(n.origin=h||[\"middle\",\"center\"],n.restore=!0),n.from=e.from||(\"show\"===o?{height:0,width:0,outerHeight:0,outerWidth:0}:l),n.to={height:l.height*c.y,width:l.width*c.x,outerHeight:l.outerHeight*c.y,outerWidth:l.outerWidth*c.x},n.fade&&(\"show\"===o&&(n.from.opacity=0,n.to.opacity=1),\"hide\"===o&&(n.from.opacity=1,n.to.opacity=0)),s.effect(n)},t.effects.effect.size=function(e,i){var s,n,o,a=t(this),r=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"width\",\"height\",\"overflow\",\"opacity\"],h=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"overflow\",\"opacity\"],l=[\"width\",\"height\",\"overflow\"],c=[\"fontSize\"],u=[\"borderTopWidth\",\"borderBottomWidth\",\"paddingTop\",\"paddingBottom\"],d=[\"borderLeftWidth\",\"borderRightWidth\",\"paddingLeft\",\"paddingRight\"],p=t.effects.setMode(a,e.mode||\"effect\"),f=e.restore||\"effect\"!==p,g=e.scale||\"both\",m=e.origin||[\"middle\",\"center\"],v=a.css(\"position\"),_=f?r:h,b={height:0,width:0,outerHeight:0,outerWidth:0};\"show\"===p&&a.show(),s={height:a.height(),width:a.width(),outerHeight:a.outerHeight(),outerWidth:a.outerWidth()},\"toggle\"===e.mode&&\"show\"===p?(a.from=e.to||b,a.to=e.from||s):(a.from=e.from||(\"show\"===p?b:s),a.to=e.to||(\"hide\"===p?b:s)),o={from:{y:a.from.height/s.height,x:a.from.width/s.width},to:{y:a.to.height/s.height,x:a.to.width/s.width}},(\"box\"===g||\"both\"===g)&&(o.from.y!==o.to.y&&(_=_.concat(u),a.from=t.effects.setTransition(a,u,o.from.y,a.from),a.to=t.effects.setTransition(a,u,o.to.y,a.to)),o.from.x!==o.to.x&&(_=_.concat(d),a.from=t.effects.setTransition(a,d,o.from.x,a.from),a.to=t.effects.setTransition(a,d,o.to.x,a.to))),(\"content\"===g||\"both\"===g)&&o.from.y!==o.to.y&&(_=_.concat(c).concat(l),a.from=t.effects.setTransition(a,c,o.from.y,a.from),a.to=t.effects.setTransition(a,c,o.to.y,a.to)),t.effects.save(a,_),a.show(),t.effects.createWrapper(a),a.css(\"overflow\",\"hidden\").css(a.from),m&&(n=t.effects.getBaseline(m,s),a.from.top=(s.outerHeight-a.outerHeight())*n.y,a.from.left=(s.outerWidth-a.outerWidth())*n.x,a.to.top=(s.outerHeight-a.to.outerHeight)*n.y,a.to.left=(s.outerWidth-a.to.outerWidth)*n.x),a.css(a.from),(\"content\"===g||\"both\"===g)&&(u=u.concat([\"marginTop\",\"marginBottom\"]).concat(c),d=d.concat([\"marginLeft\",\"marginRight\"]),l=r.concat(u).concat(d),a.find(\"*[width]\").each(function(){var i=t(this),s={height:i.height(),width:i.width(),outerHeight:i.outerHeight(),outerWidth:i.outerWidth()};f&&t.effects.save(i,l),i.from={height:s.height*o.from.y,width:s.width*o.from.x,outerHeight:s.outerHeight*o.from.y,outerWidth:s.outerWidth*o.from.x},i.to={height:s.height*o.to.y,width:s.width*o.to.x,outerHeight:s.height*o.to.y,outerWidth:s.width*o.to.x},o.from.y!==o.to.y&&(i.from=t.effects.setTransition(i,u,o.from.y,i.from),i.to=t.effects.setTransition(i,u,o.to.y,i.to)),o.from.x!==o.to.x&&(i.from=t.effects.setTransition(i,d,o.from.x,i.from),i.to=t.effects.setTransition(i,d,o.to.x,i.to)),i.css(i.from),i.animate(i.to,e.duration,e.easing,function(){f&&t.effects.restore(i,l)})})),a.animate(a.to,{queue:!1,duration:e.duration,easing:e.easing,complete:function(){0===a.to.opacity&&a.css(\"opacity\",a.from.opacity),\"hide\"===p&&a.hide(),t.effects.restore(a,_),f||(\"static\"===v?a.css({position:\"relative\",top:a.to.top,left:a.to.left}):t.each([\"top\",\"left\"],function(t,e){a.css(e,function(e,i){var s=parseInt(i,10),n=t?a.to.left:a.to.top;return\"auto\"===i?n+\"px\":s+n+\"px\"})})),t.effects.removeWrapper(a),i()}})}}(jQuery),function(t){t.effects.effect.shake=function(e,i){var s,n=t(this),o=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"height\",\"width\"],a=t.effects.setMode(n,e.mode||\"effect\"),r=e.direction||\"left\",h=e.distance||20,l=e.times||3,c=2*l+1,u=Math.round(e.duration/c),d=\"up\"===r||\"down\"===r?\"top\":\"left\",p=\"up\"===r||\"left\"===r,f={},g={},m={},v=n.queue(),_=v.length;for(t.effects.save(n,o),n.show(),t.effects.createWrapper(n),f[d]=(p?\"-=\":\"+=\")+h,g[d]=(p?\"+=\":\"-=\")+2*h,m[d]=(p?\"-=\":\"+=\")+2*h,n.animate(f,u,e.easing),s=1;l>s;s++)n.animate(g,u,e.easing).animate(m,u,e.easing);n.animate(g,u,e.easing).animate(f,u/2,e.easing).queue(function(){\"hide\"===a&&n.hide(),t.effects.restore(n,o),t.effects.removeWrapper(n),i()}),_>1&&v.splice.apply(v,[1,0].concat(v.splice(_,c+1))),n.dequeue()}}(jQuery),function(t){t.effects.effect.slide=function(e,i){var s,n=t(this),o=[\"position\",\"top\",\"bottom\",\"left\",\"right\",\"width\",\"height\"],a=t.effects.setMode(n,e.mode||\"show\"),r=\"show\"===a,h=e.direction||\"left\",l=\"up\"===h||\"down\"===h?\"top\":\"left\",c=\"up\"===h||\"left\"===h,u={};t.effects.save(n,o),n.show(),s=e.distance||n[\"top\"===l?\"outerHeight\":\"outerWidth\"](!0),t.effects.createWrapper(n).css({overflow:\"hidden\"}),r&&n.css(l,c?isNaN(s)?\"-\"+s:-s:s),u[l]=(r?c?\"+=\":\"-=\":c?\"-=\":\"+=\")+s,n.animate(u,{queue:!1,duration:e.duration,easing:e.easing,complete:function(){\"hide\"===a&&n.hide(),t.effects.restore(n,o),t.effects.removeWrapper(n),i()}})}}(jQuery),function(t){t.effects.effect.transfer=function(e,i){var s=t(this),n=t(e.to),o=\"fixed\"===n.css(\"position\"),a=t(\"body\"),r=o?a.scrollTop():0,h=o?a.scrollLeft():0,l=n.offset(),c={top:l.top-r,left:l.left-h,height:n.innerHeight(),width:n.innerWidth()},u=s.offset(),d=t(\"<div class='ui-effects-transfer'></div>\").appendTo(document.body).addClass(e.className).css({top:u.top-r,left:u.left-h,height:s.innerHeight(),width:s.innerWidth(),position:o?\"fixed\":\"absolute\"}).animate(c,e.duration,e.easing,function(){d.remove(),i()})}}(jQuery),function(t){t.widget(\"ui.menu\",{version:\"1.10.2\",defaultElement:\"<ul>\",delay:300,options:{icons:{submenu:\"ui-icon-carat-1-e\"},menus:\"ul\",position:{my:\"left top\",at:\"right top\"},role:\"menu\",blur:null,focus:null,select:null},_create:function(){this.activeMenu=this.element,this.mouseHandled=!1,this.element.uniqueId().addClass(\"ui-menu ui-widget ui-widget-content ui-corner-all\").toggleClass(\"ui-menu-icons\",!!this.element.find(\".ui-icon\").length).attr({role:this.options.role,tabIndex:0}).bind(\"click\"+this.eventNamespace,t.proxy(function(t){this.options.disabled&&t.preventDefault()},this)),this.options.disabled&&this.element.addClass(\"ui-state-disabled\").attr(\"aria-disabled\",\"true\"),this._on({\"mousedown .ui-menu-item > a\":function(t){t.preventDefault()},\"click .ui-state-disabled > a\":function(t){t.preventDefault()},\"click .ui-menu-item:has(a)\":function(e){var i=t(e.target).closest(\".ui-menu-item\");!this.mouseHandled&&i.not(\".ui-state-disabled\").length&&(this.mouseHandled=!0,this.select(e),i.has(\".ui-menu\").length?this.expand(e):this.element.is(\":focus\")||(this.element.trigger(\"focus\",[!0]),this.active&&1===this.active.parents(\".ui-menu\").length&&clearTimeout(this.timer)))},\"mouseenter .ui-menu-item\":function(e){var i=t(e.currentTarget);i.siblings().children(\".ui-state-active\").removeClass(\"ui-state-active\"),this.focus(e,i)},mouseleave:\"collapseAll\",\"mouseleave .ui-menu\":\"collapseAll\",focus:function(t,e){var i=this.active||this.element.children(\".ui-menu-item\").eq(0);e||this.focus(t,i)},blur:function(e){this._delay(function(){t.contains(this.element[0],this.document[0].activeElement)||this.collapseAll(e)})},keydown:\"_keydown\"}),this.refresh(),this._on(this.document,{click:function(e){t(e.target).closest(\".ui-menu\").length||this.collapseAll(e),this.mouseHandled=!1}})},_destroy:function(){this.element.removeAttr(\"aria-activedescendant\").find(\".ui-menu\").addBack().removeClass(\"ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons\").removeAttr(\"role\").removeAttr(\"tabIndex\").removeAttr(\"aria-labelledby\").removeAttr(\"aria-expanded\").removeAttr(\"aria-hidden\").removeAttr(\"aria-disabled\").removeUniqueId().show(),this.element.find(\".ui-menu-item\").removeClass(\"ui-menu-item\").removeAttr(\"role\").removeAttr(\"aria-disabled\").children(\"a\").removeUniqueId().removeClass(\"ui-corner-all ui-state-hover\").removeAttr(\"tabIndex\").removeAttr(\"role\").removeAttr(\"aria-haspopup\").children().each(function(){var e=t(this);e.data(\"ui-menu-submenu-carat\")&&e.remove()}),this.element.find(\".ui-menu-divider\").removeClass(\"ui-menu-divider ui-widget-content\")},_keydown:function(e){function i(t){return t.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g,\"\\\\$&\")}var s,n,o,a,r,h=!0;switch(e.keyCode){case t.ui.keyCode.PAGE_UP:this.previousPage(e);break;case t.ui.keyCode.PAGE_DOWN:this.nextPage(e);break;case t.ui.keyCode.HOME:this._move(\"first\",\"first\",e);break;case t.ui.keyCode.END:this._move(\"last\",\"last\",e);break;case t.ui.keyCode.UP:this.previous(e);break;case t.ui.keyCode.DOWN:this.next(e);break;case t.ui.keyCode.LEFT:this.collapse(e);break;case t.ui.keyCode.RIGHT:this.active&&!this.active.is(\".ui-state-disabled\")&&this.expand(e);break;case t.ui.keyCode.ENTER:case t.ui.keyCode.SPACE:this._activate(e);break;case t.ui.keyCode.ESCAPE:this.collapse(e);break;default:h=!1,n=this.previousFilter||\"\",o=String.fromCharCode(e.keyCode),a=!1,clearTimeout(this.filterTimer),o===n?a=!0:o=n+o,r=RegExp(\"^\"+i(o),\"i\"),s=this.activeMenu.children(\".ui-menu-item\").filter(function(){return r.test(t(this).children(\"a\").text())}),s=a&&-1!==s.index(this.active.next())?this.active.nextAll(\".ui-menu-item\"):s,s.length||(o=String.fromCharCode(e.keyCode),r=RegExp(\"^\"+i(o),\"i\"),s=this.activeMenu.children(\".ui-menu-item\").filter(function(){return r.test(t(this).children(\"a\").text())})),s.length?(this.focus(e,s),s.length>1?(this.previousFilter=o,this.filterTimer=this._delay(function(){delete this.previousFilter},1e3)):delete this.previousFilter):delete this.previousFilter}h&&e.preventDefault()},_activate:function(t){this.active.is(\".ui-state-disabled\")||(this.active.children(\"a[aria-haspopup='true']\").length?this.expand(t):this.select(t))},refresh:function(){var e,i=this.options.icons.submenu,s=this.element.find(this.options.menus);s.filter(\":not(.ui-menu)\").addClass(\"ui-menu ui-widget ui-widget-content ui-corner-all\").hide().attr({role:this.options.role,\"aria-hidden\":\"true\",\"aria-expanded\":\"false\"}).each(function(){var e=t(this),s=e.prev(\"a\"),n=t(\"<span>\").addClass(\"ui-menu-icon ui-icon \"+i).data(\"ui-menu-submenu-carat\",!0);s.attr(\"aria-haspopup\",\"true\").prepend(n),e.attr(\"aria-labelledby\",s.attr(\"id\"))}),e=s.add(this.element),e.children(\":not(.ui-menu-item):has(a)\").addClass(\"ui-menu-item\").attr(\"role\",\"presentation\").children(\"a\").uniqueId().addClass(\"ui-corner-all\").attr({tabIndex:-1,role:this._itemRole()}),e.children(\":not(.ui-menu-item)\").each(function(){var e=t(this);/[^\\-\\u2014\\u2013\\s]/.test(e.text())||e.addClass(\"ui-widget-content ui-menu-divider\")}),e.children(\".ui-state-disabled\").attr(\"aria-disabled\",\"true\"),this.active&&!t.contains(this.element[0],this.active[0])&&this.blur()},_itemRole:function(){return{menu:\"menuitem\",listbox:\"option\"}[this.options.role]},_setOption:function(t,e){\"icons\"===t&&this.element.find(\".ui-menu-icon\").removeClass(this.options.icons.submenu).addClass(e.submenu),this._super(t,e)},focus:function(t,e){var i,s;this.blur(t,t&&\"focus\"===t.type),this._scrollIntoView(e),this.active=e.first(),s=this.active.children(\"a\").addClass(\"ui-state-focus\"),this.options.role&&this.element.attr(\"aria-activedescendant\",s.attr(\"id\")),this.active.parent().closest(\".ui-menu-item\").children(\"a:first\").addClass(\"ui-state-active\"),t&&\"keydown\"===t.type?this._close():this.timer=this._delay(function(){this._close()},this.delay),i=e.children(\".ui-menu\"),i.length&&/^mouse/.test(t.type)&&this._startOpening(i),this.activeMenu=e.parent(),this._trigger(\"focus\",t,{item:e})},_scrollIntoView:function(e){var i,s,n,o,a,r;this._hasScroll()&&(i=parseFloat(t.css(this.activeMenu[0],\"borderTopWidth\"))||0,s=parseFloat(t.css(this.activeMenu[0],\"paddingTop\"))||0,n=e.offset().top-this.activeMenu.offset().top-i-s,o=this.activeMenu.scrollTop(),a=this.activeMenu.height(),r=e.height(),0>n?this.activeMenu.scrollTop(o+n):n+r>a&&this.activeMenu.scrollTop(o+n-a+r))},blur:function(t,e){e||clearTimeout(this.timer),this.active&&(this.active.children(\"a\").removeClass(\"ui-state-focus\"),this.active=null,this._trigger(\"blur\",t,{item:this.active}))},_startOpening:function(t){clearTimeout(this.timer),\"true\"===t.attr(\"aria-hidden\")&&(this.timer=this._delay(function(){this._close(),this._open(t)},this.delay))},_open:function(e){var i=t.extend({of:this.active},this.options.position);clearTimeout(this.timer),this.element.find(\".ui-menu\").not(e.parents(\".ui-menu\")).hide().attr(\"aria-hidden\",\"true\"),e.show().removeAttr(\"aria-hidden\").attr(\"aria-expanded\",\"true\").position(i)},collapseAll:function(e,i){clearTimeout(this.timer),this.timer=this._delay(function(){var s=i?this.element:t(e&&e.target).closest(this.element.find(\".ui-menu\"));s.length||(s=this.element),this._close(s),this.blur(e),this.activeMenu=s},this.delay)},_close:function(t){t||(t=this.active?this.active.parent():this.element),t.find(\".ui-menu\").hide().attr(\"aria-hidden\",\"true\").attr(\"aria-expanded\",\"false\").end().find(\"a.ui-state-active\").removeClass(\"ui-state-active\")},collapse:function(t){var e=this.active&&this.active.parent().closest(\".ui-menu-item\",this.element);e&&e.length&&(this._close(),this.focus(t,e))},expand:function(t){var e=this.active&&this.active.children(\".ui-menu \").children(\".ui-menu-item\").first();e&&e.length&&(this._open(e.parent()),this._delay(function(){this.focus(t,e)}))},next:function(t){this._move(\"next\",\"first\",t)},previous:function(t){this._move(\"prev\",\"last\",t)},isFirstItem:function(){return this.active&&!this.active.prevAll(\".ui-menu-item\").length},isLastItem:function(){return this.active&&!this.active.nextAll(\".ui-menu-item\").length},_move:function(t,e,i){var s;this.active&&(s=\"first\"===t||\"last\"===t?this.active[\"first\"===t?\"prevAll\":\"nextAll\"](\".ui-menu-item\").eq(-1):this.active[t+\"All\"](\".ui-menu-item\").eq(0)),s&&s.length&&this.active||(s=this.activeMenu.children(\".ui-menu-item\")[e]()),this.focus(i,s)},nextPage:function(e){var i,s,n;return this.active?(this.isLastItem()||(this._hasScroll()?(s=this.active.offset().top,n=this.element.height(),this.active.nextAll(\".ui-menu-item\").each(function(){return i=t(this),0>i.offset().top-s-n}),this.focus(e,i)):this.focus(e,this.activeMenu.children(\".ui-menu-item\")[this.active?\"last\":\"first\"]())),undefined):(this.next(e),undefined)},previousPage:function(e){var i,s,n;return this.active?(this.isFirstItem()||(this._hasScroll()?(s=this.active.offset().top,n=this.element.height(),this.active.prevAll(\".ui-menu-item\").each(function(){return i=t(this),i.offset().top-s+n>0}),this.focus(e,i)):this.focus(e,this.activeMenu.children(\".ui-menu-item\").first())),undefined):(this.next(e),undefined)},_hasScroll:function(){return this.element.outerHeight()<this.element.prop(\"scrollHeight\")},select:function(e){this.active=this.active||t(e.target).closest(\".ui-menu-item\");var i={item:this.active};this.active.has(\".ui-menu\").length||this.collapseAll(e,!0),this._trigger(\"select\",e,i)}})}(jQuery),function(t,e){function i(t,e,i){return[parseFloat(t[0])*(p.test(t[0])?e/100:1),parseFloat(t[1])*(p.test(t[1])?i/100:1)]}function s(e,i){return parseInt(t.css(e,i),10)||0}function n(e){var i=e[0];return 9===i.nodeType?{width:e.width(),height:e.height(),offset:{top:0,left:0}}:t.isWindow(i)?{width:e.width(),height:e.height(),offset:{top:e.scrollTop(),left:e.scrollLeft()}}:i.preventDefault?{width:0,height:0,offset:{top:i.pageY,left:i.pageX}}:{width:e.outerWidth(),height:e.outerHeight(),offset:e.offset()}}t.ui=t.ui||{};var o,a=Math.max,r=Math.abs,h=Math.round,l=/left|center|right/,c=/top|center|bottom/,u=/[\\+\\-]\\d+(\\.[\\d]+)?%?/,d=/^\\w+/,p=/%$/,f=t.fn.position;t.position={scrollbarWidth:function(){if(o!==e)return o;var i,s,n=t(\"<div style='display:block;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>\"),a=n.children()[0];return t(\"body\").append(n),i=a.offsetWidth,n.css(\"overflow\",\"scroll\"),s=a.offsetWidth,i===s&&(s=n[0].clientWidth),n.remove(),o=i-s},getScrollInfo:function(e){var i=e.isWindow?\"\":e.element.css(\"overflow-x\"),s=e.isWindow?\"\":e.element.css(\"overflow-y\"),n=\"scroll\"===i||\"auto\"===i&&e.width<e.element[0].scrollWidth,o=\"scroll\"===s||\"auto\"===s&&e.height<e.element[0].scrollHeight;return{width:o?t.position.scrollbarWidth():0,height:n?t.position.scrollbarWidth():0}},getWithinInfo:function(e){var i=t(e||window),s=t.isWindow(i[0]);return{element:i,isWindow:s,offset:i.offset()||{left:0,top:0},scrollLeft:i.scrollLeft(),scrollTop:i.scrollTop(),width:s?i.width():i.outerWidth(),height:s?i.height():i.outerHeight()}}},t.fn.position=function(e){if(!e||!e.of)return f.apply(this,arguments);e=t.extend({},e);var o,p,g,m,v,_,b=t(e.of),y=t.position.getWithinInfo(e.within),w=t.position.getScrollInfo(y),k=(e.collision||\"flip\").split(\" \"),x={};return _=n(b),b[0].preventDefault&&(e.at=\"left top\"),p=_.width,g=_.height,m=_.offset,v=t.extend({},m),t.each([\"my\",\"at\"],function(){var t,i,s=(e[this]||\"\").split(\" \");1===s.length&&(s=l.test(s[0])?s.concat([\"center\"]):c.test(s[0])?[\"center\"].concat(s):[\"center\",\"center\"]),s[0]=l.test(s[0])?s[0]:\"center\",s[1]=c.test(s[1])?s[1]:\"center\",t=u.exec(s[0]),i=u.exec(s[1]),x[this]=[t?t[0]:0,i?i[0]:0],e[this]=[d.exec(s[0])[0],d.exec(s[1])[0]]}),1===k.length&&(k[1]=k[0]),\"right\"===e.at[0]?v.left+=p:\"center\"===e.at[0]&&(v.left+=p/2),\"bottom\"===e.at[1]?v.top+=g:\"center\"===e.at[1]&&(v.top+=g/2),o=i(x.at,p,g),v.left+=o[0],v.top+=o[1],this.each(function(){var n,l,c=t(this),u=c.outerWidth(),d=c.outerHeight(),f=s(this,\"marginLeft\"),_=s(this,\"marginTop\"),D=u+f+s(this,\"marginRight\")+w.width,C=d+_+s(this,\"marginBottom\")+w.height,I=t.extend({},v),P=i(x.my,c.outerWidth(),c.outerHeight());\"right\"===e.my[0]?I.left-=u:\"center\"===e.my[0]&&(I.left-=u/2),\"bottom\"===e.my[1]?I.top-=d:\"center\"===e.my[1]&&(I.top-=d/2),I.left+=P[0],I.top+=P[1],t.support.offsetFractions||(I.left=h(I.left),I.top=h(I.top)),n={marginLeft:f,marginTop:_},t.each([\"left\",\"top\"],function(i,s){t.ui.position[k[i]]&&t.ui.position[k[i]][s](I,{targetWidth:p,targetHeight:g,elemWidth:u,elemHeight:d,collisionPosition:n,collisionWidth:D,collisionHeight:C,offset:[o[0]+P[0],o[1]+P[1]],my:e.my,at:e.at,within:y,elem:c})}),e.using&&(l=function(t){var i=m.left-I.left,s=i+p-u,n=m.top-I.top,o=n+g-d,h={target:{element:b,left:m.left,top:m.top,width:p,height:g},element:{element:c,left:I.left,top:I.top,width:u,height:d},horizontal:0>s?\"left\":i>0?\"right\":\"center\",vertical:0>o?\"top\":n>0?\"bottom\":\"middle\"};u>p&&p>r(i+s)&&(h.horizontal=\"center\"),d>g&&g>r(n+o)&&(h.vertical=\"middle\"),h.important=a(r(i),r(s))>a(r(n),r(o))?\"horizontal\":\"vertical\",e.using.call(this,t,h)}),c.offset(t.extend(I,{using:l}))})},t.ui.position={fit:{left:function(t,e){var i,s=e.within,n=s.isWindow?s.scrollLeft:s.offset.left,o=s.width,r=t.left-e.collisionPosition.marginLeft,h=n-r,l=r+e.collisionWidth-o-n;e.collisionWidth>o?h>0&&0>=l?(i=t.left+h+e.collisionWidth-o-n,t.left+=h-i):t.left=l>0&&0>=h?n:h>l?n+o-e.collisionWidth:n:h>0?t.left+=h:l>0?t.left-=l:t.left=a(t.left-r,t.left)},top:function(t,e){var i,s=e.within,n=s.isWindow?s.scrollTop:s.offset.top,o=e.within.height,r=t.top-e.collisionPosition.marginTop,h=n-r,l=r+e.collisionHeight-o-n;e.collisionHeight>o?h>0&&0>=l?(i=t.top+h+e.collisionHeight-o-n,t.top+=h-i):t.top=l>0&&0>=h?n:h>l?n+o-e.collisionHeight:n:h>0?t.top+=h:l>0?t.top-=l:t.top=a(t.top-r,t.top)}},flip:{left:function(t,e){var i,s,n=e.within,o=n.offset.left+n.scrollLeft,a=n.width,h=n.isWindow?n.scrollLeft:n.offset.left,l=t.left-e.collisionPosition.marginLeft,c=l-h,u=l+e.collisionWidth-a-h,d=\"left\"===e.my[0]?-e.elemWidth:\"right\"===e.my[0]?e.elemWidth:0,p=\"left\"===e.at[0]?e.targetWidth:\"right\"===e.at[0]?-e.targetWidth:0,f=-2*e.offset[0];0>c?(i=t.left+d+p+f+e.collisionWidth-a-o,(0>i||r(c)>i)&&(t.left+=d+p+f)):u>0&&(s=t.left-e.collisionPosition.marginLeft+d+p+f-h,(s>0||u>r(s))&&(t.left+=d+p+f))},top:function(t,e){var i,s,n=e.within,o=n.offset.top+n.scrollTop,a=n.height,h=n.isWindow?n.scrollTop:n.offset.top,l=t.top-e.collisionPosition.marginTop,c=l-h,u=l+e.collisionHeight-a-h,d=\"top\"===e.my[1],p=d?-e.elemHeight:\"bottom\"===e.my[1]?e.elemHeight:0,f=\"top\"===e.at[1]?e.targetHeight:\"bottom\"===e.at[1]?-e.targetHeight:0,g=-2*e.offset[1];0>c?(s=t.top+p+f+g+e.collisionHeight-a-o,t.top+p+f+g>c&&(0>s||r(c)>s)&&(t.top+=p+f+g)):u>0&&(i=t.top-e.collisionPosition.marginTop+p+f+g-h,t.top+p+f+g>u&&(i>0||u>r(i))&&(t.top+=p+f+g))}},flipfit:{left:function(){t.ui.position.flip.left.apply(this,arguments),t.ui.position.fit.left.apply(this,arguments)},top:function(){t.ui.position.flip.top.apply(this,arguments),t.ui.position.fit.top.apply(this,arguments)}}},function(){var e,i,s,n,o,a=document.getElementsByTagName(\"body\")[0],r=document.createElement(\"div\");e=document.createElement(a?\"div\":\"body\"),s={visibility:\"hidden\",width:0,height:0,border:0,margin:0,background:\"none\"},a&&t.extend(s,{position:\"absolute\",left:\"-1000px\",top:\"-1000px\"});for(o in s)e.style[o]=s[o];e.appendChild(r),i=a||document.documentElement,i.insertBefore(e,i.firstChild),r.style.cssText=\"position: absolute; left: 10.7432222px;\",n=t(r).offset().left,t.support.offsetFractions=n>10&&11>n,e.innerHTML=\"\",i.removeChild(e)}()}(jQuery),function(t,e){t.widget(\"ui.progressbar\",{version:\"1.10.2\",options:{max:100,value:0,change:null,complete:null},min:0,_create:function(){this.oldValue=this.options.value=this._constrainedValue(),this.element.addClass(\"ui-progressbar ui-widget ui-widget-content ui-corner-all\").attr({role:\"progressbar\",\"aria-valuemin\":this.min}),this.valueDiv=t(\"<div class='ui-progressbar-value ui-widget-header ui-corner-left'></div>\").appendTo(this.element),this._refreshValue()\n},_destroy:function(){this.element.removeClass(\"ui-progressbar ui-widget ui-widget-content ui-corner-all\").removeAttr(\"role\").removeAttr(\"aria-valuemin\").removeAttr(\"aria-valuemax\").removeAttr(\"aria-valuenow\"),this.valueDiv.remove()},value:function(t){return t===e?this.options.value:(this.options.value=this._constrainedValue(t),this._refreshValue(),e)},_constrainedValue:function(t){return t===e&&(t=this.options.value),this.indeterminate=t===!1,\"number\"!=typeof t&&(t=0),this.indeterminate?!1:Math.min(this.options.max,Math.max(this.min,t))},_setOptions:function(t){var e=t.value;delete t.value,this._super(t),this.options.value=this._constrainedValue(e),this._refreshValue()},_setOption:function(t,e){\"max\"===t&&(e=Math.max(this.min,e)),this._super(t,e)},_percentage:function(){return this.indeterminate?100:100*(this.options.value-this.min)/(this.options.max-this.min)},_refreshValue:function(){var e=this.options.value,i=this._percentage();this.valueDiv.toggle(this.indeterminate||e>this.min).toggleClass(\"ui-corner-right\",e===this.options.max).width(i.toFixed(0)+\"%\"),this.element.toggleClass(\"ui-progressbar-indeterminate\",this.indeterminate),this.indeterminate?(this.element.removeAttr(\"aria-valuenow\"),this.overlayDiv||(this.overlayDiv=t(\"<div class='ui-progressbar-overlay'></div>\").appendTo(this.valueDiv))):(this.element.attr({\"aria-valuemax\":this.options.max,\"aria-valuenow\":e}),this.overlayDiv&&(this.overlayDiv.remove(),this.overlayDiv=null)),this.oldValue!==e&&(this.oldValue=e,this._trigger(\"change\")),e===this.options.max&&this._trigger(\"complete\")}})}(jQuery),function(t){var e=5;t.widget(\"ui.slider\",t.ui.mouse,{version:\"1.10.2\",widgetEventPrefix:\"slide\",options:{animate:!1,distance:0,max:100,min:0,orientation:\"horizontal\",range:!1,step:1,value:0,values:null,change:null,slide:null,start:null,stop:null},_create:function(){this._keySliding=!1,this._mouseSliding=!1,this._animateOff=!0,this._handleIndex=null,this._detectOrientation(),this._mouseInit(),this.element.addClass(\"ui-slider ui-slider-\"+this.orientation+\" ui-widget\"+\" ui-widget-content\"+\" ui-corner-all\"),this._refresh(),this._setOption(\"disabled\",this.options.disabled),this._animateOff=!1},_refresh:function(){this._createRange(),this._createHandles(),this._setupEvents(),this._refreshValue()},_createHandles:function(){var e,i,s=this.options,n=this.element.find(\".ui-slider-handle\").addClass(\"ui-state-default ui-corner-all\"),o=\"<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>\",a=[];for(i=s.values&&s.values.length||1,n.length>i&&(n.slice(i).remove(),n=n.slice(0,i)),e=n.length;i>e;e++)a.push(o);this.handles=n.add(t(a.join(\"\")).appendTo(this.element)),this.handle=this.handles.eq(0),this.handles.each(function(e){t(this).data(\"ui-slider-handle-index\",e)})},_createRange:function(){var e=this.options,i=\"\";e.range?(e.range===!0&&(e.values?e.values.length&&2!==e.values.length?e.values=[e.values[0],e.values[0]]:t.isArray(e.values)&&(e.values=e.values.slice(0)):e.values=[this._valueMin(),this._valueMin()]),this.range&&this.range.length?this.range.removeClass(\"ui-slider-range-min ui-slider-range-max\").css({left:\"\",bottom:\"\"}):(this.range=t(\"<div></div>\").appendTo(this.element),i=\"ui-slider-range ui-widget-header ui-corner-all\"),this.range.addClass(i+(\"min\"===e.range||\"max\"===e.range?\" ui-slider-range-\"+e.range:\"\"))):this.range=t([])},_setupEvents:function(){var t=this.handles.add(this.range).filter(\"a\");this._off(t),this._on(t,this._handleEvents),this._hoverable(t),this._focusable(t)},_destroy:function(){this.handles.remove(),this.range.remove(),this.element.removeClass(\"ui-slider ui-slider-horizontal ui-slider-vertical ui-widget ui-widget-content ui-corner-all\"),this._mouseDestroy()},_mouseCapture:function(e){var i,s,n,o,a,r,h,l,c=this,u=this.options;return u.disabled?!1:(this.elementSize={width:this.element.outerWidth(),height:this.element.outerHeight()},this.elementOffset=this.element.offset(),i={x:e.pageX,y:e.pageY},s=this._normValueFromMouse(i),n=this._valueMax()-this._valueMin()+1,this.handles.each(function(e){var i=Math.abs(s-c.values(e));(n>i||n===i&&(e===c._lastChangedValue||c.values(e)===u.min))&&(n=i,o=t(this),a=e)}),r=this._start(e,a),r===!1?!1:(this._mouseSliding=!0,this._handleIndex=a,o.addClass(\"ui-state-active\").focus(),h=o.offset(),l=!t(e.target).parents().addBack().is(\".ui-slider-handle\"),this._clickOffset=l?{left:0,top:0}:{left:e.pageX-h.left-o.width()/2,top:e.pageY-h.top-o.height()/2-(parseInt(o.css(\"borderTopWidth\"),10)||0)-(parseInt(o.css(\"borderBottomWidth\"),10)||0)+(parseInt(o.css(\"marginTop\"),10)||0)},this.handles.hasClass(\"ui-state-hover\")||this._slide(e,a,s),this._animateOff=!0,!0))},_mouseStart:function(){return!0},_mouseDrag:function(t){var e={x:t.pageX,y:t.pageY},i=this._normValueFromMouse(e);return this._slide(t,this._handleIndex,i),!1},_mouseStop:function(t){return this.handles.removeClass(\"ui-state-active\"),this._mouseSliding=!1,this._stop(t,this._handleIndex),this._change(t,this._handleIndex),this._handleIndex=null,this._clickOffset=null,this._animateOff=!1,!1},_detectOrientation:function(){this.orientation=\"vertical\"===this.options.orientation?\"vertical\":\"horizontal\"},_normValueFromMouse:function(t){var e,i,s,n,o;return\"horizontal\"===this.orientation?(e=this.elementSize.width,i=t.x-this.elementOffset.left-(this._clickOffset?this._clickOffset.left:0)):(e=this.elementSize.height,i=t.y-this.elementOffset.top-(this._clickOffset?this._clickOffset.top:0)),s=i/e,s>1&&(s=1),0>s&&(s=0),\"vertical\"===this.orientation&&(s=1-s),n=this._valueMax()-this._valueMin(),o=this._valueMin()+s*n,this._trimAlignValue(o)},_start:function(t,e){var i={handle:this.handles[e],value:this.value()};return this.options.values&&this.options.values.length&&(i.value=this.values(e),i.values=this.values()),this._trigger(\"start\",t,i)},_slide:function(t,e,i){var s,n,o;this.options.values&&this.options.values.length?(s=this.values(e?0:1),2===this.options.values.length&&this.options.range===!0&&(0===e&&i>s||1===e&&s>i)&&(i=s),i!==this.values(e)&&(n=this.values(),n[e]=i,o=this._trigger(\"slide\",t,{handle:this.handles[e],value:i,values:n}),s=this.values(e?0:1),o!==!1&&this.values(e,i,!0))):i!==this.value()&&(o=this._trigger(\"slide\",t,{handle:this.handles[e],value:i}),o!==!1&&this.value(i))},_stop:function(t,e){var i={handle:this.handles[e],value:this.value()};this.options.values&&this.options.values.length&&(i.value=this.values(e),i.values=this.values()),this._trigger(\"stop\",t,i)},_change:function(t,e){if(!this._keySliding&&!this._mouseSliding){var i={handle:this.handles[e],value:this.value()};this.options.values&&this.options.values.length&&(i.value=this.values(e),i.values=this.values()),this._lastChangedValue=e,this._trigger(\"change\",t,i)}},value:function(t){return arguments.length?(this.options.value=this._trimAlignValue(t),this._refreshValue(),this._change(null,0),undefined):this._value()},values:function(e,i){var s,n,o;if(arguments.length>1)return this.options.values[e]=this._trimAlignValue(i),this._refreshValue(),this._change(null,e),undefined;if(!arguments.length)return this._values();if(!t.isArray(arguments[0]))return this.options.values&&this.options.values.length?this._values(e):this.value();for(s=this.options.values,n=arguments[0],o=0;s.length>o;o+=1)s[o]=this._trimAlignValue(n[o]),this._change(null,o);this._refreshValue()},_setOption:function(e,i){var s,n=0;switch(\"range\"===e&&this.options.range===!0&&(\"min\"===i?(this.options.value=this._values(0),this.options.values=null):\"max\"===i&&(this.options.value=this._values(this.options.values.length-1),this.options.values=null)),t.isArray(this.options.values)&&(n=this.options.values.length),t.Widget.prototype._setOption.apply(this,arguments),e){case\"orientation\":this._detectOrientation(),this.element.removeClass(\"ui-slider-horizontal ui-slider-vertical\").addClass(\"ui-slider-\"+this.orientation),this._refreshValue();break;case\"value\":this._animateOff=!0,this._refreshValue(),this._change(null,0),this._animateOff=!1;break;case\"values\":for(this._animateOff=!0,this._refreshValue(),s=0;n>s;s+=1)this._change(null,s);this._animateOff=!1;break;case\"min\":case\"max\":this._animateOff=!0,this._refreshValue(),this._animateOff=!1;break;case\"range\":this._animateOff=!0,this._refresh(),this._animateOff=!1}},_value:function(){var t=this.options.value;return t=this._trimAlignValue(t)},_values:function(t){var e,i,s;if(arguments.length)return e=this.options.values[t],e=this._trimAlignValue(e);if(this.options.values&&this.options.values.length){for(i=this.options.values.slice(),s=0;i.length>s;s+=1)i[s]=this._trimAlignValue(i[s]);return i}return[]},_trimAlignValue:function(t){if(this._valueMin()>=t)return this._valueMin();if(t>=this._valueMax())return this._valueMax();var e=this.options.step>0?this.options.step:1,i=(t-this._valueMin())%e,s=t-i;return 2*Math.abs(i)>=e&&(s+=i>0?e:-e),parseFloat(s.toFixed(5))},_valueMin:function(){return this.options.min},_valueMax:function(){return this.options.max},_refreshValue:function(){var e,i,s,n,o,a=this.options.range,r=this.options,h=this,l=this._animateOff?!1:r.animate,c={};this.options.values&&this.options.values.length?this.handles.each(function(s){i=100*((h.values(s)-h._valueMin())/(h._valueMax()-h._valueMin())),c[\"horizontal\"===h.orientation?\"left\":\"bottom\"]=i+\"%\",t(this).stop(1,1)[l?\"animate\":\"css\"](c,r.animate),h.options.range===!0&&(\"horizontal\"===h.orientation?(0===s&&h.range.stop(1,1)[l?\"animate\":\"css\"]({left:i+\"%\"},r.animate),1===s&&h.range[l?\"animate\":\"css\"]({width:i-e+\"%\"},{queue:!1,duration:r.animate})):(0===s&&h.range.stop(1,1)[l?\"animate\":\"css\"]({bottom:i+\"%\"},r.animate),1===s&&h.range[l?\"animate\":\"css\"]({height:i-e+\"%\"},{queue:!1,duration:r.animate}))),e=i}):(s=this.value(),n=this._valueMin(),o=this._valueMax(),i=o!==n?100*((s-n)/(o-n)):0,c[\"horizontal\"===this.orientation?\"left\":\"bottom\"]=i+\"%\",this.handle.stop(1,1)[l?\"animate\":\"css\"](c,r.animate),\"min\"===a&&\"horizontal\"===this.orientation&&this.range.stop(1,1)[l?\"animate\":\"css\"]({width:i+\"%\"},r.animate),\"max\"===a&&\"horizontal\"===this.orientation&&this.range[l?\"animate\":\"css\"]({width:100-i+\"%\"},{queue:!1,duration:r.animate}),\"min\"===a&&\"vertical\"===this.orientation&&this.range.stop(1,1)[l?\"animate\":\"css\"]({height:i+\"%\"},r.animate),\"max\"===a&&\"vertical\"===this.orientation&&this.range[l?\"animate\":\"css\"]({height:100-i+\"%\"},{queue:!1,duration:r.animate}))},_handleEvents:{keydown:function(i){var s,n,o,a,r=t(i.target).data(\"ui-slider-handle-index\");switch(i.keyCode){case t.ui.keyCode.HOME:case t.ui.keyCode.END:case t.ui.keyCode.PAGE_UP:case t.ui.keyCode.PAGE_DOWN:case t.ui.keyCode.UP:case t.ui.keyCode.RIGHT:case t.ui.keyCode.DOWN:case t.ui.keyCode.LEFT:if(i.preventDefault(),!this._keySliding&&(this._keySliding=!0,t(i.target).addClass(\"ui-state-active\"),s=this._start(i,r),s===!1))return}switch(a=this.options.step,n=o=this.options.values&&this.options.values.length?this.values(r):this.value(),i.keyCode){case t.ui.keyCode.HOME:o=this._valueMin();break;case t.ui.keyCode.END:o=this._valueMax();break;case t.ui.keyCode.PAGE_UP:o=this._trimAlignValue(n+(this._valueMax()-this._valueMin())/e);break;case t.ui.keyCode.PAGE_DOWN:o=this._trimAlignValue(n-(this._valueMax()-this._valueMin())/e);break;case t.ui.keyCode.UP:case t.ui.keyCode.RIGHT:if(n===this._valueMax())return;o=this._trimAlignValue(n+a);break;case t.ui.keyCode.DOWN:case t.ui.keyCode.LEFT:if(n===this._valueMin())return;o=this._trimAlignValue(n-a)}this._slide(i,r,o)},click:function(t){t.preventDefault()},keyup:function(e){var i=t(e.target).data(\"ui-slider-handle-index\");this._keySliding&&(this._keySliding=!1,this._stop(e,i),this._change(e,i),t(e.target).removeClass(\"ui-state-active\"))}}})}(jQuery),function(t){function e(t){return function(){var e=this.element.val();t.apply(this,arguments),this._refresh(),e!==this.element.val()&&this._trigger(\"change\")}}t.widget(\"ui.spinner\",{version:\"1.10.2\",defaultElement:\"<input>\",widgetEventPrefix:\"spin\",options:{culture:null,icons:{down:\"ui-icon-triangle-1-s\",up:\"ui-icon-triangle-1-n\"},incremental:!0,max:null,min:null,numberFormat:null,page:10,step:1,change:null,spin:null,start:null,stop:null},_create:function(){this._setOption(\"max\",this.options.max),this._setOption(\"min\",this.options.min),this._setOption(\"step\",this.options.step),this._value(this.element.val(),!0),this._draw(),this._on(this._events),this._refresh(),this._on(this.window,{beforeunload:function(){this.element.removeAttr(\"autocomplete\")}})},_getCreateOptions:function(){var e={},i=this.element;return t.each([\"min\",\"max\",\"step\"],function(t,s){var n=i.attr(s);void 0!==n&&n.length&&(e[s]=n)}),e},_events:{keydown:function(t){this._start(t)&&this._keydown(t)&&t.preventDefault()},keyup:\"_stop\",focus:function(){this.previous=this.element.val()},blur:function(t){return this.cancelBlur?(delete this.cancelBlur,void 0):(this._stop(),this._refresh(),this.previous!==this.element.val()&&this._trigger(\"change\",t),void 0)},mousewheel:function(t,e){if(e){if(!this.spinning&&!this._start(t))return!1;this._spin((e>0?1:-1)*this.options.step,t),clearTimeout(this.mousewheelTimer),this.mousewheelTimer=this._delay(function(){this.spinning&&this._stop(t)},100),t.preventDefault()}},\"mousedown .ui-spinner-button\":function(e){function i(){var t=this.element[0]===this.document[0].activeElement;t||(this.element.focus(),this.previous=s,this._delay(function(){this.previous=s}))}var s;s=this.element[0]===this.document[0].activeElement?this.previous:this.element.val(),e.preventDefault(),i.call(this),this.cancelBlur=!0,this._delay(function(){delete this.cancelBlur,i.call(this)}),this._start(e)!==!1&&this._repeat(null,t(e.currentTarget).hasClass(\"ui-spinner-up\")?1:-1,e)},\"mouseup .ui-spinner-button\":\"_stop\",\"mouseenter .ui-spinner-button\":function(e){return t(e.currentTarget).hasClass(\"ui-state-active\")?this._start(e)===!1?!1:(this._repeat(null,t(e.currentTarget).hasClass(\"ui-spinner-up\")?1:-1,e),void 0):void 0},\"mouseleave .ui-spinner-button\":\"_stop\"},_draw:function(){var t=this.uiSpinner=this.element.addClass(\"ui-spinner-input\").attr(\"autocomplete\",\"off\").wrap(this._uiSpinnerHtml()).parent().append(this._buttonHtml());this.element.attr(\"role\",\"spinbutton\"),this.buttons=t.find(\".ui-spinner-button\").attr(\"tabIndex\",-1).button().removeClass(\"ui-corner-all\"),this.buttons.height()>Math.ceil(.5*t.height())&&t.height()>0&&t.height(t.height()),this.options.disabled&&this.disable()},_keydown:function(e){var i=this.options,s=t.ui.keyCode;switch(e.keyCode){case s.UP:return this._repeat(null,1,e),!0;case s.DOWN:return this._repeat(null,-1,e),!0;case s.PAGE_UP:return this._repeat(null,i.page,e),!0;case s.PAGE_DOWN:return this._repeat(null,-i.page,e),!0}return!1},_uiSpinnerHtml:function(){return\"<span class='ui-spinner ui-widget ui-widget-content ui-corner-all'></span>\"},_buttonHtml:function(){return\"<a class='ui-spinner-button ui-spinner-up ui-corner-tr'><span class='ui-icon \"+this.options.icons.up+\"'>&#9650;</span>\"+\"</a>\"+\"<a class='ui-spinner-button ui-spinner-down ui-corner-br'>\"+\"<span class='ui-icon \"+this.options.icons.down+\"'>&#9660;</span>\"+\"</a>\"},_start:function(t){return this.spinning||this._trigger(\"start\",t)!==!1?(this.counter||(this.counter=1),this.spinning=!0,!0):!1},_repeat:function(t,e,i){t=t||500,clearTimeout(this.timer),this.timer=this._delay(function(){this._repeat(40,e,i)},t),this._spin(e*this.options.step,i)},_spin:function(t,e){var i=this.value()||0;this.counter||(this.counter=1),i=this._adjustValue(i+t*this._increment(this.counter)),this.spinning&&this._trigger(\"spin\",e,{value:i})===!1||(this._value(i),this.counter++)},_increment:function(e){var i=this.options.incremental;return i?t.isFunction(i)?i(e):Math.floor(e*e*e/5e4-e*e/500+17*e/200+1):1},_precision:function(){var t=this._precisionOf(this.options.step);return null!==this.options.min&&(t=Math.max(t,this._precisionOf(this.options.min))),t},_precisionOf:function(t){var e=\"\"+t,i=e.indexOf(\".\");return-1===i?0:e.length-i-1},_adjustValue:function(t){var e,i,s=this.options;return e=null!==s.min?s.min:0,i=t-e,i=Math.round(i/s.step)*s.step,t=e+i,t=parseFloat(t.toFixed(this._precision())),null!==s.max&&t>s.max?s.max:null!==s.min&&s.min>t?s.min:t},_stop:function(t){this.spinning&&(clearTimeout(this.timer),clearTimeout(this.mousewheelTimer),this.counter=0,this.spinning=!1,this._trigger(\"stop\",t))},_setOption:function(t,e){if(\"culture\"===t||\"numberFormat\"===t){var i=this._parse(this.element.val());return this.options[t]=e,this.element.val(this._format(i)),void 0}(\"max\"===t||\"min\"===t||\"step\"===t)&&\"string\"==typeof e&&(e=this._parse(e)),\"icons\"===t&&(this.buttons.first().find(\".ui-icon\").removeClass(this.options.icons.up).addClass(e.up),this.buttons.last().find(\".ui-icon\").removeClass(this.options.icons.down).addClass(e.down)),this._super(t,e),\"disabled\"===t&&(e?(this.element.prop(\"disabled\",!0),this.buttons.button(\"disable\")):(this.element.prop(\"disabled\",!1),this.buttons.button(\"enable\")))},_setOptions:e(function(t){this._super(t),this._value(this.element.val())}),_parse:function(t){return\"string\"==typeof t&&\"\"!==t&&(t=window.Globalize&&this.options.numberFormat?Globalize.parseFloat(t,10,this.options.culture):+t),\"\"===t||isNaN(t)?null:t},_format:function(t){return\"\"===t?\"\":window.Globalize&&this.options.numberFormat?Globalize.format(t,this.options.numberFormat,this.options.culture):t},_refresh:function(){this.element.attr({\"aria-valuemin\":this.options.min,\"aria-valuemax\":this.options.max,\"aria-valuenow\":this._parse(this.element.val())})},_value:function(t,e){var i;\"\"!==t&&(i=this._parse(t),null!==i&&(e||(i=this._adjustValue(i)),t=this._format(i))),this.element.val(t),this._refresh()},_destroy:function(){this.element.removeClass(\"ui-spinner-input\").prop(\"disabled\",!1).removeAttr(\"autocomplete\").removeAttr(\"role\").removeAttr(\"aria-valuemin\").removeAttr(\"aria-valuemax\").removeAttr(\"aria-valuenow\"),this.uiSpinner.replaceWith(this.element)},stepUp:e(function(t){this._stepUp(t)}),_stepUp:function(t){this._start()&&(this._spin((t||1)*this.options.step),this._stop())},stepDown:e(function(t){this._stepDown(t)}),_stepDown:function(t){this._start()&&(this._spin((t||1)*-this.options.step),this._stop())},pageUp:e(function(t){this._stepUp((t||1)*this.options.page)}),pageDown:e(function(t){this._stepDown((t||1)*this.options.page)}),value:function(t){return arguments.length?(e(this._value).call(this,t),void 0):this._parse(this.element.val())},widget:function(){return this.uiSpinner}})}(jQuery),function(t,e){function i(){return++n}function s(t){return t.hash.length>1&&decodeURIComponent(t.href.replace(o,\"\"))===decodeURIComponent(location.href.replace(o,\"\"))}var n=0,o=/#.*$/;t.widget(\"ui.tabs\",{version:\"1.10.2\",delay:300,options:{active:null,collapsible:!1,event:\"click\",heightStyle:\"content\",hide:null,show:null,activate:null,beforeActivate:null,beforeLoad:null,load:null},_create:function(){var e=this,i=this.options;this.running=!1,this.element.addClass(\"ui-tabs ui-widget ui-widget-content ui-corner-all\").toggleClass(\"ui-tabs-collapsible\",i.collapsible).delegate(\".ui-tabs-nav > li\",\"mousedown\"+this.eventNamespace,function(e){t(this).is(\".ui-state-disabled\")&&e.preventDefault()}).delegate(\".ui-tabs-anchor\",\"focus\"+this.eventNamespace,function(){t(this).closest(\"li\").is(\".ui-state-disabled\")&&this.blur()}),this._processTabs(),i.active=this._initialActive(),t.isArray(i.disabled)&&(i.disabled=t.unique(i.disabled.concat(t.map(this.tabs.filter(\".ui-state-disabled\"),function(t){return e.tabs.index(t)}))).sort()),this.active=this.options.active!==!1&&this.anchors.length?this._findActive(i.active):t(),this._refresh(),this.active.length&&this.load(i.active)},_initialActive:function(){var i=this.options.active,s=this.options.collapsible,n=location.hash.substring(1);return null===i&&(n&&this.tabs.each(function(s,o){return t(o).attr(\"aria-controls\")===n?(i=s,!1):e}),null===i&&(i=this.tabs.index(this.tabs.filter(\".ui-tabs-active\"))),(null===i||-1===i)&&(i=this.tabs.length?0:!1)),i!==!1&&(i=this.tabs.index(this.tabs.eq(i)),-1===i&&(i=s?!1:0)),!s&&i===!1&&this.anchors.length&&(i=0),i},_getCreateEventData:function(){return{tab:this.active,panel:this.active.length?this._getPanelForTab(this.active):t()}},_tabKeydown:function(i){var s=t(this.document[0].activeElement).closest(\"li\"),n=this.tabs.index(s),o=!0;if(!this._handlePageNav(i)){switch(i.keyCode){case t.ui.keyCode.RIGHT:case t.ui.keyCode.DOWN:n++;break;case t.ui.keyCode.UP:case t.ui.keyCode.LEFT:o=!1,n--;break;case t.ui.keyCode.END:n=this.anchors.length-1;break;case t.ui.keyCode.HOME:n=0;break;case t.ui.keyCode.SPACE:return i.preventDefault(),clearTimeout(this.activating),this._activate(n),e;case t.ui.keyCode.ENTER:return i.preventDefault(),clearTimeout(this.activating),this._activate(n===this.options.active?!1:n),e;default:return}i.preventDefault(),clearTimeout(this.activating),n=this._focusNextTab(n,o),i.ctrlKey||(s.attr(\"aria-selected\",\"false\"),this.tabs.eq(n).attr(\"aria-selected\",\"true\"),this.activating=this._delay(function(){this.option(\"active\",n)},this.delay))}},_panelKeydown:function(e){this._handlePageNav(e)||e.ctrlKey&&e.keyCode===t.ui.keyCode.UP&&(e.preventDefault(),this.active.focus())},_handlePageNav:function(i){return i.altKey&&i.keyCode===t.ui.keyCode.PAGE_UP?(this._activate(this._focusNextTab(this.options.active-1,!1)),!0):i.altKey&&i.keyCode===t.ui.keyCode.PAGE_DOWN?(this._activate(this._focusNextTab(this.options.active+1,!0)),!0):e},_findNextTab:function(e,i){function s(){return e>n&&(e=0),0>e&&(e=n),e}for(var n=this.tabs.length-1;-1!==t.inArray(s(),this.options.disabled);)e=i?e+1:e-1;return e},_focusNextTab:function(t,e){return t=this._findNextTab(t,e),this.tabs.eq(t).focus(),t},_setOption:function(t,i){return\"active\"===t?(this._activate(i),e):\"disabled\"===t?(this._setupDisabled(i),e):(this._super(t,i),\"collapsible\"===t&&(this.element.toggleClass(\"ui-tabs-collapsible\",i),i||this.options.active!==!1||this._activate(0)),\"event\"===t&&this._setupEvents(i),\"heightStyle\"===t&&this._setupHeightStyle(i),e)},_tabId:function(t){return t.attr(\"aria-controls\")||\"ui-tabs-\"+i()},_sanitizeSelector:function(t){return t?t.replace(/[!\"$%&'()*+,.\\/:;<=>?@\\[\\]\\^`{|}~]/g,\"\\\\$&\"):\"\"},refresh:function(){var e=this.options,i=this.tablist.children(\":has(a[href])\");e.disabled=t.map(i.filter(\".ui-state-disabled\"),function(t){return i.index(t)}),this._processTabs(),e.active!==!1&&this.anchors.length?this.active.length&&!t.contains(this.tablist[0],this.active[0])?this.tabs.length===e.disabled.length?(e.active=!1,this.active=t()):this._activate(this._findNextTab(Math.max(0,e.active-1),!1)):e.active=this.tabs.index(this.active):(e.active=!1,this.active=t()),this._refresh()},_refresh:function(){this._setupDisabled(this.options.disabled),this._setupEvents(this.options.event),this._setupHeightStyle(this.options.heightStyle),this.tabs.not(this.active).attr({\"aria-selected\":\"false\",tabIndex:-1}),this.panels.not(this._getPanelForTab(this.active)).hide().attr({\"aria-expanded\":\"false\",\"aria-hidden\":\"true\"}),this.active.length?(this.active.addClass(\"ui-tabs-active ui-state-active\").attr({\"aria-selected\":\"true\",tabIndex:0}),this._getPanelForTab(this.active).show().attr({\"aria-expanded\":\"true\",\"aria-hidden\":\"false\"})):this.tabs.eq(0).attr(\"tabIndex\",0)},_processTabs:function(){var e=this;this.tablist=this._getList().addClass(\"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\").attr(\"role\",\"tablist\"),this.tabs=this.tablist.find(\"> li:has(a[href])\").addClass(\"ui-state-default ui-corner-top\").attr({role:\"tab\",tabIndex:-1}),this.anchors=this.tabs.map(function(){return t(\"a\",this)[0]}).addClass(\"ui-tabs-anchor\").attr({role:\"presentation\",tabIndex:-1}),this.panels=t(),this.anchors.each(function(i,n){var o,a,r,h=t(n).uniqueId().attr(\"id\"),l=t(n).closest(\"li\"),c=l.attr(\"aria-controls\");s(n)?(o=n.hash,a=e.element.find(e._sanitizeSelector(o))):(r=e._tabId(l),o=\"#\"+r,a=e.element.find(o),a.length||(a=e._createPanel(r),a.insertAfter(e.panels[i-1]||e.tablist)),a.attr(\"aria-live\",\"polite\")),a.length&&(e.panels=e.panels.add(a)),c&&l.data(\"ui-tabs-aria-controls\",c),l.attr({\"aria-controls\":o.substring(1),\"aria-labelledby\":h}),a.attr(\"aria-labelledby\",h)}),this.panels.addClass(\"ui-tabs-panel ui-widget-content ui-corner-bottom\").attr(\"role\",\"tabpanel\")},_getList:function(){return this.element.find(\"ol,ul\").eq(0)},_createPanel:function(e){return t(\"<div>\").attr(\"id\",e).addClass(\"ui-tabs-panel ui-widget-content ui-corner-bottom\").data(\"ui-tabs-destroy\",!0)},_setupDisabled:function(e){t.isArray(e)&&(e.length?e.length===this.anchors.length&&(e=!0):e=!1);for(var i,s=0;i=this.tabs[s];s++)e===!0||-1!==t.inArray(s,e)?t(i).addClass(\"ui-state-disabled\").attr(\"aria-disabled\",\"true\"):t(i).removeClass(\"ui-state-disabled\").removeAttr(\"aria-disabled\");this.options.disabled=e},_setupEvents:function(e){var i={click:function(t){t.preventDefault()}};e&&t.each(e.split(\" \"),function(t,e){i[e]=\"_eventHandler\"}),this._off(this.anchors.add(this.tabs).add(this.panels)),this._on(this.anchors,i),this._on(this.tabs,{keydown:\"_tabKeydown\"}),this._on(this.panels,{keydown:\"_panelKeydown\"}),this._focusable(this.tabs),this._hoverable(this.tabs)},_setupHeightStyle:function(e){var i,s=this.element.parent();\"fill\"===e?(i=s.height(),i-=this.element.outerHeight()-this.element.height(),this.element.siblings(\":visible\").each(function(){var e=t(this),s=e.css(\"position\");\"absolute\"!==s&&\"fixed\"!==s&&(i-=e.outerHeight(!0))}),this.element.children().not(this.panels).each(function(){i-=t(this).outerHeight(!0)}),this.panels.each(function(){t(this).height(Math.max(0,i-t(this).innerHeight()+t(this).height()))}).css(\"overflow\",\"auto\")):\"auto\"===e&&(i=0,this.panels.each(function(){i=Math.max(i,t(this).height(\"\").height())}).height(i))},_eventHandler:function(e){var i=this.options,s=this.active,n=t(e.currentTarget),o=n.closest(\"li\"),a=o[0]===s[0],r=a&&i.collapsible,h=r?t():this._getPanelForTab(o),l=s.length?this._getPanelForTab(s):t(),c={oldTab:s,oldPanel:l,newTab:r?t():o,newPanel:h};e.preventDefault(),o.hasClass(\"ui-state-disabled\")||o.hasClass(\"ui-tabs-loading\")||this.running||a&&!i.collapsible||this._trigger(\"beforeActivate\",e,c)===!1||(i.active=r?!1:this.tabs.index(o),this.active=a?t():o,this.xhr&&this.xhr.abort(),l.length||h.length||t.error(\"jQuery UI Tabs: Mismatching fragment identifier.\"),h.length&&this.load(this.tabs.index(o),e),this._toggle(e,c))},_toggle:function(e,i){function s(){o.running=!1,o._trigger(\"activate\",e,i)}function n(){i.newTab.closest(\"li\").addClass(\"ui-tabs-active ui-state-active\"),a.length&&o.options.show?o._show(a,o.options.show,s):(a.show(),s())}var o=this,a=i.newPanel,r=i.oldPanel;this.running=!0,r.length&&this.options.hide?this._hide(r,this.options.hide,function(){i.oldTab.closest(\"li\").removeClass(\"ui-tabs-active ui-state-active\"),n()}):(i.oldTab.closest(\"li\").removeClass(\"ui-tabs-active ui-state-active\"),r.hide(),n()),r.attr({\"aria-expanded\":\"false\",\"aria-hidden\":\"true\"}),i.oldTab.attr(\"aria-selected\",\"false\"),a.length&&r.length?i.oldTab.attr(\"tabIndex\",-1):a.length&&this.tabs.filter(function(){return 0===t(this).attr(\"tabIndex\")}).attr(\"tabIndex\",-1),a.attr({\"aria-expanded\":\"true\",\"aria-hidden\":\"false\"}),i.newTab.attr({\"aria-selected\":\"true\",tabIndex:0})},_activate:function(e){var i,s=this._findActive(e);s[0]!==this.active[0]&&(s.length||(s=this.active),i=s.find(\".ui-tabs-anchor\")[0],this._eventHandler({target:i,currentTarget:i,preventDefault:t.noop}))},_findActive:function(e){return e===!1?t():this.tabs.eq(e)},_getIndex:function(t){return\"string\"==typeof t&&(t=this.anchors.index(this.anchors.filter(\"[href$='\"+t+\"']\"))),t},_destroy:function(){this.xhr&&this.xhr.abort(),this.element.removeClass(\"ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible\"),this.tablist.removeClass(\"ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all\").removeAttr(\"role\"),this.anchors.removeClass(\"ui-tabs-anchor\").removeAttr(\"role\").removeAttr(\"tabIndex\").removeUniqueId(),this.tabs.add(this.panels).each(function(){t.data(this,\"ui-tabs-destroy\")?t(this).remove():t(this).removeClass(\"ui-state-default ui-state-active ui-state-disabled ui-corner-top ui-corner-bottom ui-widget-content ui-tabs-active ui-tabs-panel\").removeAttr(\"tabIndex\").removeAttr(\"aria-live\").removeAttr(\"aria-busy\").removeAttr(\"aria-selected\").removeAttr(\"aria-labelledby\").removeAttr(\"aria-hidden\").removeAttr(\"aria-expanded\").removeAttr(\"role\")}),this.tabs.each(function(){var e=t(this),i=e.data(\"ui-tabs-aria-controls\");i?e.attr(\"aria-controls\",i).removeData(\"ui-tabs-aria-controls\"):e.removeAttr(\"aria-controls\")}),this.panels.show(),\"content\"!==this.options.heightStyle&&this.panels.css(\"height\",\"\")},enable:function(i){var s=this.options.disabled;s!==!1&&(i===e?s=!1:(i=this._getIndex(i),s=t.isArray(s)?t.map(s,function(t){return t!==i?t:null}):t.map(this.tabs,function(t,e){return e!==i?e:null})),this._setupDisabled(s))},disable:function(i){var s=this.options.disabled;if(s!==!0){if(i===e)s=!0;else{if(i=this._getIndex(i),-1!==t.inArray(i,s))return;s=t.isArray(s)?t.merge([i],s).sort():[i]}this._setupDisabled(s)}},load:function(e,i){e=this._getIndex(e);var n=this,o=this.tabs.eq(e),a=o.find(\".ui-tabs-anchor\"),r=this._getPanelForTab(o),h={tab:o,panel:r};s(a[0])||(this.xhr=t.ajax(this._ajaxSettings(a,i,h)),this.xhr&&\"canceled\"!==this.xhr.statusText&&(o.addClass(\"ui-tabs-loading\"),r.attr(\"aria-busy\",\"true\"),this.xhr.success(function(t){setTimeout(function(){r.html(t),n._trigger(\"load\",i,h)},1)}).complete(function(t,e){setTimeout(function(){\"abort\"===e&&n.panels.stop(!1,!0),o.removeClass(\"ui-tabs-loading\"),r.removeAttr(\"aria-busy\"),t===n.xhr&&delete n.xhr},1)})))},_ajaxSettings:function(e,i,s){var n=this;return{url:e.attr(\"href\"),beforeSend:function(e,o){return n._trigger(\"beforeLoad\",i,t.extend({jqXHR:e,ajaxSettings:o},s))}}},_getPanelForTab:function(e){var i=t(e).attr(\"aria-controls\");return this.element.find(this._sanitizeSelector(\"#\"+i))}})}(jQuery),function(t){function e(e,i){var s=(e.attr(\"aria-describedby\")||\"\").split(/\\s+/);s.push(i),e.data(\"ui-tooltip-id\",i).attr(\"aria-describedby\",t.trim(s.join(\" \")))}function i(e){var i=e.data(\"ui-tooltip-id\"),s=(e.attr(\"aria-describedby\")||\"\").split(/\\s+/),n=t.inArray(i,s);-1!==n&&s.splice(n,1),e.removeData(\"ui-tooltip-id\"),s=t.trim(s.join(\" \")),s?e.attr(\"aria-describedby\",s):e.removeAttr(\"aria-describedby\")}var s=0;t.widget(\"ui.tooltip\",{version:\"1.10.2\",options:{content:function(){var e=t(this).attr(\"title\")||\"\";return t(\"<a>\").text(e).html()},hide:!0,items:\"[title]:not([disabled])\",position:{my:\"left top+15\",at:\"left bottom\",collision:\"flipfit flip\"},show:!0,tooltipClass:null,track:!1,close:null,open:null},_create:function(){this._on({mouseover:\"open\",focusin:\"open\"}),this.tooltips={},this.parents={},this.options.disabled&&this._disable()},_setOption:function(e,i){var s=this;return\"disabled\"===e?(this[i?\"_disable\":\"_enable\"](),this.options[e]=i,void 0):(this._super(e,i),\"content\"===e&&t.each(this.tooltips,function(t,e){s._updateContent(e)}),void 0)},_disable:function(){var e=this;t.each(this.tooltips,function(i,s){var n=t.Event(\"blur\");n.target=n.currentTarget=s[0],e.close(n,!0)}),this.element.find(this.options.items).addBack().each(function(){var e=t(this);e.is(\"[title]\")&&e.data(\"ui-tooltip-title\",e.attr(\"title\")).attr(\"title\",\"\")})},_enable:function(){this.element.find(this.options.items).addBack().each(function(){var e=t(this);e.data(\"ui-tooltip-title\")&&e.attr(\"title\",e.data(\"ui-tooltip-title\"))})},open:function(e){var i=this,s=t(e?e.target:this.element).closest(this.options.items);s.length&&!s.data(\"ui-tooltip-id\")&&(s.attr(\"title\")&&s.data(\"ui-tooltip-title\",s.attr(\"title\")),s.data(\"ui-tooltip-open\",!0),e&&\"mouseover\"===e.type&&s.parents().each(function(){var e,s=t(this);s.data(\"ui-tooltip-open\")&&(e=t.Event(\"blur\"),e.target=e.currentTarget=this,i.close(e,!0)),s.attr(\"title\")&&(s.uniqueId(),i.parents[this.id]={element:this,title:s.attr(\"title\")},s.attr(\"title\",\"\"))}),this._updateContent(s,e))},_updateContent:function(t,e){var i,s=this.options.content,n=this,o=e?e.type:null;return\"string\"==typeof s?this._open(e,t,s):(i=s.call(t[0],function(i){t.data(\"ui-tooltip-open\")&&n._delay(function(){e&&(e.type=o),this._open(e,t,i)\n})}),i&&this._open(e,t,i),void 0)},_open:function(i,s,n){function o(t){l.of=t,a.is(\":hidden\")||a.position(l)}var a,r,h,l=t.extend({},this.options.position);if(n){if(a=this._find(s),a.length)return a.find(\".ui-tooltip-content\").html(n),void 0;s.is(\"[title]\")&&(i&&\"mouseover\"===i.type?s.attr(\"title\",\"\"):s.removeAttr(\"title\")),a=this._tooltip(s),e(s,a.attr(\"id\")),a.find(\".ui-tooltip-content\").html(n),this.options.track&&i&&/^mouse/.test(i.type)?(this._on(this.document,{mousemove:o}),o(i)):a.position(t.extend({of:s},this.options.position)),a.hide(),this._show(a,this.options.show),this.options.show&&this.options.show.delay&&(h=this.delayedShow=setInterval(function(){a.is(\":visible\")&&(o(l.of),clearInterval(h))},t.fx.interval)),this._trigger(\"open\",i,{tooltip:a}),r={keyup:function(e){if(e.keyCode===t.ui.keyCode.ESCAPE){var i=t.Event(e);i.currentTarget=s[0],this.close(i,!0)}},remove:function(){this._removeTooltip(a)}},i&&\"mouseover\"!==i.type||(r.mouseleave=\"close\"),i&&\"focusin\"!==i.type||(r.focusout=\"close\"),this._on(!0,s,r)}},close:function(e){var s=this,n=t(e?e.currentTarget:this.element),o=this._find(n);this.closing||(clearInterval(this.delayedShow),n.data(\"ui-tooltip-title\")&&n.attr(\"title\",n.data(\"ui-tooltip-title\")),i(n),o.stop(!0),this._hide(o,this.options.hide,function(){s._removeTooltip(t(this))}),n.removeData(\"ui-tooltip-open\"),this._off(n,\"mouseleave focusout keyup\"),n[0]!==this.element[0]&&this._off(n,\"remove\"),this._off(this.document,\"mousemove\"),e&&\"mouseleave\"===e.type&&t.each(this.parents,function(e,i){t(i.element).attr(\"title\",i.title),delete s.parents[e]}),this.closing=!0,this._trigger(\"close\",e,{tooltip:o}),this.closing=!1)},_tooltip:function(e){var i=\"ui-tooltip-\"+s++,n=t(\"<div>\").attr({id:i,role:\"tooltip\"}).addClass(\"ui-tooltip ui-widget ui-corner-all ui-widget-content \"+(this.options.tooltipClass||\"\"));return t(\"<div>\").addClass(\"ui-tooltip-content\").appendTo(n),n.appendTo(this.document[0].body),this.tooltips[i]=e,n},_find:function(e){var i=e.data(\"ui-tooltip-id\");return i?t(\"#\"+i):t()},_removeTooltip:function(t){t.remove(),delete this.tooltips[t.attr(\"id\")]},_destroy:function(){var e=this;t.each(this.tooltips,function(i,s){var n=t.Event(\"blur\");n.target=n.currentTarget=s[0],e.close(n,!0),t(\"#\"+i).remove(),s.data(\"ui-tooltip-title\")&&(s.attr(\"title\",s.data(\"ui-tooltip-title\")),s.removeData(\"ui-tooltip-title\"))})}})}(jQuery);});","Sendinblue_Sendinblue/js/sib.js":"require([\n    \"jquery\",\n    \"jquery/ui\",\n    'domReady!'\n], function($) {\n    //<![CDATA[\n    $(document).ready(\n        function() {\n            var token = jQuery(\"#customtoken\").val();\n            var id_shop_group = jQuery(\"#id_shop_group\").val();\n            var id_shop = jQuery(\"#id_shop\").val();\n            var iso_code = jQuery('#iso_code').val();\n\n            $(\".keyyes\").click(function() {\n                if (jQuery(this).val() == 1) {\n                    jQuery(\"#apikeybox\").show();\n                    //jQuery(\".hidetableblock\").show();\n                    jQuery(\".unsubscription\").show();\n                    jQuery(\".listData\").show();\n\n                } else {\n                    jQuery(\"#apikeybox\").hide();\n                    jQuery(\".hidetableblock\").hide();\n                    jQuery(\".unsubscription\").hide();\n                    jQuery(\".listData\").hide();\n                }\n\n            });\n\n\n            if (!$('#apikeybox').is(':hidden')) {\n\n                $('#sender_order').keyup(function() {\n                    var val = $(this).val();\n                    if (isInteger(val) || val.length == 0) {\n                        $(\"#sender_order\").attr('maxlength', '11');\n                        $('#sender_order_text').text((11 - val.length));\n                    } else {\n                        $(\"#sender_order\").attr('maxlength', '11');\n                        $('#sender_order_text').text((11 - val.length));\n                    }\n                });\n\n\n                /*----- Function for check list value  ------*/\n                $('.submitForm2').on('click', function() {\n                    var list = $('#display_list').val();\n                    if (!list) {\n                        alert('Please choose atleast one list.');\n                        return false;\n                    }\n                });\n                /*------ Ends ----------*/\n\n                    $('.manage_subscribe_block input[name=subscribe_confirm_type]').click(function() {\n\n                        $('.manage_subscribe_block .inner_manage_box').slideUp();\n                        $(this).parents('.manage_subscribe_block').find('.inner_manage_box').slideDown();\n\n                    });\n\n                    $('.openCollapse').click(function() {\n\n                        if ($(this).is(\":checked\")) {\n                            $(this).parent('.form-group').find('.collapse').slideDown();\n                        } else {\n                            $(this).parent('.form-group').find('.collapse').slideUp();\n                        }\n                    });\n                \n\n                //doubleoptin alert functionality\n\n                $('#template_doubleoptin').bind('change', function() {\n                    var abcs = $(this).find('option:selected').text().toLowerCase().indexOf('double optin');\n                    if (abcs === -1) {\n                        alert('You must select a template with the tag {{ doubleoptin }}');\n                        var selectedObj = $('#template_doubleoptin option').filter(function() {\n                            return $(this).text().toLowerCase().indexOf('double optin') !== -1\n                        });\n                        selectedObj.attr('selected', true)\n                        $(this).val(selectedObj.val());\n                    }\n                });\n                //  append hidden field in edit personal information page\n                window.onload = function() {\n                    var newsletter_hidden_val = $('#newsletter').val();\n                    $(\"#newsletter\").append('<input type=\"hidden\" id=\"sendinflag\" value=\"' + newsletter_hidden_val + '\" name=\"sendinflag\">');\n                };\n\n                $('#sender_order').keyup(function(e) {\n                    var str = $(this).val();\n                    str = str.replace(/[^a-zA-Z 0-9]+/g, '');\n                    $('#sender_order').val(str);\n                });\n                $('#sender_shipment').keyup(function(e) {\n                    var str = $(this).val();\n                    str = str.replace(/[^a-zA-Z 0-9]+/g, '');\n                    $('#sender_shipment').val(str);\n                });\n                $('#sender_campaign').keyup(function(e) {\n                    var str = $(this).val();\n                    str = str.replace(/[^a-zA-Z 0-9]+/g, '');\n                    $('#sender_campaign').val(str);\n                });\n\n                if ($('#sender_order').val() != '' || $('#sender_order').val() == '') {\n                    var val_d = $('#sender_order').val();\n\n                    if (val_d != 'undefine' || isInteger(val_d) || val_d.length == 0) {\n                        $(\"#sender_order\").attr('maxlength', '11');\n                        //$('#sender_order_text').text((11 - val_d.length));\n\n                    } else {\n                        $(\"#sender_order\").attr('maxlength', '11');\n                        $('#sender_order_text').text((11 - val_d.length));\n                    }\n                }\n\n                $(\"#sender_order\").keydown(function(event) {\n                    if (event.keyCode == 32) {\n                        event.preventDefault();\n                    }\n                });\n\n                $('#sender_order_message').keyup(function() {\n                    var chars = this.value.length,\n                        messages = Math.ceil(chars / 160),\n                        remaining = messages * 160 - (chars % (messages * 160) || messages * 160);\n                    if (remaining == 0) {\n                        remaining = 160.\n                    }\n\n                    $('#sender_order_message_text').text(remaining);\n                    $('#sender_order_message_text_count').text(messages);\n                });\n\n                if ($('#sender_order_message').val() != '' || $('#sender_order_message').val() == '') {\n                    var chars = $('#sender_order_message').val().length;\n\n                    var messages = Math.ceil(chars / 160);\n                    remaining = messages * 160 - (chars % (messages * 160) || messages * 160);\n                    if (remaining == 0) {\n                        remaining = 160.\n                    }\n                    $('#sender_order_message_text').text(remaining);\n                    $('#sender_order_message_text_count').text(messages);\n                }\n\n                $('#sender_shipment').keyup(function() {\n                    var val = $(this).val();\n\n                    if (isInteger(val) || val.length == 0) {\n                        $(\"#sender_shipment\").attr('maxlength', '11');\n                        $('#sender_shipment_text').text((11 - val.length));\n                    } else {\n                        $(\"#sender_shipment\").attr('maxlength', '11');\n                        $('#sender_shipment_text').text((11 - val.length));\n                    }\n                });\n\n                if ($('#sender_shipment').val() != '' || $('#sender_shipment').val() == '') {\n                    //var val = $('#sender_shipment').val();\n                    var val = 0;\n                    if (isInteger(val) || val.length == 0) {\n                        $(\"#sender_shipment\").attr('maxlength', '11');\n                        $('#sender_shipment_text').text((11 - val.length));\n                    } else {\n                        $(\"#sender_shipment\").attr('maxlength', '11');\n                        $('#sender_shipment_text').text((11 - val.length));\n                    }\n                }\n                $(\"#sender_shipment\").keydown(function(event) {\n                    if (event.keyCode == 32) {\n                        event.preventDefault();\n                    }\n                });\n\n                $('#sender_shipment_message').keyup(function() {\n                    var chars = this.value.length,\n                        messages = Math.ceil(chars / 160),\n                        remaining = messages * 160 - (chars % (messages * 160) || messages * 160);\n                    if (remaining == 0) {\n                        remaining = 160.\n\n                    }\n                    $('#sender_shipment_message_text').text(remaining);\n\n                    $('#sender_shipment_message_text_count').text(messages);\n\n                });\n\n                if ($('#sender_shipment_message').val() != '' || $('#sender_shipment_message').val() == '') {\n                    var chars = $('#sender_shipment_message').val().length;\n                    var messages = Math.ceil(chars / 160);\n                    remaining = messages * 160 - (chars % (messages * 160) || messages * 160);\n                    if (remaining == 0) {\n                        remaining = 160.\n\n                    }\n                    $('#sender_shipment_message_text').text(remaining);\n\n                    $('#sender_shipment_message_text_count').text(messages);\n                }\n\n                $('#sender_campaign').keyup(function() {\n                    var val = $(this).val();\n\n                    if (isInteger(val) || val.length == 0) {\n                        $(\"#sender_campaign\").attr('maxlength', '11');\n                        $('#sender_campaign_text').text((11 - val.length));\n                    } else {\n                        $(\"#sender_campaign\").attr('maxlength', '11');\n                        $('#sender_campaign_text').text((11 - val.length));\n                    }\n                });\n\n                if ($('#sender_campaign').val() != '') {\n                    //var val = $('#sender_campaign').val();\n                    var val = 0;\n                    if (isInteger(val) || val.length == 0) {\n                        $(\"#sender_campaign\").attr('maxlength', '11');\n                        $('#sender_campaign_text').text((11 - val.length));\n                    } else {\n                        $(\"#sender_campaign\").attr('maxlength', '11');\n                        $('#sender_campaign_text').text((11 - val.length));\n                    }\n                }\n                $(\"#sender_campaign\").keydown(function(event) {\n                    if (event.keyCode == 32) {\n                        event.preventDefault();\n                    }\n                });\n\n                $('#sender_campaign_message').keyup(function() {\n                    var chars = this.value.length;\n                    var messages = Math.ceil(chars / 160);\n                    var remaining = messages * 160 - (chars % (messages * 160) || messages * 160);\n                    if (remaining == 0) {\n                        remaining = 160.\n                    }\n                    $('#sender_campaign_message_text').text(remaining);\n                    $('#sender_campaign_message_text_count').text(messages);\n                });\n\n                if ($('#sender_campaign_message').val() != '') {\n                    //var chars = $('#sender_campaign_message').val().length,\n                    var chars = 0;\n                    messages = Math.ceil(chars / 160),\n                        remaining = messages * 160 - (chars % (messages * 160) || messages * 160);\n\n                    $('#sender_campaign_message_text').text(remaining);\n\n                    $('#sender_campaign_message_text_count').text(messages);\n                }\n\n                $(\".sms_order_setting_cls\").click(function() {\n                    $(this).parents('td').find('.loading-ajax').show();\n                    var order_setting_post = jQuery(this).val();\n                    var order_setting = $(\"input[name='sms_order_setting']:checked\").val();\n                    var type = 'order';\n                    var form_key = jQuery(\"#form_key\").val();\n                    var file_url = jQuery(\"#ajaxcontentUrl\").val();\n                    $.ajax({\n                        type: \"POST\",\n                        async: false,\n                        url: file_url,\n                        data: {\n                            \"form_key\": form_key,\n                            \"order_setting\": order_setting,\n                            \"order_setting_post\": order_setting_post,\n                            \"type\": type\n                        },\n                        beforeSend: function() {\n                            $('#ajax-busy').show();\n                        },\n                        success: function(msg) {\n                            $('#ajax-busy').hide();\n                            $('.loading-ajax').hide();\n                            if (order_setting == 1) {\n                                jQuery(\".hideOrder\").show();\n                            } else {\n                                jQuery(\".hideOrder\").hide();\n                            }\n                            alert(msg);\n                        }\n                    });\n                });\n                $(\".sms_shiping_setting_cls\").click(function() {\n                    $(this).parents('td').find('.loading-ajax').show();\n                    var shiping_setting_post = jQuery(this).val();\n                    var shiping_setting = $(\"input[name='sms_shiping_setting']:checked\").val();\n                    var type = 'shiping';\n                    var form_key = jQuery(\"#form_key\").val();\n                    var file_url = jQuery(\"#ajaxcontentUrl\").val();\n                    $.ajax({\n                        type: \"POST\",\n                        async: false,\n                        url: file_url,\n                        data: {\n                            \"form_key\": form_key,\n                            \"shiping_setting\": shiping_setting,\n                            \"shiping_setting_post\": shiping_setting_post,\n                            \"type\": type\n                        },\n                        beforeSend: function() {\n                            $('#ajax-busy').show();\n                        },\n                        success: function(msg) {\n                            $('#ajax-busy').hide();\n                            $('.loading-ajax').hide();\n                            if (shiping_setting == 1) {\n                                jQuery(\".hideShiping\").show();\n                            } else {\n                                jQuery(\".hideShiping\").hide();\n                            }\n                            alert(msg);\n                        }\n                    });\n\n                });\n\n                $(\".sms_campaign_setting_cls\").click(function() {\n                    $(this).parents('td').find('.loading-ajax').show();\n                    var campaign_setting_post = jQuery(this).val();\n                    var campaign_setting = $(\"input[name='sms_campaign_setting']:checked\").val();\n                    var type = 'campaign';\n                    var form_key = jQuery(\"#form_key\").val();\n                    var file_url = jQuery(\"#ajaxcontentUrl\").val();\n                    $.ajax({\n                        type: \"POST\",\n                        async: false,\n                        url: file_url,\n                        data: {\n                            \"form_key\": form_key,\n                            \"campaign_setting\": campaign_setting,\n                            \"campaign_setting_post\": campaign_setting_post,\n                            \"type\": type\n                        },\n                        beforeSend: function() {\n                            $('#ajax-busy').show();\n                        },\n                        success: function(msg) {\n                            $('#ajax-busy').hide();\n                            $('.loading-ajax').hide();\n                            if (campaign_setting == 1) {\n                                jQuery(\".hideCampaign\").show();\n                            } else {\n                                jQuery(\".hideCampaign\").hide();\n                            }\n                            alert(msg);\n                        }\n                    });\n\n                });\n\n                if ($('input:radio[name=sms_order_setting]:checked').val() == 0) {\n                    $('.hideOrder').hide();\n                } else {\n                    $('.hideOrder').show();\n                }\n\n                $(\".Sms_Choice\").click(function() {\n                    if (jQuery(this).val() == 1) {\n                        jQuery(\".multiplechoice\").hide();\n                        jQuery(\".singlechoice\").show();\n                    } else {\n                        jQuery(\".multiplechoice\").show();\n                        jQuery(\".singlechoice\").hide();\n                    }\n                });\n\n                //date picker function\n                $('.datepickercls').datepicker({\n                     dateFormat: 'yy-mm-dd'\n                });\n\n                jQuery('input:radio[name=Sms_Choice]').click(function() {\n                    var getVal = jQuery(this).val();\n                    if (getVal == 0) {\n                        jQuery(\".multiplechoice\").show();\n                        jQuery(\".singlechoice\").hide();\n                        jQuery(\".sib_datepicker\").hide();\n\n                    } else if (getVal == 2) {\n                        jQuery(\".multiplechoice\").show();\n                        jQuery(\".singlechoice\").hide();\n                        jQuery(\".sib_datepicker\").show();\n                    } else {\n                        jQuery(\".singlechoice\").show();\n                        jQuery(\".multiplechoice\").hide();\n                        jQuery(\".sib_datepicker\").hide();\n                    }\n                });\n\n                jQuery('#r1_Sms_Choice').attr('checked', true);\n                if ($('input:radio[name=sms_credit]:checked').val() == 0)\n                    jQuery(\".hideCredit\").hide();\n                else\n                    jQuery(\".hideCredit\").show();\n\n\n                $(\".sms_credit_cls\").click(function() {\n                    $(this).parents('td').find('.loading-ajax').show();\n                    var sms_credit_post = jQuery(this).val();\n                    var sms_credit = $('input:radio[name=sms_credit]:checked').val();\n                    var type = 'sms_credit';\n                    var form_key = jQuery(\"#form_key\").val();\n                    var file_url = jQuery(\"#ajaxcontentUrl\").val();\n                    $.ajax({\n                        type: \"POST\",\n                        async: false,\n                        url: file_url,\n                        data: {\n                            \"form_key\":form_key,\n                            \"sms_credit_post\":sms_credit_post,\n                            \"sms_credit\": sms_credit,\n                            \"type\": type\n                        },\n                        beforeSend: function() {\n                            $('#ajax-busy').show();\n                        },\n                        success: function(msg) {\n                            $('#ajax-busy').hide();\n                            $('.loading-ajax').hide();\n                            if (sms_credit == 1) {\n                                jQuery(\".hideCredit\").show();\n                            } else {\n                                jQuery(\".hideCredit\").hide();\n                            }\n                            alert(msg);\n                        }\n                    });\n\n                });\n\n                if ($('input:radio[name=sms_shiping_setting]:checked').val() == 0) {\n                    $('.hideShiping').hide();\n                } else {\n                    $('.hideShiping').show();\n                }\n\n                if ($('input:radio[name=sms_campaign_setting]:checked').val() == 0) {\n                    $('.hideCampaign').hide();\n                } else {\n                    $('.hideCampaign').show();\n                }\n                \n                            $(\"#selectSmsList\").multiselect({\n                                header: false,\n                                checkall: false\n                            });\n\n                $(\"#tabs li\").click(function() {\n                    //  First remove class \"active\" from currently active tab\n                    $(\"#tabs li\").removeClass('active');\n\n                    //  Now add class \"active\" to the selected/clicked tab\n                    $(this).addClass(\"active\");\n\n                    //  Hide all tab content\n                    $(\".tab_content\").hide();\n\n                    //  Here we get the href value of the selected tab\n                    var selected_tab = $(this).find(\"a\").attr(\"href\");\n\n                    //  Show the selected tab content\n                    $(selected_tab).fadeIn();\n\n                    //  At the end, we add return false so that the click on the link is not executed\n                    return false;\n                });\n\n            }\n\n           jQuery(\"#display_list\").multiselect({\n                 header: false,\n                 checkall: false\n            });\n\n\n\n            $(\".ord_track_cls_btn\").click(function() {\n                $(this).parents('td').find('.loading-ajax').show();\n                var ord_track_btn = jQuery(this).val();\n                var ord_track_status = $(\"input[name='ord_track_status']:checked\").val();\n                var import_order_data = $(\"input[name='import_order_data']:checked\").val();\n                var form_key = jQuery(\"#form_key\").val();\n                var file_url = jQuery(\"#ajaxcontentUrl\").val();\n                $.ajax({\n                    type: \"POST\",\n                    async: false,\n                    url: file_url,\n                    data: {\n                        \"form_key\": form_key,\n                        \"ord_track_status\": ord_track_status,\n                        \"ord_track_btn\": ord_track_btn,\n                        \"import_order_data\": import_order_data\n                    },\n                    beforeSend: function() {\n                        $('#ajax-busy').show();\n                    },\n                    success: function(msg) {\n\n                        $('#ajax-busy').hide();\n                        $('.loading-ajax').hide();\n                        alert(msg);\n                    }\n                });\n            });\n\n            $(\".sib_track_cls_btn\").click(function() {\n                $(this).parents('td').find('.loading-ajax').show();\n                var sib_tracking = jQuery(this).val();\n                var sib_track_status = $(\"input[name='sib_track_status']:checked\").val();\n                var sib_abdcart_status = $(\"input[name='sib_abdcart_status']:checked\").val();\n                var form_key = jQuery(\"#form_key\").val();\n                var file_url = jQuery(\"#ajaxcontentUrl\").val();\n                $.ajax({\n                    type: \"POST\",\n                    url: file_url,\n                    data: {\n                        \"form_key\": form_key,\n                        \"sib_track_status\": sib_track_status,\n                        \"sib_abdcart_status\":sib_abdcart_status,\n                        \"sib_tracking\": sib_tracking\n                    },\n                    beforeSend: function() {\n                        $('#ajax-busy').show();\n                    },\n                    success: function(msg) {\n\n                        $('#ajax-busy').hide();\n                        $('.loading-ajax').hide();\n                        alert(msg);\n                    }\n                });\n            });\n\n            $(\".sib_contact_sync_cls_btn\").click(function() {\n  //              $(this).prop('disabled', true);\n                $(this).parents('td').find('.loading-ajax').show();\n                var sib_sync_list = $(\"#sib_contact_sync_list\").val();\n                var sib_sync_status = $(\"input[name='sib_contact_sync_status']:checked\").val();\n                var form_key = jQuery(\"#form_key\").val();\n                var file_url = jQuery(\"#ajaxcontentUrl\").val();\n                $.ajax({\n                    type: \"POST\",\n                    url: file_url,\n                    data: {\n                        \"form_key\": form_key,\n                        \"sib_contact_sync_list\": sib_sync_list,\n                        \"sib_contact_sync_status\": sib_sync_status,\n                        \"sync_cron_activate\": true\n                    },\n                    success: function(msg) {\n                        $('.loading-ajax').hide();\n//                        $(\".sib_contact_sync_cls_btn\").removeAttr(\"disabled\");\n                        alert(msg);\n                    }\n                });\n            });\n\n            $(\".smtptestclickcls\").click(function() {\n                $(this).parents('td').find('.loading-ajax').show();\n                var smtp_post = jQuery(this).val();\n                var smtps_tatus = $(\"input[name='smtpservices']:checked\").val();\n                var form_key = jQuery(\"#form_key\").val();\n                var file_url = jQuery(\"#ajaxcontentUrl\").val();\n                var smtp_pass = jQuery(\"#smtp_password\").val();\n                var pass_error = jQuery('#pass_field').val();\n                var smtptest;\n\n                if (smtps_tatus == 1 && smtp_pass == '') {\n                    alert(pass_error);\n                    document.getElementById('smtp_password').focus();\n                    $('.loading-ajax').hide();\n                    return false;\n                }\n                if (smtptest == 0) {\n                    $('#smtptest').hide();\n                }\n                if (smtptest == 1) {\n                    $('#smtptest').show();\n                }\n                $.ajax({\n                    type: \"POST\",\n                    url: file_url,\n                    data: {\n                        \"form_key\":form_key,\n                        \"smtps_tatus\": smtps_tatus,\n                        \"smtp_post\": smtp_post,\n                        \"smtp_pass\": smtp_pass\n                    },\n                    beforeSend: function() {\n                        $('#ajax-busy').show();\n                    },\n                    success: function(msg) {\n\n                        $('#ajax-busy').hide();\n                        $('.loading-ajax').hide();\n                        alert(msg);\n                    }\n                });\n            });\n\n            //select multiple list for file name\n            $(\"#oem_list\")\n                .change(function() {\n                    var str = \"\";\n                    var count = ($(\"#oem_list option:selected\").length - 1);\n                    $(\"#oem_list option:selected\").each(function(i, val) {\n\n                        str += $(this).text();\n\n                        if (i < count) {\n                            str += ',';\n                        }\n                    });\n                    $(\"#em_text_val\").val(str);\n                })\n                .change();\n\n            $('.testOrdersmssend').on('click', function() {\n                var order_send_post = jQuery(this).val();\n                var sender = $('#sender_order').val();\n                var message = $('#sender_order_message').val();\n                var number = $('#sender_order_number').val();\n                var sendererr = $('#senderfield').val();\n                var mobileerr = $('#smsfield').val();\n                var messageerr = $('#messagefield').val();\n                var form_key = jQuery(\"#form_key\").val();\n                var file_url = jQuery(\"#ajaxcontentUrl\").val();\n\n                if (sender == '') {\n                    alert(sendererr);\n                    document.getElementById('sender_order').focus();\n                    return false;\n                } else if (message == '') {\n                    alert(messageerr);\n                    document.getElementById('sender_order_message').focus();\n                    return false;\n                } else if (number == '') {\n                    alert(mobileerr);\n                    document.getElementById('sender_order_number').focus();\n                    return false;\n                }\n\n                $.ajax({\n                    type: \"POST\",\n                    url: file_url,\n                    data: {\n                        \"form_key\": form_key,\n                        \"sender\": sender,\n                        \"message\": message,\n                        \"number\": number,\n                        \"order_send_post\": order_send_post\n                    },\n                    beforeSend: function() {\n                        $('#sender_order_submit').next('.loading-ajax').css({\n                            'display': 'inline-block'\n                        });\n                        $('#ajax-busy').show();\n                    },\n                    success: function(msg) {\n                        $('#ajax-busy').hide();\n                        $('.loading-ajax').hide();\n                        alert(msg);\n                    }\n                });\n                return false;\n            });\n\n            $('.testSmsShipped').on('click', function() {\n                var shipped_send_post = $(this).val();\n                var sender = $('#sender_shipment').val();\n                var message = $('#sender_shipment_message').val();\n                var number = $('#sender_shipment_number').val();\n                var sendererr = $('#senderfield').val();\n                var mobileerr = $('#smsfield').val();\n                var messageerr = $('#messagefield').val();\n                var form_key = $(\"#form_key\").val();\n                var file_url = $(\"#ajaxcontentUrl\").val();\n\n                if (sender == '') {\n                    alert(sendererr);\n                    document.getElementById('sender_shipment').focus();\n                    return false;\n                } else if (message == '') {\n                    alert(messageerr);\n                    document.getElementById('sender_shipment_message').focus();\n                    return false;\n                } else if (number == '') {\n                    alert(mobileerr);\n                    document.getElementById('sender_shipment_number').focus();\n                    return false;\n                }\n\n                $.ajax({\n                    type: \"POST\",\n                    url: file_url,\n                    data: {\n                        \"form_key\": form_key,\n                        \"sender\": sender,\n                        \"message\": message,\n                        \"number\": number,\n                        \"shipped_send_post\": shipped_send_post\n                    },\n                    beforeSend: function() {\n                        $('#sender_shipment_submit').next('.loading-ajax').css({\n                            'display': 'inline-block'\n                        });\n                        $('#ajax-busy').show();\n                    },\n                    success: function(msg) {\n                        $('.loading-ajax').hide();\n                        $('#ajax-busy').hide();\n                        alert(msg);\n                    }\n                });\n                return false;\n            });\n\n            $('.testSmsCampaignsend').on('click', function() {\n                var campaign_test_submit = $(this).val();\n                var sender = $('#sender_campaign').val();\n                var message = $('#sender_campaign_message').val();\n                var number = $('#sender_campaign_number_test').val();\n                var sendererr = $('#senderfield').val();\n                var mobileerr = $('#smsfield').val();\n                var messageerr = $('#messagefield').val();\n                var form_key = jQuery(\"#form_key\").val();\n                var file_url = jQuery(\"#ajaxcontentUrl\").val();\n\n                if (sender == '') {\n                    alert(sendererr);\n                    document.getElementById('sender_campaign').focus();\n                    return false;\n                } else if (message == '') {\n                    alert(messageerr);\n                    document.getElementById('sender_campaign_message').focus();\n                    return false;\n                } else if (number == '') {\n                    alert(mobileerr);\n                    document.getElementById('sender_campaign_number_test').focus();\n                    return false;\n                } else {\n                    $.ajax({\n                        type: \"POST\",\n                        url: file_url,\n                        data: {\n                            \"form_key\": form_key,\n                            \"sender\": sender,\n                            \"message\": message,\n                            \"number\": number,\n                            \"campaign_test_submit\": campaign_test_submit\n                        },\n                        beforeSend: function() {\n                            $('#sender_campaign_test_submit').next('.loading-ajax').css({\n                                'display': 'inline-block'\n                            });\n                            $('#ajax-busy').show();\n                        },\n                        success: function(msg) {\n                            $('.loading-ajax').hide();\n                            $('#ajax-busy').hide();\n                            alert(msg);\n                        }\n                    });\n                }\n                return false;\n            });\n\n            $('.sender_order_save').on('click', function() {\n                var senderfield = $('#senderfield').val();\n                var messagefield = $('#messagefield').val();\n                var sender = $('#sender_order').val();\n                var message = $('#sender_order_message').val();\n                if (sender == '') {\n                    alert(senderfield);\n                    document.getElementById('sender_order').focus();\n                    return false;\n                } else if (message == '') {\n                    alert(messagefield);\n                    document.getElementById('sender_order_message').focus();\n                    return false;\n                }\n            });\n            $('.sender_shipment_save').on('click', function() {\n                var senderfield = $('#senderfield').val();\n                var messagefield = $('#messagefield').val();\n                var sender = $('#sender_shipment').val();\n                var message = $('#sender_shipment_message').val();\n                if (sender == '') {\n                    alert(senderfield);\n                    document.getElementById('sender_shipment').focus();\n                    return false;\n                } else if (message == '') {\n                    alert(messagefield);\n                    document.getElementById('sender_shipment_message').focus();\n                    return false;\n                }\n            });\n\n            $('.sender_campaign_save').on('click', function() {\n                var smsfield = $('#smsfield').val();\n                if ($('.singlechoice').is(\":visible\")) {\n                    $('.fortestsms').hide();\n                    var singlechoice = $('#singlechoice').val();\n                    if (singlechoice == '') {\n                        alert(smsfield);\n                        document.getElementById('singlechoice').focus();\n                        return false;\n                    }\n                }\n                var senderfield = $('#senderfield').val();\n                var messagefield = $('#messagefield').val();\n                var sender = $('#sender_campaign').val();\n                var message = $('#sender_campaign_message').val();\n                if (sender == '') {\n                    alert(senderfield);\n                    document.getElementById('sender_campaign').focus();\n                    return false;\n                } else if (message == '') {\n                    alert(messagefield);\n                    document.getElementById('sender_campaign_message').focus();\n                    return false;\n                }\n            });\n\n            $('.toolTip').on('mouseover mouseout', function(e) {\n                var title = $(this).attr('title');\n                var offset = $(this).offset();\n\n                if (e.type == 'mouseover') {\n                    $('body').append(\n                        '<div id=\"tipkk\" style=\"top:' +\n                        offset.top +\n                        'px; left:' +\n                        offset.left +\n                        'px; \">' + title +\n                        '</div>');\n                    var tipContentHeight = $('#tipkk')\n                        .height() + 25;\n                    $('#tipkk').css(\n                        'top',\n                        (offset.top - tipContentHeight) +\n                        'px');\n                } else if (e.type == 'mouseout') {\n                    $('#tipkk').remove();\n                }\n            });\n\n\n            /*------- Ashutosh 10Aug 2016 ------*/\n\n            if ($('input[name=status]:checked').val() == 1 && $('input#apikeys').val() != '') {\n                $('#left-part').addClass('right-opened');\n                $('#right-part').show();\n            } else {\n                $('#left-part').removeClass('right-opened');\n                $('#right-part').hide();\n            }\n\n\n            /*---- Display related tab when form submit ---*/\n\n            $('.main-tabs a').click(function(){\n                var getFullPath = window.location.href;\n                var getHash = getFullPath.split('#');\n                getDataId = $(this).attr('data-id');\n                if(getHash[1]){\n                    window.location = getHash[0]+getDataId;\n                }else{\n                    window.location = window.location.href+getDataId;\n                }\n            })\n\n            var getFullPath = window.location.href;\n            var getHash = getFullPath.split('#');\n            if(getHash[1]){\n                $('.main-tabs-content').find('.tab-pane').removeClass('active');\n                $('.main-tabs-content').find('#'+getHash[1]).addClass('active');\n                $('.main-tabs a').removeClass('active');\n                $('.main-tabs a#'+getHash[1]).addClass('active');\n                /*--- Work when found # in URL -------*/\n                $('#tabs a').click(function(){\n                    var getTabID = $(this).attr('href');\n                    $('#tabs li').removeClass('active');\n                    $(this).parent('li').addClass('active');\n                    $(\"#tab1, #tab2, #tab3\").css(\"display\",\"none\");\n                    $(getTabID).css(\"display\",\"block\");\n                    $('#tabs_content_container .tab_content').fadeOut();\n                    $('#tabs_content_container '+getTabID).fadeIn();\n                });\n           }else{\n                $('.main-tabs-content').find('#about-sendinblue').addClass('active');\n                $('.main-tabs a#about-sendinblue').addClass('active'); \n            }      \n        /*---- Ends --- Display related tab when form submit ---*/\n\n            $('input[name=status]#n').click(function() {\n                setTimeout(function() {\n                    $('#left-part').removeClass('right-opened');\n                }, 500);\n                $('#right-part').hide();\n            });\n\n            $('input[name=status]#y').click(function() {\n                setTimeout(function() {\n                    $('#left-part').addClass('right-opened');\n                }, 500);\n                $('#right-part').show();\n                $('.tableblock').show();\n            });\n\n\n            /*--- For new design tabs-------*/\n            $('.main-tabs a').click(function() {\n                var get_id = $(this).attr('data-id');\n\n                $('.main-tabs-content .tab-pane.active').removeClass('active');\n                $('.main-tabs-content ' + get_id).addClass('active');\n\n                $('.main-tabs a.active').removeClass('active');\n                $(this).addClass('active');\n\n            });\n        });\n\n    function isNormalInteger(str) {\n        return /^\\+?(0|[0-9]\\d*)$/.test(str);\n    }\n\n    function RegexEmail(email) {\n        var emailRegexStr = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$/;\n        var isvalid = emailRegexStr.test(email);\n        return isvalid;\n    }\n\n    function validate(emailerr, limiter) {\n\n        if (document.notify_sms_mail_form.notify_email.value == \"\" || RegexEmail(document.notify_sms_mail_form.notify_email.value) == false) {\n            alert(emailerr);\n            document.notify_sms_mail_form.notify_email.focus();\n            return false;\n        }\n        if (document.notify_sms_mail_form.notify_value.value <= 0 ||\n            isNormalInteger(document.notify_sms_mail_form.notify_value.value) == false) {\n            alert(limiter);\n            document.notify_sms_mail_form.notify_value.focus();\n            return false;\n        }\n\n        return (true);\n    }\n\n    // get site base url\n\n    function isInteger(val) {\n        var numberRegex = /^[+-]?\\d+(\\.\\d+)?([eE][+-]?\\d+)?$/;\n        if (numberRegex.test(val)) {\n            return true\n        }\n        return false;\n    }\n    //]]>\n});\n","Sendinblue_Sendinblue/js/jquery.multiselect.js":"/** jshint forin:true, noarg:true, noempty:true, eqeqeq:true, boss:true, undef:true, curly:true, browser:true, jquery:true */\n/*\n* jQuery MultiSelect UI Widget 1.13\n* Copyright (c) 2012 Eric Hynds\n*\n* http://www.erichynds.com/jquery/jquery-ui-multiselect-widget/\n*\n* Depends:\n* - jQuery 1.4.2+\n* - jQuery UI 1.8 widget factory\n*\n* Optional:\n* - jQuery UI effects\n* - jQuery UI position utility\n*\n* Dual licensed under the MIT and GPL licenses:\n* http://www.opensource.org/licenses/mit-license.php\n* http://www.gnu.org/licenses/gpl.html\n*\n*/\n\nrequire([\n    \"jquery\",\n    \"jquery/ui\",\n    'domReady!'\n], function($){\n    console.log(\"hello\");\n    (function($, undefined){\n    var multiselectID = 0;\n    $.widget(\"ech.multiselect\", {\n        // default options\n        options: {\n            header: true,\n            height: 175,\n            minWidth: 225,\n            classes: '',\n            checkAllText: 'Check all',\n            uncheckAllText: 'Uncheck all',\n            noneSelectedText: selectoption,\n            selectedText: '# '+selected,\n            selectedList: 0,\n            show: null,\n            hide: null,\n            autoOpen: false,\n            multiple: true,\n            position: {}\n        },\n\n        _create: function(){\n            var el = this.element.hide(),\n                o = this.options;\n\n            this.speed = $.fx.speeds._default; // default speed for effects\n            this._isOpen = false; // assume no\n\n            var\n                button = (this.button = $('<button type=\"button\"><span class=\"ui-icon ui-icon-triangle-2-n-s\"></span></button>'))\n                    .addClass('ui-multiselect ui-widget ui-state-default ui-corner-all')\n                    .addClass( o.classes )\n                    .attr({ 'title':el.attr('title'), 'aria-haspopup':true, 'tabIndex':el.attr('tabIndex') })\n                    .insertAfter( el ),\n\n                buttonlabel = (this.buttonlabel = $('<span />'))\n                    .html( o.noneSelectedText )\n                    .appendTo( button ),\n\n                menu = (this.menu = $('<div />'))\n                    .addClass('ui-multiselect-menu ui-widget ui-widget-content ui-corner-all')\n                    .addClass( o.classes )\n                    .appendTo( document.body ),\n\n                header = (this.header = $('<div />'))\n                    .addClass('ui-widget-header ui-corner-all ui-multiselect-header ui-helper-clearfix')\n                    .appendTo( menu ),\n\n                headerLinkContainer = (this.headerLinkContainer = $('<ul />'))\n                    .addClass('ui-helper-reset')\n                    .html(function(){\n                        if( o.header === true ){\n                            return '<li><a class=\"ui-multiselect-all\" href=\"#\"><span class=\"ui-icon ui-icon-check\"></span><span>' + o.checkAllText + '</span></a></li><li><a class=\"ui-multiselect-none\" href=\"#\"><span class=\"ui-icon ui-icon-closethick\"></span><span>' + o.uncheckAllText + '</span></a></li>';\n                        } else if(typeof o.header === \"string\"){\n                            return '<li>' + o.header + '</li>';\n                        } else {\n                            return '';\n                        }\n                    })\n                    .append('<li class=\"ui-multiselect-close\"><a href=\"#\" class=\"ui-multiselect-close\"><span class=\"ui-icon ui-icon-circle-close\"></span></a></li>')\n                    .appendTo( header ),\n\n                checkboxContainer = (this.checkboxContainer = $('<ul />'))\n                    .addClass('ui-multiselect-checkboxes ui-helper-reset')\n                    .appendTo( menu );\n\n            // perform event bindings\n            this._bindEvents();\n\n            // build menu\n            this.refresh( true );\n\n            // some addl. logic for single selects\n            if( !o.multiple ){\n                menu.addClass('ui-multiselect-single');\n            }\n        },\n\n        _init: function(){\n            if( this.options.header === false ){\n                this.header.hide();\n            }\n            if( !this.options.multiple ){\n                this.headerLinkContainer.find('.ui-multiselect-all, .ui-multiselect-none').hide();\n            }\n            if( this.options.autoOpen ){\n                this.open();\n            }\n            if( this.element.is(':disabled') ){\n                this.disable();\n            }\n        },\n\n        refresh: function( init ){\n            var el = this.element,\n                o = this.options,\n                menu = this.menu,\n                checkboxContainer = this.checkboxContainer,\n                optgroups = [],\n                html = \"\",\n                id = el.attr('id') || multiselectID++; // unique ID for the label & option tags\n\n            // build items\n            el.find('option').each(function( i ){\n                var $this = $(this),\n                    parent = this.parentNode,\n                    title = this.innerHTML,\n                    description = this.title,\n                    value = this.value,\n                    inputID = 'ui-multiselect-' + (this.id || id + '-option-' + i),\n                    isDisabled = this.disabled,\n                    isSelected = this.selected,\n                    labelClasses = [ 'ui-corner-all' ],\n                    liClasses = (isDisabled ? 'ui-multiselect-disabled ' : ' ') + this.className,\n                    optLabel;\n\n                // is this an optgroup?\n                if( parent.tagName === 'OPTGROUP' ){\n                    optLabel = parent.getAttribute( 'label' );\n\n                    // has this optgroup been added already?\n                    if( $.inArray(optLabel, optgroups) === -1 ){\n                        html += '<li class=\"ui-multiselect-optgroup-label ' + parent.className + '\"><a href=\"#\">' + optLabel + '</a></li>';\n                        optgroups.push( optLabel );\n                    }\n                }\n\n                if( isDisabled ){\n                    labelClasses.push( 'ui-state-disabled' );\n                }\n\n                // browsers automatically select the first option\n                // by default with single selects\n                if( isSelected && !o.multiple ){\n                    labelClasses.push( 'ui-state-active' );\n                }\n\n                html += '<li class=\"' + liClasses + '\">';\n\n                // create the label\n                html += '<label for=\"' + inputID + '\" title=\"' + description + '\" class=\"' + labelClasses.join(' ') + '\">';\n                html += '<input id=\"' + inputID + '\" name=\"multiselect_' + id + '\" type=\"' + (o.multiple ? \"checkbox\" : \"radio\") + '\" value=\"' + value + '\" title=\"' + title + '\"';\n\n                // pre-selected?\n                if( isSelected ){\n                    html += ' checked=\"checked\"';\n                    html += ' aria-selected=\"true\"';\n                }\n\n                // disabled?\n                if( isDisabled ){\n                    html += ' disabled=\"disabled\"';\n                    html += ' aria-disabled=\"true\"';\n                }\n\n                // add the title and close everything off\n                html += ' /><span>' + title + '</span></label></li>';\n            });\n\n            // insert into the DOM\n            checkboxContainer.html( html );\n\n            // cache some moar useful elements\n            this.labels = menu.find('label');\n            this.inputs = this.labels.children('input');\n\n            // set widths\n            this._setButtonWidth();\n            this._setMenuWidth();\n\n            // remember default value\n            this.button[0].defaultValue = this.update();\n\n            // broadcast refresh event; useful for widgets\n            if( !init ){\n                this._trigger('refresh');\n            }\n        },\n\n        // updates the button text. call refresh() to rebuild\n        update: function(){\n            var o = this.options,\n                $inputs = this.inputs,\n                $checked = $inputs.filter(':checked'),\n                numChecked = $checked.length,\n                value;\n\n            if( numChecked === 0 ){\n                value = o.noneSelectedText;\n            } else {\n                if($.isFunction( o.selectedText )){\n                    value = o.selectedText.call(this, numChecked, $inputs.length, $checked.get());\n                } else if( /\\d/.test(o.selectedList) && o.selectedList > 0 && numChecked <= o.selectedList){\n                    value = $checked.map(function(){ return $(this).next().html(); }).get().join(', ');\n                } else {\n                    value = o.selectedText.replace('#', numChecked).replace('#', $inputs.length);\n                }\n            }\n\n            this.buttonlabel.html( value );\n            return value;\n        },\n\n        // binds events\n        _bindEvents: function(){\n            var self = this, button = this.button;\n\n            function clickHandler(){\n                self[ self._isOpen ? 'close' : 'open' ]();\n                return false;\n            }\n\n            // webkit doesn't like it when you click on the span :(\n            button\n                .find('span')\n                .bind('click.multiselect', clickHandler);\n\n            // button events\n            button.bind({\n                click: clickHandler,\n                keypress: function( e ){\n                    switch(e.which){\n                        case 27: // esc\n                        case 38: // up\n                        case 37: // left\n                            self.close();\n                            break;\n                        case 39: // right\n                        case 40: // down\n                            self.open();\n                            break;\n                    }\n                },\n                mouseenter: function(){\n                    if( !button.hasClass('ui-state-disabled') ){\n                        $(this).addClass('ui-state-hover');\n                    }\n                },\n                mouseleave: function(){\n                    $(this).removeClass('ui-state-hover');\n                },\n                focus: function(){\n                    if( !button.hasClass('ui-state-disabled') ){\n                        $(this).addClass('ui-state-focus');\n                    }\n                },\n                blur: function(){\n                    $(this).removeClass('ui-state-focus');\n                }\n            });\n\n            // header links\n            this.header\n                .delegate('a', 'click.multiselect', function( e ){\n                    // close link\n                    if( $(this).hasClass('ui-multiselect-close') ){\n                        self.close();\n\n                    // check all / uncheck all\n                    } else {\n                        self[ $(this).hasClass('ui-multiselect-all') ? 'checkAll' : 'uncheckAll' ]();\n                    }\n\n                    e.preventDefault();\n                });\n\n            // optgroup label toggle support\n            this.menu\n                .delegate('li.ui-multiselect-optgroup-label a', 'click.multiselect', function( e ){\n                    e.preventDefault();\n\n                    var $this = $(this),\n                        $inputs = $this.parent().nextUntil('li.ui-multiselect-optgroup-label').find('input:visible:not(:disabled)'),\n                        nodes = $inputs.get(),\n                        label = $this.parent().text();\n\n                    // trigger event and bail if the return is false\n                    if( self._trigger('beforeoptgrouptoggle', e, { inputs:nodes, label:label }) === false ){\n                        return;\n                    }\n\n                    // toggle inputs\n                    self._toggleChecked(\n                        $inputs.filter(':checked').length !== $inputs.length,\n                        $inputs\n                    );\n\n                    self._trigger('optgrouptoggle', e, {\n                        inputs: nodes,\n                        label: label,\n                        checked: nodes[0].checked\n                    });\n                })\n                .delegate('label', 'mouseenter.multiselect', function(){\n                    if( !$(this).hasClass('ui-state-disabled') ){\n                        self.labels.removeClass('ui-state-hover');\n                        $(this).addClass('ui-state-hover').find('input').focus();\n                    }\n                })\n                .delegate('label', 'keydown.multiselect', function( e ){\n                    e.preventDefault();\n\n                    switch(e.which){\n                        case 9: // tab\n                        case 27: // esc\n                            self.close();\n                            break;\n                        case 38: // up\n                        case 40: // down\n                        case 37: // left\n                        case 39: // right\n                            self._traverse(e.which, this);\n                            break;\n                        case 13: // enter\n                            $(this).find('input')[0].click();\n                            break;\n                    }\n                })\n                .delegate('input[type=\"checkbox\"], input[type=\"radio\"]', 'click.multiselect', function( e ){\n                    var $this = $(this),\n                        val = this.value,\n                        checked = this.checked,\n                        tags = self.element.find('option');\n\n                    // bail if this input is disabled or the event is cancelled\n                    if( this.disabled || self._trigger('click', e, { value: val, text: this.title, checked: checked }) === false ){\n                        e.preventDefault();\n                        return;\n                    }\n\n                    // make sure the input has focus. otherwise, the esc key\n                    // won't close the menu after clicking an item.\n                    $this.focus();\n\n                    // toggle aria state\n                    $this.attr('aria-selected', checked);\n\n                    // change state on the original option tags\n                    tags.each(function(){\n                        if( this.value === val ){\n                            this.selected = checked;\n                        } else if( !self.options.multiple ){\n                            this.selected = false;\n                        }\n                    });\n\n                    // some additional single select-specific logic\n                    if( !self.options.multiple ){\n                        self.labels.removeClass('ui-state-active');\n                        $this.closest('label').toggleClass('ui-state-active', checked );\n\n                        // close menu\n                        self.close();\n                    }\n\n                    // fire change on the select box\n                    self.element.trigger(\"change\");\n\n                    // setTimeout is to fix multiselect issue #14 and #47. caused by jQuery issue #3827\n                    // http://bugs.jquery.com/ticket/3827\n                    setTimeout($.proxy(self.update, self), 10);\n                });\n\n            // close each widget when clicking on any other element/anywhere else on the page\n            $(document).bind('mousedown.multiselect', function( e ){\n                if(self._isOpen && !$.contains(self.menu[0], e.target) && !$.contains(self.button[0], e.target) && e.target !== self.button[0]){\n                    self.close();\n                }\n            });\n\n            // deal with form resets.  the problem here is that buttons aren't\n            // restored to their defaultValue prop on form reset, and the reset\n            // handler fires before the form is actually reset.  delaying it a bit\n            // gives the form inputs time to clear.\n            $(this.element[0].form).bind('reset.multiselect', function(){\n                setTimeout($.proxy(self.refresh, self), 10);\n            });\n        },\n\n        // set button width\n        _setButtonWidth: function(){\n            var width = this.element.outerWidth(),\n                o = this.options;\n\n            if( /\\d/.test(o.minWidth) && width < o.minWidth){\n                width = o.minWidth;\n            }\n\n            // set widths\n            this.button.width( width );\n        },\n\n        // set menu width\n        _setMenuWidth: function(){\n            var m = this.menu,\n                width = this.button.outerWidth()-\n                    parseInt(m.css('padding-left'),10)-\n                    parseInt(m.css('padding-right'),10)-\n                    parseInt(m.css('border-right-width'),10)-\n                    parseInt(m.css('border-left-width'),10);\n\n            m.width( width || this.button.outerWidth() );\n        },\n\n        // move up or down within the menu\n        _traverse: function( which, start ){\n            var $start = $(start),\n                moveToLast = which === 38 || which === 37,\n\n                // select the first li that isn't an optgroup label / disabled\n                $next = $start.parent()[moveToLast ? 'prevAll' : 'nextAll']('li:not(.ui-multiselect-disabled, .ui-multiselect-optgroup-label)')[ moveToLast ? 'last' : 'first']();\n\n            // if at the first/last element\n            if( !$next.length ){\n                var $container = this.menu.find('ul').last();\n\n                // move to the first/last\n                this.menu.find('label')[ moveToLast ? 'last' : 'first' ]().trigger('mouseover');\n\n                // set scroll position\n                $container.scrollTop( moveToLast ? $container.height() : 0 );\n\n            } else {\n                $next.find('label').trigger('mouseover');\n            }\n        },\n\n        // This is an internal function to toggle the checked property and\n        // other related attributes of a checkbox.\n        //\n        // The context of this function should be a checkbox; do not proxy it.\n        _toggleState: function( prop, flag ){\n            return function(){\n                if( !this.disabled ) {\n                    this[ prop ] = flag;\n                }\n\n                if( flag ){\n                    this.setAttribute('aria-selected', true);\n                } else {\n                    this.removeAttribute('aria-selected');\n                }\n            };\n        },\n\n        _toggleChecked: function( flag, group ){\n            var $inputs = (group && group.length) ?  group : this.inputs,\n                self = this;\n\n            // toggle state on inputs\n            $inputs.each(this._toggleState('checked', flag));\n\n            // give the first input focus\n            $inputs.eq(0).focus();\n\n            // update button text\n            this.update();\n\n            // gather an array of the values that actually changed\n            var values = $inputs.map(function(){\n                return this.value;\n            }).get();\n\n            // toggle state on original option tags\n            this.element\n                .find('option')\n                .each(function(){\n                    if( !this.disabled && $.inArray(this.value, values) > -1 ){\n                        self._toggleState('selected', flag).call( this );\n                    }\n                });\n\n            // trigger the change event on the select\n            if( $inputs.length ) {\n                this.element.trigger(\"change\");\n            }\n        },\n\n        _toggleDisabled: function( flag ){\n            this.button\n                .attr({ 'disabled':flag, 'aria-disabled':flag })[ flag ? 'addClass' : 'removeClass' ]('ui-state-disabled');\n\n            var inputs = this.menu.find('input');\n            var key = \"ech-multiselect-disabled\";\n\n            if(flag) {\n                // remember which elements this widget disabled (not pre-disabled)\n                // elements, so that they can be restored if the widget is re-enabled.\n                inputs = inputs.filter(':enabled')\n                    .data(key, true)\n            } else {\n                inputs = inputs.filter(function() {\n                    return $.data(this, key) === true;\n                }).removeData(key);\n            }\n\n            inputs\n                .attr({ 'disabled':flag, 'arial-disabled':flag })\n                .parent()[ flag ? 'addClass' : 'removeClass' ]('ui-state-disabled');\n\n            this.element\n                .attr({ 'disabled':flag, 'aria-disabled':flag });\n        },\n\n        // open the menu\n        open: function( e ){\n            var self = this,\n                button = this.button,\n                menu = this.menu,\n                speed = this.speed,\n                o = this.options,\n                args = [];\n\n            // bail if the multiselectopen event returns false, this widget is disabled, or is already open\n            if( this._trigger('beforeopen') === false || button.hasClass('ui-state-disabled') || this._isOpen ){\n                return;\n            }\n\n            var $container = menu.find('ul').last(),\n                effect = o.show,\n                pos = button.offset();\n\n            // figure out opening effects/speeds\n            if( $.isArray(o.show) ){\n                effect = o.show[0];\n                speed = o.show[1] || self.speed;\n            }\n\n            // if there's an effect, assume jQuery UI is in use\n            // build the arguments to pass to show()\n            if( effect ) {\n          args = [ effect, speed ];\n            }\n\n            // set the scroll of the checkbox container\n            $container.scrollTop(0).height(o.height);\n\n            // position and show menu\n            if( $.ui.position && !$.isEmptyObject(o.position) ){\n                o.position.of = o.position.of || button;\n\n                menu\n                    .show()\n                    .position( o.position )\n                    .hide();\n\n            // if position utility is not available...\n            } else {\n                menu.css({\n                    top: pos.top + button.outerHeight(),\n                    left: pos.left\n                });\n            }\n\n            // show the menu, maybe with a speed/effect combo\n            $.fn.show.apply(menu, args);\n\n            // select the first option\n            // triggering both mouseover and mouseover because 1.4.2+ has a bug where triggering mouseover\n            // will actually trigger mouseenter.  the mouseenter trigger is there for when it's eventually fixed\n            this.labels.eq(0).trigger('mouseover').trigger('mouseenter').find('input').trigger('focus');\n\n            button.addClass('ui-state-active');\n            this._isOpen = true;\n            this._trigger('open');\n        },\n\n        // close the menu\n        close: function(){\n            if(this._trigger('beforeclose') === false){\n                return;\n            }\n\n            var o = this.options,\n                effect = o.hide,\n                speed = this.speed,\n                args = [];\n\n            // figure out opening effects/speeds\n            if( $.isArray(o.hide) ){\n                effect = o.hide[0];\n                speed = o.hide[1] || this.speed;\n            }\n\n        if( effect ) {\n          args = [ effect, speed ];\n        }\n\n        $.fn.hide.apply(this.menu, args);\n            this.button.removeClass('ui-state-active').trigger('blur').trigger('mouseleave');\n            this._isOpen = false;\n            this._trigger('close');\n        },\n\n        enable: function(){\n            this._toggleDisabled(false);\n        },\n\n        disable: function(){\n            this._toggleDisabled(true);\n        },\n\n        checkAll: function( e ){\n            this._toggleChecked(true);\n            this._trigger('checkAll');\n        },\n\n        uncheckAll: function(){\n            this._toggleChecked(false);\n            this._trigger('uncheckAll');\n        },\n\n        getChecked: function(){\n            return this.menu.find('input').filter(':checked');\n        },\n\n        destroy: function(){\n            // remove classes + data\n            $.Widget.prototype.destroy.call( this );\n\n            this.button.remove();\n            this.menu.remove();\n            this.element.show();\n\n            return this;\n        },\n\n        isOpen: function(){\n            return this._isOpen;\n        },\n\n        widget: function(){\n            return this.menu;\n        },\n\n        getButton: function(){\n          return this.button;\n      },\n\n        // react to option changes after initialization\n        _setOption: function( key, value ){\n            var menu = this.menu;\n\n            switch(key){\n                case 'header':\n                    menu.find('div.ui-multiselect-header')[ value ? 'show' : 'hide' ]();\n                    break;\n                case 'checkAllText':\n                    menu.find('a.ui-multiselect-all span').eq(-1).text(value);\n                    break;\n                case 'uncheckAllText':\n                    menu.find('a.ui-multiselect-none span').eq(-1).text(value);\n                    break;\n                case 'height':\n                    menu.find('ul').last().height( parseInt(value,10) );\n                    break;\n                case 'minWidth':\n                    this.options[ key ] = parseInt(value,10);\n                    this._setButtonWidth();\n                    this._setMenuWidth();\n                    break;\n                case 'selectedText':\n                case 'selectedList':\n                case 'noneSelectedText':\n                    this.options[key] = value; // these all needs to update immediately for the update() call\n                    this.update();\n                    break;\n                case 'classes':\n                    menu.add(this.button).removeClass(this.options.classes).addClass(value);\n                    break;\n                case 'multiple':\n                    menu.toggleClass('ui-multiselect-single', !value);\n                    this.options.multiple = value;\n                    this.element[0].multiple = value;\n                    this.refresh();\n            }\n\n            $.Widget.prototype._setOption.apply( this, arguments );\n        }\n    });\n})(jQuery)\n});\n","Sendinblue_Sendinblue/js/jquery.min.js":"/*! jQuery v2.2.0 | (c) jQuery Foundation | jquery.org/license */\n!function(a,b){\"object\"==typeof module&&\"object\"==typeof module.exports?module.exports=a.document?b(a,!0):function(a){if(!a.document)throw new Error(\"jQuery requires a window with a document\");return b(a)}:b(a)}(\"undefined\"!=typeof window?window:this,function(a,b){var c=[],d=a.document,e=c.slice,f=c.concat,g=c.push,h=c.indexOf,i={},j=i.toString,k=i.hasOwnProperty,l={},m=\"2.2.0\",n=function(a,b){return new n.fn.init(a,b)},o=/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g,p=/^-ms-/,q=/-([\\da-z])/gi,r=function(a,b){return b.toUpperCase()};n.fn=n.prototype={jquery:m,constructor:n,selector:\"\",length:0,toArray:function(){return e.call(this)},get:function(a){return null!=a?0>a?this[a+this.length]:this[a]:e.call(this)},pushStack:function(a){var b=n.merge(this.constructor(),a);return b.prevObject=this,b.context=this.context,b},each:function(a){return n.each(this,a)},map:function(a){return this.pushStack(n.map(this,function(b,c){return a.call(b,c,b)}))},slice:function(){return this.pushStack(e.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(a){var b=this.length,c=+a+(0>a?b:0);return this.pushStack(c>=0&&b>c?[this[c]]:[])},end:function(){return this.prevObject||this.constructor()},push:g,sort:c.sort,splice:c.splice},n.extend=n.fn.extend=function(){var a,b,c,d,e,f,g=arguments[0]||{},h=1,i=arguments.length,j=!1;for(\"boolean\"==typeof g&&(j=g,g=arguments[h]||{},h++),\"object\"==typeof g||n.isFunction(g)||(g={}),h===i&&(g=this,h--);i>h;h++)if(null!=(a=arguments[h]))for(b in a)c=g[b],d=a[b],g!==d&&(j&&d&&(n.isPlainObject(d)||(e=n.isArray(d)))?(e?(e=!1,f=c&&n.isArray(c)?c:[]):f=c&&n.isPlainObject(c)?c:{},g[b]=n.extend(j,f,d)):void 0!==d&&(g[b]=d));return g},n.extend({expando:\"jQuery\"+(m+Math.random()).replace(/\\D/g,\"\"),isReady:!0,error:function(a){throw new Error(a)},noop:function(){},isFunction:function(a){return\"function\"===n.type(a)},isArray:Array.isArray,isWindow:function(a){return null!=a&&a===a.window},isNumeric:function(a){var b=a&&a.toString();return!n.isArray(a)&&b-parseFloat(b)+1>=0},isPlainObject:function(a){return\"object\"!==n.type(a)||a.nodeType||n.isWindow(a)?!1:a.constructor&&!k.call(a.constructor.prototype,\"isPrototypeOf\")?!1:!0},isEmptyObject:function(a){var b;for(b in a)return!1;return!0},type:function(a){return null==a?a+\"\":\"object\"==typeof a||\"function\"==typeof a?i[j.call(a)]||\"object\":typeof a},globalEval:function(a){var b,c=eval;a=n.trim(a),a&&(1===a.indexOf(\"use strict\")?(b=d.createElement(\"script\"),b.text=a,d.head.appendChild(b).parentNode.removeChild(b)):c(a))},camelCase:function(a){return a.replace(p,\"ms-\").replace(q,r)},nodeName:function(a,b){return a.nodeName&&a.nodeName.toLowerCase()===b.toLowerCase()},each:function(a,b){var c,d=0;if(s(a)){for(c=a.length;c>d;d++)if(b.call(a[d],d,a[d])===!1)break}else for(d in a)if(b.call(a[d],d,a[d])===!1)break;return a},trim:function(a){return null==a?\"\":(a+\"\").replace(o,\"\")},makeArray:function(a,b){var c=b||[];return null!=a&&(s(Object(a))?n.merge(c,\"string\"==typeof a?[a]:a):g.call(c,a)),c},inArray:function(a,b,c){return null==b?-1:h.call(b,a,c)},merge:function(a,b){for(var c=+b.length,d=0,e=a.length;c>d;d++)a[e++]=b[d];return a.length=e,a},grep:function(a,b,c){for(var d,e=[],f=0,g=a.length,h=!c;g>f;f++)d=!b(a[f],f),d!==h&&e.push(a[f]);return e},map:function(a,b,c){var d,e,g=0,h=[];if(s(a))for(d=a.length;d>g;g++)e=b(a[g],g,c),null!=e&&h.push(e);else for(g in a)e=b(a[g],g,c),null!=e&&h.push(e);return f.apply([],h)},guid:1,proxy:function(a,b){var c,d,f;return\"string\"==typeof b&&(c=a[b],b=a,a=c),n.isFunction(a)?(d=e.call(arguments,2),f=function(){return a.apply(b||this,d.concat(e.call(arguments)))},f.guid=a.guid=a.guid||n.guid++,f):void 0},now:Date.now,support:l}),\"function\"==typeof Symbol&&(n.fn[Symbol.iterator]=c[Symbol.iterator]),n.each(\"Boolean Number String Function Array Date RegExp Object Error Symbol\".split(\" \"),function(a,b){i[\"[object \"+b+\"]\"]=b.toLowerCase()});function s(a){var b=!!a&&\"length\"in a&&a.length,c=n.type(a);return\"function\"===c||n.isWindow(a)?!1:\"array\"===c||0===b||\"number\"==typeof b&&b>0&&b-1 in a}var t=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u=\"sizzle\"+1*new Date,v=a.document,w=0,x=0,y=ga(),z=ga(),A=ga(),B=function(a,b){return a===b&&(l=!0),0},C=1<<31,D={}.hasOwnProperty,E=[],F=E.pop,G=E.push,H=E.push,I=E.slice,J=function(a,b){for(var c=0,d=a.length;d>c;c++)if(a[c]===b)return c;return-1},K=\"checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped\",L=\"[\\\\x20\\\\t\\\\r\\\\n\\\\f]\",M=\"(?:\\\\\\\\.|[\\\\w-]|[^\\\\x00-\\\\xa0])+\",N=\"\\\\[\"+L+\"*(\"+M+\")(?:\"+L+\"*([*^$|!~]?=)\"+L+\"*(?:'((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\"|(\"+M+\"))|)\"+L+\"*\\\\]\",O=\":(\"+M+\")(?:\\\\((('((?:\\\\\\\\.|[^\\\\\\\\'])*)'|\\\"((?:\\\\\\\\.|[^\\\\\\\\\\\"])*)\\\")|((?:\\\\\\\\.|[^\\\\\\\\()[\\\\]]|\"+N+\")*)|.*)\\\\)|)\",P=new RegExp(L+\"+\",\"g\"),Q=new RegExp(\"^\"+L+\"+|((?:^|[^\\\\\\\\])(?:\\\\\\\\.)*)\"+L+\"+$\",\"g\"),R=new RegExp(\"^\"+L+\"*,\"+L+\"*\"),S=new RegExp(\"^\"+L+\"*([>+~]|\"+L+\")\"+L+\"*\"),T=new RegExp(\"=\"+L+\"*([^\\\\]'\\\"]*?)\"+L+\"*\\\\]\",\"g\"),U=new RegExp(O),V=new RegExp(\"^\"+M+\"$\"),W={ID:new RegExp(\"^#(\"+M+\")\"),CLASS:new RegExp(\"^\\\\.(\"+M+\")\"),TAG:new RegExp(\"^(\"+M+\"|[*])\"),ATTR:new RegExp(\"^\"+N),PSEUDO:new RegExp(\"^\"+O),CHILD:new RegExp(\"^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\\\(\"+L+\"*(even|odd|(([+-]|)(\\\\d*)n|)\"+L+\"*(?:([+-]|)\"+L+\"*(\\\\d+)|))\"+L+\"*\\\\)|)\",\"i\"),bool:new RegExp(\"^(?:\"+K+\")$\",\"i\"),needsContext:new RegExp(\"^\"+L+\"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\\\(\"+L+\"*((?:-\\\\d)?\\\\d*)\"+L+\"*\\\\)|)(?=[^-]|$)\",\"i\")},X=/^(?:input|select|textarea|button)$/i,Y=/^h\\d$/i,Z=/^[^{]+\\{\\s*\\[native \\w/,$=/^(?:#([\\w-]+)|(\\w+)|\\.([\\w-]+))$/,_=/[+~]/,aa=/'|\\\\/g,ba=new RegExp(\"\\\\\\\\([\\\\da-f]{1,6}\"+L+\"?|(\"+L+\")|.)\",\"ig\"),ca=function(a,b,c){var d=\"0x\"+b-65536;return d!==d||c?b:0>d?String.fromCharCode(d+65536):String.fromCharCode(d>>10|55296,1023&d|56320)},da=function(){m()};try{H.apply(E=I.call(v.childNodes),v.childNodes),E[v.childNodes.length].nodeType}catch(ea){H={apply:E.length?function(a,b){G.apply(a,I.call(b))}:function(a,b){var c=a.length,d=0;while(a[c++]=b[d++]);a.length=c-1}}}function fa(a,b,d,e){var f,h,j,k,l,o,r,s,w=b&&b.ownerDocument,x=b?b.nodeType:9;if(d=d||[],\"string\"!=typeof a||!a||1!==x&&9!==x&&11!==x)return d;if(!e&&((b?b.ownerDocument||b:v)!==n&&m(b),b=b||n,p)){if(11!==x&&(o=$.exec(a)))if(f=o[1]){if(9===x){if(!(j=b.getElementById(f)))return d;if(j.id===f)return d.push(j),d}else if(w&&(j=w.getElementById(f))&&t(b,j)&&j.id===f)return d.push(j),d}else{if(o[2])return H.apply(d,b.getElementsByTagName(a)),d;if((f=o[3])&&c.getElementsByClassName&&b.getElementsByClassName)return H.apply(d,b.getElementsByClassName(f)),d}if(c.qsa&&!A[a+\" \"]&&(!q||!q.test(a))){if(1!==x)w=b,s=a;else if(\"object\"!==b.nodeName.toLowerCase()){(k=b.getAttribute(\"id\"))?k=k.replace(aa,\"\\\\$&\"):b.setAttribute(\"id\",k=u),r=g(a),h=r.length,l=V.test(k)?\"#\"+k:\"[id='\"+k+\"']\";while(h--)r[h]=l+\" \"+qa(r[h]);s=r.join(\",\"),w=_.test(a)&&oa(b.parentNode)||b}if(s)try{return H.apply(d,w.querySelectorAll(s)),d}catch(y){}finally{k===u&&b.removeAttribute(\"id\")}}}return i(a.replace(Q,\"$1\"),b,d,e)}function ga(){var a=[];function b(c,e){return a.push(c+\" \")>d.cacheLength&&delete b[a.shift()],b[c+\" \"]=e}return b}function ha(a){return a[u]=!0,a}function ia(a){var b=n.createElement(\"div\");try{return!!a(b)}catch(c){return!1}finally{b.parentNode&&b.parentNode.removeChild(b),b=null}}function ja(a,b){var c=a.split(\"|\"),e=c.length;while(e--)d.attrHandle[c[e]]=b}function ka(a,b){var c=b&&a,d=c&&1===a.nodeType&&1===b.nodeType&&(~b.sourceIndex||C)-(~a.sourceIndex||C);if(d)return d;if(c)while(c=c.nextSibling)if(c===b)return-1;return a?1:-1}function la(a){return function(b){var c=b.nodeName.toLowerCase();return\"input\"===c&&b.type===a}}function ma(a){return function(b){var c=b.nodeName.toLowerCase();return(\"input\"===c||\"button\"===c)&&b.type===a}}function na(a){return ha(function(b){return b=+b,ha(function(c,d){var e,f=a([],c.length,b),g=f.length;while(g--)c[e=f[g]]&&(c[e]=!(d[e]=c[e]))})})}function oa(a){return a&&\"undefined\"!=typeof a.getElementsByTagName&&a}c=fa.support={},f=fa.isXML=function(a){var b=a&&(a.ownerDocument||a).documentElement;return b?\"HTML\"!==b.nodeName:!1},m=fa.setDocument=function(a){var b,e,g=a?a.ownerDocument||a:v;return g!==n&&9===g.nodeType&&g.documentElement?(n=g,o=n.documentElement,p=!f(n),(e=n.defaultView)&&e.top!==e&&(e.addEventListener?e.addEventListener(\"unload\",da,!1):e.attachEvent&&e.attachEvent(\"onunload\",da)),c.attributes=ia(function(a){return a.className=\"i\",!a.getAttribute(\"className\")}),c.getElementsByTagName=ia(function(a){return a.appendChild(n.createComment(\"\")),!a.getElementsByTagName(\"*\").length}),c.getElementsByClassName=Z.test(n.getElementsByClassName),c.getById=ia(function(a){return o.appendChild(a).id=u,!n.getElementsByName||!n.getElementsByName(u).length}),c.getById?(d.find.ID=function(a,b){if(\"undefined\"!=typeof b.getElementById&&p){var c=b.getElementById(a);return c?[c]:[]}},d.filter.ID=function(a){var b=a.replace(ba,ca);return function(a){return a.getAttribute(\"id\")===b}}):(delete d.find.ID,d.filter.ID=function(a){var b=a.replace(ba,ca);return function(a){var c=\"undefined\"!=typeof a.getAttributeNode&&a.getAttributeNode(\"id\");return c&&c.value===b}}),d.find.TAG=c.getElementsByTagName?function(a,b){return\"undefined\"!=typeof b.getElementsByTagName?b.getElementsByTagName(a):c.qsa?b.querySelectorAll(a):void 0}:function(a,b){var c,d=[],e=0,f=b.getElementsByTagName(a);if(\"*\"===a){while(c=f[e++])1===c.nodeType&&d.push(c);return d}return f},d.find.CLASS=c.getElementsByClassName&&function(a,b){return\"undefined\"!=typeof b.getElementsByClassName&&p?b.getElementsByClassName(a):void 0},r=[],q=[],(c.qsa=Z.test(n.querySelectorAll))&&(ia(function(a){o.appendChild(a).innerHTML=\"<a id='\"+u+\"'></a><select id='\"+u+\"-\\r\\\\' msallowcapture=''><option selected=''></option></select>\",a.querySelectorAll(\"[msallowcapture^='']\").length&&q.push(\"[*^$]=\"+L+\"*(?:''|\\\"\\\")\"),a.querySelectorAll(\"[selected]\").length||q.push(\"\\\\[\"+L+\"*(?:value|\"+K+\")\"),a.querySelectorAll(\"[id~=\"+u+\"-]\").length||q.push(\"~=\"),a.querySelectorAll(\":checked\").length||q.push(\":checked\"),a.querySelectorAll(\"a#\"+u+\"+*\").length||q.push(\".#.+[+~]\")}),ia(function(a){var b=n.createElement(\"input\");b.setAttribute(\"type\",\"hidden\"),a.appendChild(b).setAttribute(\"name\",\"D\"),a.querySelectorAll(\"[name=d]\").length&&q.push(\"name\"+L+\"*[*^$|!~]?=\"),a.querySelectorAll(\":enabled\").length||q.push(\":enabled\",\":disabled\"),a.querySelectorAll(\"*,:x\"),q.push(\",.*:\")})),(c.matchesSelector=Z.test(s=o.matches||o.webkitMatchesSelector||o.mozMatchesSelector||o.oMatchesSelector||o.msMatchesSelector))&&ia(function(a){c.disconnectedMatch=s.call(a,\"div\"),s.call(a,\"[s!='']:x\"),r.push(\"!=\",O)}),q=q.length&&new RegExp(q.join(\"|\")),r=r.length&&new RegExp(r.join(\"|\")),b=Z.test(o.compareDocumentPosition),t=b||Z.test(o.contains)?function(a,b){var c=9===a.nodeType?a.documentElement:a,d=b&&b.parentNode;return a===d||!(!d||1!==d.nodeType||!(c.contains?c.contains(d):a.compareDocumentPosition&&16&a.compareDocumentPosition(d)))}:function(a,b){if(b)while(b=b.parentNode)if(b===a)return!0;return!1},B=b?function(a,b){if(a===b)return l=!0,0;var d=!a.compareDocumentPosition-!b.compareDocumentPosition;return d?d:(d=(a.ownerDocument||a)===(b.ownerDocument||b)?a.compareDocumentPosition(b):1,1&d||!c.sortDetached&&b.compareDocumentPosition(a)===d?a===n||a.ownerDocument===v&&t(v,a)?-1:b===n||b.ownerDocument===v&&t(v,b)?1:k?J(k,a)-J(k,b):0:4&d?-1:1)}:function(a,b){if(a===b)return l=!0,0;var c,d=0,e=a.parentNode,f=b.parentNode,g=[a],h=[b];if(!e||!f)return a===n?-1:b===n?1:e?-1:f?1:k?J(k,a)-J(k,b):0;if(e===f)return ka(a,b);c=a;while(c=c.parentNode)g.unshift(c);c=b;while(c=c.parentNode)h.unshift(c);while(g[d]===h[d])d++;return d?ka(g[d],h[d]):g[d]===v?-1:h[d]===v?1:0},n):n},fa.matches=function(a,b){return fa(a,null,null,b)},fa.matchesSelector=function(a,b){if((a.ownerDocument||a)!==n&&m(a),b=b.replace(T,\"='$1']\"),c.matchesSelector&&p&&!A[b+\" \"]&&(!r||!r.test(b))&&(!q||!q.test(b)))try{var d=s.call(a,b);if(d||c.disconnectedMatch||a.document&&11!==a.document.nodeType)return d}catch(e){}return fa(b,n,null,[a]).length>0},fa.contains=function(a,b){return(a.ownerDocument||a)!==n&&m(a),t(a,b)},fa.attr=function(a,b){(a.ownerDocument||a)!==n&&m(a);var e=d.attrHandle[b.toLowerCase()],f=e&&D.call(d.attrHandle,b.toLowerCase())?e(a,b,!p):void 0;return void 0!==f?f:c.attributes||!p?a.getAttribute(b):(f=a.getAttributeNode(b))&&f.specified?f.value:null},fa.error=function(a){throw new Error(\"Syntax error, unrecognized expression: \"+a)},fa.uniqueSort=function(a){var b,d=[],e=0,f=0;if(l=!c.detectDuplicates,k=!c.sortStable&&a.slice(0),a.sort(B),l){while(b=a[f++])b===a[f]&&(e=d.push(f));while(e--)a.splice(d[e],1)}return k=null,a},e=fa.getText=function(a){var b,c=\"\",d=0,f=a.nodeType;if(f){if(1===f||9===f||11===f){if(\"string\"==typeof a.textContent)return a.textContent;for(a=a.firstChild;a;a=a.nextSibling)c+=e(a)}else if(3===f||4===f)return a.nodeValue}else while(b=a[d++])c+=e(b);return c},d=fa.selectors={cacheLength:50,createPseudo:ha,match:W,attrHandle:{},find:{},relative:{\">\":{dir:\"parentNode\",first:!0},\" \":{dir:\"parentNode\"},\"+\":{dir:\"previousSibling\",first:!0},\"~\":{dir:\"previousSibling\"}},preFilter:{ATTR:function(a){return a[1]=a[1].replace(ba,ca),a[3]=(a[3]||a[4]||a[5]||\"\").replace(ba,ca),\"~=\"===a[2]&&(a[3]=\" \"+a[3]+\" \"),a.slice(0,4)},CHILD:function(a){return a[1]=a[1].toLowerCase(),\"nth\"===a[1].slice(0,3)?(a[3]||fa.error(a[0]),a[4]=+(a[4]?a[5]+(a[6]||1):2*(\"even\"===a[3]||\"odd\"===a[3])),a[5]=+(a[7]+a[8]||\"odd\"===a[3])):a[3]&&fa.error(a[0]),a},PSEUDO:function(a){var b,c=!a[6]&&a[2];return W.CHILD.test(a[0])?null:(a[3]?a[2]=a[4]||a[5]||\"\":c&&U.test(c)&&(b=g(c,!0))&&(b=c.indexOf(\")\",c.length-b)-c.length)&&(a[0]=a[0].slice(0,b),a[2]=c.slice(0,b)),a.slice(0,3))}},filter:{TAG:function(a){var b=a.replace(ba,ca).toLowerCase();return\"*\"===a?function(){return!0}:function(a){return a.nodeName&&a.nodeName.toLowerCase()===b}},CLASS:function(a){var b=y[a+\" \"];return b||(b=new RegExp(\"(^|\"+L+\")\"+a+\"(\"+L+\"|$)\"))&&y(a,function(a){return b.test(\"string\"==typeof a.className&&a.className||\"undefined\"!=typeof a.getAttribute&&a.getAttribute(\"class\")||\"\")})},ATTR:function(a,b,c){return function(d){var e=fa.attr(d,a);return null==e?\"!=\"===b:b?(e+=\"\",\"=\"===b?e===c:\"!=\"===b?e!==c:\"^=\"===b?c&&0===e.indexOf(c):\"*=\"===b?c&&e.indexOf(c)>-1:\"$=\"===b?c&&e.slice(-c.length)===c:\"~=\"===b?(\" \"+e.replace(P,\" \")+\" \").indexOf(c)>-1:\"|=\"===b?e===c||e.slice(0,c.length+1)===c+\"-\":!1):!0}},CHILD:function(a,b,c,d,e){var f=\"nth\"!==a.slice(0,3),g=\"last\"!==a.slice(-4),h=\"of-type\"===b;return 1===d&&0===e?function(a){return!!a.parentNode}:function(b,c,i){var j,k,l,m,n,o,p=f!==g?\"nextSibling\":\"previousSibling\",q=b.parentNode,r=h&&b.nodeName.toLowerCase(),s=!i&&!h,t=!1;if(q){if(f){while(p){m=b;while(m=m[p])if(h?m.nodeName.toLowerCase()===r:1===m.nodeType)return!1;o=p=\"only\"===a&&!o&&\"nextSibling\"}return!0}if(o=[g?q.firstChild:q.lastChild],g&&s){m=q,l=m[u]||(m[u]={}),k=l[m.uniqueID]||(l[m.uniqueID]={}),j=k[a]||[],n=j[0]===w&&j[1],t=n&&j[2],m=n&&q.childNodes[n];while(m=++n&&m&&m[p]||(t=n=0)||o.pop())if(1===m.nodeType&&++t&&m===b){k[a]=[w,n,t];break}}else if(s&&(m=b,l=m[u]||(m[u]={}),k=l[m.uniqueID]||(l[m.uniqueID]={}),j=k[a]||[],n=j[0]===w&&j[1],t=n),t===!1)while(m=++n&&m&&m[p]||(t=n=0)||o.pop())if((h?m.nodeName.toLowerCase()===r:1===m.nodeType)&&++t&&(s&&(l=m[u]||(m[u]={}),k=l[m.uniqueID]||(l[m.uniqueID]={}),k[a]=[w,t]),m===b))break;return t-=e,t===d||t%d===0&&t/d>=0}}},PSEUDO:function(a,b){var c,e=d.pseudos[a]||d.setFilters[a.toLowerCase()]||fa.error(\"unsupported pseudo: \"+a);return e[u]?e(b):e.length>1?(c=[a,a,\"\",b],d.setFilters.hasOwnProperty(a.toLowerCase())?ha(function(a,c){var d,f=e(a,b),g=f.length;while(g--)d=J(a,f[g]),a[d]=!(c[d]=f[g])}):function(a){return e(a,0,c)}):e}},pseudos:{not:ha(function(a){var b=[],c=[],d=h(a.replace(Q,\"$1\"));return d[u]?ha(function(a,b,c,e){var f,g=d(a,null,e,[]),h=a.length;while(h--)(f=g[h])&&(a[h]=!(b[h]=f))}):function(a,e,f){return b[0]=a,d(b,null,f,c),b[0]=null,!c.pop()}}),has:ha(function(a){return function(b){return fa(a,b).length>0}}),contains:ha(function(a){return a=a.replace(ba,ca),function(b){return(b.textContent||b.innerText||e(b)).indexOf(a)>-1}}),lang:ha(function(a){return V.test(a||\"\")||fa.error(\"unsupported lang: \"+a),a=a.replace(ba,ca).toLowerCase(),function(b){var c;do if(c=p?b.lang:b.getAttribute(\"xml:lang\")||b.getAttribute(\"lang\"))return c=c.toLowerCase(),c===a||0===c.indexOf(a+\"-\");while((b=b.parentNode)&&1===b.nodeType);return!1}}),target:function(b){var c=a.location&&a.location.hash;return c&&c.slice(1)===b.id},root:function(a){return a===o},focus:function(a){return a===n.activeElement&&(!n.hasFocus||n.hasFocus())&&!!(a.type||a.href||~a.tabIndex)},enabled:function(a){return a.disabled===!1},disabled:function(a){return a.disabled===!0},checked:function(a){var b=a.nodeName.toLowerCase();return\"input\"===b&&!!a.checked||\"option\"===b&&!!a.selected},selected:function(a){return a.parentNode&&a.parentNode.selectedIndex,a.selected===!0},empty:function(a){for(a=a.firstChild;a;a=a.nextSibling)if(a.nodeType<6)return!1;return!0},parent:function(a){return!d.pseudos.empty(a)},header:function(a){return Y.test(a.nodeName)},input:function(a){return X.test(a.nodeName)},button:function(a){var b=a.nodeName.toLowerCase();return\"input\"===b&&\"button\"===a.type||\"button\"===b},text:function(a){var b;return\"input\"===a.nodeName.toLowerCase()&&\"text\"===a.type&&(null==(b=a.getAttribute(\"type\"))||\"text\"===b.toLowerCase())},first:na(function(){return[0]}),last:na(function(a,b){return[b-1]}),eq:na(function(a,b,c){return[0>c?c+b:c]}),even:na(function(a,b){for(var c=0;b>c;c+=2)a.push(c);return a}),odd:na(function(a,b){for(var c=1;b>c;c+=2)a.push(c);return a}),lt:na(function(a,b,c){for(var d=0>c?c+b:c;--d>=0;)a.push(d);return a}),gt:na(function(a,b,c){for(var d=0>c?c+b:c;++d<b;)a.push(d);return a})}},d.pseudos.nth=d.pseudos.eq;for(b in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})d.pseudos[b]=la(b);for(b in{submit:!0,reset:!0})d.pseudos[b]=ma(b);function pa(){}pa.prototype=d.filters=d.pseudos,d.setFilters=new pa,g=fa.tokenize=function(a,b){var c,e,f,g,h,i,j,k=z[a+\" \"];if(k)return b?0:k.slice(0);h=a,i=[],j=d.preFilter;while(h){(!c||(e=R.exec(h)))&&(e&&(h=h.slice(e[0].length)||h),i.push(f=[])),c=!1,(e=S.exec(h))&&(c=e.shift(),f.push({value:c,type:e[0].replace(Q,\" \")}),h=h.slice(c.length));for(g in d.filter)!(e=W[g].exec(h))||j[g]&&!(e=j[g](e))||(c=e.shift(),f.push({value:c,type:g,matches:e}),h=h.slice(c.length));if(!c)break}return b?h.length:h?fa.error(a):z(a,i).slice(0)};function qa(a){for(var b=0,c=a.length,d=\"\";c>b;b++)d+=a[b].value;return d}function ra(a,b,c){var d=b.dir,e=c&&\"parentNode\"===d,f=x++;return b.first?function(b,c,f){while(b=b[d])if(1===b.nodeType||e)return a(b,c,f)}:function(b,c,g){var h,i,j,k=[w,f];if(g){while(b=b[d])if((1===b.nodeType||e)&&a(b,c,g))return!0}else while(b=b[d])if(1===b.nodeType||e){if(j=b[u]||(b[u]={}),i=j[b.uniqueID]||(j[b.uniqueID]={}),(h=i[d])&&h[0]===w&&h[1]===f)return k[2]=h[2];if(i[d]=k,k[2]=a(b,c,g))return!0}}}function sa(a){return a.length>1?function(b,c,d){var e=a.length;while(e--)if(!a[e](b,c,d))return!1;return!0}:a[0]}function ta(a,b,c){for(var d=0,e=b.length;e>d;d++)fa(a,b[d],c);return c}function ua(a,b,c,d,e){for(var f,g=[],h=0,i=a.length,j=null!=b;i>h;h++)(f=a[h])&&(!c||c(f,d,e))&&(g.push(f),j&&b.push(h));return g}function va(a,b,c,d,e,f){return d&&!d[u]&&(d=va(d)),e&&!e[u]&&(e=va(e,f)),ha(function(f,g,h,i){var j,k,l,m=[],n=[],o=g.length,p=f||ta(b||\"*\",h.nodeType?[h]:h,[]),q=!a||!f&&b?p:ua(p,m,a,h,i),r=c?e||(f?a:o||d)?[]:g:q;if(c&&c(q,r,h,i),d){j=ua(r,n),d(j,[],h,i),k=j.length;while(k--)(l=j[k])&&(r[n[k]]=!(q[n[k]]=l))}if(f){if(e||a){if(e){j=[],k=r.length;while(k--)(l=r[k])&&j.push(q[k]=l);e(null,r=[],j,i)}k=r.length;while(k--)(l=r[k])&&(j=e?J(f,l):m[k])>-1&&(f[j]=!(g[j]=l))}}else r=ua(r===g?r.splice(o,r.length):r),e?e(null,g,r,i):H.apply(g,r)})}function wa(a){for(var b,c,e,f=a.length,g=d.relative[a[0].type],h=g||d.relative[\" \"],i=g?1:0,k=ra(function(a){return a===b},h,!0),l=ra(function(a){return J(b,a)>-1},h,!0),m=[function(a,c,d){var e=!g&&(d||c!==j)||((b=c).nodeType?k(a,c,d):l(a,c,d));return b=null,e}];f>i;i++)if(c=d.relative[a[i].type])m=[ra(sa(m),c)];else{if(c=d.filter[a[i].type].apply(null,a[i].matches),c[u]){for(e=++i;f>e;e++)if(d.relative[a[e].type])break;return va(i>1&&sa(m),i>1&&qa(a.slice(0,i-1).concat({value:\" \"===a[i-2].type?\"*\":\"\"})).replace(Q,\"$1\"),c,e>i&&wa(a.slice(i,e)),f>e&&wa(a=a.slice(e)),f>e&&qa(a))}m.push(c)}return sa(m)}function xa(a,b){var c=b.length>0,e=a.length>0,f=function(f,g,h,i,k){var l,o,q,r=0,s=\"0\",t=f&&[],u=[],v=j,x=f||e&&d.find.TAG(\"*\",k),y=w+=null==v?1:Math.random()||.1,z=x.length;for(k&&(j=g===n||g||k);s!==z&&null!=(l=x[s]);s++){if(e&&l){o=0,g||l.ownerDocument===n||(m(l),h=!p);while(q=a[o++])if(q(l,g||n,h)){i.push(l);break}k&&(w=y)}c&&((l=!q&&l)&&r--,f&&t.push(l))}if(r+=s,c&&s!==r){o=0;while(q=b[o++])q(t,u,g,h);if(f){if(r>0)while(s--)t[s]||u[s]||(u[s]=F.call(i));u=ua(u)}H.apply(i,u),k&&!f&&u.length>0&&r+b.length>1&&fa.uniqueSort(i)}return k&&(w=y,j=v),t};return c?ha(f):f}return h=fa.compile=function(a,b){var c,d=[],e=[],f=A[a+\" \"];if(!f){b||(b=g(a)),c=b.length;while(c--)f=wa(b[c]),f[u]?d.push(f):e.push(f);f=A(a,xa(e,d)),f.selector=a}return f},i=fa.select=function(a,b,e,f){var i,j,k,l,m,n=\"function\"==typeof a&&a,o=!f&&g(a=n.selector||a);if(e=e||[],1===o.length){if(j=o[0]=o[0].slice(0),j.length>2&&\"ID\"===(k=j[0]).type&&c.getById&&9===b.nodeType&&p&&d.relative[j[1].type]){if(b=(d.find.ID(k.matches[0].replace(ba,ca),b)||[])[0],!b)return e;n&&(b=b.parentNode),a=a.slice(j.shift().value.length)}i=W.needsContext.test(a)?0:j.length;while(i--){if(k=j[i],d.relative[l=k.type])break;if((m=d.find[l])&&(f=m(k.matches[0].replace(ba,ca),_.test(j[0].type)&&oa(b.parentNode)||b))){if(j.splice(i,1),a=f.length&&qa(j),!a)return H.apply(e,f),e;break}}}return(n||h(a,o))(f,b,!p,e,!b||_.test(a)&&oa(b.parentNode)||b),e},c.sortStable=u.split(\"\").sort(B).join(\"\")===u,c.detectDuplicates=!!l,m(),c.sortDetached=ia(function(a){return 1&a.compareDocumentPosition(n.createElement(\"div\"))}),ia(function(a){return a.innerHTML=\"<a href='#'></a>\",\"#\"===a.firstChild.getAttribute(\"href\")})||ja(\"type|href|height|width\",function(a,b,c){return c?void 0:a.getAttribute(b,\"type\"===b.toLowerCase()?1:2)}),c.attributes&&ia(function(a){return a.innerHTML=\"<input/>\",a.firstChild.setAttribute(\"value\",\"\"),\"\"===a.firstChild.getAttribute(\"value\")})||ja(\"value\",function(a,b,c){return c||\"input\"!==a.nodeName.toLowerCase()?void 0:a.defaultValue}),ia(function(a){return null==a.getAttribute(\"disabled\")})||ja(K,function(a,b,c){var d;return c?void 0:a[b]===!0?b.toLowerCase():(d=a.getAttributeNode(b))&&d.specified?d.value:null}),fa}(a);n.find=t,n.expr=t.selectors,n.expr[\":\"]=n.expr.pseudos,n.uniqueSort=n.unique=t.uniqueSort,n.text=t.getText,n.isXMLDoc=t.isXML,n.contains=t.contains;var u=function(a,b,c){var d=[],e=void 0!==c;while((a=a[b])&&9!==a.nodeType)if(1===a.nodeType){if(e&&n(a).is(c))break;d.push(a)}return d},v=function(a,b){for(var c=[];a;a=a.nextSibling)1===a.nodeType&&a!==b&&c.push(a);return c},w=n.expr.match.needsContext,x=/^<([\\w-]+)\\s*\\/?>(?:<\\/\\1>|)$/,y=/^.[^:#\\[\\.,]*$/;function z(a,b,c){if(n.isFunction(b))return n.grep(a,function(a,d){return!!b.call(a,d,a)!==c});if(b.nodeType)return n.grep(a,function(a){return a===b!==c});if(\"string\"==typeof b){if(y.test(b))return n.filter(b,a,c);b=n.filter(b,a)}return n.grep(a,function(a){return h.call(b,a)>-1!==c})}n.filter=function(a,b,c){var d=b[0];return c&&(a=\":not(\"+a+\")\"),1===b.length&&1===d.nodeType?n.find.matchesSelector(d,a)?[d]:[]:n.find.matches(a,n.grep(b,function(a){return 1===a.nodeType}))},n.fn.extend({find:function(a){var b,c=this.length,d=[],e=this;if(\"string\"!=typeof a)return this.pushStack(n(a).filter(function(){for(b=0;c>b;b++)if(n.contains(e[b],this))return!0}));for(b=0;c>b;b++)n.find(a,e[b],d);return d=this.pushStack(c>1?n.unique(d):d),d.selector=this.selector?this.selector+\" \"+a:a,d},filter:function(a){return this.pushStack(z(this,a||[],!1))},not:function(a){return this.pushStack(z(this,a||[],!0))},is:function(a){return!!z(this,\"string\"==typeof a&&w.test(a)?n(a):a||[],!1).length}});var A,B=/^(?:\\s*(<[\\w\\W]+>)[^>]*|#([\\w-]*))$/,C=n.fn.init=function(a,b,c){var e,f;if(!a)return this;if(c=c||A,\"string\"==typeof a){if(e=\"<\"===a[0]&&\">\"===a[a.length-1]&&a.length>=3?[null,a,null]:B.exec(a),!e||!e[1]&&b)return!b||b.jquery?(b||c).find(a):this.constructor(b).find(a);if(e[1]){if(b=b instanceof n?b[0]:b,n.merge(this,n.parseHTML(e[1],b&&b.nodeType?b.ownerDocument||b:d,!0)),x.test(e[1])&&n.isPlainObject(b))for(e in b)n.isFunction(this[e])?this[e](b[e]):this.attr(e,b[e]);return this}return f=d.getElementById(e[2]),f&&f.parentNode&&(this.length=1,this[0]=f),this.context=d,this.selector=a,this}return a.nodeType?(this.context=this[0]=a,this.length=1,this):n.isFunction(a)?void 0!==c.ready?c.ready(a):a(n):(void 0!==a.selector&&(this.selector=a.selector,this.context=a.context),n.makeArray(a,this))};C.prototype=n.fn,A=n(d);var D=/^(?:parents|prev(?:Until|All))/,E={children:!0,contents:!0,next:!0,prev:!0};n.fn.extend({has:function(a){var b=n(a,this),c=b.length;return this.filter(function(){for(var a=0;c>a;a++)if(n.contains(this,b[a]))return!0})},closest:function(a,b){for(var c,d=0,e=this.length,f=[],g=w.test(a)||\"string\"!=typeof a?n(a,b||this.context):0;e>d;d++)for(c=this[d];c&&c!==b;c=c.parentNode)if(c.nodeType<11&&(g?g.index(c)>-1:1===c.nodeType&&n.find.matchesSelector(c,a))){f.push(c);break}return this.pushStack(f.length>1?n.uniqueSort(f):f)},index:function(a){return a?\"string\"==typeof a?h.call(n(a),this[0]):h.call(this,a.jquery?a[0]:a):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(a,b){return this.pushStack(n.uniqueSort(n.merge(this.get(),n(a,b))))},addBack:function(a){return this.add(null==a?this.prevObject:this.prevObject.filter(a))}});function F(a,b){while((a=a[b])&&1!==a.nodeType);return a}n.each({parent:function(a){var b=a.parentNode;return b&&11!==b.nodeType?b:null},parents:function(a){return u(a,\"parentNode\")},parentsUntil:function(a,b,c){return u(a,\"parentNode\",c)},next:function(a){return F(a,\"nextSibling\")},prev:function(a){return F(a,\"previousSibling\")},nextAll:function(a){return u(a,\"nextSibling\")},prevAll:function(a){return u(a,\"previousSibling\")},nextUntil:function(a,b,c){return u(a,\"nextSibling\",c)},prevUntil:function(a,b,c){return u(a,\"previousSibling\",c)},siblings:function(a){return v((a.parentNode||{}).firstChild,a)},children:function(a){return v(a.firstChild)},contents:function(a){return a.contentDocument||n.merge([],a.childNodes)}},function(a,b){n.fn[a]=function(c,d){var e=n.map(this,b,c);return\"Until\"!==a.slice(-5)&&(d=c),d&&\"string\"==typeof d&&(e=n.filter(d,e)),this.length>1&&(E[a]||n.uniqueSort(e),D.test(a)&&e.reverse()),this.pushStack(e)}});var G=/\\S+/g;function H(a){var b={};return n.each(a.match(G)||[],function(a,c){b[c]=!0}),b}n.Callbacks=function(a){a=\"string\"==typeof a?H(a):n.extend({},a);var b,c,d,e,f=[],g=[],h=-1,i=function(){for(e=a.once,d=b=!0;g.length;h=-1){c=g.shift();while(++h<f.length)f[h].apply(c[0],c[1])===!1&&a.stopOnFalse&&(h=f.length,c=!1)}a.memory||(c=!1),b=!1,e&&(f=c?[]:\"\")},j={add:function(){return f&&(c&&!b&&(h=f.length-1,g.push(c)),function d(b){n.each(b,function(b,c){n.isFunction(c)?a.unique&&j.has(c)||f.push(c):c&&c.length&&\"string\"!==n.type(c)&&d(c)})}(arguments),c&&!b&&i()),this},remove:function(){return n.each(arguments,function(a,b){var c;while((c=n.inArray(b,f,c))>-1)f.splice(c,1),h>=c&&h--}),this},has:function(a){return a?n.inArray(a,f)>-1:f.length>0},empty:function(){return f&&(f=[]),this},disable:function(){return e=g=[],f=c=\"\",this},disabled:function(){return!f},lock:function(){return e=g=[],c||(f=c=\"\"),this},locked:function(){return!!e},fireWith:function(a,c){return e||(c=c||[],c=[a,c.slice?c.slice():c],g.push(c),b||i()),this},fire:function(){return j.fireWith(this,arguments),this},fired:function(){return!!d}};return j},n.extend({Deferred:function(a){var b=[[\"resolve\",\"done\",n.Callbacks(\"once memory\"),\"resolved\"],[\"reject\",\"fail\",n.Callbacks(\"once memory\"),\"rejected\"],[\"notify\",\"progress\",n.Callbacks(\"memory\")]],c=\"pending\",d={state:function(){return c},always:function(){return e.done(arguments).fail(arguments),this},then:function(){var a=arguments;return n.Deferred(function(c){n.each(b,function(b,f){var g=n.isFunction(a[b])&&a[b];e[f[1]](function(){var a=g&&g.apply(this,arguments);a&&n.isFunction(a.promise)?a.promise().progress(c.notify).done(c.resolve).fail(c.reject):c[f[0]+\"With\"](this===d?c.promise():this,g?[a]:arguments)})}),a=null}).promise()},promise:function(a){return null!=a?n.extend(a,d):d}},e={};return d.pipe=d.then,n.each(b,function(a,f){var g=f[2],h=f[3];d[f[1]]=g.add,h&&g.add(function(){c=h},b[1^a][2].disable,b[2][2].lock),e[f[0]]=function(){return e[f[0]+\"With\"](this===e?d:this,arguments),this},e[f[0]+\"With\"]=g.fireWith}),d.promise(e),a&&a.call(e,e),e},when:function(a){var b=0,c=e.call(arguments),d=c.length,f=1!==d||a&&n.isFunction(a.promise)?d:0,g=1===f?a:n.Deferred(),h=function(a,b,c){return function(d){b[a]=this,c[a]=arguments.length>1?e.call(arguments):d,c===i?g.notifyWith(b,c):--f||g.resolveWith(b,c)}},i,j,k;if(d>1)for(i=new Array(d),j=new Array(d),k=new Array(d);d>b;b++)c[b]&&n.isFunction(c[b].promise)?c[b].promise().progress(h(b,j,i)).done(h(b,k,c)).fail(g.reject):--f;return f||g.resolveWith(k,c),g.promise()}});var I;n.fn.ready=function(a){return n.ready.promise().done(a),this},n.extend({isReady:!1,readyWait:1,holdReady:function(a){a?n.readyWait++:n.ready(!0)},ready:function(a){(a===!0?--n.readyWait:n.isReady)||(n.isReady=!0,a!==!0&&--n.readyWait>0||(I.resolveWith(d,[n]),n.fn.triggerHandler&&(n(d).triggerHandler(\"ready\"),n(d).off(\"ready\"))))}});function J(){d.removeEventListener(\"DOMContentLoaded\",J),a.removeEventListener(\"load\",J),n.ready()}n.ready.promise=function(b){return I||(I=n.Deferred(),\"complete\"===d.readyState||\"loading\"!==d.readyState&&!d.documentElement.doScroll?a.setTimeout(n.ready):(d.addEventListener(\"DOMContentLoaded\",J),a.addEventListener(\"load\",J))),I.promise(b)},n.ready.promise();var K=function(a,b,c,d,e,f,g){var h=0,i=a.length,j=null==c;if(\"object\"===n.type(c)){e=!0;for(h in c)K(a,b,h,c[h],!0,f,g)}else if(void 0!==d&&(e=!0,n.isFunction(d)||(g=!0),j&&(g?(b.call(a,d),b=null):(j=b,b=function(a,b,c){return j.call(n(a),c)})),b))for(;i>h;h++)b(a[h],c,g?d:d.call(a[h],h,b(a[h],c)));return e?a:j?b.call(a):i?b(a[0],c):f},L=function(a){return 1===a.nodeType||9===a.nodeType||!+a.nodeType};function M(){this.expando=n.expando+M.uid++}M.uid=1,M.prototype={register:function(a,b){var c=b||{};return a.nodeType?a[this.expando]=c:Object.defineProperty(a,this.expando,{value:c,writable:!0,configurable:!0}),a[this.expando]},cache:function(a){if(!L(a))return{};var b=a[this.expando];return b||(b={},L(a)&&(a.nodeType?a[this.expando]=b:Object.defineProperty(a,this.expando,{value:b,configurable:!0}))),b},set:function(a,b,c){var d,e=this.cache(a);if(\"string\"==typeof b)e[b]=c;else for(d in b)e[d]=b[d];return e},get:function(a,b){return void 0===b?this.cache(a):a[this.expando]&&a[this.expando][b]},access:function(a,b,c){var d;return void 0===b||b&&\"string\"==typeof b&&void 0===c?(d=this.get(a,b),void 0!==d?d:this.get(a,n.camelCase(b))):(this.set(a,b,c),void 0!==c?c:b)},remove:function(a,b){var c,d,e,f=a[this.expando];if(void 0!==f){if(void 0===b)this.register(a);else{n.isArray(b)?d=b.concat(b.map(n.camelCase)):(e=n.camelCase(b),b in f?d=[b,e]:(d=e,d=d in f?[d]:d.match(G)||[])),c=d.length;while(c--)delete f[d[c]]}(void 0===b||n.isEmptyObject(f))&&(a.nodeType?a[this.expando]=void 0:delete a[this.expando])}},hasData:function(a){var b=a[this.expando];return void 0!==b&&!n.isEmptyObject(b)}};var N=new M,O=new M,P=/^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/,Q=/[A-Z]/g;function R(a,b,c){var d;if(void 0===c&&1===a.nodeType)if(d=\"data-\"+b.replace(Q,\"-$&\").toLowerCase(),c=a.getAttribute(d),\"string\"==typeof c){try{c=\"true\"===c?!0:\"false\"===c?!1:\"null\"===c?null:+c+\"\"===c?+c:P.test(c)?n.parseJSON(c):c}catch(e){}O.set(a,b,c);\n}else c=void 0;return c}n.extend({hasData:function(a){return O.hasData(a)||N.hasData(a)},data:function(a,b,c){return O.access(a,b,c)},removeData:function(a,b){O.remove(a,b)},_data:function(a,b,c){return N.access(a,b,c)},_removeData:function(a,b){N.remove(a,b)}}),n.fn.extend({data:function(a,b){var c,d,e,f=this[0],g=f&&f.attributes;if(void 0===a){if(this.length&&(e=O.get(f),1===f.nodeType&&!N.get(f,\"hasDataAttrs\"))){c=g.length;while(c--)g[c]&&(d=g[c].name,0===d.indexOf(\"data-\")&&(d=n.camelCase(d.slice(5)),R(f,d,e[d])));N.set(f,\"hasDataAttrs\",!0)}return e}return\"object\"==typeof a?this.each(function(){O.set(this,a)}):K(this,function(b){var c,d;if(f&&void 0===b){if(c=O.get(f,a)||O.get(f,a.replace(Q,\"-$&\").toLowerCase()),void 0!==c)return c;if(d=n.camelCase(a),c=O.get(f,d),void 0!==c)return c;if(c=R(f,d,void 0),void 0!==c)return c}else d=n.camelCase(a),this.each(function(){var c=O.get(this,d);O.set(this,d,b),a.indexOf(\"-\")>-1&&void 0!==c&&O.set(this,a,b)})},null,b,arguments.length>1,null,!0)},removeData:function(a){return this.each(function(){O.remove(this,a)})}}),n.extend({queue:function(a,b,c){var d;return a?(b=(b||\"fx\")+\"queue\",d=N.get(a,b),c&&(!d||n.isArray(c)?d=N.access(a,b,n.makeArray(c)):d.push(c)),d||[]):void 0},dequeue:function(a,b){b=b||\"fx\";var c=n.queue(a,b),d=c.length,e=c.shift(),f=n._queueHooks(a,b),g=function(){n.dequeue(a,b)};\"inprogress\"===e&&(e=c.shift(),d--),e&&(\"fx\"===b&&c.unshift(\"inprogress\"),delete f.stop,e.call(a,g,f)),!d&&f&&f.empty.fire()},_queueHooks:function(a,b){var c=b+\"queueHooks\";return N.get(a,c)||N.access(a,c,{empty:n.Callbacks(\"once memory\").add(function(){N.remove(a,[b+\"queue\",c])})})}}),n.fn.extend({queue:function(a,b){var c=2;return\"string\"!=typeof a&&(b=a,a=\"fx\",c--),arguments.length<c?n.queue(this[0],a):void 0===b?this:this.each(function(){var c=n.queue(this,a,b);n._queueHooks(this,a),\"fx\"===a&&\"inprogress\"!==c[0]&&n.dequeue(this,a)})},dequeue:function(a){return this.each(function(){n.dequeue(this,a)})},clearQueue:function(a){return this.queue(a||\"fx\",[])},promise:function(a,b){var c,d=1,e=n.Deferred(),f=this,g=this.length,h=function(){--d||e.resolveWith(f,[f])};\"string\"!=typeof a&&(b=a,a=void 0),a=a||\"fx\";while(g--)c=N.get(f[g],a+\"queueHooks\"),c&&c.empty&&(d++,c.empty.add(h));return h(),e.promise(b)}});var S=/[+-]?(?:\\d*\\.|)\\d+(?:[eE][+-]?\\d+|)/.source,T=new RegExp(\"^(?:([+-])=|)(\"+S+\")([a-z%]*)$\",\"i\"),U=[\"Top\",\"Right\",\"Bottom\",\"Left\"],V=function(a,b){return a=b||a,\"none\"===n.css(a,\"display\")||!n.contains(a.ownerDocument,a)};function W(a,b,c,d){var e,f=1,g=20,h=d?function(){return d.cur()}:function(){return n.css(a,b,\"\")},i=h(),j=c&&c[3]||(n.cssNumber[b]?\"\":\"px\"),k=(n.cssNumber[b]||\"px\"!==j&&+i)&&T.exec(n.css(a,b));if(k&&k[3]!==j){j=j||k[3],c=c||[],k=+i||1;do f=f||\".5\",k/=f,n.style(a,b,k+j);while(f!==(f=h()/i)&&1!==f&&--g)}return c&&(k=+k||+i||0,e=c[1]?k+(c[1]+1)*c[2]:+c[2],d&&(d.unit=j,d.start=k,d.end=e)),e}var X=/^(?:checkbox|radio)$/i,Y=/<([\\w:-]+)/,Z=/^$|\\/(?:java|ecma)script/i,$={option:[1,\"<select multiple='multiple'>\",\"</select>\"],thead:[1,\"<table>\",\"</table>\"],col:[2,\"<table><colgroup>\",\"</colgroup></table>\"],tr:[2,\"<table><tbody>\",\"</tbody></table>\"],td:[3,\"<table><tbody><tr>\",\"</tr></tbody></table>\"],_default:[0,\"\",\"\"]};$.optgroup=$.option,$.tbody=$.tfoot=$.colgroup=$.caption=$.thead,$.th=$.td;function _(a,b){var c=\"undefined\"!=typeof a.getElementsByTagName?a.getElementsByTagName(b||\"*\"):\"undefined\"!=typeof a.querySelectorAll?a.querySelectorAll(b||\"*\"):[];return void 0===b||b&&n.nodeName(a,b)?n.merge([a],c):c}function aa(a,b){for(var c=0,d=a.length;d>c;c++)N.set(a[c],\"globalEval\",!b||N.get(b[c],\"globalEval\"))}var ba=/<|&#?\\w+;/;function ca(a,b,c,d,e){for(var f,g,h,i,j,k,l=b.createDocumentFragment(),m=[],o=0,p=a.length;p>o;o++)if(f=a[o],f||0===f)if(\"object\"===n.type(f))n.merge(m,f.nodeType?[f]:f);else if(ba.test(f)){g=g||l.appendChild(b.createElement(\"div\")),h=(Y.exec(f)||[\"\",\"\"])[1].toLowerCase(),i=$[h]||$._default,g.innerHTML=i[1]+n.htmlPrefilter(f)+i[2],k=i[0];while(k--)g=g.lastChild;n.merge(m,g.childNodes),g=l.firstChild,g.textContent=\"\"}else m.push(b.createTextNode(f));l.textContent=\"\",o=0;while(f=m[o++])if(d&&n.inArray(f,d)>-1)e&&e.push(f);else if(j=n.contains(f.ownerDocument,f),g=_(l.appendChild(f),\"script\"),j&&aa(g),c){k=0;while(f=g[k++])Z.test(f.type||\"\")&&c.push(f)}return l}!function(){var a=d.createDocumentFragment(),b=a.appendChild(d.createElement(\"div\")),c=d.createElement(\"input\");c.setAttribute(\"type\",\"radio\"),c.setAttribute(\"checked\",\"checked\"),c.setAttribute(\"name\",\"t\"),b.appendChild(c),l.checkClone=b.cloneNode(!0).cloneNode(!0).lastChild.checked,b.innerHTML=\"<textarea>x</textarea>\",l.noCloneChecked=!!b.cloneNode(!0).lastChild.defaultValue}();var da=/^key/,ea=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,fa=/^([^.]*)(?:\\.(.+)|)/;function ga(){return!0}function ha(){return!1}function ia(){try{return d.activeElement}catch(a){}}function ja(a,b,c,d,e,f){var g,h;if(\"object\"==typeof b){\"string\"!=typeof c&&(d=d||c,c=void 0);for(h in b)ja(a,h,c,d,b[h],f);return a}if(null==d&&null==e?(e=c,d=c=void 0):null==e&&(\"string\"==typeof c?(e=d,d=void 0):(e=d,d=c,c=void 0)),e===!1)e=ha;else if(!e)return this;return 1===f&&(g=e,e=function(a){return n().off(a),g.apply(this,arguments)},e.guid=g.guid||(g.guid=n.guid++)),a.each(function(){n.event.add(this,b,e,d,c)})}n.event={global:{},add:function(a,b,c,d,e){var f,g,h,i,j,k,l,m,o,p,q,r=N.get(a);if(r){c.handler&&(f=c,c=f.handler,e=f.selector),c.guid||(c.guid=n.guid++),(i=r.events)||(i=r.events={}),(g=r.handle)||(g=r.handle=function(b){return\"undefined\"!=typeof n&&n.event.triggered!==b.type?n.event.dispatch.apply(a,arguments):void 0}),b=(b||\"\").match(G)||[\"\"],j=b.length;while(j--)h=fa.exec(b[j])||[],o=q=h[1],p=(h[2]||\"\").split(\".\").sort(),o&&(l=n.event.special[o]||{},o=(e?l.delegateType:l.bindType)||o,l=n.event.special[o]||{},k=n.extend({type:o,origType:q,data:d,handler:c,guid:c.guid,selector:e,needsContext:e&&n.expr.match.needsContext.test(e),namespace:p.join(\".\")},f),(m=i[o])||(m=i[o]=[],m.delegateCount=0,l.setup&&l.setup.call(a,d,p,g)!==!1||a.addEventListener&&a.addEventListener(o,g)),l.add&&(l.add.call(a,k),k.handler.guid||(k.handler.guid=c.guid)),e?m.splice(m.delegateCount++,0,k):m.push(k),n.event.global[o]=!0)}},remove:function(a,b,c,d,e){var f,g,h,i,j,k,l,m,o,p,q,r=N.hasData(a)&&N.get(a);if(r&&(i=r.events)){b=(b||\"\").match(G)||[\"\"],j=b.length;while(j--)if(h=fa.exec(b[j])||[],o=q=h[1],p=(h[2]||\"\").split(\".\").sort(),o){l=n.event.special[o]||{},o=(d?l.delegateType:l.bindType)||o,m=i[o]||[],h=h[2]&&new RegExp(\"(^|\\\\.)\"+p.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"),g=f=m.length;while(f--)k=m[f],!e&&q!==k.origType||c&&c.guid!==k.guid||h&&!h.test(k.namespace)||d&&d!==k.selector&&(\"**\"!==d||!k.selector)||(m.splice(f,1),k.selector&&m.delegateCount--,l.remove&&l.remove.call(a,k));g&&!m.length&&(l.teardown&&l.teardown.call(a,p,r.handle)!==!1||n.removeEvent(a,o,r.handle),delete i[o])}else for(o in i)n.event.remove(a,o+b[j],c,d,!0);n.isEmptyObject(i)&&N.remove(a,\"handle events\")}},dispatch:function(a){a=n.event.fix(a);var b,c,d,f,g,h=[],i=e.call(arguments),j=(N.get(this,\"events\")||{})[a.type]||[],k=n.event.special[a.type]||{};if(i[0]=a,a.delegateTarget=this,!k.preDispatch||k.preDispatch.call(this,a)!==!1){h=n.event.handlers.call(this,a,j),b=0;while((f=h[b++])&&!a.isPropagationStopped()){a.currentTarget=f.elem,c=0;while((g=f.handlers[c++])&&!a.isImmediatePropagationStopped())(!a.rnamespace||a.rnamespace.test(g.namespace))&&(a.handleObj=g,a.data=g.data,d=((n.event.special[g.origType]||{}).handle||g.handler).apply(f.elem,i),void 0!==d&&(a.result=d)===!1&&(a.preventDefault(),a.stopPropagation()))}return k.postDispatch&&k.postDispatch.call(this,a),a.result}},handlers:function(a,b){var c,d,e,f,g=[],h=b.delegateCount,i=a.target;if(h&&i.nodeType&&(\"click\"!==a.type||isNaN(a.button)||a.button<1))for(;i!==this;i=i.parentNode||this)if(1===i.nodeType&&(i.disabled!==!0||\"click\"!==a.type)){for(d=[],c=0;h>c;c++)f=b[c],e=f.selector+\" \",void 0===d[e]&&(d[e]=f.needsContext?n(e,this).index(i)>-1:n.find(e,this,null,[i]).length),d[e]&&d.push(f);d.length&&g.push({elem:i,handlers:d})}return h<b.length&&g.push({elem:this,handlers:b.slice(h)}),g},props:\"altKey bubbles cancelable ctrlKey currentTarget detail eventPhase metaKey relatedTarget shiftKey target timeStamp view which\".split(\" \"),fixHooks:{},keyHooks:{props:\"char charCode key keyCode\".split(\" \"),filter:function(a,b){return null==a.which&&(a.which=null!=b.charCode?b.charCode:b.keyCode),a}},mouseHooks:{props:\"button buttons clientX clientY offsetX offsetY pageX pageY screenX screenY toElement\".split(\" \"),filter:function(a,b){var c,e,f,g=b.button;return null==a.pageX&&null!=b.clientX&&(c=a.target.ownerDocument||d,e=c.documentElement,f=c.body,a.pageX=b.clientX+(e&&e.scrollLeft||f&&f.scrollLeft||0)-(e&&e.clientLeft||f&&f.clientLeft||0),a.pageY=b.clientY+(e&&e.scrollTop||f&&f.scrollTop||0)-(e&&e.clientTop||f&&f.clientTop||0)),a.which||void 0===g||(a.which=1&g?1:2&g?3:4&g?2:0),a}},fix:function(a){if(a[n.expando])return a;var b,c,e,f=a.type,g=a,h=this.fixHooks[f];h||(this.fixHooks[f]=h=ea.test(f)?this.mouseHooks:da.test(f)?this.keyHooks:{}),e=h.props?this.props.concat(h.props):this.props,a=new n.Event(g),b=e.length;while(b--)c=e[b],a[c]=g[c];return a.target||(a.target=d),3===a.target.nodeType&&(a.target=a.target.parentNode),h.filter?h.filter(a,g):a},special:{load:{noBubble:!0},focus:{trigger:function(){return this!==ia()&&this.focus?(this.focus(),!1):void 0},delegateType:\"focusin\"},blur:{trigger:function(){return this===ia()&&this.blur?(this.blur(),!1):void 0},delegateType:\"focusout\"},click:{trigger:function(){return\"checkbox\"===this.type&&this.click&&n.nodeName(this,\"input\")?(this.click(),!1):void 0},_default:function(a){return n.nodeName(a.target,\"a\")}},beforeunload:{postDispatch:function(a){void 0!==a.result&&a.originalEvent&&(a.originalEvent.returnValue=a.result)}}}},n.removeEvent=function(a,b,c){a.removeEventListener&&a.removeEventListener(b,c)},n.Event=function(a,b){return this instanceof n.Event?(a&&a.type?(this.originalEvent=a,this.type=a.type,this.isDefaultPrevented=a.defaultPrevented||void 0===a.defaultPrevented&&a.returnValue===!1?ga:ha):this.type=a,b&&n.extend(this,b),this.timeStamp=a&&a.timeStamp||n.now(),void(this[n.expando]=!0)):new n.Event(a,b)},n.Event.prototype={constructor:n.Event,isDefaultPrevented:ha,isPropagationStopped:ha,isImmediatePropagationStopped:ha,preventDefault:function(){var a=this.originalEvent;this.isDefaultPrevented=ga,a&&a.preventDefault()},stopPropagation:function(){var a=this.originalEvent;this.isPropagationStopped=ga,a&&a.stopPropagation()},stopImmediatePropagation:function(){var a=this.originalEvent;this.isImmediatePropagationStopped=ga,a&&a.stopImmediatePropagation(),this.stopPropagation()}},n.each({mouseenter:\"mouseover\",mouseleave:\"mouseout\",pointerenter:\"pointerover\",pointerleave:\"pointerout\"},function(a,b){n.event.special[a]={delegateType:b,bindType:b,handle:function(a){var c,d=this,e=a.relatedTarget,f=a.handleObj;return(!e||e!==d&&!n.contains(d,e))&&(a.type=f.origType,c=f.handler.apply(this,arguments),a.type=b),c}}}),n.fn.extend({on:function(a,b,c,d){return ja(this,a,b,c,d)},one:function(a,b,c,d){return ja(this,a,b,c,d,1)},off:function(a,b,c){var d,e;if(a&&a.preventDefault&&a.handleObj)return d=a.handleObj,n(a.delegateTarget).off(d.namespace?d.origType+\".\"+d.namespace:d.origType,d.selector,d.handler),this;if(\"object\"==typeof a){for(e in a)this.off(e,b,a[e]);return this}return(b===!1||\"function\"==typeof b)&&(c=b,b=void 0),c===!1&&(c=ha),this.each(function(){n.event.remove(this,a,c,b)})}});var ka=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\\w:-]+)[^>]*)\\/>/gi,la=/<script|<style|<link/i,ma=/checked\\s*(?:[^=]|=\\s*.checked.)/i,na=/^true\\/(.*)/,oa=/^\\s*<!(?:\\[CDATA\\[|--)|(?:\\]\\]|--)>\\s*$/g;function pa(a,b){return n.nodeName(a,\"table\")&&n.nodeName(11!==b.nodeType?b:b.firstChild,\"tr\")?a.getElementsByTagName(\"tbody\")[0]||a:a}function qa(a){return a.type=(null!==a.getAttribute(\"type\"))+\"/\"+a.type,a}function ra(a){var b=na.exec(a.type);return b?a.type=b[1]:a.removeAttribute(\"type\"),a}function sa(a,b){var c,d,e,f,g,h,i,j;if(1===b.nodeType){if(N.hasData(a)&&(f=N.access(a),g=N.set(b,f),j=f.events)){delete g.handle,g.events={};for(e in j)for(c=0,d=j[e].length;d>c;c++)n.event.add(b,e,j[e][c])}O.hasData(a)&&(h=O.access(a),i=n.extend({},h),O.set(b,i))}}function ta(a,b){var c=b.nodeName.toLowerCase();\"input\"===c&&X.test(a.type)?b.checked=a.checked:(\"input\"===c||\"textarea\"===c)&&(b.defaultValue=a.defaultValue)}function ua(a,b,c,d){b=f.apply([],b);var e,g,h,i,j,k,m=0,o=a.length,p=o-1,q=b[0],r=n.isFunction(q);if(r||o>1&&\"string\"==typeof q&&!l.checkClone&&ma.test(q))return a.each(function(e){var f=a.eq(e);r&&(b[0]=q.call(this,e,f.html())),ua(f,b,c,d)});if(o&&(e=ca(b,a[0].ownerDocument,!1,a,d),g=e.firstChild,1===e.childNodes.length&&(e=g),g||d)){for(h=n.map(_(e,\"script\"),qa),i=h.length;o>m;m++)j=e,m!==p&&(j=n.clone(j,!0,!0),i&&n.merge(h,_(j,\"script\"))),c.call(a[m],j,m);if(i)for(k=h[h.length-1].ownerDocument,n.map(h,ra),m=0;i>m;m++)j=h[m],Z.test(j.type||\"\")&&!N.access(j,\"globalEval\")&&n.contains(k,j)&&(j.src?n._evalUrl&&n._evalUrl(j.src):n.globalEval(j.textContent.replace(oa,\"\")))}return a}function va(a,b,c){for(var d,e=b?n.filter(b,a):a,f=0;null!=(d=e[f]);f++)c||1!==d.nodeType||n.cleanData(_(d)),d.parentNode&&(c&&n.contains(d.ownerDocument,d)&&aa(_(d,\"script\")),d.parentNode.removeChild(d));return a}n.extend({htmlPrefilter:function(a){return a.replace(ka,\"<$1></$2>\")},clone:function(a,b,c){var d,e,f,g,h=a.cloneNode(!0),i=n.contains(a.ownerDocument,a);if(!(l.noCloneChecked||1!==a.nodeType&&11!==a.nodeType||n.isXMLDoc(a)))for(g=_(h),f=_(a),d=0,e=f.length;e>d;d++)ta(f[d],g[d]);if(b)if(c)for(f=f||_(a),g=g||_(h),d=0,e=f.length;e>d;d++)sa(f[d],g[d]);else sa(a,h);return g=_(h,\"script\"),g.length>0&&aa(g,!i&&_(a,\"script\")),h},cleanData:function(a){for(var b,c,d,e=n.event.special,f=0;void 0!==(c=a[f]);f++)if(L(c)){if(b=c[N.expando]){if(b.events)for(d in b.events)e[d]?n.event.remove(c,d):n.removeEvent(c,d,b.handle);c[N.expando]=void 0}c[O.expando]&&(c[O.expando]=void 0)}}}),n.fn.extend({domManip:ua,detach:function(a){return va(this,a,!0)},remove:function(a){return va(this,a)},text:function(a){return K(this,function(a){return void 0===a?n.text(this):this.empty().each(function(){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&(this.textContent=a)})},null,a,arguments.length)},append:function(){return ua(this,arguments,function(a){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var b=pa(this,a);b.appendChild(a)}})},prepend:function(){return ua(this,arguments,function(a){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var b=pa(this,a);b.insertBefore(a,b.firstChild)}})},before:function(){return ua(this,arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this)})},after:function(){return ua(this,arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this.nextSibling)})},empty:function(){for(var a,b=0;null!=(a=this[b]);b++)1===a.nodeType&&(n.cleanData(_(a,!1)),a.textContent=\"\");return this},clone:function(a,b){return a=null==a?!1:a,b=null==b?a:b,this.map(function(){return n.clone(this,a,b)})},html:function(a){return K(this,function(a){var b=this[0]||{},c=0,d=this.length;if(void 0===a&&1===b.nodeType)return b.innerHTML;if(\"string\"==typeof a&&!la.test(a)&&!$[(Y.exec(a)||[\"\",\"\"])[1].toLowerCase()]){a=n.htmlPrefilter(a);try{for(;d>c;c++)b=this[c]||{},1===b.nodeType&&(n.cleanData(_(b,!1)),b.innerHTML=a);b=0}catch(e){}}b&&this.empty().append(a)},null,a,arguments.length)},replaceWith:function(){var a=[];return ua(this,arguments,function(b){var c=this.parentNode;n.inArray(this,a)<0&&(n.cleanData(_(this)),c&&c.replaceChild(b,this))},a)}}),n.each({appendTo:\"append\",prependTo:\"prepend\",insertBefore:\"before\",insertAfter:\"after\",replaceAll:\"replaceWith\"},function(a,b){n.fn[a]=function(a){for(var c,d=[],e=n(a),f=e.length-1,h=0;f>=h;h++)c=h===f?this:this.clone(!0),n(e[h])[b](c),g.apply(d,c.get());return this.pushStack(d)}});var wa,xa={HTML:\"block\",BODY:\"block\"};function ya(a,b){var c=n(b.createElement(a)).appendTo(b.body),d=n.css(c[0],\"display\");return c.detach(),d}function za(a){var b=d,c=xa[a];return c||(c=ya(a,b),\"none\"!==c&&c||(wa=(wa||n(\"<iframe frameborder='0' width='0' height='0'/>\")).appendTo(b.documentElement),b=wa[0].contentDocument,b.write(),b.close(),c=ya(a,b),wa.detach()),xa[a]=c),c}var Aa=/^margin/,Ba=new RegExp(\"^(\"+S+\")(?!px)[a-z%]+$\",\"i\"),Ca=function(b){var c=b.ownerDocument.defaultView;return c.opener||(c=a),c.getComputedStyle(b)},Da=function(a,b,c,d){var e,f,g={};for(f in b)g[f]=a.style[f],a.style[f]=b[f];e=c.apply(a,d||[]);for(f in b)a.style[f]=g[f];return e},Ea=d.documentElement;!function(){var b,c,e,f,g=d.createElement(\"div\"),h=d.createElement(\"div\");if(h.style){h.style.backgroundClip=\"content-box\",h.cloneNode(!0).style.backgroundClip=\"\",l.clearCloneStyle=\"content-box\"===h.style.backgroundClip,g.style.cssText=\"border:0;width:8px;height:0;top:0;left:-9999px;padding:0;margin-top:1px;position:absolute\",g.appendChild(h);function i(){h.style.cssText=\"-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;position:relative;display:block;margin:auto;border:1px;padding:1px;top:1%;width:50%\",h.innerHTML=\"\",Ea.appendChild(g);var d=a.getComputedStyle(h);b=\"1%\"!==d.top,f=\"2px\"===d.marginLeft,c=\"4px\"===d.width,h.style.marginRight=\"50%\",e=\"4px\"===d.marginRight,Ea.removeChild(g)}n.extend(l,{pixelPosition:function(){return i(),b},boxSizingReliable:function(){return null==c&&i(),c},pixelMarginRight:function(){return null==c&&i(),e},reliableMarginLeft:function(){return null==c&&i(),f},reliableMarginRight:function(){var b,c=h.appendChild(d.createElement(\"div\"));return c.style.cssText=h.style.cssText=\"-webkit-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:0\",c.style.marginRight=c.style.width=\"0\",h.style.width=\"1px\",Ea.appendChild(g),b=!parseFloat(a.getComputedStyle(c).marginRight),Ea.removeChild(g),h.removeChild(c),b}})}}();function Fa(a,b,c){var d,e,f,g,h=a.style;return c=c||Ca(a),c&&(g=c.getPropertyValue(b)||c[b],\"\"!==g||n.contains(a.ownerDocument,a)||(g=n.style(a,b)),!l.pixelMarginRight()&&Ba.test(g)&&Aa.test(b)&&(d=h.width,e=h.minWidth,f=h.maxWidth,h.minWidth=h.maxWidth=h.width=g,g=c.width,h.width=d,h.minWidth=e,h.maxWidth=f)),void 0!==g?g+\"\":g}function Ga(a,b){return{get:function(){return a()?void delete this.get:(this.get=b).apply(this,arguments)}}}var Ha=/^(none|table(?!-c[ea]).+)/,Ia={position:\"absolute\",visibility:\"hidden\",display:\"block\"},Ja={letterSpacing:\"0\",fontWeight:\"400\"},Ka=[\"Webkit\",\"O\",\"Moz\",\"ms\"],La=d.createElement(\"div\").style;function Ma(a){if(a in La)return a;var b=a[0].toUpperCase()+a.slice(1),c=Ka.length;while(c--)if(a=Ka[c]+b,a in La)return a}function Na(a,b,c){var d=T.exec(b);return d?Math.max(0,d[2]-(c||0))+(d[3]||\"px\"):b}function Oa(a,b,c,d,e){for(var f=c===(d?\"border\":\"content\")?4:\"width\"===b?1:0,g=0;4>f;f+=2)\"margin\"===c&&(g+=n.css(a,c+U[f],!0,e)),d?(\"content\"===c&&(g-=n.css(a,\"padding\"+U[f],!0,e)),\"margin\"!==c&&(g-=n.css(a,\"border\"+U[f]+\"Width\",!0,e))):(g+=n.css(a,\"padding\"+U[f],!0,e),\"padding\"!==c&&(g+=n.css(a,\"border\"+U[f]+\"Width\",!0,e)));return g}function Pa(b,c,e){var f=!0,g=\"width\"===c?b.offsetWidth:b.offsetHeight,h=Ca(b),i=\"border-box\"===n.css(b,\"boxSizing\",!1,h);if(d.msFullscreenElement&&a.top!==a&&b.getClientRects().length&&(g=Math.round(100*b.getBoundingClientRect()[c])),0>=g||null==g){if(g=Fa(b,c,h),(0>g||null==g)&&(g=b.style[c]),Ba.test(g))return g;f=i&&(l.boxSizingReliable()||g===b.style[c]),g=parseFloat(g)||0}return g+Oa(b,c,e||(i?\"border\":\"content\"),f,h)+\"px\"}function Qa(a,b){for(var c,d,e,f=[],g=0,h=a.length;h>g;g++)d=a[g],d.style&&(f[g]=N.get(d,\"olddisplay\"),c=d.style.display,b?(f[g]||\"none\"!==c||(d.style.display=\"\"),\"\"===d.style.display&&V(d)&&(f[g]=N.access(d,\"olddisplay\",za(d.nodeName)))):(e=V(d),\"none\"===c&&e||N.set(d,\"olddisplay\",e?c:n.css(d,\"display\"))));for(g=0;h>g;g++)d=a[g],d.style&&(b&&\"none\"!==d.style.display&&\"\"!==d.style.display||(d.style.display=b?f[g]||\"\":\"none\"));return a}n.extend({cssHooks:{opacity:{get:function(a,b){if(b){var c=Fa(a,\"opacity\");return\"\"===c?\"1\":c}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{\"float\":\"cssFloat\"},style:function(a,b,c,d){if(a&&3!==a.nodeType&&8!==a.nodeType&&a.style){var e,f,g,h=n.camelCase(b),i=a.style;return b=n.cssProps[h]||(n.cssProps[h]=Ma(h)||h),g=n.cssHooks[b]||n.cssHooks[h],void 0===c?g&&\"get\"in g&&void 0!==(e=g.get(a,!1,d))?e:i[b]:(f=typeof c,\"string\"===f&&(e=T.exec(c))&&e[1]&&(c=W(a,b,e),f=\"number\"),null!=c&&c===c&&(\"number\"===f&&(c+=e&&e[3]||(n.cssNumber[h]?\"\":\"px\")),l.clearCloneStyle||\"\"!==c||0!==b.indexOf(\"background\")||(i[b]=\"inherit\"),g&&\"set\"in g&&void 0===(c=g.set(a,c,d))||(i[b]=c)),void 0)}},css:function(a,b,c,d){var e,f,g,h=n.camelCase(b);return b=n.cssProps[h]||(n.cssProps[h]=Ma(h)||h),g=n.cssHooks[b]||n.cssHooks[h],g&&\"get\"in g&&(e=g.get(a,!0,c)),void 0===e&&(e=Fa(a,b,d)),\"normal\"===e&&b in Ja&&(e=Ja[b]),\"\"===c||c?(f=parseFloat(e),c===!0||isFinite(f)?f||0:e):e}}),n.each([\"height\",\"width\"],function(a,b){n.cssHooks[b]={get:function(a,c,d){return c?Ha.test(n.css(a,\"display\"))&&0===a.offsetWidth?Da(a,Ia,function(){return Pa(a,b,d)}):Pa(a,b,d):void 0},set:function(a,c,d){var e,f=d&&Ca(a),g=d&&Oa(a,b,d,\"border-box\"===n.css(a,\"boxSizing\",!1,f),f);return g&&(e=T.exec(c))&&\"px\"!==(e[3]||\"px\")&&(a.style[b]=c,c=n.css(a,b)),Na(a,c,g)}}}),n.cssHooks.marginLeft=Ga(l.reliableMarginLeft,function(a,b){return b?(parseFloat(Fa(a,\"marginLeft\"))||a.getBoundingClientRect().left-Da(a,{marginLeft:0},function(){return a.getBoundingClientRect().left}))+\"px\":void 0}),n.cssHooks.marginRight=Ga(l.reliableMarginRight,function(a,b){return b?Da(a,{display:\"inline-block\"},Fa,[a,\"marginRight\"]):void 0}),n.each({margin:\"\",padding:\"\",border:\"Width\"},function(a,b){n.cssHooks[a+b]={expand:function(c){for(var d=0,e={},f=\"string\"==typeof c?c.split(\" \"):[c];4>d;d++)e[a+U[d]+b]=f[d]||f[d-2]||f[0];return e}},Aa.test(a)||(n.cssHooks[a+b].set=Na)}),n.fn.extend({css:function(a,b){return K(this,function(a,b,c){var d,e,f={},g=0;if(n.isArray(b)){for(d=Ca(a),e=b.length;e>g;g++)f[b[g]]=n.css(a,b[g],!1,d);return f}return void 0!==c?n.style(a,b,c):n.css(a,b)},a,b,arguments.length>1)},show:function(){return Qa(this,!0)},hide:function(){return Qa(this)},toggle:function(a){return\"boolean\"==typeof a?a?this.show():this.hide():this.each(function(){V(this)?n(this).show():n(this).hide()})}});function Ra(a,b,c,d,e){return new Ra.prototype.init(a,b,c,d,e)}n.Tween=Ra,Ra.prototype={constructor:Ra,init:function(a,b,c,d,e,f){this.elem=a,this.prop=c,this.easing=e||n.easing._default,this.options=b,this.start=this.now=this.cur(),this.end=d,this.unit=f||(n.cssNumber[c]?\"\":\"px\")},cur:function(){var a=Ra.propHooks[this.prop];return a&&a.get?a.get(this):Ra.propHooks._default.get(this)},run:function(a){var b,c=Ra.propHooks[this.prop];return this.options.duration?this.pos=b=n.easing[this.easing](a,this.options.duration*a,0,1,this.options.duration):this.pos=b=a,this.now=(this.end-this.start)*b+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),c&&c.set?c.set(this):Ra.propHooks._default.set(this),this}},Ra.prototype.init.prototype=Ra.prototype,Ra.propHooks={_default:{get:function(a){var b;return 1!==a.elem.nodeType||null!=a.elem[a.prop]&&null==a.elem.style[a.prop]?a.elem[a.prop]:(b=n.css(a.elem,a.prop,\"\"),b&&\"auto\"!==b?b:0)},set:function(a){n.fx.step[a.prop]?n.fx.step[a.prop](a):1!==a.elem.nodeType||null==a.elem.style[n.cssProps[a.prop]]&&!n.cssHooks[a.prop]?a.elem[a.prop]=a.now:n.style(a.elem,a.prop,a.now+a.unit)}}},Ra.propHooks.scrollTop=Ra.propHooks.scrollLeft={set:function(a){a.elem.nodeType&&a.elem.parentNode&&(a.elem[a.prop]=a.now)}},n.easing={linear:function(a){return a},swing:function(a){return.5-Math.cos(a*Math.PI)/2},_default:\"swing\"},n.fx=Ra.prototype.init,n.fx.step={};var Sa,Ta,Ua=/^(?:toggle|show|hide)$/,Va=/queueHooks$/;function Wa(){return a.setTimeout(function(){Sa=void 0}),Sa=n.now()}function Xa(a,b){var c,d=0,e={height:a};for(b=b?1:0;4>d;d+=2-b)c=U[d],e[\"margin\"+c]=e[\"padding\"+c]=a;return b&&(e.opacity=e.width=a),e}function Ya(a,b,c){for(var d,e=(_a.tweeners[b]||[]).concat(_a.tweeners[\"*\"]),f=0,g=e.length;g>f;f++)if(d=e[f].call(c,b,a))return d}function Za(a,b,c){var d,e,f,g,h,i,j,k,l=this,m={},o=a.style,p=a.nodeType&&V(a),q=N.get(a,\"fxshow\");c.queue||(h=n._queueHooks(a,\"fx\"),null==h.unqueued&&(h.unqueued=0,i=h.empty.fire,h.empty.fire=function(){h.unqueued||i()}),h.unqueued++,l.always(function(){l.always(function(){h.unqueued--,n.queue(a,\"fx\").length||h.empty.fire()})})),1===a.nodeType&&(\"height\"in b||\"width\"in b)&&(c.overflow=[o.overflow,o.overflowX,o.overflowY],j=n.css(a,\"display\"),k=\"none\"===j?N.get(a,\"olddisplay\")||za(a.nodeName):j,\"inline\"===k&&\"none\"===n.css(a,\"float\")&&(o.display=\"inline-block\")),c.overflow&&(o.overflow=\"hidden\",l.always(function(){o.overflow=c.overflow[0],o.overflowX=c.overflow[1],o.overflowY=c.overflow[2]}));for(d in b)if(e=b[d],Ua.exec(e)){if(delete b[d],f=f||\"toggle\"===e,e===(p?\"hide\":\"show\")){if(\"show\"!==e||!q||void 0===q[d])continue;p=!0}m[d]=q&&q[d]||n.style(a,d)}else j=void 0;if(n.isEmptyObject(m))\"inline\"===(\"none\"===j?za(a.nodeName):j)&&(o.display=j);else{q?\"hidden\"in q&&(p=q.hidden):q=N.access(a,\"fxshow\",{}),f&&(q.hidden=!p),p?n(a).show():l.done(function(){n(a).hide()}),l.done(function(){var b;N.remove(a,\"fxshow\");for(b in m)n.style(a,b,m[b])});for(d in m)g=Ya(p?q[d]:0,d,l),d in q||(q[d]=g.start,p&&(g.end=g.start,g.start=\"width\"===d||\"height\"===d?1:0))}}function $a(a,b){var c,d,e,f,g;for(c in a)if(d=n.camelCase(c),e=b[d],f=a[c],n.isArray(f)&&(e=f[1],f=a[c]=f[0]),c!==d&&(a[d]=f,delete a[c]),g=n.cssHooks[d],g&&\"expand\"in g){f=g.expand(f),delete a[d];for(c in f)c in a||(a[c]=f[c],b[c]=e)}else b[d]=e}function _a(a,b,c){var d,e,f=0,g=_a.prefilters.length,h=n.Deferred().always(function(){delete i.elem}),i=function(){if(e)return!1;for(var b=Sa||Wa(),c=Math.max(0,j.startTime+j.duration-b),d=c/j.duration||0,f=1-d,g=0,i=j.tweens.length;i>g;g++)j.tweens[g].run(f);return h.notifyWith(a,[j,f,c]),1>f&&i?c:(h.resolveWith(a,[j]),!1)},j=h.promise({elem:a,props:n.extend({},b),opts:n.extend(!0,{specialEasing:{},easing:n.easing._default},c),originalProperties:b,originalOptions:c,startTime:Sa||Wa(),duration:c.duration,tweens:[],createTween:function(b,c){var d=n.Tween(a,j.opts,b,c,j.opts.specialEasing[b]||j.opts.easing);return j.tweens.push(d),d},stop:function(b){var c=0,d=b?j.tweens.length:0;if(e)return this;for(e=!0;d>c;c++)j.tweens[c].run(1);return b?(h.notifyWith(a,[j,1,0]),h.resolveWith(a,[j,b])):h.rejectWith(a,[j,b]),this}}),k=j.props;for($a(k,j.opts.specialEasing);g>f;f++)if(d=_a.prefilters[f].call(j,a,k,j.opts))return n.isFunction(d.stop)&&(n._queueHooks(j.elem,j.opts.queue).stop=n.proxy(d.stop,d)),d;return n.map(k,Ya,j),n.isFunction(j.opts.start)&&j.opts.start.call(a,j),n.fx.timer(n.extend(i,{elem:a,anim:j,queue:j.opts.queue})),j.progress(j.opts.progress).done(j.opts.done,j.opts.complete).fail(j.opts.fail).always(j.opts.always)}n.Animation=n.extend(_a,{tweeners:{\"*\":[function(a,b){var c=this.createTween(a,b);return W(c.elem,a,T.exec(b),c),c}]},tweener:function(a,b){n.isFunction(a)?(b=a,a=[\"*\"]):a=a.match(G);for(var c,d=0,e=a.length;e>d;d++)c=a[d],_a.tweeners[c]=_a.tweeners[c]||[],_a.tweeners[c].unshift(b)},prefilters:[Za],prefilter:function(a,b){b?_a.prefilters.unshift(a):_a.prefilters.push(a)}}),n.speed=function(a,b,c){var d=a&&\"object\"==typeof a?n.extend({},a):{complete:c||!c&&b||n.isFunction(a)&&a,duration:a,easing:c&&b||b&&!n.isFunction(b)&&b};return d.duration=n.fx.off?0:\"number\"==typeof d.duration?d.duration:d.duration in n.fx.speeds?n.fx.speeds[d.duration]:n.fx.speeds._default,(null==d.queue||d.queue===!0)&&(d.queue=\"fx\"),d.old=d.complete,d.complete=function(){n.isFunction(d.old)&&d.old.call(this),d.queue&&n.dequeue(this,d.queue)},d},n.fn.extend({fadeTo:function(a,b,c,d){return this.filter(V).css(\"opacity\",0).show().end().animate({opacity:b},a,c,d)},animate:function(a,b,c,d){var e=n.isEmptyObject(a),f=n.speed(b,c,d),g=function(){var b=_a(this,n.extend({},a),f);(e||N.get(this,\"finish\"))&&b.stop(!0)};return g.finish=g,e||f.queue===!1?this.each(g):this.queue(f.queue,g)},stop:function(a,b,c){var d=function(a){var b=a.stop;delete a.stop,b(c)};return\"string\"!=typeof a&&(c=b,b=a,a=void 0),b&&a!==!1&&this.queue(a||\"fx\",[]),this.each(function(){var b=!0,e=null!=a&&a+\"queueHooks\",f=n.timers,g=N.get(this);if(e)g[e]&&g[e].stop&&d(g[e]);else for(e in g)g[e]&&g[e].stop&&Va.test(e)&&d(g[e]);for(e=f.length;e--;)f[e].elem!==this||null!=a&&f[e].queue!==a||(f[e].anim.stop(c),b=!1,f.splice(e,1));(b||!c)&&n.dequeue(this,a)})},finish:function(a){return a!==!1&&(a=a||\"fx\"),this.each(function(){var b,c=N.get(this),d=c[a+\"queue\"],e=c[a+\"queueHooks\"],f=n.timers,g=d?d.length:0;for(c.finish=!0,n.queue(this,a,[]),e&&e.stop&&e.stop.call(this,!0),b=f.length;b--;)f[b].elem===this&&f[b].queue===a&&(f[b].anim.stop(!0),f.splice(b,1));for(b=0;g>b;b++)d[b]&&d[b].finish&&d[b].finish.call(this);delete c.finish})}}),n.each([\"toggle\",\"show\",\"hide\"],function(a,b){var c=n.fn[b];n.fn[b]=function(a,d,e){return null==a||\"boolean\"==typeof a?c.apply(this,arguments):this.animate(Xa(b,!0),a,d,e)}}),n.each({slideDown:Xa(\"show\"),slideUp:Xa(\"hide\"),slideToggle:Xa(\"toggle\"),fadeIn:{opacity:\"show\"},fadeOut:{opacity:\"hide\"},fadeToggle:{opacity:\"toggle\"}},function(a,b){n.fn[a]=function(a,c,d){return this.animate(b,a,c,d)}}),n.timers=[],n.fx.tick=function(){var a,b=0,c=n.timers;for(Sa=n.now();b<c.length;b++)a=c[b],a()||c[b]!==a||c.splice(b--,1);c.length||n.fx.stop(),Sa=void 0},n.fx.timer=function(a){n.timers.push(a),a()?n.fx.start():n.timers.pop()},n.fx.interval=13,n.fx.start=function(){Ta||(Ta=a.setInterval(n.fx.tick,n.fx.interval))},n.fx.stop=function(){a.clearInterval(Ta),Ta=null},n.fx.speeds={slow:600,fast:200,_default:400},n.fn.delay=function(b,c){return b=n.fx?n.fx.speeds[b]||b:b,c=c||\"fx\",this.queue(c,function(c,d){var e=a.setTimeout(c,b);d.stop=function(){a.clearTimeout(e)}})},function(){var a=d.createElement(\"input\"),b=d.createElement(\"select\"),c=b.appendChild(d.createElement(\"option\"));a.type=\"checkbox\",l.checkOn=\"\"!==a.value,l.optSelected=c.selected,b.disabled=!0,l.optDisabled=!c.disabled,a=d.createElement(\"input\"),a.value=\"t\",a.type=\"radio\",l.radioValue=\"t\"===a.value}();var ab,bb=n.expr.attrHandle;n.fn.extend({attr:function(a,b){return K(this,n.attr,a,b,arguments.length>1)},removeAttr:function(a){return this.each(function(){n.removeAttr(this,a)})}}),n.extend({attr:function(a,b,c){var d,e,f=a.nodeType;if(3!==f&&8!==f&&2!==f)return\"undefined\"==typeof a.getAttribute?n.prop(a,b,c):(1===f&&n.isXMLDoc(a)||(b=b.toLowerCase(),e=n.attrHooks[b]||(n.expr.match.bool.test(b)?ab:void 0)),void 0!==c?null===c?void n.removeAttr(a,b):e&&\"set\"in e&&void 0!==(d=e.set(a,c,b))?d:(a.setAttribute(b,c+\"\"),c):e&&\"get\"in e&&null!==(d=e.get(a,b))?d:(d=n.find.attr(a,b),null==d?void 0:d))},attrHooks:{type:{set:function(a,b){if(!l.radioValue&&\"radio\"===b&&n.nodeName(a,\"input\")){var c=a.value;return a.setAttribute(\"type\",b),c&&(a.value=c),b}}}},removeAttr:function(a,b){var c,d,e=0,f=b&&b.match(G);if(f&&1===a.nodeType)while(c=f[e++])d=n.propFix[c]||c,n.expr.match.bool.test(c)&&(a[d]=!1),a.removeAttribute(c)}}),ab={set:function(a,b,c){return b===!1?n.removeAttr(a,c):a.setAttribute(c,c),c}},n.each(n.expr.match.bool.source.match(/\\w+/g),function(a,b){var c=bb[b]||n.find.attr;bb[b]=function(a,b,d){var e,f;return d||(f=bb[b],bb[b]=e,e=null!=c(a,b,d)?b.toLowerCase():null,bb[b]=f),e}});var cb=/^(?:input|select|textarea|button)$/i,db=/^(?:a|area)$/i;n.fn.extend({prop:function(a,b){return K(this,n.prop,a,b,arguments.length>1)},removeProp:function(a){return this.each(function(){delete this[n.propFix[a]||a]})}}),n.extend({prop:function(a,b,c){var d,e,f=a.nodeType;if(3!==f&&8!==f&&2!==f)return 1===f&&n.isXMLDoc(a)||(b=n.propFix[b]||b,e=n.propHooks[b]),void 0!==c?e&&\"set\"in e&&void 0!==(d=e.set(a,c,b))?d:a[b]=c:e&&\"get\"in e&&null!==(d=e.get(a,b))?d:a[b];\n},propHooks:{tabIndex:{get:function(a){var b=n.find.attr(a,\"tabindex\");return b?parseInt(b,10):cb.test(a.nodeName)||db.test(a.nodeName)&&a.href?0:-1}}},propFix:{\"for\":\"htmlFor\",\"class\":\"className\"}}),l.optSelected||(n.propHooks.selected={get:function(a){var b=a.parentNode;return b&&b.parentNode&&b.parentNode.selectedIndex,null}}),n.each([\"tabIndex\",\"readOnly\",\"maxLength\",\"cellSpacing\",\"cellPadding\",\"rowSpan\",\"colSpan\",\"useMap\",\"frameBorder\",\"contentEditable\"],function(){n.propFix[this.toLowerCase()]=this});var eb=/[\\t\\r\\n\\f]/g;function fb(a){return a.getAttribute&&a.getAttribute(\"class\")||\"\"}n.fn.extend({addClass:function(a){var b,c,d,e,f,g,h,i=0;if(n.isFunction(a))return this.each(function(b){n(this).addClass(a.call(this,b,fb(this)))});if(\"string\"==typeof a&&a){b=a.match(G)||[];while(c=this[i++])if(e=fb(c),d=1===c.nodeType&&(\" \"+e+\" \").replace(eb,\" \")){g=0;while(f=b[g++])d.indexOf(\" \"+f+\" \")<0&&(d+=f+\" \");h=n.trim(d),e!==h&&c.setAttribute(\"class\",h)}}return this},removeClass:function(a){var b,c,d,e,f,g,h,i=0;if(n.isFunction(a))return this.each(function(b){n(this).removeClass(a.call(this,b,fb(this)))});if(!arguments.length)return this.attr(\"class\",\"\");if(\"string\"==typeof a&&a){b=a.match(G)||[];while(c=this[i++])if(e=fb(c),d=1===c.nodeType&&(\" \"+e+\" \").replace(eb,\" \")){g=0;while(f=b[g++])while(d.indexOf(\" \"+f+\" \")>-1)d=d.replace(\" \"+f+\" \",\" \");h=n.trim(d),e!==h&&c.setAttribute(\"class\",h)}}return this},toggleClass:function(a,b){var c=typeof a;return\"boolean\"==typeof b&&\"string\"===c?b?this.addClass(a):this.removeClass(a):n.isFunction(a)?this.each(function(c){n(this).toggleClass(a.call(this,c,fb(this),b),b)}):this.each(function(){var b,d,e,f;if(\"string\"===c){d=0,e=n(this),f=a.match(G)||[];while(b=f[d++])e.hasClass(b)?e.removeClass(b):e.addClass(b)}else(void 0===a||\"boolean\"===c)&&(b=fb(this),b&&N.set(this,\"__className__\",b),this.setAttribute&&this.setAttribute(\"class\",b||a===!1?\"\":N.get(this,\"__className__\")||\"\"))})},hasClass:function(a){var b,c,d=0;b=\" \"+a+\" \";while(c=this[d++])if(1===c.nodeType&&(\" \"+fb(c)+\" \").replace(eb,\" \").indexOf(b)>-1)return!0;return!1}});var gb=/\\r/g;n.fn.extend({val:function(a){var b,c,d,e=this[0];{if(arguments.length)return d=n.isFunction(a),this.each(function(c){var e;1===this.nodeType&&(e=d?a.call(this,c,n(this).val()):a,null==e?e=\"\":\"number\"==typeof e?e+=\"\":n.isArray(e)&&(e=n.map(e,function(a){return null==a?\"\":a+\"\"})),b=n.valHooks[this.type]||n.valHooks[this.nodeName.toLowerCase()],b&&\"set\"in b&&void 0!==b.set(this,e,\"value\")||(this.value=e))});if(e)return b=n.valHooks[e.type]||n.valHooks[e.nodeName.toLowerCase()],b&&\"get\"in b&&void 0!==(c=b.get(e,\"value\"))?c:(c=e.value,\"string\"==typeof c?c.replace(gb,\"\"):null==c?\"\":c)}}}),n.extend({valHooks:{option:{get:function(a){return n.trim(a.value)}},select:{get:function(a){for(var b,c,d=a.options,e=a.selectedIndex,f=\"select-one\"===a.type||0>e,g=f?null:[],h=f?e+1:d.length,i=0>e?h:f?e:0;h>i;i++)if(c=d[i],(c.selected||i===e)&&(l.optDisabled?!c.disabled:null===c.getAttribute(\"disabled\"))&&(!c.parentNode.disabled||!n.nodeName(c.parentNode,\"optgroup\"))){if(b=n(c).val(),f)return b;g.push(b)}return g},set:function(a,b){var c,d,e=a.options,f=n.makeArray(b),g=e.length;while(g--)d=e[g],(d.selected=n.inArray(n.valHooks.option.get(d),f)>-1)&&(c=!0);return c||(a.selectedIndex=-1),f}}}}),n.each([\"radio\",\"checkbox\"],function(){n.valHooks[this]={set:function(a,b){return n.isArray(b)?a.checked=n.inArray(n(a).val(),b)>-1:void 0}},l.checkOn||(n.valHooks[this].get=function(a){return null===a.getAttribute(\"value\")?\"on\":a.value})});var hb=/^(?:focusinfocus|focusoutblur)$/;n.extend(n.event,{trigger:function(b,c,e,f){var g,h,i,j,l,m,o,p=[e||d],q=k.call(b,\"type\")?b.type:b,r=k.call(b,\"namespace\")?b.namespace.split(\".\"):[];if(h=i=e=e||d,3!==e.nodeType&&8!==e.nodeType&&!hb.test(q+n.event.triggered)&&(q.indexOf(\".\")>-1&&(r=q.split(\".\"),q=r.shift(),r.sort()),l=q.indexOf(\":\")<0&&\"on\"+q,b=b[n.expando]?b:new n.Event(q,\"object\"==typeof b&&b),b.isTrigger=f?2:3,b.namespace=r.join(\".\"),b.rnamespace=b.namespace?new RegExp(\"(^|\\\\.)\"+r.join(\"\\\\.(?:.*\\\\.|)\")+\"(\\\\.|$)\"):null,b.result=void 0,b.target||(b.target=e),c=null==c?[b]:n.makeArray(c,[b]),o=n.event.special[q]||{},f||!o.trigger||o.trigger.apply(e,c)!==!1)){if(!f&&!o.noBubble&&!n.isWindow(e)){for(j=o.delegateType||q,hb.test(j+q)||(h=h.parentNode);h;h=h.parentNode)p.push(h),i=h;i===(e.ownerDocument||d)&&p.push(i.defaultView||i.parentWindow||a)}g=0;while((h=p[g++])&&!b.isPropagationStopped())b.type=g>1?j:o.bindType||q,m=(N.get(h,\"events\")||{})[b.type]&&N.get(h,\"handle\"),m&&m.apply(h,c),m=l&&h[l],m&&m.apply&&L(h)&&(b.result=m.apply(h,c),b.result===!1&&b.preventDefault());return b.type=q,f||b.isDefaultPrevented()||o._default&&o._default.apply(p.pop(),c)!==!1||!L(e)||l&&n.isFunction(e[q])&&!n.isWindow(e)&&(i=e[l],i&&(e[l]=null),n.event.triggered=q,e[q](),n.event.triggered=void 0,i&&(e[l]=i)),b.result}},simulate:function(a,b,c){var d=n.extend(new n.Event,c,{type:a,isSimulated:!0});n.event.trigger(d,null,b),d.isDefaultPrevented()&&c.preventDefault()}}),n.fn.extend({trigger:function(a,b){return this.each(function(){n.event.trigger(a,b,this)})},triggerHandler:function(a,b){var c=this[0];return c?n.event.trigger(a,b,c,!0):void 0}}),n.each(\"blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu\".split(\" \"),function(a,b){n.fn[b]=function(a,c){return arguments.length>0?this.on(b,null,a,c):this.trigger(b)}}),n.fn.extend({hover:function(a,b){return this.mouseenter(a).mouseleave(b||a)}}),l.focusin=\"onfocusin\"in a,l.focusin||n.each({focus:\"focusin\",blur:\"focusout\"},function(a,b){var c=function(a){n.event.simulate(b,a.target,n.event.fix(a))};n.event.special[b]={setup:function(){var d=this.ownerDocument||this,e=N.access(d,b);e||d.addEventListener(a,c,!0),N.access(d,b,(e||0)+1)},teardown:function(){var d=this.ownerDocument||this,e=N.access(d,b)-1;e?N.access(d,b,e):(d.removeEventListener(a,c,!0),N.remove(d,b))}}});var ib=a.location,jb=n.now(),kb=/\\?/;n.parseJSON=function(a){return JSON.parse(a+\"\")},n.parseXML=function(b){var c;if(!b||\"string\"!=typeof b)return null;try{c=(new a.DOMParser).parseFromString(b,\"text/xml\")}catch(d){c=void 0}return(!c||c.getElementsByTagName(\"parsererror\").length)&&n.error(\"Invalid XML: \"+b),c};var lb=/#.*$/,mb=/([?&])_=[^&]*/,nb=/^(.*?):[ \\t]*([^\\r\\n]*)$/gm,ob=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,pb=/^(?:GET|HEAD)$/,qb=/^\\/\\//,rb={},sb={},tb=\"*/\".concat(\"*\"),ub=d.createElement(\"a\");ub.href=ib.href;function vb(a){return function(b,c){\"string\"!=typeof b&&(c=b,b=\"*\");var d,e=0,f=b.toLowerCase().match(G)||[];if(n.isFunction(c))while(d=f[e++])\"+\"===d[0]?(d=d.slice(1)||\"*\",(a[d]=a[d]||[]).unshift(c)):(a[d]=a[d]||[]).push(c)}}function wb(a,b,c,d){var e={},f=a===sb;function g(h){var i;return e[h]=!0,n.each(a[h]||[],function(a,h){var j=h(b,c,d);return\"string\"!=typeof j||f||e[j]?f?!(i=j):void 0:(b.dataTypes.unshift(j),g(j),!1)}),i}return g(b.dataTypes[0])||!e[\"*\"]&&g(\"*\")}function xb(a,b){var c,d,e=n.ajaxSettings.flatOptions||{};for(c in b)void 0!==b[c]&&((e[c]?a:d||(d={}))[c]=b[c]);return d&&n.extend(!0,a,d),a}function yb(a,b,c){var d,e,f,g,h=a.contents,i=a.dataTypes;while(\"*\"===i[0])i.shift(),void 0===d&&(d=a.mimeType||b.getResponseHeader(\"Content-Type\"));if(d)for(e in h)if(h[e]&&h[e].test(d)){i.unshift(e);break}if(i[0]in c)f=i[0];else{for(e in c){if(!i[0]||a.converters[e+\" \"+i[0]]){f=e;break}g||(g=e)}f=f||g}return f?(f!==i[0]&&i.unshift(f),c[f]):void 0}function zb(a,b,c,d){var e,f,g,h,i,j={},k=a.dataTypes.slice();if(k[1])for(g in a.converters)j[g.toLowerCase()]=a.converters[g];f=k.shift();while(f)if(a.responseFields[f]&&(c[a.responseFields[f]]=b),!i&&d&&a.dataFilter&&(b=a.dataFilter(b,a.dataType)),i=f,f=k.shift())if(\"*\"===f)f=i;else if(\"*\"!==i&&i!==f){if(g=j[i+\" \"+f]||j[\"* \"+f],!g)for(e in j)if(h=e.split(\" \"),h[1]===f&&(g=j[i+\" \"+h[0]]||j[\"* \"+h[0]])){g===!0?g=j[e]:j[e]!==!0&&(f=h[0],k.unshift(h[1]));break}if(g!==!0)if(g&&a[\"throws\"])b=g(b);else try{b=g(b)}catch(l){return{state:\"parsererror\",error:g?l:\"No conversion from \"+i+\" to \"+f}}}return{state:\"success\",data:b}}n.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:ib.href,type:\"GET\",isLocal:ob.test(ib.protocol),global:!0,processData:!0,async:!0,contentType:\"application/x-www-form-urlencoded; charset=UTF-8\",accepts:{\"*\":tb,text:\"text/plain\",html:\"text/html\",xml:\"application/xml, text/xml\",json:\"application/json, text/javascript\"},contents:{xml:/\\bxml\\b/,html:/\\bhtml/,json:/\\bjson\\b/},responseFields:{xml:\"responseXML\",text:\"responseText\",json:\"responseJSON\"},converters:{\"* text\":String,\"text html\":!0,\"text json\":n.parseJSON,\"text xml\":n.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(a,b){return b?xb(xb(a,n.ajaxSettings),b):xb(n.ajaxSettings,a)},ajaxPrefilter:vb(rb),ajaxTransport:vb(sb),ajax:function(b,c){\"object\"==typeof b&&(c=b,b=void 0),c=c||{};var e,f,g,h,i,j,k,l,m=n.ajaxSetup({},c),o=m.context||m,p=m.context&&(o.nodeType||o.jquery)?n(o):n.event,q=n.Deferred(),r=n.Callbacks(\"once memory\"),s=m.statusCode||{},t={},u={},v=0,w=\"canceled\",x={readyState:0,getResponseHeader:function(a){var b;if(2===v){if(!h){h={};while(b=nb.exec(g))h[b[1].toLowerCase()]=b[2]}b=h[a.toLowerCase()]}return null==b?null:b},getAllResponseHeaders:function(){return 2===v?g:null},setRequestHeader:function(a,b){var c=a.toLowerCase();return v||(a=u[c]=u[c]||a,t[a]=b),this},overrideMimeType:function(a){return v||(m.mimeType=a),this},statusCode:function(a){var b;if(a)if(2>v)for(b in a)s[b]=[s[b],a[b]];else x.always(a[x.status]);return this},abort:function(a){var b=a||w;return e&&e.abort(b),z(0,b),this}};if(q.promise(x).complete=r.add,x.success=x.done,x.error=x.fail,m.url=((b||m.url||ib.href)+\"\").replace(lb,\"\").replace(qb,ib.protocol+\"//\"),m.type=c.method||c.type||m.method||m.type,m.dataTypes=n.trim(m.dataType||\"*\").toLowerCase().match(G)||[\"\"],null==m.crossDomain){j=d.createElement(\"a\");try{j.href=m.url,j.href=j.href,m.crossDomain=ub.protocol+\"//\"+ub.host!=j.protocol+\"//\"+j.host}catch(y){m.crossDomain=!0}}if(m.data&&m.processData&&\"string\"!=typeof m.data&&(m.data=n.param(m.data,m.traditional)),wb(rb,m,c,x),2===v)return x;k=n.event&&m.global,k&&0===n.active++&&n.event.trigger(\"ajaxStart\"),m.type=m.type.toUpperCase(),m.hasContent=!pb.test(m.type),f=m.url,m.hasContent||(m.data&&(f=m.url+=(kb.test(f)?\"&\":\"?\")+m.data,delete m.data),m.cache===!1&&(m.url=mb.test(f)?f.replace(mb,\"$1_=\"+jb++):f+(kb.test(f)?\"&\":\"?\")+\"_=\"+jb++)),m.ifModified&&(n.lastModified[f]&&x.setRequestHeader(\"If-Modified-Since\",n.lastModified[f]),n.etag[f]&&x.setRequestHeader(\"If-None-Match\",n.etag[f])),(m.data&&m.hasContent&&m.contentType!==!1||c.contentType)&&x.setRequestHeader(\"Content-Type\",m.contentType),x.setRequestHeader(\"Accept\",m.dataTypes[0]&&m.accepts[m.dataTypes[0]]?m.accepts[m.dataTypes[0]]+(\"*\"!==m.dataTypes[0]?\", \"+tb+\"; q=0.01\":\"\"):m.accepts[\"*\"]);for(l in m.headers)x.setRequestHeader(l,m.headers[l]);if(m.beforeSend&&(m.beforeSend.call(o,x,m)===!1||2===v))return x.abort();w=\"abort\";for(l in{success:1,error:1,complete:1})x[l](m[l]);if(e=wb(sb,m,c,x)){if(x.readyState=1,k&&p.trigger(\"ajaxSend\",[x,m]),2===v)return x;m.async&&m.timeout>0&&(i=a.setTimeout(function(){x.abort(\"timeout\")},m.timeout));try{v=1,e.send(t,z)}catch(y){if(!(2>v))throw y;z(-1,y)}}else z(-1,\"No Transport\");function z(b,c,d,h){var j,l,t,u,w,y=c;2!==v&&(v=2,i&&a.clearTimeout(i),e=void 0,g=h||\"\",x.readyState=b>0?4:0,j=b>=200&&300>b||304===b,d&&(u=yb(m,x,d)),u=zb(m,u,x,j),j?(m.ifModified&&(w=x.getResponseHeader(\"Last-Modified\"),w&&(n.lastModified[f]=w),w=x.getResponseHeader(\"etag\"),w&&(n.etag[f]=w)),204===b||\"HEAD\"===m.type?y=\"nocontent\":304===b?y=\"notmodified\":(y=u.state,l=u.data,t=u.error,j=!t)):(t=y,(b||!y)&&(y=\"error\",0>b&&(b=0))),x.status=b,x.statusText=(c||y)+\"\",j?q.resolveWith(o,[l,y,x]):q.rejectWith(o,[x,y,t]),x.statusCode(s),s=void 0,k&&p.trigger(j?\"ajaxSuccess\":\"ajaxError\",[x,m,j?l:t]),r.fireWith(o,[x,y]),k&&(p.trigger(\"ajaxComplete\",[x,m]),--n.active||n.event.trigger(\"ajaxStop\")))}return x},getJSON:function(a,b,c){return n.get(a,b,c,\"json\")},getScript:function(a,b){return n.get(a,void 0,b,\"script\")}}),n.each([\"get\",\"post\"],function(a,b){n[b]=function(a,c,d,e){return n.isFunction(c)&&(e=e||d,d=c,c=void 0),n.ajax(n.extend({url:a,type:b,dataType:e,data:c,success:d},n.isPlainObject(a)&&a))}}),n._evalUrl=function(a){return n.ajax({url:a,type:\"GET\",dataType:\"script\",async:!1,global:!1,\"throws\":!0})},n.fn.extend({wrapAll:function(a){var b;return n.isFunction(a)?this.each(function(b){n(this).wrapAll(a.call(this,b))}):(this[0]&&(b=n(a,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&b.insertBefore(this[0]),b.map(function(){var a=this;while(a.firstElementChild)a=a.firstElementChild;return a}).append(this)),this)},wrapInner:function(a){return n.isFunction(a)?this.each(function(b){n(this).wrapInner(a.call(this,b))}):this.each(function(){var b=n(this),c=b.contents();c.length?c.wrapAll(a):b.append(a)})},wrap:function(a){var b=n.isFunction(a);return this.each(function(c){n(this).wrapAll(b?a.call(this,c):a)})},unwrap:function(){return this.parent().each(function(){n.nodeName(this,\"body\")||n(this).replaceWith(this.childNodes)}).end()}}),n.expr.filters.hidden=function(a){return!n.expr.filters.visible(a)},n.expr.filters.visible=function(a){return a.offsetWidth>0||a.offsetHeight>0||a.getClientRects().length>0};var Ab=/%20/g,Bb=/\\[\\]$/,Cb=/\\r?\\n/g,Db=/^(?:submit|button|image|reset|file)$/i,Eb=/^(?:input|select|textarea|keygen)/i;function Fb(a,b,c,d){var e;if(n.isArray(b))n.each(b,function(b,e){c||Bb.test(a)?d(a,e):Fb(a+\"[\"+(\"object\"==typeof e&&null!=e?b:\"\")+\"]\",e,c,d)});else if(c||\"object\"!==n.type(b))d(a,b);else for(e in b)Fb(a+\"[\"+e+\"]\",b[e],c,d)}n.param=function(a,b){var c,d=[],e=function(a,b){b=n.isFunction(b)?b():null==b?\"\":b,d[d.length]=encodeURIComponent(a)+\"=\"+encodeURIComponent(b)};if(void 0===b&&(b=n.ajaxSettings&&n.ajaxSettings.traditional),n.isArray(a)||a.jquery&&!n.isPlainObject(a))n.each(a,function(){e(this.name,this.value)});else for(c in a)Fb(c,a[c],b,e);return d.join(\"&\").replace(Ab,\"+\")},n.fn.extend({serialize:function(){return n.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var a=n.prop(this,\"elements\");return a?n.makeArray(a):this}).filter(function(){var a=this.type;return this.name&&!n(this).is(\":disabled\")&&Eb.test(this.nodeName)&&!Db.test(a)&&(this.checked||!X.test(a))}).map(function(a,b){var c=n(this).val();return null==c?null:n.isArray(c)?n.map(c,function(a){return{name:b.name,value:a.replace(Cb,\"\\r\\n\")}}):{name:b.name,value:c.replace(Cb,\"\\r\\n\")}}).get()}}),n.ajaxSettings.xhr=function(){try{return new a.XMLHttpRequest}catch(b){}};var Gb={0:200,1223:204},Hb=n.ajaxSettings.xhr();l.cors=!!Hb&&\"withCredentials\"in Hb,l.ajax=Hb=!!Hb,n.ajaxTransport(function(b){var c,d;return l.cors||Hb&&!b.crossDomain?{send:function(e,f){var g,h=b.xhr();if(h.open(b.type,b.url,b.async,b.username,b.password),b.xhrFields)for(g in b.xhrFields)h[g]=b.xhrFields[g];b.mimeType&&h.overrideMimeType&&h.overrideMimeType(b.mimeType),b.crossDomain||e[\"X-Requested-With\"]||(e[\"X-Requested-With\"]=\"XMLHttpRequest\");for(g in e)h.setRequestHeader(g,e[g]);c=function(a){return function(){c&&(c=d=h.onload=h.onerror=h.onabort=h.onreadystatechange=null,\"abort\"===a?h.abort():\"error\"===a?\"number\"!=typeof h.status?f(0,\"error\"):f(h.status,h.statusText):f(Gb[h.status]||h.status,h.statusText,\"text\"!==(h.responseType||\"text\")||\"string\"!=typeof h.responseText?{binary:h.response}:{text:h.responseText},h.getAllResponseHeaders()))}},h.onload=c(),d=h.onerror=c(\"error\"),void 0!==h.onabort?h.onabort=d:h.onreadystatechange=function(){4===h.readyState&&a.setTimeout(function(){c&&d()})},c=c(\"abort\");try{h.send(b.hasContent&&b.data||null)}catch(i){if(c)throw i}},abort:function(){c&&c()}}:void 0}),n.ajaxSetup({accepts:{script:\"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript\"},contents:{script:/\\b(?:java|ecma)script\\b/},converters:{\"text script\":function(a){return n.globalEval(a),a}}}),n.ajaxPrefilter(\"script\",function(a){void 0===a.cache&&(a.cache=!1),a.crossDomain&&(a.type=\"GET\")}),n.ajaxTransport(\"script\",function(a){if(a.crossDomain){var b,c;return{send:function(e,f){b=n(\"<script>\").prop({charset:a.scriptCharset,src:a.url}).on(\"load error\",c=function(a){b.remove(),c=null,a&&f(\"error\"===a.type?404:200,a.type)}),d.head.appendChild(b[0])},abort:function(){c&&c()}}}});var Ib=[],Jb=/(=)\\?(?=&|$)|\\?\\?/;n.ajaxSetup({jsonp:\"callback\",jsonpCallback:function(){var a=Ib.pop()||n.expando+\"_\"+jb++;return this[a]=!0,a}}),n.ajaxPrefilter(\"json jsonp\",function(b,c,d){var e,f,g,h=b.jsonp!==!1&&(Jb.test(b.url)?\"url\":\"string\"==typeof b.data&&0===(b.contentType||\"\").indexOf(\"application/x-www-form-urlencoded\")&&Jb.test(b.data)&&\"data\");return h||\"jsonp\"===b.dataTypes[0]?(e=b.jsonpCallback=n.isFunction(b.jsonpCallback)?b.jsonpCallback():b.jsonpCallback,h?b[h]=b[h].replace(Jb,\"$1\"+e):b.jsonp!==!1&&(b.url+=(kb.test(b.url)?\"&\":\"?\")+b.jsonp+\"=\"+e),b.converters[\"script json\"]=function(){return g||n.error(e+\" was not called\"),g[0]},b.dataTypes[0]=\"json\",f=a[e],a[e]=function(){g=arguments},d.always(function(){void 0===f?n(a).removeProp(e):a[e]=f,b[e]&&(b.jsonpCallback=c.jsonpCallback,Ib.push(e)),g&&n.isFunction(f)&&f(g[0]),g=f=void 0}),\"script\"):void 0}),l.createHTMLDocument=function(){var a=d.implementation.createHTMLDocument(\"\").body;return a.innerHTML=\"<form></form><form></form>\",2===a.childNodes.length}(),n.parseHTML=function(a,b,c){if(!a||\"string\"!=typeof a)return null;\"boolean\"==typeof b&&(c=b,b=!1),b=b||(l.createHTMLDocument?d.implementation.createHTMLDocument(\"\"):d);var e=x.exec(a),f=!c&&[];return e?[b.createElement(e[1])]:(e=ca([a],b,f),f&&f.length&&n(f).remove(),n.merge([],e.childNodes))};var Kb=n.fn.load;n.fn.load=function(a,b,c){if(\"string\"!=typeof a&&Kb)return Kb.apply(this,arguments);var d,e,f,g=this,h=a.indexOf(\" \");return h>-1&&(d=n.trim(a.slice(h)),a=a.slice(0,h)),n.isFunction(b)?(c=b,b=void 0):b&&\"object\"==typeof b&&(e=\"POST\"),g.length>0&&n.ajax({url:a,type:e||\"GET\",dataType:\"html\",data:b}).done(function(a){f=arguments,g.html(d?n(\"<div>\").append(n.parseHTML(a)).find(d):a)}).always(c&&function(a,b){g.each(function(){c.apply(g,f||[a.responseText,b,a])})}),this},n.each([\"ajaxStart\",\"ajaxStop\",\"ajaxComplete\",\"ajaxError\",\"ajaxSuccess\",\"ajaxSend\"],function(a,b){n.fn[b]=function(a){return this.on(b,a)}}),n.expr.filters.animated=function(a){return n.grep(n.timers,function(b){return a===b.elem}).length};function Lb(a){return n.isWindow(a)?a:9===a.nodeType&&a.defaultView}n.offset={setOffset:function(a,b,c){var d,e,f,g,h,i,j,k=n.css(a,\"position\"),l=n(a),m={};\"static\"===k&&(a.style.position=\"relative\"),h=l.offset(),f=n.css(a,\"top\"),i=n.css(a,\"left\"),j=(\"absolute\"===k||\"fixed\"===k)&&(f+i).indexOf(\"auto\")>-1,j?(d=l.position(),g=d.top,e=d.left):(g=parseFloat(f)||0,e=parseFloat(i)||0),n.isFunction(b)&&(b=b.call(a,c,n.extend({},h))),null!=b.top&&(m.top=b.top-h.top+g),null!=b.left&&(m.left=b.left-h.left+e),\"using\"in b?b.using.call(a,m):l.css(m)}},n.fn.extend({offset:function(a){if(arguments.length)return void 0===a?this:this.each(function(b){n.offset.setOffset(this,a,b)});var b,c,d=this[0],e={top:0,left:0},f=d&&d.ownerDocument;if(f)return b=f.documentElement,n.contains(b,d)?(e=d.getBoundingClientRect(),c=Lb(f),{top:e.top+c.pageYOffset-b.clientTop,left:e.left+c.pageXOffset-b.clientLeft}):e},position:function(){if(this[0]){var a,b,c=this[0],d={top:0,left:0};return\"fixed\"===n.css(c,\"position\")?b=c.getBoundingClientRect():(a=this.offsetParent(),b=this.offset(),n.nodeName(a[0],\"html\")||(d=a.offset()),d.top+=n.css(a[0],\"borderTopWidth\",!0)-a.scrollTop(),d.left+=n.css(a[0],\"borderLeftWidth\",!0)-a.scrollLeft()),{top:b.top-d.top-n.css(c,\"marginTop\",!0),left:b.left-d.left-n.css(c,\"marginLeft\",!0)}}},offsetParent:function(){return this.map(function(){var a=this.offsetParent;while(a&&\"static\"===n.css(a,\"position\"))a=a.offsetParent;return a||Ea})}}),n.each({scrollLeft:\"pageXOffset\",scrollTop:\"pageYOffset\"},function(a,b){var c=\"pageYOffset\"===b;n.fn[a]=function(d){return K(this,function(a,d,e){var f=Lb(a);return void 0===e?f?f[b]:a[d]:void(f?f.scrollTo(c?f.pageXOffset:e,c?e:f.pageYOffset):a[d]=e)},a,d,arguments.length)}}),n.each([\"top\",\"left\"],function(a,b){n.cssHooks[b]=Ga(l.pixelPosition,function(a,c){return c?(c=Fa(a,b),Ba.test(c)?n(a).position()[b]+\"px\":c):void 0})}),n.each({Height:\"height\",Width:\"width\"},function(a,b){n.each({padding:\"inner\"+a,content:b,\"\":\"outer\"+a},function(c,d){n.fn[d]=function(d,e){var f=arguments.length&&(c||\"boolean\"!=typeof d),g=c||(d===!0||e===!0?\"margin\":\"border\");return K(this,function(b,c,d){var e;return n.isWindow(b)?b.document.documentElement[\"client\"+a]:9===b.nodeType?(e=b.documentElement,Math.max(b.body[\"scroll\"+a],e[\"scroll\"+a],b.body[\"offset\"+a],e[\"offset\"+a],e[\"client\"+a])):void 0===d?n.css(b,c,g):n.style(b,c,d,g)},b,f?d:void 0,f,null)}})}),n.fn.extend({bind:function(a,b,c){return this.on(a,null,b,c)},unbind:function(a,b){return this.off(a,null,b)},delegate:function(a,b,c,d){return this.on(b,a,c,d)},undelegate:function(a,b,c){return 1===arguments.length?this.off(a,\"**\"):this.off(b,a||\"**\",c)},size:function(){return this.length}}),n.fn.andSelf=n.fn.addBack,\"function\"==typeof define&&define.amd&&define(\"jquery\",[],function(){return n});var Mb=a.jQuery,Nb=a.$;return n.noConflict=function(b){return a.$===n&&(a.$=Nb),b&&a.jQuery===n&&(a.jQuery=Mb),n},b||(a.jQuery=a.$=n),n});\n","Sendinblue_Sendinblue/js/components/new-tag.js":"/**\n * Copyright \u00a9 2022 Ihor Vansach (ihor@magefan.com). All rights reserved.\n * See LICENSE.txt for license details (http://opensource.org/licenses/osl-3.0.php).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/ui-select'\n], function (_, Select) {\n    'use strict';\n\n    function flatten(a, s, cr) {\n        var i = 0, c;\n        a = _.compact(a);\n        cr = cr || [];\n        for (i; i < a.length; i++) {\n            cr.push(a[i]);\n            if (a[i].hasOwnProperty(s)) {\n                c = a[i][s];\n                delete a[i][s];\n                flatten.call(this, c, s, cr);\n            }\n        }\n        return cr;\n    }\n\n    return Select.extend({\n\n        /**\n         * Parse data and set it to options.\n         *\n         * @param {Object} data - Response data object.\n         * @returns {Object}\n         */\n        setParsed: function (data) {\n            var option = this.parseData(data),\n                copyOptionsTree\n            if (data.error) {\n                return this;\n            }\n\n            this.options([]);\n            if (!option.parent) {\n                this.cacheOptions.tree.push(option);\n                copyOptionsTree = JSON.parse(JSON.stringify(this.cacheOptions.tree));\n                this.cacheOptions.plain = flatten(copyOptionsTree, this.separator);\n                this.options(this.cacheOptions.tree);\n            } else {\n                this.setOption(option);\n            }\n            this.set('newOption', option);\n        },\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': \"1\",\n                level: 0,\n                value: data.model['tag_id'],\n                label: data.model['title'],\n                parent: 0\n            };\n        }\n    });\n});\n","Sendinblue_Sendinblue/js/components/new-category.js":"/**\n * Copyright \u00a9 2022 Ihor Vansach (ihor@magefan.com). All rights reserved.\n * See LICENSE.txt for license details (http://opensource.org/licenses/osl-3.0.php).\n *\n * Glory to Ukraine! Glory to the heroes!\n */\n\ndefine([\n    'Magefan_Blog/js/components/new-tag'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': data.model['is_active'],\n                level: data.model['level'],\n                value: data.model['category_id'],\n                label: data.model['title'],\n                parent: data.model['parent_id']\n            };\n        }\n    });\n});\n","Magento_Theme/js/sortable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * JQuery UI Widget declaration: 'mage.sortable'\n *\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    /**\n     * Widget panel\n     */\n    $.widget('mage.sortable', $.ui.sortable, {\n        options: {\n            moveUpEvent:   'moveUp',\n            moveDownEvent: 'moveDown'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this._super();\n            this.initButtons();\n            this.bind();\n        },\n\n        /**\n         * Init buttons.\n         */\n        initButtons: function () {\n            this.element.find('input.up').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveUpEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n            this.element.find('input.down').on('click', $.proxy(function (event) {\n                $('body').trigger(this.options.moveDownEvent, {\n                    item: $(event.target).parent('li')\n                });\n            }, this));\n        },\n\n        /**\n         * Bind.\n         */\n        bind: function () {\n            var $body = $('body');\n\n            $body.on(this.options.moveUpEvent, $.proxy(this._onMoveUp, this));\n            $body.on(this.options.moveDownEvent, $.proxy(this._onMoveDown, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveUp: function (event, data) {\n            data.item.insertBefore(data.item.prev());\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onMoveDown: function (event, data) {\n            data.item.insertAfter(data.item.next());\n        }\n    });\n\n    return $.mage.sortable;\n});\n","Magento_Theme/js/bootstrap.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery/fileUploader/jquery.fileupload-ui',\n    'mage/adminhtml/browser',\n    'Magento_Theme/js/form'\n]);\n","Magento_Theme/js/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'prototype'\n], function () {\n    'use strict';\n\n    /**\n     * @param {*} selected\n     * @param {Object} defaultsById\n     */\n    function parentThemeOnChange(selected, defaultsById) {\n        var statusBar = $$('.tab-item-link')[0],\n            isChanged = statusBar.hasClassName('changed'),\n            defaults;\n\n        if (!isChanged) {\n            defaults = defaultsById[selected];\n            $('theme_title').value = defaults['theme_title'];\n        }\n    }\n\n    window.parentThemeOnChange = parentThemeOnChange;\n});\n","Magento_Theme/js/custom-js-list.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('theme.themeJsList', {\n        options: {\n            templateId: null,\n            emptyTemplateId: null,\n            refreshFileListEvent: null,\n            prefixItemId: '',\n            suffixItemId: ''\n        },\n\n        /**\n         * Initialize widget\n         *\n         * @protected\n         */\n        _create: function () {\n            this._bind();\n        },\n\n        /**\n         * Bind event handlers\n         *\n         * @protected\n         */\n        _bind: function () {\n            $('body').on(this.options.refreshFileListEvent, $.proxy(this._onRefreshList, this));\n        },\n\n        /**\n         * Render js files list\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @protected\n         */\n        _onRefreshList: function (event, data) {\n            $(this.element).html('');\n\n            if (data.jsList.length) {\n                this._renderList(data.jsList);\n            } else {\n                this._renderEmptyList();\n            }\n        },\n\n        /**\n         * Get item js list id\n         *\n         * @param {*} fileId\n         * @return {String}\n         * @protected\n         */\n        _getItemId: function (fileId) {\n            return this.options.prefixItemId + fileId + this.options.suffixItemId;\n        },\n\n        /**\n         * Render js list\n         *\n         * @param {Array} jsList\n         * @protected\n         */\n        _renderList: function (jsList) {\n            var itemTmpl,\n                index,\n                tmpl;\n\n            for (index = 0; index < jsList.length; index++) {\n                itemTmpl = $('<li></li>').html($(this.options.templateId).html());\n\n                $(itemTmpl).attr('class', $(this.options.templateId).attr('class'));\n\n                itemTmpl.attr('id', this._getItemId(jsList[index].id));\n\n                tmpl = mageTemplate(itemTmpl.html(), {\n                    data: jsList[index]\n                });\n\n                itemTmpl.html(tmpl);\n\n                itemTmpl.removeClass('no-display');\n                itemTmpl.appendTo(this.element);\n            }\n        },\n\n        /**\n         * Set empty js list\n         *\n         * @protected\n         */\n        _renderEmptyList: function () {\n            var itemTmpl = $('<li></li>').html($(this.options.emptyTemplateId).html());\n\n            $(itemTmpl).attr('class', $(this.options.emptyTemplateId).attr('class'));\n\n            itemTmpl.attr('id', 'empty-js-list');\n            itemTmpl.removeClass('no-display');\n            itemTmpl.appendTo(this.element);\n        }\n    });\n});\n","Magento_Theme/js/form/component/robots-reset-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'uiRegistry'\n], function (Button, registry) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            customInstructionField: '${ $.parentName }.custom_instructions',\n            label: '',\n            buttonTpl: 'Magento_Theme/form/element/button'\n        },\n\n        /**\n         * @private\n         * @param {String} json\n         * @return {String}\n         */\n        _parseJson: function (json) {\n            return JSON.parse(json);\n        },\n\n        /**\n         * @param {String} defaultRobotsTxt\n         */\n        reset: function (defaultRobotsTxt) {\n            var customInstructions = registry.get(this.customInstructionField);\n\n            if (customInstructions) {\n                customInstructions.set('value', this._parseJson(defaultRobotsTxt));\n            }\n        }\n    });\n});\n","Magento_AdobeStockAdminUi/js/connection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiComponent',\n    'jquery'\n], function (ko, Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockAdminUi/connection',\n            connectionFailedMessage: 'Connection test failed.',\n            emptyApiKeyMessage: 'Please fill the \"API Key (Client ID)\" field for a connection test',\n            apiKeyInputId: 'system_adobe_stock_integration_api_key',\n            url: '',\n            success: false,\n            message: '',\n            visible: false\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'success',\n                    'message',\n                    'visible'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.messageClass = ko.computed(function () {\n                return 'message-validation message message-' + (this.success() ? 'success' : 'error');\n            }, this);\n\n            if (!this.success()) {\n                this.showMessage(false, this.connectionFailedMessage);\n            }\n        },\n\n        /**\n         * @param {bool} success\n         * @param {String} message\n         */\n        showMessage: function (success, message) {\n            this.message(message);\n            this.success(success);\n            this.visible(true);\n        },\n\n        /**\n         * Send request to server to test connection to Adobe Stock API and display the result\n         */\n        testConnection: function () {\n            var apiKey = document.getElementById(this.apiKeyInputId).value;\n\n            if (apiKey.length === 0) {\n                this.showMessage(false, this.emptyApiKeyMessage);\n\n                return;\n            }\n\n            this.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.url,\n                dataType: 'json',\n                data: {\n                    'api_key': apiKey\n                },\n                success: function (response) {\n                    this.showMessage(response.success === true, response.message);\n                }.bind(this),\n                error: function () {\n                    this.showMessage(false, this.connectionFailedMessage);\n                }.bind(this)\n            });\n        }\n    });\n});\n","Smile_ElasticsuiteCatalogOptimizer/js/components/form/optimizer/fieldset-visibility.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalogOptimizer\n * @author    Fanny DECLERCK <fadec@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\ndefine(['Magento_Ui/js/form/components/fieldset', 'underscore'], function(Fieldset, _) {\n    return Fieldset.extend({\n        defaults: {\n            displayedForValues : {}\n        },\n        initialize: function() {\n            this._super();\n            this.observe(['disableChildren']);\n            this.onChange(this.initValue);\n        },\n        onChange: function(value) {\n\n            var isVisible = this.index == value;\n\n            if (Array.isArray(value)) {\n                isVisible = (value.indexOf(this.index) !== -1);\n            }\n\n            if (! _.isEmpty(this.displayedForValues)) {\n                if (Array.isArray(value)) {\n                    isVisible = value.some(function (v) {\n                        return Object.values(this.displayedForValues).indexOf(v) >= 0;\n                    }.bind(this));\n                } else {\n                    isVisible = Object.values(this.displayedForValues).indexOf(value) !== -1;\n                }\n            }\n\n            this.visible(isVisible);\n            this.disableChildren(!isVisible);\n        }\n    });\n});\n","Smile_ElasticsuiteCatalogOptimizer/js/components/form/optimizer/optimizer-preview-type.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteVirtualCategory\n * @author    Aurelien FOUCRET <aurelien.foucret@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/select',\n    'Magento_Ui/js/modal/modal'\n], function (_, uiRegistry, Select, modal) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            displayedForValues : {}\n        },\n\n        /**\n         * Component initializing\n         *\n         * @returns {exports}\n         */\n        initialize: function () {\n            this._super();\n            this.onContainersUpdate(this.searchContainers);\n            this.onUpdate(this.value());\n            return this;\n        },\n\n        /**\n         * Hide/Show fields depending of the type of container selected for previewing.\n         *\n         * @param value Current Value\n         * @returns {*}\n         */\n        onUpdate: function (value) {\n            var isFulltext = this.isFulltextContainer(value);\n\n            var depends = uiRegistry.filter('depends = ' + this.index);\n            depends.forEach(function (element) {\n                if (element.fulltext !== undefined) {\n                    var visible = element.fulltext === isFulltext;\n                    element.setVisible(visible);\n                    if (!visible) {\n                        element.value(null);\n                    }\n                }\n            }, this);\n\n            return this._super();\n        },\n\n        /**\n         * Check if currently selected container is a fulltext one or not.\n         *\n         * @param currentContainer A search request container\n         * @returns {boolean}\n         */\n        isFulltextContainer: function (currentContainer) {\n\n            var result = false;\n\n            this.options().forEach(function (container) {\n                if (currentContainer === container.value) {\n                    result = (container.fulltext !== undefined) && (container.fulltext === true);\n                }\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Prevent previewing containers not currently attached to the optimizer.\n         *\n         * @param searchContainers Current value of search_container field\n         * @returns {void}\n         */\n        onContainersUpdate: function (searchContainers) {\n            var options = [];\n            this.disabled(true);\n\n            if (searchContainers !== undefined && searchContainers.length > 0) {\n                this.initialOptions.forEach(function (option) {\n                    if (! _.isEmpty(this.displayedForValues)) {\n                        if (searchContainers.indexOf(option.value) !== -1\n                            && Object.values(this.displayedForValues).indexOf(option.value) !== -1\n                        ) {\n                            options.push(option);\n                        }\n                    }\n                }, this);\n\n                this.options(options);\n                if (options.length > 0) {\n                    this.disabled(false);\n                }\n            }\n        }\n    });\n});\n","Smile_ElasticsuiteCatalogOptimizer/js/components/form/optimizer/optimizer-preview.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalogOptimizer\n * @author    Romain Ruaud <romain.ruaud@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'jquery',\n    'Smile_ElasticsuiteCatalogOptimizer/js/components/form/optimizer/preview/item',\n    'uiRegistry'\n], function (Component, $, Product, uiRegistry) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            showSpinner: true,\n            template: \"Smile_ElasticsuiteCatalogOptimizer/form/element/optimizer-preview\",\n            refreshFields: {},\n            maxRefreshInterval: 200,\n            listens: {\n                \"${ $.provider }:data.model\" : \"resetPreview\"\n            },\n            imports: {\n                formData: \"${ $.provider }:data\"\n            },\n            messages : {\n                showMore : $.mage.__('Show more')\n            }\n        },\n\n        initialize: function ()\n        {\n            this._super();\n\n            this.baseProducts       = [];\n            this.optimizedProducts  = [];\n            this.countTotalProducts = 0;\n            this.pageSize           = parseInt(this.pageSize, 10);\n            this.currentSize        = this.pageSize;\n\n            this.observe([\n                'baseProducts',\n                'optimizedProducts',\n                'countTotalProducts',\n                'currentSize',\n                'loading',\n                'showSpinner',\n                'queryText'\n            ]);\n        },\n\n        refreshProductList: function () {\n            if (this.refreshRateLimiter !== undefined) {\n                clearTimeout();\n            }\n\n            this.refreshRateLimiter = setTimeout(function () {\n                this.value({queryText : this.queryText()});\n                this.loading(true);\n\n                var formData = this.formData;\n                formData['page_size'] = this.currentSize();\n                formData['search_container_preview'] = formData[this.searchContainerPreviewField];\n\n                if (!this.isFulltext) {\n                    formData['query_text_preview'] = null;\n                }\n\n                $.post(this.loadUrl, this.formData, this.onProductListLoad.bind(this));\n            }.bind(this), this.maxRefreshInterval);\n        },\n\n        onProductListLoad: function (loadedData) {\n\n            if (loadedData.base_products && loadedData.optimized_products) {\n                var baseProducts = loadedData.base_products.map(this.createProduct.bind(this));\n                var optimizedProducts = loadedData.optimized_products.map(this.createProduct.bind(this));\n\n                this.baseProducts(baseProducts);\n                this.optimizedProducts(optimizedProducts);\n                this.countTotalProducts(parseInt(loadedData.size, 10));\n                this.currentSize(Math.max(this.currentSize(), this.baseProducts().length));\n            }\n\n            this.loading(false);\n        },\n\n        createProduct: function (productData) {\n            productData.priceFormat = this.priceFormat;\n            return new Product({data : productData});\n        },\n\n        hasProducts: function () {\n            return (this.baseProducts().length > 0) && (this.optimizedProducts().length > 0);\n        },\n\n        hasMoreProducts: function () {\n            return this.baseProducts().length < this.countTotalProducts();\n        },\n\n        showMoreProducts: function () {\n            this.currentSize(this.currentSize() + this.pageSize);\n            this.refreshProductList();\n        },\n\n        resetPreview: function () {\n            this.baseProducts([]);\n            this.optimizedProducts([]);\n            this.countTotalProducts(0)\n            this.currentSize(this.pageSize);\n            let searchInput = uiRegistry.get(this.parentName + '.' + this.searchInput);\n            if (searchInput !== undefined) {\n                searchInput.reset();\n            }\n        },\n    });\n});\n","Smile_ElasticsuiteCatalogOptimizer/js/components/form/optimizer/scale-function-chart.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalogOptimizer\n * @author    Botis <botis@smile.fr>\n * @copyright 2021 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'jquery',\n    'EsChart',\n    'mage/translate'\n], function (Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: \"Smile_ElasticsuiteCatalogOptimizer/form/element/scale-function-chart\",\n            chartId: null,\n            chartRangesId: null,\n            defaultBorderWidth: 1,\n            selectedBorderWidth: 4,\n            chartRangesInit: false,\n            currentChartRange: {\n                min: 0,\n                max: 10,\n                interval: 1\n            },\n            chartRangeThreshold: 10,\n        },\n\n        initialize: function () {\n            this._super();\n            this.chartRangesId = this.chartId + '_chart_ranges';\n            this.currentOptionValue = this.initOptionValue;\n            this.initPlugins();\n        },\n\n        createChart: function (optionValue = null) {\n            if (!this.chartRangesInit) {\n                this.initRanges();\n            }\n            optionValue = typeof optionValue === 'object' ? null : optionValue;\n            var data = {\n                labels: _.range(\n                    this.currentChartRange.min,\n                    this.currentChartRange.max + this.currentChartRange.interval,\n                    this.currentChartRange.interval\n                ),\n                datasets: this.getDataSets(optionValue),\n            };\n\n            var chartElement = $('#' + this.chartId);\n            var modal = chartElement.closest('.modal-content');\n            var scrollTop = null;\n            if (this.chart !== undefined) {\n                /**\n                 * When the chart is in a modal, once it is destroyed there is a scroll effect because the HTML chart element is empty,\n                 * to avoid that we keep the scroll top value before the destruction and we reapply it on the modal after the chart creation.\n                 */\n                scrollTop = modal.scrollTop();\n                this.chart.destroy();\n            }\n\n            this.chart = new Chart(chartElement, {\n                type: 'line',\n                plugins : this.plugins,\n                data: data,\n                options: {\n                    tooltips: {\n                        enabled: false\n                    },\n                    scales: {\n                        y: {\n                            display: true,\n                            type: 'linear',\n                        },\n                    },\n                    animation: {\n                        duration: 0\n                    },\n                }\n            });\n\n            if (scrollTop) {\n                modal.scrollTop(scrollTop);\n            }\n        },\n\n        initRanges: function () {\n            $('#' + this.chartRangesId).on('click', '[data-role=\"range\"]', function (e) {\n                this.currentChartRange.min      = $(e.currentTarget).data('range-min');\n                this.currentChartRange.max      = $(e.currentTarget).data('range-max');\n                this.currentChartRange.interval = $(e.currentTarget).data('range-interval');\n                this.createChart();\n            }.bind(this));\n            this.chartRangesInit = true;\n        },\n\n        initPlugins: function () {\n            this.plugins = [{\n                beforeInit: function (chart) {\n                    var data = chart.config.data;\n                    for (var i = 0; i < data.datasets.length; i++) {\n                        for (var j = 0; j < data.labels.length; j++) {\n                            var fct = data.datasets[i].function,\n                                x = data.labels[j],\n                                y = fct(x);\n                            data.datasets[i].data.push(y);\n                        }\n                    }\n                }\n            }]\n        },\n\n        getDataSets: function (optionValue) {\n            optionValue =  this.currentOptionValue;\n            var datasets = [];\n            var DataSetsConfig =  {\n                'ln1p': {\n                    label: $.mage.__('Low (deprecated)'),\n                    function: function (x) {\n                        return Math.log(x + 1);\n                    },\n                    borderColor: \"rgba(0, 0, 0, 1)\",\n                    borderDash: [1, 1],\n                    data: [],\n                    fill: false,\n                    borderWidth: optionValue === 'ln1p' ? this.selectedBorderWidth : this.defaultBorderWidth,\n                },\n                'log1p': {\n                    label: $.mage.__('Low'),\n                    function: function (x) {\n                        return Math.log10(x + 1);\n                    },\n                    borderColor: \"rgba(43, 172, 118, 1)\",\n                    data: [],\n                    fill: false,\n                    borderWidth: optionValue === 'log1p' ? this.selectedBorderWidth : this.defaultBorderWidth,\n                },\n                'sqrt': {\n                    label:  $.mage.__('Medium'),\n                    function: function (x) {\n                        return Math.sqrt(x);\n                    },\n                    borderColor: \"rgba(153, 102, 255, 1)\",\n                    data: [],\n                    fill: false,\n                    borderWidth: optionValue === 'sqrt' ? this.selectedBorderWidth : this.defaultBorderWidth,\n                },\n                'none': {\n                    label:  $.mage.__('High'),\n                    function: function (x) {\n                        return x;\n                    },\n                    borderColor: \"rgba(63, 123, 217, 1)\",\n                    data: [],\n                    fill: false,\n                    borderWidth: optionValue === 'none' ? this.selectedBorderWidth : this.defaultBorderWidth,\n                    hidden: this.currentChartRange.max > this.chartRangeThreshold && optionValue !== 'none',\n                }\n            };\n\n            Object.values(this.functions).forEach(function (key) {\n                if (DataSetsConfig.hasOwnProperty(key)) {\n                    datasets.push(DataSetsConfig[key]);\n                }\n            });\n\n            return datasets;\n        },\n\n        onScaleFunctionChange: function (value) {\n            if (this.chart !== undefined) {\n                this.currentOptionValue = value;\n                this.createChart();\n            }\n        },\n    });\n});\n","Smile_ElasticsuiteCatalogOptimizer/js/components/form/optimizer/constant_score/slider.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalogOptimizer\n * @author    Botis <botis@smile.fr>\n * @copyright 2021 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'jquery'\n], function (Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            fallbackResetTpl: 'Smile_ElasticsuiteCatalogOptimizer/form/element/constant_score/slider',\n            showFallbackReset: true,\n            isDifferedFromDefault: true,\n            sliderNotice: false,\n            sliderInitialized: false,\n            messages : {\n                sliderNotice : $.mage.__('Using extreme boost values complicates achieving a balance between optimizers.'),\n            },\n            sliderConfig : {\n                initialValue: 0,\n                resetValue: 0,\n                minValue: 0,\n                maxValue: 100,\n                step: 1,\n            },\n        },\n        initialize: function () {\n            this._super();\n            this.sliderUid = this.uid + '_slider';\n\n            this.observe([\n                'sliderInitialValue',\n                'sliderMinValue',\n                'sliderMaxValue',\n                'sliderStep',\n                'sliderNotice',\n            ]);\n        },\n        createSlider: function () {\n            this.initSliderValue();\n            this.slider.slider({\n                value: this.sliderInitialValue(),\n                min: this.sliderMinValue() ,\n                max: this.sliderMaxValue(),\n                step: this.sliderStep(),\n                slide: $.proxy(function (event, ui) {\n                    this.value(ui.value);\n                    this.sliderNotice(false);\n                }, this),\n            });\n            this.sliderInitialized = true;\n        },\n        initSliderValue: function () {\n            this.sliderInitialValue(Number(this.sliderConfig.initialValue));\n            this.sliderMinValue(Number(this.sliderConfig.minValue));\n            this.sliderMaxValue(Number(this.sliderConfig.maxValue));\n            this.sliderStep(Number(this.sliderConfig.step));\n\n            this.slider = $('#' + this.sliderUid);\n\n            if (this.value() === '' || this.value() === undefined) {\n                this.value(this.sliderInitialValue());\n            } else {\n                if (this.value() >= this.sliderMinValue() && this.value() <= this.sliderMaxValue()) {\n                    this.sliderInitialValue(Number(this.value()));\n                } else if (this.value() < this.sliderMinValue()) {\n                    this.sliderNotice(true);\n                    this.sliderInitialValue(Number(this.sliderMinValue()));\n                } else if (this.value() > this.sliderMaxValue()) {\n                    this.sliderNotice(true);\n                    this.sliderInitialValue(Number(this.sliderMaxValue()));\n                }\n            }\n        },\n        onUpdate: function (value) {\n            this.sliderNotice(false);\n            if (this.slider === undefined || !this.sliderInitialized) {\n                return this._super();\n            }\n\n            if (value === '' || value === undefined) {\n                this.slider.slider('value', this.sliderConfig.initialValue);\n                return this._super();\n            }\n\n            if (value >= this.sliderMinValue() && value <= this.sliderMaxValue()) {\n                this.slider.slider('value', value);\n            } else if (value < this.sliderMinValue()) {\n                this.sliderNotice(true);\n                this.slider.slider('value', Number(this.sliderMinValue()));\n            } else if (value > this.sliderMaxValue()) {\n                this.sliderNotice(true);\n                this.slider.slider('value', Number(this.sliderMaxValue()));\n            }\n\n            return this._super();\n        },\n        setDifferedFromDefault: function () {\n            // To keep the reset block always displayed.\n            this.isDifferedFromDefault(true);\n        }\n    });\n});\n","Smile_ElasticsuiteCatalogOptimizer/js/components/form/optimizer/preview/item.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCatalog\n * @author    Aurelien FOUCRET <aurelien.foucret@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'Smile_ElasticsuiteCatalog/js/form/element/product-sorter/item',\n    'mage/translate'\n], function (Component, $, priceUtil, Item) {\n\n    'use strict';\n\n    return Item.extend({\n        getEffectClass : function () {\n            if (this.data.effect === -1) {\n                return 'down';\n            } else if (this.data.effect === 1) {\n                return 'up';\n            }\n\n            return '';\n        },\n\n        getScoreLabel: function() {\n            return $.mage.__(\"Score : \");\n        }\n    });\n\n});\n","Extendware_EWProductAttachment/js/init-drop-zone.js":"define([\n    'jquery'\n], function($) {\n    return function(e) {\n        var dropZone = $('.drop-zone'),\n            foundDropzone,\n            timeout = window.dropZoneTimeout;\n\n        if (!timeout) {\n            dropZone.addClass('in');\n        } else {\n            clearTimeout(timeout);\n        }\n\n        var found = false,\n            node = e.target;\n        do {\n            if ($(node).hasClass('drop-zone')) {\n                found = true;\n                foundDropzone = $(node);\n                break;\n            }\n            node = node.parentNode;\n        } while (node != null);\n\n        dropZone.removeClass('in hover');\n\n        if (found) {\n            foundDropzone.addClass('hover');\n        }\n\n        window.dropZoneTimeout = setTimeout(function () {\n            window.dropZoneTimeout = null;\n            dropZone.removeClass('in hover');\n        }, 600);\n    }\n});","Extendware_EWProductAttachment/js/byte-convert.js":"define([], function () {\n    /**\n     * Convert byte count to float KB/MB format\n     *\n     * @param int $bytes\n     * @return string\n     */\n    return function(bytes) {\n        if (isNaN(bytes)) {\n            return '';\n        }\n        var symbols = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];\n        var exp = Math.floor(Math.log(bytes)/Math.log(2));\n        if (exp < 1) {\n            exp = 0;\n        }\n        var i = Math.floor(exp / 10);\n        bytes = bytes / Math.pow(2, 10 * i);\n\n        if (bytes.toString().length > bytes.toFixed(2).toString().length) {\n            bytes = bytes.toFixed(2);\n        }\n        return bytes + ' ' + symbols[i];\n    };\n\n});","Extendware_EWProductAttachment/js/attachment.js":"/*\n *\n *  * web-vision GmbH\n *  * Do not edit or add to this file if you wish to upgrade Magento to newer\n *  * versions in the future. If you wish to customize Magento for your\n *  * needs please refer to https://www.web-vision.de for more information.\n *  * @category    Extendware\n *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)\n *  * @author      Fenil Timbadiya\n *\n */\nrequirejs([\n    'jquery', 'mage/url'\n], function ($, urlBuilder) {\n    'use strict';\n    (function ($) {\n        $.fn.tablesorter = function () {\n            var $table = this;\n            this.find('th').click(function () {\n                var idx = $(this).index();\n                var direction = $(this).hasClass('sort_asc');\n                $table.tablesortby(idx, direction);\n            });\n            return this;\n        };\n        $.fn.tablesortby = function (idx, direction) {\n            var $rows = this.find('tbody tr');\n\n            function elementToVal(a) {\n                var $a_elem = $(a).find('td:nth-child(' + (idx + 1) + ')');\n                var a_val = $a_elem.attr('data-sort') || $a_elem.text();\n                return (a_val == parseInt(a_val) ? parseInt(a_val) : a_val);\n            }\n\n            $rows.sort(function (a, b) {\n                var a_val = elementToVal(a), b_val = elementToVal(b);\n                return (a_val > b_val ? 1 : (a_val == b_val ? 0 : -1)) * (direction ? 1 : -1);\n            })\n            this.find('th').removeClass('sort_asc sort_desc');\n            $(this).find('thead th:nth-child(' + (idx + 1) + ')').addClass(direction ? 'sort_desc' : 'sort_asc');\n            for (var i = 0; i < $rows.length; i++)\n                this.append($rows[i]);\n            this.settablesortmarkers();\n            return this;\n        }\n        $.fn.retablesort = function () {\n            var $e = this.find('thead th.sort_asc, thead th.sort_desc');\n            if ($e.length)\n                this.tablesortby($e.index(), $e.hasClass('sort_desc'));\n\n            return this;\n        }\n        $.fn.settablesortmarkers = function () {\n            this.find('thead th span.indicator').remove();\n            this.find('thead th.sort_asc').append('<span class=\"indicator\">&darr;<span>');\n            this.find('thead th.sort_desc').append('<span class=\"indicator\">&uarr;<span>');\n            return this;\n        }\n    })(jQuery);\n\n    var MAX_UPLOAD_SIZE = $(\"#max_upload_size\").data(\"value\");\n    var $tbody = $('#list');\n    $('#table').tablesorter();\n    $(document).ready(function () {\n        list();\n    });\n    $('#table_attchemnet').on('click', '.delete_attchemnet', function (data) {\n        var closest_tr = $(this).closest(\"tr\");\n        var attchement_id = $(this).data(\"id\");\n        var attchemnetdelete = window.attchemnetdelete\n        $.ajax({\n            showLoader: true,\n            url: attchemnetdelete,\n            data: {'type': 'delete', 'attchement_id': attchement_id},\n            type: \"GET\",\n            cache: false,\n            dataType: 'json',\n            success: function (response) {\n                if (response) {\n                    closest_tr.remove();\n                    list();\n                } else {\n                    $message = 'Something Went Wrong in the Atachemnet Delte.'\n                }\n            }\n        });\n    });\n    $('#table').on('click', '.delete', function (data) {\n        var closest_tr = $(this).closest(\"tr\");\n        var resourcePath = $(this).data(\"file\");\n        filedelete(resourcePath);\n        closest_tr.remove();\n    });\n    $('#table').on('click', '.download', function (data) {\n        var resourcePath = $(this).data(\"file\");\n        var basename = $(this).data(\"basename\");\n        filedownload(resourcePath, basename);\n    });\n    $('#table').on('click', '.name', function (data) {\n        var type = $(this).data(\"type\");\n        if (type == 'is_dir') {\n            list($(this).data(\"path\"));\n        }\n    });\n    $('#breadcrumb').on('click', '.breadcrumbs-dir', function (data) {\n        var type = $(this).data(\"type\");\n        if (type == 'is_dir') {\n            list($(this).data(\"path\"));\n        }\n    });\n    $('#mkdir').submit(function (e) {\n        var dir = $(\"#dirname\").val();\n        var hashval = $(\"#breadcrumb_des_path\").data(\"value\");\n        e.preventDefault();\n        mkdir(dir, hashval);\n        $(\"#dirname\").val('');\n    });\n    $('#file_drop_target').on('dragover', function () {\n        $(this).addClass('drag_over');\n        return false;\n    }).on('dragend', function () {\n        $(this).removeClass('drag_over');\n        return false;\n    }).on('drop', function (e) {\n        e.preventDefault();\n        var hashval = $(\"#breadcrumb_des_path\").data(\"value\");\n        var files = e.originalEvent.dataTransfer.files;\n        uploadFile(files, hashval);\n        $(this).removeClass('drag_over');\n    });\n    $('input[type=file]').change(function (e) {\n        e.preventDefault();\n        var hashval = $(\"#breadcrumb_des_path\").data(\"value\");\n        uploadFile(this.files, hashval);\n    });\n\n    function list(path) {\n        var linkUrl = urlBuilder.build('extendware_attachmentrules/rules_file/filelist');\n        var filelist = window.filelist;\n        $.ajax({\n            showLoader: true,\n            url: filelist,\n            data: {'type': 'list', 'path': path,},\n            type: \"GET\",\n            cache: false,\n            dataType: 'json',\n            success: function (response) {\n                var $tbody = $('#list');\n                if (typeof path != 'undefined') {\n                    var hashval = path;\n                } else {\n                    var hashval = $('#home_dir').data(\"path\");\n                }\n                $tbody.empty();\n                $('#breadcrumb').empty().html(renderBreadcrumbs(hashval));\n                if (response) {\n                    $.each(response.results, function (k, v) {\n                        $tbody.append(renderFileRow(v));\n                    });\n                    !response.results.length && $tbody.append('<tr><td class=\"empty\" colspan=5>This folder is empty</td></tr>')\n                    response.is_writable ? $('body').removeClass('no_write') : $('body').addClass('no_write');\n                } else {\n                    console.warn(response.error.msg);\n                }\n                $('#table').retablesort();\n            }\n        });\n    }\n\n    function filedelete(resourcePath) {\n        var filedelete = window.filedelete;\n        $.ajax({\n            showLoader: true,\n            url: filedelete,\n            data: {'type': 'delete', 'resourcePath': resourcePath},\n            type: \"GET\",\n            cache: false,\n            dataType: 'json',\n            success: function (response) {\n                if (response) {\n                } else {\n                }\n                $('#table').retablesort();\n            }\n        });\n    }\n\n    function filedownload(resourcePath, basename) {\n        var filedownload = window.filedownload;\n        $.ajax({\n            showLoader: true,\n            url: filedownload,\n            data: {'type': 'download', 'resourcePath': resourcePath},\n            type: \"GET\",\n            cache: false,\n            xhrFields: {\n                responseType: 'blob'\n            },\n            success: function (blob) {\n                var link = document.createElement('a');\n                link.href = window.URL.createObjectURL(blob);\n                link.download = basename;\n                link.click();\n            }\n        });\n    }\n\n    function mkdir(dir_name, path) {\n        var filemkdir = window.filemkdir;\n        $.ajax({\n            showLoader: true,\n            url: filemkdir,\n            data: {'type': 'mkdir', 'dir_name': dir_name, 'path': path},\n            type: \"GET\",\n            cache: false,\n            dataType: 'json',\n            success: function (response) {\n                list(path);\n                if (response) {\n                } else {\n                }\n                $('#table').retablesort();\n            }\n        });\n    }\n\n    function renderBreadcrumbs(path) {\n        var file_manager_path = $(\"#file_manager_path\").data(\"value\");\n        var base = \"\",\n            $html = $('<div></div>');\n        $html.append($('<input type=\"hidden\" id=\"breadcrumb_des_path\" name=\"breadcrumb_des_path\" data-value=\"' + path + '\">'));\n        $html.append($('<a class=\"breadcrumbs-dir\" id=\"home_dir\" data-type=\"is_dir\" href=\"javascript:void(0)\" data-path=\"' + file_manager_path + '\">Home</a></div>'));\n        $.each(path.split('/'), function (k, v) {\n            if (v) {\n                var v_as_text = decodeURIComponent(v);\n                $html.append($('<span></span>').text(' \u25b8 '))\n                    .append($('<a class=\"breadcrumbs-dir\" data-type=\"is_dir\"/>').attr('href', \"javascript:void(0)\").text(v_as_text).attr('data-path', '/' + base + v));\n                base += v + '/';\n            }\n        });\n        return $html;\n    }\n\n    function renderFileRow(data) {\n        var cherry_pic = $('<input type=\"checkbox\" name=\"cherry_pic[]\" value=\"' + data.path + '\"/\"' + data.name + '\">');\n        var $link = $('<a class=\"name\" />')\n            .attr('href', \"javascript:void(0)\")\n            .text(data.name)\n            .attr('data-id', data.base_path)\n            .attr('data-path', data.path)\n            .attr('data-type', data.is_dir ? 'is_dir' : 'is_file');\n        var allow_direct_link = $(\"#allow_direct_link\").data(\"value\");\n        if (!data.is_dir && !allow_direct_link) $link.css('pointer-events', 'none');\n        var $dl_link = $('<a href=\"#\"/>').attr('data-file', data.path).attr('data-basename', data.base_path).addClass('download').text('download');\n        var $delete_link = $('<a href=\"#\" />').attr('data-file', data.path).addClass('delete').text('delete');\n        var perms = [];\n        if (data.is_readable) perms.push('read');\n        if (data.is_writable) perms.push('write');\n        if (data.is_executable) perms.push('exec');\n        var $html = $('<tr></tr>')\n            .append($('<td class=\"cherry\"></td>').append(cherry_pic))\n            .addClass(data.is_dir ? 'is_dir' : '')\n            .append($('<td class=\"first\"></td>').append($link))\n            .append($('<td></td>').attr('data-sort', data.is_dir ? -1 : data.size)\n                .html($('<span class=\"size\"></span>').text(formatFileSize(data.size))))\n            .append($('<td></td>').attr('data-sort', data.mtime).text(formatTimestamp(data.mtime)))\n            .append($('<td></td>').text(perms.join('+')))\n            .append($('<td></td>').append($dl_link).append(data.is_deleteable ? $delete_link : ''))\n        return $html;\n    }\n\n    function formatTimestamp(unix_timestamp) {\n        var m = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];\n        var d = new Date(unix_timestamp * 1000);\n        return [m[d.getMonth()], ' ', d.getDate(), ', ', d.getFullYear(), \" \",\n            (d.getHours() % 12 || 12), \":\", (d.getMinutes() < 10 ? '0' : '') + d.getMinutes(),\n            \" \", d.getHours() >= 12 ? 'PM' : 'AM'].join('');\n    }\n\n    function formatFileSize(bytes) {\n        var s = ['bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB'];\n        for (var pos = 0; bytes >= 1000; pos++, bytes /= 1024) ;\n        var d = Math.round(bytes * 10);\n        return pos ? [parseInt(d / 10), \".\", d % 10, \" \", s[pos]].join('') : bytes + ' bytes';\n    }\n\n    function uploadFile(files, path) {\n        var fileupload = window.fileupload;\n        var formData = new FormData();\n        formData.append(\"form_key\", window.FORM_KEY);\n        //Get File Value\n        formData.append('filelength', files.length);\n        formData.append('path', path);\n        if (files.length > 0) {\n            for (var i = 0; i < files.length; i++) {\n                formData.append('file' + i, files[i]);\n            }\n        }\n        var folder = window.location.hash.substr(1);\n        $.ajax({\n            url: fileupload,\n            type: 'POST',\n            data: formData,\n            cache: false,\n            contentType: false,\n            processData: false,\n            success: function (response) {\n                list(path);\n            }\n        });\n    }\n\n    function renderFileUploadRow(file, folder) {\n        return $row = $('<div></div>')\n            .append($('<span class=\"fileuploadname\"></span>').text((folder ? folder + '/' : '') + file.name))\n            .append($('<div class=\"progress_track\"><div class=\"progress\"></div></div>'))\n            .append($('<span class=\"size\"></span>').text(formatFileSize(file.size)))\n    };\n\n    function renderFileSizeErrorRow(file, folder) {\n        return $row = $('<div class=\"error\"></div>')\n            .append($('<span class=\"fileuploadname\"></span>').text('Error: ' + (folder ? folder + '/' : '') + file.name))\n            .append($('<span></span>').html(' file size - <b>' + formatFileSize(file.size) + '</b>'\n                + ' exceeds max upload size of <b>' + formatFileSize(MAX_UPLOAD_SIZE) + '</b>'));\n    }\n\n});\n","Extendware_EWProductAttachment/js/form/element/upload.js":"define([\n    'mageUtils',\n    'Magento_Ui/js/form/element/abstract'\n], function (utils, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: ''\n            }\n        },\n        initialize: function () {\n            this._super()\n                .initFormId();\n\n            return this;\n        },\n\n        initConfig: function () {\n\n            var uid = utils.uniqueid(),\n                name,\n                scope;\n\n            this._super();\n\n            scope   = this.dataScope,\n                name    = scope.split('.').slice(1);\n\n            _.extend(this, {\n                uid: uid,\n                noticeId: 'notice-' + uid,\n                inputName: name[1]\n            });\n\n            return this;\n        },\n        initFormId: function () {\n            var namespace;\n\n            if (this.formId) {\n                return this;\n            }\n\n            namespace   = this.name.split('.');\n            this.formId = namespace[0];\n\n            return this;\n        }\n    });\n});\n","Extendware_EWProductAttachment/js/dynamic-rows/dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'mageUtils',\n    'underscore',\n    'uiLayout',\n    'uiCollection',\n    'uiRegistry',\n    'mage/translate'\n], function (ko, utils, _, layout, uiCollection, registry, $t) {\n    'use strict';\n\n    /**\n     * Checks value type and cast to boolean if needed\n     *\n     * @param {*} value\n     *\n     * @returns {Boolean|*} casted or origin value\n     */\n    function castValue(value) {\n        if (_.isUndefined(value) || value === '' || _.isNull(value)) {\n            return false;\n        }\n\n        return value;\n    }\n\n    /**\n     * Compares arrays.\n     *\n     * @param {Array} base - array as method bases its decision on first argument.\n     * @param {Array} current - second array\n     *\n     * @returns {Boolean} result - is current array equal to base array\n     */\n    function compareArrays(base, current) {\n        var index = 0,\n            length = base.length;\n\n        if (base.length !== current.length) {\n            return false;\n        }\n\n        /*eslint-disable max-depth, eqeqeq, no-use-before-define */\n        for (index; index < length; index++) {\n            if (_.isArray(base[index]) && _.isArray(current[index])) {\n                if (!compareArrays(base[index], current[index])) {\n                    return false;\n                }\n            } else if (typeof base[index] === 'object' && typeof current[index] === 'object') {\n                if (!compareObjects(base[index], current[index])) {\n                    return false;\n                }\n            } else if (castValue(base[index]) != castValue(current[index])) {\n                return false;\n            }\n        }/*eslint-enable max-depth, eqeqeq, no-use-before-define */\n\n        return true;\n    }\n\n    /**\n     * Compares objects. Compares only properties from origin object,\n     * if current object has more properties - they are not considered\n     *\n     * @param {Object} base - first object\n     * @param {Object} current - second object\n     *\n     * @returns {Boolean} result - is current object equal to base object\n     */\n    function compareObjects(base, current) {\n        var prop;\n\n        /*eslint-disable max-depth, eqeqeq*/\n        for (prop in base) {\n            if (_.isArray(base[prop]) && _.isArray(current[prop])) {\n                if (!compareArrays(base[prop], current[prop])) {\n                    return false;\n                }\n            } else if (typeof base[prop] === 'object' && typeof current[prop] === 'object') {\n                if (!compareObjects(base[prop], current[prop])) {\n                    return false;\n                }\n            } else if (castValue(base[prop]) != castValue(current[prop])) {\n                return false;\n            }\n        }/*eslint-enable max-depth, eqeqeq */\n\n        return true;\n    }\n\n    return uiCollection.extend({\n        defaults: {\n            defaultRecord: false,\n            columnsHeader: true,\n            columnsHeaderAfterRender: false,\n            columnsHeaderClasses: '',\n            labels: [],\n            recordTemplate: 'record',\n            collapsibleHeader: false,\n            additionalClasses: {},\n            visible: true,\n            disabled: false,\n            fit: false,\n            addButton: true,\n            addButtonLabel: $t('Add'),\n            recordData: [],\n            maxPosition: 0,\n            deleteProperty: 'delete',\n            identificationProperty: 'record_id',\n            deleteValue: true,\n            showSpinner: true,\n            isDifferedFromDefault: false,\n            defaultState: [],\n            defaultPagesState: {},\n            pagesChanged: {},\n            hasInitialPagesState: {},\n            changed: false,\n            fallbackResetTpl: 'ui/form/element/helper/fallback-reset-link',\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/dynamic-rows/dnd',\n                template: 'ui/dynamic-rows/cells/dnd',\n                recordsProvider: '${ $.name }',\n                enabled: true\n            },\n            templates: {\n                record: {\n                    parent: '${ $.$data.collection.name }',\n                    name: '${ $.$data.index }',\n                    dataScope: '${ $.$data.collection.index }.${ $.name }',\n                    nodeTemplate: '${ $.parent }.${ $.$data.collection.recordTemplate }'\n                }\n            },\n            links: {\n                recordData: '${ $.provider }:${ $.dataScope }.${ $.index }'\n            },\n            listens: {\n                visible: 'setVisible',\n                disabled: 'setDisabled',\n                childTemplate: 'initHeader',\n                recordTemplate: 'onUpdateRecordTemplate',\n                recordData: 'setDifferedFromDefault parsePagesData setRecordDataToCache',\n                currentPage: 'changePage',\n                elems: 'checkSpinner',\n                changed: 'updateTrigger'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }'\n            },\n            pages: 1,\n            pageSize: 20,\n            relatedData: [],\n            currentPage: 1,\n            recordDataCache: [],\n            startIndex: 0\n        },\n\n        /**\n         * Sets record data to cache\n         */\n        setRecordDataToCache: function (data) {\n            this.recordDataCache = data;\n        },\n\n        /**\n         * Extends instance with default config, calls initialize of parent\n         * class, calls initChildren method, set observe variable.\n         * Use parent \"track\" method - wrapper observe array\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this,\n                'processingDeleteRecord',\n                'onChildrenUpdate',\n                'checkDefaultState',\n                'renderColumnsHeader',\n                'deleteHandler',\n                'setDefaultState'\n            );\n\n            this._super()\n                .initChildren()\n                .initDnd()\n                .initDefaultRecord()\n                .setInitialProperty()\n                .setColumnsHeaderListener()\n                .checkSpinner();\n\n            this.on('recordData', this.checkDefaultState);\n\n            return this;\n        },\n\n        updatePageSize: function (component, event) {\n            this.pageSize = $(event.target).val();\n            this.reload();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        bubble: function (event) {\n            if (event === 'deleteRecord' || event === 'update') {\n                return false;\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Inits DND module\n         *\n         * @returns {Object} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('childTemplate')\n                .observe([\n                    'pages',\n                    'currentPage',\n                    'recordData',\n                    'columnsHeader',\n                    'visible',\n                    'disabled',\n                    'labels',\n                    'showSpinner',\n                    'isDifferedFromDefault',\n                    'changed'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initElement: function (elem) {\n            this._super();\n            elem.on({\n                'deleteRecord': this.deleteHandler,\n                'update': this.onChildrenUpdate,\n                'addChild': this.setDefaultState\n            });\n\n            return this;\n        },\n\n        /**\n         * Handler for deleteRecord event\n         *\n         * @param {Number|String} index - element index\n         * @param {Number|String} id\n         */\n        deleteHandler: function (index, id) {\n            var defaultState;\n\n            this.setDefaultState();\n            defaultState = this.defaultPagesState[this.currentPage()];\n            this.processingDeleteRecord(index, id);\n            this.pagesChanged[this.currentPage()] =\n                !compareArrays(defaultState, this.arrayFilter(this.getChildItems()));\n            this.changed(_.some(this.pagesChanged));\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            if (_.isArray(this.recordData())) {\n                this.recordData.each(function (data, index) {\n                    this.source.set(this.dataScope + '.' + this.index + '.' + index + '.initialize', true);\n                }, this);\n            }\n\n            return this;\n        },\n\n        /**\n         * Handler for update event\n         *\n         * @param {Boolean} state\n         */\n        onChildrenUpdate: function (state) {\n            var changed,\n                dataScope,\n                changedElemDataScope;\n\n            if (state && !this.hasInitialPagesState[this.currentPage()]) {\n                this.setDefaultState();\n                changed = this.getChangedElems(this.elems());\n                dataScope = this.elems()[0].dataScope.split('.');\n                dataScope.splice(dataScope.length - 1, 1);\n                changed.forEach(function (elem) {\n                    changedElemDataScope = elem.dataScope.split('.');\n                    changedElemDataScope.splice(0, dataScope.length);\n                    changedElemDataScope[0] =\n                        (parseInt(changedElemDataScope[0], 10) - this.pageSize * (this.currentPage() - 1)).toString();\n                    this.setValueByPath(\n                        this.defaultPagesState[this.currentPage()],\n                        changedElemDataScope, elem.initialValue\n                    );\n                }, this);\n            }\n\n            if (this.defaultPagesState[this.currentPage()]) {\n                this.pagesChanged[this.currentPage()] =\n                    !compareArrays(this.defaultPagesState[this.currentPage()], this.arrayFilter(this.getChildItems()));\n                this.changed(_.some(this.pagesChanged));\n            }\n        },\n\n        /**\n         * Set default dynamic-rows state or state before changing data\n         *\n         * @param {Array} data - defaultState data\n         */\n        setDefaultState: function (data) {\n            var componentData,\n                childItems;\n\n            if (!this.hasInitialPagesState[this.currentPage()]) {\n                childItems = this.getChildItems();\n                componentData = childItems.length ?\n                    utils.copy(childItems) :\n                    utils.copy(this.getChildItems(this.recordDataCache));\n                componentData.forEach(function (dataObj) {\n                    if (dataObj.hasOwnProperty('initialize')) {\n                        delete dataObj.initialize;\n                    }\n                });\n\n                this.hasInitialPagesState[this.currentPage()] = true;\n                this.defaultPagesState[this.currentPage()] = data ? data : this.arrayFilter(componentData);\n            }\n        },\n\n        /**\n         * Sets value to object by string path\n         *\n         * @param {Object} obj\n         * @param {Array|String} path\n         * @param {*} value\n         */\n        setValueByPath: function (obj, path, value) {\n            var prop;\n\n            if (_.isString(path)) {\n                path = path.split('.');\n            }\n\n            if (path.length - 1) {\n                prop = obj[path[0]];\n                path.splice(0, 1);\n                this.setValueByPath(prop, path, value);\n            } else if (path.length && obj) {\n                obj[path[0]] = value;\n            }\n        },\n\n        /**\n         * Returns elements which changed self state\n         *\n         * @param {Array} array - data array\n         * @param {Array} changed - array with changed elements\n         * @returns {Array} changed - array with changed elements\n         */\n        getChangedElems: function (array, changed) {\n            changed = changed || [];\n\n            array.forEach(function (elem) {\n                if (_.isFunction(elem.elems)) {\n                    this.getChangedElems(elem.elems(), changed);\n                } else if (_.isFunction(elem.hasChanged) && elem.hasChanged()) {\n                    changed.push(elem);\n                }\n            }, this);\n\n            return changed;\n        },\n\n        /**\n         * Checks columnsHeaderAfterRender property,\n         * and set listener on elems if needed\n         *\n         * @returns {Object} Chainable.\n         */\n        setColumnsHeaderListener: function () {\n            if (this.columnsHeaderAfterRender) {\n                this.on('recordData', this.renderColumnsHeader);\n\n                if (_.isArray(this.recordData()) && this.recordData().length) {\n                    this.renderColumnsHeader();\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks whether component's state is default or not\n         */\n        checkDefaultState: function () {\n            var isRecordDataArray = _.isArray(this.recordData()),\n                initialize,\n                hasNotDefaultRecords = isRecordDataArray ? !!this.recordData().filter(function (data) {\n                    return !data.initialize;\n                }).length : false;\n\n            if (!this.hasInitialPagesState[this.currentPage()] && isRecordDataArray && hasNotDefaultRecords) {\n                this.hasInitialPagesState[this.currentPage()] = true;\n                this.defaultPagesState[this.currentPage()] = utils.copy(this.getChildItems().filter(function (data) {\n                    initialize = data.initialize;\n                    delete data.initialize;\n\n                    return initialize;\n                }));\n\n                this.pagesChanged[this.currentPage()] =\n                    !compareArrays(this.defaultPagesState[this.currentPage()], this.arrayFilter(this.getChildItems()));\n                this.changed(_.some(this.pagesChanged));\n            } else if (this.hasInitialPagesState[this.currentPage()]) {\n                this.pagesChanged[this.currentPage()] =\n                    !compareArrays(this.defaultPagesState[this.currentPage()], this.arrayFilter(this.getChildItems()));\n                this.changed(_.some(this.pagesChanged));\n            }\n        },\n\n        /**\n         * Filters out deleted items from array\n         *\n         * @param {Array} data\n         *\n         * @returns {Array} filtered array\n         */\n        arrayFilter: function (data) {\n            var prop;\n\n            /*eslint-disable no-loop-func*/\n            data.forEach(function (elem) {\n                for (prop in elem) {\n                    if (_.isArray(elem[prop])) {\n                        elem[prop] = _.filter(elem[prop], function (elemProp) {\n                            return elemProp[this.deleteProperty] !== this.deleteValue;\n                        }, this);\n\n                        elem[prop].forEach(function (elemProp) {\n                            if (_.isArray(elemProp)) {\n                                elem[prop] = this.arrayFilter(elemProp);\n                            }\n                        }, this);\n                    }\n                }\n            }, this);\n\n            /*eslint-enable no-loop-func*/\n\n            return data;\n        },\n\n        /**\n         * Triggers update event\n         *\n         * @param {Boolean} val\n         */\n        updateTrigger: function (val) {\n            this.trigger('update', val);\n        },\n\n        /**\n         * Returns component state\n         */\n        hasChanged: function () {\n            return this.changed();\n        },\n\n        /**\n         * Render column header\n         */\n        renderColumnsHeader: function () {\n            this.recordData().length ? this.columnsHeader(true) : this.columnsHeader(false);\n        },\n\n        /**\n         * Init default record\n         *\n         * @returns Chainable.\n         */\n        initDefaultRecord: function () {\n            if (this.defaultRecord && !this.recordData().length) {\n                this.addChild();\n            }\n\n            return this;\n        },\n\n        /**\n         * Create header template\n         *\n         * @param {Object} prop - instance obj\n         *\n         * @returns {Object} Chainable.\n         */\n        createHeaderTemplate: function (prop) {\n            var visible = prop.visible !== false,\n                disabled = _.isUndefined(prop.disabled) ? this.disabled() : prop.disabled;\n\n            return {\n                visible: ko.observable(visible),\n                disabled: ko.observable(disabled)\n            };\n        },\n\n        /**\n         * Init header elements\n         */\n        initHeader: function () {\n            var data;\n\n            if (!this.labels().length) {\n                _.each(this.childTemplate.children, function (cell) {\n                    data = this.createHeaderTemplate(cell.config);\n                    cell.config.labelVisible = false;\n                    _.extend(data, {\n                        label: cell.config.label,\n                        name: cell.name,\n                        required: !!cell.config.validation,\n                        columnsHeaderClasses: cell.config.columnsHeaderClasses,\n                        sortOrder: cell.config.sortOrder\n                    });\n\n                    this.labels.push(data);\n                }, this);\n            }\n        },\n\n        /**\n         * Set max element position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        setMaxPosition: function (position, elem) {\n            if (position || position === 0) {\n                this.checkMaxPosition(position);\n                this.sort(position, elem);\n            } else {\n                this.maxPosition += 1;\n            }\n        },\n\n        /**\n         * Sort element by position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        sort: function (position, elem) {\n            var that = this,\n                sorted,\n                updatedCollection;\n\n            if (this.elems().filter(function (el) {\n                    return el.position || el.position === 0;\n                }).length !== this.getChildItems().length) {\n\n                return false;\n            }\n\n            if (!elem.containers.length) {\n                registry.get(elem.name, function () {\n                    that.sort(position, elem);\n                });\n\n                return false;\n            }\n\n            sorted = this.elems().sort(function (propOne, propTwo) {\n                return ~~propOne.position - ~~propTwo.position;\n            });\n\n            updatedCollection = this.updatePosition(sorted, position, elem.name);\n            this.elems(updatedCollection);\n        },\n\n        /**\n         * Checking loader visibility\n         *\n         * @param {Array} elems\n         */\n        checkSpinner: function (elems) {\n            this.showSpinner(!(!this.recordData().length || elems && elems.length === this.getChildItems().length));\n        },\n\n        /**\n         * Filtering data and calculates the quantity of pages\n         *\n         * @param {Array} data\n         */\n        parsePagesData: function (data) {\n            var pages;\n\n            this.relatedData = this.deleteProperty ?\n                _.filter(data, function (elem) {\n                    return elem && elem[this.deleteProperty] !== this.deleteValue;\n                }, this) : data;\n\n            pages = Math.ceil(this.relatedData.length / this.pageSize) || 1;\n            this.pages(pages);\n        },\n\n        /**\n         * Reinit record data in order to remove deleted values\n         *\n         * @return void\n         */\n        reinitRecordData: function () {\n            this.recordData(\n                _.filter(this.recordData(), function (elem) {\n                    return elem && elem[this.deleteProperty] !== this.deleteValue;\n                }, this)\n            );\n        },\n\n        /**\n         * Get items to rendering on current page\n         *\n         * @returns {Array} data\n         */\n        getChildItems: function (data, page) {\n            var dataRecord = data || this.relatedData,\n                startIndex;\n\n            this.startIndex = (~~this.currentPage() - 1) * this.pageSize;\n\n            startIndex = page || this.startIndex;\n\n            return dataRecord.slice(startIndex, this.startIndex + this.pageSize);\n        },\n\n        /**\n         * Get record count with filtered delete property.\n         *\n         * @returns {Number} count\n         */\n        getRecordCount: function () {\n            return _.filter(this.recordData(), function (record) {\n                return record && record[this.deleteProperty] !== this.deleteValue;\n            }, this).length;\n        },\n\n        /**\n         * Get number of columns\n         *\n         * @returns {Number} columns\n         */\n        getColumnsCount: function () {\n            return this.labels().length + (this.dndConfig.enabled ? 1 : 0);\n        },\n\n        /**\n         * Processing pages before addChild\n         *\n         * @param {Object} ctx - element context\n         * @param {Number|String} index - element index\n         * @param {Number|String} prop - additional property to element\n         */\n        processingAddChild: function (ctx, index, prop) {\n            this.bubble('addChild', false);\n\n            if (this.relatedData.length && this.relatedData.length % this.pageSize === 0) {\n                this.pages(this.pages() + 1);\n                this.nextPage();\n            } else if (~~this.currentPage() !== this.pages()) {\n                this.currentPage(this.pages());\n            }\n\n            this.addChild(ctx, index, prop);\n        },\n\n        /**\n         * Processing pages before deleteRecord\n         *\n         * @param {Number|String} index - element index\n         * @param {Number|String} recordId\n         */\n        processingDeleteRecord: function (index, recordId) {\n            this.deleteRecord(index, recordId);\n        },\n\n        /**\n         * Change page\n         *\n         * @param {Number} page - current page\n         */\n        changePage: function (page) {\n            if (page === 1 && !this.recordData().length) {\n                return false;\n            }\n\n            if (~~page > this.pages()) {\n                this.currentPage(this.pages());\n\n                return false;\n            } else if (~~page < 1) {\n                this.currentPage(1);\n\n                return false;\n            }\n\n            this.initChildren();\n\n            return true;\n        },\n\n        /**\n         * Check page\n         *\n         * @returns {Boolean} is page first or not\n         */\n        isFirst: function () {\n            return this.currentPage() === 1;\n        },\n\n        /**\n         * Check page\n         *\n         * @returns {Boolean} is page last or not\n         */\n        isLast: function () {\n            return this.currentPage() === this.pages();\n        },\n\n        /**\n         * Change page to next\n         */\n        nextPage: function () {\n            this.clear();\n            this.currentPage(this.currentPage() + 1);\n        },\n\n        /**\n         * Change page to previous\n         */\n        previousPage: function () {\n            this.clear();\n            this.currentPage(this.currentPage() - 1);\n        },\n\n        /**\n         * Check dependency and set position to elements\n         *\n         * @param {Array} collection - elems\n         * @param {Number} position - current position\n         * @param {String} elemName - element name\n         *\n         * @returns {Array} collection\n         */\n        updatePosition: function (collection, position, elemName) {\n            var curPos,\n                parsePosition = ~~position,\n                result = _.filter(collection, function (record) {\n                    return ~~record.position === parsePosition;\n                });\n\n            if (result[1]) {\n                curPos = parsePosition + 1;\n                result[0].name === elemName ? result[1].position = curPos : result[0].position = curPos;\n                this.updatePosition(collection, curPos);\n            }\n\n            return collection;\n        },\n\n        /**\n         * Check max elements position and set if max\n         *\n         * @param {Number} position - current position\n         */\n        checkMaxPosition: function (position) {\n            var max = 0,\n                pos;\n\n            this.elems.each(function (record) {\n                pos = ~~record.position;\n                pos > max ? max = pos : false;\n            });\n\n            max < position ? max = position : false;\n            this.maxPosition = max;\n        },\n\n        /**\n         * Remove and set new max position\n         */\n        removeMaxPosition: function () {\n            this.maxPosition = 0;\n            this.elems.each(function (record) {\n                this.maxPosition < record.position ? this.maxPosition = ~~record.position : false;\n            }, this);\n        },\n\n        /**\n         * Update record template and rerender elems\n         *\n         * @param {String} recordName - record name\n         */\n        onUpdateRecordTemplate: function (recordName) {\n            if (recordName) {\n                this.recordTemplate = recordName;\n                this.reload();\n            }\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         *\n         */\n        deleteRecord: function (index, recordId) {\n            var recordInstance,\n                lastRecord,\n                recordsData;\n\n            if (this.deleteProperty) {\n                recordsData = this.recordData();\n                recordInstance = _.find(this.elems(), function (elem) {\n                    return elem.index === index;\n                });\n                recordInstance.destroy();\n                this.elems([]);\n                this._updateCollection();\n                this.removeMaxPosition();\n                recordsData[recordInstance.index][this.deleteProperty] = this.deleteValue;\n                this.recordData(recordsData);\n                this.reinitRecordData();\n                this.reload();\n            } else {\n                this.update = true;\n\n                if (~~this.currentPage() === this.pages()) {\n                    lastRecord =\n                        _.findWhere(this.elems(), {\n                            index: this.startIndex + this.getChildItems().length - 1\n                        }) ||\n                        _.findWhere(this.elems(), {\n                            index: (this.startIndex + this.getChildItems().length - 1).toString()\n                        });\n\n                    lastRecord.destroy();\n                }\n\n                this.removeMaxPosition();\n                recordsData = this._getDataByProp(recordId);\n                this._updateData(recordsData);\n                this.update = false;\n            }\n\n            this._reducePages();\n            this._sort();\n        },\n\n        /**\n         * Reduce the number of pages\n         *\n         * @private\n         * @return void\n         */\n        _reducePages: function () {\n            if (this.pages() < ~~this.currentPage()) {\n                this.currentPage(this.pages());\n            }\n        },\n\n        /**\n         * Get data object by some property\n         *\n         * @param {Number} id - element id\n         * @param {String} prop - property\n         */\n        _getDataByProp: function (id, prop) {\n            prop = prop || this.identificationProperty;\n\n            return _.reject(this.getChildItems(), function (recordData) {\n                return ~~recordData[prop] === ~~id;\n            }, this);\n        },\n\n        /**\n         * Sort elems by position property\n         */\n        _sort: function () {\n            this.elems(this.elems().sort(function (propOne, propTwo) {\n                return ~~propOne.position - ~~propTwo.position;\n            }));\n        },\n\n        /**\n         * Set new data to dataSource,\n         * delete element\n         *\n         * @param {Array} data - record data\n         */\n        _updateData: function (data) {\n            var elems = _.clone(this.elems()),\n                path,\n                dataArr;\n\n            dataArr = this.recordData.splice(this.startIndex, this.recordData().length - this.startIndex);\n            dataArr.splice(0, this.pageSize);\n            elems = _.sortBy(this.elems(), function (elem) {\n                return ~~elem.index;\n            });\n\n            data.concat(dataArr).forEach(function (rec, idx) {\n                if (elems[idx]) {\n                    elems[idx].recordId = rec[this.identificationProperty];\n                }\n\n                if (!rec.position) {\n                    rec.position = this.maxPosition;\n                    this.setMaxPosition();\n                }\n\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + idx);\n                this.source.set(path, rec);\n            }, this);\n\n            this.elems(elems);\n        },\n\n        /**\n         * Rerender dynamic-rows elems\n         */\n        reload: function () {\n            this.clear();\n            this.initChildren(false, true);\n        },\n\n        /**\n         * Destroy all dynamic-rows elems\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            this.destroyChildren();\n\n            return this;\n        },\n\n        /**\n         * Reset data to initial value.\n         * Call method reset on child elements.\n         */\n        reset: function () {\n            var elems = this.elems();\n\n            _.each(elems, function (elem) {\n                if (_.isFunction(elem.reset)) {\n                    elem.reset();\n                }\n            });\n        },\n\n        /**\n         * Set classes\n         *\n         * @param {Object} data\n         *\n         * @returns {Object} Classes\n         */\n        setClasses: function (data) {\n            var additional;\n\n            if (_.isString(data.additionalClasses)) {\n                additional = data.additionalClasses.split(' ');\n                data.additionalClasses = {};\n\n                additional.forEach(function (name) {\n                    data.additionalClasses[name] = true;\n                });\n            }\n\n            if (!data.additionalClasses) {\n                data.additionalClasses = {};\n            }\n\n            _.extend(data.additionalClasses, {\n                '_fit': data.fit,\n                '_required': data.required,\n                '_error': data.error,\n                '_empty': !this.elems().length,\n                '_no-header': this.columnsHeaderAfterRender || this.collapsibleHeader\n            });\n\n            return data.additionalClasses;\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            this.showSpinner(true);\n            this.getChildItems().forEach(function (data, index) {\n                this.addChild(data, this.startIndex + index);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Set visibility to dynamic-rows child\n         *\n         * @param {Boolean} state\n         */\n        setVisible: function (state) {\n            this.elems.each(function (record) {\n                record.setVisible(state);\n            }, this);\n        },\n\n        /**\n         * Set disabled property to dynamic-rows child\n         *\n         * @param {Boolean} state\n         */\n        setDisabled: function (state) {\n            this.elems.each(function (record) {\n                record.setDisabled(state);\n            }, this);\n        },\n\n        /**\n         * Set visibility to column\n         *\n         * @param {Number} index - column index\n         * @param {Boolean} state\n         */\n        setVisibilityColumn: function (index, state) {\n            this.elems.each(function (record) {\n                record.setVisibilityColumn(index, state);\n            }, this);\n        },\n\n        /**\n         * Set disabled property to column\n         *\n         * @param {Number} index - column index\n         * @param {Boolean} state\n         */\n        setDisabledColumn: function (index, state) {\n            this.elems.each(function (record) {\n                record.setDisabledColumn(index, state);\n            }, this);\n        },\n\n        /**\n         * Add child components\n         *\n         * @param {Object} data - component data\n         * @param {Number} index - record(row) index\n         * @param {Number|String} prop - custom identify property\n         *\n         * @returns {Object} Chainable.\n         */\n        addChild: function (data, index, prop) {\n            var template = this.templates.record,\n                child;\n\n            index = index || _.isNumber(index) ? index : this.recordData().length;\n            prop = prop || _.isNumber(prop) ? prop : index;\n\n            _.extend(this.templates.record, {\n                recordId: prop\n            });\n\n            child = utils.template(template, {\n                collection: this,\n                index: index\n            });\n\n            layout([child]);\n\n            return this;\n        },\n\n        /**\n         * Restore value to default\n         */\n        restoreToDefault: function () {\n            this.recordData(utils.copy(this.default));\n            this.reload();\n        },\n\n        /**\n         * Update whether value differs from default value\n         */\n        setDifferedFromDefault: function () {\n            var recordData = utils.copy(this.recordData());\n\n            Array.isArray(recordData) && recordData.forEach(function (item) {\n                delete item['record_id'];\n            });\n\n            this.isDifferedFromDefault(!_.isEqual(recordData, this.default));\n        }\n    });\n});\n","Extendware_EWProductAttachment/js/dynamic-rows/dynamic-rows-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './dynamic-rows'\n], function (_, dynamicRows) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            dataProvider: '',\n            insertData: [],\n            map: null,\n            cacheGridData: [],\n            deleteProperty: false,\n            positionProvider: 'position',\n            dataLength: 0,\n            identificationProperty: 'id',\n            identificationDRProperty: 'id',\n            listens: {\n                'insertData': 'processingInsertData',\n                'recordData': 'initElements setToInsertData'\n            },\n            mappingSettings: {\n                enabled: true,\n                distinct: true\n            }\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertData'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Set data from recordData to insertData\n         */\n        setToInsertData: function () {\n            var insertData = [],\n                obj;\n\n            if (this.recordData().length && !this.update) {\n                _.each(this.recordData(), function (recordData) {\n                    obj = {};\n                    obj[this.map[this.identificationProperty]] = recordData[this.identificationProperty];\n                    insertData.push(obj);\n                }, this);\n\n                if (insertData.length) {\n                    this.source.set(this.dataProvider, insertData);\n                }\n            }\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            this.getChildItems().forEach(function (data, index) {\n                this.processingAddChild(data, this.startIndex + index, data[this.identificationDRProperty]);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Initialize elements from grid\n         *\n         * @param {Array} data\n         *\n         * @returns {Object} Chainable.\n         */\n        initElements: function (data) {\n            var newData = this.getNewData(data);\n\n            this.parsePagesData(data);\n\n            if (newData.length) {\n                if (this.insertData().length) {\n                    this.processingAddChild(newData[0], data.length - 1, newData[0][this.identificationProperty]);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete record instance\n         * update data provider dataScope\n         *\n         * @param {String|Number} index - record index\n         * @param {String|Number} recordId\n         */\n        deleteRecord: function (index, recordId) {\n            this._super();\n\n            this.updateInsertData(recordId);\n        },\n\n        /**\n         * Updates insertData when record is deleted\n         *\n         * @param {String|Number} recordId\n         */\n        updateInsertData: function (recordId) {\n            var data = this.getElementData(this.insertData(), recordId),\n            prop = this.map[this.identificationDRProperty];\n\n            this.insertData(_.reject(this.source.get(this.dataProvider), function (recordData) {\n                return ~~recordData[prop] === ~~data[prop];\n            }, this));\n        },\n\n        /**\n         * Find data object by index\n         *\n         * @param {Array} array - data collection\n         * @param {Number} index - element index\n         * @param {String} property - to find by property\n         *\n         * @returns {Object} data object\n         */\n        getElementData: function (array, index, property) {\n            var obj = {},\n                result;\n\n            property ? obj[property] = index : obj[this.map[this.identificationDRProperty]] = index;\n            result = _.findWhere(array, obj);\n\n            if (!result) {\n                property ?\n                    obj[property] = index.toString() :\n                    obj[this.map[this.identificationDRProperty]] = index.toString();\n            }\n\n            result = _.findWhere(array, obj);\n\n            return result;\n        },\n\n        /**\n         * Processing pages before addChild\n         *\n         * @param {Object} ctx - element context\n         * @param {Number|String} index - element index\n         * @param {Number|String} prop - additional property to element\n         */\n        processingAddChild: function (ctx, index, prop) {\n            if (this._elems.length > this.pageSize) {\n                return false;\n            }\n\n            this.showSpinner(true);\n            this.addChild(ctx, index, prop);\n        },\n\n        /**\n         * Contains old data with new\n         *\n         * @param {Array} data\n         *\n         * @returns {Array} changed data\n         */\n        getNewData: function (data) {\n            var changes = [],\n                tmpObj = {};\n\n            if (data.length !== this.relatedData.length) {\n                _.each(data, function (obj) {\n                    tmpObj[this.identificationDRProperty] = obj[this.identificationDRProperty];\n\n                    if (!_.findWhere(this.relatedData, tmpObj)) {\n                        changes.push(obj);\n                    }\n                }, this);\n            }\n\n            return changes;\n        },\n\n        /**\n         * Processing insert data\n         *\n         * @param {Object} data\n         */\n        processingInsertData: function (data) {\n            var changes,\n                obj = {};\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            if (changes.length) {\n                obj[this.identificationDRProperty] = changes[0][this.map[this.identificationProperty]];\n\n                if (_.findWhere(this.recordData(), obj)) {\n                    return false;\n                }\n\n\t\t\t\t_.each(changes, function (changedObject) {\n\t\t\t\t\tthis.mappingValue(changedObject);\n\t\t\t\t}, this);\n            }\n        },\n\n        /**\n         * Mapping value from grid\n         *\n         * @param {Array} data\n         */\n        mappingValue: function (data) {\n            var obj = {},\n                tmpObj = {};\n\n            if (this.mappingSettings.enabled) {\n                _.each(this.map, function (prop, index) {\n                    obj[index] = !_.isUndefined(data[prop]) ? data[prop] : '';\n                }, this);\n            } else {\n                obj = data;\n            }\n\n            if (this.mappingSettings.distinct) {\n                tmpObj[this.identificationDRProperty] = obj[this.identificationDRProperty];\n\n                if (_.findWhere(this.recordData(), tmpObj)) {\n                    return false;\n                }\n            }\n\n            if (!obj.hasOwnProperty(this.positionProvider)) {\n                this.setMaxPosition();\n                obj[this.positionProvider] = this.maxPosition;\n            }\n\n            this.source.set(this.dataScope + '.' + this.index + '.' + this.recordData().length, obj);\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            _.each(max, function (record, index) {\n                obj[this.map[this.identificationDRProperty]] = record[this.map[this.identificationDRProperty]];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        }\n    });\n});\n","Extendware_EWProductAttachment/js/producticon/post-wrapper.js":"require([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    /**\n     * @param {String} url\n     * @returns {Object}\n     */\n    function getForm(url) {\n        return $('<form>', {\n            'action': url,\n            'method': 'POST'\n        }).append($('<input>', {\n            'name': 'form_key',\n            'value': window.FORM_KEY,\n            'type': 'hidden'\n        }));\n    }\n\n    $('#icon-edit-delete-button').click(function () {\n        var msg = $.mage.__('Are you sure you want to do this?'),\n            url = $('#icon-edit-delete-button').data('url');\n\n        confirm({\n            'content': msg,\n            'actions': {\n                confirm: function () {\n                    getForm(url).appendTo('body').submit();\n                }\n            }\n        });\n\n        return false;\n    });\n});\n","Extendware_EWProductAttachment/js/grid/massactions.js":"define([\n    'underscore',\n    'Magento_Ui/js/grid/massactions',\n    'uiRegistry',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function (_, Massactions, registry, utils, Collapsible, confirm, alert, $t) {\n    'use strict';\n\n    return Massactions.extend({\n         /**\n         * Default action callback. Sends selections data\n         * via POST request.\n         *\n         * @param {Object} action - Action data.\n         * @param {Object} data - Selections data.\n         */\n        defaultCallback: function (action, data) {\n            var itemsType = data.excludeMode ? 'excluded' : 'selected',\n                selections = {};\n\n            selections[itemsType] = data[itemsType];\n\n            if (!selections[itemsType].length) {\n                selections[itemsType] = false;\n            }\n\n            _.extend(selections, data.params || {});\n\n            if(action.type && action.type.indexOf('ewproduct') == 0){\n                selections['action'] = action.type;\n            }\n            console.log(action.url);\n            utils.submit({\n                url: action.url,\n                data: selections\n            });\n        },\n\n        applyMassaction: function (parent, action) {\n            var data = this.getSelections(),\n                action,\n                callback;\n            action   = this.getAction(action.type);\n\n            var fileElement = jQuery('.action-submenu._active .ewproduct-file-form input:visible, .action-submenu._active .ewproduct-file-form select:visible');\n            var value = fileElement.length? fileElement[fileElement.length - 1].value : null;\n\n            if (!value) {\n                alert({\n                    content: 'Required field is empty.'\n                });\n\n                return this;\n            }\n\n            if (!data.total || !value) {\n                alert({\n                    content: this.noItemsMsg\n                });\n\n                return this;\n            }\n            var me = this;\n            callback = function(){me.massactionCallback(action, data)};\n\n            action.confirm ?\n                this._confirm(action, callback) :\n                callback();\n        },\n\n        massactionCallback: function (action, data) {\n            var itemsType = data.excludeMode ? 'excluded' : 'selected',\n                selections = {};\n\n            selections[itemsType] = data[itemsType];\n\n            var fileElement = jQuery('.action-submenu._active .ewproduct-file-form input:visible, .action-submenu._active .ewproduct-file-form select:visible');\n            if(fileElement.length){\n                selections['ewproduct_file_field'] = fileElement[fileElement.length - 1].value;\n            }\n\n            selections['action'] = action.type;\n\n            if (!selections[itemsType].length) {\n                selections[itemsType] = false;\n            }\n\n            _.extend(selections, data.params || {});\n\n            console.log(action.url);\n            utils.submit({\n                url: action.url,\n                data: selections\n            });\n        }\n\n    });\n});\n","Extendware_EWProductAttachment/js/grid/tree-massactions.js":"define([\n    'ko',\n    'underscore',\n    'Extendware_EWProductAttachment/js/grid/massactions'\n], function (ko, _, Massactions) {\n    'use strict';\n\n    return Massactions.extend({\n        defaults: {\n            template: 'Extendware_EWProductAttachment/grid/tree-massactions',\n            submenuTemplate: 'ui/grid/submenu',\n            mwaressubmenuTemplate: 'Extendware_EWProductAttachment/grid/submenu',\n            selectProvider: '',\n            modules: {\n                selections: '${ $.selectProvider }'\n            },\n            listens: {\n                opened: 'hideSubmenus'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .recursiveObserveActions(this.actions());\n\n            return this;\n        },\n\n        /**\n         * Recursive initializes observable actions.\n         *\n         * @param {Array} actions - Action objects.\n         * @returns {Massactions} Chainable.\n         */\n        recursiveObserveActions: function (actions) {\n            _.each(actions, function (action) {\n                if (action.actions) {\n                    action.visible = ko.observable(false);\n                    action.parent = actions;\n                    this.recursiveObserveActions(action.actions);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var action = this.getAction(actionIndex),\n                visibility;\n\n            if (action.visible) {\n                visibility = action.visible();\n\n                this.hideSubmenus(action.parent);\n                action.visible(!visibility);\n\n                return this;\n            }\n\n            return this._super(actionIndex);\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Array} actions - Action objects.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex, actions) {\n            var currentActions = actions || this.actions(),\n                result = false;\n\n            _.find(currentActions, function (action) {\n                if (action.type === actionIndex) {\n                    result = action;\n\n                    return true;\n                }\n\n                if (action.actions) {\n                    result = this.getAction(actionIndex, action.actions);\n\n                    return result;\n                }\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Recursive hide all sub folders in given array.\n         *\n         * @param {Array} actions - Action objects.\n         * @returns {Massactions} Chainable.\n         */\n        hideSubmenus: function (actions) {\n            var currentActions = actions || this.actions();\n\n            _.each(currentActions, function (action) {\n                if (action.visible && action.visible()) {\n                    action.visible(false);\n                }\n\n                if (action.actions) {\n                    this.hideSubmenus(action.actions);\n                }\n            }, this);\n\n            return this;\n        },\n\n        applyMassaction: function (action) {\n            return this._super(this, action);\n        }\n    });\n});\n","Extendware_EWProductAttachment/js/grid/columns/attachment.js":"define([\n    'Magento_Ui/js/grid/columns/column',\n    'jquery',\n    'mage/template',\n    'text!Extendware_EWProductAttachment/template/grid/cells/attachment/preview.html',\n    'Magento_Ui/js/modal/alert'\n], function (Column, $, mageTemplate, attachmentPreviewTemplate, alert) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Extendware_EWProductAttachment/grid/cells/attachment',\n            fieldClass: {\n                'data-grid-attachment-cell': true\n            }\n        },\n        getAlt: function (row) {\n            return row[this.index + '_alt']\n        },\n        getAttachmentList: function (row) {\n            return row[this.index + '_list'];\n        },\n\n        getProductId: function(row) {\n            return row['entity_id'];\n        },\n\n        getAttachmentListId: function(row) {\n            return 'ewproduct-attachment-list-' + this.getProductId(row);\n        },\n\n        isPreviewAvailable: function() {\n            return this.has_preview || false;\n        },\n        preview: function (row) {\n\n            var attachmentList = this.getAttachmentList(row);\n            var productId = this.getProductId(row);\n\n            var modalHtml = mageTemplate(attachmentPreviewTemplate,\n                {\n                    attachmentList: attachmentList,\n                    productId : productId\n                }\n            );\n\n            var previewPopup = $('<div></div>').html(modalHtml);\n            previewPopup.modal({\n                title: this.getAlt(row),\n                innerScroll: true,\n                buttons: [],\n             }\n            ).trigger('openModal');\n        },\n        getFieldHandler: function (row) {\n            if (this.isPreviewAvailable()) {\n                return this.preview.bind(this, row);\n            }\n        },\n\n        getMaxAttachmentItems: function() {\n            return 3;\n        }\n\n    });\n});\n","Extendware_EWProductAttachment/js/grid/columns/attachment/upload.js":"define([\n    'Magento_Ui/js/grid/columns/column',\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'ko',\n    'Extendware_EWProductAttachment/js/init-drop-zone',\n    'Extendware_EWProductAttachment/js/byte-convert',\n    'jquery/file-uploader',\n], function (Column, $, alert, ko, initDropZone, byteConvert) {\n    'use strict';\n\n    var column = Column.extend({\n        defaults: {\n            bodyTmpl: 'Extendware_EWProductAttachment/grid/cells/attachment/upload',\n            fieldClass: {\n                'data-grid-upload-cell': true\n            }\n        },\n\n        getFieldHandler: function (row) {},\n\n        getFileId: function(row) {\n            return 'ewproduct-'+this.getProductId(row);\n        },\n\n        getProductId: function(row) {\n            return row['entity_id'];\n        },\n\n        getFormKey: function(row) {\n            return row[this.index + '_form_key'];\n        },\n\n        getStoreId: function(row) {\n            return row[this.index + '_store_id'];\n        },\n\n        getUploadUrl: function(row) {\n            return row[this.index + '_upload_url'];\n        },\n\n        getMaxFileSize: function(row) {\n            return row[this.index + '_upload_max_size'];\n        },\n\n        getDragAndDropText: function() {\n            return $.mage.__('Click or drop attachment files here');\n        },\n\n        getFileType: function() {\n            return 'attachment';\n        }\n\n    });\n\n    ko.bindingHandlers.fileUpload = {\n        init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            $(element).fileupload({\n                dataType: 'json',\n                sequentialUploads: true,\n                maxFileSize: 200,\n                dropZone: $(element).siblings('.drop-zone'),\n                add: function (e, data) {\n                    $(this).fileupload('process', data).done(function () {\n                        var fileSize, maxFileSize;\n                        var element = e.target;\n                        var errorMessage = null;\n\n                        $.each(data.files, function (index, file) {\n                            fileSize = file.size;\n                            if (typeof fileSize == \"undefined\") {\n                                errorMessage = 'We could not detect a size.';\n                            }\n\n                            maxFileSize = $(element).attr('maxFileSize');\n                            if (fileSize >= maxFileSize) {\n                                errorMessage = 'Can not upload File ' + file.name + '. Max allowed size is ' + byteConvert(maxFileSize) + '.';\n                            }\n                        });\n                        if (errorMessage === null) {\n                            data.submit();\n                        } else {\n                            alert({content: errorMessage});\n                        }\n                    });\n                },\n                progressall: function(event, data) {\n                    var element = event.target;\n                    this.spinner = $(element).closest('.upload-attachment').find('.spinner');\n                    this.spinner.show();\n                },\n                done: function (event, data) {\n                    this.spinner.hide();\n                    if (data.result && (data.result.hasOwnProperty('errorcode') || data.result.hasOwnProperty('error'))) {\n                        var alertMessage = data.result.hasOwnProperty('message') ? data.result.message : data.result.error;\n                        alert({content: alertMessage});\n                    } else {\n                        var element = event.target;\n                        var attachment = $('<span></span>');\n                        attachment.append($('<a/>').attr('href', data.result.file_url).text(data.result.file_name));\n                        attachment.clone().appendTo($('#ewproduct-attachment-list-' + data.result.product_id));\n                        $('</br>').appendTo($('#ewproduct-attachment-list-' + data.result.product_id));\n\n                        var isOk = $(\"<div></div>\").addClass('success-upload-image');\n                        $(element).closest('.upload-attachment').append(isOk);\n                        isOk.fadeOut(1200);\n                    }\n\n                },\n                fail: function (e, data) {\n                    this.spinner.hide();\n                    alert({content: data.result.error});\n                }\n            });\n        },\n        update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {\n            $(document).bind('dragover', function (e) {\n                e.preventDefault();\n                initDropZone(e);\n            });\n        }\n    };\n    return column;\n});\n","Magento_MediaGalleryUi/js/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate',\n    'jquery/uppy-core'\n], function (Component, $, _, validator, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            imageUploadInputSelector: '#image-uploader-form',\n            directoriesPath: 'media_gallery_listing.media_gallery_listing.media_gallery_directories',\n            actionsPath: 'media_gallery_listing.media_gallery_listing.media_gallery_columns.thumbnail_url',\n            messagesPath: 'media_gallery_listing.media_gallery_listing.messages',\n            imageUploadUrl: '',\n            acceptFileTypes: '',\n            allowedExtensions: '',\n            maxFileSize: '',\n            maxFileNameLength: 90,\n            loader: false,\n            modules: {\n                directories: '${ $.directoriesPath }',\n                actions: '${ $.actionsPath }',\n                mediaGridMessages: '${ $.messagesPath }',\n                sortBy: '${ $.sortByName }',\n                listingPaging: '${ $.listingPagingName }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super().observe(\n                [\n                    'loader',\n                    'count'\n                ]\n            );\n\n            return this;\n        },\n\n        /**\n         * Initializes file upload library\n         */\n        initializeFileUpload: function () {\n\n            let id = this.imageUploadInputSelector,\n                arrayFromObj = Array.from,\n                options = {\n                    proudlyDisplayPoweredByUppy: false,\n                    target: id,\n                    hideUploadButton: true,\n                    hideRetryButton: true,\n                    hideCancelButton: true,\n                    inline: true,\n                    showRemoveButtonAfterComplete: true,\n                    showProgressDetails: false,\n                    showSelectedFiles: false,\n                    hideProgressAfterFinish: true\n                },\n\n                uppyDashboard = new Uppy.Uppy({\n                    autoProceed: true,\n                    // validation before file get added\n                    onBeforeFileAdded: (currentFile) => {\n                        if (!this.isSizeExceeded(currentFile).passed) {\n                            this.addValidationErrorMessage(\n                                $t('Cannot upload \"%1\". File exceeds maximum file size limit.')\n                                    .replace('%1', currentFile.name)\n                            );\n                            return false;\n                        } else if (!this.isFileNameLengthExceeded(currentFile).passed) {\n                            this.addValidationErrorMessage(\n                                $t('Cannot upload \"%1\". Filename is too long, must be 90 characters or less.')\n                                    .replace('%1', currentFile.name)\n                            );\n                            return false;\n                        }\n\n                        // code to allow duplicate files from same folder\n                        const modifiedFile = {\n                            ...currentFile,\n                            id:  currentFile.id + '-' + Date.now()\n                        };\n\n                        this.showLoader();\n                        this.count(1);\n                        return modifiedFile;\n                    },\n                    meta: {\n                        'isAjax': true,\n                        'form_key': window.FORM_KEY\n                    }\n                });\n\n            // initialize Uppy upload\n            uppyDashboard.use(Uppy.Dashboard, options);\n\n            // drop area for file upload\n            uppyDashboard.use(Uppy.DropTarget, {\n                target: document.body,\n                onDragOver: () => {\n                    // override Array.from method of legacy-build.min.js file\n                    Array.from = null;\n                },\n                onDragLeave: () => {\n                    Array.from = arrayFromObj;\n                }\n            });\n\n            // upload files on server\n            uppyDashboard.use(Uppy.XHRUpload, {\n                endpoint: this.imageUploadUrl,\n                fieldName: 'image'\n            });\n\n            uppyDashboard.on('file-added', () => {\n                uppyDashboard.setMeta({\n                    target_folder: this.getTargetFolder()\n                });\n            });\n\n            uppyDashboard.on('upload-success', (file, response) => {\n                let data = {\n                    files : [file]\n                };\n\n                if (!response) {\n                    this.showErrorMessage(data, $t('Could not upload the asset.'));\n                    return;\n                }\n\n                if (!response.body.success) {\n                    this.showErrorMessage(data, response.body.message);\n                    return;\n                }\n\n                this.showSuccessMessage(data);\n                this.hideLoader();\n                this.actions().reloadGrid();\n            });\n\n            uppyDashboard.on('complete', () => {\n                this.openNewestImages();\n                this.mediaGridMessages().scheduleCleanup();\n                Array.from = arrayFromObj;\n            });\n\n            // handle network failure or some other upload issue\n            uppyDashboard.on('error', () => {\n                this.showUploadErrorMessage();\n            });\n        },\n\n        /**\n         * Show upload error message\n         */\n        showUploadErrorMessage: function () {\n            let bodyObj = $('body');\n\n            bodyObj.notification('clear');\n            bodyObj.notification('add', {\n                error: true,\n                message: $.mage.__(\n                    'A technical problem with the server created an error. ' +\n                    'Try again to continue what you were doing. If the problem persists, try again later.'\n                ),\n\n                /**\n                 * @param {String} message\n                 */\n                insertMethod: function (message) {\n                    let $wrapper = $('<div></div>').html(message);\n\n                    $('.page-main-actions').after($wrapper);\n                }\n            });\n\n            this.hideLoader();\n        },\n\n        /**\n         * Add error message after validation error.\n         *\n         * @param {String} message\n         */\n        addValidationErrorMessage: function (message) {\n            this.mediaGridMessages().add('error', message);\n\n            this.count() < 2 || this.mediaGridMessages().scheduleCleanup();\n        },\n\n        /**\n         * Checks if size of provided file exceeds\n         * defined in configuration size limits.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {Boolean}\n         */\n        isSizeExceeded: function (file) {\n            return validator('validate-max-size', file.size, this.maxFileSize);\n        },\n\n        /**\n         * Checks if name length of provided file exceeds\n         * defined in configuration size limits.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {Boolean}\n         */\n        isFileNameLengthExceeded: function (file) {\n            return validator('max_text_length', file.name, this.maxFileNameLength);\n        },\n\n        /**\n         * Go to recently uploaded images if at least one uploaded successfully\n         */\n        openNewestImages: function () {\n            this.mediaGridMessages().get().each(function (message) {\n                if (message.code === 'success') {\n                    this.actions().deselectImage();\n                    this.sortBy().selectDefaultOption();\n                    this.listingPaging().goFirst();\n\n                    return false;\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Show error messages with file name.\n         *\n         * @param {Object} data\n         * @param {String} message\n         */\n        showErrorMessage: function (data, message) {\n            data.files.each(function (file) {\n                this.mediaGridMessages().add(\n                    'error',\n                    file.name + ': ' + $t(message)\n                );\n            }.bind(this));\n\n            this.hideLoader();\n        },\n\n        /**\n         * Show success message, and files counts\n         */\n        showSuccessMessage: function () {\n            this.mediaGridMessages().messages.remove(function (item) {\n                return item.code === 'success';\n            });\n            this.mediaGridMessages().add('success', $t('Assets have been successfully uploaded!'));\n            this.count(this.count() + 1);\n\n        },\n\n        /**\n         * Gets Media Gallery selected folder\n         *\n         * @returns {String}\n         */\n        getTargetFolder: function () {\n\n            if (_.isUndefined(this.directories().activeNode()) ||\n                _.isNull(this.directories().activeNode())) {\n                return '/';\n            }\n\n            return this.directories().activeNode();\n        },\n\n        /**\n         * Shows spinner loader\n         */\n        showLoader: function () {\n            this.loader(true);\n        },\n\n        /**\n         * Hides spinner loader\n         */\n        hideLoader: function () {\n            this.loader(false);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/container.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'jquery'\n], function (Element, $) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            containerSelector: '.media-gallery-container',\n            masonryComponentPath: 'media_gallery_listing.media_gallery_listing.media_gallery_columns',\n            modules: {\n                masonry: '${ $.masonryComponentPath }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n\n            $(this.containerSelector).applyBindings();\n\n            return this;\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/directory/directories.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.g\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_MediaGalleryUi/js/directory/actions/createDirectory',\n    'Magento_MediaGalleryUi/js/directory/actions/deleteDirectory',\n    'mage/translate',\n    'validation'\n], function ($, Component, confirm, uiAlert, _, prompt, createDirectory, deleteDirectory, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            directoryTreeSelector: '#media-gallery-directory-tree',\n            deleteButtonSelector: '#delete_folder',\n            createFolderButtonSelector: '#create_folder',\n            messageDelay: 5,\n            selectedFolder: null,\n            messagesName: 'media_gallery_listing.media_gallery_listing.messages',\n            modules: {\n                directoryTree: '${ $.parentName }.media_gallery_directories',\n                messages: '${ $.messagesName }'\n            }\n        },\n\n        /**\n         * Initializes media gallery directories component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe(['selectedFolder']);\n            this._addValidation();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n          * Initialize directories events\n          */\n        initEvents: function () {\n            $(this.deleteButtonSelector).on('delete_folder', function () {\n                this.deleteFolder();\n            }.bind(this));\n\n            $(this.createFolderButtonSelector).on('create_folder', function () {\n                this.createFolder();\n            }.bind(this));\n        },\n\n        /**\n         * Show confirmation popup and create folder based on user input\n         */\n        createFolder: function () {\n            this.getPrompt({\n                title: $t('New Folder Name:'),\n                content: '',\n                actions: {\n                    /**\n                     * Confirm action\n                     */\n                    confirm: function (folderName) {\n                        createDirectory(\n                            this.directoryTree().createDirectoryUrl,\n                            [this.getNewFolderPath(folderName)]\n                        ).then(function () {\n                            this.directoryTree().reloadJsTree().then(function () {\n                                this.directoryTree().locateNode(this.getNewFolderPath(folderName));\n                            }.bind(this));\n                        }.bind(this)).fail(function (error) {\n                            uiAlert({\n                                content: error\n                            });\n                        });\n                    }.bind(this)\n                },\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                    }\n                }, {\n                    text: $t('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n            });\n        },\n\n        /**\n         * Return configured path for folder creation.\n         *\n         * @param {String} folderName\n         * @returns {String}\n         */\n        getNewFolderPath: function (folderName) {\n            if (_.isUndefined(this.selectedFolder()) || _.isNull(this.selectedFolder())) {\n                return folderName;\n            }\n\n            return this.selectedFolder() + '/' + folderName;\n        },\n\n        /**\n          * Return configured prompt with input field\n          */\n        getPrompt: function (data) {\n                prompt({\n                    title: $t(data.title),\n                    content:  $t(data.content),\n                    modalClass: 'media-gallery-folder-prompt',\n                    validation: true,\n                    validationRules: ['required-entry', 'validate-filename'],\n                    attributesField: {\n                        name: 'folder_name',\n                        'data-validate': '{required:true, validate-filename}',\n                        maxlength: '128'\n                    },\n                    attributesForm: {\n                        novalidate: 'novalidate',\n                        action: ''\n                    },\n                    context: this,\n                    actions: data.actions,\n                    buttons: data.buttons\n                });\n            },\n\n        /**\n          * Confirmation popup for delete folder action.\n          */\n        deleteFolder: function () {\n            confirm({\n                title: $t('Are you sure you want to delete this folder?'),\n                modalClass: 'delete-folder-confirmation-popup',\n                content: $t('The following folder is going to be deleted: %1')\n                    .replace('%1', this.selectedFolder()),\n                actions: {\n\n                    /**\n                      * Delete folder on button click\n                      */\n                    confirm: function () {\n                        deleteDirectory(\n                            this.directoryTree().deleteDirectoryUrl,\n                            this.selectedFolder()\n                        ).then(function () {\n                            this.directoryTree().removeNode();\n                            this.directoryTree().selectStorageRoot();\n                            $(window).trigger('folderDeleted.enhancedMediaGallery');\n                        }.bind(this)).fail(function (error) {\n                            uiAlert({\n                                content: error\n                            });\n                        });\n                    }.bind(this)\n                }\n            });\n        },\n\n        /**\n         * Set inactive all nodes, adds disable state to Delete Folder Button\n         */\n        setInActive: function () {\n            this.selectedFolder(null);\n            $(this.deleteButtonSelector).attr('disabled', true).addClass('disabled');\n        },\n\n        /**\n         * Set active node, remove disable state from Delete Forlder button\n         *\n         * @param {String} folderId\n         */\n        setActive: function (folderId) {\n            if (!this.allowedActions.includes('delete_folder')) {\n                return;\n            }\n\n            this.selectedFolder(folderId);\n            $(this.deleteButtonSelector).prop('disabled', false).removeClass('disabled');\n        },\n\n        /**\n         * @private\n         */\n        _addValidation: function () {\n            $.validator.addMethod(\n                'validate-filename', function (value) {\n                    return $.mage.isEmptyNoTrim(value) || /^[a-z0-9\\-\\_]+$/si.test(value);\n                },\n                $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), underscore (_) or hyphen (-) in this field. No spaces or other characters are allowed.')); //eslint-disable-line max-len\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/directory/directoryTree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Base64 */\ndefine([\n    'jquery',\n    'uiComponent',\n    'uiLayout',\n    'underscore',\n    'Magento_MediaGalleryUi/js/directory/actions/createDirectory',\n    'jquery/jstree/jquery.jstree',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_MediaGalleryUi/js/directory/directories'\n], function ($, Component, layout, _, createDirectory) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            bookmarkProvider: 'componentType = bookmark, ns = ${ $.ns }',\n            directoryTreeSelector: '#media-gallery-directory-tree',\n            getDirectoryTreeUrl: 'media_gallery/directories/gettree',\n            createDirectoryUrl: 'media_gallery/directories/create',\n            deleteDirectoryUrl: 'media_gallery/directories/delete',\n            jsTreeReloaded: null,\n            modules: {\n                bookmarks: '${ $.bookmarkProvider }',\n                directories: '${ $.name }_directories',\n                filterChips: '${ $.filterChipsProvider }'\n            },\n            listens: {\n                '${ $.provider }:params.filters.path': 'updateSelectedDirectory'\n            },\n            viewConfig: [{\n                component: 'Magento_MediaGalleryUi/js/directory/directories',\n                name: '${ $.name }_directories',\n                allowedActions: '${ $.allowedActions }'\n            }]\n        },\n\n        /**\n         * Initializes media gallery directories component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe(['activeNode']).initView();\n\n            $.async(\n                this.directoryTreeSelector,\n                this,\n                function () {\n                    this.initJsTreeEvents();\n                    this.renderDirectoryTree().then(function () {\n                        this.initEvents();\n                    }.bind(this));\n                }.bind(this)\n            );\n\n            return this;\n        },\n\n        /**\n         * Render directory tree component.\n         */\n        renderDirectoryTree: function () {\n            return this.getJsonTree().then(function (data) {\n                this.createFolderIfNotExists(data).then(function (isFolderCreated) {\n                    if (isFolderCreated) {\n                        this.getJsonTree().then(function (newData) {\n                            this.createTree(newData);\n                        }.bind(this));\n                    } else {\n                        this.createTree(data);\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Set jstree reloaded\n         *\n         * @param {Boolean} value\n         */\n        setJsTreeReloaded: function (value) {\n            this.jsTreeReloaded = value;\n        },\n\n        /**\n         * Create folder by provided current_tree_path param\n         *\n         * @param {Array} directories\n         */\n        createFolderIfNotExists: function (directories) {\n            var requestedDirectory = this.getRequestedDirectory(),\n                deferred = $.Deferred(),\n                pathArray;\n\n            if (_.isNull(requestedDirectory)) {\n                deferred.resolve(false);\n\n                return deferred.promise();\n            }\n\n            if (this.isDirectoryExist(directories, requestedDirectory)) {\n                deferred.resolve(false);\n\n                return deferred.promise();\n            }\n\n            pathArray = this.convertPathToPathsArray(requestedDirectory);\n\n            $.each(pathArray, function (i, val) {\n                if (this.isDirectoryExist(directories, val)) {\n                    pathArray.splice(i, 1);\n                }\n            }.bind(this));\n\n            createDirectory(\n                this.createDirectoryUrl,\n                pathArray\n            ).then(function () {\n                deferred.resolve(true);\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Verify if directory exists in array\n         *\n         * @param {Array} directories\n         * @param {String} directoryId\n         */\n        isDirectoryExist: function (directories, directoryId) {\n            var found = false;\n\n            /**\n             * Recursive search in array\n             *\n             * @param {Array} data\n             * @param {String} id\n             */\n            function recurse(data, id) {\n                var i;\n\n                for (i = 0; i < data.length; i++) {\n                    if (data[i].id === id) {\n                        found = data[i];\n                        break;\n                    } else if (data[i].children && data[i].children.length) {\n                        recurse(data[i].children, id);\n                    }\n                }\n            }\n\n            recurse(directories, directoryId);\n\n            return found;\n        },\n\n        /**\n         * Convert path string to path array e.g 'path1/path2' -> ['path1', 'path1/path2']\n         *\n         * @param {String} path\n         */\n        convertPathToPathsArray: function (path) {\n            var pathsArray = [],\n                pathString = '',\n                paths = path.split('/');\n\n            $.each(paths, function (i, val) {\n                pathString += i >= 1 ? val : val + '/';\n                pathsArray.push(i >= 1 ? pathString : val);\n            });\n\n            return pathsArray;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Wait for condition then call provided callback\n         */\n        waitForCondition: function (condition, callback) {\n            if (condition()) {\n                setTimeout(function () {\n                    this.waitForCondition(condition, callback);\n                }.bind(this), 100);\n            } else {\n                callback();\n            }\n        },\n\n        /**\n         * Remove ability to multiple select on nodes\n         */\n        disableMultiselectBehavior: function () {\n            $.jstree.defaults.core.multiple = false;\n        },\n\n        /**\n         *  Handle jstree events\n         */\n        initEvents: function () {\n            this.disableMultiselectBehavior();\n\n            $(window).on('reload.MediaGallery', function () {\n                this.getJsonTree().then(function (data) {\n                    this.createFolderIfNotExists(data).then(function (isCreated) {\n                        if (isCreated) {\n                            this.renderDirectoryTree().then(function () {\n                                this.setJsTreeReloaded(true);\n                                this.initJsTreeEvents();\n                            }.bind(this));\n                        } else {\n                            this.updateSelectedDirectory();\n                        }\n                    }.bind(this));\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Fire event for jstree component\n         */\n        initJsTreeEvents: function () {\n            $(this.directoryTreeSelector).on('select_node.jstree', function (element, data) {\n                this.setActiveNodeFilter(data.node.id);\n                this.setJsTreeReloaded(false);\n            }.bind(this));\n\n            $(this.directoryTreeSelector).on('loaded.jstree', function () {\n                this.updateSelectedDirectory();\n            }.bind(this));\n        },\n\n        /**\n         * Verify directory filter on init event, select folder per directory filter state\n         */\n        updateSelectedDirectory: function () {\n            var currentFilterPath = this.filterChips().filters.path,\n                requestedDirectory = this.getRequestedDirectory(),\n                currentTreePath;\n\n            if (_.isUndefined(currentFilterPath)) {\n                this.clearFiltersHandle();\n\n                return;\n            }\n\n            if (!_.isUndefined(this.bookmarks())) {\n                if (!_.size(this.bookmarks().getViewData(this.bookmarks().defaultIndex))) {\n                    setTimeout(function () {\n                        this.updateSelectedDirectory();\n                    }.bind(this), 500);\n\n                    return;\n                }\n            }\n            currentTreePath = this.isFilterApplied(currentFilterPath) || _.isNull(requestedDirectory) ?\n                currentFilterPath : requestedDirectory;\n\n            if (this.folderExistsInTree(currentTreePath)) {\n                this.locateNode(currentTreePath);\n            } else {\n                this.selectStorageRoot();\n            }\n        },\n\n        /**\n         * Verify if directory exists in folder tree\n         *\n         * @param {String} path\n         */\n        folderExistsInTree: function (path) {\n            if (!_.isUndefined(path)) {\n                return $(this.directoryTreeSelector).jstree('get_node', path);\n            }\n\n            return false;\n        },\n\n        /**\n         * Get requested directory from MediabrowserUtility\n         *\n         * @returns {String|null}\n         */\n        getRequestedDirectory: function () {\n            return !_.isUndefined(window.MediabrowserUtility) && window.MediabrowserUtility.pathId !== '' ?\n                Base64.idDecode(window.MediabrowserUtility.pathId) : null;\n        },\n\n        /**\n         * Check if need to select directory by filters state\n         *\n         * @param {String} currentFilterPath\n         */\n        isFilterApplied: function (currentFilterPath) {\n            return !_.isUndefined(currentFilterPath) && currentFilterPath !== '';\n        },\n\n        /**\n         * Locate and higlight node in jstree by path id.\n         *\n         * @param {String} path\n         */\n        locateNode: function (path) {\n            if ($(this.directoryTreeSelector).jstree('is_selected', path)) {\n                return;\n            }\n            $(this.directoryTreeSelector).jstree('deselect_node',\n                $(this.directoryTreeSelector).jstree('get_selected')\n            );\n            $(this.directoryTreeSelector).jstree('open_node', path);\n            $(this.directoryTreeSelector).jstree('select_node', path, true);\n\n        },\n\n        /**\n         * Clear filters\n         */\n        clearFiltersHandle: function () {\n            $(this.directoryTreeSelector).jstree('deselect_all');\n            this.activeNode(null);\n            this.directories().setInActive();\n        },\n\n        /**\n         * Set active node filter, or deselect if the same node clicked\n         *\n         * @param {String} nodePath\n         */\n        setActiveNodeFilter: function (nodePath) {\n            if (this.activeNode() === nodePath && !this.jsTreeReloaded) {\n                this.selectStorageRoot();\n            } else {\n                this.selectFolder(nodePath);\n            }\n        },\n\n        /**\n         * Remove folders selection -> select storage root\n         */\n        selectStorageRoot: function () {\n            var filters = {},\n                applied = this.filterChips().get('applied');\n\n            $(this.directoryTreeSelector).jstree('deselect_all');\n\n            filters = $.extend(true, filters, applied);\n            delete filters.path;\n            this.filterChips().set('applied', filters);\n            this.activeNode(null);\n            this.waitForCondition(\n                function () {\n                    return _.isUndefined(this.directories());\n                }.bind(this),\n                function () {\n                    this.directories().setInActive();\n                }.bind(this)\n            );\n        },\n\n        /**\n         * Set selected folder\n         *\n         * @param {String} path\n         */\n        selectFolder: function (path) {\n            this.activeNode(path);\n\n            this.waitForCondition(\n                function () {\n                    return _.isUndefined(this.directories());\n                }.bind(this),\n                function () {\n                    this.directories().setActive(path);\n                }.bind(this)\n            );\n\n            this.applyFilter(path);\n        },\n\n        /**\n         * Remove active node from directory tree, and select next\n         */\n        removeNode: function () {\n            $(this.directoryTreeSelector).jstree('delete_node',\n                $(this.directoryTreeSelector).jstree('get_selected')\n            );\n        },\n\n        /**\n         * Apply folder filter by path\n         *\n         * @param {String} path\n         */\n        applyFilter: function (path) {\n            var filters = {},\n                applied = this.filterChips().get('applied');\n\n            filters = $.extend(true, filters, applied);\n            filters.path = path;\n            this.filterChips().set('applied', filters);\n        },\n\n        /**\n         * Reload jstree and update jstree events\n         */\n        reloadJsTree: function () {\n            var deferred = $.Deferred();\n\n            this.getJsonTree().then(function (data) {\n                $(this.directoryTreeSelector).jstree(true).settings.core.data = data;\n                $(this.directoryTreeSelector).jstree(true).refresh(false, true);\n                this.setJsTreeReloaded(true);\n                deferred.resolve();\n            }.bind(this));\n\n            return deferred.promise();\n        },\n\n        /**\n         * Get json data for jstree\n         */\n        getJsonTree: function () {\n            var deferred = $.Deferred();\n\n            $.ajax({\n                url: this.getDirectoryTreeUrl,\n                type: 'GET',\n                dataType: 'json',\n\n                /**\n                 * Success handler for request\n                 *\n                 * @param {Object} data\n                 */\n                success: function (data) {\n                    deferred.resolve(data);\n                },\n\n                /**\n                 * Error handler for request\n                 *\n                 * @param {Object} jqXHR\n                 * @param {String} textStatus\n                 */\n                error: function (jqXHR, textStatus) {\n                    deferred.reject();\n                    throw textStatus;\n                }\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Initialize directory tree\n         *\n         * @param {Array} data\n         */\n        createTree: function (data) {\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            $(this.directoryTreeSelector).jstree({\n                plugins: [],\n                checkbox: {\n                    three_state: false,\n                    cascade: ''\n                },\n                core: {\n                    data: data,\n                    check_callback: true,\n                    themes: {\n                        dots: false\n                    }\n                }\n            });\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/directory/actions/deleteDirectory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (deleteFolderUrl, path) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'POST',\n            url: deleteFolderUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                path: path\n            },\n            context: this,\n\n            /**\n             * Resolve  if delete folder success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not delete the directory.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/directory/actions/createDirectory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (createFolderUrl, paths) {\n        var deferred = $.Deferred(),\n            message,\n            data = {\n                paths: paths\n            };\n\n        $.ajax({\n            type: 'POST',\n            url: createFolderUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: data,\n            context: this,\n\n            /**\n             * Resolve  if success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not create the directory.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/image/image-details.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_MediaGalleryUi/js/action/getDetails'\n], function ($, _, Component, getDetails) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/image/image-details',\n            modalSelector: '',\n            modalWindowSelector: '',\n            imageDetailsUrl: '/media_gallery/image/details',\n            images: [],\n            tagListLimit: 7,\n            showAllTags: false,\n            image: null,\n            modules: {\n                mediaGridMessages: '${ $.mediaGridMessages }'\n            }\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'image',\n                    'showAllTags'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Show image details by ID\n         *\n         * @param {String} imageId\n         */\n        showImageDetailsById: function (imageId) {\n            if (_.isUndefined(this.images[imageId])) {\n                getDetails(this.imageDetailsUrl, [imageId]).then(function (imageDetails) {\n                    this.images[imageId] = imageDetails[imageId];\n                    this.image(this.images[imageId]);\n                    this.openImageDetailsModal();\n                }.bind(this)).fail(function (error) {\n                    this.addMediaGridMessage('error', error);\n                }.bind(this));\n\n                return;\n            }\n\n            if (this.image() && this.image().id === imageId) {\n                this.openImageDetailsModal();\n\n                return;\n            }\n\n            this.image(this.images[imageId]);\n            this.openImageDetailsModal();\n        },\n\n        /**\n         * Open image details popup\n         */\n        openImageDetailsModal: function () {\n            var modalElement = $(this.modalSelector);\n\n            if (!modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            this.showAllTags(false);\n            modalElement.modal('openModal');\n        },\n\n        /**\n         * Close image details popup\n         */\n        closeImageDetailsModal: function () {\n            var modalElement = $(this.modalSelector);\n\n            if (!modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            modalElement.modal('closeModal');\n        },\n\n        /**\n         * Add media grid message\n         *\n         * @param {String} code\n         * @param {String} message\n         */\n        addMediaGridMessage: function (code, message) {\n            this.mediaGridMessages().add(code, message);\n            this.mediaGridMessages().scheduleCleanup();\n        },\n\n        /**\n         * Get tag text\n         *\n         * @param {String} tagText\n         * @param {Number} tagIndex\n         * @return {String}\n         */\n        getTagText: function (tagText, tagIndex) {\n            return tagText + (this.image().tags.length - 1 === tagIndex ? '' : ',');\n        },\n\n        /**\n         * Show all image tags\n         */\n        showMoreImageTags: function () {\n            this.showAllTags(true);\n        },\n\n        /**\n         * Is value an object\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isArray: function (value) {\n            return _.isArray(value);\n        },\n\n        /**\n         * Is value not empty\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        notEmpty: function (value) {\n            return value.length > 0;\n        },\n\n        /**\n         * Get name and number text for used in link\n         *\n         * @param {Object} item\n         * @returns {String}\n         */\n        getUsedInText: function (item) {\n            return item.name +  '(' + item.number + ')';\n        },\n\n        /**\n         * Get filter url\n         *\n         * @param {String} link\n         */\n        getFilterUrl: function (link) {\n            return link + '?filters[asset_id]=[' + this.image().id + ']';\n        },\n\n        /**\n         * Check if details modal is active\n         * @return {Boolean}\n         */\n        isActive: function () {\n            return $(this.modalWindowSelector).hasClass('_show');\n        },\n\n        /**\n         * Remove image details\n         *\n         * @param {String} id\n         */\n        removeCached: function (id) {\n            delete this.images[id];\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/image/image-actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiElement',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction',\n    'Magento_MediaGalleryUi/js/action/saveDetails',\n    'mage/validation'\n], function ($, _, Element, deleteImageWithDetailConfirmation, addSelected, saveDetails) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            modalSelector: '',\n            modalWindowSelector: '',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            mediaGalleryEditDetailsName: 'mediaGalleryEditDetails',\n            template: 'Magento_MediaGalleryUi/image/actions',\n            modules: {\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }',\n                mediaGalleryEditDetails: '${ $.mediaGalleryEditDetailsName }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.closeViewDetailsModal.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Close the images details modal\n         */\n        closeModal: function () {\n            var modalElement = $(this.modalSelector),\n                modalWindow = $(this.modalWindowSelector);\n\n            if (!modalWindow.hasClass('_show') || !modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            this.mediaGalleryEditDetails().keywordsSelect().cacheOptions.plain = [];\n            modalElement.modal('closeModal');\n        },\n\n        /**\n         * Opens the image edit panel\n         */\n        editImageAction: function () {\n            var record = this.imageModel().getSelected().id;\n\n            this.mediaGalleryEditDetails().showEditDetailsPanel(record);\n        },\n\n        /**\n         * Delete image action\n         */\n        deleteImageAction: function () {\n            var imageDetailsUrl = this.mediaGalleryImageDetails().imageDetailsUrl,\n                deleteImageUrl = this.imageModel().deleteImageUrl;\n\n            deleteImageWithDetailConfirmation.deleteImageAction(\n                [this.imageModel().getSelected().id],\n                imageDetailsUrl,\n                deleteImageUrl\n            );\n        },\n\n        /**\n         * Save image details action\n         */\n        saveImageDetailsAction: function () {\n            var saveDetailsUrl = this.mediaGalleryEditDetails().saveDetailsUrl,\n                modalElement = $(this.modalSelector),\n                form = modalElement.find('#image-edit-details-form'),\n                imageId = this.imageModel().getSelected().id,\n                keywords = this.mediaGalleryEditDetails().selectedKeywords(),\n                imageDetails = this.mediaGalleryImageDetails(),\n                imageEditDetails = this.mediaGalleryEditDetails();\n\n            if (form.validation('isValid')) {\n                saveDetails(\n                    saveDetailsUrl,\n                    [form.serialize(), $.param({\n                        'keywords': keywords\n                    })].join('&')\n                ).then(function () {\n                    this.closeModal();\n                    this.imageModel().reloadGrid();\n                    imageDetails.removeCached(imageId);\n                    imageEditDetails.removeCached(imageId);\n\n                    if (imageDetails.isActive()) {\n                        imageDetails.showImageDetailsById(imageId);\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Add Image\n         */\n        addImage: function () {\n            addSelected.insertImage(\n                this.imageModel().getSelected(),\n                {\n                    onInsertUrl: this.imageModel().onInsertUrl,\n                    storeId: this.imageModel().storeId\n                }\n            );\n            this.closeModal();\n        },\n\n        /**\n         * Close view details modal after confirm deleting image\n         */\n        closeViewDetailsModal: function () {\n            this.closeModal();\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/image/image-edit.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'uiLayout',\n    'Magento_Ui/js/lib/key-codes',\n    'Magento_MediaGalleryUi/js/action/getDetails',\n    'mage/validation'\n], function ($, _, Component, layout, keyCodes, getDetails) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/image/image-edit',\n            modalSelector: '.media-gallery-edit-image-details-modal',\n            imageEditDetailsUrl: '/media_gallery/image/details',\n            saveDetailsUrl: '/media_gallery/image/saveDetails',\n            images: [],\n            image: null,\n            keywordOptions: [],\n            selectedKeywords: [],\n            newKeyword: '',\n            newKeywordSelector: '#keyword',\n            modules: {\n                mediaGridMessages: '${ $.mediaGridMessages }',\n                keywordsSelect: '${ $.name }_keywords'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_Ui/js/form/element/ui-select',\n                    name: '${ $.name }_keywords',\n                    template: 'ui/grid/filters/elements/ui-select',\n                    disableLabel: true\n                }\n            ],\n            exports: {\n                keywordOptions: '${ $.name }_keywords:options'\n            },\n            links: {\n                selectedKeywords: '${ $.name }_keywords:value'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super().initView();\n\n            return this;\n        },\n\n        /**\n         * Add a new keyword to select\n         */\n        addKeyword: function () {\n            var options = this.keywordOptions(),\n                selected = this.selectedKeywords(),\n                newKeywordField = $(this.newKeywordSelector);\n\n            newKeywordField.validation();\n\n            if (!newKeywordField.validation('isValid') || this.newKeyword() === '') {\n                return;\n            }\n\n            options.push(this.getOptionForKeyword(this.newKeyword()));\n            selected.push(this.newKeyword());\n            this.newKeyword('');\n\n            this.keywordOptions(options);\n            this.selectedKeywords(selected);\n        },\n\n        /**\n         * Create an option object based on keyword string\n         *\n         * @param {String} keyword\n         * @returns {Object}\n         */\n        getOptionForKeyword: function (keyword) {\n            return {\n                'is_active': 1,\n                level: 1,\n                value: keyword,\n                label: keyword\n            };\n        },\n\n        /**\n         * Convert array of keywords to options format\n         *\n         * @param {Array} tags\n         */\n        setKeywordOptions: function (tags) {\n            var options = [];\n\n            tags.forEach(function (tag) {\n                options.push(this.getOptionForKeyword(tag));\n            }.bind(this));\n\n            this.keywordOptions(options);\n            this.selectedKeywords(tags);\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'image',\n                    'keywordOptions',\n                    'selectedKeywords',\n                    'newKeyword'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get image details by ID\n         *\n         * @param {String} imageId\n         */\n        showEditDetailsPanel: function (imageId) {\n            if (_.isUndefined(this.images[imageId])) {\n                getDetails(this.imageEditDetailsUrl, [imageId]).then(function (imageDetails) {\n                    this.images[imageId] = imageDetails[imageId];\n                    this.image(this.images[imageId]);\n                    this.openEditImageDetailsModal();\n                }.bind(this)).fail(function (error) {\n                    this.addMediaGridMessage('error', error);\n                }.bind(this));\n\n                return;\n            }\n\n            if (this.image() && this.image().id === imageId) {\n                this.openEditImageDetailsModal();\n\n                return;\n            }\n\n            this.image(this.images[imageId]);\n            this.openEditImageDetailsModal();\n        },\n\n        /**\n         * Open edit image details popup\n         */\n        openEditImageDetailsModal: function () {\n            var modalElement = $(this.modalSelector);\n\n            if (!modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            this.setKeywordOptions(this.image().tags);\n            this.newKeyword('');\n\n            modalElement.modal('openModal');\n        },\n\n        /**\n         * Close image details popup\n         */\n        closeImageDetailsModal: function () {\n            var modalElement = $(this.modalSelector);\n\n            if (!modalElement.length || _.isUndefined(modalElement.modal)) {\n                return;\n            }\n\n            modalElement.modal('closeModal');\n        },\n\n        /**\n         * Add media grid message\n         *\n         * @param {String} code\n         * @param {String} message\n         */\n        addMediaGridMessage: function (code, message) {\n            this.mediaGridMessages().add(code, message);\n            this.mediaGridMessages().scheduleCleanup();\n        },\n\n        /**\n         * Handle Enter key event to save image details\n         *\n         * @param {Object} data\n         * @param {jQuery.Event} event\n         * @returns {Boolean}\n         */\n        handleEnterKey: function (data, event) {\n            var modalElement = $(this.modalSelector),\n                key = keyCodes[event.keyCode];\n\n            if (key === 'enterKey') {\n                event.preventDefault();\n                modalElement.find('.page-action-buttons button.save').trigger('click');\n            }\n\n            return true;\n        },\n\n        /**\n         * Remove cached image details in edit form\n         *\n         * @param {String} id\n         */\n        removeCached: function (id) {\n            delete this.images[id];\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_MediaGalleryUi/js/action/getDetails',\n    'Magento_MediaGalleryUi/js/action/deleteImages',\n    'mage/translate'\n], function ($, _, getDetails, deleteImages, $t) {\n    'use strict';\n\n    return {\n\n        /**\n         * Get information about image use\n         *\n         * @param {Array} recordsIds\n         * @param {String} imageDetailsUrl\n         * @param {String} deleteImageUrl\n         */\n        deleteImageAction: function (recordsIds, imageDetailsUrl, deleteImageUrl) {\n            var confirmationContent = $t('%1Are you sure you want to delete \"%2\" image(s)?')\n                .replace('%2', Object.keys(recordsIds).length),\n                deferred = $.Deferred();\n\n            getDetails(imageDetailsUrl, recordsIds).then(function (images) {\n                        confirmationContent = confirmationContent.replace(\n                            '%1',\n                            this.getRecordRelatedContentMessage(images) + ' '\n                        );\n                    }.bind(this)).fail(function () {\n                        confirmationContent = confirmationContent.replace('%1', '');\n                    }).always(function () {\n                        deleteImages(recordsIds, deleteImageUrl, confirmationContent).then(function (status) {\n                            deferred.resolve(status);\n                        }).fail(function (error) {\n                            deferred.reject(error);\n                        });\n                    });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Get information about image use\n         *\n         * @param {Object|String} images\n         * @return {String}\n         */\n        getRecordRelatedContentMessage: function (images) {\n            var usedInMessage = $t('The selected assets are used in the content of the following entities: '),\n                usedIn = {};\n\n            $.each(images, function (key, image) {\n                $.each(image.details, function (sectionIndex, section) {\n                    if (section.title === 'Used In' && _.isObject(section) && !_.isEmpty(section.value)) {\n                        $.each(section.value, function (entityTypeIndex, entityTypeData) {\n                            usedIn[entityTypeData.name] = entityTypeData.name in usedIn ?\n                                usedIn[entityTypeData.name] + entityTypeData.number :\n                                entityTypeData.number;\n                        });\n                    }\n                });\n            });\n\n            if (_.isEmpty(usedIn)) {\n                return '';\n            }\n\n            return usedInMessage + this.usedInObjectToString(usedIn);\n        },\n\n        /**\n         * Fromats usedIn object to string\n         *\n         * @param {Object} usedIn\n         * @return {String}\n         */\n        usedInObjectToString: function (usedIn) {\n            var entities = [];\n\n            $.each(usedIn, function (entityName, number) {\n                entities.push(entityName + '(' + number + ')');\n            });\n\n            return entities.join(', ') + '.';\n        }\n    };\n});\n","Magento_MediaGalleryUi/js/action/saveDetails.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (saveImageDetailsUrl, data) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'POST',\n            url: saveImageDetailsUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: data,\n\n            /**\n             * Resolve with image details if success, reject with response message otherwise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not save image details.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/action/deleteImages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/url',\n    'Magento_MediaGalleryUi/js/grid/messages',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, _, urlBuilder, messages, confirmation, $t) {\n    'use strict';\n\n    return function (ids, deleteUrl, confirmationContent) {\n        var deferred = $.Deferred(),\n               title = $t('Delete assets'),\n               cancelText = $t('Cancel'),\n               deleteImageText = $t('Delete');\n\n        /**\n         * Send deletion request with redords ids\n         *\n         * @param {Array} recordIds\n         * @param {String} serviceUrl\n         */\n        function sendRequest(recordIds, serviceUrl) {\n\n            $.ajax({\n                type: 'POST',\n                url: serviceUrl,\n                dataType: 'json',\n                showLoader: true,\n                data: {\n                    'form_key': window.FORM_KEY,\n                    'ids': recordIds\n                },\n                context: this,\n\n                /**\n                 * Success handler for deleting image\n                 *\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var message = !_.isUndefined(response.message) ? response.message : null;\n\n                    if (!response.success) {\n                        message = message || $t('There was an error on attempt to delete the images.');\n                        $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                            reload: false,\n                            message: message,\n                            code: 'error'\n                        });\n\n                        deferred.reject(message);\n                    }\n\n                    message = message || $t('You have successfully removed the images.');\n                    $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                        reload: true,\n                        message: message,\n                        code: 'success'\n                    });\n                    deferred.resolve(message);\n                },\n\n                /**\n                 * Error handler for deleting image\n                 *\n                 * @param {Object} response\n                 */\n                error: function (response) {\n                    var message;\n\n                    if (typeof response.responseJSON === 'undefined' ||\n                        typeof response.responseJSON.message === 'undefined'\n                    ) {\n                        message = $t('There was an error on attempt to delete the image.');\n                    } else {\n                        message = response.responseJSON.message;\n                    }\n\n                    $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                        reload: false,\n                        message: message,\n                        code: 'error'\n                    });\n                    deferred.reject(message);\n                }\n            });\n        }\n\n        confirmation({\n            title: title,\n            modalClass: 'media-gallery-delete-image-action',\n            content: confirmationContent,\n            buttons: [\n                {\n                    text: cancelText,\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.resolve({\n                            status: 'canceled'\n                        });\n                    }\n                },\n                {\n                    text: deleteImageText,\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Delete Image and close modal\n                     */\n                    click: function () {\n                        sendRequest(ids, deleteUrl);\n                        this.closeModal();\n                    }\n                }\n            ]\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/action/getDetails.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (imageDetailsUrl, imageIds) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'GET',\n            url: imageDetailsUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                'ids': imageIds\n            },\n            context: this,\n\n            /**\n             * Resolve with image details if success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.imageDetails);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not retrieve image details.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/validation/validate-image-description.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/validate',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-description', function (value) {\n            return /^[a-zA-Z0-9\\-\\_\\.\\,\\n\\s]+$|^$/i.test(value);\n\n        }, $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), ' +\n            'dots (.), commas(,), underscores (_), dashes (-), and spaces on this field.'));\n});\n","Magento_MediaGalleryUi/js/validation/validate-image-keyword.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/validate',\n    'mage/translate'\n], function ($, validate, $t) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-keyword', function (value) {\n            return /^[a-zA-Z0-9\\-\\_\\.\\,]+$|^$/i.test(value);\n\n        }, $t('Please use only letters (a-z or A-Z), numbers (0-9), dots (.), commas(,), ' +\n            'underscores (_) and dashes(-) on this field.'));\n});\n","Magento_MediaGalleryUi/js/validation/validate-image-title.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/validate',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-title', function (value) {\n            return /^[a-zA-Z0-9\\-\\_\\.\\,\\s]+$/i.test(value);\n\n        }, $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), dots (.), commas(,), ' +\n            'underscores (_), dashes(-) and spaces on this field.'));\n});\n","Magento_MediaGalleryUi/js/grid/masonry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/masonry',\n    'jquery'\n], function (Masonry, $) {\n    'use strict';\n\n    return Masonry.extend({\n        defaults: {\n            modules: {\n                provider: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n         * Initialize events\n         */\n        initEvents: function () {\n            $(window).on('folderDeleted.enhancedMediaGallery', this.reloadGrid.bind(this));\n        },\n\n        /**\n         * Reload grid\n         */\n        reloadGrid: function () {\n            var provider = this.provider(),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n            provider.reload();\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/sortBy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/sortBy'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            columnIndexMap: {}\n        },\n\n        /**\n         * Prepared sort order options\n         */\n        preparedOptions: function (columns) {\n            var index = 0,\n                sortBy;\n\n            if (columns && columns.length > 0) {\n                columns.map(function (column) {\n                    if (column.sortable === true) {\n                        sortBy = column['sort_by'] || {};\n\n                        if (sortBy.excluded) {\n                            return;\n                        }\n\n                        this.options.push({\n                            value: column.index,\n                            label: column.label,\n                            sortByField: sortBy.field,\n                            sortDirection: sortBy.direction\n                        });\n\n                        this.columnIndexMap[column.index] = index++;\n\n                        this.isVisible(true);\n                    } else {\n                        this.isVisible(false);\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Apply changes\n         */\n        applyChanges: function () {\n            var column = this.getColumn(this.selectedOption());\n\n            this.applied({\n                field: column.sortByField || this.selectedOption(),\n                direction: column.sortDirection || this.sorting\n            });\n        },\n\n        /**\n         * Get column by index\n         *\n         * @param {String} optionIndex\n         * @returns {Object}\n         */\n        getColumn: function (optionIndex) {\n            return this.options[this.columnIndexMap[optionIndex]];\n        },\n\n        /**\n         * Select default option\n         */\n        selectDefaultOption: function () {\n            this.selectedOption(this.options[0].value);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'escaper'\n], function (Element, escaper) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/grid/messages',\n            messageDelay: 5,\n            messages: [],\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'messages'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get messages\n         *\n         * @returns {Array}\n         */\n        get: function () {\n            return this.messages();\n        },\n\n        /**\n         * Add message\n         *\n         * @param {String} type\n         * @param {String} message\n         */\n        add: function (type, message) {\n            this.messages.push({\n                code: type,\n                message: message\n            });\n        },\n\n        /**\n         * Clear messages\n         */\n        clear: function () {\n            this.messages.removeAll();\n        },\n\n        /**\n         * Schedule message cleanup\n         *\n         * @param {Number} delay\n         */\n        scheduleCleanup: function (delay) {\n            // eslint-disable-next-line no-unused-vars\n            var timerId;\n\n            delay = delay || this.messageDelay;\n\n            // eslint-disable-next-line no-unused-vars\n            timerId = setTimeout(function () {\n                clearTimeout(timerId);\n                this.clear();\n            }.bind(this), Number(delay) * 1000);\n        },\n\n        /**\n         * Prepare the given message to be rendered as HTML\n         *\n         * @param {String} message\n         * @return {String}\n         */\n        prepareMessageUnsanitizedHtml: function (message) {\n            return escaper.escapeHtml(message, this.allowedTags);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/massaction/massactionView.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'mage/translate',\n    'text!Magento_MediaGalleryUi/template/grid/massactions/massactionButtons.html'\n], function ($, Component, $t, massactionButtons) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            gridSelector: '[data-id=\"media-gallery-masonry-grid\"]',\n            standAloneTitle: 'Manage Gallery',\n            slidePanelTitle: 'Media Gallery',\n            defaultTitle: null,\n            are: null,\n            standAloneArea: 'standalone',\n            slidepanelArea: 'slidepanel',\n            massactionButtonsSelector: '.massaction-buttons',\n            buttonsSelectorStandalone: '.page-actions-buttons',\n            buttonsSelectorSlidePanel: '.page-actions.floating-header',\n            buttons: '.page-main-actions :button',\n            massactionModeTitle: $t('Select Images to Delete')\n        },\n\n        /**\n         * Initializes media gallery massaction component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe([\n                'massActionMode'\n            ]);\n\n            return this;\n        },\n\n        /**\n         * Switch massaction view state per active mode.\n         */\n        switchView: function () {\n            this.changePageTitle();\n            this.switchButtons();\n        },\n\n        /**\n         * Hide or show buttons per active mode.\n         */\n        switchButtons: function () {\n            if (this.massActionMode()) {\n                this.activateMassactionButtonView();\n            } else {\n                this.revertButtonsToDefaultView();\n            }\n        },\n\n        /**\n         * Sets buttons to default regular -mode view.\n         */\n        revertButtonsToDefaultView: function () {\n            $(this.buttons).removeClass('no-display');\n            $(this.massactionButtonsSelector).remove();\n        },\n\n        /**\n          * Activate mass action buttons view\n          */\n        activateMassactionButtonView: function () {\n            var buttonsContainer;\n\n            $(this.buttons).addClass('no-display');\n\n            buttonsContainer =  this.area === this.standAloneArea ?\n                this.buttonsSelectorStandalone :\n                this.buttonsSelectorSlidePanel;\n\n            $(buttonsContainer).append(massactionButtons);\n            $(this.massactionButtonsSelector).applyBindings();\n        },\n\n        /**\n         * Change page title per active mode.\n         */\n        changePageTitle: function () {\n            var title = $('h1:contains(' + this.standAloneTitle + ')'),\n                titleSelector;\n\n            if (title.length === 1)  {\n                titleSelector = title;\n                this.area = this.standAloneArea;\n            } else {\n                titleSelector = $('h1:contains(' + this.slidePanelTitle + ')');\n                this.area = this.slidepanelArea;\n            }\n\n            if (this.massActionMode()) {\n                this.defaultTitle = titleSelector.text();\n                titleSelector.text(this.massactionModeTitle);\n            } else {\n                titleSelector = $('h1:contains(' + this.massactionModeTitle + ')');\n                titleSelector.text(this.defaultTitle);\n            }\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/massaction/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'uiLayout',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function ($, Component, DeleteImages, Layout, _, uiAlert, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            deleteButtonSelector: '#delete_selected_massaction',\n            deleteImagesSelector: '#delete_massaction',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            modules: {\n                massactionView: '${ $.name }_view',\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_MediaGalleryUi/js/grid/massaction/massactionView',\n                    name: '${ $.name }_view'\n                }\n            ],\n            imports: {\n                imageItems: '${ $.mediaGalleryProvider }:data.items'\n            },\n            listens: {\n                imageItems: 'checkButtonVisibility'\n            },\n            exports: {\n                massActionMode: '${ $.name }_view:massActionMode'\n            }\n        },\n\n        /**\n         * Initializes media gallery massaction component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe([\n                'massActionMode'\n            ]);\n            this.initView();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            Layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Initilize massactions events for media gallery grid.\n         */\n        initEvents: function () {\n            $(window).on('massAction.MediaGallery', function () {\n                if (this.massActionMode()) {\n                    return;\n                }\n                this.imageModel().selected(null);\n                this.massActionMode(true);\n                this.switchMode();\n            }.bind(this));\n\n            $(window).on('terminateMassAction.MediaGallery', function () {\n                if (!this.massActionMode()) {\n                    return;\n                }\n\n                this.massActionMode(false);\n                this.switchMode();\n                this.imageModel().updateSelected();\n            }.bind(this));\n        },\n\n        /**\n         * Return total selected items.\n         */\n        getSelectedCount: function () {\n            if (this.massActionMode() && !_.isNull(this.imageModel().selected())) {\n                return Object.keys(this.imageModel().selected()).length;\n            }\n\n            return 0;\n        },\n\n        /**\n         * If images records less than one, disable \"delete images\" button\n         */\n        checkButtonVisibility: function () {\n            if (!this.allowedActions.includes('delete_assets')) {\n                return;\n            }\n\n            if (this.imageItems.length < 1) {\n                $(this.deleteImagesSelector).addClass('disabled');\n            } else {\n                $(this.deleteImagesSelector).removeClass('disabled');\n            }\n        },\n\n        /**\n         * Switch massaction per current event.\n         */\n        switchMode: function () {\n            this.massactionView().switchView();\n            this.handleDeleteAction();\n        },\n\n        /**\n         * Change Default  behavior of delete image to bulk deletion.\n         */\n        handleDeleteAction: function () {\n            if (this.massActionMode()) {\n                $(this.deleteButtonSelector).on('massDelete.MediaGallery', function () {\n                    if (this.getSelectedCount() < 1) {\n                        uiAlert({\n                            content: $t('You need to select at least one image')\n                        });\n\n                    } else {\n                        DeleteImages.deleteImageAction(\n                            this.imageModel().selected(),\n                            this.mediaGalleryImageDetails().imageDetailsUrl,\n                            this.imageModel().deleteImageUrl\n                        ).then(function (response) {\n                            if (response.status === 'canceled') {\n                                return;\n                            }\n                            $(window).trigger('terminateMassAction.MediaGallery');\n                        });\n                    }\n                }.bind(this));\n            }\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/grid/columns/column',\n    'uiLayout',\n    'underscore'\n], function ($, Column, layout, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_MediaGalleryUi/grid/columns/image',\n            messageContentSelector: 'ul.messages',\n            mediaGalleryContainerSelector: '.media-gallery-container',\n            deleteImageUrl: 'media_gallery/image/delete',\n            addSelectedBtnSelector: '#add_selected',\n            deleteSelectedBtnSelector: '#delete_selected',\n            gridSelector: '[data-id=\"media-gallery-masonry-grid\"]',\n            selected: null,\n            allowedActions: [],\n            fields: {\n                id: 'id',\n                url: 'url',\n                alt: 'name'\n            },\n            modules: {\n                actions: '${ $.name }_actions',\n                provider: '${ $.provider }',\n                messages: '${ $.messagesName }',\n                massaction: '${ $.massactionComponentName }'\n            },\n            imports: {\n                activeDirectory: '${ $.mediaGalleryDirectoryComponent }:activeNode'\n            },\n            listens: {\n                activeDirectory: 'selectDirectoryHandle',\n                '${ $.massactionComponentName }:massActionMode': 'updateSelected'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_MediaGalleryUi/js/grid/columns/image/actions',\n                    name: '${ $.name }_actions',\n                    imageModelName: '${ $.name }',\n                    allowedActions: '${ $.allowedActions }'\n                }\n            ]\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initView();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.reloadMediaGrid.bind(this));\n            $(window).on('reload.MediaGallery', this.reloadGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'selected'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Is massaction mode active.\n         */\n        isMassActionMode: function () {\n            return this.massaction().massActionMode();\n        },\n\n        /**\n         * Returns url to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getUrl: function (record) {\n            return record[this.fields.url];\n        },\n\n        /**\n         * Returns id to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Number}\n         */\n        getId: function (record) {\n            return record[this.fields.id];\n        },\n\n        /**\n         * Update selected items per massaction mode.\n         */\n        updateSelected: function () {\n            this.selected({});\n            this.hideAddSelectedAndDeleteButon();\n        },\n\n        /**\n         * Returns name to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getImageAlt: function (record) {\n            return record[this.fields.alt];\n        },\n\n        /**\n         * Check if the record is currently selected\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isSelected: function (record) {\n            if (_.isNull(this.selected())) {\n                return false;\n            }\n\n            if (this.massaction().massActionMode()) {\n                return this.selected()[record.id];\n            }\n\n            return this.getId(this.selected()) === this.getId(record);\n        },\n\n        /**\n         * Click on image\n         *\n         * @param {Object} record\n         * @param {Boolean} collapsibleOpened\n         */\n        clickOnImage: function (record, collapsibleOpened) {\n            if (!collapsibleOpened) {\n                this.select(record);\n            }\n        },\n\n        /**\n         * Click on three-dots\n         *\n         * @param {Object} record\n         * @param {Boolean} collapsibleOpened\n         */\n        clickOnThreeDots: function (record, collapsibleOpened) {\n            if (!this.isSelected(record) || collapsibleOpened) {\n                this.select(record);\n            }\n        },\n\n        /**\n         * Handle checkbox click.\n         */\n        checkboxClick: function (record) {\n            var items = this.selected();\n\n            if (this.selected()[record.id])  {\n                delete items[record.id];\n                this.selected(items);\n            } else {\n                items[record.id] = record.id;\n                this.selected(items);\n            }\n\n            return true;\n        },\n\n        /**\n         * Set the record as selected\n         */\n        select: function (record) {\n            if (this.massaction().massActionMode()) {\n                return this.checkboxClick(record);\n            }\n\n            this.isSelected(record) ? this.selected(null) : this.selected(record);\n            this.toggleAddSelectedButton();\n\n            return true;\n        },\n\n        /**\n         * Deselect the record\n         */\n        deselectImage: function () {\n            this.selected(null);\n            this.toggleAddSelectedButton();\n        },\n\n        /**\n         * Get the selected record\n         * @returns {Object}\n         */\n        getSelected: function () {\n            return this.selected();\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Toggle add selected button\n         */\n        toggleAddSelectedButton: function () {\n            if (this.selected() === null) {\n                this.hideAddSelectedAndDeleteButon();\n\n                return;\n            }\n\n            if (this.allowedActions.includes('insert')) {\n                $(this.addSelectedBtnSelector).removeClass('no-display');\n            }\n\n            if (this.allowedActions.includes('delete')) {\n                $(this.deleteSelectedBtnSelector).removeClass('no-display');\n            }\n        },\n\n        /**\n         * Hide add selected and Delete button\n         */\n        hideAddSelectedAndDeleteButon: function () {\n            $(this.addSelectedBtnSelector).addClass('no-display');\n            $(this.deleteSelectedBtnSelector).addClass('no-display');\n        },\n\n        /**\n         * @param {jQuery.event} e\n         * @param {Object} data\n         */\n        reloadMediaGrid: function (e, data) {\n            if (data.reload) {\n                this.reloadGrid();\n            }\n\n            if (data.message && data.code) {\n                this.addMessage(data.code, data.message);\n            }\n            this.hideAddSelectedAndDeleteButon();\n        },\n\n        /**\n         * Reload grid\n         */\n        reloadGrid: function () {\n            var provider = this.provider(),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n            provider.reload();\n        },\n\n        /**\n         * Add message\n         *\n         * @param {String} code\n         * @param {String} message\n         */\n        addMessage: function (code, message) {\n            this.messages().add(code, message);\n            this.closeContextMenu();\n            this.scrollToMessageContent();\n            this.messages().scheduleCleanup();\n        },\n\n        /**\n         * Listener to select directory event\n         *\n         * @param {String} path\n         */\n        selectDirectoryHandle: function (path) {\n            if (this.selected() &&\n                this.selected().directory !== path  &&\n                !this.massaction().massActionMode()) {\n                this.deselectImage();\n            }\n        },\n\n        /**\n         * Action to close the context menu in media gallery.\n         */\n        closeContextMenu: function () {\n            $(this.gridSelector).trigger('click');\n        },\n\n        /**\n         * Scroll to the top of media gallery page\n         */\n        scrollToMessageContent: function () {\n            var scrollTargetElement = $(this.messageContentSelector),\n                scrollTargetContainer = $(this.mediaGalleryContainerSelector);\n\n            scrollTargetContainer.find(scrollTargetElement).get(0).scrollIntoView({\n                behavior: 'smooth',\n                block: 'center',\n                inline: 'nearest'\n            });\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction',\n    'mage/translate',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, _, Component, deleteImageWithDetailConfirmation, image, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/grid/columns/image/actions',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            mediaGalleryEditDetailsName: 'mediaGalleryEditDetails',\n            allowedActions: [],\n            actionsList: [\n                {\n                    name: 'image-details',\n                    title: $t('View Details'),\n                    classes: 'action-menu-item',\n                    handler: 'viewImageDetails'\n                },\n                {\n                    name: 'edit',\n                    title: $t('Edit'),\n                    classes: 'action-menu-item',\n                    handler: 'editImageDetails'\n                },\n                {\n                    name: 'delete',\n                    title: $t('Delete'),\n                    classes: 'action-menu-item media-gallery-delete-assets',\n                    handler: 'deleteImageAction'\n                }\n            ],\n            modules: {\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }',\n                mediaGalleryEditDetails: '${ $.mediaGalleryEditDetailsName }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initEvents();\n\n            this.actionsList = this.actionsList.filter(function (item) {\n                return this.allowedActions.includes(item.name);\n            }.bind(this));\n\n            if (!this.allowedActions.includes('delete')) {\n                $.async('.media-gallery-delete-assets', function () {\n                    $('.media-gallery-delete-assets').off('click').addClass('action-disabled');\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Initialize image action events\n         */\n        initEvents: function () {\n            $(this.imageModel().addSelectedBtnSelector).on('click', function () {\n                image.insertImage(\n                    this.imageModel().getSelected(),\n                    {\n                        onInsertUrl: this.imageModel().onInsertUrl,\n                        storeId: this.imageModel().storeId\n                    }\n                );\n            }.bind(this));\n            $(this.imageModel().deleteSelectedBtnSelector).on('click', function () {\n                this.deleteImageAction(this.imageModel().selected());\n            }.bind(this));\n\n        },\n\n        /**\n         * Delete image action\n         *\n         * @param {Object} record\n         */\n        deleteImageAction: function (record) {\n            var imageDetailsUrl = this.mediaGalleryImageDetails().imageDetailsUrl,\n                deleteImageUrl = this.imageModel().deleteImageUrl;\n\n            deleteImageWithDetailConfirmation.deleteImageAction([record.id], imageDetailsUrl, deleteImageUrl);\n        },\n\n        /**\n         * View image details\n         *\n         * @param {Object} record\n         */\n        viewImageDetails: function (record) {\n            var recordId = this.imageModel().getId(record);\n\n            this.mediaGalleryImageDetails().showImageDetailsById(recordId);\n        },\n\n        /**\n         * Edit image details\n         *\n         * @param {Object} record\n         */\n        editImageDetails: function (record) {\n            var recordId = this.imageModel().getId(record);\n\n            this.mediaGalleryEditDetails().showEditDetailsPanel(recordId);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY, tinyMceEditors */\ndefine([\n    'jquery',\n    'wysiwygAdapter',\n    'underscore',\n    'mage/translate'\n], function ($, wysiwyg, _, $t) {\n    'use strict';\n\n    return {\n\n        /**\n         * Insert provided image in wysiwyg if enabled, or widget\n         *\n         * @param {Object} record\n         * @param {Object} config\n         * @returns {Boolean}\n         */\n        insertImage: function (record, config) {\n            var targetElement, forceStaticPath;\n\n            if (record === null) {\n                return false;\n            }\n            targetElement = this.getTargetElement(window.MediabrowserUtility.targetElementId);\n\n            if (!targetElement.length) {\n                window.MediabrowserUtility.closeDialog();\n                throw $t('Target element not found for content update');\n            }\n\n            forceStaticPath = typeof targetElement !== 'function' && targetElement.data('force_static_path') ? 1 : 0;\n\n            $.ajax({\n                url: config.onInsertUrl,\n                data: {\n                    filename: record['encoded_id'],\n                    'store_id': config.storeId,\n                    'as_is': typeof targetElement !== 'function' && targetElement.is('textarea') ? 1 : 0,\n                    'force_static_path': forceStaticPath,\n                    'form_key': FORM_KEY\n                },\n                context: this,\n                showLoader: true\n            }).done($.proxy(function (data) {\n                if (typeof targetElement === 'function') {\n                    targetElement(data.content, {text: record['title']});\n                } else if (targetElement.is('textarea')) {\n                    this.insertAtCursor(targetElement.get(0), data.content);\n                    targetElement.focus();\n                    $(targetElement).trigger('change');\n                } else {\n                    targetElement.val(data.content)\n                        .data('size', data.size)\n                        .data('mime-type', data.type)\n                        .trigger('change');\n                }\n            }, this));\n            window.MediabrowserUtility.closeDialog();\n\n            if (typeof targetElement !== 'function') {\n                targetElement.focus();\n                $(targetElement).trigger('change');\n            }\n        },\n\n        /**\n         * Insert image to target instance.\n         *\n         * @param {Object} element\n         * @param {*} value\n         */\n        insertAtCursor: function (element, value) {\n            var sel, startPos, endPos, scrollTop;\n\n            if ('selection' in document) {\n                //For browsers like Internet Explorer\n                element.focus();\n                sel = document.selection.createRange();\n                sel.text = value;\n                element.focus();\n            } else if (element.selectionStart || element.selectionStart == '0') { //eslint-disable-line eqeqeq\n                //For browsers like Firefox and Webkit based\n                startPos = element.selectionStart;\n                endPos = element.selectionEnd;\n                scrollTop = element.scrollTop;\n                element.value = element.value.substring(0, startPos) + value +\n                    element.value.substring(startPos, endPos) + element.value.substring(endPos, element.value.length);\n                element.focus();\n                element.selectionStart = startPos + value.length;\n                element.selectionEnd = startPos + value.length + element.value.substring(startPos, endPos).length;\n                element.scrollTop = scrollTop;\n            } else {\n                element.value += value;\n                element.focus();\n            }\n        },\n\n        /**\n         * Return opener Window object if it exists, not closed and editor is active\n         *\n         * @param {String} targetElementId\n         * return {Object|null}\n         */\n        getMediaBrowserOpener: function (targetElementId) {\n            if (!_.isUndefined(wysiwyg) && wysiwyg.get(targetElementId) && !_.isUndefined(tinyMceEditors)) {\n                return tinyMceEditors.get(targetElementId).getMediaBrowserOpener();\n            }\n\n            return null;\n        },\n\n        /**\n         * Get target element\n         *\n         * @param {String} targetElementId\n         * @returns {*|n.fn.init|jQuery|HTMLElement}\n         */\n        getTargetElement: function (targetElementId) {\n\n            if (!_.isUndefined(wysiwyg) && wysiwyg.get(targetElementId)) {\n                return this.getMediaBrowserOpener(targetElementId) || window;\n            }\n\n            return $('#' + targetElementId);\n        }\n    };\n});\n","chartjs/Chart.min.js":"/*!\n * Chart.js v4.4.0\n * https://www.chartjs.org\n * (c) 2023 Chart.js Contributors\n * Released under the MIT License\n */\n!function(t,e){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=e():\"function\"==typeof define&&define.amd?define(e):(t=\"undefined\"!=typeof globalThis?globalThis:t||self).Chart=e()}(this,(function(){\"use strict\";var t=Object.freeze({__proto__:null,get Colors(){return Go},get Decimation(){return Qo},get Filler(){return ma},get Legend(){return ya},get SubTitle(){return ka},get Title(){return Ma},get Tooltip(){return Ba}});function e(){}const i=(()=>{let t=0;return()=>t++})();function s(t){return null==t}function n(t){if(Array.isArray&&Array.isArray(t))return!0;const e=Object.prototype.toString.call(t);return\"[object\"===e.slice(0,7)&&\"Array]\"===e.slice(-6)}function o(t){return null!==t&&\"[object Object]\"===Object.prototype.toString.call(t)}function a(t){return(\"number\"==typeof t||t instanceof Number)&&isFinite(+t)}function r(t,e){return a(t)?t:e}function l(t,e){return void 0===t?e:t}const h=(t,e)=>\"string\"==typeof t&&t.endsWith(\"%\")?parseFloat(t)/100:+t/e,c=(t,e)=>\"string\"==typeof t&&t.endsWith(\"%\")?parseFloat(t)/100*e:+t;function d(t,e,i){if(t&&\"function\"==typeof t.call)return t.apply(i,e)}function u(t,e,i,s){let a,r,l;if(n(t))if(r=t.length,s)for(a=r-1;a>=0;a--)e.call(i,t[a],a);else for(a=0;a<r;a++)e.call(i,t[a],a);else if(o(t))for(l=Object.keys(t),r=l.length,a=0;a<r;a++)e.call(i,t[l[a]],l[a])}function f(t,e){let i,s,n,o;if(!t||!e||t.length!==e.length)return!1;for(i=0,s=t.length;i<s;++i)if(n=t[i],o=e[i],n.datasetIndex!==o.datasetIndex||n.index!==o.index)return!1;return!0}function g(t){if(n(t))return t.map(g);if(o(t)){const e=Object.create(null),i=Object.keys(t),s=i.length;let n=0;for(;n<s;++n)e[i[n]]=g(t[i[n]]);return e}return t}function p(t){return-1===[\"__proto__\",\"prototype\",\"constructor\"].indexOf(t)}function m(t,e,i,s){if(!p(t))return;const n=e[t],a=i[t];o(n)&&o(a)?b(n,a,s):e[t]=g(a)}function b(t,e,i){const s=n(e)?e:[e],a=s.length;if(!o(t))return t;const r=(i=i||{}).merger||m;let l;for(let e=0;e<a;++e){if(l=s[e],!o(l))continue;const n=Object.keys(l);for(let e=0,s=n.length;e<s;++e)r(n[e],t,l,i)}return t}function x(t,e){return b(t,e,{merger:_})}function _(t,e,i){if(!p(t))return;const s=e[t],n=i[t];o(s)&&o(n)?x(s,n):Object.prototype.hasOwnProperty.call(e,t)||(e[t]=g(n))}const y={\"\":t=>t,x:t=>t.x,y:t=>t.y};function v(t){const e=t.split(\".\"),i=[];let s=\"\";for(const t of e)s+=t,s.endsWith(\"\\\\\")?s=s.slice(0,-1)+\".\":(i.push(s),s=\"\");return i}function M(t,e){const i=y[e]||(y[e]=function(t){const e=v(t);return t=>{for(const i of e){if(\"\"===i)break;t=t&&t[i]}return t}}(e));return i(t)}function w(t){return t.charAt(0).toUpperCase()+t.slice(1)}const k=t=>void 0!==t,S=t=>\"function\"==typeof t,P=(t,e)=>{if(t.size!==e.size)return!1;for(const i of t)if(!e.has(i))return!1;return!0};function D(t){return\"mouseup\"===t.type||\"click\"===t.type||\"contextmenu\"===t.type}const C=Math.PI,O=2*C,A=O+C,T=Number.POSITIVE_INFINITY,L=C/180,E=C/2,R=C/4,I=2*C/3,z=Math.log10,F=Math.sign;function V(t,e,i){return Math.abs(t-e)<i}function B(t){const e=Math.round(t);t=V(t,e,t/1e3)?e:t;const i=Math.pow(10,Math.floor(z(t))),s=t/i;return(s<=1?1:s<=2?2:s<=5?5:10)*i}function W(t){const e=[],i=Math.sqrt(t);let s;for(s=1;s<i;s++)t%s==0&&(e.push(s),e.push(t/s));return i===(0|i)&&e.push(i),e.sort(((t,e)=>t-e)).pop(),e}function N(t){return!isNaN(parseFloat(t))&&isFinite(t)}function H(t,e){const i=Math.round(t);return i-e<=t&&i+e>=t}function j(t,e,i){let s,n,o;for(s=0,n=t.length;s<n;s++)o=t[s][i],isNaN(o)||(e.min=Math.min(e.min,o),e.max=Math.max(e.max,o))}function $(t){return t*(C/180)}function Y(t){return t*(180/C)}function U(t){if(!a(t))return;let e=1,i=0;for(;Math.round(t*e)/e!==t;)e*=10,i++;return i}function X(t,e){const i=e.x-t.x,s=e.y-t.y,n=Math.sqrt(i*i+s*s);let o=Math.atan2(s,i);return o<-.5*C&&(o+=O),{angle:o,distance:n}}function q(t,e){return Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))}function K(t,e){return(t-e+A)%O-C}function G(t){return(t%O+O)%O}function Z(t,e,i,s){const n=G(t),o=G(e),a=G(i),r=G(o-n),l=G(a-n),h=G(n-o),c=G(n-a);return n===o||n===a||s&&o===a||r>l&&h<c}function J(t,e,i){return Math.max(e,Math.min(i,t))}function Q(t){return J(t,-32768,32767)}function tt(t,e,i,s=1e-6){return t>=Math.min(e,i)-s&&t<=Math.max(e,i)+s}function et(t,e,i){i=i||(i=>t[i]<e);let s,n=t.length-1,o=0;for(;n-o>1;)s=o+n>>1,i(s)?o=s:n=s;return{lo:o,hi:n}}const it=(t,e,i,s)=>et(t,i,s?s=>{const n=t[s][e];return n<i||n===i&&t[s+1][e]===i}:s=>t[s][e]<i),st=(t,e,i)=>et(t,i,(s=>t[s][e]>=i));function nt(t,e,i){let s=0,n=t.length;for(;s<n&&t[s]<e;)s++;for(;n>s&&t[n-1]>i;)n--;return s>0||n<t.length?t.slice(s,n):t}const ot=[\"push\",\"pop\",\"shift\",\"splice\",\"unshift\"];function at(t,e){t._chartjs?t._chartjs.listeners.push(e):(Object.defineProperty(t,\"_chartjs\",{configurable:!0,enumerable:!1,value:{listeners:[e]}}),ot.forEach((e=>{const i=\"_onData\"+w(e),s=t[e];Object.defineProperty(t,e,{configurable:!0,enumerable:!1,value(...e){const n=s.apply(this,e);return t._chartjs.listeners.forEach((t=>{\"function\"==typeof t[i]&&t[i](...e)})),n}})})))}function rt(t,e){const i=t._chartjs;if(!i)return;const s=i.listeners,n=s.indexOf(e);-1!==n&&s.splice(n,1),s.length>0||(ot.forEach((e=>{delete t[e]})),delete t._chartjs)}function lt(t){const e=new Set(t);return e.size===t.length?t:Array.from(e)}const ht=\"undefined\"==typeof window?function(t){return t()}:window.requestAnimationFrame;function ct(t,e){let i=[],s=!1;return function(...n){i=n,s||(s=!0,ht.call(window,(()=>{s=!1,t.apply(e,i)})))}}function dt(t,e){let i;return function(...s){return e?(clearTimeout(i),i=setTimeout(t,e,s)):t.apply(this,s),e}}const ut=t=>\"start\"===t?\"left\":\"end\"===t?\"right\":\"center\",ft=(t,e,i)=>\"start\"===t?e:\"end\"===t?i:(e+i)/2,gt=(t,e,i,s)=>t===(s?\"left\":\"right\")?i:\"center\"===t?(e+i)/2:e;function pt(t,e,i){const s=e.length;let n=0,o=s;if(t._sorted){const{iScale:a,_parsed:r}=t,l=a.axis,{min:h,max:c,minDefined:d,maxDefined:u}=a.getUserBounds();d&&(n=J(Math.min(it(r,l,h).lo,i?s:it(e,l,a.getPixelForValue(h)).lo),0,s-1)),o=u?J(Math.max(it(r,a.axis,c,!0).hi+1,i?0:it(e,l,a.getPixelForValue(c),!0).hi+1),n,s)-n:s-n}return{start:n,count:o}}function mt(t){const{xScale:e,yScale:i,_scaleRanges:s}=t,n={xmin:e.min,xmax:e.max,ymin:i.min,ymax:i.max};if(!s)return t._scaleRanges=n,!0;const o=s.xmin!==e.min||s.xmax!==e.max||s.ymin!==i.min||s.ymax!==i.max;return Object.assign(s,n),o}class bt{constructor(){this._request=null,this._charts=new Map,this._running=!1,this._lastDate=void 0}_notify(t,e,i,s){const n=e.listeners[s],o=e.duration;n.forEach((s=>s({chart:t,initial:e.initial,numSteps:o,currentStep:Math.min(i-e.start,o)})))}_refresh(){this._request||(this._running=!0,this._request=ht.call(window,(()=>{this._update(),this._request=null,this._running&&this._refresh()})))}_update(t=Date.now()){let e=0;this._charts.forEach(((i,s)=>{if(!i.running||!i.items.length)return;const n=i.items;let o,a=n.length-1,r=!1;for(;a>=0;--a)o=n[a],o._active?(o._total>i.duration&&(i.duration=o._total),o.tick(t),r=!0):(n[a]=n[n.length-1],n.pop());r&&(s.draw(),this._notify(s,i,t,\"progress\")),n.length||(i.running=!1,this._notify(s,i,t,\"complete\"),i.initial=!1),e+=n.length})),this._lastDate=t,0===e&&(this._running=!1)}_getAnims(t){const e=this._charts;let i=e.get(t);return i||(i={running:!1,initial:!0,items:[],listeners:{complete:[],progress:[]}},e.set(t,i)),i}listen(t,e,i){this._getAnims(t).listeners[e].push(i)}add(t,e){e&&e.length&&this._getAnims(t).items.push(...e)}has(t){return this._getAnims(t).items.length>0}start(t){const e=this._charts.get(t);e&&(e.running=!0,e.start=Date.now(),e.duration=e.items.reduce(((t,e)=>Math.max(t,e._duration)),0),this._refresh())}running(t){if(!this._running)return!1;const e=this._charts.get(t);return!!(e&&e.running&&e.items.length)}stop(t){const e=this._charts.get(t);if(!e||!e.items.length)return;const i=e.items;let s=i.length-1;for(;s>=0;--s)i[s].cancel();e.items=[],this._notify(t,e,Date.now(),\"complete\")}remove(t){return this._charts.delete(t)}}var xt=new bt;\n    /*!\n     * @kurkle/color v0.3.2\n     * https://github.com/kurkle/color#readme\n     * (c) 2023 Jukka Kurkela\n     * Released under the MIT License\n     */function _t(t){return t+.5|0}const yt=(t,e,i)=>Math.max(Math.min(t,i),e);function vt(t){return yt(_t(2.55*t),0,255)}function Mt(t){return yt(_t(255*t),0,255)}function wt(t){return yt(_t(t/2.55)/100,0,1)}function kt(t){return yt(_t(100*t),0,100)}const St={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,A:10,B:11,C:12,D:13,E:14,F:15,a:10,b:11,c:12,d:13,e:14,f:15},Pt=[...\"0123456789ABCDEF\"],Dt=t=>Pt[15&t],Ct=t=>Pt[(240&t)>>4]+Pt[15&t],Ot=t=>(240&t)>>4==(15&t);function At(t){var e=(t=>Ot(t.r)&&Ot(t.g)&&Ot(t.b)&&Ot(t.a))(t)?Dt:Ct;return t?\"#\"+e(t.r)+e(t.g)+e(t.b)+((t,e)=>t<255?e(t):\"\")(t.a,e):void 0}const Tt=/^(hsla?|hwb|hsv)\\(\\s*([-+.e\\d]+)(?:deg)?[\\s,]+([-+.e\\d]+)%[\\s,]+([-+.e\\d]+)%(?:[\\s,]+([-+.e\\d]+)(%)?)?\\s*\\)$/;function Lt(t,e,i){const s=e*Math.min(i,1-i),n=(e,n=(e+t/30)%12)=>i-s*Math.max(Math.min(n-3,9-n,1),-1);return[n(0),n(8),n(4)]}function Et(t,e,i){const s=(s,n=(s+t/60)%6)=>i-i*e*Math.max(Math.min(n,4-n,1),0);return[s(5),s(3),s(1)]}function Rt(t,e,i){const s=Lt(t,1,.5);let n;for(e+i>1&&(n=1/(e+i),e*=n,i*=n),n=0;n<3;n++)s[n]*=1-e-i,s[n]+=e;return s}function It(t){const e=t.r/255,i=t.g/255,s=t.b/255,n=Math.max(e,i,s),o=Math.min(e,i,s),a=(n+o)/2;let r,l,h;return n!==o&&(h=n-o,l=a>.5?h/(2-n-o):h/(n+o),r=function(t,e,i,s,n){return t===n?(e-i)/s+(e<i?6:0):e===n?(i-t)/s+2:(t-e)/s+4}(e,i,s,h,n),r=60*r+.5),[0|r,l||0,a]}function zt(t,e,i,s){return(Array.isArray(e)?t(e[0],e[1],e[2]):t(e,i,s)).map(Mt)}function Ft(t,e,i){return zt(Lt,t,e,i)}function Vt(t){return(t%360+360)%360}function Bt(t){const e=Tt.exec(t);let i,s=255;if(!e)return;e[5]!==i&&(s=e[6]?vt(+e[5]):Mt(+e[5]));const n=Vt(+e[2]),o=+e[3]/100,a=+e[4]/100;return i=\"hwb\"===e[1]?function(t,e,i){return zt(Rt,t,e,i)}(n,o,a):\"hsv\"===e[1]?function(t,e,i){return zt(Et,t,e,i)}(n,o,a):Ft(n,o,a),{r:i[0],g:i[1],b:i[2],a:s}}const Wt={x:\"dark\",Z:\"light\",Y:\"re\",X:\"blu\",W:\"gr\",V:\"medium\",U:\"slate\",A:\"ee\",T:\"ol\",S:\"or\",B:\"ra\",C:\"lateg\",D:\"ights\",R:\"in\",Q:\"turquois\",E:\"hi\",P:\"ro\",O:\"al\",N:\"le\",M:\"de\",L:\"yello\",F:\"en\",K:\"ch\",G:\"arks\",H:\"ea\",I:\"ightg\",J:\"wh\"},Nt={OiceXe:\"f0f8ff\",antiquewEte:\"faebd7\",aqua:\"ffff\",aquamarRe:\"7fffd4\",azuY:\"f0ffff\",beige:\"f5f5dc\",bisque:\"ffe4c4\",black:\"0\",blanKedOmond:\"ffebcd\",Xe:\"ff\",XeviTet:\"8a2be2\",bPwn:\"a52a2a\",burlywood:\"deb887\",caMtXe:\"5f9ea0\",KartYuse:\"7fff00\",KocTate:\"d2691e\",cSO:\"ff7f50\",cSnflowerXe:\"6495ed\",cSnsilk:\"fff8dc\",crimson:\"dc143c\",cyan:\"ffff\",xXe:\"8b\",xcyan:\"8b8b\",xgTMnPd:\"b8860b\",xWay:\"a9a9a9\",xgYF:\"6400\",xgYy:\"a9a9a9\",xkhaki:\"bdb76b\",xmagFta:\"8b008b\",xTivegYF:\"556b2f\",xSange:\"ff8c00\",xScEd:\"9932cc\",xYd:\"8b0000\",xsOmon:\"e9967a\",xsHgYF:\"8fbc8f\",xUXe:\"483d8b\",xUWay:\"2f4f4f\",xUgYy:\"2f4f4f\",xQe:\"ced1\",xviTet:\"9400d3\",dAppRk:\"ff1493\",dApskyXe:\"bfff\",dimWay:\"696969\",dimgYy:\"696969\",dodgerXe:\"1e90ff\",fiYbrick:\"b22222\",flSOwEte:\"fffaf0\",foYstWAn:\"228b22\",fuKsia:\"ff00ff\",gaRsbSo:\"dcdcdc\",ghostwEte:\"f8f8ff\",gTd:\"ffd700\",gTMnPd:\"daa520\",Way:\"808080\",gYF:\"8000\",gYFLw:\"adff2f\",gYy:\"808080\",honeyMw:\"f0fff0\",hotpRk:\"ff69b4\",RdianYd:\"cd5c5c\",Rdigo:\"4b0082\",ivSy:\"fffff0\",khaki:\"f0e68c\",lavFMr:\"e6e6fa\",lavFMrXsh:\"fff0f5\",lawngYF:\"7cfc00\",NmoncEffon:\"fffacd\",ZXe:\"add8e6\",ZcSO:\"f08080\",Zcyan:\"e0ffff\",ZgTMnPdLw:\"fafad2\",ZWay:\"d3d3d3\",ZgYF:\"90ee90\",ZgYy:\"d3d3d3\",ZpRk:\"ffb6c1\",ZsOmon:\"ffa07a\",ZsHgYF:\"20b2aa\",ZskyXe:\"87cefa\",ZUWay:\"778899\",ZUgYy:\"778899\",ZstAlXe:\"b0c4de\",ZLw:\"ffffe0\",lime:\"ff00\",limegYF:\"32cd32\",lRF:\"faf0e6\",magFta:\"ff00ff\",maPon:\"800000\",VaquamarRe:\"66cdaa\",VXe:\"cd\",VScEd:\"ba55d3\",VpurpN:\"9370db\",VsHgYF:\"3cb371\",VUXe:\"7b68ee\",VsprRggYF:\"fa9a\",VQe:\"48d1cc\",VviTetYd:\"c71585\",midnightXe:\"191970\",mRtcYam:\"f5fffa\",mistyPse:\"ffe4e1\",moccasR:\"ffe4b5\",navajowEte:\"ffdead\",navy:\"80\",Tdlace:\"fdf5e6\",Tive:\"808000\",TivedBb:\"6b8e23\",Sange:\"ffa500\",SangeYd:\"ff4500\",ScEd:\"da70d6\",pOegTMnPd:\"eee8aa\",pOegYF:\"98fb98\",pOeQe:\"afeeee\",pOeviTetYd:\"db7093\",papayawEp:\"ffefd5\",pHKpuff:\"ffdab9\",peru:\"cd853f\",pRk:\"ffc0cb\",plum:\"dda0dd\",powMrXe:\"b0e0e6\",purpN:\"800080\",YbeccapurpN:\"663399\",Yd:\"ff0000\",Psybrown:\"bc8f8f\",PyOXe:\"4169e1\",saddNbPwn:\"8b4513\",sOmon:\"fa8072\",sandybPwn:\"f4a460\",sHgYF:\"2e8b57\",sHshell:\"fff5ee\",siFna:\"a0522d\",silver:\"c0c0c0\",skyXe:\"87ceeb\",UXe:\"6a5acd\",UWay:\"708090\",UgYy:\"708090\",snow:\"fffafa\",sprRggYF:\"ff7f\",stAlXe:\"4682b4\",tan:\"d2b48c\",teO:\"8080\",tEstN:\"d8bfd8\",tomato:\"ff6347\",Qe:\"40e0d0\",viTet:\"ee82ee\",JHt:\"f5deb3\",wEte:\"ffffff\",wEtesmoke:\"f5f5f5\",Lw:\"ffff00\",LwgYF:\"9acd32\"};let Ht;function jt(t){Ht||(Ht=function(){const t={},e=Object.keys(Nt),i=Object.keys(Wt);let s,n,o,a,r;for(s=0;s<e.length;s++){for(a=r=e[s],n=0;n<i.length;n++)o=i[n],r=r.replace(o,Wt[o]);o=parseInt(Nt[a],16),t[r]=[o>>16&255,o>>8&255,255&o]}return t}(),Ht.transparent=[0,0,0,0]);const e=Ht[t.toLowerCase()];return e&&{r:e[0],g:e[1],b:e[2],a:4===e.length?e[3]:255}}const $t=/^rgba?\\(\\s*([-+.\\d]+)(%)?[\\s,]+([-+.e\\d]+)(%)?[\\s,]+([-+.e\\d]+)(%)?(?:[\\s,/]+([-+.e\\d]+)(%)?)?\\s*\\)$/;const Yt=t=>t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055,Ut=t=>t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4);function Xt(t,e,i){if(t){let s=It(t);s[e]=Math.max(0,Math.min(s[e]+s[e]*i,0===e?360:1)),s=Ft(s),t.r=s[0],t.g=s[1],t.b=s[2]}}function qt(t,e){return t?Object.assign(e||{},t):t}function Kt(t){var e={r:0,g:0,b:0,a:255};return Array.isArray(t)?t.length>=3&&(e={r:t[0],g:t[1],b:t[2],a:255},t.length>3&&(e.a=Mt(t[3]))):(e=qt(t,{r:0,g:0,b:0,a:1})).a=Mt(e.a),e}function Gt(t){return\"r\"===t.charAt(0)?function(t){const e=$t.exec(t);let i,s,n,o=255;if(e){if(e[7]!==i){const t=+e[7];o=e[8]?vt(t):yt(255*t,0,255)}return i=+e[1],s=+e[3],n=+e[5],i=255&(e[2]?vt(i):yt(i,0,255)),s=255&(e[4]?vt(s):yt(s,0,255)),n=255&(e[6]?vt(n):yt(n,0,255)),{r:i,g:s,b:n,a:o}}}(t):Bt(t)}class Zt{constructor(t){if(t instanceof Zt)return t;const e=typeof t;let i;var s,n,o;\"object\"===e?i=Kt(t):\"string\"===e&&(o=(s=t).length,\"#\"===s[0]&&(4===o||5===o?n={r:255&17*St[s[1]],g:255&17*St[s[2]],b:255&17*St[s[3]],a:5===o?17*St[s[4]]:255}:7!==o&&9!==o||(n={r:St[s[1]]<<4|St[s[2]],g:St[s[3]]<<4|St[s[4]],b:St[s[5]]<<4|St[s[6]],a:9===o?St[s[7]]<<4|St[s[8]]:255})),i=n||jt(t)||Gt(t)),this._rgb=i,this._valid=!!i}get valid(){return this._valid}get rgb(){var t=qt(this._rgb);return t&&(t.a=wt(t.a)),t}set rgb(t){this._rgb=Kt(t)}rgbString(){return this._valid?(t=this._rgb)&&(t.a<255?`rgba(${t.r}, ${t.g}, ${t.b}, ${wt(t.a)})`:`rgb(${t.r}, ${t.g}, ${t.b})`):void 0;var t}hexString(){return this._valid?At(this._rgb):void 0}hslString(){return this._valid?function(t){if(!t)return;const e=It(t),i=e[0],s=kt(e[1]),n=kt(e[2]);return t.a<255?`hsla(${i}, ${s}%, ${n}%, ${wt(t.a)})`:`hsl(${i}, ${s}%, ${n}%)`}(this._rgb):void 0}mix(t,e){if(t){const i=this.rgb,s=t.rgb;let n;const o=e===n?.5:e,a=2*o-1,r=i.a-s.a,l=((a*r==-1?a:(a+r)/(1+a*r))+1)/2;n=1-l,i.r=255&l*i.r+n*s.r+.5,i.g=255&l*i.g+n*s.g+.5,i.b=255&l*i.b+n*s.b+.5,i.a=o*i.a+(1-o)*s.a,this.rgb=i}return this}interpolate(t,e){return t&&(this._rgb=function(t,e,i){const s=Ut(wt(t.r)),n=Ut(wt(t.g)),o=Ut(wt(t.b));return{r:Mt(Yt(s+i*(Ut(wt(e.r))-s))),g:Mt(Yt(n+i*(Ut(wt(e.g))-n))),b:Mt(Yt(o+i*(Ut(wt(e.b))-o))),a:t.a+i*(e.a-t.a)}}(this._rgb,t._rgb,e)),this}clone(){return new Zt(this.rgb)}alpha(t){return this._rgb.a=Mt(t),this}clearer(t){return this._rgb.a*=1-t,this}greyscale(){const t=this._rgb,e=_t(.3*t.r+.59*t.g+.11*t.b);return t.r=t.g=t.b=e,this}opaquer(t){return this._rgb.a*=1+t,this}negate(){const t=this._rgb;return t.r=255-t.r,t.g=255-t.g,t.b=255-t.b,this}lighten(t){return Xt(this._rgb,2,t),this}darken(t){return Xt(this._rgb,2,-t),this}saturate(t){return Xt(this._rgb,1,t),this}desaturate(t){return Xt(this._rgb,1,-t),this}rotate(t){return function(t,e){var i=It(t);i[0]=Vt(i[0]+e),i=Ft(i),t.r=i[0],t.g=i[1],t.b=i[2]}(this._rgb,t),this}}function Jt(t){if(t&&\"object\"==typeof t){const e=t.toString();return\"[object CanvasPattern]\"===e||\"[object CanvasGradient]\"===e}return!1}function Qt(t){return Jt(t)?t:new Zt(t)}function te(t){return Jt(t)?t:new Zt(t).saturate(.5).darken(.1).hexString()}const ee=[\"x\",\"y\",\"borderWidth\",\"radius\",\"tension\"],ie=[\"color\",\"borderColor\",\"backgroundColor\"];const se=new Map;function ne(t,e,i){return function(t,e){e=e||{};const i=t+JSON.stringify(e);let s=se.get(i);return s||(s=new Intl.NumberFormat(t,e),se.set(i,s)),s}(e,i).format(t)}const oe={values:t=>n(t)?t:\"\"+t,numeric(t,e,i){if(0===t)return\"0\";const s=this.chart.options.locale;let n,o=t;if(i.length>1){const e=Math.max(Math.abs(i[0].value),Math.abs(i[i.length-1].value));(e<1e-4||e>1e15)&&(n=\"scientific\"),o=function(t,e){let i=e.length>3?e[2].value-e[1].value:e[1].value-e[0].value;Math.abs(i)>=1&&t!==Math.floor(t)&&(i=t-Math.floor(t));return i}(t,i)}const a=z(Math.abs(o)),r=isNaN(a)?1:Math.max(Math.min(-1*Math.floor(a),20),0),l={notation:n,minimumFractionDigits:r,maximumFractionDigits:r};return Object.assign(l,this.options.ticks.format),ne(t,s,l)},logarithmic(t,e,i){if(0===t)return\"0\";const s=i[e].significand||t/Math.pow(10,Math.floor(z(t)));return[1,2,3,5,10,15].includes(s)||e>.8*i.length?oe.numeric.call(this,t,e,i):\"\"}};var ae={formatters:oe};const re=Object.create(null),le=Object.create(null);function he(t,e){if(!e)return t;const i=e.split(\".\");for(let e=0,s=i.length;e<s;++e){const s=i[e];t=t[s]||(t[s]=Object.create(null))}return t}function ce(t,e,i){return\"string\"==typeof e?b(he(t,e),i):b(he(t,\"\"),e)}class de{constructor(t,e){this.animation=void 0,this.backgroundColor=\"rgba(0,0,0,0.1)\",this.borderColor=\"rgba(0,0,0,0.1)\",this.color=\"#666\",this.datasets={},this.devicePixelRatio=t=>t.chart.platform.getDevicePixelRatio(),this.elements={},this.events=[\"mousemove\",\"mouseout\",\"click\",\"touchstart\",\"touchmove\"],this.font={family:\"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif\",size:12,style:\"normal\",lineHeight:1.2,weight:null},this.hover={},this.hoverBackgroundColor=(t,e)=>te(e.backgroundColor),this.hoverBorderColor=(t,e)=>te(e.borderColor),this.hoverColor=(t,e)=>te(e.color),this.indexAxis=\"x\",this.interaction={mode:\"nearest\",intersect:!0,includeInvisible:!1},this.maintainAspectRatio=!0,this.onHover=null,this.onClick=null,this.parsing=!0,this.plugins={},this.responsive=!0,this.scale=void 0,this.scales={},this.showLine=!0,this.drawActiveElementsOnTop=!0,this.describe(t),this.apply(e)}set(t,e){return ce(this,t,e)}get(t){return he(this,t)}describe(t,e){return ce(le,t,e)}override(t,e){return ce(re,t,e)}route(t,e,i,s){const n=he(this,t),a=he(this,i),r=\"_\"+e;Object.defineProperties(n,{[r]:{value:n[e],writable:!0},[e]:{enumerable:!0,get(){const t=this[r],e=a[s];return o(t)?Object.assign({},e,t):l(t,e)},set(t){this[r]=t}}})}apply(t){t.forEach((t=>t(this)))}}var ue=new de({_scriptable:t=>!t.startsWith(\"on\"),_indexable:t=>\"events\"!==t,hover:{_fallback:\"interaction\"},interaction:{_scriptable:!1,_indexable:!1}},[function(t){t.set(\"animation\",{delay:void 0,duration:1e3,easing:\"easeOutQuart\",fn:void 0,from:void 0,loop:void 0,to:void 0,type:void 0}),t.describe(\"animation\",{_fallback:!1,_indexable:!1,_scriptable:t=>\"onProgress\"!==t&&\"onComplete\"!==t&&\"fn\"!==t}),t.set(\"animations\",{colors:{type:\"color\",properties:ie},numbers:{type:\"number\",properties:ee}}),t.describe(\"animations\",{_fallback:\"animation\"}),t.set(\"transitions\",{active:{animation:{duration:400}},resize:{animation:{duration:0}},show:{animations:{colors:{from:\"transparent\"},visible:{type:\"boolean\",duration:0}}},hide:{animations:{colors:{to:\"transparent\"},visible:{type:\"boolean\",easing:\"linear\",fn:t=>0|t}}}})},function(t){t.set(\"layout\",{autoPadding:!0,padding:{top:0,right:0,bottom:0,left:0}})},function(t){t.set(\"scale\",{display:!0,offset:!1,reverse:!1,beginAtZero:!1,bounds:\"ticks\",clip:!0,grace:0,grid:{display:!0,lineWidth:1,drawOnChartArea:!0,drawTicks:!0,tickLength:8,tickWidth:(t,e)=>e.lineWidth,tickColor:(t,e)=>e.color,offset:!1},border:{display:!0,dash:[],dashOffset:0,width:1},title:{display:!1,text:\"\",padding:{top:4,bottom:4}},ticks:{minRotation:0,maxRotation:50,mirror:!1,textStrokeWidth:0,textStrokeColor:\"\",padding:3,display:!0,autoSkip:!0,autoSkipPadding:3,labelOffset:0,callback:ae.formatters.values,minor:{},major:{},align:\"center\",crossAlign:\"near\",showLabelBackdrop:!1,backdropColor:\"rgba(255, 255, 255, 0.75)\",backdropPadding:2}}),t.route(\"scale.ticks\",\"color\",\"\",\"color\"),t.route(\"scale.grid\",\"color\",\"\",\"borderColor\"),t.route(\"scale.border\",\"color\",\"\",\"borderColor\"),t.route(\"scale.title\",\"color\",\"\",\"color\"),t.describe(\"scale\",{_fallback:!1,_scriptable:t=>!t.startsWith(\"before\")&&!t.startsWith(\"after\")&&\"callback\"!==t&&\"parser\"!==t,_indexable:t=>\"borderDash\"!==t&&\"tickBorderDash\"!==t&&\"dash\"!==t}),t.describe(\"scales\",{_fallback:\"scale\"}),t.describe(\"scale.ticks\",{_scriptable:t=>\"backdropPadding\"!==t&&\"callback\"!==t,_indexable:t=>\"backdropPadding\"!==t})}]);function fe(){return\"undefined\"!=typeof window&&\"undefined\"!=typeof document}function ge(t){let e=t.parentNode;return e&&\"[object ShadowRoot]\"===e.toString()&&(e=e.host),e}function pe(t,e,i){let s;return\"string\"==typeof t?(s=parseInt(t,10),-1!==t.indexOf(\"%\")&&(s=s/100*e.parentNode[i])):s=t,s}const me=t=>t.ownerDocument.defaultView.getComputedStyle(t,null);function be(t,e){return me(t).getPropertyValue(e)}const xe=[\"top\",\"right\",\"bottom\",\"left\"];function _e(t,e,i){const s={};i=i?\"-\"+i:\"\";for(let n=0;n<4;n++){const o=xe[n];s[o]=parseFloat(t[e+\"-\"+o+i])||0}return s.width=s.left+s.right,s.height=s.top+s.bottom,s}const ye=(t,e,i)=>(t>0||e>0)&&(!i||!i.shadowRoot);function ve(t,e){if(\"native\"in t)return t;const{canvas:i,currentDevicePixelRatio:s}=e,n=me(i),o=\"border-box\"===n.boxSizing,a=_e(n,\"padding\"),r=_e(n,\"border\",\"width\"),{x:l,y:h,box:c}=function(t,e){const i=t.touches,s=i&&i.length?i[0]:t,{offsetX:n,offsetY:o}=s;let a,r,l=!1;if(ye(n,o,t.target))a=n,r=o;else{const t=e.getBoundingClientRect();a=s.clientX-t.left,r=s.clientY-t.top,l=!0}return{x:a,y:r,box:l}}(t,i),d=a.left+(c&&r.left),u=a.top+(c&&r.top);let{width:f,height:g}=e;return o&&(f-=a.width+r.width,g-=a.height+r.height),{x:Math.round((l-d)/f*i.width/s),y:Math.round((h-u)/g*i.height/s)}}const Me=t=>Math.round(10*t)/10;function we(t,e,i,s){const n=me(t),o=_e(n,\"margin\"),a=pe(n.maxWidth,t,\"clientWidth\")||T,r=pe(n.maxHeight,t,\"clientHeight\")||T,l=function(t,e,i){let s,n;if(void 0===e||void 0===i){const o=ge(t);if(o){const t=o.getBoundingClientRect(),a=me(o),r=_e(a,\"border\",\"width\"),l=_e(a,\"padding\");e=t.width-l.width-r.width,i=t.height-l.height-r.height,s=pe(a.maxWidth,o,\"clientWidth\"),n=pe(a.maxHeight,o,\"clientHeight\")}else e=t.clientWidth,i=t.clientHeight}return{width:e,height:i,maxWidth:s||T,maxHeight:n||T}}(t,e,i);let{width:h,height:c}=l;if(\"content-box\"===n.boxSizing){const t=_e(n,\"border\",\"width\"),e=_e(n,\"padding\");h-=e.width+t.width,c-=e.height+t.height}h=Math.max(0,h-o.width),c=Math.max(0,s?h/s:c-o.height),h=Me(Math.min(h,a,l.maxWidth)),c=Me(Math.min(c,r,l.maxHeight)),h&&!c&&(c=Me(h/2));return(void 0!==e||void 0!==i)&&s&&l.height&&c>l.height&&(c=l.height,h=Me(Math.floor(c*s))),{width:h,height:c}}function ke(t,e,i){const s=e||1,n=Math.floor(t.height*s),o=Math.floor(t.width*s);t.height=Math.floor(t.height),t.width=Math.floor(t.width);const a=t.canvas;return a.style&&(i||!a.style.height&&!a.style.width)&&(a.style.height=`${t.height}px`,a.style.width=`${t.width}px`),(t.currentDevicePixelRatio!==s||a.height!==n||a.width!==o)&&(t.currentDevicePixelRatio=s,a.height=n,a.width=o,t.ctx.setTransform(s,0,0,s,0,0),!0)}const Se=function(){let t=!1;try{const e={get passive(){return t=!0,!1}};window.addEventListener(\"test\",null,e),window.removeEventListener(\"test\",null,e)}catch(t){}return t}();function Pe(t,e){const i=be(t,e),s=i&&i.match(/^(\\d+)(\\.\\d+)?px$/);return s?+s[1]:void 0}function De(t){return!t||s(t.size)||s(t.family)?null:(t.style?t.style+\" \":\"\")+(t.weight?t.weight+\" \":\"\")+t.size+\"px \"+t.family}function Ce(t,e,i,s,n){let o=e[n];return o||(o=e[n]=t.measureText(n).width,i.push(n)),o>s&&(s=o),s}function Oe(t,e,i,s){let o=(s=s||{}).data=s.data||{},a=s.garbageCollect=s.garbageCollect||[];s.font!==e&&(o=s.data={},a=s.garbageCollect=[],s.font=e),t.save(),t.font=e;let r=0;const l=i.length;let h,c,d,u,f;for(h=0;h<l;h++)if(u=i[h],null==u||n(u)){if(n(u))for(c=0,d=u.length;c<d;c++)f=u[c],null==f||n(f)||(r=Ce(t,o,a,r,f))}else r=Ce(t,o,a,r,u);t.restore();const g=a.length/2;if(g>i.length){for(h=0;h<g;h++)delete o[a[h]];a.splice(0,g)}return r}function Ae(t,e,i){const s=t.currentDevicePixelRatio,n=0!==i?Math.max(i/2,.5):0;return Math.round((e-n)*s)/s+n}function Te(t,e){(e=e||t.getContext(\"2d\")).save(),e.resetTransform(),e.clearRect(0,0,t.width,t.height),e.restore()}function Le(t,e,i,s){Ee(t,e,i,s,null)}function Ee(t,e,i,s,n){let o,a,r,l,h,c,d,u;const f=e.pointStyle,g=e.rotation,p=e.radius;let m=(g||0)*L;if(f&&\"object\"==typeof f&&(o=f.toString(),\"[object HTMLImageElement]\"===o||\"[object HTMLCanvasElement]\"===o))return t.save(),t.translate(i,s),t.rotate(m),t.drawImage(f,-f.width/2,-f.height/2,f.width,f.height),void t.restore();if(!(isNaN(p)||p<=0)){switch(t.beginPath(),f){default:n?t.ellipse(i,s,n/2,p,0,0,O):t.arc(i,s,p,0,O),t.closePath();break;case\"triangle\":c=n?n/2:p,t.moveTo(i+Math.sin(m)*c,s-Math.cos(m)*p),m+=I,t.lineTo(i+Math.sin(m)*c,s-Math.cos(m)*p),m+=I,t.lineTo(i+Math.sin(m)*c,s-Math.cos(m)*p),t.closePath();break;case\"rectRounded\":h=.516*p,l=p-h,a=Math.cos(m+R)*l,d=Math.cos(m+R)*(n?n/2-h:l),r=Math.sin(m+R)*l,u=Math.sin(m+R)*(n?n/2-h:l),t.arc(i-d,s-r,h,m-C,m-E),t.arc(i+u,s-a,h,m-E,m),t.arc(i+d,s+r,h,m,m+E),t.arc(i-u,s+a,h,m+E,m+C),t.closePath();break;case\"rect\":if(!g){l=Math.SQRT1_2*p,c=n?n/2:l,t.rect(i-c,s-l,2*c,2*l);break}m+=R;case\"rectRot\":d=Math.cos(m)*(n?n/2:p),a=Math.cos(m)*p,r=Math.sin(m)*p,u=Math.sin(m)*(n?n/2:p),t.moveTo(i-d,s-r),t.lineTo(i+u,s-a),t.lineTo(i+d,s+r),t.lineTo(i-u,s+a),t.closePath();break;case\"crossRot\":m+=R;case\"cross\":d=Math.cos(m)*(n?n/2:p),a=Math.cos(m)*p,r=Math.sin(m)*p,u=Math.sin(m)*(n?n/2:p),t.moveTo(i-d,s-r),t.lineTo(i+d,s+r),t.moveTo(i+u,s-a),t.lineTo(i-u,s+a);break;case\"star\":d=Math.cos(m)*(n?n/2:p),a=Math.cos(m)*p,r=Math.sin(m)*p,u=Math.sin(m)*(n?n/2:p),t.moveTo(i-d,s-r),t.lineTo(i+d,s+r),t.moveTo(i+u,s-a),t.lineTo(i-u,s+a),m+=R,d=Math.cos(m)*(n?n/2:p),a=Math.cos(m)*p,r=Math.sin(m)*p,u=Math.sin(m)*(n?n/2:p),t.moveTo(i-d,s-r),t.lineTo(i+d,s+r),t.moveTo(i+u,s-a),t.lineTo(i-u,s+a);break;case\"line\":a=n?n/2:Math.cos(m)*p,r=Math.sin(m)*p,t.moveTo(i-a,s-r),t.lineTo(i+a,s+r);break;case\"dash\":t.moveTo(i,s),t.lineTo(i+Math.cos(m)*(n?n/2:p),s+Math.sin(m)*p);break;case!1:t.closePath()}t.fill(),e.borderWidth>0&&t.stroke()}}function Re(t,e,i){return i=i||.5,!e||t&&t.x>e.left-i&&t.x<e.right+i&&t.y>e.top-i&&t.y<e.bottom+i}function Ie(t,e){t.save(),t.beginPath(),t.rect(e.left,e.top,e.right-e.left,e.bottom-e.top),t.clip()}function ze(t){t.restore()}function Fe(t,e,i,s,n){if(!e)return t.lineTo(i.x,i.y);if(\"middle\"===n){const s=(e.x+i.x)/2;t.lineTo(s,e.y),t.lineTo(s,i.y)}else\"after\"===n!=!!s?t.lineTo(e.x,i.y):t.lineTo(i.x,e.y);t.lineTo(i.x,i.y)}function Ve(t,e,i,s){if(!e)return t.lineTo(i.x,i.y);t.bezierCurveTo(s?e.cp1x:e.cp2x,s?e.cp1y:e.cp2y,s?i.cp2x:i.cp1x,s?i.cp2y:i.cp1y,i.x,i.y)}function Be(t,e,i,s,n){if(n.strikethrough||n.underline){const o=t.measureText(s),a=e-o.actualBoundingBoxLeft,r=e+o.actualBoundingBoxRight,l=i-o.actualBoundingBoxAscent,h=i+o.actualBoundingBoxDescent,c=n.strikethrough?(l+h)/2:h;t.strokeStyle=t.fillStyle,t.beginPath(),t.lineWidth=n.decorationWidth||2,t.moveTo(a,c),t.lineTo(r,c),t.stroke()}}function We(t,e){const i=t.fillStyle;t.fillStyle=e.color,t.fillRect(e.left,e.top,e.width,e.height),t.fillStyle=i}function Ne(t,e,i,o,a,r={}){const l=n(e)?e:[e],h=r.strokeWidth>0&&\"\"!==r.strokeColor;let c,d;for(t.save(),t.font=a.string,function(t,e){e.translation&&t.translate(e.translation[0],e.translation[1]),s(e.rotation)||t.rotate(e.rotation),e.color&&(t.fillStyle=e.color),e.textAlign&&(t.textAlign=e.textAlign),e.textBaseline&&(t.textBaseline=e.textBaseline)}(t,r),c=0;c<l.length;++c)d=l[c],r.backdrop&&We(t,r.backdrop),h&&(r.strokeColor&&(t.strokeStyle=r.strokeColor),s(r.strokeWidth)||(t.lineWidth=r.strokeWidth),t.strokeText(d,i,o,r.maxWidth)),t.fillText(d,i,o,r.maxWidth),Be(t,i,o,d,r),o+=Number(a.lineHeight);t.restore()}function He(t,e){const{x:i,y:s,w:n,h:o,radius:a}=e;t.arc(i+a.topLeft,s+a.topLeft,a.topLeft,1.5*C,C,!0),t.lineTo(i,s+o-a.bottomLeft),t.arc(i+a.bottomLeft,s+o-a.bottomLeft,a.bottomLeft,C,E,!0),t.lineTo(i+n-a.bottomRight,s+o),t.arc(i+n-a.bottomRight,s+o-a.bottomRight,a.bottomRight,E,0,!0),t.lineTo(i+n,s+a.topRight),t.arc(i+n-a.topRight,s+a.topRight,a.topRight,0,-E,!0),t.lineTo(i+a.topLeft,s)}function je(t,e=[\"\"],i,s,n=(()=>t[0])){const o=i||t;void 0===s&&(s=ti(\"_fallback\",t));const a={[Symbol.toStringTag]:\"Object\",_cacheable:!0,_scopes:t,_rootScopes:o,_fallback:s,_getTarget:n,override:i=>je([i,...t],e,o,s)};return new Proxy(a,{deleteProperty:(e,i)=>(delete e[i],delete e._keys,delete t[0][i],!0),get:(i,s)=>qe(i,s,(()=>function(t,e,i,s){let n;for(const o of e)if(n=ti(Ue(o,t),i),void 0!==n)return Xe(t,n)?Je(i,s,t,n):n}(s,e,t,i))),getOwnPropertyDescriptor:(t,e)=>Reflect.getOwnPropertyDescriptor(t._scopes[0],e),getPrototypeOf:()=>Reflect.getPrototypeOf(t[0]),has:(t,e)=>ei(t).includes(e),ownKeys:t=>ei(t),set(t,e,i){const s=t._storage||(t._storage=n());return t[e]=s[e]=i,delete t._keys,!0}})}function $e(t,e,i,s){const a={_cacheable:!1,_proxy:t,_context:e,_subProxy:i,_stack:new Set,_descriptors:Ye(t,s),setContext:e=>$e(t,e,i,s),override:n=>$e(t.override(n),e,i,s)};return new Proxy(a,{deleteProperty:(e,i)=>(delete e[i],delete t[i],!0),get:(t,e,i)=>qe(t,e,(()=>function(t,e,i){const{_proxy:s,_context:a,_subProxy:r,_descriptors:l}=t;let h=s[e];S(h)&&l.isScriptable(e)&&(h=function(t,e,i,s){const{_proxy:n,_context:o,_subProxy:a,_stack:r}=i;if(r.has(t))throw new Error(\"Recursion detected: \"+Array.from(r).join(\"->\")+\"->\"+t);r.add(t);let l=e(o,a||s);r.delete(t),Xe(t,l)&&(l=Je(n._scopes,n,t,l));return l}(e,h,t,i));n(h)&&h.length&&(h=function(t,e,i,s){const{_proxy:n,_context:a,_subProxy:r,_descriptors:l}=i;if(void 0!==a.index&&s(t))return e[a.index%e.length];if(o(e[0])){const i=e,s=n._scopes.filter((t=>t!==i));e=[];for(const o of i){const i=Je(s,n,t,o);e.push($e(i,a,r&&r[t],l))}}return e}(e,h,t,l.isIndexable));Xe(e,h)&&(h=$e(h,a,r&&r[e],l));return h}(t,e,i))),getOwnPropertyDescriptor:(e,i)=>e._descriptors.allKeys?Reflect.has(t,i)?{enumerable:!0,configurable:!0}:void 0:Reflect.getOwnPropertyDescriptor(t,i),getPrototypeOf:()=>Reflect.getPrototypeOf(t),has:(e,i)=>Reflect.has(t,i),ownKeys:()=>Reflect.ownKeys(t),set:(e,i,s)=>(t[i]=s,delete e[i],!0)})}function Ye(t,e={scriptable:!0,indexable:!0}){const{_scriptable:i=e.scriptable,_indexable:s=e.indexable,_allKeys:n=e.allKeys}=t;return{allKeys:n,scriptable:i,indexable:s,isScriptable:S(i)?i:()=>i,isIndexable:S(s)?s:()=>s}}const Ue=(t,e)=>t?t+w(e):e,Xe=(t,e)=>o(e)&&\"adapters\"!==t&&(null===Object.getPrototypeOf(e)||e.constructor===Object);function qe(t,e,i){if(Object.prototype.hasOwnProperty.call(t,e))return t[e];const s=i();return t[e]=s,s}function Ke(t,e,i){return S(t)?t(e,i):t}const Ge=(t,e)=>!0===t?e:\"string\"==typeof t?M(e,t):void 0;function Ze(t,e,i,s,n){for(const o of e){const e=Ge(i,o);if(e){t.add(e);const o=Ke(e._fallback,i,n);if(void 0!==o&&o!==i&&o!==s)return o}else if(!1===e&&void 0!==s&&i!==s)return null}return!1}function Je(t,e,i,s){const a=e._rootScopes,r=Ke(e._fallback,i,s),l=[...t,...a],h=new Set;h.add(s);let c=Qe(h,l,i,r||i,s);return null!==c&&((void 0===r||r===i||(c=Qe(h,l,r,c,s),null!==c))&&je(Array.from(h),[\"\"],a,r,(()=>function(t,e,i){const s=t._getTarget();e in s||(s[e]={});const a=s[e];if(n(a)&&o(i))return i;return a||{}}(e,i,s))))}function Qe(t,e,i,s,n){for(;i;)i=Ze(t,e,i,s,n);return i}function ti(t,e){for(const i of e){if(!i)continue;const e=i[t];if(void 0!==e)return e}}function ei(t){let e=t._keys;return e||(e=t._keys=function(t){const e=new Set;for(const i of t)for(const t of Object.keys(i).filter((t=>!t.startsWith(\"_\"))))e.add(t);return Array.from(e)}(t._scopes)),e}function ii(t,e,i,s){const{iScale:n}=t,{key:o=\"r\"}=this._parsing,a=new Array(s);let r,l,h,c;for(r=0,l=s;r<l;++r)h=r+i,c=e[h],a[r]={r:n.parse(M(c,o),h)};return a}const si=Number.EPSILON||1e-14,ni=(t,e)=>e<t.length&&!t[e].skip&&t[e],oi=t=>\"x\"===t?\"y\":\"x\";function ai(t,e,i,s){const n=t.skip?e:t,o=e,a=i.skip?e:i,r=q(o,n),l=q(a,o);let h=r/(r+l),c=l/(r+l);h=isNaN(h)?0:h,c=isNaN(c)?0:c;const d=s*h,u=s*c;return{previous:{x:o.x-d*(a.x-n.x),y:o.y-d*(a.y-n.y)},next:{x:o.x+u*(a.x-n.x),y:o.y+u*(a.y-n.y)}}}function ri(t,e=\"x\"){const i=oi(e),s=t.length,n=Array(s).fill(0),o=Array(s);let a,r,l,h=ni(t,0);for(a=0;a<s;++a)if(r=l,l=h,h=ni(t,a+1),l){if(h){const t=h[e]-l[e];n[a]=0!==t?(h[i]-l[i])/t:0}o[a]=r?h?F(n[a-1])!==F(n[a])?0:(n[a-1]+n[a])/2:n[a-1]:n[a]}!function(t,e,i){const s=t.length;let n,o,a,r,l,h=ni(t,0);for(let c=0;c<s-1;++c)l=h,h=ni(t,c+1),l&&h&&(V(e[c],0,si)?i[c]=i[c+1]=0:(n=i[c]/e[c],o=i[c+1]/e[c],r=Math.pow(n,2)+Math.pow(o,2),r<=9||(a=3/Math.sqrt(r),i[c]=n*a*e[c],i[c+1]=o*a*e[c])))}(t,n,o),function(t,e,i=\"x\"){const s=oi(i),n=t.length;let o,a,r,l=ni(t,0);for(let h=0;h<n;++h){if(a=r,r=l,l=ni(t,h+1),!r)continue;const n=r[i],c=r[s];a&&(o=(n-a[i])/3,r[`cp1${i}`]=n-o,r[`cp1${s}`]=c-o*e[h]),l&&(o=(l[i]-n)/3,r[`cp2${i}`]=n+o,r[`cp2${s}`]=c+o*e[h])}}(t,o,e)}function li(t,e,i){return Math.max(Math.min(t,i),e)}function hi(t,e,i,s,n){let o,a,r,l;if(e.spanGaps&&(t=t.filter((t=>!t.skip))),\"monotone\"===e.cubicInterpolationMode)ri(t,n);else{let i=s?t[t.length-1]:t[0];for(o=0,a=t.length;o<a;++o)r=t[o],l=ai(i,r,t[Math.min(o+1,a-(s?0:1))%a],e.tension),r.cp1x=l.previous.x,r.cp1y=l.previous.y,r.cp2x=l.next.x,r.cp2y=l.next.y,i=r}e.capBezierPoints&&function(t,e){let i,s,n,o,a,r=Re(t[0],e);for(i=0,s=t.length;i<s;++i)a=o,o=r,r=i<s-1&&Re(t[i+1],e),o&&(n=t[i],a&&(n.cp1x=li(n.cp1x,e.left,e.right),n.cp1y=li(n.cp1y,e.top,e.bottom)),r&&(n.cp2x=li(n.cp2x,e.left,e.right),n.cp2y=li(n.cp2y,e.top,e.bottom)))}(t,i)}const ci=t=>0===t||1===t,di=(t,e,i)=>-Math.pow(2,10*(t-=1))*Math.sin((t-e)*O/i),ui=(t,e,i)=>Math.pow(2,-10*t)*Math.sin((t-e)*O/i)+1,fi={linear:t=>t,easeInQuad:t=>t*t,easeOutQuad:t=>-t*(t-2),easeInOutQuad:t=>(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1),easeInCubic:t=>t*t*t,easeOutCubic:t=>(t-=1)*t*t+1,easeInOutCubic:t=>(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2),easeInQuart:t=>t*t*t*t,easeOutQuart:t=>-((t-=1)*t*t*t-1),easeInOutQuart:t=>(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2),easeInQuint:t=>t*t*t*t*t,easeOutQuint:t=>(t-=1)*t*t*t*t+1,easeInOutQuint:t=>(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2),easeInSine:t=>1-Math.cos(t*E),easeOutSine:t=>Math.sin(t*E),easeInOutSine:t=>-.5*(Math.cos(C*t)-1),easeInExpo:t=>0===t?0:Math.pow(2,10*(t-1)),easeOutExpo:t=>1===t?1:1-Math.pow(2,-10*t),easeInOutExpo:t=>ci(t)?t:t<.5?.5*Math.pow(2,10*(2*t-1)):.5*(2-Math.pow(2,-10*(2*t-1))),easeInCirc:t=>t>=1?t:-(Math.sqrt(1-t*t)-1),easeOutCirc:t=>Math.sqrt(1-(t-=1)*t),easeInOutCirc:t=>(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1),easeInElastic:t=>ci(t)?t:di(t,.075,.3),easeOutElastic:t=>ci(t)?t:ui(t,.075,.3),easeInOutElastic(t){const e=.1125;return ci(t)?t:t<.5?.5*di(2*t,e,.45):.5+.5*ui(2*t-1,e,.45)},easeInBack(t){const e=1.70158;return t*t*((e+1)*t-e)},easeOutBack(t){const e=1.70158;return(t-=1)*t*((e+1)*t+e)+1},easeInOutBack(t){let e=1.70158;return(t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},easeInBounce:t=>1-fi.easeOutBounce(1-t),easeOutBounce(t){const e=7.5625,i=2.75;return t<1/i?e*t*t:t<2/i?e*(t-=1.5/i)*t+.75:t<2.5/i?e*(t-=2.25/i)*t+.9375:e*(t-=2.625/i)*t+.984375},easeInOutBounce:t=>t<.5?.5*fi.easeInBounce(2*t):.5*fi.easeOutBounce(2*t-1)+.5};function gi(t,e,i,s){return{x:t.x+i*(e.x-t.x),y:t.y+i*(e.y-t.y)}}function pi(t,e,i,s){return{x:t.x+i*(e.x-t.x),y:\"middle\"===s?i<.5?t.y:e.y:\"after\"===s?i<1?t.y:e.y:i>0?e.y:t.y}}function mi(t,e,i,s){const n={x:t.cp2x,y:t.cp2y},o={x:e.cp1x,y:e.cp1y},a=gi(t,n,i),r=gi(n,o,i),l=gi(o,e,i),h=gi(a,r,i),c=gi(r,l,i);return gi(h,c,i)}const bi=/^(normal|(\\d+(?:\\.\\d+)?)(px|em|%)?)$/,xi=/^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/;function _i(t,e){const i=(\"\"+t).match(bi);if(!i||\"normal\"===i[1])return 1.2*e;switch(t=+i[2],i[3]){case\"px\":return t;case\"%\":t/=100}return e*t}const yi=t=>+t||0;function vi(t,e){const i={},s=o(e),n=s?Object.keys(e):e,a=o(t)?s?i=>l(t[i],t[e[i]]):e=>t[e]:()=>t;for(const t of n)i[t]=yi(a(t));return i}function Mi(t){return vi(t,{top:\"y\",right:\"x\",bottom:\"y\",left:\"x\"})}function wi(t){return vi(t,[\"topLeft\",\"topRight\",\"bottomLeft\",\"bottomRight\"])}function ki(t){const e=Mi(t);return e.width=e.left+e.right,e.height=e.top+e.bottom,e}function Si(t,e){t=t||{},e=e||ue.font;let i=l(t.size,e.size);\"string\"==typeof i&&(i=parseInt(i,10));let s=l(t.style,e.style);s&&!(\"\"+s).match(xi)&&(console.warn('Invalid font style specified: \"'+s+'\"'),s=void 0);const n={family:l(t.family,e.family),lineHeight:_i(l(t.lineHeight,e.lineHeight),i),size:i,style:s,weight:l(t.weight,e.weight),string:\"\"};return n.string=De(n),n}function Pi(t,e,i,s){let o,a,r,l=!0;for(o=0,a=t.length;o<a;++o)if(r=t[o],void 0!==r&&(void 0!==e&&\"function\"==typeof r&&(r=r(e),l=!1),void 0!==i&&n(r)&&(r=r[i%r.length],l=!1),void 0!==r))return s&&!l&&(s.cacheable=!1),r}function Di(t,e,i){const{min:s,max:n}=t,o=c(e,(n-s)/2),a=(t,e)=>i&&0===t?0:t+e;return{min:a(s,-Math.abs(o)),max:a(n,o)}}function Ci(t,e){return Object.assign(Object.create(t),e)}function Oi(t,e,i){return t?function(t,e){return{x:i=>t+t+e-i,setWidth(t){e=t},textAlign:t=>\"center\"===t?t:\"right\"===t?\"left\":\"right\",xPlus:(t,e)=>t-e,leftForLtr:(t,e)=>t-e}}(e,i):{x:t=>t,setWidth(t){},textAlign:t=>t,xPlus:(t,e)=>t+e,leftForLtr:(t,e)=>t}}function Ai(t,e){let i,s;\"ltr\"!==e&&\"rtl\"!==e||(i=t.canvas.style,s=[i.getPropertyValue(\"direction\"),i.getPropertyPriority(\"direction\")],i.setProperty(\"direction\",e,\"important\"),t.prevTextDirection=s)}function Ti(t,e){void 0!==e&&(delete t.prevTextDirection,t.canvas.style.setProperty(\"direction\",e[0],e[1]))}function Li(t){return\"angle\"===t?{between:Z,compare:K,normalize:G}:{between:tt,compare:(t,e)=>t-e,normalize:t=>t}}function Ei({start:t,end:e,count:i,loop:s,style:n}){return{start:t%i,end:e%i,loop:s&&(e-t+1)%i==0,style:n}}function Ri(t,e,i){if(!i)return[t];const{property:s,start:n,end:o}=i,a=e.length,{compare:r,between:l,normalize:h}=Li(s),{start:c,end:d,loop:u,style:f}=function(t,e,i){const{property:s,start:n,end:o}=i,{between:a,normalize:r}=Li(s),l=e.length;let h,c,{start:d,end:u,loop:f}=t;if(f){for(d+=l,u+=l,h=0,c=l;h<c&&a(r(e[d%l][s]),n,o);++h)d--,u--;d%=l,u%=l}return u<d&&(u+=l),{start:d,end:u,loop:f,style:t.style}}(t,e,i),g=[];let p,m,b,x=!1,_=null;const y=()=>x||l(n,b,p)&&0!==r(n,b),v=()=>!x||0===r(o,p)||l(o,b,p);for(let t=c,i=c;t<=d;++t)m=e[t%a],m.skip||(p=h(m[s]),p!==b&&(x=l(p,n,o),null===_&&y()&&(_=0===r(p,n)?t:i),null!==_&&v()&&(g.push(Ei({start:_,end:t,loop:u,count:a,style:f})),_=null),i=t,b=p));return null!==_&&g.push(Ei({start:_,end:d,loop:u,count:a,style:f})),g}function Ii(t,e){const i=[],s=t.segments;for(let n=0;n<s.length;n++){const o=Ri(s[n],t.points,e);o.length&&i.push(...o)}return i}function zi(t,e){const i=t.points,s=t.options.spanGaps,n=i.length;if(!n)return[];const o=!!t._loop,{start:a,end:r}=function(t,e,i,s){let n=0,o=e-1;if(i&&!s)for(;n<e&&!t[n].skip;)n++;for(;n<e&&t[n].skip;)n++;for(n%=e,i&&(o+=n);o>n&&t[o%e].skip;)o--;return o%=e,{start:n,end:o}}(i,n,o,s);if(!0===s)return Fi(t,[{start:a,end:r,loop:o}],i,e);return Fi(t,function(t,e,i,s){const n=t.length,o=[];let a,r=e,l=t[e];for(a=e+1;a<=i;++a){const i=t[a%n];i.skip||i.stop?l.skip||(s=!1,o.push({start:e%n,end:(a-1)%n,loop:s}),e=r=i.stop?a:null):(r=a,l.skip&&(e=a)),l=i}return null!==r&&o.push({start:e%n,end:r%n,loop:s}),o}(i,a,r<a?r+n:r,!!t._fullLoop&&0===a&&r===n-1),i,e)}function Fi(t,e,i,s){return s&&s.setContext&&i?function(t,e,i,s){const n=t._chart.getContext(),o=Vi(t.options),{_datasetIndex:a,options:{spanGaps:r}}=t,l=i.length,h=[];let c=o,d=e[0].start,u=d;function f(t,e,s,n){const o=r?-1:1;if(t!==e){for(t+=l;i[t%l].skip;)t-=o;for(;i[e%l].skip;)e+=o;t%l!=e%l&&(h.push({start:t%l,end:e%l,loop:s,style:n}),c=n,d=e%l)}}for(const t of e){d=r?d:t.start;let e,o=i[d%l];for(u=d+1;u<=t.end;u++){const r=i[u%l];e=Vi(s.setContext(Ci(n,{type:\"segment\",p0:o,p1:r,p0DataIndex:(u-1)%l,p1DataIndex:u%l,datasetIndex:a}))),Bi(e,c)&&f(d,u-1,t.loop,c),o=r,c=e}d<u-1&&f(d,u-1,t.loop,c)}return h}(t,e,i,s):e}function Vi(t){return{backgroundColor:t.backgroundColor,borderCapStyle:t.borderCapStyle,borderDash:t.borderDash,borderDashOffset:t.borderDashOffset,borderJoinStyle:t.borderJoinStyle,borderWidth:t.borderWidth,borderColor:t.borderColor}}function Bi(t,e){if(!e)return!1;const i=[],s=function(t,e){return Jt(e)?(i.includes(e)||i.push(e),i.indexOf(e)):e};return JSON.stringify(t,s)!==JSON.stringify(e,s)}var Wi=Object.freeze({__proto__:null,HALF_PI:E,INFINITY:T,PI:C,PITAU:A,QUARTER_PI:R,RAD_PER_DEG:L,TAU:O,TWO_THIRDS_PI:I,_addGrace:Di,_alignPixel:Ae,_alignStartEnd:ft,_angleBetween:Z,_angleDiff:K,_arrayUnique:lt,_attachContext:$e,_bezierCurveTo:Ve,_bezierInterpolation:mi,_boundSegment:Ri,_boundSegments:Ii,_capitalize:w,_computeSegments:zi,_createResolver:je,_decimalPlaces:U,_deprecated:function(t,e,i,s){void 0!==e&&console.warn(t+': \"'+i+'\" is deprecated. Please use \"'+s+'\" instead')},_descriptors:Ye,_elementsEqual:f,_factorize:W,_filterBetween:nt,_getParentNode:ge,_getStartAndCountOfVisiblePoints:pt,_int16Range:Q,_isBetween:tt,_isClickEvent:D,_isDomSupported:fe,_isPointInArea:Re,_limitValue:J,_longestText:Oe,_lookup:et,_lookupByKey:it,_measureText:Ce,_merger:m,_mergerIf:_,_normalizeAngle:G,_parseObjectDataRadialScale:ii,_pointInLine:gi,_readValueToProps:vi,_rlookupByKey:st,_scaleRangesChanged:mt,_setMinAndMaxByKey:j,_splitKey:v,_steppedInterpolation:pi,_steppedLineTo:Fe,_textX:gt,_toLeftRightCenter:ut,_updateBezierControlPoints:hi,addRoundedRectPath:He,almostEquals:V,almostWhole:H,callback:d,clearCanvas:Te,clipArea:Ie,clone:g,color:Qt,createContext:Ci,debounce:dt,defined:k,distanceBetweenPoints:q,drawPoint:Le,drawPointLegend:Ee,each:u,easingEffects:fi,finiteOrDefault:r,fontString:function(t,e,i){return e+\" \"+t+\"px \"+i},formatNumber:ne,getAngleFromPoint:X,getHoverColor:te,getMaximumSize:we,getRelativePosition:ve,getRtlAdapter:Oi,getStyle:be,isArray:n,isFinite:a,isFunction:S,isNullOrUndef:s,isNumber:N,isObject:o,isPatternOrGradient:Jt,listenArrayEvents:at,log10:z,merge:b,mergeIf:x,niceNum:B,noop:e,overrideTextDirection:Ai,readUsedSize:Pe,renderText:Ne,requestAnimFrame:ht,resolve:Pi,resolveObjectKey:M,restoreTextDirection:Ti,retinaScale:ke,setsEqual:P,sign:F,splineCurve:ai,splineCurveMonotone:ri,supportsEventListenerOptions:Se,throttled:ct,toDegrees:Y,toDimension:c,toFont:Si,toFontString:De,toLineHeight:_i,toPadding:ki,toPercentage:h,toRadians:$,toTRBL:Mi,toTRBLCorners:wi,uid:i,unclipArea:ze,unlistenArrayEvents:rt,valueOrDefault:l});function Ni(t,e,i,s){const{controller:n,data:o,_sorted:a}=t,r=n._cachedMeta.iScale;if(r&&e===r.axis&&\"r\"!==e&&a&&o.length){const t=r._reversePixels?st:it;if(!s)return t(o,e,i);if(n._sharedOptions){const s=o[0],n=\"function\"==typeof s.getRange&&s.getRange(e);if(n){const s=t(o,e,i-n),a=t(o,e,i+n);return{lo:s.lo,hi:a.hi}}}}return{lo:0,hi:o.length-1}}function Hi(t,e,i,s,n){const o=t.getSortedVisibleDatasetMetas(),a=i[e];for(let t=0,i=o.length;t<i;++t){const{index:i,data:r}=o[t],{lo:l,hi:h}=Ni(o[t],e,a,n);for(let t=l;t<=h;++t){const e=r[t];e.skip||s(e,i,t)}}}function ji(t,e,i,s,n){const o=[];if(!n&&!t.isPointInArea(e))return o;return Hi(t,i,e,(function(i,a,r){(n||Re(i,t.chartArea,0))&&i.inRange(e.x,e.y,s)&&o.push({element:i,datasetIndex:a,index:r})}),!0),o}function $i(t,e,i,s,n,o){let a=[];const r=function(t){const e=-1!==t.indexOf(\"x\"),i=-1!==t.indexOf(\"y\");return function(t,s){const n=e?Math.abs(t.x-s.x):0,o=i?Math.abs(t.y-s.y):0;return Math.sqrt(Math.pow(n,2)+Math.pow(o,2))}}(i);let l=Number.POSITIVE_INFINITY;return Hi(t,i,e,(function(i,h,c){const d=i.inRange(e.x,e.y,n);if(s&&!d)return;const u=i.getCenterPoint(n);if(!(!!o||t.isPointInArea(u))&&!d)return;const f=r(e,u);f<l?(a=[{element:i,datasetIndex:h,index:c}],l=f):f===l&&a.push({element:i,datasetIndex:h,index:c})})),a}function Yi(t,e,i,s,n,o){return o||t.isPointInArea(e)?\"r\"!==i||s?$i(t,e,i,s,n,o):function(t,e,i,s){let n=[];return Hi(t,i,e,(function(t,i,o){const{startAngle:a,endAngle:r}=t.getProps([\"startAngle\",\"endAngle\"],s),{angle:l}=X(t,{x:e.x,y:e.y});Z(l,a,r)&&n.push({element:t,datasetIndex:i,index:o})})),n}(t,e,i,n):[]}function Ui(t,e,i,s,n){const o=[],a=\"x\"===i?\"inXRange\":\"inYRange\";let r=!1;return Hi(t,i,e,((t,s,l)=>{t[a](e[i],n)&&(o.push({element:t,datasetIndex:s,index:l}),r=r||t.inRange(e.x,e.y,n))})),s&&!r?[]:o}var Xi={evaluateInteractionItems:Hi,modes:{index(t,e,i,s){const n=ve(e,t),o=i.axis||\"x\",a=i.includeInvisible||!1,r=i.intersect?ji(t,n,o,s,a):Yi(t,n,o,!1,s,a),l=[];return r.length?(t.getSortedVisibleDatasetMetas().forEach((t=>{const e=r[0].index,i=t.data[e];i&&!i.skip&&l.push({element:i,datasetIndex:t.index,index:e})})),l):[]},dataset(t,e,i,s){const n=ve(e,t),o=i.axis||\"xy\",a=i.includeInvisible||!1;let r=i.intersect?ji(t,n,o,s,a):Yi(t,n,o,!1,s,a);if(r.length>0){const e=r[0].datasetIndex,i=t.getDatasetMeta(e).data;r=[];for(let t=0;t<i.length;++t)r.push({element:i[t],datasetIndex:e,index:t})}return r},point:(t,e,i,s)=>ji(t,ve(e,t),i.axis||\"xy\",s,i.includeInvisible||!1),nearest(t,e,i,s){const n=ve(e,t),o=i.axis||\"xy\",a=i.includeInvisible||!1;return Yi(t,n,o,i.intersect,s,a)},x:(t,e,i,s)=>Ui(t,ve(e,t),\"x\",i.intersect,s),y:(t,e,i,s)=>Ui(t,ve(e,t),\"y\",i.intersect,s)}};const qi=[\"left\",\"top\",\"right\",\"bottom\"];function Ki(t,e){return t.filter((t=>t.pos===e))}function Gi(t,e){return t.filter((t=>-1===qi.indexOf(t.pos)&&t.box.axis===e))}function Zi(t,e){return t.sort(((t,i)=>{const s=e?i:t,n=e?t:i;return s.weight===n.weight?s.index-n.index:s.weight-n.weight}))}function Ji(t,e){const i=function(t){const e={};for(const i of t){const{stack:t,pos:s,stackWeight:n}=i;if(!t||!qi.includes(s))continue;const o=e[t]||(e[t]={count:0,placed:0,weight:0,size:0});o.count++,o.weight+=n}return e}(t),{vBoxMaxWidth:s,hBoxMaxHeight:n}=e;let o,a,r;for(o=0,a=t.length;o<a;++o){r=t[o];const{fullSize:a}=r.box,l=i[r.stack],h=l&&r.stackWeight/l.weight;r.horizontal?(r.width=h?h*s:a&&e.availableWidth,r.height=n):(r.width=s,r.height=h?h*n:a&&e.availableHeight)}return i}function Qi(t,e,i,s){return Math.max(t[i],e[i])+Math.max(t[s],e[s])}function ts(t,e){t.top=Math.max(t.top,e.top),t.left=Math.max(t.left,e.left),t.bottom=Math.max(t.bottom,e.bottom),t.right=Math.max(t.right,e.right)}function es(t,e,i,s){const{pos:n,box:a}=i,r=t.maxPadding;if(!o(n)){i.size&&(t[n]-=i.size);const e=s[i.stack]||{size:0,count:1};e.size=Math.max(e.size,i.horizontal?a.height:a.width),i.size=e.size/e.count,t[n]+=i.size}a.getPadding&&ts(r,a.getPadding());const l=Math.max(0,e.outerWidth-Qi(r,t,\"left\",\"right\")),h=Math.max(0,e.outerHeight-Qi(r,t,\"top\",\"bottom\")),c=l!==t.w,d=h!==t.h;return t.w=l,t.h=h,i.horizontal?{same:c,other:d}:{same:d,other:c}}function is(t,e){const i=e.maxPadding;function s(t){const s={left:0,top:0,right:0,bottom:0};return t.forEach((t=>{s[t]=Math.max(e[t],i[t])})),s}return s(t?[\"left\",\"right\"]:[\"top\",\"bottom\"])}function ss(t,e,i,s){const n=[];let o,a,r,l,h,c;for(o=0,a=t.length,h=0;o<a;++o){r=t[o],l=r.box,l.update(r.width||e.w,r.height||e.h,is(r.horizontal,e));const{same:a,other:d}=es(e,i,r,s);h|=a&&n.length,c=c||d,l.fullSize||n.push(r)}return h&&ss(n,e,i,s)||c}function ns(t,e,i,s,n){t.top=i,t.left=e,t.right=e+s,t.bottom=i+n,t.width=s,t.height=n}function os(t,e,i,s){const n=i.padding;let{x:o,y:a}=e;for(const r of t){const t=r.box,l=s[r.stack]||{count:1,placed:0,weight:1},h=r.stackWeight/l.weight||1;if(r.horizontal){const s=e.w*h,o=l.size||t.height;k(l.start)&&(a=l.start),t.fullSize?ns(t,n.left,a,i.outerWidth-n.right-n.left,o):ns(t,e.left+l.placed,a,s,o),l.start=a,l.placed+=s,a=t.bottom}else{const s=e.h*h,a=l.size||t.width;k(l.start)&&(o=l.start),t.fullSize?ns(t,o,n.top,a,i.outerHeight-n.bottom-n.top):ns(t,o,e.top+l.placed,a,s),l.start=o,l.placed+=s,o=t.right}}e.x=o,e.y=a}var as={addBox(t,e){t.boxes||(t.boxes=[]),e.fullSize=e.fullSize||!1,e.position=e.position||\"top\",e.weight=e.weight||0,e._layers=e._layers||function(){return[{z:0,draw(t){e.draw(t)}}]},t.boxes.push(e)},removeBox(t,e){const i=t.boxes?t.boxes.indexOf(e):-1;-1!==i&&t.boxes.splice(i,1)},configure(t,e,i){e.fullSize=i.fullSize,e.position=i.position,e.weight=i.weight},update(t,e,i,s){if(!t)return;const n=ki(t.options.layout.padding),o=Math.max(e-n.width,0),a=Math.max(i-n.height,0),r=function(t){const e=function(t){const e=[];let i,s,n,o,a,r;for(i=0,s=(t||[]).length;i<s;++i)n=t[i],({position:o,options:{stack:a,stackWeight:r=1}}=n),e.push({index:i,box:n,pos:o,horizontal:n.isHorizontal(),weight:n.weight,stack:a&&o+a,stackWeight:r});return e}(t),i=Zi(e.filter((t=>t.box.fullSize)),!0),s=Zi(Ki(e,\"left\"),!0),n=Zi(Ki(e,\"right\")),o=Zi(Ki(e,\"top\"),!0),a=Zi(Ki(e,\"bottom\")),r=Gi(e,\"x\"),l=Gi(e,\"y\");return{fullSize:i,leftAndTop:s.concat(o),rightAndBottom:n.concat(l).concat(a).concat(r),chartArea:Ki(e,\"chartArea\"),vertical:s.concat(n).concat(l),horizontal:o.concat(a).concat(r)}}(t.boxes),l=r.vertical,h=r.horizontal;u(t.boxes,(t=>{\"function\"==typeof t.beforeLayout&&t.beforeLayout()}));const c=l.reduce(((t,e)=>e.box.options&&!1===e.box.options.display?t:t+1),0)||1,d=Object.freeze({outerWidth:e,outerHeight:i,padding:n,availableWidth:o,availableHeight:a,vBoxMaxWidth:o/2/c,hBoxMaxHeight:a/2}),f=Object.assign({},n);ts(f,ki(s));const g=Object.assign({maxPadding:f,w:o,h:a,x:n.left,y:n.top},n),p=Ji(l.concat(h),d);ss(r.fullSize,g,d,p),ss(l,g,d,p),ss(h,g,d,p)&&ss(l,g,d,p),function(t){const e=t.maxPadding;function i(i){const s=Math.max(e[i]-t[i],0);return t[i]+=s,s}t.y+=i(\"top\"),t.x+=i(\"left\"),i(\"right\"),i(\"bottom\")}(g),os(r.leftAndTop,g,d,p),g.x+=g.w,g.y+=g.h,os(r.rightAndBottom,g,d,p),t.chartArea={left:g.left,top:g.top,right:g.left+g.w,bottom:g.top+g.h,height:g.h,width:g.w},u(r.chartArea,(e=>{const i=e.box;Object.assign(i,t.chartArea),i.update(g.w,g.h,{left:0,top:0,right:0,bottom:0})}))}};class rs{acquireContext(t,e){}releaseContext(t){return!1}addEventListener(t,e,i){}removeEventListener(t,e,i){}getDevicePixelRatio(){return 1}getMaximumSize(t,e,i,s){return e=Math.max(0,e||t.width),i=i||t.height,{width:e,height:Math.max(0,s?Math.floor(e/s):i)}}isAttached(t){return!0}updateConfig(t){}}class ls extends rs{acquireContext(t){return t&&t.getContext&&t.getContext(\"2d\")||null}updateConfig(t){t.options.animation=!1}}const hs=\"$chartjs\",cs={touchstart:\"mousedown\",touchmove:\"mousemove\",touchend:\"mouseup\",pointerenter:\"mouseenter\",pointerdown:\"mousedown\",pointermove:\"mousemove\",pointerup:\"mouseup\",pointerleave:\"mouseout\",pointerout:\"mouseout\"},ds=t=>null===t||\"\"===t;const us=!!Se&&{passive:!0};function fs(t,e,i){t.canvas.removeEventListener(e,i,us)}function gs(t,e){for(const i of t)if(i===e||i.contains(e))return!0}function ps(t,e,i){const s=t.canvas,n=new MutationObserver((t=>{let e=!1;for(const i of t)e=e||gs(i.addedNodes,s),e=e&&!gs(i.removedNodes,s);e&&i()}));return n.observe(document,{childList:!0,subtree:!0}),n}function ms(t,e,i){const s=t.canvas,n=new MutationObserver((t=>{let e=!1;for(const i of t)e=e||gs(i.removedNodes,s),e=e&&!gs(i.addedNodes,s);e&&i()}));return n.observe(document,{childList:!0,subtree:!0}),n}const bs=new Map;let xs=0;function _s(){const t=window.devicePixelRatio;t!==xs&&(xs=t,bs.forEach(((e,i)=>{i.currentDevicePixelRatio!==t&&e()})))}function ys(t,e,i){const s=t.canvas,n=s&&ge(s);if(!n)return;const o=ct(((t,e)=>{const s=n.clientWidth;i(t,e),s<n.clientWidth&&i()}),window),a=new ResizeObserver((t=>{const e=t[0],i=e.contentRect.width,s=e.contentRect.height;0===i&&0===s||o(i,s)}));return a.observe(n),function(t,e){bs.size||window.addEventListener(\"resize\",_s),bs.set(t,e)}(t,o),a}function vs(t,e,i){i&&i.disconnect(),\"resize\"===e&&function(t){bs.delete(t),bs.size||window.removeEventListener(\"resize\",_s)}(t)}function Ms(t,e,i){const s=t.canvas,n=ct((e=>{null!==t.ctx&&i(function(t,e){const i=cs[t.type]||t.type,{x:s,y:n}=ve(t,e);return{type:i,chart:e,native:t,x:void 0!==s?s:null,y:void 0!==n?n:null}}(e,t))}),t);return function(t,e,i){t.addEventListener(e,i,us)}(s,e,n),n}class ws extends rs{acquireContext(t,e){const i=t&&t.getContext&&t.getContext(\"2d\");return i&&i.canvas===t?(function(t,e){const i=t.style,s=t.getAttribute(\"height\"),n=t.getAttribute(\"width\");if(t[hs]={initial:{height:s,width:n,style:{display:i.display,height:i.height,width:i.width}}},i.display=i.display||\"block\",i.boxSizing=i.boxSizing||\"border-box\",ds(n)){const e=Pe(t,\"width\");void 0!==e&&(t.width=e)}if(ds(s))if(\"\"===t.style.height)t.height=t.width/(e||2);else{const e=Pe(t,\"height\");void 0!==e&&(t.height=e)}}(t,e),i):null}releaseContext(t){const e=t.canvas;if(!e[hs])return!1;const i=e[hs].initial;[\"height\",\"width\"].forEach((t=>{const n=i[t];s(n)?e.removeAttribute(t):e.setAttribute(t,n)}));const n=i.style||{};return Object.keys(n).forEach((t=>{e.style[t]=n[t]})),e.width=e.width,delete e[hs],!0}addEventListener(t,e,i){this.removeEventListener(t,e);const s=t.$proxies||(t.$proxies={}),n={attach:ps,detach:ms,resize:ys}[e]||Ms;s[e]=n(t,e,i)}removeEventListener(t,e){const i=t.$proxies||(t.$proxies={}),s=i[e];if(!s)return;({attach:vs,detach:vs,resize:vs}[e]||fs)(t,e,s),i[e]=void 0}getDevicePixelRatio(){return window.devicePixelRatio}getMaximumSize(t,e,i,s){return we(t,e,i,s)}isAttached(t){const e=ge(t);return!(!e||!e.isConnected)}}function ks(t){return!fe()||\"undefined\"!=typeof OffscreenCanvas&&t instanceof OffscreenCanvas?ls:ws}var Ss=Object.freeze({__proto__:null,BasePlatform:rs,BasicPlatform:ls,DomPlatform:ws,_detectPlatform:ks});const Ps=\"transparent\",Ds={boolean:(t,e,i)=>i>.5?e:t,color(t,e,i){const s=Qt(t||Ps),n=s.valid&&Qt(e||Ps);return n&&n.valid?n.mix(s,i).hexString():e},number:(t,e,i)=>t+(e-t)*i};class Cs{constructor(t,e,i,s){const n=e[i];s=Pi([t.to,s,n,t.from]);const o=Pi([t.from,n,s]);this._active=!0,this._fn=t.fn||Ds[t.type||typeof o],this._easing=fi[t.easing]||fi.linear,this._start=Math.floor(Date.now()+(t.delay||0)),this._duration=this._total=Math.floor(t.duration),this._loop=!!t.loop,this._target=e,this._prop=i,this._from=o,this._to=s,this._promises=void 0}active(){return this._active}update(t,e,i){if(this._active){this._notify(!1);const s=this._target[this._prop],n=i-this._start,o=this._duration-n;this._start=i,this._duration=Math.floor(Math.max(o,t.duration)),this._total+=n,this._loop=!!t.loop,this._to=Pi([t.to,e,s,t.from]),this._from=Pi([t.from,s,e])}}cancel(){this._active&&(this.tick(Date.now()),this._active=!1,this._notify(!1))}tick(t){const e=t-this._start,i=this._duration,s=this._prop,n=this._from,o=this._loop,a=this._to;let r;if(this._active=n!==a&&(o||e<i),!this._active)return this._target[s]=a,void this._notify(!0);e<0?this._target[s]=n:(r=e/i%2,r=o&&r>1?2-r:r,r=this._easing(Math.min(1,Math.max(0,r))),this._target[s]=this._fn(n,a,r))}wait(){const t=this._promises||(this._promises=[]);return new Promise(((e,i)=>{t.push({res:e,rej:i})}))}_notify(t){const e=t?\"res\":\"rej\",i=this._promises||[];for(let t=0;t<i.length;t++)i[t][e]()}}class Os{constructor(t,e){this._chart=t,this._properties=new Map,this.configure(e)}configure(t){if(!o(t))return;const e=Object.keys(ue.animation),i=this._properties;Object.getOwnPropertyNames(t).forEach((s=>{const a=t[s];if(!o(a))return;const r={};for(const t of e)r[t]=a[t];(n(a.properties)&&a.properties||[s]).forEach((t=>{t!==s&&i.has(t)||i.set(t,r)}))}))}_animateOptions(t,e){const i=e.options,s=function(t,e){if(!e)return;let i=t.options;if(!i)return void(t.options=e);i.$shared&&(t.options=i=Object.assign({},i,{$shared:!1,$animations:{}}));return i}(t,i);if(!s)return[];const n=this._createAnimations(s,i);return i.$shared&&function(t,e){const i=[],s=Object.keys(e);for(let e=0;e<s.length;e++){const n=t[s[e]];n&&n.active()&&i.push(n.wait())}return Promise.all(i)}(t.options.$animations,i).then((()=>{t.options=i}),(()=>{})),n}_createAnimations(t,e){const i=this._properties,s=[],n=t.$animations||(t.$animations={}),o=Object.keys(e),a=Date.now();let r;for(r=o.length-1;r>=0;--r){const l=o[r];if(\"$\"===l.charAt(0))continue;if(\"options\"===l){s.push(...this._animateOptions(t,e));continue}const h=e[l];let c=n[l];const d=i.get(l);if(c){if(d&&c.active()){c.update(d,h,a);continue}c.cancel()}d&&d.duration?(n[l]=c=new Cs(d,t,l,h),s.push(c)):t[l]=h}return s}update(t,e){if(0===this._properties.size)return void Object.assign(t,e);const i=this._createAnimations(t,e);return i.length?(xt.add(this._chart,i),!0):void 0}}function As(t,e){const i=t&&t.options||{},s=i.reverse,n=void 0===i.min?e:0,o=void 0===i.max?e:0;return{start:s?o:n,end:s?n:o}}function Ts(t,e){const i=[],s=t._getSortedDatasetMetas(e);let n,o;for(n=0,o=s.length;n<o;++n)i.push(s[n].index);return i}function Ls(t,e,i,s={}){const n=t.keys,o=\"single\"===s.mode;let r,l,h,c;if(null!==e){for(r=0,l=n.length;r<l;++r){if(h=+n[r],h===i){if(s.all)continue;break}c=t.values[h],a(c)&&(o||0===e||F(e)===F(c))&&(e+=c)}return e}}function Es(t,e){const i=t&&t.options.stacked;return i||void 0===i&&void 0!==e.stack}function Rs(t,e,i){const s=t[e]||(t[e]={});return s[i]||(s[i]={})}function Is(t,e,i,s){for(const n of e.getMatchingVisibleMetas(s).reverse()){const e=t[n.index];if(i&&e>0||!i&&e<0)return n.index}return null}function zs(t,e){const{chart:i,_cachedMeta:s}=t,n=i._stacks||(i._stacks={}),{iScale:o,vScale:a,index:r}=s,l=o.axis,h=a.axis,c=function(t,e,i){return`${t.id}.${e.id}.${i.stack||i.type}`}(o,a,s),d=e.length;let u;for(let t=0;t<d;++t){const i=e[t],{[l]:o,[h]:d}=i;u=(i._stacks||(i._stacks={}))[h]=Rs(n,c,o),u[r]=d,u._top=Is(u,a,!0,s.type),u._bottom=Is(u,a,!1,s.type);(u._visualValues||(u._visualValues={}))[r]=d}}function Fs(t,e){const i=t.scales;return Object.keys(i).filter((t=>i[t].axis===e)).shift()}function Vs(t,e){const i=t.controller.index,s=t.vScale&&t.vScale.axis;if(s){e=e||t._parsed;for(const t of e){const e=t._stacks;if(!e||void 0===e[s]||void 0===e[s][i])return;delete e[s][i],void 0!==e[s]._visualValues&&void 0!==e[s]._visualValues[i]&&delete e[s]._visualValues[i]}}}const Bs=t=>\"reset\"===t||\"none\"===t,Ws=(t,e)=>e?t:Object.assign({},t);class Ns{static defaults={};static datasetElementType=null;static dataElementType=null;constructor(t,e){this.chart=t,this._ctx=t.ctx,this.index=e,this._cachedDataOpts={},this._cachedMeta=this.getMeta(),this._type=this._cachedMeta.type,this.options=void 0,this._parsing=!1,this._data=void 0,this._objectData=void 0,this._sharedOptions=void 0,this._drawStart=void 0,this._drawCount=void 0,this.enableOptionSharing=!1,this.supportsDecimation=!1,this.$context=void 0,this._syncList=[],this.datasetElementType=new.target.datasetElementType,this.dataElementType=new.target.dataElementType,this.initialize()}initialize(){const t=this._cachedMeta;this.configure(),this.linkScales(),t._stacked=Es(t.vScale,t),this.addElements(),this.options.fill&&!this.chart.isPluginEnabled(\"filler\")&&console.warn(\"Tried to use the 'fill' option without the 'Filler' plugin enabled. Please import and register the 'Filler' plugin and make sure it is not disabled in the options\")}updateIndex(t){this.index!==t&&Vs(this._cachedMeta),this.index=t}linkScales(){const t=this.chart,e=this._cachedMeta,i=this.getDataset(),s=(t,e,i,s)=>\"x\"===t?e:\"r\"===t?s:i,n=e.xAxisID=l(i.xAxisID,Fs(t,\"x\")),o=e.yAxisID=l(i.yAxisID,Fs(t,\"y\")),a=e.rAxisID=l(i.rAxisID,Fs(t,\"r\")),r=e.indexAxis,h=e.iAxisID=s(r,n,o,a),c=e.vAxisID=s(r,o,n,a);e.xScale=this.getScaleForId(n),e.yScale=this.getScaleForId(o),e.rScale=this.getScaleForId(a),e.iScale=this.getScaleForId(h),e.vScale=this.getScaleForId(c)}getDataset(){return this.chart.data.datasets[this.index]}getMeta(){return this.chart.getDatasetMeta(this.index)}getScaleForId(t){return this.chart.scales[t]}_getOtherScale(t){const e=this._cachedMeta;return t===e.iScale?e.vScale:e.iScale}reset(){this._update(\"reset\")}_destroy(){const t=this._cachedMeta;this._data&&rt(this._data,this),t._stacked&&Vs(t)}_dataCheck(){const t=this.getDataset(),e=t.data||(t.data=[]),i=this._data;if(o(e))this._data=function(t){const e=Object.keys(t),i=new Array(e.length);let s,n,o;for(s=0,n=e.length;s<n;++s)o=e[s],i[s]={x:o,y:t[o]};return i}(e);else if(i!==e){if(i){rt(i,this);const t=this._cachedMeta;Vs(t),t._parsed=[]}e&&Object.isExtensible(e)&&at(e,this),this._syncList=[],this._data=e}}addElements(){const t=this._cachedMeta;this._dataCheck(),this.datasetElementType&&(t.dataset=new this.datasetElementType)}buildOrUpdateElements(t){const e=this._cachedMeta,i=this.getDataset();let s=!1;this._dataCheck();const n=e._stacked;e._stacked=Es(e.vScale,e),e.stack!==i.stack&&(s=!0,Vs(e),e.stack=i.stack),this._resyncElements(t),(s||n!==e._stacked)&&zs(this,e._parsed)}configure(){const t=this.chart.config,e=t.datasetScopeKeys(this._type),i=t.getOptionScopes(this.getDataset(),e,!0);this.options=t.createResolver(i,this.getContext()),this._parsing=this.options.parsing,this._cachedDataOpts={}}parse(t,e){const{_cachedMeta:i,_data:s}=this,{iScale:a,_stacked:r}=i,l=a.axis;let h,c,d,u=0===t&&e===s.length||i._sorted,f=t>0&&i._parsed[t-1];if(!1===this._parsing)i._parsed=s,i._sorted=!0,d=s;else{d=n(s[t])?this.parseArrayData(i,s,t,e):o(s[t])?this.parseObjectData(i,s,t,e):this.parsePrimitiveData(i,s,t,e);const a=()=>null===c[l]||f&&c[l]<f[l];for(h=0;h<e;++h)i._parsed[h+t]=c=d[h],u&&(a()&&(u=!1),f=c);i._sorted=u}r&&zs(this,d)}parsePrimitiveData(t,e,i,s){const{iScale:n,vScale:o}=t,a=n.axis,r=o.axis,l=n.getLabels(),h=n===o,c=new Array(s);let d,u,f;for(d=0,u=s;d<u;++d)f=d+i,c[d]={[a]:h||n.parse(l[f],f),[r]:o.parse(e[f],f)};return c}parseArrayData(t,e,i,s){const{xScale:n,yScale:o}=t,a=new Array(s);let r,l,h,c;for(r=0,l=s;r<l;++r)h=r+i,c=e[h],a[r]={x:n.parse(c[0],h),y:o.parse(c[1],h)};return a}parseObjectData(t,e,i,s){const{xScale:n,yScale:o}=t,{xAxisKey:a=\"x\",yAxisKey:r=\"y\"}=this._parsing,l=new Array(s);let h,c,d,u;for(h=0,c=s;h<c;++h)d=h+i,u=e[d],l[h]={x:n.parse(M(u,a),d),y:o.parse(M(u,r),d)};return l}getParsed(t){return this._cachedMeta._parsed[t]}getDataElement(t){return this._cachedMeta.data[t]}applyStack(t,e,i){const s=this.chart,n=this._cachedMeta,o=e[t.axis];return Ls({keys:Ts(s,!0),values:e._stacks[t.axis]._visualValues},o,n.index,{mode:i})}updateRangeFromParsed(t,e,i,s){const n=i[e.axis];let o=null===n?NaN:n;const a=s&&i._stacks[e.axis];s&&a&&(s.values=a,o=Ls(s,n,this._cachedMeta.index)),t.min=Math.min(t.min,o),t.max=Math.max(t.max,o)}getMinMax(t,e){const i=this._cachedMeta,s=i._parsed,n=i._sorted&&t===i.iScale,o=s.length,r=this._getOtherScale(t),l=((t,e,i)=>t&&!e.hidden&&e._stacked&&{keys:Ts(i,!0),values:null})(e,i,this.chart),h={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY},{min:c,max:d}=function(t){const{min:e,max:i,minDefined:s,maxDefined:n}=t.getUserBounds();return{min:s?e:Number.NEGATIVE_INFINITY,max:n?i:Number.POSITIVE_INFINITY}}(r);let u,f;function g(){f=s[u];const e=f[r.axis];return!a(f[t.axis])||c>e||d<e}for(u=0;u<o&&(g()||(this.updateRangeFromParsed(h,t,f,l),!n));++u);if(n)for(u=o-1;u>=0;--u)if(!g()){this.updateRangeFromParsed(h,t,f,l);break}return h}getAllParsedValues(t){const e=this._cachedMeta._parsed,i=[];let s,n,o;for(s=0,n=e.length;s<n;++s)o=e[s][t.axis],a(o)&&i.push(o);return i}getMaxOverflow(){return!1}getLabelAndValue(t){const e=this._cachedMeta,i=e.iScale,s=e.vScale,n=this.getParsed(t);return{label:i?\"\"+i.getLabelForValue(n[i.axis]):\"\",value:s?\"\"+s.getLabelForValue(n[s.axis]):\"\"}}_update(t){const e=this._cachedMeta;this.update(t||\"default\"),e._clip=function(t){let e,i,s,n;return o(t)?(e=t.top,i=t.right,s=t.bottom,n=t.left):e=i=s=n=t,{top:e,right:i,bottom:s,left:n,disabled:!1===t}}(l(this.options.clip,function(t,e,i){if(!1===i)return!1;const s=As(t,i),n=As(e,i);return{top:n.end,right:s.end,bottom:n.start,left:s.start}}(e.xScale,e.yScale,this.getMaxOverflow())))}update(t){}draw(){const t=this._ctx,e=this.chart,i=this._cachedMeta,s=i.data||[],n=e.chartArea,o=[],a=this._drawStart||0,r=this._drawCount||s.length-a,l=this.options.drawActiveElementsOnTop;let h;for(i.dataset&&i.dataset.draw(t,n,a,r),h=a;h<a+r;++h){const e=s[h];e.hidden||(e.active&&l?o.push(e):e.draw(t,n))}for(h=0;h<o.length;++h)o[h].draw(t,n)}getStyle(t,e){const i=e?\"active\":\"default\";return void 0===t&&this._cachedMeta.dataset?this.resolveDatasetElementOptions(i):this.resolveDataElementOptions(t||0,i)}getContext(t,e,i){const s=this.getDataset();let n;if(t>=0&&t<this._cachedMeta.data.length){const e=this._cachedMeta.data[t];n=e.$context||(e.$context=function(t,e,i){return Ci(t,{active:!1,dataIndex:e,parsed:void 0,raw:void 0,element:i,index:e,mode:\"default\",type:\"data\"})}(this.getContext(),t,e)),n.parsed=this.getParsed(t),n.raw=s.data[t],n.index=n.dataIndex=t}else n=this.$context||(this.$context=function(t,e){return Ci(t,{active:!1,dataset:void 0,datasetIndex:e,index:e,mode:\"default\",type:\"dataset\"})}(this.chart.getContext(),this.index)),n.dataset=s,n.index=n.datasetIndex=this.index;return n.active=!!e,n.mode=i,n}resolveDatasetElementOptions(t){return this._resolveElementOptions(this.datasetElementType.id,t)}resolveDataElementOptions(t,e){return this._resolveElementOptions(this.dataElementType.id,e,t)}_resolveElementOptions(t,e=\"default\",i){const s=\"active\"===e,n=this._cachedDataOpts,o=t+\"-\"+e,a=n[o],r=this.enableOptionSharing&&k(i);if(a)return Ws(a,r);const l=this.chart.config,h=l.datasetElementScopeKeys(this._type,t),c=s?[`${t}Hover`,\"hover\",t,\"\"]:[t,\"\"],d=l.getOptionScopes(this.getDataset(),h),u=Object.keys(ue.elements[t]),f=l.resolveNamedOptions(d,u,(()=>this.getContext(i,s,e)),c);return f.$shared&&(f.$shared=r,n[o]=Object.freeze(Ws(f,r))),f}_resolveAnimations(t,e,i){const s=this.chart,n=this._cachedDataOpts,o=`animation-${e}`,a=n[o];if(a)return a;let r;if(!1!==s.options.animation){const s=this.chart.config,n=s.datasetAnimationScopeKeys(this._type,e),o=s.getOptionScopes(this.getDataset(),n);r=s.createResolver(o,this.getContext(t,i,e))}const l=new Os(s,r&&r.animations);return r&&r._cacheable&&(n[o]=Object.freeze(l)),l}getSharedOptions(t){if(t.$shared)return this._sharedOptions||(this._sharedOptions=Object.assign({},t))}includeOptions(t,e){return!e||Bs(t)||this.chart._animationsDisabled}_getSharedOptions(t,e){const i=this.resolveDataElementOptions(t,e),s=this._sharedOptions,n=this.getSharedOptions(i),o=this.includeOptions(e,n)||n!==s;return this.updateSharedOptions(n,e,i),{sharedOptions:n,includeOptions:o}}updateElement(t,e,i,s){Bs(s)?Object.assign(t,i):this._resolveAnimations(e,s).update(t,i)}updateSharedOptions(t,e,i){t&&!Bs(e)&&this._resolveAnimations(void 0,e).update(t,i)}_setStyle(t,e,i,s){t.active=s;const n=this.getStyle(e,s);this._resolveAnimations(e,i,s).update(t,{options:!s&&this.getSharedOptions(n)||n})}removeHoverStyle(t,e,i){this._setStyle(t,i,\"active\",!1)}setHoverStyle(t,e,i){this._setStyle(t,i,\"active\",!0)}_removeDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,\"active\",!1)}_setDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,\"active\",!0)}_resyncElements(t){const e=this._data,i=this._cachedMeta.data;for(const[t,e,i]of this._syncList)this[t](e,i);this._syncList=[];const s=i.length,n=e.length,o=Math.min(n,s);o&&this.parse(0,o),n>s?this._insertElements(s,n-s,t):n<s&&this._removeElements(n,s-n)}_insertElements(t,e,i=!0){const s=this._cachedMeta,n=s.data,o=t+e;let a;const r=t=>{for(t.length+=e,a=t.length-1;a>=o;a--)t[a]=t[a-e]};for(r(n),a=t;a<o;++a)n[a]=new this.dataElementType;this._parsing&&r(s._parsed),this.parse(t,e),i&&this.updateElements(n,t,e,\"reset\")}updateElements(t,e,i,s){}_removeElements(t,e){const i=this._cachedMeta;if(this._parsing){const s=i._parsed.splice(t,e);i._stacked&&Vs(i,s)}i.data.splice(t,e)}_sync(t){if(this._parsing)this._syncList.push(t);else{const[e,i,s]=t;this[e](i,s)}this.chart._dataChanges.push([this.index,...t])}_onDataPush(){const t=arguments.length;this._sync([\"_insertElements\",this.getDataset().data.length-t,t])}_onDataPop(){this._sync([\"_removeElements\",this._cachedMeta.data.length-1,1])}_onDataShift(){this._sync([\"_removeElements\",0,1])}_onDataSplice(t,e){e&&this._sync([\"_removeElements\",t,e]);const i=arguments.length-2;i&&this._sync([\"_insertElements\",t,i])}_onDataUnshift(){this._sync([\"_insertElements\",0,arguments.length])}}class Hs{static defaults={};static defaultRoutes=void 0;x;y;active=!1;options;$animations;tooltipPosition(t){const{x:e,y:i}=this.getProps([\"x\",\"y\"],t);return{x:e,y:i}}hasValue(){return N(this.x)&&N(this.y)}getProps(t,e){const i=this.$animations;if(!e||!i)return this;const s={};return t.forEach((t=>{s[t]=i[t]&&i[t].active()?i[t]._to:this[t]})),s}}function js(t,e){const i=t.options.ticks,n=function(t){const e=t.options.offset,i=t._tickSize(),s=t._length/i+(e?0:1),n=t._maxLength/i;return Math.floor(Math.min(s,n))}(t),o=Math.min(i.maxTicksLimit||n,n),a=i.major.enabled?function(t){const e=[];let i,s;for(i=0,s=t.length;i<s;i++)t[i].major&&e.push(i);return e}(e):[],r=a.length,l=a[0],h=a[r-1],c=[];if(r>o)return function(t,e,i,s){let n,o=0,a=i[0];for(s=Math.ceil(s),n=0;n<t.length;n++)n===a&&(e.push(t[n]),o++,a=i[o*s])}(e,c,a,r/o),c;const d=function(t,e,i){const s=function(t){const e=t.length;let i,s;if(e<2)return!1;for(s=t[0],i=1;i<e;++i)if(t[i]-t[i-1]!==s)return!1;return s}(t),n=e.length/i;if(!s)return Math.max(n,1);const o=W(s);for(let t=0,e=o.length-1;t<e;t++){const e=o[t];if(e>n)return e}return Math.max(n,1)}(a,e,o);if(r>0){let t,i;const n=r>1?Math.round((h-l)/(r-1)):null;for($s(e,c,d,s(n)?0:l-n,l),t=0,i=r-1;t<i;t++)$s(e,c,d,a[t],a[t+1]);return $s(e,c,d,h,s(n)?e.length:h+n),c}return $s(e,c,d),c}function $s(t,e,i,s,n){const o=l(s,0),a=Math.min(l(n,t.length),t.length);let r,h,c,d=0;for(i=Math.ceil(i),n&&(r=n-s,i=r/Math.floor(r/i)),c=o;c<0;)d++,c=Math.round(o+d*i);for(h=Math.max(o,0);h<a;h++)h===c&&(e.push(t[h]),d++,c=Math.round(o+d*i))}const Ys=(t,e,i)=>\"top\"===e||\"left\"===e?t[e]+i:t[e]-i,Us=(t,e)=>Math.min(e||t,t);function Xs(t,e){const i=[],s=t.length/e,n=t.length;let o=0;for(;o<n;o+=s)i.push(t[Math.floor(o)]);return i}function qs(t,e,i){const s=t.ticks.length,n=Math.min(e,s-1),o=t._startPixel,a=t._endPixel,r=1e-6;let l,h=t.getPixelForTick(n);if(!(i&&(l=1===s?Math.max(h-o,a-h):0===e?(t.getPixelForTick(1)-h)/2:(h-t.getPixelForTick(n-1))/2,h+=n<e?l:-l,h<o-r||h>a+r)))return h}function Ks(t){return t.drawTicks?t.tickLength:0}function Gs(t,e){if(!t.display)return 0;const i=Si(t.font,e),s=ki(t.padding);return(n(t.text)?t.text.length:1)*i.lineHeight+s.height}function Zs(t,e,i){let s=ut(t);return(i&&\"right\"!==e||!i&&\"right\"===e)&&(s=(t=>\"left\"===t?\"right\":\"right\"===t?\"left\":t)(s)),s}class Js extends Hs{constructor(t){super(),this.id=t.id,this.type=t.type,this.options=void 0,this.ctx=t.ctx,this.chart=t.chart,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this._margins={left:0,right:0,top:0,bottom:0},this.maxWidth=void 0,this.maxHeight=void 0,this.paddingTop=void 0,this.paddingBottom=void 0,this.paddingLeft=void 0,this.paddingRight=void 0,this.axis=void 0,this.labelRotation=void 0,this.min=void 0,this.max=void 0,this._range=void 0,this.ticks=[],this._gridLineItems=null,this._labelItems=null,this._labelSizes=null,this._length=0,this._maxLength=0,this._longestTextCache={},this._startPixel=void 0,this._endPixel=void 0,this._reversePixels=!1,this._userMax=void 0,this._userMin=void 0,this._suggestedMax=void 0,this._suggestedMin=void 0,this._ticksLength=0,this._borderValue=0,this._cache={},this._dataLimitsCached=!1,this.$context=void 0}init(t){this.options=t.setContext(this.getContext()),this.axis=t.axis,this._userMin=this.parse(t.min),this._userMax=this.parse(t.max),this._suggestedMin=this.parse(t.suggestedMin),this._suggestedMax=this.parse(t.suggestedMax)}parse(t,e){return t}getUserBounds(){let{_userMin:t,_userMax:e,_suggestedMin:i,_suggestedMax:s}=this;return t=r(t,Number.POSITIVE_INFINITY),e=r(e,Number.NEGATIVE_INFINITY),i=r(i,Number.POSITIVE_INFINITY),s=r(s,Number.NEGATIVE_INFINITY),{min:r(t,i),max:r(e,s),minDefined:a(t),maxDefined:a(e)}}getMinMax(t){let e,{min:i,max:s,minDefined:n,maxDefined:o}=this.getUserBounds();if(n&&o)return{min:i,max:s};const a=this.getMatchingVisibleMetas();for(let r=0,l=a.length;r<l;++r)e=a[r].controller.getMinMax(this,t),n||(i=Math.min(i,e.min)),o||(s=Math.max(s,e.max));return i=o&&i>s?s:i,s=n&&i>s?i:s,{min:r(i,r(s,i)),max:r(s,r(i,s))}}getPadding(){return{left:this.paddingLeft||0,top:this.paddingTop||0,right:this.paddingRight||0,bottom:this.paddingBottom||0}}getTicks(){return this.ticks}getLabels(){const t=this.chart.data;return this.options.labels||(this.isHorizontal()?t.xLabels:t.yLabels)||t.labels||[]}getLabelItems(t=this.chart.chartArea){return this._labelItems||(this._labelItems=this._computeLabelItems(t))}beforeLayout(){this._cache={},this._dataLimitsCached=!1}beforeUpdate(){d(this.options.beforeUpdate,[this])}update(t,e,i){const{beginAtZero:s,grace:n,ticks:o}=this.options,a=o.sampleSize;this.beforeUpdate(),this.maxWidth=t,this.maxHeight=e,this._margins=i=Object.assign({left:0,right:0,top:0,bottom:0},i),this.ticks=null,this._labelSizes=null,this._gridLineItems=null,this._labelItems=null,this.beforeSetDimensions(),this.setDimensions(),this.afterSetDimensions(),this._maxLength=this.isHorizontal()?this.width+i.left+i.right:this.height+i.top+i.bottom,this._dataLimitsCached||(this.beforeDataLimits(),this.determineDataLimits(),this.afterDataLimits(),this._range=Di(this,n,s),this._dataLimitsCached=!0),this.beforeBuildTicks(),this.ticks=this.buildTicks()||[],this.afterBuildTicks();const r=a<this.ticks.length;this._convertTicksToLabels(r?Xs(this.ticks,a):this.ticks),this.configure(),this.beforeCalculateLabelRotation(),this.calculateLabelRotation(),this.afterCalculateLabelRotation(),o.display&&(o.autoSkip||\"auto\"===o.source)&&(this.ticks=js(this,this.ticks),this._labelSizes=null,this.afterAutoSkip()),r&&this._convertTicksToLabels(this.ticks),this.beforeFit(),this.fit(),this.afterFit(),this.afterUpdate()}configure(){let t,e,i=this.options.reverse;this.isHorizontal()?(t=this.left,e=this.right):(t=this.top,e=this.bottom,i=!i),this._startPixel=t,this._endPixel=e,this._reversePixels=i,this._length=e-t,this._alignToPixels=this.options.alignToPixels}afterUpdate(){d(this.options.afterUpdate,[this])}beforeSetDimensions(){d(this.options.beforeSetDimensions,[this])}setDimensions(){this.isHorizontal()?(this.width=this.maxWidth,this.left=0,this.right=this.width):(this.height=this.maxHeight,this.top=0,this.bottom=this.height),this.paddingLeft=0,this.paddingTop=0,this.paddingRight=0,this.paddingBottom=0}afterSetDimensions(){d(this.options.afterSetDimensions,[this])}_callHooks(t){this.chart.notifyPlugins(t,this.getContext()),d(this.options[t],[this])}beforeDataLimits(){this._callHooks(\"beforeDataLimits\")}determineDataLimits(){}afterDataLimits(){this._callHooks(\"afterDataLimits\")}beforeBuildTicks(){this._callHooks(\"beforeBuildTicks\")}buildTicks(){return[]}afterBuildTicks(){this._callHooks(\"afterBuildTicks\")}beforeTickToLabelConversion(){d(this.options.beforeTickToLabelConversion,[this])}generateTickLabels(t){const e=this.options.ticks;let i,s,n;for(i=0,s=t.length;i<s;i++)n=t[i],n.label=d(e.callback,[n.value,i,t],this)}afterTickToLabelConversion(){d(this.options.afterTickToLabelConversion,[this])}beforeCalculateLabelRotation(){d(this.options.beforeCalculateLabelRotation,[this])}calculateLabelRotation(){const t=this.options,e=t.ticks,i=Us(this.ticks.length,t.ticks.maxTicksLimit),s=e.minRotation||0,n=e.maxRotation;let o,a,r,l=s;if(!this._isVisible()||!e.display||s>=n||i<=1||!this.isHorizontal())return void(this.labelRotation=s);const h=this._getLabelSizes(),c=h.widest.width,d=h.highest.height,u=J(this.chart.width-c,0,this.maxWidth);o=t.offset?this.maxWidth/i:u/(i-1),c+6>o&&(o=u/(i-(t.offset?.5:1)),a=this.maxHeight-Ks(t.grid)-e.padding-Gs(t.title,this.chart.options.font),r=Math.sqrt(c*c+d*d),l=Y(Math.min(Math.asin(J((h.highest.height+6)/o,-1,1)),Math.asin(J(a/r,-1,1))-Math.asin(J(d/r,-1,1)))),l=Math.max(s,Math.min(n,l))),this.labelRotation=l}afterCalculateLabelRotation(){d(this.options.afterCalculateLabelRotation,[this])}afterAutoSkip(){}beforeFit(){d(this.options.beforeFit,[this])}fit(){const t={width:0,height:0},{chart:e,options:{ticks:i,title:s,grid:n}}=this,o=this._isVisible(),a=this.isHorizontal();if(o){const o=Gs(s,e.options.font);if(a?(t.width=this.maxWidth,t.height=Ks(n)+o):(t.height=this.maxHeight,t.width=Ks(n)+o),i.display&&this.ticks.length){const{first:e,last:s,widest:n,highest:o}=this._getLabelSizes(),r=2*i.padding,l=$(this.labelRotation),h=Math.cos(l),c=Math.sin(l);if(a){const e=i.mirror?0:c*n.width+h*o.height;t.height=Math.min(this.maxHeight,t.height+e+r)}else{const e=i.mirror?0:h*n.width+c*o.height;t.width=Math.min(this.maxWidth,t.width+e+r)}this._calculatePadding(e,s,c,h)}}this._handleMargins(),a?(this.width=this._length=e.width-this._margins.left-this._margins.right,this.height=t.height):(this.width=t.width,this.height=this._length=e.height-this._margins.top-this._margins.bottom)}_calculatePadding(t,e,i,s){const{ticks:{align:n,padding:o},position:a}=this.options,r=0!==this.labelRotation,l=\"top\"!==a&&\"x\"===this.axis;if(this.isHorizontal()){const a=this.getPixelForTick(0)-this.left,h=this.right-this.getPixelForTick(this.ticks.length-1);let c=0,d=0;r?l?(c=s*t.width,d=i*e.height):(c=i*t.height,d=s*e.width):\"start\"===n?d=e.width:\"end\"===n?c=t.width:\"inner\"!==n&&(c=t.width/2,d=e.width/2),this.paddingLeft=Math.max((c-a+o)*this.width/(this.width-a),0),this.paddingRight=Math.max((d-h+o)*this.width/(this.width-h),0)}else{let i=e.height/2,s=t.height/2;\"start\"===n?(i=0,s=t.height):\"end\"===n&&(i=e.height,s=0),this.paddingTop=i+o,this.paddingBottom=s+o}}_handleMargins(){this._margins&&(this._margins.left=Math.max(this.paddingLeft,this._margins.left),this._margins.top=Math.max(this.paddingTop,this._margins.top),this._margins.right=Math.max(this.paddingRight,this._margins.right),this._margins.bottom=Math.max(this.paddingBottom,this._margins.bottom))}afterFit(){d(this.options.afterFit,[this])}isHorizontal(){const{axis:t,position:e}=this.options;return\"top\"===e||\"bottom\"===e||\"x\"===t}isFullSize(){return this.options.fullSize}_convertTicksToLabels(t){let e,i;for(this.beforeTickToLabelConversion(),this.generateTickLabels(t),e=0,i=t.length;e<i;e++)s(t[e].label)&&(t.splice(e,1),i--,e--);this.afterTickToLabelConversion()}_getLabelSizes(){let t=this._labelSizes;if(!t){const e=this.options.ticks.sampleSize;let i=this.ticks;e<i.length&&(i=Xs(i,e)),this._labelSizes=t=this._computeLabelSizes(i,i.length,this.options.ticks.maxTicksLimit)}return t}_computeLabelSizes(t,e,i){const{ctx:o,_longestTextCache:a}=this,r=[],l=[],h=Math.floor(e/Us(e,i));let c,d,f,g,p,m,b,x,_,y,v,M=0,w=0;for(c=0;c<e;c+=h){if(g=t[c].label,p=this._resolveTickFontOptions(c),o.font=m=p.string,b=a[m]=a[m]||{data:{},gc:[]},x=p.lineHeight,_=y=0,s(g)||n(g)){if(n(g))for(d=0,f=g.length;d<f;++d)v=g[d],s(v)||n(v)||(_=Ce(o,b.data,b.gc,_,v),y+=x)}else _=Ce(o,b.data,b.gc,_,g),y=x;r.push(_),l.push(y),M=Math.max(_,M),w=Math.max(y,w)}!function(t,e){u(t,(t=>{const i=t.gc,s=i.length/2;let n;if(s>e){for(n=0;n<s;++n)delete t.data[i[n]];i.splice(0,s)}}))}(a,e);const k=r.indexOf(M),S=l.indexOf(w),P=t=>({width:r[t]||0,height:l[t]||0});return{first:P(0),last:P(e-1),widest:P(k),highest:P(S),widths:r,heights:l}}getLabelForValue(t){return t}getPixelForValue(t,e){return NaN}getValueForPixel(t){}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getPixelForDecimal(t){this._reversePixels&&(t=1-t);const e=this._startPixel+t*this._length;return Q(this._alignToPixels?Ae(this.chart,e,0):e)}getDecimalForPixel(t){const e=(t-this._startPixel)/this._length;return this._reversePixels?1-e:e}getBasePixel(){return this.getPixelForValue(this.getBaseValue())}getBaseValue(){const{min:t,max:e}=this;return t<0&&e<0?e:t>0&&e>0?t:0}getContext(t){const e=this.ticks||[];if(t>=0&&t<e.length){const i=e[t];return i.$context||(i.$context=function(t,e,i){return Ci(t,{tick:i,index:e,type:\"tick\"})}(this.getContext(),t,i))}return this.$context||(this.$context=Ci(this.chart.getContext(),{scale:this,type:\"scale\"}))}_tickSize(){const t=this.options.ticks,e=$(this.labelRotation),i=Math.abs(Math.cos(e)),s=Math.abs(Math.sin(e)),n=this._getLabelSizes(),o=t.autoSkipPadding||0,a=n?n.widest.width+o:0,r=n?n.highest.height+o:0;return this.isHorizontal()?r*i>a*s?a/i:r/s:r*s<a*i?r/i:a/s}_isVisible(){const t=this.options.display;return\"auto\"!==t?!!t:this.getMatchingVisibleMetas().length>0}_computeGridLineItems(t){const e=this.axis,i=this.chart,s=this.options,{grid:n,position:a,border:r}=s,h=n.offset,c=this.isHorizontal(),d=this.ticks.length+(h?1:0),u=Ks(n),f=[],g=r.setContext(this.getContext()),p=g.display?g.width:0,m=p/2,b=function(t){return Ae(i,t,p)};let x,_,y,v,M,w,k,S,P,D,C,O;if(\"top\"===a)x=b(this.bottom),w=this.bottom-u,S=x-m,D=b(t.top)+m,O=t.bottom;else if(\"bottom\"===a)x=b(this.top),D=t.top,O=b(t.bottom)-m,w=x+m,S=this.top+u;else if(\"left\"===a)x=b(this.right),M=this.right-u,k=x-m,P=b(t.left)+m,C=t.right;else if(\"right\"===a)x=b(this.left),P=t.left,C=b(t.right)-m,M=x+m,k=this.left+u;else if(\"x\"===e){if(\"center\"===a)x=b((t.top+t.bottom)/2+.5);else if(o(a)){const t=Object.keys(a)[0],e=a[t];x=b(this.chart.scales[t].getPixelForValue(e))}D=t.top,O=t.bottom,w=x+m,S=w+u}else if(\"y\"===e){if(\"center\"===a)x=b((t.left+t.right)/2);else if(o(a)){const t=Object.keys(a)[0],e=a[t];x=b(this.chart.scales[t].getPixelForValue(e))}M=x-m,k=M-u,P=t.left,C=t.right}const A=l(s.ticks.maxTicksLimit,d),T=Math.max(1,Math.ceil(d/A));for(_=0;_<d;_+=T){const t=this.getContext(_),e=n.setContext(t),s=r.setContext(t),o=e.lineWidth,a=e.color,l=s.dash||[],d=s.dashOffset,u=e.tickWidth,g=e.tickColor,p=e.tickBorderDash||[],m=e.tickBorderDashOffset;y=qs(this,_,h),void 0!==y&&(v=Ae(i,y,o),c?M=k=P=C=v:w=S=D=O=v,f.push({tx1:M,ty1:w,tx2:k,ty2:S,x1:P,y1:D,x2:C,y2:O,width:o,color:a,borderDash:l,borderDashOffset:d,tickWidth:u,tickColor:g,tickBorderDash:p,tickBorderDashOffset:m}))}return this._ticksLength=d,this._borderValue=x,f}_computeLabelItems(t){const e=this.axis,i=this.options,{position:s,ticks:a}=i,r=this.isHorizontal(),l=this.ticks,{align:h,crossAlign:c,padding:d,mirror:u}=a,f=Ks(i.grid),g=f+d,p=u?-d:g,m=-$(this.labelRotation),b=[];let x,_,y,v,M,w,k,S,P,D,C,O,A=\"middle\";if(\"top\"===s)w=this.bottom-p,k=this._getXAxisLabelAlignment();else if(\"bottom\"===s)w=this.top+p,k=this._getXAxisLabelAlignment();else if(\"left\"===s){const t=this._getYAxisLabelAlignment(f);k=t.textAlign,M=t.x}else if(\"right\"===s){const t=this._getYAxisLabelAlignment(f);k=t.textAlign,M=t.x}else if(\"x\"===e){if(\"center\"===s)w=(t.top+t.bottom)/2+g;else if(o(s)){const t=Object.keys(s)[0],e=s[t];w=this.chart.scales[t].getPixelForValue(e)+g}k=this._getXAxisLabelAlignment()}else if(\"y\"===e){if(\"center\"===s)M=(t.left+t.right)/2-g;else if(o(s)){const t=Object.keys(s)[0],e=s[t];M=this.chart.scales[t].getPixelForValue(e)}k=this._getYAxisLabelAlignment(f).textAlign}\"y\"===e&&(\"start\"===h?A=\"top\":\"end\"===h&&(A=\"bottom\"));const T=this._getLabelSizes();for(x=0,_=l.length;x<_;++x){y=l[x],v=y.label;const t=a.setContext(this.getContext(x));S=this.getPixelForTick(x)+a.labelOffset,P=this._resolveTickFontOptions(x),D=P.lineHeight,C=n(v)?v.length:1;const e=C/2,i=t.color,o=t.textStrokeColor,h=t.textStrokeWidth;let d,f=k;if(r?(M=S,\"inner\"===k&&(f=x===_-1?this.options.reverse?\"left\":\"right\":0===x?this.options.reverse?\"right\":\"left\":\"center\"),O=\"top\"===s?\"near\"===c||0!==m?-C*D+D/2:\"center\"===c?-T.highest.height/2-e*D+D:-T.highest.height+D/2:\"near\"===c||0!==m?D/2:\"center\"===c?T.highest.height/2-e*D:T.highest.height-C*D,u&&(O*=-1),0===m||t.showLabelBackdrop||(M+=D/2*Math.sin(m))):(w=S,O=(1-C)*D/2),t.showLabelBackdrop){const e=ki(t.backdropPadding),i=T.heights[x],s=T.widths[x];let n=O-e.top,o=0-e.left;switch(A){case\"middle\":n-=i/2;break;case\"bottom\":n-=i}switch(k){case\"center\":o-=s/2;break;case\"right\":o-=s}d={left:o,top:n,width:s+e.width,height:i+e.height,color:t.backdropColor}}b.push({label:v,font:P,textOffset:O,options:{rotation:m,color:i,strokeColor:o,strokeWidth:h,textAlign:f,textBaseline:A,translation:[M,w],backdrop:d}})}return b}_getXAxisLabelAlignment(){const{position:t,ticks:e}=this.options;if(-$(this.labelRotation))return\"top\"===t?\"left\":\"right\";let i=\"center\";return\"start\"===e.align?i=\"left\":\"end\"===e.align?i=\"right\":\"inner\"===e.align&&(i=\"inner\"),i}_getYAxisLabelAlignment(t){const{position:e,ticks:{crossAlign:i,mirror:s,padding:n}}=this.options,o=t+n,a=this._getLabelSizes().widest.width;let r,l;return\"left\"===e?s?(l=this.right+n,\"near\"===i?r=\"left\":\"center\"===i?(r=\"center\",l+=a/2):(r=\"right\",l+=a)):(l=this.right-o,\"near\"===i?r=\"right\":\"center\"===i?(r=\"center\",l-=a/2):(r=\"left\",l=this.left)):\"right\"===e?s?(l=this.left+n,\"near\"===i?r=\"right\":\"center\"===i?(r=\"center\",l-=a/2):(r=\"left\",l-=a)):(l=this.left+o,\"near\"===i?r=\"left\":\"center\"===i?(r=\"center\",l+=a/2):(r=\"right\",l=this.right)):r=\"right\",{textAlign:r,x:l}}_computeLabelArea(){if(this.options.ticks.mirror)return;const t=this.chart,e=this.options.position;return\"left\"===e||\"right\"===e?{top:0,left:this.left,bottom:t.height,right:this.right}:\"top\"===e||\"bottom\"===e?{top:this.top,left:0,bottom:this.bottom,right:t.width}:void 0}drawBackground(){const{ctx:t,options:{backgroundColor:e},left:i,top:s,width:n,height:o}=this;e&&(t.save(),t.fillStyle=e,t.fillRect(i,s,n,o),t.restore())}getLineWidthForValue(t){const e=this.options.grid;if(!this._isVisible()||!e.display)return 0;const i=this.ticks.findIndex((e=>e.value===t));if(i>=0){return e.setContext(this.getContext(i)).lineWidth}return 0}drawGrid(t){const e=this.options.grid,i=this.ctx,s=this._gridLineItems||(this._gridLineItems=this._computeGridLineItems(t));let n,o;const a=(t,e,s)=>{s.width&&s.color&&(i.save(),i.lineWidth=s.width,i.strokeStyle=s.color,i.setLineDash(s.borderDash||[]),i.lineDashOffset=s.borderDashOffset,i.beginPath(),i.moveTo(t.x,t.y),i.lineTo(e.x,e.y),i.stroke(),i.restore())};if(e.display)for(n=0,o=s.length;n<o;++n){const t=s[n];e.drawOnChartArea&&a({x:t.x1,y:t.y1},{x:t.x2,y:t.y2},t),e.drawTicks&&a({x:t.tx1,y:t.ty1},{x:t.tx2,y:t.ty2},{color:t.tickColor,width:t.tickWidth,borderDash:t.tickBorderDash,borderDashOffset:t.tickBorderDashOffset})}}drawBorder(){const{chart:t,ctx:e,options:{border:i,grid:s}}=this,n=i.setContext(this.getContext()),o=i.display?n.width:0;if(!o)return;const a=s.setContext(this.getContext(0)).lineWidth,r=this._borderValue;let l,h,c,d;this.isHorizontal()?(l=Ae(t,this.left,o)-o/2,h=Ae(t,this.right,a)+a/2,c=d=r):(c=Ae(t,this.top,o)-o/2,d=Ae(t,this.bottom,a)+a/2,l=h=r),e.save(),e.lineWidth=n.width,e.strokeStyle=n.color,e.beginPath(),e.moveTo(l,c),e.lineTo(h,d),e.stroke(),e.restore()}drawLabels(t){if(!this.options.ticks.display)return;const e=this.ctx,i=this._computeLabelArea();i&&Ie(e,i);const s=this.getLabelItems(t);for(const t of s){const i=t.options,s=t.font;Ne(e,t.label,0,t.textOffset,s,i)}i&&ze(e)}drawTitle(){const{ctx:t,options:{position:e,title:i,reverse:s}}=this;if(!i.display)return;const a=Si(i.font),r=ki(i.padding),l=i.align;let h=a.lineHeight/2;\"bottom\"===e||\"center\"===e||o(e)?(h+=r.bottom,n(i.text)&&(h+=a.lineHeight*(i.text.length-1))):h+=r.top;const{titleX:c,titleY:d,maxWidth:u,rotation:f}=function(t,e,i,s){const{top:n,left:a,bottom:r,right:l,chart:h}=t,{chartArea:c,scales:d}=h;let u,f,g,p=0;const m=r-n,b=l-a;if(t.isHorizontal()){if(f=ft(s,a,l),o(i)){const t=Object.keys(i)[0],s=i[t];g=d[t].getPixelForValue(s)+m-e}else g=\"center\"===i?(c.bottom+c.top)/2+m-e:Ys(t,i,e);u=l-a}else{if(o(i)){const t=Object.keys(i)[0],s=i[t];f=d[t].getPixelForValue(s)-b+e}else f=\"center\"===i?(c.left+c.right)/2-b+e:Ys(t,i,e);g=ft(s,r,n),p=\"left\"===i?-E:E}return{titleX:f,titleY:g,maxWidth:u,rotation:p}}(this,h,e,l);Ne(t,i.text,0,0,a,{color:i.color,maxWidth:u,rotation:f,textAlign:Zs(l,e,s),textBaseline:\"middle\",translation:[c,d]})}draw(t){this._isVisible()&&(this.drawBackground(),this.drawGrid(t),this.drawBorder(),this.drawTitle(),this.drawLabels(t))}_layers(){const t=this.options,e=t.ticks&&t.ticks.z||0,i=l(t.grid&&t.grid.z,-1),s=l(t.border&&t.border.z,0);return this._isVisible()&&this.draw===Js.prototype.draw?[{z:i,draw:t=>{this.drawBackground(),this.drawGrid(t),this.drawTitle()}},{z:s,draw:()=>{this.drawBorder()}},{z:e,draw:t=>{this.drawLabels(t)}}]:[{z:e,draw:t=>{this.draw(t)}}]}getMatchingVisibleMetas(t){const e=this.chart.getSortedVisibleDatasetMetas(),i=this.axis+\"AxisID\",s=[];let n,o;for(n=0,o=e.length;n<o;++n){const o=e[n];o[i]!==this.id||t&&o.type!==t||s.push(o)}return s}_resolveTickFontOptions(t){return Si(this.options.ticks.setContext(this.getContext(t)).font)}_maxDigits(){const t=this._resolveTickFontOptions(0).lineHeight;return(this.isHorizontal()?this.width:this.height)/t}}class Qs{constructor(t,e,i){this.type=t,this.scope=e,this.override=i,this.items=Object.create(null)}isForType(t){return Object.prototype.isPrototypeOf.call(this.type.prototype,t.prototype)}register(t){const e=Object.getPrototypeOf(t);let i;(function(t){return\"id\"in t&&\"defaults\"in t})(e)&&(i=this.register(e));const s=this.items,n=t.id,o=this.scope+\".\"+n;if(!n)throw new Error(\"class does not have id: \"+t);return n in s||(s[n]=t,function(t,e,i){const s=b(Object.create(null),[i?ue.get(i):{},ue.get(e),t.defaults]);ue.set(e,s),t.defaultRoutes&&function(t,e){Object.keys(e).forEach((i=>{const s=i.split(\".\"),n=s.pop(),o=[t].concat(s).join(\".\"),a=e[i].split(\".\"),r=a.pop(),l=a.join(\".\");ue.route(o,n,l,r)}))}(e,t.defaultRoutes);t.descriptors&&ue.describe(e,t.descriptors)}(t,o,i),this.override&&ue.override(t.id,t.overrides)),o}get(t){return this.items[t]}unregister(t){const e=this.items,i=t.id,s=this.scope;i in e&&delete e[i],s&&i in ue[s]&&(delete ue[s][i],this.override&&delete re[i])}}class tn{constructor(){this.controllers=new Qs(Ns,\"datasets\",!0),this.elements=new Qs(Hs,\"elements\"),this.plugins=new Qs(Object,\"plugins\"),this.scales=new Qs(Js,\"scales\"),this._typedRegistries=[this.controllers,this.scales,this.elements]}add(...t){this._each(\"register\",t)}remove(...t){this._each(\"unregister\",t)}addControllers(...t){this._each(\"register\",t,this.controllers)}addElements(...t){this._each(\"register\",t,this.elements)}addPlugins(...t){this._each(\"register\",t,this.plugins)}addScales(...t){this._each(\"register\",t,this.scales)}getController(t){return this._get(t,this.controllers,\"controller\")}getElement(t){return this._get(t,this.elements,\"element\")}getPlugin(t){return this._get(t,this.plugins,\"plugin\")}getScale(t){return this._get(t,this.scales,\"scale\")}removeControllers(...t){this._each(\"unregister\",t,this.controllers)}removeElements(...t){this._each(\"unregister\",t,this.elements)}removePlugins(...t){this._each(\"unregister\",t,this.plugins)}removeScales(...t){this._each(\"unregister\",t,this.scales)}_each(t,e,i){[...e].forEach((e=>{const s=i||this._getRegistryForType(e);i||s.isForType(e)||s===this.plugins&&e.id?this._exec(t,s,e):u(e,(e=>{const s=i||this._getRegistryForType(e);this._exec(t,s,e)}))}))}_exec(t,e,i){const s=w(t);d(i[\"before\"+s],[],i),e[t](i),d(i[\"after\"+s],[],i)}_getRegistryForType(t){for(let e=0;e<this._typedRegistries.length;e++){const i=this._typedRegistries[e];if(i.isForType(t))return i}return this.plugins}_get(t,e,i){const s=e.get(t);if(void 0===s)throw new Error('\"'+t+'\" is not a registered '+i+\".\");return s}}var en=new tn;class sn{constructor(){this._init=[]}notify(t,e,i,s){\"beforeInit\"===e&&(this._init=this._createDescriptors(t,!0),this._notify(this._init,t,\"install\"));const n=s?this._descriptors(t).filter(s):this._descriptors(t),o=this._notify(n,t,e,i);return\"afterDestroy\"===e&&(this._notify(n,t,\"stop\"),this._notify(this._init,t,\"uninstall\")),o}_notify(t,e,i,s){s=s||{};for(const n of t){const t=n.plugin;if(!1===d(t[i],[e,s,n.options],t)&&s.cancelable)return!1}return!0}invalidate(){s(this._cache)||(this._oldCache=this._cache,this._cache=void 0)}_descriptors(t){if(this._cache)return this._cache;const e=this._cache=this._createDescriptors(t);return this._notifyStateChanges(t),e}_createDescriptors(t,e){const i=t&&t.config,s=l(i.options&&i.options.plugins,{}),n=function(t){const e={},i=[],s=Object.keys(en.plugins.items);for(let t=0;t<s.length;t++)i.push(en.getPlugin(s[t]));const n=t.plugins||[];for(let t=0;t<n.length;t++){const s=n[t];-1===i.indexOf(s)&&(i.push(s),e[s.id]=!0)}return{plugins:i,localIds:e}}(i);return!1!==s||e?function(t,{plugins:e,localIds:i},s,n){const o=[],a=t.getContext();for(const r of e){const e=r.id,l=nn(s[e],n);null!==l&&o.push({plugin:r,options:on(t.config,{plugin:r,local:i[e]},l,a)})}return o}(t,n,s,e):[]}_notifyStateChanges(t){const e=this._oldCache||[],i=this._cache,s=(t,e)=>t.filter((t=>!e.some((e=>t.plugin.id===e.plugin.id))));this._notify(s(e,i),t,\"stop\"),this._notify(s(i,e),t,\"start\")}}function nn(t,e){return e||!1!==t?!0===t?{}:t:null}function on(t,{plugin:e,local:i},s,n){const o=t.pluginScopeKeys(e),a=t.getOptionScopes(s,o);return i&&e.defaults&&a.push(e.defaults),t.createResolver(a,n,[\"\"],{scriptable:!1,indexable:!1,allKeys:!0})}function an(t,e){const i=ue.datasets[t]||{};return((e.datasets||{})[t]||{}).indexAxis||e.indexAxis||i.indexAxis||\"x\"}function rn(t){if(\"x\"===t||\"y\"===t||\"r\"===t)return t}function ln(t,...e){if(rn(t))return t;for(const s of e){const e=s.axis||(\"top\"===(i=s.position)||\"bottom\"===i?\"x\":\"left\"===i||\"right\"===i?\"y\":void 0)||t.length>1&&rn(t[0].toLowerCase());if(e)return e}var i;throw new Error(`Cannot determine type of '${t}' axis. Please provide 'axis' or 'position' option.`)}function hn(t,e,i){if(i[e+\"AxisID\"]===t)return{axis:e}}function cn(t,e){const i=re[t.type]||{scales:{}},s=e.scales||{},n=an(t.type,e),a=Object.create(null);return Object.keys(s).forEach((e=>{const r=s[e];if(!o(r))return console.error(`Invalid scale configuration for scale: ${e}`);if(r._proxy)return console.warn(`Ignoring resolver passed as options for scale: ${e}`);const l=ln(e,r,function(t,e){if(e.data&&e.data.datasets){const i=e.data.datasets.filter((e=>e.xAxisID===t||e.yAxisID===t));if(i.length)return hn(t,\"x\",i[0])||hn(t,\"y\",i[0])}return{}}(e,t),ue.scales[r.type]),h=function(t,e){return t===e?\"_index_\":\"_value_\"}(l,n),c=i.scales||{};a[e]=x(Object.create(null),[{axis:l},r,c[l],c[h]])})),t.data.datasets.forEach((i=>{const n=i.type||t.type,o=i.indexAxis||an(n,e),r=(re[n]||{}).scales||{};Object.keys(r).forEach((t=>{const e=function(t,e){let i=t;return\"_index_\"===t?i=e:\"_value_\"===t&&(i=\"x\"===e?\"y\":\"x\"),i}(t,o),n=i[e+\"AxisID\"]||e;a[n]=a[n]||Object.create(null),x(a[n],[{axis:e},s[n],r[t]])}))})),Object.keys(a).forEach((t=>{const e=a[t];x(e,[ue.scales[e.type],ue.scale])})),a}function dn(t){const e=t.options||(t.options={});e.plugins=l(e.plugins,{}),e.scales=cn(t,e)}function un(t){return(t=t||{}).datasets=t.datasets||[],t.labels=t.labels||[],t}const fn=new Map,gn=new Set;function pn(t,e){let i=fn.get(t);return i||(i=e(),fn.set(t,i),gn.add(i)),i}const mn=(t,e,i)=>{const s=M(e,i);void 0!==s&&t.add(s)};class bn{constructor(t){this._config=function(t){return(t=t||{}).data=un(t.data),dn(t),t}(t),this._scopeCache=new Map,this._resolverCache=new Map}get platform(){return this._config.platform}get type(){return this._config.type}set type(t){this._config.type=t}get data(){return this._config.data}set data(t){this._config.data=un(t)}get options(){return this._config.options}set options(t){this._config.options=t}get plugins(){return this._config.plugins}update(){const t=this._config;this.clearCache(),dn(t)}clearCache(){this._scopeCache.clear(),this._resolverCache.clear()}datasetScopeKeys(t){return pn(t,(()=>[[`datasets.${t}`,\"\"]]))}datasetAnimationScopeKeys(t,e){return pn(`${t}.transition.${e}`,(()=>[[`datasets.${t}.transitions.${e}`,`transitions.${e}`],[`datasets.${t}`,\"\"]]))}datasetElementScopeKeys(t,e){return pn(`${t}-${e}`,(()=>[[`datasets.${t}.elements.${e}`,`datasets.${t}`,`elements.${e}`,\"\"]]))}pluginScopeKeys(t){const e=t.id;return pn(`${this.type}-plugin-${e}`,(()=>[[`plugins.${e}`,...t.additionalOptionScopes||[]]]))}_cachedScopes(t,e){const i=this._scopeCache;let s=i.get(t);return s&&!e||(s=new Map,i.set(t,s)),s}getOptionScopes(t,e,i){const{options:s,type:n}=this,o=this._cachedScopes(t,i),a=o.get(e);if(a)return a;const r=new Set;e.forEach((e=>{t&&(r.add(t),e.forEach((e=>mn(r,t,e)))),e.forEach((t=>mn(r,s,t))),e.forEach((t=>mn(r,re[n]||{},t))),e.forEach((t=>mn(r,ue,t))),e.forEach((t=>mn(r,le,t)))}));const l=Array.from(r);return 0===l.length&&l.push(Object.create(null)),gn.has(e)&&o.set(e,l),l}chartOptionScopes(){const{options:t,type:e}=this;return[t,re[e]||{},ue.datasets[e]||{},{type:e},ue,le]}resolveNamedOptions(t,e,i,s=[\"\"]){const o={$shared:!0},{resolver:a,subPrefixes:r}=xn(this._resolverCache,t,s);let l=a;if(function(t,e){const{isScriptable:i,isIndexable:s}=Ye(t);for(const o of e){const e=i(o),a=s(o),r=(a||e)&&t[o];if(e&&(S(r)||_n(r))||a&&n(r))return!0}return!1}(a,e)){o.$shared=!1;l=$e(a,i=S(i)?i():i,this.createResolver(t,i,r))}for(const t of e)o[t]=l[t];return o}createResolver(t,e,i=[\"\"],s){const{resolver:n}=xn(this._resolverCache,t,i);return o(e)?$e(n,e,void 0,s):n}}function xn(t,e,i){let s=t.get(e);s||(s=new Map,t.set(e,s));const n=i.join();let o=s.get(n);if(!o){o={resolver:je(e,i),subPrefixes:i.filter((t=>!t.toLowerCase().includes(\"hover\")))},s.set(n,o)}return o}const _n=t=>o(t)&&Object.getOwnPropertyNames(t).reduce(((e,i)=>e||S(t[i])),!1);const yn=[\"top\",\"bottom\",\"left\",\"right\",\"chartArea\"];function vn(t,e){return\"top\"===t||\"bottom\"===t||-1===yn.indexOf(t)&&\"x\"===e}function Mn(t,e){return function(i,s){return i[t]===s[t]?i[e]-s[e]:i[t]-s[t]}}function wn(t){const e=t.chart,i=e.options.animation;e.notifyPlugins(\"afterRender\"),d(i&&i.onComplete,[t],e)}function kn(t){const e=t.chart,i=e.options.animation;d(i&&i.onProgress,[t],e)}function Sn(t){return fe()&&\"string\"==typeof t?t=document.getElementById(t):t&&t.length&&(t=t[0]),t&&t.canvas&&(t=t.canvas),t}const Pn={},Dn=t=>{const e=Sn(t);return Object.values(Pn).filter((t=>t.canvas===e)).pop()};function Cn(t,e,i){const s=Object.keys(t);for(const n of s){const s=+n;if(s>=e){const o=t[n];delete t[n],(i>0||s>e)&&(t[s+i]=o)}}}function On(t,e,i){return t.options.clip?t[i]:e[i]}class An{static defaults=ue;static instances=Pn;static overrides=re;static registry=en;static version=\"4.4.0\";static getChart=Dn;static register(...t){en.add(...t),Tn()}static unregister(...t){en.remove(...t),Tn()}constructor(t,e){const s=this.config=new bn(e),n=Sn(t),o=Dn(n);if(o)throw new Error(\"Canvas is already in use. Chart with ID '\"+o.id+\"' must be destroyed before the canvas with ID '\"+o.canvas.id+\"' can be reused.\");const a=s.createResolver(s.chartOptionScopes(),this.getContext());this.platform=new(s.platform||ks(n)),this.platform.updateConfig(s);const r=this.platform.acquireContext(n,a.aspectRatio),l=r&&r.canvas,h=l&&l.height,c=l&&l.width;this.id=i(),this.ctx=r,this.canvas=l,this.width=c,this.height=h,this._options=a,this._aspectRatio=this.aspectRatio,this._layers=[],this._metasets=[],this._stacks=void 0,this.boxes=[],this.currentDevicePixelRatio=void 0,this.chartArea=void 0,this._active=[],this._lastEvent=void 0,this._listeners={},this._responsiveListeners=void 0,this._sortedMetasets=[],this.scales={},this._plugins=new sn,this.$proxies={},this._hiddenIndices={},this.attached=!1,this._animationsDisabled=void 0,this.$context=void 0,this._doResize=dt((t=>this.update(t)),a.resizeDelay||0),this._dataChanges=[],Pn[this.id]=this,r&&l?(xt.listen(this,\"complete\",wn),xt.listen(this,\"progress\",kn),this._initialize(),this.attached&&this.update()):console.error(\"Failed to create chart: can't acquire context from the given item\")}get aspectRatio(){const{options:{aspectRatio:t,maintainAspectRatio:e},width:i,height:n,_aspectRatio:o}=this;return s(t)?e&&o?o:n?i/n:null:t}get data(){return this.config.data}set data(t){this.config.data=t}get options(){return this._options}set options(t){this.config.options=t}get registry(){return en}_initialize(){return this.notifyPlugins(\"beforeInit\"),this.options.responsive?this.resize():ke(this,this.options.devicePixelRatio),this.bindEvents(),this.notifyPlugins(\"afterInit\"),this}clear(){return Te(this.canvas,this.ctx),this}stop(){return xt.stop(this),this}resize(t,e){xt.running(this)?this._resizeBeforeDraw={width:t,height:e}:this._resize(t,e)}_resize(t,e){const i=this.options,s=this.canvas,n=i.maintainAspectRatio&&this.aspectRatio,o=this.platform.getMaximumSize(s,t,e,n),a=i.devicePixelRatio||this.platform.getDevicePixelRatio(),r=this.width?\"resize\":\"attach\";this.width=o.width,this.height=o.height,this._aspectRatio=this.aspectRatio,ke(this,a,!0)&&(this.notifyPlugins(\"resize\",{size:o}),d(i.onResize,[this,o],this),this.attached&&this._doResize(r)&&this.render())}ensureScalesHaveIDs(){u(this.options.scales||{},((t,e)=>{t.id=e}))}buildOrUpdateScales(){const t=this.options,e=t.scales,i=this.scales,s=Object.keys(i).reduce(((t,e)=>(t[e]=!1,t)),{});let n=[];e&&(n=n.concat(Object.keys(e).map((t=>{const i=e[t],s=ln(t,i),n=\"r\"===s,o=\"x\"===s;return{options:i,dposition:n?\"chartArea\":o?\"bottom\":\"left\",dtype:n?\"radialLinear\":o?\"category\":\"linear\"}})))),u(n,(e=>{const n=e.options,o=n.id,a=ln(o,n),r=l(n.type,e.dtype);void 0!==n.position&&vn(n.position,a)===vn(e.dposition)||(n.position=e.dposition),s[o]=!0;let h=null;if(o in i&&i[o].type===r)h=i[o];else{h=new(en.getScale(r))({id:o,type:r,ctx:this.ctx,chart:this}),i[h.id]=h}h.init(n,t)})),u(s,((t,e)=>{t||delete i[e]})),u(i,(t=>{as.configure(this,t,t.options),as.addBox(this,t)}))}_updateMetasets(){const t=this._metasets,e=this.data.datasets.length,i=t.length;if(t.sort(((t,e)=>t.index-e.index)),i>e){for(let t=e;t<i;++t)this._destroyDatasetMeta(t);t.splice(e,i-e)}this._sortedMetasets=t.slice(0).sort(Mn(\"order\",\"index\"))}_removeUnreferencedMetasets(){const{_metasets:t,data:{datasets:e}}=this;t.length>e.length&&delete this._stacks,t.forEach(((t,i)=>{0===e.filter((e=>e===t._dataset)).length&&this._destroyDatasetMeta(i)}))}buildOrUpdateControllers(){const t=[],e=this.data.datasets;let i,s;for(this._removeUnreferencedMetasets(),i=0,s=e.length;i<s;i++){const s=e[i];let n=this.getDatasetMeta(i);const o=s.type||this.config.type;if(n.type&&n.type!==o&&(this._destroyDatasetMeta(i),n=this.getDatasetMeta(i)),n.type=o,n.indexAxis=s.indexAxis||an(o,this.options),n.order=s.order||0,n.index=i,n.label=\"\"+s.label,n.visible=this.isDatasetVisible(i),n.controller)n.controller.updateIndex(i),n.controller.linkScales();else{const e=en.getController(o),{datasetElementType:s,dataElementType:a}=ue.datasets[o];Object.assign(e,{dataElementType:en.getElement(a),datasetElementType:s&&en.getElement(s)}),n.controller=new e(this,i),t.push(n.controller)}}return this._updateMetasets(),t}_resetElements(){u(this.data.datasets,((t,e)=>{this.getDatasetMeta(e).controller.reset()}),this)}reset(){this._resetElements(),this.notifyPlugins(\"reset\")}update(t){const e=this.config;e.update();const i=this._options=e.createResolver(e.chartOptionScopes(),this.getContext()),s=this._animationsDisabled=!i.animation;if(this._updateScales(),this._checkEventBindings(),this._updateHiddenIndices(),this._plugins.invalidate(),!1===this.notifyPlugins(\"beforeUpdate\",{mode:t,cancelable:!0}))return;const n=this.buildOrUpdateControllers();this.notifyPlugins(\"beforeElementsUpdate\");let o=0;for(let t=0,e=this.data.datasets.length;t<e;t++){const{controller:e}=this.getDatasetMeta(t),i=!s&&-1===n.indexOf(e);e.buildOrUpdateElements(i),o=Math.max(+e.getMaxOverflow(),o)}o=this._minPadding=i.layout.autoPadding?o:0,this._updateLayout(o),s||u(n,(t=>{t.reset()})),this._updateDatasets(t),this.notifyPlugins(\"afterUpdate\",{mode:t}),this._layers.sort(Mn(\"z\",\"_idx\"));const{_active:a,_lastEvent:r}=this;r?this._eventHandler(r,!0):a.length&&this._updateHoverStyles(a,a,!0),this.render()}_updateScales(){u(this.scales,(t=>{as.removeBox(this,t)})),this.ensureScalesHaveIDs(),this.buildOrUpdateScales()}_checkEventBindings(){const t=this.options,e=new Set(Object.keys(this._listeners)),i=new Set(t.events);P(e,i)&&!!this._responsiveListeners===t.responsive||(this.unbindEvents(),this.bindEvents())}_updateHiddenIndices(){const{_hiddenIndices:t}=this,e=this._getUniformDataChanges()||[];for(const{method:i,start:s,count:n}of e){Cn(t,s,\"_removeElements\"===i?-n:n)}}_getUniformDataChanges(){const t=this._dataChanges;if(!t||!t.length)return;this._dataChanges=[];const e=this.data.datasets.length,i=e=>new Set(t.filter((t=>t[0]===e)).map(((t,e)=>e+\",\"+t.splice(1).join(\",\")))),s=i(0);for(let t=1;t<e;t++)if(!P(s,i(t)))return;return Array.from(s).map((t=>t.split(\",\"))).map((t=>({method:t[1],start:+t[2],count:+t[3]})))}_updateLayout(t){if(!1===this.notifyPlugins(\"beforeLayout\",{cancelable:!0}))return;as.update(this,this.width,this.height,t);const e=this.chartArea,i=e.width<=0||e.height<=0;this._layers=[],u(this.boxes,(t=>{i&&\"chartArea\"===t.position||(t.configure&&t.configure(),this._layers.push(...t._layers()))}),this),this._layers.forEach(((t,e)=>{t._idx=e})),this.notifyPlugins(\"afterLayout\")}_updateDatasets(t){if(!1!==this.notifyPlugins(\"beforeDatasetsUpdate\",{mode:t,cancelable:!0})){for(let t=0,e=this.data.datasets.length;t<e;++t)this.getDatasetMeta(t).controller.configure();for(let e=0,i=this.data.datasets.length;e<i;++e)this._updateDataset(e,S(t)?t({datasetIndex:e}):t);this.notifyPlugins(\"afterDatasetsUpdate\",{mode:t})}}_updateDataset(t,e){const i=this.getDatasetMeta(t),s={meta:i,index:t,mode:e,cancelable:!0};!1!==this.notifyPlugins(\"beforeDatasetUpdate\",s)&&(i.controller._update(e),s.cancelable=!1,this.notifyPlugins(\"afterDatasetUpdate\",s))}render(){!1!==this.notifyPlugins(\"beforeRender\",{cancelable:!0})&&(xt.has(this)?this.attached&&!xt.running(this)&&xt.start(this):(this.draw(),wn({chart:this})))}draw(){let t;if(this._resizeBeforeDraw){const{width:t,height:e}=this._resizeBeforeDraw;this._resize(t,e),this._resizeBeforeDraw=null}if(this.clear(),this.width<=0||this.height<=0)return;if(!1===this.notifyPlugins(\"beforeDraw\",{cancelable:!0}))return;const e=this._layers;for(t=0;t<e.length&&e[t].z<=0;++t)e[t].draw(this.chartArea);for(this._drawDatasets();t<e.length;++t)e[t].draw(this.chartArea);this.notifyPlugins(\"afterDraw\")}_getSortedDatasetMetas(t){const e=this._sortedMetasets,i=[];let s,n;for(s=0,n=e.length;s<n;++s){const n=e[s];t&&!n.visible||i.push(n)}return i}getSortedVisibleDatasetMetas(){return this._getSortedDatasetMetas(!0)}_drawDatasets(){if(!1===this.notifyPlugins(\"beforeDatasetsDraw\",{cancelable:!0}))return;const t=this.getSortedVisibleDatasetMetas();for(let e=t.length-1;e>=0;--e)this._drawDataset(t[e]);this.notifyPlugins(\"afterDatasetsDraw\")}_drawDataset(t){const e=this.ctx,i=t._clip,s=!i.disabled,n=function(t,e){const{xScale:i,yScale:s}=t;return i&&s?{left:On(i,e,\"left\"),right:On(i,e,\"right\"),top:On(s,e,\"top\"),bottom:On(s,e,\"bottom\")}:e}(t,this.chartArea),o={meta:t,index:t.index,cancelable:!0};!1!==this.notifyPlugins(\"beforeDatasetDraw\",o)&&(s&&Ie(e,{left:!1===i.left?0:n.left-i.left,right:!1===i.right?this.width:n.right+i.right,top:!1===i.top?0:n.top-i.top,bottom:!1===i.bottom?this.height:n.bottom+i.bottom}),t.controller.draw(),s&&ze(e),o.cancelable=!1,this.notifyPlugins(\"afterDatasetDraw\",o))}isPointInArea(t){return Re(t,this.chartArea,this._minPadding)}getElementsAtEventForMode(t,e,i,s){const n=Xi.modes[e];return\"function\"==typeof n?n(this,t,i,s):[]}getDatasetMeta(t){const e=this.data.datasets[t],i=this._metasets;let s=i.filter((t=>t&&t._dataset===e)).pop();return s||(s={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:e&&e.order||0,index:t,_dataset:e,_parsed:[],_sorted:!1},i.push(s)),s}getContext(){return this.$context||(this.$context=Ci(null,{chart:this,type:\"chart\"}))}getVisibleDatasetCount(){return this.getSortedVisibleDatasetMetas().length}isDatasetVisible(t){const e=this.data.datasets[t];if(!e)return!1;const i=this.getDatasetMeta(t);return\"boolean\"==typeof i.hidden?!i.hidden:!e.hidden}setDatasetVisibility(t,e){this.getDatasetMeta(t).hidden=!e}toggleDataVisibility(t){this._hiddenIndices[t]=!this._hiddenIndices[t]}getDataVisibility(t){return!this._hiddenIndices[t]}_updateVisibility(t,e,i){const s=i?\"show\":\"hide\",n=this.getDatasetMeta(t),o=n.controller._resolveAnimations(void 0,s);k(e)?(n.data[e].hidden=!i,this.update()):(this.setDatasetVisibility(t,i),o.update(n,{visible:i}),this.update((e=>e.datasetIndex===t?s:void 0)))}hide(t,e){this._updateVisibility(t,e,!1)}show(t,e){this._updateVisibility(t,e,!0)}_destroyDatasetMeta(t){const e=this._metasets[t];e&&e.controller&&e.controller._destroy(),delete this._metasets[t]}_stop(){let t,e;for(this.stop(),xt.remove(this),t=0,e=this.data.datasets.length;t<e;++t)this._destroyDatasetMeta(t)}destroy(){this.notifyPlugins(\"beforeDestroy\");const{canvas:t,ctx:e}=this;this._stop(),this.config.clearCache(),t&&(this.unbindEvents(),Te(t,e),this.platform.releaseContext(e),this.canvas=null,this.ctx=null),delete Pn[this.id],this.notifyPlugins(\"afterDestroy\")}toBase64Image(...t){return this.canvas.toDataURL(...t)}bindEvents(){this.bindUserEvents(),this.options.responsive?this.bindResponsiveEvents():this.attached=!0}bindUserEvents(){const t=this._listeners,e=this.platform,i=(i,s)=>{e.addEventListener(this,i,s),t[i]=s},s=(t,e,i)=>{t.offsetX=e,t.offsetY=i,this._eventHandler(t)};u(this.options.events,(t=>i(t,s)))}bindResponsiveEvents(){this._responsiveListeners||(this._responsiveListeners={});const t=this._responsiveListeners,e=this.platform,i=(i,s)=>{e.addEventListener(this,i,s),t[i]=s},s=(i,s)=>{t[i]&&(e.removeEventListener(this,i,s),delete t[i])},n=(t,e)=>{this.canvas&&this.resize(t,e)};let o;const a=()=>{s(\"attach\",a),this.attached=!0,this.resize(),i(\"resize\",n),i(\"detach\",o)};o=()=>{this.attached=!1,s(\"resize\",n),this._stop(),this._resize(0,0),i(\"attach\",a)},e.isAttached(this.canvas)?a():o()}unbindEvents(){u(this._listeners,((t,e)=>{this.platform.removeEventListener(this,e,t)})),this._listeners={},u(this._responsiveListeners,((t,e)=>{this.platform.removeEventListener(this,e,t)})),this._responsiveListeners=void 0}updateHoverStyle(t,e,i){const s=i?\"set\":\"remove\";let n,o,a,r;for(\"dataset\"===e&&(n=this.getDatasetMeta(t[0].datasetIndex),n.controller[\"_\"+s+\"DatasetHoverStyle\"]()),a=0,r=t.length;a<r;++a){o=t[a];const e=o&&this.getDatasetMeta(o.datasetIndex).controller;e&&e[s+\"HoverStyle\"](o.element,o.datasetIndex,o.index)}}getActiveElements(){return this._active||[]}setActiveElements(t){const e=this._active||[],i=t.map((({datasetIndex:t,index:e})=>{const i=this.getDatasetMeta(t);if(!i)throw new Error(\"No dataset found at index \"+t);return{datasetIndex:t,element:i.data[e],index:e}}));!f(i,e)&&(this._active=i,this._lastEvent=null,this._updateHoverStyles(i,e))}notifyPlugins(t,e,i){return this._plugins.notify(this,t,e,i)}isPluginEnabled(t){return 1===this._plugins._cache.filter((e=>e.plugin.id===t)).length}_updateHoverStyles(t,e,i){const s=this.options.hover,n=(t,e)=>t.filter((t=>!e.some((e=>t.datasetIndex===e.datasetIndex&&t.index===e.index)))),o=n(e,t),a=i?t:n(t,e);o.length&&this.updateHoverStyle(o,s.mode,!1),a.length&&s.mode&&this.updateHoverStyle(a,s.mode,!0)}_eventHandler(t,e){const i={event:t,replay:e,cancelable:!0,inChartArea:this.isPointInArea(t)},s=e=>(e.options.events||this.options.events).includes(t.native.type);if(!1===this.notifyPlugins(\"beforeEvent\",i,s))return;const n=this._handleEvent(t,e,i.inChartArea);return i.cancelable=!1,this.notifyPlugins(\"afterEvent\",i,s),(n||i.changed)&&this.render(),this}_handleEvent(t,e,i){const{_active:s=[],options:n}=this,o=e,a=this._getActiveElements(t,s,i,o),r=D(t),l=function(t,e,i,s){return i&&\"mouseout\"!==t.type?s?e:t:null}(t,this._lastEvent,i,r);i&&(this._lastEvent=null,d(n.onHover,[t,a,this],this),r&&d(n.onClick,[t,a,this],this));const h=!f(a,s);return(h||e)&&(this._active=a,this._updateHoverStyles(a,s,e)),this._lastEvent=l,h}_getActiveElements(t,e,i,s){if(\"mouseout\"===t.type)return[];if(!i)return e;const n=this.options.hover;return this.getElementsAtEventForMode(t,n.mode,n,s)}}function Tn(){return u(An.instances,(t=>t._plugins.invalidate()))}function Ln(){throw new Error(\"This method is not implemented: Check that a complete date adapter is provided.\")}class En{static override(t){Object.assign(En.prototype,t)}options;constructor(t){this.options=t||{}}init(){}formats(){return Ln()}parse(){return Ln()}format(){return Ln()}add(){return Ln()}diff(){return Ln()}startOf(){return Ln()}endOf(){return Ln()}}var Rn={_date:En};function In(t){const e=t.iScale,i=function(t,e){if(!t._cache.$bar){const i=t.getMatchingVisibleMetas(e);let s=[];for(let e=0,n=i.length;e<n;e++)s=s.concat(i[e].controller.getAllParsedValues(t));t._cache.$bar=lt(s.sort(((t,e)=>t-e)))}return t._cache.$bar}(e,t.type);let s,n,o,a,r=e._length;const l=()=>{32767!==o&&-32768!==o&&(k(a)&&(r=Math.min(r,Math.abs(o-a)||r)),a=o)};for(s=0,n=i.length;s<n;++s)o=e.getPixelForValue(i[s]),l();for(a=void 0,s=0,n=e.ticks.length;s<n;++s)o=e.getPixelForTick(s),l();return r}function zn(t,e,i,s){return n(t)?function(t,e,i,s){const n=i.parse(t[0],s),o=i.parse(t[1],s),a=Math.min(n,o),r=Math.max(n,o);let l=a,h=r;Math.abs(a)>Math.abs(r)&&(l=r,h=a),e[i.axis]=h,e._custom={barStart:l,barEnd:h,start:n,end:o,min:a,max:r}}(t,e,i,s):e[i.axis]=i.parse(t,s),e}function Fn(t,e,i,s){const n=t.iScale,o=t.vScale,a=n.getLabels(),r=n===o,l=[];let h,c,d,u;for(h=i,c=i+s;h<c;++h)u=e[h],d={},d[n.axis]=r||n.parse(a[h],h),l.push(zn(u,d,o,h));return l}function Vn(t){return t&&void 0!==t.barStart&&void 0!==t.barEnd}function Bn(t,e,i,s){let n=e.borderSkipped;const o={};if(!n)return void(t.borderSkipped=o);if(!0===n)return void(t.borderSkipped={top:!0,right:!0,bottom:!0,left:!0});const{start:a,end:r,reverse:l,top:h,bottom:c}=function(t){let e,i,s,n,o;return t.horizontal?(e=t.base>t.x,i=\"left\",s=\"right\"):(e=t.base<t.y,i=\"bottom\",s=\"top\"),e?(n=\"end\",o=\"start\"):(n=\"start\",o=\"end\"),{start:i,end:s,reverse:e,top:n,bottom:o}}(t);\"middle\"===n&&i&&(t.enableBorderRadius=!0,(i._top||0)===s?n=h:(i._bottom||0)===s?n=c:(o[Wn(c,a,r,l)]=!0,n=h)),o[Wn(n,a,r,l)]=!0,t.borderSkipped=o}function Wn(t,e,i,s){var n,o,a;return s?(a=i,t=Nn(t=(n=t)===(o=e)?a:n===a?o:n,i,e)):t=Nn(t,e,i),t}function Nn(t,e,i){return\"start\"===t?e:\"end\"===t?i:t}function Hn(t,{inflateAmount:e},i){t.inflateAmount=\"auto\"===e?1===i?.33:0:e}class jn extends Ns{static id=\"doughnut\";static defaults={datasetElementType:!1,dataElementType:\"arc\",animation:{animateRotate:!0,animateScale:!1},animations:{numbers:{type:\"number\",properties:[\"circumference\",\"endAngle\",\"innerRadius\",\"outerRadius\",\"startAngle\",\"x\",\"y\",\"offset\",\"borderWidth\",\"spacing\"]}},cutout:\"50%\",rotation:0,circumference:360,radius:\"100%\",spacing:0,indexAxis:\"r\"};static descriptors={_scriptable:t=>\"spacing\"!==t,_indexable:t=>\"spacing\"!==t&&!t.startsWith(\"borderDash\")&&!t.startsWith(\"hoverBorderDash\")};static overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;if(e.labels.length&&e.datasets.length){const{labels:{pointStyle:i,color:s}}=t.legend.options;return e.labels.map(((e,n)=>{const o=t.getDatasetMeta(0).controller.getStyle(n);return{text:e,fillStyle:o.backgroundColor,strokeStyle:o.borderColor,fontColor:s,lineWidth:o.borderWidth,pointStyle:i,hidden:!t.getDataVisibility(n),index:n}}))}return[]}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update()}}}};constructor(t,e){super(t,e),this.enableOptionSharing=!0,this.innerRadius=void 0,this.outerRadius=void 0,this.offsetX=void 0,this.offsetY=void 0}linkScales(){}parse(t,e){const i=this.getDataset().data,s=this._cachedMeta;if(!1===this._parsing)s._parsed=i;else{let n,a,r=t=>+i[t];if(o(i[t])){const{key:t=\"value\"}=this._parsing;r=e=>+M(i[e],t)}for(n=t,a=t+e;n<a;++n)s._parsed[n]=r(n)}}_getRotation(){return $(this.options.rotation-90)}_getCircumference(){return $(this.options.circumference)}_getRotationExtents(){let t=O,e=-O;for(let i=0;i<this.chart.data.datasets.length;++i)if(this.chart.isDatasetVisible(i)&&this.chart.getDatasetMeta(i).type===this._type){const s=this.chart.getDatasetMeta(i).controller,n=s._getRotation(),o=s._getCircumference();t=Math.min(t,n),e=Math.max(e,n+o)}return{rotation:t,circumference:e-t}}update(t){const e=this.chart,{chartArea:i}=e,s=this._cachedMeta,n=s.data,o=this.getMaxBorderWidth()+this.getMaxOffset(n)+this.options.spacing,a=Math.max((Math.min(i.width,i.height)-o)/2,0),r=Math.min(h(this.options.cutout,a),1),l=this._getRingWeight(this.index),{circumference:d,rotation:u}=this._getRotationExtents(),{ratioX:f,ratioY:g,offsetX:p,offsetY:m}=function(t,e,i){let s=1,n=1,o=0,a=0;if(e<O){const r=t,l=r+e,h=Math.cos(r),c=Math.sin(r),d=Math.cos(l),u=Math.sin(l),f=(t,e,s)=>Z(t,r,l,!0)?1:Math.max(e,e*i,s,s*i),g=(t,e,s)=>Z(t,r,l,!0)?-1:Math.min(e,e*i,s,s*i),p=f(0,h,d),m=f(E,c,u),b=g(C,h,d),x=g(C+E,c,u);s=(p-b)/2,n=(m-x)/2,o=-(p+b)/2,a=-(m+x)/2}return{ratioX:s,ratioY:n,offsetX:o,offsetY:a}}(u,d,r),b=(i.width-o)/f,x=(i.height-o)/g,_=Math.max(Math.min(b,x)/2,0),y=c(this.options.radius,_),v=(y-Math.max(y*r,0))/this._getVisibleDatasetWeightTotal();this.offsetX=p*y,this.offsetY=m*y,s.total=this.calculateTotal(),this.outerRadius=y-v*this._getRingWeightOffset(this.index),this.innerRadius=Math.max(this.outerRadius-v*l,0),this.updateElements(n,0,n.length,t)}_circumference(t,e){const i=this.options,s=this._cachedMeta,n=this._getCircumference();return e&&i.animation.animateRotate||!this.chart.getDataVisibility(t)||null===s._parsed[t]||s.data[t].hidden?0:this.calculateCircumference(s._parsed[t]*n/O)}updateElements(t,e,i,s){const n=\"reset\"===s,o=this.chart,a=o.chartArea,r=o.options.animation,l=(a.left+a.right)/2,h=(a.top+a.bottom)/2,c=n&&r.animateScale,d=c?0:this.innerRadius,u=c?0:this.outerRadius,{sharedOptions:f,includeOptions:g}=this._getSharedOptions(e,s);let p,m=this._getRotation();for(p=0;p<e;++p)m+=this._circumference(p,n);for(p=e;p<e+i;++p){const e=this._circumference(p,n),i=t[p],o={x:l+this.offsetX,y:h+this.offsetY,startAngle:m,endAngle:m+e,circumference:e,outerRadius:u,innerRadius:d};g&&(o.options=f||this.resolveDataElementOptions(p,i.active?\"active\":s)),m+=e,this.updateElement(i,p,o,s)}}calculateTotal(){const t=this._cachedMeta,e=t.data;let i,s=0;for(i=0;i<e.length;i++){const n=t._parsed[i];null===n||isNaN(n)||!this.chart.getDataVisibility(i)||e[i].hidden||(s+=Math.abs(n))}return s}calculateCircumference(t){const e=this._cachedMeta.total;return e>0&&!isNaN(t)?O*(Math.abs(t)/e):0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,s=i.data.labels||[],n=ne(e._parsed[t],i.options.locale);return{label:s[t]||\"\",value:n}}getMaxBorderWidth(t){let e=0;const i=this.chart;let s,n,o,a,r;if(!t)for(s=0,n=i.data.datasets.length;s<n;++s)if(i.isDatasetVisible(s)){o=i.getDatasetMeta(s),t=o.data,a=o.controller;break}if(!t)return 0;for(s=0,n=t.length;s<n;++s)r=a.resolveDataElementOptions(s),\"inner\"!==r.borderAlign&&(e=Math.max(e,r.borderWidth||0,r.hoverBorderWidth||0));return e}getMaxOffset(t){let e=0;for(let i=0,s=t.length;i<s;++i){const t=this.resolveDataElementOptions(i);e=Math.max(e,t.offset||0,t.hoverOffset||0)}return e}_getRingWeightOffset(t){let e=0;for(let i=0;i<t;++i)this.chart.isDatasetVisible(i)&&(e+=this._getRingWeight(i));return e}_getRingWeight(t){return Math.max(l(this.chart.data.datasets[t].weight,1),0)}_getVisibleDatasetWeightTotal(){return this._getRingWeightOffset(this.chart.data.datasets.length)||1}}class $n extends Ns{static id=\"polarArea\";static defaults={dataElementType:\"arc\",animation:{animateRotate:!0,animateScale:!0},animations:{numbers:{type:\"number\",properties:[\"x\",\"y\",\"startAngle\",\"endAngle\",\"innerRadius\",\"outerRadius\"]}},indexAxis:\"r\",startAngle:0};static overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;if(e.labels.length&&e.datasets.length){const{labels:{pointStyle:i,color:s}}=t.legend.options;return e.labels.map(((e,n)=>{const o=t.getDatasetMeta(0).controller.getStyle(n);return{text:e,fillStyle:o.backgroundColor,strokeStyle:o.borderColor,fontColor:s,lineWidth:o.borderWidth,pointStyle:i,hidden:!t.getDataVisibility(n),index:n}}))}return[]}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update()}}},scales:{r:{type:\"radialLinear\",angleLines:{display:!1},beginAtZero:!0,grid:{circular:!0},pointLabels:{display:!1},startAngle:0}}};constructor(t,e){super(t,e),this.innerRadius=void 0,this.outerRadius=void 0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,s=i.data.labels||[],n=ne(e._parsed[t].r,i.options.locale);return{label:s[t]||\"\",value:n}}parseObjectData(t,e,i,s){return ii.bind(this)(t,e,i,s)}update(t){const e=this._cachedMeta.data;this._updateRadius(),this.updateElements(e,0,e.length,t)}getMinMax(){const t=this._cachedMeta,e={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY};return t.data.forEach(((t,i)=>{const s=this.getParsed(i).r;!isNaN(s)&&this.chart.getDataVisibility(i)&&(s<e.min&&(e.min=s),s>e.max&&(e.max=s))})),e}_updateRadius(){const t=this.chart,e=t.chartArea,i=t.options,s=Math.min(e.right-e.left,e.bottom-e.top),n=Math.max(s/2,0),o=(n-Math.max(i.cutoutPercentage?n/100*i.cutoutPercentage:1,0))/t.getVisibleDatasetCount();this.outerRadius=n-o*this.index,this.innerRadius=this.outerRadius-o}updateElements(t,e,i,s){const n=\"reset\"===s,o=this.chart,a=o.options.animation,r=this._cachedMeta.rScale,l=r.xCenter,h=r.yCenter,c=r.getIndexAngle(0)-.5*C;let d,u=c;const f=360/this.countVisibleElements();for(d=0;d<e;++d)u+=this._computeAngle(d,s,f);for(d=e;d<e+i;d++){const e=t[d];let i=u,g=u+this._computeAngle(d,s,f),p=o.getDataVisibility(d)?r.getDistanceFromCenterForValue(this.getParsed(d).r):0;u=g,n&&(a.animateScale&&(p=0),a.animateRotate&&(i=g=c));const m={x:l,y:h,innerRadius:0,outerRadius:p,startAngle:i,endAngle:g,options:this.resolveDataElementOptions(d,e.active?\"active\":s)};this.updateElement(e,d,m,s)}}countVisibleElements(){const t=this._cachedMeta;let e=0;return t.data.forEach(((t,i)=>{!isNaN(this.getParsed(i).r)&&this.chart.getDataVisibility(i)&&e++})),e}_computeAngle(t,e,i){return this.chart.getDataVisibility(t)?$(this.resolveDataElementOptions(t,e).angle||i):0}}var Yn=Object.freeze({__proto__:null,BarController:class extends Ns{static id=\"bar\";static defaults={datasetElementType:!1,dataElementType:\"bar\",categoryPercentage:.8,barPercentage:.9,grouped:!0,animations:{numbers:{type:\"number\",properties:[\"x\",\"y\",\"base\",\"width\",\"height\"]}}};static overrides={scales:{_index_:{type:\"category\",offset:!0,grid:{offset:!0}},_value_:{type:\"linear\",beginAtZero:!0}}};parsePrimitiveData(t,e,i,s){return Fn(t,e,i,s)}parseArrayData(t,e,i,s){return Fn(t,e,i,s)}parseObjectData(t,e,i,s){const{iScale:n,vScale:o}=t,{xAxisKey:a=\"x\",yAxisKey:r=\"y\"}=this._parsing,l=\"x\"===n.axis?a:r,h=\"x\"===o.axis?a:r,c=[];let d,u,f,g;for(d=i,u=i+s;d<u;++d)g=e[d],f={},f[n.axis]=n.parse(M(g,l),d),c.push(zn(M(g,h),f,o,d));return c}updateRangeFromParsed(t,e,i,s){super.updateRangeFromParsed(t,e,i,s);const n=i._custom;n&&e===this._cachedMeta.vScale&&(t.min=Math.min(t.min,n.min),t.max=Math.max(t.max,n.max))}getMaxOverflow(){return 0}getLabelAndValue(t){const e=this._cachedMeta,{iScale:i,vScale:s}=e,n=this.getParsed(t),o=n._custom,a=Vn(o)?\"[\"+o.start+\", \"+o.end+\"]\":\"\"+s.getLabelForValue(n[s.axis]);return{label:\"\"+i.getLabelForValue(n[i.axis]),value:a}}initialize(){this.enableOptionSharing=!0,super.initialize();this._cachedMeta.stack=this.getDataset().stack}update(t){const e=this._cachedMeta;this.updateElements(e.data,0,e.data.length,t)}updateElements(t,e,i,n){const o=\"reset\"===n,{index:a,_cachedMeta:{vScale:r}}=this,l=r.getBasePixel(),h=r.isHorizontal(),c=this._getRuler(),{sharedOptions:d,includeOptions:u}=this._getSharedOptions(e,n);for(let f=e;f<e+i;f++){const e=this.getParsed(f),i=o||s(e[r.axis])?{base:l,head:l}:this._calculateBarValuePixels(f),g=this._calculateBarIndexPixels(f,c),p=(e._stacks||{})[r.axis],m={horizontal:h,base:i.base,enableBorderRadius:!p||Vn(e._custom)||a===p._top||a===p._bottom,x:h?i.head:g.center,y:h?g.center:i.head,height:h?g.size:Math.abs(i.size),width:h?Math.abs(i.size):g.size};u&&(m.options=d||this.resolveDataElementOptions(f,t[f].active?\"active\":n));const b=m.options||t[f].options;Bn(m,b,p,a),Hn(m,b,c.ratio),this.updateElement(t[f],f,m,n)}}_getStacks(t,e){const{iScale:i}=this._cachedMeta,n=i.getMatchingVisibleMetas(this._type).filter((t=>t.controller.options.grouped)),o=i.options.stacked,a=[],r=t=>{const i=t.controller.getParsed(e),n=i&&i[t.vScale.axis];if(s(n)||isNaN(n))return!0};for(const i of n)if((void 0===e||!r(i))&&((!1===o||-1===a.indexOf(i.stack)||void 0===o&&void 0===i.stack)&&a.push(i.stack),i.index===t))break;return a.length||a.push(void 0),a}_getStackCount(t){return this._getStacks(void 0,t).length}_getStackIndex(t,e,i){const s=this._getStacks(t,i),n=void 0!==e?s.indexOf(e):-1;return-1===n?s.length-1:n}_getRuler(){const t=this.options,e=this._cachedMeta,i=e.iScale,s=[];let n,o;for(n=0,o=e.data.length;n<o;++n)s.push(i.getPixelForValue(this.getParsed(n)[i.axis],n));const a=t.barThickness;return{min:a||In(e),pixels:s,start:i._startPixel,end:i._endPixel,stackCount:this._getStackCount(),scale:i,grouped:t.grouped,ratio:a?1:t.categoryPercentage*t.barPercentage}}_calculateBarValuePixels(t){const{_cachedMeta:{vScale:e,_stacked:i,index:n},options:{base:o,minBarLength:a}}=this,r=o||0,l=this.getParsed(t),h=l._custom,c=Vn(h);let d,u,f=l[e.axis],g=0,p=i?this.applyStack(e,l,i):f;p!==f&&(g=p-f,p=f),c&&(f=h.barStart,p=h.barEnd-h.barStart,0!==f&&F(f)!==F(h.barEnd)&&(g=0),g+=f);const m=s(o)||c?g:o;let b=e.getPixelForValue(m);if(d=this.chart.getDataVisibility(t)?e.getPixelForValue(g+p):b,u=d-b,Math.abs(u)<a){u=function(t,e,i){return 0!==t?F(t):(e.isHorizontal()?1:-1)*(e.min>=i?1:-1)}(u,e,r)*a,f===r&&(b-=u/2);const t=e.getPixelForDecimal(0),s=e.getPixelForDecimal(1),o=Math.min(t,s),h=Math.max(t,s);b=Math.max(Math.min(b,h),o),d=b+u,i&&!c&&(l._stacks[e.axis]._visualValues[n]=e.getValueForPixel(d)-e.getValueForPixel(b))}if(b===e.getPixelForValue(r)){const t=F(u)*e.getLineWidthForValue(r)/2;b+=t,u-=t}return{size:u,base:b,head:d,center:d+u/2}}_calculateBarIndexPixels(t,e){const i=e.scale,n=this.options,o=n.skipNull,a=l(n.maxBarThickness,1/0);let r,h;if(e.grouped){const i=o?this._getStackCount(t):e.stackCount,l=\"flex\"===n.barThickness?function(t,e,i,s){const n=e.pixels,o=n[t];let a=t>0?n[t-1]:null,r=t<n.length-1?n[t+1]:null;const l=i.categoryPercentage;null===a&&(a=o-(null===r?e.end-e.start:r-o)),null===r&&(r=o+o-a);const h=o-(o-Math.min(a,r))/2*l;return{chunk:Math.abs(r-a)/2*l/s,ratio:i.barPercentage,start:h}}(t,e,n,i):function(t,e,i,n){const o=i.barThickness;let a,r;return s(o)?(a=e.min*i.categoryPercentage,r=i.barPercentage):(a=o*n,r=1),{chunk:a/n,ratio:r,start:e.pixels[t]-a/2}}(t,e,n,i),c=this._getStackIndex(this.index,this._cachedMeta.stack,o?t:void 0);r=l.start+l.chunk*c+l.chunk/2,h=Math.min(a,l.chunk*l.ratio)}else r=i.getPixelForValue(this.getParsed(t)[i.axis],t),h=Math.min(a,e.min*e.ratio);return{base:r-h/2,head:r+h/2,center:r,size:h}}draw(){const t=this._cachedMeta,e=t.vScale,i=t.data,s=i.length;let n=0;for(;n<s;++n)null!==this.getParsed(n)[e.axis]&&i[n].draw(this._ctx)}},BubbleController:class extends Ns{static id=\"bubble\";static defaults={datasetElementType:!1,dataElementType:\"point\",animations:{numbers:{type:\"number\",properties:[\"x\",\"y\",\"borderWidth\",\"radius\"]}}};static overrides={scales:{x:{type:\"linear\"},y:{type:\"linear\"}}};initialize(){this.enableOptionSharing=!0,super.initialize()}parsePrimitiveData(t,e,i,s){const n=super.parsePrimitiveData(t,e,i,s);for(let t=0;t<n.length;t++)n[t]._custom=this.resolveDataElementOptions(t+i).radius;return n}parseArrayData(t,e,i,s){const n=super.parseArrayData(t,e,i,s);for(let t=0;t<n.length;t++){const s=e[i+t];n[t]._custom=l(s[2],this.resolveDataElementOptions(t+i).radius)}return n}parseObjectData(t,e,i,s){const n=super.parseObjectData(t,e,i,s);for(let t=0;t<n.length;t++){const s=e[i+t];n[t]._custom=l(s&&s.r&&+s.r,this.resolveDataElementOptions(t+i).radius)}return n}getMaxOverflow(){const t=this._cachedMeta.data;let e=0;for(let i=t.length-1;i>=0;--i)e=Math.max(e,t[i].size(this.resolveDataElementOptions(i))/2);return e>0&&e}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart.data.labels||[],{xScale:s,yScale:n}=e,o=this.getParsed(t),a=s.getLabelForValue(o.x),r=n.getLabelForValue(o.y),l=o._custom;return{label:i[t]||\"\",value:\"(\"+a+\", \"+r+(l?\", \"+l:\"\")+\")\"}}update(t){const e=this._cachedMeta.data;this.updateElements(e,0,e.length,t)}updateElements(t,e,i,s){const n=\"reset\"===s,{iScale:o,vScale:a}=this._cachedMeta,{sharedOptions:r,includeOptions:l}=this._getSharedOptions(e,s),h=o.axis,c=a.axis;for(let d=e;d<e+i;d++){const e=t[d],i=!n&&this.getParsed(d),u={},f=u[h]=n?o.getPixelForDecimal(.5):o.getPixelForValue(i[h]),g=u[c]=n?a.getBasePixel():a.getPixelForValue(i[c]);u.skip=isNaN(f)||isNaN(g),l&&(u.options=r||this.resolveDataElementOptions(d,e.active?\"active\":s),n&&(u.options.radius=0)),this.updateElement(e,d,u,s)}}resolveDataElementOptions(t,e){const i=this.getParsed(t);let s=super.resolveDataElementOptions(t,e);s.$shared&&(s=Object.assign({},s,{$shared:!1}));const n=s.radius;return\"active\"!==e&&(s.radius=0),s.radius+=l(i&&i._custom,n),s}},DoughnutController:jn,LineController:class extends Ns{static id=\"line\";static defaults={datasetElementType:\"line\",dataElementType:\"point\",showLine:!0,spanGaps:!1};static overrides={scales:{_index_:{type:\"category\"},_value_:{type:\"linear\"}}};initialize(){this.enableOptionSharing=!0,this.supportsDecimation=!0,super.initialize()}update(t){const e=this._cachedMeta,{dataset:i,data:s=[],_dataset:n}=e,o=this.chart._animationsDisabled;let{start:a,count:r}=pt(e,s,o);this._drawStart=a,this._drawCount=r,mt(e)&&(a=0,r=s.length),i._chart=this.chart,i._datasetIndex=this.index,i._decimated=!!n._decimated,i.points=s;const l=this.resolveDatasetElementOptions(t);this.options.showLine||(l.borderWidth=0),l.segment=this.options.segment,this.updateElement(i,void 0,{animated:!o,options:l},t),this.updateElements(s,a,r,t)}updateElements(t,e,i,n){const o=\"reset\"===n,{iScale:a,vScale:r,_stacked:l,_dataset:h}=this._cachedMeta,{sharedOptions:c,includeOptions:d}=this._getSharedOptions(e,n),u=a.axis,f=r.axis,{spanGaps:g,segment:p}=this.options,m=N(g)?g:Number.POSITIVE_INFINITY,b=this.chart._animationsDisabled||o||\"none\"===n,x=e+i,_=t.length;let y=e>0&&this.getParsed(e-1);for(let i=0;i<_;++i){const g=t[i],_=b?g:{};if(i<e||i>=x){_.skip=!0;continue}const v=this.getParsed(i),M=s(v[f]),w=_[u]=a.getPixelForValue(v[u],i),k=_[f]=o||M?r.getBasePixel():r.getPixelForValue(l?this.applyStack(r,v,l):v[f],i);_.skip=isNaN(w)||isNaN(k)||M,_.stop=i>0&&Math.abs(v[u]-y[u])>m,p&&(_.parsed=v,_.raw=h.data[i]),d&&(_.options=c||this.resolveDataElementOptions(i,g.active?\"active\":n)),b||this.updateElement(g,i,_,n),y=v}}getMaxOverflow(){const t=this._cachedMeta,e=t.dataset,i=e.options&&e.options.borderWidth||0,s=t.data||[];if(!s.length)return i;const n=s[0].size(this.resolveDataElementOptions(0)),o=s[s.length-1].size(this.resolveDataElementOptions(s.length-1));return Math.max(i,n,o)/2}draw(){const t=this._cachedMeta;t.dataset.updateControlPoints(this.chart.chartArea,t.iScale.axis),super.draw()}},PieController:class extends jn{static id=\"pie\";static defaults={cutout:0,rotation:0,circumference:360,radius:\"100%\"}},PolarAreaController:$n,RadarController:class extends Ns{static id=\"radar\";static defaults={datasetElementType:\"line\",dataElementType:\"point\",indexAxis:\"r\",showLine:!0,elements:{line:{fill:\"start\"}}};static overrides={aspectRatio:1,scales:{r:{type:\"radialLinear\"}}};getLabelAndValue(t){const e=this._cachedMeta.vScale,i=this.getParsed(t);return{label:e.getLabels()[t],value:\"\"+e.getLabelForValue(i[e.axis])}}parseObjectData(t,e,i,s){return ii.bind(this)(t,e,i,s)}update(t){const e=this._cachedMeta,i=e.dataset,s=e.data||[],n=e.iScale.getLabels();if(i.points=s,\"resize\"!==t){const e=this.resolveDatasetElementOptions(t);this.options.showLine||(e.borderWidth=0);const o={_loop:!0,_fullLoop:n.length===s.length,options:e};this.updateElement(i,void 0,o,t)}this.updateElements(s,0,s.length,t)}updateElements(t,e,i,s){const n=this._cachedMeta.rScale,o=\"reset\"===s;for(let a=e;a<e+i;a++){const e=t[a],i=this.resolveDataElementOptions(a,e.active?\"active\":s),r=n.getPointPositionForValue(a,this.getParsed(a).r),l=o?n.xCenter:r.x,h=o?n.yCenter:r.y,c={x:l,y:h,angle:r.angle,skip:isNaN(l)||isNaN(h),options:i};this.updateElement(e,a,c,s)}}},ScatterController:class extends Ns{static id=\"scatter\";static defaults={datasetElementType:!1,dataElementType:\"point\",showLine:!1,fill:!1};static overrides={interaction:{mode:\"point\"},scales:{x:{type:\"linear\"},y:{type:\"linear\"}}};getLabelAndValue(t){const e=this._cachedMeta,i=this.chart.data.labels||[],{xScale:s,yScale:n}=e,o=this.getParsed(t),a=s.getLabelForValue(o.x),r=n.getLabelForValue(o.y);return{label:i[t]||\"\",value:\"(\"+a+\", \"+r+\")\"}}update(t){const e=this._cachedMeta,{data:i=[]}=e,s=this.chart._animationsDisabled;let{start:n,count:o}=pt(e,i,s);if(this._drawStart=n,this._drawCount=o,mt(e)&&(n=0,o=i.length),this.options.showLine){this.datasetElementType||this.addElements();const{dataset:n,_dataset:o}=e;n._chart=this.chart,n._datasetIndex=this.index,n._decimated=!!o._decimated,n.points=i;const a=this.resolveDatasetElementOptions(t);a.segment=this.options.segment,this.updateElement(n,void 0,{animated:!s,options:a},t)}else this.datasetElementType&&(delete e.dataset,this.datasetElementType=!1);this.updateElements(i,n,o,t)}addElements(){const{showLine:t}=this.options;!this.datasetElementType&&t&&(this.datasetElementType=this.chart.registry.getElement(\"line\")),super.addElements()}updateElements(t,e,i,n){const o=\"reset\"===n,{iScale:a,vScale:r,_stacked:l,_dataset:h}=this._cachedMeta,c=this.resolveDataElementOptions(e,n),d=this.getSharedOptions(c),u=this.includeOptions(n,d),f=a.axis,g=r.axis,{spanGaps:p,segment:m}=this.options,b=N(p)?p:Number.POSITIVE_INFINITY,x=this.chart._animationsDisabled||o||\"none\"===n;let _=e>0&&this.getParsed(e-1);for(let c=e;c<e+i;++c){const e=t[c],i=this.getParsed(c),p=x?e:{},y=s(i[g]),v=p[f]=a.getPixelForValue(i[f],c),M=p[g]=o||y?r.getBasePixel():r.getPixelForValue(l?this.applyStack(r,i,l):i[g],c);p.skip=isNaN(v)||isNaN(M)||y,p.stop=c>0&&Math.abs(i[f]-_[f])>b,m&&(p.parsed=i,p.raw=h.data[c]),u&&(p.options=d||this.resolveDataElementOptions(c,e.active?\"active\":n)),x||this.updateElement(e,c,p,n),_=i}this.updateSharedOptions(d,n,c)}getMaxOverflow(){const t=this._cachedMeta,e=t.data||[];if(!this.options.showLine){let t=0;for(let i=e.length-1;i>=0;--i)t=Math.max(t,e[i].size(this.resolveDataElementOptions(i))/2);return t>0&&t}const i=t.dataset,s=i.options&&i.options.borderWidth||0;if(!e.length)return s;const n=e[0].size(this.resolveDataElementOptions(0)),o=e[e.length-1].size(this.resolveDataElementOptions(e.length-1));return Math.max(s,n,o)/2}}});function Un(t,e,i,s){const n=vi(t.options.borderRadius,[\"outerStart\",\"outerEnd\",\"innerStart\",\"innerEnd\"]);const o=(i-e)/2,a=Math.min(o,s*e/2),r=t=>{const e=(i-Math.min(o,t))*s/2;return J(t,0,Math.min(o,e))};return{outerStart:r(n.outerStart),outerEnd:r(n.outerEnd),innerStart:J(n.innerStart,0,a),innerEnd:J(n.innerEnd,0,a)}}function Xn(t,e,i,s){return{x:i+t*Math.cos(e),y:s+t*Math.sin(e)}}function qn(t,e,i,s,n,o){const{x:a,y:r,startAngle:l,pixelMargin:h,innerRadius:c}=e,d=Math.max(e.outerRadius+s+i-h,0),u=c>0?c+s+i+h:0;let f=0;const g=n-l;if(s){const t=((c>0?c-s:0)+(d>0?d-s:0))/2;f=(g-(0!==t?g*t/(t+s):g))/2}const p=(g-Math.max(.001,g*d-i/C)/d)/2,m=l+p+f,b=n-p-f,{outerStart:x,outerEnd:_,innerStart:y,innerEnd:v}=Un(e,u,d,b-m),M=d-x,w=d-_,k=m+x/M,S=b-_/w,P=u+y,D=u+v,O=m+y/P,A=b-v/D;if(t.beginPath(),o){const e=(k+S)/2;if(t.arc(a,r,d,k,e),t.arc(a,r,d,e,S),_>0){const e=Xn(w,S,a,r);t.arc(e.x,e.y,_,S,b+E)}const i=Xn(D,b,a,r);if(t.lineTo(i.x,i.y),v>0){const e=Xn(D,A,a,r);t.arc(e.x,e.y,v,b+E,A+Math.PI)}const s=(b-v/u+(m+y/u))/2;if(t.arc(a,r,u,b-v/u,s,!0),t.arc(a,r,u,s,m+y/u,!0),y>0){const e=Xn(P,O,a,r);t.arc(e.x,e.y,y,O+Math.PI,m-E)}const n=Xn(M,m,a,r);if(t.lineTo(n.x,n.y),x>0){const e=Xn(M,k,a,r);t.arc(e.x,e.y,x,m-E,k)}}else{t.moveTo(a,r);const e=Math.cos(k)*d+a,i=Math.sin(k)*d+r;t.lineTo(e,i);const s=Math.cos(S)*d+a,n=Math.sin(S)*d+r;t.lineTo(s,n)}t.closePath()}function Kn(t,e,i,s,n){const{fullCircles:o,startAngle:a,circumference:r,options:l}=e,{borderWidth:h,borderJoinStyle:c,borderDash:d,borderDashOffset:u}=l,f=\"inner\"===l.borderAlign;if(!h)return;t.setLineDash(d||[]),t.lineDashOffset=u,f?(t.lineWidth=2*h,t.lineJoin=c||\"round\"):(t.lineWidth=h,t.lineJoin=c||\"bevel\");let g=e.endAngle;if(o){qn(t,e,i,s,g,n);for(let e=0;e<o;++e)t.stroke();isNaN(r)||(g=a+(r%O||O))}f&&function(t,e,i){const{startAngle:s,pixelMargin:n,x:o,y:a,outerRadius:r,innerRadius:l}=e;let h=n/r;t.beginPath(),t.arc(o,a,r,s-h,i+h),l>n?(h=n/l,t.arc(o,a,l,i+h,s-h,!0)):t.arc(o,a,n,i+E,s-E),t.closePath(),t.clip()}(t,e,g),o||(qn(t,e,i,s,g,n),t.stroke())}function Gn(t,e,i=e){t.lineCap=l(i.borderCapStyle,e.borderCapStyle),t.setLineDash(l(i.borderDash,e.borderDash)),t.lineDashOffset=l(i.borderDashOffset,e.borderDashOffset),t.lineJoin=l(i.borderJoinStyle,e.borderJoinStyle),t.lineWidth=l(i.borderWidth,e.borderWidth),t.strokeStyle=l(i.borderColor,e.borderColor)}function Zn(t,e,i){t.lineTo(i.x,i.y)}function Jn(t,e,i={}){const s=t.length,{start:n=0,end:o=s-1}=i,{start:a,end:r}=e,l=Math.max(n,a),h=Math.min(o,r),c=n<a&&o<a||n>r&&o>r;return{count:s,start:l,loop:e.loop,ilen:h<l&&!c?s+h-l:h-l}}function Qn(t,e,i,s){const{points:n,options:o}=e,{count:a,start:r,loop:l,ilen:h}=Jn(n,i,s),c=function(t){return t.stepped?Fe:t.tension||\"monotone\"===t.cubicInterpolationMode?Ve:Zn}(o);let d,u,f,{move:g=!0,reverse:p}=s||{};for(d=0;d<=h;++d)u=n[(r+(p?h-d:d))%a],u.skip||(g?(t.moveTo(u.x,u.y),g=!1):c(t,f,u,p,o.stepped),f=u);return l&&(u=n[(r+(p?h:0))%a],c(t,f,u,p,o.stepped)),!!l}function to(t,e,i,s){const n=e.points,{count:o,start:a,ilen:r}=Jn(n,i,s),{move:l=!0,reverse:h}=s||{};let c,d,u,f,g,p,m=0,b=0;const x=t=>(a+(h?r-t:t))%o,_=()=>{f!==g&&(t.lineTo(m,g),t.lineTo(m,f),t.lineTo(m,p))};for(l&&(d=n[x(0)],t.moveTo(d.x,d.y)),c=0;c<=r;++c){if(d=n[x(c)],d.skip)continue;const e=d.x,i=d.y,s=0|e;s===u?(i<f?f=i:i>g&&(g=i),m=(b*m+e)/++b):(_(),t.lineTo(e,i),u=s,b=0,f=g=i),p=i}_()}function eo(t){const e=t.options,i=e.borderDash&&e.borderDash.length;return!(t._decimated||t._loop||e.tension||\"monotone\"===e.cubicInterpolationMode||e.stepped||i)?to:Qn}const io=\"function\"==typeof Path2D;function so(t,e,i,s){io&&!e.options.segment?function(t,e,i,s){let n=e._path;n||(n=e._path=new Path2D,e.path(n,i,s)&&n.closePath()),Gn(t,e.options),t.stroke(n)}(t,e,i,s):function(t,e,i,s){const{segments:n,options:o}=e,a=eo(e);for(const r of n)Gn(t,o,r.style),t.beginPath(),a(t,e,r,{start:i,end:i+s-1})&&t.closePath(),t.stroke()}(t,e,i,s)}class no extends Hs{static id=\"line\";static defaults={borderCapStyle:\"butt\",borderDash:[],borderDashOffset:0,borderJoinStyle:\"miter\",borderWidth:3,capBezierPoints:!0,cubicInterpolationMode:\"default\",fill:!1,spanGaps:!1,stepped:!1,tension:0};static defaultRoutes={backgroundColor:\"backgroundColor\",borderColor:\"borderColor\"};static descriptors={_scriptable:!0,_indexable:t=>\"borderDash\"!==t&&\"fill\"!==t};constructor(t){super(),this.animated=!0,this.options=void 0,this._chart=void 0,this._loop=void 0,this._fullLoop=void 0,this._path=void 0,this._points=void 0,this._segments=void 0,this._decimated=!1,this._pointsUpdated=!1,this._datasetIndex=void 0,t&&Object.assign(this,t)}updateControlPoints(t,e){const i=this.options;if((i.tension||\"monotone\"===i.cubicInterpolationMode)&&!i.stepped&&!this._pointsUpdated){const s=i.spanGaps?this._loop:this._fullLoop;hi(this._points,i,t,s,e),this._pointsUpdated=!0}}set points(t){this._points=t,delete this._segments,delete this._path,this._pointsUpdated=!1}get points(){return this._points}get segments(){return this._segments||(this._segments=zi(this,this.options.segment))}first(){const t=this.segments,e=this.points;return t.length&&e[t[0].start]}last(){const t=this.segments,e=this.points,i=t.length;return i&&e[t[i-1].end]}interpolate(t,e){const i=this.options,s=t[e],n=this.points,o=Ii(this,{property:e,start:s,end:s});if(!o.length)return;const a=[],r=function(t){return t.stepped?pi:t.tension||\"monotone\"===t.cubicInterpolationMode?mi:gi}(i);let l,h;for(l=0,h=o.length;l<h;++l){const{start:h,end:c}=o[l],d=n[h],u=n[c];if(d===u){a.push(d);continue}const f=r(d,u,Math.abs((s-d[e])/(u[e]-d[e])),i.stepped);f[e]=t[e],a.push(f)}return 1===a.length?a[0]:a}pathSegment(t,e,i){return eo(this)(t,this,e,i)}path(t,e,i){const s=this.segments,n=eo(this);let o=this._loop;e=e||0,i=i||this.points.length-e;for(const a of s)o&=n(t,this,a,{start:e,end:e+i-1});return!!o}draw(t,e,i,s){const n=this.options||{};(this.points||[]).length&&n.borderWidth&&(t.save(),so(t,this,i,s),t.restore()),this.animated&&(this._pointsUpdated=!1,this._path=void 0)}}function oo(t,e,i,s){const n=t.options,{[i]:o}=t.getProps([i],s);return Math.abs(e-o)<n.radius+n.hitRadius}function ao(t,e){const{x:i,y:s,base:n,width:o,height:a}=t.getProps([\"x\",\"y\",\"base\",\"width\",\"height\"],e);let r,l,h,c,d;return t.horizontal?(d=a/2,r=Math.min(i,n),l=Math.max(i,n),h=s-d,c=s+d):(d=o/2,r=i-d,l=i+d,h=Math.min(s,n),c=Math.max(s,n)),{left:r,top:h,right:l,bottom:c}}function ro(t,e,i,s){return t?0:J(e,i,s)}function lo(t){const e=ao(t),i=e.right-e.left,s=e.bottom-e.top,n=function(t,e,i){const s=t.options.borderWidth,n=t.borderSkipped,o=Mi(s);return{t:ro(n.top,o.top,0,i),r:ro(n.right,o.right,0,e),b:ro(n.bottom,o.bottom,0,i),l:ro(n.left,o.left,0,e)}}(t,i/2,s/2),a=function(t,e,i){const{enableBorderRadius:s}=t.getProps([\"enableBorderRadius\"]),n=t.options.borderRadius,a=wi(n),r=Math.min(e,i),l=t.borderSkipped,h=s||o(n);return{topLeft:ro(!h||l.top||l.left,a.topLeft,0,r),topRight:ro(!h||l.top||l.right,a.topRight,0,r),bottomLeft:ro(!h||l.bottom||l.left,a.bottomLeft,0,r),bottomRight:ro(!h||l.bottom||l.right,a.bottomRight,0,r)}}(t,i/2,s/2);return{outer:{x:e.left,y:e.top,w:i,h:s,radius:a},inner:{x:e.left+n.l,y:e.top+n.t,w:i-n.l-n.r,h:s-n.t-n.b,radius:{topLeft:Math.max(0,a.topLeft-Math.max(n.t,n.l)),topRight:Math.max(0,a.topRight-Math.max(n.t,n.r)),bottomLeft:Math.max(0,a.bottomLeft-Math.max(n.b,n.l)),bottomRight:Math.max(0,a.bottomRight-Math.max(n.b,n.r))}}}}function ho(t,e,i,s){const n=null===e,o=null===i,a=t&&!(n&&o)&&ao(t,s);return a&&(n||tt(e,a.left,a.right))&&(o||tt(i,a.top,a.bottom))}function co(t,e){t.rect(e.x,e.y,e.w,e.h)}function uo(t,e,i={}){const s=t.x!==i.x?-e:0,n=t.y!==i.y?-e:0,o=(t.x+t.w!==i.x+i.w?e:0)-s,a=(t.y+t.h!==i.y+i.h?e:0)-n;return{x:t.x+s,y:t.y+n,w:t.w+o,h:t.h+a,radius:t.radius}}var fo=Object.freeze({__proto__:null,ArcElement:class extends Hs{static id=\"arc\";static defaults={borderAlign:\"center\",borderColor:\"#fff\",borderDash:[],borderDashOffset:0,borderJoinStyle:void 0,borderRadius:0,borderWidth:2,offset:0,spacing:0,angle:void 0,circular:!0};static defaultRoutes={backgroundColor:\"backgroundColor\"};static descriptors={_scriptable:!0,_indexable:t=>\"borderDash\"!==t};circumference;endAngle;fullCircles;innerRadius;outerRadius;pixelMargin;startAngle;constructor(t){super(),this.options=void 0,this.circumference=void 0,this.startAngle=void 0,this.endAngle=void 0,this.innerRadius=void 0,this.outerRadius=void 0,this.pixelMargin=0,this.fullCircles=0,t&&Object.assign(this,t)}inRange(t,e,i){const s=this.getProps([\"x\",\"y\"],i),{angle:n,distance:o}=X(s,{x:t,y:e}),{startAngle:a,endAngle:r,innerRadius:h,outerRadius:c,circumference:d}=this.getProps([\"startAngle\",\"endAngle\",\"innerRadius\",\"outerRadius\",\"circumference\"],i),u=(this.options.spacing+this.options.borderWidth)/2,f=l(d,r-a)>=O||Z(n,a,r),g=tt(o,h+u,c+u);return f&&g}getCenterPoint(t){const{x:e,y:i,startAngle:s,endAngle:n,innerRadius:o,outerRadius:a}=this.getProps([\"x\",\"y\",\"startAngle\",\"endAngle\",\"innerRadius\",\"outerRadius\"],t),{offset:r,spacing:l}=this.options,h=(s+n)/2,c=(o+a+l+r)/2;return{x:e+Math.cos(h)*c,y:i+Math.sin(h)*c}}tooltipPosition(t){return this.getCenterPoint(t)}draw(t){const{options:e,circumference:i}=this,s=(e.offset||0)/4,n=(e.spacing||0)/2,o=e.circular;if(this.pixelMargin=\"inner\"===e.borderAlign?.33:0,this.fullCircles=i>O?Math.floor(i/O):0,0===i||this.innerRadius<0||this.outerRadius<0)return;t.save();const a=(this.startAngle+this.endAngle)/2;t.translate(Math.cos(a)*s,Math.sin(a)*s);const r=s*(1-Math.sin(Math.min(C,i||0)));t.fillStyle=e.backgroundColor,t.strokeStyle=e.borderColor,function(t,e,i,s,n){const{fullCircles:o,startAngle:a,circumference:r}=e;let l=e.endAngle;if(o){qn(t,e,i,s,l,n);for(let e=0;e<o;++e)t.fill();isNaN(r)||(l=a+(r%O||O))}qn(t,e,i,s,l,n),t.fill()}(t,this,r,n,o),Kn(t,this,r,n,o),t.restore()}},BarElement:class extends Hs{static id=\"bar\";static defaults={borderSkipped:\"start\",borderWidth:0,borderRadius:0,inflateAmount:\"auto\",pointStyle:void 0};static defaultRoutes={backgroundColor:\"backgroundColor\",borderColor:\"borderColor\"};constructor(t){super(),this.options=void 0,this.horizontal=void 0,this.base=void 0,this.width=void 0,this.height=void 0,this.inflateAmount=void 0,t&&Object.assign(this,t)}draw(t){const{inflateAmount:e,options:{borderColor:i,backgroundColor:s}}=this,{inner:n,outer:o}=lo(this),a=(r=o.radius).topLeft||r.topRight||r.bottomLeft||r.bottomRight?He:co;var r;t.save(),o.w===n.w&&o.h===n.h||(t.beginPath(),a(t,uo(o,e,n)),t.clip(),a(t,uo(n,-e,o)),t.fillStyle=i,t.fill(\"evenodd\")),t.beginPath(),a(t,uo(n,e)),t.fillStyle=s,t.fill(),t.restore()}inRange(t,e,i){return ho(this,t,e,i)}inXRange(t,e){return ho(this,t,null,e)}inYRange(t,e){return ho(this,null,t,e)}getCenterPoint(t){const{x:e,y:i,base:s,horizontal:n}=this.getProps([\"x\",\"y\",\"base\",\"horizontal\"],t);return{x:n?(e+s)/2:e,y:n?i:(i+s)/2}}getRange(t){return\"x\"===t?this.width/2:this.height/2}},LineElement:no,PointElement:class extends Hs{static id=\"point\";parsed;skip;stop;static defaults={borderWidth:1,hitRadius:1,hoverBorderWidth:1,hoverRadius:4,pointStyle:\"circle\",radius:3,rotation:0};static defaultRoutes={backgroundColor:\"backgroundColor\",borderColor:\"borderColor\"};constructor(t){super(),this.options=void 0,this.parsed=void 0,this.skip=void 0,this.stop=void 0,t&&Object.assign(this,t)}inRange(t,e,i){const s=this.options,{x:n,y:o}=this.getProps([\"x\",\"y\"],i);return Math.pow(t-n,2)+Math.pow(e-o,2)<Math.pow(s.hitRadius+s.radius,2)}inXRange(t,e){return oo(this,t,\"x\",e)}inYRange(t,e){return oo(this,t,\"y\",e)}getCenterPoint(t){const{x:e,y:i}=this.getProps([\"x\",\"y\"],t);return{x:e,y:i}}size(t){let e=(t=t||this.options||{}).radius||0;e=Math.max(e,e&&t.hoverRadius||0);return 2*(e+(e&&t.borderWidth||0))}draw(t,e){const i=this.options;this.skip||i.radius<.1||!Re(this,e,this.size(i)/2)||(t.strokeStyle=i.borderColor,t.lineWidth=i.borderWidth,t.fillStyle=i.backgroundColor,Le(t,i,this.x,this.y))}getRange(){const t=this.options||{};return t.radius+t.hitRadius}}});function go(t,e,i,s){const n=t.indexOf(e);if(-1===n)return((t,e,i,s)=>(\"string\"==typeof e?(i=t.push(e)-1,s.unshift({index:i,label:e})):isNaN(e)&&(i=null),i))(t,e,i,s);return n!==t.lastIndexOf(e)?i:n}function po(t){const e=this.getLabels();return t>=0&&t<e.length?e[t]:t}function mo(t,e,{horizontal:i,minRotation:s}){const n=$(s),o=(i?Math.sin(n):Math.cos(n))||.001,a=.75*e*(\"\"+t).length;return Math.min(e/o,a)}class bo extends Js{constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._endValue=void 0,this._valueRange=0}parse(t,e){return s(t)||(\"number\"==typeof t||t instanceof Number)&&!isFinite(+t)?null:+t}handleTickRangeOptions(){const{beginAtZero:t}=this.options,{minDefined:e,maxDefined:i}=this.getUserBounds();let{min:s,max:n}=this;const o=t=>s=e?s:t,a=t=>n=i?n:t;if(t){const t=F(s),e=F(n);t<0&&e<0?a(0):t>0&&e>0&&o(0)}if(s===n){let e=0===n?1:Math.abs(.05*n);a(n+e),t||o(s-e)}this.min=s,this.max=n}getTickLimit(){const t=this.options.ticks;let e,{maxTicksLimit:i,stepSize:s}=t;return s?(e=Math.ceil(this.max/s)-Math.floor(this.min/s)+1,e>1e3&&(console.warn(`scales.${this.id}.ticks.stepSize: ${s} would result generating up to ${e} ticks. Limiting to 1000.`),e=1e3)):(e=this.computeTickLimit(),i=i||11),i&&(e=Math.min(i,e)),e}computeTickLimit(){return Number.POSITIVE_INFINITY}buildTicks(){const t=this.options,e=t.ticks;let i=this.getTickLimit();i=Math.max(2,i);const n=function(t,e){const i=[],{bounds:n,step:o,min:a,max:r,precision:l,count:h,maxTicks:c,maxDigits:d,includeBounds:u}=t,f=o||1,g=c-1,{min:p,max:m}=e,b=!s(a),x=!s(r),_=!s(h),y=(m-p)/(d+1);let v,M,w,k,S=B((m-p)/g/f)*f;if(S<1e-14&&!b&&!x)return[{value:p},{value:m}];k=Math.ceil(m/S)-Math.floor(p/S),k>g&&(S=B(k*S/g/f)*f),s(l)||(v=Math.pow(10,l),S=Math.ceil(S*v)/v),\"ticks\"===n?(M=Math.floor(p/S)*S,w=Math.ceil(m/S)*S):(M=p,w=m),b&&x&&o&&H((r-a)/o,S/1e3)?(k=Math.round(Math.min((r-a)/S,c)),S=(r-a)/k,M=a,w=r):_?(M=b?a:M,w=x?r:w,k=h-1,S=(w-M)/k):(k=(w-M)/S,k=V(k,Math.round(k),S/1e3)?Math.round(k):Math.ceil(k));const P=Math.max(U(S),U(M));v=Math.pow(10,s(l)?P:l),M=Math.round(M*v)/v,w=Math.round(w*v)/v;let D=0;for(b&&(u&&M!==a?(i.push({value:a}),M<a&&D++,V(Math.round((M+D*S)*v)/v,a,mo(a,y,t))&&D++):M<a&&D++);D<k;++D){const t=Math.round((M+D*S)*v)/v;if(x&&t>r)break;i.push({value:t})}return x&&u&&w!==r?i.length&&V(i[i.length-1].value,r,mo(r,y,t))?i[i.length-1].value=r:i.push({value:r}):x&&w!==r||i.push({value:w}),i}({maxTicks:i,bounds:t.bounds,min:t.min,max:t.max,precision:e.precision,step:e.stepSize,count:e.count,maxDigits:this._maxDigits(),horizontal:this.isHorizontal(),minRotation:e.minRotation||0,includeBounds:!1!==e.includeBounds},this._range||this);return\"ticks\"===t.bounds&&j(n,this,\"value\"),t.reverse?(n.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max),n}configure(){const t=this.ticks;let e=this.min,i=this.max;if(super.configure(),this.options.offset&&t.length){const s=(i-e)/Math.max(t.length-1,1)/2;e-=s,i+=s}this._startValue=e,this._endValue=i,this._valueRange=i-e}getLabelForValue(t){return ne(t,this.chart.options.locale,this.options.ticks.format)}}class xo extends bo{static id=\"linear\";static defaults={ticks:{callback:ae.formatters.numeric}};determineDataLimits(){const{min:t,max:e}=this.getMinMax(!0);this.min=a(t)?t:0,this.max=a(e)?e:1,this.handleTickRangeOptions()}computeTickLimit(){const t=this.isHorizontal(),e=t?this.width:this.height,i=$(this.options.ticks.minRotation),s=(t?Math.sin(i):Math.cos(i))||.001,n=this._resolveTickFontOptions(0);return Math.ceil(e/Math.min(40,n.lineHeight/s))}getPixelForValue(t){return null===t?NaN:this.getPixelForDecimal((t-this._startValue)/this._valueRange)}getValueForPixel(t){return this._startValue+this.getDecimalForPixel(t)*this._valueRange}}const _o=t=>Math.floor(z(t)),yo=(t,e)=>Math.pow(10,_o(t)+e);function vo(t){return 1===t/Math.pow(10,_o(t))}function Mo(t,e,i){const s=Math.pow(10,i),n=Math.floor(t/s);return Math.ceil(e/s)-n}function wo(t,{min:e,max:i}){e=r(t.min,e);const s=[],n=_o(e);let o=function(t,e){let i=_o(e-t);for(;Mo(t,e,i)>10;)i++;for(;Mo(t,e,i)<10;)i--;return Math.min(i,_o(t))}(e,i),a=o<0?Math.pow(10,Math.abs(o)):1;const l=Math.pow(10,o),h=n>o?Math.pow(10,n):0,c=Math.round((e-h)*a)/a,d=Math.floor((e-h)/l/10)*l*10;let u=Math.floor((c-d)/Math.pow(10,o)),f=r(t.min,Math.round((h+d+u*Math.pow(10,o))*a)/a);for(;f<i;)s.push({value:f,major:vo(f),significand:u}),u>=10?u=u<15?15:20:u++,u>=20&&(o++,u=2,a=o>=0?1:a),f=Math.round((h+d+u*Math.pow(10,o))*a)/a;const g=r(t.max,f);return s.push({value:g,major:vo(g),significand:u}),s}class ko extends Js{static id=\"logarithmic\";static defaults={ticks:{callback:ae.formatters.logarithmic,major:{enabled:!0}}};constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._valueRange=0}parse(t,e){const i=bo.prototype.parse.apply(this,[t,e]);if(0!==i)return a(i)&&i>0?i:null;this._zero=!0}determineDataLimits(){const{min:t,max:e}=this.getMinMax(!0);this.min=a(t)?Math.max(0,t):null,this.max=a(e)?Math.max(0,e):null,this.options.beginAtZero&&(this._zero=!0),this._zero&&this.min!==this._suggestedMin&&!a(this._userMin)&&(this.min=t===yo(this.min,0)?yo(this.min,-1):yo(this.min,0)),this.handleTickRangeOptions()}handleTickRangeOptions(){const{minDefined:t,maxDefined:e}=this.getUserBounds();let i=this.min,s=this.max;const n=e=>i=t?i:e,o=t=>s=e?s:t;i===s&&(i<=0?(n(1),o(10)):(n(yo(i,-1)),o(yo(s,1)))),i<=0&&n(yo(s,-1)),s<=0&&o(yo(i,1)),this.min=i,this.max=s}buildTicks(){const t=this.options,e=wo({min:this._userMin,max:this._userMax},this);return\"ticks\"===t.bounds&&j(e,this,\"value\"),t.reverse?(e.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max),e}getLabelForValue(t){return void 0===t?\"0\":ne(t,this.chart.options.locale,this.options.ticks.format)}configure(){const t=this.min;super.configure(),this._startValue=z(t),this._valueRange=z(this.max)-z(t)}getPixelForValue(t){return void 0!==t&&0!==t||(t=this.min),null===t||isNaN(t)?NaN:this.getPixelForDecimal(t===this.min?0:(z(t)-this._startValue)/this._valueRange)}getValueForPixel(t){const e=this.getDecimalForPixel(t);return Math.pow(10,this._startValue+e*this._valueRange)}}function So(t){const e=t.ticks;if(e.display&&t.display){const t=ki(e.backdropPadding);return l(e.font&&e.font.size,ue.font.size)+t.height}return 0}function Po(t,e,i,s,n){return t===s||t===n?{start:e-i/2,end:e+i/2}:t<s||t>n?{start:e-i,end:e}:{start:e,end:e+i}}function Do(t){const e={l:t.left+t._padding.left,r:t.right-t._padding.right,t:t.top+t._padding.top,b:t.bottom-t._padding.bottom},i=Object.assign({},e),s=[],o=[],a=t._pointLabels.length,r=t.options.pointLabels,l=r.centerPointLabels?C/a:0;for(let u=0;u<a;u++){const a=r.setContext(t.getPointLabelContext(u));o[u]=a.padding;const f=t.getPointPosition(u,t.drawingArea+o[u],l),g=Si(a.font),p=(h=t.ctx,c=g,d=n(d=t._pointLabels[u])?d:[d],{w:Oe(h,c.string,d),h:d.length*c.lineHeight});s[u]=p;const m=G(t.getIndexAngle(u)+l),b=Math.round(Y(m));Co(i,e,m,Po(b,f.x,p.w,0,180),Po(b,f.y,p.h,90,270))}var h,c,d;t.setCenterPoint(e.l-i.l,i.r-e.r,e.t-i.t,i.b-e.b),t._pointLabelItems=function(t,e,i){const s=[],n=t._pointLabels.length,o=t.options,{centerPointLabels:a,display:r}=o.pointLabels,l={extra:So(o)/2,additionalAngle:a?C/n:0};let h;for(let o=0;o<n;o++){l.padding=i[o],l.size=e[o];const n=Oo(t,o,l);s.push(n),\"auto\"===r&&(n.visible=Ao(n,h),n.visible&&(h=n))}return s}(t,s,o)}function Co(t,e,i,s,n){const o=Math.abs(Math.sin(i)),a=Math.abs(Math.cos(i));let r=0,l=0;s.start<e.l?(r=(e.l-s.start)/o,t.l=Math.min(t.l,e.l-r)):s.end>e.r&&(r=(s.end-e.r)/o,t.r=Math.max(t.r,e.r+r)),n.start<e.t?(l=(e.t-n.start)/a,t.t=Math.min(t.t,e.t-l)):n.end>e.b&&(l=(n.end-e.b)/a,t.b=Math.max(t.b,e.b+l))}function Oo(t,e,i){const s=t.drawingArea,{extra:n,additionalAngle:o,padding:a,size:r}=i,l=t.getPointPosition(e,s+n+a,o),h=Math.round(Y(G(l.angle+E))),c=function(t,e,i){90===i||270===i?t-=e/2:(i>270||i<90)&&(t-=e);return t}(l.y,r.h,h),d=function(t){if(0===t||180===t)return\"center\";if(t<180)return\"left\";return\"right\"}(h),u=function(t,e,i){\"right\"===i?t-=e:\"center\"===i&&(t-=e/2);return t}(l.x,r.w,d);return{visible:!0,x:l.x,y:c,textAlign:d,left:u,top:c,right:u+r.w,bottom:c+r.h}}function Ao(t,e){if(!e)return!0;const{left:i,top:s,right:n,bottom:o}=t;return!(Re({x:i,y:s},e)||Re({x:i,y:o},e)||Re({x:n,y:s},e)||Re({x:n,y:o},e))}function To(t,e,i){const{left:n,top:o,right:a,bottom:r}=i,{backdropColor:l}=e;if(!s(l)){const i=wi(e.borderRadius),s=ki(e.backdropPadding);t.fillStyle=l;const h=n-s.left,c=o-s.top,d=a-n+s.width,u=r-o+s.height;Object.values(i).some((t=>0!==t))?(t.beginPath(),He(t,{x:h,y:c,w:d,h:u,radius:i}),t.fill()):t.fillRect(h,c,d,u)}}function Lo(t,e,i,s){const{ctx:n}=t;if(i)n.arc(t.xCenter,t.yCenter,e,0,O);else{let i=t.getPointPosition(0,e);n.moveTo(i.x,i.y);for(let o=1;o<s;o++)i=t.getPointPosition(o,e),n.lineTo(i.x,i.y)}}class Eo extends bo{static id=\"radialLinear\";static defaults={display:!0,animate:!0,position:\"chartArea\",angleLines:{display:!0,lineWidth:1,borderDash:[],borderDashOffset:0},grid:{circular:!1},startAngle:0,ticks:{showLabelBackdrop:!0,callback:ae.formatters.numeric},pointLabels:{backdropColor:void 0,backdropPadding:2,display:!0,font:{size:10},callback:t=>t,padding:5,centerPointLabels:!1}};static defaultRoutes={\"angleLines.color\":\"borderColor\",\"pointLabels.color\":\"color\",\"ticks.color\":\"color\"};static descriptors={angleLines:{_fallback:\"grid\"}};constructor(t){super(t),this.xCenter=void 0,this.yCenter=void 0,this.drawingArea=void 0,this._pointLabels=[],this._pointLabelItems=[]}setDimensions(){const t=this._padding=ki(So(this.options)/2),e=this.width=this.maxWidth-t.width,i=this.height=this.maxHeight-t.height;this.xCenter=Math.floor(this.left+e/2+t.left),this.yCenter=Math.floor(this.top+i/2+t.top),this.drawingArea=Math.floor(Math.min(e,i)/2)}determineDataLimits(){const{min:t,max:e}=this.getMinMax(!1);this.min=a(t)&&!isNaN(t)?t:0,this.max=a(e)&&!isNaN(e)?e:0,this.handleTickRangeOptions()}computeTickLimit(){return Math.ceil(this.drawingArea/So(this.options))}generateTickLabels(t){bo.prototype.generateTickLabels.call(this,t),this._pointLabels=this.getLabels().map(((t,e)=>{const i=d(this.options.pointLabels.callback,[t,e],this);return i||0===i?i:\"\"})).filter(((t,e)=>this.chart.getDataVisibility(e)))}fit(){const t=this.options;t.display&&t.pointLabels.display?Do(this):this.setCenterPoint(0,0,0,0)}setCenterPoint(t,e,i,s){this.xCenter+=Math.floor((t-e)/2),this.yCenter+=Math.floor((i-s)/2),this.drawingArea-=Math.min(this.drawingArea/2,Math.max(t,e,i,s))}getIndexAngle(t){return G(t*(O/(this._pointLabels.length||1))+$(this.options.startAngle||0))}getDistanceFromCenterForValue(t){if(s(t))return NaN;const e=this.drawingArea/(this.max-this.min);return this.options.reverse?(this.max-t)*e:(t-this.min)*e}getValueForDistanceFromCenter(t){if(s(t))return NaN;const e=t/(this.drawingArea/(this.max-this.min));return this.options.reverse?this.max-e:this.min+e}getPointLabelContext(t){const e=this._pointLabels||[];if(t>=0&&t<e.length){const i=e[t];return function(t,e,i){return Ci(t,{label:i,index:e,type:\"pointLabel\"})}(this.getContext(),t,i)}}getPointPosition(t,e,i=0){const s=this.getIndexAngle(t)-E+i;return{x:Math.cos(s)*e+this.xCenter,y:Math.sin(s)*e+this.yCenter,angle:s}}getPointPositionForValue(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))}getBasePosition(t){return this.getPointPositionForValue(t||0,this.getBaseValue())}getPointLabelPosition(t){const{left:e,top:i,right:s,bottom:n}=this._pointLabelItems[t];return{left:e,top:i,right:s,bottom:n}}drawBackground(){const{backgroundColor:t,grid:{circular:e}}=this.options;if(t){const i=this.ctx;i.save(),i.beginPath(),Lo(this,this.getDistanceFromCenterForValue(this._endValue),e,this._pointLabels.length),i.closePath(),i.fillStyle=t,i.fill(),i.restore()}}drawGrid(){const t=this.ctx,e=this.options,{angleLines:i,grid:s,border:n}=e,o=this._pointLabels.length;let a,r,l;if(e.pointLabels.display&&function(t,e){const{ctx:i,options:{pointLabels:s}}=t;for(let n=e-1;n>=0;n--){const e=t._pointLabelItems[n];if(!e.visible)continue;const o=s.setContext(t.getPointLabelContext(n));To(i,o,e);const a=Si(o.font),{x:r,y:l,textAlign:h}=e;Ne(i,t._pointLabels[n],r,l+a.lineHeight/2,a,{color:o.color,textAlign:h,textBaseline:\"middle\"})}}(this,o),s.display&&this.ticks.forEach(((t,e)=>{if(0!==e){r=this.getDistanceFromCenterForValue(t.value);const i=this.getContext(e),a=s.setContext(i),l=n.setContext(i);!function(t,e,i,s,n){const o=t.ctx,a=e.circular,{color:r,lineWidth:l}=e;!a&&!s||!r||!l||i<0||(o.save(),o.strokeStyle=r,o.lineWidth=l,o.setLineDash(n.dash),o.lineDashOffset=n.dashOffset,o.beginPath(),Lo(t,i,a,s),o.closePath(),o.stroke(),o.restore())}(this,a,r,o,l)}})),i.display){for(t.save(),a=o-1;a>=0;a--){const s=i.setContext(this.getPointLabelContext(a)),{color:n,lineWidth:o}=s;o&&n&&(t.lineWidth=o,t.strokeStyle=n,t.setLineDash(s.borderDash),t.lineDashOffset=s.borderDashOffset,r=this.getDistanceFromCenterForValue(e.ticks.reverse?this.min:this.max),l=this.getPointPosition(a,r),t.beginPath(),t.moveTo(this.xCenter,this.yCenter),t.lineTo(l.x,l.y),t.stroke())}t.restore()}}drawBorder(){}drawLabels(){const t=this.ctx,e=this.options,i=e.ticks;if(!i.display)return;const s=this.getIndexAngle(0);let n,o;t.save(),t.translate(this.xCenter,this.yCenter),t.rotate(s),t.textAlign=\"center\",t.textBaseline=\"middle\",this.ticks.forEach(((s,a)=>{if(0===a&&!e.reverse)return;const r=i.setContext(this.getContext(a)),l=Si(r.font);if(n=this.getDistanceFromCenterForValue(this.ticks[a].value),r.showLabelBackdrop){t.font=l.string,o=t.measureText(s.label).width,t.fillStyle=r.backdropColor;const e=ki(r.backdropPadding);t.fillRect(-o/2-e.left,-n-l.size/2-e.top,o+e.width,l.size+e.height)}Ne(t,s.label,0,-n,l,{color:r.color,strokeColor:r.textStrokeColor,strokeWidth:r.textStrokeWidth})})),t.restore()}drawTitle(){}}const Ro={millisecond:{common:!0,size:1,steps:1e3},second:{common:!0,size:1e3,steps:60},minute:{common:!0,size:6e4,steps:60},hour:{common:!0,size:36e5,steps:24},day:{common:!0,size:864e5,steps:30},week:{common:!1,size:6048e5,steps:4},month:{common:!0,size:2628e6,steps:12},quarter:{common:!1,size:7884e6,steps:4},year:{common:!0,size:3154e7}},Io=Object.keys(Ro);function zo(t,e){return t-e}function Fo(t,e){if(s(e))return null;const i=t._adapter,{parser:n,round:o,isoWeekday:r}=t._parseOpts;let l=e;return\"function\"==typeof n&&(l=n(l)),a(l)||(l=\"string\"==typeof n?i.parse(l,n):i.parse(l)),null===l?null:(o&&(l=\"week\"!==o||!N(r)&&!0!==r?i.startOf(l,o):i.startOf(l,\"isoWeek\",r)),+l)}function Vo(t,e,i,s){const n=Io.length;for(let o=Io.indexOf(t);o<n-1;++o){const t=Ro[Io[o]],n=t.steps?t.steps:Number.MAX_SAFE_INTEGER;if(t.common&&Math.ceil((i-e)/(n*t.size))<=s)return Io[o]}return Io[n-1]}function Bo(t,e,i){if(i){if(i.length){const{lo:s,hi:n}=et(i,e);t[i[s]>=e?i[s]:i[n]]=!0}}else t[e]=!0}function Wo(t,e,i){const s=[],n={},o=e.length;let a,r;for(a=0;a<o;++a)r=e[a],n[r]=a,s.push({value:r,major:!1});return 0!==o&&i?function(t,e,i,s){const n=t._adapter,o=+n.startOf(e[0].value,s),a=e[e.length-1].value;let r,l;for(r=o;r<=a;r=+n.add(r,1,s))l=i[r],l>=0&&(e[l].major=!0);return e}(t,s,n,i):s}class No extends Js{static id=\"time\";static defaults={bounds:\"data\",adapters:{},time:{parser:!1,unit:!1,round:!1,isoWeekday:!1,minUnit:\"millisecond\",displayFormats:{}},ticks:{source:\"auto\",callback:!1,major:{enabled:!1}}};constructor(t){super(t),this._cache={data:[],labels:[],all:[]},this._unit=\"day\",this._majorUnit=void 0,this._offsets={},this._normalized=!1,this._parseOpts=void 0}init(t,e={}){const i=t.time||(t.time={}),s=this._adapter=new Rn._date(t.adapters.date);s.init(e),x(i.displayFormats,s.formats()),this._parseOpts={parser:i.parser,round:i.round,isoWeekday:i.isoWeekday},super.init(t),this._normalized=e.normalized}parse(t,e){return void 0===t?null:Fo(this,t)}beforeLayout(){super.beforeLayout(),this._cache={data:[],labels:[],all:[]}}determineDataLimits(){const t=this.options,e=this._adapter,i=t.time.unit||\"day\";let{min:s,max:n,minDefined:o,maxDefined:r}=this.getUserBounds();function l(t){o||isNaN(t.min)||(s=Math.min(s,t.min)),r||isNaN(t.max)||(n=Math.max(n,t.max))}o&&r||(l(this._getLabelBounds()),\"ticks\"===t.bounds&&\"labels\"===t.ticks.source||l(this.getMinMax(!1))),s=a(s)&&!isNaN(s)?s:+e.startOf(Date.now(),i),n=a(n)&&!isNaN(n)?n:+e.endOf(Date.now(),i)+1,this.min=Math.min(s,n-1),this.max=Math.max(s+1,n)}_getLabelBounds(){const t=this.getLabelTimestamps();let e=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY;return t.length&&(e=t[0],i=t[t.length-1]),{min:e,max:i}}buildTicks(){const t=this.options,e=t.time,i=t.ticks,s=\"labels\"===i.source?this.getLabelTimestamps():this._generate();\"ticks\"===t.bounds&&s.length&&(this.min=this._userMin||s[0],this.max=this._userMax||s[s.length-1]);const n=this.min,o=nt(s,n,this.max);return this._unit=e.unit||(i.autoSkip?Vo(e.minUnit,this.min,this.max,this._getLabelCapacity(n)):function(t,e,i,s,n){for(let o=Io.length-1;o>=Io.indexOf(i);o--){const i=Io[o];if(Ro[i].common&&t._adapter.diff(n,s,i)>=e-1)return i}return Io[i?Io.indexOf(i):0]}(this,o.length,e.minUnit,this.min,this.max)),this._majorUnit=i.major.enabled&&\"year\"!==this._unit?function(t){for(let e=Io.indexOf(t)+1,i=Io.length;e<i;++e)if(Ro[Io[e]].common)return Io[e]}(this._unit):void 0,this.initOffsets(s),t.reverse&&o.reverse(),Wo(this,o,this._majorUnit)}afterAutoSkip(){this.options.offsetAfterAutoskip&&this.initOffsets(this.ticks.map((t=>+t.value)))}initOffsets(t=[]){let e,i,s=0,n=0;this.options.offset&&t.length&&(e=this.getDecimalForValue(t[0]),s=1===t.length?1-e:(this.getDecimalForValue(t[1])-e)/2,i=this.getDecimalForValue(t[t.length-1]),n=1===t.length?i:(i-this.getDecimalForValue(t[t.length-2]))/2);const o=t.length<3?.5:.25;s=J(s,0,o),n=J(n,0,o),this._offsets={start:s,end:n,factor:1/(s+1+n)}}_generate(){const t=this._adapter,e=this.min,i=this.max,s=this.options,n=s.time,o=n.unit||Vo(n.minUnit,e,i,this._getLabelCapacity(e)),a=l(s.ticks.stepSize,1),r=\"week\"===o&&n.isoWeekday,h=N(r)||!0===r,c={};let d,u,f=e;if(h&&(f=+t.startOf(f,\"isoWeek\",r)),f=+t.startOf(f,h?\"day\":o),t.diff(i,e,o)>1e5*a)throw new Error(e+\" and \"+i+\" are too far apart with stepSize of \"+a+\" \"+o);const g=\"data\"===s.ticks.source&&this.getDataTimestamps();for(d=f,u=0;d<i;d=+t.add(d,a,o),u++)Bo(c,d,g);return d!==i&&\"ticks\"!==s.bounds&&1!==u||Bo(c,d,g),Object.keys(c).sort(zo).map((t=>+t))}getLabelForValue(t){const e=this._adapter,i=this.options.time;return i.tooltipFormat?e.format(t,i.tooltipFormat):e.format(t,i.displayFormats.datetime)}format(t,e){const i=this.options.time.displayFormats,s=this._unit,n=e||i[s];return this._adapter.format(t,n)}_tickFormatFunction(t,e,i,s){const n=this.options,o=n.ticks.callback;if(o)return d(o,[t,e,i],this);const a=n.time.displayFormats,r=this._unit,l=this._majorUnit,h=r&&a[r],c=l&&a[l],u=i[e],f=l&&c&&u&&u.major;return this._adapter.format(t,s||(f?c:h))}generateTickLabels(t){let e,i,s;for(e=0,i=t.length;e<i;++e)s=t[e],s.label=this._tickFormatFunction(s.value,e,t)}getD