require.config({"config": {
        "jsbuild":{"jquery/jstree/jquery.jstree.js":"/*globals jQuery, define, module, exports, require, window, document, postMessage */\n(function (factory) {\n    \"use strict\";\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery'], factory);\n    }\n    else if(typeof module !== 'undefined' && module.exports) {\n        module.exports = factory(require('jquery'));\n    }\n    else {\n        factory(jQuery);\n    }\n}(function ($, undefined) {\n    \"use strict\";\n    /*!\n * jsTree 3.3.16\n * http://jstree.com/\n *\n * Copyright (c) 2014 Ivan Bozhanov (http://vakata.com)\n *\n * Licensed same as jquery - under the terms of the MIT License\n *   http://www.opensource.org/licenses/mit-license.php\n */\n    /*!\n * if using jslint please allow for the jQuery global and use following options:\n * jslint: loopfunc: true, browser: true, ass: true, bitwise: true, continue: true, nomen: true, plusplus: true, regexp: true, unparam: true, todo: true, white: true\n */\n    /*jshint -W083 */\n\n    // prevent another load? maybe there is a better way?\n    if($.jstree) {\n        return;\n    }\n\n    /**\n     * ### jsTree core functionality\n     */\n\n        // internal variables\n    var instance_counter = 0,\n        ccp_node = false,\n        ccp_mode = false,\n        ccp_inst = false,\n        themes_loaded = [],\n        src = $('script:last').attr('src'),\n        document = window.document; // local variable is always faster to access then a global\n\n    var setImmediate = window.setImmediate;\n    var Promise = window.Promise;\n    if (!setImmediate && Promise) {\n        // Good enough approximation of setImmediate\n        setImmediate = function (cb, arg) {\n            Promise.resolve(arg).then(cb);\n        };\n    }\n\n    /**\n     * holds all jstree related functions and variables, including the actual class and methods to create, access and manipulate instances.\n     * @name $.jstree\n     */\n    $.jstree = {\n        /**\n         * specifies the jstree version in use\n         * @name $.jstree.version\n         */\n        version : '3.3.16',\n        /**\n         * holds all the default options used when creating new instances\n         * @name $.jstree.defaults\n         */\n        defaults : {\n            /**\n             * configure which plugins will be active on an instance. Should be an array of strings, where each element is a plugin name. The default is `[]`\n             * @name $.jstree.defaults.plugins\n             */\n            plugins : []\n        },\n        /**\n         * stores all loaded jstree plugins (used internally)\n         * @name $.jstree.plugins\n         */\n        plugins : {},\n        path : src && src.indexOf('/') !== -1 ? src.replace(/\\/[^\\/]+$/,'') : '',\n        idregex : /[\\\\:&!^|()\\[\\]<>@*'+~#\";.,=\\- \\/${}%?`]/g,\n        root : '#'\n    };\n\n    /**\n     * creates a jstree instance\n     * @name $.jstree.create(el [, options])\n     * @param {DOMElement|jQuery|String} el the element to create the instance on, can be jQuery extended or a selector\n     * @param {Object} options options for this instance (extends `$.jstree.defaults`)\n     * @return {jsTree} the new instance\n     */\n    $.jstree.create = function (el, options) {\n        var tmp = new $.jstree.core(++instance_counter),\n            opt = options;\n        options = $.extend(true, {}, $.jstree.defaults, options);\n        if(opt && opt.plugins) {\n            options.plugins = opt.plugins;\n        }\n        $.each(options.plugins, function (i, k) {\n            if(i !== 'core') {\n                tmp = tmp.plugin(k, options[k]);\n            }\n        });\n        $(el).data('jstree', tmp);\n        tmp.init(el, options);\n        return tmp;\n    };\n    /**\n     * remove all traces of jstree from the DOM and destroy all instances\n     * @name $.jstree.destroy()\n     */\n    $.jstree.destroy = function () {\n        $('.jstree:jstree').jstree('destroy');\n        $(document).off('.jstree');\n    };\n    /**\n     * the jstree class constructor, used only internally\n     * @private\n     * @name $.jstree.core(id)\n     * @param {Number} id this instance's index\n     */\n    $.jstree.core = function (id) {\n        this._id = id;\n        this._cnt = 0;\n        this._wrk = null;\n        this._data = {\n            core : {\n                themes : {\n                    name : false,\n                    dots : false,\n                    icons : false,\n                    ellipsis : false\n                },\n                selected : [],\n                last_error : {},\n                working : false,\n                worker_queue : [],\n                focused : null\n            }\n        };\n    };\n    /**\n     * get a reference to an existing instance\n     *\n     * __Examples__\n     *\n     *\t// provided a container with an ID of \"tree\", and a nested node with an ID of \"branch\"\n     *\t// all of there will return the same instance\n     *\t$.jstree.reference('tree');\n     *\t$.jstree.reference('#tree');\n     *\t$.jstree.reference($('#tree'));\n     *\t$.jstree.reference(document.getElementByID('tree'));\n     *\t$.jstree.reference('branch');\n     *\t$.jstree.reference('#branch');\n     *\t$.jstree.reference($('#branch'));\n     *\t$.jstree.reference(document.getElementByID('branch'));\n     *\n     * @name $.jstree.reference(needle)\n     * @param {DOMElement|jQuery|String} needle\n     * @return {jsTree|null} the instance or `null` if not found\n     */\n    $.jstree.reference = function (needle) {\n        var tmp = null,\n            obj = null;\n        if(needle && needle.id && (!needle.tagName || !needle.nodeType)) { needle = needle.id; }\n\n        if(!obj || !obj.length) {\n            try { obj = $(needle); } catch (ignore) { }\n        }\n        if(!obj || !obj.length) {\n            try { obj = $('#' + needle.replace($.jstree.idregex,'\\\\$&')); } catch (ignore) { }\n        }\n        if(obj && obj.length && (obj = obj.closest('.jstree')).length && (obj = obj.data('jstree'))) {\n            tmp = obj;\n        }\n        else {\n            $('.jstree').each(function () {\n                var inst = $(this).data('jstree');\n                if(inst && inst._model.data[needle]) {\n                    tmp = inst;\n                    return false;\n                }\n            });\n        }\n        return tmp;\n    };\n    /**\n     * Create an instance, get an instance or invoke a command on a instance.\n     *\n     * If there is no instance associated with the current node a new one is created and `arg` is used to extend `$.jstree.defaults` for this new instance. There would be no return value (chaining is not broken).\n     *\n     * If there is an existing instance and `arg` is a string the command specified by `arg` is executed on the instance, with any additional arguments passed to the function. If the function returns a value it will be returned (chaining could break depending on function).\n     *\n     * If there is an existing instance and `arg` is not a string the instance itself is returned (similar to `$.jstree.reference`).\n     *\n     * In any other case - nothing is returned and chaining is not broken.\n     *\n     * __Examples__\n     *\n     *\t$('#tree1').jstree(); // creates an instance\n     *\t$('#tree2').jstree({ plugins : [] }); // create an instance with some options\n     *\t$('#tree1').jstree('open_node', '#branch_1'); // call a method on an existing instance, passing additional arguments\n     *\t$('#tree2').jstree(); // get an existing instance (or create an instance)\n     *\t$('#tree2').jstree(true); // get an existing instance (will not create new instance)\n     *\t$('#branch_1').jstree().select_node('#branch_1'); // get an instance (using a nested element and call a method)\n     *\n     * @name $().jstree([arg])\n     * @param {String|Object} arg\n     * @return {Mixed}\n     */\n    $.fn.jstree = function (arg) {\n        // check for string argument\n        var is_method\t= (typeof arg === 'string'),\n            args\t\t= Array.prototype.slice.call(arguments, 1),\n            result\t\t= null;\n        if(arg === true && !this.length) { return false; }\n        this.each(function () {\n            // get the instance (if there is one) and method (if it exists)\n            var instance = $.jstree.reference(this),\n                method = is_method && instance ? instance[arg] : null;\n            // if calling a method, and method is available - execute on the instance\n            result = is_method && method ?\n                method.apply(instance, args) :\n                null;\n            // if there is no instance and no method is being called - create one\n            if(!instance && !is_method && (arg === undefined || $.isPlainObject(arg))) {\n                $.jstree.create(this, arg);\n            }\n            // if there is an instance and no method is called - return the instance\n            if( (instance && !is_method) || arg === true ) {\n                result = instance || false;\n            }\n            // if there was a method call which returned a result - break and return the value\n            if(result !== null && result !== undefined) {\n                return false;\n            }\n        });\n        // if there was a method call with a valid return value - return that, otherwise continue the chain\n        return result !== null && result !== undefined ?\n            result : this;\n    };\n    /**\n     * used to find elements containing an instance\n     *\n     * __Examples__\n     *\n     *\t$('div:jstree').each(function () {\n     *\t\t$(this).jstree('destroy');\n     *\t});\n     *\n     * @name $(':jstree')\n     * @return {jQuery}\n     */\n    $.expr.pseudos.jstree = $.expr.createPseudo(function(search) {\n        return function(a) {\n            return $(a).hasClass('jstree') &&\n                $(a).data('jstree') !== undefined;\n        };\n    });\n\n    /**\n     * stores all defaults for the core\n     * @name $.jstree.defaults.core\n     */\n    $.jstree.defaults.core = {\n        /**\n         * data configuration\n         *\n         * If left as `false` the HTML inside the jstree container element is used to populate the tree (that should be an unordered list with list items).\n         *\n         * You can also pass in a HTML string or a JSON array here.\n         *\n         * It is possible to pass in a standard jQuery-like AJAX config and jstree will automatically determine if the response is JSON or HTML and use that to populate the tree.\n         * In addition to the standard jQuery ajax options here you can supply functions for `data` and `url`, the functions will be run in the current instance's scope and a param will be passed indicating which node is being loaded, the return value of those functions will be used.\n         *\n         * The last option is to specify a function, that function will receive the node being loaded as argument and a second param which is a function which should be called with the result.\n         *\n         * __Examples__\n         *\n         *\t// AJAX\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : {\n         *\t\t\t\t'url' : '/get/children/',\n         *\t\t\t\t'data' : function (node) {\n         *\t\t\t\t\treturn { 'id' : node.id };\n         *\t\t\t\t}\n         *\t\t\t}\n         *\t\t});\n         *\n         *\t// direct data\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : [\n         *\t\t\t\t'Simple root node',\n         *\t\t\t\t{\n         *\t\t\t\t\t'id' : 'node_2',\n         *\t\t\t\t\t'text' : 'Root node with options',\n         *\t\t\t\t\t'state' : { 'opened' : true, 'selected' : true },\n         *\t\t\t\t\t'children' : [ { 'text' : 'Child 1' }, 'Child 2']\n         *\t\t\t\t}\n         *\t\t\t]\n         *\t\t}\n         *\t});\n         *\n         *\t// function\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : function (obj, callback) {\n         *\t\t\t\tcallback.call(this, ['Root 1', 'Root 2']);\n         *\t\t\t}\n         *\t\t});\n         *\n         * @name $.jstree.defaults.core.data\n         */\n        data\t\t\t: false,\n        /**\n         * configure the various strings used throughout the tree\n         *\n         * You can use an object where the key is the string you need to replace and the value is your replacement.\n         * Another option is to specify a function which will be called with an argument of the needed string and should return the replacement.\n         * If left as `false` no replacement is made.\n         *\n         * __Examples__\n         *\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'strings' : {\n         *\t\t\t\t'Loading ...' : 'Please wait ...'\n         *\t\t\t}\n         *\t\t}\n         *\t});\n         *\n         * @name $.jstree.defaults.core.strings\n         */\n        strings\t\t\t: false,\n        /**\n         * determines what happens when a user tries to modify the structure of the tree\n         * If left as `false` all operations like create, rename, delete, move or copy are prevented.\n         * You can set this to `true` to allow all interactions or use a function to have better control.\n         *\n         * __Examples__\n         *\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'check_callback' : function (operation, node, node_parent, node_position, more) {\n         *\t\t\t\t// operation can be 'create_node', 'rename_node', 'delete_node', 'move_node', 'copy_node' or 'edit'\n         *\t\t\t\t// in case of 'rename_node' node_position is filled with the new node name\n         *\t\t\t\treturn operation === 'rename_node' ? true : false;\n         *\t\t\t}\n         *\t\t}\n         *\t});\n         *\n         * @name $.jstree.defaults.core.check_callback\n         */\n        check_callback\t: false,\n        /**\n         * a callback called with a single object parameter in the instance's scope when something goes wrong (operation prevented, ajax failed, etc)\n         * @name $.jstree.defaults.core.error\n         */\n        error\t\t\t: $.noop,\n        /**\n         * the open / close animation duration in milliseconds - set this to `false` to disable the animation (default is `200`)\n         * @name $.jstree.defaults.core.animation\n         */\n        animation\t\t: 200,\n        /**\n         * a boolean indicating if multiple nodes can be selected\n         * @name $.jstree.defaults.core.multiple\n         */\n        multiple\t\t: true,\n        /**\n         * theme configuration object\n         * @name $.jstree.defaults.core.themes\n         */\n        themes\t\t\t: {\n            /**\n             * the name of the theme to use (if left as `false` the default theme is used)\n             * @name $.jstree.defaults.core.themes.name\n             */\n            name\t\t\t: false,\n            /**\n             * the URL of the theme's CSS file, leave this as `false` if you have manually included the theme CSS (recommended). You can set this to `true` too which will try to autoload the theme.\n             * @name $.jstree.defaults.core.themes.url\n             */\n            url\t\t\t\t: false,\n            /**\n             * the location of all jstree themes - only used if `url` is set to `true`\n             * @name $.jstree.defaults.core.themes.dir\n             */\n            dir\t\t\t\t: false,\n            /**\n             * a boolean indicating if connecting dots are shown\n             * @name $.jstree.defaults.core.themes.dots\n             */\n            dots\t\t\t: true,\n            /**\n             * a boolean indicating if node icons are shown\n             * @name $.jstree.defaults.core.themes.icons\n             */\n            icons\t\t\t: true,\n            /**\n             * a boolean indicating if node ellipsis should be shown - this only works with a fixed with on the container\n             * @name $.jstree.defaults.core.themes.ellipsis\n             */\n            ellipsis\t\t: false,\n            /**\n             * a boolean indicating if the tree background is striped\n             * @name $.jstree.defaults.core.themes.stripes\n             */\n            stripes\t\t\t: false,\n            /**\n             * a string (or boolean `false`) specifying the theme variant to use (if the theme supports variants)\n             * @name $.jstree.defaults.core.themes.variant\n             */\n            variant\t\t\t: false,\n            /**\n             * a boolean specifying if a reponsive version of the theme should kick in on smaller screens (if the theme supports it). Defaults to `false`.\n             * @name $.jstree.defaults.core.themes.responsive\n             */\n            responsive\t\t: false\n        },\n        /**\n         * if left as `true` all parents of all selected nodes will be opened once the tree loads (so that all selected nodes are visible to the user)\n         * @name $.jstree.defaults.core.expand_selected_onload\n         */\n        expand_selected_onload : true,\n        /**\n         * if left as `true` web workers will be used to parse incoming JSON data where possible, so that the UI will not be blocked by large requests. Workers are however about 30% slower. Defaults to `true`\n         * @name $.jstree.defaults.core.worker\n         */\n        worker : true,\n        /**\n         * Force node text to plain text (and escape HTML). Defaults to `false`\n         * @name $.jstree.defaults.core.force_text\n         */\n        force_text : false,\n        /**\n         * Should the node be toggled if the text is double clicked. Defaults to `true`\n         * @name $.jstree.defaults.core.dblclick_toggle\n         */\n        dblclick_toggle : true,\n        /**\n         * Should the loaded nodes be part of the state. Defaults to `false`\n         * @name $.jstree.defaults.core.loaded_state\n         */\n        loaded_state : false,\n        /**\n         * Should the last active node be focused when the tree container is blurred and the focused again. This helps working with screen readers. Defaults to `true`\n         * @name $.jstree.defaults.core.restore_focus\n         */\n        restore_focus : true,\n        /**\n         * Force to compute and set \"aria-setsize\" and \"aria-posinset\" explicitly for each treeitem.\n         * Some browsers may compute incorrect elements position and produce wrong announcements for screen readers. Defaults to `false`\n         * @name $.jstree.defaults.core.compute_elements_positions\n         */\n        compute_elements_positions : false,\n        /**\n         * Default keyboard shortcuts (an object where each key is the button name or combo - like 'enter', 'ctrl-space', 'p', etc and the value is the function to execute in the instance's scope)\n         * @name $.jstree.defaults.core.keyboard\n         */\n        keyboard : {\n            'ctrl-space': function (e) {\n                // aria defines space only with Ctrl\n                e.type = \"click\";\n                $(e.currentTarget).trigger(e);\n            },\n            'enter': function (e) {\n                // enter\n                e.type = \"click\";\n                $(e.currentTarget).trigger(e);\n            },\n            'left': function (e) {\n                // left\n                e.preventDefault();\n                if(this.is_open(e.currentTarget)) {\n                    this.close_node(e.currentTarget);\n                }\n                else {\n                    var o = this.get_parent(e.currentTarget);\n                    if(o && o.id !== $.jstree.root) { this.get_node(o, true).children('.jstree-anchor').trigger('focus'); }\n                }\n            },\n            'up': function (e) {\n                // up\n                e.preventDefault();\n                var o = this.get_prev_dom(e.currentTarget);\n                if(o && o.length) { o.children('.jstree-anchor').trigger('focus'); }\n            },\n            'right': function (e) {\n                // right\n                e.preventDefault();\n                if(this.is_closed(e.currentTarget)) {\n                    this.open_node(e.currentTarget, function (o) { this.get_node(o, true).children('.jstree-anchor').trigger('focus'); });\n                }\n                else if (this.is_open(e.currentTarget)) {\n                    var o = this.get_node(e.currentTarget, true).children('.jstree-children')[0];\n                    if(o) { $(this._firstChild(o)).children('.jstree-anchor').trigger('focus'); }\n                }\n            },\n            'down': function (e) {\n                // down\n                e.preventDefault();\n                var o = this.get_next_dom(e.currentTarget);\n                if(o && o.length) { o.children('.jstree-anchor').trigger('focus'); }\n            },\n            '*': function (e) {\n                // aria defines * on numpad as open_all - not very common\n                this.open_all();\n            },\n            'home': function (e) {\n                // home\n                e.preventDefault();\n                var o = this._firstChild(this.get_container_ul()[0]);\n                if(o) { $(o).children('.jstree-anchor').filter(':visible').trigger('focus'); }\n            },\n            'end': function (e) {\n                // end\n                e.preventDefault();\n                this.element.find('.jstree-anchor').filter(':visible').last().trigger('focus');\n            },\n            'f2': function (e) {\n                // f2 - safe to include - if check_callback is false it will fail\n                e.preventDefault();\n                this.edit(e.currentTarget);\n            }\n        },\n        /**\n         * Should reselecting an already selected node trigger the select and changed callbacks\n         * @name $.jstree.defaults.core.allow_reselect\n         */\n        allow_reselect : false\n    };\n    $.jstree.core.prototype = {\n        /**\n         * used to decorate an instance with a plugin. Used internally.\n         * @private\n         * @name plugin(deco [, opts])\n         * @param  {String} deco the plugin to decorate with\n         * @param  {Object} opts options for the plugin\n         * @return {jsTree}\n         */\n        plugin : function (deco, opts) {\n            var Child = $.jstree.plugins[deco];\n            if(Child) {\n                this._data[deco] = {};\n                Child.prototype = this;\n                return new Child(opts, this);\n            }\n            return this;\n        },\n        /**\n         * initialize the instance. Used internally.\n         * @private\n         * @name init(el, optons)\n         * @param {DOMElement|jQuery|String} el the element we are transforming\n         * @param {Object} options options for this instance\n         * @trigger init.jstree, loading.jstree, loaded.jstree, ready.jstree, changed.jstree\n         */\n        init : function (el, options) {\n            this._model = {\n                data : {},\n                changed : [],\n                force_full_redraw : false,\n                redraw_timeout : false,\n                default_state : {\n                    loaded : true,\n                    opened : false,\n                    selected : false,\n                    disabled : false\n                }\n            };\n            this._model.data[$.jstree.root] = {\n                id : $.jstree.root,\n                parent : null,\n                parents : [],\n                children : [],\n                children_d : [],\n                state : { loaded : false }\n            };\n\n            this.element = $(el).addClass('jstree jstree-' + this._id);\n            this.settings = options;\n\n            this._data.core.ready = false;\n            this._data.core.loaded = false;\n            this._data.core.rtl = (this.element.css(\"direction\") === \"rtl\");\n            this.element[this._data.core.rtl ? 'addClass' : 'removeClass'](\"jstree-rtl\");\n            this.element.attr('role','tree');\n            if(this.settings.core.multiple) {\n                this.element.attr('aria-multiselectable', true);\n            }\n            if(!this.element.attr('tabindex')) {\n                this.element.attr('tabindex','0');\n            }\n\n            this.bind();\n            /**\n             * triggered after all events are bound\n             * @event\n             * @name init.jstree\n             */\n            this.trigger(\"init\");\n\n            this._data.core.original_container_html = this.element.find(\" > ul > li\").clone(true);\n            this._data.core.original_container_html\n                .find(\"li\").addBack()\n                .contents().filter(function() {\n                return this.nodeType === 3 && (!this.nodeValue || /^\\s+$/.test(this.nodeValue));\n            })\n                .remove();\n            this.element.html(\"<\"+\"ul class='jstree-container-ul jstree-children' role='group'><\"+\"li id='j\"+this._id+\"_loading' class='jstree-initial-node jstree-loading jstree-leaf jstree-last' role='none'><i class='jstree-icon jstree-ocl'></i><\"+\"a class='jstree-anchor' role='treeitem' href='#'><i class='jstree-icon jstree-themeicon-hidden'></i>\" + this.get_string(\"Loading ...\") + \"</a></li></ul>\");\n            this.element.attr('aria-activedescendant','j' + this._id + '_loading');\n            this._data.core.li_height = this.get_container_ul().children(\"li\").first().outerHeight() || 24;\n            this._data.core.node = this._create_prototype_node();\n            /**\n             * triggered after the loading text is shown and before loading starts\n             * @event\n             * @name loading.jstree\n             */\n            this.trigger(\"loading\");\n            this.load_node($.jstree.root);\n        },\n        /**\n         * destroy an instance\n         * @name destroy()\n         * @param  {Boolean} keep_html if not set to `true` the container will be emptied, otherwise the current DOM elements will be kept intact\n         */\n        destroy : function (keep_html) {\n            /**\n             * triggered before the tree is destroyed\n             * @event\n             * @name destroy.jstree\n             */\n            this.trigger(\"destroy\");\n            if(this._wrk) {\n                try {\n                    window.URL.revokeObjectURL(this._wrk);\n                    this._wrk = null;\n                }\n                catch (ignore) { }\n            }\n            if(!keep_html) { this.element.empty(); }\n            this.teardown();\n        },\n        /**\n         * Create a prototype node\n         * @name _create_prototype_node()\n         * @return {DOMElement}\n         */\n        _create_prototype_node : function () {\n            var _node = document.createElement('LI'), _temp1, _temp2;\n            _node.setAttribute('role', 'none');\n            _temp1 = document.createElement('I');\n            _temp1.className = 'jstree-icon jstree-ocl';\n            _temp1.setAttribute('role', 'presentation');\n            _node.appendChild(_temp1);\n            _temp1 = document.createElement('A');\n            _temp1.className = 'jstree-anchor';\n            _temp1.setAttribute('href','#');\n            _temp1.setAttribute('tabindex','-1');\n            _temp1.setAttribute('role', 'treeitem');\n            _temp2 = document.createElement('I');\n            _temp2.className = 'jstree-icon jstree-themeicon';\n            _temp2.setAttribute('role', 'presentation');\n            _temp1.appendChild(_temp2);\n            _node.appendChild(_temp1);\n            _temp1 = _temp2 = null;\n\n            return _node;\n        },\n        _kbevent_to_func : function (e) {\n            var keys = {\n                8: \"Backspace\", 9: \"Tab\", 13: \"Enter\", 19: \"Pause\", 27: \"Esc\",\n                32: \"Space\", 33: \"PageUp\", 34: \"PageDown\", 35: \"End\", 36: \"Home\",\n                37: \"Left\", 38: \"Up\", 39: \"Right\", 40: \"Down\", 44: \"Print\", 45: \"Insert\",\n                46: \"Delete\", 96: \"Numpad0\", 97: \"Numpad1\", 98: \"Numpad2\", 99 : \"Numpad3\",\n                100: \"Numpad4\", 101: \"Numpad5\", 102: \"Numpad6\", 103: \"Numpad7\",\n                104: \"Numpad8\", 105: \"Numpad9\", '-13': \"NumpadEnter\", 112: \"F1\",\n                113: \"F2\", 114: \"F3\", 115: \"F4\", 116: \"F5\", 117: \"F6\", 118: \"F7\",\n                119: \"F8\", 120: \"F9\", 121: \"F10\", 122: \"F11\", 123: \"F12\", 144: \"Numlock\",\n                145: \"Scrolllock\", 16: 'Shift', 17: 'Ctrl', 18: 'Alt',\n                48: '0',  49: '1',  50: '2',  51: '3',  52: '4', 53:  '5',\n                54: '6',  55: '7',  56: '8',  57: '9',  59: ';',  61: '=', 65:  'a',\n                66: 'b',  67: 'c',  68: 'd',  69: 'e',  70: 'f',  71: 'g', 72:  'h',\n                73: 'i',  74: 'j',  75: 'k',  76: 'l',  77: 'm',  78: 'n', 79:  'o',\n                80: 'p',  81: 'q',  82: 'r',  83: 's',  84: 't',  85: 'u', 86:  'v',\n                87: 'w',  88: 'x',  89: 'y',  90: 'z', 107: '+', 109: '-', 110: '.',\n                186: ';', 187: '=', 188: ',', 189: '-', 190: '.', 191: '/', 192: '`',\n                219: '[', 220: '\\\\',221: ']', 222: \"'\", 111: '/', 106: '*', 173: '-'\n            };\n            var parts = [];\n            if (e.ctrlKey) { parts.push('ctrl'); }\n            if (e.altKey) { parts.push('alt'); }\n            if (e.shiftKey) { parts.push('shift'); }\n            parts.push(keys[e.which] ? keys[e.which].toLowerCase() : e.which);\n            parts = parts.sort().join('-').toLowerCase();\n            if (parts === 'shift-shift' || parts === 'ctrl-ctrl' || parts === 'alt-alt') {\n                return null;\n            }\n\n            var kb = this.settings.core.keyboard, i, tmp;\n            for (i in kb) {\n                if (kb.hasOwnProperty(i)) {\n                    tmp = i;\n                    if (tmp !== '-' && tmp !== '+') {\n                        tmp = tmp.replace('--', '-MINUS').replace('+-', '-MINUS').replace('++', '-PLUS').replace('-+', '-PLUS');\n                        tmp = tmp.split(/-|\\+/).sort().join('-').replace('MINUS', '-').replace('PLUS', '+').toLowerCase();\n                    }\n                    if (tmp === parts) {\n                        return kb[i];\n                    }\n                }\n            }\n            return null;\n        },\n        /**\n         * part of the destroying of an instance. Used internally.\n         * @private\n         * @name teardown()\n         */\n        teardown : function () {\n            this.unbind();\n            this.element\n                .removeClass('jstree')\n                .removeData('jstree')\n                .find(\"[class^='jstree']\")\n                .addBack()\n                .attr(\"class\", function () { return this.className.replace(/jstree[^ ]*|$/ig,''); });\n            this.element = null;\n        },\n        /**\n         * bind all events. Used internally.\n         * @private\n         * @name bind()\n         */\n        bind : function () {\n            var word = '',\n                tout = null,\n                was_click = 0;\n            this.element\n                .on(\"dblclick.jstree\", function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(document.selection && document.selection.empty) {\n                        document.selection.empty();\n                    }\n                    else {\n                        if(window.getSelection) {\n                            var sel = window.getSelection();\n                            try {\n                                sel.removeAllRanges();\n                                sel.collapse();\n                            } catch (ignore) { }\n                        }\n                    }\n                })\n                .on(\"mousedown.jstree\", function (e) {\n                    if(e.target === this.element[0]) {\n                        e.preventDefault(); // prevent losing focus when clicking scroll arrows (FF, Chrome)\n                        was_click = +(new Date()); // ie does not allow to prevent losing focus\n                    }\n                }.bind(this))\n                .on(\"mousedown.jstree\", \".jstree-ocl\", function (e) {\n                    e.preventDefault(); // prevent any node inside from losing focus when clicking the open/close icon\n                })\n                .on(\"click.jstree\", \".jstree-ocl\", function (e) {\n                    this.toggle_node(e.target);\n                }.bind(this))\n                .on(\"dblclick.jstree\", \".jstree-anchor\", function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(this.settings.core.dblclick_toggle) {\n                        this.toggle_node(e.target);\n                    }\n                }.bind(this))\n                .on(\"click.jstree\", \".jstree-anchor\", function (e) {\n                    e.preventDefault();\n                    if(e.currentTarget !== document.activeElement) { $(e.currentTarget).trigger('focus'); }\n                    this.activate_node(e.currentTarget, e);\n                }.bind(this))\n                .on('keydown.jstree', '.jstree-anchor', function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(this._data.core.rtl) {\n                        if(e.which === 37) { e.which = 39; }\n                        else if(e.which === 39) { e.which = 37; }\n                    }\n                    var f = this._kbevent_to_func(e);\n                    if (f) {\n                        var r = f.call(this, e);\n                        if (r === false || r === true) {\n                            return r;\n                        }\n                    }\n                }.bind(this))\n                .on(\"load_node.jstree\", function (e, data) {\n                    if(data.status) {\n                        if(data.node.id === $.jstree.root && !this._data.core.loaded) {\n                            this._data.core.loaded = true;\n                            if(this._firstChild(this.get_container_ul()[0])) {\n                                this.element.attr('aria-activedescendant',this._firstChild(this.get_container_ul()[0]).id);\n                            }\n                            /**\n                             * triggered after the root node is loaded for the first time\n                             * @event\n                             * @name loaded.jstree\n                             */\n                            this.trigger(\"loaded\");\n                        }\n                        if(!this._data.core.ready) {\n                            setTimeout(function() {\n                                if(this.element && !this.get_container_ul().find('.jstree-loading').length) {\n                                    this._data.core.ready = true;\n                                    if(this._data.core.selected.length) {\n                                        if(this.settings.core.expand_selected_onload) {\n                                            var tmp = [], i, j;\n                                            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                                                tmp = tmp.concat(this._model.data[this._data.core.selected[i]].parents);\n                                            }\n                                            tmp = $.vakata.array_unique(tmp);\n                                            for(i = 0, j = tmp.length; i < j; i++) {\n                                                this.open_node(tmp[i], false, 0);\n                                            }\n                                        }\n                                        this.trigger('changed', { 'action' : 'ready', 'selected' : this._data.core.selected });\n                                    }\n                                    /**\n                                     * triggered after all nodes are finished loading\n                                     * @event\n                                     * @name ready.jstree\n                                     */\n                                    this.trigger(\"ready\");\n                                }\n                            }.bind(this), 0);\n                        }\n                    }\n                }.bind(this))\n                // quick searching when the tree is focused\n                .on('keypress.jstree', function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(tout) { clearTimeout(tout); }\n                    tout = setTimeout(function () {\n                        word = '';\n                    }, 500);\n\n                    var chr = String.fromCharCode(e.which).toLowerCase(),\n                        col = this.element.find('.jstree-anchor').filter(':visible'),\n                        ind = col.index(document.activeElement) || 0,\n                        end = false;\n                    word += chr;\n\n                    // match for whole word from current node down (including the current node)\n                    if(word.length > 1) {\n                        col.slice(ind).each(function (i, v) {\n                            if($(v).text().toLowerCase().indexOf(word) === 0) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n\n                        // match for whole word from the beginning of the tree\n                        col.slice(0, ind).each(function (i, v) {\n                            if($(v).text().toLowerCase().indexOf(word) === 0) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n                    }\n                    // list nodes that start with that letter (only if word consists of a single char)\n                    if(new RegExp('^' + chr.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g, '\\\\$&') + '+$').test(word)) {\n                        // search for the next node starting with that letter\n                        col.slice(ind + 1).each(function (i, v) {\n                            if($(v).text().toLowerCase().charAt(0) === chr) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n\n                        // search from the beginning\n                        col.slice(0, ind + 1).each(function (i, v) {\n                            if($(v).text().toLowerCase().charAt(0) === chr) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n                    }\n                }.bind(this))\n                // THEME RELATED\n                .on(\"init.jstree\", function () {\n                    var s = this.settings.core.themes;\n                    this._data.core.themes.dots\t\t\t= s.dots;\n                    this._data.core.themes.stripes\t\t= s.stripes;\n                    this._data.core.themes.icons\t\t= s.icons;\n                    this._data.core.themes.ellipsis\t\t= s.ellipsis;\n                    this.set_theme(s.name || \"default\", s.url);\n                    this.set_theme_variant(s.variant);\n                }.bind(this))\n                .on(\"loading.jstree\", function () {\n                    this[ this._data.core.themes.dots ? \"show_dots\" : \"hide_dots\" ]();\n                    this[ this._data.core.themes.icons ? \"show_icons\" : \"hide_icons\" ]();\n                    this[ this._data.core.themes.stripes ? \"show_stripes\" : \"hide_stripes\" ]();\n                    this[ this._data.core.themes.ellipsis ? \"show_ellipsis\" : \"hide_ellipsis\" ]();\n                }.bind(this))\n                .on('blur.jstree', '.jstree-anchor', function (e) {\n                    this._data.core.focused = null;\n                    $(e.currentTarget).filter('.jstree-hovered').trigger('mouseleave');\n                    this.element.attr('tabindex', '0');\n                    $(e.currentTarget).attr('tabindex', '-1');\n                }.bind(this))\n                .on('focus.jstree', '.jstree-anchor', function (e) {\n                    var tmp = this.get_node(e.currentTarget);\n                    if(tmp && (tmp.id || tmp.id === 0)) {\n                        this._data.core.focused = tmp.id;\n                    }\n                    this.element.find('.jstree-hovered').not(e.currentTarget).trigger('mouseleave');\n                    $(e.currentTarget).trigger('mouseenter');\n                    this.element.attr('tabindex', '-1');\n                    $(e.currentTarget).attr('tabindex', '0');\n                }.bind(this))\n                .on('focus.jstree', function () {\n                    if(+(new Date()) - was_click > 500 && !this._data.core.focused && this.settings.core.restore_focus) {\n                        was_click = 0;\n                        var act = this.get_node(this.element.attr('aria-activedescendant'), true);\n                        if(act) {\n                            act.find('> .jstree-anchor').trigger('focus');\n                        }\n                    }\n                }.bind(this))\n                .on('mouseenter.jstree', '.jstree-anchor', function (e) {\n                    this.hover_node(e.currentTarget);\n                }.bind(this))\n                .on('mouseleave.jstree', '.jstree-anchor', function (e) {\n                    this.dehover_node(e.currentTarget);\n                }.bind(this));\n        },\n        /**\n         * part of the destroying of an instance. Used internally.\n         * @private\n         * @name unbind()\n         */\n        unbind : function () {\n            this.element.off('.jstree');\n            $(document).off('.jstree-' + this._id);\n        },\n        /**\n         * trigger an event. Used internally.\n         * @private\n         * @name trigger(ev [, data])\n         * @param  {String} ev the name of the event to trigger\n         * @param  {Object} data additional data to pass with the event\n         */\n        trigger : function (ev, data) {\n            if(!data) {\n                data = {};\n            }\n            data.instance = this;\n            this.element.triggerHandler(ev.replace('.jstree','') + '.jstree', data);\n        },\n        /**\n         * returns the jQuery extended instance container\n         * @name get_container()\n         * @return {jQuery}\n         */\n        get_container : function () {\n            return this.element;\n        },\n        /**\n         * returns the jQuery extended main UL node inside the instance container. Used internally.\n         * @private\n         * @name get_container_ul()\n         * @return {jQuery}\n         */\n        get_container_ul : function () {\n            return this.element.children(\".jstree-children\").first();\n        },\n        /**\n         * gets string replacements (localization). Used internally.\n         * @private\n         * @name get_string(key)\n         * @param  {String} key\n         * @return {String}\n         */\n        get_string : function (key) {\n            var a = this.settings.core.strings;\n            if($.vakata.is_function(a)) { return a.call(this, key); }\n            if(a && a[key]) { return a[key]; }\n            return key;\n        },\n        /**\n         * gets the first child of a DOM node. Used internally.\n         * @private\n         * @name _firstChild(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _firstChild : function (dom) {\n            dom = dom ? dom.firstChild : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.nextSibling;\n            }\n            return dom;\n        },\n        /**\n         * gets the next sibling of a DOM node. Used internally.\n         * @private\n         * @name _nextSibling(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _nextSibling : function (dom) {\n            dom = dom ? dom.nextSibling : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.nextSibling;\n            }\n            return dom;\n        },\n        /**\n         * gets the previous sibling of a DOM node. Used internally.\n         * @private\n         * @name _previousSibling(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _previousSibling : function (dom) {\n            dom = dom ? dom.previousSibling : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.previousSibling;\n            }\n            return dom;\n        },\n        /**\n         * get the JSON representation of a node (or the actual jQuery extended DOM node) by using any input (child DOM element, ID string, selector, etc)\n         * @name get_node(obj [, as_dom])\n         * @param  {mixed} obj\n         * @param  {Boolean} as_dom\n         * @return {Object|jQuery}\n         */\n        get_node : function (obj, as_dom) {\n            if(obj && (obj.id || obj.id === 0)) {\n                obj = obj.id;\n            }\n            if (obj instanceof $ && obj.length && obj[0].id) {\n                obj = obj[0].id;\n            }\n            var dom;\n            try {\n                if(this._model.data[obj]) {\n                    obj = this._model.data[obj];\n                }\n                else if(typeof obj === \"string\" && this._model.data[obj.replace(/^#/, '')]) {\n                    obj = this._model.data[obj.replace(/^#/, '')];\n                }\n                else if(typeof obj === \"string\" && (dom = $('#' + obj.replace($.jstree.idregex,'\\\\$&'), this.element)).length && this._model.data[dom.closest('.jstree-node').attr('id')]) {\n                    obj = this._model.data[dom.closest('.jstree-node').attr('id')];\n                }\n                else if((dom = this.element.find(obj)).length && this._model.data[dom.closest('.jstree-node').attr('id')]) {\n                    obj = this._model.data[dom.closest('.jstree-node').attr('id')];\n                }\n                else if((dom = this.element.find(obj)).length && dom.hasClass('jstree')) {\n                    obj = this._model.data[$.jstree.root];\n                }\n                else {\n                    return false;\n                }\n\n                if(as_dom) {\n                    obj = obj.id === $.jstree.root ? this.element : $('#' + obj.id.replace($.jstree.idregex,'\\\\$&'), this.element);\n                }\n                return obj;\n            } catch (ex) { return false; }\n        },\n        /**\n         * get the path to a node, either consisting of node texts, or of node IDs, optionally glued together (otherwise an array)\n         * @name get_path(obj [, glue, ids])\n         * @param  {mixed} obj the node\n         * @param  {String} glue if you want the path as a string - pass the glue here (for example '/'), if a falsy value is supplied here, an array is returned\n         * @param  {Boolean} ids if set to true build the path using ID, otherwise node text is used\n         * @return {mixed}\n         */\n        get_path : function (obj, glue, ids) {\n            obj = obj.parents ? obj : this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root || !obj.parents) {\n                return false;\n            }\n            var i, j, p = [];\n            p.push(ids ? obj.id : obj.text);\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                p.push(ids ? obj.parents[i] : this.get_text(obj.parents[i]));\n            }\n            p = p.reverse().slice(1);\n            return glue ? p.join(glue) : p;\n        },\n        /**\n         * get the next visible node that is below the `obj` node. If `strict` is set to `true` only sibling nodes are returned.\n         * @name get_next_dom(obj [, strict])\n         * @param  {mixed} obj\n         * @param  {Boolean} strict\n         * @return {jQuery}\n         */\n        get_next_dom : function (obj, strict) {\n            var tmp;\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                tmp = this._firstChild(this.get_container_ul()[0]);\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._nextSibling(tmp);\n                }\n                return tmp ? $(tmp) : false;\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            if(strict) {\n                tmp = obj[0];\n                do {\n                    tmp = this._nextSibling(tmp);\n                } while (tmp && tmp.offsetHeight === 0);\n                return tmp ? $(tmp) : false;\n            }\n            if(obj.hasClass(\"jstree-open\")) {\n                tmp = this._firstChild(obj.children('.jstree-children')[0]);\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._nextSibling(tmp);\n                }\n                if(tmp !== null) {\n                    return $(tmp);\n                }\n            }\n            tmp = obj[0];\n            do {\n                tmp = this._nextSibling(tmp);\n            } while (tmp && tmp.offsetHeight === 0);\n            if(tmp !== null) {\n                return $(tmp);\n            }\n            return obj.parentsUntil(\".jstree\",\".jstree-node\").nextAll(\".jstree-node:visible\").first();\n        },\n        /**\n         * get the previous visible node that is above the `obj` node. If `strict` is set to `true` only sibling nodes are returned.\n         * @name get_prev_dom(obj [, strict])\n         * @param  {mixed} obj\n         * @param  {Boolean} strict\n         * @return {jQuery}\n         */\n        get_prev_dom : function (obj, strict) {\n            var tmp;\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                tmp = this.get_container_ul()[0].lastChild;\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._previousSibling(tmp);\n                }\n                return tmp ? $(tmp) : false;\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            if(strict) {\n                tmp = obj[0];\n                do {\n                    tmp = this._previousSibling(tmp);\n                } while (tmp && tmp.offsetHeight === 0);\n                return tmp ? $(tmp) : false;\n            }\n            tmp = obj[0];\n            do {\n                tmp = this._previousSibling(tmp);\n            } while (tmp && tmp.offsetHeight === 0);\n            if(tmp !== null) {\n                obj = $(tmp);\n                while(obj.hasClass(\"jstree-open\")) {\n                    obj = obj.children(\".jstree-children\").first().children(\".jstree-node:visible:last\");\n                }\n                return obj;\n            }\n            tmp = obj[0].parentNode.parentNode;\n            return tmp && tmp.className && tmp.className.indexOf('jstree-node') !== -1 ? $(tmp) : false;\n        },\n        /**\n         * get the parent ID of a node\n         * @name get_parent(obj)\n         * @param  {mixed} obj\n         * @return {String}\n         */\n        get_parent : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            return obj.parent;\n        },\n        /**\n         * get a jQuery collection of all the children of a node (node must be rendered), returns false on error\n         * @name get_children_dom(obj)\n         * @param  {mixed} obj\n         * @return {jQuery}\n         */\n        get_children_dom : function (obj) {\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                return this.get_container_ul().children(\".jstree-node\");\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            return obj.children(\".jstree-children\").children(\".jstree-node\");\n        },\n        /**\n         * checks if a node has children\n         * @name is_parent(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_parent : function (obj) {\n            obj = this.get_node(obj);\n            return obj && (obj.state.loaded === false || obj.children.length > 0);\n        },\n        /**\n         * checks if a node is loaded (its children are available)\n         * @name is_loaded(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_loaded : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state.loaded;\n        },\n        /**\n         * check if a node is currently loading (fetching children)\n         * @name is_loading(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_loading : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state && obj.state.loading;\n        },\n        /**\n         * check if a node is opened\n         * @name is_open(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_open : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state.opened;\n        },\n        /**\n         * check if a node is in a closed state\n         * @name is_closed(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_closed : function (obj) {\n            obj = this.get_node(obj);\n            return obj && this.is_parent(obj) && !obj.state.opened;\n        },\n        /**\n         * check if a node has no children\n         * @name is_leaf(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_leaf : function (obj) {\n            return !this.is_parent(obj);\n        },\n        /**\n         * loads a node (fetches its children using the `core.data` setting). Multiple nodes can be passed to by using an array.\n         * @name load_node(obj [, callback])\n         * @param  {mixed} obj\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives two arguments - the node and a boolean status\n         * @return {Boolean}\n         * @trigger load_node.jstree\n         */\n        load_node : function (obj, callback) {\n            var dom = this.get_node(obj, true), k, l, i, j, c;\n            if($.vakata.is_array(obj)) {\n                this._load_nodes(obj.slice(), callback);\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj) {\n                if(callback) { callback.call(this, obj, false); }\n                return false;\n            }\n            // if(obj.state.loading) { } // the node is already loading - just wait for it to load and invoke callback? but if called implicitly it should be loaded again?\n            if(obj.state.loaded) {\n                obj.state.loaded = false;\n                for(i = 0, j = obj.parents.length; i < j; i++) {\n                    this._model.data[obj.parents[i]].children_d = $.vakata.array_filter(this._model.data[obj.parents[i]].children_d, function (v) {\n                        return $.inArray(v, obj.children_d) === -1;\n                    });\n                }\n                for(k = 0, l = obj.children_d.length; k < l; k++) {\n                    if(this._model.data[obj.children_d[k]].state.selected) {\n                        c = true;\n                    }\n                    delete this._model.data[obj.children_d[k]];\n                }\n                if (c) {\n                    this._data.core.selected = $.vakata.array_filter(this._data.core.selected, function (v) {\n                        return $.inArray(v, obj.children_d) === -1;\n                    });\n                }\n                obj.children = [];\n                obj.children_d = [];\n                if(c) {\n                    this.trigger('changed', { 'action' : 'load_node', 'node' : obj, 'selected' : this._data.core.selected });\n                }\n            }\n            obj.state.failed = false;\n            obj.state.loading = true;\n            if (obj.id !== $.jstree.root) {\n                dom.children(\".jstree-anchor\").attr('aria-busy', true);\n            } else {\n                dom.attr('aria-busy', true);\n            }\n            dom.addClass(\"jstree-loading\");\n            this._load_node(obj, function (status) {\n                obj = this._model.data[obj.id];\n                obj.state.loading = false;\n                obj.state.loaded = status;\n                obj.state.failed = !obj.state.loaded;\n                var dom = this.get_node(obj, true), i = 0, j = 0, m = this._model.data, has_children = false;\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    if(m[obj.children[i]] && !m[obj.children[i]].state.hidden) {\n                        has_children = true;\n                        break;\n                    }\n                }\n                if(obj.state.loaded && dom && dom.length) {\n                    dom.removeClass('jstree-closed jstree-open jstree-leaf');\n                    if (!has_children) {\n                        dom.addClass('jstree-leaf');\n                    }\n                    else {\n                        if (obj.id !== '#') {\n                            dom.addClass(obj.state.opened ? 'jstree-open' : 'jstree-closed');\n                        }\n                    }\n                }\n                if (obj.id !== $.jstree.root) {\n                    dom.children(\".jstree-anchor\").attr('aria-busy', false);\n                } else {\n                    dom.attr('aria-busy', false);\n                }\n                dom.removeClass(\"jstree-loading\");\n                /**\n                 * triggered after a node is loaded\n                 * @event\n                 * @name load_node.jstree\n                 * @param {Object} node the node that was loading\n                 * @param {Boolean} status was the node loaded successfully\n                 */\n                this.trigger('load_node', { \"node\" : obj, \"status\" : status });\n                if(callback) {\n                    callback.call(this, obj, status);\n                }\n            }.bind(this));\n            return true;\n        },\n        /**\n         * load an array of nodes (will also load unavailable nodes as soon as they appear in the structure). Used internally.\n         * @private\n         * @name _load_nodes(nodes [, callback])\n         * @param  {array} nodes\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives one argument - the array passed to _load_nodes\n         */\n        _load_nodes : function (nodes, callback, is_callback, force_reload) {\n            var r = true,\n                c = function () { this._load_nodes(nodes, callback, true); },\n                m = this._model.data, i, j, tmp = [];\n            for(i = 0, j = nodes.length; i < j; i++) {\n                if(m[nodes[i]] && ( (!m[nodes[i]].state.loaded && !m[nodes[i]].state.failed) || (!is_callback && force_reload) )) {\n                    if(!this.is_loading(nodes[i])) {\n                        this.load_node(nodes[i], c);\n                    }\n                    r = false;\n                }\n            }\n            if(r) {\n                for(i = 0, j = nodes.length; i < j; i++) {\n                    if(m[nodes[i]] && m[nodes[i]].state.loaded) {\n                        tmp.push(nodes[i]);\n                    }\n                }\n                if(callback && !callback.done) {\n                    callback.call(this, tmp);\n                    callback.done = true;\n                }\n            }\n        },\n        /**\n         * loads all unloaded nodes\n         * @name load_all([obj, callback])\n         * @param {mixed} obj the node to load recursively, omit to load all nodes in the tree\n         * @param {function} callback a function to be executed once loading all the nodes is complete,\n         * @trigger load_all.jstree\n         */\n        load_all : function (obj, callback) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var to_load = [],\n                m = this._model.data,\n                c = m[obj.id].children_d,\n                i, j;\n            if(obj.state && !obj.state.loaded) {\n                to_load.push(obj.id);\n            }\n            for(i = 0, j = c.length; i < j; i++) {\n                if(m[c[i]] && m[c[i]].state && !m[c[i]].state.loaded) {\n                    to_load.push(c[i]);\n                }\n            }\n            if(to_load.length) {\n                this._load_nodes(to_load, function () {\n                    this.load_all(obj, callback);\n                });\n            }\n            else {\n                /**\n                 * triggered after a load_all call completes\n                 * @event\n                 * @name load_all.jstree\n                 * @param {Object} node the recursively loaded node\n                 */\n                if(callback) { callback.call(this, obj); }\n                this.trigger('load_all', { \"node\" : obj });\n            }\n        },\n        /**\n         * handles the actual loading of a node. Used only internally.\n         * @private\n         * @name _load_node(obj [, callback])\n         * @param  {mixed} obj\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives one argument - a boolean status\n         * @return {Boolean}\n         */\n        _load_node : function (obj, callback) {\n            var s = this.settings.core.data, t;\n            var notTextOrCommentNode = function notTextOrCommentNode () {\n                return this.nodeType !== 3 && this.nodeType !== 8;\n            };\n            // use original HTML\n            if(!s) {\n                if(obj.id === $.jstree.root) {\n                    return this._append_html_data(obj, this._data.core.original_container_html.clone(true), function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    return callback.call(this, false);\n                }\n                // return callback.call(this, obj.id === $.jstree.root ? this._append_html_data(obj, this._data.core.original_container_html.clone(true)) : false);\n            }\n            if($.vakata.is_function(s)) {\n                return s.call(this, obj, function (d) {\n                    if(d === false) {\n                        callback.call(this, false);\n                    }\n                    else {\n                        this[typeof d === 'string' ? '_append_html_data' : '_append_json_data'](obj, typeof d === 'string' ? $($.parseHTML(d)).filter(notTextOrCommentNode) : d, function (status) {\n                            callback.call(this, status);\n                        });\n                    }\n                    // return d === false ? callback.call(this, false) : callback.call(this, this[typeof d === 'string' ? '_append_html_data' : '_append_json_data'](obj, typeof d === 'string' ? $(d) : d));\n                }.bind(this));\n            }\n            if(typeof s === 'object') {\n                if(s.url) {\n                    s = $.extend(true, {}, s);\n                    if($.vakata.is_function(s.url)) {\n                        s.url = s.url.call(this, obj);\n                    }\n                    if($.vakata.is_function(s.data)) {\n                        s.data = s.data.call(this, obj);\n                    }\n                    return $.ajax(s)\n                        .done(function (d,t,x) {\n                            var type = x.getResponseHeader('Content-Type');\n                            if((type && type.indexOf('json') !== -1) || typeof d === \"object\") {\n                                return this._append_json_data(obj, d, function (status) { callback.call(this, status); });\n                                //return callback.call(this, this._append_json_data(obj, d));\n                            }\n                            if((type && type.indexOf('html') !== -1) || typeof d === \"string\") {\n                                return this._append_html_data(obj, $($.parseHTML(d)).filter(notTextOrCommentNode), function (status) { callback.call(this, status); });\n                                // return callback.call(this, this._append_html_data(obj, $(d)));\n                            }\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'core', 'id' : 'core_04', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id, 'xhr' : x }) };\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                            return callback.call(this, false);\n                        }.bind(this))\n                        .fail(function (f) {\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'core', 'id' : 'core_04', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id, 'xhr' : f }) };\n                            callback.call(this, false);\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                        }.bind(this));\n                }\n                if ($.vakata.is_array(s)) {\n                    t = $.extend(true, [], s);\n                } else if ($.isPlainObject(s)) {\n                    t = $.extend(true, {}, s);\n                } else {\n                    t = s;\n                }\n                if(obj.id === $.jstree.root) {\n                    return this._append_json_data(obj, t, function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    this._data.core.last_error = { 'error' : 'nodata', 'plugin' : 'core', 'id' : 'core_05', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id }) };\n                    this.settings.core.error.call(this, this._data.core.last_error);\n                    return callback.call(this, false);\n                }\n                //return callback.call(this, (obj.id === $.jstree.root ? this._append_json_data(obj, t) : false) );\n            }\n            if(typeof s === 'string') {\n                if(obj.id === $.jstree.root) {\n                    return this._append_html_data(obj, $($.parseHTML(s)).filter(notTextOrCommentNode), function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    this._data.core.last_error = { 'error' : 'nodata', 'plugin' : 'core', 'id' : 'core_06', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id }) };\n                    this.settings.core.error.call(this, this._data.core.last_error);\n                    return callback.call(this, false);\n                }\n                //return callback.call(this, (obj.id === $.jstree.root ? this._append_html_data(obj, $(s)) : false) );\n            }\n            return callback.call(this, false);\n        },\n        /**\n         * adds a node to the list of nodes to redraw. Used only internally.\n         * @private\n         * @name _node_changed(obj [, callback])\n         * @param  {mixed} obj\n         */\n        _node_changed : function (obj) {\n            obj = this.get_node(obj);\n            if (obj && $.inArray(obj.id, this._model.changed) === -1) {\n                this._model.changed.push(obj.id);\n            }\n        },\n        /**\n         * appends HTML content to the tree. Used internally.\n         * @private\n         * @name _append_html_data(obj, data)\n         * @param  {mixed} obj the node to append to\n         * @param  {String} data the HTML string to parse and append\n         * @trigger model.jstree, changed.jstree\n         */\n        _append_html_data : function (dom, data, cb) {\n            dom = this.get_node(dom);\n            dom.children = [];\n            dom.children_d = [];\n            var dat = data.is('ul') ? data.children() : data,\n                par = dom.id,\n                chd = [],\n                dpc = [],\n                m = this._model.data,\n                p = m[par],\n                s = this._data.core.selected.length,\n                tmp, i, j;\n            dat.each(function (i, v) {\n                tmp = this._parse_model_from_html($(v), par, p.parents.concat());\n                if(tmp) {\n                    chd.push(tmp);\n                    dpc.push(tmp);\n                    if(m[tmp].children_d.length) {\n                        dpc = dpc.concat(m[tmp].children_d);\n                    }\n                }\n            }.bind(this));\n            p.children = chd;\n            p.children_d = dpc;\n            for(i = 0, j = p.parents.length; i < j; i++) {\n                m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n            }\n            /**\n             * triggered when new data is inserted to the tree model\n             * @event\n             * @name model.jstree\n             * @param {Array} nodes an array of node IDs\n             * @param {String} parent the parent ID of the nodes\n             */\n            this.trigger('model', { \"nodes\" : dpc, 'parent' : par });\n            if(par !== $.jstree.root) {\n                this._node_changed(par);\n                this.redraw();\n            }\n            else {\n                this.get_container_ul().children('.jstree-initial-node').remove();\n                this.redraw(true);\n            }\n            if(this._data.core.selected.length !== s) {\n                this.trigger('changed', { 'action' : 'model', 'selected' : this._data.core.selected });\n            }\n            cb.call(this, true);\n        },\n        /**\n         * appends JSON content to the tree. Used internally.\n         * @private\n         * @name _append_json_data(obj, data)\n         * @param  {mixed} obj the node to append to\n         * @param  {String} data the JSON object to parse and append\n         * @param  {Boolean} force_processing internal param - do not set\n         * @trigger model.jstree, changed.jstree\n         */\n        _append_json_data : function (dom, data, cb, force_processing) {\n            if(this.element === null) { return; }\n            dom = this.get_node(dom);\n            dom.children = [];\n            dom.children_d = [];\n            // *%$@!!!\n            if(data.d) {\n                data = data.d;\n                if(typeof data === \"string\") {\n                    data = JSON.parse(data);\n                }\n            }\n            if(!$.vakata.is_array(data)) { data = [data]; }\n            var w = null,\n                args = {\n                    'df'\t: this._model.default_state,\n                    'dat'\t: data,\n                    'par'\t: dom.id,\n                    'm'\t\t: this._model.data,\n                    't_id'\t: this._id,\n                    't_cnt'\t: this._cnt,\n                    'sel'\t: this._data.core.selected\n                },\n                inst = this,\n                func = function (data, undefined) {\n                    if(data.data) { data = data.data; }\n                    var dat = data.dat,\n                        par = data.par,\n                        chd = [],\n                        dpc = [],\n                        add = [],\n                        df = data.df,\n                        t_id = data.t_id,\n                        t_cnt = data.t_cnt,\n                        m = data.m,\n                        p = m[par],\n                        sel = data.sel,\n                        tmp, i, j, rslt,\n                        parse_flat = function (d, p, ps) {\n                            if(!ps) { ps = []; }\n                            else { ps = ps.concat(); }\n                            if(p) { ps.unshift(p); }\n                            var tid = d.id.toString(),\n                                i, j, c, e,\n                                tmp = {\n                                    id\t\t\t: tid,\n                                    text\t\t: d.text || '',\n                                    icon\t\t: d.icon !== undefined ? d.icon : true,\n                                    parent\t\t: p,\n                                    parents\t\t: ps,\n                                    children\t: d.children || [],\n                                    children_d\t: d.children_d || [],\n                                    data\t\t: d.data,\n                                    state\t\t: { },\n                                    li_attr\t\t: { id : false },\n                                    a_attr\t\t: { href : '#' },\n                                    original\t: false\n                                };\n                            for(i in df) {\n                                if(df.hasOwnProperty(i)) {\n                                    tmp.state[i] = df[i];\n                                }\n                            }\n                            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                                tmp.icon = d.data.jstree.icon;\n                            }\n                            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                                tmp.icon = true;\n                            }\n                            if(d && d.data) {\n                                tmp.data = d.data;\n                                if(d.data.jstree) {\n                                    for(i in d.data.jstree) {\n                                        if(d.data.jstree.hasOwnProperty(i)) {\n                                            tmp.state[i] = d.data.jstree[i];\n                                        }\n                                    }\n                                }\n                            }\n                            if(d && typeof d.state === 'object') {\n                                for (i in d.state) {\n                                    if(d.state.hasOwnProperty(i)) {\n                                        tmp.state[i] = d.state[i];\n                                    }\n                                }\n                            }\n                            if(d && typeof d.li_attr === 'object') {\n                                for (i in d.li_attr) {\n                                    if(d.li_attr.hasOwnProperty(i)) {\n                                        tmp.li_attr[i] = d.li_attr[i];\n                                    }\n                                }\n                            }\n                            if(!tmp.li_attr.id) {\n                                tmp.li_attr.id = tid;\n                            }\n                            if(d && typeof d.a_attr === 'object') {\n                                for (i in d.a_attr) {\n                                    if(d.a_attr.hasOwnProperty(i)) {\n                                        tmp.a_attr[i] = d.a_attr[i];\n                                    }\n                                }\n                            }\n                            if(d && d.children && d.children === true) {\n                                tmp.state.loaded = false;\n                                tmp.children = [];\n                                tmp.children_d = [];\n                            }\n                            m[tmp.id] = tmp;\n                            for(i = 0, j = tmp.children.length; i < j; i++) {\n                                c = parse_flat(m[tmp.children[i]], tmp.id, ps);\n                                e = m[c];\n                                tmp.children_d.push(c);\n                                if(e.children_d.length) {\n                                    tmp.children_d = tmp.children_d.concat(e.children_d);\n                                }\n                            }\n                            delete d.data;\n                            delete d.children;\n                            m[tmp.id].original = d;\n                            if(tmp.state.selected) {\n                                add.push(tmp.id);\n                            }\n                            return tmp.id;\n                        },\n                        parse_nest = function (d, p, ps) {\n                            if(!ps) { ps = []; }\n                            else { ps = ps.concat(); }\n                            if(p) { ps.unshift(p); }\n                            var tid = false, i, j, c, e, tmp;\n                            do {\n                                tid = 'j' + t_id + '_' + (++t_cnt);\n                            } while(m[tid]);\n\n                            tmp = {\n                                id\t\t\t: false,\n                                text\t\t: typeof d === 'string' ? d : '',\n                                icon\t\t: typeof d === 'object' && d.icon !== undefined ? d.icon : true,\n                                parent\t\t: p,\n                                parents\t\t: ps,\n                                children\t: [],\n                                children_d\t: [],\n                                data\t\t: null,\n                                state\t\t: { },\n                                li_attr\t\t: { id : false },\n                                a_attr\t\t: { href : '#' },\n                                original\t: false\n                            };\n                            for(i in df) {\n                                if(df.hasOwnProperty(i)) {\n                                    tmp.state[i] = df[i];\n                                }\n                            }\n                            if(d && (d.id || d.id === 0)) { tmp.id = d.id.toString(); }\n                            if(d && d.text) { tmp.text = d.text; }\n                            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                                tmp.icon = d.data.jstree.icon;\n                            }\n                            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                                tmp.icon = true;\n                            }\n                            if(d && d.data) {\n                                tmp.data = d.data;\n                                if(d.data.jstree) {\n                                    for(i in d.data.jstree) {\n                                        if(d.data.jstree.hasOwnProperty(i)) {\n                                            tmp.state[i] = d.data.jstree[i];\n                                        }\n                                    }\n                                }\n                            }\n                            if(d && typeof d.state === 'object') {\n                                for (i in d.state) {\n                                    if(d.state.hasOwnProperty(i)) {\n                                        tmp.state[i] = d.state[i];\n                                    }\n                                }\n                            }\n                            if(d && typeof d.li_attr === 'object') {\n                                for (i in d.li_attr) {\n                                    if(d.li_attr.hasOwnProperty(i)) {\n                                        tmp.li_attr[i] = d.li_attr[i];\n                                    }\n                                }\n                            }\n                            if(tmp.li_attr.id && !(tmp.id || tmp.id === 0)) {\n                                tmp.id = tmp.li_attr.id.toString();\n                            }\n                            if(!(tmp.id || tmp.id === 0)) {\n                                tmp.id = tid;\n                            }\n                            if(!tmp.li_attr.id) {\n                                tmp.li_attr.id = tmp.id;\n                            }\n                            if(d && typeof d.a_attr === 'object') {\n                                for (i in d.a_attr) {\n                                    if(d.a_attr.hasOwnProperty(i)) {\n                                        tmp.a_attr[i] = d.a_attr[i];\n                                    }\n                                }\n                            }\n                            if(d && d.children && d.children.length) {\n                                for(i = 0, j = d.children.length; i < j; i++) {\n                                    c = parse_nest(d.children[i], tmp.id, ps);\n                                    e = m[c];\n                                    tmp.children.push(c);\n                                    if(e.children_d.length) {\n                                        tmp.children_d = tmp.children_d.concat(e.children_d);\n                                    }\n                                }\n                                tmp.children_d = tmp.children_d.concat(tmp.children);\n                            }\n                            if(d && d.children && d.children === true) {\n                                tmp.state.loaded = false;\n                                tmp.children = [];\n                                tmp.children_d = [];\n                            }\n                            delete d.data;\n                            delete d.children;\n                            tmp.original = d;\n                            m[tmp.id] = tmp;\n                            if(tmp.state.selected) {\n                                add.push(tmp.id);\n                            }\n                            return tmp.id;\n                        };\n\n                    if(dat.length && dat[0].id !== undefined && dat[0].parent !== undefined) {\n                        // Flat JSON support (for easy import from DB):\n                        // 1) convert to object (foreach)\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            if(!dat[i].children) {\n                                dat[i].children = [];\n                            }\n                            if(!dat[i].state) {\n                                dat[i].state = {};\n                            }\n                            m[dat[i].id.toString()] = dat[i];\n                        }\n                        // 2) populate children (foreach)\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            if (!m[dat[i].parent.toString()]) {\n                                if (typeof inst !== \"undefined\") {\n                                    inst._data.core.last_error = { 'error' : 'parse', 'plugin' : 'core', 'id' : 'core_07', 'reason' : 'Node with invalid parent', 'data' : JSON.stringify({ 'id' : dat[i].id.toString(), 'parent' : dat[i].parent.toString() }) };\n                                    inst.settings.core.error.call(inst, inst._data.core.last_error);\n                                }\n                                continue;\n                            }\n\n                            m[dat[i].parent.toString()].children.push(dat[i].id.toString());\n                            // populate parent.children_d\n                            p.children_d.push(dat[i].id.toString());\n                        }\n                        // 3) normalize && populate parents and children_d with recursion\n                        for(i = 0, j = p.children.length; i < j; i++) {\n                            tmp = parse_flat(m[p.children[i]], par, p.parents.concat());\n                            dpc.push(tmp);\n                            if(m[tmp].children_d.length) {\n                                dpc = dpc.concat(m[tmp].children_d);\n                            }\n                        }\n                        for(i = 0, j = p.parents.length; i < j; i++) {\n                            m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n                        }\n                        // ?) three_state selection - p.state.selected && t - (if three_state foreach(dat => ch) -> foreach(parents) if(parent.selected) child.selected = true;\n                        rslt = {\n                            'cnt' : t_cnt,\n                            'mod' : m,\n                            'sel' : sel,\n                            'par' : par,\n                            'dpc' : dpc,\n                            'add' : add\n                        };\n                    }\n                    else {\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            tmp = parse_nest(dat[i], par, p.parents.concat());\n                            if(tmp) {\n                                chd.push(tmp);\n                                dpc.push(tmp);\n                                if(m[tmp].children_d.length) {\n                                    dpc = dpc.concat(m[tmp].children_d);\n                                }\n                            }\n                        }\n                        p.children = chd;\n                        p.children_d = dpc;\n                        for(i = 0, j = p.parents.length; i < j; i++) {\n                            m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n                        }\n                        rslt = {\n                            'cnt' : t_cnt,\n                            'mod' : m,\n                            'sel' : sel,\n                            'par' : par,\n                            'dpc' : dpc,\n                            'add' : add\n                        };\n                    }\n                    if(typeof window === 'undefined' || typeof window.document === 'undefined') {\n                        postMessage(rslt);\n                    }\n                    else {\n                        return rslt;\n                    }\n                },\n                rslt = function (rslt, worker) {\n                    if(this.element === null) { return; }\n                    this._cnt = rslt.cnt;\n                    var i, m = this._model.data;\n                    for (i in m) {\n                        if (m.hasOwnProperty(i) && m[i].state && m[i].state.loading && rslt.mod[i]) {\n                            rslt.mod[i].state.loading = true;\n                        }\n                    }\n                    this._model.data = rslt.mod; // breaks the reference in load_node - careful\n\n                    if(worker) {\n                        var j, a = rslt.add, r = rslt.sel, s = this._data.core.selected.slice();\n                        m = this._model.data;\n                        // if selection was changed while calculating in worker\n                        if(r.length !== s.length || $.vakata.array_unique(r.concat(s)).length !== r.length) {\n                            // deselect nodes that are no longer selected\n                            for(i = 0, j = r.length; i < j; i++) {\n                                if($.inArray(r[i], a) === -1 && $.inArray(r[i], s) === -1) {\n                                    m[r[i]].state.selected = false;\n                                }\n                            }\n                            // select nodes that were selected in the mean time\n                            for(i = 0, j = s.length; i < j; i++) {\n                                if($.inArray(s[i], r) === -1) {\n                                    m[s[i]].state.selected = true;\n                                }\n                            }\n                        }\n                    }\n                    if(rslt.add.length) {\n                        this._data.core.selected = this._data.core.selected.concat(rslt.add);\n                    }\n\n                    this.trigger('model', { \"nodes\" : rslt.dpc, 'parent' : rslt.par });\n\n                    if(rslt.par !== $.jstree.root) {\n                        this._node_changed(rslt.par);\n                        this.redraw();\n                    }\n                    else {\n                        // this.get_container_ul().children('.jstree-initial-node').remove();\n                        this.redraw(true);\n                    }\n                    if(rslt.add.length) {\n                        this.trigger('changed', { 'action' : 'model', 'selected' : this._data.core.selected });\n                    }\n\n                    // If no worker, try to mimic worker behavioour, by invoking cb asynchronously\n                    if (!worker && setImmediate) {\n                        setImmediate(function(){\n                            cb.call(inst, true);\n                        });\n                    }\n                    else {\n                        cb.call(inst, true);\n                    }\n                };\n            if(this.settings.core.worker && window.Blob && window.URL && window.Worker) {\n                try {\n                    if(this._wrk === null) {\n                        this._wrk = window.URL.createObjectURL(\n                            new window.Blob(\n                                ['self.onmessage = ' + func.toString()],\n                                {type:\"text/javascript\"}\n                            )\n                        );\n                    }\n                    if(!this._data.core.working || force_processing) {\n                        this._data.core.working = true;\n                        w = new window.Worker(this._wrk);\n                        w.onmessage = function (e) {\n                            rslt.call(this, e.data, true);\n                            try { w.terminate(); w = null; } catch(ignore) { }\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }.bind(this);\n                        w.onerror = function (e) {\n                            rslt.call(this, func(args), false);\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }.bind(this);\n                        if(!args.par) {\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }\n                        else {\n                            w.postMessage(args);\n                        }\n                    }\n                    else {\n                        this._data.core.worker_queue.push([dom, data, cb, true]);\n                    }\n                }\n                catch(e) {\n                    rslt.call(this, func(args), false);\n                    if(this._data.core.worker_queue.length) {\n                        this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                    }\n                    else {\n                        this._data.core.working = false;\n                    }\n                }\n            }\n            else {\n                rslt.call(this, func(args), false);\n            }\n        },\n        /**\n         * parses a node from a jQuery object and appends them to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_html(d [, p, ps])\n         * @param  {jQuery} d the jQuery object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_html : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = [].concat(ps); }\n            if(p) { ps.unshift(p); }\n            var c, e, m = this._model.data,\n                data = {\n                    id\t\t\t: false,\n                    text\t\t: false,\n                    icon\t\t: true,\n                    parent\t\t: p,\n                    parents\t\t: ps,\n                    children\t: [],\n                    children_d\t: [],\n                    data\t\t: null,\n                    state\t\t: { },\n                    li_attr\t\t: { id : false },\n                    a_attr\t\t: { href : '#' },\n                    original\t: false\n                }, i, tmp, tid;\n            for(i in this._model.default_state) {\n                if(this._model.default_state.hasOwnProperty(i)) {\n                    data.state[i] = this._model.default_state[i];\n                }\n            }\n            tmp = $.vakata.attributes(d, true);\n            $.each(tmp, function (i, v) {\n                v = $.vakata.trim(v);\n                if(!v.length) { return true; }\n                data.li_attr[i] = v;\n                if(i === 'id') {\n                    data.id = v.toString();\n                }\n            });\n            tmp = d.children('a').first();\n            if(tmp.length) {\n                tmp = $.vakata.attributes(tmp, true);\n                $.each(tmp, function (i, v) {\n                    v = $.vakata.trim(v);\n                    if(v.length) {\n                        data.a_attr[i] = v;\n                    }\n                });\n            }\n            tmp = d.children(\"a\").first().length ? d.children(\"a\").first().clone() : d.clone();\n            tmp.children(\"ins, i, ul\").remove();\n            tmp = tmp.html();\n            tmp = $('<div></div>').html(tmp);\n            data.text = this.settings.core.force_text ? tmp.text() : tmp.html();\n            tmp = d.data();\n            data.data = tmp ? $.extend(true, {}, tmp) : null;\n            data.state.opened = d.hasClass('jstree-open');\n            data.state.selected = d.children('a').hasClass('jstree-clicked');\n            data.state.disabled = d.children('a').hasClass('jstree-disabled');\n            if(data.data && data.data.jstree) {\n                for(i in data.data.jstree) {\n                    if(data.data.jstree.hasOwnProperty(i)) {\n                        data.state[i] = data.data.jstree[i];\n                    }\n                }\n            }\n            tmp = d.children(\"a\").children(\".jstree-themeicon\");\n            if(tmp.length) {\n                data.icon = tmp.hasClass('jstree-themeicon-hidden') ? false : tmp.attr('rel');\n            }\n            if(data.state.icon !== undefined) {\n                data.icon = data.state.icon;\n            }\n            if(data.icon === undefined || data.icon === null || data.icon === \"\") {\n                data.icon = true;\n            }\n            tmp = d.children(\"ul\").children(\"li\");\n            do {\n                tid = 'j' + this._id + '_' + (++this._cnt);\n            } while(m[tid]);\n            data.id = data.li_attr.id ? data.li_attr.id.toString() : tid;\n            if(tmp.length) {\n                tmp.each(function (i, v) {\n                    c = this._parse_model_from_html($(v), data.id, ps);\n                    e = this._model.data[c];\n                    data.children.push(c);\n                    if(e.children_d.length) {\n                        data.children_d = data.children_d.concat(e.children_d);\n                    }\n                }.bind(this));\n                data.children_d = data.children_d.concat(data.children);\n            }\n            else {\n                if(d.hasClass('jstree-closed')) {\n                    data.state.loaded = false;\n                }\n            }\n            if(data.li_attr['class']) {\n                data.li_attr['class'] = data.li_attr['class'].replace('jstree-closed','').replace('jstree-open','');\n            }\n            if(data.a_attr['class']) {\n                data.a_attr['class'] = data.a_attr['class'].replace('jstree-clicked','').replace('jstree-disabled','');\n            }\n            m[data.id] = data;\n            if(data.state.selected) {\n                this._data.core.selected.push(data.id);\n            }\n            return data.id;\n        },\n        /**\n         * parses a node from a JSON object (used when dealing with flat data, which has no nesting of children, but has id and parent properties) and appends it to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_flat_json(d [, p, ps])\n         * @param  {Object} d the JSON object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_flat_json : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = ps.concat(); }\n            if(p) { ps.unshift(p); }\n            var tid = d.id.toString(),\n                m = this._model.data,\n                df = this._model.default_state,\n                i, j, c, e,\n                tmp = {\n                    id\t\t\t: tid,\n                    text\t\t: d.text || '',\n                    icon\t\t: d.icon !== undefined ? d.icon : true,\n                    parent\t\t: p,\n                    parents\t\t: ps,\n                    children\t: d.children || [],\n                    children_d\t: d.children_d || [],\n                    data\t\t: d.data,\n                    state\t\t: { },\n                    li_attr\t\t: { id : false },\n                    a_attr\t\t: { href : '#' },\n                    original\t: false\n                };\n            for(i in df) {\n                if(df.hasOwnProperty(i)) {\n                    tmp.state[i] = df[i];\n                }\n            }\n            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                tmp.icon = d.data.jstree.icon;\n            }\n            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                tmp.icon = true;\n            }\n            if(d && d.data) {\n                tmp.data = d.data;\n                if(d.data.jstree) {\n                    for(i in d.data.jstree) {\n                        if(d.data.jstree.hasOwnProperty(i)) {\n                            tmp.state[i] = d.data.jstree[i];\n                        }\n                    }\n                }\n            }\n            if(d && typeof d.state === 'object') {\n                for (i in d.state) {\n                    if(d.state.hasOwnProperty(i)) {\n                        tmp.state[i] = d.state[i];\n                    }\n                }\n            }\n            if(d && typeof d.li_attr === 'object') {\n                for (i in d.li_attr) {\n                    if(d.li_attr.hasOwnProperty(i)) {\n                        tmp.li_attr[i] = d.li_attr[i];\n                    }\n                }\n            }\n            if(!tmp.li_attr.id) {\n                tmp.li_attr.id = tid;\n            }\n            if(d && typeof d.a_attr === 'object') {\n                for (i in d.a_attr) {\n                    if(d.a_attr.hasOwnProperty(i)) {\n                        tmp.a_attr[i] = d.a_attr[i];\n                    }\n                }\n            }\n            if(d && d.children && d.children === true) {\n                tmp.state.loaded = false;\n                tmp.children = [];\n                tmp.children_d = [];\n            }\n            m[tmp.id] = tmp;\n            for(i = 0, j = tmp.children.length; i < j; i++) {\n                c = this._parse_model_from_flat_json(m[tmp.children[i]], tmp.id, ps);\n                e = m[c];\n                tmp.children_d.push(c);\n                if(e.children_d.length) {\n                    tmp.children_d = tmp.children_d.concat(e.children_d);\n                }\n            }\n            delete d.data;\n            delete d.children;\n            m[tmp.id].original = d;\n            if(tmp.state.selected) {\n                this._data.core.selected.push(tmp.id);\n            }\n            return tmp.id;\n        },\n        /**\n         * parses a node from a JSON object and appends it to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_json(d [, p, ps])\n         * @param  {Object} d the JSON object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_json : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = ps.concat(); }\n            if(p) { ps.unshift(p); }\n            var tid = false, i, j, c, e, m = this._model.data, df = this._model.default_state, tmp;\n            do {\n                tid = 'j' + this._id + '_' + (++this._cnt);\n            } while(m[tid]);\n\n            tmp = {\n                id\t\t\t: false,\n                text\t\t: typeof d === 'string' ? d : '',\n                icon\t\t: typeof d === 'object' && d.icon !== undefined ? d.icon : true,\n                parent\t\t: p,\n                parents\t\t: ps,\n                children\t: [],\n                children_d\t: [],\n                data\t\t: null,\n                state\t\t: { },\n                li_attr\t\t: { id : false },\n                a_attr\t\t: { href : '#' },\n                original\t: false\n            };\n            for(i in df) {\n                if(df.hasOwnProperty(i)) {\n                    tmp.state[i] = df[i];\n                }\n            }\n            if(d && (d.id || d.id === 0)) { tmp.id = d.id.toString(); }\n            if(d && d.text) { tmp.text = d.text; }\n            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                tmp.icon = d.data.jstree.icon;\n            }\n            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                tmp.icon = true;\n            }\n            if(d && d.data) {\n                tmp.data = d.data;\n                if(d.data.jstree) {\n                    for(i in d.data.jstree) {\n                        if(d.data.jstree.hasOwnProperty(i)) {\n                            tmp.state[i] = d.data.jstree[i];\n                        }\n                    }\n                }\n            }\n            if(d && typeof d.state === 'object') {\n                for (i in d.state) {\n                    if(d.state.hasOwnProperty(i)) {\n                        tmp.state[i] = d.state[i];\n                    }\n                }\n            }\n            if(d && typeof d.li_attr === 'object') {\n                for (i in d.li_attr) {\n                    if(d.li_attr.hasOwnProperty(i)) {\n                        tmp.li_attr[i] = d.li_attr[i];\n                    }\n                }\n            }\n            if(tmp.li_attr.id && !(tmp.id || tmp.id === 0)) {\n                tmp.id = tmp.li_attr.id.toString();\n            }\n            if(!(tmp.id || tmp.id === 0)) {\n                tmp.id = tid;\n            }\n            if(!tmp.li_attr.id) {\n                tmp.li_attr.id = tmp.id;\n            }\n            if(d && typeof d.a_attr === 'object') {\n                for (i in d.a_attr) {\n                    if(d.a_attr.hasOwnProperty(i)) {\n                        tmp.a_attr[i] = d.a_attr[i];\n                    }\n                }\n            }\n            if(d && d.children && d.children.length) {\n                for(i = 0, j = d.children.length; i < j; i++) {\n                    c = this._parse_model_from_json(d.children[i], tmp.id, ps);\n                    e = m[c];\n                    tmp.children.push(c);\n                    if(e.children_d.length) {\n                        tmp.children_d = tmp.children_d.concat(e.children_d);\n                    }\n                }\n                tmp.children_d = tmp.children.concat(tmp.children_d);\n            }\n            if(d && d.children && d.children === true) {\n                tmp.state.loaded = false;\n                tmp.children = [];\n                tmp.children_d = [];\n            }\n            delete d.data;\n            delete d.children;\n            tmp.original = d;\n            m[tmp.id] = tmp;\n            if(tmp.state.selected) {\n                this._data.core.selected.push(tmp.id);\n            }\n            return tmp.id;\n        },\n        /**\n         * redraws all nodes that need to be redrawn. Used internally.\n         * @private\n         * @name _redraw()\n         * @trigger redraw.jstree\n         */\n        _redraw : function () {\n            var nodes = this._model.force_full_redraw ? this._model.data[$.jstree.root].children.concat([]) : this._model.changed.concat([]),\n                f = document.createElement('UL'), tmp, i, j, fe = this._data.core.focused;\n            for(i = 0, j = nodes.length; i < j; i++) {\n                tmp = this.redraw_node(nodes[i], true, this._model.force_full_redraw);\n                if(tmp && this._model.force_full_redraw) {\n                    f.appendChild(tmp);\n                }\n            }\n            if(this._model.force_full_redraw) {\n                f.className = this.get_container_ul()[0].className;\n                f.setAttribute('role','presentation');\n                this.element.empty().append(f);\n                //this.get_container_ul()[0].appendChild(f);\n            }\n            if(fe !== null && this.settings.core.restore_focus) {\n                tmp = this.get_node(fe, true);\n                if(tmp && tmp.length && tmp.children('.jstree-anchor')[0] !== document.activeElement) {\n                    tmp.children('.jstree-anchor').trigger('focus');\n                }\n                else {\n                    this._data.core.focused = null;\n                }\n            }\n            this._model.force_full_redraw = false;\n            this._model.changed = [];\n            /**\n             * triggered after nodes are redrawn\n             * @event\n             * @name redraw.jstree\n             * @param {array} nodes the redrawn nodes\n             */\n            this.trigger('redraw', { \"nodes\" : nodes });\n        },\n        /**\n         * redraws all nodes that need to be redrawn or optionally - the whole tree\n         * @name redraw([full])\n         * @param {Boolean} full if set to `true` all nodes are redrawn.\n         */\n        redraw : function (full) {\n            if(full) {\n                this._model.force_full_redraw = true;\n            }\n            //if(this._model.redraw_timeout) {\n            //\tclearTimeout(this._model.redraw_timeout);\n            //}\n            //this._model.redraw_timeout = setTimeout($.proxy(this._redraw, this),0);\n            this._redraw();\n        },\n        /**\n         * redraws a single node's children. Used internally.\n         * @private\n         * @name draw_children(node)\n         * @param {mixed} node the node whose children will be redrawn\n         */\n        draw_children : function (node) {\n            var obj = this.get_node(node),\n                i = false,\n                j = false,\n                k = false,\n                d = document;\n            if(!obj) { return false; }\n            if(obj.id === $.jstree.root) { return this.redraw(true); }\n            node = this.get_node(node, true);\n            if(!node || !node.length) { return false; } // TODO: quick toggle\n\n            node.children('.jstree-children').remove();\n            node = node[0];\n            if(obj.children.length && obj.state.loaded) {\n                k = d.createElement('UL');\n                k.setAttribute('role', 'group');\n                k.className = 'jstree-children';\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    k.appendChild(this.redraw_node(obj.children[i], true, true));\n                }\n                node.appendChild(k);\n            }\n        },\n        /**\n         * redraws a single node. Used internally.\n         * @private\n         * @name redraw_node(node, deep, is_callback, force_render)\n         * @param {mixed} node the node to redraw\n         * @param {Boolean} deep should child nodes be redrawn too\n         * @param {Boolean} is_callback is this a recursion call\n         * @param {Boolean} force_render should children of closed parents be drawn anyway\n         */\n        redraw_node : function (node, deep, is_callback, force_render) {\n            var obj = this.get_node(node),\n                par = false,\n                ind = false,\n                old = false,\n                i = false,\n                j = false,\n                k = false,\n                c = '',\n                d = document,\n                m = this._model.data,\n                f = false,\n                s = false,\n                tmp = null,\n                t = 0,\n                l = 0,\n                has_children = false,\n                last_sibling = false;\n            if(!obj) { return false; }\n            if(obj.id === $.jstree.root) {  return this.redraw(true); }\n            deep = deep || obj.children.length === 0;\n            node = !document.querySelector ? document.getElementById(obj.id) : this.element[0].querySelector('#' + (\"0123456789\".indexOf(obj.id[0]) !== -1 ? '\\\\3' + obj.id[0] + ' ' + obj.id.substr(1).replace($.jstree.idregex,'\\\\$&') : obj.id.replace($.jstree.idregex,'\\\\$&')) ); //, this.element);\n            if(!node) {\n                deep = true;\n                //node = d.createElement('LI');\n                if(!is_callback) {\n                    par = obj.parent !== $.jstree.root ? $('#' + obj.parent.replace($.jstree.idregex,'\\\\$&'), this.element)[0] : null;\n                    if(par !== null && (!par || !m[obj.parent].state.opened)) {\n                        return false;\n                    }\n                    ind = $.inArray(obj.id, par === null ? m[$.jstree.root].children : m[obj.parent].children);\n                }\n            }\n            else {\n                node = $(node);\n                if(!is_callback) {\n                    par = node.parent().parent()[0];\n                    if(par === this.element[0]) {\n                        par = null;\n                    }\n                    ind = node.index();\n                }\n                // m[obj.id].data = node.data(); // use only node's data, no need to touch jquery storage\n                if(!deep && obj.children.length && !node.children('.jstree-children').length) {\n                    deep = true;\n                }\n                if(!deep) {\n                    old = node.children('.jstree-children')[0];\n                }\n                f = node.children('.jstree-anchor')[0] === document.activeElement;\n                node.remove();\n                //node = d.createElement('LI');\n                //node = node[0];\n            }\n            node = this._data.core.node.cloneNode(true);\n            // node is DOM, deep is boolean\n\n            c = 'jstree-node ';\n            for(i in obj.li_attr) {\n                if(obj.li_attr.hasOwnProperty(i)) {\n                    if(i === 'id') { continue; }\n                    if(i !== 'class') {\n                        node.setAttribute(i, obj.li_attr[i]);\n                    }\n                    else {\n                        c += obj.li_attr[i];\n                    }\n                }\n            }\n            if(!obj.a_attr.id) {\n                obj.a_attr.id = obj.id + '_anchor';\n            }\n            node.childNodes[1].setAttribute('aria-selected', !!obj.state.selected);\n            node.childNodes[1].setAttribute('aria-level', obj.parents.length);\n            if(this.settings.core.compute_elements_positions) {\n                node.childNodes[1].setAttribute('aria-setsize', m[obj.parent].children.length);\n                node.childNodes[1].setAttribute('aria-posinset', m[obj.parent].children.indexOf(obj.id) + 1);\n            }\n            if(obj.state.disabled) {\n                node.childNodes[1].setAttribute('aria-disabled', true);\n            }\n\n            for(i = 0, j = obj.children.length; i < j; i++) {\n                if(!m[obj.children[i]].state.hidden) {\n                    has_children = true;\n                    break;\n                }\n            }\n            if(obj.parent !== null && m[obj.parent] && !obj.state.hidden) {\n                i = $.inArray(obj.id, m[obj.parent].children);\n                last_sibling = obj.id;\n                if(i !== -1) {\n                    i++;\n                    for(j = m[obj.parent].children.length; i < j; i++) {\n                        if(!m[m[obj.parent].children[i]].state.hidden) {\n                            last_sibling = m[obj.parent].children[i];\n                        }\n                        if(last_sibling !== obj.id) {\n                            break;\n                        }\n                    }\n                }\n            }\n\n            if(obj.state.hidden) {\n                c += ' jstree-hidden';\n            }\n            if (obj.state.loading) {\n                c += ' jstree-loading';\n            }\n            if(obj.state.loaded && !has_children) {\n                c += ' jstree-leaf';\n            }\n            else {\n                c += obj.state.opened && obj.state.loaded ? ' jstree-open' : ' jstree-closed';\n                node.childNodes[1].setAttribute('aria-expanded', (obj.state.opened && obj.state.loaded) );\n            }\n            if(last_sibling === obj.id) {\n                c += ' jstree-last';\n            }\n            node.id = obj.id;\n            node.className = c;\n            c = ( obj.state.selected ? ' jstree-clicked' : '') + ( obj.state.disabled ? ' jstree-disabled' : '');\n            for(j in obj.a_attr) {\n                if(obj.a_attr.hasOwnProperty(j)) {\n                    if(j === 'href' && obj.a_attr[j] === '#') { continue; }\n                    if(j !== 'class') {\n                        node.childNodes[1].setAttribute(j, obj.a_attr[j]);\n                    }\n                    else {\n                        c += ' ' + obj.a_attr[j];\n                    }\n                }\n            }\n            if(c.length) {\n                node.childNodes[1].className = 'jstree-anchor ' + c;\n            }\n            if((obj.icon && obj.icon !== true) || obj.icon === false) {\n                if(obj.icon === false) {\n                    node.childNodes[1].childNodes[0].className += ' jstree-themeicon-hidden';\n                }\n                else if(obj.icon.indexOf('/') === -1 && obj.icon.indexOf('.') === -1) {\n                    node.childNodes[1].childNodes[0].className += ' ' + obj.icon + ' jstree-themeicon-custom';\n                }\n                else {\n                    node.childNodes[1].childNodes[0].style.backgroundImage = 'url(\"'+obj.icon+'\")';\n                    node.childNodes[1].childNodes[0].style.backgroundPosition = 'center center';\n                    node.childNodes[1].childNodes[0].style.backgroundSize = 'auto';\n                    node.childNodes[1].childNodes[0].className += ' jstree-themeicon-custom';\n                }\n            }\n\n            if(this.settings.core.force_text) {\n                node.childNodes[1].appendChild(d.createTextNode(obj.text));\n            }\n            else {\n                node.childNodes[1].innerHTML += obj.text;\n            }\n\n\n            if(deep && obj.children.length && (obj.state.opened || force_render) && obj.state.loaded) {\n                k = d.createElement('UL');\n                k.setAttribute('role', 'group');\n                k.className = 'jstree-children';\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    k.appendChild(this.redraw_node(obj.children[i], deep, true));\n                }\n                node.appendChild(k);\n            }\n            if(old) {\n                node.appendChild(old);\n            }\n            if(!is_callback) {\n                // append back using par / ind\n                if(!par) {\n                    par = this.element[0];\n                }\n                for(i = 0, j = par.childNodes.length; i < j; i++) {\n                    if(par.childNodes[i] && par.childNodes[i].className && par.childNodes[i].className.indexOf('jstree-children') !== -1) {\n                        tmp = par.childNodes[i];\n                        break;\n                    }\n                }\n                if(!tmp) {\n                    tmp = d.createElement('UL');\n                    tmp.setAttribute('role', 'group');\n                    tmp.className = 'jstree-children';\n                    par.appendChild(tmp);\n                }\n                par = tmp;\n\n                if(ind < par.childNodes.length) {\n                    par.insertBefore(node, par.childNodes[ind]);\n                }\n                else {\n                    par.appendChild(node);\n                }\n                if(f) {\n                    t = this.element[0].scrollTop;\n                    l = this.element[0].scrollLeft;\n                    node.childNodes[1].focus();\n                    this.element[0].scrollTop = t;\n                    this.element[0].scrollLeft = l;\n                }\n            }\n            if(obj.state.opened && !obj.state.loaded) {\n                obj.state.opened = false;\n                setTimeout(function () {\n                    this.open_node(obj.id, false, 0);\n                }.bind(this), 0);\n            }\n            return node;\n        },\n        /**\n         * opens a node, revealing its children. If the node is not loaded it will be loaded and opened once ready.\n         * @name open_node(obj [, callback, animation])\n         * @param {mixed} obj the node to open\n         * @param {Function} callback a function to execute once the node is opened\n         * @param {Number} animation the animation duration in milliseconds when opening the node (overrides the `core.animation` setting). Use `false` for no animation.\n         * @trigger open_node.jstree, after_open.jstree, before_open.jstree\n         */\n        open_node : function (obj, callback, animation) {\n            var t1, t2, d, t;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.open_node(obj[t1], callback, animation);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            animation = animation === undefined ? this.settings.core.animation : animation;\n            if(!this.is_closed(obj)) {\n                if(callback) {\n                    callback.call(this, obj, false);\n                }\n                return false;\n            }\n            if(!this.is_loaded(obj)) {\n                if(this.is_loading(obj)) {\n                    return setTimeout(function () {\n                        this.open_node(obj, callback, animation);\n                    }.bind(this), 500);\n                }\n                this.load_node(obj, function (o, ok) {\n                    return ok ? this.open_node(o, callback, animation) : (callback ? callback.call(this, o, false) : false);\n                });\n            }\n            else {\n                d = this.get_node(obj, true);\n                t = this;\n                if(d.length) {\n                    if(animation && d.children(\".jstree-children\").length) {\n                        d.children(\".jstree-children\").stop(true, true);\n                    }\n                    if(obj.children.length && !this._firstChild(d.children('.jstree-children')[0])) {\n                        this.draw_children(obj);\n                        //d = this.get_node(obj, true);\n                    }\n                    if(!animation) {\n                        this.trigger('before_open', { \"node\" : obj });\n                        d[0].className = d[0].className.replace('jstree-closed', 'jstree-open');\n                        d[0].childNodes[1].setAttribute(\"aria-expanded\", true);\n                    }\n                    else {\n                        this.trigger('before_open', { \"node\" : obj });\n                        d\n                            .children(\".jstree-children\").css(\"display\",\"none\").end()\n                            .removeClass(\"jstree-closed\").addClass(\"jstree-open\")\n                            .children('.jstree-anchor').attr(\"aria-expanded\", true).end()\n                            .children(\".jstree-children\").stop(true, true)\n                            .slideDown(animation, function () {\n                                this.style.display = \"\";\n                                if (t.element) {\n                                    t.trigger(\"after_open\", { \"node\" : obj });\n                                }\n                            });\n                    }\n                }\n                obj.state.opened = true;\n                if(callback) {\n                    callback.call(this, obj, true);\n                }\n                if(!d.length) {\n                    /**\n                     * triggered when a node is about to be opened (if the node is supposed to be in the DOM, it will be, but it won't be visible yet)\n                     * @event\n                     * @name before_open.jstree\n                     * @param {Object} node the opened node\n                     */\n                    this.trigger('before_open', { \"node\" : obj });\n                }\n                /**\n                 * triggered when a node is opened (if there is an animation it will not be completed yet)\n                 * @event\n                 * @name open_node.jstree\n                 * @param {Object} node the opened node\n                 */\n                this.trigger('open_node', { \"node\" : obj });\n                if(!animation || !d.length) {\n                    /**\n                     * triggered when a node is opened and the animation is complete\n                     * @event\n                     * @name after_open.jstree\n                     * @param {Object} node the opened node\n                     */\n                    this.trigger(\"after_open\", { \"node\" : obj });\n                }\n                return true;\n            }\n        },\n        /**\n         * opens every parent of a node (node should be loaded)\n         * @name _open_to(obj)\n         * @param {mixed} obj the node to reveal\n         * @private\n         */\n        _open_to : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            var i, j, p = obj.parents;\n            for(i = 0, j = p.length; i < j; i+=1) {\n                if(i !== $.jstree.root) {\n                    this.open_node(p[i], false, 0);\n                }\n            }\n            return $('#' + obj.id.replace($.jstree.idregex,'\\\\$&'), this.element);\n        },\n        /**\n         * closes a node, hiding its children\n         * @name close_node(obj [, animation])\n         * @param {mixed} obj the node to close\n         * @param {Number} animation the animation duration in milliseconds when closing the node (overrides the `core.animation` setting). Use `false` for no animation.\n         * @trigger close_node.jstree, after_close.jstree\n         */\n        close_node : function (obj, animation) {\n            var t1, t2, t, d;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.close_node(obj[t1], animation);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(this.is_closed(obj)) {\n                return false;\n            }\n            animation = animation === undefined ? this.settings.core.animation : animation;\n            t = this;\n            d = this.get_node(obj, true);\n\n            obj.state.opened = false;\n            /**\n             * triggered when a node is closed (if there is an animation it will not be complete yet)\n             * @event\n             * @name close_node.jstree\n             * @param {Object} node the closed node\n             */\n            this.trigger('close_node',{ \"node\" : obj });\n            if(!d.length) {\n                /**\n                 * triggered when a node is closed and the animation is complete\n                 * @event\n                 * @name after_close.jstree\n                 * @param {Object} node the closed node\n                 */\n                this.trigger(\"after_close\", { \"node\" : obj });\n            }\n            else {\n                if(!animation) {\n                    d[0].className = d[0].className.replace('jstree-open', 'jstree-closed');\n                    d.children('.jstree-anchor').attr(\"aria-expanded\", false);\n                    d.children('.jstree-children').remove();\n                    this.trigger(\"after_close\", { \"node\" : obj });\n                }\n                else {\n                    d\n                        .children(\".jstree-children\").attr(\"style\",\"display:block !important\").end()\n                        .removeClass(\"jstree-open\").addClass(\"jstree-closed\")\n                        .children('.jstree-anchor').attr(\"aria-expanded\", false).end()\n                        .children(\".jstree-children\").stop(true, true).slideUp(animation, function () {\n                        this.style.display = \"\";\n                        d.children('.jstree-children').remove();\n                        if (t.element) {\n                            t.trigger(\"after_close\", { \"node\" : obj });\n                        }\n                    });\n                }\n            }\n        },\n        /**\n         * toggles a node - closing it if it is open, opening it if it is closed\n         * @name toggle_node(obj)\n         * @param {mixed} obj the node to toggle\n         */\n        toggle_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.toggle_node(obj[t1]);\n                }\n                return true;\n            }\n            if(this.is_closed(obj)) {\n                return this.open_node(obj);\n            }\n            if(this.is_open(obj)) {\n                return this.close_node(obj);\n            }\n        },\n        /**\n         * opens all nodes within a node (or the tree), revealing their children. If the node is not loaded it will be loaded and opened once ready.\n         * @name open_all([obj, animation, original_obj])\n         * @param {mixed} obj the node to open recursively, omit to open all nodes in the tree\n         * @param {Number} animation the animation duration in milliseconds when opening the nodes, the default is no animation\n         * @param {jQuery} reference to the node that started the process (internal use)\n         * @trigger open_all.jstree\n         */\n        open_all : function (obj, animation, original_obj) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var dom = obj.id === $.jstree.root ? this.get_container_ul() : this.get_node(obj, true), i, j, _this;\n            if(!dom.length) {\n                for(i = 0, j = obj.children_d.length; i < j; i++) {\n                    if(this.is_closed(this._model.data[obj.children_d[i]])) {\n                        this._model.data[obj.children_d[i]].state.opened = true;\n                    }\n                }\n                return this.trigger('open_all', { \"node\" : obj });\n            }\n            original_obj = original_obj || dom;\n            _this = this;\n            dom = this.is_closed(obj) ? dom.find('.jstree-closed').addBack() : dom.find('.jstree-closed');\n            dom.each(function () {\n                _this.open_node(\n                    this,\n                    function(node, status) { if(status && this.is_parent(node)) { this.open_all(node, animation, original_obj); } },\n                    animation || 0\n                );\n            });\n            if(original_obj.find('.jstree-closed').length === 0) {\n                /**\n                 * triggered when an `open_all` call completes\n                 * @event\n                 * @name open_all.jstree\n                 * @param {Object} node the opened node\n                 */\n                this.trigger('open_all', { \"node\" : this.get_node(original_obj) });\n            }\n        },\n        /**\n         * closes all nodes within a node (or the tree), revealing their children\n         * @name close_all([obj, animation])\n         * @param {mixed} obj the node to close recursively, omit to close all nodes in the tree\n         * @param {Number} animation the animation duration in milliseconds when closing the nodes, the default is no animation\n         * @trigger close_all.jstree\n         */\n        close_all : function (obj, animation) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var dom = obj.id === $.jstree.root ? this.get_container_ul() : this.get_node(obj, true),\n                _this = this, i, j;\n            if(dom.length) {\n                dom = this.is_open(obj) ? dom.find('.jstree-open').addBack() : dom.find('.jstree-open');\n                $(dom.get().reverse()).each(function () { _this.close_node(this, animation || 0); });\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                this._model.data[obj.children_d[i]].state.opened = false;\n            }\n            /**\n             * triggered when an `close_all` call completes\n             * @event\n             * @name close_all.jstree\n             * @param {Object} node the closed node\n             */\n            this.trigger('close_all', { \"node\" : obj });\n        },\n        /**\n         * checks if a node is disabled (not selectable)\n         * @name is_disabled(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_disabled : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state && obj.state.disabled;\n        },\n        /**\n         * enables a node - so that it can be selected\n         * @name enable_node(obj)\n         * @param {mixed} obj the node to enable\n         * @trigger enable_node.jstree\n         */\n        enable_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.enable_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            obj.state.disabled = false;\n            this.get_node(obj,true).children('.jstree-anchor').removeClass('jstree-disabled').attr('aria-disabled', false);\n            /**\n             * triggered when an node is enabled\n             * @event\n             * @name enable_node.jstree\n             * @param {Object} node the enabled node\n             */\n            this.trigger('enable_node', { 'node' : obj });\n        },\n        /**\n         * disables a node - so that it can not be selected\n         * @name disable_node(obj)\n         * @param {mixed} obj the node to disable\n         * @trigger disable_node.jstree\n         */\n        disable_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.disable_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            obj.state.disabled = true;\n            this.get_node(obj,true).children('.jstree-anchor').addClass('jstree-disabled').attr('aria-disabled', true);\n            /**\n             * triggered when an node is disabled\n             * @event\n             * @name disable_node.jstree\n             * @param {Object} node the disabled node\n             */\n            this.trigger('disable_node', { 'node' : obj });\n        },\n        /**\n         * determines if a node is hidden\n         * @name is_hidden(obj)\n         * @param {mixed} obj the node\n         */\n        is_hidden : function (obj) {\n            obj = this.get_node(obj);\n            return obj.state.hidden === true;\n        },\n        /**\n         * hides a node - it is still in the structure but will not be visible\n         * @name hide_node(obj)\n         * @param {mixed} obj the node to hide\n         * @param {Boolean} skip_redraw internal parameter controlling if redraw is called\n         * @trigger hide_node.jstree\n         */\n        hide_node : function (obj, skip_redraw) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.hide_node(obj[t1], true);\n                }\n                if (!skip_redraw) {\n                    this.redraw();\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(!obj.state.hidden) {\n                obj.state.hidden = true;\n                this._node_changed(obj.parent);\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n                /**\n                 * triggered when an node is hidden\n                 * @event\n                 * @name hide_node.jstree\n                 * @param {Object} node the hidden node\n                 */\n                this.trigger('hide_node', { 'node' : obj });\n            }\n        },\n        /**\n         * shows a node\n         * @name show_node(obj)\n         * @param {mixed} obj the node to show\n         * @param {Boolean} skip_redraw internal parameter controlling if redraw is called\n         * @trigger show_node.jstree\n         */\n        show_node : function (obj, skip_redraw) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.show_node(obj[t1], true);\n                }\n                if (!skip_redraw) {\n                    this.redraw();\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(obj.state.hidden) {\n                obj.state.hidden = false;\n                this._node_changed(obj.parent);\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n                /**\n                 * triggered when an node is shown\n                 * @event\n                 * @name show_node.jstree\n                 * @param {Object} node the shown node\n                 */\n                this.trigger('show_node', { 'node' : obj });\n            }\n        },\n        /**\n         * hides all nodes\n         * @name hide_all()\n         * @trigger hide_all.jstree\n         */\n        hide_all : function (skip_redraw) {\n            var i, m = this._model.data, ids = [];\n            for(i in m) {\n                if(m.hasOwnProperty(i) && i !== $.jstree.root && !m[i].state.hidden) {\n                    m[i].state.hidden = true;\n                    ids.push(i);\n                }\n            }\n            this._model.force_full_redraw = true;\n            if(!skip_redraw) {\n                this.redraw();\n            }\n            /**\n             * triggered when all nodes are hidden\n             * @event\n             * @name hide_all.jstree\n             * @param {Array} nodes the IDs of all hidden nodes\n             */\n            this.trigger('hide_all', { 'nodes' : ids });\n            return ids;\n        },\n        /**\n         * shows all nodes\n         * @name show_all()\n         * @trigger show_all.jstree\n         */\n        show_all : function (skip_redraw) {\n            var i, m = this._model.data, ids = [];\n            for(i in m) {\n                if(m.hasOwnProperty(i) && i !== $.jstree.root && m[i].state.hidden) {\n                    m[i].state.hidden = false;\n                    ids.push(i);\n                }\n            }\n            this._model.force_full_redraw = true;\n            if(!skip_redraw) {\n                this.redraw();\n            }\n            /**\n             * triggered when all nodes are shown\n             * @event\n             * @name show_all.jstree\n             * @param {Array} nodes the IDs of all shown nodes\n             */\n            this.trigger('show_all', { 'nodes' : ids });\n            return ids;\n        },\n        /**\n         * called when a node is selected by the user. Used internally.\n         * @private\n         * @name activate_node(obj, e)\n         * @param {mixed} obj the node\n         * @param {Object} e the related event\n         * @trigger activate_node.jstree, changed.jstree\n         */\n        activate_node : function (obj, e) {\n            if(this.is_disabled(obj)) {\n                return false;\n            }\n            if(!e || typeof e !== 'object') {\n                e = {};\n            }\n\n            // ensure last_clicked is still in the DOM, make it fresh (maybe it was moved?) and make sure it is still selected, if not - make last_clicked the last selected node\n            this._data.core.last_clicked = this._data.core.last_clicked && this._data.core.last_clicked.id !== undefined ? this.get_node(this._data.core.last_clicked.id) : null;\n            if(this._data.core.last_clicked && !this._data.core.last_clicked.state.selected) { this._data.core.last_clicked = null; }\n            if(!this._data.core.last_clicked && this._data.core.selected.length) { this._data.core.last_clicked = this.get_node(this._data.core.selected[this._data.core.selected.length - 1]); }\n\n            if(!this.settings.core.multiple || (!e.metaKey && !e.ctrlKey && !e.shiftKey) || (e.shiftKey && (!this._data.core.last_clicked || !this.get_parent(obj) || this.get_parent(obj) !== this._data.core.last_clicked.parent ) )) {\n                if(!this.settings.core.multiple && (e.metaKey || e.ctrlKey || e.shiftKey) && this.is_selected(obj)) {\n                    this.deselect_node(obj, false, e);\n                }\n                else {\n                    if (this.settings.core.allow_reselect || !this.is_selected(obj) || this._data.core.selected.length !== 1) {\n                        this.deselect_all(true);\n                        this.select_node(obj, false, false, e);\n                    }\n                    this._data.core.last_clicked = this.get_node(obj);\n                }\n            }\n            else {\n                if(e.shiftKey) {\n                    var o = this.get_node(obj).id,\n                        l = this._data.core.last_clicked.id,\n                        p = this.get_node(this._data.core.last_clicked.parent).children,\n                        c = false,\n                        i, j;\n                    for(i = 0, j = p.length; i < j; i += 1) {\n                        // separate IFs work whem o and l are the same\n                        if(p[i] === o) {\n                            c = !c;\n                        }\n                        if(p[i] === l) {\n                            c = !c;\n                        }\n                        if(!this.is_disabled(p[i]) && (c || p[i] === o || p[i] === l)) {\n                            if (!this.is_hidden(p[i])) {\n                                this.select_node(p[i], true, false, e);\n                            }\n                        }\n                        else {\n                            if (!e.ctrlKey) {\n                                this.deselect_node(p[i], true, e);\n                            }\n                        }\n                    }\n                    this.trigger('changed', { 'action' : 'select_node', 'node' : this.get_node(obj), 'selected' : this._data.core.selected, 'event' : e });\n                }\n                else {\n                    if(!this.is_selected(obj)) {\n                        if (e.ctrlKey) {\n                            this._data.core.last_clicked = this.get_node(obj);\n                        }\n                        this.select_node(obj, false, false, e);\n                    }\n                    else {\n                        this.deselect_node(obj, false, e);\n                    }\n                }\n            }\n            /**\n             * triggered when an node is clicked or intercated with by the user\n             * @event\n             * @name activate_node.jstree\n             * @param {Object} node\n             * @param {Object} event the ooriginal event (if any) which triggered the call (may be an empty object)\n             */\n            this.trigger('activate_node', { 'node' : this.get_node(obj), 'event' : e });\n        },\n        /**\n         * applies the hover state on a node, called when a node is hovered by the user. Used internally.\n         * @private\n         * @name hover_node(obj)\n         * @param {mixed} obj\n         * @trigger hover_node.jstree\n         */\n        hover_node : function (obj) {\n            obj = this.get_node(obj, true);\n            if(!obj || !obj.length || obj.children('.jstree-hovered').length) {\n                return false;\n            }\n            var o = this.element.find('.jstree-hovered'), t = this.element;\n            if(o && o.length) { this.dehover_node(o); }\n\n            obj.children('.jstree-anchor').addClass('jstree-hovered');\n            /**\n             * triggered when an node is hovered\n             * @event\n             * @name hover_node.jstree\n             * @param {Object} node\n             */\n            this.trigger('hover_node', { 'node' : this.get_node(obj) });\n            setTimeout(function () { t.attr('aria-activedescendant', obj[0].id); }, 0);\n        },\n        /**\n         * removes the hover state from a nodecalled when a node is no longer hovered by the user. Used internally.\n         * @private\n         * @name dehover_node(obj)\n         * @param {mixed} obj\n         * @trigger dehover_node.jstree\n         */\n        dehover_node : function (obj) {\n            obj = this.get_node(obj, true);\n            if(!obj || !obj.length || !obj.children('.jstree-hovered').length) {\n                return false;\n            }\n            obj.children('.jstree-anchor').removeClass('jstree-hovered');\n            /**\n             * triggered when an node is no longer hovered\n             * @event\n             * @name dehover_node.jstree\n             * @param {Object} node\n             */\n            this.trigger('dehover_node', { 'node' : this.get_node(obj) });\n        },\n        /**\n         * select a node\n         * @name select_node(obj [, supress_event, prevent_open])\n         * @param {mixed} obj an array can be used to select multiple nodes\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @param {Boolean} prevent_open if set to `true` parents of the selected node won't be opened\n         * @trigger select_node.jstree, changed.jstree\n         */\n        select_node : function (obj, supress_event, prevent_open, e) {\n            var dom, t1, t2, th;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.select_node(obj[t1], supress_event, prevent_open, e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.selected) {\n                obj.state.selected = true;\n                this._data.core.selected.push(obj.id);\n                if(!prevent_open) {\n                    dom = this._open_to(obj);\n                }\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').addClass('jstree-clicked').attr('aria-selected', true);\n                }\n                /**\n                 * triggered when an node is selected\n                 * @event\n                 * @name select_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this select_node\n                 */\n                this.trigger('select_node', { 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                if(!supress_event) {\n                    /**\n                     * triggered when selection changes\n                     * @event\n                     * @name changed.jstree\n                     * @param {Object} node\n                     * @param {Object} action the action that caused the selection to change\n                     * @param {Array} selected the current selection\n                     * @param {Object} event the event (if any) that triggered this changed event\n                     */\n                    this.trigger('changed', { 'action' : 'select_node', 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                }\n            }\n        },\n        /**\n         * deselect a node\n         * @name deselect_node(obj [, supress_event])\n         * @param {mixed} obj an array can be used to deselect multiple nodes\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger deselect_node.jstree, changed.jstree\n         */\n        deselect_node : function (obj, supress_event, e) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.deselect_node(obj[t1], supress_event, e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.selected) {\n                obj.state.selected = false;\n                this._data.core.selected = $.vakata.array_remove_item(this._data.core.selected, obj.id);\n                if(dom.length) {\n                    dom.children('.jstree-anchor').removeClass('jstree-clicked').attr('aria-selected', false);\n                }\n                /**\n                 * triggered when an node is deselected\n                 * @event\n                 * @name deselect_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this deselect_node\n                 */\n                this.trigger('deselect_node', { 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                if(!supress_event) {\n                    this.trigger('changed', { 'action' : 'deselect_node', 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                }\n            }\n        },\n        /**\n         * select all nodes in the tree\n         * @name select_all([supress_event])\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger select_all.jstree, changed.jstree\n         */\n        select_all : function (supress_event) {\n            var tmp = this._data.core.selected.concat([]), i, j;\n            this._data.core.selected = this._model.data[$.jstree.root].children_d.concat();\n            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                if(this._model.data[this._data.core.selected[i]]) {\n                    this._model.data[this._data.core.selected[i]].state.selected = true;\n                }\n            }\n            this.redraw(true);\n            /**\n             * triggered when all nodes are selected\n             * @event\n             * @name select_all.jstree\n             * @param {Array} selected the current selection\n             */\n            this.trigger('select_all', { 'selected' : this._data.core.selected });\n            if(!supress_event) {\n                this.trigger('changed', { 'action' : 'select_all', 'selected' : this._data.core.selected, 'old_selection' : tmp });\n            }\n        },\n        /**\n         * deselect all selected nodes\n         * @name deselect_all([supress_event])\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger deselect_all.jstree, changed.jstree\n         */\n        deselect_all : function (supress_event) {\n            var tmp = this._data.core.selected.concat([]), i, j;\n            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                if(this._model.data[this._data.core.selected[i]]) {\n                    this._model.data[this._data.core.selected[i]].state.selected = false;\n                }\n            }\n            this._data.core.selected = [];\n            this.element.find('.jstree-clicked').removeClass('jstree-clicked').attr('aria-selected', false);\n            /**\n             * triggered when all nodes are deselected\n             * @event\n             * @name deselect_all.jstree\n             * @param {Object} node the previous selection\n             * @param {Array} selected the current selection\n             */\n            this.trigger('deselect_all', { 'selected' : this._data.core.selected, 'node' : tmp });\n            if(!supress_event) {\n                this.trigger('changed', { 'action' : 'deselect_all', 'selected' : this._data.core.selected, 'old_selection' : tmp });\n            }\n        },\n        /**\n         * checks if a node is selected\n         * @name is_selected(obj)\n         * @param  {mixed}  obj\n         * @return {Boolean}\n         */\n        is_selected : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            return obj.state.selected;\n        },\n        /**\n         * get an array of all selected nodes\n         * @name get_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_selected : function (full) {\n            return full ? $.map(this._data.core.selected, function (i) { return this.get_node(i); }.bind(this)) : this._data.core.selected.slice();\n        },\n        /**\n         * get an array of all top level selected nodes (ignoring children of selected nodes)\n         * @name get_top_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_top_selected : function (full) {\n            var tmp = this.get_selected(true),\n                obj = {}, i, j, k, l;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                obj[tmp[i].id] = tmp[i];\n            }\n            for(i = 0, j = tmp.length; i < j; i++) {\n                for(k = 0, l = tmp[i].children_d.length; k < l; k++) {\n                    if(obj[tmp[i].children_d[k]]) {\n                        delete obj[tmp[i].children_d[k]];\n                    }\n                }\n            }\n            tmp = [];\n            for(i in obj) {\n                if(obj.hasOwnProperty(i)) {\n                    tmp.push(i);\n                }\n            }\n            return full ? $.map(tmp, function (i) { return this.get_node(i); }.bind(this)) : tmp;\n        },\n        /**\n         * get an array of all bottom level selected nodes (ignoring selected parents)\n         * @name get_bottom_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_bottom_selected : function (full) {\n            var tmp = this.get_selected(true),\n                obj = [], i, j;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                if(!tmp[i].children.length) {\n                    obj.push(tmp[i].id);\n                }\n            }\n            return full ? $.map(obj, function (i) { return this.get_node(i); }.bind(this)) : obj;\n        },\n        /**\n         * gets the current state of the tree so that it can be restored later with `set_state(state)`. Used internally.\n         * @name get_state()\n         * @private\n         * @return {Object}\n         */\n        get_state : function () {\n            var state\t= {\n                'core' : {\n                    'open' : [],\n                    'loaded' : [],\n                    'scroll' : {\n                        'left' : this.element.scrollLeft(),\n                        'top' : this.element.scrollTop()\n                    },\n                    /*!\n\t\t\t\t\t'themes' : {\n\t\t\t\t\t\t'name' : this.get_theme(),\n\t\t\t\t\t\t'icons' : this._data.core.themes.icons,\n\t\t\t\t\t\t'dots' : this._data.core.themes.dots\n\t\t\t\t\t},\n\t\t\t\t\t*/\n                    'selected' : []\n                }\n            }, i;\n            for(i in this._model.data) {\n                if(this._model.data.hasOwnProperty(i)) {\n                    if(i !== $.jstree.root) {\n                        if(this._model.data[i].state.loaded && this.settings.core.loaded_state) {\n                            state.core.loaded.push(i);\n                        }\n                        if(this._model.data[i].state.opened) {\n                            state.core.open.push(i);\n                        }\n                        if(this._model.data[i].state.selected) {\n                            state.core.selected.push(i);\n                        }\n                    }\n                }\n            }\n            return state;\n        },\n        /**\n         * sets the state of the tree. Used internally.\n         * @name set_state(state [, callback])\n         * @private\n         * @param {Object} state the state to restore. Keep in mind this object is passed by reference and jstree will modify it.\n         * @param {Function} callback an optional function to execute once the state is restored.\n         * @trigger set_state.jstree\n         */\n        set_state : function (state, callback) {\n            if(state) {\n                if(state.core && state.core.selected && state.core.initial_selection === undefined) {\n                    state.core.initial_selection = this._data.core.selected.concat([]).sort().join(',');\n                }\n                if(state.core) {\n                    var res, n, t, _this, i;\n                    if(state.core.loaded) {\n                        if(!this.settings.core.loaded_state || !$.vakata.is_array(state.core.loaded) || !state.core.loaded.length) {\n                            delete state.core.loaded;\n                            this.set_state(state, callback);\n                        }\n                        else {\n                            this._load_nodes(state.core.loaded, function (nodes) {\n                                delete state.core.loaded;\n                                this.set_state(state, callback);\n                            });\n                        }\n                        return false;\n                    }\n                    if(state.core.open) {\n                        if(!$.vakata.is_array(state.core.open) || !state.core.open.length) {\n                            delete state.core.open;\n                            this.set_state(state, callback);\n                        }\n                        else {\n                            this._load_nodes(state.core.open, function (nodes) {\n                                this.open_node(nodes, false, 0);\n                                delete state.core.open;\n                                this.set_state(state, callback);\n                            });\n                        }\n                        return false;\n                    }\n                    if(state.core.scroll) {\n                        if(state.core.scroll && state.core.scroll.left !== undefined) {\n                            this.element.scrollLeft(state.core.scroll.left);\n                        }\n                        if(state.core.scroll && state.core.scroll.top !== undefined) {\n                            this.element.scrollTop(state.core.scroll.top);\n                        }\n                        delete state.core.scroll;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                    if(state.core.selected) {\n                        _this = this;\n                        if (state.core.initial_selection === undefined ||\n                            state.core.initial_selection === this._data.core.selected.concat([]).sort().join(',')\n                        ) {\n                            this.deselect_all();\n                            $.each(state.core.selected, function (i, v) {\n                                _this.select_node(v, false, true);\n                            });\n                        }\n                        delete state.core.initial_selection;\n                        delete state.core.selected;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                    for(i in state) {\n                        if(state.hasOwnProperty(i) && i !== \"core\" && $.inArray(i, this.settings.plugins) === -1) {\n                            delete state[i];\n                        }\n                    }\n                    if($.isEmptyObject(state.core)) {\n                        delete state.core;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                }\n                if($.isEmptyObject(state)) {\n                    state = null;\n                    if(callback) { callback.call(this); }\n                    /**\n                     * triggered when a `set_state` call completes\n                     * @event\n                     * @name set_state.jstree\n                     */\n                    this.trigger('set_state');\n                    return false;\n                }\n                return true;\n            }\n            return false;\n        },\n        /**\n         * refreshes the tree - all nodes are reloaded with calls to `load_node`.\n         * @name refresh()\n         * @param {Boolean} skip_loading an option to skip showing the loading indicator\n         * @param {Mixed} forget_state if set to `true` state will not be reapplied, if set to a function (receiving the current state as argument) the result of that function will be used as state\n         * @trigger refresh.jstree\n         */\n        refresh : function (skip_loading, forget_state) {\n            this._data.core.state = forget_state === true ? {} : this.get_state();\n            if(forget_state && $.vakata.is_function(forget_state)) { this._data.core.state = forget_state.call(this, this._data.core.state); }\n            this._cnt = 0;\n            this._model.data = {};\n            this._model.data[$.jstree.root] = {\n                id : $.jstree.root,\n                parent : null,\n                parents : [],\n                children : [],\n                children_d : [],\n                state : { loaded : false }\n            };\n            this._data.core.selected = [];\n            this._data.core.last_clicked = null;\n            this._data.core.focused = null;\n\n            var c = this.get_container_ul()[0].className;\n            if(!skip_loading) {\n                this.element.html(\"<\"+\"ul class='\"+c+\"' role='group'><\"+\"li class='jstree-initial-node jstree-loading jstree-leaf jstree-last' role='none' id='j\"+this._id+\"_loading'><i class='jstree-icon jstree-ocl'></i><\"+\"a class='jstree-anchor' role='treeitem' href='#'><i class='jstree-icon jstree-themeicon-hidden'></i>\" + this.get_string(\"Loading ...\") + \"</a></li></ul>\");\n                this.element.attr('aria-activedescendant','j'+this._id+'_loading');\n            }\n            this.load_node($.jstree.root, function (o, s) {\n                if(s) {\n                    this.get_container_ul()[0].className = c;\n                    if(this._firstChild(this.get_container_ul()[0])) {\n                        this.element.attr('aria-activedescendant',this._firstChild(this.get_container_ul()[0]).id);\n                    }\n                    this.set_state($.extend(true, {}, this._data.core.state), function () {\n                        /**\n                         * triggered when a `refresh` call completes\n                         * @event\n                         * @name refresh.jstree\n                         */\n                        this.trigger('refresh');\n                    });\n                }\n                this._data.core.state = null;\n            });\n        },\n        /**\n         * refreshes a node in the tree (reload its children) all opened nodes inside that node are reloaded with calls to `load_node`.\n         * @name refresh_node(obj)\n         * @param  {mixed} obj the node\n         * @trigger refresh_node.jstree\n         */\n        refresh_node : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var opened = [], to_load = [], s = this._data.core.selected.concat([]);\n            to_load.push(obj.id);\n            if(obj.state.opened === true) { opened.push(obj.id); }\n            this.get_node(obj, true).find('.jstree-open').each(function() { to_load.push(this.id); opened.push(this.id); });\n            this._load_nodes(to_load, function (nodes) {\n                this.open_node(opened, false, 0);\n                this.select_node(s);\n                /**\n                 * triggered when a node is refreshed\n                 * @event\n                 * @name refresh_node.jstree\n                 * @param {Object} node - the refreshed node\n                 * @param {Array} nodes - an array of the IDs of the nodes that were reloaded\n                 */\n                this.trigger('refresh_node', { 'node' : obj, 'nodes' : nodes });\n            }.bind(this), false, true);\n        },\n        /**\n         * set (change) the ID of a node\n         * @name set_id(obj, id)\n         * @param  {mixed} obj the node\n         * @param  {String} id the new ID\n         * @return {Boolean}\n         * @trigger set_id.jstree\n         */\n        set_id : function (obj, id) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var i, j, m = this._model.data, old = obj.id;\n            id = id.toString();\n            // update parents (replace current ID with new one in children and children_d)\n            m[obj.parent].children[$.inArray(obj.id, m[obj.parent].children)] = id;\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                m[obj.parents[i]].children_d[$.inArray(obj.id, m[obj.parents[i]].children_d)] = id;\n            }\n            // update children (replace current ID with new one in parent and parents)\n            for(i = 0, j = obj.children.length; i < j; i++) {\n                m[obj.children[i]].parent = id;\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                m[obj.children_d[i]].parents[$.inArray(obj.id, m[obj.children_d[i]].parents)] = id;\n            }\n            i = $.inArray(obj.id, this._data.core.selected);\n            if(i !== -1) { this._data.core.selected[i] = id; }\n            // update model and obj itself (obj.id, this._model.data[KEY])\n            i = this.get_node(obj.id, true);\n            if(i) {\n                i.attr('id', id); //.children('.jstree-anchor').attr('id', id + '_anchor').end().attr('aria-labelledby', id + '_anchor');\n                if(this.element.attr('aria-activedescendant') === obj.id) {\n                    this.element.attr('aria-activedescendant', id);\n                }\n            }\n            delete m[obj.id];\n            obj.id = id;\n            obj.li_attr.id = id;\n            m[id] = obj;\n            /**\n             * triggered when a node id value is changed\n             * @event\n             * @name set_id.jstree\n             * @param {Object} node\n             * @param {String} old the old id\n             */\n            this.trigger('set_id',{ \"node\" : obj, \"new\" : obj.id, \"old\" : old });\n            return true;\n        },\n        /**\n         * get the text value of a node\n         * @name get_text(obj)\n         * @param  {mixed} obj the node\n         * @return {String}\n         */\n        get_text : function (obj) {\n            obj = this.get_node(obj);\n            return (!obj || obj.id === $.jstree.root) ? false : obj.text;\n        },\n        /**\n         * set the text value of a node. Used internally, please use `rename_node(obj, val)`.\n         * @private\n         * @name set_text(obj, val)\n         * @param  {mixed} obj the node, you can pass an array to set the text on multiple nodes\n         * @param  {String} val the new text value\n         * @return {Boolean}\n         * @trigger set_text.jstree\n         */\n        set_text : function (obj, val) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_text(obj[t1], val);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            obj.text = val;\n            if(this.get_node(obj, true).length) {\n                this.redraw_node(obj.id);\n            }\n            /**\n             * triggered when a node text value is changed\n             * @event\n             * @name set_text.jstree\n             * @param {Object} obj\n             * @param {String} text the new value\n             */\n            this.trigger('set_text',{ \"obj\" : obj, \"text\" : val });\n            return true;\n        },\n        /**\n         * gets a JSON representation of a node (or the whole tree)\n         * @name get_json([obj, options])\n         * @param  {mixed} obj\n         * @param  {Object} options\n         * @param  {Boolean} options.no_state do not return state information\n         * @param  {Boolean} options.no_id do not return ID\n         * @param  {Boolean} options.no_children do not include children\n         * @param  {Boolean} options.no_data do not include node data\n         * @param  {Boolean} options.no_li_attr do not include LI attributes\n         * @param  {Boolean} options.no_a_attr do not include A attributes\n         * @param  {Boolean} options.flat return flat JSON instead of nested\n         * @return {Object}\n         */\n        get_json : function (obj, options, flat) {\n            obj = this.get_node(obj || $.jstree.root);\n            if(!obj) { return false; }\n            if(options && options.flat && !flat) { flat = []; }\n            var tmp = {\n                'id' : obj.id,\n                'text' : obj.text,\n                'icon' : this.get_icon(obj),\n                'li_attr' : $.extend(true, {}, obj.li_attr),\n                'a_attr' : $.extend(true, {}, obj.a_attr),\n                'state' : {},\n                'data' : options && options.no_data ? false : $.extend(true, $.vakata.is_array(obj.data)?[]:{}, obj.data)\n                //( this.get_node(obj, true).length ? this.get_node(obj, true).data() : obj.data ),\n            }, i, j;\n            if(options && options.flat) {\n                tmp.parent = obj.parent;\n            }\n            else {\n                tmp.children = [];\n            }\n            if(!options || !options.no_state) {\n                for(i in obj.state) {\n                    if(obj.state.hasOwnProperty(i)) {\n                        tmp.state[i] = obj.state[i];\n                    }\n                }\n            } else {\n                delete tmp.state;\n            }\n            if(options && options.no_li_attr) {\n                delete tmp.li_attr;\n            }\n            if(options && options.no_a_attr) {\n                delete tmp.a_attr;\n            }\n            if(options && options.no_id) {\n                delete tmp.id;\n                if(tmp.li_attr && tmp.li_attr.id) {\n                    delete tmp.li_attr.id;\n                }\n                if(tmp.a_attr && tmp.a_attr.id) {\n                    delete tmp.a_attr.id;\n                }\n            }\n            if(options && options.flat && obj.id !== $.jstree.root) {\n                flat.push(tmp);\n            }\n            if(!options || !options.no_children) {\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    if(options && options.flat) {\n                        this.get_json(obj.children[i], options, flat);\n                    }\n                    else {\n                        tmp.children.push(this.get_json(obj.children[i], options));\n                    }\n                }\n            }\n            return options && options.flat ? flat : (obj.id === $.jstree.root ? tmp.children : tmp);\n        },\n        /**\n         * create a new node (do not confuse with load_node)\n         * @name create_node([par, node, pos, callback, is_loaded])\n         * @param  {mixed}   par       the parent node (to create a root node use either \"#\" (string) or `null`)\n         * @param  {mixed}   node      the data for the new node (a valid JSON object, or a simple string with the name)\n         * @param  {mixed}   pos       the index at which to insert the node, \"first\" and \"last\" are also supported, default is \"last\"\n         * @param  {Function} callback a function to be called once the node is created\n         * @param  {Boolean} is_loaded internal argument indicating if the parent node was succesfully loaded\n         * @return {String}            the ID of the newly create node\n         * @trigger model.jstree, create_node.jstree\n         */\n        create_node : function (par, node, pos, callback, is_loaded) {\n            if(par === null) { par = $.jstree.root; }\n            par = this.get_node(par);\n            if(!par) { return false; }\n            pos = pos === undefined ? \"last\" : pos;\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.create_node(par, node, pos, callback, true); });\n            }\n            if(!node) { node = { \"text\" : this.get_string('New node') }; }\n            if(typeof node === \"string\") {\n                node = { \"text\" : node };\n            } else {\n                node = $.extend(true, {}, node);\n            }\n            if(node.text === undefined) { node.text = this.get_string('New node'); }\n            var tmp, dpc, i, j;\n\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    tmp = this.get_node(par.parent);\n                    pos = $.inArray(par.id, tmp.children);\n                    par = tmp;\n                    break;\n                case \"after\" :\n                    tmp = this.get_node(par.parent);\n                    pos = $.inArray(par.id, tmp.children) + 1;\n                    par = tmp;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > par.children.length) { pos = par.children.length; }\n            if(node.id === undefined) { node.id = true; }\n            if(!this.check(\"create_node\", node, par, pos)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(node.id === true) { delete node.id; }\n            node = this._parse_model_from_json(node, par.id, par.parents.concat());\n            if(!node) { return false; }\n            tmp = this.get_node(node);\n            dpc = [];\n            dpc.push(node);\n            dpc = dpc.concat(tmp.children_d);\n            this.trigger('model', { \"nodes\" : dpc, \"parent\" : par.id });\n\n            par.children_d = par.children_d.concat(dpc);\n            for(i = 0, j = par.parents.length; i < j; i++) {\n                this._model.data[par.parents[i]].children_d = this._model.data[par.parents[i]].children_d.concat(dpc);\n            }\n            node = tmp;\n            tmp = [];\n            for(i = 0, j = par.children.length; i < j; i++) {\n                tmp[i >= pos ? i+1 : i] = par.children[i];\n            }\n            tmp[pos] = node.id;\n            par.children = tmp;\n\n            this.redraw_node(par, true);\n            /**\n             * triggered when a node is created\n             * @event\n             * @name create_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the new node among the parent's children\n             */\n            this.trigger('create_node', { \"node\" : this.get_node(node), \"parent\" : par.id, \"position\" : pos });\n            if(callback) { callback.call(this, this.get_node(node)); }\n            return node.id;\n        },\n        /**\n         * set the text value of a node\n         * @name rename_node(obj, val)\n         * @param  {mixed} obj the node, you can pass an array to rename multiple nodes to the same name\n         * @param  {String} val the new text value\n         * @return {Boolean}\n         * @trigger rename_node.jstree\n         */\n        rename_node : function (obj, val) {\n            var t1, t2, old;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.rename_node(obj[t1], val);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            old = obj.text;\n            if(!this.check(\"rename_node\", obj, this.get_parent(obj), val)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            this.set_text(obj, val); // .apply(this, Array.prototype.slice.call(arguments))\n            /**\n             * triggered when a node is renamed\n             * @event\n             * @name rename_node.jstree\n             * @param {Object} node\n             * @param {String} text the new value\n             * @param {String} old the old value\n             */\n            this.trigger('rename_node', { \"node\" : obj, \"text\" : val, \"old\" : old });\n            return true;\n        },\n        /**\n         * remove a node\n         * @name delete_node(obj)\n         * @param  {mixed} obj the node, you can pass an array to delete multiple nodes\n         * @return {Boolean}\n         * @trigger delete_node.jstree, changed.jstree\n         */\n        delete_node : function (obj) {\n            var t1, t2, par, pos, tmp, i, j, k, l, c, top, lft;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.delete_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            par = this.get_node(obj.parent);\n            pos = $.inArray(obj.id, par.children);\n            c = false;\n            if(!this.check(\"delete_node\", obj, par, pos)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(pos !== -1) {\n                par.children = $.vakata.array_remove(par.children, pos);\n            }\n            tmp = obj.children_d.concat([]);\n            tmp.push(obj.id);\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                this._model.data[obj.parents[i]].children_d = $.vakata.array_filter(this._model.data[obj.parents[i]].children_d, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            for(k = 0, l = tmp.length; k < l; k++) {\n                if(this._model.data[tmp[k]].state.selected) {\n                    c = true;\n                    break;\n                }\n            }\n            if (c) {\n                this._data.core.selected = $.vakata.array_filter(this._data.core.selected, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            /**\n             * triggered when a node is deleted\n             * @event\n             * @name delete_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             */\n            this.trigger('delete_node', { \"node\" : obj, \"parent\" : par.id });\n            if(c) {\n                this.trigger('changed', { 'action' : 'delete_node', 'node' : obj, 'selected' : this._data.core.selected, 'parent' : par.id });\n            }\n            for(k = 0, l = tmp.length; k < l; k++) {\n                delete this._model.data[tmp[k]];\n            }\n            if($.inArray(this._data.core.focused, tmp) !== -1) {\n                this._data.core.focused = null;\n                top = this.element[0].scrollTop;\n                lft = this.element[0].scrollLeft;\n                if(par.id === $.jstree.root) {\n                    if (this._model.data[$.jstree.root].children[0]) {\n                        this.get_node(this._model.data[$.jstree.root].children[0], true).children('.jstree-anchor').trigger('focus');\n                    }\n                }\n                else {\n                    this.get_node(par, true).children('.jstree-anchor').trigger('focus');\n                }\n                this.element[0].scrollTop  = top;\n                this.element[0].scrollLeft = lft;\n            }\n            this.redraw_node(par, true);\n            return true;\n        },\n        /**\n         * check if an operation is premitted on the tree. Used internally.\n         * @private\n         * @name check(chk, obj, par, pos)\n         * @param  {String} chk the operation to check, can be \"create_node\", \"rename_node\", \"delete_node\", \"copy_node\" or \"move_node\"\n         * @param  {mixed} obj the node\n         * @param  {mixed} par the parent\n         * @param  {mixed} pos the position to insert at, or if \"rename_node\" - the new name\n         * @param  {mixed} more some various additional information, for example if a \"move_node\" operations is triggered by DND this will be the hovered node\n         * @return {Boolean}\n         */\n        check : function (chk, obj, par, pos, more) {\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            var tmp = chk.match(/^(move_node|copy_node|create_node)$/i) ? par : obj,\n                chc = this.settings.core.check_callback;\n            if(chk === \"move_node\" || chk === \"copy_node\") {\n                if((!more || !more.is_multi) && (chk === \"move_node\" && $.inArray(obj.id, par.children) === pos)) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_08', 'reason' : 'Moving node to its current position', 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    return false;\n                }\n                if((!more || !more.is_multi) && (obj.id === par.id || (chk === \"move_node\" && $.inArray(obj.id, par.children) === pos) || $.inArray(par.id, obj.children_d) !== -1)) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_01', 'reason' : 'Moving parent inside child', 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    return false;\n                }\n            }\n            if(tmp && tmp.data) { tmp = tmp.data; }\n            if(tmp && tmp.functions && (tmp.functions[chk] === false || tmp.functions[chk] === true)) {\n                if(tmp.functions[chk] === false) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_02', 'reason' : 'Node data prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                }\n                return tmp.functions[chk];\n            }\n            if(chc === false || ($.vakata.is_function(chc) && chc.call(this, chk, obj, par, pos, more) === false) || (chc && chc[chk] === false)) {\n                this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_03', 'reason' : 'User config for core.check_callback prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                return false;\n            }\n            return true;\n        },\n        /**\n         * get the last error\n         * @name last_error()\n         * @return {Object}\n         */\n        last_error : function () {\n            return this._data.core.last_error;\n        },\n        /**\n         * move a node to a new parent\n         * @name move_node(obj, par [, pos, callback, is_loaded])\n         * @param  {mixed} obj the node to move, pass an array to move multiple nodes\n         * @param  {mixed} par the new parent\n         * @param  {mixed} pos the position to insert at (besides integer values, \"first\" and \"last\" are supported, as well as \"before\" and \"after\"), defaults to integer `0`\n         * @param  {function} callback a function to call once the move is completed, receives 3 arguments - the node, the new parent and the position\n         * @param  {Boolean} is_loaded internal parameter indicating if the parent node has been loaded\n         * @param  {Boolean} skip_redraw internal parameter indicating if the tree should be redrawn\n         * @param  {Boolean} instance internal parameter indicating if the node comes from another instance\n         * @trigger move_node.jstree\n         */\n        move_node : function (obj, par, pos, callback, is_loaded, skip_redraw, origin) {\n            var t1, t2, old_par, old_pos, new_par, old_ins, is_multi, dpc, tmp, i, j, k, l, p;\n\n            par = this.get_node(par);\n            pos = pos === undefined ? 0 : pos;\n            if(!par) { return false; }\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.move_node(obj, par, pos, callback, true, false, origin); });\n            }\n\n            if($.vakata.is_array(obj)) {\n                if(obj.length === 1) {\n                    obj = obj[0];\n                }\n                else {\n                    //obj = obj.slice();\n                    for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                        if((tmp = this.move_node(obj[t1], par, pos, callback, is_loaded, false, origin))) {\n                            par = tmp;\n                            pos = \"after\";\n                        }\n                    }\n                    this.redraw();\n                    return true;\n                }\n            }\n            obj = obj && (obj.id !== undefined) ? obj : this.get_node(obj);\n\n            if(!obj || obj.id === $.jstree.root) { return false; }\n\n            old_par = (obj.parent || $.jstree.root).toString();\n            new_par = (!pos.toString().match(/^(before|after)$/) || par.id === $.jstree.root) ? par : this.get_node(par.parent);\n            old_ins = origin ? origin : (this._model.data[obj.id] ? this : $.jstree.reference(obj.id));\n            is_multi = !old_ins || !old_ins._id || (this._id !== old_ins._id);\n            old_pos = old_ins && old_ins._id && old_par && old_ins._model.data[old_par] && old_ins._model.data[old_par].children ? $.inArray(obj.id, old_ins._model.data[old_par].children) : -1;\n            if(old_ins && old_ins._id) {\n                obj = old_ins._model.data[obj.id];\n            }\n\n            if(is_multi) {\n                if((tmp = this.copy_node(obj, par, pos, callback, is_loaded, false, origin))) {\n                    if(old_ins) { old_ins.delete_node(obj); }\n                    return tmp;\n                }\n                return false;\n            }\n            //var m = this._model.data;\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    pos = $.inArray(par.id, new_par.children);\n                    break;\n                case \"after\" :\n                    pos = $.inArray(par.id, new_par.children) + 1;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = new_par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > new_par.children.length) { pos = new_par.children.length; }\n            if(!this.check(\"move_node\", obj, new_par, pos, { 'core' : true, 'origin' : origin, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id) })) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(obj.parent === new_par.id) {\n                dpc = new_par.children.concat();\n                tmp = $.inArray(obj.id, dpc);\n                if(tmp !== -1) {\n                    dpc = $.vakata.array_remove(dpc, tmp);\n                    if(pos > tmp) { pos--; }\n                }\n                tmp = [];\n                for(i = 0, j = dpc.length; i < j; i++) {\n                    tmp[i >= pos ? i+1 : i] = dpc[i];\n                }\n                tmp[pos] = obj.id;\n                new_par.children = tmp;\n                this._node_changed(new_par.id);\n                this.redraw(new_par.id === $.jstree.root);\n            }\n            else {\n                // clean old parent and up\n                tmp = obj.children_d.concat();\n                tmp.push(obj.id);\n                for(i = 0, j = obj.parents.length; i < j; i++) {\n                    dpc = [];\n                    p = old_ins._model.data[obj.parents[i]].children_d;\n                    for(k = 0, l = p.length; k < l; k++) {\n                        if($.inArray(p[k], tmp) === -1) {\n                            dpc.push(p[k]);\n                        }\n                    }\n                    old_ins._model.data[obj.parents[i]].children_d = dpc;\n                }\n                old_ins._model.data[old_par].children = $.vakata.array_remove_item(old_ins._model.data[old_par].children, obj.id);\n\n                // insert into new parent and up\n                for(i = 0, j = new_par.parents.length; i < j; i++) {\n                    this._model.data[new_par.parents[i]].children_d = this._model.data[new_par.parents[i]].children_d.concat(tmp);\n                }\n                dpc = [];\n                for(i = 0, j = new_par.children.length; i < j; i++) {\n                    dpc[i >= pos ? i+1 : i] = new_par.children[i];\n                }\n                dpc[pos] = obj.id;\n                new_par.children = dpc;\n                new_par.children_d.push(obj.id);\n                new_par.children_d = new_par.children_d.concat(obj.children_d);\n\n                // update object\n                obj.parent = new_par.id;\n                tmp = new_par.parents.concat();\n                tmp.unshift(new_par.id);\n                p = obj.parents.length;\n                obj.parents = tmp;\n\n                // update object children\n                tmp = tmp.concat();\n                for(i = 0, j = obj.children_d.length; i < j; i++) {\n                    this._model.data[obj.children_d[i]].parents = this._model.data[obj.children_d[i]].parents.slice(0,p*-1);\n                    Array.prototype.push.apply(this._model.data[obj.children_d[i]].parents, tmp);\n                }\n\n                if(old_par === $.jstree.root || new_par.id === $.jstree.root) {\n                    this._model.force_full_redraw = true;\n                }\n                if(!this._model.force_full_redraw) {\n                    this._node_changed(old_par);\n                    this._node_changed(new_par.id);\n                }\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n            }\n            if(callback) { callback.call(this, obj, new_par, pos); }\n            /**\n             * triggered when a node is moved\n             * @event\n             * @name move_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the node among the parent's children\n             * @param {String} old_parent the old parent of the node\n             * @param {Number} old_position the old position of the node\n             * @param {Boolean} is_multi do the node and new parent belong to different instances\n             * @param {jsTree} old_instance the instance the node came from\n             * @param {jsTree} new_instance the instance of the new parent\n             */\n            this.trigger('move_node', { \"node\" : obj, \"parent\" : new_par.id, \"position\" : pos, \"old_parent\" : old_par, \"old_position\" : old_pos, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id), 'old_instance' : old_ins, 'new_instance' : this });\n            return obj.id;\n        },\n        /**\n         * copy a node to a new parent\n         * @name copy_node(obj, par [, pos, callback, is_loaded])\n         * @param  {mixed} obj the node to copy, pass an array to copy multiple nodes\n         * @param  {mixed} par the new parent\n         * @param  {mixed} pos the position to insert at (besides integer values, \"first\" and \"last\" are supported, as well as \"before\" and \"after\"), defaults to integer `0`\n         * @param  {function} callback a function to call once the move is completed, receives 3 arguments - the node, the new parent and the position\n         * @param  {Boolean} is_loaded internal parameter indicating if the parent node has been loaded\n         * @param  {Boolean} skip_redraw internal parameter indicating if the tree should be redrawn\n         * @param  {Boolean} instance internal parameter indicating if the node comes from another instance\n         * @trigger model.jstree copy_node.jstree\n         */\n        copy_node : function (obj, par, pos, callback, is_loaded, skip_redraw, origin) {\n            var t1, t2, dpc, tmp, i, j, node, old_par, new_par, old_ins, is_multi;\n\n            par = this.get_node(par);\n            pos = pos === undefined ? 0 : pos;\n            if(!par) { return false; }\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.copy_node(obj, par, pos, callback, true, false, origin); });\n            }\n\n            if($.vakata.is_array(obj)) {\n                if(obj.length === 1) {\n                    obj = obj[0];\n                }\n                else {\n                    //obj = obj.slice();\n                    for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                        if((tmp = this.copy_node(obj[t1], par, pos, callback, is_loaded, true, origin))) {\n                            par = tmp;\n                            pos = \"after\";\n                        }\n                    }\n                    this.redraw();\n                    return true;\n                }\n            }\n            obj = obj && (obj.id !== undefined) ? obj : this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n\n            old_par = (obj.parent || $.jstree.root).toString();\n            new_par = (!pos.toString().match(/^(before|after)$/) || par.id === $.jstree.root) ? par : this.get_node(par.parent);\n            old_ins = origin ? origin : (this._model.data[obj.id] ? this : $.jstree.reference(obj.id));\n            is_multi = !old_ins || !old_ins._id || (this._id !== old_ins._id);\n\n            if(old_ins && old_ins._id) {\n                obj = old_ins._model.data[obj.id];\n            }\n\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    pos = $.inArray(par.id, new_par.children);\n                    break;\n                case \"after\" :\n                    pos = $.inArray(par.id, new_par.children) + 1;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = new_par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > new_par.children.length) { pos = new_par.children.length; }\n            if(!this.check(\"copy_node\", obj, new_par, pos, { 'core' : true, 'origin' : origin, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id) })) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            node = old_ins ? old_ins.get_json(obj, { no_id : true, no_data : true, no_state : true }) : obj;\n            if(!node) { return false; }\n            if(node.id === true) { delete node.id; }\n            node = this._parse_model_from_json(node, new_par.id, new_par.parents.concat());\n            if(!node) { return false; }\n            tmp = this.get_node(node);\n            if(obj && obj.state && obj.state.loaded === false) { tmp.state.loaded = false; }\n            dpc = [];\n            dpc.push(node);\n            dpc = dpc.concat(tmp.children_d);\n            this.trigger('model', { \"nodes\" : dpc, \"parent\" : new_par.id });\n\n            // insert into new parent and up\n            for(i = 0, j = new_par.parents.length; i < j; i++) {\n                this._model.data[new_par.parents[i]].children_d = this._model.data[new_par.parents[i]].children_d.concat(dpc);\n            }\n            dpc = [];\n            for(i = 0, j = new_par.children.length; i < j; i++) {\n                dpc[i >= pos ? i+1 : i] = new_par.children[i];\n            }\n            dpc[pos] = tmp.id;\n            new_par.children = dpc;\n            new_par.children_d.push(tmp.id);\n            new_par.children_d = new_par.children_d.concat(tmp.children_d);\n\n            if(new_par.id === $.jstree.root) {\n                this._model.force_full_redraw = true;\n            }\n            if(!this._model.force_full_redraw) {\n                this._node_changed(new_par.id);\n            }\n            if(!skip_redraw) {\n                this.redraw(new_par.id === $.jstree.root);\n            }\n            if(callback) { callback.call(this, tmp, new_par, pos); }\n            /**\n             * triggered when a node is copied\n             * @event\n             * @name copy_node.jstree\n             * @param {Object} node the copied node\n             * @param {Object} original the original node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the node among the parent's children\n             * @param {String} old_parent the old parent of the node\n             * @param {Number} old_position the position of the original node\n             * @param {Boolean} is_multi do the node and new parent belong to different instances\n             * @param {jsTree} old_instance the instance the node came from\n             * @param {jsTree} new_instance the instance of the new parent\n             */\n            this.trigger('copy_node', { \"node\" : tmp, \"original\" : obj, \"parent\" : new_par.id, \"position\" : pos, \"old_parent\" : old_par, \"old_position\" : old_ins && old_ins._id && old_par && old_ins._model.data[old_par] && old_ins._model.data[old_par].children ? $.inArray(obj.id, old_ins._model.data[old_par].children) : -1,'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id), 'old_instance' : old_ins, 'new_instance' : this });\n            return tmp.id;\n        },\n        /**\n         * cut a node (a later call to `paste(obj)` would move the node)\n         * @name cut(obj)\n         * @param  {mixed} obj multiple objects can be passed using an array\n         * @trigger cut.jstree\n         */\n        cut : function (obj) {\n            if(!obj) { obj = this._data.core.selected.concat(); }\n            if(!$.vakata.is_array(obj)) { obj = [obj]; }\n            if(!obj.length) { return false; }\n            var tmp = [], o, t1, t2;\n            for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                o = this.get_node(obj[t1]);\n                if(o && (o.id || o.id === 0) && o.id !== $.jstree.root) { tmp.push(o); }\n            }\n            if(!tmp.length) { return false; }\n            ccp_node = tmp;\n            ccp_inst = this;\n            ccp_mode = 'move_node';\n            /**\n             * triggered when nodes are added to the buffer for moving\n             * @event\n             * @name cut.jstree\n             * @param {Array} node\n             */\n            this.trigger('cut', { \"node\" : obj });\n        },\n        /**\n         * copy a node (a later call to `paste(obj)` would copy the node)\n         * @name copy(obj)\n         * @param  {mixed} obj multiple objects can be passed using an array\n         * @trigger copy.jstree\n         */\n        copy : function (obj) {\n            if(!obj) { obj = this._data.core.selected.concat(); }\n            if(!$.vakata.is_array(obj)) { obj = [obj]; }\n            if(!obj.length) { return false; }\n            var tmp = [], o, t1, t2;\n            for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                o = this.get_node(obj[t1]);\n                if(o && (o.id !== undefined) && o.id !== $.jstree.root) { tmp.push(o); }\n            }\n            if(!tmp.length) { return false; }\n            ccp_node = tmp;\n            ccp_inst = this;\n            ccp_mode = 'copy_node';\n            /**\n             * triggered when nodes are added to the buffer for copying\n             * @event\n             * @name copy.jstree\n             * @param {Array} node\n             */\n            this.trigger('copy', { \"node\" : obj });\n        },\n        /**\n         * get the current buffer (any nodes that are waiting for a paste operation)\n         * @name get_buffer()\n         * @return {Object} an object consisting of `mode` (\"copy_node\" or \"move_node\"), `node` (an array of objects) and `inst` (the instance)\n         */\n        get_buffer : function () {\n            return { 'mode' : ccp_mode, 'node' : ccp_node, 'inst' : ccp_inst };\n        },\n        /**\n         * check if there is something in the buffer to paste\n         * @name can_paste()\n         * @return {Boolean}\n         */\n        can_paste : function () {\n            return ccp_mode !== false && ccp_node !== false; // && ccp_inst._model.data[ccp_node];\n        },\n        /**\n         * copy or move the previously cut or copied nodes to a new parent\n         * @name paste(obj [, pos])\n         * @param  {mixed} obj the new parent\n         * @param  {mixed} pos the position to insert at (besides integer, \"first\" and \"last\" are supported), defaults to integer `0`\n         * @trigger paste.jstree\n         */\n        paste : function (obj, pos) {\n            obj = this.get_node(obj);\n            if(!obj || !ccp_mode || !ccp_mode.match(/^(copy_node|move_node)$/) || !ccp_node) { return false; }\n            if(this[ccp_mode](ccp_node, obj, pos, false, false, false, ccp_inst)) {\n                /**\n                 * triggered when paste is invoked\n                 * @event\n                 * @name paste.jstree\n                 * @param {String} parent the ID of the receiving node\n                 * @param {Array} node the nodes in the buffer\n                 * @param {String} mode the performed operation - \"copy_node\" or \"move_node\"\n                 */\n                this.trigger('paste', { \"parent\" : obj.id, \"node\" : ccp_node, \"mode\" : ccp_mode });\n            }\n            ccp_node = false;\n            ccp_mode = false;\n            ccp_inst = false;\n        },\n        /**\n         * clear the buffer of previously copied or cut nodes\n         * @name clear_buffer()\n         * @trigger clear_buffer.jstree\n         */\n        clear_buffer : function () {\n            ccp_node = false;\n            ccp_mode = false;\n            ccp_inst = false;\n            /**\n             * triggered when the copy / cut buffer is cleared\n             * @event\n             * @name clear_buffer.jstree\n             */\n            this.trigger('clear_buffer');\n        },\n        /**\n         * put a node in edit mode (input field to rename the node)\n         * @name edit(obj [, default_text, callback])\n         * @param  {mixed} obj\n         * @param  {String} default_text the text to populate the input with (if omitted or set to a non-string value the node's text value is used)\n         * @param  {Function} callback a function to be called once the text box is blurred, it is called in the instance's scope and receives the node, a status parameter (true if the rename is successful, false otherwise), a boolean indicating if the user cancelled the edit and the original unescaped value provided by the user. You can also access the node's title using .text\n         */\n        edit : function (obj, default_text, callback) {\n            var rtl, w, a, s, t, h1, h2, fn, tmp, cancel = false;\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            if(!this.check(\"edit\", obj, this.get_parent(obj))) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            tmp = obj;\n            default_text = typeof default_text === 'string' ? default_text : obj.text;\n            this.set_text(obj, \"\");\n            obj = this._open_to(obj);\n            tmp.text = default_text;\n\n            rtl = this._data.core.rtl;\n            w  = this.element.width();\n            this._data.core.focused = tmp.id;\n            a  = obj.children('.jstree-anchor').trigger('focus');\n            s  = $('<span></span>');\n            /*!\n\t\t\toi = obj.children(\"i:visible\"),\n\t\t\tai = a.children(\"i:visible\"),\n\t\t\tw1 = oi.width() * oi.length,\n\t\t\tw2 = ai.width() * ai.length,\n\t\t\t*/\n            t  = default_text;\n            h1 = $(\"<\"+\"div></div>\", { css : { \"position\" : \"absolute\", \"top\" : \"-200px\", \"left\" : (rtl ? \"0px\" : \"-1000px\"), \"visibility\" : \"hidden\" } }).appendTo(document.body);\n            h2 = $(\"<\"+\"input />\", {\n                \"value\" : t,\n                \"class\" : \"jstree-rename-input\",\n                // \"size\" : t.length,\n                \"css\" : {\n                    \"padding\" : \"0\",\n                    \"border\" : \"1px solid silver\",\n                    \"box-sizing\" : \"border-box\",\n                    \"display\" : \"inline-block\",\n                    \"height\" : (this._data.core.li_height) + \"px\",\n                    \"lineHeight\" : (this._data.core.li_height) + \"px\",\n                    \"width\" : \"150px\" // will be set a bit further down\n                },\n                \"blur\" : function (e) {\n                    e.stopImmediatePropagation();\n                    e.preventDefault();\n                    var i = s.children(\".jstree-rename-input\"),\n                        v = i.val(),\n                        f = this.settings.core.force_text,\n                        nv;\n                    if(v === \"\") { v = t; }\n                    h1.remove();\n                    s.replaceWith(a);\n                    s.remove();\n                    t = f ? t : $('<div></div>').append($.parseHTML(t)).html();\n                    obj = this.get_node(obj);\n                    this.set_text(obj, t);\n                    nv = !!this.rename_node(obj, f ? $('<div></div>').text(v).text() : $('<div></div>').append($.parseHTML(v)).html());\n                    if(!nv) {\n                        this.set_text(obj, t); // move this up? and fix #483\n                    }\n                    this._data.core.focused = tmp.id;\n                    setTimeout(function () {\n                        var node = this.get_node(tmp.id, true);\n                        if(node.length) {\n                            this._data.core.focused = tmp.id;\n                            node.children('.jstree-anchor').trigger('focus');\n                        }\n                    }.bind(this), 0);\n                    if(callback) {\n                        callback.call(this, tmp, nv, cancel, v);\n                    }\n                    h2 = null;\n                }.bind(this),\n                \"keydown\" : function (e) {\n                    var key = e.which;\n                    if(key === 27) {\n                        cancel = true;\n                        this.value = t;\n                    }\n                    if(key === 27 || key === 13 || key === 37 || key === 38 || key === 39 || key === 40 || key === 32) {\n                        e.stopImmediatePropagation();\n                    }\n                    if(key === 27 || key === 13) {\n                        e.preventDefault();\n                        this.blur();\n                    }\n                },\n                \"click\" : function (e) { e.stopImmediatePropagation(); },\n                \"mousedown\" : function (e) { e.stopImmediatePropagation(); },\n                \"keyup\" : function (e) {\n                    h2.width(Math.min(h1.text(\"pW\" + this.value).width(),w));\n                },\n                \"keypress\" : function(e) {\n                    if(e.which === 13) { return false; }\n                }\n            });\n            fn = {\n                fontFamily\t\t: a.css('fontFamily')\t\t|| '',\n                fontSize\t\t: a.css('fontSize')\t\t\t|| '',\n                fontWeight\t\t: a.css('fontWeight')\t\t|| '',\n                fontStyle\t\t: a.css('fontStyle')\t\t|| '',\n                fontStretch\t\t: a.css('fontStretch')\t\t|| '',\n                fontVariant\t\t: a.css('fontVariant')\t\t|| '',\n                letterSpacing\t: a.css('letterSpacing')\t|| '',\n                wordSpacing\t\t: a.css('wordSpacing')\t\t|| ''\n            };\n            s.attr('class', a.attr('class')).append(a.contents().clone()).append(h2);\n            a.replaceWith(s);\n            h1.css(fn);\n            h2.css(fn).width(Math.min(h1.text(\"pW\" + h2[0].value).width(),w))[0].select();\n            $(document).one('mousedown.jstree touchstart.jstree dnd_start.vakata', function (e) {\n                if (h2 && e.target !== h2) {\n                    $(h2).trigger('blur');\n                }\n            });\n        },\n\n\n        /**\n         * changes the theme\n         * @name set_theme(theme_name [, theme_url])\n         * @param {String} theme_name the name of the new theme to apply\n         * @param {mixed} theme_url  the location of the CSS file for this theme. Omit or set to `false` if you manually included the file. Set to `true` to autoload from the `core.themes.dir` directory.\n         * @trigger set_theme.jstree\n         */\n        set_theme : function (theme_name, theme_url) {\n            if(!theme_name) { return false; }\n            if(theme_url === true) {\n                var dir = this.settings.core.themes.dir;\n                if(!dir) { dir = $.jstree.path + '/themes'; }\n                theme_url = dir + '/' + theme_name + '/style.css';\n            }\n            if(theme_url && $.inArray(theme_url, themes_loaded) === -1) {\n                $('head').append('<'+'link rel=\"stylesheet\" href=\"' + theme_url + '\" type=\"text/css\" />');\n                themes_loaded.push(theme_url);\n            }\n            if(this._data.core.themes.name) {\n                this.element.removeClass('jstree-' + this._data.core.themes.name);\n            }\n            this._data.core.themes.name = theme_name;\n            this.element.addClass('jstree-' + theme_name);\n            this.element[this.settings.core.themes.responsive ? 'addClass' : 'removeClass' ]('jstree-' + theme_name + '-responsive');\n            /**\n             * triggered when a theme is set\n             * @event\n             * @name set_theme.jstree\n             * @param {String} theme the new theme\n             */\n            this.trigger('set_theme', { 'theme' : theme_name });\n        },\n        /**\n         * gets the name of the currently applied theme name\n         * @name get_theme()\n         * @return {String}\n         */\n        get_theme : function () { return this._data.core.themes.name; },\n        /**\n         * changes the theme variant (if the theme has variants)\n         * @name set_theme_variant(variant_name)\n         * @param {String|Boolean} variant_name the variant to apply (if `false` is used the current variant is removed)\n         */\n        set_theme_variant : function (variant_name) {\n            if(this._data.core.themes.variant) {\n                this.element.removeClass('jstree-' + this._data.core.themes.name + '-' + this._data.core.themes.variant);\n            }\n            this._data.core.themes.variant = variant_name;\n            if(variant_name) {\n                this.element.addClass('jstree-' + this._data.core.themes.name + '-' + this._data.core.themes.variant);\n            }\n        },\n        /**\n         * gets the name of the currently applied theme variant\n         * @name get_theme()\n         * @return {String}\n         */\n        get_theme_variant : function () { return this._data.core.themes.variant; },\n        /**\n         * shows a striped background on the container (if the theme supports it)\n         * @name show_stripes()\n         */\n        show_stripes : function () {\n            this._data.core.themes.stripes = true;\n            this.get_container_ul().addClass(\"jstree-striped\");\n            /**\n             * triggered when stripes are shown\n             * @event\n             * @name show_stripes.jstree\n             */\n            this.trigger('show_stripes');\n        },\n        /**\n         * hides the striped background on the container\n         * @name hide_stripes()\n         */\n        hide_stripes : function () {\n            this._data.core.themes.stripes = false;\n            this.get_container_ul().removeClass(\"jstree-striped\");\n            /**\n             * triggered when stripes are hidden\n             * @event\n             * @name hide_stripes.jstree\n             */\n            this.trigger('hide_stripes');\n        },\n        /**\n         * toggles the striped background on the container\n         * @name toggle_stripes()\n         */\n        toggle_stripes : function () { if(this._data.core.themes.stripes) { this.hide_stripes(); } else { this.show_stripes(); } },\n        /**\n         * shows the connecting dots (if the theme supports it)\n         * @name show_dots()\n         */\n        show_dots : function () {\n            this._data.core.themes.dots = true;\n            this.get_container_ul().removeClass(\"jstree-no-dots\");\n            /**\n             * triggered when dots are shown\n             * @event\n             * @name show_dots.jstree\n             */\n            this.trigger('show_dots');\n        },\n        /**\n         * hides the connecting dots\n         * @name hide_dots()\n         */\n        hide_dots : function () {\n            this._data.core.themes.dots = false;\n            this.get_container_ul().addClass(\"jstree-no-dots\");\n            /**\n             * triggered when dots are hidden\n             * @event\n             * @name hide_dots.jstree\n             */\n            this.trigger('hide_dots');\n        },\n        /**\n         * toggles the connecting dots\n         * @name toggle_dots()\n         */\n        toggle_dots : function () { if(this._data.core.themes.dots) { this.hide_dots(); } else { this.show_dots(); } },\n        /**\n         * show the node icons\n         * @name show_icons()\n         */\n        show_icons : function () {\n            this._data.core.themes.icons = true;\n            this.get_container_ul().removeClass(\"jstree-no-icons\");\n            /**\n             * triggered when icons are shown\n             * @event\n             * @name show_icons.jstree\n             */\n            this.trigger('show_icons');\n        },\n        /**\n         * hide the node icons\n         * @name hide_icons()\n         */\n        hide_icons : function () {\n            this._data.core.themes.icons = false;\n            this.get_container_ul().addClass(\"jstree-no-icons\");\n            /**\n             * triggered when icons are hidden\n             * @event\n             * @name hide_icons.jstree\n             */\n            this.trigger('hide_icons');\n        },\n        /**\n         * toggle the node icons\n         * @name toggle_icons()\n         */\n        toggle_icons : function () { if(this._data.core.themes.icons) { this.hide_icons(); } else { this.show_icons(); } },\n        /**\n         * show the node ellipsis\n         * @name show_icons()\n         */\n        show_ellipsis : function () {\n            this._data.core.themes.ellipsis = true;\n            this.get_container_ul().addClass(\"jstree-ellipsis\");\n            /**\n             * triggered when ellisis is shown\n             * @event\n             * @name show_ellipsis.jstree\n             */\n            this.trigger('show_ellipsis');\n        },\n        /**\n         * hide the node ellipsis\n         * @name hide_ellipsis()\n         */\n        hide_ellipsis : function () {\n            this._data.core.themes.ellipsis = false;\n            this.get_container_ul().removeClass(\"jstree-ellipsis\");\n            /**\n             * triggered when ellisis is hidden\n             * @event\n             * @name hide_ellipsis.jstree\n             */\n            this.trigger('hide_ellipsis');\n        },\n        /**\n         * toggle the node ellipsis\n         * @name toggle_icons()\n         */\n        toggle_ellipsis : function () { if(this._data.core.themes.ellipsis) { this.hide_ellipsis(); } else { this.show_ellipsis(); } },\n        /**\n         * set the node icon for a node\n         * @name set_icon(obj, icon)\n         * @param {mixed} obj\n         * @param {String} icon the new icon - can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class\n         */\n        set_icon : function (obj, icon) {\n            var t1, t2, dom, old;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_icon(obj[t1], icon);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            old = obj.icon;\n            obj.icon = icon === true || icon === null || icon === undefined || icon === '' ? true : icon;\n            dom = this.get_node(obj, true).children(\".jstree-anchor\").children(\".jstree-themeicon\");\n            if(icon === false) {\n                dom.removeClass('jstree-themeicon-custom ' + old).css(\"background\",\"\").removeAttr(\"rel\");\n                this.hide_icon(obj);\n            }\n            else if(icon === true || icon === null || icon === undefined || icon === '') {\n                dom.removeClass('jstree-themeicon-custom ' + old).css(\"background\",\"\").removeAttr(\"rel\");\n                if(old === false) { this.show_icon(obj); }\n            }\n            else if(icon.indexOf(\"/\") === -1 && icon.indexOf(\".\") === -1) {\n                dom.removeClass(old).css(\"background\",\"\");\n                dom.addClass(icon + ' jstree-themeicon-custom').attr(\"rel\",icon);\n                if(old === false) { this.show_icon(obj); }\n            }\n            else {\n                dom.removeClass(old).css(\"background\",\"\");\n                dom.addClass('jstree-themeicon-custom').css(\"background\", \"url('\" + icon + \"') center center no-repeat\").attr(\"rel\",icon);\n                if(old === false) { this.show_icon(obj); }\n            }\n            return true;\n        },\n        /**\n         * get the node icon for a node\n         * @name get_icon(obj)\n         * @param {mixed} obj\n         * @return {String}\n         */\n        get_icon : function (obj) {\n            obj = this.get_node(obj);\n            return (!obj || obj.id === $.jstree.root) ? false : obj.icon;\n        },\n        /**\n         * hide the icon on an individual node\n         * @name hide_icon(obj)\n         * @param {mixed} obj\n         */\n        hide_icon : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.hide_icon(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj === $.jstree.root) { return false; }\n            obj.icon = false;\n            this.get_node(obj, true).children(\".jstree-anchor\").children(\".jstree-themeicon\").addClass('jstree-themeicon-hidden');\n            return true;\n        },\n        /**\n         * show the icon on an individual node\n         * @name show_icon(obj)\n         * @param {mixed} obj\n         */\n        show_icon : function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.show_icon(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj === $.jstree.root) { return false; }\n            dom = this.get_node(obj, true);\n            obj.icon = dom.length ? dom.children(\".jstree-anchor\").children(\".jstree-themeicon\").attr('rel') : true;\n            if(!obj.icon) { obj.icon = true; }\n            dom.children(\".jstree-anchor\").children(\".jstree-themeicon\").removeClass('jstree-themeicon-hidden');\n            return true;\n        }\n    };\n\n    // helpers\n    $.vakata = {};\n    // collect attributes\n    $.vakata.attributes = function(node, with_values) {\n        node = $(node)[0];\n        var attr = with_values ? {} : [];\n        if(node && node.attributes) {\n            $.each(node.attributes, function (i, v) {\n                if($.inArray(v.name.toLowerCase(),['style','contenteditable','hasfocus','tabindex']) !== -1) { return; }\n                if(v.value !== null && $.vakata.trim(v.value) !== '') {\n                    if(with_values) { attr[v.name] = v.value; }\n                    else { attr.push(v.name); }\n                }\n            });\n        }\n        return attr;\n    };\n    $.vakata.array_unique = function(array) {\n        var a = [], i, j, l, o = {};\n        for(i = 0, l = array.length; i < l; i++) {\n            if(o[array[i]] === undefined) {\n                a.push(array[i]);\n                o[array[i]] = true;\n            }\n        }\n        return a;\n    };\n    // remove item from array\n    $.vakata.array_remove = function(array, from) {\n        array.splice(from, 1);\n        return array;\n        //var rest = array.slice((to || from) + 1 || array.length);\n        //array.length = from < 0 ? array.length + from : from;\n        //array.push.apply(array, rest);\n        //return array;\n    };\n    // remove item from array\n    $.vakata.array_remove_item = function(array, item) {\n        var tmp = $.inArray(item, array);\n        return tmp !== -1 ? $.vakata.array_remove(array, tmp) : array;\n    };\n    $.vakata.array_filter = function(c,a,b,d,e) {\n        if (c.filter) {\n            return c.filter(a, b);\n        }\n        d=[];\n        for (e in c) {\n            if (~~e+''===e+'' && e>=0 && a.call(b,c[e],+e,c)) {\n                d.push(c[e]);\n            }\n        }\n        return d;\n    };\n    $.vakata.trim = function (text) {\n        return String.prototype.trim ?\n            String.prototype.trim.call(text.toString()) :\n            text.toString().replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n    };\n    $.vakata.is_function = function(obj) {\n        return typeof obj === \"function\" && typeof obj.nodeType !== \"number\";\n    };\n    $.vakata.is_array = Array.isArray || function (obj) {\n        return Object.prototype.toString.call(obj) === \"[object Array]\";\n    };\n\n    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_objects/Function/bind#polyfill\n    if (!Function.prototype.bind) {\n        Function.prototype.bind = function () {\n            var thatFunc = this, thatArg = arguments[0];\n            var args = Array.prototype.slice.call(arguments, 1);\n            if (typeof thatFunc !== 'function') {\n                // closest thing possible to the ECMAScript 5\n                // internal IsCallable function\n                throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');\n            }\n            return function(){\n                var funcArgs = args.concat(Array.prototype.slice.call(arguments));\n                return thatFunc.apply(thatArg, funcArgs);\n            };\n        };\n    }\n\n\n    /**\n     * ### Changed plugin\n     *\n     * This plugin adds more information to the `changed.jstree` event. The new data is contained in the `changed` event data property, and contains a lists of `selected` and `deselected` nodes.\n     */\n\n    $.jstree.plugins.changed = function (options, parent) {\n        var last = [];\n        this.trigger = function (ev, data) {\n            var i, j;\n            if(!data) {\n                data = {};\n            }\n            if(ev.replace('.jstree','') === 'changed') {\n                data.changed = { selected : [], deselected : [] };\n                var tmp = {};\n                for(i = 0, j = last.length; i < j; i++) {\n                    tmp[last[i]] = 1;\n                }\n                for(i = 0, j = data.selected.length; i < j; i++) {\n                    if(!tmp[data.selected[i]]) {\n                        data.changed.selected.push(data.selected[i]);\n                    }\n                    else {\n                        tmp[data.selected[i]] = 2;\n                    }\n                }\n                for(i = 0, j = last.length; i < j; i++) {\n                    if(tmp[last[i]] === 1) {\n                        data.changed.deselected.push(last[i]);\n                    }\n                }\n                last = data.selected.slice();\n            }\n            /**\n             * triggered when selection changes (the \"changed\" plugin enhances the original event with more data)\n             * @event\n             * @name changed.jstree\n             * @param {Object} node\n             * @param {Object} action the action that caused the selection to change\n             * @param {Array} selected the current selection\n             * @param {Object} changed an object containing two properties `selected` and `deselected` - both arrays of node IDs, which were selected or deselected since the last changed event\n             * @param {Object} event the event (if any) that triggered this changed event\n             * @plugin changed\n             */\n            parent.trigger.call(this, ev, data);\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            last = [];\n            return parent.refresh.apply(this, arguments);\n        };\n    };\n\n    /**\n     * ### Checkbox plugin\n     *\n     * This plugin renders checkbox icons in front of each node, making multiple selection much easier.\n     * It also supports tri-state behavior, meaning that if a node has a few of its children checked it will be rendered as undetermined, and state will be propagated up.\n     */\n\n    var _i = document.createElement('I');\n    _i.className = 'jstree-icon jstree-checkbox';\n    _i.setAttribute('role', 'presentation');\n    /**\n     * stores all defaults for the checkbox plugin\n     * @name $.jstree.defaults.checkbox\n     * @plugin checkbox\n     */\n    $.jstree.defaults.checkbox = {\n        /**\n         * a boolean indicating if checkboxes should be visible (can be changed at a later time using `show_checkboxes()` and `hide_checkboxes`). Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.visible\n         * @plugin checkbox\n         */\n        visible\t\t\t\t: true,\n        /**\n         * a boolean indicating if checkboxes should cascade down and have an undetermined state. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.three_state\n         * @plugin checkbox\n         */\n        three_state\t\t\t: true,\n        /**\n         * a boolean indicating if clicking anywhere on the node should act as clicking on the checkbox. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.whole_node\n         * @plugin checkbox\n         */\n        whole_node\t\t\t: true,\n        /**\n         * a boolean indicating if the selected style of a node should be kept, or removed. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.keep_selected_style\n         * @plugin checkbox\n         */\n        keep_selected_style\t: true,\n        /**\n         * This setting controls how cascading and undetermined nodes are applied.\n         * If 'up' is in the string - cascading up is enabled, if 'down' is in the string - cascading down is enabled, if 'undetermined' is in the string - undetermined nodes will be used.\n         * If `three_state` is set to `true` this setting is automatically set to 'up+down+undetermined'. Defaults to ''.\n         * @name $.jstree.defaults.checkbox.cascade\n         * @plugin checkbox\n         */\n        cascade\t\t\t\t: '',\n        /**\n         * This setting controls if checkbox are bound to the general tree selection or to an internal array maintained by the checkbox plugin. Defaults to `true`, only set to `false` if you know exactly what you are doing.\n         * @name $.jstree.defaults.checkbox.tie_selection\n         * @plugin checkbox\n         */\n        tie_selection\t\t: true,\n\n        /**\n         * This setting controls if cascading down affects disabled checkboxes\n         * @name $.jstree.defaults.checkbox.cascade_to_disabled\n         * @plugin checkbox\n         */\n        cascade_to_disabled : true,\n\n        /**\n         * This setting controls if cascading down affects hidden checkboxes\n         * @name $.jstree.defaults.checkbox.cascade_to_hidden\n         * @plugin checkbox\n         */\n        cascade_to_hidden : true\n    };\n    $.jstree.plugins.checkbox = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            this._data.checkbox.uto = false;\n            this._data.checkbox.selected = [];\n            if(this.settings.checkbox.three_state) {\n                this.settings.checkbox.cascade = 'up+down+undetermined';\n            }\n            this.element\n                .on(\"init.jstree\", function () {\n                    this._data.checkbox.visible = this.settings.checkbox.visible;\n                    if(!this.settings.checkbox.keep_selected_style) {\n                        this.element.addClass('jstree-checkbox-no-clicked');\n                    }\n                    if(this.settings.checkbox.tie_selection) {\n                        this.element.addClass('jstree-checkbox-selection');\n                    }\n                }.bind(this))\n                .on(\"loading.jstree\", function () {\n                    this[ this._data.checkbox.visible ? 'show_checkboxes' : 'hide_checkboxes' ]();\n                }.bind(this));\n            if(this.settings.checkbox.cascade.indexOf('undetermined') !== -1) {\n                this.element\n                    .on('changed.jstree uncheck_node.jstree check_node.jstree uncheck_all.jstree check_all.jstree move_node.jstree copy_node.jstree redraw.jstree open_node.jstree', function () {\n                        // only if undetermined is in setting\n                        if(this._data.checkbox.uto) { clearTimeout(this._data.checkbox.uto); }\n                        this._data.checkbox.uto = setTimeout(this._undetermined.bind(this), 50);\n                    }.bind(this));\n            }\n            if(!this.settings.checkbox.tie_selection) {\n                this.element\n                    .on('model.jstree', function (e, data) {\n                        var m = this._model.data,\n                            p = m[data.parent],\n                            dpc = data.nodes,\n                            i, j;\n                        for(i = 0, j = dpc.length; i < j; i++) {\n                            m[dpc[i]].state.checked = m[dpc[i]].state.checked || (m[dpc[i]].original && m[dpc[i]].original.state && m[dpc[i]].original.state.checked);\n                            if(m[dpc[i]].state.checked) {\n                                this._data.checkbox.selected.push(dpc[i]);\n                            }\n                        }\n                    }.bind(this));\n            }\n            if(this.settings.checkbox.cascade.indexOf('up') !== -1 || this.settings.checkbox.cascade.indexOf('down') !== -1) {\n                this.element\n                    .on('model.jstree', function (e, data) {\n                        var m = this._model.data,\n                            p = m[data.parent],\n                            dpc = data.nodes,\n                            chd = [],\n                            c, i, j, k, l, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection;\n\n                        if(s.indexOf('down') !== -1) {\n                            // apply down\n                            if(p.state[ t ? 'selected' : 'checked' ]) {\n                                for(i = 0, j = dpc.length; i < j; i++) {\n                                    m[dpc[i]].state[ t ? 'selected' : 'checked' ] = true;\n                                }\n\n                                this._data[ t ? 'core' : 'checkbox' ].selected = this._data[ t ? 'core' : 'checkbox' ].selected.concat(dpc);\n                            }\n                            else {\n                                for(i = 0, j = dpc.length; i < j; i++) {\n                                    if(m[dpc[i]].state[ t ? 'selected' : 'checked' ]) {\n                                        for(k = 0, l = m[dpc[i]].children_d.length; k < l; k++) {\n                                            m[m[dpc[i]].children_d[k]].state[ t ? 'selected' : 'checked' ] = true;\n                                        }\n                                        this._data[ t ? 'core' : 'checkbox' ].selected = this._data[ t ? 'core' : 'checkbox' ].selected.concat(m[dpc[i]].children_d);\n                                    }\n                                }\n                            }\n                        }\n\n                        if(s.indexOf('up') !== -1) {\n                            // apply up\n                            for(i = 0, j = p.children_d.length; i < j; i++) {\n                                if(!m[p.children_d[i]].children.length) {\n                                    chd.push(m[p.children_d[i]].parent);\n                                }\n                            }\n                            chd = $.vakata.array_unique(chd);\n                            for(k = 0, l = chd.length; k < l; k++) {\n                                p = m[chd[k]];\n                                while(p && p.id !== $.jstree.root) {\n                                    c = 0;\n                                    for(i = 0, j = p.children.length; i < j; i++) {\n                                        c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                                    }\n                                    if(c === j) {\n                                        p.state[ t ? 'selected' : 'checked' ] = true;\n                                        this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                        tmp = this.get_node(p, true);\n                                        if(tmp && tmp.length) {\n                                            tmp.children('.jstree-anchor').attr('aria-selected', true).addClass( t ? 'jstree-clicked' : 'jstree-checked');\n                                        }\n                                    }\n                                    else {\n                                        break;\n                                    }\n                                    p = this.get_node(p.parent);\n                                }\n                            }\n                        }\n\n                        this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_unique(this._data[ t ? 'core' : 'checkbox' ].selected);\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'select_node.jstree' : 'check_node.jstree', function (e, data) {\n                        var self = this,\n                            obj = data.node,\n                            m = this._model.data,\n                            par = this.get_node(obj.parent),\n                            i, j, c, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection,\n                            sel = {}, cur = this._data[ t ? 'core' : 'checkbox' ].selected;\n\n                        for (i = 0, j = cur.length; i < j; i++) {\n                            sel[cur[i]] = true;\n                        }\n\n                        // apply down\n                        if(s.indexOf('down') !== -1) {\n                            //this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_unique(this._data[ t ? 'core' : 'checkbox' ].selected.concat(obj.children_d));\n                            var selectedIds = this._cascade_new_checked_state(obj.id, true);\n                            var temp = obj.children_d.concat(obj.id);\n                            for (i = 0, j = temp.length; i < j; i++) {\n                                if (selectedIds.indexOf(temp[i]) > -1) {\n                                    sel[temp[i]] = true;\n                                }\n                                else {\n                                    delete sel[temp[i]];\n                                }\n                            }\n                        }\n\n                        // apply up\n                        if(s.indexOf('up') !== -1) {\n                            while(par && par.id !== $.jstree.root) {\n                                c = 0;\n                                for(i = 0, j = par.children.length; i < j; i++) {\n                                    c += m[par.children[i]].state[ t ? 'selected' : 'checked' ];\n                                }\n                                if(c === j) {\n                                    par.state[ t ? 'selected' : 'checked' ] = true;\n                                    sel[par.id] = true;\n                                    //this._data[ t ? 'core' : 'checkbox' ].selected.push(par.id);\n                                    tmp = this.get_node(par, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.children('.jstree-anchor').attr('aria-selected', true).addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                                par = this.get_node(par.parent);\n                            }\n                        }\n\n                        cur = [];\n                        for (i in sel) {\n                            if (sel.hasOwnProperty(i)) {\n                                cur.push(i);\n                            }\n                        }\n                        this._data[ t ? 'core' : 'checkbox' ].selected = cur;\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'deselect_all.jstree' : 'uncheck_all.jstree', function (e, data) {\n                        var obj = this.get_node($.jstree.root),\n                            m = this._model.data,\n                            i, j, tmp;\n                        for(i = 0, j = obj.children_d.length; i < j; i++) {\n                            tmp = m[obj.children_d[i]];\n                            if(tmp && tmp.original && tmp.original.state && tmp.original.state.undetermined) {\n                                tmp.original.state.undetermined = false;\n                            }\n                        }\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'deselect_node.jstree' : 'uncheck_node.jstree', function (e, data) {\n                        var self = this,\n                            obj = data.node,\n                            dom = this.get_node(obj, true),\n                            i, j, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection,\n                            cur = this._data[ t ? 'core' : 'checkbox' ].selected, sel = {},\n                            stillSelectedIds = [],\n                            allIds = obj.children_d.concat(obj.id);\n\n                        // apply down\n                        if(s.indexOf('down') !== -1) {\n                            var selectedIds = this._cascade_new_checked_state(obj.id, false);\n\n                            cur = $.vakata.array_filter(cur, function(id) {\n                                return allIds.indexOf(id) === -1 || selectedIds.indexOf(id) > -1;\n                            });\n                        }\n\n                        // only apply up if cascade up is enabled and if this node is not selected\n                        // (if all child nodes are disabled and cascade_to_disabled === false then this node will till be selected).\n                        if(s.indexOf('up') !== -1 && cur.indexOf(obj.id) === -1) {\n                            for(i = 0, j = obj.parents.length; i < j; i++) {\n                                tmp = this._model.data[obj.parents[i]];\n                                tmp.state[ t ? 'selected' : 'checked' ] = false;\n                                if(tmp && tmp.original && tmp.original.state && tmp.original.state.undetermined) {\n                                    tmp.original.state.undetermined = false;\n                                }\n                                tmp = this.get_node(obj.parents[i], true);\n                                if(tmp && tmp.length) {\n                                    tmp.children('.jstree-anchor').attr('aria-selected', false).removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                }\n                            }\n\n                            cur = $.vakata.array_filter(cur, function(id) {\n                                return obj.parents.indexOf(id) === -1;\n                            });\n                        }\n\n                        this._data[ t ? 'core' : 'checkbox' ].selected = cur;\n                    }.bind(this));\n            }\n            if(this.settings.checkbox.cascade.indexOf('up') !== -1) {\n                this.element\n                    .on('delete_node.jstree', function (e, data) {\n                        // apply up (whole handler)\n                        var p = this.get_node(data.parent),\n                            m = this._model.data,\n                            i, j, c, tmp, t = this.settings.checkbox.tie_selection;\n                        while(p && p.id !== $.jstree.root && !p.state[ t ? 'selected' : 'checked' ]) {\n                            c = 0;\n                            for(i = 0, j = p.children.length; i < j; i++) {\n                                c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                            }\n                            if(j > 0 && c === j) {\n                                p.state[ t ? 'selected' : 'checked' ] = true;\n                                this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                tmp = this.get_node(p, true);\n                                if(tmp && tmp.length) {\n                                    tmp.children('.jstree-anchor').attr('aria-selected', true).addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                }\n                            }\n                            else {\n                                break;\n                            }\n                            p = this.get_node(p.parent);\n                        }\n                    }.bind(this))\n                    .on('move_node.jstree', function (e, data) {\n                        // apply up (whole handler)\n                        var is_multi = data.is_multi,\n                            old_par = data.old_parent,\n                            new_par = this.get_node(data.parent),\n                            m = this._model.data,\n                            p, c, i, j, tmp, t = this.settings.checkbox.tie_selection;\n                        if(!is_multi) {\n                            p = this.get_node(old_par);\n                            while(p && p.id !== $.jstree.root && !p.state[ t ? 'selected' : 'checked' ]) {\n                                c = 0;\n                                for(i = 0, j = p.children.length; i < j; i++) {\n                                    c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                                }\n                                if(j > 0 && c === j) {\n                                    p.state[ t ? 'selected' : 'checked' ] = true;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.children('.jstree-anchor').attr('aria-selected', true).addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                                p = this.get_node(p.parent);\n                            }\n                        }\n                        p = new_par;\n                        while(p && p.id !== $.jstree.root) {\n                            c = 0;\n                            for(i = 0, j = p.children.length; i < j; i++) {\n                                c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                            }\n                            if(c === j) {\n                                if(!p.state[ t ? 'selected' : 'checked' ]) {\n                                    p.state[ t ? 'selected' : 'checked' ] = true;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.children('.jstree-anchor').attr('aria-selected', true).addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                            }\n                            else {\n                                if(p.state[ t ? 'selected' : 'checked' ]) {\n                                    p.state[ t ? 'selected' : 'checked' ] = false;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_remove_item(this._data[ t ? 'core' : 'checkbox' ].selected, p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.children('.jstree-anchor').attr('aria-selected', false).removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                            }\n                            p = this.get_node(p.parent);\n                        }\n                    }.bind(this));\n            }\n        };\n        /**\n         * get an array of all nodes whose state is \"undetermined\"\n         * @name get_undetermined([full])\n         * @param  {boolean} full: if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_undetermined = function (full) {\n            if (this.settings.checkbox.cascade.indexOf('undetermined') === -1) {\n                return [];\n            }\n            var i, j, k, l, o = {}, m = this._model.data, t = this.settings.checkbox.tie_selection, s = this._data[ t ? 'core' : 'checkbox' ].selected, p = [], tt = this, r = [];\n            for(i = 0, j = s.length; i < j; i++) {\n                if(m[s[i]] && m[s[i]].parents) {\n                    for(k = 0, l = m[s[i]].parents.length; k < l; k++) {\n                        if(o[m[s[i]].parents[k]] !== undefined) {\n                            break;\n                        }\n                        if(m[s[i]].parents[k] !== $.jstree.root) {\n                            o[m[s[i]].parents[k]] = true;\n                            p.push(m[s[i]].parents[k]);\n                        }\n                    }\n                }\n            }\n            // attempt for server side undetermined state\n            this.element.find('.jstree-closed').not(':has(.jstree-children)')\n                .each(function () {\n                    var tmp = tt.get_node(this), tmp2;\n\n                    if(!tmp) { return; }\n\n                    if(!tmp.state.loaded) {\n                        if(tmp.original && tmp.original.state && tmp.original.state.undetermined && tmp.original.state.undetermined === true) {\n                            if(o[tmp.id] === undefined && tmp.id !== $.jstree.root) {\n                                o[tmp.id] = true;\n                                p.push(tmp.id);\n                            }\n                            for(k = 0, l = tmp.parents.length; k < l; k++) {\n                                if(o[tmp.parents[k]] === undefined && tmp.parents[k] !== $.jstree.root) {\n                                    o[tmp.parents[k]] = true;\n                                    p.push(tmp.parents[k]);\n                                }\n                            }\n                        }\n                    }\n                    else {\n                        for(i = 0, j = tmp.children_d.length; i < j; i++) {\n                            tmp2 = m[tmp.children_d[i]];\n                            if(!tmp2.state.loaded && tmp2.original && tmp2.original.state && tmp2.original.state.undetermined && tmp2.original.state.undetermined === true) {\n                                if(o[tmp2.id] === undefined && tmp2.id !== $.jstree.root) {\n                                    o[tmp2.id] = true;\n                                    p.push(tmp2.id);\n                                }\n                                for(k = 0, l = tmp2.parents.length; k < l; k++) {\n                                    if(o[tmp2.parents[k]] === undefined && tmp2.parents[k] !== $.jstree.root) {\n                                        o[tmp2.parents[k]] = true;\n                                        p.push(tmp2.parents[k]);\n                                    }\n                                }\n                            }\n                        }\n                    }\n                });\n            for (i = 0, j = p.length; i < j; i++) {\n                if(!m[p[i]].state[ t ? 'selected' : 'checked' ]) {\n                    r.push(full ? m[p[i]] : p[i]);\n                }\n            }\n            return r;\n        };\n        /**\n         * set the undetermined state where and if necessary. Used internally.\n         * @private\n         * @name _undetermined()\n         * @plugin checkbox\n         */\n        this._undetermined = function () {\n            if(this.element === null) { return; }\n            var p = this.get_undetermined(false), i, j, s;\n\n            this.element.find('.jstree-undetermined').removeClass('jstree-undetermined');\n            for (i = 0, j = p.length; i < j; i++) {\n                s = this.get_node(p[i], true);\n                if(s && s.length) {\n                    s.children('.jstree-anchor').children('.jstree-checkbox').addClass('jstree-undetermined');\n                }\n            }\n        };\n        this.redraw_node = function(obj, deep, is_callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                var i, j, tmp = null, icon = null;\n                for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                    if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                        tmp = obj.childNodes[i];\n                        break;\n                    }\n                }\n                if(tmp) {\n                    if(!this.settings.checkbox.tie_selection && this._model.data[obj.id].state.checked) { tmp.className += ' jstree-checked'; }\n                    icon = _i.cloneNode(false);\n                    if(this._model.data[obj.id].state.checkbox_disabled) { icon.className += ' jstree-checkbox-disabled'; }\n                    tmp.insertBefore(icon, tmp.childNodes[0]);\n                }\n            }\n            if(!is_callback && this.settings.checkbox.cascade.indexOf('undetermined') !== -1) {\n                if(this._data.checkbox.uto) { clearTimeout(this._data.checkbox.uto); }\n                this._data.checkbox.uto = setTimeout(this._undetermined.bind(this), 50);\n            }\n            return obj;\n        };\n        /**\n         * show the node checkbox icons\n         * @name show_checkboxes()\n         * @plugin checkbox\n         */\n        this.show_checkboxes = function () { this._data.core.themes.checkboxes = true; this.get_container_ul().removeClass(\"jstree-no-checkboxes\"); };\n        /**\n         * hide the node checkbox icons\n         * @name hide_checkboxes()\n         * @plugin checkbox\n         */\n        this.hide_checkboxes = function () { this._data.core.themes.checkboxes = false; this.get_container_ul().addClass(\"jstree-no-checkboxes\"); };\n        /**\n         * toggle the node icons\n         * @name toggle_checkboxes()\n         * @plugin checkbox\n         */\n        this.toggle_checkboxes = function () { if(this._data.core.themes.checkboxes) { this.hide_checkboxes(); } else { this.show_checkboxes(); } };\n        /**\n         * checks if a node is in an undetermined state\n         * @name is_undetermined(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        this.is_undetermined = function (obj) {\n            obj = this.get_node(obj);\n            var s = this.settings.checkbox.cascade, i, j, t = this.settings.checkbox.tie_selection, d = this._data[ t ? 'core' : 'checkbox' ].selected, m = this._model.data;\n            if(!obj || obj.state[ t ? 'selected' : 'checked' ] === true || s.indexOf('undetermined') === -1 || (s.indexOf('down') === -1 && s.indexOf('up') === -1)) {\n                return false;\n            }\n            if(!obj.state.loaded && obj.original.state.undetermined === true) {\n                return true;\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                if($.inArray(obj.children_d[i], d) !== -1 || (!m[obj.children_d[i]].state.loaded && m[obj.children_d[i]].original.state.undetermined)) {\n                    return true;\n                }\n            }\n            return false;\n        };\n        /**\n         * disable a node's checkbox\n         * @name disable_checkbox(obj)\n         * @param {mixed} obj an array can be used too\n         * @trigger disable_checkbox.jstree\n         * @plugin checkbox\n         */\n        this.disable_checkbox = function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.disable_checkbox(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.checkbox_disabled) {\n                obj.state.checkbox_disabled = true;\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').children('.jstree-checkbox').addClass('jstree-checkbox-disabled');\n                }\n                /**\n                 * triggered when an node's checkbox is disabled\n                 * @event\n                 * @name disable_checkbox.jstree\n                 * @param {Object} node\n                 * @plugin checkbox\n                 */\n                this.trigger('disable_checkbox', { 'node' : obj });\n            }\n        };\n        /**\n         * enable a node's checkbox\n         * @name enable_checkbox(obj)\n         * @param {mixed} obj an array can be used too\n         * @trigger enable_checkbox.jstree\n         * @plugin checkbox\n         */\n        this.enable_checkbox = function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.enable_checkbox(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.checkbox_disabled) {\n                obj.state.checkbox_disabled = false;\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').children('.jstree-checkbox').removeClass('jstree-checkbox-disabled');\n                }\n                /**\n                 * triggered when an node's checkbox is enabled\n                 * @event\n                 * @name enable_checkbox.jstree\n                 * @param {Object} node\n                 * @plugin checkbox\n                 */\n                this.trigger('enable_checkbox', { 'node' : obj });\n            }\n        };\n\n        this.activate_node = function (obj, e) {\n            if($(e.target).hasClass('jstree-checkbox-disabled')) {\n                return false;\n            }\n            if(this.settings.checkbox.tie_selection && (this.settings.checkbox.whole_node || $(e.target).hasClass('jstree-checkbox'))) {\n                e.ctrlKey = true;\n            }\n            if(this.settings.checkbox.tie_selection || (!this.settings.checkbox.whole_node && !$(e.target).hasClass('jstree-checkbox'))) {\n                return parent.activate_node.call(this, obj, e);\n            }\n            if(this.is_disabled(obj)) {\n                return false;\n            }\n            if(this.is_checked(obj)) {\n                this.uncheck_node(obj, e);\n            }\n            else {\n                this.check_node(obj, e);\n            }\n            this.trigger('activate_node', { 'node' : this.get_node(obj) });\n        };\n        this.delete_node = function (obj) {\n            if(this.settings.checkbox.tie_selection || $.vakata.is_array(obj)) {\n                return parent.delete_node.call(this, obj);\n            }\n            var tmp, k, l, c = false;\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            tmp = obj.children_d.concat([]);\n            tmp.push(obj.id);\n            for(k = 0, l = tmp.length; k < l; k++) {\n                if(this._model.data[tmp[k]].state.checked) {\n                    c = true;\n                    break;\n                }\n            }\n            if (c) {\n                this._data.checkbox.selected = $.vakata.array_filter(this._data.checkbox.selected, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            return parent.delete_node.call(this, obj);\n        };\n\n        /**\n         * Cascades checked state to a node and all its descendants. This function does NOT affect hidden and disabled nodes (or their descendants).\n         * However if these unaffected nodes are already selected their ids will be included in the returned array.\n         * @private\n         * @name _cascade_new_checked_state(id, checkedState)\n         * @param {string} id the node ID\n         * @param {bool} checkedState should the nodes be checked or not\n         * @returns {Array} Array of all node id's (in this tree branch) that are checked.\n         */\n        this._cascade_new_checked_state = function (id, checkedState) {\n            var self = this;\n            var t = this.settings.checkbox.tie_selection;\n            var node = this._model.data[id];\n            var selectedNodeIds = [];\n            var selectedChildrenIds = [], i, j, selectedChildIds;\n\n            if (\n                (this.settings.checkbox.cascade_to_disabled || !node.state.disabled) &&\n                (this.settings.checkbox.cascade_to_hidden || !node.state.hidden)\n            ) {\n                //First try and check/uncheck the children\n                if (node.children) {\n                    for (i = 0, j = node.children.length; i < j; i++) {\n                        var childId = node.children[i];\n                        selectedChildIds = self._cascade_new_checked_state(childId, checkedState);\n                        selectedNodeIds = selectedNodeIds.concat(selectedChildIds);\n                        if (selectedChildIds.indexOf(childId) > -1) {\n                            selectedChildrenIds.push(childId);\n                        }\n                    }\n                }\n\n                var dom = self.get_node(node, true);\n\n                //A node's state is undetermined if some but not all of it's children are checked/selected .\n                var undetermined = selectedChildrenIds.length > 0 && selectedChildrenIds.length < node.children.length;\n\n                if(node.original && node.original.state && node.original.state.undetermined) {\n                    node.original.state.undetermined = undetermined;\n                }\n\n                //If a node is undetermined then remove selected class\n                if (undetermined) {\n                    node.state[ t ? 'selected' : 'checked' ] = false;\n                    dom.children('.jstree-anchor').attr('aria-selected', false).removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n                    //Otherwise, if the checkedState === true (i.e. the node is being checked now) and all of the node's children are checked (if it has any children),\n                //check the node and style it correctly.\n                else if (checkedState && selectedChildrenIds.length === node.children.length) {\n                    node.state[ t ? 'selected' : 'checked' ] = checkedState;\n                    selectedNodeIds.push(node.id);\n\n                    dom.children('.jstree-anchor').attr('aria-selected', true).addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n                else {\n                    node.state[ t ? 'selected' : 'checked' ] = false;\n                    dom.children('.jstree-anchor').attr('aria-selected', false).removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n            }\n            else {\n                selectedChildIds = this.get_checked_descendants(id);\n\n                if (node.state[ t ? 'selected' : 'checked' ]) {\n                    selectedChildIds.push(node.id);\n                }\n\n                selectedNodeIds = selectedNodeIds.concat(selectedChildIds);\n            }\n\n            return selectedNodeIds;\n        };\n\n        /**\n         * Gets ids of nodes selected in branch (of tree) specified by id (does not include the node specified by id)\n         * @name get_checked_descendants(obj)\n         * @param {string} id the node ID\n         * @return {Array} array of IDs\n         * @plugin checkbox\n         */\n        this.get_checked_descendants = function (id) {\n            var self = this;\n            var t = self.settings.checkbox.tie_selection;\n            var node = self._model.data[id];\n\n            return $.vakata.array_filter(node.children_d, function(_id) {\n                return self._model.data[_id].state[ t ? 'selected' : 'checked' ];\n            });\n        };\n\n        /**\n         * check a node (only if tie_selection in checkbox settings is false, otherwise select_node will be called internally)\n         * @name check_node(obj)\n         * @param {mixed} obj an array can be used to check multiple nodes\n         * @trigger check_node.jstree\n         * @plugin checkbox\n         */\n        this.check_node = function (obj, e) {\n            if(this.settings.checkbox.tie_selection) { return this.select_node(obj, false, true, e); }\n            var dom, t1, t2, th;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.check_node(obj[t1], e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.checked) {\n                obj.state.checked = true;\n                this._data.checkbox.selected.push(obj.id);\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').addClass('jstree-checked');\n                }\n                /**\n                 * triggered when an node is checked (only if tie_selection in checkbox settings is false)\n                 * @event\n                 * @name check_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this check_node\n                 * @plugin checkbox\n                 */\n                this.trigger('check_node', { 'node' : obj, 'selected' : this._data.checkbox.selected, 'event' : e });\n            }\n        };\n        /**\n         * uncheck a node (only if tie_selection in checkbox settings is false, otherwise deselect_node will be called internally)\n         * @name uncheck_node(obj)\n         * @param {mixed} obj an array can be used to uncheck multiple nodes\n         * @trigger uncheck_node.jstree\n         * @plugin checkbox\n         */\n        this.uncheck_node = function (obj, e) {\n            if(this.settings.checkbox.tie_selection) { return this.deselect_node(obj, false, e); }\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.uncheck_node(obj[t1], e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.checked) {\n                obj.state.checked = false;\n                this._data.checkbox.selected = $.vakata.array_remove_item(this._data.checkbox.selected, obj.id);\n                if(dom.length) {\n                    dom.children('.jstree-anchor').removeClass('jstree-checked');\n                }\n                /**\n                 * triggered when an node is unchecked (only if tie_selection in checkbox settings is false)\n                 * @event\n                 * @name uncheck_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this uncheck_node\n                 * @plugin checkbox\n                 */\n                this.trigger('uncheck_node', { 'node' : obj, 'selected' : this._data.checkbox.selected, 'event' : e });\n            }\n        };\n\n        /**\n         * checks all nodes in the tree (only if tie_selection in checkbox settings is false, otherwise select_all will be called internally)\n         * @name check_all()\n         * @trigger check_all.jstree, changed.jstree\n         * @plugin checkbox\n         */\n        this.check_all = function () {\n            if(this.settings.checkbox.tie_selection) { return this.select_all(); }\n            var tmp = this._data.checkbox.selected.concat([]), i, j;\n            this._data.checkbox.selected = this._model.data[$.jstree.root].children_d.concat();\n            for(i = 0, j = this._data.checkbox.selected.length; i < j; i++) {\n                if(this._model.data[this._data.checkbox.selected[i]]) {\n                    this._model.data[this._data.checkbox.selected[i]].state.checked = true;\n                }\n            }\n            this.redraw(true);\n            /**\n             * triggered when all nodes are checked (only if tie_selection in checkbox settings is false)\n             * @event\n             * @name check_all.jstree\n             * @param {Array} selected the current selection\n             * @plugin checkbox\n             */\n            this.trigger('check_all', { 'selected' : this._data.checkbox.selected });\n        };\n        /**\n         * uncheck all checked nodes (only if tie_selection in checkbox settings is false, otherwise deselect_all will be called internally)\n         * @name uncheck_all()\n         * @trigger uncheck_all.jstree\n         * @plugin checkbox\n         */\n        this.uncheck_all = function () {\n            if(this.settings.checkbox.tie_selection) { return this.deselect_all(); }\n            var tmp = this._data.checkbox.selected.concat([]), i, j;\n            for(i = 0, j = this._data.checkbox.selected.length; i < j; i++) {\n                if(this._model.data[this._data.checkbox.selected[i]]) {\n                    this._model.data[this._data.checkbox.selected[i]].state.checked = false;\n                }\n            }\n            this._data.checkbox.selected = [];\n            this.element.find('.jstree-checked').removeClass('jstree-checked');\n            /**\n             * triggered when all nodes are unchecked (only if tie_selection in checkbox settings is false)\n             * @event\n             * @name uncheck_all.jstree\n             * @param {Object} node the previous selection\n             * @param {Array} selected the current selection\n             * @plugin checkbox\n             */\n            this.trigger('uncheck_all', { 'selected' : this._data.checkbox.selected, 'node' : tmp });\n        };\n        /**\n         * checks if a node is checked (if tie_selection is on in the settings this function will return the same as is_selected)\n         * @name is_checked(obj)\n         * @param  {mixed}  obj\n         * @return {Boolean}\n         * @plugin checkbox\n         */\n        this.is_checked = function (obj) {\n            if(this.settings.checkbox.tie_selection) { return this.is_selected(obj); }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            return obj.state.checked;\n        };\n        /**\n         * get an array of all checked nodes (if tie_selection is on in the settings this function will return the same as get_selected)\n         * @name get_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_selected(full); }\n            return full ? $.map(this._data.checkbox.selected, function (i) { return this.get_node(i); }.bind(this)) : this._data.checkbox.selected.slice();\n        };\n        /**\n         * get an array of all top level checked nodes (ignoring children of checked nodes) (if tie_selection is on in the settings this function will return the same as get_top_selected)\n         * @name get_top_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_top_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_top_selected(full); }\n            var tmp = this.get_checked(true),\n                obj = {}, i, j, k, l;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                obj[tmp[i].id] = tmp[i];\n            }\n            for(i = 0, j = tmp.length; i < j; i++) {\n                for(k = 0, l = tmp[i].children_d.length; k < l; k++) {\n                    if(obj[tmp[i].children_d[k]]) {\n                        delete obj[tmp[i].children_d[k]];\n                    }\n                }\n            }\n            tmp = [];\n            for(i in obj) {\n                if(obj.hasOwnProperty(i)) {\n                    tmp.push(i);\n                }\n            }\n            return full ? $.map(tmp, function (i) { return this.get_node(i); }.bind(this)) : tmp;\n        };\n        /**\n         * get an array of all bottom level checked nodes (ignoring selected parents) (if tie_selection is on in the settings this function will return the same as get_bottom_selected)\n         * @name get_bottom_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_bottom_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_bottom_selected(full); }\n            var tmp = this.get_checked(true),\n                obj = [], i, j;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                if(!tmp[i].children.length) {\n                    obj.push(tmp[i].id);\n                }\n            }\n            return full ? $.map(obj, function (i) { return this.get_node(i); }.bind(this)) : obj;\n        };\n        this.load_node = function (obj, callback) {\n            var k, l, i, j, c, tmp;\n            if(!$.vakata.is_array(obj) && !this.settings.checkbox.tie_selection) {\n                tmp = this.get_node(obj);\n                if(tmp && tmp.state.loaded) {\n                    for(k = 0, l = tmp.children_d.length; k < l; k++) {\n                        if(this._model.data[tmp.children_d[k]].state.checked) {\n                            c = true;\n                            this._data.checkbox.selected = $.vakata.array_remove_item(this._data.checkbox.selected, tmp.children_d[k]);\n                        }\n                    }\n                }\n            }\n            return parent.load_node.apply(this, arguments);\n        };\n        this.get_state = function () {\n            var state = parent.get_state.apply(this, arguments);\n            if(this.settings.checkbox.tie_selection) { return state; }\n            state.checkbox = this._data.checkbox.selected.slice();\n            return state;\n        };\n        this.set_state = function (state, callback) {\n            var res = parent.set_state.apply(this, arguments);\n            if(res && state.checkbox) {\n                if(!this.settings.checkbox.tie_selection) {\n                    this.uncheck_all();\n                    var _this = this;\n                    $.each(state.checkbox, function (i, v) {\n                        _this.check_node(v);\n                    });\n                }\n                delete state.checkbox;\n                this.set_state(state, callback);\n                return false;\n            }\n            return res;\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            if(this.settings.checkbox.tie_selection) {\n                this._data.checkbox.selected = [];\n            }\n            return parent.refresh.apply(this, arguments);\n        };\n    };\n\n    // include the checkbox plugin by default\n    // $.jstree.defaults.plugins.push(\"checkbox\");\n\n\n    /**\n     * ### Conditionalselect plugin\n     *\n     * This plugin allows defining a callback to allow or deny node selection by user input (activate node method).\n     */\n\n    /**\n     * a callback (function) which is invoked in the instance's scope and receives two arguments - the node and the event that triggered the `activate_node` call. Returning false prevents working with the node, returning true allows invoking activate_node. Defaults to returning `true`.\n     * @name $.jstree.defaults.checkbox.visible\n     * @plugin checkbox\n     */\n    $.jstree.defaults.conditionalselect = function () { return true; };\n    $.jstree.plugins.conditionalselect = function (options, parent) {\n        // own function\n        this.activate_node = function (obj, e) {\n            if(this.settings.conditionalselect.call(this, this.get_node(obj), e)) {\n                return parent.activate_node.call(this, obj, e);\n            }\n        };\n    };\n\n\n    /**\n     * ### Contextmenu plugin\n     *\n     * Shows a context menu when a node is right-clicked.\n     */\n\n    /**\n     * stores all defaults for the contextmenu plugin\n     * @name $.jstree.defaults.contextmenu\n     * @plugin contextmenu\n     */\n    $.jstree.defaults.contextmenu = {\n        /**\n         * a boolean indicating if the node should be selected when the context menu is invoked on it. Defaults to `true`.\n         * @name $.jstree.defaults.contextmenu.select_node\n         * @plugin contextmenu\n         */\n        select_node : true,\n        /**\n         * a boolean indicating if the menu should be shown aligned with the node. Defaults to `true`, otherwise the mouse coordinates are used.\n         * @name $.jstree.defaults.contextmenu.show_at_node\n         * @plugin contextmenu\n         */\n        show_at_node : true,\n        /**\n         * an object of actions, or a function that accepts a node and a callback function and calls the callback function with an object of actions available for that node (you can also return the items too).\n         *\n         * Each action consists of a key (a unique name) and a value which is an object with the following properties (only label and action are required). Once a menu item is activated the `action` function will be invoked with an object containing the following keys: item - the contextmenu item definition as seen below, reference - the DOM node that was used (the tree node), element - the contextmenu DOM element, position - an object with x/y properties indicating the position of the menu.\n         *\n         * * `separator_before` - a boolean indicating if there should be a separator before this item\n         * * `separator_after` - a boolean indicating if there should be a separator after this item\n         * * `_disabled` - a boolean indicating if this action should be disabled\n         * * `label` - a string - the name of the action (could be a function returning a string)\n         * * `title` - a string - an optional tooltip for the item\n         * * `action` - a function to be executed if this item is chosen, the function will receive\n         * * `icon` - a string, can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class\n         * * `shortcut` - keyCode which will trigger the action if the menu is open (for example `113` for rename, which equals F2)\n         * * `shortcut_label` - shortcut label (like for example `F2` for rename)\n         * * `submenu` - an object with the same structure as $.jstree.defaults.contextmenu.items which can be used to create a submenu - each key will be rendered as a separate option in a submenu that will appear once the current item is hovered\n         *\n         * @name $.jstree.defaults.contextmenu.items\n         * @plugin contextmenu\n         */\n        items : function (o, cb) { // Could be an object directly\n            return {\n                \"create\" : {\n                    \"separator_before\"\t: false,\n                    \"separator_after\"\t: true,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"create_node\", data.reference, {}, \"last\")),\n                    \"label\"\t\t\t\t: \"Create\",\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        inst.create_node(obj, {}, \"last\", function (new_node) {\n                            try {\n                                inst.edit(new_node);\n                            } catch (ex) {\n                                setTimeout(function () { inst.edit(new_node); },0);\n                            }\n                        });\n                    }\n                },\n                \"rename\" : {\n                    \"separator_before\"\t: false,\n                    \"separator_after\"\t: false,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"rename_node\", data.reference, this.get_parent(data.reference), \"\")),\n                    \"label\"\t\t\t\t: \"Rename\",\n                    /*!\n\t\t\t\t\t\"shortcut\"\t\t\t: 113,\n\t\t\t\t\t\"shortcut_label\"\t: 'F2',\n\t\t\t\t\t\"icon\"\t\t\t\t: \"glyphicon glyphicon-leaf\",\n\t\t\t\t\t*/\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        inst.edit(obj);\n                    }\n                },\n                \"remove\" : {\n                    \"separator_before\"\t: false,\n                    \"icon\"\t\t\t\t: false,\n                    \"separator_after\"\t: false,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"delete_node\", data.reference, this.get_parent(data.reference), \"\")),\n                    \"label\"\t\t\t\t: \"Delete\",\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        if(inst.is_selected(obj)) {\n                            inst.delete_node(inst.get_selected());\n                        }\n                        else {\n                            inst.delete_node(obj);\n                        }\n                    }\n                },\n                \"ccp\" : {\n                    \"separator_before\"\t: true,\n                    \"icon\"\t\t\t\t: false,\n                    \"separator_after\"\t: false,\n                    \"label\"\t\t\t\t: \"Edit\",\n                    \"action\"\t\t\t: false,\n                    \"submenu\" : {\n                        \"cut\" : {\n                            \"separator_before\"\t: false,\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Cut\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                if(inst.is_selected(obj)) {\n                                    inst.cut(inst.get_top_selected());\n                                }\n                                else {\n                                    inst.cut(obj);\n                                }\n                            }\n                        },\n                        \"copy\" : {\n                            \"separator_before\"\t: false,\n                            \"icon\"\t\t\t\t: false,\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Copy\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                if(inst.is_selected(obj)) {\n                                    inst.copy(inst.get_top_selected());\n                                }\n                                else {\n                                    inst.copy(obj);\n                                }\n                            }\n                        },\n                        \"paste\" : {\n                            \"separator_before\"\t: false,\n                            \"icon\"\t\t\t\t: false,\n                            \"_disabled\"\t\t\t: function (data) {\n                                return !$.jstree.reference(data.reference).can_paste();\n                            },\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Paste\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                inst.paste(obj);\n                            }\n                        }\n                    }\n                }\n            };\n        }\n    };\n\n    $.jstree.plugins.contextmenu = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            var last_ts = 0, cto = null, ex, ey;\n            this.element\n                .on(\"init.jstree loading.jstree ready.jstree\", function () {\n                    this.get_container_ul().addClass('jstree-contextmenu');\n                }.bind(this))\n                .on(\"contextmenu.jstree\", \".jstree-anchor\", function (e, data) {\n                    if (e.target.tagName.toLowerCase() === 'input') {\n                        return;\n                    }\n                    e.preventDefault();\n                    last_ts = e.ctrlKey ? +new Date() : 0;\n                    if(data || cto) {\n                        last_ts = (+new Date()) + 10000;\n                    }\n                    if(cto) {\n                        clearTimeout(cto);\n                    }\n                    if(!this.is_loading(e.currentTarget)) {\n                        this.show_contextmenu(e.currentTarget, e.pageX, e.pageY, e);\n                    }\n                }.bind(this))\n                .on(\"click.jstree\", \".jstree-anchor\", function (e) {\n                    if(this._data.contextmenu.visible && (!last_ts || (+new Date()) - last_ts > 250)) { // work around safari & macOS ctrl+click\n                        $.vakata.context.hide();\n                    }\n                    last_ts = 0;\n                }.bind(this))\n                .on(\"touchstart.jstree\", \".jstree-anchor\", function (e) {\n                    if(!e.originalEvent || !e.originalEvent.changedTouches || !e.originalEvent.changedTouches[0]) {\n                        return;\n                    }\n                    ex = e.originalEvent.changedTouches[0].clientX;\n                    ey = e.originalEvent.changedTouches[0].clientY;\n                    cto = setTimeout(function () {\n                        $(e.currentTarget).trigger('contextmenu', true);\n                    }, 750);\n                })\n                .on('touchmove.vakata.jstree', function (e) {\n                    if(cto && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0] && (Math.abs(ex - e.originalEvent.changedTouches[0].clientX) > 10 || Math.abs(ey - e.originalEvent.changedTouches[0].clientY) > 10)) {\n                        clearTimeout(cto);\n                        $.vakata.context.hide();\n                    }\n                })\n                .on('touchend.vakata.jstree', function (e) {\n                    if(cto) {\n                        clearTimeout(cto);\n                    }\n                });\n\n            /*!\n\t\t\tif(!('oncontextmenu' in document.body) && ('ontouchstart' in document.body)) {\n\t\t\t\tvar el = null, tm = null;\n\t\t\t\tthis.element\n\t\t\t\t\t.on(\"touchstart\", \".jstree-anchor\", function (e) {\n\t\t\t\t\t\tel = e.currentTarget;\n\t\t\t\t\t\ttm = +new Date();\n\t\t\t\t\t\t$(document).one(\"touchend\", function (e) {\n\t\t\t\t\t\t\te.target = document.elementFromPoint(e.originalEvent.targetTouches[0].pageX - window.pageXOffset, e.originalEvent.targetTouches[0].pageY - window.pageYOffset);\n\t\t\t\t\t\t\te.currentTarget = e.target;\n\t\t\t\t\t\t\ttm = ((+(new Date())) - tm);\n\t\t\t\t\t\t\tif(e.target === el && tm > 600 && tm < 1000) {\n\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t$(el).trigger('contextmenu', e);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tel = null;\n\t\t\t\t\t\t\ttm = null;\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t}\n\t\t\t*/\n            $(document).on(\"context_hide.vakata.jstree\", function (e, data) {\n                this._data.contextmenu.visible = false;\n                $(data.reference).removeClass('jstree-context');\n            }.bind(this));\n        };\n        this.teardown = function () {\n            if(this._data.contextmenu.visible) {\n                $.vakata.context.hide();\n            }\n            $(document).off(\"context_hide.vakata.jstree\");\n            parent.teardown.call(this);\n        };\n\n        /**\n         * prepare and show the context menu for a node\n         * @name show_contextmenu(obj [, x, y])\n         * @param {mixed} obj the node\n         * @param {Number} x the x-coordinate relative to the document to show the menu at\n         * @param {Number} y the y-coordinate relative to the document to show the menu at\n         * @param {Object} e the event if available that triggered the contextmenu\n         * @plugin contextmenu\n         * @trigger show_contextmenu.jstree\n         */\n        this.show_contextmenu = function (obj, x, y, e) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var s = this.settings.contextmenu,\n                d = this.get_node(obj, true),\n                a = d.children(\".jstree-anchor\"),\n                o = false,\n                i = false;\n            if(s.show_at_node || x === undefined || y === undefined) {\n                o = a.offset();\n                x = o.left;\n                y = o.top + this._data.core.li_height;\n            }\n            if(this.settings.contextmenu.select_node && !this.is_selected(obj)) {\n                this.activate_node(obj, e);\n            }\n\n            i = s.items;\n            if($.vakata.is_function(i)) {\n                i = i.call(this, obj, function (i) {\n                    this._show_contextmenu(obj, x, y, i);\n                }.bind(this));\n            }\n            if($.isPlainObject(i)) {\n                this._show_contextmenu(obj, x, y, i);\n            }\n        };\n        /**\n         * show the prepared context menu for a node\n         * @name _show_contextmenu(obj, x, y, i)\n         * @param {mixed} obj the node\n         * @param {Number} x the x-coordinate relative to the document to show the menu at\n         * @param {Number} y the y-coordinate relative to the document to show the menu at\n         * @param {Number} i the object of items to show\n         * @plugin contextmenu\n         * @trigger show_contextmenu.jstree\n         * @private\n         */\n        this._show_contextmenu = function (obj, x, y, i) {\n            var d = this.get_node(obj, true),\n                a = d.children(\".jstree-anchor\");\n            $(document).one(\"context_show.vakata.jstree\", function (e, data) {\n                var cls = 'jstree-contextmenu jstree-' + this.get_theme() + '-contextmenu';\n                $(data.element).addClass(cls);\n                a.addClass('jstree-context');\n            }.bind(this));\n            this._data.contextmenu.visible = true;\n            $.vakata.context.show(a, { 'x' : x, 'y' : y }, i);\n            /**\n             * triggered when the contextmenu is shown for a node\n             * @event\n             * @name show_contextmenu.jstree\n             * @param {Object} node the node\n             * @param {Number} x the x-coordinate of the menu relative to the document\n             * @param {Number} y the y-coordinate of the menu relative to the document\n             * @plugin contextmenu\n             */\n            this.trigger('show_contextmenu', { \"node\" : obj, \"x\" : x, \"y\" : y });\n        };\n    };\n\n    // contextmenu helper\n    (function ($) {\n        var right_to_left = false,\n            vakata_context = {\n                element\t\t: false,\n                reference\t: false,\n                position_x\t: 0,\n                position_y\t: 0,\n                items\t\t: [],\n                html\t\t: \"\",\n                is_visible\t: false\n            };\n\n        $.vakata.context = {\n            settings : {\n                hide_onmouseleave\t: 0,\n                icons\t\t\t\t: true\n            },\n            _trigger : function (event_name) {\n                $(document).triggerHandler(\"context_\" + event_name + \".vakata\", {\n                    \"reference\"\t: vakata_context.reference,\n                    \"element\"\t: vakata_context.element,\n                    \"position\"\t: {\n                        \"x\" : vakata_context.position_x,\n                        \"y\" : vakata_context.position_y\n                    }\n                });\n            },\n            _execute : function (i) {\n                i = vakata_context.items[i];\n                return i && (!i._disabled || ($.vakata.is_function(i._disabled) && !i._disabled({ \"item\" : i, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element }))) && i.action ? i.action.call(null, {\n                    \"item\"\t\t: i,\n                    \"reference\"\t: vakata_context.reference,\n                    \"element\"\t: vakata_context.element,\n                    \"position\"\t: {\n                        \"x\" : vakata_context.position_x,\n                        \"y\" : vakata_context.position_y\n                    }\n                }) : false;\n            },\n            _parse : function (o, is_callback) {\n                if(!o) { return false; }\n                if(!is_callback) {\n                    vakata_context.html\t\t= \"\";\n                    vakata_context.items\t= [];\n                }\n                var str = \"\",\n                    sep = false,\n                    tmp;\n\n                if(is_callback) { str += \"<\"+\"ul>\"; }\n                $.each(o, function (i, val) {\n                    if(!val) { return true; }\n                    vakata_context.items.push(val);\n                    if(!sep && val.separator_before) {\n                        str += \"<\"+\"li class='vakata-context-separator'><\"+\"a href='#' \" + ($.vakata.context.settings.icons ? '' : 'class=\"vakata-context-no-icons\"') + \">&#160;<\"+\"/a><\"+\"/li>\";\n                    }\n                    sep = false;\n                    str += \"<\"+\"li class='\" + (val._class || \"\") + (val._disabled === true || ($.vakata.is_function(val._disabled) && val._disabled({ \"item\" : val, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element })) ? \" vakata-contextmenu-disabled \" : \"\") + \"' \"+(val.shortcut?\" data-shortcut='\"+val.shortcut+\"' \":'')+\">\";\n                    str += \"<\"+\"a href='#' rel='\" + (vakata_context.items.length - 1) + \"' \" + (val.title ? \"title='\" + val.title + \"'\" : \"\") + \">\";\n                    if($.vakata.context.settings.icons) {\n                        str += \"<\"+\"i \";\n                        if(val.icon) {\n                            if(val.icon.indexOf(\"/\") !== -1 || val.icon.indexOf(\".\") !== -1) { str += \" style='background:url(\\\"\" + val.icon + \"\\\") center center no-repeat' \"; }\n                            else { str += \" class='\" + val.icon + \"' \"; }\n                        }\n                        str += \"><\"+\"/i><\"+\"span class='vakata-contextmenu-sep'>&#160;<\"+\"/span>\";\n                    }\n                    str += ($.vakata.is_function(val.label) ? val.label({ \"item\" : i, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element }) : val.label) + (val.shortcut?' <span class=\"vakata-contextmenu-shortcut vakata-contextmenu-shortcut-'+val.shortcut+'\">'+ (val.shortcut_label || '') +'</span>':'') + \"<\"+\"/a>\";\n                    if(val.submenu) {\n                        tmp = $.vakata.context._parse(val.submenu, true);\n                        if(tmp) { str += tmp; }\n                    }\n                    str += \"<\"+\"/li>\";\n                    if(val.separator_after) {\n                        str += \"<\"+\"li class='vakata-context-separator'><\"+\"a href='#' \" + ($.vakata.context.settings.icons ? '' : 'class=\"vakata-context-no-icons\"') + \">&#160;<\"+\"/a><\"+\"/li>\";\n                        sep = true;\n                    }\n                });\n                str  = str.replace(/<li class\\='vakata-context-separator'\\><\\/li\\>$/,\"\");\n                if(is_callback) { str += \"</ul>\"; }\n                /**\n                 * triggered on the document when the contextmenu is parsed (HTML is built)\n                 * @event\n                 * @plugin contextmenu\n                 * @name context_parse.vakata\n                 * @param {jQuery} reference the element that was right clicked\n                 * @param {jQuery} element the DOM element of the menu itself\n                 * @param {Object} position the x & y coordinates of the menu\n                 */\n                if(!is_callback) { vakata_context.html = str; $.vakata.context._trigger(\"parse\"); }\n                return str.length > 10 ? str : false;\n            },\n            _show_submenu : function (o) {\n                o = $(o);\n                if(!o.length || !o.children(\"ul\").length) { return; }\n                var e = o.children(\"ul\"),\n                    xl = o.offset().left,\n                    x = xl + o.outerWidth(),\n                    y = o.offset().top,\n                    w = e.width(),\n                    h = e.height(),\n                    dw = $(window).width() + $(window).scrollLeft(),\n                    dh = $(window).height() + $(window).scrollTop();\n                // \u043c\u043e\u0436\u0435 \u0434\u0430 \u0441\u0435 \u0441\u043f\u0435\u0441\u0442\u0438 \u0435 \u0435\u0434\u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 - \u0434\u0430\u043b\u0438 \u043d\u044f\u043c\u0430 \u043d\u044f\u043a\u043e\u0439 \u043e\u0442 \u043a\u043b\u0430\u0441\u043e\u0432\u0435\u0442\u0435 \u0432\u0435\u0447\u0435 \u043d\u0430\u0433\u043e\u0440\u0435\n                if(right_to_left) {\n                    o[x - (w + 10 + o.outerWidth()) < 0 ? \"addClass\" : \"removeClass\"](\"vakata-context-left\");\n                }\n                else {\n                    o[x + w > dw  && xl > dw - x ? \"addClass\" : \"removeClass\"](\"vakata-context-right\");\n                }\n                if(y + h + 10 > dh) {\n                    e.css(\"bottom\",\"-1px\");\n                }\n\n                //if does not fit - stick it to the side\n                if (o.hasClass('vakata-context-right')) {\n                    if (xl < w) {\n                        e.css(\"margin-right\", xl - w);\n                    }\n                } else {\n                    if (dw - x < w) {\n                        e.css(\"margin-left\", dw - x - w);\n                    }\n                }\n\n                e.show();\n            },\n            show : function (reference, position, data) {\n                var o, e, x, y, w, h, dw, dh, cond = true;\n                if(vakata_context.element && vakata_context.element.length) {\n                    vakata_context.element.width('');\n                }\n                switch(cond) {\n                    case (!position && !reference):\n                        return false;\n                    case (!!position && !!reference):\n                        vakata_context.reference\t= reference;\n                        vakata_context.position_x\t= position.x;\n                        vakata_context.position_y\t= position.y;\n                        break;\n                    case (!position && !!reference):\n                        vakata_context.reference\t= reference;\n                        o = reference.offset();\n                        vakata_context.position_x\t= o.left + reference.outerHeight();\n                        vakata_context.position_y\t= o.top;\n                        break;\n                    case (!!position && !reference):\n                        vakata_context.position_x\t= position.x;\n                        vakata_context.position_y\t= position.y;\n                        break;\n                }\n                if(!!reference && !data && $(reference).data('vakata_contextmenu')) {\n                    data = $(reference).data('vakata_contextmenu');\n                }\n                if($.vakata.context._parse(data)) {\n                    vakata_context.element.html(vakata_context.html);\n                }\n                if(vakata_context.items.length) {\n                    vakata_context.element.appendTo(document.body);\n                    e = vakata_context.element;\n                    x = vakata_context.position_x;\n                    y = vakata_context.position_y;\n                    w = e.width();\n                    h = e.height();\n                    dw = $(window).width() + $(window).scrollLeft();\n                    dh = $(window).height() + $(window).scrollTop();\n                    if(right_to_left) {\n                        x -= (e.outerWidth() - $(reference).outerWidth());\n                        if(x < $(window).scrollLeft() + 20) {\n                            x = $(window).scrollLeft() + 20;\n                        }\n                    }\n                    if(x + w + 20 > dw) {\n                        x = dw - (w + 20);\n                    }\n                    if(y + h + 20 > dh) {\n                        y = dh - (h + 20);\n                    }\n\n                    vakata_context.element\n                        .css({ \"left\" : x, \"top\" : y })\n                        .show()\n                        .find('a').first().trigger('focus').parent().addClass(\"vakata-context-hover\");\n                    vakata_context.is_visible = true;\n                    /**\n                     * triggered on the document when the contextmenu is shown\n                     * @event\n                     * @plugin contextmenu\n                     * @name context_show.vakata\n                     * @param {jQuery} reference the element that was right clicked\n                     * @param {jQuery} element the DOM element of the menu itself\n                     * @param {Object} position the x & y coordinates of the menu\n                     */\n                    $.vakata.context._trigger(\"show\");\n                }\n            },\n            hide : function () {\n                if(vakata_context.is_visible) {\n                    vakata_context.element.hide().find(\"ul\").hide().end().find(':focus').trigger('blur').end().detach();\n                    vakata_context.is_visible = false;\n                    /**\n                     * triggered on the document when the contextmenu is hidden\n                     * @event\n                     * @plugin contextmenu\n                     * @name context_hide.vakata\n                     * @param {jQuery} reference the element that was right clicked\n                     * @param {jQuery} element the DOM element of the menu itself\n                     * @param {Object} position the x & y coordinates of the menu\n                     */\n                    $.vakata.context._trigger(\"hide\");\n                }\n            }\n        };\n        $(function () {\n            right_to_left = $(document.body).css(\"direction\") === \"rtl\";\n            var to = false;\n\n            vakata_context.element = $(\"<ul class='vakata-context'></ul>\");\n            vakata_context.element\n                .on(\"mouseenter\", \"li\", function (e) {\n                    e.stopImmediatePropagation();\n\n                    if($.contains(this, e.relatedTarget)) {\n                        // \u043f\u0440\u0435\u043c\u0430\u0445\u043d\u0430\u0442\u043e \u0437\u0430\u0440\u0430\u0434\u0438 delegate mouseleave \u043f\u043e-\u0434\u043e\u043b\u0443\n                        // $(this).find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\");\n                        return;\n                    }\n\n                    if(to) { clearTimeout(to); }\n                    vakata_context.element.find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").end();\n\n                    $(this)\n                        .siblings().find(\"ul\").hide().end().end()\n                        .parentsUntil(\".vakata-context\", \"li\").addBack().addClass(\"vakata-context-hover\");\n                    $.vakata.context._show_submenu(this);\n                })\n                // \u0442\u0435\u0441\u0442\u043e\u0432\u043e - \u0434\u0430\u043b\u0438 \u043d\u0435 \u043d\u0430\u0442\u043e\u0432\u0430\u0440\u0432\u0430?\n                .on(\"mouseleave\", \"li\", function (e) {\n                    if($.contains(this, e.relatedTarget)) { return; }\n                    $(this).find(\".vakata-context-hover\").addBack().removeClass(\"vakata-context-hover\");\n                })\n                .on(\"mouseleave\", function (e) {\n                    $(this).find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\");\n                    if($.vakata.context.settings.hide_onmouseleave) {\n                        to = setTimeout(\n                            (function (t) {\n                                return function () { $.vakata.context.hide(); };\n                            }(this)), $.vakata.context.settings.hide_onmouseleave);\n                    }\n                })\n                .on(\"click\", \"a\", function (e) {\n                    e.preventDefault();\n                    //})\n                    //.on(\"mouseup\", \"a\", function (e) {\n                    if(!$(this).trigger('blur').parent().hasClass(\"vakata-context-disabled\") && $.vakata.context._execute($(this).attr(\"rel\")) !== false) {\n                        $.vakata.context.hide();\n                    }\n                })\n                .on('keydown', 'a', function (e) {\n                    var o = null;\n                    switch(e.which) {\n                        case 13:\n                        case 32:\n                            e.type = \"click\";\n                            e.preventDefault();\n                            $(e.currentTarget).trigger(e);\n                            break;\n                        case 37:\n                            if(vakata_context.is_visible) {\n                                vakata_context.element.find(\".vakata-context-hover\").last().closest(\"li\").first().find(\"ul\").hide().find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").end().end().children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 38:\n                            if(vakata_context.is_visible) {\n                                o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").prevAll(\"li:not(.vakata-context-separator)\").first();\n                                if(!o.length) { o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\"li:not(.vakata-context-separator)\").last(); }\n                                o.addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 39:\n                            if(vakata_context.is_visible) {\n                                vakata_context.element.find(\".vakata-context-hover\").last().children(\"ul\").show().children(\"li:not(.vakata-context-separator)\").removeClass(\"vakata-context-hover\").first().addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 40:\n                            if(vakata_context.is_visible) {\n                                o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").nextAll(\"li:not(.vakata-context-separator)\").first();\n                                if(!o.length) { o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\"li:not(.vakata-context-separator)\").first(); }\n                                o.addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 27:\n                            $.vakata.context.hide();\n                            e.preventDefault();\n                            break;\n                        default:\n                            //console.log(e.which);\n                            break;\n                    }\n                })\n                .on('keydown', function (e) {\n                    e.preventDefault();\n                    var a = vakata_context.element.find('.vakata-contextmenu-shortcut-' + e.which).parent();\n                    if(a.parent().not('.vakata-context-disabled')) {\n                        a.trigger('click');\n                    }\n                });\n\n            $(document)\n                .on(\"mousedown.vakata.jstree\", function (e) {\n                    if(vakata_context.is_visible && vakata_context.element[0] !== e.target  && !$.contains(vakata_context.element[0], e.target)) {\n                        $.vakata.context.hide();\n                    }\n                })\n                .on(\"context_show.vakata.jstree\", function (e, data) {\n                    vakata_context.element.find(\"li:has(ul)\").children(\"a\").addClass(\"vakata-context-parent\");\n                    if(right_to_left) {\n                        vakata_context.element.addClass(\"vakata-context-rtl\").css(\"direction\", \"rtl\");\n                    }\n                    // also apply a RTL class?\n                    vakata_context.element.find(\"ul\").hide().end();\n                });\n        });\n    }($));\n    // $.jstree.defaults.plugins.push(\"contextmenu\");\n\n\n    /**\n     * ### Drag'n'drop plugin\n     *\n     * Enables dragging and dropping of nodes in the tree, resulting in a move or copy operations.\n     */\n\n    /**\n     * stores all defaults for the drag'n'drop plugin\n     * @name $.jstree.defaults.dnd\n     * @plugin dnd\n     */\n    $.jstree.defaults.dnd = {\n        /**\n         * a boolean indicating if a copy should be possible while dragging (by pressint the meta key or Ctrl). Defaults to `true`.\n         * @name $.jstree.defaults.dnd.copy\n         * @plugin dnd\n         */\n        copy : true,\n        /**\n         * a number indicating how long a node should remain hovered while dragging to be opened. Defaults to `500`.\n         * @name $.jstree.defaults.dnd.open_timeout\n         * @plugin dnd\n         */\n        open_timeout : 500,\n        /**\n         * a function invoked each time a node is about to be dragged, invoked in the tree's scope and receives the nodes about to be dragged as an argument (array) and the event that started the drag - return `false` to prevent dragging\n         * @name $.jstree.defaults.dnd.is_draggable\n         * @plugin dnd\n         */\n        is_draggable : true,\n        /**\n         * a boolean indicating if checks should constantly be made while the user is dragging the node (as opposed to checking only on drop), default is `true`\n         * @name $.jstree.defaults.dnd.check_while_dragging\n         * @plugin dnd\n         */\n        check_while_dragging : true,\n        /**\n         * a boolean indicating if nodes from this tree should only be copied with dnd (as opposed to moved), default is `false`\n         * @name $.jstree.defaults.dnd.always_copy\n         * @plugin dnd\n         */\n        always_copy : false,\n        /**\n         * when dropping a node \"inside\", this setting indicates the position the node should go to - it can be an integer or a string: \"first\" (same as 0) or \"last\", default is `0`\n         * @name $.jstree.defaults.dnd.inside_pos\n         * @plugin dnd\n         */\n        inside_pos : 0,\n        /**\n         * when starting the drag on a node that is selected this setting controls if all selected nodes are dragged or only the single node, default is `true`, which means all selected nodes are dragged when the drag is started on a selected node\n         * @name $.jstree.defaults.dnd.drag_selection\n         * @plugin dnd\n         */\n        drag_selection : true,\n        /**\n         * controls whether dnd works on touch devices. If left as boolean true dnd will work the same as in desktop browsers, which in some cases may impair scrolling. If set to boolean false dnd will not work on touch devices. There is a special third option - string \"selected\" which means only selected nodes can be dragged on touch devices.\n         * @name $.jstree.defaults.dnd.touch\n         * @plugin dnd\n         */\n        touch : true,\n        /**\n         * controls whether items can be dropped anywhere on the node, not just on the anchor, by default only the node anchor is a valid drop target. Works best with the wholerow plugin. If enabled on mobile depending on the interface it might be hard for the user to cancel the drop, since the whole tree container will be a valid drop target.\n         * @name $.jstree.defaults.dnd.large_drop_target\n         * @plugin dnd\n         */\n        large_drop_target : false,\n        /**\n         * controls whether a drag can be initiated from any part of the node and not just the text/icon part, works best with the wholerow plugin. Keep in mind it can cause problems with tree scrolling on mobile depending on the interface - in that case set the touch option to \"selected\".\n         * @name $.jstree.defaults.dnd.large_drag_target\n         * @plugin dnd\n         */\n        large_drag_target : false,\n        /**\n         * controls whether use HTML5 dnd api instead of classical. That will allow better integration of dnd events with other HTML5 controls.\n         * @reference http://caniuse.com/#feat=dragndrop\n         * @name $.jstree.defaults.dnd.use_html5\n         * @plugin dnd\n         */\n        use_html5: false,\n        /**\n         * controls whether items can be dropped anywhere on the tree.\n         * @name $.jstree.defaults.dnd.blank_space_drop\n         * @plugin dnd\n         */\n        blank_space_drop: false\n    };\n    var drg, elm;\n    // TODO: now check works by checking for each node individually, how about max_children, unique, etc?\n    $.jstree.plugins.dnd = function (options, parent) {\n        this.init = function (el, options) {\n            parent.init.call(this, el, options);\n            this.settings.dnd.use_html5 = this.settings.dnd.use_html5 && ('draggable' in document.createElement('span'));\n        };\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this.element\n                .on(this.settings.dnd.use_html5 ? 'dragstart.jstree' : 'mousedown.jstree touchstart.jstree', this.settings.dnd.large_drag_target ? '.jstree-node' : '.jstree-anchor', function (e) {\n                    if(this.settings.dnd.large_drag_target && $(e.target).closest('.jstree-node')[0] !== e.currentTarget) {\n                        return true;\n                    }\n                    if(e.type === \"touchstart\" && (!this.settings.dnd.touch || (this.settings.dnd.touch === 'selected' && !$(e.currentTarget).closest('.jstree-node').children('.jstree-anchor').hasClass('jstree-clicked')))) {\n                        return true;\n                    }\n                    var obj = this.get_node(e.target),\n                        mlt = this.is_selected(obj) && this.settings.dnd.drag_selection ? this.get_top_selected().length : 1,\n                        txt = (mlt > 1 ? mlt + ' ' + this.get_string('nodes') : this.get_text(e.currentTarget));\n                    if(this.settings.core.force_text) {\n                        txt = $.vakata.html.escape(txt);\n                    }\n                    if(obj && (obj.id || obj.id === 0) && obj.id !== $.jstree.root && (e.which === 1 || e.type === \"touchstart\" || e.type === \"dragstart\") &&\n                        (this.settings.dnd.is_draggable === true || ($.vakata.is_function(this.settings.dnd.is_draggable) && this.settings.dnd.is_draggable.call(this, (mlt > 1 ? this.get_top_selected(true) : [obj]), e)))\n                    ) {\n                        drg = { 'jstree' : true, 'origin' : this, 'obj' : this.get_node(obj,true), 'nodes' : mlt > 1 ? this.get_top_selected() : [obj.id] };\n                        elm = e.currentTarget;\n                        if (this.settings.dnd.use_html5) {\n                            $.vakata.dnd._trigger('start', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        } else {\n                            this.element.trigger('mousedown.jstree');\n                            return $.vakata.dnd.start(e, drg, '<div id=\"jstree-dnd\" class=\"jstree-' + this.get_theme() + ' jstree-' + this.get_theme() + '-' + this.get_theme_variant() + ' ' + ( this.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ) + '\"><i class=\"jstree-icon jstree-er\"></i>' + txt + '<ins class=\"jstree-copy\">+</ins></div>');\n                        }\n                    }\n                }.bind(this));\n            if (this.settings.dnd.use_html5) {\n                this.element\n                    .on('dragover.jstree', function (e) {\n                        e.preventDefault();\n                        $.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        return false;\n                    })\n                    //.on('dragenter.jstree', this.settings.dnd.large_drop_target ? '.jstree-node' : '.jstree-anchor', $.proxy(function (e) {\n                    //\t\te.preventDefault();\n                    //\t\t$.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                    //\t\treturn false;\n                    //\t}, this))\n                    .on('drop.jstree', function (e) {\n                        e.preventDefault();\n                        $.vakata.dnd._trigger('stop', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        return false;\n                    }.bind(this));\n            }\n        };\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if (obj && this.settings.dnd.use_html5) {\n                if (this.settings.dnd.large_drag_target) {\n                    obj.setAttribute('draggable', true);\n                } else {\n                    var i, j, tmp = null;\n                    for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                        if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                            tmp = obj.childNodes[i];\n                            break;\n                        }\n                    }\n                    if(tmp) {\n                        tmp.setAttribute('draggable', true);\n                    }\n                }\n            }\n            return obj;\n        };\n    };\n\n    $(function() {\n        // bind only once for all instances\n        var lastmv = false,\n            laster = false,\n            lastev = false,\n            opento = false,\n            marker = $('<div id=\"jstree-marker\">&#160;</div>').hide(); //.appendTo('body');\n\n        $(document)\n            .on('dragover.vakata.jstree', function (e) {\n                if (elm) {\n                    $.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                }\n            })\n            .on('drop.vakata.jstree', function (e) {\n                if (elm) {\n                    $.vakata.dnd._trigger('stop', e, { 'helper': $(), 'element': elm, 'data': drg });\n                    elm = null;\n                    drg = null;\n                }\n            })\n            .on('dnd_start.vakata.jstree', function (e, data) {\n                lastmv = false;\n                lastev = false;\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.appendTo(document.body); //.show();\n            })\n            .on('dnd_move.vakata.jstree', function (e, data) {\n                var isDifferentNode = data.event.target !== lastev.target;\n                if(opento) {\n                    if (!data.event || data.event.type !== 'dragover' || isDifferentNode) {\n                        clearTimeout(opento);\n                    }\n                }\n                if(!data || !data.data || !data.data.jstree) { return; }\n\n                // if we are hovering the marker image do nothing (can happen on \"inside\" drags)\n                if(data.event.target.id && data.event.target.id === 'jstree-marker') {\n                    return;\n                }\n                lastev = data.event;\n\n                var ins = $.jstree.reference(data.event.target),\n                    ref = false,\n                    off = false,\n                    rel = false,\n                    tmp, l, t, h, p, i, o, ok, t1, t2, op, ps, pr, ip, tm, is_copy, pn, c;\n                // if we are over an instance\n                if(ins && ins._data && ins._data.dnd) {\n                    marker.attr('class', 'jstree-' + ins.get_theme() + ( ins.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ));\n                    is_copy = data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey)));\n                    data.helper\n                        .children().attr('class', 'jstree-' + ins.get_theme() + ' jstree-' + ins.get_theme() + '-' + ins.get_theme_variant() + ' ' + ( ins.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ))\n                        .find('.jstree-copy').first()[ is_copy ? 'show' : 'hide' ]();\n\n                    // if are hovering the container itself add a new root node\n                    //console.log(data.event);\n                    if( (data.event.target === ins.element[0] || data.event.target === ins.get_container_ul()[0]) && (ins.get_container_ul().children().length === 0 || ins.settings.dnd.blank_space_drop)) {\n                        ok = true;\n                        for(t1 = 0, t2 = data.data.nodes.length; t1 < t2; t1++) {\n                            ok = ok && ins.check( (data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey)) ) ? \"copy_node\" : \"move_node\"), (data.data.origin && data.data.origin !== ins ? data.data.origin.get_node(data.data.nodes[t1]) : data.data.nodes[t1]), $.jstree.root, 'last', { 'dnd' : true, 'ref' : ins.get_node($.jstree.root), 'pos' : 'i', 'origin' : data.data.origin, 'is_multi' : (data.data.origin && data.data.origin !== ins), 'is_foreign' : (!data.data.origin) });\n                            if(!ok) { break; }\n                        }\n                        if(ok) {\n                            lastmv = { 'ins' : ins, 'par' : $.jstree.root, 'pos' : 'last' };\n                            marker.hide();\n                            data.helper.find('.jstree-icon').first().removeClass('jstree-er').addClass('jstree-ok');\n                            if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                                data.event.originalEvent.dataTransfer.dropEffect = is_copy ? 'copy' : 'move';\n                            }\n                            return;\n                        }\n                    }\n                    else {\n                        // if we are hovering a tree node\n                        ref = ins.settings.dnd.large_drop_target ? $(data.event.target).closest('.jstree-node').children('.jstree-anchor') : $(data.event.target).closest('.jstree-anchor');\n\n                        if(ref && ref.length && ref.parent().is('.jstree-closed, .jstree-open, .jstree-leaf')) {\n                            off = ref.offset();\n                            rel = (data.event.pageY !== undefined ? data.event.pageY : data.event.originalEvent.pageY) - off.top;\n                            h = ref.outerHeight();\n                            if(rel < h / 3) {\n                                o = ['b', 'i', 'a'];\n                            }\n                            else if(rel > h - h / 3) {\n                                o = ['a', 'i', 'b'];\n                            }\n                            else {\n                                o = rel > h / 2 ? ['i', 'a', 'b'] : ['i', 'b', 'a'];\n                            }\n                            $.each(o, function (j, v) {\n                                switch(v) {\n                                    case 'b':\n                                        l = off.left - 6;\n                                        t = off.top;\n                                        p = ins.get_parent(ref);\n                                        i = ref.parent().index();\n                                        c = 'jstree-below';\n                                        break;\n                                    case 'i':\n                                        ip = ins.settings.dnd.inside_pos;\n                                        tm = ins.get_node(ref.parent());\n                                        l = off.left - 2;\n                                        t = off.top + h / 2 + 1;\n                                        p = tm.id;\n                                        i = ip === 'first' ? 0 : (ip === 'last' ? tm.children.length : Math.min(ip, tm.children.length));\n                                        c = 'jstree-inside';\n                                        break;\n                                    case 'a':\n                                        l = off.left - 6;\n                                        t = off.top + h;\n                                        p = ins.get_parent(ref);\n                                        i = ref.parent().index() + 1;\n                                        c = 'jstree-above';\n                                        break;\n                                }\n                                ok = true;\n                                for(t1 = 0, t2 = data.data.nodes.length; t1 < t2; t1++) {\n                                    op = data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey))) ? \"copy_node\" : \"move_node\";\n                                    ps = i;\n                                    if(op === \"move_node\" && v === 'a' && (data.data.origin && data.data.origin === ins) && p === ins.get_parent(data.data.nodes[t1])) {\n                                        pr = ins.get_node(p);\n                                        if(ps > $.inArray(data.data.nodes[t1], pr.children)) {\n                                            ps -= 1;\n                                        }\n                                    }\n                                    ok = ok && ( (ins && ins.settings && ins.settings.dnd && ins.settings.dnd.check_while_dragging === false) || ins.check(op, (data.data.origin && data.data.origin !== ins ? data.data.origin.get_node(data.data.nodes[t1]) : data.data.nodes[t1]), p, ps, { 'dnd' : true, 'ref' : ins.get_node(ref.parent()), 'pos' : v, 'origin' : data.data.origin, 'is_multi' : (data.data.origin && data.data.origin !== ins), 'is_foreign' : (!data.data.origin) }) );\n                                    if(!ok) {\n                                        if(ins && ins.last_error) { laster = ins.last_error(); }\n                                        break;\n                                    }\n                                }\n                                if(v === 'i' && ref.parent().is('.jstree-closed') && ins.settings.dnd.open_timeout) {\n                                    if (!data.event || data.event.type !== 'dragover' || isDifferentNode) {\n                                        if (opento) { clearTimeout(opento); }\n                                        opento = setTimeout((function (x, z) { return function () { x.open_node(z); }; }(ins, ref)), ins.settings.dnd.open_timeout);\n                                    }\n                                }\n                                if(ok) {\n                                    pn = ins.get_node(p, true);\n                                    if (!pn.hasClass('.jstree-dnd-parent')) {\n                                        $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                                        pn.addClass('jstree-dnd-parent');\n                                    }\n                                    lastmv = { 'ins' : ins, 'par' : p, 'pos' : v === 'i' && ip === 'last' && i === 0 && !ins.is_loaded(tm) ? 'last' : i };\n                                    marker.css({ 'left' : l + 'px', 'top' : t + 'px' }).show();\n                                    marker.removeClass('jstree-above jstree-inside jstree-below').addClass(c);\n                                    data.helper.find('.jstree-icon').first().removeClass('jstree-er').addClass('jstree-ok');\n                                    if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                                        data.event.originalEvent.dataTransfer.dropEffect = is_copy ? 'copy' : 'move';\n                                    }\n                                    laster = {};\n                                    o = true;\n                                    return false;\n                                }\n                            });\n                            if(o === true) { return; }\n                        }\n                    }\n                }\n                $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                lastmv = false;\n                data.helper.find('.jstree-icon').removeClass('jstree-ok').addClass('jstree-er');\n                if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                    //data.event.originalEvent.dataTransfer.dropEffect = 'none';\n                }\n                marker.hide();\n            })\n            .on('dnd_scroll.vakata.jstree', function (e, data) {\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.hide();\n                lastmv = false;\n                lastev = false;\n                data.helper.find('.jstree-icon').first().removeClass('jstree-ok').addClass('jstree-er');\n            })\n            .on('dnd_stop.vakata.jstree', function (e, data) {\n                $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                if(opento) { clearTimeout(opento); }\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.hide().detach();\n                var i, j, nodes = [];\n                if(lastmv) {\n                    for(i = 0, j = data.data.nodes.length; i < j; i++) {\n                        nodes[i] = data.data.origin ? data.data.origin.get_node(data.data.nodes[i]) : data.data.nodes[i];\n                    }\n                    lastmv.ins[ data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey))) ? 'copy_node' : 'move_node' ](nodes, lastmv.par, lastmv.pos, false, false, false, data.data.origin);\n                }\n                else {\n                    i = $(data.event.target).closest('.jstree');\n                    if(i.length && laster && laster.error && laster.error === 'check') {\n                        i = i.jstree(true);\n                        if(i) {\n                            i.settings.core.error.call(this, laster);\n                        }\n                    }\n                }\n                lastev = false;\n                lastmv = false;\n            })\n            .on('keyup.jstree keydown.jstree', function (e, data) {\n                data = $.vakata.dnd._get();\n                if(data && data.data && data.data.jstree) {\n                    if (e.type === \"keyup\" && e.which === 27) {\n                        if (opento) { clearTimeout(opento); }\n                        lastmv = false;\n                        laster = false;\n                        lastev = false;\n                        opento = false;\n                        marker.hide().detach();\n                        $.vakata.dnd._clean();\n                    } else {\n                        data.helper.find('.jstree-copy').first()[ data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (e.metaKey || e.ctrlKey))) ? 'show' : 'hide' ]();\n                        if(lastev) {\n                            lastev.metaKey = e.metaKey;\n                            lastev.ctrlKey = e.ctrlKey;\n                            $.vakata.dnd._trigger('move', lastev);\n                        }\n                    }\n                }\n            });\n    });\n\n    // helpers\n    (function ($) {\n        $.vakata.html = {\n            div : $('<div></div>'),\n            escape : function (str) {\n                return $.vakata.html.div.text(str).html();\n            },\n            strip : function (str) {\n                return $.vakata.html.div.empty().append($.parseHTML(str)).text();\n            }\n        };\n        // private variable\n        var vakata_dnd = {\n            element\t: false,\n            target\t: false,\n            is_down\t: false,\n            is_drag\t: false,\n            helper\t: false,\n            helper_w: 0,\n            data\t: false,\n            init_x\t: 0,\n            init_y\t: 0,\n            scroll_l: 0,\n            scroll_t: 0,\n            scroll_e: false,\n            scroll_i: false,\n            is_touch: false\n        };\n        $.vakata.dnd = {\n            settings : {\n                scroll_speed\t\t: 10,\n                scroll_proximity\t: 20,\n                helper_left\t\t\t: 5,\n                helper_top\t\t\t: 10,\n                threshold\t\t\t: 5,\n                threshold_touch\t\t: 10\n            },\n            _trigger : function (event_name, e, data) {\n                if (data === undefined) {\n                    data = $.vakata.dnd._get();\n                }\n                data.event = e;\n                $(document).triggerHandler(\"dnd_\" + event_name + \".vakata\", data);\n            },\n            _get : function () {\n                return {\n                    \"data\"\t\t: vakata_dnd.data,\n                    \"element\"\t: vakata_dnd.element,\n                    \"helper\"\t: vakata_dnd.helper\n                };\n            },\n            _clean : function () {\n                if(vakata_dnd.helper) { vakata_dnd.helper.remove(); }\n                if(vakata_dnd.scroll_i) { clearInterval(vakata_dnd.scroll_i); vakata_dnd.scroll_i = false; }\n                vakata_dnd = {\n                    element\t: false,\n                    target\t: false,\n                    is_down\t: false,\n                    is_drag\t: false,\n                    helper\t: false,\n                    helper_w: 0,\n                    data\t: false,\n                    init_x\t: 0,\n                    init_y\t: 0,\n                    scroll_l: 0,\n                    scroll_t: 0,\n                    scroll_e: false,\n                    scroll_i: false,\n                    is_touch: false\n                };\n                elm = null;\n                $(document).off(\"mousemove.vakata.jstree touchmove.vakata.jstree\", $.vakata.dnd.drag);\n                $(document).off(\"mouseup.vakata.jstree touchend.vakata.jstree\", $.vakata.dnd.stop);\n            },\n            _scroll : function (init_only) {\n                if(!vakata_dnd.scroll_e || (!vakata_dnd.scroll_l && !vakata_dnd.scroll_t)) {\n                    if(vakata_dnd.scroll_i) { clearInterval(vakata_dnd.scroll_i); vakata_dnd.scroll_i = false; }\n                    return false;\n                }\n                if(!vakata_dnd.scroll_i) {\n                    vakata_dnd.scroll_i = setInterval($.vakata.dnd._scroll, 100);\n                    return false;\n                }\n                if(init_only === true) { return false; }\n\n                var i = vakata_dnd.scroll_e.scrollTop(),\n                    j = vakata_dnd.scroll_e.scrollLeft();\n                vakata_dnd.scroll_e.scrollTop(i + vakata_dnd.scroll_t * $.vakata.dnd.settings.scroll_speed);\n                vakata_dnd.scroll_e.scrollLeft(j + vakata_dnd.scroll_l * $.vakata.dnd.settings.scroll_speed);\n                if(i !== vakata_dnd.scroll_e.scrollTop() || j !== vakata_dnd.scroll_e.scrollLeft()) {\n                    /**\n                     * triggered on the document when a drag causes an element to scroll\n                     * @event\n                     * @plugin dnd\n                     * @name dnd_scroll.vakata\n                     * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                     * @param {DOM} element the DOM element being dragged\n                     * @param {jQuery} helper the helper shown next to the mouse\n                     * @param {jQuery} event the element that is scrolling\n                     */\n                    $.vakata.dnd._trigger(\"scroll\", vakata_dnd.scroll_e);\n                }\n            },\n            start : function (e, data, html) {\n                if(e.type === \"touchstart\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(vakata_dnd.is_drag) { $.vakata.dnd.stop({}); }\n                try {\n                    e.currentTarget.unselectable = \"on\";\n                    e.currentTarget.onselectstart = function() { return false; };\n                    if(e.currentTarget.style) {\n                        e.currentTarget.style.touchAction = \"none\";\n                        e.currentTarget.style.msTouchAction = \"none\";\n                        e.currentTarget.style.MozUserSelect = \"none\";\n                    }\n                } catch(ignore) { }\n                vakata_dnd.init_x\t= e.pageX;\n                vakata_dnd.init_y\t= e.pageY;\n                vakata_dnd.data\t\t= data;\n                vakata_dnd.is_down\t= true;\n                vakata_dnd.element\t= e.currentTarget;\n                vakata_dnd.target\t= e.target;\n                vakata_dnd.is_touch\t= e.type === \"touchstart\";\n                if(html !== false) {\n                    vakata_dnd.helper = $(\"<div id='vakata-dnd'></div>\").html(html).css({\n                        \"display\"\t\t: \"block\",\n                        \"margin\"\t\t: \"0\",\n                        \"padding\"\t\t: \"0\",\n                        \"position\"\t\t: \"absolute\",\n                        \"top\"\t\t\t: \"-2000px\",\n                        \"lineHeight\"\t: \"16px\",\n                        \"zIndex\"\t\t: \"10000\"\n                    });\n                }\n                $(document).on(\"mousemove.vakata.jstree touchmove.vakata.jstree\", $.vakata.dnd.drag);\n                $(document).on(\"mouseup.vakata.jstree touchend.vakata.jstree\", $.vakata.dnd.stop);\n                return false;\n            },\n            drag : function (e) {\n                if(e.type === \"touchmove\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(!vakata_dnd.is_down) { return; }\n                if(!vakata_dnd.is_drag) {\n                    if(\n                        Math.abs(e.pageX - vakata_dnd.init_x) > (vakata_dnd.is_touch ? $.vakata.dnd.settings.threshold_touch : $.vakata.dnd.settings.threshold) ||\n                        Math.abs(e.pageY - vakata_dnd.init_y) > (vakata_dnd.is_touch ? $.vakata.dnd.settings.threshold_touch : $.vakata.dnd.settings.threshold)\n                    ) {\n                        if(vakata_dnd.helper) {\n                            vakata_dnd.helper.appendTo(document.body);\n                            vakata_dnd.helper_w = vakata_dnd.helper.outerWidth();\n                        }\n                        vakata_dnd.is_drag = true;\n                        $(vakata_dnd.target).one('click.vakata', false);\n                        /**\n                         * triggered on the document when a drag starts\n                         * @event\n                         * @plugin dnd\n                         * @name dnd_start.vakata\n                         * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                         * @param {DOM} element the DOM element being dragged\n                         * @param {jQuery} helper the helper shown next to the mouse\n                         * @param {Object} event the event that caused the start (probably mousemove)\n                         */\n                        $.vakata.dnd._trigger(\"start\", e);\n                    }\n                    else { return; }\n                }\n\n                var d  = false, w  = false,\n                    dh = false, wh = false,\n                    dw = false, ww = false,\n                    dt = false, dl = false,\n                    ht = false, hl = false;\n\n                vakata_dnd.scroll_t = 0;\n                vakata_dnd.scroll_l = 0;\n                vakata_dnd.scroll_e = false;\n                $($(e.target).parentsUntil(\"body\").addBack().get().reverse())\n                    .filter(function () {\n                        return\tthis.ownerDocument && (/^auto|scroll$/).test($(this).css(\"overflow\")) &&\n                            (this.scrollHeight > this.offsetHeight || this.scrollWidth > this.offsetWidth);\n                    })\n                    .each(function () {\n                        var t = $(this), o = t.offset();\n                        if(this.scrollHeight > this.offsetHeight) {\n                            if(o.top + t.height() - e.pageY < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_t = 1; }\n                            if(e.pageY - o.top < $.vakata.dnd.settings.scroll_proximity)\t\t\t\t{ vakata_dnd.scroll_t = -1; }\n                        }\n                        if(this.scrollWidth > this.offsetWidth) {\n                            if(o.left + t.width() - e.pageX < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_l = 1; }\n                            if(e.pageX - o.left < $.vakata.dnd.settings.scroll_proximity)\t\t\t\t{ vakata_dnd.scroll_l = -1; }\n                        }\n                        if(vakata_dnd.scroll_t || vakata_dnd.scroll_l) {\n                            vakata_dnd.scroll_e = $(this);\n                            return false;\n                        }\n                    });\n\n                if(!vakata_dnd.scroll_e) {\n                    d  = $(document); w = $(window);\n                    dh = d.height(); wh = w.height();\n                    dw = d.width(); ww = w.width();\n                    dt = d.scrollTop(); dl = d.scrollLeft();\n                    if(dh > wh && e.pageY - dt < $.vakata.dnd.settings.scroll_proximity)\t\t{ vakata_dnd.scroll_t = -1;  }\n                    if(dh > wh && wh - (e.pageY - dt) < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_t = 1; }\n                    if(dw > ww && e.pageX - dl < $.vakata.dnd.settings.scroll_proximity)\t\t{ vakata_dnd.scroll_l = -1; }\n                    if(dw > ww && ww - (e.pageX - dl) < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_l = 1; }\n                    if(vakata_dnd.scroll_t || vakata_dnd.scroll_l) {\n                        vakata_dnd.scroll_e = d;\n                    }\n                }\n                if(vakata_dnd.scroll_e) { $.vakata.dnd._scroll(true); }\n\n                if(vakata_dnd.helper) {\n                    ht = parseInt(e.pageY + $.vakata.dnd.settings.helper_top, 10);\n                    hl = parseInt(e.pageX + $.vakata.dnd.settings.helper_left, 10);\n                    if(dh && ht + 25 > dh) { ht = dh - 50; }\n                    if(dw && hl + vakata_dnd.helper_w > dw) { hl = dw - (vakata_dnd.helper_w + 2); }\n                    vakata_dnd.helper.css({\n                        left\t: hl + \"px\",\n                        top\t\t: ht + \"px\"\n                    });\n                }\n                /**\n                 * triggered on the document when a drag is in progress\n                 * @event\n                 * @plugin dnd\n                 * @name dnd_move.vakata\n                 * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                 * @param {DOM} element the DOM element being dragged\n                 * @param {jQuery} helper the helper shown next to the mouse\n                 * @param {Object} event the event that caused this to trigger (most likely mousemove)\n                 */\n                $.vakata.dnd._trigger(\"move\", e);\n                return false;\n            },\n            stop : function (e) {\n                if(e.type === \"touchend\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(vakata_dnd.is_drag) {\n                    /**\n                     * triggered on the document when a drag stops (the dragged element is dropped)\n                     * @event\n                     * @plugin dnd\n                     * @name dnd_stop.vakata\n                     * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                     * @param {DOM} element the DOM element being dragged\n                     * @param {jQuery} helper the helper shown next to the mouse\n                     * @param {Object} event the event that caused the stop\n                     */\n                    if (e.target !== vakata_dnd.target) {\n                        $(vakata_dnd.target).off('click.vakata');\n                    }\n                    $.vakata.dnd._trigger(\"stop\", e);\n                }\n                else {\n                    if(e.type === \"touchend\" && e.target === vakata_dnd.target) {\n                        var to = setTimeout(function () { $(e.target).trigger('click'); }, 100);\n                        $(e.target).one('click', function() { if(to) { clearTimeout(to); } });\n                    }\n                }\n                $.vakata.dnd._clean();\n                return false;\n            }\n        };\n    }($));\n\n    // include the dnd plugin by default\n    // $.jstree.defaults.plugins.push(\"dnd\");\n\n\n    /**\n     * ### Massload plugin\n     *\n     * Adds massload functionality to jsTree, so that multiple nodes can be loaded in a single request (only useful with lazy loading).\n     */\n\n    /**\n     * massload configuration\n     *\n     * It is possible to set this to a standard jQuery-like AJAX config.\n     * In addition to the standard jQuery ajax options here you can supply functions for `data` and `url`, the functions will be run in the current instance's scope and a param will be passed indicating which node IDs need to be loaded, the return value of those functions will be used.\n     *\n     * You can also set this to a function, that function will receive the node IDs being loaded as argument and a second param which is a function (callback) which should be called with the result.\n     *\n     * Both the AJAX and the function approach rely on the same return value - an object where the keys are the node IDs, and the value is the children of that node as an array.\n     *\n     *\t{\n     *\t\t\"id1\" : [{ \"text\" : \"Child of ID1\", \"id\" : \"c1\" }, { \"text\" : \"Another child of ID1\", \"id\" : \"c2\" }],\n     *\t\t\"id2\" : [{ \"text\" : \"Child of ID2\", \"id\" : \"c3\" }]\n     *\t}\n     *\n     * @name $.jstree.defaults.massload\n     * @plugin massload\n     */\n    $.jstree.defaults.massload = null;\n    $.jstree.plugins.massload = function (options, parent) {\n        this.init = function (el, options) {\n            this._data.massload = {};\n            parent.init.call(this, el, options);\n        };\n        this._load_nodes = function (nodes, callback, is_callback, force_reload) {\n            var s = this.settings.massload,\n                toLoad = [],\n                m = this._model.data,\n                i, j, dom;\n            if (!is_callback) {\n                for(i = 0, j = nodes.length; i < j; i++) {\n                    if(!m[nodes[i]] || ( (!m[nodes[i]].state.loaded && !m[nodes[i]].state.failed) || force_reload) ) {\n                        toLoad.push(nodes[i]);\n                        dom = this.get_node(nodes[i], true);\n                        if (dom && dom.length) {\n                            dom.addClass(\"jstree-loading\").attr('aria-busy',true);\n                        }\n                    }\n                }\n                this._data.massload = {};\n                if (toLoad.length) {\n                    if($.vakata.is_function(s)) {\n                        return s.call(this, toLoad, function (data) {\n                            var i, j;\n                            if(data) {\n                                for(i in data) {\n                                    if(data.hasOwnProperty(i)) {\n                                        this._data.massload[i] = data[i];\n                                    }\n                                }\n                            }\n                            for(i = 0, j = nodes.length; i < j; i++) {\n                                dom = this.get_node(nodes[i], true);\n                                if (dom && dom.length) {\n                                    dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                                }\n                            }\n                            parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                        }.bind(this));\n                    }\n                    if(typeof s === 'object' && s && s.url) {\n                        s = $.extend(true, {}, s);\n                        if($.vakata.is_function(s.url)) {\n                            s.url = s.url.call(this, toLoad);\n                        }\n                        if($.vakata.is_function(s.data)) {\n                            s.data = s.data.call(this, toLoad);\n                        }\n                        return $.ajax(s)\n                            .done(function (data,t,x) {\n                                var i, j;\n                                if(data) {\n                                    for(i in data) {\n                                        if(data.hasOwnProperty(i)) {\n                                            this._data.massload[i] = data[i];\n                                        }\n                                    }\n                                }\n                                for(i = 0, j = nodes.length; i < j; i++) {\n                                    dom = this.get_node(nodes[i], true);\n                                    if (dom && dom.length) {\n                                        dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                                    }\n                                }\n                                parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                            }.bind(this))\n                            .fail(function (f) {\n                                parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                            }.bind(this));\n                    }\n                }\n            }\n            return parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n        };\n        this._load_node = function (obj, callback) {\n            var data = this._data.massload[obj.id],\n                rslt = null, dom;\n            if(data) {\n                rslt = this[typeof data === 'string' ? '_append_html_data' : '_append_json_data'](\n                    obj,\n                    typeof data === 'string' ? $($.parseHTML(data)).filter(function () { return this.nodeType !== 3; }) : data,\n                    function (status) { callback.call(this, status); }\n                );\n                dom = this.get_node(obj.id, true);\n                if (dom && dom.length) {\n                    dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                }\n                delete this._data.massload[obj.id];\n                return rslt;\n            }\n            return parent._load_node.call(this, obj, callback);\n        };\n    };\n\n\n    /**\n     * ### Search plugin\n     *\n     * Adds search functionality to jsTree.\n     */\n\n    /**\n     * stores all defaults for the search plugin\n     * @name $.jstree.defaults.search\n     * @plugin search\n     */\n    $.jstree.defaults.search = {\n        /**\n         * a jQuery-like AJAX config, which jstree uses if a server should be queried for results.\n         *\n         * A `str` (which is the search string) parameter will be added with the request, an optional `inside` parameter will be added if the search is limited to a node id. The expected result is a JSON array with nodes that need to be opened so that matching nodes will be revealed.\n         * Leave this setting as `false` to not query the server. You can also set this to a function, which will be invoked in the instance's scope and receive 3 parameters - the search string, the callback to call with the array of nodes to load, and the optional node ID to limit the search to\n         * @name $.jstree.defaults.search.ajax\n         * @plugin search\n         */\n        ajax : false,\n        /**\n         * Indicates if the search should be fuzzy or not (should `chnd3` match `child node 3`). Default is `false`.\n         * @name $.jstree.defaults.search.fuzzy\n         * @plugin search\n         */\n        fuzzy : false,\n        /**\n         * Indicates if the search should be case sensitive. Default is `false`.\n         * @name $.jstree.defaults.search.case_sensitive\n         * @plugin search\n         */\n        case_sensitive : false,\n        /**\n         * Indicates if the tree should be filtered (by default) to show only matching nodes (keep in mind this can be a heavy on large trees in old browsers).\n         * This setting can be changed at runtime when calling the search method. Default is `false`.\n         * @name $.jstree.defaults.search.show_only_matches\n         * @plugin search\n         */\n        show_only_matches : false,\n        /**\n         * Indicates if the children of matched element are shown (when show_only_matches is true)\n         * This setting can be changed at runtime when calling the search method. Default is `false`.\n         * @name $.jstree.defaults.search.show_only_matches_children\n         * @plugin search\n         */\n        show_only_matches_children : false,\n        /**\n         * Indicates if all nodes opened to reveal the search result, should be closed when the search is cleared or a new search is performed. Default is `true`.\n         * @name $.jstree.defaults.search.close_opened_onclear\n         * @plugin search\n         */\n        close_opened_onclear : true,\n        /**\n         * Indicates if only leaf nodes should be included in search results. Default is `false`.\n         * @name $.jstree.defaults.search.search_leaves_only\n         * @plugin search\n         */\n        search_leaves_only : false,\n        /**\n         * If set to a function it wil be called in the instance's scope with two arguments - search string and node (where node will be every node in the structure, so use with caution).\n         * If the function returns a truthy value the node will be considered a match (it might not be displayed if search_only_leaves is set to true and the node is not a leaf). Default is `false`.\n         * @name $.jstree.defaults.search.search_callback\n         * @plugin search\n         */\n        search_callback : false\n    };\n\n    $.jstree.plugins.search = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this._data.search.str = \"\";\n            this._data.search.dom = $();\n            this._data.search.res = [];\n            this._data.search.opn = [];\n            this._data.search.som = false;\n            this._data.search.smc = false;\n            this._data.search.hdn = [];\n\n            this.element\n                .on(\"search.jstree\", function (e, data) {\n                    if(this._data.search.som && data.res.length) {\n                        var m = this._model.data, i, j, p = [], k, l;\n                        for(i = 0, j = data.res.length; i < j; i++) {\n                            if(m[data.res[i]] && !m[data.res[i]].state.hidden) {\n                                p.push(data.res[i]);\n                                p = p.concat(m[data.res[i]].parents);\n                                if(this._data.search.smc) {\n                                    for (k = 0, l = m[data.res[i]].children_d.length; k < l; k++) {\n                                        if (m[m[data.res[i]].children_d[k]] && !m[m[data.res[i]].children_d[k]].state.hidden) {\n                                            p.push(m[data.res[i]].children_d[k]);\n                                        }\n                                    }\n                                }\n                            }\n                        }\n                        p = $.vakata.array_remove_item($.vakata.array_unique(p), $.jstree.root);\n                        this._data.search.hdn = this.hide_all(true);\n                        this.show_node(p, true);\n                        this.redraw(true);\n                    }\n                }.bind(this))\n                .on(\"clear_search.jstree\", function (e, data) {\n                    if(this._data.search.som && data.res.length) {\n                        this.show_node(this._data.search.hdn, true);\n                        this.redraw(true);\n                    }\n                }.bind(this));\n        };\n        /**\n         * used to search the tree nodes for a given string\n         * @name search(str [, skip_async])\n         * @param {String} str the search string\n         * @param {Boolean} skip_async if set to true server will not be queried even if configured\n         * @param {Boolean} show_only_matches if set to true only matching nodes will be shown (keep in mind this can be very slow on large trees or old browsers)\n         * @param {mixed} inside an optional node to whose children to limit the search\n         * @param {Boolean} append if set to true the results of this search are appended to the previous search\n         * @plugin search\n         * @trigger search.jstree\n         */\n        this.search = function (str, skip_async, show_only_matches, inside, append, show_only_matches_children) {\n            if(str === false || $.vakata.trim(str.toString()) === \"\") {\n                return this.clear_search();\n            }\n            inside = this.get_node(inside);\n            inside = inside && (inside.id || inside.id === 0) ? inside.id : null;\n            str = str.toString();\n            var s = this.settings.search,\n                a = s.ajax ? s.ajax : false,\n                m = this._model.data,\n                f = null,\n                r = [],\n                p = [], i, j;\n            if(this._data.search.res.length && !append) {\n                this.clear_search();\n            }\n            if(show_only_matches === undefined) {\n                show_only_matches = s.show_only_matches;\n            }\n            if(show_only_matches_children === undefined) {\n                show_only_matches_children = s.show_only_matches_children;\n            }\n            if(!skip_async && a !== false) {\n                if($.vakata.is_function(a)) {\n                    return a.call(this, str, function (d) {\n                        if(d && d.d) { d = d.d; }\n                        this._load_nodes(!$.vakata.is_array(d) ? [] : $.vakata.array_unique(d), function () {\n                            this.search(str, true, show_only_matches, inside, append, show_only_matches_children);\n                        });\n                    }.bind(this), inside);\n                }\n                else {\n                    a = $.extend({}, a);\n                    if(!a.data) { a.data = {}; }\n                    a.data.str = str;\n                    if(inside) {\n                        a.data.inside = inside;\n                    }\n                    if (this._data.search.lastRequest) {\n                        this._data.search.lastRequest.abort();\n                    }\n                    this._data.search.lastRequest = $.ajax(a)\n                        .fail(function () {\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'search', 'id' : 'search_01', 'reason' : 'Could not load search parents', 'data' : JSON.stringify(a) };\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                        }.bind(this))\n                        .done(function (d) {\n                            if(d && d.d) { d = d.d; }\n                            this._load_nodes(!$.vakata.is_array(d) ? [] : $.vakata.array_unique(d), function () {\n                                this.search(str, true, show_only_matches, inside, append, show_only_matches_children);\n                            });\n                        }.bind(this));\n                    return this._data.search.lastRequest;\n                }\n            }\n            if(!append) {\n                this._data.search.str = str;\n                this._data.search.dom = $();\n                this._data.search.res = [];\n                this._data.search.opn = [];\n                this._data.search.som = show_only_matches;\n                this._data.search.smc = show_only_matches_children;\n            }\n\n            f = new $.vakata.search(str, true, { caseSensitive : s.case_sensitive, fuzzy : s.fuzzy });\n            $.each(m[inside ? inside : $.jstree.root].children_d, function (ii, i) {\n                var v = m[i];\n                if(v.text && !v.state.hidden && (!s.search_leaves_only || (v.state.loaded && v.children.length === 0)) && ( (s.search_callback && s.search_callback.call(this, str, v)) || (!s.search_callback && f.search(v.text).isMatch) ) ) {\n                    r.push(i);\n                    p = p.concat(v.parents);\n                }\n            });\n            if(r.length) {\n                p = $.vakata.array_unique(p);\n                for(i = 0, j = p.length; i < j; i++) {\n                    if(p[i] !== $.jstree.root && m[p[i]] && this.open_node(p[i], null, 0) === true) {\n                        this._data.search.opn.push(p[i]);\n                    }\n                }\n                if(!append) {\n                    this._data.search.dom = $(this.element[0].querySelectorAll('#' + $.map(r, function (v) { return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&'); }).join(', #')));\n                    this._data.search.res = r;\n                }\n                else {\n                    this._data.search.dom = this._data.search.dom.add($(this.element[0].querySelectorAll('#' + $.map(r, function (v) { return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&'); }).join(', #'))));\n                    this._data.search.res = $.vakata.array_unique(this._data.search.res.concat(r));\n                }\n                this._data.search.dom.children(\".jstree-anchor\").addClass('jstree-search');\n            }\n            /**\n             * triggered after search is complete\n             * @event\n             * @name search.jstree\n             * @param {jQuery} nodes a jQuery collection of matching nodes\n             * @param {String} str the search string\n             * @param {Array} res a collection of objects represeing the matching nodes\n             * @plugin search\n             */\n            this.trigger('search', { nodes : this._data.search.dom, str : str, res : this._data.search.res, show_only_matches : show_only_matches });\n        };\n        /**\n         * used to clear the last search (removes classes and shows all nodes if filtering is on)\n         * @name clear_search()\n         * @plugin search\n         * @trigger clear_search.jstree\n         */\n        this.clear_search = function () {\n            if(this.settings.search.close_opened_onclear) {\n                this.close_node(this._data.search.opn, 0);\n            }\n            /**\n             * triggered after search is complete\n             * @event\n             * @name clear_search.jstree\n             * @param {jQuery} nodes a jQuery collection of matching nodes (the result from the last search)\n             * @param {String} str the search string (the last search string)\n             * @param {Array} res a collection of objects represeing the matching nodes (the result from the last search)\n             * @plugin search\n             */\n            this.trigger('clear_search', { 'nodes' : this._data.search.dom, str : this._data.search.str, res : this._data.search.res });\n            if(this._data.search.res.length) {\n                this._data.search.dom = $(this.element[0].querySelectorAll('#' + $.map(this._data.search.res, function (v) {\n                    return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&');\n                }).join(', #')));\n                this._data.search.dom.children(\".jstree-anchor\").removeClass(\"jstree-search\");\n            }\n            this._data.search.str = \"\";\n            this._data.search.res = [];\n            this._data.search.opn = [];\n            this._data.search.dom = $();\n        };\n\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                if($.inArray(obj.id, this._data.search.res) !== -1) {\n                    var i, j, tmp = null;\n                    for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                        if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                            tmp = obj.childNodes[i];\n                            break;\n                        }\n                    }\n                    if(tmp) {\n                        tmp.className += ' jstree-search';\n                    }\n                }\n            }\n            return obj;\n        };\n    };\n\n    // helpers\n    (function ($) {\n        // from http://kiro.me/projects/fuse.html\n        $.vakata.search = function(pattern, txt, options) {\n            options = options || {};\n            options = $.extend({}, $.vakata.search.defaults, options);\n            if(options.fuzzy !== false) {\n                options.fuzzy = true;\n            }\n            pattern = options.caseSensitive ? pattern : pattern.toLowerCase();\n            var MATCH_LOCATION\t= options.location,\n                MATCH_DISTANCE\t= options.distance,\n                MATCH_THRESHOLD\t= options.threshold,\n                patternLen = pattern.length,\n                matchmask, pattern_alphabet, match_bitapScore, search;\n            if(patternLen > 32) {\n                options.fuzzy = false;\n            }\n            if(options.fuzzy) {\n                matchmask = 1 << (patternLen - 1);\n                pattern_alphabet = (function () {\n                    var mask = {},\n                        i = 0;\n                    for (i = 0; i < patternLen; i++) {\n                        mask[pattern.charAt(i)] = 0;\n                    }\n                    for (i = 0; i < patternLen; i++) {\n                        mask[pattern.charAt(i)] |= 1 << (patternLen - i - 1);\n                    }\n                    return mask;\n                }());\n                match_bitapScore = function (e, x) {\n                    var accuracy = e / patternLen,\n                        proximity = Math.abs(MATCH_LOCATION - x);\n                    if(!MATCH_DISTANCE) {\n                        return proximity ? 1.0 : accuracy;\n                    }\n                    return accuracy + (proximity / MATCH_DISTANCE);\n                };\n            }\n            search = function (text) {\n                text = options.caseSensitive ? text.toString() : text.toString().toLowerCase();\n                if(pattern === text || text.indexOf(pattern) !== -1) {\n                    return {\n                        isMatch: true,\n                        score: 0\n                    };\n                }\n                if(!options.fuzzy) {\n                    return {\n                        isMatch: false,\n                        score: 1\n                    };\n                }\n                var i, j,\n                    textLen = text.length,\n                    scoreThreshold = MATCH_THRESHOLD,\n                    bestLoc = text.indexOf(pattern, MATCH_LOCATION),\n                    binMin, binMid,\n                    binMax = patternLen + textLen,\n                    lastRd, start, finish, rd, charMatch,\n                    score = 1,\n                    locations = [];\n                if (bestLoc !== -1) {\n                    scoreThreshold = Math.min(match_bitapScore(0, bestLoc), scoreThreshold);\n                    bestLoc = text.lastIndexOf(pattern, MATCH_LOCATION + patternLen);\n                    if (bestLoc !== -1) {\n                        scoreThreshold = Math.min(match_bitapScore(0, bestLoc), scoreThreshold);\n                    }\n                }\n                bestLoc = -1;\n                for (i = 0; i < patternLen; i++) {\n                    binMin = 0;\n                    binMid = binMax;\n                    while (binMin < binMid) {\n                        if (match_bitapScore(i, MATCH_LOCATION + binMid) <= scoreThreshold) {\n                            binMin = binMid;\n                        } else {\n                            binMax = binMid;\n                        }\n                        binMid = Math.floor((binMax - binMin) / 2 + binMin);\n                    }\n                    binMax = binMid;\n                    start = Math.max(1, MATCH_LOCATION - binMid + 1);\n                    finish = Math.min(MATCH_LOCATION + binMid, textLen) + patternLen;\n                    rd = new Array(finish + 2);\n                    rd[finish + 1] = (1 << i) - 1;\n                    for (j = finish; j >= start; j--) {\n                        charMatch = pattern_alphabet[text.charAt(j - 1)];\n                        if (i === 0) {\n                            rd[j] = ((rd[j + 1] << 1) | 1) & charMatch;\n                        } else {\n                            rd[j] = ((rd[j + 1] << 1) | 1) & charMatch | (((lastRd[j + 1] | lastRd[j]) << 1) | 1) | lastRd[j + 1];\n                        }\n                        if (rd[j] & matchmask) {\n                            score = match_bitapScore(i, j - 1);\n                            if (score <= scoreThreshold) {\n                                scoreThreshold = score;\n                                bestLoc = j - 1;\n                                locations.push(bestLoc);\n                                if (bestLoc > MATCH_LOCATION) {\n                                    start = Math.max(1, 2 * MATCH_LOCATION - bestLoc);\n                                } else {\n                                    break;\n                                }\n                            }\n                        }\n                    }\n                    if (match_bitapScore(i + 1, MATCH_LOCATION) > scoreThreshold) {\n                        break;\n                    }\n                    lastRd = rd;\n                }\n                return {\n                    isMatch: bestLoc >= 0,\n                    score: score\n                };\n            };\n            return txt === true ? { 'search' : search } : search(txt);\n        };\n        $.vakata.search.defaults = {\n            location : 0,\n            distance : 100,\n            threshold : 0.6,\n            fuzzy : false,\n            caseSensitive : false\n        };\n    }($));\n\n    // include the search plugin by default\n    // $.jstree.defaults.plugins.push(\"search\");\n\n\n    /**\n     * ### Sort plugin\n     *\n     * Automatically sorts all siblings in the tree according to a sorting function.\n     */\n\n    /**\n     * the settings function used to sort the nodes.\n     * It is executed in the tree's context, accepts two nodes as arguments and should return `1` or `-1`.\n     * @name $.jstree.defaults.sort\n     * @plugin sort\n     */\n    $.jstree.defaults.sort = function (a, b) {\n        //return this.get_type(a) === this.get_type(b) ? (this.get_text(a) > this.get_text(b) ? 1 : -1) : this.get_type(a) >= this.get_type(b);\n        return this.get_text(a) > this.get_text(b) ? 1 : -1;\n    };\n    $.jstree.plugins.sort = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            this.element\n                .on(\"model.jstree\", function (e, data) {\n                    this.sort(data.parent, true);\n                }.bind(this))\n                .on(\"rename_node.jstree create_node.jstree\", function (e, data) {\n                    this.sort(data.parent || data.node.parent, false);\n                    this.redraw_node(data.parent || data.node.parent, true);\n                }.bind(this))\n                .on(\"move_node.jstree copy_node.jstree\", function (e, data) {\n                    this.sort(data.parent, false);\n                    this.redraw_node(data.parent, true);\n                }.bind(this));\n        };\n        /**\n         * used to sort a node's children\n         * @private\n         * @name sort(obj [, deep])\n         * @param  {mixed} obj the node\n         * @param {Boolean} deep if set to `true` nodes are sorted recursively.\n         * @plugin sort\n         * @trigger search.jstree\n         */\n        this.sort = function (obj, deep) {\n            var i, j;\n            obj = this.get_node(obj);\n            if(obj && obj.children && obj.children.length) {\n                obj.children.sort(this.settings.sort.bind(this));\n                if(deep) {\n                    for(i = 0, j = obj.children_d.length; i < j; i++) {\n                        this.sort(obj.children_d[i], false);\n                    }\n                }\n            }\n        };\n    };\n\n    // include the sort plugin by default\n    // $.jstree.defaults.plugins.push(\"sort\");\n\n    /**\n     * ### State plugin\n     *\n     * Saves the state of the tree (selected nodes, opened nodes) on the user's computer using available options (localStorage, cookies, etc)\n     */\n\n    var to = false;\n    /**\n     * stores all defaults for the state plugin\n     * @name $.jstree.defaults.state\n     * @plugin state\n     */\n    $.jstree.defaults.state = {\n        /**\n         * A string for the key to use when saving the current tree (change if using multiple trees in your project). Defaults to `jstree`.\n         * @name $.jstree.defaults.state.key\n         * @plugin state\n         */\n        key\t\t: 'jstree',\n        /**\n         * A space separated list of events that trigger a state save. Defaults to `changed.jstree open_node.jstree close_node.jstree`.\n         * @name $.jstree.defaults.state.events\n         * @plugin state\n         */\n        events\t: 'changed.jstree open_node.jstree close_node.jstree check_node.jstree uncheck_node.jstree',\n        /**\n         * Time in milliseconds after which the state will expire. Defaults to 'false' meaning - no expire.\n         * @name $.jstree.defaults.state.ttl\n         * @plugin state\n         */\n        ttl\t\t: false,\n        /**\n         * A function that will be executed prior to restoring state with one argument - the state object. Can be used to clear unwanted parts of the state.\n         * @name $.jstree.defaults.state.filter\n         * @plugin state\n         */\n        filter\t: false,\n        /**\n         * Should loaded nodes be restored (setting this to true means that it is possible that the whole tree will be loaded for some users - use with caution). Defaults to `false`\n         * @name $.jstree.defaults.state.preserve_loaded\n         * @plugin state\n         */\n        preserve_loaded : false\n    };\n    $.jstree.plugins.state = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            var bind = function () {\n                this.element.on(this.settings.state.events, function () {\n                    if(to) { clearTimeout(to); }\n                    to = setTimeout(function () { this.save_state(); }.bind(this), 100);\n                }.bind(this));\n                /**\n                 * triggered when the state plugin is finished restoring the state (and immediately after ready if there is no state to restore).\n                 * @event\n                 * @name state_ready.jstree\n                 * @plugin state\n                 */\n                this.trigger('state_ready');\n            }.bind(this);\n            this.element\n                .on(\"ready.jstree\", function (e, data) {\n                    this.element.one(\"restore_state.jstree\", bind);\n                    if(!this.restore_state()) { bind(); }\n                }.bind(this));\n        };\n        /**\n         * save the state\n         * @name save_state()\n         * @plugin state\n         */\n        this.save_state = function () {\n            var tm = this.get_state();\n            if (!this.settings.state.preserve_loaded) {\n                delete tm.core.loaded;\n            }\n            var st = { 'state' : tm, 'ttl' : this.settings.state.ttl, 'sec' : +(new Date()) };\n            $.vakata.storage.set(this.settings.state.key, JSON.stringify(st));\n        };\n        /**\n         * restore the state from the user's computer\n         * @name restore_state()\n         * @plugin state\n         */\n        this.restore_state = function () {\n            var k = $.vakata.storage.get(this.settings.state.key);\n            if(!!k) { try { k = JSON.parse(k); } catch(ex) { return false; } }\n            if(!!k && k.ttl && k.sec && +(new Date()) - k.sec > k.ttl) { return false; }\n            if(!!k && k.state) { k = k.state; }\n            if(!!k && $.vakata.is_function(this.settings.state.filter)) { k = this.settings.state.filter.call(this, k); }\n            if(!!k) {\n                if (!this.settings.state.preserve_loaded) {\n                    delete k.core.loaded;\n                }\n                this.element.one(\"set_state.jstree\", function (e, data) { data.instance.trigger('restore_state', { 'state' : $.extend(true, {}, k) }); });\n                this.set_state(k);\n                return true;\n            }\n            return false;\n        };\n        /**\n         * clear the state on the user's computer\n         * @name clear_state()\n         * @plugin state\n         */\n        this.clear_state = function () {\n            return $.vakata.storage.del(this.settings.state.key);\n        };\n    };\n\n    (function ($, undefined) {\n        $.vakata.storage = {\n            // simply specifying the functions in FF throws an error\n            set : function (key, val) { return window.localStorage.setItem(key, val); },\n            get : function (key) { return window.localStorage.getItem(key); },\n            del : function (key) { return window.localStorage.removeItem(key); }\n        };\n    }($));\n\n    // include the state plugin by default\n    // $.jstree.defaults.plugins.push(\"state\");\n\n    /**\n     * ### Types plugin\n     *\n     * Makes it possible to add predefined types for groups of nodes, which make it possible to easily control nesting rules and icon for each group.\n     */\n\n    /**\n     * An object storing all types as key value pairs, where the key is the type name and the value is an object that could contain following keys (all optional).\n     *\n     * * `max_children` the maximum number of immediate children this node type can have. Do not specify or set to `-1` for unlimited.\n     * * `max_depth` the maximum number of nesting this node type can have. A value of `1` would mean that the node can have children, but no grandchildren. Do not specify or set to `-1` for unlimited.\n     * * `valid_children` an array of node type strings, that nodes of this type can have as children. Do not specify or set to `-1` for no limits.\n     * * `icon` a string - can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class. Omit to use the default icon from your theme.\n     * * `li_attr` an object of values which will be used to add HTML attributes on the resulting LI DOM node (merged with the node's own data)\n     * * `a_attr` an object of values which will be used to add HTML attributes on the resulting A DOM node (merged with the node's own data)\n     *\n     * There are two predefined types:\n     *\n     * * `#` represents the root of the tree, for example `max_children` would control the maximum number of root nodes.\n     * * `default` represents the default node - any settings here will be applied to all nodes that do not have a type specified.\n     *\n     * @name $.jstree.defaults.types\n     * @plugin types\n     */\n    $.jstree.defaults.types = {\n        'default' : {}\n    };\n    $.jstree.defaults.types[$.jstree.root] = {};\n\n    $.jstree.plugins.types = function (options, parent) {\n        this.init = function (el, options) {\n            var i, j;\n            if(options && options.types && options.types['default']) {\n                for(i in options.types) {\n                    if(i !== \"default\" && i !== $.jstree.root && options.types.hasOwnProperty(i)) {\n                        for(j in options.types['default']) {\n                            if(options.types['default'].hasOwnProperty(j) && options.types[i][j] === undefined) {\n                                options.types[i][j] = options.types['default'][j];\n                            }\n                        }\n                    }\n                }\n            }\n            parent.init.call(this, el, options);\n            this._model.data[$.jstree.root].type = $.jstree.root;\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            parent.refresh.call(this, skip_loading, forget_state);\n            this._model.data[$.jstree.root].type = $.jstree.root;\n        };\n        this.bind = function () {\n            this.element\n                .on('model.jstree', function (e, data) {\n                    var m = this._model.data,\n                        dpc = data.nodes,\n                        t = this.settings.types,\n                        i, j, c = 'default', k;\n                    for(i = 0, j = dpc.length; i < j; i++) {\n                        c = 'default';\n                        if(m[dpc[i]].original && m[dpc[i]].original.type && t[m[dpc[i]].original.type]) {\n                            c = m[dpc[i]].original.type;\n                        }\n                        if(m[dpc[i]].data && m[dpc[i]].data.jstree && m[dpc[i]].data.jstree.type && t[m[dpc[i]].data.jstree.type]) {\n                            c = m[dpc[i]].data.jstree.type;\n                        }\n                        m[dpc[i]].type = c;\n                        if(m[dpc[i]].icon === true && t[c].icon !== undefined) {\n                            m[dpc[i]].icon = t[c].icon;\n                        }\n                        if(t[c].li_attr !== undefined && typeof t[c].li_attr === 'object') {\n                            for (k in t[c].li_attr) {\n                                if (t[c].li_attr.hasOwnProperty(k)) {\n                                    if (k === 'id') {\n                                        continue;\n                                    }\n                                    else if (m[dpc[i]].li_attr[k] === undefined) {\n                                        m[dpc[i]].li_attr[k] = t[c].li_attr[k];\n                                    }\n                                    else if (k === 'class') {\n                                        m[dpc[i]].li_attr['class'] = t[c].li_attr['class'] + ' ' + m[dpc[i]].li_attr['class'];\n                                    }\n                                }\n                            }\n                        }\n                        if(t[c].a_attr !== undefined && typeof t[c].a_attr === 'object') {\n                            for (k in t[c].a_attr) {\n                                if (t[c].a_attr.hasOwnProperty(k)) {\n                                    if (k === 'id') {\n                                        continue;\n                                    }\n                                    else if (m[dpc[i]].a_attr[k] === undefined) {\n                                        m[dpc[i]].a_attr[k] = t[c].a_attr[k];\n                                    }\n                                    else if (k === 'href' && m[dpc[i]].a_attr[k] === '#') {\n                                        m[dpc[i]].a_attr['href'] = t[c].a_attr['href'];\n                                    }\n                                    else if (k === 'class') {\n                                        m[dpc[i]].a_attr['class'] = t[c].a_attr['class'] + ' ' + m[dpc[i]].a_attr['class'];\n                                    }\n                                }\n                            }\n                        }\n                    }\n                    m[$.jstree.root].type = $.jstree.root;\n                }.bind(this));\n            parent.bind.call(this);\n        };\n        this.get_json = function (obj, options, flat) {\n            var i, j,\n                m = this._model.data,\n                opt = options ? $.extend(true, {}, options, {no_id:false}) : {},\n                tmp = parent.get_json.call(this, obj, opt, flat);\n            if(tmp === false) { return false; }\n            if($.vakata.is_array(tmp)) {\n                for(i = 0, j = tmp.length; i < j; i++) {\n                    tmp[i].type = (tmp[i].id || tmp[i].id === 0) && m[tmp[i].id] && m[tmp[i].id].type ? m[tmp[i].id].type : \"default\";\n                    if(options && options.no_id) {\n                        delete tmp[i].id;\n                        if(tmp[i].li_attr && tmp[i].li_attr.id) {\n                            delete tmp[i].li_attr.id;\n                        }\n                        if(tmp[i].a_attr && tmp[i].a_attr.id) {\n                            delete tmp[i].a_attr.id;\n                        }\n                    }\n                }\n            }\n            else {\n                tmp.type = (tmp.id || tmp.id === 0) && m[tmp.id] && m[tmp.id].type ? m[tmp.id].type : \"default\";\n                if(options && options.no_id) {\n                    tmp = this._delete_ids(tmp);\n                }\n            }\n            return tmp;\n        };\n        this._delete_ids = function (tmp) {\n            if($.vakata.is_array(tmp)) {\n                for(var i = 0, j = tmp.length; i < j; i++) {\n                    tmp[i] = this._delete_ids(tmp[i]);\n                }\n                return tmp;\n            }\n            delete tmp.id;\n            if(tmp.li_attr && tmp.li_attr.id) {\n                delete tmp.li_attr.id;\n            }\n            if(tmp.a_attr && tmp.a_attr.id) {\n                delete tmp.a_attr.id;\n            }\n            if(tmp.children && $.vakata.is_array(tmp.children)) {\n                tmp.children = this._delete_ids(tmp.children);\n            }\n            return tmp;\n        };\n        this.check = function (chk, obj, par, pos, more) {\n            if(parent.check.call(this, chk, obj, par, pos, more) === false) { return false; }\n            obj = obj && (obj.id || obj.id === 0) ? obj : this.get_node(obj);\n            par = par && (par.id || par.id === 0) ? par : this.get_node(par);\n            var m = obj && (obj.id || obj.id === 0) ? (more && more.origin ? more.origin : $.jstree.reference(obj.id)) : null, tmp, d, i, j;\n            m = m && m._model && m._model.data ? m._model.data : null;\n            switch(chk) {\n                case \"create_node\":\n                case \"move_node\":\n                case \"copy_node\":\n                    if(chk !== 'move_node' || $.inArray(obj.id, par.children) === -1) {\n                        tmp = this.get_rules(par);\n                        if(tmp.max_children !== undefined && tmp.max_children !== -1 && tmp.max_children === par.children.length) {\n                            this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_01', 'reason' : 'max_children prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && (obj.id || obj.id === 0) ? obj.id : false, 'par' : par && (par.id || par.id === 0) ? par.id : false }) };\n                            return false;\n                        }\n                        if(tmp.valid_children !== undefined && tmp.valid_children !== -1 && $.inArray((obj.type || 'default'), tmp.valid_children) === -1) {\n                            this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_02', 'reason' : 'valid_children prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && (obj.id || obj.id === 0) ? obj.id : false, 'par' : par && (par.id || par.id === 0) ? par.id : false }) };\n                            return false;\n                        }\n                        if(m && obj.children_d && obj.parents) {\n                            d = 0;\n                            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                                d = Math.max(d, m[obj.children_d[i]].parents.length);\n                            }\n                            d = d - obj.parents.length + 1;\n                        }\n                        if(d <= 0 || d === undefined) { d = 1; }\n                        do {\n                            if(tmp.max_depth !== undefined && tmp.max_depth !== -1 && tmp.max_depth < d) {\n                                this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_03', 'reason' : 'max_depth prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && (obj.id || obj.id === 0) ? obj.id : false, 'par' : par && (par.id || par.id === 0) ? par.id : false }) };\n                                return false;\n                            }\n                            par = this.get_node(par.parent);\n                            tmp = this.get_rules(par);\n                            d++;\n                        } while(par);\n                    }\n                    break;\n            }\n            return true;\n        };\n        /**\n         * used to retrieve the type settings object for a node\n         * @name get_rules(obj)\n         * @param {mixed} obj the node to find the rules for\n         * @return {Object}\n         * @plugin types\n         */\n        this.get_rules = function (obj) {\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var tmp = this.get_type(obj, true);\n            if(tmp.max_depth === undefined) { tmp.max_depth = -1; }\n            if(tmp.max_children === undefined) { tmp.max_children = -1; }\n            if(tmp.valid_children === undefined) { tmp.valid_children = -1; }\n            return tmp;\n        };\n        /**\n         * used to retrieve the type string or settings object for a node\n         * @name get_type(obj [, rules])\n         * @param {mixed} obj the node to find the rules for\n         * @param {Boolean} rules if set to `true` instead of a string the settings object will be returned\n         * @return {String|Object}\n         * @plugin types\n         */\n        this.get_type = function (obj, rules) {\n            obj = this.get_node(obj);\n            return (!obj) ? false : ( rules ? $.extend({ 'type' : obj.type }, this.settings.types[obj.type]) : obj.type);\n        };\n        /**\n         * used to change a node's type\n         * @name set_type(obj, type)\n         * @param {mixed} obj the node to change\n         * @param {String} type the new type\n         * @plugin types\n         */\n        this.set_type = function (obj, type) {\n            var m = this._model.data, t, t1, t2, old_type, old_icon, k, d, a;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_type(obj[t1], type);\n                }\n                return true;\n            }\n            t = this.settings.types;\n            obj = this.get_node(obj);\n            if(!t[type] || !obj) { return false; }\n            d = this.get_node(obj, true);\n            if (d && d.length) {\n                a = d.children('.jstree-anchor');\n            }\n            old_type = obj.type;\n            old_icon = this.get_icon(obj);\n            obj.type = type;\n            if(old_icon === true || !t[old_type] || (t[old_type].icon !== undefined && old_icon === t[old_type].icon)) {\n                this.set_icon(obj, t[type].icon !== undefined ? t[type].icon : true);\n            }\n\n            // remove old type props\n            if(t[old_type] && t[old_type].li_attr !== undefined && typeof t[old_type].li_attr === 'object') {\n                for (k in t[old_type].li_attr) {\n                    if (t[old_type].li_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].li_attr['class'] = (m[obj.id].li_attr['class'] || '').replace(t[old_type].li_attr[k], '');\n                            if (d) { d.removeClass(t[old_type].li_attr[k]); }\n                        }\n                        else if (m[obj.id].li_attr[k] === t[old_type].li_attr[k]) {\n                            m[obj.id].li_attr[k] = null;\n                            if (d) { d.removeAttr(k); }\n                        }\n                    }\n                }\n            }\n            if(t[old_type] && t[old_type].a_attr !== undefined && typeof t[old_type].a_attr === 'object') {\n                for (k in t[old_type].a_attr) {\n                    if (t[old_type].a_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].a_attr['class'] = (m[obj.id].a_attr['class'] || '').replace(t[old_type].a_attr[k], '');\n                            if (a) { a.removeClass(t[old_type].a_attr[k]); }\n                        }\n                        else if (m[obj.id].a_attr[k] === t[old_type].a_attr[k]) {\n                            if (k === 'href') {\n                                m[obj.id].a_attr[k] = '#';\n                                if (a) { a.attr('href', '#'); }\n                            }\n                            else {\n                                delete m[obj.id].a_attr[k];\n                                if (a) { a.removeAttr(k); }\n                            }\n                        }\n                    }\n                }\n            }\n\n            // add new props\n            if(t[type].li_attr !== undefined && typeof t[type].li_attr === 'object') {\n                for (k in t[type].li_attr) {\n                    if (t[type].li_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (m[obj.id].li_attr[k] === undefined) {\n                            m[obj.id].li_attr[k] = t[type].li_attr[k];\n                            if (d) {\n                                if (k === 'class') {\n                                    d.addClass(t[type].li_attr[k]);\n                                }\n                                else {\n                                    d.attr(k, t[type].li_attr[k]);\n                                }\n                            }\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].li_attr['class'] = t[type].li_attr[k] + ' ' + m[obj.id].li_attr['class'];\n                            if (d) { d.addClass(t[type].li_attr[k]); }\n                        }\n                    }\n                }\n            }\n            if(t[type].a_attr !== undefined && typeof t[type].a_attr === 'object') {\n                for (k in t[type].a_attr) {\n                    if (t[type].a_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (m[obj.id].a_attr[k] === undefined) {\n                            m[obj.id].a_attr[k] = t[type].a_attr[k];\n                            if (a) {\n                                if (k === 'class') {\n                                    a.addClass(t[type].a_attr[k]);\n                                }\n                                else {\n                                    a.attr(k, t[type].a_attr[k]);\n                                }\n                            }\n                        }\n                        else if (k === 'href' && m[obj.id].a_attr[k] === '#') {\n                            m[obj.id].a_attr['href'] = t[type].a_attr['href'];\n                            if (a) { a.attr('href', t[type].a_attr['href']); }\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].a_attr['class'] = t[type].a_attr['class'] + ' ' + m[obj.id].a_attr['class'];\n                            if (a) { a.addClass(t[type].a_attr[k]); }\n                        }\n                    }\n                }\n            }\n\n            return true;\n        };\n    };\n    // include the types plugin by default\n    // $.jstree.defaults.plugins.push(\"types\");\n\n\n    /**\n     * ### Unique plugin\n     *\n     * Enforces that no nodes with the same name can coexist as siblings.\n     */\n\n    /**\n     * stores all defaults for the unique plugin\n     * @name $.jstree.defaults.unique\n     * @plugin unique\n     */\n    $.jstree.defaults.unique = {\n        /**\n         * Indicates if the comparison should be case sensitive. Default is `false`.\n         * @name $.jstree.defaults.unique.case_sensitive\n         * @plugin unique\n         */\n        case_sensitive : false,\n        /**\n         * Indicates if white space should be trimmed before the comparison. Default is `false`.\n         * @name $.jstree.defaults.unique.trim_whitespace\n         * @plugin unique\n         */\n        trim_whitespace : false,\n        /**\n         * A callback executed in the instance's scope when a new node is created with no name and a node with the default name already exists, the two arguments are the conflicting name and the counter. The default will produce results like `New node (2)`.\n         * @name $.jstree.defaults.unique.duplicate\n         * @plugin unique\n         */\n        duplicate : function (name, counter) {\n            return name + ' (' + counter + ')';\n        }\n    };\n\n    $.jstree.plugins.unique = function (options, parent) {\n        this.check = function (chk, obj, par, pos, more) {\n            if(parent.check.call(this, chk, obj, par, pos, more) === false) { return false; }\n            obj = obj && (obj.id || obj.id === 0) ? obj : this.get_node(obj);\n            par = par && (par.id || par.id === 0) ? par : this.get_node(par);\n            if(!par || !par.children) { return true; }\n            var n = chk === \"rename_node\" ? pos : obj.text,\n                c = [],\n                s = this.settings.unique.case_sensitive,\n                w = this.settings.unique.trim_whitespace,\n                m = this._model.data, i, j, t;\n            for(i = 0, j = par.children.length; i < j; i++) {\n                t = m[par.children[i]].text;\n                if (!s) {\n                    t = t.toLowerCase();\n                }\n                if (w) {\n                    t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                }\n                c.push(t);\n            }\n            if(!s) { n = n.toLowerCase(); }\n            if (w) { n = n.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, ''); }\n            switch(chk) {\n                case \"delete_node\":\n                    return true;\n                case \"rename_node\":\n                    t = obj.text || '';\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                    i = ($.inArray(n, c) === -1 || (obj.text && t === n));\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_01', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && (obj.id || obj.id === 0) ? obj.id : false, 'par' : par && (par.id || par.id === 0) ? par.id : false }) };\n                    }\n                    return i;\n                case \"create_node\":\n                    i = ($.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_04', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && (obj.id || obj.id === 0) ? obj.id : false, 'par' : par && (par.id || par.id === 0) ? par.id : false }) };\n                    }\n                    return i;\n                case \"copy_node\":\n                    i = ($.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_02', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && (obj.id || obj.id === 0) ? obj.id : false, 'par' : par && (par.id || par.id === 0) ? par.id : false }) };\n                    }\n                    return i;\n                case \"move_node\":\n                    i = ( (obj.parent === par.id && (!more || !more.is_multi)) || $.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_03', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && (obj.id || obj.id === 0) ? obj.id : false, 'par' : par && (par.id || par.id === 0) ? par.id : false }) };\n                    }\n                    return i;\n            }\n            return true;\n        };\n        this.create_node = function (par, node, pos, callback, is_loaded) {\n            if(!node || (typeof node === 'object' && node.text === undefined)) {\n                if(par === null) {\n                    par = $.jstree.root;\n                }\n                par = this.get_node(par);\n                if(!par) {\n                    return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n                }\n                pos = pos === undefined ? \"last\" : pos;\n                if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                    return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n                }\n                if(!node) { node = {}; }\n                var tmp, n, dpc, i, j, m = this._model.data, s = this.settings.unique.case_sensitive, w = this.settings.unique.trim_whitespace, cb = this.settings.unique.duplicate, t;\n                n = tmp = this.get_string('New node');\n                dpc = [];\n                for(i = 0, j = par.children.length; i < j; i++) {\n                    t = m[par.children[i]].text;\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                    dpc.push(t);\n                }\n                i = 1;\n                t = n;\n                if (!s) {\n                    t = t.toLowerCase();\n                }\n                if (w) {\n                    t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                }\n                while($.inArray(t, dpc) !== -1) {\n                    n = cb.call(this, tmp, (++i)).toString();\n                    t = n;\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                }\n                node.text = n;\n            }\n            return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n        };\n    };\n\n    // include the unique plugin by default\n    // $.jstree.defaults.plugins.push(\"unique\");\n\n\n    /**\n     * ### Wholerow plugin\n     *\n     * Makes each node appear block level. Making selection easier. May cause slow down for large trees in old browsers.\n     */\n\n    var div = document.createElement('DIV');\n    div.setAttribute('unselectable','on');\n    div.setAttribute('role','presentation');\n    div.className = 'jstree-wholerow';\n    div.innerHTML = '&#160;';\n    $.jstree.plugins.wholerow = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this.element\n                .on('ready.jstree set_state.jstree', function () {\n                    this.hide_dots();\n                }.bind(this))\n                .on(\"init.jstree loading.jstree ready.jstree\", function () {\n                    //div.style.height = this._data.core.li_height + 'px';\n                    this.get_container_ul().addClass('jstree-wholerow-ul');\n                }.bind(this))\n                .on(\"deselect_all.jstree\", function (e, data) {\n                    this.element.find('.jstree-wholerow-clicked').removeClass('jstree-wholerow-clicked');\n                }.bind(this))\n                .on(\"changed.jstree\", function (e, data) {\n                    this.element.find('.jstree-wholerow-clicked').removeClass('jstree-wholerow-clicked');\n                    var tmp = false, i, j;\n                    for(i = 0, j = data.selected.length; i < j; i++) {\n                        tmp = this.get_node(data.selected[i], true);\n                        if(tmp && tmp.length) {\n                            tmp.children('.jstree-wholerow').addClass('jstree-wholerow-clicked');\n                        }\n                    }\n                }.bind(this))\n                .on(\"open_node.jstree\", function (e, data) {\n                    this.get_node(data.node, true).find('.jstree-clicked').parent().children('.jstree-wholerow').addClass('jstree-wholerow-clicked');\n                }.bind(this))\n                .on(\"hover_node.jstree dehover_node.jstree\", function (e, data) {\n                    if(e.type === \"hover_node\" && this.is_disabled(data.node)) { return; }\n                    this.get_node(data.node, true).children('.jstree-wholerow')[e.type === \"hover_node\"?\"addClass\":\"removeClass\"]('jstree-wholerow-hovered');\n                }.bind(this))\n                .on(\"contextmenu.jstree\", \".jstree-wholerow\", function (e) {\n                    if (this._data.contextmenu) {\n                        e.preventDefault();\n                        var tmp = $.Event('contextmenu', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey, pageX : e.pageX, pageY : e.pageY });\n                        $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp);\n                    }\n                }.bind(this))\n                /*!\n\t\t\t\t.on(\"mousedown.jstree touchstart.jstree\", \".jstree-wholerow\", function (e) {\n\t\t\t\t\t\tif(e.target === e.currentTarget) {\n\t\t\t\t\t\t\tvar a = $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\");\n\t\t\t\t\t\t\te.target = a[0];\n\t\t\t\t\t\t\ta.trigger(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t*/\n                .on(\"click.jstree\", \".jstree-wholerow\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('click', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                })\n                .on(\"dblclick.jstree\", \".jstree-wholerow\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('dblclick', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                })\n                .on(\"click.jstree\", \".jstree-leaf > .jstree-ocl\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('click', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                }.bind(this))\n                .on(\"mouseover.jstree\", \".jstree-wholerow, .jstree-icon\", function (e) {\n                    e.stopImmediatePropagation();\n                    if(!this.is_disabled(e.currentTarget)) {\n                        this.hover_node(e.currentTarget);\n                    }\n                    return false;\n                }.bind(this))\n                .on(\"mouseleave.jstree\", \".jstree-node\", function (e) {\n                    this.dehover_node(e.currentTarget);\n                }.bind(this));\n        };\n        this.teardown = function () {\n            if(this.settings.wholerow) {\n                this.element.find(\".jstree-wholerow\").remove();\n            }\n            parent.teardown.call(this);\n        };\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                var tmp = div.cloneNode(true);\n                //tmp.style.height = this._data.core.li_height + 'px';\n                if($.inArray(obj.id, this._data.core.selected) !== -1) { tmp.className += ' jstree-wholerow-clicked'; }\n                if(this._data.core.focused && this._data.core.focused === obj.id) { tmp.className += ' jstree-wholerow-hovered'; }\n                obj.insertBefore(tmp, obj.childNodes[0]);\n            }\n            return obj;\n        };\n    };\n    // include the wholerow plugin by default\n    // $.jstree.defaults.plugins.push(\"wholerow\");\n    if(window.customElements && Object && Object.create) {\n        var proto = Object.create(HTMLElement.prototype);\n        proto.createdCallback = function () {\n            var c = { core : {}, plugins : [] }, i;\n            for(i in $.jstree.plugins) {\n                if($.jstree.plugins.hasOwnProperty(i) && this.attributes[i]) {\n                    c.plugins.push(i);\n                    if(this.getAttribute(i) && JSON.parse(this.getAttribute(i))) {\n                        c[i] = JSON.parse(this.getAttribute(i));\n                    }\n                }\n            }\n            for(i in $.jstree.defaults.core) {\n                if($.jstree.defaults.core.hasOwnProperty(i) && this.attributes[i]) {\n                    c.core[i] = JSON.parse(this.getAttribute(i)) || this.getAttribute(i);\n                }\n            }\n            $(this).jstree(c);\n        };\n        // proto.attributeChangedCallback = function (name, previous, value) { };\n        try {\n            window.customElements.define(\"vakata-jstree\", function() {}, { prototype: proto });\n        } catch (ignore) { }\n    }\n\n}));\n","jquery/ui-modules/disable-selection.js":"/*!\n * jQuery UI Disable Selection 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: disableSelection\n//>>group: Core\n//>>description: Disable selection of text content within the set of matched elements.\n//>>docs: http://api.jqueryui.com/disableSelection/\n\n// This file is deprecated\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.fn.extend( {\n        disableSelection: ( function() {\n            var eventType = \"onselectstart\" in document.createElement( \"div\" ) ?\n                \"selectstart\" :\n                \"mousedown\";\n\n            return function() {\n                return this.on( eventType + \".ui-disableSelection\", function( event ) {\n                    event.preventDefault();\n                } );\n            };\n        } )(),\n\n        enableSelection: function() {\n            return this.off( \".ui-disableSelection\" );\n        }\n    } );\n\n} );\n","jquery/ui-modules/jquery-var-for-color.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\t\"use strict\";\n\n// Create a local jQuery because jQuery Color relies on it and the\n// global may not exist with AMD and a custom build (#10199).\n// This module is a noop if used as a regular AMD module.\n// eslint-disable-next-line no-unused-vars\nvar jQuery = $;\n\n} );\n","jquery/ui-modules/core.js":"// This file is deprecated in 1.12.0 to be removed in 1.14\n( function() {\n\"use strict\";\n\ndefine( [\n\t\"jquery\",\n\t\"./data\",\n\t\"./disable-selection\",\n\t\"./focusable\",\n\t\"./form\",\n\t\"./ie\",\n\t\"./keycode\",\n\t\"./labels\",\n\t\"./jquery-patch\",\n\t\"./plugin\",\n\t\"./safe-active-element\",\n\t\"./safe-blur\",\n\t\"./scroll-parent\",\n\t\"./tabbable\",\n\t\"./unique-id\",\n\t\"./version\"\n] );\n} )();\n","jquery/ui-modules/ie.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// This file is deprecated\nreturn $.ui.ie = !!/msie [\\w.]+/.exec( navigator.userAgent.toLowerCase() );\n} );\n","jquery/ui-modules/keycode.js":"/*!\n * jQuery UI Keycode 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Keycode\n//>>group: Core\n//>>description: Provide keycodes as keynames\n//>>docs: http://api.jqueryui.com/jQuery.ui.keyCode/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.ui.keyCode = {\n        BACKSPACE: 8,\n        COMMA: 188,\n        DELETE: 46,\n        DOWN: 40,\n        END: 35,\n        ENTER: 13,\n        ESCAPE: 27,\n        HOME: 36,\n        LEFT: 37,\n        PAGE_DOWN: 34,\n        PAGE_UP: 33,\n        PERIOD: 190,\n        RIGHT: 39,\n        SPACE: 32,\n        TAB: 9,\n        UP: 38\n    };\n\n} );\n","jquery/ui-modules/jquery-patch.js":"/*!\n * jQuery UI Support for jQuery core 1.8.x and newer 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n */\n\n//>>label: jQuery 1.8+ Support\n//>>group: Core\n//>>description: Support version 1.8.x and newer of jQuery core\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n// Support: jQuery 1.9.x or older\n// $.expr[ \":\" ] is deprecated.\n    if ( !$.expr.pseudos ) {\n        $.expr.pseudos = $.expr[ \":\" ];\n    }\n\n// Support: jQuery 1.11.x or older\n// $.unique has been renamed to $.uniqueSort\n    if ( !$.uniqueSort ) {\n        $.uniqueSort = $.unique;\n    }\n\n// Support: jQuery 2.2.x or older.\n// This method has been defined in jQuery 3.0.0.\n// Code from https://github.com/jquery/jquery/blob/e539bac79e666bba95bba86d690b4e609dca2286/src/selector/escapeSelector.js\n    if ( !$.escapeSelector ) {\n\n        // CSS string/identifier serialization\n        // https://drafts.csswg.org/cssom/#common-serializing-idioms\n        var rcssescape = /([\\0-\\x1f\\x7f]|^-?\\d)|^-$|[^\\x80-\\uFFFF\\w-]/g;\n\n        var fcssescape = function( ch, asCodePoint ) {\n            if ( asCodePoint ) {\n\n                // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER\n                if ( ch === \"\\0\" ) {\n                    return \"\\uFFFD\";\n                }\n\n                // Control characters and (dependent upon position) numbers get escaped as code points\n                return ch.slice( 0, -1 ) + \"\\\\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + \" \";\n            }\n\n            // Other potentially-special ASCII characters get backslash-escaped\n            return \"\\\\\" + ch;\n        };\n\n        $.escapeSelector = function( sel ) {\n            return ( sel + \"\" ).replace( rcssescape, fcssescape );\n        };\n    }\n\n// Support: jQuery 3.4.x or older\n// These methods have been defined in jQuery 3.5.0.\n    if ( !$.fn.even || !$.fn.odd ) {\n        $.fn.extend( {\n            even: function() {\n                return this.filter( function( i ) {\n                    return i % 2 === 0;\n                } );\n            },\n            odd: function() {\n                return this.filter( function( i ) {\n                    return i % 2 === 1;\n                } );\n            }\n        } );\n    }\n\n} );\n","jquery/ui-modules/labels.js":"/*!\n * jQuery UI Labels 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: labels\n//>>group: Core\n//>>description: Find all the labels associated with a given input\n//>>docs: http://api.jqueryui.com/labels/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.fn.labels = function() {\n        var ancestor, selector, id, labels, ancestors;\n\n        if ( !this.length ) {\n            return this.pushStack( [] );\n        }\n\n        // Check control.labels first\n        if ( this[ 0 ].labels && this[ 0 ].labels.length ) {\n            return this.pushStack( this[ 0 ].labels );\n        }\n\n        // Support: IE <= 11, FF <= 37, Android <= 2.3 only\n        // Above browsers do not support control.labels. Everything below is to support them\n        // as well as document fragments. control.labels does not work on document fragments\n        labels = this.eq( 0 ).parents( \"label\" );\n\n        // Look for the label based on the id\n        id = this.attr( \"id\" );\n        if ( id ) {\n\n            // We don't search against the document in case the element\n            // is disconnected from the DOM\n            ancestor = this.eq( 0 ).parents().last();\n\n            // Get a full set of top level ancestors\n            ancestors = ancestor.add( ancestor.length ? ancestor.siblings() : this.siblings() );\n\n            // Create a selector for the label based on the id\n            selector = \"label[for='\" + $.escapeSelector( id ) + \"']\";\n\n            labels = labels.add( ancestors.find( selector ).addBack( selector ) );\n\n        }\n\n        // Return whatever we have found for labels\n        return this.pushStack( labels );\n    };\n\n} );\n","jquery/ui-modules/form-reset-mixin.js":"/*!\n * jQuery UI Form Reset Mixin 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Form Reset Mixin\n//>>group: Core\n//>>description: Refresh input widgets when their form is reset\n//>>docs: http://api.jqueryui.com/form-reset-mixin/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./form\",\n            \"./version\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.ui.formResetMixin = {\n        _formResetHandler: function() {\n            var form = $( this );\n\n            // Wait for the form reset to actually happen before refreshing\n            setTimeout( function() {\n                var instances = form.data( \"ui-form-reset-instances\" );\n                $.each( instances, function() {\n                    this.refresh();\n                } );\n            } );\n        },\n\n        _bindFormResetHandler: function() {\n            this.form = this.element._form();\n            if ( !this.form.length ) {\n                return;\n            }\n\n            var instances = this.form.data( \"ui-form-reset-instances\" ) || [];\n            if ( !instances.length ) {\n\n                // We don't use _on() here because we use a single event handler per form\n                this.form.on( \"reset.ui-form-reset\", this._formResetHandler );\n            }\n            instances.push( this );\n            this.form.data( \"ui-form-reset-instances\", instances );\n        },\n\n        _unbindFormResetHandler: function() {\n            if ( !this.form.length ) {\n                return;\n            }\n\n            var instances = this.form.data( \"ui-form-reset-instances\" );\n            instances.splice( $.inArray( this, instances ), 1 );\n            if ( instances.length ) {\n                this.form.data( \"ui-form-reset-instances\", instances );\n            } else {\n                this.form\n                    .removeData( \"ui-form-reset-instances\" )\n                    .off( \"reset.ui-form-reset\" );\n            }\n        }\n    };\n\n} );\n","jquery/ui-modules/unique-id.js":"/*!\n * jQuery UI Unique ID 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: uniqueId\n//>>group: Core\n//>>description: Functions to generate and remove uniqueId's\n//>>docs: http://api.jqueryui.com/uniqueId/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.fn.extend( {\n        uniqueId: ( function() {\n            var uuid = 0;\n\n            return function() {\n                return this.each( function() {\n                    if ( !this.id ) {\n                        this.id = \"ui-id-\" + ( ++uuid );\n                    }\n                } );\n            };\n        } )(),\n\n        removeUniqueId: function() {\n            return this.each( function() {\n                if ( /^ui-id-\\d+$/.test( this.id ) ) {\n                    $( this ).removeAttr( \"id\" );\n                }\n            } );\n        }\n    } );\n\n} );\n","jquery/ui-modules/scroll-parent.js":"/*!\n * jQuery UI Scroll Parent 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: scrollParent\n//>>group: Core\n//>>description: Get the closest ancestor element that is scrollable.\n//>>docs: http://api.jqueryui.com/scrollParent/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.fn.scrollParent = function( includeHidden ) {\n        var position = this.css( \"position\" ),\n            excludeStaticParent = position === \"absolute\",\n            overflowRegex = includeHidden ? /(auto|scroll|hidden)/ : /(auto|scroll)/,\n            scrollParent = this.parents().filter( function() {\n                var parent = $( this );\n                if ( excludeStaticParent && parent.css( \"position\" ) === \"static\" ) {\n                    return false;\n                }\n                return overflowRegex.test( parent.css( \"overflow\" ) + parent.css( \"overflow-y\" ) +\n                    parent.css( \"overflow-x\" ) );\n            } ).eq( 0 );\n\n        return position === \"fixed\" || !scrollParent.length ?\n            $( this[ 0 ].ownerDocument || document ) :\n            scrollParent;\n    };\n\n} );\n","jquery/ui-modules/tabbable.js":"/*!\n * jQuery UI Tabbable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :tabbable Selector\n//>>group: Core\n//>>description: Selects elements which can be tabbed to.\n//>>docs: http://api.jqueryui.com/tabbable-selector/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\", \"./focusable\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.extend( $.expr.pseudos, {\n        tabbable: function( element ) {\n            var tabIndex = $.attr( element, \"tabindex\" ),\n                hasTabindex = tabIndex != null;\n            return ( !hasTabindex || tabIndex >= 0 ) && $.ui.focusable( element, hasTabindex );\n        }\n    } );\n\n} );\n","jquery/ui-modules/widget.js":"/*!\n * jQuery UI Widget 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Widget\n//>>group: Core\n//>>description: Provides a factory for creating stateful widgets with a common API.\n//>>docs: http://api.jqueryui.com/jQuery.widget/\n//>>demos: http://jqueryui.com/widget/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var widgetUuid = 0;\n    var widgetHasOwnProperty = Array.prototype.hasOwnProperty;\n    var widgetSlice = Array.prototype.slice;\n\n    $.cleanData = ( function( orig ) {\n        return function( elems ) {\n            var events, elem, i;\n            for ( i = 0; ( elem = elems[ i ] ) != null; i++ ) {\n\n                // Only trigger remove when necessary to save time\n                events = $._data( elem, \"events\" );\n                if ( events && events.remove ) {\n                    $( elem ).triggerHandler( \"remove\" );\n                }\n            }\n            orig( elems );\n        };\n    } )( $.cleanData );\n\n    $.widget = function( name, base, prototype ) {\n        var existingConstructor, constructor, basePrototype;\n\n        // ProxiedPrototype allows the provided prototype to remain unmodified\n        // so that it can be used as a mixin for multiple widgets (#8876)\n        var proxiedPrototype = {};\n\n        var namespace = name.split( \".\" )[ 0 ];\n        name = name.split( \".\" )[ 1 ];\n        var fullName = namespace + \"-\" + name;\n\n        if ( !prototype ) {\n            prototype = base;\n            base = $.Widget;\n        }\n\n        if ( Array.isArray( prototype ) ) {\n            prototype = $.extend.apply( null, [ {} ].concat( prototype ) );\n        }\n\n        // Create selector for plugin\n        $.expr.pseudos[ fullName.toLowerCase() ] = function( elem ) {\n            return !!$.data( elem, fullName );\n        };\n\n        $[ namespace ] = $[ namespace ] || {};\n        existingConstructor = $[ namespace ][ name ];\n        constructor = $[ namespace ][ name ] = function( options, element ) {\n\n            // Allow instantiation without \"new\" keyword\n            if ( !this || !this._createWidget ) {\n                return new constructor( options, element );\n            }\n\n            // Allow instantiation without initializing for simple inheritance\n            // must use \"new\" keyword (the code above always passes args)\n            if ( arguments.length ) {\n                this._createWidget( options, element );\n            }\n        };\n\n        // Extend with the existing constructor to carry over any static properties\n        $.extend( constructor, existingConstructor, {\n            version: prototype.version,\n\n            // Copy the object used to create the prototype in case we need to\n            // redefine the widget later\n            _proto: $.extend( {}, prototype ),\n\n            // Track widgets that inherit from this widget in case this widget is\n            // redefined after a widget inherits from it\n            _childConstructors: []\n        } );\n\n        basePrototype = new base();\n\n        // We need to make the options hash a property directly on the new instance\n        // otherwise we'll modify the options hash on the prototype that we're\n        // inheriting from\n        basePrototype.options = $.widget.extend( {}, basePrototype.options );\n        $.each( prototype, function( prop, value ) {\n            if ( typeof value !== \"function\" ) {\n                proxiedPrototype[ prop ] = value;\n                return;\n            }\n            proxiedPrototype[ prop ] = ( function() {\n                function _super() {\n                    return base.prototype[ prop ].apply( this, arguments );\n                }\n\n                function _superApply( args ) {\n                    return base.prototype[ prop ].apply( this, args );\n                }\n\n                return function() {\n                    var __super = this._super;\n                    var __superApply = this._superApply;\n                    var returnValue;\n\n                    this._super = _super;\n                    this._superApply = _superApply;\n\n                    returnValue = value.apply( this, arguments );\n\n                    this._super = __super;\n                    this._superApply = __superApply;\n\n                    return returnValue;\n                };\n            } )();\n        } );\n        constructor.prototype = $.widget.extend( basePrototype, {\n\n            // TODO: remove support for widgetEventPrefix\n            // always use the name + a colon as the prefix, e.g., draggable:start\n            // don't prefix for widgets that aren't DOM-based\n            widgetEventPrefix: existingConstructor ? ( basePrototype.widgetEventPrefix || name ) : name\n        }, proxiedPrototype, {\n            constructor: constructor,\n            namespace: namespace,\n            widgetName: name,\n            widgetFullName: fullName\n        } );\n\n        // If this widget is being redefined then we need to find all widgets that\n        // are inheriting from it and redefine all of them so that they inherit from\n        // the new version of this widget. We're essentially trying to replace one\n        // level in the prototype chain.\n        if ( existingConstructor ) {\n            $.each( existingConstructor._childConstructors, function( i, child ) {\n                var childPrototype = child.prototype;\n\n                // Redefine the child widget using the same prototype that was\n                // originally used, but inherit from the new version of the base\n                $.widget( childPrototype.namespace + \".\" + childPrototype.widgetName, constructor,\n                    child._proto );\n            } );\n\n            // Remove the list of existing child constructors from the old constructor\n            // so the old child constructors can be garbage collected\n            delete existingConstructor._childConstructors;\n        } else {\n            base._childConstructors.push( constructor );\n        }\n\n        $.widget.bridge( name, constructor );\n\n        return constructor;\n    };\n\n    $.widget.extend = function( target ) {\n        var input = widgetSlice.call( arguments, 1 );\n        var inputIndex = 0;\n        var inputLength = input.length;\n        var key;\n        var value;\n\n        for ( ; inputIndex < inputLength; inputIndex++ ) {\n            for ( key in input[ inputIndex ] ) {\n                value = input[ inputIndex ][ key ];\n                if ( widgetHasOwnProperty.call( input[ inputIndex ], key ) && value !== undefined ) {\n\n                    // Clone objects\n                    if ( $.isPlainObject( value ) ) {\n                        target[ key ] = $.isPlainObject( target[ key ] ) ?\n                            $.widget.extend( {}, target[ key ], value ) :\n\n                            // Don't extend strings, arrays, etc. with objects\n                            $.widget.extend( {}, value );\n\n                        // Copy everything else by reference\n                    } else {\n                        target[ key ] = value;\n                    }\n                }\n            }\n        }\n        return target;\n    };\n\n    $.widget.bridge = function( name, object ) {\n        var fullName = object.prototype.widgetFullName || name;\n        $.fn[ name ] = function( options ) {\n            var isMethodCall = typeof options === \"string\";\n            var args = widgetSlice.call( arguments, 1 );\n            var returnValue = this;\n\n            if ( isMethodCall ) {\n\n                // If this is an empty collection, we need to have the instance method\n                // return undefined instead of the jQuery instance\n                if ( !this.length && options === \"instance\" ) {\n                    returnValue = undefined;\n                } else {\n                    this.each( function() {\n                        var methodValue;\n                        var instance = $.data( this, fullName );\n\n                        if ( options === \"instance\" ) {\n                            returnValue = instance;\n                            return false;\n                        }\n\n                        if ( !instance ) {\n                            return $.error( \"cannot call methods on \" + name +\n                                \" prior to initialization; \" +\n                                \"attempted to call method '\" + options + \"'\" );\n                        }\n\n                        if ( typeof instance[ options ] !== \"function\" ||\n                            options.charAt( 0 ) === \"_\" ) {\n                            return $.error( \"no such method '\" + options + \"' for \" + name +\n                                \" widget instance\" );\n                        }\n\n                        methodValue = instance[ options ].apply( instance, args );\n\n                        if ( methodValue !== instance && methodValue !== undefined ) {\n                            returnValue = methodValue && methodValue.jquery ?\n                                returnValue.pushStack( methodValue.get() ) :\n                                methodValue;\n                            return false;\n                        }\n                    } );\n                }\n            } else {\n\n                // Allow multiple hashes to be passed on init\n                if ( args.length ) {\n                    options = $.widget.extend.apply( null, [ options ].concat( args ) );\n                }\n\n                this.each( function() {\n                    var instance = $.data( this, fullName );\n                    if ( instance ) {\n                        instance.option( options || {} );\n                        if ( instance._init ) {\n                            instance._init();\n                        }\n                    } else {\n                        $.data( this, fullName, new object( options, this ) );\n                    }\n                } );\n            }\n\n            return returnValue;\n        };\n    };\n\n    $.Widget = function( /* options, element */ ) {};\n    $.Widget._childConstructors = [];\n\n    $.Widget.prototype = {\n        widgetName: \"widget\",\n        widgetEventPrefix: \"\",\n        defaultElement: \"<div>\",\n\n        options: {\n            classes: {},\n            disabled: false,\n\n            // Callbacks\n            create: null\n        },\n\n        _createWidget: function( options, element ) {\n            element = $( element || this.defaultElement || this )[ 0 ];\n            this.element = $( element );\n            this.uuid = widgetUuid++;\n            this.eventNamespace = \".\" + this.widgetName + this.uuid;\n\n            this.bindings = $();\n            this.hoverable = $();\n            this.focusable = $();\n            this.classesElementLookup = {};\n\n            if ( element !== this ) {\n                $.data( element, this.widgetFullName, this );\n                this._on( true, this.element, {\n                    remove: function( event ) {\n                        if ( event.target === element ) {\n                            this.destroy();\n                        }\n                    }\n                } );\n                this.document = $( element.style ?\n\n                    // Element within the document\n                    element.ownerDocument :\n\n                    // Element is window or document\n                    element.document || element );\n                this.window = $( this.document[ 0 ].defaultView || this.document[ 0 ].parentWindow );\n            }\n\n            this.options = $.widget.extend( {},\n                this.options,\n                this._getCreateOptions(),\n                options );\n\n            this._create();\n\n            if ( this.options.disabled ) {\n                this._setOptionDisabled( this.options.disabled );\n            }\n\n            this._trigger( \"create\", null, this._getCreateEventData() );\n            this._init();\n        },\n\n        _getCreateOptions: function() {\n            return {};\n        },\n\n        _getCreateEventData: $.noop,\n\n        _create: $.noop,\n\n        _init: $.noop,\n\n        destroy: function() {\n            var that = this;\n\n            this._destroy();\n            $.each( this.classesElementLookup, function( key, value ) {\n                that._removeClass( value, key );\n            } );\n\n            // We can probably remove the unbind calls in 2.0\n            // all event bindings should go through this._on()\n            this.element\n                .off( this.eventNamespace )\n                .removeData( this.widgetFullName );\n            this.widget()\n                .off( this.eventNamespace )\n                .removeAttr( \"aria-disabled\" );\n\n            // Clean up events and states\n            this.bindings.off( this.eventNamespace );\n        },\n\n        _destroy: $.noop,\n\n        widget: function() {\n            return this.element;\n        },\n\n        option: function( key, value ) {\n            var options = key;\n            var parts;\n            var curOption;\n            var i;\n\n            if ( arguments.length === 0 ) {\n\n                // Don't return a reference to the internal hash\n                return $.widget.extend( {}, this.options );\n            }\n\n            if ( typeof key === \"string\" ) {\n\n                // Handle nested keys, e.g., \"foo.bar\" => { foo: { bar: ___ } }\n                options = {};\n                parts = key.split( \".\" );\n                key = parts.shift();\n                if ( parts.length ) {\n                    curOption = options[ key ] = $.widget.extend( {}, this.options[ key ] );\n                    for ( i = 0; i < parts.length - 1; i++ ) {\n                        curOption[ parts[ i ] ] = curOption[ parts[ i ] ] || {};\n                        curOption = curOption[ parts[ i ] ];\n                    }\n                    key = parts.pop();\n                    if ( arguments.length === 1 ) {\n                        return curOption[ key ] === undefined ? null : curOption[ key ];\n                    }\n                    curOption[ key ] = value;\n                } else {\n                    if ( arguments.length === 1 ) {\n                        return this.options[ key ] === undefined ? null : this.options[ key ];\n                    }\n                    options[ key ] = value;\n                }\n            }\n\n            this._setOptions( options );\n\n            return this;\n        },\n\n        _setOptions: function( options ) {\n            var key;\n\n            for ( key in options ) {\n                this._setOption( key, options[ key ] );\n            }\n\n            return this;\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"classes\" ) {\n                this._setOptionClasses( value );\n            }\n\n            this.options[ key ] = value;\n\n            if ( key === \"disabled\" ) {\n                this._setOptionDisabled( value );\n            }\n\n            return this;\n        },\n\n        _setOptionClasses: function( value ) {\n            var classKey, elements, currentElements;\n\n            for ( classKey in value ) {\n                currentElements = this.classesElementLookup[ classKey ];\n                if ( value[ classKey ] === this.options.classes[ classKey ] ||\n                    !currentElements ||\n                    !currentElements.length ) {\n                    continue;\n                }\n\n                // We are doing this to create a new jQuery object because the _removeClass() call\n                // on the next line is going to destroy the reference to the current elements being\n                // tracked. We need to save a copy of this collection so that we can add the new classes\n                // below.\n                elements = $( currentElements.get() );\n                this._removeClass( currentElements, classKey );\n\n                // We don't use _addClass() here, because that uses this.options.classes\n                // for generating the string of classes. We want to use the value passed in from\n                // _setOption(), this is the new value of the classes option which was passed to\n                // _setOption(). We pass this value directly to _classes().\n                elements.addClass( this._classes( {\n                    element: elements,\n                    keys: classKey,\n                    classes: value,\n                    add: true\n                } ) );\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._toggleClass( this.widget(), this.widgetFullName + \"-disabled\", null, !!value );\n\n            // If the widget is becoming disabled, then nothing is interactive\n            if ( value ) {\n                this._removeClass( this.hoverable, null, \"ui-state-hover\" );\n                this._removeClass( this.focusable, null, \"ui-state-focus\" );\n            }\n        },\n\n        enable: function() {\n            return this._setOptions( { disabled: false } );\n        },\n\n        disable: function() {\n            return this._setOptions( { disabled: true } );\n        },\n\n        _classes: function( options ) {\n            var full = [];\n            var that = this;\n\n            options = $.extend( {\n                element: this.element,\n                classes: this.options.classes || {}\n            }, options );\n\n            function bindRemoveEvent() {\n                var nodesToBind = [];\n\n                options.element.each( function( _, element ) {\n                    var isTracked = $.map( that.classesElementLookup, function( elements ) {\n                        return elements;\n                    } )\n                        .some( function( elements ) {\n                            return elements.is( element );\n                        } );\n\n                    if ( !isTracked ) {\n                        nodesToBind.push( element );\n                    }\n                } );\n\n                that._on( $( nodesToBind ), {\n                    remove: \"_untrackClassesElement\"\n                } );\n            }\n\n            function processClassString( classes, checkOption ) {\n                var current, i;\n                for ( i = 0; i < classes.length; i++ ) {\n                    current = that.classesElementLookup[ classes[ i ] ] || $();\n                    if ( options.add ) {\n                        bindRemoveEvent();\n                        current = $( $.uniqueSort( current.get().concat( options.element.get() ) ) );\n                    } else {\n                        current = $( current.not( options.element ).get() );\n                    }\n                    that.classesElementLookup[ classes[ i ] ] = current;\n                    full.push( classes[ i ] );\n                    if ( checkOption && options.classes[ classes[ i ] ] ) {\n                        full.push( options.classes[ classes[ i ] ] );\n                    }\n                }\n            }\n\n            if ( options.keys ) {\n                processClassString( options.keys.match( /\\S+/g ) || [], true );\n            }\n            if ( options.extra ) {\n                processClassString( options.extra.match( /\\S+/g ) || [] );\n            }\n\n            return full.join( \" \" );\n        },\n\n        _untrackClassesElement: function( event ) {\n            var that = this;\n            $.each( that.classesElementLookup, function( key, value ) {\n                if ( $.inArray( event.target, value ) !== -1 ) {\n                    that.classesElementLookup[ key ] = $( value.not( event.target ).get() );\n                }\n            } );\n\n            this._off( $( event.target ) );\n        },\n\n        _removeClass: function( element, keys, extra ) {\n            return this._toggleClass( element, keys, extra, false );\n        },\n\n        _addClass: function( element, keys, extra ) {\n            return this._toggleClass( element, keys, extra, true );\n        },\n\n        _toggleClass: function( element, keys, extra, add ) {\n            add = ( typeof add === \"boolean\" ) ? add : extra;\n            var shift = ( typeof element === \"string\" || element === null ),\n                options = {\n                    extra: shift ? keys : extra,\n                    keys: shift ? element : keys,\n                    element: shift ? this.element : element,\n                    add: add\n                };\n            options.element.toggleClass( this._classes( options ), add );\n            return this;\n        },\n\n        _on: function( suppressDisabledCheck, element, handlers ) {\n            var delegateElement;\n            var instance = this;\n\n            // No suppressDisabledCheck flag, shuffle arguments\n            if ( typeof suppressDisabledCheck !== \"boolean\" ) {\n                handlers = element;\n                element = suppressDisabledCheck;\n                suppressDisabledCheck = false;\n            }\n\n            // No element argument, shuffle and use this.element\n            if ( !handlers ) {\n                handlers = element;\n                element = this.element;\n                delegateElement = this.widget();\n            } else {\n                element = delegateElement = $( element );\n                this.bindings = this.bindings.add( element );\n            }\n\n            $.each( handlers, function( event, handler ) {\n                function handlerProxy() {\n\n                    // Allow widgets to customize the disabled handling\n                    // - disabled as an array instead of boolean\n                    // - disabled class as method for disabling individual parts\n                    if ( !suppressDisabledCheck &&\n                        ( instance.options.disabled === true ||\n                            $( this ).hasClass( \"ui-state-disabled\" ) ) ) {\n                        return;\n                    }\n                    return ( typeof handler === \"string\" ? instance[ handler ] : handler )\n                        .apply( instance, arguments );\n                }\n\n                // Copy the guid so direct unbinding works\n                if ( typeof handler !== \"string\" ) {\n                    handlerProxy.guid = handler.guid =\n                        handler.guid || handlerProxy.guid || $.guid++;\n                }\n\n                var match = event.match( /^([\\w:-]*)\\s*(.*)$/ );\n                var eventName = match[ 1 ] + instance.eventNamespace;\n                var selector = match[ 2 ];\n\n                if ( selector ) {\n                    delegateElement.on( eventName, selector, handlerProxy );\n                } else {\n                    element.on( eventName, handlerProxy );\n                }\n            } );\n        },\n\n        _off: function( element, eventName ) {\n            eventName = ( eventName || \"\" ).split( \" \" ).join( this.eventNamespace + \" \" ) +\n                this.eventNamespace;\n            element.off( eventName );\n\n            // Clear the stack to avoid memory leaks (#10056)\n            this.bindings = $( this.bindings.not( element ).get() );\n            this.focusable = $( this.focusable.not( element ).get() );\n            this.hoverable = $( this.hoverable.not( element ).get() );\n        },\n\n        _delay: function( handler, delay ) {\n            function handlerProxy() {\n                return ( typeof handler === \"string\" ? instance[ handler ] : handler )\n                    .apply( instance, arguments );\n            }\n            var instance = this;\n            return setTimeout( handlerProxy, delay || 0 );\n        },\n\n        _hoverable: function( element ) {\n            this.hoverable = this.hoverable.add( element );\n            this._on( element, {\n                mouseenter: function( event ) {\n                    this._addClass( $( event.currentTarget ), null, \"ui-state-hover\" );\n                },\n                mouseleave: function( event ) {\n                    this._removeClass( $( event.currentTarget ), null, \"ui-state-hover\" );\n                }\n            } );\n        },\n\n        _focusable: function( element ) {\n            this.focusable = this.focusable.add( element );\n            this._on( element, {\n                focusin: function( event ) {\n                    this._addClass( $( event.currentTarget ), null, \"ui-state-focus\" );\n                },\n                focusout: function( event ) {\n                    this._removeClass( $( event.currentTarget ), null, \"ui-state-focus\" );\n                }\n            } );\n        },\n\n        _trigger: function( type, event, data ) {\n            var prop, orig;\n            var callback = this.options[ type ];\n\n            data = data || {};\n            event = $.Event( event );\n            event.type = ( type === this.widgetEventPrefix ?\n                type :\n                this.widgetEventPrefix + type ).toLowerCase();\n\n            // The original event may come from any element\n            // so we need to reset the target on the new event\n            event.target = this.element[ 0 ];\n\n            // Copy original event properties over to the new event\n            orig = event.originalEvent;\n            if ( orig ) {\n                for ( prop in orig ) {\n                    if ( !( prop in event ) ) {\n                        event[ prop ] = orig[ prop ];\n                    }\n                }\n            }\n\n            this.element.trigger( event, data );\n            return !( typeof callback === \"function\" &&\n                callback.apply( this.element[ 0 ], [ event ].concat( data ) ) === false ||\n                event.isDefaultPrevented() );\n        }\n    };\n\n    $.each( { show: \"fadeIn\", hide: \"fadeOut\" }, function( method, defaultEffect ) {\n        $.Widget.prototype[ \"_\" + method ] = function( element, options, callback ) {\n            if ( typeof options === \"string\" ) {\n                options = { effect: options };\n            }\n\n            var hasOptions;\n            var effectName = !options ?\n                method :\n                options === true || typeof options === \"number\" ?\n                    defaultEffect :\n                    options.effect || defaultEffect;\n\n            options = options || {};\n            if ( typeof options === \"number\" ) {\n                options = { duration: options };\n            } else if ( options === true ) {\n                options = {};\n            }\n\n            hasOptions = !$.isEmptyObject( options );\n            options.complete = callback;\n\n            if ( options.delay ) {\n                element.delay( options.delay );\n            }\n\n            if ( hasOptions && $.effects && $.effects.effect[ effectName ] ) {\n                element[ method ]( options );\n            } else if ( effectName !== method && element[ effectName ] ) {\n                element[ effectName ]( options.duration, options.easing, callback );\n            } else {\n                element.queue( function( next ) {\n                    $( this )[ method ]();\n                    if ( callback ) {\n                        callback.call( element[ 0 ] );\n                    }\n                    next();\n                } );\n            }\n        };\n    } );\n\n    return $.widget;\n\n} );\n","jquery/ui-modules/version.js":"( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.ui = $.ui || {};\n\n    return $.ui.version = \"1.13.2\";\n\n} );\n","jquery/ui-modules/focusable.js":"/*!\n * jQuery UI Focusable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :focusable Selector\n//>>group: Core\n//>>description: Selects elements which can be focused.\n//>>docs: http://api.jqueryui.com/focusable-selector/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n// Selectors\n    $.ui.focusable = function( element, hasTabindex ) {\n        var map, mapName, img, focusableIfVisible, fieldset,\n            nodeName = element.nodeName.toLowerCase();\n\n        if ( \"area\" === nodeName ) {\n            map = element.parentNode;\n            mapName = map.name;\n            if ( !element.href || !mapName || map.nodeName.toLowerCase() !== \"map\" ) {\n                return false;\n            }\n            img = $( \"img[usemap='#\" + mapName + \"']\" );\n            return img.length > 0 && img.is( \":visible\" );\n        }\n\n        if ( /^(input|select|textarea|button|object)$/.test( nodeName ) ) {\n            focusableIfVisible = !element.disabled;\n\n            if ( focusableIfVisible ) {\n\n                // Form controls within a disabled fieldset are disabled.\n                // However, controls within the fieldset's legend do not get disabled.\n                // Since controls generally aren't placed inside legends, we skip\n                // this portion of the check.\n                fieldset = $( element ).closest( \"fieldset\" )[ 0 ];\n                if ( fieldset ) {\n                    focusableIfVisible = !fieldset.disabled;\n                }\n            }\n        } else if ( \"a\" === nodeName ) {\n            focusableIfVisible = element.href || hasTabindex;\n        } else {\n            focusableIfVisible = hasTabindex;\n        }\n\n        return focusableIfVisible && $( element ).is( \":visible\" ) && visible( $( element ) );\n    };\n\n// Support: IE 8 only\n// IE 8 doesn't resolve inherit to visible/hidden for computed values\n    function visible( element ) {\n        var visibility = element.css( \"visibility\" );\n        while ( visibility === \"inherit\" ) {\n            element = element.parent();\n            visibility = element.css( \"visibility\" );\n        }\n        return visibility === \"visible\";\n    }\n\n    $.extend( $.expr.pseudos, {\n        focusable: function( element ) {\n            return $.ui.focusable( element, $.attr( element, \"tabindex\" ) != null );\n        }\n    } );\n\n    return $.ui.focusable;\n\n} );\n","jquery/ui-modules/data.js":"/*!\n * jQuery UI :data 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :data Selector\n//>>group: Core\n//>>description: Selects elements which have data stored under the specified key.\n//>>docs: http://api.jqueryui.com/data-selector/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.extend( $.expr.pseudos, {\n        data: $.expr.createPseudo ?\n            $.expr.createPseudo( function( dataName ) {\n                return function( elem ) {\n                    return !!$.data( elem, dataName );\n                };\n            } ) :\n\n            // Support: jQuery <1.8\n            function( elem, i, match ) {\n                return !!$.data( elem, match[ 3 ] );\n            }\n    } );\n} );\n","jquery/ui-modules/effect.js":"/*!\n * jQuery UI Effects 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Effects Core\n//>>group: Effects\n/* eslint-disable max-len */\n//>>description: Extends the internal jQuery effects. Includes morphing and easing. Required by all other effects.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/category/effects-core/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./jquery-var-for-color\",\n            \"./vendor/jquery-color/jquery.color\",\n            \"./version\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var dataSpace = \"ui-effects-\",\n        dataSpaceStyle = \"ui-effects-style\",\n        dataSpaceAnimated = \"ui-effects-animated\";\n\n    $.effects = {\n        effect: {}\n    };\n\n    /******************************************************************************/\n    /****************************** CLASS ANIMATIONS ******************************/\n    /******************************************************************************/\n    ( function() {\n\n        var classAnimationActions = [ \"add\", \"remove\", \"toggle\" ],\n            shorthandStyles = {\n                border: 1,\n                borderBottom: 1,\n                borderColor: 1,\n                borderLeft: 1,\n                borderRight: 1,\n                borderTop: 1,\n                borderWidth: 1,\n                margin: 1,\n                padding: 1\n            };\n\n        $.each(\n            [ \"borderLeftStyle\", \"borderRightStyle\", \"borderBottomStyle\", \"borderTopStyle\" ],\n            function( _, prop ) {\n                $.fx.step[ prop ] = function( fx ) {\n                    if ( fx.end !== \"none\" && !fx.setAttr || fx.pos === 1 && !fx.setAttr ) {\n                        jQuery.style( fx.elem, prop, fx.end );\n                        fx.setAttr = true;\n                    }\n                };\n            }\n        );\n\n        function camelCase( string ) {\n            return string.replace( /-([\\da-z])/gi, function( all, letter ) {\n                return letter.toUpperCase();\n            } );\n        }\n\n        function getElementStyles( elem ) {\n            var key, len,\n                style = elem.ownerDocument.defaultView ?\n                    elem.ownerDocument.defaultView.getComputedStyle( elem, null ) :\n                    elem.currentStyle,\n                styles = {};\n\n            if ( style && style.length && style[ 0 ] && style[ style[ 0 ] ] ) {\n                len = style.length;\n                while ( len-- ) {\n                    key = style[ len ];\n                    if ( typeof style[ key ] === \"string\" ) {\n                        styles[ camelCase( key ) ] = style[ key ];\n                    }\n                }\n\n                // Support: Opera, IE <9\n            } else {\n                for ( key in style ) {\n                    if ( typeof style[ key ] === \"string\" ) {\n                        styles[ key ] = style[ key ];\n                    }\n                }\n            }\n\n            return styles;\n        }\n\n        function styleDifference( oldStyle, newStyle ) {\n            var diff = {},\n                name, value;\n\n            for ( name in newStyle ) {\n                value = newStyle[ name ];\n                if ( oldStyle[ name ] !== value ) {\n                    if ( !shorthandStyles[ name ] ) {\n                        if ( $.fx.step[ name ] || !isNaN( parseFloat( value ) ) ) {\n                            diff[ name ] = value;\n                        }\n                    }\n                }\n            }\n\n            return diff;\n        }\n\n// Support: jQuery <1.8\n        if ( !$.fn.addBack ) {\n            $.fn.addBack = function( selector ) {\n                return this.add( selector == null ?\n                    this.prevObject : this.prevObject.filter( selector )\n                );\n            };\n        }\n\n        $.effects.animateClass = function( value, duration, easing, callback ) {\n            var o = $.speed( duration, easing, callback );\n\n            return this.queue( function() {\n                var animated = $( this ),\n                    baseClass = animated.attr( \"class\" ) || \"\",\n                    applyClassChange,\n                    allAnimations = o.children ? animated.find( \"*\" ).addBack() : animated;\n\n                // Map the animated objects to store the original styles.\n                allAnimations = allAnimations.map( function() {\n                    var el = $( this );\n                    return {\n                        el: el,\n                        start: getElementStyles( this )\n                    };\n                } );\n\n                // Apply class change\n                applyClassChange = function() {\n                    $.each( classAnimationActions, function( i, action ) {\n                        if ( value[ action ] ) {\n                            animated[ action + \"Class\" ]( value[ action ] );\n                        }\n                    } );\n                };\n                applyClassChange();\n\n                // Map all animated objects again - calculate new styles and diff\n                allAnimations = allAnimations.map( function() {\n                    this.end = getElementStyles( this.el[ 0 ] );\n                    this.diff = styleDifference( this.start, this.end );\n                    return this;\n                } );\n\n                // Apply original class\n                animated.attr( \"class\", baseClass );\n\n                // Map all animated objects again - this time collecting a promise\n                allAnimations = allAnimations.map( function() {\n                    var styleInfo = this,\n                        dfd = $.Deferred(),\n                        opts = $.extend( {}, o, {\n                            queue: false,\n                            complete: function() {\n                                dfd.resolve( styleInfo );\n                            }\n                        } );\n\n                    this.el.animate( this.diff, opts );\n                    return dfd.promise();\n                } );\n\n                // Once all animations have completed:\n                $.when.apply( $, allAnimations.get() ).done( function() {\n\n                    // Set the final class\n                    applyClassChange();\n\n                    // For each animated element,\n                    // clear all css properties that were animated\n                    $.each( arguments, function() {\n                        var el = this.el;\n                        $.each( this.diff, function( key ) {\n                            el.css( key, \"\" );\n                        } );\n                    } );\n\n                    // This is guarnteed to be there if you use jQuery.speed()\n                    // it also handles dequeuing the next anim...\n                    o.complete.call( animated[ 0 ] );\n                } );\n            } );\n        };\n\n        $.fn.extend( {\n            addClass: ( function( orig ) {\n                return function( classNames, speed, easing, callback ) {\n                    return speed ?\n                        $.effects.animateClass.call( this,\n                            { add: classNames }, speed, easing, callback ) :\n                        orig.apply( this, arguments );\n                };\n            } )( $.fn.addClass ),\n\n            removeClass: ( function( orig ) {\n                return function( classNames, speed, easing, callback ) {\n                    return arguments.length > 1 ?\n                        $.effects.animateClass.call( this,\n                            { remove: classNames }, speed, easing, callback ) :\n                        orig.apply( this, arguments );\n                };\n            } )( $.fn.removeClass ),\n\n            toggleClass: ( function( orig ) {\n                return function( classNames, force, speed, easing, callback ) {\n                    if ( typeof force === \"boolean\" || force === undefined ) {\n                        if ( !speed ) {\n\n                            // Without speed parameter\n                            return orig.apply( this, arguments );\n                        } else {\n                            return $.effects.animateClass.call( this,\n                                ( force ? { add: classNames } : { remove: classNames } ),\n                                speed, easing, callback );\n                        }\n                    } else {\n\n                        // Without force parameter\n                        return $.effects.animateClass.call( this,\n                            { toggle: classNames }, force, speed, easing );\n                    }\n                };\n            } )( $.fn.toggleClass ),\n\n            switchClass: function( remove, add, speed, easing, callback ) {\n                return $.effects.animateClass.call( this, {\n                    add: add,\n                    remove: remove\n                }, speed, easing, callback );\n            }\n        } );\n\n    } )();\n\n    /******************************************************************************/\n    /*********************************** EFFECTS **********************************/\n    /******************************************************************************/\n\n    ( function() {\n\n        if ( $.expr && $.expr.pseudos && $.expr.pseudos.animated ) {\n            $.expr.pseudos.animated = ( function( orig ) {\n                return function( elem ) {\n                    return !!$( elem ).data( dataSpaceAnimated ) || orig( elem );\n                };\n            } )( $.expr.pseudos.animated );\n        }\n\n        if ( $.uiBackCompat !== false ) {\n            $.extend( $.effects, {\n\n                // Saves a set of properties in a data storage\n                save: function( element, set ) {\n                    var i = 0, length = set.length;\n                    for ( ; i < length; i++ ) {\n                        if ( set[ i ] !== null ) {\n                            element.data( dataSpace + set[ i ], element[ 0 ].style[ set[ i ] ] );\n                        }\n                    }\n                },\n\n                // Restores a set of previously saved properties from a data storage\n                restore: function( element, set ) {\n                    var val, i = 0, length = set.length;\n                    for ( ; i < length; i++ ) {\n                        if ( set[ i ] !== null ) {\n                            val = element.data( dataSpace + set[ i ] );\n                            element.css( set[ i ], val );\n                        }\n                    }\n                },\n\n                setMode: function( el, mode ) {\n                    if ( mode === \"toggle\" ) {\n                        mode = el.is( \":hidden\" ) ? \"show\" : \"hide\";\n                    }\n                    return mode;\n                },\n\n                // Wraps the element around a wrapper that copies position properties\n                createWrapper: function( element ) {\n\n                    // If the element is already wrapped, return it\n                    if ( element.parent().is( \".ui-effects-wrapper\" ) ) {\n                        return element.parent();\n                    }\n\n                    // Wrap the element\n                    var props = {\n                            width: element.outerWidth( true ),\n                            height: element.outerHeight( true ),\n                            \"float\": element.css( \"float\" )\n                        },\n                        wrapper = $( \"<div></div>\" )\n                            .addClass( \"ui-effects-wrapper\" )\n                            .css( {\n                                fontSize: \"100%\",\n                                background: \"transparent\",\n                                border: \"none\",\n                                margin: 0,\n                                padding: 0\n                            } ),\n\n                        // Store the size in case width/height are defined in % - Fixes #5245\n                        size = {\n                            width: element.width(),\n                            height: element.height()\n                        },\n                        active = document.activeElement;\n\n                    // Support: Firefox\n                    // Firefox incorrectly exposes anonymous content\n                    // https://bugzilla.mozilla.org/show_bug.cgi?id=561664\n                    try {\n                        // eslint-disable-next-line no-unused-expressions\n                        active.id;\n                    } catch ( e ) {\n                        active = document.body;\n                    }\n\n                    element.wrap( wrapper );\n\n                    // Fixes #7595 - Elements lose focus when wrapped.\n                    if ( element[ 0 ] === active || $.contains( element[ 0 ], active ) ) {\n                        $( active ).trigger( \"focus\" );\n                    }\n\n                    // Hotfix for jQuery 1.4 since some change in wrap() seems to actually\n                    // lose the reference to the wrapped element\n                    wrapper = element.parent();\n\n                    // Transfer positioning properties to the wrapper\n                    if ( element.css( \"position\" ) === \"static\" ) {\n                        wrapper.css( { position: \"relative\" } );\n                        element.css( { position: \"relative\" } );\n                    } else {\n                        $.extend( props, {\n                            position: element.css( \"position\" ),\n                            zIndex: element.css( \"z-index\" )\n                        } );\n                        $.each( [ \"top\", \"left\", \"bottom\", \"right\" ], function( i, pos ) {\n                            props[ pos ] = element.css( pos );\n                            if ( isNaN( parseInt( props[ pos ], 10 ) ) ) {\n                                props[ pos ] = \"auto\";\n                            }\n                        } );\n                        element.css( {\n                            position: \"relative\",\n                            top: 0,\n                            left: 0,\n                            right: \"auto\",\n                            bottom: \"auto\"\n                        } );\n                    }\n                    element.css( size );\n\n                    return wrapper.css( props ).show();\n                },\n\n                removeWrapper: function( element ) {\n                    var active = document.activeElement;\n\n                    if ( element.parent().is( \".ui-effects-wrapper\" ) ) {\n                        element.parent().replaceWith( element );\n\n                        // Fixes #7595 - Elements lose focus when wrapped.\n                        if ( element[ 0 ] === active || $.contains( element[ 0 ], active ) ) {\n                            $( active ).trigger( \"focus\" );\n                        }\n                    }\n\n                    return element;\n                }\n            } );\n        }\n\n        $.extend( $.effects, {\n            version: \"1.13.2\",\n\n            define: function( name, mode, effect ) {\n                if ( !effect ) {\n                    effect = mode;\n                    mode = \"effect\";\n                }\n\n                $.effects.effect[ name ] = effect;\n                $.effects.effect[ name ].mode = mode;\n\n                return effect;\n            },\n\n            scaledDimensions: function( element, percent, direction ) {\n                if ( percent === 0 ) {\n                    return {\n                        height: 0,\n                        width: 0,\n                        outerHeight: 0,\n                        outerWidth: 0\n                    };\n                }\n\n                var x = direction !== \"horizontal\" ? ( ( percent || 100 ) / 100 ) : 1,\n                    y = direction !== \"vertical\" ? ( ( percent || 100 ) / 100 ) : 1;\n\n                return {\n                    height: element.height() * y,\n                    width: element.width() * x,\n                    outerHeight: element.outerHeight() * y,\n                    outerWidth: element.outerWidth() * x\n                };\n\n            },\n\n            clipToBox: function( animation ) {\n                return {\n                    width: animation.clip.right - animation.clip.left,\n                    height: animation.clip.bottom - animation.clip.top,\n                    left: animation.clip.left,\n                    top: animation.clip.top\n                };\n            },\n\n            // Injects recently queued functions to be first in line (after \"inprogress\")\n            unshift: function( element, queueLength, count ) {\n                var queue = element.queue();\n\n                if ( queueLength > 1 ) {\n                    queue.splice.apply( queue,\n                        [ 1, 0 ].concat( queue.splice( queueLength, count ) ) );\n                }\n                element.dequeue();\n            },\n\n            saveStyle: function( element ) {\n                element.data( dataSpaceStyle, element[ 0 ].style.cssText );\n            },\n\n            restoreStyle: function( element ) {\n                element[ 0 ].style.cssText = element.data( dataSpaceStyle ) || \"\";\n                element.removeData( dataSpaceStyle );\n            },\n\n            mode: function( element, mode ) {\n                var hidden = element.is( \":hidden\" );\n\n                if ( mode === \"toggle\" ) {\n                    mode = hidden ? \"show\" : \"hide\";\n                }\n                if ( hidden ? mode === \"hide\" : mode === \"show\" ) {\n                    mode = \"none\";\n                }\n                return mode;\n            },\n\n            // Translates a [top,left] array into a baseline value\n            getBaseline: function( origin, original ) {\n                var y, x;\n\n                switch ( origin[ 0 ] ) {\n                    case \"top\":\n                        y = 0;\n                        break;\n                    case \"middle\":\n                        y = 0.5;\n                        break;\n                    case \"bottom\":\n                        y = 1;\n                        break;\n                    default:\n                        y = origin[ 0 ] / original.height;\n                }\n\n                switch ( origin[ 1 ] ) {\n                    case \"left\":\n                        x = 0;\n                        break;\n                    case \"center\":\n                        x = 0.5;\n                        break;\n                    case \"right\":\n                        x = 1;\n                        break;\n                    default:\n                        x = origin[ 1 ] / original.width;\n                }\n\n                return {\n                    x: x,\n                    y: y\n                };\n            },\n\n            // Creates a placeholder element so that the original element can be made absolute\n            createPlaceholder: function( element ) {\n                var placeholder,\n                    cssPosition = element.css( \"position\" ),\n                    position = element.position();\n\n                // Lock in margins first to account for form elements, which\n                // will change margin if you explicitly set height\n                // see: http://jsfiddle.net/JZSMt/3/ https://bugs.webkit.org/show_bug.cgi?id=107380\n                // Support: Safari\n                element.css( {\n                    marginTop: element.css( \"marginTop\" ),\n                    marginBottom: element.css( \"marginBottom\" ),\n                    marginLeft: element.css( \"marginLeft\" ),\n                    marginRight: element.css( \"marginRight\" )\n                } )\n                    .outerWidth( element.outerWidth() )\n                    .outerHeight( element.outerHeight() );\n\n                if ( /^(static|relative)/.test( cssPosition ) ) {\n                    cssPosition = \"absolute\";\n\n                    placeholder = $( \"<\" + element[ 0 ].nodeName + \">\" ).insertAfter( element ).css( {\n\n                        // Convert inline to inline block to account for inline elements\n                        // that turn to inline block based on content (like img)\n                        display: /^(inline|ruby)/.test( element.css( \"display\" ) ) ?\n                            \"inline-block\" :\n                            \"block\",\n                        visibility: \"hidden\",\n\n                        // Margins need to be set to account for margin collapse\n                        marginTop: element.css( \"marginTop\" ),\n                        marginBottom: element.css( \"marginBottom\" ),\n                        marginLeft: element.css( \"marginLeft\" ),\n                        marginRight: element.css( \"marginRight\" ),\n                        \"float\": element.css( \"float\" )\n                    } )\n                        .outerWidth( element.outerWidth() )\n                        .outerHeight( element.outerHeight() )\n                        .addClass( \"ui-effects-placeholder\" );\n\n                    element.data( dataSpace + \"placeholder\", placeholder );\n                }\n\n                element.css( {\n                    position: cssPosition,\n                    left: position.left,\n                    top: position.top\n                } );\n\n                return placeholder;\n            },\n\n            removePlaceholder: function( element ) {\n                var dataKey = dataSpace + \"placeholder\",\n                    placeholder = element.data( dataKey );\n\n                if ( placeholder ) {\n                    placeholder.remove();\n                    element.removeData( dataKey );\n                }\n            },\n\n            // Removes a placeholder if it exists and restores\n            // properties that were modified during placeholder creation\n            cleanUp: function( element ) {\n                $.effects.restoreStyle( element );\n                $.effects.removePlaceholder( element );\n            },\n\n            setTransition: function( element, list, factor, value ) {\n                value = value || {};\n                $.each( list, function( i, x ) {\n                    var unit = element.cssUnit( x );\n                    if ( unit[ 0 ] > 0 ) {\n                        value[ x ] = unit[ 0 ] * factor + unit[ 1 ];\n                    }\n                } );\n                return value;\n            }\n        } );\n\n// Return an effect options object for the given parameters:\n        function _normalizeArguments( effect, options, speed, callback ) {\n\n            // Allow passing all options as the first parameter\n            if ( $.isPlainObject( effect ) ) {\n                options = effect;\n                effect = effect.effect;\n            }\n\n            // Convert to an object\n            effect = { effect: effect };\n\n            // Catch (effect, null, ...)\n            if ( options == null ) {\n                options = {};\n            }\n\n            // Catch (effect, callback)\n            if ( typeof options === \"function\" ) {\n                callback = options;\n                speed = null;\n                options = {};\n            }\n\n            // Catch (effect, speed, ?)\n            if ( typeof options === \"number\" || $.fx.speeds[ options ] ) {\n                callback = speed;\n                speed = options;\n                options = {};\n            }\n\n            // Catch (effect, options, callback)\n            if ( typeof speed === \"function\" ) {\n                callback = speed;\n                speed = null;\n            }\n\n            // Add options to effect\n            if ( options ) {\n                $.extend( effect, options );\n            }\n\n            speed = speed || options.duration;\n            effect.duration = $.fx.off ? 0 :\n                typeof speed === \"number\" ? speed :\n                    speed in $.fx.speeds ? $.fx.speeds[ speed ] :\n                        $.fx.speeds._default;\n\n            effect.complete = callback || options.complete;\n\n            return effect;\n        }\n\n        function standardAnimationOption( option ) {\n\n            // Valid standard speeds (nothing, number, named speed)\n            if ( !option || typeof option === \"number\" || $.fx.speeds[ option ] ) {\n                return true;\n            }\n\n            // Invalid strings - treat as \"normal\" speed\n            if ( typeof option === \"string\" && !$.effects.effect[ option ] ) {\n                return true;\n            }\n\n            // Complete callback\n            if ( typeof option === \"function\" ) {\n                return true;\n            }\n\n            // Options hash (but not naming an effect)\n            if ( typeof option === \"object\" && !option.effect ) {\n                return true;\n            }\n\n            // Didn't match any standard API\n            return false;\n        }\n\n        $.fn.extend( {\n            effect: function( /* effect, options, speed, callback */ ) {\n                var args = _normalizeArguments.apply( this, arguments ),\n                    effectMethod = $.effects.effect[ args.effect ],\n                    defaultMode = effectMethod.mode,\n                    queue = args.queue,\n                    queueName = queue || \"fx\",\n                    complete = args.complete,\n                    mode = args.mode,\n                    modes = [],\n                    prefilter = function( next ) {\n                        var el = $( this ),\n                            normalizedMode = $.effects.mode( el, mode ) || defaultMode;\n\n                        // Sentinel for duck-punching the :animated pseudo-selector\n                        el.data( dataSpaceAnimated, true );\n\n                        // Save effect mode for later use,\n                        // we can't just call $.effects.mode again later,\n                        // as the .show() below destroys the initial state\n                        modes.push( normalizedMode );\n\n                        // See $.uiBackCompat inside of run() for removal of defaultMode in 1.14\n                        if ( defaultMode && ( normalizedMode === \"show\" ||\n                            ( normalizedMode === defaultMode && normalizedMode === \"hide\" ) ) ) {\n                            el.show();\n                        }\n\n                        if ( !defaultMode || normalizedMode !== \"none\" ) {\n                            $.effects.saveStyle( el );\n                        }\n\n                        if ( typeof next === \"function\" ) {\n                            next();\n                        }\n                    };\n\n                if ( $.fx.off || !effectMethod ) {\n\n                    // Delegate to the original method (e.g., .show()) if possible\n                    if ( mode ) {\n                        return this[ mode ]( args.duration, complete );\n                    } else {\n                        return this.each( function() {\n                            if ( complete ) {\n                                complete.call( this );\n                            }\n                        } );\n                    }\n                }\n\n                function run( next ) {\n                    var elem = $( this );\n\n                    function cleanup() {\n                        elem.removeData( dataSpaceAnimated );\n\n                        $.effects.cleanUp( elem );\n\n                        if ( args.mode === \"hide\" ) {\n                            elem.hide();\n                        }\n\n                        done();\n                    }\n\n                    function done() {\n                        if ( typeof complete === \"function\" ) {\n                            complete.call( elem[ 0 ] );\n                        }\n\n                        if ( typeof next === \"function\" ) {\n                            next();\n                        }\n                    }\n\n                    // Override mode option on a per element basis,\n                    // as toggle can be either show or hide depending on element state\n                    args.mode = modes.shift();\n\n                    if ( $.uiBackCompat !== false && !defaultMode ) {\n                        if ( elem.is( \":hidden\" ) ? mode === \"hide\" : mode === \"show\" ) {\n\n                            // Call the core method to track \"olddisplay\" properly\n                            elem[ mode ]();\n                            done();\n                        } else {\n                            effectMethod.call( elem[ 0 ], args, done );\n                        }\n                    } else {\n                        if ( args.mode === \"none\" ) {\n\n                            // Call the core method to track \"olddisplay\" properly\n                            elem[ mode ]();\n                            done();\n                        } else {\n                            effectMethod.call( elem[ 0 ], args, cleanup );\n                        }\n                    }\n                }\n\n                // Run prefilter on all elements first to ensure that\n                // any showing or hiding happens before placeholder creation,\n                // which ensures that any layout changes are correctly captured.\n                return queue === false ?\n                    this.each( prefilter ).each( run ) :\n                    this.queue( queueName, prefilter ).queue( queueName, run );\n            },\n\n            show: ( function( orig ) {\n                return function( option ) {\n                    if ( standardAnimationOption( option ) ) {\n                        return orig.apply( this, arguments );\n                    } else {\n                        var args = _normalizeArguments.apply( this, arguments );\n                        args.mode = \"show\";\n                        return this.effect.call( this, args );\n                    }\n                };\n            } )( $.fn.show ),\n\n            hide: ( function( orig ) {\n                return function( option ) {\n                    if ( standardAnimationOption( option ) ) {\n                        return orig.apply( this, arguments );\n                    } else {\n                        var args = _normalizeArguments.apply( this, arguments );\n                        args.mode = \"hide\";\n                        return this.effect.call( this, args );\n                    }\n                };\n            } )( $.fn.hide ),\n\n            toggle: ( function( orig ) {\n                return function( option ) {\n                    if ( standardAnimationOption( option ) || typeof option === \"boolean\" ) {\n                        return orig.apply( this, arguments );\n                    } else {\n                        var args = _normalizeArguments.apply( this, arguments );\n                        args.mode = \"toggle\";\n                        return this.effect.call( this, args );\n                    }\n                };\n            } )( $.fn.toggle ),\n\n            cssUnit: function( key ) {\n                var style = this.css( key ),\n                    val = [];\n\n                $.each( [ \"em\", \"px\", \"%\", \"pt\" ], function( i, unit ) {\n                    if ( style.indexOf( unit ) > 0 ) {\n                        val = [ parseFloat( style ), unit ];\n                    }\n                } );\n                return val;\n            },\n\n            cssClip: function( clipObj ) {\n                if ( clipObj ) {\n                    return this.css( \"clip\", \"rect(\" + clipObj.top + \"px \" + clipObj.right + \"px \" +\n                        clipObj.bottom + \"px \" + clipObj.left + \"px)\" );\n                }\n                return parseClip( this.css( \"clip\" ), this );\n            },\n\n            transfer: function( options, done ) {\n                var element = $( this ),\n                    target = $( options.to ),\n                    targetFixed = target.css( \"position\" ) === \"fixed\",\n                    body = $( \"body\" ),\n                    fixTop = targetFixed ? body.scrollTop() : 0,\n                    fixLeft = targetFixed ? body.scrollLeft() : 0,\n                    endPosition = target.offset(),\n                    animation = {\n                        top: endPosition.top - fixTop,\n                        left: endPosition.left - fixLeft,\n                        height: target.innerHeight(),\n                        width: target.innerWidth()\n                    },\n                    startPosition = element.offset(),\n                    transfer = $( \"<div class='ui-effects-transfer'></div>\" );\n\n                transfer\n                    .appendTo( \"body\" )\n                    .addClass( options.className )\n                    .css( {\n                        top: startPosition.top - fixTop,\n                        left: startPosition.left - fixLeft,\n                        height: element.innerHeight(),\n                        width: element.innerWidth(),\n                        position: targetFixed ? \"fixed\" : \"absolute\"\n                    } )\n                    .animate( animation, options.duration, options.easing, function() {\n                        transfer.remove();\n                        if ( typeof done === \"function\" ) {\n                            done();\n                        }\n                    } );\n            }\n        } );\n\n        function parseClip( str, element ) {\n            var outerWidth = element.outerWidth(),\n                outerHeight = element.outerHeight(),\n                clipRegex = /^rect\\((-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto)\\)$/,\n                values = clipRegex.exec( str ) || [ \"\", 0, outerWidth, outerHeight, 0 ];\n\n            return {\n                top: parseFloat( values[ 1 ] ) || 0,\n                right: values[ 2 ] === \"auto\" ? outerWidth : parseFloat( values[ 2 ] ),\n                bottom: values[ 3 ] === \"auto\" ? outerHeight : parseFloat( values[ 3 ] ),\n                left: parseFloat( values[ 4 ] ) || 0\n            };\n        }\n\n        $.fx.step.clip = function( fx ) {\n            if ( !fx.clipInit ) {\n                fx.start = $( fx.elem ).cssClip();\n                if ( typeof fx.end === \"string\" ) {\n                    fx.end = parseClip( fx.end, fx.elem );\n                }\n                fx.clipInit = true;\n            }\n\n            $( fx.elem ).cssClip( {\n                top: fx.pos * ( fx.end.top - fx.start.top ) + fx.start.top,\n                right: fx.pos * ( fx.end.right - fx.start.right ) + fx.start.right,\n                bottom: fx.pos * ( fx.end.bottom - fx.start.bottom ) + fx.start.bottom,\n                left: fx.pos * ( fx.end.left - fx.start.left ) + fx.start.left\n            } );\n        };\n\n    } )();\n\n    /******************************************************************************/\n    /*********************************** EASING ***********************************/\n    /******************************************************************************/\n\n    ( function() {\n\n// Based on easing equations from Robert Penner (http://www.robertpenner.com/easing)\n\n        var baseEasings = {};\n\n        $.each( [ \"Quad\", \"Cubic\", \"Quart\", \"Quint\", \"Expo\" ], function( i, name ) {\n            baseEasings[ name ] = function( p ) {\n                return Math.pow( p, i + 2 );\n            };\n        } );\n\n        $.extend( baseEasings, {\n            Sine: function( p ) {\n                return 1 - Math.cos( p * Math.PI / 2 );\n            },\n            Circ: function( p ) {\n                return 1 - Math.sqrt( 1 - p * p );\n            },\n            Elastic: function( p ) {\n                return p === 0 || p === 1 ? p :\n                    -Math.pow( 2, 8 * ( p - 1 ) ) * Math.sin( ( ( p - 1 ) * 80 - 7.5 ) * Math.PI / 15 );\n            },\n            Back: function( p ) {\n                return p * p * ( 3 * p - 2 );\n            },\n            Bounce: function( p ) {\n                var pow2,\n                    bounce = 4;\n\n                while ( p < ( ( pow2 = Math.pow( 2, --bounce ) ) - 1 ) / 11 ) {}\n                return 1 / Math.pow( 4, 3 - bounce ) - 7.5625 * Math.pow( ( pow2 * 3 - 2 ) / 22 - p, 2 );\n            }\n        } );\n\n        $.each( baseEasings, function( name, easeIn ) {\n            $.easing[ \"easeIn\" + name ] = easeIn;\n            $.easing[ \"easeOut\" + name ] = function( p ) {\n                return 1 - easeIn( 1 - p );\n            };\n            $.easing[ \"easeInOut\" + name ] = function( p ) {\n                return p < 0.5 ?\n                    easeIn( p * 2 ) / 2 :\n                    1 - easeIn( p * -2 + 2 ) / 2;\n            };\n        } );\n\n    } )();\n\n    return $.effects;\n\n} );\n","jquery/ui-modules/safe-blur.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.ui.safeBlur = function( element ) {\n\n\t// Support: IE9 - 10 only\n\t// If the <body> is blurred, IE will switch windows, see #9420\n\tif ( element && element.nodeName.toLowerCase() !== \"body\" ) {\n\t\t$( element ).trigger( \"blur\" );\n\t}\n};\n\n} );\n","jquery/ui-modules/form.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// Support: IE8 Only\n// IE8 does not support the form attribute and when it is supplied. It overwrites the form prop\n// with a string, so we need to find the proper form.\nreturn $.fn._form = function() {\n\treturn typeof this[ 0 ].form === \"string\" ? this.closest( \"form\" ) : $( this[ 0 ].form );\n};\n\n} );\n","jquery/ui-modules/safe-active-element.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.ui.safeActiveElement = function( document ) {\n\tvar activeElement;\n\n\t// Support: IE 9 only\n\t// IE9 throws an \"Unspecified error\" accessing document.activeElement from an <iframe>\n\ttry {\n\t\tactiveElement = document.activeElement;\n\t} catch ( error ) {\n\t\tactiveElement = document.body;\n\t}\n\n\t// Support: IE 9 - 11 only\n\t// IE may return null instead of an element\n\t// Interestingly, this only seems to occur when NOT in an iframe\n\tif ( !activeElement ) {\n\t\tactiveElement = document.body;\n\t}\n\n\t// Support: IE 11 only\n\t// IE11 returns a seemingly empty object in some cases when accessing\n\t// document.activeElement from an <iframe>\n\tif ( !activeElement.nodeName ) {\n\t\tactiveElement = document.body;\n\t}\n\n\treturn activeElement;\n};\n\n} );\n","jquery/ui-modules/plugin.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// $.ui.plugin is deprecated. Use $.widget() extensions instead.\nreturn $.ui.plugin = {\n\tadd: function( module, option, set ) {\n\t\tvar i,\n\t\t\tproto = $.ui[ module ].prototype;\n\t\tfor ( i in set ) {\n\t\t\tproto.plugins[ i ] = proto.plugins[ i ] || [];\n\t\t\tproto.plugins[ i ].push( [ option, set[ i ] ] );\n\t\t}\n\t},\n\tcall: function( instance, name, args, allowDisconnected ) {\n\t\tvar i,\n\t\t\tset = instance.plugins[ name ];\n\n\t\tif ( !set ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( !allowDisconnected && ( !instance.element[ 0 ].parentNode ||\n\t\t\t\tinstance.element[ 0 ].parentNode.nodeType === 11 ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tfor ( i = 0; i < set.length; i++ ) {\n\t\t\tif ( instance.options[ set[ i ][ 0 ] ] ) {\n\t\t\t\tset[ i ][ 1 ].apply( instance.element, args );\n\t\t\t}\n\t\t}\n\t}\n};\n\n} );\n","jquery/ui-modules/position.js":"/*!\n * jQuery UI Position 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/position/\n */\n\n//>>label: Position\n//>>group: Core\n//>>description: Positions elements relative to other elements.\n//>>docs: http://api.jqueryui.com/position/\n//>>demos: http://jqueryui.com/position/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\", \"./version\" ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    ( function() {\n        var cachedScrollbarWidth,\n            max = Math.max,\n            abs = Math.abs,\n            rhorizontal = /left|center|right/,\n            rvertical = /top|center|bottom/,\n            roffset = /[\\+\\-]\\d+(\\.[\\d]+)?%?/,\n            rposition = /^\\w+/,\n            rpercent = /%$/,\n            _position = $.fn.position;\n\n        function getOffsets( offsets, width, height ) {\n            return [\n                parseFloat( offsets[ 0 ] ) * ( rpercent.test( offsets[ 0 ] ) ? width / 100 : 1 ),\n                parseFloat( offsets[ 1 ] ) * ( rpercent.test( offsets[ 1 ] ) ? height / 100 : 1 )\n            ];\n        }\n\n        function parseCss( element, property ) {\n            return parseInt( $.css( element, property ), 10 ) || 0;\n        }\n\n        function isWindow( obj ) {\n            return obj != null && obj === obj.window;\n        }\n\n        function getDimensions( elem ) {\n            var raw = elem[ 0 ];\n            if ( raw.nodeType === 9 ) {\n                return {\n                    width: elem.width(),\n                    height: elem.height(),\n                    offset: { top: 0, left: 0 }\n                };\n            }\n            if ( isWindow( raw ) ) {\n                return {\n                    width: elem.width(),\n                    height: elem.height(),\n                    offset: { top: elem.scrollTop(), left: elem.scrollLeft() }\n                };\n            }\n            if ( raw.preventDefault ) {\n                return {\n                    width: 0,\n                    height: 0,\n                    offset: { top: raw.pageY, left: raw.pageX }\n                };\n            }\n            return {\n                width: elem.outerWidth(),\n                height: elem.outerHeight(),\n                offset: elem.offset()\n            };\n        }\n\n        $.position = {\n            scrollbarWidth: function() {\n                if ( cachedScrollbarWidth !== undefined ) {\n                    return cachedScrollbarWidth;\n                }\n                var w1, w2,\n                    div = $( \"<div style=\" +\n                        \"'display:block;position:absolute;width:200px;height:200px;overflow:hidden;'>\" +\n                        \"<div style='height:300px;width:auto;'></div></div>\" ),\n                    innerDiv = div.children()[ 0 ];\n\n                $( \"body\" ).append( div );\n                w1 = innerDiv.offsetWidth;\n                div.css( \"overflow\", \"scroll\" );\n\n                w2 = innerDiv.offsetWidth;\n\n                if ( w1 === w2 ) {\n                    w2 = div[ 0 ].clientWidth;\n                }\n\n                div.remove();\n\n                return ( cachedScrollbarWidth = w1 - w2 );\n            },\n            getScrollInfo: function( within ) {\n                var overflowX = within.isWindow || within.isDocument ? \"\" :\n                        within.element.css( \"overflow-x\" ),\n                    overflowY = within.isWindow || within.isDocument ? \"\" :\n                        within.element.css( \"overflow-y\" ),\n                    hasOverflowX = overflowX === \"scroll\" ||\n                        ( overflowX === \"auto\" && within.width < within.element[ 0 ].scrollWidth ),\n                    hasOverflowY = overflowY === \"scroll\" ||\n                        ( overflowY === \"auto\" && within.height < within.element[ 0 ].scrollHeight );\n                return {\n                    width: hasOverflowY ? $.position.scrollbarWidth() : 0,\n                    height: hasOverflowX ? $.position.scrollbarWidth() : 0\n                };\n            },\n            getWithinInfo: function( element ) {\n                var withinElement = $( element || window ),\n                    isElemWindow = isWindow( withinElement[ 0 ] ),\n                    isDocument = !!withinElement[ 0 ] && withinElement[ 0 ].nodeType === 9,\n                    hasOffset = !isElemWindow && !isDocument;\n                return {\n                    element: withinElement,\n                    isWindow: isElemWindow,\n                    isDocument: isDocument,\n                    offset: hasOffset ? $( element ).offset() : { left: 0, top: 0 },\n                    scrollLeft: withinElement.scrollLeft(),\n                    scrollTop: withinElement.scrollTop(),\n                    width: withinElement.outerWidth(),\n                    height: withinElement.outerHeight()\n                };\n            }\n        };\n\n        $.fn.position = function( options ) {\n            if ( !options || !options.of ) {\n                return _position.apply( this, arguments );\n            }\n\n            // Make a copy, we don't want to modify arguments\n            options = $.extend( {}, options );\n\n            var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions,\n\n                // Make sure string options are treated as CSS selectors\n                target = typeof options.of === \"string\" ?\n                    $( document ).find( options.of ) :\n                    $( options.of ),\n\n                within = $.position.getWithinInfo( options.within ),\n                scrollInfo = $.position.getScrollInfo( within ),\n                collision = ( options.collision || \"flip\" ).split( \" \" ),\n                offsets = {};\n\n            dimensions = getDimensions( target );\n            if ( target[ 0 ].preventDefault ) {\n\n                // Force left top to allow flipping\n                options.at = \"left top\";\n            }\n            targetWidth = dimensions.width;\n            targetHeight = dimensions.height;\n            targetOffset = dimensions.offset;\n\n            // Clone to reuse original targetOffset later\n            basePosition = $.extend( {}, targetOffset );\n\n            // Force my and at to have valid horizontal and vertical positions\n            // if a value is missing or invalid, it will be converted to center\n            $.each( [ \"my\", \"at\" ], function() {\n                var pos = ( options[ this ] || \"\" ).split( \" \" ),\n                    horizontalOffset,\n                    verticalOffset;\n\n                if ( pos.length === 1 ) {\n                    pos = rhorizontal.test( pos[ 0 ] ) ?\n                        pos.concat( [ \"center\" ] ) :\n                        rvertical.test( pos[ 0 ] ) ?\n                            [ \"center\" ].concat( pos ) :\n                            [ \"center\", \"center\" ];\n                }\n                pos[ 0 ] = rhorizontal.test( pos[ 0 ] ) ? pos[ 0 ] : \"center\";\n                pos[ 1 ] = rvertical.test( pos[ 1 ] ) ? pos[ 1 ] : \"center\";\n\n                // Calculate offsets\n                horizontalOffset = roffset.exec( pos[ 0 ] );\n                verticalOffset = roffset.exec( pos[ 1 ] );\n                offsets[ this ] = [\n                    horizontalOffset ? horizontalOffset[ 0 ] : 0,\n                    verticalOffset ? verticalOffset[ 0 ] : 0\n                ];\n\n                // Reduce to just the positions without the offsets\n                options[ this ] = [\n                    rposition.exec( pos[ 0 ] )[ 0 ],\n                    rposition.exec( pos[ 1 ] )[ 0 ]\n                ];\n            } );\n\n            // Normalize collision option\n            if ( collision.length === 1 ) {\n                collision[ 1 ] = collision[ 0 ];\n            }\n\n            if ( options.at[ 0 ] === \"right\" ) {\n                basePosition.left += targetWidth;\n            } else if ( options.at[ 0 ] === \"center\" ) {\n                basePosition.left += targetWidth / 2;\n            }\n\n            if ( options.at[ 1 ] === \"bottom\" ) {\n                basePosition.top += targetHeight;\n            } else if ( options.at[ 1 ] === \"center\" ) {\n                basePosition.top += targetHeight / 2;\n            }\n\n            atOffset = getOffsets( offsets.at, targetWidth, targetHeight );\n            basePosition.left += atOffset[ 0 ];\n            basePosition.top += atOffset[ 1 ];\n\n            return this.each( function() {\n                var collisionPosition, using,\n                    elem = $( this ),\n                    elemWidth = elem.outerWidth(),\n                    elemHeight = elem.outerHeight(),\n                    marginLeft = parseCss( this, \"marginLeft\" ),\n                    marginTop = parseCss( this, \"marginTop\" ),\n                    collisionWidth = elemWidth + marginLeft + parseCss( this, \"marginRight\" ) +\n                        scrollInfo.width,\n                    collisionHeight = elemHeight + marginTop + parseCss( this, \"marginBottom\" ) +\n                        scrollInfo.height,\n                    position = $.extend( {}, basePosition ),\n                    myOffset = getOffsets( offsets.my, elem.outerWidth(), elem.outerHeight() );\n\n                if ( options.my[ 0 ] === \"right\" ) {\n                    position.left -= elemWidth;\n                } else if ( options.my[ 0 ] === \"center\" ) {\n                    position.left -= elemWidth / 2;\n                }\n\n                if ( options.my[ 1 ] === \"bottom\" ) {\n                    position.top -= elemHeight;\n                } else if ( options.my[ 1 ] === \"center\" ) {\n                    position.top -= elemHeight / 2;\n                }\n\n                position.left += myOffset[ 0 ];\n                position.top += myOffset[ 1 ];\n\n                collisionPosition = {\n                    marginLeft: marginLeft,\n                    marginTop: marginTop\n                };\n\n                $.each( [ \"left\", \"top\" ], function( i, dir ) {\n                    if ( $.ui.position[ collision[ i ] ] ) {\n                        $.ui.position[ collision[ i ] ][ dir ]( position, {\n                            targetWidth: targetWidth,\n                            targetHeight: targetHeight,\n                            elemWidth: elemWidth,\n                            elemHeight: elemHeight,\n                            collisionPosition: collisionPosition,\n                            collisionWidth: collisionWidth,\n                            collisionHeight: collisionHeight,\n                            offset: [ atOffset[ 0 ] + myOffset[ 0 ], atOffset [ 1 ] + myOffset[ 1 ] ],\n                            my: options.my,\n                            at: options.at,\n                            within: within,\n                            elem: elem\n                        } );\n                    }\n                } );\n\n                if ( options.using ) {\n\n                    // Adds feedback as second argument to using callback, if present\n                    using = function( props ) {\n                        var left = targetOffset.left - position.left,\n                            right = left + targetWidth - elemWidth,\n                            top = targetOffset.top - position.top,\n                            bottom = top + targetHeight - elemHeight,\n                            feedback = {\n                                target: {\n                                    element: target,\n                                    left: targetOffset.left,\n                                    top: targetOffset.top,\n                                    width: targetWidth,\n                                    height: targetHeight\n                                },\n                                element: {\n                                    element: elem,\n                                    left: position.left,\n                                    top: position.top,\n                                    width: elemWidth,\n                                    height: elemHeight\n                                },\n                                horizontal: right < 0 ? \"left\" : left > 0 ? \"right\" : \"center\",\n                                vertical: bottom < 0 ? \"top\" : top > 0 ? \"bottom\" : \"middle\"\n                            };\n                        if ( targetWidth < elemWidth && abs( left + right ) < targetWidth ) {\n                            feedback.horizontal = \"center\";\n                        }\n                        if ( targetHeight < elemHeight && abs( top + bottom ) < targetHeight ) {\n                            feedback.vertical = \"middle\";\n                        }\n                        if ( max( abs( left ), abs( right ) ) > max( abs( top ), abs( bottom ) ) ) {\n                            feedback.important = \"horizontal\";\n                        } else {\n                            feedback.important = \"vertical\";\n                        }\n                        options.using.call( this, props, feedback );\n                    };\n                }\n\n                elem.offset( $.extend( position, { using: using } ) );\n            } );\n        };\n\n        $.ui.position = {\n            fit: {\n                left: function( position, data ) {\n                    var within = data.within,\n                        withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,\n                        outerWidth = within.width,\n                        collisionPosLeft = position.left - data.collisionPosition.marginLeft,\n                        overLeft = withinOffset - collisionPosLeft,\n                        overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,\n                        newOverRight;\n\n                    // Element is wider than within\n                    if ( data.collisionWidth > outerWidth ) {\n\n                        // Element is initially over the left side of within\n                        if ( overLeft > 0 && overRight <= 0 ) {\n                            newOverRight = position.left + overLeft + data.collisionWidth - outerWidth -\n                                withinOffset;\n                            position.left += overLeft - newOverRight;\n\n                            // Element is initially over right side of within\n                        } else if ( overRight > 0 && overLeft <= 0 ) {\n                            position.left = withinOffset;\n\n                            // Element is initially over both left and right sides of within\n                        } else {\n                            if ( overLeft > overRight ) {\n                                position.left = withinOffset + outerWidth - data.collisionWidth;\n                            } else {\n                                position.left = withinOffset;\n                            }\n                        }\n\n                        // Too far left -> align with left edge\n                    } else if ( overLeft > 0 ) {\n                        position.left += overLeft;\n\n                        // Too far right -> align with right edge\n                    } else if ( overRight > 0 ) {\n                        position.left -= overRight;\n\n                        // Adjust based on position and margin\n                    } else {\n                        position.left = max( position.left - collisionPosLeft, position.left );\n                    }\n                },\n                top: function( position, data ) {\n                    var within = data.within,\n                        withinOffset = within.isWindow ? within.scrollTop : within.offset.top,\n                        outerHeight = data.within.height,\n                        collisionPosTop = position.top - data.collisionPosition.marginTop,\n                        overTop = withinOffset - collisionPosTop,\n                        overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,\n                        newOverBottom;\n\n                    // Element is taller than within\n                    if ( data.collisionHeight > outerHeight ) {\n\n                        // Element is initially over the top of within\n                        if ( overTop > 0 && overBottom <= 0 ) {\n                            newOverBottom = position.top + overTop + data.collisionHeight - outerHeight -\n                                withinOffset;\n                            position.top += overTop - newOverBottom;\n\n                            // Element is initially over bottom of within\n                        } else if ( overBottom > 0 && overTop <= 0 ) {\n                            position.top = withinOffset;\n\n                            // Element is initially over both top and bottom of within\n                        } else {\n                            if ( overTop > overBottom ) {\n                                position.top = withinOffset + outerHeight - data.collisionHeight;\n                            } else {\n                                position.top = withinOffset;\n                            }\n                        }\n\n                        // Too far up -> align with top\n                    } else if ( overTop > 0 ) {\n                        position.top += overTop;\n\n                        // Too far down -> align with bottom edge\n                    } else if ( overBottom > 0 ) {\n                        position.top -= overBottom;\n\n                        // Adjust based on position and margin\n                    } else {\n                        position.top = max( position.top - collisionPosTop, position.top );\n                    }\n                }\n            },\n            flip: {\n                left: function( position, data ) {\n                    var within = data.within,\n                        withinOffset = within.offset.left + within.scrollLeft,\n                        outerWidth = within.width,\n                        offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,\n                        collisionPosLeft = position.left - data.collisionPosition.marginLeft,\n                        overLeft = collisionPosLeft - offsetLeft,\n                        overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,\n                        myOffset = data.my[ 0 ] === \"left\" ?\n                            -data.elemWidth :\n                            data.my[ 0 ] === \"right\" ?\n                                data.elemWidth :\n                                0,\n                        atOffset = data.at[ 0 ] === \"left\" ?\n                            data.targetWidth :\n                            data.at[ 0 ] === \"right\" ?\n                                -data.targetWidth :\n                                0,\n                        offset = -2 * data.offset[ 0 ],\n                        newOverRight,\n                        newOverLeft;\n\n                    if ( overLeft < 0 ) {\n                        newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth -\n                            outerWidth - withinOffset;\n                        if ( newOverRight < 0 || newOverRight < abs( overLeft ) ) {\n                            position.left += myOffset + atOffset + offset;\n                        }\n                    } else if ( overRight > 0 ) {\n                        newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset +\n                            atOffset + offset - offsetLeft;\n                        if ( newOverLeft > 0 || abs( newOverLeft ) < overRight ) {\n                            position.left += myOffset + atOffset + offset;\n                        }\n                    }\n                },\n                top: function( position, data ) {\n                    var within = data.within,\n                        withinOffset = within.offset.top + within.scrollTop,\n                        outerHeight = within.height,\n                        offsetTop = within.isWindow ? within.scrollTop : within.offset.top,\n                        collisionPosTop = position.top - data.collisionPosition.marginTop,\n                        overTop = collisionPosTop - offsetTop,\n                        overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,\n                        top = data.my[ 1 ] === \"top\",\n                        myOffset = top ?\n                            -data.elemHeight :\n                            data.my[ 1 ] === \"bottom\" ?\n                                data.elemHeight :\n                                0,\n                        atOffset = data.at[ 1 ] === \"top\" ?\n                            data.targetHeight :\n                            data.at[ 1 ] === \"bottom\" ?\n                                -data.targetHeight :\n                                0,\n                        offset = -2 * data.offset[ 1 ],\n                        newOverTop,\n                        newOverBottom;\n                    if ( overTop < 0 ) {\n                        newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight -\n                            outerHeight - withinOffset;\n                        if ( newOverBottom < 0 || newOverBottom < abs( overTop ) ) {\n                            position.top += myOffset + atOffset + offset;\n                        }\n                    } else if ( overBottom > 0 ) {\n                        newOverTop = position.top - data.collisionPosition.marginTop + myOffset + atOffset +\n                            offset - offsetTop;\n                        if ( newOverTop > 0 || abs( newOverTop ) < overBottom ) {\n                            position.top += myOffset + atOffset + offset;\n                        }\n                    }\n                }\n            },\n            flipfit: {\n                left: function() {\n                    $.ui.position.flip.left.apply( this, arguments );\n                    $.ui.position.fit.left.apply( this, arguments );\n                },\n                top: function() {\n                    $.ui.position.flip.top.apply( this, arguments );\n                    $.ui.position.fit.top.apply( this, arguments );\n                }\n            }\n        };\n\n    } )();\n\n    return $.ui.position;\n\n} );\n","jquery/ui-modules/i18n/datepicker-id.js":"/* Indonesian initialisation for the jQuery UI date picker plugin. */\n/* Written by Deden Fathurahman (dedenf@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.id = {\n\tcloseText: \"Tutup\",\n\tprevText: \"&#x3C;mundur\",\n\tnextText: \"maju&#x3E;\",\n\tcurrentText: \"hari ini\",\n\tmonthNames: [ \"Januari\", \"Februari\", \"Maret\", \"April\", \"Mei\", \"Juni\",\n\t\"Juli\", \"Agustus\", \"September\", \"Oktober\", \"Nopember\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Agus\", \"Sep\", \"Okt\", \"Nop\", \"Des\" ],\n\tdayNames: [ \"Minggu\", \"Senin\", \"Selasa\", \"Rabu\", \"Kamis\", \"Jumat\", \"Sabtu\" ],\n\tdayNamesShort: [ \"Min\", \"Sen\", \"Sel\", \"Rab\", \"kam\", \"Jum\", \"Sab\" ],\n\tdayNamesMin: [ \"Mg\", \"Sn\", \"Sl\", \"Rb\", \"Km\", \"jm\", \"Sb\" ],\n\tweekHeader: \"Mg\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.id );\n\nreturn datepicker.regional.id;\n\n} );\n","jquery/ui-modules/i18n/datepicker-az.js":"/* Azerbaijani (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Jamil Najafov (necefov33@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.az = {\n\tcloseText: \"Ba\u011fla\",\n\tprevText: \"&#x3C;Geri\",\n\tnextText: \"\u0130r\u0259li&#x3E;\",\n\tcurrentText: \"Bug\u00fcn\",\n\tmonthNames: [ \"Yanvar\", \"Fevral\", \"Mart\", \"Aprel\", \"May\", \"\u0130yun\",\n\t\"\u0130yul\", \"Avqust\", \"Sentyabr\", \"Oktyabr\", \"Noyabr\", \"Dekabr\" ],\n\tmonthNamesShort: [ \"Yan\", \"Fev\", \"Mar\", \"Apr\", \"May\", \"\u0130yun\",\n\t\"\u0130yul\", \"Avq\", \"Sen\", \"Okt\", \"Noy\", \"Dek\" ],\n\tdayNames: [ \"Bazar\", \"Bazar ert\u0259si\", \"\u00c7\u0259r\u015f\u0259nb\u0259 ax\u015fam\u0131\", \"\u00c7\u0259r\u015f\u0259nb\u0259\", \"C\u00fcm\u0259 ax\u015fam\u0131\", \"C\u00fcm\u0259\", \"\u015e\u0259nb\u0259\" ],\n\tdayNamesShort: [ \"B\", \"Be\", \"\u00c7a\", \"\u00c7\", \"Ca\", \"C\", \"\u015e\" ],\n\tdayNamesMin: [ \"B\", \"B\", \"\u00c7\", \"\u0421\", \"\u00c7\", \"C\", \"\u015e\" ],\n\tweekHeader: \"Hf\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.az );\n\nreturn datepicker.regional.az;\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-CN.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by Cloudream (cloudream@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-CN\" ] = {\n\tcloseText: \"\u5173\u95ed\",\n\tprevText: \"&#x3C;\u4e0a\u6708\",\n\tnextText: \"\u4e0b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u5468\u65e5\", \"\u5468\u4e00\", \"\u5468\u4e8c\", \"\u5468\u4e09\", \"\u5468\u56db\", \"\u5468\u4e94\", \"\u5468\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u5468\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-CN\" ] );\n\nreturn datepicker.regional[ \"zh-CN\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-AU.js":"/* English/Australia initialisation for the jQuery UI date picker plugin. */\n/* Based on the en-GB initialisation. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-AU\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-AU\" ] );\n\nreturn datepicker.regional[ \"en-AU\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-af.js":"/* Afrikaans initialisation for the jQuery UI date picker plugin. */\n/* Written by Renier Pretorius. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.af = {\n\tcloseText: \"Selekteer\",\n\tprevText: \"Vorige\",\n\tnextText: \"Volgende\",\n\tcurrentText: \"Vandag\",\n\tmonthNames: [ \"Januarie\", \"Februarie\", \"Maart\", \"April\", \"Mei\", \"Junie\",\n\t\"Julie\", \"Augustus\", \"September\", \"Oktober\", \"November\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mrt\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Des\" ],\n\tdayNames: [ \"Sondag\", \"Maandag\", \"Dinsdag\", \"Woensdag\", \"Donderdag\", \"Vrydag\", \"Saterdag\" ],\n\tdayNamesShort: [ \"Son\", \"Maa\", \"Din\", \"Woe\", \"Don\", \"Vry\", \"Sat\" ],\n\tdayNamesMin: [ \"So\", \"Ma\", \"Di\", \"Wo\", \"Do\", \"Vr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.af );\n\nreturn datepicker.regional.af;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hy.js":"/* Armenian(UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Levon Zakaryan (levon.zakaryan@gmail.com)*/\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hy = {\n\tcloseText: \"\u0553\u0561\u056f\u0565\u056c\",\n\tprevText: \"&#x3C;\u0546\u0561\u056d.\",\n\tnextText: \"\u0540\u0561\u057b.&#x3E;\",\n\tcurrentText: \"\u0531\u0575\u057d\u0585\u0580\",\n\tmonthNames: [ \"\u0540\u0578\u0582\u0576\u057e\u0561\u0580\", \"\u0553\u0565\u057f\u0580\u057e\u0561\u0580\", \"\u0544\u0561\u0580\u057f\", \"\u0531\u057a\u0580\u056b\u056c\", \"\u0544\u0561\u0575\u056b\u057d\", \"\u0540\u0578\u0582\u0576\u056b\u057d\",\n\t\"\u0540\u0578\u0582\u056c\u056b\u057d\", \"\u0555\u0563\u0578\u057d\u057f\u0578\u057d\", \"\u054d\u0565\u057a\u057f\u0565\u0574\u0562\u0565\u0580\", \"\u0540\u0578\u056f\u057f\u0565\u0574\u0562\u0565\u0580\", \"\u0546\u0578\u0575\u0565\u0574\u0562\u0565\u0580\", \"\u0534\u0565\u056f\u057f\u0565\u0574\u0562\u0565\u0580\" ],\n\tmonthNamesShort: [ \"\u0540\u0578\u0582\u0576\u057e\", \"\u0553\u0565\u057f\u0580\", \"\u0544\u0561\u0580\u057f\", \"\u0531\u057a\u0580\", \"\u0544\u0561\u0575\u056b\u057d\", \"\u0540\u0578\u0582\u0576\u056b\u057d\",\n\t\"\u0540\u0578\u0582\u056c\", \"\u0555\u0563\u057d\", \"\u054d\u0565\u057a\", \"\u0540\u0578\u056f\", \"\u0546\u0578\u0575\", \"\u0534\u0565\u056f\" ],\n\tdayNames: [ \"\u056f\u056b\u0580\u0561\u056f\u056b\", \"\u0565\u056f\u0578\u0582\u0577\u0561\u0562\u0569\u056b\", \"\u0565\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b\", \"\u0579\u0578\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b\", \"\u0570\u056b\u0576\u0563\u0577\u0561\u0562\u0569\u056b\", \"\u0578\u0582\u0580\u0562\u0561\u0569\", \"\u0577\u0561\u0562\u0561\u0569\" ],\n\tdayNamesShort: [ \"\u056f\u056b\u0580\", \"\u0565\u0580\u056f\", \"\u0565\u0580\u0584\", \"\u0579\u0580\u0584\", \"\u0570\u0576\u0563\", \"\u0578\u0582\u0580\u0562\", \"\u0577\u0562\u0569\" ],\n\tdayNamesMin: [ \"\u056f\u056b\u0580\", \"\u0565\u0580\u056f\", \"\u0565\u0580\u0584\", \"\u0579\u0580\u0584\", \"\u0570\u0576\u0563\", \"\u0578\u0582\u0580\u0562\", \"\u0577\u0562\u0569\" ],\n\tweekHeader: \"\u0547\u0532\u054f\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hy );\n\nreturn datepicker.regional.hy;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ky.js":"/* Kyrgyz (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Sergey Kartashov (ebishkek@yandex.ru). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ky = {\n\tcloseText: \"\u0416\u0430\u0431\u0443\u0443\",\n\tprevText: \"&#x3c;\u041c\u0443\u0440\",\n\tnextText: \"\u041a\u0438\u0439&#x3e;\",\n\tcurrentText: \"\u0411\u04af\u0433\u04af\u043d\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\u044c\", \"\u0424\u0435\u0432\u0440\u0430\u043b\u044c\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\u044c\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\u044c\",\n\t\"\u0418\u044e\u043b\u044c\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c\", \"\u041e\u043a\u0442\u044f\u0431\u0440\u044c\", \"\u041d\u043e\u044f\u0431\u0440\u044c\", \"\u0414\u0435\u043a\u0430\u0431\u0440\u044c\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u0436\u0435\u043a\u0448\u0435\u043c\u0431\u0438\", \"\u0434\u04af\u0439\u0448\u04e9\u043c\u0431\u04af\", \"\u0448\u0435\u0439\u0448\u0435\u043c\u0431\u0438\", \"\u0448\u0430\u0440\u0448\u0435\u043c\u0431\u0438\", \"\u0431\u0435\u0439\u0448\u0435\u043c\u0431\u0438\", \"\u0436\u0443\u043c\u0430\", \"\u0438\u0448\u0435\u043c\u0431\u0438\" ],\n\tdayNamesShort: [ \"\u0436\u0435\u043a\", \"\u0434\u04af\u0439\", \"\u0448\u0435\u0439\", \"\u0448\u0430\u0440\", \"\u0431\u0435\u0439\", \"\u0436\u0443\u043c\", \"\u0438\u0448\u0435\" ],\n\tdayNamesMin: [ \"\u0416\u043a\", \"\u0414\u0448\", \"\u0428\u0448\", \"\u0428\u0440\", \"\u0411\u0448\", \"\u0416\u043c\", \"\u0418\u0448\" ],\n\tweekHeader: \"\u0416\u0443\u043c\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.ky );\n\nreturn datepicker.regional.ky;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ja.js":"/* Japanese initialisation for the jQuery UI date picker plugin. */\n/* Written by Kentaro SATO (kentaro@ranvis.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ja = {\n\tcloseText: \"\u9589\u3058\u308b\",\n\tprevText: \"&#x3C;\u524d\",\n\tnextText: \"\u6b21&#x3E;\",\n\tcurrentText: \"\u4eca\u65e5\",\n\tmonthNames: [ \"1\u6708\", \"2\u6708\", \"3\u6708\", \"4\u6708\", \"5\u6708\", \"6\u6708\",\n\t\"7\u6708\", \"8\u6708\", \"9\u6708\", \"10\u6708\", \"11\u6708\", \"12\u6708\" ],\n\tmonthNamesShort: [ \"1\u6708\", \"2\u6708\", \"3\u6708\", \"4\u6708\", \"5\u6708\", \"6\u6708\",\n\t\"7\u6708\", \"8\u6708\", \"9\u6708\", \"10\u6708\", \"11\u6708\", \"12\u6708\" ],\n\tdayNames: [ \"\u65e5\u66dc\u65e5\", \"\u6708\u66dc\u65e5\", \"\u706b\u66dc\u65e5\", \"\u6c34\u66dc\u65e5\", \"\u6728\u66dc\u65e5\", \"\u91d1\u66dc\u65e5\", \"\u571f\u66dc\u65e5\" ],\n\tdayNamesShort: [ \"\u65e5\", \"\u6708\", \"\u706b\", \"\u6c34\", \"\u6728\", \"\u91d1\", \"\u571f\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u6708\", \"\u706b\", \"\u6c34\", \"\u6728\", \"\u91d1\", \"\u571f\" ],\n\tweekHeader: \"\u9031\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional.ja );\n\nreturn datepicker.regional.ja;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ka.js":"/* Georgian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Lado Lomidze (lado.lomidze@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ka = {\n\tcloseText: \"\u10d3\u10d0\u10ee\u10e3\u10e0\u10d5\u10d0\",\n\tprevText: \"&#x3c; \u10ec\u10d8\u10dc\u10d0\",\n\tnextText: \"\u10e8\u10d4\u10db\u10d3\u10d4\u10d2\u10d8 &#x3e;\",\n\tcurrentText: \"\u10d3\u10e6\u10d4\u10e1\",\n\tmonthNames: [\n\t\t\"\u10d8\u10d0\u10dc\u10d5\u10d0\u10e0\u10d8\",\n\t\t\"\u10d7\u10d4\u10d1\u10d4\u10e0\u10d5\u10d0\u10da\u10d8\",\n\t\t\"\u10db\u10d0\u10e0\u10e2\u10d8\",\n\t\t\"\u10d0\u10de\u10e0\u10d8\u10da\u10d8\",\n\t\t\"\u10db\u10d0\u10d8\u10e1\u10d8\",\n\t\t\"\u10d8\u10d5\u10dc\u10d8\u10e1\u10d8\",\n\t\t\"\u10d8\u10d5\u10da\u10d8\u10e1\u10d8\",\n\t\t\"\u10d0\u10d2\u10d5\u10d8\u10e1\u10e2\u10dd\",\n\t\t\"\u10e1\u10d4\u10e5\u10e2\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10dd\u10e5\u10e2\u10dd\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10dc\u10dd\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10d3\u10d4\u10d9\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\"\n\t],\n\tmonthNamesShort: [ \"\u10d8\u10d0\u10dc\", \"\u10d7\u10d4\u10d1\", \"\u10db\u10d0\u10e0\", \"\u10d0\u10de\u10e0\", \"\u10db\u10d0\u10d8\", \"\u10d8\u10d5\u10dc\", \"\u10d8\u10d5\u10da\", \"\u10d0\u10d2\u10d5\", \"\u10e1\u10d4\u10e5\", \"\u10dd\u10e5\u10e2\", \"\u10dc\u10dd\u10d4\", \"\u10d3\u10d4\u10d9\" ],\n\tdayNames: [ \"\u10d9\u10d5\u10d8\u10e0\u10d0\", \"\u10dd\u10e0\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10e1\u10d0\u10db\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10dd\u10d7\u10ee\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10ee\u10e3\u10d7\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10de\u10d0\u10e0\u10d0\u10e1\u10d9\u10d4\u10d5\u10d8\", \"\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\" ],\n\tdayNamesShort: [ \"\u10d9\u10d5\", \"\u10dd\u10e0\u10e8\", \"\u10e1\u10d0\u10db\", \"\u10dd\u10d7\u10ee\", \"\u10ee\u10e3\u10d7\", \"\u10de\u10d0\u10e0\", \"\u10e8\u10d0\u10d1\" ],\n\tdayNamesMin: [ \"\u10d9\u10d5\", \"\u10dd\u10e0\u10e8\", \"\u10e1\u10d0\u10db\", \"\u10dd\u10d7\u10ee\", \"\u10ee\u10e3\u10d7\", \"\u10de\u10d0\u10e0\", \"\u10e8\u10d0\u10d1\" ],\n\tweekHeader: \"\u10d9\u10d5\u10d8\u10e0\u10d0\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ka );\n\nreturn datepicker.regional.ka;\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-TW.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by Ressol (ressol@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-TW\" ] = {\n\tcloseText: \"\u95dc\u9589\",\n\tprevText: \"&#x3C;\u4e0a\u500b\u6708\",\n\tnextText: \"\u4e0b\u500b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u9031\u65e5\", \"\u9031\u4e00\", \"\u9031\u4e8c\", \"\u9031\u4e09\", \"\u9031\u56db\", \"\u9031\u4e94\", \"\u9031\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u9031\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-TW\" ] );\n\nreturn datepicker.regional[ \"zh-TW\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-pt-BR.js":"/* Brazilian initialisation for the jQuery UI date picker plugin. */\n/* Written by Leonildo Costa Silva (leocsilva@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"pt-BR\" ] = {\n\tcloseText: \"Fechar\",\n\tprevText: \"&#x3C;Anterior\",\n\tnextText: \"Pr\u00f3ximo&#x3E;\",\n\tcurrentText: \"Hoje\",\n\tmonthNames: [ \"Janeiro\", \"Fevereiro\", \"Mar\u00e7o\", \"Abril\", \"Maio\", \"Junho\",\n\t\"Julho\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Dezembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Fev\", \"Mar\", \"Abr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Domingo\",\n\t\t\"Segunda-feira\",\n\t\t\"Ter\u00e7a-feira\",\n\t\t\"Quarta-feira\",\n\t\t\"Quinta-feira\",\n\t\t\"Sexta-feira\",\n\t\t\"S\u00e1bado\"\n\t],\n\tdayNamesShort: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"pt-BR\" ] );\n\nreturn datepicker.regional[ \"pt-BR\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-he.js":"/* Hebrew initialisation for the UI Datepicker extension. */\n/* Written by Amir Hardon (ahardon at gmail dot com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.he = {\n\tcloseText: \"\u05e1\u05d2\u05d5\u05e8\",\n\tprevText: \"&#x3C;\u05d4\u05e7\u05d5\u05d3\u05dd\",\n\tnextText: \"\u05d4\u05d1\u05d0&#x3E;\",\n\tcurrentText: \"\u05d4\u05d9\u05d5\u05dd\",\n\tmonthNames: [ \"\u05d9\u05e0\u05d5\u05d0\u05e8\", \"\u05e4\u05d1\u05e8\u05d5\u05d0\u05e8\", \"\u05de\u05e8\u05e5\", \"\u05d0\u05e4\u05e8\u05d9\u05dc\", \"\u05de\u05d0\u05d9\", \"\u05d9\u05d5\u05e0\u05d9\",\n\t\"\u05d9\u05d5\u05dc\u05d9\", \"\u05d0\u05d5\u05d2\u05d5\u05e1\u05d8\", \"\u05e1\u05e4\u05d8\u05de\u05d1\u05e8\", \"\u05d0\u05d5\u05e7\u05d8\u05d5\u05d1\u05e8\", \"\u05e0\u05d5\u05d1\u05de\u05d1\u05e8\", \"\u05d3\u05e6\u05de\u05d1\u05e8\" ],\n\tmonthNamesShort: [ \"\u05d9\u05e0\u05d5\", \"\u05e4\u05d1\u05e8\", \"\u05de\u05e8\u05e5\", \"\u05d0\u05e4\u05e8\", \"\u05de\u05d0\u05d9\", \"\u05d9\u05d5\u05e0\u05d9\",\n\t\"\u05d9\u05d5\u05dc\u05d9\", \"\u05d0\u05d5\u05d2\", \"\u05e1\u05e4\u05d8\", \"\u05d0\u05d5\u05e7\", \"\u05e0\u05d5\u05d1\", \"\u05d3\u05e6\u05de\" ],\n\tdayNames: [ \"\u05e8\u05d0\u05e9\u05d5\u05df\", \"\u05e9\u05e0\u05d9\", \"\u05e9\u05dc\u05d9\u05e9\u05d9\", \"\u05e8\u05d1\u05d9\u05e2\u05d9\", \"\u05d7\u05de\u05d9\u05e9\u05d9\", \"\u05e9\u05d9\u05e9\u05d9\", \"\u05e9\u05d1\u05ea\" ],\n\tdayNamesShort: [ \"\u05d0'\", \"\u05d1'\", \"\u05d2'\", \"\u05d3'\", \"\u05d4'\", \"\u05d5'\", \"\u05e9\u05d1\u05ea\" ],\n\tdayNamesMin: [ \"\u05d0'\", \"\u05d1'\", \"\u05d2'\", \"\u05d3'\", \"\u05d4'\", \"\u05d5'\", \"\u05e9\u05d1\u05ea\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.he );\n\nreturn datepicker.regional.he;\n\n} );\n","jquery/ui-modules/i18n/datepicker-de-AT.js":"/* German/Austrian initialisation for the jQuery UI date picker plugin. */\n/* Based on the de initialisation. */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"de-AT\" ] = {\n\tcloseText: \"Schlie\u00dfen\",\n\tprevText: \"&#x3C;Zur\u00fcck\",\n\tnextText: \"Vor&#x3E;\",\n\tcurrentText: \"Heute\",\n\tmonthNames: [ \"J\u00e4nner\", \"Februar\", \"M\u00e4rz\", \"April\", \"Mai\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"J\u00e4n\", \"Feb\", \"M\u00e4r\", \"Apr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [ \"Sonntag\", \"Montag\", \"Dienstag\", \"Mittwoch\", \"Donnerstag\", \"Freitag\", \"Samstag\" ],\n\tdayNamesShort: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tdayNamesMin: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"KW\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"de-AT\" ] );\n\nreturn datepicker.regional[ \"de-AT\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-bg.js":"/* Bulgarian initialisation for the jQuery UI date picker plugin. */\n/* Written by Stoyan Kyosev (http://svest.org). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.bg = {\n\tcloseText: \"\u0437\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\u043d\u0430\u0437\u0430\u0434\",\n\tnextText: \"\u043d\u0430\u043f\u0440\u0435\u0434&#x3E;\",\n\tnextBigText: \"&#x3E;&#x3E;\",\n\tcurrentText: \"\u0434\u043d\u0435\u0441\",\n\tmonthNames: [ \"\u042f\u043d\u0443\u0430\u0440\u0438\", \"\u0424\u0435\u0432\u0440\u0443\u0430\u0440\u0438\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0439\", \"\u042e\u043d\u0438\",\n\t\"\u042e\u043b\u0438\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0432\u0440\u0438\", \"\u041e\u043a\u0442\u043e\u043c\u0432\u0440\u0438\", \"\u041d\u043e\u0435\u043c\u0432\u0440\u0438\", \"\u0414\u0435\u043a\u0435\u043c\u0432\u0440\u0438\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0443\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u042e\u043d\u0438\",\n\t\"\u042e\u043b\u0438\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0432\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u043b\u044f\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u043d\u0438\u043a\", \"\u0412\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0421\u0440\u044f\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u044a\u0440\u0442\u044a\u043a\", \"\u041f\u0435\u0442\u044a\u043a\", \"\u0421\u044a\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0412\u0442\u043e\", \"\u0421\u0440\u044f\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u044a\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u044a\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.bg );\n\nreturn datepicker.regional.bg;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sq.js":"/* Albanian initialisation for the jQuery UI date picker plugin. */\n/* Written by Flakron Bytyqi (flakron@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sq = {\n\tcloseText: \"mbylle\",\n\tprevText: \"&#x3C;mbrapa\",\n\tnextText: \"P\u00ebrpara&#x3E;\",\n\tcurrentText: \"sot\",\n\tmonthNames: [ \"Janar\", \"Shkurt\", \"Mars\", \"Prill\", \"Maj\", \"Qershor\",\n\t\"Korrik\", \"Gusht\", \"Shtator\", \"Tetor\", \"N\u00ebntor\", \"Dhjetor\" ],\n\tmonthNamesShort: [ \"Jan\", \"Shk\", \"Mar\", \"Pri\", \"Maj\", \"Qer\",\n\t\"Kor\", \"Gus\", \"Sht\", \"Tet\", \"N\u00ebn\", \"Dhj\" ],\n\tdayNames: [ \"E Diel\", \"E H\u00ebn\u00eb\", \"E Mart\u00eb\", \"E M\u00ebrkur\u00eb\", \"E Enjte\", \"E Premte\", \"E Shtune\" ],\n\tdayNamesShort: [ \"Di\", \"H\u00eb\", \"Ma\", \"M\u00eb\", \"En\", \"Pr\", \"Sh\" ],\n\tdayNamesMin: [ \"Di\", \"H\u00eb\", \"Ma\", \"M\u00eb\", \"En\", \"Pr\", \"Sh\" ],\n\tweekHeader: \"Ja\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sq );\n\nreturn datepicker.regional.sq;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nl-BE.js":"/* Dutch (Belgium) initialisation for the jQuery UI date picker plugin. */\n/* David De Sloovere @DavidDeSloovere */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"nl-BE\" ] = {\n\tcloseText: \"Sluiten\",\n\tprevText: \"\u2190\",\n\tnextText: \"\u2192\",\n\tcurrentText: \"Vandaag\",\n\tmonthNames: [ \"januari\", \"februari\", \"maart\", \"april\", \"mei\", \"juni\",\n\t\"juli\", \"augustus\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mrt\", \"apr\", \"mei\", \"jun\",\n\t\"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"dec\" ],\n\tdayNames: [ \"zondag\", \"maandag\", \"dinsdag\", \"woensdag\", \"donderdag\", \"vrijdag\", \"zaterdag\" ],\n\tdayNamesShort: [ \"zon\", \"maa\", \"din\", \"woe\", \"don\", \"vri\", \"zat\" ],\n\tdayNamesMin: [ \"zo\", \"ma\", \"di\", \"wo\", \"do\", \"vr\", \"za\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"nl-BE\" ] );\n\nreturn datepicker.regional[ \"nl-BE\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-ar-DZ.js":"/* Algerian Arabic Translation for jQuery UI date picker plugin.\n/* Used in most of Maghreb countries, primarily in Algeria, Tunisia, Morocco.\n/* Mohamed Cherif BOUCHELAGHEM -- cherifbouchelaghem@yahoo.fr */\n/* Mohamed Amine HADDAD -- zatamine@gmail.com */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"ar-DZ\" ] = {\n\tcloseText: \"\u0625\u063a\u0644\u0627\u0642\",\n\tprevText: \"&#x3C;\u0627\u0644\u0633\u0627\u0628\u0642\",\n\tnextText: \"\u0627\u0644\u062a\u0627\u0644\u064a&#x3E;\",\n\tcurrentText: \"\u0627\u0644\u064a\u0648\u0645\",\n\tmonthNames: [ \"\u062c\u0627\u0646\u0641\u064a\", \"\u0641\u064a\u0641\u0631\u064a\", \"\u0645\u0627\u0631\u0633\", \"\u0623\u0641\u0631\u064a\u0644\", \"\u0645\u0627\u064a\", \"\u062c\u0648\u0627\u0646\",\n\t\"\u062c\u0648\u064a\u0644\u064a\u0629\", \"\u0623\u0648\u062a\", \"\u0633\u0628\u062a\u0645\u0628\u0631\", \"\u0623\u0643\u062a\u0648\u0628\u0631\", \"\u0646\u0648\u0641\u0645\u0628\u0631\", \"\u062f\u064a\u0633\u0645\u0628\u0631\" ],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesShort: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesMin: [ \"\u062d\", \"\u0646\", \"\u062b\", \"\u0631\", \"\u062e\", \"\u062c\", \"\u0633\" ],\n\tweekHeader: \"\u0623\u0633\u0628\u0648\u0639\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 6,\n\t\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"ar-DZ\" ] );\n\nreturn datepicker.regional[ \"ar-DZ\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr-CA.js":"/* Canadian-French initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"fr-CA\" ] = {\n\tcloseText: \"Fermer\",\n\tprevText: \"Pr\u00e9c\u00e9dent\",\n\tnextText: \"Suivant\",\n\tcurrentText: \"Aujourd'hui\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sem.\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional[ \"fr-CA\" ] );\n\nreturn datepicker.regional[ \"fr-CA\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-GB.js":"/* English/UK initialisation for the jQuery UI date picker plugin. */\n/* Written by Stuart. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-GB\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-GB\" ] );\n\nreturn datepicker.regional[ \"en-GB\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-rm.js":"/* Romansh initialisation for the jQuery UI date picker plugin. */\n/* Written by Yvonne Gienal (yvonne.gienal@educa.ch). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.rm = {\n\tcloseText: \"Serrar\",\n\tprevText: \"&#x3C;Suandant\",\n\tnextText: \"Precedent&#x3E;\",\n\tcurrentText: \"Actual\",\n\tmonthNames: [\n\t\t\"Schaner\",\n\t\t\"Favrer\",\n\t\t\"Mars\",\n\t\t\"Avrigl\",\n\t\t\"Matg\",\n\t\t\"Zercladur\",\n\t\t\"Fanadur\",\n\t\t\"Avust\",\n\t\t\"Settember\",\n\t\t\"October\",\n\t\t\"November\",\n\t\t\"December\"\n\t],\n\tmonthNamesShort: [\n\t\t\"Scha\",\n\t\t\"Fev\",\n\t\t\"Mar\",\n\t\t\"Avr\",\n\t\t\"Matg\",\n\t\t\"Zer\",\n\t\t\"Fan\",\n\t\t\"Avu\",\n\t\t\"Sett\",\n\t\t\"Oct\",\n\t\t\"Nov\",\n\t\t\"Dec\"\n\t],\n\tdayNames: [ \"Dumengia\", \"Glindesdi\", \"Mardi\", \"Mesemna\", \"Gievgia\", \"Venderdi\", \"Sonda\" ],\n\tdayNamesShort: [ \"Dum\", \"Gli\", \"Mar\", \"Mes\", \"Gie\", \"Ven\", \"Som\" ],\n\tdayNamesMin: [ \"Du\", \"Gl\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"So\" ],\n\tweekHeader: \"emna\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.rm );\n\nreturn datepicker.regional.rm;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hr.js":"/* Croatian i18n for the jQuery UI date picker plugin. */\n/* Written by Vjekoslav Nesek. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hr = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Sije\u010danj\", \"Velja\u010da\", \"O\u017eujak\", \"Travanj\", \"Svibanj\", \"Lipanj\",\n\t\"Srpanj\", \"Kolovoz\", \"Rujan\", \"Listopad\", \"Studeni\", \"Prosinac\" ],\n\tmonthNamesShort: [ \"Sij\", \"Velj\", \"O\u017eu\", \"Tra\", \"Svi\", \"Lip\",\n\t\"Srp\", \"Kol\", \"Ruj\", \"Lis\", \"Stu\", \"Pro\" ],\n\tdayNames: [ \"Nedjelja\", \"Ponedjeljak\", \"Utorak\", \"Srijeda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sri\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Tje\",\n\tdateFormat: \"dd.mm.yy.\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hr );\n\nreturn datepicker.regional.hr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ms.js":"/* Malaysian initialisation for the jQuery UI date picker plugin. */\n/* Written by Mohd Nawawi Mohamad Jamili (nawawi@ronggeng.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ms = {\n\tcloseText: \"Tutup\",\n\tprevText: \"&#x3C;Sebelum\",\n\tnextText: \"Selepas&#x3E;\",\n\tcurrentText: \"hari ini\",\n\tmonthNames: [ \"Januari\", \"Februari\", \"Mac\", \"April\", \"Mei\", \"Jun\",\n\t\"Julai\", \"Ogos\", \"September\", \"Oktober\", \"November\", \"Disember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mac\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Ogo\", \"Sep\", \"Okt\", \"Nov\", \"Dis\" ],\n\tdayNames: [ \"Ahad\", \"Isnin\", \"Selasa\", \"Rabu\", \"Khamis\", \"Jumaat\", \"Sabtu\" ],\n\tdayNamesShort: [ \"Aha\", \"Isn\", \"Sel\", \"Rab\", \"kha\", \"Jum\", \"Sab\" ],\n\tdayNamesMin: [ \"Ah\", \"Is\", \"Se\", \"Ra\", \"Kh\", \"Ju\", \"Sa\" ],\n\tweekHeader: \"Mg\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ms );\n\nreturn datepicker.regional.ms;\n\n} );\n","jquery/ui-modules/i18n/datepicker-th.js":"/* Thai initialisation for the jQuery UI date picker plugin. */\n/* Written by pipo (pipo@sixhead.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.th = {\n\tcloseText: \"\u0e1b\u0e34\u0e14\",\n\tprevText: \"&#xAB;&#xA0;\u0e22\u0e49\u0e2d\u0e19\",\n\tnextText: \"\u0e16\u0e31\u0e14\u0e44\u0e1b&#xA0;&#xBB;\",\n\tcurrentText: \"\u0e27\u0e31\u0e19\u0e19\u0e35\u0e49\",\n\tmonthNames: [ \"\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21\", \"\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c\", \"\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21\", \"\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19\", \"\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21\", \"\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19\",\n\t\"\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21\", \"\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21\", \"\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19\", \"\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21\", \"\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19\", \"\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21\" ],\n\tmonthNamesShort: [ \"\u0e21.\u0e04.\", \"\u0e01.\u0e1e.\", \"\u0e21\u0e35.\u0e04.\", \"\u0e40\u0e21.\u0e22.\", \"\u0e1e.\u0e04.\", \"\u0e21\u0e34.\u0e22.\",\n\t\"\u0e01.\u0e04.\", \"\u0e2a.\u0e04.\", \"\u0e01.\u0e22.\", \"\u0e15.\u0e04.\", \"\u0e1e.\u0e22.\", \"\u0e18.\u0e04.\" ],\n\tdayNames: [ \"\u0e2d\u0e32\u0e17\u0e34\u0e15\u0e22\u0e4c\", \"\u0e08\u0e31\u0e19\u0e17\u0e23\u0e4c\", \"\u0e2d\u0e31\u0e07\u0e04\u0e32\u0e23\", \"\u0e1e\u0e38\u0e18\", \"\u0e1e\u0e24\u0e2b\u0e31\u0e2a\u0e1a\u0e14\u0e35\", \"\u0e28\u0e38\u0e01\u0e23\u0e4c\", \"\u0e40\u0e2a\u0e32\u0e23\u0e4c\" ],\n\tdayNamesShort: [ \"\u0e2d\u0e32.\", \"\u0e08.\", \"\u0e2d.\", \"\u0e1e.\", \"\u0e1e\u0e24.\", \"\u0e28.\", \"\u0e2a.\" ],\n\tdayNamesMin: [ \"\u0e2d\u0e32.\", \"\u0e08.\", \"\u0e2d.\", \"\u0e1e.\", \"\u0e1e\u0e24.\", \"\u0e28.\", \"\u0e2a.\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.th );\n\nreturn datepicker.regional.th;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fi.js":"/* Finnish initialisation for the jQuery UI date picker plugin. */\n/* Written by Harri Kilpi\u00f6 (harrikilpio@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fi = {\n\tcloseText: \"Sulje\",\n\tprevText: \"&#xAB;Edellinen\",\n\tnextText: \"Seuraava&#xBB;\",\n\tcurrentText: \"T\u00e4n\u00e4\u00e4n\",\n\tmonthNames: [ \"Tammikuu\", \"Helmikuu\", \"Maaliskuu\", \"Huhtikuu\", \"Toukokuu\", \"Kes\u00e4kuu\",\n\t\"Hein\u00e4kuu\", \"Elokuu\", \"Syyskuu\", \"Lokakuu\", \"Marraskuu\", \"Joulukuu\" ],\n\tmonthNamesShort: [ \"Tammi\", \"Helmi\", \"Maalis\", \"Huhti\", \"Touko\", \"Kes\u00e4\",\n\t\"Hein\u00e4\", \"Elo\", \"Syys\", \"Loka\", \"Marras\", \"Joulu\" ],\n\tdayNamesShort: [ \"Su\", \"Ma\", \"Ti\", \"Ke\", \"To\", \"Pe\", \"La\" ],\n\tdayNames: [ \"Sunnuntai\", \"Maanantai\", \"Tiistai\", \"Keskiviikko\", \"Torstai\", \"Perjantai\", \"Lauantai\" ],\n\tdayNamesMin: [ \"Su\", \"Ma\", \"Ti\", \"Ke\", \"To\", \"Pe\", \"La\" ],\n\tweekHeader: \"Vk\",\n\tdateFormat: \"d.m.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fi );\n\nreturn datepicker.regional.fi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ru.js":"/* Russian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Andrew Stromnov (stromnov@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ru = {\n\tcloseText: \"\u0417\u0430\u043a\u0440\u044b\u0442\u044c\",\n\tprevText: \"&#x3C;\u041f\u0440\u0435\u0434\",\n\tnextText: \"\u0421\u043b\u0435\u0434&#x3E;\",\n\tcurrentText: \"\u0421\u0435\u0433\u043e\u0434\u043d\u044f\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\u044c\", \"\u0424\u0435\u0432\u0440\u0430\u043b\u044c\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\u044c\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\u044c\",\n\t\"\u0418\u044e\u043b\u044c\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c\", \"\u041e\u043a\u0442\u044f\u0431\u0440\u044c\", \"\u041d\u043e\u044f\u0431\u0440\u044c\", \"\u0414\u0435\u043a\u0430\u0431\u0440\u044c\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435\", \"\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a\", \"\u0432\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0441\u0440\u0435\u0434\u0430\", \"\u0447\u0435\u0442\u0432\u0435\u0440\u0433\", \"\u043f\u044f\u0442\u043d\u0438\u0446\u0430\", \"\u0441\u0443\u0431\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u0432\u0441\u043a\", \"\u043f\u043d\u0434\", \"\u0432\u0442\u0440\", \"\u0441\u0440\u0434\", \"\u0447\u0442\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u0412\u0441\", \"\u041f\u043d\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0442\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u041d\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ru );\n\nreturn datepicker.regional.ru;\n\n} );\n","jquery/ui-modules/i18n/datepicker-eu.js":"/* Karrikas-ek itzulia (karrikas@karrikas.com) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.eu = {\n\tcloseText: \"Egina\",\n\tprevText: \"&#x3C;Aur\",\n\tnextText: \"Hur&#x3E;\",\n\tcurrentText: \"Gaur\",\n\tmonthNames: [ \"urtarrila\", \"otsaila\", \"martxoa\", \"apirila\", \"maiatza\", \"ekaina\",\n\t\t\"uztaila\", \"abuztua\", \"iraila\", \"urria\", \"azaroa\", \"abendua\" ],\n\tmonthNamesShort: [ \"urt.\", \"ots.\", \"mar.\", \"api.\", \"mai.\", \"eka.\",\n\t\t\"uzt.\", \"abu.\", \"ira.\", \"urr.\", \"aza.\", \"abe.\" ],\n\tdayNames: [ \"igandea\", \"astelehena\", \"asteartea\", \"asteazkena\", \"osteguna\", \"ostirala\", \"larunbata\" ],\n\tdayNamesShort: [ \"ig.\", \"al.\", \"ar.\", \"az.\", \"og.\", \"ol.\", \"lr.\" ],\n\tdayNamesMin: [ \"ig\", \"al\", \"ar\", \"az\", \"og\", \"ol\", \"lr\" ],\n\tweekHeader: \"As\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.eu );\n\nreturn datepicker.regional.eu;\n\n} );\n","jquery/ui-modules/i18n/datepicker-mk.js":"/* Macedonian i18n for the jQuery UI date picker plugin. */\n/* Written by Stojce Slavkovski. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.mk = {\n\tcloseText: \"\u0417\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0414\u0435\u043d\u0435\u0441\",\n\tmonthNames: [ \"\u0408\u0430\u043d\u0443\u0430\u0440\u0438\", \"\u0424\u0435\u0432\u0440\u0443\u0430\u0440\u0438\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\u0438\",\n\t\"\u0408\u0443\u043b\u0438\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0432\u0440\u0438\", \"\u041e\u043a\u0442\u043e\u043c\u0432\u0440\u0438\", \"\u041d\u043e\u0435\u043c\u0432\u0440\u0438\", \"\u0414\u0435\u043a\u0435\u043c\u0432\u0440\u0438\" ],\n\tmonthNamesShort: [ \"\u0408\u0430\u043d\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0435\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u043b\u0430\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u043d\u0438\u043a\", \"\u0412\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0421\u0440\u0435\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u0440\u0442\u043e\u043a\", \"\u041f\u0435\u0442\u043e\u043a\", \"\u0421\u0430\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0412\u0442\u043e\", \"\u0421\u0440\u0435\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u0430\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u0430\" ],\n\tweekHeader: \"\u0421\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.mk );\n\nreturn datepicker.regional.mk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-no.js":"/* Norwegian initialisation for the jQuery UI date picker plugin. */\n/* Written by Naimdjon Takhirov (naimdjon@gmail.com). */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.no = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;Forrige\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"s\u00f8n\", \"man\", \"tir\", \"ons\", \"tor\", \"fre\", \"l\u00f8r\" ],\n\tdayNames: [ \"s\u00f8ndag\", \"mandag\", \"tirsdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f8rdag\" ],\n\tdayNamesMin: [ \"s\u00f8\", \"ma\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f8\" ],\n\tweekHeader: \"Uke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.no );\n\nreturn datepicker.regional.no;\n\n} );\n","jquery/ui-modules/i18n/datepicker-el.js":"/* Greek (el) initialisation for the jQuery UI date picker plugin. */\n/* Written by Alex Cicovic (http://www.alexcicovic.com) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.el = {\n\tcloseText: \"\u039a\u03bb\u03b5\u03af\u03c3\u03b9\u03bc\u03bf\",\n\tprevText: \"\u03a0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf\u03c2\",\n\tnextText: \"\u0395\u03c0\u03cc\u03bc\u03b5\u03bd\u03bf\u03c2\",\n\tcurrentText: \"\u03a3\u03ae\u03bc\u03b5\u03c1\u03b1\",\n\tmonthNames: [ \"\u0399\u03b1\u03bd\u03bf\u03c5\u03ac\u03c1\u03b9\u03bf\u03c2\", \"\u03a6\u03b5\u03b2\u03c1\u03bf\u03c5\u03ac\u03c1\u03b9\u03bf\u03c2\", \"\u039c\u03ac\u03c1\u03c4\u03b9\u03bf\u03c2\", \"\u0391\u03c0\u03c1\u03af\u03bb\u03b9\u03bf\u03c2\", \"\u039c\u03ac\u03b9\u03bf\u03c2\", \"\u0399\u03bf\u03cd\u03bd\u03b9\u03bf\u03c2\",\n\t\"\u0399\u03bf\u03cd\u03bb\u03b9\u03bf\u03c2\", \"\u0391\u03cd\u03b3\u03bf\u03c5\u03c3\u03c4\u03bf\u03c2\", \"\u03a3\u03b5\u03c0\u03c4\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u039f\u03ba\u03c4\u03ce\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u039d\u03bf\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u0394\u03b5\u03ba\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\" ],\n\tmonthNamesShort: [ \"\u0399\u03b1\u03bd\", \"\u03a6\u03b5\u03b2\", \"\u039c\u03b1\u03c1\", \"\u0391\u03c0\u03c1\", \"\u039c\u03b1\u03b9\", \"\u0399\u03bf\u03c5\u03bd\",\n\t\"\u0399\u03bf\u03c5\u03bb\", \"\u0391\u03c5\u03b3\", \"\u03a3\u03b5\u03c0\", \"\u039f\u03ba\u03c4\", \"\u039d\u03bf\u03b5\", \"\u0394\u03b5\u03ba\" ],\n\tdayNames: [ \"\u039a\u03c5\u03c1\u03b9\u03b1\u03ba\u03ae\", \"\u0394\u03b5\u03c5\u03c4\u03ad\u03c1\u03b1\", \"\u03a4\u03c1\u03af\u03c4\u03b7\", \"\u03a4\u03b5\u03c4\u03ac\u03c1\u03c4\u03b7\", \"\u03a0\u03ad\u03bc\u03c0\u03c4\u03b7\", \"\u03a0\u03b1\u03c1\u03b1\u03c3\u03ba\u03b5\u03c5\u03ae\", \"\u03a3\u03ac\u03b2\u03b2\u03b1\u03c4\u03bf\" ],\n\tdayNamesShort: [ \"\u039a\u03c5\u03c1\", \"\u0394\u03b5\u03c5\", \"\u03a4\u03c1\u03b9\", \"\u03a4\u03b5\u03c4\", \"\u03a0\u03b5\u03bc\", \"\u03a0\u03b1\u03c1\", \"\u03a3\u03b1\u03b2\" ],\n\tdayNamesMin: [ \"\u039a\u03c5\", \"\u0394\u03b5\", \"\u03a4\u03c1\", \"\u03a4\u03b5\", \"\u03a0\u03b5\", \"\u03a0\u03b1\", \"\u03a3\u03b1\" ],\n\tweekHeader: \"\u0395\u03b2\u03b4\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.el );\n\nreturn datepicker.regional.el;\n\n} );\n","jquery/ui-modules/i18n/datepicker-et.js":"/* Estonian initialisation for the jQuery UI date picker plugin. */\n/* Written by Mart S\u00f5mermaa (mrts.pydev at gmail com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.et = {\n\tcloseText: \"Sulge\",\n\tprevText: \"Eelnev\",\n\tnextText: \"J\u00e4rgnev\",\n\tcurrentText: \"T\u00e4na\",\n\tmonthNames: [ \"Jaanuar\", \"Veebruar\", \"M\u00e4rts\", \"Aprill\", \"Mai\", \"Juuni\",\n\t\"Juuli\", \"August\", \"September\", \"Oktoober\", \"November\", \"Detsember\" ],\n\tmonthNamesShort: [ \"Jaan\", \"Veebr\", \"M\u00e4rts\", \"Apr\", \"Mai\", \"Juuni\",\n\t\"Juuli\", \"Aug\", \"Sept\", \"Okt\", \"Nov\", \"Dets\" ],\n\tdayNames: [\n\t\t\"P\u00fchap\u00e4ev\",\n\t\t\"Esmasp\u00e4ev\",\n\t\t\"Teisip\u00e4ev\",\n\t\t\"Kolmap\u00e4ev\",\n\t\t\"Neljap\u00e4ev\",\n\t\t\"Reede\",\n\t\t\"Laup\u00e4ev\"\n\t],\n\tdayNamesShort: [ \"P\u00fchap\", \"Esmasp\", \"Teisip\", \"Kolmap\", \"Neljap\", \"Reede\", \"Laup\" ],\n\tdayNamesMin: [ \"P\", \"E\", \"T\", \"K\", \"N\", \"R\", \"L\" ],\n\tweekHeader: \"n\u00e4d\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.et );\n\nreturn datepicker.regional.et;\n\n} );\n","jquery/ui-modules/i18n/datepicker-is.js":"/* Icelandic initialisation for the jQuery UI date picker plugin. */\n/* Written by Haukur H. Thorsson (haukur@eskill.is). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.is = {\n\tcloseText: \"Loka\",\n\tprevText: \"&#x3C; Fyrri\",\n\tnextText: \"N\u00e6sti &#x3E;\",\n\tcurrentText: \"\u00cd dag\",\n\tmonthNames: [ \"Jan\u00faar\", \"Febr\u00faar\", \"Mars\", \"Apr\u00edl\", \"Ma\u00ed\", \"J\u00fan\u00ed\",\n\t\"J\u00fal\u00ed\", \"\u00c1g\u00fast\", \"September\", \"Okt\u00f3ber\", \"N\u00f3vember\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Ma\u00ed\", \"J\u00fan\",\n\t\"J\u00fal\", \"\u00c1g\u00fa\", \"Sep\", \"Okt\", \"N\u00f3v\", \"Des\" ],\n\tdayNames: [\n\t\t\"Sunnudagur\",\n\t\t\"M\u00e1nudagur\",\n\t\t\"\u00deri\u00f0judagur\",\n\t\t\"Mi\u00f0vikudagur\",\n\t\t\"Fimmtudagur\",\n\t\t\"F\u00f6studagur\",\n\t\t\"Laugardagur\"\n\t],\n\tdayNamesShort: [ \"Sun\", \"M\u00e1n\", \"\u00deri\", \"Mi\u00f0\", \"Fim\", \"F\u00f6s\", \"Lau\" ],\n\tdayNamesMin: [ \"Su\", \"M\u00e1\", \"\u00der\", \"Mi\", \"Fi\", \"F\u00f6\", \"La\" ],\n\tweekHeader: \"Vika\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.is );\n\nreturn datepicker.regional.is;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sl.js":"/* Slovenian initialisation for the jQuery UI date picker plugin. */\n/* Written by Jaka Jancar (jaka@kubje.org). */\n/* c = \u010d, s = \u0161 z = \u017e C = \u010c S = \u0160 Z = \u017d */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sl = {\n\tcloseText: \"Zapri\",\n\tprevText: \"&#x3C;Prej\u0161nji\",\n\tnextText: \"Naslednji&#x3E;\",\n\tcurrentText: \"Trenutni\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Marec\", \"April\", \"Maj\", \"Junij\",\n\t\"Julij\", \"Avgust\", \"September\", \"Oktober\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljek\", \"Torek\", \"Sreda\", \"\u010cetrtek\", \"Petek\", \"Sobota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Tor\", \"Sre\", \"\u010cet\", \"Pet\", \"Sob\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"To\", \"Sr\", \"\u010ce\", \"Pe\", \"So\" ],\n\tweekHeader: \"Teden\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sl );\n\nreturn datepicker.regional.sl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nn.js":"/* Norwegian Nynorsk initialisation for the jQuery UI date picker plugin. */\n/* Written by Bj\u00f8rn Johansen (post@bjornjohansen.no). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nn = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;F\u00f8rre\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"sun\", \"m\u00e5n\", \"tys\", \"ons\", \"tor\", \"fre\", \"lau\" ],\n\tdayNames: [ \"sundag\", \"m\u00e5ndag\", \"tysdag\", \"onsdag\", \"torsdag\", \"fredag\", \"laurdag\" ],\n\tdayNamesMin: [ \"su\", \"m\u00e5\", \"ty\", \"on\", \"to\", \"fr\", \"la\" ],\n\tweekHeader: \"Veke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.nn );\n\nreturn datepicker.regional.nn;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ko.js":"/* Korean initialisation for the jQuery calendar extension. */\n/* Written by DaeKwon Kang (ncrash.dk@gmail.com), Edited by Genie and Myeongjin Lee. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ko = {\n\tcloseText: \"\ub2eb\uae30\",\n\tprevText: \"\uc774\uc804\ub2ec\",\n\tnextText: \"\ub2e4\uc74c\ub2ec\",\n\tcurrentText: \"\uc624\ub298\",\n\tmonthNames: [ \"1\uc6d4\", \"2\uc6d4\", \"3\uc6d4\", \"4\uc6d4\", \"5\uc6d4\", \"6\uc6d4\",\n\t\"7\uc6d4\", \"8\uc6d4\", \"9\uc6d4\", \"10\uc6d4\", \"11\uc6d4\", \"12\uc6d4\" ],\n\tmonthNamesShort: [ \"1\uc6d4\", \"2\uc6d4\", \"3\uc6d4\", \"4\uc6d4\", \"5\uc6d4\", \"6\uc6d4\",\n\t\"7\uc6d4\", \"8\uc6d4\", \"9\uc6d4\", \"10\uc6d4\", \"11\uc6d4\", \"12\uc6d4\" ],\n\tdayNames: [ \"\uc77c\uc694\uc77c\", \"\uc6d4\uc694\uc77c\", \"\ud654\uc694\uc77c\", \"\uc218\uc694\uc77c\", \"\ubaa9\uc694\uc77c\", \"\uae08\uc694\uc77c\", \"\ud1a0\uc694\uc77c\" ],\n\tdayNamesShort: [ \"\uc77c\", \"\uc6d4\", \"\ud654\", \"\uc218\", \"\ubaa9\", \"\uae08\", \"\ud1a0\" ],\n\tdayNamesMin: [ \"\uc77c\", \"\uc6d4\", \"\ud654\", \"\uc218\", \"\ubaa9\", \"\uae08\", \"\ud1a0\" ],\n\tweekHeader: \"\uc8fc\",\n\tdateFormat: \"yy. m. d.\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\ub144\" };\ndatepicker.setDefaults( datepicker.regional.ko );\n\nreturn datepicker.regional.ko;\n\n} );\n","jquery/ui-modules/i18n/datepicker-pt.js":"/* Portuguese initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.pt = {\n\tcloseText: \"Fechar\",\n\tprevText: \"Anterior\",\n\tnextText: \"Seguinte\",\n\tcurrentText: \"Hoje\",\n\tmonthNames: [ \"Janeiro\", \"Fevereiro\", \"Mar\u00e7o\", \"Abril\", \"Maio\", \"Junho\",\n\t\"Julho\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Dezembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Fev\", \"Mar\", \"Abr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Domingo\",\n\t\t\"Segunda-feira\",\n\t\t\"Ter\u00e7a-feira\",\n\t\t\"Quarta-feira\",\n\t\t\"Quinta-feira\",\n\t\t\"Sexta-feira\",\n\t\t\"S\u00e1bado\"\n\t],\n\tdayNamesShort: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tweekHeader: \"Sem\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.pt );\n\nreturn datepicker.regional.pt;\n\n} );\n","jquery/ui-modules/i18n/datepicker-vi.js":"/* Vietnamese initialisation for the jQuery UI date picker plugin. */\n/* Translated by Le Thanh Huy (lthanhhuy@cit.ctu.edu.vn). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.vi = {\n\tcloseText: \"\u0110\u00f3ng\",\n\tprevText: \"&#x3C;Tr\u01b0\u1edbc\",\n\tnextText: \"Ti\u1ebfp&#x3E;\",\n\tcurrentText: \"H\u00f4m nay\",\n\tmonthNames: [ \"Th\u00e1ng M\u1ed9t\", \"Th\u00e1ng Hai\", \"Th\u00e1ng Ba\", \"Th\u00e1ng T\u01b0\", \"Th\u00e1ng N\u0103m\", \"Th\u00e1ng S\u00e1u\",\n\t\"Th\u00e1ng B\u1ea3y\", \"Th\u00e1ng T\u00e1m\", \"Th\u00e1ng Ch\u00edn\", \"Th\u00e1ng M\u01b0\u1eddi\", \"Th\u00e1ng M\u01b0\u1eddi M\u1ed9t\", \"Th\u00e1ng M\u01b0\u1eddi Hai\" ],\n\tmonthNamesShort: [ \"Th\u00e1ng 1\", \"Th\u00e1ng 2\", \"Th\u00e1ng 3\", \"Th\u00e1ng 4\", \"Th\u00e1ng 5\", \"Th\u00e1ng 6\",\n\t\"Th\u00e1ng 7\", \"Th\u00e1ng 8\", \"Th\u00e1ng 9\", \"Th\u00e1ng 10\", \"Th\u00e1ng 11\", \"Th\u00e1ng 12\" ],\n\tdayNames: [ \"Ch\u1ee7 Nh\u1eadt\", \"Th\u1ee9 Hai\", \"Th\u1ee9 Ba\", \"Th\u1ee9 T\u01b0\", \"Th\u1ee9 N\u0103m\", \"Th\u1ee9 S\u00e1u\", \"Th\u1ee9 B\u1ea3y\" ],\n\tdayNamesShort: [ \"CN\", \"T2\", \"T3\", \"T4\", \"T5\", \"T6\", \"T7\" ],\n\tdayNamesMin: [ \"CN\", \"T2\", \"T3\", \"T4\", \"T5\", \"T6\", \"T7\" ],\n\tweekHeader: \"Tu\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.vi );\n\nreturn datepicker.regional.vi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lv.js":"/* Latvian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* @author Arturas Paleicikas <arturas.paleicikas@metasite.net> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lv = {\n\tcloseText: \"Aizv\u0113rt\",\n\tprevText: \"Iepr.\",\n\tnextText: \"N\u0101k.\",\n\tcurrentText: \"\u0160odien\",\n\tmonthNames: [ \"Janv\u0101ris\", \"Febru\u0101ris\", \"Marts\", \"Apr\u012blis\", \"Maijs\", \"J\u016bnijs\",\n\t\"J\u016blijs\", \"Augusts\", \"Septembris\", \"Oktobris\", \"Novembris\", \"Decembris\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mai\", \"J\u016bn\",\n\t\"J\u016bl\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [\n\t\t\"sv\u0113tdiena\",\n\t\t\"pirmdiena\",\n\t\t\"otrdiena\",\n\t\t\"tre\u0161diena\",\n\t\t\"ceturtdiena\",\n\t\t\"piektdiena\",\n\t\t\"sestdiena\"\n\t],\n\tdayNamesShort: [ \"svt\", \"prm\", \"otr\", \"tre\", \"ctr\", \"pkt\", \"sst\" ],\n\tdayNamesMin: [ \"Sv\", \"Pr\", \"Ot\", \"Tr\", \"Ct\", \"Pk\", \"Ss\" ],\n\tweekHeader: \"Ned.\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lv );\n\nreturn datepicker.regional.lv;\n\n} );\n","jquery/ui-modules/i18n/datepicker-kk.js":"/* Kazakh (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Dmitriy Karasyov (dmitriy.karasyov@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.kk = {\n\tcloseText: \"\u0416\u0430\u0431\u0443\",\n\tprevText: \"&#x3C;\u0410\u043b\u0434\u044b\u04a3\u0493\u044b\",\n\tnextText: \"\u041a\u0435\u043b\u0435\u0441\u0456&#x3E;\",\n\tcurrentText: \"\u0411\u04af\u0433\u0456\u043d\",\n\tmonthNames: [ \"\u049a\u0430\u04a3\u0442\u0430\u0440\", \"\u0410\u049b\u043f\u0430\u043d\", \"\u041d\u0430\u0443\u0440\u044b\u0437\", \"\u0421\u04d9\u0443\u0456\u0440\", \"\u041c\u0430\u043c\u044b\u0440\", \"\u041c\u0430\u0443\u0441\u044b\u043c\",\n\t\"\u0428\u0456\u043b\u0434\u0435\", \"\u0422\u0430\u043c\u044b\u0437\", \"\u049a\u044b\u0440\u043a\u04af\u0439\u0435\u043a\", \"\u049a\u0430\u0437\u0430\u043d\", \"\u049a\u0430\u0440\u0430\u0448\u0430\", \"\u0416\u0435\u043b\u0442\u043e\u049b\u0441\u0430\u043d\" ],\n\tmonthNamesShort: [ \"\u049a\u0430\u04a3\", \"\u0410\u049b\u043f\", \"\u041d\u0430\u0443\", \"\u0421\u04d9\u0443\", \"\u041c\u0430\u043c\", \"\u041c\u0430\u0443\",\n\t\"\u0428\u0456\u043b\", \"\u0422\u0430\u043c\", \"\u049a\u044b\u0440\", \"\u049a\u0430\u0437\", \"\u049a\u0430\u0440\", \"\u0416\u0435\u043b\" ],\n\tdayNames: [ \"\u0416\u0435\u043a\u0441\u0435\u043d\u0431\u0456\", \"\u0414\u04af\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0421\u0435\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0421\u04d9\u0440\u0441\u0435\u043d\u0431\u0456\", \"\u0411\u0435\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0416\u04b1\u043c\u0430\", \"\u0421\u0435\u043d\u0431\u0456\" ],\n\tdayNamesShort: [ \"\u0436\u043a\u0441\", \"\u0434\u0441\u043d\", \"\u0441\u0441\u043d\", \"\u0441\u0440\u0441\", \"\u0431\u0441\u043d\", \"\u0436\u043c\u0430\", \"\u0441\u043d\u0431\" ],\n\tdayNamesMin: [ \"\u0416\u043a\", \"\u0414\u0441\", \"\u0421\u0441\", \"\u0421\u0440\", \"\u0411\u0441\", \"\u0416\u043c\", \"\u0421\u043d\" ],\n\tweekHeader: \"\u041d\u0435\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.kk );\n\nreturn datepicker.regional.kk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-it-CH.js":"/* Italian initialisation for the jQuery UI date picker plugin. */\n/* Written by Antonello Pasella (antonello.pasella@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"it-CH\" ] = {\n\tcloseText: \"Chiudi\",\n\tprevText: \"&#x3C;Prec\",\n\tnextText: \"Succ&#x3E;\",\n\tcurrentText: \"Oggi\",\n\tmonthNames: [ \"Gennaio\", \"Febbraio\", \"Marzo\", \"Aprile\", \"Maggio\", \"Giugno\",\n\t\t\"Luglio\", \"Agosto\", \"Settembre\", \"Ottobre\", \"Novembre\", \"Dicembre\" ],\n\tmonthNamesShort: [ \"Gen\", \"Feb\", \"Mar\", \"Apr\", \"Mag\", \"Giu\",\n\t\t\"Lug\", \"Ago\", \"Set\", \"Ott\", \"Nov\", \"Dic\" ],\n\tdayNames: [ \"Domenica\", \"Luned\u00ec\", \"Marted\u00ec\", \"Mercoled\u00ec\", \"Gioved\u00ec\", \"Venerd\u00ec\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"Mer\", \"Gio\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"it-CH\" ] );\n\nreturn datepicker.regional[ \"it-CH\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-gl.js":"/* Galician localization for 'UI date picker' jQuery extension. */\n/* Translated by Jorge Barreiro <yortx.barry@gmail.com>. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.gl = {\n\tcloseText: \"Pechar\",\n\tprevText: \"&#x3C;Ant\",\n\tnextText: \"Seg&#x3E;\",\n\tcurrentText: \"Hoxe\",\n\tmonthNames: [ \"Xaneiro\", \"Febreiro\", \"Marzo\", \"Abril\", \"Maio\", \"Xu\u00f1o\",\n\t\"Xullo\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Decembro\" ],\n\tmonthNamesShort: [ \"Xan\", \"Feb\", \"Mar\", \"Abr\", \"Mai\", \"Xu\u00f1\",\n\t\"Xul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Domingo\", \"Luns\", \"Martes\", \"M\u00e9rcores\", \"Xoves\", \"Venres\", \"S\u00e1bado\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"M\u00e9r\", \"Xov\", \"Ven\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"M\u00e9\", \"Xo\", \"Ve\", \"S\u00e1\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.gl );\n\nreturn datepicker.regional.gl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-pl.js":"/* Polish initialisation for the jQuery UI date picker plugin. */\n/* Written by Jacek Wysocki (jacek.wysocki@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.pl = {\n\tcloseText: \"Zamknij\",\n\tprevText: \"&#x3C;Poprzedni\",\n\tnextText: \"Nast\u0119pny&#x3E;\",\n\tcurrentText: \"Dzi\u015b\",\n\tmonthNames: [ \"Stycze\u0144\", \"Luty\", \"Marzec\", \"Kwiecie\u0144\", \"Maj\", \"Czerwiec\",\n\t\"Lipiec\", \"Sierpie\u0144\", \"Wrzesie\u0144\", \"Pa\u017adziernik\", \"Listopad\", \"Grudzie\u0144\" ],\n\tmonthNamesShort: [ \"Sty\", \"Lu\", \"Mar\", \"Kw\", \"Maj\", \"Cze\",\n\t\"Lip\", \"Sie\", \"Wrz\", \"Pa\", \"Lis\", \"Gru\" ],\n\tdayNames: [ \"Niedziela\", \"Poniedzia\u0142ek\", \"Wtorek\", \"\u015aroda\", \"Czwartek\", \"Pi\u0105tek\", \"Sobota\" ],\n\tdayNamesShort: [ \"Nie\", \"Pn\", \"Wt\", \"\u015ar\", \"Czw\", \"Pt\", \"So\" ],\n\tdayNamesMin: [ \"N\", \"Pn\", \"Wt\", \"\u015ar\", \"Cz\", \"Pt\", \"So\" ],\n\tweekHeader: \"Tydz\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.pl );\n\nreturn datepicker.regional.pl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-eo.js":"/* Esperanto initialisation for the jQuery UI date picker plugin. */\n/* Written by Olivier M. (olivierweb@ifrance.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.eo = {\n\tcloseText: \"Fermi\",\n\tprevText: \"&#x3C;Anta\",\n\tnextText: \"Sekv&#x3E;\",\n\tcurrentText: \"Nuna\",\n\tmonthNames: [ \"Januaro\", \"Februaro\", \"Marto\", \"Aprilo\", \"Majo\", \"Junio\",\n\t\"Julio\", \"A\u016dgusto\", \"Septembro\", \"Oktobro\", \"Novembro\", \"Decembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"A\u016dg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Diman\u0109o\", \"Lundo\", \"Mardo\", \"Merkredo\", \"\u0134a\u016ddo\", \"Vendredo\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dim\", \"Lun\", \"Mar\", \"Mer\", \"\u0134a\u016d\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Di\", \"Lu\", \"Ma\", \"Me\", \"\u0134a\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sb\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.eo );\n\nreturn datepicker.regional.eo;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ro.js":"/* Romanian initialisation for the jQuery UI date picker plugin.\n *\n * Written by Edmond L. (ll_edmond@walla.com)\n * and Ionut G. Stan (ionut.g.stan@gmail.com)\n */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ro = {\n\tcloseText: \"\u00cenchide\",\n\tprevText: \"&#xAB; Luna precedent\u0103\",\n\tnextText: \"Luna urm\u0103toare &#xBB;\",\n\tcurrentText: \"Azi\",\n\tmonthNames: [ \"Ianuarie\", \"Februarie\", \"Martie\", \"Aprilie\", \"Mai\", \"Iunie\",\n\t\"Iulie\", \"August\", \"Septembrie\", \"Octombrie\", \"Noiembrie\", \"Decembrie\" ],\n\tmonthNamesShort: [ \"Ian\", \"Feb\", \"Mar\", \"Apr\", \"Mai\", \"Iun\",\n\t\"Iul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Duminic\u0103\", \"Luni\", \"Mar\u0163i\", \"Miercuri\", \"Joi\", \"Vineri\", \"S\u00e2mb\u0103t\u0103\" ],\n\tdayNamesShort: [ \"Dum\", \"Lun\", \"Mar\", \"Mie\", \"Joi\", \"Vin\", \"S\u00e2m\" ],\n\tdayNamesMin: [ \"Du\", \"Lu\", \"Ma\", \"Mi\", \"Jo\", \"Vi\", \"S\u00e2\" ],\n\tweekHeader: \"S\u0103pt\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ro );\n\nreturn datepicker.regional.ro;\n\n} );\n","jquery/ui-modules/i18n/datepicker-tj.js":"/* Tajiki (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Abdurahmon Saidov (saidovab@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.tj = {\n\tcloseText: \"\u0418\u0434\u043e\u043c\u0430\",\n\tprevText: \"&#x3c;\u049a\u0430\u0444\u043e\",\n\tnextText: \"\u041f\u0435\u0448&#x3e;\",\n\tcurrentText: \"\u0418\u043c\u0440\u04ef\u0437\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\", \"\u0424\u0435\u0432\u0440\u0430\u043b\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\", \"\u041e\u043a\u0442\u044f\u0431\u0440\", \"\u041d\u043e\u044f\u0431\u0440\", \"\u0414\u0435\u043a\u0430\u0431\u0440\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u044f\u043a\u0448\u0430\u043d\u0431\u0435\", \"\u0434\u0443\u0448\u0430\u043d\u0431\u0435\", \"\u0441\u0435\u0448\u0430\u043d\u0431\u0435\", \"\u0447\u043e\u0440\u0448\u0430\u043d\u0431\u0435\", \"\u043f\u0430\u043d\u04b7\u0448\u0430\u043d\u0431\u0435\", \"\u04b7\u0443\u043c\u044a\u0430\", \"\u0448\u0430\u043d\u0431\u0435\" ],\n\tdayNamesShort: [ \"\u044f\u043a\u0448\", \"\u0434\u0443\u0448\", \"\u0441\u0435\u0448\", \"\u0447\u043e\u0440\", \"\u043f\u0430\u043d\", \"\u04b7\u0443\u043c\", \"\u0448\u0430\u043d\" ],\n\tdayNamesMin: [ \"\u042f\u043a\", \"\u0414\u0448\", \"\u0421\u0448\", \"\u0427\u0448\", \"\u041f\u0448\", \"\u04b6\u043c\", \"\u0428\u043d\" ],\n\tweekHeader: \"\u0425\u0444\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.tj );\n\nreturn datepicker.regional.tj;\n\n} );\n","jquery/ui-modules/i18n/datepicker-tr.js":"/* Turkish initialisation for the jQuery UI date picker plugin. */\n/* Written by Izzet Emre Erkan (kara@karalamalar.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.tr = {\n\tcloseText: \"kapat\",\n\tprevText: \"&#x3C;geri\",\n\tnextText: \"ileri&#x3e\",\n\tcurrentText: \"bug\u00fcn\",\n\tmonthNames: [ \"Ocak\", \"\u015eubat\", \"Mart\", \"Nisan\", \"May\u0131s\", \"Haziran\",\n\t\"Temmuz\", \"A\u011fustos\", \"Eyl\u00fcl\", \"Ekim\", \"Kas\u0131m\", \"Aral\u0131k\" ],\n\tmonthNamesShort: [ \"Oca\", \"\u015eub\", \"Mar\", \"Nis\", \"May\", \"Haz\",\n\t\"Tem\", \"A\u011fu\", \"Eyl\", \"Eki\", \"Kas\", \"Ara\" ],\n\tdayNames: [ \"Pazar\", \"Pazartesi\", \"Sal\u0131\", \"\u00c7ar\u015famba\", \"Per\u015fembe\", \"Cuma\", \"Cumartesi\" ],\n\tdayNamesShort: [ \"Pz\", \"Pt\", \"Sa\", \"\u00c7a\", \"Pe\", \"Cu\", \"Ct\" ],\n\tdayNamesMin: [ \"Pz\", \"Pt\", \"Sa\", \"\u00c7a\", \"Pe\", \"Cu\", \"Ct\" ],\n\tweekHeader: \"Hf\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.tr );\n\nreturn datepicker.regional.tr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fo.js":"/* Faroese initialisation for the jQuery UI date picker plugin */\n/* Written by Sverri Mohr Olsen, sverrimo@gmail.com */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fo = {\n\tcloseText: \"Lat aftur\",\n\tprevText: \"&#x3C;Fyrra\",\n\tnextText: \"N\u00e6sta&#x3E;\",\n\tcurrentText: \"\u00cd dag\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mars\", \"Apr\u00edl\", \"Mei\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Des\" ],\n\tdayNames: [\n\t\t\"Sunnudagur\",\n\t\t\"M\u00e1nadagur\",\n\t\t\"T\u00fdsdagur\",\n\t\t\"Mikudagur\",\n\t\t\"H\u00f3sdagur\",\n\t\t\"Fr\u00edggjadagur\",\n\t\t\"Leyardagur\"\n\t],\n\tdayNamesShort: [ \"Sun\", \"M\u00e1n\", \"T\u00fds\", \"Mik\", \"H\u00f3s\", \"Fr\u00ed\", \"Ley\" ],\n\tdayNamesMin: [ \"Su\", \"M\u00e1\", \"T\u00fd\", \"Mi\", \"H\u00f3\", \"Fr\", \"Le\" ],\n\tweekHeader: \"Vk\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fo );\n\nreturn datepicker.regional.fo;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ar.js":"/* Arabic Translation for jQuery UI date picker plugin. */\n/* Used in most of Arab countries, primarily in Bahrain, */\n/* Kuwait, Oman, Qatar, Saudi Arabia and the United Arab Emirates, Egypt, Sudan and Yemen. */\n/* Written by Mohammed Alshehri -- m@dralshehri.com */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ar = {\n\tcloseText: \"\u0625\u063a\u0644\u0627\u0642\",\n\tprevText: \"&#x3C;\u0627\u0644\u0633\u0627\u0628\u0642\",\n\tnextText: \"\u0627\u0644\u062a\u0627\u0644\u064a&#x3E;\",\n\tcurrentText: \"\u0627\u0644\u064a\u0648\u0645\",\n\tmonthNames: [ \"\u064a\u0646\u0627\u064a\u0631\", \"\u0641\u0628\u0631\u0627\u064a\u0631\", \"\u0645\u0627\u0631\u0633\", \"\u0623\u0628\u0631\u064a\u0644\", \"\u0645\u0627\u064a\u0648\", \"\u064a\u0648\u0646\u064a\u0648\",\n\t\"\u064a\u0648\u0644\u064a\u0648\", \"\u0623\u063a\u0633\u0637\u0633\", \"\u0633\u0628\u062a\u0645\u0628\u0631\", \"\u0623\u0643\u062a\u0648\u0628\u0631\", \"\u0646\u0648\u0641\u0645\u0628\u0631\", \"\u062f\u064a\u0633\u0645\u0628\u0631\" ],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesShort: [ \"\u0623\u062d\u062f\", \"\u0627\u062b\u0646\u064a\u0646\", \"\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u062e\u0645\u064a\u0633\", \"\u062c\u0645\u0639\u0629\", \"\u0633\u0628\u062a\" ],\n\tdayNamesMin: [ \"\u062d\", \"\u0646\", \"\u062b\", \"\u0631\", \"\u062e\", \"\u062c\", \"\u0633\" ],\n\tweekHeader: \"\u0623\u0633\u0628\u0648\u0639\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\t\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ar );\n\nreturn datepicker.regional.ar;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sr-SR.js":"/* Serbian i18n for the jQuery UI date picker plugin. */\n/* Written by Dejan Dimi\u0107. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"sr-SR\" ] = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mart\", \"April\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avgust\", \"Septembar\", \"Oktobar\", \"Novembar\", \"Decembar\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljak\", \"Utorak\", \"Sreda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sre\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Sed\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"sr-SR\" ] );\n\nreturn datepicker.regional[ \"sr-SR\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-sk.js":"/* Slovak initialisation for the jQuery UI date picker plugin. */\n/* Written by Vojtech Rinik (vojto@hmm.sk). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sk = {\n\tcloseText: \"Zavrie\u0165\",\n\tprevText: \"&#x3C;Predch\u00e1dzaj\u00faci\",\n\tnextText: \"Nasleduj\u00faci&#x3E;\",\n\tcurrentText: \"Dnes\",\n\tmonthNames: [ \"janu\u00e1r\", \"febru\u00e1r\", \"marec\", \"apr\u00edl\", \"m\u00e1j\", \"j\u00fan\",\n\t\"j\u00fal\", \"august\", \"september\", \"okt\u00f3ber\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"M\u00e1j\", \"J\u00fan\",\n\t\"J\u00fal\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"nede\u013ea\", \"pondelok\", \"utorok\", \"streda\", \"\u0161tvrtok\", \"piatok\", \"sobota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Str\", \"\u0160tv\", \"Pia\", \"Sob\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"St\", \"\u0160t\", \"Pia\", \"So\" ],\n\tweekHeader: \"Ty\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sk );\n\nreturn datepicker.regional.sk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-it.js":"/* Italian initialisation for the jQuery UI date picker plugin. */\n/* Written by Antonello Pasella (antonello.pasella@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.it = {\n\tcloseText: \"Chiudi\",\n\tprevText: \"&#x3C;Prec\",\n\tnextText: \"Succ&#x3E;\",\n\tcurrentText: \"Oggi\",\n\tmonthNames: [ \"Gennaio\", \"Febbraio\", \"Marzo\", \"Aprile\", \"Maggio\", \"Giugno\",\n\t\t\"Luglio\", \"Agosto\", \"Settembre\", \"Ottobre\", \"Novembre\", \"Dicembre\" ],\n\tmonthNamesShort: [ \"Gen\", \"Feb\", \"Mar\", \"Apr\", \"Mag\", \"Giu\",\n\t\t\"Lug\", \"Ago\", \"Set\", \"Ott\", \"Nov\", \"Dic\" ],\n\tdayNames: [ \"Domenica\", \"Luned\u00ec\", \"Marted\u00ec\", \"Mercoled\u00ec\", \"Gioved\u00ec\", \"Venerd\u00ec\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"Mer\", \"Gio\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.it );\n\nreturn datepicker.regional.it;\n\n} );\n","jquery/ui-modules/i18n/datepicker-es.js":"/* Inicializaci\u00f3n en espa\u00f1ol para la extensi\u00f3n 'UI date picker' para jQuery. */\n/* Traducido por Vester (xvester@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.es = {\n\tcloseText: \"Cerrar\",\n\tprevText: \"&#x3C;Ant\",\n\tnextText: \"Sig&#x3E;\",\n\tcurrentText: \"Hoy\",\n\tmonthNames: [ \"enero\", \"febrero\", \"marzo\", \"abril\", \"mayo\", \"junio\",\n\t\"julio\", \"agosto\", \"septiembre\", \"octubre\", \"noviembre\", \"diciembre\" ],\n\tmonthNamesShort: [ \"ene\", \"feb\", \"mar\", \"abr\", \"may\", \"jun\",\n\t\"jul\", \"ago\", \"sep\", \"oct\", \"nov\", \"dic\" ],\n\tdayNames: [ \"domingo\", \"lunes\", \"martes\", \"mi\u00e9rcoles\", \"jueves\", \"viernes\", \"s\u00e1bado\" ],\n\tdayNamesShort: [ \"dom\", \"lun\", \"mar\", \"mi\u00e9\", \"jue\", \"vie\", \"s\u00e1b\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"X\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.es );\n\nreturn datepicker.regional.es;\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-NZ.js":"/* English/New Zealand initialisation for the jQuery UI date picker plugin. */\n/* Based on the en-GB initialisation. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-NZ\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-NZ\" ] );\n\nreturn datepicker.regional[ \"en-NZ\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-sr.js":"/* Serbian i18n for the jQuery UI date picker plugin. */\n/* Written by Dejan Dimi\u0107. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sr = {\n\tcloseText: \"\u0417\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0414\u0430\u043d\u0430\u0441\",\n\tmonthNames: [ \"\u0408\u0430\u043d\u0443\u0430\u0440\", \"\u0424\u0435\u0431\u0440\u0443\u0430\u0440\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0431\u0430\u0440\", \"\u041e\u043a\u0442\u043e\u0431\u0430\u0440\", \"\u041d\u043e\u0432\u0435\u043c\u0431\u0430\u0440\", \"\u0414\u0435\u0446\u0435\u043c\u0431\u0430\u0440\" ],\n\tmonthNamesShort: [ \"\u0408\u0430\u043d\", \"\u0424\u0435\u0431\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0432\", \"\u0414\u0435\u0446\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u0459\u0430\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u0459\u0430\u043a\", \"\u0423\u0442\u043e\u0440\u0430\u043a\", \"\u0421\u0440\u0435\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u0440\u0442\u0430\u043a\", \"\u041f\u0435\u0442\u0430\u043a\", \"\u0421\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0423\u0442\u043e\", \"\u0421\u0440\u0435\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u0443\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0423\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u0443\" ],\n\tweekHeader: \"\u0421\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sr );\n\nreturn datepicker.regional.sr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hu.js":"/* Hungarian initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hu = {\n\tcloseText: \"Bez\u00e1r\",\n\tprevText: \"Vissza\",\n\tnextText: \"El\u0151re\",\n\tcurrentText: \"Ma\",\n\tmonthNames: [ \"Janu\u00e1r\", \"Febru\u00e1r\", \"M\u00e1rcius\", \"\u00c1prilis\", \"M\u00e1jus\", \"J\u00fanius\",\n\t\"J\u00falius\", \"Augusztus\", \"Szeptember\", \"Okt\u00f3ber\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e1r\", \"\u00c1pr\", \"M\u00e1j\", \"J\u00fan\",\n\t\"J\u00fal\", \"Aug\", \"Szep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Vas\u00e1rnap\", \"H\u00e9tf\u0151\", \"Kedd\", \"Szerda\", \"Cs\u00fct\u00f6rt\u00f6k\", \"P\u00e9ntek\", \"Szombat\" ],\n\tdayNamesShort: [ \"Vas\", \"H\u00e9t\", \"Ked\", \"Sze\", \"Cs\u00fc\", \"P\u00e9n\", \"Szo\" ],\n\tdayNamesMin: [ \"V\", \"H\", \"K\", \"Sze\", \"Cs\", \"P\", \"Szo\" ],\n\tweekHeader: \"H\u00e9t\",\n\tdateFormat: \"yy.mm.dd.\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hu );\n\nreturn datepicker.regional.hu;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lt.js":"/* Lithuanian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* @author Arturas Paleicikas <arturas@avalon.lt> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lt = {\n\tcloseText: \"U\u017edaryti\",\n\tprevText: \"&#x3C;Atgal\",\n\tnextText: \"Pirmyn&#x3E;\",\n\tcurrentText: \"\u0160iandien\",\n\tmonthNames: [ \"Sausis\", \"Vasaris\", \"Kovas\", \"Balandis\", \"Gegu\u017e\u0117\", \"Bir\u017eelis\",\n\t\"Liepa\", \"Rugpj\u016btis\", \"Rugs\u0117jis\", \"Spalis\", \"Lapkritis\", \"Gruodis\" ],\n\tmonthNamesShort: [ \"Sau\", \"Vas\", \"Kov\", \"Bal\", \"Geg\", \"Bir\",\n\t\"Lie\", \"Rugp\", \"Rugs\", \"Spa\", \"Lap\", \"Gru\" ],\n\tdayNames: [\n\t\t\"sekmadienis\",\n\t\t\"pirmadienis\",\n\t\t\"antradienis\",\n\t\t\"tre\u010diadienis\",\n\t\t\"ketvirtadienis\",\n\t\t\"penktadienis\",\n\t\t\"\u0161e\u0161tadienis\"\n\t],\n\tdayNamesShort: [ \"sek\", \"pir\", \"ant\", \"tre\", \"ket\", \"pen\", \"\u0161e\u0161\" ],\n\tdayNamesMin: [ \"Se\", \"Pr\", \"An\", \"Tr\", \"Ke\", \"Pe\", \"\u0160e\" ],\n\tweekHeader: \"SAV\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lt );\n\nreturn datepicker.regional.lt;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ml.js":"/* Malayalam (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Saji Nediyanchath (saji89@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ml = {\n\tcloseText: \"\u0d36\u0d30\u0d3f\",\n\tprevText: \"\u0d2e\u0d41\u0d28\u0d4d\u0d28\u0d24\u0d4d\u0d24\u0d46\",\n\tnextText: \"\u0d05\u0d1f\u0d41\u0d24\u0d4d\u0d24\u0d24\u0d4d \",\n\tcurrentText: \"\u0d07\u0d28\u0d4d\u0d28\u0d4d\",\n\tmonthNames: [ \"\u0d1c\u0d28\u0d41\u0d35\u0d30\u0d3f\", \"\u0d2b\u0d46\u0d2c\u0d4d\u0d30\u0d41\u0d35\u0d30\u0d3f\", \"\u0d2e\u0d3e\u0d30\u0d4d\u200d\u0d1a\u0d4d\u0d1a\u0d4d\", \"\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u200d\", \"\u0d2e\u0d47\u0d2f\u0d4d\", \"\u0d1c\u0d42\u0d23\u0d4d\u200d\",\n\t\"\u0d1c\u0d42\u0d32\u0d48\", \"\u0d06\u0d17\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4d\", \"\u0d38\u0d46\u0d2a\u0d4d\u0d31\u0d4d\u0d31\u0d02\u0d2c\u0d30\u0d4d\u200d\", \"\u0d12\u0d15\u0d4d\u0d1f\u0d4b\u0d2c\u0d30\u0d4d\u200d\", \"\u0d28\u0d35\u0d02\u0d2c\u0d30\u0d4d\u200d\", \"\u0d21\u0d3f\u0d38\u0d02\u0d2c\u0d30\u0d4d\u200d\" ],\n\tmonthNamesShort: [ \"\u0d1c\u0d28\u0d41\", \"\u0d2b\u0d46\u0d2c\u0d4d\", \"\u0d2e\u0d3e\u0d30\u0d4d\u200d\", \"\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\", \"\u0d2e\u0d47\u0d2f\u0d4d\", \"\u0d1c\u0d42\u0d23\u0d4d\u200d\",\n\t\"\u0d1c\u0d42\u0d32\u0d3e\", \"\u0d06\u0d17\", \"\u0d38\u0d46\u0d2a\u0d4d\", \"\u0d12\u0d15\u0d4d\u0d1f\u0d4b\", \"\u0d28\u0d35\u0d02\", \"\u0d21\u0d3f\u0d38\" ],\n\tdayNames: [ \"\u0d1e\u0d3e\u0d2f\u0d30\u0d4d\u200d\", \"\u0d24\u0d3f\u0d19\u0d4d\u0d15\u0d33\u0d4d\u200d\", \"\u0d1a\u0d4a\u0d35\u0d4d\u0d35\", \"\u0d2c\u0d41\u0d27\u0d28\u0d4d\u200d\", \"\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02\", \"\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\", \"\u0d36\u0d28\u0d3f\" ],\n\tdayNamesShort: [ \"\u0d1e\u0d3e\u0d2f\", \"\u0d24\u0d3f\u0d19\u0d4d\u0d15\", \"\u0d1a\u0d4a\u0d35\u0d4d\u0d35\", \"\u0d2c\u0d41\u0d27\", \"\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02\", \"\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\", \"\u0d36\u0d28\u0d3f\" ],\n\tdayNamesMin: [ \"\u0d1e\u0d3e\", \"\u0d24\u0d3f\", \"\u0d1a\u0d4a\", \"\u0d2c\u0d41\", \"\u0d35\u0d4d\u0d2f\u0d3e\", \"\u0d35\u0d46\", \"\u0d36\" ],\n\tweekHeader: \"\u0d06\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ml );\n\nreturn datepicker.regional.ml;\n\n} );\n","jquery/ui-modules/i18n/datepicker-bs.js":"/* Bosnian i18n for the jQuery UI date picker plugin. */\n/* Written by Kenan Konjo. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.bs = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mart\", \"April\", \"Maj\", \"Juni\",\n\t\"Juli\", \"August\", \"Septembar\", \"Oktobar\", \"Novembar\", \"Decembar\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljak\", \"Utorak\", \"Srijeda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sri\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.bs );\n\nreturn datepicker.regional.bs;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sv.js":"/* Swedish initialisation for the jQuery UI date picker plugin. */\n/* Written by Anders Ekdahl ( anders@nomadiz.se). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sv = {\n\tcloseText: \"St\u00e4ng\",\n\tprevText: \"&#xAB;F\u00f6rra\",\n\tnextText: \"N\u00e4sta&#xBB;\",\n\tcurrentText: \"Idag\",\n\tmonthNames: [ \"januari\", \"februari\", \"mars\", \"april\", \"maj\", \"juni\",\n\t\"juli\", \"augusti\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan.\", \"feb.\", \"mars\", \"apr.\", \"maj\", \"juni\",\n\t\"juli\", \"aug.\", \"sep.\", \"okt.\", \"nov.\", \"dec.\" ],\n\tdayNamesShort: [ \"s\u00f6n\", \"m\u00e5n\", \"tis\", \"ons\", \"tor\", \"fre\", \"l\u00f6r\" ],\n\tdayNames: [ \"s\u00f6ndag\", \"m\u00e5ndag\", \"tisdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f6rdag\" ],\n\tdayNamesMin: [ \"s\u00f6\", \"m\u00e5\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f6\" ],\n\tweekHeader: \"Ve\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sv );\n\nreturn datepicker.regional.sv;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hi.js":"/* Hindi initialisation for the jQuery UI date picker plugin. */\n/* Written by Michael Dawart. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hi = {\n\tcloseText: \"\u092c\u0902\u0926\",\n\tprevText: \"\u092a\u093f\u091b\u0932\u093e\",\n\tnextText: \"\u0905\u0917\u0932\u093e\",\n\tcurrentText: \"\u0906\u091c\",\n\tmonthNames: [ \"\u091c\u0928\u0935\u0930\u0940 \", \"\u092b\u0930\u0935\u0930\u0940\", \"\u092e\u093e\u0930\u094d\u091a\", \"\u0905\u092a\u094d\u0930\u0947\u0932\", \"\u092e\u0908\", \"\u091c\u0942\u0928\",\n\t\"\u091c\u0942\u0932\u093e\u0908\", \"\u0905\u0917\u0938\u094d\u0924 \", \"\u0938\u093f\u0924\u092e\u094d\u092c\u0930\", \"\u0905\u0915\u094d\u091f\u0942\u092c\u0930\", \"\u0928\u0935\u092e\u094d\u092c\u0930\", \"\u0926\u093f\u0938\u092e\u094d\u092c\u0930\" ],\n\tmonthNamesShort: [ \"\u091c\u0928\", \"\u092b\u0930\", \"\u092e\u093e\u0930\u094d\u091a\", \"\u0905\u092a\u094d\u0930\u0947\u0932\", \"\u092e\u0908\", \"\u091c\u0942\u0928\",\n\t\"\u091c\u0942\u0932\u093e\u0908\", \"\u0905\u0917\", \"\u0938\u093f\u0924\", \"\u0905\u0915\u094d\u091f\", \"\u0928\u0935\", \"\u0926\u093f\" ],\n\tdayNames: [ \"\u0930\u0935\u093f\u0935\u093e\u0930\", \"\u0938\u094b\u092e\u0935\u093e\u0930\", \"\u092e\u0902\u0917\u0932\u0935\u093e\u0930\", \"\u092c\u0941\u0927\u0935\u093e\u0930\", \"\u0917\u0941\u0930\u0941\u0935\u093e\u0930\", \"\u0936\u0941\u0915\u094d\u0930\u0935\u093e\u0930\", \"\u0936\u0928\u093f\u0935\u093e\u0930\" ],\n\tdayNamesShort: [ \"\u0930\u0935\u093f\", \"\u0938\u094b\u092e\", \"\u092e\u0902\u0917\u0932\", \"\u092c\u0941\u0927\", \"\u0917\u0941\u0930\u0941\", \"\u0936\u0941\u0915\u094d\u0930\", \"\u0936\u0928\u093f\" ],\n\tdayNamesMin: [ \"\u0930\u0935\u093f\", \"\u0938\u094b\u092e\", \"\u092e\u0902\u0917\u0932\", \"\u092c\u0941\u0927\", \"\u0917\u0941\u0930\u0941\", \"\u0936\u0941\u0915\u094d\u0930\", \"\u0936\u0928\u093f\" ],\n\tweekHeader: \"\u0939\u092b\u094d\u0924\u093e\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hi );\n\nreturn datepicker.regional.hi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-uk.js":"/* Ukrainian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Maxim Drogobitskiy (maxdao@gmail.com). */\n/* Corrected by Igor Milla (igor.fsp.milla@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.uk = {\n\tcloseText: \"\u0417\u0430\u043a\u0440\u0438\u0442\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456\",\n\tmonthNames: [ \"\u0421\u0456\u0447\u0435\u043d\u044c\", \"\u041b\u044e\u0442\u0438\u0439\", \"\u0411\u0435\u0440\u0435\u0437\u0435\u043d\u044c\", \"\u041a\u0432\u0456\u0442\u0435\u043d\u044c\", \"\u0422\u0440\u0430\u0432\u0435\u043d\u044c\", \"\u0427\u0435\u0440\u0432\u0435\u043d\u044c\",\n\t\"\u041b\u0438\u043f\u0435\u043d\u044c\", \"\u0421\u0435\u0440\u043f\u0435\u043d\u044c\", \"\u0412\u0435\u0440\u0435\u0441\u0435\u043d\u044c\", \"\u0416\u043e\u0432\u0442\u0435\u043d\u044c\", \"\u041b\u0438\u0441\u0442\u043e\u043f\u0430\u0434\", \"\u0413\u0440\u0443\u0434\u0435\u043d\u044c\" ],\n\tmonthNamesShort: [ \"\u0421\u0456\u0447\", \"\u041b\u044e\u0442\", \"\u0411\u0435\u0440\", \"\u041a\u0432\u0456\", \"\u0422\u0440\u0430\", \"\u0427\u0435\u0440\",\n\t\"\u041b\u0438\u043f\", \"\u0421\u0435\u0440\", \"\u0412\u0435\u0440\", \"\u0416\u043e\u0432\", \"\u041b\u0438\u0441\", \"\u0413\u0440\u0443\" ],\n\tdayNames: [ \"\u043d\u0435\u0434\u0456\u043b\u044f\", \"\u043f\u043e\u043d\u0435\u0434\u0456\u043b\u043e\u043a\", \"\u0432\u0456\u0432\u0442\u043e\u0440\u043e\u043a\", \"\u0441\u0435\u0440\u0435\u0434\u0430\", \"\u0447\u0435\u0442\u0432\u0435\u0440\", \"\u043f\u2019\u044f\u0442\u043d\u0438\u0446\u044f\", \"\u0441\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u043d\u0435\u0434\", \"\u043f\u043d\u0434\", \"\u0432\u0456\u0432\", \"\u0441\u0440\u0434\", \"\u0447\u0442\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u041d\u0434\", \"\u041f\u043d\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0442\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u0422\u0438\u0436\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.uk );\n\nreturn datepicker.regional.uk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-cs.js":"/* Czech initialisation for the jQuery UI date picker plugin. */\n/* Written by Tomas Muller (tomas@tomas-muller.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.cs = {\n\tcloseText: \"Zav\u0159\u00edt\",\n\tprevText: \"&#x3C;D\u0159\u00edve\",\n\tnextText: \"Pozd\u011bji&#x3E;\",\n\tcurrentText: \"Nyn\u00ed\",\n\tmonthNames: [ \"leden\", \"\u00fanor\", \"b\u0159ezen\", \"duben\", \"kv\u011bten\", \"\u010derven\",\n\t\"\u010dervenec\", \"srpen\", \"z\u00e1\u0159\u00ed\", \"\u0159\u00edjen\", \"listopad\", \"prosinec\" ],\n\tmonthNamesShort: [ \"led\", \"\u00fano\", \"b\u0159e\", \"dub\", \"kv\u011b\", \"\u010der\",\n\t\"\u010dvc\", \"srp\", \"z\u00e1\u0159\", \"\u0159\u00edj\", \"lis\", \"pro\" ],\n\tdayNames: [ \"ned\u011ble\", \"pond\u011bl\u00ed\", \"\u00fater\u00fd\", \"st\u0159eda\", \"\u010dtvrtek\", \"p\u00e1tek\", \"sobota\" ],\n\tdayNamesShort: [ \"ne\", \"po\", \"\u00fat\", \"st\", \"\u010dt\", \"p\u00e1\", \"so\" ],\n\tdayNamesMin: [ \"ne\", \"po\", \"\u00fat\", \"st\", \"\u010dt\", \"p\u00e1\", \"so\" ],\n\tweekHeader: \"T\u00fdd\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.cs );\n\nreturn datepicker.regional.cs;\n\n} );\n","jquery/ui-modules/i18n/datepicker-km.js":"/* Khmer initialisation for the jQuery calendar extension. */\n/* Written by Chandara Om (chandara.teacher@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.km = {\n\tcloseText: \"\u1792\u17d2\u179c\u17be\u200b\u179a\u17bd\u1785\",\n\tprevText: \"\u1798\u17bb\u1793\",\n\tnextText: \"\u1794\u1793\u17d2\u1791\u17b6\u1794\u17cb\",\n\tcurrentText: \"\u1790\u17d2\u1784\u17c3\u200b\u1793\u17c1\u17c7\",\n\tmonthNames: [ \"\u1798\u1780\u179a\u17b6\", \"\u1780\u17bb\u1798\u17d2\u1797\u17c8\", \"\u1798\u17b8\u1793\u17b6\", \"\u1798\u17c1\u179f\u17b6\", \"\u17a7\u179f\u1797\u17b6\", \"\u1798\u17b7\u1790\u17bb\u1793\u17b6\",\n\t\"\u1780\u1780\u17d2\u1780\u178a\u17b6\", \"\u179f\u17b8\u17a0\u17b6\", \"\u1780\u1789\u17d2\u1789\u17b6\", \"\u178f\u17bb\u179b\u17b6\", \"\u179c\u17b7\u1785\u17d2\u1786\u17b7\u1780\u17b6\", \"\u1792\u17d2\u1793\u17bc\" ],\n\tmonthNamesShort: [ \"\u1798\u1780\u179a\u17b6\", \"\u1780\u17bb\u1798\u17d2\u1797\u17c8\", \"\u1798\u17b8\u1793\u17b6\", \"\u1798\u17c1\u179f\u17b6\", \"\u17a7\u179f\u1797\u17b6\", \"\u1798\u17b7\u1790\u17bb\u1793\u17b6\",\n\t\"\u1780\u1780\u17d2\u1780\u178a\u17b6\", \"\u179f\u17b8\u17a0\u17b6\", \"\u1780\u1789\u17d2\u1789\u17b6\", \"\u178f\u17bb\u179b\u17b6\", \"\u179c\u17b7\u1785\u17d2\u1786\u17b7\u1780\u17b6\", \"\u1792\u17d2\u1793\u17bc\" ],\n\tdayNames: [ \"\u17a2\u17b6\u1791\u17b7\u178f\u17d2\u1799\", \"\u1785\u1793\u17d2\u1791\", \"\u17a2\u1784\u17d2\u1782\u17b6\u179a\", \"\u1796\u17bb\u1792\", \"\u1796\u17d2\u179a\u17a0\u179f\u17d2\u1794\u178f\u17b7\u17cd\", \"\u179f\u17bb\u1780\u17d2\u179a\", \"\u179f\u17c5\u179a\u17cd\" ],\n\tdayNamesShort: [ \"\u17a2\u17b6\", \"\u1785\", \"\u17a2\", \"\u1796\u17bb\", \"\u1796\u17d2\u179a\u17a0\", \"\u179f\u17bb\", \"\u179f\u17c5\" ],\n\tdayNamesMin: [ \"\u17a2\u17b6\", \"\u1785\", \"\u17a2\", \"\u1796\u17bb\", \"\u1796\u17d2\u179a\u17a0\", \"\u179f\u17bb\", \"\u179f\u17c5\" ],\n\tweekHeader: \"\u179f\u1794\u17d2\u178a\u17b6\u17a0\u17cd\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.km );\n\nreturn datepicker.regional.km;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr.js":"/* French initialisation for the jQuery UI date picker plugin. */\n/* Written by Keith Wood (kbwood{at}iinet.com.au),\n\t\t\t  St\u00e9phane Nahmani (sholby@sholby.net),\n\t\t\t  St\u00e9phane Raimbault <stephane.raimbault@gmail.com> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fr = {\n\tcloseText: \"Fermer\",\n\tprevText: \"Pr\u00e9c\u00e9dent\",\n\tnextText: \"Suivant\",\n\tcurrentText: \"Aujourd'hui\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avr.\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sem.\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fr );\n\nreturn datepicker.regional.fr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nl.js":"/* Dutch (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Mathias Bynens <http://mathiasbynens.be/> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nl = {\n\tcloseText: \"Sluiten\",\n\tprevText: \"\u2190\",\n\tnextText: \"\u2192\",\n\tcurrentText: \"Vandaag\",\n\tmonthNames: [ \"januari\", \"februari\", \"maart\", \"april\", \"mei\", \"juni\",\n\t\"juli\", \"augustus\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mrt\", \"apr\", \"mei\", \"jun\",\n\t\"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"dec\" ],\n\tdayNames: [ \"zondag\", \"maandag\", \"dinsdag\", \"woensdag\", \"donderdag\", \"vrijdag\", \"zaterdag\" ],\n\tdayNamesShort: [ \"zon\", \"maa\", \"din\", \"woe\", \"don\", \"vri\", \"zat\" ],\n\tdayNamesMin: [ \"zo\", \"ma\", \"di\", \"wo\", \"do\", \"vr\", \"za\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.nl );\n\nreturn datepicker.regional.nl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fa.js":"/* Persian (Farsi) Translation for the jQuery UI date picker plugin. */\n/* Javad Mowlanezhad -- jmowla@gmail.com */\n/* Jalali calendar should supported soon! (Its implemented but I have to test it) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fa = {\n\tcloseText: \"\u0628\u0633\u062a\u0646\",\n\tprevText: \"&#x3C;\u0642\u0628\u0644\u06cc\",\n\tnextText: \"\u0628\u0639\u062f\u06cc&#x3E;\",\n\tcurrentText: \"\u0627\u0645\u0631\u0648\u0632\",\n\tmonthNames: [\n\t\t\"\u0698\u0627\u0646\u0648\u06cc\u0647\",\n\t\t\"\u0641\u0648\u0631\u06cc\u0647\",\n\t\t\"\u0645\u0627\u0631\u0633\",\n\t\t\"\u0622\u0648\u0631\u06cc\u0644\",\n\t\t\"\u0645\u0647\",\n\t\t\"\u0698\u0648\u0626\u0646\",\n\t\t\"\u0698\u0648\u0626\u06cc\u0647\",\n\t\t\"\u0627\u0648\u062a\",\n\t\t\"\u0633\u067e\u062a\u0627\u0645\u0628\u0631\",\n\t\t\"\u0627\u06a9\u062a\u0628\u0631\",\n\t\t\"\u0646\u0648\u0627\u0645\u0628\u0631\",\n\t\t\"\u062f\u0633\u0627\u0645\u0628\u0631\"\n\t],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [\n\t\t\"\u064a\u06a9\u0634\u0646\u0628\u0647\",\n\t\t\"\u062f\u0648\u0634\u0646\u0628\u0647\",\n\t\t\"\u0633\u0647\u200c\u0634\u0646\u0628\u0647\",\n\t\t\"\u0686\u0647\u0627\u0631\u0634\u0646\u0628\u0647\",\n\t\t\"\u067e\u0646\u062c\u0634\u0646\u0628\u0647\",\n\t\t\"\u062c\u0645\u0639\u0647\",\n\t\t\"\u0634\u0646\u0628\u0647\"\n\t],\n\tdayNamesShort: [\n\t\t\"\u06cc\",\n\t\t\"\u062f\",\n\t\t\"\u0633\",\n\t\t\"\u0686\",\n\t\t\"\u067e\",\n\t\t\"\u062c\",\n\t\t\"\u0634\"\n\t],\n\tdayNamesMin: [\n\t\t\"\u06cc\",\n\t\t\"\u062f\",\n\t\t\"\u0633\",\n\t\t\"\u0686\",\n\t\t\"\u067e\",\n\t\t\"\u062c\",\n\t\t\"\u0634\"\n\t],\n\tweekHeader: \"\u0647\u0641\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 6,\n\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fa );\n\nreturn datepicker.regional.fa;\n\n} );\n","jquery/ui-modules/i18n/datepicker-de.js":"/* German initialisation for the jQuery UI date picker plugin. */\n/* Written by Milian Wolff (mail@milianw.de). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.de = {\n\tcloseText: \"Schlie\u00dfen\",\n\tprevText: \"&#x3C;Zur\u00fcck\",\n\tnextText: \"Vor&#x3E;\",\n\tcurrentText: \"Heute\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"M\u00e4rz\", \"April\", \"Mai\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e4r\", \"Apr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [ \"Sonntag\", \"Montag\", \"Dienstag\", \"Mittwoch\", \"Donnerstag\", \"Freitag\", \"Samstag\" ],\n\tdayNamesShort: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tdayNamesMin: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"KW\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.de );\n\nreturn datepicker.regional.de;\n\n} );\n","jquery/ui-modules/i18n/datepicker-da.js":"/* Danish initialisation for the jQuery UI date picker plugin. */\n/* Written by Jan Christensen ( deletestuff@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.da = {\n\tcloseText: \"Luk\",\n\tprevText: \"&#x3C;Forrige\",\n\tnextText: \"N\u00e6ste&#x3E;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Marts\", \"April\", \"Maj\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"S\u00f8ndag\", \"Mandag\", \"Tirsdag\", \"Onsdag\", \"Torsdag\", \"Fredag\", \"L\u00f8rdag\" ],\n\tdayNamesShort: [ \"S\u00f8n\", \"Man\", \"Tir\", \"Ons\", \"Tor\", \"Fre\", \"L\u00f8r\" ],\n\tdayNamesMin: [ \"S\u00f8\", \"Ma\", \"Ti\", \"On\", \"To\", \"Fr\", \"L\u00f8\" ],\n\tweekHeader: \"Uge\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.da );\n\nreturn datepicker.regional.da;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nb.js":"/* Norwegian Bokm\u00e5l initialisation for the jQuery UI date picker plugin. */\n/* Written by Bj\u00f8rn Johansen (post@bjornjohansen.no). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nb = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;Forrige\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"s\u00f8n\", \"man\", \"tir\", \"ons\", \"tor\", \"fre\", \"l\u00f8r\" ],\n\tdayNames: [ \"s\u00f8ndag\", \"mandag\", \"tirsdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f8rdag\" ],\n\tdayNamesMin: [ \"s\u00f8\", \"ma\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f8\" ],\n\tweekHeader: \"Uke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.nb );\n\nreturn datepicker.regional.nb;\n\n} );\n","jquery/ui-modules/i18n/datepicker-be.js":"/* Belarusian initialisation for the jQuery UI date picker plugin. */\n/* Written by Pavel Selitskas <p.selitskas@gmail.com> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.be = {\n\tcloseText: \"\u0417\u0430\u0447\u044b\u043d\u0456\u0446\u044c\",\n\tprevText: \"&larr;\u041f\u0430\u043f\u044f\u0440.\",\n\tnextText: \"\u041d\u0430\u0441\u0442.&rarr;\",\n\tcurrentText: \"\u0421\u0451\u043d\u044c\u043d\u044f\",\n\tmonthNames: [ \"\u0421\u0442\u0443\u0434\u0437\u0435\u043d\u044c\", \"\u041b\u044e\u0442\u044b\", \"\u0421\u0430\u043a\u0430\u0432\u0456\u043a\", \"\u041a\u0440\u0430\u0441\u0430\u0432\u0456\u043a\", \"\u0422\u0440\u0430\u0432\u0435\u043d\u044c\", \"\u0427\u044d\u0440\u0432\u0435\u043d\u044c\",\n\t\"\u041b\u0456\u043f\u0435\u043d\u044c\", \"\u0416\u043d\u0456\u0432\u0435\u043d\u044c\", \"\u0412\u0435\u0440\u0430\u0441\u0435\u043d\u044c\", \"\u041a\u0430\u0441\u0442\u0440\u044b\u0447\u043d\u0456\u043a\", \"\u041b\u0456\u0441\u0442\u0430\u043f\u0430\u0434\", \"\u0421\u044c\u043d\u0435\u0436\u0430\u043d\u044c\" ],\n\tmonthNamesShort: [ \"\u0421\u0442\u0443\", \"\u041b\u044e\u0442\", \"\u0421\u0430\u043a\", \"\u041a\u0440\u0430\", \"\u0422\u0440\u0430\", \"\u0427\u044d\u0440\",\n\t\"\u041b\u0456\u043f\", \"\u0416\u043d\u0456\", \"\u0412\u0435\u0440\", \"\u041a\u0430\u0441\", \"\u041b\u0456\u0441\", \"\u0421\u044c\u043d\" ],\n\tdayNames: [ \"\u043d\u044f\u0434\u0437\u0435\u043b\u044f\", \"\u043f\u0430\u043d\u044f\u0434\u0437\u0435\u043b\u0430\u043a\", \"\u0430\u045e\u0442\u043e\u0440\u0430\u043a\", \"\u0441\u0435\u0440\u0430\u0434\u0430\", \"\u0447\u0430\u0446\u044c\u0432\u0435\u0440\", \"\u043f\u044f\u0442\u043d\u0456\u0446\u0430\", \"\u0441\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u043d\u0434\u0437\", \"\u043f\u043d\u0434\", \"\u0430\u045e\u0442\", \"\u0441\u0440\u0434\", \"\u0447\u0446\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u041d\u0434\", \"\u041f\u043d\", \"\u0410\u045e\", \"\u0421\u0440\", \"\u0427\u0446\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u0422\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.be );\n\nreturn datepicker.regional.be;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lb.js":"/* Luxembourgish initialisation for the jQuery UI date picker plugin. */\n/* Written by Michel Weimerskirch <michel@weimerskirch.net> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lb = {\n\tcloseText: \"F\u00e4erdeg\",\n\tprevText: \"Zr\u00e9ck\",\n\tnextText: \"Weider\",\n\tcurrentText: \"Haut\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"M\u00e4erz\", \"Abr\u00ebll\", \"Mee\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e4e\", \"Abr\", \"Mee\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Sonndeg\",\n\t\t\"M\u00e9indeg\",\n\t\t\"D\u00ebnschdeg\",\n\t\t\"M\u00ebttwoch\",\n\t\t\"Donneschdeg\",\n\t\t\"Freideg\",\n\t\t\"Samschdeg\"\n\t],\n\tdayNamesShort: [ \"Son\", \"M\u00e9i\", \"D\u00ebn\", \"M\u00ebt\", \"Don\", \"Fre\", \"Sam\" ],\n\tdayNamesMin: [ \"So\", \"M\u00e9\", \"D\u00eb\", \"M\u00eb\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"W\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lb );\n\nreturn datepicker.regional.lb;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ca.js":"/* Inicialitzaci\u00f3 en catal\u00e0 per a l'extensi\u00f3 'UI date picker' per jQuery. */\n/* Writers: (joan.leon@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ca = {\n\tcloseText: \"Tanca\",\n\tprevText: \"Anterior\",\n\tnextText: \"Seg\u00fcent\",\n\tcurrentText: \"Avui\",\n\tmonthNames: [ \"gener\", \"febrer\", \"mar\u00e7\", \"abril\", \"maig\", \"juny\",\n\t\"juliol\", \"agost\", \"setembre\", \"octubre\", \"novembre\", \"desembre\" ],\n\tmonthNamesShort: [ \"gen\", \"feb\", \"mar\u00e7\", \"abr\", \"maig\", \"juny\",\n\t\"jul\", \"ag\", \"set\", \"oct\", \"nov\", \"des\" ],\n\tdayNames: [ \"diumenge\", \"dilluns\", \"dimarts\", \"dimecres\", \"dijous\", \"divendres\", \"dissabte\" ],\n\tdayNamesShort: [ \"dg\", \"dl\", \"dt\", \"dc\", \"dj\", \"dv\", \"ds\" ],\n\tdayNamesMin: [ \"dg\", \"dl\", \"dt\", \"dc\", \"dj\", \"dv\", \"ds\" ],\n\tweekHeader: \"Set\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ca );\n\nreturn datepicker.regional.ca;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ta.js":"/* Tamil (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by S A Sureshkumar (saskumar@live.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ta = {\n\tcloseText: \"\u0bae\u0bc2\u0b9f\u0bc1\",\n\tprevText: \"\u0bae\u0bc1\u0ba9\u0bcd\u0ba9\u0bc8\u0baf\u0ba4\u0bc1\",\n\tnextText: \"\u0b85\u0b9f\u0bc1\u0ba4\u0bcd\u0ba4\u0ba4\u0bc1\",\n\tcurrentText: \"\u0b87\u0ba9\u0bcd\u0bb1\u0bc1\",\n\tmonthNames: [ \"\u0ba4\u0bc8\", \"\u0bae\u0bbe\u0b9a\u0bbf\", \"\u0baa\u0b99\u0bcd\u0b95\u0bc1\u0ba9\u0bbf\", \"\u0b9a\u0bbf\u0ba4\u0bcd\u0ba4\u0bbf\u0bb0\u0bc8\", \"\u0bb5\u0bc8\u0b95\u0bbe\u0b9a\u0bbf\", \"\u0b86\u0ba9\u0bbf\",\n\t\"\u0b86\u0b9f\u0bbf\", \"\u0b86\u0bb5\u0ba3\u0bbf\", \"\u0baa\u0bc1\u0bb0\u0b9f\u0bcd\u0b9f\u0bbe\u0b9a\u0bbf\", \"\u0b90\u0baa\u0bcd\u0baa\u0b9a\u0bbf\", \"\u0b95\u0bbe\u0bb0\u0bcd\u0ba4\u0bcd\u0ba4\u0bbf\u0b95\u0bc8\", \"\u0bae\u0bbe\u0bb0\u0bcd\u0b95\u0bb4\u0bbf\" ],\n\tmonthNamesShort: [ \"\u0ba4\u0bc8\", \"\u0bae\u0bbe\u0b9a\u0bbf\", \"\u0baa\u0b99\u0bcd\", \"\u0b9a\u0bbf\u0ba4\u0bcd\", \"\u0bb5\u0bc8\u0b95\u0bbe\", \"\u0b86\u0ba9\u0bbf\",\n\t\"\u0b86\u0b9f\u0bbf\", \"\u0b86\u0bb5\", \"\u0baa\u0bc1\u0bb0\", \"\u0b90\u0baa\u0bcd\", \"\u0b95\u0bbe\u0bb0\u0bcd\", \"\u0bae\u0bbe\u0bb0\u0bcd\" ],\n\tdayNames: [\n\t\t\"\u0b9e\u0bbe\u0baf\u0bbf\u0bb1\u0bcd\u0bb1\u0bc1\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0ba4\u0bbf\u0b99\u0bcd\u0b95\u0b9f\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0b9a\u0bc6\u0bb5\u0bcd\u0bb5\u0bbe\u0baf\u0bcd\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0baa\u0bc1\u0ba4\u0ba9\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0bb5\u0bbf\u0baf\u0bbe\u0bb4\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0bb5\u0bc6\u0bb3\u0bcd\u0bb3\u0bbf\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0b9a\u0ba9\u0bbf\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\"\n\t],\n\tdayNamesShort: [\n\t\t\"\u0b9e\u0bbe\u0baf\u0bbf\u0bb1\u0bc1\",\n\t\t\"\u0ba4\u0bbf\u0b99\u0bcd\u0b95\u0bb3\u0bcd\",\n\t\t\"\u0b9a\u0bc6\u0bb5\u0bcd\u0bb5\u0bbe\u0baf\u0bcd\",\n\t\t\"\u0baa\u0bc1\u0ba4\u0ba9\u0bcd\",\n\t\t\"\u0bb5\u0bbf\u0baf\u0bbe\u0bb4\u0ba9\u0bcd\",\n\t\t\"\u0bb5\u0bc6\u0bb3\u0bcd\u0bb3\u0bbf\",\n\t\t\"\u0b9a\u0ba9\u0bbf\"\n\t],\n\tdayNamesMin: [ \"\u0b9e\u0bbe\", \"\u0ba4\u0bbf\", \"\u0b9a\u0bc6\", \"\u0baa\u0bc1\", \"\u0bb5\u0bbf\", \"\u0bb5\u0bc6\", \"\u0b9a\" ],\n\tweekHeader: \"\u041d\u0435\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ta );\n\nreturn datepicker.regional.ta;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr-CH.js":"/* Swiss-French initialisation for the jQuery UI date picker plugin. */\n/* Written Martin Voelkle (martin.voelkle@e-tc.ch). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"fr-CH\" ] = {\n\tcloseText: \"Fermer\",\n\tprevText: \"&#x3C;Pr\u00e9c\",\n\tnextText: \"Suiv&#x3E;\",\n\tcurrentText: \"Courant\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"fr-CH\" ] );\n\nreturn datepicker.regional[ \"fr-CH\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-cy-GB.js":"/* Welsh/UK initialisation for the jQuery UI date picker plugin. */\n/* Written by William Griffiths. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"cy-GB\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"Ionawr\", \"Chwefror\", \"Mawrth\", \"Ebrill\", \"Mai\", \"Mehefin\",\n\t\"Gorffennaf\", \"Awst\", \"Medi\", \"Hydref\", \"Tachwedd\", \"Rhagfyr\" ],\n\tmonthNamesShort: [ \"Ion\", \"Chw\", \"Maw\", \"Ebr\", \"Mai\", \"Meh\",\n\t\"Gor\", \"Aws\", \"Med\", \"Hyd\", \"Tac\", \"Rha\" ],\n\tdayNames: [\n\t\t\"Dydd Sul\",\n\t\t\"Dydd Llun\",\n\t\t\"Dydd Mawrth\",\n\t\t\"Dydd Mercher\",\n\t\t\"Dydd Iau\",\n\t\t\"Dydd Gwener\",\n\t\t\"Dydd Sadwrn\"\n\t],\n\tdayNamesShort: [ \"Sul\", \"Llu\", \"Maw\", \"Mer\", \"Iau\", \"Gwe\", \"Sad\" ],\n\tdayNamesMin: [ \"Su\", \"Ll\", \"Ma\", \"Me\", \"Ia\", \"Gw\", \"Sa\" ],\n\tweekHeader: \"Wy\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"cy-GB\" ] );\n\nreturn datepicker.regional[ \"cy-GB\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-HK.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by SCCY (samuelcychan@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-HK\" ] = {\n\tcloseText: \"\u95dc\u9589\",\n\tprevText: \"&#x3C;\u4e0a\u6708\",\n\tnextText: \"\u4e0b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u5468\u65e5\", \"\u5468\u4e00\", \"\u5468\u4e8c\", \"\u5468\u4e09\", \"\u5468\u56db\", \"\u5468\u4e94\", \"\u5468\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u5468\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-HK\" ] );\n\nreturn datepicker.regional[ \"zh-HK\" ];\n\n} );\n","jquery/ui-modules/effects/effect-pulsate.js":"/*!\n * jQuery UI Effects Pulsate 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Pulsate Effect\n//>>group: Effects\n//>>description: Pulsates an element n times by changing the opacity to zero and back.\n//>>docs: http://api.jqueryui.com/pulsate-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"pulsate\", \"show\", function( options, done ) {\n        var element = $( this ),\n            mode = options.mode,\n            show = mode === \"show\",\n            hide = mode === \"hide\",\n            showhide = show || hide,\n\n            // Showing or hiding leaves off the \"last\" animation\n            anims = ( ( options.times || 5 ) * 2 ) + ( showhide ? 1 : 0 ),\n            duration = options.duration / anims,\n            animateTo = 0,\n            i = 1,\n            queuelen = element.queue().length;\n\n        if ( show || !element.is( \":visible\" ) ) {\n            element.css( \"opacity\", 0 ).show();\n            animateTo = 1;\n        }\n\n        // Anims - 1 opacity \"toggles\"\n        for ( ; i < anims; i++ ) {\n            element.animate( { opacity: animateTo }, duration, options.easing );\n            animateTo = 1 - animateTo;\n        }\n\n        element.animate( { opacity: animateTo }, duration, options.easing );\n\n        element.queue( done );\n\n        $.effects.unshift( element, queuelen, anims + 1 );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-fade.js":"/*!\n * jQuery UI Effects Fade 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Fade Effect\n//>>group: Effects\n//>>description: Fades the element.\n//>>docs: http://api.jqueryui.com/fade-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"fade\", \"toggle\", function( options, done ) {\n        var show = options.mode === \"show\";\n\n        $( this )\n            .css( \"opacity\", show ? 0 : 1 )\n            .animate( {\n                opacity: show ? 1 : 0\n            }, {\n                queue: false,\n                duration: options.duration,\n                easing: options.easing,\n                complete: done\n            } );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-clip.js":"/*!\n * jQuery UI Effects Clip 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Clip Effect\n//>>group: Effects\n//>>description: Clips the element on and off like an old TV.\n//>>docs: http://api.jqueryui.com/clip-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"clip\", \"hide\", function( options, done ) {\n        var start,\n            animate = {},\n            element = $( this ),\n            direction = options.direction || \"vertical\",\n            both = direction === \"both\",\n            horizontal = both || direction === \"horizontal\",\n            vertical = both || direction === \"vertical\";\n\n        start = element.cssClip();\n        animate.clip = {\n            top: vertical ? ( start.bottom - start.top ) / 2 : start.top,\n            right: horizontal ? ( start.right - start.left ) / 2 : start.right,\n            bottom: vertical ? ( start.bottom - start.top ) / 2 : start.bottom,\n            left: horizontal ? ( start.right - start.left ) / 2 : start.left\n        };\n\n        $.effects.createPlaceholder( element );\n\n        if ( options.mode === \"show\" ) {\n            element.cssClip( animate.clip );\n            animate.clip = start;\n        }\n\n        element.animate( animate, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: done\n        } );\n\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-fold.js":"/*!\n * jQuery UI Effects Fold 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Fold Effect\n//>>group: Effects\n//>>description: Folds an element first horizontally and then vertically.\n//>>docs: http://api.jqueryui.com/fold-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"fold\", \"hide\", function( options, done ) {\n\n        // Create element\n        var element = $( this ),\n            mode = options.mode,\n            show = mode === \"show\",\n            hide = mode === \"hide\",\n            size = options.size || 15,\n            percent = /([0-9]+)%/.exec( size ),\n            horizFirst = !!options.horizFirst,\n            ref = horizFirst ? [ \"right\", \"bottom\" ] : [ \"bottom\", \"right\" ],\n            duration = options.duration / 2,\n\n            placeholder = $.effects.createPlaceholder( element ),\n\n            start = element.cssClip(),\n            animation1 = { clip: $.extend( {}, start ) },\n            animation2 = { clip: $.extend( {}, start ) },\n\n            distance = [ start[ ref[ 0 ] ], start[ ref[ 1 ] ] ],\n\n            queuelen = element.queue().length;\n\n        if ( percent ) {\n            size = parseInt( percent[ 1 ], 10 ) / 100 * distance[ hide ? 0 : 1 ];\n        }\n        animation1.clip[ ref[ 0 ] ] = size;\n        animation2.clip[ ref[ 0 ] ] = size;\n        animation2.clip[ ref[ 1 ] ] = 0;\n\n        if ( show ) {\n            element.cssClip( animation2.clip );\n            if ( placeholder ) {\n                placeholder.css( $.effects.clipToBox( animation2 ) );\n            }\n\n            animation2.clip = start;\n        }\n\n        // Animate\n        element\n            .queue( function( next ) {\n                if ( placeholder ) {\n                    placeholder\n                        .animate( $.effects.clipToBox( animation1 ), duration, options.easing )\n                        .animate( $.effects.clipToBox( animation2 ), duration, options.easing );\n                }\n\n                next();\n            } )\n            .animate( animation1, duration, options.easing )\n            .animate( animation2, duration, options.easing )\n            .queue( done );\n\n        $.effects.unshift( element, queuelen, 4 );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-drop.js":"/*!\n * jQuery UI Effects Clip 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Clip Effect\n//>>group: Effects\n//>>description: Clips the element on and off like an old TV.\n//>>docs: http://api.jqueryui.com/clip-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"clip\", \"hide\", function( options, done ) {\n        var start,\n            animate = {},\n            element = $( this ),\n            direction = options.direction || \"vertical\",\n            both = direction === \"both\",\n            horizontal = both || direction === \"horizontal\",\n            vertical = both || direction === \"vertical\";\n\n        start = element.cssClip();\n        animate.clip = {\n            top: vertical ? ( start.bottom - start.top ) / 2 : start.top,\n            right: horizontal ? ( start.right - start.left ) / 2 : start.right,\n            bottom: vertical ? ( start.bottom - start.top ) / 2 : start.bottom,\n            left: horizontal ? ( start.right - start.left ) / 2 : start.left\n        };\n\n        $.effects.createPlaceholder( element );\n\n        if ( options.mode === \"show\" ) {\n            element.cssClip( animate.clip );\n            animate.clip = start;\n        }\n\n        element.animate( animate, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: done\n        } );\n\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-scale.js":"/*!\n * jQuery UI Effects Scale 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Scale Effect\n//>>group: Effects\n//>>description: Grows or shrinks an element and its content.\n//>>docs: http://api.jqueryui.com/scale-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\",\n            \"./effect-size\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"scale\", function( options, done ) {\n\n        // Create element\n        var el = $( this ),\n            mode = options.mode,\n            percent = parseInt( options.percent, 10 ) ||\n                ( parseInt( options.percent, 10 ) === 0 ? 0 : ( mode !== \"effect\" ? 0 : 100 ) ),\n\n            newOptions = $.extend( true, {\n                from: $.effects.scaledDimensions( el ),\n                to: $.effects.scaledDimensions( el, percent, options.direction || \"both\" ),\n                origin: options.origin || [ \"middle\", \"center\" ]\n            }, options );\n\n        // Fade option to support puff\n        if ( options.fade ) {\n            newOptions.from.opacity = 1;\n            newOptions.to.opacity = 0;\n        }\n\n        $.effects.effect.size.call( this, newOptions, done );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-explode.js":"/*!\n * jQuery UI Effects Explode 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Explode Effect\n//>>group: Effects\n/* eslint-disable max-len */\n//>>description: Explodes an element in all directions into n pieces. Implodes an element to its original wholeness.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/explode-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"explode\", \"hide\", function( options, done ) {\n\n        var i, j, left, top, mx, my,\n            rows = options.pieces ? Math.round( Math.sqrt( options.pieces ) ) : 3,\n            cells = rows,\n            element = $( this ),\n            mode = options.mode,\n            show = mode === \"show\",\n\n            // Show and then visibility:hidden the element before calculating offset\n            offset = element.show().css( \"visibility\", \"hidden\" ).offset(),\n\n            // Width and height of a piece\n            width = Math.ceil( element.outerWidth() / cells ),\n            height = Math.ceil( element.outerHeight() / rows ),\n            pieces = [];\n\n        // Children animate complete:\n        function childComplete() {\n            pieces.push( this );\n            if ( pieces.length === rows * cells ) {\n                animComplete();\n            }\n        }\n\n        // Clone the element for each row and cell.\n        for ( i = 0; i < rows; i++ ) { // ===>\n            top = offset.top + i * height;\n            my = i - ( rows - 1 ) / 2;\n\n            for ( j = 0; j < cells; j++ ) { // |||\n                left = offset.left + j * width;\n                mx = j - ( cells - 1 ) / 2;\n\n                // Create a clone of the now hidden main element that will be absolute positioned\n                // within a wrapper div off the -left and -top equal to size of our pieces\n                element\n                    .clone()\n                    .appendTo( \"body\" )\n                    .wrap( \"<div></div>\" )\n                    .css( {\n                        position: \"absolute\",\n                        visibility: \"visible\",\n                        left: -j * width,\n                        top: -i * height\n                    } )\n\n                    // Select the wrapper - make it overflow: hidden and absolute positioned based on\n                    // where the original was located +left and +top equal to the size of pieces\n                    .parent()\n                    .addClass( \"ui-effects-explode\" )\n                    .css( {\n                        position: \"absolute\",\n                        overflow: \"hidden\",\n                        width: width,\n                        height: height,\n                        left: left + ( show ? mx * width : 0 ),\n                        top: top + ( show ? my * height : 0 ),\n                        opacity: show ? 0 : 1\n                    } )\n                    .animate( {\n                        left: left + ( show ? 0 : mx * width ),\n                        top: top + ( show ? 0 : my * height ),\n                        opacity: show ? 1 : 0\n                    }, options.duration || 500, options.easing, childComplete );\n            }\n        }\n\n        function animComplete() {\n            element.css( {\n                visibility: \"visible\"\n            } );\n            $( pieces ).remove();\n            done();\n        }\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-puff.js":"/*!\n * jQuery UI Effects Puff 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Puff Effect\n//>>group: Effects\n//>>description: Creates a puff effect by scaling the element up and hiding it at the same time.\n//>>docs: http://api.jqueryui.com/puff-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\",\n            \"./effect-scale\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"puff\", \"hide\", function( options, done ) {\n        var newOptions = $.extend( true, {}, options, {\n            fade: true,\n            percent: parseInt( options.percent, 10 ) || 150\n        } );\n\n        $.effects.effect.scale.call( this, newOptions, done );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-transfer.js":"/*!\n * jQuery UI Effects Transfer 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Transfer Effect\n//>>group: Effects\n//>>description: Displays a transfer effect from one element to another.\n//>>docs: http://api.jqueryui.com/transfer-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var effect;\n    if ( $.uiBackCompat !== false ) {\n        effect = $.effects.define( \"transfer\", function( options, done ) {\n            $( this ).transfer( options, done );\n        } );\n    }\n    return effect;\n\n} );\n","jquery/ui-modules/effects/effect-bounce.js":"/*!\n * jQuery UI Effects Bounce 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Bounce Effect\n//>>group: Effects\n//>>description: Bounces an element horizontally or vertically n times.\n//>>docs: http://api.jqueryui.com/bounce-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"bounce\", function( options, done ) {\n        var upAnim, downAnim, refValue,\n            element = $( this ),\n\n            // Defaults:\n            mode = options.mode,\n            hide = mode === \"hide\",\n            show = mode === \"show\",\n            direction = options.direction || \"up\",\n            distance = options.distance,\n            times = options.times || 5,\n\n            // Number of internal animations\n            anims = times * 2 + ( show || hide ? 1 : 0 ),\n            speed = options.duration / anims,\n            easing = options.easing,\n\n            // Utility:\n            ref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n            motion = ( direction === \"up\" || direction === \"left\" ),\n            i = 0,\n\n            queuelen = element.queue().length;\n\n        $.effects.createPlaceholder( element );\n\n        refValue = element.css( ref );\n\n        // Default distance for the BIGGEST bounce is the outer Distance / 3\n        if ( !distance ) {\n            distance = element[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]() / 3;\n        }\n\n        if ( show ) {\n            downAnim = { opacity: 1 };\n            downAnim[ ref ] = refValue;\n\n            // If we are showing, force opacity 0 and set the initial position\n            // then do the \"first\" animation\n            element\n                .css( \"opacity\", 0 )\n                .css( ref, motion ? -distance * 2 : distance * 2 )\n                .animate( downAnim, speed, easing );\n        }\n\n        // Start at the smallest distance if we are hiding\n        if ( hide ) {\n            distance = distance / Math.pow( 2, times - 1 );\n        }\n\n        downAnim = {};\n        downAnim[ ref ] = refValue;\n\n        // Bounces up/down/left/right then back to 0 -- times * 2 animations happen here\n        for ( ; i < times; i++ ) {\n            upAnim = {};\n            upAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n            element\n                .animate( upAnim, speed, easing )\n                .animate( downAnim, speed, easing );\n\n            distance = hide ? distance * 2 : distance / 2;\n        }\n\n        // Last Bounce when Hiding\n        if ( hide ) {\n            upAnim = { opacity: 0 };\n            upAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n            element.animate( upAnim, speed, easing );\n        }\n\n        element.queue( done );\n\n        $.effects.unshift( element, queuelen, anims + 1 );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-blind.js":"/*!\n * jQuery UI Effects Blind 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Blind Effect\n//>>group: Effects\n//>>description: Blinds the element.\n//>>docs: http://api.jqueryui.com/blind-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"blind\", \"hide\", function( options, done ) {\n        var map = {\n                up: [ \"bottom\", \"top\" ],\n                vertical: [ \"bottom\", \"top\" ],\n                down: [ \"top\", \"bottom\" ],\n                left: [ \"right\", \"left\" ],\n                horizontal: [ \"right\", \"left\" ],\n                right: [ \"left\", \"right\" ]\n            },\n            element = $( this ),\n            direction = options.direction || \"up\",\n            start = element.cssClip(),\n            animate = { clip: $.extend( {}, start ) },\n            placeholder = $.effects.createPlaceholder( element );\n\n        animate.clip[ map[ direction ][ 0 ] ] = animate.clip[ map[ direction ][ 1 ] ];\n\n        if ( options.mode === \"show\" ) {\n            element.cssClip( animate.clip );\n            if ( placeholder ) {\n                placeholder.css( $.effects.clipToBox( animate ) );\n            }\n\n            animate.clip = start;\n        }\n\n        if ( placeholder ) {\n            placeholder.animate( $.effects.clipToBox( animate ), options.duration, options.easing );\n        }\n\n        element.animate( animate, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: done\n        } );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-slide.js":"/*!\n * jQuery UI Effects Slide 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Slide Effect\n//>>group: Effects\n//>>description: Slides an element in and out of the viewport.\n//>>docs: http://api.jqueryui.com/slide-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"slide\", \"show\", function( options, done ) {\n        var startClip, startRef,\n            element = $( this ),\n            map = {\n                up: [ \"bottom\", \"top\" ],\n                down: [ \"top\", \"bottom\" ],\n                left: [ \"right\", \"left\" ],\n                right: [ \"left\", \"right\" ]\n            },\n            mode = options.mode,\n            direction = options.direction || \"left\",\n            ref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n            positiveMotion = ( direction === \"up\" || direction === \"left\" ),\n            distance = options.distance ||\n                element[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]( true ),\n            animation = {};\n\n        $.effects.createPlaceholder( element );\n\n        startClip = element.cssClip();\n        startRef = element.position()[ ref ];\n\n        // Define hide animation\n        animation[ ref ] = ( positiveMotion ? -1 : 1 ) * distance + startRef;\n        animation.clip = element.cssClip();\n        animation.clip[ map[ direction ][ 1 ] ] = animation.clip[ map[ direction ][ 0 ] ];\n\n        // Reverse the animation if we're showing\n        if ( mode === \"show\" ) {\n            element.cssClip( animation.clip );\n            element.css( ref, animation[ ref ] );\n            animation.clip = startClip;\n            animation[ ref ] = startRef;\n        }\n\n        // Actually animate\n        element.animate( animation, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: done\n        } );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-highlight.js":"/*!\n * jQuery UI Effects Highlight 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Highlight Effect\n//>>group: Effects\n//>>description: Highlights the background of an element in a defined color for a custom duration.\n//>>docs: http://api.jqueryui.com/highlight-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"highlight\", \"show\", function( options, done ) {\n        var element = $( this ),\n            animation = {\n                backgroundColor: element.css( \"backgroundColor\" )\n            };\n\n        if ( options.mode === \"hide\" ) {\n            animation.opacity = 0;\n        }\n\n        $.effects.saveStyle( element );\n\n        element\n            .css( {\n                backgroundImage: \"none\",\n                backgroundColor: options.color || \"#ffff99\"\n            } )\n            .animate( animation, {\n                queue: false,\n                duration: options.duration,\n                easing: options.easing,\n                complete: done\n            } );\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-size.js":"/*!\n * jQuery UI Effects Size 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Size Effect\n//>>group: Effects\n//>>description: Resize an element to a specified width and height.\n//>>docs: http://api.jqueryui.com/size-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"size\", function( options, done ) {\n\n        // Create element\n        var baseline, factor, temp,\n            element = $( this ),\n\n            // Copy for children\n            cProps = [ \"fontSize\" ],\n            vProps = [ \"borderTopWidth\", \"borderBottomWidth\", \"paddingTop\", \"paddingBottom\" ],\n            hProps = [ \"borderLeftWidth\", \"borderRightWidth\", \"paddingLeft\", \"paddingRight\" ],\n\n            // Set options\n            mode = options.mode,\n            restore = mode !== \"effect\",\n            scale = options.scale || \"both\",\n            origin = options.origin || [ \"middle\", \"center\" ],\n            position = element.css( \"position\" ),\n            pos = element.position(),\n            original = $.effects.scaledDimensions( element ),\n            from = options.from || original,\n            to = options.to || $.effects.scaledDimensions( element, 0 );\n\n        $.effects.createPlaceholder( element );\n\n        if ( mode === \"show\" ) {\n            temp = from;\n            from = to;\n            to = temp;\n        }\n\n        // Set scaling factor\n        factor = {\n            from: {\n                y: from.height / original.height,\n                x: from.width / original.width\n            },\n            to: {\n                y: to.height / original.height,\n                x: to.width / original.width\n            }\n        };\n\n        // Scale the css box\n        if ( scale === \"box\" || scale === \"both\" ) {\n\n            // Vertical props scaling\n            if ( factor.from.y !== factor.to.y ) {\n                from = $.effects.setTransition( element, vProps, factor.from.y, from );\n                to = $.effects.setTransition( element, vProps, factor.to.y, to );\n            }\n\n            // Horizontal props scaling\n            if ( factor.from.x !== factor.to.x ) {\n                from = $.effects.setTransition( element, hProps, factor.from.x, from );\n                to = $.effects.setTransition( element, hProps, factor.to.x, to );\n            }\n        }\n\n        // Scale the content\n        if ( scale === \"content\" || scale === \"both\" ) {\n\n            // Vertical props scaling\n            if ( factor.from.y !== factor.to.y ) {\n                from = $.effects.setTransition( element, cProps, factor.from.y, from );\n                to = $.effects.setTransition( element, cProps, factor.to.y, to );\n            }\n        }\n\n        // Adjust the position properties based on the provided origin points\n        if ( origin ) {\n            baseline = $.effects.getBaseline( origin, original );\n            from.top = ( original.outerHeight - from.outerHeight ) * baseline.y + pos.top;\n            from.left = ( original.outerWidth - from.outerWidth ) * baseline.x + pos.left;\n            to.top = ( original.outerHeight - to.outerHeight ) * baseline.y + pos.top;\n            to.left = ( original.outerWidth - to.outerWidth ) * baseline.x + pos.left;\n        }\n        delete from.outerHeight;\n        delete from.outerWidth;\n        element.css( from );\n\n        // Animate the children if desired\n        if ( scale === \"content\" || scale === \"both\" ) {\n\n            vProps = vProps.concat( [ \"marginTop\", \"marginBottom\" ] ).concat( cProps );\n            hProps = hProps.concat( [ \"marginLeft\", \"marginRight\" ] );\n\n            // Only animate children with width attributes specified\n            // TODO: is this right? should we include anything with css width specified as well\n            element.find( \"*[width]\" ).each( function() {\n                var child = $( this ),\n                    childOriginal = $.effects.scaledDimensions( child ),\n                    childFrom = {\n                        height: childOriginal.height * factor.from.y,\n                        width: childOriginal.width * factor.from.x,\n                        outerHeight: childOriginal.outerHeight * factor.from.y,\n                        outerWidth: childOriginal.outerWidth * factor.from.x\n                    },\n                    childTo = {\n                        height: childOriginal.height * factor.to.y,\n                        width: childOriginal.width * factor.to.x,\n                        outerHeight: childOriginal.height * factor.to.y,\n                        outerWidth: childOriginal.width * factor.to.x\n                    };\n\n                // Vertical props scaling\n                if ( factor.from.y !== factor.to.y ) {\n                    childFrom = $.effects.setTransition( child, vProps, factor.from.y, childFrom );\n                    childTo = $.effects.setTransition( child, vProps, factor.to.y, childTo );\n                }\n\n                // Horizontal props scaling\n                if ( factor.from.x !== factor.to.x ) {\n                    childFrom = $.effects.setTransition( child, hProps, factor.from.x, childFrom );\n                    childTo = $.effects.setTransition( child, hProps, factor.to.x, childTo );\n                }\n\n                if ( restore ) {\n                    $.effects.saveStyle( child );\n                }\n\n                // Animate children\n                child.css( childFrom );\n                child.animate( childTo, options.duration, options.easing, function() {\n\n                    // Restore children\n                    if ( restore ) {\n                        $.effects.restoreStyle( child );\n                    }\n                } );\n            } );\n        }\n\n        // Animate\n        element.animate( to, {\n            queue: false,\n            duration: options.duration,\n            easing: options.easing,\n            complete: function() {\n\n                var offset = element.offset();\n\n                if ( to.opacity === 0 ) {\n                    element.css( \"opacity\", from.opacity );\n                }\n\n                if ( !restore ) {\n                    element\n                        .css( \"position\", position === \"static\" ? \"relative\" : position )\n                        .offset( offset );\n\n                    // Need to save style here so that automatic style restoration\n                    // doesn't restore to the original styles from before the animation.\n                    $.effects.saveStyle( element );\n                }\n\n                done();\n            }\n        } );\n\n    } );\n\n} );\n","jquery/ui-modules/effects/effect-shake.js":"/*!\n * jQuery UI Effects Shake 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Shake Effect\n//>>group: Effects\n//>>description: Shakes an element horizontally or vertically n times.\n//>>docs: http://api.jqueryui.com/shake-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../effect\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.effects.define( \"shake\", function( options, done ) {\n\n        var i = 1,\n            element = $( this ),\n            direction = options.direction || \"left\",\n            distance = options.distance || 20,\n            times = options.times || 3,\n            anims = times * 2 + 1,\n            speed = Math.round( options.duration / anims ),\n            ref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n            positiveMotion = ( direction === \"up\" || direction === \"left\" ),\n            animation = {},\n            animation1 = {},\n            animation2 = {},\n\n            queuelen = element.queue().length;\n\n        $.effects.createPlaceholder( element );\n\n        // Animation\n        animation[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance;\n        animation1[ ref ] = ( positiveMotion ? \"+=\" : \"-=\" ) + distance * 2;\n        animation2[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance * 2;\n\n        // Animate\n        element.animate( animation, speed, options.easing );\n\n        // Shakes\n        for ( ; i < times; i++ ) {\n            element\n                .animate( animation1, speed, options.easing )\n                .animate( animation2, speed, options.easing );\n        }\n\n        element\n            .animate( animation1, speed, options.easing )\n            .animate( animation, speed / 2, options.easing )\n            .queue( done );\n\n        $.effects.unshift( element, queuelen, anims + 1 );\n    } );\n\n} );\n","jquery/ui-modules/widgets/sortable.js":"/*!\n * jQuery UI Sortable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Sortable\n//>>group: Interactions\n//>>description: Enables items in a list to be sorted using the mouse.\n//>>docs: http://api.jqueryui.com/sortable/\n//>>demos: http://jqueryui.com/sortable/\n//>>css.structure: ../../themes/base/sortable.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../data\",\n            \"../ie\",\n            \"../scroll-parent\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.sortable\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"sort\",\n        ready: false,\n        options: {\n            appendTo: \"parent\",\n            axis: false,\n            connectWith: false,\n            containment: false,\n            cursor: \"auto\",\n            cursorAt: false,\n            dropOnEmpty: true,\n            forcePlaceholderSize: false,\n            forceHelperSize: false,\n            grid: false,\n            handle: false,\n            helper: \"original\",\n            items: \"> *\",\n            opacity: false,\n            placeholder: false,\n            revert: false,\n            scroll: true,\n            scrollSensitivity: 20,\n            scrollSpeed: 20,\n            scope: \"default\",\n            tolerance: \"intersect\",\n            zIndex: 1000,\n\n            // Callbacks\n            activate: null,\n            beforeStop: null,\n            change: null,\n            deactivate: null,\n            out: null,\n            over: null,\n            receive: null,\n            remove: null,\n            sort: null,\n            start: null,\n            stop: null,\n            update: null\n        },\n\n        _isOverAxis: function( x, reference, size ) {\n            return ( x >= reference ) && ( x < ( reference + size ) );\n        },\n\n        _isFloating: function( item ) {\n            return ( /left|right/ ).test( item.css( \"float\" ) ) ||\n                ( /inline|table-cell/ ).test( item.css( \"display\" ) );\n        },\n\n        _create: function() {\n            this.containerCache = {};\n            this._addClass( \"ui-sortable\" );\n\n            //Get the items\n            this.refresh();\n\n            //Let's determine the parent's offset\n            this.offset = this.element.offset();\n\n            //Initialize mouse events for interaction\n            this._mouseInit();\n\n            this._setHandleClassName();\n\n            //We're ready to go\n            this.ready = true;\n\n        },\n\n        _setOption: function( key, value ) {\n            this._super( key, value );\n\n            if ( key === \"handle\" ) {\n                this._setHandleClassName();\n            }\n        },\n\n        _setHandleClassName: function() {\n            var that = this;\n            this._removeClass( this.element.find( \".ui-sortable-handle\" ), \"ui-sortable-handle\" );\n            $.each( this.items, function() {\n                that._addClass(\n                    this.instance.options.handle ?\n                        this.item.find( this.instance.options.handle ) :\n                        this.item,\n                    \"ui-sortable-handle\"\n                );\n            } );\n        },\n\n        _destroy: function() {\n            this._mouseDestroy();\n\n            for ( var i = this.items.length - 1; i >= 0; i-- ) {\n                this.items[ i ].item.removeData( this.widgetName + \"-item\" );\n            }\n\n            return this;\n        },\n\n        _mouseCapture: function( event, overrideHandle ) {\n            var currentItem = null,\n                validHandle = false,\n                that = this;\n\n            if ( this.reverting ) {\n                return false;\n            }\n\n            if ( this.options.disabled || this.options.type === \"static\" ) {\n                return false;\n            }\n\n            //We have to refresh the items data once first\n            this._refreshItems( event );\n\n            //Find out if the clicked node (or one of its parents) is a actual item in this.items\n            $( event.target ).parents().each( function() {\n                if ( $.data( this, that.widgetName + \"-item\" ) === that ) {\n                    currentItem = $( this );\n                    return false;\n                }\n            } );\n            if ( $.data( event.target, that.widgetName + \"-item\" ) === that ) {\n                currentItem = $( event.target );\n            }\n\n            if ( !currentItem ) {\n                return false;\n            }\n            if ( this.options.handle && !overrideHandle ) {\n                $( this.options.handle, currentItem ).find( \"*\" ).addBack().each( function() {\n                    if ( this === event.target ) {\n                        validHandle = true;\n                    }\n                } );\n                if ( !validHandle ) {\n                    return false;\n                }\n            }\n\n            this.currentItem = currentItem;\n            this._removeCurrentsFromItems();\n            return true;\n\n        },\n\n        _mouseStart: function( event, overrideHandle, noActivation ) {\n\n            var i, body,\n                o = this.options;\n\n            this.currentContainer = this;\n\n            //We only need to call refreshPositions, because the refreshItems call has been moved to\n            // mouseCapture\n            this.refreshPositions();\n\n            //Prepare the dragged items parent\n            this.appendTo = $( o.appendTo !== \"parent\" ?\n                o.appendTo :\n                this.currentItem.parent() );\n\n            //Create and append the visible helper\n            this.helper = this._createHelper( event );\n\n            //Cache the helper size\n            this._cacheHelperProportions();\n\n            /*\n             * - Position generation -\n             * This block generates everything position related - it's the core of draggables.\n             */\n\n            //Cache the margins of the original element\n            this._cacheMargins();\n\n            //The element's absolute position on the page minus margins\n            this.offset = this.currentItem.offset();\n            this.offset = {\n                top: this.offset.top - this.margins.top,\n                left: this.offset.left - this.margins.left\n            };\n\n            $.extend( this.offset, {\n                click: { //Where the click happened, relative to the element\n                    left: event.pageX - this.offset.left,\n                    top: event.pageY - this.offset.top\n                },\n\n                // This is a relative to absolute position minus the actual position calculation -\n                // only used for relative positioned helper\n                relative: this._getRelativeOffset()\n            } );\n\n            // After we get the helper offset, but before we get the parent offset we can\n            // change the helper's position to absolute\n            // TODO: Still need to figure out a way to make relative sorting possible\n            this.helper.css( \"position\", \"absolute\" );\n            this.cssPosition = this.helper.css( \"position\" );\n\n            //Adjust the mouse offset relative to the helper if \"cursorAt\" is supplied\n            if ( o.cursorAt ) {\n                this._adjustOffsetFromHelper( o.cursorAt );\n            }\n\n            //Cache the former DOM position\n            this.domPosition = {\n                prev: this.currentItem.prev()[ 0 ],\n                parent: this.currentItem.parent()[ 0 ]\n            };\n\n            // If the helper is not the original, hide the original so it's not playing any role during\n            // the drag, won't cause anything bad this way\n            if ( this.helper[ 0 ] !== this.currentItem[ 0 ] ) {\n                this.currentItem.hide();\n            }\n\n            //Create the placeholder\n            this._createPlaceholder();\n\n            //Get the next scrolling parent\n            this.scrollParent = this.placeholder.scrollParent();\n\n            $.extend( this.offset, {\n                parent: this._getParentOffset()\n            } );\n\n            //Set a containment if given in the options\n            if ( o.containment ) {\n                this._setContainment();\n            }\n\n            if ( o.cursor && o.cursor !== \"auto\" ) { // cursor option\n                body = this.document.find( \"body\" );\n\n                // Support: IE\n                this.storedCursor = body.css( \"cursor\" );\n                body.css( \"cursor\", o.cursor );\n\n                this.storedStylesheet =\n                    $( \"<style>*{ cursor: \" + o.cursor + \" !important; }</style>\" ).appendTo( body );\n            }\n\n            // We need to make sure to grab the zIndex before setting the\n            // opacity, because setting the opacity to anything lower than 1\n            // causes the zIndex to change from \"auto\" to 0.\n            if ( o.zIndex ) { // zIndex option\n                if ( this.helper.css( \"zIndex\" ) ) {\n                    this._storedZIndex = this.helper.css( \"zIndex\" );\n                }\n                this.helper.css( \"zIndex\", o.zIndex );\n            }\n\n            if ( o.opacity ) { // opacity option\n                if ( this.helper.css( \"opacity\" ) ) {\n                    this._storedOpacity = this.helper.css( \"opacity\" );\n                }\n                this.helper.css( \"opacity\", o.opacity );\n            }\n\n            //Prepare scrolling\n            if ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                this.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n                this.overflowOffset = this.scrollParent.offset();\n            }\n\n            //Call callbacks\n            this._trigger( \"start\", event, this._uiHash() );\n\n            //Recache the helper size\n            if ( !this._preserveHelperProportions ) {\n                this._cacheHelperProportions();\n            }\n\n            //Post \"activate\" events to possible containers\n            if ( !noActivation ) {\n                for ( i = this.containers.length - 1; i >= 0; i-- ) {\n                    this.containers[ i ]._trigger( \"activate\", event, this._uiHash( this ) );\n                }\n            }\n\n            //Prepare possible droppables\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.current = this;\n            }\n\n            if ( $.ui.ddmanager && !o.dropBehaviour ) {\n                $.ui.ddmanager.prepareOffsets( this, event );\n            }\n\n            this.dragging = true;\n\n            this._addClass( this.helper, \"ui-sortable-helper\" );\n\n            //Move the helper, if needed\n            if ( !this.helper.parent().is( this.appendTo ) ) {\n                this.helper.detach().appendTo( this.appendTo );\n\n                //Update position\n                this.offset.parent = this._getParentOffset();\n            }\n\n            //Generate the original position\n            this.position = this.originalPosition = this._generatePosition( event );\n            this.originalPageX = event.pageX;\n            this.originalPageY = event.pageY;\n            this.lastPositionAbs = this.positionAbs = this._convertPositionTo( \"absolute\" );\n\n            this._mouseDrag( event );\n\n            return true;\n\n        },\n\n        _scroll: function( event ) {\n            var o = this.options,\n                scrolled = false;\n\n            if ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                this.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n\n                if ( ( this.overflowOffset.top + this.scrollParent[ 0 ].offsetHeight ) -\n                    event.pageY < o.scrollSensitivity ) {\n                    this.scrollParent[ 0 ].scrollTop =\n                        scrolled = this.scrollParent[ 0 ].scrollTop + o.scrollSpeed;\n                } else if ( event.pageY - this.overflowOffset.top < o.scrollSensitivity ) {\n                    this.scrollParent[ 0 ].scrollTop =\n                        scrolled = this.scrollParent[ 0 ].scrollTop - o.scrollSpeed;\n                }\n\n                if ( ( this.overflowOffset.left + this.scrollParent[ 0 ].offsetWidth ) -\n                    event.pageX < o.scrollSensitivity ) {\n                    this.scrollParent[ 0 ].scrollLeft = scrolled =\n                        this.scrollParent[ 0 ].scrollLeft + o.scrollSpeed;\n                } else if ( event.pageX - this.overflowOffset.left < o.scrollSensitivity ) {\n                    this.scrollParent[ 0 ].scrollLeft = scrolled =\n                        this.scrollParent[ 0 ].scrollLeft - o.scrollSpeed;\n                }\n\n            } else {\n\n                if ( event.pageY - this.document.scrollTop() < o.scrollSensitivity ) {\n                    scrolled = this.document.scrollTop( this.document.scrollTop() - o.scrollSpeed );\n                } else if ( this.window.height() - ( event.pageY - this.document.scrollTop() ) <\n                    o.scrollSensitivity ) {\n                    scrolled = this.document.scrollTop( this.document.scrollTop() + o.scrollSpeed );\n                }\n\n                if ( event.pageX - this.document.scrollLeft() < o.scrollSensitivity ) {\n                    scrolled = this.document.scrollLeft(\n                        this.document.scrollLeft() - o.scrollSpeed\n                    );\n                } else if ( this.window.width() - ( event.pageX - this.document.scrollLeft() ) <\n                    o.scrollSensitivity ) {\n                    scrolled = this.document.scrollLeft(\n                        this.document.scrollLeft() + o.scrollSpeed\n                    );\n                }\n\n            }\n\n            return scrolled;\n        },\n\n        _mouseDrag: function( event ) {\n            var i, item, itemElement, intersection,\n                o = this.options;\n\n            //Compute the helpers position\n            this.position = this._generatePosition( event );\n            this.positionAbs = this._convertPositionTo( \"absolute\" );\n\n            //Set the helper position\n            if ( !this.options.axis || this.options.axis !== \"y\" ) {\n                this.helper[ 0 ].style.left = this.position.left + \"px\";\n            }\n            if ( !this.options.axis || this.options.axis !== \"x\" ) {\n                this.helper[ 0 ].style.top = this.position.top + \"px\";\n            }\n\n            //Do scrolling\n            if ( o.scroll ) {\n                if ( this._scroll( event ) !== false ) {\n\n                    //Update item positions used in position checks\n                    this._refreshItemPositions( true );\n\n                    if ( $.ui.ddmanager && !o.dropBehaviour ) {\n                        $.ui.ddmanager.prepareOffsets( this, event );\n                    }\n                }\n            }\n\n            this.dragDirection = {\n                vertical: this._getDragVerticalDirection(),\n                horizontal: this._getDragHorizontalDirection()\n            };\n\n            //Rearrange\n            for ( i = this.items.length - 1; i >= 0; i-- ) {\n\n                //Cache variables and intersection, continue if no intersection\n                item = this.items[ i ];\n                itemElement = item.item[ 0 ];\n                intersection = this._intersectsWithPointer( item );\n                if ( !intersection ) {\n                    continue;\n                }\n\n                // Only put the placeholder inside the current Container, skip all\n                // items from other containers. This works because when moving\n                // an item from one container to another the\n                // currentContainer is switched before the placeholder is moved.\n                //\n                // Without this, moving items in \"sub-sortables\" can cause\n                // the placeholder to jitter between the outer and inner container.\n                if ( item.instance !== this.currentContainer ) {\n                    continue;\n                }\n\n                // Cannot intersect with itself\n                // no useless actions that have been done before\n                // no action if the item moved is the parent of the item checked\n                if ( itemElement !== this.currentItem[ 0 ] &&\n                    this.placeholder[ intersection === 1 ?\n                        \"next\" : \"prev\" ]()[ 0 ] !== itemElement &&\n                    !$.contains( this.placeholder[ 0 ], itemElement ) &&\n                    ( this.options.type === \"semi-dynamic\" ?\n                            !$.contains( this.element[ 0 ], itemElement ) :\n                            true\n                    )\n                ) {\n\n                    this.direction = intersection === 1 ? \"down\" : \"up\";\n\n                    if ( this.options.tolerance === \"pointer\" ||\n                        this._intersectsWithSides( item ) ) {\n                        this._rearrange( event, item );\n                    } else {\n                        break;\n                    }\n\n                    this._trigger( \"change\", event, this._uiHash() );\n                    break;\n                }\n            }\n\n            //Post events to containers\n            this._contactContainers( event );\n\n            //Interconnect with droppables\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.drag( this, event );\n            }\n\n            //Call callbacks\n            this._trigger( \"sort\", event, this._uiHash() );\n\n            this.lastPositionAbs = this.positionAbs;\n            return false;\n\n        },\n\n        _mouseStop: function( event, noPropagation ) {\n\n            if ( !event ) {\n                return;\n            }\n\n            //If we are using droppables, inform the manager about the drop\n            if ( $.ui.ddmanager && !this.options.dropBehaviour ) {\n                $.ui.ddmanager.drop( this, event );\n            }\n\n            if ( this.options.revert ) {\n                var that = this,\n                    cur = this.placeholder.offset(),\n                    axis = this.options.axis,\n                    animation = {};\n\n                if ( !axis || axis === \"x\" ) {\n                    animation.left = cur.left - this.offset.parent.left - this.margins.left +\n                        ( this.offsetParent[ 0 ] === this.document[ 0 ].body ?\n                                0 :\n                                this.offsetParent[ 0 ].scrollLeft\n                        );\n                }\n                if ( !axis || axis === \"y\" ) {\n                    animation.top = cur.top - this.offset.parent.top - this.margins.top +\n                        ( this.offsetParent[ 0 ] === this.document[ 0 ].body ?\n                                0 :\n                                this.offsetParent[ 0 ].scrollTop\n                        );\n                }\n                this.reverting = true;\n                $( this.helper ).animate(\n                    animation,\n                    parseInt( this.options.revert, 10 ) || 500,\n                    function() {\n                        that._clear( event );\n                    }\n                );\n            } else {\n                this._clear( event, noPropagation );\n            }\n\n            return false;\n\n        },\n\n        cancel: function() {\n\n            if ( this.dragging ) {\n\n                this._mouseUp( new $.Event( \"mouseup\", { target: null } ) );\n\n                if ( this.options.helper === \"original\" ) {\n                    this.currentItem.css( this._storedCSS );\n                    this._removeClass( this.currentItem, \"ui-sortable-helper\" );\n                } else {\n                    this.currentItem.show();\n                }\n\n                //Post deactivating events to containers\n                for ( var i = this.containers.length - 1; i >= 0; i-- ) {\n                    this.containers[ i ]._trigger( \"deactivate\", null, this._uiHash( this ) );\n                    if ( this.containers[ i ].containerCache.over ) {\n                        this.containers[ i ]._trigger( \"out\", null, this._uiHash( this ) );\n                        this.containers[ i ].containerCache.over = 0;\n                    }\n                }\n\n            }\n\n            if ( this.placeholder ) {\n\n                //$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately,\n                // it unbinds ALL events from the original node!\n                if ( this.placeholder[ 0 ].parentNode ) {\n                    this.placeholder[ 0 ].parentNode.removeChild( this.placeholder[ 0 ] );\n                }\n                if ( this.options.helper !== \"original\" && this.helper &&\n                    this.helper[ 0 ].parentNode ) {\n                    this.helper.remove();\n                }\n\n                $.extend( this, {\n                    helper: null,\n                    dragging: false,\n                    reverting: false,\n                    _noFinalSort: null\n                } );\n\n                if ( this.domPosition.prev ) {\n                    $( this.domPosition.prev ).after( this.currentItem );\n                } else {\n                    $( this.domPosition.parent ).prepend( this.currentItem );\n                }\n            }\n\n            return this;\n\n        },\n\n        serialize: function( o ) {\n\n            var items = this._getItemsAsjQuery( o && o.connected ),\n                str = [];\n            o = o || {};\n\n            $( items ).each( function() {\n                var res = ( $( o.item || this ).attr( o.attribute || \"id\" ) || \"\" )\n                    .match( o.expression || ( /(.+)[\\-=_](.+)/ ) );\n                if ( res ) {\n                    str.push(\n                        ( o.key || res[ 1 ] + \"[]\" ) +\n                        \"=\" + ( o.key && o.expression ? res[ 1 ] : res[ 2 ] ) );\n                }\n            } );\n\n            if ( !str.length && o.key ) {\n                str.push( o.key + \"=\" );\n            }\n\n            return str.join( \"&\" );\n\n        },\n\n        toArray: function( o ) {\n\n            var items = this._getItemsAsjQuery( o && o.connected ),\n                ret = [];\n\n            o = o || {};\n\n            items.each( function() {\n                ret.push( $( o.item || this ).attr( o.attribute || \"id\" ) || \"\" );\n            } );\n            return ret;\n\n        },\n\n        /* Be careful with the following core functions */\n        _intersectsWith: function( item ) {\n\n            var x1 = this.positionAbs.left,\n                x2 = x1 + this.helperProportions.width,\n                y1 = this.positionAbs.top,\n                y2 = y1 + this.helperProportions.height,\n                l = item.left,\n                r = l + item.width,\n                t = item.top,\n                b = t + item.height,\n                dyClick = this.offset.click.top,\n                dxClick = this.offset.click.left,\n                isOverElementHeight = ( this.options.axis === \"x\" ) || ( ( y1 + dyClick ) > t &&\n                    ( y1 + dyClick ) < b ),\n                isOverElementWidth = ( this.options.axis === \"y\" ) || ( ( x1 + dxClick ) > l &&\n                    ( x1 + dxClick ) < r ),\n                isOverElement = isOverElementHeight && isOverElementWidth;\n\n            if ( this.options.tolerance === \"pointer\" ||\n                this.options.forcePointerForContainers ||\n                ( this.options.tolerance !== \"pointer\" &&\n                    this.helperProportions[ this.floating ? \"width\" : \"height\" ] >\n                    item[ this.floating ? \"width\" : \"height\" ] )\n            ) {\n                return isOverElement;\n            } else {\n\n                return ( l < x1 + ( this.helperProportions.width / 2 ) && // Right Half\n                    x2 - ( this.helperProportions.width / 2 ) < r && // Left Half\n                    t < y1 + ( this.helperProportions.height / 2 ) && // Bottom Half\n                    y2 - ( this.helperProportions.height / 2 ) < b ); // Top Half\n\n            }\n        },\n\n        _intersectsWithPointer: function( item ) {\n            var verticalDirection, horizontalDirection,\n                isOverElementHeight = ( this.options.axis === \"x\" ) ||\n                    this._isOverAxis(\n                        this.positionAbs.top + this.offset.click.top, item.top, item.height ),\n                isOverElementWidth = ( this.options.axis === \"y\" ) ||\n                    this._isOverAxis(\n                        this.positionAbs.left + this.offset.click.left, item.left, item.width ),\n                isOverElement = isOverElementHeight && isOverElementWidth;\n\n            if ( !isOverElement ) {\n                return false;\n            }\n\n            verticalDirection = this.dragDirection.vertical;\n            horizontalDirection = this.dragDirection.horizontal;\n\n            return this.floating ?\n                ( ( horizontalDirection === \"right\" || verticalDirection === \"down\" ) ? 2 : 1 ) :\n                ( verticalDirection && ( verticalDirection === \"down\" ? 2 : 1 ) );\n\n        },\n\n        _intersectsWithSides: function( item ) {\n\n            var isOverBottomHalf = this._isOverAxis( this.positionAbs.top +\n                    this.offset.click.top, item.top + ( item.height / 2 ), item.height ),\n                isOverRightHalf = this._isOverAxis( this.positionAbs.left +\n                    this.offset.click.left, item.left + ( item.width / 2 ), item.width ),\n                verticalDirection = this.dragDirection.vertical,\n                horizontalDirection = this.dragDirection.horizontal;\n\n            if ( this.floating && horizontalDirection ) {\n                return ( ( horizontalDirection === \"right\" && isOverRightHalf ) ||\n                    ( horizontalDirection === \"left\" && !isOverRightHalf ) );\n            } else {\n                return verticalDirection && ( ( verticalDirection === \"down\" && isOverBottomHalf ) ||\n                    ( verticalDirection === \"up\" && !isOverBottomHalf ) );\n            }\n\n        },\n\n        _getDragVerticalDirection: function() {\n            var delta = this.positionAbs.top - this.lastPositionAbs.top;\n            return delta !== 0 && ( delta > 0 ? \"down\" : \"up\" );\n        },\n\n        _getDragHorizontalDirection: function() {\n            var delta = this.positionAbs.left - this.lastPositionAbs.left;\n            return delta !== 0 && ( delta > 0 ? \"right\" : \"left\" );\n        },\n\n        refresh: function( event ) {\n            this._refreshItems( event );\n            this._setHandleClassName();\n            this.refreshPositions();\n            return this;\n        },\n\n        _connectWith: function() {\n            var options = this.options;\n            return options.connectWith.constructor === String ?\n                [ options.connectWith ] :\n                options.connectWith;\n        },\n\n        _getItemsAsjQuery: function( connected ) {\n\n            var i, j, cur, inst,\n                items = [],\n                queries = [],\n                connectWith = this._connectWith();\n\n            if ( connectWith && connected ) {\n                for ( i = connectWith.length - 1; i >= 0; i-- ) {\n                    cur = $( connectWith[ i ], this.document[ 0 ] );\n                    for ( j = cur.length - 1; j >= 0; j-- ) {\n                        inst = $.data( cur[ j ], this.widgetFullName );\n                        if ( inst && inst !== this && !inst.options.disabled ) {\n                            queries.push( [ typeof inst.options.items === \"function\" ?\n                                inst.options.items.call( inst.element ) :\n                                $( inst.options.items, inst.element )\n                                    .not( \".ui-sortable-helper\" )\n                                    .not( \".ui-sortable-placeholder\" ), inst ] );\n                        }\n                    }\n                }\n            }\n\n            queries.push( [ typeof this.options.items === \"function\" ?\n                this.options.items\n                    .call( this.element, null, { options: this.options, item: this.currentItem } ) :\n                $( this.options.items, this.element )\n                    .not( \".ui-sortable-helper\" )\n                    .not( \".ui-sortable-placeholder\" ), this ] );\n\n            function addItems() {\n                items.push( this );\n            }\n            for ( i = queries.length - 1; i >= 0; i-- ) {\n                queries[ i ][ 0 ].each( addItems );\n            }\n\n            return $( items );\n\n        },\n\n        _removeCurrentsFromItems: function() {\n\n            var list = this.currentItem.find( \":data(\" + this.widgetName + \"-item)\" );\n\n            this.items = $.grep( this.items, function( item ) {\n                for ( var j = 0; j < list.length; j++ ) {\n                    if ( list[ j ] === item.item[ 0 ] ) {\n                        return false;\n                    }\n                }\n                return true;\n            } );\n\n        },\n\n        _refreshItems: function( event ) {\n\n            this.items = [];\n            this.containers = [ this ];\n\n            var i, j, cur, inst, targetData, _queries, item, queriesLength,\n                items = this.items,\n                queries = [ [ typeof this.options.items === \"function\" ?\n                    this.options.items.call( this.element[ 0 ], event, { item: this.currentItem } ) :\n                    $( this.options.items, this.element ), this ] ],\n                connectWith = this._connectWith();\n\n            //Shouldn't be run the first time through due to massive slow-down\n            if ( connectWith && this.ready ) {\n                for ( i = connectWith.length - 1; i >= 0; i-- ) {\n                    cur = $( connectWith[ i ], this.document[ 0 ] );\n                    for ( j = cur.length - 1; j >= 0; j-- ) {\n                        inst = $.data( cur[ j ], this.widgetFullName );\n                        if ( inst && inst !== this && !inst.options.disabled ) {\n                            queries.push( [ typeof inst.options.items === \"function\" ?\n                                inst.options.items\n                                    .call( inst.element[ 0 ], event, { item: this.currentItem } ) :\n                                $( inst.options.items, inst.element ), inst ] );\n                            this.containers.push( inst );\n                        }\n                    }\n                }\n            }\n\n            for ( i = queries.length - 1; i >= 0; i-- ) {\n                targetData = queries[ i ][ 1 ];\n                _queries = queries[ i ][ 0 ];\n\n                for ( j = 0, queriesLength = _queries.length; j < queriesLength; j++ ) {\n                    item = $( _queries[ j ] );\n\n                    // Data for target checking (mouse manager)\n                    item.data( this.widgetName + \"-item\", targetData );\n\n                    items.push( {\n                        item: item,\n                        instance: targetData,\n                        width: 0, height: 0,\n                        left: 0, top: 0\n                    } );\n                }\n            }\n\n        },\n\n        _refreshItemPositions: function( fast ) {\n            var i, item, t, p;\n\n            for ( i = this.items.length - 1; i >= 0; i-- ) {\n                item = this.items[ i ];\n\n                //We ignore calculating positions of all connected containers when we're not over them\n                if ( this.currentContainer && item.instance !== this.currentContainer &&\n                    item.item[ 0 ] !== this.currentItem[ 0 ] ) {\n                    continue;\n                }\n\n                t = this.options.toleranceElement ?\n                    $( this.options.toleranceElement, item.item ) :\n                    item.item;\n\n                if ( !fast ) {\n                    item.width = t.outerWidth();\n                    item.height = t.outerHeight();\n                }\n\n                p = t.offset();\n                item.left = p.left;\n                item.top = p.top;\n            }\n        },\n\n        refreshPositions: function( fast ) {\n\n            // Determine whether items are being displayed horizontally\n            this.floating = this.items.length ?\n                this.options.axis === \"x\" || this._isFloating( this.items[ 0 ].item ) :\n                false;\n\n            // This has to be redone because due to the item being moved out/into the offsetParent,\n            // the offsetParent's position will change\n            if ( this.offsetParent && this.helper ) {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            this._refreshItemPositions( fast );\n\n            var i, p;\n\n            if ( this.options.custom && this.options.custom.refreshContainers ) {\n                this.options.custom.refreshContainers.call( this );\n            } else {\n                for ( i = this.containers.length - 1; i >= 0; i-- ) {\n                    p = this.containers[ i ].element.offset();\n                    this.containers[ i ].containerCache.left = p.left;\n                    this.containers[ i ].containerCache.top = p.top;\n                    this.containers[ i ].containerCache.width =\n                        this.containers[ i ].element.outerWidth();\n                    this.containers[ i ].containerCache.height =\n                        this.containers[ i ].element.outerHeight();\n                }\n            }\n\n            return this;\n        },\n\n        _createPlaceholder: function( that ) {\n            that = that || this;\n            var className, nodeName,\n                o = that.options;\n\n            if ( !o.placeholder || o.placeholder.constructor === String ) {\n                className = o.placeholder;\n                nodeName = that.currentItem[ 0 ].nodeName.toLowerCase();\n                o.placeholder = {\n                    element: function() {\n\n                        var element = $( \"<\" + nodeName + \">\", that.document[ 0 ] );\n\n                        that._addClass( element, \"ui-sortable-placeholder\",\n                            className || that.currentItem[ 0 ].className )\n                            ._removeClass( element, \"ui-sortable-helper\" );\n\n                        if ( nodeName === \"tbody\" ) {\n                            that._createTrPlaceholder(\n                                that.currentItem.find( \"tr\" ).eq( 0 ),\n                                $( \"<tr>\", that.document[ 0 ] ).appendTo( element )\n                            );\n                        } else if ( nodeName === \"tr\" ) {\n                            that._createTrPlaceholder( that.currentItem, element );\n                        } else if ( nodeName === \"img\" ) {\n                            element.attr( \"src\", that.currentItem.attr( \"src\" ) );\n                        }\n\n                        if ( !className ) {\n                            element.css( \"visibility\", \"hidden\" );\n                        }\n\n                        return element;\n                    },\n                    update: function( container, p ) {\n\n                        // 1. If a className is set as 'placeholder option, we don't force sizes -\n                        // the class is responsible for that\n                        // 2. The option 'forcePlaceholderSize can be enabled to force it even if a\n                        // class name is specified\n                        if ( className && !o.forcePlaceholderSize ) {\n                            return;\n                        }\n\n                        // If the element doesn't have a actual height or width by itself (without\n                        // styles coming from a stylesheet), it receives the inline height and width\n                        // from the dragged item. Or, if it's a tbody or tr, it's going to have a height\n                        // anyway since we're populating them with <td>s above, but they're unlikely to\n                        // be the correct height on their own if the row heights are dynamic, so we'll\n                        // always assign the height of the dragged item given forcePlaceholderSize\n                        // is true.\n                        if ( !p.height() || ( o.forcePlaceholderSize &&\n                            ( nodeName === \"tbody\" || nodeName === \"tr\" ) ) ) {\n                            p.height(\n                                that.currentItem.innerHeight() -\n                                parseInt( that.currentItem.css( \"paddingTop\" ) || 0, 10 ) -\n                                parseInt( that.currentItem.css( \"paddingBottom\" ) || 0, 10 ) );\n                        }\n                        if ( !p.width() ) {\n                            p.width(\n                                that.currentItem.innerWidth() -\n                                parseInt( that.currentItem.css( \"paddingLeft\" ) || 0, 10 ) -\n                                parseInt( that.currentItem.css( \"paddingRight\" ) || 0, 10 ) );\n                        }\n                    }\n                };\n            }\n\n            //Create the placeholder\n            that.placeholder = $( o.placeholder.element.call( that.element, that.currentItem ) );\n\n            //Append it after the actual current item\n            that.currentItem.after( that.placeholder );\n\n            //Update the size of the placeholder (TODO: Logic to fuzzy, see line 316/317)\n            o.placeholder.update( that, that.placeholder );\n\n        },\n\n        _createTrPlaceholder: function( sourceTr, targetTr ) {\n            var that = this;\n\n            sourceTr.children().each( function() {\n                $( \"<td>&#160;</td>\", that.document[ 0 ] )\n                    .attr( \"colspan\", $( this ).attr( \"colspan\" ) || 1 )\n                    .appendTo( targetTr );\n            } );\n        },\n\n        _contactContainers: function( event ) {\n            var i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, cur, nearBottom,\n                floating, axis,\n                innermostContainer = null,\n                innermostIndex = null;\n\n            // Get innermost container that intersects with item\n            for ( i = this.containers.length - 1; i >= 0; i-- ) {\n\n                // Never consider a container that's located within the item itself\n                if ( $.contains( this.currentItem[ 0 ], this.containers[ i ].element[ 0 ] ) ) {\n                    continue;\n                }\n\n                if ( this._intersectsWith( this.containers[ i ].containerCache ) ) {\n\n                    // If we've already found a container and it's more \"inner\" than this, then continue\n                    if ( innermostContainer &&\n                        $.contains(\n                            this.containers[ i ].element[ 0 ],\n                            innermostContainer.element[ 0 ] ) ) {\n                        continue;\n                    }\n\n                    innermostContainer = this.containers[ i ];\n                    innermostIndex = i;\n\n                } else {\n\n                    // container doesn't intersect. trigger \"out\" event if necessary\n                    if ( this.containers[ i ].containerCache.over ) {\n                        this.containers[ i ]._trigger( \"out\", event, this._uiHash( this ) );\n                        this.containers[ i ].containerCache.over = 0;\n                    }\n                }\n\n            }\n\n            // If no intersecting containers found, return\n            if ( !innermostContainer ) {\n                return;\n            }\n\n            // Move the item into the container if it's not there already\n            if ( this.containers.length === 1 ) {\n                if ( !this.containers[ innermostIndex ].containerCache.over ) {\n                    this.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash( this ) );\n                    this.containers[ innermostIndex ].containerCache.over = 1;\n                }\n            } else {\n\n                // When entering a new container, we will find the item with the least distance and\n                // append our item near it\n                dist = 10000;\n                itemWithLeastDistance = null;\n                floating = innermostContainer.floating || this._isFloating( this.currentItem );\n                posProperty = floating ? \"left\" : \"top\";\n                sizeProperty = floating ? \"width\" : \"height\";\n                axis = floating ? \"pageX\" : \"pageY\";\n\n                for ( j = this.items.length - 1; j >= 0; j-- ) {\n                    if ( !$.contains(\n                        this.containers[ innermostIndex ].element[ 0 ], this.items[ j ].item[ 0 ] )\n                    ) {\n                        continue;\n                    }\n                    if ( this.items[ j ].item[ 0 ] === this.currentItem[ 0 ] ) {\n                        continue;\n                    }\n\n                    cur = this.items[ j ].item.offset()[ posProperty ];\n                    nearBottom = false;\n                    if ( event[ axis ] - cur > this.items[ j ][ sizeProperty ] / 2 ) {\n                        nearBottom = true;\n                    }\n\n                    if ( Math.abs( event[ axis ] - cur ) < dist ) {\n                        dist = Math.abs( event[ axis ] - cur );\n                        itemWithLeastDistance = this.items[ j ];\n                        this.direction = nearBottom ? \"up\" : \"down\";\n                    }\n                }\n\n                //Check if dropOnEmpty is enabled\n                if ( !itemWithLeastDistance && !this.options.dropOnEmpty ) {\n                    return;\n                }\n\n                if ( this.currentContainer === this.containers[ innermostIndex ] ) {\n                    if ( !this.currentContainer.containerCache.over ) {\n                        this.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash() );\n                        this.currentContainer.containerCache.over = 1;\n                    }\n                    return;\n                }\n\n                if ( itemWithLeastDistance ) {\n                    this._rearrange( event, itemWithLeastDistance, null, true );\n                } else {\n                    this._rearrange( event, null, this.containers[ innermostIndex ].element, true );\n                }\n                this._trigger( \"change\", event, this._uiHash() );\n                this.containers[ innermostIndex ]._trigger( \"change\", event, this._uiHash( this ) );\n                this.currentContainer = this.containers[ innermostIndex ];\n\n                //Update the placeholder\n                this.options.placeholder.update( this.currentContainer, this.placeholder );\n\n                //Update scrollParent\n                this.scrollParent = this.placeholder.scrollParent();\n\n                //Update overflowOffset\n                if ( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                    this.scrollParent[ 0 ].tagName !== \"HTML\" ) {\n                    this.overflowOffset = this.scrollParent.offset();\n                }\n\n                this.containers[ innermostIndex ]._trigger( \"over\", event, this._uiHash( this ) );\n                this.containers[ innermostIndex ].containerCache.over = 1;\n            }\n\n        },\n\n        _createHelper: function( event ) {\n\n            var o = this.options,\n                helper = typeof o.helper === \"function\" ?\n                    $( o.helper.apply( this.element[ 0 ], [ event, this.currentItem ] ) ) :\n                    ( o.helper === \"clone\" ? this.currentItem.clone() : this.currentItem );\n\n            //Add the helper to the DOM if that didn't happen already\n            if ( !helper.parents( \"body\" ).length ) {\n                this.appendTo[ 0 ].appendChild( helper[ 0 ] );\n            }\n\n            if ( helper[ 0 ] === this.currentItem[ 0 ] ) {\n                this._storedCSS = {\n                    width: this.currentItem[ 0 ].style.width,\n                    height: this.currentItem[ 0 ].style.height,\n                    position: this.currentItem.css( \"position\" ),\n                    top: this.currentItem.css( \"top\" ),\n                    left: this.currentItem.css( \"left\" )\n                };\n            }\n\n            if ( !helper[ 0 ].style.width || o.forceHelperSize ) {\n                helper.width( this.currentItem.width() );\n            }\n            if ( !helper[ 0 ].style.height || o.forceHelperSize ) {\n                helper.height( this.currentItem.height() );\n            }\n\n            return helper;\n\n        },\n\n        _adjustOffsetFromHelper: function( obj ) {\n            if ( typeof obj === \"string\" ) {\n                obj = obj.split( \" \" );\n            }\n            if ( Array.isArray( obj ) ) {\n                obj = { left: +obj[ 0 ], top: +obj[ 1 ] || 0 };\n            }\n            if ( \"left\" in obj ) {\n                this.offset.click.left = obj.left + this.margins.left;\n            }\n            if ( \"right\" in obj ) {\n                this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n            }\n            if ( \"top\" in obj ) {\n                this.offset.click.top = obj.top + this.margins.top;\n            }\n            if ( \"bottom\" in obj ) {\n                this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n            }\n        },\n\n        _getParentOffset: function() {\n\n            //Get the offsetParent and cache its position\n            this.offsetParent = this.helper.offsetParent();\n            var po = this.offsetParent.offset();\n\n            // This is a special case where we need to modify a offset calculated on start, since the\n            // following happened:\n            // 1. The position of the helper is absolute, so it's position is calculated based on the\n            // next positioned parent\n            // 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't\n            // the document, which means that the scroll is included in the initial calculation of the\n            // offset of the parent, and never recalculated upon drag\n            if ( this.cssPosition === \"absolute\" && this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) {\n                po.left += this.scrollParent.scrollLeft();\n                po.top += this.scrollParent.scrollTop();\n            }\n\n            // This needs to be actually done for all browsers, since pageX/pageY includes this\n            // information with an ugly IE fix\n            if ( this.offsetParent[ 0 ] === this.document[ 0 ].body ||\n                ( this.offsetParent[ 0 ].tagName &&\n                    this.offsetParent[ 0 ].tagName.toLowerCase() === \"html\" && $.ui.ie ) ) {\n                po = { top: 0, left: 0 };\n            }\n\n            return {\n                top: po.top + ( parseInt( this.offsetParent.css( \"borderTopWidth\" ), 10 ) || 0 ),\n                left: po.left + ( parseInt( this.offsetParent.css( \"borderLeftWidth\" ), 10 ) || 0 )\n            };\n\n        },\n\n        _getRelativeOffset: function() {\n\n            if ( this.cssPosition === \"relative\" ) {\n                var p = this.currentItem.position();\n                return {\n                    top: p.top - ( parseInt( this.helper.css( \"top\" ), 10 ) || 0 ) +\n                        this.scrollParent.scrollTop(),\n                    left: p.left - ( parseInt( this.helper.css( \"left\" ), 10 ) || 0 ) +\n                        this.scrollParent.scrollLeft()\n                };\n            } else {\n                return { top: 0, left: 0 };\n            }\n\n        },\n\n        _cacheMargins: function() {\n            this.margins = {\n                left: ( parseInt( this.currentItem.css( \"marginLeft\" ), 10 ) || 0 ),\n                top: ( parseInt( this.currentItem.css( \"marginTop\" ), 10 ) || 0 )\n            };\n        },\n\n        _cacheHelperProportions: function() {\n            this.helperProportions = {\n                width: this.helper.outerWidth(),\n                height: this.helper.outerHeight()\n            };\n        },\n\n        _setContainment: function() {\n\n            var ce, co, over,\n                o = this.options;\n            if ( o.containment === \"parent\" ) {\n                o.containment = this.helper[ 0 ].parentNode;\n            }\n            if ( o.containment === \"document\" || o.containment === \"window\" ) {\n                this.containment = [\n                    0 - this.offset.relative.left - this.offset.parent.left,\n                    0 - this.offset.relative.top - this.offset.parent.top,\n                    o.containment === \"document\" ?\n                        this.document.width() :\n                        this.window.width() - this.helperProportions.width - this.margins.left,\n                    ( o.containment === \"document\" ?\n                            ( this.document.height() || document.body.parentNode.scrollHeight ) :\n                            this.window.height() || this.document[ 0 ].body.parentNode.scrollHeight\n                    ) - this.helperProportions.height - this.margins.top\n                ];\n            }\n\n            if ( !( /^(document|window|parent)$/ ).test( o.containment ) ) {\n                ce = $( o.containment )[ 0 ];\n                co = $( o.containment ).offset();\n                over = ( $( ce ).css( \"overflow\" ) !== \"hidden\" );\n\n                this.containment = [\n                    co.left + ( parseInt( $( ce ).css( \"borderLeftWidth\" ), 10 ) || 0 ) +\n                    ( parseInt( $( ce ).css( \"paddingLeft\" ), 10 ) || 0 ) - this.margins.left,\n                    co.top + ( parseInt( $( ce ).css( \"borderTopWidth\" ), 10 ) || 0 ) +\n                    ( parseInt( $( ce ).css( \"paddingTop\" ), 10 ) || 0 ) - this.margins.top,\n                    co.left + ( over ? Math.max( ce.scrollWidth, ce.offsetWidth ) : ce.offsetWidth ) -\n                    ( parseInt( $( ce ).css( \"borderLeftWidth\" ), 10 ) || 0 ) -\n                    ( parseInt( $( ce ).css( \"paddingRight\" ), 10 ) || 0 ) -\n                    this.helperProportions.width - this.margins.left,\n                    co.top + ( over ? Math.max( ce.scrollHeight, ce.offsetHeight ) : ce.offsetHeight ) -\n                    ( parseInt( $( ce ).css( \"borderTopWidth\" ), 10 ) || 0 ) -\n                    ( parseInt( $( ce ).css( \"paddingBottom\" ), 10 ) || 0 ) -\n                    this.helperProportions.height - this.margins.top\n                ];\n            }\n\n        },\n\n        _convertPositionTo: function( d, pos ) {\n\n            if ( !pos ) {\n                pos = this.position;\n            }\n            var mod = d === \"absolute\" ? 1 : -1,\n                scroll = this.cssPosition === \"absolute\" &&\n                !( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                    $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) ?\n                    this.offsetParent :\n                    this.scrollParent,\n                scrollIsRootNode = ( /(html|body)/i ).test( scroll[ 0 ].tagName );\n\n            return {\n                top: (\n\n                    // The absolute mouse position\n                    pos.top\t+\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.top * mod +\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.top * mod -\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.scrollParent.scrollTop() :\n                        ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) * mod )\n                ),\n                left: (\n\n                    // The absolute mouse position\n                    pos.left +\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.left * mod +\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.left * mod\t-\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.scrollParent.scrollLeft() : scrollIsRootNode ? 0 :\n                            scroll.scrollLeft() ) * mod )\n                )\n            };\n\n        },\n\n        _generatePosition: function( event ) {\n\n            var top, left,\n                o = this.options,\n                pageX = event.pageX,\n                pageY = event.pageY,\n                scroll = this.cssPosition === \"absolute\" &&\n                !( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                    $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) ?\n                    this.offsetParent :\n                    this.scrollParent,\n                scrollIsRootNode = ( /(html|body)/i ).test( scroll[ 0 ].tagName );\n\n            // This is another very weird special case that only happens for relative elements:\n            // 1. If the css position is relative\n            // 2. and the scroll parent is the document or similar to the offset parent\n            // we have to refresh the relative offset during the scroll so there are no jumps\n            if ( this.cssPosition === \"relative\" && !( this.scrollParent[ 0 ] !== this.document[ 0 ] &&\n                this.scrollParent[ 0 ] !== this.offsetParent[ 0 ] ) ) {\n                this.offset.relative = this._getRelativeOffset();\n            }\n\n            /*\n             * - Position constraining -\n             * Constrain the position to a mix of grid, containment.\n             */\n\n            if ( this.originalPosition ) { //If we are not dragging yet, we won't check for options\n\n                if ( this.containment ) {\n                    if ( event.pageX - this.offset.click.left < this.containment[ 0 ] ) {\n                        pageX = this.containment[ 0 ] + this.offset.click.left;\n                    }\n                    if ( event.pageY - this.offset.click.top < this.containment[ 1 ] ) {\n                        pageY = this.containment[ 1 ] + this.offset.click.top;\n                    }\n                    if ( event.pageX - this.offset.click.left > this.containment[ 2 ] ) {\n                        pageX = this.containment[ 2 ] + this.offset.click.left;\n                    }\n                    if ( event.pageY - this.offset.click.top > this.containment[ 3 ] ) {\n                        pageY = this.containment[ 3 ] + this.offset.click.top;\n                    }\n                }\n\n                if ( o.grid ) {\n                    top = this.originalPageY + Math.round( ( pageY - this.originalPageY ) /\n                        o.grid[ 1 ] ) * o.grid[ 1 ];\n                    pageY = this.containment ?\n                        ( ( top - this.offset.click.top >= this.containment[ 1 ] &&\n                            top - this.offset.click.top <= this.containment[ 3 ] ) ?\n                            top :\n                            ( ( top - this.offset.click.top >= this.containment[ 1 ] ) ?\n                                top - o.grid[ 1 ] : top + o.grid[ 1 ] ) ) :\n                        top;\n\n                    left = this.originalPageX + Math.round( ( pageX - this.originalPageX ) /\n                        o.grid[ 0 ] ) * o.grid[ 0 ];\n                    pageX = this.containment ?\n                        ( ( left - this.offset.click.left >= this.containment[ 0 ] &&\n                            left - this.offset.click.left <= this.containment[ 2 ] ) ?\n                            left :\n                            ( ( left - this.offset.click.left >= this.containment[ 0 ] ) ?\n                                left - o.grid[ 0 ] : left + o.grid[ 0 ] ) ) :\n                        left;\n                }\n\n            }\n\n            return {\n                top: (\n\n                    // The absolute mouse position\n                    pageY -\n\n                    // Click offset (relative to the element)\n                    this.offset.click.top -\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.top -\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.top +\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.scrollParent.scrollTop() :\n                        ( scrollIsRootNode ? 0 : scroll.scrollTop() ) ) )\n                ),\n                left: (\n\n                    // The absolute mouse position\n                    pageX -\n\n                    // Click offset (relative to the element)\n                    this.offset.click.left -\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.left -\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.left +\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.scrollParent.scrollLeft() :\n                        scrollIsRootNode ? 0 : scroll.scrollLeft() ) )\n                )\n            };\n\n        },\n\n        _rearrange: function( event, i, a, hardRefresh ) {\n\n            if ( a ) {\n                a[ 0 ].appendChild( this.placeholder[ 0 ] );\n            } else {\n                i.item[ 0 ].parentNode.insertBefore( this.placeholder[ 0 ],\n                    ( this.direction === \"down\" ? i.item[ 0 ] : i.item[ 0 ].nextSibling ) );\n            }\n\n            //Various things done here to improve the performance:\n            // 1. we create a setTimeout, that calls refreshPositions\n            // 2. on the instance, we have a counter variable, that get's higher after every append\n            // 3. on the local scope, we copy the counter variable, and check in the timeout,\n            // if it's still the same\n            // 4. this lets only the last addition to the timeout stack through\n            this.counter = this.counter ? ++this.counter : 1;\n            var counter = this.counter;\n\n            this._delay( function() {\n                if ( counter === this.counter ) {\n\n                    //Precompute after each DOM insertion, NOT on mousemove\n                    this.refreshPositions( !hardRefresh );\n                }\n            } );\n\n        },\n\n        _clear: function( event, noPropagation ) {\n\n            this.reverting = false;\n\n            // We delay all events that have to be triggered to after the point where the placeholder\n            // has been removed and everything else normalized again\n            var i,\n                delayedTriggers = [];\n\n            // We first have to update the dom position of the actual currentItem\n            // Note: don't do it if the current item is already removed (by a user), or it gets\n            // reappended (see #4088)\n            if ( !this._noFinalSort && this.currentItem.parent().length ) {\n                this.placeholder.before( this.currentItem );\n            }\n            this._noFinalSort = null;\n\n            if ( this.helper[ 0 ] === this.currentItem[ 0 ] ) {\n                for ( i in this._storedCSS ) {\n                    if ( this._storedCSS[ i ] === \"auto\" || this._storedCSS[ i ] === \"static\" ) {\n                        this._storedCSS[ i ] = \"\";\n                    }\n                }\n                this.currentItem.css( this._storedCSS );\n                this._removeClass( this.currentItem, \"ui-sortable-helper\" );\n            } else {\n                this.currentItem.show();\n            }\n\n            if ( this.fromOutside && !noPropagation ) {\n                delayedTriggers.push( function( event ) {\n                    this._trigger( \"receive\", event, this._uiHash( this.fromOutside ) );\n                } );\n            }\n            if ( ( this.fromOutside ||\n                this.domPosition.prev !==\n                this.currentItem.prev().not( \".ui-sortable-helper\" )[ 0 ] ||\n                this.domPosition.parent !== this.currentItem.parent()[ 0 ] ) && !noPropagation ) {\n\n                // Trigger update callback if the DOM position has changed\n                delayedTriggers.push( function( event ) {\n                    this._trigger( \"update\", event, this._uiHash() );\n                } );\n            }\n\n            // Check if the items Container has Changed and trigger appropriate\n            // events.\n            if ( this !== this.currentContainer ) {\n                if ( !noPropagation ) {\n                    delayedTriggers.push( function( event ) {\n                        this._trigger( \"remove\", event, this._uiHash() );\n                    } );\n                    delayedTriggers.push( ( function( c ) {\n                        return function( event ) {\n                            c._trigger( \"receive\", event, this._uiHash( this ) );\n                        };\n                    } ).call( this, this.currentContainer ) );\n                    delayedTriggers.push( ( function( c ) {\n                        return function( event ) {\n                            c._trigger( \"update\", event, this._uiHash( this ) );\n                        };\n                    } ).call( this, this.currentContainer ) );\n                }\n            }\n\n            //Post events to containers\n            function delayEvent( type, instance, container ) {\n                return function( event ) {\n                    container._trigger( type, event, instance._uiHash( instance ) );\n                };\n            }\n            for ( i = this.containers.length - 1; i >= 0; i-- ) {\n                if ( !noPropagation ) {\n                    delayedTriggers.push( delayEvent( \"deactivate\", this, this.containers[ i ] ) );\n                }\n                if ( this.containers[ i ].containerCache.over ) {\n                    delayedTriggers.push( delayEvent( \"out\", this, this.containers[ i ] ) );\n                    this.containers[ i ].containerCache.over = 0;\n                }\n            }\n\n            //Do what was originally in plugins\n            if ( this.storedCursor ) {\n                this.document.find( \"body\" ).css( \"cursor\", this.storedCursor );\n                this.storedStylesheet.remove();\n            }\n            if ( this._storedOpacity ) {\n                this.helper.css( \"opacity\", this._storedOpacity );\n            }\n            if ( this._storedZIndex ) {\n                this.helper.css( \"zIndex\", this._storedZIndex === \"auto\" ? \"\" : this._storedZIndex );\n            }\n\n            this.dragging = false;\n\n            if ( !noPropagation ) {\n                this._trigger( \"beforeStop\", event, this._uiHash() );\n            }\n\n            //$(this.placeholder[0]).remove(); would have been the jQuery way - unfortunately,\n            // it unbinds ALL events from the original node!\n            this.placeholder[ 0 ].parentNode.removeChild( this.placeholder[ 0 ] );\n\n            if ( !this.cancelHelperRemoval ) {\n                if ( this.helper[ 0 ] !== this.currentItem[ 0 ] ) {\n                    this.helper.remove();\n                }\n                this.helper = null;\n            }\n\n            if ( !noPropagation ) {\n                for ( i = 0; i < delayedTriggers.length; i++ ) {\n\n                    // Trigger all delayed events\n                    delayedTriggers[ i ].call( this, event );\n                }\n                this._trigger( \"stop\", event, this._uiHash() );\n            }\n\n            this.fromOutside = false;\n            return !this.cancelHelperRemoval;\n\n        },\n\n        _trigger: function() {\n            if ( $.Widget.prototype._trigger.apply( this, arguments ) === false ) {\n                this.cancel();\n            }\n        },\n\n        _uiHash: function( _inst ) {\n            var inst = _inst || this;\n            return {\n                helper: inst.helper,\n                placeholder: inst.placeholder || $( [] ),\n                position: inst.position,\n                originalPosition: inst.originalPosition,\n                offset: inst.positionAbs,\n                item: inst.currentItem,\n                sender: _inst ? _inst.element : null\n            };\n        }\n\n    } );\n\n} );\n","jquery/ui-modules/widgets/controlgroup.js":"/*!\n * jQuery UI Controlgroup 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Controlgroup\n//>>group: Widgets\n//>>description: Visually groups form control widgets\n//>>docs: http://api.jqueryui.com/controlgroup/\n//>>demos: http://jqueryui.com/controlgroup/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/controlgroup.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var controlgroupCornerRegex = /ui-corner-([a-z]){2,6}/g;\n\n    return $.widget( \"ui.controlgroup\", {\n        version: \"1.13.2\",\n        defaultElement: \"<div>\",\n        options: {\n            direction: \"horizontal\",\n            disabled: null,\n            onlyVisible: true,\n            items: {\n                \"button\": \"input[type=button], input[type=submit], input[type=reset], button, a\",\n                \"controlgroupLabel\": \".ui-controlgroup-label\",\n                \"checkboxradio\": \"input[type='checkbox'], input[type='radio']\",\n                \"selectmenu\": \"select\",\n                \"spinner\": \".ui-spinner-input\"\n            }\n        },\n\n        _create: function() {\n            this._enhance();\n        },\n\n        // To support the enhanced option in jQuery Mobile, we isolate DOM manipulation\n        _enhance: function() {\n            this.element.attr( \"role\", \"toolbar\" );\n            this.refresh();\n        },\n\n        _destroy: function() {\n            this._callChildMethod( \"destroy\" );\n            this.childWidgets.removeData( \"ui-controlgroup-data\" );\n            this.element.removeAttr( \"role\" );\n            if ( this.options.items.controlgroupLabel ) {\n                this.element\n                    .find( this.options.items.controlgroupLabel )\n                    .find( \".ui-controlgroup-label-contents\" )\n                    .contents().unwrap();\n            }\n        },\n\n        _initWidgets: function() {\n            var that = this,\n                childWidgets = [];\n\n            // First we iterate over each of the items options\n            $.each( this.options.items, function( widget, selector ) {\n                var labels;\n                var options = {};\n\n                // Make sure the widget has a selector set\n                if ( !selector ) {\n                    return;\n                }\n\n                if ( widget === \"controlgroupLabel\" ) {\n                    labels = that.element.find( selector );\n                    labels.each( function() {\n                        var element = $( this );\n\n                        if ( element.children( \".ui-controlgroup-label-contents\" ).length ) {\n                            return;\n                        }\n                        element.contents()\n                            .wrapAll( \"<span class='ui-controlgroup-label-contents'></span>\" );\n                    } );\n                    that._addClass( labels, null, \"ui-widget ui-widget-content ui-state-default\" );\n                    childWidgets = childWidgets.concat( labels.get() );\n                    return;\n                }\n\n                // Make sure the widget actually exists\n                if ( !$.fn[ widget ] ) {\n                    return;\n                }\n\n                // We assume everything is in the middle to start because we can't determine\n                // first / last elements until all enhancments are done.\n                if ( that[ \"_\" + widget + \"Options\" ] ) {\n                    options = that[ \"_\" + widget + \"Options\" ]( \"middle\" );\n                } else {\n                    options = { classes: {} };\n                }\n\n                // Find instances of this widget inside controlgroup and init them\n                that.element\n                    .find( selector )\n                    .each( function() {\n                        var element = $( this );\n                        var instance = element[ widget ]( \"instance\" );\n\n                        // We need to clone the default options for this type of widget to avoid\n                        // polluting the variable options which has a wider scope than a single widget.\n                        var instanceOptions = $.widget.extend( {}, options );\n\n                        // If the button is the child of a spinner ignore it\n                        // TODO: Find a more generic solution\n                        if ( widget === \"button\" && element.parent( \".ui-spinner\" ).length ) {\n                            return;\n                        }\n\n                        // Create the widget if it doesn't exist\n                        if ( !instance ) {\n                            instance = element[ widget ]()[ widget ]( \"instance\" );\n                        }\n                        if ( instance ) {\n                            instanceOptions.classes =\n                                that._resolveClassesValues( instanceOptions.classes, instance );\n                        }\n                        element[ widget ]( instanceOptions );\n\n                        // Store an instance of the controlgroup to be able to reference\n                        // from the outermost element for changing options and refresh\n                        var widgetElement = element[ widget ]( \"widget\" );\n                        $.data( widgetElement[ 0 ], \"ui-controlgroup-data\",\n                            instance ? instance : element[ widget ]( \"instance\" ) );\n\n                        childWidgets.push( widgetElement[ 0 ] );\n                    } );\n            } );\n\n            this.childWidgets = $( $.uniqueSort( childWidgets ) );\n            this._addClass( this.childWidgets, \"ui-controlgroup-item\" );\n        },\n\n        _callChildMethod: function( method ) {\n            this.childWidgets.each( function() {\n                var element = $( this ),\n                    data = element.data( \"ui-controlgroup-data\" );\n                if ( data && data[ method ] ) {\n                    data[ method ]();\n                }\n            } );\n        },\n\n        _updateCornerClass: function( element, position ) {\n            var remove = \"ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all\";\n            var add = this._buildSimpleOptions( position, \"label\" ).classes.label;\n\n            this._removeClass( element, null, remove );\n            this._addClass( element, null, add );\n        },\n\n        _buildSimpleOptions: function( position, key ) {\n            var direction = this.options.direction === \"vertical\";\n            var result = {\n                classes: {}\n            };\n            result.classes[ key ] = {\n                \"middle\": \"\",\n                \"first\": \"ui-corner-\" + ( direction ? \"top\" : \"left\" ),\n                \"last\": \"ui-corner-\" + ( direction ? \"bottom\" : \"right\" ),\n                \"only\": \"ui-corner-all\"\n            }[ position ];\n\n            return result;\n        },\n\n        _spinnerOptions: function( position ) {\n            var options = this._buildSimpleOptions( position, \"ui-spinner\" );\n\n            options.classes[ \"ui-spinner-up\" ] = \"\";\n            options.classes[ \"ui-spinner-down\" ] = \"\";\n\n            return options;\n        },\n\n        _buttonOptions: function( position ) {\n            return this._buildSimpleOptions( position, \"ui-button\" );\n        },\n\n        _checkboxradioOptions: function( position ) {\n            return this._buildSimpleOptions( position, \"ui-checkboxradio-label\" );\n        },\n\n        _selectmenuOptions: function( position ) {\n            var direction = this.options.direction === \"vertical\";\n            return {\n                width: direction ? \"auto\" : false,\n                classes: {\n                    middle: {\n                        \"ui-selectmenu-button-open\": \"\",\n                        \"ui-selectmenu-button-closed\": \"\"\n                    },\n                    first: {\n                        \"ui-selectmenu-button-open\": \"ui-corner-\" + ( direction ? \"top\" : \"tl\" ),\n                        \"ui-selectmenu-button-closed\": \"ui-corner-\" + ( direction ? \"top\" : \"left\" )\n                    },\n                    last: {\n                        \"ui-selectmenu-button-open\": direction ? \"\" : \"ui-corner-tr\",\n                        \"ui-selectmenu-button-closed\": \"ui-corner-\" + ( direction ? \"bottom\" : \"right\" )\n                    },\n                    only: {\n                        \"ui-selectmenu-button-open\": \"ui-corner-top\",\n                        \"ui-selectmenu-button-closed\": \"ui-corner-all\"\n                    }\n\n                }[ position ]\n            };\n        },\n\n        _resolveClassesValues: function( classes, instance ) {\n            var result = {};\n            $.each( classes, function( key ) {\n                var current = instance.options.classes[ key ] || \"\";\n                current = String.prototype.trim.call( current.replace( controlgroupCornerRegex, \"\" ) );\n                result[ key ] = ( current + \" \" + classes[ key ] ).replace( /\\s+/g, \" \" );\n            } );\n            return result;\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"direction\" ) {\n                this._removeClass( \"ui-controlgroup-\" + this.options.direction );\n            }\n\n            this._super( key, value );\n            if ( key === \"disabled\" ) {\n                this._callChildMethod( value ? \"disable\" : \"enable\" );\n                return;\n            }\n\n            this.refresh();\n        },\n\n        refresh: function() {\n            var children,\n                that = this;\n\n            this._addClass( \"ui-controlgroup ui-controlgroup-\" + this.options.direction );\n\n            if ( this.options.direction === \"horizontal\" ) {\n                this._addClass( null, \"ui-helper-clearfix\" );\n            }\n            this._initWidgets();\n\n            children = this.childWidgets;\n\n            // We filter here because we need to track all childWidgets not just the visible ones\n            if ( this.options.onlyVisible ) {\n                children = children.filter( \":visible\" );\n            }\n\n            if ( children.length ) {\n\n                // We do this last because we need to make sure all enhancment is done\n                // before determining first and last\n                $.each( [ \"first\", \"last\" ], function( index, value ) {\n                    var instance = children[ value ]().data( \"ui-controlgroup-data\" );\n\n                    if ( instance && that[ \"_\" + instance.widgetName + \"Options\" ] ) {\n                        var options = that[ \"_\" + instance.widgetName + \"Options\" ](\n                            children.length === 1 ? \"only\" : value\n                        );\n                        options.classes = that._resolveClassesValues( options.classes, instance );\n                        instance.element[ instance.widgetName ]( options );\n                    } else {\n                        that._updateCornerClass( children[ value ](), value );\n                    }\n                } );\n\n                // Finally call the refresh method on each of the child widgets.\n                this._callChildMethod( \"refresh\" );\n            }\n        }\n    } );\n} );\n","jquery/ui-modules/widgets/droppable.js":"/*!\n * jQuery UI Droppable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Droppable\n//>>group: Interactions\n//>>description: Enables drop targets for draggable elements.\n//>>docs: http://api.jqueryui.com/droppable/\n//>>demos: http://jqueryui.com/droppable/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./draggable\",\n            \"./mouse\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.droppable\", {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"drop\",\n        options: {\n            accept: \"*\",\n            addClasses: true,\n            greedy: false,\n            scope: \"default\",\n            tolerance: \"intersect\",\n\n            // Callbacks\n            activate: null,\n            deactivate: null,\n            drop: null,\n            out: null,\n            over: null\n        },\n        _create: function() {\n\n            var proportions,\n                o = this.options,\n                accept = o.accept;\n\n            this.isover = false;\n            this.isout = true;\n\n            this.accept = typeof accept === \"function\" ? accept : function( d ) {\n                return d.is( accept );\n            };\n\n            this.proportions = function( /* valueToWrite */ ) {\n                if ( arguments.length ) {\n\n                    // Store the droppable's proportions\n                    proportions = arguments[ 0 ];\n                } else {\n\n                    // Retrieve or derive the droppable's proportions\n                    return proportions ?\n                        proportions :\n                        proportions = {\n                            width: this.element[ 0 ].offsetWidth,\n                            height: this.element[ 0 ].offsetHeight\n                        };\n                }\n            };\n\n            this._addToManager( o.scope );\n\n            if ( o.addClasses ) {\n                this._addClass( \"ui-droppable\" );\n            }\n\n        },\n\n        _addToManager: function( scope ) {\n\n            // Add the reference and positions to the manager\n            $.ui.ddmanager.droppables[ scope ] = $.ui.ddmanager.droppables[ scope ] || [];\n            $.ui.ddmanager.droppables[ scope ].push( this );\n        },\n\n        _splice: function( drop ) {\n            var i = 0;\n            for ( ; i < drop.length; i++ ) {\n                if ( drop[ i ] === this ) {\n                    drop.splice( i, 1 );\n                }\n            }\n        },\n\n        _destroy: function() {\n            var drop = $.ui.ddmanager.droppables[ this.options.scope ];\n\n            this._splice( drop );\n        },\n\n        _setOption: function( key, value ) {\n\n            if ( key === \"accept\" ) {\n                this.accept = typeof value === \"function\" ? value : function( d ) {\n                    return d.is( value );\n                };\n            } else if ( key === \"scope\" ) {\n                var drop = $.ui.ddmanager.droppables[ this.options.scope ];\n\n                this._splice( drop );\n                this._addToManager( value );\n            }\n\n            this._super( key, value );\n        },\n\n        _activate: function( event ) {\n            var draggable = $.ui.ddmanager.current;\n\n            this._addActiveClass();\n            if ( draggable ) {\n                this._trigger( \"activate\", event, this.ui( draggable ) );\n            }\n        },\n\n        _deactivate: function( event ) {\n            var draggable = $.ui.ddmanager.current;\n\n            this._removeActiveClass();\n            if ( draggable ) {\n                this._trigger( \"deactivate\", event, this.ui( draggable ) );\n            }\n        },\n\n        _over: function( event ) {\n\n            var draggable = $.ui.ddmanager.current;\n\n            // Bail if draggable and droppable are same element\n            if ( !draggable || ( draggable.currentItem ||\n                draggable.element )[ 0 ] === this.element[ 0 ] ) {\n                return;\n            }\n\n            if ( this.accept.call( this.element[ 0 ], ( draggable.currentItem ||\n                draggable.element ) ) ) {\n                this._addHoverClass();\n                this._trigger( \"over\", event, this.ui( draggable ) );\n            }\n\n        },\n\n        _out: function( event ) {\n\n            var draggable = $.ui.ddmanager.current;\n\n            // Bail if draggable and droppable are same element\n            if ( !draggable || ( draggable.currentItem ||\n                draggable.element )[ 0 ] === this.element[ 0 ] ) {\n                return;\n            }\n\n            if ( this.accept.call( this.element[ 0 ], ( draggable.currentItem ||\n                draggable.element ) ) ) {\n                this._removeHoverClass();\n                this._trigger( \"out\", event, this.ui( draggable ) );\n            }\n\n        },\n\n        _drop: function( event, custom ) {\n\n            var draggable = custom || $.ui.ddmanager.current,\n                childrenIntersection = false;\n\n            // Bail if draggable and droppable are same element\n            if ( !draggable || ( draggable.currentItem ||\n                draggable.element )[ 0 ] === this.element[ 0 ] ) {\n                return false;\n            }\n\n            this.element\n                .find( \":data(ui-droppable)\" )\n                .not( \".ui-draggable-dragging\" )\n                .each( function() {\n                    var inst = $( this ).droppable( \"instance\" );\n                    if (\n                        inst.options.greedy &&\n                        !inst.options.disabled &&\n                        inst.options.scope === draggable.options.scope &&\n                        inst.accept.call(\n                            inst.element[ 0 ], ( draggable.currentItem || draggable.element )\n                        ) &&\n                        $.ui.intersect(\n                            draggable,\n                            $.extend( inst, { offset: inst.element.offset() } ),\n                            inst.options.tolerance, event\n                        )\n                    ) {\n                        childrenIntersection = true;\n                        return false;\n                    }\n                } );\n            if ( childrenIntersection ) {\n                return false;\n            }\n\n            if ( this.accept.call( this.element[ 0 ],\n                ( draggable.currentItem || draggable.element ) ) ) {\n                this._removeActiveClass();\n                this._removeHoverClass();\n\n                this._trigger( \"drop\", event, this.ui( draggable ) );\n                return this.element;\n            }\n\n            return false;\n\n        },\n\n        ui: function( c ) {\n            return {\n                draggable: ( c.currentItem || c.element ),\n                helper: c.helper,\n                position: c.position,\n                offset: c.positionAbs\n            };\n        },\n\n        // Extension points just to make backcompat sane and avoid duplicating logic\n        // TODO: Remove in 1.14 along with call to it below\n        _addHoverClass: function() {\n            this._addClass( \"ui-droppable-hover\" );\n        },\n\n        _removeHoverClass: function() {\n            this._removeClass( \"ui-droppable-hover\" );\n        },\n\n        _addActiveClass: function() {\n            this._addClass( \"ui-droppable-active\" );\n        },\n\n        _removeActiveClass: function() {\n            this._removeClass( \"ui-droppable-active\" );\n        }\n    } );\n\n    $.ui.intersect = ( function() {\n        function isOverAxis( x, reference, size ) {\n            return ( x >= reference ) && ( x < ( reference + size ) );\n        }\n\n        return function( draggable, droppable, toleranceMode, event ) {\n\n            if ( !droppable.offset ) {\n                return false;\n            }\n\n            var x1 = ( draggable.positionAbs ||\n                    draggable.position.absolute ).left + draggable.margins.left,\n                y1 = ( draggable.positionAbs ||\n                    draggable.position.absolute ).top + draggable.margins.top,\n                x2 = x1 + draggable.helperProportions.width,\n                y2 = y1 + draggable.helperProportions.height,\n                l = droppable.offset.left,\n                t = droppable.offset.top,\n                r = l + droppable.proportions().width,\n                b = t + droppable.proportions().height;\n\n            switch ( toleranceMode ) {\n                case \"fit\":\n                    return ( l <= x1 && x2 <= r && t <= y1 && y2 <= b );\n                case \"intersect\":\n                    return ( l < x1 + ( draggable.helperProportions.width / 2 ) && // Right Half\n                        x2 - ( draggable.helperProportions.width / 2 ) < r && // Left Half\n                        t < y1 + ( draggable.helperProportions.height / 2 ) && // Bottom Half\n                        y2 - ( draggable.helperProportions.height / 2 ) < b ); // Top Half\n                case \"pointer\":\n                    return isOverAxis( event.pageY, t, droppable.proportions().height ) &&\n                        isOverAxis( event.pageX, l, droppable.proportions().width );\n                case \"touch\":\n                    return (\n                        ( y1 >= t && y1 <= b ) || // Top edge touching\n                        ( y2 >= t && y2 <= b ) || // Bottom edge touching\n                        ( y1 < t && y2 > b ) // Surrounded vertically\n                    ) && (\n                        ( x1 >= l && x1 <= r ) || // Left edge touching\n                        ( x2 >= l && x2 <= r ) || // Right edge touching\n                        ( x1 < l && x2 > r ) // Surrounded horizontally\n                    );\n                default:\n                    return false;\n            }\n        };\n    } )();\n\n    /*\n        This manager tracks offsets of draggables and droppables\n    */\n    $.ui.ddmanager = {\n        current: null,\n        droppables: { \"default\": [] },\n        prepareOffsets: function( t, event ) {\n\n            var i, j,\n                m = $.ui.ddmanager.droppables[ t.options.scope ] || [],\n                type = event ? event.type : null, // workaround for #2317\n                list = ( t.currentItem || t.element ).find( \":data(ui-droppable)\" ).addBack();\n\n            droppablesLoop: for ( i = 0; i < m.length; i++ ) {\n\n                // No disabled and non-accepted\n                if ( m[ i ].options.disabled || ( t && !m[ i ].accept.call( m[ i ].element[ 0 ],\n                    ( t.currentItem || t.element ) ) ) ) {\n                    continue;\n                }\n\n                // Filter out elements in the current dragged item\n                for ( j = 0; j < list.length; j++ ) {\n                    if ( list[ j ] === m[ i ].element[ 0 ] ) {\n                        m[ i ].proportions().height = 0;\n                        continue droppablesLoop;\n                    }\n                }\n\n                m[ i ].visible = m[ i ].element.css( \"display\" ) !== \"none\";\n                if ( !m[ i ].visible ) {\n                    continue;\n                }\n\n                // Activate the droppable if used directly from draggables\n                if ( type === \"mousedown\" ) {\n                    m[ i ]._activate.call( m[ i ], event );\n                }\n\n                m[ i ].offset = m[ i ].element.offset();\n                m[ i ].proportions( {\n                    width: m[ i ].element[ 0 ].offsetWidth,\n                    height: m[ i ].element[ 0 ].offsetHeight\n                } );\n\n            }\n\n        },\n        drop: function( draggable, event ) {\n\n            var dropped = false;\n\n            // Create a copy of the droppables in case the list changes during the drop (#9116)\n            $.each( ( $.ui.ddmanager.droppables[ draggable.options.scope ] || [] ).slice(), function() {\n\n                if ( !this.options ) {\n                    return;\n                }\n                if ( !this.options.disabled && this.visible &&\n                    $.ui.intersect( draggable, this, this.options.tolerance, event ) ) {\n                    dropped = this._drop.call( this, event ) || dropped;\n                }\n\n                if ( !this.options.disabled && this.visible && this.accept.call( this.element[ 0 ],\n                    ( draggable.currentItem || draggable.element ) ) ) {\n                    this.isout = true;\n                    this.isover = false;\n                    this._deactivate.call( this, event );\n                }\n\n            } );\n            return dropped;\n\n        },\n        dragStart: function( draggable, event ) {\n\n            // Listen for scrolling so that if the dragging causes scrolling the position of the\n            // droppables can be recalculated (see #5003)\n            draggable.element.parentsUntil( \"body\" ).on( \"scroll.droppable\", function() {\n                if ( !draggable.options.refreshPositions ) {\n                    $.ui.ddmanager.prepareOffsets( draggable, event );\n                }\n            } );\n        },\n        drag: function( draggable, event ) {\n\n            // If you have a highly dynamic page, you might try this option. It renders positions\n            // every time you move the mouse.\n            if ( draggable.options.refreshPositions ) {\n                $.ui.ddmanager.prepareOffsets( draggable, event );\n            }\n\n            // Run through all droppables and check their positions based on specific tolerance options\n            $.each( $.ui.ddmanager.droppables[ draggable.options.scope ] || [], function() {\n\n                if ( this.options.disabled || this.greedyChild || !this.visible ) {\n                    return;\n                }\n\n                var parentInstance, scope, parent,\n                    intersects = $.ui.intersect( draggable, this, this.options.tolerance, event ),\n                    c = !intersects && this.isover ?\n                        \"isout\" :\n                        ( intersects && !this.isover ? \"isover\" : null );\n                if ( !c ) {\n                    return;\n                }\n\n                if ( this.options.greedy ) {\n\n                    // find droppable parents with same scope\n                    scope = this.options.scope;\n                    parent = this.element.parents( \":data(ui-droppable)\" ).filter( function() {\n                        return $( this ).droppable( \"instance\" ).options.scope === scope;\n                    } );\n\n                    if ( parent.length ) {\n                        parentInstance = $( parent[ 0 ] ).droppable( \"instance\" );\n                        parentInstance.greedyChild = ( c === \"isover\" );\n                    }\n                }\n\n                // We just moved into a greedy child\n                if ( parentInstance && c === \"isover\" ) {\n                    parentInstance.isover = false;\n                    parentInstance.isout = true;\n                    parentInstance._out.call( parentInstance, event );\n                }\n\n                this[ c ] = true;\n                this[ c === \"isout\" ? \"isover\" : \"isout\" ] = false;\n                this[ c === \"isover\" ? \"_over\" : \"_out\" ].call( this, event );\n\n                // We just moved out of a greedy child\n                if ( parentInstance && c === \"isout\" ) {\n                    parentInstance.isout = false;\n                    parentInstance.isover = true;\n                    parentInstance._over.call( parentInstance, event );\n                }\n            } );\n\n        },\n        dragStop: function( draggable, event ) {\n            draggable.element.parentsUntil( \"body\" ).off( \"scroll.droppable\" );\n\n            // Call prepareOffsets one final time since IE does not fire return scroll events when\n            // overflow was caused by drag (see #5003)\n            if ( !draggable.options.refreshPositions ) {\n                $.ui.ddmanager.prepareOffsets( draggable, event );\n            }\n        }\n    };\n\n// DEPRECATED\n// TODO: switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for activeClass and hoverClass options\n        $.widget( \"ui.droppable\", $.ui.droppable, {\n            options: {\n                hoverClass: false,\n                activeClass: false\n            },\n            _addActiveClass: function() {\n                this._super();\n                if ( this.options.activeClass ) {\n                    this.element.addClass( this.options.activeClass );\n                }\n            },\n            _removeActiveClass: function() {\n                this._super();\n                if ( this.options.activeClass ) {\n                    this.element.removeClass( this.options.activeClass );\n                }\n            },\n            _addHoverClass: function() {\n                this._super();\n                if ( this.options.hoverClass ) {\n                    this.element.addClass( this.options.hoverClass );\n                }\n            },\n            _removeHoverClass: function() {\n                this._super();\n                if ( this.options.hoverClass ) {\n                    this.element.removeClass( this.options.hoverClass );\n                }\n            }\n        } );\n    }\n\n    return $.ui.droppable;\n\n} );\n","jquery/ui-modules/widgets/draggable.js":"/*!\n * jQuery UI Draggable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Draggable\n//>>group: Interactions\n//>>description: Enables dragging functionality for any element.\n//>>docs: http://api.jqueryui.com/draggable/\n//>>demos: http://jqueryui.com/draggable/\n//>>css.structure: ../../themes/base/draggable.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../data\",\n            \"../plugin\",\n            \"../safe-active-element\",\n            \"../safe-blur\",\n            \"../scroll-parent\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.draggable\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"drag\",\n        options: {\n            addClasses: true,\n            appendTo: \"parent\",\n            axis: false,\n            connectToSortable: false,\n            containment: false,\n            cursor: \"auto\",\n            cursorAt: false,\n            grid: false,\n            handle: false,\n            helper: \"original\",\n            iframeFix: false,\n            opacity: false,\n            refreshPositions: false,\n            revert: false,\n            revertDuration: 500,\n            scope: \"default\",\n            scroll: true,\n            scrollSensitivity: 20,\n            scrollSpeed: 20,\n            snap: false,\n            snapMode: \"both\",\n            snapTolerance: 20,\n            stack: false,\n            zIndex: false,\n\n            // Callbacks\n            drag: null,\n            start: null,\n            stop: null\n        },\n        _create: function() {\n\n            if ( this.options.helper === \"original\" ) {\n                this._setPositionRelative();\n            }\n            if ( this.options.addClasses ) {\n                this._addClass( \"ui-draggable\" );\n            }\n            this._setHandleClassName();\n\n            this._mouseInit();\n        },\n\n        _setOption: function( key, value ) {\n            this._super( key, value );\n            if ( key === \"handle\" ) {\n                this._removeHandleClassName();\n                this._setHandleClassName();\n            }\n        },\n\n        _destroy: function() {\n            if ( ( this.helper || this.element ).is( \".ui-draggable-dragging\" ) ) {\n                this.destroyOnClear = true;\n                return;\n            }\n            this._removeHandleClassName();\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function( event ) {\n            var o = this.options;\n\n            // Among others, prevent a drag on a resizable-handle\n            if ( this.helper || o.disabled ||\n                $( event.target ).closest( \".ui-resizable-handle\" ).length > 0 ) {\n                return false;\n            }\n\n            //Quit if we're not on a valid handle\n            this.handle = this._getHandle( event );\n            if ( !this.handle ) {\n                return false;\n            }\n\n            this._blurActiveElement( event );\n\n            this._blockFrames( o.iframeFix === true ? \"iframe\" : o.iframeFix );\n\n            return true;\n\n        },\n\n        _blockFrames: function( selector ) {\n            this.iframeBlocks = this.document.find( selector ).map( function() {\n                var iframe = $( this );\n\n                return $( \"<div>\" )\n                    .css( \"position\", \"absolute\" )\n                    .appendTo( iframe.parent() )\n                    .outerWidth( iframe.outerWidth() )\n                    .outerHeight( iframe.outerHeight() )\n                    .offset( iframe.offset() )[ 0 ];\n            } );\n        },\n\n        _unblockFrames: function() {\n            if ( this.iframeBlocks ) {\n                this.iframeBlocks.remove();\n                delete this.iframeBlocks;\n            }\n        },\n\n        _blurActiveElement: function( event ) {\n            var activeElement = $.ui.safeActiveElement( this.document[ 0 ] ),\n                target = $( event.target );\n\n            // Don't blur if the event occurred on an element that is within\n            // the currently focused element\n            // See #10527, #12472\n            if ( target.closest( activeElement ).length ) {\n                return;\n            }\n\n            // Blur any element that currently has focus, see #4261\n            $.ui.safeBlur( activeElement );\n        },\n\n        _mouseStart: function( event ) {\n\n            var o = this.options;\n\n            //Create and append the visible helper\n            this.helper = this._createHelper( event );\n\n            this._addClass( this.helper, \"ui-draggable-dragging\" );\n\n            //Cache the helper size\n            this._cacheHelperProportions();\n\n            //If ddmanager is used for droppables, set the global draggable\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.current = this;\n            }\n\n            /*\n             * - Position generation -\n             * This block generates everything position related - it's the core of draggables.\n             */\n\n            //Cache the margins of the original element\n            this._cacheMargins();\n\n            //Store the helper's css position\n            this.cssPosition = this.helper.css( \"position\" );\n            this.scrollParent = this.helper.scrollParent( true );\n            this.offsetParent = this.helper.offsetParent();\n            this.hasFixedAncestor = this.helper.parents().filter( function() {\n                return $( this ).css( \"position\" ) === \"fixed\";\n            } ).length > 0;\n\n            //The element's absolute position on the page minus margins\n            this.positionAbs = this.element.offset();\n            this._refreshOffsets( event );\n\n            //Generate the original position\n            this.originalPosition = this.position = this._generatePosition( event, false );\n            this.originalPageX = event.pageX;\n            this.originalPageY = event.pageY;\n\n            //Adjust the mouse offset relative to the helper if \"cursorAt\" is supplied\n            if ( o.cursorAt ) {\n                this._adjustOffsetFromHelper( o.cursorAt );\n            }\n\n            //Set a containment if given in the options\n            this._setContainment();\n\n            //Trigger event + callbacks\n            if ( this._trigger( \"start\", event ) === false ) {\n                this._clear();\n                return false;\n            }\n\n            //Recache the helper size\n            this._cacheHelperProportions();\n\n            //Prepare the droppable offsets\n            if ( $.ui.ddmanager && !o.dropBehaviour ) {\n                $.ui.ddmanager.prepareOffsets( this, event );\n            }\n\n            // Execute the drag once - this causes the helper not to be visible before getting its\n            // correct position\n            this._mouseDrag( event, true );\n\n            // If the ddmanager is used for droppables, inform the manager that dragging has started\n            // (see #5003)\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.dragStart( this, event );\n            }\n\n            return true;\n        },\n\n        _refreshOffsets: function( event ) {\n            this.offset = {\n                top: this.positionAbs.top - this.margins.top,\n                left: this.positionAbs.left - this.margins.left,\n                scroll: false,\n                parent: this._getParentOffset(),\n                relative: this._getRelativeOffset()\n            };\n\n            this.offset.click = {\n                left: event.pageX - this.offset.left,\n                top: event.pageY - this.offset.top\n            };\n        },\n\n        _mouseDrag: function( event, noPropagation ) {\n\n            // reset any necessary cached properties (see #5009)\n            if ( this.hasFixedAncestor ) {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            //Compute the helpers position\n            this.position = this._generatePosition( event, true );\n            this.positionAbs = this._convertPositionTo( \"absolute\" );\n\n            //Call plugins and callbacks and use the resulting position if something is returned\n            if ( !noPropagation ) {\n                var ui = this._uiHash();\n                if ( this._trigger( \"drag\", event, ui ) === false ) {\n                    this._mouseUp( new $.Event( \"mouseup\", event ) );\n                    return false;\n                }\n                this.position = ui.position;\n            }\n\n            this.helper[ 0 ].style.left = this.position.left + \"px\";\n            this.helper[ 0 ].style.top = this.position.top + \"px\";\n\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.drag( this, event );\n            }\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n\n            //If we are using droppables, inform the manager about the drop\n            var that = this,\n                dropped = false;\n            if ( $.ui.ddmanager && !this.options.dropBehaviour ) {\n                dropped = $.ui.ddmanager.drop( this, event );\n            }\n\n            //if a drop comes from outside (a sortable)\n            if ( this.dropped ) {\n                dropped = this.dropped;\n                this.dropped = false;\n            }\n\n            if ( ( this.options.revert === \"invalid\" && !dropped ) ||\n                ( this.options.revert === \"valid\" && dropped ) ||\n                this.options.revert === true || ( typeof this.options.revert === \"function\" &&\n                    this.options.revert.call( this.element, dropped ) )\n            ) {\n                $( this.helper ).animate(\n                    this.originalPosition,\n                    parseInt( this.options.revertDuration, 10 ),\n                    function() {\n                        if ( that._trigger( \"stop\", event ) !== false ) {\n                            that._clear();\n                        }\n                    }\n                );\n            } else {\n                if ( this._trigger( \"stop\", event ) !== false ) {\n                    this._clear();\n                }\n            }\n\n            return false;\n        },\n\n        _mouseUp: function( event ) {\n            this._unblockFrames();\n\n            // If the ddmanager is used for droppables, inform the manager that dragging has stopped\n            // (see #5003)\n            if ( $.ui.ddmanager ) {\n                $.ui.ddmanager.dragStop( this, event );\n            }\n\n            // Only need to focus if the event occurred on the draggable itself, see #10527\n            if ( this.handleElement.is( event.target ) ) {\n\n                // The interaction is over; whether or not the click resulted in a drag,\n                // focus the element\n                this.element.trigger( \"focus\" );\n            }\n\n            return $.ui.mouse.prototype._mouseUp.call( this, event );\n        },\n\n        cancel: function() {\n\n            if ( this.helper.is( \".ui-draggable-dragging\" ) ) {\n                this._mouseUp( new $.Event( \"mouseup\", { target: this.element[ 0 ] } ) );\n            } else {\n                this._clear();\n            }\n\n            return this;\n\n        },\n\n        _getHandle: function( event ) {\n            return this.options.handle ?\n                !!$( event.target ).closest( this.element.find( this.options.handle ) ).length :\n                true;\n        },\n\n        _setHandleClassName: function() {\n            this.handleElement = this.options.handle ?\n                this.element.find( this.options.handle ) : this.element;\n            this._addClass( this.handleElement, \"ui-draggable-handle\" );\n        },\n\n        _removeHandleClassName: function() {\n            this._removeClass( this.handleElement, \"ui-draggable-handle\" );\n        },\n\n        _createHelper: function( event ) {\n\n            var o = this.options,\n                helperIsFunction = typeof o.helper === \"function\",\n                helper = helperIsFunction ?\n                    $( o.helper.apply( this.element[ 0 ], [ event ] ) ) :\n                    ( o.helper === \"clone\" ?\n                        this.element.clone().removeAttr( \"id\" ) :\n                        this.element );\n\n            if ( !helper.parents( \"body\" ).length ) {\n                helper.appendTo( ( o.appendTo === \"parent\" ?\n                    this.element[ 0 ].parentNode :\n                    o.appendTo ) );\n            }\n\n            // Http://bugs.jqueryui.com/ticket/9446\n            // a helper function can return the original element\n            // which wouldn't have been set to relative in _create\n            if ( helperIsFunction && helper[ 0 ] === this.element[ 0 ] ) {\n                this._setPositionRelative();\n            }\n\n            if ( helper[ 0 ] !== this.element[ 0 ] &&\n                !( /(fixed|absolute)/ ).test( helper.css( \"position\" ) ) ) {\n                helper.css( \"position\", \"absolute\" );\n            }\n\n            return helper;\n\n        },\n\n        _setPositionRelative: function() {\n            if ( !( /^(?:r|a|f)/ ).test( this.element.css( \"position\" ) ) ) {\n                this.element[ 0 ].style.position = \"relative\";\n            }\n        },\n\n        _adjustOffsetFromHelper: function( obj ) {\n            if ( typeof obj === \"string\" ) {\n                obj = obj.split( \" \" );\n            }\n            if ( Array.isArray( obj ) ) {\n                obj = { left: +obj[ 0 ], top: +obj[ 1 ] || 0 };\n            }\n            if ( \"left\" in obj ) {\n                this.offset.click.left = obj.left + this.margins.left;\n            }\n            if ( \"right\" in obj ) {\n                this.offset.click.left = this.helperProportions.width - obj.right + this.margins.left;\n            }\n            if ( \"top\" in obj ) {\n                this.offset.click.top = obj.top + this.margins.top;\n            }\n            if ( \"bottom\" in obj ) {\n                this.offset.click.top = this.helperProportions.height - obj.bottom + this.margins.top;\n            }\n        },\n\n        _isRootNode: function( element ) {\n            return ( /(html|body)/i ).test( element.tagName ) || element === this.document[ 0 ];\n        },\n\n        _getParentOffset: function() {\n\n            //Get the offsetParent and cache its position\n            var po = this.offsetParent.offset(),\n                document = this.document[ 0 ];\n\n            // This is a special case where we need to modify a offset calculated on start, since the\n            // following happened:\n            // 1. The position of the helper is absolute, so it's position is calculated based on the\n            // next positioned parent\n            // 2. The actual offset parent is a child of the scroll parent, and the scroll parent isn't\n            // the document, which means that the scroll is included in the initial calculation of the\n            // offset of the parent, and never recalculated upon drag\n            if ( this.cssPosition === \"absolute\" && this.scrollParent[ 0 ] !== document &&\n                $.contains( this.scrollParent[ 0 ], this.offsetParent[ 0 ] ) ) {\n                po.left += this.scrollParent.scrollLeft();\n                po.top += this.scrollParent.scrollTop();\n            }\n\n            if ( this._isRootNode( this.offsetParent[ 0 ] ) ) {\n                po = { top: 0, left: 0 };\n            }\n\n            return {\n                top: po.top + ( parseInt( this.offsetParent.css( \"borderTopWidth\" ), 10 ) || 0 ),\n                left: po.left + ( parseInt( this.offsetParent.css( \"borderLeftWidth\" ), 10 ) || 0 )\n            };\n\n        },\n\n        _getRelativeOffset: function() {\n            if ( this.cssPosition !== \"relative\" ) {\n                return { top: 0, left: 0 };\n            }\n\n            var p = this.element.position(),\n                scrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] );\n\n            return {\n                top: p.top - ( parseInt( this.helper.css( \"top\" ), 10 ) || 0 ) +\n                    ( !scrollIsRootNode ? this.scrollParent.scrollTop() : 0 ),\n                left: p.left - ( parseInt( this.helper.css( \"left\" ), 10 ) || 0 ) +\n                    ( !scrollIsRootNode ? this.scrollParent.scrollLeft() : 0 )\n            };\n\n        },\n\n        _cacheMargins: function() {\n            this.margins = {\n                left: ( parseInt( this.element.css( \"marginLeft\" ), 10 ) || 0 ),\n                top: ( parseInt( this.element.css( \"marginTop\" ), 10 ) || 0 ),\n                right: ( parseInt( this.element.css( \"marginRight\" ), 10 ) || 0 ),\n                bottom: ( parseInt( this.element.css( \"marginBottom\" ), 10 ) || 0 )\n            };\n        },\n\n        _cacheHelperProportions: function() {\n            this.helperProportions = {\n                width: this.helper.outerWidth(),\n                height: this.helper.outerHeight()\n            };\n        },\n\n        _setContainment: function() {\n\n            var isUserScrollable, c, ce,\n                o = this.options,\n                document = this.document[ 0 ];\n\n            this.relativeContainer = null;\n\n            if ( !o.containment ) {\n                this.containment = null;\n                return;\n            }\n\n            if ( o.containment === \"window\" ) {\n                this.containment = [\n                    $( window ).scrollLeft() - this.offset.relative.left - this.offset.parent.left,\n                    $( window ).scrollTop() - this.offset.relative.top - this.offset.parent.top,\n                    $( window ).scrollLeft() + $( window ).width() -\n                    this.helperProportions.width - this.margins.left,\n                    $( window ).scrollTop() +\n                    ( $( window ).height() || document.body.parentNode.scrollHeight ) -\n                    this.helperProportions.height - this.margins.top\n                ];\n                return;\n            }\n\n            if ( o.containment === \"document\" ) {\n                this.containment = [\n                    0,\n                    0,\n                    $( document ).width() - this.helperProportions.width - this.margins.left,\n                    ( $( document ).height() || document.body.parentNode.scrollHeight ) -\n                    this.helperProportions.height - this.margins.top\n                ];\n                return;\n            }\n\n            if ( o.containment.constructor === Array ) {\n                this.containment = o.containment;\n                return;\n            }\n\n            if ( o.containment === \"parent\" ) {\n                o.containment = this.helper[ 0 ].parentNode;\n            }\n\n            c = $( o.containment );\n            ce = c[ 0 ];\n\n            if ( !ce ) {\n                return;\n            }\n\n            isUserScrollable = /(scroll|auto)/.test( c.css( \"overflow\" ) );\n\n            this.containment = [\n                ( parseInt( c.css( \"borderLeftWidth\" ), 10 ) || 0 ) +\n                ( parseInt( c.css( \"paddingLeft\" ), 10 ) || 0 ),\n                ( parseInt( c.css( \"borderTopWidth\" ), 10 ) || 0 ) +\n                ( parseInt( c.css( \"paddingTop\" ), 10 ) || 0 ),\n                ( isUserScrollable ? Math.max( ce.scrollWidth, ce.offsetWidth ) : ce.offsetWidth ) -\n                ( parseInt( c.css( \"borderRightWidth\" ), 10 ) || 0 ) -\n                ( parseInt( c.css( \"paddingRight\" ), 10 ) || 0 ) -\n                this.helperProportions.width -\n                this.margins.left -\n                this.margins.right,\n                ( isUserScrollable ? Math.max( ce.scrollHeight, ce.offsetHeight ) : ce.offsetHeight ) -\n                ( parseInt( c.css( \"borderBottomWidth\" ), 10 ) || 0 ) -\n                ( parseInt( c.css( \"paddingBottom\" ), 10 ) || 0 ) -\n                this.helperProportions.height -\n                this.margins.top -\n                this.margins.bottom\n            ];\n            this.relativeContainer = c;\n        },\n\n        _convertPositionTo: function( d, pos ) {\n\n            if ( !pos ) {\n                pos = this.position;\n            }\n\n            var mod = d === \"absolute\" ? 1 : -1,\n                scrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] );\n\n            return {\n                top: (\n\n                    // The absolute mouse position\n                    pos.top\t+\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.top * mod +\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.top * mod -\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.offset.scroll.top :\n                        ( scrollIsRootNode ? 0 : this.offset.scroll.top ) ) * mod )\n                ),\n                left: (\n\n                    // The absolute mouse position\n                    pos.left +\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.left * mod +\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.left * mod\t-\n                    ( ( this.cssPosition === \"fixed\" ?\n                        -this.offset.scroll.left :\n                        ( scrollIsRootNode ? 0 : this.offset.scroll.left ) ) * mod )\n                )\n            };\n\n        },\n\n        _generatePosition: function( event, constrainPosition ) {\n\n            var containment, co, top, left,\n                o = this.options,\n                scrollIsRootNode = this._isRootNode( this.scrollParent[ 0 ] ),\n                pageX = event.pageX,\n                pageY = event.pageY;\n\n            // Cache the scroll\n            if ( !scrollIsRootNode || !this.offset.scroll ) {\n                this.offset.scroll = {\n                    top: this.scrollParent.scrollTop(),\n                    left: this.scrollParent.scrollLeft()\n                };\n            }\n\n            /*\n             * - Position constraining -\n             * Constrain the position to a mix of grid, containment.\n             */\n\n            // If we are not dragging yet, we won't check for options\n            if ( constrainPosition ) {\n                if ( this.containment ) {\n                    if ( this.relativeContainer ) {\n                        co = this.relativeContainer.offset();\n                        containment = [\n                            this.containment[ 0 ] + co.left,\n                            this.containment[ 1 ] + co.top,\n                            this.containment[ 2 ] + co.left,\n                            this.containment[ 3 ] + co.top\n                        ];\n                    } else {\n                        containment = this.containment;\n                    }\n\n                    if ( event.pageX - this.offset.click.left < containment[ 0 ] ) {\n                        pageX = containment[ 0 ] + this.offset.click.left;\n                    }\n                    if ( event.pageY - this.offset.click.top < containment[ 1 ] ) {\n                        pageY = containment[ 1 ] + this.offset.click.top;\n                    }\n                    if ( event.pageX - this.offset.click.left > containment[ 2 ] ) {\n                        pageX = containment[ 2 ] + this.offset.click.left;\n                    }\n                    if ( event.pageY - this.offset.click.top > containment[ 3 ] ) {\n                        pageY = containment[ 3 ] + this.offset.click.top;\n                    }\n                }\n\n                if ( o.grid ) {\n\n                    //Check for grid elements set to 0 to prevent divide by 0 error causing invalid\n                    // argument errors in IE (see ticket #6950)\n                    top = o.grid[ 1 ] ? this.originalPageY + Math.round( ( pageY -\n                        this.originalPageY ) / o.grid[ 1 ] ) * o.grid[ 1 ] : this.originalPageY;\n                    pageY = containment ? ( ( top - this.offset.click.top >= containment[ 1 ] ||\n                        top - this.offset.click.top > containment[ 3 ] ) ?\n                        top :\n                        ( ( top - this.offset.click.top >= containment[ 1 ] ) ?\n                            top - o.grid[ 1 ] : top + o.grid[ 1 ] ) ) : top;\n\n                    left = o.grid[ 0 ] ? this.originalPageX +\n                        Math.round( ( pageX - this.originalPageX ) / o.grid[ 0 ] ) * o.grid[ 0 ] :\n                        this.originalPageX;\n                    pageX = containment ? ( ( left - this.offset.click.left >= containment[ 0 ] ||\n                        left - this.offset.click.left > containment[ 2 ] ) ?\n                        left :\n                        ( ( left - this.offset.click.left >= containment[ 0 ] ) ?\n                            left - o.grid[ 0 ] : left + o.grid[ 0 ] ) ) : left;\n                }\n\n                if ( o.axis === \"y\" ) {\n                    pageX = this.originalPageX;\n                }\n\n                if ( o.axis === \"x\" ) {\n                    pageY = this.originalPageY;\n                }\n            }\n\n            return {\n                top: (\n\n                    // The absolute mouse position\n                    pageY -\n\n                    // Click offset (relative to the element)\n                    this.offset.click.top -\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.top -\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.top +\n                    ( this.cssPosition === \"fixed\" ?\n                        -this.offset.scroll.top :\n                        ( scrollIsRootNode ? 0 : this.offset.scroll.top ) )\n                ),\n                left: (\n\n                    // The absolute mouse position\n                    pageX -\n\n                    // Click offset (relative to the element)\n                    this.offset.click.left -\n\n                    // Only for relative positioned nodes: Relative offset from element to offset parent\n                    this.offset.relative.left -\n\n                    // The offsetParent's offset without borders (offset + border)\n                    this.offset.parent.left +\n                    ( this.cssPosition === \"fixed\" ?\n                        -this.offset.scroll.left :\n                        ( scrollIsRootNode ? 0 : this.offset.scroll.left ) )\n                )\n            };\n\n        },\n\n        _clear: function() {\n            this._removeClass( this.helper, \"ui-draggable-dragging\" );\n            if ( this.helper[ 0 ] !== this.element[ 0 ] && !this.cancelHelperRemoval ) {\n                this.helper.remove();\n            }\n            this.helper = null;\n            this.cancelHelperRemoval = false;\n            if ( this.destroyOnClear ) {\n                this.destroy();\n            }\n        },\n\n        // From now on bulk stuff - mainly helpers\n\n        _trigger: function( type, event, ui ) {\n            ui = ui || this._uiHash();\n            $.ui.plugin.call( this, type, [ event, ui, this ], true );\n\n            // Absolute position and offset (see #6884 ) have to be recalculated after plugins\n            if ( /^(drag|start|stop)/.test( type ) ) {\n                this.positionAbs = this._convertPositionTo( \"absolute\" );\n                ui.offset = this.positionAbs;\n            }\n            return $.Widget.prototype._trigger.call( this, type, event, ui );\n        },\n\n        plugins: {},\n\n        _uiHash: function() {\n            return {\n                helper: this.helper,\n                position: this.position,\n                originalPosition: this.originalPosition,\n                offset: this.positionAbs\n            };\n        }\n\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"connectToSortable\", {\n        start: function( event, ui, draggable ) {\n            var uiSortable = $.extend( {}, ui, {\n                item: draggable.element\n            } );\n\n            draggable.sortables = [];\n            $( draggable.options.connectToSortable ).each( function() {\n                var sortable = $( this ).sortable( \"instance\" );\n\n                if ( sortable && !sortable.options.disabled ) {\n                    draggable.sortables.push( sortable );\n\n                    // RefreshPositions is called at drag start to refresh the containerCache\n                    // which is used in drag. This ensures it's initialized and synchronized\n                    // with any changes that might have happened on the page since initialization.\n                    sortable.refreshPositions();\n                    sortable._trigger( \"activate\", event, uiSortable );\n                }\n            } );\n        },\n        stop: function( event, ui, draggable ) {\n            var uiSortable = $.extend( {}, ui, {\n                item: draggable.element\n            } );\n\n            draggable.cancelHelperRemoval = false;\n\n            $.each( draggable.sortables, function() {\n                var sortable = this;\n\n                if ( sortable.isOver ) {\n                    sortable.isOver = 0;\n\n                    // Allow this sortable to handle removing the helper\n                    draggable.cancelHelperRemoval = true;\n                    sortable.cancelHelperRemoval = false;\n\n                    // Use _storedCSS To restore properties in the sortable,\n                    // as this also handles revert (#9675) since the draggable\n                    // may have modified them in unexpected ways (#8809)\n                    sortable._storedCSS = {\n                        position: sortable.placeholder.css( \"position\" ),\n                        top: sortable.placeholder.css( \"top\" ),\n                        left: sortable.placeholder.css( \"left\" )\n                    };\n\n                    sortable._mouseStop( event );\n\n                    // Once drag has ended, the sortable should return to using\n                    // its original helper, not the shared helper from draggable\n                    sortable.options.helper = sortable.options._helper;\n                } else {\n\n                    // Prevent this Sortable from removing the helper.\n                    // However, don't set the draggable to remove the helper\n                    // either as another connected Sortable may yet handle the removal.\n                    sortable.cancelHelperRemoval = true;\n\n                    sortable._trigger( \"deactivate\", event, uiSortable );\n                }\n            } );\n        },\n        drag: function( event, ui, draggable ) {\n            $.each( draggable.sortables, function() {\n                var innermostIntersecting = false,\n                    sortable = this;\n\n                // Copy over variables that sortable's _intersectsWith uses\n                sortable.positionAbs = draggable.positionAbs;\n                sortable.helperProportions = draggable.helperProportions;\n                sortable.offset.click = draggable.offset.click;\n\n                if ( sortable._intersectsWith( sortable.containerCache ) ) {\n                    innermostIntersecting = true;\n\n                    $.each( draggable.sortables, function() {\n\n                        // Copy over variables that sortable's _intersectsWith uses\n                        this.positionAbs = draggable.positionAbs;\n                        this.helperProportions = draggable.helperProportions;\n                        this.offset.click = draggable.offset.click;\n\n                        if ( this !== sortable &&\n                            this._intersectsWith( this.containerCache ) &&\n                            $.contains( sortable.element[ 0 ], this.element[ 0 ] ) ) {\n                            innermostIntersecting = false;\n                        }\n\n                        return innermostIntersecting;\n                    } );\n                }\n\n                if ( innermostIntersecting ) {\n\n                    // If it intersects, we use a little isOver variable and set it once,\n                    // so that the move-in stuff gets fired only once.\n                    if ( !sortable.isOver ) {\n                        sortable.isOver = 1;\n\n                        // Store draggable's parent in case we need to reappend to it later.\n                        draggable._parent = ui.helper.parent();\n\n                        sortable.currentItem = ui.helper\n                            .appendTo( sortable.element )\n                            .data( \"ui-sortable-item\", true );\n\n                        // Store helper option to later restore it\n                        sortable.options._helper = sortable.options.helper;\n\n                        sortable.options.helper = function() {\n                            return ui.helper[ 0 ];\n                        };\n\n                        // Fire the start events of the sortable with our passed browser event,\n                        // and our own helper (so it doesn't create a new one)\n                        event.target = sortable.currentItem[ 0 ];\n                        sortable._mouseCapture( event, true );\n                        sortable._mouseStart( event, true, true );\n\n                        // Because the browser event is way off the new appended portlet,\n                        // modify necessary variables to reflect the changes\n                        sortable.offset.click.top = draggable.offset.click.top;\n                        sortable.offset.click.left = draggable.offset.click.left;\n                        sortable.offset.parent.left -= draggable.offset.parent.left -\n                            sortable.offset.parent.left;\n                        sortable.offset.parent.top -= draggable.offset.parent.top -\n                            sortable.offset.parent.top;\n\n                        draggable._trigger( \"toSortable\", event );\n\n                        // Inform draggable that the helper is in a valid drop zone,\n                        // used solely in the revert option to handle \"valid/invalid\".\n                        draggable.dropped = sortable.element;\n\n                        // Need to refreshPositions of all sortables in the case that\n                        // adding to one sortable changes the location of the other sortables (#9675)\n                        $.each( draggable.sortables, function() {\n                            this.refreshPositions();\n                        } );\n\n                        // Hack so receive/update callbacks work (mostly)\n                        draggable.currentItem = draggable.element;\n                        sortable.fromOutside = draggable;\n                    }\n\n                    if ( sortable.currentItem ) {\n                        sortable._mouseDrag( event );\n\n                        // Copy the sortable's position because the draggable's can potentially reflect\n                        // a relative position, while sortable is always absolute, which the dragged\n                        // element has now become. (#8809)\n                        ui.position = sortable.position;\n                    }\n                } else {\n\n                    // If it doesn't intersect with the sortable, and it intersected before,\n                    // we fake the drag stop of the sortable, but make sure it doesn't remove\n                    // the helper by using cancelHelperRemoval.\n                    if ( sortable.isOver ) {\n\n                        sortable.isOver = 0;\n                        sortable.cancelHelperRemoval = true;\n\n                        // Calling sortable's mouseStop would trigger a revert,\n                        // so revert must be temporarily false until after mouseStop is called.\n                        sortable.options._revert = sortable.options.revert;\n                        sortable.options.revert = false;\n\n                        sortable._trigger( \"out\", event, sortable._uiHash( sortable ) );\n                        sortable._mouseStop( event, true );\n\n                        // Restore sortable behaviors that were modfied\n                        // when the draggable entered the sortable area (#9481)\n                        sortable.options.revert = sortable.options._revert;\n                        sortable.options.helper = sortable.options._helper;\n\n                        if ( sortable.placeholder ) {\n                            sortable.placeholder.remove();\n                        }\n\n                        // Restore and recalculate the draggable's offset considering the sortable\n                        // may have modified them in unexpected ways. (#8809, #10669)\n                        ui.helper.appendTo( draggable._parent );\n                        draggable._refreshOffsets( event );\n                        ui.position = draggable._generatePosition( event, true );\n\n                        draggable._trigger( \"fromSortable\", event );\n\n                        // Inform draggable that the helper is no longer in a valid drop zone\n                        draggable.dropped = false;\n\n                        // Need to refreshPositions of all sortables just in case removing\n                        // from one sortable changes the location of other sortables (#9675)\n                        $.each( draggable.sortables, function() {\n                            this.refreshPositions();\n                        } );\n                    }\n                }\n            } );\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"cursor\", {\n        start: function( event, ui, instance ) {\n            var t = $( \"body\" ),\n                o = instance.options;\n\n            if ( t.css( \"cursor\" ) ) {\n                o._cursor = t.css( \"cursor\" );\n            }\n            t.css( \"cursor\", o.cursor );\n        },\n        stop: function( event, ui, instance ) {\n            var o = instance.options;\n            if ( o._cursor ) {\n                $( \"body\" ).css( \"cursor\", o._cursor );\n            }\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"opacity\", {\n        start: function( event, ui, instance ) {\n            var t = $( ui.helper ),\n                o = instance.options;\n            if ( t.css( \"opacity\" ) ) {\n                o._opacity = t.css( \"opacity\" );\n            }\n            t.css( \"opacity\", o.opacity );\n        },\n        stop: function( event, ui, instance ) {\n            var o = instance.options;\n            if ( o._opacity ) {\n                $( ui.helper ).css( \"opacity\", o._opacity );\n            }\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"scroll\", {\n        start: function( event, ui, i ) {\n            if ( !i.scrollParentNotHidden ) {\n                i.scrollParentNotHidden = i.helper.scrollParent( false );\n            }\n\n            if ( i.scrollParentNotHidden[ 0 ] !== i.document[ 0 ] &&\n                i.scrollParentNotHidden[ 0 ].tagName !== \"HTML\" ) {\n                i.overflowOffset = i.scrollParentNotHidden.offset();\n            }\n        },\n        drag: function( event, ui, i  ) {\n\n            var o = i.options,\n                scrolled = false,\n                scrollParent = i.scrollParentNotHidden[ 0 ],\n                document = i.document[ 0 ];\n\n            if ( scrollParent !== document && scrollParent.tagName !== \"HTML\" ) {\n                if ( !o.axis || o.axis !== \"x\" ) {\n                    if ( ( i.overflowOffset.top + scrollParent.offsetHeight ) - event.pageY <\n                        o.scrollSensitivity ) {\n                        scrollParent.scrollTop = scrolled = scrollParent.scrollTop + o.scrollSpeed;\n                    } else if ( event.pageY - i.overflowOffset.top < o.scrollSensitivity ) {\n                        scrollParent.scrollTop = scrolled = scrollParent.scrollTop - o.scrollSpeed;\n                    }\n                }\n\n                if ( !o.axis || o.axis !== \"y\" ) {\n                    if ( ( i.overflowOffset.left + scrollParent.offsetWidth ) - event.pageX <\n                        o.scrollSensitivity ) {\n                        scrollParent.scrollLeft = scrolled = scrollParent.scrollLeft + o.scrollSpeed;\n                    } else if ( event.pageX - i.overflowOffset.left < o.scrollSensitivity ) {\n                        scrollParent.scrollLeft = scrolled = scrollParent.scrollLeft - o.scrollSpeed;\n                    }\n                }\n\n            } else {\n\n                if ( !o.axis || o.axis !== \"x\" ) {\n                    if ( event.pageY - $( document ).scrollTop() < o.scrollSensitivity ) {\n                        scrolled = $( document ).scrollTop( $( document ).scrollTop() - o.scrollSpeed );\n                    } else if ( $( window ).height() - ( event.pageY - $( document ).scrollTop() ) <\n                        o.scrollSensitivity ) {\n                        scrolled = $( document ).scrollTop( $( document ).scrollTop() + o.scrollSpeed );\n                    }\n                }\n\n                if ( !o.axis || o.axis !== \"y\" ) {\n                    if ( event.pageX - $( document ).scrollLeft() < o.scrollSensitivity ) {\n                        scrolled = $( document ).scrollLeft(\n                            $( document ).scrollLeft() - o.scrollSpeed\n                        );\n                    } else if ( $( window ).width() - ( event.pageX - $( document ).scrollLeft() ) <\n                        o.scrollSensitivity ) {\n                        scrolled = $( document ).scrollLeft(\n                            $( document ).scrollLeft() + o.scrollSpeed\n                        );\n                    }\n                }\n\n            }\n\n            if ( scrolled !== false && $.ui.ddmanager && !o.dropBehaviour ) {\n                $.ui.ddmanager.prepareOffsets( i, event );\n            }\n\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"snap\", {\n        start: function( event, ui, i ) {\n\n            var o = i.options;\n\n            i.snapElements = [];\n\n            $( o.snap.constructor !== String ? ( o.snap.items || \":data(ui-draggable)\" ) : o.snap )\n                .each( function() {\n                    var $t = $( this ),\n                        $o = $t.offset();\n                    if ( this !== i.element[ 0 ] ) {\n                        i.snapElements.push( {\n                            item: this,\n                            width: $t.outerWidth(), height: $t.outerHeight(),\n                            top: $o.top, left: $o.left\n                        } );\n                    }\n                } );\n\n        },\n        drag: function( event, ui, inst ) {\n\n            var ts, bs, ls, rs, l, r, t, b, i, first,\n                o = inst.options,\n                d = o.snapTolerance,\n                x1 = ui.offset.left, x2 = x1 + inst.helperProportions.width,\n                y1 = ui.offset.top, y2 = y1 + inst.helperProportions.height;\n\n            for ( i = inst.snapElements.length - 1; i >= 0; i-- ) {\n\n                l = inst.snapElements[ i ].left - inst.margins.left;\n                r = l + inst.snapElements[ i ].width;\n                t = inst.snapElements[ i ].top - inst.margins.top;\n                b = t + inst.snapElements[ i ].height;\n\n                if ( x2 < l - d || x1 > r + d || y2 < t - d || y1 > b + d ||\n                    !$.contains( inst.snapElements[ i ].item.ownerDocument,\n                        inst.snapElements[ i ].item ) ) {\n                    if ( inst.snapElements[ i ].snapping ) {\n                        if ( inst.options.snap.release ) {\n                            inst.options.snap.release.call(\n                                inst.element,\n                                event,\n                                $.extend( inst._uiHash(), { snapItem: inst.snapElements[ i ].item } )\n                            );\n                        }\n                    }\n                    inst.snapElements[ i ].snapping = false;\n                    continue;\n                }\n\n                if ( o.snapMode !== \"inner\" ) {\n                    ts = Math.abs( t - y2 ) <= d;\n                    bs = Math.abs( b - y1 ) <= d;\n                    ls = Math.abs( l - x2 ) <= d;\n                    rs = Math.abs( r - x1 ) <= d;\n                    if ( ts ) {\n                        ui.position.top = inst._convertPositionTo( \"relative\", {\n                            top: t - inst.helperProportions.height,\n                            left: 0\n                        } ).top;\n                    }\n                    if ( bs ) {\n                        ui.position.top = inst._convertPositionTo( \"relative\", {\n                            top: b,\n                            left: 0\n                        } ).top;\n                    }\n                    if ( ls ) {\n                        ui.position.left = inst._convertPositionTo( \"relative\", {\n                            top: 0,\n                            left: l - inst.helperProportions.width\n                        } ).left;\n                    }\n                    if ( rs ) {\n                        ui.position.left = inst._convertPositionTo( \"relative\", {\n                            top: 0,\n                            left: r\n                        } ).left;\n                    }\n                }\n\n                first = ( ts || bs || ls || rs );\n\n                if ( o.snapMode !== \"outer\" ) {\n                    ts = Math.abs( t - y1 ) <= d;\n                    bs = Math.abs( b - y2 ) <= d;\n                    ls = Math.abs( l - x1 ) <= d;\n                    rs = Math.abs( r - x2 ) <= d;\n                    if ( ts ) {\n                        ui.position.top = inst._convertPositionTo( \"relative\", {\n                            top: t,\n                            left: 0\n                        } ).top;\n                    }\n                    if ( bs ) {\n                        ui.position.top = inst._convertPositionTo( \"relative\", {\n                            top: b - inst.helperProportions.height,\n                            left: 0\n                        } ).top;\n                    }\n                    if ( ls ) {\n                        ui.position.left = inst._convertPositionTo( \"relative\", {\n                            top: 0,\n                            left: l\n                        } ).left;\n                    }\n                    if ( rs ) {\n                        ui.position.left = inst._convertPositionTo( \"relative\", {\n                            top: 0,\n                            left: r - inst.helperProportions.width\n                        } ).left;\n                    }\n                }\n\n                if ( !inst.snapElements[ i ].snapping && ( ts || bs || ls || rs || first ) ) {\n                    if ( inst.options.snap.snap ) {\n                        inst.options.snap.snap.call(\n                            inst.element,\n                            event,\n                            $.extend( inst._uiHash(), {\n                                snapItem: inst.snapElements[ i ].item\n                            } ) );\n                    }\n                }\n                inst.snapElements[ i ].snapping = ( ts || bs || ls || rs || first );\n\n            }\n\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"stack\", {\n        start: function( event, ui, instance ) {\n            var min,\n                o = instance.options,\n                group = $.makeArray( $( o.stack ) ).sort( function( a, b ) {\n                    return ( parseInt( $( a ).css( \"zIndex\" ), 10 ) || 0 ) -\n                        ( parseInt( $( b ).css( \"zIndex\" ), 10 ) || 0 );\n                } );\n\n            if ( !group.length ) {\n                return;\n            }\n\n            min = parseInt( $( group[ 0 ] ).css( \"zIndex\" ), 10 ) || 0;\n            $( group ).each( function( i ) {\n                $( this ).css( \"zIndex\", min + i );\n            } );\n            this.css( \"zIndex\", ( min + group.length ) );\n        }\n    } );\n\n    $.ui.plugin.add( \"draggable\", \"zIndex\", {\n        start: function( event, ui, instance ) {\n            var t = $( ui.helper ),\n                o = instance.options;\n\n            if ( t.css( \"zIndex\" ) ) {\n                o._zIndex = t.css( \"zIndex\" );\n            }\n            t.css( \"zIndex\", o.zIndex );\n        },\n        stop: function( event, ui, instance ) {\n            var o = instance.options;\n\n            if ( o._zIndex ) {\n                $( ui.helper ).css( \"zIndex\", o._zIndex );\n            }\n        }\n    } );\n\n    return $.ui.draggable;\n\n} );\n","jquery/ui-modules/widgets/checkboxradio.js":"/*!\n * jQuery UI Checkboxradio 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Checkboxradio\n//>>group: Widgets\n//>>description: Enhances a form with multiple themeable checkboxes or radio buttons.\n//>>docs: http://api.jqueryui.com/checkboxradio/\n//>>demos: http://jqueryui.com/checkboxradio/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/button.css\n//>>css.structure: ../../themes/base/checkboxradio.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../form-reset-mixin\",\n            \"../labels\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.checkboxradio\", [ $.ui.formResetMixin, {\n        version: \"1.13.2\",\n        options: {\n            disabled: null,\n            label: null,\n            icon: true,\n            classes: {\n                \"ui-checkboxradio-label\": \"ui-corner-all\",\n                \"ui-checkboxradio-icon\": \"ui-corner-all\"\n            }\n        },\n\n        _getCreateOptions: function() {\n            var disabled, labels, labelContents;\n            var options = this._super() || {};\n\n            // We read the type here, because it makes more sense to throw a element type error first,\n            // rather then the error for lack of a label. Often if its the wrong type, it\n            // won't have a label (e.g. calling on a div, btn, etc)\n            this._readType();\n\n            labels = this.element.labels();\n\n            // If there are multiple labels, use the last one\n            this.label = $( labels[ labels.length - 1 ] );\n            if ( !this.label.length ) {\n                $.error( \"No label found for checkboxradio widget\" );\n            }\n\n            this.originalLabel = \"\";\n\n            // We need to get the label text but this may also need to make sure it does not contain the\n            // input itself.\n            // The label contents could be text, html, or a mix. We wrap all elements\n            // and read the wrapper's `innerHTML` to get a string representation of\n            // the label, without the input as part of it.\n            labelContents = this.label.contents().not( this.element[ 0 ] );\n\n            if ( labelContents.length ) {\n                this.originalLabel += labelContents\n                    .clone()\n                    .wrapAll( \"<div></div>\" )\n                    .parent()\n                    .html();\n            }\n\n            // Set the label option if we found label text\n            if ( this.originalLabel ) {\n                options.label = this.originalLabel;\n            }\n\n            disabled = this.element[ 0 ].disabled;\n            if ( disabled != null ) {\n                options.disabled = disabled;\n            }\n            return options;\n        },\n\n        _create: function() {\n            var checked = this.element[ 0 ].checked;\n\n            this._bindFormResetHandler();\n\n            if ( this.options.disabled == null ) {\n                this.options.disabled = this.element[ 0 ].disabled;\n            }\n\n            this._setOption( \"disabled\", this.options.disabled );\n            this._addClass( \"ui-checkboxradio\", \"ui-helper-hidden-accessible\" );\n            this._addClass( this.label, \"ui-checkboxradio-label\", \"ui-button ui-widget\" );\n\n            if ( this.type === \"radio\" ) {\n                this._addClass( this.label, \"ui-checkboxradio-radio-label\" );\n            }\n\n            if ( this.options.label && this.options.label !== this.originalLabel ) {\n                this._updateLabel();\n            } else if ( this.originalLabel ) {\n                this.options.label = this.originalLabel;\n            }\n\n            this._enhance();\n\n            if ( checked ) {\n                this._addClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\" );\n            }\n\n            this._on( {\n                change: \"_toggleClasses\",\n                focus: function() {\n                    this._addClass( this.label, null, \"ui-state-focus ui-visual-focus\" );\n                },\n                blur: function() {\n                    this._removeClass( this.label, null, \"ui-state-focus ui-visual-focus\" );\n                }\n            } );\n        },\n\n        _readType: function() {\n            var nodeName = this.element[ 0 ].nodeName.toLowerCase();\n            this.type = this.element[ 0 ].type;\n            if ( nodeName !== \"input\" || !/radio|checkbox/.test( this.type ) ) {\n                $.error( \"Can't create checkboxradio on element.nodeName=\" + nodeName +\n                    \" and element.type=\" + this.type );\n            }\n        },\n\n        // Support jQuery Mobile enhanced option\n        _enhance: function() {\n            this._updateIcon( this.element[ 0 ].checked );\n        },\n\n        widget: function() {\n            return this.label;\n        },\n\n        _getRadioGroup: function() {\n            var group;\n            var name = this.element[ 0 ].name;\n            var nameSelector = \"input[name='\" + $.escapeSelector( name ) + \"']\";\n\n            if ( !name ) {\n                return $( [] );\n            }\n\n            if ( this.form.length ) {\n                group = $( this.form[ 0 ].elements ).filter( nameSelector );\n            } else {\n\n                // Not inside a form, check all inputs that also are not inside a form\n                group = $( nameSelector ).filter( function() {\n                    return $( this )._form().length === 0;\n                } );\n            }\n\n            return group.not( this.element );\n        },\n\n        _toggleClasses: function() {\n            var checked = this.element[ 0 ].checked;\n            this._toggleClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\", checked );\n\n            if ( this.options.icon && this.type === \"checkbox\" ) {\n                this._toggleClass( this.icon, null, \"ui-icon-check ui-state-checked\", checked )\n                    ._toggleClass( this.icon, null, \"ui-icon-blank\", !checked );\n            }\n\n            if ( this.type === \"radio\" ) {\n                this._getRadioGroup()\n                    .each( function() {\n                        var instance = $( this ).checkboxradio( \"instance\" );\n\n                        if ( instance ) {\n                            instance._removeClass( instance.label,\n                                \"ui-checkboxradio-checked\", \"ui-state-active\" );\n                        }\n                    } );\n            }\n        },\n\n        _destroy: function() {\n            this._unbindFormResetHandler();\n\n            if ( this.icon ) {\n                this.icon.remove();\n                this.iconSpace.remove();\n            }\n        },\n\n        _setOption: function( key, value ) {\n\n            // We don't allow the value to be set to nothing\n            if ( key === \"label\" && !value ) {\n                return;\n            }\n\n            this._super( key, value );\n\n            if ( key === \"disabled\" ) {\n                this._toggleClass( this.label, null, \"ui-state-disabled\", value );\n                this.element[ 0 ].disabled = value;\n\n                // Don't refresh when setting disabled\n                return;\n            }\n            this.refresh();\n        },\n\n        _updateIcon: function( checked ) {\n            var toAdd = \"ui-icon ui-icon-background \";\n\n            if ( this.options.icon ) {\n                if ( !this.icon ) {\n                    this.icon = $( \"<span>\" );\n                    this.iconSpace = $( \"<span> </span>\" );\n                    this._addClass( this.iconSpace, \"ui-checkboxradio-icon-space\" );\n                }\n\n                if ( this.type === \"checkbox\" ) {\n                    toAdd += checked ? \"ui-icon-check ui-state-checked\" : \"ui-icon-blank\";\n                    this._removeClass( this.icon, null, checked ? \"ui-icon-blank\" : \"ui-icon-check\" );\n                } else {\n                    toAdd += \"ui-icon-blank\";\n                }\n                this._addClass( this.icon, \"ui-checkboxradio-icon\", toAdd );\n                if ( !checked ) {\n                    this._removeClass( this.icon, null, \"ui-icon-check ui-state-checked\" );\n                }\n                this.icon.prependTo( this.label ).after( this.iconSpace );\n            } else if ( this.icon !== undefined ) {\n                this.icon.remove();\n                this.iconSpace.remove();\n                delete this.icon;\n            }\n        },\n\n        _updateLabel: function() {\n\n            // Remove the contents of the label ( minus the icon, icon space, and input )\n            var contents = this.label.contents().not( this.element[ 0 ] );\n            if ( this.icon ) {\n                contents = contents.not( this.icon[ 0 ] );\n            }\n            if ( this.iconSpace ) {\n                contents = contents.not( this.iconSpace[ 0 ] );\n            }\n            contents.remove();\n\n            this.label.append( this.options.label );\n        },\n\n        refresh: function() {\n            var checked = this.element[ 0 ].checked,\n                isDisabled = this.element[ 0 ].disabled;\n\n            this._updateIcon( checked );\n            this._toggleClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\", checked );\n            if ( this.options.label !== null ) {\n                this._updateLabel();\n            }\n\n            if ( isDisabled !== this.options.disabled ) {\n                this._setOptions( { \"disabled\": isDisabled } );\n            }\n        }\n\n    } ] );\n\n    return $.ui.checkboxradio;\n\n} );\n","jquery/ui-modules/widgets/tooltip.js":"/*!\n * jQuery UI Tooltip 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Tooltip\n//>>group: Widgets\n//>>description: Shows additional information for any element on hover or focus.\n//>>docs: http://api.jqueryui.com/tooltip/\n//>>demos: http://jqueryui.com/tooltip/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/tooltip.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../keycode\",\n            \"../position\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.tooltip\", {\n        version: \"1.13.2\",\n        options: {\n            classes: {\n                \"ui-tooltip\": \"ui-corner-all ui-widget-shadow\"\n            },\n            content: function() {\n                var title = $( this ).attr( \"title\" );\n\n                // Escape title, since we're going from an attribute to raw HTML\n                return $( \"<a>\" ).text( title ).html();\n            },\n            hide: true,\n\n            // Disabled elements have inconsistent behavior across browsers (#8661)\n            items: \"[title]:not([disabled])\",\n            position: {\n                my: \"left top+15\",\n                at: \"left bottom\",\n                collision: \"flipfit flip\"\n            },\n            show: true,\n            track: false,\n\n            // Callbacks\n            close: null,\n            open: null\n        },\n\n        _addDescribedBy: function( elem, id ) {\n            var describedby = ( elem.attr( \"aria-describedby\" ) || \"\" ).split( /\\s+/ );\n            describedby.push( id );\n            elem\n                .data( \"ui-tooltip-id\", id )\n                .attr( \"aria-describedby\", String.prototype.trim.call( describedby.join( \" \" ) ) );\n        },\n\n        _removeDescribedBy: function( elem ) {\n            var id = elem.data( \"ui-tooltip-id\" ),\n                describedby = ( elem.attr( \"aria-describedby\" ) || \"\" ).split( /\\s+/ ),\n                index = $.inArray( id, describedby );\n\n            if ( index !== -1 ) {\n                describedby.splice( index, 1 );\n            }\n\n            elem.removeData( \"ui-tooltip-id\" );\n            describedby = String.prototype.trim.call( describedby.join( \" \" ) );\n            if ( describedby ) {\n                elem.attr( \"aria-describedby\", describedby );\n            } else {\n                elem.removeAttr( \"aria-describedby\" );\n            }\n        },\n\n        _create: function() {\n            this._on( {\n                mouseover: \"open\",\n                focusin: \"open\"\n            } );\n\n            // IDs of generated tooltips, needed for destroy\n            this.tooltips = {};\n\n            // IDs of parent tooltips where we removed the title attribute\n            this.parents = {};\n\n            // Append the aria-live region so tooltips announce correctly\n            this.liveRegion = $( \"<div>\" )\n                .attr( {\n                    role: \"log\",\n                    \"aria-live\": \"assertive\",\n                    \"aria-relevant\": \"additions\"\n                } )\n                .appendTo( this.document[ 0 ].body );\n            this._addClass( this.liveRegion, null, \"ui-helper-hidden-accessible\" );\n\n            this.disabledTitles = $( [] );\n        },\n\n        _setOption: function( key, value ) {\n            var that = this;\n\n            this._super( key, value );\n\n            if ( key === \"content\" ) {\n                $.each( this.tooltips, function( id, tooltipData ) {\n                    that._updateContent( tooltipData.element );\n                } );\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this[ value ? \"_disable\" : \"_enable\" ]();\n        },\n\n        _disable: function() {\n            var that = this;\n\n            // Close open tooltips\n            $.each( this.tooltips, function( id, tooltipData ) {\n                var event = $.Event( \"blur\" );\n                event.target = event.currentTarget = tooltipData.element[ 0 ];\n                that.close( event, true );\n            } );\n\n            // Remove title attributes to prevent native tooltips\n            this.disabledTitles = this.disabledTitles.add(\n                this.element.find( this.options.items ).addBack()\n                    .filter( function() {\n                        var element = $( this );\n                        if ( element.is( \"[title]\" ) ) {\n                            return element\n                                .data( \"ui-tooltip-title\", element.attr( \"title\" ) )\n                                .removeAttr( \"title\" );\n                        }\n                    } )\n            );\n        },\n\n        _enable: function() {\n\n            // restore title attributes\n            this.disabledTitles.each( function() {\n                var element = $( this );\n                if ( element.data( \"ui-tooltip-title\" ) ) {\n                    element.attr( \"title\", element.data( \"ui-tooltip-title\" ) );\n                }\n            } );\n            this.disabledTitles = $( [] );\n        },\n\n        open: function( event ) {\n            var that = this,\n                target = $( event ? event.target : this.element )\n\n                    // we need closest here due to mouseover bubbling,\n                    // but always pointing at the same event target\n                    .closest( this.options.items );\n\n            // No element to show a tooltip for or the tooltip is already open\n            if ( !target.length || target.data( \"ui-tooltip-id\" ) ) {\n                return;\n            }\n\n            if ( target.attr( \"title\" ) ) {\n                target.data( \"ui-tooltip-title\", target.attr( \"title\" ) );\n            }\n\n            target.data( \"ui-tooltip-open\", true );\n\n            // Kill parent tooltips, custom or native, for hover\n            if ( event && event.type === \"mouseover\" ) {\n                target.parents().each( function() {\n                    var parent = $( this ),\n                        blurEvent;\n                    if ( parent.data( \"ui-tooltip-open\" ) ) {\n                        blurEvent = $.Event( \"blur\" );\n                        blurEvent.target = blurEvent.currentTarget = this;\n                        that.close( blurEvent, true );\n                    }\n                    if ( parent.attr( \"title\" ) ) {\n                        parent.uniqueId();\n                        that.parents[ this.id ] = {\n                            element: this,\n                            title: parent.attr( \"title\" )\n                        };\n                        parent.attr( \"title\", \"\" );\n                    }\n                } );\n            }\n\n            this._registerCloseHandlers( event, target );\n            this._updateContent( target, event );\n        },\n\n        _updateContent: function( target, event ) {\n            var content,\n                contentOption = this.options.content,\n                that = this,\n                eventType = event ? event.type : null;\n\n            if ( typeof contentOption === \"string\" || contentOption.nodeType ||\n                contentOption.jquery ) {\n                return this._open( event, target, contentOption );\n            }\n\n            content = contentOption.call( target[ 0 ], function( response ) {\n\n                // IE may instantly serve a cached response for ajax requests\n                // delay this call to _open so the other call to _open runs first\n                that._delay( function() {\n\n                    // Ignore async response if tooltip was closed already\n                    if ( !target.data( \"ui-tooltip-open\" ) ) {\n                        return;\n                    }\n\n                    // JQuery creates a special event for focusin when it doesn't\n                    // exist natively. To improve performance, the native event\n                    // object is reused and the type is changed. Therefore, we can't\n                    // rely on the type being correct after the event finished\n                    // bubbling, so we set it back to the previous value. (#8740)\n                    if ( event ) {\n                        event.type = eventType;\n                    }\n                    this._open( event, target, response );\n                } );\n            } );\n            if ( content ) {\n                this._open( event, target, content );\n            }\n        },\n\n        _open: function( event, target, content ) {\n            var tooltipData, tooltip, delayedShow, a11yContent,\n                positionOption = $.extend( {}, this.options.position );\n\n            if ( !content ) {\n                return;\n            }\n\n            // Content can be updated multiple times. If the tooltip already\n            // exists, then just update the content and bail.\n            tooltipData = this._find( target );\n            if ( tooltipData ) {\n                tooltipData.tooltip.find( \".ui-tooltip-content\" ).html( content );\n                return;\n            }\n\n            // If we have a title, clear it to prevent the native tooltip\n            // we have to check first to avoid defining a title if none exists\n            // (we don't want to cause an element to start matching [title])\n            //\n            // We use removeAttr only for key events, to allow IE to export the correct\n            // accessible attributes. For mouse events, set to empty string to avoid\n            // native tooltip showing up (happens only when removing inside mouseover).\n            if ( target.is( \"[title]\" ) ) {\n                if ( event && event.type === \"mouseover\" ) {\n                    target.attr( \"title\", \"\" );\n                } else {\n                    target.removeAttr( \"title\" );\n                }\n            }\n\n            tooltipData = this._tooltip( target );\n            tooltip = tooltipData.tooltip;\n            this._addDescribedBy( target, tooltip.attr( \"id\" ) );\n            tooltip.find( \".ui-tooltip-content\" ).html( content );\n\n            // Support: Voiceover on OS X, JAWS on IE <= 9\n            // JAWS announces deletions even when aria-relevant=\"additions\"\n            // Voiceover will sometimes re-read the entire log region's contents from the beginning\n            this.liveRegion.children().hide();\n            a11yContent = $( \"<div>\" ).html( tooltip.find( \".ui-tooltip-content\" ).html() );\n            a11yContent.removeAttr( \"name\" ).find( \"[name]\" ).removeAttr( \"name\" );\n            a11yContent.removeAttr( \"id\" ).find( \"[id]\" ).removeAttr( \"id\" );\n            a11yContent.appendTo( this.liveRegion );\n\n            function position( event ) {\n                positionOption.of = event;\n                if ( tooltip.is( \":hidden\" ) ) {\n                    return;\n                }\n                tooltip.position( positionOption );\n            }\n            if ( this.options.track && event && /^mouse/.test( event.type ) ) {\n                this._on( this.document, {\n                    mousemove: position\n                } );\n\n                // trigger once to override element-relative positioning\n                position( event );\n            } else {\n                tooltip.position( $.extend( {\n                    of: target\n                }, this.options.position ) );\n            }\n\n            tooltip.hide();\n\n            this._show( tooltip, this.options.show );\n\n            // Handle tracking tooltips that are shown with a delay (#8644). As soon\n            // as the tooltip is visible, position the tooltip using the most recent\n            // event.\n            // Adds the check to add the timers only when both delay and track options are set (#14682)\n            if ( this.options.track && this.options.show && this.options.show.delay ) {\n                delayedShow = this.delayedShow = setInterval( function() {\n                    if ( tooltip.is( \":visible\" ) ) {\n                        position( positionOption.of );\n                        clearInterval( delayedShow );\n                    }\n                }, 13 );\n            }\n\n            this._trigger( \"open\", event, { tooltip: tooltip } );\n        },\n\n        _registerCloseHandlers: function( event, target ) {\n            var events = {\n                keyup: function( event ) {\n                    if ( event.keyCode === $.ui.keyCode.ESCAPE ) {\n                        var fakeEvent = $.Event( event );\n                        fakeEvent.currentTarget = target[ 0 ];\n                        this.close( fakeEvent, true );\n                    }\n                }\n            };\n\n            // Only bind remove handler for delegated targets. Non-delegated\n            // tooltips will handle this in destroy.\n            if ( target[ 0 ] !== this.element[ 0 ] ) {\n                events.remove = function() {\n                    var targetElement = this._find( target );\n                    if ( targetElement ) {\n                        this._removeTooltip( targetElement.tooltip );\n                    }\n                };\n            }\n\n            if ( !event || event.type === \"mouseover\" ) {\n                events.mouseleave = \"close\";\n            }\n            if ( !event || event.type === \"focusin\" ) {\n                events.focusout = \"close\";\n            }\n            this._on( true, target, events );\n        },\n\n        close: function( event ) {\n            var tooltip,\n                that = this,\n                target = $( event ? event.currentTarget : this.element ),\n                tooltipData = this._find( target );\n\n            // The tooltip may already be closed\n            if ( !tooltipData ) {\n\n                // We set ui-tooltip-open immediately upon open (in open()), but only set the\n                // additional data once there's actually content to show (in _open()). So even if the\n                // tooltip doesn't have full data, we always remove ui-tooltip-open in case we're in\n                // the period between open() and _open().\n                target.removeData( \"ui-tooltip-open\" );\n                return;\n            }\n\n            tooltip = tooltipData.tooltip;\n\n            // Disabling closes the tooltip, so we need to track when we're closing\n            // to avoid an infinite loop in case the tooltip becomes disabled on close\n            if ( tooltipData.closing ) {\n                return;\n            }\n\n            // Clear the interval for delayed tracking tooltips\n            clearInterval( this.delayedShow );\n\n            // Only set title if we had one before (see comment in _open())\n            // If the title attribute has changed since open(), don't restore\n            if ( target.data( \"ui-tooltip-title\" ) && !target.attr( \"title\" ) ) {\n                target.attr( \"title\", target.data( \"ui-tooltip-title\" ) );\n            }\n\n            this._removeDescribedBy( target );\n\n            tooltipData.hiding = true;\n            tooltip.stop( true );\n            this._hide( tooltip, this.options.hide, function() {\n                that._removeTooltip( $( this ) );\n            } );\n\n            target.removeData( \"ui-tooltip-open\" );\n            this._off( target, \"mouseleave focusout keyup\" );\n\n            // Remove 'remove' binding only on delegated targets\n            if ( target[ 0 ] !== this.element[ 0 ] ) {\n                this._off( target, \"remove\" );\n            }\n            this._off( this.document, \"mousemove\" );\n\n            if ( event && event.type === \"mouseleave\" ) {\n                $.each( this.parents, function( id, parent ) {\n                    $( parent.element ).attr( \"title\", parent.title );\n                    delete that.parents[ id ];\n                } );\n            }\n\n            tooltipData.closing = true;\n            this._trigger( \"close\", event, { tooltip: tooltip } );\n            if ( !tooltipData.hiding ) {\n                tooltipData.closing = false;\n            }\n        },\n\n        _tooltip: function( element ) {\n            var tooltip = $( \"<div>\" ).attr( \"role\", \"tooltip\" ),\n                content = $( \"<div>\" ).appendTo( tooltip ),\n                id = tooltip.uniqueId().attr( \"id\" );\n\n            this._addClass( content, \"ui-tooltip-content\" );\n            this._addClass( tooltip, \"ui-tooltip\", \"ui-widget ui-widget-content\" );\n\n            tooltip.appendTo( this._appendTo( element ) );\n\n            return this.tooltips[ id ] = {\n                element: element,\n                tooltip: tooltip\n            };\n        },\n\n        _find: function( target ) {\n            var id = target.data( \"ui-tooltip-id\" );\n            return id ? this.tooltips[ id ] : null;\n        },\n\n        _removeTooltip: function( tooltip ) {\n\n            // Clear the interval for delayed tracking tooltips\n            clearInterval( this.delayedShow );\n\n            tooltip.remove();\n            delete this.tooltips[ tooltip.attr( \"id\" ) ];\n        },\n\n        _appendTo: function( target ) {\n            var element = target.closest( \".ui-front, dialog\" );\n\n            if ( !element.length ) {\n                element = this.document[ 0 ].body;\n            }\n\n            return element;\n        },\n\n        _destroy: function() {\n            var that = this;\n\n            // Close open tooltips\n            $.each( this.tooltips, function( id, tooltipData ) {\n\n                // Delegate to close method to handle common cleanup\n                var event = $.Event( \"blur\" ),\n                    element = tooltipData.element;\n                event.target = event.currentTarget = element[ 0 ];\n                that.close( event, true );\n\n                // Remove immediately; destroying an open tooltip doesn't use the\n                // hide animation\n                $( \"#\" + id ).remove();\n\n                // Restore the title\n                if ( element.data( \"ui-tooltip-title\" ) ) {\n\n                    // If the title attribute has changed since open(), don't restore\n                    if ( !element.attr( \"title\" ) ) {\n                        element.attr( \"title\", element.data( \"ui-tooltip-title\" ) );\n                    }\n                    element.removeData( \"ui-tooltip-title\" );\n                }\n            } );\n            this.liveRegion.remove();\n        }\n    } );\n\n// DEPRECATED\n// TODO: Switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for tooltipClass option\n        $.widget( \"ui.tooltip\", $.ui.tooltip, {\n            options: {\n                tooltipClass: null\n            },\n            _tooltip: function() {\n                var tooltipData = this._superApply( arguments );\n                if ( this.options.tooltipClass ) {\n                    tooltipData.tooltip.addClass( this.options.tooltipClass );\n                }\n                return tooltipData;\n            }\n        } );\n    }\n\n    return $.ui.tooltip;\n\n} );\n","jquery/ui-modules/widgets/dialog.js":"/*!\n * jQuery UI Dialog 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Dialog\n//>>group: Widgets\n//>>description: Displays customizable dialog windows.\n//>>docs: http://api.jqueryui.com/dialog/\n//>>demos: http://jqueryui.com/dialog/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/dialog.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./button\",\n            \"./draggable\",\n            \"./mouse\",\n            \"./resizable\",\n            \"../focusable\",\n            \"../keycode\",\n            \"../position\",\n            \"../safe-active-element\",\n            \"../safe-blur\",\n            \"../tabbable\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.dialog\", {\n        version: \"1.13.2\",\n        options: {\n            appendTo: \"body\",\n            autoOpen: true,\n            buttons: [],\n            classes: {\n                \"ui-dialog\": \"ui-corner-all\",\n                \"ui-dialog-titlebar\": \"ui-corner-all\"\n            },\n            closeOnEscape: true,\n            closeText: \"Close\",\n            draggable: true,\n            hide: null,\n            height: \"auto\",\n            maxHeight: null,\n            maxWidth: null,\n            minHeight: 150,\n            minWidth: 150,\n            modal: false,\n            position: {\n                my: \"center\",\n                at: \"center\",\n                of: window,\n                collision: \"fit\",\n\n                // Ensure the titlebar is always visible\n                using: function( pos ) {\n                    var topOffset = $( this ).css( pos ).offset().top;\n                    if ( topOffset < 0 ) {\n                        $( this ).css( \"top\", pos.top - topOffset );\n                    }\n                }\n            },\n            resizable: true,\n            show: null,\n            title: null,\n            width: 300,\n\n            // Callbacks\n            beforeClose: null,\n            close: null,\n            drag: null,\n            dragStart: null,\n            dragStop: null,\n            focus: null,\n            open: null,\n            resize: null,\n            resizeStart: null,\n            resizeStop: null\n        },\n\n        sizeRelatedOptions: {\n            buttons: true,\n            height: true,\n            maxHeight: true,\n            maxWidth: true,\n            minHeight: true,\n            minWidth: true,\n            width: true\n        },\n\n        resizableRelatedOptions: {\n            maxHeight: true,\n            maxWidth: true,\n            minHeight: true,\n            minWidth: true\n        },\n\n        _create: function() {\n            this.originalCss = {\n                display: this.element[ 0 ].style.display,\n                width: this.element[ 0 ].style.width,\n                minHeight: this.element[ 0 ].style.minHeight,\n                maxHeight: this.element[ 0 ].style.maxHeight,\n                height: this.element[ 0 ].style.height\n            };\n            this.originalPosition = {\n                parent: this.element.parent(),\n                index: this.element.parent().children().index( this.element )\n            };\n            this.originalTitle = this.element.attr( \"title\" );\n            if ( this.options.title == null && this.originalTitle != null ) {\n                this.options.title = this.originalTitle;\n            }\n\n            // Dialogs can't be disabled\n            if ( this.options.disabled ) {\n                this.options.disabled = false;\n            }\n\n            this._createWrapper();\n\n            this.element\n                .show()\n                .removeAttr( \"title\" )\n                .appendTo( this.uiDialog );\n\n            this._addClass( \"ui-dialog-content\", \"ui-widget-content\" );\n\n            this._createTitlebar();\n            this._createButtonPane();\n\n            if ( this.options.draggable && $.fn.draggable ) {\n                this._makeDraggable();\n            }\n            if ( this.options.resizable && $.fn.resizable ) {\n                this._makeResizable();\n            }\n\n            this._isOpen = false;\n\n            this._trackFocus();\n        },\n\n        _init: function() {\n            if ( this.options.autoOpen ) {\n                this.open();\n            }\n        },\n\n        _appendTo: function() {\n            var element = this.options.appendTo;\n            if ( element && ( element.jquery || element.nodeType ) ) {\n                return $( element );\n            }\n            return this.document.find( element || \"body\" ).eq( 0 );\n        },\n\n        _destroy: function() {\n            var next,\n                originalPosition = this.originalPosition;\n\n            this._untrackInstance();\n            this._destroyOverlay();\n\n            this.element\n                .removeUniqueId()\n                .css( this.originalCss )\n\n                // Without detaching first, the following becomes really slow\n                .detach();\n\n            this.uiDialog.remove();\n\n            if ( this.originalTitle ) {\n                this.element.attr( \"title\", this.originalTitle );\n            }\n\n            next = originalPosition.parent.children().eq( originalPosition.index );\n\n            // Don't try to place the dialog next to itself (#8613)\n            if ( next.length && next[ 0 ] !== this.element[ 0 ] ) {\n                next.before( this.element );\n            } else {\n                originalPosition.parent.append( this.element );\n            }\n        },\n\n        widget: function() {\n            return this.uiDialog;\n        },\n\n        disable: $.noop,\n        enable: $.noop,\n\n        close: function( event ) {\n            var that = this;\n\n            if ( !this._isOpen || this._trigger( \"beforeClose\", event ) === false ) {\n                return;\n            }\n\n            this._isOpen = false;\n            this._focusedElement = null;\n            this._destroyOverlay();\n            this._untrackInstance();\n\n            if ( !this.opener.filter( \":focusable\" ).trigger( \"focus\" ).length ) {\n\n                // Hiding a focused element doesn't trigger blur in WebKit\n                // so in case we have nothing to focus on, explicitly blur the active element\n                // https://bugs.webkit.org/show_bug.cgi?id=47182\n                $.ui.safeBlur( $.ui.safeActiveElement( this.document[ 0 ] ) );\n            }\n\n            this._hide( this.uiDialog, this.options.hide, function() {\n                that._trigger( \"close\", event );\n            } );\n        },\n\n        isOpen: function() {\n            return this._isOpen;\n        },\n\n        moveToTop: function() {\n            this._moveToTop();\n        },\n\n        _moveToTop: function( event, silent ) {\n            var moved = false,\n                zIndices = this.uiDialog.siblings( \".ui-front:visible\" ).map( function() {\n                    return +$( this ).css( \"z-index\" );\n                } ).get(),\n                zIndexMax = Math.max.apply( null, zIndices );\n\n            if ( zIndexMax >= +this.uiDialog.css( \"z-index\" ) ) {\n                this.uiDialog.css( \"z-index\", zIndexMax + 1 );\n                moved = true;\n            }\n\n            if ( moved && !silent ) {\n                this._trigger( \"focus\", event );\n            }\n            return moved;\n        },\n\n        open: function() {\n            var that = this;\n            if ( this._isOpen ) {\n                if ( this._moveToTop() ) {\n                    this._focusTabbable();\n                }\n                return;\n            }\n\n            this._isOpen = true;\n            this.opener = $( $.ui.safeActiveElement( this.document[ 0 ] ) );\n\n            this._size();\n            this._position();\n            this._createOverlay();\n            this._moveToTop( null, true );\n\n            // Ensure the overlay is moved to the top with the dialog, but only when\n            // opening. The overlay shouldn't move after the dialog is open so that\n            // modeless dialogs opened after the modal dialog stack properly.\n            if ( this.overlay ) {\n                this.overlay.css( \"z-index\", this.uiDialog.css( \"z-index\" ) - 1 );\n            }\n\n            this._show( this.uiDialog, this.options.show, function() {\n                that._focusTabbable();\n                that._trigger( \"focus\" );\n            } );\n\n            // Track the dialog immediately upon opening in case a focus event\n            // somehow occurs outside of the dialog before an element inside the\n            // dialog is focused (#10152)\n            this._makeFocusTarget();\n\n            this._trigger( \"open\" );\n        },\n\n        _focusTabbable: function() {\n\n            // Set focus to the first match:\n            // 1. An element that was focused previously\n            // 2. First element inside the dialog matching [autofocus]\n            // 3. Tabbable element inside the content element\n            // 4. Tabbable element inside the buttonpane\n            // 5. The close button\n            // 6. The dialog itself\n            var hasFocus = this._focusedElement;\n            if ( !hasFocus ) {\n                hasFocus = this.element.find( \"[autofocus]\" );\n            }\n            if ( !hasFocus.length ) {\n                hasFocus = this.element.find( \":tabbable\" );\n            }\n            if ( !hasFocus.length ) {\n                hasFocus = this.uiDialogButtonPane.find( \":tabbable\" );\n            }\n            if ( !hasFocus.length ) {\n                hasFocus = this.uiDialogTitlebarClose.filter( \":tabbable\" );\n            }\n            if ( !hasFocus.length ) {\n                hasFocus = this.uiDialog;\n            }\n            hasFocus.eq( 0 ).trigger( \"focus\" );\n        },\n\n        _restoreTabbableFocus: function() {\n            var activeElement = $.ui.safeActiveElement( this.document[ 0 ] ),\n                isActive = this.uiDialog[ 0 ] === activeElement ||\n                    $.contains( this.uiDialog[ 0 ], activeElement );\n            if ( !isActive ) {\n                this._focusTabbable();\n            }\n        },\n\n        _keepFocus: function( event ) {\n            event.preventDefault();\n            this._restoreTabbableFocus();\n\n            // support: IE\n            // IE <= 8 doesn't prevent moving focus even with event.preventDefault()\n            // so we check again later\n            this._delay( this._restoreTabbableFocus );\n        },\n\n        _createWrapper: function() {\n            this.uiDialog = $( \"<div>\" )\n                .hide()\n                .attr( {\n\n                    // Setting tabIndex makes the div focusable\n                    tabIndex: -1,\n                    role: \"dialog\"\n                } )\n                .appendTo( this._appendTo() );\n\n            this._addClass( this.uiDialog, \"ui-dialog\", \"ui-widget ui-widget-content ui-front\" );\n            this._on( this.uiDialog, {\n                keydown: function( event ) {\n                    if ( this.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode &&\n                        event.keyCode === $.ui.keyCode.ESCAPE ) {\n                        event.preventDefault();\n                        this.close( event );\n                        return;\n                    }\n\n                    // Prevent tabbing out of dialogs\n                    if ( event.keyCode !== $.ui.keyCode.TAB || event.isDefaultPrevented() ) {\n                        return;\n                    }\n                    var tabbables = this.uiDialog.find( \":tabbable\" ),\n                        first = tabbables.first(),\n                        last = tabbables.last();\n\n                    if ( ( event.target === last[ 0 ] || event.target === this.uiDialog[ 0 ] ) &&\n                        !event.shiftKey ) {\n                        this._delay( function() {\n                            first.trigger( \"focus\" );\n                        } );\n                        event.preventDefault();\n                    } else if ( ( event.target === first[ 0 ] ||\n                        event.target === this.uiDialog[ 0 ] ) && event.shiftKey ) {\n                        this._delay( function() {\n                            last.trigger( \"focus\" );\n                        } );\n                        event.preventDefault();\n                    }\n                },\n                mousedown: function( event ) {\n                    if ( this._moveToTop( event ) ) {\n                        this._focusTabbable();\n                    }\n                }\n            } );\n\n            // We assume that any existing aria-describedby attribute means\n            // that the dialog content is marked up properly\n            // otherwise we brute force the content as the description\n            if ( !this.element.find( \"[aria-describedby]\" ).length ) {\n                this.uiDialog.attr( {\n                    \"aria-describedby\": this.element.uniqueId().attr( \"id\" )\n                } );\n            }\n        },\n\n        _createTitlebar: function() {\n            var uiDialogTitle;\n\n            this.uiDialogTitlebar = $( \"<div>\" );\n            this._addClass( this.uiDialogTitlebar,\n                \"ui-dialog-titlebar\", \"ui-widget-header ui-helper-clearfix\" );\n            this._on( this.uiDialogTitlebar, {\n                mousedown: function( event ) {\n\n                    // Don't prevent click on close button (#8838)\n                    // Focusing a dialog that is partially scrolled out of view\n                    // causes the browser to scroll it into view, preventing the click event\n                    if ( !$( event.target ).closest( \".ui-dialog-titlebar-close\" ) ) {\n\n                        // Dialog isn't getting focus when dragging (#8063)\n                        this.uiDialog.trigger( \"focus\" );\n                    }\n                }\n            } );\n\n            // Support: IE\n            // Use type=\"button\" to prevent enter keypresses in textboxes from closing the\n            // dialog in IE (#9312)\n            this.uiDialogTitlebarClose = $( \"<button type='button'></button>\" )\n                .button( {\n                    label: $( \"<a>\" ).text( this.options.closeText ).html(),\n                    icon: \"ui-icon-closethick\",\n                    showLabel: false\n                } )\n                .appendTo( this.uiDialogTitlebar );\n\n            this._addClass( this.uiDialogTitlebarClose, \"ui-dialog-titlebar-close\" );\n            this._on( this.uiDialogTitlebarClose, {\n                click: function( event ) {\n                    event.preventDefault();\n                    this.close( event );\n                }\n            } );\n\n            uiDialogTitle = $( \"<span>\" ).uniqueId().prependTo( this.uiDialogTitlebar );\n            this._addClass( uiDialogTitle, \"ui-dialog-title\" );\n            this._title( uiDialogTitle );\n\n            this.uiDialogTitlebar.prependTo( this.uiDialog );\n\n            this.uiDialog.attr( {\n                \"aria-labelledby\": uiDialogTitle.attr( \"id\" )\n            } );\n        },\n\n        _title: function( title ) {\n            if ( this.options.title ) {\n                title.text( this.options.title );\n            } else {\n                title.html( \"&#160;\" );\n            }\n        },\n\n        _createButtonPane: function() {\n            this.uiDialogButtonPane = $( \"<div>\" );\n            this._addClass( this.uiDialogButtonPane, \"ui-dialog-buttonpane\",\n                \"ui-widget-content ui-helper-clearfix\" );\n\n            this.uiButtonSet = $( \"<div>\" )\n                .appendTo( this.uiDialogButtonPane );\n            this._addClass( this.uiButtonSet, \"ui-dialog-buttonset\" );\n\n            this._createButtons();\n        },\n\n        _createButtons: function() {\n            var that = this,\n                buttons = this.options.buttons;\n\n            // If we already have a button pane, remove it\n            this.uiDialogButtonPane.remove();\n            this.uiButtonSet.empty();\n\n            if ( $.isEmptyObject( buttons ) || ( Array.isArray( buttons ) && !buttons.length ) ) {\n                this._removeClass( this.uiDialog, \"ui-dialog-buttons\" );\n                return;\n            }\n\n            $.each( buttons, function( name, props ) {\n                var click, buttonOptions;\n                props = typeof props === \"function\" ?\n                    { click: props, text: name } :\n                    props;\n\n                // Default to a non-submitting button\n                props = $.extend( { type: \"button\" }, props );\n\n                // Change the context for the click callback to be the main element\n                click = props.click;\n                buttonOptions = {\n                    icon: props.icon,\n                    iconPosition: props.iconPosition,\n                    showLabel: props.showLabel,\n\n                    // Deprecated options\n                    icons: props.icons,\n                    text: props.text\n                };\n\n                delete props.click;\n                delete props.icon;\n                delete props.iconPosition;\n                delete props.showLabel;\n\n                // Deprecated options\n                delete props.icons;\n                if ( typeof props.text === \"boolean\" ) {\n                    delete props.text;\n                }\n\n                $( \"<button></button>\", props )\n                    .button( buttonOptions )\n                    .appendTo( that.uiButtonSet )\n                    .on( \"click\", function() {\n                        click.apply( that.element[ 0 ], arguments );\n                    } );\n            } );\n            this._addClass( this.uiDialog, \"ui-dialog-buttons\" );\n            this.uiDialogButtonPane.appendTo( this.uiDialog );\n        },\n\n        _makeDraggable: function() {\n            var that = this,\n                options = this.options;\n\n            function filteredUi( ui ) {\n                return {\n                    position: ui.position,\n                    offset: ui.offset\n                };\n            }\n\n            this.uiDialog.draggable( {\n                cancel: \".ui-dialog-content, .ui-dialog-titlebar-close\",\n                handle: \".ui-dialog-titlebar\",\n                containment: \"document\",\n                start: function( event, ui ) {\n                    that._addClass( $( this ), \"ui-dialog-dragging\" );\n                    that._blockFrames();\n                    that._trigger( \"dragStart\", event, filteredUi( ui ) );\n                },\n                drag: function( event, ui ) {\n                    that._trigger( \"drag\", event, filteredUi( ui ) );\n                },\n                stop: function( event, ui ) {\n                    var left = ui.offset.left - that.document.scrollLeft(),\n                        top = ui.offset.top - that.document.scrollTop();\n\n                    options.position = {\n                        my: \"left top\",\n                        at: \"left\" + ( left >= 0 ? \"+\" : \"\" ) + left + \" \" +\n                            \"top\" + ( top >= 0 ? \"+\" : \"\" ) + top,\n                        of: that.window\n                    };\n                    that._removeClass( $( this ), \"ui-dialog-dragging\" );\n                    that._unblockFrames();\n                    that._trigger( \"dragStop\", event, filteredUi( ui ) );\n                }\n            } );\n        },\n\n        _makeResizable: function() {\n            var that = this,\n                options = this.options,\n                handles = options.resizable,\n\n                // .ui-resizable has position: relative defined in the stylesheet\n                // but dialogs have to use absolute or fixed positioning\n                position = this.uiDialog.css( \"position\" ),\n                resizeHandles = typeof handles === \"string\" ?\n                    handles :\n                    \"n,e,s,w,se,sw,ne,nw\";\n\n            function filteredUi( ui ) {\n                return {\n                    originalPosition: ui.originalPosition,\n                    originalSize: ui.originalSize,\n                    position: ui.position,\n                    size: ui.size\n                };\n            }\n\n            this.uiDialog.resizable( {\n                cancel: \".ui-dialog-content\",\n                containment: \"document\",\n                alsoResize: this.element,\n                maxWidth: options.maxWidth,\n                maxHeight: options.maxHeight,\n                minWidth: options.minWidth,\n                minHeight: this._minHeight(),\n                handles: resizeHandles,\n                start: function( event, ui ) {\n                    that._addClass( $( this ), \"ui-dialog-resizing\" );\n                    that._blockFrames();\n                    that._trigger( \"resizeStart\", event, filteredUi( ui ) );\n                },\n                resize: function( event, ui ) {\n                    that._trigger( \"resize\", event, filteredUi( ui ) );\n                },\n                stop: function( event, ui ) {\n                    var offset = that.uiDialog.offset(),\n                        left = offset.left - that.document.scrollLeft(),\n                        top = offset.top - that.document.scrollTop();\n\n                    options.height = that.uiDialog.height();\n                    options.width = that.uiDialog.width();\n                    options.position = {\n                        my: \"left top\",\n                        at: \"left\" + ( left >= 0 ? \"+\" : \"\" ) + left + \" \" +\n                            \"top\" + ( top >= 0 ? \"+\" : \"\" ) + top,\n                        of: that.window\n                    };\n                    that._removeClass( $( this ), \"ui-dialog-resizing\" );\n                    that._unblockFrames();\n                    that._trigger( \"resizeStop\", event, filteredUi( ui ) );\n                }\n            } )\n                .css( \"position\", position );\n        },\n\n        _trackFocus: function() {\n            this._on( this.widget(), {\n                focusin: function( event ) {\n                    this._makeFocusTarget();\n                    this._focusedElement = $( event.target );\n                }\n            } );\n        },\n\n        _makeFocusTarget: function() {\n            this._untrackInstance();\n            this._trackingInstances().unshift( this );\n        },\n\n        _untrackInstance: function() {\n            var instances = this._trackingInstances(),\n                exists = $.inArray( this, instances );\n            if ( exists !== -1 ) {\n                instances.splice( exists, 1 );\n            }\n        },\n\n        _trackingInstances: function() {\n            var instances = this.document.data( \"ui-dialog-instances\" );\n            if ( !instances ) {\n                instances = [];\n                this.document.data( \"ui-dialog-instances\", instances );\n            }\n            return instances;\n        },\n\n        _minHeight: function() {\n            var options = this.options;\n\n            return options.height === \"auto\" ?\n                options.minHeight :\n                Math.min( options.minHeight, options.height );\n        },\n\n        _position: function() {\n\n            // Need to show the dialog to get the actual offset in the position plugin\n            var isVisible = this.uiDialog.is( \":visible\" );\n            if ( !isVisible ) {\n                this.uiDialog.show();\n            }\n            this.uiDialog.position( this.options.position );\n            if ( !isVisible ) {\n                this.uiDialog.hide();\n            }\n        },\n\n        _setOptions: function( options ) {\n            var that = this,\n                resize = false,\n                resizableOptions = {};\n\n            $.each( options, function( key, value ) {\n                that._setOption( key, value );\n\n                if ( key in that.sizeRelatedOptions ) {\n                    resize = true;\n                }\n                if ( key in that.resizableRelatedOptions ) {\n                    resizableOptions[ key ] = value;\n                }\n            } );\n\n            if ( resize ) {\n                this._size();\n                this._position();\n            }\n            if ( this.uiDialog.is( \":data(ui-resizable)\" ) ) {\n                this.uiDialog.resizable( \"option\", resizableOptions );\n            }\n        },\n\n        _setOption: function( key, value ) {\n            var isDraggable, isResizable,\n                uiDialog = this.uiDialog;\n\n            if ( key === \"disabled\" ) {\n                return;\n            }\n\n            this._super( key, value );\n\n            if ( key === \"appendTo\" ) {\n                this.uiDialog.appendTo( this._appendTo() );\n            }\n\n            if ( key === \"buttons\" ) {\n                this._createButtons();\n            }\n\n            if ( key === \"closeText\" ) {\n                this.uiDialogTitlebarClose.button( {\n\n                    // Ensure that we always pass a string\n                    label: $( \"<a>\" ).text( \"\" + this.options.closeText ).html()\n                } );\n            }\n\n            if ( key === \"draggable\" ) {\n                isDraggable = uiDialog.is( \":data(ui-draggable)\" );\n                if ( isDraggable && !value ) {\n                    uiDialog.draggable( \"destroy\" );\n                }\n\n                if ( !isDraggable && value ) {\n                    this._makeDraggable();\n                }\n            }\n\n            if ( key === \"position\" ) {\n                this._position();\n            }\n\n            if ( key === \"resizable\" ) {\n\n                // currently resizable, becoming non-resizable\n                isResizable = uiDialog.is( \":data(ui-resizable)\" );\n                if ( isResizable && !value ) {\n                    uiDialog.resizable( \"destroy\" );\n                }\n\n                // Currently resizable, changing handles\n                if ( isResizable && typeof value === \"string\" ) {\n                    uiDialog.resizable( \"option\", \"handles\", value );\n                }\n\n                // Currently non-resizable, becoming resizable\n                if ( !isResizable && value !== false ) {\n                    this._makeResizable();\n                }\n            }\n\n            if ( key === \"title\" ) {\n                this._title( this.uiDialogTitlebar.find( \".ui-dialog-title\" ) );\n            }\n        },\n\n        _size: function() {\n\n            // If the user has resized the dialog, the .ui-dialog and .ui-dialog-content\n            // divs will both have width and height set, so we need to reset them\n            var nonContentHeight, minContentHeight, maxContentHeight,\n                options = this.options;\n\n            // Reset content sizing\n            this.element.show().css( {\n                width: \"auto\",\n                minHeight: 0,\n                maxHeight: \"none\",\n                height: 0\n            } );\n\n            if ( options.minWidth > options.width ) {\n                options.width = options.minWidth;\n            }\n\n            // Reset wrapper sizing\n            // determine the height of all the non-content elements\n            nonContentHeight = this.uiDialog.css( {\n                height: \"auto\",\n                width: options.width\n            } )\n                .outerHeight();\n            minContentHeight = Math.max( 0, options.minHeight - nonContentHeight );\n            maxContentHeight = typeof options.maxHeight === \"number\" ?\n                Math.max( 0, options.maxHeight - nonContentHeight ) :\n                \"none\";\n\n            if ( options.height === \"auto\" ) {\n                this.element.css( {\n                    minHeight: minContentHeight,\n                    maxHeight: maxContentHeight,\n                    height: \"auto\"\n                } );\n            } else {\n                this.element.height( Math.max( 0, options.height - nonContentHeight ) );\n            }\n\n            if ( this.uiDialog.is( \":data(ui-resizable)\" ) ) {\n                this.uiDialog.resizable( \"option\", \"minHeight\", this._minHeight() );\n            }\n        },\n\n        _blockFrames: function() {\n            this.iframeBlocks = this.document.find( \"iframe\" ).map( function() {\n                var iframe = $( this );\n\n                return $( \"<div>\" )\n                    .css( {\n                        position: \"absolute\",\n                        width: iframe.outerWidth(),\n                        height: iframe.outerHeight()\n                    } )\n                    .appendTo( iframe.parent() )\n                    .offset( iframe.offset() )[ 0 ];\n            } );\n        },\n\n        _unblockFrames: function() {\n            if ( this.iframeBlocks ) {\n                this.iframeBlocks.remove();\n                delete this.iframeBlocks;\n            }\n        },\n\n        _allowInteraction: function( event ) {\n            if ( $( event.target ).closest( \".ui-dialog\" ).length ) {\n                return true;\n            }\n\n            // TODO: Remove hack when datepicker implements\n            // the .ui-front logic (#8989)\n            return !!$( event.target ).closest( \".ui-datepicker\" ).length;\n        },\n\n        _createOverlay: function() {\n            if ( !this.options.modal ) {\n                return;\n            }\n\n            var jqMinor = $.fn.jquery.substring( 0, 4 );\n\n            // We use a delay in case the overlay is created from an\n            // event that we're going to be cancelling (#2804)\n            var isOpening = true;\n            this._delay( function() {\n                isOpening = false;\n            } );\n\n            if ( !this.document.data( \"ui-dialog-overlays\" ) ) {\n\n                // Prevent use of anchors and inputs\n                // This doesn't use `_on()` because it is a shared event handler\n                // across all open modal dialogs.\n                this.document.on( \"focusin.ui-dialog\", function( event ) {\n                    if ( isOpening ) {\n                        return;\n                    }\n\n                    var instance = this._trackingInstances()[ 0 ];\n                    if ( !instance._allowInteraction( event ) ) {\n                        event.preventDefault();\n                        instance._focusTabbable();\n\n                        // Support: jQuery >=3.4 <3.6 only\n                        // Focus re-triggering in jQuery 3.4/3.5 makes the original element\n                        // have its focus event propagated last, breaking the re-targeting.\n                        // Trigger focus in a delay in addition if needed to avoid the issue\n                        // See https://github.com/jquery/jquery/issues/4382\n                        if ( jqMinor === \"3.4.\" || jqMinor === \"3.5.\" ) {\n                            instance._delay( instance._restoreTabbableFocus );\n                        }\n                    }\n                }.bind( this ) );\n            }\n\n            this.overlay = $( \"<div>\" )\n                .appendTo( this._appendTo() );\n\n            this._addClass( this.overlay, null, \"ui-widget-overlay ui-front\" );\n            this._on( this.overlay, {\n                mousedown: \"_keepFocus\"\n            } );\n            this.document.data( \"ui-dialog-overlays\",\n                ( this.document.data( \"ui-dialog-overlays\" ) || 0 ) + 1 );\n        },\n\n        _destroyOverlay: function() {\n            if ( !this.options.modal ) {\n                return;\n            }\n\n            if ( this.overlay ) {\n                var overlays = this.document.data( \"ui-dialog-overlays\" ) - 1;\n\n                if ( !overlays ) {\n                    this.document.off( \"focusin.ui-dialog\" );\n                    this.document.removeData( \"ui-dialog-overlays\" );\n                } else {\n                    this.document.data( \"ui-dialog-overlays\", overlays );\n                }\n\n                this.overlay.remove();\n                this.overlay = null;\n            }\n        }\n    } );\n\n// DEPRECATED\n// TODO: switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for dialogClass option\n        $.widget( \"ui.dialog\", $.ui.dialog, {\n            options: {\n                dialogClass: \"\"\n            },\n            _createWrapper: function() {\n                this._super();\n                this.uiDialog.addClass( this.options.dialogClass );\n            },\n            _setOption: function( key, value ) {\n                if ( key === \"dialogClass\" ) {\n                    this.uiDialog\n                        .removeClass( this.options.dialogClass )\n                        .addClass( value );\n                }\n                this._superApply( arguments );\n            }\n        } );\n    }\n\n    return $.ui.dialog;\n\n} );\n","jquery/ui-modules/widgets/tabs.js":"/*!\n * jQuery UI Tabs 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Tabs\n//>>group: Widgets\n//>>description: Transforms a set of container elements into a tab structure.\n//>>docs: http://api.jqueryui.com/tabs/\n//>>demos: http://jqueryui.com/tabs/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/tabs.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../keycode\",\n            \"../safe-active-element\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.tabs\", {\n        version: \"1.13.2\",\n        delay: 300,\n        options: {\n            active: null,\n            classes: {\n                \"ui-tabs\": \"ui-corner-all\",\n                \"ui-tabs-nav\": \"ui-corner-all\",\n                \"ui-tabs-panel\": \"ui-corner-bottom\",\n                \"ui-tabs-tab\": \"ui-corner-top\"\n            },\n            collapsible: false,\n            event: \"click\",\n            heightStyle: \"content\",\n            hide: null,\n            show: null,\n\n            // Callbacks\n            activate: null,\n            beforeActivate: null,\n            beforeLoad: null,\n            load: null\n        },\n\n        _isLocal: ( function() {\n            var rhash = /#.*$/;\n\n            return function( anchor ) {\n                var anchorUrl, locationUrl;\n\n                anchorUrl = anchor.href.replace( rhash, \"\" );\n                locationUrl = location.href.replace( rhash, \"\" );\n\n                // Decoding may throw an error if the URL isn't UTF-8 (#9518)\n                try {\n                    anchorUrl = decodeURIComponent( anchorUrl );\n                } catch ( error ) {}\n                try {\n                    locationUrl = decodeURIComponent( locationUrl );\n                } catch ( error ) {}\n\n                return anchor.hash.length > 1 && anchorUrl === locationUrl;\n            };\n        } )(),\n\n        _create: function() {\n            var that = this,\n                options = this.options;\n\n            this.running = false;\n\n            this._addClass( \"ui-tabs\", \"ui-widget ui-widget-content\" );\n            this._toggleClass( \"ui-tabs-collapsible\", null, options.collapsible );\n\n            this._processTabs();\n            options.active = this._initialActive();\n\n            // Take disabling tabs via class attribute from HTML\n            // into account and update option properly.\n            if ( Array.isArray( options.disabled ) ) {\n                options.disabled = $.uniqueSort( options.disabled.concat(\n                    $.map( this.tabs.filter( \".ui-state-disabled\" ), function( li ) {\n                        return that.tabs.index( li );\n                    } )\n                ) ).sort();\n            }\n\n            // Check for length avoids error when initializing empty list\n            if ( this.options.active !== false && this.anchors.length ) {\n                this.active = this._findActive( options.active );\n            } else {\n                this.active = $();\n            }\n\n            this._refresh();\n\n            if ( this.active.length ) {\n                this.load( options.active );\n            }\n        },\n\n        _initialActive: function() {\n            var active = this.options.active,\n                collapsible = this.options.collapsible,\n                locationHash = location.hash.substring( 1 );\n\n            if ( active === null ) {\n\n                // check the fragment identifier in the URL\n                if ( locationHash ) {\n                    this.tabs.each( function( i, tab ) {\n                        if ( $( tab ).attr( \"aria-controls\" ) === locationHash ) {\n                            active = i;\n                            return false;\n                        }\n                    } );\n                }\n\n                // Check for a tab marked active via a class\n                if ( active === null ) {\n                    active = this.tabs.index( this.tabs.filter( \".ui-tabs-active\" ) );\n                }\n\n                // No active tab, set to false\n                if ( active === null || active === -1 ) {\n                    active = this.tabs.length ? 0 : false;\n                }\n            }\n\n            // Handle numbers: negative, out of range\n            if ( active !== false ) {\n                active = this.tabs.index( this.tabs.eq( active ) );\n                if ( active === -1 ) {\n                    active = collapsible ? false : 0;\n                }\n            }\n\n            // Don't allow collapsible: false and active: false\n            if ( !collapsible && active === false && this.anchors.length ) {\n                active = 0;\n            }\n\n            return active;\n        },\n\n        _getCreateEventData: function() {\n            return {\n                tab: this.active,\n                panel: !this.active.length ? $() : this._getPanelForTab( this.active )\n            };\n        },\n\n        _tabKeydown: function( event ) {\n            var focusedTab = $( $.ui.safeActiveElement( this.document[ 0 ] ) ).closest( \"li\" ),\n                selectedIndex = this.tabs.index( focusedTab ),\n                goingForward = true;\n\n            if ( this._handlePageNav( event ) ) {\n                return;\n            }\n\n            switch ( event.keyCode ) {\n                case $.ui.keyCode.RIGHT:\n                case $.ui.keyCode.DOWN:\n                    selectedIndex++;\n                    break;\n                case $.ui.keyCode.UP:\n                case $.ui.keyCode.LEFT:\n                    goingForward = false;\n                    selectedIndex--;\n                    break;\n                case $.ui.keyCode.END:\n                    selectedIndex = this.anchors.length - 1;\n                    break;\n                case $.ui.keyCode.HOME:\n                    selectedIndex = 0;\n                    break;\n                case $.ui.keyCode.SPACE:\n\n                    // Activate only, no collapsing\n                    event.preventDefault();\n                    clearTimeout( this.activating );\n                    this._activate( selectedIndex );\n                    return;\n                case $.ui.keyCode.ENTER:\n\n                    // Toggle (cancel delayed activation, allow collapsing)\n                    event.preventDefault();\n                    clearTimeout( this.activating );\n\n                    // Determine if we should collapse or activate\n                    this._activate( selectedIndex === this.options.active ? false : selectedIndex );\n                    return;\n                default:\n                    return;\n            }\n\n            // Focus the appropriate tab, based on which key was pressed\n            event.preventDefault();\n            clearTimeout( this.activating );\n            selectedIndex = this._focusNextTab( selectedIndex, goingForward );\n\n            // Navigating with control/command key will prevent automatic activation\n            if ( !event.ctrlKey && !event.metaKey ) {\n\n                // Update aria-selected immediately so that AT think the tab is already selected.\n                // Otherwise AT may confuse the user by stating that they need to activate the tab,\n                // but the tab will already be activated by the time the announcement finishes.\n                focusedTab.attr( \"aria-selected\", \"false\" );\n                this.tabs.eq( selectedIndex ).attr( \"aria-selected\", \"true\" );\n\n                this.activating = this._delay( function() {\n                    this.option( \"active\", selectedIndex );\n                }, this.delay );\n            }\n        },\n\n        _panelKeydown: function( event ) {\n            if ( this._handlePageNav( event ) ) {\n                return;\n            }\n\n            // Ctrl+up moves focus to the current tab\n            if ( event.ctrlKey && event.keyCode === $.ui.keyCode.UP ) {\n                event.preventDefault();\n                this.active.trigger( \"focus\" );\n            }\n        },\n\n        // Alt+page up/down moves focus to the previous/next tab (and activates)\n        _handlePageNav: function( event ) {\n            if ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP ) {\n                this._activate( this._focusNextTab( this.options.active - 1, false ) );\n                return true;\n            }\n            if ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN ) {\n                this._activate( this._focusNextTab( this.options.active + 1, true ) );\n                return true;\n            }\n        },\n\n        _findNextTab: function( index, goingForward ) {\n            var lastTabIndex = this.tabs.length - 1;\n\n            function constrain() {\n                if ( index > lastTabIndex ) {\n                    index = 0;\n                }\n                if ( index < 0 ) {\n                    index = lastTabIndex;\n                }\n                return index;\n            }\n\n            while ( $.inArray( constrain(), this.options.disabled ) !== -1 ) {\n                index = goingForward ? index + 1 : index - 1;\n            }\n\n            return index;\n        },\n\n        _focusNextTab: function( index, goingForward ) {\n            index = this._findNextTab( index, goingForward );\n            this.tabs.eq( index ).trigger( \"focus\" );\n            return index;\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"active\" ) {\n\n                // _activate() will handle invalid values and update this.options\n                this._activate( value );\n                return;\n            }\n\n            this._super( key, value );\n\n            if ( key === \"collapsible\" ) {\n                this._toggleClass( \"ui-tabs-collapsible\", null, value );\n\n                // Setting collapsible: false while collapsed; open first panel\n                if ( !value && this.options.active === false ) {\n                    this._activate( 0 );\n                }\n            }\n\n            if ( key === \"event\" ) {\n                this._setupEvents( value );\n            }\n\n            if ( key === \"heightStyle\" ) {\n                this._setupHeightStyle( value );\n            }\n        },\n\n        _sanitizeSelector: function( hash ) {\n            return hash ? hash.replace( /[!\"$%&'()*+,.\\/:;<=>?@\\[\\]\\^`{|}~]/g, \"\\\\$&\" ) : \"\";\n        },\n\n        refresh: function() {\n            var options = this.options,\n                lis = this.tablist.children( \":has(a[href])\" );\n\n            // Get disabled tabs from class attribute from HTML\n            // this will get converted to a boolean if needed in _refresh()\n            options.disabled = $.map( lis.filter( \".ui-state-disabled\" ), function( tab ) {\n                return lis.index( tab );\n            } );\n\n            this._processTabs();\n\n            // Was collapsed or no tabs\n            if ( options.active === false || !this.anchors.length ) {\n                options.active = false;\n                this.active = $();\n\n                // was active, but active tab is gone\n            } else if ( this.active.length && !$.contains( this.tablist[ 0 ], this.active[ 0 ] ) ) {\n\n                // all remaining tabs are disabled\n                if ( this.tabs.length === options.disabled.length ) {\n                    options.active = false;\n                    this.active = $();\n\n                    // activate previous tab\n                } else {\n                    this._activate( this._findNextTab( Math.max( 0, options.active - 1 ), false ) );\n                }\n\n                // was active, active tab still exists\n            } else {\n\n                // make sure active index is correct\n                options.active = this.tabs.index( this.active );\n            }\n\n            this._refresh();\n        },\n\n        _refresh: function() {\n            this._setOptionDisabled( this.options.disabled );\n            this._setupEvents( this.options.event );\n            this._setupHeightStyle( this.options.heightStyle );\n\n            this.tabs.not( this.active ).attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\",\n                tabIndex: -1\n            } );\n            this.panels.not( this._getPanelForTab( this.active ) )\n                .hide()\n                .attr( {\n                    \"aria-hidden\": \"true\"\n                } );\n\n            // Make sure one tab is in the tab order\n            if ( !this.active.length ) {\n                this.tabs.eq( 0 ).attr( \"tabIndex\", 0 );\n            } else {\n                this.active\n                    .attr( {\n                        \"aria-selected\": \"true\",\n                        \"aria-expanded\": \"true\",\n                        tabIndex: 0\n                    } );\n                this._addClass( this.active, \"ui-tabs-active\", \"ui-state-active\" );\n                this._getPanelForTab( this.active )\n                    .show()\n                    .attr( {\n                        \"aria-hidden\": \"false\"\n                    } );\n            }\n        },\n\n        _processTabs: function() {\n            var that = this,\n                prevTabs = this.tabs,\n                prevAnchors = this.anchors,\n                prevPanels = this.panels;\n\n            this.tablist = this._getList().attr( \"role\", \"tablist\" );\n            this._addClass( this.tablist, \"ui-tabs-nav\",\n                \"ui-helper-reset ui-helper-clearfix ui-widget-header\" );\n\n            // Prevent users from focusing disabled tabs via click\n            this.tablist\n                .on( \"mousedown\" + this.eventNamespace, \"> li\", function( event ) {\n                    if ( $( this ).is( \".ui-state-disabled\" ) ) {\n                        event.preventDefault();\n                    }\n                } )\n\n                // Support: IE <9\n                // Preventing the default action in mousedown doesn't prevent IE\n                // from focusing the element, so if the anchor gets focused, blur.\n                // We don't have to worry about focusing the previously focused\n                // element since clicking on a non-focusable element should focus\n                // the body anyway.\n                .on( \"focus\" + this.eventNamespace, \".ui-tabs-anchor\", function() {\n                    if ( $( this ).closest( \"li\" ).is( \".ui-state-disabled\" ) ) {\n                        this.blur();\n                    }\n                } );\n\n            this.tabs = this.tablist.find( \"> li:has(a[href])\" )\n                .attr( {\n                    role: \"tab\",\n                    tabIndex: -1\n                } );\n            this._addClass( this.tabs, \"ui-tabs-tab\", \"ui-state-default\" );\n\n            this.anchors = this.tabs.map( function() {\n                return $( \"a\", this )[ 0 ];\n            } )\n                .attr( {\n                    tabIndex: -1\n                } );\n            this._addClass( this.anchors, \"ui-tabs-anchor\" );\n\n            this.panels = $();\n\n            this.anchors.each( function( i, anchor ) {\n                var selector, panel, panelId,\n                    anchorId = $( anchor ).uniqueId().attr( \"id\" ),\n                    tab = $( anchor ).closest( \"li\" ),\n                    originalAriaControls = tab.attr( \"aria-controls\" );\n\n                // Inline tab\n                if ( that._isLocal( anchor ) ) {\n                    selector = anchor.hash;\n                    panelId = selector.substring( 1 );\n                    panel = that.element.find( that._sanitizeSelector( selector ) );\n\n                    // remote tab\n                } else {\n\n                    // If the tab doesn't already have aria-controls,\n                    // generate an id by using a throw-away element\n                    panelId = tab.attr( \"aria-controls\" ) || $( {} ).uniqueId()[ 0 ].id;\n                    selector = \"#\" + panelId;\n                    panel = that.element.find( selector );\n                    if ( !panel.length ) {\n                        panel = that._createPanel( panelId );\n                        panel.insertAfter( that.panels[ i - 1 ] || that.tablist );\n                    }\n                    panel.attr( \"aria-live\", \"polite\" );\n                }\n\n                if ( panel.length ) {\n                    that.panels = that.panels.add( panel );\n                }\n                if ( originalAriaControls ) {\n                    tab.data( \"ui-tabs-aria-controls\", originalAriaControls );\n                }\n                tab.attr( {\n                    \"aria-controls\": panelId,\n                    \"aria-labelledby\": anchorId\n                } );\n                panel.attr( \"aria-labelledby\", anchorId );\n            } );\n\n            this.panels.attr( \"role\", \"tabpanel\" );\n            this._addClass( this.panels, \"ui-tabs-panel\", \"ui-widget-content\" );\n\n            // Avoid memory leaks (#10056)\n            if ( prevTabs ) {\n                this._off( prevTabs.not( this.tabs ) );\n                this._off( prevAnchors.not( this.anchors ) );\n                this._off( prevPanels.not( this.panels ) );\n            }\n        },\n\n        // Allow overriding how to find the list for rare usage scenarios (#7715)\n        _getList: function() {\n            return this.tablist || this.element.find( \"ol, ul\" ).eq( 0 );\n        },\n\n        _createPanel: function( id ) {\n            return $( \"<div>\" )\n                .attr( \"id\", id )\n                .data( \"ui-tabs-destroy\", true );\n        },\n\n        _setOptionDisabled: function( disabled ) {\n            var currentItem, li, i;\n\n            if ( Array.isArray( disabled ) ) {\n                if ( !disabled.length ) {\n                    disabled = false;\n                } else if ( disabled.length === this.anchors.length ) {\n                    disabled = true;\n                }\n            }\n\n            // Disable tabs\n            for ( i = 0; ( li = this.tabs[ i ] ); i++ ) {\n                currentItem = $( li );\n                if ( disabled === true || $.inArray( i, disabled ) !== -1 ) {\n                    currentItem.attr( \"aria-disabled\", \"true\" );\n                    this._addClass( currentItem, null, \"ui-state-disabled\" );\n                } else {\n                    currentItem.removeAttr( \"aria-disabled\" );\n                    this._removeClass( currentItem, null, \"ui-state-disabled\" );\n                }\n            }\n\n            this.options.disabled = disabled;\n\n            this._toggleClass( this.widget(), this.widgetFullName + \"-disabled\", null,\n                disabled === true );\n        },\n\n        _setupEvents: function( event ) {\n            var events = {};\n            if ( event ) {\n                $.each( event.split( \" \" ), function( index, eventName ) {\n                    events[ eventName ] = \"_eventHandler\";\n                } );\n            }\n\n            this._off( this.anchors.add( this.tabs ).add( this.panels ) );\n\n            // Always prevent the default action, even when disabled\n            this._on( true, this.anchors, {\n                click: function( event ) {\n                    event.preventDefault();\n                }\n            } );\n            this._on( this.anchors, events );\n            this._on( this.tabs, { keydown: \"_tabKeydown\" } );\n            this._on( this.panels, { keydown: \"_panelKeydown\" } );\n\n            this._focusable( this.tabs );\n            this._hoverable( this.tabs );\n        },\n\n        _setupHeightStyle: function( heightStyle ) {\n            var maxHeight,\n                parent = this.element.parent();\n\n            if ( heightStyle === \"fill\" ) {\n                maxHeight = parent.height();\n                maxHeight -= this.element.outerHeight() - this.element.height();\n\n                this.element.siblings( \":visible\" ).each( function() {\n                    var elem = $( this ),\n                        position = elem.css( \"position\" );\n\n                    if ( position === \"absolute\" || position === \"fixed\" ) {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight( true );\n                } );\n\n                this.element.children().not( this.panels ).each( function() {\n                    maxHeight -= $( this ).outerHeight( true );\n                } );\n\n                this.panels.each( function() {\n                    $( this ).height( Math.max( 0, maxHeight -\n                        $( this ).innerHeight() + $( this ).height() ) );\n                } )\n                    .css( \"overflow\", \"auto\" );\n            } else if ( heightStyle === \"auto\" ) {\n                maxHeight = 0;\n                this.panels.each( function() {\n                    maxHeight = Math.max( maxHeight, $( this ).height( \"\" ).height() );\n                } ).height( maxHeight );\n            }\n        },\n\n        _eventHandler: function( event ) {\n            var options = this.options,\n                active = this.active,\n                anchor = $( event.currentTarget ),\n                tab = anchor.closest( \"li\" ),\n                clickedIsActive = tab[ 0 ] === active[ 0 ],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : this._getPanelForTab( tab ),\n                toHide = !active.length ? $() : this._getPanelForTab( active ),\n                eventData = {\n                    oldTab: active,\n                    oldPanel: toHide,\n                    newTab: collapsing ? $() : tab,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if ( tab.hasClass( \"ui-state-disabled\" ) ||\n\n                // tab is already loading\n                tab.hasClass( \"ui-tabs-loading\" ) ||\n\n                // can't switch durning an animation\n                this.running ||\n\n                // click on active header, but not collapsible\n                ( clickedIsActive && !options.collapsible ) ||\n\n                // allow canceling activation\n                ( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.tabs.index( tab );\n\n            this.active = clickedIsActive ? $() : tab;\n            if ( this.xhr ) {\n                this.xhr.abort();\n            }\n\n            if ( !toHide.length && !toShow.length ) {\n                $.error( \"jQuery UI Tabs: Mismatching fragment identifier.\" );\n            }\n\n            if ( toShow.length ) {\n                this.load( this.tabs.index( tab ), event );\n            }\n            this._toggle( event, eventData );\n        },\n\n        // Handles show/hide for selecting tabs\n        _toggle: function( event, eventData ) {\n            var that = this,\n                toShow = eventData.newPanel,\n                toHide = eventData.oldPanel;\n\n            this.running = true;\n\n            function complete() {\n                that.running = false;\n                that._trigger( \"activate\", event, eventData );\n            }\n\n            function show() {\n                that._addClass( eventData.newTab.closest( \"li\" ), \"ui-tabs-active\", \"ui-state-active\" );\n\n                if ( toShow.length && that.options.show ) {\n                    that._show( toShow, that.options.show, complete );\n                } else {\n                    toShow.show();\n                    complete();\n                }\n            }\n\n            // Start out by hiding, then showing, then completing\n            if ( toHide.length && this.options.hide ) {\n                this._hide( toHide, this.options.hide, function() {\n                    that._removeClass( eventData.oldTab.closest( \"li\" ),\n                        \"ui-tabs-active\", \"ui-state-active\" );\n                    show();\n                } );\n            } else {\n                this._removeClass( eventData.oldTab.closest( \"li\" ),\n                    \"ui-tabs-active\", \"ui-state-active\" );\n                toHide.hide();\n                show();\n            }\n\n            toHide.attr( \"aria-hidden\", \"true\" );\n            eventData.oldTab.attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\"\n            } );\n\n            // If we're switching tabs, remove the old tab from the tab order.\n            // If we're opening from collapsed state, remove the previous tab from the tab order.\n            // If we're collapsing, then keep the collapsing tab in the tab order.\n            if ( toShow.length && toHide.length ) {\n                eventData.oldTab.attr( \"tabIndex\", -1 );\n            } else if ( toShow.length ) {\n                this.tabs.filter( function() {\n                    return $( this ).attr( \"tabIndex\" ) === 0;\n                } )\n                    .attr( \"tabIndex\", -1 );\n            }\n\n            toShow.attr( \"aria-hidden\", \"false\" );\n            eventData.newTab.attr( {\n                \"aria-selected\": \"true\",\n                \"aria-expanded\": \"true\",\n                tabIndex: 0\n            } );\n        },\n\n        _activate: function( index ) {\n            var anchor,\n                active = this._findActive( index );\n\n            // Trying to activate the already active panel\n            if ( active[ 0 ] === this.active[ 0 ] ) {\n                return;\n            }\n\n            // Trying to collapse, simulate a click on the current active header\n            if ( !active.length ) {\n                active = this.active;\n            }\n\n            anchor = active.find( \".ui-tabs-anchor\" )[ 0 ];\n            this._eventHandler( {\n                target: anchor,\n                currentTarget: anchor,\n                preventDefault: $.noop\n            } );\n        },\n\n        _findActive: function( index ) {\n            return index === false ? $() : this.tabs.eq( index );\n        },\n\n        _getIndex: function( index ) {\n\n            // meta-function to give users option to provide a href string instead of a numerical index.\n            if ( typeof index === \"string\" ) {\n                index = this.anchors.index( this.anchors.filter( \"[href$='\" +\n                    $.escapeSelector( index ) + \"']\" ) );\n            }\n\n            return index;\n        },\n\n        _destroy: function() {\n            if ( this.xhr ) {\n                this.xhr.abort();\n            }\n\n            this.tablist\n                .removeAttr( \"role\" )\n                .off( this.eventNamespace );\n\n            this.anchors\n                .removeAttr( \"role tabIndex\" )\n                .removeUniqueId();\n\n            this.tabs.add( this.panels ).each( function() {\n                if ( $.data( this, \"ui-tabs-destroy\" ) ) {\n                    $( this ).remove();\n                } else {\n                    $( this ).removeAttr( \"role tabIndex \" +\n                        \"aria-live aria-busy aria-selected aria-labelledby aria-hidden aria-expanded\" );\n                }\n            } );\n\n            this.tabs.each( function() {\n                var li = $( this ),\n                    prev = li.data( \"ui-tabs-aria-controls\" );\n                if ( prev ) {\n                    li\n                        .attr( \"aria-controls\", prev )\n                        .removeData( \"ui-tabs-aria-controls\" );\n                } else {\n                    li.removeAttr( \"aria-controls\" );\n                }\n            } );\n\n            this.panels.show();\n\n            if ( this.options.heightStyle !== \"content\" ) {\n                this.panels.css( \"height\", \"\" );\n            }\n        },\n\n        enable: function( index ) {\n            var disabled = this.options.disabled;\n            if ( disabled === false ) {\n                return;\n            }\n\n            if ( index === undefined ) {\n                disabled = false;\n            } else {\n                index = this._getIndex( index );\n                if ( Array.isArray( disabled ) ) {\n                    disabled = $.map( disabled, function( num ) {\n                        return num !== index ? num : null;\n                    } );\n                } else {\n                    disabled = $.map( this.tabs, function( li, num ) {\n                        return num !== index ? num : null;\n                    } );\n                }\n            }\n            this._setOptionDisabled( disabled );\n        },\n\n        disable: function( index ) {\n            var disabled = this.options.disabled;\n            if ( disabled === true ) {\n                return;\n            }\n\n            if ( index === undefined ) {\n                disabled = true;\n            } else {\n                index = this._getIndex( index );\n                if ( $.inArray( index, disabled ) !== -1 ) {\n                    return;\n                }\n                if ( Array.isArray( disabled ) ) {\n                    disabled = $.merge( [ index ], disabled ).sort();\n                } else {\n                    disabled = [ index ];\n                }\n            }\n            this._setOptionDisabled( disabled );\n        },\n\n        load: function( index, event ) {\n            index = this._getIndex( index );\n            var that = this,\n                tab = this.tabs.eq( index ),\n                anchor = tab.find( \".ui-tabs-anchor\" ),\n                panel = this._getPanelForTab( tab ),\n                eventData = {\n                    tab: tab,\n                    panel: panel\n                },\n                complete = function( jqXHR, status ) {\n                    if ( status === \"abort\" ) {\n                        that.panels.stop( false, true );\n                    }\n\n                    that._removeClass( tab, \"ui-tabs-loading\" );\n                    panel.removeAttr( \"aria-busy\" );\n\n                    if ( jqXHR === that.xhr ) {\n                        delete that.xhr;\n                    }\n                };\n\n            // Not remote\n            if ( this._isLocal( anchor[ 0 ] ) ) {\n                return;\n            }\n\n            this.xhr = $.ajax( this._ajaxSettings( anchor, event, eventData ) );\n\n            // Support: jQuery <1.8\n            // jQuery <1.8 returns false if the request is canceled in beforeSend,\n            // but as of 1.8, $.ajax() always returns a jqXHR object.\n            if ( this.xhr && this.xhr.statusText !== \"canceled\" ) {\n                this._addClass( tab, \"ui-tabs-loading\" );\n                panel.attr( \"aria-busy\", \"true\" );\n\n                this.xhr\n                    .done( function( response, status, jqXHR ) {\n\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout( function() {\n                            panel.html( response );\n                            that._trigger( \"load\", event, eventData );\n\n                            complete( jqXHR, status );\n                        }, 1 );\n                    } )\n                    .fail( function( jqXHR, status ) {\n\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout( function() {\n                            complete( jqXHR, status );\n                        }, 1 );\n                    } );\n            }\n        },\n\n        _ajaxSettings: function( anchor, event, eventData ) {\n            var that = this;\n            return {\n\n                // Support: IE <11 only\n                // Strip any hash that exists to prevent errors with the Ajax request\n                url: anchor.attr( \"href\" ).replace( /#.*$/, \"\" ),\n                beforeSend: function( jqXHR, settings ) {\n                    return that._trigger( \"beforeLoad\", event,\n                        $.extend( { jqXHR: jqXHR, ajaxSettings: settings }, eventData ) );\n                }\n            };\n        },\n\n        _getPanelForTab: function( tab ) {\n            var id = $( tab ).attr( \"aria-controls\" );\n            return this.element.find( this._sanitizeSelector( \"#\" + id ) );\n        }\n    } );\n\n// DEPRECATED\n// TODO: Switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for ui-tab class (now ui-tabs-tab)\n        $.widget( \"ui.tabs\", $.ui.tabs, {\n            _processTabs: function() {\n                this._superApply( arguments );\n                this._addClass( this.tabs, \"ui-tab\" );\n            }\n        } );\n    }\n\n    return $.ui.tabs;\n\n} );\n","jquery/ui-modules/widgets/resizable.js":"/*!\n * jQuery UI Resizable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Resizable\n//>>group: Interactions\n//>>description: Enables resize functionality for any element.\n//>>docs: http://api.jqueryui.com/resizable/\n//>>demos: http://jqueryui.com/resizable/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/resizable.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../disable-selection\",\n            \"../plugin\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.resizable\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"resize\",\n        options: {\n            alsoResize: false,\n            animate: false,\n            animateDuration: \"slow\",\n            animateEasing: \"swing\",\n            aspectRatio: false,\n            autoHide: false,\n            classes: {\n                \"ui-resizable-se\": \"ui-icon ui-icon-gripsmall-diagonal-se\"\n            },\n            containment: false,\n            ghost: false,\n            grid: false,\n            handles: \"e,s,se\",\n            helper: false,\n            maxHeight: null,\n            maxWidth: null,\n            minHeight: 10,\n            minWidth: 10,\n\n            // See #7960\n            zIndex: 90,\n\n            // Callbacks\n            resize: null,\n            start: null,\n            stop: null\n        },\n\n        _num: function( value ) {\n            return parseFloat( value ) || 0;\n        },\n\n        _isNumber: function( value ) {\n            return !isNaN( parseFloat( value ) );\n        },\n\n        _hasScroll: function( el, a ) {\n\n            if ( $( el ).css( \"overflow\" ) === \"hidden\" ) {\n                return false;\n            }\n\n            var scroll = ( a && a === \"left\" ) ? \"scrollLeft\" : \"scrollTop\",\n                has = false;\n\n            if ( el[ scroll ] > 0 ) {\n                return true;\n            }\n\n            // TODO: determine which cases actually cause this to happen\n            // if the element doesn't have the scroll set, see if it's possible to\n            // set the scroll\n            try {\n                el[ scroll ] = 1;\n                has = ( el[ scroll ] > 0 );\n                el[ scroll ] = 0;\n            } catch ( e ) {\n\n                // `el` might be a string, then setting `scroll` will throw\n                // an error in strict mode; ignore it.\n            }\n            return has;\n        },\n\n        _create: function() {\n\n            var margins,\n                o = this.options,\n                that = this;\n            this._addClass( \"ui-resizable\" );\n\n            $.extend( this, {\n                _aspectRatio: !!( o.aspectRatio ),\n                aspectRatio: o.aspectRatio,\n                originalElement: this.element,\n                _proportionallyResizeElements: [],\n                _helper: o.helper || o.ghost || o.animate ? o.helper || \"ui-resizable-helper\" : null\n            } );\n\n            // Wrap the element if it cannot hold child nodes\n            if ( this.element[ 0 ].nodeName.match( /^(canvas|textarea|input|select|button|img)$/i ) ) {\n\n                this.element.wrap(\n                    $( \"<div class='ui-wrapper'></div>\" ).css( {\n                        overflow: \"hidden\",\n                        position: this.element.css( \"position\" ),\n                        width: this.element.outerWidth(),\n                        height: this.element.outerHeight(),\n                        top: this.element.css( \"top\" ),\n                        left: this.element.css( \"left\" )\n                    } )\n                );\n\n                this.element = this.element.parent().data(\n                    \"ui-resizable\", this.element.resizable( \"instance\" )\n                );\n\n                this.elementIsWrapper = true;\n\n                margins = {\n                    marginTop: this.originalElement.css( \"marginTop\" ),\n                    marginRight: this.originalElement.css( \"marginRight\" ),\n                    marginBottom: this.originalElement.css( \"marginBottom\" ),\n                    marginLeft: this.originalElement.css( \"marginLeft\" )\n                };\n\n                this.element.css( margins );\n                this.originalElement.css( \"margin\", 0 );\n\n                // support: Safari\n                // Prevent Safari textarea resize\n                this.originalResizeStyle = this.originalElement.css( \"resize\" );\n                this.originalElement.css( \"resize\", \"none\" );\n\n                this._proportionallyResizeElements.push( this.originalElement.css( {\n                    position: \"static\",\n                    zoom: 1,\n                    display: \"block\"\n                } ) );\n\n                // Support: IE9\n                // avoid IE jump (hard set the margin)\n                this.originalElement.css( margins );\n\n                this._proportionallyResize();\n            }\n\n            this._setupHandles();\n\n            if ( o.autoHide ) {\n                $( this.element )\n                    .on( \"mouseenter\", function() {\n                        if ( o.disabled ) {\n                            return;\n                        }\n                        that._removeClass( \"ui-resizable-autohide\" );\n                        that._handles.show();\n                    } )\n                    .on( \"mouseleave\", function() {\n                        if ( o.disabled ) {\n                            return;\n                        }\n                        if ( !that.resizing ) {\n                            that._addClass( \"ui-resizable-autohide\" );\n                            that._handles.hide();\n                        }\n                    } );\n            }\n\n            this._mouseInit();\n        },\n\n        _destroy: function() {\n\n            this._mouseDestroy();\n            this._addedHandles.remove();\n\n            var wrapper,\n                _destroy = function( exp ) {\n                    $( exp )\n                        .removeData( \"resizable\" )\n                        .removeData( \"ui-resizable\" )\n                        .off( \".resizable\" );\n                };\n\n            // TODO: Unwrap at same DOM position\n            if ( this.elementIsWrapper ) {\n                _destroy( this.element );\n                wrapper = this.element;\n                this.originalElement.css( {\n                    position: wrapper.css( \"position\" ),\n                    width: wrapper.outerWidth(),\n                    height: wrapper.outerHeight(),\n                    top: wrapper.css( \"top\" ),\n                    left: wrapper.css( \"left\" )\n                } ).insertAfter( wrapper );\n                wrapper.remove();\n            }\n\n            this.originalElement.css( \"resize\", this.originalResizeStyle );\n            _destroy( this.originalElement );\n\n            return this;\n        },\n\n        _setOption: function( key, value ) {\n            this._super( key, value );\n\n            switch ( key ) {\n                case \"handles\":\n                    this._removeHandles();\n                    this._setupHandles();\n                    break;\n                case \"aspectRatio\":\n                    this._aspectRatio = !!value;\n                    break;\n                default:\n                    break;\n            }\n        },\n\n        _setupHandles: function() {\n            var o = this.options, handle, i, n, hname, axis, that = this;\n            this.handles = o.handles ||\n                ( !$( \".ui-resizable-handle\", this.element ).length ?\n                    \"e,s,se\" : {\n                        n: \".ui-resizable-n\",\n                        e: \".ui-resizable-e\",\n                        s: \".ui-resizable-s\",\n                        w: \".ui-resizable-w\",\n                        se: \".ui-resizable-se\",\n                        sw: \".ui-resizable-sw\",\n                        ne: \".ui-resizable-ne\",\n                        nw: \".ui-resizable-nw\"\n                    } );\n\n            this._handles = $();\n            this._addedHandles = $();\n            if ( this.handles.constructor === String ) {\n\n                if ( this.handles === \"all\" ) {\n                    this.handles = \"n,e,s,w,se,sw,ne,nw\";\n                }\n\n                n = this.handles.split( \",\" );\n                this.handles = {};\n\n                for ( i = 0; i < n.length; i++ ) {\n\n                    handle = String.prototype.trim.call( n[ i ] );\n                    hname = \"ui-resizable-\" + handle;\n                    axis = $( \"<div>\" );\n                    this._addClass( axis, \"ui-resizable-handle \" + hname );\n\n                    axis.css( { zIndex: o.zIndex } );\n\n                    this.handles[ handle ] = \".ui-resizable-\" + handle;\n                    if ( !this.element.children( this.handles[ handle ] ).length ) {\n                        this.element.append( axis );\n                        this._addedHandles = this._addedHandles.add( axis );\n                    }\n                }\n\n            }\n\n            this._renderAxis = function( target ) {\n\n                var i, axis, padPos, padWrapper;\n\n                target = target || this.element;\n\n                for ( i in this.handles ) {\n\n                    if ( this.handles[ i ].constructor === String ) {\n                        this.handles[ i ] = this.element.children( this.handles[ i ] ).first().show();\n                    } else if ( this.handles[ i ].jquery || this.handles[ i ].nodeType ) {\n                        this.handles[ i ] = $( this.handles[ i ] );\n                        this._on( this.handles[ i ], { \"mousedown\": that._mouseDown } );\n                    }\n\n                    if ( this.elementIsWrapper &&\n                        this.originalElement[ 0 ]\n                            .nodeName\n                            .match( /^(textarea|input|select|button)$/i ) ) {\n                        axis = $( this.handles[ i ], this.element );\n\n                        padWrapper = /sw|ne|nw|se|n|s/.test( i ) ?\n                            axis.outerHeight() :\n                            axis.outerWidth();\n\n                        padPos = [ \"padding\",\n                            /ne|nw|n/.test( i ) ? \"Top\" :\n                                /se|sw|s/.test( i ) ? \"Bottom\" :\n                                    /^e$/.test( i ) ? \"Right\" : \"Left\" ].join( \"\" );\n\n                        target.css( padPos, padWrapper );\n\n                        this._proportionallyResize();\n                    }\n\n                    this._handles = this._handles.add( this.handles[ i ] );\n                }\n            };\n\n            // TODO: make renderAxis a prototype function\n            this._renderAxis( this.element );\n\n            this._handles = this._handles.add( this.element.find( \".ui-resizable-handle\" ) );\n            this._handles.disableSelection();\n\n            this._handles.on( \"mouseover\", function() {\n                if ( !that.resizing ) {\n                    if ( this.className ) {\n                        axis = this.className.match( /ui-resizable-(se|sw|ne|nw|n|e|s|w)/i );\n                    }\n                    that.axis = axis && axis[ 1 ] ? axis[ 1 ] : \"se\";\n                }\n            } );\n\n            if ( o.autoHide ) {\n                this._handles.hide();\n                this._addClass( \"ui-resizable-autohide\" );\n            }\n        },\n\n        _removeHandles: function() {\n            this._addedHandles.remove();\n        },\n\n        _mouseCapture: function( event ) {\n            var i, handle,\n                capture = false;\n\n            for ( i in this.handles ) {\n                handle = $( this.handles[ i ] )[ 0 ];\n                if ( handle === event.target || $.contains( handle, event.target ) ) {\n                    capture = true;\n                }\n            }\n\n            return !this.options.disabled && capture;\n        },\n\n        _mouseStart: function( event ) {\n\n            var curleft, curtop, cursor,\n                o = this.options,\n                el = this.element;\n\n            this.resizing = true;\n\n            this._renderProxy();\n\n            curleft = this._num( this.helper.css( \"left\" ) );\n            curtop = this._num( this.helper.css( \"top\" ) );\n\n            if ( o.containment ) {\n                curleft += $( o.containment ).scrollLeft() || 0;\n                curtop += $( o.containment ).scrollTop() || 0;\n            }\n\n            this.offset = this.helper.offset();\n            this.position = { left: curleft, top: curtop };\n\n            this.size = this._helper ? {\n                width: this.helper.width(),\n                height: this.helper.height()\n            } : {\n                width: el.width(),\n                height: el.height()\n            };\n\n            this.originalSize = this._helper ? {\n                width: el.outerWidth(),\n                height: el.outerHeight()\n            } : {\n                width: el.width(),\n                height: el.height()\n            };\n\n            this.sizeDiff = {\n                width: el.outerWidth() - el.width(),\n                height: el.outerHeight() - el.height()\n            };\n\n            this.originalPosition = { left: curleft, top: curtop };\n            this.originalMousePosition = { left: event.pageX, top: event.pageY };\n\n            this.aspectRatio = ( typeof o.aspectRatio === \"number\" ) ?\n                o.aspectRatio :\n                ( ( this.originalSize.width / this.originalSize.height ) || 1 );\n\n            cursor = $( \".ui-resizable-\" + this.axis ).css( \"cursor\" );\n            $( \"body\" ).css( \"cursor\", cursor === \"auto\" ? this.axis + \"-resize\" : cursor );\n\n            this._addClass( \"ui-resizable-resizing\" );\n            this._propagate( \"start\", event );\n            return true;\n        },\n\n        _mouseDrag: function( event ) {\n\n            var data, props,\n                smp = this.originalMousePosition,\n                a = this.axis,\n                dx = ( event.pageX - smp.left ) || 0,\n                dy = ( event.pageY - smp.top ) || 0,\n                trigger = this._change[ a ];\n\n            this._updatePrevProperties();\n\n            if ( !trigger ) {\n                return false;\n            }\n\n            data = trigger.apply( this, [ event, dx, dy ] );\n\n            this._updateVirtualBoundaries( event.shiftKey );\n            if ( this._aspectRatio || event.shiftKey ) {\n                data = this._updateRatio( data, event );\n            }\n\n            data = this._respectSize( data, event );\n\n            this._updateCache( data );\n\n            this._propagate( \"resize\", event );\n\n            props = this._applyChanges();\n\n            if ( !this._helper && this._proportionallyResizeElements.length ) {\n                this._proportionallyResize();\n            }\n\n            if ( !$.isEmptyObject( props ) ) {\n                this._updatePrevProperties();\n                this._trigger( \"resize\", event, this.ui() );\n                this._applyChanges();\n            }\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n\n            this.resizing = false;\n            var pr, ista, soffseth, soffsetw, s, left, top,\n                o = this.options, that = this;\n\n            if ( this._helper ) {\n\n                pr = this._proportionallyResizeElements;\n                ista = pr.length && ( /textarea/i ).test( pr[ 0 ].nodeName );\n                soffseth = ista && this._hasScroll( pr[ 0 ], \"left\" ) ? 0 : that.sizeDiff.height;\n                soffsetw = ista ? 0 : that.sizeDiff.width;\n\n                s = {\n                    width: ( that.helper.width()  - soffsetw ),\n                    height: ( that.helper.height() - soffseth )\n                };\n                left = ( parseFloat( that.element.css( \"left\" ) ) +\n                    ( that.position.left - that.originalPosition.left ) ) || null;\n                top = ( parseFloat( that.element.css( \"top\" ) ) +\n                    ( that.position.top - that.originalPosition.top ) ) || null;\n\n                if ( !o.animate ) {\n                    this.element.css( $.extend( s, { top: top, left: left } ) );\n                }\n\n                that.helper.height( that.size.height );\n                that.helper.width( that.size.width );\n\n                if ( this._helper && !o.animate ) {\n                    this._proportionallyResize();\n                }\n            }\n\n            $( \"body\" ).css( \"cursor\", \"auto\" );\n\n            this._removeClass( \"ui-resizable-resizing\" );\n\n            this._propagate( \"stop\", event );\n\n            if ( this._helper ) {\n                this.helper.remove();\n            }\n\n            return false;\n\n        },\n\n        _updatePrevProperties: function() {\n            this.prevPosition = {\n                top: this.position.top,\n                left: this.position.left\n            };\n            this.prevSize = {\n                width: this.size.width,\n                height: this.size.height\n            };\n        },\n\n        _applyChanges: function() {\n            var props = {};\n\n            if ( this.position.top !== this.prevPosition.top ) {\n                props.top = this.position.top + \"px\";\n            }\n            if ( this.position.left !== this.prevPosition.left ) {\n                props.left = this.position.left + \"px\";\n            }\n            if ( this.size.width !== this.prevSize.width ) {\n                props.width = this.size.width + \"px\";\n            }\n            if ( this.size.height !== this.prevSize.height ) {\n                props.height = this.size.height + \"px\";\n            }\n\n            this.helper.css( props );\n\n            return props;\n        },\n\n        _updateVirtualBoundaries: function( forceAspectRatio ) {\n            var pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b,\n                o = this.options;\n\n            b = {\n                minWidth: this._isNumber( o.minWidth ) ? o.minWidth : 0,\n                maxWidth: this._isNumber( o.maxWidth ) ? o.maxWidth : Infinity,\n                minHeight: this._isNumber( o.minHeight ) ? o.minHeight : 0,\n                maxHeight: this._isNumber( o.maxHeight ) ? o.maxHeight : Infinity\n            };\n\n            if ( this._aspectRatio || forceAspectRatio ) {\n                pMinWidth = b.minHeight * this.aspectRatio;\n                pMinHeight = b.minWidth / this.aspectRatio;\n                pMaxWidth = b.maxHeight * this.aspectRatio;\n                pMaxHeight = b.maxWidth / this.aspectRatio;\n\n                if ( pMinWidth > b.minWidth ) {\n                    b.minWidth = pMinWidth;\n                }\n                if ( pMinHeight > b.minHeight ) {\n                    b.minHeight = pMinHeight;\n                }\n                if ( pMaxWidth < b.maxWidth ) {\n                    b.maxWidth = pMaxWidth;\n                }\n                if ( pMaxHeight < b.maxHeight ) {\n                    b.maxHeight = pMaxHeight;\n                }\n            }\n            this._vBoundaries = b;\n        },\n\n        _updateCache: function( data ) {\n            this.offset = this.helper.offset();\n            if ( this._isNumber( data.left ) ) {\n                this.position.left = data.left;\n            }\n            if ( this._isNumber( data.top ) ) {\n                this.position.top = data.top;\n            }\n            if ( this._isNumber( data.height ) ) {\n                this.size.height = data.height;\n            }\n            if ( this._isNumber( data.width ) ) {\n                this.size.width = data.width;\n            }\n        },\n\n        _updateRatio: function( data ) {\n\n            var cpos = this.position,\n                csize = this.size,\n                a = this.axis;\n\n            if ( this._isNumber( data.height ) ) {\n                data.width = ( data.height * this.aspectRatio );\n            } else if ( this._isNumber( data.width ) ) {\n                data.height = ( data.width / this.aspectRatio );\n            }\n\n            if ( a === \"sw\" ) {\n                data.left = cpos.left + ( csize.width - data.width );\n                data.top = null;\n            }\n            if ( a === \"nw\" ) {\n                data.top = cpos.top + ( csize.height - data.height );\n                data.left = cpos.left + ( csize.width - data.width );\n            }\n\n            return data;\n        },\n\n        _respectSize: function( data ) {\n\n            var o = this._vBoundaries,\n                a = this.axis,\n                ismaxw = this._isNumber( data.width ) && o.maxWidth && ( o.maxWidth < data.width ),\n                ismaxh = this._isNumber( data.height ) && o.maxHeight && ( o.maxHeight < data.height ),\n                isminw = this._isNumber( data.width ) && o.minWidth && ( o.minWidth > data.width ),\n                isminh = this._isNumber( data.height ) && o.minHeight && ( o.minHeight > data.height ),\n                dw = this.originalPosition.left + this.originalSize.width,\n                dh = this.originalPosition.top + this.originalSize.height,\n                cw = /sw|nw|w/.test( a ), ch = /nw|ne|n/.test( a );\n            if ( isminw ) {\n                data.width = o.minWidth;\n            }\n            if ( isminh ) {\n                data.height = o.minHeight;\n            }\n            if ( ismaxw ) {\n                data.width = o.maxWidth;\n            }\n            if ( ismaxh ) {\n                data.height = o.maxHeight;\n            }\n\n            if ( isminw && cw ) {\n                data.left = dw - o.minWidth;\n            }\n            if ( ismaxw && cw ) {\n                data.left = dw - o.maxWidth;\n            }\n            if ( isminh && ch ) {\n                data.top = dh - o.minHeight;\n            }\n            if ( ismaxh && ch ) {\n                data.top = dh - o.maxHeight;\n            }\n\n            // Fixing jump error on top/left - bug #2330\n            if ( !data.width && !data.height && !data.left && data.top ) {\n                data.top = null;\n            } else if ( !data.width && !data.height && !data.top && data.left ) {\n                data.left = null;\n            }\n\n            return data;\n        },\n\n        _getPaddingPlusBorderDimensions: function( element ) {\n            var i = 0,\n                widths = [],\n                borders = [\n                    element.css( \"borderTopWidth\" ),\n                    element.css( \"borderRightWidth\" ),\n                    element.css( \"borderBottomWidth\" ),\n                    element.css( \"borderLeftWidth\" )\n                ],\n                paddings = [\n                    element.css( \"paddingTop\" ),\n                    element.css( \"paddingRight\" ),\n                    element.css( \"paddingBottom\" ),\n                    element.css( \"paddingLeft\" )\n                ];\n\n            for ( ; i < 4; i++ ) {\n                widths[ i ] = ( parseFloat( borders[ i ] ) || 0 );\n                widths[ i ] += ( parseFloat( paddings[ i ] ) || 0 );\n            }\n\n            return {\n                height: widths[ 0 ] + widths[ 2 ],\n                width: widths[ 1 ] + widths[ 3 ]\n            };\n        },\n\n        _proportionallyResize: function() {\n\n            if ( !this._proportionallyResizeElements.length ) {\n                return;\n            }\n\n            var prel,\n                i = 0,\n                element = this.helper || this.element;\n\n            for ( ; i < this._proportionallyResizeElements.length; i++ ) {\n\n                prel = this._proportionallyResizeElements[ i ];\n\n                // TODO: Seems like a bug to cache this.outerDimensions\n                // considering that we are in a loop.\n                if ( !this.outerDimensions ) {\n                    this.outerDimensions = this._getPaddingPlusBorderDimensions( prel );\n                }\n\n                prel.css( {\n                    height: ( element.height() - this.outerDimensions.height ) || 0,\n                    width: ( element.width() - this.outerDimensions.width ) || 0\n                } );\n\n            }\n\n        },\n\n        _renderProxy: function() {\n\n            var el = this.element, o = this.options;\n            this.elementOffset = el.offset();\n\n            if ( this._helper ) {\n\n                this.helper = this.helper || $( \"<div></div>\" ).css( { overflow: \"hidden\" } );\n\n                this._addClass( this.helper, this._helper );\n                this.helper.css( {\n                    width: this.element.outerWidth(),\n                    height: this.element.outerHeight(),\n                    position: \"absolute\",\n                    left: this.elementOffset.left + \"px\",\n                    top: this.elementOffset.top + \"px\",\n                    zIndex: ++o.zIndex //TODO: Don't modify option\n                } );\n\n                this.helper\n                    .appendTo( \"body\" )\n                    .disableSelection();\n\n            } else {\n                this.helper = this.element;\n            }\n\n        },\n\n        _change: {\n            e: function( event, dx ) {\n                return { width: this.originalSize.width + dx };\n            },\n            w: function( event, dx ) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return { left: sp.left + dx, width: cs.width - dx };\n            },\n            n: function( event, dx, dy ) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return { top: sp.top + dy, height: cs.height - dy };\n            },\n            s: function( event, dx, dy ) {\n                return { height: this.originalSize.height + dy };\n            },\n            se: function( event, dx, dy ) {\n                return $.extend( this._change.s.apply( this, arguments ),\n                    this._change.e.apply( this, [ event, dx, dy ] ) );\n            },\n            sw: function( event, dx, dy ) {\n                return $.extend( this._change.s.apply( this, arguments ),\n                    this._change.w.apply( this, [ event, dx, dy ] ) );\n            },\n            ne: function( event, dx, dy ) {\n                return $.extend( this._change.n.apply( this, arguments ),\n                    this._change.e.apply( this, [ event, dx, dy ] ) );\n            },\n            nw: function( event, dx, dy ) {\n                return $.extend( this._change.n.apply( this, arguments ),\n                    this._change.w.apply( this, [ event, dx, dy ] ) );\n            }\n        },\n\n        _propagate: function( n, event ) {\n            $.ui.plugin.call( this, n, [ event, this.ui() ] );\n            if ( n !== \"resize\" ) {\n                this._trigger( n, event, this.ui() );\n            }\n        },\n\n        plugins: {},\n\n        ui: function() {\n            return {\n                originalElement: this.originalElement,\n                element: this.element,\n                helper: this.helper,\n                position: this.position,\n                size: this.size,\n                originalSize: this.originalSize,\n                originalPosition: this.originalPosition\n            };\n        }\n\n    } );\n\n    /*\n     * Resizable Extensions\n     */\n\n    $.ui.plugin.add( \"resizable\", \"animate\", {\n\n        stop: function( event ) {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                pr = that._proportionallyResizeElements,\n                ista = pr.length && ( /textarea/i ).test( pr[ 0 ].nodeName ),\n                soffseth = ista && that._hasScroll( pr[ 0 ], \"left\" ) ? 0 : that.sizeDiff.height,\n                soffsetw = ista ? 0 : that.sizeDiff.width,\n                style = {\n                    width: ( that.size.width - soffsetw ),\n                    height: ( that.size.height - soffseth )\n                },\n                left = ( parseFloat( that.element.css( \"left\" ) ) +\n                    ( that.position.left - that.originalPosition.left ) ) || null,\n                top = ( parseFloat( that.element.css( \"top\" ) ) +\n                    ( that.position.top - that.originalPosition.top ) ) || null;\n\n            that.element.animate(\n                $.extend( style, top && left ? { top: top, left: left } : {} ), {\n                    duration: o.animateDuration,\n                    easing: o.animateEasing,\n                    step: function() {\n\n                        var data = {\n                            width: parseFloat( that.element.css( \"width\" ) ),\n                            height: parseFloat( that.element.css( \"height\" ) ),\n                            top: parseFloat( that.element.css( \"top\" ) ),\n                            left: parseFloat( that.element.css( \"left\" ) )\n                        };\n\n                        if ( pr && pr.length ) {\n                            $( pr[ 0 ] ).css( { width: data.width, height: data.height } );\n                        }\n\n                        // Propagating resize, and updating values for each animation step\n                        that._updateCache( data );\n                        that._propagate( \"resize\", event );\n\n                    }\n                }\n            );\n        }\n\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"containment\", {\n\n        start: function() {\n            var element, p, co, ch, cw, width, height,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                el = that.element,\n                oc = o.containment,\n                ce = ( oc instanceof $ ) ?\n                    oc.get( 0 ) :\n                    ( /parent/.test( oc ) ) ? el.parent().get( 0 ) : oc;\n\n            if ( !ce ) {\n                return;\n            }\n\n            that.containerElement = $( ce );\n\n            if ( /document/.test( oc ) || oc === document ) {\n                that.containerOffset = {\n                    left: 0,\n                    top: 0\n                };\n                that.containerPosition = {\n                    left: 0,\n                    top: 0\n                };\n\n                that.parentData = {\n                    element: $( document ),\n                    left: 0,\n                    top: 0,\n                    width: $( document ).width(),\n                    height: $( document ).height() || document.body.parentNode.scrollHeight\n                };\n            } else {\n                element = $( ce );\n                p = [];\n                $( [ \"Top\", \"Right\", \"Left\", \"Bottom\" ] ).each( function( i, name ) {\n                    p[ i ] = that._num( element.css( \"padding\" + name ) );\n                } );\n\n                that.containerOffset = element.offset();\n                that.containerPosition = element.position();\n                that.containerSize = {\n                    height: ( element.innerHeight() - p[ 3 ] ),\n                    width: ( element.innerWidth() - p[ 1 ] )\n                };\n\n                co = that.containerOffset;\n                ch = that.containerSize.height;\n                cw = that.containerSize.width;\n                width = ( that._hasScroll( ce, \"left\" ) ? ce.scrollWidth : cw );\n                height = ( that._hasScroll( ce ) ? ce.scrollHeight : ch );\n\n                that.parentData = {\n                    element: ce,\n                    left: co.left,\n                    top: co.top,\n                    width: width,\n                    height: height\n                };\n            }\n        },\n\n        resize: function( event ) {\n            var woset, hoset, isParent, isOffsetRelative,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                co = that.containerOffset,\n                cp = that.position,\n                pRatio = that._aspectRatio || event.shiftKey,\n                cop = {\n                    top: 0,\n                    left: 0\n                },\n                ce = that.containerElement,\n                continueResize = true;\n\n            if ( ce[ 0 ] !== document && ( /static/ ).test( ce.css( \"position\" ) ) ) {\n                cop = co;\n            }\n\n            if ( cp.left < ( that._helper ? co.left : 0 ) ) {\n                that.size.width = that.size.width +\n                    ( that._helper ?\n                        ( that.position.left - co.left ) :\n                        ( that.position.left - cop.left ) );\n\n                if ( pRatio ) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                    continueResize = false;\n                }\n                that.position.left = o.helper ? co.left : 0;\n            }\n\n            if ( cp.top < ( that._helper ? co.top : 0 ) ) {\n                that.size.height = that.size.height +\n                    ( that._helper ?\n                        ( that.position.top - co.top ) :\n                        that.position.top );\n\n                if ( pRatio ) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                    continueResize = false;\n                }\n                that.position.top = that._helper ? co.top : 0;\n            }\n\n            isParent = that.containerElement.get( 0 ) === that.element.parent().get( 0 );\n            isOffsetRelative = /relative|absolute/.test( that.containerElement.css( \"position\" ) );\n\n            if ( isParent && isOffsetRelative ) {\n                that.offset.left = that.parentData.left + that.position.left;\n                that.offset.top = that.parentData.top + that.position.top;\n            } else {\n                that.offset.left = that.element.offset().left;\n                that.offset.top = that.element.offset().top;\n            }\n\n            woset = Math.abs( that.sizeDiff.width +\n                ( that._helper ?\n                    that.offset.left - cop.left :\n                    ( that.offset.left - co.left ) ) );\n\n            hoset = Math.abs( that.sizeDiff.height +\n                ( that._helper ?\n                    that.offset.top - cop.top :\n                    ( that.offset.top - co.top ) ) );\n\n            if ( woset + that.size.width >= that.parentData.width ) {\n                that.size.width = that.parentData.width - woset;\n                if ( pRatio ) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                    continueResize = false;\n                }\n            }\n\n            if ( hoset + that.size.height >= that.parentData.height ) {\n                that.size.height = that.parentData.height - hoset;\n                if ( pRatio ) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                    continueResize = false;\n                }\n            }\n\n            if ( !continueResize ) {\n                that.position.left = that.prevPosition.left;\n                that.position.top = that.prevPosition.top;\n                that.size.width = that.prevSize.width;\n                that.size.height = that.prevSize.height;\n            }\n        },\n\n        stop: function() {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                co = that.containerOffset,\n                cop = that.containerPosition,\n                ce = that.containerElement,\n                helper = $( that.helper ),\n                ho = helper.offset(),\n                w = helper.outerWidth() - that.sizeDiff.width,\n                h = helper.outerHeight() - that.sizeDiff.height;\n\n            if ( that._helper && !o.animate && ( /relative/ ).test( ce.css( \"position\" ) ) ) {\n                $( this ).css( {\n                    left: ho.left - cop.left - co.left,\n                    width: w,\n                    height: h\n                } );\n            }\n\n            if ( that._helper && !o.animate && ( /static/ ).test( ce.css( \"position\" ) ) ) {\n                $( this ).css( {\n                    left: ho.left - cop.left - co.left,\n                    width: w,\n                    height: h\n                } );\n            }\n        }\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"alsoResize\", {\n\n        start: function() {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options;\n\n            $( o.alsoResize ).each( function() {\n                var el = $( this );\n                el.data( \"ui-resizable-alsoresize\", {\n                    width: parseFloat( el.width() ), height: parseFloat( el.height() ),\n                    left: parseFloat( el.css( \"left\" ) ), top: parseFloat( el.css( \"top\" ) )\n                } );\n            } );\n        },\n\n        resize: function( event, ui ) {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                os = that.originalSize,\n                op = that.originalPosition,\n                delta = {\n                    height: ( that.size.height - os.height ) || 0,\n                    width: ( that.size.width - os.width ) || 0,\n                    top: ( that.position.top - op.top ) || 0,\n                    left: ( that.position.left - op.left ) || 0\n                };\n\n            $( o.alsoResize ).each( function() {\n                var el = $( this ), start = $( this ).data( \"ui-resizable-alsoresize\" ), style = {},\n                    css = el.parents( ui.originalElement[ 0 ] ).length ?\n                        [ \"width\", \"height\" ] :\n                        [ \"width\", \"height\", \"top\", \"left\" ];\n\n                $.each( css, function( i, prop ) {\n                    var sum = ( start[ prop ] || 0 ) + ( delta[ prop ] || 0 );\n                    if ( sum && sum >= 0 ) {\n                        style[ prop ] = sum || null;\n                    }\n                } );\n\n                el.css( style );\n            } );\n        },\n\n        stop: function() {\n            $( this ).removeData( \"ui-resizable-alsoresize\" );\n        }\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"ghost\", {\n\n        start: function() {\n\n            var that = $( this ).resizable( \"instance\" ), cs = that.size;\n\n            that.ghost = that.originalElement.clone();\n            that.ghost.css( {\n                opacity: 0.25,\n                display: \"block\",\n                position: \"relative\",\n                height: cs.height,\n                width: cs.width,\n                margin: 0,\n                left: 0,\n                top: 0\n            } );\n\n            that._addClass( that.ghost, \"ui-resizable-ghost\" );\n\n            // DEPRECATED\n            // TODO: remove after 1.12\n            if ( $.uiBackCompat !== false && typeof that.options.ghost === \"string\" ) {\n\n                // Ghost option\n                that.ghost.addClass( this.options.ghost );\n            }\n\n            that.ghost.appendTo( that.helper );\n\n        },\n\n        resize: function() {\n            var that = $( this ).resizable( \"instance\" );\n            if ( that.ghost ) {\n                that.ghost.css( {\n                    position: \"relative\",\n                    height: that.size.height,\n                    width: that.size.width\n                } );\n            }\n        },\n\n        stop: function() {\n            var that = $( this ).resizable( \"instance\" );\n            if ( that.ghost && that.helper ) {\n                that.helper.get( 0 ).removeChild( that.ghost.get( 0 ) );\n            }\n        }\n\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"grid\", {\n\n        resize: function() {\n            var outerDimensions,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                cs = that.size,\n                os = that.originalSize,\n                op = that.originalPosition,\n                a = that.axis,\n                grid = typeof o.grid === \"number\" ? [ o.grid, o.grid ] : o.grid,\n                gridX = ( grid[ 0 ] || 1 ),\n                gridY = ( grid[ 1 ] || 1 ),\n                ox = Math.round( ( cs.width - os.width ) / gridX ) * gridX,\n                oy = Math.round( ( cs.height - os.height ) / gridY ) * gridY,\n                newWidth = os.width + ox,\n                newHeight = os.height + oy,\n                isMaxWidth = o.maxWidth && ( o.maxWidth < newWidth ),\n                isMaxHeight = o.maxHeight && ( o.maxHeight < newHeight ),\n                isMinWidth = o.minWidth && ( o.minWidth > newWidth ),\n                isMinHeight = o.minHeight && ( o.minHeight > newHeight );\n\n            o.grid = grid;\n\n            if ( isMinWidth ) {\n                newWidth += gridX;\n            }\n            if ( isMinHeight ) {\n                newHeight += gridY;\n            }\n            if ( isMaxWidth ) {\n                newWidth -= gridX;\n            }\n            if ( isMaxHeight ) {\n                newHeight -= gridY;\n            }\n\n            if ( /^(se|s|e)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n            } else if ( /^(ne)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.top = op.top - oy;\n            } else if ( /^(sw)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.left = op.left - ox;\n            } else {\n                if ( newHeight - gridY <= 0 || newWidth - gridX <= 0 ) {\n                    outerDimensions = that._getPaddingPlusBorderDimensions( this );\n                }\n\n                if ( newHeight - gridY > 0 ) {\n                    that.size.height = newHeight;\n                    that.position.top = op.top - oy;\n                } else {\n                    newHeight = gridY - outerDimensions.height;\n                    that.size.height = newHeight;\n                