require.config({"config": {
        "jsbuild":{"jquery/ui-modules/widgets/menu.js":"/*!\n * jQuery UI Menu 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Menu\n//>>group: Widgets\n//>>description: Creates nestable menus.\n//>>docs: http://api.jqueryui.com/menu/\n//>>demos: http://jqueryui.com/menu/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/menu.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../keycode\",\n            \"../position\",\n            \"../safe-active-element\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.menu\", {\n        version: \"1.13.2\",\n        defaultElement: \"<ul>\",\n        delay: 300,\n        options: {\n            icons: {\n                submenu: \"ui-icon-caret-1-e\"\n            },\n            items: \"> *\",\n            menus: \"ul\",\n            position: {\n                my: \"left top\",\n                at: \"right top\"\n            },\n            role: \"menu\",\n\n            // Callbacks\n            blur: null,\n            focus: null,\n            select: null\n        },\n\n        _create: function() {\n            this.activeMenu = this.element;\n\n            // Flag used to prevent firing of the click handler\n            // as the event bubbles up through nested menus\n            this.mouseHandled = false;\n            this.lastMousePosition = { x: null, y: null };\n            this.element\n                .uniqueId()\n                .attr( {\n                    role: this.options.role,\n                    tabIndex: 0\n                } );\n\n            this._addClass( \"ui-menu\", \"ui-widget ui-widget-content\" );\n            this._on( {\n\n                // Prevent focus from sticking to links inside menu after clicking\n                // them (focus should always stay on UL during navigation).\n                \"mousedown .ui-menu-item\": function( event ) {\n                    event.preventDefault();\n\n                    this._activateItem( event );\n                },\n                \"click .ui-menu-item\": function( event ) {\n                    var target = $( event.target );\n                    var active = $( $.ui.safeActiveElement( this.document[ 0 ] ) );\n                    if ( !this.mouseHandled && target.not( \".ui-state-disabled\" ).length ) {\n                        this.select( event );\n\n                        // Only set the mouseHandled flag if the event will bubble, see #9469.\n                        if ( !event.isPropagationStopped() ) {\n                            this.mouseHandled = true;\n                        }\n\n                        // Open submenu on click\n                        if ( target.has( \".ui-menu\" ).length ) {\n                            this.expand( event );\n                        } else if ( !this.element.is( \":focus\" ) &&\n                            active.closest( \".ui-menu\" ).length ) {\n\n                            // Redirect focus to the menu\n                            this.element.trigger( \"focus\", [ true ] );\n\n                            // If the active item is on the top level, let it stay active.\n                            // Otherwise, blur the active item since it is no longer visible.\n                            if ( this.active && this.active.parents( \".ui-menu\" ).length === 1 ) {\n                                clearTimeout( this.timer );\n                            }\n                        }\n                    }\n                },\n                \"mouseenter .ui-menu-item\": \"_activateItem\",\n                \"mousemove .ui-menu-item\": \"_activateItem\",\n                mouseleave: \"collapseAll\",\n                \"mouseleave .ui-menu\": \"collapseAll\",\n                focus: function( event, keepActiveItem ) {\n\n                    // If there's already an active item, keep it active\n                    // If not, activate the first item\n                    var item = this.active || this._menuItems().first();\n\n                    if ( !keepActiveItem ) {\n                        this.focus( event, item );\n                    }\n                },\n                blur: function( event ) {\n                    this._delay( function() {\n                        var notContained = !$.contains(\n                            this.element[ 0 ],\n                            $.ui.safeActiveElement( this.document[ 0 ] )\n                        );\n                        if ( notContained ) {\n                            this.collapseAll( event );\n                        }\n                    } );\n                },\n                keydown: \"_keydown\"\n            } );\n\n            this.refresh();\n\n            // Clicks outside of a menu collapse any open menus\n            this._on( this.document, {\n                click: function( event ) {\n                    if ( this._closeOnDocumentClick( event ) ) {\n                        this.collapseAll( event, true );\n                    }\n\n                    // Reset the mouseHandled flag\n                    this.mouseHandled = false;\n                }\n            } );\n        },\n\n        _activateItem: function( event ) {\n\n            // Ignore mouse events while typeahead is active, see #10458.\n            // Prevents focusing the wrong item when typeahead causes a scroll while the mouse\n            // is over an item in the menu\n            if ( this.previousFilter ) {\n                return;\n            }\n\n            // If the mouse didn't actually move, but the page was scrolled, ignore the event (#9356)\n            if ( event.clientX === this.lastMousePosition.x &&\n                event.clientY === this.lastMousePosition.y ) {\n                return;\n            }\n\n            this.lastMousePosition = {\n                x: event.clientX,\n                y: event.clientY\n            };\n\n            var actualTarget = $( event.target ).closest( \".ui-menu-item\" ),\n                target = $( event.currentTarget );\n\n            // Ignore bubbled events on parent items, see #11641\n            if ( actualTarget[ 0 ] !== target[ 0 ] ) {\n                return;\n            }\n\n            // If the item is already active, there's nothing to do\n            if ( target.is( \".ui-state-active\" ) ) {\n                return;\n            }\n\n            // Remove ui-state-active class from siblings of the newly focused menu item\n            // to avoid a jump caused by adjacent elements both having a class with a border\n            this._removeClass( target.siblings().children( \".ui-state-active\" ),\n                null, \"ui-state-active\" );\n            this.focus( event, target );\n        },\n\n        _destroy: function() {\n            var items = this.element.find( \".ui-menu-item\" )\n                    .removeAttr( \"role aria-disabled\" ),\n                submenus = items.children( \".ui-menu-item-wrapper\" )\n                    .removeUniqueId()\n                    .removeAttr( \"tabIndex role aria-haspopup\" );\n\n            // Destroy (sub)menus\n            this.element\n                .removeAttr( \"aria-activedescendant\" )\n                .find( \".ui-menu\" ).addBack()\n                .removeAttr( \"role aria-labelledby aria-expanded aria-hidden aria-disabled \" +\n                    \"tabIndex\" )\n                .removeUniqueId()\n                .show();\n\n            submenus.children().each( function() {\n                var elem = $( this );\n                if ( elem.data( \"ui-menu-submenu-caret\" ) ) {\n                    elem.remove();\n                }\n            } );\n        },\n\n        _keydown: function( event ) {\n            var match, prev, character, skip,\n                preventDefault = true;\n\n            switch ( event.keyCode ) {\n                case $.ui.keyCode.PAGE_UP:\n                    this.previousPage( event );\n                    break;\n                case $.ui.keyCode.PAGE_DOWN:\n                    this.nextPage( event );\n                    break;\n                case $.ui.keyCode.HOME:\n                    this._move( \"first\", \"first\", event );\n                    break;\n                case $.ui.keyCode.END:\n                    this._move( \"last\", \"last\", event );\n                    break;\n                case $.ui.keyCode.UP:\n                    this.previous( event );\n                    break;\n                case $.ui.keyCode.DOWN:\n                    this.next( event );\n                    break;\n                case $.ui.keyCode.LEFT:\n                    this.collapse( event );\n                    break;\n                case $.ui.keyCode.RIGHT:\n                    if ( this.active && !this.active.is( \".ui-state-disabled\" ) ) {\n                        this.expand( event );\n                    }\n                    break;\n                case $.ui.keyCode.ENTER:\n                case $.ui.keyCode.SPACE:\n                    this._activate( event );\n                    break;\n                case $.ui.keyCode.ESCAPE:\n                    this.collapse( event );\n                    break;\n                default:\n                    preventDefault = false;\n                    prev = this.previousFilter || \"\";\n                    skip = false;\n\n                    // Support number pad values\n                    character = event.keyCode >= 96 && event.keyCode <= 105 ?\n                        ( event.keyCode - 96 ).toString() : String.fromCharCode( event.keyCode );\n\n                    clearTimeout( this.filterTimer );\n\n                    if ( character === prev ) {\n                        skip = true;\n                    } else {\n                        character = prev + character;\n                    }\n\n                    match = this._filterMenuItems( character );\n                    match = skip && match.index( this.active.next() ) !== -1 ?\n                        this.active.nextAll( \".ui-menu-item\" ) :\n                        match;\n\n                    // If no matches on the current filter, reset to the last character pressed\n                    // to move down the menu to the first item that starts with that character\n                    if ( !match.length ) {\n                        character = String.fromCharCode( event.keyCode );\n                        match = this._filterMenuItems( character );\n                    }\n\n                    if ( match.length ) {\n                        this.focus( event, match );\n                        this.previousFilter = character;\n                        this.filterTimer = this._delay( function() {\n                            delete this.previousFilter;\n                        }, 1000 );\n                    } else {\n                        delete this.previousFilter;\n                    }\n            }\n\n            if ( preventDefault ) {\n                event.preventDefault();\n            }\n        },\n\n        _activate: function( event ) {\n            if ( this.active && !this.active.is( \".ui-state-disabled\" ) ) {\n                if ( this.active.children( \"[aria-haspopup='true']\" ).length ) {\n                    this.expand( event );\n                } else {\n                    this.select( event );\n                }\n            }\n        },\n\n        refresh: function() {\n            var menus, items, newSubmenus, newItems, newWrappers,\n                that = this,\n                icon = this.options.icons.submenu,\n                submenus = this.element.find( this.options.menus );\n\n            this._toggleClass( \"ui-menu-icons\", null, !!this.element.find( \".ui-icon\" ).length );\n\n            // Initialize nested menus\n            newSubmenus = submenus.filter( \":not(.ui-menu)\" )\n                .hide()\n                .attr( {\n                    role: this.options.role,\n                    \"aria-hidden\": \"true\",\n                    \"aria-expanded\": \"false\"\n                } )\n                .each( function() {\n                    var menu = $( this ),\n                        item = menu.prev(),\n                        submenuCaret = $( \"<span>\" ).data( \"ui-menu-submenu-caret\", true );\n\n                    that._addClass( submenuCaret, \"ui-menu-icon\", \"ui-icon \" + icon );\n                    item\n                        .attr( \"aria-haspopup\", \"true\" )\n                        .prepend( submenuCaret );\n                    menu.attr( \"aria-labelledby\", item.attr( \"id\" ) );\n                } );\n\n            this._addClass( newSubmenus, \"ui-menu\", \"ui-widget ui-widget-content ui-front\" );\n\n            menus = submenus.add( this.element );\n            items = menus.find( this.options.items );\n\n            // Initialize menu-items containing spaces and/or dashes only as dividers\n            items.not( \".ui-menu-item\" ).each( function() {\n                var item = $( this );\n                if ( that._isDivider( item ) ) {\n                    that._addClass( item, \"ui-menu-divider\", \"ui-widget-content\" );\n                }\n            } );\n\n            // Don't refresh list items that are already adapted\n            newItems = items.not( \".ui-menu-item, .ui-menu-divider\" );\n            newWrappers = newItems.children()\n                .not( \".ui-menu\" )\n                .uniqueId()\n                .attr( {\n                    tabIndex: -1,\n                    role: this._itemRole()\n                } );\n            this._addClass( newItems, \"ui-menu-item\" )\n                ._addClass( newWrappers, \"ui-menu-item-wrapper\" );\n\n            // Add aria-disabled attribute to any disabled menu item\n            items.filter( \".ui-state-disabled\" ).attr( \"aria-disabled\", \"true\" );\n\n            // If the active item has been removed, blur the menu\n            if ( this.active && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n                this.blur();\n            }\n        },\n\n        _itemRole: function() {\n            return {\n                menu: \"menuitem\",\n                listbox: \"option\"\n            }[ this.options.role ];\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"icons\" ) {\n                var icons = this.element.find( \".ui-menu-icon\" );\n                this._removeClass( icons, null, this.options.icons.submenu )\n                    ._addClass( icons, null, value.submenu );\n            }\n            this._super( key, value );\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this.element.attr( \"aria-disabled\", String( value ) );\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n        },\n\n        focus: function( event, item ) {\n            var nested, focused, activeParent;\n            this.blur( event, event && event.type === \"focus\" );\n\n            this._scrollIntoView( item );\n\n            this.active = item.first();\n\n            focused = this.active.children( \".ui-menu-item-wrapper\" );\n            this._addClass( focused, null, \"ui-state-active\" );\n\n            // Only update aria-activedescendant if there's a role\n            // otherwise we assume focus is managed elsewhere\n            if ( this.options.role ) {\n                this.element.attr( \"aria-activedescendant\", focused.attr( \"id\" ) );\n            }\n\n            // Highlight active parent menu item, if any\n            activeParent = this.active\n                .parent()\n                .closest( \".ui-menu-item\" )\n                .children( \".ui-menu-item-wrapper\" );\n            this._addClass( activeParent, null, \"ui-state-active\" );\n\n            if ( event && event.type === \"keydown\" ) {\n                this._close();\n            } else {\n                this.timer = this._delay( function() {\n                    this._close();\n                }, this.delay );\n            }\n\n            nested = item.children( \".ui-menu\" );\n            if ( nested.length && event && ( /^mouse/.test( event.type ) ) ) {\n                this._startOpening( nested );\n            }\n            this.activeMenu = item.parent();\n\n            this._trigger( \"focus\", event, { item: item } );\n        },\n\n        _scrollIntoView: function( item ) {\n            var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n            if ( this._hasScroll() ) {\n                borderTop = parseFloat( $.css( this.activeMenu[ 0 ], \"borderTopWidth\" ) ) || 0;\n                paddingTop = parseFloat( $.css( this.activeMenu[ 0 ], \"paddingTop\" ) ) || 0;\n                offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n                scroll = this.activeMenu.scrollTop();\n                elementHeight = this.activeMenu.height();\n                itemHeight = item.outerHeight();\n\n                if ( offset < 0 ) {\n                    this.activeMenu.scrollTop( scroll + offset );\n                } else if ( offset + itemHeight > elementHeight ) {\n                    this.activeMenu.scrollTop( scroll + offset - elementHeight + itemHeight );\n                }\n            }\n        },\n\n        blur: function( event, fromFocus ) {\n            if ( !fromFocus ) {\n                clearTimeout( this.timer );\n            }\n\n            if ( !this.active ) {\n                return;\n            }\n\n            this._removeClass( this.active.children( \".ui-menu-item-wrapper\" ),\n                null, \"ui-state-active\" );\n\n            this._trigger( \"blur\", event, { item: this.active } );\n            this.active = null;\n        },\n\n        _startOpening: function( submenu ) {\n            clearTimeout( this.timer );\n\n            // Don't open if already open fixes a Firefox bug that caused a .5 pixel\n            // shift in the submenu position when mousing over the caret icon\n            if ( submenu.attr( \"aria-hidden\" ) !== \"true\" ) {\n                return;\n            }\n\n            this.timer = this._delay( function() {\n                this._close();\n                this._open( submenu );\n            }, this.delay );\n        },\n\n        _open: function( submenu ) {\n            var position = $.extend( {\n                of: this.active\n            }, this.options.position );\n\n            clearTimeout( this.timer );\n            this.element.find( \".ui-menu\" ).not( submenu.parents( \".ui-menu\" ) )\n                .hide()\n                .attr( \"aria-hidden\", \"true\" );\n\n            submenu\n                .show()\n                .removeAttr( \"aria-hidden\" )\n                .attr( \"aria-expanded\", \"true\" )\n                .position( position );\n        },\n\n        collapseAll: function( event, all ) {\n            clearTimeout( this.timer );\n            this.timer = this._delay( function() {\n\n                // If we were passed an event, look for the submenu that contains the event\n                var currentMenu = all ? this.element :\n                    $( event && event.target ).closest( this.element.find( \".ui-menu\" ) );\n\n                // If we found no valid submenu ancestor, use the main menu to close all\n                // sub menus anyway\n                if ( !currentMenu.length ) {\n                    currentMenu = this.element;\n                }\n\n                this._close( currentMenu );\n\n                this.blur( event );\n\n                // Work around active item staying active after menu is blurred\n                this._removeClass( currentMenu.find( \".ui-state-active\" ), null, \"ui-state-active\" );\n\n                this.activeMenu = currentMenu;\n            }, all ? 0 : this.delay );\n        },\n\n        // With no arguments, closes the currently active menu - if nothing is active\n        // it closes all menus.  If passed an argument, it will search for menus BELOW\n        _close: function( startMenu ) {\n            if ( !startMenu ) {\n                startMenu = this.active ? this.active.parent() : this.element;\n            }\n\n            startMenu.find( \".ui-menu\" )\n                .hide()\n                .attr( \"aria-hidden\", \"true\" )\n                .attr( \"aria-expanded\", \"false\" );\n        },\n\n        _closeOnDocumentClick: function( event ) {\n            return !$( event.target ).closest( \".ui-menu\" ).length;\n        },\n\n        _isDivider: function( item ) {\n\n            // Match hyphen, em dash, en dash\n            return !/[^\\-\\u2014\\u2013\\s]/.test( item.text() );\n        },\n\n        collapse: function( event ) {\n            var newItem = this.active &&\n                this.active.parent().closest( \".ui-menu-item\", this.element );\n            if ( newItem && newItem.length ) {\n                this._close();\n                this.focus( event, newItem );\n            }\n        },\n\n        expand: function( event ) {\n            var newItem = this.active && this._menuItems( this.active.children( \".ui-menu\" ) ).first();\n\n            if ( newItem && newItem.length ) {\n                this._open( newItem.parent() );\n\n                // Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n                this._delay( function() {\n                    this.focus( event, newItem );\n                } );\n            }\n        },\n\n        next: function( event ) {\n            this._move( \"next\", \"first\", event );\n        },\n\n        previous: function( event ) {\n            this._move( \"prev\", \"last\", event );\n        },\n\n        isFirstItem: function() {\n            return this.active && !this.active.prevAll( \".ui-menu-item\" ).length;\n        },\n\n        isLastItem: function() {\n            return this.active && !this.active.nextAll( \".ui-menu-item\" ).length;\n        },\n\n        _menuItems: function( menu ) {\n            return ( menu || this.element )\n                .find( this.options.items )\n                .filter( \".ui-menu-item\" );\n        },\n\n        _move: function( direction, filter, event ) {\n            var next;\n            if ( this.active ) {\n                if ( direction === \"first\" || direction === \"last\" ) {\n                    next = this.active\n                        [ direction === \"first\" ? \"prevAll\" : \"nextAll\" ]( \".ui-menu-item\" )\n                        .last();\n                } else {\n                    next = this.active\n                        [ direction + \"All\" ]( \".ui-menu-item\" )\n                        .first();\n                }\n            }\n            if ( !next || !next.length || !this.active ) {\n                next = this._menuItems( this.activeMenu )[ filter ]();\n            }\n\n            this.focus( event, next );\n        },\n\n        nextPage: function( event ) {\n            var item, base, height;\n\n            if ( !this.active ) {\n                this.next( event );\n                return;\n            }\n            if ( this.isLastItem() ) {\n                return;\n            }\n            if ( this._hasScroll() ) {\n                base = this.active.offset().top;\n                height = this.element.innerHeight();\n\n                // jQuery 3.2 doesn't include scrollbars in innerHeight, add it back.\n                if ( $.fn.jquery.indexOf( \"3.2.\" ) === 0 ) {\n                    height += this.element[ 0 ].offsetHeight - this.element.outerHeight();\n                }\n\n                this.active.nextAll( \".ui-menu-item\" ).each( function() {\n                    item = $( this );\n                    return item.offset().top - base - height < 0;\n                } );\n\n                this.focus( event, item );\n            } else {\n                this.focus( event, this._menuItems( this.activeMenu )\n                    [ !this.active ? \"first\" : \"last\" ]() );\n            }\n        },\n\n        previousPage: function( event ) {\n            var item, base, height;\n            if ( !this.active ) {\n                this.next( event );\n                return;\n            }\n            if ( this.isFirstItem() ) {\n                return;\n            }\n            if ( this._hasScroll() ) {\n                base = this.active.offset().top;\n                height = this.element.innerHeight();\n\n                // jQuery 3.2 doesn't include scrollbars in innerHeight, add it back.\n                if ( $.fn.jquery.indexOf( \"3.2.\" ) === 0 ) {\n                    height += this.element[ 0 ].offsetHeight - this.element.outerHeight();\n                }\n\n                this.active.prevAll( \".ui-menu-item\" ).each( function() {\n                    item = $( this );\n                    return item.offset().top - base + height > 0;\n                } );\n\n                this.focus( event, item );\n            } else {\n                this.focus( event, this._menuItems( this.activeMenu ).first() );\n            }\n        },\n\n        _hasScroll: function() {\n            return this.element.outerHeight() < this.element.prop( \"scrollHeight\" );\n        },\n\n        select: function( event ) {\n\n            // TODO: It should never be possible to not have an active item at this\n            // point, but the tests don't trigger mouseenter before click.\n            this.active = this.active || $( event.target ).closest( \".ui-menu-item\" );\n            var ui = { item: this.active };\n            if ( !this.active.has( \".ui-menu\" ).length ) {\n                this.collapseAll( event, true );\n            }\n            this._trigger( \"select\", event, ui );\n        },\n\n        _filterMenuItems: function( character ) {\n            var escapedCharacter = character.replace( /[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\" ),\n                regex = new RegExp( \"^\" + escapedCharacter, \"i\" );\n\n            return this.activeMenu\n                .find( this.options.items )\n\n                // Only match on items, not dividers or other content (#10571)\n                .filter( \".ui-menu-item\" )\n                .filter( function() {\n                    return regex.test(\n                        String.prototype.trim.call(\n                            $( this ).children( \".ui-menu-item-wrapper\" ).text() ) );\n                } );\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/slider.js":"/*!\n * jQuery UI Slider 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Slider\n//>>group: Widgets\n//>>description: Displays a flexible slider with ranges and accessibility via keyboard.\n//>>docs: http://api.jqueryui.com/slider/\n//>>demos: http://jqueryui.com/slider/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/slider.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../keycode\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.slider\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"slide\",\n\n        options: {\n            animate: false,\n            classes: {\n                \"ui-slider\": \"ui-corner-all\",\n                \"ui-slider-handle\": \"ui-corner-all\",\n\n                // Note: ui-widget-header isn't the most fittingly semantic framework class for this\n                // element, but worked best visually with a variety of themes\n                \"ui-slider-range\": \"ui-corner-all ui-widget-header\"\n            },\n            distance: 0,\n            max: 100,\n            min: 0,\n            orientation: \"horizontal\",\n            range: false,\n            step: 1,\n            value: 0,\n            values: null,\n\n            // Callbacks\n            change: null,\n            slide: null,\n            start: null,\n            stop: null\n        },\n\n        // Number of pages in a slider\n        // (how many times can you page up/down to go through the whole range)\n        numPages: 5,\n\n        _create: function() {\n            this._keySliding = false;\n            this._mouseSliding = false;\n            this._animateOff = true;\n            this._handleIndex = null;\n            this._detectOrientation();\n            this._mouseInit();\n            this._calculateNewMax();\n\n            this._addClass( \"ui-slider ui-slider-\" + this.orientation,\n                \"ui-widget ui-widget-content\" );\n\n            this._refresh();\n\n            this._animateOff = false;\n        },\n\n        _refresh: function() {\n            this._createRange();\n            this._createHandles();\n            this._setupEvents();\n            this._refreshValue();\n        },\n\n        _createHandles: function() {\n            var i, handleCount,\n                options = this.options,\n                existingHandles = this.element.find( \".ui-slider-handle\" ),\n                handle = \"<span tabindex='0'></span>\",\n                handles = [];\n\n            handleCount = ( options.values && options.values.length ) || 1;\n\n            if ( existingHandles.length > handleCount ) {\n                existingHandles.slice( handleCount ).remove();\n                existingHandles = existingHandles.slice( 0, handleCount );\n            }\n\n            for ( i = existingHandles.length; i < handleCount; i++ ) {\n                handles.push( handle );\n            }\n\n            this.handles = existingHandles.add( $( handles.join( \"\" ) ).appendTo( this.element ) );\n\n            this._addClass( this.handles, \"ui-slider-handle\", \"ui-state-default\" );\n\n            this.handle = this.handles.eq( 0 );\n\n            this.handles.each( function( i ) {\n                $( this )\n                    .data( \"ui-slider-handle-index\", i )\n                    .attr( \"tabIndex\", 0 );\n            } );\n        },\n\n        _createRange: function() {\n            var options = this.options;\n\n            if ( options.range ) {\n                if ( options.range === true ) {\n                    if ( !options.values ) {\n                        options.values = [ this._valueMin(), this._valueMin() ];\n                    } else if ( options.values.length && options.values.length !== 2 ) {\n                        options.values = [ options.values[ 0 ], options.values[ 0 ] ];\n                    } else if ( Array.isArray( options.values ) ) {\n                        options.values = options.values.slice( 0 );\n                    }\n                }\n\n                if ( !this.range || !this.range.length ) {\n                    this.range = $( \"<div>\" )\n                        .appendTo( this.element );\n\n                    this._addClass( this.range, \"ui-slider-range\" );\n                } else {\n                    this._removeClass( this.range, \"ui-slider-range-min ui-slider-range-max\" );\n\n                    // Handle range switching from true to min/max\n                    this.range.css( {\n                        \"left\": \"\",\n                        \"bottom\": \"\"\n                    } );\n                }\n                if ( options.range === \"min\" || options.range === \"max\" ) {\n                    this._addClass( this.range, \"ui-slider-range-\" + options.range );\n                }\n            } else {\n                if ( this.range ) {\n                    this.range.remove();\n                }\n                this.range = null;\n            }\n        },\n\n        _setupEvents: function() {\n            this._off( this.handles );\n            this._on( this.handles, this._handleEvents );\n            this._hoverable( this.handles );\n            this._focusable( this.handles );\n        },\n\n        _destroy: function() {\n            this.handles.remove();\n            if ( this.range ) {\n                this.range.remove();\n            }\n\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function( event ) {\n            var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,\n                that = this,\n                o = this.options;\n\n            if ( o.disabled ) {\n                return false;\n            }\n\n            this.elementSize = {\n                width: this.element.outerWidth(),\n                height: this.element.outerHeight()\n            };\n            this.elementOffset = this.element.offset();\n\n            position = { x: event.pageX, y: event.pageY };\n            normValue = this._normValueFromMouse( position );\n            distance = this._valueMax() - this._valueMin() + 1;\n            this.handles.each( function( i ) {\n                var thisDistance = Math.abs( normValue - that.values( i ) );\n                if ( ( distance > thisDistance ) ||\n                    ( distance === thisDistance &&\n                        ( i === that._lastChangedValue || that.values( i ) === o.min ) ) ) {\n                    distance = thisDistance;\n                    closestHandle = $( this );\n                    index = i;\n                }\n            } );\n\n            allowed = this._start( event, index );\n            if ( allowed === false ) {\n                return false;\n            }\n            this._mouseSliding = true;\n\n            this._handleIndex = index;\n\n            this._addClass( closestHandle, null, \"ui-state-active\" );\n            closestHandle.trigger( \"focus\" );\n\n            offset = closestHandle.offset();\n            mouseOverHandle = !$( event.target ).parents().addBack().is( \".ui-slider-handle\" );\n            this._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {\n                left: event.pageX - offset.left - ( closestHandle.width() / 2 ),\n                top: event.pageY - offset.top -\n                    ( closestHandle.height() / 2 ) -\n                    ( parseInt( closestHandle.css( \"borderTopWidth\" ), 10 ) || 0 ) -\n                    ( parseInt( closestHandle.css( \"borderBottomWidth\" ), 10 ) || 0 ) +\n                    ( parseInt( closestHandle.css( \"marginTop\" ), 10 ) || 0 )\n            };\n\n            if ( !this.handles.hasClass( \"ui-state-hover\" ) ) {\n                this._slide( event, index, normValue );\n            }\n            this._animateOff = true;\n            return true;\n        },\n\n        _mouseStart: function() {\n            return true;\n        },\n\n        _mouseDrag: function( event ) {\n            var position = { x: event.pageX, y: event.pageY },\n                normValue = this._normValueFromMouse( position );\n\n            this._slide( event, this._handleIndex, normValue );\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n            this._removeClass( this.handles, null, \"ui-state-active\" );\n            this._mouseSliding = false;\n\n            this._stop( event, this._handleIndex );\n            this._change( event, this._handleIndex );\n\n            this._handleIndex = null;\n            this._clickOffset = null;\n            this._animateOff = false;\n\n            return false;\n        },\n\n        _detectOrientation: function() {\n            this.orientation = ( this.options.orientation === \"vertical\" ) ? \"vertical\" : \"horizontal\";\n        },\n\n        _normValueFromMouse: function( position ) {\n            var pixelTotal,\n                pixelMouse,\n                percentMouse,\n                valueTotal,\n                valueMouse;\n\n            if ( this.orientation === \"horizontal\" ) {\n                pixelTotal = this.elementSize.width;\n                pixelMouse = position.x - this.elementOffset.left -\n                    ( this._clickOffset ? this._clickOffset.left : 0 );\n            } else {\n                pixelTotal = this.elementSize.height;\n                pixelMouse = position.y - this.elementOffset.top -\n                    ( this._clickOffset ? this._clickOffset.top : 0 );\n            }\n\n            percentMouse = ( pixelMouse / pixelTotal );\n            if ( percentMouse > 1 ) {\n                percentMouse = 1;\n            }\n            if ( percentMouse < 0 ) {\n                percentMouse = 0;\n            }\n            if ( this.orientation === \"vertical\" ) {\n                percentMouse = 1 - percentMouse;\n            }\n\n            valueTotal = this._valueMax() - this._valueMin();\n            valueMouse = this._valueMin() + percentMouse * valueTotal;\n\n            return this._trimAlignValue( valueMouse );\n        },\n\n        _uiHash: function( index, value, values ) {\n            var uiHash = {\n                handle: this.handles[ index ],\n                handleIndex: index,\n                value: value !== undefined ? value : this.value()\n            };\n\n            if ( this._hasMultipleValues() ) {\n                uiHash.value = value !== undefined ? value : this.values( index );\n                uiHash.values = values || this.values();\n            }\n\n            return uiHash;\n        },\n\n        _hasMultipleValues: function() {\n            return this.options.values && this.options.values.length;\n        },\n\n        _start: function( event, index ) {\n            return this._trigger( \"start\", event, this._uiHash( index ) );\n        },\n\n        _slide: function( event, index, newVal ) {\n            var allowed, otherVal,\n                currentValue = this.value(),\n                newValues = this.values();\n\n            if ( this._hasMultipleValues() ) {\n                otherVal = this.values( index ? 0 : 1 );\n                currentValue = this.values( index );\n\n                if ( this.options.values.length === 2 && this.options.range === true ) {\n                    newVal =  index === 0 ? Math.min( otherVal, newVal ) : Math.max( otherVal, newVal );\n                }\n\n                newValues[ index ] = newVal;\n            }\n\n            if ( newVal === currentValue ) {\n                return;\n            }\n\n            allowed = this._trigger( \"slide\", event, this._uiHash( index, newVal, newValues ) );\n\n            // A slide can be canceled by returning false from the slide callback\n            if ( allowed === false ) {\n                return;\n            }\n\n            if ( this._hasMultipleValues() ) {\n                this.values( index, newVal );\n            } else {\n                this.value( newVal );\n            }\n        },\n\n        _stop: function( event, index ) {\n            this._trigger( \"stop\", event, this._uiHash( index ) );\n        },\n\n        _change: function( event, index ) {\n            if ( !this._keySliding && !this._mouseSliding ) {\n\n                //store the last changed value index for reference when handles overlap\n                this._lastChangedValue = index;\n                this._trigger( \"change\", event, this._uiHash( index ) );\n            }\n        },\n\n        value: function( newValue ) {\n            if ( arguments.length ) {\n                this.options.value = this._trimAlignValue( newValue );\n                this._refreshValue();\n                this._change( null, 0 );\n                return;\n            }\n\n            return this._value();\n        },\n\n        values: function( index, newValue ) {\n            var vals,\n                newValues,\n                i;\n\n            if ( arguments.length > 1 ) {\n                this.options.values[ index ] = this._trimAlignValue( newValue );\n                this._refreshValue();\n                this._change( null, index );\n                return;\n            }\n\n            if ( arguments.length ) {\n                if ( Array.isArray( arguments[ 0 ] ) ) {\n                    vals = this.options.values;\n                    newValues = arguments[ 0 ];\n                    for ( i = 0; i < vals.length; i += 1 ) {\n                        vals[ i ] = this._trimAlignValue( newValues[ i ] );\n                        this._change( null, i );\n                    }\n                    this._refreshValue();\n                } else {\n                    if ( this._hasMultipleValues() ) {\n                        return this._values( index );\n                    } else {\n                        return this.value();\n                    }\n                }\n            } else {\n                return this._values();\n            }\n        },\n\n        _setOption: function( key, value ) {\n            var i,\n                valsLength = 0;\n\n            if ( key === \"range\" && this.options.range === true ) {\n                if ( value === \"min\" ) {\n                    this.options.value = this._values( 0 );\n                    this.options.values = null;\n                } else if ( value === \"max\" ) {\n                    this.options.value = this._values( this.options.values.length - 1 );\n                    this.options.values = null;\n                }\n            }\n\n            if ( Array.isArray( this.options.values ) ) {\n                valsLength = this.options.values.length;\n            }\n\n            this._super( key, value );\n\n            switch ( key ) {\n                case \"orientation\":\n                    this._detectOrientation();\n                    this._removeClass( \"ui-slider-horizontal ui-slider-vertical\" )\n                        ._addClass( \"ui-slider-\" + this.orientation );\n                    this._refreshValue();\n                    if ( this.options.range ) {\n                        this._refreshRange( value );\n                    }\n\n                    // Reset positioning from previous orientation\n                    this.handles.css( value === \"horizontal\" ? \"bottom\" : \"left\", \"\" );\n                    break;\n                case \"value\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._change( null, 0 );\n                    this._animateOff = false;\n                    break;\n                case \"values\":\n                    this._animateOff = true;\n                    this._refreshValue();\n\n                    // Start from the last handle to prevent unreachable handles (#9046)\n                    for ( i = valsLength - 1; i >= 0; i-- ) {\n                        this._change( null, i );\n                    }\n                    this._animateOff = false;\n                    break;\n                case \"step\":\n                case \"min\":\n                case \"max\":\n                    this._animateOff = true;\n                    this._calculateNewMax();\n                    this._refreshValue();\n                    this._animateOff = false;\n                    break;\n                case \"range\":\n                    this._animateOff = true;\n                    this._refresh();\n                    this._animateOff = false;\n                    break;\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n        },\n\n        //internal value getter\n        // _value() returns value trimmed by min and max, aligned by step\n        _value: function() {\n            var val = this.options.value;\n            val = this._trimAlignValue( val );\n\n            return val;\n        },\n\n        //internal values getter\n        // _values() returns array of values trimmed by min and max, aligned by step\n        // _values( index ) returns single value trimmed by min and max, aligned by step\n        _values: function( index ) {\n            var val,\n                vals,\n                i;\n\n            if ( arguments.length ) {\n                val = this.options.values[ index ];\n                val = this._trimAlignValue( val );\n\n                return val;\n            } else if ( this._hasMultipleValues() ) {\n\n                // .slice() creates a copy of the array\n                // this copy gets trimmed by min and max and then returned\n                vals = this.options.values.slice();\n                for ( i = 0; i < vals.length; i += 1 ) {\n                    vals[ i ] = this._trimAlignValue( vals[ i ] );\n                }\n\n                return vals;\n            } else {\n                return [];\n            }\n        },\n\n        // Returns the step-aligned value that val is closest to, between (inclusive) min and max\n        _trimAlignValue: function( val ) {\n            if ( val <= this._valueMin() ) {\n                return this._valueMin();\n            }\n            if ( val >= this._valueMax() ) {\n                return this._valueMax();\n            }\n            var step = ( this.options.step > 0 ) ? this.options.step : 1,\n                valModStep = ( val - this._valueMin() ) % step,\n                alignValue = val - valModStep;\n\n            if ( Math.abs( valModStep ) * 2 >= step ) {\n                alignValue += ( valModStep > 0 ) ? step : ( -step );\n            }\n\n            // Since JavaScript has problems with large floats, round\n            // the final value to 5 digits after the decimal point (see #4124)\n            return parseFloat( alignValue.toFixed( 5 ) );\n        },\n\n        _calculateNewMax: function() {\n            var max = this.options.max,\n                min = this._valueMin(),\n                step = this.options.step,\n                aboveMin = Math.round( ( max - min ) / step ) * step;\n            max = aboveMin + min;\n            if ( max > this.options.max ) {\n\n                //If max is not divisible by step, rounding off may increase its value\n                max -= step;\n            }\n            this.max = parseFloat( max.toFixed( this._precision() ) );\n        },\n\n        _precision: function() {\n            var precision = this._precisionOf( this.options.step );\n            if ( this.options.min !== null ) {\n                precision = Math.max( precision, this._precisionOf( this.options.min ) );\n            }\n            return precision;\n        },\n\n        _precisionOf: function( num ) {\n            var str = num.toString(),\n                decimal = str.indexOf( \".\" );\n            return decimal === -1 ? 0 : str.length - decimal - 1;\n        },\n\n        _valueMin: function() {\n            return this.options.min;\n        },\n\n        _valueMax: function() {\n            return this.max;\n        },\n\n        _refreshRange: function( orientation ) {\n            if ( orientation === \"vertical\" ) {\n                this.range.css( { \"width\": \"\", \"left\": \"\" } );\n            }\n            if ( orientation === \"horizontal\" ) {\n                this.range.css( { \"height\": \"\", \"bottom\": \"\" } );\n            }\n        },\n\n        _refreshValue: function() {\n            var lastValPercent, valPercent, value, valueMin, valueMax,\n                oRange = this.options.range,\n                o = this.options,\n                that = this,\n                animate = ( !this._animateOff ) ? o.animate : false,\n                _set = {};\n\n            if ( this._hasMultipleValues() ) {\n                this.handles.each( function( i ) {\n                    valPercent = ( that.values( i ) - that._valueMin() ) / ( that._valueMax() -\n                        that._valueMin() ) * 100;\n                    _set[ that.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n                    $( this ).stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n                    if ( that.options.range === true ) {\n                        if ( that.orientation === \"horizontal\" ) {\n                            if ( i === 0 ) {\n                                that.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                                    left: valPercent + \"%\"\n                                }, o.animate );\n                            }\n                            if ( i === 1 ) {\n                                that.range[ animate ? \"animate\" : \"css\" ]( {\n                                    width: ( valPercent - lastValPercent ) + \"%\"\n                                }, {\n                                    queue: false,\n                                    duration: o.animate\n                                } );\n                            }\n                        } else {\n                            if ( i === 0 ) {\n                                that.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                                    bottom: ( valPercent ) + \"%\"\n                                }, o.animate );\n                            }\n                            if ( i === 1 ) {\n                                that.range[ animate ? \"animate\" : \"css\" ]( {\n                                    height: ( valPercent - lastValPercent ) + \"%\"\n                                }, {\n                                    queue: false,\n                                    duration: o.animate\n                                } );\n                            }\n                        }\n                    }\n                    lastValPercent = valPercent;\n                } );\n            } else {\n                value = this.value();\n                valueMin = this._valueMin();\n                valueMax = this._valueMax();\n                valPercent = ( valueMax !== valueMin ) ?\n                    ( value - valueMin ) / ( valueMax - valueMin ) * 100 :\n                    0;\n                _set[ this.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n                this.handle.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n\n                if ( oRange === \"min\" && this.orientation === \"horizontal\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        width: valPercent + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"max\" && this.orientation === \"horizontal\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        width: ( 100 - valPercent ) + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"min\" && this.orientation === \"vertical\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        height: valPercent + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"max\" && this.orientation === \"vertical\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        height: ( 100 - valPercent ) + \"%\"\n                    }, o.animate );\n                }\n            }\n        },\n\n        _handleEvents: {\n            keydown: function( event ) {\n                var allowed, curVal, newVal, step,\n                    index = $( event.target ).data( \"ui-slider-handle-index\" );\n\n                switch ( event.keyCode ) {\n                    case $.ui.keyCode.HOME:\n                    case $.ui.keyCode.END:\n                    case $.ui.keyCode.PAGE_UP:\n                    case $.ui.keyCode.PAGE_DOWN:\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        event.preventDefault();\n                        if ( !this._keySliding ) {\n                            this._keySliding = true;\n                            this._addClass( $( event.target ), null, \"ui-state-active\" );\n                            allowed = this._start( event, index );\n                            if ( allowed === false ) {\n                                return;\n                            }\n                        }\n                        break;\n                }\n\n                step = this.options.step;\n                if ( this._hasMultipleValues() ) {\n                    curVal = newVal = this.values( index );\n                } else {\n                    curVal = newVal = this.value();\n                }\n\n                switch ( event.keyCode ) {\n                    case $.ui.keyCode.HOME:\n                        newVal = this._valueMin();\n                        break;\n                    case $.ui.keyCode.END:\n                        newVal = this._valueMax();\n                        break;\n                    case $.ui.keyCode.PAGE_UP:\n                        newVal = this._trimAlignValue(\n                            curVal + ( ( this._valueMax() - this._valueMin() ) / this.numPages )\n                        );\n                        break;\n                    case $.ui.keyCode.PAGE_DOWN:\n                        newVal = this._trimAlignValue(\n                            curVal - ( ( this._valueMax() - this._valueMin() ) / this.numPages ) );\n                        break;\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                        if ( curVal === this._valueMax() ) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue( curVal + step );\n                        break;\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        if ( curVal === this._valueMin() ) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue( curVal - step );\n                        break;\n                }\n\n                this._slide( event, index, newVal );\n            },\n            keyup: function( event ) {\n                var index = $( event.target ).data( \"ui-slider-handle-index\" );\n\n                if ( this._keySliding ) {\n                    this._keySliding = false;\n                    this._stop( event, index );\n                    this._change( event, index );\n                    this._removeClass( $( event.target ), null, \"ui-state-active\" );\n                }\n            }\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/mouse.js":"/*!\n * jQuery UI Mouse 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Mouse\n//>>group: Widgets\n//>>description: Abstracts mouse-based interactions to assist in creating certain widgets.\n//>>docs: http://api.jqueryui.com/mouse/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../ie\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var mouseHandled = false;\n    $( document ).on( \"mouseup\", function() {\n        mouseHandled = false;\n    } );\n\n    return $.widget( \"ui.mouse\", {\n        version: \"1.13.2\",\n        options: {\n            cancel: \"input, textarea, button, select, option\",\n            distance: 1,\n            delay: 0\n        },\n        _mouseInit: function() {\n            var that = this;\n\n            this.element\n                .on( \"mousedown.\" + this.widgetName, function( event ) {\n                    return that._mouseDown( event );\n                } )\n                .on( \"click.\" + this.widgetName, function( event ) {\n                    if ( true === $.data( event.target, that.widgetName + \".preventClickEvent\" ) ) {\n                        $.removeData( event.target, that.widgetName + \".preventClickEvent\" );\n                        event.stopImmediatePropagation();\n                        return false;\n                    }\n                } );\n\n            this.started = false;\n        },\n\n        // TODO: make sure destroying one instance of mouse doesn't mess with\n        // other instances of mouse\n        _mouseDestroy: function() {\n            this.element.off( \".\" + this.widgetName );\n            if ( this._mouseMoveDelegate ) {\n                this.document\n                    .off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                    .off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n            }\n        },\n\n        _mouseDown: function( event ) {\n\n            // don't let more than one widget handle mouseStart\n            if ( mouseHandled ) {\n                return;\n            }\n\n            this._mouseMoved = false;\n\n            // We may have missed mouseup (out of window)\n            if ( this._mouseStarted ) {\n                this._mouseUp( event );\n            }\n\n            this._mouseDownEvent = event;\n\n            var that = this,\n                btnIsLeft = ( event.which === 1 ),\n\n                // event.target.nodeName works around a bug in IE 8 with\n                // disabled inputs (#7620)\n                elIsCancel = ( typeof this.options.cancel === \"string\" && event.target.nodeName ?\n                    $( event.target ).closest( this.options.cancel ).length : false );\n            if ( !btnIsLeft || elIsCancel || !this._mouseCapture( event ) ) {\n                return true;\n            }\n\n            this.mouseDelayMet = !this.options.delay;\n            if ( !this.mouseDelayMet ) {\n                this._mouseDelayTimer = setTimeout( function() {\n                    that.mouseDelayMet = true;\n                }, this.options.delay );\n            }\n\n            if ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n                this._mouseStarted = ( this._mouseStart( event ) !== false );\n                if ( !this._mouseStarted ) {\n                    event.preventDefault();\n                    return true;\n                }\n            }\n\n            // Click event may never have fired (Gecko & Opera)\n            if ( true === $.data( event.target, this.widgetName + \".preventClickEvent\" ) ) {\n                $.removeData( event.target, this.widgetName + \".preventClickEvent\" );\n            }\n\n            // These delegates are required to keep context\n            this._mouseMoveDelegate = function( event ) {\n                return that._mouseMove( event );\n            };\n            this._mouseUpDelegate = function( event ) {\n                return that._mouseUp( event );\n            };\n\n            this.document\n                .on( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                .on( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n            event.preventDefault();\n\n            mouseHandled = true;\n            return true;\n        },\n\n        _mouseMove: function( event ) {\n\n            // Only check for mouseups outside the document if you've moved inside the document\n            // at least once. This prevents the firing of mouseup in the case of IE<9, which will\n            // fire a mousemove event if content is placed under the cursor. See #7778\n            // Support: IE <9\n            if ( this._mouseMoved ) {\n\n                // IE mouseup check - mouseup happened when mouse was out of window\n                if ( $.ui.ie && ( !document.documentMode || document.documentMode < 9 ) &&\n                    !event.button ) {\n                    return this._mouseUp( event );\n\n                    // Iframe mouseup check - mouseup occurred in another document\n                } else if ( !event.which ) {\n\n                    // Support: Safari <=8 - 9\n                    // Safari sets which to 0 if you press any of the following keys\n                    // during a drag (#14461)\n                    if ( event.originalEvent.altKey || event.originalEvent.ctrlKey ||\n                        event.originalEvent.metaKey || event.originalEvent.shiftKey ) {\n                        this.ignoreMissingWhich = true;\n                    } else if ( !this.ignoreMissingWhich ) {\n                        return this._mouseUp( event );\n                    }\n                }\n            }\n\n            if ( event.which || event.button ) {\n                this._mouseMoved = true;\n            }\n\n            if ( this._mouseStarted ) {\n                this._mouseDrag( event );\n                return event.preventDefault();\n            }\n\n            if ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n                this._mouseStarted =\n                    ( this._mouseStart( this._mouseDownEvent, event ) !== false );\n                if ( this._mouseStarted ) {\n                    this._mouseDrag( event );\n                } else {\n                    this._mouseUp( event );\n                }\n            }\n\n            return !this._mouseStarted;\n        },\n\n        _mouseUp: function( event ) {\n            this.document\n                .off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                .off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n            if ( this._mouseStarted ) {\n                this._mouseStarted = false;\n\n                if ( event.target === this._mouseDownEvent.target ) {\n                    $.data( event.target, this.widgetName + \".preventClickEvent\", true );\n                }\n\n                this._mouseStop( event );\n            }\n\n            if ( this._mouseDelayTimer ) {\n                clearTimeout( this._mouseDelayTimer );\n                delete this._mouseDelayTimer;\n            }\n\n            this.ignoreMissingWhich = false;\n            mouseHandled = false;\n            event.preventDefault();\n        },\n\n        _mouseDistanceMet: function( event ) {\n            return ( Math.max(\n                    Math.abs( this._mouseDownEvent.pageX - event.pageX ),\n                    Math.abs( this._mouseDownEvent.pageY - event.pageY )\n                ) >= this.options.distance\n            );\n        },\n\n        _mouseDelayMet: function( /* event */ ) {\n            return this.mouseDelayMet;\n        },\n\n        // These are placeholder methods, to be overriden by extending plugin\n        _mouseStart: function( /* event */ ) {},\n        _mouseDrag: function( /* event */ ) {},\n        _mouseStop: function( /* event */ ) {},\n        _mouseCapture: function( /* event */ ) {\n            return true;\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/datepicker.js":"/* eslint-disable max-len, camelcase */\n/*!\n * jQuery UI Datepicker 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Datepicker\n//>>group: Widgets\n//>>description: Displays a calendar from an input or inline for selecting dates.\n//>>docs: http://api.jqueryui.com/datepicker/\n//>>demos: http://jqueryui.com/datepicker/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/datepicker.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../keycode\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.extend( $.ui, { datepicker: { version: \"1.13.2\" } } );\n\n    var datepicker_instActive;\n\n    function datepicker_getZindex( elem ) {\n        var position, value;\n        while ( elem.length && elem[ 0 ] !== document ) {\n\n            // Ignore z-index if position is set to a value where z-index is ignored by the browser\n            // This makes behavior of this function consistent across browsers\n            // WebKit always returns auto if the element is positioned\n            position = elem.css( \"position\" );\n            if ( position === \"absolute\" || position === \"relative\" || position === \"fixed\" ) {\n\n                // IE returns 0 when zIndex is not specified\n                // other browsers return a string\n                // we ignore the case of nested elements with an explicit value of 0\n                // <div style=\"z-index: -10;\"><div style=\"z-index: 0;\"></div></div>\n                value = parseInt( elem.css( \"zIndex\" ), 10 );\n                if ( !isNaN( value ) && value !== 0 ) {\n                    return value;\n                }\n            }\n            elem = elem.parent();\n        }\n\n        return 0;\n    }\n\n    /* Date picker manager.\n       Use the singleton instance of this class, $.datepicker, to interact with the date picker.\n       Settings for (groups of) date pickers are maintained in an instance object,\n       allowing multiple different settings on the same page. */\n\n    function Datepicker() {\n        this._curInst = null; // The current instance in use\n        this._keyEvent = false; // If the last event was a key event\n        this._disabledInputs = []; // List of date picker inputs that have been disabled\n        this._datepickerShowing = false; // True if the popup picker is showing , false if not\n        this._inDialog = false; // True if showing within a \"dialog\", false if not\n        this._mainDivId = \"ui-datepicker-div\"; // The ID of the main datepicker division\n        this._inlineClass = \"ui-datepicker-inline\"; // The name of the inline marker class\n        this._appendClass = \"ui-datepicker-append\"; // The name of the append marker class\n        this._triggerClass = \"ui-datepicker-trigger\"; // The name of the trigger marker class\n        this._dialogClass = \"ui-datepicker-dialog\"; // The name of the dialog marker class\n        this._disableClass = \"ui-datepicker-disabled\"; // The name of the disabled covering marker class\n        this._unselectableClass = \"ui-datepicker-unselectable\"; // The name of the unselectable cell marker class\n        this._currentClass = \"ui-datepicker-current-day\"; // The name of the current day marker class\n        this._dayOverClass = \"ui-datepicker-days-cell-over\"; // The name of the day hover marker class\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[ \"\" ] = { // Default regional settings\n            closeText: \"Done\", // Display text for close link\n            prevText: \"Prev\", // Display text for previous month link\n            nextText: \"Next\", // Display text for next month link\n            currentText: \"Today\", // Display text for current month link\n            monthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n                \"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ], // Names of months for drop-down and formatting\n            monthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\", \"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ], // For formatting\n            dayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ], // For formatting\n            dayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ], // For formatting\n            dayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ], // Column headings for days starting at Sunday\n            weekHeader: \"Wk\", // Column header for week of the year\n            dateFormat: \"mm/dd/yy\", // See format options on parseDate\n            firstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...\n            isRTL: false, // True if right-to-left language, false if left-to-right\n            showMonthAfterYear: false, // True if the year select precedes month, false for month then year\n            yearSuffix: \"\", // Additional text to append to the year in the month headers,\n            selectMonthLabel: \"Select month\", // Invisible label for month selector\n            selectYearLabel: \"Select year\" // Invisible label for year selector\n        };\n        this._defaults = { // Global defaults for all the date picker instances\n            showOn: \"focus\", // \"focus\" for popup on focus,\n            // \"button\" for trigger button, or \"both\" for either\n            showAnim: \"fadeIn\", // Name of jQuery animation for popup\n            showOptions: {}, // Options for enhanced animations\n            defaultDate: null, // Used when field is blank: actual date,\n            // +/-number for offset from today, null for today\n            appendText: \"\", // Display text following the input box, e.g. showing the format\n            buttonText: \"...\", // Text for trigger button\n            buttonImage: \"\", // URL for trigger button image\n            buttonImageOnly: false, // True if the image appears alone, false if it appears on a button\n            hideIfNoPrevNext: false, // True to hide next/previous month links\n            // if not applicable, false to just disable them\n            navigationAsDateFormat: false, // True if date formatting applied to prev/today/next links\n            gotoCurrent: false, // True if today link goes back to current selection instead\n            changeMonth: false, // True if month can be selected directly, false if only prev/next\n            changeYear: false, // True if year can be selected directly, false if only prev/next\n            yearRange: \"c-10:c+10\", // Range of years to display in drop-down,\n            // either relative to today's year (-nn:+nn), relative to currently displayed year\n            // (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)\n            showOtherMonths: false, // True to show dates in other months, false to leave blank\n            selectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable\n            showWeek: false, // True to show week of the year, false to not show it\n            calculateWeek: this.iso8601Week, // How to calculate the week of the year,\n            // takes a Date and returns the number of the week for it\n            shortYearCutoff: \"+10\", // Short year values < this are in the current century,\n            // > this are in the previous century,\n            // string value starting with \"+\" for current year + value\n            minDate: null, // The earliest selectable date, or null for no limit\n            maxDate: null, // The latest selectable date, or null for no limit\n            duration: \"fast\", // Duration of display/closure\n            beforeShowDay: null, // Function that takes a date and returns an array with\n            // [0] = true if selectable, false if not, [1] = custom CSS class name(s) or \"\",\n            // [2] = cell title (optional), e.g. $.datepicker.noWeekends\n            beforeShow: null, // Function that takes an input field and\n            // returns a set of custom settings for the date picker\n            onSelect: null, // Define a callback function when a date is selected\n            onChangeMonthYear: null, // Define a callback function when the month or year is changed\n            onClose: null, // Define a callback function when the datepicker is closed\n            onUpdateDatepicker: null, // Define a callback function when the datepicker is updated\n            numberOfMonths: 1, // Number of months to show at a time\n            showCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)\n            stepMonths: 1, // Number of months to step back/forward\n            stepBigMonths: 12, // Number of months to step back/forward for the big links\n            altField: \"\", // Selector for an alternate field to store selected dates into\n            altFormat: \"\", // The date format to use for the alternate field\n            constrainInput: true, // The input is constrained by the current date format\n            showButtonPanel: false, // True to show button panel, false to not show it\n            autoSize: false, // True to size the input for the date format, false to leave as is\n            disabled: false // The initial disabled state\n        };\n        $.extend( this._defaults, this.regional[ \"\" ] );\n        this.regional.en = $.extend( true, {}, this.regional[ \"\" ] );\n        this.regional[ \"en-US\" ] = $.extend( true, {}, this.regional.en );\n        this.dpDiv = datepicker_bindHover( $( \"<div id='\" + this._mainDivId + \"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\" ) );\n    }\n\n    $.extend( Datepicker.prototype, {\n\n        /* Class name added to elements to indicate already configured with a date picker. */\n        markerClassName: \"hasDatepicker\",\n\n        //Keep track of the maximum number of rows displayed (see #7043)\n        maxRows: 4,\n\n        // TODO rename to \"widget\" when switching to widget factory\n        _widgetDatepicker: function() {\n            return this.dpDiv;\n        },\n\n        /* Override the default settings for all instances of the date picker.\n         * @param  settings  object - the new settings to use as defaults (anonymous object)\n         * @return the manager object\n         */\n        setDefaults: function( settings ) {\n            datepicker_extendRemove( this._defaults, settings || {} );\n            return this;\n        },\n\n        /* Attach the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         * @param  settings  object - the new settings to use for this date picker instance (anonymous)\n         */\n        _attachDatepicker: function( target, settings ) {\n            var nodeName, inline, inst;\n            nodeName = target.nodeName.toLowerCase();\n            inline = ( nodeName === \"div\" || nodeName === \"span\" );\n            if ( !target.id ) {\n                this.uuid += 1;\n                target.id = \"dp\" + this.uuid;\n            }\n            inst = this._newInst( $( target ), inline );\n            inst.settings = $.extend( {}, settings || {} );\n            if ( nodeName === \"input\" ) {\n                this._connectDatepicker( target, inst );\n            } else if ( inline ) {\n                this._inlineDatepicker( target, inst );\n            }\n        },\n\n        /* Create a new instance object. */\n        _newInst: function( target, inline ) {\n            var id = target[ 0 ].id.replace( /([^A-Za-z0-9_\\-])/g, \"\\\\\\\\$1\" ); // escape jQuery meta chars\n            return { id: id, input: target, // associated target\n                selectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection\n                drawMonth: 0, drawYear: 0, // month being drawn\n                inline: inline, // is datepicker inline or not\n                dpDiv: ( !inline ? this.dpDiv : // presentation div\n                    datepicker_bindHover( $( \"<div class='\" + this._inlineClass + \" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\" ) ) ) };\n        },\n\n        /* Attach the date picker to an input field. */\n        _connectDatepicker: function( target, inst ) {\n            var input = $( target );\n            inst.append = $( [] );\n            inst.trigger = $( [] );\n            if ( input.hasClass( this.markerClassName ) ) {\n                return;\n            }\n            this._attachments( input, inst );\n            input.addClass( this.markerClassName ).on( \"keydown\", this._doKeyDown ).\n            on( \"keypress\", this._doKeyPress ).on( \"keyup\", this._doKeyUp );\n            this._autoSize( inst );\n            $.data( target, \"datepicker\", inst );\n\n            //If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)\n            if ( inst.settings.disabled ) {\n                this._disableDatepicker( target );\n            }\n        },\n\n        /* Make attachments based on settings. */\n        _attachments: function( input, inst ) {\n            var showOn, buttonText, buttonImage,\n                appendText = this._get( inst, \"appendText\" ),\n                isRTL = this._get( inst, \"isRTL\" );\n\n            if ( inst.append ) {\n                inst.append.remove();\n            }\n            if ( appendText ) {\n                inst.append = $( \"<span>\" )\n                    .addClass( this._appendClass )\n                    .text( appendText );\n                input[ isRTL ? \"before\" : \"after\" ]( inst.append );\n            }\n\n            input.off( \"focus\", this._showDatepicker );\n\n            if ( inst.trigger ) {\n                inst.trigger.remove();\n            }\n\n            showOn = this._get( inst, \"showOn\" );\n            if ( showOn === \"focus\" || showOn === \"both\" ) { // pop-up date picker when in the marked field\n                input.on( \"focus\", this._showDatepicker );\n            }\n            if ( showOn === \"button\" || showOn === \"both\" ) { // pop-up date picker when button clicked\n                buttonText = this._get( inst, \"buttonText\" );\n                buttonImage = this._get( inst, \"buttonImage\" );\n\n                if ( this._get( inst, \"buttonImageOnly\" ) ) {\n                    inst.trigger = $( \"<img>\" )\n                        .addClass( this._triggerClass )\n                        .attr( {\n                            src: buttonImage,\n                            alt: buttonText,\n                            title: buttonText\n                        } );\n                } else {\n                    inst.trigger = $( \"<button type='button'>\" )\n                        .addClass( this._triggerClass );\n                    if ( buttonImage ) {\n                        inst.trigger.html(\n                            $( \"<img>\" )\n                                .attr( {\n                                    src: buttonImage,\n                                    alt: buttonText,\n                                    title: buttonText\n                                } )\n                        );\n                    } else {\n                        inst.trigger.text( buttonText );\n                    }\n                }\n\n                input[ isRTL ? \"before\" : \"after\" ]( inst.trigger );\n                inst.trigger.on( \"click\", function() {\n                    if ( $.datepicker._datepickerShowing && $.datepicker._lastInput === input[ 0 ] ) {\n                        $.datepicker._hideDatepicker();\n                    } else if ( $.datepicker._datepickerShowing && $.datepicker._lastInput !== input[ 0 ] ) {\n                        $.datepicker._hideDatepicker();\n                        $.datepicker._showDatepicker( input[ 0 ] );\n                    } else {\n                        $.datepicker._showDatepicker( input[ 0 ] );\n                    }\n                    return false;\n                } );\n            }\n        },\n\n        /* Apply the maximum length for the date format. */\n        _autoSize: function( inst ) {\n            if ( this._get( inst, \"autoSize\" ) && !inst.inline ) {\n                var findMax, max, maxI, i,\n                    date = new Date( 2009, 12 - 1, 20 ), // Ensure double digits\n                    dateFormat = this._get( inst, \"dateFormat\" );\n\n                if ( dateFormat.match( /[DM]/ ) ) {\n                    findMax = function( names ) {\n                        max = 0;\n                        maxI = 0;\n                        for ( i = 0; i < names.length; i++ ) {\n                            if ( names[ i ].length > max ) {\n                                max = names[ i ].length;\n                                maxI = i;\n                            }\n                        }\n                        return maxI;\n                    };\n                    date.setMonth( findMax( this._get( inst, ( dateFormat.match( /MM/ ) ?\n                        \"monthNames\" : \"monthNamesShort\" ) ) ) );\n                    date.setDate( findMax( this._get( inst, ( dateFormat.match( /DD/ ) ?\n                        \"dayNames\" : \"dayNamesShort\" ) ) ) + 20 - date.getDay() );\n                }\n                inst.input.attr( \"size\", this._formatDate( inst, date ).length );\n            }\n        },\n\n        /* Attach an inline date picker to a div. */\n        _inlineDatepicker: function( target, inst ) {\n            var divSpan = $( target );\n            if ( divSpan.hasClass( this.markerClassName ) ) {\n                return;\n            }\n            divSpan.addClass( this.markerClassName ).append( inst.dpDiv );\n            $.data( target, \"datepicker\", inst );\n            this._setDate( inst, this._getDefaultDate( inst ), true );\n            this._updateDatepicker( inst );\n            this._updateAlternate( inst );\n\n            //If disabled option is true, disable the datepicker before showing it (see ticket #5665)\n            if ( inst.settings.disabled ) {\n                this._disableDatepicker( target );\n            }\n\n            // Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements\n            // http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height\n            inst.dpDiv.css( \"display\", \"block\" );\n        },\n\n        /* Pop-up the date picker in a \"dialog\" box.\n         * @param  input element - ignored\n         * @param  date\tstring or Date - the initial date to display\n         * @param  onSelect  function - the function to call when a date is selected\n         * @param  settings  object - update the dialog date picker instance's settings (anonymous object)\n         * @param  pos int[2] - coordinates for the dialog's position within the screen or\n         *\t\t\t\t\tevent - with x/y coordinates or\n         *\t\t\t\t\tleave empty for default (screen centre)\n         * @return the manager object\n         */\n        _dialogDatepicker: function( input, date, onSelect, settings, pos ) {\n            var id, browserWidth, browserHeight, scrollX, scrollY,\n                inst = this._dialogInst; // internal instance\n\n            if ( !inst ) {\n                this.uuid += 1;\n                id = \"dp\" + this.uuid;\n                this._dialogInput = $( \"<input type='text' id='\" + id +\n                    \"' style='position: absolute; top: -100px; width: 0px;'/>\" );\n                this._dialogInput.on( \"keydown\", this._doKeyDown );\n                $( \"body\" ).append( this._dialogInput );\n                inst = this._dialogInst = this._newInst( this._dialogInput, false );\n                inst.settings = {};\n                $.data( this._dialogInput[ 0 ], \"datepicker\", inst );\n            }\n            datepicker_extendRemove( inst.settings, settings || {} );\n            date = ( date && date.constructor === Date ? this._formatDate( inst, date ) : date );\n            this._dialogInput.val( date );\n\n            this._pos = ( pos ? ( pos.length ? pos : [ pos.pageX, pos.pageY ] ) : null );\n            if ( !this._pos ) {\n                browserWidth = document.documentElement.clientWidth;\n                browserHeight = document.documentElement.clientHeight;\n                scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;\n                scrollY = document.documentElement.scrollTop || document.body.scrollTop;\n                this._pos = // should use actual width/height below\n                    [ ( browserWidth / 2 ) - 100 + scrollX, ( browserHeight / 2 ) - 150 + scrollY ];\n            }\n\n            // Move input on screen for focus, but hidden behind dialog\n            this._dialogInput.css( \"left\", ( this._pos[ 0 ] + 20 ) + \"px\" ).css( \"top\", this._pos[ 1 ] + \"px\" );\n            inst.settings.onSelect = onSelect;\n            this._inDialog = true;\n            this.dpDiv.addClass( this._dialogClass );\n            this._showDatepicker( this._dialogInput[ 0 ] );\n            if ( $.blockUI ) {\n                $.blockUI( this.dpDiv );\n            }\n            $.data( this._dialogInput[ 0 ], \"datepicker\", inst );\n            return this;\n        },\n\n        /* Detach a datepicker from its control.\n         * @param  target\telement - the target input field or division or span\n         */\n        _destroyDatepicker: function( target ) {\n            var nodeName,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            $.removeData( target, \"datepicker\" );\n            if ( nodeName === \"input\" ) {\n                inst.append.remove();\n                inst.trigger.remove();\n                $target.removeClass( this.markerClassName ).\n                off( \"focus\", this._showDatepicker ).\n                off( \"keydown\", this._doKeyDown ).\n                off( \"keypress\", this._doKeyPress ).\n                off( \"keyup\", this._doKeyUp );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                $target.removeClass( this.markerClassName ).empty();\n            }\n\n            if ( datepicker_instActive === inst ) {\n                datepicker_instActive = null;\n                this._curInst = null;\n            }\n        },\n\n        /* Enable the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         */\n        _enableDatepicker: function( target ) {\n            var nodeName, inline,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            if ( nodeName === \"input\" ) {\n                target.disabled = false;\n                inst.trigger.filter( \"button\" ).\n                each( function() {\n                    this.disabled = false;\n                } ).end().\n                filter( \"img\" ).css( { opacity: \"1.0\", cursor: \"\" } );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                inline = $target.children( \".\" + this._inlineClass );\n                inline.children().removeClass( \"ui-state-disabled\" );\n                inline.find( \"select.ui-datepicker-month, select.ui-datepicker-year\" ).\n                prop( \"disabled\", false );\n            }\n            this._disabledInputs = $.map( this._disabledInputs,\n\n                // Delete entry\n                function( value ) {\n                    return ( value === target ? null : value );\n                } );\n        },\n\n        /* Disable the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         */\n        _disableDatepicker: function( target ) {\n            var nodeName, inline,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            if ( nodeName === \"input\" ) {\n                target.disabled = true;\n                inst.trigger.filter( \"button\" ).\n                each( function() {\n                    this.disabled = true;\n                } ).end().\n                filter( \"img\" ).css( { opacity: \"0.5\", cursor: \"default\" } );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                inline = $target.children( \".\" + this._inlineClass );\n                inline.children().addClass( \"ui-state-disabled\" );\n                inline.find( \"select.ui-datepicker-month, select.ui-datepicker-year\" ).\n                prop( \"disabled\", true );\n            }\n            this._disabledInputs = $.map( this._disabledInputs,\n\n                // Delete entry\n                function( value ) {\n                    return ( value === target ? null : value );\n                } );\n            this._disabledInputs[ this._disabledInputs.length ] = target;\n        },\n\n        /* Is the first field in a jQuery collection disabled as a datepicker?\n         * @param  target\telement - the target input field or division or span\n         * @return boolean - true if disabled, false if enabled\n         */\n        _isDisabledDatepicker: function( target ) {\n            if ( !target ) {\n                return false;\n            }\n            for ( var i = 0; i < this._disabledInputs.length; i++ ) {\n                if ( this._disabledInputs[ i ] === target ) {\n                    return true;\n                }\n            }\n            return false;\n        },\n\n        /* Retrieve the instance data for the target control.\n         * @param  target  element - the target input field or division or span\n         * @return  object - the associated instance data\n         * @throws  error if a jQuery problem getting data\n         */\n        _getInst: function( target ) {\n            try {\n                return $.data( target, \"datepicker\" );\n            } catch ( err ) {\n                throw \"Missing instance data for this datepicker\";\n            }\n        },\n\n        /* Update or retrieve the settings for a date picker attached to an input field or division.\n         * @param  target  element - the target input field or division or span\n         * @param  name\tobject - the new settings to update or\n         *\t\t\t\tstring - the name of the setting to change or retrieve,\n         *\t\t\t\twhen retrieving also \"all\" for all instance settings or\n         *\t\t\t\t\"defaults\" for all global defaults\n         * @param  value   any - the new value for the setting\n         *\t\t\t\t(omit if above is an object or to retrieve a value)\n         */\n        _optionDatepicker: function( target, name, value ) {\n            var settings, date, minDate, maxDate,\n                inst = this._getInst( target );\n\n            if ( arguments.length === 2 && typeof name === \"string\" ) {\n                return ( name === \"defaults\" ? $.extend( {}, $.datepicker._defaults ) :\n                    ( inst ? ( name === \"all\" ? $.extend( {}, inst.settings ) :\n                        this._get( inst, name ) ) : null ) );\n            }\n\n            settings = name || {};\n            if ( typeof name === \"string\" ) {\n                settings = {};\n                settings[ name ] = value;\n            }\n\n            if ( inst ) {\n                if ( this._curInst === inst ) {\n                    this._hideDatepicker();\n                }\n\n                date = this._getDateDatepicker( target, true );\n                minDate = this._getMinMaxDate( inst, \"min\" );\n                maxDate = this._getMinMaxDate( inst, \"max\" );\n                datepicker_extendRemove( inst.settings, settings );\n\n                // reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided\n                if ( minDate !== null && settings.dateFormat !== undefined && settings.minDate === undefined ) {\n                    inst.settings.minDate = this._formatDate( inst, minDate );\n                }\n                if ( maxDate !== null && settings.dateFormat !== undefined && settings.maxDate === undefined ) {\n                    inst.settings.maxDate = this._formatDate( inst, maxDate );\n                }\n                if ( \"disabled\" in settings ) {\n                    if ( settings.disabled ) {\n                        this._disableDatepicker( target );\n                    } else {\n                        this._enableDatepicker( target );\n                    }\n                }\n                this._attachments( $( target ), inst );\n                this._autoSize( inst );\n                this._setDate( inst, date );\n                this._updateAlternate( inst );\n                this._updateDatepicker( inst );\n            }\n        },\n\n        // Change method deprecated\n        _changeDatepicker: function( target, name, value ) {\n            this._optionDatepicker( target, name, value );\n        },\n\n        /* Redraw the date picker attached to an input field or division.\n         * @param  target  element - the target input field or division or span\n         */\n        _refreshDatepicker: function( target ) {\n            var inst = this._getInst( target );\n            if ( inst ) {\n                this._updateDatepicker( inst );\n            }\n        },\n\n        /* Set the dates for a jQuery selection.\n         * @param  target element - the target input field or division or span\n         * @param  date\tDate - the new date\n         */\n        _setDateDatepicker: function( target, date ) {\n            var inst = this._getInst( target );\n            if ( inst ) {\n                this._setDate( inst, date );\n                this._updateDatepicker( inst );\n                this._updateAlternate( inst );\n            }\n        },\n\n        /* Get the date(s) for the first entry in a jQuery selection.\n         * @param  target element - the target input field or division or span\n         * @param  noDefault boolean - true if no default date is to be used\n         * @return Date - the current date\n         */\n        _getDateDatepicker: function( target, noDefault ) {\n            var inst = this._getInst( target );\n            if ( inst && !inst.inline ) {\n                this._setDateFromField( inst, noDefault );\n            }\n            return ( inst ? this._getDate( inst ) : null );\n        },\n\n        /* Handle keystrokes. */\n        _doKeyDown: function( event ) {\n            var onSelect, dateStr, sel,\n                inst = $.datepicker._getInst( event.target ),\n                handled = true,\n                isRTL = inst.dpDiv.is( \".ui-datepicker-rtl\" );\n\n            inst._keyEvent = true;\n            if ( $.datepicker._datepickerShowing ) {\n                switch ( event.keyCode ) {\n                    case 9: $.datepicker._hideDatepicker();\n                        handled = false;\n                        break; // hide on tab out\n                    case 13: sel = $( \"td.\" + $.datepicker._dayOverClass + \":not(.\" +\n                        $.datepicker._currentClass + \")\", inst.dpDiv );\n                        if ( sel[ 0 ] ) {\n                            $.datepicker._selectDay( event.target, inst.selectedMonth, inst.selectedYear, sel[ 0 ] );\n                        }\n\n                        onSelect = $.datepicker._get( inst, \"onSelect\" );\n                        if ( onSelect ) {\n                            dateStr = $.datepicker._formatDate( inst );\n\n                            // Trigger custom callback\n                            onSelect.apply( ( inst.input ? inst.input[ 0 ] : null ), [ dateStr, inst ] );\n                        } else {\n                            $.datepicker._hideDatepicker();\n                        }\n\n                        return false; // don't submit the form\n                    case 27: $.datepicker._hideDatepicker();\n                        break; // hide on escape\n                    case 33: $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                        -$.datepicker._get( inst, \"stepBigMonths\" ) :\n                        -$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        break; // previous month/year on page up/+ ctrl\n                    case 34: $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                        +$.datepicker._get( inst, \"stepBigMonths\" ) :\n                        +$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        break; // next month/year on page down/+ ctrl\n                    case 35: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._clearDate( event.target );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // clear on ctrl or command +end\n                    case 36: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._gotoToday( event.target );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // current on ctrl or command +home\n                    case 37: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, ( isRTL ? +1 : -1 ), \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n\n                        // -1 day on ctrl or command +left\n                        if ( event.originalEvent.altKey ) {\n                            $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                                -$.datepicker._get( inst, \"stepBigMonths\" ) :\n                                -$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        }\n\n                        // next month/year on alt +left on Mac\n                        break;\n                    case 38: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, -7, \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // -1 week on ctrl or command +up\n                    case 39: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, ( isRTL ? -1 : +1 ), \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n\n                        // +1 day on ctrl or command +right\n                        if ( event.originalEvent.altKey ) {\n                            $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                                +$.datepicker._get( inst, \"stepBigMonths\" ) :\n                                +$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        }\n\n                        // next month/year on alt +right\n                        break;\n                    case 40: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, +7, \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // +1 week on ctrl or command +down\n                    default: handled = false;\n                }\n            } else if ( event.keyCode === 36 && event.ctrlKey ) { // display the date picker on ctrl+home\n                $.datepicker._showDatepicker( this );\n            } else {\n                handled = false;\n            }\n\n            if ( handled ) {\n                event.preventDefault();\n                event.stopPropagation();\n            }\n        },\n\n        /* Filter entered characters - based on date format. */\n        _doKeyPress: function( event ) {\n            var chars, chr,\n                inst = $.datepicker._getInst( event.target );\n\n            if ( $.datepicker._get( inst, \"constrainInput\" ) ) {\n                chars = $.datepicker._possibleChars( $.datepicker._get( inst, \"dateFormat\" ) );\n                chr = String.fromCharCode( event.charCode == null ? event.keyCode : event.charCode );\n                return event.ctrlKey || event.metaKey || ( chr < \" \" || !chars || chars.indexOf( chr ) > -1 );\n            }\n        },\n\n        /* Synchronise manual entry and field/alternate field. */\n        _doKeyUp: function( event ) {\n            var date,\n                inst = $.datepicker._getInst( event.target );\n\n            if ( inst.input.val() !== inst.lastVal ) {\n                try {\n                    date = $.datepicker.parseDate( $.datepicker._get( inst, \"dateFormat\" ),\n                        ( inst.input ? inst.input.val() : null ),\n                        $.datepicker._getFormatConfig( inst ) );\n\n                    if ( date ) { // only if valid\n                        $.datepicker._setDateFromField( inst );\n                        $.datepicker._updateAlternate( inst );\n                        $.datepicker._updateDatepicker( inst );\n                    }\n                } catch ( err ) {\n                }\n            }\n            return true;\n        },\n\n        /* Pop-up the date picker for a given input field.\n         * If false returned from beforeShow event handler do not show.\n         * @param  input  element - the input field attached to the date picker or\n         *\t\t\t\t\tevent - if triggered by focus\n         */\n        _showDatepicker: function( input ) {\n            input = input.target || input;\n            if ( input.nodeName.toLowerCase() !== \"input\" ) { // find from button/image trigger\n                input = $( \"input\", input.parentNode )[ 0 ];\n            }\n\n            if ( $.datepicker._isDisabledDatepicker( input ) || $.datepicker._lastInput === input ) { // already here\n                return;\n            }\n\n            var inst, beforeShow, beforeShowSettings, isFixed,\n                offset, showAnim, duration;\n\n            inst = $.datepicker._getInst( input );\n            if ( $.datepicker._curInst && $.datepicker._curInst !== inst ) {\n                $.datepicker._curInst.dpDiv.stop( true, true );\n                if ( inst && $.datepicker._datepickerShowing ) {\n                    $.datepicker._hideDatepicker( $.datepicker._curInst.input[ 0 ] );\n                }\n            }\n\n            beforeShow = $.datepicker._get( inst, \"beforeShow\" );\n            beforeShowSettings = beforeShow ? beforeShow.apply( input, [ input, inst ] ) : {};\n            if ( beforeShowSettings === false ) {\n                return;\n            }\n            datepicker_extendRemove( inst.settings, beforeShowSettings );\n\n            inst.lastVal = null;\n            $.datepicker._lastInput = input;\n            $.datepicker._setDateFromField( inst );\n\n            if ( $.datepicker._inDialog ) { // hide cursor\n                input.value = \"\";\n            }\n            if ( !$.datepicker._pos ) { // position below input\n                $.datepicker._pos = $.datepicker._findPos( input );\n                $.datepicker._pos[ 1 ] += input.offsetHeight; // add the height\n            }\n\n            isFixed = false;\n            $( input ).parents().each( function() {\n                isFixed |= $( this ).css( \"position\" ) === \"fixed\";\n                return !isFixed;\n            } );\n\n            offset = { left: $.datepicker._pos[ 0 ], top: $.datepicker._pos[ 1 ] };\n            $.datepicker._pos = null;\n\n            //to avoid flashes on Firefox\n            inst.dpDiv.empty();\n\n            // determine sizing offscreen\n            inst.dpDiv.css( { position: \"absolute\", display: \"block\", top: \"-1000px\" } );\n            $.datepicker._updateDatepicker( inst );\n\n            // fix width for dynamic number of date pickers\n            // and adjust position before showing\n            offset = $.datepicker._checkOffset( inst, offset, isFixed );\n            inst.dpDiv.css( { position: ( $.datepicker._inDialog && $.blockUI ?\n                    \"static\" : ( isFixed ? \"fixed\" : \"absolute\" ) ), display: \"none\",\n                left: offset.left + \"px\", top: offset.top + \"px\" } );\n\n            if ( !inst.inline ) {\n                showAnim = $.datepicker._get( inst, \"showAnim\" );\n                duration = $.datepicker._get( inst, \"duration\" );\n                inst.dpDiv.css( \"z-index\", datepicker_getZindex( $( input ) ) + 1 );\n                $.datepicker._datepickerShowing = true;\n\n                if ( $.effects && $.effects.effect[ showAnim ] ) {\n                    inst.dpDiv.show( showAnim, $.datepicker._get( inst, \"showOptions\" ), duration );\n                } else {\n                    inst.dpDiv[ showAnim || \"show\" ]( showAnim ? duration : null );\n                }\n\n                if ( $.datepicker._shouldFocusInput( inst ) ) {\n                    inst.input.trigger( \"focus\" );\n                }\n\n                $.datepicker._curInst = inst;\n            }\n        },\n\n        /* Generate the date picker content. */\n        _updateDatepicker: function( inst ) {\n            this.maxRows = 4; //Reset the max number of rows being displayed (see #7043)\n            datepicker_instActive = inst; // for delegate hover events\n            inst.dpDiv.empty().append( this._generateHTML( inst ) );\n            this._attachHandlers( inst );\n\n            var origyearshtml,\n                numMonths = this._getNumberOfMonths( inst ),\n                cols = numMonths[ 1 ],\n                width = 17,\n                activeCell = inst.dpDiv.find( \".\" + this._dayOverClass + \" a\" ),\n                onUpdateDatepicker = $.datepicker._get( inst, \"onUpdateDatepicker\" );\n\n            if ( activeCell.length > 0 ) {\n                datepicker_handleMouseover.apply( activeCell.get( 0 ) );\n            }\n\n            inst.dpDiv.removeClass( \"ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4\" ).width( \"\" );\n            if ( cols > 1 ) {\n                inst.dpDiv.addClass( \"ui-datepicker-multi-\" + cols ).css( \"width\", ( width * cols ) + \"em\" );\n            }\n            inst.dpDiv[ ( numMonths[ 0 ] !== 1 || numMonths[ 1 ] !== 1 ? \"add\" : \"remove\" ) +\n            \"Class\" ]( \"ui-datepicker-multi\" );\n            inst.dpDiv[ ( this._get( inst, \"isRTL\" ) ? \"add\" : \"remove\" ) +\n            \"Class\" ]( \"ui-datepicker-rtl\" );\n\n            if ( inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput( inst ) ) {\n                inst.input.trigger( \"focus\" );\n            }\n\n            // Deffered render of the years select (to avoid flashes on Firefox)\n            if ( inst.yearshtml ) {\n                origyearshtml = inst.yearshtml;\n                setTimeout( function() {\n\n                    //assure that inst.yearshtml didn't change.\n                    if ( origyearshtml === inst.yearshtml && inst.yearshtml ) {\n                        inst.dpDiv.find( \"select.ui-datepicker-year\" ).first().replaceWith( inst.yearshtml );\n                    }\n                    origyearshtml = inst.yearshtml = null;\n                }, 0 );\n            }\n\n            if ( onUpdateDatepicker ) {\n                onUpdateDatepicker.apply( ( inst.input ? inst.input[ 0 ] : null ), [ inst ] );\n            }\n        },\n\n        // #6694 - don't focus the input if it's already focused\n        // this breaks the change event in IE\n        // Support: IE and jQuery <1.9\n        _shouldFocusInput: function( inst ) {\n            return inst.input && inst.input.is( \":visible\" ) && !inst.input.is( \":disabled\" ) && !inst.input.is( \":focus\" );\n        },\n\n        /* Check positioning to remain on screen. */\n        _checkOffset: function( inst, offset, isFixed ) {\n            var dpWidth = inst.dpDiv.outerWidth(),\n                dpHeight = inst.dpDiv.outerHeight(),\n                inputWidth = inst.input ? inst.input.outerWidth() : 0,\n                inputHeight = inst.input ? inst.input.outerHeight() : 0,\n                viewWidth = document.documentElement.clientWidth + ( isFixed ? 0 : $( document ).scrollLeft() ),\n                viewHeight = document.documentElement.clientHeight + ( isFixed ? 0 : $( document ).scrollTop() );\n\n            offset.left -= ( this._get( inst, \"isRTL\" ) ? ( dpWidth - inputWidth ) : 0 );\n            offset.left -= ( isFixed && offset.left === inst.input.offset().left ) ? $( document ).scrollLeft() : 0;\n            offset.top -= ( isFixed && offset.top === ( inst.input.offset().top + inputHeight ) ) ? $( document ).scrollTop() : 0;\n\n            // Now check if datepicker is showing outside window viewport - move to a better place if so.\n            offset.left -= Math.min( offset.left, ( offset.left + dpWidth > viewWidth && viewWidth > dpWidth ) ?\n                Math.abs( offset.left + dpWidth - viewWidth ) : 0 );\n            offset.top -= Math.min( offset.top, ( offset.top + dpHeight > viewHeight && viewHeight > dpHeight ) ?\n                Math.abs( dpHeight + inputHeight ) : 0 );\n\n            return offset;\n        },\n\n        /* Find an object's position on the screen. */\n        _findPos: function( obj ) {\n            var position,\n                inst = this._getInst( obj ),\n                isRTL = this._get( inst, \"isRTL\" );\n\n            while ( obj && ( obj.type === \"hidden\" || obj.nodeType !== 1 || $.expr.pseudos.hidden( obj ) ) ) {\n                obj = obj[ isRTL ? \"previousSibling\" : \"nextSibling\" ];\n            }\n\n            position = $( obj ).offset();\n            return [ position.left, position.top ];\n        },\n\n        /* Hide the date picker from view.\n         * @param  input  element - the input field attached to the date picker\n         */\n        _hideDatepicker: function( input ) {\n            var showAnim, duration, postProcess, onClose,\n                inst = this._curInst;\n\n            if ( !inst || ( input && inst !== $.data( input, \"datepicker\" ) ) ) {\n                return;\n            }\n\n            if ( this._datepickerShowing ) {\n                showAnim = this._get( inst, \"showAnim\" );\n                duration = this._get( inst, \"duration\" );\n                postProcess = function() {\n                    $.datepicker._tidyDialog( inst );\n                };\n\n                // DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed\n                if ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) ) {\n                    inst.dpDiv.hide( showAnim, $.datepicker._get( inst, \"showOptions\" ), duration, postProcess );\n                } else {\n                    inst.dpDiv[ ( showAnim === \"slideDown\" ? \"slideUp\" :\n                        ( showAnim === \"fadeIn\" ? \"fadeOut\" : \"hide\" ) ) ]( ( showAnim ? duration : null ), postProcess );\n                }\n\n                if ( !showAnim ) {\n                    postProcess();\n                }\n                this._datepickerShowing = false;\n\n                onClose = this._get( inst, \"onClose\" );\n                if ( onClose ) {\n                    onClose.apply( ( inst.input ? inst.input[ 0 ] : null ), [ ( inst.input ? inst.input.val() : \"\" ), inst ] );\n                }\n\n                this._lastInput = null;\n                if ( this._inDialog ) {\n                    this._dialogInput.css( { position: \"absolute\", left: \"0\", top: \"-100px\" } );\n                    if ( $.blockUI ) {\n                        $.unblockUI();\n                        $( \"body\" ).append( this.dpDiv );\n                    }\n                }\n                this._inDialog = false;\n            }\n        },\n\n        /* Tidy up after a dialog display. */\n        _tidyDialog: function( inst ) {\n            inst.dpDiv.removeClass( this._dialogClass ).off( \".ui-datepicker-calendar\" );\n        },\n\n        /* Close date picker if clicked elsewhere. */\n        _checkExternalClick: function( event ) {\n            if ( !$.datepicker._curInst ) {\n                return;\n            }\n\n            var $target = $( event.target ),\n                inst = $.datepicker._getInst( $target[ 0 ] );\n\n            if ( ( ( $target[ 0 ].id !== $.datepicker._mainDivId &&\n                    $target.parents( \"#\" + $.datepicker._mainDivId ).length === 0 &&\n                    !$target.hasClass( $.datepicker.markerClassName ) &&\n                    !$target.closest( \".\" + $.datepicker._triggerClass ).length &&\n                    $.datepicker._datepickerShowing && !( $.datepicker._inDialog && $.blockUI ) ) ) ||\n                ( $target.hasClass( $.datepicker.markerClassName ) && $.datepicker._curInst !== inst ) ) {\n                $.datepicker._hideDatepicker();\n            }\n        },\n\n        /* Adjust one of the date sub-fields. */\n        _adjustDate: function( id, offset, period ) {\n            var target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            if ( this._isDisabledDatepicker( target[ 0 ] ) ) {\n                return;\n            }\n            this._adjustInstDate( inst, offset, period );\n            this._updateDatepicker( inst );\n        },\n\n        /* Action for current link. */\n        _gotoToday: function( id ) {\n            var date,\n                target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            if ( this._get( inst, \"gotoCurrent\" ) && inst.currentDay ) {\n                inst.selectedDay = inst.currentDay;\n                inst.drawMonth = inst.selectedMonth = inst.currentMonth;\n                inst.drawYear = inst.selectedYear = inst.currentYear;\n            } else {\n                date = new Date();\n                inst.selectedDay = date.getDate();\n                inst.drawMonth = inst.selectedMonth = date.getMonth();\n                inst.drawYear = inst.selectedYear = date.getFullYear();\n            }\n            this._notifyChange( inst );\n            this._adjustDate( target );\n        },\n\n        /* Action for selecting a new month/year. */\n        _selectMonthYear: function( id, select, period ) {\n            var target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            inst[ \"selected\" + ( period === \"M\" ? \"Month\" : \"Year\" ) ] =\n                inst[ \"draw\" + ( period === \"M\" ? \"Month\" : \"Year\" ) ] =\n                    parseInt( select.options[ select.selectedIndex ].value, 10 );\n\n            this._notifyChange( inst );\n            this._adjustDate( target );\n        },\n\n        /* Action for selecting a day. */\n        _selectDay: function( id, month, year, td ) {\n            var inst,\n                target = $( id );\n\n            if ( $( td ).hasClass( this._unselectableClass ) || this._isDisabledDatepicker( target[ 0 ] ) ) {\n                return;\n            }\n\n            inst = this._getInst( target[ 0 ] );\n            inst.selectedDay = inst.currentDay = parseInt( $( \"a\", td ).attr( \"data-date\" ) );\n            inst.selectedMonth = inst.currentMonth = month;\n            inst.selectedYear = inst.currentYear = year;\n            this._selectDate( id, this._formatDate( inst,\n                inst.currentDay, inst.currentMonth, inst.currentYear ) );\n        },\n\n        /* Erase the input field and hide the date picker. */\n        _clearDate: function( id ) {\n            var target = $( id );\n            this._selectDate( target, \"\" );\n        },\n\n        /* Update the input field with the selected date. */\n        _selectDate: function( id, dateStr ) {\n            var onSelect,\n                target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            dateStr = ( dateStr != null ? dateStr : this._formatDate( inst ) );\n            if ( inst.input ) {\n                inst.input.val( dateStr );\n            }\n            this._updateAlternate( inst );\n\n            onSelect = this._get( inst, \"onSelect\" );\n            if ( onSelect ) {\n                onSelect.apply( ( inst.input ? inst.input[ 0 ] : null ), [ dateStr, inst ] );  // trigger custom callback\n            } else if ( inst.input ) {\n                inst.input.trigger( \"change\" ); // fire the change event\n            }\n\n            if ( inst.inline ) {\n                this._updateDatepicker( inst );\n            } else {\n                this._hideDatepicker();\n                this._lastInput = inst.input[ 0 ];\n                if ( typeof( inst.input[ 0 ] ) !== \"object\" ) {\n                    inst.input.trigger( \"focus\" ); // restore focus\n                }\n                this._lastInput = null;\n            }\n        },\n\n        /* Update any alternate field to synchronise with the main field. */\n        _updateAlternate: function( inst ) {\n            var altFormat, date, dateStr,\n                altField = this._get( inst, \"altField\" );\n\n            if ( altField ) { // update alternate field too\n                altFormat = this._get( inst, \"altFormat\" ) || this._get( inst, \"dateFormat\" );\n                date = this._getDate( inst );\n                dateStr = this.formatDate( altFormat, date, this._getFormatConfig( inst ) );\n                $( document ).find( altField ).val( dateStr );\n            }\n        },\n\n        /* Set as beforeShowDay function to prevent selection of weekends.\n         * @param  date  Date - the date to customise\n         * @return [boolean, string] - is this date selectable?, what is its CSS class?\n         */\n        noWeekends: function( date ) {\n            var day = date.getDay();\n            return [ ( day > 0 && day < 6 ), \"\" ];\n        },\n\n        /* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.\n         * @param  date  Date - the date to get the week for\n         * @return  number - the number of the week within the year that contains this date\n         */\n        iso8601Week: function( date ) {\n            var time,\n                checkDate = new Date( date.getTime() );\n\n            // Find Thursday of this week starting on Monday\n            checkDate.setDate( checkDate.getDate() + 4 - ( checkDate.getDay() || 7 ) );\n\n            time = checkDate.getTime();\n            checkDate.setMonth( 0 ); // Compare with Jan 1\n            checkDate.setDate( 1 );\n            return Math.floor( Math.round( ( time - checkDate ) / 86400000 ) / 7 ) + 1;\n        },\n\n        /* Parse a string value into a date object.\n         * See formatDate below for the possible formats.\n         *\n         * @param  format string - the expected format of the date\n         * @param  value string - the date in the above format\n         * @param  settings Object - attributes include:\n         *\t\t\t\t\tshortYearCutoff  number - the cutoff year for determining the century (optional)\n         *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n         *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n         *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n         *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n         * @return  Date - the extracted date value or null if value is blank\n         */\n        parseDate: function( format, value, settings ) {\n            if ( format == null || value == null ) {\n                throw \"Invalid arguments\";\n            }\n\n            value = ( typeof value === \"object\" ? value.toString() : value + \"\" );\n            if ( value === \"\" ) {\n                return null;\n            }\n\n            var iFormat, dim, extra,\n                iValue = 0,\n                shortYearCutoffTemp = ( settings ? settings.shortYearCutoff : null ) || this._defaults.shortYearCutoff,\n                shortYearCutoff = ( typeof shortYearCutoffTemp !== \"string\" ? shortYearCutoffTemp :\n                    new Date().getFullYear() % 100 + parseInt( shortYearCutoffTemp, 10 ) ),\n                dayNamesShort = ( settings ? settings.dayNamesShort : null ) || this._defaults.dayNamesShort,\n                dayNames = ( settings ? settings.dayNames : null ) || this._defaults.dayNames,\n                monthNamesShort = ( settings ? settings.monthNamesShort : null ) || this._defaults.monthNamesShort,\n                monthNames = ( settings ? settings.monthNames : null ) || this._defaults.monthNames,\n                year = -1,\n                month = -1,\n                day = -1,\n                doy = -1,\n                literal = false,\n                date,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                },\n\n                // Extract a number from the string value\n                getNumber = function( match ) {\n                    var isDoubled = lookAhead( match ),\n                        size = ( match === \"@\" ? 14 : ( match === \"!\" ? 20 :\n                            ( match === \"y\" && isDoubled ? 4 : ( match === \"o\" ? 3 : 2 ) ) ) ),\n                        minSize = ( match === \"y\" ? size : 1 ),\n                        digits = new RegExp( \"^\\\\d{\" + minSize + \",\" + size + \"}\" ),\n                        num = value.substring( iValue ).match( digits );\n                    if ( !num ) {\n                        throw \"Missing number at position \" + iValue;\n                    }\n                    iValue += num[ 0 ].length;\n                    return parseInt( num[ 0 ], 10 );\n                },\n\n                // Extract a name from the string value and convert to an index\n                getName = function( match, shortNames, longNames ) {\n                    var index = -1,\n                        names = $.map( lookAhead( match ) ? longNames : shortNames, function( v, k ) {\n                            return [ [ k, v ] ];\n                        } ).sort( function( a, b ) {\n                            return -( a[ 1 ].length - b[ 1 ].length );\n                        } );\n\n                    $.each( names, function( i, pair ) {\n                        var name = pair[ 1 ];\n                        if ( value.substr( iValue, name.length ).toLowerCase() === name.toLowerCase() ) {\n                            index = pair[ 0 ];\n                            iValue += name.length;\n                            return false;\n                        }\n                    } );\n                    if ( index !== -1 ) {\n                        return index + 1;\n                    } else {\n                        throw \"Unknown name at position \" + iValue;\n                    }\n                },\n\n                // Confirm that a literal character matches the string value\n                checkLiteral = function() {\n                    if ( value.charAt( iValue ) !== format.charAt( iFormat ) ) {\n                        throw \"Unexpected literal at position \" + iValue;\n                    }\n                    iValue++;\n                };\n\n            for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                if ( literal ) {\n                    if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                        literal = false;\n                    } else {\n                        checkLiteral();\n                    }\n                } else {\n                    switch ( format.charAt( iFormat ) ) {\n                        case \"d\":\n                            day = getNumber( \"d\" );\n                            break;\n                        case \"D\":\n                            getName( \"D\", dayNamesShort, dayNames );\n                            break;\n                        case \"o\":\n                            doy = getNumber( \"o\" );\n                            break;\n                        case \"m\":\n                            month = getNumber( \"m\" );\n                            break;\n                        case \"M\":\n                            month = getName( \"M\", monthNamesShort, monthNames );\n                            break;\n                        case \"y\":\n                            year = getNumber( \"y\" );\n                            break;\n                        case \"@\":\n                            date = new Date( getNumber( \"@\" ) );\n                            year = date.getFullYear();\n                            month = date.getMonth() + 1;\n                            day = date.getDate();\n                            break;\n                        case \"!\":\n                            date = new Date( ( getNumber( \"!\" ) - this._ticksTo1970 ) / 10000 );\n                            year = date.getFullYear();\n                            month = date.getMonth() + 1;\n                            day = date.getDate();\n                            break;\n                        case \"'\":\n                            if ( lookAhead( \"'\" ) ) {\n                                checkLiteral();\n                            } else {\n                                literal = true;\n                            }\n                            break;\n                        default:\n                            checkLiteral();\n                    }\n                }\n            }\n\n            if ( iValue < value.length ) {\n                extra = value.substr( iValue );\n                if ( !/^\\s+/.test( extra ) ) {\n                    throw \"Extra/unparsed characters found in date: \" + extra;\n                }\n            }\n\n            if ( year === -1 ) {\n                year = new Date().getFullYear();\n            } else if ( year < 100 ) {\n                year += new Date().getFullYear() - new Date().getFullYear() % 100 +\n                    ( year <= shortYearCutoff ? 0 : -100 );\n            }\n\n            if ( doy > -1 ) {\n                month = 1;\n                day = doy;\n                do {\n                    dim = this._getDaysInMonth( year, month - 1 );\n                    if ( day <= dim ) {\n                        break;\n                    }\n                    month++;\n                    day -= dim;\n                } while ( true );\n            }\n\n            date = this._daylightSavingAdjust( new Date( year, month - 1, day ) );\n            if ( date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day ) {\n                throw \"Invalid date\"; // E.g. 31/02/00\n            }\n            return date;\n        },\n\n        /* Standard date formats. */\n        ATOM: \"yy-mm-dd\", // RFC 3339 (ISO 8601)\n        COOKIE: \"D, dd M yy\",\n        ISO_8601: \"yy-mm-dd\",\n        RFC_822: \"D, d M y\",\n        RFC_850: \"DD, dd-M-y\",\n        RFC_1036: \"D, d M y\",\n        RFC_1123: \"D, d M yy\",\n        RFC_2822: \"D, d M yy\",\n        RSS: \"D, d M y\", // RFC 822\n        TICKS: \"!\",\n        TIMESTAMP: \"@\",\n        W3C: \"yy-mm-dd\", // ISO 8601\n\n        _ticksTo1970: ( ( ( 1970 - 1 ) * 365 + Math.floor( 1970 / 4 ) - Math.floor( 1970 / 100 ) +\n            Math.floor( 1970 / 400 ) ) * 24 * 60 * 60 * 10000000 ),\n\n        /* Format a date object into a string value.\n         * The format can be combinations of the following:\n         * d  - day of month (no leading zero)\n         * dd - day of month (two digit)\n         * o  - day of year (no leading zeros)\n         * oo - day of year (three digit)\n         * D  - day name short\n         * DD - day name long\n         * m  - month of year (no leading zero)\n         * mm - month of year (two digit)\n         * M  - month name short\n         * MM - month name long\n         * y  - year (two digit)\n         * yy - year (four digit)\n         * @ - Unix timestamp (ms since 01/01/1970)\n         * ! - Windows ticks (100ns since 01/01/0001)\n         * \"...\" - literal text\n         * '' - single quote\n         *\n         * @param  format string - the desired format of the date\n         * @param  date Date - the date value to format\n         * @param  settings Object - attributes include:\n         *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n         *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n         *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n         *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n         * @return  string - the date in the above format\n         */\n        formatDate: function( format, date, settings ) {\n            if ( !date ) {\n                return \"\";\n            }\n\n            var iFormat,\n                dayNamesShort = ( settings ? settings.dayNamesShort : null ) || this._defaults.dayNamesShort,\n                dayNames = ( settings ? settings.dayNames : null ) || this._defaults.dayNames,\n                monthNamesShort = ( settings ? settings.monthNamesShort : null ) || this._defaults.monthNamesShort,\n                monthNames = ( settings ? settings.monthNames : null ) || this._defaults.monthNames,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                },\n\n                // Format a number, with leading zero if necessary\n                formatNumber = function( match, value, len ) {\n                    var num = \"\" + value;\n                    if ( lookAhead( match ) ) {\n                        while ( num.length < len ) {\n                            num = \"0\" + num;\n                        }\n                    }\n                    return num;\n                },\n\n                // Format a name, short or long as requested\n                formatName = function( match, value, shortNames, longNames ) {\n                    return ( lookAhead( match ) ? longNames[ value ] : shortNames[ value ] );\n                },\n                output = \"\",\n                literal = false;\n\n            if ( date ) {\n                for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                    if ( literal ) {\n                        if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                            literal = false;\n                        } else {\n                            output += format.charAt( iFormat );\n                        }\n                    } else {\n                        switch ( format.charAt( iFormat ) ) {\n                            case \"d\":\n                                output += formatNumber( \"d\", date.getDate(), 2 );\n                                break;\n                            case \"D\":\n                                output += formatName( \"D\", date.getDay(), dayNamesShort, dayNames );\n                                break;\n                            case \"o\":\n                                output += formatNumber( \"o\",\n                                    Math.round( ( new Date( date.getFullYear(), date.getMonth(), date.getDate() ).getTime() - new Date( date.getFullYear(), 0, 0 ).getTime() ) / 86400000 ), 3 );\n                                break;\n                            case \"m\":\n                                output += formatNumber( \"m\", date.getMonth() + 1, 2 );\n                                break;\n                            case \"M\":\n                                output += formatName( \"M\", date.getMonth(), monthNamesShort, monthNames );\n                                break;\n                            case \"y\":\n                                output += ( lookAhead( \"y\" ) ? date.getFullYear() :\n                                    ( date.getFullYear() % 100 < 10 ? \"0\" : \"\" ) + date.getFullYear() % 100 );\n                                break;\n                            case \"@\":\n                                output += date.getTime();\n                                break;\n                            case \"!\":\n                                output += date.getTime() * 10000 + this._ticksTo1970;\n                                break;\n                            case \"'\":\n                                if ( lookAhead( \"'\" ) ) {\n                                    output += \"'\";\n                                } else {\n                                    literal = true;\n                                }\n                                break;\n                            default:\n                                output += format.charAt( iFormat );\n                        }\n                    }\n                }\n            }\n            return output;\n        },\n\n        /* Extract all possible characters from the date format. */\n        _possibleChars: function( format ) {\n            var iFormat,\n                chars = \"\",\n                literal = false,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                };\n\n            for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                if ( literal ) {\n                    if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                        literal = false;\n                    } else {\n                        chars += format.charAt( iFormat );\n                    }\n                } else {\n                    switch ( format.charAt( iFormat ) ) {\n                        case \"d\": case \"m\": case \"y\": case \"@\":\n                            chars += \"0123456789\";\n                            break;\n                        case \"D\": case \"M\":\n                            return null; // Accept anything\n                        case \"'\":\n                            if ( lookAhead( \"'\" ) ) {\n                                chars += \"'\";\n                            } else {\n                                literal = true;\n                            }\n                            break;\n                        default:\n                            chars += format.charAt( iFormat );\n                    }\n                }\n            }\n            return chars;\n        },\n\n        /* Get a setting value, defaulting if necessary. */\n        _get: function( inst, name ) {\n            return inst.settings[ name ] !== undefined ?\n                inst.settings[ name ] : this._defaults[ name ];\n        },\n\n        /* Parse existing date and initialise date picker. */\n        _setDateFromField: function( inst, noDefault ) {\n            if ( inst.input.val() === inst.lastVal ) {\n                return;\n            }\n\n            var dateFormat = this._get( inst, \"dateFormat\" ),\n                dates = inst.lastVal = inst.input ? inst.input.val() : null,\n                defaultDate = this._getDefaultDate( inst ),\n                date = defaultDate,\n                settings = this._getFormatConfig( inst );\n\n            try {\n                date = this.parseDate( dateFormat, dates, settings ) || defaultDate;\n            } catch ( event ) {\n                dates = ( noDefault ? \"\" : dates );\n            }\n            inst.selectedDay = date.getDate();\n            inst.drawMonth = inst.selectedMonth = date.getMonth();\n            inst.drawYear = inst.selectedYear = date.getFullYear();\n            inst.currentDay = ( dates ? date.getDate() : 0 );\n            inst.currentMonth = ( dates ? date.getMonth() : 0 );\n            inst.currentYear = ( dates ? date.getFullYear() : 0 );\n            this._adjustInstDate( inst );\n        },\n\n        /* Retrieve the default date shown on opening. */\n        _getDefaultDate: function( inst ) {\n            return this._restrictMinMax( inst,\n                this._determineDate( inst, this._get( inst, \"defaultDate\" ), new Date() ) );\n        },\n\n        /* A date may be specified as an exact value or a relative one. */\n        _determineDate: function( inst, date, defaultDate ) {\n            var offsetNumeric = function( offset ) {\n                    var date = new Date();\n                    date.setDate( date.getDate() + offset );\n                    return date;\n                },\n                offsetString = function( offset ) {\n                    try {\n                        return $.datepicker.parseDate( $.datepicker._get( inst, \"dateFormat\" ),\n                            offset, $.datepicker._getFormatConfig( inst ) );\n                    } catch ( e ) {\n\n                        // Ignore\n                    }\n\n                    var date = ( offset.toLowerCase().match( /^c/ ) ?\n                            $.datepicker._getDate( inst ) : null ) || new Date(),\n                        year = date.getFullYear(),\n                        month = date.getMonth(),\n                        day = date.getDate(),\n                        pattern = /([+\\-]?[0-9]+)\\s*(d|D|w|W|m|M|y|Y)?/g,\n                        matches = pattern.exec( offset );\n\n                    while ( matches ) {\n                        switch ( matches[ 2 ] || \"d\" ) {\n                            case \"d\" : case \"D\" :\n                                day += parseInt( matches[ 1 ], 10 ); break;\n                            case \"w\" : case \"W\" :\n                                day += parseInt( matches[ 1 ], 10 ) * 7; break;\n                            case \"m\" : case \"M\" :\n                                month += parseInt( matches[ 1 ], 10 );\n                                day = Math.min( day, $.datepicker._getDaysInMonth( year, month ) );\n                                break;\n                            case \"y\": case \"Y\" :\n                                year += parseInt( matches[ 1 ], 10 );\n                                day = Math.min( day, $.datepicker._getDaysInMonth( year, month ) );\n                                break;\n                        }\n                        matches = pattern.exec( offset );\n                    }\n                    return new Date( year, month, day );\n                },\n                newDate = ( date == null || date === \"\" ? defaultDate : ( typeof date === \"string\" ? offsetString( date ) :\n                    ( typeof date === \"number\" ? ( isNaN( date ) ? defaultDate : offsetNumeric( date ) ) : new Date( date.getTime() ) ) ) );\n\n            newDate = ( newDate && newDate.toString() === \"Invalid Date\" ? defaultDate : newDate );\n            if ( newDate ) {\n                newDate.setHours( 0 );\n                newDate.setMinutes( 0 );\n                newDate.setSeconds( 0 );\n                newDate.setMilliseconds( 0 );\n            }\n            return this._daylightSavingAdjust( newDate );\n        },\n\n        /* Handle switch to/from daylight saving.\n         * Hours may be non-zero on daylight saving cut-over:\n         * > 12 when midnight changeover, but then cannot generate\n         * midnight datetime, so jump to 1AM, otherwise reset.\n         * @param  date  (Date) the date to check\n         * @return  (Date) the corrected date\n         */\n        _daylightSavingAdjust: function( date ) {\n            if ( !date ) {\n                return null;\n            }\n            date.setHours( date.getHours() > 12 ? date.getHours() + 2 : 0 );\n            return date;\n        },\n\n        /* Set the date(s) directly. */\n        _setDate: function( inst, date, noChange ) {\n            var clear = !date,\n                origMonth = inst.selectedMonth,\n                origYear = inst.selectedYear,\n                newDate = this._restrictMinMax( inst, this._determineDate( inst, date, new Date() ) );\n\n            inst.selectedDay = inst.currentDay = newDate.getDate();\n            inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();\n            inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();\n            if ( ( origMonth !== inst.selectedMonth || origYear !== inst.selectedYear ) && !noChange ) {\n                this._notifyChange( inst );\n            }\n            this._adjustInstDate( inst );\n            if ( inst.input ) {\n                inst.input.val( clear ? \"\" : this._formatDate( inst ) );\n            }\n        },\n\n        /* Retrieve the date(s) directly. */\n        _getDate: function( inst ) {\n            var startDate = ( !inst.currentYear || ( inst.input && inst.input.val() === \"\" ) ? null :\n                this._daylightSavingAdjust( new Date(\n                    inst.currentYear, inst.currentMonth, inst.currentDay ) ) );\n            return startDate;\n        },\n\n        /* Attach the onxxx handlers.  These are declared statically so\n         * they work with static code transformers like Caja.\n         */\n        _attachHandlers: function( inst ) {\n            var stepMonths = this._get( inst, \"stepMonths\" ),\n                id = \"#\" + inst.id.replace( /\\\\\\\\/g, \"\\\\\" );\n            inst.dpDiv.find( \"[data-handler]\" ).map( function() {\n                var handler = {\n                    prev: function() {\n                        $.datepicker._adjustDate( id, -stepMonths, \"M\" );\n                    },\n                    next: function() {\n                        $.datepicker._adjustDate( id, +stepMonths, \"M\" );\n                    },\n                    hide: function() {\n                        $.datepicker._hideDatepicker();\n                    },\n                    today: function() {\n                        $.datepicker._gotoToday( id );\n                    },\n                    selectDay: function() {\n                        $.datepicker._selectDay( id, +this.getAttribute( \"data-month\" ), +this.getAttribute( \"data-year\" ), this );\n                        return false;\n                    },\n                    selectMonth: function() {\n                        $.datepicker._selectMonthYear( id, this, \"M\" );\n                        return false;\n                    },\n                    selectYear: function() {\n                        $.datepicker._selectMonthYear( id, this, \"Y\" );\n                        return false;\n                    }\n                };\n                $( this ).on( this.getAttribute( \"data-event\" ), handler[ this.getAttribute( \"data-handler\" ) ] );\n            } );\n        },\n\n        /* Generate the HTML for the current state of the date picker. */\n        _generateHTML: function( inst ) {\n            var maxDraw, prevText, prev, nextText, next, currentText, gotoDate,\n                controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin,\n                monthNames, monthNamesShort, beforeShowDay, showOtherMonths,\n                selectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate,\n                cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows,\n                printDate, dRow, tbody, daySettings, otherMonth, unselectable,\n                tempDate = new Date(),\n                today = this._daylightSavingAdjust(\n                    new Date( tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate() ) ), // clear time\n                isRTL = this._get( inst, \"isRTL\" ),\n                showButtonPanel = this._get( inst, \"showButtonPanel\" ),\n                hideIfNoPrevNext = this._get( inst, \"hideIfNoPrevNext\" ),\n                navigationAsDateFormat = this._get( inst, \"navigationAsDateFormat\" ),\n                numMonths = this._getNumberOfMonths( inst ),\n                showCurrentAtPos = this._get( inst, \"showCurrentAtPos\" ),\n                stepMonths = this._get( inst, \"stepMonths\" ),\n                isMultiMonth = ( numMonths[ 0 ] !== 1 || numMonths[ 1 ] !== 1 ),\n                currentDate = this._daylightSavingAdjust( ( !inst.currentDay ? new Date( 9999, 9, 9 ) :\n                    new Date( inst.currentYear, inst.currentMonth, inst.currentDay ) ) ),\n                minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                drawMonth = inst.drawMonth - showCurrentAtPos,\n                drawYear = inst.drawYear;\n\n            if ( drawMonth < 0 ) {\n                drawMonth += 12;\n                drawYear--;\n            }\n            if ( maxDate ) {\n                maxDraw = this._daylightSavingAdjust( new Date( maxDate.getFullYear(),\n                    maxDate.getMonth() - ( numMonths[ 0 ] * numMonths[ 1 ] ) + 1, maxDate.getDate() ) );\n                maxDraw = ( minDate && maxDraw < minDate ? minDate : maxDraw );\n                while ( this._daylightSavingAdjust( new Date( drawYear, drawMonth, 1 ) ) > maxDraw ) {\n                    drawMonth--;\n                    if ( drawMonth < 0 ) {\n                        drawMonth = 11;\n                        drawYear--;\n                    }\n                }\n            }\n            inst.drawMonth = drawMonth;\n            inst.drawYear = drawYear;\n\n            prevText = this._get( inst, \"prevText\" );\n            prevText = ( !navigationAsDateFormat ? prevText : this.formatDate( prevText,\n                this._daylightSavingAdjust( new Date( drawYear, drawMonth - stepMonths, 1 ) ),\n                this._getFormatConfig( inst ) ) );\n\n            if ( this._canAdjustMonth( inst, -1, drawYear, drawMonth ) ) {\n                prev = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-prev ui-corner-all\",\n                        \"data-handler\": \"prev\",\n                        \"data-event\": \"click\",\n                        title: prevText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"e\" : \"w\" ) )\n                            .text( prevText )\n                    )[ 0 ].outerHTML;\n            } else if ( hideIfNoPrevNext ) {\n                prev = \"\";\n            } else {\n                prev = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-prev ui-corner-all ui-state-disabled\",\n                        title: prevText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"e\" : \"w\" ) )\n                            .text( prevText )\n                    )[ 0 ].outerHTML;\n            }\n\n            nextText = this._get( inst, \"nextText\" );\n            nextText = ( !navigationAsDateFormat ? nextText : this.formatDate( nextText,\n                this._daylightSavingAdjust( new Date( drawYear, drawMonth + stepMonths, 1 ) ),\n                this._getFormatConfig( inst ) ) );\n\n            if ( this._canAdjustMonth( inst, +1, drawYear, drawMonth ) ) {\n                next = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-next ui-corner-all\",\n                        \"data-handler\": \"next\",\n                        \"data-event\": \"click\",\n                        title: nextText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"w\" : \"e\" ) )\n                            .text( nextText )\n                    )[ 0 ].outerHTML;\n            } else if ( hideIfNoPrevNext ) {\n                next = \"\";\n            } else {\n                next = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-next ui-corner-all ui-state-disabled\",\n                        title: nextText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .attr( \"class\", \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"w\" : \"e\" ) )\n                            .text( nextText )\n                    )[ 0 ].outerHTML;\n            }\n\n            currentText = this._get( inst, \"currentText\" );\n            gotoDate = ( this._get( inst, \"gotoCurrent\" ) && inst.currentDay ? currentDate : today );\n            currentText = ( !navigationAsDateFormat ? currentText :\n                this.formatDate( currentText, gotoDate, this._getFormatConfig( inst ) ) );\n\n            controls = \"\";\n            if ( !inst.inline ) {\n                controls = $( \"<button>\" )\n                    .attr( {\n                        type: \"button\",\n                        \"class\": \"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all\",\n                        \"data-handler\": \"hide\",\n                        \"data-event\": \"click\"\n                    } )\n                    .text( this._get( inst, \"closeText\" ) )[ 0 ].outerHTML;\n            }\n\n            buttonPanel = \"\";\n            if ( showButtonPanel ) {\n                buttonPanel = $( \"<div class='ui-datepicker-buttonpane ui-widget-content'>\" )\n                    .append( isRTL ? controls : \"\" )\n                    .append( this._isInRange( inst, gotoDate ) ?\n                        $( \"<button>\" )\n                            .attr( {\n                                type: \"button\",\n                                \"class\": \"ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all\",\n                                \"data-handler\": \"today\",\n                                \"data-event\": \"click\"\n                            } )\n                            .text( currentText ) :\n                        \"\" )\n                    .append( isRTL ? \"\" : controls )[ 0 ].outerHTML;\n            }\n\n            firstDay = parseInt( this._get( inst, \"firstDay\" ), 10 );\n            firstDay = ( isNaN( firstDay ) ? 0 : firstDay );\n\n            showWeek = this._get( inst, \"showWeek\" );\n            dayNames = this._get( inst, \"dayNames\" );\n            dayNamesMin = this._get( inst, \"dayNamesMin\" );\n            monthNames = this._get( inst, \"monthNames\" );\n            monthNamesShort = this._get( inst, \"monthNamesShort\" );\n            beforeShowDay = this._get( inst, \"beforeShowDay\" );\n            showOtherMonths = this._get( inst, \"showOtherMonths\" );\n            selectOtherMonths = this._get( inst, \"selectOtherMonths\" );\n            defaultDate = this._getDefaultDate( inst );\n            html = \"\";\n\n            for ( row = 0; row < numMonths[ 0 ]; row++ ) {\n                group = \"\";\n                this.maxRows = 4;\n                for ( col = 0; col < numMonths[ 1 ]; col++ ) {\n                    selectedDate = this._daylightSavingAdjust( new Date( drawYear, drawMonth, inst.selectedDay ) );\n                    cornerClass = \" ui-corner-all\";\n                    calender = \"\";\n                    if ( isMultiMonth ) {\n                        calender += \"<div class='ui-datepicker-group\";\n                        if ( numMonths[ 1 ] > 1 ) {\n                            switch ( col ) {\n                                case 0: calender += \" ui-datepicker-group-first\";\n                                    cornerClass = \" ui-corner-\" + ( isRTL ? \"right\" : \"left\" ); break;\n                                case numMonths[ 1 ] - 1: calender += \" ui-datepicker-group-last\";\n                                    cornerClass = \" ui-corner-\" + ( isRTL ? \"left\" : \"right\" ); break;\n                                default: calender += \" ui-datepicker-group-middle\"; cornerClass = \"\"; break;\n                            }\n                        }\n                        calender += \"'>\";\n                    }\n                    calender += \"<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix\" + cornerClass + \"'>\" +\n                        ( /all|left/.test( cornerClass ) && row === 0 ? ( isRTL ? next : prev ) : \"\" ) +\n                        ( /all|right/.test( cornerClass ) && row === 0 ? ( isRTL ? prev : next ) : \"\" ) +\n                        this._generateMonthYearHeader( inst, drawMonth, drawYear, minDate, maxDate,\n                            row > 0 || col > 0, monthNames, monthNamesShort ) + // draw month headers\n                        \"</div><table class='ui-datepicker-calendar'><thead>\" +\n                        \"<tr>\";\n                    thead = ( showWeek ? \"<th class='ui-datepicker-week-col'>\" + this._get( inst, \"weekHeader\" ) + \"</th>\" : \"\" );\n                    for ( dow = 0; dow < 7; dow++ ) { // days of the week\n                        day = ( dow + firstDay ) % 7;\n                        thead += \"<th scope='col'\" + ( ( dow + firstDay + 6 ) % 7 >= 5 ? \" class='ui-datepicker-week-end'\" : \"\" ) + \">\" +\n                            \"<span title='\" + dayNames[ day ] + \"'>\" + dayNamesMin[ day ] + \"</span></th>\";\n                    }\n                    calender += thead + \"</tr></thead><tbody>\";\n                    daysInMonth = this._getDaysInMonth( drawYear, drawMonth );\n                    if ( drawYear === inst.selectedYear && drawMonth === inst.selectedMonth ) {\n                        inst.selectedDay = Math.min( inst.selectedDay, daysInMonth );\n                    }\n                    leadDays = ( this._getFirstDayOfMonth( drawYear, drawMonth ) - firstDay + 7 ) % 7;\n                    curRows = Math.ceil( ( leadDays + daysInMonth ) / 7 ); // calculate the number of rows to generate\n                    numRows = ( isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows ); //If multiple months, use the higher number of rows (see #7043)\n                    this.maxRows = numRows;\n                    printDate = this._daylightSavingAdjust( new Date( drawYear, drawMonth, 1 - leadDays ) );\n                    for ( dRow = 0; dRow < numRows; dRow++ ) { // create date picker rows\n                        calender += \"<tr>\";\n                        tbody = ( !showWeek ? \"\" : \"<td class='ui-datepicker-week-col'>\" +\n                            this._get( inst, \"calculateWeek\" )( printDate ) + \"</td>\" );\n                        for ( dow = 0; dow < 7; dow++ ) { // create date picker days\n                            daySettings = ( beforeShowDay ?\n                                beforeShowDay.apply( ( inst.input ? inst.input[ 0 ] : null ), [ printDate ] ) : [ true, \"\" ] );\n                            otherMonth = ( printDate.getMonth() !== drawMonth );\n                            unselectable = ( otherMonth && !selectOtherMonths ) || !daySettings[ 0 ] ||\n                                ( minDate && printDate < minDate ) || ( maxDate && printDate > maxDate );\n                            tbody += \"<td class='\" +\n                                ( ( dow + firstDay + 6 ) % 7 >= 5 ? \" ui-datepicker-week-end\" : \"\" ) + // highlight weekends\n                                ( otherMonth ? \" ui-datepicker-other-month\" : \"\" ) + // highlight days from other months\n                                ( ( printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent ) || // user pressed key\n                                ( defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime() ) ?\n\n                                    // or defaultDate is current printedDate and defaultDate is selectedDate\n                                    \" \" + this._dayOverClass : \"\" ) + // highlight selected day\n                                ( unselectable ? \" \" + this._unselectableClass + \" ui-state-disabled\" : \"\" ) +  // highlight unselectable days\n                                ( otherMonth && !showOtherMonths ? \"\" : \" \" + daySettings[ 1 ] + // highlight custom dates\n                                    ( printDate.getTime() === currentDate.getTime() ? \" \" + this._currentClass : \"\" ) + // highlight selected day\n                                    ( printDate.getTime() === today.getTime() ? \" ui-datepicker-today\" : \"\" ) ) + \"'\" + // highlight today (if different)\n                                ( ( !otherMonth || showOtherMonths ) && daySettings[ 2 ] ? \" title='\" + daySettings[ 2 ].replace( /'/g, \"&#39;\" ) + \"'\" : \"\" ) + // cell title\n                                ( unselectable ? \"\" : \" data-handler='selectDay' data-event='click' data-month='\" + printDate.getMonth() + \"' data-year='\" + printDate.getFullYear() + \"'\" ) + \">\" + // actions\n                                ( otherMonth && !showOtherMonths ? \"&#xa0;\" : // display for other months\n                                    ( unselectable ? \"<span class='ui-state-default'>\" + printDate.getDate() + \"</span>\" : \"<a class='ui-state-default\" +\n                                        ( printDate.getTime() === today.getTime() ? \" ui-state-highlight\" : \"\" ) +\n                                        ( printDate.getTime() === currentDate.getTime() ? \" ui-state-active\" : \"\" ) + // highlight selected day\n                                        ( otherMonth ? \" ui-priority-secondary\" : \"\" ) + // distinguish dates from other months\n                                        \"' href='#' aria-current='\" + ( printDate.getTime() === currentDate.getTime() ? \"true\" : \"false\" ) + // mark date as selected for screen reader\n                                        \"' data-date='\" + printDate.getDate() + // store date as data\n                                        \"'>\" + printDate.getDate() + \"</a>\" ) ) + \"</td>\"; // display selectable date\n                            printDate.setDate( printDate.getDate() + 1 );\n                            printDate = this._daylightSavingAdjust( printDate );\n                        }\n                        calender += tbody + \"</tr>\";\n                    }\n                    drawMonth++;\n                    if ( drawMonth > 11 ) {\n                        drawMonth = 0;\n                        drawYear++;\n                    }\n                    calender += \"</tbody></table>\" + ( isMultiMonth ? \"</div>\" +\n                        ( ( numMonths[ 0 ] > 0 && col === numMonths[ 1 ] - 1 ) ? \"<div class='ui-datepicker-row-break'></div>\" : \"\" ) : \"\" );\n                    group += calender;\n                }\n                html += group;\n            }\n            html += buttonPanel;\n            inst._keyEvent = false;\n            return html;\n        },\n\n        /* Generate the month and year header. */\n        _generateMonthYearHeader: function( inst, drawMonth, drawYear, minDate, maxDate,\n                                            secondary, monthNames, monthNamesShort ) {\n\n            var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear,\n                changeMonth = this._get( inst, \"changeMonth\" ),\n                changeYear = this._get( inst, \"changeYear\" ),\n                showMonthAfterYear = this._get( inst, \"showMonthAfterYear\" ),\n                selectMonthLabel = this._get( inst, \"selectMonthLabel\" ),\n                selectYearLabel = this._get( inst, \"selectYearLabel\" ),\n                html = \"<div class='ui-datepicker-title'>\",\n                monthHtml = \"\";\n\n            // Month selection\n            if ( secondary || !changeMonth ) {\n                monthHtml += \"<span class='ui-datepicker-month'>\" + monthNames[ drawMonth ] + \"</span>\";\n            } else {\n                inMinYear = ( minDate && minDate.getFullYear() === drawYear );\n                inMaxYear = ( maxDate && maxDate.getFullYear() === drawYear );\n                monthHtml += \"<select class='ui-datepicker-month' aria-label='\" + selectMonthLabel + \"' data-handler='selectMonth' data-event='change'>\";\n                for ( month = 0; month < 12; month++ ) {\n                    if ( ( !inMinYear || month >= minDate.getMonth() ) && ( !inMaxYear || month <= maxDate.getMonth() ) ) {\n                        monthHtml += \"<option value='\" + month + \"'\" +\n                            ( month === drawMonth ? \" selected='selected'\" : \"\" ) +\n                            \">\" + monthNamesShort[ month ] + \"</option>\";\n                    }\n                }\n                monthHtml += \"</select>\";\n            }\n\n            if ( !showMonthAfterYear ) {\n                html += monthHtml + ( secondary || !( changeMonth && changeYear ) ? \"&#xa0;\" : \"\" );\n            }\n\n            // Year selection\n            if ( !inst.yearshtml ) {\n                inst.yearshtml = \"\";\n                if ( secondary || !changeYear ) {\n                    html += \"<span class='ui-datepicker-year'>\" + drawYear + \"</span>\";\n                } else {\n\n                    // determine range of years to display\n                    years = this._get( inst, \"yearRange\" ).split( \":\" );\n                    thisYear = new Date().getFullYear();\n                    determineYear = function( value ) {\n                        var year = ( value.match( /c[+\\-].*/ ) ? drawYear + parseInt( value.substring( 1 ), 10 ) :\n                            ( value.match( /[+\\-].*/ ) ? thisYear + parseInt( value, 10 ) :\n                                parseInt( value, 10 ) ) );\n                        return ( isNaN( year ) ? thisYear : year );\n                    };\n                    year = determineYear( years[ 0 ] );\n                    endYear = Math.max( year, determineYear( years[ 1 ] || \"\" ) );\n                    year = ( minDate ? Math.max( year, minDate.getFullYear() ) : year );\n                    endYear = ( maxDate ? Math.min( endYear, maxDate.getFullYear() ) : endYear );\n                    inst.yearshtml += \"<select class='ui-datepicker-year' aria-label='\" + selectYearLabel + \"' data-handler='selectYear' data-event='change'>\";\n                    for ( ; year <= endYear; year++ ) {\n                        inst.yearshtml += \"<option value='\" + year + \"'\" +\n                            ( year === drawYear ? \" selected='selected'\" : \"\" ) +\n                            \">\" + year + \"</option>\";\n                    }\n                    inst.yearshtml += \"</select>\";\n\n                    html += inst.yearshtml;\n                    inst.yearshtml = null;\n                }\n            }\n\n            html += this._get( inst, \"yearSuffix\" );\n            if ( showMonthAfterYear ) {\n                html += ( secondary || !( changeMonth && changeYear ) ? \"&#xa0;\" : \"\" ) + monthHtml;\n            }\n            html += \"</div>\"; // Close datepicker_header\n            return html;\n        },\n\n        /* Adjust one of the date sub-fields. */\n        _adjustInstDate: function( inst, offset, period ) {\n            var year = inst.selectedYear + ( period === \"Y\" ? offset : 0 ),\n                month = inst.selectedMonth + ( period === \"M\" ? offset : 0 ),\n                day = Math.min( inst.selectedDay, this._getDaysInMonth( year, month ) ) + ( period === \"D\" ? offset : 0 ),\n                date = this._restrictMinMax( inst, this._daylightSavingAdjust( new Date( year, month, day ) ) );\n\n            inst.selectedDay = date.getDate();\n            inst.drawMonth = inst.selectedMonth = date.getMonth();\n            inst.drawYear = inst.selectedYear = date.getFullYear();\n            if ( period === \"M\" || period === \"Y\" ) {\n                this._notifyChange( inst );\n            }\n        },\n\n        /* Ensure a date is within any min/max bounds. */\n        _restrictMinMax: function( inst, date ) {\n            var minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                newDate = ( minDate && date < minDate ? minDate : date );\n            return ( maxDate && newDate > maxDate ? maxDate : newDate );\n        },\n\n        /* Notify change of month/year. */\n        _notifyChange: function( inst ) {\n            var onChange = this._get( inst, \"onChangeMonthYear\" );\n            if ( onChange ) {\n                onChange.apply( ( inst.input ? inst.input[ 0 ] : null ),\n                    [ inst.selectedYear, inst.selectedMonth + 1, inst ] );\n            }\n        },\n\n        /* Determine the number of months to show. */\n        _getNumberOfMonths: function( inst ) {\n            var numMonths = this._get( inst, \"numberOfMonths\" );\n            return ( numMonths == null ? [ 1, 1 ] : ( typeof numMonths === \"number\" ? [ 1, numMonths ] : numMonths ) );\n        },\n\n        /* Determine the current maximum date - ensure no time components are set. */\n        _getMinMaxDate: function( inst, minMax ) {\n            return this._determineDate( inst, this._get( inst, minMax + \"Date\" ), null );\n        },\n\n        /* Find the number of days in a given month. */\n        _getDaysInMonth: function( year, month ) {\n            return 32 - this._daylightSavingAdjust( new Date( year, month, 32 ) ).getDate();\n        },\n\n        /* Find the day of the week of the first of a month. */\n        _getFirstDayOfMonth: function( year, month ) {\n            return new Date( year, month, 1 ).getDay();\n        },\n\n        /* Determines if we should allow a \"next/prev\" month display change. */\n        _canAdjustMonth: function( inst, offset, curYear, curMonth ) {\n            var numMonths = this._getNumberOfMonths( inst ),\n                date = this._daylightSavingAdjust( new Date( curYear,\n                    curMonth + ( offset < 0 ? offset : numMonths[ 0 ] * numMonths[ 1 ] ), 1 ) );\n\n            if ( offset < 0 ) {\n                date.setDate( this._getDaysInMonth( date.getFullYear(), date.getMonth() ) );\n            }\n            return this._isInRange( inst, date );\n        },\n\n        /* Is the given date in the accepted range? */\n        _isInRange: function( inst, date ) {\n            var yearSplit, currentYear,\n                minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                minYear = null,\n                maxYear = null,\n                years = this._get( inst, \"yearRange\" );\n            if ( years ) {\n                yearSplit = years.split( \":\" );\n                currentYear = new Date().getFullYear();\n                minYear = parseInt( yearSplit[ 0 ], 10 );\n                maxYear = parseInt( yearSplit[ 1 ], 10 );\n                if ( yearSplit[ 0 ].match( /[+\\-].*/ ) ) {\n                    minYear += currentYear;\n                }\n                if ( yearSplit[ 1 ].match( /[+\\-].*/ ) ) {\n                    maxYear += currentYear;\n                }\n            }\n\n            return ( ( !minDate || date.getTime() >= minDate.getTime() ) &&\n                ( !maxDate || date.getTime() <= maxDate.getTime() ) &&\n                ( !minYear || date.getFullYear() >= minYear ) &&\n                ( !maxYear || date.getFullYear() <= maxYear ) );\n        },\n\n        /* Provide the configuration settings for formatting/parsing. */\n        _getFormatConfig: function( inst ) {\n            var shortYearCutoff = this._get( inst, \"shortYearCutoff\" );\n            shortYearCutoff = ( typeof shortYearCutoff !== \"string\" ? shortYearCutoff :\n                new Date().getFullYear() % 100 + parseInt( shortYearCutoff, 10 ) );\n            return { shortYearCutoff: shortYearCutoff,\n                dayNamesShort: this._get( inst, \"dayNamesShort\" ), dayNames: this._get( inst, \"dayNames\" ),\n                monthNamesShort: this._get( inst, \"monthNamesShort\" ), monthNames: this._get( inst, \"monthNames\" ) };\n        },\n\n        /* Format the given date for display. */\n        _formatDate: function( inst, day, month, year ) {\n            if ( !day ) {\n                inst.currentDay = inst.selectedDay;\n                inst.currentMonth = inst.selectedMonth;\n                inst.currentYear = inst.selectedYear;\n            }\n            var date = ( day ? ( typeof day === \"object\" ? day :\n                    this._daylightSavingAdjust( new Date( year, month, day ) ) ) :\n                this._daylightSavingAdjust( new Date( inst.currentYear, inst.currentMonth, inst.currentDay ) ) );\n            return this.formatDate( this._get( inst, \"dateFormat\" ), date, this._getFormatConfig( inst ) );\n        }\n    } );\n\n    /*\n     * Bind hover events for datepicker elements.\n     * Done via delegate so the binding only occurs once in the lifetime of the parent div.\n     * Global datepicker_instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.\n     */\n    function datepicker_bindHover( dpDiv ) {\n        var selector = \"button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a\";\n        return dpDiv.on( \"mouseout\", selector, function() {\n            $( this ).removeClass( \"ui-state-hover\" );\n            if ( this.className.indexOf( \"ui-datepicker-prev\" ) !== -1 ) {\n                $( this ).removeClass( \"ui-datepicker-prev-hover\" );\n            }\n            if ( this.className.indexOf( \"ui-datepicker-next\" ) !== -1 ) {\n                $( this ).removeClass( \"ui-datepicker-next-hover\" );\n            }\n        } )\n            .on( \"mouseover\", selector, datepicker_handleMouseover );\n    }\n\n    function datepicker_handleMouseover() {\n        if ( !$.datepicker._isDisabledDatepicker( datepicker_instActive.inline ? datepicker_instActive.dpDiv.parent()[ 0 ] : datepicker_instActive.input[ 0 ] ) ) {\n            $( this ).parents( \".ui-datepicker-calendar\" ).find( \"a\" ).removeClass( \"ui-state-hover\" );\n            $( this ).addClass( \"ui-state-hover\" );\n            if ( this.className.indexOf( \"ui-datepicker-prev\" ) !== -1 ) {\n                $( this ).addClass( \"ui-datepicker-prev-hover\" );\n            }\n            if ( this.className.indexOf( \"ui-datepicker-next\" ) !== -1 ) {\n                $( this ).addClass( \"ui-datepicker-next-hover\" );\n            }\n        }\n    }\n\n    /* jQuery extend now ignores nulls! */\n    function datepicker_extendRemove( target, props ) {\n        $.extend( target, props );\n        for ( var name in props ) {\n            if ( props[ name ] == null ) {\n                target[ name ] = props[ name ];\n            }\n        }\n        return target;\n    }\n\n    /* Invoke the datepicker functionality.\n       @param  options  string - a command, optionally followed by additional parameters or\n                        Object - settings for attaching new datepicker functionality\n       @return  jQuery object */\n    $.fn.datepicker = function( options ) {\n\n        /* Verify an empty collection wasn't passed - Fixes #6976 */\n        if ( !this.length ) {\n            return this;\n        }\n\n        /* Initialise the date picker. */\n        if ( !$.datepicker.initialized ) {\n            $( document ).on( \"mousedown\", $.datepicker._checkExternalClick );\n            $.datepicker.initialized = true;\n        }\n\n        /* Append datepicker main container to body if not exist. */\n        if ( $( \"#\" + $.datepicker._mainDivId ).length === 0 ) {\n            $( \"body\" ).append( $.datepicker.dpDiv );\n        }\n\n        var otherArgs = Array.prototype.slice.call( arguments, 1 );\n        if ( typeof options === \"string\" && ( options === \"isDisabled\" || options === \"getDate\" || options === \"widget\" ) ) {\n            return $.datepicker[ \"_\" + options + \"Datepicker\" ].\n            apply( $.datepicker, [ this[ 0 ] ].concat( otherArgs ) );\n        }\n        if ( options === \"option\" && arguments.length === 2 && typeof arguments[ 1 ] === \"string\" ) {\n            return $.datepicker[ \"_\" + options + \"Datepicker\" ].\n            apply( $.datepicker, [ this[ 0 ] ].concat( otherArgs ) );\n        }\n        return this.each( function() {\n            if ( typeof options === \"string\" ) {\n                $.datepicker[ \"_\" + options + \"Datepicker\" ]\n                    .apply( $.datepicker, [ this ].concat( otherArgs ) );\n            } else {\n                $.datepicker._attachDatepicker( this, options );\n            }\n        } );\n    };\n\n    $.datepicker = new Datepicker(); // singleton instance\n    $.datepicker.initialized = false;\n    $.datepicker.uuid = new Date().getTime();\n    $.datepicker.version = \"1.13.2\";\n\n    return $.datepicker;\n\n} );\n","jquery/ui-modules/widgets/accordion.js":"/*!\n * jQuery UI Accordion 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Accordion\n//>>group: Widgets\n/* eslint-disable max-len */\n//>>description: Displays collapsible content panels for presenting information in a limited amount of space.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/accordion/\n//>>demos: http://jqueryui.com/accordion/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/accordion.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../keycode\",\n            \"../unique-id\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.accordion\", {\n        version: \"1.13.2\",\n        options: {\n            active: 0,\n            animate: {},\n            classes: {\n                \"ui-accordion-header\": \"ui-corner-top\",\n                \"ui-accordion-header-collapsed\": \"ui-corner-all\",\n                \"ui-accordion-content\": \"ui-corner-bottom\"\n            },\n            collapsible: false,\n            event: \"click\",\n            header: function( elem ) {\n                return elem.find( \"> li > :first-child\" ).add( elem.find( \"> :not(li)\" ).even() );\n            },\n            heightStyle: \"auto\",\n            icons: {\n                activeHeader: \"ui-icon-triangle-1-s\",\n                header: \"ui-icon-triangle-1-e\"\n            },\n\n            // Callbacks\n            activate: null,\n            beforeActivate: null\n        },\n\n        hideProps: {\n            borderTopWidth: \"hide\",\n            borderBottomWidth: \"hide\",\n            paddingTop: \"hide\",\n            paddingBottom: \"hide\",\n            height: \"hide\"\n        },\n\n        showProps: {\n            borderTopWidth: \"show\",\n            borderBottomWidth: \"show\",\n            paddingTop: \"show\",\n            paddingBottom: \"show\",\n            height: \"show\"\n        },\n\n        _create: function() {\n            var options = this.options;\n\n            this.prevShow = this.prevHide = $();\n            this._addClass( \"ui-accordion\", \"ui-widget ui-helper-reset\" );\n            this.element.attr( \"role\", \"tablist\" );\n\n            // Don't allow collapsible: false and active: false / null\n            if ( !options.collapsible && ( options.active === false || options.active == null ) ) {\n                options.active = 0;\n            }\n\n            this._processPanels();\n\n            // handle negative values\n            if ( options.active < 0 ) {\n                options.active += this.headers.length;\n            }\n            this._refresh();\n        },\n\n        _getCreateEventData: function() {\n            return {\n                header: this.active,\n                panel: !this.active.length ? $() : this.active.next()\n            };\n        },\n\n        _createIcons: function() {\n            var icon, children,\n                icons = this.options.icons;\n\n            if ( icons ) {\n                icon = $( \"<span>\" );\n                this._addClass( icon, \"ui-accordion-header-icon\", \"ui-icon \" + icons.header );\n                icon.prependTo( this.headers );\n                children = this.active.children( \".ui-accordion-header-icon\" );\n                this._removeClass( children, icons.header )\n                    ._addClass( children, null, icons.activeHeader )\n                    ._addClass( this.headers, \"ui-accordion-icons\" );\n            }\n        },\n\n        _destroyIcons: function() {\n            this._removeClass( this.headers, \"ui-accordion-icons\" );\n            this.headers.children( \".ui-accordion-header-icon\" ).remove();\n        },\n\n        _destroy: function() {\n            var contents;\n\n            // Clean up main element\n            this.element.removeAttr( \"role\" );\n\n            // Clean up headers\n            this.headers\n                .removeAttr( \"role aria-expanded aria-selected aria-controls tabIndex\" )\n                .removeUniqueId();\n\n            this._destroyIcons();\n\n            // Clean up content panels\n            contents = this.headers.next()\n                .css( \"display\", \"\" )\n                .removeAttr( \"role aria-hidden aria-labelledby\" )\n                .removeUniqueId();\n\n            if ( this.options.heightStyle !== \"content\" ) {\n                contents.css( \"height\", \"\" );\n            }\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"active\" ) {\n\n                // _activate() will handle invalid values and update this.options\n                this._activate( value );\n                return;\n            }\n\n            if ( key === \"event\" ) {\n                if ( this.options.event ) {\n                    this._off( this.headers, this.options.event );\n                }\n                this._setupEvents( value );\n            }\n\n            this._super( key, value );\n\n            // Setting collapsible: false while collapsed; open first panel\n            if ( key === \"collapsible\" && !value && this.options.active === false ) {\n                this._activate( 0 );\n            }\n\n            if ( key === \"icons\" ) {\n                this._destroyIcons();\n                if ( value ) {\n                    this._createIcons();\n                }\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this.element.attr( \"aria-disabled\", value );\n\n            // Support: IE8 Only\n            // #5332 / #6059 - opacity doesn't cascade to positioned elements in IE\n            // so we need to add the disabled class to the headers and panels\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n            this._toggleClass( this.headers.add( this.headers.next() ), null, \"ui-state-disabled\",\n                !!value );\n        },\n\n        _keydown: function( event ) {\n            if ( event.altKey || event.ctrlKey ) {\n                return;\n            }\n\n            var keyCode = $.ui.keyCode,\n                length = this.headers.length,\n                currentIndex = this.headers.index( event.target ),\n                toFocus = false;\n\n            switch ( event.keyCode ) {\n                case keyCode.RIGHT:\n                case keyCode.DOWN:\n                    toFocus = this.headers[ ( currentIndex + 1 ) % length ];\n                    break;\n                case keyCode.LEFT:\n                case keyCode.UP:\n                    toFocus = this.headers[ ( currentIndex - 1 + length ) % length ];\n                    break;\n                case keyCode.SPACE:\n                case keyCode.ENTER:\n                    this._eventHandler( event );\n                    break;\n                case keyCode.HOME:\n                    toFocus = this.headers[ 0 ];\n                    break;\n                case keyCode.END:\n                    toFocus = this.headers[ length - 1 ];\n                    break;\n            }\n\n            if ( toFocus ) {\n                $( event.target ).attr( \"tabIndex\", -1 );\n                $( toFocus ).attr( \"tabIndex\", 0 );\n                $( toFocus ).trigger( \"focus\" );\n                event.preventDefault();\n            }\n        },\n\n        _panelKeyDown: function( event ) {\n            if ( event.keyCode === $.ui.keyCode.UP && event.ctrlKey ) {\n                $( event.currentTarget ).prev().trigger( \"focus\" );\n            }\n        },\n\n        refresh: function() {\n            var options = this.options;\n            this._processPanels();\n\n            // Was collapsed or no panel\n            if ( ( options.active === false && options.collapsible === true ) ||\n                !this.headers.length ) {\n                options.active = false;\n                this.active = $();\n\n                // active false only when collapsible is true\n            } else if ( options.active === false ) {\n                this._activate( 0 );\n\n                // was active, but active panel is gone\n            } else if ( this.active.length && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n\n                // all remaining panel are disabled\n                if ( this.headers.length === this.headers.find( \".ui-state-disabled\" ).length ) {\n                    options.active = false;\n                    this.active = $();\n\n                    // activate previous panel\n                } else {\n                    this._activate( Math.max( 0, options.active - 1 ) );\n                }\n\n                // was active, active panel still exists\n            } else {\n\n                // make sure active index is correct\n                options.active = this.headers.index( this.active );\n            }\n\n            this._destroyIcons();\n\n            this._refresh();\n        },\n\n        _processPanels: function() {\n            var prevHeaders = this.headers,\n                prevPanels = this.panels;\n\n            if ( typeof this.options.header === \"function\" ) {\n                this.headers = this.options.header( this.element );\n            } else {\n                this.headers = this.element.find( this.options.header );\n            }\n            this._addClass( this.headers, \"ui-accordion-header ui-accordion-header-collapsed\",\n                \"ui-state-default\" );\n\n            this.panels = this.headers.next().filter( \":not(.ui-accordion-content-active)\" ).hide();\n            this._addClass( this.panels, \"ui-accordion-content\", \"ui-helper-reset ui-widget-content\" );\n\n            // Avoid memory leaks (#10056)\n            if ( prevPanels ) {\n                this._off( prevHeaders.not( this.headers ) );\n                this._off( prevPanels.not( this.panels ) );\n            }\n        },\n\n        _refresh: function() {\n            var maxHeight,\n                options = this.options,\n                heightStyle = options.heightStyle,\n                parent = this.element.parent();\n\n            this.active = this._findActive( options.active );\n            this._addClass( this.active, \"ui-accordion-header-active\", \"ui-state-active\" )\n                ._removeClass( this.active, \"ui-accordion-header-collapsed\" );\n            this._addClass( this.active.next(), \"ui-accordion-content-active\" );\n            this.active.next().show();\n\n            this.headers\n                .attr( \"role\", \"tab\" )\n                .each( function() {\n                    var header = $( this ),\n                        headerId = header.uniqueId().attr( \"id\" ),\n                        panel = header.next(),\n                        panelId = panel.uniqueId().attr( \"id\" );\n                    header.attr( \"aria-controls\", panelId );\n                    panel.attr( \"aria-labelledby\", headerId );\n                } )\n                .next()\n                .attr( \"role\", \"tabpanel\" );\n\n            this.headers\n                .not( this.active )\n                .attr( {\n                    \"aria-selected\": \"false\",\n                    \"aria-expanded\": \"false\",\n                    tabIndex: -1\n                } )\n                .next()\n                .attr( {\n                    \"aria-hidden\": \"true\"\n                } )\n                .hide();\n\n            // Make sure at least one header is in the tab order\n            if ( !this.active.length ) {\n                this.headers.eq( 0 ).attr( \"tabIndex\", 0 );\n            } else {\n                this.active.attr( {\n                    \"aria-selected\": \"true\",\n                    \"aria-expanded\": \"true\",\n                    tabIndex: 0\n                } )\n                    .next()\n                    .attr( {\n                        \"aria-hidden\": \"false\"\n                    } );\n            }\n\n            this._createIcons();\n\n            this._setupEvents( options.event );\n\n            if ( heightStyle === \"fill\" ) {\n                maxHeight = parent.height();\n                this.element.siblings( \":visible\" ).each( function() {\n                    var elem = $( this ),\n                        position = elem.css( \"position\" );\n\n                    if ( position === \"absolute\" || position === \"fixed\" ) {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight( true );\n                } );\n\n                this.headers.each( function() {\n                    maxHeight -= $( this ).outerHeight( true );\n                } );\n\n                this.headers.next()\n                    .each( function() {\n                        $( this ).height( Math.max( 0, maxHeight -\n                            $( this ).innerHeight() + $( this ).height() ) );\n                    } )\n                    .css( \"overflow\", \"auto\" );\n            } else if ( heightStyle === \"auto\" ) {\n                maxHeight = 0;\n                this.headers.next()\n                    .each( function() {\n                        var isVisible = $( this ).is( \":visible\" );\n                        if ( !isVisible ) {\n                            $( this ).show();\n                        }\n                        maxHeight = Math.max( maxHeight, $( this ).css( \"height\", \"\" ).height() );\n                        if ( !isVisible ) {\n                            $( this ).hide();\n                        }\n                    } )\n                    .height( maxHeight );\n            }\n        },\n\n        _activate: function( index ) {\n            var active = this._findActive( index )[ 0 ];\n\n            // Trying to activate the already active panel\n            if ( active === this.active[ 0 ] ) {\n                return;\n            }\n\n            // Trying to collapse, simulate a click on the currently active header\n            active = active || this.active[ 0 ];\n\n            this._eventHandler( {\n                target: active,\n                currentTarget: active,\n                preventDefault: $.noop\n            } );\n        },\n\n        _findActive: function( selector ) {\n            return typeof selector === \"number\" ? this.headers.eq( selector ) : $();\n        },\n\n        _setupEvents: function( event ) {\n            var events = {\n                keydown: \"_keydown\"\n            };\n            if ( event ) {\n                $.each( event.split( \" \" ), function( index, eventName ) {\n                    events[ eventName ] = \"_eventHandler\";\n                } );\n            }\n\n            this._off( this.headers.add( this.headers.next() ) );\n            this._on( this.headers, events );\n            this._on( this.headers.next(), { keydown: \"_panelKeyDown\" } );\n            this._hoverable( this.headers );\n            this._focusable( this.headers );\n        },\n\n        _eventHandler: function( event ) {\n            var activeChildren, clickedChildren,\n                options = this.options,\n                active = this.active,\n                clicked = $( event.currentTarget ),\n                clickedIsActive = clicked[ 0 ] === active[ 0 ],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : clicked.next(),\n                toHide = active.next(),\n                eventData = {\n                    oldHeader: active,\n                    oldPanel: toHide,\n                    newHeader: collapsing ? $() : clicked,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if (\n\n                // click on active header, but not collapsible\n                ( clickedIsActive && !options.collapsible ) ||\n\n                // allow canceling activation\n                ( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.headers.index( clicked );\n\n            // When the call to ._toggle() comes after the class changes\n            // it causes a very odd bug in IE 8 (see #6720)\n            this.active = clickedIsActive ? $() : clicked;\n            this._toggle( eventData );\n\n            // Switch classes\n            // corner classes on the previously active header stay after the animation\n            this._removeClass( active, \"ui-accordion-header-active\", \"ui-state-active\" );\n            if ( options.icons ) {\n                activeChildren = active.children( \".ui-accordion-header-icon\" );\n                this._removeClass( activeChildren, null, options.icons.activeHeader )\n                    ._addClass( activeChildren, null, options.icons.header );\n            }\n\n            if ( !clickedIsActive ) {\n                this._removeClass( clicked, \"ui-accordion-header-collapsed\" )\n                    ._addClass( clicked, \"ui-accordion-header-active\", \"ui-state-active\" );\n                if ( options.icons ) {\n                    clickedChildren = clicked.children( \".ui-accordion-header-icon\" );\n                    this._removeClass( clickedChildren, null, options.icons.header )\n                        ._addClass( clickedChildren, null, options.icons.activeHeader );\n                }\n\n                this._addClass( clicked.next(), \"ui-accordion-content-active\" );\n            }\n        },\n\n        _toggle: function( data ) {\n            var toShow = data.newPanel,\n                toHide = this.prevShow.length ? this.prevShow : data.oldPanel;\n\n            // Handle activating a panel during the animation for another activation\n            this.prevShow.add( this.prevHide ).stop( true, true );\n            this.prevShow = toShow;\n            this.prevHide = toHide;\n\n            if ( this.options.animate ) {\n                this._animate( toShow, toHide, data );\n            } else {\n                toHide.hide();\n                toShow.show();\n                this._toggleComplete( data );\n            }\n\n            toHide.attr( {\n                \"aria-hidden\": \"true\"\n            } );\n            toHide.prev().attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\"\n            } );\n\n            // if we're switching panels, remove the old header from the tab order\n            // if we're opening from collapsed state, remove the previous header from the tab order\n            // if we're collapsing, then keep the collapsing header in the tab order\n            if ( toShow.length && toHide.length ) {\n                toHide.prev().attr( {\n                    \"tabIndex\": -1,\n                    \"aria-expanded\": \"false\"\n                } );\n            } else if ( toShow.length ) {\n                this.headers.filter( function() {\n                    return parseInt( $( this ).attr( \"tabIndex\" ), 10 ) === 0;\n                } )\n                    .attr( \"tabIndex\", -1 );\n            }\n\n            toShow\n                .attr( \"aria-hidden\", \"false\" )\n                .prev()\n                .attr( {\n                    \"aria-selected\": \"true\",\n                    \"aria-expanded\": \"true\",\n                    tabIndex: 0\n                } );\n        },\n\n        _animate: function( toShow, toHide, data ) {\n            var total, easing, duration,\n                that = this,\n                adjust = 0,\n                boxSizing = toShow.css( \"box-sizing\" ),\n                down = toShow.length &&\n                    ( !toHide.length || ( toShow.index() < toHide.index() ) ),\n                animate = this.options.animate || {},\n                options = down && animate.down || animate,\n                complete = function() {\n                    that._toggleComplete( data );\n                };\n\n            if ( typeof options === \"number\" ) {\n                duration = options;\n            }\n            if ( typeof options === \"string\" ) {\n                easing = options;\n            }\n\n            // fall back from options to animation in case of partial down settings\n            easing = easing || options.easing || animate.easing;\n            duration = duration || options.duration || animate.duration;\n\n            if ( !toHide.length ) {\n                return toShow.animate( this.showProps, duration, easing, complete );\n            }\n            if ( !toShow.length ) {\n                return toHide.animate( this.hideProps, duration, easing, complete );\n            }\n\n            total = toShow.show().outerHeight();\n            toHide.animate( this.hideProps, {\n                duration: duration,\n                easing: easing,\n                step: function( now, fx ) {\n                    fx.now = Math.round( now );\n                }\n            } );\n            toShow\n                .hide()\n                .animate( this.showProps, {\n                    duration: duration,\n                    easing: easing,\n                    complete: complete,\n                    step: function( now, fx ) {\n                        fx.now = Math.round( now );\n                        if ( fx.prop !== \"height\" ) {\n                            if ( boxSizing === \"content-box\" ) {\n                                adjust += fx.now;\n                            }\n                        } else if ( that.options.heightStyle !== \"content\" ) {\n                            fx.now = Math.round( total - toHide.outerHeight() - adjust );\n                            adjust = 0;\n                        }\n                    }\n                } );\n        },\n\n        _toggleComplete: function( data ) {\n            var toHide = data.oldPanel,\n                prev = toHide.prev();\n\n            this._removeClass( toHide, \"ui-accordion-content-active\" );\n            this._removeClass( prev, \"ui-accordion-header-active\" )\n                ._addClass( prev, \"ui-accordion-header-collapsed\" );\n\n            // Work around for rendering bug in IE (#5421)\n            if ( toHide.length ) {\n                toHide.parent()[ 0 ].className = toHide.parent()[ 0 ].className;\n            }\n            this._trigger( \"activate\", null, data );\n        }\n    } );\n\n} );\n","jquery/ui-modules/vendor/jquery-color/jquery.color.js":"/*!\n * jQuery Color Animations v2.2.0\n * https://github.com/jquery/jquery-color\n *\n * Copyright OpenJS Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * Date: Sun May 10 09:02:36 2020 +0200\n */\n\n( function( root, factory ) {\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\" ], factory );\n\t} else if ( typeof exports === \"object\" ) {\n\t\tmodule.exports = factory( require( \"jquery\" ) );\n\t} else {\n\t\tfactory( root.jQuery );\n\t}\n} )( this, function( jQuery, undefined ) {\n\n\tvar stepHooks = \"backgroundColor borderBottomColor borderLeftColor borderRightColor \" +\n\t\t\"borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor\",\n\n\tclass2type = {},\n\ttoString = class2type.toString,\n\n\t// plusequals test for += 100 -= 100\n\trplusequals = /^([\\-+])=\\s*(\\d+\\.?\\d*)/,\n\n\t// a set of RE's that can match strings and generate color tuples.\n\tstringParsers = [ {\n\t\t\tre: /rgba?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ],\n\t\t\t\t\texecResult[ 3 ],\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /rgba?\\(\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ] * 2.55,\n\t\t\t\t\texecResult[ 2 ] * 2.55,\n\t\t\t\t\texecResult[ 3 ] * 2.55,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ], 16 ),\n\t\t\t\t\texecResult[ 4 ] ?\n\t\t\t\t\t\t( parseInt( execResult[ 4 ], 16 ) / 255 ).toFixed( 2 ) :\n\t\t\t\t\t\t1\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ] + execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ] + execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ] + execResult[ 3 ], 16 ),\n\t\t\t\t\texecResult[ 4 ] ?\n\t\t\t\t\t\t( parseInt( execResult[ 4 ] + execResult[ 4 ], 16 ) / 255 )\n\t\t\t\t\t\t\t.toFixed( 2 ) :\n\t\t\t\t\t\t1\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /hsla?\\(\\s*(\\d+(?:\\.\\d+)?)\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tspace: \"hsla\",\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ] / 100,\n\t\t\t\t\texecResult[ 3 ] / 100,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t} ],\n\n\t// jQuery.Color( )\n\tcolor = jQuery.Color = function( color, green, blue, alpha ) {\n\t\treturn new jQuery.Color.fn.parse( color, green, blue, alpha );\n\t},\n\tspaces = {\n\t\trgba: {\n\t\t\tprops: {\n\t\t\t\tred: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tgreen: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tblue: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\thsla: {\n\t\t\tprops: {\n\t\t\t\thue: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"degrees\"\n\t\t\t\t},\n\t\t\t\tsaturation: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t},\n\t\t\t\tlightness: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\tpropTypes = {\n\t\t\"byte\": {\n\t\t\tfloor: true,\n\t\t\tmax: 255\n\t\t},\n\t\t\"percent\": {\n\t\t\tmax: 1\n\t\t},\n\t\t\"degrees\": {\n\t\t\tmod: 360,\n\t\t\tfloor: true\n\t\t}\n\t},\n\tsupport = color.support = {},\n\n\t// element for support tests\n\tsupportElem = jQuery( \"<p>\" )[ 0 ],\n\n\t// colors = jQuery.Color.names\n\tcolors,\n\n\t// local aliases of functions called often\n\teach = jQuery.each;\n\n// determine rgba support immediately\nsupportElem.style.cssText = \"background-color:rgba(1,1,1,.5)\";\nsupport.rgba = supportElem.style.backgroundColor.indexOf( \"rgba\" ) > -1;\n\n// define cache name and alpha properties\n// for rgba and hsla spaces\neach( spaces, function( spaceName, space ) {\n\tspace.cache = \"_\" + spaceName;\n\tspace.props.alpha = {\n\t\tidx: 3,\n\t\ttype: \"percent\",\n\t\tdef: 1\n\t};\n} );\n\n// Populate the class2type map\njQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n\tfunction( _i, name ) {\n\t\tclass2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n\t} );\n\nfunction getType( obj ) {\n\tif ( obj == null ) {\n\t\treturn obj + \"\";\n\t}\n\n\treturn typeof obj === \"object\" ?\n\t\tclass2type[ toString.call( obj ) ] || \"object\" :\n\t\ttypeof obj;\n}\n\nfunction clamp( value, prop, allowEmpty ) {\n\tvar type = propTypes[ prop.type ] || {};\n\n\tif ( value == null ) {\n\t\treturn ( allowEmpty || !prop.def ) ? null : prop.def;\n\t}\n\n\t// ~~ is an short way of doing floor for positive numbers\n\tvalue = type.floor ? ~~value : parseFloat( value );\n\n\t// IE will pass in empty strings as value for alpha,\n\t// which will hit this case\n\tif ( isNaN( value ) ) {\n\t\treturn prop.def;\n\t}\n\n\tif ( type.mod ) {\n\n\t\t// we add mod before modding to make sure that negatives values\n\t\t// get converted properly: -10 -> 350\n\t\treturn ( value + type.mod ) % type.mod;\n\t}\n\n\t// for now all property types without mod have min and max\n\treturn Math.min( type.max, Math.max( 0, value ) );\n}\n\nfunction stringParse( string ) {\n\tvar inst = color(),\n\t\trgba = inst._rgba = [];\n\n\tstring = string.toLowerCase();\n\n\teach( stringParsers, function( _i, parser ) {\n\t\tvar parsed,\n\t\t\tmatch = parser.re.exec( string ),\n\t\t\tvalues = match && parser.parse( match ),\n\t\t\tspaceName = parser.space || \"rgba\";\n\n\t\tif ( values ) {\n\t\t\tparsed = inst[ spaceName ]( values );\n\n\t\t\t// if this was an rgba parse the assignment might happen twice\n\t\t\t// oh well....\n\t\t\tinst[ spaces[ spaceName ].cache ] = parsed[ spaces[ spaceName ].cache ];\n\t\t\trgba = inst._rgba = parsed._rgba;\n\n\t\t\t// exit each( stringParsers ) here because we matched\n\t\t\treturn false;\n\t\t}\n\t} );\n\n\t// Found a stringParser that handled it\n\tif ( rgba.length ) {\n\n\t\t// if this came from a parsed string, force \"transparent\" when alpha is 0\n\t\t// chrome, (and maybe others) return \"transparent\" as rgba(0,0,0,0)\n\t\tif ( rgba.join() === \"0,0,0,0\" ) {\n\t\t\tjQuery.extend( rgba, colors.transparent );\n\t\t}\n\t\treturn inst;\n\t}\n\n\t// named colors\n\treturn colors[ string ];\n}\n\ncolor.fn = jQuery.extend( color.prototype, {\n\tparse: function( red, green, blue, alpha ) {\n\t\tif ( red === undefined ) {\n\t\t\tthis._rgba = [ null, null, null, null ];\n\t\t\treturn this;\n\t\t}\n\t\tif ( red.jquery || red.nodeType ) {\n\t\t\tred = jQuery( red ).css( green );\n\t\t\tgreen = undefined;\n\t\t}\n\n\t\tvar inst = this,\n\t\t\ttype = getType( red ),\n\t\t\trgba = this._rgba = [];\n\n\t\t// more than 1 argument specified - assume ( red, green, blue, alpha )\n\t\tif ( green !== undefined ) {\n\t\t\tred = [ red, green, blue, alpha ];\n\t\t\ttype = \"array\";\n\t\t}\n\n\t\tif ( type === \"string\" ) {\n\t\t\treturn this.parse( stringParse( red ) || colors._default );\n\t\t}\n\n\t\tif ( type === \"array\" ) {\n\t\t\teach( spaces.rgba.props, function( _key, prop ) {\n\t\t\t\trgba[ prop.idx ] = clamp( red[ prop.idx ], prop );\n\t\t\t} );\n\t\t\treturn this;\n\t\t}\n\n\t\tif ( type === \"object\" ) {\n\t\t\tif ( red instanceof color ) {\n\t\t\t\teach( spaces, function( _spaceName, space ) {\n\t\t\t\t\tif ( red[ space.cache ] ) {\n\t\t\t\t\t\tinst[ space.cache ] = red[ space.cache ].slice();\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t} else {\n\t\t\t\teach( spaces, function( _spaceName, space ) {\n\t\t\t\t\tvar cache = space.cache;\n\t\t\t\t\teach( space.props, function( key, prop ) {\n\n\t\t\t\t\t\t// if the cache doesn't exist, and we know how to convert\n\t\t\t\t\t\tif ( !inst[ cache ] && space.to ) {\n\n\t\t\t\t\t\t\t// if the value was null, we don't need to copy it\n\t\t\t\t\t\t\t// if the key was alpha, we don't need to copy it either\n\t\t\t\t\t\t\tif ( key === \"alpha\" || red[ key ] == null ) {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tinst[ cache ] = space.to( inst._rgba );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// this is the only case where we allow nulls for ALL properties.\n\t\t\t\t\t\t// call clamp with alwaysAllowEmpty\n\t\t\t\t\t\tinst[ cache ][ prop.idx ] = clamp( red[ key ], prop, true );\n\t\t\t\t\t} );\n\n\t\t\t\t\t// everything defined but alpha?\n\t\t\t\t\tif ( inst[ cache ] && jQuery.inArray( null, inst[ cache ].slice( 0, 3 ) ) < 0 ) {\n\n\t\t\t\t\t\t// use the default of 1\n\t\t\t\t\t\tif ( inst[ cache ][ 3 ] == null ) {\n\t\t\t\t\t\t\tinst[ cache ][ 3 ] = 1;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( space.from ) {\n\t\t\t\t\t\t\tinst._rgba = space.from( inst[ cache ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t},\n\tis: function( compare ) {\n\t\tvar is = color( compare ),\n\t\t\tsame = true,\n\t\t\tinst = this;\n\n\t\teach( spaces, function( _, space ) {\n\t\t\tvar localCache,\n\t\t\t\tisCache = is[ space.cache ];\n\t\t\tif ( isCache ) {\n\t\t\t\tlocalCache = inst[ space.cache ] || space.to && space.to( inst._rgba ) || [];\n\t\t\t\teach( space.props, function( _, prop ) {\n\t\t\t\t\tif ( isCache[ prop.idx ] != null ) {\n\t\t\t\t\t\tsame = ( isCache[ prop.idx ] === localCache[ prop.idx ] );\n\t\t\t\t\t\treturn same;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn same;\n\t\t} );\n\t\treturn same;\n\t},\n\t_space: function() {\n\t\tvar used = [],\n\t\t\tinst = this;\n\t\teach( spaces, function( spaceName, space ) {\n\t\t\tif ( inst[ space.cache ] ) {\n\t\t\t\tused.push( spaceName );\n\t\t\t}\n\t\t} );\n\t\treturn used.pop();\n\t},\n\ttransition: function( other, distance ) {\n\t\tvar end = color( other ),\n\t\t\tspaceName = end._space(),\n\t\t\tspace = spaces[ spaceName ],\n\t\t\tstartColor = this.alpha() === 0 ? color( \"transparent\" ) : this,\n\t\t\tstart = startColor[ space.cache ] || space.to( startColor._rgba ),\n\t\t\tresult = start.slice();\n\n\t\tend = end[ space.cache ];\n\t\teach( space.props, function( _key, prop ) {\n\t\t\tvar index = prop.idx,\n\t\t\t\tstartValue = start[ index ],\n\t\t\t\tendValue = end[ index ],\n\t\t\t\ttype = propTypes[ prop.type ] || {};\n\n\t\t\t// if null, don't override start value\n\t\t\tif ( endValue === null ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// if null - use end\n\t\t\tif ( startValue === null ) {\n\t\t\t\tresult[ index ] = endValue;\n\t\t\t} else {\n\t\t\t\tif ( type.mod ) {\n\t\t\t\t\tif ( endValue - startValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue += type.mod;\n\t\t\t\t\t} else if ( startValue - endValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue -= type.mod;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tresult[ index ] = clamp( ( endValue - startValue ) * distance + startValue, prop );\n\t\t\t}\n\t\t} );\n\t\treturn this[ spaceName ]( result );\n\t},\n\tblend: function( opaque ) {\n\n\t\t// if we are already opaque - return ourself\n\t\tif ( this._rgba[ 3 ] === 1 ) {\n\t\t\treturn this;\n\t\t}\n\n\t\tvar rgb = this._rgba.slice(),\n\t\t\ta = rgb.pop(),\n\t\t\tblend = color( opaque )._rgba;\n\n\t\treturn color( jQuery.map( rgb, function( v, i ) {\n\t\t\treturn ( 1 - a ) * blend[ i ] + a * v;\n\t\t} ) );\n\t},\n\ttoRgbaString: function() {\n\t\tvar prefix = \"rgba(\",\n\t\t\trgba = jQuery.map( this._rgba, function( v, i ) {\n\t\t\t\tif ( v != null ) {\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\t\t\t\treturn i > 2 ? 1 : 0;\n\t\t\t} );\n\n\t\tif ( rgba[ 3 ] === 1 ) {\n\t\t\trgba.pop();\n\t\t\tprefix = \"rgb(\";\n\t\t}\n\n\t\treturn prefix + rgba.join() + \")\";\n\t},\n\ttoHslaString: function() {\n\t\tvar prefix = \"hsla(\",\n\t\t\thsla = jQuery.map( this.hsla(), function( v, i ) {\n\t\t\t\tif ( v == null ) {\n\t\t\t\t\tv = i > 2 ? 1 : 0;\n\t\t\t\t}\n\n\t\t\t\t// catch 1 and 2\n\t\t\t\tif ( i && i < 3 ) {\n\t\t\t\t\tv = Math.round( v * 100 ) + \"%\";\n\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t} );\n\n\t\tif ( hsla[ 3 ] === 1 ) {\n\t\t\thsla.pop();\n\t\t\tprefix = \"hsl(\";\n\t\t}\n\t\treturn prefix + hsla.join() + \")\";\n\t},\n\ttoHexString: function( includeAlpha ) {\n\t\tvar rgba = this._rgba.slice(),\n\t\t\talpha = rgba.pop();\n\n\t\tif ( includeAlpha ) {\n\t\t\trgba.push( ~~( alpha * 255 ) );\n\t\t}\n\n\t\treturn \"#\" + jQuery.map( rgba, function( v ) {\n\n\t\t\t// default to 0 when nulls exist\n\t\t\tv = ( v || 0 ).toString( 16 );\n\t\t\treturn v.length === 1 ? \"0\" + v : v;\n\t\t} ).join( \"\" );\n\t},\n\ttoString: function() {\n\t\treturn this._rgba[ 3 ] === 0 ? \"transparent\" : this.toRgbaString();\n\t}\n} );\ncolor.fn.parse.prototype = color.fn;\n\n// hsla conversions adapted from:\n// https://code.google.com/p/maashaack/source/browse/packages/graphics/trunk/src/graphics/colors/HUE2RGB.as?r=5021\n\nfunction hue2rgb( p, q, h ) {\n\th = ( h + 1 ) % 1;\n\tif ( h * 6 < 1 ) {\n\t\treturn p + ( q - p ) * h * 6;\n\t}\n\tif ( h * 2 < 1 ) {\n\t\treturn q;\n\t}\n\tif ( h * 3 < 2 ) {\n\t\treturn p + ( q - p ) * ( ( 2 / 3 ) - h ) * 6;\n\t}\n\treturn p;\n}\n\nspaces.hsla.to = function( rgba ) {\n\tif ( rgba[ 0 ] == null || rgba[ 1 ] == null || rgba[ 2 ] == null ) {\n\t\treturn [ null, null, null, rgba[ 3 ] ];\n\t}\n\tvar r = rgba[ 0 ] / 255,\n\t\tg = rgba[ 1 ] / 255,\n\t\tb = rgba[ 2 ] / 255,\n\t\ta = rgba[ 3 ],\n\t\tmax = Math.max( r, g, b ),\n\t\tmin = Math.min( r, g, b ),\n\t\tdiff = max - min,\n\t\tadd = max + min,\n\t\tl = add * 0.5,\n\t\th, s;\n\n\tif ( min === max ) {\n\t\th = 0;\n\t} else if ( r === max ) {\n\t\th = ( 60 * ( g - b ) / diff ) + 360;\n\t} else if ( g === max ) {\n\t\th = ( 60 * ( b - r ) / diff ) + 120;\n\t} else {\n\t\th = ( 60 * ( r - g ) / diff ) + 240;\n\t}\n\n\t// chroma (diff) == 0 means greyscale which, by definition, saturation = 0%\n\t// otherwise, saturation is based on the ratio of chroma (diff) to lightness (add)\n\tif ( diff === 0 ) {\n\t\ts = 0;\n\t} else if ( l <= 0.5 ) {\n\t\ts = diff / add;\n\t} else {\n\t\ts = diff / ( 2 - add );\n\t}\n\treturn [ Math.round( h ) % 360, s, l, a == null ? 1 : a ];\n};\n\nspaces.hsla.from = function( hsla ) {\n\tif ( hsla[ 0 ] == null || hsla[ 1 ] == null || hsla[ 2 ] == null ) {\n\t\treturn [ null, null, null, hsla[ 3 ] ];\n\t}\n\tvar h = hsla[ 0 ] / 360,\n\t\ts = hsla[ 1 ],\n\t\tl = hsla[ 2 ],\n\t\ta = hsla[ 3 ],\n\t\tq = l <= 0.5 ? l * ( 1 + s ) : l + s - l * s,\n\t\tp = 2 * l - q;\n\n\treturn [\n\t\tMath.round( hue2rgb( p, q, h + ( 1 / 3 ) ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h - ( 1 / 3 ) ) * 255 ),\n\t\ta\n\t];\n};\n\n\neach( spaces, function( spaceName, space ) {\n\tvar props = space.props,\n\t\tcache = space.cache,\n\t\tto = space.to,\n\t\tfrom = space.from;\n\n\t// makes rgba() and hsla()\n\tcolor.fn[ spaceName ] = function( value ) {\n\n\t\t// generate a cache for this space if it doesn't exist\n\t\tif ( to && !this[ cache ] ) {\n\t\t\tthis[ cache ] = to( this._rgba );\n\t\t}\n\t\tif ( value === undefined ) {\n\t\t\treturn this[ cache ].slice();\n\t\t}\n\n\t\tvar ret,\n\t\t\ttype = getType( value ),\n\t\t\tarr = ( type === \"array\" || type === \"object\" ) ? value : arguments,\n\t\t\tlocal = this[ cache ].slice();\n\n\t\teach( props, function( key, prop ) {\n\t\t\tvar val = arr[ type === \"object\" ? key : prop.idx ];\n\t\t\tif ( val == null ) {\n\t\t\t\tval = local[ prop.idx ];\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = clamp( val, prop );\n\t\t} );\n\n\t\tif ( from ) {\n\t\t\tret = color( from( local ) );\n\t\t\tret[ cache ] = local;\n\t\t\treturn ret;\n\t\t} else {\n\t\t\treturn color( local );\n\t\t}\n\t};\n\n\t// makes red() green() blue() alpha() hue() saturation() lightness()\n\teach( props, function( key, prop ) {\n\n\t\t// alpha is included in more than one space\n\t\tif ( color.fn[ key ] ) {\n\t\t\treturn;\n\t\t}\n\t\tcolor.fn[ key ] = function( value ) {\n\t\t\tvar local, cur, match, fn,\n\t\t\t\tvtype = getType( value );\n\n\t\t\tif ( key === \"alpha\" ) {\n\t\t\t\tfn = this._hsla ? \"hsla\" : \"rgba\";\n\t\t\t} else {\n\t\t\t\tfn = spaceName;\n\t\t\t}\n\t\t\tlocal = this[ fn ]();\n\t\t\tcur = local[ prop.idx ];\n\n\t\t\tif ( vtype === \"undefined\" ) {\n\t\t\t\treturn cur;\n\t\t\t}\n\n\t\t\tif ( vtype === \"function\" ) {\n\t\t\t\tvalue = value.call( this, cur );\n\t\t\t\tvtype = getType( value );\n\t\t\t}\n\t\t\tif ( value == null && prop.empty ) {\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( vtype === \"string\" ) {\n\t\t\t\tmatch = rplusequals.exec( value );\n\t\t\t\tif ( match ) {\n\t\t\t\t\tvalue = cur + parseFloat( match[ 2 ] ) * ( match[ 1 ] === \"+\" ? 1 : -1 );\n\t\t\t\t}\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = value;\n\t\t\treturn this[ fn ]( local );\n\t\t};\n\t} );\n} );\n\n// add cssHook and .fx.step function for each named hook.\n// accept a space separated string of properties\ncolor.hook = function( hook ) {\n\tvar hooks = hook.split( \" \" );\n\teach( hooks, function( _i, hook ) {\n\t\tjQuery.cssHooks[ hook ] = {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tvar parsed, curElem,\n\t\t\t\t\tbackgroundColor = \"\";\n\n\t\t\t\tif ( value !== \"transparent\" && ( getType( value ) !== \"string\" || ( parsed = stringParse( value ) ) ) ) {\n\t\t\t\t\tvalue = color( parsed || value );\n\t\t\t\t\tif ( !support.rgba && value._rgba[ 3 ] !== 1 ) {\n\t\t\t\t\t\tcurElem = hook === \"backgroundColor\" ? elem.parentNode : elem;\n\t\t\t\t\t\twhile (\n\t\t\t\t\t\t\t( backgroundColor === \"\" || backgroundColor === \"transparent\" ) &&\n\t\t\t\t\t\t\tcurElem && curElem.style\n\t\t\t\t\t\t) {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tbackgroundColor = jQuery.css( curElem, \"backgroundColor\" );\n\t\t\t\t\t\t\t\tcurElem = curElem.parentNode;\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvalue = value.blend( backgroundColor && backgroundColor !== \"transparent\" ?\n\t\t\t\t\t\t\tbackgroundColor :\n\t\t\t\t\t\t\t\"_default\" );\n\t\t\t\t\t}\n\n\t\t\t\t\tvalue = value.toRgbaString();\n\t\t\t\t}\n\t\t\t\ttry {\n\t\t\t\t\telem.style[ hook ] = value;\n\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t// wrapped to prevent IE from throwing errors on \"invalid\" values like 'auto' or 'inherit'\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t\tjQuery.fx.step[ hook ] = function( fx ) {\n\t\t\tif ( !fx.colorInit ) {\n\t\t\t\tfx.start = color( fx.elem, hook );\n\t\t\t\tfx.end = color( fx.end );\n\t\t\t\tfx.colorInit = true;\n\t\t\t}\n\t\t\tjQuery.cssHooks[ hook ].set( fx.elem, fx.start.transition( fx.end, fx.pos ) );\n\t\t};\n\t} );\n\n};\n\ncolor.hook( stepHooks );\n\njQuery.cssHooks.borderColor = {\n\texpand: function( value ) {\n\t\tvar expanded = {};\n\n\t\teach( [ \"Top\", \"Right\", \"Bottom\", \"Left\" ], function( _i, part ) {\n\t\t\texpanded[ \"border\" + part + \"Color\" ] = value;\n\t\t} );\n\t\treturn expanded;\n\t}\n};\n\n// Basic color names only.\n// Usage of any of the other color names requires adding yourself or including\n// jquery.color.svg-names.js.\ncolors = jQuery.Color.names = {\n\n\t// 4.1. Basic color keywords\n\taqua: \"#00ffff\",\n\tblack: \"#000000\",\n\tblue: \"#0000ff\",\n\tfuchsia: \"#ff00ff\",\n\tgray: \"#808080\",\n\tgreen: \"#008000\",\n\tlime: \"#00ff00\",\n\tmaroon: \"#800000\",\n\tnavy: \"#000080\",\n\tolive: \"#808000\",\n\tpurple: \"#800080\",\n\tred: \"#ff0000\",\n\tsilver: \"#c0c0c0\",\n\tteal: \"#008080\",\n\twhite: \"#ffffff\",\n\tyellow: \"#ffff00\",\n\n\t// 4.2.3. \"transparent\" color keyword\n\ttransparent: [ null, null, null, 0 ],\n\n\t_default: \"#ffffff\"\n};\n\n} );\n","jquery/patches/jquery-ui-sortable.js":"/*!\n * jQuery UI Sortable\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Patch for sortable widget.\n     * Can safely remove only when jQuery UI is upgraded to >= 1.13.1.\n     * Fixes:\n     * https://github.com/jquery/jquery-ui/pull/2008\n     * https://github.com/jquery/jquery-ui/pull/2009\n     */\n    var sortablePatch = {\n        /** @inheritdoc */\n        _mouseDrag: function (event) {\n            var i, item, itemElement, intersection,\n                o = this.options;\n\n            //Compute the helpers position\n            this.position = this._generatePosition(event);\n            this.positionAbs = this._convertPositionTo(\"absolute\");\n\n            //Set the helper position\n            if (!this.options.axis || this.options.axis !== \"y\") {\n                this.helper[0].style.left = this.position.left + \"px\";\n            }\n            if (!this.options.axis || this.options.axis !== \"x\") {\n                this.helper[0].style.top = this.position.top + \"px\";\n            }\n\n            //Do scrolling\n            if (o.scroll) {\n                if (this._scroll(event) !== false) {\n\n                    //Update item positions used in position checks\n                    this._refreshItemPositions(true);\n\n                    if ($.ui.ddmanager && !o.dropBehaviour) {\n                        $.ui.ddmanager.prepareOffsets(this, event);\n                    }\n                }\n            }\n\n            this.dragDirection = {\n                vertical: this._getDragVerticalDirection(),\n                horizontal: this._getDragHorizontalDirection()\n            };\n\n            //Rearrange\n            for (i = this.items.length - 1; i >= 0; i--) {\n\n                //Cache variables and intersection, continue if no intersection\n                item = this.items[i];\n                itemElement = item.item[0];\n                intersection = this._intersectsWithPointer(item);\n                if (!intersection) {\n                    continue;\n                }\n\n                // Only put the placeholder inside the current Container, skip all\n                // items from other containers. This works because when moving\n                // an item from one container to another the\n                // currentContainer is switched before the placeholder is moved.\n                //\n                // Without this, moving items in \"sub-sortables\" can cause\n                // the placeholder to jitter between the outer and inner container.\n                if (item.instance !== this.currentContainer) {\n                    continue;\n                }\n\n                // Cannot intersect with itself\n                // no useless actions that have been done before\n                // no action if the item moved is the parent of the item checked\n                if (itemElement !== this.currentItem[0] &&\n                    this.placeholder[intersection === 1 ?\n                        \"next\" : \"prev\"]()[0] !== itemElement &&\n                    !$.contains(this.placeholder[0], itemElement) &&\n                    (this.options.type === \"semi-dynamic\" ?\n                            !$.contains(this.element[0], itemElement) :\n                            true\n                    )\n                ) {\n\n                    this.direction = intersection === 1 ? \"down\" : \"up\";\n\n                    if (this.options.tolerance === \"pointer\" ||\n                        this._intersectsWithSides(item)) {\n                        this._rearrange(event, item);\n                    } else {\n                        break;\n                    }\n\n                    this._trigger(\"change\", event, this._uiHash());\n                    break;\n                }\n            }\n\n            //Post events to containers\n            this._contactContainers(event);\n\n            //Interconnect with droppables\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.drag(this, event);\n            }\n\n            //Call callbacks\n            this._trigger(\"sort\", event, this._uiHash());\n\n            this.lastPositionAbs = this.positionAbs;\n            return false;\n\n        },\n\n        /** @inheritdoc */\n        refreshPositions: function (fast) {\n\n            // Determine whether items are being displayed horizontally\n            this.floating = this.items.length ?\n                this.options.axis === \"x\" || this._isFloating(this.items[0].item) :\n                false;\n\n            // This has to be redone because due to the item being moved out/into the offsetParent,\n            // the offsetParent's position will change\n            if (this.offsetParent && this.helper) {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            this._refreshItemPositions(fast);\n\n            var i, p;\n\n            if (this.options.custom && this.options.custom.refreshContainers) {\n                this.options.custom.refreshContainers.call(this);\n            } else {\n                for (i = this.containers.length - 1; i >= 0; i--) {\n                    p = this.containers[i].element.offset();\n                    this.containers[i].containerCache.left = p.left;\n                    this.containers[i].containerCache.top = p.top;\n                    this.containers[i].containerCache.width =\n                        this.containers[i].element.outerWidth();\n                    this.containers[i].containerCache.height =\n                        this.containers[i].element.outerHeight();\n                }\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        _contactContainers: function (event) {\n            var i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, cur, nearBottom,\n                floating, axis,\n                innermostContainer = null,\n                innermostIndex = null;\n\n            // Get innermost container that intersects with item\n            for (i = this.containers.length - 1; i >= 0; i--) {\n\n                // Never consider a container that's located within the item itself\n                if ($.contains(this.currentItem[0], this.containers[i].element[0])) {\n                    continue;\n                }\n\n                if (this._intersectsWith(this.containers[i].containerCache)) {\n\n                    // If we've already found a container and it's more \"inner\" than this, then continue\n                    if (innermostContainer &&\n                        $.contains(\n                            this.containers[i].element[0],\n                            innermostContainer.element[0])) {\n                        continue;\n                    }\n\n                    innermostContainer = this.containers[i];\n                    innermostIndex = i;\n\n                } else {\n\n                    // container doesn't intersect. trigger \"out\" event if necessary\n                    if (this.containers[i].containerCache.over) {\n                        this.containers[i]._trigger(\"out\", event, this._uiHash(this));\n                        this.containers[i].containerCache.over = 0;\n                    }\n                }\n\n            }\n\n            // If no intersecting containers found, return\n            if (!innermostContainer) {\n                return;\n            }\n\n            // Move the item into the container if it's not there already\n            if (this.containers.length === 1) {\n                if (!this.containers[innermostIndex].containerCache.over) {\n                    this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash(this));\n                    this.containers[innermostIndex].containerCache.over = 1;\n                }\n            } else {\n\n                // When entering a new container, we will find the item with the least distance and\n                // append our item near it\n                dist = 10000;\n                itemWithLeastDistance = null;\n                floating = innermostContainer.floating || this._isFloating(this.currentItem);\n                posProperty = floating ? \"left\" : \"top\";\n                sizeProperty = floating ? \"width\" : \"height\";\n                axis = floating ? \"pageX\" : \"pageY\";\n\n                for (j = this.items.length - 1; j >= 0; j--) {\n                    if (!$.contains(\n                        this.containers[innermostIndex].element[0], this.items[j].item[0])\n                    ) {\n                        continue;\n                    }\n                    if (this.items[j].item[0] === this.currentItem[0]) {\n                        continue;\n                    }\n\n                    cur = this.items[j].item.offset()[posProperty];\n                    nearBottom = false;\n                    if (event[axis] - cur > this.items[j][sizeProperty] / 2) {\n                        nearBottom = true;\n                    }\n\n                    if (Math.abs(event[axis] - cur) < dist) {\n                        dist = Math.abs(event[axis] - cur);\n                        itemWithLeastDistance = this.items[j];\n                        this.direction = nearBottom ? \"up\" : \"down\";\n                    }\n                }\n\n                //Check if dropOnEmpty is enabled\n                if (!itemWithLeastDistance && !this.options.dropOnEmpty) {\n                    return;\n                }\n\n                if (this.currentContainer === this.containers[innermostIndex]) {\n                    if (!this.currentContainer.containerCache.over) {\n                        this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash());\n                        this.currentContainer.containerCache.over = 1;\n                    }\n                    return;\n                }\n\n                if (itemWithLeastDistance) {\n                    this._rearrange(event, itemWithLeastDistance, null, true);\n                } else {\n                    this._rearrange(event, null, this.containers[innermostIndex].element, true);\n                }\n                this._trigger(\"change\", event, this._uiHash());\n                this.containers[innermostIndex]._trigger(\"change\", event, this._uiHash(this));\n                this.currentContainer = this.containers[innermostIndex];\n\n                //Update the placeholder\n                this.options.placeholder.update(this.currentContainer, this.placeholder);\n\n                //Update scrollParent\n                this.scrollParent = this.placeholder.scrollParent();\n\n                //Update overflowOffset\n                if (this.scrollParent[0] !== this.document[0] &&\n                    this.scrollParent[0].tagName !== \"HTML\") {\n                    this.overflowOffset = this.scrollParent.offset();\n                }\n\n                this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash(this));\n                this.containers[innermostIndex].containerCache.over = 1;\n            }\n\n        }\n    }\n\n    return function () {\n        var majorVersion = parseInt($.ui.version.split('.')[0]),\n            minorVersion = parseInt($.ui.version.split('.')[1]),\n            patchVersion = parseInt($.ui.version.split('.')[2])\n\n        if (majorVersion === 1 && minorVersion === 13 && patchVersion > 0 ||\n            majorVersion === 1 && minorVersion >= 14 ||\n            majorVersion >= 2\n        ) {\n            console.warn('jQuery ui sortable patch is no longer necessary, and should be removed');\n        }\n\n        $.widget('ui.sortable', $.ui.sortable, sortablePatch);\n    };\n\n});\n","jquery/colorpicker/js/colorpicker.js":"/**\n *\n * Color picker\n * Author: Stefan Petre www.eyecon.ro\n * \n * Dual licensed under the MIT and GPL licenses\n * \n */\n\ndefine([\n\t\"jquery\",\n], function ($) {\n\tvar ColorPicker = function () {\n\t\tvar\n\t\t\tids = {},\n\t\t\tinAction,\n\t\t\tcharMin = 65,\n\t\t\tvisible,\n\t\t\ttpl = '<div class=\"colorpicker\"><div class=\"colorpicker_color\"><div><div></div></div></div><div class=\"colorpicker_hue\"><div></div></div><div class=\"colorpicker_new_color\"></div><div class=\"colorpicker_current_color\"></div><div class=\"colorpicker_hex\"><input type=\"text\" maxlength=\"6\" size=\"6\" /></div><div class=\"colorpicker_rgb_r colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_g colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_rgb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_h colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_s colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_hsb_b colorpicker_field\"><input type=\"text\" maxlength=\"3\" size=\"3\" /><span></span></div><div class=\"colorpicker_submit\"></div></div>',\n\t\t\tdefaults = {\n\t\t\t\teventName: 'click',\n\t\t\t\tonShow: function () {},\n\t\t\t\tonBeforeShow: function(){},\n\t\t\t\tonHide: function () {},\n\t\t\t\tonChange: function () {},\n\t\t\t\tonSubmit: function () {},\n\t\t\t\tcolor: 'ff0000',\n\t\t\t\tlivePreview: true,\n\t\t\t\tflat: false\n\t\t\t},\n\t\t\tfillRGBFields = function  (hsb, cal) {\n\t\t\t\tvar rgb = HSBToRGB(hsb);\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(1).val(rgb.r).end()\n\t\t\t\t\t.eq(2).val(rgb.g).end()\n\t\t\t\t\t.eq(3).val(rgb.b).end();\n\t\t\t},\n\t\t\tfillHSBFields = function  (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(4).val(hsb.h).end()\n\t\t\t\t\t.eq(5).val(hsb.s).end()\n\t\t\t\t\t.eq(6).val(hsb.b).end();\n\t\t\t},\n\t\t\tfillHexFields = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').fields\n\t\t\t\t\t.eq(0).val(HSBToHex(hsb)).end();\n\t\t\t},\n\t\t\tsetSelector = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').selector.css('backgroundColor', '#' + HSBToHex({h: hsb.h, s: 100, b: 100}));\n\t\t\t\t$(cal).data('colorpicker').selectorIndic.css({\n\t\t\t\t\tleft: parseInt(150 * hsb.s/100, 10),\n\t\t\t\t\ttop: parseInt(150 * (100-hsb.b)/100, 10)\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetHue = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').hue.css('top', parseInt(150 - 150 * hsb.h/360, 10));\n\t\t\t},\n\t\t\tsetCurrentColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').currentColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tsetNewColor = function (hsb, cal) {\n\t\t\t\t$(cal).data('colorpicker').newColor.css('backgroundColor', '#' + HSBToHex(hsb));\n\t\t\t},\n\t\t\tkeyDown = function (ev) {\n\t\t\t\tvar pressedKey = ev.charCode || ev.keyCode || -1;\n\t\t\t\tif ((pressedKey > charMin && pressedKey <= 90) || pressedKey == 32) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tif (cal.data('colorpicker').livePreview === true) {\n\t\t\t\t\tchange.apply(this);\n\t\t\t\t}\n\t\t\t},\n\t\t\tchange = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent(), col;\n\t\t\t\tif (this.parentNode.className.indexOf('_hex') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = HexToHSB(fixHex(this.value));\n\t\t\t\t} else if (this.parentNode.className.indexOf('_hsb') > 0) {\n\t\t\t\t\tcal.data('colorpicker').color = col = fixHSB({\n\t\t\t\t\t\th: parseInt(cal.data('colorpicker').fields.eq(4).val(), 10),\n\t\t\t\t\t\ts: parseInt(cal.data('colorpicker').fields.eq(5).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(6).val(), 10)\n\t\t\t\t\t});\n\t\t\t\t} else {\n\t\t\t\t\tcal.data('colorpicker').color = col = RGBToHSB(fixRGB({\n\t\t\t\t\t\tr: parseInt(cal.data('colorpicker').fields.eq(1).val(), 10),\n\t\t\t\t\t\tg: parseInt(cal.data('colorpicker').fields.eq(2).val(), 10),\n\t\t\t\t\t\tb: parseInt(cal.data('colorpicker').fields.eq(3).val(), 10)\n\t\t\t\t\t}));\n\t\t\t\t}\n\t\t\t\tif (ev) {\n\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t}\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onChange.apply(cal, [col, HSBToHex(col), HSBToRGB(col)]);\n\t\t\t},\n\t\t\tblur = function (ev) {\n\t\t\t\tvar cal = $(this).parent().parent();\n\t\t\t\tcal.data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tfocus = function () {\n\t\t\t\tcharMin = this.parentNode.className.indexOf('_hex') > 0 ? 70 : 65;\n\t\t\t\t$(this).parent().parent().data('colorpicker').fields.parent().removeClass('colorpicker_focus');\n\t\t\t\t$(this).parent().addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tdownIncrement = function (ev) {\n\t\t\t\tvar field = $(this).parent().find('input').focus();\n\t\t\t\tvar current = {\n\t\t\t\t\tel: $(this).parent().addClass('colorpicker_slider'),\n\t\t\t\t\tmax: this.parentNode.className.indexOf('_hsb_h') > 0 ? 360 : (this.parentNode.className.indexOf('_hsb') > 0 ? 100 : 255),\n\t\t\t\t\ty: ev.pageY,\n\t\t\t\t\tfield: field,\n\t\t\t\t\tval: parseInt(field.val(), 10),\n\t\t\t\t\tpreview: $(this).parent().parent().data('colorpicker').livePreview\t\t\t\t\t\n\t\t\t\t};\n\t\t\t\t$(document).bind('mouseup', current, upIncrement);\n\t\t\t\t$(document).bind('mousemove', current, moveIncrement);\n\t\t\t},\n\t\t\tmoveIncrement = function (ev) {\n\t\t\t\tev.data.field.val(Math.max(0, Math.min(ev.data.max, parseInt(ev.data.val + ev.pageY - ev.data.y, 10))));\n\t\t\t\tif (ev.data.preview) {\n\t\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupIncrement = function (ev) {\n\t\t\t\tchange.apply(ev.data.field.get(0), [true]);\n\t\t\t\tev.data.el.removeClass('colorpicker_slider').find('input').focus();\n\t\t\t\t$(document).unbind('mouseup', upIncrement);\n\t\t\t\t$(document).unbind('mousemove', moveIncrement);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownHue = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\ty: $(this).offset().top\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upHue);\n\t\t\t\t$(document).bind('mousemove', current, moveHue);\n\t\t\t},\n\t\t\tmoveHue = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(4)\n\t\t\t\t\t\t.val(parseInt(360*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.y))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupHue = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upHue);\n\t\t\t\t$(document).unbind('mousemove', moveHue);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tdownSelector = function (ev) {\n\t\t\t\tvar current = {\n\t\t\t\t\tcal: $(this).parent(),\n\t\t\t\t\tpos: $(this).offset()\n\t\t\t\t};\n\t\t\t\tcurrent.preview = current.cal.data('colorpicker').livePreview;\n\t\t\t\t$(document).bind('mouseup', current, upSelector);\n\t\t\t\t$(document).bind('mousemove', current, moveSelector);\n\t\t\t},\n\t\t\tmoveSelector = function (ev) {\n\t\t\t\tchange.apply(\n\t\t\t\t\tev.data.cal.data('colorpicker')\n\t\t\t\t\t\t.fields\n\t\t\t\t\t\t.eq(6)\n\t\t\t\t\t\t.val(parseInt(100*(150 - Math.max(0,Math.min(150,(ev.pageY - ev.data.pos.top))))/150, 10))\n\t\t\t\t\t\t.end()\n\t\t\t\t\t\t.eq(5)\n\t\t\t\t\t\t.val(parseInt(100*(Math.max(0,Math.min(150,(ev.pageX - ev.data.pos.left))))/150, 10))\n\t\t\t\t\t\t.get(0),\n\t\t\t\t\t[ev.data.preview]\n\t\t\t\t);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tupSelector = function (ev) {\n\t\t\t\tfillRGBFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\tfillHexFields(ev.data.cal.data('colorpicker').color, ev.data.cal.get(0));\n\t\t\t\t$(document).unbind('mouseup', upSelector);\n\t\t\t\t$(document).unbind('mousemove', moveSelector);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tenterSubmit = function (ev) {\n\t\t\t\t$(this).addClass('colorpicker_focus');\n\t\t\t},\n\t\t\tleaveSubmit = function (ev) {\n\t\t\t\t$(this).removeClass('colorpicker_focus');\n\t\t\t},\n\t\t\tclickSubmit = function (ev) {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').color;\n\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\tcal.data('colorpicker').onSubmit(col, HSBToHex(col), HSBToRGB(col), cal.data('colorpicker').el);\n\t\t\t},\n\t\t\tshow = function (ev) {\n\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\tcal.data('colorpicker').onBeforeShow.apply(this, [cal.get(0)]);\n\t\t\t\tvar pos = $(this).offset();\n\t\t\t\tvar viewPort = getViewport();\n\t\t\t\tvar top = pos.top + this.offsetHeight;\n\t\t\t\tvar left = pos.left;\n\t\t\t\tif (top + 176 > viewPort.t + viewPort.h) {\n\t\t\t\t\ttop -= this.offsetHeight + 176;\n\t\t\t\t}\n\t\t\t\tif (left + 356 > viewPort.l + viewPort.w) {\n\t\t\t\t\tleft -= 356;\n\t\t\t\t}\n\t\t\t\tcal.css({left: left + 'px', top: top + 'px'});\n\t\t\t\tif (cal.data('colorpicker').onShow.apply(this, [cal.get(0)]) != false) {\n\t\t\t\t\tcal.show();\n\t\t\t\t}\n\t\t\t\t$(document).bind('mousedown', {cal: cal}, hide);\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\thide = function (ev) {\n\t\t\t\tif (!isChildOf(ev.data.cal.get(0), ev.target, ev.data.cal.get(0))) {\n\t\t\t\t\tif (ev.data.cal.data('colorpicker').onHide.apply(this, [ev.data.cal.get(0)]) != false) {\n\t\t\t\t\t\tev.data.cal.hide();\n\t\t\t\t\t}\n\t\t\t\t\t$(document).unbind('mousedown', hide);\n\t\t\t\t}\n\t\t\t},\n\t\t\tisChildOf = function(parentEl, el, container) {\n\t\t\t\tif (parentEl == el) {\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t\tif (parentEl.contains) {\n\t\t\t\t\treturn parentEl.contains(el);\n\t\t\t\t}\n\t\t\t\tif ( parentEl.compareDocumentPosition ) {\n\t\t\t\t\treturn !!(parentEl.compareDocumentPosition(el) & 16);\n\t\t\t\t}\n\t\t\t\tvar prEl = el.parentNode;\n\t\t\t\twhile(prEl && prEl != container) {\n\t\t\t\t\tif (prEl == parentEl)\n\t\t\t\t\t\treturn true;\n\t\t\t\t\tprEl = prEl.parentNode;\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t},\n\t\t\tgetViewport = function () {\n\t\t\t\tvar m = document.compatMode == 'CSS1Compat';\n\t\t\t\treturn {\n\t\t\t\t\tl : window.pageXOffset || (m ? document.documentElement.scrollLeft : document.body.scrollLeft),\n\t\t\t\t\tt : window.pageYOffset || (m ? document.documentElement.scrollTop : document.body.scrollTop),\n\t\t\t\t\tw : window.innerWidth || (m ? document.documentElement.clientWidth : document.body.clientWidth),\n\t\t\t\t\th : window.innerHeight || (m ? document.documentElement.clientHeight : document.body.clientHeight)\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHSB = function (hsb) {\n\t\t\t\treturn {\n\t\t\t\t\th: Math.min(360, Math.max(0, hsb.h)),\n\t\t\t\t\ts: Math.min(100, Math.max(0, hsb.s)),\n\t\t\t\t\tb: Math.min(100, Math.max(0, hsb.b))\n\t\t\t\t};\n\t\t\t}, \n\t\t\tfixRGB = function (rgb) {\n\t\t\t\treturn {\n\t\t\t\t\tr: Math.min(255, Math.max(0, rgb.r)),\n\t\t\t\t\tg: Math.min(255, Math.max(0, rgb.g)),\n\t\t\t\t\tb: Math.min(255, Math.max(0, rgb.b))\n\t\t\t\t};\n\t\t\t},\n\t\t\tfixHex = function (hex) {\n\t\t\t\tvar len = 6 - hex.length;\n\t\t\t\tif (len > 0) {\n\t\t\t\t\tvar o = [];\n\t\t\t\t\tfor (var i=0; i<len; i++) {\n\t\t\t\t\t\to.push('0');\n\t\t\t\t\t}\n\t\t\t\t\to.push(hex);\n\t\t\t\t\thex = o.join('');\n\t\t\t\t}\n\t\t\t\treturn hex;\n\t\t\t}, \n\t\t\tHexToRGB = function (hex) {\n\t\t\t\tvar hex = parseInt(((hex.indexOf('#') > -1) ? hex.substring(1) : hex), 16);\n\t\t\t\treturn {r: hex >> 16, g: (hex & 0x00FF00) >> 8, b: (hex & 0x0000FF)};\n\t\t\t},\n\t\t\tHexToHSB = function (hex) {\n\t\t\t\treturn RGBToHSB(HexToRGB(hex));\n\t\t\t},\n\t\t\tRGBToHSB = function (rgb) {\n\t\t\t\tvar hsb = {\n\t\t\t\t\th: 0,\n\t\t\t\t\ts: 0,\n\t\t\t\t\tb: 0\n\t\t\t\t};\n\t\t\t\tvar min = Math.min(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar max = Math.max(rgb.r, rgb.g, rgb.b);\n\t\t\t\tvar delta = max - min;\n\t\t\t\thsb.b = max;\n\t\t\t\tif (max != 0) {\n\t\t\t\t\t\n\t\t\t\t}\n\t\t\t\thsb.s = max != 0 ? 255 * delta / max : 0;\n\t\t\t\tif (hsb.s != 0) {\n\t\t\t\t\tif (rgb.r == max) {\n\t\t\t\t\t\thsb.h = (rgb.g - rgb.b) / delta;\n\t\t\t\t\t} else if (rgb.g == max) {\n\t\t\t\t\t\thsb.h = 2 + (rgb.b - rgb.r) / delta;\n\t\t\t\t\t} else {\n\t\t\t\t\t\thsb.h = 4 + (rgb.r - rgb.g) / delta;\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\thsb.h = -1;\n\t\t\t\t}\n\t\t\t\thsb.h *= 60;\n\t\t\t\tif (hsb.h < 0) {\n\t\t\t\t\thsb.h += 360;\n\t\t\t\t}\n\t\t\t\thsb.s *= 100/255;\n\t\t\t\thsb.b *= 100/255;\n\t\t\t\treturn hsb;\n\t\t\t},\n\t\t\tHSBToRGB = function (hsb) {\n\t\t\t\tvar rgb = {};\n\t\t\t\tvar h = Math.round(hsb.h);\n\t\t\t\tvar s = Math.round(hsb.s*255/100);\n\t\t\t\tvar v = Math.round(hsb.b*255/100);\n\t\t\t\tif(s == 0) {\n\t\t\t\t\trgb.r = rgb.g = rgb.b = v;\n\t\t\t\t} else {\n\t\t\t\t\tvar t1 = v;\n\t\t\t\t\tvar t2 = (255-s)*v/255;\n\t\t\t\t\tvar t3 = (t1-t2)*(h%60)/60;\n\t\t\t\t\tif(h==360) h = 0;\n\t\t\t\t\tif(h<60) {rgb.r=t1;\trgb.b=t2; rgb.g=t2+t3}\n\t\t\t\t\telse if(h<120) {rgb.g=t1; rgb.b=t2;\trgb.r=t1-t3}\n\t\t\t\t\telse if(h<180) {rgb.g=t1; rgb.r=t2;\trgb.b=t2+t3}\n\t\t\t\t\telse if(h<240) {rgb.b=t1; rgb.r=t2;\trgb.g=t1-t3}\n\t\t\t\t\telse if(h<300) {rgb.b=t1; rgb.g=t2;\trgb.r=t2+t3}\n\t\t\t\t\telse if(h<360) {rgb.r=t1; rgb.g=t2;\trgb.b=t1-t3}\n\t\t\t\t\telse {rgb.r=0; rgb.g=0;\trgb.b=0}\n\t\t\t\t}\n\t\t\t\treturn {r:Math.round(rgb.r), g:Math.round(rgb.g), b:Math.round(rgb.b)};\n\t\t\t},\n\t\t\tRGBToHex = function (rgb) {\n\t\t\t\tvar hex = [\n\t\t\t\t\trgb.r.toString(16),\n\t\t\t\t\trgb.g.toString(16),\n\t\t\t\t\trgb.b.toString(16)\n\t\t\t\t];\n\t\t\t\t$.each(hex, function (nr, val) {\n\t\t\t\t\tif (val.length == 1) {\n\t\t\t\t\t\thex[nr] = '0' + val;\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t\treturn hex.join('');\n\t\t\t},\n\t\t\tHSBToHex = function (hsb) {\n\t\t\t\treturn RGBToHex(HSBToRGB(hsb));\n\t\t\t},\n\t\t\trestoreOriginal = function () {\n\t\t\t\tvar cal = $(this).parent();\n\t\t\t\tvar col = cal.data('colorpicker').origColor;\n\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t};\n\t\treturn {\n\t\t\tinit: function (opt) {\n\t\t\t\topt = $.extend({}, defaults, opt||{});\n\t\t\t\tif (typeof opt.color == 'string') {\n\t\t\t\t\topt.color = HexToHSB(opt.color);\n\t\t\t\t} else if (opt.color.r != undefined && opt.color.g != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = RGBToHSB(opt.color);\n\t\t\t\t} else if (opt.color.h != undefined && opt.color.s != undefined && opt.color.b != undefined) {\n\t\t\t\t\topt.color = fixHSB(opt.color);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function () {\n\t\t\t\t\tif (!$(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar options = $.extend({}, opt);\n\t\t\t\t\t\toptions.origColor = opt.color;\n\t\t\t\t\t\tvar id = 'collorpicker_' + parseInt(Math.random() * 1000);\n\t\t\t\t\t\t$(this).data('colorpickerId', id);\n\t\t\t\t\t\tvar cal = $(tpl).attr('id', id);\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.appendTo(this).show();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tcal.appendTo(document.body);\n\t\t\t\t\t\t}\n\t\t\t\t\t\toptions.fields = cal\n\t\t\t\t\t\t\t\t\t\t\t.find('input')\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('keyup', keyDown)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('change', change)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('blur', blur)\n\t\t\t\t\t\t\t\t\t\t\t\t.bind('focus', focus);\n\t\t\t\t\t\tcal\n\t\t\t\t\t\t\t.find('span').bind('mousedown', downIncrement).end()\n\t\t\t\t\t\t\t.find('>div.colorpicker_current_color').bind('click', restoreOriginal);\n\t\t\t\t\t\toptions.selector = cal.find('div.colorpicker_color').bind('mousedown', downSelector);\n\t\t\t\t\t\toptions.selectorIndic = options.selector.find('div div');\n\t\t\t\t\t\toptions.el = this;\n\t\t\t\t\t\toptions.hue = cal.find('div.colorpicker_hue div');\n\t\t\t\t\t\tcal.find('div.colorpicker_hue').bind('mousedown', downHue);\n\t\t\t\t\t\toptions.newColor = cal.find('div.colorpicker_new_color');\n\t\t\t\t\t\toptions.currentColor = cal.find('div.colorpicker_current_color');\n\t\t\t\t\t\tcal.data('colorpicker', options);\n\t\t\t\t\t\tcal.find('div.colorpicker_submit')\n\t\t\t\t\t\t\t.bind('mouseenter', enterSubmit)\n\t\t\t\t\t\t\t.bind('mouseleave', leaveSubmit)\n\t\t\t\t\t\t\t.bind('click', clickSubmit);\n\t\t\t\t\t\tfillRGBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(options.color, cal.get(0));\n\t\t\t\t\t\tfillHexFields(options.color, cal.get(0));\n\t\t\t\t\t\tsetHue(options.color, cal.get(0));\n\t\t\t\t\t\tsetSelector(options.color, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(options.color, cal.get(0));\n\t\t\t\t\t\tsetNewColor(options.color, cal.get(0));\n\t\t\t\t\t\tif (options.flat) {\n\t\t\t\t\t\t\tcal.css({\n\t\t\t\t\t\t\t\tposition: 'relative',\n\t\t\t\t\t\t\t\tdisplay: 'block'\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t$(this).bind(options.eventName, show);\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tshowPicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tshow.apply(this);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\thidePicker: function() {\n\t\t\t\treturn this.each( function () {\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\t$('#' + $(this).data('colorpickerId')).hide();\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t},\n\t\t\tsetColor: function(col) {\n\t\t\t\tif (typeof col == 'string') {\n\t\t\t\t\tcol = HexToHSB(col);\n\t\t\t\t} else if (col.r != undefined && col.g != undefined && col.b != undefined) {\n\t\t\t\t\tcol = RGBToHSB(col);\n\t\t\t\t} else if (col.h != undefined && col.s != undefined && col.b != undefined) {\n\t\t\t\t\tcol = fixHSB(col);\n\t\t\t\t} else {\n\t\t\t\t\treturn this;\n\t\t\t\t}\n\t\t\t\treturn this.each(function(){\n\t\t\t\t\tif ($(this).data('colorpickerId')) {\n\t\t\t\t\t\tvar cal = $('#' + $(this).data('colorpickerId'));\n\t\t\t\t\t\tcal.data('colorpicker').color = col;\n\t\t\t\t\t\tcal.data('colorpicker').origColor = col;\n\t\t\t\t\t\tfillRGBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHSBFields(col, cal.get(0));\n\t\t\t\t\t\tfillHexFields(col, cal.get(0));\n\t\t\t\t\t\tsetHue(col, cal.get(0));\n\t\t\t\t\t\tsetSelector(col, cal.get(0));\n\t\t\t\t\t\tsetCurrentColor(col, cal.get(0));\n\t\t\t\t\t\tsetNewColor(col, cal.get(0));\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\t}();\n\t$.fn.extend({\n\t\tColorPicker: ColorPicker.init,\n\t\tColorPickerHide: ColorPicker.hidePicker,\n\t\tColorPickerShow: ColorPicker.showPicker,\n\t\tColorPickerSetColor: ColorPicker.setColor\n\t});\n});","jquery/spectrum/tinycolor.js":"// This file is autogenerated. v1.6.0\n// It's here at this path for backwards compatibility for links to it\n// but the npm package now exports both CJS and ESM.\n// See https://github.com/bgrins/TinyColor/ for instructions.\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.tinycolor = factory());\n})(this, (function () { 'use strict';\n\n    function _typeof(obj) {\n        \"@babel/helpers - typeof\";\n\n        return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) {\n            return typeof obj;\n        } : function (obj) {\n            return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj;\n        }, _typeof(obj);\n    }\n\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    var trimLeft = /^\\s+/;\n    var trimRight = /\\s+$/;\n    function tinycolor(color, opts) {\n        color = color ? color : \"\";\n        opts = opts || {};\n\n        // If input is already a tinycolor, return itself\n        if (color instanceof tinycolor) {\n            return color;\n        }\n        // If we are called as a function, call using new instead\n        if (!(this instanceof tinycolor)) {\n            return new tinycolor(color, opts);\n        }\n        var rgb = inputToRGB(color);\n        this._originalInput = color, this._r = rgb.r, this._g = rgb.g, this._b = rgb.b, this._a = rgb.a, this._roundA = Math.round(100 * this._a) / 100, this._format = opts.format || rgb.format;\n        this._gradientType = opts.gradientType;\n\n        // Don't let the range of [0,255] come back in [0,1].\n        // Potentially lose a little bit of precision here, but will fix issues where\n        // .5 gets interpreted as half of the total, instead of half of 1\n        // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n        if (this._r < 1) this._r = Math.round(this._r);\n        if (this._g < 1) this._g = Math.round(this._g);\n        if (this._b < 1) this._b = Math.round(this._b);\n        this._ok = rgb.ok;\n    }\n    tinycolor.prototype = {\n        isDark: function isDark() {\n            return this.getBrightness() < 128;\n        },\n        isLight: function isLight() {\n            return !this.isDark();\n        },\n        isValid: function isValid() {\n            return this._ok;\n        },\n        getOriginalInput: function getOriginalInput() {\n            return this._originalInput;\n        },\n        getFormat: function getFormat() {\n            return this._format;\n        },\n        getAlpha: function getAlpha() {\n            return this._a;\n        },\n        getBrightness: function getBrightness() {\n            //http://www.w3.org/TR/AERT#color-contrast\n            var rgb = this.toRgb();\n            return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n        },\n        getLuminance: function getLuminance() {\n            //http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef\n            var rgb = this.toRgb();\n            var RsRGB, GsRGB, BsRGB, R, G, B;\n            RsRGB = rgb.r / 255;\n            GsRGB = rgb.g / 255;\n            BsRGB = rgb.b / 255;\n            if (RsRGB <= 0.03928) R = RsRGB / 12.92;else R = Math.pow((RsRGB + 0.055) / 1.055, 2.4);\n            if (GsRGB <= 0.03928) G = GsRGB / 12.92;else G = Math.pow((GsRGB + 0.055) / 1.055, 2.4);\n            if (BsRGB <= 0.03928) B = BsRGB / 12.92;else B = Math.pow((BsRGB + 0.055) / 1.055, 2.4);\n            return 0.2126 * R + 0.7152 * G + 0.0722 * B;\n        },\n        setAlpha: function setAlpha(value) {\n            this._a = boundAlpha(value);\n            this._roundA = Math.round(100 * this._a) / 100;\n            return this;\n        },\n        toHsv: function toHsv() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            return {\n                h: hsv.h * 360,\n                s: hsv.s,\n                v: hsv.v,\n                a: this._a\n            };\n        },\n        toHsvString: function toHsvString() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            var h = Math.round(hsv.h * 360),\n                s = Math.round(hsv.s * 100),\n                v = Math.round(hsv.v * 100);\n            return this._a == 1 ? \"hsv(\" + h + \", \" + s + \"%, \" + v + \"%)\" : \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \" + this._roundA + \")\";\n        },\n        toHsl: function toHsl() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            return {\n                h: hsl.h * 360,\n                s: hsl.s,\n                l: hsl.l,\n                a: this._a\n            };\n        },\n        toHslString: function toHslString() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            var h = Math.round(hsl.h * 360),\n                s = Math.round(hsl.s * 100),\n                l = Math.round(hsl.l * 100);\n            return this._a == 1 ? \"hsl(\" + h + \", \" + s + \"%, \" + l + \"%)\" : \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \" + this._roundA + \")\";\n        },\n        toHex: function toHex(allow3Char) {\n            return rgbToHex(this._r, this._g, this._b, allow3Char);\n        },\n        toHexString: function toHexString(allow3Char) {\n            return \"#\" + this.toHex(allow3Char);\n        },\n        toHex8: function toHex8(allow4Char) {\n            return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);\n        },\n        toHex8String: function toHex8String(allow4Char) {\n            return \"#\" + this.toHex8(allow4Char);\n        },\n        toRgb: function toRgb() {\n            return {\n                r: Math.round(this._r),\n                g: Math.round(this._g),\n                b: Math.round(this._b),\n                a: this._a\n            };\n        },\n        toRgbString: function toRgbString() {\n            return this._a == 1 ? \"rgb(\" + Math.round(this._r) + \", \" + Math.round(this._g) + \", \" + Math.round(this._b) + \")\" : \"rgba(\" + Math.round(this._r) + \", \" + Math.round(this._g) + \", \" + Math.round(this._b) + \", \" + this._roundA + \")\";\n        },\n        toPercentageRgb: function toPercentageRgb() {\n            return {\n                r: Math.round(bound01(this._r, 255) * 100) + \"%\",\n                g: Math.round(bound01(this._g, 255) * 100) + \"%\",\n                b: Math.round(bound01(this._b, 255) * 100) + \"%\",\n                a: this._a\n            };\n        },\n        toPercentageRgbString: function toPercentageRgbString() {\n            return this._a == 1 ? \"rgb(\" + Math.round(bound01(this._r, 255) * 100) + \"%, \" + Math.round(bound01(this._g, 255) * 100) + \"%, \" + Math.round(bound01(this._b, 255) * 100) + \"%)\" : \"rgba(\" + Math.round(bound01(this._r, 255) * 100) + \"%, \" + Math.round(bound01(this._g, 255) * 100) + \"%, \" + Math.round(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n        },\n        toName: function toName() {\n            if (this._a === 0) {\n                return \"transparent\";\n            }\n            if (this._a < 1) {\n                return false;\n            }\n            return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n        },\n        toFilter: function toFilter(secondColor) {\n            var hex8String = \"#\" + rgbaToArgbHex(this._r, this._g, this._b, this._a);\n            var secondHex8String = hex8String;\n            var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n            if (secondColor) {\n                var s = tinycolor(secondColor);\n                secondHex8String = \"#\" + rgbaToArgbHex(s._r, s._g, s._b, s._a);\n            }\n            return \"progid:DXImageTransform.Microsoft.gradient(\" + gradientType + \"startColorstr=\" + hex8String + \",endColorstr=\" + secondHex8String + \")\";\n        },\n        toString: function toString(format) {\n            var formatSet = !!format;\n            format = format || this._format;\n            var formattedString = false;\n            var hasAlpha = this._a < 1 && this._a >= 0;\n            var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"hex4\" || format === \"hex8\" || format === \"name\");\n            if (needsAlphaFormat) {\n                // Special case for \"transparent\", all other non-alpha formats\n                // will return rgba when there is transparency.\n                if (format === \"name\" && this._a === 0) {\n                    return this.toName();\n                }\n                return this.toRgbString();\n            }\n            if (format === \"rgb\") {\n                formattedString = this.toRgbString();\n            }\n            if (format === \"prgb\") {\n                formattedString = this.toPercentageRgbString();\n            }\n            if (format === \"hex\" || format === \"hex6\") {\n                formattedString = this.toHexString();\n            }\n            if (format === \"hex3\") {\n                formattedString = this.toHexString(true);\n            }\n            if (format === \"hex4\") {\n                formattedString = this.toHex8String(true);\n            }\n            if (format === \"hex8\") {\n                formattedString = this.toHex8String();\n            }\n            if (format === \"name\") {\n                formattedString = this.toName();\n            }\n            if (format === \"hsl\") {\n                formattedString = this.toHslString();\n            }\n            if (format === \"hsv\") {\n                formattedString = this.toHsvString();\n            }\n            return formattedString || this.toHexString();\n        },\n        clone: function clone() {\n            return tinycolor(this.toString());\n        },\n        _applyModification: function _applyModification(fn, args) {\n            var color = fn.apply(null, [this].concat([].slice.call(args)));\n            this._r = color._r;\n            this._g = color._g;\n            this._b = color._b;\n            this.setAlpha(color._a);\n            return this;\n        },\n        lighten: function lighten() {\n            return this._applyModification(_lighten, arguments);\n        },\n        brighten: function brighten() {\n            return this._applyModification(_brighten, arguments);\n        },\n        darken: function darken() {\n            return this._applyModification(_darken, arguments);\n        },\n        desaturate: function desaturate() {\n            return this._applyModification(_desaturate, arguments);\n        },\n        saturate: function saturate() {\n            return this._applyModification(_saturate, arguments);\n        },\n        greyscale: function greyscale() {\n            return this._applyModification(_greyscale, arguments);\n        },\n        spin: function spin() {\n            return this._applyModification(_spin, arguments);\n        },\n        _applyCombination: function _applyCombination(fn, args) {\n            return fn.apply(null, [this].concat([].slice.call(args)));\n        },\n        analogous: function analogous() {\n            return this._applyCombination(_analogous, arguments);\n        },\n        complement: function complement() {\n            return this._applyCombination(_complement, arguments);\n        },\n        monochromatic: function monochromatic() {\n            return this._applyCombination(_monochromatic, arguments);\n        },\n        splitcomplement: function splitcomplement() {\n            return this._applyCombination(_splitcomplement, arguments);\n        },\n        // Disabled until https://github.com/bgrins/TinyColor/issues/254\n        // polyad: function (number) {\n        //   return this._applyCombination(polyad, [number]);\n        // },\n        triad: function triad() {\n            return this._applyCombination(polyad, [3]);\n        },\n        tetrad: function tetrad() {\n            return this._applyCombination(polyad, [4]);\n        }\n    };\n\n    // If input is an object, force 1 into \"1.0\" to handle ratios properly\n    // String input requires \"1.0\" as input, so 1 will be treated as 1\n    tinycolor.fromRatio = function (color, opts) {\n        if (_typeof(color) == \"object\") {\n            var newColor = {};\n            for (var i in color) {\n                if (color.hasOwnProperty(i)) {\n                    if (i === \"a\") {\n                        newColor[i] = color[i];\n                    } else {\n                        newColor[i] = convertToPercentage(color[i]);\n                    }\n                }\n            }\n            color = newColor;\n        }\n        return tinycolor(color, opts);\n    };\n\n    // Given a string or object, convert that input to RGB\n    // Possible string inputs:\n    //\n    //     \"red\"\n    //     \"#f00\" or \"f00\"\n    //     \"#ff0000\" or \"ff0000\"\n    //     \"#ff000000\" or \"ff000000\"\n    //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n    //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n    //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n    //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n    //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n    //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n    //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n    //\n    function inputToRGB(color) {\n        var rgb = {\n            r: 0,\n            g: 0,\n            b: 0\n        };\n        var a = 1;\n        var s = null;\n        var v = null;\n        var l = null;\n        var ok = false;\n        var format = false;\n        if (typeof color == \"string\") {\n            color = stringInputToObject(color);\n        }\n        if (_typeof(color) == \"object\") {\n            if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {\n                rgb = rgbToRgb(color.r, color.g, color.b);\n                ok = true;\n                format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n            } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {\n                s = convertToPercentage(color.s);\n                v = convertToPercentage(color.v);\n                rgb = hsvToRgb(color.h, s, v);\n                ok = true;\n                format = \"hsv\";\n            } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {\n                s = convertToPercentage(color.s);\n                l = convertToPercentage(color.l);\n                rgb = hslToRgb(color.h, s, l);\n                ok = true;\n                format = \"hsl\";\n            }\n            if (color.hasOwnProperty(\"a\")) {\n                a = color.a;\n            }\n        }\n        a = boundAlpha(a);\n        return {\n            ok: ok,\n            format: color.format || format,\n            r: Math.min(255, Math.max(rgb.r, 0)),\n            g: Math.min(255, Math.max(rgb.g, 0)),\n            b: Math.min(255, Math.max(rgb.b, 0)),\n            a: a\n        };\n    }\n\n    // Conversion Functions\n    // --------------------\n\n    // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n    // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n    // `rgbToRgb`\n    // Handle bounds / percentage checking to conform to CSS color spec\n    // <http://www.w3.org/TR/css3-color/>\n    // *Assumes:* r, g, b in [0, 255] or [0, 1]\n    // *Returns:* { r, g, b } in [0, 255]\n    function rgbToRgb(r, g, b) {\n        return {\n            r: bound01(r, 255) * 255,\n            g: bound01(g, 255) * 255,\n            b: bound01(b, 255) * 255\n        };\n    }\n\n    // `rgbToHsl`\n    // Converts an RGB color value to HSL.\n    // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n    // *Returns:* { h, s, l } in [0,1]\n    function rgbToHsl(r, g, b) {\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n        var max = Math.max(r, g, b),\n            min = Math.min(r, g, b);\n        var h,\n            s,\n            l = (max + min) / 2;\n        if (max == min) {\n            h = s = 0; // achromatic\n        } else {\n            var d = max - min;\n            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n            switch (max) {\n                case r:\n                    h = (g - b) / d + (g < b ? 6 : 0);\n                    break;\n                case g:\n                    h = (b - r) / d + 2;\n                    break;\n                case b:\n                    h = (r - g) / d + 4;\n                    break;\n            }\n            h /= 6;\n        }\n        return {\n            h: h,\n            s: s,\n            l: l\n        };\n    }\n\n    // `hslToRgb`\n    // Converts an HSL color value to RGB.\n    // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n    // *Returns:* { r, g, b } in the set [0, 255]\n    function hslToRgb(h, s, l) {\n        var r, g, b;\n        h = bound01(h, 360);\n        s = bound01(s, 100);\n        l = bound01(l, 100);\n        function hue2rgb(p, q, t) {\n            if (t < 0) t += 1;\n            if (t > 1) t -= 1;\n            if (t < 1 / 6) return p + (q - p) * 6 * t;\n            if (t < 1 / 2) return q;\n            if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;\n            return p;\n        }\n        if (s === 0) {\n            r = g = b = l; // achromatic\n        } else {\n            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n            var p = 2 * l - q;\n            r = hue2rgb(p, q, h + 1 / 3);\n            g = hue2rgb(p, q, h);\n            b = hue2rgb(p, q, h - 1 / 3);\n        }\n        return {\n            r: r * 255,\n            g: g * 255,\n            b: b * 255\n        };\n    }\n\n    // `rgbToHsv`\n    // Converts an RGB color value to HSV\n    // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n    // *Returns:* { h, s, v } in [0,1]\n    function rgbToHsv(r, g, b) {\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n        var max = Math.max(r, g, b),\n            min = Math.min(r, g, b);\n        var h,\n            s,\n            v = max;\n        var d = max - min;\n        s = max === 0 ? 0 : d / max;\n        if (max == min) {\n            h = 0; // achromatic\n        } else {\n            switch (max) {\n                case r:\n                    h = (g - b) / d + (g < b ? 6 : 0);\n                    break;\n                case g:\n                    h = (b - r) / d + 2;\n                    break;\n                case b:\n                    h = (r - g) / d + 4;\n                    break;\n            }\n            h /= 6;\n        }\n        return {\n            h: h,\n            s: s,\n            v: v\n        };\n    }\n\n    // `hsvToRgb`\n    // Converts an HSV color value to RGB.\n    // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n    // *Returns:* { r, g, b } in the set [0, 255]\n    function hsvToRgb(h, s, v) {\n        h = bound01(h, 360) * 6;\n        s = bound01(s, 100);\n        v = bound01(v, 100);\n        var i = Math.floor(h),\n            f = h - i,\n            p = v * (1 - s),\n            q = v * (1 - f * s),\n            t = v * (1 - (1 - f) * s),\n            mod = i % 6,\n            r = [v, q, p, p, t, v][mod],\n            g = [t, v, v, q, p, p][mod],\n            b = [p, p, t, v, v, q][mod];\n        return {\n            r: r * 255,\n            g: g * 255,\n            b: b * 255\n        };\n    }\n\n    // `rgbToHex`\n    // Converts an RGB color to hex\n    // Assumes r, g, and b are contained in the set [0, 255]\n    // Returns a 3 or 6 character hex\n    function rgbToHex(r, g, b, allow3Char) {\n        var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];\n\n        // Return a 3 character hex if possible\n        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n        }\n        return hex.join(\"\");\n    }\n\n    // `rgbaToHex`\n    // Converts an RGBA color plus alpha transparency to hex\n    // Assumes r, g, b are contained in the set [0, 255] and\n    // a in [0, 1]. Returns a 4 or 8 character rgba hex\n    function rgbaToHex(r, g, b, a, allow4Char) {\n        var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16)), pad2(convertDecimalToHex(a))];\n\n        // Return a 4 character hex if possible\n        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);\n        }\n        return hex.join(\"\");\n    }\n\n    // `rgbaToArgbHex`\n    // Converts an RGBA color to an ARGB Hex8 string\n    // Rarely used, but required for \"toFilter()\"\n    function rgbaToArgbHex(r, g, b, a) {\n        var hex = [pad2(convertDecimalToHex(a)), pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];\n        return hex.join(\"\");\n    }\n\n    // `equals`\n    // Can be called with any tinycolor input\n    tinycolor.equals = function (color1, color2) {\n        if (!color1 || !color2) return false;\n        return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n    };\n    tinycolor.random = function () {\n        return tinycolor.fromRatio({\n            r: Math.random(),\n            g: Math.random(),\n            b: Math.random()\n        });\n    };\n\n    // Modification Functions\n    // ----------------------\n    // Thanks to less.js for some of the basics here\n    // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n    function _desaturate(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.s -= amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n    function _saturate(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.s += amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n    function _greyscale(color) {\n        return tinycolor(color).desaturate(100);\n    }\n    function _lighten(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.l += amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n    function _brighten(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var rgb = tinycolor(color).toRgb();\n        rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));\n        rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));\n        rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));\n        return tinycolor(rgb);\n    }\n    function _darken(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.l -= amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n    // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n    // Values outside of this range will be wrapped into this range.\n    function _spin(color, amount) {\n        var hsl = tinycolor(color).toHsl();\n        var hue = (hsl.h + amount) % 360;\n        hsl.h = hue < 0 ? 360 + hue : hue;\n        return tinycolor(hsl);\n    }\n\n    // Combination Functions\n    // ---------------------\n    // Thanks to jQuery xColor for some of the ideas behind these\n    // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n    function _complement(color) {\n        var hsl = tinycolor(color).toHsl();\n        hsl.h = (hsl.h + 180) % 360;\n        return tinycolor(hsl);\n    }\n    function polyad(color, number) {\n        if (isNaN(number) || number <= 0) {\n            throw new Error(\"Argument to polyad must be a positive number\");\n        }\n        var hsl = tinycolor(color).toHsl();\n        var result = [tinycolor(color)];\n        var step = 360 / number;\n        for (var i = 1; i < number; i++) {\n            result.push(tinycolor({\n                h: (hsl.h + i * step) % 360,\n                s: hsl.s,\n                l: hsl.l\n            }));\n        }\n        return result;\n    }\n    function _splitcomplement(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [tinycolor(color), tinycolor({\n            h: (h + 72) % 360,\n            s: hsl.s,\n            l: hsl.l\n        }), tinycolor({\n            h: (h + 216) % 360,\n            s: hsl.s,\n            l: hsl.l\n        })];\n    }\n    function _analogous(color, results, slices) {\n        results = results || 6;\n        slices = slices || 30;\n        var hsl = tinycolor(color).toHsl();\n        var part = 360 / slices;\n        var ret = [tinycolor(color)];\n        for (hsl.h = (hsl.h - (part * results >> 1) + 720) % 360; --results;) {\n            hsl.h = (hsl.h + part) % 360;\n            ret.push(tinycolor(hsl));\n        }\n        return ret;\n    }\n    function _monochromatic(color, results) {\n        results = results || 6;\n        var hsv = tinycolor(color).toHsv();\n        var h = hsv.h,\n            s = hsv.s,\n            v = hsv.v;\n        var ret = [];\n        var modification = 1 / results;\n        while (results--) {\n            ret.push(tinycolor({\n                h: h,\n                s: s,\n                v: v\n            }));\n            v = (v + modification) % 1;\n        }\n        return ret;\n    }\n\n    // Utility Functions\n    // ---------------------\n\n    tinycolor.mix = function (color1, color2, amount) {\n        amount = amount === 0 ? 0 : amount || 50;\n        var rgb1 = tinycolor(color1).toRgb();\n        var rgb2 = tinycolor(color2).toRgb();\n        var p = amount / 100;\n        var rgba = {\n            r: (rgb2.r - rgb1.r) * p + rgb1.r,\n            g: (rgb2.g - rgb1.g) * p + rgb1.g,\n            b: (rgb2.b - rgb1.b) * p + rgb1.b,\n            a: (rgb2.a - rgb1.a) * p + rgb1.a\n        };\n        return tinycolor(rgba);\n    };\n\n    // Readability Functions\n    // ---------------------\n    // <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)\n\n    // `contrast`\n    // Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)\n    tinycolor.readability = function (color1, color2) {\n        var c1 = tinycolor(color1);\n        var c2 = tinycolor(color2);\n        return (Math.max(c1.getLuminance(), c2.getLuminance()) + 0.05) / (Math.min(c1.getLuminance(), c2.getLuminance()) + 0.05);\n    };\n\n    // `isReadable`\n    // Ensure that foreground and background color combinations meet WCAG2 guidelines.\n    // The third argument is an optional Object.\n    //      the 'level' property states 'AA' or 'AAA' - if missing or invalid, it defaults to 'AA';\n    //      the 'size' property states 'large' or 'small' - if missing or invalid, it defaults to 'small'.\n    // If the entire object is absent, isReadable defaults to {level:\"AA\",size:\"small\"}.\n\n    // *Example*\n    //    tinycolor.isReadable(\"#000\", \"#111\") => false\n    //    tinycolor.isReadable(\"#000\", \"#111\",{level:\"AA\",size:\"large\"}) => false\n    tinycolor.isReadable = function (color1, color2, wcag2) {\n        var readability = tinycolor.readability(color1, color2);\n        var wcag2Parms, out;\n        out = false;\n        wcag2Parms = validateWCAG2Parms(wcag2);\n        switch (wcag2Parms.level + wcag2Parms.size) {\n            case \"AAsmall\":\n            case \"AAAlarge\":\n                out = readability >= 4.5;\n                break;\n            case \"AAlarge\":\n                out = readability >= 3;\n                break;\n            case \"AAAsmall\":\n                out = readability >= 7;\n                break;\n        }\n        return out;\n    };\n\n    // `mostReadable`\n    // Given a base color and a list of possible foreground or background\n    // colors for that base, returns the most readable color.\n    // Optionally returns Black or White if the most readable color is unreadable.\n    // *Example*\n    //    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:false}).toHexString(); // \"#112255\"\n    //    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:true}).toHexString();  // \"#ffffff\"\n    //    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"large\"}).toHexString(); // \"#faf3f3\"\n    //    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"small\"}).toHexString(); // \"#ffffff\"\n    tinycolor.mostReadable = function (baseColor, colorList, args) {\n        var bestColor = null;\n        var bestScore = 0;\n        var readability;\n        var includeFallbackColors, level, size;\n        args = args || {};\n        includeFallbackColors = args.includeFallbackColors;\n        level = args.level;\n        size = args.size;\n        for (var i = 0; i < colorList.length; i++) {\n            readability = tinycolor.readability(baseColor, colorList[i]);\n            if (readability > bestScore) {\n                bestScore = readability;\n                bestColor = tinycolor(colorList[i]);\n            }\n        }\n        if (tinycolor.isReadable(baseColor, bestColor, {\n            level: level,\n            size: size\n        }) || !includeFallbackColors) {\n            return bestColor;\n        } else {\n            args.includeFallbackColors = false;\n            return tinycolor.mostReadable(baseColor, [\"#fff\", \"#000\"], args);\n        }\n    };\n\n    // Big List of Colors\n    // ------------------\n    // <https://www.w3.org/TR/css-color-4/#named-colors>\n    var names = tinycolor.names = {\n        aliceblue: \"f0f8ff\",\n        antiquewhite: \"faebd7\",\n        aqua: \"0ff\",\n        aquamarine: \"7fffd4\",\n        azure: \"f0ffff\",\n        beige: \"f5f5dc\",\n        bisque: \"ffe4c4\",\n        black: \"000\",\n        blanchedalmond: \"ffebcd\",\n        blue: \"00f\",\n        blueviolet: \"8a2be2\",\n        brown: \"a52a2a\",\n        burlywood: \"deb887\",\n        burntsienna: \"ea7e5d\",\n        cadetblue: \"5f9ea0\",\n        chartreuse: \"7fff00\",\n        chocolate: \"d2691e\",\n        coral: \"ff7f50\",\n        cornflowerblue: \"6495ed\",\n        cornsilk: \"fff8dc\",\n        crimson: \"dc143c\",\n        cyan: \"0ff\",\n        darkblue: \"00008b\",\n        darkcyan: \"008b8b\",\n        darkgoldenrod: \"b8860b\",\n        darkgray: \"a9a9a9\",\n        darkgreen: \"006400\",\n        darkgrey: \"a9a9a9\",\n        darkkhaki: \"bdb76b\",\n        darkmagenta: \"8b008b\",\n        darkolivegreen: \"556b2f\",\n        darkorange: \"ff8c00\",\n        darkorchid: \"9932cc\",\n        darkred: \"8b0000\",\n        darksalmon: \"e9967a\",\n        darkseagreen: \"8fbc8f\",\n        darkslateblue: \"483d8b\",\n        darkslategray: \"2f4f4f\",\n        darkslategrey: \"2f4f4f\",\n        darkturquoise: \"00ced1\",\n        darkviolet: \"9400d3\",\n        deeppink: \"ff1493\",\n        deepskyblue: \"00bfff\",\n        dimgray: \"696969\",\n        dimgrey: \"696969\",\n        dodgerblue: \"1e90ff\",\n        firebrick: \"b22222\",\n        floralwhite: \"fffaf0\",\n        forestgreen: \"228b22\",\n        fuchsia: \"f0f\",\n        gainsboro: \"dcdcdc\",\n        ghostwhite: \"f8f8ff\",\n        gold: \"ffd700\",\n        goldenrod: \"daa520\",\n        gray: \"808080\",\n        green: \"008000\",\n        greenyellow: \"adff2f\",\n        grey: \"808080\",\n        honeydew: \"f0fff0\",\n        hotpink: \"ff69b4\",\n        indianred: \"cd5c5c\",\n        indigo: \"4b0082\",\n        ivory: \"fffff0\",\n        khaki: \"f0e68c\",\n        lavender: \"e6e6fa\",\n        lavenderblush: \"fff0f5\",\n        lawngreen: \"7cfc00\",\n        lemonchiffon: \"fffacd\",\n        lightblue: \"add8e6\",\n        lightcoral: \"f08080\",\n        lightcyan: \"e0ffff\",\n        lightgoldenrodyellow: \"fafad2\",\n        lightgray: \"d3d3d3\",\n        lightgreen: \"90ee90\",\n        lightgrey: \"d3d3d3\",\n        lightpink: \"ffb6c1\",\n        lightsalmon: \"ffa07a\",\n        lightseagreen: \"20b2aa\",\n        lightskyblue: \"87cefa\",\n        lightslategray: \"789\",\n        lightslategrey: \"789\",\n        lightsteelblue: \"b0c4de\",\n        lightyellow: \"ffffe0\",\n        lime: \"0f0\",\n        limegreen: \"32cd32\",\n        linen: \"faf0e6\",\n        magenta: \"f0f\",\n        maroon: \"800000\",\n        mediumaquamarine: \"66cdaa\",\n        mediumblue: \"0000cd\",\n        mediumorchid: \"ba55d3\",\n        mediumpurple: \"9370db\",\n        mediumseagreen: \"3cb371\",\n        mediumslateblue: \"7b68ee\",\n        mediumspringgreen: \"00fa9a\",\n        mediumturquoise: \"48d1cc\",\n        mediumvioletred: \"c71585\",\n        midnightblue: \"191970\",\n        mintcream: \"f5fffa\",\n        mistyrose: \"ffe4e1\",\n        moccasin: \"ffe4b5\",\n        navajowhite: \"ffdead\",\n        navy: \"000080\",\n        oldlace: \"fdf5e6\",\n        olive: \"808000\",\n        olivedrab: \"6b8e23\",\n        orange: \"ffa500\",\n        orangered: \"ff4500\",\n        orchid: \"da70d6\",\n        palegoldenrod: \"eee8aa\",\n        palegreen: \"98fb98\",\n        paleturquoise: \"afeeee\",\n        palevioletred: \"db7093\",\n        papayawhip: \"ffefd5\",\n        peachpuff: \"ffdab9\",\n        peru: \"cd853f\",\n        pink: \"ffc0cb\",\n        plum: \"dda0dd\",\n        powderblue: \"b0e0e6\",\n        purple: \"800080\",\n        rebeccapurple: \"663399\",\n        red: \"f00\",\n        rosybrown: \"bc8f8f\",\n        royalblue: \"4169e1\",\n        saddlebrown: \"8b4513\",\n        salmon: \"fa8072\",\n        sandybrown: \"f4a460\",\n        seagreen: \"2e8b57\",\n        seashell: \"fff5ee\",\n        sienna: \"a0522d\",\n        silver: \"c0c0c0\",\n        skyblue: \"87ceeb\",\n        slateblue: \"6a5acd\",\n        slategray: \"708090\",\n        slategrey: \"708090\",\n        snow: \"fffafa\",\n        springgreen: \"00ff7f\",\n        steelblue: \"4682b4\",\n        tan: \"d2b48c\",\n        teal: \"008080\",\n        thistle: \"d8bfd8\",\n        tomato: \"ff6347\",\n        turquoise: \"40e0d0\",\n        violet: \"ee82ee\",\n        wheat: \"f5deb3\",\n        white: \"fff\",\n        whitesmoke: \"f5f5f5\",\n        yellow: \"ff0\",\n        yellowgreen: \"9acd32\"\n    };\n\n    // Make it easy to access colors via `hexNames[hex]`\n    var hexNames = tinycolor.hexNames = flip(names);\n\n    // Utilities\n    // ---------\n\n    // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n    function flip(o) {\n        var flipped = {};\n        for (var i in o) {\n            if (o.hasOwnProperty(i)) {\n                flipped[o[i]] = i;\n            }\n        }\n        return flipped;\n    }\n\n    // Return a valid alpha value [0,1] with all invalid values being set to 1\n    function boundAlpha(a) {\n        a = parseFloat(a);\n        if (isNaN(a) || a < 0 || a > 1) {\n            a = 1;\n        }\n        return a;\n    }\n\n    // Take input from [0, n] and return it as [0, 1]\n    function bound01(n, max) {\n        if (isOnePointZero(n)) n = \"100%\";\n        var processPercent = isPercentage(n);\n        n = Math.min(max, Math.max(0, parseFloat(n)));\n\n        // Automatically convert percentage into number\n        if (processPercent) {\n            n = parseInt(n * max, 10) / 100;\n        }\n\n        // Handle floating point rounding errors\n        if (Math.abs(n - max) < 0.000001) {\n            return 1;\n        }\n\n        // Convert into [0, 1] range if it isn't already\n        return n % max / parseFloat(max);\n    }\n\n    // Force a number between 0 and 1\n    function clamp01(val) {\n        return Math.min(1, Math.max(0, val));\n    }\n\n    // Parse a base-16 hex value into a base-10 integer\n    function parseIntFromHex(val) {\n        return parseInt(val, 16);\n    }\n\n    // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n    // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n    function isOnePointZero(n) {\n        return typeof n == \"string\" && n.indexOf(\".\") != -1 && parseFloat(n) === 1;\n    }\n\n    // Check to see if string passed in is a percentage\n    function isPercentage(n) {\n        return typeof n === \"string\" && n.indexOf(\"%\") != -1;\n    }\n\n    // Force a hex value to have 2 characters\n    function pad2(c) {\n        return c.length == 1 ? \"0\" + c : \"\" + c;\n    }\n\n    // Replace a decimal with it's percentage value\n    function convertToPercentage(n) {\n        if (n <= 1) {\n            n = n * 100 + \"%\";\n        }\n        return n;\n    }\n\n    // Converts a decimal to a hex value\n    function convertDecimalToHex(d) {\n        return Math.round(parseFloat(d) * 255).toString(16);\n    }\n    // Converts a hex value to a decimal\n    function convertHexToDecimal(h) {\n        return parseIntFromHex(h) / 255;\n    }\n    var matchers = function () {\n        // <http://www.w3.org/TR/css3-values/#integers>\n        var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n        // <http://www.w3.org/TR/css3-values/#number-value>\n        var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n        // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n        var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n        // Actual matching.\n        // Parentheses and commas are optional, but not required.\n        // Whitespace can take the place of commas or opening paren\n        var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        return {\n            CSS_UNIT: new RegExp(CSS_UNIT),\n            rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n            rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n            hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n            hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n            hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n            hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n            hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n            hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n        };\n    }();\n\n    // `isValidCSSUnit`\n    // Take in a single string / number and check to see if it looks like a CSS unit\n    // (see `matchers` above for definition).\n    function isValidCSSUnit(color) {\n        return !!matchers.CSS_UNIT.exec(color);\n    }\n\n    // `stringInputToObject`\n    // Permissive string parsing.  Take in a number of formats, and output an object\n    // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n    function stringInputToObject(color) {\n        color = color.replace(trimLeft, \"\").replace(trimRight, \"\").toLowerCase();\n        var named = false;\n        if (names[color]) {\n            color = names[color];\n            named = true;\n        } else if (color == \"transparent\") {\n            return {\n                r: 0,\n                g: 0,\n                b: 0,\n                a: 0,\n                format: \"name\"\n            };\n        }\n\n        // Try to match string input using regular expressions.\n        // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n        // Just return an object and let the conversion functions handle that.\n        // This way the result will be the same whether the tinycolor is initialized with string or object.\n        var match;\n        if (match = matchers.rgb.exec(color)) {\n            return {\n                r: match[1],\n                g: match[2],\n                b: match[3]\n            };\n        }\n        if (match = matchers.rgba.exec(color)) {\n            return {\n                r: match[1],\n                g: match[2],\n                b: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hsl.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                l: match[3]\n            };\n        }\n        if (match = matchers.hsla.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                l: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hsv.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                v: match[3]\n            };\n        }\n        if (match = matchers.hsva.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                v: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hex8.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                a: convertHexToDecimal(match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if (match = matchers.hex6.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        if (match = matchers.hex4.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1] + \"\" + match[1]),\n                g: parseIntFromHex(match[2] + \"\" + match[2]),\n                b: parseIntFromHex(match[3] + \"\" + match[3]),\n                a: convertHexToDecimal(match[4] + \"\" + match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if (match = matchers.hex3.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1] + \"\" + match[1]),\n                g: parseIntFromHex(match[2] + \"\" + match[2]),\n                b: parseIntFromHex(match[3] + \"\" + match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        return false;\n    }\n    function validateWCAG2Parms(parms) {\n        // return valid WCAG2 parms for isReadable.\n        // If input parms are invalid, return {\"level\":\"AA\", \"size\":\"small\"}\n        var level, size;\n        parms = parms || {\n            level: \"AA\",\n            size: \"small\"\n        };\n        level = (parms.level || \"AA\").toUpperCase();\n        size = (parms.size || \"small\").toLowerCase();\n        if (level !== \"AA\" && level !== \"AAA\") {\n            level = \"AA\";\n        }\n        if (size !== \"small\" && size !== \"large\") {\n            size = \"small\";\n        }\n        return {\n            level: level,\n            size: size\n        };\n    }\n\n    return tinycolor;\n\n}));\n","jquery/spectrum/spectrum.js":"// Spectrum Colorpicker v1.8.1\n// https://github.com/bgrins/spectrum\n// Author: Brian Grinstead\n// License: MIT\n\n(function (factory) {\n    \"use strict\";\n\n    if (typeof define === 'function' && define.amd) { // AMD\n        define(['jquery'], factory);\n    }\n    else if (typeof exports == \"object\" && typeof module == \"object\") { // CommonJS\n        module.exports = factory(require('jquery'));\n    }\n    else { // Browser\n        factory(jQuery);\n    }\n})(function($, undefined) {\n    \"use strict\";\n\n    var defaultOpts = {\n\n            // Callbacks\n            beforeShow: noop,\n            move: noop,\n            change: noop,\n            show: noop,\n            hide: noop,\n\n            // Options\n            color: false,\n            flat: false,\n            showInput: false,\n            allowEmpty: false,\n            showButtons: true,\n            clickoutFiresChange: true,\n            showInitial: false,\n            showPalette: false,\n            showPaletteOnly: false,\n            hideAfterPaletteSelect: false,\n            togglePaletteOnly: false,\n            showSelectionPalette: true,\n            localStorageKey: false,\n            appendTo: \"body\",\n            maxSelectionSize: 7,\n            cancelText: \"cancel\",\n            chooseText: \"choose\",\n            togglePaletteMoreText: \"more\",\n            togglePaletteLessText: \"less\",\n            clearText: \"Clear Color Selection\",\n            noColorSelectedText: \"No Color Selected\",\n            preferredFormat: false,\n            className: \"\", // Deprecated - use containerClassName and replacerClassName instead.\n            containerClassName: \"\",\n            replacerClassName: \"\",\n            showAlpha: false,\n            theme: \"sp-light\",\n            palette: [[\"#ffffff\", \"#000000\", \"#ff0000\", \"#ff8000\", \"#ffff00\", \"#008000\", \"#0000ff\", \"#4b0082\", \"#9400d3\"]],\n            selectionPalette: [],\n            disabled: false,\n            offset: null\n        },\n        spectrums = [],\n        IE = !!/msie/i.exec( window.navigator.userAgent ),\n        rgbaSupport = (function() {\n            function contains( str, substr ) {\n                return !!~('' + str).indexOf(substr);\n            }\n\n            var elem = document.createElement('div');\n            var style = elem.style;\n            style.cssText = 'background-color:rgba(0,0,0,.5)';\n            return contains(style.backgroundColor, 'rgba') || contains(style.backgroundColor, 'hsla');\n        })(),\n        replaceInput = [\n            \"<div class='sp-replacer'>\",\n            \"<div class='sp-preview'><div class='sp-preview-inner'></div></div>\",\n            \"<div class='sp-dd'>&#9660;</div>\",\n            \"</div>\"\n        ].join(''),\n        markup = (function () {\n\n            // IE does not support gradients with multiple stops, so we need to simulate\n            //  that for the rainbow slider with 8 divs that each have a single gradient\n            var gradientFix = \"\";\n            if (IE) {\n                for (var i = 1; i <= 6; i++) {\n                    gradientFix += \"<div class='sp-\" + i + \"'></div>\";\n                }\n            }\n\n            return [\n                \"<div class='sp-container sp-hidden'>\",\n                \"<div class='sp-palette-container'>\",\n                \"<div class='sp-palette sp-thumb sp-cf'></div>\",\n                \"<div class='sp-palette-button-container sp-cf'>\",\n                \"<button type='button' class='sp-palette-toggle'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-picker-container'>\",\n                \"<div class='sp-top sp-cf'>\",\n                \"<div class='sp-fill'></div>\",\n                \"<div class='sp-top-inner'>\",\n                \"<div class='sp-color'>\",\n                \"<div class='sp-sat'>\",\n                \"<div class='sp-val'>\",\n                \"<div class='sp-dragger'></div>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-clear sp-clear-display'>\",\n                \"</div>\",\n                \"<div class='sp-hue'>\",\n                \"<div class='sp-slider'></div>\",\n                gradientFix,\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>\",\n                \"</div>\",\n                \"<div class='sp-input-container sp-cf'>\",\n                \"<input class='sp-input' type='text' spellcheck='false'  />\",\n                \"</div>\",\n                \"<div class='sp-initial sp-thumb sp-cf'></div>\",\n                \"<div class='sp-button-container sp-cf'>\",\n                \"<a class='sp-cancel' href='#'></a>\",\n                \"<button type='button' class='sp-choose'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\"\n            ].join(\"\");\n        })();\n\n    function paletteTemplate (p, color, className, opts) {\n        var html = [];\n        for (var i = 0; i < p.length; i++) {\n            var current = p[i];\n            if(current) {\n                var tiny = tinycolor(current);\n                var c = tiny.toHsl().l < 0.5 ? \"sp-thumb-el sp-thumb-dark\" : \"sp-thumb-el sp-thumb-light\";\n                c += (tinycolor.equals(color, current)) ? \" sp-thumb-active\" : \"\";\n                var formattedString = tiny.toString(opts.preferredFormat || \"rgb\");\n                var swatchStyle = rgbaSupport ? (\"background-color:\" + tiny.toRgbString()) : \"filter:\" + tiny.toFilter();\n                html.push('<span title=\"' + formattedString + '\" data-color=\"' + tiny.toRgbString() + '\" class=\"' + c + '\"><span class=\"sp-thumb-inner\" style=\"' + swatchStyle + ';\"></span></span>');\n            } else {\n                var cls = 'sp-clear-display';\n                html.push($('<div />')\n                    .append($('<span data-color=\"\" style=\"background-color:transparent;\" class=\"' + cls + '\"></span>')\n                        .attr('title', opts.noColorSelectedText)\n                    )\n                    .html()\n                );\n            }\n        }\n        return \"<div class='sp-cf \" + className + \"'>\" + html.join('') + \"</div>\";\n    }\n\n    function hideAll() {\n        for (var i = 0; i < spectrums.length; i++) {\n            if (spectrums[i]) {\n                spectrums[i].hide();\n            }\n        }\n    }\n\n    function instanceOptions(o, callbackContext) {\n        var opts = $.extend({}, defaultOpts, o);\n        opts.callbacks = {\n            'move': bind(opts.move, callbackContext),\n            'change': bind(opts.change, callbackContext),\n            'show': bind(opts.show, callbackContext),\n            'hide': bind(opts.hide, callbackContext),\n            'beforeShow': bind(opts.beforeShow, callbackContext)\n        };\n\n        return opts;\n    }\n\n    function spectrum(element, o) {\n\n        var opts = instanceOptions(o, element),\n            flat = opts.flat,\n            showSelectionPalette = opts.showSelectionPalette,\n            localStorageKey = opts.localStorageKey,\n            theme = opts.theme,\n            callbacks = opts.callbacks,\n            resize = throttle(reflow, 10),\n            visible = false,\n            isDragging = false,\n            dragWidth = 0,\n            dragHeight = 0,\n            dragHelperHeight = 0,\n            slideHeight = 0,\n            slideWidth = 0,\n            alphaWidth = 0,\n            alphaSlideHelperWidth = 0,\n            slideHelperHeight = 0,\n            currentHue = 0,\n            currentSaturation = 0,\n            currentValue = 0,\n            currentAlpha = 1,\n            palette = [],\n            paletteArray = [],\n            paletteLookup = {},\n            selectionPalette = opts.selectionPalette.slice(0),\n            maxSelectionSize = opts.maxSelectionSize,\n            draggingClass = \"sp-dragging\",\n            shiftMovementDirection = null;\n\n        var doc = element.ownerDocument,\n            body = doc.body,\n            boundElement = $(element),\n            disabled = false,\n            container = $(markup, doc).addClass(theme),\n            pickerContainer = container.find(\".sp-picker-container\"),\n            dragger = container.find(\".sp-color\"),\n            dragHelper = container.find(\".sp-dragger\"),\n            slider = container.find(\".sp-hue\"),\n            slideHelper = container.find(\".sp-slider\"),\n            alphaSliderInner = container.find(\".sp-alpha-inner\"),\n            alphaSlider = container.find(\".sp-alpha\"),\n            alphaSlideHelper = container.find(\".sp-alpha-handle\"),\n            textInput = container.find(\".sp-input\"),\n            paletteContainer = container.find(\".sp-palette\"),\n            initialColorContainer = container.find(\".sp-initial\"),\n            cancelButton = container.find(\".sp-cancel\"),\n            clearButton = container.find(\".sp-clear\"),\n            chooseButton = container.find(\".sp-choose\"),\n            toggleButton = container.find(\".sp-palette-toggle\"),\n            isInput = boundElement.is(\"input\"),\n            isInputTypeColor = isInput && boundElement.attr(\"type\") === \"color\" && inputTypeColorSupport(),\n            shouldReplace = isInput && !flat,\n            replacer = (shouldReplace) ? $(replaceInput).addClass(theme).addClass(opts.className).addClass(opts.replacerClassName) : $([]),\n            offsetElement = (shouldReplace) ? replacer : boundElement,\n            previewElement = replacer.find(\".sp-preview-inner\"),\n            initialColor = opts.color || (isInput && boundElement.val()),\n            colorOnShow = false,\n            currentPreferredFormat = opts.preferredFormat,\n            clickoutFiresChange = !opts.showButtons || opts.clickoutFiresChange,\n            isEmpty = !initialColor,\n            allowEmpty = opts.allowEmpty && !isInputTypeColor;\n\n        function applyOptions() {\n\n            if (opts.showPaletteOnly) {\n                opts.showPalette = true;\n            }\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n\n            if (opts.palette) {\n                palette = opts.palette.slice(0);\n                paletteArray = $.isArray(palette[0]) ? palette : [palette];\n                paletteLookup = {};\n                for (var i = 0; i < paletteArray.length; i++) {\n                    for (var j = 0; j < paletteArray[i].length; j++) {\n                        var rgb = tinycolor(paletteArray[i][j]).toRgbString();\n                        paletteLookup[rgb] = true;\n                    }\n                }\n            }\n\n            container.toggleClass(\"sp-flat\", flat);\n            container.toggleClass(\"sp-input-disabled\", !opts.showInput);\n            container.toggleClass(\"sp-alpha-enabled\", opts.showAlpha);\n            container.toggleClass(\"sp-clear-enabled\", allowEmpty);\n            container.toggleClass(\"sp-buttons-disabled\", !opts.showButtons);\n            container.toggleClass(\"sp-palette-buttons-disabled\", !opts.togglePaletteOnly);\n            container.toggleClass(\"sp-palette-disabled\", !opts.showPalette);\n            container.toggleClass(\"sp-palette-only\", opts.showPaletteOnly);\n            container.toggleClass(\"sp-initial-disabled\", !opts.showInitial);\n            container.addClass(opts.className).addClass(opts.containerClassName);\n\n            reflow();\n        }\n\n        function initialize() {\n\n            if (IE) {\n                container.find(\"*:not(input)\").attr(\"unselectable\", \"on\");\n            }\n\n            applyOptions();\n\n            if (shouldReplace) {\n                boundElement.after(replacer).hide();\n            }\n\n            if (!allowEmpty) {\n                clearButton.hide();\n            }\n\n            if (flat) {\n                boundElement.after(container).hide();\n            }\n            else {\n\n                var appendTo = opts.appendTo === \"parent\" ? boundElement.parent() : $(opts.appendTo);\n                if (appendTo.length !== 1) {\n                    appendTo = $(\"body\");\n                }\n\n                appendTo.append(container);\n            }\n\n            updateSelectionPaletteFromStorage();\n\n            offsetElement.on(\"click.spectrum touchstart.spectrum\", function (e) {\n                if (!disabled) {\n                    toggle();\n                }\n\n                e.stopPropagation();\n\n                if (!$(e.target).is(\"input\")) {\n                    e.preventDefault();\n                }\n            });\n\n            if(boundElement.is(\":disabled\") || (opts.disabled === true)) {\n                disable();\n            }\n\n            // Prevent clicks from bubbling up to document.  This would cause it to be hidden.\n            container.click(stopPropagation);\n\n            // Handle user typed input\n            textInput.change(setFromTextInput);\n            textInput.on(\"paste\", function () {\n                setTimeout(setFromTextInput, 1);\n            });\n            textInput.keydown(function (e) { if (e.keyCode == 13) { setFromTextInput(); } });\n\n            cancelButton.text(opts.cancelText);\n            cancelButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                revert();\n                hide();\n            });\n\n            clearButton.attr(\"title\", opts.clearText);\n            clearButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                isEmpty = true;\n                move();\n\n                if(flat) {\n                    //for the flat style, this is a change event\n                    updateOriginalInput(true);\n                }\n            });\n\n            chooseButton.text(opts.chooseText);\n            chooseButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                if (IE && textInput.is(\":focus\")) {\n                    textInput.trigger('change');\n                }\n\n                if (isValid()) {\n                    updateOriginalInput(true);\n                    hide();\n                }\n            });\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n            toggleButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                opts.showPaletteOnly = !opts.showPaletteOnly;\n\n                // To make sure the Picker area is drawn on the right, next to the\n                // Palette area (and not below the palette), first move the Palette\n                // to the left to make space for the picker, plus 5px extra.\n                // The 'applyOptions' function puts the whole container back into place\n                // and takes care of the button-text and the sp-palette-only CSS class.\n                if (!opts.showPaletteOnly && !flat) {\n                    container.css('left', '-=' + (pickerContainer.outerWidth(true) + 5));\n                }\n                applyOptions();\n            });\n\n            draggable(alphaSlider, function (dragX, dragY, e) {\n                currentAlpha = (dragX / alphaWidth);\n                isEmpty = false;\n                if (e.shiftKey) {\n                    currentAlpha = Math.round(currentAlpha * 10) / 10;\n                }\n\n                move();\n            }, dragStart, dragStop);\n\n            draggable(slider, function (dragX, dragY) {\n                currentHue = parseFloat(dragY / slideHeight);\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n                move();\n            }, dragStart, dragStop);\n\n            draggable(dragger, function (dragX, dragY, e) {\n\n                // shift+drag should snap the movement to either the x or y axis.\n                if (!e.shiftKey) {\n                    shiftMovementDirection = null;\n                }\n                else if (!shiftMovementDirection) {\n                    var oldDragX = currentSaturation * dragWidth;\n                    var oldDragY = dragHeight - (currentValue * dragHeight);\n                    var furtherFromX = Math.abs(dragX - oldDragX) > Math.abs(dragY - oldDragY);\n\n                    shiftMovementDirection = furtherFromX ? \"x\" : \"y\";\n                }\n\n                var setSaturation = !shiftMovementDirection || shiftMovementDirection === \"x\";\n                var setValue = !shiftMovementDirection || shiftMovementDirection === \"y\";\n\n                if (setSaturation) {\n                    currentSaturation = parseFloat(dragX / dragWidth);\n                }\n                if (setValue) {\n                    currentValue = parseFloat((dragHeight - dragY) / dragHeight);\n                }\n\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n\n                move();\n\n            }, dragStart, dragStop);\n\n            if (!!initialColor) {\n                set(initialColor);\n\n                // In case color was black - update the preview UI and set the format\n                // since the set function will not run (default color is black).\n                updateUI();\n                currentPreferredFormat = opts.preferredFormat || tinycolor(initialColor).format;\n\n                addColorToSelectionPalette(initialColor);\n            }\n            else {\n                updateUI();\n            }\n\n            if (flat) {\n                show();\n            }\n\n            function paletteElementClick(e) {\n                if (e.data && e.data.ignore) {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n                }\n                else {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n\n                    updateOriginalInput(true);\n                    if (opts.hideAfterPaletteSelect) {\n                        hide();\n                    }\n                }\n\n                return false;\n            }\n\n            var paletteEvent = IE ? \"mousedown.spectrum\" : \"click.spectrum touchstart.spectrum\";\n            paletteContainer.on(paletteEvent, \".sp-thumb-el\", paletteElementClick);\n            initialColorContainer.on(paletteEvent, \".sp-thumb-el:nth-child(1)\", { ignore: true }, paletteElementClick);\n        }\n\n        function updateSelectionPaletteFromStorage() {\n\n            if (localStorageKey && window.localStorage) {\n\n                // Migrate old palettes over to new format.  May want to remove this eventually.\n                try {\n                    var oldPalette = window.localStorage[localStorageKey].split(\",#\");\n                    if (oldPalette.length > 1) {\n                        delete window.localStorage[localStorageKey];\n                        $.each(oldPalette, function(i, c) {\n                            addColorToSelectionPalette(c);\n                        });\n                    }\n                }\n                catch(e) { }\n\n                try {\n                    selectionPalette = window.localStorage[localStorageKey].split(\";\");\n                }\n                catch (e) { }\n            }\n        }\n\n        function addColorToSelectionPalette(color) {\n            if (showSelectionPalette) {\n                var rgb = tinycolor(color).toRgbString();\n                if (!paletteLookup[rgb] && $.inArray(rgb, selectionPalette) === -1) {\n                    selectionPalette.push(rgb);\n                    while(selectionPalette.length > maxSelectionSize) {\n                        selectionPalette.shift();\n                    }\n                }\n\n                if (localStorageKey && window.localStorage) {\n                    try {\n                        window.localStorage[localStorageKey] = selectionPalette.join(\";\");\n                    }\n                    catch(e) { }\n                }\n            }\n        }\n\n        function getUniqueSelectionPalette() {\n            var unique = [];\n            if (opts.showPalette) {\n                for (var i = 0; i < selectionPalette.length; i++) {\n                    var rgb = tinycolor(selectionPalette[i]).toRgbString();\n\n                    if (!paletteLookup[rgb]) {\n                        unique.push(selectionPalette[i]);\n                    }\n                }\n            }\n\n            return unique.reverse().slice(0, opts.maxSelectionSize);\n        }\n\n        function drawPalette() {\n\n            var currentColor = get();\n\n            var html = $.map(paletteArray, function (palette, i) {\n                return paletteTemplate(palette, currentColor, \"sp-palette-row sp-palette-row-\" + i, opts);\n            });\n\n            updateSelectionPaletteFromStorage();\n\n            if (selectionPalette) {\n                html.push(paletteTemplate(getUniqueSelectionPalette(), currentColor, \"sp-palette-row sp-palette-row-selection\", opts));\n            }\n\n            paletteContainer.html(html.join(\"\"));\n        }\n\n        function drawInitial() {\n            if (opts.showInitial) {\n                var initial = colorOnShow;\n                var current = get();\n                initialColorContainer.html(paletteTemplate([initial, current], current, \"sp-palette-row-initial\", opts));\n            }\n        }\n\n        function dragStart() {\n            if (dragHeight <= 0 || dragWidth <= 0 || slideHeight <= 0) {\n                reflow();\n            }\n            isDragging = true;\n            container.addClass(draggingClass);\n            shiftMovementDirection = null;\n            boundElement.trigger('dragstart.spectrum', [ get() ]);\n        }\n\n        function dragStop() {\n            isDragging = false;\n            container.removeClass(draggingClass);\n            boundElement.trigger('dragstop.spectrum', [ get() ]);\n        }\n\n        function setFromTextInput() {\n\n            var value = textInput.val();\n\n            if ((value === null || value === \"\") && allowEmpty) {\n                set(null);\n                move();\n                updateOriginalInput();\n            }\n            else {\n                var tiny = tinycolor(value);\n                if (tiny.isValid()) {\n                    set(tiny);\n                    move();\n                    updateOriginalInput(true);\n                }\n                else {\n                    textInput.addClass(\"sp-validation-error\");\n                }\n            }\n        }\n\n        function toggle() {\n            if (visible) {\n                hide();\n            }\n            else {\n                show();\n            }\n        }\n\n        function show() {\n            var event = $.Event('beforeShow.spectrum');\n\n            if (visible) {\n                reflow();\n                return;\n            }\n\n            boundElement.trigger(event, [ get() ]);\n\n            if (callbacks.beforeShow(get()) === false || event.isDefaultPrevented()) {\n                return;\n            }\n\n            hideAll();\n            visible = true;\n\n            $(doc).on(\"keydown.spectrum\", onkeydown);\n            $(doc).on(\"click.spectrum\", clickout);\n            $(window).on(\"resize.spectrum\", resize);\n            replacer.addClass(\"sp-active\");\n            container.removeClass(\"sp-hidden\");\n\n            reflow();\n            updateUI();\n\n            colorOnShow = get();\n\n            drawInitial();\n            callbacks.show(colorOnShow);\n            boundElement.trigger('show.spectrum', [ colorOnShow ]);\n        }\n\n        function onkeydown(e) {\n            // Close on ESC\n            if (e.keyCode === 27) {\n                hide();\n            }\n        }\n\n        function clickout(e) {\n            // Return on right click.\n            if (e.button == 2) { return; }\n\n            // If a drag event was happening during the mouseup, don't hide\n            // on click.\n            if (isDragging) { return; }\n\n            if (clickoutFiresChange) {\n                updateOriginalInput(true);\n            }\n            else {\n                revert();\n            }\n            hide();\n        }\n\n        function hide() {\n            // Return if hiding is unnecessary\n            if (!visible || flat) { return; }\n            visible = false;\n\n            $(doc).off(\"keydown.spectrum\", onkeydown);\n            $(doc).off(\"click.spectrum\", clickout);\n            $(window).off(\"resize.spectrum\", resize);\n\n            replacer.removeClass(\"sp-active\");\n            container.addClass(\"sp-hidden\");\n\n            callbacks.hide(get());\n            boundElement.trigger('hide.spectrum', [ get() ]);\n        }\n\n        function revert() {\n            set(colorOnShow, true);\n            updateOriginalInput(true);\n        }\n\n        function set(color, ignoreFormatChange) {\n            if (tinycolor.equals(color, get())) {\n                // Update UI just in case a validation error needs\n                // to be cleared.\n                updateUI();\n                return;\n            }\n\n            var newColor, newHsv;\n            if (!color && allowEmpty) {\n                isEmpty = true;\n            } else {\n                isEmpty = false;\n                newColor = tinycolor(color);\n                newHsv = newColor.toHsv();\n\n                currentHue = (newHsv.h % 360) / 360;\n                currentSaturation = newHsv.s;\n                currentValue = newHsv.v;\n                currentAlpha = newHsv.a;\n            }\n            updateUI();\n\n            if (newColor && newColor.isValid() && !ignoreFormatChange) {\n                currentPreferredFormat = opts.preferredFormat || newColor.getFormat();\n            }\n        }\n\n        function get(opts) {\n            opts = opts || { };\n\n            if (allowEmpty && isEmpty) {\n                return null;\n            }\n\n            return tinycolor.fromRatio({\n                h: currentHue,\n                s: currentSaturation,\n                v: currentValue,\n                a: Math.round(currentAlpha * 1000) / 1000\n            }, { format: opts.format || currentPreferredFormat });\n        }\n\n        function isValid() {\n            return !textInput.hasClass(\"sp-validation-error\");\n        }\n\n        function move() {\n            updateUI();\n\n            callbacks.move(get());\n            boundElement.trigger('move.spectrum', [ get() ]);\n        }\n\n        function updateUI() {\n\n            textInput.removeClass(\"sp-validation-error\");\n\n            updateHelperLocations();\n\n            // Update dragger background color (gradients take care of saturation and value).\n            var flatColor = tinycolor.fromRatio({ h: currentHue, s: 1, v: 1 });\n            dragger.css(\"background-color\", flatColor.toHexString());\n\n            // Get a format that alpha will be included in (hex and names ignore alpha)\n            var format = currentPreferredFormat;\n            if (currentAlpha < 1 && !(currentAlpha === 0 && format === \"name\")) {\n                if (format === \"hex\" || format === \"hex3\" || format === \"hex6\" || format === \"name\") {\n                    format = \"rgb\";\n                }\n            }\n\n            var realColor = get({ format: format }),\n                displayColor = '';\n\n            //reset background info for preview element\n            previewElement.removeClass(\"sp-clear-display\");\n            previewElement.css('background-color', 'transparent');\n\n            if (!realColor && allowEmpty) {\n                // Update the replaced elements background with icon indicating no color selection\n                previewElement.addClass(\"sp-clear-display\");\n            }\n            else {\n                var realHex = realColor.toHexString(),\n                    realRgb = realColor.toRgbString();\n\n                // Update the replaced elements background color (with actual selected color)\n                if (rgbaSupport || realColor.alpha === 1) {\n                    previewElement.css(\"background-color\", realRgb);\n                }\n                else {\n                    previewElement.css(\"background-color\", \"transparent\");\n                    previewElement.css(\"filter\", realColor.toFilter());\n                }\n\n                if (opts.showAlpha) {\n                    var rgb = realColor.toRgb();\n                    rgb.a = 0;\n                    var realAlpha = tinycolor(rgb).toRgbString();\n                    var gradient = \"linear-gradient(left, \" + realAlpha + \", \" + realHex + \")\";\n\n                    if (IE) {\n                        alphaSliderInner.css(\"filter\", tinycolor(realAlpha).toFilter({ gradientType: 1 }, realHex));\n                    }\n                    else {\n                        alphaSliderInner.css(\"background\", \"-webkit-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-moz-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-ms-\" + gradient);\n                        // Use current syntax gradient on unprefixed property.\n                        alphaSliderInner.css(\"background\",\n                            \"linear-gradient(to right, \" + realAlpha + \", \" + realHex + \")\");\n                    }\n                }\n\n                displayColor = realColor.toString(format);\n            }\n\n            // Update the text entry input as it changes happen\n            if (opts.showInput) {\n                textInput.val(displayColor);\n            }\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            drawInitial();\n        }\n\n        function updateHelperLocations() {\n            var s = currentSaturation;\n            var v = currentValue;\n\n            if(allowEmpty && isEmpty) {\n                //if selected color is empty, hide the helpers\n                alphaSlideHelper.hide();\n                slideHelper.hide();\n                dragHelper.hide();\n            }\n            else {\n                //make sure helpers are visible\n                alphaSlideHelper.show();\n                slideHelper.show();\n                dragHelper.show();\n\n                // Where to show the little circle in that displays your current selected color\n                var dragX = s * dragWidth;\n                var dragY = dragHeight - (v * dragHeight);\n                dragX = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragWidth - dragHelperHeight, dragX - dragHelperHeight)\n                );\n                dragY = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragHeight - dragHelperHeight, dragY - dragHelperHeight)\n                );\n                dragHelper.css({\n                    \"top\": dragY + \"px\",\n                    \"left\": dragX + \"px\"\n                });\n\n                var alphaX = currentAlpha * alphaWidth;\n                alphaSlideHelper.css({\n                    \"left\": (alphaX - (alphaSlideHelperWidth / 2)) + \"px\"\n                });\n\n                // Where to show the bar that displays your current selected hue\n                var slideY = (currentHue) * slideHeight;\n                slideHelper.css({\n                    \"top\": (slideY - slideHelperHeight) + \"px\"\n                });\n            }\n        }\n\n        function updateOriginalInput(fireCallback) {\n            var color = get(),\n                displayColor = '',\n                hasChanged = !tinycolor.equals(color, colorOnShow);\n\n            if (color) {\n                displayColor = color.toString(currentPreferredFormat);\n                // Update the selection palette with the current color\n                addColorToSelectionPalette(color);\n            }\n\n            if (isInput) {\n                boundElement.val(displayColor);\n            }\n\n            if (fireCallback && hasChanged) {\n                callbacks.change(color);\n                boundElement.trigger('change', [ color ]);\n            }\n        }\n\n        function reflow() {\n            if (!visible) {\n                return; // Calculations would be useless and wouldn't be reliable anyways\n            }\n            dragWidth = dragger.width();\n            dragHeight = dragger.height();\n            dragHelperHeight = dragHelper.height();\n            slideWidth = slider.width();\n            slideHeight = slider.height();\n            slideHelperHeight = slideHelper.height();\n            alphaWidth = alphaSlider.width();\n            alphaSlideHelperWidth = alphaSlideHelper.width();\n\n            if (!flat) {\n                container.css(\"position\", \"absolute\");\n                if (opts.offset) {\n                    container.offset(opts.offset);\n                } else {\n                    container.offset(getOffset(container, offsetElement));\n                }\n            }\n\n            updateHelperLocations();\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            boundElement.trigger('reflow.spectrum');\n        }\n\n        function destroy() {\n            boundElement.show();\n            offsetElement.off(\"click.spectrum touchstart.spectrum\");\n            container.remove();\n            replacer.remove();\n            spectrums[spect.id] = null;\n        }\n\n        function option(optionName, optionValue) {\n            if (optionName === undefined) {\n                return $.extend({}, opts);\n            }\n            if (optionValue === undefined) {\n                return opts[optionName];\n            }\n\n            opts[optionName] = optionValue;\n\n            if (optionName === \"preferredFormat\") {\n                currentPreferredFormat = opts.preferredFormat;\n            }\n            applyOptions();\n        }\n\n        function enable() {\n            disabled = false;\n            boundElement.attr(\"disabled\", false);\n            offsetElement.removeClass(\"sp-disabled\");\n        }\n\n        function disable() {\n            hide();\n            disabled = true;\n            boundElement.attr(\"disabled\", true);\n            offsetElement.addClass(\"sp-disabled\");\n        }\n\n        function setOffset(coord) {\n            opts.offset = coord;\n            reflow();\n        }\n\n        initialize();\n\n        var spect = {\n            show: show,\n            hide: hide,\n            toggle: toggle,\n            reflow: reflow,\n            option: option,\n            enable: enable,\n            disable: disable,\n            offset: setOffset,\n            set: function (c) {\n                set(c);\n                updateOriginalInput();\n            },\n            get: get,\n            destroy: destroy,\n            container: container\n        };\n\n        spect.id = spectrums.push(spect) - 1;\n\n        return spect;\n    }\n\n    /**\n     * checkOffset - get the offset below/above and left/right element depending on screen position\n     * Thanks https://github.com/jquery/jquery-ui/blob/master/ui/jquery.ui.datepicker.js\n     */\n    function getOffset(picker, input) {\n        var extraY = 0;\n        var dpWidth = picker.outerWidth();\n        var dpHeight = picker.outerHeight();\n        var inputHeight = input.outerHeight();\n        var doc = picker[0].ownerDocument;\n        var docElem = doc.documentElement;\n        var viewWidth = docElem.clientWidth + $(doc).scrollLeft();\n        var viewHeight = docElem.clientHeight + $(doc).scrollTop();\n        var offset = input.offset();\n        var offsetLeft = offset.left;\n        var offsetTop = offset.top;\n\n        offsetTop += inputHeight;\n\n        offsetLeft -=\n            Math.min(offsetLeft, (offsetLeft + dpWidth > viewWidth && viewWidth > dpWidth) ?\n                Math.abs(offsetLeft + dpWidth - viewWidth) : 0);\n\n        offsetTop -=\n            Math.min(offsetTop, ((offsetTop + dpHeight > viewHeight && viewHeight > dpHeight) ?\n                Math.abs(dpHeight + inputHeight - extraY) : extraY));\n\n        return {\n            top: offsetTop,\n            bottom: offset.bottom,\n            left: offsetLeft,\n            right: offset.right,\n            width: offset.width,\n            height: offset.height\n        };\n    }\n\n    /**\n     * noop - do nothing\n     */\n    function noop() {\n\n    }\n\n    /**\n     * stopPropagation - makes the code only doing this a little easier to read in line\n     */\n    function stopPropagation(e) {\n        e.stopPropagation();\n    }\n\n    /**\n     * Create a function bound to a given object\n     * Thanks to underscore.js\n     */\n    function bind(func, obj) {\n        var slice = Array.prototype.slice;\n        var args = slice.call(arguments, 2);\n        return function () {\n            return func.apply(obj, args.concat(slice.call(arguments)));\n        };\n    }\n\n    /**\n     * Lightweight drag helper.  Handles containment within the element, so that\n     * when dragging, the x is within [0,element.width] and y is within [0,element.height]\n     */\n    function draggable(element, onmove, onstart, onstop) {\n        onmove = onmove || function () { };\n        onstart = onstart || function () { };\n        onstop = onstop || function () { };\n        var doc = document;\n        var dragging = false;\n        var offset = {};\n        var maxHeight = 0;\n        var maxWidth = 0;\n        var hasTouch = ('ontouchstart' in window);\n\n        var duringDragEvents = {};\n        duringDragEvents[\"selectstart\"] = prevent;\n        duringDragEvents[\"dragstart\"] = prevent;\n        duringDragEvents[\"touchmove mousemove\"] = move;\n        duringDragEvents[\"touchend mouseup\"] = stop;\n\n        function prevent(e) {\n            if (e.stopPropagation) {\n                e.stopPropagation();\n            }\n            if (e.preventDefault) {\n                e.preventDefault();\n            }\n            e.returnValue = false;\n        }\n\n        function move(e) {\n            if (dragging) {\n                // Mouseup happened outside of window\n                if (IE && doc.documentMode < 9 && !e.button) {\n                    return stop();\n                }\n\n                var t0 = e.originalEvent && e.originalEvent.touches && e.originalEvent.touches[0];\n                var pageX = t0 && t0.pageX || e.pageX;\n                var pageY = t0 && t0.pageY || e.pageY;\n\n                var dragX = Math.max(0, Math.min(pageX - offset.left, maxWidth));\n                var dragY = Math.max(0, Math.min(pageY - offset.top, maxHeight));\n\n                if (hasTouch) {\n                    // Stop scrolling in iOS\n                    prevent(e);\n                }\n\n                onmove.apply(element, [dragX, dragY, e]);\n            }\n        }\n\n        function start(e) {\n            var rightclick = (e.which) ? (e.which == 3) : (e.button == 2);\n\n            if (!rightclick && !dragging) {\n                if (onstart.apply(element, arguments) !== false) {\n                    dragging = true;\n                    maxHeight = $(element).height();\n                    maxWidth = $(element).width();\n                    offset = $(element).offset();\n\n                    $(doc).on(duringDragEvents);\n                    $(doc.body).addClass(\"sp-dragging\");\n\n                    move(e);\n\n                    prevent(e);\n                }\n            }\n        }\n\n        function stop() {\n            if (dragging) {\n                $(doc).off(duringDragEvents);\n                $(doc.body).removeClass(\"sp-dragging\");\n\n                // Wait a tick before notifying observers to allow the click event\n                // to fire in Chrome.\n                setTimeout(function() {\n                    onstop.apply(element, arguments);\n                }, 0);\n            }\n            dragging = false;\n        }\n\n        $(element).on(\"touchstart mousedown\", start);\n    }\n\n    function throttle(func, wait, debounce) {\n        var timeout;\n        return function () {\n            var context = this, args = arguments;\n            var throttler = function () {\n                timeout = null;\n                func.apply(context, args);\n            };\n            if (debounce) clearTimeout(timeout);\n            if (debounce || !timeout) timeout = setTimeout(throttler, wait);\n        };\n    }\n\n    function inputTypeColorSupport() {\n        return $.fn.spectrum.inputTypeColorSupport();\n    }\n\n    /**\n     * Define a jQuery plugin\n     */\n    var dataID = \"spectrum.id\";\n    $.fn.spectrum = function (opts, extra) {\n\n        if (typeof opts == \"string\") {\n\n            var returnValue = this;\n            var args = Array.prototype.slice.call( arguments, 1 );\n\n            this.each(function () {\n                var spect = spectrums[$(this).data(dataID)];\n                if (spect) {\n                    var method = spect[opts];\n                    if (!method) {\n                        throw new Error( \"Spectrum: no such method: '\" + opts + \"'\" );\n                    }\n\n                    if (opts == \"get\") {\n                        returnValue = spect.get();\n                    }\n                    else if (opts == \"container\") {\n                        returnValue = spect.container;\n                    }\n                    else if (opts == \"option\") {\n                        returnValue = spect.option.apply(spect, args);\n                    }\n                    else if (opts == \"destroy\") {\n                        spect.destroy();\n                        $(this).removeData(dataID);\n                    }\n                    else {\n                        method.apply(spect, args);\n                    }\n                }\n            });\n\n            return returnValue;\n        }\n\n        // Initializing a new instance of spectrum\n        return this.spectrum(\"destroy\").each(function () {\n            var options = $.extend({}, $(this).data(), opts);\n            var spect = spectrum(this, options);\n            $(this).data(dataID, spect.id);\n        });\n    };\n\n    $.fn.spectrum.load = true;\n    $.fn.spectrum.loadOpts = {};\n    $.fn.spectrum.draggable = draggable;\n    $.fn.spectrum.defaults = defaultOpts;\n    $.fn.spectrum.inputTypeColorSupport = function inputTypeColorSupport() {\n        if (typeof inputTypeColorSupport._cachedResult === \"undefined\") {\n            var colorInput = $(\"<input type='color'/>\")[0]; // if color element is supported, value will default to not null\n            inputTypeColorSupport._cachedResult = colorInput.type === \"color\" && colorInput.value !== \"\";\n        }\n        return inputTypeColorSupport._cachedResult;\n    };\n\n    $.spectrum = { };\n    $.spectrum.localization = { };\n    $.spectrum.palettes = { };\n\n    $.fn.spectrum.processNativeColorInputs = function () {\n        var colorInputs = $(\"input[type=color]\");\n        if (colorInputs.length && !inputTypeColorSupport()) {\n            colorInputs.spectrum({\n                preferredFormat: \"hex6\"\n            });\n        }\n    };\n\n    // TinyColor v1.1.2\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    (function() {\n\n        var trimLeft = /^[\\s,#]+/,\n            trimRight = /\\s+$/,\n            tinyCounter = 0,\n            math = Math,\n            mathRound = math.round,\n            mathMin = math.min,\n            mathMax = math.max,\n            mathRandom = math.random;\n\n        var tinycolor = function(color, opts) {\n\n            color = (color) ? color : '';\n            opts = opts || { };\n\n            // If input is already a tinycolor, return itself\n            if (color instanceof tinycolor) {\n                return color;\n            }\n            // If we are called as a function, call using new instead\n            if (!(this instanceof tinycolor)) {\n                return new tinycolor(color, opts);\n            }\n\n            var rgb = inputToRGB(color);\n            this._originalInput = color;\n            this._r = rgb.r;\n            this._g = rgb.g;\n            this._b = rgb.b;\n            this._a = rgb.a;\n            this._roundA = mathRound(1000 * this._a) / 1000;\n            this._format = opts.format || rgb.format;\n            this._gradientType = opts.gradientType;\n\n            // Don't let the range of [0,255] come back in [0,1].\n            // Potentially lose a little bit of precision here, but will fix issues where\n            // .5 gets interpreted as half of the total, instead of half of 1\n            // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n            if (this._r < 1) { this._r = mathRound(this._r); }\n            if (this._g < 1) { this._g = mathRound(this._g); }\n            if (this._b < 1) { this._b = mathRound(this._b); }\n\n            this._ok = rgb.ok;\n            this._tc_id = tinyCounter++;\n        };\n\n        tinycolor.prototype = {\n            isDark: function() {\n                return this.getBrightness() < 128;\n            },\n            isLight: function() {\n                return !this.isDark();\n            },\n            isValid: function() {\n                return this._ok;\n            },\n            getOriginalInput: function() {\n                return this._originalInput;\n            },\n            getFormat: function() {\n                return this._format;\n            },\n            getAlpha: function() {\n                return this._a;\n            },\n            getBrightness: function() {\n                var rgb = this.toRgb();\n                return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n            },\n            setAlpha: function(value) {\n                this._a = boundAlpha(value);\n                this._roundA = mathRound(1000 * this._a) / 1000;\n                return this;\n            },\n            toHsv: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n            },\n            toHsvString: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n                return (this._a == 1) ?\n                    \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                    \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n            },\n            toHsl: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n            },\n            toHslString: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n                return (this._a == 1) ?\n                    \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                    \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n            },\n            toHex: function(allow3Char) {\n                return rgbToHex(this._r, this._g, this._b, allow3Char);\n            },\n            toHexString: function(allow3Char) {\n                return '#' + this.toHex(allow3Char);\n            },\n            toHex8: function() {\n                return rgbaToHex(this._r, this._g, this._b, this._a);\n            },\n            toHex8String: function() {\n                return '#' + this.toHex8();\n            },\n            toRgb: function() {\n                return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n            },\n            toRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                    \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n            },\n            toPercentageRgb: function() {\n                return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n            },\n            toPercentageRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                    \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n            },\n            toName: function() {\n                if (this._a === 0) {\n                    return \"transparent\";\n                }\n\n                if (this._a < 1) {\n                    return false;\n                }\n\n                return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n            },\n            toFilter: function(secondColor) {\n                var hex8String = '#' + rgbaToHex(this._r, this._g, this._b, this._a);\n                var secondHex8String = hex8String;\n                var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n                if (secondColor) {\n                    var s = tinycolor(secondColor);\n                    secondHex8String = s.toHex8String();\n                }\n\n                return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n            },\n            toString: function(format) {\n                var formatSet = !!format;\n                format = format || this._format;\n\n                var formattedString = false;\n                var hasAlpha = this._a < 1 && this._a >= 0;\n                var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"name\");\n\n                if (needsAlphaFormat) {\n                    // Special case for \"transparent\", all other non-alpha formats\n                    // will return rgba when there is transparency.\n                    if (format === \"name\" && this._a === 0) {\n                        return this.toName();\n                    }\n                    return this.toRgbString();\n                }\n                if (format === \"rgb\") {\n                    formattedString = this.toRgbString();\n                }\n                if (format === \"prgb\") {\n                    formattedString = this.toPercentageRgbString();\n                }\n                if (format === \"hex\" || format === \"hex6\") {\n                    formattedString = this.toHexString();\n                }\n                if (format === \"hex3\") {\n                    formattedString = this.toHexString(true);\n                }\n                if (format === \"hex8\") {\n                    formattedString = this.toHex8String();\n                }\n                if (format === \"name\") {\n                    formattedString = this.toName();\n                }\n                if (format === \"hsl\") {\n                    formattedString = this.toHslString();\n                }\n                if (format === \"hsv\") {\n                    formattedString = this.toHsvString();\n                }\n\n                return formattedString || this.toHexString();\n            },\n\n            _applyModification: function(fn, args) {\n                var color = fn.apply(null, [this].concat([].slice.call(args)));\n                this._r = color._r;\n                this._g = color._g;\n                this._b = color._b;\n                this.setAlpha(color._a);\n                return this;\n            },\n            lighten: function() {\n                return this._applyModification(lighten, arguments);\n            },\n            brighten: function() {\n                return this._applyModification(brighten, arguments);\n            },\n            darken: function() {\n                return this._applyModification(darken, arguments);\n            },\n            desaturate: function() {\n                return this._applyModification(desaturate, arguments);\n            },\n            saturate: function() {\n                return this._applyModification(saturate, arguments);\n            },\n            greyscale: function() {\n                return this._applyModification(greyscale, arguments);\n            },\n            spin: function() {\n                return this._applyModification(spin, arguments);\n            },\n\n            _applyCombination: function(fn, args) {\n                return fn.apply(null, [this].concat([].slice.call(args)));\n            },\n            analogous: function() {\n                return this._applyCombination(analogous, arguments);\n            },\n            complement: function() {\n                return this._applyCombination(complement, arguments);\n            },\n            monochromatic: function() {\n                return this._applyCombination(monochromatic, arguments);\n            },\n            splitcomplement: function() {\n                return this._applyCombination(splitcomplement, arguments);\n            },\n            triad: function() {\n                return this._applyCombination(triad, arguments);\n            },\n            tetrad: function() {\n                return this._applyCombination(tetrad, arguments);\n            }\n        };\n\n        // If input is an object, force 1 into \"1.0\" to handle ratios properly\n        // String input requires \"1.0\" as input, so 1 will be treated as 1\n        tinycolor.fromRatio = function(color, opts) {\n            if (typeof color == \"object\") {\n                var newColor = {};\n                for (var i in color) {\n                    if (color.hasOwnProperty(i)) {\n                        if (i === \"a\") {\n                            newColor[i] = color[i];\n                        }\n                        else {\n                            newColor[i] = convertToPercentage(color[i]);\n                        }\n                    }\n                }\n                color = newColor;\n            }\n\n            return tinycolor(color, opts);\n        };\n\n        // Given a string or object, convert that input to RGB\n        // Possible string inputs:\n        //\n        //     \"red\"\n        //     \"#f00\" or \"f00\"\n        //     \"#ff0000\" or \"ff0000\"\n        //     \"#ff000000\" or \"ff000000\"\n        //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n        //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n        //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n        //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n        //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n        //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n        //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n        //\n        function inputToRGB(color) {\n\n            var rgb = { r: 0, g: 0, b: 0 };\n            var a = 1;\n            var ok = false;\n            var format = false;\n\n            if (typeof color == \"string\") {\n                color = stringInputToObject(color);\n            }\n\n            if (typeof color == \"object\") {\n                if (color.hasOwnProperty(\"r\") && color.hasOwnProperty(\"g\") && color.hasOwnProperty(\"b\")) {\n                    rgb = rgbToRgb(color.r, color.g, color.b);\n                    ok = true;\n                    format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"v\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.v = convertToPercentage(color.v);\n                    rgb = hsvToRgb(color.h, color.s, color.v);\n                    ok = true;\n                    format = \"hsv\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"l\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.l = convertToPercentage(color.l);\n                    rgb = hslToRgb(color.h, color.s, color.l);\n                    ok = true;\n                    format = \"hsl\";\n                }\n\n                if (color.hasOwnProperty(\"a\")) {\n                    a = color.a;\n                }\n            }\n\n            a = boundAlpha(a);\n\n            return {\n                ok: ok,\n                format: color.format || format,\n                r: mathMin(255, mathMax(rgb.r, 0)),\n                g: mathMin(255, mathMax(rgb.g, 0)),\n                b: mathMin(255, mathMax(rgb.b, 0)),\n                a: a\n            };\n        }\n\n\n        // Conversion Functions\n        // --------------------\n\n        // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n        // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n        // `rgbToRgb`\n        // Handle bounds / percentage checking to conform to CSS color spec\n        // <http://www.w3.org/TR/css3-color/>\n        // *Assumes:* r, g, b in [0, 255] or [0, 1]\n        // *Returns:* { r, g, b } in [0, 255]\n        function rgbToRgb(r, g, b){\n            return {\n                r: bound01(r, 255) * 255,\n                g: bound01(g, 255) * 255,\n                b: bound01(b, 255) * 255\n            };\n        }\n\n        // `rgbToHsl`\n        // Converts an RGB color value to HSL.\n        // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n        // *Returns:* { h, s, l } in [0,1]\n        function rgbToHsl(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, l = (max + min) / 2;\n\n            if(max == min) {\n                h = s = 0; // achromatic\n            }\n            else {\n                var d = max - min;\n                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n\n                h /= 6;\n            }\n\n            return { h: h, s: s, l: l };\n        }\n\n        // `hslToRgb`\n        // Converts an HSL color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hslToRgb(h, s, l) {\n            var r, g, b;\n\n            h = bound01(h, 360);\n            s = bound01(s, 100);\n            l = bound01(l, 100);\n\n            function hue2rgb(p, q, t) {\n                if(t < 0) t += 1;\n                if(t > 1) t -= 1;\n                if(t < 1/6) return p + (q - p) * 6 * t;\n                if(t < 1/2) return q;\n                if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n                return p;\n            }\n\n            if(s === 0) {\n                r = g = b = l; // achromatic\n            }\n            else {\n                var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n                var p = 2 * l - q;\n                r = hue2rgb(p, q, h + 1/3);\n                g = hue2rgb(p, q, h);\n                b = hue2rgb(p, q, h - 1/3);\n            }\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHsv`\n        // Converts an RGB color value to HSV\n        // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n        // *Returns:* { h, s, v } in [0,1]\n        function rgbToHsv(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, v = max;\n\n            var d = max - min;\n            s = max === 0 ? 0 : d / max;\n\n            if(max == min) {\n                h = 0; // achromatic\n            }\n            else {\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n                h /= 6;\n            }\n            return { h: h, s: s, v: v };\n        }\n\n        // `hsvToRgb`\n        // Converts an HSV color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hsvToRgb(h, s, v) {\n\n            h = bound01(h, 360) * 6;\n            s = bound01(s, 100);\n            v = bound01(v, 100);\n\n            var i = math.floor(h),\n                f = h - i,\n                p = v * (1 - s),\n                q = v * (1 - f * s),\n                t = v * (1 - (1 - f) * s),\n                mod = i % 6,\n                r = [v, q, p, p, t, v][mod],\n                g = [t, v, v, q, p, p][mod],\n                b = [p, p, t, v, v, q][mod];\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHex`\n        // Converts an RGB color to hex\n        // Assumes r, g, and b are contained in the set [0, 255]\n        // Returns a 3 or 6 character hex\n        function rgbToHex(r, g, b, allow3Char) {\n\n            var hex = [\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            // Return a 3 character hex if possible\n            if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n                return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n            }\n\n            return hex.join(\"\");\n        }\n        // `rgbaToHex`\n        // Converts an RGBA color plus alpha transparency to hex\n        // Assumes r, g, b and a are contained in the set [0, 255]\n        // Returns an 8 character hex\n        function rgbaToHex(r, g, b, a) {\n\n            var hex = [\n                pad2(convertDecimalToHex(a)),\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            return hex.join(\"\");\n        }\n\n        // `equals`\n        // Can be called with any tinycolor input\n        tinycolor.equals = function (color1, color2) {\n            if (!color1 || !color2) { return false; }\n            return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n        };\n        tinycolor.random = function() {\n            return tinycolor.fromRatio({\n                r: mathRandom(),\n                g: mathRandom(),\n                b: mathRandom()\n            });\n        };\n\n\n        // Modification Functions\n        // ----------------------\n        // Thanks to less.js for some of the basics here\n        // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n        function desaturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s -= amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function saturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s += amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function greyscale(color) {\n            return tinycolor(color).desaturate(100);\n        }\n\n        function lighten (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l += amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        function brighten(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var rgb = tinycolor(color).toRgb();\n            rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n            rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n            rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n            return tinycolor(rgb);\n        }\n\n        function darken (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l -= amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n        // Values outside of this range will be wrapped into this range.\n        function spin(color, amount) {\n            var hsl = tinycolor(color).toHsl();\n            var hue = (mathRound(hsl.h) + amount) % 360;\n            hsl.h = hue < 0 ? 360 + hue : hue;\n            return tinycolor(hsl);\n        }\n\n        // Combination Functions\n        // ---------------------\n        // Thanks to jQuery xColor for some of the ideas behind these\n        // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n        function complement(color) {\n            var hsl = tinycolor(color).toHsl();\n            hsl.h = (hsl.h + 180) % 360;\n            return tinycolor(hsl);\n        }\n\n        function triad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function tetrad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function splitcomplement(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n                tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n            ];\n        }\n\n        function analogous(color, results, slices) {\n            results = results || 6;\n            slices = slices || 30;\n\n            var hsl = tinycolor(color).toHsl();\n            var part = 360 / slices;\n            var ret = [tinycolor(color)];\n\n            for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n                hsl.h = (hsl.h + part) % 360;\n                ret.push(tinycolor(hsl));\n            }\n            return ret;\n        }\n\n        function monochromatic(color, results) {\n            results = results || 6;\n            var hsv = tinycolor(color).toHsv();\n            var h = hsv.h, s = hsv.s, v = hsv.v;\n            var ret = [];\n            var modification = 1 / results;\n\n            while (results--) {\n                ret.push(tinycolor({ h: h, s: s, v: v}));\n                v = (v + modification) % 1;\n            }\n\n            return ret;\n        }\n\n        // Utility Functions\n        // ---------------------\n\n        tinycolor.mix = function(color1, color2, amount) {\n            amount = (amount === 0) ? 0 : (amount || 50);\n\n            var rgb1 = tinycolor(color1).toRgb();\n            var rgb2 = tinycolor(color2).toRgb();\n\n            var p = amount / 100;\n            var w = p * 2 - 1;\n            var a = rgb2.a - rgb1.a;\n\n            var w1;\n\n            if (w * a == -1) {\n                w1 = w;\n            } else {\n                w1 = (w + a) / (1 + w * a);\n            }\n\n            w1 = (w1 + 1) / 2;\n\n            var w2 = 1 - w1;\n\n            var rgba = {\n                r: rgb2.r * w1 + rgb1.r * w2,\n                g: rgb2.g * w1 + rgb1.g * w2,\n                b: rgb2.b * w1 + rgb1.b * w2,\n                a: rgb2.a * p  + rgb1.a * (1 - p)\n            };\n\n            return tinycolor(rgba);\n        };\n\n\n        // Readability Functions\n        // ---------------------\n        // <http://www.w3.org/TR/AERT#color-contrast>\n\n        // `readability`\n        // Analyze the 2 colors and returns an object with the following properties:\n        //    `brightness`: difference in brightness between the two colors\n        //    `color`: difference in color/hue between the two colors\n        tinycolor.readability = function(color1, color2) {\n            var c1 = tinycolor(color1);\n            var c2 = tinycolor(color2);\n            var rgb1 = c1.toRgb();\n            var rgb2 = c2.toRgb();\n            var brightnessA = c1.getBrightness();\n            var brightnessB = c2.getBrightness();\n            var colorDiff = (\n                Math.max(rgb1.r, rgb2.r) - Math.min(rgb1.r, rgb2.r) +\n                Math.max(rgb1.g, rgb2.g) - Math.min(rgb1.g, rgb2.g) +\n                Math.max(rgb1.b, rgb2.b) - Math.min(rgb1.b, rgb2.b)\n            );\n\n            return {\n                brightness: Math.abs(brightnessA - brightnessB),\n                color: colorDiff\n            };\n        };\n\n        // `readable`\n        // http://www.w3.org/TR/AERT#color-contrast\n        // Ensure that foreground and background color combinations provide sufficient contrast.\n        // *Example*\n        //    tinycolor.isReadable(\"#000\", \"#111\") => false\n        tinycolor.isReadable = function(color1, color2) {\n            var readability = tinycolor.readability(color1, color2);\n            return readability.brightness > 125 && readability.color > 500;\n        };\n\n        // `mostReadable`\n        // Given a base color and a list of possible foreground or background\n        // colors for that base, returns the most readable color.\n        // *Example*\n        //    tinycolor.mostReadable(\"#123\", [\"#fff\", \"#000\"]) => \"#000\"\n        tinycolor.mostReadable = function(baseColor, colorList) {\n            var bestColor = null;\n            var bestScore = 0;\n            var bestIsReadable = false;\n            for (var i=0; i < colorList.length; i++) {\n\n                // We normalize both around the \"acceptable\" breaking point,\n                // but rank brightness constrast higher than hue.\n\n                var readability = tinycolor.readability(baseColor, colorList[i]);\n                var readable = readability.brightness > 125 && readability.color > 500;\n                var score = 3 * (readability.brightness / 125) + (readability.color / 500);\n\n                if ((readable && ! bestIsReadable) ||\n                    (readable && bestIsReadable && score > bestScore) ||\n                    ((! readable) && (! bestIsReadable) && score > bestScore)) {\n                    bestIsReadable = readable;\n                    bestScore = score;\n                    bestColor = tinycolor(colorList[i]);\n                }\n            }\n            return bestColor;\n        };\n\n\n        // Big List of Colors\n        // ------------------\n        // <http://www.w3.org/TR/css3-color/#svg-color>\n        var names = tinycolor.names = {\n            aliceblue: \"f0f8ff\",\n            antiquewhite: \"faebd7\",\n            aqua: \"0ff\",\n            aquamarine: \"7fffd4\",\n            azure: \"f0ffff\",\n            beige: \"f5f5dc\",\n            bisque: \"ffe4c4\",\n            black: \"000\",\n            blanchedalmond: \"ffebcd\",\n            blue: \"00f\",\n            blueviolet: \"8a2be2\",\n            brown: \"a52a2a\",\n            burlywood: \"deb887\",\n            burntsienna: \"ea7e5d\",\n            cadetblue: \"5f9ea0\",\n            chartreuse: \"7fff00\",\n            chocolate: \"d2691e\",\n            coral: \"ff7f50\",\n            cornflowerblue: \"6495ed\",\n            cornsilk: \"fff8dc\",\n            crimson: \"dc143c\",\n            cyan: \"0ff\",\n            darkblue: \"00008b\",\n            darkcyan: \"008b8b\",\n            darkgoldenrod: \"b8860b\",\n            darkgray: \"a9a9a9\",\n            darkgreen: \"006400\",\n            darkgrey: \"a9a9a9\",\n            darkkhaki: \"bdb76b\",\n            darkmagenta: \"8b008b\",\n            darkolivegreen: \"556b2f\",\n            darkorange: \"ff8c00\",\n            darkorchid: \"9932cc\",\n            darkred: \"8b0000\",\n            darksalmon: \"e9967a\",\n            darkseagreen: \"8fbc8f\",\n            darkslateblue: \"483d8b\",\n            darkslategray: \"2f4f4f\",\n            darkslategrey: \"2f4f4f\",\n            darkturquoise: \"00ced1\",\n            darkviolet: \"9400d3\",\n            deeppink: \"ff1493\",\n            deepskyblue: \"00bfff\",\n            dimgray: \"696969\",\n            dimgrey: \"696969\",\n            dodgerblue: \"1e90ff\",\n            firebrick: \"b22222\",\n            floralwhite: \"fffaf0\",\n            forestgreen: \"228b22\",\n            fuchsia: \"f0f\",\n            gainsboro: \"dcdcdc\",\n            ghostwhite: \"f8f8ff\",\n            gold: \"ffd700\",\n            goldenrod: \"daa520\",\n            gray: \"808080\",\n            green: \"008000\",\n            greenyellow: \"adff2f\",\n            grey: \"808080\",\n            honeydew: \"f0fff0\",\n            hotpink: \"ff69b4\",\n            indianred: \"cd5c5c\",\n            indigo: \"4b0082\",\n            ivory: \"fffff0\",\n            khaki: \"f0e68c\",\n            lavender: \"e6e6fa\",\n            lavenderblush: \"fff0f5\",\n            lawngreen: \"7cfc00\",\n            lemonchiffon: \"fffacd\",\n            lightblue: \"add8e6\",\n            lightcoral: \"f08080\",\n            lightcyan: \"e0ffff\",\n            lightgoldenrodyellow: \"fafad2\",\n            lightgray: \"d3d3d3\",\n            lightgreen: \"90ee90\",\n            lightgrey: \"d3d3d3\",\n            lightpink: \"ffb6c1\",\n            lightsalmon: \"ffa07a\",\n            lightseagreen: \"20b2aa\",\n            lightskyblue: \"87cefa\",\n            lightslategray: \"789\",\n            lightslategrey: \"789\",\n            lightsteelblue: \"b0c4de\",\n            lightyellow: \"ffffe0\",\n            lime: \"0f0\",\n            limegreen: \"32cd32\",\n            linen: \"faf0e6\",\n            magenta: \"f0f\",\n            maroon: \"800000\",\n            mediumaquamarine: \"66cdaa\",\n            mediumblue: \"0000cd\",\n            mediumorchid: \"ba55d3\",\n            mediumpurple: \"9370db\",\n            mediumseagreen: \"3cb371\",\n            mediumslateblue: \"7b68ee\",\n            mediumspringgreen: \"00fa9a\",\n            mediumturquoise: \"48d1cc\",\n            mediumvioletred: \"c71585\",\n            midnightblue: \"191970\",\n            mintcream: \"f5fffa\",\n            mistyrose: \"ffe4e1\",\n            moccasin: \"ffe4b5\",\n            navajowhite: \"ffdead\",\n            navy: \"000080\",\n            oldlace: \"fdf5e6\",\n            olive: \"808000\",\n            olivedrab: \"6b8e23\",\n            orange: \"ffa500\",\n            orangered: \"ff4500\",\n            orchid: \"da70d6\",\n            palegoldenrod: \"eee8aa\",\n            palegreen: \"98fb98\",\n            paleturquoise: \"afeeee\",\n            palevioletred: \"db7093\",\n            papayawhip: \"ffefd5\",\n            peachpuff: \"ffdab9\",\n            peru: \"cd853f\",\n            pink: \"ffc0cb\",\n            plum: \"dda0dd\",\n            powderblue: \"b0e0e6\",\n            purple: \"800080\",\n            rebeccapurple: \"663399\",\n            red: \"f00\",\n            rosybrown: \"bc8f8f\",\n            royalblue: \"4169e1\",\n            saddlebrown: \"8b4513\",\n            salmon: \"fa8072\",\n            sandybrown: \"f4a460\",\n            seagreen: \"2e8b57\",\n            seashell: \"fff5ee\",\n            sienna: \"a0522d\",\n            silver: \"c0c0c0\",\n            skyblue: \"87ceeb\",\n            slateblue: \"6a5acd\",\n            slategray: \"708090\",\n            slategrey: \"708090\",\n            snow: \"fffafa\",\n            springgreen: \"00ff7f\",\n            steelblue: \"4682b4\",\n            tan: \"d2b48c\",\n            teal: \"008080\",\n            thistle: \"d8bfd8\",\n            tomato: \"ff6347\",\n            turquoise: \"40e0d0\",\n            violet: \"ee82ee\",\n            wheat: \"f5deb3\",\n            white: \"fff\",\n            whitesmoke: \"f5f5f5\",\n            yellow: \"ff0\",\n            yellowgreen: \"9acd32\"\n        };\n\n        // Make it easy to access colors via `hexNames[hex]`\n        var hexNames = tinycolor.hexNames = flip(names);\n\n\n        // Utilities\n        // ---------\n\n        // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n        function flip(o) {\n            var flipped = { };\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    flipped[o[i]] = i;\n                }\n            }\n            return flipped;\n        }\n\n        // Return a valid alpha value [0,1] with all invalid values being set to 1\n        function boundAlpha(a) {\n            a = parseFloat(a);\n\n            if (isNaN(a) || a < 0 || a > 1) {\n                a = 1;\n            }\n\n            return a;\n        }\n\n        // Take input from [0, n] and return it as [0, 1]\n        function bound01(n, max) {\n            if (isOnePointZero(n)) { n = \"100%\"; }\n\n            var processPercent = isPercentage(n);\n            n = mathMin(max, mathMax(0, parseFloat(n)));\n\n            // Automatically convert percentage into number\n            if (processPercent) {\n                n = parseInt(n * max, 10) / 100;\n            }\n\n            // Handle floating point rounding errors\n            if ((math.abs(n - max) < 0.000001)) {\n                return 1;\n            }\n\n            // Convert into [0, 1] range if it isn't already\n            return (n % max) / parseFloat(max);\n        }\n\n        // Force a number between 0 and 1\n        function clamp01(val) {\n            return mathMin(1, mathMax(0, val));\n        }\n\n        // Parse a base-16 hex value into a base-10 integer\n        function parseIntFromHex(val) {\n            return parseInt(val, 16);\n        }\n\n        // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n        // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n        function isOnePointZero(n) {\n            return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n        }\n\n        // Check to see if string passed in is a percentage\n        function isPercentage(n) {\n            return typeof n === \"string\" && n.indexOf('%') != -1;\n        }\n\n        // Force a hex value to have 2 characters\n        function pad2(c) {\n            return c.length == 1 ? '0' + c : '' + c;\n        }\n\n        // Replace a decimal with it's percentage value\n        function convertToPercentage(n) {\n            if (n <= 1) {\n                n = (n * 100) + \"%\";\n            }\n\n            return n;\n        }\n\n        // Converts a decimal to a hex value\n        function convertDecimalToHex(d) {\n            return Math.round(parseFloat(d) * 255).toString(16);\n        }\n        // Converts a hex value to a decimal\n        function convertHexToDecimal(h) {\n            return (parseIntFromHex(h) / 255);\n        }\n\n        var matchers = (function() {\n\n            // <http://www.w3.org/TR/css3-values/#integers>\n            var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n            // <http://www.w3.org/TR/css3-values/#number-value>\n            var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n            // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n            var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n            // Actual matching.\n            // Parentheses and commas are optional, but not required.\n            // Whitespace can take the place of commas or opening paren\n            var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n            var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n            return {\n                rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n                rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n                hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n                hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n                hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n                hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n                hex3: /^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n                hex6: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n                hex8: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n            };\n        })();\n\n        // `stringInputToObject`\n        // Permissive string parsing.  Take in a number of formats, and output an object\n        // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n        function stringInputToObject(color) {\n\n            color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n            var named = false;\n            if (names[color]) {\n                color = names[color];\n                named = true;\n            }\n            else if (color == 'transparent') {\n                return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n            }\n\n            // Try to match string input using regular expressions.\n            // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n            // Just return an object and let the conversion functions handle that.\n            // This way the result will be the same whether the tinycolor is initialized with string or object.\n            var match;\n            if ((match = matchers.rgb.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3] };\n            }\n            if ((match = matchers.rgba.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsl.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3] };\n            }\n            if ((match = matchers.hsla.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsv.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3] };\n            }\n            if ((match = matchers.hsva.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3], a: match[4] };\n            }\n            if ((match = matchers.hex8.exec(color))) {\n                return {\n                    a: convertHexToDecimal(match[1]),\n                    r: parseIntFromHex(match[2]),\n                    g: parseIntFromHex(match[3]),\n                    b: parseIntFromHex(match[4]),\n                    format: named ? \"name\" : \"hex8\"\n                };\n            }\n            if ((match = matchers.hex6.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1]),\n                    g: parseIntFromHex(match[2]),\n                    b: parseIntFromHex(match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n            if ((match = matchers.hex3.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1] + '' + match[1]),\n                    g: parseIntFromHex(match[2] + '' + match[2]),\n                    b: parseIntFromHex(match[3] + '' + match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n\n            return false;\n        }\n\n        window.tinycolor = tinycolor;\n    })();\n\n    $(function () {\n        if ($.fn.spectrum.load) {\n            $.fn.spectrum.processNativeColorInputs();\n        }\n    });\n\n});\n","jquery/fileUploader/jquery.fileupload-validate.js":"/*\n * jQuery File Upload Validation Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/jquery.fileupload-process'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'), require('jquery/fileUploader/jquery.fileupload-process'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  // Append to the default processQueue:\n  $.blueimp.fileupload.prototype.options.processQueue.push({\n    action: 'validate',\n    // Always trigger this action,\n    // even if the previous action was rejected:\n    always: true,\n    // Options taken from the global options map:\n    acceptFileTypes: '@',\n    maxFileSize: '@',\n    minFileSize: '@',\n    maxNumberOfFiles: '@',\n    disabled: '@disableValidation'\n  });\n\n  // The File Upload Validation plugin extends the fileupload widget\n  // with file validation functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      /*\n            // The regular expression for allowed file types, matches\n            // against either file type or file name:\n            acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n            // The maximum allowed file size in bytes:\n            maxFileSize: 10000000, // 10 MB\n            // The minimum allowed file size in bytes:\n            minFileSize: undefined, // No minimal file size\n            // The limit of files to be uploaded:\n            maxNumberOfFiles: 10,\n            */\n\n      // Function returning the current number of files,\n      // has to be overridden for maxNumberOfFiles validation:\n      getNumberOfFiles: $.noop,\n\n      // Error and info messages:\n      messages: {\n        maxNumberOfFiles: 'Maximum number of files exceeded',\n        acceptFileTypes: 'File type not allowed',\n        maxFileSize: 'File is too large',\n        minFileSize: 'File is too small'\n      }\n    },\n\n    processActions: {\n      validate: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        // eslint-disable-next-line new-cap\n        var dfd = $.Deferred(),\n          settings = this.options,\n          file = data.files[data.index],\n          fileSize;\n        if (options.minFileSize || options.maxFileSize) {\n          fileSize = file.size;\n        }\n        if (\n          $.type(options.maxNumberOfFiles) === 'number' &&\n          (settings.getNumberOfFiles() || 0) + data.files.length >\n            options.maxNumberOfFiles\n        ) {\n          file.error = settings.i18n('maxNumberOfFiles');\n        } else if (\n          options.acceptFileTypes &&\n          !(\n            options.acceptFileTypes.test(file.type) ||\n            options.acceptFileTypes.test(file.name)\n          )\n        ) {\n          file.error = settings.i18n('acceptFileTypes');\n        } else if (fileSize > options.maxFileSize) {\n          file.error = settings.i18n('maxFileSize');\n        } else if (\n          $.type(fileSize) === 'number' &&\n          fileSize < options.minFileSize\n        ) {\n          file.error = settings.i18n('minFileSize');\n        } else {\n          delete file.error;\n        }\n        if (file.error || data.files.error) {\n          data.files.error = true;\n          dfd.rejectWith(this, [data]);\n        } else {\n          dfd.resolveWith(this, [data]);\n        }\n        return dfd.promise();\n      }\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload.js":"/*\n * jQuery File Upload Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n/* eslint-disable new-cap */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/vendor/jquery.ui.widget'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'), require('jquery/fileUploader/vendor/jquery.ui.widget'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  // Detect file input support, based on\n  // https://viljamis.com/2012/file-upload-support-on-mobile/\n  $.support.fileInput = !(\n    new RegExp(\n      // Handle devices which give false positives for the feature detection:\n      '(Android (1\\\\.[0156]|2\\\\.[01]))' +\n        '|(Windows Phone (OS 7|8\\\\.0))|(XBLWP)|(ZuneWP)|(WPDesktop)' +\n        '|(w(eb)?OSBrowser)|(webOS)' +\n        '|(Kindle/(1\\\\.0|2\\\\.[05]|3\\\\.0))'\n    ).test(window.navigator.userAgent) ||\n    // Feature detection for all other devices:\n    $('<input type=\"file\"/>').prop('disabled')\n  );\n\n  // The FileReader API is not actually used, but works as feature detection,\n  // as some Safari versions (5?) support XHR file uploads via the FormData API,\n  // but not non-multipart XHR file uploads.\n  // window.XMLHttpRequestUpload is not available on IE10, so we check for\n  // window.ProgressEvent instead to detect XHR2 file upload capability:\n  $.support.xhrFileUpload = !!(window.ProgressEvent && window.FileReader);\n  $.support.xhrFormDataFileUpload = !!window.FormData;\n\n  // Detect support for Blob slicing (required for chunked uploads):\n  $.support.blobSlice =\n    window.Blob &&\n    (Blob.prototype.slice ||\n      Blob.prototype.webkitSlice ||\n      Blob.prototype.mozSlice);\n\n  /**\n   * Helper function to create drag handlers for dragover/dragenter/dragleave\n   *\n   * @param {string} type Event type\n   * @returns {Function} Drag handler\n   */\n  function getDragHandler(type) {\n    var isDragOver = type === 'dragover';\n    return function (e) {\n      e.dataTransfer = e.originalEvent && e.originalEvent.dataTransfer;\n      var dataTransfer = e.dataTransfer;\n      if (\n        dataTransfer &&\n        $.inArray('Files', dataTransfer.types) !== -1 &&\n        this._trigger(type, $.Event(type, { delegatedEvent: e })) !== false\n      ) {\n        e.preventDefault();\n        if (isDragOver) {\n          dataTransfer.dropEffect = 'copy';\n        }\n      }\n    };\n  }\n\n  // The fileupload widget listens for change events on file input fields defined\n  // via fileInput setting and paste or drop events of the given dropZone.\n  // In addition to the default jQuery Widget methods, the fileupload widget\n  // exposes the \"add\" and \"send\" methods, to add or directly send files using\n  // the fileupload API.\n  // By default, files added via file input selection, paste, drag & drop or\n  // \"add\" method are uploaded immediately, but it is possible to override\n  // the \"add\" callback option to queue file uploads.\n  $.widget('blueimp.fileupload', {\n    options: {\n      // The drop target element(s), by the default the complete document.\n      // Set to null to disable drag & drop support:\n      dropZone: $(document),\n      // The paste target element(s), by the default undefined.\n      // Set to a DOM node or jQuery object to enable file pasting:\n      pasteZone: undefined,\n      // The file input field(s), that are listened to for change events.\n      // If undefined, it is set to the file input fields inside\n      // of the widget element on plugin initialization.\n      // Set to null to disable the change listener.\n      fileInput: undefined,\n      // By default, the file input field is replaced with a clone after\n      // each input field change event. This is required for iframe transport\n      // queues and allows change events to be fired for the same file\n      // selection, but can be disabled by setting the following option to false:\n      replaceFileInput: true,\n      // The parameter name for the file form data (the request argument name).\n      // If undefined or empty, the name property of the file input field is\n      // used, or \"files[]\" if the file input name property is also empty,\n      // can be a string or an array of strings:\n      paramName: undefined,\n      // By default, each file of a selection is uploaded using an individual\n      // request for XHR type uploads. Set to false to upload file\n      // selections in one request each:\n      singleFileUploads: true,\n      // To limit the number of files uploaded with one XHR request,\n      // set the following option to an integer greater than 0:\n      limitMultiFileUploads: undefined,\n      // The following option limits the number of files uploaded with one\n      // XHR request to keep the request size under or equal to the defined\n      // limit in bytes:\n      limitMultiFileUploadSize: undefined,\n      // Multipart file uploads add a number of bytes to each uploaded file,\n      // therefore the following option adds an overhead for each file used\n      // in the limitMultiFileUploadSize configuration:\n      limitMultiFileUploadSizeOverhead: 512,\n      // Set the following option to true to issue all file upload requests\n      // in a sequential order:\n      sequentialUploads: false,\n      // To limit the number of concurrent uploads,\n      // set the following option to an integer greater than 0:\n      limitConcurrentUploads: undefined,\n      // Set the following option to true to force iframe transport uploads:\n      forceIframeTransport: false,\n      // Set the following option to the location of a redirect url on the\n      // origin server, for cross-domain iframe transport uploads:\n      redirect: undefined,\n      // The parameter name for the redirect url, sent as part of the form\n      // data and set to 'redirect' if this option is empty:\n      redirectParamName: undefined,\n      // Set the following option to the location of a postMessage window,\n      // to enable postMessage transport uploads:\n      postMessage: undefined,\n      // By default, XHR file uploads are sent as multipart/form-data.\n      // The iframe transport is always using multipart/form-data.\n      // Set to false to enable non-multipart XHR uploads:\n      multipart: true,\n      // To upload large files in smaller chunks, set the following option\n      // to a preferred maximum chunk size. If set to 0, null or undefined,\n      // or the browser does not support the required Blob API, files will\n      // be uploaded as a whole.\n      maxChunkSize: undefined,\n      // When a non-multipart upload or a chunked multipart upload has been\n      // aborted, this option can be used to resume the upload by setting\n      // it to the size of the already uploaded bytes. This option is most\n      // useful when modifying the options object inside of the \"add\" or\n      // \"send\" callbacks, as the options are cloned for each file upload.\n      uploadedBytes: undefined,\n      // By default, failed (abort or error) file uploads are removed from the\n      // global progress calculation. Set the following option to false to\n      // prevent recalculating the global progress data:\n      recalculateProgress: true,\n      // Interval in milliseconds to calculate and trigger progress events:\n      progressInterval: 100,\n      // Interval in milliseconds to calculate progress bitrate:\n      bitrateInterval: 500,\n      // By default, uploads are started automatically when adding files:\n      autoUpload: true,\n      // By default, duplicate file names are expected to be handled on\n      // the server-side. If this is not possible (e.g. when uploading\n      // files directly to Amazon S3), the following option can be set to\n      // an empty object or an object mapping existing filenames, e.g.:\n      // { \"image.jpg\": true, \"image (1).jpg\": true }\n      // If it is set, all files will be uploaded with unique filenames,\n      // adding increasing number suffixes if necessary, e.g.:\n      // \"image (2).jpg\"\n      uniqueFilenames: undefined,\n\n      // Error and info messages:\n      messages: {\n        uploadedBytes: 'Uploaded bytes exceed file size'\n      },\n\n      // Translation function, gets the message key to be translated\n      // and an object with context specific data as arguments:\n      i18n: function (message, context) {\n        // eslint-disable-next-line no-param-reassign\n        message = this.messages[message] || message.toString();\n        if (context) {\n          $.each(context, function (key, value) {\n            // eslint-disable-next-line no-param-reassign\n            message = message.replace('{' + key + '}', value);\n          });\n        }\n        return message;\n      },\n\n      // Additional form data to be sent along with the file uploads can be set\n      // using this option, which accepts an array of objects with name and\n      // value properties, a function returning such an array, a FormData\n      // object (for XHR file uploads), or a simple object.\n      // The form of the first fileInput is given as parameter to the function:\n      formData: function (form) {\n        return form.serializeArray();\n      },\n\n      // The add callback is invoked as soon as files are added to the fileupload\n      // widget (via file input selection, drag & drop, paste or add API call).\n      // If the singleFileUploads option is enabled, this callback will be\n      // called once for each file in the selection for XHR file uploads, else\n      // once for each file selection.\n      //\n      // The upload starts when the submit method is invoked on the data parameter.\n      // The data object contains a files property holding the added files\n      // and allows you to override plugin options as well as define ajax settings.\n      //\n      // Listeners for this callback can also be bound the following way:\n      // .on('fileuploadadd', func);\n      //\n      // data.submit() returns a Promise object and allows to attach additional\n      // handlers using jQuery's Deferred callbacks:\n      // data.submit().done(func).fail(func).always(func);\n      add: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        if (\n          data.autoUpload ||\n          (data.autoUpload !== false &&\n            $(this).fileupload('option', 'autoUpload'))\n        ) {\n          data.process().done(function () {\n            data.submit();\n          });\n        }\n      },\n\n      // Other callbacks:\n\n      // Callback for the submit event of each file upload:\n      // submit: function (e, data) {}, // .on('fileuploadsubmit', func);\n\n      // Callback for the start of each file upload request:\n      // send: function (e, data) {}, // .on('fileuploadsend', func);\n\n      // Callback for successful uploads:\n      // done: function (e, data) {}, // .on('fileuploaddone', func);\n\n      // Callback for failed (abort or error) uploads:\n      // fail: function (e, data) {}, // .on('fileuploadfail', func);\n\n      // Callback for completed (success, abort or error) requests:\n      // always: function (e, data) {}, // .on('fileuploadalways', func);\n\n      // Callback for upload progress events:\n      // progress: function (e, data) {}, // .on('fileuploadprogress', func);\n\n      // Callback for global upload progress events:\n      // progressall: function (e, data) {}, // .on('fileuploadprogressall', func);\n\n      // Callback for uploads start, equivalent to the global ajaxStart event:\n      // start: function (e) {}, // .on('fileuploadstart', func);\n\n      // Callback for uploads stop, equivalent to the global ajaxStop event:\n      // stop: function (e) {}, // .on('fileuploadstop', func);\n\n      // Callback for change events of the fileInput(s):\n      // change: function (e, data) {}, // .on('fileuploadchange', func);\n\n      // Callback for paste events to the pasteZone(s):\n      // paste: function (e, data) {}, // .on('fileuploadpaste', func);\n\n      // Callback for drop events of the dropZone(s):\n      // drop: function (e, data) {}, // .on('fileuploaddrop', func);\n\n      // Callback for dragover events of the dropZone(s):\n      // dragover: function (e) {}, // .on('fileuploaddragover', func);\n\n      // Callback before the start of each chunk upload request (before form data initialization):\n      // chunkbeforesend: function (e, data) {}, // .on('fileuploadchunkbeforesend', func);\n\n      // Callback for the start of each chunk upload request:\n      // chunksend: function (e, data) {}, // .on('fileuploadchunksend', func);\n\n      // Callback for successful chunk uploads:\n      // chunkdone: function (e, data) {}, // .on('fileuploadchunkdone', func);\n\n      // Callback for failed (abort or error) chunk uploads:\n      // chunkfail: function (e, data) {}, // .on('fileuploadchunkfail', func);\n\n      // Callback for completed (success, abort or error) chunk upload requests:\n      // chunkalways: function (e, data) {}, // .on('fileuploadchunkalways', func);\n\n      // The plugin options are used as settings object for the ajax calls.\n      // The following are jQuery ajax settings required for the file uploads:\n      processData: false,\n      contentType: false,\n      cache: false,\n      timeout: 0\n    },\n\n    // jQuery versions before 1.8 require promise.pipe if the return value is\n    // used, as promise.then in older versions has a different behavior, see:\n    // https://blog.jquery.com/2012/08/09/jquery-1-8-released/\n    // https://bugs.jquery.com/ticket/11010\n    // https://github.com/blueimp/jQuery-File-Upload/pull/3435\n    _promisePipe: (function () {\n      var parts = $.fn.jquery.split('.');\n      return Number(parts[0]) > 1 || Number(parts[1]) > 7 ? 'then' : 'pipe';\n    })(),\n\n    // A list of options that require reinitializing event listeners and/or\n    // special initialization code:\n    _specialOptions: [\n      'fileInput',\n      'dropZone',\n      'pasteZone',\n      'multipart',\n      'forceIframeTransport'\n    ],\n\n    _blobSlice:\n      $.support.blobSlice &&\n      function () {\n        var slice = this.slice || this.webkitSlice || this.mozSlice;\n        return slice.apply(this, arguments);\n      },\n\n    _BitrateTimer: function () {\n      this.timestamp = Date.now ? Date.now() : new Date().getTime();\n      this.loaded = 0;\n      this.bitrate = 0;\n      this.getBitrate = function (now, loaded, interval) {\n        var timeDiff = now - this.timestamp;\n        if (!this.bitrate || !interval || timeDiff > interval) {\n          this.bitrate = (loaded - this.loaded) * (1000 / timeDiff) * 8;\n          this.loaded = loaded;\n          this.timestamp = now;\n        }\n        return this.bitrate;\n      };\n    },\n\n    _isXHRUpload: function (options) {\n      return (\n        !options.forceIframeTransport &&\n        ((!options.multipart && $.support.xhrFileUpload) ||\n          $.support.xhrFormDataFileUpload)\n      );\n    },\n\n    _getFormData: function (options) {\n      var formData;\n      if ($.type(options.formData) === 'function') {\n        return options.formData(options.form);\n      }\n      if ($.isArray(options.formData)) {\n        return options.formData;\n      }\n      if ($.type(options.formData) === 'object') {\n        formData = [];\n        $.each(options.formData, function (name, value) {\n          formData.push({ name: name, value: value });\n        });\n        return formData;\n      }\n      return [];\n    },\n\n    _getTotal: function (files) {\n      var total = 0;\n      $.each(files, function (index, file) {\n        total += file.size || 1;\n      });\n      return total;\n    },\n\n    _initProgressObject: function (obj) {\n      var progress = {\n        loaded: 0,\n        total: 0,\n        bitrate: 0\n      };\n      if (obj._progress) {\n        $.extend(obj._progress, progress);\n      } else {\n        obj._progress = progress;\n      }\n    },\n\n    _initResponseObject: function (obj) {\n      var prop;\n      if (obj._response) {\n        for (prop in obj._response) {\n          if (Object.prototype.hasOwnProperty.call(obj._response, prop)) {\n            delete obj._response[prop];\n          }\n        }\n      } else {\n        obj._response = {};\n      }\n    },\n\n    _onProgress: function (e, data) {\n      if (e.lengthComputable) {\n        var now = Date.now ? Date.now() : new Date().getTime(),\n          loaded;\n        if (\n          data._time &&\n          data.progressInterval &&\n          now - data._time < data.progressInterval &&\n          e.loaded !== e.total\n        ) {\n          return;\n        }\n        data._time = now;\n        loaded =\n          Math.floor(\n            (e.loaded / e.total) * (data.chunkSize || data._progress.total)\n          ) + (data.uploadedBytes || 0);\n        // Add the difference from the previously loaded state\n        // to the global loaded counter:\n        this._progress.loaded += loaded - data._progress.loaded;\n        this._progress.bitrate = this._bitrateTimer.getBitrate(\n          now,\n          this._progress.loaded,\n          data.bitrateInterval\n        );\n        data._progress.loaded = data.loaded = loaded;\n        data._progress.bitrate = data.bitrate = data._bitrateTimer.getBitrate(\n          now,\n          loaded,\n          data.bitrateInterval\n        );\n        // Trigger a custom progress event with a total data property set\n        // to the file size(s) of the current upload and a loaded data\n        // property calculated accordingly:\n        this._trigger(\n          'progress',\n          $.Event('progress', { delegatedEvent: e }),\n          data\n        );\n        // Trigger a global progress event for all current file uploads,\n        // including ajax calls queued for sequential file uploads:\n        this._trigger(\n          'progressall',\n          $.Event('progressall', { delegatedEvent: e }),\n          this._progress\n        );\n      }\n    },\n\n    _initProgressListener: function (options) {\n      var that = this,\n        xhr = options.xhr ? options.xhr() : $.ajaxSettings.xhr();\n      // Accesss to the native XHR object is required to add event listeners\n      // for the upload progress event:\n      if (xhr.upload) {\n        $(xhr.upload).on('progress', function (e) {\n          var oe = e.originalEvent;\n          // Make sure the progress event properties get copied over:\n          e.lengthComputable = oe.lengthComputable;\n          e.loaded = oe.loaded;\n          e.total = oe.total;\n          that._onProgress(e, options);\n        });\n        options.xhr = function () {\n          return xhr;\n        };\n      }\n    },\n\n    _deinitProgressListener: function (options) {\n      var xhr = options.xhr ? options.xhr() : $.ajaxSettings.xhr();\n      if (xhr.upload) {\n        $(xhr.upload).off('progress');\n      }\n    },\n\n    _isInstanceOf: function (type, obj) {\n      // Cross-frame instanceof check\n      return Object.prototype.toString.call(obj) === '[object ' + type + ']';\n    },\n\n    _getUniqueFilename: function (name, map) {\n      // eslint-disable-next-line no-param-reassign\n      name = String(name);\n      if (map[name]) {\n        // eslint-disable-next-line no-param-reassign\n        name = name.replace(/(?: \\(([\\d]+)\\))?(\\.[^.]+)?$/, function (\n          _,\n          p1,\n          p2\n        ) {\n          var index = p1 ? Number(p1) + 1 : 1;\n          var ext = p2 || '';\n          return ' (' + index + ')' + ext;\n        });\n        return this._getUniqueFilename(name, map);\n      }\n      map[name] = true;\n      return name;\n    },\n\n    _initXHRData: function (options) {\n      var that = this,\n        formData,\n        file = options.files[0],\n        // Ignore non-multipart setting if not supported:\n        multipart = options.multipart || !$.support.xhrFileUpload,\n        paramName =\n          $.type(options.paramName) === 'array'\n            ? options.paramName[0]\n            : options.paramName;\n      options.headers = $.extend({}, options.headers);\n      if (options.contentRange) {\n        options.headers['Content-Range'] = options.contentRange;\n      }\n      if (!multipart || options.blob || !this._isInstanceOf('File', file)) {\n        options.headers['Content-Disposition'] =\n          'attachment; filename=\"' +\n          encodeURI(file.uploadName || file.name) +\n          '\"';\n      }\n      if (!multipart) {\n        options.contentType = file.type || 'application/octet-stream';\n        options.data = options.blob || file;\n      } else if ($.support.xhrFormDataFileUpload) {\n        if (options.postMessage) {\n          // window.postMessage does not allow sending FormData\n          // objects, so we just add the File/Blob objects to\n          // the formData array and let the postMessage window\n          // create the FormData object out of this array:\n          formData = this._getFormData(options);\n          if (options.blob) {\n            formData.push({\n              name: paramName,\n              value: options.blob\n            });\n          } else {\n            $.each(options.files, function (index, file) {\n              formData.push({\n                name:\n                  ($.type(options.paramName) === 'array' &&\n                    options.paramName[index]) ||\n                  paramName,\n                value: file\n              });\n            });\n          }\n        } else {\n          if (that._isInstanceOf('FormData', options.formData)) {\n            formData = options.formData;\n          } else {\n            formData = new FormData();\n            $.each(this._getFormData(options), function (index, field) {\n              formData.append(field.name, field.value);\n            });\n          }\n          if (options.blob) {\n            formData.append(\n              paramName,\n              options.blob,\n              file.uploadName || file.name\n            );\n          } else {\n            $.each(options.files, function (index, file) {\n              // This check allows the tests to run with\n              // dummy objects:\n              if (\n                that._isInstanceOf('File', file) ||\n                that._isInstanceOf('Blob', file)\n              ) {\n                var fileName = file.uploadName || file.name;\n                if (options.uniqueFilenames) {\n                  fileName = that._getUniqueFilename(\n                    fileName,\n                    options.uniqueFilenames\n                  );\n                }\n                formData.append(\n                  ($.type(options.paramName) === 'array' &&\n                    options.paramName[index]) ||\n                    paramName,\n                  file,\n                  fileName\n                );\n              }\n            });\n          }\n        }\n        options.data = formData;\n      }\n      // Blob reference is not needed anymore, free memory:\n      options.blob = null;\n    },\n\n    _initIframeSettings: function (options) {\n      var targetHost = $('<a></a>').prop('href', options.url).prop('host');\n      // Setting the dataType to iframe enables the iframe transport:\n      options.dataType = 'iframe ' + (options.dataType || '');\n      // The iframe transport accepts a serialized array as form data:\n      options.formData = this._getFormData(options);\n      // Add redirect url to form data on cross-domain uploads:\n      if (options.redirect && targetHost && targetHost !== location.host) {\n        options.formData.push({\n          name: options.redirectParamName || 'redirect',\n          value: options.redirect\n        });\n      }\n    },\n\n    _initDataSettings: function (options) {\n      if (this._isXHRUpload(options)) {\n        if (!this._chunkedUpload(options, true)) {\n          if (!options.data) {\n            this._initXHRData(options);\n          }\n          this._initProgressListener(options);\n        }\n        if (options.postMessage) {\n          // Setting the dataType to postmessage enables the\n          // postMessage transport:\n          options.dataType = 'postmessage ' + (options.dataType || '');\n        }\n      } else {\n        this._initIframeSettings(options);\n      }\n    },\n\n    _getParamName: function (options) {\n      var fileInput = $(options.fileInput),\n        paramName = options.paramName;\n      if (!paramName) {\n        paramName = [];\n        fileInput.each(function () {\n          var input = $(this),\n            name = input.prop('name') || 'files[]',\n            i = (input.prop('files') || [1]).length;\n          while (i) {\n            paramName.push(name);\n            i -= 1;\n          }\n        });\n        if (!paramName.length) {\n          paramName = [fileInput.prop('name') || 'files[]'];\n        }\n      } else if (!$.isArray(paramName)) {\n        paramName = [paramName];\n      }\n      return paramName;\n    },\n\n    _initFormSettings: function (options) {\n      // Retrieve missing options from the input field and the\n      // associated form, if available:\n      if (!options.form || !options.form.length) {\n        options.form = $(options.fileInput.prop('form'));\n        // If the given file input doesn't have an associated form,\n        // use the default widget file input's form:\n        if (!options.form.length) {\n          options.form = $(this.options.fileInput.prop('form'));\n        }\n      }\n      options.paramName = this._getParamName(options);\n      if (!options.url) {\n        options.url = options.form.prop('action') || location.href;\n      }\n      // The HTTP request method must be \"POST\" or \"PUT\":\n      options.type = (\n        options.type ||\n        ($.type(options.form.prop('method')) === 'string' &&\n          options.form.prop('method')) ||\n        ''\n      ).toUpperCase();\n      if (\n        options.type !== 'POST' &&\n        options.type !== 'PUT' &&\n        options.type !== 'PATCH'\n      ) {\n        options.type = 'POST';\n      }\n      if (!options.formAcceptCharset) {\n        options.formAcceptCharset = options.form.attr('accept-charset');\n      }\n    },\n\n    _getAJAXSettings: function (data) {\n      var options = $.extend({}, this.options, data);\n      this._initFormSettings(options);\n      this._initDataSettings(options);\n      return options;\n    },\n\n    // jQuery 1.6 doesn't provide .state(),\n    // while jQuery 1.8+ removed .isRejected() and .isResolved():\n    _getDeferredState: function (deferred) {\n      if (deferred.state) {\n        return deferred.state();\n      }\n      if (deferred.isResolved()) {\n        return 'resolved';\n      }\n      if (deferred.isRejected()) {\n        return 'rejected';\n      }\n      return 'pending';\n    },\n\n    // Maps jqXHR callbacks to the equivalent\n    // methods of the given Promise object:\n    _enhancePromise: function (promise) {\n      promise.success = promise.done;\n      promise.error = promise.fail;\n      promise.complete = promise.always;\n      return promise;\n    },\n\n    // Creates and returns a Promise object enhanced with\n    // the jqXHR methods abort, success, error and complete:\n    _getXHRPromise: function (resolveOrReject, context, args) {\n      var dfd = $.Deferred(),\n        promise = dfd.promise();\n      // eslint-disable-next-line no-param-reassign\n      context = context || this.options.context || promise;\n      if (resolveOrReject === true) {\n        dfd.resolveWith(context, args);\n      } else if (resolveOrReject === false) {\n        dfd.rejectWith(context, args);\n      }\n      promise.abort = dfd.promise;\n      return this._enhancePromise(promise);\n    },\n\n    // Adds convenience methods to the data callback argument:\n    _addConvenienceMethods: function (e, data) {\n      var that = this,\n        getPromise = function (args) {\n          return $.Deferred().resolveWith(that, args).promise();\n        };\n      data.process = function (resolveFunc, rejectFunc) {\n        if (resolveFunc || rejectFunc) {\n          data._processQueue = this._processQueue = (this._processQueue ||\n            getPromise([this]))\n            [that._promisePipe](function () {\n              if (data.errorThrown) {\n                return $.Deferred().rejectWith(that, [data]).promise();\n              }\n              return getPromise(arguments);\n            })\n            [that._promisePipe](resolveFunc, rejectFunc);\n        }\n        return this._processQueue || getPromise([this]);\n      };\n      data.submit = function () {\n        if (this.state() !== 'pending') {\n          data.jqXHR = this.jqXHR =\n            that._trigger(\n              'submit',\n              $.Event('submit', { delegatedEvent: e }),\n              this\n            ) !== false && that._onSend(e, this);\n        }\n        return this.jqXHR || that._getXHRPromise();\n      };\n      data.abort = function () {\n        if (this.jqXHR) {\n          return this.jqXHR.abort();\n        }\n        this.errorThrown = 'abort';\n        that._trigger('fail', null, this);\n        return that._getXHRPromise(false);\n      };\n      data.state = function () {\n        if (this.jqXHR) {\n          return that._getDeferredState(this.jqXHR);\n        }\n        if (this._processQueue) {\n          return that._getDeferredState(this._processQueue);\n        }\n      };\n      data.processing = function () {\n        return (\n          !this.jqXHR &&\n          this._processQueue &&\n          that._getDeferredState(this._processQueue) === 'pending'\n        );\n      };\n      data.progress = function () {\n        return this._progress;\n      };\n      data.response = function () {\n        return this._response;\n      };\n    },\n\n    // Parses the Range header from the server response\n    // and returns the uploaded bytes:\n    _getUploadedBytes: function (jqXHR) {\n      var range = jqXHR.getResponseHeader('Range'),\n        parts = range && range.split('-'),\n        upperBytesPos = parts && parts.length > 1 && parseInt(parts[1], 10);\n      return upperBytesPos && upperBytesPos + 1;\n    },\n\n    // Uploads a file in multiple, sequential requests\n    // by splitting the file up in multiple blob chunks.\n    // If the second parameter is true, only tests if the file\n    // should be uploaded in chunks, but does not invoke any\n    // upload requests:\n    _chunkedUpload: function (options, testOnly) {\n      options.uploadedBytes = options.uploadedBytes || 0;\n      var that = this,\n        file = options.files[0],\n        fs = file.size,\n        ub = options.uploadedBytes,\n        mcs = options.maxChunkSize || fs,\n        slice = this._blobSlice,\n        dfd = $.Deferred(),\n        promise = dfd.promise(),\n        jqXHR,\n        upload;\n      if (\n        !(\n          this._isXHRUpload(options) &&\n          slice &&\n          (ub || ($.type(mcs) === 'function' ? mcs(options) : mcs) < fs)\n        ) ||\n        options.data\n      ) {\n        return false;\n      }\n      if (testOnly) {\n        return true;\n      }\n      if (ub >= fs) {\n        file.error = options.i18n('uploadedBytes');\n        return this._getXHRPromise(false, options.context, [\n          null,\n          'error',\n          file.error\n        ]);\n      }\n      // The chunk upload method:\n      upload = function () {\n        // Clone the options object for each chunk upload:\n        var o = $.extend({}, options),\n          currentLoaded = o._progress.loaded;\n        o.blob = slice.call(\n          file,\n          ub,\n          ub + ($.type(mcs) === 'function' ? mcs(o) : mcs),\n          file.type\n        );\n        // Store the current chunk size, as the blob itself\n        // will be dereferenced after data processing:\n        o.chunkSize = o.blob.size;\n        // Expose the chunk bytes position range:\n        o.contentRange =\n          'bytes ' + ub + '-' + (ub + o.chunkSize - 1) + '/' + fs;\n        // Trigger chunkbeforesend to allow form data to be updated for this chunk\n        that._trigger('chunkbeforesend', null, o);\n        // Process the upload data (the blob and potential form data):\n        that._initXHRData(o);\n        // Add progress listeners for this chunk upload:\n        that._initProgressListener(o);\n        jqXHR = (\n          (that._trigger('chunksend', null, o) !== false && $.ajax(o)) ||\n          that._getXHRPromise(false, o.context)\n        )\n          .done(function (result, textStatus, jqXHR) {\n            ub = that._getUploadedBytes(jqXHR) || ub + o.chunkSize;\n            // Create a progress event if no final progress event\n            // with loaded equaling total has been triggered\n            // for this chunk:\n            if (currentLoaded + o.chunkSize - o._progress.loaded) {\n              that._onProgress(\n                $.Event('progress', {\n                  lengthComputable: true,\n                  loaded: ub - o.uploadedBytes,\n                  total: ub - o.uploadedBytes\n                }),\n                o\n              );\n            }\n            options.uploadedBytes = o.uploadedBytes = ub;\n            o.result = result;\n            o.textStatus = textStatus;\n            o.jqXHR = jqXHR;\n            that._trigger('chunkdone', null, o);\n            that._trigger('chunkalways', null, o);\n            if (ub < fs) {\n              // File upload not yet complete,\n              // continue with the next chunk:\n              upload();\n            } else {\n              dfd.resolveWith(o.context, [result, textStatus, jqXHR]);\n            }\n          })\n          .fail(function (jqXHR, textStatus, errorThrown) {\n            o.jqXHR = jqXHR;\n            o.textStatus = textStatus;\n            o.errorThrown = errorThrown;\n            that._trigger('chunkfail', null, o);\n            that._trigger('chunkalways', null, o);\n            dfd.rejectWith(o.context, [jqXHR, textStatus, errorThrown]);\n          })\n          .always(function () {\n            that._deinitProgressListener(o);\n          });\n      };\n      this._enhancePromise(promise);\n      promise.abort = function () {\n        return jqXHR.abort();\n      };\n      upload();\n      return promise;\n    },\n\n    _beforeSend: function (e, data) {\n      if (this._active === 0) {\n        // the start callback is triggered when an upload starts\n        // and no other uploads are currently running,\n        // equivalent to the global ajaxStart event:\n        this._trigger('start');\n        // Set timer for global bitrate progress calculation:\n        this._bitrateTimer = new this._BitrateTimer();\n        // Reset the global progress values:\n        this._progress.loaded = this._progress.total = 0;\n        this._progress.bitrate = 0;\n      }\n      // Make sure the container objects for the .response() and\n      // .progress() methods on the data object are available\n      // and reset to their initial state:\n      this._initResponseObject(data);\n      this._initProgressObject(data);\n      data._progress.loaded = data.loaded = data.uploadedBytes || 0;\n      data._progress.total = data.total = this._getTotal(data.files) || 1;\n      data._progress.bitrate = data.bitrate = 0;\n      this._active += 1;\n      // Initialize the global progress values:\n      this._progress.loaded += data.loaded;\n      this._progress.total += data.total;\n    },\n\n    _onDone: function (result, textStatus, jqXHR, options) {\n      var total = options._progress.total,\n        response = options._response;\n      if (options._progress.loaded < total) {\n        // Create a progress event if no final progress event\n        // with loaded equaling total has been triggered:\n        this._onProgress(\n          $.Event('progress', {\n            lengthComputable: true,\n            loaded: total,\n            total: total\n          }),\n          options\n        );\n      }\n      response.result = options.result = result;\n      response.textStatus = options.textStatus = textStatus;\n      response.jqXHR = options.jqXHR = jqXHR;\n      this._trigger('done', null, options);\n    },\n\n    _onFail: function (jqXHR, textStatus, errorThrown, options) {\n      var response = options._response;\n      if (options.recalculateProgress) {\n        // Remove the failed (error or abort) file upload from\n        // the global progress calculation:\n        this._progress.loaded -= options._progress.loaded;\n        this._progress.total -= options._progress.total;\n      }\n      response.jqXHR = options.jqXHR = jqXHR;\n      response.textStatus = options.textStatus = textStatus;\n      response.errorThrown = options.errorThrown = errorThrown;\n      this._trigger('fail', null, options);\n    },\n\n    _onAlways: function (jqXHRorResult, textStatus, jqXHRorError, options) {\n      // jqXHRorResult, textStatus and jqXHRorError are added to the\n      // options object via done and fail callbacks\n      this._trigger('always', null, options);\n    },\n\n    _onSend: function (e, data) {\n      if (!data.submit) {\n        this._addConvenienceMethods(e, data);\n      }\n      var that = this,\n        jqXHR,\n        aborted,\n        slot,\n        pipe,\n        options = that._getAJAXSettings(data),\n        send = function () {\n          that._sending += 1;\n          // Set timer for bitrate progress calculation:\n          options._bitrateTimer = new that._BitrateTimer();\n          jqXHR =\n            jqXHR ||\n            (\n              ((aborted ||\n                that._trigger(\n                  'send',\n                  $.Event('send', { delegatedEvent: e }),\n                  options\n                ) === false) &&\n                that._getXHRPromise(false, options.context, aborted)) ||\n              that._chunkedUpload(options) ||\n              $.ajax(options)\n            )\n              .done(function (result, textStatus, jqXHR) {\n                that._onDone(result, textStatus, jqXHR, options);\n              })\n              .fail(function (jqXHR, textStatus, errorThrown) {\n                that._onFail(jqXHR, textStatus, errorThrown, options);\n              })\n              .always(function (jqXHRorResult, textStatus, jqXHRorError) {\n                that._deinitProgressListener(options);\n                that._onAlways(\n                  jqXHRorResult,\n                  textStatus,\n                  jqXHRorError,\n                  options\n                );\n                that._sending -= 1;\n                that._active -= 1;\n                if (\n                  options.limitConcurrentUploads &&\n                  options.limitConcurrentUploads > that._sending\n                ) {\n                  // Start the next queued upload,\n                  // that has not been aborted:\n                  var nextSlot = that._slots.shift();\n                  while (nextSlot) {\n                    if (that._getDeferredState(nextSlot) === 'pending') {\n                      nextSlot.resolve();\n                      break;\n                    }\n                    nextSlot = that._slots.shift();\n                  }\n                }\n                if (that._active === 0) {\n                  // The stop callback is triggered when all uploads have\n                  // been completed, equivalent to the global ajaxStop event:\n                  that._trigger('stop');\n                }\n              });\n          return jqXHR;\n        };\n      this._beforeSend(e, options);\n      if (\n        this.options.sequentialUploads ||\n        (this.options.limitConcurrentUploads &&\n          this.options.limitConcurrentUploads <= this._sending)\n      ) {\n        if (this.options.limitConcurrentUploads > 1) {\n          slot = $.Deferred();\n          this._slots.push(slot);\n          pipe = slot[that._promisePipe](send);\n        } else {\n          this._sequence = this._sequence[that._promisePipe](send, send);\n          pipe = this._sequence;\n        }\n        // Return the piped Promise object, enhanced with an abort method,\n        // which is delegated to the jqXHR object of the current upload,\n        // and jqXHR callbacks mapped to the equivalent Promise methods:\n        pipe.abort = function () {\n          aborted = [undefined, 'abort', 'abort'];\n          if (!jqXHR) {\n            if (slot) {\n              slot.rejectWith(options.context, aborted);\n            }\n            return send();\n          }\n          return jqXHR.abort();\n        };\n        return this._enhancePromise(pipe);\n      }\n      return send();\n    },\n\n    _onAdd: function (e, data) {\n      var that = this,\n        result = true,\n        options = $.extend({}, this.options, data),\n        files = data.files,\n        filesLength = files.length,\n        limit = options.limitMultiFileUploads,\n        limitSize = options.limitMultiFileUploadSize,\n        overhead = options.limitMultiFileUploadSizeOverhead,\n        batchSize = 0,\n        paramName = this._getParamName(options),\n        paramNameSet,\n        paramNameSlice,\n        fileSet,\n        i,\n        j = 0;\n      if (!filesLength) {\n        return false;\n      }\n      if (limitSize && files[0].size === undefined) {\n        limitSize = undefined;\n      }\n      if (\n        !(options.singleFileUploads || limit || limitSize) ||\n        !this._isXHRUpload(options)\n      ) {\n        fileSet = [files];\n        paramNameSet = [paramName];\n      } else if (!(options.singleFileUploads || limitSize) && limit) {\n        fileSet = [];\n        paramNameSet = [];\n        for (i = 0; i < filesLength; i += limit) {\n          fileSet.push(files.slice(i, i + limit));\n          paramNameSlice = paramName.slice(i, i + limit);\n          if (!paramNameSlice.length) {\n            paramNameSlice = paramName;\n          }\n          paramNameSet.push(paramNameSlice);\n        }\n      } else if (!options.singleFileUploads && limitSize) {\n        fileSet = [];\n        paramNameSet = [];\n        for (i = 0; i < filesLength; i = i + 1) {\n          batchSize += files[i].size + overhead;\n          if (\n            i + 1 === filesLength ||\n            batchSize + files[i + 1].size + overhead > limitSize ||\n            (limit && i + 1 - j >= limit)\n          ) {\n            fileSet.push(files.slice(j, i + 1));\n            paramNameSlice = paramName.slice(j, i + 1);\n            if (!paramNameSlice.length) {\n              paramNameSlice = paramName;\n            }\n            paramNameSet.push(paramNameSlice);\n            j = i + 1;\n            batchSize = 0;\n          }\n        }\n      } else {\n        paramNameSet = paramName;\n      }\n      data.originalFiles = files;\n      $.each(fileSet || files, function (index, element) {\n        var newData = $.extend({}, data);\n        newData.files = fileSet ? element : [element];\n        newData.paramName = paramNameSet[index];\n        that._initResponseObject(newData);\n        that._initProgressObject(newData);\n        that._addConvenienceMethods(e, newData);\n        result = that._trigger(\n          'add',\n          $.Event('add', { delegatedEvent: e }),\n          newData\n        );\n        return result;\n      });\n      return result;\n    },\n\n    _replaceFileInput: function (data) {\n      var input = data.fileInput,\n        inputClone = input.clone(true),\n        restoreFocus = input.is(document.activeElement);\n      // Add a reference for the new cloned file input to the data argument:\n      data.fileInputClone = inputClone;\n      $('<form></form>').append(inputClone)[0].reset();\n      // Detaching allows to insert the fileInput on another form\n      // without loosing the file input value:\n      input.after(inputClone).detach();\n      // If the fileInput had focus before it was detached,\n      // restore focus to the inputClone.\n      if (restoreFocus) {\n        inputClone.trigger('focus');\n      }\n      // Avoid memory leaks with the detached file input:\n      $.cleanData(input.off('remove'));\n      // Replace the original file input element in the fileInput\n      // elements set with the clone, which has been copied including\n      // event handlers:\n      this.options.fileInput = this.options.fileInput.map(function (i, el) {\n        if (el === input[0]) {\n          return inputClone[0];\n        }\n        return el;\n      });\n      // If the widget has been initialized on the file input itself,\n      // override this.element with the file input clone:\n      if (input[0] === this.element[0]) {\n        this.element = inputClone;\n      }\n    },\n\n    _handleFileTreeEntry: function (entry, path) {\n      var that = this,\n        dfd = $.Deferred(),\n        entries = [],\n        dirReader,\n        errorHandler = function (e) {\n          if (e && !e.entry) {\n            e.entry = entry;\n          }\n          // Since $.when returns immediately if one\n          // Deferred is rejected, we use resolve instead.\n          // This allows valid files and invalid items\n          // to be returned together in one set:\n          dfd.resolve([e]);\n        },\n        successHandler = function (entries) {\n          that\n            ._handleFileTreeEntries(entries, path + entry.name + '/')\n            .done(function (files) {\n              dfd.resolve(files);\n            })\n            .fail(errorHandler);\n        },\n        readEntries = function () {\n          dirReader.readEntries(function (results) {\n            if (!results.length) {\n              successHandler(entries);\n            } else {\n              entries = entries.concat(results);\n              readEntries();\n            }\n          }, errorHandler);\n        };\n      // eslint-disable-next-line no-param-reassign\n      path = path || '';\n      if (entry.isFile) {\n        if (entry._file) {\n          // Workaround for Chrome bug #149735\n          entry._file.relativePath = path;\n          dfd.resolve(entry._file);\n        } else {\n          entry.file(function (file) {\n            file.relativePath = path;\n            dfd.resolve(file);\n          }, errorHandler);\n        }\n      } else if (entry.isDirectory) {\n        dirReader = entry.createReader();\n        readEntries();\n      } else {\n        // Return an empty list for file system items\n        // other than files or directories:\n        dfd.resolve([]);\n      }\n      return dfd.promise();\n    },\n\n    _handleFileTreeEntries: function (entries, path) {\n      var that = this;\n      return $.when\n        .apply(\n          $,\n          $.map(entries, function (entry) {\n            return that._handleFileTreeEntry(entry, path);\n          })\n        )\n        [this._promisePipe](function () {\n          return Array.prototype.concat.apply([], arguments);\n        });\n    },\n\n    _getDroppedFiles: function (dataTransfer) {\n      // eslint-disable-next-line no-param-reassign\n      dataTransfer = dataTransfer || {};\n      var items = dataTransfer.items;\n      if (\n        items &&\n        items.length &&\n        (items[0].webkitGetAsEntry || items[0].getAsEntry)\n      ) {\n        return this._handleFileTreeEntries(\n          $.map(items, function (item) {\n            var entry;\n            if (item.webkitGetAsEntry) {\n              entry = item.webkitGetAsEntry();\n              if (entry) {\n                // Workaround for Chrome bug #149735:\n                entry._file = item.getAsFile();\n              }\n              return entry;\n            }\n            return item.getAsEntry();\n          })\n        );\n      }\n      return $.Deferred().resolve($.makeArray(dataTransfer.files)).promise();\n    },\n\n    _getSingleFileInputFiles: function (fileInput) {\n      // eslint-disable-next-line no-param-reassign\n      fileInput = $(fileInput);\n      var entries =\n          fileInput.prop('webkitEntries') || fileInput.prop('entries'),\n        files,\n        value;\n      if (entries && entries.length) {\n        return this._handleFileTreeEntries(entries);\n      }\n      files = $.makeArray(fileInput.prop('files'));\n      if (!files.length) {\n        value = fileInput.prop('value');\n        if (!value) {\n          return $.Deferred().resolve([]).promise();\n        }\n        // If the files property is not available, the browser does not\n        // support the File API and we add a pseudo File object with\n        // the input value as name with path information removed:\n        files = [{ name: value.replace(/^.*\\\\/, '') }];\n      } else if (files[0].name === undefined && files[0].fileName) {\n        // File normalization for Safari 4 and Firefox 3:\n        $.each(files, function (index, file) {\n          file.name = file.fileName;\n          file.size = file.fileSize;\n        });\n      }\n      return $.Deferred().resolve(files).promise();\n    },\n\n    _getFileInputFiles: function (fileInput) {\n      if (!(fileInput instanceof $) || fileInput.length === 1) {\n        return this._getSingleFileInputFiles(fileInput);\n      }\n      return $.when\n        .apply($, $.map(fileInput, this._getSingleFileInputFiles))\n        [this._promisePipe](function () {\n          return Array.prototype.concat.apply([], arguments);\n        });\n    },\n\n    _onChange: function (e) {\n      var that = this,\n        data = {\n          fileInput: $(e.target),\n          form: $(e.target.form)\n        };\n      this._getFileInputFiles(data.fileInput).always(function (files) {\n        data.files = files;\n        if (that.options.replaceFileInput) {\n          that._replaceFileInput(data);\n        }\n        if (\n          that._trigger(\n            'change',\n            $.Event('change', { delegatedEvent: e }),\n            data\n          ) !== false\n        ) {\n          that._onAdd(e, data);\n        }\n      });\n    },\n\n    _onPaste: function (e) {\n      var items =\n          e.originalEvent &&\n          e.originalEvent.clipboardData &&\n          e.originalEvent.clipboardData.items,\n        data = { files: [] };\n      if (items && items.length) {\n        $.each(items, function (index, item) {\n          var file = item.getAsFile && item.getAsFile();\n          if (file) {\n            data.files.push(file);\n          }\n        });\n        if (\n          this._trigger(\n            'paste',\n            $.Event('paste', { delegatedEvent: e }),\n            data\n          ) !== false\n        ) {\n          this._onAdd(e, data);\n        }\n      }\n    },\n\n    _onDrop: function (e) {\n      e.dataTransfer = e.originalEvent && e.originalEvent.dataTransfer;\n      var that = this,\n        dataTransfer = e.dataTransfer,\n        data = {};\n      if (dataTransfer && dataTransfer.files && dataTransfer.files.length) {\n        e.preventDefault();\n        this._getDroppedFiles(dataTransfer).always(function (files) {\n          data.files = files;\n          if (\n            that._trigger(\n              'drop',\n              $.Event('drop', { delegatedEvent: e }),\n              data\n            ) !== false\n          ) {\n            that._onAdd(e, data);\n          }\n        });\n      }\n    },\n\n    _onDragOver: getDragHandler('dragover'),\n\n    _onDragEnter: getDragHandler('dragenter'),\n\n    _onDragLeave: getDragHandler('dragleave'),\n\n    _initEventHandlers: function () {\n      if (this._isXHRUpload(this.options)) {\n        this._on(this.options.dropZone, {\n          dragover: this._onDragOver,\n          drop: this._onDrop,\n          // event.preventDefault() on dragenter is required for IE10+:\n          dragenter: this._onDragEnter,\n          // dragleave is not required, but added for completeness:\n          dragleave: this._onDragLeave\n        });\n        this._on(this.options.pasteZone, {\n          paste: this._onPaste\n        });\n      }\n      if ($.support.fileInput) {\n        this._on(this.options.fileInput, {\n          change: this._onChange\n        });\n      }\n    },\n\n    _destroyEventHandlers: function () {\n      this._off(this.options.dropZone, 'dragenter dragleave dragover drop');\n      this._off(this.options.pasteZone, 'paste');\n      this._off(this.options.fileInput, 'change');\n    },\n\n    _destroy: function () {\n      this._destroyEventHandlers();\n    },\n\n    _setOption: function (key, value) {\n      var reinit = $.inArray(key, this._specialOptions) !== -1;\n      if (reinit) {\n        this._destroyEventHandlers();\n      }\n      this._super(key, value);\n      if (reinit) {\n        this._initSpecialOptions();\n        this._initEventHandlers();\n      }\n    },\n\n    _initSpecialOptions: function () {\n      var options = this.options;\n      if (options.fileInput === undefined) {\n        options.fileInput = this.element.is('input[type=\"file\"]')\n          ? this.element\n          : this.element.find('input[type=\"file\"]');\n      } else if (!(options.fileInput instanceof $)) {\n        options.fileInput = $(options.fileInput);\n      }\n      if (!(options.dropZone instanceof $)) {\n        options.dropZone = $(options.dropZone);\n      }\n      if (!(options.pasteZone instanceof $)) {\n        options.pasteZone = $(options.pasteZone);\n      }\n    },\n\n    _getRegExp: function (str) {\n      var parts = str.split('/'),\n        modifiers = parts.pop();\n      parts.shift();\n      return new RegExp(parts.join('/'), modifiers);\n    },\n\n    _isRegExpOption: function (key, value) {\n      return (\n        key !== 'url' &&\n        $.type(value) === 'string' &&\n        /^\\/.*\\/[igm]{0,3}$/.test(value)\n      );\n    },\n\n    _initDataAttributes: function () {\n      var that = this,\n        options = this.options,\n        data = this.element.data();\n      // Initialize options set via HTML5 data-attributes:\n      $.each(this.element[0].attributes, function (index, attr) {\n        var key = attr.name.toLowerCase(),\n          value;\n        if (/^data-/.test(key)) {\n          // Convert hyphen-ated key to camelCase:\n          key = key.slice(5).replace(/-[a-z]/g, function (str) {\n            return str.charAt(1).toUpperCase();\n          });\n          value = data[key];\n          if (that._isRegExpOption(key, value)) {\n            value = that._getRegExp(value);\n          }\n          options[key] = value;\n        }\n      });\n    },\n\n    _create: function () {\n      this._initDataAttributes();\n      this._initSpecialOptions();\n      this._slots = [];\n      this._sequence = this._getXHRPromise(true);\n      this._sending = this._active = 0;\n      this._initProgressObject(this);\n      this._initEventHandlers();\n    },\n\n    // This method is exposed to the widget API and allows to query\n    // the number of active uploads:\n    active: function () {\n      return this._active;\n    },\n\n    // This method is exposed to the widget API and allows to query\n    // the widget upload progress.\n    // It returns an object with loaded, total and bitrate properties\n    // for the running uploads:\n    progress: function () {\n      return this._progress;\n    },\n\n    // This method is exposed to the widget API and allows adding files\n    // using the fileupload API. The data parameter accepts an object which\n    // must have a files property and can contain additional options:\n    // .fileupload('add', {files: filesList});\n    add: function (data) {\n      var that = this;\n      if (!data || this.options.disabled) {\n        return;\n      }\n      if (data.fileInput && !data.files) {\n        this._getFileInputFiles(data.fileInput).always(function (files) {\n          data.files = files;\n          that._onAdd(null, data);\n        });\n      } else {\n        data.files = $.makeArray(data.files);\n        this._onAdd(null, data);\n      }\n    },\n\n    // This method is exposed to the widget API and allows sending files\n    // using the fileupload API. The data parameter accepts an object which\n    // must have a files or fileInput property and can contain additional options:\n    // .fileupload('send', {files: filesList});\n    // The method returns a Promise object for the file upload call.\n    send: function (data) {\n      if (data && !this.options.disabled) {\n        if (data.fileInput && !data.files) {\n          var that = this,\n            dfd = $.Deferred(),\n            promise = dfd.promise(),\n            jqXHR,\n            aborted;\n          promise.abort = function () {\n            aborted = true;\n            if (jqXHR) {\n              return jqXHR.abort();\n            }\n            dfd.reject(null, 'abort', 'abort');\n            return promise;\n          };\n          this._getFileInputFiles(data.fileInput).always(function (files) {\n            if (aborted) {\n              return;\n            }\n            if (!files.length) {\n              dfd.reject();\n              return;\n            }\n            data.files = files;\n            jqXHR = that._onSend(null, data);\n            jqXHR.then(\n              function (result, textStatus, jqXHR) {\n                dfd.resolve(result, textStatus, jqXHR);\n              },\n              function (jqXHR, textStatus, errorThrown) {\n                dfd.reject(jqXHR, textStatus, errorThrown);\n              }\n            );\n          });\n          return this._enhancePromise(promise);\n        }\n        data.files = $.makeArray(data.files);\n        if (data.files.length) {\n          return this._onSend(null, data);\n        }\n      }\n      return this._getXHRPromise(false, data && data.context);\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload-ui.js":"/*\n * jQuery File Upload User Interface Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2010, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define([\n      'jquery',\n      'jquery/fileUploader/vendor/blueimp-tmpl/js/tmpl',\n      'jquery/fileUploader/jquery.fileupload-image',\n      'jquery/fileUploader/jquery.fileupload-audio',\n      'jquery/fileUploader/jquery.fileupload-video',\n      'jquery/fileUploader/jquery.fileupload-validate'\n    ], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/vendor/blueimp-tmpl/js/tmpl'),\n      require('jquery/fileUploader/jquery.fileupload-image'),\n      require('jquery/fileUploader/jquery.fileupload-audio'),\n      require('jquery/fileUploader/jquery.fileupload-video'),\n      require('jquery/fileUploader/jquery.fileupload-validate')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery, window.tmpl);\n  }\n})(function ($, tmpl) {\n  'use strict';\n\n  $.blueimp.fileupload.prototype._specialOptions.push(\n    'filesContainer',\n    'uploadTemplateId',\n    'downloadTemplateId'\n  );\n\n  // The UI version extends the file upload widget\n  // and adds complete user interface interaction:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // By default, files added to the widget are uploaded as soon\n      // as the user clicks on the start buttons. To enable automatic\n      // uploads, set the following option to true:\n      autoUpload: false,\n      // The class to show/hide UI elements:\n      showElementClass: 'in',\n      // The ID of the upload template:\n      uploadTemplateId: 'template-upload',\n      // The ID of the download template:\n      downloadTemplateId: 'template-download',\n      // The container for the list of files. If undefined, it is set to\n      // an element with class \"files\" inside of the widget element:\n      filesContainer: undefined,\n      // By default, files are appended to the files container.\n      // Set the following option to true, to prepend files instead:\n      prependFiles: false,\n      // The expected data type of the upload response, sets the dataType\n      // option of the $.ajax upload requests:\n      dataType: 'json',\n\n      // Error and info messages:\n      messages: {\n        unknownError: 'Unknown error'\n      },\n\n      // Function returning the current number of files,\n      // used by the maxNumberOfFiles validation:\n      getNumberOfFiles: function () {\n        return this.filesContainer.children().not('.processing').length;\n      },\n\n      // Callback to retrieve the list of files from the server response:\n      getFilesFromResponse: function (data) {\n        if (data.result && $.isArray(data.result.files)) {\n          return data.result.files;\n        }\n        return [];\n      },\n\n      // The add callback is invoked as soon as files are added to the fileupload\n      // widget (via file input selection, drag & drop or add API call).\n      // See the basic file upload widget for more information:\n      add: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var $this = $(this),\n          that = $this.data('blueimp-fileupload') || $this.data('fileupload'),\n          options = that.options;\n        data.context = that\n          ._renderUpload(data.files)\n          .data('data', data)\n          .addClass('processing');\n        options.filesContainer[options.prependFiles ? 'prepend' : 'append'](\n          data.context\n        );\n        that._forceReflow(data.context);\n        that._transition(data.context);\n        data\n          .process(function () {\n            return $this.fileupload('process', data);\n          })\n          .always(function () {\n            data.context\n              .each(function (index) {\n                $(this)\n                  .find('.size')\n                  .text(that._formatFileSize(data.files[index].size));\n              })\n              .removeClass('processing');\n            that._renderPreviews(data);\n          })\n          .done(function () {\n            data.context.find('.edit,.start').prop('disabled', false);\n            if (\n              that._trigger('added', e, data) !== false &&\n              (options.autoUpload || data.autoUpload) &&\n              data.autoUpload !== false\n            ) {\n              data.submit();\n            }\n          })\n          .fail(function () {\n            if (data.files.error) {\n              data.context.each(function (index) {\n                var error = data.files[index].error;\n                if (error) {\n                  $(this).find('.error').text(error);\n                }\n              });\n            }\n          });\n      },\n      // Callback for the start of each file upload request:\n      send: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n          $(this).data('blueimp-fileupload') || $(this).data('fileupload');\n        if (\n          data.context &&\n          data.dataType &&\n          data.dataType.substr(0, 6) === 'iframe'\n        ) {\n          // Iframe Transport does not support progress events.\n          // In lack of an indeterminate progress bar, we set\n          // the progress to 100%, showing the full animated bar:\n          data.context\n            .find('.progress')\n            .addClass(!$.support.transition && 'progress-animated')\n            .attr('aria-valuenow', 100)\n            .children()\n            .first()\n            .css('width', '100%');\n        }\n        return that._trigger('sent', e, data);\n      },\n      // Callback for successful uploads:\n      done: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n            $(this).data('blueimp-fileupload') || $(this).data('fileupload'),\n          getFilesFromResponse =\n            data.getFilesFromResponse || that.options.getFilesFromResponse,\n          files = getFilesFromResponse(data),\n          template,\n          deferred;\n        if (data.context) {\n          data.context.each(function (index) {\n            var file = files[index] || { error: 'Empty file upload result' };\n            deferred = that._addFinishedDeferreds();\n            that._transition($(this)).done(function () {\n              var node = $(this);\n              template = that._renderDownload([file]).replaceAll(node);\n              that._forceReflow(template);\n              that._transition(template).done(function () {\n                data.context = $(this);\n                that._trigger('completed', e, data);\n                that._trigger('finished', e, data);\n                deferred.resolve();\n              });\n            });\n          });\n        } else {\n          template = that\n            ._renderDownload(files)\n            [that.options.prependFiles ? 'prependTo' : 'appendTo'](\n              that.options.filesContainer\n            );\n          that._forceReflow(template);\n          deferred = that._addFinishedDeferreds();\n          that._transition(template).done(function () {\n            data.context = $(this);\n            that._trigger('completed', e, data);\n            that._trigger('finished', e, data);\n            deferred.resolve();\n          });\n        }\n      },\n      // Callback for failed (abort or error) uploads:\n      fail: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n            $(this).data('blueimp-fileupload') || $(this).data('fileupload'),\n          template,\n          deferred;\n        if (data.context) {\n          data.context.each(function (index) {\n            if (data.errorThrown !== 'abort') {\n              var file = data.files[index];\n              file.error =\n                file.error || data.errorThrown || data.i18n('unknownError');\n              deferred = that._addFinishedDeferreds();\n              that._transition($(this)).done(function () {\n                var node = $(this);\n                template = that._renderDownload([file]).replaceAll(node);\n                that._forceReflow(template);\n                that._transition(template).done(function () {\n                  data.context = $(this);\n                  that._trigger('failed', e, data);\n                  that._trigger('finished', e, data);\n                  deferred.resolve();\n                });\n              });\n            } else {\n              deferred = that._addFinishedDeferreds();\n              that._transition($(this)).done(function () {\n                $(this).remove();\n                that._trigger('failed', e, data);\n                that._trigger('finished', e, data);\n                deferred.resolve();\n              });\n            }\n          });\n        } else if (data.errorThrown !== 'abort') {\n          data.context = that\n            ._renderUpload(data.files)\n            [that.options.prependFiles ? 'prependTo' : 'appendTo'](\n              that.options.filesContainer\n            )\n            .data('data', data);\n          that._forceReflow(data.context);\n          deferred = that._addFinishedDeferreds();\n          that._transition(data.context).done(function () {\n            data.context = $(this);\n            that._trigger('failed', e, data);\n            that._trigger('finished', e, data);\n            deferred.resolve();\n          });\n        } else {\n          that._trigger('failed', e, data);\n          that._trigger('finished', e, data);\n          that._addFinishedDeferreds().resolve();\n        }\n      },\n      // Callback for upload progress events:\n      progress: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var progress = Math.floor((data.loaded / data.total) * 100);\n        if (data.context) {\n          data.context.each(function () {\n            $(this)\n              .find('.progress')\n              .attr('aria-valuenow', progress)\n              .children()\n              .first()\n              .css('width', progress + '%');\n          });\n        }\n      },\n      // Callback for global upload progress events:\n      progressall: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var $this = $(this),\n          progress = Math.floor((data.loaded / data.total) * 100),\n          globalProgressNode = $this.find('.fileupload-progress'),\n          extendedProgressNode = globalProgressNode.find('.progress-extended');\n        if (extendedProgressNode.length) {\n          extendedProgressNode.html(\n            (\n              $this.data('blueimp-fileupload') || $this.data('fileupload')\n            )._renderExtendedProgress(data)\n          );\n        }\n        globalProgressNode\n          .find('.progress')\n          .attr('aria-valuenow', progress)\n          .children()\n          .first()\n          .css('width', progress + '%');\n      },\n      // Callback for uploads start, equivalent to the global ajaxStart event:\n      start: function (e) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n          $(this).data('blueimp-fileupload') || $(this).data('fileupload');\n        that._resetFinishedDeferreds();\n        that\n          ._transition($(this).find('.fileupload-progress'))\n          .done(function () {\n            that._trigger('started', e);\n          });\n      },\n      // Callback for uploads stop, equivalent to the global ajaxStop event:\n      stop: function (e) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n            $(this).data('blueimp-fileupload') || $(this).data('fileupload'),\n          deferred = that._addFinishedDeferreds();\n        $.when.apply($, that._getFinishedDeferreds()).done(function () {\n          that._trigger('stopped', e);\n        });\n        that\n          ._transition($(this).find('.fileupload-progress'))\n          .done(function () {\n            $(this)\n              .find('.progress')\n              .attr('aria-valuenow', '0')\n              .children()\n              .first()\n              .css('width', '0%');\n            $(this).find('.progress-extended').html('&nbsp;');\n            deferred.resolve();\n          });\n      },\n      processstart: function (e) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        $(this).addClass('fileupload-processing');\n      },\n      processstop: function (e) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        $(this).removeClass('fileupload-processing');\n      },\n      // Callback for file deletion:\n      destroy: function (e, data) {\n        if (e.isDefaultPrevented()) {\n          return false;\n        }\n        var that =\n            $(this).data('blueimp-fileupload') || $(this).data('fileupload'),\n          removeNode = function () {\n            that._transition(data.context).done(function () {\n              $(this).remove();\n              that._trigger('destroyed', e, data);\n            });\n          };\n        if (data.url) {\n          data.dataType = data.dataType || that.options.dataType;\n          $.ajax(data)\n            .done(removeNode)\n            .fail(function () {\n              that._trigger('destroyfailed', e, data);\n            });\n        } else {\n          removeNode();\n        }\n      }\n    },\n\n    _resetFinishedDeferreds: function () {\n      this._finishedUploads = [];\n    },\n\n    _addFinishedDeferreds: function (deferred) {\n      // eslint-disable-next-line new-cap\n      var promise = deferred || $.Deferred();\n      this._finishedUploads.push(promise);\n      return promise;\n    },\n\n    _getFinishedDeferreds: function () {\n      return this._finishedUploads;\n    },\n\n    // Link handler, that allows to download files\n    // by drag & drop of the links to the desktop:\n    _enableDragToDesktop: function () {\n      var link = $(this),\n        url = link.prop('href'),\n        name = link.prop('download'),\n        type = 'application/octet-stream';\n      link.on('dragstart', function (e) {\n        try {\n          e.originalEvent.dataTransfer.setData(\n            'DownloadURL',\n            [type, name, url].join(':')\n          );\n        } catch (ignore) {\n          // Ignore exceptions\n        }\n      });\n    },\n\n    _formatFileSize: function (bytes) {\n      if (typeof bytes !== 'number') {\n        return '';\n      }\n      if (bytes >= 1000000000) {\n        return (bytes / 1000000000).toFixed(2) + ' GB';\n      }\n      if (bytes >= 1000000) {\n        return (bytes / 1000000).toFixed(2) + ' MB';\n      }\n      return (bytes / 1000).toFixed(2) + ' KB';\n    },\n\n    _formatBitrate: function (bits) {\n      if (typeof bits !== 'number') {\n        return '';\n      }\n      if (bits >= 1000000000) {\n        return (bits / 1000000000).toFixed(2) + ' Gbit/s';\n      }\n      if (bits >= 1000000) {\n        return (bits / 1000000).toFixed(2) + ' Mbit/s';\n      }\n      if (bits >= 1000) {\n        return (bits / 1000).toFixed(2) + ' kbit/s';\n      }\n      return bits.toFixed(2) + ' bit/s';\n    },\n\n    _formatTime: function (seconds) {\n      var date = new Date(seconds * 1000),\n        days = Math.floor(seconds / 86400);\n      days = days ? days + 'd ' : '';\n      return (\n        days +\n        ('0' + date.getUTCHours()).slice(-2) +\n        ':' +\n        ('0' + date.getUTCMinutes()).slice(-2) +\n        ':' +\n        ('0' + date.getUTCSeconds()).slice(-2)\n      );\n    },\n\n    _formatPercentage: function (floatValue) {\n      return (floatValue * 100).toFixed(2) + ' %';\n    },\n\n    _renderExtendedProgress: function (data) {\n      return (\n        this._formatBitrate(data.bitrate) +\n        ' | ' +\n        this._formatTime(((data.total - data.loaded) * 8) / data.bitrate) +\n        ' | ' +\n        this._formatPercentage(data.loaded / data.total) +\n        ' | ' +\n        this._formatFileSize(data.loaded) +\n        ' / ' +\n        this._formatFileSize(data.total)\n      );\n    },\n\n    _renderTemplate: function (func, files) {\n      if (!func) {\n        return $();\n      }\n      var result = func({\n        files: files,\n        formatFileSize: this._formatFileSize,\n        options: this.options\n      });\n      if (result instanceof $) {\n        return result;\n      }\n      return $(this.options.templatesContainer).html(result).children();\n    },\n\n    _renderPreviews: function (data) {\n      data.context.find('.preview').each(function (index, elm) {\n        $(elm).empty().append(data.files[index].preview);\n      });\n    },\n\n    _renderUpload: function (files) {\n      return this._renderTemplate(this.options.uploadTemplate, files);\n    },\n\n    _renderDownload: function (files) {\n      return this._renderTemplate(this.options.downloadTemplate, files)\n        .find('a[download]')\n        .each(this._enableDragToDesktop)\n        .end();\n    },\n\n    _editHandler: function (e) {\n      e.preventDefault();\n      if (!this.options.edit) return;\n      var that = this,\n        button = $(e.currentTarget),\n        template = button.closest('.template-upload'),\n        data = template.data('data'),\n        index = button.data().index;\n      this.options.edit(data.files[index]).then(function (file) {\n        if (!file) return;\n        data.files[index] = file;\n        data.context.addClass('processing');\n        template.find('.edit,.start').prop('disabled', true);\n        $(that.element)\n          .fileupload('process', data)\n          .always(function () {\n            template\n              .find('.size')\n              .text(that._formatFileSize(data.files[index].size));\n            data.context.removeClass('processing');\n            that._renderPreviews(data);\n          })\n          .done(function () {\n            template.find('.edit,.start').prop('disabled', false);\n          })\n          .fail(function () {\n            template.find('.edit').prop('disabled', false);\n            var error = data.files[index].error;\n            if (error) {\n              template.find('.error').text(error);\n            }\n          });\n      });\n    },\n\n    _startHandler: function (e) {\n      e.preventDefault();\n      var button = $(e.currentTarget),\n        template = button.closest('.template-upload'),\n        data = template.data('data');\n      button.prop('disabled', true);\n      if (data && data.submit) {\n        data.submit();\n      }\n    },\n\n    _cancelHandler: function (e) {\n      e.preventDefault();\n      var template = $(e.currentTarget).closest(\n          '.template-upload,.template-download'\n        ),\n        data = template.data('data') || {};\n      data.context = data.context || template;\n      if (data.abort) {\n        data.abort();\n      } else {\n        data.errorThrown = 'abort';\n        this._trigger('fail', e, data);\n      }\n    },\n\n    _deleteHandler: function (e) {\n      e.preventDefault();\n      var button = $(e.currentTarget);\n      this._trigger(\n        'destroy',\n        e,\n        $.extend(\n          {\n            context: button.closest('.template-download'),\n            type: 'DELETE'\n          },\n          button.data()\n        )\n      );\n    },\n\n    _forceReflow: function (node) {\n      return $.support.transition && node.length && node[0].offsetWidth;\n    },\n\n    _transition: function (node) {\n      // eslint-disable-next-line new-cap\n      var dfd = $.Deferred();\n      if (\n        $.support.transition &&\n        node.hasClass('fade') &&\n        node.is(':visible')\n      ) {\n        var transitionEndHandler = function (e) {\n          // Make sure we don't respond to other transition events\n          // in the container element, e.g. from button elements:\n          if (e.target === node[0]) {\n            node.off($.support.transition.end, transitionEndHandler);\n            dfd.resolveWith(node);\n          }\n        };\n        node\n          .on($.support.transition.end, transitionEndHandler)\n          .toggleClass(this.options.showElementClass);\n      } else {\n        node.toggleClass(this.options.showElementClass);\n        dfd.resolveWith(node);\n      }\n      return dfd;\n    },\n\n    _initButtonBarEventHandlers: function () {\n      var fileUploadButtonBar = this.element.find('.fileupload-buttonbar'),\n        filesList = this.options.filesContainer;\n      this._on(fileUploadButtonBar.find('.start'), {\n        click: function (e) {\n          e.preventDefault();\n          filesList.find('.start').trigger('click');\n        }\n      });\n      this._on(fileUploadButtonBar.find('.cancel'), {\n        click: function (e) {\n          e.preventDefault();\n          filesList.find('.cancel').trigger('click');\n        }\n      });\n      this._on(fileUploadButtonBar.find('.delete'), {\n        click: function (e) {\n          e.preventDefault();\n          filesList\n            .find('.toggle:checked')\n            .closest('.template-download')\n            .find('.delete')\n            .trigger('click');\n          fileUploadButtonBar.find('.toggle').prop('checked', false);\n        }\n      });\n      this._on(fileUploadButtonBar.find('.toggle'), {\n        change: function (e) {\n          filesList\n            .find('.toggle')\n            .prop('checked', $(e.currentTarget).is(':checked'));\n        }\n      });\n    },\n\n    _destroyButtonBarEventHandlers: function () {\n      this._off(\n        this.element\n          .find('.fileupload-buttonbar')\n          .find('.start, .cancel, .delete'),\n        'click'\n      );\n      this._off(this.element.find('.fileupload-buttonbar .toggle'), 'change.');\n    },\n\n    _initEventHandlers: function () {\n      this._super();\n      this._on(this.options.filesContainer, {\n        'click .edit': this._editHandler,\n        'click .start': this._startHandler,\n        'click .cancel': this._cancelHandler,\n        'click .delete': this._deleteHandler\n      });\n      this._initButtonBarEventHandlers();\n    },\n\n    _destroyEventHandlers: function () {\n      this._destroyButtonBarEventHandlers();\n      this._off(this.options.filesContainer, 'click');\n      this._super();\n    },\n\n    _enableFileInputButton: function () {\n      this.element\n        .find('.fileinput-button input')\n        .prop('disabled', false)\n        .parent()\n        .removeClass('disabled');\n    },\n\n    _disableFileInputButton: function () {\n      this.element\n        .find('.fileinput-button input')\n        .prop('disabled', true)\n        .parent()\n        .addClass('disabled');\n    },\n\n    _initTemplates: function () {\n      var options = this.options;\n      options.templatesContainer = this.document[0].createElement(\n        options.filesContainer.prop('nodeName')\n      );\n      if (tmpl) {\n        if (options.uploadTemplateId) {\n          options.uploadTemplate = tmpl(options.uploadTemplateId);\n        }\n        if (options.downloadTemplateId) {\n          options.downloadTemplate = tmpl(options.downloadTemplateId);\n        }\n      }\n    },\n\n    _initFilesContainer: function () {\n      var options = this.options;\n      if (options.filesContainer === undefined) {\n        options.filesContainer = this.element.find('.files');\n      } else if (!(options.filesContainer instanceof $)) {\n        options.filesContainer = $(options.filesContainer);\n      }\n    },\n\n    _initSpecialOptions: function () {\n      this._super();\n      this._initFilesContainer();\n      // this._initTemplates();\n    },\n\n    _create: function () {\n      this._super();\n      this._resetFinishedDeferreds();\n      if (!$.support.fileInput) {\n        this._disableFileInputButton();\n      }\n    },\n\n    enable: function () {\n      var wasDisabled = false;\n      if (this.options.disabled) {\n        wasDisabled = true;\n      }\n      this._super();\n      if (wasDisabled) {\n        this.element.find('input, button').prop('disabled', false);\n        this._enableFileInputButton();\n      }\n    },\n\n    disable: function () {\n      if (!this.options.disabled) {\n        this.element.find('input, button').prop('disabled', true);\n        this._disableFileInputButton();\n      }\n      this._super();\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload-video.js":"/*\n * jQuery File Upload Video Preview Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/jquery.fileupload-process'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'),\n      require('jquery/fileUploader/jquery.fileupload-process')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery, window.loadImage);\n  }\n})(function ($, loadImage) {\n  'use strict';\n\n  // Prepend to the default processQueue:\n  $.blueimp.fileupload.prototype.options.processQueue.unshift(\n    {\n      action: 'loadVideo',\n      // Use the action as prefix for the \"@\" options:\n      prefix: true,\n      fileTypes: '@',\n      maxFileSize: '@',\n      disabled: '@disableVideoPreview'\n    },\n    {\n      action: 'setVideo',\n      name: '@videoPreviewName',\n      disabled: '@disableVideoPreview'\n    }\n  );\n\n  // The File Upload Video Preview plugin extends the fileupload widget\n  // with video preview functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // The regular expression for the types of video files to load,\n      // matched against the file type:\n      loadVideoFileTypes: /^video\\/.*$/\n    },\n\n    _videoElement: document.createElement('video'),\n\n    processActions: {\n      // Loads the video file given via data.files and data.index\n      // as video element if the browser supports playing it.\n      // Accepts the options fileTypes (regular expression)\n      // and maxFileSize (integer) to limit the files to load:\n      loadVideo: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        var file = data.files[data.index],\n          url,\n          video;\n        if (\n          this._videoElement.canPlayType &&\n          this._videoElement.canPlayType(file.type) &&\n          ($.type(options.maxFileSize) !== 'number' ||\n            file.size <= options.maxFileSize) &&\n          (!options.fileTypes || options.fileTypes.test(file.type))\n        ) {\n          url = loadImage.createObjectURL(file);\n          if (url) {\n            video = this._videoElement.cloneNode(false);\n            video.src = url;\n            video.controls = true;\n            data.video = video;\n            return data;\n          }\n        }\n        return data;\n      },\n\n      // Sets the video element as a property of the file object:\n      setVideo: function (data, options) {\n        if (data.video && !options.disabled) {\n          data.files[data.index][options.name || 'preview'] = data.video;\n        }\n        return data;\n      }\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload-image.js":"/*\n * jQuery File Upload Image Preview & Resize Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define([\n      'jquery',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif',\n      'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-orientation',\n      'jquery/fileUploader/vendor/blueimp-canvas-to-blob/js/canvas-to-blob',\n      'jquery/fileUploader/jquery.fileupload-process'\n    ], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-orientation'),\n      require('jquery/fileUploader/vendor/blueimp-canvas-to-blob/js/canvas-to-blob'),\n      require('jquery/fileUploader/jquery.fileupload-process')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery, window.loadImage);\n  }\n})(function ($, loadImage) {\n  'use strict';\n\n  // Prepend to the default processQueue:\n  $.blueimp.fileupload.prototype.options.processQueue.unshift(\n    {\n      action: 'loadImageMetaData',\n      maxMetaDataSize: '@',\n      disableImageHead: '@',\n      disableMetaDataParsers: '@',\n      disableExif: '@',\n      disableExifOffsets: '@',\n      includeExifTags: '@',\n      excludeExifTags: '@',\n      disableIptc: '@',\n      disableIptcOffsets: '@',\n      includeIptcTags: '@',\n      excludeIptcTags: '@',\n      disabled: '@disableImageMetaDataLoad'\n    },\n    {\n      action: 'loadImage',\n      // Use the action as prefix for the \"@\" options:\n      prefix: true,\n      fileTypes: '@',\n      maxFileSize: '@',\n      noRevoke: '@',\n      disabled: '@disableImageLoad'\n    },\n    {\n      action: 'resizeImage',\n      // Use \"image\" as prefix for the \"@\" options:\n      prefix: 'image',\n      maxWidth: '@',\n      maxHeight: '@',\n      minWidth: '@',\n      minHeight: '@',\n      crop: '@',\n      orientation: '@',\n      forceResize: '@',\n      disabled: '@disableImageResize'\n    },\n    {\n      action: 'saveImage',\n      quality: '@imageQuality',\n      type: '@imageType',\n      disabled: '@disableImageResize'\n    },\n    {\n      action: 'saveImageMetaData',\n      disabled: '@disableImageMetaDataSave'\n    },\n    {\n      action: 'resizeImage',\n      // Use \"preview\" as prefix for the \"@\" options:\n      prefix: 'preview',\n      maxWidth: '@',\n      maxHeight: '@',\n      minWidth: '@',\n      minHeight: '@',\n      crop: '@',\n      orientation: '@',\n      thumbnail: '@',\n      canvas: '@',\n      disabled: '@disableImagePreview'\n    },\n    {\n      action: 'setImage',\n      name: '@imagePreviewName',\n      disabled: '@disableImagePreview'\n    },\n    {\n      action: 'deleteImageReferences',\n      disabled: '@disableImageReferencesDeletion'\n    }\n  );\n\n  // The File Upload Resize plugin extends the fileupload widget\n  // with image resize functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // The regular expression for the types of images to load:\n      // matched against the file type:\n      loadImageFileTypes: /^image\\/(gif|jpeg|png|svg\\+xml)$/,\n      // The maximum file size of images to load:\n      loadImageMaxFileSize: 10000000, // 10MB\n      // The maximum width of resized images:\n      imageMaxWidth: 1920,\n      // The maximum height of resized images:\n      imageMaxHeight: 1080,\n      // Defines the image orientation (1-8) or takes the orientation\n      // value from Exif data if set to true:\n      imageOrientation: true,\n      // Define if resized images should be cropped or only scaled:\n      imageCrop: false,\n      // Disable the resize image functionality by default:\n      disableImageResize: true,\n      // The maximum width of the preview images:\n      previewMaxWidth: 80,\n      // The maximum height of the preview images:\n      previewMaxHeight: 80,\n      // Defines the preview orientation (1-8) or takes the orientation\n      // value from Exif data if set to true:\n      previewOrientation: true,\n      // Create the preview using the Exif data thumbnail:\n      previewThumbnail: true,\n      // Define if preview images should be cropped or only scaled:\n      previewCrop: false,\n      // Define if preview images should be resized as canvas elements:\n      previewCanvas: true\n    },\n\n    processActions: {\n      // Loads the image given via data.files and data.index\n      // as img element, if the browser supports the File API.\n      // Accepts the options fileTypes (regular expression)\n      // and maxFileSize (integer) to limit the files to load:\n      loadImage: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        var that = this,\n          file = data.files[data.index],\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred();\n        if (\n          ($.type(options.maxFileSize) === 'number' &&\n            file.size > options.maxFileSize) ||\n          (options.fileTypes && !options.fileTypes.test(file.type)) ||\n          !loadImage(\n            file,\n            function (img) {\n              if (img.src) {\n                data.img = img;\n              }\n              dfd.resolveWith(that, [data]);\n            },\n            options\n          )\n        ) {\n          return data;\n        }\n        return dfd.promise();\n      },\n\n      // Resizes the image given as data.canvas or data.img\n      // and updates data.canvas or data.img with the resized image.\n      // Also stores the resized image as preview property.\n      // Accepts the options maxWidth, maxHeight, minWidth,\n      // minHeight, canvas and crop:\n      resizeImage: function (data, options) {\n        if (options.disabled || !(data.canvas || data.img)) {\n          return data;\n        }\n        // eslint-disable-next-line no-param-reassign\n        options = $.extend({ canvas: true }, options);\n        var that = this,\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred(),\n          img = (options.canvas && data.canvas) || data.img,\n          resolve = function (newImg) {\n            if (\n              newImg &&\n              (newImg.width !== img.width ||\n                newImg.height !== img.height ||\n                options.forceResize)\n            ) {\n              data[newImg.getContext ? 'canvas' : 'img'] = newImg;\n            }\n            data.preview = newImg;\n            dfd.resolveWith(that, [data]);\n          },\n          thumbnail,\n          thumbnailBlob;\n        if (data.exif && options.thumbnail) {\n          thumbnail = data.exif.get('Thumbnail');\n          thumbnailBlob = thumbnail && thumbnail.get('Blob');\n          if (thumbnailBlob) {\n            options.orientation = data.exif.get('Orientation');\n            loadImage(thumbnailBlob, resolve, options);\n            return dfd.promise();\n          }\n        }\n        if (data.orientation) {\n          // Prevent orienting the same image twice:\n          delete options.orientation;\n        } else {\n          data.orientation = options.orientation || loadImage.orientation;\n        }\n        if (img) {\n          resolve(loadImage.scale(img, options, data));\n          return dfd.promise();\n        }\n        return data;\n      },\n\n      // Saves the processed image given as data.canvas\n      // inplace at data.index of data.files:\n      saveImage: function (data, options) {\n        if (!data.canvas || options.disabled) {\n          return data;\n        }\n        var that = this,\n          file = data.files[data.index],\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred();\n        if (data.canvas.toBlob) {\n          data.canvas.toBlob(\n            function (blob) {\n              if (!blob.name) {\n                if (file.type === blob.type) {\n                  blob.name = file.name;\n                } else if (file.name) {\n                  blob.name = file.name.replace(\n                    /\\.\\w+$/,\n                    '.' + blob.type.substr(6)\n                  );\n                }\n              }\n              // Don't restore invalid meta data:\n              if (file.type !== blob.type) {\n                delete data.imageHead;\n              }\n              // Store the created blob at the position\n              // of the original file in the files list:\n              data.files[data.index] = blob;\n              dfd.resolveWith(that, [data]);\n            },\n            options.type || file.type,\n            options.quality\n          );\n        } else {\n          return data;\n        }\n        return dfd.promise();\n      },\n\n      loadImageMetaData: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        var that = this,\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred();\n        loadImage.parseMetaData(\n          data.files[data.index],\n          function (result) {\n            $.extend(data, result);\n            dfd.resolveWith(that, [data]);\n          },\n          options\n        );\n        return dfd.promise();\n      },\n\n      saveImageMetaData: function (data, options) {\n        if (\n          !(\n            data.imageHead &&\n            data.canvas &&\n            data.canvas.toBlob &&\n            !options.disabled\n          )\n        ) {\n          return data;\n        }\n        var that = this,\n          file = data.files[data.index],\n          // eslint-disable-next-line new-cap\n          dfd = $.Deferred();\n        if (data.orientation === true && data.exifOffsets) {\n          // Reset Exif Orientation data:\n          loadImage.writeExifData(data.imageHead, data, 'Orientation', 1);\n        }\n        loadImage.replaceHead(file, data.imageHead, function (blob) {\n          blob.name = file.name;\n          data.files[data.index] = blob;\n          dfd.resolveWith(that, [data]);\n        });\n        return dfd.promise();\n      },\n\n      // Sets the resized version of the image as a property of the\n      // file object, must be called after \"saveImage\":\n      setImage: function (data, options) {\n        if (data.preview && !options.disabled) {\n          data.files[data.index][options.name || 'preview'] = data.preview;\n        }\n        return data;\n      },\n\n      deleteImageReferences: function (data, options) {\n        if (!options.disabled) {\n          delete data.img;\n          delete data.canvas;\n          delete data.preview;\n          delete data.imageHead;\n        }\n        return data;\n      }\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileuploader.js":"/**\n * Custom Uploader\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define([\n      'jquery',\n      'jquery/fileUploader/jquery.fileupload-image',\n      'jquery/fileUploader/jquery.fileupload-audio',\n      'jquery/fileUploader/jquery.fileupload-video',\n      'jquery/fileUploader/jquery.iframe-transport',\n    ], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/jquery.fileupload-image'),\n      require('jquery/fileUploader/jquery.fileupload-audio'),\n      require('jquery/fileUploader/jquery.fileupload-video'),\n      require('jquery/fileUploader/jquery.iframe-transport')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})();\n","jquery/fileUploader/jquery.fileupload-process.js":"/*\n * jQuery File Upload Processing Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2012, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/jquery.fileupload'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'), require('jquery/fileUploader/jquery.fileupload'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  var originalAdd = $.blueimp.fileupload.prototype.options.add;\n\n  // The File Upload Processing plugin extends the fileupload widget\n  // with file processing functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // The list of processing actions:\n      processQueue: [\n        /*\n                {\n                    action: 'log',\n                    type: 'debug'\n                }\n                */\n      ],\n      add: function (e, data) {\n        var $this = $(this);\n        data.process(function () {\n          return $this.fileupload('process', data);\n        });\n        originalAdd.call(this, e, data);\n      }\n    },\n\n    processActions: {\n      /*\n            log: function (data, options) {\n                console[options.type](\n                    'Processing \"' + data.files[data.index].name + '\"'\n                );\n            }\n            */\n    },\n\n    _processFile: function (data, originalData) {\n      var that = this,\n        // eslint-disable-next-line new-cap\n        dfd = $.Deferred().resolveWith(that, [data]),\n        chain = dfd.promise();\n      this._trigger('process', null, data);\n      $.each(data.processQueue, function (i, settings) {\n        var func = function (data) {\n          if (originalData.errorThrown) {\n            // eslint-disable-next-line new-cap\n            return $.Deferred().rejectWith(that, [originalData]).promise();\n          }\n          return that.processActions[settings.action].call(\n            that,\n            data,\n            settings\n          );\n        };\n        chain = chain[that._promisePipe](func, settings.always && func);\n      });\n      chain\n        .done(function () {\n          that._trigger('processdone', null, data);\n          that._trigger('processalways', null, data);\n        })\n        .fail(function () {\n          that._trigger('processfail', null, data);\n          that._trigger('processalways', null, data);\n        });\n      return chain;\n    },\n\n    // Replaces the settings of each processQueue item that\n    // are strings starting with an \"@\", using the remaining\n    // substring as key for the option map,\n    // e.g. \"@autoUpload\" is replaced with options.autoUpload:\n    _transformProcessQueue: function (options) {\n      var processQueue = [];\n      $.each(options.processQueue, function () {\n        var settings = {},\n          action = this.action,\n          prefix = this.prefix === true ? action : this.prefix;\n        $.each(this, function (key, value) {\n          if ($.type(value) === 'string' && value.charAt(0) === '@') {\n            settings[key] =\n              options[\n                value.slice(1) ||\n                  (prefix\n                    ? prefix + key.charAt(0).toUpperCase() + key.slice(1)\n                    : key)\n              ];\n          } else {\n            settings[key] = value;\n          }\n        });\n        processQueue.push(settings);\n      });\n      options.processQueue = processQueue;\n    },\n\n    // Returns the number of files currently in the processsing queue:\n    processing: function () {\n      return this._processing;\n    },\n\n    // Processes the files given as files property of the data parameter,\n    // returns a Promise object that allows to bind callbacks:\n    process: function (data) {\n      var that = this,\n        options = $.extend({}, this.options, data);\n      if (options.processQueue && options.processQueue.length) {\n        this._transformProcessQueue(options);\n        if (this._processing === 0) {\n          this._trigger('processstart');\n        }\n        $.each(data.files, function (index) {\n          var opts = index ? $.extend({}, options) : options,\n            func = function () {\n              if (data.errorThrown) {\n                // eslint-disable-next-line new-cap\n                return $.Deferred().rejectWith(that, [data]).promise();\n              }\n              return that._processFile(opts, data);\n            };\n          opts.index = index;\n          that._processing += 1;\n          that._processingQueue = that._processingQueue[that._promisePipe](\n            func,\n            func\n          ).always(function () {\n            that._processing -= 1;\n            if (that._processing === 0) {\n              that._trigger('processstop');\n            }\n          });\n        });\n      }\n      return this._processingQueue;\n    },\n\n    _create: function () {\n      this._super();\n      this._processing = 0;\n      // eslint-disable-next-line new-cap\n      this._processingQueue = $.Deferred().resolveWith(this).promise();\n    }\n  });\n});\n","jquery/fileUploader/jquery.iframe-transport.js":"/*\n * jQuery Iframe Transport Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  // Helper variable to create unique names for the transport iframes:\n  var counter = 0,\n    jsonAPI = $,\n    jsonParse = 'parseJSON';\n\n  if ('JSON' in window && 'parse' in JSON) {\n    jsonAPI = JSON;\n    jsonParse = 'parse';\n  }\n\n  // The iframe transport accepts four additional options:\n  // options.fileInput: a jQuery collection of file input fields\n  // options.paramName: the parameter name for the file form data,\n  //  overrides the name property of the file input field(s),\n  //  can be a string or an array of strings.\n  // options.formData: an array of objects with name and value properties,\n  //  equivalent to the return data of .serializeArray(), e.g.:\n  //  [{name: 'a', value: 1}, {name: 'b', value: 2}]\n  // options.initialIframeSrc: the URL of the initial iframe src,\n  //  by default set to \"javascript:false;\"\n  $.ajaxTransport('iframe', function (options) {\n    if (options.async) {\n      // javascript:false as initial iframe src\n      // prevents warning popups on HTTPS in IE6:\n      // eslint-disable-next-line no-script-url\n      var initialIframeSrc = options.initialIframeSrc || 'javascript:false;',\n        form,\n        iframe,\n        addParamChar;\n      return {\n        send: function (_, completeCallback) {\n          form = $('<form style=\"display:none;\"></form>');\n          form.attr('accept-charset', options.formAcceptCharset);\n          addParamChar = /\\?/.test(options.url) ? '&' : '?';\n          // XDomainRequest only supports GET and POST:\n          if (options.type === 'DELETE') {\n            options.url = options.url + addParamChar + '_method=DELETE';\n            options.type = 'POST';\n          } else if (options.type === 'PUT') {\n            options.url = options.url + addParamChar + '_method=PUT';\n            options.type = 'POST';\n          } else if (options.type === 'PATCH') {\n            options.url = options.url + addParamChar + '_method=PATCH';\n            options.type = 'POST';\n          }\n          // IE versions below IE8 cannot set the name property of\n          // elements that have already been added to the DOM,\n          // so we set the name along with the iframe HTML markup:\n          counter += 1;\n          iframe = $(\n            '<iframe src=\"' +\n              initialIframeSrc +\n              '\" name=\"iframe-transport-' +\n              counter +\n              '\"></iframe>'\n          ).on('load', function () {\n            var fileInputClones,\n              paramNames = $.isArray(options.paramName)\n                ? options.paramName\n                : [options.paramName];\n            iframe.off('load').on('load', function () {\n              var response;\n              // Wrap in a try/catch block to catch exceptions thrown\n              // when trying to access cross-domain iframe contents:\n              try {\n                response = iframe.contents();\n                // Google Chrome and Firefox do not throw an\n                // exception when calling iframe.contents() on\n                // cross-domain requests, so we unify the response:\n                if (!response.length || !response[0].firstChild) {\n                  throw new Error();\n                }\n              } catch (e) {\n                response = undefined;\n              }\n              // The complete callback returns the\n              // iframe content document as response object:\n              completeCallback(200, 'success', { iframe: response });\n              // Fix for IE endless progress bar activity bug\n              // (happens on form submits to iframe targets):\n              $('<iframe src=\"' + initialIframeSrc + '\"></iframe>').appendTo(\n                form\n              );\n              window.setTimeout(function () {\n                // Removing the form in a setTimeout call\n                // allows Chrome's developer tools to display\n                // the response result\n                form.remove();\n              }, 0);\n            });\n            form\n              .prop('target', iframe.prop('name'))\n              .prop('action', options.url)\n              .prop('method', options.type);\n            if (options.formData) {\n              $.each(options.formData, function (index, field) {\n                $('<input type=\"hidden\"/>')\n                  .prop('name', field.name)\n                  .val(field.value)\n                  .appendTo(form);\n              });\n            }\n            if (\n              options.fileInput &&\n              options.fileInput.length &&\n              options.type === 'POST'\n            ) {\n              fileInputClones = options.fileInput.clone();\n              // Insert a clone for each file input field:\n              options.fileInput.after(function (index) {\n                return fileInputClones[index];\n              });\n              if (options.paramName) {\n                options.fileInput.each(function (index) {\n                  $(this).prop('name', paramNames[index] || options.paramName);\n                });\n              }\n              // Appending the file input fields to the hidden form\n              // removes them from their original location:\n              form\n                .append(options.fileInput)\n                .prop('enctype', 'multipart/form-data')\n                // enctype must be set as encoding for IE:\n                .prop('encoding', 'multipart/form-data');\n              // Remove the HTML5 form attribute from the input(s):\n              options.fileInput.removeAttr('form');\n            }\n            window.setTimeout(function () {\n              // Submitting the form in a setTimeout call fixes an issue with\n              // Safari 13 not triggering the iframe load event after resetting\n              // the load event handler, see also:\n              // https://github.com/blueimp/jQuery-File-Upload/issues/3633\n              form.submit();\n              // Insert the file input fields at their original location\n              // by replacing the clones with the originals:\n              if (fileInputClones && fileInputClones.length) {\n                options.fileInput.each(function (index, input) {\n                  var clone = $(fileInputClones[index]);\n                  // Restore the original name and form properties:\n                  $(input)\n                    .prop('name', clone.prop('name'))\n                    .attr('form', clone.attr('form'));\n                  clone.replaceWith(input);\n                });\n              }\n            }, 0);\n          });\n          form.append(iframe).appendTo(document.body);\n        },\n        abort: function () {\n          if (iframe) {\n            // javascript:false as iframe src aborts the request\n            // and prevents warning popups on HTTPS in IE6.\n            iframe.off('load').prop('src', initialIframeSrc);\n          }\n          if (form) {\n            form.remove();\n          }\n        }\n      };\n    }\n  });\n\n  // The iframe transport returns the iframe content document as response.\n  // The following adds converters from iframe to text, json, html, xml\n  // and script.\n  // Please note that the Content-Type for JSON responses has to be text/plain\n  // or text/html, if the browser doesn't include application/json in the\n  // Accept header, else IE will show a download dialog.\n  // The Content-Type for XML responses on the other hand has to be always\n  // application/xml or text/xml, so IE properly parses the XML response.\n  // See also\n  // https://github.com/blueimp/jQuery-File-Upload/wiki/Setup#content-type-negotiation\n  $.ajaxSetup({\n    converters: {\n      'iframe text': function (iframe) {\n        return iframe && $(iframe[0].body).text();\n      },\n      'iframe json': function (iframe) {\n        return iframe && jsonAPI[jsonParse]($(iframe[0].body).text());\n      },\n      'iframe html': function (iframe) {\n        return iframe && $(iframe[0].body).html();\n      },\n      'iframe xml': function (iframe) {\n        var xmlDoc = iframe && iframe[0];\n        return xmlDoc && $.isXMLDoc(xmlDoc)\n          ? xmlDoc\n          : $.parseXML(\n              (xmlDoc.XMLDocument && xmlDoc.XMLDocument.xml) ||\n                $(xmlDoc.body).html()\n            );\n      },\n      'iframe script': function (iframe) {\n        return iframe && $.globalEval($(iframe[0].body).text());\n      }\n    }\n  });\n});\n","jquery/fileUploader/jquery.fileupload-audio.js":"/*\n * jQuery File Upload Audio Preview Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/jquery.fileupload-process'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(\n      require('jquery'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'),\n      require('jquery/fileUploader/jquery.fileupload-process')\n    );\n  } else {\n    // Browser globals:\n    factory(window.jQuery, window.loadImage);\n  }\n})(function ($, loadImage) {\n  'use strict';\n\n  // Prepend to the default processQueue:\n  $.blueimp.fileupload.prototype.options.processQueue.unshift(\n    {\n      action: 'loadAudio',\n      // Use the action as prefix for the \"@\" options:\n      prefix: true,\n      fileTypes: '@',\n      maxFileSize: '@',\n      disabled: '@disableAudioPreview'\n    },\n    {\n      action: 'setAudio',\n      name: '@audioPreviewName',\n      disabled: '@disableAudioPreview'\n    }\n  );\n\n  // The File Upload Audio Preview plugin extends the fileupload widget\n  // with audio preview functionality:\n  $.widget('blueimp.fileupload', $.blueimp.fileupload, {\n    options: {\n      // The regular expression for the types of audio files to load,\n      // matched against the file type:\n      loadAudioFileTypes: /^audio\\/.*$/\n    },\n\n    _audioElement: document.createElement('audio'),\n\n    processActions: {\n      // Loads the audio file given via data.files and data.index\n      // as audio element if the browser supports playing it.\n      // Accepts the options fileTypes (regular expression)\n      // and maxFileSize (integer) to limit the files to load:\n      loadAudio: function (data, options) {\n        if (options.disabled) {\n          return data;\n        }\n        var file = data.files[data.index],\n          url,\n          audio;\n        if (\n          this._audioElement.canPlayType &&\n          this._audioElement.canPlayType(file.type) &&\n          ($.type(options.maxFileSize) !== 'number' ||\n            file.size <= options.maxFileSize) &&\n          (!options.fileTypes || options.fileTypes.test(file.type))\n        ) {\n          url = loadImage.createObjectURL(file);\n          if (url) {\n            audio = this._audioElement.cloneNode(false);\n            audio.src = url;\n            audio.controls = true;\n            data.audio = audio;\n            return data;\n          }\n        }\n        return data;\n      },\n\n      // Sets the audio element as a property of the file object:\n      setAudio: function (data, options) {\n        if (data.audio && !options.disabled) {\n          data.files[data.index][options.name || 'preview'] = data.audio;\n        }\n        return data;\n      }\n    }\n  });\n});\n","jquery/fileUploader/cors/jquery.xdr-transport.js":"/*\n * jQuery XDomainRequest Transport Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n *\n * Based on Julian Aubourg's ajaxHooks xdr.js:\n * https://github.com/jaubourg/ajaxHooks/\n */\n\n/* global define, require, XDomainRequest */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n  if (window.XDomainRequest && !$.support.cors) {\n    $.ajaxTransport(function (s) {\n      if (s.crossDomain && s.async) {\n        if (s.timeout) {\n          s.xdrTimeout = s.timeout;\n          delete s.timeout;\n        }\n        var xdr;\n        return {\n          send: function (headers, completeCallback) {\n            var addParamChar = /\\?/.test(s.url) ? '&' : '?';\n            /**\n             * Callback wrapper function\n             *\n             * @param {number} status HTTP status code\n             * @param {string} statusText HTTP status text\n             * @param {object} [responses] Content-type specific responses\n             * @param {string} [responseHeaders] Response headers string\n             */\n            function callback(status, statusText, responses, responseHeaders) {\n              xdr.onload = xdr.onerror = xdr.ontimeout = $.noop;\n              xdr = null;\n              completeCallback(status, statusText, responses, responseHeaders);\n            }\n            xdr = new XDomainRequest();\n            // XDomainRequest only supports GET and POST:\n            if (s.type === 'DELETE') {\n              s.url = s.url + addParamChar + '_method=DELETE';\n              s.type = 'POST';\n            } else if (s.type === 'PUT') {\n              s.url = s.url + addParamChar + '_method=PUT';\n              s.type = 'POST';\n            } else if (s.type === 'PATCH') {\n              s.url = s.url + addParamChar + '_method=PATCH';\n              s.type = 'POST';\n            }\n            xdr.open(s.type, s.url);\n            xdr.onload = function () {\n              callback(\n                200,\n                'OK',\n                { text: xdr.responseText },\n                'Content-Type: ' + xdr.contentType\n              );\n            };\n            xdr.onerror = function () {\n              callback(404, 'Not Found');\n            };\n            if (s.xdrTimeout) {\n              xdr.ontimeout = function () {\n                callback(0, 'timeout');\n              };\n              xdr.timeout = s.xdrTimeout;\n            }\n            xdr.send((s.hasContent && s.data) || null);\n          },\n          abort: function () {\n            if (xdr) {\n              xdr.onerror = $.noop();\n              xdr.abort();\n            }\n          }\n        };\n      }\n    });\n  }\n});\n","jquery/fileUploader/cors/jquery.postmessage-transport.js":"/*\n * jQuery postMessage Transport Plugin\n * https://github.com/blueimp/jQuery-File-Upload\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, require */\n\n(function (factory) {\n  'use strict';\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery'], factory);\n  } else if (typeof exports === 'object') {\n    // Node/CommonJS:\n    factory(require('jquery'));\n  } else {\n    // Browser globals:\n    factory(window.jQuery);\n  }\n})(function ($) {\n  'use strict';\n\n  var counter = 0,\n    names = [\n      'accepts',\n      'cache',\n      'contents',\n      'contentType',\n      'crossDomain',\n      'data',\n      'dataType',\n      'headers',\n      'ifModified',\n      'mimeType',\n      'password',\n      'processData',\n      'timeout',\n      'traditional',\n      'type',\n      'url',\n      'username'\n    ],\n    convert = function (p) {\n      return p;\n    };\n\n  $.ajaxSetup({\n    converters: {\n      'postmessage text': convert,\n      'postmessage json': convert,\n      'postmessage html': convert\n    }\n  });\n\n  $.ajaxTransport('postmessage', function (options) {\n    if (options.postMessage && window.postMessage) {\n      var iframe,\n        loc = $('<a></a>').prop('href', options.postMessage)[0],\n        target = loc.protocol + '//' + loc.host,\n        xhrUpload = options.xhr().upload;\n      // IE always includes the port for the host property of a link\n      // element, but not in the location.host or origin property for the\n      // default http port 80 and https port 443, so we strip it:\n      if (/^(http:\\/\\/.+:80)|(https:\\/\\/.+:443)$/.test(target)) {\n        target = target.replace(/:(80|443)$/, '');\n      }\n      return {\n        send: function (_, completeCallback) {\n          counter += 1;\n          var message = {\n              id: 'postmessage-transport-' + counter\n            },\n            eventName = 'message.' + message.id;\n          iframe = $(\n            '<iframe style=\"display:none;\" src=\"' +\n              options.postMessage +\n              '\" name=\"' +\n              message.id +\n              '\"></iframe>'\n          )\n            .on('load', function () {\n              $.each(names, function (i, name) {\n                message[name] = options[name];\n              });\n              message.dataType = message.dataType.replace('postmessage ', '');\n              $(window).on(eventName, function (event) {\n                var e = event.originalEvent;\n                var data = e.data;\n                var ev;\n                if (e.origin === target && data.id === message.id) {\n                  if (data.type === 'progress') {\n                    ev = document.createEvent('Event');\n                    ev.initEvent(data.type, false, true);\n                    $.extend(ev, data);\n                    xhrUpload.dispatchEvent(ev);\n                  } else {\n                    completeCallback(\n                      data.status,\n                      data.statusText,\n                      { postmessage: data.result },\n                      data.headers\n                    );\n                    iframe.remove();\n                    $(window).off(eventName);\n                  }\n                }\n              });\n              iframe[0].contentWindow.postMessage(message, target);\n            })\n            .appendTo(document.body);\n        },\n        abort: function () {\n          if (iframe) {\n            iframe.remove();\n          }\n        }\n      };\n    }\n  });\n});\n","jquery/fileUploader/vendor/jquery.ui.widget.js":"/*! jQuery UI - v1.13.2\n * http://jqueryui.com\n * Includes: widget.js\n * Copyright jQuery Foundation and other contributors; Licensed MIT */\n\n/* global define, require */\n/* eslint-disable no-param-reassign, new-cap, jsdoc/require-jsdoc */\n\n(function (factory) {\n    'use strict';\n    if (typeof define === 'function' && define.amd) {\n        // AMD. Register as an anonymous module.\n        define(['jquery'], factory);\n    } else if (typeof exports === 'object') {\n        // Node/CommonJS\n        factory(require('jquery'));\n    } else {\n        // Browser globals\n        factory(window.jQuery);\n    }\n})(function ($) {\n    ('use strict');\n\n    $.ui = $.ui || {};\n\n    $.ui.version = '1.13.2';\n\n    /*!\n     * jQuery UI Widget 1.13.2\n     * http://jqueryui.com\n     *\n     * Copyright jQuery Foundation and other contributors\n     * Released under the MIT license.\n     * http://jquery.org/license\n     */\n\n    //>>label: Widget\n    //>>group: Core\n    //>>description: Provides a factory for creating stateful widgets with a common API.\n    //>>docs: http://api.jqueryui.com/jQuery.widget/\n    //>>demos: http://jqueryui.com/widget/\n\n    // Support: jQuery 1.9.x or older\n    // $.expr[ \":\" ] is deprecated.\n    if (!$.expr.pseudos) {\n        $.expr.pseudos = $.expr[':'];\n    }\n\n    // Support: jQuery 1.11.x or older\n    // $.unique has been renamed to $.uniqueSort\n    if (!$.uniqueSort) {\n        $.uniqueSort = $.unique;\n    }\n    var widgetUuid = 0;\n    var widgetHasOwnProperty = Array.prototype.hasOwnProperty;\n    var widgetSlice = Array.prototype.slice;\n\n    $.cleanData = (function (orig) {\n        return function (elems) {\n            var events, elem, i;\n            for (i = 0; (elem = elems[i]) != null; i++) {\n                // Only trigger remove when necessary to save time\n                events = $._data(elem, 'events');\n                if (events && events.remove) {\n                    $(elem).triggerHandler('remove');\n                }\n            }\n            orig(elems);\n        };\n    })($.cleanData);\n\n    $.widget = function (name, base, prototype) {\n        var existingConstructor, constructor, basePrototype;\n\n        // ProxiedPrototype allows the provided prototype to remain unmodified\n        // so that it can be used as a mixin for multiple widgets (#8876)\n        var proxiedPrototype = {};\n\n        var namespace = name.split('.')[0];\n        // eslint-disable-next-line no-param-reassign\n        name = name.split('.')[1];\n        var fullName = namespace + '-' + name;\n\n        if (!prototype) {\n            prototype = base;\n            base = $.Widget;\n        }\n\n        if (Array.isArray(prototype)) {\n            prototype = $.extend.apply(null, [{}].concat(prototype));\n        }\n\n        // Create selector for plugin\n        $.expr.pseudos[fullName.toLowerCase()] = function (elem) {\n            return !!$.data(elem, fullName);\n        };\n\n        $[namespace] = $[namespace] || {};\n        existingConstructor = $[namespace][name];\n        constructor = $[namespace][name] = function (options, element) {\n            // Allow instantiation without \"new\" keyword\n            if (!this || !this._createWidget) {\n                return new constructor(options, element);\n            }\n\n            // Allow instantiation without initializing for simple inheritance\n            // must use \"new\" keyword (the code above always passes args)\n            if (arguments.length) {\n                this._createWidget(options, element);\n            }\n        };\n\n        // Extend with the existing constructor to carry over any static properties\n        $.extend(constructor, existingConstructor, {\n            version: prototype.version,\n\n            // Copy the object used to create the prototype in case we need to\n            // redefine the widget later\n            _proto: $.extend({}, prototype),\n\n            // Track widgets that inherit from this widget in case this widget is\n            // redefined after a widget inherits from it\n            _childConstructors: []\n        });\n\n        basePrototype = new base();\n\n        // We need to make the options hash a property directly on the new instance\n        // otherwise we'll modify the options hash on the prototype that we're\n        // inheriting from\n        basePrototype.options = $.widget.extend({}, basePrototype.options);\n        $.each(prototype, function (prop, value) {\n            if (typeof value !== 'function') {\n                proxiedPrototype[prop] = value;\n                return;\n            }\n            proxiedPrototype[prop] = (function () {\n                /**\n                 *\n                 */\n                function _super() {\n                    return base.prototype[prop].apply(this, arguments);\n                }\n\n                /**\n                 * @param args\n                 */\n                function _superApply(args) {\n                    return base.prototype[prop].apply(this, args);\n                }\n\n                return function () {\n                    var __super = this._super;\n                    var __superApply = this._superApply;\n                    var returnValue;\n\n                    this._super = _super;\n                    this._superApply = _superApply;\n\n                    returnValue = value.apply(this, arguments);\n\n                    this._super = __super;\n                    this._superApply = __superApply;\n\n                    return returnValue;\n                };\n            })();\n        });\n        constructor.prototype = $.widget.extend(\n            basePrototype,\n            {\n                // TODO: remove support for widgetEventPrefix\n                // always use the name + a colon as the prefix, e.g., draggable:start\n                // don't prefix for widgets that aren't DOM-based\n                widgetEventPrefix: existingConstructor\n                    ? basePrototype.widgetEventPrefix || name\n                    : name\n            },\n            proxiedPrototype,\n            {\n                constructor: constructor,\n                namespace: namespace,\n                widgetName: name,\n                widgetFullName: fullName\n            }\n        );\n\n        // If this widget is being redefined then we need to find all widgets that\n        // are inheriting from it and redefine all of them so that they inherit from\n        // the new version of this widget. We're essentially trying to replace one\n        // level in the prototype chain.\n        if (existingConstructor) {\n            $.each(existingConstructor._childConstructors, function (i, child) {\n                var childPrototype = child.prototype;\n\n                // Redefine the child widget using the same prototype that was\n                // originally used, but inherit from the new version of the base\n                $.widget(\n                    childPrototype.namespace + '.' + childPrototype.widgetName,\n                    constructor,\n                    child._proto\n                );\n            });\n\n            // Remove the list of existing child constructors from the old constructor\n            // so the old child constructors can be garbage collected\n            delete existingConstructor._childConstructors;\n        } else {\n            base._childConstructors.push(constructor);\n        }\n\n        $.widget.bridge(name, constructor);\n\n        return constructor;\n    };\n\n    $.widget.extend = function (target) {\n        var input = widgetSlice.call(arguments, 1);\n        var inputIndex = 0;\n        var inputLength = input.length;\n        var key;\n        var value;\n\n        for (; inputIndex < inputLength; inputIndex++) {\n            for (key in input[inputIndex]) {\n                value = input[inputIndex][key];\n                if (\n                    widgetHasOwnProperty.call(input[inputIndex], key) &&\n                    value !== undefined\n                ) {\n                    // Clone objects\n                    if ($.isPlainObject(value)) {\n                        target[key] = $.isPlainObject(target[key])\n                            ? $.widget.extend({}, target[key], value)\n                            : // Don't extend strings, arrays, etc. with objects\n                            $.widget.extend({}, value);\n\n                        // Copy everything else by reference\n                    } else {\n                        target[key] = value;\n                    }\n                }\n            }\n        }\n        return target;\n    };\n\n    $.widget.bridge = function (name, object) {\n        var fullName = object.prototype.widgetFullName || name;\n        $.fn[name] = function (options) {\n            var isMethodCall = typeof options === 'string';\n            var args = widgetSlice.call(arguments, 1);\n            var returnValue = this;\n\n            if (isMethodCall) {\n                // If this is an empty collection, we need to have the instance method\n                // return undefined instead of the jQuery instance\n                if (!this.length && options === 'instance') {\n                    returnValue = undefined;\n                } else {\n                    this.each(function () {\n                        var methodValue;\n                        var instance = $.data(this, fullName);\n\n                        if (options === 'instance') {\n                            returnValue = instance;\n                            return false;\n                        }\n\n                        if (!instance) {\n                            return $.error(\n                                'cannot call methods on ' +\n                                name +\n                                ' prior to initialization; ' +\n                                \"attempted to call method '\" +\n                                options +\n                                \"'\"\n                            );\n                        }\n\n                        if (\n                            typeof instance[options] !== 'function' ||\n                            options.charAt(0) === '_'\n                        ) {\n                            return $.error(\n                                \"no such method '\" +\n                                options +\n                                \"' for \" +\n                                name +\n                                ' widget instance'\n                            );\n                        }\n\n                        methodValue = instance[options].apply(instance, args);\n\n                        if (methodValue !== instance && methodValue !== undefined) {\n                            returnValue =\n                                methodValue && methodValue.jquery\n                                    ? returnValue.pushStack(methodValue.get())\n                                    : methodValue;\n                            return false;\n                        }\n                    });\n                }\n            } else {\n                // Allow multiple hashes to be passed on init\n                if (args.length) {\n                    options = $.widget.extend.apply(null, [options].concat(args));\n                }\n\n                this.each(function () {\n                    var instance = $.data(this, fullName);\n                    if (instance) {\n                        instance.option(options || {});\n                        if (instance._init) {\n                            instance._init();\n                        }\n                    } else {\n                        $.data(this, fullName, new object(options, this));\n                    }\n                });\n            }\n\n            return returnValue;\n        };\n    };\n\n    $.Widget = function (/* options, element */) {};\n    $.Widget._childConstructors = [];\n\n    $.Widget.prototype = {\n        widgetName: 'widget',\n        widgetEventPrefix: '',\n        defaultElement: '<div>',\n\n        options: {\n            classes: {},\n            disabled: false,\n\n            // Callbacks\n            create: null\n        },\n\n        _createWidget: function (options, element) {\n            element = $(element || this.defaultElement || this)[0];\n            this.element = $(element);\n            this.uuid = widgetUuid++;\n            this.eventNamespace = '.' + this.widgetName + this.uuid;\n\n            this.bindings = $();\n            this.hoverable = $();\n            this.focusable = $();\n            this.classesElementLookup = {};\n\n            if (element !== this) {\n                $.data(element, this.widgetFullName, this);\n                this._on(true, this.element, {\n                    remove: function (event) {\n                        if (event.target === element) {\n                            this.destroy();\n                        }\n                    }\n                });\n                this.document = $(\n                    element.style\n                        ? // Element within the document\n                        element.ownerDocument\n                        : // Element is window or document\n                        element.document || element\n                );\n                this.window = $(\n                    this.document[0].defaultView || this.document[0].parentWindow\n                );\n            }\n\n            this.options = $.widget.extend(\n                {},\n                this.options,\n                this._getCreateOptions(),\n                options\n            );\n\n            this._create();\n\n            if (this.options.disabled) {\n                this._setOptionDisabled(this.options.disabled);\n            }\n\n            this._trigger('create', null, this._getCreateEventData());\n            this._init();\n        },\n\n        _getCreateOptions: function () {\n            return {};\n        },\n\n        _getCreateEventData: $.noop,\n\n        _create: $.noop,\n\n        _init: $.noop,\n\n        destroy: function () {\n            var that = this;\n\n            this._destroy();\n            $.each(this.classesElementLookup, function (key, value) {\n                that._removeClass(value, key);\n            });\n\n            // We can probably remove the unbind calls in 2.0\n            // all event bindings should go through this._on()\n            this.element.off(this.eventNamespace).removeData(this.widgetFullName);\n            this.widget().off(this.eventNamespace).removeAttr('aria-disabled');\n\n            // Clean up events and states\n            this.bindings.off(this.eventNamespace);\n        },\n\n        _destroy: $.noop,\n\n        widget: function () {\n            return this.element;\n        },\n\n        option: function (key, value) {\n            var options = key;\n            var parts;\n            var curOption;\n            var i;\n\n            if (arguments.length === 0) {\n                // Don't return a reference to the internal hash\n                return $.widget.extend({}, this.options);\n            }\n\n            if (typeof key === 'string') {\n                // Handle nested keys, e.g., \"foo.bar\" => { foo: { bar: ___ } }\n                options = {};\n                parts = key.split('.');\n                key = parts.shift();\n                if (parts.length) {\n                    curOption = options[key] = $.widget.extend({}, this.options[key]);\n                    for (i = 0; i < parts.length - 1; i++) {\n                        curOption[parts[i]] = curOption[parts[i]] || {};\n                        curOption = curOption[parts[i]];\n                    }\n                    key = parts.pop();\n                    if (arguments.length === 1) {\n                        return curOption[key] === undefined ? null : curOption[key];\n                    }\n                    curOption[key] = value;\n                } else {\n                    if (arguments.length === 1) {\n                        return this.options[key] === undefined ? null : this.options[key];\n                    }\n                    options[key] = value;\n                }\n            }\n\n            this._setOptions(options);\n\n            return this;\n        },\n\n        _setOptions: function (options) {\n            var key;\n\n            for (key in options) {\n                this._setOption(key, options[key]);\n            }\n\n            return this;\n        },\n\n        _setOption: function (key, value) {\n            if (key === 'classes') {\n                this._setOptionClasses(value);\n            }\n\n            this.options[key] = value;\n\n            if (key === 'disabled') {\n                this._setOptionDisabled(value);\n            }\n\n            return this;\n        },\n\n        _setOptionClasses: function (value) {\n            var classKey, elements, currentElements;\n\n            for (classKey in value) {\n                currentElements = this.classesElementLookup[classKey];\n                if (\n                    value[classKey] === this.options.classes[classKey] ||\n                    !currentElements ||\n                    !currentElements.length\n                ) {\n                    continue;\n                }\n\n                // We are doing this to create a new jQuery object because the _removeClass() call\n                // on the next line is going to destroy the reference to the current elements being\n                // tracked. We need to save a copy of this collection so that we can add the new classes\n                // below.\n                elements = $(currentElements.get());\n                this._removeClass(currentElements, classKey);\n\n                // We don't use _addClass() here, because that uses this.options.classes\n                // for generating the string of classes. We want to use the value passed in from\n                // _setOption(), this is the new value of the classes option which was passed to\n                // _setOption(). We pass this value directly to _classes().\n                elements.addClass(\n                    this._classes({\n                        element: elements,\n                        keys: classKey,\n                        classes: value,\n                        add: true\n                    })\n                );\n            }\n        },\n\n        _setOptionDisabled: function (value) {\n            this._toggleClass(\n                this.widget(),\n                this.widgetFullName + '-disabled',\n                null,\n                !!value\n            );\n\n            // If the widget is becoming disabled, then nothing is interactive\n            if (value) {\n                this._removeClass(this.hoverable, null, 'ui-state-hover');\n                this._removeClass(this.focusable, null, 'ui-state-focus');\n            }\n        },\n\n        enable: function () {\n            return this._setOptions({ disabled: false });\n        },\n\n        disable: function () {\n            return this._setOptions({ disabled: true });\n        },\n\n        _classes: function (options) {\n            var full = [];\n            var that = this;\n\n            options = $.extend(\n                {\n                    element: this.element,\n                    classes: this.options.classes || {}\n                },\n                options\n            );\n\n            /**\n             *\n             */\n            function bindRemoveEvent() {\n                var nodesToBind = [];\n\n                options.element.each(function (_, element) {\n                    var isTracked = $.map(that.classesElementLookup, function (elements) {\n                        return elements;\n                    }).some(function (elements) {\n                        return elements.is(element);\n                    });\n\n                    if (!isTracked) {\n                        nodesToBind.push(element);\n                    }\n                });\n\n                that._on($(nodesToBind), {\n                    remove: '_untrackClassesElement'\n                });\n            }\n\n            /**\n             * @param classes\n             * @param checkOption\n             */\n            function processClassString(classes, checkOption) {\n                var current, i;\n                for (i = 0; i < classes.length; i++) {\n                    current = that.classesElementLookup[classes[i]] || $();\n                    if (options.add) {\n                        bindRemoveEvent();\n                        current = $(\n                            $.uniqueSort(current.get().concat(options.element.get()))\n                        );\n                    } else {\n                        current = $(current.not(options.element).get());\n                    }\n                    that.classesElementLookup[classes[i]] = current;\n                    full.push(classes[i]);\n                    if (checkOption && options.classes[classes[i]]) {\n                        full.push(options.classes[classes[i]]);\n                    }\n                }\n            }\n\n            if (options.keys) {\n                processClassString(options.keys.match(/\\S+/g) || [], true);\n            }\n            if (options.extra) {\n                processClassString(options.extra.match(/\\S+/g) || []);\n            }\n\n            return full.join(' ');\n        },\n\n        _untrackClassesElement: function (event) {\n            var that = this;\n            $.each(that.classesElementLookup, function (key, value) {\n                if ($.inArray(event.target, value) !== -1) {\n                    that.classesElementLookup[key] = $(value.not(event.target).get());\n                }\n            });\n\n            this._off($(event.target));\n        },\n\n        _removeClass: function (element, keys, extra) {\n            return this._toggleClass(element, keys, extra, false);\n        },\n\n        _addClass: function (element, keys, extra) {\n            return this._toggleClass(element, keys, extra, true);\n        },\n\n        _toggleClass: function (element, keys, extra, add) {\n            add = typeof add === 'boolean' ? add : extra;\n            var shift = typeof element === 'string' || element === null,\n                options = {\n                    extra: shift ? keys : extra,\n                    keys: shift ? element : keys,\n                    element: shift ? this.element : element,\n                    add: add\n                };\n            options.element.toggleClass(this._classes(options), add);\n            return this;\n        },\n\n        _on: function (suppressDisabledCheck, element, handlers) {\n            var delegateElement;\n            var instance = this;\n\n            // No suppressDisabledCheck flag, shuffle arguments\n            if (typeof suppressDisabledCheck !== 'boolean') {\n                handlers = element;\n                element = suppressDisabledCheck;\n                suppressDisabledCheck = false;\n            }\n\n            // No element argument, shuffle and use this.element\n            if (!handlers) {\n                handlers = element;\n                element = this.element;\n                delegateElement = this.widget();\n            } else {\n                element = delegateElement = $(element);\n                this.bindings = this.bindings.add(element);\n            }\n\n            $.each(handlers, function (event, handler) {\n                /**\n                 *\n                 */\n                function handlerProxy() {\n                    // Allow widgets to customize the disabled handling\n                    // - disabled as an array instead of boolean\n                    // - disabled class as method for disabling individual parts\n                    if (\n                        !suppressDisabledCheck &&\n                        (instance.options.disabled === true ||\n                            $(this).hasClass('ui-state-disabled'))\n                    ) {\n                        return;\n                    }\n                    return (\n                        typeof handler === 'string' ? instance[handler] : handler\n                    ).apply(instance, arguments);\n                }\n\n                // Copy the guid so direct unbinding works\n                if (typeof handler !== 'string') {\n                    handlerProxy.guid = handler.guid =\n                        handler.guid || handlerProxy.guid || $.guid++;\n                }\n\n                var match = event.match(/^([\\w:-]*)\\s*(.*)$/);\n                var eventName = match[1] + instance.eventNamespace;\n                var selector = match[2];\n\n                if (selector) {\n                    delegateElement.on(eventName, selector, handlerProxy);\n                } else {\n                    element.on(eventName, handlerProxy);\n                }\n            });\n        },\n\n        _off: function (element, eventName) {\n            eventName =\n                (eventName || '').split(' ').join(this.eventNamespace + ' ') +\n                this.eventNamespace;\n            element.off(eventName);\n\n            // Clear the stack to avoid memory leaks (#10056)\n            this.bindings = $(this.bindings.not(element).get());\n            this.focusable = $(this.focusable.not(element).get());\n            this.hoverable = $(this.hoverable.not(element).get());\n        },\n\n        _delay: function (handler, delay) {\n            /**\n             *\n             */\n            function handlerProxy() {\n                return (\n                    typeof handler === 'string' ? instance[handler] : handler\n                ).apply(instance, arguments);\n            }\n            var instance = this;\n            return setTimeout(handlerProxy, delay || 0);\n        },\n\n        _hoverable: function (element) {\n            this.hoverable = this.hoverable.add(element);\n            this._on(element, {\n                mouseenter: function (event) {\n                    this._addClass($(event.currentTarget), null, 'ui-state-hover');\n                },\n                mouseleave: function (event) {\n                    this._removeClass($(event.currentTarget), null, 'ui-state-hover');\n                }\n            });\n        },\n\n        _focusable: function (element) {\n            this.focusable = this.focusable.add(element);\n            this._on(element, {\n                focusin: function (event) {\n                    this._addClass($(event.currentTarget), null, 'ui-state-focus');\n                },\n                focusout: function (event) {\n                    this._removeClass($(event.currentTarget), null, 'ui-state-focus');\n                }\n            });\n        },\n\n        _trigger: function (type, event, data) {\n            var prop, orig;\n            var callback = this.options[type];\n\n            data = data || {};\n            event = $.Event(event);\n            event.type = (\n                type === this.widgetEventPrefix ? type : this.widgetEventPrefix + type\n            ).toLowerCase();\n\n            // The original event may come from any element\n            // so we need to reset the target on the new event\n            event.target = this.element[0];\n\n            // Copy original event properties over to the new event\n            orig = event.originalEvent;\n            if (orig) {\n                for (prop in orig) {\n                    if (!(prop in event)) {\n                        event[prop] = orig[prop];\n                    }\n                }\n            }\n\n            this.element.trigger(event, data);\n            return !(\n                (typeof callback === 'function' &&\n                    callback.apply(this.element[0], [event].concat(data)) === false) ||\n                event.isDefaultPrevented()\n            );\n        }\n    };\n\n    $.each({ show: 'fadeIn', hide: 'fadeOut' }, function (method, defaultEffect) {\n        $.Widget.prototype['_' + method] = function (element, options, callback) {\n            if (typeof options === 'string') {\n                options = { effect: options };\n            }\n\n            var hasOptions;\n            var effectName = !options\n                ? method\n                : options === true || typeof options === 'number'\n                    ? defaultEffect\n                    : options.effect || defaultEffect;\n\n            options = options || {};\n            if (typeof options === 'number') {\n                options = { duration: options };\n            } else if (options === true) {\n                options = {};\n            }\n\n            hasOptions = !$.isEmptyObject(options);\n            options.complete = callback;\n\n            if (options.delay) {\n                element.delay(options.delay);\n            }\n\n            if (hasOptions && $.effects && $.effects.effect[effectName]) {\n                element[method](options);\n            } else if (effectName !== method && element[effectName]) {\n                element[effectName](options.duration, options.easing, callback);\n            } else {\n                element.queue(function (next) {\n                    $(this)[method]();\n                    if (callback) {\n                        callback.call(element[0]);\n                    }\n                    next();\n                });\n            }\n        };\n    });\n});\n","jquery/fileUploader/vendor/blueimp-tmpl/js/runtime.js":"/*\n * JavaScript Templates Runtime\n * https://github.com/blueimp/JavaScript-Templates\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define */\n\n/* eslint-disable strict */\n\n;(function ($) {\n  'use strict'\n  var tmpl = function (id, data) {\n    var f = tmpl.cache[id]\n    return data\n      ? f(data, tmpl)\n      : function (data) {\n          return f(data, tmpl)\n        }\n  }\n  tmpl.cache = {}\n  tmpl.encReg = /[<>&\"'\\x00]/g // eslint-disable-line no-control-regex\n  tmpl.encMap = {\n    '<': '&lt;',\n    '>': '&gt;',\n    '&': '&amp;',\n    '\"': '&quot;',\n    \"'\": '&#39;'\n  }\n  tmpl.encode = function (s) {\n    // eslint-disable-next-line eqeqeq\n    return (s == null ? '' : '' + s).replace(tmpl.encReg, function (c) {\n      return tmpl.encMap[c] || ''\n    })\n  }\n  if (typeof define === 'function' && define.amd) {\n    define(function () {\n      return tmpl\n    })\n  } else if (typeof module === 'object' && module.exports) {\n    module.exports = tmpl\n  } else {\n    $.tmpl = tmpl\n  }\n})(this)\n","jquery/fileUploader/vendor/blueimp-tmpl/js/tmpl.js":"/*\n * JavaScript Templates\n * https://github.com/blueimp/JavaScript-Templates\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n *\n * Inspired by John Resig's JavaScript Micro-Templating:\n * http://ejohn.org/blog/javascript-micro-templating/\n */\n\n/* global define */\n\n/* eslint-disable strict */\n\n;(function ($) {\n  'use strict'\n  var tmpl = function (str, data) {\n    var f = !/[^\\w\\-.:]/.test(str)\n      ? (tmpl.cache[str] = tmpl.cache[str] || tmpl(tmpl.load(str)))\n      : new Function( // eslint-disable-line no-new-func\n          tmpl.arg + ',tmpl',\n          'var _e=tmpl.encode' +\n            tmpl.helper +\n            \",_s='\" +\n            str.replace(tmpl.regexp, tmpl.func) +\n            \"';return _s;\"\n        )\n    return data\n      ? f(data, tmpl)\n      : function (data) {\n          return f(data, tmpl)\n        }\n  }\n  tmpl.cache = {}\n  tmpl.load = function (id) {\n    return document.getElementById(id).innerHTML\n  }\n  tmpl.regexp = /([\\s'\\\\])(?!(?:[^{]|\\{(?!%))*%\\})|(?:\\{%(=|#)([\\s\\S]+?)%\\})|(\\{%)|(%\\})/g\n  tmpl.func = function (s, p1, p2, p3, p4, p5) {\n    if (p1) {\n      // whitespace, quote and backspace in HTML context\n      return (\n        {\n          '\\n': '\\\\n',\n          '\\r': '\\\\r',\n          '\\t': '\\\\t',\n          ' ': ' '\n        }[p1] || '\\\\' + p1\n      )\n    }\n    if (p2) {\n      // interpolation: {%=prop%}, or unescaped: {%#prop%}\n      if (p2 === '=') {\n        return \"'+_e(\" + p3 + \")+'\"\n      }\n      return \"'+(\" + p3 + \"==null?'':\" + p3 + \")+'\"\n    }\n    if (p4) {\n      // evaluation start tag: {%\n      return \"';\"\n    }\n    if (p5) {\n      // evaluation end tag: %}\n      return \"_s+='\"\n    }\n  }\n  tmpl.encReg = /[<>&\"'\\x00]/g // eslint-disable-line no-control-regex\n  tmpl.encMap = {\n    '<': '&lt;',\n    '>': '&gt;',\n    '&': '&amp;',\n    '\"': '&quot;',\n    \"'\": '&#39;'\n  }\n  tmpl.encode = function (s) {\n    // eslint-disable-next-line eqeqeq\n    return (s == null ? '' : '' + s).replace(tmpl.encReg, function (c) {\n      return tmpl.encMap[c] || ''\n    })\n  }\n  tmpl.arg = 'o'\n  tmpl.helper =\n    \",print=function(s,e){_s+=e?(s==null?'':s):_e(s);}\" +\n    ',include=function(s,d){_s+=tmpl(s,d);}'\n  if (typeof define === 'function' && define.amd) {\n    define(function () {\n      return tmpl\n    })\n  } else if (typeof module === 'object' && module.exports) {\n    module.exports = tmpl\n  } else {\n    $.tmpl = tmpl\n  }\n})(this)\n","jquery/fileUploader/vendor/blueimp-tmpl/js/compile.js":"#!/usr/bin/env node\n/*\n * JavaScript Templates Compiler\n * https://github.com/blueimp/JavaScript-Templates\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* eslint-disable strict */\n/* eslint-disable no-console */\n\n;(function () {\n  'use strict'\n  var path = require('path')\n  var tmpl = require(path.join(__dirname, 'tmpl.js'))\n  var fs = require('fs')\n  // Retrieve the content of the minimal runtime:\n  var runtime = fs.readFileSync(path.join(__dirname, 'runtime.js'), 'utf8')\n  // A regular expression to parse templates from script tags in a HTML page:\n  var regexp = /<script( id=\"([\\w-]+)\")? type=\"text\\/x-tmpl\"( id=\"([\\w-]+)\")?>([\\s\\S]+?)<\\/script>/gi\n  // A regular expression to match the helper function names:\n  var helperRegexp = new RegExp(\n    tmpl.helper.match(/\\w+(?=\\s*=\\s*function\\s*\\()/g).join('\\\\s*\\\\(|') +\n      '\\\\s*\\\\('\n  )\n  // A list to store the function bodies:\n  var list = []\n  var code\n  // Extend the Templating engine with a print method for the generated functions:\n  tmpl.print = function (str) {\n    // Only add helper functions if they are used inside of the template:\n    var helper = helperRegexp.test(str) ? tmpl.helper : ''\n    var body = str.replace(tmpl.regexp, tmpl.func)\n    if (helper || /_e\\s*\\(/.test(body)) {\n      helper = '_e=tmpl.encode' + helper + ','\n    }\n    return (\n      'function(' +\n      tmpl.arg +\n      ',tmpl){' +\n      ('var ' + helper + \"_s='\" + body + \"';return _s;\")\n        .split(\"_s+='';\")\n        .join('') +\n      '}'\n    )\n  }\n  // Loop through the command line arguments:\n  process.argv.forEach(function (file, index) {\n    var listLength = list.length\n    var stats\n    var content\n    var result\n    var id\n    // Skip the first two arguments, which are \"node\" and the script:\n    if (index > 1) {\n      stats = fs.statSync(file)\n      if (!stats.isFile()) {\n        console.error(file + ' is not a file.')\n        return\n      }\n      content = fs.readFileSync(file, 'utf8')\n      // eslint-disable-next-line no-constant-condition\n      while (true) {\n        // Find templates in script tags:\n        result = regexp.exec(content)\n        if (!result) {\n          break\n        }\n        id = result[2] || result[4]\n        list.push(\"'\" + id + \"':\" + tmpl.print(result[5]))\n      }\n      if (listLength === list.length) {\n        // No template script tags found, use the complete content:\n        id = path.basename(file, path.extname(file))\n        list.push(\"'\" + id + \"':\" + tmpl.print(content))\n      }\n    }\n  })\n  if (!list.length) {\n    console.error('Missing input file.')\n    return\n  }\n  // Combine the generated functions as cache of the minimal runtime:\n  code = runtime.replace('{}', '{' + list.join(',') + '}')\n  // Print the resulting code to the console output:\n  console.log(code)\n})()\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif-map.js":"/*\n * JavaScript Load Image Exif Map\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Exif tags mapping based on\n * https://github.com/jseidelin/exif-js\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'), require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var ExifMapProto = loadImage.ExifMap.prototype\n\n  ExifMapProto.tags = {\n    // =================\n    // TIFF tags (IFD0):\n    // =================\n    0x0100: 'ImageWidth',\n    0x0101: 'ImageHeight',\n    0x0102: 'BitsPerSample',\n    0x0103: 'Compression',\n    0x0106: 'PhotometricInterpretation',\n    0x0112: 'Orientation',\n    0x0115: 'SamplesPerPixel',\n    0x011c: 'PlanarConfiguration',\n    0x0212: 'YCbCrSubSampling',\n    0x0213: 'YCbCrPositioning',\n    0x011a: 'XResolution',\n    0x011b: 'YResolution',\n    0x0128: 'ResolutionUnit',\n    0x0111: 'StripOffsets',\n    0x0116: 'RowsPerStrip',\n    0x0117: 'StripByteCounts',\n    0x0201: 'JPEGInterchangeFormat',\n    0x0202: 'JPEGInterchangeFormatLength',\n    0x012d: 'TransferFunction',\n    0x013e: 'WhitePoint',\n    0x013f: 'PrimaryChromaticities',\n    0x0211: 'YCbCrCoefficients',\n    0x0214: 'ReferenceBlackWhite',\n    0x0132: 'DateTime',\n    0x010e: 'ImageDescription',\n    0x010f: 'Make',\n    0x0110: 'Model',\n    0x0131: 'Software',\n    0x013b: 'Artist',\n    0x8298: 'Copyright',\n    0x8769: {\n      // ExifIFDPointer\n      0x9000: 'ExifVersion', // EXIF version\n      0xa000: 'FlashpixVersion', // Flashpix format version\n      0xa001: 'ColorSpace', // Color space information tag\n      0xa002: 'PixelXDimension', // Valid width of meaningful image\n      0xa003: 'PixelYDimension', // Valid height of meaningful image\n      0xa500: 'Gamma',\n      0x9101: 'ComponentsConfiguration', // Information about channels\n      0x9102: 'CompressedBitsPerPixel', // Compressed bits per pixel\n      0x927c: 'MakerNote', // Any desired information written by the manufacturer\n      0x9286: 'UserComment', // Comments by user\n      0xa004: 'RelatedSoundFile', // Name of related sound file\n      0x9003: 'DateTimeOriginal', // Date and time when the original image was generated\n      0x9004: 'DateTimeDigitized', // Date and time when the image was stored digitally\n      0x9010: 'OffsetTime', // Time zone when the image file was last changed\n      0x9011: 'OffsetTimeOriginal', // Time zone when the image was stored digitally\n      0x9012: 'OffsetTimeDigitized', // Time zone when the image was stored digitally\n      0x9290: 'SubSecTime', // Fractions of seconds for DateTime\n      0x9291: 'SubSecTimeOriginal', // Fractions of seconds for DateTimeOriginal\n      0x9292: 'SubSecTimeDigitized', // Fractions of seconds for DateTimeDigitized\n      0x829a: 'ExposureTime', // Exposure time (in seconds)\n      0x829d: 'FNumber',\n      0x8822: 'ExposureProgram', // Exposure program\n      0x8824: 'SpectralSensitivity', // Spectral sensitivity\n      0x8827: 'PhotographicSensitivity', // EXIF 2.3, ISOSpeedRatings in EXIF 2.2\n      0x8828: 'OECF', // Optoelectric conversion factor\n      0x8830: 'SensitivityType',\n      0x8831: 'StandardOutputSensitivity',\n      0x8832: 'RecommendedExposureIndex',\n      0x8833: 'ISOSpeed',\n      0x8834: 'ISOSpeedLatitudeyyy',\n      0x8835: 'ISOSpeedLatitudezzz',\n      0x9201: 'ShutterSpeedValue', // Shutter speed\n      0x9202: 'ApertureValue', // Lens aperture\n      0x9203: 'BrightnessValue', // Value of brightness\n      0x9204: 'ExposureBias', // Exposure bias\n      0x9205: 'MaxApertureValue', // Smallest F number of lens\n      0x9206: 'SubjectDistance', // Distance to subject in meters\n      0x9207: 'MeteringMode', // Metering mode\n      0x9208: 'LightSource', // Kind of light source\n      0x9209: 'Flash', // Flash status\n      0x9214: 'SubjectArea', // Location and area of main subject\n      0x920a: 'FocalLength', // Focal length of the lens in mm\n      0xa20b: 'FlashEnergy', // Strobe energy in BCPS\n      0xa20c: 'SpatialFrequencyResponse',\n      0xa20e: 'FocalPlaneXResolution', // Number of pixels in width direction per FPRUnit\n      0xa20f: 'FocalPlaneYResolution', // Number of pixels in height direction per FPRUnit\n      0xa210: 'FocalPlaneResolutionUnit', // Unit for measuring the focal plane resolution\n      0xa214: 'SubjectLocation', // Location of subject in image\n      0xa215: 'ExposureIndex', // Exposure index selected on camera\n      0xa217: 'SensingMethod', // Image sensor type\n      0xa300: 'FileSource', // Image source (3 == DSC)\n      0xa301: 'SceneType', // Scene type (1 == directly photographed)\n      0xa302: 'CFAPattern', // Color filter array geometric pattern\n      0xa401: 'CustomRendered', // Special processing\n      0xa402: 'ExposureMode', // Exposure mode\n      0xa403: 'WhiteBalance', // 1 = auto white balance, 2 = manual\n      0xa404: 'DigitalZoomRatio', // Digital zoom ratio\n      0xa405: 'FocalLengthIn35mmFilm',\n      0xa406: 'SceneCaptureType', // Type of scene\n      0xa407: 'GainControl', // Degree of overall image gain adjustment\n      0xa408: 'Contrast', // Direction of contrast processing applied by camera\n      0xa409: 'Saturation', // Direction of saturation processing applied by camera\n      0xa40a: 'Sharpness', // Direction of sharpness processing applied by camera\n      0xa40b: 'DeviceSettingDescription',\n      0xa40c: 'SubjectDistanceRange', // Distance to subject\n      0xa420: 'ImageUniqueID', // Identifier assigned uniquely to each image\n      0xa430: 'CameraOwnerName',\n      0xa431: 'BodySerialNumber',\n      0xa432: 'LensSpecification',\n      0xa433: 'LensMake',\n      0xa434: 'LensModel',\n      0xa435: 'LensSerialNumber'\n    },\n    0x8825: {\n      // GPSInfoIFDPointer\n      0x0000: 'GPSVersionID',\n      0x0001: 'GPSLatitudeRef',\n      0x0002: 'GPSLatitude',\n      0x0003: 'GPSLongitudeRef',\n      0x0004: 'GPSLongitude',\n      0x0005: 'GPSAltitudeRef',\n      0x0006: 'GPSAltitude',\n      0x0007: 'GPSTimeStamp',\n      0x0008: 'GPSSatellites',\n      0x0009: 'GPSStatus',\n      0x000a: 'GPSMeasureMode',\n      0x000b: 'GPSDOP',\n      0x000c: 'GPSSpeedRef',\n      0x000d: 'GPSSpeed',\n      0x000e: 'GPSTrackRef',\n      0x000f: 'GPSTrack',\n      0x0010: 'GPSImgDirectionRef',\n      0x0011: 'GPSImgDirection',\n      0x0012: 'GPSMapDatum',\n      0x0013: 'GPSDestLatitudeRef',\n      0x0014: 'GPSDestLatitude',\n      0x0015: 'GPSDestLongitudeRef',\n      0x0016: 'GPSDestLongitude',\n      0x0017: 'GPSDestBearingRef',\n      0x0018: 'GPSDestBearing',\n      0x0019: 'GPSDestDistanceRef',\n      0x001a: 'GPSDestDistance',\n      0x001b: 'GPSProcessingMethod',\n      0x001c: 'GPSAreaInformation',\n      0x001d: 'GPSDateStamp',\n      0x001e: 'GPSDifferential',\n      0x001f: 'GPSHPositioningError'\n    },\n    0xa005: {\n      // InteroperabilityIFDPointer\n      0x0001: 'InteroperabilityIndex'\n    }\n  }\n\n  // IFD1 directory can contain any IFD0 tags:\n  ExifMapProto.tags.ifd1 = ExifMapProto.tags\n\n  ExifMapProto.stringValues = {\n    ExposureProgram: {\n      0: 'Undefined',\n      1: 'Manual',\n      2: 'Normal program',\n      3: 'Aperture priority',\n      4: 'Shutter priority',\n      5: 'Creative program',\n      6: 'Action program',\n      7: 'Portrait mode',\n      8: 'Landscape mode'\n    },\n    MeteringMode: {\n      0: 'Unknown',\n      1: 'Average',\n      2: 'CenterWeightedAverage',\n      3: 'Spot',\n      4: 'MultiSpot',\n      5: 'Pattern',\n      6: 'Partial',\n      255: 'Other'\n    },\n    LightSource: {\n      0: 'Unknown',\n      1: 'Daylight',\n      2: 'Fluorescent',\n      3: 'Tungsten (incandescent light)',\n      4: 'Flash',\n      9: 'Fine weather',\n      10: 'Cloudy weather',\n      11: 'Shade',\n      12: 'Daylight fluorescent (D 5700 - 7100K)',\n      13: 'Day white fluorescent (N 4600 - 5400K)',\n      14: 'Cool white fluorescent (W 3900 - 4500K)',\n      15: 'White fluorescent (WW 3200 - 3700K)',\n      17: 'Standard light A',\n      18: 'Standard light B',\n      19: 'Standard light C',\n      20: 'D55',\n      21: 'D65',\n      22: 'D75',\n      23: 'D50',\n      24: 'ISO studio tungsten',\n      255: 'Other'\n    },\n    Flash: {\n      0x0000: 'Flash did not fire',\n      0x0001: 'Flash fired',\n      0x0005: 'Strobe return light not detected',\n      0x0007: 'Strobe return light detected',\n      0x0009: 'Flash fired, compulsory flash mode',\n      0x000d: 'Flash fired, compulsory flash mode, return light not detected',\n      0x000f: 'Flash fired, compulsory flash mode, return light detected',\n      0x0010: 'Flash did not fire, compulsory flash mode',\n      0x0018: 'Flash did not fire, auto mode',\n      0x0019: 'Flash fired, auto mode',\n      0x001d: 'Flash fired, auto mode, return light not detected',\n      0x001f: 'Flash fired, auto mode, return light detected',\n      0x0020: 'No flash function',\n      0x0041: 'Flash fired, red-eye reduction mode',\n      0x0045: 'Flash fired, red-eye reduction mode, return light not detected',\n      0x0047: 'Flash fired, red-eye reduction mode, return light detected',\n      0x0049: 'Flash fired, compulsory flash mode, red-eye reduction mode',\n      0x004d: 'Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected',\n      0x004f: 'Flash fired, compulsory flash mode, red-eye reduction mode, return light detected',\n      0x0059: 'Flash fired, auto mode, red-eye reduction mode',\n      0x005d: 'Flash fired, auto mode, return light not detected, red-eye reduction mode',\n      0x005f: 'Flash fired, auto mode, return light detected, red-eye reduction mode'\n    },\n    SensingMethod: {\n      1: 'Undefined',\n      2: 'One-chip color area sensor',\n      3: 'Two-chip color area sensor',\n      4: 'Three-chip color area sensor',\n      5: 'Color sequential area sensor',\n      7: 'Trilinear sensor',\n      8: 'Color sequential linear sensor'\n    },\n    SceneCaptureType: {\n      0: 'Standard',\n      1: 'Landscape',\n      2: 'Portrait',\n      3: 'Night scene'\n    },\n    SceneType: {\n      1: 'Directly photographed'\n    },\n    CustomRendered: {\n      0: 'Normal process',\n      1: 'Custom process'\n    },\n    WhiteBalance: {\n      0: 'Auto white balance',\n      1: 'Manual white balance'\n    },\n    GainControl: {\n      0: 'None',\n      1: 'Low gain up',\n      2: 'High gain up',\n      3: 'Low gain down',\n      4: 'High gain down'\n    },\n    Contrast: {\n      0: 'Normal',\n      1: 'Soft',\n      2: 'Hard'\n    },\n    Saturation: {\n      0: 'Normal',\n      1: 'Low saturation',\n      2: 'High saturation'\n    },\n    Sharpness: {\n      0: 'Normal',\n      1: 'Soft',\n      2: 'Hard'\n    },\n    SubjectDistanceRange: {\n      0: 'Unknown',\n      1: 'Macro',\n      2: 'Close view',\n      3: 'Distant view'\n    },\n    FileSource: {\n      3: 'DSC'\n    },\n    ComponentsConfiguration: {\n      0: '',\n      1: 'Y',\n      2: 'Cb',\n      3: 'Cr',\n      4: 'R',\n      5: 'G',\n      6: 'B'\n    },\n    Orientation: {\n      1: 'Original',\n      2: 'Horizontal flip',\n      3: 'Rotate 180\u00b0 CCW',\n      4: 'Vertical flip',\n      5: 'Vertical flip + Rotate 90\u00b0 CW',\n      6: 'Rotate 90\u00b0 CW',\n      7: 'Horizontal flip + Rotate 90\u00b0 CW',\n      8: 'Rotate 90\u00b0 CCW'\n    }\n  }\n\n  ExifMapProto.getText = function (name) {\n    var value = this.get(name)\n    switch (name) {\n      case 'LightSource':\n      case 'Flash':\n      case 'MeteringMode':\n      case 'ExposureProgram':\n      case 'SensingMethod':\n      case 'SceneCaptureType':\n      case 'SceneType':\n      case 'CustomRendered':\n      case 'WhiteBalance':\n      case 'GainControl':\n      case 'Contrast':\n      case 'Saturation':\n      case 'Sharpness':\n      case 'SubjectDistanceRange':\n      case 'FileSource':\n      case 'Orientation':\n        return this.stringValues[name][value]\n      case 'ExifVersion':\n      case 'FlashpixVersion':\n        if (!value) return\n        return String.fromCharCode(value[0], value[1], value[2], value[3])\n      case 'ComponentsConfiguration':\n        if (!value) return\n        return (\n          this.stringValues[name][value[0]] +\n          this.stringValues[name][value[1]] +\n          this.stringValues[name][value[2]] +\n          this.stringValues[name][value[3]]\n        )\n      case 'GPSVersionID':\n        if (!value) return\n        return value[0] + '.' + value[1] + '.' + value[2] + '.' + value[3]\n    }\n    return String(value)\n  }\n\n  ExifMapProto.getAll = function () {\n    var map = {}\n    var prop\n    var obj\n    var name\n    for (prop in this) {\n      if (Object.prototype.hasOwnProperty.call(this, prop)) {\n        obj = this[prop]\n        if (obj && obj.getAll) {\n          map[this.ifds[prop].name] = obj.getAll()\n        } else {\n          name = this.tags[prop]\n          if (name) map[name] = this.getText(name)\n        }\n      }\n    }\n    return map\n  }\n\n  ExifMapProto.getName = function (tagCode) {\n    var name = this.tags[tagCode]\n    if (typeof name === 'object') return this.ifds[tagCode].name\n    return name\n  }\n\n  // Extend the map of tag names to tag codes:\n  ;(function () {\n    var tags = ExifMapProto.tags\n    var prop\n    var ifd\n    var subTags\n    // Map the tag names to tags:\n    for (prop in tags) {\n      if (Object.prototype.hasOwnProperty.call(tags, prop)) {\n        ifd = ExifMapProto.ifds[prop]\n        if (ifd) {\n          subTags = tags[prop]\n          for (prop in subTags) {\n            if (Object.prototype.hasOwnProperty.call(subTags, prop)) {\n              ifd.map[subTags[prop]] = Number(prop)\n            }\n          }\n        } else {\n          ExifMapProto.map[tags[prop]] = Number(prop)\n        }\n      }\n    }\n  })()\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc.js":"/*\n * JavaScript Load Image IPTC Parser\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * Copyright 2018, Dave Bevan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require, DataView */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'), require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  /**\n   * IPTC tag map\n   *\n   * @name IptcMap\n   * @class\n   */\n  function IptcMap() {}\n\n  IptcMap.prototype.map = {\n    ObjectName: 5\n  }\n\n  IptcMap.prototype.types = {\n    0: 'Uint16', // ApplicationRecordVersion\n    200: 'Uint16', // ObjectPreviewFileFormat\n    201: 'Uint16', // ObjectPreviewFileVersion\n    202: 'binary' // ObjectPreviewData\n  }\n\n  /**\n   * Retrieves IPTC tag value\n   *\n   * @param {number|string} id IPTC tag code or name\n   * @returns {object} IPTC tag value\n   */\n  IptcMap.prototype.get = function (id) {\n    return this[id] || this[this.map[id]]\n  }\n\n  /**\n   * Retrieves string for the given DataView and range\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Offset start\n   * @param {number} length Offset length\n   * @returns {string} String value\n   */\n  function getStringValue(dataView, offset, length) {\n    var outstr = ''\n    var end = offset + length\n    for (var n = offset; n < end; n += 1) {\n      outstr += String.fromCharCode(dataView.getUint8(n))\n    }\n    return outstr\n  }\n\n  /**\n   * Retrieves tag value for the given DataView and range\n   *\n   * @param {number} tagCode tag code\n   * @param {IptcMap} map IPTC tag map\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Range start\n   * @param {number} length Range length\n   * @returns {object} Tag value\n   */\n  function getTagValue(tagCode, map, dataView, offset, length) {\n    if (map.types[tagCode] === 'binary') {\n      return new Blob([dataView.buffer.slice(offset, offset + length)])\n    }\n    if (map.types[tagCode] === 'Uint16') {\n      return dataView.getUint16(offset)\n    }\n    return getStringValue(dataView, offset, length)\n  }\n\n  /**\n   * Combines IPTC value with existing ones.\n   *\n   * @param {object} value Existing IPTC field value\n   * @param {object} newValue New IPTC field value\n   * @returns {object} Resulting IPTC field value\n   */\n  function combineTagValues(value, newValue) {\n    if (value === undefined) return newValue\n    if (value instanceof Array) {\n      value.push(newValue)\n      return value\n    }\n    return [value, newValue]\n  }\n\n  /**\n   * Parses IPTC tags.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} segmentOffset Segment offset\n   * @param {number} segmentLength Segment length\n   * @param {object} data Data export object\n   * @param {object} includeTags Map of tags to include\n   * @param {object} excludeTags Map of tags to exclude\n   */\n  function parseIptcTags(\n    dataView,\n    segmentOffset,\n    segmentLength,\n    data,\n    includeTags,\n    excludeTags\n  ) {\n    var value, tagSize, tagCode\n    var segmentEnd = segmentOffset + segmentLength\n    var offset = segmentOffset\n    while (offset < segmentEnd) {\n      if (\n        dataView.getUint8(offset) === 0x1c && // tag marker\n        dataView.getUint8(offset + 1) === 0x02 // record number, only handles v2\n      ) {\n        tagCode = dataView.getUint8(offset + 2)\n        if (\n          (!includeTags || includeTags[tagCode]) &&\n          (!excludeTags || !excludeTags[tagCode])\n        ) {\n          tagSize = dataView.getInt16(offset + 3)\n          value = getTagValue(tagCode, data.iptc, dataView, offset + 5, tagSize)\n          data.iptc[tagCode] = combineTagValues(data.iptc[tagCode], value)\n          if (data.iptcOffsets) {\n            data.iptcOffsets[tagCode] = offset\n          }\n        }\n      }\n      offset += 1\n    }\n  }\n\n  /**\n   * Tests if field segment starts at offset.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Segment offset\n   * @returns {boolean} True if '8BIM<EOT><EOT>' exists at offset\n   */\n  function isSegmentStart(dataView, offset) {\n    return (\n      dataView.getUint32(offset) === 0x3842494d && // Photoshop segment start\n      dataView.getUint16(offset + 4) === 0x0404 // IPTC segment start\n    )\n  }\n\n  /**\n   * Returns header length.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Segment offset\n   * @returns {number} Header length\n   */\n  function getHeaderLength(dataView, offset) {\n    var length = dataView.getUint8(offset + 7)\n    if (length % 2 !== 0) length += 1\n    // Check for pre photoshop 6 format\n    if (length === 0) {\n      // Always 4\n      length = 4\n    }\n    return length\n  }\n\n  loadImage.parseIptcData = function (dataView, offset, length, data, options) {\n    if (options.disableIptc) {\n      return\n    }\n    var markerLength = offset + length\n    while (offset + 8 < markerLength) {\n      if (isSegmentStart(dataView, offset)) {\n        var headerLength = getHeaderLength(dataView, offset)\n        var segmentOffset = offset + 8 + headerLength\n        if (segmentOffset > markerLength) {\n          // eslint-disable-next-line no-console\n          console.log('Invalid IPTC data: Invalid segment offset.')\n          break\n        }\n        var segmentLength = dataView.getUint16(offset + 6 + headerLength)\n        if (offset + segmentLength > markerLength) {\n          // eslint-disable-next-line no-console\n          console.log('Invalid IPTC data: Invalid segment size.')\n          break\n        }\n        // Create the iptc object to store the tags:\n        data.iptc = new IptcMap()\n        if (!options.disableIptcOffsets) {\n          data.iptcOffsets = new IptcMap()\n        }\n        parseIptcTags(\n          dataView,\n          segmentOffset,\n          segmentLength,\n          data,\n          options.includeIptcTags,\n          options.excludeIptcTags || { 202: true } // ObjectPreviewData\n        )\n        return\n      }\n      // eslint-disable-next-line no-param-reassign\n      offset += 1\n    }\n  }\n\n  // Registers this IPTC parser for the APP13 JPEG metadata segment:\n  loadImage.metaDataParsers.jpeg[0xffed].push(loadImage.parseIptcData)\n\n  loadImage.IptcMap = IptcMap\n\n  // Adds the following properties to the parseMetaData callback data:\n  // - iptc: The iptc tags, parsed by the parseIptcData method\n\n  // Adds the following options to the parseMetaData method:\n  // - disableIptc: Disables IPTC parsing when true.\n  // - disableIptcOffsets: Disables storing IPTC tag offsets when true.\n  // - includeIptcTags: A map of IPTC tags to include for parsing.\n  // - excludeIptcTags: A map of IPTC tags to exclude from parsing.\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-fetch.js":"/*\n * JavaScript Load Image Fetch\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2017, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require, Promise */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var global = loadImage.global\n\n  if (\n    global.fetch &&\n    global.Request &&\n    global.Response &&\n    global.Response.prototype.blob\n  ) {\n    loadImage.fetchBlob = function (url, callback, options) {\n      /**\n       * Fetch response handler.\n       *\n       * @param {Response} response Fetch response\n       * @returns {Blob} Fetched Blob.\n       */\n      function responseHandler(response) {\n        return response.blob()\n      }\n      if (global.Promise && typeof callback !== 'function') {\n        return fetch(new Request(url, callback)).then(responseHandler)\n      }\n      fetch(new Request(url, options))\n        .then(responseHandler)\n        .then(callback)\n        [\n          // Avoid parsing error in IE<9, where catch is a reserved word.\n          // eslint-disable-next-line dot-notation\n          'catch'\n        ](function (err) {\n          callback(null, err)\n        })\n    }\n  } else if (\n    global.XMLHttpRequest &&\n    // https://xhr.spec.whatwg.org/#the-responsetype-attribute\n    new XMLHttpRequest().responseType === ''\n  ) {\n    loadImage.fetchBlob = function (url, callback, options) {\n      /**\n       * Promise executor\n       *\n       * @param {Function} resolve Resolution function\n       * @param {Function} reject Rejection function\n       */\n      function executor(resolve, reject) {\n        options = options || {} // eslint-disable-line no-param-reassign\n        var req = new XMLHttpRequest()\n        req.open(options.method || 'GET', url)\n        if (options.headers) {\n          Object.keys(options.headers).forEach(function (key) {\n            req.setRequestHeader(key, options.headers[key])\n          })\n        }\n        req.withCredentials = options.credentials === 'include'\n        req.responseType = 'blob'\n        req.onload = function () {\n          resolve(req.response)\n        }\n        req.onerror = req.onabort = req.ontimeout = function (err) {\n          if (resolve === reject) {\n            // Not using Promises\n            reject(null, err)\n          } else {\n            reject(err)\n          }\n        }\n        req.send(options.body)\n      }\n      if (global.Promise && typeof callback !== 'function') {\n        options = callback // eslint-disable-line no-param-reassign\n        return new Promise(executor)\n      }\n      return executor(callback, callback)\n    }\n  }\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc-map.js":"/*\n * JavaScript Load Image IPTC Map\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * Copyright 2018, Dave Bevan\n *\n * IPTC tags mapping based on\n * https://iptc.org/standards/photo-metadata\n * https://exiftool.org/TagNames/IPTC.html\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'), require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var IptcMapProto = loadImage.IptcMap.prototype\n\n  IptcMapProto.tags = {\n    0: 'ApplicationRecordVersion',\n    3: 'ObjectTypeReference',\n    4: 'ObjectAttributeReference',\n    5: 'ObjectName',\n    7: 'EditStatus',\n    8: 'EditorialUpdate',\n    10: 'Urgency',\n    12: 'SubjectReference',\n    15: 'Category',\n    20: 'SupplementalCategories',\n    22: 'FixtureIdentifier',\n    25: 'Keywords',\n    26: 'ContentLocationCode',\n    27: 'ContentLocationName',\n    30: 'ReleaseDate',\n    35: 'ReleaseTime',\n    37: 'ExpirationDate',\n    38: 'ExpirationTime',\n    40: 'SpecialInstructions',\n    42: 'ActionAdvised',\n    45: 'ReferenceService',\n    47: 'ReferenceDate',\n    50: 'ReferenceNumber',\n    55: 'DateCreated',\n    60: 'TimeCreated',\n    62: 'DigitalCreationDate',\n    63: 'DigitalCreationTime',\n    65: 'OriginatingProgram',\n    70: 'ProgramVersion',\n    75: 'ObjectCycle',\n    80: 'Byline',\n    85: 'BylineTitle',\n    90: 'City',\n    92: 'Sublocation',\n    95: 'State',\n    100: 'CountryCode',\n    101: 'Country',\n    103: 'OriginalTransmissionReference',\n    105: 'Headline',\n    110: 'Credit',\n    115: 'Source',\n    116: 'CopyrightNotice',\n    118: 'Contact',\n    120: 'Caption',\n    121: 'LocalCaption',\n    122: 'Writer',\n    125: 'RasterizedCaption',\n    130: 'ImageType',\n    131: 'ImageOrientation',\n    135: 'LanguageIdentifier',\n    150: 'AudioType',\n    151: 'AudioSamplingRate',\n    152: 'AudioSamplingResolution',\n    153: 'AudioDuration',\n    154: 'AudioOutcue',\n    184: 'JobID',\n    185: 'MasterDocumentID',\n    186: 'ShortDocumentID',\n    187: 'UniqueDocumentID',\n    188: 'OwnerID',\n    200: 'ObjectPreviewFileFormat',\n    201: 'ObjectPreviewFileVersion',\n    202: 'ObjectPreviewData',\n    221: 'Prefs',\n    225: 'ClassifyState',\n    228: 'SimilarityIndex',\n    230: 'DocumentNotes',\n    231: 'DocumentHistory',\n    232: 'ExifCameraInfo',\n    255: 'CatalogSets'\n  }\n\n  IptcMapProto.stringValues = {\n    10: {\n      0: '0 (reserved)',\n      1: '1 (most urgent)',\n      2: '2',\n      3: '3',\n      4: '4',\n      5: '5 (normal urgency)',\n      6: '6',\n      7: '7',\n      8: '8 (least urgent)',\n      9: '9 (user-defined priority)'\n    },\n    75: {\n      a: 'Morning',\n      b: 'Both Morning and Evening',\n      p: 'Evening'\n    },\n    131: {\n      L: 'Landscape',\n      P: 'Portrait',\n      S: 'Square'\n    }\n  }\n\n  IptcMapProto.getText = function (id) {\n    var value = this.get(id)\n    var tagCode = this.map[id]\n    var stringValue = this.stringValues[tagCode]\n    if (stringValue) return stringValue[value]\n    return String(value)\n  }\n\n  IptcMapProto.getAll = function () {\n    var map = {}\n    var prop\n    var name\n    for (prop in this) {\n      if (Object.prototype.hasOwnProperty.call(this, prop)) {\n        name = this.tags[prop]\n        if (name) map[name] = this.getText(name)\n      }\n    }\n    return map\n  }\n\n  IptcMapProto.getName = function (tagCode) {\n    return this.tags[tagCode]\n  }\n\n  // Extend the map of tag names to tag codes:\n  ;(function () {\n    var tags = IptcMapProto.tags\n    var map = IptcMapProto.map || {}\n    var prop\n    // Map the tag names to tags:\n    for (prop in tags) {\n      if (Object.prototype.hasOwnProperty.call(tags, prop)) {\n        map[tags[prop]] = Number(prop)\n      }\n    }\n  })()\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/index.js":"/* global module, require */\n\nmodule.exports = require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image')\n\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-fetch')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif-map')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-iptc-map')\nrequire('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-orientation')\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-exif.js":"/*\n * JavaScript Load Image Exif Parser\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require, DataView */\n\n/* eslint-disable no-console */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'), require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  /**\n   * Exif tag map\n   *\n   * @name ExifMap\n   * @class\n   * @param {number|string} tagCode IFD tag code\n   */\n  function ExifMap(tagCode) {\n    if (tagCode) {\n      Object.defineProperty(this, 'map', {\n        value: this.ifds[tagCode].map\n      })\n      Object.defineProperty(this, 'tags', {\n        value: (this.tags && this.tags[tagCode]) || {}\n      })\n    }\n  }\n\n  ExifMap.prototype.map = {\n    Orientation: 0x0112,\n    Thumbnail: 'ifd1',\n    Blob: 0x0201, // Alias for JPEGInterchangeFormat\n    Exif: 0x8769,\n    GPSInfo: 0x8825,\n    Interoperability: 0xa005\n  }\n\n  ExifMap.prototype.ifds = {\n    ifd1: { name: 'Thumbnail', map: ExifMap.prototype.map },\n    0x8769: { name: 'Exif', map: {} },\n    0x8825: { name: 'GPSInfo', map: {} },\n    0xa005: { name: 'Interoperability', map: {} }\n  }\n\n  /**\n   * Retrieves exif tag value\n   *\n   * @param {number|string} id Exif tag code or name\n   * @returns {object} Exif tag value\n   */\n  ExifMap.prototype.get = function (id) {\n    return this[id] || this[this.map[id]]\n  }\n\n  /**\n   * Returns the Exif Thumbnail data as Blob.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} offset Thumbnail data offset\n   * @param {number} length Thumbnail data length\n   * @returns {undefined|Blob} Returns the Thumbnail Blob or undefined\n   */\n  function getExifThumbnail(dataView, offset, length) {\n    if (!length) return\n    if (offset + length > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid thumbnail data.')\n      return\n    }\n    return new Blob(\n      [loadImage.bufferSlice.call(dataView.buffer, offset, offset + length)],\n      {\n        type: 'image/jpeg'\n      }\n    )\n  }\n\n  var ExifTagTypes = {\n    // byte, 8-bit unsigned int:\n    1: {\n      getValue: function (dataView, dataOffset) {\n        return dataView.getUint8(dataOffset)\n      },\n      size: 1\n    },\n    // ascii, 8-bit byte:\n    2: {\n      getValue: function (dataView, dataOffset) {\n        return String.fromCharCode(dataView.getUint8(dataOffset))\n      },\n      size: 1,\n      ascii: true\n    },\n    // short, 16 bit int:\n    3: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return dataView.getUint16(dataOffset, littleEndian)\n      },\n      size: 2\n    },\n    // long, 32 bit int:\n    4: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return dataView.getUint32(dataOffset, littleEndian)\n      },\n      size: 4\n    },\n    // rational = two long values, first is numerator, second is denominator:\n    5: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return (\n          dataView.getUint32(dataOffset, littleEndian) /\n          dataView.getUint32(dataOffset + 4, littleEndian)\n        )\n      },\n      size: 8\n    },\n    // slong, 32 bit signed int:\n    9: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return dataView.getInt32(dataOffset, littleEndian)\n      },\n      size: 4\n    },\n    // srational, two slongs, first is numerator, second is denominator:\n    10: {\n      getValue: function (dataView, dataOffset, littleEndian) {\n        return (\n          dataView.getInt32(dataOffset, littleEndian) /\n          dataView.getInt32(dataOffset + 4, littleEndian)\n        )\n      },\n      size: 8\n    }\n  }\n  // undefined, 8-bit byte, value depending on field:\n  ExifTagTypes[7] = ExifTagTypes[1]\n\n  /**\n   * Returns Exif tag value.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} tiffOffset TIFF offset\n   * @param {number} offset Tag offset\n   * @param {number} type Tag type\n   * @param {number} length Tag length\n   * @param {boolean} littleEndian Little endian encoding\n   * @returns {object} Tag value\n   */\n  function getExifValue(\n    dataView,\n    tiffOffset,\n    offset,\n    type,\n    length,\n    littleEndian\n  ) {\n    var tagType = ExifTagTypes[type]\n    var tagSize\n    var dataOffset\n    var values\n    var i\n    var str\n    var c\n    if (!tagType) {\n      console.log('Invalid Exif data: Invalid tag type.')\n      return\n    }\n    tagSize = tagType.size * length\n    // Determine if the value is contained in the dataOffset bytes,\n    // or if the value at the dataOffset is a pointer to the actual data:\n    dataOffset =\n      tagSize > 4\n        ? tiffOffset + dataView.getUint32(offset + 8, littleEndian)\n        : offset + 8\n    if (dataOffset + tagSize > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid data offset.')\n      return\n    }\n    if (length === 1) {\n      return tagType.getValue(dataView, dataOffset, littleEndian)\n    }\n    values = []\n    for (i = 0; i < length; i += 1) {\n      values[i] = tagType.getValue(\n        dataView,\n        dataOffset + i * tagType.size,\n        littleEndian\n      )\n    }\n    if (tagType.ascii) {\n      str = ''\n      // Concatenate the chars:\n      for (i = 0; i < values.length; i += 1) {\n        c = values[i]\n        // Ignore the terminating NULL byte(s):\n        if (c === '\\u0000') {\n          break\n        }\n        str += c\n      }\n      return str\n    }\n    return values\n  }\n\n  /**\n   * Determines if the given tag should be included.\n   *\n   * @param {object} includeTags Map of tags to include\n   * @param {object} excludeTags Map of tags to exclude\n   * @param {number|string} tagCode Tag code to check\n   * @returns {boolean} True if the tag should be included\n   */\n  function shouldIncludeTag(includeTags, excludeTags, tagCode) {\n    return (\n      (!includeTags || includeTags[tagCode]) &&\n      (!excludeTags || excludeTags[tagCode] !== true)\n    )\n  }\n\n  /**\n   * Parses Exif tags.\n   *\n   * @param {DataView} dataView Data view interface\n   * @param {number} tiffOffset TIFF offset\n   * @param {number} dirOffset Directory offset\n   * @param {boolean} littleEndian Little endian encoding\n   * @param {ExifMap} tags Map to store parsed exif tags\n   * @param {ExifMap} tagOffsets Map to store parsed exif tag offsets\n   * @param {object} includeTags Map of tags to include\n   * @param {object} excludeTags Map of tags to exclude\n   * @returns {number} Next directory offset\n   */\n  function parseExifTags(\n    dataView,\n    tiffOffset,\n    dirOffset,\n    littleEndian,\n    tags,\n    tagOffsets,\n    includeTags,\n    excludeTags\n  ) {\n    var tagsNumber, dirEndOffset, i, tagOffset, tagNumber, tagValue\n    if (dirOffset + 6 > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid directory offset.')\n      return\n    }\n    tagsNumber = dataView.getUint16(dirOffset, littleEndian)\n    dirEndOffset = dirOffset + 2 + 12 * tagsNumber\n    if (dirEndOffset + 4 > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid directory size.')\n      return\n    }\n    for (i = 0; i < tagsNumber; i += 1) {\n      tagOffset = dirOffset + 2 + 12 * i\n      tagNumber = dataView.getUint16(tagOffset, littleEndian)\n      if (!shouldIncludeTag(includeTags, excludeTags, tagNumber)) continue\n      tagValue = getExifValue(\n        dataView,\n        tiffOffset,\n        tagOffset,\n        dataView.getUint16(tagOffset + 2, littleEndian), // tag type\n        dataView.getUint32(tagOffset + 4, littleEndian), // tag length\n        littleEndian\n      )\n      tags[tagNumber] = tagValue\n      if (tagOffsets) {\n        tagOffsets[tagNumber] = tagOffset\n      }\n    }\n    // Return the offset to the next directory:\n    return dataView.getUint32(dirEndOffset, littleEndian)\n  }\n\n  /**\n   * Parses tags in a given IFD (Image File Directory).\n   *\n   * @param {object} data Data object to store exif tags and offsets\n   * @param {number|string} tagCode IFD tag code\n   * @param {DataView} dataView Data view interface\n   * @param {number} tiffOffset TIFF offset\n   * @param {boolean} littleEndian Little endian encoding\n   * @param {object} includeTags Map of tags to include\n   * @param {object} excludeTags Map of tags to exclude\n   */\n  function parseExifIFD(\n    data,\n    tagCode,\n    dataView,\n    tiffOffset,\n    littleEndian,\n    includeTags,\n    excludeTags\n  ) {\n    var dirOffset = data.exif[tagCode]\n    if (dirOffset) {\n      data.exif[tagCode] = new ExifMap(tagCode)\n      if (data.exifOffsets) {\n        data.exifOffsets[tagCode] = new ExifMap(tagCode)\n      }\n      parseExifTags(\n        dataView,\n        tiffOffset,\n        tiffOffset + dirOffset,\n        littleEndian,\n        data.exif[tagCode],\n        data.exifOffsets && data.exifOffsets[tagCode],\n        includeTags && includeTags[tagCode],\n        excludeTags && excludeTags[tagCode]\n      )\n    }\n  }\n\n  loadImage.parseExifData = function (dataView, offset, length, data, options) {\n    if (options.disableExif) {\n      return\n    }\n    var includeTags = options.includeExifTags\n    var excludeTags = options.excludeExifTags || {\n      0x8769: {\n        // ExifIFDPointer\n        0x927c: true // MakerNote\n      }\n    }\n    var tiffOffset = offset + 10\n    var littleEndian\n    var dirOffset\n    var thumbnailIFD\n    // Check for the ASCII code for \"Exif\" (0x45786966):\n    if (dataView.getUint32(offset + 4) !== 0x45786966) {\n      // No Exif data, might be XMP data instead\n      return\n    }\n    if (tiffOffset + 8 > dataView.byteLength) {\n      console.log('Invalid Exif data: Invalid segment size.')\n      return\n    }\n    // Check for the two null bytes:\n    if (dataView.getUint16(offset + 8) !== 0x0000) {\n      console.log('Invalid Exif data: Missing byte alignment offset.')\n      return\n    }\n    // Check the byte alignment:\n    switch (dataView.getUint16(tiffOffset)) {\n      case 0x4949:\n        littleEndian = true\n        break\n      case 0x4d4d:\n        littleEndian = false\n        break\n      default:\n        console.log('Invalid Exif data: Invalid byte alignment marker.')\n        return\n    }\n    // Check for the TIFF tag marker (0x002A):\n    if (dataView.getUint16(tiffOffset + 2, littleEndian) !== 0x002a) {\n      console.log('Invalid Exif data: Missing TIFF marker.')\n      return\n    }\n    // Retrieve the directory offset bytes, usually 0x00000008 or 8 decimal:\n    dirOffset = dataView.getUint32(tiffOffset + 4, littleEndian)\n    // Create the exif object to store the tags:\n    data.exif = new ExifMap()\n    if (!options.disableExifOffsets) {\n      data.exifOffsets = new ExifMap()\n      data.exifTiffOffset = tiffOffset\n      data.exifLittleEndian = littleEndian\n    }\n    // Parse the tags of the main image directory (IFD0) and retrieve the\n    // offset to the next directory (IFD1), usually the thumbnail directory:\n    dirOffset = parseExifTags(\n      dataView,\n      tiffOffset,\n      tiffOffset + dirOffset,\n      littleEndian,\n      data.exif,\n      data.exifOffsets,\n      includeTags,\n      excludeTags\n    )\n    if (dirOffset && shouldIncludeTag(includeTags, excludeTags, 'ifd1')) {\n      data.exif.ifd1 = dirOffset\n      if (data.exifOffsets) {\n        data.exifOffsets.ifd1 = tiffOffset + dirOffset\n      }\n    }\n    Object.keys(data.exif.ifds).forEach(function (tagCode) {\n      parseExifIFD(\n        data,\n        tagCode,\n        dataView,\n        tiffOffset,\n        littleEndian,\n        includeTags,\n        excludeTags\n      )\n    })\n    thumbnailIFD = data.exif.ifd1\n    // Check for JPEG Thumbnail offset and data length:\n    if (thumbnailIFD && thumbnailIFD[0x0201]) {\n      thumbnailIFD[0x0201] = getExifThumbnail(\n        dataView,\n        tiffOffset + thumbnailIFD[0x0201],\n        thumbnailIFD[0x0202] // Thumbnail data length\n      )\n    }\n  }\n\n  // Registers the Exif parser for the APP1 JPEG metadata segment:\n  loadImage.metaDataParsers.jpeg[0xffe1].push(loadImage.parseExifData)\n\n  loadImage.exifWriters = {\n    // Orientation writer:\n    0x0112: function (buffer, data, value) {\n      var orientationOffset = data.exifOffsets[0x0112]\n      if (!orientationOffset) return buffer\n      var view = new DataView(buffer, orientationOffset + 8, 2)\n      view.setUint16(0, value, data.exifLittleEndian)\n      return buffer\n    }\n  }\n\n  loadImage.writeExifData = function (buffer, data, id, value) {\n    loadImage.exifWriters[data.exif.map[id]](buffer, data, value)\n  }\n\n  loadImage.ExifMap = ExifMap\n\n  // Adds the following properties to the parseMetaData callback data:\n  // - exif: The parsed Exif tags\n  // - exifOffsets: The parsed Exif tag offsets\n  // - exifTiffOffset: TIFF header offset (used for offset pointers)\n  // - exifLittleEndian: little endian order if true, big endian if false\n\n  // Adds the following options to the parseMetaData method:\n  // - disableExif: Disables Exif parsing when true.\n  // - disableExifOffsets: Disables storing Exif tag offsets when true.\n  // - includeExifTags: A map of Exif tags to include for parsing.\n  // - excludeExifTags: A map of Exif tags to exclude from parsing.\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image.js":"/*\n * JavaScript Load Image\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, Promise */\n\n;(function ($) {\n  'use strict'\n\n  var urlAPI = $.URL || $.webkitURL\n\n  /**\n   * Creates an object URL for a given File object.\n   *\n   * @param {Blob} blob Blob object\n   * @returns {string|boolean} Returns object URL if API exists, else false.\n   */\n  function createObjectURL(blob) {\n    return urlAPI ? urlAPI.createObjectURL(blob) : false\n  }\n\n  /**\n   * Revokes a given object URL.\n   *\n   * @param {string} url Blob object URL\n   * @returns {undefined|boolean} Returns undefined if API exists, else false.\n   */\n  function revokeObjectURL(url) {\n    return urlAPI ? urlAPI.revokeObjectURL(url) : false\n  }\n\n  /**\n   * Helper function to revoke an object URL\n   *\n   * @param {string} url Blob Object URL\n   * @param {object} [options] Options object\n   */\n  function revokeHelper(url, options) {\n    if (url && url.slice(0, 5) === 'blob:' && !(options && options.noRevoke)) {\n      revokeObjectURL(url)\n    }\n  }\n\n  /**\n   * Loads a given File object via FileReader interface.\n   *\n   * @param {Blob} file Blob object\n   * @param {Function} onload Load event callback\n   * @param {Function} [onerror] Error/Abort event callback\n   * @param {string} [method=readAsDataURL] FileReader method\n   * @returns {FileReader|boolean} Returns FileReader if API exists, else false.\n   */\n  function readFile(file, onload, onerror, method) {\n    if (!$.FileReader) return false\n    var reader = new FileReader()\n    reader.onload = function () {\n      onload.call(reader, this.result)\n    }\n    if (onerror) {\n      reader.onabort = reader.onerror = function () {\n        onerror.call(reader, this.error)\n      }\n    }\n    var readerMethod = reader[method || 'readAsDataURL']\n    if (readerMethod) {\n      readerMethod.call(reader, file)\n      return reader\n    }\n  }\n\n  /**\n   * Cross-frame instanceof check.\n   *\n   * @param {string} type Instance type\n   * @param {object} obj Object instance\n   * @returns {boolean} Returns true if the object is of the given instance.\n   */\n  function isInstanceOf(type, obj) {\n    // Cross-frame instanceof check\n    return Object.prototype.toString.call(obj) === '[object ' + type + ']'\n  }\n\n  /**\n   * @typedef { HTMLImageElement|HTMLCanvasElement } Result\n   */\n\n  /**\n   * Loads an image for a given File object.\n   *\n   * @param {Blob|string} file Blob object or image URL\n   * @param {Function|object} [callback] Image load event callback or options\n   * @param {object} [options] Options object\n   * @returns {HTMLImageElement|FileReader|Promise<Result>} Object\n   */\n  function loadImage(file, callback, options) {\n    /**\n     * Promise executor\n     *\n     * @param {Function} resolve Resolution function\n     * @param {Function} reject Rejection function\n     * @returns {HTMLImageElement|FileReader} Object\n     */\n    function executor(resolve, reject) {\n      var img = document.createElement('img')\n      var url\n      /**\n       * Callback for the fetchBlob call.\n       *\n       * @param {HTMLImageElement|HTMLCanvasElement} img Error object\n       * @param {object} data Data object\n       * @returns {undefined} Undefined\n       */\n      function resolveWrapper(img, data) {\n        if (resolve === reject) {\n          // Not using Promises\n          if (resolve) resolve(img, data)\n          return\n        } else if (img instanceof Error) {\n          reject(img)\n          return\n        }\n        data = data || {} // eslint-disable-line no-param-reassign\n        data.image = img\n        resolve(data)\n      }\n      /**\n       * Callback for the fetchBlob call.\n       *\n       * @param {Blob} blob Blob object\n       * @param {Error} err Error object\n       */\n      function fetchBlobCallback(blob, err) {\n        if (err && $.console) console.log(err) // eslint-disable-line no-console\n        if (blob && isInstanceOf('Blob', blob)) {\n          file = blob // eslint-disable-line no-param-reassign\n          url = createObjectURL(file)\n        } else {\n          url = file\n          if (options && options.crossOrigin) {\n            img.crossOrigin = options.crossOrigin\n          }\n        }\n        img.src = url\n      }\n      img.onerror = function (event) {\n        revokeHelper(url, options)\n        if (reject) reject.call(img, event)\n      }\n      img.onload = function () {\n        revokeHelper(url, options)\n        var data = {\n          originalWidth: img.naturalWidth || img.width,\n          originalHeight: img.naturalHeight || img.height\n        }\n        try {\n          loadImage.transform(img, options, resolveWrapper, file, data)\n        } catch (error) {\n          if (reject) reject(error)\n        }\n      }\n      if (typeof file === 'string') {\n        if (loadImage.requiresMetaData(options)) {\n          loadImage.fetchBlob(file, fetchBlobCallback, options)\n        } else {\n          fetchBlobCallback()\n        }\n        return img\n      } else if (isInstanceOf('Blob', file) || isInstanceOf('File', file)) {\n        url = createObjectURL(file)\n        if (url) {\n          img.src = url\n          return img\n        }\n        return readFile(\n          file,\n          function (url) {\n            img.src = url\n          },\n          reject\n        )\n      }\n    }\n    if ($.Promise && typeof callback !== 'function') {\n      options = callback // eslint-disable-line no-param-reassign\n      return new Promise(executor)\n    }\n    return executor(callback, callback)\n  }\n\n  // Determines if metadata should be loaded automatically.\n  // Requires the load image meta extension to load metadata.\n  loadImage.requiresMetaData = function (options) {\n    return options && options.meta\n  }\n\n  // If the callback given to this function returns a blob, it is used as image\n  // source instead of the original url and overrides the file argument used in\n  // the onload and onerror event callbacks:\n  loadImage.fetchBlob = function (url, callback) {\n    callback()\n  }\n\n  loadImage.transform = function (img, options, callback, file, data) {\n    callback(img, data)\n  }\n\n  loadImage.global = $\n  loadImage.readFile = readFile\n  loadImage.isInstanceOf = isInstanceOf\n  loadImage.createObjectURL = createObjectURL\n  loadImage.revokeObjectURL = revokeObjectURL\n\n  if (typeof define === 'function' && define.amd) {\n    define(function () {\n      return loadImage\n    })\n  } else if (typeof module === 'object' && module.exports) {\n    module.exports = loadImage\n  } else {\n    $.loadImage = loadImage\n  }\n})((typeof window !== 'undefined' && window) || this)\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale.js":"/*\n * JavaScript Load Image Scaling\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var originalTransform = loadImage.transform\n\n  loadImage.createCanvas = function (width, height, offscreen) {\n    if (offscreen && loadImage.global.OffscreenCanvas) {\n      return new OffscreenCanvas(width, height)\n    }\n    var canvas = document.createElement('canvas')\n    canvas.width = width\n    canvas.height = height\n    return canvas\n  }\n\n  loadImage.transform = function (img, options, callback, file, data) {\n    originalTransform.call(\n      loadImage,\n      loadImage.scale(img, options, data),\n      options,\n      callback,\n      file,\n      data\n    )\n  }\n\n  // Transform image coordinates, allows to override e.g.\n  // the canvas orientation based on the orientation option,\n  // gets canvas, options and data passed as arguments:\n  loadImage.transformCoordinates = function () {}\n\n  // Returns transformed options, allows to override e.g.\n  // maxWidth, maxHeight and crop options based on the aspectRatio.\n  // gets img, options, data passed as arguments:\n  loadImage.getTransformedOptions = function (img, options) {\n    var aspectRatio = options.aspectRatio\n    var newOptions\n    var i\n    var width\n    var height\n    if (!aspectRatio) {\n      return options\n    }\n    newOptions = {}\n    for (i in options) {\n      if (Object.prototype.hasOwnProperty.call(options, i)) {\n        newOptions[i] = options[i]\n      }\n    }\n    newOptions.crop = true\n    width = img.naturalWidth || img.width\n    height = img.naturalHeight || img.height\n    if (width / height > aspectRatio) {\n      newOptions.maxWidth = height * aspectRatio\n      newOptions.maxHeight = height\n    } else {\n      newOptions.maxWidth = width\n      newOptions.maxHeight = width / aspectRatio\n    }\n    return newOptions\n  }\n\n  // Canvas render method, allows to implement a different rendering algorithm:\n  loadImage.drawImage = function (\n    img,\n    canvas,\n    sourceX,\n    sourceY,\n    sourceWidth,\n    sourceHeight,\n    destWidth,\n    destHeight,\n    options\n  ) {\n    var ctx = canvas.getContext('2d')\n    if (options.imageSmoothingEnabled === false) {\n      ctx.msImageSmoothingEnabled = false\n      ctx.imageSmoothingEnabled = false\n    } else if (options.imageSmoothingQuality) {\n      ctx.imageSmoothingQuality = options.imageSmoothingQuality\n    }\n    ctx.drawImage(\n      img,\n      sourceX,\n      sourceY,\n      sourceWidth,\n      sourceHeight,\n      0,\n      0,\n      destWidth,\n      destHeight\n    )\n    return ctx\n  }\n\n  // Determines if the target image should be a canvas element:\n  loadImage.requiresCanvas = function (options) {\n    return options.canvas || options.crop || !!options.aspectRatio\n  }\n\n  // Scales and/or crops the given image (img or canvas HTML element)\n  // using the given options:\n  loadImage.scale = function (img, options, data) {\n    // eslint-disable-next-line no-param-reassign\n    options = options || {}\n    // eslint-disable-next-line no-param-reassign\n    data = data || {}\n    var useCanvas =\n      img.getContext ||\n      (loadImage.requiresCanvas(options) &&\n        !!loadImage.global.HTMLCanvasElement)\n    var width = img.naturalWidth || img.width\n    var height = img.naturalHeight || img.height\n    var destWidth = width\n    var destHeight = height\n    var maxWidth\n    var maxHeight\n    var minWidth\n    var minHeight\n    var sourceWidth\n    var sourceHeight\n    var sourceX\n    var sourceY\n    var pixelRatio\n    var downsamplingRatio\n    var tmp\n    var canvas\n    /**\n     * Scales up image dimensions\n     */\n    function scaleUp() {\n      var scale = Math.max(\n        (minWidth || destWidth) / destWidth,\n        (minHeight || destHeight) / destHeight\n      )\n      if (scale > 1) {\n        destWidth *= scale\n        destHeight *= scale\n      }\n    }\n    /**\n     * Scales down image dimensions\n     */\n    function scaleDown() {\n      var scale = Math.min(\n        (maxWidth || destWidth) / destWidth,\n        (maxHeight || destHeight) / destHeight\n      )\n      if (scale < 1) {\n        destWidth *= scale\n        destHeight *= scale\n      }\n    }\n    if (useCanvas) {\n      // eslint-disable-next-line no-param-reassign\n      options = loadImage.getTransformedOptions(img, options, data)\n      sourceX = options.left || 0\n      sourceY = options.top || 0\n      if (options.sourceWidth) {\n        sourceWidth = options.sourceWidth\n        if (options.right !== undefined && options.left === undefined) {\n          sourceX = width - sourceWidth - options.right\n        }\n      } else {\n        sourceWidth = width - sourceX - (options.right || 0)\n      }\n      if (options.sourceHeight) {\n        sourceHeight = options.sourceHeight\n        if (options.bottom !== undefined && options.top === undefined) {\n          sourceY = height - sourceHeight - options.bottom\n        }\n      } else {\n        sourceHeight = height - sourceY - (options.bottom || 0)\n      }\n      destWidth = sourceWidth\n      destHeight = sourceHeight\n    }\n    maxWidth = options.maxWidth\n    maxHeight = options.maxHeight\n    minWidth = options.minWidth\n    minHeight = options.minHeight\n    if (useCanvas && maxWidth && maxHeight && options.crop) {\n      destWidth = maxWidth\n      destHeight = maxHeight\n      tmp = sourceWidth / sourceHeight - maxWidth / maxHeight\n      if (tmp < 0) {\n        sourceHeight = (maxHeight * sourceWidth) / maxWidth\n        if (options.top === undefined && options.bottom === undefined) {\n          sourceY = (height - sourceHeight) / 2\n        }\n      } else if (tmp > 0) {\n        sourceWidth = (maxWidth * sourceHeight) / maxHeight\n        if (options.left === undefined && options.right === undefined) {\n          sourceX = (width - sourceWidth) / 2\n        }\n      }\n    } else {\n      if (options.contain || options.cover) {\n        minWidth = maxWidth = maxWidth || minWidth\n        minHeight = maxHeight = maxHeight || minHeight\n      }\n      if (options.cover) {\n        scaleDown()\n        scaleUp()\n      } else {\n        scaleUp()\n        scaleDown()\n      }\n    }\n    if (useCanvas) {\n      pixelRatio = options.pixelRatio\n      if (\n        pixelRatio > 1 &&\n        // Check if the image has not yet had the device pixel ratio applied:\n        !(\n          img.style.width &&\n          Math.floor(parseFloat(img.style.width, 10)) ===\n            Math.floor(width / pixelRatio)\n        )\n      ) {\n        destWidth *= pixelRatio\n        destHeight *= pixelRatio\n      }\n      // Check if workaround for Chromium orientation crop bug is required:\n      // https://bugs.chromium.org/p/chromium/issues/detail?id=1074354\n      if (\n        loadImage.orientationCropBug &&\n        !img.getContext &&\n        (sourceX || sourceY || sourceWidth !== width || sourceHeight !== height)\n      ) {\n        // Write the complete source image to an intermediate canvas first:\n        tmp = img\n        // eslint-disable-next-line no-param-reassign\n        img = loadImage.createCanvas(width, height, true)\n        loadImage.drawImage(\n          tmp,\n          img,\n          0,\n          0,\n          width,\n          height,\n          width,\n          height,\n          options\n        )\n      }\n      downsamplingRatio = options.downsamplingRatio\n      if (\n        downsamplingRatio > 0 &&\n        downsamplingRatio < 1 &&\n        destWidth < sourceWidth &&\n        destHeight < sourceHeight\n      ) {\n        while (sourceWidth * downsamplingRatio > destWidth) {\n          canvas = loadImage.createCanvas(\n            sourceWidth * downsamplingRatio,\n            sourceHeight * downsamplingRatio,\n            true\n          )\n          loadImage.drawImage(\n            img,\n            canvas,\n            sourceX,\n            sourceY,\n            sourceWidth,\n            sourceHeight,\n            canvas.width,\n            canvas.height,\n            options\n          )\n          sourceX = 0\n          sourceY = 0\n          sourceWidth = canvas.width\n          sourceHeight = canvas.height\n          // eslint-disable-next-line no-param-reassign\n          img = canvas\n        }\n      }\n      canvas = loadImage.createCanvas(destWidth, destHeight)\n      loadImage.transformCoordinates(canvas, options, data)\n      if (pixelRatio > 1) {\n        canvas.style.width = canvas.width / pixelRatio + 'px'\n      }\n      loadImage\n        .drawImage(\n          img,\n          canvas,\n          sourceX,\n          sourceY,\n          sourceWidth,\n          sourceHeight,\n          destWidth,\n          destHeight,\n          options\n        )\n        .setTransform(1, 0, 0, 1, 0, 0) // reset to the identity matrix\n      return canvas\n    }\n    img.width = destWidth\n    img.height = destHeight\n    return img\n  }\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-orientation.js":"/*\n * JavaScript Load Image Orientation\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/*\nExif orientation values to correctly display the letter F:\n\n    1             2\n  \u2588\u2588\u2588\u2588\u2588\u2588        \u2588\u2588\u2588\u2588\u2588\u2588\n  \u2588\u2588                \u2588\u2588\n  \u2588\u2588\u2588\u2588            \u2588\u2588\u2588\u2588\n  \u2588\u2588                \u2588\u2588\n  \u2588\u2588                \u2588\u2588\n\n    3             4\n      \u2588\u2588        \u2588\u2588\n      \u2588\u2588        \u2588\u2588\n    \u2588\u2588\u2588\u2588        \u2588\u2588\u2588\u2588\n      \u2588\u2588        \u2588\u2588\n  \u2588\u2588\u2588\u2588\u2588\u2588        \u2588\u2588\u2588\u2588\u2588\u2588\n\n    5             6\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588    \u2588\u2588\n\u2588\u2588  \u2588\u2588        \u2588\u2588  \u2588\u2588\n\u2588\u2588            \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\n\n    7             8\n        \u2588\u2588    \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\n    \u2588\u2588  \u2588\u2588        \u2588\u2588  \u2588\u2588\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588            \u2588\u2588\n\n*/\n\n/* global define, module, require */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale', 'jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-scale'),\n      require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta')\n    )\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var originalTransform = loadImage.transform\n  var originalRequiresCanvas = loadImage.requiresCanvas\n  var originalRequiresMetaData = loadImage.requiresMetaData\n  var originalTransformCoordinates = loadImage.transformCoordinates\n  var originalGetTransformedOptions = loadImage.getTransformedOptions\n\n  ;(function ($) {\n    // Guard for non-browser environments (e.g. server-side rendering):\n    if (!$.global.document) return\n    // black+white 3x2 JPEG, with the following meta information set:\n    // - EXIF Orientation: 6 (Rotated 90\u00b0 CCW)\n    // Image data layout (B=black, F=white):\n    // BFF\n    // BBB\n    var testImageURL =\n      'data:image/jpeg;base64,/9j/4QAiRXhpZgAATU0AKgAAAAgAAQESAAMAAAABAAYAAAA' +\n      'AAAD/2wCEAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBA' +\n      'QEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQE' +\n      'BAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAf/AABEIAAIAAwMBEQACEQEDEQH/x' +\n      'ABRAAEAAAAAAAAAAAAAAAAAAAAKEAEBAQADAQEAAAAAAAAAAAAGBQQDCAkCBwEBAAAAAAA' +\n      'AAAAAAAAAAAAAABEBAAAAAAAAAAAAAAAAAAAAAP/aAAwDAQACEQMRAD8AG8T9NfSMEVMhQ' +\n      'voP3fFiRZ+MTHDifa/95OFSZU5OzRzxkyejv8ciEfhSceSXGjS8eSdLnZc2HDm4M3BxcXw' +\n      'H/9k='\n    var img = document.createElement('img')\n    img.onload = function () {\n      // Check if the browser supports automatic image orientation:\n      $.orientation = img.width === 2 && img.height === 3\n      if ($.orientation) {\n        var canvas = $.createCanvas(1, 1, true)\n        var ctx = canvas.getContext('2d')\n        ctx.drawImage(img, 1, 1, 1, 1, 0, 0, 1, 1)\n        // Check if the source image coordinates (sX, sY, sWidth, sHeight) are\n        // correctly applied to the auto-orientated image, which should result\n        // in a white opaque pixel (e.g. in Safari).\n        // Browsers that show a transparent pixel (e.g. Chromium) fail to crop\n        // auto-oriented images correctly and require a workaround, e.g.\n        // drawing the complete source image to an intermediate canvas first.\n        // See https://bugs.chromium.org/p/chromium/issues/detail?id=1074354\n        $.orientationCropBug =\n          ctx.getImageData(0, 0, 1, 1).data.toString() !== '255,255,255,255'\n      }\n    }\n    img.src = testImageURL\n  })(loadImage)\n\n  /**\n   * Determines if the orientation requires a canvas element.\n   *\n   * @param {object} [options] Options object\n   * @param {boolean} [withMetaData] Is metadata required for orientation\n   * @returns {boolean} Returns true if orientation requires canvas/meta\n   */\n  function requiresCanvasOrientation(options, withMetaData) {\n    var orientation = options && options.orientation\n    return (\n      // Exif orientation for browsers without automatic image orientation:\n      (orientation === true && !loadImage.orientation) ||\n      // Orientation reset for browsers with automatic image orientation:\n      (orientation === 1 && loadImage.orientation) ||\n      // Orientation to defined value, requires meta for orientation reset only:\n      ((!withMetaData || loadImage.orientation) &&\n        orientation > 1 &&\n        orientation < 9)\n    )\n  }\n\n  /**\n   * Determines if the image requires an orientation change.\n   *\n   * @param {number} [orientation] Defined orientation value\n   * @param {number} [autoOrientation] Auto-orientation based on Exif data\n   * @returns {boolean} Returns true if an orientation change is required\n   */\n  function requiresOrientationChange(orientation, autoOrientation) {\n    return (\n      orientation !== autoOrientation &&\n      ((orientation === 1 && autoOrientation > 1 && autoOrientation < 9) ||\n        (orientation > 1 && orientation < 9))\n    )\n  }\n\n  /**\n   * Determines orientation combinations that require a rotation by 180\u00b0.\n   *\n   * The following is a list of combinations that return true:\n   *\n   * 2 (flip) => 5 (rot90,flip), 7 (rot90,flip), 6 (rot90), 8 (rot90)\n   * 4 (flip) => 5 (rot90,flip), 7 (rot90,flip), 6 (rot90), 8 (rot90)\n   *\n   * 5 (rot90,flip) => 2 (flip), 4 (flip), 6 (rot90), 8 (rot90)\n   * 7 (rot90,flip) => 2 (flip), 4 (flip), 6 (rot90), 8 (rot90)\n   *\n   * 6 (rot90) => 2 (flip), 4 (flip), 5 (rot90,flip), 7 (rot90,flip)\n   * 8 (rot90) => 2 (flip), 4 (flip), 5 (rot90,flip), 7 (rot90,flip)\n   *\n   * @param {number} [orientation] Defined orientation value\n   * @param {number} [autoOrientation] Auto-orientation based on Exif data\n   * @returns {boolean} Returns true if rotation by 180\u00b0 is required\n   */\n  function requiresRot180(orientation, autoOrientation) {\n    if (autoOrientation > 1 && autoOrientation < 9) {\n      switch (orientation) {\n        case 2:\n        case 4:\n          return autoOrientation > 4\n        case 5:\n        case 7:\n          return autoOrientation % 2 === 0\n        case 6:\n        case 8:\n          return (\n            autoOrientation === 2 ||\n            autoOrientation === 4 ||\n            autoOrientation === 5 ||\n            autoOrientation === 7\n          )\n      }\n    }\n    return false\n  }\n\n  // Determines if the target image should be a canvas element:\n  loadImage.requiresCanvas = function (options) {\n    return (\n      requiresCanvasOrientation(options) ||\n      originalRequiresCanvas.call(loadImage, options)\n    )\n  }\n\n  // Determines if metadata should be loaded automatically:\n  loadImage.requiresMetaData = function (options) {\n    return (\n      requiresCanvasOrientation(options, true) ||\n      originalRequiresMetaData.call(loadImage, options)\n    )\n  }\n\n  loadImage.transform = function (img, options, callback, file, data) {\n    originalTransform.call(\n      loadImage,\n      img,\n      options,\n      function (img, data) {\n        if (data) {\n          var autoOrientation =\n            loadImage.orientation && data.exif && data.exif.get('Orientation')\n          if (autoOrientation > 4 && autoOrientation < 9) {\n            // Automatic image orientation switched image dimensions\n            var originalWidth = data.originalWidth\n            var originalHeight = data.originalHeight\n            data.originalWidth = originalHeight\n            data.originalHeight = originalWidth\n          }\n        }\n        callback(img, data)\n      },\n      file,\n      data\n    )\n  }\n\n  // Transforms coordinate and dimension options\n  // based on the given orientation option:\n  loadImage.getTransformedOptions = function (img, opts, data) {\n    var options = originalGetTransformedOptions.call(loadImage, img, opts)\n    var exifOrientation = data.exif && data.exif.get('Orientation')\n    var orientation = options.orientation\n    var autoOrientation = loadImage.orientation && exifOrientation\n    if (orientation === true) orientation = exifOrientation\n    if (!requiresOrientationChange(orientation, autoOrientation)) {\n      return options\n    }\n    var top = options.top\n    var right = options.right\n    var bottom = options.bottom\n    var left = options.left\n    var newOptions = {}\n    for (var i in options) {\n      if (Object.prototype.hasOwnProperty.call(options, i)) {\n        newOptions[i] = options[i]\n      }\n    }\n    newOptions.orientation = orientation\n    if (\n      (orientation > 4 && !(autoOrientation > 4)) ||\n      (orientation < 5 && autoOrientation > 4)\n    ) {\n      // Image dimensions and target dimensions are switched\n      newOptions.maxWidth = options.maxHeight\n      newOptions.maxHeight = options.maxWidth\n      newOptions.minWidth = options.minHeight\n      newOptions.minHeight = options.minWidth\n      newOptions.sourceWidth = options.sourceHeight\n      newOptions.sourceHeight = options.sourceWidth\n    }\n    if (autoOrientation > 1) {\n      // Browsers which correctly apply source image coordinates to\n      // auto-oriented images\n      switch (autoOrientation) {\n        case 2:\n          // Horizontal flip\n          right = options.left\n          left = options.right\n          break\n        case 3:\n          // 180\u00b0 Rotate CCW\n          top = options.bottom\n          right = options.left\n          bottom = options.top\n          left = options.right\n          break\n        case 4:\n          // Vertical flip\n          top = options.bottom\n          bottom = options.top\n          break\n        case 5:\n          // Horizontal flip + 90\u00b0 Rotate CCW\n          top = options.left\n          right = options.bottom\n          bottom = options.right\n          left = options.top\n          break\n        case 6:\n          // 90\u00b0 Rotate CCW\n          top = options.left\n          right = options.top\n          bottom = options.right\n          left = options.bottom\n          break\n        case 7:\n          // Vertical flip + 90\u00b0 Rotate CCW\n          top = options.right\n          right = options.top\n          bottom = options.left\n          left = options.bottom\n          break\n        case 8:\n          // 90\u00b0 Rotate CW\n          top = options.right\n          right = options.bottom\n          bottom = options.left\n          left = options.top\n          break\n      }\n      // Some orientation combinations require additional rotation by 180\u00b0:\n      if (requiresRot180(orientation, autoOrientation)) {\n        var tmpTop = top\n        var tmpRight = right\n        top = bottom\n        right = left\n        bottom = tmpTop\n        left = tmpRight\n      }\n    }\n    newOptions.top = top\n    newOptions.right = right\n    newOptions.bottom = bottom\n    newOptions.left = left\n    // Account for defined browser orientation:\n    switch (orientation) {\n      case 2:\n        // Horizontal flip\n        newOptions.right = left\n        newOptions.left = right\n        break\n      case 3:\n        // 180\u00b0 Rotate CCW\n        newOptions.top = bottom\n        newOptions.right = left\n        newOptions.bottom = top\n        newOptions.left = right\n        break\n      case 4:\n        // Vertical flip\n        newOptions.top = bottom\n        newOptions.bottom = top\n        break\n      case 5:\n        // Vertical flip + 90\u00b0 Rotate CW\n        newOptions.top = left\n        newOptions.right = bottom\n        newOptions.bottom = right\n        newOptions.left = top\n        break\n      case 6:\n        // 90\u00b0 Rotate CW\n        newOptions.top = right\n        newOptions.right = bottom\n        newOptions.bottom = left\n        newOptions.left = top\n        break\n      case 7:\n        // Horizontal flip + 90\u00b0 Rotate CW\n        newOptions.top = right\n        newOptions.right = top\n        newOptions.bottom = left\n        newOptions.left = bottom\n        break\n      case 8:\n        // 90\u00b0 Rotate CCW\n        newOptions.top = left\n        newOptions.right = top\n        newOptions.bottom = right\n        newOptions.left = bottom\n        break\n    }\n    return newOptions\n  }\n\n  // Transform image orientation based on the given EXIF orientation option:\n  loadImage.transformCoordinates = function (canvas, options, data) {\n    originalTransformCoordinates.call(loadImage, canvas, options, data)\n    var orientation = options.orientation\n    var autoOrientation =\n      loadImage.orientation && data.exif && data.exif.get('Orientation')\n    if (!requiresOrientationChange(orientation, autoOrientation)) {\n      return\n    }\n    var ctx = canvas.getContext('2d')\n    var width = canvas.width\n    var height = canvas.height\n    var sourceWidth = width\n    var sourceHeight = height\n    if (\n      (orientation > 4 && !(autoOrientation > 4)) ||\n      (orientation < 5 && autoOrientation > 4)\n    ) {\n      // Image dimensions and target dimensions are switched\n      canvas.width = height\n      canvas.height = width\n    }\n    if (orientation > 4) {\n      // Destination and source dimensions are switched\n      sourceWidth = height\n      sourceHeight = width\n    }\n    // Reset automatic browser orientation:\n    switch (autoOrientation) {\n      case 2:\n        // Horizontal flip\n        ctx.translate(sourceWidth, 0)\n        ctx.scale(-1, 1)\n        break\n      case 3:\n        // 180\u00b0 Rotate CCW\n        ctx.translate(sourceWidth, sourceHeight)\n        ctx.rotate(Math.PI)\n        break\n      case 4:\n        // Vertical flip\n        ctx.translate(0, sourceHeight)\n        ctx.scale(1, -1)\n        break\n      case 5:\n        // Horizontal flip + 90\u00b0 Rotate CCW\n        ctx.rotate(-0.5 * Math.PI)\n        ctx.scale(-1, 1)\n        break\n      case 6:\n        // 90\u00b0 Rotate CCW\n        ctx.rotate(-0.5 * Math.PI)\n        ctx.translate(-sourceWidth, 0)\n        break\n      case 7:\n        // Vertical flip + 90\u00b0 Rotate CCW\n        ctx.rotate(-0.5 * Math.PI)\n        ctx.translate(-sourceWidth, sourceHeight)\n        ctx.scale(1, -1)\n        break\n      case 8:\n        // 90\u00b0 Rotate CW\n        ctx.rotate(0.5 * Math.PI)\n        ctx.translate(0, -sourceHeight)\n        break\n    }\n    // Some orientation combinations require additional rotation by 180\u00b0:\n    if (requiresRot180(orientation, autoOrientation)) {\n      ctx.translate(sourceWidth, sourceHeight)\n      ctx.rotate(Math.PI)\n    }\n    switch (orientation) {\n      case 2:\n        // Horizontal flip\n        ctx.translate(width, 0)\n        ctx.scale(-1, 1)\n        break\n      case 3:\n        // 180\u00b0 Rotate CCW\n        ctx.translate(width, height)\n        ctx.rotate(Math.PI)\n        break\n      case 4:\n        // Vertical flip\n        ctx.translate(0, height)\n        ctx.scale(1, -1)\n        break\n      case 5:\n        // Vertical flip + 90\u00b0 Rotate CW\n        ctx.rotate(0.5 * Math.PI)\n        ctx.scale(1, -1)\n        break\n      case 6:\n        // 90\u00b0 Rotate CW\n        ctx.rotate(0.5 * Math.PI)\n        ctx.translate(0, -height)\n        break\n      case 7:\n        // Horizontal flip + 90\u00b0 Rotate CW\n        ctx.rotate(0.5 * Math.PI)\n        ctx.translate(width, -height)\n        ctx.scale(-1, 1)\n        break\n      case 8:\n        // 90\u00b0 Rotate CCW\n        ctx.rotate(-0.5 * Math.PI)\n        ctx.translate(-width, 0)\n        break\n    }\n  }\n})\n","jquery/fileUploader/vendor/blueimp-load-image/js/load-image-meta.js":"/*\n * JavaScript Load Image Meta\n * https://github.com/blueimp/JavaScript-Load-Image\n *\n * Copyright 2013, Sebastian Tschan\n * https://blueimp.net\n *\n * Image metadata handling implementation\n * based on the help and contribution of\n * Achim St\u00f6hr.\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n */\n\n/* global define, module, require, Promise, DataView, Uint8Array, ArrayBuffer */\n\n;(function (factory) {\n  'use strict'\n  if (typeof define === 'function' && define.amd) {\n    // Register as an anonymous AMD module:\n    define(['jquery/fileUploader/vendor/blueimp-load-image/js/load-image'], factory)\n  } else if (typeof module === 'object' && module.exports) {\n    factory(require('jquery/fileUploader/vendor/blueimp-load-image/js/load-image'))\n  } else {\n    // Browser globals:\n    factory(window.loadImage)\n  }\n})(function (loadImage) {\n  'use strict'\n\n  var global = loadImage.global\n  var originalTransform = loadImage.transform\n\n  var blobSlice =\n    global.Blob &&\n    (Blob.prototype.slice ||\n      Blob.prototype.webkitSlice ||\n      Blob.prototype.mozSlice)\n\n  var bufferSlice =\n    (global.ArrayBuffer && ArrayBuffer.prototype.slice) ||\n    function (begin, end) {\n      // Polyfill for IE10, which does not support ArrayBuffer.slice\n      // eslint-disable-next-line no-param-reassign\n      end = end || this.byteLength - begin\n      var arr1 = new Uint8Array(this, begin, end)\n      var arr2 = new Uint8Array(end)\n      arr2.set(arr1)\n      return arr2.buffer\n    }\n\n  var metaDataParsers = {\n    jpeg: {\n      0xffe1: [], // APP1 marker\n      0xffed: [] // APP13 marker\n    }\n  }\n\n  /**\n   * Parses image metadata and calls the callback with an object argument\n   * with the following property:\n   * - imageHead: The complete image head as ArrayBuffer\n   * The options argument accepts an object and supports the following\n   * properties:\n   * - maxMetaDataSize: Defines the maximum number of bytes to parse.\n   * - disableImageHead: Disables creating the imageHead property.\n   *\n   * @param {Blob} file Blob object\n   * @param {Function} [callback] Callback function\n   * @param {object} [options] Parsing options\n   * @param {object} [data] Result data object\n   * @returns {Promise<object>|undefined} Returns Promise if no callback given.\n   */\n  function parseMetaData(file, callback, options, data) {\n    var that = this\n    /**\n     * Promise executor\n     *\n     * @param {Function} resolve Resolution function\n     * @param {Function} reject Rejection function\n     * @returns {undefined} Undefined\n     */\n    function executor(resolve, reject) {\n      if (\n        !(\n          global.DataView &&\n          blobSlice &&\n          file &&\n          file.size >= 12 &&\n          file.type === 'image/jpeg'\n        )\n      ) {\n        // Nothing to parse\n        return resolve(data)\n      }\n      // 256 KiB should contain all EXIF/ICC/IPTC segments:\n      var maxMetaDataSize = options.maxMetaDataSize || 262144\n      if (\n        !loadImage.readFile(\n          blobSlice.call(file, 0, maxMetaDataSize),\n          function (buffer) {\n            // Note on endianness:\n            // Since the marker and length bytes in JPEG files are always\n            // stored in big endian order, we can leave the endian parameter\n            // of the DataView methods undefined, defaulting to big endian.\n            var dataView = new DataView(buffer)\n            // Check for the JPEG marker (0xffd8):\n            if (dataView.getUint16(0) !== 0xffd8) {\n              return reject(\n                new Error('Invalid JPEG file: Missing JPEG marker.')\n              )\n            }\n            var offset = 2\n            var maxOffset = dataView.byteLength - 4\n            var headLength = offset\n            var markerBytes\n            var markerLength\n            var parsers\n            var i\n            while (offset < maxOffset) {\n              markerBytes = dataView.getUint16(offset)\n              // Search for APPn (0xffeN) and COM (0xfffe) markers,\n              // which contain application-specific metadata like\n              // Exif, ICC and IPTC data and text comments:\n              if (\n                (markerBytes >= 0xffe0 && markerBytes <= 0xffef) ||\n                markerBytes === 0xfffe\n              ) {\n                // The marker bytes (2) are always followed by\n                // the length bytes (2), indicating the length of the\n                // marker segment, which includes the length bytes,\n                // but not the marker bytes, so we add 2:\n                markerLength = dataView.getUint16(offset + 2) + 2\n                if (offset + markerLength > dataView.byteLength) {\n                  // eslint-disable-next-line no-console\n                  console.log('Invalid JPEG metadata: Invalid segment size.')\n                  break\n                }\n                parsers = metaDataParsers.jpeg[markerBytes]\n                if (parsers && !options.disableMetaDataParsers) {\n                  for (i = 0; i < parsers.length; i += 1) {\n                    parsers[i].call(\n                      that,\n                      dataView,\n                      offset,\n                      markerLength,\n                      data,\n                      options\n                    )\n                  }\n                }\n                offset += markerLength\n                headLength = offset\n              } else {\n                // Not an APPn or COM marker, probably safe to\n                // assume that this is the end of the metadata\n                break\n              }\n            }\n            // Meta length must be longer than JPEG marker (2)\n            // plus APPn marker (2), followed by length bytes (2):\n            if (!options.disableImageHead && headLength > 6) {\n              data.imageHead = bufferSlice.call(buffer, 0, headLength)\n            }\n            resolve(data)\n          },\n          reject,\n          'readAsArrayBuffer'\n        )\n      ) {\n        // No support for the FileReader interface, nothing to parse\n        resolve(data)\n      }\n    }\n    options = options || {} // eslint-disable-line no-param-reassign\n    if (global.Promise && typeof callback !== 'function') {\n      options = callback || {} // eslint-disable-line no-param-reassign\n      data = options // eslint-disable-line no-param-reassign\n      return new Promise(executor)\n    }\n    data = data || {} // eslint-disable-line no-param-reassign\n    return executor(callback, callback)\n  }\n\n  /**\n   * Replaces the head of a JPEG Blob\n   *\n   * @param {Blob} blob Blob object\n   * @param {ArrayBuffer} oldHead Old JPEG head\n   * @param {ArrayBuffer} newHead New JPEG head\n   * @returns {Blob} Combined Blob\n   */\n  function replaceJPEGHead(blob, oldHead, newHead) {\n    if (!blob || !oldHead || !newHead) return null\n    return new Blob([newHead, blobSlice.call(blob, oldHead.byteLength)], {\n      type: 'image/jpeg'\n    })\n  }\n\n  /**\n   * Replaces the image head of a JPEG blob with the given one.\n   * Returns a Promise or calls the callback with the new Blob.\n   *\n   * @param {Blob} blob Blob object\n   * @param {ArrayBuffer} head New JPEG head\n   * @param {Function} [callback] Callback function\n   * @returns {Promise<Blob|null>|undefined} Combined Blob\n   */\n  function replaceHead(blob, head, callback) {\n    var options = { maxMetaDataSize: 256, disableMetaDataParsers: true }\n    if (!callback && global.Promise) {\n      return parseMetaData(blob, options).then(function (data) {\n        return replaceJPEGHead(blob, data.imageHead, head)\n      })\n    }\n    parseMetaData(\n      blob,\n      function (data) {\n        callback(replaceJPEGHead(blob, data.imageHead, head))\n      },\n      options\n    )\n  }\n\n  loadImage.transform = function (img, options, callback, file, data) {\n    if (loadImage.requiresMetaData(options)) {\n      data = data || {} // eslint-disable-line no-param-reassign\n      parseMetaData(\n        file,\n        function (result) {\n          if (result !== data) {\n            // eslint-disable-next-line no-console\n            if (global.console) console.log(result)\n            result = data // eslint-disable-line no-param-reassign\n          }\n          originalTransform.call(\n            loadImage,\n            img,\n            options,\n            callback,\n            file,\n            result\n          )\n        },\n        options,\n        data\n      )\n    } else {\n      originalTransform.apply(loadImage, arguments)\n    }\n  }\n\n  loadImage.blobSlice = blobSlice\n  loadImage.bufferSlice = bufferSlice\n  loadImage.replaceHead = replaceHead\n  loadImage.parseMetaData = parseMetaData\n  loadImage.metaDataParsers = metaDataParsers\n})\n","jquery/fileUploader/vendor/blueimp-canvas-to-blob/js/canvas-to-blob.js":"/*\n * JavaScript Canvas to Blob\n * https://github.com/blueimp/JavaScript-Canvas-to-Blob\n *\n * Copyright 2012, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n *\n * Based on stackoverflow user Stoive's code snippet:\n * http://stackoverflow.com/q/4998908\n */\n\n/* global define, Uint8Array, ArrayBuffer, module */\n\n;(function (window) {\n  'use strict'\n\n  var CanvasPrototype =\n    window.HTMLCanvasElement && window.HTMLCanvasElement.prototype\n  var hasBlobConstructor =\n    window.Blob &&\n    (function () {\n      try {\n        return Boolean(new Blob())\n      } catch (e) {\n        return false\n      }\n    })()\n  var hasArrayBufferViewSupport =\n    hasBlobConstructor &&\n    window.Uint8Array &&\n    (function () {\n      try {\n        return new Blob([new Uint8Array(100)]).size === 100\n      } catch (e) {\n        return false\n      }\n    })()\n  var BlobBuilder =\n    window.BlobBuilder ||\n    window.WebKitBlobBuilder ||\n    window.MozBlobBuilder ||\n    window.MSBlobBuilder\n  var dataURIPattern = /^data:((.*?)(;charset=.*?)?)(;base64)?,/\n  var dataURLtoBlob =\n    (hasBlobConstructor || BlobBuilder) &&\n    window.atob &&\n    window.ArrayBuffer &&\n    window.Uint8Array &&\n    function (dataURI) {\n      var matches,\n        mediaType,\n        isBase64,\n        dataString,\n        byteString,\n        arrayBuffer,\n        intArray,\n        i,\n        bb\n      // Parse the dataURI components as per RFC 2397\n      matches = dataURI.match(dataURIPattern)\n      if (!matches) {\n        throw new Error('invalid data URI')\n      }\n      // Default to text/plain;charset=US-ASCII\n      mediaType = matches[2]\n        ? matches[1]\n        : 'text/plain' + (matches[3] || ';charset=US-ASCII')\n      isBase64 = !!matches[4]\n      dataString = dataURI.slice(matches[0].length)\n      if (isBase64) {\n        // Convert base64 to raw binary data held in a string:\n        byteString = atob(dataString)\n      } else {\n        // Convert base64/URLEncoded data component to raw binary:\n        byteString = decodeURIComponent(dataString)\n      }\n      // Write the bytes of the string to an ArrayBuffer:\n      arrayBuffer = new ArrayBuffer(byteString.length)\n      intArray = new Uint8Array(arrayBuffer)\n      for (i = 0; i < byteString.length; i += 1) {\n        intArray[i] = byteString.charCodeAt(i)\n      }\n      // Write the ArrayBuffer (or ArrayBufferView) to a blob:\n      if (hasBlobConstructor) {\n        return new Blob([hasArrayBufferViewSupport ? intArray : arrayBuffer], {\n          type: mediaType\n        })\n      }\n      bb = new BlobBuilder()\n      bb.append(arrayBuffer)\n      return bb.getBlob(mediaType)\n    }\n  if (window.HTMLCanvasElement && !CanvasPrototype.toBlob) {\n    if (CanvasPrototype.mozGetAsFile) {\n      CanvasPrototype.toBlob = function (callback, type, quality) {\n        var self = this\n        setTimeout(function () {\n          if (quality && CanvasPrototype.toDataURL && dataURLtoBlob) {\n            callback(dataURLtoBlob(self.toDataURL(type, quality)))\n          } else {\n            callback(self.mozGetAsFile('blob', type))\n          }\n        })\n      }\n    } else if (CanvasPrototype.toDataURL && dataURLtoBlob) {\n      if (CanvasPrototype.msToBlob) {\n        CanvasPrototype.toBlob = function (callback, type, quality) {\n          var self = this\n          setTimeout(function () {\n            if (\n              ((type && type !== 'image/png') || quality) &&\n              CanvasPrototype.toDataURL &&\n              dataURLtoBlob\n            ) {\n              callback(dataURLtoBlob(self.toDataURL(type, quality)))\n            } else {\n              callback(self.msToBlob(type))\n            }\n          })\n        }\n      } else {\n        CanvasPrototype.toBlob = function (callback, type, quality) {\n          var self = this\n          setTimeout(function () {\n            callback(dataURLtoBlob(self.toDataURL(type, quality)))\n          })\n        }\n      }\n    }\n  }\n  if (typeof define === 'function' && define.amd) {\n    define(function () {\n      return dataURLtoBlob\n    })\n  } else if (typeof module === 'object' && module.exports) {\n    module.exports = dataURLtoBlob\n  } else {\n    window.dataURLtoBlob = dataURLtoBlob\n  }\n})(window)\n"}
}});
