require.config({"config": {
        "jsbuild":{"Magento_PageBuilder/js/content-type/observable-updater.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"consoleLogger\", \"knockout\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/appearance-config\", \"Magento_PageBuilder/js/content-type/observable-updater/attributes\", \"Magento_PageBuilder/js/content-type/observable-updater/css\", \"Magento_PageBuilder/js/content-type/observable-updater/html\", \"Magento_PageBuilder/js/content-type/observable-updater/style\"], function (_consoleLogger, _knockout, _underscore, _config, _appearanceConfig, _attributes, _css, _html, _style) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ObservableUpdater = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {typeof ConverterPool} converterPool\n     * @param {typeof MassConverterPool} massConverterPool\n     * @param {(config: object) => string} converterResolver\n     */\n    function ObservableUpdater(converterPool, massConverterPool, converterResolver) {\n      this.previousData = {};\n      this.bindingGenerators = {\n        attributes: _attributes,\n        css: _css,\n        html: _html,\n        style: _style\n      };\n      this.converterPool = converterPool;\n      this.massConverterPool = massConverterPool;\n      this.converterResolver = converterResolver;\n    }\n    /**\n     * Update the associated viewModel with the generated data\n     *\n     * We create an API for each potential binding and make it available in the master and preview templates through\n     * the data variable. Each data variable will have associated observables that are updated on a data change.\n     *\n     * @param {Preview} viewModel\n     * @param {DataObject} data\n     * @param {DataObject} dataStores\n     */\n\n\n    var _proto = ObservableUpdater.prototype;\n\n    _proto.update = function update(viewModel, data, dataStores) {\n      var appearance = data && data.appearance !== undefined ? data.appearance : undefined;\n      var appearanceConfiguration = (0, _appearanceConfig)(viewModel.contentType.config.name, appearance);\n\n      if (undefined === appearanceConfiguration || undefined === appearanceConfiguration.elements) {\n        return;\n      } // Generate Knockout bindings in objects for usage in preview and master templates\n\n\n      var generatedBindings = this.generateKnockoutBindings(appearanceConfiguration.elements, appearanceConfiguration.converters, data, dataStores);\n\n      var _loop = function _loop(element) {\n        if (generatedBindings.hasOwnProperty(element)) {\n          // Ensure every element is represented by an object\n          if (viewModel.data[element] === undefined) {\n            viewModel.data[element] = {};\n          }\n          /**\n           * Iterate through each elements data (css, style, attributes) and apply data updates within the\n           * observable. If no observable already exists create a new one.\n           */\n\n\n          Object.keys(generatedBindings[element]).forEach(function (key) {\n            var elementBindings = viewModel.data[element][key];\n\n            if (elementBindings !== undefined && _knockout.isObservable(elementBindings)) {\n              elementBindings(generatedBindings[element][key]);\n            } else {\n              viewModel.data[element][key] = _knockout.observable(generatedBindings[element][key]);\n            }\n          });\n        }\n      };\n\n      for (var element in generatedBindings) {\n        _loop(element);\n      }\n    }\n    /**\n     * Generate binding object to be applied to master format\n     *\n     * This function iterates through each element defined in the content types XML and generates a nested object of\n     * the associated Knockout binding data. We support 5 bindings attributes, style, css, html & tag.\n     *\n     * @param elements\n     * @param converters\n     * @param data\n     * @param dataStoreStates\n     */\n    ;\n\n    _proto.generateKnockoutBindings = function generateKnockoutBindings(elements, converters, data, dataStoreStates) {\n      var convertedData = this.convertData(data, converters);\n      var generatedData = {};\n\n      for (var _i = 0, _Object$keys = Object.keys(elements); _i < _Object$keys.length; _i++) {\n        var elementName = _Object$keys[_i];\n        var elementConfig = elements[elementName];\n\n        if (this.previousData[elementName] === undefined) {\n          this.previousData[elementName] = {};\n        }\n\n        generatedData[elementName] = {\n          attributes: this.generateKnockoutBinding(\"attributes\", elementName, elementConfig, data),\n          style: _config.getMode() === \"Preview\" ? this.generateKnockoutBinding(\"style\", elementName, elementConfig, data) : this.generateKnockoutBindingForBreakpoints(\"style\", elementName, elementConfig, data, dataStoreStates),\n          css: elementConfig.css.var in convertedData ? this.generateKnockoutBinding(\"css\", elementName, elementConfig, data) : {},\n          html: this.generateKnockoutBinding(\"html\", elementName, elementConfig, data)\n        };\n\n        if (elementConfig.tag !== undefined && elementConfig.tag.var !== undefined) {\n          if (generatedData[elementName][elementConfig.tag.var] === undefined) {\n            generatedData[elementName][elementConfig.tag.var] = \"\";\n          }\n\n          generatedData[elementName][elementConfig.tag.var] = convertedData[elementConfig.tag.var];\n        }\n      }\n\n      return generatedData;\n    }\n    /**\n     * Process data for elements before its converted to knockout format\n     *\n     * @param {object} data\n     * @param {ConverterInterface[]} convertersConfig\n     * @returns {object}\n     */\n    ;\n\n    _proto.convertData = function convertData(data, convertersConfig) {\n      for (var _iterator = _createForOfIteratorHelperLoose(convertersConfig), _step; !(_step = _iterator()).done;) {\n        var converterConfig = _step.value;\n        this.massConverterPool.get(converterConfig.component).toDom(data, converterConfig.config);\n      }\n\n      return data;\n    }\n    /**\n     * Generate an individual knockout binding\n     *\n     * @param binding\n     * @param elementName\n     * @param config\n     * @param data\n     */\n    ;\n\n    _proto.generateKnockoutBinding = function generateKnockoutBinding(binding, elementName, config, data) {\n      if (config[binding] === undefined) {\n        return {};\n      }\n\n      var previousData = {};\n\n      if (this.previousData[elementName][binding] !== undefined) {\n        previousData = this.previousData[elementName][binding];\n      }\n\n      if (this.bindingGenerators[binding] === undefined) {\n        _consoleLogger.error(\"Unable to find Knockout binding generator for \" + binding);\n\n        return {};\n      } // Generate the associated binding using our dedicated generators\n\n\n      var generatedBindingData = this.bindingGenerators[binding](elementName, config, data, this.converterResolver, this.converterPool, previousData);\n      this.previousData[elementName][binding] = generatedBindingData;\n      return generatedBindingData;\n    }\n    /**\n     * Generate an individual knockout binding for breakpoints\n     *\n     * @param binding\n     * @param elementName\n     * @param config\n     * @param data\n     * @param dataStoreStates\n     */\n    ;\n\n    _proto.generateKnockoutBindingForBreakpoints = function generateKnockoutBindingForBreakpoints(binding, elementName, config, data, dataStoreStates) {\n      var _this = this;\n\n      var result = {};\n      Object.keys(dataStoreStates).forEach(function (name) {\n        result[name] = _underscore.isEmpty(dataStoreStates[name]) ? {} : _this.generateKnockoutBinding(binding, elementName, config, dataStoreStates[name]);\n      });\n      return result;\n    };\n\n    return ObservableUpdater;\n  }();\n\n  return ObservableUpdater;\n});\n//# sourceMappingURL=observable-updater.js.map","Magento_PageBuilder/js/content-type/appearance-config.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Get config for appearance\n   *\n   * @param {string} contentType\n   * @param {string} appearance\n   * @returns {ContentTypeConfigAppearanceInterface}\n   * @api\n   */\n  function getAppearanceConfig(contentType, appearance) {\n    var contentTypeConfig = _config.getContentTypeConfig(contentType);\n\n    var config;\n\n    if (contentTypeConfig.appearances !== undefined) {\n      if (!appearance) {\n        for (var key in contentTypeConfig.appearances) {\n          if (!!contentTypeConfig.appearances[key].default) {\n            appearance = key;\n            break;\n          }\n        }\n      }\n\n      if (appearance) {\n        config = contentTypeConfig.appearances[appearance];\n      }\n    }\n\n    return config;\n  }\n\n  return getAppearanceConfig;\n});\n//# sourceMappingURL=appearance-config.js.map","Magento_PageBuilder/js/content-type/converter-resolver.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Resolve converter\n   *\n   * @param {DataMappingInterface} config\n   * @return string\n   */\n  function resolve(config) {\n    return config.converter;\n  }\n\n  return resolve;\n});\n//# sourceMappingURL=converter-resolver.js.map","Magento_PageBuilder/js/content-type/master.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/appearance-config\"], function (_underscore, _object, _appearanceConfig) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Master = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Master(contentType, observableUpdater) {\n      this.data = {};\n      this.contentType = contentType;\n      this.observableUpdater = observableUpdater;\n      this.bindEvents();\n    }\n    /**\n     * Retrieve the render template\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Master.prototype;\n\n    /**\n     * Get content type data\n     *\n     * @param {string} element\n     * @returns {DataObject}\n     * @deprecated\n     */\n    _proto.getData = function getData(element) {\n      var data = _underscore.extend({}, this.contentType.dataStore.getState());\n\n      if (undefined === element) {\n        return data;\n      }\n\n      var appearanceConfiguration = (0, _appearanceConfig)(this.contentType.config.name, data.appearance);\n      var config = appearanceConfiguration.elements;\n      data = this.observableUpdater.convertData(data, appearanceConfiguration.converters);\n      var result = {};\n\n      if (undefined !== config[element].tag.var) {\n        result[config[element].tag.var] = (0, _object.get)(data, config[element].tag.var);\n      }\n\n      return result;\n    }\n    /**\n     * Destroys current instance\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      return;\n    }\n    /**\n     * Attach event to updating data in data store to update observables\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this = this;\n\n      this.contentType.dataStore.subscribe(function () {\n        _this.updateObservables();\n      });\n    }\n    /**\n     * After observables updated, allows to modify observables\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      return;\n    }\n    /**\n     * Update observables\n     *\n     * @deprecated\n     */\n    ;\n\n    _proto.updateObservables = function updateObservables() {\n      this.observableUpdater.update(this, _underscore.extend({\n        name: this.contentType.config.name\n      }, this.contentType.dataStore.getState()), this.contentType.getDataStoresStates());\n      this.afterObservablesUpdated();\n    };\n\n    _createClass(Master, [{\n      key: \"template\",\n      get: function get() {\n        return (0, _appearanceConfig)(this.contentType.config.name, this.getData().appearance).master_template;\n      }\n    }]);\n\n    return Master;\n  }();\n\n  return Master;\n});\n//# sourceMappingURL=master.js.map","Magento_PageBuilder/js/content-type/preview-factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/content-type/observable-updater-factory\", \"Magento_PageBuilder/js/content-type/preview-converter-resolver\"], function (_loader, _observableUpdaterFactory, _previewConverterResolver) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create new preview instance\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {ContentTypeConfigInterface} config\n   * @returns {Promise<Preview | PreviewCollection>}\n   */\n  function create(contentType, config) {\n    return new Promise(function (resolve, reject) {\n      (0, _observableUpdaterFactory)(config, _previewConverterResolver).then(function (observableUpdater) {\n        (0, _loader)([config.preview_component], function (previewComponent) {\n          try {\n            var preview = new previewComponent(contentType, config, observableUpdater);\n            resolve(preview);\n          } catch (error) {\n            reject(\"Error within preview component (\" + config.preview_component + \") for \" + config.name + \".\");\n            console.error(error);\n          }\n        }, function (error) {\n          reject(\"Unable to load preview component (\" + config.preview_component + \") for \" + config.name + \". Please \" + \"check preview component exists and content type configuration is correct.\");\n          console.error(error);\n        });\n      }).catch(function (error) {\n        console.error(error);\n        return null;\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=preview-factory.js.map","Magento_PageBuilder/js/content-type/tabs/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"tabs\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _tabs, _underscore, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _promiseDeferred, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Wait for the tabs instance to mount and the container to be ready\n\n      _this.focusedTab = _knockout.observable(null);\n      _this.activeTab = _knockout.observable(0);\n      _this.onContainerRenderDeferred = (0, _promiseDeferred)();\n      _this.mountAfterDeferred = (0, _promiseDeferred)();\n      Promise.all([_this.onContainerRenderDeferred.promise, _this.mountAfterDeferred.promise]).then(function (_ref) {\n        var element = _ref[0],\n            expectedChildren = _ref[1];\n        // We always create 1 tab when dropping tabs into the instance\n        expectedChildren = expectedChildren || 1; // Wait until all children's DOM elements are present before building the tabs instance\n\n        (0, _delayUntil)(function () {\n          _this.element = element;\n\n          _this.buildTabs();\n        }, function () {\n          return (0, _jquery)(element).find(\".pagebuilder-tab-item\").length === expectedChildren;\n        });\n      }); // Resolve our deferred when the tabs item mounts with expect children\n\n      _events.on(\"tabs:mountAfter\", function (args) {\n        if (args.contentType.id === _this.contentType.id && args.expectChildren !== undefined) {\n          _this.mountAfterDeferred.resolve(args.expectChildren);\n        }\n      });\n\n      _events.on(\"tab-item:mountAfter\", function (args) {\n        if (_this.element && args.contentType.parentContentType.id === _this.contentType.id) {\n          _this.refreshTabs();\n        }\n      });\n\n      _events.on(\"tab-item:renderAfter\", function (args) {\n        if (_this.element && args.contentType.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.refreshTabs();\n          });\n        }\n      }); // Set the active tab to the new position of the sorted tab\n\n\n      _events.on(\"tab-item:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _this.refreshTabs(); // We need to wait for the tabs to refresh before executing the focus\n\n\n          _underscore.defer(function () {\n            var newPosition = args.index > 0 ? args.index - 1 : 0;\n\n            _this.setFocusedTab(newPosition, true);\n          });\n        }\n      }); // Refresh tab contents and set the focus to the new position of the sorted tab\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this.contentType.id) {\n          _this.refreshTabs(args.newPosition, true);\n          /**\n           * Update the default active tab if its position was affected by the sorting\n           */\n\n\n          var defaultActiveTab = +_this.activeTab();\n          var newDefaultActiveTab = defaultActiveTab;\n\n          if (args.originalPosition === defaultActiveTab) {\n            newDefaultActiveTab = args.newPosition;\n          } else if (args.originalPosition < defaultActiveTab && args.newPosition >= defaultActiveTab) {\n            // a tab was moved from the left of the default active tab the right of it, changing its index\n            newDefaultActiveTab--;\n          } else if (args.originalPosition > defaultActiveTab && args.newPosition <= defaultActiveTab) {\n            // a tab was moved from the right of the default active tab the left of it, changing its index\n            newDefaultActiveTab++;\n          }\n\n          _this.updateData(\"default_active\", newDefaultActiveTab.toString());\n        }\n      }); // Monitor focus tab to start / stop interaction on the stage, debounce to avoid duplicate calls\n\n\n      _this.focusedTab.subscribe(_underscore.debounce(function (index) {\n        if (index !== null) {\n          _events.trigger(\"stage:interactionStart\");\n\n          (0, _delayUntil)(function () {\n            return (0, _jquery)((0, _jquery)(_this.wrapperElement).find(\".tab-header\")[index]).find(\"[contenteditable]\").focus();\n          }, function () {\n            return (0, _jquery)((0, _jquery)(_this.wrapperElement).find(\".tab-header\")[index]).find(\"[contenteditable]\").length > 0;\n          }, 10);\n        } else {\n          // We have to force the stop as the event firing is inconsistent for certain operations\n          _events.trigger(\"stage:interactionStop\", {\n            force: true\n          });\n        }\n      }, 1));\n\n      return _this;\n    }\n    /**\n     * Remove focused tab\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.destroy = function destroy() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.destroy.call(this);\n\n      _underscore.defer(function () {\n        return _this2.setFocusedTab(null);\n      });\n    }\n    /**\n     * Refresh the tabs instance when new content appears\n     *\n     * @param {number} focusIndex\n     * @param {boolean} forceFocus\n     * @param {number} activeIndex\n     */\n    ;\n\n    _proto.refreshTabs = function refreshTabs(focusIndex, forceFocus, activeIndex) {\n      try {\n        (0, _jquery)(this.element).tabs(\"refresh\");\n\n        if (focusIndex >= 0) {\n          this.setFocusedTab(focusIndex, forceFocus);\n        } else if (activeIndex) {\n          this.setActiveTab(activeIndex);\n        } // update sortability of tabs\n\n\n        var sortableElement = (0, _jquery)(this.element).find(\".tabs-navigation\");\n\n        if (sortableElement.hasClass(\"ui-sortable\")) {\n          if (this.contentType.children().length <= 1) {\n            sortableElement.sortable(\"disable\");\n          } else {\n            sortableElement.sortable(\"enable\");\n          }\n        }\n      } catch (e) {\n        this.buildTabs();\n      }\n    }\n    /**\n     * Set the active tab, we maintain a reference to it in an observable for when we rebuild the tab instance\n     *\n     * @param {number} index\n     */\n    ;\n\n    _proto.setActiveTab = function setActiveTab(index) {\n      var _this3 = this;\n\n      if (index !== null) {\n        // Added to prevent mismatched fragment error caused by not yet rendered tab-item\n        index = parseInt(index.toString(), 10);\n        (0, _delayUntil)(function () {\n          (0, _jquery)(_this3.element).tabs(\"option\", \"active\", index);\n\n          _this3.activeTab(index);\n\n          _events.trigger(\"contentType:redrawAfter\", {\n            id: _this3.contentType.id,\n            contentType: _this3\n          });\n        }, function () {\n          return (0, _jquery)(_this3.element).find(\".pagebuilder-tab-item\").length >= index + 1;\n        });\n      }\n    }\n    /**\n     * Set the focused tab\n     *\n     * @param {number} index\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.setFocusedTab = function setFocusedTab(index, force) {\n      if (force === void 0) {\n        force = false;\n      }\n\n      this.setActiveTab(index);\n\n      if (force) {\n        this.focusedTab(null);\n      }\n\n      this.focusedTab(index);\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add\"),\n        action: this.addTab,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Add a tab\n     */\n    ;\n\n    _proto.addTab = function addTab() {\n      var _this4 = this;\n\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"tab-item\"), this.contentType, this.contentType.stageId).then(function (tab) {\n        _events.on(\"tab-item:mountAfter\", function (args) {\n          if (args.id === tab.id) {\n            _this4.setFocusedTab(_this4.contentType.children().length - 1);\n\n            _events.off(\"tab-item:\" + tab.id + \":mountAfter\");\n          }\n        }, \"tab-item:\" + tab.id + \":mountAfter\");\n\n        _this4.contentType.addChild(tab, _this4.contentType.children().length); // Update the default tab title when adding a new tab\n\n\n        tab.dataStore.set(\"tab_name\", (0, _translate)(\"Tab\") + \" \" + (_this4.contentType.children.indexOf(tab) + 1));\n      });\n    }\n    /**\n     * On render init the tabs widget\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.onContainerRender = function onContainerRender(element) {\n      this.element = element;\n      this.onContainerRenderDeferred.resolve(element);\n    }\n    /**\n     * Copy over border styles to the tab headers\n     *\n     * @returns {any}\n     */\n    ;\n\n    _proto.getTabHeaderStyles = function getTabHeaderStyles() {\n      var headerStyles = this.data.headers.style();\n      return _extends({}, headerStyles, {\n        marginBottom: \"-\" + headerStyles.borderWidth,\n        marginLeft: \"-\" + headerStyles.borderWidth\n      });\n    }\n    /**\n     * Get the sortable options for the tab heading sorting\n     *\n     * @returns {JQueryUI.SortableOptions}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions() {\n      var self = this;\n      var borderWidth;\n      return {\n        handle: \".tab-drag-handle\",\n        tolerance: \"pointer\",\n        cursor: \"grabbing\",\n        cursorAt: {\n          left: 8,\n          top: 25\n        },\n\n        /**\n         * Provide custom helper element\n         *\n         * @param {Event} event\n         * @param {JQueryUI.Sortable} element\n         * @returns {Element}\n         */\n        helper: function helper(event, element) {\n          var helper = (0, _jquery)(element).clone().css(\"opacity\", \"0.7\");\n          helper[0].querySelector(\".pagebuilder-options\").remove();\n          return helper[0];\n        },\n\n        /**\n         * Add a padding to the navigation UL to resolve issues of negative margins when sorting\n         *\n         * @param {Event} event\n         * @param {JQueryUI.SortableUIParams} ui\n         */\n        start: function start(event, ui) {\n          /**\n           * Due to the way we use negative margins to overlap the borders we need to apply a padding to the\n           * container when we're moving the first item to ensure the tabs remain in the same place.\n           */\n          if (ui.item.index() === 0) {\n            borderWidth = parseInt(ui.item.css(\"borderWidth\"), 10) || 1;\n            (0, _jquery)(this).css(\"paddingLeft\", borderWidth);\n          }\n\n          ui.helper.css(\"width\", \"\");\n\n          _events.trigger(\"stage:interactionStart\");\n\n          self.disableInteracting = true;\n        },\n\n        /**\n         * Remove the padding once the operation is completed\n         *\n         * @param {Event} event\n         * @param {JQueryUI.SortableUIParams} ui\n         */\n        stop: function stop(event, ui) {\n          (0, _jquery)(this).css(\"paddingLeft\", \"\");\n\n          _events.trigger(\"stage:interactionStop\");\n\n          self.disableInteracting = false;\n        },\n        placeholder: {\n          /**\n           * Provide custom placeholder element\n           *\n           * @param {JQuery} item\n           * @returns {JQuery}\n           */\n          element: function element(item) {\n            var placeholder = item.clone().css({\n              display: \"inline-block\",\n              opacity: \"0.3\"\n            }).removeClass(\"focused\").addClass(\"sortable-placeholder\");\n            placeholder[0].querySelector(\".pagebuilder-options\").remove();\n            return placeholder[0];\n          },\n          update: function update() {\n            return;\n          }\n        }\n      };\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this5 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this); // ContentType being mounted onto container\n\n\n      _events.on(\"tabs:dropAfter\", function (args) {\n        if (args.id === _this5.contentType.id && _this5.contentType.children().length === 0) {\n          _this5.addTab();\n        }\n      }); // ContentType being removed from container\n\n\n      _events.on(\"tab-item:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this5.contentType.id) {\n          // Mark the previous tab as active\n          var newIndex = args.index - 1 >= 0 ? args.index - 1 : 0;\n\n          _this5.refreshTabs(newIndex, true);\n        }\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedTab;\n      var duplicatedTabIndex;\n\n      _events.on(\"tab-item:duplicateAfter\", function (args) {\n        if (_this5.contentType.id === args.duplicateContentType.parentContentType.id && args.direct) {\n          var tabData = args.duplicateContentType.dataStore.getState();\n          args.duplicateContentType.dataStore.set(\"tab_name\", tabData.tab_name.toString() + \" copy\");\n          duplicatedTab = args.duplicateContentType;\n          duplicatedTabIndex = args.index;\n        }\n      });\n\n      _events.on(\"tab-item:mountAfter\", function (args) {\n        if (duplicatedTab && args.id === duplicatedTab.id) {\n          _this5.refreshTabs(duplicatedTabIndex, true);\n\n          duplicatedTab = duplicatedTabIndex = null;\n        }\n\n        if (_this5.contentType.id === args.contentType.parentContentType.id) {\n          _this5.updateTabNamesInDataStore();\n\n          args.contentType.dataStore.subscribe(function () {\n            _this5.updateTabNamesInDataStore();\n          });\n        }\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _this5.activeTab(data.default_active);\n      });\n    }\n    /**\n     * Update data store with active options\n     */\n    ;\n\n    _proto.updateTabNamesInDataStore = function updateTabNamesInDataStore() {\n      var activeOptions = [];\n      this.contentType.children().forEach(function (tab, index) {\n        var tabData = tab.dataStore.getState();\n        activeOptions.push({\n          label: tabData.tab_name.toString(),\n          labeltitle: tabData.tab_name.toString(),\n          value: index\n        });\n      });\n      this.contentType.dataStore.set(\"_default_active_options\", activeOptions);\n    }\n    /**\n     * Assign a debounce and delay to the init of tabs to ensure the DOM has updated\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n    ;\n\n    _proto.buildTabs = function buildTabs(activeTabIndex) {\n      var _this6 = this;\n\n      if (activeTabIndex === void 0) {\n        activeTabIndex = this.activeTab() || 0;\n      }\n\n      this.ready = false;\n\n      if (this.element && this.element.children.length > 0) {\n        var focusedTab = this.focusedTab();\n\n        try {\n          (0, _jquery)(this.element).tabs(\"destroy\");\n        } catch (e) {// We aren't concerned if this fails, tabs throws an Exception when we cannot destroy\n        }\n\n        (0, _jquery)(this.element).tabs({\n          create: function create() {\n            _this6.ready = true; // Ensure focus tab is restored after a rebuild cycle\n\n            if (focusedTab !== null) {\n              _this6.setFocusedTab(focusedTab, true);\n            } else {\n              _this6.setFocusedTab(null);\n\n              if (activeTabIndex) {\n                _this6.setActiveTab(activeTabIndex);\n              }\n            }\n          },\n\n          /**\n           * Trigger redraw event since new content is being displayed\n           */\n          activate: function activate() {\n            _events.trigger(\"contentType:redrawAfter\", {\n              element: _this6.element\n            });\n          }\n        });\n      }\n    };\n\n    return Preview;\n  }(_previewCollection); // Resolve issue with jQuery UI tabs content typing events on content editable areas\n\n\n  var originalTabKeyDown = _jquery.ui.tabs.prototype._tabKeydown;\n\n  _jquery.ui.tabs.prototype._tabKeydown = function (event) {\n    // If the target is content editable don't handle any events\n    if ((0, _jquery)(event.target).attr(\"contenteditable\")) {\n      return;\n    }\n\n    originalTabKeyDown.call(this, event);\n  };\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/tabs/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'jquery-ui-modules/tabs'\n], function ($, events) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element);\n\n        // Ignore stage builder preview tabs\n        if ($element.is('.pagebuilder-tabs')) {\n            return;\n        }\n\n        // Disambiguate between the mage/tabs component which is loaded randomly depending on requirejs order.\n        $.ui.tabs({\n            active: $element.data('activeTab') || 0,\n            create:\n\n                /**\n                 * Adjust the margin bottom of the navigation to correctly display the active tab\n                 */\n                function () {\n                    var borderWidth = parseInt($element.find('.tabs-content').css('borderWidth').toString(), 10);\n\n                    $element.find('.tabs-navigation').css('marginBottom', -borderWidth);\n                    $element.find('.tabs-navigation li:not(:first-child)').css('marginLeft', -borderWidth);\n                },\n            activate:\n\n                /**\n                 * Trigger redraw event since new content is being displayed\n                 */\n                function () {\n                    events.trigger('contentType:redrawAfter', {\n                        element: element\n                    });\n                }\n        }, element);\n    };\n});\n","Magento_PageBuilder/js/content-type/tabs/mass-converter/header-alignment.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var HeaderAlignment = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function HeaderAlignment() {}\n\n    var _proto = HeaderAlignment.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      return data;\n    }\n    /**\n     * Add our tab alignment class into the data for the tabs\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      data.css_classes += \" tab-align-\" + (0, _object.get)(data, config.navigation_alignment_variable, \"left\");\n      return data;\n    };\n\n    return HeaderAlignment;\n  }();\n\n  return HeaderAlignment;\n});\n//# sourceMappingURL=header-alignment.js.map","Magento_PageBuilder/js/content-type/video/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    _proto.isHosted = function isHosted(src) {\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      return vimeoRegExp.test(src) || youtubeRegExp.test(src);\n    }\n    /**\n     * After render callback\n     *\n     * @param {HTMLVideoElement} videoElement\n     * @param {Preview} self\n     */\n    ;\n\n    _proto.onAfterRender = function onAfterRender(videoElement, self) {\n      // Assign muted attribute explicitly due to API issues\n      videoElement.muted = self.data.video.attributes().autoplay;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/video/master.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type/master\"], function (_master) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Master = /*#__PURE__*/function (_master2) {\n    \"use strict\";\n\n    _inheritsLoose(Master, _master2);\n\n    function Master() {\n      return _master2.apply(this, arguments) || this;\n    }\n\n    var _proto = Master.prototype;\n\n    _proto.isHosted = function isHosted(src) {\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      return vimeoRegExp.test(src) || youtubeRegExp.test(src);\n    };\n\n    return Master;\n  }(_master);\n\n  return Master;\n});\n//# sourceMappingURL=master.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/videosrc.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoSrc = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoSrc() {}\n\n    /**\n     * Parse YouTube parameters from given URL and Autoplay setting from UI\n     *\n     * @param url string\n     * @param data DataObject\n     * @returns string\n     * @private\n     */\n    VideoSrc.parseYoutubeGetParams = function parseYoutubeGetParams(url, data) {\n      var acceptableYouTubeParams = [\"rel\", \"controls\", \"autoplay\", \"mute\", \"loop\", \"playlist\", \"cc_lang_pref\", \"cc_load_policy\", \"color\", \"disablekb\", \"end\", \"fs\", \"hl\", \"iv_load_policy\", \"modestbranding\", \"start\"];\n      var a = document.createElement(\"a\");\n      a.href = url;\n      var urlGetParams = {};\n      a.search.slice(a.search.indexOf(\"?\") + 1).split(\"&\").map(function (hash) {\n        var _hash$split = hash.split(\"=\"),\n            key = _hash$split[0],\n            val = _hash$split[1];\n\n        urlGetParams[key] = decodeURIComponent(val);\n      });\n      var filteredGetParams = {};\n\n      for (var _i = 0, _acceptableYouTubePar = acceptableYouTubeParams; _i < _acceptableYouTubePar.length; _i++) {\n        var param = _acceptableYouTubePar[_i];\n\n        if (urlGetParams.hasOwnProperty(param)) {\n          filteredGetParams[param] = urlGetParams[param];\n        }\n      }\n\n      if (data.autoplay === \"true\") {\n        filteredGetParams.autoplay = \"1\";\n        filteredGetParams.mute = \"1\";\n      } else {\n        delete filteredGetParams.autoplay;\n        delete filteredGetParams.mute;\n      }\n\n      var processedGetParams = [];\n\n      for (var _param in filteredGetParams) {\n        if (filteredGetParams.hasOwnProperty(_param)) {\n          processedGetParams.push(encodeURI(_param + \"=\" + filteredGetParams[_param]));\n        }\n      }\n\n      return processedGetParams.length > 0 ? \"?\" + processedGetParams.join(\"&\") : \"\";\n    }\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    ;\n\n    var _proto = VideoSrc.prototype;\n\n    _proto.fromDom = function fromDom(value) {\n      value = value.replace(/\\?autoplay=1&mute=1/g, \"\");\n      value = value.replace(/&autoplay=1&mute=1/g, \"\");\n      value = value.replace(/\\?title=0&byline=0&portrait=0/g, \"\");\n      value = value.replace(/&autoplay=1&autopause=0&muted=1/g, \"\");\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value === undefined) {\n        return \"\";\n      }\n\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n\n      if (youtubeRegExp.test(value)) {\n        return \"https://www.youtube.com/embed/\" + youtubeRegExp.exec(value)[1] + VideoSrc.parseYoutubeGetParams(value, data);\n      } else if (vimeoRegExp.test(value)) {\n        return \"https://player.vimeo.com/video/\" + vimeoRegExp.exec(value)[3] + \"?title=0&byline=0&portrait=0\" + (data.autoplay === \"true\" ? \"&autoplay=1&autopause=0&muted=1\" : \"\");\n      }\n\n      return value;\n    };\n\n    return VideoSrc;\n  }();\n\n  return VideoSrc;\n});\n//# sourceMappingURL=videosrc.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/autoplay.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoSrc = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoSrc() {}\n\n    var _proto = VideoSrc.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"true\" ? value : \"false\";\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {boolean|string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value === \"true\" ? true : null;\n    };\n\n    return VideoSrc;\n  }();\n\n  return VideoSrc;\n});\n//# sourceMappingURL=autoplay.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var fileRegExp = new RegExp(\"^(webm:|mp4:|ogv:)\");\n\n      if (fileRegExp.test(value)) {\n        return value.substr(fileRegExp.exec(value)[0].length);\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value === undefined) {\n        return \"\";\n      }\n\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      var fileRegExp = new RegExp(\"^(?:https:|http:)?\\\\/\\\\/.*[\\\\\\\\\\\\/].+\\\\.(webm|mp4|ogv)(?!\\w)\");\n\n      if (youtubeRegExp.test(value)) {\n        return \"https://www.youtube.com/embed/\" + youtubeRegExp.exec(value)[1];\n      } else if (vimeoRegExp.test(value)) {\n        return \"https://player.vimeo.com/video/\" + vimeoRegExp.exec(value)[3] + \"?title=0&byline=0&portrait=0\";\n      } else if (fileRegExp.test(value)) {\n        var result = fileRegExp.exec(value);\n        return result[1] + \":\" + value;\n      }\n\n      return value;\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/content-type/products/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"slick\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _events, _slick, _underscore, _config, _hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * Define keys which when changed should not trigger the slider to be rebuilt\n     *\n     * @type {string[]}\n     */\n\n    /**\n     * @inheritdoc\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.displayPreview = _knockout.observable(false);\n      _this.previewElement = _jquery.Deferred();\n      _this.widgetUnsanitizedHtml = _knockout.observable();\n      _this.slidesToShow = 5;\n      _this.productItemSelector = \".product-item\";\n      _this.centerModeClass = \"center-mode\";\n      _this.messages = {\n        EMPTY: (0, _translate)(\"Empty Products\"),\n        NO_RESULTS: (0, _translate)(\"No products were found matching your condition\"),\n        LOADING: (0, _translate)(\"Loading...\"),\n        UNKNOWN_ERROR: (0, _translate)(\"An unknown error occurred. Please try again.\")\n      };\n      _this.ignoredKeysForBuild = [\"margins_and_padding\", \"border\", \"border_color\", \"border_radius\", \"border_width\", \"css_classes\", \"text_align\"];\n      _this.placeholderText = _knockout.observable(_this.messages.EMPTY); // Redraw slider after content type gets redrawn\n\n      _events.on(\"contentType:redrawAfter\", function (args) {\n        if (_this.element && _this.element.children) {\n          var $element = (0, _jquery)(_this.element.children);\n\n          if (args.element && $element.closest(args.element).length) {\n            $element.slick(\"setPosition\");\n          }\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        var viewports = _config.getConfig(\"viewports\");\n\n        if (_this.element && _this.appearance() === \"carousel\") {\n          _this.slidesToShow = parseFloat(viewports[args.viewport].options.products.default.slidesToShow);\n\n          _this.destroySlider();\n\n          _this.initSlider();\n        }\n      });\n\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * On afterRender callback.\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.onAfterRender = function onAfterRender(element) {\n      this.element = element;\n      this.previewElement.resolve(element);\n      this.initSlider();\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      var _this2 = this;\n\n      _preview2.prototype.afterObservablesUpdated.call(this);\n\n      var data = this.contentType.dataStore.getState();\n\n      if (this.hasDataChanged(this.previousData, data)) {\n        this.displayPreview(false);\n\n        if (typeof data.conditions_encoded !== \"string\" || data.conditions_encoded.length === 0) {\n          this.placeholderText(this.messages.EMPTY);\n          return;\n        }\n\n        var url = _config.getConfig(\"preview_url\");\n\n        var requestConfig = {\n          // Prevent caching\n          method: \"POST\",\n          data: {\n            role: this.config.name,\n            directive: this.data.main.html()\n          }\n        };\n        this.placeholderText(this.messages.LOADING);\n\n        _jquery.ajax(url, requestConfig).done(function (response) {\n          if (typeof response.data !== \"object\" || !Boolean(response.data.content)) {\n            _this2.placeholderText(_this2.messages.NO_RESULTS);\n\n            return;\n          }\n\n          if (response.data.error) {\n            _this2.widgetUnsanitizedHtml(response.data.error);\n          } else {\n            _this2.widgetUnsanitizedHtml(response.data.content);\n\n            _this2.displayPreview(true);\n          }\n\n          _this2.previewElement.done(function () {\n            (0, _jquery)(_this2.element).trigger(\"contentUpdated\");\n          });\n        }).fail(function () {\n          _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n        });\n      }\n\n      this.previousData = Object.assign({}, data);\n    };\n\n    _proto.initSlider = function initSlider() {\n      if (this.element && this.appearance() === \"carousel\") {\n        (0, _jquery)(this.element.children).slick(this.buildSlickConfig());\n      }\n    };\n\n    _proto.destroySlider = function destroySlider() {\n      (0, _jquery)(this.element.children).slick(\"unslick\");\n    }\n    /**\n     * Build the slick config object\n     *\n     * @returns {{autoplay: boolean; autoplay: number; infinite: boolean; arrows: boolean; dots: boolean;\n     * centerMode: boolean; slidesToScroll: number; slidesToShow: number;}}\n     */\n    ;\n\n    _proto.buildSlickConfig = function buildSlickConfig() {\n      var attributes = this.data.main.attributes();\n      var productCount = (0, _jquery)(this.widgetUnsanitizedHtml()).find(this.productItemSelector).length;\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      var currentViewport = this.viewport();\n      var carouselMode = attributes[\"data-carousel-mode\"];\n      var config = {\n        slidesToShow: this.slidesToShow,\n        slidesToScroll: this.slidesToShow,\n        dots: attributes[\"data-show-dots\"] === \"true\",\n        arrows: attributes[\"data-show-arrows\"] === \"true\",\n        autoplay: attributes[\"data-autoplay\"] === \"true\",\n        autoplaySpeed: parseFloat(attributes[\"data-autoplay-speed\"])\n      };\n      var slidesToShow = viewports[currentViewport].options.products[carouselMode] ? viewports[currentViewport].options.products[carouselMode].slidesToShow : viewports[currentViewport].options.products.default.slidesToShow;\n      config.slidesToShow = parseFloat(slidesToShow);\n\n      if (attributes[\"data-carousel-mode\"] === \"continuous\" && productCount > config.slidesToShow) {\n        config.centerPadding = attributes[\"data-center-padding\"];\n        config.centerMode = true;\n        (0, _jquery)(this.element).addClass(this.centerModeClass);\n      } else {\n        config.infinite = attributes[\"data-infinite-loop\"] === \"true\";\n        (0, _jquery)(this.element).removeClass(this.centerModeClass);\n      }\n\n      return config;\n    }\n    /**\n     * Determine if the data has changed, whilst ignoring certain keys which don't require a rebuild\n     *\n     * @param {DataObject} previousData\n     * @param {DataObject} newData\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.hasDataChanged = function hasDataChanged(previousData, newData) {\n      previousData = _underscore.omit(previousData, this.ignoredKeysForBuild);\n      newData = _underscore.omit(newData, this.ignoredKeysForBuild);\n      return !_underscore.isEqual(previousData, newData);\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/products/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/form/provider',\n    'Magento_PageBuilder/js/form/provider/conditions-data-processor'\n], function (Provider, conditionsDataProcessor) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        save: function () {\n            var data = this.get('data');\n\n            conditionsDataProcessor(data, data['condition_option'] + '_source');\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/content-type/products/appearance/carousel/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'matchMedia',\n    'Magento_PageBuilder/js/utils/breakpoints',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, _, mediaCheck, breakpointsUtils, events) {\n    'use strict';\n\n    /**\n     * Build slick\n     *\n     * @param {jQuery} $carouselElement\n     * @param {Object} config\n     */\n    function buildSlick($carouselElement, config) {\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($carouselElement.hasClass('slick-initialized')) {\n            $carouselElement.slick('unslick');\n        }\n\n        config.slidesToScroll = config.slidesToShow;\n        $carouselElement.slick(config);\n    }\n\n    /**\n     * Initialize slider.\n     *\n     * @param {jQuery} $element\n     * @param {Object} slickConfig\n     * @param {Object} breakpoint\n     */\n    function initSlider($element, slickConfig, breakpoint) {\n        var productCount = $element.find('.product-item').length,\n            $carouselElement = $($element.children()),\n            centerModeClass = 'center-mode',\n            carouselMode = $element.data('carousel-mode'),\n            slidesToShow = breakpoint.options.products[carouselMode] ?\n                breakpoint.options.products[carouselMode].slidesToShow :\n                breakpoint.options.products.default.slidesToShow;\n\n        slickConfig.slidesToShow = parseFloat(slidesToShow);\n\n        if (carouselMode === 'continuous' && productCount > slickConfig.slidesToShow) {\n            $element.addClass(centerModeClass);\n            slickConfig.centerPadding = $element.data('center-padding');\n            slickConfig.centerMode = true;\n        } else {\n            $element.removeClass(centerModeClass);\n            slickConfig.infinite = $element.data('infinite-loop');\n        }\n\n        buildSlick($carouselElement, slickConfig);\n    }\n\n    return function (config, element) {\n        var $element = $(element),\n            $carouselElement = $($element.children()),\n            currentViewport = config.currentViewport,\n            currentBreakpoint = config.breakpoints[currentViewport],\n            slickConfig = {\n                autoplay: $element.data('autoplay'),\n                autoplaySpeed: $element.data('autoplay-speed') || 0,\n                arrows: $element.data('show-arrows'),\n                dots: $element.data('show-dots')\n            };\n\n        _.each(config.breakpoints, function (breakpoint) {\n            mediaCheck({\n                media: breakpointsUtils.buildMedia(breakpoint.conditions),\n\n                /** @inheritdoc */\n                entry: function () {\n                    initSlider($element, slickConfig, breakpoint);\n                }\n            });\n        });\n\n        //initialize slider when content type is added in mobile viewport\n        if (currentViewport === 'mobile') {\n            initSlider($element, slickConfig, currentBreakpoint);\n        }\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($carouselElement.closest(args.element).length) {\n                $carouselElement.slick('setPosition');\n            }\n        });\n\n        events.on('stage:viewportChangeAfter', function (args) {\n            var breakpoint = config.breakpoints[args.viewport];\n\n            initSlider($element, slickConfig, breakpoint);\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/products/mass-converter/widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.products_count = attributes.products_count;\n      data.sort_order = attributes.sort_order;\n      data.condition_option = attributes.condition_option || \"condition\";\n      data[data.condition_option] = this.decodeWysiwygCharacters(this.decodeHtmlCharacters(attributes.condition_option_value || \"\"));\n      data.conditions_encoded = this.decodeWysiwygCharacters(attributes.conditions_encoded || \"\");\n      data[data.condition_option + \"_source\"] = data.conditions_encoded;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\CatalogWidget\\\\Block\\\\Product\\\\ProductsList\",\n        template: \"Magento_CatalogWidget::product/widget/content/grid.phtml\",\n        anchor_text: \"\",\n        id_path: \"\",\n        show_pager: 0,\n        products_count: data.products_count,\n        condition_option: data.condition_option,\n        condition_option_value: \"\",\n        type_name: \"Catalog Products List\",\n        conditions_encoded: this.encodeWysiwygCharacters(data.conditions_encoded || \"\")\n      };\n\n      if (data.sort_order) {\n        attributes.sort_order = data.sort_order;\n      }\n\n      if (typeof data[data.condition_option] === \"string\") {\n        attributes.condition_option_value = this.encodeWysiwygCharacters(data[data.condition_option]);\n      }\n\n      if (attributes.conditions_encoded.length === 0) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.encodeWysiwygCharacters = function encodeWysiwygCharacters(content) {\n      return content.replace(/\\{/g, \"^[\").replace(/\\}/g, \"^]\").replace(/\"/g, \"`\").replace(/\\\\/g, \"|\").replace(/</g, \"&lt;\").replace(/>/g, \"&gt;\");\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeWysiwygCharacters = function decodeWysiwygCharacters(content) {\n      return content.replace(/\\^\\[/g, \"{\").replace(/\\^\\]/g, \"}\").replace(/`/g, \"\\\"\").replace(/\\|/g, \"\\\\\").replace(/&lt;/g, \"<\").replace(/&gt;/g, \">\");\n    }\n    /**\n     * Decode html special characters\n     *\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeHtmlCharacters = function decodeHtmlCharacters(content) {\n      if (content) {\n        var htmlDocument = new DOMParser().parseFromString(content, \"text/html\");\n        return htmlDocument.body ? htmlDocument.body.textContent : content;\n      }\n\n      return content;\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=widget-directive.js.map","Magento_PageBuilder/js/content-type/products/mass-converter/carousel-widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.carousel_products_count = attributes.products_count;\n      data.sort_order = attributes.sort_order;\n      data.condition_option = attributes.condition_option || \"condition\";\n      data[data.condition_option] = this.decodeWysiwygCharacters(this.decodeHtmlCharacters(attributes.condition_option_value || \"\"));\n      data.conditions_encoded = this.decodeWysiwygCharacters(attributes.conditions_encoded || \"\");\n      data[data.condition_option + \"_source\"] = data.conditions_encoded;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\CatalogWidget\\\\Block\\\\Product\\\\ProductsList\",\n        template: \"Magento_PageBuilder::catalog/product/widget/content/carousel.phtml\",\n        anchor_text: \"\",\n        id_path: \"\",\n        show_pager: 0,\n        products_count: data.carousel_products_count,\n        condition_option: data.condition_option,\n        condition_option_value: \"\",\n        type_name: \"Catalog Products Carousel\",\n        conditions_encoded: this.encodeWysiwygCharacters(data.conditions_encoded || \"\")\n      };\n\n      if (data.sort_order) {\n        attributes.sort_order = data.sort_order;\n      }\n\n      if (typeof data[data.condition_option] === \"string\") {\n        attributes.condition_option_value = this.encodeWysiwygCharacters(data[data.condition_option]);\n      }\n\n      if (attributes.conditions_encoded.length === 0) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.encodeWysiwygCharacters = function encodeWysiwygCharacters(content) {\n      return content.replace(/\\{/g, \"^[\").replace(/\\}/g, \"^]\").replace(/\"/g, \"`\").replace(/\\\\/g, \"|\").replace(/</g, \"&lt;\").replace(/>/g, \"&gt;\");\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeWysiwygCharacters = function decodeWysiwygCharacters(content) {\n      return content.replace(/\\^\\[/g, \"{\").replace(/\\^\\]/g, \"}\").replace(/`/g, \"\\\"\").replace(/\\|/g, \"\\\\\").replace(/&lt;/g, \"<\").replace(/&gt;/g, \">\");\n    }\n    /**\n     * Decode html special characters\n     *\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeHtmlCharacters = function decodeHtmlCharacters(content) {\n      if (content) {\n        var htmlDocument = new DOMParser().parseFromString(content, \"text/html\");\n        return htmlDocument.body ? htmlDocument.body.textContent : content;\n      }\n\n      return content;\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=carousel-widget-directive.js.map","Magento_PageBuilder/js/content-type/slide/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/nesting-link-dialog\", \"Magento_PageBuilder/js/utils/nesting-widget-dialog\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jarallax, _jarallaxVideo, _jquery, _knockout, _translate, _events, _mageUtils, _underscore, _vimeoWrapper, _conditionalRemoveOption, _uploader, _delayUntil, _editor, _nestingLinkDialog, _nestingWidgetDialog, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      _this.slideName = _knockout.observable();\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.slideChanged = true;\n      _this.handledDoubleClick = false;\n      _this.videoUpdateProperties = [\"background_type\", \"video_fallback_image\", \"video_lazy_load\", \"video_loop\", \"video_play_only_visible\", \"video_source\"];\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.wrapper, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.wrapper && _this.wrapper.dataset.backgroundType === \"video\" && _this.wrapper.dataset.videoSrc.length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            var viewportElement = (0, _jquery)(\"<div/>\").addClass(\"jarallax-viewport-element\");\n            (0, _jquery)(_this.wrapper).append((0, _jquery)(\".jarallax-viewport-element\", _this.wrapper).length ? \"\" : viewportElement);\n            jarallax(_this.wrapper, {\n              videoSrc: _this.wrapper.dataset.videoSrc,\n              imgSrc: _this.wrapper.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: 1,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              elementInViewport: (0, _jquery)(\".jarallax-viewport-element\", _this.wrapper),\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.wrapper.jarallax && _this.wrapper.jarallax.video) {\n              // @ts-ignore\n              _this.wrapper.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.wrapper.jarallax && _this.wrapper.jarallax.$video) {\n                  // @ts-ignore\n                  _this.wrapper.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.content.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.content.html();\n        }\n      }, \"content\");\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Set state based on overlay mouseover event for the preview\n     */\n    ;\n\n    _proto.onMouseOverWrapper = function onMouseOverWrapper() {\n      // Triggers the visibility of the overlay content to show\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.attributes(Object.assign(this.data.overlay.attributes(), {\n          \"data-background-color-orig\": this.data.overlay.style().backgroundColor\n        }));\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-overlay-color\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 1,\n          visibility: \"visible\"\n        }));\n      }\n    }\n    /**\n     * Set state based on overlay mouseout event for the preview\n     */\n    ;\n\n    _proto.onMouseOutWrapper = function onMouseOutWrapper() {\n      // Triggers the visibility of the overlay content to hide\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-background-color-orig\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 0,\n          visibility: \"hidden\"\n        }));\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      delete options.move;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\"); // Create uploader\n\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this3 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this3.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this3.handledDoubleClick = true;\n\n              _this3.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this3.element);\n            }, function () {\n              return _this3.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      } else if (this.element && this.wysiwyg) {\n        var element = this.element || this.textarea;\n\n        if (event.currentTarget !== event.target && event.target !== element && !element.contains(event.target)) {\n          return;\n        }\n\n        element.focus();\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this4 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this4.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this5 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"content\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this5.textarea.value = _this5.contentType.dataStore.get(\"content\");\n\n        _this5.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"content\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(true);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this6 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function (editor) {\n          editor.on(\"blur\", function () {\n            (0, _nestingLinkDialog)(_this6.contentType.dataStore, _this6.wysiwyg, \"content\", \"link_url\");\n            (0, _nestingWidgetDialog)(_this6.contentType.dataStore, _this6.wysiwyg, \"content\", \"link_url\");\n          });\n\n          _underscore.defer(function () {\n            _this6.element.blur();\n\n            _this6.element.focus();\n          });\n        };\n      }\n\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"content\", this.contentType.stageId).then(function (wysiwyg) {\n        _this6.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this7 = this;\n\n      this.wrapper = element;\n\n      _underscore.defer(function () {\n        _this7.buildJarallax();\n      });\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _preview2.prototype.destroy.call(this);\n\n      if (this.wrapper) {\n        jarallax(this.wrapper, \"destroy\");\n      }\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      this.contentType.dataStore.subscribe(function (state) {\n        var sanitizedContent = (0, _editor.removeReservedHtmlAttributes)(state.content);\n\n        if (sanitizedContent !== state.content) {\n          state.content = sanitizedContent;\n        }\n      }, \"content\");\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"slide:mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.buildJarallax();\n\n          _this8.isSnapshot.subscribe(function (value) {\n            _this8.changeUploaderControlsVisibility();\n          });\n\n          _this8.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var dataStore = _this8.contentType.dataStore.getState();\n\n        var imageObject = dataStore[_this8.config.additional_data.uploaderConfig.dataScope][0] || {};\n\n        _events.trigger(\"image:\" + _this8.contentType.id + \":assignAfter\", imageObject);\n      }); // Remove wysiwyg before assign new instance.\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this8.contentType.parentContentType.id) {\n          _this8.wysiwyg = null;\n        }\n      });\n\n      _events.on(this.config.name + \":mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          // Update the display label for the slide\n          var slider = _this8.contentType.parentContentType;\n\n          _this8.displayLabel((0, _translate)(\"Slide \" + (slider.children().indexOf(_this8.contentType) + 1)));\n\n          slider.children.subscribe(function (children) {\n            var index = children.indexOf(_this8.contentType);\n\n            _this8.displayLabel((0, _translate)(\"Slide \" + (slider.children().indexOf(_this8.contentType) + 1)));\n          });\n        }\n      });\n\n      _events.on(this.config.name + \":renderAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          var slider = _this8.contentType.parentContentType;\n          (0, _jquery)(slider.preview.element).on(\"beforeChange\", function () {\n            _this8.slideChanged = false;\n          });\n          (0, _jquery)(slider.preview.element).on(\"afterChange\", function (event, slick) {\n            (0, _jquery)(slick.$slides).each(function (index, slide) {\n              var videoSlide = slide.querySelector(\".jarallax\");\n\n              if (videoSlide) {\n                jarallax(videoSlide, \"onScroll\");\n              }\n            });\n            _this8.slideChanged = true;\n          });\n        }\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _this8.slideName(data.slide_name);\n\n        if (_this8.shouldUpdateVideo(data)) {\n          _this8.buildJarallax();\n        }\n      });\n\n      _events.on(\"image:\" + this.contentType.id + \":uploadAfter\", function () {\n        _this8.contentType.dataStore.set(\"background_type\", \"image\");\n      });\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        if (_this8.contentType.dataStore.get(\"background_type\") === \"video\") {\n          _this8.buildJarallax();\n        }\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this9 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this9.isSnapshot();\n      });\n    }\n    /**\n     * Update image data inside data store\n     *\n     * @param {Array} data - list of each files' data\n     */\n    ;\n\n    _proto.onImageUploaded = function onImageUploaded(data) {\n      this.contentType.dataStore.set(this.config.additional_data.uploaderConfig.dataScope, data);\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    }\n    /**\n     * Check if video options has been updated.\n     *\n     * @return boolean\n     */\n    ;\n\n    _proto.shouldUpdateVideo = function shouldUpdateVideo(state) {\n      var _this10 = this;\n\n      var previousState = this.contentType.dataStore.getPreviousState();\n\n      var diff = _mageUtils.compare(previousState, state).changes;\n\n      if (diff.length > 0) {\n        return _underscore.some(diff, function (element) {\n          if (element.name === \"video_fallback_image\") {\n            return (!_underscore.isEmpty(previousState.video_fallback_image) && previousState.video_fallback_image) !== (!_underscore.isEmpty(state.video_fallback_image) && state.video_fallback_image);\n          }\n\n          return _this10.videoUpdateProperties.indexOf(element.name) !== -1;\n        });\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slide/converter/attribute/overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.overlay_color) {\n        return data.overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=overlay-color.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/overlay-background-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayBackgroundColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBackgroundColor() {}\n\n    var _proto = OverlayBackgroundColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (data.show_overlay === \"always\" && value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return OverlayBackgroundColor;\n  }();\n\n  return OverlayBackgroundColor;\n});\n//# sourceMappingURL=overlay-background-color.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var result = {};\n\n      if (undefined !== value.padding) {\n        result.padding = {\n          bottom: value.padding.bottom.replace(\"px\", \"\"),\n          left: value.padding.left.replace(\"px\", \"\"),\n          right: value.padding.right.replace(\"px\", \"\"),\n          top: value.padding.top.replace(\"px\", \"\")\n        };\n      }\n\n      if (result.padding.right[0] === \"c\") {\n        result.padding.right = parseInt(result.padding.right.split(\"+\")[1].trim(), 10);\n      }\n\n      if (result.padding.left[0] === \"c\") {\n        result.padding.left = parseInt(result.padding.left.split(\"+\")[1].trim(), 10);\n      }\n\n      return result;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/button-opacity.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonOpacity = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonOpacity() {}\n\n    var _proto = ButtonOpacity.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"1\" : \"0\";\n    };\n\n    return ButtonOpacity;\n  }();\n\n  return ButtonOpacity;\n});\n//# sourceMappingURL=button-opacity.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/button-visibility.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonVisibility = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonVisibility() {}\n\n    var _proto = ButtonVisibility.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"visible\" : \"hidden\";\n    };\n\n    return ButtonVisibility;\n  }();\n\n  return ButtonVisibility;\n});\n//# sourceMappingURL=button-visibility.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/slide/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function ($, _, showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]'),\n            viewportElement = document.createElement('div'),\n            $slider = null;\n\n        showOnHover(config);\n\n        if (videoElement) {\n            $slider = $(element).closest('[data-content-type=slider]');\n            viewportElement.classList.add('jarallax-viewport-element');\n            videoElement.setAttribute('data-element-in-viewport', '.jarallax-viewport-element');\n            videoElement.appendChild(viewportElement);\n            videoBackground(config, videoElement);\n\n            if ($slider.data('afterChangeIsSet')) {\n                return;\n            }\n\n            $slider.on('afterChange init', function () {\n                var videoSlides = $slider[0].querySelectorAll('.jarallax');\n\n                _.each(videoSlides, function (videoSlide) {\n                    videoSlide.jarallax && videoSlide.jarallax.onScroll();\n                });\n            });\n            $slider.data('afterChangeIsSet', true);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/slide/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\", \"Magento_PageBuilder/js/utils/delay-until\"], function (_jquery, _events, _delayUntil) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {\n      this.sliderSelector = \".slick-list\";\n      this.sliderContentSelector = \".slick-track\";\n      this.slideSelector = \".slick-slide\";\n      this.activeSlideSelector = \".slick-current\";\n      this.slideChanging = false;\n    }\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      var _this = this;\n\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this)); // Update our KO pointer to the active slide on change\n\n      (0, _jquery)(this.$element.parents(this.sliderSelector)).parent().on(\"beforeChange\", function () {\n        _this.slideChanging = true;\n      }).on(\"afterChange\", function () {\n        _this.slideChanging = false;\n      });\n    }\n    /**\n     * Event handler for wysiwyg focus\n     * Fixes z-index issues for tabs and column\n     * Fixes slider\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this2 = this;\n\n      var $slider = (0, _jquery)(this.$element.parents(this.sliderSelector));\n      var sliderContent = this.$element.parents(this.sliderContentSelector)[0];\n      var $notActiveSlides = $slider.find(this.slideSelector).not(this.activeSlideSelector); // If there isn't enough room for a left-aligned toolbar, right align it\n\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      (0, _delayUntil)(function () {\n        _jquery.each(_this2.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n          _this2.$element.closest(selector).css(\"z-index\", 100);\n        }); // Disable slider keyboard events and fix problem with overflow hidden issue\n\n\n        $slider.parent().slick(\"slickSetOption\", \"accessibility\", false);\n        _this2.autoplay = $slider.parent().slick(\"slickGetOption\", \"autoplay\");\n        _this2.fade = $slider.parent().slick(\"slickGetOption\", \"fade\");\n\n        if (_this2.autoplay) {\n          $slider.parent().slick(\"slickPause\");\n        }\n\n        if (!_this2.fade) {\n          $notActiveSlides.css(\"display\", \"none\");\n        }\n\n        _this2.sliderTransform = sliderContent.style.transform;\n        sliderContent.style.transform = \"\";\n        $slider.css(\"overflow\", \"visible\");\n      }, function () {\n        return !_this2.slideChanging;\n      }, 10);\n    }\n    /**\n     * Event handler for wysiwyg blur\n     * Fixes z-index issues for tabs and column\n     * Fixes slider\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this3 = this;\n\n      var $slider = (0, _jquery)(this.$element.parents(this.sliderSelector));\n      var sliderContent = this.$element.parents(this.sliderContentSelector)[0];\n      var $notActiveSlides = $slider.find(this.slideSelector).not(this.activeSlideSelector);\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this3.$element.closest(selector).css(\"z-index\", \"\");\n      }); // Enable slider keyboard events and revert changes made in onFocus\n\n\n      $slider.css(\"overflow\", \"hidden\");\n      sliderContent.style.transform = this.sliderTransform;\n      $notActiveSlides.css(\"display\", \"block\");\n      $slider.parent().slick(\"slickSetOption\", \"accessibility\", true);\n\n      if (this.autoplay) {\n        $slider.parent().slick(\"slickPlay\");\n      }\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/slide/wysiwyg/tinymce/config-modifier.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConfigModifier = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConfigModifier() {}\n\n    var _proto = ConfigModifier.prototype;\n\n    /**\n     * Initialize the config\n     *\n     * @param {String} contentTypeId\n     * @param {Object} config\n     */\n    _proto.modify = function modify(contentTypeId, config) {\n      if (config.adapter_config.mode === \"inline\") {\n        config.adapter.settings.fixed_toolbar_container = \"#\" + contentTypeId + \" .wysiwyg-container\";\n      }\n    };\n\n    return ConfigModifier;\n  }();\n\n  return ConfigModifier;\n});\n//# sourceMappingURL=config-modifier.js.map","Magento_PageBuilder/js/content-type/buttons/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _underscore, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Keeps track of number of button item to disable sortable if there is only 1.\n\n      _this.focusedButton = _knockout.observable();\n      _this.debouncedResizeHandler = _underscore.debounce(function () {\n        _this.resizeChildButtons();\n      }, 350);\n\n      _this.contentType.children.subscribe(function () {\n        var sortableElement = (0, _jquery)(_this.wrapperElement).find(\".buttons-container\");\n\n        if (!sortableElement.data(\"ui-sortable\")) {\n          return;\n        }\n\n        if (_this.contentType.children().length <= 1) {\n          sortableElement.sortable(\"disable\");\n        } else {\n          sortableElement.sortable(\"enable\");\n        }\n      }); // Monitor focus tab to start / stop interaction on the stage, debounce to avoid duplicate calls\n\n\n      _this.focusedButton.subscribe(_underscore.debounce(function (index) {\n        if (index !== null) {\n          _events.trigger(\"stage:interactionStart\");\n\n          var focusedButton = _this.contentType.children()[index];\n\n          (0, _delayUntil)(function () {\n            return (0, _jquery)(focusedButton.preview.wrapperElement).find(\"[contenteditable]\").focus();\n          }, function () {\n            return typeof focusedButton.preview.wrapperElement !== \"undefined\";\n          }, 10);\n        } else {\n          // We have to force the stop as the event firing is inconsistent for certain operations\n          _events.trigger(\"stage:interactionStop\", {\n            force: true\n          });\n        }\n      }, 1));\n\n      return _this;\n    }\n    /**\n     * Bind events\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"buttons:dropAfter\", function (args) {\n        if (args.id === _this2.contentType.id && _this2.contentType.children().length === 0) {\n          _this2.addButton();\n        }\n      });\n\n      _events.on(\"buttons:renderAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.debouncedResizeHandler();\n        }\n      });\n\n      _events.on(\"button-item:renderAfter\", function (args) {\n        if (args.contentType.parentContentType.id === _this2.contentType.id) {\n          _this2.debouncedResizeHandler();\n        }\n      });\n\n      _events.on(\"stage:updateAfter\", function () {\n        _this2.debouncedResizeHandler();\n      });\n\n      _events.on(\"contentType:redrawAfter\", function () {\n        _this2.debouncedResizeHandler();\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedButton;\n      var duplicatedButtonIndex;\n\n      _events.on(\"button-item:duplicateAfter\", function (args) {\n        if (_this2.contentType.id === args.duplicateContentType.parentContentType.id && args.direct) {\n          duplicatedButton = args.duplicateContentType;\n          duplicatedButtonIndex = args.index;\n        }\n      });\n\n      _events.on(\"button-item:mountAfter\", function (args) {\n        if (duplicatedButton && args.id === duplicatedButton.id) {\n          _this2.focusedButton(duplicatedButtonIndex);\n        }\n      });\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add Button\"),\n        action: this.addButton,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Add button-item to buttons children array\n     */\n    ;\n\n    _proto.addButton = function addButton() {\n      var _this3 = this;\n\n      var createButtonItemPromise = (0, _contentTypeFactory)(_config.getContentTypeConfig(\"button-item\"), this.contentType, this.contentType.stageId, {});\n      createButtonItemPromise.then(function (button) {\n        _this3.contentType.addChild(button);\n\n        var buttonIndex = _this3.contentType.children().indexOf(button);\n\n        _this3.focusedButton(buttonIndex > -1 ? buttonIndex : null);\n\n        return button;\n      }).catch(function (error) {\n        console.error(error);\n      });\n    }\n    /**\n     * Get the sortable options for the buttons sorting\n     *\n     * @param {string} orientation\n     * @param {string} tolerance\n     * @returns {JQueryUI.Sortable}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions(orientation, tolerance) {\n      if (orientation === void 0) {\n        orientation = \"width\";\n      }\n\n      if (tolerance === void 0) {\n        tolerance = \"intersect\";\n      }\n\n      return {\n        handle: \".button-item-drag-handle\",\n        items: \".pagebuilder-content-type-wrapper\",\n        cursor: \"grabbing\",\n        containment: \"parent\",\n        tolerance: tolerance,\n        revert: 200,\n        disabled: this.contentType.children().length <= 1,\n\n        /**\n         * Provide custom helper element\n         *\n         * @param {Event} event\n         * @param {JQueryUI.Sortable} element\n         * @returns {Element}\n         */\n        helper: function helper(event, element) {\n          var helper = (0, _jquery)(element).clone().css({\n            opacity: \"0.7\",\n            width: \"auto\"\n          });\n          helper[0].querySelector(\".pagebuilder-options\").remove();\n          return helper[0];\n        },\n        placeholder: {\n          /**\n           * Provide custom placeholder element\n           *\n           * @param {JQuery} item\n           * @returns {JQuery}\n           */\n          element: function element(item) {\n            var placeholder = item.clone().css({\n              display: \"inline-block\",\n              opacity: \"0.3\"\n            }).removeClass(\"focused\").addClass(\"sortable-placeholder\");\n            placeholder[0].querySelector(\".pagebuilder-options\").remove();\n            return placeholder[0];\n          },\n          update: function update() {\n            return;\n          }\n        },\n\n        /**\n         * Trigger interaction start on sort\n         */\n        start: function start() {\n          _events.trigger(\"stage:interactionStart\");\n        },\n\n        /**\n         * Stop stage interaction on stop\n         */\n        stop: function stop() {\n          _events.trigger(\"stage:interactionStop\");\n        }\n      };\n    }\n    /**\n     * Resize width of all child buttons. Dependently make them the same width if configured.\n     */\n    ;\n\n    _proto.resizeChildButtons = function resizeChildButtons() {\n      if (this.wrapperElement) {\n        var buttonItems = (0, _jquery)(this.wrapperElement).find(\".pagebuilder-button-item > a\");\n        var buttonResizeValue = 0;\n\n        if (this.contentType.dataStore.get(\"is_same_width\") === \"true\") {\n          if (buttonItems.length > 0) {\n            var currentLargestButtonWidth = this.findLargestButtonWidth(buttonItems);\n            var parentWrapperWidth = (0, _jquery)(this.wrapperElement).find(\".buttons-container\").width();\n\n            if (currentLargestButtonWidth === 0) {\n              return;\n            }\n\n            buttonResizeValue = Math.min(currentLargestButtonWidth, parentWrapperWidth);\n          }\n        }\n\n        buttonItems.css(\"min-width\", buttonResizeValue);\n      }\n    }\n    /**\n     * Find the largest button width for calculating same size value.\n     *\n     * @param {JQuery} buttonItems\n     * @returns {number}\n     */\n    ;\n\n    _proto.findLargestButtonWidth = function findLargestButtonWidth(buttonItems) {\n      var _this4 = this;\n\n      return _underscore.max(_underscore.map(buttonItems, function (buttonItem) {\n        return _this4.calculateButtonWidth((0, _jquery)(buttonItem));\n      }));\n    }\n    /**\n     * Manually calculate button width using content plus box widths (padding, border)\n     *\n     * @param {JQuery} buttonItem\n     * @returns {number}\n     */\n    ;\n\n    _proto.calculateButtonWidth = function calculateButtonWidth(buttonItem) {\n      if (buttonItem.is(\":visible\") === false) {\n        return 0;\n      }\n\n      var widthProperties = [\"paddingLeft\", \"paddingRight\", \"borderLeftWidth\", \"borderRightWidth\"];\n      var buttonText = buttonItem.find(\"[data-element='link_text']\");\n      var textWidth = buttonText.css(\"display\", \"inline-block\").width();\n      buttonText.css(\"display\", \"\");\n      return widthProperties.reduce(function (accumulatedWidth, widthProperty) {\n        return accumulatedWidth + (parseInt(buttonItem.css(widthProperty), 10) || 0);\n      }, textWidth);\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/preview/display/flex.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return;\n    }\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return \"flex\";\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=flex.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/display/boolean.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Boolean = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Boolean() {}\n\n    var _proto = Boolean.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be reset to default\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"\";\n    };\n\n    return Boolean;\n  }();\n\n  return Boolean;\n});\n//# sourceMappingURL=boolean.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/display/flex.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Flex = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Flex() {}\n\n    var _proto = Flex.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be inline block\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"flex\";\n    };\n\n    return Flex;\n  }();\n\n  return Flex;\n});\n//# sourceMappingURL=flex.js.map","Magento_PageBuilder/js/content-type/buttons/appearance/inline/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events'\n], function ($, events) {\n    'use strict';\n\n    /**\n     * Equalize the width of a list of button-item components\n     *\n     * @param {JQuery} buttonList\n     */\n    var equalizeButtonWidth = function (buttonList) {\n        var buttonMinWidth = 0;\n\n        buttonList.css('min-width', buttonMinWidth);\n        buttonList.each(function () {\n            var buttonWidth = this.offsetWidth;\n\n            if (buttonWidth > buttonMinWidth) {\n                buttonMinWidth = buttonWidth;\n            }\n        });\n        buttonList.css('min-width', buttonMinWidth);\n    };\n\n    return function (config, element) {\n        var $element = $(element),\n            buttonSelector = '[data-element=\"link\"], [data-element=\"empty_link\"]';\n\n        if ($element.data('sameWidth')) {\n            equalizeButtonWidth($element.find(buttonSelector));\n            $(window).on('resize', function () {\n                equalizeButtonWidth($element.find(buttonSelector));\n            });\n            events.on('contentType:redrawAfter', function (eventData) {\n                if ($element.closest(eventData.element).length > 0) {\n                    equalizeButtonWidth($element.find(buttonSelector));\n                }\n            });\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/root-container/content-type-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_Ui/js/modal/alert\", \"Magento_PageBuilder/js/content-type-collection\"], function (_alert, _contentTypeCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var RootContainer = /*#__PURE__*/function (_contentTypeCollectio) {\n    \"use strict\";\n\n    _inheritsLoose(RootContainer, _contentTypeCollectio);\n\n    function RootContainer() {\n      return _contentTypeCollectio.apply(this, arguments) || this;\n    }\n\n    var _proto = RootContainer.prototype;\n\n    /**\n     * Remove a child from the observable array\n     *\n     * @param child\n     */\n    _proto.removeChild = function removeChild(child) {\n      if (this.getChildren().length === 1) {\n        (0, _alert)({\n          content: $t(\"You are not able to remove the final row from the content.\"),\n          title: $t(\"Unable to Remove\")\n        });\n        return;\n      }\n\n      _contentTypeCollectio.prototype.removeChild.call(this, child);\n    };\n\n    return RootContainer;\n  }(_contentTypeCollection);\n\n  return RootContainer;\n});\n//# sourceMappingURL=content-type-collection.js.map","Magento_PageBuilder/js/content-type/tab-item/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _conditionalRemoveOption, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _previewCollection2.call.apply(_previewCollection2, [this].concat(args)) || this;\n      _this.fieldsToIgnoreOnRemove = [\"tab_name\"];\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Force the focus on the clicked tab header\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onClick = function onClick(index, event) {\n      (0, _jquery)(event.currentTarget).find(\"[contenteditable]\").focus();\n      event.stopPropagation();\n    }\n    /**\n     * On focus in set the focused button\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(index, event) {\n      var parentPreview = this.contentType.parentContentType.preview;\n\n      if (parentPreview.focusedTab() !== index) {\n        parentPreview.setFocusedTab(index, true);\n      }\n    }\n    /**\n     * On focus out set the focused tab to null\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(index, event) {\n      if (this.contentType && this.contentType.parentContentType) {\n        var parentPreview = this.contentType.parentContentType.preview;\n\n        var unfocus = function unfocus() {\n          window.getSelection().removeAllRanges();\n          parentPreview.focusedTab(null);\n        };\n\n        if (event.relatedTarget && _jquery.contains(parentPreview.wrapperElement, event.relatedTarget)) {\n          // Verify the focus was not onto the options menu\n          if ((0, _jquery)(event.relatedTarget).closest(\".pagebuilder-options\").length > 0) {\n            unfocus();\n          } else {\n            // Have we moved the focus onto another button in the current group?\n            var tabItem = _knockout.dataFor(event.relatedTarget);\n\n            if (tabItem && tabItem.contentType && tabItem.contentType.parentContentType && tabItem.contentType.parentContentType.id === this.contentType.parentContentType.id) {\n              var newIndex = tabItem.contentType.parentContentType.children().indexOf(tabItem.contentType);\n              parentPreview.setFocusedTab(newIndex, true);\n            } else {\n              unfocus();\n            }\n          }\n        } else if (parentPreview.focusedTab() === index) {\n          unfocus();\n        }\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      delete options.move;\n      delete options.title;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/heading/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-toolbar\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _events, _underscore, _hideShowOption, _contentTypeToolbar, _promiseDeferred, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.afterRenderDeferred = (0, _promiseDeferred)();\n      _this.toolbar = new _contentTypeToolbar(_assertThisInitialized(_this), _this.getToolbarOptions());\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * On render init the heading\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.afterRender = function afterRender(element) {\n      this.element = element;\n      this.afterRenderDeferred.resolve(element);\n    };\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _preview2.prototype.bindEvents.call(this); // When a heading is dropped for the first time show heading toolbar\n\n\n      _events.on(\"heading:dropAfter\", function (args) {\n        if (args.id === _this2.contentType.id) {\n          Promise.all([_this2.afterRenderDeferred.promise, _this2.toolbar.afterRenderDeferred.promise]).then(function (_ref) {\n            var element = _ref[0];\n\n            _underscore.defer(function () {\n              (0, _jquery)(element).focus();\n            });\n          });\n        }\n      });\n    }\n    /**\n     * Get option value from observable data.\n     *\n     * @param {string} key\n     * @return {*}\n     */\n    ;\n\n    _proto.getOptionValue = function getOptionValue(key) {\n      if (key === \"heading_type\") {\n        return this.data.main.heading_type();\n      } else if (key === \"text_align\") {\n        return this.data.main.style().textAlign;\n      }\n\n      return;\n    }\n    /**\n     * Build and return the tool bar options for heading\n     *\n     * @returns {OptionInterface[]}\n     */\n    ;\n\n    _proto.getToolbarOptions = function getToolbarOptions() {\n      return [{\n        key: \"heading_type\",\n        type: \"select\",\n        values: [{\n          value: \"h1\",\n          label: \"H1\",\n          icon: \"\"\n        }, {\n          value: \"h2\",\n          label: \"H2\",\n          icon: \"\"\n        }, {\n          value: \"h3\",\n          label: \"H3\",\n          icon: \"\"\n        }, {\n          value: \"h4\",\n          label: \"H4\",\n          icon: \"\"\n        }, {\n          value: \"h5\",\n          label: \"H5\",\n          icon: \"\"\n        }, {\n          value: \"h6\",\n          label: \"H6\",\n          icon: \"\"\n        }]\n      }, {\n        key: \"text_align\",\n        type: \"select\",\n        values: [{\n          value: \"left\",\n          label: \"Left\",\n          icon: \"icon-pagebuilder-align-left\"\n        }, {\n          value: \"center\",\n          label: \"Center\",\n          icon: \"icon-pagebuilder-align-center\"\n        }, {\n          value: \"right\",\n          label: \"Right\",\n          icon: \"icon-pagebuilder-align-right\"\n        }]\n      }];\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slider/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"slick\", \"underscore\", \"Magento_PageBuilder/js/binding/focus\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _slick, _underscore, _focus, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _promiseDeferred, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Define keys which when changed should not trigger the slider to be rebuilt\n     *\n     * @type {string[]}\n     */\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Wait for the tabs instance to mount and the container to be ready\n\n      _this.focusedSlide = _knockout.observable();\n      _this.activeSlide = _knockout.observable(0);\n      _this.events = {\n        columnWidthChangeAfter: \"onColumnResize\"\n      };\n      _this.ready = false;\n      _this.mountAfterDeferred = (0, _promiseDeferred)();\n      _this.afterChildrenRenderDeferred = (0, _promiseDeferred)();\n      _this.buildSlickDebounce = _underscore.debounce(_this.buildSlick.bind(_assertThisInitialized(_this)), 10);\n      _this.ignoredKeysForBuild = [\"display\", \"margins_and_padding\", \"border\", \"border_color\", \"border_radius\", \"border_width\", \"css_classes\", \"name\", \"text_align\"];\n      Promise.all([_this.afterChildrenRenderDeferred.promise, _this.mountAfterDeferred.promise]).then(function (_ref) {\n        var element = _ref[0],\n            expectedChildren = _ref[1];\n        // We always create 1 tab when dropping tabs into the instance\n        expectedChildren = expectedChildren || 1; // Wait until all children's DOM elements are present before building the tabs instance\n\n        (0, _delayUntil)(function () {\n          _this.element = element;\n          _this.childSubscribe = _this.contentType.children.subscribe(_this.buildSlickDebounce);\n          _this.previousData = _this.contentType.dataStore.getState();\n\n          _this.contentType.dataStore.subscribe(function (data) {\n            if (_this.hasDataChanged(_this.previousData, data)) {\n              _this.buildSlickDebounce();\n            }\n\n            _this.previousData = data;\n          });\n\n          _this.buildSlick(); // Redraw slide after content type gets redrawn\n\n\n          _events.on(\"contentType:redrawAfter\", function (args) {\n            var $element = (0, _jquery)(_this.element);\n\n            if (args.element && _this.element && $element.closest(args.element).length) {\n              $element.slick(\"setPosition\");\n            }\n          }); // Set the stage to interacting when a slide is focused\n\n\n          _this.focusedSlideSubscriber = _this.focusedSlide.subscribe(function (value) {\n            if (value !== null) {\n              _events.trigger(\"stage:interactionStart\");\n            } else {\n              _events.trigger(\"stage:interactionStop\");\n            }\n          });\n\n          _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.onColumnResize.bind(_assertThisInitialized(_this), [true]));\n\n          _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function () {\n            if (_this.element) {\n              (0, _jquery)(_this.element).slick(\"setPosition\");\n\n              _this.checkWidth();\n            }\n          });\n        }, function () {\n          return (0, _jquery)(element).find(\".pagebuilder-slide\").length === expectedChildren;\n        });\n      });\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add\"),\n        action: this.addSlide,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Set an active slide for navigation dot\n     *\n     * @param slideIndex\n     */\n    ;\n\n    _proto.setActiveSlide = function setActiveSlide(slideIndex) {\n      this.activeSlide(slideIndex);\n    }\n    /**\n     * Set the focused slide\n     *\n     * @param {number} slideIndex\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.setFocusedSlide = function setFocusedSlide(slideIndex, force) {\n      if (force === void 0) {\n        force = false;\n      }\n\n      if (force) {\n        this.focusedSlide(null);\n      }\n\n      this.focusedSlide(slideIndex);\n    }\n    /**\n     * Unset focused slide on focusout event.\n     *\n     * @param {PreviewCollection} data\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(data, event) {\n      var relatedTarget = event.relatedTarget;\n\n      if (!relatedTarget && document.activeElement && !(document.activeElement instanceof HTMLBodyElement)) {\n        relatedTarget = document.activeElement;\n      }\n\n      if (!relatedTarget) {\n        this.setFocusedSlide(null);\n        return;\n      }\n\n      var $relatedTarget = (0, _jquery)(relatedTarget);\n      var isRelatedTargetDescendantOfNavigation = $relatedTarget.closest(this.navigationElement).length;\n      var isFocusedOnAnotherSlideInThisSlider = $relatedTarget.hasClass(\"navigation-dot-anchor\") && isRelatedTargetDescendantOfNavigation;\n\n      if (isFocusedOnAnotherSlideInThisSlider) {\n        _events.trigger(\"stage:interactionStop\");\n      } else if (!isRelatedTargetDescendantOfNavigation) {\n        this.setFocusedSlide(null);\n      }\n    }\n    /**\n     * Set reference to navigation element in template\n     *\n     * @param {HTMLElement} navigationElement\n     */\n    ;\n\n    _proto.afterNavigationRender = function afterNavigationRender(navigationElement) {\n      this.navigationElement = navigationElement;\n    }\n    /**\n     * Navigate to a slide\n     *\n     * @param {number} slideIndex\n     * @param {boolean} dontAnimate\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.navigateToSlide = function navigateToSlide(slideIndex, dontAnimate, force) {\n      if (dontAnimate === void 0) {\n        dontAnimate = false;\n      }\n\n      if (force === void 0) {\n        force = false;\n      }\n\n      if ((0, _jquery)(this.element).hasClass(\"slick-initialized\")) {\n        (0, _jquery)(this.element).slick(\"slickGoTo\", slideIndex, dontAnimate);\n        this.setActiveSlide(slideIndex);\n        this.setFocusedSlide(slideIndex, force);\n      }\n    }\n    /**\n     * After child render record element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterChildrenRender = function afterChildrenRender(element) {\n      this.element = element; // if slider has been re-rendered previously on this element, re-build\n\n      if (this.ready) {\n        this.buildSlick();\n      }\n\n      _previewCollection2.prototype.afterChildrenRender.call(this, element);\n\n      this.afterChildrenRenderDeferred.resolve(element);\n    }\n    /**\n     * On sort start force the container height, also focus to that slide\n     *\n     * @param {Event} event\n     * @param {JQueryUI.SortableUIParams} params\n     */\n    ;\n\n    _proto.onSortStart = function onSortStart(event, params) {\n      this.forceContainerHeight();\n\n      if (this.activeSlide() !== params.item.index() || this.focusedSlide() !== params.item.index()) {\n        this.navigateToSlide(params.item.index(), false, true); // As we've completed a navigation request we need to ensure we don't remove the forced height\n\n        this.contentTypeHeightReset = true;\n      }\n    }\n    /**\n     * On sort stop ensure the focused slide and the active slide are in sync, as the focus can be lost in this\n     * operation\n     */\n    ;\n\n    _proto.onSortStop = function onSortStop(event, params) {\n      var _this2 = this;\n\n      if (this.activeSlide() !== this.focusedSlide()) {\n        this.setFocusedSlide(this.activeSlide(), true);\n      }\n\n      if (params.item.index() !== -1) {\n        _underscore.defer(this.focusElement.bind(this, event, params.item.index()));\n      }\n\n      _underscore.defer(function () {\n        (0, _jquery)(_this2.element).css({\n          height: \"\",\n          overflow: \"\"\n        });\n      });\n    }\n    /**\n     * Add a slide into the slider\n     */\n    ;\n\n    _proto.addSlide = function addSlide() {\n      var _this3 = this;\n\n      (0, _contentTypeFactory)(_config.getConfig(\"content_types\").slide, this.contentType, this.contentType.stageId).then(function (slide) {\n        _events.on(\"slide:mountAfter\", function (args) {\n          if (args.id === slide.id) {\n            _underscore.defer(function () {\n              // Wait until slick is initialized before trying to navigate\n              (0, _delayUntil)(function () {\n                return _this3.navigateToSlide(_this3.contentType.children().length - 1);\n              }, function () {\n                return (0, _jquery)(_this3.element).hasClass(\"slick-initialized\");\n              }, 10);\n            });\n\n            _events.off(\"slide:\" + slide.id + \":mountAfter\");\n          }\n        }, \"slide:\" + slide.id + \":mountAfter\");\n\n        _this3.contentType.addChild(slide, _this3.contentType.children().length);\n      });\n    }\n    /**\n     * Slider can not receive drops by default\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isContainer = function isContainer() {\n      return false;\n    }\n    /**\n     * Slider navigation click handler.\n     *\n     * @param {number} index\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onControlClick = function onControlClick(index, context, event) {\n      (0, _jquery)(event.target).focus();\n      this.navigateToSlide(index);\n      this.setFocusedSlide(index);\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _previewCollection2.prototype.destroy.call(this);\n\n      if (this.focusedSlideSubscriber) {\n        this.focusedSlideSubscriber.dispose();\n      }\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this4 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"slider:mountAfter\", function (args) {\n        if (args.id === _this4.contentType.id) {\n          if (args.expectChildren !== undefined) {\n            _this4.mountAfterDeferred.resolve(args.expectChildren);\n          }\n        }\n      }); // Set the active slide to the new position of the sorted slide\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this4.contentType.id) {\n          (0, _jquery)(args.ui.item).remove(); // Remove the item as the container's children is controlled by knockout\n\n          _this4.setActiveSlide(args.newPosition);\n\n          _underscore.defer(_this4.focusElement.bind(_this4, args.event, args.newPosition));\n        }\n      }); // When a slide content type is removed\n      // we need to force update the content of the slider due to KO rendering issues\n\n\n      var newItemIndex;\n\n      _events.on(\"slide:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this4.contentType.id) {\n          // Mark the previous slide as active\n          newItemIndex = args.index - 1 >= 0 ? args.index - 1 : 0;\n\n          _this4.forceContainerHeight();\n\n          var data = _this4.contentType.children().slice(0);\n\n          _this4.contentType.children([]);\n\n          _this4.contentType.children(data);\n\n          _underscore.defer(function () {\n            _this4.buildSlick();\n          });\n        }\n      });\n\n      _events.on(\"slide:renderAfter\", function (args) {\n        var itemIndex = args.contentType.parentContentType.getChildren()().indexOf(args.contentType);\n\n        if (args.contentType.parentContentType.id === _this4.contentType.id && newItemIndex !== null && newItemIndex === itemIndex) {\n          _underscore.defer(function () {\n            if (newItemIndex !== null) {\n              newItemIndex = null;\n\n              _this4.navigateToSlide(itemIndex, true, true);\n\n              _underscore.defer(function () {\n                _this4.focusedSlide(null);\n\n                _this4.focusedSlide(itemIndex);\n              });\n            }\n          });\n        }\n      }); // On a slide content types creation we need to lock the height of the slider to ensure a smooth transition\n\n\n      _events.on(\"slide:createAfter\", function (args) {\n        if (_this4.element && _this4.ready && args.contentType.parentContentType.id === _this4.contentType.id) {\n          _this4.forceContainerHeight();\n\n          _underscore.defer(function () {\n            (0, _jquery)(_this4.element).css({\n              height: \"\",\n              overflow: \"\"\n            });\n          });\n        }\n      }); // ContentType being mounted onto container\n\n\n      _events.on(\"slider:dropAfter\", function (args) {\n        if (args.id === _this4.contentType.id && _this4.contentType.children().length === 0) {\n          _this4.addSlide();\n        }\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedSlide;\n      var duplicatedSlideIndex;\n\n      _events.on(\"slide:duplicateAfter\", function (args) {\n        if (args.duplicateContentType.parentContentType.id === _this4.contentType.id && args.direct) {\n          duplicatedSlide = args.duplicateContentType;\n          duplicatedSlideIndex = args.index;\n        }\n      });\n\n      _events.on(\"slide:mountAfter\", function (args) {\n        if (duplicatedSlide && args.id === duplicatedSlide.id) {\n          _underscore.defer(function () {\n            // Mark the new duplicate slide as active\n            _this4.navigateToSlide(duplicatedSlideIndex, true, true);\n\n            duplicatedSlide = duplicatedSlideIndex = null;\n          });\n        }\n      });\n    }\n    /**\n     * Determine if the data has changed, whilst ignoring certain keys which don't require a rebuild\n     *\n     * @param {DataObject} previousData\n     * @param {DataObject} newData\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.hasDataChanged = function hasDataChanged(previousData, newData) {\n      previousData = _underscore.omit(previousData, this.ignoredKeysForBuild);\n      newData = _underscore.omit(newData, this.ignoredKeysForBuild);\n      return !_underscore.isEqual(previousData, newData);\n    }\n    /**\n     * Build our instance of slick\n     */\n    ;\n\n    _proto.buildSlick = function buildSlick() {\n      var _this5 = this;\n\n      if (this.element && this.element.children.length > 0) {\n        try {\n          (0, _jquery)(this.element).slick(\"unslick\");\n        } catch (e) {// We aren't concerned if this fails, slick throws an Exception when we cannot unslick\n        } // Dispose current subscription in order to prevent infinite loop\n\n\n        if (this.childSubscribe) {\n          this.childSubscribe.dispose();\n        } // Force an update on all children, ko tries to intelligently re-render but fails\n\n\n        var data = this.contentType.children().slice(0);\n        this.contentType.children([]);\n        (0, _jquery)(this.element).empty();\n        this.contentType.children(data); // Re-subscribe original event\n\n        this.childSubscribe = this.contentType.children.subscribe(this.buildSlickDebounce); // Bind our init event for slick\n\n        (0, _jquery)(this.element).on(\"init\", function () {\n          _this5.ready = true;\n        }); // Build slick\n\n        (0, _jquery)(this.element).slick(Object.assign({\n          initialSlide: this.activeSlide() || 0\n        }, this.buildSlickConfig())); // Update our KO pointer to the active slide on change\n\n        (0, _jquery)(this.element).on(\"beforeChange\", function (event, slick, currentSlide, nextSlide) {\n          (0, _jquery)(_this5.element).css(\"pointer-events\", \"none\");\n\n          _this5.setActiveSlide(nextSlide);\n        }).on(\"afterChange\", function () {\n          if (!_this5.contentTypeHeightReset) {\n            (0, _jquery)(_this5.element).css({\n              height: \"\",\n              overflow: \"\"\n            });\n            _this5.contentTypeHeightReset = null;\n          }\n\n          (0, _jquery)(_this5.element).css(\"pointer-events\", \"\");\n        });\n      }\n    }\n    /**\n     * Take dropped element on focus.\n     *\n     * @param {JQueryEventObject} event\n     * @param {number} index\n     */\n    ;\n\n    _proto.focusElement = function focusElement(event, index) {\n      var handleClassName = (0, _jquery)(event.target).data(\"ui-sortable\").options.handle;\n      (0, _jquery)((0, _jquery)(event.target).find(handleClassName)[index]).focus();\n    }\n    /**\n     * To ensure smooth animations we need to lock the container height\n     */\n    ;\n\n    _proto.forceContainerHeight = function forceContainerHeight() {\n      (0, _jquery)(this.element).css({\n        height: (0, _jquery)(this.element).outerHeight(),\n        overflow: \"hidden\"\n      });\n    }\n    /**\n     * Build the slick config object\n     *\n     * @returns {{autoplay: boolean; autoplaySpeed: (any | number);\n     * fade: boolean; infinite: boolean; arrows: boolean; dots: boolean}}\n     */\n    ;\n\n    _proto.buildSlickConfig = function buildSlickConfig() {\n      var data = this.contentType.dataStore.getState();\n      return {\n        arrows: data.show_arrows === \"true\",\n        autoplay: data.autoplay === \"true\",\n        autoplaySpeed: data.autoplay_speed,\n        dots: false,\n        // We have our own dots implemented\n        fade: data.fade === \"true\",\n        infinite: data.is_infinite === \"true\",\n        waitForAnimate: false,\n        swipe: false\n      };\n    }\n    /**\n     * Fit slider in column container\n     *\n     * @param params\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(params) {\n      var _this6 = this;\n\n      setTimeout(function () {\n        if (_this6.element) {\n          (0, _jquery)(_this6.element).slick(\"setPosition\");\n\n          _this6.checkWidth();\n        }\n      }, 450);\n    }\n    /**\n     * Check width and add class that marks element as small\n     */\n    ;\n\n    _proto.checkWidth = function checkWidth() {\n      if (this.element.offsetWidth < 410) {\n        this.element.classList.add(\"slider-small-width\");\n      } else {\n        this.element.classList.remove(\"slider-small-width\");\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slider/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, events) {\n    'use strict';\n\n    return function (config, sliderElement) {\n        var $element = $(sliderElement);\n\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($element.hasClass('slick-initialized')) {\n            $element.slick('unslick');\n        }\n\n        $element.slick({\n            autoplay: $element.data('autoplay'),\n            autoplaySpeed: $element.data('autoplay-speed') || 0,\n            fade: $element.data('fade'),\n            infinite: $element.data('infinite-loop'),\n            arrows: $element.data('show-arrows'),\n            dots: $element.data('show-dots')\n        });\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($element.closest(args.element).length) {\n                $element.slick('setPosition');\n            }\n        });\n        // eslint-disable-next-line jquery-no-bind-unbind\n        events.on('stage:viewportChangeAfter', $element.slick.bind($element, 'setPosition'));\n    };\n});\n","Magento_PageBuilder/js/content-type/html/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"Magento_Ui/js/modal/alert\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column-line/preview\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column/resize\"], function (_jquery, _knockout, _translate, _events, _alert, _config, _contentTypeFactory, _option, _gridSize, _preview, _previewCollection, _resize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Fields that should not be considered when evaluating whether an object has been configured.\n     *\n     * @see {Preview.isConfigured}\n     * @type {[string]}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Update the width label for the column\n\n      _this.resizing = _knockout.observable(false);\n      _this.fieldsToIgnoreOnRemove = [\"width\"];\n\n      _this.contentType.dataStore.subscribe(_this.updateColumnWidthClass.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.dataStore.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.dataStore.subscribe(_this.triggerChildren.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.parentContentType.dataStore.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)), \"grid_size\"); // Update the column number for the column\n\n\n      _this.contentType.parentContentType.children.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)));\n\n      return _this;\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"column:moveAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.updateDisplayLabel();\n        }\n\n        _this2.resetRemoveOnLastColumn(args.targetParent);\n\n        _this2.resetRemoveOnLastColumn(args.sourceParent);\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(args.columnLine);\n      });\n\n      _events.on(\"column:dropAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(_this2.contentType.parentContentType);\n      });\n\n      _events.on(\"column:duplicateAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(args.duplicateContentType.parentContentType);\n      });\n\n      _events.on(\"column:removeAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.resetRemoveOnLastColumn(args.parentContentType);\n        }\n      });\n    }\n    /**\n     * Make a reference to the element in the column\n     *\n     * @param element\n     */\n    ;\n\n    _proto.initColumn = function initColumn(element) {\n      this.element = (0, _jquery)(element);\n      this.updateColumnWidthClass();\n\n      _events.trigger(\"column:initializeAfter\", {\n        column: this.contentType,\n        element: (0, _jquery)(element),\n        columnLine: this.contentType.parentContentType,\n        columnGroup: this.contentType.parentContentType.parentContentType\n      });\n\n      this.updateDisplayLabel();\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.move = new _option({\n        preview: this,\n        icon: \"<i class='icon-admin-pagebuilder-handle'></i>\",\n        title: (0, _translate)(\"Move\"),\n        classes: [\"move-column\"],\n        sort: 10\n      });\n      return options;\n    }\n    /**\n     * Init the resize handle for the resizing functionality\n     *\n     * @param handle\n     */\n    ;\n\n    _proto.bindResizeHandle = function bindResizeHandle(handle) {\n      _events.trigger(\"column:resizeHandleBindAfter\", {\n        column: this.contentType,\n        handle: (0, _jquery)(handle),\n        columnLine: this.contentType.parentContentType\n      });\n    }\n    /**\n     * Wrap the current column in a group if it not in a column-group\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumnGroup = function createColumnGroup() {\n      var _this3 = this;\n\n      if (this.contentType.parentContentType.config.name !== \"column-group\") {\n        var index = this.contentType.parentContentType.children().indexOf(this.contentType); // Remove child instantly to stop content jumping around\n\n        this.contentType.parentContentType.removeChild(this.contentType); // Create a new instance of column group to wrap our columns with\n\n        var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n        return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-group\"), this.contentType.parentContentType, this.contentType.stageId, {\n          grid_size: defaultGridSize\n        }).then(function (columnGroup) {\n          var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n          return Promise.all([(0, _contentTypeFactory)(_this3.contentType.config, columnGroup, columnGroup.stageId, {\n            width: col1Width + \"%\"\n          }), (0, _contentTypeFactory)(_this3.contentType.config, columnGroup, columnGroup.stageId, {\n            width: 100 - parseFloat(col1Width) + \"%\"\n          })]).then(function (columns) {\n            columnGroup.addChild(columns[0], 0);\n            columnGroup.addChild(columns[1], 1);\n\n            _this3.contentType.parentContentType.addChild(columnGroup, index);\n\n            _this3.fireMountEvent(columnGroup, columns[0], columns[1]);\n\n            return columnGroup;\n          });\n        });\n      }\n    }\n    /**\n     * Duplicate a child of the current instance\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} contentType\n     * @param {boolean} autoAppend\n     * @returns {Promise<ContentTypeCollectionInterface> | void}\n     */\n    ;\n\n    _proto.clone = function clone(contentType, autoAppend) {\n      if (autoAppend === void 0) {\n        autoAppend = true;\n      }\n\n      var resizeUtils = this.contentType.parentContentType.preview.getResizeUtils(); // Are we duplicating from a container content type?\n\n      if (contentType.config.name !== \"column\" || this.contentType.parentContentType.children().length === 0 || this.contentType.parentContentType.children().length > 0 && resizeUtils.getColumnsWidth() < 100) {\n        return _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n      }\n\n      var biggestShrinkableColumn = resizeUtils.findBiggerShrinkableColumn(contentType);\n\n      if (biggestShrinkableColumn) {\n        var shrinkableClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n        if (shrinkableClone) {\n          var newShrinkableColumnWidth = resizeUtils.getColumnWidth(biggestShrinkableColumn) - resizeUtils.getColumnWidth(contentType);\n          var duplicateColumnWidth = resizeUtils.getColumnWidth(contentType);\n          shrinkableClone.then(function (duplicateContentType) {\n            (0, _resize.updateColumnWidth)(biggestShrinkableColumn, resizeUtils.getAcceptedColumnWidth(newShrinkableColumnWidth.toString()));\n            (0, _resize.updateColumnWidth)(duplicateContentType, duplicateColumnWidth);\n            return duplicateContentType;\n          });\n        }\n\n        return;\n      } // Attempt to split the current column into parts\n\n\n      var splitTimes = Math.round(resizeUtils.getColumnWidth(contentType) / resizeUtils.getSmallestColumnWidth());\n\n      if (splitTimes > 1) {\n        var splitClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n        if (splitClone) {\n          splitClone.then(function (duplicateContentType) {\n            /**\n             * Distribute the width across the original & duplicated columns, if the we have an odd number of\n             * split times apply it to the original.\n             */\n            var originalWidth = (Math.floor(splitTimes / 2) + splitTimes % 2) * resizeUtils.getSmallestColumnWidth();\n            var duplicateWidth = Math.floor(splitTimes / 2) * resizeUtils.getSmallestColumnWidth();\n            (0, _resize.updateColumnWidth)(contentType, resizeUtils.getAcceptedColumnWidth(originalWidth.toString()));\n            (0, _resize.updateColumnWidth)(duplicateContentType, resizeUtils.getAcceptedColumnWidth(duplicateWidth.toString()));\n            return duplicateContentType;\n          });\n        }\n      } else {\n        // Conduct an outward search on the children to locate a suitable shrinkable column\n        var shrinkableColumn = resizeUtils.findShrinkableColumn(contentType);\n\n        if (shrinkableColumn) {\n          var _shrinkableClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n          if (_shrinkableClone) {\n            _shrinkableClone.then(function (duplicateContentType) {\n              (0, _resize.updateColumnWidth)(shrinkableColumn, resizeUtils.getAcceptedColumnWidth((resizeUtils.getColumnWidth(shrinkableColumn) - resizeUtils.getSmallestColumnWidth()).toString()));\n              (0, _resize.updateColumnWidth)(duplicateContentType, resizeUtils.getSmallestColumnWidth());\n              return duplicateContentType;\n            });\n          }\n        } else {\n          // If we aren't able to duplicate inform the user why\n          (0, _alert)({\n            content: (0, _translate)(\"There is no free space within the column group to perform this action.\"),\n            title: (0, _translate)(\"Unable to duplicate column\")\n          });\n        }\n      }\n    }\n    /**\n     * Update the display label for the column\n     */\n    ;\n\n    _proto.updateDisplayLabel = function updateDisplayLabel() {\n      if (this.contentType.parentContentType.preview instanceof _preview) {\n        var newWidth = parseFloat(this.contentType.dataStore.get(\"width\").toString());\n        var grandParent = this.contentType.parentContentType.parentContentType;\n        var columnGroupPreview = grandParent.preview;\n        var gridSize = columnGroupPreview.gridSize();\n        var newLabel = Math.round(newWidth / (100 / gridSize)) + \"/\" + gridSize;\n        var columnIndex = this.contentType.parentContentType.children().indexOf(this.contentType);\n        var columnNumber = columnIndex !== -1 ? columnIndex + 1 + \" \" : \"\";\n        this.displayLabel((0, _translate)(\"Column\") + \" \" + columnNumber + \"(\" + newLabel + \")\");\n      }\n    }\n    /**\n     * Reset remove option on all columns within a column-group depending on the number of remaining child columns\n     * @param parentContentType\n     */\n    ;\n\n    _proto.resetRemoveOnLastColumn = function resetRemoveOnLastColumn(parentContentType) {\n      if (!parentContentType) {\n        // can happen if the column is moved within the same column group\n        return;\n      }\n\n      if (parentContentType.config.name !== \"column-line\") {\n        // for legacy content in preview mode before stage is initialized, the parent may not be a column line\n        return;\n      }\n\n      var siblings = parentContentType.children();\n      var siblingColumnLines = parentContentType.parentContentType.children();\n      var totalColumnCount = 0;\n      siblingColumnLines.forEach(function (columnLine) {\n        var columns = columnLine.children();\n        columns.forEach(function (column) {\n          totalColumnCount++;\n        });\n      });\n      var isRemoveDisabled = totalColumnCount <= 1;\n      siblingColumnLines.forEach(function (columnLine) {\n        var columns = columnLine.children();\n        columns.forEach(function (column) {\n          var removeOption = column.preview.getOptions().getOption(\"remove\");\n          removeOption.isDisabled(isRemoveDisabled);\n        });\n      });\n    }\n    /**\n     * Syncs the column-width-* class on the children-wrapper with the current width to the nearest tenth rounded up\n     */\n    ;\n\n    _proto.updateColumnWidthClass = function updateColumnWidthClass() {\n      // Only update once instantiated\n      if (!this.element) {\n        return;\n      }\n\n      var currentClass = this.element.attr(\"class\").match(/(?:^|\\s)(column-width-\\d{1,3})(?:$|\\s)/);\n\n      if (currentClass !== null) {\n        this.element.removeClass(currentClass[1]);\n      }\n\n      var roundedWidth = Math.ceil(parseFloat(this.contentType.dataStore.get(\"width\").toString()) / 10) * 10;\n      this.element.addClass(\"column-width-\" + roundedWidth);\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len = arguments.length, contentTypes = new Array(_len), _key = 0; _key < _len; _key++) {\n        contentTypes[_key] = arguments[_key];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Delegate trigger call on children elements.\n     */\n    ;\n\n    _proto.triggerChildren = function triggerChildren() {\n      if (this.contentType.parentContentType.preview instanceof _preview) {\n        var newWidth = parseFloat(this.contentType.dataStore.get(\"width\").toString());\n        this.delegate(\"trigger\", \"columnWidthChangeAfter\", {\n          width: newWidth\n        });\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column/resize.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/array\"], function (_array) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Resize = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Resize(columnGroup, columnLine) {\n      this.columnGroup = columnGroup;\n      this.columnLine = columnLine;\n    }\n    /**\n     * Get the grid size for this columnGroup\n     *\n     * @returns {number}\n     */\n\n\n    var _proto = Resize.prototype;\n\n    _proto.getGridSize = function getGridSize() {\n      return parseInt(this.columnGroup.dataStore.get(\"grid_size\").toString(), 10);\n    }\n    /**\n     * Get the initial grid size for this columnGroup before it was updated\n     *\n     * @returns {number}\n     */\n    ;\n\n    _proto.getInitialGridSize = function getInitialGridSize() {\n      return parseInt(this.columnGroup.dataStore.get(\"initial_grid_size\", 0).toString(), 10);\n    }\n    /**\n     * Get the smallest column width possible\n     *\n     * @param {number} gridSize\n     * @returns {number}\n     */\n    ;\n\n    _proto.getSmallestColumnWidth = function getSmallestColumnWidth(gridSize) {\n      gridSize = gridSize || this.getInitialGridSize() || this.getGridSize();\n      return this.getAcceptedColumnWidth(parseFloat((100 / gridSize).toString()).toFixed(Math.round(100 / gridSize) !== 100 / gridSize ? 8 : 0));\n    }\n    /**\n     * Get an accepted column width to resolve rounding issues, e.g. turn 49.995% into 50%\n     *\n     * @param {string} width\n     * @param {number} gridSize\n     * @returns {number}\n     */\n    ;\n\n    _proto.getAcceptedColumnWidth = function getAcceptedColumnWidth(width, gridSize) {\n      gridSize = gridSize || this.getInitialGridSize() || this.getGridSize();\n      var newWidth = 0;\n\n      for (var i = gridSize; i > 0; i--) {\n        var percentage = parseFloat((100 / gridSize * i).toFixed(Math.round(100 / gridSize * i) !== 100 / gridSize * i ? 8 : 0)); // Allow for rounding issues\n\n        if (parseFloat(width) > percentage - 0.1 && parseFloat(width) < percentage + 0.1) {\n          newWidth = percentage;\n          break;\n        }\n      }\n\n      return newWidth;\n    }\n    /**\n     * Return the width of the column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {number}\n     */\n    ;\n\n    _proto.getColumnWidth = function getColumnWidth(column) {\n      return this.getAcceptedColumnWidth(column.dataStore.get(\"width\").toString());\n    }\n    /**\n     * Get the total width of all columns in the column line\n     *\n     * @returns {number}\n     */\n    ;\n\n    _proto.getColumnsWidth = function getColumnsWidth() {\n      var _this = this;\n\n      return this.getAcceptedColumnWidth(this.columnLine.children().map(function (column) {\n        return _this.getColumnWidth(column);\n      }).reduce(function (widthA, widthB) {\n        return widthA + (widthB ? widthB : 0);\n      }).toString());\n    }\n    /**\n     * Determine the pixel position of every column that can be created within the group\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {GroupPositionCache} groupPosition\n     * @returns {ColumnWidth[]}\n     */\n    ;\n\n    _proto.determineColumnWidths = function determineColumnWidths(column, groupPosition) {\n      var gridSize = this.getGridSize();\n      var singleColumnWidth = groupPosition.outerWidth / gridSize;\n      var adjacentColumn = getAdjacentColumn(column, \"+1\");\n      var columnWidths = [];\n      var columnLeft = column.preview.element.offset().left - parseInt(column.preview.element.css(\"margin-left\"), 10);\n      var adjacentRightPosition = adjacentColumn.preview.element.offset().left + adjacentColumn.preview.element.outerWidth(true); // Determine the maximum size (in pixels) that this column can be dragged to\n\n      var columnsToRight = column.parentContentType.children().length - (getColumnIndexInGroup(column) + 1);\n      var leftMaxWidthFromChildren = groupPosition.left + groupPosition.outerWidth - columnsToRight * singleColumnWidth + 10;\n      var rightMaxWidthFromChildren = groupPosition.left + (column.parentContentType.children().length - columnsToRight) * singleColumnWidth - 10; // Due to rounding we add a threshold of 10\n      // Iterate through the amount of columns generating the position for both left & right interactions\n\n      for (var i = gridSize; i > 0; i--) {\n        var position = Math.round(columnLeft + singleColumnWidth * i);\n\n        if (position > Math.round(leftMaxWidthFromChildren)) {\n          continue;\n        }\n\n        columnWidths.push({\n          forColumn: \"left\",\n          // These positions are for the left column in the pair\n          name: i + \"/\" + gridSize,\n          position: position,\n          width: getRoundedColumnWidth(100 / gridSize * i)\n        });\n      }\n\n      for (var _i = 1; _i < gridSize; _i++) {\n        var _position = Math.floor(adjacentRightPosition - _i * singleColumnWidth);\n\n        if (_position < Math.floor(rightMaxWidthFromChildren)) {\n          continue;\n        } // The right interaction is only used when we're crushing a column that isn't adjacent\n\n\n        columnWidths.push({\n          forColumn: \"right\",\n          // These positions are for the left column in the pair\n          name: _i + \"/\" + gridSize,\n          position: _position,\n          width: getRoundedColumnWidth(100 / gridSize * _i)\n        });\n      }\n\n      return columnWidths;\n    }\n    /**\n     * Find a column which can be shrunk for the current resize action\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {\"left\" | \"right\"} direction\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findShrinkableColumnForResize = function findShrinkableColumnForResize(column, direction) {\n      var _this2 = this;\n\n      var currentIndex = getColumnIndexInGroup(column);\n      var columnItemsArray = column.parentContentType.children();\n      var searchArray;\n\n      switch (direction) {\n        case \"right\":\n          searchArray = columnItemsArray.slice(currentIndex + 1);\n          break;\n\n        case \"left\":\n          searchArray = columnItemsArray.slice(0).reverse().slice(columnItemsArray.length - currentIndex);\n          break;\n      }\n\n      return searchArray.find(function (groupColumn) {\n        return _this2.getColumnWidth(groupColumn) > _this2.getSmallestColumnWidth();\n      });\n    }\n    /**\n     * Find a shrinkable column outwards from the current column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findShrinkableColumn = function findShrinkableColumn(column) {\n      var _this3 = this;\n\n      return (0, _array.outwardSearch)(column.parentContentType.children(), getColumnIndexInGroup(column), function (neighbourColumn) {\n        return _this3.getColumnWidth(neighbourColumn) > _this3.getSmallestColumnWidth();\n      });\n    }\n    /**\n     * Find a shrinkable column of a greater size outwards from the current column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findBiggerShrinkableColumn = function findBiggerShrinkableColumn(column) {\n      var _this4 = this;\n\n      return (0, _array.outwardSearch)(column.parentContentType.children(), getColumnIndexInGroup(column), function (neighbourColumn) {\n        return _this4.getColumnWidth(neighbourColumn) > _this4.getColumnWidth(column);\n      });\n    }\n    /**\n     * Calculate the ghost size for the resizing action\n     *\n     * @param {GroupPositionCache} groupPosition\n     * @param {number} currentPos\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {string} modifyColumnInPair\n     * @param {MaxGhostWidth} maxGhostWidth\n     * @returns {number}\n     */\n    ;\n\n    _proto.calculateGhostWidth = function calculateGhostWidth(groupPosition, currentPos, column, modifyColumnInPair, maxGhostWidth) {\n      var ghostWidth = currentPos - groupPosition.left;\n\n      switch (modifyColumnInPair) {\n        case \"left\":\n          var singleColumnWidth = column.preview.element.position().left + groupPosition.outerWidth / this.getGridSize(); // Don't allow the ghost widths be less than the smallest column\n\n          if (ghostWidth <= singleColumnWidth) {\n            ghostWidth = singleColumnWidth;\n          }\n\n          if (currentPos >= maxGhostWidth.left) {\n            ghostWidth = maxGhostWidth.left - groupPosition.left;\n          }\n\n          break;\n\n        case \"right\":\n          if (currentPos <= maxGhostWidth.right) {\n            ghostWidth = maxGhostWidth.right - groupPosition.left;\n          }\n\n          break;\n      }\n\n      return ghostWidth;\n    }\n    /**\n     * Determine which column in the group should be adjusted for the current resize action\n     *\n     * @param {number} currentPos\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {ResizeHistory} history\n     * @returns {[ContentTypeCollectionInterface<ColumnPreview>, string, string]}\n     */\n    ;\n\n    _proto.determineAdjustedColumn = function determineAdjustedColumn(currentPos, column, history) {\n      var modifyColumnInPair = \"left\";\n      var usedHistory;\n      var resizeColumnLeft = column.preview.element.offset().left - parseInt(column.preview.element.css(\"margin-left\"), 10);\n      var resizeColumnWidth = column.preview.element.outerWidth(true);\n      var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n      var adjustedColumn;\n\n      if (currentPos >= resizeHandlePosition) {\n        // Get the history for the opposite direction of resizing\n        if (history.left.length > 0) {\n          usedHistory = \"left\";\n          adjustedColumn = history.left.reverse()[0].adjustedColumn;\n          modifyColumnInPair = history.left.reverse()[0].modifyColumnInPair;\n        } else {\n          // If we're increasing the width of our column we need to locate a column that can shrink to the\n          // right\n          adjustedColumn = this.findShrinkableColumnForResize(column, \"right\");\n        }\n      } else {\n        if (this.getColumnWidth(column) <= this.getSmallestColumnWidth()) {\n          adjustedColumn = this.findShrinkableColumnForResize(column, \"left\");\n\n          if (adjustedColumn) {\n            modifyColumnInPair = \"right\";\n          }\n        } else if (history.right.length > 0) {\n          usedHistory = \"right\";\n          adjustedColumn = history.right.reverse()[0].adjustedColumn;\n          modifyColumnInPair = history.right.reverse()[0].modifyColumnInPair;\n        } else {\n          // If we're shrinking our column we can just increase the adjacent column\n          adjustedColumn = getAdjacentColumn(column, \"+1\");\n        }\n      }\n\n      return [adjustedColumn, modifyColumnInPair, usedHistory];\n    }\n    /**\n     * Resize a column to a specific width\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<Preview>} shrinkableColumn\n     */\n    ;\n\n    _proto.resizeColumn = function resizeColumn(column, width, shrinkableColumn) {\n      var current = this.getColumnWidth(column);\n      var difference = (parseFloat(width.toString()) - current).toFixed(8); // Don't run the update if we've already modified the column\n\n      if (current === parseFloat(width.toString()) || parseFloat(width.toString()) < this.getSmallestColumnWidth()) {\n        return;\n      } // Also shrink the closest shrinkable column\n\n\n      var allowedToShrink = true;\n\n      if (difference && shrinkableColumn) {\n        var currentShrinkable = this.getColumnWidth(shrinkableColumn);\n        var shrinkableSize = this.getAcceptedColumnWidth((currentShrinkable + -difference).toString()); // Ensure the column we're crushing is not becoming the same size, and it's not less than the smallest width\n\n        if (currentShrinkable === parseFloat(shrinkableSize.toString()) || parseFloat(shrinkableSize.toString()) < this.getSmallestColumnWidth()) {\n          allowedToShrink = false;\n        } else {\n          // Ensure we're not creating more columns width than the grid can support\n          if (this.gridSupportsResize(column, width, shrinkableColumn, shrinkableSize)) {\n            updateColumnWidth(shrinkableColumn, shrinkableSize);\n          } else {\n            allowedToShrink = false;\n          }\n        }\n      }\n\n      if (allowedToShrink) {\n        updateColumnWidth(column, width);\n      }\n    }\n    /**\n     * Determine if the grid supports the new proposed grid size\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} column\n     * @param {number} newWidth\n     * @param {ContentTypeCollectionInterface<Preview>} shrinkableColumn\n     * @param {number} shrinkableColumnNewWidth\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.gridSupportsResize = function gridSupportsResize(column, newWidth, shrinkableColumn, shrinkableColumnNewWidth) {\n      var _this5 = this;\n\n      // Determine the total width of all other columns in the grid, excluding the ones we plan to resize\n      var otherColumnsWidth = column.parentContentType.getChildren()().filter(function (gridColumn) {\n        return gridColumn !== column && shrinkableColumn && gridColumn !== shrinkableColumn;\n      }).map(function (otherColumn) {\n        return _this5.getColumnWidth(otherColumn);\n      }).reduce(function (a, b) {\n        return a + b;\n      }, 0); // Determine if the new total grid size will be 100%, with 1 for margin of error with rounding\n\n      return comparator(otherColumnsWidth + newWidth + (shrinkableColumnNewWidth ? shrinkableColumnNewWidth : 0), 100, 0.1);\n    };\n\n    return Resize;\n  }();\n  /**\n   * Retrieve the index of the column within it's group\n   * @deprecated use getColumnIndexInLine\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @returns {number}\n   */\n\n\n  function getColumnIndexInGroup(column) {\n    return column.parentContentType.children().indexOf(column);\n  }\n  /**\n   * Retrieve the index of the column within it's column line\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @returns {number}\n   */\n\n\n  function getColumnIndexInLine(column) {\n    return column.parentContentType.children().indexOf(column);\n  }\n  /**\n   * Retrieve the adjacent column based on a direction of +1 or -1\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} column\n   * @param {\"+1\" | \"-1\"} direction\n   * @returns {ContentTypeCollectionInterface<Preview>}\n   */\n\n\n  function getAdjacentColumn(column, direction) {\n    var currentIndex = getColumnIndexInGroup(column);\n\n    if (typeof column.parentContentType.children()[currentIndex + parseInt(direction, 10)] !== \"undefined\") {\n      return column.parentContentType.children()[currentIndex + parseInt(direction, 10)];\n    }\n\n    return null;\n  }\n  /**\n   * Determine the max ghost width based on the calculated columns\n   *\n   * @param {ColumnWidth[]} columnWidths\n   * @returns {MaxGhostWidth}\n   */\n\n\n  function determineMaxGhostWidth(columnWidths) {\n    var leftColumns = columnWidths.filter(function (width) {\n      return width.forColumn === \"left\";\n    });\n    var rightColumns = columnWidths.filter(function (width) {\n      return width.forColumn === \"right\";\n    });\n    return {\n      left: leftColumns[0].position,\n      right: rightColumns[rightColumns.length - 1].position\n    };\n  }\n  /**\n   * Return the column width to 8 decimal places if it's not a whole number\n   *\n   * @param {number} width\n   * @returns {string}\n   */\n\n\n  function getRoundedColumnWidth(width) {\n    return Number(width.toFixed(Math.round(width) !== width ? 8 : 0));\n  }\n  /**\n   * Compare if two numbers are within a certain threshold of each other\n   *\n   * comparator(10,11,2) => true\n   * comparator(1.1,1.11,0.5) => true\n   *\n   * @param {number} num1\n   * @param {number} num2\n   * @param {number} threshold\n   * @returns {boolean}\n   */\n\n\n  function comparator(num1, num2, threshold) {\n    return num1 > num2 - threshold / 2 && num1 < num2 + threshold / 2;\n  }\n  /**\n   * Update the width of a column\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @param {number} width\n   */\n\n\n  function updateColumnWidth(column, width) {\n    column.dataStore.set(\"width\", parseFloat(width.toString()) + \"%\");\n  }\n\n  return Object.assign(Resize, {\n    getColumnIndexInGroup: getColumnIndexInGroup,\n    getColumnIndexInLine: getColumnIndexInLine,\n    getAdjacentColumn: getAdjacentColumn,\n    determineMaxGhostWidth: determineMaxGhostWidth,\n    getRoundedColumnWidth: getRoundedColumnWidth,\n    comparator: comparator,\n    updateColumnWidth: updateColumnWidth\n  });\n});\n//# sourceMappingURL=resize.js.map","Magento_PageBuilder/js/content-type/column/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = (value.margin.right && parseInt(value.margin.right, 10) !== 0 ? value.margin.right : 1) + \"px\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/column-line/drag-and-drop.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Calculate the drop positions of a column group\n   *\n   * @param {ContentTypeCollectionInterface} group\n   * @returns {any[]}\n   */\n  function calculateDropPositions(line) {\n    var resizeUtils = line.preview.getResizeUtils();\n    var dropPositions = [];\n    line.children().forEach(function (column, index) {\n      var left = column.preview.element.position().left;\n      var width = column.preview.element.outerWidth(true);\n      var canShrink = resizeUtils.getAcceptedColumnWidth(resizeUtils.getColumnWidth(column).toString()) > resizeUtils.getSmallestColumnWidth();\n      dropPositions.push({\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index,\n        left: left,\n        placement: \"left\",\n        right: left + width / 2\n      }, {\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index + 1,\n        left: left + width / 2,\n        placement: \"right\",\n        right: left + width\n      });\n    });\n    return dropPositions;\n  }\n\n  return {\n    calculateDropPositions: calculateDropPositions\n  };\n});\n//# sourceMappingURL=drag-and-drop.js.map","Magento_PageBuilder/js/content-type/column-line/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/column-group/factory\", \"Magento_PageBuilder/js/content-type/column-group/registry\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/utils/create-stylesheet\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column/resize\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column-line/drag-and-drop\"], function (_jquery, _knockout, _contentTypeFactory, _factory, _registry, _moveContentType, _registry2, _sortable, _events, _createStylesheet, _underscore, _config, _gridSize, _resize, _previewCollection, _dragAndDrop) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     *\n     * @param {ContentTypeCollection} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.resizing = _knockout.observable(false);\n      _this.gridSizeArray = _knockout.observableArray([]);\n      _this.dropPositions = [];\n      _this.resizeHistory = {\n        left: [],\n        right: []\n      };\n      _this.interactionLevel = 0;\n      _this.lineDropperHeight = 50;\n      _this.resizeUtils = new _resize(_this.contentType.parentContentType, _this.contentType);\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.spreadWidth(args.index);\n          });\n        }\n      }); // Listen for resizing events from child columns\n\n\n      _events.on(\"column:resizeHandleBindAfter\", function (args) {\n        // Does the events content type match the previews column group?\n        if (args.columnLine.id === _this.contentType.id) {\n          _this.registerResizeHandle(args.column, args.handle);\n        }\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnGroup.id === _this.contentType.id) {\n          _this.bindDraggable(args.column);\n        }\n      });\n\n      var parentPreview = _this.contentType.parentContentType.preview;\n\n      _this.gridSizeArray(parentPreview.gridSizeArray());\n\n      parentPreview.gridSizeArray.subscribe(function (gridSize) {\n        _this.gridSizeArray(gridSize);\n      });\n\n      _this.contentType.children.subscribe(_underscore.debounce(_this.removeIfEmpty.bind(_assertThisInitialized(_this)), 50));\n\n      return _this;\n    }\n    /**\n     * Bind events\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      if (_config.getContentTypeConfig(\"column\")) {\n        _events.on(\"column-line:dropAfter\", function (args) {\n          if (args.id === _this2.contentType.id) {\n            _this2.createColumns();\n          }\n        });\n      }\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnLine.id === _this2.contentType.id) {\n          _this2.bindDraggable(args.column);\n        }\n      });\n    }\n    /**\n     * Init the droppable & resizing interactions\n     *\n     * @param line\n     */\n    ;\n\n    _proto.bindInteractions = function bindInteractions(line) {\n      this.element = (0, _jquery)(line);\n      this.initDroppable(this.element);\n      this.initMouseMove(this.element); // Handle the mouse leaving the window\n      //  $(\"body\").mouseleave(this.endAllInteractions.bind(this));\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindDropPlaceholder = function bindDropPlaceholder(element) {\n      this.dropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindColumnLineBottomDropPlaceholder = function bindColumnLineBottomDropPlaceholder(element) {\n      this.columnLineBottomDropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindColumnLineDropPlaceholder = function bindColumnLineDropPlaceholder(element) {\n      this.columnLineDropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the move placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindMovePlaceholder = function bindMovePlaceholder(element) {\n      this.movePlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Retrieve the ghost element from the template\n     *\n     * @param {Element} ghost\n     */\n    ;\n\n    _proto.bindGhost = function bindGhost(ghost) {\n      this.resizeGhost = (0, _jquery)(ghost);\n    }\n    /**\n     * Retrieve the resize utils\n     *\n     * @returns {Resize}\n     */\n    ;\n\n    _proto.getResizeUtils = function getResizeUtils() {\n      return this.resizeUtils;\n    }\n    /**\n     * Bind draggable instances to the child columns\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     */\n    ;\n\n    _proto.bindDraggable = function bindDraggable(column) {\n      var _this3 = this;\n\n      column.preview.element.draggable({\n        appendTo: \"body\",\n        containment: \"body\",\n        cursor: \"-webkit-grabbing\",\n        handle: \".move-column\",\n        revertDuration: 250,\n        helper: function helper() {\n          var helper = (0, _jquery)(this).clone();\n          helper.css({\n            height: (0, _jquery)(this).outerHeight() + \"px\",\n            minHeight: 0,\n            opacity: 0.5,\n            pointerEvents: \"none\",\n            width: (0, _jquery)(this).outerWidth() + \"px\",\n            zIndex: 5000\n          });\n          return helper;\n        },\n        start: function start(event) {\n          var columnInstance = _knockout.dataFor((0, _jquery)(event.target)[0]); // Use the global state as columns can be dragged between groups\n\n\n          (0, _registry.setDragColumn)(columnInstance.contentType);\n          _this3.dropPositions = (0, _dragAndDrop.calculateDropPositions)(_this3.contentType);\n          _this3.startDragEvent = event;\n\n          _events.trigger(\"column:dragStart\", {\n            column: columnInstance,\n            stageId: _this3.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStart\", {\n            stageId: _this3.contentType.stageId\n          });\n        },\n        stop: function stop() {\n          var draggedColumn = (0, _registry.getDragColumn)();\n\n          if (_this3.movePosition && draggedColumn) {\n            // Check if we're moving within the same group, even though this function will\n            // only ever run on the group that bound the draggable event\n            if (draggedColumn.parentContentType === _this3.contentType) {\n              _this3.onColumnSort(draggedColumn, _this3.movePosition.insertIndex);\n\n              _this3.movePosition = null; // todo see from column group\n            }\n          }\n\n          (0, _registry.removeDragColumn)();\n\n          _this3.dropPlaceholder.removeClass(\"left right\");\n\n          _this3.movePlaceholder.removeClass(\"active\");\n\n          _this3.movePosition = null;\n          _this3.startDragEvent = null;\n\n          _events.trigger(\"column:dragStop\", {\n            column: draggedColumn,\n            stageId: _this3.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: _this3.contentType.stageId\n          });\n        }\n      });\n    }\n    /**\n     * Handle a column being sorted into a new position in the column line\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} newIndex\n     */\n    ;\n\n    _proto.onColumnSort = function onColumnSort(column, newIndex) {\n      var currentIndex = (0, _resize.getColumnIndexInLine)(column);\n\n      if (currentIndex !== newIndex) {\n        if (currentIndex < newIndex) {\n          // As we're moving an array item the keys all reduce by 1\n          --newIndex;\n        } // Move the content type\n\n\n        (0, _moveContentType.moveContentType)(column, newIndex);\n      }\n    }\n    /**\n     * Handle a new column being dropped into the group\n     *\n     * @param {DropPosition} dropPosition\n     */\n    ;\n\n    _proto.onNewColumnDrop = function onNewColumnDrop(dropPosition) {\n      var _this4 = this;\n\n      // Create our new column\n      (0, _factory.createColumn)(this.contentType, this.resizeUtils.getSmallestColumnWidth(), dropPosition.insertIndex).then(function () {\n        var newWidth = _this4.resizeUtils.getAcceptedColumnWidth((_this4.resizeUtils.getColumnWidth(dropPosition.affectedColumn) - _this4.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n\n        (0, _resize.updateColumnWidth)(dropPosition.affectedColumn, newWidth);\n      });\n    }\n    /**\n     * Handle an existing column being dropped into a different column line\n     *\n     * @param {DropPosition} movePosition\n     */\n    ;\n\n    _proto.onExistingColumnDrop = function onExistingColumnDrop(movePosition) {\n      var _this5 = this;\n\n      var column = (0, _registry.getDragColumn)();\n      var sourceLinePreview = column.parentContentType.preview;\n      var modifyOldNeighbour; // Determine which old neighbour we should modify\n\n      var oldWidth = sourceLinePreview.getResizeUtils().getColumnWidth(column);\n      var direction = \"+1\"; // Retrieve the adjacent column either +1 or -1\n\n      if ((0, _resize.getAdjacentColumn)(column, \"+1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"+1\");\n      } else if ((0, _resize.getAdjacentColumn)(column, \"-1\")) {\n        direction = \"-1\";\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"-1\");\n      } // Modify the old neighbour\n\n\n      var oldNeighbourWidth = 100;\n\n      if (modifyOldNeighbour) {\n        oldNeighbourWidth = sourceLinePreview.getResizeUtils().getAcceptedColumnWidth((oldWidth + sourceLinePreview.getResizeUtils().getColumnWidth(modifyOldNeighbour)).toString());\n      } // Move the content type\n\n\n      if (this.columnLineDropPlaceholder.hasClass(\"active\")) {\n        // if new column line placeholders are visible, add new column line and move column there\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          (0, _moveContentType.moveContentType)(column, 0, columnLine);\n          (0, _resize.updateColumnWidth)(column, 100);\n\n          if (modifyOldNeighbour) {\n            (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n          }\n\n          _this5.fireMountEvent(_this5.contentType, column);\n        });\n      } else if (this.columnLineBottomDropPlaceholder.hasClass(\"active\")) {\n        // if new column line placeholders are visible, add new column line and move column there\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          (0, _moveContentType.moveContentType)(column, 0, columnLine);\n          (0, _resize.updateColumnWidth)(column, 100);\n\n          if (modifyOldNeighbour) {\n            (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n          }\n\n          _this5.fireMountEvent(_this5.contentType, column);\n        });\n      } else {\n        (0, _moveContentType.moveContentType)(column, movePosition.insertIndex, this.contentType);\n\n        if (modifyOldNeighbour) {\n          (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n        }\n\n        var newNeighbourWidth = this.resizeUtils.getAcceptedColumnWidth((this.resizeUtils.getColumnWidth(movePosition.affectedColumn) - oldWidth).toString());\n        var newNeighbour = movePosition.affectedColumn;\n        var totalWidthAdjusted = 0;\n        (0, _resize.updateColumnWidth)(column, oldWidth);\n\n        while (true) {\n          // take width from all neighbours in one direction till the entire width is obtained\n          if (newNeighbourWidth <= 0) {\n            newNeighbourWidth = this.resizeUtils.getSmallestColumnWidth();\n            var originalWidthOfNeighbour = this.resizeUtils.getColumnWidth(newNeighbour);\n            (0, _resize.updateColumnWidth)(newNeighbour, newNeighbourWidth);\n            totalWidthAdjusted += originalWidthOfNeighbour - newNeighbourWidth;\n          } else {\n            (0, _resize.updateColumnWidth)(newNeighbour, newNeighbourWidth);\n            break;\n          }\n\n          if (direction === \"+1\") {\n            newNeighbour = (0, _resize.getAdjacentColumn)(newNeighbour, \"+1\");\n          } else {\n            newNeighbour = (0, _resize.getAdjacentColumn)(newNeighbour, \"-1\");\n          }\n\n          if (!newNeighbour) {\n            (0, _resize.updateColumnWidth)(column, totalWidthAdjusted);\n            break;\n          }\n\n          var neighbourExistingWidth = this.resizeUtils.getColumnWidth(newNeighbour);\n          newNeighbourWidth = neighbourExistingWidth - (oldWidth - totalWidthAdjusted);\n\n          if (newNeighbourWidth < 0.001) {\n            newNeighbourWidth = 0;\n          }\n        }\n\n        var totalWidth = 0;\n        this.contentType.children().forEach(function (columnChild) {\n          totalWidth += _this5.resizeUtils.getColumnWidth(columnChild);\n        });\n\n        if (totalWidth > 100) {\n          // take extra width from newly moved column\n          (0, _resize.updateColumnWidth)(column, this.resizeUtils.getColumnWidth(column) - (totalWidth - 100));\n        }\n      }\n    }\n    /**\n     * Init the resizing events on the group\n     *\n     * @param {JQuery} line\n     */\n    ;\n\n    _proto.initMouseMove = function initMouseMove(line) {\n      var _this6 = this;\n\n      var intersects = false;\n      (0, _jquery)(document).on(\"mousemove touchmove\", function (event) {\n        if (line.parents(_sortable.hiddenClass).length > 0) {\n          return;\n        }\n\n        var linePosition = _this6.getLinePosition(line); // If we're handling a touch event we need to pass through the page X & Y\n\n\n        if (event.type === \"touchmove\") {\n          event.pageX = event.originalEvent.pageX;\n          event.pageY = event.originalEvent.pageY;\n        }\n\n        if (_this6.eventIntersectsLine(event, linePosition)) {\n          intersects = true; // @todo re-instate onResizingMouseMove\n\n          _this6.onResizingMouseMove(event, line, linePosition);\n\n          _this6.onDraggingMouseMove(event, line, linePosition);\n\n          _this6.onDroppingMouseMove(event, line, linePosition);\n        } else {\n          intersects = false;\n          _this6.linePositionCache = null;\n          _this6.dropPosition = null;\n\n          _this6.dropPlaceholder.removeClass(\"left right\");\n\n          _this6.columnLineDropPlaceholder.removeClass(\"active\");\n\n          _this6.columnLineBottomDropPlaceholder.removeClass(\"active\");\n\n          _this6.columnLineBottomDropPlaceholder.hide();\n\n          _this6.columnLineDropPlaceholder.hide(); // @todo combine active and show/hide functionality for columnLineDropPlaceholder\n          //  this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n\n        }\n      }).on(\"mouseup touchend\", function () {\n        if (intersects) {\n          _this6.handleMouseUp();\n        }\n\n        intersects = false;\n        _this6.dropPosition = null;\n\n        _this6.endAllInteractions();\n\n        _underscore.defer(function () {\n          // Re-enable any disabled sortable areas\n          line.find(\".ui-sortable\").each(function () {\n            if ((0, _jquery)(this).data(\"ui-sortable\")) {\n              (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n            }\n          });\n        });\n      });\n    }\n    /**\n     * End all current interactions\n     */\n    ;\n\n    _proto.endAllInteractions = function endAllInteractions() {\n      if (this.resizing() === true) {\n        for (; this.interactionLevel > 0; this.interactionLevel--) {\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: this.contentType.stageId\n          });\n        }\n      }\n\n      this.linePositionCache = null;\n      this.dropPosition = null;\n      this.dropPlaceholder.removeClass(\"left right\");\n      this.columnLineDropPlaceholder.removeClass(\"active\");\n      this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n      this.columnLineBottomDropPlaceholder.hide();\n      this.columnLineDropPlaceholder.hide();\n      this.resizing(false);\n      this.resizeMouseDown = null;\n      this.resizeLeftLastColumnShrunk = this.resizeRightLastColumnShrunk = null;\n      this.dropPositions = [];\n      this.unsetResizingColumns(); // Change the cursor back\n\n      (0, _jquery)(\"body\").css(\"cursor\", \"\");\n      this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n      this.resizeGhost.removeClass(\"active\"); // Reset the line positions cache\n\n      this.linePositionCache = null;\n    }\n    /**\n     * Handle the mouse up action, either adding a new column or moving an existing\n     */\n    ;\n\n    _proto.handleMouseUp = function handleMouseUp() {\n      var self = this;\n      var dragColumn = (0, _registry.getDragColumn)();\n\n      if ((this.columnLineDropPlaceholder.hasClass(\"active\") || this.columnLineBottomDropPlaceholder.hasClass(\"active\")) && !dragColumn) {\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          _events.trigger(columnLine.config.name + \":dropAfter\", {\n            id: columnLine.id,\n            columnLine: columnLine\n          });\n        });\n        return;\n      }\n\n      if (this.dropOverElement && this.dropPosition) {\n        this.onNewColumnDrop(this.dropPosition);\n        this.dropOverElement = null; // Re-enable the parent disabled sortable instance\n\n        _underscore.defer(function () {\n          (0, _jquery)(\".element-children.ui-sortable-disabled\").each(function () {\n            (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n          });\n        });\n      }\n\n      var column = (0, _registry.getDragColumn)();\n\n      if (this.isColumnBeingMovedToAnotherColumnLine()) {\n        this.onExistingColumnDrop(this.movePosition);\n      }\n    }\n    /**\n     * Does the current event intersect with the line?\n     *\n     * @param {JQueryEventObject} event\n     * @param {LinePositionCache} groupPosition\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.eventIntersectsLine = function eventIntersectsLine(event, groupPosition) {\n      return event.pageY > groupPosition.top && event.pageY < groupPosition.top + groupPosition.outerHeight && event.pageX > groupPosition.left && event.pageX < groupPosition.left + groupPosition.outerWidth;\n    }\n    /**\n     * Handle a column being dragged around the group\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} line\n     * @param {LinePositionCache} linePosition\n     */\n    ;\n\n    _proto.onDraggingMouseMove = function onDraggingMouseMove(event, line, linePosition) {\n      var dragColumn = (0, _registry.getDragColumn)();\n\n      if (dragColumn) {\n        // If the drop positions haven't been calculated for this line do so now\n        if (this.dropPositions.length === 0) {\n          this.dropPositions = (0, _dragAndDrop.calculateDropPositions)(this.contentType);\n        }\n\n        var columnInstance = dragColumn;\n        var currentX = event.pageX - linePosition.left; // Are we within the same column line or have we ended up over another?\n\n        if (columnInstance.parentContentType === this.contentType && this.startDragEvent) {\n          var dragDirection = event.pageX <= this.startDragEvent.pageX ? \"left\" : \"right\";\n          var adjacentLeftColumn = (0, _resize.getAdjacentColumn)(dragColumn, \"-1\"); // Determine the current move position based on the cursors position and direction of drag\n\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX < position.right && position.placement === dragDirection && position.affectedColumn !== dragColumn;\n          }); // Differences in the element & event positions cause a right movement to activate on the left column\n\n          if (this.movePosition && dragDirection === \"right\" && this.movePosition.affectedColumn === adjacentLeftColumn) {\n            this.movePosition = null;\n          }\n\n          if (this.movePosition && !this.isNewLinePlaceDropPlaceholderVisible(event, linePosition) && !this.isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition)) {\n            this.dropPlaceholder.removeClass(\"left right\");\n            this.movePlaceholder.css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? linePosition.width - this.movePosition.right : \"\",\n              width: dragColumn.preview.element.outerWidth() + \"px\"\n            }).addClass(\"active\");\n          } else {\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        } else {\n          // If we're moving to another column line we utilise the existing drop placeholder\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX <= position.right && position.canShrink;\n          });\n\n          if (this.movePosition && !this.isNewLinePlaceDropPlaceholderVisible(event, linePosition)) {\n            var classToRemove = this.movePosition.placement === \"left\" ? \"right\" : \"left\";\n            this.movePlaceholder.removeClass(\"active\");\n            this.dropPlaceholder.removeClass(classToRemove).css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? linePosition.width - this.movePosition.right : \"\",\n              width: linePosition.width / this.resizeUtils.getGridSize() + \"px\"\n            }).addClass(this.movePosition.placement);\n          } else {\n            this.dropPlaceholder.removeClass(\"left right\");\n          }\n        }\n      }\n    }\n    /**\n     * Handle the resizing on mouse move, we always resize a pair of columns at once\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onResizingMouseMove = function onResizingMouseMove(event, group, groupPosition) {\n      var _this7 = this;\n\n      var newColumnWidth;\n\n      if (this.resizeMouseDown) {\n        event.preventDefault();\n        var currentPos = event.pageX;\n        var resizeColumnLeft = this.resizeColumnInstance.preview.element.offset().left;\n        var resizeColumnWidth = this.resizeColumnInstance.preview.element.outerWidth();\n        var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n        var direction = currentPos >= resizeHandlePosition ? \"right\" : \"left\";\n        var adjustedColumn;\n        var modifyColumnInPair; // We need to know if we're modifying the left or right column in the pair\n\n        var usedHistory; // Was the adjusted column pulled from history?\n        // Determine which column in the group should be adjusted for this action\n\n        var _this$resizeUtils$det = this.resizeUtils.determineAdjustedColumn(currentPos, this.resizeColumnInstance, this.resizeHistory);\n\n        adjustedColumn = _this$resizeUtils$det[0];\n        modifyColumnInPair = _this$resizeUtils$det[1];\n        usedHistory = _this$resizeUtils$det[2];\n        // Calculate the ghost width based on mouse position and bounds of allowed sizes\n        var ghostWidth = this.resizeUtils.calculateGhostWidth(groupPosition, currentPos, this.resizeColumnInstance, modifyColumnInPair, this.resizeMaxGhostWidth);\n        this.resizeGhost.width(ghostWidth - 15 + \"px\").addClass(\"active\");\n\n        if (adjustedColumn && this.resizeColumnWidths) {\n          newColumnWidth = this.resizeColumnWidths.find(function (val) {\n            return (0, _resize.comparator)(currentPos, val.position, 35) && val.forColumn === modifyColumnInPair;\n          });\n\n          if (newColumnWidth) {\n            var mainColumn = this.resizeColumnInstance; // If we're using the left data set, we're actually resizing the right column of the group\n\n            if (modifyColumnInPair === \"right\") {\n              mainColumn = (0, _resize.getAdjacentColumn)(this.resizeColumnInstance, \"+1\");\n            } // Ensure we aren't resizing multiple times, also validate the last resize isn't the same as the\n            // one being performed now. This occurs as we re-calculate the column positions on resize, we have\n            // to use the comparator as the calculation may result in slightly different numbers due to rounding\n\n\n            if (this.resizeUtils.getColumnWidth(mainColumn) !== newColumnWidth.width && !(0, _resize.comparator)(this.resizeLastPosition, newColumnWidth.position, 10)) {\n              // If our previous action was to resize the right column in pair, and we're now dragging back\n              // to the right, but have matched a column for the left we need to fix the columns being\n              // affected\n              if (usedHistory && this.resizeLastColumnInPair === \"right\" && direction === \"right\" && newColumnWidth.forColumn === \"left\") {\n                var originalMainColumn = mainColumn;\n                mainColumn = adjustedColumn;\n                adjustedColumn = (0, _resize.getAdjacentColumn)(originalMainColumn, \"+1\");\n              }\n\n              this.recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair);\n              this.resizeLastPosition = newColumnWidth.position;\n              this.resizeLastColumnInPair = modifyColumnInPair; // Ensure the adjusted column is marked as resizing to animate correctly\n\n              this.setColumnsAsResizing(mainColumn, adjustedColumn);\n              this.onColumnResize(mainColumn, newColumnWidth.width, adjustedColumn); // Wait for the render cycle to finish from the above resize before re-calculating\n\n              _underscore.defer(function () {\n                // If we do a resize, re-calculate the column widths\n                _this7.resizeColumnWidths = _this7.resizeUtils.determineColumnWidths(_this7.resizeColumnInstance, groupPosition);\n                _this7.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this7.resizeColumnWidths);\n              });\n            }\n          }\n        }\n      }\n    }\n    /**\n     * Unset resizing flag on all child columns\n     */\n    ;\n\n    _proto.unsetResizingColumns = function unsetResizingColumns() {\n      this.contentType.children().forEach(function (column) {\n        column.preview.resizing(false);\n\n        if (column.preview.element) {\n          column.preview.element.css({\n            transition: \"\"\n          });\n        }\n      });\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewLinePlaceDropPlaceholderVisible = function isNewLinePlaceDropPlaceholderVisible(event, linePosition) {\n      var siblings = this.contentType.parentContentType.children();\n      var id = this.contentType.id;\n      var index = 0;\n      siblings.forEach(function (columnLine) {\n        if (columnLine.id === id) {\n          return false;\n        }\n\n        index++;\n      });\n      var draggedColumn = (0, _registry.getDragColumn)(); // show column line drop placeholder only for top column line in a group\n\n      return (this.dropOverElement || draggedColumn) && event.pageY > linePosition.top + 15 && event.pageY < linePosition.top + 15 + this.lineDropperHeight;\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewLineBottomPlaceDropPlaceholderVisible = function isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition) {\n      var draggedColumn = (0, _registry.getDragColumn)();\n      return (this.dropOverElement || draggedColumn) && event.pageY < linePosition.top + 15 + this.element.outerHeight() && event.pageY > linePosition.top + 15 + this.element.outerHeight() - this.lineDropperHeight;\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewColumnDropPlaceholderVisible = function isNewColumnDropPlaceholderVisible(event, linePosition) {\n      var draggedColumn = (0, _registry.getDragColumn)();\n      return (this.dropOverElement || draggedColumn) && event.pageY > linePosition.top + 15 + this.lineDropperHeight && event.pageY < linePosition.top + 15 + linePosition.outerHeight - this.lineDropperHeight;\n    }\n    /**\n     * Handle mouse move events on when dropping elements\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} line\n     * @param {LinePositionCache} linePosition\n     */\n    ;\n\n    _proto.onDroppingMouseMove = function onDroppingMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.isNewLinePlaceDropPlaceholderVisible(event, linePosition)) {\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n        this.columnLineDropPlaceholder.addClass(\"active\");\n        this.columnLineDropPlaceholder.show();\n        return this.handleLineDropMouseMove(event, line, linePosition);\n      } else if (this.isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition)) {\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n        this.columnLineBottomDropPlaceholder.addClass(\"active\");\n        this.columnLineBottomDropPlaceholder.show();\n        return this.handleLineDropMouseMove(event, line, linePosition);\n      } else if (this.dropOverElement) {\n        this.columnLineDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n        this.columnLineDropPlaceholder.removeClass(\"active\");\n      }\n\n      if (this.isNewColumnDropPlaceholderVisible(event, linePosition)) {\n        this.columnLineDropPlaceholder.hide();\n        this.columnLineDropPlaceholder.removeClass(\"active\");\n        this.columnLineBottomDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n        return this.handleColumnDropMouseMove(event, line, linePosition);\n      }\n    }\n    /**\n     *\n     * @param event\n     * @param line\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.handleLineDropMouseMove = function handleLineDropMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Disable the column line sortable instance\n      // Disable the column group sortable instance\n\n      if (elementChildrenParent.data(\"ui-sortable\")) {\n        elementChildrenParent.sortable(\"option\", \"disabled\", true);\n      }\n    }\n    /**\n     *\n     * @param event\n     * @param line\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.handleColumnDropMouseMove = function handleColumnDropMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.dropOverElement && event.pageY > linePosition.top + 50 && event.pageY < linePosition.top + linePosition.outerHeight - 50) {\n        // Disable the column line sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", true);\n        }\n\n        var currentX = event.pageX - linePosition.left;\n        this.dropPosition = this.dropPositions.find(function (position) {\n          return currentX > position.left && currentX <= position.right && position.canShrink;\n        });\n\n        if (this.dropPosition) {\n          this.dropPlaceholder.removeClass(\"left right\").css({\n            left: this.dropPosition.placement === \"left\" ? this.dropPosition.left : \"\",\n            right: this.dropPosition.placement === \"right\" ? linePosition.width - this.dropPosition.right : \"\",\n            width: linePosition.width / this.resizeUtils.getGridSize() + \"px\"\n          }).addClass(this.dropPosition.placement);\n        }\n      } else if (this.dropOverElement) {\n        // Re-enable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", false);\n        }\n\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n      }\n    }\n    /**\n     * Cache the groups positions\n     *\n     * @param {JQuery} line\n     * @returns {}\n     */\n    ;\n\n    _proto.getLinePosition = function getLinePosition(line) {\n      if (!this.linePositionCache) {\n        this.linePositionCache = {\n          top: line.offset().top,\n          left: line.offset().left,\n          width: line.width(),\n          height: line.height(),\n          outerWidth: line.outerWidth(),\n          outerHeight: line.outerHeight()\n        };\n      }\n\n      return this.linePositionCache;\n    }\n    /**\n     * Init the droppable functionality for new columns\n     *\n     * @param {JQuery} line\n     */\n    ;\n\n    _proto.initDroppable = function initDroppable(line) {\n      var self = this;\n      var headStyles;\n      line.droppable({\n        deactivate: function deactivate() {\n          self.dropOverElement = null;\n          self.dropPlaceholder.removeClass(\"left right\");\n\n          _underscore.defer(function () {\n            // Re-enable the column group sortable instance & all children sortable instances\n            line.parents(\".element-children\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n              }\n            });\n          });\n        },\n        activate: function activate() {\n          if ((0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            var _ref;\n\n            line.find(\".ui-sortable\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", true);\n              }\n            });\n            var classes = [\".pagebuilder-content-type.pagebuilder-column .pagebuilder-drop-indicator\", \".pagebuilder-content-type.pagebuilder-column .empty-container .content-type-container:before\"]; // Ensure we don't display any drop indicators inside the column\n\n            headStyles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classes.join(\", \")] = {\n              display: \"none!important\"\n            }, _ref));\n            document.head.appendChild(headStyles);\n          } else if (headStyles) {\n            headStyles.remove();\n            headStyles = null;\n          }\n        },\n        drop: function drop() {\n          self.dropPositions = [];\n          self.dropPlaceholder.removeClass(\"left right\");\n        },\n        out: function out() {\n          self.dropOverElement = null;\n          self.dropPlaceholder.removeClass(\"left right\");\n        },\n        over: function over() {\n          // Is the element currently being dragged a column group?\n          if ((0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\") || (0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column\")) {\n            // Always calculate drop positions when an element is dragged over\n            var ownContentType = self.contentType;\n            self.dropPositions = (0, _dragAndDrop.calculateDropPositions)(ownContentType);\n            self.dropOverElement = true;\n          } else {\n            self.dropOverElement = null;\n          }\n        }\n      });\n    }\n    /**\n     * Spread any empty space across the other columns when a column is removed\n     *\n     * @param {number} removedIndex\n     */\n    ;\n\n    _proto.spreadWidth = function spreadWidth(removedIndex) {\n      if (this.contentType.children().length === 0) {\n        return;\n      }\n\n      var availableWidth = 100 - this.resizeUtils.getColumnsWidth();\n      var formattedAvailableWidth = (0, _resize.getRoundedColumnWidth)(availableWidth);\n      var totalChildColumns = this.contentType.children().length;\n      var allowedColumnWidths = [];\n      var spreadAcross = 1;\n      var spreadAmount;\n\n      for (var i = this.resizeUtils.getGridSize(); i > 0; i--) {\n        allowedColumnWidths.push((0, _resize.getRoundedColumnWidth)(100 / this.resizeUtils.getGridSize() * i));\n      } // Determine how we can spread the empty space across the columns\n\n\n      for (var _i = totalChildColumns; _i > 0; _i--) {\n        var potentialWidth = Math.floor(formattedAvailableWidth / _i);\n\n        for (var _iterator = _createForOfIteratorHelperLoose(allowedColumnWidths), _step; !(_step = _iterator()).done;) {\n          var width = _step.value;\n\n          if (potentialWidth === Math.floor(width)) {\n            spreadAcross = _i;\n            spreadAmount = formattedAvailableWidth / _i;\n            break;\n          }\n        }\n\n        if (spreadAmount) {\n          break;\n        }\n      } // Let's spread the width across the columns\n\n\n      for (var _i2 = 1; _i2 <= spreadAcross; _i2++) {\n        var columnToModify = void 0; // As the original column has been removed from the array, check the new index for a column\n\n        if (removedIndex <= this.contentType.children().length && typeof this.contentType.children()[removedIndex] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex];\n        }\n\n        if (!columnToModify && removedIndex - _i2 >= 0 && typeof this.contentType.children()[removedIndex - _i2] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex - _i2];\n        }\n\n        if (columnToModify) {\n          (0, _resize.updateColumnWidth)(columnToModify, this.resizeUtils.getColumnWidth(columnToModify) + spreadAmount);\n        }\n      }\n    }\n    /**\n     * Register a resize handle within a child column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {JQuery} handle\n     */\n    ;\n\n    _proto.registerResizeHandle = function registerResizeHandle(column, handle) {\n      var _this8 = this;\n\n      handle.off(\"mousedown touchstart\");\n      handle.on(\"mousedown touchstart\", function (event) {\n        event.preventDefault();\n\n        var groupPosition = _this8.getLinePosition(_this8.element);\n\n        _this8.resizing(true); // @ts-ignore\n\n\n        _this8.resizeColumnInstance = column;\n        _this8.resizeColumnWidths = _this8.resizeUtils.determineColumnWidths(_this8.resizeColumnInstance, groupPosition);\n        _this8.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this8.resizeColumnWidths); // Force the cursor to resizing\n\n        (0, _jquery)(\"body\").css(\"cursor\", \"col-resize\"); // Reset the resize history\n\n        _this8.resizeHistory = {\n          left: [],\n          right: []\n        };\n        _this8.resizeLastPosition = null;\n        _this8.resizeMouseDown = true;\n        ++_this8.interactionLevel;\n\n        _events.trigger(\"stage:interactionStart\", {\n          stageId: _this8.contentType.stageId\n        });\n      });\n    }\n    /**\n     * Add Columns to the current Column Line\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumns = function createColumns() {\n      var _this9 = this;\n\n      var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n      var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n      Promise.all([(0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: col1Width + \"%\"\n      }), (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: 100 - parseFloat(col1Width) + \"%\"\n      })]).then(function (columns) {\n        _this9.contentType.addChild(columns[0], 0);\n\n        _this9.contentType.addChild(columns[1], 1);\n\n        _this9.fireMountEvent(_this9.contentType, columns[0], columns[1]);\n      });\n    }\n    /**\n     * Record the resizing history for this action\n     *\n     * @param {string} usedHistory\n     * @param {string} direction\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     * @param {string} modifyColumnInPair\n     */\n    ;\n\n    _proto.recordResizeHistory = function recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair) {\n      if (usedHistory) {\n        this.resizeHistory[usedHistory].pop();\n      }\n\n      this.resizeHistory[direction].push({\n        adjustedColumn: adjustedColumn,\n        modifyColumnInPair: modifyColumnInPair\n      });\n    }\n    /**\n     * Set columns in the group as resizing\n     *\n     * @param {Array<ContentTypeCollectionInterface<ColumnPreview>>} columns\n     */\n    ;\n\n    _proto.setColumnsAsResizing = function setColumnsAsResizing() {\n      for (var _len = arguments.length, columns = new Array(_len), _key = 0; _key < _len; _key++) {\n        columns[_key] = arguments[_key];\n      }\n\n      columns.forEach(function (column) {\n        column.preview.resizing(true);\n        column.preview.element.css({\n          transition: \"width 350ms ease-in-out\"\n        });\n      });\n    }\n    /**\n     * Handle a column being resized\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(column, width, adjustedColumn) {\n      this.resizeUtils.resizeColumn(column, width, adjustedColumn);\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len2 = arguments.length, contentTypes = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n        contentTypes[_key2] = arguments[_key2];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Remove self if we contain no children\n     */\n    ;\n\n    _proto.removeIfEmpty = function removeIfEmpty() {\n      if (this.contentType.children().length === 0) {\n        this.contentType.parentContentType.removeChild(this.contentType);\n        return;\n      }\n    };\n\n    _proto.getNewColumnLineIndex = function getNewColumnLineIndex() {\n      var index = -1;\n      var self = this;\n\n      for (var _iterator2 = _createForOfIteratorHelperLoose(this.contentType.parentContentType.children()), _step2; !(_step2 = _iterator2()).done;) {\n        var child = _step2.value;\n        index++;\n\n        if (child.id === self.contentType.id) {\n          break;\n        }\n      }\n\n      if (this.columnLineBottomDropPlaceholder.hasClass(\"active\")) {\n        // show the bottom drop placeholder\n        index++;\n      }\n\n      return index;\n    };\n\n    _proto.isColumnBeingMovedToAnotherColumnLine = function isColumnBeingMovedToAnotherColumnLine() {\n      var column = (0, _registry.getDragColumn)();\n\n      if (!column) {\n        // if no move position, column is not being moved.\n        return false;\n      }\n\n      if (column.parentContentType !== this.contentType) {\n        // if the parent content type is not same as this column line, column is being moved to new column line\n        return true;\n      }\n\n      if (column.parentContentType === this.contentType && (this.columnLineDropPlaceholder.hasClass(\"active\") || this.columnLineBottomDropPlaceholder.hasClass(\"active\"))) {\n        // since new column line drop placeholder is visible, column move should introduce a new column line\n        return true;\n      }\n\n      return false;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/image/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/content-type/preview\"], function (_events, _hideShowOption, _uploader, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\");\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * Get viewport image data\n     */\n    ;\n\n    _proto.getViewportImageData = function getViewportImageData() {\n      var desktopImageData = this.data.desktop_image;\n      var mobileImageData = this.data.mobile_image;\n      return this.viewport() === \"mobile\" && typeof mobileImageData !== \"undefined\" ? mobileImageData : desktopImageData;\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"image:mountAfter\", function (args) {\n        if (args.id === _this.contentType.id) {\n          _this.isSnapshot.subscribe(function (value) {\n            _this.changeUploaderControlsVisibility();\n          });\n\n          _this.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var files = _this.contentType.dataStore.get(_this.config.additional_data.uploaderConfig.dataScope);\n\n        var imageObject = files ? files[0] : {};\n\n        _events.trigger(\"image:\" + _this.contentType.id + \":assignAfter\", imageObject);\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this2 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this2.isSnapshot();\n      });\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/observable-updater/html.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/object\"], function (_config, _directives, _editor, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements html binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   */\n  function generate(elementName, config, data, converterResolver, converterPool) {\n    var value = config.html.var ? (0, _object.get)(data, config.html.var, config.html.placeholder) : config.html.placeholder;\n    var converter = converterResolver(config.html);\n\n    if (converterPool.get(converter)) {\n      value = converterPool.get(converter).toDom(config.html.var, data);\n    } // if value is empty, use placeholder\n\n\n    if (typeof value === \"string\" && !value.length && config.html.placeholder) {\n      value = config.html.placeholder;\n    } // Replacing src attribute with data-tmp-src to prevent img requests in iframe during master format rendering\n\n\n    if (_config.getMode() !== \"Preview\" && typeof value === \"string\" && value.indexOf(\"{{media url=\") !== -1) {\n      value = (0, _directives.replaceWithDataSrc)(value);\n    } // Process all desktop styles that left unprocessed after migrating from inline styles.\n\n\n    if (typeof value === \"string\") {\n      value = (0, _editor.processInlineStyles)(value);\n    }\n\n    return value;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=html.js.map","Magento_PageBuilder/js/content-type/observable-updater/style.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/utils/string\"], function (_underscore, _object, _string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements style binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   * @param previousData\n   */\n  function generate(elementName, config, data, converterResolver, converterPool, previousData) {\n    var newStyles = {};\n\n    if (config.style) {\n      for (var _iterator = _createForOfIteratorHelperLoose(config.style), _step; !(_step = _iterator()).done;) {\n        var propertyConfig = _step.value;\n\n        if (\"read\" === propertyConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = void 0;\n\n        if (!!propertyConfig.static) {\n          value = propertyConfig.value;\n        } else {\n          value = (0, _object.get)(data, propertyConfig.var);\n          var converter = converterResolver(propertyConfig);\n\n          if (converterPool.get(converter)) {\n            value = converterPool.get(converter).toDom(propertyConfig.var, data);\n          }\n        }\n\n        if (typeof value === \"object\") {\n          _underscore.extend(newStyles, value);\n        } else if (value !== undefined) {\n          newStyles[(0, _string.fromSnakeToCamelCase)(propertyConfig.name)] = value;\n        }\n      }\n    }\n\n    if (previousData) {\n      /**\n       * If so we need to retrieve the previous styles applied to this element and create a new object\n       * which forces all of these styles to be \"false\". Knockout doesn't clean existing styles when\n       * applying new styles to an element. This resolves styles sticking around when they should be\n       * removed.\n       */\n      var removeCurrentStyles = Object.keys(previousData).reduce(function (object, styleName) {\n        var _Object$assign;\n\n        return Object.assign(object, (_Object$assign = {}, _Object$assign[styleName] = \"\", _Object$assign));\n      }, {});\n\n      if (!_underscore.isEmpty(removeCurrentStyles)) {\n        newStyles = _underscore.extend(removeCurrentStyles, newStyles);\n      }\n    }\n\n    return newStyles;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=style.js.map","Magento_PageBuilder/js/content-type/observable-updater/attributes.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _config, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements attribute binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   */\n  function generate(elementName, config, data, converterResolver, converterPool) {\n    var attributeData = {};\n\n    var _loop = function _loop() {\n      var attributeConfig = _step.value;\n\n      if (\"read\" === attributeConfig.persistence_mode) {\n        return \"continue\";\n      } // @ts-ignore\n\n\n      var value = void 0;\n\n      if (!!attributeConfig.static) {\n        value = attributeConfig.value;\n      } else {\n        value = (0, _object.get)(data, attributeConfig.var);\n      }\n\n      var converter = converterResolver(attributeConfig);\n\n      if (converterPool.get(converter)) {\n        value = converterPool.get(converter).toDom(attributeConfig.var, data);\n      } // Replacing src attribute with data-tmp-src to prevent img requests in iframe during master format rendering\n\n\n      if (_config.getMode() !== \"Preview\" && attributeConfig.name === \"src\" && _underscore.isString(value) && !value.indexOf(\"{{media url=\")) {\n        attributeData[\"data-tmp-\" + attributeConfig.name] = value; // @ts-ignore\n\n        Object.defineProperty(attributeData, attributeConfig.name, {\n          get: function get() {\n            return value;\n          }\n        });\n      } else {\n        attributeData[attributeConfig.name] = value;\n      }\n    };\n\n    for (var _iterator = _createForOfIteratorHelperLoose(config.attributes), _step; !(_step = _iterator()).done;) {\n      var _ret = _loop();\n\n      if (_ret === \"continue\") continue;\n    }\n\n    attributeData[\"data-element\"] = elementName;\n    return attributeData;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=attributes.js.map","Magento_PageBuilder/js/content-type/observable-updater/css.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements css binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   * @param previousData\n   */\n  function generate(elementName, config, data, converterResolver, converterPool, previousData) {\n    var css = (0, _object.get)(data, config.css.var);\n    var newClasses = {};\n\n    if (css && css.length > 0) {\n      css.toString().split(\" \").map(function (value) {\n        return newClasses[value] = true;\n      });\n    }\n\n    for (var _i = 0, _Object$keys = Object.keys(previousData); _i < _Object$keys.length; _i++) {\n      var className = _Object$keys[_i];\n\n      if (!(className in newClasses)) {\n        newClasses[className] = false;\n      }\n    }\n\n    return newClasses;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=css.js.map","Magento_PageBuilder/js/content-type/row/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/resource/resize-observer/ResizeObserver\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jarallax, _jarallaxVideo, _jquery, _knockout, _events, _ResizeObserver, _underscore, _vimeoWrapper, _hideShowOption, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Debounce and defer the init of Jarallax\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.wrapClass = _knockout.observable(false);\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.element, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.element && (0, _jquery)(_this.element).hasClass(\"jarallax\") && _this.contentType.dataStore.get(\"background_type\") !== \"video\" && _this.contentType.dataStore.get(\"background_image\").length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            var parallaxSpeed = Number.parseFloat(_this.contentType.dataStore.get(\"parallax_speed\"));\n            jarallax(_this.element, {\n              imgPosition: _this.contentType.dataStore.get(\"background_position\") || \"50% 50%\",\n              imgRepeat: _this.contentType.dataStore.get(\"background_repeat\") || \"no-repeat\",\n              imgSize: _this.contentType.dataStore.get(\"background_size\") || \"cover\",\n              speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n            });\n            jarallax(_this.element, \"onResize\");\n          });\n        }\n\n        if (_this.element && _this.element.dataset.backgroundType === \"video\" && _this.element.dataset.videoSrc.length) {\n          var parallaxSpeed = _this.contentType.dataStore.get(\"enable_parallax\") === \"1\" ? Number.parseFloat(_this.contentType.dataStore.get(\"parallax_speed\")) : 1;\n\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            jarallax(_this.element, {\n              videoSrc: _this.element.dataset.videoSrc,\n              imgSrc: _this.element.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.element.jarallax && _this.element.jarallax.video) {\n              // @ts-ignore\n              _this.element.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.element.jarallax.$video) {\n                  // @ts-ignore\n                  _this.element.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n\n      _this.contentType.dataStore.subscribe(_this.buildJarallax);\n\n      _events.on(\"row:mountAfter\", function (args) {\n        if (args.id === _this.contentType.id) {\n          _this.buildJarallax();\n        }\n      });\n\n      _events.on(\"contentType:mountAfter\", function (args) {\n        if (args.contentType.parentContentType && args.contentType.parentContentType.id === _this.contentType.id) {\n          _this.buildJarallax();\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.toggleFullScreen.bind(_assertThisInitialized(_this)));\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this.buildJarallax();\n      });\n\n      return _this;\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Toggle fullscreen\n     */\n    ;\n\n    _proto.toggleFullScreen = function toggleFullScreen() {\n      if ((0, _jquery)(this.element).hasClass(\"jarallax\")) {\n        this.buildJarallax();\n      }\n    }\n    /**\n     * Use the conditional remove to disable the option when the content type has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this2 = this;\n\n      this.element = element;\n\n      _underscore.defer(function () {\n        _this2.buildJarallax();\n      });\n\n      new _ResizeObserver(function () {\n        // Observe for resizes of the element and force jarallax to display correctly\n        if ((0, _jquery)(_this2.element).hasClass(\"jarallax\") && _this2.contentType.dataStore.get(\"background_image\").length) {\n          jarallax(_this2.element, \"onResize\");\n          jarallax(_this2.element, \"onScroll\");\n        }\n      }).observe(this.element);\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _previewCollection2.prototype.destroy.call(this);\n\n      if (this.element) {\n        jarallax(this.element, \"destroy\");\n      }\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/row/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * @param {string} value\n     * @returns {Object | string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/content-type/row/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * @param {string} value\n     * @returns {Object | string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = (parseInt(value.margin.bottom, 10) > 0 ? value.margin.bottom : 1) + \"px\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/row/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/widget/video-background',\n    'jarallax'\n], function ($, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = null,\n            elementStyle = null;\n\n        if ($element.data('appearance') === 'contained') {\n            $element = $(element).find('[data-element=\"inner\"]');\n        }\n\n        if ($element.data('background-type') === 'video') {\n            videoBackground(config, $element[0]);\n\n            return;\n        }\n\n        if ($element.data('enableParallax') !== 1) {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        parallaxSpeed = parseFloat($element.data('parallaxSpeed'));\n        elementStyle = window.getComputedStyle($element[0]);\n\n        window.jarallax($element[0], {\n            imgPosition: elementStyle.backgroundPosition || '50% 50%',\n            imgRepeat: elementStyle.backgroundRepeat || 'no-repeat',\n            imgSize: elementStyle.backgroundSize || 'cover',\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/row/appearance/default/widget-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(['underscore', 'jquery', 'Magento_PageBuilder/js/events'], function (_, $, events) {\n    'use strict';\n\n    return function (target) {\n        return function (config, element) {\n            var result = target(config, element),\n                stageId = $(element).parents('[data-role=\"pagebuilder-stage\"]').attr('id'),\n                $element = $(element);\n\n            if ($element.data('appearance') === 'contained') {\n                $element = $(element).find('[data-element=\"inner\"]');\n            }\n\n            // If Parallax isn't enabled, let's not attach the event\n            if ($element.data('enableParallax') !== 1) {\n                return result;\n            }\n\n            // Listen for full screen events and destroy and rebuild jarallax\n            events.on('stage:' + stageId + ':fullScreenModeChangeAfter', function () {\n                _.delay(function () {\n                    $element.jarallax('destroy');\n                    target(config, element);\n                }, 350);\n            });\n\n            return result;\n        };\n    };\n});\n","Magento_PageBuilder/js/content-type/column-group/drag-and-drop.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Calculate the drop positions of a column group\n   *\n   * @param {ContentTypeCollectionInterface} group\n   * @returns {any[]}\n   */\n  function calculateDropPositions(group) {\n    var resizeUtils = group.preview.getResizeUtils();\n    var dropPositions = [];\n    group.children().forEach(function (column, index) {\n      var left = column.preview.element.position().left;\n      var width = column.preview.element.outerWidth(true);\n      var canShrink = resizeUtils.getAcceptedColumnWidth(resizeUtils.getColumnWidth(column).toString()) > resizeUtils.getSmallestColumnWidth();\n      dropPositions.push({\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index,\n        left: left,\n        placement: \"left\",\n        right: left + width / 2\n      }, {\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index + 1,\n        left: left + width / 2,\n        placement: \"right\",\n        right: left + width\n      });\n    });\n    return dropPositions;\n  }\n\n  return {\n    calculateDropPositions: calculateDropPositions\n  };\n});\n//# sourceMappingURL=drag-and-drop.js.map","Magento_PageBuilder/js/content-type/column-group/registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var dragColumn;\n  /**\n   * Retrieve the drag column from the registry\n   *\n   * @returns {ContentTypeCollectionInterface}\n   */\n\n  function getDragColumn() {\n    return dragColumn;\n  }\n  /**\n   * Remove the drag column reference\n   */\n\n\n  function removeDragColumn() {\n    dragColumn = null;\n  }\n  /**\n   * Set the drag column in the registry\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   */\n\n\n  function setDragColumn(column) {\n    dragColumn = column;\n  }\n\n  return {\n    getDragColumn: getDragColumn,\n    removeDragColumn: removeDragColumn,\n    setDragColumn: setDragColumn\n  };\n});\n//# sourceMappingURL=registry.js.map","Magento_PageBuilder/js/content-type/column-group/factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\"], function (_config, _contentTypeFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a column and add it to it's column group\n   *\n   * @param {ContentTypeCollectionInterface} columnGroup\n   * @param {number} width\n   * @param {number} index\n   * @returns {Promise<ContentTypeCollectionInterface>}\n   */\n  function createColumn(columnGroup, width, index) {\n    return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), columnGroup, columnGroup.stageId, {\n      width: parseFloat(width.toString()) + \"%\"\n    }).then(function (column) {\n      columnGroup.addChild(column, index);\n      return column;\n    }).catch(function (error) {\n      console.error(error);\n      return null;\n    });\n  }\n  /**\n   * Create a column and add it to it's column group\n   *\n   * @param {ContentTypeCollectionInterface} columnGroup\n   * @param {number} width\n   * @param {number} index\n   * @returns {Promise<ContentTypeCollectionInterface>}\n   */\n\n\n  function createColumnLine(columnGroup, width, index) {\n    return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-line\"), columnGroup, columnGroup.stageId, {\n      width: parseFloat(width.toString()) + \"%\"\n    }).then(function (columnLine) {\n      columnGroup.addChild(columnLine, index);\n      return columnLine;\n    }).catch(function (error) {\n      console.error(error);\n      return null;\n    });\n  }\n\n  return {\n    createColumn: createColumn,\n    createColumnLine: createColumnLine\n  };\n});\n//# sourceMappingURL=factory.js.map","Magento_PageBuilder/js/content-type/column-group/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/utils/check-stage-full-screen\", \"Magento_PageBuilder/js/utils/create-stylesheet\", \"Magento_PageBuilder/js/content-type/column/resize\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column-group/drag-and-drop\", \"Magento_PageBuilder/js/content-type/column-group/factory\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column-group/registry\"], function (_jquery, _knockout, _translate, _hideShowOption, _events, _underscore, _config, _contentTypeFactory, _moveContentType, _registry, _sortable, _checkStageFullScreen, _createStylesheet, _resize, _previewCollection, _dragAndDrop, _factory, _gridSize, _registry2) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     *\n     * @param {ContentTypeCollection} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.resizing = _knockout.observable(false);\n      _this.hasEmptyChild = _knockout.computed(function () {\n        var empty = false;\n\n        _this.contentType.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            empty = true;\n          }\n        });\n\n        return empty;\n      });\n      _this.gridSize = _knockout.observable();\n      _this.gridSizeInput = _knockout.observable();\n      _this.gridSizeArray = _knockout.observableArray([]);\n      _this.gridSizeError = _knockout.observable();\n      _this.gridSizeMax = _knockout.observable((0, _gridSize.getMaxGridSize)());\n      _this.gridFormOpen = _knockout.observable(false);\n      _this.gridChange = _knockout.observable(false);\n      _this.gridToolTipOverFlow = _knockout.observable(false);\n      _this.resizeColumnWidths = [];\n      _this.resizeHistory = {\n        left: [],\n        right: []\n      };\n      _this.dropPositions = [];\n      _this.gridSizeHistory = new Map();\n      _this.interactionLevel = 0;\n      _this.resizeUtils = new _resize(_this.contentType); // Keep track of the grid size in an observable\n\n      _this.contentType.dataStore.subscribe(function (state) {\n        var gridSize = parseInt(state.grid_size.toString(), 10);\n\n        _this.gridSize(gridSize);\n\n        _this.gridSizeInput(gridSize);\n\n        if (gridSize) {\n          _this.gridSizeArray(new Array(gridSize));\n        }\n      }, \"grid_size\");\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.spreadWidth(args.index);\n          });\n        }\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnGroup.id === _this.contentType.id) {\n          _this.bindDraggable(args.column);\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":readyAfter\", _this.moveContentsToNewColumnGroup.bind(_assertThisInitialized(_this)));\n\n      _events.on(\"column-group:renderAfter\", function (args) {\n        if (args.contentType.id === _this.contentType.id) {\n          if (!_this.hasColumnLine(args.contentType)) {\n            args.element.classList.add(\"no-column-line\");\n          } else {\n            args.element.classList.remove(\"no-column-line\");\n            args.element.classList.add(\"with-column-line\");\n          }\n        }\n      });\n\n      _this.contentType.children.subscribe(_underscore.debounce(_this.removeIfEmpty.bind(_assertThisInitialized(_this)), 50));\n\n      return _this;\n    }\n    /**\n     * Handle user editing an instance\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.onOptionEdit = function onOptionEdit() {\n      var numCols = this.contentType.getChildren()().length; // count the number of non empty columns\n\n      var numEmptyColumns = 0;\n      this.contentType.getChildren()().forEach(function (column) {\n        if (column.getChildren()().length === 0) {\n          numEmptyColumns++;\n        }\n      });\n      var appearance = this.contentType.dataStore.get(\"appearance\") ? this.contentType.dataStore.get(\"appearance\") : \"default\";\n      this.contentType.dataStore.set(\"appearance\", appearance);\n      this.contentType.dataStore.set(\"non_empty_column_count\", this.getNonEmptyColumnCount());\n      this.contentType.dataStore.set(\"max_grid_size\", (0, _gridSize.getMaxGridSize)());\n      this.contentType.dataStore.set(\"initial_grid_size\", this.contentType.dataStore.get(\"grid_size\"));\n\n      _previewCollection2.prototype.openEdit.call(this);\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      if (_config.getContentTypeConfig(\"column\")) {\n        _events.on(\"column-group:dropAfter\", function (args) {\n          if (args.id === _this2.contentType.id) {\n            _this2.setDefaultGridSizeOnColumnGroup();\n\n            _this2.addDefaultColumnLine(args);\n          }\n        });\n      }\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        if (_this2.contentType.dataStore.get(\"grid_size\") !== _this2.contentType.dataStore.get(\"initial_grid_size\")) {\n          _this2.updateGridSize();\n        }\n      });\n    }\n    /**\n     * Set default grid size on current column group\n     */\n    ;\n\n    _proto.setDefaultGridSizeOnColumnGroup = function setDefaultGridSizeOnColumnGroup() {\n      this.contentType.dataStore.set(\"grid_size\", (0, _gridSize.getDefaultGridSize)());\n    }\n    /**\n     * Add Columns to the current Column Group\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumns = function createColumns() {\n      var _this3 = this;\n\n      var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n      var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n      Promise.all([(0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: col1Width + \"%\"\n      }), (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: 100 - parseFloat(col1Width) + \"%\"\n      })]).then(function (columns) {\n        _this3.contentType.addChild(columns[0], 0);\n\n        _this3.contentType.addChild(columns[1], 1);\n\n        _this3.fireMountEvent(_this3.contentType, columns[0], columns[1]);\n      });\n    };\n\n    _proto.addDefaultColumnLine = function addDefaultColumnLine(args) {\n      var _this4 = this;\n\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-line\"), this.contentType, this.contentType.stageId).then(function (columnLine) {\n        _this4.contentType.addChild(columnLine, 0);\n\n        if (args.columnGroupWithoutColumnLine === undefined) {\n          _events.trigger(columnLine.config.name + \":dropAfter\", {\n            id: columnLine.id,\n            columnLine: columnLine\n          });\n        } else {\n          // Move children of this column group without column line as descendant of new\n          // column group that has a column line\n          var children = args.columnGroupWithoutColumnLine.getChildren()();\n          var index = 0;\n          children.forEach(function (child) {\n            setTimeout(function () {\n              (0, _moveContentType.moveContentType)(child, index++, columnLine);\n            }, 250);\n          });\n        }\n\n        _this4.fireMountEvent(_this4.contentType, columnLine);\n      });\n    }\n    /**\n     * Use the conditional remove to disable the option when the content type has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Retrieve the resize utils\n     *\n     * @returns {Resize}\n     */\n    ;\n\n    _proto.getResizeUtils = function getResizeUtils() {\n      return this.resizeUtils;\n    }\n    /**\n     * Handle a new column being dropped into the group\n     *\n     * @param {DropPosition} dropPosition\n     */\n    ;\n\n    _proto.onNewColumnDrop = function onNewColumnDrop(dropPosition) {\n      var _this5 = this;\n\n      // Create our new column\n      (0, _factory.createColumn)(this.contentType, this.resizeUtils.getSmallestColumnWidth(), dropPosition.insertIndex).then(function () {\n        var newWidth = _this5.resizeUtils.getAcceptedColumnWidth((_this5.resizeUtils.getColumnWidth(dropPosition.affectedColumn) - _this5.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n\n        (0, _resize.updateColumnWidth)(dropPosition.affectedColumn, newWidth);\n      });\n    }\n    /**\n     * Handle an existing column being dropped into a new column group\n     *\n     * @param {DropPosition} movePosition\n     */\n    ;\n\n    _proto.onExistingColumnDrop = function onExistingColumnDrop(movePosition) {\n      var column = (0, _registry2.getDragColumn)();\n      var sourceGroupPreview = column.parentContentType.preview;\n      var modifyOldNeighbour; // Determine which old neighbour we should modify\n\n      var oldWidth = sourceGroupPreview.getResizeUtils().getColumnWidth(column); // Retrieve the adjacent column either +1 or -1\n\n      if ((0, _resize.getAdjacentColumn)(column, \"+1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"+1\");\n      } else if ((0, _resize.getAdjacentColumn)(column, \"-1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"-1\");\n      } // Set the column to it's smallest column width\n\n\n      (0, _resize.updateColumnWidth)(column, this.resizeUtils.getSmallestColumnWidth()); // Move the content type\n\n      (0, _moveContentType.moveContentType)(column, movePosition.insertIndex, this.contentType); // Modify the old neighbour\n\n      if (modifyOldNeighbour) {\n        var oldNeighbourWidth = sourceGroupPreview.getResizeUtils().getAcceptedColumnWidth((oldWidth + sourceGroupPreview.getResizeUtils().getColumnWidth(modifyOldNeighbour)).toString());\n        (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n      } // Modify the columns new neighbour\n\n\n      var newNeighbourWidth = this.resizeUtils.getAcceptedColumnWidth((this.resizeUtils.getColumnWidth(movePosition.affectedColumn) - this.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n      (0, _resize.updateColumnWidth)(movePosition.affectedColumn, newNeighbourWidth);\n    }\n    /**\n     * Handle a column being sorted into a new position in the group\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} newIndex\n     */\n    ;\n\n    _proto.onColumnSort = function onColumnSort(column, newIndex) {\n      var currentIndex = (0, _resize.getColumnIndexInGroup)(column);\n\n      if (currentIndex !== newIndex) {\n        if (currentIndex < newIndex) {\n          // As we're moving an array item the keys all reduce by 1\n          --newIndex;\n        } // Move the content type\n\n\n        (0, _moveContentType.moveContentType)(column, newIndex);\n      }\n    }\n    /**\n     * Handle a column being resized\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(column, width, adjustedColumn) {\n      this.resizeUtils.resizeColumn(column, width, adjustedColumn);\n    }\n    /**\n     * Init the droppable & resizing interactions\n     *\n     * @param group\n     */\n    ;\n\n    _proto.bindInteractions = function bindInteractions(group) {\n      this.groupElement = (0, _jquery)(group);\n      this.initDroppable(this.groupElement);\n      this.initMouseMove(this.groupElement); // Handle the mouse leaving the window\n\n      (0, _jquery)(\"body\").mouseleave(this.endAllInteractions.bind(this));\n    }\n    /**\n     * Init the drop placeholder\n     * @deprecated - dropPlaceholder functionality moved to column-line\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindDropPlaceholder = function bindDropPlaceholder(element) {\n      this.dropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the move placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindMovePlaceholder = function bindMovePlaceholder(element) {\n      this.movePlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Retrieve the ghost element from the template\n     *\n     * @param {Element} ghost\n     */\n    ;\n\n    _proto.bindGhost = function bindGhost(ghost) {\n      this.resizeGhost = (0, _jquery)(ghost);\n    }\n    /**\n     * Register a resize handle within a child column\n     * @deprecated\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {JQuery} handle\n     */\n    ;\n\n    _proto.registerResizeHandle = function registerResizeHandle(column, handle) {\n      var _this6 = this;\n\n      handle.off(\"mousedown touchstart\");\n      handle.on(\"mousedown touchstart\", function (event) {\n        event.preventDefault();\n\n        var groupPosition = _this6.getGroupPosition(_this6.groupElement);\n\n        _this6.resizing(true);\n\n        _this6.resizeColumnInstance = column;\n        _this6.resizeColumnWidths = _this6.resizeUtils.determineColumnWidths(_this6.resizeColumnInstance, groupPosition);\n        _this6.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this6.resizeColumnWidths); // Force the cursor to resizing\n\n        (0, _jquery)(\"body\").css(\"cursor\", \"col-resize\"); // Reset the resize history\n\n        _this6.resizeHistory = {\n          left: [],\n          right: []\n        };\n        _this6.resizeLastPosition = null;\n        _this6.resizeMouseDown = true;\n        ++_this6.interactionLevel;\n\n        _events.trigger(\"stage:interactionStart\", {\n          stageId: _this6.contentType.stageId\n        });\n      });\n    }\n    /**\n     * Bind draggable instances to the child columns\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     */\n    ;\n\n    _proto.bindDraggable = function bindDraggable(column) {\n      var _this7 = this;\n\n      column.preview.element.draggable({\n        appendTo: \"body\",\n        containment: \"body\",\n        cursor: \"-webkit-grabbing\",\n        handle: \".move-column\",\n        revertDuration: 250,\n        helper: function helper() {\n          var helper = (0, _jquery)(this).clone();\n          helper.css({\n            height: (0, _jquery)(this).outerHeight() + \"px\",\n            minHeight: 0,\n            opacity: 0.5,\n            pointerEvents: \"none\",\n            width: (0, _jquery)(this).outerWidth() + \"px\",\n            zIndex: 5000\n          });\n          return helper;\n        },\n        start: function start(event) {\n          var columnInstance = _knockout.dataFor((0, _jquery)(event.target)[0]); // Use the global state as columns can be dragged between groups\n\n\n          (0, _registry2.setDragColumn)(columnInstance.contentType);\n          _this7.dropPositions = (0, _dragAndDrop.calculateDropPositions)(_this7.contentType);\n          _this7.startDragEvent = event;\n\n          _events.trigger(\"column:dragStart\", {\n            column: columnInstance,\n            stageId: _this7.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStart\", {\n            stageId: _this7.contentType.stageId\n          });\n        },\n        stop: function stop() {\n          var draggedColumn = (0, _registry2.getDragColumn)();\n\n          if (_this7.movePosition && draggedColumn) {\n            // Check if we're moving within the same group, even though this function will\n            // only ever run on the group that bound the draggable event\n            if (draggedColumn.parentContentType === _this7.contentType) {\n              _this7.onColumnSort(draggedColumn, _this7.movePosition.insertIndex);\n\n              _this7.movePosition = null;\n            }\n          }\n\n          (0, _registry2.removeDragColumn)();\n\n          _this7.movePlaceholder.removeClass(\"active\");\n\n          _this7.startDragEvent = null;\n\n          _events.trigger(\"column:dragStop\", {\n            column: draggedColumn,\n            stageId: _this7.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: _this7.contentType.stageId\n          });\n        }\n      });\n    }\n    /**\n     * Update the grid size on enter or blur of the input\n     */\n    ;\n\n    _proto.updateGridSize = function updateGridSize() {\n      var _this8 = this;\n\n      if (!_jquery.isNumeric(this.gridSizeInput())) {\n        this.gridSizeError((0, _translate)(\"Please enter a valid number.\"));\n      }\n\n      var newGridSize = parseInt(this.gridSizeInput().toString(), 10);\n\n      if (newGridSize || newGridSize === 0) {\n        if (newGridSize !== this.resizeUtils.getGridSize() || true) {\n          try {\n            (0, _gridSize.resizeGrid)(this.contentType, newGridSize, this.gridSizeHistory);\n            this.recordGridResize(newGridSize);\n            this.gridSizeError(null); // Make the grid \"flash\" on successful change\n\n            this.gridChange(true);\n\n            _underscore.delay(function () {\n              _this8.gridChange(false);\n            }, 1000);\n          } catch (e) {\n            if (e instanceof _gridSize.GridSizeError) {\n              this.gridSizeError(e.message);\n            } else {\n              throw e;\n            }\n          }\n        } else {\n          this.gridSizeError(null);\n        }\n      }\n    }\n    /**\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n     * @private\n     */\n    ;\n\n    _proto.hasColumnLine = function hasColumnLine(contentType) {\n      var children = this.contentType.getChildren()();\n      var hasColumnLine = false;\n\n      if (children.length === 0 && (0, _checkStageFullScreen)(contentType.stageId)) {\n        // new column group, so it has a column line\n        hasColumnLine = true;\n      }\n\n      children.forEach(function (child) {\n        if (child.config.name === \"column-line\") {\n          hasColumnLine = true;\n        }\n      });\n      return hasColumnLine;\n    }\n    /**\n     * If the column group does not have a column line, move contents to a new column group with a column line\n     */\n    ;\n\n    _proto.moveContentsToNewColumnGroup = function moveContentsToNewColumnGroup() {\n      var _this9 = this;\n\n      if (this.hasColumnLine(this.contentType)) {\n        // This column-group already has a column line. Don't need to add one.\n        return;\n      }\n\n      var indexToInsertNewColumnGroupAt = this.getCurrentIndexInParent();\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-group\"), this.contentType.parentContentType, this.contentType.stageId).then(function (columnGroup) {\n        _this9.contentType.parentContentType.addChild(columnGroup, indexToInsertNewColumnGroupAt);\n\n        _events.trigger(columnGroup.config.name + \":dropAfter\", {\n          id: columnGroup.id,\n          columnGroup: columnGroup,\n          columnGroupWithoutColumnLine: _this9.contentType\n        });\n\n        _this9.fireMountEvent(_this9.contentType, columnGroup);\n      });\n    }\n    /**\n     * @private return index of current content type in parent\n     */\n    ;\n\n    _proto.getCurrentIndexInParent = function getCurrentIndexInParent() {\n      var parentContentType = this.contentType.parentContentType;\n      var currentIndex = 0;\n\n      for (var _iterator = _createForOfIteratorHelperLoose(this.contentType.parentContentType.getChildren()()), _step; !(_step = _iterator()).done;) {\n        var sibling = _step.value;\n\n        if (sibling.id !== this.contentType.id) {\n          currentIndex++;\n          continue;\n        }\n\n        break;\n      }\n\n      return currentIndex;\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len = arguments.length, contentTypes = new Array(_len), _key = 0; _key < _len; _key++) {\n        contentTypes[_key] = arguments[_key];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Set columns in the group as resizing\n     *\n     * @param {Array<ContentTypeCollectionInterface<ColumnPreview>>} columns\n     */\n    ;\n\n    _proto.setColumnsAsResizing = function setColumnsAsResizing() {\n      for (var _len2 = arguments.length, columns = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n        columns[_key2] = arguments[_key2];\n      }\n\n      columns.forEach(function (column) {\n        column.preview.resizing(true);\n        column.preview.element.css({\n          transition: \"width 350ms ease-in-out\"\n        });\n      });\n    }\n    /**\n     * Unset resizing flag on all child columns\n     */\n    ;\n\n    _proto.unsetResizingColumns = function unsetResizingColumns() {\n      this.contentType.children().forEach(function (column) {\n        column.preview.resizing(false);\n\n        if (column.preview.element) {\n          column.preview.element.css({\n            transition: \"\"\n          });\n        }\n      });\n    }\n    /**\n     * End all current interactions\n     */\n    ;\n\n    _proto.endAllInteractions = function endAllInteractions() {\n      if (this.resizing() === true) {\n        for (; this.interactionLevel > 0; this.interactionLevel--) {\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: this.contentType.stageId\n          });\n        }\n      }\n\n      this.resizing(false);\n      this.resizeMouseDown = null;\n      this.resizeLeftLastColumnShrunk = this.resizeRightLastColumnShrunk = null;\n      this.dropPositions = []; // this.unsetResizingColumns();\n      // Change the cursor back\n\n      (0, _jquery)(\"body\").css(\"cursor\", \"\");\n      this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n      this.resizeGhost.removeClass(\"active\"); // Reset the group positions cache\n\n      this.groupPositionCache = null;\n    }\n    /**\n     * Init the resizing events on the group\n     *\n     * @param {JQuery} group\n     */\n    ;\n\n    _proto.initMouseMove = function initMouseMove(group) {\n      var _this10 = this;\n\n      var intersects = false;\n      (0, _jquery)(document).on(\"mousemove touchmove\", function (event) {\n        if (group.parents(_sortable.hiddenClass).length > 0) {\n          return;\n        }\n\n        var groupPosition = _this10.getGroupPosition(group); // If we're handling a touch event we need to pass through the page X & Y\n\n\n        if (event.type === \"touchmove\") {\n          event.pageX = event.originalEvent.pageX;\n          event.pageY = event.originalEvent.pageY;\n        }\n\n        if (_this10.eventIntersectsGroup(event, groupPosition)) {\n          intersects = true; // @todo make column re-sizing work\n\n          _this10.onResizingMouseMove(event, group, groupPosition);\n        } else {\n          intersects = false;\n          _this10.groupPositionCache = null;\n          _this10.dropPosition = null;\n\n          _this10.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n        }\n      }).on(\"mouseup touchend\", function () {\n        intersects = false;\n        _this10.dropPosition = null;\n\n        _this10.endAllInteractions();\n\n        _underscore.defer(function () {\n          // Re-enable any disabled sortable areas\n          group.find(\".ui-sortable\").each(function () {\n            if ((0, _jquery)(this).data(\"ui-sortable\")) {\n              (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n            }\n          });\n        });\n      });\n    }\n    /**\n     * Handle the mouse up action, either adding a new column or moving an existing\n     * @deprecated\n     */\n    ;\n\n    _proto.handleMouseUp = function handleMouseUp() {\n      if (this.dropOverElement && this.dropPosition) {\n        this.onNewColumnDrop(this.dropPosition);\n        this.dropOverElement = null; // Re-enable the parent disabled sortable instance\n\n        _underscore.defer(function () {\n          (0, _jquery)(\".element-children.ui-sortable-disabled\").each(function () {\n            (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n          });\n        });\n      }\n\n      var column = (0, _registry2.getDragColumn)();\n\n      if (this.movePosition && column && column.parentContentType !== this.contentType) {\n        this.onExistingColumnDrop(this.movePosition);\n      }\n    }\n    /**\n     * Does the current event intersect with the group?\n     *\n     * @param {JQueryEventObject} event\n     * @param {GroupPositionCache} groupPosition\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.eventIntersectsGroup = function eventIntersectsGroup(event, groupPosition) {\n      return event.pageY > groupPosition.top && event.pageY < groupPosition.top + groupPosition.outerHeight && event.pageX > groupPosition.left && event.pageX < groupPosition.left + groupPosition.outerWidth;\n    }\n    /**\n     * Cache the groups positions\n     *\n     * @param {JQuery} group\n     * @returns {GroupPositionCache}\n     */\n    ;\n\n    _proto.getGroupPosition = function getGroupPosition(group) {\n      if (!this.groupPositionCache) {\n        this.groupPositionCache = {\n          top: group.offset().top,\n          left: group.offset().left,\n          width: group.width(),\n          height: group.height(),\n          outerWidth: group.outerWidth(),\n          outerHeight: group.outerHeight()\n        };\n      }\n\n      return this.groupPositionCache;\n    }\n    /**\n     * Record the resizing history for this action\n     *\n     * @param {string} usedHistory\n     * @param {string} direction\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     * @param {string} modifyColumnInPair\n     */\n    ;\n\n    _proto.recordResizeHistory = function recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair) {\n      if (usedHistory) {\n        this.resizeHistory[usedHistory].pop();\n      }\n\n      this.resizeHistory[direction].push({\n        adjustedColumn: adjustedColumn,\n        modifyColumnInPair: modifyColumnInPair\n      });\n    }\n    /**\n     * Handle the resizing on mouse move, we always resize a pair of columns at once\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onResizingMouseMove = function onResizingMouseMove(event, group, groupPosition) {\n      var _this11 = this;\n\n      var newColumnWidth;\n\n      if (this.resizeMouseDown) {\n        event.preventDefault();\n        var currentPos = event.pageX;\n        var resizeColumnLeft = this.resizeColumnInstance.preview.element.offset().left;\n        var resizeColumnWidth = this.resizeColumnInstance.preview.element.outerWidth();\n        var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n        var direction = currentPos >= resizeHandlePosition ? \"right\" : \"left\";\n        var adjustedColumn;\n        var modifyColumnInPair; // We need to know if we're modifying the left or right column in the pair\n\n        var usedHistory; // Was the adjusted column pulled from history?\n        // Determine which column in the group should be adjusted for this action\n\n        var _this$resizeUtils$det = this.resizeUtils.determineAdjustedColumn(currentPos, this.resizeColumnInstance, this.resizeHistory);\n\n        adjustedColumn = _this$resizeUtils$det[0];\n        modifyColumnInPair = _this$resizeUtils$det[1];\n        usedHistory = _this$resizeUtils$det[2];\n        // Calculate the ghost width based on mouse position and bounds of allowed sizes\n        var ghostWidth = this.resizeUtils.calculateGhostWidth(groupPosition, currentPos, this.resizeColumnInstance, modifyColumnInPair, this.resizeMaxGhostWidth);\n        this.resizeGhost.width(ghostWidth - 15 + \"px\").addClass(\"active\");\n\n        if (adjustedColumn && this.resizeColumnWidths) {\n          newColumnWidth = this.resizeColumnWidths.find(function (val) {\n            return (0, _resize.comparator)(currentPos, val.position, 35) && val.forColumn === modifyColumnInPair;\n          });\n\n          if (newColumnWidth) {\n            var mainColumn = this.resizeColumnInstance; // If we're using the left data set, we're actually resizing the right column of the group\n\n            if (modifyColumnInPair === \"right\") {\n              mainColumn = (0, _resize.getAdjacentColumn)(this.resizeColumnInstance, \"+1\");\n            } // Ensure we aren't resizing multiple times, also validate the last resize isn't the same as the\n            // one being performed now. This occurs as we re-calculate the column positions on resize, we have\n            // to use the comparator as the calculation may result in slightly different numbers due to rounding\n\n\n            if (this.resizeUtils.getColumnWidth(mainColumn) !== newColumnWidth.width && !(0, _resize.comparator)(this.resizeLastPosition, newColumnWidth.position, 10)) {\n              // If our previous action was to resize the right column in pair, and we're now dragging back\n              // to the right, but have matched a column for the left we need to fix the columns being\n              // affected\n              if (usedHistory && this.resizeLastColumnInPair === \"right\" && direction === \"right\" && newColumnWidth.forColumn === \"left\") {\n                var originalMainColumn = mainColumn;\n                mainColumn = adjustedColumn;\n                adjustedColumn = (0, _resize.getAdjacentColumn)(originalMainColumn, \"+1\");\n              }\n\n              this.recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair);\n              this.resizeLastPosition = newColumnWidth.position;\n              this.resizeLastColumnInPair = modifyColumnInPair; // Ensure the adjusted column is marked as resizing to animate correctly\n\n              this.setColumnsAsResizing(mainColumn, adjustedColumn);\n              this.onColumnResize(mainColumn, newColumnWidth.width, adjustedColumn); // Wait for the render cycle to finish from the above resize before re-calculating\n\n              _underscore.defer(function () {\n                // If we do a resize, re-calculate the column widths\n                _this11.resizeColumnWidths = _this11.resizeUtils.determineColumnWidths(_this11.resizeColumnInstance, groupPosition);\n                _this11.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this11.resizeColumnWidths);\n              });\n            }\n          }\n        }\n      }\n    }\n    /**\n     * Handle a column being dragged around the group\n     * @deprecated - this is now handled in column-line/preview onDraggingMouseMove\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onDraggingMouseMove = function onDraggingMouseMove(event, group, groupPosition) {\n      var dragColumn = (0, _registry2.getDragColumn)();\n\n      if (dragColumn) {\n        // If the drop positions haven't been calculated for this group do so now\n        if (this.dropPositions.length === 0) {\n          this.dropPositions = (0, _dragAndDrop.calculateDropPositions)(this.contentType);\n        }\n\n        var columnInstance = dragColumn;\n        var currentX = event.pageX - groupPosition.left; // Are we within the same column group or have we ended up over another?\n\n        if (columnInstance.parentContentType === this.contentType && this.startDragEvent) {\n          var dragDirection = event.pageX <= this.startDragEvent.pageX ? \"left\" : \"right\";\n          var adjacentLeftColumn = (0, _resize.getAdjacentColumn)(dragColumn, \"-1\"); // Determine the current move position based on the cursors position and direction of drag\n\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX < position.right && position.placement === dragDirection && position.affectedColumn !== dragColumn;\n          }); // Differences in the element & event positions cause a right movement to activate on the left column\n\n          if (this.movePosition && dragDirection === \"right\" && this.movePosition.affectedColumn === adjacentLeftColumn) {\n            this.movePosition = null;\n          }\n\n          if (this.movePosition) {\n            this.movePlaceholder.css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? groupPosition.width - this.movePosition.right : \"\",\n              width: dragColumn.preview.element.outerWidth() + \"px\"\n            }).addClass(\"active\");\n          } else {\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        } else {\n          // If we're moving to another column group we utilise the existing drop placeholder\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX <= position.right && position.canShrink;\n          });\n\n          if (this.movePosition) {\n            var classToRemove = this.movePosition.placement === \"left\" ? \"right\" : \"left\";\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        }\n      }\n    }\n    /**\n     * Handle mouse move events on when dropping elements\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     * @deprecated now handled in column-line/preview\n     */\n    ;\n\n    _proto.onDroppingMouseMove = function onDroppingMouseMove(event, group, groupPosition) {\n      var elementChildrenParent = group.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.dropOverElement && event.pageY > groupPosition.top + 20 && event.pageY < groupPosition.top + groupPosition.outerHeight - 20) {\n        // Disable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", true);\n        }\n\n        var currentX = event.pageX - groupPosition.left;\n        this.dropPosition = this.dropPositions.find(function (position) {\n          return currentX > position.left && currentX <= position.right && position.canShrink;\n        });\n      } else if (this.dropOverElement) {\n        // Re-enable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", false);\n        }\n\n        this.dropPosition = null;\n      }\n    }\n    /**\n     * Init the droppable functionality for new columns\n     *\n     * @param {JQuery} group\n     */\n    ;\n\n    _proto.initDroppable = function initDroppable(group) {\n      var self = this;\n      var headStyles;\n      group.droppable({\n        deactivate: function deactivate() {\n          self.dropOverElement = null;\n\n          _underscore.defer(function () {\n            // Re-enable the column group sortable instance & all children sortable instances\n            group.parents(\".element-children\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n              }\n            });\n          });\n        },\n        activate: function activate() {\n          if ((0, _registry.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            var _ref;\n\n            group.find(\".ui-sortable\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", true);\n              }\n            });\n            var classes = [\".pagebuilder-content-type.pagebuilder-column .pagebuilder-drop-indicator\", \".pagebuilder-content-type.pagebuilder-column .empty-container .content-type-container:before\"]; // Ensure we don't display any drop indicators inside the column\n\n            headStyles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classes.join(\", \")] = {\n              display: \"none!important\"\n            }, _ref));\n            document.head.appendChild(headStyles);\n          } else if (headStyles) {\n            headStyles.remove();\n            headStyles = null;\n          }\n        },\n        drop: function drop() {\n          self.dropPositions = [];\n        },\n        out: function out() {\n          self.dropOverElement = null;\n        },\n        over: function over() {\n          // Is the element currently being dragged a column group?\n          if ((0, _registry.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            // Always calculate drop positions when an element is dragged over\n            self.dropOverElement = true;\n          } else {\n            self.dropOverElement = null;\n          }\n        }\n      });\n    }\n    /**\n     * Spread any empty space across the other columns when a column is removed\n     *\n     * @param {number} removedIndex\n     */\n    ;\n\n    _proto.spreadWidth = function spreadWidth(removedIndex) {\n      if (this.contentType.children().length === 0) {\n        return;\n      }\n\n      var availableWidth = 100 - this.resizeUtils.getColumnsWidth();\n      var formattedAvailableWidth = (0, _resize.getRoundedColumnWidth)(availableWidth);\n      var totalChildColumns = this.contentType.children().length;\n      var allowedColumnWidths = [];\n      var spreadAcross = 1;\n      var spreadAmount;\n\n      for (var i = this.resizeUtils.getGridSize(); i > 0; i--) {\n        allowedColumnWidths.push((0, _resize.getRoundedColumnWidth)(100 / this.resizeUtils.getGridSize() * i));\n      } // Determine how we can spread the empty space across the columns\n\n\n      for (var _i = totalChildColumns; _i > 0; _i--) {\n        var potentialWidth = Math.floor(formattedAvailableWidth / _i);\n\n        for (var _iterator2 = _createForOfIteratorHelperLoose(allowedColumnWidths), _step2; !(_step2 = _iterator2()).done;) {\n          var width = _step2.value;\n\n          if (potentialWidth === Math.floor(width)) {\n            spreadAcross = _i;\n            spreadAmount = formattedAvailableWidth / _i;\n            break;\n          }\n        }\n\n        if (spreadAmount) {\n          break;\n        }\n      } // Let's spread the width across the columns\n\n\n      for (var _i2 = 1; _i2 <= spreadAcross; _i2++) {\n        var columnToModify = void 0; // As the original column has been removed from the array, check the new index for a column\n\n        if (removedIndex <= this.contentType.children().length && typeof this.contentType.children()[removedIndex] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex];\n        }\n\n        if (!columnToModify && removedIndex - _i2 >= 0 && typeof this.contentType.children()[removedIndex - _i2] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex - _i2];\n        }\n\n        if (columnToModify) {\n          (0, _resize.updateColumnWidth)(columnToModify, this.resizeUtils.getColumnWidth(columnToModify) + spreadAmount);\n        }\n      }\n    }\n    /**\n     * Remove self if we contain no children\n     */\n    ;\n\n    _proto.removeIfEmpty = function removeIfEmpty() {\n      if (this.contentType.children().length === 0) {\n        this.contentType.parentContentType.removeChild(this.contentType);\n        return;\n      }\n    }\n    /**\n     * Record the grid resize operation into a history for later restoration\n     *\n     * @param {number} newGridSize\n     */\n    ;\n\n    _proto.recordGridResize = function recordGridResize(newGridSize) {\n      var _this12 = this;\n\n      // @todo evaluate utility of having a grid size history\n      return;\n\n      if (!this.gridSizeHistory.has(newGridSize)) {\n        var columnWidths = [];\n        this.contentType.getChildren()().forEach(function (column) {\n          columnWidths.push(_this12.resizeUtils.getColumnWidth(column));\n        });\n        this.gridSizeHistory.set(newGridSize, columnWidths);\n      }\n    }\n    /**\n     * Figure out the maximum number of non-empty columns in various column lines\n     * @private\n     */\n    ;\n\n    _proto.getNonEmptyColumnCount = function getNonEmptyColumnCount() {\n      var nonEmptyColumnCount = 0;\n      this.contentType.getChildren()().forEach(function (columnLine, index) {\n        var numEmptyColumns = 0;\n        var numCols = columnLine.getChildren()().length;\n        columnLine.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            numEmptyColumns++;\n          }\n        });\n\n        if (numCols - numEmptyColumns > nonEmptyColumnCount) {\n          nonEmptyColumnCount = numCols - numEmptyColumns;\n        }\n      });\n      return nonEmptyColumnCount;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column-group/grid-size.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _wrapNativeSuper(Class) { var _cache = typeof Map === \"function\" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== \"function\") { throw new TypeError(\"Super expression must either be null or a function\"); } if (typeof _cache !== \"undefined\") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }\n\nfunction _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _isNativeFunction(fn) { return Function.toString.call(fn).indexOf(\"[native code]\") !== -1; }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"mage/translate\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/column/resize\"], function (_translate, _config, _resize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Retrieve default  grid size\n   *\n   * @returns {number}\n   */\n  function getDefaultGridSize() {\n    return parseInt(_config.getConfig(\"column_grid_default\"), 10);\n  }\n  /**\n   * Retrieve the max grid size\n   *\n   * @returns {number}\n   */\n\n\n  function getMaxGridSize() {\n    return parseInt(_config.getConfig(\"column_grid_max\"), 10);\n  }\n  /**\n   * Apply the new grid size, adjusting the existing columns as needed.\n   *\n   * Rules for resizing the grid:\n   *  - The grid size can be increased up to the configured maximum value.\n   *  - The grid size can be decreased only if the number of non-empty columns is less than or equal to the new size.\n   *  - If the new grid size is less than the number of columns currently in the grid, empty columns will be deleted\n   *    to accommodate the new size.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   * @param {Map<number, number[]>} gridSizeHistory\n   */\n\n\n  function resizeGrid(columnGroup, newGridSize, gridSizeHistory) {\n    if (newGridSize === columnGroup.preview.getResizeUtils().getInitialGridSize()) {\n      return;\n    }\n\n    validateNewGridSize(columnGroup, newGridSize);\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      // if we have more columns than the new grid size allows, remove empty columns till the correct size\n      console.log(columnLine.getChildren()().length);\n\n      if (newGridSize < columnLine.getChildren()().length) {\n        removeEmptyColumnsToFit(columnLine, newGridSize);\n      }\n    }); // update column widths\n\n    redistributeColumnWidths(columnGroup, newGridSize, gridSizeHistory);\n  }\n  /**\n   * Validate that the new grid size is within the configured limits and can be achieved.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function validateNewGridSize(columnGroup, newGridSize) {\n    // Validate against the max grid size\n    if (newGridSize > getMaxGridSize()) {\n      throw new GridSizeError((0, _translate)(\"The maximum grid size supported is \" + getMaxGridSize() + \".\"));\n    } else if (newGridSize < 2) {\n      throw new GridSizeError((0, _translate)(\"The minimum grid size supported is 2.\"));\n    } // Validate that the operation will be successful\n\n\n    var doThrowException = false;\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      var numEmptyColumns = 0;\n      var numCols = columnLine.getChildren()().length;\n      var currentGridSize = columnLine.preview.getResizeUtils().getInitialGridSize();\n\n      if (newGridSize < currentGridSize && numCols > newGridSize) {\n        columnLine.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            numEmptyColumns++;\n          }\n        });\n\n        if (newGridSize < numCols - numEmptyColumns) {\n          doThrowException = true;\n        }\n      }\n    });\n\n    if (doThrowException) {\n      throw new Error((0, _translate)(\"Grid size cannot be smaller than the current total amount of columns, minus any empty columns.\"));\n    }\n  }\n  /**\n   * Remove empty columns so we can accommodate the new grid size\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function removeEmptyColumnsToFit(columnLine, newGridSize) {\n    var columns = columnLine.getChildren()();\n    var numColumns = columns.length;\n    var i;\n\n    for (i = numColumns - 1; i >= 0; i--) {\n      var column = columns[i];\n\n      if (newGridSize < numColumns && column.getChildren()().length === 0) {\n        columnLine.removeChild(column);\n        numColumns--;\n      }\n    }\n  }\n  /**\n   * Adjust columns widths across the new grid size, making sure each column is at least one grid size in width\n   * and the entire grid size is distributed.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   * @param {Map<number, number[]>} gridSizeHistory\n   */\n\n\n  function redistributeColumnWidths(columnGroup, newGridSize, gridSizeHistory) {\n    // apply known column widths if we have resized before\n    if (gridSizeHistory.has(newGridSize) && gridSizeHistory.get(newGridSize).length === columnGroup.getChildren()().length) {\n      var columnWidths = gridSizeHistory.get(newGridSize);\n      columnGroup.getChildren()().forEach(function (column, index) {\n        (0, _resize.updateColumnWidth)(column, columnWidths[index]);\n      });\n      columnGroup.dataStore.set(\"grid_size\", newGridSize);\n      columnGroup.dataStore.unset(\"initial_grid_size\");\n      return;\n    }\n\n    var columnGroupResizeUtil = columnGroup.preview.getResizeUtils();\n    var existingGridSize = columnGroupResizeUtil.getInitialGridSize();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    columnGroup.getChildren()().forEach(function (columnLine, columnLineIndex) {\n      var totalNewWidths = 0;\n      var remainingWidth = 0;\n      var numColumns = columnLine.getChildren()().length;\n      var resizeUtils = columnLine.preview.getResizeUtils();\n      columnLine.getChildren()().forEach(function (column, index) {\n        var existingWidth = resizeUtils.getColumnWidth(column);\n        var fractionColumnWidth = Math.round(existingWidth / (100 / existingGridSize));\n        /**\n         * Determine if the grid & column are directly compatible with the new defined grid size, this will\n         * directly convert fractions to their equivalent of the new grid size.\n         *\n         * For instance changing a 12 column grid with 2 x 6 / 12 columns to a 6 grid is fully compatible.\n         *\n         * Check the existing grid size and new grid size are divisible, verify the amount of columns will fit\n         * in the new grid size and finally check the calculation to convert the existing column width results\n         * in a positive integer.\n         */\n\n        if ((existingGridSize > newGridSize && existingGridSize % newGridSize === 0 || existingGridSize < newGridSize && newGridSize % existingGridSize === 0) && newGridSize % numColumns === 0 && newGridSize / existingGridSize * fractionColumnWidth % 1 === 0) {\n          // We don't need to modify the columns width as it's compatible, we will however increment the\n          // width counter as some other columns may not be compatible.\n          totalNewWidths += existingWidth;\n        } else {\n          var newWidth = (100 * Math.floor(existingWidth / 100 * newGridSize) / newGridSize).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0); // make sure the column is at least one grid size wide\n\n          if (parseFloat(newWidth) < parseFloat(minColWidth)) {\n            newWidth = minColWidth;\n          } // make sure we leave enough space for other columns\n\n\n          var widthTaken = totalNewWidths + (numColumns - index - 1) * parseFloat(minColWidth);\n          var maxAvailableWidth = 100 - totalNewWidths;\n\n          if (parseFloat(newWidth) > maxAvailableWidth) {\n            var gridWidth = Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0;\n            newWidth = maxAvailableWidth.toFixed(gridWidth);\n          } // Calculate any width lost from the column, if a 5 / 12 is becoming a 2 / 6 then it's lost 1 / 12\n\n\n          remainingWidth += existingWidth - parseFloat(newWidth);\n          /**\n           * Determine if we have enough remaining width, and apply it to the current column, this results in\n           * a subsequent column always receiving any additional width from the previous column\n           */\n\n          if (resizeUtils.getSmallestColumnWidth(newGridSize) === resizeUtils.getAcceptedColumnWidth(remainingWidth.toString(), newGridSize)) {\n            var widthWithRemaining = resizeUtils.getAcceptedColumnWidth((parseFloat(newWidth) + remainingWidth).toString(), newGridSize);\n\n            if (widthWithRemaining > 0) {\n              newWidth = widthWithRemaining.toFixed(Math.round(100 / widthWithRemaining) !== 100 / widthWithRemaining ? 8 : 0);\n              remainingWidth = 0;\n            }\n          }\n\n          totalNewWidths += parseFloat(newWidth);\n          (0, _resize.updateColumnWidth)(column, parseFloat(newWidth));\n        }\n\n        column.preview.updateDisplayLabel();\n      });\n    });\n    columnGroup.dataStore.set(\"grid_size\", newGridSize);\n    columnGroup.dataStore.unset(\"initial_grid_size\");\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      var resizeUtils = columnLine.preview.getResizeUtils();\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        applyLeftoverColumnsInColumnLine(columnLine, newGridSize);\n      }\n    });\n  }\n  /**\n   * Make sure the full grid size is distributed across the columns\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function applyLeftoverColumns(columnGroup, newGridSize) {\n    var resizeUtils = columnGroup.preview.getResizeUtils();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    var column;\n\n    for (var _iterator = _createForOfIteratorHelperLoose(columnGroup.getChildren()()), _step; !(_step = _iterator()).done;) {\n      column = _step.value;\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        (0, _resize.updateColumnWidth)(column, parseFloat(resizeUtils.getColumnWidth(column).toString()) + parseFloat(minColWidth));\n      } else {\n        break;\n      }\n    }\n  }\n  /**\n   * Make sure the full grid size is distributed across the columns\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function applyLeftoverColumnsInColumnLine(columnLine, newGridSize) {\n    var resizeUtils = columnLine.preview.getResizeUtils();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    var column;\n\n    for (var _iterator2 = _createForOfIteratorHelperLoose(columnLine.getChildren()()), _step2; !(_step2 = _iterator2()).done;) {\n      column = _step2.value;\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        (0, _resize.updateColumnWidth)(column, parseFloat(resizeUtils.getColumnWidth(column).toString()) + parseFloat(minColWidth));\n      } else {\n        break;\n      }\n    }\n  }\n\n  var GridSizeError = /*#__PURE__*/function (_Error) {\n    \"use strict\";\n\n    _inheritsLoose(GridSizeError, _Error);\n\n    function GridSizeError(m) {\n      var _this;\n\n      _this = _Error.call(this, m) || this;\n      Object.setPrototypeOf(_assertThisInitialized(_this), GridSizeError.prototype);\n      return _this;\n    }\n\n    return GridSizeError;\n  }( /*#__PURE__*/_wrapNativeSuper(Error));\n\n  return {\n    getDefaultGridSize: getDefaultGridSize,\n    getMaxGridSize: getMaxGridSize,\n    resizeGrid: resizeGrid,\n    GridSizeError: GridSizeError\n  };\n});\n//# sourceMappingURL=grid-size.js.map","Magento_PageBuilder/js/content-type/map/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/utils/map\", \"module\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_knockout, _events, _map, _module, _hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.apiKeyValid = _knockout.observable(!!_module.config().apiKey);\n      _this.apiKeyErrorMessage = _module.config().apiKeyErrorMessage;\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Open edit menu on map content type drop with a delay of 300ms\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _preview2.prototype.bindEvents.call(this); // When the map api key fails, empties out the content type and adds the placeholder\n\n\n      _events.on(\"googleMaps:authFailure\", function () {\n        _this2.apiKeyValid(false);\n      });\n    }\n    /**\n     * Renders the map and subscribe to position for updates\n     *\n     * @param {Element} element\n     * @returns {void}\n     */\n    ;\n\n    _proto.renderMap = function renderMap(element) {\n      var _this3 = this;\n\n      if (!this.apiKeyValid()) {\n        return;\n      }\n\n      this.generateMap(element);\n      this.element = element;\n\n      if (this.mapElement && this.mapElement.map) {\n        this.data.main.attributes.subscribe(function () {\n          _this3.updateMap();\n        });\n      }\n    }\n    /**\n     * Generate maps\n     *\n     * @param {Element} element\n     * @returns {void}\n     */\n    ;\n\n    _proto.generateMap = function generateMap(element) {\n      var currentLocations = this.data.main.attributes()[\"data-locations\"] || \"[]\";\n      var controls = this.data.main.attributes()[\"data-show-controls\"] || \"true\";\n      var locations = [];\n      var options = {\n        disableDefaultUI: controls !== \"true\",\n        mapTypeControl: controls === \"true\"\n      };\n\n      if (currentLocations !== \"[]\") {\n        var mapData = this.getMapData();\n        locations = mapData.locations;\n        options = mapData.options;\n      }\n\n      this.mapElement = new _map(element, locations, options);\n    }\n    /**\n     * Updates map\n     *\n     * @returns {void}\n     */\n    ;\n\n    _proto.updateMap = function updateMap() {\n      var mapData = this.getMapData();\n      this.mapElement.onUpdate(mapData.locations, mapData.options);\n    }\n    /**\n     * Get locations, center coordinates, and zoom from data.position\n     *\n     * @returns {Object}\n     */\n    ;\n\n    _proto.getMapData = function getMapData() {\n      var attributes = this.data.main.attributes();\n      var controls = attributes[\"data-show-controls\"];\n      var options = {\n        disableDefaultUI: controls !== \"true\",\n        mapTypeControl: controls === \"true\"\n      };\n      var locations = attributes[\"data-locations\"];\n\n      if (locations !== \"\" && typeof locations === \"string\") {\n        locations = JSON.parse(locations);\n      }\n\n      locations.forEach(function (location) {\n        location.position.latitude = parseFloat(location.position.latitude);\n        location.position.longitude = parseFloat(location.position.longitude);\n      });\n      return {\n        locations: locations,\n        options: options\n      };\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/map/converter/attribute/locations.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Locations = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Locations() {}\n\n    var _proto = Locations.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value && value !== \"\") {\n        return JSON.parse(value);\n      }\n\n      return [];\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var content = (0, _object.get)(data, name);\n\n      if (_underscore.isString(content) && content !== \"\") {\n        content = JSON.parse(content);\n      }\n\n      if (content && Object.keys(content).length) {\n        content.forEach(function (marker) {\n          if (marker.position) {\n            marker.position.latitude = parseFloat(marker.position.latitude);\n            marker.position.longitude = parseFloat(marker.position.longitude);\n          }\n        });\n        return JSON.stringify(content);\n      }\n\n      return JSON.stringify([]);\n    };\n\n    return Locations;\n  }();\n\n  return Locations;\n});\n//# sourceMappingURL=locations.js.map","Magento_PageBuilder/js/content-type/map/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/utils/map'\n], function ($, GoogleMap) {\n    'use strict';\n\n    return function (config, element) {\n        var locations,\n            controls,\n            mapOptions = {};\n\n        element = element[0];\n\n        if (element !== undefined && element.hasAttribute('data-locations')) {\n\n            /**\n             * Set map display to none if no locations\n             */\n            if (element.getAttribute('data-locations') === '[]') {\n                $(element).hide();\n\n                return;\n            }\n            locations = JSON.parse(element.getAttribute('data-locations'));\n            locations.forEach(function (location) {\n                location.position.latitude = parseFloat(location.position.latitude);\n                location.position.longitude = parseFloat(location.position.longitude);\n            });\n            controls = element.getAttribute('data-show-controls');\n            mapOptions.disableDefaultUI = controls !== 'true';\n            mapOptions.mapTypeControl = controls === 'true';\n            new GoogleMap(element, locations, mapOptions);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/divider/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/button-item/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _conditionalRemoveOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Use the conditional remove to disable the option when the parent has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      delete options.title;\n      delete options.move;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    }\n    /**\n     * Force the focus on the clicked button\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onClick = function onClick(index, event) {\n      (0, _jquery)(event.currentTarget).find(\"[contenteditable]\").focus();\n      event.stopPropagation();\n    }\n    /**\n     * Handle on focus out events, when the button item is focused out we need to set our focusedButton record on the\n     * buttons preview item to null. If we detect this focus out event is to focus into another button we need to ensure\n     * we update the record appropriately.\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(index, event) {\n      if (this.contentType && this.contentType.parentContentType) {\n        var parentPreview = this.contentType.parentContentType.preview;\n\n        var unfocus = function unfocus() {\n          window.getSelection().removeAllRanges();\n          parentPreview.focusedButton(null);\n        };\n\n        if (event.relatedTarget && _jquery.contains(parentPreview.wrapperElement, event.relatedTarget)) {\n          // Verify the focus was not onto the options menu\n          if ((0, _jquery)(event.relatedTarget).closest(\".pagebuilder-options\").length > 0) {\n            unfocus();\n          } else {\n            // Have we moved the focus onto another button in the current group?\n            var buttonItem = _knockout.dataFor(event.relatedTarget);\n\n            if (buttonItem && buttonItem.contentType && buttonItem.contentType.parentContentType && buttonItem.contentType.parentContentType.id === this.contentType.parentContentType.id) {\n              var newIndex = buttonItem.contentType.parentContentType.children().indexOf(buttonItem.contentType);\n              parentPreview.focusedButton(newIndex);\n            } else {\n              unfocus();\n            }\n          }\n        } else if (parentPreview.focusedButton() === index) {\n          unfocus();\n        }\n      }\n    }\n    /**\n     * On focus in set the focused button\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(index, event) {\n      var parentPreview = this.contentType.parentContentType.preview;\n\n      if (parentPreview.focusedButton() !== index) {\n        parentPreview.focusedButton(index);\n      }\n    }\n    /**\n     * If the button is displayed we need to show the options menu on hover\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onButtonMouseOver = function onButtonMouseOver(context, event) {\n      if (this.display() === false) {\n        this.onMouseOver(context, event);\n      }\n    }\n    /**\n     * If the button is displayed we need to hide the options menu on mouse out\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onButtonMouseOut = function onButtonMouseOut(context, event) {\n      if (this.display() === false) {\n        this.onMouseOut(context, event);\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/button-item/converter/style/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be inline block\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"inline-block\";\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/content-type/text/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _events, _underscore, _hideShowOption, _delayUntil, _editor, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.afterRenderDeferred = _jquery.Deferred();\n      _this.handledDoubleClick = false;\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * @returns {Boolean}\n     */\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.main.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.main.html();\n        }\n      }, \"content\");\n      this.afterRenderDeferred.resolve(element);\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(true);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this3 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function () {\n          _underscore.defer(function () {\n            _this3.element.blur();\n\n            _this3.element.focus();\n          });\n        };\n      }\n\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"content\", this.contentType.stageId).then(function (wysiwyg) {\n        _this3.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this4 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this4.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this4.handledDoubleClick = true;\n\n              _this4.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this4.element);\n            }, function () {\n              return _this4.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this5 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this5.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Handle \"mousedown\" event\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.handleMouseDown = function handleMouseDown(preview, event) {\n      var _this6 = this;\n\n      var handleMouseUp = function handleMouseUp(mouseUpEvent) {\n        if (_this6.element && !_this6.wysiwyg && document.activeElement === _this6.element // Check that mouseup occurred outside the element, otherwise \"click\" event will be triggerred in which\n        // case we don't need to do anything as the \"click\" event is handled in \"activateEditor\"\n        // Note: click is fired after a full click action occurs; that is, the mouse button is pressed\n        // and released while the pointer remains inside the same element.\n        && _this6.element !== mouseUpEvent.target && !_jquery.contains(_this6.element, mouseUpEvent.target)) {\n          _this6.activateEditor(_this6, mouseUpEvent);\n        }\n\n        (0, _jquery)(document).off(\"mouseup\", handleMouseUp);\n        return true;\n      };\n\n      event.stopPropagation();\n\n      if (this.element && !this.wysiwyg) {\n        (0, _jquery)(document).on(\"mouseup\", handleMouseUp);\n      }\n\n      return true;\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this7 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"content\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this7.textarea.value = _this7.contentType.dataStore.get(\"content\");\n\n        _this7.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"content\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Retrieve the margin & padding & alignment styles for the placeholder\n     *\n     * @returns {any}\n     */\n    ;\n\n    _proto.getPlaceholderStyle = function getPlaceholderStyle() {\n      var keys = [\"marginBottom\", \"marginLeft\", \"marginRight\", \"marginTop\", \"paddingBottom\", \"paddingLeft\", \"paddingRight\", \"paddingTop\", \"textAlign\"];\n      return _underscore.pick(this.data.main.style(), function (style, key) {\n        return keys.indexOf(key) !== -1;\n      });\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      this.contentType.dataStore.subscribe(function (state) {\n        var sanitizedContent = (0, _editor.removeReservedHtmlAttributes)((0, _editor.replaceDoubleQuoteWithSingleQuoteWithinVariableDirective)((0, _editor.escapeDoubleQuoteWithinWidgetDirective)(state.content)));\n\n        if (sanitizedContent !== state.content) {\n          state.content = sanitizedContent;\n        }\n      }, \"content\");\n\n      _preview2.prototype.bindEvents.call(this); // After drop of new content type open TinyMCE and focus\n\n\n      _events.on(\"text:dropAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.afterRenderDeferred.then(function () {\n            if (_this8.isWysiwygSupported()) {\n              _this8.initWysiwygFromClick(true);\n            }\n          });\n        }\n      });\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/text/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\"], function (_jquery, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {}\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * The editor element\n     */\n\n    /**\n     * The configuration of the wysiwyg content type\n     */\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n    }\n    /**\n     * Called when tinymce is focused\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this = this;\n\n      // If there isn't enough room for a left-aligned toolbar, right align it\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this.$element.closest(selector).css(\"z-index\", 100);\n      });\n    }\n    /**\n     * Called when tinymce is blurred\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this2 = this;\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this2.$element.closest(selector).css(\"z-index\", \"\");\n      });\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/text/wysiwyg/tinymce/config-modifier.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConfigModifier = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConfigModifier() {}\n\n    var _proto = ConfigModifier.prototype;\n\n    /**\n     * Initialize the config\n     *\n     * @param {String} contentTypeId\n     * @param {Object} config\n     */\n    _proto.modify = function modify(contentTypeId, config) {\n      if (config.adapter_config.mode === \"inline\") {\n        config.adapter.settings.fixed_toolbar_container = \"#\" + contentTypeId + \" \" + config.adapter.settings.fixed_toolbar_container;\n      }\n    };\n\n    return ConfigModifier;\n  }();\n\n  return ConfigModifier;\n});\n//# sourceMappingURL=config-modifier.js.map","Magento_PageBuilder/js/content-type/banner/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"jquery/z-index\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/nesting-link-dialog\", \"Magento_PageBuilder/js/utils/nesting-widget-dialog\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jarallax, _jarallaxVideo, _jquery, _zIndex, _translate, _events, _mageUtils, _underscore, _vimeoWrapper, _hideShowOption, _uploader, _delayUntil, _editor, _nestingLinkDialog, _nestingWidgetDialog, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.handledDoubleClick = false;\n      _this.videoUpdateProperties = [\"background_type\", \"video_fallback_image\", \"video_lazy_load\", \"video_loop\", \"video_play_only_visible\", \"video_source\"];\n      _this.bannerOverlaySelector = \".pagebuilder-overlay\";\n      _this.defaultOverlayZIndex = 2;\n      _this.activeEditorOverlayZIndex = 3;\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.wrapper, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.wrapper && _this.wrapper.dataset.backgroundType === \"video\" && _this.wrapper.dataset.videoSrc.length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            jarallax(_this.wrapper, {\n              videoSrc: _this.wrapper.dataset.videoSrc,\n              imgSrc: _this.wrapper.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: 1,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.wrapper.jarallax && _this.wrapper.jarallax.video) {\n              // @ts-ignore\n              _this.wrapper.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.wrapper.jarallax && _this.wrapper.jarallax.$video) {\n                  // @ts-ignore\n                  _this.wrapper.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\"); // Create uploader\n\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.content.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.content.html();\n        }\n      }, \"message\");\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(false);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this3 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function (editor) {\n          editor.on(\"focus\", function () {\n            (0, _jquery)(_this3.element).parents(_this3.bannerOverlaySelector).zIndex(_this3.activeEditorOverlayZIndex);\n          });\n          editor.on(\"blur\", function () {\n            (0, _jquery)(_this3.element).parents(_this3.bannerOverlaySelector).zIndex(_this3.defaultOverlayZIndex);\n            (0, _nestingLinkDialog)(_this3.contentType.dataStore, _this3.wysiwyg, \"message\", \"link_url\");\n            (0, _nestingWidgetDialog)(_this3.contentType.dataStore, _this3.wysiwyg, \"message\", \"link_url\");\n          });\n\n          _underscore.defer(function () {\n            _this3.element.blur();\n\n            _this3.element.focus();\n          });\n        };\n      }\n\n      wysiwygConfig.adapter.settings.fixed_toolbar_container = \"#\" + this.contentType.id + \" .pagebuilder-banner-text-content\";\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"message\", this.contentType.stageId).then(function (wysiwyg) {\n        _this3.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this4 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this4.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this4.handledDoubleClick = true;\n\n              _this4.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this4.element);\n            }, function () {\n              return _this4.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      } else if (this.element && this.wysiwyg) {\n        var element = this.element || this.textarea;\n\n        if (event.currentTarget !== event.target && event.target !== element && !element.contains(event.target)) {\n          return;\n        }\n\n        element.focus();\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this5 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this5.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Set state based on overlay mouseover event for the preview\n     */\n    ;\n\n    _proto.onMouseOverWrapper = function onMouseOverWrapper() {\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.attributes(Object.assign(this.data.overlay.attributes(), {\n          \"data-background-color-orig\": this.data.overlay.style().backgroundColor\n        }));\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-overlay-color\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 1,\n          visibility: \"visible\"\n        }));\n      }\n    }\n    /**\n     * Set state based on overlay mouseout event for the preview\n     */\n    ;\n\n    _proto.onMouseOutWrapper = function onMouseOutWrapper() {\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-background-color-orig\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 0,\n          visibility: \"hidden\"\n        }));\n      }\n    }\n    /**\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this6 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"message\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this6.textarea.value = _this6.contentType.dataStore.get(\"message\");\n\n        _this6.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"message\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-banner-text-content\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-banner-text-content\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this7 = this;\n\n      this.wrapper = element;\n\n      _underscore.defer(function () {\n        _this7.buildJarallax();\n      });\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _preview2.prototype.destroy.call(this);\n\n      if (this.wrapper) {\n        jarallax(this.wrapper, \"destroy\");\n      }\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      this.contentType.dataStore.subscribe(function (state) {\n        var sanitizedContent = (0, _editor.removeReservedHtmlAttributes)(state.message);\n\n        if (sanitizedContent !== state.message) {\n          state.message = sanitizedContent;\n        }\n      }, \"message\");\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"banner:mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.buildJarallax();\n\n          _this8.isSnapshot.subscribe(function (value) {\n            _this8.changeUploaderControlsVisibility();\n          });\n\n          _this8.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var dataStore = _this8.contentType.dataStore.getState();\n\n        var imageObject = dataStore[_this8.config.additional_data.uploaderConfig.dataScope][0] || {}; // Resolves issue when tinyMCE injects a non-breaking space on reinitialization and removes placeholder.\n\n        if (dataStore.message === \"<div data-bind=\\\"html: data.content.html\\\">&nbsp;</div>\") {\n          _this8.contentType.dataStore.set(\"message\", \"\");\n        }\n\n        _events.trigger(\"image:\" + _this8.contentType.id + \":assignAfter\", imageObject);\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        if (this.shouldUpdateVideo(data)) {\n          this.buildJarallax();\n        }\n      }.bind(this));\n\n      _events.on(\"image:\" + this.contentType.id + \":uploadAfter\", function () {\n        _this8.contentType.dataStore.set(\"background_type\", \"image\");\n      });\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this8.buildJarallax();\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this9 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this9.isSnapshot();\n      });\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    }\n    /**\n     * Check if video options has been updated.\n     *\n     * @return boolean\n     */\n    ;\n\n    _proto.shouldUpdateVideo = function shouldUpdateVideo(state) {\n      var _this10 = this;\n\n      var previousState = this.contentType.dataStore.getPreviousState();\n\n      var diff = _mageUtils.compare(previousState, state).changes;\n\n      if (diff.length > 0) {\n        return _underscore.some(diff, function (element) {\n          if (element.name === \"video_fallback_image\") {\n            return (!_underscore.isEmpty(previousState.video_fallback_image) && previousState.video_fallback_image) !== (!_underscore.isEmpty(state.video_fallback_image) && state.video_fallback_image);\n          }\n\n          return _this10.videoUpdateProperties.indexOf(element.name) !== -1;\n        });\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/banner/converter/attribute/overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.overlay_color) {\n        return data.overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=overlay-color.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/overlay-background-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayBackgroundColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBackgroundColor() {}\n\n    var _proto = OverlayBackgroundColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (data.show_overlay === \"always\" && value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return OverlayBackgroundColor;\n  }();\n\n  return OverlayBackgroundColor;\n});\n//# sourceMappingURL=overlay-background-color.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/button-opacity.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonOpacity = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonOpacity() {}\n\n    var _proto = ButtonOpacity.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"1\" : \"0\";\n    };\n\n    return ButtonOpacity;\n  }();\n\n  return ButtonOpacity;\n});\n//# sourceMappingURL=button-opacity.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/button-visibility.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonVisibility = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonVisibility() {}\n\n    var _proto = ButtonVisibility.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"visible\" : \"hidden\";\n    };\n\n    return ButtonVisibility;\n  }();\n\n  return ButtonVisibility;\n});\n//# sourceMappingURL=button-visibility.js.map","Magento_PageBuilder/js/content-type/banner/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function (showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]');\n\n        showOnHover(config);\n\n        if (videoElement) {\n            videoBackground(config, videoElement);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/banner/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\"], function (_jquery, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {}\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * The editor element\n     */\n\n    /**\n     * The configuration of the wysiwyg content type\n     */\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n    }\n    /**\n     * Called when tinymce is focused\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this = this;\n\n      // If there isn't enough room for a left-aligned toolbar, right align it\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this.$element.closest(selector).css(\"z-index\", 100);\n      });\n    }\n    /**\n     * Called when tinymce is blurred\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this2 = this;\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this2.$element.closest(selector).css(\"z-index\", \"\");\n      });\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/block/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/widget-initializer\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _widgetInitializer, _mageUtils, _underscore, _config, _hideShowOption, _styleRegistry, _object, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * @inheritdoc\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.displayingBlockPreview = _knockout.observable(false);\n      _this.loading = _knockout.observable(false);\n      _this.messages = {\n        NOT_SELECTED: (0, _translate)(\"Empty Block\"),\n        UNKNOWN_ERROR: (0, _translate)(\"An unknown error occurred. Please try again.\")\n      };\n      _this.placeholderText = _knockout.observable(_this.messages.NOT_SELECTED);\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Runs the widget initializer for each configured widget\n     */\n    ;\n\n    _proto.initializeWidgets = function initializeWidgets(element) {\n      if (element) {\n        this.element = element;\n        (0, _widgetInitializer)({\n          config: _config.getConfig(\"widgets\"),\n          breakpoints: _config.getConfig(\"breakpoints\"),\n          currentViewport: _config.getConfig(\"viewport\")\n        }, element);\n      }\n    }\n    /**\n     * Updates the view state using the data provided\n     * @param {DataObject} data\n     */\n    ;\n\n    _proto.processBlockData = function processBlockData(data) {\n      // Only load if something changed\n      this.displayPreviewPlaceholder(data, \"block_id\");\n\n      if (data.block_id && data.template.length !== 0) {\n        this.processRequest(data, \"block_id\", \"title\");\n      }\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      _preview2.prototype.afterObservablesUpdated.call(this);\n\n      var data = this.contentType.dataStore.getState(); // Only load if something changed\n\n      this.processBlockData(data);\n    }\n    /**\n     * Display preview placeholder\n     *\n     * @param {DataObject} data\n     * @param {string} identifierName\n     */\n    ;\n\n    _proto.displayPreviewPlaceholder = function displayPreviewPlaceholder(data, identifierName) {\n      var blockId = (0, _object.get)(data, identifierName); // Only load if something changed\n\n      if (this.lastBlockId === blockId && this.lastTemplate === data.template) {\n        // The mass converter will have transformed the HTML property into a directive\n        if (this.lastRenderedHtml) {\n          this.data.main.html(this.lastRenderedHtml);\n          this.showBlockPreview(true);\n          this.initializeWidgets(this.element);\n        }\n      } else {\n        this.showBlockPreview(false);\n        this.placeholderText(\"\");\n      }\n\n      if (!blockId || blockId && blockId.toString().length === 0 || data.template.length === 0) {\n        this.showBlockPreview(false);\n        this.placeholderText(this.messages.NOT_SELECTED);\n        return;\n      }\n    }\n    /**\n     *\n     * @param {DataObject} data\n     * @param {string} identifierName\n     * @param {string} labelKey\n     */\n    ;\n\n    _proto.processRequest = function processRequest(data, identifierName, labelKey) {\n      var _this2 = this;\n\n      var url = _config.getConfig(\"preview_url\");\n\n      var identifier = (0, _object.get)(data, identifierName);\n      var requestConfig = {\n        // Prevent caching\n        method: \"POST\",\n        data: {\n          role: this.config.name,\n          block_id: identifier,\n          directive: this.data.main.html()\n        }\n      };\n      this.loading(true); // Retrieve a state object representing the block from the preview controller and process it on the stage\n\n      _jquery.ajax(url, requestConfig) // The state object will contain the block name and either html or a message why there isn't any.\n      .done(function (response) {\n        // Empty content means something bad happened in the controller that didn't trigger a 5xx\n        if (typeof response.data !== \"object\") {\n          _this2.showBlockPreview(false);\n\n          _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n\n          return;\n        } // Update the stage content type label with the real block title if provided\n\n\n        _this2.displayLabel(response.data[labelKey] ? response.data[labelKey] : _this2.config.label);\n\n        var content = \"\";\n\n        if (response.data.content) {\n          content = _this2.processContent(response.data.content);\n\n          _this2.data.main.html(content);\n\n          _this2.showBlockPreview(true);\n\n          _this2.initializeWidgets(_this2.element);\n        } else if (response.data.error) {\n          _this2.showBlockPreview(false);\n\n          _this2.placeholderText(response.data.error);\n        }\n\n        _this2.lastBlockId = parseInt(identifier.toString(), 10);\n        _this2.lastTemplate = data.template.toString();\n        _this2.lastRenderedHtml = content;\n      }).fail(function () {\n        _this2.showBlockPreview(false);\n\n        _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n      }).always(function () {\n        _this2.loading(false);\n      });\n    }\n    /**\n     * Toggle display of block preview.  If showing block preview, add hidden mode to PB preview.\n     * @param {boolean} isShow\n     */\n    ;\n\n    _proto.showBlockPreview = function showBlockPreview(isShow) {\n      this.displayingBlockPreview(isShow);\n    }\n    /**\n     * Adapt content to view it on stage.\n     *\n     * @param content\n     */\n    ;\n\n    _proto.processContent = function processContent(content) {\n      var processedContent = this.processBackgroundImages(content);\n      processedContent = this.processBreakpointStyles(processedContent);\n      return processedContent;\n    }\n    /**\n     * Generate styles for background images.\n     *\n     * @param {string} content\n     * @return string\n     */\n    ;\n\n    _proto.processBackgroundImages = function processBackgroundImages(content) {\n      var document = new DOMParser().parseFromString(content, \"text/html\");\n      var elements = document.querySelectorAll(\"[data-background-images]\");\n      var styleBlock = document.createElement(\"style\");\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      elements.forEach(function (element) {\n        var rawAttrValue = element.getAttribute(\"data-background-images\").replace(/\\\\(.)/mg, \"$1\");\n        var attrValue = JSON.parse(rawAttrValue);\n\n        var elementClass = \"background-image-\" + _mageUtils.uniqueid(13);\n\n        var rules = \"\";\n        Object.keys(attrValue).forEach(function (imageName) {\n          var imageUrl = attrValue[imageName];\n          var viewportName = imageName.replace(\"_image\", \"\");\n\n          if (viewports[viewportName].stage && imageUrl) {\n            rules += \".\" + viewportName + \"-viewport .\" + elementClass + \" {\\n                            background-image: url(\\\"\" + imageUrl + \"\\\");\\n                        }\";\n          }\n        });\n\n        if (rules.length) {\n          styleBlock.append(rules);\n          element.classList.add(elementClass);\n        }\n      });\n\n      if (elements.length && styleBlock.innerText.length) {\n        document.body.append(styleBlock);\n        content = document.head.innerHTML + document.body.innerHTML;\n      }\n\n      return content;\n    }\n    /**\n     * Replace media queries with viewport classes.\n     *\n     * @param {string} content\n     * @return string\n     */\n    ;\n\n    _proto.processBreakpointStyles = function processBreakpointStyles(content) {\n      var document = new DOMParser().parseFromString(content, \"text/html\");\n      var styleBlocks = document.querySelectorAll(\"style\");\n      var mediaStyleBlock = document.createElement(\"style\");\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      styleBlocks.forEach(function (styleBlock) {\n        var cssRules = styleBlock.sheet.cssRules;\n        Array.from(cssRules).forEach(function (rule) {\n          var mediaScope = rule instanceof CSSMediaRule && _underscore.findKey(viewports, function (viewport) {\n            return rule.conditionText === viewport.media;\n          });\n\n          if (mediaScope) {\n            Array.from(rule.cssRules).forEach(function (mediaRule, index) {\n              if (mediaRule.selectorText.indexOf(_styleRegistry.pbStyleAttribute) !== -1) {\n                var searchPattern = new RegExp(_config.getConfig(\"bodyId\") + \" \", \"g\");\n                var replaceValue = _config.getConfig(\"bodyId\") + \" .\" + mediaScope + \"-viewport \";\n                var selector = mediaRule.selectorText.replace(searchPattern, replaceValue);\n                mediaStyleBlock.append(selector + \" {\" + mediaRule.style.cssText + \"}\");\n              }\n            });\n          }\n        });\n      });\n\n      if (mediaStyleBlock.innerText.length) {\n        document.body.append(mediaStyleBlock);\n        content = document.head.innerHTML + document.body.innerHTML;\n      }\n\n      return content;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/block/mass-converter/widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Enables the settings of the content type to be stored as a widget directive.\n   *\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.template = attributes.template;\n      data.block_id = attributes.block_id;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\Cms\\\\Block\\\\Widget\\\\Block\",\n        template: data.template,\n        block_id: data.block_id,\n        type_name: \"CMS Static Block\"\n      };\n\n      if (!attributes.block_id || !attributes.template) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=widget-directive.js.map","Magento_PageBuilder/js/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/provider',\n    'Magento_PageBuilder/js/events'\n], function (Provider, events) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        initClient: function () {\n            return this;\n        },\n\n        /** @inheritdoc **/\n        save: function () {\n            events.trigger('form:' + this.id + ':saveAfter', this.get('data'));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/map-location-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/provider',\n    'Magento_PageBuilder/js/events'\n], function (Provider, events) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        initClient: function () {\n            return this;\n        },\n\n        /** @inheritdoc **/\n        save: function () {\n            events.trigger('mapLocation:saveAfter', this.get('data'));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/form-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'consoleLogger'\n], function (_, $, events, consoleLogger) {\n    'use strict';\n\n    var mixin = {\n        /**\n         * Record instances of Page Builder initialized in the forms namespace\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            if (!this.source.get('pageBuilderInstances')) {\n                this.source.set('pageBuilderInstances', []);\n            }\n\n            events.on('pagebuilder:register', function (data) {\n                var instance;\n\n                if (data.ns === self.ns) {\n                    instance = _.findWhere(self.source.get('pageBuilderInstances'), {id: data.instance.id});\n                    if (!instance) {\n                        self.source.get('pageBuilderInstances').push(data.instance);\n                    }\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Intercept save call to ensure any Page Builder rendering is completed before submitting form\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        save: function (redirect, data) {\n            var submit = this._super.bind(this, redirect, data),\n                timeout,\n                locks;\n\n            if (_.isEmpty(this.source.get('pageBuilderInstances'))) {\n                submit();\n            } else {\n                timeout = setTimeout(function () {\n                    consoleLogger.error('Page Builder was rendering for 5 seconds without releasing locks.');\n                }, 5000);\n\n                $('body').trigger('processStart');\n\n                // Wait for all rendering locks within Page Builder stages to resolve\n                $.when.apply(\n                    null,\n                    this.source.get('pageBuilderInstances').map(function (instance) {\n                        locks = instance.stage.renderingLocks;\n\n                        return locks[locks.length - 1];\n                    })\n                ).then(function () {\n                    $('body').trigger('processStop');\n                    clearTimeout(timeout);\n                    submit();\n                });\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PageBuilder/js/form/element/html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html',\n    'jquery',\n    'underscore'\n], function (Html, $, _) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            inputSelector: '[data-form-part=${ $.ns }]',\n            elements: [],\n            value: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.initInputListener();\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('value');\n        },\n\n        /**\n         * Listen for value change on each field that has been added.\n         */\n        initInputListener: function () {\n            $.async({\n                component: this,\n                selector: this.inputSelector\n            }, function (el) {\n                this.elements.push(el);\n                $(el).on('change', this.updateValue.bind(this));\n                $(el).nextAll('.rule-param-apply').on('click', function () {\n                    $(el).trigger('change');\n                });\n                $(el).closest('li').find('.rule-param-remove').on('click', function () {\n                    $(el).val('').trigger('change');\n                });\n                this.updateValue(this);\n            }.bind(this));\n        },\n\n        /**\n         * Collect data and update value.\n         */\n        updateValue: function () {\n            var result = {},\n                name;\n\n            this.elements.forEach(function (item) {\n                switch (item.type) {\n                    case 'checkbox':\n                        result[item.name] = +!!item.checked;\n                        break;\n\n                    case 'radio':\n                        if (item.checked) {\n                            result[item.name] = item.value;\n                        }\n                        break;\n\n                    case 'select-multiple':\n                        name = item.name.substring(0, item.name.length - 2); //remove [] from the name ending\n                        result[name] = _.pluck(item.selectedOptions, 'value');\n                        break;\n\n                    default:\n                        result[item.name] = item.value;\n                }\n            });\n\n            this.value(result);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/product-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'Magento_PageBuilder/js/form/provider/conditions-data-processor',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, $, $t, conditionsDataProcessor, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            conditionOption: '',\n            conditionValue: '',\n            formData: {},\n            totalProductCount: 0,\n            totalDisabledProducts: 0,\n            totalNotVisibleProducts: 0,\n            previousConditions: false,\n            listens: {\n                conditionOption: 'updateProductTotals',\n                conditionValue: 'updateProductTotals',\n                '${ $.provider }:data.modalClosed': 'abortRunningRequest'\n            },\n            imports: {\n                formData: '${ $.provider }:data'\n            },\n            links: {\n                value: false\n            },\n            url: null,\n            valuePlaceholder: $t('of %1 total'),\n            disabledPlaceholder: $t('%1 disabled'),\n            notVisiblePlaceholder: $t('%1 not visible'),\n            showSpinner: true,\n            loading: false,\n            jqXHR: null\n        },\n\n        /**\n         * Abort running Ajax request\n         */\n        abortRunningRequest: function () {\n            if (this.jqXHR && this.jqXHR.readyState !== 4) {\n                this.jqXHR.abort();\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('value totalProductCount totalDisabledProducts totalNotVisibleProducts loading');\n        },\n\n        /**\n         * If we haven't aborted the request, continue and display the error\n         *\n         * @param {Object} jqXHR\n         */\n        callSuperError: function (jqXHR) {\n            // eslint-disable-next-line jquery-no-bind-unbind\n            var superError = $.ajaxSettings.error.bind(window, jqXHR);\n\n            superError();\n        },\n\n        /**\n         * Update product count.\n         */\n        updateProductTotals: _.debounce(function () {\n            var totalText,\n                negativeTotals = [];\n\n            if (!this.conditionOption || _.isEmpty(this.formData)) {\n                return;\n            }\n\n            if (this.conditionOption === 'category_ids' && typeof this.formData['category_ids'] !== 'string') {\n                this.formData['category_ids'] = '';\n            }\n\n            _.extend(this.formData, this.conditionValue);\n            conditionsDataProcessor(this.formData, this.conditionOption + '_source');\n\n            // Store the previous conditions so we don't update the totals when nothing has changed\n            if (this.previousConditions === this.formData['conditions_encoded']) {\n                return;\n            }\n            this.previousConditions = this.formData['conditions_encoded'];\n\n            this.loading(true);\n            this.abortRunningRequest();\n            this.jqXHR = $.ajax({\n                url: this.url,\n                method: 'POST',\n                data: {\n                    conditionValue: this.formData['conditions_encoded']\n                },\n                error: function (jqXHR) {\n                    if (jqXHR.statusText !== 'abort') {\n                        this.callSuperError(jqXHR);\n                    }\n                }.bind(this)\n            }).done(function (response) {\n                this.totalProductCount(parseInt(response.total, 10));\n                this.totalDisabledProducts(parseInt(response.disabled, 10));\n                this.totalNotVisibleProducts(parseInt(response.notVisible, 10));\n                totalText = this.valuePlaceholder\n                    .replace('%1', parseInt(response.total, 10));\n\n                if (parseInt(response.disabled, 10) > 0) {\n                    negativeTotals.push(this.disabledPlaceholder.replace('%1', parseInt(response.disabled, 10)));\n                }\n\n                if (parseInt(response.notVisible, 10) > 0) {\n                    negativeTotals.push(this.notVisiblePlaceholder.replace('%1', parseInt(response.notVisible, 10)));\n                }\n\n                if (negativeTotals.length > 0) {\n                    totalText += ' (' + negativeTotals.join(', ') + ')';\n                }\n\n                this.value(totalText);\n                this.loading(false);\n            }.bind(this)).fail(function () {\n                if (this.jqXHR.statusText !== 'abort') {\n                    this.value($t('An unknown error occurred. Please try again.'));\n                }\n                this.loading(false);\n            }.bind(this));\n        }, 10)\n    });\n});\n","Magento_PageBuilder/js/form/element/condition-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/form/element/visual-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.showRelatedElement(this.value());\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super();\n\n            this.options().forEach(function (option) {\n                this.observe(option.value + 'Visible');\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        onUpdate: function (value) {\n            this.showRelatedElement(value);\n\n            return this._super();\n        },\n\n        /**\n         * Sets exported property, linked with visibility of the element, defined as option\n         *\n         * @param {String} value\n         * @returns {Object} Chainable\n         */\n        showRelatedElement: function (value) {\n            this[value + 'Visible'](true);\n            this.options().forEach(function (option) {\n                if (value !== option.value) {\n                    this[option.value + 'Visible'](false);\n                }\n            }.bind(this));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/margins-and-padding.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict */\n\ndefine([\n    'underscore',\n    'ko',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, ko, Abstract) {\n    'use strict';\n\n    var defaultValue = '';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/margins-and-padding',\n            marginTop: defaultValue,\n            marginRight: defaultValue,\n            marginBottom: defaultValue,\n            marginLeft: defaultValue,\n            paddingTop: defaultValue,\n            paddingRight: defaultValue,\n            paddingBottom: defaultValue,\n            paddingLeft: defaultValue,\n            listens: {\n                marginTop: 'updateValue',\n                marginRight: 'updateValue',\n                marginBottom: 'updateValue',\n                marginLeft: 'updateValue',\n                paddingTop: 'updateValue',\n                paddingRight: 'updateValue',\n                paddingBottom: 'updateValue',\n                paddingLeft: 'updateValue'\n            }\n        },\n\n        /**\n         * Init observable on our margin & padding properties\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('marginTop marginRight marginBottom marginLeft ' +\n                'paddingTop paddingRight paddingBottom paddingLeft');\n\n            return this;\n        },\n\n        /**\n         * Update the value on individual property changes\n         */\n        updateValue: function () {\n            this.value({\n                margin: {\n                    top: this.marginTop(),\n                    right: this.marginRight(),\n                    bottom: this.marginBottom(),\n                    left: this.marginLeft()\n                },\n                padding: {\n                    top: this.paddingTop(),\n                    right: this.paddingRight(),\n                    bottom: this.paddingBottom(),\n                    left: this.paddingLeft()\n                }\n            });\n        },\n\n        /**\n         * On set of the initial value update our individual observables\n         *\n         * @returns {exports}\n         */\n        setInitialValue: function () {\n            this._super();\n            this._updateObservables(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * On update of the value property update our individual observables, the data provider can have data\n         * set on it after the initial construction, this ensures we translate our values\n         *\n         * @returns {exports}\n         */\n        onUpdate: function () {\n            this._super();\n            this._updateObservables(this.value());\n\n            return this;\n        },\n\n        /**\n         * Update the observable properties\n         *\n         * @param {Number} value\n         * @private\n         */\n        _updateObservables: function (value) {\n            if (value && _.isString(value)) {\n                value = JSON.parse(value);\n            }\n\n            if (value && _.isObject(value)) {\n                _.each(value, function (attributeData, attributeType) {\n                    _.each(attributeData, function (attributeValue, attributeDirection) {\n                        if (attributeValue !== defaultValue) {\n                            this[attributeType + attributeDirection.capitalize()](attributeValue);\n                        }\n                    }, this);\n                }, this);\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/select-filtered-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n\n        defaults: {\n            excludeOptions: []\n        },\n\n        /** @inheritdoc */\n        onUpdate: function () {\n            if (!this.updatedByFilter) {\n                this.transferredValue = null;\n            } else {\n                this.updatedByFilter = false;\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Excluding options according excludeOptions configuration based on the passed value\n         *\n         * @param {String} value\n         */\n        filter: function (value) {\n            var source = this.initialOptions,\n                initialValue = this.value(),\n                result,\n                excludeOptions =  this.excludeOptions[value],\n                excludedOptionsArray = excludeOptions ? excludeOptions.split(',') : [];\n\n            result = _.filter(source, function (item) {\n                return !excludeOptions || excludedOptionsArray.indexOf(item.value) === -1;\n            });\n\n            this.updatedByFilter = true;\n            this.setOptions(result);\n\n            this.value(this.transferredValue ? this.transferredValue : initialValue);\n\n            if (excludedOptionsArray.indexOf(initialValue) !== -1) {\n                this.transferredValue = initialValue;\n            } else {\n                this.transferredValue = null;\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-value-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var setDependentValuesSetting = {\n        defaults: {\n            dependentValues: {}\n        },\n\n        /**\n         * Change value of component if it present in dependentValues\n         */\n        setDependentValues: function (value) {\n            if (this.dependentValues.hasOwnProperty(value)) {\n                this.previousValue = this.value();\n                this.value(this.dependentValues[value]);\n            } else if (this.hasOwnProperty('previousValue')) {\n                this.value(this.previousValue);\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(setDependentValuesSetting);\n    };\n});\n","Magento_PageBuilder/js/form/element/conditional-disable-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var setDisabledSetting = {\n        defaults: {\n            disabledValues: []\n        },\n\n        /**\n         * Set the field as disabled when it's empty or is equal to a value within disabledValues\n         *\n         * @param {Array} value\n         */\n        setDisabled: function (value) {\n            if (_.indexOf(_.values(this.disabledValues), value) !== -1) {\n                this.disable();\n            } else {\n                this.enable();\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(setDisabledSetting);\n    };\n});\n","Magento_PageBuilder/js/form/element/dependent-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            visible: false\n        },\n\n        /**\n         * Dependently display dropdown component if it contains more than one option\n         *\n         * @returns {Object} Chainable\n         */\n        setOptions: function () {\n            this._super();\n\n            if (this.options().length > 1) {\n                this.setVisible(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/html-code.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global MediabrowserUtility, widgetTools, MagentovariablePlugin */\ndefine([\n    'Magento_Ui/js/form/element/textarea',\n    'mage/adminhtml/wysiwyg/widget'\n], function (Textarea) {\n    'use strict';\n\n    var HTML_ID_PLACEHOLDER = 'HTML_ID_PLACEHOLDER';\n\n    return Textarea.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/html-code'\n        },\n\n        /**\n         * Click event for Insert Widget Button\n         */\n        clickInsertWidget: function () {\n            return widgetTools.openDialog(\n                this.widgetUrl.replace(HTML_ID_PLACEHOLDER, this.uid)\n            );\n        },\n\n        /**\n         * Click event for Insert Image Button\n         */\n        clickInsertImage: function () {\n            return MediabrowserUtility.openDialog(\n                this.imageUrl.replace(HTML_ID_PLACEHOLDER, this.uid)\n            );\n        },\n\n        /**\n         * Click event for Insert Variable Button\n         */\n        clickInsertVariable: function () {\n            return MagentovariablePlugin.loadChooser(\n                this.variableUrl,\n                this.uid\n            );\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/wysiwyg.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/element/wysiwyg',\n    'mage/translate',\n    'Magento_PageBuilder/js/events',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'Magento_PageBuilder/js/page-builder',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, _, Wysiwyg, $t, events, domObserver, PageBuilder) {\n    'use strict';\n\n    /**\n     * Extend the original WYSIWYG with added PageBuilder functionality\n     */\n    return Wysiwyg.extend({\n        defaults: {\n            transition: false,\n            transitionOut: false,\n            elementSelector: '> textarea',\n            stageSelector: '.pagebuilder-stage-wrapper',\n            fieldsetSelector: 'fieldset.admin__fieldset',\n            overlaySelector: '.pagebuilder-wysiwyg-overlay',\n            overlayMouseover: false,\n            pageBuilder: false,\n            visiblePageBuilder: false,\n            isComponentInitialized: false,\n            wysiwygConfigData: {\n                isFullScreen: false\n            },\n            pageBuilderEditButtonText: $t('Edit with Page Builder'),\n            isWithinModal: false,\n            modal: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n\n            if (!this.wysiwygConfigData()['pagebuilder_button'] ||\n                this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                this.initPageBuilder();\n            }\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super()\n                .observe('isComponentInitialized visiblePageBuilder wysiwygConfigData loading transition ' +\n                    'transitionOut overlayMouseover');\n\n            return this;\n        },\n\n        /**\n         * Handle button click, init the Page Builder application\n         */\n        pageBuilderEditButtonClick: function (context, event) {\n            this.determineIfWithinModal(event.currentTarget);\n            this.transition(false);\n\n            if (!this.isComponentInitialized()) {\n                this.disableDomObserver($(event.currentTarget).parent()[0]);\n            }\n\n            this.initPageBuilder();\n            this.toggleFullScreen();\n        },\n\n        /**\n         * Init Page Builder\n         */\n        initPageBuilder: function () {\n            if (!this.isComponentInitialized()) {\n                this.loading(true);\n                this.pageBuilder = new PageBuilder(\n                  this.wysiwygConfigData(),\n                  this.initialValue\n                );\n                if (!this.source.get('pageBuilderInstances')) {\n                    this.source.set('pageBuilderInstances', []);\n                }\n                // Register PageBuilder instance in the data provider in case the event \"pagebuilder:register\"\n                // is triggered before the subscribers are registered\n                this.source.get('pageBuilderInstances').push(this.pageBuilder);\n                events.trigger('pagebuilder:register', {\n                    ns: this.ns,\n                    instance: this.pageBuilder\n                });\n                this.initPageBuilderListeners();\n                this.isComponentInitialized(true);\n\n                // Disable the domObserver for the entire stage\n                $.async({\n                    component: this,\n                    selector: this.stageSelector\n                }, this.disableDomObserver.bind(this));\n\n                if (!this.wysiwygConfigData()['pagebuilder_button'] ||\n                    this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.visiblePageBuilder(true);\n                }\n            }\n        },\n\n        /**\n         * Disable the domObserver on the PageBuilder stage to improve performance\n         *\n         * @param {HTMLElement} node\n         */\n        disableDomObserver: function (node) {\n            this.determineIfWithinModal(node);\n            domObserver.disableNode(node);\n            domObserver.disableNode($(node).parents(this.fieldsetSelector)[0]);\n        },\n\n        /**\n         * Changes tabindex and content editable on stage elements\n         */\n        toggleFocusableElements: function () {\n            var pageBuilderSelector = '#' + this.pageBuilder.id,\n                editable = $(pageBuilderSelector).find('[contenteditable]:not(.mceNonEditable)'),\n                focusableSelector = ' :focusable:not(' + this.overlaySelector + ')',\n                mediaSelector = pageBuilderSelector + ' iframe,' + pageBuilderSelector + ' video',\n                tabIndexValue = this.pageBuilder.isFullScreen() ? '0' : '-1',\n                editableValue = this.pageBuilder.isFullScreen();\n\n            editable.attr('contenteditable', editableValue);\n            if (this.pageBuilder.isFullScreen()) {\n                $(pageBuilderSelector + focusableSelector)\n                    .each(function () {\n                        if ($(this).data('original-tabindex')) {\n                            $(this).attr('tabindex', $(this).data('original-tabindex'));\n                        } else if ($(this).data('original-tabindex') === '') {\n                            $(this).removeAttr('tabindex');\n                        }\n                        $(this).removeData('original-tabindex');\n                    });\n            } else {\n                $(pageBuilderSelector + focusableSelector).each(function () {\n                    if ($(this).attr('tabindex')) {\n                        $(this).data('original-tabindex', $(this).attr('tabindex'));\n                    } else {\n                        $(this).data('original-tabindex', '');\n                    }\n                    $(this).attr('tabindex', '-1');\n                });\n            }\n            $(mediaSelector).attr('tabindex', tabIndexValue);\n        },\n\n        /**\n         * Determine if the current instance is within a modal\n         *\n         * @param {HTMLElement} element\n         */\n        determineIfWithinModal: function (element) {\n            var modalInnerWrap = $(element).parents('.modal-inner-wrap');\n\n            // Determine if the Page Builder instance is within a modal\n            this.isWithinModal = modalInnerWrap.length === 1;\n\n            if (this.isWithinModal) {\n                this.modal = modalInnerWrap;\n            }\n        },\n\n        /**\n         * Press Enter key on Overlay\n         */\n        onOverlayKeyDown: function (context, event) {\n            if (event.which === 13 || event.keyCode === 13) {\n                this.pageBuilderEditButtonClick(context, event);\n            }\n\n            return true;\n        },\n\n        /**\n         * Toggle Page Builder full screen mode\n         */\n        toggleFullScreen: function () {\n            events.trigger('stage:' + this.pageBuilder.id + ':toggleFullscreen', {\n                animate: !!this.wysiwygConfigData()['pagebuilder_content_snapshot']\n            });\n        },\n\n        /**\n         * Init various listeners on the stage\n         */\n        initPageBuilderListeners: function () {\n            var id = this.pageBuilder.id,\n                renderDeferred = $.Deferred(),\n                fullScreenDeferred = $.Deferred(),\n                rendered = false;\n\n            events.on('stage:' + id + ':readyAfter', function () {\n                this.loading(false);\n            }.bind(this));\n\n            events.on('stage:' + id + ':renderAfter', function () {\n                renderDeferred.resolve();\n                rendered = true;\n            });\n\n            events.on('stage:' + id + ':masterFormatRenderAfter', function (args) {\n                this.value(args.value);\n\n                if (this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.toggleFocusableElements();\n                }\n            }.bind(this));\n\n            events.on('stage:' + id + ':fullScreenModeChangeAfter', function (args) {\n                if (!args.fullScreen) {\n                    if (this.isWithinModal && this.modal) {\n                        _.delay(function () {\n                            this.modal.css({\n                                transform: '',\n                                transition: ''\n                            });\n                        }.bind(this), 350);\n                    }\n\n                    if (this.wysiwygConfigData()['pagebuilder_button'] &&\n                        !this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                        // Force full screen mode whilst the animation occurs\n                        this.transitionOut(true);\n                        // Trigger animation out\n                        this.transition(false);\n\n                        // Reset the transition out class and hide the stage\n                        _.delay(function () {\n                            this.transitionOut(false);\n                            this.visiblePageBuilder(false);\n                        }.bind(this), 185);\n                    }\n                } else if (args.fullScreen) {\n                    if (this.isWithinModal && this.modal) {\n                        this.modal.css({\n                            transform: 'none',\n                            transition: 'none'\n                        });\n                    }\n\n                    if (this.wysiwygConfigData()['pagebuilder_button'] &&\n                        !this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                        this.visiblePageBuilder(true);\n\n                        fullScreenDeferred.resolve();\n\n                        /* eslint-disable max-depth */\n                        // If the stage has already rendered once we don't need to wait until animating the stage in\n                        if (rendered) {\n                            _.defer(function () {\n                                this.transition(true);\n                            }.bind(this));\n                        }\n                        /* eslint-enable max-depth */\n                    }\n                }\n\n                if (this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.toggleFocusableElements();\n                }\n            }.bind(this));\n\n            // Wait until the stage is rendered and full screen mode is activated\n            $.when(renderDeferred, fullScreenDeferred).done(function () {\n                _.defer(function () {\n                    this.transition(true);\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this.pageBuilder && this.pageBuilder.destroy();\n            this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/validator-rules-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/lib/validation/utils'\n], function ($, _, utils) {\n    'use strict';\n\n    /**\n     * Validate the number is between the min and max provided\n     *\n     * @param {Number} value\n     * @param {Number} min\n     * @param {Number} max\n     * @return {Boolean}\n     */\n    function validateNumberBetween(value, min, max) {\n        var numValue;\n\n        if ($.mage.isEmptyNoTrim(value)) {\n            return true;\n        }\n\n        numValue = $.mage.parseNumber(value);\n\n        if (isNaN(numValue)) {\n            return false;\n        }\n\n        return $.mage.isBetween(numValue, min, max);\n    }\n\n    /**\n     * Validate that string is url\n     * @param {String} href\n     * @return {Boolean}\n     */\n    function validateIsUrl(href) {\n        return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(href);//eslint-disable-line max-len\n    }\n\n    /**\n     * Validate that string has an anchor tag\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateWysiwygHasAnchorTags(str) {\n        return (/<a[\\s]+([^>]+)>|<a>|<\\/a>/igm).test(str);\n    }\n\n    /**\n     * Validate that string has a widget\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateWysiwygHasWidget(str) {\n        return (/\\{\\{widget(.*?)\\}\\}/ig).test(str);\n    }\n\n    /**\n     * Validate that string is a proper css-class\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateCssClass(str) {\n        return (/^[a-zA-Z _\\-\\d]+$/i).test(str);\n    }\n\n    /**\n     * Validate message field and url field anchor tag is used exclusively by one field\n     * @param {String} message\n     * @param {Object} url\n     * @return {Boolean}\n     */\n    function validateOneAnchorTagField(message, url) {\n        return !(validateWysiwygHasAnchorTags(message) &&\n            ['page', 'product', 'category', 'default'].indexOf(url.type) !== -1 &&\n            url[url.type] &&\n            url[url.type].length > 0);\n    }\n\n    /**\n     * Validate message field and url field html standards, nested widget\n     * @param {String} message\n     * @param {Object} url\n     * @return {Boolean}\n     */\n    function validateNestedWidgetElement(message, url) {\n        return !(validateWysiwygHasWidget(message) &&\n            ['page', 'product', 'category', 'default'].indexOf(url.type) !== -1 &&\n            url[url.type] &&\n            url[url.type].length > 0);\n    }\n\n    /**\n     * Validate a field with an expected data value of type object, like margins_and_padding field\n     * @param {Function} validator\n     * @param {String} ruleName\n     */\n    function validateObjectField(validator, ruleName) {\n        var rule = validator.getRule(ruleName);\n\n        validator.addRule(\n            ruleName,\n            function (value, params) {\n                var allNumbers = true,\n                    handler = rule.handler.bind(this);\n\n                if (typeof value !== 'object') {\n                    return handler(value, params);\n                }\n\n                _.flatten(_.map(value, _.values)).forEach(function (val) {\n                    if (!handler(val, params)) {\n                        allNumbers = false;\n\n                        return allNumbers;\n                    }\n                });\n\n                return allNumbers;\n            },\n            $.mage.__(rule.message)\n        );\n    }\n\n    /**\n     * Validate calc value.\n     *\n     * @param {String} value\n     * @returns {Boolean}\n     */\n    function validateCalc(value) {\n        var el = document.createElement('div'),\n            style = el.style;\n\n        if (!value.trim().length) {\n            return true;\n        }\n\n        style.width = 'calc(' + value + ')';\n\n        return !!style.width.length;\n    }\n\n    return function (validator) {\n        var requiredInputRule = validator.getRule('required-entry');\n\n        validator.addRule(\n            'required-entry-location-name',\n            requiredInputRule.handler,\n            $.mage.__('Please enter the location name.')\n        );\n\n        validator.addRule(\n            'required-entry-latitude',\n            requiredInputRule.handler,\n            $.mage.__('Enter latitude')\n        );\n\n        validator.addRule(\n            'required-entry-longitude',\n            requiredInputRule.handler,\n            $.mage.__('Enter longitude')\n        );\n\n        validator.addRule(\n            'validate-latitude',\n            function (value) {\n                return validateNumberBetween(value, -85, 85);\n            },\n            $.mage.__('Please enter a number between -85 and 85')\n        );\n\n        validator.addRule(\n            'validate-longitude',\n            function (value) {\n                return validateNumberBetween(value, -180, 180);\n            },\n            $.mage.__('Please enter a number between -180 and 180')\n        );\n\n        validator.addRule(\n            'validate-video-url',\n            function (href) {\n                if (utils.isEmptyNoTrim(href)) {\n                    return true;\n                }\n\n                href = (href || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return validateIsUrl(href) && (href.match(/youtube\\.com|youtu\\.be/) || href.match(/vimeo\\.com/));\n            },\n            $.mage.__('Please enter a valid video URL.')\n        );\n\n        validator.addRule(\n            'validate-video-source',\n            function (href) {\n                if (utils.isEmptyNoTrim(href)) {\n                    return true;\n                }\n\n                href = (href || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return validateIsUrl(href) && (\n                    href.match(/youtube\\.com|youtu\\.be/) ||\n                    href.match(/vimeo\\.com/) ||\n                    href.match(/\\.(mp4|ogv|webm)(?!\\w)/)\n                );\n            },\n            $.mage.__('Please enter a valid video URL. Valid URLs have a video file extension (.mp4, .webm, .ogv) or links to videos on YouTube or Vimeo.')//eslint-disable-line max-len\n        );\n\n        validator.addRule(\n            'validate-css-class',\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                return validateCssClass(value);\n            },\n            $.mage.__('Please enter a valid CSS class.')\n        );\n\n        validator.addRule(\n            'required-entry',\n            function (value) {\n                var allFilled;\n\n                // Validation only for margins and paddings\n                if (value !== null && typeof value === 'object' && !!(value.padding || value.margin)) {\n                    allFilled = true;\n\n                    _.flatten(_.map(value, _.values)).forEach(function (val) {\n                        if (utils.isEmpty(val)) {\n                            allFilled = false;\n\n                            return allFilled;\n                        }\n                    });\n\n                    return allFilled;\n                }\n\n                return requiredInputRule.handler(value);\n            },\n            $.mage.__(requiredInputRule.message)\n        );\n\n        validator.addRule(\n            'validate-message-no-link',\n            function (url, message) {\n                return validateOneAnchorTagField(message, url);\n            },\n            $.mage.__('Adding link in both content and outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-no-url',\n            function (message, url) {\n                return validateOneAnchorTagField(message, url);\n            },\n            $.mage.__('Adding link in both content and outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-message-no-widget',\n            function (url, message) {\n                return validateNestedWidgetElement(message, url);\n            },\n            $.mage.__('Adding link in outer element and widget in content is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-no-widget',\n            function (message, url) {\n                return validateNestedWidgetElement(message, url);\n            },\n            $.mage.__('Adding widget in content and link in outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-calc',\n            function (value) {\n                return validateCalc(value);\n            },\n            $.mage.__('Please enter a valid number or calculation: Valid numbers must have an extension (px, %, pt, vh). Calculations must have white space around the + and - operators and cannot divide by zero.')//eslint-disable-line max-len\n        );\n\n        validator.addRule(\n            'validate-grid-size',\n            function (value, params, additionalParams) {\n                if (value < additionalParams.non_empty_column_count) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Grid size cannot be smaller than the current total amount of columns, minus any empty columns.')\n        );\n\n        validator.addRule(\n            'validate-max-grid-size',\n            function (value, params, additionalParams) {\n                if (value > additionalParams.max_grid_size) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a value less than or equal to the Maximum Column Grid Size configuration.')\n        );\n\n        validateObjectField(validator, 'validate-number');\n        validateObjectField(validator, 'less-than-equals-to');\n        validateObjectField(validator, 'greater-than-equals-to');\n\n        return validator;\n    };\n});\n","Magento_PageBuilder/js/form/element/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/image-uploader',\n    'Magento_PageBuilder/js/resource/resize-observer/ResizeObserver',\n    'Magento_PageBuilder/js/events',\n    'mage/translate'\n], function ($, _, uiRegistry, Uploader, ResizeObserver, events, $t) {\n    'use strict';\n\n    var initializedOnce = false;\n\n    return Uploader.extend({\n        defaults: {\n            $uploadArea: null,\n            isShowImageUploadInstructions: true,\n            isShowImageUploadOptions: false,\n            visibleControls: true,\n            classes: {\n                dragging: 'dragging',\n                draggingInside: 'dragging-inside',\n                draggingOutside: 'dragging-outside'\n            },\n            // listed in ascending order\n            elementWidthModifierClasses: {\n                '_micro-ui': {\n                    maxWidth: 130\n                },\n                '_compact-ui': {\n                    minWidth: 131,\n                    maxWidth: 440\n                }\n            },\n            translations: {\n                allowedFileTypes: $t('Allowed file types'),\n                dragImageHere: $t('Drag image here'),\n                dropHere: $t('Drop here'),\n                maximumFileSize: $t('Maximum file size'),\n                selectFromGallery: $t('Select from Gallery'),\n                or: $t('or'),\n                uploadImage: $t('Upload Image'),\n                uploadNewImage: $t('Upload New Image')\n            },\n            tracks: {\n                visibleControls: true\n            }\n        },\n\n        /**\n         * Bind drag events to highlight/unhighlight dropzones\n         * {@inheritDoc}\n         */\n        initialize: function () {\n            var $document = $(document);\n\n            this._super();\n\n            events.on('image:' + this.id + ':assignAfter', this.onAssignedFile.bind(this));\n\n            // bind dropzone highlighting using event delegation only once\n            if (!initializedOnce) {\n                // dropzone highlighting\n                $document.on('dragover', this.highlightDropzone.bind(this));\n\n                // dropzone unhighlighting\n                $document.on('dragend dragleave mouseup', this.unhighlightDropzone.bind(this));\n\n                initializedOnce = true;\n            }\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        initUploader: function (fileInput) {\n            this._super(fileInput);\n            this.$uploadArea = $('#' + $(fileInput).attr('id')).closest('.pagebuilder-image-empty-preview');\n            if (this.$uploadArea.get(0) !== undefined) {\n                new ResizeObserver(this.updateResponsiveClasses.bind(this)).observe(this.$uploadArea.get(0));\n            }\n        },\n\n        /**\n         * Checks if provided file is allowed to be uploaded.\n         * {@inheritDoc}\n         */\n        isFileAllowed: function () {\n            var result = this._super(),\n                allowedExtensions = this.getAllowedFileExtensionsInCommaDelimitedFormat();\n\n            if (!result.passed && result.rule === 'validate-file-type') {\n                result.message += ' ' + this.translations.allowedFileTypes + ': ' + allowedExtensions + '.';\n            }\n\n            return result;\n        },\n\n        /**\n         * Remove draggable classes from dropzones\n         * {@inheritDoc}\n         */\n        onBeforeFileUpload: function () {\n            this.removeDraggableClassesFromDropzones();\n            this._super();\n        },\n\n        /**\n         * Add/remove CSS classes to $dropzone element to provide UI feedback\n         *\n         * @param {jQuery.event} e\n         */\n        highlightDropzone: function (e) {\n            var $dropzone = $(e.target).closest(this.dropZone),\n                $otherDropzones = $(this.dropZone).not($dropzone),\n                isInsideDropzone = !!$dropzone.length;\n\n            if (isInsideDropzone) {\n                $dropzone\n                    .removeClass(this.classes.draggingOutside)\n                    .addClass([this.classes.dragging, this.classes.draggingInside].join(' '));\n            }\n\n            $otherDropzones\n                .removeClass(this.classes.draggingInside)\n                .addClass([this.classes.dragging, this.classes.draggingOutside].join(' '));\n        },\n\n        /**\n         * Remove all UI styling from dropzone\n         *\n         * @param {jQuery.event} e\n         */\n        unhighlightDropzone: function (e) {\n            var isMouseReleased = e.type === 'mouseup' || e.type === 'dragend',\n                isActuallyLeavingThePage = e.type === 'dragleave' && (e.clientX === 0 || e.clientY === 0);\n\n            if (!isMouseReleased && !isActuallyLeavingThePage) {\n                return;\n            }\n\n            this.removeDraggableClassesFromDropzones();\n        },\n\n        /**\n         * Remove draggable CSS classes from dropzone elements\n         */\n        removeDraggableClassesFromDropzones: function () {\n            var $dropzones = $(this.dropZone);\n\n            $dropzones\n                .removeClass([\n                    this.classes.dragging,\n                    this.classes.draggingInside,\n                    this.classes.draggingOutside\n                ].join(' '));\n        },\n\n        /**\n         * Trigger image:uploadAfter event to be handled by PageBuilder image component\n         * {@inheritDoc}\n         */\n        addFile: function (file) {\n            this._super();\n\n            events.trigger('image:' + this.id + ':uploadAfter', [file]);\n\n            return this;\n        },\n\n        /**\n         * Trigger image:deleteFileAfter event to be handled by PageBuilder image component\n         * {inheritDoc}\n         */\n        clear: function () {\n            this._super();\n\n            events.trigger('image:' + this.id + ':deleteFileAfter');\n\n            return this;\n        },\n\n        /**\n         * Propagate file changes through all image uploaders sharing the same id\n         *\n         * @param {Object} file\n         */\n        onAssignedFile: function (file) {\n            this.value([file]);\n        },\n\n        /**\n         * Adds the appropriate ui state class to the upload control area based on the current rendered size\n         */\n        updateResponsiveClasses: function () {\n            var classesToAdd = [],\n                classConfig,\n                elementWidth = this.$uploadArea.width(),\n                modifierClass;\n\n            if (!this.$uploadArea.is(':visible')) {\n                return;\n            }\n\n            this.$uploadArea.removeClass(Object.keys(this.elementWidthModifierClasses).join(' '));\n\n            for (modifierClass in this.elementWidthModifierClasses) {\n                if (!this.elementWidthModifierClasses.hasOwnProperty(modifierClass)) {\n                    // jscs:disable disallowKeywords\n                    continue;\n                    // jscs:enable disallowKeywords\n                }\n\n                classConfig = this.elementWidthModifierClasses[modifierClass];\n\n                if (classConfig.minWidth && classConfig.maxWidth &&\n                    (classConfig.minWidth <= elementWidth && elementWidth <= classConfig.maxWidth) ||\n                    classConfig.minWidth && !classConfig.maxWidth && classConfig.minWidth <= elementWidth ||\n                    classConfig.maxWidth && !classConfig.minWidth && elementWidth <= classConfig.maxWidth\n                ) {\n                    classesToAdd.push(modifierClass);\n                }\n            }\n\n            if (classesToAdd.length) {\n                this.$uploadArea.addClass(classesToAdd.join(' '));\n            }\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        hasData: function () {\n            // Some of the components automatically add an empty object if the value is unset.\n            return this._super() && !$.isEmptyObject(this.value()[0]);\n        },\n\n        /**\n         * Stop event to prevent it from reaching any objects other than the current object.\n         *\n         * @param {Object} uploader\n         * @param {Event} event\n         * @returns {Boolean}\n         */\n        stopEvent: function (uploader, event) {\n            event.stopPropagation();\n\n            return true;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset'\n], function (Fieldset) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            originalLabelValue: ''\n        },\n\n        /**\n         * Observe label\n         * {@inheritDoc}\n         */\n        initObservable: function () {\n            this._super().observe('label');\n\n            return this;\n        },\n\n        /**\n         * Store original label value\n         * {@inheritDoc}\n         */\n        initConfig: function () {\n            this._super();\n            this.originalLabelValue = this.label;\n        },\n\n        /**\n         * Hide fieldset if number of field options is <= 1 and it is the only element in the group\n         *\n         * @param {Array} options\n         */\n        hideFieldset: function (options) {\n            this.visible(options.length > 1 || this.elems().length > 1);\n        },\n\n        /**\n         * Hide label if number of field options is <= 1\n         *\n         * @param {Array} options\n         */\n        hideLabel: function (options) {\n            this.label(options.length > 1 ? this.originalLabelValue : '');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/page-ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Get path to current option\n         *\n         * @param {Object} data - option data\n         * @returns {String} path\n         */\n        getPath: function (data) {\n            var path = '';\n\n            if (this.renderPath) {\n                path = data.identifier || path;\n            }\n\n            return path;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-visual-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_PageBuilder/js/form/element/visual-select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            visible: false\n        },\n\n        /**\n         * Dependently display dropdown component if it contains more than one option\n         *\n         * @returns {Object} Chainable\n         */\n        setOptions: function () {\n            this._super();\n\n            if (this.options().length > 1) {\n                this.setVisible(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/conditions-loader.js":"define([\n    'jquery',\n    'Magento_Rule/rules',\n    'uiRegistry',\n    'mage/utils/objects'\n], function ($, RulesForm, uiRegistry, objectUtils) {\n    'use strict';\n\n    return function (config, conditionsFormPlaceholder) {\n        var $conditionsFormPlaceholder = $(conditionsFormPlaceholder),\n            attributeData = uiRegistry.get(config.formNamespace + '.' + config.formNamespace).source.data,\n            conditions = objectUtils.nested(attributeData, config.attribute) || '[]';\n\n        $('body').trigger('processStart');\n\n        $.ajax(config.componentUrl, {\n            method: 'POST',\n            data: {\n                conditions: conditions\n            }\n        })\n        .done(function (response) {\n            $conditionsFormPlaceholder.html(response);\n            window[config.jsObjectName] = new RulesForm(config.jsObjectName, config.childComponentUrl);\n            $('body').trigger('processStop');\n        });\n    };\n});\n","Magento_PageBuilder/js/form/element/visual-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            noticeMessage: '',\n            listens: {\n                value: 'setNoticeMessage'\n            }\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('noticeMessage');\n\n            return this;\n        },\n\n        /**\n         * Parses incoming options, considers options with undefined value property\n         *     as caption\n         *\n         * @param  {Array} nodes\n         * @param {Object} captionValue\n         * @return {Object} captionValue\n         */\n        parseOptions: function (nodes, captionValue) {\n            var caption,\n                value;\n\n            nodes = _.map(nodes, function (node) {\n                value = node.value;\n\n                if ((value === null || value === captionValue) && _.isUndefined(caption)) {\n                    caption = node.label;\n                }\n\n                return node;\n            });\n\n            return {\n                options: _.compact(nodes),\n                caption: _.isString(caption) ? caption : false\n            };\n        },\n\n        /**\n         * Recursively set to object item like value and item.value like key.\n         *\n         * @param {Array} data\n         * @param {Object} result\n         * @returns {Object}\n         */\n        indexOptions: function (data, result) {\n            var value;\n\n            result = result || {};\n\n            data.forEach(function (item) {\n                value = item.value;\n\n                if (Array.isArray(value)) {\n                    this.indexOptions(value, result);\n                } else {\n                    result[value] = item;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * Sets 'data' to 'options' observable array, if instance has\n         * 'customEntry' property set to true, calls 'setHidden' method\n         *  passing !options.length as a parameter\n         *\n         * @param {Array} data\n         * @returns {Object} Chainable\n         */\n        setOptions: function (data) {\n            var captionValue = this.captionValue || '',\n                result = this.parseOptions(data, captionValue),\n                isVisible;\n\n            this.indexedOptions = this.indexOptions(result.options);\n\n            this.options(result.options);\n\n            if (!this.caption()) {\n                this.caption(result.caption);\n            }\n\n            if (this.customEntry) {\n                isVisible = !!result.options.length;\n\n                this.setVisible(isVisible);\n                this.toggleInput(!isVisible);\n            }\n\n            return this;\n        },\n\n        /**\n         * Set the notice message on value change\n         *\n         * @param {any} value\n         * @returns {exports}\n         */\n        setNoticeMessage: function (value) {\n            var noticeMessage = '',\n                selectedOption = _.find(this.options(), function (option) {\n                    return option.value === value;\n                });\n\n            if (selectedOption && typeof selectedOption.noticeMessage !== 'undefined') {\n                noticeMessage = selectedOption.noticeMessage;\n            }\n\n            this.noticeMessage(noticeMessage);\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_PageBuilder/js/utils/map',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (AbstractField, GoogleMap, module, events) {\n    'use strict';\n\n    var google = window.google || {};\n\n    return AbstractField.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/map',\n            map: false,\n            marker: false,\n            apiKeyValid: !!module.config().apiKey,\n            apiKeyErrorMessage: module.config().apiKeyErrorMessage\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n\n            this.observe('apiKeyValid');\n\n            return this;\n        },\n\n        /**\n         * Render the map into the field\n         *\n         * @param {HTMLElement} element\n         */\n        renderMap: function (element) {\n            // Get the start value and convert the value into an array\n            var startValue = this.value(),\n                mapOptions,\n                latitudeLongitude;\n\n            if (!this.apiKeyValid()) {\n                return;\n            }\n\n            if (typeof startValue === 'string' && startValue !== '') {\n                startValue = JSON.parse(startValue);\n            }\n\n            mapOptions = {\n                navigationControl: true,\n                navigationControlOptions: {\n                    style: google.maps.NavigationControlStyle.DEFAULT\n                }\n            };\n\n            events.on('googleMaps:authFailure', function () {\n                this.apiKeyValid(false);\n            }.bind(this));\n\n            // Create the map\n            this.mapElement = new GoogleMap(element, [], mapOptions);\n\n            if (!this.mapElement || !this.mapElement.map) {\n                return;\n            }\n\n            // Add marker if there is a start value\n            if (startValue.latitude !== '' && startValue.longitude !== '') {\n                latitudeLongitude = new google.maps.LatLng(\n                    parseFloat(startValue.latitude),\n                    parseFloat(startValue.longitude)\n                );\n\n                this.mapElement.map.setCenter(latitudeLongitude);\n                this.addMarker(startValue.latitude, startValue.longitude);\n            }\n\n            // After click, add and update both Latitude and Longitude.\n            google.maps.event.addListener(this.mapElement.map, 'click', this.onClick.bind(this));\n            google.maps.event.addListener(this.mapElement.map, 'dblclick', this.onDblClick.bind(this));\n            google.maps.event.trigger(this.marker, 'click');\n        },\n\n        /**\n         * Adds a map marker\n         *\n         * @param {String} latitude\n         * @param {String} longitude\n         */\n        addMarker: function (latitude, longitude) {\n            this.marker = new google.maps.Marker({\n                draggable: true,\n                map: this.mapElement.map,\n                position: new google.maps.LatLng(latitude, longitude)\n            });\n            google.maps.event.addListener(this.marker, 'dragend', this.onDragEnd.bind(this));\n        },\n\n        /**\n         * Event for drag end to update value\n         */\n        onDragEnd: function () {\n            this.value(this.exportValue());\n        },\n\n        /**\n         * Event for click to update marker, delayed by 300ms in case of double click\n         *\n         * @param {Event} event\n         */\n        onClick: function (event) {\n            this.clickTimer = setTimeout(function () {\n                if (!this.marker) {\n                    this.addMarker(event.latLng.lat(), event.latLng.lng());\n                }\n                this.value(this.exportValue(event.latLng));\n            }.bind(this), 300);\n        },\n\n        /**\n         * Event for double click to prevent call from single click\n         */\n        onDblClick: function () {\n            clearTimeout(this.clickTimer);\n        },\n\n        /**\n         * Callback after an update to map\n         */\n        onUpdate: function () {\n            if (!this.mapElement) {\n                return;\n            }\n\n            this._super();\n            var content = this.value(),\n                latitudeLongitude;\n\n            if (this.marker && content.latitude === '' && content.longitude === '') {\n                this.marker.setMap(null);\n                delete this.marker;\n\n                return;\n            }\n\n            if (!this.validateCoordinate(content) ||\n                this.mapElement &&\n                !this.mapElement.map ||\n                this.value() === '' ||\n                this.value() === this.exportValue()) {\n                return;\n            }\n\n            if (typeof this.value() === 'string' && this.value() !== '') {\n                content = JSON.parse(this.value());\n            }\n            latitudeLongitude = new google.maps.LatLng(parseFloat(content.latitude), parseFloat(content.longitude));\n\n            if (!this.marker) {\n                this.addMarker(latitudeLongitude.lat(), latitudeLongitude.lng());\n            }\n\n            this.marker.setPosition(latitudeLongitude);\n            this.mapElement.map.setCenter(latitudeLongitude);\n        },\n\n        /**\n         * Coordinate validation\n         *\n         * @param {Object} coordinates\n         * @return {Boolean}\n         */\n        validateCoordinate: function (coordinates) {\n            var valid = true;\n\n            if (coordinates.longitude === '' ||\n                coordinates.latitude === '' ||\n                isNaN(coordinates.longitude) ||\n                isNaN(coordinates.latitude) ||\n                parseFloat(coordinates.longitude) < -180 ||\n                parseFloat(coordinates.longitude) > 180 ||\n                parseFloat(coordinates.latitude) < -90 ||\n                parseFloat(coordinates.latitude) > 90\n            ) {\n                valid = false;\n            }\n\n            return valid;\n        },\n\n        /**\n         * Returns current latitude and longitude as an object\n         *\n         * @param {Object} coordinate\n         * @return {Object}\n         */\n        exportValue: function (coordinate) {\n            var position = this.marker ?\n                this.marker.getPosition() :\n                new google.maps.LatLng(this.mapElement.map.center.lat(), this.mapElement.map.center.lng()),\n                currentCoordinate = coordinate ? coordinate : position;\n\n            return {\n                latitude: currentCoordinate.lat(),\n                longitude: currentCoordinate.lng()\n            };\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/block-chooser.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiLayout',\n    'uiElement',\n    'Magento_PageBuilder/js/config',\n    'mage/translate',\n    'mage/utils/objects'\n], function ($, layout, Element, Config, $t, objectUtils) {\n    'use strict';\n\n    return Element.extend({\n        id: null,\n        meta: {},\n        errorMessage: null,\n        displayMetadata: true,\n        messages: {\n            UNKOWN_ERROR: $t('Sorry, there was an error getting requested content. ' +\n                'Please contact the store owner.'),\n            UNKNOWN_SELECTION: $t('The currently selected block does not exist.')\n        },\n        defaults: {\n            template: 'Magento_PageBuilder/form/element/block-chooser',\n            requestParameter: null,\n            dataUrlConfigPath: null,\n            modalName: null,\n            buttonComponentConfig: {\n                title: '${ $.buttonTitle }',\n                component: 'Magento_Ui/js/form/components/button',\n                actions: [{\n                    targetName: '${ $.modalName }',\n                    actionName: 'openModal'\n                }]\n            },\n            requestData: {\n                method: 'POST',\n                data: {\n                    'form_key': window.FORM_KEY\n                }\n            },\n            listens: {\n                id: 'updateFromServer'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super()\n                .observe('id meta errorMessage displayMetadata');\n        },\n\n        /**\n         * Updates the block data from the server\n         *\n         * @returns void\n         */\n        updateFromServer: function () {\n            var requestData = $.extend(true, {}, this.requestData);\n\n            // The component hasn't be configured yet. Nothing to do.\n            if (!this.id().length || !this.requestParameter || !this.dataUrlConfigPath) {\n                this.meta({});\n\n                return;\n            }\n\n            requestData.data[this.requestParameter] = this.id();\n            $('body').trigger('processStart');\n\n            $.ajax(objectUtils.nested(Config.getConfig(), this.dataUrlConfigPath), requestData)\n                .always(function () {\n                    $('body').trigger('processStop');\n                    this.errorMessage(null);\n                }.bind(this))\n                .done(function (response) {\n                    if (typeof response !== 'object' || response.error) {\n                        this.meta({});\n                        this.errorMessage(this.messages.UNKOWN_ERROR);\n\n                        return;\n                    } else if (Array.isArray(response)) {\n                        this.meta({});\n                        this.errorMessage(this.messages.UNKNOWN_SELECTION);\n\n                        return;\n                    }\n\n                    this.meta(response);\n                }.bind(this))\n                .fail(function () {\n                    this.meta({});\n                    this.errorMessage(this.messages.UNKOWN_ERROR);\n                }.bind(this));\n        },\n\n        /**\n         * Creates the button component for rendering\n         *\n         * @returns {Object} The button component\n         */\n        getButton: function () {\n            var elementConfig = this.buttonComponentConfig;\n\n            elementConfig.name = this.name + '_button';\n            layout([elementConfig]);\n\n            return this.requestModule(elementConfig.name);\n        },\n\n        /**\n         * Determines the status label for the currently loaded block\n         *\n         * @returns {String}\n         */\n        getStatusLabel: function () {\n            return this.meta()['is_active'] === '1' ? $t('Active') : $t('Inactive');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/grid-size.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        validate: function () {\n            var externalFormSourceData = this.requestModule('index=' + this.ns)().source.data;\n\n            this.validationParams = {\n                'non_empty_column_count': externalFormSourceData.non_empty_column_count,\n                'max_grid_size': externalFormSourceData.max_grid_size\n            };\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/form/provider/conditions-data-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mage/utils/objects',\n    'Magento_Rule/conditions-data-normalizer'\n], function (_, objectUtils, ConditionsDataNormalizer) {\n    'use strict';\n\n    var serializer = new ConditionsDataNormalizer();\n\n    return function (data, attribute) {\n        var pairs = {},\n            conditions = '';\n\n        /*\n         * The Condition Rule Tree is not a UI component and doesn't provide good data.\n         * The best solution is to implement the tree as a UI component that can provide good data but\n         * that is outside of the scope of the feature for now.\n         */\n        _.each(data, function (element, key) {\n            // parameters is hardcoded in the Magento\\Rule model that creates the HTML forms.\n            if (key.indexOf('parameters[' + attribute + ']') === 0) {\n                // Remove the bad, un-normalized data.\n                delete data[key];\n                pairs[key] = element;\n            }\n        });\n\n        /*\n         * The Combine Condition rule needs to have children,\n         * if does not have, we cannot parse the rule in the backend.\n         */\n        _.each(pairs, function (element, key) {\n            var keyIds = key.match(/[\\d?-]+/g),\n              combineElement = 'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Combine',\n              nextPairsFirstKey = 'parameters[condition_source][NEXT_ITEM--1][type]',\n              nextPairsSecondKey = 'parameters[condition_source][NEXT_ITEM--2][type]';\n\n            if (keyIds !== null && element === combineElement) {\n                if (pairs[nextPairsFirstKey.replace('NEXT_ITEM', keyIds[0])] === undefined ||\n                    pairs[nextPairsFirstKey.replace('NEXT_ITEM', keyIds[0])] === combineElement &&\n                    pairs[nextPairsSecondKey.replace('NEXT_ITEM', keyIds[0])] === undefined) {\n                    pairs[key] = '';\n                }\n            }\n        });\n\n        /*\n         * Add pairs in case conditions source is not rules configurator\n         */\n        if (data['condition_option'] !== 'condition') {\n            pairs['parameters[' + attribute + '][1--1][operator]'] =\n                data[data['condition_option'] + '-condition_operator'] ?\n                data[data['condition_option'] + '-condition_operator'] :\n                '==';\n            pairs['parameters[' + attribute + '][1--1][type]'] =\n                'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Product';\n            pairs['parameters[' + attribute + '][1][aggregator]'] = 'all';\n            pairs['parameters[' + attribute + '][1][new_child]'] = '';\n            pairs['parameters[' + attribute + '][1][type]'] = 'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Combine';\n            pairs['parameters[' + attribute + '][1][value]'] = '1';\n            pairs['parameters[' + attribute + '][1--1][attribute]'] = data['condition_option'];\n            pairs['parameters[' + attribute + '][1--1][value]'] = _.isString(data[data['condition_option']]) ?\n                data[data['condition_option']].trim() :\n                '';\n        }\n\n        if (!_.isEmpty(pairs)) {\n            conditions = JSON.stringify(serializer.normalize(pairs).parameters[attribute]);\n            data['conditions_encoded'] = conditions;\n            objectUtils.nested(data, attribute, conditions);\n        }\n    };\n});\n","Magento_PageBuilder/js/form/components/action-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/button'\n], function (Button) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            modules: {\n                parent: '${ $.parentName }',\n                insertForm: '${ $.insertFormProvider }',\n                modal: '${ $.modalProvider }'\n            }\n        },\n\n        /**\n         * Edit form with data assigning.\n         */\n        edit: function () {\n            this.modal().openModal();\n            this.insertForm().edit(this.parent().data());\n        },\n\n        /**\n         * Delete record from dynamic row.\n         */\n        deleteRecord: function () {\n            var record = this.parent(),\n                dynamicRow = record.parentComponent(),\n                prop = dynamicRow.identificationProperty,\n                id = record.data()[prop];\n\n            dynamicRow.deleteRecord(record.index, id);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form',\n    'Magento_PageBuilder/js/events',\n    'jquery'\n], function (Insert, events, $) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            appearanceIndex: '',\n            configs: {},\n            tracks: {\n                id: true\n            },\n            listens: {\n                appearance: 'onAppearanceChange'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            events.on('form:renderAfter', function (params) {\n                this.render(params);\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        render: function (params) {\n            this.availableAppearances = params.appearances;\n            this.title = params.title;\n            this.defaultNamespace = params.defaultNamespace;\n            this.destroyInserted();\n            this.setData(params);\n\n            return this._super({\n                namespace: params.namespace,\n                handle: params.namespace\n            });\n        },\n\n        /**\n         * Set data for new form.\n         *\n         * @param {Object} params\n         */\n        setData: function (params) {\n            var formQuery = 'index=' + params.namespace,\n                dataProviderQuery = 'index=' + params.namespace + '_data_source';\n\n            this.providerData = params.data;\n            this.id = params.id;\n            this.externalForm = this.requestModule(formQuery);\n            this.externalSource = this.requestModule(dataProviderQuery);\n            this.setLinks({\n                appearance: 'ns = ' + params.namespace + ', index = ' + this.appearanceIndex + ':value'\n            }, 'imports');\n            this.setLinks({\n                providerData: dataProviderQuery + ':data',\n                prefix: formQuery + ':selectorPrefix',\n                id: dataProviderQuery + ':id'\n            }, 'exports');\n        },\n\n        /** @inheritdoc **/\n        requestData: function (params) {\n            var deffer = $.Deferred(),\n                formConfig = this.configs[params.namespace];\n\n            if (formConfig) {\n                return deffer.resolve(formConfig);\n            }\n\n            return this._super().done(function (data) {\n                this.configs[params.namespace] = data;\n            }.bind(this));\n        },\n\n        /**\n         * Re-render after appearance change\n         *\n         * @param {String} value\n         */\n        onAppearanceChange: function (value) {\n            var namespace = this.availableAppearances[value] && this.availableAppearances[value].form ||\n                this.defaultNamespace;\n\n            if (namespace !== this.previousParams.namespace) {\n                this.render({\n                    namespace: namespace,\n                    id: this.id,\n                    data: this.externalSource().get('data'),\n                    appearances: this.availableAppearances,\n                    title: this.title,\n                    defaultNamespace: this.defaultNamespace\n                });\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/map-location-insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (Insert) {\n    'use strict';\n\n    return Insert.extend({\n        /**\n         * Clear form content and reinsert data in argument\n         * @param {Object} data\n         */\n        edit: function (data) {\n            this.destroyInserted();\n            this.render();\n            this.setData(data);\n        },\n\n        /**\n         * Set data for new form\n         *\n         * @param {Object} data\n         */\n        setData: function (data) {\n            var formQuery = 'index=' + this.ns,\n                dataProviderQuery = 'index=' + this.ns + '_data_source';\n\n            this.providerData = data;\n            this.externalForm = this.requestModule(formQuery);\n            this.externalSource = this.requestModule(dataProviderQuery);\n            this.setLinks({\n                providerData: dataProviderQuery + ':data'\n            }, 'exports');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/map-location-dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'Magento_PageBuilder/js/events',\n    'underscore',\n    'jquery'\n], function (dynamicRows, Events, _, $) {\n    'use strict';\n\n    /**\n     * Returns sortable values\n     *\n     * @param {String | Number | Object | Array} value\n     * @return {String | Number}\n     */\n    var sortValueValidator = function (value) {\n        if (typeof value === 'string') {\n            return value.toLowerCase();\n        }\n\n        if (typeof value === 'number') {\n            return value;\n        }\n\n        return '';\n    };\n\n    return dynamicRows.extend({\n        defaults: {\n            modules: {\n                insertForm: '${ $.insertFormProvider }',\n                modal: '${$.modalProvider}'\n            }\n        },\n\n        /** @inheritdoc */\n        initLinks: function () {\n            this._super();\n            Events.on('mapLocation:saveAfter', function (data) {\n                this.modal().closeModal();\n                this.reInitData(data);\n            }.bind(this), this.name);\n\n            return this;\n        },\n\n        /**\n         * Open the location modal and insert form with the data from selected record\n         *\n         * @param {Object} record\n         */\n        edit: function (record) {\n            this.modal().openModal();\n            this.insertForm().edit(record.data());\n        },\n\n        /**\n         * Reinitializing of dynamic row records.\n         *\n         * @param {Object} data\n         */\n        reInitData: function (data) {\n            var recordData = this.recordData().slice(),\n                prop = this.identificationProperty,\n                isExists = false;\n\n            _.each(recordData, function (elem, index) {\n                if (elem[prop] === data[prop]) {\n                    recordData[index] = data;\n                    isExists = true;\n                }\n            }, this);\n\n            if (!isExists) {\n                recordData.push(data);\n            }\n\n            this.recordData(recordData);\n\n            _.each(this.labels(), function (label) {\n                if (label.columnsHeaderClasses) {\n                    this.sortRecord(label.name, label.columnsHeaderClasses === '_ascend');\n                }\n            }.bind(this));\n\n            this.reload();\n        },\n\n        /**\n         * Logic to toggle ascend and descend sorting for headers\n         *\n         * @param {KnockoutObservableArray} property\n         */\n        sortByHeader: function (property) {\n            var ascend,\n                activeLabel,\n                allLabels,\n                placeholder;\n\n            if (property().name === 'actions') {\n                return;\n            }\n\n            if (property().columnsHeaderClasses) {\n                activeLabel = $.extend({}, property());\n                activeLabel.columnsHeaderClasses =\n                    property().columnsHeaderClasses === '_ascend' ? '_descend' : '_ascend';\n                ascend = activeLabel.columnsHeaderClasses === '_ascend';\n                property(activeLabel);\n            } else {\n                allLabels = this.labels().slice();\n                allLabels.forEach(function (label) {\n\n                    if (label.name === property().name) {\n                        label.columnsHeaderClasses = '_ascend';\n                    } else {\n                        label.columnsHeaderClasses = '';\n                    }\n                });\n                ascend = true;\n                this.labels(allLabels);\n            }\n\n            if (this.recordData().length) {\n                placeholder = this.emptyContentPlaceholder;\n\n                this.emptyContentPlaceholder = false;\n                this.sortRecord(property().name, ascend);\n                this.reload();\n                this.emptyContentPlaceholder = placeholder;\n            }\n        },\n\n        /**\n         * Sorting of dynamic row records.\n         *\n         * @param {String} sortBy\n         * @param {Boolean} ascend\n         */\n        sortRecord: function (sortBy, ascend) {\n            this.recordData.sort(function (left, right) {\n                var record1 = ascend ? left : right,\n                    record2 = ascend ? right : left;\n\n                record1 = sortValueValidator(record1[sortBy]);\n                record2 = sortValueValidator(record2[sortBy]);\n\n                return record1 === record2 ? 0 : record1 < record2 ? -1 : 1;\n            });\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n            Events.off(this.name);\n        }\n    });\n});\n","Magento_PageBuilder/js/types/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/panel/menu.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\"], function (_knockout) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Menu = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Menu constructor\n     *\n     * @param id\n     * @param menu\n     * @param contentTypes\n     * @param stageId\n     */\n    function Menu(id, menu, contentTypes, stageId) {\n      if (contentTypes === void 0) {\n        contentTypes = [];\n      }\n\n      this.hidden = _knockout.observable(false);\n      this.id = _knockout.observable();\n      this.code = _knockout.observable(\"\");\n      this.label = _knockout.observable(\"\");\n      this.icon = _knockout.observable(\"\");\n      this.sort = _knockout.observable();\n      this.contentTypes = _knockout.observableArray([]);\n      this.active = _knockout.observable(false);\n      this.id(id);\n      this.code(menu.code);\n      this.label(menu.label);\n      this.icon(menu.icon);\n      this.sort(menu.sort);\n      this.contentTypes(contentTypes);\n      this.stageId = stageId;\n    }\n    /**\n     * Toggle the menu\n     */\n\n\n    var _proto = Menu.prototype;\n\n    _proto.toggle = function toggle() {\n      this.active(!this.active());\n    };\n\n    return Menu;\n  }();\n\n  return {\n    Menu: Menu\n  };\n});\n//# sourceMappingURL=menu.js.map","Magento_PageBuilder/js/panel/menu/content-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/drag-drop/matrix\"], function (_knockout, _matrix) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ContentType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {string} identifier\n     * @param {ContentTypeConfigInterface} config\n     * @param {string} stageId\n     */\n    function ContentType(identifier, config, stageId) {\n      this.droppable = true;\n      this.icon = _knockout.observable(\"\");\n      this.identifier = _knockout.observable(\"\");\n      this.label = _knockout.observable(\"\");\n      this.config = config;\n      this.identifier(identifier);\n      this.label(config.label);\n      this.icon(config.icon);\n      this.stageId = stageId;\n    }\n    /**\n     * Retrieve the config object\n     *\n     * @returns {ContentTypeConfigInterface}\n     */\n\n\n    var _proto = ContentType.prototype;\n\n    _proto.getConfig = function getConfig() {\n      return this.config;\n    }\n    /**\n     * Only connect to container sortable instances that the current content type is accepted into\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getDraggableOptions = function getDraggableOptions() {\n      return {\n        connectToSortable: (0, _matrix.getAllowedContainersClasses)(this.config.name, this.stageId)\n      };\n    };\n\n    return ContentType;\n  }();\n\n  return {\n    ContentType: ContentType\n  };\n});\n//# sourceMappingURL=content-type.js.map","Magento_PageBuilder/js/widget/show-on-hover.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    /**\n     * Show the overlay on hover of specific elements\n     *\n     * @param {JQuery<Element>[]} $elements\n     */\n    function showOverlayOnHover($elements) {\n        $elements.each(function (index, element) {\n            var overlayEl = $(element).find('.pagebuilder-overlay'),\n                overlayColor = overlayEl.attr('data-overlay-color');\n\n            $(element).on('mouseenter', function () {\n                overlayEl.css('background-color', overlayColor);\n            });\n\n            $(element).on('mouseleave', function () {\n                overlayEl.css('background-color', 'transparent');\n            });\n        });\n    }\n\n    /**\n     * Show button on hover of specific elements\n     *\n     * @param {JQuery<Element>[]} $elements\n     * @param {String} buttonClass\n     */\n    function showButtonOnHover($elements, buttonClass) {\n        $elements.each(function (index, element) {\n            var buttonEl = $(element).find(buttonClass);\n\n            $(element).on('mouseenter', function () {\n                buttonEl.css({\n                    'opacity': '1',\n                    'visibility': 'visible'\n                });\n            });\n\n            $(element).on('mouseleave', function () {\n                buttonEl.css({\n                    'opacity': '0',\n                    'visibility': 'hidden'\n                });\n            });\n        });\n    }\n\n    return function (config) {\n\n        var buttonSelector = config.buttonSelector,\n            overlayHoverSelector = 'div[data-content-type=\"%s\"][data-show-overlay=\"%s\"]'\n                .replace('%s', config.dataRole)\n                .replace('%s', config.showOverlay),\n            overlayButtonSelector = 'div[data-content-type=\"%s\"][data-show-button=\"%s\"]'\n                .replace('%s', config.dataRole)\n                .replace('%s', config.showOverlay);\n\n        showOverlayOnHover($(overlayHoverSelector));\n        showButtonOnHover($(overlayButtonSelector), buttonSelector);\n    };\n});\n","Magento_PageBuilder/js/widget/video-background.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jarallax',\n    'jarallaxVideo',\n    'vimeoWrapper'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = $element.data('enableParallax') !== 1 ? 1 : parseFloat($element.data('parallaxSpeed'));\n\n        if ($element.data('background-type') !== 'video') {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        window.jarallax($element[0], {\n            imgSrc: $element.data('videoFallbackSrc'),\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5,\n            videoLoop: $element.data('videoLoop'),\n            videoPlayOnlyVisible: $element.data('videoPlayOnlyVisible'),\n            videoLazyLoading: $element.data('videoLazyLoad'),\n            disableVideo: false,\n            elementInViewport: $element.data('elementInViewport') &&\n                $element[0].querySelector($element.data('elementInViewport'))\n        });\n        $element[0].jarallax.video && $element[0].jarallax.video.on('started', function () {\n            if ($element[0].jarallax.$video) {\n                $element[0].jarallax.$video.style.visibility = 'visible';\n            }\n        });\n    };\n});\n","Magento_PageBuilder/js/converter/converter-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConverterPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConverterPool() {\n      this.converters = {};\n    }\n\n    var _proto = ConverterPool.prototype;\n\n    /**\n     * Retrieve a converter from the pool\n     *\n     * @param {string} name\n     * @returns {ConverterInterface}\n     */\n    _proto.get = function get(name) {\n      return this.converters[name] !== undefined ? this.converters[name] : null;\n    }\n    /**\n     * Register a new converter into the pool\n     *\n     * @param {string} name\n     * @param {ConverterInterface} converter\n     */\n    ;\n\n    _proto.register = function register(name, converter) {\n      this.converters[name] = converter;\n    };\n\n    return ConverterPool;\n  }();\n\n  var _default = new ConverterPool();\n\n  return _default;\n});\n//# sourceMappingURL=converter-pool.js.map","Magento_PageBuilder/js/converter/converter-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=converter-interface.js.map","Magento_PageBuilder/js/converter/converter-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/converter/converter-pool\"], function (_config, _loader, _converterPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of converter pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var converters = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (appearance !== undefined && appearance.elements !== undefined) {\n        var elementName = void 0;\n\n        for (var _i2 = 0, _Object$keys2 = Object.keys(appearance.elements); _i2 < _Object$keys2.length; _i2++) {\n          elementName = _Object$keys2[_i2];\n\n          if (appearance.elements[elementName].style !== undefined) {\n            for (var _iterator = _createForOfIteratorHelperLoose(appearance.elements[elementName].style), _step; !(_step = _iterator()).done;) {\n              var propertyConfig = _step.value;\n\n              if (!!propertyConfig.converter && converters.indexOf(propertyConfig.converter) === -1 && !_converterPool.get(propertyConfig.converter)) {\n                converters.push(propertyConfig.converter);\n              }\n\n              if (!!propertyConfig.preview_converter && converters.indexOf(propertyConfig.preview_converter) === -1 && !_converterPool.get(propertyConfig.preview_converter)) {\n                converters.push(propertyConfig.preview_converter);\n              }\n            }\n          }\n\n          if (appearance.elements[elementName].attributes !== undefined) {\n            for (var _iterator2 = _createForOfIteratorHelperLoose(appearance.elements[elementName].attributes), _step2; !(_step2 = _iterator2()).done;) {\n              var attributeConfig = _step2.value;\n\n              if (!!attributeConfig.converter && converters.indexOf(attributeConfig.converter) === -1 && !_converterPool.get(attributeConfig.converter)) {\n                converters.push(attributeConfig.converter);\n              }\n\n              if (!!attributeConfig.preview_converter && converters.indexOf(attributeConfig.preview_converter) === -1 && !_converterPool.get(attributeConfig.preview_converter)) {\n                converters.push(attributeConfig.preview_converter);\n              }\n            }\n          }\n\n          if (appearance.elements[elementName].html !== undefined) {\n            var htmlConfig = appearance.elements[elementName].html;\n\n            if (!!htmlConfig.converter && converters.indexOf(htmlConfig.converter) === -1 && !_converterPool.get(htmlConfig.converter)) {\n              converters.push(htmlConfig.converter);\n            }\n\n            if (!!htmlConfig.preview_converter && converters.indexOf(htmlConfig.preview_converter) === -1 && !_converterPool.get(htmlConfig.preview_converter)) {\n              converters.push(htmlConfig.preview_converter);\n            }\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(converters, function () {\n        for (var _len = arguments.length, loadedConverters = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedConverters[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < converters.length; i++) {\n          _converterPool.register(converters[i], new loadedConverters[i]());\n        }\n\n        resolve(_converterPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=converter-pool-factory.js.map","Magento_PageBuilder/js/converter/attribute/link-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForLinkType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForLinkType() {}\n\n    var _proto = CreateValueForLinkType.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value && value.type ? value.type : \"default\";\n    };\n\n    return CreateValueForLinkType;\n  }();\n\n  return CreateValueForLinkType;\n});\n//# sourceMappingURL=link-type.js.map","Magento_PageBuilder/js/converter/attribute/video-overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.video_overlay_color) {\n        return data.video_overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=video-overlay-color.js.map","Magento_PageBuilder/js/converter/attribute/link-href.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForHref = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForHref() {\n      this.widgetParamsByLinkType = {\n        category: {\n          type: \"Magento\\\\Catalog\\\\Block\\\\Category\\\\Widget\\\\Link\",\n          id_path: \"category/:href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"Catalog Category Link\"\n        },\n        product: {\n          type: \"Magento\\\\Catalog\\\\Block\\\\Product\\\\Widget\\\\Link\",\n          id_path: \"product/:href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"Catalog Product Link\"\n        },\n        page: {\n          type: \"Magento\\\\Cms\\\\Block\\\\Widget\\\\Page\\\\Link\",\n          page_id: \":href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"CMS Page Link\"\n        }\n      };\n    }\n\n    var _proto = CreateValueForHref.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var link = (0, _object.get)(data, name);\n      var href = \"\";\n\n      if (!link) {\n        return href;\n      }\n\n      var linkType = link.type;\n      var isHrefId = !isNaN(parseInt(link[linkType], 10));\n\n      if (isHrefId && link) {\n        href = this.convertToWidget(link[linkType], linkType);\n      } else if (typeof link[linkType] === \"string\") {\n        href = link[linkType];\n      }\n\n      return href;\n    }\n    /**\n     * @param {string} href\n     * @param {string} linkType\n     * @returns {string}\n     */\n    ;\n\n    _proto.convertToWidget = function convertToWidget(href, linkType) {\n      if (!href || !this.widgetParamsByLinkType[linkType]) {\n        return href;\n      }\n\n      var attributesString = _underscore.map(this.widgetParamsByLinkType[linkType], function (val, key) {\n        return key + \"='\" + val.replace(\":href\", href) + \"'\";\n      }).join(\" \");\n\n      return \"{{widget \" + attributesString + \" }}\";\n    };\n\n    return CreateValueForHref;\n  }();\n\n  return CreateValueForHref;\n});\n//# sourceMappingURL=link-href.js.map","Magento_PageBuilder/js/converter/attribute/link-target.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForTarget = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForTarget() {}\n\n    var _proto = CreateValueForTarget.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!value) {\n        return \"\";\n      }\n\n      return value.setting ? \"_blank\" : \"\";\n    };\n\n    return CreateValueForTarget;\n  }();\n\n  return CreateValueForTarget;\n});\n//# sourceMappingURL=link-target.js.map","Magento_PageBuilder/js/converter/attribute/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/image\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/utils/url\"], function (_config, _image, _object, _url) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (!value) {\n        return \"\";\n      }\n\n      return (0, _image.decodeUrl)(value);\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value[0] === undefined || value[0].url === undefined) {\n        return \"\";\n      }\n\n      var imageUrl = value[0].url;\n      var mediaUrl = (0, _url.convertUrlToPathIfOtherUrlIsOnlyAPath)(_config.getConfig(\"media_url\"), imageUrl);\n      var mediaPath = imageUrl.split(mediaUrl);\n      return \"{{media url=\" + mediaPath[1] + \"}}\";\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/converter/attribute/preview/store-id.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var StoreId = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StoreId() {}\n\n    var _proto = StoreId.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (typeof data[name] !== \"string\") {\n        return \"\";\n      }\n\n      var storeId = (0, _jquery)('[data-role=\"store-view-id\"]').val() || \"0\";\n      return data[name].replace(/}}$/, \" store_id=\\\"\" + storeId + \"\\\"}}\");\n    };\n\n    return StoreId;\n  }();\n\n  return StoreId;\n});\n//# sourceMappingURL=store-id.js.map","Magento_PageBuilder/js/converter/attribute/preview/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && typeof value[0] === \"object\") {\n        return value[0].url;\n      }\n\n      return \"\";\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/converter/html/decode.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/object\"], function (_directives, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Decode = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Decode() {}\n\n    var _proto = Decode.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      // Convert the encoded string back to HTML without executing\n      var html = new DOMParser().parseFromString(value, \"text/html\");\n      return html.body.textContent;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _directives.removeQuotesInMediaDirectives)((0, _object.get)(data, name));\n    };\n\n    return Decode;\n  }();\n\n  return Decode;\n});\n//# sourceMappingURL=decode.js.map","Magento_PageBuilder/js/converter/html/tag-escaper.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var TagEscaper = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function TagEscaper() {}\n\n    var _proto = TagEscaper.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var result = (0, _underscore.unescape)(value); // Have to do a manual &nbsp; replace since underscore un-escape does not un-escape &nbsp;\n\n      return result.replace(/&nbsp;/g, String.fromCharCode(160));\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _underscore.escape)((0, _object.get)(data, name));\n    };\n\n    return TagEscaper;\n  }();\n\n  return TagEscaper;\n});\n//# sourceMappingURL=tag-escaper.js.map","Magento_PageBuilder/js/converter/html/directive.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/object\"], function (_directives, _editor, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Directives = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Directives() {}\n\n    var _proto = Directives.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _editor.encodeContent)((0, _directives.convertMediaDirectivesToUrls)((0, _directives.removeQuotesInMediaDirectives)((0, _object.get)(data, name))));\n    };\n\n    return Directives;\n  }();\n\n  return Directives;\n});\n//# sourceMappingURL=directive.js.map","Magento_PageBuilder/js/converter/style/border-style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BorderStyleDefault = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BorderStyleDefault() {}\n\n    var _proto = BorderStyleDefault.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (!value) {\n        return \"_default\";\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && value !== \"_default\") {\n        return value;\n      }\n    };\n\n    return BorderStyleDefault;\n  }();\n\n  return BorderStyleDefault;\n});\n//# sourceMappingURL=border-style.js.map","Magento_PageBuilder/js/converter/style/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, we only provide a none property if we intend for the content type to be hidden,\n     * otherwise we let the original display property handle the display of the content type.\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return;\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/converter/style/background-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BackgroundImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImage() {}\n\n    var _proto = BackgroundImage.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return null;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return null;\n    };\n\n    return BackgroundImage;\n  }();\n\n  return BackgroundImage;\n});\n//# sourceMappingURL=background-image.js.map","Magento_PageBuilder/js/converter/style/overlay-border-radius.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Takes difference of border width from border radius to conform snugly to edges of wrapper border\n   *\n   * @api\n   */\n  var OverlayBorderRadius = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBorderRadius() {}\n\n    var _proto = OverlayBorderRadius.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var borderRadius = data.border_radius ? parseInt(data.border_radius, 10) : 0;\n      var borderWidth = data.border_width ? parseInt(data.border_width, 10) : 0;\n\n      if (borderRadius <= borderWidth) {\n        return \"0\";\n      }\n\n      return borderRadius - borderWidth + \"px\";\n    };\n\n    return OverlayBorderRadius;\n  }();\n\n  return OverlayBorderRadius;\n});\n//# sourceMappingURL=overlay-border-radius.js.map","Magento_PageBuilder/js/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.padding) {\n        return {\n          padding: {\n            top: value.padding.top.replace(\"px\", \"\"),\n            left: value.padding.left.replace(\"px\", \"\"),\n            right: value.padding.right.replace(\"px\", \"\"),\n            bottom: value.padding.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/converter/style/color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Color = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Color() {}\n\n    var _proto = Color.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value === \"default\" || value === \"initial\" || value === \"\") {\n        value = \"\";\n      } else {\n        var regexp = /(\\d{0,3}),\\s(\\d{0,3}),\\s(\\d{0,3})/;\n        var matches = regexp.exec(value);\n\n        if (matches) {\n          value = \"#\" + this.fromIntToHex(parseInt(matches[1], 10)) + this.fromIntToHex(parseInt(matches[2], 10)) + this.fromIntToHex(parseInt(matches[3], 10));\n        }\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _object.get)(data, name, \"\");\n    }\n    /**\n     * Convert from int to hex\n     *\n     * @param {number} value\n     * @returns {string}\n     */\n    ;\n\n    _proto.fromIntToHex = function fromIntToHex(value) {\n      var hex = value.toString(16);\n      return hex.length === 1 ? \"0\" + hex : hex;\n    };\n\n    return Color;\n  }();\n\n  return Color;\n});\n//# sourceMappingURL=color.js.map","Magento_PageBuilder/js/converter/style/video-overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoOverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoOverlayColor() {}\n\n    var _proto = VideoOverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return VideoOverlayColor;\n  }();\n\n  return VideoOverlayColor;\n});\n//# sourceMappingURL=video-overlay-color.js.map","Magento_PageBuilder/js/converter/style/border-width.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BorderWidth = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BorderWidth() {}\n\n    var _proto = BorderWidth.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"initial\" ? \"\" : value.replace(\"px\", \"\");\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value) {\n        return value + \"px\";\n      }\n    };\n\n    return BorderWidth;\n  }();\n\n  return BorderWidth;\n});\n//# sourceMappingURL=border-width.js.map","Magento_PageBuilder/js/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/converter/style/remove-px.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var RemovePx = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function RemovePx() {}\n\n    var _proto = RemovePx.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value.replace(\"px\", \"\");\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value) {\n        return value + \"px\";\n      }\n    };\n\n    return RemovePx;\n  }();\n\n  return RemovePx;\n});\n//# sourceMappingURL=remove-px.js.map","Magento_PageBuilder/js/converter/style/min-height.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var MinHeight = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function MinHeight() {}\n\n    var _proto = MinHeight.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value.indexOf(\"calc\") !== -1 ? value.substring(5, value.length - 1) : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value.split(/\\+|\\-|\\*|\\//).length > 1 ? \"calc(\" + (0, _object.get)(data, name) + \")\" : value;\n    };\n\n    return MinHeight;\n  }();\n\n  return MinHeight;\n});\n//# sourceMappingURL=min-height.js.map","Magento_PageBuilder/js/converter/style/width.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Subtract margin from width to ensure adjacent elements do not\n   * move or resize when positive or negative margins are present\n   *\n   * @api\n   */\n  var Width = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Width() {}\n\n    var _proto = Width.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value.indexOf(\"calc\") !== -1) {\n        return value.split(\"%\")[0].split(\"(\")[1] + \"%\";\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data[name] && data[name] !== \"\") {\n        var marginsAndPadding = data.margins_and_padding || {};\n        var margins = marginsAndPadding.margin || \"\";\n        var marginLeft = margins.left ? parseInt(margins.left, 10) : 0;\n        var marginRight = margins.right ? parseInt(margins.right, 10) : 0;\n\n        if (marginLeft === 0 && marginRight === 0) {\n          return data[name].toString();\n        }\n\n        return \"calc(\" + data[name].toString() + \" - \" + (marginLeft + marginRight) + \"px)\";\n      }\n    };\n\n    return Width;\n  }();\n\n  return Width;\n});\n//# sourceMappingURL=width.js.map","Magento_PageBuilder/js/converter/style/preview/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return;\n    }\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return;\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/converter/style/preview/background-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BackgroundImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImage() {}\n\n    var _proto = BackgroundImage.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && typeof value[0] === \"object\") {\n        return \"url(\" + value[0].url + \")\";\n      }\n\n      return \"\";\n    };\n\n    return BackgroundImage;\n  }();\n\n  return BackgroundImage;\n});\n//# sourceMappingURL=background-image.js.map","Magento_PageBuilder/js/property/attribute-reader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var AttributeReader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function AttributeReader() {}\n\n    var _proto = AttributeReader.prototype;\n\n    /**\n     * Read attribute from element\n     *\n     * @param {HTMLElement} element\n     * @param {string} source\n     * @returns {string | object}\n     */\n    _proto.read = function read(element, source) {\n      return element.getAttribute(source);\n    };\n\n    return AttributeReader;\n  }();\n\n  return AttributeReader;\n});\n//# sourceMappingURL=attribute-reader.js.map","Magento_PageBuilder/js/property/property-reader-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PropertyReaderPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function PropertyReaderPool() {\n      this.propertyReaders = {};\n    }\n\n    var _proto = PropertyReaderPool.prototype;\n\n    /**\n     * Retrieve a property reader from the pool\n     *\n     * @param {string} name\n     * @returns {PropertyReaderInterface}\n     */\n    _proto.get = function get(name) {\n      return this.propertyReaders[name] !== undefined ? this.propertyReaders[name] : null;\n    }\n    /**\n     * Register a new property reader into the pool\n     *\n     * @param {string} name\n     * @param {PropertyReaderInterface} property\n     */\n    ;\n\n    _proto.register = function register(name, property) {\n      this.propertyReaders[name] = property;\n    };\n\n    return PropertyReaderPool;\n  }();\n\n  var _default = new PropertyReaderPool();\n\n  return Object.assign(_default, {\n    PropertyReaderPool: PropertyReaderPool\n  });\n});\n//# sourceMappingURL=property-reader-pool.js.map","Magento_PageBuilder/js/property/link.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Link = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Link() {\n      this.regexpByLinkType = {\n        category: new RegExp(/id_path=['\"]category\\/(\\d+)/),\n        product: new RegExp(/id_path=['\"]product\\/(\\d+)/),\n        page: new RegExp(/page_id=['\"](\\d+)/)\n      };\n    }\n\n    var _proto = Link.prototype;\n\n    /**\n     * Read link from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      var _ref;\n\n      var href = element.getAttribute(\"href\");\n      var attributeLinkType = element.getAttribute(\"data-link-type\");\n\n      if (typeof href === \"string\" && attributeLinkType !== \"default\") {\n        href = this.getIdFromWidgetSyntax(href, this.regexpByLinkType[attributeLinkType]);\n      }\n\n      return _ref = {}, _ref[attributeLinkType] = href, _ref.setting = element.getAttribute(\"target\") === \"_blank\", _ref.type = attributeLinkType, _ref;\n    }\n    /**\n     * Returns link value from widget string\n     *\n     * @param {string} href\n     * @param {RegExp} regexp\n     * @return {string}\n     */\n    ;\n\n    _proto.getIdFromWidgetSyntax = function getIdFromWidgetSyntax(href, regexp) {\n      var attributeIdMatches = href.match(regexp);\n\n      if (!attributeIdMatches) {\n        return href;\n      }\n\n      return attributeIdMatches[1];\n    };\n\n    return Link;\n  }();\n\n  return Link;\n});\n//# sourceMappingURL=link.js.map","Magento_PageBuilder/js/property/property-reader-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=property-reader-interface.js.map","Magento_PageBuilder/js/property/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Read paddings from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      return {\n        padding: {\n          left: element.style.paddingLeft,\n          top: element.style.paddingTop,\n          right: element.style.paddingRight,\n          bottom: element.style.paddingBottom\n        }\n      };\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/property/style-property-reader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/string\"], function (_string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var StylePropertyReader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StylePropertyReader() {}\n\n    var _proto = StylePropertyReader.prototype;\n\n    /**\n     * Read style property from element\n     *\n     * @param {HTMLElement} element\n     * @param {string} source\n     * @returns {string | object}\n     */\n    _proto.read = function read(element, source) {\n      var camelCasedSource = (0, _string.fromSnakeToCamelCase)(source);\n      return element.style[camelCasedSource];\n    };\n\n    return StylePropertyReader;\n  }();\n\n  return StylePropertyReader;\n});\n//# sourceMappingURL=style-property-reader.js.map","Magento_PageBuilder/js/property/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Read margins from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      return {\n        margin: {\n          left: element.style.marginLeft,\n          top: element.style.marginTop,\n          right: element.style.marginRight,\n          bottom: element.style.marginBottom\n        }\n      };\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/property/property-reader-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/property/property-reader-pool\"], function (_config, _loader, _propertyReaderPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of property reader pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var propertyReaders = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (appearance !== undefined && appearance.elements !== undefined) {\n        var elementName = void 0;\n\n        for (var _i2 = 0, _Object$keys2 = Object.keys(appearance.elements); _i2 < _Object$keys2.length; _i2++) {\n          elementName = _Object$keys2[_i2];\n          var element = appearance.elements[elementName];\n\n          if (element.style !== undefined) {\n            for (var _iterator = _createForOfIteratorHelperLoose(element.style), _step; !(_step = _iterator()).done;) {\n              var propertyConfig = _step.value;\n\n              if (propertyConfig.reader && propertyReaders.indexOf(propertyConfig.reader) === -1 && !_propertyReaderPool.get(propertyConfig.reader)) {\n                propertyReaders.push(propertyConfig.reader);\n              }\n            }\n          }\n\n          if (element.attributes !== undefined) {\n            for (var _iterator2 = _createForOfIteratorHelperLoose(element.attributes), _step2; !(_step2 = _iterator2()).done;) {\n              var attributeConfig = _step2.value;\n\n              if (attributeConfig.reader && propertyReaders.indexOf(attributeConfig.reader) === -1 && !_propertyReaderPool.get(attributeConfig.reader)) {\n                propertyReaders.push(attributeConfig.reader);\n              }\n            }\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(propertyReaders, function () {\n        for (var _len = arguments.length, loadedPropertyReaders = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedPropertyReaders[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < propertyReaders.length; i++) {\n          _propertyReaderPool.register(propertyReaders[i], new loadedPropertyReaders[i]());\n        }\n\n        resolve(_propertyReaderPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=property-reader-pool-factory.js.map","Magento_PageBuilder/js/mass-converter/background-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var BackgroundType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundType() {}\n\n    var _proto = BackgroundType.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var backgroundType = (0, _object.get)(data, config.attribute_name);\n\n      if (backgroundType === \"video\") {\n        (0, _object.set)(data, config.desktop_image_variable, []);\n        (0, _object.set)(data, config.mobile_image_variable, []);\n      } else if (backgroundType === \"image\") {\n        (0, _object.set)(data, config.video_source_variable, null);\n        (0, _object.set)(data, config.video_fallback_image_variable, []);\n        (0, _object.set)(data, config.video_overlay_color_variable, \"\");\n      }\n\n      return data;\n    };\n\n    return BackgroundType;\n  }();\n\n  return BackgroundType;\n});\n//# sourceMappingURL=background-type.js.map","Magento_PageBuilder/js/mass-converter/empty-mobile-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var EmptyMobileImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function EmptyMobileImage() {}\n\n    var _proto = EmptyMobileImage.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var desktopImage = (0, _object.get)(data, config.desktop_image_variable);\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n\n      if (mobileImage && desktopImage && mobileImage[0] !== undefined && desktopImage[0] !== undefined && mobileImage[0].url === desktopImage[0].url) {\n        delete data[config.mobile_image_variable];\n      }\n\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n\n      if (mobileImage === undefined || mobileImage[0] === undefined) {\n        (0, _object.set)(data, config.mobile_image_variable, (0, _object.get)(data, config.desktop_image_variable));\n      }\n\n      return data;\n    };\n\n    return EmptyMobileImage;\n  }();\n\n  return EmptyMobileImage;\n});\n//# sourceMappingURL=empty-mobile-image.js.map","Magento_PageBuilder/js/mass-converter/converter-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var DataConverterPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function DataConverterPool() {\n      this.converters = {};\n    }\n\n    var _proto = DataConverterPool.prototype;\n\n    /**\n     * Retrieve a data converter instance from the pool\n     *\n     * @param {string} name\n     * @returns {ConverterInterface}\n     */\n    _proto.get = function get(name) {\n      return this.converters[name] !== undefined ? this.converters[name] : null;\n    }\n    /**\n     * Register a new data converter into the pool\n     *\n     * @param {string} name\n     * @param {ConverterInterface} converter\n     */\n    ;\n\n    _proto.register = function register(name, converter) {\n      this.converters[name] = converter;\n    };\n\n    return DataConverterPool;\n  }();\n\n  var _default = new DataConverterPool();\n\n  return _default;\n});\n//# sourceMappingURL=converter-pool.js.map","Magento_PageBuilder/js/mass-converter/background-images.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/image\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _image, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var BackgroundImages = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImages() {}\n\n    var _proto = BackgroundImages.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var directive = (0, _object.get)(data, config.attribute_name);\n\n      if (directive) {\n        var images = JSON.parse(directive.replace(/\\\\(.)/mg, \"$1\")) || {};\n\n        if (!_underscore.isUndefined(images.desktop_image)) {\n          (0, _object.set)(data, config.desktop_image_variable, (0, _image.decodeUrl)(images.desktop_image));\n        }\n\n        if (!_underscore.isUndefined(images.mobile_image)) {\n          (0, _object.set)(data, config.mobile_image_variable, (0, _image.decodeUrl)(images.mobile_image));\n        }\n\n        delete data[config.attribute_name];\n      }\n\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var desktopImage = (0, _object.get)(data, config.desktop_image_variable);\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n      var directiveData = {};\n\n      if (!_underscore.isUndefined(desktopImage) && desktopImage && !_underscore.isUndefined(desktopImage[0])) {\n        directiveData.desktop_image = (0, _image.urlToDirective)(desktopImage[0].url);\n      }\n\n      if (!_underscore.isUndefined(mobileImage) && mobileImage && !_underscore.isUndefined(mobileImage[0])) {\n        directiveData.mobile_image = (0, _image.urlToDirective)(mobileImage[0].url);\n      } // Add the directive data, ensuring we escape double quotes\n\n\n      (0, _object.set)(data, config.attribute_name, JSON.stringify(directiveData).replace(/[\\\\\"']/g, \"\\\\$&\").replace(/\\u0000/g, \"\\\\0\"));\n      return data;\n    };\n\n    return BackgroundImages;\n  }();\n\n  return BackgroundImages;\n});\n//# sourceMappingURL=background-images.js.map","Magento_PageBuilder/js/mass-converter/converter-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=converter-interface.js.map","Magento_PageBuilder/js/mass-converter/widget-directive-abstract.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var WidgetDirectiveAbstract = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function WidgetDirectiveAbstract() {}\n\n    var _proto = WidgetDirectiveAbstract.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {WidgetDirectiveAttributes}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var _this = this;\n\n      var attributes = {};\n      (0, _object.get)(data, config.html_variable).replace(/\\{\\{widget([\\S\\s]*?)\\}\\}/i, function (match, attributeString) {\n        attributes = _this.parseAttributesString(attributeString);\n      }.bind(this));\n      return attributes;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      (0, _object.set)(data, config.html_variable, this.buildDirective(data));\n      return data;\n    }\n    /**\n     * Build the directive string using the supplies attributes\n     *\n     * @param {object} attributes\n     * @returns {string}\n     */\n    ;\n\n    _proto.buildDirective = function buildDirective(attributes) {\n      return \"{{widget \" + this.createAttributesString(attributes) + \"}}\";\n    }\n    /**\n     * @param {string} attributes\n     * @return {Object}\n     */\n    ;\n\n    _proto.parseAttributesString = function parseAttributesString(attributes) {\n      var result = {};\n      attributes.replace(/(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/g, function (match, key, value) {\n        result[key] = value.replace(/&quote;/g, \"\\\"\");\n        return \"\";\n      });\n      return result;\n    }\n    /**\n     * @param {Object} attributes\n     * @return {string}\n     */\n    ;\n\n    _proto.createAttributesString = function createAttributesString(attributes) {\n      var result = \"\";\n\n      _underscore.each(attributes, function (value, name) {\n        result += name + \"=\\\"\" + String(value).replace(/\"/g, \"&quote;\") + \"\\\" \";\n      });\n\n      return result.substr(0, result.length - 1);\n    };\n\n    return WidgetDirectiveAbstract;\n  }();\n\n  return WidgetDirectiveAbstract;\n});\n//# sourceMappingURL=widget-directive-abstract.js.map","Magento_PageBuilder/js/mass-converter/converter-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/mass-converter/converter-pool\"], function (_config, _loader, _converterPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of converter pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var converters = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (undefined !== appearance && undefined !== appearance.converters) {\n        for (var _iterator = _createForOfIteratorHelperLoose(appearance.converters), _step; !(_step = _iterator()).done;) {\n          var converterConfig = _step.value;\n\n          if (!!converterConfig.component && !_converterPool.get(converterConfig.component)) {\n            converters.push(converterConfig.component);\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(converters, function () {\n        for (var _len = arguments.length, loadedConverters = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedConverters[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < converters.length; i++) {\n          _converterPool.register(converters[i], new loadedConverters[i]());\n        }\n\n        resolve(_converterPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=converter-pool-factory.js.map","Magento_PageBuilder/js/wysiwyg/factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"Magento_PageBuilder/js/utils/loader\"], function (_jquery, _loader) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @param {String} contentTypeId The ID in the registry of the content type.\n   * @param {String} elementId The ID of the editor element in the DOM.\n   * @param {String} contentTypeName The type of content type this editor will be used in. E.g. \"banner\".\n   * @param {AdditionalDataConfigInterface} config The configuration for the wysiwyg.\n   * @param {DataStore} dataStore The datastore to store the content in.\n   * @param {String} fieldName The key in the provided datastore to set the data.\n   * @param {String} stageId The ID in the registry of the stage containing the content type.\n   * @returns {Wysiwyg}\n   */\n  function create(contentTypeId, elementId, contentTypeName, config, dataStore, fieldName, stageId) {\n    config = _jquery.extend(true, {}, config);\n    return new Promise(function (resolve) {\n      (0, _loader)([config.adapter_config.component], function (WysiwygInstance) {\n        new Promise(function (configResolve) {\n          if (config.adapter_config.config_modifiers && config.adapter_config.config_modifiers[contentTypeName]) {\n            (0, _loader)([config.adapter_config.config_modifiers[contentTypeName]], function (ConfigModifierType) {\n              var modifier = new ConfigModifierType(); // Allow dynamic settings to be set before editor is initialized\n\n              modifier.modify(contentTypeId, config);\n              configResolve();\n            });\n          } else {\n            configResolve();\n          }\n        }).then(function () {\n          // Instantiate the component\n          var wysiwyg = new WysiwygInstance(contentTypeId, elementId, config, dataStore, fieldName, stageId);\n\n          if (config.adapter_config.component_initializers && config.adapter_config.component_initializers[contentTypeName]) {\n            (0, _loader)([config.adapter_config.component_initializers[contentTypeName]], function (InitializerType) {\n              var initializer = new InitializerType(); // Allow dynamic bindings from configuration such as events from the editor\n\n              initializer.initialize(wysiwyg);\n              resolve(wysiwyg);\n            });\n          } else {\n            resolve(wysiwyg);\n          }\n        });\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=factory.js.map","Magento_PageBuilder/js/wysiwyg/config-modifier-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=config-modifier-interface.js.map","Magento_PageBuilder/js/wysiwyg/tinymce.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\", \"mage/adminhtml/wysiwyg/tiny_mce/setup\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/utils/check-stage-full-screen\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/pagebuilder-header-height\"], function (_jquery, _events, _setup, _events2, _underscore, _checkStageFullScreen, _delayUntil, _pagebuilderHeaderHeight) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Inline editing wysiwyg component\n   *\n   * @api\n   */\n  var Wysiwyg = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * The id of the editor element\n     */\n\n    /**\n     * The supplied wysiwyg configuration\n     */\n\n    /**\n     * Id of content type\n     */\n\n    /**\n     * Id of the stage\n     */\n\n    /**\n     * Wysiwyg adapter instance\n     */\n\n    /**\n     * Content type's data store\n     */\n\n    /**\n     * Field name in data store reflecting value held in wysiwyg\n     */\n\n    /**\n     * Create a debounce to save the content into the data store\n     */\n\n    /**\n     * @param {String} contentTypeId The ID in the registry of the content type.\n     * @param {String} elementId The ID of the editor element in the DOM.\n     * @param {AdditionalDataConfigInterface} config The configuration for the wysiwyg.\n     * @param {DataStore} dataStore The datastore to store the content in.\n     * @param {String} fieldName The key in the provided datastore to set the data.\n     * @param {String} stageId The ID in the registry of the stage containing the content type.\n     */\n    function Wysiwyg(contentTypeId, elementId, config, dataStore, fieldName, stageId) {\n      this.saveContentDebounce = _underscore.debounce(this.saveContentFromWysiwygToDataStore.bind(this), 500);\n      this.contentTypeId = contentTypeId;\n      this.elementId = elementId;\n      this.fieldName = fieldName;\n      this.config = config;\n      this.dataStore = dataStore;\n      this.stageId = stageId;\n\n      if (this.config.adapter_config.mode === \"inline\") {\n        /**\n         * Don't include content_css within the inline mode of TinyMCE, if any stylesheets are included here they're\n         * appended to the head of the main page, and thus cause other styles to be modified.\n         *\n         * The styles for typography in the inline editor are scoped within _typography.less\n         */\n        this.config.adapter.tinymce.content_css = [];\n      }\n\n      var wysiwygSetup = new _setup(this.elementId, this.config.adapter);\n      wysiwygSetup.setup(this.config.adapter_config.mode);\n      this.wysiwygAdapter = wysiwygSetup.wysiwygInstance;\n\n      if (this.config.adapter_config.mode === \"inline\") {\n        this.wysiwygAdapter.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n        this.wysiwygAdapter.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n      } // Update content in our data store after our stage preview wysiwyg gets updated\n\n\n      this.wysiwygAdapter.eventBus.attachEventHandler(_events.afterChangeContent, this.onChangeContent.bind(this)); // Update content in our stage preview wysiwyg after its slideout counterpart gets updated\n\n      _events2.on(\"form:\" + this.contentTypeId + \":saveAfter\", this.setContentFromDataStoreToWysiwyg.bind(this));\n\n      _events2.on(\"stage:\" + this.stageId + \":fullScreenModeChangeAfter\", this.toggleFullScreen.bind(this));\n    }\n    /**\n     * Hide TinyMce inline toolbar options after fullscreen exit\n     */\n\n\n    var _proto = Wysiwyg.prototype;\n\n    _proto.toggleFullScreen = function toggleFullScreen() {\n      var _this = this;\n\n      var $editor = (0, _jquery)(\"#\" + this.elementId); // wait for fullscreen to close\n\n      _underscore.defer(function () {\n        if (!(0, _checkStageFullScreen)(_this.stageId) && _this.config.adapter_config.mode === \"inline\" && $editor.hasClass(\"mce-edit-focus\")) {\n          $editor.removeClass(\"mce-edit-focus\");\n\n          _this.onBlur();\n        }\n      });\n    }\n    /**\n     * @returns {WysiwygInstanceInterface}\n     */\n    ;\n\n    _proto.getAdapter = function getAdapter() {\n      return this.wysiwygAdapter;\n    }\n    /**\n     * Called for the onFocus event\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this2 = this;\n\n      this.getFixedToolbarContainer().addClass(\"pagebuilder-toolbar-active\");\n\n      _events2.trigger(\"stage:interactionStart\");\n\n      var element = document.querySelector(\"#\" + this.elementId);\n\n      if (!element) {\n        return;\n      } // Wait for everything else to finish\n\n\n      _underscore.defer(function () {\n        return (0, _delayUntil)(function () {\n          var $inlineToolbar = _this2.getFixedToolbarContainer().find(\".tox-tinymce-inline\");\n\n          var self = _this2;\n          $inlineToolbar.css(\"min-width\", _this2.config.adapter_config.minToolbarWidth + \"px\");\n\n          _this2.invertInlineEditorToAccommodateOffscreenToolbar(); // Update toolbar when the height changes\n\n\n          _this2.toolbarHeight = $inlineToolbar.height();\n\n          if ($inlineToolbar.length) {\n            _this2.resizeObserver = new ResizeObserver(function (entries) {\n              for (var _iterator = _createForOfIteratorHelperLoose(entries), _step; !(_step = _iterator()).done;) {\n                var entry = _step.value;\n\n                if (entry.target === $inlineToolbar.get(0) && entry.target.clientHeight !== self.toolbarHeight) {\n                  self.invertInlineEditorToAccommodateOffscreenToolbar();\n                  self.toolbarHeight = entry.target.clientHeight;\n                }\n              }\n            });\n\n            _this2.resizeObserver.observe($inlineToolbar.get(0));\n          }\n\n          var dialogContainer = document.querySelector(\"#\" + _this2.elementId + \" ~ .tox-tinymce-aux\");\n\n          if (!!dialogContainer) {\n            dialogContainer.setAttribute(\"data-editor-aux\", _this2.elementId);\n            document.body.appendChild(dialogContainer);\n          }\n        }, function () {\n          return element.classList.contains(\"mce-edit-focus\");\n        }, 10);\n      });\n    }\n    /**\n     * Called for the onChangeContent event\n     */\n    ;\n\n    _proto.onChangeContent = function onChangeContent() {\n      this.saveContentDebounce();\n      this.invertInlineEditorToAccommodateOffscreenToolbar();\n    }\n    /**\n     * Called for the onBlur events\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      this.getFixedToolbarContainer().removeClass(\"pagebuilder-toolbar-active\").find(\".tox-tinymce-inline\").css(\"top\", \"\");\n\n      if (this.resizeObserver) {\n        this.resizeObserver.unobserve(this.getFixedToolbarContainer().find(\".tox-tinymce-inline\").get(0));\n      }\n\n      this.toolbarHeight = 0;\n      var dialogContainer = document.querySelector(\"[data-editor-aux=\" + this.elementId + \"]\");\n\n      if (!!dialogContainer) {\n        dialogContainer.removeAttribute(\"data-editor-aux\");\n        document.querySelector(\"#\" + this.elementId).parentNode.appendChild(dialogContainer);\n      }\n\n      _events2.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Update content in our data store after our stage preview wysiwyg gets updated\n     */\n    ;\n\n    _proto.saveContentFromWysiwygToDataStore = function saveContentFromWysiwygToDataStore() {\n      this.dataStore.set(this.fieldName, this.getAdapter().getContent());\n    }\n    /**\n     * Update content in our stage wysiwyg after our data store gets updated\n     */\n    ;\n\n    _proto.setContentFromDataStoreToWysiwyg = function setContentFromDataStoreToWysiwyg() {\n      this.getAdapter().setContent(this.dataStore.get(this.fieldName));\n    }\n    /**\n     * Adjust padding on stage if in fullscreen mode to accommodate inline wysiwyg toolbar overflowing fixed viewport\n     */\n    ;\n\n    _proto.invertInlineEditorToAccommodateOffscreenToolbar = function invertInlineEditorToAccommodateOffscreenToolbar() {\n      if (this.config.adapter_config.mode !== \"inline\") {\n        return;\n      }\n\n      var $inlineToolbar = this.getFixedToolbarContainer().find(\".tox-tinymce-inline\");\n\n      if (!$inlineToolbar.length) {\n        return;\n      }\n\n      var inlineWysiwygClientRectTop = this.getFixedToolbarContainer().get(0).getBoundingClientRect().top - (0, _pagebuilderHeaderHeight)(this.stageId);\n\n      if (!(0, _checkStageFullScreen)(this.stageId) || $inlineToolbar.height() < inlineWysiwygClientRectTop) {\n        var extraHeight = 0;\n\n        if ($inlineToolbar.parents(\".pagebuilder-slide[data-appearance='collage-left']\").length || $inlineToolbar.parents(\".pagebuilder-slide[data-appearance='collage-right']\").length || $inlineToolbar.parents(\".pagebuilder-slide[data-appearance='collage-centered']\").length) {\n          extraHeight = 29;\n        }\n\n        $inlineToolbar.css(\"top\", ($inlineToolbar.height() - extraHeight) * -1);\n        return;\n      }\n\n      $inlineToolbar.css(\"top\", \"\");\n    }\n    /**\n     * Get fixed toolbar container element referenced as selector in wysiwyg adapter settings\n     *\n     * @returns {jQuery}\n     */\n    ;\n\n    _proto.getFixedToolbarContainer = function getFixedToolbarContainer() {\n      return (0, _jquery)(\"#\" + this.elementId).closest(\"\" + this.config.adapter.settings.fixed_toolbar_container);\n    };\n\n    return Wysiwyg;\n  }();\n\n  return Wysiwyg;\n});\n//# sourceMappingURL=tinymce.js.map","Magento_PageBuilder/js/wysiwyg/wysiwyg-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=wysiwyg-interface.js.map","Magento_PageBuilder/js/wysiwyg/component-initializer-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=component-initializer-interface.js.map","Magento_PageBuilder/js/utils/create-stylesheet.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a stylesheet DOM object from a style block declaration\n   *\n   * @param {StyleBlocks} blocks\n   * @returns {HTMLStyleElement}\n   * @api\n   */\n  function createStyleSheet(blocks) {\n    var style = document.createElement(\"style\");\n    var text = Object.keys(blocks).map(function (selector) {\n      return selector + (\" {\\n\" + processDeclarationBlock(blocks[selector]) + \"\\n}\");\n    }).join(\"\\n\");\n    style.setAttribute(\"type\", \"text/css\");\n    style.appendChild(document.createTextNode(text));\n    return style;\n  }\n  /**\n   * Process a declaration block from the rule set\n   *\n   * @param {StyleBlock} block\n   * @returns {string}\n   */\n\n\n  function processDeclarationBlock(block) {\n    return Object.keys(block).map(function (property) {\n      return processDeclaration(property, block[property]);\n    }).join(\"\\n\");\n  }\n  /**\n   * Process a declaration, creating the property: value syntax\n   *\n   * @param {string} property\n   * @param {string | number} value\n   * @returns {string}\n   */\n\n\n  function processDeclaration(property, value) {\n    return hyphenate(property) + (\": \" + value + \";\");\n  }\n  /**\n   * Hyphenate style property, from textAlign to text-align\n   *\n   * @param {string} property\n   * @returns {string}\n   */\n\n\n  function hyphenate(property) {\n    return property.replace(/[A-Z]/g, function (match) {\n      return \"-\" + match.toLowerCase();\n    });\n  }\n\n  return {\n    createStyleSheet: createStyleSheet\n  };\n});\n//# sourceMappingURL=create-stylesheet.js.map","Magento_PageBuilder/js/utils/pagebuilder-header-height.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Checks if PageBuilder has header and returns it's height\n   *\n   * @param {string} stageId\n   * @param {string} stageWrapper\n   * @param {string} pageBuilderHeader\n   * @returns {number}\n   */\n  function pageBuilderHeaderHeight(stageId, stageWrapper, pageBuilderHeader) {\n    if (stageWrapper === void 0) {\n      stageWrapper = \".pagebuilder-stage-wrapper\";\n    }\n\n    if (pageBuilderHeader === void 0) {\n      pageBuilderHeader = \".pagebuilder-header\";\n    }\n\n    var $stageWrapper = (0, _jquery)(\"#\" + stageId).closest(stageWrapper);\n    var $pageBuilderHeader = $stageWrapper.find(pageBuilderHeader);\n    return !!$pageBuilderHeader.length ? $pageBuilderHeader.height() : 0;\n  }\n\n  return pageBuilderHeaderHeight;\n});\n//# sourceMappingURL=pagebuilder-header-height.js.map","Magento_PageBuilder/js/utils/nesting-widget-dialog.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/modal/dismissible-confirm\"], function (_jquery, _translate, _dismissibleConfirm) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate inline editor for having nested widget\n   * Creates a dialog and removes inline editor widget if present\n   *\n   * @param {DataStore} dataStore\n   * @param {WysiwygInterface} wysiwyg\n   * @param {string} inlineMessageField\n   * @param {string} linkUrlField\n   */\n  function nestingWidgetDialog(dataStore, wysiwyg, inlineMessageField, linkUrlField) {\n    var dataStoreContent = dataStore.getState();\n    var inlineMessage = dataStoreContent[inlineMessageField];\n    var linkUrl = dataStoreContent[linkUrlField];\n    var widgetRegex = /\\{\\{widget([\\S\\s]*?)\\}\\}/ig;\n    var widgetPlaceholderRegex = /<span.*(class=)(\\\"|\\').*((magento-placeholder).*(magento-widget)|(magento-widget).*(magento-placeholder)).*<\\/span>/igm;\n\n    if (wysiwyg && inlineMessage.match(widgetRegex) && linkUrl && [\"page\", \"product\", \"category\", \"default\"].indexOf(linkUrl.type) !== -1 && linkUrl[linkUrl.type] && linkUrl[linkUrl.type].length !== 0) {\n      var inlineEditor = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      inlineEditor.trigger(\"blur\");\n      (0, _dismissibleConfirm)({\n        actions: {\n          always: function always() {\n            var widgetLessDataStoreMessage = inlineMessage.replace(widgetRegex, \"\");\n            var widgetLessInlineMessage = inlineEditor.html().replace(widgetPlaceholderRegex, \"\");\n            dataStore.set(inlineMessageField, widgetLessDataStoreMessage);\n            inlineEditor.html(widgetLessInlineMessage);\n          }\n        },\n        content: (0, _translate)(\"We are unable to support widget within the content field whilst having a link set on the content type. Please remove the content type link if you'd like to set a widget within the content. We will automatically remove the widget within the content field.\"),\n        // tslint:disable-line:max-line-length\n        title: (0, _translate)(\"Nested widgets are not allowed\"),\n        haveCancelButton: false\n      });\n    }\n  }\n\n  return nestingWidgetDialog;\n});\n//# sourceMappingURL=nesting-widget-dialog.js.map","Magento_PageBuilder/js/utils/nesting-link-dialog.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/modal/dismissible-confirm\"], function (_jquery, _translate, _dismissibleConfirm) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate inline editor for having nested link\n   * Creates a dialog and removes inline editor link if present\n   *\n   * @param {DataStore} dataStore\n   * @param {WysiwygInterface} wysiwyg\n   * @param {string} inlineMessageField\n   * @param {string} linkUrlField\n   */\n  function nestingLinkDialog(dataStore, wysiwyg, inlineMessageField, linkUrlField) {\n    var dataStoreContent = dataStore.getState();\n    var inlineMessage = dataStoreContent[inlineMessageField];\n    var linkUrl = dataStoreContent[linkUrlField];\n    var aLinkRegex = /(<a[\\s]+[^>]+).+(?=<\\/a>)<\\/a>/igm;\n\n    if (wysiwyg && inlineMessage.match(aLinkRegex) && linkUrl && [\"page\", \"product\", \"category\", \"default\"].indexOf(linkUrl.type) !== -1 && linkUrl[linkUrl.type] && linkUrl[linkUrl.type].length !== 0) {\n      var inlineEditor = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      inlineEditor.trigger(\"blur\");\n      (0, _dismissibleConfirm)({\n        actions: {\n          always: function always() {\n            var anchorLessDataStoreMessage = inlineMessage.replace(aLinkRegex, \"\");\n            var anchorLessInlineMessage = inlineEditor.html().replace(aLinkRegex, \"\");\n            dataStore.set(inlineMessageField, anchorLessDataStoreMessage);\n            inlineEditor.html(anchorLessInlineMessage);\n          }\n        },\n        content: (0, _translate)(\"We are unable to support links within the content field whilst having a link set on the content type. Please remove the content type link if you'd like to set a link within the content. We will automatically remove the links within the content field.\"),\n        // tslint:disable-line:max-line-length\n        title: (0, _translate)(\"Nested links are not allowed\"),\n        haveCancelButton: false\n      });\n    }\n  }\n\n  return nestingLinkDialog;\n});\n//# sourceMappingURL=nesting-link-dialog.js.map","Magento_PageBuilder/js/utils/object.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"object-path\"], function (_objectPath) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Retrieve a value from an object via a path\n   *\n   * @param {object} object\n   * @param {string} path\n   * @param {TResult} defaultValue\n   * @returns {TResult}\n   */\n  function get(object, path, defaultValue) {\n    return _objectPath.get(object, path, defaultValue);\n  }\n  /**\n   * Set a value within an object via a path\n   *\n   * @param {object} object\n   * @param {string} path\n   * @param {TResult} value\n   * @returns {TResult | undefined}\n   */\n\n\n  function set(object, path, value) {\n    return _objectPath.set(object, path, value);\n  }\n\n  return {\n    get: get,\n    set: set\n  };\n});\n//# sourceMappingURL=object.js.map","Magento_PageBuilder/js/utils/array.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Move an array item within the current array\n   *\n   * @param array\n   * @param fromIndex\n   * @param toIndex\n   * @returns {Array<any>}\n   */\n  function moveArrayItem(array, fromIndex, toIndex) {\n    array.splice(toIndex, 0, array.splice(fromIndex, 1)[0]);\n    return array;\n  }\n  /**\n   * Move an array item from one array into another\n   *\n   * @param item\n   * @param array\n   * @param toIndex\n   * @returns {Array<any>}\n   */\n\n\n  function moveArrayItemIntoArray(item, array, toIndex) {\n    array.splice(toIndex, 0, item);\n    return array;\n  }\n  /**\n   * Remove an array item\n   *\n   * @param array\n   * @param item\n   * @returns {Array<any>}\n   */\n\n\n  function removeArrayItem(array, item) {\n    var index = array.indexOf(item);\n\n    if (index > -1) {\n      array.splice(index, 1);\n    }\n\n    return array;\n  }\n  /**\n   * Search outwards from an array item until a callback matches\n   *\n   * @author https://github.com/thejameskyle/outward-search\n   *\n   * @param {any[]} items\n   * @param {number} start\n   * @param {(item: any, index: number) => boolean} callback\n   * @returns {any}\n   * @api\n   */\n\n\n  function outwardSearch(items, start, callback) {\n    if (!items.length) {\n      return null;\n    }\n\n    if (start < 0 || start > items.length - 1) {\n      throw new TypeError(\"starting index must be within bounds of array\");\n    }\n\n    var max = items.length - 1;\n    var low = start;\n    var high = start + 1;\n\n    while (true) {\n      var hitMin = low < 0;\n      var hitMax = high > max;\n\n      if (hitMin && hitMax) {\n        break;\n      }\n\n      if (!hitMin) {\n        var _item = items[low];\n        var result = callback(_item, low);\n\n        if (!!result) {\n          return _item;\n        }\n\n        low--;\n      }\n\n      if (!hitMax) {\n        var _item2 = items[high];\n\n        var _result = callback(_item2, high);\n\n        if (!!_result) {\n          return _item2;\n        }\n\n        high++;\n      }\n    }\n\n    return null;\n  }\n\n  return {\n    moveArrayItem: moveArrayItem,\n    moveArrayItemIntoArray: moveArrayItemIntoArray,\n    removeArrayItem: removeArrayItem,\n    outwardSearch: outwardSearch\n  };\n});\n//# sourceMappingURL=array.js.map","Magento_PageBuilder/js/utils/editor.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/tools\", \"mage/translate\", \"mageUtils\", \"Magento_PageBuilder/js/config\"], function (_jquery, _tools, _translate, _mageUtils, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Is the inline WYSIWYG supported?\n   */\n  function isWysiwygSupported() {\n    return _config.getConfig(\"can_use_inline_editing_on_stage\");\n  }\n  /**\n   * Encode content for TinyMCE\n   *\n   * @param content\n   */\n\n\n  function encodeContent(content) {\n    if (isWysiwygSupported()) {\n      return convertVariablesToHtmlPreview(convertWidgetsToHtmlPreview(unescapeDoubleQuoteWithinWidgetDirective(removeInvalidPlaceholders(content))));\n    }\n\n    return content;\n  }\n  /**\n   * Prior to parsing the content remove any invalid placeholders within the content\n   *\n   * @param content\n   */\n\n\n  function removeInvalidPlaceholders(content) {\n    if (content.indexOf(\"magento-placeholder\") !== -1) {\n      var html = new DOMParser().parseFromString(content, \"text/html\");\n      var placeholders = html.querySelectorAll(\"span.magento-placeholder\");\n\n      if (placeholders.length > 0) {\n        [].slice.call(placeholders).forEach(function (placeholder) {\n          // If the invalid placeholder contains a directive, let's insert it back where it belongs\n          if (placeholder.innerText.indexOf(\"{{\") !== -1) {\n            placeholder.parentNode.insertBefore(document.createTextNode(placeholder.innerText), placeholder);\n          }\n\n          placeholder.remove();\n        });\n      }\n\n      return html.body.innerHTML;\n    }\n\n    return content;\n  }\n  /**\n   * Convert all variables to their HTML preview counterparts\n   *\n   * Re-implements logic from lib/web/mage/adminhtml/wysiwyg/tiny_mce/plugins/magentovariable/editor_plugin.js to parse\n   * and replace the variables within the content.\n   *\n   * @param content\n   */\n\n\n  function convertVariablesToHtmlPreview(content) {\n    var config = _config.getConfig(\"tinymce\").variables;\n\n    var magentoVariables = JSON.parse(config.placeholders);\n    return content.replace(/{\\{\\s?(?:customVar code=|config path=\\\")([^\\}\\\"]+)[\\\"]?\\s?\\}\\}/ig, function (match, path) {\n      var id = btoa(path).replace(/\\+/g, \":\").replace(/\\//g, \"_\").replace(/=/g, \"-\");\n      var placeholder = (0, _jquery)(\"<span />\").addClass(\"magento-variable\").addClass(\"magento-placeholder\").addClass(\"mceNonEditable\").prop(\"id\", id).prop(\"contentEditable\", \"false\");\n\n      if (magentoVariables[path].variable_type === \"custom\") {\n        placeholder.addClass(\"magento-custom-var\");\n      }\n\n      var variableType = magentoVariables[path].variable_type;\n\n      if (magentoVariables[path] && (variableType === \"default\" || variableType === \"custom\")) {\n        placeholder.text(magentoVariables[path].variable_name);\n      } else {\n        // If we're unable to find the placeholder we need to attach an error class\n        placeholder.addClass(\"magento-placeholder-error\");\n        placeholder.text(variableType === \"custom\" ? path : (0, _translate)(\"Not Found\"));\n      }\n\n      return placeholder[0].outerHTML;\n    });\n  }\n  /**\n   * Convert widgets within content to their HTML counterparts\n   *\n   * @param content\n   */\n\n\n  function convertWidgetsToHtmlPreview(content) {\n    var config = _config.getConfig(\"tinymce\").widgets;\n\n    return content.replace(/\\{\\{widget([\\S\\s]*?)\\}\\}/ig, function (match, widgetBody) {\n      var attributes = parseAttributesString(widgetBody);\n      var imageSrc;\n\n      if (attributes.type) {\n        var placeholder = (0, _jquery)(\"<span />\").addClass(\"magento-placeholder\").addClass(\"magento-widget\").addClass(\"mceNonEditable\").prop(\"id\", _mageUtils.uniqueid()).prop(\"contentEditable\", \"false\");\n        attributes.type = attributes.type.replace(/\\\\\\\\/g, \"\\\\\");\n        imageSrc = config.placeholders[attributes.type];\n\n        if (!imageSrc) {\n          imageSrc = config.error_image_url;\n          placeholder.addClass(\"magento-placeholder-error\");\n        }\n\n        var image = (0, _jquery)(\"<img />\").prop(\"id\", window.Base64.idEncode(match)).prop(\"src\", imageSrc);\n        placeholder.append(image);\n        var widgetType = \"\";\n\n        if (config.types[attributes.type]) {\n          widgetType += config.types[attributes.type];\n        }\n\n        placeholder.append((0, _jquery)(document.createTextNode(widgetType)));\n        return placeholder[0].outerHTML;\n      }\n    });\n  }\n  /**\n   * Parse attributes into a string\n   *\n   * @param attributes\n   */\n\n\n  function parseAttributesString(attributes) {\n    var result = {};\n    attributes.replace(/(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/g, function (match, key, value) {\n      result[key] = value ? value.replace(/&quote;/g, \"\\\"\") : value;\n      return \"\";\n    });\n    return result;\n  }\n  /**\n   * Lock all image sizes before initializing TinyMCE to avoid content jumps\n   *\n   * @param element\n   */\n\n\n  function lockImageSize(element) {\n    [].slice.call(element.querySelectorAll(\"img\")).forEach(function (image) {\n      if (image.style.width.length === 0) {\n        image.style.width = /^\\d+$/.test(image.getAttribute(\"width\")) ? image.getAttribute(\"width\") + \"px\" : image.getAttribute(\"width\");\n        image.setAttribute(\"data-width-locked\", \"true\");\n      }\n\n      if (image.style.height.length === 0) {\n        image.style.height = /^\\d+$/.test(image.getAttribute(\"height\")) ? image.getAttribute(\"height\") + \"px\" : image.getAttribute(\"height\");\n        image.setAttribute(\"data-height-locked\", \"true\");\n      }\n    });\n  }\n  /**\n   * Reverse forced image size after TinyMCE is finished initializing\n   *\n   * @param element\n   */\n\n\n  function unlockImageSize(element) {\n    [].slice.call(element.querySelectorAll(\"img\")).forEach(function (image) {\n      if (image.getAttribute(\"data-width-locked\")) {\n        image.style.width = null;\n        image.removeAttribute(\"data-width-locked\");\n      }\n\n      if (image.getAttribute(\"data-height-locked\")) {\n        image.style.height = null;\n        image.removeAttribute(\"data-height-locked\");\n      }\n    });\n  }\n  /**\n   * Create a bookmark within the content to be restored later\n   */\n\n\n  function createBookmark(event) {\n    var wrapperElement = (0, _jquery)(event.target).parents(\".inline-wysiwyg\");\n    /**\n     * Create an element bookmark\n     *\n     * @param element\n     */\n\n    var createElementBookmark = function createElementBookmark(element) {\n      return {\n        name: element.nodeName,\n        index: findNodeIndex(wrapperElement[0], element.nodeName, element)\n      };\n    }; // Handle direct clicks onto an IMG\n\n\n    if (event.target.nodeName === \"IMG\") {\n      return createElementBookmark(event.target);\n    }\n\n    if (window.getSelection) {\n      var selection = window.getSelection();\n\n      var id = _mageUtils.uniqueid();\n\n      if (selection.getRangeAt && selection.rangeCount) {\n        var range = normalizeTableCellSelection(selection.getRangeAt(0).cloneRange()); // Determine if the current node is an image or span that we want to select instead of text\n\n        var currentNode = range.startContainer;\n\n        if (currentNode.nodeType === Node.ELEMENT_NODE && (currentNode.nodeName === \"IMG\" || currentNode.nodeName === \"SPAN\" && currentNode.classList.contains(\"magento-placeholder\"))) {\n          return createElementBookmark(currentNode);\n        } // Also check if the direct parent is either of these\n\n\n        var parentNode = range.startContainer.parentNode;\n\n        if (parentNode.nodeName === \"IMG\" || parentNode.nodeName === \"SPAN\" && parentNode.classList.contains(\"magento-placeholder\")) {\n          return createElementBookmark(parentNode);\n        }\n\n        if (!range.collapsed) {\n          range.collapse(false);\n          var endBookmarkNode = createBookmarkSpan(id + \"_end\");\n          range.insertNode(endBookmarkNode);\n        }\n\n        var range2 = normalizeTableCellSelection(selection.getRangeAt(0));\n        range2.collapse(true);\n        var startBookmarkNode = createBookmarkSpan(id + \"_start\");\n        range2.insertNode(startBookmarkNode);\n        return {\n          id: id\n        };\n      }\n    }\n\n    return null;\n  }\n  /**\n   * Move the cursor to our new bookmark\n   *\n   * @param bookmark\n   */\n\n\n  function moveToBookmark(bookmark) {\n    window.tinymce.activeEditor.selection.moveToBookmark(bookmark);\n  }\n  /**\n   * Retrieve active editor from TinyMCE\n   */\n\n\n  function getActiveEditor() {\n    return window.tinymce.activeEditor;\n  }\n  /**\n   * Create a bookmark span for the selection\n   *\n   * @param id\n   */\n\n\n  function createBookmarkSpan(id) {\n    var bookmark = document.createElement(\"span\");\n    bookmark.setAttribute(\"data-mce-type\", \"bookmark\");\n    bookmark.id = id;\n    bookmark.style.overflow = \"hidden\";\n    bookmark.style.lineHeight = \"0px\";\n    return bookmark;\n  }\n  /**\n   * Find the index of an element within a wrapper\n   *\n   * @param wrapperElement\n   * @param name\n   * @param element\n   */\n\n\n  function findNodeIndex(wrapperElement, name, element) {\n    var selector = name.toLowerCase() + ':not([data-mce-bogus=\"all\"])'; // If there is no ID on the element add a unique ID so we can efficiently find it\n\n    if (!element.id) {\n      element.id = _mageUtils.uniqueid();\n    }\n\n    return (0, _jquery)(wrapperElement).find(selector).toArray().findIndex(function (node) {\n      return node.id === element.id;\n    });\n  }\n  /**\n   * Get a node by index within a wrapper\n   *\n   * @param wrapperElement\n   * @param name\n   * @param index\n   */\n\n\n  function getNodeByIndex(wrapperElement, name, index) {\n    var selector = name.toLowerCase() + ':not([data-mce-bogus=\"all\"])';\n    return (0, _jquery)(wrapperElement).find(selector).get(index);\n  }\n  /**\n   * Create a double click event that works in all browsers\n   */\n\n\n  function createDoubleClickEvent() {\n    try {\n      return new MouseEvent(\"dblclick\", {\n        view: window,\n        bubbles: true,\n        cancelable: true\n      });\n    } catch (e) {\n      var dblClickEvent = document.createEvent(\"MouseEvent\");\n      dblClickEvent.initMouseEvent(\"dblclick\", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n      return dblClickEvent;\n    }\n  }\n  /**\n   * Replace all desktop styles that left unprocessed back to style element to prevent data corruption.\n   */\n\n\n  function processInlineStyles(html) {\n    var name = _config.getConfig(\"defaultViewport\");\n\n    var searchPattern = new RegExp(\"data-\" + name + \"-style=\", \"g\");\n    return html.replace(searchPattern, \"style=\");\n  }\n  /**\n   * Move the end point of a range to handle tables\n   *\n   * @param range\n   * @param start\n   */\n\n\n  function moveEndPoint(range, start) {\n    var container;\n    var offset;\n    var childNodes;\n\n    if (start) {\n      container = range.startContainer;\n      offset = range.startOffset;\n    } else {\n      container = range.endContainer;\n      offset = range.endOffset;\n    }\n\n    if (container.nodeType === Node.ELEMENT_NODE && container.nodeName === \"TR\") {\n      childNodes = container.childNodes;\n      container = childNodes[Math.min(start ? offset : offset - 1, childNodes.length - 1)];\n\n      if (container) {\n        offset = start ? 0 : container.childNodes.length;\n\n        if (start) {\n          range.setStart(container, offset);\n        } else {\n          range.setEnd(container, offset);\n        }\n      }\n    }\n  }\n  /**\n   * Normalize the table sell selection within a range to better handle selections being inside of tables\n   *\n   * @param range\n   */\n\n\n  function normalizeTableCellSelection(range) {\n    moveEndPoint(range, true);\n    moveEndPoint(range, false);\n    return range;\n  }\n  /**\n   * Convert HTML encoded double quote to double quote with backslash within widget directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function escapeDoubleQuoteWithinWidgetDirective(content) {\n    return content.replace(/\\{\\{widget[\\S\\s]*?\\}\\}/ig, function (match) {\n      return match.replace(/&quot;/g, \"\\\\\\\"\");\n    });\n  }\n  /**\n   * Convert double quote with backslash to HTML encoded double quote within widget directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function unescapeDoubleQuoteWithinWidgetDirective(content) {\n    return content.replace(/\\{\\{widget[\\S\\s]*?\\}\\}/ig, function (match) {\n      return match.replace(/\\\\+\"/g, \"&quot;\");\n    });\n  }\n  /**\n   * Convert double quote to single quote within magento variable directives\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function replaceDoubleQuoteWithSingleQuoteWithinVariableDirective(content) {\n    // Find html elements which attributes contain magento variables directives\n    return content.replace(/<([a-z0-9\\-\\_]+)([^>]+?[a-z0-9\\-\\_]+=\"[^\"]*?\\{\\{.+?\\}\\}.*?\".*?)>/gi, function (match1, tag, attributes) {\n      // Replace double quote with single quote within magento variable directive\n      var sanitizedAttributes = attributes.replace(/\\{\\{[^\\{\\}]+\\}\\}/gi, function (match2) {\n        return match2.replace(/\"/g, \"'\");\n      });\n      return \"<\" + tag + sanitizedAttributes + \">\";\n    });\n  }\n  /**\n   * Remove Page Builder reserved html tag attributes from the content\n   *\n   * @param {string} content\n   * @returns {string}\n   */\n\n\n  function removeReservedHtmlAttributes(content) {\n    var attributes = _config.getConfig(\"stage_config\").reserved_html_attributes || {};\n\n    for (var _i = 0, _Object$keys = Object.keys(attributes); _i < _Object$keys.length; _i++) {\n      var attribute = _Object$keys[_i];\n      content = removeHtmlTagAttribute(content, attribute);\n    }\n\n    return content;\n  }\n  /**\n   * Remove attribute from html tags\n   *\n   * @param {string} content\n   * @param {string} name\n   * @returns {string}\n   */\n\n\n  function removeHtmlTagAttribute(content, name) {\n    if (typeof content === \"string\" && content.indexOf(name + \"=\") !== -1) {\n      var html = new DOMParser().parseFromString(content, \"text/html\");\n      html.querySelectorAll(\"[\" + name + \"]\").forEach(function (child) {\n        child.removeAttribute(name);\n      });\n      content = html.body.innerHTML;\n    }\n\n    return content;\n  }\n\n  return {\n    isWysiwygSupported: isWysiwygSupported,\n    encodeContent: encodeContent,\n    parseAttributesString: parseAttributesString,\n    lockImageSize: lockImageSize,\n    unlockImageSize: unlockImageSize,\n    createBookmark: createBookmark,\n    moveToBookmark: moveToBookmark,\n    getActiveEditor: getActiveEditor,\n    findNodeIndex: findNodeIndex,\n    getNodeByIndex: getNodeByIndex,\n    createDoubleClickEvent: createDoubleClickEvent,\n    processInlineStyles: processInlineStyles,\n    escapeDoubleQuoteWithinWidgetDirective: escapeDoubleQuoteWithinWidgetDirective,\n    unescapeDoubleQuoteWithinWidgetDirective: unescapeDoubleQuoteWithinWidgetDirective,\n    replaceDoubleQuoteWithSingleQuoteWithinVariableDirective: replaceDoubleQuoteWithSingleQuoteWithinVariableDirective,\n    removeReservedHtmlAttributes: removeReservedHtmlAttributes\n  };\n});\n//# sourceMappingURL=editor.js.map","Magento_PageBuilder/js/utils/string.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Convert from snake case to camel case\n   *\n   * @param {string} currentString\n   * @returns {string}\n   * @api\n   */\n  function fromSnakeToCamelCase(currentString) {\n    var parts = currentString.split(/[_-]/);\n    var newString = \"\";\n\n    for (var i = 1; i < parts.length; i++) {\n      newString += parts[i].charAt(0).toUpperCase() + parts[i].slice(1);\n    }\n\n    return parts[0] + newString;\n  }\n  /**\n   * Convert a camel case string to snake case\n   *\n   * @param currentString\n   */\n\n\n  function fromCamelCaseToDash(currentString) {\n    return currentString.replace(/[A-Z]/g, function (m) {\n      return \"-\" + m.toLowerCase();\n    });\n  }\n\n  return {\n    fromSnakeToCamelCase: fromSnakeToCamelCase,\n    fromCamelCaseToDash: fromCamelCaseToDash\n  };\n});\n//# sourceMappingURL=string.js.map","Magento_PageBuilder/js/utils/delay-until.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Delay until a condition is met\n   *\n   * @param {() => void} callback\n   * @param {() => boolean} condition\n   * @param {number} interval\n   */\n  function delayUntil(callback, condition, interval) {\n    if (interval === void 0) {\n      interval = 50;\n    }\n\n    var delayInterval = setInterval(function () {\n      if (condition()) {\n        clearInterval(delayInterval);\n        callback();\n      }\n    }, interval);\n  }\n\n  return delayUntil;\n});\n//# sourceMappingURL=delay-until.js.map","Magento_PageBuilder/js/utils/position-sticky.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Determine if the current browser supports position sticky\n   *\n   * @returns {boolean}\n   */\n  function supportsPositionSticky() {\n    if (!window.getComputedStyle) {\n      return false;\n    }\n\n    var testNode = document.createElement(\"div\");\n    return [\"\", \"-webkit-\", \"-moz-\", \"-ms-\"].some(function (prefix) {\n      try {\n        testNode.style.position = prefix + \"sticky\";\n      } catch (e) {// Fail silently\n      }\n\n      return testNode.style.position !== \"\";\n    });\n  }\n\n  return {\n    supportsPositionSticky: supportsPositionSticky\n  };\n});\n//# sourceMappingURL=position-sticky.js.map","Magento_PageBuilder/js/utils/image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/url\"], function (_config, _directives, _url) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Decode image background URL to object\n   *\n   * @param value\n   * @returns {Object}\n   * @api\n   */\n  function decodeUrl(value) {\n    var result = \"\";\n    value = decodeURIComponent(value.replace(window.location.href, \"\"));\n    var regexp = /{{.*\\s*url=\"?(.*\\.([a-z|A-Z]*))\"?\\s*}}/;\n\n    if (regexp.test(value)) {\n      var _regexp$exec = regexp.exec(value),\n          url = _regexp$exec[1],\n          type = _regexp$exec[2];\n\n      var image = {\n        name: url.split(\"/\").pop(),\n        size: 0,\n        type: \"image/\" + type,\n        url: _config.getConfig(\"media_url\") + url\n      };\n      result = [image];\n    }\n\n    return result;\n  }\n  /**\n   * Convert a URL to an image directive\n   *\n   * @param {string} imageUrl\n   * @returns {string}\n   */\n\n\n  function urlToDirective(imageUrl) {\n    var mediaUrl = (0, _url.convertUrlToPathIfOtherUrlIsOnlyAPath)(_config.getConfig(\"media_url\"), imageUrl);\n    var mediaPath = imageUrl.split(mediaUrl);\n    return \"{{media url=\" + mediaPath[1] + \"}}\";\n  }\n  /**\n   * Convert an image URL to a background image data uri\n   *\n   * @param {string} imageUrl\n   * @returns {string}\n   */\n\n\n  function imageToBackgroundImageDataUrl(imageUrl) {\n    return \"url(\\'\" + (0, _directives.toDataUrl)(urlToDirective(imageUrl)) + \"\\')\";\n  }\n\n  return {\n    decodeUrl: decodeUrl,\n    urlToDirective: urlToDirective,\n    imageToBackgroundImageDataUrl: imageToBackgroundImageDataUrl\n  };\n});\n//# sourceMappingURL=image.js.map","Magento_PageBuilder/js/utils/breakpoints.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return {\n        /**\n         * Build media query.\n         *\n         * @param {Object} conditions\n         * @returns {String}\n         */\n        buildMedia: function (conditions) {\n            var result = _.map(_.pairs(conditions), function (condition) {\n                return '(' + condition.join(': ') + ')';\n            });\n\n            return result.join(' and ');\n        }\n    };\n});\n","Magento_PageBuilder/js/utils/check-stage-full-screen.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Check if stage full screen mode is active\n   *\n   * @param {string} stageId\n   * @returns {boolean}\n   */\n  function checkStageFullScreen(stageId) {\n    var $stage = (0, _jquery)(\"#\" + stageId);\n    var $fullScreenStageWrapper = $stage.closest(\".stage-full-screen\");\n    return !!$fullScreenStageWrapper.length;\n  }\n\n  return checkStageFullScreen;\n});\n//# sourceMappingURL=check-stage-full-screen.js.map","Magento_PageBuilder/js/utils/directives.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * MIME type to use in place of the image\n   *\n   * @type {string}\n   */\n  var mimeType = \"text/magento-directive\";\n  /**\n   * Determine if a URL is a directive of our type\n   *\n   * @param {string} url\n   * @returns {boolean}\n   * @api\n   */\n\n  function isDirectiveDataUrl(url) {\n    return url.indexOf(\"data:\" + mimeType) === 0;\n  }\n  /**\n   * Convert a directive into our data URI\n   *\n   * @param {string} directive\n   * @returns {string}\n   * @api\n   */\n\n\n  function toDataUrl(directive) {\n    return \"data:\" + mimeType + \",\" + encodeURIComponent(directive);\n  }\n  /**\n   * Convert a URI to it's directive equivalent\n   *\n   * @param {string} url\n   * @returns {string}\n   * @api\n   */\n\n\n  function fromDataUrl(url) {\n    if (!isDirectiveDataUrl(url)) {\n      throw Error(url + \" is not a magento directive data url\");\n    }\n\n    return decodeURIComponent(url.split(mimeType + \",\")[1]);\n  }\n  /**\n   * Decode all data URIs present in a string\n   *\n   * @param {string} str\n   * @returns {string}\n   * @api\n   */\n\n\n  function decodeAllDataUrlsInString(str) {\n    return str.replace(new RegExp(\"url\\\\s*\\\\(\\\\s*(?:&quot;|\\'|\\\")?(data:\" + mimeType + \",.+?)(?:&quot;|\\'|\\\")?\\\\s*\\\\)\", \"g\"), function (match, url) {\n      return \"url(\\'\" + fromDataUrl(url) + \"\\')\";\n    });\n  }\n  /**\n   * Retrieve the image URL with directive\n   *\n   * @param {Array} image\n   * @returns {string}\n   * @api\n   */\n\n\n  function getImageUrl(image) {\n    var imageUrl = image[0].url;\n    var mediaPath = imageUrl.split(_config.getConfig(\"media_url\"));\n    return \"{{media url=\" + mediaPath[1] + \"}}\";\n  }\n  /**\n   * Remove quotes in media directives, {{media url=\"wysiwyg/image.png\"}} convert to {{media url=wysiwyg/image.png}}\n   *\n   * @param {string} html\n   * @returns {string}\n   * @api\n   */\n\n\n  function removeQuotesInMediaDirectives(html) {\n    if (!html) {\n      return \"\";\n    }\n\n    var mediaDirectiveRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(.*?)\\s*\\}\\}/g;\n    var urlRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(.*)\\s*\\}\\}/;\n    var mediaDirectiveMatches = html.match(mediaDirectiveRegExp);\n\n    if (mediaDirectiveMatches) {\n      mediaDirectiveMatches.forEach(function (mediaDirective) {\n        var urlMatches = mediaDirective.match(urlRegExp);\n\n        if (urlMatches && urlMatches[1] !== undefined) {\n          var directiveWithOutQuotes = \"{{media url=\" + urlMatches[1].replace(/(\"|&quot;|\\s)/g, \"\") + \"}}\";\n          html = html.replace(mediaDirective, directiveWithOutQuotes);\n        }\n      });\n    }\n\n    return html;\n  }\n  /**\n   * Replace media directives with actual media URLs\n   *\n   * @param {string} html\n   * @returns {string}\n   * @api\n   */\n\n\n  function convertMediaDirectivesToUrls(html) {\n    if (!html) {\n      return \"\";\n    }\n\n    var mediaDirectiveRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*\"?[^\"\\s\\}]+\"?\\s*\\}\\}/g;\n    var mediaDirectiveMatches = html.match(mediaDirectiveRegExp);\n\n    if (mediaDirectiveMatches) {\n      mediaDirectiveMatches.forEach(function (mediaDirective) {\n        var urlRegExp = /\\{\\{\\s*media\\s+url\\s*=\\s*(?:\"|&quot;)?(.+)(?=}})\\s*\\}\\}/;\n        var urlMatches = mediaDirective.match(urlRegExp);\n\n        if (urlMatches && typeof urlMatches[1] !== \"undefined\") {\n          html = html.replace(mediaDirective, _config.getConfig(\"media_url\") + urlMatches[1].replace(/\"$/, \"\").replace(/&quot;$/, \"\"));\n        }\n      });\n    }\n\n    return html;\n  }\n  /**\n   * Replace data-src attribute with src.\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n\n\n  function replaceWithSrc(html) {\n    return html.replace(new RegExp(\"data-tmp-src=\\\"\\{\\{\", \"g\"), \"src=\\\"{{\");\n  }\n  /**\n   * Replace src attribute with data-tmp-src.\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n\n\n  function replaceWithDataSrc(html) {\n    return html.replace(new RegExp(\"src=\\\"\\{\\{\", \"g\"), \"data-tmp-src=\\\"{{\");\n  }\n\n  return Object.assign(decodeAllDataUrlsInString, {\n    toDataUrl: toDataUrl,\n    fromDataUrl: fromDataUrl,\n    getImageUrl: getImageUrl,\n    removeQuotesInMediaDirectives: removeQuotesInMediaDirectives,\n    convertMediaDirectivesToUrls: convertMediaDirectivesToUrls,\n    replaceWithSrc: replaceWithSrc,\n    replaceWithDataSrc: replaceWithDataSrc\n  });\n});\n//# sourceMappingURL=directives.js.map","Magento_PageBuilder/js/utils/url.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Check for whether url string contains only a path\n   *\n   * @param {String} url\n   * @returns {Boolean}\n   */\n  function isPathOnly(url) {\n    return url.indexOf(\"/\") === 0;\n  }\n  /**\n   * Get the path from a URL\n   *\n   * @param {String} url\n   * @returns {String}\n   */\n\n\n  function getPathFromUrl(url) {\n    var a = document.createElement(\"a\");\n    a.href = url;\n    return a.pathname;\n  }\n  /**\n   * Convert url to path if other url is only a path\n   *\n   * @param {string} url\n   * @param {string} otherUrl\n   * @returns {string}\n   * @api\n   */\n\n\n  function convertUrlToPathIfOtherUrlIsOnlyAPath(url, otherUrl) {\n    return isPathOnly(otherUrl) ? getPathFromUrl(url) : url;\n  }\n\n  return {\n    convertUrlToPathIfOtherUrlIsOnlyAPath: convertUrlToPathIfOtherUrlIsOnlyAPath\n  };\n});\n//# sourceMappingURL=url.js.map","Magento_PageBuilder/js/utils/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * googleMaps dependency is added within googlemaps.phtml through shim based on API key being set\n *\n * @api\n */\ndefine([\n    'underscore',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (_, module, events) {\n    'use strict';\n\n    var google = window.google || {},\n\n        /**\n         * Generates a google map usable latitude and longitude object\n         *\n         * @param {Object} position\n         * @return {google.maps.LatLng}\n         */\n        getGoogleLatitudeLongitude = function (position) {\n            return new google.maps.LatLng(position.latitude, position.longitude);\n        },\n        gmAuthFailure = false;\n\n    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n    /**\n     * Google's error listener for map loader failures\n     */\n    window.gm_authFailure = function () {\n        events.trigger('googleMaps:authFailure');\n        gmAuthFailure = true;\n    };\n    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n    return function (element, markers, additionalOptions) {\n        var options,\n            style;\n\n        // If we've previously had an API key error, throw the error even again\n        if (gmAuthFailure) {\n            events.trigger('googleMaps:authFailure');\n\n            return;\n        }\n\n        // If Google Maps isn't loaded don't try init the map, it won't work\n        if (typeof google.maps === 'undefined') {\n            return;\n        }\n\n        /**\n         * Just in case of a bad JSON that bypassed validation\n         */\n        try {\n            style = module.config().style ? JSON.parse(module.config().style) : [];\n        }\n        catch (error) {\n            style = [];\n        }\n        options = _.extend({\n            zoom: 8,\n            center: getGoogleLatitudeLongitude({\n                latitude: 30.2672,\n                longitude: -97.7431\n            }),\n            scrollwheel: false,\n            disableDoubleClickZoom: false,\n            disableDefaultUI: false,\n            mapTypeControl: true,\n            mapTypeControlOptions: {\n                style: google.maps.MapTypeControlStyle.DEFAULT\n            },\n            styles: style\n        }, additionalOptions);\n\n        /* Create the map */\n        this.map = new google.maps.Map(element, options);\n        this.markers = [];\n\n        /**\n         * Callback function on map config update\n         * @param {Array} newMarkers\n         * @param {Object} updateOptions\n         */\n        this.onUpdate = function (newMarkers, updateOptions) {\n            this.map.setOptions(updateOptions);\n            this.setMarkers(newMarkers);\n        };\n\n        /**\n         * Sets the markers to selected map\n         * @param {Object} newMarkers\n         */\n        this.setMarkers = function (newMarkers) {\n            var activeInfoWindow,\n                latitudeLongitudeBounds = new google.maps.LatLngBounds();\n\n            this.markers.forEach(function (marker) {\n                marker.setMap(null);\n            }, this);\n\n            this.markers = [];\n            this.bounds = [];\n\n            /**\n             * Creates and set listener for markers\n             */\n            if (newMarkers && newMarkers.length) {\n                newMarkers.forEach(function (newMarker) {\n                    var location = _.escape(newMarker['location_name']) || '',\n                    comment = newMarker.comment ?\n                        '<p>' + _.escape(newMarker.comment).replace(/(?:\\r\\n|\\r|\\n)/g, '<br/>') + '</p>'\n                        : '',\n                    phone = newMarker.phone ? '<p>Phone: ' + _.escape(newMarker.phone) + '</p>' : '',\n                    address = newMarker.address ? _.escape(newMarker.address) + '<br/>' : '',\n                    city = _.escape(newMarker.city) || '',\n                    country = newMarker.country ? _.escape(newMarker.country) : '',\n                    state = newMarker.state ? _.escape(newMarker.state) + ' ' : '',\n                    zipCode = newMarker.zipcode ? _.escape(newMarker.zipcode) : '',\n                    cityComma = city !== '' && (zipCode !== '' || state !== '') ? ', ' : '',\n                    lineBreak = city !== '' || zipCode !== '' ? '<br/>' : '',\n                    contentString =\n                        '<div>' +\n                        '<h3><b>' + location + '</b></h3>' +\n                        comment +\n                        phone +\n                        '<p><span>' + address +\n                        city + cityComma + state + zipCode + lineBreak +\n                        country + '</span></p>' +\n                        '</div>',\n                    infowindow = new google.maps.InfoWindow({\n                        content: contentString,\n                        maxWidth: 350\n                    }),\n                    newCreatedMarker = new google.maps.Marker({\n                        map: this.map,\n                        position: getGoogleLatitudeLongitude(newMarker.position),\n                        title: location\n                    });\n\n                    if (location) {\n                        newCreatedMarker.addListener('click', function () {\n                            if (activeInfoWindow) {\n                                activeInfoWindow.close();\n                            }\n\n                            infowindow.open(this.map, newCreatedMarker);\n                            activeInfoWindow = infowindow;\n                        }, this);\n                    }\n\n                    this.markers.push(newCreatedMarker);\n                    this.bounds.push(getGoogleLatitudeLongitude(newMarker.position));\n                }, this);\n            }\n\n            /**\n             * This sets the bounds of the map for multiple locations\n             */\n            if (this.bounds.length > 1) {\n                this.bounds.forEach(function (bound) {\n                    latitudeLongitudeBounds.extend(bound);\n                });\n                this.map.fitBounds(latitudeLongitudeBounds);\n            }\n\n            /**\n             * Zoom to 8 if there is only a single location\n             */\n            if (this.bounds.length === 1) {\n                this.map.setCenter(this.bounds[0]);\n                this.map.setZoom(8);\n            }\n        };\n\n        this.setMarkers(markers);\n    };\n});\n","Magento_PageBuilder/js/utils/promise-deferred.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Returns a deferred promise\n   *\n   * @returns {DeferredInterface}\n   * @api\n   */\n  function deferred() {\n    var resolve;\n    var reject;\n    var promise = new Promise(function (promiseResolve, promiseReject) {\n      resolve = promiseResolve;\n      reject = promiseReject;\n    });\n    return {\n      resolve: resolve,\n      reject: reject,\n      promise: promise\n    };\n  }\n\n  return deferred;\n});\n//# sourceMappingURL=promise-deferred.js.map","Magento_PageBuilder/js/utils/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/utils/loader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  function load(dependencies, factory, onError) {\n    require(dependencies, factory, onError);\n  }\n\n  return load;\n});\n//# sourceMappingURL=loader.js.map","Magento_PageBuilder/js/binding/sortable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"underscore\"], function (_jquery, _knockout, _underscore) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _underscore = _interopRequireDefault(_underscore);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  // Create a new sortable Knockout binding\n  _knockout.default.bindingHandlers.sortable = {\n    init: function init(element, valueAccessor) {\n      // As we can't conditionally apply bindings we block this operation when options are null\n      if (valueAccessor() === null) {\n        return;\n      }\n\n      _underscore.default.defer(function () {\n        (0, _jquery.default)(element).sortable(valueAccessor());\n      });\n    }\n  };\n});\n//# sourceMappingURL=sortable.js.map","Magento_PageBuilder/js/binding/draggable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\"], function (_jquery, _knockout) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  // Create a new sortable Knockout binding\n  _knockout.default.bindingHandlers.draggable = {\n    init: function init(element, valueAccessor) {\n      (0, _jquery.default)(element).draggable(valueAccessor());\n    }\n  };\n});\n//# sourceMappingURL=draggable.js.map","Magento_PageBuilder/js/binding/master-style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/style-registry\"], function (_knockout, _mageUtils, _underscore, _config, _styleRegistry) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n  _mageUtils = _interopRequireDefault(_mageUtils);\n  _underscore = _interopRequireDefault(_underscore);\n  _config = _interopRequireDefault(_config);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var bodyId = _config.default.getConfig(\"bodyId\");\n\n  var getStyles = function getStyles(styleObject) {\n    var styles = {};\n\n    _knockout.default.utils.objectForEach(styleObject, function (styleName, styleValue) {\n      styleValue = _knockout.default.utils.unwrapObservable(styleValue);\n\n      if (styleValue === null || styleValue === undefined || styleValue === false) {\n        // Empty string removes the value, whereas null/undefined have no effect\n        styleValue = \"\";\n      }\n\n      if (styleValue) {\n        styles[styleName] = styleValue;\n      }\n    });\n\n    return styles;\n  };\n\n  _knockout.default.bindingHandlers.style = {\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var value = _knockout.default.utils.unwrapObservable(valueAccessor() || {});\n\n      var viewportKeys = _underscore.default.keys(_config.default.getConfig(\"viewports\"));\n\n      var commonStyles = getStyles(_underscore.default.omit(value, viewportKeys));\n      var viewportStyles = {};\n\n      _underscore.default.each(viewportKeys, function (name) {\n        viewportStyles[name] = _underscore.default.extend(getStyles(value[name]), commonStyles);\n      });\n\n      if (_underscore.default.findKey(viewportStyles, function (styles) {\n        return !_underscore.default.isEmpty(styles);\n      })) {\n        var id = _mageUtils.default.uniqueid();\n\n        var selector = \"#\" + bodyId + \" [\" + _styleRegistry.pbStyleAttribute + \"=\\\"\" + id + \"\\\"]\";\n\n        _underscore.default.each(viewportKeys, function (name) {\n          var registry = (0, _styleRegistry.getStyleRegistry)(name + bindingContext.$root.id);\n          registry.setStyles(selector, viewportStyles[name]);\n        });\n\n        element.setAttribute(_styleRegistry.pbStyleAttribute, id);\n      }\n    }\n  };\n});\n//# sourceMappingURL=master-style.js.map","Magento_PageBuilder/js/binding/style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/style-registry\"], function (_knockout, _mageUtils, _underscore, _config, _styleRegistry) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n  _mageUtils = _interopRequireDefault(_mageUtils);\n  _underscore = _interopRequireDefault(_underscore);\n  _config = _interopRequireDefault(_config);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var originalStyle = _knockout.default.bindingHandlers.style;\n\n  var bodyId = _config.default.getConfig(\"bodyId\");\n\n  function isPageBuilderContext(context) {\n    return !!(context.stage && context.stage.pageBuilder);\n  }\n\n  _knockout.default.bindingHandlers.style = {\n    init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      if (isPageBuilderContext(bindingContext)) {\n        element.setAttribute(_styleRegistry.pbStyleAttribute, _mageUtils.default.uniqueid());\n      }\n    },\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      if (isPageBuilderContext(bindingContext)) {\n        var value = _knockout.default.utils.unwrapObservable(valueAccessor() || {});\n\n        var styles = {};\n        var styleId = element.getAttribute(_styleRegistry.pbStyleAttribute);\n        var existedStyleBlock = document.querySelector(\"style[\" + _styleRegistry.styleDataAttribute + \"=\\\"\" + styleId + \"\\\"]\");\n\n        _knockout.default.utils.objectForEach(value, function (styleName, styleValue) {\n          styleValue = _knockout.default.utils.unwrapObservable(styleValue);\n\n          if (styleValue === null || styleValue === undefined || styleValue === false) {\n            styleValue = \"\";\n          }\n\n          if (styleValue) {\n            styles[styleName] = styleValue;\n          }\n        });\n\n        if (existedStyleBlock) {\n          existedStyleBlock.remove();\n        }\n\n        if (!_underscore.default.isEmpty(styles)) {\n          var styleElement = document.createElement(\"style\");\n          styleElement.setAttribute(_styleRegistry.styleDataAttribute, styleId);\n          styleElement.innerHTML = (0, _styleRegistry.generateCssBlock)(\"#\" + bodyId + \" [\" + _styleRegistry.pbStyleAttribute + \"=\\\"\" + styleId + \"\\\"]\", styles);\n          element.parentElement.append(styleElement);\n        }\n      } else {\n        originalStyle.update(element, valueAccessor, allBindings, viewModel, bindingContext);\n      }\n    }\n  };\n});\n//# sourceMappingURL=style.js.map","Magento_PageBuilder/js/binding/focus.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\"], function (_knockout) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  _knockout.default.bindingHandlers.hasFocusNoScroll = {\n    init: _knockout.default.bindingHandlers.hasFocus.init,\n    update: function update(element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {\n      var value = !!_knockout.default.utils.unwrapObservable(valueAccessor());\n      value ? element.focus({\n        preventScroll: true\n      }) : element.blur();\n    }\n  };\n});\n//# sourceMappingURL=focus.js.map","Magento_PageBuilder/js/binding/live-edit.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_Ui/js/lib/key-codes\", \"underscore\"], function (_jquery, _knockout, _keyCodes, _underscore) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _keyCodes = _interopRequireDefault(_keyCodes);\n  _underscore = _interopRequireDefault(_underscore);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n\n  /**\n   * Strip HTML and return text\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n  function stripHtml(html) {\n    if (html) {\n      var htmlDocument = new DOMParser().parseFromString(html, \"text/html\");\n      return htmlDocument.body ? htmlDocument.body.textContent : \"\";\n    }\n\n    return html;\n  }\n  /**\n   * Add or remove the placeholder-text class from the element based on its content\n   *\n   * @param {Element} element\n   */\n\n\n  function handlePlaceholderClass(element) {\n    if (stripHtml(element.innerHTML).length === 0) {\n      element.innerHTML = \"\";\n      element.classList.add(\"placeholder-text\");\n    } else {\n      element.classList.remove(\"placeholder-text\");\n    }\n  } // Custom Knockout binding for live editing text inputs\n\n\n  _knockout.default.bindingHandlers.liveEdit = {\n    /**\n     * Init the live edit binding on an element\n     *\n     * @param {HTMLElement} element\n     * @param {() => any} valueAccessor\n     * @param {KnockoutAllBindingsAccessor} allBindings\n     * @param {any} viewModel\n     * @param {KnockoutBindingContext} bindingContext\n     */\n    init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var _valueAccessor = valueAccessor(),\n          field = _valueAccessor.field,\n          placeholder = _valueAccessor.placeholder,\n          _valueAccessor$select = _valueAccessor.selectAll,\n          selectAll = _valueAccessor$select === void 0 ? false : _valueAccessor$select;\n\n      var focusedValue = element.innerHTML;\n      var previouslyFocused = false;\n      var blurTimeout;\n      var lastUpdateValue;\n      /**\n       * Record the value on focus, only conduct an update when data changes\n       */\n\n      var onFocus = function onFocus() {\n        clearTimeout(blurTimeout);\n        focusedValue = stripHtml(element.innerHTML);\n        lastUpdateValue = focusedValue;\n\n        if (selectAll && element.innerHTML !== \"\" && !previouslyFocused) {\n          _underscore.default.defer(function () {\n            var selection = window.getSelection();\n            var range = document.createRange();\n            range.selectNodeContents(element);\n            selection.removeAllRanges();\n            selection.addRange(range);\n            previouslyFocused = true;\n          });\n        }\n      };\n      /**\n       * On blur change our timeout for previously focused. We require a flag to track whether the input has been\n       * focused and selected previously due to a bug in Firefox which doesn't handle focus events correctly when\n       * contenteditable is placed within an anchor.\n       */\n\n\n      var onBlur = function onBlur() {\n        blurTimeout = setTimeout(function () {\n          previouslyFocused = false;\n        }, 100);\n      };\n      /**\n       * Mousedown event on element\n       *\n       * @param {Event} event\n       */\n\n\n      var onMouseDown = function onMouseDown(event) {\n        event.stopPropagation();\n      };\n      /**\n       * Key down event on element\n       *\n       * Prevent styling such as bold, italic, and underline using keyboard commands, and prevent multi-line entries\n       *\n       * @param {JQueryEventObject} event\n       */\n\n\n      var onKeyDown = function onKeyDown(event) {\n        var key = _keyCodes.default[event.keyCode]; // command or control\n\n        if (event.metaKey || event.ctrlKey) {\n          if (key === \"bKey\" || key === \"iKey\" || key === \"uKey\") {\n            event.preventDefault();\n          }\n        }\n\n        if (key === \"enterKey\") {\n          event.preventDefault();\n        } // prevent slides from sliding\n\n\n        if (key === \"pageLeftKey\" || key === \"pageRightKey\") {\n          event.stopPropagation();\n        }\n      };\n      /**\n       * On key up update the view model to ensure all changes are saved\n       */\n\n\n      var onKeyUp = function onKeyUp() {\n        var strippedValue = stripHtml(element.innerHTML);\n\n        if (focusedValue !== strippedValue) {\n          lastUpdateValue = strippedValue;\n          viewModel.updateData(field, strippedValue);\n        }\n      };\n      /**\n       * Prevent content from being dropped inside of inline edit area\n       *\n       * @param {DragEvent} event\n       */\n\n\n      var onDrop = function onDrop(event) {\n        event.preventDefault();\n      };\n      /**\n       * Prevent content from being dragged\n       *\n       * @param {DragEvent} event\n       */\n\n\n      var onDragStart = function onDragStart(event) {\n        event.preventDefault();\n      };\n      /**\n       * Input event on element\n       */\n\n\n      var onInput = function onInput() {\n        handlePlaceholderClass(element);\n      };\n      /**\n       * On paste strip any HTML\n       */\n\n\n      var onPaste = function onPaste() {\n        // Record the original caret position so we can ensure we restore it at the correct position\n        var selection = window.getSelection();\n        var originalPositionStart = selection.getRangeAt(0).cloneRange().startOffset;\n        var originalPositionEnd = selection.getRangeAt(0).cloneRange().endOffset;\n        var originalContentLength = stripHtml(element.innerHTML).length; // Allow the paste action to update the content\n\n        _underscore.default.defer(function () {\n          var strippedValue = stripHtml(element.innerHTML);\n          lastUpdateValue = strippedValue;\n          element.textContent = strippedValue;\n          /**\n           * Calculate the position the caret should end up at, the difference in string length + the original\n           * end offset position\n           */\n\n          var restoredPosition = Math.abs(strippedValue.length - originalContentLength) + originalPositionStart; // If part of the text was selected adjust the position for the removed text\n\n          if (originalPositionStart !== originalPositionEnd) {\n            restoredPosition += Math.abs(originalPositionEnd - originalPositionStart);\n          }\n\n          var range = document.createRange();\n          range.setStart(element.childNodes[0], restoredPosition);\n          range.setEnd(element.childNodes[0], restoredPosition);\n          selection.removeAllRanges();\n          selection.addRange(range);\n        });\n      };\n\n      element.setAttribute(\"data-placeholder\", placeholder);\n      element.textContent = viewModel.contentType.dataStore.get(field);\n      element.contentEditable = \"true\";\n      element.addEventListener(\"focus\", onFocus);\n      element.addEventListener(\"blur\", onBlur);\n      element.addEventListener(\"mousedown\", onMouseDown);\n      element.addEventListener(\"keydown\", onKeyDown);\n      element.addEventListener(\"keyup\", onKeyUp);\n      element.addEventListener(\"input\", onInput);\n      element.addEventListener(\"drop\", onDrop);\n      element.addEventListener(\"paste\", onPaste);\n      element.addEventListener(\"dragstart\", onDragStart);\n      (0, _jquery.default)(element).parent().css(\"cursor\", \"text\");\n      handlePlaceholderClass(element); // Create a subscription onto the original data to update the internal value\n\n      viewModel.contentType.dataStore.subscribe(function (data) {\n        // Only update the value if it differs from the last value added within live edit\n        if (lastUpdateValue !== data[field]) {\n          lastUpdateValue = data[field];\n          element.textContent = data[field];\n          handlePlaceholderClass(element);\n        }\n      }, field); // Resolve issues of content editable being within an anchor\n\n      if ((0, _jquery.default)(element).parent().is(\"a\")) {\n        (0, _jquery.default)(element).parent().attr(\"draggable\", \"false\");\n      }\n    },\n\n    /**\n     * Update live edit binding on an element\n     *\n     * @param {any} element\n     * @param {() => any} valueAccessor\n     * @param {KnockoutAllBindingsAccessor} allBindings\n     * @param {any} viewModel\n     * @param {KnockoutBindingContext} bindingContext\n     */\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var _valueAccessor2 = valueAccessor(),\n          field = _valueAccessor2.field;\n\n      element.textContent = viewModel.contentType.dataStore.get(field);\n      handlePlaceholderClass(element);\n    }\n  };\n});\n//# sourceMappingURL=live-edit.js.map","Magento_PageBuilder/js/binding/sortable-children.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/utils/array\"], function (_jquery, _knockout, _events, _moveContentType, _array) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _events = _interopRequireDefault(_events);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var draggedContentType; // Create a new sortable Knockout binding\n\n  _knockout.default.bindingHandlers.sortableChildren = {\n    /**\n     * Init the draggable binding on an element\n     *\n     * @param element\n     * @param valueAccessor\n     * @param allBindingsAccessor\n     * @param data\n     * @param context\n     */\n    init: function init(element, valueAccessor, allBindingsAccessor, data, context) {\n      var instance = context.$data.contentType;\n\n      var options = _knockout.default.unwrap(valueAccessor());\n\n      var originalPosition;\n      (0, _jquery.default)(element).sortable(options).on(\"sortstart\", function (event, ui) {\n        originalPosition = ui.item.index();\n        draggedContentType = instance.children()[originalPosition];\n\n        _events.default.trigger(\"childContentType:sortStart\", {\n          instance: instance,\n          originalPosition: originalPosition,\n          ui: ui\n        });\n      }).on(\"sortstop\", function (event, ui) {\n        _events.default.trigger(\"childContentType:sortStop\", {\n          instance: instance,\n          ui: ui,\n          originalPosition: originalPosition\n        });\n      }).on(\"sortupdate\", function (event, ui) {\n        if (this === ui.item.parent()[0]) {\n          var index = ui.item.index();\n\n          var targetParent = _knockout.default.dataFor(ui.item.parent()[0]).contentType;\n\n          if (targetParent && (originalPosition !== index || draggedContentType.parentContentType !== targetParent)) {\n            ui.item.remove();\n\n            if (draggedContentType.parentContentType === targetParent) {\n              (0, _array.moveArrayItem)(instance.children, originalPosition, index);\n            } else {\n              (0, _moveContentType.moveContentType)(draggedContentType, index, targetParent);\n            }\n\n            _events.default.trigger(\"childContentType:sortUpdate\", {\n              instance: instance,\n              newPosition: index,\n              originalPosition: originalPosition,\n              ui: ui,\n              event: event\n            });\n          }\n        }\n      });\n    }\n  };\n});\n//# sourceMappingURL=sortable-children.js.map","Magento_PageBuilder/js/system/config/validator-rules-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (target) {\n        $.validator.addMethod(\n            'validate-google-map-style',\n            function (value) {\n                if ($.mage.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                try {\n                    JSON.parse(value);\n                } catch (e) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Google Maps Style JSON is invalid. Please paste the valid JSON style.')\n        );\n\n        $.validator.addMethod(\n            'validate-greater-than-one',\n            function (value) {\n                return !(value <= 1);\n            },\n            $.mage.__('Please enter a number 2 or greater in this field.')\n        );\n\n        $.validator.addMethod(\n            'validate-default-grid-size',\n            function (value) {\n                return !(parseInt(value, 10) >\n                    parseInt($('[name=\"groups[pagebuilder][fields][column_grid_max][value]\"]').val(), 10)\n                );\n            },\n            $.mage.__('Default grid size must be less than the maximum grid size.')\n        );\n\n        return target;\n    };\n});\n","Magento_PageBuilder/js/system/config/google-maps-api-key-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    /**\n     * Initialize click and input events to handle validation\n     *\n     * @param {Object} config\n     * @param {HTMLElement} el\n     */\n    var GoogleMapsApiKeyValidator = function (config, el) {\n        var sourceElement = $('#' + config.sourceField),\n            initialValue = sourceElement.val(),\n            resultElement = $('#' + config.elementId + ' > .result');\n\n        if (initialValue) {\n            $(el).attr('disabled', false);\n        }\n\n        $(el).on('click', function () {\n            var resultText = config.invalidLabel,\n                resultIcon = 'icon-admin-pagebuilder-error',\n                resultHtml;\n\n            $.ajax({\n                url: config.validateUrl,\n                showLoader: true,\n                data: {\n                    googleMapsApiKey: sourceElement.val()\n                }\n            }).done(function (data) {\n                if (data.success) {\n                    resultText = config.validLabel;\n                    resultIcon = 'icon-admin-pagebuilder-success';\n                }\n\n                resultHtml = '<i class=\"' + resultIcon + '\"></i> ' + resultText;\n                resultElement.html(resultHtml);\n            });\n        });\n\n        sourceElement.on('keyup', function (event) {\n            var elementValue = event.currentTarget.value,\n                buttonText = config.buttonLabel;\n\n            $(el).attr('disabled', !elementValue);\n            resultElement.html(buttonText);\n        });\n    };\n\n    return GoogleMapsApiKeyValidator;\n});\n","Magento_PageBuilder/js/system/config/switch-attribute-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/confirm',\n    'domReady!'\n], function ($, $t, confirm) {\n    'use strict';\n\n    return function (config, attributeDropDownEl) {\n\n        var $attributeDropDownEl = $(attributeDropDownEl),\n            previousOption = '';\n\n        $attributeDropDownEl.on('focus', function () {\n            // Store the current value on focus and on change\n            previousOption = this.value;\n        });\n\n        $attributeDropDownEl.on('change', function () {\n\n            if (attributeDropDownEl.options.length > 3 ||\n                this.value === 'pagebuilder' ||\n                previousOption !== 'pagebuilder'\n            ) {\n                return;\n            }\n\n            confirm({\n                title: $t(config.modalTitleText),\n                content: $t(config.modalContentBody),\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss action-pagebuilder-cancel',\n\n                    /**\n                     * Close modal and trigger 'cancel' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Change Input Type'),\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Close modal and trigger 'confirm' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event, true);\n                    }\n                }],\n                actions: {\n\n                    /**\n                     * Revert back to 'pagebuilder' setting\n                     */\n                    cancel: function () {\n                        $attributeDropDownEl.val('pagebuilder');\n                        $attributeDropDownEl.trigger('change');\n                    }\n                }\n            });\n        });\n    };\n});\n","Magento_PageBuilder/js/system/config/enable-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/confirm',\n    'domReady!'\n], function ($, $t, confirm) {\n    'use strict';\n\n    return function (config, enableSelectEl) {\n\n        var $enableSelectEl = $(enableSelectEl),\n            isEnabledInDatabase = !!parseInt($enableSelectEl.val(), 10);\n\n        $enableSelectEl.on('change', function () {\n            var userIsDisabling = !parseInt($enableSelectEl.val(), 10);\n\n            if (!isEnabledInDatabase || !userIsDisabling) {\n                return;\n            }\n\n            confirm({\n                title: $t(config.modalTitleText),\n                content: $t(config.modalContentBody),\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss action-pagebuilder-cancel',\n\n                    /**\n                     * Close modal and trigger 'cancel' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Turn Off'),\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Close modal and trigger 'confirm' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event, true);\n                    }\n                }],\n                actions: {\n\n                    /**\n                     * Revert back to original Enabled setting\n                     */\n                    cancel: function () {\n                        $enableSelectEl.val(Number(true));\n                    }\n                }\n            });\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type-menu/edit.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\"], function (_events, _mageUtils, _underscore, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Edit = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {ContentTypeInterface} instance\n     * @param {DataStore} dataStore\n     */\n    function Edit(instance, dataStore) {\n      var _this = this;\n\n      this.instance = instance;\n      this.dataStore = dataStore;\n\n      _events.on(\"form:\" + this.instance.id + \":saveAfter\", function (data) {\n        var viewport = _config.getConfig(\"viewport\");\n\n        var defaultViewport = _config.getConfig(\"defaultViewport\"); // set value to dataStore from default viewport if it is empty\n\n\n        if (defaultViewport !== viewport) {\n          _underscore.each(_this.instance.getViewportFields(viewport, data), function (value, key) {\n            var isEmpty = !_underscore.find(_mageUtils.compare(data[key], _this.instance.dataStores[defaultViewport].get(key)).changes, function (change) {\n              return !_underscore.isEmpty(change.oldValue);\n            });\n\n            if (isEmpty) {\n              _this.instance.dataStores[viewport].set(key, data[key]);\n\n              data[key] = _this.instance.dataStores[defaultViewport].get(key);\n            }\n          });\n        }\n\n        _this.dataStore.setState(_this.filterData(data));\n      });\n    }\n    /**\n     * Open the modal\n     */\n\n\n    var _proto = Edit.prototype;\n\n    _proto.open = function open() {\n      var _this2 = this;\n\n      var contentTypeData = this.dataStore.getState();\n\n      var viewport = _config.getConfig(\"viewport\");\n\n      var defaultViewport = _config.getConfig(\"defaultViewport\"); // set empty value if it the same in default viewport\n\n\n      if (defaultViewport !== viewport) {\n        _underscore.each(this.instance.getViewportFields(viewport, contentTypeData), function (value, key) {\n          if (_mageUtils.compare(contentTypeData[key], _this2.instance.dataStores.desktop.get(key)).equal) {\n            contentTypeData[key] = undefined;\n          }\n        });\n      }\n\n      _events.trigger(\"contentType:editBefore\", {\n        contentType: this.instance\n      });\n\n      _events.trigger(\"form:renderAfter\", {\n        data: contentTypeData,\n        appearances: this.instance.config.appearances,\n        defaultNamespace: this.getDefaultNamespaceForm(),\n        id: this.instance.id,\n        namespace: this.getFormNamespace(contentTypeData),\n        title: this.instance.config.label\n      });\n    }\n    /**\n     * Flip flop to JSON and back again to ensure all data received from the form is serializable. Magento by default\n     * adds functions into some basic types which cannot be serialized when calling PostMessage.\n     *\n     * @param {DataObject} data\n     * @returns {DataObject}\n     */\n    ;\n\n    _proto.filterData = function filterData(data) {\n      return JSON.parse(JSON.stringify(data));\n    }\n    /**\n     * Determine the form namespace based on the currently set appearance\n     *\n     * @param {DataObject} contentTypeData\n     * @returns {string}\n     */\n    ;\n\n    _proto.getFormNamespace = function getFormNamespace(contentTypeData) {\n      var viewport = this.instance.preview.viewport();\n      var currentAppearance = this.dataStore.get(\"appearance\");\n      var appearance = this.instance.config.appearances[currentAppearance];\n      var breakpoints = appearance.breakpoints;\n      var formNamespace = this.getDefaultNamespaceForm(); // Use the default form unless a custom one is defined\n\n      if (breakpoints && breakpoints[viewport] && breakpoints[viewport].form) {\n        formNamespace = breakpoints[viewport].form;\n      } else if (!_underscore.isUndefined(appearance.form)) {\n        formNamespace = appearance.form;\n      }\n\n      return formNamespace;\n    }\n    /**\n     * Determine the form default namespace based on the currently set appearance and breakpoint\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getDefaultNamespaceForm = function getDefaultNamespaceForm() {\n      var viewport = this.instance.preview.viewport();\n      var breakpoints = this.instance.config.breakpoints;\n      var formNamespace = this.instance.config.form;\n\n      if (breakpoints && breakpoints[viewport] && breakpoints[viewport].form) {\n        formNamespace = breakpoints[viewport].form;\n      }\n\n      return formNamespace;\n    };\n\n    return Edit;\n  }();\n\n  return Edit;\n});\n//# sourceMappingURL=edit.js.map","Magento_PageBuilder/js/content-type-menu/conditional-remove-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/option\"], function (_option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConditionalRemoveOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(ConditionalRemoveOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} config\n     */\n    function ConditionalRemoveOption(config) {\n      var _this;\n\n      _this = _option2.call(this, config) || this;\n      var parentContentType = _this.preview.contentType.parentContentType;\n\n      if (parentContentType.children().length < 2) {\n        _this.isDisabled(true);\n      }\n\n      parentContentType.children.subscribe(function (children) {\n        _this.isDisabled(children.length < 2);\n      });\n      return _this;\n    }\n\n    return ConditionalRemoveOption;\n  }(_option);\n\n  return ConditionalRemoveOption;\n});\n//# sourceMappingURL=conditional-remove-option.js.map","Magento_PageBuilder/js/content-type-menu/option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"knockout\"], function (_knockout) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Option = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {OptionConfigInterface} config\n     */\n    function Option(config) {\n      var _this = this;\n\n      this.icon = _knockout.observable(\"\");\n      this.title = _knockout.observable(\"\");\n      this.classes = _knockout.observable({});\n      this.isDisabled = _knockout.observable(false);\n      this.config = config;\n      this.preview = config.preview;\n      this.icon(config.icon);\n      this.title(config.title);\n      this.code = config.code;\n      this.sort = config.sort || 0;\n      this.customTemplate = config.template; // Generate an array of classes for KO to consume\n\n      var koClasses = {};\n\n      if (config.classes && config.classes.length > 0) {\n        config.classes.forEach(function (cssClass) {\n          koClasses[cssClass] = true;\n        });\n      } // Always add a disabled class which tracks whether this option is disabled\n\n\n      koClasses.disabled = this.isDisabled;\n      this.classes(koClasses); // If no action is supplied pass an empty function, this is called within the context of the preview\n\n      var action = config.action ? config.action : function () {\n        return;\n      };\n\n      this.action = function () {\n        if (!_this.isDisabled()) {\n          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n            args[_key] = arguments[_key];\n          }\n\n          action.apply(_this.preview, args);\n        }\n      };\n    }\n\n    _createClass(Option, [{\n      key: \"template\",\n      get: function get() {\n        return this.customTemplate || null;\n      }\n    }]);\n\n    return Option;\n  }();\n\n  return Option;\n});\n//# sourceMappingURL=option.js.map","Magento_PageBuilder/js/content-type-menu/title-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/option\"], function (_option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var TitleOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(TitleOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} options\n     */\n    function TitleOption(options) {\n      var _this;\n\n      _this = _option2.call(this, options) || this; // Modify the icon when changes are made to display in the data store\n\n      _this.preview.displayLabel.subscribe(function (label) {\n        _this.title(label);\n      });\n\n      return _this;\n    }\n\n    return TitleOption;\n  }(_option);\n\n  return TitleOption;\n});\n//# sourceMappingURL=title-option.js.map","Magento_PageBuilder/js/content-type-menu/hide-show-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/option\"], function (_translate, _option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var HideShowOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(HideShowOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} options\n     */\n    function HideShowOption(options) {\n      var _this;\n\n      _this = _option2.call(this, options) || this; // Modify the icon when changes are made to display in the data store\n\n      _this.preview.contentType.dataStore.subscribe(_this.onDisplayChange.bind(_assertThisInitialized(_this)), \"display\");\n\n      return _this;\n    }\n    /**\n     * On display change update the title and icon\n     *\n     * @param {DataObject} state\n     */\n\n\n    var _proto = HideShowOption.prototype;\n\n    _proto.onDisplayChange = function onDisplayChange(state) {\n      var display = !!state.display;\n\n      if (display) {\n        this.icon(HideShowOption.hideIcon);\n        this.title(HideShowOption.hideText);\n      } else {\n        this.icon(HideShowOption.showIcon);\n        this.title(HideShowOption.showText);\n      }\n    };\n\n    return HideShowOption;\n  }(_option);\n\n  HideShowOption.showText = (0, _translate)(\"Show\");\n  HideShowOption.showIcon = \"<i class='icon-pagebuilder-show'></i>\";\n  HideShowOption.hideText = (0, _translate)(\"Hide\");\n  HideShowOption.hideIcon = \"<i class='icon-pagebuilder-hide'></i>\";\n  return HideShowOption;\n});\n//# sourceMappingURL=hide-show-option.js.map","Magento_PageBuilder/js/master-format/filter-html.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Filter the HTML output to only include necessary attributes & nodes\n   *\n   * @param {JQuery} element\n   * @returns {JQuery}\n   */\n  function filterHtml(element) {\n    var isWhiteSpaceOrComment = function isWhiteSpaceOrComment() {\n      return this.nodeType === Node.COMMENT_NODE || this.nodeType === Node.TEXT_NODE && this.data.match(/^\\s+$/);\n    };\n\n    element.find(\"[data-bind]\").each(function (index, value) {\n      (0, _jquery)(value).removeAttr(\"data-bind\");\n    });\n    element.contents().filter(isWhiteSpaceOrComment).remove();\n    element.find(\"*\").filter(function (index, descendentEl) {\n      // filter out elements that are iframes or have .bypass-html-filter ancestor\n      var isIframe = descendentEl.tagName === \"IFRAME\";\n      var isBeingBypassedByThisFilter = !!(0, _jquery)(descendentEl).closest(\".bypass-html-filter\").length;\n      return !isIframe && !isBeingBypassedByThisFilter;\n    }).each(function (index, descendentEl) {\n      (0, _jquery)(descendentEl).contents().filter(isWhiteSpaceOrComment).remove();\n    });\n    element.find(\"[data-wrapper]\").each(function (index, value) {\n      (0, _jquery)(value).parent().append((0, _jquery)(value).children());\n      (0, _jquery)(value).remove();\n    });\n    element.find(\".bypass-html-filter\").each(function (index, value) {\n      (0, _jquery)(value).removeClass(\"bypass-html-filter\").filter('[class=\"\"]').removeAttr(\"class\");\n    });\n    return element;\n  }\n\n  return filterHtml;\n});\n//# sourceMappingURL=filter-html.js.map","Magento_PageBuilder/js/master-format/validator.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate if content has page builder format by checking for any data-content-type attributes\n   *\n   * @param {string} content\n   * @returns {boolean}\n   */\n  function validate(content) {\n    var stageDocument = new DOMParser().parseFromString(content, \"text/html\");\n    return !!stageDocument.querySelector(\"[\" + _config.getConfig(\"dataContentTypeAttributeName\") + \"]\");\n  }\n\n  return validate;\n});\n//# sourceMappingURL=validator.js.map","Magento_PageBuilder/js/master-format/render.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/master-format/render/serialize\"], function (_jquery, _config, _serialize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var MasterFormatRenderer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param stageId\n     */\n    function MasterFormatRenderer(stageId) {\n      this.ready = false;\n      this.readyDeferred = _jquery.Deferred();\n      this.stageId = stageId;\n    }\n    /**\n     * Render the root container into a string utilising our sandboxed iframe\n     *\n     * @param {ContentTypeCollection} rootContainer\n     * @returns {Promise<string>}\n     */\n\n\n    var _proto = MasterFormatRenderer.prototype;\n\n    _proto.applyBindings = function applyBindings(rootContainer) {\n      var _this = this;\n\n      return new Promise(function (resolve, reject) {\n        if (!_this.getRenderFrame()) {\n          // If the stage exists we should also have a frame\n          if (document.getElementById(_this.stageId)) {\n            return reject(\"No render frame present for Page Builder instance.\");\n          } // Otherwise the instance of Page Builder has been removed from the DOM and this is an old instance.\n\n\n          return reject();\n        }\n\n        if (_this.ready) {\n          _this.channel.port1.postMessage({\n            type: \"render\",\n            message: {\n              stageId: _this.stageId,\n              tree: (0, _serialize.getSerializedTree)(rootContainer)\n            }\n          });\n\n          _this.channel.port1.onmessage = function (event) {\n            if (event.isTrusted) {\n              if (event.data.type === \"render\") {\n                resolve(event.data.message);\n              }\n\n              if (event.data.type === \"template\") {\n                _this.loadTemplate(event.data.message);\n              }\n            } else {\n              reject(\"Render event was not trusted.\");\n            }\n          };\n        } else {\n          _this.readyDeferred.then(function () {\n            _this.applyBindings(rootContainer).then(function (rendered) {\n              resolve(rendered);\n            }).catch(function (error) {\n              reject(error);\n            });\n          });\n        }\n      });\n    }\n    /**\n     * Create a channel to communicate with our sandboxed iframe. Firstly add a listener to the current window and then\n     * set the src of the iframe. Listening for a specific message event with a predefined term and then hand over the\n     * MessageChannel port to allow communication between the main window and iframe.\n     */\n    ;\n\n    _proto.setupChannel = function setupChannel() {\n      var _this2 = this;\n\n      this.channel = new MessageChannel();\n      var frame = this.getRenderFrame();\n      window.addEventListener(\"message\", function (event) {\n        if (!_this2.ready && event.data.name === \"PB_RENDER_READY\" && _this2.stageId === event.data.stageId) {\n          frame.contentWindow.postMessage(\"PB_RENDER_PORT\", \"*\", [_this2.channel.port2]);\n          _this2.ready = true;\n\n          _this2.readyDeferred.resolve();\n        }\n      });\n      frame.src = _config.getConfig(\"render_url\") + \"?stageId=\" + this.stageId;\n    }\n    /**\n     * Use the text! RequireJS plugin to load a template and send it back to the child render iframe\n     *\n     * @param name\n     */\n    ;\n\n    _proto.loadTemplate = function loadTemplate(name) {\n      var _this3 = this;\n\n      require([\"text!\" + name], function (template) {\n        _this3.channel.port1.postMessage({\n          type: \"template\",\n          message: {\n            name: name,\n            template: template\n          }\n        });\n      });\n    }\n    /**\n     * Retrieve the render frame\n     *\n     * @returns {HTMLIFrameElement}\n     */\n    ;\n\n    _proto.getRenderFrame = function getRenderFrame() {\n      return document.getElementById(\"render_frame_\" + this.stageId);\n    };\n\n    return MasterFormatRenderer;\n  }();\n\n  return MasterFormatRenderer;\n});\n//# sourceMappingURL=render.js.map","Magento_PageBuilder/js/master-format/read-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=read-interface.js.map","Magento_PageBuilder/js/master-format/read/configurable.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"jquery\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/appearance-config\", \"Magento_PageBuilder/js/converter/converter-pool-factory\", \"Magento_PageBuilder/js/mass-converter/converter-pool-factory\", \"Magento_PageBuilder/js/property/property-reader-pool-factory\"], function (_jquery, _mageUtils, _underscore, _config, _appearanceConfig, _converterPoolFactory, _converterPoolFactory2, _propertyReaderPoolFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Configurable = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Configurable() {}\n\n    var _proto = Configurable.prototype;\n\n    /**\n     * Read data from the dom based on configuration\n     *\n     * @param element HTMLElement\n     * @returns {Promise<any>}\n     */\n    _proto.read = function read(element) {\n      var _this = this;\n\n      var role = element.getAttribute(_config.getConfig(\"dataContentTypeAttributeName\"));\n      var config = (0, _appearanceConfig)(role, element.getAttribute(\"data-appearance\"));\n      var componentsPromise = [(0, _propertyReaderPoolFactory)(role), (0, _converterPoolFactory)(role), (0, _converterPoolFactory2)(role)];\n      return new Promise(function (resolve) {\n        Promise.all(componentsPromise).then(function (loadedComponents) {\n          var propertyReaderPool = loadedComponents[0],\n              converterPool = loadedComponents[1],\n              massConverterPool = loadedComponents[2];\n\n          var viewports = _config.getConfig(\"viewports\");\n\n          var data = {};\n\n          _underscore.each(viewports, function (viewport, name) {\n            return data[name] = {};\n          });\n\n          var _loop = function _loop() {\n            var elementName = _Object$keys[_i];\n            var elementConfig = config.elements[elementName];\n\n            var currentElement = _this.findElementByName(element, elementName); // If we cannot locate the current element skip trying to read any attributes from it\n\n\n            if (currentElement === null || currentElement === undefined) {\n              return \"continue\";\n            }\n\n            _underscore.each(viewports, function (viewportObj, viewport) {\n              currentElement.setAttribute(\"style\", currentElement.getAttribute(\"data-\" + viewport + \"-style\"));\n\n              if (elementConfig.style.length) {\n                data[viewport] = _this.readStyle(elementConfig.style, currentElement, data[viewport], propertyReaderPool, converterPool);\n              }\n\n              if (elementConfig.attributes.length) {\n                data[viewport] = _this.readAttributes(elementConfig.attributes, currentElement, data[viewport], propertyReaderPool, converterPool);\n              }\n\n              if (undefined !== elementConfig.html.var) {\n                data[viewport] = _this.readHtml(elementConfig, currentElement, data[viewport], converterPool);\n              }\n\n              if (undefined !== elementConfig.tag.var) {\n                data[viewport] = _this.readHtmlTag(elementConfig, currentElement, data[viewport]);\n              }\n\n              if (undefined !== elementConfig.css.var) {\n                data[viewport] = _this.readCss(elementConfig, currentElement, data[viewport]);\n              }\n            });\n          };\n\n          for (var _i = 0, _Object$keys = Object.keys(config.elements); _i < _Object$keys.length; _i++) {\n            var _ret = _loop();\n\n            if (_ret === \"continue\") continue;\n          }\n\n          _underscore.each(viewports, function (viewportObj, viewport) {\n            data[viewport] = _this.convertData(config, data[viewport], massConverterPool);\n          });\n\n          resolve(data);\n        }).catch(function (error) {\n          console.error(error);\n        });\n      });\n    }\n    /**\n     * Find the element for the current content type by it's name, avoiding searching in other content types by\n     * removing any other element which contains it's own data-content-type.\n     *\n     * @param {HTMLElement} element\n     * @param {string} name\n     * @returns {HTMLElement}\n     */\n    ;\n\n    _proto.findElementByName = function findElementByName(element, name) {\n      // Create a clone of the element to avoid modifying the source\n      var currentElement = (0, _jquery)(element).clone();\n\n      if (currentElement.attr(\"data-element\") === name) {\n        return currentElement[0];\n      } // Attempt to find the element in the children of the data-content-type\n\n\n      var searchInChildren = currentElement.find(\"[data-element=\\\"\" + name + \"\\\"]\"); // Ensure the element is within the current content type\n\n      if (searchInChildren.length > 0 && searchInChildren.closest(\"[data-content-type]\")[0] === currentElement[0]) {\n        return searchInChildren[0];\n      }\n\n      return null;\n    }\n    /**\n     * Read attributes for element\n     *\n     * @param {DataMappingAttributesInterface[]} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof PropertyReaderPool} propertyReaderPool\n     * @param {typeof ConverterPool} converterPool\n     * @returns {any}\n     */\n    ;\n\n    _proto.readAttributes = function readAttributes(config, element, data, propertyReaderPool, converterPool) {\n      var result = {};\n\n      for (var _iterator = _createForOfIteratorHelperLoose(config), _step; !(_step = _iterator()).done;) {\n        var attributeConfig = _step.value;\n\n        if (\"write\" === attributeConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = !!attributeConfig.static ? attributeConfig.value : propertyReaderPool.get(attributeConfig.reader).read(element, attributeConfig.name);\n\n        if (converterPool.get(attributeConfig.converter)) {\n          value = converterPool.get(attributeConfig.converter).fromDom(value);\n        }\n\n        if (_jquery.type(result[attributeConfig.var]) === \"object\") {\n          var _mageUtils$extend;\n\n          value = _mageUtils.extend((_mageUtils$extend = {}, _mageUtils$extend[attributeConfig.name] = value, _mageUtils$extend), result[attributeConfig.var]);\n        }\n\n        result[attributeConfig.var] = value;\n      }\n\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read style properties for element\n     *\n     * @param {DataMappingStyleInterface[]} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof PropertyReaderPool} propertyReaderPool\n     * @param {typeof ConverterPool} converterPool\n     * @returns {{[p: string]: string}}\n     */\n    ;\n\n    _proto.readStyle = function readStyle(config, element, data, propertyReaderPool, converterPool) {\n      var result = _underscore.extend({}, data);\n\n      for (var _iterator2 = _createForOfIteratorHelperLoose(config), _step2; !(_step2 = _iterator2()).done;) {\n        var propertyConfig = _step2.value;\n\n        if (\"write\" === propertyConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = !!propertyConfig.static ? propertyConfig.value : propertyReaderPool.get(propertyConfig.reader).read(element, propertyConfig.name);\n\n        if (converterPool.get(propertyConfig.converter)) {\n          value = converterPool.get(propertyConfig.converter).fromDom(value);\n        }\n\n        if (_jquery.type(result[propertyConfig.var]) === \"object\") {\n          value = _mageUtils.extend(result[propertyConfig.var], value);\n        }\n\n        result[propertyConfig.var] = value;\n      }\n\n      return result;\n    }\n    /**\n     * Read element's tag\n     *\n     * @param {object} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @returns {object}\n     */\n    ;\n\n    _proto.readHtmlTag = function readHtmlTag(config, element, data) {\n      var result = {};\n      result[config.tag.var] = element.nodeName.toLowerCase();\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read element's css\n     *\n     * @param {ContentTypeConfigAppearanceElementInterface} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @returns {any}\n     */\n    ;\n\n    _proto.readCss = function readCss(config, element, data) {\n      var result = {};\n      var css = element.getAttribute(\"class\") !== null ? element.getAttribute(\"class\") : \"\";\n\n      if (config.css !== undefined && config.css.filter !== undefined && config.css.filter.length) {\n        for (var _iterator3 = _createForOfIteratorHelperLoose(config.css.filter), _step3; !(_step3 = _iterator3()).done;) {\n          var filterClass = _step3.value;\n          css = css.replace(filterClass, \"\");\n        }\n      }\n\n      result[config.css.var] = css.replace(/\\s{2,}/g, \" \").trim();\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read element's content\n     *\n     * @param {ContentTypeConfigAppearanceElementInterface} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof ConverterPool} converterPool\n     * @returns {any}\n     */\n    ;\n\n    _proto.readHtml = function readHtml(config, element, data, converterPool) {\n      var result = {};\n      var value = element.innerHTML;\n\n      if (converterPool.get(config.html.converter)) {\n        value = converterPool.get(config.html.converter).fromDom(value);\n      }\n\n      result[config.html.var] = value;\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Convert data after it's read for all elements\n     *\n     * @param config\n     * @param {object} data\n     * @param {typeof MassConverterPool} massConverterPool\n     * @returns {object}\n     */\n    ;\n\n    _proto.convertData = function convertData(config, data, massConverterPool) {\n      for (var _iterator4 = _createForOfIteratorHelperLoose(config.converters), _step4; !(_step4 = _iterator4()).done;) {\n        var converterConfig = _step4.value;\n\n        if (massConverterPool.get(converterConfig.component)) {\n          data = massConverterPool.get(converterConfig.component).fromDom(data, converterConfig.config);\n        }\n      }\n\n      return data;\n    };\n\n    return Configurable;\n  }();\n\n  return Configurable;\n});\n//# sourceMappingURL=configurable.js.map","Magento_PageBuilder/js/master-format/render/events.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * The frame does not need to create or observe events, however the app will naturally attempt to. So let's stop that!\n   */\n  var _default = {\n    on: function on() {\n      return this;\n    },\n    off: function off() {\n      return this;\n    },\n    trigger: function trigger() {\n      return this;\n    }\n  };\n  return _default;\n});\n//# sourceMappingURL=events.js.map","Magento_PageBuilder/js/master-format/render/serialize.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-collection\"], function (_config, _contentTypeCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Serialize the tree as a simplified object for rendering\n   *\n   * @param contentType\n   */\n  function buildTree(contentType) {\n    var data = getData(contentType);\n    var viewportsData = getViewportsData(contentType);\n    var tree = {\n      name: contentType.config.name,\n      id: contentType.id,\n      data: data,\n      children: [],\n      viewportsData: viewportsData\n    };\n\n    if (contentType instanceof _contentTypeCollection && contentType.getChildren()().length > 0) {\n      contentType.getChildren()().forEach(function (child) {\n        tree.children.push(buildTree(child));\n      });\n    }\n\n    return tree;\n  }\n  /**\n   * Get a serialized version of the tree\n   *\n   * @param contentType\n   */\n\n\n  function getSerializedTree(contentType) {\n    return buildTree(contentType);\n  }\n  /**\n   * Retrieve the master data from the content types instance\n   *\n   * @param contentType\n   */\n\n\n  function getData(contentType) {\n    /**\n     * Flip flop to JSON and back again to ensure all data is serializable. Magento by default adds functions into\n     * some basic types which cannot be serialized when calling PostMessage.\n     */\n    return JSON.parse(JSON.stringify(contentType.dataStores[_config.getConfig(\"defaultViewport\")].getState())) || {};\n  }\n  /**\n   * Retrieve the master data from the content types instance\n   *\n   * @param contentType\n   */\n\n\n  function getViewportsData(contentType) {\n    /**\n     * Flip flop to JSON and back again to ensure all data is serializable. Magento by default adds functions into\n     * some basic types which cannot be serialized when calling PostMessage.\n     */\n    var result = {};\n    Object.keys(contentType.dataStores).forEach(function (name) {\n      result[name] = JSON.parse(JSON.stringify(contentType.dataStores[name].getState())) || {};\n    });\n    return result;\n  }\n\n  return {\n    buildTree: buildTree,\n    getSerializedTree: getSerializedTree\n  };\n});\n//# sourceMappingURL=serialize.js.map","Magento_PageBuilder/js/master-format/render/frame.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"csso\", \"jquery\", \"knockout\", \"Magento_Ui/js/lib/knockout/template/engine\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/binding/master-style\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/master-format/filter-html\"], function (_csso, _jquery, _knockout, _engine, _mageUtils, _underscore, _masterStyle, _config, _contentTypeFactory, _styleRegistry, _directives, _filterHtml) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var port = null;\n\n  var portDeferred = _jquery.Deferred();\n\n  var deferredTemplates = {};\n  var lastRenderId;\n  /**\n   * Debounce the render call, so we don't render until the final request\n   */\n\n  var debounceRender = _underscore.debounce(function (message, renderId) {\n    render(message, renderId).then(function (output) {\n      // Only post the most recent render back to the parent\n      if (lastRenderId === renderId) {\n        port.postMessage({\n          type: \"render\",\n          message: output\n        });\n      }\n    });\n  }, 50);\n  /**\n   * Listen for requests from the parent window for a render\n   */\n\n\n  function listen(config) {\n    var stageId = window.location.href.split(\"?\")[1].split(\"=\")[1];\n\n    _config.setConfig(config);\n\n    _config.setMode(\"Master\"); // Override assign with extend to prevent deep object overriding.\n\n\n    Object.assign = _mageUtils.extend;\n    /**\n     * Create a listener within our iframe so we can observe messages from the parent, once we receive a port on the\n     * MessageChannel we utilise that for all communication.\n     */\n\n    window.addEventListener(\"message\", function (event) {\n      if (event.ports && event.ports.length) {\n        port = event.ports[0];\n        portDeferred.resolve(port);\n\n        port.onmessage = function (messageEvent) {\n          if (messageEvent.data.type === \"render\") {\n            var renderId = _mageUtils.uniqueid();\n\n            lastRenderId = renderId;\n            debounceRender(messageEvent.data.message, renderId);\n          }\n\n          if (messageEvent.data.type === \"template\") {\n            var message = messageEvent.data.message;\n\n            if (message.name in deferredTemplates) {\n              deferredTemplates[message.name].resolve(message.template);\n              delete deferredTemplates[message.name];\n            }\n          }\n        };\n      }\n    }, false); // Inform the parent iframe that we're ready to receive the port\n\n    window.parent.postMessage({\n      name: \"PB_RENDER_READY\",\n      stageId: stageId\n    }, \"*\");\n  }\n  /**\n   * Use our MessageChannel to load a template from the parent window, this is required as the iframe isn't allowed to\n   * make same origin XHR requests.\n   *\n   * @param name\n   */\n\n\n  function loadTemplate(name) {\n    return new Promise(function (resolve) {\n      if (!(name in deferredTemplates)) {\n        deferredTemplates[name] = _jquery.Deferred();\n      }\n\n      deferredTemplates[name].then(function (template) {\n        resolve(template);\n      });\n\n      if (port) {\n        port.postMessage({\n          type: \"template\",\n          message: name\n        });\n      } else {\n        portDeferred.then(function (messagePort) {\n          messagePort.postMessage({\n            type: \"template\",\n            message: name\n          });\n        });\n      }\n    });\n  }\n  /**\n   * Assert if the render has finished\n   */\n\n\n  var assertRenderFinished = _underscore.debounce(function (element, expectedCount, callback) {\n    if (element.querySelectorAll(\"[data-content-type]\").length === expectedCount) {\n      callback();\n    }\n  }, 50);\n  /**\n   * Iterate over the root container and count all content types\n   *\n   * @param rootContainer\n   * @param count\n   */\n\n\n  function countContentTypes(rootContainer, count) {\n    count = count || 0;\n    rootContainer.getChildren()().forEach(function (child) {\n      ++count;\n\n      if (typeof child.getChildren !== \"undefined\" && child.getChildren()().length > 0) {\n        count = countContentTypes(child, count);\n      }\n    });\n    return count;\n  }\n  /**\n   * Perform a render of the provided data\n   *\n   * @param message\n   * @param renderId\n   */\n\n\n  function render(message, renderId) {\n    var styleRegistries = {};\n\n    _underscore.each(_config.getConfig(\"viewports\"), function (viewport, name) {\n      styleRegistries[name] = new _styleRegistry(name + renderId);\n    });\n\n    return new Promise(function (resolve, reject) {\n      createRenderTree(message.stageId, message.tree).then(function (rootContainer) {\n        var element = document.createElement(\"div\");\n        /**\n         * Setup an event on the element to observe changes and count the expected amount of content types are\n         * present within the content.\n         */\n\n        var renderFinished = _jquery.Deferred();\n\n        var observer = new MutationObserver(function () {\n          assertRenderFinished(element, countContentTypes(rootContainer), renderFinished.resolve);\n        });\n        observer.observe(element, {\n          attributes: true,\n          childList: true,\n          subtree: true\n        }); // Combine this event with our engine waitForRenderFinish to ensure rendering is completed\n\n        _jquery.when(_engine.waitForFinishRender(), renderFinished).then(function () {\n          observer.disconnect();\n\n          _knockout.cleanNode(element);\n\n          var styles = generateMasterCssForViewports(styleRegistries);\n\n          if (styles) {\n            (0, _jquery)(element).append((0, _jquery)(\"<style/>\").html(styles));\n          }\n\n          _underscore.each(styleRegistries, function (value, name) {\n            return (0, _styleRegistry.deleteStyleRegistry)(name + renderId);\n          });\n\n          var filtered = (0, _filterHtml)((0, _jquery)(element));\n          var output = (0, _directives.replaceWithSrc)((0, _directives)(filtered.html()));\n          resolve(output);\n        });\n\n        _knockout.applyBindingsToNode(element, {\n          template: {\n            data: rootContainer.content,\n            name: rootContainer.content.template\n          }\n        }, {\n          id: renderId\n        });\n      }).catch(function (error) {\n        reject(error);\n      });\n    });\n  }\n  /**\n   * Rebuild the content type tree using their original data and configuration\n   *\n   * @param stageId\n   * @param tree\n   * @param parent\n   */\n\n\n  function createRenderTree(stageId, tree, parent) {\n    if (parent === void 0) {\n      parent = null;\n    }\n\n    return new Promise(function (resolve, reject) {\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(tree.name), parent, stageId, tree.data, parent !== null ? tree.children.length : 0, tree.viewportsData).then(function (contentType) {\n        // Ensure  we retain the original tree ID's\n        contentType.id = tree.id;\n\n        if (tree.children.length > 0) {\n          var childPromises = [];\n          tree.children.forEach(function (child) {\n            childPromises.push(createRenderTree(stageId, child, contentType));\n          });\n          Promise.all(childPromises).then(function (children) {\n            children.forEach(function (child) {\n              contentType.addChild(child);\n            });\n            resolve(contentType);\n          });\n        } else {\n          resolve(contentType);\n        }\n      }).catch(function (error) {\n        reject(error);\n      });\n    });\n  }\n  /**\n   * Generate the master format CSS\n   *\n   * @param registry\n   */\n\n\n  function generateMasterCss(registry) {\n    var scopes = Object.keys(registry.getAllStyles()).map(function (selector) {\n      return [selector];\n    });\n    return _csso.minify((0, _styleRegistry.generateCss)(registry.getAllStyles()), {\n      usage: {\n        scopes: scopes\n      }\n    }).css;\n  }\n\n  function generateMasterCssForViewports(registries) {\n    var result = \"\";\n\n    _underscore.each(registries, function (registry, name) {\n      var css = generateMasterCss(registry);\n\n      var media = _config.getConfig(\"viewports\")[name].media;\n\n      if (media && css) {\n        result += \"@media \" + media + \" { \" + css + \" }\";\n      } else {\n        result += css;\n      }\n    });\n\n    return result;\n  }\n\n  return Object.assign(listen, {\n    loadTemplate: loadTemplate\n  });\n});\n//# sourceMappingURL=frame.js.map","Magento_PageBuilder/js/master-format/render/requirejs/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"mage/requirejs/text\", \"Magento_PageBuilder/js/master-format/render/frame\"], function (_text, _frame) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Within our render frame we override the RequireJS text! plugin, this is originally implemented within\n   * lib/web/mage/requirejs/text.js. The override uses the MessageChannel to communicate with the parent frame to\n   * retrieve any requested HTML knockout template. We do this due to the sandbox restrictions on the iframe disallow\n   * XHR requests to the same origin domain.\n   */\n\n  /**\n   * Load a template\n   *\n   * @param name\n   * @param req\n   * @param onLoad\n   */\n  function load(name, req, onLoad) {\n    (0, _frame.loadTemplate)(name).then(function (template) {\n      onLoad(template);\n    }).catch(function (error) {\n      onLoad.error(error);\n    });\n  }\n  /**\n   * Retrieve a template\n   *\n   * @param url\n   * @param callback\n   * @param fail\n   * @param headers\n   */\n\n\n  function get(url, callback, fail, headers) {\n    _text.get.apply(_text, arguments);\n  }\n\n  return {\n    load: load,\n    get: get\n  };\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/resource/object-path.js":"(function (root, factory){\n    'use strict';\n\n    /*istanbul ignore next:cant test*/\n    if (typeof module === 'object' && typeof module.exports === 'object') {\n        module.exports = factory();\n    } else if (typeof define === 'function' && define.amd) {\n        // AMD. Register as an anonymous module.\n        define([], factory);\n    } else {\n        // Browser globals\n        root.objectPath = factory();\n    }\n})(this, function(){\n    'use strict';\n\n    var toStr = Object.prototype.toString;\n    function hasOwnProperty(obj, prop) {\n        if(obj == null) {\n            return false\n        }\n        //to handle objects with null prototypes (too edge case?)\n        return Object.prototype.hasOwnProperty.call(obj, prop)\n    }\n\n    function isEmpty(value){\n        if (!value) {\n            return true;\n        }\n        if (isArray(value) && value.length === 0) {\n            return true;\n        } else if (typeof value !== 'string') {\n            for (var i in value) {\n                if (hasOwnProperty(value, i)) {\n                    return false;\n                }\n            }\n            return true;\n        }\n        return false;\n    }\n\n    function toString(type){\n        return toStr.call(type);\n    }\n\n    function isObject(obj){\n        return typeof obj === 'object' && toString(obj) === \"[object Object]\";\n    }\n\n    var isArray = Array.isArray || function(obj){\n        /*istanbul ignore next:cant test*/\n        return toStr.call(obj) === '[object Array]';\n    }\n\n    function isBoolean(obj){\n        return typeof obj === 'boolean' || toString(obj) === '[object Boolean]';\n    }\n\n    function getKey(key){\n        var intKey = parseInt(key);\n        if (intKey.toString() === key) {\n            return intKey;\n        }\n        return key;\n    }\n\n    function factory(options) {\n        options = options || {}\n\n        var objectPath = function(obj) {\n            return Object.keys(objectPath).reduce(function(proxy, prop) {\n                if(prop === 'create') {\n                    return proxy;\n                }\n\n                /*istanbul ignore else*/\n                if (typeof objectPath[prop] === 'function') {\n                    proxy[prop] = objectPath[prop].bind(objectPath, obj);\n                }\n\n                return proxy;\n            }, {});\n        };\n\n        var hasShallowProperty\n        if (options.includeInheritedProps) {\n            hasShallowProperty = function () {\n                return true\n            }\n        } else {\n            hasShallowProperty = function (obj, prop) {\n                return (typeof prop === 'number' && Array.isArray(obj)) || hasOwnProperty(obj, prop)\n            }\n        }\n\n        function getShallowProperty(obj, prop) {\n            if (hasShallowProperty(obj, prop)) {\n                return obj[prop];\n            }\n        }\n\n        function set(obj, path, value, doNotReplace){\n            if (typeof path === 'number') {\n                path = [path];\n            }\n            if (!path || path.length === 0) {\n                return obj;\n            }\n            if (typeof path === 'string') {\n                return set(obj, path.split('.').map(getKey), value, doNotReplace);\n            }\n            var currentPath = path[0];\n            var currentValue = getShallowProperty(obj, currentPath);\n            if (options.includeInheritedProps && (currentPath === '__proto__' ||\n                (currentPath === 'constructor' && typeof currentValue === 'function'))) {\n                throw new Error('For security reasons, object\\'s magic properties cannot be set')\n            }\n            if (path.length === 1) {\n                if (currentValue === void 0 || !doNotReplace) {\n                    obj[currentPath] = value;\n                }\n                return currentValue;\n            }\n\n            if (currentValue === void 0) {\n                //check if we assume an array\n                if(typeof path[1] === 'number') {\n                    obj[currentPath] = [];\n                } else {\n                    obj[currentPath] = {};\n                }\n            }\n\n            return set(obj[currentPath], path.slice(1), value, doNotReplace);\n        }\n\n        objectPath.has = function (obj, path) {\n            if (typeof path === 'number') {\n                path = [path];\n            } else if (typeof path === 'string') {\n                path = path.split('.');\n            }\n\n            if (!path || path.length === 0) {\n                return !!obj;\n            }\n\n            for (var i = 0; i < path.length; i++) {\n                var j = getKey(path[i]);\n\n                if((typeof j === 'number' && isArray(obj) && j < obj.length) ||\n                    (options.includeInheritedProps ? (j in Object(obj)) : hasOwnProperty(obj, j))) {\n                    obj = obj[j];\n                } else {\n                    return false;\n                }\n            }\n\n            return true;\n        };\n\n        objectPath.ensureExists = function (obj, path, value){\n            return set(obj, path, value, true);\n        };\n\n        objectPath.set = function (obj, path, value, doNotReplace){\n            return set(obj, path, value, doNotReplace);\n        };\n\n        objectPath.insert = function (obj, path, value, at){\n            var arr = objectPath.get(obj, path);\n            at = ~~at;\n            if (!isArray(arr)) {\n                arr = [];\n                objectPath.set(obj, path, arr);\n            }\n            arr.splice(at, 0, value);\n        };\n\n        objectPath.empty = function(obj, path) {\n            if (isEmpty(path)) {\n                return void 0;\n            }\n            if (obj == null) {\n                return void 0;\n            }\n\n            var value, i;\n            if (!(value = objectPath.get(obj, path))) {\n                return void 0;\n            }\n\n            if (typeof value === 'string') {\n                return objectPath.set(obj, path, '');\n            } else if (isBoolean(value)) {\n                return objectPath.set(obj, path, false);\n            } else if (typeof value === 'number') {\n                return objectPath.set(obj, path, 0);\n            } else if (isArray(value)) {\n                value.length = 0;\n            } else if (isObject(value)) {\n                for (i in value) {\n                    if (hasShallowProperty(value, i)) {\n                        delete value[i];\n                    }\n                }\n            } else {\n                return objectPath.set(obj, path, null);\n            }\n        };\n\n        objectPath.push = function (obj, path /*, values */){\n            var arr = objectPath.get(obj, path);\n            if (!isArray(arr)) {\n                arr = [];\n                objectPath.set(obj, path, arr);\n            }\n\n            arr.push.apply(arr, Array.prototype.slice.call(arguments, 2));\n        };\n\n        objectPath.coalesce = function (obj, paths, defaultValue) {\n            var value;\n\n            for (var i = 0, len = paths.length; i < len; i++) {\n                if ((value = objectPath.get(obj, paths[i])) !== void 0) {\n                    return value;\n                }\n            }\n\n            return defaultValue;\n        };\n\n        objectPath.get = function (obj, path, defaultValue){\n            if (typeof path === 'number') {\n                path = [path];\n            }\n            if (!path || path.length === 0) {\n                return obj;\n            }\n            if (obj == null) {\n                return defaultValue;\n            }\n            if (typeof path === 'string') {\n                return objectPath.get(obj, path.split('.'), defaultValue);\n            }\n\n            var currentPath = getKey(path[0]);\n            var nextObj = getShallowProperty(obj, currentPath)\n            if (nextObj === void 0) {\n                return defaultValue;\n            }\n\n            if (path.length === 1) {\n                return nextObj;\n            }\n\n            return objectPath.get(obj[currentPath], path.slice(1), defaultValue);\n        };\n\n        objectPath.del = function del(obj, path) {\n            if (typeof path === 'number') {\n                path = [path];\n            }\n\n            if (obj == null) {\n                return obj;\n            }\n\n            if (isEmpty(path)) {\n                return obj;\n            }\n            if(typeof path === 'string') {\n                return objectPath.del(obj, path.split('.'));\n            }\n\n            var currentPath = getKey(path[0]);\n            if (!hasShallowProperty(obj, currentPath)) {\n                return obj;\n            }\n\n            if(path.length === 1) {\n                if (isArray(obj)) {\n                    obj.splice(currentPath, 1);\n                } else {\n                    delete obj[currentPath];\n                }\n            } else {\n                return objectPath.del(obj[currentPath], path.slice(1));\n            }\n\n            return obj;\n        }\n\n        return objectPath;\n    }\n\n    var mod = factory();\n    mod.create = factory;\n    mod.withInheritedProps = factory({includeInheritedProps: true})\n    return mod;\n});","Magento_PageBuilder/js/resource/slick/slick.min.js":"/*\n     _ _      _       _\n ___| (_) ___| | __  (_)___\n/ __| | |/ __| |/ /  | / __|\n\\__ \\ | | (__|   < _ | \\__ \\\n|___/_|_|\\___|_|\\_(_)/ |___/\n                   |__/\n\n Version: 1.9.0\n  Author: Ken Wheeler\n Website: http://kenwheeler.github.io\n    Docs: http://kenwheeler.github.io/slick\n    Repo: http://github.com/kenwheeler/slick\n  Issues: http://github.com/kenwheeler/slick/issues\n\n */\n(function(i){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],i):\"undefined\"!=typeof exports?module.exports=i(require(\"jquery\")):i(jQuery)})(function(i){\"use strict\";var e=window.Slick||{};e=function(){function e(e,o){var s,n=this;n.defaults={accessibility:!0,adaptiveHeight:!1,appendArrows:i(e),appendDots:i(e),arrows:!0,asNavFor:null,prevArrow:'<button class=\"slick-prev\" aria-label=\"Previous\" type=\"button\">Previous</button>',nextArrow:'<button class=\"slick-next\" aria-label=\"Next\" type=\"button\">Next</button>',autoplay:!1,autoplaySpeed:3e3,centerMode:!1,centerPadding:\"50px\",cssEase:\"ease\",customPaging:function(e,t){return i('<button type=\"button\" />').text(t+1)},dots:!1,dotsClass:\"slick-dots\",draggable:!0,easing:\"linear\",edgeFriction:.35,fade:!1,focusOnSelect:!1,focusOnChange:!1,infinite:!0,initialSlide:0,lazyLoad:\"ondemand\",mobileFirst:!1,pauseOnHover:!0,pauseOnFocus:!0,pauseOnDotsHover:!1,respondTo:\"window\",responsive:null,rows:1,rtl:!1,slide:\"\",slidesPerRow:1,slidesToShow:1,slidesToScroll:1,speed:500,swipe:!0,swipeToSlide:!1,touchMove:!0,touchThreshold:5,useCSS:!0,useTransform:!0,variableWidth:!1,vertical:!1,verticalSwiping:!1,waitForAnimate:!0,zIndex:1e3},n.initials={animating:!1,dragging:!1,autoPlayTimer:null,currentDirection:0,currentLeft:null,currentSlide:0,direction:1,$dots:null,listWidth:null,listHeight:null,loadIndex:0,$nextArrow:null,$prevArrow:null,scrolling:!1,slideCount:null,slideWidth:null,$slideTrack:null,$slides:null,sliding:!1,slideOffset:0,swipeLeft:null,swiping:!1,$list:null,touchObject:{},transformsEnabled:!1,unslicked:!1},i.extend(n,n.initials),n.activeBreakpoint=null,n.animType=null,n.animProp=null,n.breakpoints=[],n.breakpointSettings=[],n.cssTransitions=!1,n.focussed=!1,n.interrupted=!1,n.hidden=\"hidden\",n.paused=!0,n.positionProp=null,n.respondTo=null,n.rowCount=1,n.shouldClick=!0,n.$slider=i(e),n.$slidesCache=null,n.transformType=null,n.transitionType=null,n.visibilityChange=\"visibilitychange\",n.windowWidth=0,n.windowTimer=null,s=i(e).data(\"slick\")||{},n.options=i.extend({},n.defaults,o,s),n.currentSlide=n.options.initialSlide,n.originalSettings=n.options,\"undefined\"!=typeof document.mozHidden?(n.hidden=\"mozHidden\",n.visibilityChange=\"mozvisibilitychange\"):\"undefined\"!=typeof document.webkitHidden&&(n.hidden=\"webkitHidden\",n.visibilityChange=\"webkitvisibilitychange\"),n.autoPlay=i.proxy(n.autoPlay,n),n.autoPlayClear=i.proxy(n.autoPlayClear,n),n.autoPlayIterator=i.proxy(n.autoPlayIterator,n),n.changeSlide=i.proxy(n.changeSlide,n),n.clickHandler=i.proxy(n.clickHandler,n),n.selectHandler=i.proxy(n.selectHandler,n),n.setPosition=i.proxy(n.setPosition,n),n.swipeHandler=i.proxy(n.swipeHandler,n),n.dragHandler=i.proxy(n.dragHandler,n),n.keyHandler=i.proxy(n.keyHandler,n),n.instanceUid=t++,n.htmlExpr=/^(?:\\s*(<[\\w\\W]+>)[^>]*)$/,n.registerBreakpoints(),n.init(!0)}var t=0;return e}(),e.prototype.activateADA=function(){var i=this;i.$slideTrack.find(\".slick-active\").attr({\"aria-hidden\":\"false\"}).find(\"a, input, button, select\").attr({tabindex:\"0\"})},e.prototype.addSlide=e.prototype.slickAdd=function(e,t,o){var s=this;if(\"boolean\"==typeof t)o=t,t=null;else if(t<0||t>=s.slideCount)return!1;s.unload(),\"number\"==typeof t?0===t&&0===s.$slides.length?i(e).appendTo(s.$slideTrack):o?i(e).insertBefore(s.$slides.eq(t)):i(e).insertAfter(s.$slides.eq(t)):o===!0?i(e).prependTo(s.$slideTrack):i(e).appendTo(s.$slideTrack),s.$slides=s.$slideTrack.children(this.options.slide),s.$slideTrack.children(this.options.slide).detach(),s.$slideTrack.append(s.$slides),s.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e)}),s.$slidesCache=s.$slides,s.reinit()},e.prototype.animateHeight=function(){var i=this;if(1===i.options.slidesToShow&&i.options.adaptiveHeight===!0&&i.options.vertical===!1){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.animate({height:e},i.options.speed)}},e.prototype.animateSlide=function(e,t){var o={},s=this;s.animateHeight(),s.options.rtl===!0&&s.options.vertical===!1&&(e=-e),s.transformsEnabled===!1?s.options.vertical===!1?s.$slideTrack.animate({left:e},s.options.speed,s.options.easing,t):s.$slideTrack.animate({top:e},s.options.speed,s.options.easing,t):s.cssTransitions===!1?(s.options.rtl===!0&&(s.currentLeft=-s.currentLeft),i({animStart:s.currentLeft}).animate({animStart:e},{duration:s.options.speed,easing:s.options.easing,step:function(i){i=Math.ceil(i),s.options.vertical===!1?(o[s.animType]=\"translate(\"+i+\"px, 0px)\",s.$slideTrack.css(o)):(o[s.animType]=\"translate(0px,\"+i+\"px)\",s.$slideTrack.css(o))},complete:function(){t&&t.call()}})):(s.applyTransition(),e=Math.ceil(e),s.options.vertical===!1?o[s.animType]=\"translate3d(\"+e+\"px, 0px, 0px)\":o[s.animType]=\"translate3d(0px,\"+e+\"px, 0px)\",s.$slideTrack.css(o),t&&setTimeout(function(){s.disableTransition(),t.call()},s.options.speed))},e.prototype.getNavTarget=function(){var e=this,t=e.options.asNavFor;return t&&null!==t&&(t=i(t).not(e.$slider)),t},e.prototype.asNavFor=function(e){var t=this,o=t.getNavTarget();null!==o&&\"object\"==typeof o&&o.each(function(){var t=i(this).slick(\"getSlick\");t.unslicked||t.slideHandler(e,!0)})},e.prototype.applyTransition=function(i){var e=this,t={};e.options.fade===!1?t[e.transitionType]=e.transformType+\" \"+e.options.speed+\"ms \"+e.options.cssEase:t[e.transitionType]=\"opacity \"+e.options.speed+\"ms \"+e.options.cssEase,e.options.fade===!1?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.autoPlay=function(){var i=this;i.autoPlayClear(),i.slideCount>i.options.slidesToShow&&(i.autoPlayTimer=setInterval(i.autoPlayIterator,i.options.autoplaySpeed))},e.prototype.autoPlayClear=function(){var i=this;i.autoPlayTimer&&clearInterval(i.autoPlayTimer)},e.prototype.autoPlayIterator=function(){var i=this,e=i.currentSlide+i.options.slidesToScroll;i.paused||i.interrupted||i.focussed||(i.options.infinite===!1&&(1===i.direction&&i.currentSlide+1===i.slideCount-1?i.direction=0:0===i.direction&&(e=i.currentSlide-i.options.slidesToScroll,i.currentSlide-1===0&&(i.direction=1))),i.slideHandler(e))},e.prototype.buildArrows=function(){var e=this;e.options.arrows===!0&&(e.$prevArrow=i(e.options.prevArrow).addClass(\"slick-arrow\"),e.$nextArrow=i(e.options.nextArrow).addClass(\"slick-arrow\"),e.slideCount>e.options.slidesToShow?(e.$prevArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.$nextArrow.removeClass(\"slick-hidden\").removeAttr(\"aria-hidden tabindex\"),e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.prependTo(e.options.appendArrows),e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.appendTo(e.options.appendArrows),e.options.infinite!==!0&&e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\")):e.$prevArrow.add(e.$nextArrow).addClass(\"slick-hidden\").attr({\"aria-disabled\":\"true\",tabindex:\"-1\"}))},e.prototype.buildDots=function(){var e,t,o=this;if(o.options.dots===!0&&o.slideCount>o.options.slidesToShow){for(o.$slider.addClass(\"slick-dotted\"),t=i(\"<ul />\").addClass(o.options.dotsClass),e=0;e<=o.getDotCount();e+=1)t.append(i(\"<li />\").append(o.options.customPaging.call(this,o,e)));o.$dots=t.appendTo(o.options.appendDots),o.$dots.find(\"li\").first().addClass(\"slick-active\")}},e.prototype.buildOut=function(){var e=this;e.$slides=e.$slider.children(e.options.slide+\":not(.slick-cloned)\").addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.$slides.each(function(e,t){i(t).attr(\"data-slick-index\",e).data(\"originalStyling\",i(t).attr(\"style\")||\"\")}),e.$slider.addClass(\"slick-slider\"),e.$slideTrack=0===e.slideCount?i('<div class=\"slick-track\"/>').appendTo(e.$slider):e.$slides.wrapAll('<div class=\"slick-track\"/>').parent(),e.$list=e.$slideTrack.wrap('<div class=\"slick-list\"/>').parent(),e.$slideTrack.css(\"opacity\",0),e.options.centerMode!==!0&&e.options.swipeToSlide!==!0||(e.options.slidesToScroll=1),i(\"img[data-lazy]\",e.$slider).not(\"[src]\").addClass(\"slick-loading\"),e.setupInfinite(),e.buildArrows(),e.buildDots(),e.updateDots(),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.options.draggable===!0&&e.$list.addClass(\"draggable\")},e.prototype.buildRows=function(){var i,e,t,o,s,n,r,l=this;if(o=document.createDocumentFragment(),n=l.$slider.children(),l.options.rows>0){for(r=l.options.slidesPerRow*l.options.rows,s=Math.ceil(n.length/r),i=0;i<s;i++){var d=document.createElement(\"div\");for(e=0;e<l.options.rows;e++){var a=document.createElement(\"div\");for(t=0;t<l.options.slidesPerRow;t++){var c=i*r+(e*l.options.slidesPerRow+t);n.get(c)&&a.appendChild(n.get(c))}d.appendChild(a)}o.appendChild(d)}l.$slider.empty().append(o),l.$slider.children().children().children().css({width:100/l.options.slidesPerRow+\"%\",display:\"inline-block\"})}},e.prototype.checkResponsive=function(e,t){var o,s,n,r=this,l=!1,d=r.$slider.width(),a=window.innerWidth||i(window).width();if(\"window\"===r.respondTo?n=a:\"slider\"===r.respondTo?n=d:\"min\"===r.respondTo&&(n=Math.min(a,d)),r.options.responsive&&r.options.responsive.length&&null!==r.options.responsive){s=null;for(o in r.breakpoints)r.breakpoints.hasOwnProperty(o)&&(r.originalSettings.mobileFirst===!1?n<r.breakpoints[o]&&(s=r.breakpoints[o]):n>r.breakpoints[o]&&(s=r.breakpoints[o]));null!==s?null!==r.activeBreakpoint?(s!==r.activeBreakpoint||t)&&(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):(r.activeBreakpoint=s,\"unslick\"===r.breakpointSettings[s]?r.unslick(s):(r.options=i.extend({},r.originalSettings,r.breakpointSettings[s]),e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e)),l=s):null!==r.activeBreakpoint&&(r.activeBreakpoint=null,r.options=r.originalSettings,e===!0&&(r.currentSlide=r.options.initialSlide),r.refresh(e),l=s),e||l===!1||r.$slider.trigger(\"breakpoint\",[r,l])}},e.prototype.changeSlide=function(e,t){var o,s,n,r=this,l=i(e.currentTarget);switch(l.is(\"a\")&&e.preventDefault(),l.is(\"li\")||(l=l.closest(\"li\")),n=r.slideCount%r.options.slidesToScroll!==0,o=n?0:(r.slideCount-r.currentSlide)%r.options.slidesToScroll,e.data.message){case\"previous\":s=0===o?r.options.slidesToScroll:r.options.slidesToShow-o,r.slideCount>r.options.slidesToShow&&r.slideHandler(r.currentSlide-s,!1,t);break;case\"next\":s=0===o?r.options.slidesToScroll:o,r.slideCount>r.options.slidesToShow&&r.slideHandler(r.currentSlide+s,!1,t);break;case\"index\":var d=0===e.data.index?0:e.data.index||l.index()*r.options.slidesToScroll;r.slideHandler(r.checkNavigable(d),!1,t),l.children().trigger(\"focus\");break;default:return}},e.prototype.checkNavigable=function(i){var e,t,o=this;if(e=o.getNavigableIndexes(),t=0,i>e[e.length-1])i=e[e.length-1];else for(var s in e){if(i<e[s]){i=t;break}t=e[s]}return i},e.prototype.cleanUpEvents=function(){var e=this;e.options.dots&&null!==e.$dots&&(i(\"li\",e.$dots).off(\"click.slick\",e.changeSlide).off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)),e.options.accessibility===!0&&e.$dots.off(\"keydown.slick\",e.keyHandler)),e.$slider.off(\"focus.slick blur.slick\"),e.options.arrows===!0&&e.slideCount>e.options.slidesToShow&&(e.$prevArrow&&e.$prevArrow.off(\"click.slick\",e.changeSlide),e.$nextArrow&&e.$nextArrow.off(\"click.slick\",e.changeSlide),e.options.accessibility===!0&&(e.$prevArrow&&e.$prevArrow.off(\"keydown.slick\",e.keyHandler),e.$nextArrow&&e.$nextArrow.off(\"keydown.slick\",e.keyHandler))),e.$list.off(\"touchstart.slick mousedown.slick\",e.swipeHandler),e.$list.off(\"touchmove.slick mousemove.slick\",e.swipeHandler),e.$list.off(\"touchend.slick mouseup.slick\",e.swipeHandler),e.$list.off(\"touchcancel.slick mouseleave.slick\",e.swipeHandler),e.$list.off(\"click.slick\",e.clickHandler),i(document).off(e.visibilityChange,e.visibility),e.cleanUpSlideEvents(),e.options.accessibility===!0&&e.$list.off(\"keydown.slick\",e.keyHandler),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().off(\"click.slick\",e.selectHandler),i(window).off(\"orientationchange.slick.slick-\"+e.instanceUid,e.orientationChange),i(window).off(\"resize.slick.slick-\"+e.instanceUid,e.resize),i(\"[draggable!=true]\",e.$slideTrack).off(\"dragstart\",e.preventDefault),i(window).off(\"load.slick.slick-\"+e.instanceUid,e.setPosition)},e.prototype.cleanUpSlideEvents=function(){var e=this;e.$list.off(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.off(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.cleanUpRows=function(){var i,e=this;e.options.rows>0&&(i=e.$slides.children().children(),i.removeAttr(\"style\"),e.$slider.empty().append(i))},e.prototype.clickHandler=function(i){var e=this;e.shouldClick===!1&&(i.stopImmediatePropagation(),i.stopPropagation(),i.preventDefault())},e.prototype.destroy=function(e){var t=this;t.autoPlayClear(),t.touchObject={},t.cleanUpEvents(),i(\".slick-cloned\",t.$slider).detach(),t.$dots&&t.$dots.remove(),t.$prevArrow&&t.$prevArrow.length&&(t.$prevArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.prevArrow)&&t.$prevArrow.remove()),t.$nextArrow&&t.$nextArrow.length&&(t.$nextArrow.removeClass(\"slick-disabled slick-arrow slick-hidden\").removeAttr(\"aria-hidden aria-disabled tabindex\").css(\"display\",\"\"),t.htmlExpr.test(t.options.nextArrow)&&t.$nextArrow.remove()),t.$slides&&(t.$slides.removeClass(\"slick-slide slick-active slick-center slick-visible slick-current\").removeAttr(\"aria-hidden\").removeAttr(\"data-slick-index\").each(function(){i(this).attr(\"style\",i(this).data(\"originalStyling\"))}),t.$slideTrack.children(this.options.slide).detach(),t.$slideTrack.detach(),t.$list.detach(),t.$slider.append(t.$slides)),t.cleanUpRows(),t.$slider.removeClass(\"slick-slider\"),t.$slider.removeClass(\"slick-initialized\"),t.$slider.removeClass(\"slick-dotted\"),t.unslicked=!0,e||t.$slider.trigger(\"destroy\",[t])},e.prototype.disableTransition=function(i){var e=this,t={};t[e.transitionType]=\"\",e.options.fade===!1?e.$slideTrack.css(t):e.$slides.eq(i).css(t)},e.prototype.fadeSlide=function(i,e){var t=this;t.cssTransitions===!1?(t.$slides.eq(i).css({zIndex:t.options.zIndex}),t.$slides.eq(i).animate({opacity:1},t.options.speed,t.options.easing,e)):(t.applyTransition(i),t.$slides.eq(i).css({opacity:1,zIndex:t.options.zIndex}),e&&setTimeout(function(){t.disableTransition(i),e.call()},t.options.speed))},e.prototype.fadeSlideOut=function(i){var e=this;e.cssTransitions===!1?e.$slides.eq(i).animate({opacity:0,zIndex:e.options.zIndex-2},e.options.speed,e.options.easing):(e.applyTransition(i),e.$slides.eq(i).css({opacity:0,zIndex:e.options.zIndex-2}))},e.prototype.filterSlides=e.prototype.slickFilter=function(i){var e=this;null!==i&&(e.$slidesCache=e.$slides,e.unload(),e.$slideTrack.children(this.options.slide).detach(),e.$slidesCache.filter(i).appendTo(e.$slideTrack),e.reinit())},e.prototype.focusHandler=function(){var e=this;e.$slider.off(\"focus.slick blur.slick\").on(\"focus.slick\",\"*\",function(t){var o=i(this);setTimeout(function(){e.options.pauseOnFocus&&o.is(\":focus\")&&(e.focussed=!0,e.autoPlay())},0)}).on(\"blur.slick\",\"*\",function(t){i(this);e.options.pauseOnFocus&&(e.focussed=!1,e.autoPlay())})},e.prototype.getCurrent=e.prototype.slickCurrentSlide=function(){var i=this;return i.currentSlide},e.prototype.getDotCount=function(){var i=this,e=0,t=0,o=0;if(i.options.infinite===!0)if(i.slideCount<=i.options.slidesToShow)++o;else for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else if(i.options.centerMode===!0)o=i.slideCount;else if(i.options.asNavFor)for(;e<i.slideCount;)++o,e=t+i.options.slidesToScroll,t+=i.options.slidesToScroll<=i.options.slidesToShow?i.options.slidesToScroll:i.options.slidesToShow;else o=1+Math.ceil((i.slideCount-i.options.slidesToShow)/i.options.slidesToScroll);return o-1},e.prototype.getLeft=function(i){var e,t,o,s,n=this,r=0;return n.slideOffset=0,t=n.$slides.first().outerHeight(!0),n.options.infinite===!0?(n.slideCount>n.options.slidesToShow&&(n.slideOffset=n.slideWidth*n.options.slidesToShow*-1,s=-1,n.options.vertical===!0&&n.options.centerMode===!0&&(2===n.options.slidesToShow?s=-1.5:1===n.options.slidesToShow&&(s=-2)),r=t*n.options.slidesToShow*s),n.slideCount%n.options.slidesToScroll!==0&&i+n.options.slidesToScroll>n.slideCount&&n.slideCount>n.options.slidesToShow&&(i>n.slideCount?(n.slideOffset=(n.options.slidesToShow-(i-n.slideCount))*n.slideWidth*-1,r=(n.options.slidesToShow-(i-n.slideCount))*t*-1):(n.slideOffset=n.slideCount%n.options.slidesToScroll*n.slideWidth*-1,r=n.slideCount%n.options.slidesToScroll*t*-1))):i+n.options.slidesToShow>n.slideCount&&(n.slideOffset=(i+n.options.slidesToShow-n.slideCount)*n.slideWidth,r=(i+n.options.slidesToShow-n.slideCount)*t),n.slideCount<=n.options.slidesToShow&&(n.slideOffset=0,r=0),n.options.centerMode===!0&&n.slideCount<=n.options.slidesToShow?n.slideOffset=n.slideWidth*Math.floor(n.options.slidesToShow)/2-n.slideWidth*n.slideCount/2:n.options.centerMode===!0&&n.options.infinite===!0?n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)-n.slideWidth:n.options.centerMode===!0&&(n.slideOffset=0,n.slideOffset+=n.slideWidth*Math.floor(n.options.slidesToShow/2)),e=n.options.vertical===!1?i*n.slideWidth*-1+n.slideOffset:i*t*-1+r,n.options.variableWidth===!0&&(o=n.slideCount<=n.options.slidesToShow||n.options.infinite===!1?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow),e=n.options.rtl===!0?o[0]?(n.$slideTrack.width()-o[0].offsetLeft-o.width())*-1:0:o[0]?o[0].offsetLeft*-1:0,n.options.centerMode===!0&&(o=n.slideCount<=n.options.slidesToShow||n.options.infinite===!1?n.$slideTrack.children(\".slick-slide\").eq(i):n.$slideTrack.children(\".slick-slide\").eq(i+n.options.slidesToShow+1),e=n.options.rtl===!0?o[0]?(n.$slideTrack.width()-o[0].offsetLeft-o.width())*-1:0:o[0]?o[0].offsetLeft*-1:0,e+=(n.$list.width()-o.outerWidth())/2)),e},e.prototype.getOption=e.prototype.slickGetOption=function(i){var e=this;return e.options[i]},e.prototype.getNavigableIndexes=function(){var i,e=this,t=0,o=0,s=[];for(e.options.infinite===!1?i=e.slideCount:(t=e.options.slidesToScroll*-1,o=e.options.slidesToScroll*-1,i=2*e.slideCount);t<i;)s.push(t),t=o+e.options.slidesToScroll,o+=e.options.slidesToScroll<=e.options.slidesToShow?e.options.slidesToScroll:e.options.slidesToShow;return s},e.prototype.getSlick=function(){return this},e.prototype.getSlideCount=function(){var e,t,o,s,n=this;return s=n.options.centerMode===!0?Math.floor(n.$list.width()/2):0,o=n.swipeLeft*-1+s,n.options.swipeToSlide===!0?(n.$slideTrack.find(\".slick-slide\").each(function(e,s){var r,l,d;if(r=i(s).outerWidth(),l=s.offsetLeft,n.options.centerMode!==!0&&(l+=r/2),d=l+r,o<d)return t=s,!1}),e=Math.abs(i(t).attr(\"data-slick-index\")-n.currentSlide)||1):n.options.slidesToScroll},e.prototype.goTo=e.prototype.slickGoTo=function(i,e){var t=this;t.changeSlide({data:{message:\"index\",index:parseInt(i)}},e)},e.prototype.init=function(e){var t=this;i(t.$slider).hasClass(\"slick-initialized\")||(i(t.$slider).addClass(\"slick-initialized\"),t.buildRows(),t.buildOut(),t.setProps(),t.startLoad(),t.loadSlider(),t.initializeEvents(),t.updateArrows(),t.updateDots(),t.checkResponsive(!0),t.focusHandler()),e&&t.$slider.trigger(\"init\",[t]),t.options.accessibility===!0&&t.initADA(),t.options.autoplay&&(t.paused=!1,t.autoPlay())},e.prototype.initADA=function(){var e=this,t=Math.ceil(e.slideCount/e.options.slidesToShow),o=e.getNavigableIndexes().filter(function(i){return i>=0&&i<e.slideCount});e.$slides.add(e.$slideTrack.find(\".slick-cloned\")).attr({\"aria-hidden\":\"true\",tabindex:\"-1\"}).find(\"a, input, button, select\").attr({tabindex:\"-1\"}),null!==e.$dots&&(e.$slides.not(e.$slideTrack.find(\".slick-cloned\")).each(function(t){var s=o.indexOf(t);if(i(this).attr({role:\"tabpanel\",id:\"slick-slide\"+e.instanceUid+t,tabindex:-1}),s!==-1){var n=\"slick-slide-control\"+e.instanceUid+s;i(\"#\"+n).length&&i(this).attr({\"aria-describedby\":n})}}),e.$dots.attr(\"role\",\"tablist\").find(\"li\").each(function(s){var n=o[s];i(this).attr({role:\"presentation\"}),i(this).find(\"button\").first().attr({role:\"tab\",id:\"slick-slide-control\"+e.instanceUid+s,\"aria-controls\":\"slick-slide\"+e.instanceUid+n,\"aria-label\":s+1+\" of \"+t,\"aria-selected\":null,tabindex:\"-1\"})}).eq(e.currentSlide).find(\"button\").attr({\"aria-selected\":\"true\",tabindex:\"0\"}).end());for(var s=e.currentSlide,n=s+e.options.slidesToShow;s<n;s++)e.options.focusOnChange?e.$slides.eq(s).attr({tabindex:\"0\"}):e.$slides.eq(s).removeAttr(\"tabindex\");e.activateADA()},e.prototype.initArrowEvents=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.off(\"click.slick\").on(\"click.slick\",{message:\"previous\"},i.changeSlide),i.$nextArrow.off(\"click.slick\").on(\"click.slick\",{message:\"next\"},i.changeSlide),i.options.accessibility===!0&&(i.$prevArrow.on(\"keydown.slick\",i.keyHandler),i.$nextArrow.on(\"keydown.slick\",i.keyHandler)))},e.prototype.initDotEvents=function(){var e=this;e.options.dots===!0&&e.slideCount>e.options.slidesToShow&&(i(\"li\",e.$dots).on(\"click.slick\",{message:\"index\"},e.changeSlide),e.options.accessibility===!0&&e.$dots.on(\"keydown.slick\",e.keyHandler)),e.options.dots===!0&&e.options.pauseOnDotsHover===!0&&e.slideCount>e.options.slidesToShow&&i(\"li\",e.$dots).on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)).on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1))},e.prototype.initSlideEvents=function(){var e=this;e.options.pauseOnHover&&(e.$list.on(\"mouseenter.slick\",i.proxy(e.interrupt,e,!0)),e.$list.on(\"mouseleave.slick\",i.proxy(e.interrupt,e,!1)))},e.prototype.initializeEvents=function(){var e=this;e.initArrowEvents(),e.initDotEvents(),e.initSlideEvents(),e.$list.on(\"touchstart.slick mousedown.slick\",{action:\"start\"},e.swipeHandler),e.$list.on(\"touchmove.slick mousemove.slick\",{action:\"move\"},e.swipeHandler),e.$list.on(\"touchend.slick mouseup.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"touchcancel.slick mouseleave.slick\",{action:\"end\"},e.swipeHandler),e.$list.on(\"click.slick\",e.clickHandler),i(document).on(e.visibilityChange,i.proxy(e.visibility,e)),e.options.accessibility===!0&&e.$list.on(\"keydown.slick\",e.keyHandler),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),i(window).on(\"orientationchange.slick.slick-\"+e.instanceUid,i.proxy(e.orientationChange,e)),i(window).on(\"resize.slick.slick-\"+e.instanceUid,i.proxy(e.resize,e)),i(\"[draggable!=true]\",e.$slideTrack).on(\"dragstart\",e.preventDefault),i(window).on(\"load.slick.slick-\"+e.instanceUid,e.setPosition),i(e.setPosition)},e.prototype.initUI=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.show(),i.$nextArrow.show()),i.options.dots===!0&&i.slideCount>i.options.slidesToShow&&i.$dots.show()},e.prototype.keyHandler=function(i){var e=this;i.target.tagName.match(\"TEXTAREA|INPUT|SELECT\")||(37===i.keyCode&&e.options.accessibility===!0?e.changeSlide({data:{message:e.options.rtl===!0?\"next\":\"previous\"}}):39===i.keyCode&&e.options.accessibility===!0&&e.changeSlide({data:{message:e.options.rtl===!0?\"previous\":\"next\"}}))},e.prototype.lazyLoad=function(){function e(e){i(\"img[data-lazy]\",e).each(function(){var e=i(this),t=i(this).attr(\"data-lazy\"),o=i(this).attr(\"data-srcset\"),s=i(this).attr(\"data-sizes\")||r.$slider.attr(\"data-sizes\"),n=document.createElement(\"img\");n.onload=function(){e.animate({opacity:0},100,function(){o&&(e.attr(\"srcset\",o),s&&e.attr(\"sizes\",s)),e.attr(\"src\",t).animate({opacity:1},200,function(){e.removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\")}),r.$slider.trigger(\"lazyLoaded\",[r,e,t])})},n.onerror=function(){e.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),r.$slider.trigger(\"lazyLoadError\",[r,e,t])},n.src=t})}var t,o,s,n,r=this;if(r.options.centerMode===!0?r.options.infinite===!0?(s=r.currentSlide+(r.options.slidesToShow/2+1),n=s+r.options.slidesToShow+2):(s=Math.max(0,r.currentSlide-(r.options.slidesToShow/2+1)),n=2+(r.options.slidesToShow/2+1)+r.currentSlide):(s=r.options.infinite?r.options.slidesToShow+r.currentSlide:r.currentSlide,n=Math.ceil(s+r.options.slidesToShow),r.options.fade===!0&&(s>0&&s--,n<=r.slideCount&&n++)),t=r.$slider.find(\".slick-slide\").slice(s,n),\"anticipated\"===r.options.lazyLoad)for(var l=s-1,d=n,a=r.$slider.find(\".slick-slide\"),c=0;c<r.options.slidesToScroll;c++)l<0&&(l=r.slideCount-1),t=t.add(a.eq(l)),t=t.add(a.eq(d)),l--,d++;e(t),r.slideCount<=r.options.slidesToShow?(o=r.$slider.find(\".slick-slide\"),e(o)):r.currentSlide>=r.slideCount-r.options.slidesToShow?(o=r.$slider.find(\".slick-cloned\").slice(0,r.options.slidesToShow),e(o)):0===r.currentSlide&&(o=r.$slider.find(\".slick-cloned\").slice(r.options.slidesToShow*-1),e(o))},e.prototype.loadSlider=function(){var i=this;i.setPosition(),i.$slideTrack.css({opacity:1}),i.$slider.removeClass(\"slick-loading\"),i.initUI(),\"progressive\"===i.options.lazyLoad&&i.progressiveLazyLoad()},e.prototype.next=e.prototype.slickNext=function(){var i=this;i.changeSlide({data:{message:\"next\"}})},e.prototype.orientationChange=function(){var i=this;i.checkResponsive(),i.setPosition()},e.prototype.pause=e.prototype.slickPause=function(){var i=this;i.autoPlayClear(),i.paused=!0},e.prototype.play=e.prototype.slickPlay=function(){var i=this;i.autoPlay(),i.options.autoplay=!0,i.paused=!1,i.focussed=!1,i.interrupted=!1},e.prototype.postSlide=function(e){var t=this;if(!t.unslicked&&(t.$slider.trigger(\"afterChange\",[t,e]),t.animating=!1,t.slideCount>t.options.slidesToShow&&t.setPosition(),t.swipeLeft=null,t.options.autoplay&&t.autoPlay(),t.options.accessibility===!0&&(t.initADA(),t.options.focusOnChange))){var o=i(t.$slides.get(t.currentSlide));o.attr(\"tabindex\",0).focus()}},e.prototype.prev=e.prototype.slickPrev=function(){var i=this;i.changeSlide({data:{message:\"previous\"}})},e.prototype.preventDefault=function(i){i.preventDefault()},e.prototype.progressiveLazyLoad=function(e){e=e||1;var t,o,s,n,r,l=this,d=i(\"img[data-lazy]\",l.$slider);d.length?(t=d.first(),o=t.attr(\"data-lazy\"),s=t.attr(\"data-srcset\"),n=t.attr(\"data-sizes\")||l.$slider.attr(\"data-sizes\"),r=document.createElement(\"img\"),r.onload=function(){s&&(t.attr(\"srcset\",s),n&&t.attr(\"sizes\",n)),t.attr(\"src\",o).removeAttr(\"data-lazy data-srcset data-sizes\").removeClass(\"slick-loading\"),l.options.adaptiveHeight===!0&&l.setPosition(),l.$slider.trigger(\"lazyLoaded\",[l,t,o]),l.progressiveLazyLoad()},r.onerror=function(){e<3?setTimeout(function(){l.progressiveLazyLoad(e+1)},500):(t.removeAttr(\"data-lazy\").removeClass(\"slick-loading\").addClass(\"slick-lazyload-error\"),l.$slider.trigger(\"lazyLoadError\",[l,t,o]),l.progressiveLazyLoad())},r.src=o):l.$slider.trigger(\"allImagesLoaded\",[l])},e.prototype.refresh=function(e){var t,o,s=this;o=s.slideCount-s.options.slidesToShow,!s.options.infinite&&s.currentSlide>o&&(s.currentSlide=o),s.slideCount<=s.options.slidesToShow&&(s.currentSlide=0),t=s.currentSlide,s.destroy(!0),i.extend(s,s.initials,{currentSlide:t}),s.init(),e||s.changeSlide({data:{message:\"index\",index:t}},!1)},e.prototype.registerBreakpoints=function(){var e,t,o,s=this,n=s.options.responsive||null;if(\"array\"===i.type(n)&&n.length){s.respondTo=s.options.respondTo||\"window\";for(e in n)if(o=s.breakpoints.length-1,n.hasOwnProperty(e)){for(t=n[e].breakpoint;o>=0;)s.breakpoints[o]&&s.breakpoints[o]===t&&s.breakpoints.splice(o,1),o--;s.breakpoints.push(t),s.breakpointSettings[t]=n[e].settings}s.breakpoints.sort(function(i,e){return s.options.mobileFirst?i-e:e-i})}},e.prototype.reinit=function(){var e=this;e.$slides=e.$slideTrack.children(e.options.slide).addClass(\"slick-slide\"),e.slideCount=e.$slides.length,e.currentSlide>=e.slideCount&&0!==e.currentSlide&&(e.currentSlide=e.currentSlide-e.options.slidesToScroll),e.slideCount<=e.options.slidesToShow&&(e.currentSlide=0),e.registerBreakpoints(),e.setProps(),e.setupInfinite(),e.buildArrows(),e.updateArrows(),e.initArrowEvents(),e.buildDots(),e.updateDots(),e.initDotEvents(),e.cleanUpSlideEvents(),e.initSlideEvents(),e.checkResponsive(!1,!0),e.options.focusOnSelect===!0&&i(e.$slideTrack).children().on(\"click.slick\",e.selectHandler),e.setSlideClasses(\"number\"==typeof e.currentSlide?e.currentSlide:0),e.setPosition(),e.focusHandler(),e.paused=!e.options.autoplay,e.autoPlay(),e.$slider.trigger(\"reInit\",[e])},e.prototype.resize=function(){var e=this;i(window).width()!==e.windowWidth&&(clearTimeout(e.windowDelay),e.windowDelay=window.setTimeout(function(){e.windowWidth=i(window).width(),e.checkResponsive(),e.unslicked||e.setPosition()},50))},e.prototype.removeSlide=e.prototype.slickRemove=function(i,e,t){var o=this;return\"boolean\"==typeof i?(e=i,i=e===!0?0:o.slideCount-1):i=e===!0?--i:i,!(o.slideCount<1||i<0||i>o.slideCount-1)&&(o.unload(),t===!0?o.$slideTrack.children().remove():o.$slideTrack.children(this.options.slide).eq(i).remove(),o.$slides=o.$slideTrack.children(this.options.slide),o.$slideTrack.children(this.options.slide).detach(),o.$slideTrack.append(o.$slides),o.$slidesCache=o.$slides,void o.reinit())},e.prototype.setCSS=function(i){var e,t,o=this,s={};o.options.rtl===!0&&(i=-i),e=\"left\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",t=\"top\"==o.positionProp?Math.ceil(i)+\"px\":\"0px\",s[o.positionProp]=i,o.transformsEnabled===!1?o.$slideTrack.css(s):(s={},o.cssTransitions===!1?(s[o.animType]=\"translate(\"+e+\", \"+t+\")\",o.$slideTrack.css(s)):(s[o.animType]=\"translate3d(\"+e+\", \"+t+\", 0px)\",o.$slideTrack.css(s)))},e.prototype.setDimensions=function(){var i=this;i.options.vertical===!1?i.options.centerMode===!0&&i.$list.css({padding:\"0px \"+i.options.centerPadding}):(i.$list.height(i.$slides.first().outerHeight(!0)*i.options.slidesToShow),i.options.centerMode===!0&&i.$list.css({padding:i.options.centerPadding+\" 0px\"})),i.listWidth=i.$list.width(),i.listHeight=i.$list.height(),i.options.vertical===!1&&i.options.variableWidth===!1?(i.slideWidth=Math.ceil(i.listWidth/i.options.slidesToShow),i.$slideTrack.width(Math.ceil(i.slideWidth*i.$slideTrack.children(\".slick-slide\").length))):i.options.variableWidth===!0?i.$slideTrack.width(5e3*i.slideCount):(i.slideWidth=Math.ceil(i.listWidth),i.$slideTrack.height(Math.ceil(i.$slides.first().outerHeight(!0)*i.$slideTrack.children(\".slick-slide\").length)));var e=i.$slides.first().outerWidth(!0)-i.$slides.first().width();i.options.variableWidth===!1&&i.$slideTrack.children(\".slick-slide\").width(i.slideWidth-e)},e.prototype.setFade=function(){var e,t=this;t.$slides.each(function(o,s){e=t.slideWidth*o*-1,t.options.rtl===!0?i(s).css({position:\"relative\",right:e,top:0,zIndex:t.options.zIndex-2,opacity:0}):i(s).css({position:\"relative\",left:e,top:0,zIndex:t.options.zIndex-2,opacity:0})}),t.$slides.eq(t.currentSlide).css({zIndex:t.options.zIndex-1,opacity:1})},e.prototype.setHeight=function(){var i=this;if(1===i.options.slidesToShow&&i.options.adaptiveHeight===!0&&i.options.vertical===!1){var e=i.$slides.eq(i.currentSlide).outerHeight(!0);i.$list.css(\"height\",e)}},e.prototype.setOption=e.prototype.slickSetOption=function(){var e,t,o,s,n,r=this,l=!1;if(\"object\"===i.type(arguments[0])?(o=arguments[0],l=arguments[1],n=\"multiple\"):\"string\"===i.type(arguments[0])&&(o=arguments[0],s=arguments[1],l=arguments[2],\"responsive\"===arguments[0]&&\"array\"===i.type(arguments[1])?n=\"responsive\":\"undefined\"!=typeof arguments[1]&&(n=\"single\")),\"single\"===n)r.options[o]=s;else if(\"multiple\"===n)i.each(o,function(i,e){r.options[i]=e});else if(\"responsive\"===n)for(t in s)if(\"array\"!==i.type(r.options.responsive))r.options.responsive=[s[t]];else{for(e=r.options.responsive.length-1;e>=0;)r.options.responsive[e].breakpoint===s[t].breakpoint&&r.options.responsive.splice(e,1),e--;r.options.responsive.push(s[t])}l&&(r.unload(),r.reinit())},e.prototype.setPosition=function(){var i=this;i.setDimensions(),i.setHeight(),i.options.fade===!1?i.setCSS(i.getLeft(i.currentSlide)):i.setFade(),i.$slider.trigger(\"setPosition\",[i])},e.prototype.setProps=function(){var i=this,e=document.body.style;i.positionProp=i.options.vertical===!0?\"top\":\"left\",\n\"top\"===i.positionProp?i.$slider.addClass(\"slick-vertical\"):i.$slider.removeClass(\"slick-vertical\"),void 0===e.WebkitTransition&&void 0===e.MozTransition&&void 0===e.msTransition||i.options.useCSS===!0&&(i.cssTransitions=!0),i.options.fade&&(\"number\"==typeof i.options.zIndex?i.options.zIndex<3&&(i.options.zIndex=3):i.options.zIndex=i.defaults.zIndex),void 0!==e.OTransform&&(i.animType=\"OTransform\",i.transformType=\"-o-transform\",i.transitionType=\"OTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.MozTransform&&(i.animType=\"MozTransform\",i.transformType=\"-moz-transform\",i.transitionType=\"MozTransition\",void 0===e.perspectiveProperty&&void 0===e.MozPerspective&&(i.animType=!1)),void 0!==e.webkitTransform&&(i.animType=\"webkitTransform\",i.transformType=\"-webkit-transform\",i.transitionType=\"webkitTransition\",void 0===e.perspectiveProperty&&void 0===e.webkitPerspective&&(i.animType=!1)),void 0!==e.msTransform&&(i.animType=\"msTransform\",i.transformType=\"-ms-transform\",i.transitionType=\"msTransition\",void 0===e.msTransform&&(i.animType=!1)),void 0!==e.transform&&i.animType!==!1&&(i.animType=\"transform\",i.transformType=\"transform\",i.transitionType=\"transition\"),i.transformsEnabled=i.options.useTransform&&null!==i.animType&&i.animType!==!1},e.prototype.setSlideClasses=function(i){var e,t,o,s,n=this;if(t=n.$slider.find(\".slick-slide\").removeClass(\"slick-active slick-center slick-current\").attr(\"aria-hidden\",\"true\"),n.$slides.eq(i).addClass(\"slick-current\"),n.options.centerMode===!0){var r=n.options.slidesToShow%2===0?1:0;e=Math.floor(n.options.slidesToShow/2),n.options.infinite===!0&&(i>=e&&i<=n.slideCount-1-e?n.$slides.slice(i-e+r,i+e+1).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(o=n.options.slidesToShow+i,t.slice(o-e+1+r,o+e+2).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\")),0===i?t.eq(t.length-1-n.options.slidesToShow).addClass(\"slick-center\"):i===n.slideCount-1&&t.eq(n.options.slidesToShow).addClass(\"slick-center\")),n.$slides.eq(i).addClass(\"slick-center\")}else i>=0&&i<=n.slideCount-n.options.slidesToShow?n.$slides.slice(i,i+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.length<=n.options.slidesToShow?t.addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):(s=n.slideCount%n.options.slidesToShow,o=n.options.infinite===!0?n.options.slidesToShow+i:i,n.options.slidesToShow==n.options.slidesToScroll&&n.slideCount-i<n.options.slidesToShow?t.slice(o-(n.options.slidesToShow-s),o+s).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"):t.slice(o,o+n.options.slidesToShow).addClass(\"slick-active\").attr(\"aria-hidden\",\"false\"));\"ondemand\"!==n.options.lazyLoad&&\"anticipated\"!==n.options.lazyLoad||n.lazyLoad()},e.prototype.setupInfinite=function(){var e,t,o,s=this;if(s.options.fade===!0&&(s.options.centerMode=!1),s.options.infinite===!0&&s.options.fade===!1&&(t=null,s.slideCount>s.options.slidesToShow)){for(o=s.options.centerMode===!0?s.options.slidesToShow+1:s.options.slidesToShow,e=s.slideCount;e>s.slideCount-o;e-=1)t=e-1,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t-s.slideCount).prependTo(s.$slideTrack).addClass(\"slick-cloned\");for(e=0;e<o+s.slideCount;e+=1)t=e,i(s.$slides[t]).clone(!0).attr(\"id\",\"\").attr(\"data-slick-index\",t+s.slideCount).appendTo(s.$slideTrack).addClass(\"slick-cloned\");s.$slideTrack.find(\".slick-cloned\").find(\"[id]\").each(function(){i(this).attr(\"id\",\"\")})}},e.prototype.interrupt=function(i){var e=this;i||e.autoPlay(),e.interrupted=i},e.prototype.selectHandler=function(e){var t=this,o=i(e.target).is(\".slick-slide\")?i(e.target):i(e.target).parents(\".slick-slide\"),s=parseInt(o.attr(\"data-slick-index\"));return s||(s=0),t.slideCount<=t.options.slidesToShow?void t.slideHandler(s,!1,!0):void t.slideHandler(s)},e.prototype.slideHandler=function(i,e,t){var o,s,n,r,l,d=null,a=this;if(e=e||!1,!(a.animating===!0&&a.options.waitForAnimate===!0||a.options.fade===!0&&a.currentSlide===i))return e===!1&&a.asNavFor(i),o=i,d=a.getLeft(o),r=a.getLeft(a.currentSlide),a.currentLeft=null===a.swipeLeft?r:a.swipeLeft,a.options.infinite===!1&&a.options.centerMode===!1&&(i<0||i>a.getDotCount()*a.options.slidesToScroll)?void(a.options.fade===!1&&(o=a.currentSlide,t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o))):a.options.infinite===!1&&a.options.centerMode===!0&&(i<0||i>a.slideCount-a.options.slidesToScroll)?void(a.options.fade===!1&&(o=a.currentSlide,t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(r,function(){a.postSlide(o)}):a.postSlide(o))):(a.options.autoplay&&clearInterval(a.autoPlayTimer),s=o<0?a.slideCount%a.options.slidesToScroll!==0?a.slideCount-a.slideCount%a.options.slidesToScroll:a.slideCount+o:o>=a.slideCount?a.slideCount%a.options.slidesToScroll!==0?0:o-a.slideCount:o,a.animating=!0,a.$slider.trigger(\"beforeChange\",[a,a.currentSlide,s]),n=a.currentSlide,a.currentSlide=s,a.setSlideClasses(a.currentSlide),a.options.asNavFor&&(l=a.getNavTarget(),l=l.slick(\"getSlick\"),l.slideCount<=l.options.slidesToShow&&l.setSlideClasses(a.currentSlide)),a.updateDots(),a.updateArrows(),a.options.fade===!0?(t!==!0?(a.fadeSlideOut(n),a.fadeSlide(s,function(){a.postSlide(s)})):a.postSlide(s),void a.animateHeight()):void(t!==!0&&a.slideCount>a.options.slidesToShow?a.animateSlide(d,function(){a.postSlide(s)}):a.postSlide(s)))},e.prototype.startLoad=function(){var i=this;i.options.arrows===!0&&i.slideCount>i.options.slidesToShow&&(i.$prevArrow.hide(),i.$nextArrow.hide()),i.options.dots===!0&&i.slideCount>i.options.slidesToShow&&i.$dots.hide(),i.$slider.addClass(\"slick-loading\")},e.prototype.swipeDirection=function(){var i,e,t,o,s=this;return i=s.touchObject.startX-s.touchObject.curX,e=s.touchObject.startY-s.touchObject.curY,t=Math.atan2(e,i),o=Math.round(180*t/Math.PI),o<0&&(o=360-Math.abs(o)),o<=45&&o>=0?s.options.rtl===!1?\"left\":\"right\":o<=360&&o>=315?s.options.rtl===!1?\"left\":\"right\":o>=135&&o<=225?s.options.rtl===!1?\"right\":\"left\":s.options.verticalSwiping===!0?o>=35&&o<=135?\"down\":\"up\":\"vertical\"},e.prototype.swipeEnd=function(i){var e,t,o=this;if(o.dragging=!1,o.swiping=!1,o.scrolling)return o.scrolling=!1,!1;if(o.interrupted=!1,o.shouldClick=!(o.touchObject.swipeLength>10),void 0===o.touchObject.curX)return!1;if(o.touchObject.edgeHit===!0&&o.$slider.trigger(\"edge\",[o,o.swipeDirection()]),o.touchObject.swipeLength>=o.touchObject.minSwipe){switch(t=o.swipeDirection()){case\"left\":case\"down\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide+o.getSlideCount()):o.currentSlide+o.getSlideCount(),o.currentDirection=0;break;case\"right\":case\"up\":e=o.options.swipeToSlide?o.checkNavigable(o.currentSlide-o.getSlideCount()):o.currentSlide-o.getSlideCount(),o.currentDirection=1}\"vertical\"!=t&&(o.slideHandler(e),o.touchObject={},o.$slider.trigger(\"swipe\",[o,t]))}else o.touchObject.startX!==o.touchObject.curX&&(o.slideHandler(o.currentSlide),o.touchObject={})},e.prototype.swipeHandler=function(i){var e=this;if(!(e.options.swipe===!1||\"ontouchend\"in document&&e.options.swipe===!1||e.options.draggable===!1&&i.type.indexOf(\"mouse\")!==-1))switch(e.touchObject.fingerCount=i.originalEvent&&void 0!==i.originalEvent.touches?i.originalEvent.touches.length:1,e.touchObject.minSwipe=e.listWidth/e.options.touchThreshold,e.options.verticalSwiping===!0&&(e.touchObject.minSwipe=e.listHeight/e.options.touchThreshold),i.data.action){case\"start\":e.swipeStart(i);break;case\"move\":e.swipeMove(i);break;case\"end\":e.swipeEnd(i)}},e.prototype.swipeMove=function(i){var e,t,o,s,n,r,l=this;return n=void 0!==i.originalEvent?i.originalEvent.touches:null,!(!l.dragging||l.scrolling||n&&1!==n.length)&&(e=l.getLeft(l.currentSlide),l.touchObject.curX=void 0!==n?n[0].pageX:i.clientX,l.touchObject.curY=void 0!==n?n[0].pageY:i.clientY,l.touchObject.swipeLength=Math.round(Math.sqrt(Math.pow(l.touchObject.curX-l.touchObject.startX,2))),r=Math.round(Math.sqrt(Math.pow(l.touchObject.curY-l.touchObject.startY,2))),!l.options.verticalSwiping&&!l.swiping&&r>4?(l.scrolling=!0,!1):(l.options.verticalSwiping===!0&&(l.touchObject.swipeLength=r),t=l.swipeDirection(),void 0!==i.originalEvent&&l.touchObject.swipeLength>4&&(l.swiping=!0,i.preventDefault()),s=(l.options.rtl===!1?1:-1)*(l.touchObject.curX>l.touchObject.startX?1:-1),l.options.verticalSwiping===!0&&(s=l.touchObject.curY>l.touchObject.startY?1:-1),o=l.touchObject.swipeLength,l.touchObject.edgeHit=!1,l.options.infinite===!1&&(0===l.currentSlide&&\"right\"===t||l.currentSlide>=l.getDotCount()&&\"left\"===t)&&(o=l.touchObject.swipeLength*l.options.edgeFriction,l.touchObject.edgeHit=!0),l.options.vertical===!1?l.swipeLeft=e+o*s:l.swipeLeft=e+o*(l.$list.height()/l.listWidth)*s,l.options.verticalSwiping===!0&&(l.swipeLeft=e+o*s),l.options.fade!==!0&&l.options.touchMove!==!1&&(l.animating===!0?(l.swipeLeft=null,!1):void l.setCSS(l.swipeLeft))))},e.prototype.swipeStart=function(i){var e,t=this;return t.interrupted=!0,1!==t.touchObject.fingerCount||t.slideCount<=t.options.slidesToShow?(t.touchObject={},!1):(void 0!==i.originalEvent&&void 0!==i.originalEvent.touches&&(e=i.originalEvent.touches[0]),t.touchObject.startX=t.touchObject.curX=void 0!==e?e.pageX:i.clientX,t.touchObject.startY=t.touchObject.curY=void 0!==e?e.pageY:i.clientY,void(t.dragging=!0))},e.prototype.unfilterSlides=e.prototype.slickUnfilter=function(){var i=this;null!==i.$slidesCache&&(i.unload(),i.$slideTrack.children(this.options.slide).detach(),i.$slidesCache.appendTo(i.$slideTrack),i.reinit())},e.prototype.unload=function(){var e=this;i(\".slick-cloned\",e.$slider).remove(),e.$dots&&e.$dots.remove(),e.$prevArrow&&e.htmlExpr.test(e.options.prevArrow)&&e.$prevArrow.remove(),e.$nextArrow&&e.htmlExpr.test(e.options.nextArrow)&&e.$nextArrow.remove(),e.$slides.removeClass(\"slick-slide slick-active slick-visible slick-current\").attr(\"aria-hidden\",\"true\").css(\"width\",\"\")},e.prototype.unslick=function(i){var e=this;e.$slider.trigger(\"unslick\",[e,i]),e.destroy()},e.prototype.updateArrows=function(){var i,e=this;i=Math.floor(e.options.slidesToShow/2),e.options.arrows===!0&&e.slideCount>e.options.slidesToShow&&!e.options.infinite&&(e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),e.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\"),0===e.currentSlide?(e.$prevArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$nextArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):e.currentSlide>=e.slideCount-e.options.slidesToShow&&e.options.centerMode===!1?(e.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")):e.currentSlide>=e.slideCount-1&&e.options.centerMode===!0&&(e.$nextArrow.addClass(\"slick-disabled\").attr(\"aria-disabled\",\"true\"),e.$prevArrow.removeClass(\"slick-disabled\").attr(\"aria-disabled\",\"false\")))},e.prototype.updateDots=function(){var i=this;null!==i.$dots&&(i.$dots.find(\"li\").removeClass(\"slick-active\").end(),i.$dots.find(\"li\").eq(Math.floor(i.currentSlide/i.options.slidesToScroll)).addClass(\"slick-active\"))},e.prototype.visibility=function(){var i=this;i.options.autoplay&&(document[i.hidden]?i.interrupted=!0:i.interrupted=!1)},i.fn.slick=function(){var i,t,o=this,s=arguments[0],n=Array.prototype.slice.call(arguments,1),r=o.length;for(i=0;i<r;i++)if(\"object\"==typeof s||\"undefined\"==typeof s?o[i].slick=new e(o[i],s):t=o[i].slick[s].apply(o[i].slick,n),\"undefined\"!=typeof t)return t;return o}});\n","Magento_PageBuilder/js/resource/jarallax/jarallax-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/resource/jarallax/jarallax'\n], function(jarallax){\n    'use strict';\n\n    window.jarallax = window.jarallax || jarallax;\n});\n","Magento_PageBuilder/js/resource/jarallax/jarallax-video.js":"/*!\n * Video Extension for Jarallax v2.0.3 (https://github.com/nk-o/jarallax)\n * Copyright 2022 nK <https://nkdev.info>\n * Licensed under MIT (https://github.com/nk-o/jarallax/blob/master/LICENSE)\n */\n\n(function (global, factory) {\n  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n      typeof define === 'function' && define.amd ? define(factory) :\n          (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.jarallaxVideo = factory());\n})(this, (function () { 'use strict';\n\n  /*!\n   * Name    : Video Worker\n   * Version : 2.0.0\n   * Author  : nK <https://nkdev.info>\n   * GitHub  : https://github.com/nk-o/video-worker\n   */\n\n  /* eslint-disable import/no-mutable-exports */\n\n  /* eslint-disable no-restricted-globals */\n  let win$1;\n\n  if (typeof window !== 'undefined') {\n    win$1 = window;\n  } else if (typeof global !== 'undefined') {\n    win$1 = global;\n  } else if (typeof self !== 'undefined') {\n    win$1 = self;\n  } else {\n    win$1 = {};\n  }\n\n  var global$1$1 = win$1; // Deferred\n  // thanks http://stackoverflow.com/questions/18096715/implement-deferred-object-without-using-jquery\n\n  function Deferred() {\n    this.doneCallbacks = [];\n    this.failCallbacks = [];\n  }\n\n  Deferred.prototype = {\n    execute(list, args) {\n      let i = list.length; // eslint-disable-next-line no-param-reassign\n\n      args = Array.prototype.slice.call(args);\n\n      while (i) {\n        i -= 1;\n        list[i].apply(null, args);\n      }\n    },\n\n    resolve(...args) {\n      this.execute(this.doneCallbacks, args);\n    },\n\n    reject(...args) {\n      this.execute(this.failCallbacks, args);\n    },\n\n    done(callback) {\n      this.doneCallbacks.push(callback);\n    },\n\n    fail(callback) {\n      this.failCallbacks.push(callback);\n    }\n\n  };\n  let ID = 0;\n  let YoutubeAPIadded = 0;\n  let VimeoAPIadded = 0;\n  let loadingYoutubePlayer = 0;\n  let loadingVimeoPlayer = 0;\n  const loadingYoutubeDefer = /*#__PURE__*/new Deferred();\n  const loadingVimeoDefer = /*#__PURE__*/new Deferred();\n\n  class VideoWorker {\n    constructor(url, options) {\n      const self = this;\n      self.url = url;\n      self.options_default = {\n        autoplay: false,\n        loop: false,\n        mute: false,\n        volume: 100,\n        showControls: true,\n        accessibilityHidden: false,\n        // start / end video time in seconds\n        startTime: 0,\n        endTime: 0\n      };\n      self.options = self.extend({}, self.options_default, options); // Fix wrong option name.\n      // Thanks to https://github.com/nk-o/video-worker/issues/13.\n\n      if (typeof self.options.showContols !== 'undefined') {\n        self.options.showControls = self.options.showContols;\n        delete self.options.showContols;\n      } // check URL\n\n\n      self.videoID = self.parseURL(url); // init\n\n      if (self.videoID) {\n        self.ID = ID;\n        ID += 1;\n        self.loadAPI();\n        self.init();\n      }\n    } // Extend like jQuery.extend\n    // eslint-disable-next-line class-methods-use-this\n\n\n    extend(...args) {\n      const out = args[0] || {};\n      Object.keys(args).forEach(i => {\n        if (!args[i]) {\n          return;\n        }\n\n        Object.keys(args[i]).forEach(key => {\n          out[key] = args[i][key];\n        });\n      });\n      return out;\n    }\n\n    parseURL(url) {\n      // parse youtube ID\n      function getYoutubeID(ytUrl) {\n        // eslint-disable-next-line no-useless-escape\n        const regExp = /.*(?:youtu.be\\/|v\\/|u\\/\\w\\/|embed\\/|watch\\?v=)([^#\\&\\?]*).*/;\n        const match = ytUrl.match(regExp);\n        return match && match[1].length === 11 ? match[1] : false;\n      } // parse vimeo ID\n\n\n      function getVimeoID(vmUrl) {\n        // eslint-disable-next-line no-useless-escape\n        const regExp = /https?:\\/\\/(?:www\\.|player\\.)?vimeo.com\\/(?:channels\\/(?:\\w+\\/)?|groups\\/([^/]*)\\/videos\\/|album\\/(\\d+)\\/video\\/|video\\/|)(\\d+)(?:$|\\/|\\?)/;\n        const match = vmUrl.match(regExp);\n        return match && match[3] ? match[3] : false;\n      } // parse local string\n\n\n      function getLocalVideos(locUrl) {\n        // eslint-disable-next-line no-useless-escape\n        const videoFormats = locUrl.split(/,(?=mp4\\:|webm\\:|ogv\\:|ogg\\:)/);\n        const result = {};\n        let ready = 0;\n        videoFormats.forEach(val => {\n          // eslint-disable-next-line no-useless-escape\n          const match = val.match(/^(mp4|webm|ogv|ogg)\\:(.*)/);\n\n          if (match && match[1] && match[2]) {\n            // eslint-disable-next-line prefer-destructuring\n            result[match[1] === 'ogv' ? 'ogg' : match[1]] = match[2];\n            ready = 1;\n          }\n        });\n        return ready ? result : false;\n      }\n\n      const Youtube = getYoutubeID(url);\n      const Vimeo = getVimeoID(url);\n      const Local = getLocalVideos(url);\n\n      if (Youtube) {\n        this.type = 'youtube';\n        return Youtube;\n      }\n\n      if (Vimeo) {\n        this.type = 'vimeo';\n        return Vimeo;\n      }\n\n      if (Local) {\n        this.type = 'local';\n        return Local;\n      }\n\n      return false;\n    }\n\n    isValid() {\n      return !!this.videoID;\n    } // events\n\n\n    on(name, callback) {\n      this.userEventsList = this.userEventsList || []; // add new callback in events list\n\n      (this.userEventsList[name] || (this.userEventsList[name] = [])).push(callback);\n    }\n\n    off(name, callback) {\n      if (!this.userEventsList || !this.userEventsList[name]) {\n        return;\n      }\n\n      if (!callback) {\n        delete this.userEventsList[name];\n      } else {\n        this.userEventsList[name].forEach((val, key) => {\n          if (val === callback) {\n            this.userEventsList[name][key] = false;\n          }\n        });\n      }\n    }\n\n    fire(name, ...args) {\n      if (this.userEventsList && typeof this.userEventsList[name] !== 'undefined') {\n        this.userEventsList[name].forEach(val => {\n          // call with all arguments\n          if (val) {\n            val.apply(this, args);\n          }\n        });\n      }\n    }\n\n    play(start) {\n      const self = this;\n\n      if (!self.player) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.playVideo) {\n        if (typeof start !== 'undefined') {\n          self.player.seekTo(start || 0);\n        }\n\n        if (global$1$1.YT.PlayerState.PLAYING !== self.player.getPlayerState()) {\n          self.player.playVideo();\n        }\n      }\n\n      if (self.type === 'vimeo') {\n        if (typeof start !== 'undefined') {\n          self.player.setCurrentTime(start);\n        }\n\n        self.player.getPaused().then(paused => {\n          if (paused) {\n            self.player.play();\n          }\n        });\n      }\n\n      if (self.type === 'local') {\n        if (typeof start !== 'undefined') {\n          self.player.currentTime = start;\n        }\n\n        if (self.player.paused) {\n          self.player.play();\n        }\n      }\n    }\n\n    pause() {\n      const self = this;\n\n      if (!self.player) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.pauseVideo) {\n        if (global$1$1.YT.PlayerState.PLAYING === self.player.getPlayerState()) {\n          self.player.pauseVideo();\n        }\n      }\n\n      if (self.type === 'vimeo') {\n        self.player.getPaused().then(paused => {\n          if (!paused) {\n            self.player.pause();\n          }\n        });\n      }\n\n      if (self.type === 'local') {\n        if (!self.player.paused) {\n          self.player.pause();\n        }\n      }\n    }\n\n    mute() {\n      const self = this;\n\n      if (!self.player) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.mute) {\n        self.player.mute();\n      }\n\n      if (self.type === 'vimeo' && self.player.setVolume) {\n        self.player.setVolume(0);\n      }\n\n      if (self.type === 'local') {\n        self.$video.muted = true;\n      }\n    }\n\n    unmute() {\n      const self = this;\n\n      if (!self.player) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.mute) {\n        self.player.unMute();\n      }\n\n      if (self.type === 'vimeo' && self.player.setVolume) {\n        self.player.setVolume(self.options.volume);\n      }\n\n      if (self.type === 'local') {\n        self.$video.muted = false;\n      }\n    }\n\n    setVolume(volume = false) {\n      const self = this;\n\n      if (!self.player || !volume) {\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.setVolume) {\n        self.player.setVolume(volume);\n      }\n\n      if (self.type === 'vimeo' && self.player.setVolume) {\n        self.player.setVolume(volume);\n      }\n\n      if (self.type === 'local') {\n        self.$video.volume = volume / 100;\n      }\n    }\n\n    getVolume(callback) {\n      const self = this;\n\n      if (!self.player) {\n        callback(false);\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.getVolume) {\n        callback(self.player.getVolume());\n      }\n\n      if (self.type === 'vimeo' && self.player.getVolume) {\n        self.player.getVolume().then(volume => {\n          callback(volume);\n        });\n      }\n\n      if (self.type === 'local') {\n        callback(self.$video.volume * 100);\n      }\n    }\n\n    getMuted(callback) {\n      const self = this;\n\n      if (!self.player) {\n        callback(null);\n        return;\n      }\n\n      if (self.type === 'youtube' && self.player.isMuted) {\n        callback(self.player.isMuted());\n      }\n\n      if (self.type === 'vimeo' && self.player.getVolume) {\n        self.player.getVolume().then(volume => {\n          callback(!!volume);\n        });\n      }\n\n      if (self.type === 'local') {\n        callback(self.$video.muted);\n      }\n    }\n\n    getImageURL(callback) {\n      const self = this;\n\n      if (self.videoImage) {\n        callback(self.videoImage);\n        return;\n      }\n\n      if (self.type === 'youtube') {\n        const availableSizes = ['maxresdefault', 'sddefault', 'hqdefault', '0'];\n        let step = 0;\n        const tempImg = new Image();\n\n        tempImg.onload = function () {\n          // if no thumbnail, youtube add their own image with width = 120px\n          if ((this.naturalWidth || this.width) !== 120 || step === availableSizes.length - 1) {\n            // ok\n            self.videoImage = `https://img.youtube.com/vi/${self.videoID}/${availableSizes[step]}.jpg`;\n            callback(self.videoImage);\n          } else {\n            // try another size\n            step += 1;\n            this.src = `https://img.youtube.com/vi/${self.videoID}/${availableSizes[step]}.jpg`;\n          }\n        };\n\n        tempImg.src = `https://img.youtube.com/vi/${self.videoID}/${availableSizes[step]}.jpg`;\n      }\n\n      if (self.type === 'vimeo') {\n        let request = new XMLHttpRequest(); // https://vimeo.com/api/oembed.json?url=https://vimeo.com/235212527\n\n        request.open('GET', `https://vimeo.com/api/oembed.json?url=${self.url}`, true);\n\n        request.onreadystatechange = function () {\n          if (this.readyState === 4) {\n            if (this.status >= 200 && this.status < 400) {\n              // Success!\n              const response = JSON.parse(this.responseText);\n\n              if (response.thumbnail_url) {\n                self.videoImage = response.thumbnail_url;\n                callback(self.videoImage);\n              }\n            }\n          }\n        };\n\n        request.send();\n        request = null;\n      }\n    } // fallback to the old version.\n\n\n    getIframe(callback) {\n      this.getVideo(callback);\n    }\n\n    getVideo(callback) {\n      const self = this; // return generated video block\n\n      if (self.$video) {\n        callback(self.$video);\n        return;\n      } // generate new video block\n\n\n      self.onAPIready(() => {\n        let hiddenDiv;\n\n        if (!self.$video) {\n          hiddenDiv = document.createElement('div');\n          hiddenDiv.style.display = 'none';\n        } // Youtube\n\n\n        if (self.type === 'youtube') {\n          self.playerOptions = {\n            // GDPR Compliance.\n            host: 'https://www.youtube-nocookie.com',\n            videoId: self.videoID,\n            playerVars: {\n              autohide: 1,\n              rel: 0,\n              autoplay: 0,\n              // autoplay enable on mobile devices\n              playsinline: 1\n            }\n          }; // hide controls\n\n          if (!self.options.showControls) {\n            self.playerOptions.playerVars.iv_load_policy = 3;\n            self.playerOptions.playerVars.modestbranding = 1;\n            self.playerOptions.playerVars.controls = 0;\n            self.playerOptions.playerVars.showinfo = 0;\n            self.playerOptions.playerVars.disablekb = 1;\n          } // events\n\n\n          let ytStarted;\n          let ytProgressInterval;\n          self.playerOptions.events = {\n            onReady(e) {\n              // mute\n              if (self.options.mute) {\n                e.target.mute();\n              } else if (self.options.volume) {\n                e.target.setVolume(self.options.volume);\n              } // autoplay\n\n\n              if (self.options.autoplay) {\n                self.play(self.options.startTime);\n              }\n\n              self.fire('ready', e); // For seamless loops, set the endTime to 0.1 seconds less than the video's duration\n              // https://github.com/nk-o/video-worker/issues/2\n\n              if (self.options.loop && !self.options.endTime) {\n                const secondsOffset = 0.1;\n                self.options.endTime = self.player.getDuration() - secondsOffset;\n              } // volumechange\n\n\n              setInterval(() => {\n                self.getVolume(volume => {\n                  if (self.options.volume !== volume) {\n                    self.options.volume = volume;\n                    self.fire('volumechange', e);\n                  }\n                });\n              }, 150);\n            },\n\n            onStateChange(e) {\n              // loop\n              if (self.options.loop && e.data === global$1$1.YT.PlayerState.ENDED) {\n                self.play(self.options.startTime);\n              }\n\n              if (!ytStarted && e.data === global$1$1.YT.PlayerState.PLAYING) {\n                ytStarted = 1;\n                self.fire('started', e);\n              }\n\n              if (e.data === global$1$1.YT.PlayerState.PLAYING) {\n                self.fire('play', e);\n              }\n\n              if (e.data === global$1$1.YT.PlayerState.PAUSED) {\n                self.fire('pause', e);\n              }\n\n              if (e.data === global$1$1.YT.PlayerState.ENDED) {\n                self.fire('ended', e);\n              } // progress check\n\n\n              if (e.data === global$1$1.YT.PlayerState.PLAYING) {\n                ytProgressInterval = setInterval(() => {\n                  self.fire('timeupdate', e); // check for end of video and play again or stop\n\n                  if (self.options.endTime && self.player.getCurrentTime() >= self.options.endTime) {\n                    if (self.options.loop) {\n                      self.play(self.options.startTime);\n                    } else {\n                      self.pause();\n                    }\n                  }\n                }, 150);\n              } else {\n                clearInterval(ytProgressInterval);\n              }\n            },\n\n            onError(e) {\n              self.fire('error', e);\n            }\n\n          };\n          const firstInit = !self.$video;\n\n          if (firstInit) {\n            const div = document.createElement('div');\n            div.setAttribute('id', self.playerID);\n            hiddenDiv.appendChild(div);\n            document.body.appendChild(hiddenDiv);\n          }\n\n          self.player = self.player || new global$1$1.YT.Player(self.playerID, self.playerOptions);\n\n          if (firstInit) {\n            self.$video = document.getElementById(self.playerID); // add accessibility attributes\n\n            if (self.options.accessibilityHidden) {\n              self.$video.setAttribute('tabindex', '-1');\n              self.$video.setAttribute('aria-hidden', 'true');\n            } // get video width and height\n\n\n            self.videoWidth = parseInt(self.$video.getAttribute('width'), 10) || 1280;\n            self.videoHeight = parseInt(self.$video.getAttribute('height'), 10) || 720;\n          }\n        } // Vimeo\n\n\n        if (self.type === 'vimeo') {\n          self.playerOptions = {\n            // GDPR Compliance.\n            dnt: 1,\n            id: self.videoID,\n            autopause: 0,\n            transparent: 0,\n            autoplay: self.options.autoplay ? 1 : 0,\n            loop: self.options.loop ? 1 : 0,\n            muted: self.options.mute ? 1 : 0\n          };\n\n          if (self.options.volume) {\n            self.playerOptions.volume = self.options.volume;\n          } // hide controls\n\n\n          if (!self.options.showControls) {\n            self.playerOptions.badge = 0;\n            self.playerOptions.byline = 0;\n            self.playerOptions.portrait = 0;\n            self.playerOptions.title = 0;\n            self.playerOptions.background = 1;\n          }\n\n          if (!self.$video) {\n            let playerOptionsString = '';\n            Object.keys(self.playerOptions).forEach(key => {\n              if (playerOptionsString !== '') {\n                playerOptionsString += '&';\n              }\n\n              playerOptionsString += `${key}=${encodeURIComponent(self.playerOptions[key])}`;\n            }); // we need to create iframe manually because when we create it using API\n            // js events won't triggers after iframe moved to another place\n\n            self.$video = document.createElement('iframe');\n            self.$video.setAttribute('id', self.playerID);\n            self.$video.setAttribute('src', `https://player.vimeo.com/video/${self.videoID}?${playerOptionsString}`);\n            self.$video.setAttribute('frameborder', '0');\n            self.$video.setAttribute('mozallowfullscreen', '');\n            self.$video.setAttribute('allowfullscreen', '');\n            self.$video.setAttribute('title', 'Vimeo video player'); // add accessibility attributes\n\n            if (self.options.accessibilityHidden) {\n              self.$video.setAttribute('tabindex', '-1');\n              self.$video.setAttribute('aria-hidden', 'true');\n            }\n\n            hiddenDiv.appendChild(self.$video);\n            document.body.appendChild(hiddenDiv);\n          }\n\n          self.player = self.player || new global$1$1.Vimeo.Player(self.$video, self.playerOptions); // set current time for autoplay\n\n          if (self.options.startTime && self.options.autoplay) {\n            self.player.setCurrentTime(self.options.startTime);\n          } // get video width and height\n\n\n          self.player.getVideoWidth().then(width => {\n            self.videoWidth = width || 1280;\n          });\n          self.player.getVideoHeight().then(height => {\n            self.videoHeight = height || 720;\n          }); // events\n\n          let vmStarted;\n          self.player.on('timeupdate', e => {\n            if (!vmStarted) {\n              self.fire('started', e);\n              vmStarted = 1;\n            }\n\n            self.fire('timeupdate', e); // check for end of video and play again or stop\n\n            if (self.options.endTime) {\n              if (self.options.endTime && e.seconds >= self.options.endTime) {\n                if (self.options.loop) {\n                  self.play(self.options.startTime);\n                } else {\n                  self.pause();\n                }\n              }\n            }\n          });\n          self.player.on('play', e => {\n            self.fire('play', e); // check for the start time and start with it\n\n            if (self.options.startTime && e.seconds === 0) {\n              self.play(self.options.startTime);\n            }\n          });\n          self.player.on('pause', e => {\n            self.fire('pause', e);\n          });\n          self.player.on('ended', e => {\n            self.fire('ended', e);\n          });\n          self.player.on('loaded', e => {\n            self.fire('ready', e);\n          });\n          self.player.on('volumechange', e => {\n            self.fire('volumechange', e);\n          });\n          self.player.on('error', e => {\n            self.fire('error', e);\n          });\n        } // Local\n\n\n        function addSourceToLocal(element, src, type) {\n          const source = document.createElement('source');\n          source.src = src;\n          source.type = type;\n          element.appendChild(source);\n        }\n\n        if (self.type === 'local') {\n          if (!self.$video) {\n            self.$video = document.createElement('video'); // show controls\n\n            if (self.options.showControls) {\n              self.$video.controls = true;\n            } // mute\n\n\n            if (self.options.mute) {\n              self.$video.muted = true;\n            } else if (self.$video.volume) {\n              self.$video.volume = self.options.volume / 100;\n            } // loop\n\n\n            if (self.options.loop) {\n              self.$video.loop = true;\n            } // autoplay enable on mobile devices\n\n\n            self.$video.setAttribute('playsinline', '');\n            self.$video.setAttribute('webkit-playsinline', ''); // add accessibility attributes\n\n            if (self.options.accessibilityHidden) {\n              self.$video.setAttribute('tabindex', '-1');\n              self.$video.setAttribute('aria-hidden', 'true');\n            }\n\n            self.$video.setAttribute('id', self.playerID);\n            hiddenDiv.appendChild(self.$video);\n            document.body.appendChild(hiddenDiv);\n            Object.keys(self.videoID).forEach(key => {\n              addSourceToLocal(self.$video, self.videoID[key], `video/${key}`);\n            });\n          }\n\n          self.player = self.player || self.$video;\n          let locStarted;\n          self.player.addEventListener('playing', e => {\n            if (!locStarted) {\n              self.fire('started', e);\n            }\n\n            locStarted = 1;\n          });\n          self.player.addEventListener('timeupdate', function (e) {\n            self.fire('timeupdate', e); // check for end of video and play again or stop\n\n            if (self.options.endTime) {\n              if (self.options.endTime && this.currentTime >= self.options.endTime) {\n                if (self.options.loop) {\n                  self.play(self.options.startTime);\n                } else {\n                  self.pause();\n                }\n              }\n            }\n          });\n          self.player.addEventListener('play', e => {\n            self.fire('play', e);\n          });\n          self.player.addEventListener('pause', e => {\n            self.fire('pause', e);\n          });\n          self.player.addEventListener('ended', e => {\n            self.fire('ended', e);\n          });\n          self.player.addEventListener('loadedmetadata', function () {\n            // get video width and height\n            self.videoWidth = this.videoWidth || 1280;\n            self.videoHeight = this.videoHeight || 720;\n            self.fire('ready'); // autoplay\n\n            if (self.options.autoplay) {\n              self.play(self.options.startTime);\n            }\n          });\n          self.player.addEventListener('volumechange', e => {\n            self.getVolume(volume => {\n              self.options.volume = volume;\n            });\n            self.fire('volumechange', e);\n          });\n          self.player.addEventListener('error', e => {\n            self.fire('error', e);\n          });\n        }\n\n        callback(self.$video);\n      });\n    }\n\n    init() {\n      const self = this;\n      self.playerID = `VideoWorker-${self.ID}`;\n    }\n\n    loadAPI() {\n      const self = this;\n\n      if (YoutubeAPIadded && VimeoAPIadded) {\n        return;\n      }\n\n      let src = ''; // load Youtube API\n\n      if (self.type === 'youtube' && !YoutubeAPIadded) {\n        YoutubeAPIadded = 1;\n        src = 'https://www.youtube.com/iframe_api';\n      } // load Vimeo API\n\n\n      if (self.type === 'vimeo' && !VimeoAPIadded) {\n        VimeoAPIadded = 1; // Useful when Vimeo API added using RequireJS https://github.com/nk-o/video-worker/pull/7\n\n        if (typeof global$1$1.Vimeo !== 'undefined') {\n          return;\n        }\n\n        src = 'https://player.vimeo.com/api/player.js';\n      }\n\n      if (!src) {\n        return;\n      } // add script in head section\n\n\n      let tag = document.createElement('script');\n      let head = document.getElementsByTagName('head')[0];\n      tag.src = src;\n      head.appendChild(tag);\n      head = null;\n      tag = null;\n    }\n\n    onAPIready(callback) {\n      const self = this; // Youtube\n\n      if (self.type === 'youtube') {\n        // Listen for global YT player callback\n        if ((typeof global$1$1.YT === 'undefined' || global$1$1.YT.loaded === 0) && !loadingYoutubePlayer) {\n          // Prevents Ready event from being called twice\n          loadingYoutubePlayer = 1; // Creates deferred so, other players know when to wait.\n\n          global$1$1.onYouTubeIframeAPIReady = function () {\n            global$1$1.onYouTubeIframeAPIReady = null;\n            loadingYoutubeDefer.resolve('done');\n            callback();\n          };\n        } else if (typeof global$1$1.YT === 'object' && global$1$1.YT.loaded === 1) {\n          callback();\n        } else {\n          loadingYoutubeDefer.done(() => {\n            callback();\n          });\n        }\n      } // Vimeo\n\n\n      if (self.type === 'vimeo') {\n        if (typeof global$1$1.Vimeo === 'undefined' && !loadingVimeoPlayer) {\n          loadingVimeoPlayer = 1;\n          const vimeoInterval = setInterval(() => {\n            if (typeof global$1$1.Vimeo !== 'undefined') {\n              clearInterval(vimeoInterval);\n              loadingVimeoDefer.resolve('done');\n              callback();\n            }\n          }, 20);\n        } else if (typeof global$1$1.Vimeo !== 'undefined') {\n          callback();\n        } else {\n          loadingVimeoDefer.done(() => {\n            callback();\n          });\n        }\n      } // Local\n\n\n      if (self.type === 'local') {\n        callback();\n      }\n    }\n\n  }\n\n  function ready(callback) {\n    if ('complete' === document.readyState || 'interactive' === document.readyState) {\n      // Already ready or interactive, execute callback\n      callback();\n    } else {\n      document.addEventListener('DOMContentLoaded', callback, {\n        capture: true,\n        once: true,\n        passive: true\n      });\n    }\n  }\n\n  /* eslint-disable import/no-mutable-exports */\n\n  /* eslint-disable no-restricted-globals */\n  let win;\n\n  if ('undefined' !== typeof window) {\n    win = window;\n  } else if ('undefined' !== typeof global) {\n    win = global;\n  } else if ('undefined' !== typeof self) {\n    win = self;\n  } else {\n    win = {};\n  }\n\n  var global$1 = win;\n\n  function jarallaxVideo(jarallax = global$1.jarallax) {\n    if ('undefined' === typeof jarallax) {\n      return;\n    }\n\n    const Jarallax = jarallax.constructor; // append video after when block will be visible.\n\n    const defOnScroll = Jarallax.prototype.onScroll;\n\n    Jarallax.prototype.onScroll = function () {\n      const self = this;\n      defOnScroll.apply(self);\n      const isReady = !self.isVideoInserted && self.video && (!self.options.videoLazyLoading || self.isElementInViewport) && !self.options.disableVideo();\n\n      if (isReady) {\n        self.isVideoInserted = true;\n        self.video.getVideo(video => {\n          const $parent = video.parentNode;\n          self.css(video, {\n            position: self.image.position,\n            top: '0px',\n            left: '0px',\n            right: '0px',\n            bottom: '0px',\n            width: '100%',\n            height: '100%',\n            maxWidth: 'none',\n            maxHeight: 'none',\n            pointerEvents: 'none',\n            transformStyle: 'preserve-3d',\n            backfaceVisibility: 'hidden',\n            willChange: 'transform,opacity',\n            margin: 0,\n            zIndex: -1\n          });\n          self.$video = video; // add Poster attribute to self-hosted video\n\n          if ('local' === self.video.type) {\n            if (self.image.src) {\n              self.$video.setAttribute('poster', self.image.src);\n            } else if (self.image.$item && 'IMG' === self.image.$item.tagName && self.image.$item.src) {\n              self.$video.setAttribute('poster', self.image.$item.src);\n            }\n          } // insert video tag\n\n\n          self.image.$container.appendChild(video); // remove parent video element (created by VideoWorker)\n\n          $parent.parentNode.removeChild($parent); // call onVideoInsert event\n\n          if (self.options.onVideoInsert) {\n            self.options.onVideoInsert.call(self);\n          }\n        });\n      }\n    }; // cover video\n\n\n    const defCoverImage = Jarallax.prototype.coverImage;\n\n    Jarallax.prototype.coverImage = function () {\n      const self = this;\n      const imageData = defCoverImage.apply(self);\n      const node = self.image.$item ? self.image.$item.nodeName : false;\n\n      if (imageData && self.video && node && ('IFRAME' === node || 'VIDEO' === node)) {\n        let h = imageData.image.height;\n        let w = h * self.image.width / self.image.height;\n        let ml = (imageData.container.width - w) / 2;\n        let mt = imageData.image.marginTop;\n\n        if (imageData.container.width > w) {\n          w = imageData.container.width;\n          h = w * self.image.height / self.image.width;\n          ml = 0;\n          mt += (imageData.image.height - h) / 2;\n        } // add video height over than need to hide controls\n\n\n        if ('IFRAME' === node) {\n          h += 400;\n          mt -= 200;\n        }\n\n        self.css(self.$video, {\n          width: `${w}px`,\n          marginLeft: `${ml}px`,\n          height: `${h}px`,\n          marginTop: `${mt}px`\n        });\n      }\n\n      return imageData;\n    }; // init video\n\n\n    const defInitImg = Jarallax.prototype.initImg;\n\n    Jarallax.prototype.initImg = function () {\n      const self = this;\n      const defaultResult = defInitImg.apply(self);\n\n      if (!self.options.videoSrc) {\n        self.options.videoSrc = self.$item.getAttribute('data-jarallax-video') || null;\n      }\n\n      if (self.options.videoSrc) {\n        self.defaultInitImgResult = defaultResult;\n        return true;\n      }\n\n      return defaultResult;\n    };\n\n    const defCanInitParallax = Jarallax.prototype.canInitParallax;\n\n    Jarallax.prototype.canInitParallax = function () {\n      const self = this;\n      let defaultResult = defCanInitParallax.apply(self);\n\n      if (!self.options.videoSrc) {\n        return defaultResult;\n      } // Init video api\n\n\n      const video = new VideoWorker(self.options.videoSrc, {\n        autoplay: true,\n        loop: self.options.videoLoop,\n        showControls: false,\n        accessibilityHidden: true,\n        startTime: self.options.videoStartTime || 0,\n        endTime: self.options.videoEndTime || 0,\n        mute: self.options.videoVolume ? 0 : 1,\n        volume: self.options.videoVolume || 0\n      }); // call onVideoWorkerInit event\n\n      if (self.options.onVideoWorkerInit) {\n        self.options.onVideoWorkerInit.call(self, video);\n      }\n\n      function resetDefaultImage() {\n        if (self.image.$default_item) {\n          self.image.$item = self.image.$default_item;\n          self.image.$item.style.display = 'block'; // set image width and height\n\n          self.coverImage();\n          self.onScroll();\n        }\n      }\n\n      if (video.isValid()) {\n        // Force enable parallax.\n        // When the parallax disabled on mobile devices, we still need to display videos.\n        // https://github.com/nk-o/jarallax/issues/159\n        if (this.options.disableParallax()) {\n          defaultResult = true;\n          self.image.position = 'absolute';\n          self.options.type = 'scroll';\n          self.options.speed = 1;\n        } // if parallax will not be inited, we can add thumbnail on background.\n\n\n        if (!defaultResult) {\n          if (!self.defaultInitImgResult) {\n            video.getImageURL(url => {\n              // save default user styles\n              const curStyle = self.$item.getAttribute('style');\n\n              if (curStyle) {\n                self.$item.setAttribute('data-jarallax-original-styles', curStyle);\n              } // set new background\n\n\n              self.css(self.$item, {\n                'background-image': `url(\"${url}\")`,\n                'background-position': 'center',\n                'background-size': 'cover'\n              });\n            });\n          } // init video\n\n        } else {\n          video.on('ready', () => {\n            if (self.options.videoPlayOnlyVisible) {\n              const oldOnScroll = self.onScroll;\n\n              self.onScroll = function () {\n                oldOnScroll.apply(self);\n\n                if (!self.videoError && (self.options.videoLoop || !self.options.videoLoop && !self.videoEnded)) {\n                  if (self.isVisible()) {\n                    video.play();\n                  } else {\n                    video.pause();\n                  }\n                }\n              };\n            } else {\n              video.play();\n            }\n          });\n          video.on('started', () => {\n            self.image.$default_item = self.image.$item;\n            self.image.$item = self.$video; // set video width and height\n\n            self.image.width = self.video.videoWidth || 1280;\n            self.image.height = self.video.videoHeight || 720;\n            self.coverImage();\n            self.onScroll(); // hide image\n\n            if (self.image.$default_item) {\n              self.image.$default_item.style.display = 'none';\n            }\n          });\n          video.on('ended', () => {\n            self.videoEnded = true;\n\n            if (!self.options.videoLoop) {\n              // show default image if Loop disabled.\n              resetDefaultImage();\n            }\n          });\n          video.on('error', () => {\n            self.videoError = true; // show default image if video loading error.\n\n            resetDefaultImage();\n          });\n          self.video = video; // set image if not exists\n\n          if (!self.defaultInitImgResult) {\n            // set empty image on self-hosted video if not defined\n            self.image.src = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';\n\n            if ('local' !== video.type) {\n              video.getImageURL(url => {\n                self.image.bgImage = `url(\"${url}\")`;\n                self.init();\n              });\n              return false;\n            }\n          }\n        }\n      }\n\n      return defaultResult;\n    }; // Destroy video parallax\n\n\n    const defDestroy = Jarallax.prototype.destroy;\n\n    Jarallax.prototype.destroy = function () {\n      const self = this;\n\n      if (self.image.$default_item) {\n        self.image.$item = self.image.$default_item;\n        delete self.image.$default_item;\n      }\n\n      defDestroy.apply(self);\n    };\n  }\n\n  jarallaxVideo(); // data-jarallax-video initialization\n\n  ready(() => {\n    if ('undefined' !== typeof global$1.jarallax) {\n      global$1.jarallax(document.querySelectorAll('[data-jarallax-video]'));\n    }\n  }); // We should add VideoWorker globally, since some project uses it.\n\n  if (!global$1.VideoWorker) {\n    global$1.VideoWorker = VideoWorker;\n  }\n\n  return jarallaxVideo;\n\n}));\n//# sourceMappingURL=jarallax-video.js.map\n","Magento_PageBuilder/js/resource/jarallax/jarallax.js":"/*!\n * Jarallax v2.0.3 (https://github.com/nk-o/jarallax)\n * Copyright 2022 nK <https://nkdev.info>\n * Licensed under MIT (https://github.com/nk-o/jarallax/blob/master/LICENSE)\n */\n(function (global, factory) {\n  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n      typeof define === 'function' && define.amd ? define(factory) :\n          (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.jarallax = factory());\n})(this, (function () { 'use strict';\n\n  function ready(callback) {\n    if ('complete' === document.readyState || 'interactive' === document.readyState) {\n      // Already ready or interactive, execute callback\n      callback();\n    } else {\n      document.addEventListener('DOMContentLoaded', callback, {\n        capture: true,\n        once: true,\n        passive: true\n      });\n    }\n  }\n\n  /* eslint-disable import/no-mutable-exports */\n\n  /* eslint-disable no-restricted-globals */\n  let win;\n\n  if ('undefined' !== typeof window) {\n    win = window;\n  } else if ('undefined' !== typeof global) {\n    win = global;\n  } else if ('undefined' !== typeof self) {\n    win = self;\n  } else {\n    win = {};\n  }\n\n  var global$1 = win;\n\n  const {\n    navigator\n  } = global$1;\n  const isMobile = /*#__PURE__*/ /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);\n  let $deviceHelper;\n  /**\n   * The most popular mobile browsers changes height after page scroll and this generates image jumping.\n   * We can fix it using this workaround with vh units.\n   */\n\n  function getDeviceHeight() {\n    if (!$deviceHelper && document.body) {\n      $deviceHelper = document.createElement('div');\n      $deviceHelper.style.cssText = 'position: fixed; top: -9999px; left: 0; height: 100vh; width: 0;';\n      document.body.appendChild($deviceHelper);\n    }\n\n    return ($deviceHelper ? $deviceHelper.clientHeight : 0) || global$1.innerHeight || document.documentElement.clientHeight;\n  } // Window height data\n\n\n  let wndH;\n\n  function updateWndVars() {\n    if (isMobile) {\n      wndH = getDeviceHeight();\n    } else {\n      wndH = global$1.innerHeight || document.documentElement.clientHeight;\n    }\n  }\n\n  updateWndVars();\n  global$1.addEventListener('resize', updateWndVars);\n  global$1.addEventListener('orientationchange', updateWndVars);\n  global$1.addEventListener('load', updateWndVars);\n  ready(() => {\n    updateWndVars();\n  }); // list with all jarallax instances\n  // need to render all in one scroll/resize event\n\n  const jarallaxList = []; // get all parents of the element.\n\n  function getParents(elem) {\n    const parents = [];\n\n    while (null !== elem.parentElement) {\n      elem = elem.parentElement;\n\n      if (1 === elem.nodeType) {\n        parents.push(elem);\n      }\n    }\n\n    return parents;\n  }\n\n  function updateParallax() {\n    if (!jarallaxList.length) {\n      return;\n    }\n\n    jarallaxList.forEach((data, k) => {\n      const {\n        instance,\n        oldData\n      } = data;\n      const clientRect = instance.$item.getBoundingClientRect();\n      const newData = {\n        width: clientRect.width,\n        height: clientRect.height,\n        top: clientRect.top,\n        bottom: clientRect.bottom,\n        wndW: global$1.innerWidth,\n        wndH\n      };\n      const isResized = !oldData || oldData.wndW !== newData.wndW || oldData.wndH !== newData.wndH || oldData.width !== newData.width || oldData.height !== newData.height;\n      const isScrolled = isResized || !oldData || oldData.top !== newData.top || oldData.bottom !== newData.bottom;\n      jarallaxList[k].oldData = newData;\n\n      if (isResized) {\n        instance.onResize();\n      }\n\n      if (isScrolled) {\n        instance.onScroll();\n      }\n    });\n    global$1.requestAnimationFrame(updateParallax);\n  }\n\n  let instanceID = 0; // Jarallax class\n\n  class Jarallax {\n    constructor(item, userOptions) {\n      const self = this;\n      self.instanceID = instanceID;\n      instanceID += 1;\n      self.$item = item;\n      self.defaults = {\n        type: 'scroll',\n        // type of parallax: scroll, scale, opacity, scale-opacity, scroll-opacity\n        speed: 0.5,\n        // supported value from -1 to 2\n        imgSrc: null,\n        imgElement: '.jarallax-img',\n        imgSize: 'cover',\n        imgPosition: '50% 50%',\n        imgRepeat: 'no-repeat',\n        // supported only for background, not for <img> tag\n        keepImg: false,\n        // keep <img> tag in it's default place\n        elementInViewport: null,\n        zIndex: -100,\n        disableParallax: false,\n        disableVideo: false,\n        // video\n        videoSrc: null,\n        videoStartTime: 0,\n        videoEndTime: 0,\n        videoVolume: 0,\n        videoLoop: true,\n        videoPlayOnlyVisible: true,\n        videoLazyLoading: true,\n        // events\n        onScroll: null,\n        // function(calculations) {}\n        onInit: null,\n        // function() {}\n        onDestroy: null,\n        // function() {}\n        onCoverImage: null // function() {}\n\n      }; // prepare data-options\n\n      const dataOptions = self.$item.dataset || {};\n      const pureDataOptions = {};\n      Object.keys(dataOptions).forEach(key => {\n        const loweCaseOption = key.substr(0, 1).toLowerCase() + key.substr(1);\n\n        if (loweCaseOption && 'undefined' !== typeof self.defaults[loweCaseOption]) {\n          pureDataOptions[loweCaseOption] = dataOptions[key];\n        }\n      });\n      self.options = self.extend({}, self.defaults, pureDataOptions, userOptions);\n      self.pureOptions = self.extend({}, self.options); // prepare 'true' and 'false' strings to boolean\n\n      Object.keys(self.options).forEach(key => {\n        if ('true' === self.options[key]) {\n          self.options[key] = true;\n        } else if ('false' === self.options[key]) {\n          self.options[key] = false;\n        }\n      }); // fix speed option [-1.0, 2.0]\n\n      self.options.speed = Math.min(2, Math.max(-1, parseFloat(self.options.speed))); // prepare disableParallax callback\n\n      if ('string' === typeof self.options.disableParallax) {\n        self.options.disableParallax = new RegExp(self.options.disableParallax);\n      }\n\n      if (self.options.disableParallax instanceof RegExp) {\n        const disableParallaxRegexp = self.options.disableParallax;\n\n        self.options.disableParallax = () => disableParallaxRegexp.test(navigator.userAgent);\n      }\n\n      if ('function' !== typeof self.options.disableParallax) {\n        self.options.disableParallax = () => false;\n      } // prepare disableVideo callback\n\n\n      if ('string' === typeof self.options.disableVideo) {\n        self.options.disableVideo = new RegExp(self.options.disableVideo);\n      }\n\n      if (self.options.disableVideo instanceof RegExp) {\n        const disableVideoRegexp = self.options.disableVideo;\n\n        self.options.disableVideo = () => disableVideoRegexp.test(navigator.userAgent);\n      }\n\n      if ('function' !== typeof self.options.disableVideo) {\n        self.options.disableVideo = () => false;\n      } // custom element to check if parallax in viewport\n\n\n      let elementInVP = self.options.elementInViewport; // get first item from array\n\n      if (elementInVP && 'object' === typeof elementInVP && 'undefined' !== typeof elementInVP.length) {\n        [elementInVP] = elementInVP;\n      } // check if dom element\n\n\n      if (!(elementInVP instanceof Element)) {\n        elementInVP = null;\n      }\n\n      self.options.elementInViewport = elementInVP;\n      self.image = {\n        src: self.options.imgSrc || null,\n        $container: null,\n        useImgTag: false,\n        // 1. Position fixed is needed for the most of browsers because absolute position have glitches\n        // 2. On MacOS with smooth scroll there is a huge lags with absolute position - https://github.com/nk-o/jarallax/issues/75\n        // 3. Previously used 'absolute' for mobile devices. But we re-tested on iPhone 12 and 'fixed' position is working better, then 'absolute', so for now position is always 'fixed'\n        position: 'fixed'\n      };\n\n      if (self.initImg() && self.canInitParallax()) {\n        self.init();\n      }\n    } // add styles to element\n    // eslint-disable-next-line class-methods-use-this\n\n\n    css(el, styles) {\n      if ('string' === typeof styles) {\n        return global$1.getComputedStyle(el).getPropertyValue(styles);\n      }\n\n      Object.keys(styles).forEach(key => {\n        el.style[key] = styles[key];\n      });\n      return el;\n    } // Extend like jQuery.extend\n    // eslint-disable-next-line class-methods-use-this\n\n\n    extend(out, ...args) {\n      out = out || {};\n      Object.keys(args).forEach(i => {\n        if (!args[i]) {\n          return;\n        }\n\n        Object.keys(args[i]).forEach(key => {\n          out[key] = args[i][key];\n        });\n      });\n      return out;\n    } // get window size and scroll position. Useful for extensions\n    // eslint-disable-next-line class-methods-use-this\n\n\n    getWindowData() {\n      return {\n        width: global$1.innerWidth || document.documentElement.clientWidth,\n        height: wndH,\n        y: document.documentElement.scrollTop\n      };\n    } // Jarallax functions\n\n\n    initImg() {\n      const self = this; // find image element\n\n      let $imgElement = self.options.imgElement;\n\n      if ($imgElement && 'string' === typeof $imgElement) {\n        $imgElement = self.$item.querySelector($imgElement);\n      } // check if dom element\n\n\n      if (!($imgElement instanceof Element)) {\n        if (self.options.imgSrc) {\n          $imgElement = new Image();\n          $imgElement.src = self.options.imgSrc;\n        } else {\n          $imgElement = null;\n        }\n      }\n\n      if ($imgElement) {\n        if (self.options.keepImg) {\n          self.image.$item = $imgElement.cloneNode(true);\n        } else {\n          self.image.$item = $imgElement;\n          self.image.$itemParent = $imgElement.parentNode;\n        }\n\n        self.image.useImgTag = true;\n      } // true if there is img tag\n\n\n      if (self.image.$item) {\n        return true;\n      } // get image src\n\n\n      if (null === self.image.src) {\n        self.image.src = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';\n        self.image.bgImage = self.css(self.$item, 'background-image');\n      }\n\n      return !(!self.image.bgImage || 'none' === self.image.bgImage);\n    }\n\n    canInitParallax() {\n      return !this.options.disableParallax();\n    }\n\n    init() {\n      const self = this;\n      const containerStyles = {\n        position: 'absolute',\n        top: 0,\n        left: 0,\n        width: '100%',\n        height: '100%',\n        overflow: 'hidden'\n      };\n      let imageStyles = {\n        pointerEvents: 'none',\n        transformStyle: 'preserve-3d',\n        backfaceVisibility: 'hidden',\n        willChange: 'transform,opacity'\n      };\n\n      if (!self.options.keepImg) {\n        // save default user styles\n        const curStyle = self.$item.getAttribute('style');\n\n        if (curStyle) {\n          self.$item.setAttribute('data-jarallax-original-styles', curStyle);\n        }\n\n        if (self.image.useImgTag) {\n          const curImgStyle = self.image.$item.getAttribute('style');\n\n          if (curImgStyle) {\n            self.image.$item.setAttribute('data-jarallax-original-styles', curImgStyle);\n          }\n        }\n      } // set relative position and z-index to the parent\n\n\n      if ('static' === self.css(self.$item, 'position')) {\n        self.css(self.$item, {\n          position: 'relative'\n        });\n      }\n\n      if ('auto' === self.css(self.$item, 'z-index')) {\n        self.css(self.$item, {\n          zIndex: 0\n        });\n      } // container for parallax image\n\n\n      self.image.$container = document.createElement('div');\n      self.css(self.image.$container, containerStyles);\n      self.css(self.image.$container, {\n        'z-index': self.options.zIndex\n      }); // it will remove some image overlapping\n      // overlapping occur due to an image position fixed inside absolute position element\n      // needed only when background in fixed position\n\n      if ('fixed' === this.image.position) {\n        self.css(self.image.$container, {\n          '-webkit-clip-path': 'polygon(0 0, 100% 0, 100% 100%, 0 100%)',\n          'clip-path': 'polygon(0 0, 100% 0, 100% 100%, 0 100%)'\n        });\n      }\n\n      self.image.$container.setAttribute('id', `jarallax-container-${self.instanceID}`);\n      self.$item.appendChild(self.image.$container); // use img tag\n\n      if (self.image.useImgTag) {\n        imageStyles = self.extend({\n          'object-fit': self.options.imgSize,\n          'object-position': self.options.imgPosition,\n          'max-width': 'none'\n        }, containerStyles, imageStyles); // use div with background image\n      } else {\n        self.image.$item = document.createElement('div');\n\n        if (self.image.src) {\n          imageStyles = self.extend({\n            'background-position': self.options.imgPosition,\n            'background-size': self.options.imgSize,\n            'background-repeat': self.options.imgRepeat,\n            'background-image': self.image.bgImage || `url(\"${self.image.src}\")`\n          }, containerStyles, imageStyles);\n        }\n      }\n\n      if ('opacity' === self.options.type || 'scale' === self.options.type || 'scale-opacity' === self.options.type || 1 === self.options.speed) {\n        self.image.position = 'absolute';\n      } // 1. Check if one of parents have transform style (without this check, scroll transform will be inverted if used parallax with position fixed)\n      //    discussion - https://github.com/nk-o/jarallax/issues/9\n      // 2. Check if parents have overflow scroll\n\n\n      if ('fixed' === self.image.position) {\n        const $parents = getParents(self.$item).filter(el => {\n          const styles = global$1.getComputedStyle(el);\n          const parentTransform = styles['-webkit-transform'] || styles['-moz-transform'] || styles.transform;\n          const overflowRegex = /(auto|scroll)/;\n          return parentTransform && 'none' !== parentTransform || overflowRegex.test(styles.overflow + styles['overflow-y'] + styles['overflow-x']);\n        });\n        self.image.position = $parents.length ? 'absolute' : 'fixed';\n      } // add position to parallax block\n\n\n      imageStyles.position = self.image.position; // insert parallax image\n\n      self.css(self.image.$item, imageStyles);\n      self.image.$container.appendChild(self.image.$item); // set initial position and size\n\n      self.onResize();\n      self.onScroll(true); // call onInit event\n\n      if (self.options.onInit) {\n        self.options.onInit.call(self);\n      } // remove default user background\n\n\n      if ('none' !== self.css(self.$item, 'background-image')) {\n        self.css(self.$item, {\n          'background-image': 'none'\n        });\n      }\n\n      self.addToParallaxList();\n    } // add to parallax instances list\n\n\n    addToParallaxList() {\n      jarallaxList.push({\n        instance: this\n      });\n\n      if (1 === jarallaxList.length) {\n        global$1.requestAnimationFrame(updateParallax);\n      }\n    } // remove from parallax instances list\n\n\n    removeFromParallaxList() {\n      const self = this;\n      jarallaxList.forEach((data, key) => {\n        if (data.instance.instanceID === self.instanceID) {\n          jarallaxList.splice(key, 1);\n        }\n      });\n    }\n\n    destroy() {\n      const self = this;\n      self.removeFromParallaxList(); // return styles on container as before jarallax init\n\n      const originalStylesTag = self.$item.getAttribute('data-jarallax-original-styles');\n      self.$item.removeAttribute('data-jarallax-original-styles'); // null occurs if there is no style tag before jarallax init\n\n      if (!originalStylesTag) {\n        self.$item.removeAttribute('style');\n      } else {\n        self.$item.setAttribute('style', originalStylesTag);\n      }\n\n      if (self.image.useImgTag) {\n        // return styles on img tag as before jarallax init\n        const originalStylesImgTag = self.image.$item.getAttribute('data-jarallax-original-styles');\n        self.image.$item.removeAttribute('data-jarallax-original-styles'); // null occurs if there is no style tag before jarallax init\n\n        if (!originalStylesImgTag) {\n          self.image.$item.removeAttribute('style');\n        } else {\n          self.image.$item.setAttribute('style', originalStylesTag);\n        } // move img tag to its default position\n\n\n        if (self.image.$itemParent) {\n          self.image.$itemParent.appendChild(self.image.$item);\n        }\n      } // remove additional dom elements\n\n\n      if (self.image.$container) {\n        self.image.$container.parentNode.removeChild(self.image.$container);\n      } // call onDestroy event\n\n\n      if (self.options.onDestroy) {\n        self.options.onDestroy.call(self);\n      } // delete jarallax from item\n\n\n      delete self.$item.jarallax;\n    } // Fallback for removed function.\n    // Does nothing now.\n    // eslint-disable-next-line class-methods-use-this\n\n\n    clipContainer() {}\n\n    coverImage() {\n      const self = this;\n      const rect = self.image.$container.getBoundingClientRect();\n      const contH = rect.height;\n      const {\n        speed\n      } = self.options;\n      const isScroll = 'scroll' === self.options.type || 'scroll-opacity' === self.options.type;\n      let scrollDist = 0;\n      let resultH = contH;\n      let resultMT = 0; // scroll parallax\n\n      if (isScroll) {\n        // scroll distance and height for image\n        if (0 > speed) {\n          scrollDist = speed * Math.max(contH, wndH);\n\n          if (wndH < contH) {\n            scrollDist -= speed * (contH - wndH);\n          }\n        } else {\n          scrollDist = speed * (contH + wndH);\n        } // size for scroll parallax\n\n\n        if (1 < speed) {\n          resultH = Math.abs(scrollDist - wndH);\n        } else if (0 > speed) {\n          resultH = scrollDist / speed + Math.abs(scrollDist);\n        } else {\n          resultH += (wndH - contH) * (1 - speed);\n        }\n\n        scrollDist /= 2;\n      } // store scroll distance\n\n\n      self.parallaxScrollDistance = scrollDist; // vertical center\n\n      if (isScroll) {\n        resultMT = (wndH - resultH) / 2;\n      } else {\n        resultMT = (contH - resultH) / 2;\n      } // apply result to item\n\n\n      self.css(self.image.$item, {\n        height: `${resultH}px`,\n        marginTop: `${resultMT}px`,\n        left: 'fixed' === self.image.position ? `${rect.left}px` : '0',\n        width: `${rect.width}px`\n      }); // call onCoverImage event\n\n      if (self.options.onCoverImage) {\n        self.options.onCoverImage.call(self);\n      } // return some useful data. Used in the video cover function\n\n\n      return {\n        image: {\n          height: resultH,\n          marginTop: resultMT\n        },\n        container: rect\n      };\n    }\n\n    isVisible() {\n      return this.isElementInViewport || false;\n    }\n\n    onScroll(force) {\n      const self = this;\n      const rect = self.$item.getBoundingClientRect();\n      const contT = rect.top;\n      const contH = rect.height;\n      const styles = {}; // check if in viewport\n\n      let viewportRect = rect;\n\n      if (self.options.elementInViewport) {\n        viewportRect = self.options.elementInViewport.getBoundingClientRect();\n      }\n\n      self.isElementInViewport = 0 <= viewportRect.bottom && 0 <= viewportRect.right && viewportRect.top <= wndH && viewportRect.left <= global$1.innerWidth; // stop calculations if item is not in viewport\n\n      if (force ? false : !self.isElementInViewport) {\n        return;\n      } // calculate parallax helping variables\n\n\n      const beforeTop = Math.max(0, contT);\n      const beforeTopEnd = Math.max(0, contH + contT);\n      const afterTop = Math.max(0, -contT);\n      const beforeBottom = Math.max(0, contT + contH - wndH);\n      const beforeBottomEnd = Math.max(0, contH - (contT + contH - wndH));\n      const afterBottom = Math.max(0, -contT + wndH - contH);\n      const fromViewportCenter = 1 - 2 * ((wndH - contT) / (wndH + contH)); // calculate on how percent of section is visible\n\n      let visiblePercent = 1;\n\n      if (contH < wndH) {\n        visiblePercent = 1 - (afterTop || beforeBottom) / contH;\n      } else if (beforeTopEnd <= wndH) {\n        visiblePercent = beforeTopEnd / wndH;\n      } else if (beforeBottomEnd <= wndH) {\n        visiblePercent = beforeBottomEnd / wndH;\n      } // opacity\n\n\n      if ('opacity' === self.options.type || 'scale-opacity' === self.options.type || 'scroll-opacity' === self.options.type) {\n        styles.transform = 'translate3d(0,0,0)';\n        styles.opacity = visiblePercent;\n      } // scale\n\n\n      if ('scale' === self.options.type || 'scale-opacity' === self.options.type) {\n        let scale = 1;\n\n        if (0 > self.options.speed) {\n          scale -= self.options.speed * visiblePercent;\n        } else {\n          scale += self.options.speed * (1 - visiblePercent);\n        }\n\n        styles.transform = `scale(${scale}) translate3d(0,0,0)`;\n      } // scroll\n\n\n      if ('scroll' === self.options.type || 'scroll-opacity' === self.options.type) {\n        let positionY = self.parallaxScrollDistance * fromViewportCenter; // fix if parallax block in absolute position\n\n        if ('absolute' === self.image.position) {\n          positionY -= contT;\n        }\n\n        styles.transform = `translate3d(0,${positionY}px,0)`;\n      }\n\n      self.css(self.image.$item, styles); // call onScroll event\n\n      if (self.options.onScroll) {\n        self.options.onScroll.call(self, {\n          section: rect,\n          beforeTop,\n          beforeTopEnd,\n          afterTop,\n          beforeBottom,\n          beforeBottomEnd,\n          afterBottom,\n          visiblePercent,\n          fromViewportCenter\n        });\n      }\n    }\n\n    onResize() {\n      this.coverImage();\n    }\n\n  } // global definition\n\n\n  const jarallax = function (items, options, ...args) {\n    // check for dom element\n    // thanks: http://stackoverflow.com/questions/384286/javascript-isdom-how-do-you-check-if-a-javascript-object-is-a-dom-object\n    if ('object' === typeof HTMLElement ? items instanceof HTMLElement : items && 'object' === typeof items && null !== items && 1 === items.nodeType && 'string' === typeof items.nodeName) {\n      items = [items];\n    }\n\n    const len = items.length;\n    let k = 0;\n    let ret;\n\n    for (k; k < len; k += 1) {\n      if ('object' === typeof options || 'undefined' === typeof options) {\n        if (!items[k].jarallax) {\n          items[k].jarallax = new Jarallax(items[k], options);\n        }\n      } else if (items[k].jarallax) {\n        // eslint-disable-next-line prefer-spread\n        ret = items[k].jarallax[options].apply(items[k].jarallax, args);\n      }\n\n      if ('undefined' !== typeof ret) {\n        return ret;\n      }\n    }\n\n    return items;\n  };\n\n  jarallax.constructor = Jarallax;\n\n  const $ = global$1.jQuery; // jQuery support\n\n  if ('undefined' !== typeof $) {\n    const $Plugin = function (...args) {\n      Array.prototype.unshift.call(args, this);\n      const res = jarallax.apply(global$1, args);\n      return 'object' !== typeof res ? res : this;\n    };\n\n    $Plugin.constructor = jarallax.constructor; // no conflict\n\n    const old$Plugin = $.fn.jarallax;\n    $.fn.jarallax = $Plugin;\n\n    $.fn.jarallax.noConflict = function () {\n      $.fn.jarallax = old$Plugin;\n      return this;\n    };\n  } // data-jarallax initialization\n\n\n  ready(() => {\n    jarallax(document.querySelectorAll('[data-jarallax]'));\n  });\n\n  return jarallax;\n\n}));\n//# sourceMappingURL=jarallax.js.map\n","Magento_PageBuilder/js/resource/jquery/ui/jquery.ui.touch-punch.js":"/*!\n * jQuery UI Touch Punch 0.2.3\n *\n * Copyright 2011\u20132014, Dave Furfero\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Depends:\n *  jquery.ui.widget.js\n *  jquery.ui.mouse.js\n */\n(function ($) {\n\n    // Detect touch support\n    $.support.touch = 'ontouchend' in document;\n\n    // Ignore browsers without touch support\n    if (!$.support.touch) {\n        return;\n    }\n\n    var mouseProto = $.ui.mouse.prototype,\n        _mouseInit = mouseProto._mouseInit,\n        _mouseDestroy = mouseProto._mouseDestroy,\n        touchHandled;\n\n    /**\n     * Simulate a mouse event based on a corresponding touch event\n     * @param {Object} event A touch event\n     * @param {String} simulatedType The corresponding mouse event\n     */\n    function simulateMouseEvent (event, simulatedType) {\n\n        // Ignore multi-touch events\n        if (event.originalEvent.touches.length > 1) {\n            return;\n        }\n\n        event.preventDefault();\n\n        var touch = event.originalEvent.changedTouches[0],\n            simulatedEvent = document.createEvent('MouseEvents');\n\n        // Initialize the simulated mouse event using the touch event's coordinates\n        simulatedEvent.initMouseEvent(\n            simulatedType,    // type\n            true,             // bubbles\n            true,             // cancelable\n            window,           // view\n            1,                // detail\n            touch.screenX,    // screenX\n            touch.screenY,    // screenY\n            touch.clientX,    // clientX\n            touch.clientY,    // clientY\n            false,            // ctrlKey\n            false,            // altKey\n            false,            // shiftKey\n            false,            // metaKey\n            0,                // button\n            null              // relatedTarget\n        );\n\n        // Dispatch the simulated event to the target element\n        event.target.dispatchEvent(simulatedEvent);\n    }\n\n    /**\n     * Handle the jQuery UI widget's touchstart events\n     * @param {Object} event The widget element's touchstart event\n     */\n    mouseProto._touchStart = function (event) {\n\n        var self = this;\n\n        // Ignore the event if another widget is already being handled\n        if (touchHandled || !self._mouseCapture(event.originalEvent.changedTouches[0])) {\n            return;\n        }\n\n        // Set the flag to prevent other widgets from inheriting the touch event\n        touchHandled = true;\n\n        // Track movement to determine if interaction was a click\n        self._touchMoved = false;\n\n        // Simulate the mouseover event\n        simulateMouseEvent(event, 'mouseover');\n\n        // Simulate the mousemove event\n        simulateMouseEvent(event, 'mousemove');\n\n        // Simulate the mousedown event\n        simulateMouseEvent(event, 'mousedown');\n    };\n\n    /**\n     * Handle the jQuery UI widget's touchmove events\n     * @param {Object} event The document's touchmove event\n     */\n    mouseProto._touchMove = function (event) {\n\n        // Ignore event if not handled\n        if (!touchHandled) {\n            return;\n        }\n\n        // Interaction was not a click\n        this._touchMoved = true;\n\n        // Simulate the mousemove event\n        simulateMouseEvent(event, 'mousemove');\n    };\n\n    /**\n     * Handle the jQuery UI widget's touchend events\n     * @param {Object} event The document's touchend event\n     */\n    mouseProto._touchEnd = function (event) {\n\n        // Ignore event if not handled\n        if (!touchHandled) {\n            return;\n        }\n\n        // Simulate the mouseup event\n        simulateMouseEvent(event, 'mouseup');\n\n        // Simulate the mouseout event\n        simulateMouseEvent(event, 'mouseout');\n\n        // If the touch interaction did not move, it should trigger a click\n        if (!this._touchMoved) {\n\n            // Simulate the click event\n            simulateMouseEvent(event, 'click');\n        }\n\n        // Unset the flag to allow other widgets to inherit the touch event\n        touchHandled = false;\n    };\n\n    /**\n     * A duck punch of the $.ui.mouse _mouseInit method to support touch events.\n     * This method extends the widget with bound touch event handlers that\n     * translate touch events to mouse events and pass them to the widget's\n     * original mouse event handling methods.\n     */\n    mouseProto._mouseInit = function () {\n\n        var self = this;\n\n        // Delegate the touch handlers to the widget's element\n        self.element.bind({\n            touchstart: $.proxy(self, '_touchStart'),\n            touchmove: $.proxy(self, '_touchMove'),\n            touchend: $.proxy(self, '_touchEnd')\n        });\n\n        // Call the original $.ui.mouse init method\n        _mouseInit.call(self);\n    };\n\n    /**\n     * Remove the touch event handlers\n     */\n    mouseProto._mouseDestroy = function () {\n\n        var self = this;\n\n        // Delegate the touch handlers to the widget's element\n        self.element.unbind({\n            touchstart: $.proxy(self, '_touchStart'),\n            touchmove: $.proxy(self, '_touchMove'),\n            touchend: $.proxy(self, '_touchEnd')\n        });\n\n        // Call the original $.ui.mouse destroy method\n        _mouseDestroy.call(self);\n    };\n\n})(jQuery);","Magento_PageBuilder/js/resource/jquery/ui/jquery.ui.touch-punch.min.js":"/*!\n * jQuery UI Touch Punch 0.2.3\n *\n * Copyright 2011\u20132014, Dave Furfero\n * Dual licensed under the MIT or GPL Version 2 licenses.\n *\n * Depends:\n *  jquery.ui.widget.js\n *  jquery.ui.mouse.js\n */\n!function(a){function f(a,b){if(!(a.originalEvent.touches.length>1)){a.preventDefault();var c=a.originalEvent.changedTouches[0],d=document.createEvent(\"MouseEvents\");d.initMouseEvent(b,!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null),a.target.dispatchEvent(d)}}if(a.support.touch=\"ontouchend\"in document,a.support.touch){var e,b=a.ui.mouse.prototype,c=b._mouseInit,d=b._mouseDestroy;b._touchStart=function(a){var b=this;!e&&b._mouseCapture(a.originalEvent.changedTouches[0])&&(e=!0,b._touchMoved=!1,f(a,\"mouseover\"),f(a,\"mousemove\"),f(a,\"mousedown\"))},b._touchMove=function(a){e&&(this._touchMoved=!0,f(a,\"mousemove\"))},b._touchEnd=function(a){e&&(f(a,\"mouseup\"),f(a,\"mouseout\"),this._touchMoved||f(a,\"click\"),e=!1)},b._mouseInit=function(){var b=this;b.element.bind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),c.call(b)},b._mouseDestroy=function(){var b=this;b.element.unbind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),d.call(b)}}}(jQuery);\n"}
}});
