require.config({"config": {
        "jsbuild":{"mage/accordion.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/tabs'\n], function ($, tabs) {\n    'use strict';\n\n    $.widget('mage.accordion', tabs, {\n        options: {\n            active: [0],\n            multipleCollapsible: false,\n            openOnFocus: false\n        },\n\n        /**\n         * @private\n         */\n        _callCollapsible: function () {\n            var self = this,\n                disabled = false,\n                active = false;\n\n            if (typeof this.options.active === 'string') {\n                this.options.active = this.options.active.split(' ').map(function (item) {\n                    return parseInt(item, 10);\n                });\n            }\n\n            $.each(this.collapsibles, function (i) {\n                disabled = active = false;\n\n                if ($.inArray(i, self.options.disabled) !== -1) {\n                    disabled = true;\n                }\n\n                if ($.inArray(i, self.options.active) !== -1) {\n                    active = true;\n                }\n                self._instantiateCollapsible(this, i, active, disabled);\n            });\n        },\n\n        /**\n         * Overwrites default functionality to provide the option to activate/deactivate multiple sections simultaneous\n         * @param {*} action\n         * @param {*} index\n         * @private\n         */\n        _toggleActivate: function (action, index) {\n            var self = this;\n\n            if (Array.isArray(index && this.options.multipleCollapsible)) {\n                $.each(index, function () {\n                    self.collapsibles.eq(this).collapsible(action);\n                });\n            } else if (index === undefined && this.options.multipleCollapsible) {\n                this.collapsibles.collapsible(action);\n            } else {\n                this._super(action, index);\n            }\n        },\n\n        /**\n         * If the Accordion allows multiple section to be active at the same time, if deep linking is used\n         * sections that don't contain the id from anchor shouldn't be closed, otherwise the accordion uses the\n         * tabs behavior\n         * @private\n         */\n        _handleDeepLinking: function () {\n            if (!this.options.multipleCollapsible) {\n                this._super();\n            }\n        },\n\n        /**\n         * Prevent default behavior that closes the other sections when one gets activated if the Accordion allows\n         * multiple sections simultaneous\n         * @private\n         */\n        _closeOthers: function () {\n            var self = this;\n\n            if (!this.options.multipleCollapsible) {\n                $.each(this.collapsibles, function () {\n                    $(this).on('beforeOpen', function () {\n                        self.collapsibles.not(this).collapsible('deactivate');\n                    });\n                });\n            }\n            $.each(this.collapsibles, function () {\n                $(this).on('beforeOpen', function () {\n                    var section = $(this);\n\n                    section.addClass('allow').prevAll().addClass('allow');\n                    section.nextAll().removeClass('allow');\n                });\n            });\n        }\n    });\n\n    return $.mage.accordion;\n});\n","mage/apply/main.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    './scripts'\n], function (_, $, processScripts) {\n    'use strict';\n\n    var dataAttr = 'data-mage-init',\n        nodeSelector = '[' + dataAttr + ']';\n\n    /**\n     * Initializes components assigned to a specified element via data-* attribute.\n     *\n     * @param {HTMLElement} el - Element to initialize components with.\n     * @param {Object|String} config - Initial components' config.\n     * @param {String} component - Components' path.\n     */\n    function init(el, config, component) {\n        require([component], function (fn) {\n            var $el;\n\n            if (typeof fn === 'object') {\n                fn = fn[component].bind(fn);\n            }\n\n            if (_.isFunction(fn)) {\n                fn = fn.bind(null, config, el);\n            } else {\n                $el = $(el);\n\n                if ($el[component]) {\n                    // eslint-disable-next-line jquery-no-bind-unbind\n                    fn = $el[component].bind($el, config);\n                }\n            }\n            // Init module in separate task to prevent blocking main thread.\n            setTimeout(fn);\n        }, function (error) {\n            if ('console' in window && typeof window.console.error === 'function') {\n                console.error(error);\n            }\n\n            return true;\n        });\n    }\n\n    /**\n     * Parses elements 'data-mage-init' attribute as a valid JSON data.\n     * Note: data-mage-init attribute will be removed.\n     *\n     * @param {HTMLElement} el - Element whose attribute should be parsed.\n     * @returns {Object}\n     */\n    function getData(el) {\n        var data = el.getAttribute(dataAttr);\n\n        el.removeAttribute(dataAttr);\n\n        return {\n            el: el,\n            data: JSON.parse(data)\n        };\n    }\n\n    return {\n        /**\n         * Initializes components assigned to HTML elements via [data-mage-init].\n         *\n         * @example Sample 'data-mage-init' declaration.\n         *      data-mage-init='{\"path/to/component\": {\"foo\": \"bar\"}}'\n         */\n        apply: function (context) {\n            var virtuals = processScripts(!context ? document : context),\n                nodes = document.querySelectorAll(nodeSelector);\n\n            _.toArray(nodes)\n                .map(getData)\n                .concat(virtuals)\n                .forEach(function (itemContainer) {\n                    var element = itemContainer.el;\n\n                    _.each(itemContainer.data, function (obj, key) {\n                            if (obj.mixins) {\n                                require(obj.mixins, function () { //eslint-disable-line max-nested-callbacks\n                                    var i, len;\n\n                                    for (i = 0, len = arguments.length; i < len; i++) {\n                                        $.extend(\n                                            true,\n                                            itemContainer.data[key],\n                                            arguments[i](itemContainer.data[key], element)\n                                        );\n                                    }\n\n                                    delete obj.mixins;\n                                    init.call(null, element, obj, key);\n                                });\n                            } else {\n                                init.call(null, element, obj, key);\n                            }\n\n                        }\n                    );\n\n                });\n        },\n        applyFor: init\n    };\n});\n","mage/apply/scripts.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery'\n], function (_, $) {\n    'use strict';\n\n    var scriptSelector = 'script[type=\"text/x-magento-init\"]',\n        dataAttr = 'data-mage-init',\n        virtuals = [];\n\n    /**\n     * Adds components to the virtual list.\n     *\n     * @param {Object} components\n     */\n    function addVirtual(components) {\n        virtuals.push({\n            el: false,\n            data: components\n        });\n    }\n\n    /**\n     * Merges provided data with a current data\n     * of a elements' \"data-mage-init\" attribute.\n     *\n     * @param {Object} components - Object with components and theirs configuration.\n     * @param {HTMLElement} elem - Element whose data should be modified.\n     */\n    function setData(components, elem) {\n        var data = elem.getAttribute(dataAttr);\n\n        data = data ? JSON.parse(data) : {};\n        _.each(components, function (obj, key) {\n            if (_.has(obj, 'mixins')) {\n                data[key] = data[key] || {};\n                data[key].mixins = data[key].mixins || [];\n                data[key].mixins = data[key].mixins.concat(obj.mixins);\n                delete obj.mixins;\n            }\n        });\n\n        data = $.extend(true, data, components);\n        data = JSON.stringify(data);\n        elem.setAttribute(dataAttr, data);\n    }\n\n    /**\n     * Search for the elements by privded selector and extends theirs data.\n     *\n     * @param {Object} components - Object with components and theirs configuration.\n     * @param {String} selector - Selector for the elements.\n     */\n    function processElems(components, selector) {\n        var elems,\n            iterator;\n\n        if (selector === '*') {\n            addVirtual(components);\n\n            return;\n        }\n\n        elems = document.querySelectorAll(selector);\n        iterator = setData.bind(null, components);\n\n        _.toArray(elems).forEach(iterator);\n    }\n\n    /**\n     * Parses content of a provided script node.\n     * Note: node will be removed from DOM.\n     *\n     * @param {HTMLScriptElement} node - Node to be processed.\n     * @returns {Object}\n     */\n    function getNodeData(node) {\n        var data = node.textContent;\n\n        node.parentNode.removeChild(node);\n\n        return JSON.parse(data);\n    }\n\n    /**\n     * Parses 'script' tags with a custom type attribute and moves it's data\n     * to a 'data-mage-init' attribute of an element found by provided selector.\n     * Note: All found script nodes will be removed from DOM.\n     *\n     * @returns {Array} An array of components not assigned to the specific element.\n     *\n     * @example Sample declaration.\n     *      <script type=\"text/x-magento-init\">\n     *          {\n     *              \"body\": {\n     *                  \"path/to/component\": {\"foo\": \"bar\"}\n     *              }\n     *          }\n     *      </script>\n     *\n     * @example Providing data without selector.\n     *      {\n     *          \"*\": {\n     *              \"path/to/component\": {\"bar\": \"baz\"}\n     *          }\n     *      }\n     */\n    return function () {\n        var nodes = document.querySelectorAll(scriptSelector);\n\n        _.toArray(nodes)\n            .map(getNodeData)\n            .forEach(function (item) {\n                _.each(item, processElems);\n            });\n\n        return virtuals.splice(0, virtuals.length);\n    };\n});\n","mage/gallery/gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'fotorama/fotorama',\n    'underscore',\n    'matchMedia',\n    'mage/template',\n    'text!mage/gallery/gallery.html',\n    'uiClass',\n    'mage/translate'\n], function ($, fotorama, _, mediaCheck, template, galleryTpl, Class, $t) {\n    'use strict';\n\n    /**\n     * Retrieves index if the main item.\n     * @param {Array.<Object>} data - Set of gallery items.\n     */\n    var getMainImageIndex = function (data) {\n            var mainIndex;\n\n            if (_.every(data, function (item) {\n                return _.isObject(item);\n            })\n            ) {\n                mainIndex = _.findIndex(data, function (item) {\n                    return item.isMain;\n                });\n            }\n\n            return mainIndex > 0 ? mainIndex : 0;\n        },\n\n        /**\n         * Helper for parse translate property\n         *\n         * @param {Element} el - el that to parse\n         * @returns {Array} - array of properties.\n         */\n        getTranslate = function (el) {\n            var slideTransform = $(el).attr('style').split(';');\n\n            slideTransform = $.map(slideTransform, function (style) {\n                style = style.trim();\n\n                if (style.startsWith('transform: translate3d')) {\n                    return style.match(/transform: translate3d\\((.+)px,(.+)px,(.+)px\\)/);\n                }\n\n                return false;\n            });\n\n            return slideTransform.filter(Boolean);\n        },\n\n        /**\n         * @param {*} str\n         * @return {*}\n         * @private\n         */\n        _toNumber = function (str) {\n            var type = typeof str;\n\n            if (type === 'string') {\n                return parseInt(str); //eslint-disable-line radix\n            }\n\n            return str;\n        };\n\n    return Class.extend({\n\n        defaults: {\n            settings: {},\n            config: {},\n            startConfig: {}\n        },\n\n        /**\n         * Checks if device has touch interface.\n         * @return {Boolean} The result of searching touch events on device.\n         */\n        isTouchEnabled: (function () {\n            return 'ontouchstart' in document.documentElement;\n        })(),\n\n        /**\n         * Initializes gallery.\n         * @param {Object} config - Gallery configuration.\n         * @param {String} element - String selector of gallery DOM element.\n         */\n        initialize: function (config, element) {\n            var self = this;\n\n            this._super();\n\n            _.bindAll(this,\n                '_focusSwitcher'\n            );\n\n            /*turn off arrows for touch devices*/\n            if (this.isTouchEnabled) {\n                config.options.arrows = false;\n\n                if (config.fullscreen) {\n                    config.fullscreen.arrows = false;\n                }\n            }\n\n            config.options.width = _toNumber(config.options.width);\n            config.options.height = _toNumber(config.options.height);\n            config.options.thumbwidth = _toNumber(config.options.thumbwidth);\n            config.options.thumbheight = _toNumber(config.options.thumbheight);\n\n            config.options.whiteBorders = _toNumber(config.options.whiteBorders);\n\n            config.options.swipe = true;\n            this.config = config;\n\n            this.settings = {\n                $element: $(element),\n                $pageWrapper: $('.page-wrapper'),\n                currentConfig: config,\n                defaultConfig: _.clone(config),\n                fullscreenConfig: _.clone(config.fullscreen),\n                breakpoints: config.breakpoints,\n                activeBreakpoint: {},\n                fotoramaApi: null,\n                isFullscreen: false,\n                api: null,\n                data: _.clone(config.data)\n            };\n            config.options.ratio = config.options.width / config.options.height;\n            config.options.height = null;\n            if (!config.options.whiteBorders) {\n                config.options.height = $(element).height();\n            }\n\n            $.extend(true, this.startConfig, config);\n\n            this.initGallery();\n            this.initApi();\n            this.setupBreakpoints();\n            this.initFullscreenSettings();\n\n            this.settings.$element.on('click', '.fotorama__stage__frame', function () {\n                if (\n                    !$(this).parents('.fotorama__shadows--left, .fotorama__shadows--right').length &&\n                    !$(this).hasClass('fotorama-video-container')\n                ) {\n                    self.openFullScreen();\n                }\n            });\n\n            if (this.isTouchEnabled && this.settings.isFullscreen) {\n                this.settings.$element.on('tap', '.fotorama__stage__frame', function () {\n                    var translate = getTranslate($(this).parents('.fotorama__stage__shaft'));\n\n                    if (translate[1] === '0' && !$(this).hasClass('fotorama-video-container')) {\n                        self.openFullScreen();\n                        self.settings.$pageWrapper.hide();\n                    }\n                });\n            }\n        },\n\n        /**\n         * Open gallery fullscreen\n         */\n        openFullScreen: function () {\n            this.settings.api.fotorama.requestFullScreen();\n            this.settings.$fullscreenIcon.css({\n                opacity: 1,\n                visibility: 'visible',\n                display: 'block'\n            });\n        },\n\n        /**\n         * Gallery fullscreen settings.\n         */\n        initFullscreenSettings: function () {\n            var settings = this.settings,\n                self = this;\n\n            settings.$gallery = this.settings.$element.find('[data-gallery-role=\"gallery\"]');\n            settings.$fullscreenIcon = this.settings.$element.find('[data-gallery-role=\"fotorama__fullscreen-icon\"]');\n            settings.focusableStart = this.settings.$element.find('[data-gallery-role=\"fotorama__focusable-start\"]');\n            settings.focusableEnd = this.settings.$element.find('[data-gallery-role=\"fotorama__focusable-end\"]');\n            settings.closeIcon = this.settings.$element.find('[data-gallery-role=\"fotorama__fullscreen-icon\"]');\n            settings.fullscreenConfig.swipe = true;\n\n            settings.$gallery.on('fotorama:fullscreenenter', function () {\n                settings.closeIcon.show();\n                settings.focusableStart.attr('tabindex', '0');\n                settings.focusableEnd.attr('tabindex', '0');\n                settings.focusableStart.on('focusin', self._focusSwitcher);\n                settings.focusableEnd.on('focusin', self._focusSwitcher);\n                settings.api.updateOptions(settings.defaultConfig.options, true);\n                settings.api.updateOptions(settings.fullscreenConfig, true);\n\n                if (!_.isEqual(settings.activeBreakpoint, {}) && settings.breakpoints) {\n                    settings.api.updateOptions(settings.activeBreakpoint.options, true);\n                }\n                settings.isFullscreen = true;\n            });\n\n            settings.$gallery.on('fotorama:fullscreenexit', function () {\n                settings.closeIcon.hide();\n                settings.focusableStart.attr('tabindex', '-1');\n                settings.focusableEnd.attr('tabindex', '-1');\n                settings.api.updateOptions(settings.defaultConfig.options, true);\n                settings.focusableStart.off('focusin', this._focusSwitcher);\n                settings.focusableEnd.off('focusin', this._focusSwitcher);\n                settings.closeIcon.hide();\n\n                if (!_.isEqual(settings.activeBreakpoint, {}) && settings.breakpoints) {\n                    settings.api.updateOptions(settings.activeBreakpoint.options, true);\n                }\n                settings.isFullscreen = false;\n                settings.$element.data('gallery').updateOptions({\n                    swipe: true\n                });\n            });\n        },\n\n        /**\n         * Switcher focus.\n         */\n        _focusSwitcher: function (e) {\n            var target = $(e.target),\n                settings = this.settings;\n\n            if (target.is(settings.focusableStart)) {\n                this._setFocus('start');\n            } else if (target.is(settings.focusableEnd)) {\n                this._setFocus('end');\n            }\n        },\n\n        /**\n         * Set focus to element.\n         * @param {String} position - can be \"start\" and \"end\"\n         *      positions.\n         *      If position is \"end\" - sets focus to first\n         *      focusable element in modal window scope.\n         *      If position is \"start\" - sets focus to last\n         *      focusable element in modal window scope\n         */\n        _setFocus: function (position) {\n            var settings = this.settings,\n                focusableElements,\n                infelicity;\n\n            if (position === 'end') {\n                settings.$gallery.find(settings.closeIcon).trigger('focus');\n            } else if (position === 'start') {\n                infelicity = 3; //Constant for find last focusable element\n                focusableElements = settings.$gallery.find(':focusable');\n                focusableElements.eq(focusableElements.length - infelicity).trigger('focus');\n            }\n        },\n\n        /**\n         * Initializes gallery with configuration options.\n         */\n        initGallery: function () {\n            var breakpoints = {},\n                settings = this.settings,\n                config = this.config,\n                tpl = template(galleryTpl, {\n                    next: $t('Next'),\n                    previous: $t('Previous')\n                }),\n                mainImageIndex,\n                $element = settings.$element,\n                $fotoramaElement;\n\n            if (settings.breakpoints) {\n                _.each(_.values(settings.breakpoints), function (breakpoint) {\n                    var conditions;\n\n                    _.each(_.pairs(breakpoint.conditions), function (pair) {\n                        conditions = conditions ? conditions + ' and (' + pair[0] + ': ' + pair[1] + ')' :\n                            '(' + pair[0] + ': ' + pair[1] + ')';\n                    });\n                    breakpoints[conditions] = breakpoint.options;\n                });\n                settings.breakpoints = breakpoints;\n            }\n\n            _.extend(config, config.options,\n                {\n                    options: undefined,\n                    click: false,\n                    breakpoints: null\n                }\n            );\n            settings.currentConfig = config;\n\n            $element\n                .css('min-height', settings.$element.height())\n                .append(tpl);\n\n            $fotoramaElement = $element.find('[data-gallery-role=\"gallery\"]');\n\n            $fotoramaElement.fotorama(config);\n            $fotoramaElement.find('.fotorama__stage__frame.fotorama__active')\n                .one('f:load', function () {\n                    $element\n                        .removeClass('_block-content-loading')\n                        .css('min-height', '');\n                });\n            settings.$elementF = $fotoramaElement;\n            settings.fotoramaApi = $fotoramaElement.data('fotorama');\n\n            $.extend(true, config, this.startConfig);\n\n            mainImageIndex = getMainImageIndex(config.data);\n\n            if (mainImageIndex) {\n                this.settings.fotoramaApi.show({\n                    index: mainImageIndex,\n                    time: 0\n                });\n            }\n        },\n\n        /**\n         * Creates breakpoints for gallery.\n         */\n        setupBreakpoints: function () {\n            var pairs,\n                settings = this.settings,\n                config = this.config,\n                startConfig = this.startConfig,\n                isInitialized = {},\n                isTouchEnabled = this.isTouchEnabled;\n\n            if (_.isObject(settings.breakpoints)) {\n                pairs = _.pairs(settings.breakpoints);\n                _.each(pairs, function (pair) {\n                    var mediaQuery = pair[0];\n\n                    isInitialized[mediaQuery] = false;\n                    mediaCheck({\n                        media: mediaQuery,\n\n                        /**\n                         * Is triggered when breakpoint enties.\n                         */\n                        entry: function () {\n                            $.extend(true, config, _.clone(startConfig));\n\n                            settings.api.updateOptions(settings.defaultConfig.options, true);\n\n                            if (settings.isFullscreen) {\n                                settings.api.updateOptions(settings.fullscreenConfig, true);\n                            }\n\n                            if (isTouchEnabled) {\n                                settings.breakpoints[mediaQuery].options.arrows = false;\n\n                                if (settings.breakpoints[mediaQuery].options.fullscreen) {\n                                    settings.breakpoints[mediaQuery].options.fullscreen.arrows = false;\n                                }\n                            }\n\n                            settings.api.updateOptions(settings.breakpoints[mediaQuery].options, true);\n                            $.extend(true, config, settings.breakpoints[mediaQuery]);\n                            settings.activeBreakpoint = settings.breakpoints[mediaQuery];\n\n                            isInitialized[mediaQuery] = true;\n                        },\n\n                        /**\n                         * Is triggered when breakpoint exits.\n                         */\n                        exit: function () {\n                            if (isInitialized[mediaQuery]) {\n                                $.extend(true, config, _.clone(startConfig));\n                                settings.api.updateOptions(settings.defaultConfig.options, true);\n\n                                if (settings.isFullscreen) {\n                                    settings.api.updateOptions(settings.fullscreenConfig, true);\n                                }\n                                settings.activeBreakpoint = {};\n                            } else {\n                                isInitialized[mediaQuery] = true;\n                            }\n                        }\n                    });\n                });\n            }\n        },\n\n        /**\n         * Creates gallery's API.\n         */\n        initApi: function () {\n            var settings = this.settings,\n                config = this.config,\n                api = {\n\n                    /**\n                     * Contains fotorama's API methods.\n                     */\n                    fotorama: settings.fotoramaApi,\n\n                    /**\n                     * Displays the last image on preview.\n                     */\n                    last: function () {\n                        settings.fotoramaApi.show('>>');\n                    },\n\n                    /**\n                     * Displays the first image on preview.\n                     */\n                    first: function () {\n                        settings.fotoramaApi.show('<<');\n                    },\n\n                    /**\n                     * Displays previous element on preview.\n                     */\n                    prev: function () {\n                        settings.fotoramaApi.show('<');\n                    },\n\n                    /**\n                     * Displays next element on preview.\n                     */\n                    next: function () {\n                        settings.fotoramaApi.show('>');\n                    },\n\n                    /**\n                     * Displays image with appropriate count number on preview.\n                     * @param {Number} index - Number of image that should be displayed.\n                     */\n                    seek: function (index) {\n                        if (_.isNumber(index) && index !== 0) {\n\n                            if (index > 0) {\n                                index -= 1;\n                            }\n                            settings.fotoramaApi.show(index);\n                        }\n                    },\n\n                    /**\n                     * Updates gallery with new set of options.\n                     * @param {Object} configuration - Standart gallery configuration object.\n                     * @param {Boolean} isInternal - Is this function called via breakpoints.\n                     */\n                    updateOptions: function (configuration, isInternal) {\n\n                        var $selectable = $('a[href], area[href], input, select, ' +\n                                'textarea, button, iframe, object, embed, *[tabindex], *[contenteditable]')\n                                .not('[tabindex=-1], [disabled], :hidden'),\n                            $focus = $(':focus'),\n                            index;\n\n                        if (_.isObject(configuration)) {\n\n                            //Saves index of focus\n                            $selectable.each(function (number) {\n                                if ($(this).is($focus)) {\n                                    index = number;\n                                }\n                            });\n\n                            if (this.isTouchEnabled) {\n                                configuration.arrows = false;\n                            }\n                            configuration.click = false;\n                            configuration.breakpoints = null;\n\n                            if (!isInternal) {\n                                !_.isEqual(settings.activeBreakpoint, {} && settings.breakpoints) ?\n                                    $.extend(true, settings.activeBreakpoint.options, configuration) :\n\n                                    settings.isFullscreen ?\n                                        $.extend(true, settings.fullscreenConfig, configuration) :\n                                        $.extend(true, settings.defaultConfig.options, configuration);\n\n                            }\n                            $.extend(true, settings.currentConfig.options, configuration);\n                            settings.fotoramaApi.setOptions(settings.currentConfig.options);\n\n                            if (_.isNumber(index)) {\n                                $selectable.eq(index).trigger('focus');\n                            }\n                        }\n                    },\n\n                    /**\n                     * Updates gallery with specific set of items.\n                     * @param {Array.<Object>} data - Set of gallery items to update.\n                     */\n                    updateData: function (data) {\n                        var mainImageIndex;\n\n                        if (_.isArray(data)) {\n                            settings.fotoramaApi.load(data);\n                            mainImageIndex = getMainImageIndex(data);\n\n                            if (settings.fotoramaApi.activeIndex !== mainImageIndex) {\n                                settings.fotoramaApi.show({\n                                    index: mainImageIndex,\n                                    time: 0\n                                });\n                            }\n\n                            $.extend(false, settings, {\n                                data: data,\n                                defaultConfig: data\n                            });\n                            $.extend(false, config, {\n                                data: data\n                            });\n                        }\n                    },\n\n                    /**\n                     * Returns current images list\n                     *\n                     * @returns {Array}\n                     */\n                    returnCurrentImages: function () {\n                        var images = [];\n\n                        _.each(this.fotorama.data, function (item) {\n                            images.push(_.omit(item, '$navThumbFrame', '$navDotFrame', '$stageFrame', 'labelledby'));\n                        });\n\n                        return images;\n                    },\n\n                    /**\n                     * Updates gallery data partially by index\n                     * @param {Number} index - Index of image in data array to be updated.\n                     * @param {Object} item - Standart gallery image object.\n                     *\n                     */\n                    updateDataByIndex: function (index, item) {\n                        settings.fotoramaApi.spliceByIndex(index, item);\n                    }\n                };\n\n            settings.$element.data('gallery', api);\n            settings.api = settings.$element.data('gallery');\n            settings.$element.trigger('gallery:loaded');\n        }\n    });\n});\n","mage/requirejs/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* inspired by http://github.com/requirejs/text */\n/*global XDomainRequest */\n\ndefine(['module'], function (module) {\n    'use strict';\n\n    var xmlRegExp = /^\\s*<\\?xml(\\s)+version=[\\'\\\"](\\d)*.(\\d)*[\\'\\\"](\\s)*\\?>/im,\n        bodyRegExp = /<body[^>]*>\\s*([\\s\\S]+)\\s*<\\/body>/im,\n        stripReg = /!strip$/i,\n        defaultConfig = module.config && module.config() || {};\n\n    /**\n     * Strips <?xml ...?> declarations so that external SVG and XML documents can be\n     * added to a document without worry.\n     * Also, if the string is an HTML document, only the part inside the body tag is returned.\n     *\n     * @param {String} external\n     * @returns {String}\n     */\n    function stripContent(external) {\n        var matches;\n\n        if (!external) {\n            return '';\n        }\n\n        matches = external.match(bodyRegExp);\n        external = matches ?\n            matches[1] :\n            external.replace(xmlRegExp, '');\n\n        return external;\n    }\n\n    /**\n     * Checks that url match current location\n     *\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    function sameDomain(url) {\n        var uProtocol, uHostName, uPort,\n            xdRegExp = /^([\\w:]+)?\\/\\/([^\\/\\\\]+)/i,\n            location = window.location,\n            match = xdRegExp.exec(url);\n\n        if (!match) {\n            return true;\n        }\n        uProtocol = match[1];\n        uHostName = match[2];\n\n        uHostName = uHostName.split(':');\n        uPort = uHostName[1] || '';\n        uHostName = uHostName[0];\n\n        return (!uProtocol || uProtocol === location.protocol) &&\n            (!uHostName || uHostName.toLowerCase() === location.hostname.toLowerCase()) &&\n            (!uPort && !uHostName || uPort === location.port);\n    }\n\n    /**\n     * @returns {XMLHttpRequest|XDomainRequest|null}\n     */\n    function createRequest(url) {\n        var xhr = new XMLHttpRequest();\n\n        if (!sameDomain(url) && typeof XDomainRequest !== 'undefined') {\n            xhr = new XDomainRequest();\n        }\n\n        return xhr;\n    }\n\n    /**\n     * XHR requester. Returns value to callback.\n     *\n     * @param {String} url\n     * @param {Function} callback\n     * @param {Function} fail\n     * @param {Object} headers\n     */\n    function getContent(url, callback, fail, headers) {\n        var xhr = createRequest(url),\n            header;\n\n        xhr.open('GET', url);\n\n        /*eslint-disable max-depth */\n        if ('setRequestHeader' in xhr && headers) {\n            for (header in headers) {\n                if (headers.hasOwnProperty(header)) {\n                    xhr.setRequestHeader(header.toLowerCase(), headers[header]);\n                }\n            }\n        }\n\n        /**\n         * @inheritdoc\n         */\n        xhr.onreadystatechange = function () {\n            var status, err;\n\n            //Do not explicitly handle errors, those should be\n            //visible via console output in the browser.\n            if (xhr.readyState === 4) {\n                status = xhr.status || 0;\n\n                if (status > 399 && status < 600) {\n                    //An http 4xx or 5xx error. Signal an error.\n                    err = new Error(url + ' HTTP status: ' + status);\n                    err.xhr = xhr;\n\n                    if (fail) {\n                        fail(err);\n                    }\n                } else {\n                    callback(xhr.responseText);\n\n                    if (defaultConfig.onXhrComplete) {\n                        defaultConfig.onXhrComplete(xhr, url);\n                    }\n                }\n            }\n        };\n\n        /*eslint-enable max-depth */\n\n        if (defaultConfig.onXhr) {\n            defaultConfig.onXhr(xhr, url);\n        }\n\n        xhr.send();\n    }\n\n    /**\n     * Main method used by RequireJs.\n     *\n     * @param {String} name - has format: some.module.filext!strip\n     * @param {Function} req\n     * @param {Function|undefined} onLoad\n     */\n    function loadContent(name, req, onLoad) {\n\n        var toStrip = stripReg.test(name),\n            url = req.toUrl(name.replace(stripReg, '')),\n            headers = defaultConfig.headers;\n\n        getContent(url, function (content) {\n                content = toStrip ? stripContent(content) : content;\n                onLoad(content);\n            }, onLoad.error, headers);\n    }\n\n    return {\n        load: loadContent,\n        get: getContent\n    };\n});\n","mage/requirejs/resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'domReady!'\n], function (_) {\n    'use strict';\n\n    var context = require.s.contexts._,\n        execCb = context.execCb,\n        registry = context.registry,\n        callbacks = [],\n        retries = 10,\n        updateDelay = 1,\n        ready,\n        update;\n\n    /**\n     * Checks if provided callback already exists in the callbacks list.\n     *\n     * @param {Object} callback - Callback object to be checked.\n     * @returns {Boolean}\n     */\n    function isSubscribed(callback) {\n        return !!_.findWhere(callbacks, callback);\n    }\n\n    /**\n     * Checks if provided module is rejected during load.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isRejected(module) {\n        return registry[module.id] && (registry[module.id].inited || registry[module.id].error);\n    }\n\n    /**\n     * Checks if provided module had path fallback triggered.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isPathFallback(module) {\n        return registry[module.id] && registry[module.id].events.error;\n    }\n\n    /**\n     * Checks if provided module has unresolved dependencies.\n     *\n     * @param {Object} module - Module to be checked.\n     * @returns {Boolean}\n     */\n    function isPending(module) {\n        if (!module.depCount) {\n            return false;\n        }\n\n        return module.depCount >\n            _.filter(module.depMaps, isRejected).length + _.filter(module.depMaps, isPathFallback).length;\n    }\n\n    /**\n     * Checks if requirejs's registry object contains pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function hasPending() {\n        return _.some(registry, isPending);\n    }\n\n    /**\n     * Checks if 'resolver' module is in ready\n     * state and that there are no pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function isReady() {\n        return ready && !hasPending();\n    }\n\n    /**\n     * Invokes provided callback handler.\n     *\n     * @param {Object} callback\n     */\n    function invoke(callback) {\n        callback.handler.call(callback.ctx);\n    }\n\n    /**\n     * Sets 'resolver' module to a ready state\n     * and invokes pending callbacks.\n     */\n    function resolve() {\n        ready = true;\n\n        callbacks.splice(0).forEach(invoke);\n    }\n\n    /**\n     * Drops 'ready' flag and runs the update process.\n     */\n    function tick() {\n        ready = false;\n\n        update(retries);\n    }\n\n    /**\n     * Adds callback which will be invoked\n     * when all of the pending modules are initiated.\n     *\n     * @param {Function} handler - 'Ready' event handler function.\n     * @param {Object} [ctx] - Optional context with which handler\n     *      will be invoked.\n     */\n    function subscribe(handler, ctx) {\n        var callback = {\n            handler: handler,\n            ctx: ctx\n        };\n\n        if (!isSubscribed(callback)) {\n            callbacks.push(callback);\n\n            if (isReady()) {\n                _.defer(tick);\n            }\n        }\n    }\n\n    /**\n     * Checks for all modules to be initiated\n     * and invokes pending callbacks if it's so.\n     *\n     * @param {Number} [retry] - Number of retries\n     *      that will be used to repeat the 'update' function\n     *      invokation in case if there are no pending requests.\n     */\n    update = _.debounce(function (retry) {\n        if (!hasPending()) {\n            retry ? update(--retry) : resolve();\n        }\n    }, updateDelay);\n\n    /**\n     * Overrides requirejs's original 'execCb' method\n     * in order to track pending modules.\n     *\n     * @returns {*} Result of original method call.\n     */\n    context.execCb = function () {\n        var exported = execCb.apply(context, arguments);\n\n        tick();\n\n        return exported;\n    };\n\n    return subscribe;\n});\n","mage/requirejs/baseUrlResolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Sample configuration:\n *\n require.config({\n        \"config\": {\n            \"baseUrlInterceptor\": {\n                \"Magento_Ui/js/lib/knockout/bindings/collapsible.js\": \"../../../../frontend/Magento/luma/en_US/\"\n            }\n        }\n    });\n */\n\n/* global jsSuffixRegExp */\n/* eslint-disable max-depth */\ndefine('baseUrlInterceptor', [\n    'module'\n], function (module) {\n    'use strict';\n\n    /**\n     * RequireJS Context object\n     */\n    var ctx = require.s.contexts._,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        origNameToUrl = ctx.nameToUrl,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        newContextConstr = require.s.newContext;\n\n    /**\n     * Remove dots from URL\n     *\n     * @param {Array} ary\n     */\n    function trimDots(ary) {\n        var i, part, length = ary.length;\n\n        for (i = 0; i < length; i++) {\n            part = ary[i];\n\n            if (part === '.') {\n                ary.splice(i, 1);\n                i -= 1;\n            } else if (part === '..') {\n                if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {\n                    //End of the line. Keep at least one non-dot\n                    //path segment at the front so it can be mapped\n                    //correctly to disk. Otherwise, there is likely\n                    //no path mapping for a path starting with '..'.\n                    //This can still fail, but catches the most reasonable\n                    //uses of ..\n                    break;\n                } else if (i > 0) {\n                    ary.splice(i - 1, 2);\n                    i -= 2;\n                }\n            }\n        }\n    }\n\n    /**\n     * Normalize URL string (remove '/../')\n     *\n     * @param {String} name\n     * @param {String} baseName\n     * @param {Object} applyMap\n     * @param {Object} localContext\n     * @returns {*}\n     */\n    function normalize(name, baseName, applyMap, localContext) {\n        var lastIndex,\n            baseParts = baseName && baseName.split('/'),\n            normalizedBaseParts = baseParts;\n\n        //Adjust any relative paths.\n        if (name && name.charAt(0) === '.') {\n            //If have a base name, try to normalize against it,\n            //otherwise, assume it is a top-level require that will\n            //be relative to baseUrl in the end.\n            if (baseName) {\n                //Convert baseName to array, and lop off the last part,\n                //so that . matches that 'directory' and not name of the baseName's\n                //module. For instance, baseName of 'one/two/three', maps to\n                //'one/two/three.js', but we want the directory, 'one/two' for\n                //this normalization.\n                normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);\n                name = name.split('/');\n                lastIndex = name.length - 1;\n\n                // If wanting node ID compatibility, strip .js from end\n                // of IDs. Have to do this here, and not in nameToUrl\n                // because node allows either .js or non .js to map\n                // to same file.\n                if (localContext.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {\n                    name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');\n                }\n\n                name = normalizedBaseParts.concat(name);\n                trimDots(name);\n                name = name.join('/');\n            } else if (name.indexOf('./') === 0) {\n                // No baseName, so this is ID is resolved relative\n                // to baseUrl, pull off the leading dot.\n                name = name.substring(2);\n            }\n        }\n\n        return name;\n    }\n\n    /**\n     * Get full url.\n     *\n     * @param {Object} context\n     * @param {String} url\n     * @return {String}\n     */\n    function getUrl(context, url) {\n        var baseUrl = context.config.baseUrl,\n            newConfig = context.config,\n            modulePath = url.replace(baseUrl, ''),\n            newBaseUrl,\n            rewrite = module.config()[modulePath];\n\n        if (!rewrite) {\n            return url;\n        }\n\n        newBaseUrl = normalize(rewrite, baseUrl, undefined, newConfig);\n\n        return newBaseUrl + modulePath;\n    }\n\n    /**\n     * Replace original function.\n     *\n     * @returns {*}\n     */\n    ctx.nameToUrl = function () {\n        return getUrl(ctx, origNameToUrl.apply(ctx, arguments));\n    };\n\n    /**\n     * Replace original function.\n     *\n     * @return {*}\n     */\n    require.s.newContext = function () {\n        var newCtx = newContextConstr.apply(require.s, arguments),\n            newOrigNameToUrl = newCtx.nameToUrl;\n\n        /**\n         * New implementation of native function.\n         *\n         * @returns {String}\n         */\n        newCtx.nameToUrl = function () {\n            return getUrl(newCtx, newOrigNameToUrl.apply(newCtx, arguments));\n        };\n\n        return newCtx;\n    };\n});\n\nrequire(['baseUrlInterceptor'], function () {\n    'use strict';\n\n});\n","mage/msie/file-reader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Init \"readAsBinaryString\" function for FileReader class.\n     * It need for IE11\n     * @param {Blob} fileData\n     */\n    var readAsBinaryStringIEFunc = function (fileData) {\n        var binary = '',\n            self = this,\n            reader = new FileReader();\n\n        /**\n         * Read file as binary string\n         */\n        reader.onload = function () {\n            var bytes, length, index;\n\n            /* eslint-disable no-undef */\n            bytes = new Uint8Array(reader.result);\n            /* eslint-enable */\n            length = bytes.length;\n\n            for (index = 0; index < length; index++) {\n                binary += String.fromCharCode(bytes[index]);\n            }\n            //self.result  - readonly so assign binary\n            self.content = binary;\n            $(self).trigger('onload');\n        };\n        reader.readAsArrayBuffer(fileData);\n    };\n\n    if (typeof FileReader.prototype.readAsBinaryString === 'undefined') {\n        FileReader.prototype.readAsBinaryString = readAsBinaryStringIEFunc;\n    }\n});\n","mage/utils/wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Utility methods used to wrap and extend functions.\n *\n * @example Usage of a 'wrap' method with arguments delegation.\n *      var multiply = function (a, b) {\n *          return a * b;\n *      };\n *\n *      multiply = module.wrap(multiply, function (orig) {\n *          return 'Result is: ' + orig();\n *      });\n *\n *      multiply(2, 2);\n *      => 'Result is: 4'\n *\n * @example Usage of 'wrapSuper' method.\n *      var multiply = function (a, b) {\n *         return a * b;\n *      };\n *\n *      var obj = {\n *          multiply: module.wrapSuper(multiply, function () {\n *              return 'Result is: ' + this._super();\n *          });\n *      };\n *\n *      obj.multiply(2, 2);\n *      => 'Result is: 4'\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Checks if string has a '_super' substring.\n     */\n    var superReg = /\\b_super\\b/;\n\n    return {\n\n        /**\n         * Wraps target function with a specified wrapper, which will receive\n         * reference to the original function as a first argument.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapper function.\n         */\n        wrap: function (target, wrapper) {\n            if (!_.isFunction(target) || !_.isFunction(wrapper)) {\n                return wrapper;\n            }\n\n            return function () {\n                var args    = _.toArray(arguments),\n                    ctx     = this,\n                    _super;\n\n                /**\n                 * Function that will be passed to the wrapper.\n                 * If no arguments will be passed to it, then the original\n                 * function will be called with an arguments of a wrapper function.\n                 */\n                _super = function () {\n                    var superArgs = arguments.length ? arguments : args.slice(1);\n\n                    return target.apply(ctx, superArgs);\n                };\n\n                args.unshift(_super);\n\n                return wrapper.apply(ctx, args);\n            };\n        },\n\n        /**\n         * Wraps the incoming function to implement support of the '_super' method.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapped function.\n         */\n        wrapSuper: function (target, wrapper) {\n            if (!this.hasSuper(wrapper) || !_.isFunction(target)) {\n                return wrapper;\n            }\n\n            return function () {\n                var _super  = this._super,\n                    args    = arguments,\n                    result;\n\n                /**\n                 * Temporary define '_super' method which\n                 * contains call to the original function.\n                 */\n                this._super = function () {\n                    var superArgs = arguments.length ? arguments : args;\n\n                    return target.apply(this, superArgs);\n                };\n\n                result = wrapper.apply(this, args);\n\n                this._super = _super;\n\n                return result;\n            };\n        },\n\n        /**\n         * Checks wether the incoming method contains calls of the '_super' method.\n         *\n         * @param {Function} fn - Function to be checked.\n         * @returns {Boolean}\n         */\n        hasSuper: function (fn) {\n            return _.isFunction(fn) && superReg.test(fn);\n        },\n\n        /**\n         * Extends target object with provided extenders.\n         * If property in target and extender objects is a function,\n         * then it will be wrapped using 'wrap' method.\n         *\n         * @param {Object} target - Object to be extended.\n         * @param {...Object} extenders - Multiple extenders objects.\n         * @returns {Object} Modified target object.\n         */\n        extend: function (target) {\n            var extenders = _.toArray(arguments).slice(1),\n                iterator = this._extend.bind(this, target);\n\n            extenders.forEach(iterator);\n\n            return target;\n        },\n\n        /**\n         * Same as the 'extend' method, but operates only on one extender object.\n         *\n         * @private\n         * @param {Object} target\n         * @param {Object} extender\n         */\n        _extend: function (target, extender) {\n            _.each(extender, function (value, key) {\n                target[key] = this.wrap(target[key], extender[key]);\n            }, this);\n        }\n    };\n});\n","mage/utils/misc.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mage/utils/objects'\n], function (_, $, utils) {\n    'use strict';\n\n    var defaultAttributes,\n        ajaxSettings,\n        map;\n\n    defaultAttributes = {\n        method: 'post',\n        enctype: 'multipart/form-data'\n    };\n\n    ajaxSettings = {\n        default: {\n            method: 'POST',\n            cache: false,\n            processData: false,\n            contentType: false\n        },\n        simple: {\n            method: 'POST',\n            dataType: 'json'\n        }\n    };\n\n    map = {\n        'D': 'DDD',\n        'dd': 'DD',\n        'd': 'D',\n        'EEEE': 'dddd',\n        'EEE': 'ddd',\n        'e': 'd',\n        'yyyy': 'YYYY',\n        'yy': 'YY',\n        'y': 'YYYY',\n        'a': 'A'\n    };\n\n    return {\n\n        /**\n         * Generates a unique identifier.\n         *\n         * @param {Number} [size=7] - Length of a resulting identifier.\n         * @returns {String}\n         */\n        uniqueid: function (size) {\n            var code = Math.random() * 25 + 65 | 0,\n                idstr = String.fromCharCode(code);\n\n            size = size || 7;\n\n            while (idstr.length < size) {\n                code = Math.floor(Math.random() * 42 + 48);\n\n                if (code < 58 || code > 64) {\n                    idstr += String.fromCharCode(code);\n                }\n            }\n\n            return idstr;\n        },\n\n        /**\n         * Limits function call.\n         *\n         * @param {Object} owner\n         * @param {String} target\n         * @param {Number} limit\n         */\n        limit: function (owner, target, limit) {\n            var fn = owner[target];\n\n            owner[target] = _.debounce(fn.bind(owner), limit);\n        },\n\n        /**\n         * Converts mage date format to a moment.js format.\n         *\n         * @param {String} mageFormat\n         * @returns {String}\n         */\n        normalizeDate: function (mageFormat) {\n            var result = mageFormat;\n\n            _.each(map, function (moment, mage) {\n                result = result.replace(\n                    new RegExp(mage + '(?=([^\\u0027]*\\u0027[^\\u0027]*\\u0027)*[^\\u0027]*$)'),\n                    moment\n                );\n            });\n            result = result.replace(/'(.*?)'/g, '[$1]');\n            return result;\n        },\n\n        /**\n         * Puts provided value in range of min and max parameters.\n         *\n         * @param {Number} value - Value to be located.\n         * @param {Number} min - Min value.\n         * @param {Number} max - Max value.\n         * @returns {Number}\n         */\n        inRange: function (value, min, max) {\n            return Math.min(Math.max(min, value), max);\n        },\n\n        /**\n         * Serializes and sends data via POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} attrs - Attributes that will be added to virtual form.\n         */\n        submit: function (options, attrs) {\n            var form        = document.createElement('form'),\n                data        = utils.serialize(options.data),\n                attributes  = _.extend({}, defaultAttributes, attrs || {});\n\n            if (!attributes.action) {\n                attributes.action = options.url;\n            }\n\n            data['form_key'] = window.FORM_KEY;\n\n            _.each(attributes, function (value, name) {\n                form.setAttribute(name, value);\n            });\n\n            data = _.map(\n                data,\n                function (value, name) {\n                    return '<input type=\"hidden\" ' +\n                        'name=\"' + _.escape(name) + '\" ' +\n                        'value=\"' + _.escape(value) + '\"' +\n                        ' />';\n                }\n            ).join('');\n\n            form.insertAdjacentHTML('afterbegin', data);\n            document.body.appendChild(form);\n\n            form.submit();\n        },\n\n        /**\n         * Serializes and sends data via AJAX POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} config\n         */\n        ajaxSubmit: function (options, config) {\n            var t = new Date().getTime(),\n                settings;\n\n            options.data['form_key'] = window.FORM_KEY;\n            options.data = this.prepareFormData(options.data, config.ajaxSaveType);\n            settings = _.extend({}, ajaxSettings[config.ajaxSaveType], options || {});\n\n            if (!config.ignoreProcessEvents) {\n                $('body').trigger('processStart');\n            }\n\n            return $.ajax(settings)\n                .done(function (data) {\n                    if (config.response) {\n                        data.t = t;\n                        config.response.data(data);\n                        config.response.status(undefined);\n                        config.response.status(!data.error);\n                    }\n                })\n                .fail(function () {\n                    if (config.response) {\n                        config.response.status(undefined);\n                        config.response.status(false);\n                        config.response.data({\n                            error: true,\n                            messages: 'Something went wrong.',\n                            t: t\n                        });\n                    }\n                })\n                .always(function () {\n                    if (!config.ignoreProcessEvents) {\n                        $('body').trigger('processStop');\n                    }\n                });\n        },\n\n        /**\n         * Creates FormData object and append this data.\n         *\n         * @param {Object} data\n         * @param {String} type\n         * @returns {FormData}\n         */\n        prepareFormData: function (data, type) {\n            var formData;\n\n            if (type === 'default') {\n                formData = new FormData();\n                _.each(utils.serialize(data), function (val, name) {\n                    formData.append(name, val);\n                });\n            } else if (type === 'simple') {\n                formData = utils.serialize(data);\n            }\n\n            return formData;\n        },\n\n        /**\n         * Filters data object. Finds properties with suffix\n         * and sets their values to properties with the same name without suffix.\n         *\n         * @param {Object} data - The data object that should be filtered\n         * @param {String} suffix - The string by which data object should be filtered\n         * @param {String} separator - The string that is separator between property and suffix\n         *\n         * @returns {Object} Filtered data object\n         */\n        filterFormData: function (data, suffix, separator) {\n            data = data || {};\n            suffix = suffix || 'prepared-for-send';\n            separator = separator || '-';\n\n            _.each(data, function (value, key) {\n                if (_.isObject(value) && !Array.isArray(value)) {\n                    this.filterFormData(value, suffix, separator);\n                } else if (_.isString(key) && ~key.indexOf(suffix)) {\n                    data[key.split(separator)[0]] = value;\n                    delete data[key];\n                }\n            }, this);\n\n            return data;\n        },\n\n        /**\n         * Replaces special characters with their corresponding HTML entities.\n         *\n         * @param {String} string - Text to escape.\n         * @returns {String} Escaped text.\n         */\n        escape: function (string) {\n            return string ? $('<p></p>').text(string).html().replace(/\"/g, '&quot;') : string;\n        },\n\n        /**\n         * Replaces symbol codes with their unescaped counterparts.\n         *\n         * @param {String} data\n         *\n         * @returns {String}\n         */\n        unescape: function (data) {\n            var unescaped = _.unescape(data),\n                mapCharacters = {\n                    '&#039;': '\\''\n                };\n\n            _.each(mapCharacters, function (value, key) {\n                unescaped = unescaped.replace(key, value);\n            });\n\n            return unescaped;\n        },\n\n        /**\n         * Converts PHP IntlFormatter format to moment format.\n         *\n         * @param {String} format - PHP format\n         * @returns {String} - moment compatible formatting\n         */\n        convertToMomentFormat: function (format) {\n            var newFormat;\n\n            newFormat = format.replace(/yyyy|yy|y/, 'YYYY'); // replace the year\n            newFormat = newFormat.replace(/dd|d/g, 'DD'); // replace the date\n\n            return newFormat;\n        },\n\n        /**\n         * Get Url Parameters.\n         *\n         * @param {String} url - Url string\n         * @returns {Object}\n         */\n        getUrlParameters: function (url) {\n            var params = {},\n                queries = url.split('?'),\n                temp,\n                i,\n                l;\n\n            if (!queries[1]) {\n                return params;\n            }\n\n            queries = queries[1].split('&');\n\n            for (i = 0, l = queries.length; i < l; i++) {\n                temp = queries[i].split('=');\n\n                if (temp[1]) {\n                    params[temp[0]] = decodeURIComponent(temp[1].replace(/\\+/g, '%20'));\n                } else {\n                    params[temp[0]] = '';\n                }\n            }\n\n            return params;\n        }\n    };\n});\n","mage/utils/arrays.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './strings'\n], function (_, utils) {\n    'use strict';\n\n    /**\n     * Defines index of an item in a specified container.\n     *\n     * @param {*} item - Item whose index should be defined.\n     * @param {Array} container - Container upon which to perform search.\n     * @returns {Number}\n     */\n    function getIndex(item, container) {\n        var index = container.indexOf(item);\n\n        if (~index) {\n            return index;\n        }\n\n        return _.findIndex(container, function (value) {\n            return value && value.name === item;\n        });\n    }\n\n    return {\n        /**\n         * Facade method to remove/add value from/to array\n         * without creating a new instance.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to add/remove.\n         * @param {Boolean} add - Flag that specfies operation.\n         * @returns {Utils} Chainable.\n         */\n        toggle: function (arr, value, add) {\n            return add ?\n                this.add(arr, value) :\n                this.remove(arr, value);\n        },\n\n        /**\n         * Removes the incoming value from array in case\n         * without creating a new instance of it.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to be removed.\n         * @returns {Utils} Chainable.\n         */\n        remove: function (arr, value) {\n            var index = arr.indexOf(value);\n\n            if (~index) {\n                arr.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds the incoming value to array if\n         * it's not alredy present in there.\n         *\n         * @param {Array} arr - Array to be modifed.\n         * @param {...*} arguments - Values to be added.\n         * @returns {Utils} Chainable.\n         */\n        add: function (arr) {\n            var values = _.toArray(arguments).slice(1);\n\n            values.forEach(function (value) {\n                if (!~arr.indexOf(value)) {\n                    arr.push(value);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Inserts specified item into container at a specified position.\n         *\n         * @param {*} item - Item to be inserted into container.\n         * @param {Array} container - Container of items.\n         * @param {*} [position=-1] - Position at which item should be inserted.\n         *      Position can represent:\n         *          - specific index in container\n         *          - item which might already be present in container\n         *          - structure with one of these properties: after, before\n         * @returns {Boolean|*}\n         *      - true if element has changed its' position\n         *      - false if nothing has changed\n         *      - inserted value if it wasn't present in container\n         */\n        insert: function (item, container, position) {\n            var currentIndex = getIndex(item, container),\n                newIndex,\n                target;\n\n            if (typeof position === 'undefined') {\n                position = -1;\n            } else if (typeof position === 'string') {\n                position = isNaN(+position) ? position : +position;\n            }\n\n            newIndex = position;\n\n            if (~currentIndex) {\n                target = container.splice(currentIndex, 1)[0];\n\n                if (typeof item === 'string') {\n                    item = target;\n                }\n            }\n\n            if (typeof position !== 'number') {\n                target = position.after || position.before || position;\n\n                newIndex = getIndex(target, container);\n\n                if (~newIndex && (position.after || newIndex >= currentIndex)) {\n                    newIndex++;\n                }\n            }\n\n            if (newIndex < 0) {\n                newIndex += container.length + 1;\n            }\n\n            container[newIndex] ?\n                container.splice(newIndex, 0, item) :\n                container[newIndex] = item;\n\n            return !~currentIndex ? item : currentIndex !== newIndex;\n        },\n\n        /**\n         * @param {Array} elems\n         * @param {Number} offset\n         * @return {Number|*}\n         */\n        formatOffset: function (elems, offset) {\n            if (utils.isEmpty(offset)) {\n                offset = -1;\n            }\n\n            offset = +offset;\n\n            if (offset < 0) {\n                offset += elems.length + 1;\n            }\n\n            return offset;\n        }\n    };\n});\n","mage/utils/main.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function (require) {\n    'use strict';\n\n    var utils = {},\n        _ = require('underscore'),\n        root = typeof self == 'object' && self.self === self && self ||\n            typeof global == 'object' && global.global === global && global ||\n            Function('return this')() || {};\n\n    root._ = _;\n\n    return _.extend(\n        utils,\n        require('./arrays'),\n        require('./compare'),\n        require('./misc'),\n        require('./objects'),\n        require('./strings'),\n        require('./template')\n    );\n});\n","mage/utils/objects.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'mage/utils/strings'\n], function (ko, $, _, stringUtils) {\n    'use strict';\n\n    var primitives = [\n        'undefined',\n        'boolean',\n        'number',\n        'string'\n    ];\n\n    /**\n     * Sets nested property of a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @param {*} value - Value of the last property in 'path' array.\n     * returns {*} New value for the property.\n     */\n    function setNested(parent, path, value) {\n        var last = path.pop(),\n            len = path.length,\n            pi = 0,\n            part = path[pi];\n\n        for (; pi < len; part = path[++pi]) {\n            if (!_.isObject(parent[part])) {\n                parent[part] = {};\n            }\n\n            parent = parent[part];\n        }\n\n        if (typeof parent[last] === 'function') {\n            parent[last](value);\n        } else {\n            parent[last] = value;\n        }\n\n        return value;\n    }\n\n    /**\n     * Retrieves value of a nested property.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @returns {*} Value of the property.\n     */\n    function getNested(parent, path) {\n        var exists = true,\n            len = path.length,\n            pi = 0;\n\n        for (; pi < len && exists; pi++) {\n            parent = parent[path[pi]];\n\n            if (typeof parent === 'undefined') {\n                exists = false;\n            }\n        }\n\n        if (exists) {\n            if (ko.isObservable(parent)) {\n                parent = parent();\n            }\n\n            return parent;\n        }\n    }\n\n    /**\n     * Removes property from a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object from which to remove property.\n     * @param {Array} path - Splitted path to the property.\n     */\n    function removeNested(parent, path) {\n        var field = path.pop();\n\n        parent = getNested(parent, path);\n\n        if (_.isObject(parent)) {\n            delete parent[field];\n        }\n    }\n\n    return {\n\n        /**\n         * Retrieves or defines objects' property by a composite path.\n         *\n         * @param {Object} data - Container for the properties specified in path.\n         * @param {String} path - Objects' properties divided by dots.\n         * @param {*} [value] - New value for the last property.\n         * @returns {*} Returns value of the last property in chain.\n         *\n         * @example\n         *      utils.nested({}, 'one.two', 3);\n         *      => { one: {two: 3} }\n         */\n        nested: function (data, path, value) {\n            var action = arguments.length > 2 ? setNested : getNested;\n\n            path = path ? path.split('.') : [];\n\n            return action(data, path, value);\n        },\n\n        /**\n         * Removes nested property from an object.\n         *\n         * @param {Object} data - Data source.\n         * @param {String} path - Path to the property e.g. 'one.two.three'\n         */\n        nestedRemove: function (data, path) {\n            path = path.split('.');\n\n            removeNested(data, path);\n        },\n\n        /**\n         * Flattens objects' nested properties.\n         *\n         * @param {Object} data - Object to flatten.\n         * @param {String} [separator='.'] - Objects' keys separator.\n         * @returns {Object} Flattened object.\n         *\n         * @example Example with a default separator.\n         *      utils.flatten({one: { two: { three: 'value'} }});\n         *      => { 'one.two.three': 'value' };\n         *\n         * @example Example with a custom separator.\n         *      utils.flatten({one: { two: { three: 'value'} }}, '=>');\n         *      => {'one=>two=>three': 'value'};\n         */\n        flatten: function (data, separator, parent, result) {\n            separator = separator || '.';\n            result = result || {};\n\n            if (!data) {\n                return result;\n            }\n\n            // UnderscoreJS each breaks when an object has a length property so we use Object.keys\n            _.each(Object.keys(data), function (name) {\n                var node = data[name];\n\n                if ({}.toString.call(node) === '[object Function]') {\n                    return;\n                }\n\n                if (parent) {\n                    name = parent + separator + name;\n                }\n\n                typeof node === 'object' ?\n                    this.flatten(node, separator, name, result) :\n                    result[name] = node;\n\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Opposite operation of the 'flatten' method.\n         *\n         * @param {Object} data - Previously flattened object.\n         * @param {String} [separator='.'] - Keys separator.\n         * @returns {Object} Object with nested properties.\n         *\n         * @example Example using custom separator.\n         *      utils.unflatten({'one=>two': 'value'}, '=>');\n         *      => {\n         *          one: { two: 'value' }\n         *      };\n         */\n        unflatten: function (data, separator) {\n            var result = {};\n\n            separator = separator || '.';\n\n            _.each(data, function (value, nodes) {\n                nodes = nodes.split(separator);\n\n                setNested(result, nodes, value);\n            });\n\n            return result;\n        },\n\n        /**\n         * Same operation as 'flatten' method,\n         * but returns objects' keys wrapped in '[]'.\n         *\n         * @param {Object} data - Object that should be serialized.\n         * @returns {Object} Serialized data.\n         *\n         * @example\n         *      utils.serialize({one: { two: { three: 'value'} }});\n         *      => { 'one[two][three]': 'value' }\n         */\n        serialize: function (data) {\n            var result = {};\n\n            data = this.flatten(data);\n\n            _.each(data, function (value, keys) {\n                keys = stringUtils.serializeName(keys);\n                value = _.isUndefined(value) ? '' : value;\n\n                result[keys] = value;\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Performs deep extend of specified objects.\n         *\n         * @returns {Object|Array} Extended object.\n         */\n        extend: function () {\n            var args = _.toArray(arguments);\n\n            args.unshift(true);\n\n            return $.extend.apply($, args);\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         *\n         * @param {(Object|Array)} data - Data that should be copied.\n         * @returns {Object|Array} Cloned object.\n         */\n        copy: function (data) {\n            var result = data,\n                isArray = Array.isArray(data),\n                placeholder;\n\n            if (this.isObject(data) || isArray) {\n                placeholder = isArray ? [] : {};\n                result = this.extend(placeholder, data);\n            }\n\n            return result;\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         * Doesn't save links to original object.\n         *\n         * @param {*} original - Object to clone\n         * @returns {*}\n         */\n        hardCopy: function (original) {\n            if (original === null || typeof original !== 'object') {\n                return original;\n            }\n\n            return JSON.parse(JSON.stringify(original));\n        },\n\n        /**\n         * Removes specified nested properties from the target object.\n         *\n         * @param {Object} target - Object whose properties should be removed.\n         * @param {(...String|Array|Object)} list - List that specifies properties to be removed.\n         * @returns {Object} Modified object.\n         *\n         * @example Basic usage\n         *      var obj = {a: {b: 2}, c: 'a'};\n         *\n         *      omit(obj, 'a.b');\n         *      => {'a.b': 2};\n         *      obj => {a: {}, c: 'a'};\n         *\n         * @example Various syntaxes that would return same result\n         *      omit(obj, ['a.b', 'c']);\n         *      omit(obj, 'a.b', 'c');\n         *      omit(obj, {'a.b': true, 'c': true});\n         */\n        omit: function (target, list) {\n            var removed = {},\n                ignored = list;\n\n            if (this.isObject(list)) {\n                ignored = [];\n\n                _.each(list, function (value, key) {\n                    if (value) {\n                        ignored.push(key);\n                    }\n                });\n            } else if (_.isString(list)) {\n                ignored = _.toArray(arguments).slice(1);\n            }\n\n            _.each(ignored, function (path) {\n                var value = this.nested(target, path);\n\n                if (!_.isUndefined(value)) {\n                    removed[path] = value;\n\n                    this.nestedRemove(target, path);\n                }\n            }, this);\n\n            return removed;\n        },\n\n        /**\n         * Checks if provided value is a plain object.\n         *\n         * @param {*} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isObject: function (value) {\n            var objProto = Object.prototype;\n\n            return typeof value == 'object' ?\n            objProto.toString.call(value) === '[object Object]' :\n                false;\n        },\n\n        /**\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isPrimitive: function (value) {\n            return value === null || ~primitives.indexOf(typeof value);\n        },\n\n        /**\n         * Iterates over obj props/array elems recursively, applying action to each one\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to be called with each item as an argument.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         */\n        forEachRecursive: function (data, action, maxDepth) {\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return;\n            }\n\n            if (!_.isObject(data)) {\n                action(data);\n\n                return;\n            }\n\n            _.each(data, function (value) {\n                this.forEachRecursive(value, action, maxDepth);\n            }, this);\n\n            action(data);\n        },\n\n        /**\n         * Maps obj props/array elems recursively\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to transform each item.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         *\n         * @returns {Object|Array}\n         */\n        mapRecursive: function (data, action, maxDepth) {\n            var newData;\n\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return data;\n            }\n\n            if (!_.isObject(data)) {\n                return action(data);\n            }\n\n            if (_.isArray(data)) {\n                newData = _.map(data, function (item) {\n                    return this.mapRecursive(item, action, maxDepth);\n                }, this);\n\n                return action(newData);\n            }\n\n            newData = _.mapObject(data, function (val, key) {\n                if (data.hasOwnProperty(key)) {\n                    return this.mapRecursive(val, action, maxDepth);\n                }\n\n                return val;\n            }, this);\n\n            return action(newData);\n        },\n\n        /**\n         * Removes empty(in common sence) obj props/array elems\n         *\n         * @param {*} data - Data to be cleaned.\n         * @returns {*}\n         */\n        removeEmptyValues: function (data) {\n            if (!_.isObject(data)) {\n                return data;\n            }\n\n            if (_.isArray(data)) {\n                return data.filter(function (item) {\n                    return !this.isEmptyObj(item);\n                }, this);\n            }\n\n            return _.omit(data, this.isEmptyObj.bind(this));\n        },\n\n        /**\n         * Checks that argument of any type is empty in common sence:\n         * empty string, string with spaces only, object without own props, empty array, null or undefined\n         *\n         * @param {*} val - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEmptyObj: function (val) {\n\n            return _.isObject(val) && _.isEmpty(val) ||\n            this.isEmpty(val) ||\n            val && val.trim && this.isEmpty(val.trim());\n        }\n    };\n});\n\n","mage/utils/compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mage/utils/objects'\n], function (_, utils) {\n    'use strict';\n\n    var result = [];\n\n    /**\n     * Checks if all of the provided arrays contains equal values.\n     *\n     * @param {(Boolean|Array)} [keepOrder=false]\n     * @param {Array} target\n     * @returns {Boolean}\n     */\n    function equalArrays(keepOrder, target) {\n        var args = _.toArray(arguments),\n            arrays;\n\n        if (!Array.isArray(keepOrder)) {\n            arrays      = args.slice(2);\n        } else {\n            target      = keepOrder;\n            keepOrder   = false;\n            arrays      = args.slice(1);\n        }\n\n        if (!arrays.length) {\n            return true;\n        }\n\n        return arrays.every(function (array) {\n            if (array === target) {\n                return true;\n            } else if (array.length !== target.length) {\n                return false;\n            } else if (!keepOrder) {\n                return !_.difference(target, array).length;\n            }\n\n            return array.every(function (value, index) {\n                return target[index] === value;\n            });\n        });\n    }\n\n    /**\n     * Checks if two values are different.\n     *\n     * @param {*} a - First value.\n     * @param {*} b - Second value.\n     * @returns {Boolean}\n     */\n    function isDifferent(a, b) {\n        var oldIsPrimitive = utils.isPrimitive(a);\n\n        if (Array.isArray(a) && Array.isArray(b)) {\n            return !equalArrays(true, a, b);\n        }\n\n        return oldIsPrimitive ? a !== b : true;\n    }\n\n    /**\n     * @param {String} prefix\n     * @param {String} part\n     */\n    function getPath(prefix, part) {\n        return prefix ? prefix + '.' + part : part;\n    }\n\n    /**\n     * Checks if object has own specified property.\n     *\n     * @param {*} obj - Value to be checked.\n     * @param {String} key - Key of the property.\n     * @returns {Boolean}\n     */\n    function hasOwn(obj, key) {\n        return Object.prototype.hasOwnProperty.call(obj, key);\n    }\n\n    /**\n     * @param {Array} changes\n     */\n    function getContainers(changes) {\n        var containers  = {},\n            indexed     = _.indexBy(changes, 'path');\n\n        _.each(indexed, function (change, name) {\n            var path;\n\n            name.split('.').forEach(function (part) {\n                path = getPath(path, part);\n\n                if (path in indexed) {\n                    return;\n                }\n\n                (containers[path] = containers[path] || []).push(change);\n            });\n        });\n\n        return containers;\n    }\n\n    /**\n     * @param {String} path\n     * @param {String} name\n     * @param {String} type\n     * @param {String} newValue\n     * @param {String} oldValue\n     */\n    function addChange(path, name, type, newValue, oldValue) {\n        var data;\n\n        data = {\n            path: path,\n            name: name,\n            type: type\n        };\n\n        if (type !== 'remove') {\n            data.value = newValue;\n            data.oldValue = oldValue;\n        } else {\n            data.oldValue = newValue;\n        }\n\n        result.push(data);\n    }\n\n    /**\n     * @param {String} ns\n     * @param {String} name\n     * @param {String} type\n     * @param {String} iterator\n     * @param {String} placeholder\n     */\n    function setAll(ns, name, type, iterator, placeholder) {\n        var key;\n\n        if (arguments.length > 4) {\n            type === 'add' ?\n                addChange(ns, name, 'update', iterator, placeholder) :\n                addChange(ns, name, 'update', placeholder, iterator);\n        } else {\n            addChange(ns, name, type, iterator);\n        }\n\n        if (!utils.isObject(iterator)) {\n            return;\n        }\n\n        for (key in iterator) {\n            if (hasOwn(iterator, key)) {\n                setAll(getPath(ns, key), key, type, iterator[key]);\n            }\n        }\n    }\n\n    /*eslint-disable max-depth*/\n    /**\n     * @param {Object} old\n     * @param {Object} current\n     * @param {String} ns\n     * @param {String} name\n     */\n    function compare(old, current, ns, name) {\n        var key,\n            oldIsObj = utils.isObject(old),\n            newIsObj = utils.isObject(current);\n\n        if (oldIsObj && newIsObj) {\n            for (key in old) {\n                if (hasOwn(old, key) && !hasOwn(current, key)) {\n                    setAll(getPath(ns, key), key, 'remove', old[key]);\n                }\n            }\n\n            for (key in current) {\n                if (hasOwn(current, key)) {\n                    hasOwn(old, key) ?\n                        compare(old[key], current[key], getPath(ns, key), key) :\n                        setAll(getPath(ns, key), key, 'add', current[key]);\n                }\n            }\n        } else if (oldIsObj) {\n            setAll(ns, name, 'remove', old, current);\n        } else if (newIsObj) {\n            setAll(ns, name, 'add', current, old);\n        } else if (isDifferent(old, current)) {\n            addChange(ns, name, 'update', current, old);\n        }\n    }\n\n    /*eslint-enable max-depth*/\n\n    return {\n\n        /**\n         *\n         * @returns {Object}\n         */\n        compare: function () {\n            var changes;\n\n            compare.apply(null, arguments);\n\n            changes = result.splice(0);\n\n            return {\n                containers: getContainers(changes),\n                changes: changes,\n                equal: !changes.length\n            };\n        },\n\n        equalArrays: equalArrays\n    };\n});\n","mage/utils/strings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var jsonRe = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/;\n\n    return {\n\n        /**\n         * Attempts to convert string to one of the primitive values,\n         * or to parse it as a valid json object.\n         *\n         * @param {String} str - String to be processed.\n         * @returns {*}\n         */\n        castString: function (str) {\n            try {\n                str = str === 'true' ? true :\n                    str === 'false' ? false :\n                        str === 'null' ? null :\n                            +str + '' === str ? +str :\n                                jsonRe.test(str) ? JSON.parse(str) :\n                                    str;\n            } catch (e) {\n            }\n\n            return str;\n        },\n\n        /**\n         * Splits string by separator if it's possible,\n         * otherwise returns the incoming value.\n         *\n         * @param {(String|Array|*)} str - String to split.\n         * @param {String} [separator=' '] - Seperator based on which to split the string.\n         * @returns {Array|*} Splitted string or the incoming value.\n         */\n        stringToArray: function (str, separator) {\n            separator = separator || ' ';\n\n            return typeof str === 'string' ?\n                str.split(separator) :\n                str;\n        },\n\n        /**\n         * Converts the incoming string which consists\n         * of a specified delimiters into a format commonly used in form elements.\n         *\n         * @param {String} name - The incoming string.\n         * @param {String} [separator='.']\n         * @returns {String} Serialized string.\n         *\n         * @example\n         *      utils.serializeName('one.two.three');\n         *      => 'one[two][three]';\n         */\n        serializeName: function (name, separator) {\n            var result;\n\n            separator = separator || '.';\n            name = name.split(separator);\n\n            result = name.shift();\n\n            name.forEach(function (part) {\n                result += '[' + part + ']';\n            });\n\n            return result;\n        },\n\n        /**\n         * Checks wether the incoming value is not empty,\n         * e.g. not 'null' or 'undefined'\n         *\n         * @param {*} value - Value to check.\n         * @returns {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || _.isUndefined(value) || _.isNull(value);\n        },\n\n        /**\n         * Adds 'prefix' to the 'part' value if it was provided.\n         *\n         * @param {String} prefix\n         * @param {String} part\n         * @returns {String}\n         */\n        fullPath: function (prefix, part) {\n            return prefix ? prefix + '.' + part : part;\n        },\n\n        /**\n         * Splits incoming string and returns its' part specified by offset.\n         *\n         * @param {String} parts\n         * @param {Number} [offset]\n         * @param {String} [delimiter=.]\n         * @returns {String}\n         */\n        getPart: function (parts, offset, delimiter) {\n            delimiter = delimiter || '.';\n            parts = parts.split(delimiter);\n            offset = this.formatOffset(parts, offset);\n\n            parts.splice(offset, 1);\n\n            return parts.join(delimiter) || '';\n        },\n\n        /**\n         * Converts nameThroughCamelCase to name-through-minus\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        camelCaseToMinus: function camelCaseToMinus(string) {\n            return ('' + string)\n                .split('')\n                .map(function (symbol, index) {\n                    return index ?\n                        symbol.toUpperCase() === symbol ?\n                        '-' + symbol.toLowerCase() :\n                            symbol :\n                        symbol.toLowerCase();\n                })\n                .join('');\n        },\n\n        /**\n         * Converts name-through-minus to nameThroughCamelCase\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        minusToCamelCase: function minusToCamelCase(string) {\n            return ('' + string)\n                .split('-')\n                .map(function (part, index) {\n                    return index ? part.charAt(0).toUpperCase() + part.slice(1) : part;\n                })\n                .join('');\n        }\n    };\n});\n","mage/utils/template.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-shadow */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/utils/objects',\n    'mage/utils/strings'\n], function ($, _, utils, stringUtils) {\n    'use strict';\n\n    var tmplSettings = _.templateSettings,\n        interpolate = /\\$\\{([\\s\\S]+?)\\}/g,\n        opener = '${',\n        template,\n        hasStringTmpls;\n\n    /**\n     * Identifies whether ES6 templates are supported.\n     */\n    hasStringTmpls = (function () {\n        var testString = 'var foo = \"bar\"; return `${ foo }` === foo';\n\n        try {\n            return Function(testString)();\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    /**\n     * Objects can specify how to use templating for their properties - getting that configuration.\n     *\n     * To disable rendering for all properties of your object add __disableTmpl: true.\n     * To disable for specific property add __disableTmpl: {propertyName: true}.\n     * To limit recursion for a specific property add __disableTmpl: {propertyName: numberOfCycles}.\n     *\n     * @param {String} tmpl\n     * @param {Object | undefined} target\n     * @returns {Boolean|Object}\n     */\n    function isTmplIgnored(tmpl, target) {\n        var parsedTmpl;\n\n        try {\n            parsedTmpl = JSON.parse(tmpl);\n\n            if (typeof parsedTmpl === 'object') {\n                return tmpl.includes('__disableTmpl');\n            }\n        } catch (e) {\n        }\n\n        if (typeof target !== 'undefined') {\n            if (typeof target === 'object' && target.hasOwnProperty('__disableTmpl')) {\n                return target.__disableTmpl;\n            }\n        }\n\n        return false;\n\n    }\n\n    if (hasStringTmpls) {\n\n        /*eslint-disable no-unused-vars, no-eval*/\n        /**\n         * Evaluates template string using ES6 templates.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} $ - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, $) {\n            return eval('`' + tmpl + '`');\n        };\n\n        /*eslint-enable no-unused-vars, no-eval*/\n    } else {\n\n        /**\n         * Fallback function used when ES6 templates are not supported.\n         * Uses underscore templates renderer.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} data - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, data) {\n            var cached = tmplSettings.interpolate;\n\n            tmplSettings.interpolate = interpolate;\n\n            tmpl = _.template(tmpl, {\n                variable: '$'\n            })(data);\n\n            tmplSettings.interpolate = cached;\n\n            return tmpl;\n        };\n    }\n\n    /**\n     * Checks if provided value contains template syntax.\n     *\n     * @param {*} value - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isTemplate(value) {\n        return typeof value === 'string' &&\n            value.indexOf(opener) !== -1 &&\n            // the below pattern almost always indicates an accident which should not cause template evaluation\n            // refuse to evaluate\n            value.indexOf('${{') === -1;\n    }\n\n    /**\n     * Iteratively processes provided string\n     * until no templates syntax will be found.\n     *\n     * @param {String} tmpl - Template string.\n     * @param {Object} data - Data object used in a template.\n     * @param {Boolean} [castString=false] - Flag that indicates whether template\n     *      should be casted after evaluation to a value of another type or\n     *      that it should be leaved as a string.\n     * @param {Number|undefined} maxCycles - Maximum number of rendering cycles, can be 0.\n     * @returns {*} Compiled template.\n     */\n    function render(tmpl, data, castString, maxCycles) {\n        var last = tmpl,\n            cycles = 0;\n\n        while (~tmpl.indexOf(opener) && (typeof maxCycles === 'undefined' || cycles < maxCycles)) {\n            if (!isTmplIgnored(tmpl)) {\n                tmpl = template(tmpl, data);\n            }\n\n            if (tmpl === last) {\n                break;\n            }\n\n            last = tmpl;\n            cycles++;\n        }\n\n        return castString ?\n            stringUtils.castString(tmpl) :\n            tmpl;\n    }\n\n    return {\n\n        /**\n         * Applies provided data to the template.\n         *\n         * @param {Object|String} tmpl\n         * @param {Object} [data] - Data object to match with template.\n         * @param {Boolean} [castString=false] - Flag that indicates whether template\n         *      should be casted after evaluation to a value of another type or\n         *      that it should be leaved as a string.\n         * @returns {*}\n         *\n         * @example Template defined as a string.\n         *      var source = { foo: 'Random Stuff', bar: 'Some' };\n         *\n         *      utils.template('${ $.bar } ${ $.foo }', source);\n         *      => 'Some Random Stuff';\n         *\n         * @example Template defined as an object.\n         *      var tmpl = {\n         *              key: {'${ $.$data.bar }': '${ $.$data.foo }'},\n         *              foo: 'bar',\n         *              x1: 2, x2: 5,\n         *              delta: '${ $.x2 - $.x1 }',\n         *              baz: 'Upper ${ $.foo.toUpperCase() }'\n         *      };\n         *\n         *      utils.template(tmpl, source);\n         *      => {\n         *          key: {'Some': 'Random Stuff'},\n         *          foo: 'bar',\n         *          x1: 2, x2: 5,\n         *          delta: 3,\n         *          baz: 'Upper BAR'\n         *      };\n         */\n        template: function (tmpl, data, castString, dontClone) {\n            if (typeof tmpl === 'string') {\n                return render(tmpl, data, castString);\n            }\n\n            if (!dontClone) {\n                tmpl = utils.copy(tmpl);\n            }\n\n            tmpl.$data = data || {};\n\n            /**\n             * Template iterator function.\n             */\n            _.each(tmpl, function iterate(value, key, list) {\n                var disabled,\n                    maxCycles;\n\n                if (key === '$data') {\n                    return;\n                }\n\n                if (isTemplate(key)) {\n                    delete list[key];\n\n                    key = render(key, tmpl);\n                    list[key] = value;\n                }\n\n                if (isTemplate(value)) {\n                    //Getting template disabling settings, can be true for all disabled and separate settings\n                    //for each property.\n                    disabled = isTmplIgnored(value, list);\n\n                    if (typeof disabled === 'object' && disabled.hasOwnProperty(key) && disabled[key] !== false) {\n                        //Checking if specific settings for a property provided.\n                        maxCycles = disabled[key];\n                    }\n\n                    if (disabled === true || maxCycles === true) {\n                        //Rendering for all properties is disabled.\n                        maxCycles = 0;\n                    }\n\n                    list[key] = render(value, tmpl, castString, maxCycles);\n                } else if ($.isPlainObject(value) || Array.isArray(value)) {\n                    _.each(value, iterate);\n                }\n            });\n\n            delete tmpl.$data;\n\n            return tmpl;\n        }\n    };\n});\n","mage/validation/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/validation',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.each({\n        'validate-grouped-qty': [\n            function (value, element, params) {\n                var result = false,\n                    total = 0;\n\n                $(params).find('input[data-validate*=\"validate-grouped-qty\"]').each(function (i, e) {\n                    var val = $(e).val(),\n                        valInt;\n\n                    if (val && val.length > 0) {\n                        result = true;\n                        valInt = parseFloat(val) || 0;\n\n                        if (valInt >= 0) {\n                            total += valInt;\n                        } else {\n                            result = false;\n\n                            return result;\n                        }\n                    }\n                });\n\n                return result && total > 0;\n            },\n            $.mage.__('Please specify the quantity of product(s).')\n        ],\n        'validate-one-checkbox-required-by-name': [\n            function (value, element, params) {\n                var checkedCount = 0,\n                    container;\n\n                if (element.type === 'checkbox') {\n                    $('[name=\"' + element.name + '\"]').each(\n                        function () {\n                            if ($(this).is(':checked')) {\n                                checkedCount += 1;\n\n                                return false;\n                            }\n                        }\n                    );\n                }\n                container = '#' + params;\n\n                if (checkedCount > 0) {\n                    $(container).removeClass('validation-failed');\n                    $(container).addClass('validation-passed');\n\n                    return true;\n                }\n                $(container).addClass('validation-failed');\n                $(container).removeClass('validation-passed');\n\n                return false;\n            },\n            $.mage.__('Please select one of the options.')\n        ],\n        'validate-date-between': [\n            function (value, element, params) {\n                var minDate = new Date(params[0]),\n                    maxDate = new Date(params[1]),\n                    inputDate = new Date(element.value),\n                    message;\n\n                minDate.setHours(0);\n                maxDate.setHours(0);\n\n                if (inputDate >= minDate && inputDate <= maxDate) {\n                    return true;\n                }\n                message = $.mage.__('Please enter a date between %min and %max.');\n                this.dateBetweenErrorMessage = message.replace('%min', minDate).replace('%max', maxDate);\n\n                return false;\n            },\n            function () {\n                return this.dateBetweenErrorMessage;\n            }\n        ],\n        'validate-dob': [\n            function (val, element, params) {\n                var dob = $(element).parents('.customer-dob'),\n                    dayVal, monthVal, yearVal, dobLength, day, month, year, curYear,\n                    validYearMessage, validateDayInMonth, validDateMessage, today, dateEntered;\n\n                $(dob).find('.' + this.settings.errorClass).removeClass(this.settings.errorClass);\n                dayVal = $(dob).find(params[0]).find('input:text').val();\n                monthVal = $(dob).find(params[1]).find('input:text').val();\n                yearVal = $(dob).find(params[2]).find('input:text').val();\n                dobLength = dayVal.length + monthVal.length + yearVal.length;\n\n                if (params[3] && dobLength === 0) {\n                    this.dobErrorMessage = $.mage.__('This is a required field.');\n\n                    return false;\n                }\n\n                if (!params[3] && dobLength === 0) {\n                    return true;\n                }\n                day = parseInt(dayVal, 10) || 0;\n                month = parseInt(monthVal, 10) || 0;\n                year = parseInt(yearVal, 10) || 0;\n                curYear = new Date().getFullYear();\n\n                if (!day || !month || !year) {\n                    this.dobErrorMessage = $.mage.__('Please enter a valid full date.');\n\n                    return false;\n                }\n\n                if (month < 1 || month > 12) {\n                    this.dobErrorMessage = $.mage.__('Please enter a valid month (1-12).');\n\n                    return false;\n                }\n\n                if (year < 1900 || year > curYear) {\n                    validYearMessage = $.mage.__('Please enter a valid year (1900-%1).');\n                    this.dobErrorMessage = validYearMessage.replace('%1', curYear.toString());\n\n                    return false;\n                }\n                validateDayInMonth = new Date(year, month, 0).getDate();\n\n                if (day < 1 || day > validateDayInMonth) {\n                    validDateMessage = $.mage.__('Please enter a valid day (1-%1).');\n                    this.dobErrorMessage = validDateMessage.replace('%1', validateDayInMonth.toString());\n\n                    return false;\n                }\n                today = new Date();\n                dateEntered = new Date();\n                dateEntered.setFullYear(year, month - 1, day);\n\n                if (dateEntered > today) {\n                    this.dobErrorMessage = $.mage.__('Please enter a date from the past.');\n\n                    return false;\n                }\n\n                day = day % 10 === day ? '0' + day : day;\n                month = month % 10 === month ? '0' + month : month;\n                $(element).val(month + '/' + day + '/' + year);\n\n                return true;\n            },\n            function () {\n                return this.dobErrorMessage;\n            }\n        ]\n    }, function (i, rule) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n});\n","mage/validation/url.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n\n        /**\n         * Redirects to the url if it is considered safe\n         *\n         * @param {String} path - url to be redirected to\n         */\n        redirect: function (path) {\n            path = this.sanitize(path);\n\n            if (this.validate(path)) {\n                window.location.href = path;\n            }\n        },\n\n        /**\n         * Validates url\n         *\n         * @param {Object} path - url to be validated\n         * @returns {Boolean}\n         */\n        validate: function (path) {\n            var hostname = window.location.hostname;\n\n            if (path.indexOf(hostname) === -1 ||\n                path.indexOf('javascript:') !== -1 ||\n                path.indexOf('vbscript:') !== -1) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Sanitize url, replacing disallowed chars\n         *\n         * @param {String} path - url to be normalized\n         * @returns {String}\n         */\n        sanitize: function (path) {\n            return path.replace('[^-A-Za-z0-9+&@#/%?=~_|!:,.;\\(\\)]', '');\n        }\n    };\n});\n","Magento_Paypal/js/order-review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery-ui-modules/widget',\n    'mage/translate',\n    'mage/mage',\n    'mage/validation'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.orderReview', {\n        options: {\n            orderReviewSubmitSelector: '#review-button',\n            shippingSelector: '#shipping_method',\n            shippingSubmitFormSelector: null,\n            updateOrderSelector: '#update-order',\n            billingAsShippingSelector: '#billing\\\\:as_shipping',\n            updateContainerSelector: '#details-reload',\n            waitLoadingContainer: '#review-please-wait',\n            shippingMethodContainer: '#shipping-method-container',\n            agreementSelector: 'div.checkout-agreements input',\n            isAjax: false,\n            shippingMethodUpdateUrl: null,\n            updateOrderSubmitUrl: null,\n            canEditShippingMethod: false\n        },\n\n        /**\n         * Widget instance properties\n         */\n        triggerPropertyChange: true,\n        isShippingSubmitForm: false,\n\n        /** @inheritdoc */\n        _create: function () {\n            var isDisable;\n\n            //change handler for ajaxEnabled\n            if (this.options.isAjax) {\n                this._submitOrder = this._ajaxSubmitOrder;\n            }\n\n            this.element.on('click', this.options.orderReviewSubmitSelector, $.proxy(this._submitOrder, this))\n                .on('click', this.options.billingAsShippingSelector, $.proxy(this._shippingTobilling, this))\n                .on('change',\n                    this.options.shippingSelector,\n                    $.proxy(this._submitUpdateOrder,\n                        this,\n                        this.options.updateOrderSubmitUrl,\n                        this.options.updateContainerSelector\n                    )\n                ).find(this.options.updateOrderSelector).on('click', $.proxy(this._updateOrderHandler, this)).end();\n            this._shippingTobilling();\n\n            if ($(this.options.shippingSubmitFormSelector).length && this.options.canEditShippingMethod) {\n                this.isShippingSubmitForm = true;\n                $(this.options.shippingSubmitFormSelector)\n                    .on('change',\n                        this.options.shippingSelector,\n                        $.proxy(\n                            this._submitUpdateOrder,\n                            this,\n                            $(this.options.shippingSubmitFormSelector).prop('action'),\n                            this.options.updateContainerSelector\n                        )\n                    );\n                this._updateOrderSubmit(!$(this.options.shippingSubmitFormSelector)\n                    .find(this.options.shippingSelector).val());\n            } else {\n                isDisable = this.isShippingSubmitForm && this.element.find(this.options.shippingSelector).val();\n                this.element\n                    .on('input propertychange', ':input[name]',\n                        $.proxy(this._updateOrderSubmit, this, isDisable, this._onShippingChange)\n                    ).find('select').not(this.options.shippingSelector).on('change', this._propertyChange);\n                this._updateOrderSubmit(isDisable);\n            }\n        },\n\n        /**\n         * show ajax loader\n         */\n        _ajaxBeforeSend: function () {\n            this.element.find(this.options.waitLoadingContainer).show();\n        },\n\n        /**\n         * hide ajax loader\n         */\n        _ajaxComplete: function () {\n            this.element.find(this.options.waitLoadingContainer).hide();\n        },\n\n        /**\n         * trigger propertychange for input type select\n         */\n        _propertyChange: function () {\n            $(this).trigger('propertychange');\n        },\n\n        /**\n         * trigger change for the update of shipping methods from server\n         */\n        _updateOrderHandler: function () {\n            $(this.options.shippingSelector).trigger('change');\n        },\n\n        /**\n         * Attempt to submit order\n         */\n        _submitOrder: function () {\n            if (this._validateForm()) {\n                this.element.find(this.options.updateOrderSelector).fadeTo(0, 0.5)\n                    .end().find(this.options.waitLoadingContainer).show()\n                    .end().trigger('submit');\n                this._updateOrderSubmit(true);\n            }\n        },\n\n        /**\n         * Attempt to ajax submit order\n         */\n        _ajaxSubmitOrder: function () {\n            if (this.element.find(this.options.waitLoadingContainer).is(':visible')) {\n                return false;\n            }\n            $.ajax({\n                url: this.element.prop('action'),\n                type: 'post',\n                context: this,\n                data: {\n                    isAjax: 1\n                },\n                dataType: 'json',\n                beforeSend: this._ajaxBeforeSend,\n                complete: this._ajaxComplete,\n\n                /** @inheritdoc */\n                success: function (response) {\n                    var msg;\n\n                    if (typeof response === 'object' && !$.isEmptyObject(response)) {\n                        if (response['error_messages']) {\n                            this._ajaxComplete();\n                            msg = response['error_messages'];\n\n                            /* eslint-disable max-depth */\n                            if (msg) {\n                                if (Array.isArray(msg)) {\n                                    msg = msg.join('\\n');\n                                }\n                            }\n\n                            /* eslint-enablemax-depth */\n                            alert({\n                                content: msg\n                            });\n\n                            return false;\n                        }\n\n                        if (response.redirect) {\n                            $.mage.redirect(response.redirect);\n\n                            return false;\n                        } else if (response.success) {\n                            $.mage.redirect(this.options.successUrl);\n\n                            return false;\n                        }\n                        this._ajaxComplete();\n                        alert({\n                            content: $.mage.__('Sorry, something went wrong.')\n                        });\n                    }\n                },\n\n                /** @inheritdoc */\n                error: function () {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    this._ajaxComplete();\n                }\n            });\n        },\n\n        /**\n         * Validate Order form\n         */\n        _validateForm: function () {\n            this.element.find(this.options.agreementSelector).off('change').on('change', $.proxy(function () {\n                var isValid = this._validateForm();\n\n                this._updateOrderSubmit(!isValid);\n            }, this));\n\n            if (this.element.data('mageValidation')) {\n                return this.element.validation().valid();\n            }\n\n            return true;\n        },\n\n        /**\n         * Check/Set whether order can be submitted\n         * Also disables form submission element, if any\n         * @param {*} shouldDisable - whether should prevent order submission explicitly\n         * @param {Function} [fn] - function for shipping change handler\n         * @param {*} [*] - if true the property change will be set to true\n         */\n        _updateOrderSubmit: function (shouldDisable, fn) {\n            this._toggleButton(this.options.orderReviewSubmitSelector, shouldDisable);\n\n            if (typeof fn === 'function') {\n                fn.call(this);\n            }\n        },\n\n        /**\n         * Enable/Disable button\n         * @param {jQuery} button - button selector to be toggled\n         * @param {*} disable - boolean for toggling\n         */\n        _toggleButton: function (button, disable) {\n            $(button).prop({\n                'disabled': disable\n            }).toggleClass('no-checkout', disable).fadeTo(0, disable ? 0.5 : 1);\n        },\n\n        /**\n         * Copy element value from shipping to billing address\n         * @param {jQuery.Event} e - optional\n         */\n        _shippingTobilling: function (e) {\n            var isChecked, opacity;\n\n            if (this.options.shippingSubmitFormSelector) {\n                return false;\n            }\n            isChecked = $(this.options.billingAsShippingSelector).is(':checked');\n            opacity = isChecked ? 0.5 : 1;\n\n            if (isChecked) {\n                this.element.validation('clearError', ':input[name^=\"billing\"]');\n            }\n            $(':input[name^=\"shipping\"]', this.element).each($.proxy(function (key, value) {\n                var fieldObj = $(value.id.replace('shipping:', '#billing\\\\:'));\n\n                if (isChecked) {\n                    fieldObj = fieldObj.val($(value).val());\n                }\n                fieldObj.prop({\n                    'readonly': isChecked,\n                    'disabled': isChecked\n                }).fadeTo(0, opacity);\n\n                if (fieldObj.is('select')) {\n                    this.triggerPropertyChange = false;\n                    fieldObj.trigger('change');\n                }\n            }, this));\n\n            if (isChecked || e) {\n                this._updateOrderSubmit(true);\n            }\n            this.triggerPropertyChange = true;\n        },\n\n        /**\n         * Dispatch an ajax request of Update Order submission\n         * @param {*} url - url where to submit shipping method\n         * @param {*} resultId - id of element to be updated\n         */\n        _submitUpdateOrder: function (url, resultId) {\n            var isChecked, formData, callBackResponseHandler, shippingMethod;\n\n            if (this.element.find(this.options.waitLoadingContainer).is(':visible')) {\n                return false;\n            }\n            isChecked = $(this.options.billingAsShippingSelector).is(':checked');\n            formData = null;\n            callBackResponseHandler = null;\n            let val = $(this.options.shippingSelector).val();\n\n            shippingMethod = val.trim();\n            this._shippingTobilling();\n\n            if (url && resultId && shippingMethod) {\n                this._updateOrderSubmit(true);\n                this._toggleButton(this.options.updateOrderSelector, true);\n\n                // form data and callBack updated based on the shipping Form element\n                if (this.isShippingSubmitForm) {\n                    formData = $(this.options.shippingSubmitFormSelector).serialize() + '&isAjax=true';\n\n                    /**\n                     * @param {Object} response\n                     */\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._updateOrderSubmit(false);\n                        this._ajaxComplete();\n                    };\n                } else {\n                    formData = this.element.serialize() + '&isAjax=true';\n\n                    /**\n                     * @param {Object} response\n                     */\n                    callBackResponseHandler = function (response) {\n                        $(resultId).html(response);\n                        this._ajaxShippingUpdate(shippingMethod);\n                    };\n                }\n\n                if (isChecked) {\n                    $(this.options.shippingSelect).prop('disabled', true);\n                }\n                $.ajax({\n                    url: url,\n                    type: 'post',\n                    context: this,\n                    beforeSend: this._ajaxBeforeSend,\n                    data: formData,\n                    success: callBackResponseHandler\n                });\n            }\n        },\n\n        /**\n         * Update Shipping Methods Element from server\n         * @param {*} shippingMethod\n         */\n        _ajaxShippingUpdate: function (shippingMethod) {\n            $.ajax({\n                url: this.options.shippingMethodUpdateUrl,\n                data: {\n                    isAjax: true,\n                    'shipping_method': shippingMethod\n                },\n                type: 'post',\n                context: this,\n\n                /** @inheritdoc */\n                success: function (response) {\n                    $(this.options.shippingMethodContainer).parent().html(response);\n                    this._toggleButton(this.options.updateOrderSelector, false);\n                    this._updateOrderSubmit(false);\n                },\n                complete: this._ajaxComplete\n            });\n        },\n\n        /**\n         * Actions on change Shipping Address data\n         */\n        _onShippingChange: function () {\n            let val = $(this.options.shippingSelector).val();\n\n            if (this.triggerPropertyChange && val.trim()) {\n                this.element.find(this.options.shippingSelector).hide().end()\n                    .find(this.options.shippingSelector + '_update').show();\n            }\n        }\n    });\n\n    return $.mage.orderReview;\n});\n","Magento_Paypal/js/paypal-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data',\n    'jquery-ui-modules/widget',\n    'mage/mage'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.paypalCheckout', {\n        options: {\n            originalForm:\n                'form:not(#product_addtocart_form_from_popup):has(input[name=\"product\"][value=%1])',\n            productId: 'input[type=\"hidden\"][name=\"product\"]',\n            ppCheckoutSelector: '[data-role=pp-checkout-url]',\n            ppCheckoutInput: '<input type=\"hidden\" data-role=\"pp-checkout-url\" name=\"return_url\" value=\"\"/>'\n        },\n\n        /**\n         * Initialize store credit events\n         * @private\n         */\n        _create: function () {\n            this.element.on('click', '[data-action=\"checkout-form-submit\"]', $.proxy(function (e) {\n                var $target = $(e.target),\n                    returnUrl = $target.data('checkout-url'),\n                    productId = $target.closest('form').find(this.options.productId).val(),\n                    originalForm = this.options.originalForm.replace('%1', productId),\n                    self = this,\n                    billingAgreement = customerData.get('paypal-billing-agreement');\n\n                e.preventDefault();\n\n                if (billingAgreement().askToCreate) {\n                    confirm({\n                        content: billingAgreement().confirmMessage,\n                        actions: {\n\n                            /**\n                             * Confirmation handler\n                             *\n                             */\n                            confirm: function () {\n                                returnUrl = billingAgreement().confirmUrl;\n                                self._redirect(returnUrl, originalForm);\n                            },\n\n                            /**\n                             * Cancel confirmation handler\n                             *\n                             */\n                            cancel: function (event) {\n                                if (event && !$(event.target).hasClass('action-close')) {\n                                    self._redirect(returnUrl);\n                                }\n                            }\n                        }\n                    });\n                } else {\n                    this._redirect(returnUrl, originalForm);\n                }\n            }, this));\n        },\n\n        /**\n         * Redirect to certain url, with optional form\n         * @param {String} returnUrl\n         * @param {HTMLElement} originalForm\n         *\n         */\n        _redirect: function (returnUrl, originalForm) {\n            var $form,\n                ppCheckoutInput;\n\n            if (this.options.isCatalogProduct) {\n                // find the form from which the button was clicked\n                $form = originalForm ? $(originalForm) : $($(this.options.shortcutContainerClass).closest('form'));\n\n                ppCheckoutInput = $form.find(this.options.ppCheckoutSelector)[0];\n\n                if (!ppCheckoutInput) {\n                    ppCheckoutInput = $(this.options.ppCheckoutInput);\n                    ppCheckoutInput.appendTo($form);\n                }\n                $(ppCheckoutInput).val(returnUrl);\n\n                $form.trigger('submit');\n            } else {\n                $.mage.redirect(returnUrl);\n            }\n        }\n    });\n\n    return $.mage.paypalCheckout;\n});\n","Magento_Paypal/js/action/set-payment-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Checkout/js/model/quote',\n    'Magento_Checkout/js/action/set-payment-information'\n], function (quote, setPaymentInformation) {\n    'use strict';\n\n    return function (messageContainer) {\n        return setPaymentInformation(messageContainer, quote.paymentMethod());\n    };\n});\n","Magento_Paypal/js/model/iframe-redirect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'Magento_Paypal/js/model/iframe',\n    'Magento_Ui/js/model/messageList'\n],\nfunction (ko, iframe, messageList) {\n    'use strict';\n\n    return function (cartUrl, errorMessage, goToSuccessPage, successUrl) {\n        if (this === window.self) {\n            window.location = cartUrl;\n        }\n\n        if (!!errorMessage.message) { //eslint-disable-line no-extra-boolean-cast\n            document.removeEventListener('click', iframe.stopEventPropagation, true);\n            iframe.isInAction(false);\n            messageList.addErrorMessage(errorMessage);\n        } else if (!!goToSuccessPage) { //eslint-disable-line no-extra-boolean-cast\n            window.location = successUrl;\n        } else {\n            window.location = cartUrl;\n        }\n    };\n});\n","Magento_Paypal/js/model/iframe.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    var isInAction = ko.observable(false);\n\n    return {\n        isInAction: isInAction,\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        stopEventPropagation: function (event) {\n            event.stopImmediatePropagation();\n            event.preventDefault();\n        }\n    };\n});\n","Magento_Paypal/js/view/paylater.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiElement',\n    'uiLayout',\n    'Magento_Paypal/js/in-context/paypal-sdk',\n    'domReady!'\n], function (\n    $,\n    ko,\n    Component,\n    layout,\n    paypalSdk\n) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            template: 'Magento_Paypal/paylater',\n            sdkUrl: '',\n            attributes: {\n                class: 'pay-later-message'\n            },\n            dataAttributes: {},\n            refreshSelector: '',\n            displayAmount: false,\n            amountComponentConfig: {\n                name: '${ $.name }.amountProvider',\n                component: ''\n            }\n        },\n        paypal: null,\n        amount: null,\n\n        /**\n         * Initialize\n         *\n         * @returns {*}\n         */\n        initialize: function () {\n            this._super()\n                .observe(['amount']);\n\n            if (this.displayAmount) {\n                layout([this.amountComponentConfig]);\n            }\n\n            if (this.sdkUrl !== '') {\n                this.loadPayPalSdk(this.sdkUrl, this.dataAttributes)\n                    .then(this._setPayPalObject.bind(this));\n            }\n\n            if (this.refreshSelector) {\n                $(this.refreshSelector).on('click', this._refreshMessages.bind(this));\n            }\n\n            return this;\n        },\n\n        /**\n         * Get attribute value from configuration\n         *\n         * @param {String} attributeName\n         * @returns {*|null}\n         */\n        getAttribute: function (attributeName) {\n            return typeof this.attributes[attributeName] !== 'undefined' ?\n                this.attributes[attributeName] : null;\n        },\n\n        /**\n         * Load PP SDK with preconfigured options\n         *\n         * @param {String} sdkUrl - the url of the PayPal SDK\n         * @param {Array} dataAttributes - Array of the Attributes for PayPal SDK Script tag\n         */\n        loadPayPalSdk: function (sdkUrl, dataAttributes) {\n            return paypalSdk(sdkUrl, dataAttributes);\n        },\n\n        /**\n         * Set reference to paypal Sdk object\n         *\n         * @param {Object} paypal\n         * @private\n         */\n        _setPayPalObject: function (paypal) {\n            this.paypal = paypal;\n        },\n\n        /**\n         * Render messages\n         *\n         * @private\n         */\n        _refreshMessages: function () {\n            if (this.paypal) {\n                this.paypal.Messages.render();\n            }\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/paypal-payments.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list'\n], function (Component, rendererList) {\n    'use strict';\n\n    var isContextCheckout = window.checkoutConfig.payment.paypalExpress.isContextCheckout,\n        paypalExpress = 'Magento_Paypal/js/view/payment/method-renderer' +\n            (isContextCheckout ? '/in-context/checkout-express' : '/paypal-express');\n\n    rendererList.push(\n        {\n            type: 'paypal_express',\n            component: paypalExpress,\n            config: window.checkoutConfig.payment.paypalExpress.inContextConfig\n        },\n        {\n            type: 'payflow_express',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express'\n        },\n        {\n            type: 'payflow_express_bml',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml'\n        },\n        {\n            type: 'payflowpro',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/payflowpro-method'\n        },\n        {\n            type: 'payflow_link',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'payflow_advanced',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'hosted_pro',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/iframe-methods'\n        },\n        {\n            type: 'paypal_billing_agreement',\n            component: 'Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement'\n        }\n    );\n\n    /**\n     * Add view logic here if needed\n     **/\n    return Component.extend({});\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-billing-agreement.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/payment/default',\n    'mage/validation'\n], function ($, Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal_billing_agreement-form',\n            selectedBillingAgreement: ''\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('selectedBillingAgreement');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        getTransportName: function () {\n            return window.checkoutConfig.payment.paypalBillingAgreement.transportName;\n        },\n\n        /**\n         * @return {*}\n         */\n        getBillingAgreements: function () {\n            return window.checkoutConfig.payment.paypalBillingAgreement.agreements;\n        },\n\n        /**\n         * @return {Object}\n         */\n        getData: function () {\n            var additionalData = null;\n\n            if (this.getTransportName()) {\n                additionalData = {};\n                additionalData[this.getTransportName()] = this.selectedBillingAgreement();\n            }\n\n            return {\n                'method': this.item.method,\n                'additional_data': additionalData\n            };\n        },\n\n        /**\n         * @return {jQuery}\n         */\n        validate: function () {\n            var form = '#billing-agreement-form';\n\n            return $(form).validation() && $(form).validation('isValid');\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Paypal/js/action/set-payment-method',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/model/quote',\n    'Magento_Customer/js/customer-data'\n], function ($, Component, setPaymentMethodAction, additionalValidators, quote, customerData) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflow-express-bml',\n            billingAgreement: ''\n        },\n\n        /** Init observable variables */\n        initObservable: function () {\n            this._super()\n                .observe('billingAgreement');\n\n            return this;\n        },\n\n        /** Open window with  */\n        showAcceptanceWindow: function (data, event) {\n            window.open(\n                $(event.currentTarget).attr('href'),\n                'olcwhatispaypal',\n                'toolbar=no, location=no,' +\n                ' directories=no, status=no,' +\n                ' menubar=no, scrollbars=yes,' +\n                ' resizable=yes, ,left=0,' +\n                ' top=0, width=400, height=350'\n            );\n\n            return false;\n        },\n\n        /** Returns payment acceptance mark link path */\n        getPaymentAcceptanceMarkHref: function () {\n            return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkHref;\n        },\n\n        /** Returns payment acceptance mark image path */\n        getPaymentAcceptanceMarkSrc: function () {\n            return window.checkoutConfig.payment.paypalExpress.paymentAcceptanceMarkSrc;\n        },\n\n        /** Returns billing agreement data */\n        getBillingAgreementCode: function () {\n            return window.checkoutConfig.payment.paypalExpress.billingAgreementCode[this.item.method];\n        },\n\n        /** Returns payment information data */\n        getData: function () {\n            var parent = this._super(),\n                additionalData = null;\n\n            if (this.getBillingAgreementCode()) {\n                additionalData = {};\n                additionalData[this.getBillingAgreementCode()] = this.billingAgreement();\n            }\n\n            return $.extend(true, parent, {\n                'additional_data': additionalData\n            });\n        },\n\n        /** Redirect to paypal */\n        continueToPayPal: function () {\n            if (additionalValidators.validate()) {\n                //update payment method information if additional data was changed\n                setPaymentMethodAction(this.messageContainer).done(\n                    function () {\n                        customerData.invalidate(['cart']);\n                        $.mage.redirect(\n                            window.checkoutConfig.payment.paypalExpress.redirectUrl[quote.paymentMethod().method]\n                        );\n                    }\n                );\n\n                return false;\n            }\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro-method.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Payment/js/view/payment/iframe',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Checkout/js/action/set-payment-information',\n    'Magento_Checkout/js/model/full-screen-loader',\n    'Magento_Vault/js/view/payment/vault-enabler'\n], function ($, Component, additionalValidators, setPaymentInformationAction, fullScreenLoader, VaultEnabler) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflowpro-form'\n        },\n        placeOrderHandler: null,\n        validateHandler: null,\n\n        /**\n         * @returns {exports.initialize}\n         */\n        initialize: function () {\n            this._super();\n            this.vaultEnabler = new VaultEnabler();\n            this.vaultEnabler.setPaymentCode(this.getVaultCode());\n\n            return this;\n        },\n\n        /**\n         * @param {Function} handler\n         */\n        setPlaceOrderHandler: function (handler) {\n            this.placeOrderHandler = handler;\n        },\n\n        /**\n         * @param {Function} handler\n         */\n        setValidateHandler: function (handler) {\n            this.validateHandler = handler;\n        },\n\n        /**\n         * @returns {Object}\n         */\n        context: function () {\n            return this;\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isShowLegend: function () {\n            return true;\n        },\n\n        /**\n         * @returns {String}\n         */\n        getCode: function () {\n            return 'payflowpro';\n        },\n\n        /**\n         * @returns {Boolean}\n         */\n        isActive: function () {\n            return true;\n        },\n\n        /**\n         * @override\n         */\n        placeOrder: function () {\n            var self = this;\n\n            if (this.validateHandler() &&\n                additionalValidators.validate() &&\n                this.isPlaceOrderActionAllowed() === true\n            ) {\n                this.isPlaceOrderActionAllowed(false);\n                fullScreenLoader.startLoader();\n                $.when(\n                    setPaymentInformationAction(this.messageContainer, self.getData())\n                ).done(\n                    function () {\n                        self.placeOrderHandler().fail(\n                            function () {\n                                fullScreenLoader.stopLoader();\n                            }\n                        );\n                    }\n                ).always(\n                    function () {\n                        self.isPlaceOrderActionAllowed(true);\n                        fullScreenLoader.stopLoader();\n                    }\n                );\n            }\n        },\n\n        /**\n         * @returns {Object}\n         */\n        getData: function () {\n            var data = {\n                'method': this.getCode(),\n                'additional_data': {\n                    'cc_type': this.creditCardType(),\n                    'cc_exp_year': this.creditCardExpYear(),\n                    'cc_exp_month': this.creditCardExpMonth(),\n                    'cc_last_4': this.creditCardNumber().substr(-4)\n                }\n            };\n\n            this.vaultEnabler.visitAdditionalData(data);\n\n            return data;\n        },\n\n        /**\n         * @returns {Bool}\n         */\n        isVaultEnabled: function () {\n            return this.vaultEnabler.isVaultEnabled();\n        },\n\n        /**\n         * @returns {String}\n         */\n        getVaultCode: function () {\n            return 'payflowpro_cc_vault';\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/paypal-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal-express'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express-bml.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflow-express-bml'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflow-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/payflow-express'\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/iframe-methods.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Checkout/js/view/payment/default',\n    'Magento_Paypal/js/model/iframe',\n    'Magento_Checkout/js/model/full-screen-loader'\n], function (Component, iframe, fullScreenLoader) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/iframe-methods',\n            paymentReady: false\n        },\n        redirectAfterPlaceOrder: false,\n        isInAction: iframe.isInAction,\n\n        /**\n         * @return {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe('paymentReady');\n\n            return this;\n        },\n\n        /**\n         * @return {*}\n         */\n        isPaymentReady: function () {\n            return this.paymentReady();\n        },\n\n        /**\n         * Get action url for payment method iframe.\n         * @returns {String}\n         */\n        getActionUrl: function () {\n            return this.isInAction() ? window.checkoutConfig.payment.paypalIframe.actionUrl[this.getCode()] : '';\n        },\n\n        /**\n         * Places order in pending payment status.\n         */\n        placePendingPaymentOrder: function () {\n            if (this.placeOrder()) {\n                fullScreenLoader.startLoader();\n                this.isInAction(true);\n                // capture all click events\n                document.addEventListener('click', iframe.stopEventPropagation, true);\n            }\n        },\n\n        /**\n         * @return {*}\n         */\n        getPlaceOrderDeferredObject: function () {\n            var self = this;\n\n            return this._super().fail(function () {\n                fullScreenLoader.stopLoader();\n                self.isInAction(false);\n                document.removeEventListener('click', iframe.stopEventPropagation, true);\n            });\n        },\n\n        /**\n         * After place order callback\n         */\n        afterPlaceOrder: function () {\n            if (this.iframeIsLoaded) {\n                document.getElementById(this.getCode() + '-iframe')\n                    .contentWindow.location.reload();\n                this.paymentReady(false);\n            }\n\n            this.paymentReady(true);\n            this.iframeIsLoaded = true;\n            this.isPlaceOrderActionAllowed(true);\n            fullScreenLoader.stopLoader();\n        },\n\n        /**\n         * Hide loader when iframe is fully loaded.\n         */\n        iframeLoaded: function () {\n            fullScreenLoader.stopLoader();\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/payflowpro/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Vault/js/view/payment/method-renderer/vault'\n], function (VaultComponent) {\n    'use strict';\n\n    return VaultComponent.extend({\n        defaults: {\n            template: 'Magento_Vault/payment/form'\n        },\n\n        /**\n         * @returns {String}\n         */\n        getToken: function () {\n            return this.publicHash;\n        },\n\n        /**\n         * Get last 4 digits of card\n         * @returns {String}\n         */\n        getMaskedCard: function () {\n            return this.details['cc_last_4'];\n        },\n\n        /**\n         * Get expiration date\n         * @returns {String}\n         */\n        getExpirationDate: function () {\n            return this.details['cc_exp_month'] + '/' + this.details['cc_exp_year'];\n        },\n\n        /**\n         * Get card type\n         * @returns {String}\n         */\n        getCardType: function () {\n            return this.details['cc_type'];\n        }\n    });\n});\n","Magento_Paypal/js/view/payment/method-renderer/in-context/checkout-express.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Paypal/js/view/payment/method-renderer/paypal-express-abstract',\n    'Magento_Paypal/js/in-context/express-checkout-wrapper',\n    'Magento_Paypal/js/action/set-payment-method',\n    'Magento_Checkout/js/model/payment/additional-validators',\n    'Magento_Ui/js/model/messageList',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, Component, Wrapper, setPaymentMethod, additionalValidators, messageList) {\n    'use strict';\n\n    return Component.extend(Wrapper).extend({\n        defaults: {\n            template: 'Magento_Paypal/payment/paypal-express-in-context',\n            validationElements: 'input'\n        },\n\n        /**\n         * Listens element on change and validate it.\n         *\n         * @param {HTMLElement} context\n         */\n        initListeners: function (context) {\n            $.async(this.validationElements, context, function (element) {\n                $(element).on('change', function () {\n                    this.validate();\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         *  Validates Smart Buttons\n         */\n        validate: function () {\n            this._super();\n\n            if (this.actions) {\n                additionalValidators.validate(true) ? this.actions.enable() : this.actions.disable();\n            }\n        },\n\n        /** @inheritdoc */\n        beforePayment: function (resolve, reject) {\n            var promise = $.Deferred();\n\n            setPaymentMethod(this.messageContainer).done(function () {\n                return promise.resolve();\n            }).fail(function (response) {\n                var error;\n\n                try {\n                    error = JSON.parse(response.responseText);\n                } catch (exception) {\n                    error = this.paymentActionError;\n                }\n\n                this.addError(error);\n\n                return reject(new Error(error));\n            }.bind(this));\n\n            return promise;\n        },\n\n        /**\n         * Populate client config with all required data\n         *\n         * @return {Object}\n         */\n        prepareClientConfig: function () {\n            this._super();\n            this.clientConfig.quoteId = window.checkoutConfig.quoteData['entity_id'];\n            this.clientConfig.customerId = window.customerData.id;\n            this.clientConfig.button = 0;\n\n            return this.clientConfig;\n        },\n\n        /**\n         * Adding logic to be triggered onClick action for smart buttons component\n         */\n        onClick: function () {\n            additionalValidators.validate();\n        },\n\n        /**\n         * Adds error message\n         *\n         * @param {String} message\n         */\n        addError: function (message) {\n            messageList.addErrorMessage({\n                message: message\n            });\n        },\n\n        /**\n         * After payment execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         *\n         * @return {*}\n         */\n        afterPayment: function (res, resolve, reject) {\n            if (res.success) {\n                return resolve(res.token);\n            }\n\n            this.addError(res['error_message']);\n\n            return reject(new Error(res['error_message']));\n        },\n\n        /**\n         * After onAuthorize execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         * @param {Object} actions\n         *\n         * @return {*}\n         */\n        afterOnAuthorize: function (res, resolve, reject, actions) {\n            if (res.success) {\n                resolve();\n\n                return actions.redirect(res.redirectUrl);\n            }\n\n            this.addError(res['error_message']);\n\n            return reject(new Error(res['error_message']));\n        }\n    });\n});\n","Magento_Paypal/js/view/amountProviders/product-grouped.js":"/**\n* Copyright \u00a9 Magento, Inc. All rights reserved.\n* See COPYING.txt for license details.\n*/\n\ndefine([\n    'jquery',\n    'uiElement',\n    'uiRegistry',\n    'domReady!'\n], function (\n    $,\n    Component,\n    registry\n) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            tableWrapperSelector: '.table-wrapper.grouped',\n            priceBoxSelector: '[data-role=\"priceBox\"]',\n            qtyFieldSelector: '.input-text.qty',\n            amount: null\n        },\n        priceInfo: {},\n\n        /**\n         * Initialize\n         *\n         * @returns {*}\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            $('tbody tr', this.tableWrapperSelector).each(function (index, element) {\n                var priceBox = $(self.priceBoxSelector, element),\n                    qtyElement = $(self.qtyFieldSelector, element),\n                    productId = priceBox.data('productId'),\n                    priceElement = $('#product-price-' + productId);\n\n                self.priceInfo[productId] = {\n                    qty: self._getQty(qtyElement),\n                    price: priceElement.data('priceAmount')\n                };\n            });\n\n            $(this.qtyFieldSelector).on('change', this._onQtyChange.bind(this));\n\n            this._updateAmount();\n\n            return this;\n        },\n\n        /**\n         * Get product quantity\n         *\n         * @param {jQuery.Element} element\n         * @private\n         */\n        _getQty: function (element) {\n            var qty = parseFloat(element.val());\n\n            return !isNaN(qty) && qty ? qty : 0;\n        },\n\n        /**\n         * Handle changed product quantity\n         *\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyChange: function (event) {\n            var qtyElement = $(event.target),\n                parent = qtyElement.parents('tr'),\n                priceBox = $(this.priceBoxSelector, parent),\n                productId = priceBox.data('productId');\n\n            if (this.priceInfo[productId]) {\n                this.priceInfo[productId].qty = this._getQty(qtyElement);\n            }\n\n            this._updateAmount();\n        },\n\n        /**\n         * Calculate and update amount\n         *\n         * @private\n         */\n        _updateAmount: function () {\n            var productId,\n                amount = 0,\n                payLater = registry.get(this.parentName);\n\n            for (productId in this.priceInfo) {\n                if (this.priceInfo.hasOwnProperty(productId)) {\n                    amount += this.priceInfo[productId].price * this.priceInfo[productId].qty;\n                }\n            }\n\n            payLater.amount(amount);\n        }\n    });\n});\n","Magento_Paypal/js/view/amountProviders/product.js":"/**\n* Copyright \u00a9 Magento, Inc. All rights reserved.\n* See COPYING.txt for license details.\n*/\n\ndefine([\n    'jquery',\n    'uiElement',\n    'uiRegistry',\n    'priceBox',\n    'domReady!'\n], function (\n    $,\n    Component,\n    registry\n) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            priceBoxSelector: '.price-box',\n            qtyFieldSelector: '#product_addtocart_form [name=\"qty\"]',\n            amount: null\n        },\n        qty: 1,\n        price: 0,\n        priceType: '',\n\n        /**\n         * Initialize\n         *\n         * @returns {*}\n         */\n        initialize: function () {\n            var priceBox;\n\n            this._super();\n\n            priceBox = $(this.priceBoxSelector);\n            priceBox.on('priceUpdated', this._onPriceChange.bind(this));\n\n            if (priceBox.priceBox('option') &&\n                priceBox.priceBox('option').prices &&\n                (priceBox.priceBox('option').prices.finalPrice || priceBox.priceBox('option').prices.basePrice)\n            ) {\n                this.priceType = priceBox.priceBox('option').prices.finalPrice ? 'finalPrice' : 'basePrice';\n                this.price = priceBox.priceBox('option').prices[this.priceType].amount;\n            }\n\n            $(this.qtyFieldSelector).on('change', this._onQtyChange.bind(this));\n\n            priceBox.trigger('updatePrice');\n\n            return this;\n        },\n\n        /**\n         * Handle changed product qty\n         *\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyChange: function (event) {\n            var qty = parseFloat($(event.target).val());\n\n            this.qty = !isNaN(qty) && qty ? qty : 1;\n            this._updateAmount();\n        },\n\n        /**\n         * Handle product price change\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _onPriceChange: function (event, data) {\n            this.price = data[this.priceType].amount;\n            this._updateAmount();\n        },\n\n        /**\n         * Calculate and update amount\n         *\n         * @private\n         */\n        _updateAmount: function () {\n            var amount = this.price * this.qty,\n                payLater = registry.get(this.parentName);\n\n            if (amount !== 0) {\n                payLater.amount(amount);\n            }\n        }\n    });\n});\n","Magento_Paypal/js/view/amountProviders/checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'uiElement',\n    'uiRegistry',\n    'Magento_Checkout/js/model/quote',\n    'domReady!'\n], function (\n    $,\n    ko,\n    Component,\n    registry,\n    quote\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            amount: null\n        },\n\n        /**\n         * Initialize\n         *\n         * @returns {*}\n         */\n        initialize: function () {\n            this._super();\n\n            this.updateAmount();\n\n            return this;\n        },\n\n        /**\n         * Update amount\n         */\n        updateAmount: function () {\n            var payLater = registry.get(this.parentName);\n\n            quote.totals.subscribe(function (newValue) {\n                payLater.amount(newValue['base_grand_total']);\n            });\n        }\n    });\n});\n","Magento_Paypal/js/in-context/express-checkout-smart-buttons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable max-nested-callbacks */\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_Paypal/js/in-context/paypal-sdk',\n    'Magento_Customer/js/customer-data',\n    'domReady!'\n], function (_, $, paypalSdk, customerData) {\n    'use strict';\n\n    /**\n     * Triggers beforePayment action on PayPal buttons\n     *\n     * @param {Object} clientConfig\n     * @returns {Object} jQuery promise\n     */\n    function performCreateOrder(clientConfig) {\n        var params = {\n            'quote_id': clientConfig.quoteId,\n            'customer_id': clientConfig.customerId || '',\n            'form_key': clientConfig.formKey,\n            button: clientConfig.button\n        };\n\n        return $.Deferred(function (deferred) {\n            clientConfig.rendererComponent.beforePayment(deferred.resolve, deferred.reject).then(function () {\n                $.post(clientConfig.getTokenUrl, params).done(function (res) {\n                    clientConfig.rendererComponent.afterPayment(res, deferred.resolve, deferred.reject);\n                }).fail(function (jqXHR, textStatus, err) {\n                    clientConfig.rendererComponent.catchPayment(err, deferred.resolve, deferred.reject);\n                });\n            });\n        }).promise();\n    }\n\n    /**\n     * Triggers beforeOnAuthorize action on PayPal buttons\n     * @param {Object} clientConfig\n     * @param {Object} data\n     * @param {Object} actions\n     * @returns {Object} jQuery promise\n     */\n    function performOnApprove(clientConfig, data, actions) {\n        var params = {\n            paymentToken: data.orderID,\n            payerId: data.payerID,\n            paypalFundingSource: customerData.get('paypal-funding-source'),\n            'form_key': clientConfig.formKey\n        };\n\n        return $.Deferred(function (deferred) {\n            clientConfig.rendererComponent.beforeOnAuthorize(deferred.resolve, deferred.reject, actions)\n                .then(function () {\n                    $.post(clientConfig.onAuthorizeUrl, params).done(function (res) {\n                        if (res.success === false) {\n                            clientConfig.rendererComponent.catchOnAuthorize(res, deferred.resolve, deferred.reject);\n                            return;\n                        }\n                        clientConfig.rendererComponent\n                            .afterOnAuthorize(res, deferred.resolve, deferred.reject, actions);\n                        customerData.set('paypal-funding-source', '');\n                    }).fail(function (jqXHR, textStatus, err) {\n                        clientConfig.rendererComponent.catchOnAuthorize(err, deferred.resolve, deferred.reject);\n                        customerData.set('paypal-funding-source', '');\n                    });\n                });\n        }).promise();\n    }\n\n    return function (clientConfig, element) {\n        paypalSdk(clientConfig.sdkUrl, clientConfig.dataAttributes).done(function (paypal) {\n            paypal.Buttons({\n                style: clientConfig.styles,\n\n                /**\n                 * onInit is called when the button first renders\n                 * @param {Object} data\n                 * @param {Object} actions\n                 */\n                onInit: function (data, actions) {\n                    clientConfig.rendererComponent.validate(actions);\n                },\n\n                /**\n                 * Triggers beforePayment action on PayPal buttons\n                 * @returns {Object} jQuery promise\n                 */\n                createOrder: function () {\n                    return performCreateOrder(clientConfig);\n                },\n\n                /**\n                 * Triggers beforeOnAuthorize action on PayPal buttons\n                 * @param {Object} data\n                 * @param {Object} actions\n                 */\n                onApprove: function (data, actions) {\n                    performOnApprove(clientConfig, data, actions);\n                },\n\n                /**\n                 * Execute logic on Paypal button click\n                 */\n                onClick: function (data) {\n                    customerData.set('paypal-funding-source', data.fundingSource);\n                    clientConfig.rendererComponent.validate();\n                    clientConfig.rendererComponent.onClick();\n                },\n\n                /**\n                 * Process cancel action\n                 * @param {Object} data\n                 * @param {Object} actions\n                 */\n                onCancel: function (data, actions) {\n                    clientConfig.rendererComponent.onCancel(data, actions);\n                },\n\n                /**\n                 * Process errors\n                 *\n                 * @param {Error} err\n                 */\n                onError: function (err) {\n                    clientConfig.rendererComponent.onError(err);\n                }\n            }).render(element);\n        });\n    };\n});\n","Magento_Paypal/js/in-context/product-express-checkout.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'uiComponent',\n    'Magento_Paypal/js/in-context/express-checkout-wrapper',\n    'Magento_Customer/js/customer-data'\n], function (_, $, Component, Wrapper, customerData) {\n    'use strict';\n\n    return Component.extend(Wrapper).extend({\n        defaults: {\n            productFormSelector: '#product_addtocart_form',\n            declinePayment: false,\n            formInvalid: false,\n            productAddedToCart: false\n        },\n\n        /** @inheritdoc */\n        initialize: function (config, element) {\n            var cart = customerData.get('cart'),\n                customer = customerData.get('customer'),\n                isGuestCheckoutAllowed;\n\n            this._super();\n\n            isGuestCheckoutAllowed = cart().isGuestCheckoutAllowed;\n\n            if (typeof isGuestCheckoutAllowed === 'undefined') {\n                isGuestCheckoutAllowed = config.clientConfig.isGuestCheckoutAllowed;\n            }\n\n            if (config.clientConfig.isVisibleOnProductPage) {\n                this.renderPayPalButtons(element);\n            }\n\n            this.declinePayment = !customer().firstname && !isGuestCheckoutAllowed;\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        onClick: function () {\n            var $form = $(this.productFormSelector);\n\n            if (!this.declinePayment && !this.productAddedToCart) {\n                $form.trigger('submit');\n                this.formInvalid = !$form.validation('isValid');\n                this.productAddedToCart = true;\n            }\n        },\n\n        /** @inheritdoc */\n        beforePayment: function (resolve, reject) {\n            var promise = $.Deferred();\n\n            if (this.declinePayment) {\n                this.addError(this.signInMessage, 'warning');\n                reject();\n            } else if (this.formInvalid) {\n                reject();\n            } else {\n                $(document).on('ajax:addToCart', function (e, data) {\n                    if (_.isEmpty(data.response)) {\n                        return promise.resolve();\n                    }\n\n                    return reject();\n                });\n                $(document).on('ajax:addToCart:error', reject);\n            }\n\n            return promise;\n        },\n\n        /**\n         * After payment execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         *\n         * @return {*}\n         */\n        afterPayment: function (res, resolve, reject) {\n            if (res.success) {\n                return resolve(res.token);\n            }\n\n            this.addAlert(res['error_message']);\n\n            return reject(new Error(res['error_message']));\n        },\n\n        /** @inheritdoc */\n        prepareClientConfig: function () {\n            this._super();\n            this.clientConfig.quoteId = '';\n            this.clientConfig.customerId = '';\n\n            return this.clientConfig;\n        },\n\n        /** @inheritdoc */\n        onError: function (err) {\n            this.productAddedToCart = false;\n            this._super(err);\n        },\n\n        /** @inheritdoc */\n        onCancel: function (data, actions) {\n            this.productAddedToCart = false;\n            this._super(data, actions);\n        },\n\n        /** @inheritdoc */\n        afterOnAuthorize: function (res, resolve, reject, actions) {\n            this.productAddedToCart = false;\n\n            return this._super(res, resolve, reject, actions);\n        }\n    });\n});\n","Magento_Paypal/js/in-context/express-checkout-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Customer/js/customer-data',\n    'Magento_Paypal/js/in-context/express-checkout-smart-buttons',\n    'Magento_Ui/js/modal/alert',\n    'mage/cookies'\n], function ($, $t, customerData, checkoutSmartButtons, alert) {\n    'use strict';\n\n    return {\n        defaults: {\n            paymentActionError: $t('Something went wrong with your request. Please try again later.'),\n            signInMessage: $t('To check out, please sign in with your email address.')\n        },\n\n        /**\n         * Render PayPal buttons using checkout.js\n         */\n        renderPayPalButtons: function (element) {\n            checkoutSmartButtons(this.prepareClientConfig(), element);\n        },\n\n        /**\n         * Validate payment method\n         *\n         * @param {Object} actions\n         */\n        validate: function (actions) {\n            this.actions = actions || this.actions;\n        },\n\n        /**\n         * Execute logic on Paypal button click\n         */\n        onClick: function () {},\n\n        /**\n         * Before payment execute\n         *\n         * @param {Function} resolve\n         * @param {Function} reject\n         * @return {*}\n         */\n        beforePayment: function (resolve, reject) { //eslint-disable-line no-unused-vars\n            return $.Deferred().resolve();\n        },\n\n        /**\n         * After payment execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         *\n         * @return {*}\n         */\n        afterPayment: function (res, resolve, reject) {\n\n            if (res.success) {\n                return resolve(res.token);\n            }\n\n            return reject(new Error(res['error_message']));\n        },\n\n        /**\n         * Catch payment\n         *\n         * @param {Error} err\n         * @param {Function} resolve\n         * @param {Function} reject\n         */\n        catchPayment: function (err, resolve, reject) {\n            this.addAlert(this.paymentActionError);\n            reject(err);\n        },\n\n        /**\n         * Before onAuthorize execute\n         *\n         * @param {Function} resolve\n         * @param {Function} reject\n         * @param {Object} actions\n         *\n         * @return {jQuery.Deferred}\n         */\n        beforeOnAuthorize: function (resolve, reject, actions) { //eslint-disable-line no-unused-vars\n            //display loading widget.\n            $('body').trigger('processStart');\n\n            return $.Deferred().resolve();\n        },\n\n        /**\n         * After onAuthorize execute\n         *\n         * @param {Object} res\n         * @param {Function} resolve\n         * @param {Function} reject\n         * @param {Object} actions\n         *\n         * @return {*}\n         */\n        afterOnAuthorize: function (res, resolve, reject, actions) {\n            $('body').trigger('processStop');\n\n            if (res.success) {\n                resolve();\n\n                return actions.redirect(res.redirectUrl);\n            }\n\n            return reject(new Error(res['error_message']));\n        },\n\n        /**\n         * Catch payment\n         *\n         * @param {Error} err\n         * @param {Function} resolve\n         * @param {Function} reject\n         */\n        catchOnAuthorize: function (err, resolve, reject) {\n            $('body').trigger('processStop');\n            this.addAlert(this.paymentActionError);\n            reject(err);\n        },\n\n        /**\n         * Process cancel action\n         *\n         * @param {Object} data\n         * @param {Object} actions\n         */\n        onCancel: function (data, actions) {\n            $('body').trigger('processStop');\n            actions.redirect(this.clientConfig.onCancelUrl);\n        },\n\n        /**\n         * Process errors\n         *\n         * @param {Error} err\n         */\n        onError: function (err) { //eslint-disable-line no-unused-vars\n            // Uncaught error isn't displayed in the console\n        },\n\n        /**\n         * Adds error message\n         *\n         * @param {String} message\n         * @param {String} [type]\n         */\n        addError: function (message, type) {\n            type = type || 'error';\n            customerData.set('messages', {\n                messages: [{\n                    type: type,\n                    text: message\n                }],\n                'data_id': Math.floor(Date.now() / 1000)\n            });\n        },\n\n        /**\n         * Add alert message\n         *\n         * @param {String} message\n         */\n        addAlert: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * @returns {String}\n         */\n        getButtonId: function () {\n            return this.inContextId;\n        },\n\n        /**\n         * Populate client config with all required data\n         *\n         * @return {Object}\n         */\n        prepareClientConfig: function () {\n            this.clientConfig.rendererComponent = this;\n            this.clientConfig.formKey = $.mage.cookies.get('form_key');\n\n            return this.clientConfig;\n        }\n    };\n});\n","Magento_Paypal/js/in-context/billing-agreement.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Customer/js/customer-data'\n], function ($, confirm, customerData) {\n    'use strict';\n\n    $.widget('mage.billingAgreement', {\n        options: {\n            invalidateOnLoad: false,\n            cancelButtonSelector: '.block-billing-agreements-view button.cancel',\n            cancelMessage: '',\n            cancelUrl: ''\n        },\n\n        /**\n         * Initialize billing agreements events\n         * @private\n         */\n        _create: function () {\n            var self = this;\n\n            if (this.options.invalidateOnLoad) {\n                this.invalidate();\n            }\n            $(this.options.cancelButtonSelector).on('click', function () {\n                confirm({\n                    content: self.options.cancelMessage,\n                    actions: {\n                        /**\n                         * 'Confirm' action handler.\n                         */\n                        confirm: function () {\n                            self.invalidate();\n                            window.location.href = self.options.cancelUrl;\n                        }\n                    }\n                });\n\n                return false;\n            });\n        },\n\n        /**\n         * clear paypal billing agreement customer data\n         * @returns void\n         */\n        invalidate: function () {\n            customerData.invalidate(['paypal-billing-agreement']);\n        }\n    });\n\n    return $.mage.billingAgreement;\n});\n","Magento_Paypal/js/in-context/button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Paypal/js/in-context/express-checkout-wrapper',\n    'Magento_Customer/js/customer-data'\n], function (Component, $, Wrapper, customerData) {\n    'use strict';\n\n    return Component.extend(Wrapper).extend({\n        defaults: {\n            declinePayment: false\n        },\n\n        /** @inheritdoc */\n        initialize: function (config, element) {\n            var cart = customerData.get('cart'),\n                customer = customerData.get('customer');\n\n            this._super();\n            this.renderPayPalButtons(element);\n\n            if (cart().isGuestCheckoutAllowed === undefined) {\n                cart.subscribe(function (updatedCart) {\n                    this.declinePayment = !customer().firstname && !cart().isGuestCheckoutAllowed;\n\n                    return updatedCart;\n                }.bind(this));\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        beforePayment: function (resolve, reject) {\n            var promise = $.Deferred();\n\n            if (this.declinePayment) {\n                this.addError(this.signInMessage, 'warning');\n\n                reject();\n            } else {\n                promise.resolve();\n            }\n\n            return promise;\n        },\n\n        /** @inheritdoc */\n        prepareClientConfig: function () {\n            this._super();\n\n            return this.clientConfig;\n        }\n    });\n});\n","Magento_Paypal/js/in-context/paypal-sdk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var dfd = $.Deferred();\n\n    /**\n     * Loads the PayPal SDK object\n     * @param {String} paypalUrl - the url of the PayPal SDK\n     * @param {Array} dataAttributes - Array of the Attributes for PayPal SDK Script tag\n     */\n    return function loadPaypalScript(paypalUrl, dataAttributes) {\n        //configuration for loaded PayPal script\n        require.config({\n            paths: {\n                paypalSdk: paypalUrl\n            },\n            shim: {\n                paypalSdk: {\n                    exports: 'paypal'\n                }\n            },\n            attributes: {\n                'paypalSdk': dataAttributes\n            },\n\n            /**\n             * Add attributes under Paypal SDK Script tag\n             */\n            onNodeCreated: function (node, config, name) {\n                if (config.attributes && config.attributes[name]) {\n                    $.each(dataAttributes, function (index, elem) {\n                        node.setAttribute(index, elem);\n                    });\n                }\n            }\n        });\n\n        if (dfd.state() !== 'resolved') {\n            require(['paypalSdk'], function (paypalObject) {\n                dfd.resolve(paypalObject);\n            });\n        }\n\n        return dfd.promise();\n    };\n});\n","Magento_Review/js/process-reviews.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'tabs',\n    'collapsible'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {String} url\n     * @param {*} fromPages\n     */\n    function processReviews(url, fromPages) {\n        $.ajax({\n            url: url,\n            cache: true,\n            dataType: 'html',\n            showLoader: false,\n            loaderContext: $('.product.data.items')\n        }).done(function (data) {\n            $('#product-review-container').html(data).trigger('contentUpdated');\n            $('[data-role=\"product-review\"] .pages a').each(function (index, element) {\n                $(element).on('click', function (event) { //eslint-disable-line max-nested-callbacks\n                    processReviews($(element).attr('href'), true);\n                    event.preventDefault();\n                });\n            });\n        }).always(function () {\n            if (fromPages == true) { //eslint-disable-line eqeqeq\n                $('html, body').animate({\n                    scrollTop: $('#reviews').offset().top - 50\n                }, 300);\n            }\n        });\n    }\n\n    return function (config) {\n        var reviewTab = $(config.reviewsTabSelector),\n            requiredReviewTabRole = 'tab';\n\n        if (reviewTab.attr('role') === requiredReviewTabRole && reviewTab.hasClass('active')) {\n            processReviews(config.productReviewUrl, location.hash === '#reviews');\n        } else {\n            reviewTab.one('beforeOpen', function () {\n                processReviews(config.productReviewUrl);\n            });\n        }\n\n        $(function () {\n            $('.product-info-main .reviews-actions a').on('click', function (event) {\n                var anchor, addReviewBlock;\n\n                event.preventDefault();\n                anchor = $(this).attr('href').replace(/^.*?(#|$)/, '');\n                addReviewBlock = $('#' + anchor);\n\n                if (addReviewBlock.length) {\n                    $('.product.data.items [data-role=\"content\"]').each(function (index) { //eslint-disable-line\n                        if (this.id == 'reviews') { //eslint-disable-line eqeqeq\n                            $('.product.data.items').tabs('activate', index);\n                        }\n                    });\n                    $('html, body').animate({\n                        scrollTop: addReviewBlock.offset().top - 50\n                    }, 300);\n                }\n\n            });\n        });\n    };\n});\n","Magento_Review/js/submit-review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).on('submit', function () {\n            if ($(this).valid()) {\n                $(this).find('.submit').attr('disabled', true);\n            }\n        });\n    };\n});\n","Magento_Review/js/error-placement.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).mage('validation', {\n            /** @inheritdoc */\n            errorPlacement: function (error, el) {\n\n                if (el.parents('#product-review-table').length) {\n                    $('#product-review-table').siblings(this.errorElement + '.' + this.errorClass).remove();\n                    $('#product-review-table').after(error);\n                } else {\n                    el.after(error);\n                }\n            }\n        });\n    };\n});\n","Magento_Review/js/validate-review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/validate',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    $.validator.addMethod(\n        'rating-required', function (value) {\n            return value !== undefined;\n        }, $.mage.__('Please select one of each of the ratings above.'));\n});\n","Magento_Review/js/view/review.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Customer/js/customer-data',\n    'Magento_Customer/js/view/customer'\n], function (Component, customerData) {\n    'use strict';\n\n    return Component.extend({\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.review = customerData.get('review').extend({\n                disposableCustomerData: 'review'\n            });\n        },\n\n        /**\n         * @return {*}\n         */\n        nickname: function () {\n            return this.review().nickname || customerData.get('customer')().firstname;\n        }\n    });\n});\n","Magento_Csp/js/sri.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire.config({\n    onNodeCreated: function (node, config, moduleName, url) {\n        'use strict';\n        if ('sriHashes' in window && url in window.sriHashes) {\n            node.setAttribute('integrity', window.sriHashes[url]);\n            node.setAttribute('crossorigin', 'anonymous');\n        }\n    }\n});\n","Smile_ElasticsuiteCore/js/MutationObserver.js":"/**\n * @license\n * Copyright (c) 2014 The Polymer Project Authors. All rights reserved.\n * This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt\n * The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt\n * The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt\n * Code distributed by Google as part of the polymer project is also\n * subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt\n */\n\n(function(global) {\n\n    var registrationsTable = new WeakMap();\n\n    var setImmediate;\n\n    // As much as we would like to use the native implementation, IE\n    // (all versions) suffers a rather annoying bug where it will drop or defer\n    // callbacks when heavy DOM operations are being performed concurrently.\n    //\n    // For a thorough discussion on this, see:\n    // http://codeforhire.com/2013/09/21/setimmediate-and-messagechannel-broken-on-internet-explorer-10/\n    if (/Trident|Edge/.test(navigator.userAgent)) {\n        // Sadly, this bug also affects postMessage and MessageQueues.\n        //\n        // We would like to use the onreadystatechange hack for IE <= 10, but it is\n        // dangerous in the polyfilled environment due to requiring that the\n        // observed script element be in the document.\n        setImmediate = setTimeout;\n\n        // If some other browser ever implements it, let's prefer their native\n        // implementation:\n    } else if (window.setImmediate) {\n        setImmediate = window.setImmediate;\n\n        // Otherwise, we fall back to postMessage as a means of emulating the next\n        // task semantics of setImmediate.\n    } else {\n        var setImmediateQueue = [];\n        var sentinel = String(Math.random());\n        window.addEventListener('message', function(e) {\n            if (e.data === sentinel) {\n                var queue = setImmediateQueue;\n                setImmediateQueue = [];\n                queue.forEach(function(func) {\n                    func();\n                });\n            }\n        });\n        setImmediate = function(func) {\n            setImmediateQueue.push(func);\n            window.postMessage(sentinel, '*');\n        };\n    }\n\n    // This is used to ensure that we never schedule 2 callas to setImmediate\n    var isScheduled = false;\n\n    // Keep track of observers that needs to be notified next time.\n    var scheduledObservers = [];\n\n    /**\n     * Schedules |dispatchCallback| to be called in the future.\n     * @param {MutationObserver} observer\n     */\n    function scheduleCallback(observer) {\n        scheduledObservers.push(observer);\n        if (!isScheduled) {\n            isScheduled = true;\n            setImmediate(dispatchCallbacks);\n        }\n    }\n\n    function wrapIfNeeded(node) {\n        return window.ShadowDOMPolyfill &&\n            window.ShadowDOMPolyfill.wrapIfNeeded(node) ||\n            node;\n    }\n\n    function dispatchCallbacks() {\n        // http://dom.spec.whatwg.org/#mutation-observers\n\n        isScheduled = false; // Used to allow a new setImmediate call above.\n\n        var observers = scheduledObservers;\n        scheduledObservers = [];\n        // Sort observers based on their creation UID (incremental).\n        observers.sort(function(o1, o2) {\n            return o1.uid_ - o2.uid_;\n        });\n\n        var anyNonEmpty = false;\n        observers.forEach(function(observer) {\n\n            // 2.1, 2.2\n            var queue = observer.takeRecords();\n            // 2.3. Remove all transient registered observers whose observer is mo.\n            removeTransientObserversFor(observer);\n\n            // 2.4\n            if (queue.length) {\n                observer.callback_(queue, observer);\n                anyNonEmpty = true;\n            }\n        });\n\n        // 3.\n        if (anyNonEmpty)\n            dispatchCallbacks();\n    }\n\n    function removeTransientObserversFor(observer) {\n        observer.nodes_.forEach(function(node) {\n            var registrations = registrationsTable.get(node);\n            if (!registrations)\n                return;\n            registrations.forEach(function(registration) {\n                if (registration.observer === observer)\n                    registration.removeTransientObservers();\n            });\n        });\n    }\n\n    /**\n     * This function is used for the \"For each registered observer observer (with\n     * observer's options as options) in target's list of registered observers,\n     * run these substeps:\" and the \"For each ancestor ancestor of target, and for\n     * each registered observer observer (with options options) in ancestor's list\n     * of registered observers, run these substeps:\" part of the algorithms. The\n     * |options.subtree| is checked to ensure that the callback is called\n     * correctly.\n     *\n     * @param {Node} target\n     * @param {function(MutationObserverInit):MutationRecord} callback\n     */\n    function forEachAncestorAndObserverEnqueueRecord(target, callback) {\n        for (var node = target; node; node = node.parentNode) {\n            var registrations = registrationsTable.get(node);\n\n            if (registrations) {\n                for (var j = 0; j < registrations.length; j++) {\n                    var registration = registrations[j];\n                    var options = registration.options;\n\n                    // Only target ignores subtree.\n                    if (node !== target && !options.subtree)\n                        continue;\n\n                    var record = callback(options);\n                    if (record)\n                        registration.enqueue(record);\n                }\n            }\n        }\n    }\n\n    var uidCounter = 0;\n\n    /**\n     * The class that maps to the DOM MutationObserver interface.\n     * @param {Function} callback.\n     * @constructor\n     */\n    function JsMutationObserver(callback) {\n        this.callback_ = callback;\n        this.nodes_ = [];\n        this.records_ = [];\n        this.uid_ = ++uidCounter;\n    }\n\n    JsMutationObserver.prototype = {\n        observe: function(target, options) {\n            target = wrapIfNeeded(target);\n\n            // 1.1\n            if (!options.childList && !options.attributes && !options.characterData ||\n\n                // 1.2\n                options.attributeOldValue && !options.attributes ||\n\n                // 1.3\n                options.attributeFilter && options.attributeFilter.length &&\n                !options.attributes ||\n\n                // 1.4\n                options.characterDataOldValue && !options.characterData) {\n\n                throw new SyntaxError();\n            }\n\n            var registrations = registrationsTable.get(target);\n            if (!registrations)\n                registrationsTable.set(target, registrations = []);\n\n            // 2\n            // If target's list of registered observers already includes a registered\n            // observer associated with the context object, replace that registered\n            // observer's options with options.\n            var registration;\n            for (var i = 0; i < registrations.length; i++) {\n                if (registrations[i].observer === this) {\n                    registration = registrations[i];\n                    registration.removeListeners();\n                    registration.options = options;\n                    break;\n                }\n            }\n\n            // 3.\n            // Otherwise, add a new registered observer to target's list of registered\n            // observers with the context object as the observer and options as the\n            // options, and add target to context object's list of nodes on which it\n            // is registered.\n            if (!registration) {\n                registration = new Registration(this, target, options);\n                registrations.push(registration);\n                this.nodes_.push(target);\n            }\n\n            registration.addListeners();\n        },\n\n        disconnect: function() {\n            this.nodes_.forEach(function(node) {\n                var registrations = registrationsTable.get(node);\n                for (var i = 0; i < registrations.length; i++) {\n                    var registration = registrations[i];\n                    if (registration.observer === this) {\n                        registration.removeListeners();\n                        registrations.splice(i, 1);\n                        // Each node can only have one registered observer associated with\n                        // this observer.\n                        break;\n                    }\n                }\n            }, this);\n            this.records_ = [];\n        },\n\n        takeRecords: function() {\n            var copyOfRecords = this.records_;\n            this.records_ = [];\n            return copyOfRecords;\n        }\n    };\n\n    /**\n     * @param {string} type\n     * @param {Node} target\n     * @constructor\n     */\n    function MutationRecord(type, target) {\n        this.type = type;\n        this.target = target;\n        this.addedNodes = [];\n        this.removedNodes = [];\n        this.previousSibling = null;\n        this.nextSibling = null;\n        this.attributeName = null;\n        this.attributeNamespace = null;\n        this.oldValue = null;\n    }\n\n    function copyMutationRecord(original) {\n        var record = new MutationRecord(original.type, original.target);\n        record.addedNodes = original.addedNodes.slice();\n        record.removedNodes = original.removedNodes.slice();\n        record.previousSibling = original.previousSibling;\n        record.nextSibling = original.nextSibling;\n        record.attributeName = original.attributeName;\n        record.attributeNamespace = original.attributeNamespace;\n        record.oldValue = original.oldValue;\n        return record;\n    };\n\n    // We keep track of the two (possibly one) records used in a single mutation.\n    var currentRecord, recordWithOldValue;\n\n    /**\n     * Creates a record without |oldValue| and caches it as |currentRecord| for\n     * later use.\n     * @param {string} oldValue\n     * @return {MutationRecord}\n     */\n    function getRecord(type, target) {\n        return currentRecord = new MutationRecord(type, target);\n    }\n\n    /**\n     * Gets or creates a record with |oldValue| based in the |currentRecord|\n     * @param {string} oldValue\n     * @return {MutationRecord}\n     */\n    function getRecordWithOldValue(oldValue) {\n        if (recordWithOldValue)\n            return recordWithOldValue;\n        recordWithOldValue = copyMutationRecord(currentRecord);\n        recordWithOldValue.oldValue = oldValue;\n        return recordWithOldValue;\n    }\n\n    function clearRecords() {\n        currentRecord = recordWithOldValue = undefined;\n    }\n\n    /**\n     * @param {MutationRecord} record\n     * @return {boolean} Whether the record represents a record from the current\n     * mutation event.\n     */\n    function recordRepresentsCurrentMutation(record) {\n        return record === recordWithOldValue || record === currentRecord;\n    }\n\n    /**\n     * Selects which record, if any, to replace the last record in the queue.\n     * This returns |null| if no record should be replaced.\n     *\n     * @param {MutationRecord} lastRecord\n     * @param {MutationRecord} newRecord\n     * @param {MutationRecord}\n     */\n    function selectRecord(lastRecord, newRecord) {\n        if (lastRecord === newRecord)\n            return lastRecord;\n\n        // Check if the record we are adding represents the same record. If\n        // so, we keep the one with the oldValue in it.\n        if (recordWithOldValue && recordRepresentsCurrentMutation(lastRecord))\n            return recordWithOldValue;\n\n        return null;\n    }\n\n    /**\n     * Class used to represent a registered observer.\n     * @param {MutationObserver} observer\n     * @param {Node} target\n     * @param {MutationObserverInit} options\n     * @constructor\n     */\n    function Registration(observer, target, options) {\n        this.observer = observer;\n        this.target = target;\n        this.options = options;\n        this.transientObservedNodes = [];\n    }\n\n    Registration.prototype = {\n        enqueue: function(record) {\n            var records = this.observer.records_;\n            var length = records.length;\n\n            // There are cases where we replace the last record with the new record.\n            // For example if the record represents the same mutation we need to use\n            // the one with the oldValue. If we get same record (this can happen as we\n            // walk up the tree) we ignore the new record.\n            if (records.length > 0) {\n                var lastRecord = records[length - 1];\n                var recordToReplaceLast = selectRecord(lastRecord, record);\n                if (recordToReplaceLast) {\n                    records[length - 1] = recordToReplaceLast;\n                    return;\n                }\n            } else {\n                scheduleCallback(this.observer);\n            }\n\n            records[length] = record;\n        },\n\n        addListeners: function() {\n            this.addListeners_(this.target);\n        },\n\n        addListeners_: function(node) {\n            var options = this.options;\n            if (options.attributes)\n                node.addEventListener('DOMAttrModified', this, true);\n\n            if (options.characterData)\n                node.addEventListener('DOMCharacterDataModified', this, true);\n\n            if (options.childList)\n                node.addEventListener('DOMNodeInserted', this, true);\n\n            if (options.childList || options.subtree)\n                node.addEventListener('DOMNodeRemoved', this, true);\n        },\n\n        removeListeners: function() {\n            this.removeListeners_(this.target);\n        },\n\n        removeListeners_: function(node) {\n            var options = this.options;\n            if (options.attributes)\n                node.removeEventListener('DOMAttrModified', this, true);\n\n            if (options.characterData)\n                node.removeEventListener('DOMCharacterDataModified', this, true);\n\n            if (options.childList)\n                node.removeEventListener('DOMNodeInserted', this, true);\n\n            if (options.childList || options.subtree)\n                node.removeEventListener('DOMNodeRemoved', this, true);\n        },\n\n        /**\n         * Adds a transient observer on node. The transient observer gets removed\n         * next time we deliver the change records.\n         * @param {Node} node\n         */\n        addTransientObserver: function(node) {\n            // Don't add transient observers on the target itself. We already have all\n            // the required listeners set up on the target.\n            if (node === this.target)\n                return;\n\n            this.addListeners_(node);\n            this.transientObservedNodes.push(node);\n            var registrations = registrationsTable.get(node);\n            if (!registrations)\n                registrationsTable.set(node, registrations = []);\n\n            // We know that registrations does not contain this because we already\n            // checked if node === this.target.\n            registrations.push(this);\n        },\n\n        removeTransientObservers: function() {\n            var transientObservedNodes = this.transientObservedNodes;\n            this.transientObservedNodes = [];\n\n            transientObservedNodes.forEach(function(node) {\n                // Transient observers are never added to the target.\n                this.removeListeners_(node);\n\n                var registrations = registrationsTable.get(node);\n                for (var i = 0; i < registrations.length; i++) {\n                    if (registrations[i] === this) {\n                        registrations.splice(i, 1);\n                        // Each node can only have one registered observer associated with\n                        // this observer.\n                        break;\n                    }\n                }\n            }, this);\n        },\n\n        handleEvent: function(e) {\n            // Stop propagation since we are managing the propagation manually.\n            // This means that other mutation events on the page will not work\n            // correctly but that is by design.\n            e.stopImmediatePropagation();\n\n            switch (e.type) {\n                case 'DOMAttrModified':\n                    // http://dom.spec.whatwg.org/#concept-mo-queue-attributes\n\n                    var name = e.attrName;\n                    var namespace = e.relatedNode.namespaceURI;\n                    var target = e.target;\n\n                    // 1.\n                    var record = new getRecord('attributes', target);\n                    record.attributeName = name;\n                    record.attributeNamespace = namespace;\n\n                    // 2.\n                    var oldValue =\n                            e.attrChange === MutationEvent.ADDITION ? null : e.prevValue;\n\n                    forEachAncestorAndObserverEnqueueRecord(target, function(options) {\n                        // 3.1, 4.2\n                        if (!options.attributes)\n                            return;\n\n                        // 3.2, 4.3\n                        if (options.attributeFilter && options.attributeFilter.length &&\n                            options.attributeFilter.indexOf(name) === -1 &&\n                            options.attributeFilter.indexOf(namespace) === -1) {\n                            return;\n                        }\n                        // 3.3, 4.4\n                        if (options.attributeOldValue)\n                            return getRecordWithOldValue(oldValue);\n\n                        // 3.4, 4.5\n                        return record;\n                    });\n\n                    break;\n\n                case 'DOMCharacterDataModified':\n                    // http://dom.spec.whatwg.org/#concept-mo-queue-characterdata\n                    var target = e.target;\n\n                    // 1.\n                    var record = getRecord('characterData', target);\n\n                    // 2.\n                    var oldValue = e.prevValue;\n\n\n                    forEachAncestorAndObserverEnqueueRecord(target, function(options) {\n                        // 3.1, 4.2\n                        if (!options.characterData)\n                            return;\n\n                        // 3.2, 4.3\n                        if (options.characterDataOldValue)\n                            return getRecordWithOldValue(oldValue);\n\n                        // 3.3, 4.4\n                        return record;\n                    });\n\n                    break;\n\n                case 'DOMNodeRemoved':\n                    this.addTransientObserver(e.target);\n                // Fall through.\n                case 'DOMNodeInserted':\n                    // http://dom.spec.whatwg.org/#concept-mo-queue-childlist\n                    var changedNode = e.target;\n                    var addedNodes, removedNodes;\n                    if (e.type === 'DOMNodeInserted') {\n                        addedNodes = [changedNode];\n                        removedNodes = [];\n                    } else {\n\n                        addedNodes = [];\n                        removedNodes = [changedNode];\n                    }\n                    var previousSibling = changedNode.previousSibling;\n                    var nextSibling = changedNode.nextSibling;\n\n                    // 1.\n                    var record = getRecord('childList', e.target.parentNode);\n                    record.addedNodes = addedNodes;\n                    record.removedNodes = removedNodes;\n                    record.previousSibling = previousSibling;\n                    record.nextSibling = nextSibling;\n\n                    forEachAncestorAndObserverEnqueueRecord(e.relatedNode, function(options) {\n                        // 2.1, 3.2\n                        if (!options.childList)\n                            return;\n\n                        // 2.2, 3.3\n                        return record;\n                    });\n\n            }\n\n            clearRecords();\n        }\n    };\n\n    global.JsMutationObserver = JsMutationObserver;\n\n    if (!global.MutationObserver)\n        global.MutationObserver = JsMutationObserver;\n\n\n})(this);\n","Smile_ElasticsuiteCore/js/form-mini.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCore\n * @author    Romain Ruaud <romain.ruaud@smile.fr>\n * @copyright 2020 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\n/*jshint browser:true jquery:true*/\n/*global alert*/\n\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'mage/template',\n    'Magento_Catalog/js/price-utils',\n    'Magento_Ui/js/lib/knockout/template/loader',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'Magento_Search/js/form-mini'\n], function (ko, $, _, mageTemplate, priceUtil, templateLoader) {\n    'use strict';\n\n    $.widget('smileEs.quickSearch', $.mage.quickSearch, {\n        options: {\n            autocomplete: 'off',\n            minSearchLength: 2,\n            responseFieldElements: 'dl dd',\n            selectClass: 'selected',\n            submitBtn: 'button[type=\"submit\"]',\n            searchLabel: '[data-role=minisearch-label]'\n        },\n\n        /**\n         * Overriden constructor to ensure templates initialization on load\n         *\n         * @private\n         */\n        _create: function () {\n            this.templateCache = [];\n            this.currentRequest = null;\n            this._initTemplates();\n            this._initTitleRenderer();\n            this._super();\n            this._blur();\n        },\n\n        /**\n         * Init templates used for rendering when instantiating the widget\n         *\n         * @private\n         */\n        _initTemplates: function() {\n            for (var template in this.options.templates) {\n                if ({}.hasOwnProperty.call(this.options.templates, template)) {\n                    this._loadTemplate(template);\n                }\n            }\n        },\n\n        /**\n         * Init templates used for rendering when instantiating the widget\n         *\n         * @private\n         */\n        _initTitleRenderer: function() {\n            this.titleRenderers = {};\n            for (var typeIdentifier in this.options.templates) {\n                if (this.options.templates[typeIdentifier]['titleRenderer']) {\n                   require([this.options.templates[typeIdentifier]['titleRenderer']], function (renderer) {\n                       this.component.titleRenderers[this.type] = renderer;\n                   }.bind({component: this, type: typeIdentifier}));\n                }\n            }\n        },\n\n        /**\n         * Load a renderer for title when configured for a type.\n         *\n         * @param type The type to render\n         *\n         * @private\n         */\n        _loadTemplate: function (type) {\n            var templateFile = this.options.templates[type]['template'];\n            templateLoader.loadTemplate(templateFile).done(function (renderer) {\n                this.options.templates[type]['template'] = renderer;\n            }.bind(this));\n        },\n\n        /**\n         * Get rendering template for a given element. Will look into this.options.templates[element.type] for the renderer.\n         * Returns an evaluated template for the given element's type.\n         *\n         * @param element The autocomplete result to display\n         *\n         * @returns function\n         *\n         * @private\n         */\n        _getTemplate: function (element) {\n            var source = this.options.template; // Fallback to standard widget template\n            var type   = element.type ? element.type : 'undefined';\n\n            if (this.templateCache[type]) {\n                return this.templateCache[type];\n            }\n\n            if (element.type && this.options.templates && this.options.templates[element.type]) {\n                source = this.options.templates[element.type].template;\n            }\n\n            this.templateCache[type] = mageTemplate(source);\n\n            return this.templateCache[type];\n        },\n\n        /**\n         * Render an autocomplete item in the result list\n         *\n         * @param element The element : an autocomplete result\n         * @param index   The element index\n         *\n         * @returns {*|jQuery|HTMLElement}\n         *\n         * @private\n         */\n        _renderItem: function (element, index) {\n            var template = this._getTemplate(element);\n            element.index = index;\n\n            if (element.price && (!isNaN(element.price))) {\n                element.price = priceUtil.formatPrice(element.price, this.options.priceFormat);\n            }\n\n            return template({\n                data: element\n            });\n        },\n\n        /**\n         * Return the wrapper for all autocomplete results\n         *\n         * @returns {*|jQuery|HTMLElement}\n         *\n         * @private\n         */\n        _getResultWrapper: function () {\n            return $('<div class=\"smile-elasticsuite-autocomplete-result\"></div>');\n        },\n\n        /**\n         * Return the header for an autocomplete result section\n         *\n         * @param type The type of element to display\n         *\n         * @returns {*|jQuery|HTMLElement}\n         *\n         * @private\n         */\n        _getSectionHeader: function(type, data) {\n            var title = '';\n            var header = $('<dl role=\"listbox\" class=\"autocomplete-list\"></dl>');\n\n            if (type !== undefined) {\n                title = this._getSectionTitle(type, data);\n                header.append(title);\n            }\n\n            return header;\n        },\n\n        /**\n         * Return the title for an autocomplete result section\n         *\n         * @param type\n         *\n         * @returns {*|jQuery|HTMLElement}\n         *\n         * @private\n         */\n        _getSectionTitle: function(type, data) {\n            var title = '';\n\n            if (this.titleRenderers && this.titleRenderers[type]) {\n                title = $('<dt role=\"listbox\" class=\"autocomplete-list-title title-' + type + '\">' + this.titleRenderers[type].render(data) + '</dt>');\n            } else if (this.options.templates && this.options.templates[type].title) {\n                title = $('<dt role=\"listbox\" class=\"autocomplete-list-title title-' + type + '\">' + this.options.templates[type].title + '</dt>');\n            }\n\n            return title;\n        },\n\n        /**\n         * Check wether the incoming string is not empty or if doesn't consist of spaces.\n         *\n         * @param {String} value - Value to check.\n         *\n         * @returns {Boolean}\n         *\n         * @private\n         */\n        _isEmpty : function(value) {\n            return value === null || value.trim().length === 0;\n        },\n\n        /**\n         * Executes when the value of the search input field changes. Executes a GET request\n         * to populate a suggestion list based on entered text. Handles click (select), hover,\n         * and mouseout events on the populated suggestion list dropdown.\n         *\n         * Overriden to :\n         *  - move rendering of elements in a subfunction.\n         *  - manage redirection when clicking a result having an href attribute.\n         *\n         * @private\n         */\n        _onPropertyChange: _.debounce(function () {\n            var searchField = this.element,\n                clonePosition = {\n                    position: 'absolute',\n                    // Removed to fix display issues\n                    // left: searchField.offset().left,\n                    // top: searchField.offset().top + searchField.outerHeight(),\n                    width: searchField.outerWidth()\n                },\n                value = this.element.val();\n\n            this.submitBtn.disabled = this._isEmpty(value);\n\n            if (value.trim().length >= parseInt(this.options.minSearchLength, 10)) {\n                this.searchForm.addClass('processing');\n                this.currentRequest = $.ajax({\n                    method: \"GET\",\n                    url: this.options.url,\n                    cache: true,\n                    dataType: 'json',\n                    data: {q: value},\n                    // This function will ensure proper killing of the last Ajax call.\n                    // In order to prevent requests of an old request to pop up later and replace results.\n                    beforeSend: function() { if (this.currentRequest !== null) { this.currentRequest.abort(); }}.bind(this),\n                    success: $.proxy(function (data) {\n                        var self = this;\n                        var lastElement = false;\n                        var content = this._getResultWrapper();\n                        var sectionDropdown = this._getSectionHeader();\n                        $.each(data, function(index, element) {\n\n                            if (!lastElement || (lastElement && lastElement.type !== element.type)) {\n                                sectionDropdown = this._getSectionHeader(element.type, data);\n                            }\n\n                            var elementHtml = this._renderItem(element, index);\n\n                            sectionDropdown.append(elementHtml);\n\n                            if (!lastElement || (lastElement && lastElement.type !== element.type)) {\n                                content.append(sectionDropdown);\n                            }\n\n                            lastElement = element;\n                        }.bind(this));\n                        this.responseList.indexList = this.autoComplete.html(content)\n                            .css(clonePosition)\n                            .show()\n                            .find(this.options.responseFieldElements + ':visible');\n\n                        this._resetResponseList(false);\n                        this.element.removeAttr('aria-activedescendant');\n\n                        if (this.responseList.indexList.length) {\n                            this._updateAriaHasPopup(true);\n                        } else {\n                            this._updateAriaHasPopup(false);\n                        }\n\n                        this.responseList.indexList\n                            .on('click vclick', function (e) {\n                                self.responseList.selected = $(this);\n                                if (self.responseList.selected.attr(\"href\")) {\n                                    window.location.href = self.responseList.selected.attr(\"href\");\n                                    e.stopPropagation();\n                                    return false;\n                                }\n                                self.searchForm.trigger('submit');\n                            })\n                            .on('mouseenter', function (e) {\n                                self.responseList.indexList.removeClass(self.options.selectClass);\n                                $(this).addClass(self.options.selectClass);\n                                self.responseList.selected = $(e.target);\n                                self.element.attr('aria-activedescendant', $(e.target).attr('id'));\n                            })\n                            .on('mouseleave', function (e) {\n                                $(this).removeClass(self.options.selectClass);\n                                self._resetResponseList(false);\n                            })\n                            .on('mouseout', function () {\n                                if (!self._getLastElement() && self._getLastElement().hasClass(self.options.selectClass)) {\n                                    $(this).removeClass(self.options.selectClass);\n                                    self._resetResponseList(false);\n                                }\n                            });\n                    },this),\n                    complete : $.proxy(function () {\n                        this.searchForm.removeClass('processing');\n                    }, this)\n                });\n            } else {\n                this._resetResponseList(true);\n                this.autoComplete.hide();\n                this._updateAriaHasPopup(false);\n                this.element.removeAttr('aria-activedescendant');\n            }\n        }, 250),\n\n        /**\n         * Executes when keys are pressed in the search input field. Performs specific actions\n         * depending on which keys are pressed.\n         *\n         * @private\n         * @param {Event} e - The key down event\n         * @return {Boolean} Default return type for any unhandled keys\n         */\n        _onKeyDown: function (e) {\n            var keyCode = e.keyCode || e.which;\n\n            switch (keyCode) {\n                case $.ui.keyCode.HOME:\n                    this._selectElement(this._getFirstVisibleElement());\n                    break;\n                case $.ui.keyCode.END:\n                    this._selectElement(this._getLastElement());\n                    break;\n                case $.ui.keyCode.ESCAPE:\n                    this._resetResponseList(true);\n                    this.autoComplete.hide();\n                    break;\n                case $.ui.keyCode.ENTER:\n                    this._validateElement(e);\n                    break;\n                case $.ui.keyCode.DOWN:\n                    this._navigateDown();\n                    break;\n                case $.ui.keyCode.UP:\n                    this._navigateUp();\n                    break;\n                default:\n                    return true;\n            }\n        },\n\n        /**\n         * Validate selection of an element (eg : when ENTER is pressed)\n         *\n         * @param event The keydown event\n         *\n         * @returns {boolean}\n         *\n         * @private\n         */\n        _validateElement: function(event) {\n            var selected = this.responseList.selected;\n            if (selected && selected.attr('href') !== undefined) {\n                window.location = selected.attr('href');\n                event.preventDefault();\n                return false;\n            }\n            this.searchForm.trigger('submit');\n        },\n\n        /**\n         * Process down navigation on autocomplete box\n         *\n         * @private\n         */\n        _navigateDown: function() {\n            if (this.responseList.indexList) {\n                if (!this.responseList.selected) {\n                    this._getFirstVisibleElement().addClass(this.options.selectClass);\n                    this.responseList.selected = this._getFirstVisibleElement();\n                }\n                else if (!this._getLastElement().hasClass(this.options.selectClass)) {\n                    var nextElement = this._getNextElement();\n                    this.responseList.selected.removeClass(this.options.selectClass);\n                    this.responseList.selected = nextElement.addClass(this.options.selectClass);\n                } else {\n                    this.responseList.selected.removeClass(this.options.selectClass);\n                    this._getFirstVisibleElement().addClass(this.options.selectClass);\n                    this.responseList.selected = this._getFirstVisibleElement();\n                }\n                this._activateElement();\n            }\n        },\n\n        /**\n         * Process up navigation on autocomplete box\n         *\n         * @private\n         */\n        _navigateUp: function() {\n            if (this.responseList.indexList !== null) {\n                if (!this._getFirstVisibleElement().hasClass(this.options.selectClass)) {\n                    var prevElement = this._getPrevElement();\n                    this.responseList.selected.removeClass(this.options.selectClass);\n                    this.responseList.selected = prevElement.addClass(this.options.selectClass);\n                } else {\n                    this.responseList.selected.removeClass(this.options.selectClass);\n                    this._getLastElement().addClass(this.options.selectClass);\n                    this.responseList.selected = this._getLastElement();\n                }\n                this._activateElement();\n            }\n        },\n\n        /**\n         * Toggles an element as currently selected\n         *\n         * @param {Element} e - The DOM element\n         *\n         * @private\n         */\n        _selectElement: function(element) {\n            element.addClass(this.options.selectClass);\n            this.responseList.selected = element;\n        },\n\n        /**\n         * Toggles an element as active\n         *\n         * @param {Element} e - The DOM element\n         *\n         * @private\n         */\n        _activateElement: function() {\n            this.element.val(this.responseList.selected.find('.qs-option-name').text());\n            this.element.attr('aria-activedescendant', this.responseList.selected.attr('id'));\n        },\n\n        /**\n         * Retrieve the next element when navigating through keyboard\n         *\n         * @private\n         *\n         * @return Element\n         */\n        _getNextElement: function() {\n            var nextElement = this.responseList.selected.next('dd');\n            if (nextElement.length === 0) {\n                nextElement = this.responseList.selected.parent('dl').next('dl').find('dd').first();\n            }\n\n            return nextElement;\n        },\n\n        /**\n         * Retrieve the previous element when navigating through keyboard\n         *\n         * @private\n         *\n         * @return Element\n         */\n        _getPrevElement: function() {\n            var prevElement = this.responseList.selected.prev('dd');\n            this.responseList.selected.removeClass(this.options.selectClass);\n            if (prevElement.length === 0) {\n                prevElement = this.responseList.selected.parent('dl').prev('dl').find('dd').last();\n            }\n\n            return prevElement;\n        },\n\n        /**\n         * Handle blur event of search input item\n         * @private\n         */\n        _blur: function() {\n            this.element.on('blur', $.proxy(function () {\n                if (!this.searchLabel.hasClass('active')) {\n                    return;\n                }\n                setTimeout($.proxy(function () {\n                    if (this.autoComplete.is(':hidden')) {\n                        this.setActiveState(false);\n                    } else {\n                        this.element.trigger('focus');\n                    }\n                    this.autoComplete.hide();\n                    $('#search').trigger('blur');\n                    this._updateAriaHasPopup(false);\n                }, this),250);\n            }, this));\n        }\n    });\n\n    return $.smileEs.quickSearch;\n});\n","Smile_ElasticsuiteCore/js/validation/validator-mixin.js":"/**\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer\n * versions in the future.\n *\n * @category  Smile\n * @package   Smile\\ElasticsuiteCore\n * @author    Botis <botis@smile.fr>\n * @copyright 2021 Smile\n * @license   Open Software License (\"OSL\") v. 3.0\n */\n\ndefine(['jquery'], function ($) {\n    'use strict';\n\n    return function (validator) {\n        validator.addRule(\n            'not-zero',\n            function (value, element) {\n                return parseInt(value) !== 0;\n            },\n            $.mage.__('The value should be different to zero.')\n        );\n\n        return validator;\n    }\n});\n\n","Hyva_Theme/js/alpine3.min.js":"(()=>{var nt=!1,it=!1,W=[],ot=-1;function Ut(e){Rn(e)}function Rn(e){W.includes(e)||W.push(e),Mn()}function Wt(e){let t=W.indexOf(e);t!==-1&&t>ot&&W.splice(t,1)}function Mn(){!it&&!nt&&(nt=!0,queueMicrotask(Nn))}function Nn(){nt=!1,it=!0;for(let e=0;e<W.length;e++)W[e](),ot=e;W.length=0,ot=-1,it=!1}var T,N,$,at,st=!0;function Gt(e){st=!1,e(),st=!0}function Jt(e){T=e.reactive,$=e.release,N=t=>e.effect(t,{scheduler:r=>{st?Ut(r):r()}}),at=e.raw}function ct(e){N=e}function Yt(e){let t=()=>{};return[n=>{let i=N(n);return e._x_effects||(e._x_effects=new Set,e._x_runEffects=()=>{e._x_effects.forEach(o=>o())}),e._x_effects.add(i),t=()=>{i!==void 0&&(e._x_effects.delete(i),$(i))},i},()=>{t()}]}function ve(e,t){let r=!0,n,i=N(()=>{let o=e();JSON.stringify(o),r?n=o:queueMicrotask(()=>{t(o,n),n=o}),r=!1});return()=>$(i)}var Xt=[],Zt=[],Qt=[];function er(e){Qt.push(e)}function te(e,t){typeof t==\"function\"?(e._x_cleanups||(e._x_cleanups=[]),e._x_cleanups.push(t)):(t=e,Zt.push(t))}function Ae(e){Xt.push(e)}function Oe(e,t,r){e._x_attributeCleanups||(e._x_attributeCleanups={}),e._x_attributeCleanups[t]||(e._x_attributeCleanups[t]=[]),e._x_attributeCleanups[t].push(r)}function lt(e,t){e._x_attributeCleanups&&Object.entries(e._x_attributeCleanups).forEach(([r,n])=>{(t===void 0||t.includes(r))&&(n.forEach(i=>i()),delete e._x_attributeCleanups[r])})}function tr(e){for(e._x_effects?.forEach(Wt);e._x_cleanups?.length;)e._x_cleanups.pop()()}var ut=new MutationObserver(mt),ft=!1;function ue(){ut.observe(document,{subtree:!0,childList:!0,attributes:!0,attributeOldValue:!0}),ft=!0}function dt(){kn(),ut.disconnect(),ft=!1}var le=[];function kn(){let e=ut.takeRecords();le.push(()=>e.length>0&&mt(e));let t=le.length;queueMicrotask(()=>{if(le.length===t)for(;le.length>0;)le.shift()()})}function m(e){if(!ft)return e();dt();let t=e();return ue(),t}var pt=!1,Se=[];function rr(){pt=!0}function nr(){pt=!1,mt(Se),Se=[]}function mt(e){if(pt){Se=Se.concat(e);return}let t=[],r=new Set,n=new Map,i=new Map;for(let o=0;o<e.length;o++)if(!e[o].target._x_ignoreMutationObserver&&(e[o].type===\"childList\"&&(e[o].removedNodes.forEach(s=>{s.nodeType===1&&s._x_marker&&r.add(s)}),e[o].addedNodes.forEach(s=>{if(s.nodeType===1){if(r.has(s)){r.delete(s);return}s._x_marker||t.push(s)}})),e[o].type===\"attributes\")){let s=e[o].target,a=e[o].attributeName,c=e[o].oldValue,l=()=>{n.has(s)||n.set(s,[]),n.get(s).push({name:a,value:s.getAttribute(a)})},u=()=>{i.has(s)||i.set(s,[]),i.get(s).push(a)};s.hasAttribute(a)&&c===null?l():s.hasAttribute(a)?(u(),l()):u()}i.forEach((o,s)=>{lt(s,o)}),n.forEach((o,s)=>{Xt.forEach(a=>a(s,o))});for(let o of r)t.some(s=>s.contains(o))||Zt.forEach(s=>s(o));for(let o of t)o.isConnected&&Qt.forEach(s=>s(o));t=null,r=null,n=null,i=null}function Ce(e){return z(B(e))}function k(e,t,r){return e._x_dataStack=[t,...B(r||e)],()=>{e._x_dataStack=e._x_dataStack.filter(n=>n!==t)}}function B(e){return e._x_dataStack?e._x_dataStack:typeof ShadowRoot==\"function\"&&e instanceof ShadowRoot?B(e.host):e.parentNode?B(e.parentNode):[]}function z(e){return new Proxy({objects:e},Dn)}var Dn={ownKeys({objects:e}){return Array.from(new Set(e.flatMap(t=>Object.keys(t))))},has({objects:e},t){return t==Symbol.unscopables?!1:e.some(r=>Object.prototype.hasOwnProperty.call(r,t)||Reflect.has(r,t))},get({objects:e},t,r){return t==\"toJSON\"?Pn:Reflect.get(e.find(n=>Reflect.has(n,t))||{},t,r)},set({objects:e},t,r,n){let i=e.find(s=>Object.prototype.hasOwnProperty.call(s,t))||e[e.length-1],o=Object.getOwnPropertyDescriptor(i,t);return o?.set&&o?.get?o.set.call(n,r)||!0:Reflect.set(i,t,r)}};function Pn(){return Reflect.ownKeys(this).reduce((t,r)=>(t[r]=Reflect.get(this,r),t),{})}function Te(e){let t=n=>typeof n==\"object\"&&!Array.isArray(n)&&n!==null,r=(n,i=\"\")=>{Object.entries(Object.getOwnPropertyDescriptors(n)).forEach(([o,{value:s,enumerable:a}])=>{if(a===!1||s===void 0||typeof s==\"object\"&&s!==null&&s.__v_skip)return;let c=i===\"\"?o:`${i}.${o}`;typeof s==\"object\"&&s!==null&&s._x_interceptor?n[o]=s.initialize(e,c,o):t(s)&&s!==n&&!(s instanceof Element)&&r(s,c)})};return r(e)}function Re(e,t=()=>{}){let r={initialValue:void 0,_x_interceptor:!0,initialize(n,i,o){return e(this.initialValue,()=>In(n,i),s=>ht(n,i,s),i,o)}};return t(r),n=>{if(typeof n==\"object\"&&n!==null&&n._x_interceptor){let i=r.initialize.bind(r);r.initialize=(o,s,a)=>{let c=n.initialize(o,s,a);return r.initialValue=c,i(o,s,a)}}else r.initialValue=n;return r}}function In(e,t){return t.split(\".\").reduce((r,n)=>r[n],e)}function ht(e,t,r){if(typeof t==\"string\"&&(t=t.split(\".\")),t.length===1)e[t[0]]=r;else{if(t.length===0)throw error;return e[t[0]]||(e[t[0]]={}),ht(e[t[0]],t.slice(1),r)}}var ir={};function y(e,t){ir[e]=t}function fe(e,t){let r=Ln(t);return Object.entries(ir).forEach(([n,i])=>{Object.defineProperty(e,`$${n}`,{get(){return i(t,r)},enumerable:!1})}),e}function Ln(e){let[t,r]=_t(e),n={interceptor:Re,...t};return te(e,r),n}function or(e,t,r,...n){try{return r(...n)}catch(i){re(i,e,t)}}function re(e,t,r=void 0){e=Object.assign(e??{message:\"No error message given.\"},{el:t,expression:r}),console.warn(`Alpine Expression Error: ${e.message}\n\n${r?'Expression: \"'+r+`\"\n\n`:\"\"}`,t),setTimeout(()=>{throw e},0)}var Me=!0;function ke(e){let t=Me;Me=!1;let r=e();return Me=t,r}function R(e,t,r={}){let n;return x(e,t)(i=>n=i,r),n}function x(...e){return sr(...e)}var sr=xt;function ar(e){sr=e}function xt(e,t){let r={};fe(r,e);let n=[r,...B(e)],i=typeof t==\"function\"?$n(n,t):Fn(n,t,e);return or.bind(null,e,t,i)}function $n(e,t){return(r=()=>{},{scope:n={},params:i=[]}={})=>{let o=t.apply(z([n,...e]),i);Ne(r,o)}}var gt={};function jn(e,t){if(gt[e])return gt[e];let r=Object.getPrototypeOf(async function(){}).constructor,n=/^[\\n\\s]*if.*\\(.*\\)/.test(e.trim())||/^(let|const)\\s/.test(e.trim())?`(async()=>{ ${e} })()`:e,o=(()=>{try{let s=new r([\"__self\",\"scope\"],`with (scope) { __self.result = ${n} }; __self.finished = true; return __self.result;`);return Object.defineProperty(s,\"name\",{value:`[Alpine] ${e}`}),s}catch(s){return re(s,t,e),Promise.resolve()}})();return gt[e]=o,o}function Fn(e,t,r){let n=jn(t,r);return(i=()=>{},{scope:o={},params:s=[]}={})=>{n.result=void 0,n.finished=!1;let a=z([o,...e]);if(typeof n==\"function\"){let c=n(n,a).catch(l=>re(l,r,t));n.finished?(Ne(i,n.result,a,s,r),n.result=void 0):c.then(l=>{Ne(i,l,a,s,r)}).catch(l=>re(l,r,t)).finally(()=>n.result=void 0)}}}function Ne(e,t,r,n,i){if(Me&&typeof t==\"function\"){let o=t.apply(r,n);o instanceof Promise?o.then(s=>Ne(e,s,r,n)).catch(s=>re(s,i,t)):e(o)}else typeof t==\"object\"&&t instanceof Promise?t.then(o=>e(o)):e(t)}var wt=\"x-\";function C(e=\"\"){return wt+e}function cr(e){wt=e}var De={};function d(e,t){return De[e]=t,{before(r){if(!De[r]){console.warn(String.raw`Cannot find directive \\`${r}\\`. \\`${e}\\` will use the default order of execution`);return}let n=G.indexOf(r);G.splice(n>=0?n:G.indexOf(\"DEFAULT\"),0,e)}}}function lr(e){return Object.keys(De).includes(e)}function pe(e,t,r){if(t=Array.from(t),e._x_virtualDirectives){let o=Object.entries(e._x_virtualDirectives).map(([a,c])=>({name:a,value:c})),s=Et(o);o=o.map(a=>s.find(c=>c.name===a.name)?{name:`x-bind:${a.name}`,value:`\"${a.value}\"`}:a),t=t.concat(o)}let n={};return t.map(dr((o,s)=>n[o]=s)).filter(mr).map(zn(n,r)).sort(Kn).map(o=>Bn(e,o))}function Et(e){return Array.from(e).map(dr()).filter(t=>!mr(t))}var yt=!1,de=new Map,ur=Symbol();function fr(e){yt=!0;let t=Symbol();ur=t,de.set(t,[]);let r=()=>{for(;de.get(t).length;)de.get(t).shift()();de.delete(t)},n=()=>{yt=!1,r()};e(r),n()}function _t(e){let t=[],r=a=>t.push(a),[n,i]=Yt(e);return t.push(i),[{Alpine:K,effect:n,cleanup:r,evaluateLater:x.bind(x,e),evaluate:R.bind(R,e)},()=>t.forEach(a=>a())]}function Bn(e,t){let r=()=>{},n=De[t.type]||r,[i,o]=_t(e);Oe(e,t.original,o);let s=()=>{e._x_ignore||e._x_ignoreSelf||(n.inline&&n.inline(e,t,i),n=n.bind(n,e,t,i),yt?de.get(ur).push(n):n())};return s.runCleanups=o,s}var Pe=(e,t)=>({name:r,value:n})=>(r.startsWith(e)&&(r=r.replace(e,t)),{name:r,value:n}),Ie=e=>e;function dr(e=()=>{}){return({name:t,value:r})=>{let{name:n,value:i}=pr.reduce((o,s)=>s(o),{name:t,value:r});return n!==t&&e(n,t),{name:n,value:i}}}var pr=[];function ne(e){pr.push(e)}function mr({name:e}){return hr().test(e)}var hr=()=>new RegExp(`^${wt}([^:^.]+)\\\\b`);function zn(e,t){return({name:r,value:n})=>{let i=r.match(hr()),o=r.match(/:([a-zA-Z0-9\\-_:]+)/),s=r.match(/\\.[^.\\]]+(?=[^\\]]*$)/g)||[],a=t||e[r]||r;return{type:i?i[1]:null,value:o?o[1]:null,modifiers:s.map(c=>c.replace(\".\",\"\")),expression:n,original:a}}}var bt=\"DEFAULT\",G=[\"ignore\",\"ref\",\"data\",\"id\",\"anchor\",\"bind\",\"init\",\"for\",\"model\",\"modelable\",\"transition\",\"show\",\"if\",bt,\"teleport\"];function Kn(e,t){let r=G.indexOf(e.type)===-1?bt:e.type,n=G.indexOf(t.type)===-1?bt:t.type;return G.indexOf(r)-G.indexOf(n)}function J(e,t,r={}){e.dispatchEvent(new CustomEvent(t,{detail:r,bubbles:!0,composed:!0,cancelable:!0}))}function D(e,t){if(typeof ShadowRoot==\"function\"&&e instanceof ShadowRoot){Array.from(e.children).forEach(i=>D(i,t));return}let r=!1;if(t(e,()=>r=!0),r)return;let n=e.firstElementChild;for(;n;)D(n,t,!1),n=n.nextElementSibling}function E(e,...t){console.warn(`Alpine Warning: ${e}`,...t)}var _r=!1;function gr(){_r&&E(\"Alpine has already been initialized on this page. Calling Alpine.start() more than once can cause problems.\"),_r=!0,document.body||E(\"Unable to initialize. Trying to load Alpine before `<body>` is available. Did you forget to add `defer` in Alpine's `<script>` tag?\"),J(document,\"alpine:init\"),J(document,\"alpine:initializing\"),ue(),er(t=>S(t,D)),te(t=>P(t)),Ae((t,r)=>{pe(t,r).forEach(n=>n())});let e=t=>!Y(t.parentElement,!0);Array.from(document.querySelectorAll(br().join(\",\"))).filter(e).forEach(t=>{S(t)}),J(document,\"alpine:initialized\"),setTimeout(()=>{Vn()})}var vt=[],xr=[];function yr(){return vt.map(e=>e())}function br(){return vt.concat(xr).map(e=>e())}function Le(e){vt.push(e)}function $e(e){xr.push(e)}function Y(e,t=!1){return j(e,r=>{if((t?br():yr()).some(i=>r.matches(i)))return!0})}function j(e,t){if(e){if(t(e))return e;if(e._x_teleportBack&&(e=e._x_teleportBack),!!e.parentElement)return j(e.parentElement,t)}}function wr(e){return yr().some(t=>e.matches(t))}var Er=[];function vr(e){Er.push(e)}var Hn=1;function S(e,t=D,r=()=>{}){j(e,n=>n._x_ignore)||fr(()=>{t(e,(n,i)=>{n._x_marker||(r(n,i),Er.forEach(o=>o(n,i)),pe(n,n.attributes).forEach(o=>o()),n._x_ignore||(n._x_marker=Hn++),n._x_ignore&&i())})})}function P(e,t=D){t(e,r=>{tr(r),lt(r),delete r._x_marker})}function Vn(){[[\"ui\",\"dialog\",[\"[x-dialog], [x-popover]\"]],[\"anchor\",\"anchor\",[\"[x-anchor]\"]],[\"sort\",\"sort\",[\"[x-sort]\"]]].forEach(([t,r,n])=>{lr(r)||n.some(i=>{if(document.querySelector(i))return E(`found \"${i}\", but missing ${t} plugin`),!0})})}var St=[],At=!1;function ie(e=()=>{}){return queueMicrotask(()=>{At||setTimeout(()=>{je()})}),new Promise(t=>{St.push(()=>{e(),t()})})}function je(){for(At=!1;St.length;)St.shift()()}function Sr(){At=!0}function me(e,t){return Array.isArray(t)?Ar(e,t.join(\" \")):typeof t==\"object\"&&t!==null?qn(e,t):typeof t==\"function\"?me(e,t()):Ar(e,t)}function Ar(e,t){let r=o=>o.split(\" \").filter(Boolean),n=o=>o.split(\" \").filter(s=>!e.classList.contains(s)).filter(Boolean),i=o=>(e.classList.add(...o),()=>{e.classList.remove(...o)});return t=t===!0?t=\"\":t||\"\",i(n(t))}function qn(e,t){let r=a=>a.split(\" \").filter(Boolean),n=Object.entries(t).flatMap(([a,c])=>c?r(a):!1).filter(Boolean),i=Object.entries(t).flatMap(([a,c])=>c?!1:r(a)).filter(Boolean),o=[],s=[];return i.forEach(a=>{e.classList.contains(a)&&(e.classList.remove(a),s.push(a))}),n.forEach(a=>{e.classList.contains(a)||(e.classList.add(a),o.push(a))}),()=>{s.forEach(a=>e.classList.add(a)),o.forEach(a=>e.classList.remove(a))}}function X(e,t){return typeof t==\"object\"&&t!==null?Un(e,t):Wn(e,t)}function Un(e,t){let r={};return Object.entries(t).forEach(([n,i])=>{r[n]=e.style[n],n.startsWith(\"--\")||(n=Gn(n)),e.style.setProperty(n,i)}),setTimeout(()=>{e.style.length===0&&e.removeAttribute(\"style\")}),()=>{X(e,r)}}function Wn(e,t){let r=e.getAttribute(\"style\",t);return e.setAttribute(\"style\",t),()=>{e.setAttribute(\"style\",r||\"\")}}function Gn(e){return e.replace(/([a-z])([A-Z])/g,\"$1-$2\").toLowerCase()}function he(e,t=()=>{}){let r=!1;return function(){r?t.apply(this,arguments):(r=!0,e.apply(this,arguments))}}d(\"transition\",(e,{value:t,modifiers:r,expression:n},{evaluate:i})=>{typeof n==\"function\"&&(n=i(n)),n!==!1&&(!n||typeof n==\"boolean\"?Yn(e,r,t):Jn(e,n,t))});function Jn(e,t,r){Or(e,me,\"\"),{enter:i=>{e._x_transition.enter.during=i},\"enter-start\":i=>{e._x_transition.enter.start=i},\"enter-end\":i=>{e._x_transition.enter.end=i},leave:i=>{e._x_transition.leave.during=i},\"leave-start\":i=>{e._x_transition.leave.start=i},\"leave-end\":i=>{e._x_transition.leave.end=i}}[r](t)}function Yn(e,t,r){Or(e,X);let n=!t.includes(\"in\")&&!t.includes(\"out\")&&!r,i=n||t.includes(\"in\")||[\"enter\"].includes(r),o=n||t.includes(\"out\")||[\"leave\"].includes(r);t.includes(\"in\")&&!n&&(t=t.filter((g,b)=>b<t.indexOf(\"out\"))),t.includes(\"out\")&&!n&&(t=t.filter((g,b)=>b>t.indexOf(\"out\")));let s=!t.includes(\"opacity\")&&!t.includes(\"scale\"),a=s||t.includes(\"opacity\"),c=s||t.includes(\"scale\"),l=a?0:1,u=c?_e(t,\"scale\",95)/100:1,p=_e(t,\"delay\",0)/1e3,h=_e(t,\"origin\",\"center\"),w=\"opacity, transform\",F=_e(t,\"duration\",150)/1e3,Ee=_e(t,\"duration\",75)/1e3,f=\"cubic-bezier(0.4, 0.0, 0.2, 1)\";i&&(e._x_transition.enter.during={transformOrigin:h,transitionDelay:`${p}s`,transitionProperty:w,transitionDuration:`${F}s`,transitionTimingFunction:f},e._x_transition.enter.start={opacity:l,transform:`scale(${u})`},e._x_transition.enter.end={opacity:1,transform:\"scale(1)\"}),o&&(e._x_transition.leave.during={transformOrigin:h,transitionDelay:`${p}s`,transitionProperty:w,transitionDuration:`${Ee}s`,transitionTimingFunction:f},e._x_transition.leave.start={opacity:1,transform:\"scale(1)\"},e._x_transition.leave.end={opacity:l,transform:`scale(${u})`})}function Or(e,t,r={}){e._x_transition||(e._x_transition={enter:{during:r,start:r,end:r},leave:{during:r,start:r,end:r},in(n=()=>{},i=()=>{}){Fe(e,t,{during:this.enter.during,start:this.enter.start,end:this.enter.end},n,i)},out(n=()=>{},i=()=>{}){Fe(e,t,{during:this.leave.during,start:this.leave.start,end:this.leave.end},n,i)}})}window.Element.prototype._x_toggleAndCascadeWithTransitions=function(e,t,r,n){let i=document.visibilityState===\"visible\"?requestAnimationFrame:setTimeout,o=()=>i(r);if(t){e._x_transition&&(e._x_transition.enter||e._x_transition.leave)?e._x_transition.enter&&(Object.entries(e._x_transition.enter.during).length||Object.entries(e._x_transition.enter.start).length||Object.entries(e._x_transition.enter.end).length)?e._x_transition.in(r):o():e._x_transition?e._x_transition.in(r):o();return}e._x_hidePromise=e._x_transition?new Promise((s,a)=>{e._x_transition.out(()=>{},()=>s(n)),e._x_transitioning&&e._x_transitioning.beforeCancel(()=>a({isFromCancelledTransition:!0}))}):Promise.resolve(n),queueMicrotask(()=>{let s=Cr(e);s?(s._x_hideChildren||(s._x_hideChildren=[]),s._x_hideChildren.push(e)):i(()=>{let a=c=>{let l=Promise.all([c._x_hidePromise,...(c._x_hideChildren||[]).map(a)]).then(([u])=>u?.());return delete c._x_hidePromise,delete c._x_hideChildren,l};a(e).catch(c=>{if(!c.isFromCancelledTransition)throw c})})})};function Cr(e){let t=e.parentNode;if(t)return t._x_hidePromise?t:Cr(t)}function Fe(e,t,{during:r,start:n,end:i}={},o=()=>{},s=()=>{}){if(e._x_transitioning&&e._x_transitioning.cancel(),Object.keys(r).length===0&&Object.keys(n).length===0&&Object.keys(i).length===0){o(),s();return}let a,c,l;Xn(e,{start(){a=t(e,n)},during(){c=t(e,r)},before:o,end(){a(),l=t(e,i)},after:s,cleanup(){c(),l()}})}function Xn(e,t){let r,n,i,o=he(()=>{m(()=>{r=!0,n||t.before(),i||(t.end(),je()),t.after(),e.isConnected&&t.cleanup(),delete e._x_transitioning})});e._x_transitioning={beforeCancels:[],beforeCancel(s){this.beforeCancels.push(s)},cancel:he(function(){for(;this.beforeCancels.length;)this.beforeCancels.shift()();o()}),finish:o},m(()=>{t.start(),t.during()}),Sr(),requestAnimationFrame(()=>{if(r)return;let s=Number(getComputedStyle(e).transitionDuration.replace(/,.*/,\"\").replace(\"s\",\"\"))*1e3,a=Number(getComputedStyle(e).transitionDelay.replace(/,.*/,\"\").replace(\"s\",\"\"))*1e3;s===0&&(s=Number(getComputedStyle(e).animationDuration.replace(\"s\",\"\"))*1e3),m(()=>{t.before()}),n=!0,requestAnimationFrame(()=>{r||(m(()=>{t.end()}),je(),setTimeout(e._x_transitioning.finish,s+a),i=!0)})})}function _e(e,t,r){if(e.indexOf(t)===-1)return r;let n=e[e.indexOf(t)+1];if(!n||t===\"scale\"&&isNaN(n))return r;if(t===\"duration\"||t===\"delay\"){let i=n.match(/([0-9]+)ms/);if(i)return i[1]}return t===\"origin\"&&[\"top\",\"right\",\"left\",\"center\",\"bottom\"].includes(e[e.indexOf(t)+2])?[n,e[e.indexOf(t)+2]].join(\" \"):n}var I=!1;function A(e,t=()=>{}){return(...r)=>I?t(...r):e(...r)}function Tr(e){return(...t)=>I&&e(...t)}var Rr=[];function H(e){Rr.push(e)}function Mr(e,t){Rr.forEach(r=>r(e,t)),I=!0,kr(()=>{S(t,(r,n)=>{n(r,()=>{})})}),I=!1}var Be=!1;function Nr(e,t){t._x_dataStack||(t._x_dataStack=e._x_dataStack),I=!0,Be=!0,kr(()=>{Zn(t)}),I=!1,Be=!1}function Zn(e){let t=!1;S(e,(n,i)=>{D(n,(o,s)=>{if(t&&wr(o))return s();t=!0,i(o,s)})})}function kr(e){let t=N;ct((r,n)=>{let i=t(r);return $(i),()=>{}}),e(),ct(t)}function ge(e,t,r,n=[]){switch(e._x_bindings||(e._x_bindings=T({})),e._x_bindings[t]=r,t=n.includes(\"camel\")?si(t):t,t){case\"value\":Qn(e,r);break;case\"style\":ti(e,r);break;case\"class\":ei(e,r);break;case\"selected\":case\"checked\":ri(e,t,r);break;default:Pr(e,t,r);break}}function Qn(e,t){if(Ot(e))e.attributes.value===void 0&&(e.value=t),window.fromModel&&(typeof t==\"boolean\"?e.checked=xe(e.value)===t:e.checked=Dr(e.value,t));else if(ze(e))Number.isInteger(t)?e.value=t:!Array.isArray(t)&&typeof t!=\"boolean\"&&![null,void 0].includes(t)?e.value=String(t):Array.isArray(t)?e.checked=t.some(r=>Dr(r,e.value)):e.checked=!!t;else if(e.tagName===\"SELECT\")oi(e,t);else{if(e.value===t)return;e.value=t===void 0?\"\":t}}function ei(e,t){e._x_undoAddedClasses&&e._x_undoAddedClasses(),e._x_undoAddedClasses=me(e,t)}function ti(e,t){e._x_undoAddedStyles&&e._x_undoAddedStyles(),e._x_undoAddedStyles=X(e,t)}function ri(e,t,r){Pr(e,t,r),ii(e,t,r)}function Pr(e,t,r){[null,void 0,!1].includes(r)&&ci(t)?e.removeAttribute(t):(Ir(t)&&(r=t),ni(e,t,r))}function ni(e,t,r){e.getAttribute(t)!=r&&e.setAttribute(t,r)}function ii(e,t,r){e[t]!==r&&(e[t]=r)}function oi(e,t){let r=[].concat(t).map(n=>n+\"\");Array.from(e.options).forEach(n=>{n.selected=r.includes(n.value)})}function si(e){return e.toLowerCase().replace(/-(\\w)/g,(t,r)=>r.toUpperCase())}function Dr(e,t){return e==t}function xe(e){return[1,\"1\",\"true\",\"on\",\"yes\",!0].includes(e)?!0:[0,\"0\",\"false\",\"off\",\"no\",!1].includes(e)?!1:e?Boolean(e):null}var ai=new Set([\"allowfullscreen\",\"async\",\"autofocus\",\"autoplay\",\"checked\",\"controls\",\"default\",\"defer\",\"disabled\",\"formnovalidate\",\"inert\",\"ismap\",\"itemscope\",\"loop\",\"multiple\",\"muted\",\"nomodule\",\"novalidate\",\"open\",\"playsinline\",\"readonly\",\"required\",\"reversed\",\"selected\",\"shadowrootclonable\",\"shadowrootdelegatesfocus\",\"shadowrootserializable\"]);function Ir(e){return ai.has(e)}function ci(e){return![\"aria-pressed\",\"aria-checked\",\"aria-expanded\",\"aria-selected\"].includes(e)}function Lr(e,t,r){return e._x_bindings&&e._x_bindings[t]!==void 0?e._x_bindings[t]:jr(e,t,r)}function $r(e,t,r,n=!0){if(e._x_bindings&&e._x_bindings[t]!==void 0)return e._x_bindings[t];if(e._x_inlineBindings&&e._x_inlineBindings[t]!==void 0){let i=e._x_inlineBindings[t];return i.extract=n,ke(()=>R(e,i.expression))}return jr(e,t,r)}function jr(e,t,r){let n=e.getAttribute(t);return n===null?typeof r==\"function\"?r():r:n===\"\"?!0:Ir(t)?!![t,\"true\"].includes(n):n}function ze(e){return e.type===\"checkbox\"||e.localName===\"ui-checkbox\"||e.localName===\"ui-switch\"}function Ot(e){return e.type===\"radio\"||e.localName===\"ui-radio\"}function Ke(e,t){var r;return function(){var n=this,i=arguments,o=function(){r=null,e.apply(n,i)};clearTimeout(r),r=setTimeout(o,t)}}function He(e,t){let r;return function(){let n=this,i=arguments;r||(e.apply(n,i),r=!0,setTimeout(()=>r=!1,t))}}function Ve({get:e,set:t},{get:r,set:n}){let i=!0,o,s,a=N(()=>{let c=e(),l=r();if(i)n(Ct(c)),i=!1;else{let u=JSON.stringify(c),p=JSON.stringify(l);u!==o?n(Ct(c)):u!==p&&t(Ct(l))}o=JSON.stringify(e()),s=JSON.stringify(r())});return()=>{$(a)}}function Ct(e){return typeof e==\"object\"?JSON.parse(JSON.stringify(e)):e}function Fr(e){(Array.isArray(e)?e:[e]).forEach(r=>r(K))}var Z={},Br=!1;function zr(e,t){if(Br||(Z=T(Z),Br=!0),t===void 0)return Z[e];Z[e]=t,Te(Z[e]),typeof t==\"object\"&&t!==null&&t.hasOwnProperty(\"init\")&&typeof t.init==\"function\"&&Z[e].init()}function Kr(){return Z}var Hr={};function Vr(e,t){let r=typeof t!=\"function\"?()=>t:t;return e instanceof Element?Tt(e,r()):(Hr[e]=r,()=>{})}function qr(e){return Object.entries(Hr).forEach(([t,r])=>{Object.defineProperty(e,t,{get(){return(...n)=>r(...n)}})}),e}function Tt(e,t,r){let n=[];for(;n.length;)n.pop()();let i=Object.entries(t).map(([s,a])=>({name:s,value:a})),o=Et(i);return i=i.map(s=>o.find(a=>a.name===s.name)?{name:`x-bind:${s.name}`,value:`\"${s.value}\"`}:s),pe(e,i,r).map(s=>{n.push(s.runCleanups),s()}),()=>{for(;n.length;)n.pop()()}}var Ur={};function Wr(e,t){Ur[e]=t}function Gr(e,t){return Object.entries(Ur).forEach(([r,n])=>{Object.defineProperty(e,r,{get(){return(...i)=>n.bind(t)(...i)},enumerable:!1})}),e}var li={get reactive(){return T},get release(){return $},get effect(){return N},get raw(){return at},version:\"3.14.6\",flushAndStopDeferringMutations:nr,dontAutoEvaluateFunctions:ke,disableEffectScheduling:Gt,startObservingMutations:ue,stopObservingMutations:dt,setReactivityEngine:Jt,onAttributeRemoved:Oe,onAttributesAdded:Ae,closestDataStack:B,skipDuringClone:A,onlyDuringClone:Tr,addRootSelector:Le,addInitSelector:$e,interceptClone:H,addScopeToNode:k,deferMutations:rr,mapAttributes:ne,evaluateLater:x,interceptInit:vr,setEvaluator:ar,mergeProxies:z,extractProp:$r,findClosest:j,onElRemoved:te,closestRoot:Y,destroyTree:P,interceptor:Re,transition:Fe,setStyles:X,mutateDom:m,directive:d,entangle:Ve,throttle:He,debounce:Ke,evaluate:R,initTree:S,nextTick:ie,prefixed:C,prefix:cr,plugin:Fr,magic:y,store:zr,start:gr,clone:Nr,cloneNode:Mr,bound:Lr,$data:Ce,watch:ve,walk:D,data:Wr,bind:Vr},K=li;function Rt(e,t){let r=Object.create(null),n=e.split(\",\");for(let i=0;i<n.length;i++)r[n[i]]=!0;return t?i=>!!r[i.toLowerCase()]:i=>!!r[i]}var ui=\"itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly\";var Ls=Rt(ui+\",async,autofocus,autoplay,controls,default,defer,disabled,hidden,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected\");var Jr=Object.freeze({}),$s=Object.freeze([]);var fi=Object.prototype.hasOwnProperty,ye=(e,t)=>fi.call(e,t),V=Array.isArray,oe=e=>Yr(e)===\"[object Map]\";var di=e=>typeof e==\"string\",qe=e=>typeof e==\"symbol\",be=e=>e!==null&&typeof e==\"object\";var pi=Object.prototype.toString,Yr=e=>pi.call(e),Mt=e=>Yr(e).slice(8,-1);var Ue=e=>di(e)&&e!==\"NaN\"&&e[0]!==\"-\"&&\"\"+parseInt(e,10)===e;var We=e=>{let t=Object.create(null);return r=>t[r]||(t[r]=e(r))},mi=/-(\\w)/g,js=We(e=>e.replace(mi,(t,r)=>r?r.toUpperCase():\"\")),hi=/\\B([A-Z])/g,Fs=We(e=>e.replace(hi,\"-$1\").toLowerCase()),Nt=We(e=>e.charAt(0).toUpperCase()+e.slice(1)),Bs=We(e=>e?`on${Nt(e)}`:\"\"),kt=(e,t)=>e!==t&&(e===e||t===t);var Dt=new WeakMap,we=[],L,Q=Symbol(\"iterate\"),Pt=Symbol(\"Map key iterate\");function _i(e){return e&&e._isEffect===!0}function rn(e,t=Jr){_i(e)&&(e=e.raw);let r=xi(e,t);return t.lazy||r(),r}function nn(e){e.active&&(on(e),e.options.onStop&&e.options.onStop(),e.active=!1)}var gi=0;function xi(e,t){let r=function(){if(!r.active)return e();if(!we.includes(r)){on(r);try{return bi(),we.push(r),L=r,e()}finally{we.pop(),sn(),L=we[we.length-1]}}};return r.id=gi++,r.allowRecurse=!!t.allowRecurse,r._isEffect=!0,r.active=!0,r.raw=e,r.deps=[],r.options=t,r}function on(e){let{deps:t}=e;if(t.length){for(let r=0;r<t.length;r++)t[r].delete(e);t.length=0}}var se=!0,Lt=[];function yi(){Lt.push(se),se=!1}function bi(){Lt.push(se),se=!0}function sn(){let e=Lt.pop();se=e===void 0?!0:e}function M(e,t,r){if(!se||L===void 0)return;let n=Dt.get(e);n||Dt.set(e,n=new Map);let i=n.get(r);i||n.set(r,i=new Set),i.has(L)||(i.add(L),L.deps.push(i),L.options.onTrack&&L.options.onTrack({effect:L,target:e,type:t,key:r}))}function U(e,t,r,n,i,o){let s=Dt.get(e);if(!s)return;let a=new Set,c=u=>{u&&u.forEach(p=>{(p!==L||p.allowRecurse)&&a.add(p)})};if(t===\"clear\")s.forEach(c);else if(r===\"length\"&&V(e))s.forEach((u,p)=>{(p===\"length\"||p>=n)&&c(u)});else switch(r!==void 0&&c(s.get(r)),t){case\"add\":V(e)?Ue(r)&&c(s.get(\"length\")):(c(s.get(Q)),oe(e)&&c(s.get(Pt)));break;case\"delete\":V(e)||(c(s.get(Q)),oe(e)&&c(s.get(Pt)));break;case\"set\":oe(e)&&c(s.get(Q));break}let l=u=>{u.options.onTrigger&&u.options.onTrigger({effect:u,target:e,key:r,type:t,newValue:n,oldValue:i,oldTarget:o}),u.options.scheduler?u.options.scheduler(u):u()};a.forEach(l)}var wi=Rt(\"__proto__,__v_isRef,__isVue\"),an=new Set(Object.getOwnPropertyNames(Symbol).map(e=>Symbol[e]).filter(qe)),Ei=cn();var vi=cn(!0);var Xr=Si();function Si(){let e={};return[\"includes\",\"indexOf\",\"lastIndexOf\"].forEach(t=>{e[t]=function(...r){let n=_(this);for(let o=0,s=this.length;o<s;o++)M(n,\"get\",o+\"\");let i=n[t](...r);return i===-1||i===!1?n[t](...r.map(_)):i}}),[\"push\",\"pop\",\"shift\",\"unshift\",\"splice\"].forEach(t=>{e[t]=function(...r){yi();let n=_(this)[t].apply(this,r);return sn(),n}}),e}function cn(e=!1,t=!1){return function(n,i,o){if(i===\"__v_isReactive\")return!e;if(i===\"__v_isReadonly\")return e;if(i===\"__v_raw\"&&o===(e?t?Bi:dn:t?Fi:fn).get(n))return n;let s=V(n);if(!e&&s&&ye(Xr,i))return Reflect.get(Xr,i,o);let a=Reflect.get(n,i,o);return(qe(i)?an.has(i):wi(i))||(e||M(n,\"get\",i),t)?a:It(a)?!s||!Ue(i)?a.value:a:be(a)?e?pn(a):et(a):a}}var Ai=Oi();function Oi(e=!1){return function(r,n,i,o){let s=r[n];if(!e&&(i=_(i),s=_(s),!V(r)&&It(s)&&!It(i)))return s.value=i,!0;let a=V(r)&&Ue(n)?Number(n)<r.length:ye(r,n),c=Reflect.set(r,n,i,o);return r===_(o)&&(a?kt(i,s)&&U(r,\"set\",n,i,s):U(r,\"add\",n,i)),c}}function Ci(e,t){let r=ye(e,t),n=e[t],i=Reflect.deleteProperty(e,t);return i&&r&&U(e,\"delete\",t,void 0,n),i}function Ti(e,t){let r=Reflect.has(e,t);return(!qe(t)||!an.has(t))&&M(e,\"has\",t),r}function Ri(e){return M(e,\"iterate\",V(e)?\"length\":Q),Reflect.ownKeys(e)}var Mi={get:Ei,set:Ai,deleteProperty:Ci,has:Ti,ownKeys:Ri},Ni={get:vi,set(e,t){return console.warn(`Set operation on key \"${String(t)}\" failed: target is readonly.`,e),!0},deleteProperty(e,t){return console.warn(`Delete operation on key \"${String(t)}\" failed: target is readonly.`,e),!0}};var $t=e=>be(e)?et(e):e,jt=e=>be(e)?pn(e):e,Ft=e=>e,Qe=e=>Reflect.getPrototypeOf(e);function Ge(e,t,r=!1,n=!1){e=e.__v_raw;let i=_(e),o=_(t);t!==o&&!r&&M(i,\"get\",t),!r&&M(i,\"get\",o);let{has:s}=Qe(i),a=n?Ft:r?jt:$t;if(s.call(i,t))return a(e.get(t));if(s.call(i,o))return a(e.get(o));e!==i&&e.get(t)}function Je(e,t=!1){let r=this.__v_raw,n=_(r),i=_(e);return e!==i&&!t&&M(n,\"has\",e),!t&&M(n,\"has\",i),e===i?r.has(e):r.has(e)||r.has(i)}function Ye(e,t=!1){return e=e.__v_raw,!t&&M(_(e),\"iterate\",Q),Reflect.get(e,\"size\",e)}function Zr(e){e=_(e);let t=_(this);return Qe(t).has.call(t,e)||(t.add(e),U(t,\"add\",e,e)),this}function Qr(e,t){t=_(t);let r=_(this),{has:n,get:i}=Qe(r),o=n.call(r,e);o?un(r,n,e):(e=_(e),o=n.call(r,e));let s=i.call(r,e);return r.set(e,t),o?kt(t,s)&&U(r,\"set\",e,t,s):U(r,\"add\",e,t),this}function en(e){let t=_(this),{has:r,get:n}=Qe(t),i=r.call(t,e);i?un(t,r,e):(e=_(e),i=r.call(t,e));let o=n?n.call(t,e):void 0,s=t.delete(e);return i&&U(t,\"delete\",e,void 0,o),s}function tn(){let e=_(this),t=e.size!==0,r=oe(e)?new Map(e):new Set(e),n=e.clear();return t&&U(e,\"clear\",void 0,void 0,r),n}function Xe(e,t){return function(n,i){let o=this,s=o.__v_raw,a=_(s),c=t?Ft:e?jt:$t;return!e&&M(a,\"iterate\",Q),s.forEach((l,u)=>n.call(i,c(l),c(u),o))}}function Ze(e,t,r){return function(...n){let i=this.__v_raw,o=_(i),s=oe(o),a=e===\"entries\"||e===Symbol.iterator&&s,c=e===\"keys\"&&s,l=i[e](...n),u=r?Ft:t?jt:$t;return!t&&M(o,\"iterate\",c?Pt:Q),{next(){let{value:p,done:h}=l.next();return h?{value:p,done:h}:{value:a?[u(p[0]),u(p[1])]:u(p),done:h}},[Symbol.iterator](){return this}}}}function q(e){return function(...t){{let r=t[0]?`on key \"${t[0]}\" `:\"\";console.warn(`${Nt(e)} operation ${r}failed: target is readonly.`,_(this))}return e===\"delete\"?!1:this}}function ki(){let e={get(o){return Ge(this,o)},get size(){return Ye(this)},has:Je,add:Zr,set:Qr,delete:en,clear:tn,forEach:Xe(!1,!1)},t={get(o){return Ge(this,o,!1,!0)},get size(){return Ye(this)},has:Je,add:Zr,set:Qr,delete:en,clear:tn,forEach:Xe(!1,!0)},r={get(o){return Ge(this,o,!0)},get size(){return Ye(this,!0)},has(o){return Je.call(this,o,!0)},add:q(\"add\"),set:q(\"set\"),delete:q(\"delete\"),clear:q(\"clear\"),forEach:Xe(!0,!1)},n={get(o){return Ge(this,o,!0,!0)},get size(){return Ye(this,!0)},has(o){return Je.call(this,o,!0)},add:q(\"add\"),set:q(\"set\"),delete:q(\"delete\"),clear:q(\"clear\"),forEach:Xe(!0,!0)};return[\"keys\",\"values\",\"entries\",Symbol.iterator].forEach(o=>{e[o]=Ze(o,!1,!1),r[o]=Ze(o,!0,!1),t[o]=Ze(o,!1,!0),n[o]=Ze(o,!0,!0)}),[e,r,t,n]}var[Di,Pi,Ii,Li]=ki();function ln(e,t){let r=t?e?Li:Ii:e?Pi:Di;return(n,i,o)=>i===\"__v_isReactive\"?!e:i===\"__v_isReadonly\"?e:i===\"__v_raw\"?n:Reflect.get(ye(r,i)&&i in n?r:n,i,o)}var $i={get:ln(!1,!1)};var ji={get:ln(!0,!1)};function un(e,t,r){let n=_(r);if(n!==r&&t.call(e,n)){let i=Mt(e);console.warn(`Reactive ${i} contains both the raw and reactive versions of the same object${i===\"Map\"?\" as keys\":\"\"}, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`)}}var fn=new WeakMap,Fi=new WeakMap,dn=new WeakMap,Bi=new WeakMap;function zi(e){switch(e){case\"Object\":case\"Array\":return 1;case\"Map\":case\"Set\":case\"WeakMap\":case\"WeakSet\":return 2;default:return 0}}function Ki(e){return e.__v_skip||!Object.isExtensible(e)?0:zi(Mt(e))}function et(e){return e&&e.__v_isReadonly?e:mn(e,!1,Mi,$i,fn)}function pn(e){return mn(e,!0,Ni,ji,dn)}function mn(e,t,r,n,i){if(!be(e))return console.warn(`value cannot be made reactive: ${String(e)}`),e;if(e.__v_raw&&!(t&&e.__v_isReactive))return e;let o=i.get(e);if(o)return o;let s=Ki(e);if(s===0)return e;let a=new Proxy(e,s===2?n:r);return i.set(e,a),a}function _(e){return e&&_(e.__v_raw)||e}function It(e){return Boolean(e&&e.__v_isRef===!0)}y(\"nextTick\",()=>ie);y(\"dispatch\",e=>J.bind(J,e));y(\"watch\",(e,{evaluateLater:t,cleanup:r})=>(n,i)=>{let o=t(n),a=ve(()=>{let c;return o(l=>c=l),c},i);r(a)});y(\"store\",Kr);y(\"data\",e=>Ce(e));y(\"root\",e=>Y(e));y(\"refs\",e=>(e._x_refs_proxy||(e._x_refs_proxy=z(Hi(e))),e._x_refs_proxy));function Hi(e){let t=[];return j(e,r=>{r._x_refs&&t.push(r._x_refs)}),t}var Bt={};function zt(e){return Bt[e]||(Bt[e]=0),++Bt[e]}function hn(e,t){return j(e,r=>{if(r._x_ids&&r._x_ids[t])return!0})}function _n(e,t){e._x_ids||(e._x_ids={}),e._x_ids[t]||(e._x_ids[t]=zt(t))}y(\"id\",(e,{cleanup:t})=>(r,n=null)=>{let i=`${r}${n?`-${n}`:\"\"}`;return Vi(e,i,t,()=>{let o=hn(e,r),s=o?o._x_ids[r]:zt(r);return n?`${r}-${s}-${n}`:`${r}-${s}`})});H((e,t)=>{e._x_id&&(t._x_id=e._x_id)});function Vi(e,t,r,n){if(e._x_id||(e._x_id={}),e._x_id[t])return e._x_id[t];let i=n();return e._x_id[t]=i,r(()=>{delete e._x_id[t]}),i}y(\"el\",e=>e);gn(\"Focus\",\"focus\",\"focus\");gn(\"Persist\",\"persist\",\"persist\");function gn(e,t,r){y(t,n=>E(`You can't use [$${t}] without first installing the \"${e}\" plugin here: https://alpinejs.dev/plugins/${r}`,n))}d(\"modelable\",(e,{expression:t},{effect:r,evaluateLater:n,cleanup:i})=>{let o=n(t),s=()=>{let u;return o(p=>u=p),u},a=n(`${t} = __placeholder`),c=u=>a(()=>{},{scope:{__placeholder:u}}),l=s();c(l),queueMicrotask(()=>{if(!e._x_model)return;e._x_removeModelListeners.default();let u=e._x_model.get,p=e._x_model.set,h=Ve({get(){return u()},set(w){p(w)}},{get(){return s()},set(w){c(w)}});i(h)})});d(\"teleport\",(e,{modifiers:t,expression:r},{cleanup:n})=>{e.tagName.toLowerCase()!==\"template\"&&E(\"x-teleport can only be used on a <template> tag\",e);let i=xn(r),o=e.content.cloneNode(!0).firstElementChild;e._x_teleport=o,o._x_teleportBack=e,e.setAttribute(\"data-teleport-template\",!0),o.setAttribute(\"data-teleport-target\",!0),e._x_forwardEvents&&e._x_forwardEvents.forEach(a=>{o.addEventListener(a,c=>{c.stopPropagation(),e.dispatchEvent(new c.constructor(c.type,c))})}),k(o,{},e);let s=(a,c,l)=>{l.includes(\"prepend\")?c.parentNode.insertBefore(a,c):l.includes(\"append\")?c.parentNode.insertBefore(a,c.nextSibling):c.appendChild(a)};m(()=>{s(o,i,t),A(()=>{S(o),o._x_ignore=!0})()}),e._x_teleportPutBack=()=>{let a=xn(r);m(()=>{s(e._x_teleport,a,t)})},n(()=>m(()=>{o.remove(),P(o)}))});var qi=document.createElement(\"div\");function xn(e){let t=A(()=>document.querySelector(e),()=>qi)();return t||E(`Cannot find x-teleport element for selector: \"${e}\"`),t}var yn=()=>{};yn.inline=(e,{modifiers:t},{cleanup:r})=>{t.includes(\"self\")?e._x_ignoreSelf=!0:e._x_ignore=!0,r(()=>{t.includes(\"self\")?delete e._x_ignoreSelf:delete e._x_ignore})};d(\"ignore\",yn);d(\"effect\",A((e,{expression:t},{effect:r})=>{r(x(e,t))}));function ae(e,t,r,n){let i=e,o=c=>n(c),s={},a=(c,l)=>u=>l(c,u);if(r.includes(\"dot\")&&(t=Ui(t)),r.includes(\"camel\")&&(t=Wi(t)),r.includes(\"passive\")&&(s.passive=!0),r.includes(\"capture\")&&(s.capture=!0),r.includes(\"window\")&&(i=window),r.includes(\"document\")&&(i=document),r.includes(\"debounce\")){let c=r[r.indexOf(\"debounce\")+1]||\"invalid-wait\",l=tt(c.split(\"ms\")[0])?Number(c.split(\"ms\")[0]):250;o=Ke(o,l)}if(r.includes(\"throttle\")){let c=r[r.indexOf(\"throttle\")+1]||\"invalid-wait\",l=tt(c.split(\"ms\")[0])?Number(c.split(\"ms\")[0]):250;o=He(o,l)}return r.includes(\"prevent\")&&(o=a(o,(c,l)=>{l.preventDefault(),c(l)})),r.includes(\"stop\")&&(o=a(o,(c,l)=>{l.stopPropagation(),c(l)})),r.includes(\"once\")&&(o=a(o,(c,l)=>{c(l),i.removeEventListener(t,o,s)})),(r.includes(\"away\")||r.includes(\"outside\"))&&(i=document,o=a(o,(c,l)=>{e.contains(l.target)||l.target.isConnected!==!1&&(e.offsetWidth<1&&e.offsetHeight<1||e._x_isShown!==!1&&c(l))})),r.includes(\"self\")&&(o=a(o,(c,l)=>{l.target===e&&c(l)})),(Ji(t)||wn(t))&&(o=a(o,(c,l)=>{Yi(l,r)||c(l)})),i.addEventListener(t,o,s),()=>{i.removeEventListener(t,o,s)}}function Ui(e){return e.replace(/-/g,\".\")}function Wi(e){return e.toLowerCase().replace(/-(\\w)/g,(t,r)=>r.toUpperCase())}function tt(e){return!Array.isArray(e)&&!isNaN(e)}function Gi(e){return[\" \",\"_\"].includes(e)?e:e.replace(/([a-z])([A-Z])/g,\"$1-$2\").replace(/[_\\s]/,\"-\").toLowerCase()}function Ji(e){return[\"keydown\",\"keyup\"].includes(e)}function wn(e){return[\"contextmenu\",\"click\",\"mouse\"].some(t=>e.includes(t))}function Yi(e,t){let r=t.filter(o=>![\"window\",\"document\",\"prevent\",\"stop\",\"once\",\"capture\",\"self\",\"away\",\"outside\",\"passive\"].includes(o));if(r.includes(\"debounce\")){let o=r.indexOf(\"debounce\");r.splice(o,tt((r[o+1]||\"invalid-wait\").split(\"ms\")[0])?2:1)}if(r.includes(\"throttle\")){let o=r.indexOf(\"throttle\");r.splice(o,tt((r[o+1]||\"invalid-wait\").split(\"ms\")[0])?2:1)}if(r.length===0||r.length===1&&bn(e.key).includes(r[0]))return!1;let i=[\"ctrl\",\"shift\",\"alt\",\"meta\",\"cmd\",\"super\"].filter(o=>r.includes(o));return r=r.filter(o=>!i.includes(o)),!(i.length>0&&i.filter(s=>((s===\"cmd\"||s===\"super\")&&(s=\"meta\"),e[`${s}Key`])).length===i.length&&(wn(e.type)||bn(e.key).includes(r[0])))}function bn(e){if(!e)return[];e=Gi(e);let t={ctrl:\"control\",slash:\"/\",space:\" \",spacebar:\" \",cmd:\"meta\",esc:\"escape\",up:\"arrow-up\",down:\"arrow-down\",left:\"arrow-left\",right:\"arrow-right\",period:\".\",comma:\",\",equal:\"=\",minus:\"-\",underscore:\"_\"};return t[e]=e,Object.keys(t).map(r=>{if(t[r]===e)return r}).filter(r=>r)}d(\"model\",(e,{modifiers:t,expression:r},{effect:n,cleanup:i})=>{let o=e;t.includes(\"parent\")&&(o=e.parentNode);let s=x(o,r),a;typeof r==\"string\"?a=x(o,`${r} = __placeholder`):typeof r==\"function\"&&typeof r()==\"string\"?a=x(o,`${r()} = __placeholder`):a=()=>{};let c=()=>{let h;return s(w=>h=w),En(h)?h.get():h},l=h=>{let w;s(F=>w=F),En(w)?w.set(h):a(()=>{},{scope:{__placeholder:h}})};typeof r==\"string\"&&e.type===\"radio\"&&m(()=>{e.hasAttribute(\"name\")||e.setAttribute(\"name\",r)});var u=e.tagName.toLowerCase()===\"select\"||[\"checkbox\",\"radio\"].includes(e.type)||t.includes(\"lazy\")?\"change\":\"input\";let p=I?()=>{}:ae(e,u,t,h=>{l(Kt(e,t,h,c()))});if(t.includes(\"fill\")&&([void 0,null,\"\"].includes(c())||ze(e)&&Array.isArray(c())||e.tagName.toLowerCase()===\"select\"&&e.multiple)&&l(Kt(e,t,{target:e},c())),e._x_removeModelListeners||(e._x_removeModelListeners={}),e._x_removeModelListeners.default=p,i(()=>e._x_removeModelListeners.default()),e.form){let h=ae(e.form,\"reset\",[],w=>{ie(()=>e._x_model&&e._x_model.set(Kt(e,t,{target:e},c())))});i(()=>h())}e._x_model={get(){return c()},set(h){l(h)}},e._x_forceModelUpdate=h=>{h===void 0&&typeof r==\"string\"&&r.match(/\\./)&&(h=\"\"),window.fromModel=!0,m(()=>ge(e,\"value\",h)),delete window.fromModel},n(()=>{let h=c();t.includes(\"unintrusive\")&&document.activeElement.isSameNode(e)||e._x_forceModelUpdate(h)})});function Kt(e,t,r,n){return m(()=>{if(r instanceof CustomEvent&&r.detail!==void 0)return r.detail!==null&&r.detail!==void 0?r.detail:r.target.value;if(ze(e))if(Array.isArray(n)){let i=null;return t.includes(\"number\")?i=Ht(r.target.value):t.includes(\"boolean\")?i=xe(r.target.value):i=r.target.value,r.target.checked?n.includes(i)?n:n.concat([i]):n.filter(o=>!Xi(o,i))}else return r.target.checked;else{if(e.tagName.toLowerCase()===\"select\"&&e.multiple)return t.includes(\"number\")?Array.from(r.target.selectedOptions).map(i=>{let o=i.value||i.text;return Ht(o)}):t.includes(\"boolean\")?Array.from(r.target.selectedOptions).map(i=>{let o=i.value||i.text;return xe(o)}):Array.from(r.target.selectedOptions).map(i=>i.value||i.text);{let i;return Ot(e)?r.target.checked?i=r.target.value:i=n:i=r.target.value,t.includes(\"number\")?Ht(i):t.includes(\"boolean\")?xe(i):t.includes(\"trim\")?i.trim():i}}})}function Ht(e){let t=e?parseFloat(e):null;return Zi(t)?t:e}function Xi(e,t){return e==t}function Zi(e){return!Array.isArray(e)&&!isNaN(e)}function En(e){return e!==null&&typeof e==\"object\"&&typeof e.get==\"function\"&&typeof e.set==\"function\"}d(\"cloak\",e=>queueMicrotask(()=>m(()=>e.removeAttribute(C(\"cloak\")))));$e(()=>`[${C(\"init\")}]`);d(\"init\",A((e,{expression:t},{evaluate:r})=>typeof t==\"string\"?!!t.trim()&&r(t,{},!1):r(t,{},!1)));d(\"text\",(e,{expression:t},{effect:r,evaluateLater:n})=>{let i=n(t);r(()=>{i(o=>{m(()=>{e.textContent=o})})})});d(\"html\",(e,{expression:t},{effect:r,evaluateLater:n})=>{let i=n(t);r(()=>{i(o=>{m(()=>{e.innerHTML=o,e._x_ignoreSelf=!0,S(e),delete e._x_ignoreSelf})})})});ne(Pe(\":\",Ie(C(\"bind:\"))));var vn=(e,{value:t,modifiers:r,expression:n,original:i},{effect:o,cleanup:s})=>{if(!t){let c={};qr(c),x(e,n)(u=>{Tt(e,u,i)},{scope:c});return}if(t===\"key\")return Qi(e,n);if(e._x_inlineBindings&&e._x_inlineBindings[t]&&e._x_inlineBindings[t].extract)return;let a=x(e,n);o(()=>a(c=>{c===void 0&&typeof n==\"string\"&&n.match(/\\./)&&(c=\"\"),m(()=>ge(e,t,c,r))})),s(()=>{e._x_undoAddedClasses&&e._x_undoAddedClasses(),e._x_undoAddedStyles&&e._x_undoAddedStyles()})};vn.inline=(e,{value:t,modifiers:r,expression:n})=>{t&&(e._x_inlineBindings||(e._x_inlineBindings={}),e._x_inlineBindings[t]={expression:n,extract:!1})};d(\"bind\",vn);function Qi(e,t){e._x_keyExpression=t}Le(()=>`[${C(\"data\")}]`);d(\"data\",(e,{expression:t},{cleanup:r})=>{if(eo(e))return;t=t===\"\"?\"{}\":t;let n={};fe(n,e);let i={};Gr(i,n);let o=R(e,t,{scope:i});(o===void 0||o===!0)&&(o={}),fe(o,e);let s=T(o);Te(s);let a=k(e,s);s.init&&R(e,s.init),r(()=>{s.destroy&&R(e,s.destroy),a()})});H((e,t)=>{e._x_dataStack&&(t._x_dataStack=e._x_dataStack,t.setAttribute(\"data-has-alpine-state\",!0))});function eo(e){return I?Be?!0:e.hasAttribute(\"data-has-alpine-state\"):!1}d(\"show\",(e,{modifiers:t,expression:r},{effect:n})=>{let i=x(e,r);e._x_doHide||(e._x_doHide=()=>{m(()=>{e.style.setProperty(\"display\",\"none\",t.includes(\"important\")?\"important\":void 0)})}),e._x_doShow||(e._x_doShow=()=>{m(()=>{e.style.length===1&&e.style.display===\"none\"?e.removeAttribute(\"style\"):e.style.removeProperty(\"display\")})});let o=()=>{e._x_doHide(),e._x_isShown=!1},s=()=>{e._x_doShow(),e._x_isShown=!0},a=()=>setTimeout(s),c=he(p=>p?s():o(),p=>{typeof e._x_toggleAndCascadeWithTransitions==\"function\"?e._x_toggleAndCascadeWithTransitions(e,p,s,o):p?a():o()}),l,u=!0;n(()=>i(p=>{!u&&p===l||(t.includes(\"immediate\")&&(p?a():o()),c(p),l=p,u=!1)}))});d(\"for\",(e,{expression:t},{effect:r,cleanup:n})=>{let i=ro(t),o=x(e,i.items),s=x(e,e._x_keyExpression||\"index\");e._x_prevKeys=[],e._x_lookup={},r(()=>to(e,i,o,s)),n(()=>{Object.values(e._x_lookup).forEach(a=>m(()=>{P(a),a.remove()})),delete e._x_prevKeys,delete e._x_lookup})});function to(e,t,r,n){let i=s=>typeof s==\"object\"&&!Array.isArray(s),o=e;r(s=>{no(s)&&s>=0&&(s=Array.from(Array(s).keys(),f=>f+1)),s===void 0&&(s=[]);let a=e._x_lookup,c=e._x_prevKeys,l=[],u=[];if(i(s))s=Object.entries(s).map(([f,g])=>{let b=Sn(t,g,f,s);n(v=>{u.includes(v)&&E(\"Duplicate key on x-for\",e),u.push(v)},{scope:{index:f,...b}}),l.push(b)});else for(let f=0;f<s.length;f++){let g=Sn(t,s[f],f,s);n(b=>{u.includes(b)&&E(\"Duplicate key on x-for\",e),u.push(b)},{scope:{index:f,...g}}),l.push(g)}let p=[],h=[],w=[],F=[];for(let f=0;f<c.length;f++){let g=c[f];u.indexOf(g)===-1&&w.push(g)}c=c.filter(f=>!w.includes(f));let Ee=\"template\";for(let f=0;f<u.length;f++){let g=u[f],b=c.indexOf(g);if(b===-1)c.splice(f,0,g),p.push([Ee,f]);else if(b!==f){let v=c.splice(f,1)[0],O=c.splice(b-1,1)[0];c.splice(f,0,O),c.splice(b,0,v),h.push([v,O])}else F.push(g);Ee=g}for(let f=0;f<w.length;f++){let g=w[f];g in a&&(m(()=>{P(a[g]),a[g].remove()}),delete a[g])}for(let f=0;f<h.length;f++){let[g,b]=h[f],v=a[g],O=a[b],ee=document.createElement(\"div\");m(()=>{O||E('x-for \":key\" is undefined or invalid',o,b,a),O.after(ee),v.after(O),O._x_currentIfEl&&O.after(O._x_currentIfEl),ee.before(v),v._x_currentIfEl&&v.after(v._x_currentIfEl),ee.remove()}),O._x_refreshXForScope(l[u.indexOf(b)])}for(let f=0;f<p.length;f++){let[g,b]=p[f],v=g===\"template\"?o:a[g];v._x_currentIfEl&&(v=v._x_currentIfEl);let O=l[b],ee=u[b],ce=document.importNode(o.content,!0).firstElementChild,qt=T(O);k(ce,qt,o),ce._x_refreshXForScope=On=>{Object.entries(On).forEach(([Cn,Tn])=>{qt[Cn]=Tn})},m(()=>{v.after(ce),A(()=>S(ce))()}),typeof ee==\"object\"&&E(\"x-for key cannot be an object, it must be a string or an integer\",o),a[ee]=ce}for(let f=0;f<F.length;f++)a[F[f]]._x_refreshXForScope(l[u.indexOf(F[f])]);o._x_prevKeys=u})}function ro(e){let t=/,([^,\\}\\]]*)(?:,([^,\\}\\]]*))?$/,r=/^\\s*\\(|\\)\\s*$/g,n=/([\\s\\S]*?)\\s+(?:in|of)\\s+([\\s\\S]*)/,i=e.match(n);if(!i)return;let o={};o.items=i[2].trim();let s=i[1].replace(r,\"\").trim(),a=s.match(t);return a?(o.item=s.replace(t,\"\").trim(),o.index=a[1].trim(),a[2]&&(o.collection=a[2].trim())):o.item=s,o}function Sn(e,t,r,n){let i={};return/^\\[.*\\]$/.test(e.item)&&Array.isArray(t)?e.item.replace(\"[\",\"\").replace(\"]\",\"\").split(\",\").map(s=>s.trim()).forEach((s,a)=>{i[s]=t[a]}):/^\\{.*\\}$/.test(e.item)&&!Array.isArray(t)&&typeof t==\"object\"?e.item.replace(\"{\",\"\").replace(\"}\",\"\").split(\",\").map(s=>s.trim()).forEach(s=>{i[s]=t[s]}):i[e.item]=t,e.index&&(i[e.index]=r),e.collection&&(i[e.collection]=n),i}function no(e){return!Array.isArray(e)&&!isNaN(e)}function An(){}An.inline=(e,{expression:t},{cleanup:r})=>{let n=Y(e);n._x_refs||(n._x_refs={}),n._x_refs[t]=e,r(()=>delete n._x_refs[t])};d(\"ref\",An);d(\"if\",(e,{expression:t},{effect:r,cleanup:n})=>{e.tagName.toLowerCase()!==\"template\"&&E(\"x-if can only be used on a <template> tag\",e);let i=x(e,t),o=()=>{if(e._x_currentIfEl)return e._x_currentIfEl;let a=e.content.cloneNode(!0).firstElementChild;return k(a,{},e),m(()=>{e.after(a),A(()=>S(a))()}),e._x_currentIfEl=a,e._x_undoIf=()=>{m(()=>{P(a),a.remove()}),delete e._x_currentIfEl},a},s=()=>{e._x_undoIf&&(e._x_undoIf(),delete e._x_undoIf)};r(()=>i(a=>{a?o():s()})),n(()=>e._x_undoIf&&e._x_undoIf())});d(\"id\",(e,{expression:t},{evaluate:r})=>{r(t).forEach(i=>_n(e,i))});H((e,t)=>{e._x_ids&&(t._x_ids=e._x_ids)});ne(Pe(\"@\",Ie(C(\"on:\"))));d(\"on\",A((e,{value:t,modifiers:r,expression:n},{cleanup:i})=>{let o=n?x(e,n):()=>{};e.tagName.toLowerCase()===\"template\"&&(e._x_forwardEvents||(e._x_forwardEvents=[]),e._x_forwardEvents.includes(t)||e._x_forwardEvents.push(t));let s=ae(e,t,r,a=>{o(()=>{},{scope:{$event:a},params:[a]})});i(()=>s())}));rt(\"Collapse\",\"collapse\",\"collapse\");rt(\"Intersect\",\"intersect\",\"intersect\");rt(\"Focus\",\"trap\",\"focus\");rt(\"Mask\",\"mask\",\"mask\");function rt(e,t,r){d(t,n=>E(`You can't use [x-${t}] without first installing the \"${e}\" plugin here: https://alpinejs.dev/plugins/${r}`,n))}K.setEvaluator(xt);K.setReactivityEngine({reactive:et,effect:rn,release:nn,raw:_});var Vt=K;window.Alpine=Vt;queueMicrotask(()=>{Vt.start()});})();\n//# sourceMappingURL=alpine3.min.js.map\n","Hyva_Theme/js/alpine.min.js":"/**\n * Minified by jsDelivr using Terser v5.3.5.\n * Original file: /gh/alpinejs/alpine@2.8.2/dist/alpine.js\n *\n * Do NOT use SRI with dynamically generated files! More information: https://www.jsdelivr.com/using-sri-with-dynamic-files\n */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):(e=e||self).Alpine=t()}(this,(function(){\"use strict\";function e(e,t,n){return t in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function t(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var i=Object.getOwnPropertySymbols(e);t&&(i=i.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,i)}return n}function n(n){for(var i=1;i<arguments.length;i++){var r=null!=arguments[i]?arguments[i]:{};i%2?t(Object(r),!0).forEach((function(t){e(n,t,r[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(n,Object.getOwnPropertyDescriptors(r)):t(Object(r)).forEach((function(e){Object.defineProperty(n,e,Object.getOwnPropertyDescriptor(r,e))}))}return n}function i(e){return Array.from(new Set(e))}function r(){return navigator.userAgent.includes(\"Node.js\")||navigator.userAgent.includes(\"jsdom\")}function s(e,t){return e==t}function o(e,t){\"template\"!==e.tagName.toLowerCase()?console.warn(`Alpine: [${t}] directive should only be added to <template> tags. See https://github.com/alpinejs/alpine#${t}`):1!==e.content.childElementCount&&console.warn(`Alpine: <template> tag with [${t}] encountered with an unexpected number of root elements. Make sure <template> has a single root element. `)}function a(e){return e.toLowerCase().replace(/-(\\w)/g,((e,t)=>t.toUpperCase()))}function l(e,t){if(!1===t(e))return;let n=e.firstElementChild;for(;n;)l(n,t),n=n.nextElementSibling}function c(e,t){var n;return function(){var i=this,r=arguments,s=function(){n=null,e.apply(i,r)};clearTimeout(n),n=setTimeout(s,t)}}const u=(e,t,n)=>{if(console.warn(`Alpine Error: \"${n}\"\\n\\nExpression: \"${t}\"\\nElement:`,e),!r())throw Object.assign(n,{el:e,expression:t}),n};function d(e,{el:t,expression:n}){try{const i=e();return i instanceof Promise?i.catch((e=>u(t,n,e))):i}catch(e){u(t,n,e)}}function f(e,t,n,i={}){return d((()=>\"function\"==typeof t?t.call(n):new Function([\"$data\",...Object.keys(i)],`var __alpine_result; with($data) { __alpine_result = ${t} }; return __alpine_result`)(n,...Object.values(i))),{el:e,expression:t})}const m=/^x-(on|bind|data|text|html|model|if|for|show|cloak|transition|ref|spread)\\b/;function p(e){const t=y(e.name);return m.test(t)}function h(e,t,n){let i=Array.from(e.attributes).filter(p).map(v),r=i.filter((e=>\"spread\"===e.type))[0];if(r){let n=f(e,r.expression,t.$data);i=i.concat(Object.entries(n).map((([e,t])=>v({name:e,value:t}))))}return n?i.filter((e=>e.type===n)):function(e){let t=[\"bind\",\"model\",\"show\",\"catch-all\"];return e.sort(((e,n)=>{let i=-1===t.indexOf(e.type)?\"catch-all\":e.type,r=-1===t.indexOf(n.type)?\"catch-all\":n.type;return t.indexOf(i)-t.indexOf(r)}))}(i)}function v({name:e,value:t}){const n=y(e),i=n.match(m),r=n.match(/:([a-zA-Z0-9\\-:]+)/),s=n.match(/\\.[^.\\]]+(?=[^\\]]*$)/g)||[];return{type:i?i[1]:null,value:r?r[1]:null,modifiers:s.map((e=>e.replace(\".\",\"\"))),expression:t}}function y(e){return e.startsWith(\"@\")?e.replace(\"@\",\"x-on:\"):e.startsWith(\":\")?e.replace(\":\",\"x-bind:\"):e}function b(e,t=Boolean){return e.split(\" \").filter(t)}const g=\"in\",x=\"out\",_=\"cancelled\";function w(e,t,n,i,r=!1){if(r)return t();if(e.__x_transition&&e.__x_transition.type===g)return;const s=h(e,i,\"transition\"),o=h(e,i,\"show\")[0];if(o&&o.modifiers.includes(\"transition\")){let i=o.modifiers;if(i.includes(\"out\")&&!i.includes(\"in\"))return t();const r=i.includes(\"in\")&&i.includes(\"out\");i=r?i.filter(((e,t)=>t<i.indexOf(\"out\"))):i,function(e,t,n,i){const r={duration:O(t,\"duration\",150),origin:O(t,\"origin\",\"center\"),first:{opacity:0,scale:O(t,\"scale\",95)},second:{opacity:1,scale:100}};k(e,t,n,(()=>{}),i,r,g)}(e,i,t,n)}else s.some((e=>[\"enter\",\"enter-start\",\"enter-end\"].includes(e.value)))?function(e,t,n,i,r){const s=b(A((n.find((e=>\"enter\"===e.value))||{expression:\"\"}).expression,e,t)),o=b(A((n.find((e=>\"enter-start\"===e.value))||{expression:\"\"}).expression,e,t)),a=b(A((n.find((e=>\"enter-end\"===e.value))||{expression:\"\"}).expression,e,t));S(e,s,o,a,i,(()=>{}),g,r)}(e,i,s,t,n):t()}function E(e,t,n,i,r=!1){if(r)return t();if(e.__x_transition&&e.__x_transition.type===x)return;const s=h(e,i,\"transition\"),o=h(e,i,\"show\")[0];if(o&&o.modifiers.includes(\"transition\")){let i=o.modifiers;if(i.includes(\"in\")&&!i.includes(\"out\"))return t();const r=i.includes(\"in\")&&i.includes(\"out\");i=r?i.filter(((e,t)=>t>i.indexOf(\"out\"))):i,function(e,t,n,i,r){const s={duration:n?O(t,\"duration\",150):O(t,\"duration\",150)/2,origin:O(t,\"origin\",\"center\"),first:{opacity:1,scale:100},second:{opacity:0,scale:O(t,\"scale\",95)}};k(e,t,(()=>{}),i,r,s,x)}(e,i,r,t,n)}else s.some((e=>[\"leave\",\"leave-start\",\"leave-end\"].includes(e.value)))?function(e,t,n,i,r){const s=b(A((n.find((e=>\"leave\"===e.value))||{expression:\"\"}).expression,e,t)),o=b(A((n.find((e=>\"leave-start\"===e.value))||{expression:\"\"}).expression,e,t)),a=b(A((n.find((e=>\"leave-end\"===e.value))||{expression:\"\"}).expression,e,t));S(e,s,o,a,(()=>{}),i,x,r)}(e,i,s,t,n):t()}function O(e,t,n){if(-1===e.indexOf(t))return n;const i=e[e.indexOf(t)+1];if(!i)return n;if(\"scale\"===t&&!P(i))return n;if(\"duration\"===t){let e=i.match(/([0-9]+)ms/);if(e)return e[1]}return\"origin\"===t&&[\"top\",\"right\",\"left\",\"center\",\"bottom\"].includes(e[e.indexOf(t)+2])?[i,e[e.indexOf(t)+2]].join(\" \"):i}function k(e,t,n,i,r,s,o){e.__x_transition&&e.__x_transition.cancel&&e.__x_transition.cancel();const a=e.style.opacity,l=e.style.transform,c=e.style.transformOrigin,u=!t.includes(\"opacity\")&&!t.includes(\"scale\"),d=u||t.includes(\"opacity\"),f=u||t.includes(\"scale\"),m={start(){d&&(e.style.opacity=s.first.opacity),f&&(e.style.transform=`scale(${s.first.scale/100})`)},during(){f&&(e.style.transformOrigin=s.origin),e.style.transitionProperty=[d?\"opacity\":\"\",f?\"transform\":\"\"].join(\" \").trim(),e.style.transitionDuration=s.duration/1e3+\"s\",e.style.transitionTimingFunction=\"cubic-bezier(0.4, 0.0, 0.2, 1)\"},show(){n()},end(){d&&(e.style.opacity=s.second.opacity),f&&(e.style.transform=`scale(${s.second.scale/100})`)},hide(){i()},cleanup(){d&&(e.style.opacity=a),f&&(e.style.transform=l),f&&(e.style.transformOrigin=c),e.style.transitionProperty=null,e.style.transitionDuration=null,e.style.transitionTimingFunction=null}};$(e,m,o,r)}const A=(e,t,n)=>\"function\"==typeof e?n.evaluateReturnExpression(t,e):e;function S(e,t,n,i,r,s,o,a){e.__x_transition&&e.__x_transition.cancel&&e.__x_transition.cancel();const l=e.__x_original_classes||[],c={start(){e.classList.add(...n)},during(){e.classList.add(...t)},show(){r()},end(){e.classList.remove(...n.filter((e=>!l.includes(e)))),e.classList.add(...i)},hide(){s()},cleanup(){e.classList.remove(...t.filter((e=>!l.includes(e)))),e.classList.remove(...i.filter((e=>!l.includes(e))))}};$(e,c,o,a)}function $(e,t,n,i){const r=C((()=>{t.hide(),e.isConnected&&t.cleanup(),delete e.__x_transition}));e.__x_transition={type:n,cancel:C((()=>{i(_),r()})),finish:r,nextFrame:null},t.start(),t.during(),e.__x_transition.nextFrame=requestAnimationFrame((()=>{let n=1e3*Number(getComputedStyle(e).transitionDuration.replace(/,.*/,\"\").replace(\"s\",\"\"));0===n&&(n=1e3*Number(getComputedStyle(e).animationDuration.replace(\"s\",\"\"))),t.show(),e.__x_transition.nextFrame=requestAnimationFrame((()=>{t.end(),setTimeout(e.__x_transition.finish,n)}))}))}function P(e){return!Array.isArray(e)&&!isNaN(e)}function C(e){let t=!1;return function(){t||(t=!0,e.apply(this,arguments))}}function j(e,t,i,r,s){o(t,\"x-for\");let a=D(\"function\"==typeof i?e.evaluateReturnExpression(t,i):i),l=function(e,t,n,i){let r=h(t,e,\"if\")[0];if(r&&!e.evaluateReturnExpression(t,r.expression))return[];let s=e.evaluateReturnExpression(t,n.items,i);P(s)&&s>=0&&(s=Array.from(Array(s).keys(),(e=>e+1)));return s}(e,t,a,s),c=t;l.forEach(((i,o)=>{let u=function(e,t,i,r,s){let o=s?n({},s):{};o[e.item]=t,e.index&&(o[e.index]=i);e.collection&&(o[e.collection]=r);return o}(a,i,o,l,s()),d=function(e,t,n,i){let r=h(t,e,\"bind\").filter((e=>\"key\"===e.value))[0];return r?e.evaluateReturnExpression(t,r.expression,(()=>i)):n}(e,t,o,u),f=function(e,t){if(!e)return;if(void 0===e.__x_for_key)return;if(e.__x_for_key===t)return e;let n=e;for(;n;){if(n.__x_for_key===t)return n.parentElement.insertBefore(n,e);n=!(!n.nextElementSibling||void 0===n.nextElementSibling.__x_for_key)&&n.nextElementSibling}}(c.nextElementSibling,d);f?(delete f.__x_for_key,f.__x_for=u,e.updateElements(f,(()=>f.__x_for))):(f=function(e,t){let n=document.importNode(e.content,!0);return t.parentElement.insertBefore(n,t.nextElementSibling),t.nextElementSibling}(t,c),w(f,(()=>{}),(()=>{}),e,r),f.__x_for=u,e.initializeElements(f,(()=>f.__x_for))),c=f,c.__x_for_key=d})),function(e,t){var n=!(!e.nextElementSibling||void 0===e.nextElementSibling.__x_for_key)&&e.nextElementSibling;for(;n;){let e=n,i=n.nextElementSibling;E(n,(()=>{e.remove()}),(()=>{}),t),n=!(!i||void 0===i.__x_for_key)&&i}}(c,e)}function D(e){let t=/,([^,\\}\\]]*)(?:,([^,\\}\\]]*))?$/,n=String(e).match(/([\\s\\S]*?)\\s+(?:in|of)\\s+([\\s\\S]*)/);if(!n)return;let i={};i.items=n[2].trim();let r=n[1].trim().replace(/^\\(|\\)$/g,\"\"),s=r.match(t);return s?(i.item=r.replace(t,\"\").trim(),i.index=s[1].trim(),s[2]&&(i.collection=s[2].trim())):i.item=r,i}function T(e,t,n,r,o,l,c){var u=e.evaluateReturnExpression(t,r,o);if(\"value\"===n){if(ge.ignoreFocusedForValueBinding&&document.activeElement.isSameNode(t))return;if(void 0===u&&String(r).match(/\\./)&&(u=\"\"),\"radio\"===t.type)void 0===t.attributes.value&&\"bind\"===l?t.value=u:\"bind\"!==l&&(t.checked=s(t.value,u));else if(\"checkbox\"===t.type)\"boolean\"==typeof u||[null,void 0].includes(u)||\"bind\"!==l?\"bind\"!==l&&(Array.isArray(u)?t.checked=u.some((e=>s(e,t.value))):t.checked=!!u):t.value=String(u);else if(\"SELECT\"===t.tagName)!function(e,t){const n=[].concat(t).map((e=>e+\"\"));Array.from(e.options).forEach((e=>{e.selected=n.includes(e.value||e.text)}))}(t,u);else{if(t.value===u)return;t.value=u}}else if(\"class\"===n)if(Array.isArray(u)){const e=t.__x_original_classes||[];t.setAttribute(\"class\",i(e.concat(u)).join(\" \"))}else if(\"object\"==typeof u){Object.keys(u).sort(((e,t)=>u[e]-u[t])).forEach((e=>{u[e]?b(e).forEach((e=>t.classList.add(e))):b(e).forEach((e=>t.classList.remove(e)))}))}else{const e=t.__x_original_classes||[],n=u?b(u):[];t.setAttribute(\"class\",i(e.concat(n)).join(\" \"))}else n=c.includes(\"camel\")?a(n):n,[null,void 0,!1].includes(u)?t.removeAttribute(n):!function(e){return[\"disabled\",\"checked\",\"required\",\"readonly\",\"hidden\",\"open\",\"selected\",\"autofocus\",\"itemscope\",\"multiple\",\"novalidate\",\"allowfullscreen\",\"allowpaymentrequest\",\"formnovalidate\",\"autoplay\",\"controls\",\"loop\",\"muted\",\"playsinline\",\"default\",\"ismap\",\"reversed\",\"async\",\"defer\",\"nomodule\"].includes(e)}(n)?L(t,n,u):L(t,n,n)}function L(e,t,n){e.getAttribute(t)!=n&&e.setAttribute(t,n)}function N(e,t,n,i,r,s={}){const o={passive:i.includes(\"passive\")};let l,u;if(i.includes(\"camel\")&&(n=a(n)),i.includes(\"away\")?(u=document,l=a=>{t.contains(a.target)||t.offsetWidth<1&&t.offsetHeight<1||(z(e,r,a,s),i.includes(\"once\")&&document.removeEventListener(n,l,o))}):(u=i.includes(\"window\")?window:i.includes(\"document\")?document:t,l=a=>{if(u!==window&&u!==document||document.body.contains(t)){if(!(function(e){return[\"keydown\",\"keyup\"].includes(e)}(n)&&function(e,t){let n=t.filter((e=>![\"window\",\"document\",\"prevent\",\"stop\"].includes(e)));if(n.includes(\"debounce\")){let e=n.indexOf(\"debounce\");n.splice(e,P((n[e+1]||\"invalid-wait\").split(\"ms\")[0])?2:1)}if(0===n.length)return!1;if(1===n.length&&n[0]===R(e.key))return!1;const i=[\"ctrl\",\"shift\",\"alt\",\"meta\",\"cmd\",\"super\"].filter((e=>n.includes(e)));if(n=n.filter((e=>!i.includes(e))),i.length>0){if(i.filter((t=>(\"cmd\"!==t&&\"super\"!==t||(t=\"meta\"),e[t+\"Key\"]))).length===i.length&&n[0]===R(e.key))return!1}return!0}(a,i)||(i.includes(\"prevent\")&&a.preventDefault(),i.includes(\"stop\")&&a.stopPropagation(),i.includes(\"self\")&&a.target!==t))){z(e,r,a,s).then((e=>{!1===e?a.preventDefault():i.includes(\"once\")&&u.removeEventListener(n,l,o)}))}}else u.removeEventListener(n,l,o)}),i.includes(\"debounce\")){let e=i[i.indexOf(\"debounce\")+1]||\"invalid-wait\",t=P(e.split(\"ms\")[0])?Number(e.split(\"ms\")[0]):250;l=c(l,t)}u.addEventListener(n,l,o)}function z(e,t,i,r){return e.evaluateCommandExpression(i.target,t,(()=>n(n({},r()),{},{$event:i})))}function R(e){switch(e){case\"/\":return\"slash\";case\" \":case\"Spacebar\":return\"space\";default:return e&&e.replace(/([a-z])([A-Z])/g,\"$1-$2\").replace(/[_\\s]/,\"-\").toLowerCase()}}function F(e,t,n){return\"radio\"===e.type&&(e.hasAttribute(\"name\")||e.setAttribute(\"name\",n)),(n,i)=>{if(n instanceof CustomEvent&&n.detail)return n.detail;if(\"checkbox\"===e.type){if(Array.isArray(i)){const e=t.includes(\"number\")?I(n.target.value):n.target.value;return n.target.checked?i.concat([e]):i.filter((t=>!s(t,e)))}return n.target.checked}if(\"select\"===e.tagName.toLowerCase()&&e.multiple)return t.includes(\"number\")?Array.from(n.target.selectedOptions).map((e=>I(e.value||e.text))):Array.from(n.target.selectedOptions).map((e=>e.value||e.text));{const e=n.target.value;return t.includes(\"number\")?I(e):t.includes(\"trim\")?e.trim():e}}}function I(e){const t=e?parseFloat(e):null;return P(t)?t:e}const{isArray:M}=Array,{getPrototypeOf:B,create:q,defineProperty:U,defineProperties:W,isExtensible:K,getOwnPropertyDescriptor:G,getOwnPropertyNames:H,getOwnPropertySymbols:V,preventExtensions:Z,hasOwnProperty:J}=Object,{push:Q,concat:X,map:Y}=Array.prototype;function ee(e){return void 0===e}function te(e){return\"function\"==typeof e}const ne=new WeakMap;function ie(e,t){ne.set(e,t)}const re=e=>ne.get(e)||e;function se(e,t){return e.valueIsObservable(t)?e.getProxy(t):t}function oe(e,t,n){X.call(H(n),V(n)).forEach((i=>{let r=G(n,i);r.configurable||(r=ve(e,r,se)),U(t,i,r)})),Z(t)}class ae{constructor(e,t){this.originalTarget=t,this.membrane=e}get(e,t){const{originalTarget:n,membrane:i}=this,r=n[t],{valueObserved:s}=i;return s(n,t),i.getProxy(r)}set(e,t,n){const{originalTarget:i,membrane:{valueMutated:r}}=this;return i[t]!==n?(i[t]=n,r(i,t)):\"length\"===t&&M(i)&&r(i,t),!0}deleteProperty(e,t){const{originalTarget:n,membrane:{valueMutated:i}}=this;return delete n[t],i(n,t),!0}apply(e,t,n){}construct(e,t,n){}has(e,t){const{originalTarget:n,membrane:{valueObserved:i}}=this;return i(n,t),t in n}ownKeys(e){const{originalTarget:t}=this;return X.call(H(t),V(t))}isExtensible(e){const t=K(e);if(!t)return t;const{originalTarget:n,membrane:i}=this,r=K(n);return r||oe(i,e,n),r}setPrototypeOf(e,t){}getPrototypeOf(e){const{originalTarget:t}=this;return B(t)}getOwnPropertyDescriptor(e,t){const{originalTarget:n,membrane:i}=this,{valueObserved:r}=this.membrane;r(n,t);let s=G(n,t);if(ee(s))return s;const o=G(e,t);return ee(o)?(s=ve(i,s,se),s.configurable||U(e,t,s),s):o}preventExtensions(e){const{originalTarget:t,membrane:n}=this;return oe(n,e,t),Z(t),!0}defineProperty(e,t,n){const{originalTarget:i,membrane:r}=this,{valueMutated:s}=r,{configurable:o}=n;if(J.call(n,\"writable\")&&!J.call(n,\"value\")){const e=G(i,t);n.value=e.value}return U(i,t,function(e){return J.call(e,\"value\")&&(e.value=re(e.value)),e}(n)),!1===o&&U(e,t,ve(r,n,se)),s(i,t),!0}}function le(e,t){return e.valueIsObservable(t)?e.getReadOnlyProxy(t):t}class ce{constructor(e,t){this.originalTarget=t,this.membrane=e}get(e,t){const{membrane:n,originalTarget:i}=this,r=i[t],{valueObserved:s}=n;return s(i,t),n.getReadOnlyProxy(r)}set(e,t,n){return!1}deleteProperty(e,t){return!1}apply(e,t,n){}construct(e,t,n){}has(e,t){const{originalTarget:n,membrane:{valueObserved:i}}=this;return i(n,t),t in n}ownKeys(e){const{originalTarget:t}=this;return X.call(H(t),V(t))}setPrototypeOf(e,t){}getOwnPropertyDescriptor(e,t){const{originalTarget:n,membrane:i}=this,{valueObserved:r}=i;r(n,t);let s=G(n,t);if(ee(s))return s;const o=G(e,t);return ee(o)?(s=ve(i,s,le),J.call(s,\"set\")&&(s.set=void 0),s.configurable||U(e,t,s),s):o}preventExtensions(e){return!1}defineProperty(e,t,n){return!1}}function ue(e){let t=void 0;return M(e)?t=[]:\"object\"==typeof e&&(t={}),t}const de=Object.prototype;function fe(e){if(null===e)return!1;if(\"object\"!=typeof e)return!1;if(M(e))return!0;const t=B(e);return t===de||null===t||null===B(t)}const me=(e,t)=>{},pe=(e,t)=>{},he=e=>e;function ve(e,t,n){const{set:i,get:r}=t;return J.call(t,\"value\")?t.value=n(e,t.value):(ee(r)||(t.get=function(){return n(e,r.call(re(this)))}),ee(i)||(t.set=function(t){i.call(re(this),e.unwrapProxy(t))})),t}class ye{constructor(e){if(this.valueDistortion=he,this.valueMutated=pe,this.valueObserved=me,this.valueIsObservable=fe,this.objectGraph=new WeakMap,!ee(e)){const{valueDistortion:t,valueMutated:n,valueObserved:i,valueIsObservable:r}=e;this.valueDistortion=te(t)?t:he,this.valueMutated=te(n)?n:pe,this.valueObserved=te(i)?i:me,this.valueIsObservable=te(r)?r:fe}}getProxy(e){const t=re(e),n=this.valueDistortion(t);if(this.valueIsObservable(n)){const i=this.getReactiveState(t,n);return i.readOnly===e?e:i.reactive}return n}getReadOnlyProxy(e){e=re(e);const t=this.valueDistortion(e);return this.valueIsObservable(t)?this.getReactiveState(e,t).readOnly:t}unwrapProxy(e){return re(e)}getReactiveState(e,t){const{objectGraph:n}=this;let i=n.get(t);if(i)return i;const r=this;return i={get reactive(){const n=new ae(r,t),i=new Proxy(ue(t),n);return ie(i,e),U(this,\"reactive\",{value:i}),i},get readOnly(){const n=new ce(r,t),i=new Proxy(ue(t),n);return ie(i,e),U(this,\"readOnly\",{value:i}),i}},n.set(t,i),i}}class be{constructor(e,t=null){this.$el=e;const n=this.$el.getAttribute(\"x-data\"),i=\"\"===n?\"{}\":n,r=this.$el.getAttribute(\"x-init\");let s={$el:this.$el},o=t?t.$el:this.$el;Object.entries(ge.magicProperties).forEach((([e,t])=>{Object.defineProperty(s,\"$\"+e,{get:function(){return t(o)}})})),this.unobservedData=t?t.getUnobservedData():f(e,i,s);let{membrane:a,data:l}=this.wrapDataInObservable(this.unobservedData);var c;this.$data=l,this.membrane=a,this.unobservedData.$el=this.$el,this.unobservedData.$refs=this.getRefsProxy(),this.nextTickStack=[],this.unobservedData.$nextTick=e=>{this.nextTickStack.push(e)},this.watchers={},this.unobservedData.$watch=(e,t)=>{this.watchers[e]||(this.watchers[e]=[]),this.watchers[e].push(t)},Object.entries(ge.magicProperties).forEach((([e,t])=>{Object.defineProperty(this.unobservedData,\"$\"+e,{get:function(){return t(o,this.$el)}})})),this.showDirectiveStack=[],this.showDirectiveLastElement,t||ge.onBeforeComponentInitializeds.forEach((e=>e(this))),r&&!t&&(this.pauseReactivity=!0,c=this.evaluateReturnExpression(this.$el,r),this.pauseReactivity=!1),this.initializeElements(this.$el,(()=>{}),t),this.listenForNewElementsToInitialize(),\"function\"==typeof c&&c.call(this.$data),t||setTimeout((()=>{ge.onComponentInitializeds.forEach((e=>e(this)))}),0)}getUnobservedData(){return function(e,t){let n=e.unwrapProxy(t),i={};return Object.keys(n).forEach((e=>{[\"$el\",\"$refs\",\"$nextTick\",\"$watch\"].includes(e)||(i[e]=n[e])})),i}(this.membrane,this.$data)}wrapDataInObservable(e){var t=this;let n=c((function(){t.updateElements(t.$el)}),0);return function(e,t){let n=new ye({valueMutated(e,n){t(e,n)}});return{data:n.getProxy(e),membrane:n}}(e,((e,i)=>{t.watchers[i]?t.watchers[i].forEach((t=>t(e[i]))):Array.isArray(e)?Object.keys(t.watchers).forEach((n=>{let r=n.split(\".\");\"length\"!==i&&r.reduce(((i,r)=>(Object.is(e,i[r])&&t.watchers[n].forEach((t=>t(e))),i[r])),t.unobservedData)})):Object.keys(t.watchers).filter((e=>e.includes(\".\"))).forEach((n=>{let r=n.split(\".\");i===r[r.length-1]&&r.reduce(((r,s)=>(Object.is(e,r)&&t.watchers[n].forEach((t=>t(e[i]))),r[s])),t.unobservedData)})),t.pauseReactivity||n()}))}walkAndSkipNestedComponents(e,t,n=(()=>{})){l(e,(e=>e.hasAttribute(\"x-data\")&&!e.isSameNode(this.$el)?(e.__x||n(e),!1):t(e)))}initializeElements(e,t=(()=>{}),n=!1){this.walkAndSkipNestedComponents(e,(e=>void 0===e.__x_for_key&&(void 0===e.__x_inserted_me&&void this.initializeElement(e,t,!n))),(e=>{n||(e.__x=new be(e))})),this.executeAndClearRemainingShowDirectiveStack(),this.executeAndClearNextTickStack(e)}initializeElement(e,t,n=!0){e.hasAttribute(\"class\")&&h(e,this).length>0&&(e.__x_original_classes=b(e.getAttribute(\"class\"))),n&&this.registerListeners(e,t),this.resolveBoundAttributes(e,!0,t)}updateElements(e,t=(()=>{})){this.walkAndSkipNestedComponents(e,(e=>{if(void 0!==e.__x_for_key&&!e.isSameNode(this.$el))return!1;this.updateElement(e,t)}),(e=>{e.__x=new be(e)})),this.executeAndClearRemainingShowDirectiveStack(),this.executeAndClearNextTickStack(e)}executeAndClearNextTickStack(e){e===this.$el&&this.nextTickStack.length>0&&requestAnimationFrame((()=>{for(;this.nextTickStack.length>0;)this.nextTickStack.shift()()}))}executeAndClearRemainingShowDirectiveStack(){this.showDirectiveStack.reverse().map((e=>new Promise(((t,n)=>{e(t,n)})))).reduce(((e,t)=>e.then((()=>t.then((e=>{e()}))))),Promise.resolve((()=>{}))).catch((e=>{if(e!==_)throw e})),this.showDirectiveStack=[],this.showDirectiveLastElement=void 0}updateElement(e,t){this.resolveBoundAttributes(e,!1,t)}registerListeners(e,t){h(e,this).forEach((({type:i,value:r,modifiers:s,expression:o})=>{switch(i){case\"on\":N(this,e,r,s,o,t);break;case\"model\":!function(e,t,i,r,s){var o=\"select\"===t.tagName.toLowerCase()||[\"checkbox\",\"radio\"].includes(t.type)||i.includes(\"lazy\")?\"change\":\"input\";N(e,t,o,i,`${r} = rightSideOfExpression($event, ${r})`,(()=>n(n({},s()),{},{rightSideOfExpression:F(t,i,r)})))}(this,e,s,o,t)}}))}resolveBoundAttributes(e,t=!1,n){let i=h(e,this);i.forEach((({type:r,value:s,modifiers:a,expression:l})=>{switch(r){case\"model\":T(this,e,\"value\",l,n,r,a);break;case\"bind\":if(\"template\"===e.tagName.toLowerCase()&&\"key\"===s)return;T(this,e,s,l,n,r,a);break;case\"text\":var c=this.evaluateReturnExpression(e,l,n);!function(e,t,n){void 0===t&&String(n).match(/\\./)&&(t=\"\"),e.textContent=t}(e,c,l);break;case\"html\":!function(e,t,n,i){t.innerHTML=e.evaluateReturnExpression(t,n,i)}(this,e,l,n);break;case\"show\":c=this.evaluateReturnExpression(e,l,n);!function(e,t,n,i,r=!1){const s=()=>{t.style.display=\"none\",t.__x_is_shown=!1},o=()=>{1===t.style.length&&\"none\"===t.style.display?t.removeAttribute(\"style\"):t.style.removeProperty(\"display\"),t.__x_is_shown=!0};if(!0===r)return void(n?o():s());const a=(i,r)=>{n?((\"none\"===t.style.display||t.__x_transition)&&w(t,(()=>{o()}),r,e),i((()=>{}))):\"none\"!==t.style.display?E(t,(()=>{i((()=>{s()}))}),r,e):i((()=>{}))};i.includes(\"immediate\")?a((e=>e()),(()=>{})):(e.showDirectiveLastElement&&!e.showDirectiveLastElement.contains(t)&&e.executeAndClearRemainingShowDirectiveStack(),e.showDirectiveStack.push(a),e.showDirectiveLastElement=t)}(this,e,c,a,t);break;case\"if\":if(i.some((e=>\"for\"===e.type)))return;c=this.evaluateReturnExpression(e,l,n);!function(e,t,n,i,r){o(t,\"x-if\");const s=t.nextElementSibling&&!0===t.nextElementSibling.__x_inserted_me;if(!n||s&&!t.__x_transition)!n&&s&&E(t.nextElementSibling,(()=>{t.nextElementSibling.remove()}),(()=>{}),e,i);else{const n=document.importNode(t.content,!0);t.parentElement.insertBefore(n,t.nextElementSibling),w(t.nextElementSibling,(()=>{}),(()=>{}),e,i),e.initializeElements(t.nextElementSibling,r),t.nextElementSibling.__x_inserted_me=!0}}(this,e,c,t,n);break;case\"for\":j(this,e,l,t,n);break;case\"cloak\":e.removeAttribute(\"x-cloak\")}}))}evaluateReturnExpression(e,t,i=(()=>{})){return f(e,t,this.$data,n(n({},i()),{},{$dispatch:this.getDispatchFunction(e)}))}evaluateCommandExpression(e,t,i=(()=>{})){return function(e,t,n,i={}){return d((()=>{if(\"function\"==typeof t)return Promise.resolve(t.call(n,i.$event));let e=Function;if(e=Object.getPrototypeOf((async function(){})).constructor,Object.keys(n).includes(t)){let e=new Function([\"dataContext\",...Object.keys(i)],`with(dataContext) { return ${t} }`)(n,...Object.values(i));return\"function\"==typeof e?Promise.resolve(e.call(n,i.$event)):Promise.resolve()}return Promise.resolve(new e([\"dataContext\",...Object.keys(i)],`with(dataContext) { ${t} }`)(n,...Object.values(i)))}),{el:e,expression:t})}(e,t,this.$data,n(n({},i()),{},{$dispatch:this.getDispatchFunction(e)}))}getDispatchFunction(e){return(t,n={})=>{e.dispatchEvent(new CustomEvent(t,{detail:n,bubbles:!0}))}}listenForNewElementsToInitialize(){const e=this.$el;new MutationObserver((e=>{for(let t=0;t<e.length;t++){const n=e[t].target.closest(\"[x-data]\");if(n&&n.isSameNode(this.$el)){if(\"attributes\"===e[t].type&&\"x-data\"===e[t].attributeName){const n=e[t].target.getAttribute(\"x-data\")||\"{}\",i=f(this.$el,n,{$el:this.$el});Object.keys(i).forEach((e=>{this.$data[e]!==i[e]&&(this.$data[e]=i[e])}))}e[t].addedNodes.length>0&&e[t].addedNodes.forEach((e=>{1!==e.nodeType||e.__x_inserted_me||(!e.matches(\"[x-data]\")||e.__x?this.initializeElements(e):e.__x=new be(e))}))}}})).observe(e,{childList:!0,attributes:!0,subtree:!0})}getRefsProxy(){var e=this;return new Proxy({},{get(t,n){return\"$isAlpineProxy\"===n||(e.walkAndSkipNestedComponents(e.$el,(e=>{e.hasAttribute(\"x-ref\")&&e.getAttribute(\"x-ref\")===n&&(i=e)})),i);var i}})}}const ge={version:\"2.8.2\",pauseMutationObserver:!1,magicProperties:{},onComponentInitializeds:[],onBeforeComponentInitializeds:[],ignoreFocusedForValueBinding:!1,start:async function(){r()||await new Promise((e=>{\"loading\"==document.readyState?document.addEventListener(\"DOMContentLoaded\",e):e()})),this.discoverComponents((e=>{this.initializeComponent(e)})),document.addEventListener(\"turbolinks:load\",(()=>{this.discoverUninitializedComponents((e=>{this.initializeComponent(e)}))})),this.listenForNewUninitializedComponentsAtRunTime()},discoverComponents:function(e){document.querySelectorAll(\"[x-data]\").forEach((t=>{e(t)}))},discoverUninitializedComponents:function(e,t=null){const n=(t||document).querySelectorAll(\"[x-data]\");Array.from(n).filter((e=>void 0===e.__x)).forEach((t=>{e(t)}))},listenForNewUninitializedComponentsAtRunTime:function(){const e=document.querySelector(\"body\");new MutationObserver((e=>{if(!this.pauseMutationObserver)for(let t=0;t<e.length;t++)e[t].addedNodes.length>0&&e[t].addedNodes.forEach((e=>{1===e.nodeType&&(e.parentElement&&e.parentElement.closest(\"[x-data]\")||this.discoverUninitializedComponents((e=>{this.initializeComponent(e)}),e.parentElement))}))})).observe(e,{childList:!0,attributes:!0,subtree:!0})},initializeComponent:function(e){if(!e.__x)try{e.__x=new be(e)}catch(e){setTimeout((()=>{throw e}),0)}},clone:function(e,t){t.__x||(t.__x=new be(t,e))},addMagicProperty:function(e,t){this.magicProperties[e]=t},onComponentInitialized:function(e){this.onComponentInitializeds.push(e)},onBeforeComponentInitialized:function(e){this.onBeforeComponentInitializeds.push(e)}};return r()||(window.Alpine=ge,window.deferLoadingAlpine?window.deferLoadingAlpine((function(){window.Alpine.start()})):window.Alpine.start()),ge}));\n//# sourceMappingURL=alpine.min.js.map\n","Hyva_Theme/js/alpine3-csp.min.js":"(()=>{var it=!1,ot=!1,W=[],st=-1;function Wt(e){Mn(e)}function Mn(e){W.includes(e)||W.push(e),Nn()}function Gt(e){let t=W.indexOf(e);t!==-1&&t>st&&W.splice(t,1)}function Nn(){!ot&&!it&&(it=!0,queueMicrotask(kn))}function kn(){it=!1,ot=!0;for(let e=0;e<W.length;e++)W[e](),st=e;W.length=0,st=-1,ot=!1}var T,N,F,ct,at=!0;function Jt(e){at=!1,e(),at=!0}function Yt(e){T=e.reactive,F=e.release,N=t=>e.effect(t,{scheduler:r=>{at?Wt(r):r()}}),ct=e.raw}function lt(e){N=e}function Xt(e){let t=()=>{};return[n=>{let i=N(n);return e._x_effects||(e._x_effects=new Set,e._x_runEffects=()=>{e._x_effects.forEach(o=>o())}),e._x_effects.add(i),t=()=>{i!==void 0&&(e._x_effects.delete(i),F(i))},i},()=>{t()}]}function Se(e,t){let r=!0,n,i=N(()=>{let o=e();JSON.stringify(o),r?n=o:queueMicrotask(()=>{t(o,n),n=o}),r=!1});return()=>F(i)}var Zt=[],Qt=[],er=[];function tr(e){er.push(e)}function re(e,t){typeof t==\"function\"?(e._x_cleanups||(e._x_cleanups=[]),e._x_cleanups.push(t)):(t=e,Qt.push(t))}function Oe(e){Zt.push(e)}function Ce(e,t,r){e._x_attributeCleanups||(e._x_attributeCleanups={}),e._x_attributeCleanups[t]||(e._x_attributeCleanups[t]=[]),e._x_attributeCleanups[t].push(r)}function ut(e,t){e._x_attributeCleanups&&Object.entries(e._x_attributeCleanups).forEach(([r,n])=>{(t===void 0||t.includes(r))&&(n.forEach(i=>i()),delete e._x_attributeCleanups[r])})}function rr(e){for(e._x_effects?.forEach(Gt);e._x_cleanups?.length;)e._x_cleanups.pop()()}var ft=new MutationObserver(ht),dt=!1;function de(){ft.observe(document,{subtree:!0,childList:!0,attributes:!0,attributeOldValue:!0}),dt=!0}function pt(){Dn(),ft.disconnect(),dt=!1}var fe=[];function Dn(){let e=ft.takeRecords();fe.push(()=>e.length>0&&ht(e));let t=fe.length;queueMicrotask(()=>{if(fe.length===t)for(;fe.length>0;)fe.shift()()})}function m(e){if(!dt)return e();pt();let t=e();return de(),t}var mt=!1,Ae=[];function nr(){mt=!0}function ir(){mt=!1,ht(Ae),Ae=[]}function ht(e){if(mt){Ae=Ae.concat(e);return}let t=[],r=new Set,n=new Map,i=new Map;for(let o=0;o<e.length;o++)if(!e[o].target._x_ignoreMutationObserver&&(e[o].type===\"childList\"&&(e[o].removedNodes.forEach(s=>{s.nodeType===1&&s._x_marker&&r.add(s)}),e[o].addedNodes.forEach(s=>{if(s.nodeType===1){if(r.has(s)){r.delete(s);return}s._x_marker||t.push(s)}})),e[o].type===\"attributes\")){let s=e[o].target,a=e[o].attributeName,c=e[o].oldValue,l=()=>{n.has(s)||n.set(s,[]),n.get(s).push({name:a,value:s.getAttribute(a)})},u=()=>{i.has(s)||i.set(s,[]),i.get(s).push(a)};s.hasAttribute(a)&&c===null?l():s.hasAttribute(a)?(u(),l()):u()}i.forEach((o,s)=>{ut(s,o)}),n.forEach((o,s)=>{Zt.forEach(a=>a(s,o))});for(let o of r)t.some(s=>s.contains(o))||Qt.forEach(s=>s(o));for(let o of t)o.isConnected&&er.forEach(s=>s(o));t=null,r=null,n=null,i=null}function Te(e){return P(k(e))}function D(e,t,r){return e._x_dataStack=[t,...k(r||e)],()=>{e._x_dataStack=e._x_dataStack.filter(n=>n!==t)}}function k(e){return e._x_dataStack?e._x_dataStack:typeof ShadowRoot==\"function\"&&e instanceof ShadowRoot?k(e.host):e.parentNode?k(e.parentNode):[]}function P(e){return new Proxy({objects:e},Pn)}var Pn={ownKeys({objects:e}){return Array.from(new Set(e.flatMap(t=>Object.keys(t))))},has({objects:e},t){return t==Symbol.unscopables?!1:e.some(r=>Object.prototype.hasOwnProperty.call(r,t)||Reflect.has(r,t))},get({objects:e},t,r){return t==\"toJSON\"?In:Reflect.get(e.find(n=>Reflect.has(n,t))||{},t,r)},set({objects:e},t,r,n){let i=e.find(s=>Object.prototype.hasOwnProperty.call(s,t))||e[e.length-1],o=Object.getOwnPropertyDescriptor(i,t);return o?.set&&o?.get?o.set.call(n,r)||!0:Reflect.set(i,t,r)}};function In(){return Reflect.ownKeys(this).reduce((t,r)=>(t[r]=Reflect.get(this,r),t),{})}function Re(e){let t=n=>typeof n==\"object\"&&!Array.isArray(n)&&n!==null,r=(n,i=\"\")=>{Object.entries(Object.getOwnPropertyDescriptors(n)).forEach(([o,{value:s,enumerable:a}])=>{if(a===!1||s===void 0||typeof s==\"object\"&&s!==null&&s.__v_skip)return;let c=i===\"\"?o:`${i}.${o}`;typeof s==\"object\"&&s!==null&&s._x_interceptor?n[o]=s.initialize(e,c,o):t(s)&&s!==n&&!(s instanceof Element)&&r(s,c)})};return r(e)}function Me(e,t=()=>{}){let r={initialValue:void 0,_x_interceptor:!0,initialize(n,i,o){return e(this.initialValue,()=>$n(n,i),s=>_t(n,i,s),i,o)}};return t(r),n=>{if(typeof n==\"object\"&&n!==null&&n._x_interceptor){let i=r.initialize.bind(r);r.initialize=(o,s,a)=>{let c=n.initialize(o,s,a);return r.initialValue=c,i(o,s,a)}}else r.initialValue=n;return r}}function $n(e,t){return t.split(\".\").reduce((r,n)=>r[n],e)}function _t(e,t,r){if(typeof t==\"string\"&&(t=t.split(\".\")),t.length===1)e[t[0]]=r;else{if(t.length===0)throw error;return e[t[0]]||(e[t[0]]={}),_t(e[t[0]],t.slice(1),r)}}var or={};function y(e,t){or[e]=t}function G(e,t){let r=Ln(t);return Object.entries(or).forEach(([n,i])=>{Object.defineProperty(e,`$${n}`,{get(){return i(t,r)},enumerable:!1})}),e}function Ln(e){let[t,r]=gt(e),n={interceptor:Me,...t};return re(e,r),n}function Ne(e,t,r,...n){try{return r(...n)}catch(i){ne(i,e,t)}}function ne(e,t,r=void 0){e=Object.assign(e??{message:\"No error message given.\"},{el:t,expression:r}),console.warn(`Alpine Expression Error: ${e.message}\n\n${r?'Expression: \"'+r+`\"\n\n`:\"\"}`,t),setTimeout(()=>{throw e},0)}var ke=!0;function De(e){let t=ke;ke=!1;let r=e();return ke=t,r}function R(e,t,r={}){let n;return x(e,t)(i=>n=i,r),n}function x(...e){return sr(...e)}var sr=jn;function ar(e){sr=e}function jn(e,t){let r={};G(r,e);let n=[r,...k(e)],i=typeof t==\"function\"?yt(n,t):Bn(n,t,e);return Ne.bind(null,e,t,i)}function yt(e,t){return(r=()=>{},{scope:n={},params:i=[]}={})=>{let o=t.apply(P([n,...e]),i);ie(r,o)}}var xt={};function Fn(e,t){if(xt[e])return xt[e];let r=Object.getPrototypeOf(async function(){}).constructor,n=/^[\\n\\s]*if.*\\(.*\\)/.test(e.trim())||/^(let|const)\\s/.test(e.trim())?`(async()=>{ ${e} })()`:e,o=(()=>{try{let s=new r([\"__self\",\"scope\"],`with (scope) { __self.result = ${n} }; __self.finished = true; return __self.result;`);return Object.defineProperty(s,\"name\",{value:`[Alpine] ${e}`}),s}catch(s){return ne(s,t,e),Promise.resolve()}})();return xt[e]=o,o}function Bn(e,t,r){let n=Fn(t,r);return(i=()=>{},{scope:o={},params:s=[]}={})=>{n.result=void 0,n.finished=!1;let a=P([o,...e]);if(typeof n==\"function\"){let c=n(n,a).catch(l=>ne(l,r,t));n.finished?(ie(i,n.result,a,s,r),n.result=void 0):c.then(l=>{ie(i,l,a,s,r)}).catch(l=>ne(l,r,t)).finally(()=>n.result=void 0)}}}function ie(e,t,r,n,i){if(ke&&typeof t==\"function\"){let o=t.apply(r,n);o instanceof Promise?o.then(s=>ie(e,s,r,n)).catch(s=>ne(s,i,t)):e(o)}else typeof t==\"object\"&&t instanceof Promise?t.then(o=>e(o)):e(t)}var Et=\"x-\";function C(e=\"\"){return Et+e}function cr(e){Et=e}var Pe={};function d(e,t){return Pe[e]=t,{before(r){if(!Pe[r]){console.warn(String.raw`Cannot find directive \\`${r}\\`. \\`${e}\\` will use the default order of execution`);return}let n=J.indexOf(r);J.splice(n>=0?n:J.indexOf(\"DEFAULT\"),0,e)}}}function lr(e){return Object.keys(Pe).includes(e)}function me(e,t,r){if(t=Array.from(t),e._x_virtualDirectives){let o=Object.entries(e._x_virtualDirectives).map(([a,c])=>({name:a,value:c})),s=vt(o);o=o.map(a=>s.find(c=>c.name===a.name)?{name:`x-bind:${a.name}`,value:`\"${a.value}\"`}:a),t=t.concat(o)}let n={};return t.map(dr((o,s)=>n[o]=s)).filter(mr).map(Kn(n,r)).sort(Hn).map(o=>zn(e,o))}function vt(e){return Array.from(e).map(dr()).filter(t=>!mr(t))}var bt=!1,pe=new Map,ur=Symbol();function fr(e){bt=!0;let t=Symbol();ur=t,pe.set(t,[]);let r=()=>{for(;pe.get(t).length;)pe.get(t).shift()();pe.delete(t)},n=()=>{bt=!1,r()};e(r),n()}function gt(e){let t=[],r=a=>t.push(a),[n,i]=Xt(e);return t.push(i),[{Alpine:K,effect:n,cleanup:r,evaluateLater:x.bind(x,e),evaluate:R.bind(R,e)},()=>t.forEach(a=>a())]}function zn(e,t){let r=()=>{},n=Pe[t.type]||r,[i,o]=gt(e);Ce(e,t.original,o);let s=()=>{e._x_ignore||e._x_ignoreSelf||(n.inline&&n.inline(e,t,i),n=n.bind(n,e,t,i),bt?pe.get(ur).push(n):n())};return s.runCleanups=o,s}var Ie=(e,t)=>({name:r,value:n})=>(r.startsWith(e)&&(r=r.replace(e,t)),{name:r,value:n}),$e=e=>e;function dr(e=()=>{}){return({name:t,value:r})=>{let{name:n,value:i}=pr.reduce((o,s)=>s(o),{name:t,value:r});return n!==t&&e(n,t),{name:n,value:i}}}var pr=[];function oe(e){pr.push(e)}function mr({name:e}){return hr().test(e)}var hr=()=>new RegExp(`^${Et}([^:^.]+)\\\\b`);function Kn(e,t){return({name:r,value:n})=>{let i=r.match(hr()),o=r.match(/:([a-zA-Z0-9\\-_:]+)/),s=r.match(/\\.[^.\\]]+(?=[^\\]]*$)/g)||[],a=t||e[r]||r;return{type:i?i[1]:null,value:o?o[1]:null,modifiers:s.map(c=>c.replace(\".\",\"\")),expression:n,original:a}}}var wt=\"DEFAULT\",J=[\"ignore\",\"ref\",\"data\",\"id\",\"anchor\",\"bind\",\"init\",\"for\",\"model\",\"modelable\",\"transition\",\"show\",\"if\",wt,\"teleport\"];function Hn(e,t){let r=J.indexOf(e.type)===-1?wt:e.type,n=J.indexOf(t.type)===-1?wt:t.type;return J.indexOf(r)-J.indexOf(n)}function Y(e,t,r={}){e.dispatchEvent(new CustomEvent(t,{detail:r,bubbles:!0,composed:!0,cancelable:!0}))}function I(e,t){if(typeof ShadowRoot==\"function\"&&e instanceof ShadowRoot){Array.from(e.children).forEach(i=>I(i,t));return}let r=!1;if(t(e,()=>r=!0),r)return;let n=e.firstElementChild;for(;n;)I(n,t,!1),n=n.nextElementSibling}function E(e,...t){console.warn(`Alpine Warning: ${e}`,...t)}var _r=!1;function gr(){_r&&E(\"Alpine has already been initialized on this page. Calling Alpine.start() more than once can cause problems.\"),_r=!0,document.body||E(\"Unable to initialize. Trying to load Alpine before `<body>` is available. Did you forget to add `defer` in Alpine's `<script>` tag?\"),Y(document,\"alpine:init\"),Y(document,\"alpine:initializing\"),de(),tr(t=>S(t,I)),re(t=>$(t)),Oe((t,r)=>{me(t,r).forEach(n=>n())});let e=t=>!X(t.parentElement,!0);Array.from(document.querySelectorAll(br().join(\",\"))).filter(e).forEach(t=>{S(t)}),Y(document,\"alpine:initialized\"),setTimeout(()=>{qn()})}var St=[],xr=[];function yr(){return St.map(e=>e())}function br(){return St.concat(xr).map(e=>e())}function Le(e){St.push(e)}function je(e){xr.push(e)}function X(e,t=!1){return B(e,r=>{if((t?br():yr()).some(i=>r.matches(i)))return!0})}function B(e,t){if(e){if(t(e))return e;if(e._x_teleportBack&&(e=e._x_teleportBack),!!e.parentElement)return B(e.parentElement,t)}}function wr(e){return yr().some(t=>e.matches(t))}var Er=[];function vr(e){Er.push(e)}var Vn=1;function S(e,t=I,r=()=>{}){B(e,n=>n._x_ignore)||fr(()=>{t(e,(n,i)=>{n._x_marker||(r(n,i),Er.forEach(o=>o(n,i)),me(n,n.attributes).forEach(o=>o()),n._x_ignore||(n._x_marker=Vn++),n._x_ignore&&i())})})}function $(e,t=I){t(e,r=>{rr(r),ut(r),delete r._x_marker})}function qn(){[[\"ui\",\"dialog\",[\"[x-dialog], [x-popover]\"]],[\"anchor\",\"anchor\",[\"[x-anchor]\"]],[\"sort\",\"sort\",[\"[x-sort]\"]]].forEach(([t,r,n])=>{lr(r)||n.some(i=>{if(document.querySelector(i))return E(`found \"${i}\", but missing ${t} plugin`),!0})})}var At=[],Ot=!1;function se(e=()=>{}){return queueMicrotask(()=>{Ot||setTimeout(()=>{Fe()})}),new Promise(t=>{At.push(()=>{e(),t()})})}function Fe(){for(Ot=!1;At.length;)At.shift()()}function Sr(){Ot=!0}function he(e,t){return Array.isArray(t)?Ar(e,t.join(\" \")):typeof t==\"object\"&&t!==null?Un(e,t):typeof t==\"function\"?he(e,t()):Ar(e,t)}function Ar(e,t){let r=o=>o.split(\" \").filter(Boolean),n=o=>o.split(\" \").filter(s=>!e.classList.contains(s)).filter(Boolean),i=o=>(e.classList.add(...o),()=>{e.classList.remove(...o)});return t=t===!0?t=\"\":t||\"\",i(n(t))}function Un(e,t){let r=a=>a.split(\" \").filter(Boolean),n=Object.entries(t).flatMap(([a,c])=>c?r(a):!1).filter(Boolean),i=Object.entries(t).flatMap(([a,c])=>c?!1:r(a)).filter(Boolean),o=[],s=[];return i.forEach(a=>{e.classList.contains(a)&&(e.classList.remove(a),s.push(a))}),n.forEach(a=>{e.classList.contains(a)||(e.classList.add(a),o.push(a))}),()=>{s.forEach(a=>e.classList.add(a)),o.forEach(a=>e.classList.remove(a))}}function Z(e,t){return typeof t==\"object\"&&t!==null?Wn(e,t):Gn(e,t)}function Wn(e,t){let r={};return Object.entries(t).forEach(([n,i])=>{r[n]=e.style[n],n.startsWith(\"--\")||(n=Jn(n)),e.style.setProperty(n,i)}),setTimeout(()=>{e.style.length===0&&e.removeAttribute(\"style\")}),()=>{Z(e,r)}}function Gn(e,t){let r=e.getAttribute(\"style\",t);return e.setAttribute(\"style\",t),()=>{e.setAttribute(\"style\",r||\"\")}}function Jn(e){return e.replace(/([a-z])([A-Z])/g,\"$1-$2\").toLowerCase()}function _e(e,t=()=>{}){let r=!1;return function(){r?t.apply(this,arguments):(r=!0,e.apply(this,arguments))}}d(\"transition\",(e,{value:t,modifiers:r,expression:n},{evaluate:i})=>{typeof n==\"function\"&&(n=i(n)),n!==!1&&(!n||typeof n==\"boolean\"?Xn(e,r,t):Yn(e,n,t))});function Yn(e,t,r){Or(e,he,\"\"),{enter:i=>{e._x_transition.enter.during=i},\"enter-start\":i=>{e._x_transition.enter.start=i},\"enter-end\":i=>{e._x_transition.enter.end=i},leave:i=>{e._x_transition.leave.during=i},\"leave-start\":i=>{e._x_transition.leave.start=i},\"leave-end\":i=>{e._x_transition.leave.end=i}}[r](t)}function Xn(e,t,r){Or(e,Z);let n=!t.includes(\"in\")&&!t.includes(\"out\")&&!r,i=n||t.includes(\"in\")||[\"enter\"].includes(r),o=n||t.includes(\"out\")||[\"leave\"].includes(r);t.includes(\"in\")&&!n&&(t=t.filter((g,b)=>b<t.indexOf(\"out\"))),t.includes(\"out\")&&!n&&(t=t.filter((g,b)=>b>t.indexOf(\"out\")));let s=!t.includes(\"opacity\")&&!t.includes(\"scale\"),a=s||t.includes(\"opacity\"),c=s||t.includes(\"scale\"),l=a?0:1,u=c?ge(t,\"scale\",95)/100:1,p=ge(t,\"delay\",0)/1e3,h=ge(t,\"origin\",\"center\"),w=\"opacity, transform\",z=ge(t,\"duration\",150)/1e3,ve=ge(t,\"duration\",75)/1e3,f=\"cubic-bezier(0.4, 0.0, 0.2, 1)\";i&&(e._x_transition.enter.during={transformOrigin:h,transitionDelay:`${p}s`,transitionProperty:w,transitionDuration:`${z}s`,transitionTimingFunction:f},e._x_transition.enter.start={opacity:l,transform:`scale(${u})`},e._x_transition.enter.end={opacity:1,transform:\"scale(1)\"}),o&&(e._x_transition.leave.during={transformOrigin:h,transitionDelay:`${p}s`,transitionProperty:w,transitionDuration:`${ve}s`,transitionTimingFunction:f},e._x_transition.leave.start={opacity:1,transform:\"scale(1)\"},e._x_transition.leave.end={opacity:l,transform:`scale(${u})`})}function Or(e,t,r={}){e._x_transition||(e._x_transition={enter:{during:r,start:r,end:r},leave:{during:r,start:r,end:r},in(n=()=>{},i=()=>{}){Be(e,t,{during:this.enter.during,start:this.enter.start,end:this.enter.end},n,i)},out(n=()=>{},i=()=>{}){Be(e,t,{during:this.leave.during,start:this.leave.start,end:this.leave.end},n,i)}})}window.Element.prototype._x_toggleAndCascadeWithTransitions=function(e,t,r,n){let i=document.visibilityState===\"visible\"?requestAnimationFrame:setTimeout,o=()=>i(r);if(t){e._x_transition&&(e._x_transition.enter||e._x_transition.leave)?e._x_transition.enter&&(Object.entries(e._x_transition.enter.during).length||Object.entries(e._x_transition.enter.start).length||Object.entries(e._x_transition.enter.end).length)?e._x_transition.in(r):o():e._x_transition?e._x_transition.in(r):o();return}e._x_hidePromise=e._x_transition?new Promise((s,a)=>{e._x_transition.out(()=>{},()=>s(n)),e._x_transitioning&&e._x_transitioning.beforeCancel(()=>a({isFromCancelledTransition:!0}))}):Promise.resolve(n),queueMicrotask(()=>{let s=Cr(e);s?(s._x_hideChildren||(s._x_hideChildren=[]),s._x_hideChildren.push(e)):i(()=>{let a=c=>{let l=Promise.all([c._x_hidePromise,...(c._x_hideChildren||[]).map(a)]).then(([u])=>u?.());return delete c._x_hidePromise,delete c._x_hideChildren,l};a(e).catch(c=>{if(!c.isFromCancelledTransition)throw c})})})};function Cr(e){let t=e.parentNode;if(t)return t._x_hidePromise?t:Cr(t)}function Be(e,t,{during:r,start:n,end:i}={},o=()=>{},s=()=>{}){if(e._x_transitioning&&e._x_transitioning.cancel(),Object.keys(r).length===0&&Object.keys(n).length===0&&Object.keys(i).length===0){o(),s();return}let a,c,l;Zn(e,{start(){a=t(e,n)},during(){c=t(e,r)},before:o,end(){a(),l=t(e,i)},after:s,cleanup(){c(),l()}})}function Zn(e,t){let r,n,i,o=_e(()=>{m(()=>{r=!0,n||t.before(),i||(t.end(),Fe()),t.after(),e.isConnected&&t.cleanup(),delete e._x_transitioning})});e._x_transitioning={beforeCancels:[],beforeCancel(s){this.beforeCancels.push(s)},cancel:_e(function(){for(;this.beforeCancels.length;)this.beforeCancels.shift()();o()}),finish:o},m(()=>{t.start(),t.during()}),Sr(),requestAnimationFrame(()=>{if(r)return;let s=Number(getComputedStyle(e).transitionDuration.replace(/,.*/,\"\").replace(\"s\",\"\"))*1e3,a=Number(getComputedStyle(e).transitionDelay.replace(/,.*/,\"\").replace(\"s\",\"\"))*1e3;s===0&&(s=Number(getComputedStyle(e).animationDuration.replace(\"s\",\"\"))*1e3),m(()=>{t.before()}),n=!0,requestAnimationFrame(()=>{r||(m(()=>{t.end()}),Fe(),setTimeout(e._x_transitioning.finish,s+a),i=!0)})})}function ge(e,t,r){if(e.indexOf(t)===-1)return r;let n=e[e.indexOf(t)+1];if(!n||t===\"scale\"&&isNaN(n))return r;if(t===\"duration\"||t===\"delay\"){let i=n.match(/([0-9]+)ms/);if(i)return i[1]}return t===\"origin\"&&[\"top\",\"right\",\"left\",\"center\",\"bottom\"].includes(e[e.indexOf(t)+2])?[n,e[e.indexOf(t)+2]].join(\" \"):n}var L=!1;function A(e,t=()=>{}){return(...r)=>L?t(...r):e(...r)}function Tr(e){return(...t)=>L&&e(...t)}var Rr=[];function H(e){Rr.push(e)}function Mr(e,t){Rr.forEach(r=>r(e,t)),L=!0,kr(()=>{S(t,(r,n)=>{n(r,()=>{})})}),L=!1}var ze=!1;function Nr(e,t){t._x_dataStack||(t._x_dataStack=e._x_dataStack),L=!0,ze=!0,kr(()=>{Qn(t)}),L=!1,ze=!1}function Qn(e){let t=!1;S(e,(n,i)=>{I(n,(o,s)=>{if(t&&wr(o))return s();t=!0,i(o,s)})})}function kr(e){let t=N;lt((r,n)=>{let i=t(r);return F(i),()=>{}}),e(),lt(t)}function xe(e,t,r,n=[]){switch(e._x_bindings||(e._x_bindings=T({})),e._x_bindings[t]=r,t=n.includes(\"camel\")?ai(t):t,t){case\"value\":ei(e,r);break;case\"style\":ri(e,r);break;case\"class\":ti(e,r);break;case\"selected\":case\"checked\":ni(e,t,r);break;default:Pr(e,t,r);break}}function ei(e,t){if(Ct(e))e.attributes.value===void 0&&(e.value=t),window.fromModel&&(typeof t==\"boolean\"?e.checked=ye(e.value)===t:e.checked=Dr(e.value,t));else if(Ke(e))Number.isInteger(t)?e.value=t:!Array.isArray(t)&&typeof t!=\"boolean\"&&![null,void 0].includes(t)?e.value=String(t):Array.isArray(t)?e.checked=t.some(r=>Dr(r,e.value)):e.checked=!!t;else if(e.tagName===\"SELECT\")si(e,t);else{if(e.value===t)return;e.value=t===void 0?\"\":t}}function ti(e,t){e._x_undoAddedClasses&&e._x_undoAddedClasses(),e._x_undoAddedClasses=he(e,t)}function ri(e,t){e._x_undoAddedStyles&&e._x_undoAddedStyles(),e._x_undoAddedStyles=Z(e,t)}function ni(e,t,r){Pr(e,t,r),oi(e,t,r)}function Pr(e,t,r){[null,void 0,!1].includes(r)&&li(t)?e.removeAttribute(t):(Ir(t)&&(r=t),ii(e,t,r))}function ii(e,t,r){e.getAttribute(t)!=r&&e.setAttribute(t,r)}function oi(e,t,r){e[t]!==r&&(e[t]=r)}function si(e,t){let r=[].concat(t).map(n=>n+\"\");Array.from(e.options).forEach(n=>{n.selected=r.includes(n.value)})}function ai(e){return e.toLowerCase().replace(/-(\\w)/g,(t,r)=>r.toUpperCase())}function Dr(e,t){return e==t}function ye(e){return[1,\"1\",\"true\",\"on\",\"yes\",!0].includes(e)?!0:[0,\"0\",\"false\",\"off\",\"no\",!1].includes(e)?!1:e?Boolean(e):null}var ci=new Set([\"allowfullscreen\",\"async\",\"autofocus\",\"autoplay\",\"checked\",\"controls\",\"default\",\"defer\",\"disabled\",\"formnovalidate\",\"inert\",\"ismap\",\"itemscope\",\"loop\",\"multiple\",\"muted\",\"nomodule\",\"novalidate\",\"open\",\"playsinline\",\"readonly\",\"required\",\"reversed\",\"selected\",\"shadowrootclonable\",\"shadowrootdelegatesfocus\",\"shadowrootserializable\"]);function Ir(e){return ci.has(e)}function li(e){return![\"aria-pressed\",\"aria-checked\",\"aria-expanded\",\"aria-selected\"].includes(e)}function $r(e,t,r){return e._x_bindings&&e._x_bindings[t]!==void 0?e._x_bindings[t]:jr(e,t,r)}function Lr(e,t,r,n=!0){if(e._x_bindings&&e._x_bindings[t]!==void 0)return e._x_bindings[t];if(e._x_inlineBindings&&e._x_inlineBindings[t]!==void 0){let i=e._x_inlineBindings[t];return i.extract=n,De(()=>R(e,i.expression))}return jr(e,t,r)}function jr(e,t,r){let n=e.getAttribute(t);return n===null?typeof r==\"function\"?r():r:n===\"\"?!0:Ir(t)?!![t,\"true\"].includes(n):n}function Ke(e){return e.type===\"checkbox\"||e.localName===\"ui-checkbox\"||e.localName===\"ui-switch\"}function Ct(e){return e.type===\"radio\"||e.localName===\"ui-radio\"}function He(e,t){var r;return function(){var n=this,i=arguments,o=function(){r=null,e.apply(n,i)};clearTimeout(r),r=setTimeout(o,t)}}function Ve(e,t){let r;return function(){let n=this,i=arguments;r||(e.apply(n,i),r=!0,setTimeout(()=>r=!1,t))}}function qe({get:e,set:t},{get:r,set:n}){let i=!0,o,s,a=N(()=>{let c=e(),l=r();if(i)n(Tt(c)),i=!1;else{let u=JSON.stringify(c),p=JSON.stringify(l);u!==o?n(Tt(c)):u!==p&&t(Tt(l))}o=JSON.stringify(e()),s=JSON.stringify(r())});return()=>{F(a)}}function Tt(e){return typeof e==\"object\"?JSON.parse(JSON.stringify(e)):e}function Fr(e){(Array.isArray(e)?e:[e]).forEach(r=>r(K))}var Q={},Br=!1;function zr(e,t){if(Br||(Q=T(Q),Br=!0),t===void 0)return Q[e];Q[e]=t,Re(Q[e]),typeof t==\"object\"&&t!==null&&t.hasOwnProperty(\"init\")&&typeof t.init==\"function\"&&Q[e].init()}function Kr(){return Q}var Hr={};function Vr(e,t){let r=typeof t!=\"function\"?()=>t:t;return e instanceof Element?Rt(e,r()):(Hr[e]=r,()=>{})}function qr(e){return Object.entries(Hr).forEach(([t,r])=>{Object.defineProperty(e,t,{get(){return(...n)=>r(...n)}})}),e}function Rt(e,t,r){let n=[];for(;n.length;)n.pop()();let i=Object.entries(t).map(([s,a])=>({name:s,value:a})),o=vt(i);return i=i.map(s=>o.find(a=>a.name===s.name)?{name:`x-bind:${s.name}`,value:`\"${s.value}\"`}:s),me(e,i,r).map(s=>{n.push(s.runCleanups),s()}),()=>{for(;n.length;)n.pop()()}}var Ur={};function Wr(e,t){Ur[e]=t}function Gr(e,t){return Object.entries(Ur).forEach(([r,n])=>{Object.defineProperty(e,r,{get(){return(...i)=>n.bind(t)(...i)},enumerable:!1})}),e}var ui={get reactive(){return T},get release(){return F},get effect(){return N},get raw(){return ct},version:\"3.14.6\",flushAndStopDeferringMutations:ir,dontAutoEvaluateFunctions:De,disableEffectScheduling:Jt,startObservingMutations:de,stopObservingMutations:pt,setReactivityEngine:Yt,onAttributeRemoved:Ce,onAttributesAdded:Oe,closestDataStack:k,skipDuringClone:A,onlyDuringClone:Tr,addRootSelector:Le,addInitSelector:je,interceptClone:H,addScopeToNode:D,deferMutations:nr,mapAttributes:oe,evaluateLater:x,interceptInit:vr,setEvaluator:ar,mergeProxies:P,extractProp:Lr,findClosest:B,onElRemoved:re,closestRoot:X,destroyTree:$,interceptor:Me,transition:Be,setStyles:Z,mutateDom:m,directive:d,entangle:qe,throttle:Ve,debounce:He,evaluate:R,initTree:S,nextTick:se,prefixed:C,prefix:cr,plugin:Fr,magic:y,store:zr,start:gr,clone:Nr,cloneNode:Mr,bound:$r,$data:Te,watch:Se,walk:I,data:Wr,bind:Vr},K=ui;function Jr(e,t){let r=fi(e);if(typeof t==\"function\")return yt(r,t);let n=di(e,t,r);return Ne.bind(null,e,t,n)}function fi(e){let t={};return G(t,e),[t,...k(e)]}function di(e,t,r){return(n=()=>{},{scope:i={},params:o=[]}={})=>{let s=P([i,...r]),a=t.split(\".\").reduce((c,l)=>(c[l]===void 0&&pi(e,t),c[l]),s);ie(n,a,s,o)}}function pi(e,t){console.warn(`Alpine Error: Alpine is unable to interpret the following expression using the CSP-friendly build:\n\n\"${t}\"\n\nRead more about the Alpine's CSP-friendly build restrictions here: https://alpinejs.dev/advanced/csp\n\n`,e)}function Mt(e,t){let r=Object.create(null),n=e.split(\",\");for(let i=0;i<n.length;i++)r[n[i]]=!0;return t?i=>!!r[i.toLowerCase()]:i=>!!r[i]}var mi=\"itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly\";var qs=Mt(mi+\",async,autofocus,autoplay,controls,default,defer,disabled,hidden,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected\");var Yr=Object.freeze({}),Us=Object.freeze([]);var hi=Object.prototype.hasOwnProperty,be=(e,t)=>hi.call(e,t),V=Array.isArray,ae=e=>Xr(e)===\"[object Map]\";var _i=e=>typeof e==\"string\",Ue=e=>typeof e==\"symbol\",we=e=>e!==null&&typeof e==\"object\";var gi=Object.prototype.toString,Xr=e=>gi.call(e),Nt=e=>Xr(e).slice(8,-1);var We=e=>_i(e)&&e!==\"NaN\"&&e[0]!==\"-\"&&\"\"+parseInt(e,10)===e;var Ge=e=>{let t=Object.create(null);return r=>t[r]||(t[r]=e(r))},xi=/-(\\w)/g,Ws=Ge(e=>e.replace(xi,(t,r)=>r?r.toUpperCase():\"\")),yi=/\\B([A-Z])/g,Gs=Ge(e=>e.replace(yi,\"-$1\").toLowerCase()),kt=Ge(e=>e.charAt(0).toUpperCase()+e.slice(1)),Js=Ge(e=>e?`on${kt(e)}`:\"\"),Dt=(e,t)=>e!==t&&(e===e||t===t);var Pt=new WeakMap,Ee=[],j,ee=Symbol(\"iterate\"),It=Symbol(\"Map key iterate\");function bi(e){return e&&e._isEffect===!0}function nn(e,t=Yr){bi(e)&&(e=e.raw);let r=Ei(e,t);return t.lazy||r(),r}function on(e){e.active&&(sn(e),e.options.onStop&&e.options.onStop(),e.active=!1)}var wi=0;function Ei(e,t){let r=function(){if(!r.active)return e();if(!Ee.includes(r)){sn(r);try{return Si(),Ee.push(r),j=r,e()}finally{Ee.pop(),an(),j=Ee[Ee.length-1]}}};return r.id=wi++,r.allowRecurse=!!t.allowRecurse,r._isEffect=!0,r.active=!0,r.raw=e,r.deps=[],r.options=t,r}function sn(e){let{deps:t}=e;if(t.length){for(let r=0;r<t.length;r++)t[r].delete(e);t.length=0}}var ce=!0,Lt=[];function vi(){Lt.push(ce),ce=!1}function Si(){Lt.push(ce),ce=!0}function an(){let e=Lt.pop();ce=e===void 0?!0:e}function M(e,t,r){if(!ce||j===void 0)return;let n=Pt.get(e);n||Pt.set(e,n=new Map);let i=n.get(r);i||n.set(r,i=new Set),i.has(j)||(i.add(j),j.deps.push(i),j.options.onTrack&&j.options.onTrack({effect:j,target:e,type:t,key:r}))}function U(e,t,r,n,i,o){let s=Pt.get(e);if(!s)return;let a=new Set,c=u=>{u&&u.forEach(p=>{(p!==j||p.allowRecurse)&&a.add(p)})};if(t===\"clear\")s.forEach(c);else if(r===\"length\"&&V(e))s.forEach((u,p)=>{(p===\"length\"||p>=n)&&c(u)});else switch(r!==void 0&&c(s.get(r)),t){case\"add\":V(e)?We(r)&&c(s.get(\"length\")):(c(s.get(ee)),ae(e)&&c(s.get(It)));break;case\"delete\":V(e)||(c(s.get(ee)),ae(e)&&c(s.get(It)));break;case\"set\":ae(e)&&c(s.get(ee));break}let l=u=>{u.options.onTrigger&&u.options.onTrigger({effect:u,target:e,key:r,type:t,newValue:n,oldValue:i,oldTarget:o}),u.options.scheduler?u.options.scheduler(u):u()};a.forEach(l)}var Ai=Mt(\"__proto__,__v_isRef,__isVue\"),cn=new Set(Object.getOwnPropertyNames(Symbol).map(e=>Symbol[e]).filter(Ue)),Oi=ln();var Ci=ln(!0);var Zr=Ti();function Ti(){let e={};return[\"includes\",\"indexOf\",\"lastIndexOf\"].forEach(t=>{e[t]=function(...r){let n=_(this);for(let o=0,s=this.length;o<s;o++)M(n,\"get\",o+\"\");let i=n[t](...r);return i===-1||i===!1?n[t](...r.map(_)):i}}),[\"push\",\"pop\",\"shift\",\"unshift\",\"splice\"].forEach(t=>{e[t]=function(...r){vi();let n=_(this)[t].apply(this,r);return an(),n}}),e}function ln(e=!1,t=!1){return function(n,i,o){if(i===\"__v_isReactive\")return!e;if(i===\"__v_isReadonly\")return e;if(i===\"__v_raw\"&&o===(e?t?Vi:pn:t?Hi:dn).get(n))return n;let s=V(n);if(!e&&s&&be(Zr,i))return Reflect.get(Zr,i,o);let a=Reflect.get(n,i,o);return(Ue(i)?cn.has(i):Ai(i))||(e||M(n,\"get\",i),t)?a:$t(a)?!s||!We(i)?a.value:a:we(a)?e?mn(a):tt(a):a}}var Ri=Mi();function Mi(e=!1){return function(r,n,i,o){let s=r[n];if(!e&&(i=_(i),s=_(s),!V(r)&&$t(s)&&!$t(i)))return s.value=i,!0;let a=V(r)&&We(n)?Number(n)<r.length:be(r,n),c=Reflect.set(r,n,i,o);return r===_(o)&&(a?Dt(i,s)&&U(r,\"set\",n,i,s):U(r,\"add\",n,i)),c}}function Ni(e,t){let r=be(e,t),n=e[t],i=Reflect.deleteProperty(e,t);return i&&r&&U(e,\"delete\",t,void 0,n),i}function ki(e,t){let r=Reflect.has(e,t);return(!Ue(t)||!cn.has(t))&&M(e,\"has\",t),r}function Di(e){return M(e,\"iterate\",V(e)?\"length\":ee),Reflect.ownKeys(e)}var Pi={get:Oi,set:Ri,deleteProperty:Ni,has:ki,ownKeys:Di},Ii={get:Ci,set(e,t){return console.warn(`Set operation on key \"${String(t)}\" failed: target is readonly.`,e),!0},deleteProperty(e,t){return console.warn(`Delete operation on key \"${String(t)}\" failed: target is readonly.`,e),!0}};var jt=e=>we(e)?tt(e):e,Ft=e=>we(e)?mn(e):e,Bt=e=>e,et=e=>Reflect.getPrototypeOf(e);function Je(e,t,r=!1,n=!1){e=e.__v_raw;let i=_(e),o=_(t);t!==o&&!r&&M(i,\"get\",t),!r&&M(i,\"get\",o);let{has:s}=et(i),a=n?Bt:r?Ft:jt;if(s.call(i,t))return a(e.get(t));if(s.call(i,o))return a(e.get(o));e!==i&&e.get(t)}function Ye(e,t=!1){let r=this.__v_raw,n=_(r),i=_(e);return e!==i&&!t&&M(n,\"has\",e),!t&&M(n,\"has\",i),e===i?r.has(e):r.has(e)||r.has(i)}function Xe(e,t=!1){return e=e.__v_raw,!t&&M(_(e),\"iterate\",ee),Reflect.get(e,\"size\",e)}function Qr(e){e=_(e);let t=_(this);return et(t).has.call(t,e)||(t.add(e),U(t,\"add\",e,e)),this}function en(e,t){t=_(t);let r=_(this),{has:n,get:i}=et(r),o=n.call(r,e);o?fn(r,n,e):(e=_(e),o=n.call(r,e));let s=i.call(r,e);return r.set(e,t),o?Dt(t,s)&&U(r,\"set\",e,t,s):U(r,\"add\",e,t),this}function tn(e){let t=_(this),{has:r,get:n}=et(t),i=r.call(t,e);i?fn(t,r,e):(e=_(e),i=r.call(t,e));let o=n?n.call(t,e):void 0,s=t.delete(e);return i&&U(t,\"delete\",e,void 0,o),s}function rn(){let e=_(this),t=e.size!==0,r=ae(e)?new Map(e):new Set(e),n=e.clear();return t&&U(e,\"clear\",void 0,void 0,r),n}function Ze(e,t){return function(n,i){let o=this,s=o.__v_raw,a=_(s),c=t?Bt:e?Ft:jt;return!e&&M(a,\"iterate\",ee),s.forEach((l,u)=>n.call(i,c(l),c(u),o))}}function Qe(e,t,r){return function(...n){let i=this.__v_raw,o=_(i),s=ae(o),a=e===\"entries\"||e===Symbol.iterator&&s,c=e===\"keys\"&&s,l=i[e](...n),u=r?Bt:t?Ft:jt;return!t&&M(o,\"iterate\",c?It:ee),{next(){let{value:p,done:h}=l.next();return h?{value:p,done:h}:{value:a?[u(p[0]),u(p[1])]:u(p),done:h}},[Symbol.iterator](){return this}}}}function q(e){return function(...t){{let r=t[0]?`on key \"${t[0]}\" `:\"\";console.warn(`${kt(e)} operation ${r}failed: target is readonly.`,_(this))}return e===\"delete\"?!1:this}}function $i(){let e={get(o){return Je(this,o)},get size(){return Xe(this)},has:Ye,add:Qr,set:en,delete:tn,clear:rn,forEach:Ze(!1,!1)},t={get(o){return Je(this,o,!1,!0)},get size(){return Xe(this)},has:Ye,add:Qr,set:en,delete:tn,clear:rn,forEach:Ze(!1,!0)},r={get(o){return Je(this,o,!0)},get size(){return Xe(this,!0)},has(o){return Ye.call(this,o,!0)},add:q(\"add\"),set:q(\"set\"),delete:q(\"delete\"),clear:q(\"clear\"),forEach:Ze(!0,!1)},n={get(o){return Je(this,o,!0,!0)},get size(){return Xe(this,!0)},has(o){return Ye.call(this,o,!0)},add:q(\"add\"),set:q(\"set\"),delete:q(\"delete\"),clear:q(\"clear\"),forEach:Ze(!0,!0)};return[\"keys\",\"values\",\"entries\",Symbol.iterator].forEach(o=>{e[o]=Qe(o,!1,!1),r[o]=Qe(o,!0,!1),t[o]=Qe(o,!1,!0),n[o]=Qe(o,!0,!0)}),[e,r,t,n]}var[Li,ji,Fi,Bi]=$i();function un(e,t){let r=t?e?Bi:Fi:e?ji:Li;return(n,i,o)=>i===\"__v_isReactive\"?!e:i===\"__v_isReadonly\"?e:i===\"__v_raw\"?n:Reflect.get(be(r,i)&&i in n?r:n,i,o)}var zi={get:un(!1,!1)};var Ki={get:un(!0,!1)};function fn(e,t,r){let n=_(r);if(n!==r&&t.call(e,n)){let i=Nt(e);console.warn(`Reactive ${i} contains both the raw and reactive versions of the same object${i===\"Map\"?\" as keys\":\"\"}, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`)}}var dn=new WeakMap,Hi=new WeakMap,pn=new WeakMap,Vi=new WeakMap;function qi(e){switch(e){case\"Object\":case\"Array\":return 1;case\"Map\":case\"Set\":case\"WeakMap\":case\"WeakSet\":return 2;default:return 0}}function Ui(e){return e.__v_skip||!Object.isExtensible(e)?0:qi(Nt(e))}function tt(e){return e&&e.__v_isReadonly?e:hn(e,!1,Pi,zi,dn)}function mn(e){return hn(e,!0,Ii,Ki,pn)}function hn(e,t,r,n,i){if(!we(e))return console.warn(`value cannot be made reactive: ${String(e)}`),e;if(e.__v_raw&&!(t&&e.__v_isReactive))return e;let o=i.get(e);if(o)return o;let s=Ui(e);if(s===0)return e;let a=new Proxy(e,s===2?n:r);return i.set(e,a),a}function _(e){return e&&_(e.__v_raw)||e}function $t(e){return Boolean(e&&e.__v_isRef===!0)}y(\"nextTick\",()=>se);y(\"dispatch\",e=>Y.bind(Y,e));y(\"watch\",(e,{evaluateLater:t,cleanup:r})=>(n,i)=>{let o=t(n),a=Se(()=>{let c;return o(l=>c=l),c},i);r(a)});y(\"store\",Kr);y(\"data\",e=>Te(e));y(\"root\",e=>X(e));y(\"refs\",e=>(e._x_refs_proxy||(e._x_refs_proxy=P(Wi(e))),e._x_refs_proxy));function Wi(e){let t=[];return B(e,r=>{r._x_refs&&t.push(r._x_refs)}),t}var zt={};function Kt(e){return zt[e]||(zt[e]=0),++zt[e]}function _n(e,t){return B(e,r=>{if(r._x_ids&&r._x_ids[t])return!0})}function gn(e,t){e._x_ids||(e._x_ids={}),e._x_ids[t]||(e._x_ids[t]=Kt(t))}y(\"id\",(e,{cleanup:t})=>(r,n=null)=>{let i=`${r}${n?`-${n}`:\"\"}`;return Gi(e,i,t,()=>{let o=_n(e,r),s=o?o._x_ids[r]:Kt(r);return n?`${r}-${s}-${n}`:`${r}-${s}`})});H((e,t)=>{e._x_id&&(t._x_id=e._x_id)});function Gi(e,t,r,n){if(e._x_id||(e._x_id={}),e._x_id[t])return e._x_id[t];let i=n();return e._x_id[t]=i,r(()=>{delete e._x_id[t]}),i}y(\"el\",e=>e);xn(\"Focus\",\"focus\",\"focus\");xn(\"Persist\",\"persist\",\"persist\");function xn(e,t,r){y(t,n=>E(`You can't use [$${t}] without first installing the \"${e}\" plugin here: https://alpinejs.dev/plugins/${r}`,n))}d(\"modelable\",(e,{expression:t},{effect:r,evaluateLater:n,cleanup:i})=>{let o=n(t),s=()=>{let u;return o(p=>u=p),u},a=n(`${t} = __placeholder`),c=u=>a(()=>{},{scope:{__placeholder:u}}),l=s();c(l),queueMicrotask(()=>{if(!e._x_model)return;e._x_removeModelListeners.default();let u=e._x_model.get,p=e._x_model.set,h=qe({get(){return u()},set(w){p(w)}},{get(){return s()},set(w){c(w)}});i(h)})});d(\"teleport\",(e,{modifiers:t,expression:r},{cleanup:n})=>{e.tagName.toLowerCase()!==\"template\"&&E(\"x-teleport can only be used on a <template> tag\",e);let i=yn(r),o=e.content.cloneNode(!0).firstElementChild;e._x_teleport=o,o._x_teleportBack=e,e.setAttribute(\"data-teleport-template\",!0),o.setAttribute(\"data-teleport-target\",!0),e._x_forwardEvents&&e._x_forwardEvents.forEach(a=>{o.addEventListener(a,c=>{c.stopPropagation(),e.dispatchEvent(new c.constructor(c.type,c))})}),D(o,{},e);let s=(a,c,l)=>{l.includes(\"prepend\")?c.parentNode.insertBefore(a,c):l.includes(\"append\")?c.parentNode.insertBefore(a,c.nextSibling):c.appendChild(a)};m(()=>{s(o,i,t),A(()=>{S(o),o._x_ignore=!0})()}),e._x_teleportPutBack=()=>{let a=yn(r);m(()=>{s(e._x_teleport,a,t)})},n(()=>m(()=>{o.remove(),$(o)}))});var Ji=document.createElement(\"div\");function yn(e){let t=A(()=>document.querySelector(e),()=>Ji)();return t||E(`Cannot find x-teleport element for selector: \"${e}\"`),t}var bn=()=>{};bn.inline=(e,{modifiers:t},{cleanup:r})=>{t.includes(\"self\")?e._x_ignoreSelf=!0:e._x_ignore=!0,r(()=>{t.includes(\"self\")?delete e._x_ignoreSelf:delete e._x_ignore})};d(\"ignore\",bn);d(\"effect\",A((e,{expression:t},{effect:r})=>{r(x(e,t))}));function le(e,t,r,n){let i=e,o=c=>n(c),s={},a=(c,l)=>u=>l(c,u);if(r.includes(\"dot\")&&(t=Yi(t)),r.includes(\"camel\")&&(t=Xi(t)),r.includes(\"passive\")&&(s.passive=!0),r.includes(\"capture\")&&(s.capture=!0),r.includes(\"window\")&&(i=window),r.includes(\"document\")&&(i=document),r.includes(\"debounce\")){let c=r[r.indexOf(\"debounce\")+1]||\"invalid-wait\",l=rt(c.split(\"ms\")[0])?Number(c.split(\"ms\")[0]):250;o=He(o,l)}if(r.includes(\"throttle\")){let c=r[r.indexOf(\"throttle\")+1]||\"invalid-wait\",l=rt(c.split(\"ms\")[0])?Number(c.split(\"ms\")[0]):250;o=Ve(o,l)}return r.includes(\"prevent\")&&(o=a(o,(c,l)=>{l.preventDefault(),c(l)})),r.includes(\"stop\")&&(o=a(o,(c,l)=>{l.stopPropagation(),c(l)})),r.includes(\"once\")&&(o=a(o,(c,l)=>{c(l),i.removeEventListener(t,o,s)})),(r.includes(\"away\")||r.includes(\"outside\"))&&(i=document,o=a(o,(c,l)=>{e.contains(l.target)||l.target.isConnected!==!1&&(e.offsetWidth<1&&e.offsetHeight<1||e._x_isShown!==!1&&c(l))})),r.includes(\"self\")&&(o=a(o,(c,l)=>{l.target===e&&c(l)})),(Qi(t)||En(t))&&(o=a(o,(c,l)=>{eo(l,r)||c(l)})),i.addEventListener(t,o,s),()=>{i.removeEventListener(t,o,s)}}function Yi(e){return e.replace(/-/g,\".\")}function Xi(e){return e.toLowerCase().replace(/-(\\w)/g,(t,r)=>r.toUpperCase())}function rt(e){return!Array.isArray(e)&&!isNaN(e)}function Zi(e){return[\" \",\"_\"].includes(e)?e:e.replace(/([a-z])([A-Z])/g,\"$1-$2\").replace(/[_\\s]/,\"-\").toLowerCase()}function Qi(e){return[\"keydown\",\"keyup\"].includes(e)}function En(e){return[\"contextmenu\",\"click\",\"mouse\"].some(t=>e.includes(t))}function eo(e,t){let r=t.filter(o=>![\"window\",\"document\",\"prevent\",\"stop\",\"once\",\"capture\",\"self\",\"away\",\"outside\",\"passive\"].includes(o));if(r.includes(\"debounce\")){let o=r.indexOf(\"debounce\");r.splice(o,rt((r[o+1]||\"invalid-wait\").split(\"ms\")[0])?2:1)}if(r.includes(\"throttle\")){let o=r.indexOf(\"throttle\");r.splice(o,rt((r[o+1]||\"invalid-wait\").split(\"ms\")[0])?2:1)}if(r.length===0||r.length===1&&wn(e.key).includes(r[0]))return!1;let i=[\"ctrl\",\"shift\",\"alt\",\"meta\",\"cmd\",\"super\"].filter(o=>r.includes(o));return r=r.filter(o=>!i.includes(o)),!(i.length>0&&i.filter(s=>((s===\"cmd\"||s===\"super\")&&(s=\"meta\"),e[`${s}Key`])).length===i.length&&(En(e.type)||wn(e.key).includes(r[0])))}function wn(e){if(!e)return[];e=Zi(e);let t={ctrl:\"control\",slash:\"/\",space:\" \",spacebar:\" \",cmd:\"meta\",esc:\"escape\",up:\"arrow-up\",down:\"arrow-down\",left:\"arrow-left\",right:\"arrow-right\",period:\".\",comma:\",\",equal:\"=\",minus:\"-\",underscore:\"_\"};return t[e]=e,Object.keys(t).map(r=>{if(t[r]===e)return r}).filter(r=>r)}d(\"model\",(e,{modifiers:t,expression:r},{effect:n,cleanup:i})=>{let o=e;t.includes(\"parent\")&&(o=e.parentNode);let s=x(o,r),a;typeof r==\"string\"?a=x(o,`${r} = __placeholder`):typeof r==\"function\"&&typeof r()==\"string\"?a=x(o,`${r()} = __placeholder`):a=()=>{};let c=()=>{let h;return s(w=>h=w),vn(h)?h.get():h},l=h=>{let w;s(z=>w=z),vn(w)?w.set(h):a(()=>{},{scope:{__placeholder:h}})};typeof r==\"string\"&&e.type===\"radio\"&&m(()=>{e.hasAttribute(\"name\")||e.setAttribute(\"name\",r)});var u=e.tagName.toLowerCase()===\"select\"||[\"checkbox\",\"radio\"].includes(e.type)||t.includes(\"lazy\")?\"change\":\"input\";let p=L?()=>{}:le(e,u,t,h=>{l(Ht(e,t,h,c()))});if(t.includes(\"fill\")&&([void 0,null,\"\"].includes(c())||Ke(e)&&Array.isArray(c())||e.tagName.toLowerCase()===\"select\"&&e.multiple)&&l(Ht(e,t,{target:e},c())),e._x_removeModelListeners||(e._x_removeModelListeners={}),e._x_removeModelListeners.default=p,i(()=>e._x_removeModelListeners.default()),e.form){let h=le(e.form,\"reset\",[],w=>{se(()=>e._x_model&&e._x_model.set(Ht(e,t,{target:e},c())))});i(()=>h())}e._x_model={get(){return c()},set(h){l(h)}},e._x_forceModelUpdate=h=>{h===void 0&&typeof r==\"string\"&&r.match(/\\./)&&(h=\"\"),window.fromModel=!0,m(()=>xe(e,\"value\",h)),delete window.fromModel},n(()=>{let h=c();t.includes(\"unintrusive\")&&document.activeElement.isSameNode(e)||e._x_forceModelUpdate(h)})});function Ht(e,t,r,n){return m(()=>{if(r instanceof CustomEvent&&r.detail!==void 0)return r.detail!==null&&r.detail!==void 0?r.detail:r.target.value;if(Ke(e))if(Array.isArray(n)){let i=null;return t.includes(\"number\")?i=Vt(r.target.value):t.includes(\"boolean\")?i=ye(r.target.value):i=r.target.value,r.target.checked?n.includes(i)?n:n.concat([i]):n.filter(o=>!to(o,i))}else return r.target.checked;else{if(e.tagName.toLowerCase()===\"select\"&&e.multiple)return t.includes(\"number\")?Array.from(r.target.selectedOptions).map(i=>{let o=i.value||i.text;return Vt(o)}):t.includes(\"boolean\")?Array.from(r.target.selectedOptions).map(i=>{let o=i.value||i.text;return ye(o)}):Array.from(r.target.selectedOptions).map(i=>i.value||i.text);{let i;return Ct(e)?r.target.checked?i=r.target.value:i=n:i=r.target.value,t.includes(\"number\")?Vt(i):t.includes(\"boolean\")?ye(i):t.includes(\"trim\")?i.trim():i}}})}function Vt(e){let t=e?parseFloat(e):null;return ro(t)?t:e}function to(e,t){return e==t}function ro(e){return!Array.isArray(e)&&!isNaN(e)}function vn(e){return e!==null&&typeof e==\"object\"&&typeof e.get==\"function\"&&typeof e.set==\"function\"}d(\"cloak\",e=>queueMicrotask(()=>m(()=>e.removeAttribute(C(\"cloak\")))));je(()=>`[${C(\"init\")}]`);d(\"init\",A((e,{expression:t},{evaluate:r})=>typeof t==\"string\"?!!t.trim()&&r(t,{},!1):r(t,{},!1)));d(\"text\",(e,{expression:t},{effect:r,evaluateLater:n})=>{let i=n(t);r(()=>{i(o=>{m(()=>{e.textContent=o})})})});d(\"html\",(e,{expression:t},{effect:r,evaluateLater:n})=>{let i=n(t);r(()=>{i(o=>{m(()=>{e.innerHTML=o,e._x_ignoreSelf=!0,S(e),delete e._x_ignoreSelf})})})});oe(Ie(\":\",$e(C(\"bind:\"))));var Sn=(e,{value:t,modifiers:r,expression:n,original:i},{effect:o,cleanup:s})=>{if(!t){let c={};qr(c),x(e,n)(u=>{Rt(e,u,i)},{scope:c});return}if(t===\"key\")return no(e,n);if(e._x_inlineBindings&&e._x_inlineBindings[t]&&e._x_inlineBindings[t].extract)return;let a=x(e,n);o(()=>a(c=>{c===void 0&&typeof n==\"string\"&&n.match(/\\./)&&(c=\"\"),m(()=>xe(e,t,c,r))})),s(()=>{e._x_undoAddedClasses&&e._x_undoAddedClasses(),e._x_undoAddedStyles&&e._x_undoAddedStyles()})};Sn.inline=(e,{value:t,modifiers:r,expression:n})=>{t&&(e._x_inlineBindings||(e._x_inlineBindings={}),e._x_inlineBindings[t]={expression:n,extract:!1})};d(\"bind\",Sn);function no(e,t){e._x_keyExpression=t}Le(()=>`[${C(\"data\")}]`);d(\"data\",(e,{expression:t},{cleanup:r})=>{if(io(e))return;t=t===\"\"?\"{}\":t;let n={};G(n,e);let i={};Gr(i,n);let o=R(e,t,{scope:i});(o===void 0||o===!0)&&(o={}),G(o,e);let s=T(o);Re(s);let a=D(e,s);s.init&&R(e,s.init),r(()=>{s.destroy&&R(e,s.destroy),a()})});H((e,t)=>{e._x_dataStack&&(t._x_dataStack=e._x_dataStack,t.setAttribute(\"data-has-alpine-state\",!0))});function io(e){return L?ze?!0:e.hasAttribute(\"data-has-alpine-state\"):!1}d(\"show\",(e,{modifiers:t,expression:r},{effect:n})=>{let i=x(e,r);e._x_doHide||(e._x_doHide=()=>{m(()=>{e.style.setProperty(\"display\",\"none\",t.includes(\"important\")?\"important\":void 0)})}),e._x_doShow||(e._x_doShow=()=>{m(()=>{e.style.length===1&&e.style.display===\"none\"?e.removeAttribute(\"style\"):e.style.removeProperty(\"display\")})});let o=()=>{e._x_doHide(),e._x_isShown=!1},s=()=>{e._x_doShow(),e._x_isShown=!0},a=()=>setTimeout(s),c=_e(p=>p?s():o(),p=>{typeof e._x_toggleAndCascadeWithTransitions==\"function\"?e._x_toggleAndCascadeWithTransitions(e,p,s,o):p?a():o()}),l,u=!0;n(()=>i(p=>{!u&&p===l||(t.includes(\"immediate\")&&(p?a():o()),c(p),l=p,u=!1)}))});d(\"for\",(e,{expression:t},{effect:r,cleanup:n})=>{let i=so(t),o=x(e,i.items),s=x(e,e._x_keyExpression||\"index\");e._x_prevKeys=[],e._x_lookup={},r(()=>oo(e,i,o,s)),n(()=>{Object.values(e._x_lookup).forEach(a=>m(()=>{$(a),a.remove()})),delete e._x_prevKeys,delete e._x_lookup})});function oo(e,t,r,n){let i=s=>typeof s==\"object\"&&!Array.isArray(s),o=e;r(s=>{ao(s)&&s>=0&&(s=Array.from(Array(s).keys(),f=>f+1)),s===void 0&&(s=[]);let a=e._x_lookup,c=e._x_prevKeys,l=[],u=[];if(i(s))s=Object.entries(s).map(([f,g])=>{let b=An(t,g,f,s);n(v=>{u.includes(v)&&E(\"Duplicate key on x-for\",e),u.push(v)},{scope:{index:f,...b}}),l.push(b)});else for(let f=0;f<s.length;f++){let g=An(t,s[f],f,s);n(b=>{u.includes(b)&&E(\"Duplicate key on x-for\",e),u.push(b)},{scope:{index:f,...g}}),l.push(g)}let p=[],h=[],w=[],z=[];for(let f=0;f<c.length;f++){let g=c[f];u.indexOf(g)===-1&&w.push(g)}c=c.filter(f=>!w.includes(f));let ve=\"template\";for(let f=0;f<u.length;f++){let g=u[f],b=c.indexOf(g);if(b===-1)c.splice(f,0,g),p.push([ve,f]);else if(b!==f){let v=c.splice(f,1)[0],O=c.splice(b-1,1)[0];c.splice(f,0,O),c.splice(b,0,v),h.push([v,O])}else z.push(g);ve=g}for(let f=0;f<w.length;f++){let g=w[f];g in a&&(m(()=>{$(a[g]),a[g].remove()}),delete a[g])}for(let f=0;f<h.length;f++){let[g,b]=h[f],v=a[g],O=a[b],te=document.createElement(\"div\");m(()=>{O||E('x-for \":key\" is undefined or invalid',o,b,a),O.after(te),v.after(O),O._x_currentIfEl&&O.after(O._x_currentIfEl),te.before(v),v._x_currentIfEl&&v.after(v._x_currentIfEl),te.remove()}),O._x_refreshXForScope(l[u.indexOf(b)])}for(let f=0;f<p.length;f++){let[g,b]=p[f],v=g===\"template\"?o:a[g];v._x_currentIfEl&&(v=v._x_currentIfEl);let O=l[b],te=u[b],ue=document.importNode(o.content,!0).firstElementChild,Ut=T(O);D(ue,Ut,o),ue._x_refreshXForScope=Cn=>{Object.entries(Cn).forEach(([Tn,Rn])=>{Ut[Tn]=Rn})},m(()=>{v.after(ue),A(()=>S(ue))()}),typeof te==\"object\"&&E(\"x-for key cannot be an object, it must be a string or an integer\",o),a[te]=ue}for(let f=0;f<z.length;f++)a[z[f]]._x_refreshXForScope(l[u.indexOf(z[f])]);o._x_prevKeys=u})}function so(e){let t=/,([^,\\}\\]]*)(?:,([^,\\}\\]]*))?$/,r=/^\\s*\\(|\\)\\s*$/g,n=/([\\s\\S]*?)\\s+(?:in|of)\\s+([\\s\\S]*)/,i=e.match(n);if(!i)return;let o={};o.items=i[2].trim();let s=i[1].replace(r,\"\").trim(),a=s.match(t);return a?(o.item=s.replace(t,\"\").trim(),o.index=a[1].trim(),a[2]&&(o.collection=a[2].trim())):o.item=s,o}function An(e,t,r,n){let i={};return/^\\[.*\\]$/.test(e.item)&&Array.isArray(t)?e.item.replace(\"[\",\"\").replace(\"]\",\"\").split(\",\").map(s=>s.trim()).forEach((s,a)=>{i[s]=t[a]}):/^\\{.*\\}$/.test(e.item)&&!Array.isArray(t)&&typeof t==\"object\"?e.item.replace(\"{\",\"\").replace(\"}\",\"\").split(\",\").map(s=>s.trim()).forEach(s=>{i[s]=t[s]}):i[e.item]=t,e.index&&(i[e.index]=r),e.collection&&(i[e.collection]=n),i}function ao(e){return!Array.isArray(e)&&!isNaN(e)}function On(){}On.inline=(e,{expression:t},{cleanup:r})=>{let n=X(e);n._x_refs||(n._x_refs={}),n._x_refs[t]=e,r(()=>delete n._x_refs[t])};d(\"ref\",On);d(\"if\",(e,{expression:t},{effect:r,cleanup:n})=>{e.tagName.toLowerCase()!==\"template\"&&E(\"x-if can only be used on a <template> tag\",e);let i=x(e,t),o=()=>{if(e._x_currentIfEl)return e._x_currentIfEl;let a=e.content.cloneNode(!0).firstElementChild;return D(a,{},e),m(()=>{e.after(a),A(()=>S(a))()}),e._x_currentIfEl=a,e._x_undoIf=()=>{m(()=>{$(a),a.remove()}),delete e._x_currentIfEl},a},s=()=>{e._x_undoIf&&(e._x_undoIf(),delete e._x_undoIf)};r(()=>i(a=>{a?o():s()})),n(()=>e._x_undoIf&&e._x_undoIf())});d(\"id\",(e,{expression:t},{evaluate:r})=>{r(t).forEach(i=>gn(e,i))});H((e,t)=>{e._x_ids&&(t._x_ids=e._x_ids)});oe(Ie(\"@\",$e(C(\"on:\"))));d(\"on\",A((e,{value:t,modifiers:r,expression:n},{cleanup:i})=>{let o=n?x(e,n):()=>{};e.tagName.toLowerCase()===\"template\"&&(e._x_forwardEvents||(e._x_forwardEvents=[]),e._x_forwardEvents.includes(t)||e._x_forwardEvents.push(t));let s=le(e,t,r,a=>{o(()=>{},{scope:{$event:a},params:[a]})});i(()=>s())}));nt(\"Collapse\",\"collapse\",\"collapse\");nt(\"Intersect\",\"intersect\",\"intersect\");nt(\"Focus\",\"trap\",\"focus\");nt(\"Mask\",\"mask\",\"mask\");function nt(e,t,r){d(t,n=>E(`You can't use [x-${t}] without first installing the \"${e}\" plugin here: https://alpinejs.dev/plugins/${r}`,n))}K.setEvaluator(Jr);K.setReactivityEngine({reactive:tt,effect:nn,release:on,raw:_});var qt=K;window.Alpine=qt;queueMicrotask(()=>{qt.start()});})();\n//# sourceMappingURL=alpine3-csp.min.js.map\n","Magento_Directory/js/region-updater.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'mage/validation'\n], function ($, mageTemplate, _) {\n    'use strict';\n\n    $.widget('mage.directoryRegionUpdater', {\n        options: {\n            regionTemplate:\n                '<option value=\"<%- data.value %>\" <% if (data.isSelected) { %>selected=\"selected\"<% } %>>' +\n                '<%- data.title %>' +\n                '</option>',\n            isRegionRequired: true,\n            isZipRequired: true,\n            isCountryRequired: true,\n            currentRegion: null,\n            isMultipleCountriesAllowed: true\n        },\n\n        /**\n         *\n         * @private\n         */\n        _create: function () {\n            this._initCountryElement();\n\n            this.currentRegionOption = this.options.currentRegion;\n            this.regionTmpl = mageTemplate(this.options.regionTemplate);\n\n            this._updateRegion(this.element.find('option:selected').val());\n\n            $(this.options.regionListId).on('change', $.proxy(function (e) {\n                this.setOption = false;\n                this.currentRegionOption = $(e.target).val();\n\n                if (!this.currentRegionOption) {\n                    $(this.options.regionListId).add(this.options.regionInputId).val('');\n                }\n            }, this));\n\n            $(this.options.regionInputId).on('focusout', $.proxy(function () {\n                this.setOption = true;\n            }, this));\n        },\n\n        /**\n         *\n         * @private\n         */\n        _initCountryElement: function () {\n\n            if (this.options.isMultipleCountriesAllowed) {\n                this.element.parents('div.field').show();\n                this.element.on('change', $.proxy(function (e) {\n                    // clear region inputs on country change\n                    $(this.options.regionListId).val('');\n                    $(this.options.regionInputId).val('');\n                    this._updateRegion($(e.target).val());\n                }, this));\n\n                if (this.options.isCountryRequired) {\n                    this.element.addClass('required-entry');\n                    this.element.parents('div.field').addClass('required');\n                }\n            } else {\n                this.element.parents('div.field').hide();\n            }\n        },\n\n        /**\n         * Remove options from dropdown list\n         *\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @private\n         */\n        _removeSelectOptions: function (selectElement) {\n            selectElement.find('option').each(function (index) {\n                if (index) {\n                    $(this).remove();\n                }\n            });\n        },\n\n        /**\n         * Render dropdown list\n         * @param {Object} selectElement - jQuery object for dropdown list\n         * @param {String} key - region code\n         * @param {Object} value - region object\n         * @private\n         */\n        _renderSelectOption: function (selectElement, key, value) {\n            selectElement.append($.proxy(function () {\n                var name = value.name.replace(/[!\"#$%&'()*+,.\\/:;<=>?@[\\\\\\]^`{|}~]/g, '\\\\$&'),\n                    tmplData,\n                    tmpl;\n\n                if (value.code && $(name).is('span')) {\n                    key = value.code;\n                    value.name = $(name).text();\n                }\n\n                tmplData = {\n                    value: key,\n                    title: value.name,\n                    isSelected: false\n                };\n\n                if (this.options.defaultRegion === key) {\n                    tmplData.isSelected = true;\n                }\n\n                tmpl = this.regionTmpl({\n                    data: tmplData\n                });\n\n                return $(tmpl);\n            }, this));\n        },\n\n        /**\n         * Takes clearError callback function as first option\n         * If no form is passed as option, look up the closest form and call clearError method.\n         * @private\n         */\n        _clearError: function () {\n            var args = ['clearError', this.options.regionListId, this.options.regionInputId, this.options.postcodeId];\n\n            if (this.options.clearError && typeof this.options.clearError === 'function') {\n                this.options.clearError.call(this);\n            } else {\n                if (!this.options.form) {\n                    this.options.form = this.element.closest('form').length ? $(this.element.closest('form')[0]) : null;\n                }\n\n                this.options.form = $(this.options.form);\n\n                this.options.form && this.options.form.data('validator') &&\n                this.options.form.validation.apply(this.options.form, _.compact(args));\n\n                // Clean up errors on region & zip fix\n                $(this.options.regionInputId).removeClass('mage-error').parent().find('[generated]').remove();\n                $(this.options.regionListId).removeClass('mage-error').parent().find('[generated]').remove();\n                $(this.options.postcodeId).removeClass('mage-error').parent().find('[generated]').remove();\n            }\n        },\n\n        /**\n         * Update dropdown list based on the country selected\n         *\n         * @param {String} country - 2 uppercase letter for country code\n         * @private\n         */\n        _updateRegion: function (country) {\n            // Clear validation error messages\n            var regionList = $(this.options.regionListId),\n                regionInput = $(this.options.regionInputId),\n                postcode = $(this.options.postcodeId),\n                label = regionList.parent().siblings('label'),\n                container = regionList.parents('div.field'),\n                regionsEntries,\n                regionId,\n                regionData;\n\n            this._clearError();\n            this._checkRegionRequired(country);\n\n            // Populate state/province dropdown list if available or use input box\n            if (this.options.regionJson[country]) {\n                this._removeSelectOptions(regionList);\n                regionsEntries = _.pairs(this.options.regionJson[country]);\n                $.each(regionsEntries, $.proxy(function (key, value) {\n                    regionData = value[1];\n                    regionId = regionData.id;\n                    this._renderSelectOption(regionList, regionId.toString(), regionData);\n                }, this));\n\n                if (this.currentRegionOption) {\n                    regionList.val(this.currentRegionOption);\n                }\n\n                if (this.setOption) {\n                    regionList.find('option').filter(function () {\n                        return this.text === regionInput.val();\n                    }).attr('selected', true);\n                }\n\n                if (this.options.isRegionRequired) {\n                    regionList.addClass('required-entry').removeAttr('disabled');\n                    container.addClass('required').show();\n                } else {\n                    regionList.removeClass('required-entry validate-select').removeAttr('data-validate');\n                    container.removeClass('required');\n\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionList.hide();\n                        container.hide();\n                    } else {\n                        regionList.removeAttr('disabled').show();\n                    }\n                }\n\n                regionList.show();\n                regionInput.hide();\n                label.attr('for', regionList.attr('id'));\n            } else {\n                this._removeSelectOptions(regionList);\n\n                if (this.options.isRegionRequired) {\n                    regionInput.addClass('required-entry').removeAttr('disabled');\n                    container.addClass('required').show();\n                } else {\n                    if (!this.options.optionalRegionAllowed) { //eslint-disable-line max-depth\n                        regionInput.attr('disabled', 'disabled');\n                        container.hide();\n                    }\n                    container.removeClass('required');\n                    regionInput.removeClass('required-entry');\n                }\n\n                regionList.removeClass('required-entry').prop('disabled', 'disabled').hide();\n                regionInput.show();\n                label.attr('for', regionInput.attr('id'));\n            }\n\n            // If country is in optionalzip list, make postcode input not required\n            if (this.options.isZipRequired) {\n                $.inArray(country, this.options.countriesWithOptionalZip) >= 0 ?\n                    postcode.removeClass('required-entry').closest('.field').removeClass('required') :\n                    postcode.addClass('required-entry').closest('.field').addClass('required');\n            }\n\n            // Add defaultvalue attribute to state/province select element\n            regionList.attr('defaultvalue', this.options.defaultRegion);\n            this.options.form.find('[type=\"submit\"]').removeAttr('disabled').show();\n        },\n\n        /**\n         * Check if the selected country has a mandatory region selection\n         *\n         * @param {String} country - Code of the country - 2 uppercase letter for country code\n         * @private\n         */\n        _checkRegionRequired: function (country) {\n            var self = this;\n\n            this.options.isRegionRequired = false;\n            $.each(this.options.regionJson.config['regions_required'], function (index, elem) {\n                if (elem === country) {\n                    self.options.isRegionRequired = true;\n                }\n            });\n        }\n    });\n\n    return $.mage.directoryRegionUpdater;\n});\n","Magento_Dhl/js/model/shipping-rates-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Dhl/js/model/shipping-rates-validation-rules',\n    'mage/translate'\n], function ($, utils, validationRules, $t) {\n    'use strict';\n\n    return {\n        validationErrors: [],\n\n        /**\n         * @param {Object} address\n         * @return {Boolean}\n         */\n        validate: function (address) {\n            var self = this;\n\n            this.validationErrors = [];\n            $.each(validationRules.getRules(), function (field, rule) {\n                var message;\n\n                if (rule.required && utils.isEmpty(address[field])) {\n                    message = $t('Field ') + field + $t(' is required.');\n\n                    self.validationErrors.push(message);\n                }\n            });\n\n            return !this.validationErrors.length;\n        }\n    };\n});\n","Magento_Dhl/js/model/shipping-rates-validation-rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * @return {Object}\n         */\n        getRules: function () {\n            return {\n                'postcode': {\n                    'required': true\n                },\n                'country_id': {\n                    'required': true\n                },\n                'city': {\n                    'required': true\n                }\n            };\n        }\n    };\n});\n","Magento_Dhl/js/view/shipping-rates-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Checkout/js/model/shipping-rates-validator',\n    'Magento_Checkout/js/model/shipping-rates-validation-rules',\n    'Magento_Dhl/js/model/shipping-rates-validator',\n    'Magento_Dhl/js/model/shipping-rates-validation-rules'\n], function (\n    Component,\n    defaultShippingRatesValidator,\n    defaultShippingRatesValidationRules,\n    dhlShippingRatesValidator,\n    dhlShippingRatesValidationRules\n) {\n    'use strict';\n\n    defaultShippingRatesValidator.registerValidator('dhl', dhlShippingRatesValidator);\n    defaultShippingRatesValidationRules.registerRules('dhl', dhlShippingRatesValidationRules);\n\n    return Component;\n});\n","Magento_Vault/js/customer_account/deleteWidget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modalToggle',\n    'mage/translate'\n], function ($, modalToggle) {\n    'use strict';\n\n    return function (config, deleteButton) {\n        config.buttons = [\n            {\n                text: $.mage.__('Cancel'),\n                class: 'action secondary cancel'\n            }, {\n                text: $.mage.__('Delete'),\n                class: 'action primary',\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) { //eslint-disable-line no-unused-vars\n                    $(deleteButton.form).trigger('submit');\n                }\n            }\n        ];\n\n        modalToggle(config, deleteButton);\n    };\n});\n","Magento_Vault/js/view/payment/vault-enabler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine(\n    [\n        'uiElement'\n    ],\n    function (\n        Component\n    ) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                isActivePaymentTokenEnabler: true\n            },\n\n            /**\n             * @param {String} paymentCode\n             */\n            setPaymentCode: function (paymentCode) {\n                this.paymentCode = paymentCode;\n            },\n\n            /**\n             * @returns {Object}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([\n                        'isActivePaymentTokenEnabler'\n                    ]);\n\n                return this;\n            },\n\n            /**\n             * @param {Object} data\n             */\n            visitAdditionalData: function (data) {\n                if (!this.isVaultEnabled()) {\n                    return;\n                }\n\n                if (!('additional_data' in data)) {\n                    data['additional_data'] = {};\n                }\n\n                data['additional_data']['is_active_payment_token_enabler'] = this.isActivePaymentTokenEnabler();\n            },\n\n            /**\n             * @returns {Boolean}\n             */\n            isVaultEnabled: function () {\n                return typeof window.checkoutConfig.vault[this.paymentCode] !== 'undefined' &&\n                    window.checkoutConfig.vault[this.paymentCode]['is_enabled'] === true;\n            }\n        });\n    }\n);\n","Magento_Vault/js/view/payment/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\n/* @api */\ndefine([\n    'underscore',\n    'uiComponent',\n    'Magento_Checkout/js/model/payment/renderer-list',\n    'uiLayout',\n    'uiRegistry'\n], function (_, Component, rendererList, layout, registry) {\n    'use strict';\n\n    var vaultGroupName = 'vaultGroup';\n\n    layout([{\n        name: vaultGroupName,\n        component: 'Magento_Checkout/js/model/payment/method-group',\n        alias: 'vault',\n        sortOrder: 10\n    }]);\n\n    registry.get(vaultGroupName, function (vaultGroup) {\n        _.each(window.checkoutConfig.payment.vault, function (config, index) {\n            rendererList.push(\n                {\n                    type: index,\n                    config: config.config,\n                    component: config.component,\n                    group: vaultGroup,\n\n                    /**\n                     * Custom payment method types comparator\n                     * @param {String} typeA\n                     * @param {String} typeB\n                     * @return {Boolean}\n                     */\n                    typeComparatorCallback: function (typeA, typeB) {\n                        // vault token items have the same name as vault payment without index\n                        return typeA.substring(0, typeA.lastIndexOf('_')) === typeB;\n                    }\n                }\n            );\n        });\n    });\n\n    /**\n     * Add view logic here if needed\n     */\n    return Component.extend({});\n});\n","Magento_Vault/js/view/payment/method-renderer/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n\ndefine(\n    [\n        'Magento_Checkout/js/view/payment/default',\n        'Magento_Checkout/js/action/select-payment-method',\n        'Magento_Checkout/js/checkout-data'\n    ],\n    function (Component, selectPaymentMethod, checkoutData) {\n        'use strict';\n\n        return Component.extend({\n            defaults: {\n                template: 'Magento_Vault/payment/form'\n            },\n\n            /**\n             * @returns {exports.initObservable}\n             */\n            initObservable: function () {\n                this._super()\n                    .observe([]);\n\n                return this;\n            },\n\n            /**\n             * @returns\n             */\n            selectPaymentMethod: function () {\n                selectPaymentMethod(\n                    {\n                        method: this.getId()\n                    }\n                );\n                checkoutData.setSelectedPaymentMethod(this.getId());\n\n                return true;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getTitle: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getToken: function () {\n                return '';\n            },\n\n            /**\n             * @returns {String}\n             */\n            getId: function () {\n                return this.index;\n            },\n\n            /**\n             * @returns {String}\n             */\n            getCode: function () {\n                return this.code;\n            },\n\n            /**\n             * Get last 4 digits of card\n             * @returns {String}\n             */\n            getMaskedCard: function () {\n                return '';\n            },\n\n            /**\n             * Get expiration date\n             * @returns {String}\n             */\n            getExpirationDate: function () {\n                return '';\n            },\n\n            /**\n             * Get card type\n             * @returns {String}\n             */\n            getCardType: function () {\n                return '';\n            },\n\n            /**\n             * @param {String} type\n             * @returns {Boolean}\n             */\n            getIcons: function (type) {\n                return window.checkoutConfig.payment.ccform.icons.hasOwnProperty(type) ?\n                    window.checkoutConfig.payment.ccform.icons[type]\n                    : false;\n            },\n\n            /**\n             * Return state of place order button.\n             *\n             * @return {Boolean}\n             */\n            isButtonActive: function () {\n                return this.isActive() && this.isPlaceOrderActionAllowed();\n            },\n\n            /**\n             * Check if payment is active.\n             *\n             * @return {Boolean}\n             */\n            isActive: function () {\n                return this.isChecked() === this.getId();\n            },\n\n            /**\n             * @returns {*}\n             */\n            getData: function () {\n                var data = {\n                    method: this.getCode()\n                };\n\n                data['additional_data'] = {};\n                data['additional_data']['public_hash'] = this.getToken();\n\n                return data;\n            }\n        });\n    }\n);\n","Magento_GoogleAnalytics/js/google-analytics.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* jscs:disable */\n/* eslint-disable */\ndefine([\n    'jquery',\n    'mage/cookies'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} config\n     */\n    return function (config) {\n        var allowServices = false,\n            allowedCookies,\n            allowedWebsites;\n\n        if (config.isCookieRestrictionModeEnabled) {\n            allowedCookies = $.mage.cookies.get(config.cookieName);\n\n            if (allowedCookies !== null) {\n                allowedWebsites = JSON.parse(allowedCookies);\n\n                if (allowedWebsites[config.currentWebsite] === 1) {\n                    allowServices = true;\n                }\n            }\n        } else {\n            allowServices = true;\n        }\n\n        if (allowServices) {\n            (function (i, s, o, g, r, a, m) {\n                i.GoogleAnalyticsObject = r;\n                i[r] = i[r] || function () {\n                        (i[r].q = i[r].q || []).push(arguments)\n                    }, i[r].l = 1 * new Date();\n                a = s.createElement(o),\n                    m = s.getElementsByTagName(o)[0];\n                a.async = 1;\n                a.src = g;\n                m.parentNode.insertBefore(a, m)\n            })(window, document, 'script', '//www.google-analytics.com/analytics.js', 'ga');\n\n            // Process page info\n            ga('create', config.pageTrackingData.accountId, 'auto');\n\n            if (config.pageTrackingData.isAnonymizedIpActive) {\n                ga('set', 'anonymizeIp', true);\n            }\n\n            // Process orders data\n            if (config.ordersTrackingData.hasOwnProperty('currency')) {\n                ga('require', 'ec', 'ec.js');\n\n                ga('set', 'currencyCode', config.ordersTrackingData.currency);\n\n                // Collect product data for GA\n                if (config.ordersTrackingData.products) {\n                    $.each(config.ordersTrackingData.products, function (index, value) {\n                        ga('ec:addProduct', value);\n                    });\n                }\n\n                // Collect orders data for GA\n                if (config.ordersTrackingData.orders) {\n                    $.each(config.ordersTrackingData.orders, function (index, value) {\n                        ga('ec:setAction', 'purchase', value);\n                    });\n                }\n\n                ga('send', 'pageview');\n            } else {\n                // Process Data if not orders\n                ga('send', 'pageview' + config.pageTrackingData.optPageUrl);\n            }\n        }\n    }\n});\n","jquery/jquery.storageapi.min.js":"/* jQuery Storage API Plugin 1.7.3 https://github.com/julien-maurel/jQuery-Storage-API */\n!function(e){\"function\"==typeof define&&define.amd?define([\"jquery\", \"jquery/jquery.cookie\"],e):e(\"object\"==typeof exports?require(\"jquery\"):jQuery)}(function(e){function t(t){var r,i,n,o=arguments.length,s=window[t],a=arguments,u=a[1];if(2>o)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(u)){i={};for(var f in u){r=u[f];try{i[r]=JSON.parse(s.getItem(r))}catch(c){i[r]=s.getItem(r)}}return i}if(2!=o){try{i=JSON.parse(s.getItem(u))}catch(c){throw new ReferenceError(u+\" is not defined in this storage\")}for(var f=2;o-1>f;f++)if(i=i[a[f]],void 0===i)throw new ReferenceError([].slice.call(a,1,f+1).join(\".\")+\" is not defined in this storage\");if(e.isArray(a[f])){n=i,i={};for(var m in a[f])i[a[f][m]]=n[a[f][m]];return i}return i[a[f]]}try{return JSON.parse(s.getItem(u))}catch(c){return s.getItem(u)}}function r(t){var r,i,n=arguments.length,o=window[t],s=arguments,a=s[1],u=s[2],f={};if(2>n||!e.isPlainObject(a)&&3>n)throw Error(\"Minimum 3 arguments must be given or second parameter must be an object\");if(e.isPlainObject(a)){for(var c in a)r=a[c],e.isPlainObject(r)?o.setItem(c,JSON.stringify(r)):o.setItem(c,r);return a}if(3==n)return\"object\"==typeof u?o.setItem(a,JSON.stringify(u)):o.setItem(a,u),u;try{i=o.getItem(a),null!=i&&(f=JSON.parse(i))}catch(m){}i=f;for(var c=2;n-2>c;c++)r=s[c],i[r]&&e.isPlainObject(i[r])||(i[r]={}),i=i[r];return i[s[c]]=s[c+1],o.setItem(a,JSON.stringify(f)),f}function i(t){var r,i,n=arguments.length,o=window[t],s=arguments,a=s[1];if(2>n)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(a)){for(var u in a)o.removeItem(a[u]);return!0}if(2==n)return o.removeItem(a),!0;try{r=i=JSON.parse(o.getItem(a))}catch(f){throw new ReferenceError(a+\" is not defined in this storage\")}for(var u=2;n-1>u;u++)if(i=i[s[u]],void 0===i)throw new ReferenceError([].slice.call(s,1,u).join(\".\")+\" is not defined in this storage\");if(e.isArray(s[u]))for(var c in s[u])delete i[s[u][c]];else delete i[s[u]];return o.setItem(a,JSON.stringify(r)),!0}function n(t,r){var n=a(t);for(var o in n)i(t,n[o]);if(r)for(var o in e.namespaceStorages)u(o)}function o(r){var i=arguments.length,n=arguments,s=(window[r],n[1]);if(1==i)return 0==a(r).length;if(e.isArray(s)){for(var u=0;u<s.length;u++)if(!o(r,s[u]))return!1;return!0}try{var f=t.apply(this,arguments);e.isArray(n[i-1])||(f={totest:f});for(var u in f)if(!(e.isPlainObject(f[u])&&e.isEmptyObject(f[u])||e.isArray(f[u])&&!f[u].length)&&f[u])return!1;return!0}catch(c){return!0}}function s(r){var i=arguments.length,n=arguments,o=(window[r],n[1]);if(2>i)throw Error(\"Minimum 2 arguments must be given\");if(e.isArray(o)){for(var a=0;a<o.length;a++)if(!s(r,o[a]))return!1;return!0}try{var u=t.apply(this,arguments);e.isArray(n[i-1])||(u={totest:u});for(var a in u)if(void 0===u[a]||null===u[a])return!1;return!0}catch(f){return!1}}function a(r){var i=arguments.length,n=window[r],o=arguments,s=(o[1],[]),a={};if(a=i>1?t.apply(this,o):n,a._cookie)for(var u in e.cookie())\"\"!=u&&s.push(u.replace(a._prefix,\"\"));else for(var f in a)s.push(f);return s}function u(t){if(!t||\"string\"!=typeof t)throw Error(\"First parameter must be a string\");g?(window.localStorage.getItem(t)||window.localStorage.setItem(t,\"{}\"),window.sessionStorage.getItem(t)||window.sessionStorage.setItem(t,\"{}\")):(window.localCookieStorage.getItem(t)||window.localCookieStorage.setItem(t,\"{}\"),window.sessionCookieStorage.getItem(t)||window.sessionCookieStorage.setItem(t,\"{}\"));var r={localStorage:e.extend({},e.localStorage,{_ns:t}),sessionStorage:e.extend({},e.sessionStorage,{_ns:t})};return e.cookie&&(window.cookieStorage.getItem(t)||window.cookieStorage.setItem(t,\"{}\"),r.cookieStorage=e.extend({},e.cookieStorage,{_ns:t})),e.namespaceStorages[t]=r,r}function f(e){if(!window[e])return!1;var t=\"jsapi\";try{return window[e].setItem(t,t),window[e].removeItem(t),!0}catch(r){return!1}}var c=\"ls_\",m=\"ss_\",g=f(\"localStorage\"),h={_type:\"\",_ns:\"\",_callMethod:function(e,t){var r=[this._type],t=Array.prototype.slice.call(t),i=t[0];return this._ns&&r.push(this._ns),\"string\"==typeof i&&-1!==i.indexOf(\".\")&&(t.shift(),[].unshift.apply(t,i.split(\".\"))),[].push.apply(r,t),e.apply(this,r)},get:function(){return this._callMethod(t,arguments)},set:function(){var t=arguments.length,i=arguments,n=i[0];if(1>t||!e.isPlainObject(n)&&2>t)throw Error(\"Minimum 2 arguments must be given or first parameter must be an object\");if(e.isPlainObject(n)&&this._ns){for(var o in n)r(this._type,this._ns,o,n[o]);return n}var s=this._callMethod(r,i);return this._ns?s[n.split(\".\")[0]]:s},remove:function(){if(arguments.length<1)throw Error(\"Minimum 1 argument must be given\");return this._callMethod(i,arguments)},removeAll:function(e){return this._ns?(r(this._type,this._ns,{}),!0):n(this._type,e)},isEmpty:function(){return this._callMethod(o,arguments)},isSet:function(){if(arguments.length<1)throw Error(\"Minimum 1 argument must be given\");return this._callMethod(s,arguments)},keys:function(){return this._callMethod(a,arguments)}};if(e.cookie){window.name||(window.name=Math.floor(1e8*Math.random()));var l={_cookie:!0,_prefix:\"\",_expires:null,_path:null,_domain:null,setItem:function(t,r){e.cookie(this._prefix+t,r,{expires:this._expires,path:this._path,domain:this._domain})},getItem:function(t){return e.cookie(this._prefix+t)},removeItem:function(t){return e.removeCookie(this._prefix+t)},clear:function(){for(var t in e.cookie())\"\"!=t&&(!this._prefix&&-1===t.indexOf(c)&&-1===t.indexOf(m)||this._prefix&&0===t.indexOf(this._prefix))&&e.removeCookie(t)},setExpires:function(e){return this._expires=e,this},setPath:function(e){return this._path=e,this},setDomain:function(e){return this._domain=e,this},setConf:function(e){return e.path&&(this._path=e.path),e.domain&&(this._domain=e.domain),e.expires&&(this._expires=e.expires),this},setDefaultConf:function(){this._path=this._domain=this._expires=null}};g||(window.localCookieStorage=e.extend({},l,{_prefix:c,_expires:3650}),window.sessionCookieStorage=e.extend({},l,{_prefix:m+window.name+\"_\"})),window.cookieStorage=e.extend({},l),e.cookieStorage=e.extend({},h,{_type:\"cookieStorage\",setExpires:function(e){return window.cookieStorage.setExpires(e),this},setPath:function(e){return window.cookieStorage.setPath(e),this},setDomain:function(e){return window.cookieStorage.setDomain(e),this},setConf:function(e){return window.cookieStorage.setConf(e),this},setDefaultConf:function(){return window.cookieStorage.setDefaultConf(),this}})}e.initNamespaceStorage=function(e){return u(e)},g?(e.localStorage=e.extend({},h,{_type:\"localStorage\"}),e.sessionStorage=e.extend({},h,{_type:\"sessionStorage\"})):(e.localStorage=e.extend({},h,{_type:\"localCookieStorage\"}),e.sessionStorage=e.extend({},h,{_type:\"sessionCookieStorage\"})),e.namespaceStorages={},e.removeAllStorages=function(t){e.localStorage.removeAll(t),e.sessionStorage.removeAll(t),e.cookieStorage&&e.cookieStorage.removeAll(t),t||(e.namespaceStorages={})}});\n","jquery/jquery.validate.js":"/*!\n * jQuery Validation Plugin v1.19.5\n *\n * https://jqueryvalidation.org/\n *\n * Copyright (c) 2022 J\u00f6rn Zaefferer\n * Released under the MIT license\n */\n(function( factory ) {\n    if ( typeof define === \"function\" && define.amd ) {\n        define( [\"jquery\", \"jquery/jquery.metadata\"], factory );\n    } else if (typeof module === \"object\" && module.exports) {\n        module.exports = factory( require( \"jquery\" ) );\n    } else {\n        factory( jQuery );\n    }\n}(function( $ ) {\n\n    $.extend( $.fn, {\n\n        // https://jqueryvalidation.org/validate/\n        validate: function( options ) {\n\n            // If nothing is selected, return nothing; can't chain anyway\n            if ( !this.length ) {\n                if ( options && options.debug && window.console ) {\n                    console.warn( \"Nothing selected, can't validate, returning nothing.\" );\n                }\n                return;\n            }\n\n            // Check if a validator for this form was already created\n            var validator = $.data( this[ 0 ], \"validator\" );\n            if ( validator ) {\n                return validator;\n            }\n\n            // Add novalidate tag if HTML5.\n            this.attr( \"novalidate\", \"novalidate\" );\n\n            validator = new $.validator( options, this[ 0 ] );\n            $.data( this[ 0 ], \"validator\", validator );\n\n            if ( validator.settings.onsubmit ) {\n\n                this.on( \"click.validate\", \":submit\", function( event ) {\n\n                    // Track the used submit button to properly handle scripted\n                    // submits later.\n                    validator.submitButton = event.currentTarget;\n\n                    // Allow suppressing validation by adding a cancel class to the submit button\n                    if ( $( this ).hasClass( \"cancel\" ) ) {\n                        validator.cancelSubmit = true;\n                    }\n\n                    // Allow suppressing validation by adding the html5 formnovalidate attribute to the submit button\n                    if ( $( this ).attr( \"formnovalidate\" ) !== undefined ) {\n                        validator.cancelSubmit = true;\n                    }\n                } );\n\n                // Validate the form on submit\n                this.on( \"submit.validate\", function( event ) {\n                    if ( validator.settings.debug ) {\n\n                        // Prevent form submit to be able to see console output\n                        event.preventDefault();\n                    }\n\n                    function handle() {\n                        var hidden, result;\n\n                        // Insert a hidden input as a replacement for the missing submit button\n                        // The hidden input is inserted in two cases:\n                        //   - A user defined a `submitHandler`\n                        //   - There was a pending request due to `remote` method and `stopRequest()`\n                        //     was called to submit the form in case it's valid\n                        if ( validator.submitButton && ( validator.settings.submitHandler || validator.formSubmitted ) ) {\n                            hidden = $( \"<input type='hidden'/>\" )\n                                .attr( \"name\", validator.submitButton.name )\n                                .val( $( validator.submitButton ).val() )\n                                .appendTo( validator.currentForm );\n                        }\n\n                        if ( validator.settings.submitHandler && !validator.settings.debug ) {\n                            result = validator.settings.submitHandler.call( validator, validator.currentForm, event );\n                            if ( hidden ) {\n\n                                // And clean up afterwards; thanks to no-block-scope, hidden can be referenced\n                                hidden.remove();\n                            }\n                            if ( result !== undefined ) {\n                                return result;\n                            }\n                            return false;\n                        }\n                        return true;\n                    }\n\n                    // Prevent submit for invalid forms or custom submit handlers\n                    if ( validator.cancelSubmit ) {\n                        validator.cancelSubmit = false;\n                        return handle();\n                    }\n                    if ( validator.form() ) {\n                        if ( validator.pendingRequest ) {\n                            validator.formSubmitted = true;\n                            return false;\n                        }\n                        return handle();\n                    } else {\n                        validator.focusInvalid();\n                        return false;\n                    }\n                } );\n            }\n\n            return validator;\n        },\n\n        // https://jqueryvalidation.org/valid/\n        valid: function() {\n            var valid, validator, errorList;\n\n            if ( $( this[ 0 ] ).is( \"form\" ) ) {\n                valid = this.validate().form();\n            } else {\n                errorList = [];\n                valid = true;\n                validator = $( this[ 0 ].form ).validate();\n                this.each( function() {\n                    valid = validator.element( this ) && valid;\n                    if ( !valid ) {\n                        errorList = errorList.concat( validator.errorList );\n                    }\n                } );\n                validator.errorList = errorList;\n            }\n            return valid;\n        },\n\n        // https://jqueryvalidation.org/rules/\n        rules: function( command, argument ) {\n            var element = this[ 0 ],\n                isContentEditable = typeof this.attr( \"contenteditable\" ) !== \"undefined\" && this.attr( \"contenteditable\" ) !== \"false\",\n                settings, staticRules, existingRules, data, param, filtered;\n\n            // If nothing is selected, return empty object; can't chain anyway\n            if ( element == null ) {\n                return;\n            }\n\n            if ( !element.form && isContentEditable ) {\n                element.form = this.closest( \"form\" )[ 0 ];\n                element.name = this.attr( \"name\" );\n            }\n\n            if ( element.form == null ) {\n                return;\n            }\n\n            if ( command ) {\n                settings = $.data( element.form, \"validator\" ).settings;\n                staticRules = settings.rules;\n                existingRules = $.validator.staticRules( element );\n                switch ( command ) {\n                    case \"add\":\n                        $.extend( existingRules, $.validator.normalizeRule( argument ) );\n\n                        // Remove messages from rules, but allow them to be set separately\n                        delete existingRules.messages;\n                        staticRules[ element.name ] = existingRules;\n                        if ( argument.messages ) {\n                            settings.messages[ element.name ] = $.extend( settings.messages[ element.name ], argument.messages );\n                        }\n                        break;\n                    case \"remove\":\n                        if ( !argument ) {\n                            delete staticRules[ element.name ];\n                            return existingRules;\n                        }\n                        filtered = {};\n                        $.each( argument.split( /\\s/ ), function( index, method ) {\n                            filtered[ method ] = existingRules[ method ];\n                            delete existingRules[ method ];\n                        } );\n                        return filtered;\n                }\n            }\n\n            data = $.validator.normalizeRules(\n                $.extend(\n                    {},\n                    $.validator.metadataRules(element),\n                    $.validator.classRules( element ),\n                    $.validator.attributeRules( element ),\n                    $.validator.dataRules( element ),\n                    $.validator.staticRules( element )\n                ), element );\n\n            // Make sure required is at front\n            if ( data.required ) {\n                param = data.required;\n                delete data.required;\n                data = $.extend( { required: param }, data );\n            }\n\n            // Make sure remote is at back\n            if ( data.remote ) {\n                param = data.remote;\n                delete data.remote;\n                data = $.extend( data, { remote: param } );\n            }\n\n            return data;\n        }\n    } );\n\n// JQuery trim is deprecated, provide a trim method based on String.prototype.trim\n    var trim = function( str ) {\n\n        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/trim#Polyfill\n        return str.replace( /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, \"\" );\n    };\n\n// Custom selectors\n    $.extend( $.expr.pseudos || $.expr[ \":\" ], {\t\t// '|| $.expr[ \":\" ]' here enables backwards compatibility to jQuery 1.7. Can be removed when dropping jQ 1.7.x support\n\n        // https://jqueryvalidation.org/blank-selector/\n        blank: function( a ) {\n            return !trim( \"\" + $( a ).val() );\n        },\n\n        // https://jqueryvalidation.org/filled-selector/\n        filled: function( a ) {\n            var val = $( a ).val();\n            return val !== null && !!trim( \"\" + val );\n        },\n\n        // https://jqueryvalidation.org/unchecked-selector/\n        unchecked: function( a ) {\n            return !$( a ).prop( \"checked\" );\n        }\n    } );\n\n// Constructor for validator\n    $.validator = function( options, form ) {\n        this.settings = $.extend( true, {}, $.validator.defaults, options );\n        this.currentForm = form;\n        this.init();\n    };\n\n// https://jqueryvalidation.org/jQuery.validator.format/\n    $.validator.format = function( source, params ) {\n        if ( arguments.length === 1 ) {\n            return function() {\n                var args = $.makeArray( arguments );\n                args.unshift( source );\n                return $.validator.format.apply( this, args );\n            };\n        }\n        if ( params === undefined ) {\n            return source;\n        }\n        if ( arguments.length > 2 && params.constructor !== Array  ) {\n            params = $.makeArray( arguments ).slice( 1 );\n        }\n        if ( params.constructor !== Array ) {\n            params = [ params ];\n        }\n        $.each( params, function( i, n ) {\n            source = source.replace( new RegExp( \"\\\\{\" + i + \"\\\\}\", \"g\" ), function() {\n                return n;\n            } );\n        } );\n        return source;\n    };\n\n    $.extend( $.validator, {\n\n        defaults: {\n            messages: {},\n            groups: {},\n            rules: {},\n            errorClass: \"error\",\n            pendingClass: \"pending\",\n            validClass: \"valid\",\n            errorElement: \"label\",\n            focusCleanup: false,\n            focusInvalid: true,\n            errorContainer: $( [] ),\n            errorLabelContainer: $( [] ),\n            onsubmit: true,\n            ignore: \":hidden\",\n            ignoreTitle: false,\n            onfocusin: function( element ) {\n                this.lastActive = element;\n\n                // Hide error label and remove error class on focus if enabled\n                if ( this.settings.focusCleanup ) {\n                    if ( this.settings.unhighlight ) {\n                        this.settings.unhighlight.call( this, element, this.settings.errorClass, this.settings.validClass );\n                    }\n                    this.hideThese( this.errorsFor( element ) );\n                }\n            },\n            onfocusout: function( element ) {\n                if ( !this.checkable( element ) && ( element.name in this.submitted || !this.optional( element ) ) ) {\n                    this.element( element );\n                }\n            },\n            onkeyup: function( element, event ) {\n\n                // Avoid revalidate the field when pressing one of the following keys\n                // Shift       => 16\n                // Ctrl        => 17\n                // Alt         => 18\n                // Caps lock   => 20\n                // End         => 35\n                // Home        => 36\n                // Left arrow  => 37\n                // Up arrow    => 38\n                // Right arrow => 39\n                // Down arrow  => 40\n                // Insert      => 45\n                // Num lock    => 144\n                // AltGr key   => 225\n                var excludedKeys = [\n                    16, 17, 18, 20, 35, 36, 37,\n                    38, 39, 40, 45, 144, 225\n                ];\n\n                if ( event.which === 9 && this.elementValue( element ) === \"\" || $.inArray( event.keyCode, excludedKeys ) !== -1 ) {\n                    return;\n                } else if ( element.name in this.submitted || element.name in this.invalid ) {\n                    this.element( element );\n                }\n            },\n            onclick: function( element ) {\n\n                // Click on selects, radiobuttons and checkboxes\n                if ( element.name in this.submitted ) {\n                    this.element( element );\n\n                    // Or option elements, check parent select in that case\n                } else if ( element.parentNode.name in this.submitted ) {\n                    this.element( element.parentNode );\n                }\n            },\n            highlight: function( element, errorClass, validClass ) {\n                if ( element.type === \"radio\" ) {\n                    this.findByName( element.name ).addClass( errorClass ).removeClass( validClass );\n                } else {\n                    $( element ).addClass( errorClass ).removeClass( validClass );\n                }\n            },\n            unhighlight: function( element, errorClass, validClass ) {\n                if ( element.type === \"radio\" ) {\n                    this.findByName( element.name ).removeClass( errorClass ).addClass( validClass );\n                } else {\n                    $( element ).removeClass( errorClass ).addClass( validClass );\n                }\n            }\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.setDefaults/\n        setDefaults: function( settings ) {\n            $.extend( $.validator.defaults, settings );\n        },\n\n        messages: {\n            required: \"This field is required.\",\n            remote: \"Please fix this field.\",\n            email: \"Please enter a valid email address.\",\n            url: \"Please enter a valid URL.\",\n            date: \"Please enter a valid date.\",\n            dateISO: \"Please enter a valid date (ISO).\",\n            number: \"Please enter a valid number.\",\n            digits: \"Please enter only digits.\",\n            equalTo: \"Please enter the same value again.\",\n            maxlength: $.validator.format( \"Please enter no more than {0} characters.\" ),\n            minlength: $.validator.format( \"Please enter at least {0} characters.\" ),\n            rangelength: $.validator.format( \"Please enter a value between {0} and {1} characters long.\" ),\n            range: $.validator.format( \"Please enter a value between {0} and {1}.\" ),\n            max: $.validator.format( \"Please enter a value less than or equal to {0}.\" ),\n            min: $.validator.format( \"Please enter a value greater than or equal to {0}.\" ),\n            step: $.validator.format( \"Please enter a multiple of {0}.\" )\n        },\n\n        autoCreateRanges: false,\n\n        prototype: {\n\n            init: function() {\n                this.labelContainer = $( this.settings.errorLabelContainer );\n                this.errorContext = this.labelContainer.length && this.labelContainer || $( this.currentForm );\n                this.containers = $( this.settings.errorContainer ).add( this.settings.errorLabelContainer );\n                this.submitted = {};\n                this.valueCache = {};\n                this.pendingRequest = 0;\n                this.pending = {};\n                this.invalid = {};\n                this.reset();\n\n                var currentForm = this.currentForm,\n                    groups = ( this.groups = {} ),\n                    rules;\n                $.each( this.settings.groups, function( key, value ) {\n                    if ( typeof value === \"string\" ) {\n                        value = value.split( /\\s/ );\n                    }\n                    $.each( value, function( index, name ) {\n                        groups[ name ] = key;\n                    } );\n                } );\n                rules = this.settings.rules;\n                $.each( rules, function( key, value ) {\n                    rules[ key ] = $.validator.normalizeRule( value );\n                } );\n\n                function delegate( event ) {\n                    var isContentEditable = typeof $( this ).attr( \"contenteditable\" ) !== \"undefined\" && $( this ).attr( \"contenteditable\" ) !== \"false\";\n\n                    // Set form expando on contenteditable\n                    if ( !this.form && isContentEditable ) {\n                        this.form = $( this ).closest( \"form\" )[ 0 ];\n                        this.name = $( this ).attr( \"name\" );\n                    }\n\n                    // Ignore the element if it belongs to another form. This will happen mainly\n                    // when setting the `form` attribute of an input to the id of another form.\n                    if ( currentForm !== this.form ) {\n                        return;\n                    }\n\n                    var validator = $.data( this.form, \"validator\" ),\n                        eventType = \"on\" + event.type.replace( /^validate/, \"\" ),\n                        settings = validator.settings;\n                    if ( settings[ eventType ] && !$( this ).is( settings.ignore ) ) {\n                        settings[ eventType ].call( validator, this, event );\n                    }\n                }\n\n                $( this.currentForm )\n                    .on( \"focusin.validate focusout.validate keyup.validate\",\n                        \":text, [type='password'], [type='file'], select, textarea, [type='number'], [type='search'], \" +\n                        \"[type='tel'], [type='url'], [type='email'], [type='datetime'], [type='date'], [type='month'], \" +\n                        \"[type='week'], [type='time'], [type='datetime-local'], [type='range'], [type='color'], \" +\n                        \"[type='radio'], [type='checkbox'], [contenteditable], [type='button']\", delegate )\n\n                    // Support: Chrome, oldIE\n                    // \"select\" is provided as event.target when clicking a option\n                    .on( \"click.validate\", \"select, option, [type='radio'], [type='checkbox']\", delegate );\n\n                if ( this.settings.invalidHandler ) {\n                    $( this.currentForm ).on( \"invalid-form.validate\", this.settings.invalidHandler );\n                }\n            },\n\n            // https://jqueryvalidation.org/Validator.form/\n            form: function() {\n                this.checkForm();\n                $.extend( this.submitted, this.errorMap );\n                this.invalid = $.extend( {}, this.errorMap );\n                if ( !this.valid() ) {\n                    $( this.currentForm ).triggerHandler( \"invalid-form\", [ this ] );\n                }\n                this.showErrors();\n                return this.valid();\n            },\n\n            checkForm: function() {\n                this.prepareForm();\n                for ( var i = 0, elements = ( this.currentElements = this.elements() ); elements[ i ]; i++ ) {\n                    this.check( elements[ i ] );\n                }\n                return this.valid();\n            },\n\n            // https://jqueryvalidation.org/Validator.element/\n            element: function( element ) {\n                var cleanElement = this.clean( element ),\n                    checkElement = this.validationTargetFor( cleanElement ),\n                    v = this,\n                    result = true,\n                    rs, group;\n\n                if ( checkElement === undefined ) {\n                    delete this.invalid[ cleanElement.name ];\n                } else {\n                    this.prepareElement( checkElement );\n                    this.currentElements = $( checkElement );\n\n                    // If this element is grouped, then validate all group elements already\n                    // containing a value\n                    group = this.groups[ checkElement.name ];\n                    if ( group ) {\n                        $.each( this.groups, function( name, testgroup ) {\n                            if ( testgroup === group && name !== checkElement.name ) {\n                                cleanElement = v.validationTargetFor( v.clean( v.findByName( name ) ) );\n                                if ( cleanElement && cleanElement.name in v.invalid ) {\n                                    v.currentElements.push( cleanElement );\n                                    result = v.check( cleanElement ) && result;\n                                }\n                            }\n                        } );\n                    }\n\n                    rs = this.check( checkElement ) !== false;\n                    result = result && rs;\n                    if ( rs ) {\n                        this.invalid[ checkElement.name ] = false;\n                    } else {\n                        this.invalid[ checkElement.name ] = true;\n                    }\n\n                    if ( !this.numberOfInvalids() ) {\n\n                        // Hide error containers on last error\n                        this.toHide = this.toHide.add( this.containers );\n                    }\n                    this.showErrors();\n\n                    // Add aria-invalid status for screen readers\n                    $( element ).attr( \"aria-invalid\", !rs );\n                }\n\n                return result;\n            },\n\n            // https://jqueryvalidation.org/Validator.showErrors/\n            showErrors: function( errors ) {\n                if ( errors ) {\n                    var validator = this;\n\n                    // Add items to error list and map\n                    $.extend( this.errorMap, errors );\n                    this.errorList = $.map( this.errorMap, function( message, name ) {\n                        return {\n                            message: message,\n                            element: validator.findByName( name )[ 0 ]\n                        };\n                    } );\n\n                    // Remove items from success list\n                    this.successList = $.grep( this.successList, function( element ) {\n                        return !( element.name in errors );\n                    } );\n                }\n                if ( this.settings.showErrors ) {\n                    this.settings.showErrors.call( this, this.errorMap, this.errorList );\n                } else {\n                    this.defaultShowErrors();\n                }\n            },\n\n            // https://jqueryvalidation.org/Validator.resetForm/\n            resetForm: function() {\n                if ( $.fn.resetForm ) {\n                    $( this.currentForm ).resetForm();\n                }\n                this.invalid = {};\n                this.submitted = {};\n                this.prepareForm();\n                this.hideErrors();\n                var elements = this.elements()\n                    .removeData( \"previousValue\" )\n                    .removeAttr( \"aria-invalid\" );\n\n                this.resetElements( elements );\n            },\n\n            resetElements: function( elements ) {\n                var i;\n\n                if ( this.settings.unhighlight ) {\n                    for ( i = 0; elements[ i ]; i++ ) {\n                        this.settings.unhighlight.call( this, elements[ i ],\n                            this.settings.errorClass, \"\" );\n                        this.findByName( elements[ i ].name ).removeClass( this.settings.validClass );\n                    }\n                } else {\n                    elements\n                        .removeClass( this.settings.errorClass )\n                        .removeClass( this.settings.validClass );\n                }\n            },\n\n            numberOfInvalids: function() {\n                return this.objectLength( this.invalid );\n            },\n\n            objectLength: function( obj ) {\n                /* jshint unused: false */\n                var count = 0,\n                    i;\n                for ( i in obj ) {\n\n                    // This check allows counting elements with empty error\n                    // message as invalid elements\n                    if ( obj[ i ] !== undefined && obj[ i ] !== null && obj[ i ] !== false ) {\n                        count++;\n                    }\n                }\n                return count;\n            },\n\n            hideErrors: function() {\n                this.hideThese( this.toHide );\n            },\n\n            hideThese: function( errors ) {\n                errors.not( this.containers ).text( \"\" );\n                this.addWrapper( errors ).hide();\n            },\n\n            valid: function() {\n                return this.size() === 0;\n            },\n\n            size: function() {\n                return this.errorList.length;\n            },\n\n            focusInvalid: function() {\n                if ( this.settings.focusInvalid ) {\n                    try {\n                        $( this.findLastActive() || this.errorList.length && this.errorList[ 0 ].element || [] )\n                            .filter( \":visible\" )\n                            .trigger( \"focus\" )\n\n                            // Manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find\n                            .trigger( \"focusin\" );\n                    } catch ( e ) {\n\n                        // Ignore IE throwing errors when focusing hidden elements\n                    }\n                }\n            },\n\n            findLastActive: function() {\n                var lastActive = this.lastActive;\n                return lastActive && $.grep( this.errorList, function( n ) {\n                    return n.element.name === lastActive.name;\n                } ).length === 1 && lastActive;\n            },\n\n            elements: function() {\n                var validator = this,\n                    rulesCache = {};\n\n                // Select all valid inputs inside the form (no submit or reset buttons)\n                return $( this.currentForm )\n                    .find( \"input, select, textarea, [contenteditable]\" )\n                    .not( \":submit, :reset, :image, :disabled\" )\n                    .not( this.settings.ignore )\n                    .filter( function() {\n                        var name = this.name || $( this ).attr( \"name\" ); // For contenteditable\n                        var isContentEditable = typeof $( this ).attr( \"contenteditable\" ) !== \"undefined\" && $( this ).attr( \"contenteditable\" ) !== \"false\";\n\n                        if ( !name && validator.settings.debug && window.console ) {\n                            console.error( \"%o has no name assigned\", this );\n                        }\n\n                        // Set form expando on contenteditable\n                        if ( isContentEditable ) {\n                            this.form = $( this ).closest( \"form\" )[ 0 ];\n                            this.name = name;\n                        }\n\n                        // Ignore elements that belong to other/nested forms\n                        if ( this.form !== validator.currentForm ) {\n                            return false;\n                        }\n\n                        // Select only the first element for each name, and only those with rules specified\n                        if ( name in rulesCache || !validator.objectLength( $( this ).rules() ) ) {\n                            return false;\n                        }\n\n                        rulesCache[ name ] = true;\n                        return true;\n                    } );\n            },\n\n            clean: function( selector ) {\n                return $( selector )[ 0 ];\n            },\n\n            errors: function() {\n                var errorClass = this.settings.errorClass.split( \" \" ).join( \".\" );\n                return $( this.settings.errorElement + \".\" + errorClass, this.errorContext );\n            },\n\n            resetInternals: function() {\n                this.successList = [];\n                this.errorList = [];\n                this.errorMap = {};\n                this.toShow = $( [] );\n                this.toHide = $( [] );\n            },\n\n            reset: function() {\n                this.resetInternals();\n                this.currentElements = $( [] );\n            },\n\n            prepareForm: function() {\n                this.reset();\n                this.toHide = this.errors().add( this.containers );\n            },\n\n            prepareElement: function( element ) {\n                this.reset();\n                this.toHide = this.errorsFor( element );\n            },\n\n            elementValue: function( element ) {\n                var $element = $( element ),\n                    type = element.type,\n                    isContentEditable = typeof $element.attr( \"contenteditable\" ) !== \"undefined\" && $element.attr( \"contenteditable\" ) !== \"false\",\n                    val, idx;\n\n                if ( type === \"radio\" || type === \"checkbox\" ) {\n                    return this.findByName( element.name ).filter( \":checked\" ).val();\n                } else if ( type === \"number\" && typeof element.validity !== \"undefined\" ) {\n                    return element.validity.badInput ? \"NaN\" : $element.val();\n                }\n\n                if ( isContentEditable ) {\n                    val = $element.text();\n                } else {\n                    val = $element.val();\n                }\n\n                if ( type === \"file\" ) {\n\n                    // Modern browser (chrome & safari)\n                    if ( val.substr( 0, 12 ) === \"C:\\\\fakepath\\\\\" ) {\n                        return val.substr( 12 );\n                    }\n\n                    // Legacy browsers\n                    // Unix-based path\n                    idx = val.lastIndexOf( \"/\" );\n                    if ( idx >= 0 ) {\n                        return val.substr( idx + 1 );\n                    }\n\n                    // Windows-based path\n                    idx = val.lastIndexOf( \"\\\\\" );\n                    if ( idx >= 0 ) {\n                        return val.substr( idx + 1 );\n                    }\n\n                    // Just the file name\n                    return val;\n                }\n\n                if ( typeof val === \"string\" ) {\n                    return val.replace( /\\r/g, \"\" );\n                }\n                return val;\n            },\n\n            check: function( element ) {\n                element = this.validationTargetFor( this.clean( element ) );\n\n                var rules = $( element ).rules(),\n                    rulesCount = $.map( rules, function( n, i ) {\n                        return i;\n                    } ).length,\n                    dependencyMismatch = false,\n                    val = this.elementValue( element ),\n                    result, method, rule, normalizer;\n\n                // Prioritize the local normalizer defined for this element over the global one\n                // if the former exists, otherwise user the global one in case it exists.\n                if ( typeof rules.normalizer === \"function\" ) {\n                    normalizer = rules.normalizer;\n                } else if (\ttypeof this.settings.normalizer === \"function\" ) {\n                    normalizer = this.settings.normalizer;\n                }\n\n                // If normalizer is defined, then call it to the changed value instead\n                // of using the real one.\n                // Note that `this` in the normalizer is `element`.\n                if ( normalizer ) {\n                    val = normalizer.call( element, val );\n\n                    // Delete the normalizer from rules to avoid treating it as a pre-defined method.\n                    delete rules.normalizer;\n                }\n\n                for ( method in rules ) {\n                    rule = { method: method, parameters: rules[ method ] };\n                    try {\n                        result = $.validator.methods[ method ].call( this, val, element, rule.parameters );\n\n                        // If a method indicates that the field is optional and therefore valid,\n                        // don't mark it as valid when there are no other rules\n                        if ( result === \"dependency-mismatch\" && rulesCount === 1 ) {\n                            dependencyMismatch = true;\n                            continue;\n                        }\n                        dependencyMismatch = false;\n\n                        if ( result === \"pending\" ) {\n                            this.toHide = this.toHide.not( this.errorsFor( element ) );\n                            return;\n                        }\n\n                        if ( !result ) {\n                            this.formatAndAdd( element, rule );\n                            return false;\n                        }\n                    } catch ( e ) {\n                        if ( this.settings.debug && window.console ) {\n                            console.log( \"Exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method.\", e );\n                        }\n                        if ( e instanceof TypeError ) {\n                            e.message += \".  Exception occurred when checking element \" + element.id + \", check the '\" + rule.method + \"' method.\";\n                        }\n\n                        throw e;\n                    }\n                }\n                if ( dependencyMismatch ) {\n                    return;\n                }\n                if ( this.objectLength( rules ) ) {\n                    this.successList.push( element );\n                }\n                return true;\n            },\n\n            // Return the custom message for the given element and validation method\n            // specified in the element's HTML5 data attribute\n            // return the generic message if present and no method specific message is present\n            customDataMessage: function( element, method ) {\n                return $( element ).data( \"msg\" + method.charAt( 0 ).toUpperCase() +\n                    method.substring( 1 ).toLowerCase() ) || $( element ).data( \"msg\" );\n            },\n\n            // Return the custom message for the given element name and validation method\n            customMessage: function( name, method ) {\n                var m = this.settings.messages[ name ];\n                return m && ( m.constructor === String ? m : m[ method ] );\n            },\n\n            // Return the first defined argument, allowing empty strings\n            findDefined: function() {\n                for ( var i = 0; i < arguments.length; i++ ) {\n                    if ( arguments[ i ] !== undefined ) {\n                        return arguments[ i ];\n                    }\n                }\n                return undefined;\n            },\n\n            // The second parameter 'rule' used to be a string, and extended to an object literal\n            // of the following form:\n            // rule = {\n            //     method: \"method name\",\n            //     parameters: \"the given method parameters\"\n            // }\n            //\n            // The old behavior still supported, kept to maintain backward compatibility with\n            // old code, and will be removed in the next major release.\n            defaultMessage: function( element, rule ) {\n                if ( typeof rule === \"string\" ) {\n                    rule = { method: rule };\n                }\n\n                var message = this.findDefined(\n                        this.customMessage( element.name, rule.method ),\n                        this.customDataMessage( element, rule.method ),\n\n                        // 'title' is never undefined, so handle empty string as undefined\n                        !this.settings.ignoreTitle && element.title || undefined,\n                        $.validator.messages[ rule.method ],\n                        \"<strong>Warning: No message defined for \" + element.name + \"</strong>\"\n                    ),\n                    theregex = /\\$?\\{(\\d+)\\}/g;\n                if ( typeof message === \"function\" ) {\n                    message = message.call( this, rule.parameters, element );\n                } else if ( theregex.test( message ) ) {\n                    message = $.validator.format( message.replace( theregex, \"{$1}\" ), rule.parameters );\n                }\n\n                return message;\n            },\n\n            formatAndAdd: function( element, rule ) {\n                var message = this.defaultMessage( element, rule );\n\n                this.errorList.push( {\n                    message: message,\n                    element: element,\n                    method: rule.method\n                } );\n\n                this.errorMap[ element.name ] = message;\n                this.submitted[ element.name ] = message;\n            },\n\n            addWrapper: function( toToggle ) {\n                if ( this.settings.wrapper ) {\n                    toToggle = toToggle.add( toToggle.parent( this.settings.wrapper ) );\n                }\n                return toToggle;\n            },\n\n            defaultShowErrors: function() {\n                var i, elements, error;\n                for ( i = 0; this.errorList[ i ]; i++ ) {\n                    error = this.errorList[ i ];\n                    if ( this.settings.highlight ) {\n                        this.settings.highlight.call( this, error.element, this.settings.errorClass, this.settings.validClass );\n                    }\n                    this.showLabel( error.element, error.message );\n                }\n                if ( this.errorList.length ) {\n                    this.toShow = this.toShow.add( this.containers );\n                }\n                if ( this.settings.success ) {\n                    for ( i = 0; this.successList[ i ]; i++ ) {\n                        this.showLabel( this.successList[ i ] );\n                    }\n                }\n                if ( this.settings.unhighlight ) {\n                    for ( i = 0, elements = this.validElements(); elements[ i ]; i++ ) {\n                        this.settings.unhighlight.call( this, elements[ i ], this.settings.errorClass, this.settings.validClass );\n                    }\n                }\n                this.toHide = this.toHide.not( this.toShow );\n                this.hideErrors();\n                this.addWrapper( this.toShow ).show();\n            },\n\n            validElements: function() {\n                return this.currentElements.not( this.invalidElements() );\n            },\n\n            invalidElements: function() {\n                return $( this.errorList ).map( function() {\n                    return this.element;\n                } );\n            },\n\n            showLabel: function( element, message ) {\n                var place, group, errorID, v,\n                    error = this.errorsFor( element ),\n                    elementID = this.idOrName( element ),\n                    describedBy = $( element ).attr( \"aria-describedby\" );\n\n                if ( error.length ) {\n\n                    // Refresh error/success class\n                    error.removeClass( this.settings.validClass ).addClass( this.settings.errorClass );\n\n                    // Replace message on existing label\n                    error.html( message );\n                } else {\n\n                    // Create error element\n                    error = $( \"<\" + this.settings.errorElement + \">\" )\n                        .attr( \"id\", elementID + \"-error\" )\n                        .addClass( this.settings.errorClass )\n                        .html( message || \"\" );\n\n                    // Maintain reference to the element to be placed into the DOM\n                    place = error;\n                    if ( this.settings.wrapper ) {\n\n                        // Make sure the element is visible, even in IE\n                        // actually showing the wrapped element is handled elsewhere\n                        place = error.hide().show().wrap( \"<\" + this.settings.wrapper + \"/>\" ).parent();\n                    }\n                    if ( this.labelContainer.length ) {\n                        this.labelContainer.append( place );\n                    } else if ( this.settings.errorPlacement ) {\n                        this.settings.errorPlacement.call( this, place, $( element ) );\n                    } else {\n                        place.insertAfter( element );\n                    }\n\n                    // Link error back to the element\n                    if ( error.is( \"label\" ) ) {\n\n                        // If the error is a label, then associate using 'for'\n                        error.attr( \"for\", elementID );\n\n                        // If the element is not a child of an associated label, then it's necessary\n                        // to explicitly apply aria-describedby\n                    } else if ( error.parents( \"label[for='\" + this.escapeCssMeta( elementID ) + \"']\" ).length === 0 ) {\n                        errorID = error.attr( \"id\" );\n\n                        // Respect existing non-error aria-describedby\n                        if ( !describedBy ) {\n                            describedBy = errorID;\n                        } else if ( !describedBy.match( new RegExp( \"\\\\b\" + this.escapeCssMeta( errorID ) + \"\\\\b\" ) ) ) {\n\n                            // Add to end of list if not already present\n                            describedBy += \" \" + errorID;\n                        }\n                        $( element ).attr( \"aria-describedby\", describedBy );\n\n                        // If this element is grouped, then assign to all elements in the same group\n                        group = this.groups[ element.name ];\n                        if ( group ) {\n                            v = this;\n                            $.each( v.groups, function( name, testgroup ) {\n                                if ( testgroup === group ) {\n                                    $( \"[name='\" + v.escapeCssMeta( name ) + \"']\", v.currentForm )\n                                        .attr( \"aria-describedby\", error.attr( \"id\" ) );\n                                }\n                            } );\n                        }\n                    }\n                }\n                if ( !message && this.settings.success ) {\n                    error.text( \"\" );\n                    if ( typeof this.settings.success === \"string\" ) {\n                        error.addClass( this.settings.success );\n                    } else {\n                        this.settings.success( error, element );\n                    }\n                }\n                this.toShow = this.toShow.add( error );\n            },\n\n            errorsFor: function( element ) {\n                var name = this.escapeCssMeta( this.idOrName( element ) ),\n                    describer = $( element ).attr( \"aria-describedby\" ),\n                    selector = \"label[for='\" + name + \"'], label[for='\" + name + \"'] *\";\n\n                // 'aria-describedby' should directly reference the error element\n                if ( describer ) {\n                    selector = selector + \", #\" + this.escapeCssMeta( describer )\n                        .replace( /\\s+/g, \", #\" ) + \":visible\";\n                }\n\n                return this\n                    .errors()\n                    .filter( selector );\n            },\n\n            // See https://api.jquery.com/category/selectors/, for CSS\n            // meta-characters that should be escaped in order to be used with JQuery\n            // as a literal part of a name/id or any selector.\n            escapeCssMeta: function( string ) {\n                if ( string === undefined ) {\n                    return \"\";\n                }\n\n                return string.replace( /([\\\\!\"#$%&'()*+,./:;<=>?@\\[\\]^`{|}~])/g, \"\\\\$1\" );\n            },\n\n            idOrName: function( element ) {\n                return this.groups[ element.name ] || ( this.checkable( element ) ? element.name : element.id || element.name );\n            },\n\n            validationTargetFor: function( element ) {\n\n                // If radio/checkbox, validate first element in group instead\n                if ( this.checkable( element ) ) {\n                    element = this.findByName( element.name );\n                }\n\n                // Always apply ignore filter\n                return $( element ).not( this.settings.ignore )[ 0 ];\n            },\n\n            checkable: function( element ) {\n                return ( /radio|checkbox/i ).test( element.type );\n            },\n\n            findByName: function( name ) {\n                return $( this.currentForm ).find( \"[name='\" + this.escapeCssMeta( name ) + \"']\" );\n            },\n\n            getLength: function( value, element ) {\n                switch ( element.nodeName.toLowerCase() ) {\n                    case \"select\":\n                        return $( \"option:selected\", element ).length;\n                    case \"input\":\n                        if ( this.checkable( element ) ) {\n                            return this.findByName( element.name ).filter( \":checked\" ).length;\n                        }\n                }\n                return value.length;\n            },\n\n            depend: function( param, element ) {\n                return this.dependTypes[ typeof param ] ? this.dependTypes[ typeof param ]( param, element ) : true;\n            },\n\n            dependTypes: {\n                \"boolean\": function( param ) {\n                    return param;\n                },\n                \"string\": function( param, element ) {\n                    return !!$( param, element.form ).length;\n                },\n                \"function\": function( param, element ) {\n                    return param( element );\n                }\n            },\n\n            optional: function( element ) {\n                var val = this.elementValue( element );\n                return !$.validator.methods.required.call( this, val, element ) && \"dependency-mismatch\";\n            },\n\n            startRequest: function( element ) {\n                if ( !this.pending[ element.name ] ) {\n                    this.pendingRequest++;\n                    $( element ).addClass( this.settings.pendingClass );\n                    this.pending[ element.name ] = true;\n                }\n            },\n\n            stopRequest: function( element, valid ) {\n                this.pendingRequest--;\n\n                // Sometimes synchronization fails, make sure pendingRequest is never < 0\n                if ( this.pendingRequest < 0 ) {\n                    this.pendingRequest = 0;\n                }\n                delete this.pending[ element.name ];\n                $( element ).removeClass( this.settings.pendingClass );\n                if ( valid && this.pendingRequest === 0 && this.formSubmitted && this.form() && this.pendingRequest === 0 ) {\n                    $( this.currentForm ).trigger( \"submit\" );\n\n                    // Remove the hidden input that was used as a replacement for the\n                    // missing submit button. The hidden input is added by `handle()`\n                    // to ensure that the value of the used submit button is passed on\n                    // for scripted submits triggered by this method\n                    if ( this.submitButton ) {\n                        $( \"input:hidden[name='\" + this.submitButton.name + \"']\", this.currentForm ).remove();\n                    }\n\n                    this.formSubmitted = false;\n                } else if ( !valid && this.pendingRequest === 0 && this.formSubmitted ) {\n                    $( this.currentForm ).triggerHandler( \"invalid-form\", [ this ] );\n                    this.formSubmitted = false;\n                }\n            },\n\n            previousValue: function( element, method ) {\n                method = typeof method === \"string\" && method || \"remote\";\n\n                return $.data( element, \"previousValue\" ) || $.data( element, \"previousValue\", {\n                    old: null,\n                    valid: true,\n                    message: this.defaultMessage( element, { method: method } )\n                } );\n            },\n\n            // Cleans up all forms and elements, removes validator-specific events\n            destroy: function() {\n                this.resetForm();\n\n                $( this.currentForm )\n                    .off( \".validate\" )\n                    .removeData( \"validator\" )\n                    .find( \".validate-equalTo-blur\" )\n                    .off( \".validate-equalTo\" )\n                    .removeClass( \"validate-equalTo-blur\" )\n                    .find( \".validate-lessThan-blur\" )\n                    .off( \".validate-lessThan\" )\n                    .removeClass( \"validate-lessThan-blur\" )\n                    .find( \".validate-lessThanEqual-blur\" )\n                    .off( \".validate-lessThanEqual\" )\n                    .removeClass( \"validate-lessThanEqual-blur\" )\n                    .find( \".validate-greaterThanEqual-blur\" )\n                    .off( \".validate-greaterThanEqual\" )\n                    .removeClass( \"validate-greaterThanEqual-blur\" )\n                    .find( \".validate-greaterThan-blur\" )\n                    .off( \".validate-greaterThan\" )\n                    .removeClass( \"validate-greaterThan-blur\" );\n            }\n\n        },\n\n        classRuleSettings: {\n            required: { required: true },\n            email: { email: true },\n            url: { url: true },\n            date: { date: true },\n            dateISO: { dateISO: true },\n            number: { number: true },\n            digits: { digits: true },\n            creditcard: { creditcard: true }\n        },\n\n        addClassRules: function( className, rules ) {\n            if ( className.constructor === String ) {\n                this.classRuleSettings[ className ] = rules;\n            } else {\n                $.extend( this.classRuleSettings, className );\n            }\n        },\n\n        classRules: function( element ) {\n            var rules = {},\n                classes = $( element ).attr( \"class\" );\n\n            if ( classes ) {\n                $.each( classes.split( \" \" ), function() {\n                    if ( this in $.validator.classRuleSettings ) {\n                        $.extend( rules, $.validator.classRuleSettings[ this ] );\n                    }\n                } );\n            }\n            return rules;\n        },\n\n        normalizeAttributeRule: function( rules, type, method, value ) {\n\n            // Convert the value to a number for number inputs, and for text for backwards compability\n            // allows type=\"date\" and others to be compared as strings\n            if ( /min|max|step/.test( method ) && ( type === null || /number|range|text/.test( type ) ) ) {\n                value = Number( value );\n\n                // Support Opera Mini, which returns NaN for undefined minlength\n                if ( isNaN( value ) ) {\n                    value = undefined;\n                }\n            }\n\n            if ( value || value === 0 ) {\n                rules[ method ] = value;\n            } else if ( type === method && type !== \"range\" ) {\n\n                // Exception: the jquery validate 'range' method\n                // does not test for the html5 'range' type\n                rules[ type === \"date\" ? \"dateISO\" : method ] = true;\n            }\n        },\n\n        attributeRules: function( element ) {\n            var rules = {},\n                $element = $( element ),\n                type = element.getAttribute( \"type\" ),\n                method, value;\n\n            for ( method in $.validator.methods ) {\n\n                // Support for <input required> in both html5 and older browsers\n                if ( method === \"required\" ) {\n                    value = element.getAttribute( method );\n\n                    // Some browsers return an empty string for the required attribute\n                    // and non-HTML5 browsers might have required=\"\" markup\n                    if ( value === \"\" ) {\n                        value = true;\n                    }\n\n                    // Force non-HTML5 browsers to return bool\n                    value = !!value;\n                } else {\n                    value = $element.attr( method );\n                }\n\n                this.normalizeAttributeRule( rules, type, method, value );\n            }\n\n            // 'maxlength' may be returned as -1, 2147483647 ( IE ) and 524288 ( safari ) for text inputs\n            if ( rules.maxlength && /-1|2147483647|524288/.test( rules.maxlength ) ) {\n                delete rules.maxlength;\n            }\n\n            return rules;\n        },\n\n        metadataRules: function (element) {\n            if (!$.metadata) {\n                return {};\n            }\n\n            var meta = $.data(element.form, 'validator').settings.meta;\n            return meta ?\n                $(element).metadata()[meta] :\n                $(element).metadata();\n        },\n        \n        dataRules: function( element ) {\n            var rules = {},\n                $element = $( element ),\n                type = element.getAttribute( \"type\" ),\n                method, value;\n\n            for ( method in $.validator.methods ) {\n                value = $element.data( \"rule\" + method.charAt( 0 ).toUpperCase() + method.substring( 1 ).toLowerCase() );\n\n                // Cast empty attributes like `data-rule-required` to `true`\n                if ( value === \"\" ) {\n                    value = true;\n                }\n\n                this.normalizeAttributeRule( rules, type, method, value );\n            }\n            return rules;\n        },\n\n        staticRules: function( element ) {\n            var rules = {},\n                validator = $.data( element.form, \"validator\" );\n\n            if ( validator.settings.rules ) {\n                rules = $.validator.normalizeRule( validator.settings.rules[ element.name ] ) || {};\n            }\n            return rules;\n        },\n\n        normalizeRules: function( rules, element ) {\n\n            // Handle dependency check\n            $.each( rules, function( prop, val ) {\n\n                // Ignore rule when param is explicitly false, eg. required:false\n                if ( val === false ) {\n                    delete rules[ prop ];\n                    return;\n                }\n                if ( val.param || val.depends ) {\n                    var keepRule = true;\n                    switch ( typeof val.depends ) {\n                        case \"string\":\n                            keepRule = !!$( val.depends, element.form ).length;\n                            break;\n                        case \"function\":\n                            keepRule = val.depends.call( element, element );\n                            break;\n                    }\n                    if ( keepRule ) {\n                        rules[ prop ] = val.param !== undefined ? val.param : true;\n                    } else {\n                        $.data( element.form, \"validator\" ).resetElements( $( element ) );\n                        delete rules[ prop ];\n                    }\n                }\n            } );\n\n            // Evaluate parameters\n            $.each( rules, function( rule, parameter ) {\n                rules[ rule ] = typeof parameter === \"function\" && rule !== \"normalizer\" ? parameter( element ) : parameter;\n            } );\n\n            // Clean number parameters\n            $.each( [ \"minlength\", \"maxlength\" ], function() {\n                if ( rules[ this ] ) {\n                    rules[ this ] = Number( rules[ this ] );\n                }\n            } );\n            $.each( [ \"rangelength\", \"range\" ], function() {\n                var parts;\n                if ( rules[ this ] ) {\n                    if ( Array.isArray( rules[ this ] ) ) {\n                        rules[ this ] = [ Number( rules[ this ][ 0 ] ), Number( rules[ this ][ 1 ] ) ];\n                    } else if ( typeof rules[ this ] === \"string\" ) {\n                        parts = rules[ this ].replace( /[\\[\\]]/g, \"\" ).split( /[\\s,]+/ );\n                        rules[ this ] = [ Number( parts[ 0 ] ), Number( parts[ 1 ] ) ];\n                    }\n                }\n            } );\n\n            if ( $.validator.autoCreateRanges ) {\n\n                // Auto-create ranges\n                if ( rules.min != null && rules.max != null ) {\n                    rules.range = [ rules.min, rules.max ];\n                    delete rules.min;\n                    delete rules.max;\n                }\n                if ( rules.minlength != null && rules.maxlength != null ) {\n                    rules.rangelength = [ rules.minlength, rules.maxlength ];\n                    delete rules.minlength;\n                    delete rules.maxlength;\n                }\n            }\n\n            return rules;\n        },\n\n        // Converts a simple string to a {string: true} rule, e.g., \"required\" to {required:true}\n        normalizeRule: function( data ) {\n            if ( typeof data === \"string\" ) {\n                var transformed = {};\n                $.each( data.split( /\\s/ ), function() {\n                    transformed[ this ] = true;\n                } );\n                data = transformed;\n            }\n            return data;\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.addMethod/\n        addMethod: function( name, method, message ) {\n            $.validator.methods[ name ] = method;\n            $.validator.messages[ name ] = message !== undefined ? message : $.validator.messages[ name ];\n            if ( method.length < 3 ) {\n                $.validator.addClassRules( name, $.validator.normalizeRule( name ) );\n            }\n        },\n\n        // https://jqueryvalidation.org/jQuery.validator.methods/\n        methods: {\n\n            // https://jqueryvalidation.org/required-method/\n            required: function( value, element, param ) {\n\n                // Check if dependency is met\n                if ( !this.depend( param, element ) ) {\n                    return \"dependency-mismatch\";\n                }\n                if ( element.nodeName.toLowerCase() === \"select\" ) {\n\n                    // Could be an array for select-multiple or a string, both are fine this way\n                    var val = $( element ).val();\n                    return val && val.length > 0;\n                }\n                if ( this.checkable( element ) ) {\n                    return this.getLength( value, element ) > 0;\n                }\n                return value !== undefined && value !== null && value.length > 0;\n            },\n\n            // https://jqueryvalidation.org/email-method/\n            email: function( value, element ) {\n\n                // From https://html.spec.whatwg.org/multipage/forms.html#valid-e-mail-address\n                // Retrieved 2014-01-14\n                // If you have a problem with this implementation, report a bug against the above spec\n                // Or use custom methods to implement your own email validation\n                return this.optional( element ) || /^[a-zA-Z0-9.!#$%&'*+\\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/url-method/\n            url: function( value, element ) {\n\n                // Copyright (c) 2010-2013 Diego Perini, MIT licensed\n                // https://gist.github.com/dperini/729294\n                // see also https://mathiasbynens.be/demo/url-regex\n                // modified to allow protocol-relative URLs\n                return this.optional( element ) || /^(?:(?:(?:https?|ftp):)?\\/\\/)(?:(?:[^\\]\\[?\\/<~#`!@$^&*()+=}|:\";',>{ ]|%[0-9A-Fa-f]{2})+(?::(?:[^\\]\\[?\\/<~#`!@$^&*()+=}|:\";',>{ ]|%[0-9A-Fa-f]{2})*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z0-9\\u00a1-\\uffff][a-z0-9\\u00a1-\\uffff_-]{0,62})?[a-z0-9\\u00a1-\\uffff]\\.)+(?:[a-z\\u00a1-\\uffff]{2,}\\.?))(?::\\d{2,5})?(?:[/?#]\\S*)?$/i.test( value );\n            },\n\n            // https://jqueryvalidation.org/date-method/\n            date: ( function() {\n                var called = false;\n\n                return function( value, element ) {\n                    if ( !called ) {\n                        called = true;\n                        if ( this.settings.debug && window.console ) {\n                            console.warn(\n                                \"The `date` method is deprecated and will be removed in version '2.0.0'.\\n\" +\n                                \"Please don't use it, since it relies on the Date constructor, which\\n\" +\n                                \"behaves very differently across browsers and locales. Use `dateISO`\\n\" +\n                                \"instead or one of the locale specific methods in `localizations/`\\n\" +\n                                \"and `additional-methods.js`.\"\n                            );\n                        }\n                    }\n\n                    return this.optional( element ) || !/Invalid|NaN/.test( new Date( value ).toString() );\n                };\n            }() ),\n\n            // https://jqueryvalidation.org/dateISO-method/\n            dateISO: function( value, element ) {\n                return this.optional( element ) || /^\\d{4}[\\/\\-](0?[1-9]|1[012])[\\/\\-](0?[1-9]|[12][0-9]|3[01])$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/number-method/\n            number: function( value, element ) {\n                return this.optional( element ) || /^(?:-?\\d+|-?\\d{1,3}(?:,\\d{3})+)?(?:\\.\\d+)?$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/digits-method/\n            digits: function( value, element ) {\n                return this.optional( element ) || /^\\d+$/.test( value );\n            },\n\n            // https://jqueryvalidation.org/minlength-method/\n            minlength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || length >= param;\n            },\n\n            // https://jqueryvalidation.org/maxlength-method/\n            maxlength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || length <= param;\n            },\n\n            // https://jqueryvalidation.org/rangelength-method/\n            rangelength: function( value, element, param ) {\n                var length = Array.isArray( value ) ? value.length : this.getLength( value, element );\n                return this.optional( element ) || ( length >= param[ 0 ] && length <= param[ 1 ] );\n            },\n\n            // https://jqueryvalidation.org/min-method/\n            min: function( value, element, param ) {\n                return this.optional( element ) || value >= param;\n            },\n\n            // https://jqueryvalidation.org/max-method/\n            max: function( value, element, param ) {\n                return this.optional( element ) || value <= param;\n            },\n\n            // https://jqueryvalidation.org/range-method/\n            range: function( value, element, param ) {\n                return this.optional( element ) || ( value >= param[ 0 ] && value <= param[ 1 ] );\n            },\n\n            // https://jqueryvalidation.org/step-method/\n            step: function( value, element, param ) {\n                var type = $( element ).attr( \"type\" ),\n                    errorMessage = \"Step attribute on input type \" + type + \" is not supported.\",\n                    supportedTypes = [ \"text\", \"number\", \"range\" ],\n                    re = new RegExp( \"\\\\b\" + type + \"\\\\b\" ),\n                    notSupported = type && !re.test( supportedTypes.join() ),\n                    decimalPlaces = function( num ) {\n                        var match = ( \"\" + num ).match( /(?:\\.(\\d+))?$/ );\n                        if ( !match ) {\n                            return 0;\n                        }\n\n                        // Number of digits right of decimal point.\n                        return match[ 1 ] ? match[ 1 ].length : 0;\n                    },\n                    toInt = function( num ) {\n                        return Math.round( num * Math.pow( 10, decimals ) );\n                    },\n                    valid = true,\n                    decimals;\n\n                // Works only for text, number and range input types\n                // TODO find a way to support input types date, datetime, datetime-local, month, time and week\n                if ( notSupported ) {\n                    throw new Error( errorMessage );\n                }\n\n                decimals = decimalPlaces( param );\n\n                // Value can't have too many decimals\n                if ( decimalPlaces( value ) > decimals || toInt( value ) % toInt( param ) !== 0 ) {\n                    valid = false;\n                }\n\n                return this.optional( element ) || valid;\n            },\n\n            // https://jqueryvalidation.org/equalTo-method/\n            equalTo: function( value, element, param ) {\n\n                // Bind to the blur event of the target in order to revalidate whenever the target field is updated\n                var target = $( param );\n                if ( this.settings.onfocusout && target.not( \".validate-equalTo-blur\" ).length ) {\n                    target.addClass( \"validate-equalTo-blur\" ).on( \"blur.validate-equalTo\", function() {\n                        $( element ).valid();\n                    } );\n                }\n                return value === target.val();\n            },\n\n            // https://jqueryvalidation.org/remote-method/\n            remote: function( value, element, param, method ) {\n                if ( this.optional( element ) ) {\n                    return \"dependency-mismatch\";\n                }\n\n                method = typeof method === \"string\" && method || \"remote\";\n\n                var previous = this.previousValue( element, method ),\n                    validator, data, optionDataString;\n\n                if ( !this.settings.messages[ element.name ] ) {\n                    this.settings.messages[ element.name ] = {};\n                }\n                previous.originalMessage = previous.originalMessage || this.settings.messages[ element.name ][ method ];\n                this.settings.messages[ element.name ][ method ] = previous.message;\n\n                param = typeof param === \"string\" && { url: param } || param;\n                optionDataString = $.param( $.extend( { data: value }, param.data ) );\n                if ( previous.old === optionDataString ) {\n                    return previous.valid;\n                }\n\n                previous.old = optionDataString;\n                validator = this;\n                this.startRequest( element );\n                data = {};\n                data[ element.name ] = value;\n                $.ajax( $.extend( true, {\n                    mode: \"abort\",\n                    port: \"validate\" + element.name,\n                    dataType: \"json\",\n                    data: data,\n                    context: validator.currentForm,\n                    success: function( response ) {\n                        var valid = response === true || response === \"true\",\n                            errors, message, submitted;\n\n                        validator.settings.messages[ element.name ][ method ] = previous.originalMessage;\n                        if ( valid ) {\n                            submitted = validator.formSubmitted;\n                            validator.resetInternals();\n                            validator.toHide = validator.errorsFor( element );\n                            validator.formSubmitted = submitted;\n                            validator.successList.push( element );\n                            validator.invalid[ element.name ] = false;\n                            validator.showErrors();\n                        } else {\n                            errors = {};\n                            message = response || validator.defaultMessage( element, { method: method, parameters: value } );\n                            errors[ element.name ] = previous.message = message;\n                            validator.invalid[ element.name ] = true;\n                            validator.showErrors( errors );\n                        }\n                        previous.valid = valid;\n                        validator.stopRequest( element, valid );\n                    }\n                }, param ) );\n                return \"pending\";\n            }\n        }\n\n    } );\n\n// Ajax mode: abort\n// usage: $.ajax({ mode: \"abort\"[, port: \"uniqueport\"]});\n// if mode:\"abort\" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()\n\n    var pendingRequests = {},\n        ajax;\n\n// Use a prefilter if available (1.5+)\n    if ( $.ajaxPrefilter ) {\n        $.ajaxPrefilter( function( settings, _, xhr ) {\n            var port = settings.port;\n            if ( settings.mode === \"abort\" ) {\n                if ( pendingRequests[ port ] ) {\n                    pendingRequests[ port ].abort();\n                }\n                pendingRequests[ port ] = xhr;\n            }\n        } );\n    } else {\n\n        // Proxy ajax\n        ajax = $.ajax;\n        $.ajax = function( settings ) {\n            var mode = ( \"mode\" in settings ? settings : $.ajaxSettings ).mode,\n                port = ( \"port\" in settings ? settings : $.ajaxSettings ).port;\n            if ( mode === \"abort\" ) {\n                if ( pendingRequests[ port ] ) {\n                    pendingRequests[ port ].abort();\n                }\n                pendingRequests[ port ] = ajax.apply( this, arguments );\n                return pendingRequests[ port ];\n            }\n            return ajax.apply( this, arguments );\n        };\n    }\n    return $;\n}));\n","jquery/jquery.tabs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    \"jquery\",\n    \"jquery/bootstrap/tab\",\n    \"jquery/bootstrap/collapse\",\n], function () {\n\n});\n","jquery/compat.js":"// Import every plugin under the sun. Bad for performance,\n// but prevents the store from breaking in situations\n// where a dependency was missed during the migration from\n// a monolith build of jQueryUI to a modular one\n\ndefine([\n    'jquery-ui-modules/core',\n    'jquery-ui-modules/accordion',\n    'jquery-ui-modules/autocomplete',\n    'jquery-ui-modules/button',\n    'jquery-ui-modules/datepicker',\n    'jquery-ui-modules/dialog',\n    'jquery-ui-modules/draggable',\n    'jquery-ui-modules/droppable',\n    'jquery-ui-modules/effect-blind',\n    'jquery-ui-modules/effect-bounce',\n    'jquery-ui-modules/effect-clip',\n    'jquery-ui-modules/effect-drop',\n    'jquery-ui-modules/effect-explode',\n    'jquery-ui-modules/effect-fade',\n    'jquery-ui-modules/effect-fold',\n    'jquery-ui-modules/effect-highlight',\n    'jquery-ui-modules/effect-scale',\n    'jquery-ui-modules/effect-pulsate',\n    'jquery-ui-modules/effect-shake',\n    'jquery-ui-modules/effect-slide',\n    'jquery-ui-modules/effect-transfer',\n    'jquery-ui-modules/effect',\n    'jquery-ui-modules/menu',\n    'jquery-ui-modules/mouse',\n    'jquery-ui-modules/position',\n    'jquery-ui-modules/progressbar',\n    'jquery-ui-modules/resizable',\n    'jquery-ui-modules/selectable',\n    'jquery-ui-modules/slider',\n    'jquery-ui-modules/sortable',\n    'jquery-ui-modules/spinner',\n    'jquery-ui-modules/tabs',\n    'jquery-ui-modules/timepicker',\n    'jquery-ui-modules/tooltip',\n    'jquery-ui-modules/widget'\n], function() {\n    console.warn(\n        'Fallback to JQueryUI Compat activated. ' +\n        'Your store is missing a dependency for a ' +\n        'jQueryUI widget. Identifying and addressing the dependency ' +\n        'will drastically improve the performance of your site.'\n    );\n});\n","jquery/jquery-migrate.js":"/*!\n * jQuery Migrate - v3.3.2 - 2020-11-17T23:22Z\n * Copyright OpenJS Foundation and other contributors\n */\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [ \"jquery\" ], function( jQuery ) {\n            return factory( jQuery, window );\n        } );\n    } else if ( typeof module === \"object\" && module.exports ) {\n\n        // Node/CommonJS\n        // eslint-disable-next-line no-undef\n        module.exports = factory( require( \"jquery\" ), window );\n    } else {\n\n        // Browser globals\n        factory( jQuery, window );\n    }\n} )( function( jQuery, window ) {\n    \"use strict\";\n\n    jQuery.migrateVersion = \"3.3.2\";\n\n// Returns 0 if v1 == v2, -1 if v1 < v2, 1 if v1 > v2\n    function compareVersions( v1, v2 ) {\n        var i,\n            rVersionParts = /^(\\d+)\\.(\\d+)\\.(\\d+)/,\n            v1p = rVersionParts.exec( v1 ) || [ ],\n            v2p = rVersionParts.exec( v2 ) || [ ];\n\n        for ( i = 1; i <= 3; i++ ) {\n            if ( +v1p[ i ] > +v2p[ i ] ) {\n                return 1;\n            }\n            if ( +v1p[ i ] < +v2p[ i ] ) {\n                return -1;\n            }\n        }\n        return 0;\n    }\n\n    function jQueryVersionSince( version ) {\n        return compareVersions( jQuery.fn.jquery, version ) >= 0;\n    }\n\n    ( function() {\n\n        // Support: IE9 only\n        // IE9 only creates console object when dev tools are first opened\n        // IE9 console is a host object, callable but doesn't have .apply()\n        if ( !window.console || !window.console.log ) {\n            return;\n        }\n\n        // Need jQuery 3.0.0+ and no older Migrate loaded\n        if ( !jQuery || !jQueryVersionSince( \"3.0.0\" ) ) {\n            window.console.log( \"JQMIGRATE: jQuery 3.0.0+ REQUIRED\" );\n        }\n        if ( jQuery.migrateWarnings ) {\n            window.console.log( \"JQMIGRATE: Migrate plugin loaded multiple times\" );\n        }\n\n        // Show a message on the console so devs know we're active\n        window.console.log( \"JQMIGRATE: Migrate is installed\" +\n            ( jQuery.migrateMute ? \"\" : \" with logging active\" ) +\n            \", version \" + jQuery.migrateVersion );\n\n    } )();\n\n    var warnedAbout = {};\n\n// By default each warning is only reported once.\n    jQuery.migrateDeduplicateWarnings = true;\n\n// List of warnings already given; public read only\n    jQuery.migrateWarnings = [];\n\n// Set to false to disable traces that appear with warnings\n    if ( jQuery.migrateTrace === undefined ) {\n        jQuery.migrateTrace = true;\n    }\n\n// Forget any warnings we've already given; public\n    jQuery.migrateReset = function() {\n        warnedAbout = {};\n        jQuery.migrateWarnings.length = 0;\n    };\n\n    function migrateWarn( msg ) {\n        var console = window.console;\n        if ( !jQuery.migrateDeduplicateWarnings || !warnedAbout[ msg ] ) {\n            warnedAbout[ msg ] = true;\n            jQuery.migrateWarnings.push( msg );\n            if ( console && console.warn && !jQuery.migrateMute ) {\n                console.warn( \"JQMIGRATE: \" + msg );\n                if ( jQuery.migrateTrace && console.trace ) {\n                    console.trace();\n                }\n            }\n        }\n    }\n\n    function migrateWarnProp( obj, prop, value, msg ) {\n        Object.defineProperty( obj, prop, {\n            configurable: true,\n            enumerable: true,\n            get: function() {\n                migrateWarn( msg );\n                return value;\n            },\n            set: function( newValue ) {\n                migrateWarn( msg );\n                value = newValue;\n            }\n        } );\n    }\n\n    function migrateWarnFunc( obj, prop, newFunc, msg ) {\n        obj[ prop ] = function() {\n            migrateWarn( msg );\n            return newFunc.apply( this, arguments );\n        };\n    }\n\n    if ( window.document.compatMode === \"BackCompat\" ) {\n\n        // JQuery has never supported or tested Quirks Mode\n        migrateWarn( \"jQuery is not compatible with Quirks Mode\" );\n    }\n\n    var findProp,\n        class2type = {},\n        oldInit = jQuery.fn.init,\n        oldFind = jQuery.find,\n\n        rattrHashTest = /\\[(\\s*[-\\w]+\\s*)([~|^$*]?=)\\s*([-\\w#]*?#[-\\w#]*)\\s*\\]/,\n        rattrHashGlob = /\\[(\\s*[-\\w]+\\s*)([~|^$*]?=)\\s*([-\\w#]*?#[-\\w#]*)\\s*\\]/g,\n\n        // Support: Android <=4.0 only\n        // Make sure we trim BOM and NBSP\n        rtrim = /^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g;\n\n    jQuery.fn.init = function( arg1 ) {\n        var args = Array.prototype.slice.call( arguments );\n\n        if ( typeof arg1 === \"string\" && arg1 === \"#\" ) {\n\n            // JQuery( \"#\" ) is a bogus ID selector, but it returned an empty set before jQuery 3.0\n            migrateWarn( \"jQuery( '#' ) is not a valid selector\" );\n            args[ 0 ] = [];\n        }\n\n        return oldInit.apply( this, args );\n    };\n    jQuery.fn.init.prototype = jQuery.fn;\n\n    jQuery.find = function( selector ) {\n        var args = Array.prototype.slice.call( arguments );\n\n        // Support: PhantomJS 1.x\n        // String#match fails to match when used with a //g RegExp, only on some strings\n        if ( typeof selector === \"string\" && rattrHashTest.test( selector ) ) {\n\n            // The nonstandard and undocumented unquoted-hash was removed in jQuery 1.12.0\n            // First see if qS thinks it's a valid selector, if so avoid a false positive\n            try {\n                window.document.querySelector( selector );\n            } catch ( err1 ) {\n\n                // Didn't *look* valid to qSA, warn and try quoting what we think is the value\n                selector = selector.replace( rattrHashGlob, function( _, attr, op, value ) {\n                    return \"[\" + attr + op + \"\\\"\" + value + \"\\\"]\";\n                } );\n\n                // If the regexp *may* have created an invalid selector, don't update it\n                // Note that there may be false alarms if selector uses jQuery extensions\n                try {\n                    window.document.querySelector( selector );\n                    migrateWarn( \"Attribute selector with '#' must be quoted: \" + args[ 0 ] );\n                    args[ 0 ] = selector;\n                } catch ( err2 ) {\n                    migrateWarn( \"Attribute selector with '#' was not fixed: \" + args[ 0 ] );\n                }\n            }\n        }\n\n        return oldFind.apply( this, args );\n    };\n\n// Copy properties attached to original jQuery.find method (e.g. .attr, .isXML)\n    for ( findProp in oldFind ) {\n        if ( Object.prototype.hasOwnProperty.call( oldFind, findProp ) ) {\n            jQuery.find[ findProp ] = oldFind[ findProp ];\n        }\n    }\n\n// The number of elements contained in the matched element set\n    migrateWarnFunc( jQuery.fn, \"size\", function() {\n            return this.length;\n        },\n        \"jQuery.fn.size() is deprecated and removed; use the .length property\" );\n\n    migrateWarnFunc( jQuery, \"parseJSON\", function() {\n            return JSON.parse.apply( null, arguments );\n        },\n        \"jQuery.parseJSON is deprecated; use JSON.parse\" );\n\n    migrateWarnFunc( jQuery, \"holdReady\", jQuery.holdReady,\n        \"jQuery.holdReady is deprecated\" );\n\n    migrateWarnFunc( jQuery, \"unique\", jQuery.uniqueSort,\n        \"jQuery.unique is deprecated; use jQuery.uniqueSort\" );\n\n// Now jQuery.expr.pseudos is the standard incantation\n    migrateWarnProp( jQuery.expr, \"filters\", jQuery.expr.pseudos,\n        \"jQuery.expr.filters is deprecated; use jQuery.expr.pseudos\" );\n    migrateWarnProp( jQuery.expr, \":\", jQuery.expr.pseudos,\n        \"jQuery.expr[':'] is deprecated; use jQuery.expr.pseudos\" );\n\n// Prior to jQuery 3.1.1 there were internal refs so we don't warn there\n    if ( jQueryVersionSince( \"3.1.1\" ) ) {\n        migrateWarnFunc( jQuery, \"trim\", function( text ) {\n                return text == null ?\n                    \"\" :\n                    ( text + \"\" ).replace( rtrim, \"\" );\n            },\n            \"jQuery.trim is deprecated; use String.prototype.trim\" );\n    }\n\n// Prior to jQuery 3.2 there were internal refs so we don't warn there\n    if ( jQueryVersionSince( \"3.2.0\" ) ) {\n        migrateWarnFunc( jQuery, \"nodeName\", function( elem, name ) {\n                return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();\n            },\n            \"jQuery.nodeName is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isArray\", Array.isArray,\n            \"jQuery.isArray is deprecated; use Array.isArray\"\n        );\n    }\n\n    if ( jQueryVersionSince( \"3.3.0\" ) ) {\n\n        migrateWarnFunc( jQuery, \"isNumeric\", function( obj ) {\n\n                // As of jQuery 3.0, isNumeric is limited to\n                // strings and numbers (primitives or objects)\n                // that can be coerced to finite numbers (gh-2662)\n                var type = typeof obj;\n                return ( type === \"number\" || type === \"string\" ) &&\n\n                    // parseFloat NaNs numeric-cast false positives (\"\")\n                    // ...but misinterprets leading-number strings, e.g. hex literals (\"0x...\")\n                    // subtraction forces infinities to NaN\n                    !isNaN( obj - parseFloat( obj ) );\n            },\n            \"jQuery.isNumeric() is deprecated\"\n        );\n\n        // Populate the class2type map\n        jQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".\n            split( \" \" ),\n            function( _, name ) {\n                class2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n            } );\n\n        migrateWarnFunc( jQuery, \"type\", function( obj ) {\n                if ( obj == null ) {\n                    return obj + \"\";\n                }\n\n                // Support: Android <=2.3 only (functionish RegExp)\n                return typeof obj === \"object\" || typeof obj === \"function\" ?\n                    class2type[ Object.prototype.toString.call( obj ) ] || \"object\" :\n                    typeof obj;\n            },\n            \"jQuery.type is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isFunction\",\n            function( obj ) {\n                return typeof obj === \"function\";\n            },\n            \"jQuery.isFunction() is deprecated\" );\n\n        migrateWarnFunc( jQuery, \"isWindow\",\n            function( obj ) {\n                return obj != null && obj === obj.window;\n            },\n            \"jQuery.isWindow() is deprecated\"\n        );\n    }\n\n// Support jQuery slim which excludes the ajax module\n    if ( jQuery.ajax ) {\n\n        var oldAjax = jQuery.ajax,\n            rjsonp = /(=)\\?(?=&|$)|\\?\\?/;\n\n        jQuery.ajax = function( ) {\n            var jQXHR = oldAjax.apply( this, arguments );\n\n            // Be sure we got a jQXHR (e.g., not sync)\n            if ( jQXHR.promise ) {\n                migrateWarnFunc( jQXHR, \"success\", jQXHR.done,\n                    \"jQXHR.success is deprecated and removed\" );\n                migrateWarnFunc( jQXHR, \"error\", jQXHR.fail,\n                    \"jQXHR.error is deprecated and removed\" );\n                migrateWarnFunc( jQXHR, \"complete\", jQXHR.always,\n                    \"jQXHR.complete is deprecated and removed\" );\n            }\n\n            return jQXHR;\n        };\n\n// Only trigger the logic in jQuery <4 as the JSON-to-JSONP auto-promotion\n// behavior is gone in jQuery 4.0 and as it has security implications, we don't\n// want to restore the legacy behavior.\n        if ( !jQueryVersionSince( \"4.0.0\" ) ) {\n\n            // Register this prefilter before the jQuery one. Otherwise, a promoted\n            // request is transformed into one with the script dataType and we can't\n            // catch it anymore.\n            jQuery.ajaxPrefilter( \"+json\", function( s ) {\n\n                // Warn if JSON-to-JSONP auto-promotion happens.\n                if ( s.jsonp !== false && ( rjsonp.test( s.url ) ||\n                    typeof s.data === \"string\" &&\n                    ( s.contentType || \"\" )\n                        .indexOf( \"application/x-www-form-urlencoded\" ) === 0 &&\n                    rjsonp.test( s.data )\n                ) ) {\n                    migrateWarn( \"JSON-to-JSONP auto-promotion is deprecated\" );\n                }\n            } );\n        }\n\n    }\n\n    var oldRemoveAttr = jQuery.fn.removeAttr,\n        oldToggleClass = jQuery.fn.toggleClass,\n        rmatchNonSpace = /\\S+/g;\n\n    jQuery.fn.removeAttr = function( name ) {\n        var self = this;\n\n        jQuery.each( name.match( rmatchNonSpace ), function( _i, attr ) {\n            if ( jQuery.expr.match.bool.test( attr ) ) {\n                migrateWarn( \"jQuery.fn.removeAttr no longer sets boolean properties: \" + attr );\n                self.prop( attr, false );\n            }\n        } );\n\n        return oldRemoveAttr.apply( this, arguments );\n    };\n\n    jQuery.fn.toggleClass = function( state ) {\n\n        // Only deprecating no-args or single boolean arg\n        if ( state !== undefined && typeof state !== \"boolean\" ) {\n            return oldToggleClass.apply( this, arguments );\n        }\n\n        migrateWarn( \"jQuery.fn.toggleClass( boolean ) is deprecated\" );\n\n        // Toggle entire class name of each element\n        return this.each( function() {\n            var className = this.getAttribute && this.getAttribute( \"class\" ) || \"\";\n\n            if ( className ) {\n                jQuery.data( this, \"__className__\", className );\n            }\n\n            // If the element has a class name or if we're passed `false`,\n            // then remove the whole classname (if there was one, the above saved it).\n            // Otherwise bring back whatever was previously saved (if anything),\n            // falling back to the empty string if nothing was stored.\n            if ( this.setAttribute ) {\n                this.setAttribute( \"class\",\n                    className || state === false ?\n                        \"\" :\n                        jQuery.data( this, \"__className__\" ) || \"\"\n                );\n            }\n        } );\n    };\n\n    function camelCase( string ) {\n        return string.replace( /-([a-z])/g, function( _, letter ) {\n            return letter.toUpperCase();\n        } );\n    }\n\n    var oldFnCss,\n        internalSwapCall = false,\n        ralphaStart = /^[a-z]/,\n\n        // The regex visualized:\n        //\n        //                         /----------\\\n        //                        |            |    /-------\\\n        //                        |  / Top  \\  |   |         |\n        //         /--- Border ---+-| Right  |-+---+- Width -+---\\\n        //        |                 | Bottom |                    |\n        //        |                  \\ Left /                     |\n        //        |                                               |\n        //        |                              /----------\\     |\n        //        |          /-------------\\    |            |    |- END\n        //        |         |               |   |  / Top  \\  |    |\n        //        |         |  / Margin  \\  |   | | Right  | |    |\n        //        |---------+-|           |-+---+-| Bottom |-+----|\n        //        |            \\ Padding /         \\ Left /       |\n        // BEGIN -|                                               |\n        //        |                /---------\\                    |\n        //        |               |           |                   |\n        //        |               |  / Min \\  |    / Width  \\     |\n        //         \\--------------+-|       |-+---|          |---/\n        //                           \\ Max /       \\ Height /\n        rautoPx = /^(?:Border(?:Top|Right|Bottom|Left)?(?:Width|)|(?:Margin|Padding)?(?:Top|Right|Bottom|Left)?|(?:Min|Max)?(?:Width|Height))$/;\n\n// If this version of jQuery has .swap(), don't false-alarm on internal uses\n    if ( jQuery.swap ) {\n        jQuery.each( [ \"height\", \"width\", \"reliableMarginRight\" ], function( _, name ) {\n            var oldHook = jQuery.cssHooks[ name ] && jQuery.cssHooks[ name ].get;\n\n            if ( oldHook ) {\n                jQuery.cssHooks[ name ].get = function() {\n                    var ret;\n\n                    internalSwapCall = true;\n                    ret = oldHook.apply( this, arguments );\n                    internalSwapCall = false;\n                    return ret;\n                };\n            }\n        } );\n    }\n\n    jQuery.swap = function( elem, options, callback, args ) {\n        var ret, name,\n            old = {};\n\n        if ( !internalSwapCall ) {\n            migrateWarn( \"jQuery.swap() is undocumented and deprecated\" );\n        }\n\n        // Remember the old values, and insert the new ones\n        for ( name in options ) {\n            old[ name ] = elem.style[ name ];\n            elem.style[ name ] = options[ name ];\n        }\n\n        ret = callback.apply( elem, args || [] );\n\n        // Revert the old values\n        for ( name in options ) {\n            elem.style[ name ] = old[ name ];\n        }\n\n        return ret;\n    };\n\n    if ( jQueryVersionSince( \"3.4.0\" ) && typeof Proxy !== \"undefined\" ) {\n\n        jQuery.cssProps = new Proxy( jQuery.cssProps || {}, {\n            set: function() {\n                migrateWarn( \"JQMIGRATE: jQuery.cssProps is deprecated\" );\n                return Reflect.set.apply( this, arguments );\n            }\n        } );\n    }\n\n// Create a dummy jQuery.cssNumber if missing. It won't be used by jQuery but\n// it will prevent code adding new keys to it unconditionally from crashing.\n    if ( !jQuery.cssNumber ) {\n        jQuery.cssNumber = {};\n    }\n\n    function isAutoPx( prop ) {\n\n        // The first test is used to ensure that:\n        // 1. The prop starts with a lowercase letter (as we uppercase it for the second regex).\n        // 2. The prop is not empty.\n        return ralphaStart.test( prop ) &&\n            rautoPx.test( prop[ 0 ].toUpperCase() + prop.slice( 1 ) );\n    }\n\n    oldFnCss = jQuery.fn.css;\n\n    jQuery.fn.css = function( name, value ) {\n        var camelName,\n            origThis = this;\n        if ( name && typeof name === \"object\" && !Array.isArray( name ) ) {\n            jQuery.each( name, function( n, v ) {\n                jQuery.fn.css.call( origThis, n, v );\n            } );\n            return this;\n        }\n        if ( typeof value === \"number\" ) {\n            camelName = camelCase( name );\n            if ( !isAutoPx( camelName ) && !jQuery.cssNumber[ camelName ] ) {\n                migrateWarn( \"Number-typed values are deprecated for jQuery.fn.css( \\\"\" +\n                    name + \"\\\", value )\" );\n            }\n        }\n\n        return oldFnCss.apply( this, arguments );\n    };\n\n    var oldData = jQuery.data;\n\n    jQuery.data = function( elem, name, value ) {\n        var curData, sameKeys, key;\n\n        // Name can be an object, and each entry in the object is meant to be set as data\n        if ( name && typeof name === \"object\" && arguments.length === 2 ) {\n            curData = jQuery.hasData( elem ) && oldData.call( this, elem );\n            sameKeys = {};\n            for ( key in name ) {\n                if ( key !== camelCase( key ) ) {\n                    migrateWarn( \"jQuery.data() always sets/gets camelCased names: \" + key );\n                    curData[ key ] = name[ key ];\n                } else {\n                    sameKeys[ key ] = name[ key ];\n                }\n            }\n\n            oldData.call( this, elem, sameKeys );\n\n            return name;\n        }\n\n        // If the name is transformed, look for the un-transformed name in the data object\n        if ( name && typeof name === \"string\" && name !== camelCase( name ) ) {\n            curData = jQuery.hasData( elem ) && oldData.call( this, elem );\n            if ( curData && name in curData ) {\n                migrateWarn( \"jQuery.data() always sets/gets camelCased names: \" + name );\n                if ( arguments.length > 2 ) {\n                    curData[ name ] = value;\n                }\n                return curData[ name ];\n            }\n        }\n\n        return oldData.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the effects module\n    if ( jQuery.fx ) {\n\n        var intervalValue, intervalMsg,\n            oldTweenRun = jQuery.Tween.prototype.run,\n            linearEasing = function( pct ) {\n                return pct;\n            };\n\n        jQuery.Tween.prototype.run = function( ) {\n            if ( jQuery.easing[ this.easing ].length > 1 ) {\n                migrateWarn(\n                    \"'jQuery.easing.\" + this.easing.toString() + \"' should use only one argument\"\n                );\n\n                jQuery.easing[ this.easing ] = linearEasing;\n            }\n\n            oldTweenRun.apply( this, arguments );\n        };\n\n        intervalValue = jQuery.fx.interval || 13;\n        intervalMsg = \"jQuery.fx.interval is deprecated\";\n\n// Support: IE9, Android <=4.4\n// Avoid false positives on browsers that lack rAF\n// Don't warn if document is hidden, jQuery uses setTimeout (#292)\n        if ( window.requestAnimationFrame ) {\n            Object.defineProperty( jQuery.fx, \"interval\", {\n                configurable: true,\n                enumerable: true,\n                get: function() {\n                    if ( !window.document.hidden ) {\n                        migrateWarn( intervalMsg );\n                    }\n                    return intervalValue;\n                },\n                set: function( newValue ) {\n                    migrateWarn( intervalMsg );\n                    intervalValue = newValue;\n                }\n            } );\n        }\n\n    }\n\n    var oldLoad = jQuery.fn.load,\n        oldEventAdd = jQuery.event.add,\n        originalFix = jQuery.event.fix;\n\n    jQuery.event.props = [];\n    jQuery.event.fixHooks = {};\n\n    migrateWarnProp( jQuery.event.props, \"concat\", jQuery.event.props.concat,\n        \"jQuery.event.props.concat() is deprecated and removed\" );\n\n    jQuery.event.fix = function( originalEvent ) {\n        var event,\n            type = originalEvent.type,\n            fixHook = this.fixHooks[ type ],\n            props = jQuery.event.props;\n\n        if ( props.length ) {\n            migrateWarn( \"jQuery.event.props are deprecated and removed: \" + props.join() );\n            while ( props.length ) {\n                jQuery.event.addProp( props.pop() );\n            }\n        }\n\n        if ( fixHook && !fixHook._migrated_ ) {\n            fixHook._migrated_ = true;\n            migrateWarn( \"jQuery.event.fixHooks are deprecated and removed: \" + type );\n            if ( ( props = fixHook.props ) && props.length ) {\n                while ( props.length ) {\n                    jQuery.event.addProp( props.pop() );\n                }\n            }\n        }\n\n        event = originalFix.call( this, originalEvent );\n\n        return fixHook && fixHook.filter ? fixHook.filter( event, originalEvent ) : event;\n    };\n\n    jQuery.event.add = function( elem, types ) {\n\n        // This misses the multiple-types case but that seems awfully rare\n        if ( elem === window && types === \"load\" && window.document.readyState === \"complete\" ) {\n            migrateWarn( \"jQuery(window).on('load'...) called after load event occurred\" );\n        }\n        return oldEventAdd.apply( this, arguments );\n    };\n\n    jQuery.each( [ \"load\", \"unload\", \"error\" ], function( _, name ) {\n\n        jQuery.fn[ name ] = function() {\n            var args = Array.prototype.slice.call( arguments, 0 );\n\n            // If this is an ajax load() the first arg should be the string URL;\n            // technically this could also be the \"Anything\" arg of the event .load()\n            // which just goes to show why this dumb signature has been deprecated!\n            // jQuery custom builds that exclude the Ajax module justifiably die here.\n            if ( name === \"load\" && typeof args[ 0 ] === \"string\" ) {\n                return oldLoad.apply( this, args );\n            }\n\n            migrateWarn( \"jQuery.fn.\" + name + \"() is deprecated\" );\n\n            args.splice( 0, 0, name );\n            if ( arguments.length ) {\n                return this.on.apply( this, args );\n            }\n\n            // Use .triggerHandler here because:\n            // - load and unload events don't need to bubble, only applied to window or image\n            // - error event should not bubble to window, although it does pre-1.7\n            // See http://bugs.jquery.com/ticket/11820\n            this.triggerHandler.apply( this, args );\n            return this;\n        };\n\n    } );\n\n    jQuery.each( ( \"blur focus focusin focusout resize scroll click dblclick \" +\n            \"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave \" +\n            \"change select submit keydown keypress keyup contextmenu\" ).split( \" \" ),\n        function( _i, name ) {\n\n            // Handle event binding\n            jQuery.fn[ name ] = function( data, fn ) {\n                migrateWarn( \"jQuery.fn.\" + name + \"() event shorthand is deprecated\" );\n                return arguments.length > 0 ?\n                    this.on( name, null, data, fn ) :\n                    this.trigger( name );\n            };\n        } );\n\n// Trigger \"ready\" event only once, on document ready\n    jQuery( function() {\n        jQuery( window.document ).triggerHandler( \"ready\" );\n    } );\n\n    jQuery.event.special.ready = {\n        setup: function() {\n            if ( this === window.document ) {\n                migrateWarn( \"'ready' event is deprecated\" );\n            }\n        }\n    };\n\n    jQuery.fn.extend( {\n\n        bind: function( types, data, fn ) {\n            migrateWarn( \"jQuery.fn.bind() is deprecated\" );\n            return this.on( types, null, data, fn );\n        },\n        unbind: function( types, fn ) {\n            migrateWarn( \"jQuery.fn.unbind() is deprecated\" );\n            return this.off( types, null, fn );\n        },\n        delegate: function( selector, types, data, fn ) {\n            migrateWarn( \"jQuery.fn.delegate() is deprecated\" );\n            return this.on( types, selector, data, fn );\n        },\n        undelegate: function( selector, types, fn ) {\n            migrateWarn( \"jQuery.fn.undelegate() is deprecated\" );\n            return arguments.length === 1 ?\n                this.off( selector, \"**\" ) :\n                this.off( types, selector || \"**\", fn );\n        },\n        hover: function( fnOver, fnOut ) {\n            migrateWarn( \"jQuery.fn.hover() is deprecated\" );\n            return this.on( \"mouseenter\", fnOver ).on( \"mouseleave\", fnOut || fnOver );\n        }\n    } );\n\n    var rxhtmlTag = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\\/\\0>\\x20\\t\\r\\n\\f]*)[^>]*)\\/>/gi,\n        origHtmlPrefilter = jQuery.htmlPrefilter,\n        makeMarkup = function( html ) {\n            var doc = window.document.implementation.createHTMLDocument( \"\" );\n            doc.body.innerHTML = html;\n            return doc.body && doc.body.innerHTML;\n        },\n        warnIfChanged = function( html ) {\n            var changed = html.replace( rxhtmlTag, \"<$1></$2>\" );\n            if ( changed !== html && makeMarkup( html ) !== makeMarkup( changed ) ) {\n                migrateWarn( \"HTML tags must be properly nested and closed: \" + html );\n            }\n        };\n\n    jQuery.UNSAFE_restoreLegacyHtmlPrefilter = function() {\n        jQuery.htmlPrefilter = function( html ) {\n            warnIfChanged( html );\n            return html.replace( rxhtmlTag, \"<$1></$2>\" );\n        };\n    };\n\n    jQuery.htmlPrefilter = function( html ) {\n        warnIfChanged( html );\n        return origHtmlPrefilter( html );\n    };\n\n    var oldOffset = jQuery.fn.offset;\n\n    jQuery.fn.offset = function() {\n        var elem = this[ 0 ];\n\n        if ( elem && ( !elem.nodeType || !elem.getBoundingClientRect ) ) {\n            migrateWarn( \"jQuery.fn.offset() requires a valid DOM element\" );\n            return arguments.length ? this : undefined;\n        }\n\n        return oldOffset.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the ajax module\n// The jQuery.param patch is about respecting `jQuery.ajaxSettings.traditional`\n// so it doesn't make sense for the slim build.\n    if ( jQuery.ajax ) {\n\n        var oldParam = jQuery.param;\n\n        jQuery.param = function( data, traditional ) {\n            var ajaxTraditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;\n\n            if ( traditional === undefined && ajaxTraditional ) {\n\n                migrateWarn( \"jQuery.param() no longer uses jQuery.ajaxSettings.traditional\" );\n                traditional = ajaxTraditional;\n            }\n\n            return oldParam.call( this, data, traditional );\n        };\n\n    }\n\n    var oldSelf = jQuery.fn.andSelf || jQuery.fn.addBack;\n\n    jQuery.fn.andSelf = function() {\n        migrateWarn( \"jQuery.fn.andSelf() is deprecated and removed, use jQuery.fn.addBack()\" );\n        return oldSelf.apply( this, arguments );\n    };\n\n// Support jQuery slim which excludes the deferred module in jQuery 4.0+\n    if ( jQuery.Deferred ) {\n\n        var oldDeferred = jQuery.Deferred,\n            tuples = [\n\n                // Action, add listener, callbacks, .then handlers, final state\n                [ \"resolve\", \"done\", jQuery.Callbacks( \"once memory\" ),\n                    jQuery.Callbacks( \"once memory\" ), \"resolved\" ],\n                [ \"reject\", \"fail\", jQuery.Callbacks( \"once memory\" ),\n                    jQuery.Callbacks( \"once memory\" ), \"rejected\" ],\n                [ \"notify\", \"progress\", jQuery.Callbacks( \"memory\" ),\n                    jQuery.Callbacks( \"memory\" ) ]\n            ];\n\n        jQuery.Deferred = function( func ) {\n            var deferred = oldDeferred(),\n                promise = deferred.promise();\n\n            deferred.pipe = promise.pipe = function( /* fnDone, fnFail, fnProgress */ ) {\n                var fns = arguments;\n\n                migrateWarn( \"deferred.pipe() is deprecated\" );\n\n                return jQuery.Deferred( function( newDefer ) {\n                    jQuery.each( tuples, function( i, tuple ) {\n                        var fn = typeof fns[ i ] === \"function\" && fns[ i ];\n\n                        // Deferred.done(function() { bind to newDefer or newDefer.resolve })\n                        // deferred.fail(function() { bind to newDefer or newDefer.reject })\n                        // deferred.progress(function() { bind to newDefer or newDefer.notify })\n                        deferred[ tuple[ 1 ] ]( function() {\n                            var returned = fn && fn.apply( this, arguments );\n                            if ( returned && typeof returned.promise === \"function\" ) {\n                                returned.promise()\n                                    .done( newDefer.resolve )\n                                    .fail( newDefer.reject )\n                                    .progress( newDefer.notify );\n                            } else {\n                                newDefer[ tuple[ 0 ] + \"With\" ](\n                                    this === promise ? newDefer.promise() : this,\n                                    fn ? [ returned ] : arguments\n                                );\n                            }\n                        } );\n                    } );\n                    fns = null;\n                } ).promise();\n\n            };\n\n            if ( func ) {\n                func.call( deferred, deferred );\n            }\n\n            return deferred;\n        };\n\n// Preserve handler of uncaught exceptions in promise chains\n        jQuery.Deferred.exceptionHook = oldDeferred.exceptionHook;\n\n    }\n\n    return jQuery;\n} );\n","jquery/timepicker.js":"/*! jQuery Timepicker Addon - v1.6.3 - 2016-04-20\n* http://trentrichardson.com/examples/timepicker\n* Copyright (c) 2016 Trent Richardson; Licensed MIT */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery', 'jquery-ui-modules/datepicker', 'jquery-ui-modules/slider'], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n    /*\n    * Lets not redefine timepicker, Prevent \"Uncaught RangeError: Maximum call stack size exceeded\"\n    */\n    $.ui.timepicker = $.ui.timepicker || {};\n    if ($.ui.timepicker.version) {\n        return;\n    }\n\n    /*\n    * Extend jQueryUI, get it started with our version number\n    */\n    $.extend($.ui, {\n        timepicker: {\n            version: \"1.6.3\"\n        }\n    });\n\n    /*\n    * Timepicker manager.\n    * Use the singleton instance of this class, $.timepicker, to interact with the time picker.\n    * Settings for (groups of) time pickers are maintained in an instance object,\n    * allowing multiple different settings on the same page.\n    */\n    var Timepicker = function () {\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[''] = { // Default regional settings\n            currentText: 'Now',\n            closeText: 'Done',\n            amNames: ['AM', 'A'],\n            pmNames: ['PM', 'P'],\n            timeFormat: 'HH:mm',\n            timeSuffix: '',\n            timeOnlyTitle: 'Choose Time',\n            timeText: 'Time',\n            hourText: 'Hour',\n            minuteText: 'Minute',\n            secondText: 'Second',\n            millisecText: 'Millisecond',\n            microsecText: 'Microsecond',\n            timezoneText: 'Time Zone',\n            isRTL: false\n        };\n        this._defaults = { // Global defaults for all the datetime picker instances\n            showButtonPanel: true,\n            timeOnly: false,\n            timeOnlyShowDate: false,\n            showHour: null,\n            showMinute: null,\n            showSecond: null,\n            showMillisec: null,\n            showMicrosec: null,\n            showTimezone: null,\n            showTime: true,\n            stepHour: 1,\n            stepMinute: 1,\n            stepSecond: 1,\n            stepMillisec: 1,\n            stepMicrosec: 1,\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null,\n            hourMin: 0,\n            minuteMin: 0,\n            secondMin: 0,\n            millisecMin: 0,\n            microsecMin: 0,\n            hourMax: 23,\n            minuteMax: 59,\n            secondMax: 59,\n            millisecMax: 999,\n            microsecMax: 999,\n            minDateTime: null,\n            maxDateTime: null,\n            maxTime: null,\n            minTime: null,\n            onSelect: null,\n            hourGrid: 0,\n            minuteGrid: 0,\n            secondGrid: 0,\n            millisecGrid: 0,\n            microsecGrid: 0,\n            alwaysSetTime: true,\n            separator: ' ',\n            altFieldTimeOnly: true,\n            altTimeFormat: null,\n            altSeparator: null,\n            altTimeSuffix: null,\n            altRedirectFocus: true,\n            pickerTimeFormat: null,\n            pickerTimeSuffix: null,\n            showTimepicker: true,\n            timezoneList: null,\n            addSliderAccess: false,\n            sliderAccessArgs: null,\n            controlType: 'slider',\n            oneLine: false,\n            defaultValue: null,\n            parse: 'strict',\n            afterInject: null\n        };\n        $.extend(this._defaults, this.regional['']);\n    };\n\n    $.extend(Timepicker.prototype, {\n        $input: null,\n        $altInput: null,\n        $timeObj: null,\n        inst: null,\n        hour_slider: null,\n        minute_slider: null,\n        second_slider: null,\n        millisec_slider: null,\n        microsec_slider: null,\n        timezone_select: null,\n        maxTime: null,\n        minTime: null,\n        hour: 0,\n        minute: 0,\n        second: 0,\n        millisec: 0,\n        microsec: 0,\n        timezone: null,\n        hourMinOriginal: null,\n        minuteMinOriginal: null,\n        secondMinOriginal: null,\n        millisecMinOriginal: null,\n        microsecMinOriginal: null,\n        hourMaxOriginal: null,\n        minuteMaxOriginal: null,\n        secondMaxOriginal: null,\n        millisecMaxOriginal: null,\n        microsecMaxOriginal: null,\n        ampm: '',\n        formattedDate: '',\n        formattedTime: '',\n        formattedDateTime: '',\n        timezoneList: null,\n        units: ['hour', 'minute', 'second', 'millisec', 'microsec'],\n        support: {},\n        control: null,\n\n        /*\n        * Override the default settings for all instances of the time picker.\n        * @param  {Object} settings  object - the new settings to use as defaults (anonymous object)\n        * @return {Object} the manager object\n        */\n        setDefaults: function (settings) {\n            extendRemove(this._defaults, settings || {});\n            return this;\n        },\n\n        /*\n        * Create a new Timepicker instance\n        */\n        _newInst: function ($input, opts) {\n            var tp_inst = new Timepicker(),\n                inlineSettings = {},\n                fns = {},\n                overrides, i;\n\n            for (var attrName in this._defaults) {\n                if (this._defaults.hasOwnProperty(attrName)) {\n                    var attrValue = $input.attr('time:' + attrName);\n                    if (attrValue) {\n                        try {\n                            inlineSettings[attrName] = eval(attrValue);\n                        } catch (err) {\n                            inlineSettings[attrName] = attrValue;\n                        }\n                    }\n                }\n            }\n\n            overrides = {\n                beforeShow: function (input, dp_inst) {\n                    if ($.isFunction(tp_inst._defaults.evnts.beforeShow)) {\n                        return tp_inst._defaults.evnts.beforeShow.call($input[0], input, dp_inst, tp_inst);\n                    }\n                },\n                onChangeMonthYear: function (year, month, dp_inst) {\n                    // Update the time as well : this prevents the time from disappearing from the $input field.\n                    // tp_inst._updateDateTime(dp_inst);\n                    if ($.isFunction(tp_inst._defaults.evnts.onChangeMonthYear)) {\n                        tp_inst._defaults.evnts.onChangeMonthYear.call($input[0], year, month, dp_inst, tp_inst);\n                    }\n                },\n                onClose: function (dateText, dp_inst) {\n                    if (tp_inst.timeDefined === true && $input.val() !== '') {\n                        tp_inst._updateDateTime(dp_inst);\n                    }\n                    if ($.isFunction(tp_inst._defaults.evnts.onClose)) {\n                        tp_inst._defaults.evnts.onClose.call($input[0], dateText, dp_inst, tp_inst);\n                    }\n                }\n            };\n            for (i in overrides) {\n                if (overrides.hasOwnProperty(i)) {\n                    fns[i] = opts[i] || this._defaults[i] || null;\n                }\n            }\n\n            tp_inst._defaults = $.extend({}, this._defaults, inlineSettings, opts, overrides, {\n                evnts: fns,\n                timepicker: tp_inst // add timepicker as a property of datepicker: $.datepicker._get(dp_inst, 'timepicker');\n            });\n            tp_inst.amNames = $.map(tp_inst._defaults.amNames, function (val) {\n                return val.toUpperCase();\n            });\n            tp_inst.pmNames = $.map(tp_inst._defaults.pmNames, function (val) {\n                return val.toUpperCase();\n            });\n\n            // detect which units are supported\n            tp_inst.support = detectSupport(\n                tp_inst._defaults.timeFormat +\n                (tp_inst._defaults.pickerTimeFormat ? tp_inst._defaults.pickerTimeFormat : '') +\n                (tp_inst._defaults.altTimeFormat ? tp_inst._defaults.altTimeFormat : ''));\n\n            // controlType is string - key to our this._controls\n            if (typeof(tp_inst._defaults.controlType) === 'string') {\n                if (tp_inst._defaults.controlType === 'slider' && typeof($.ui.slider) === 'undefined') {\n                    tp_inst._defaults.controlType = 'select';\n                }\n                tp_inst.control = tp_inst._controls[tp_inst._defaults.controlType];\n            }\n            // controlType is an object and must implement create, options, value methods\n            else {\n                tp_inst.control = tp_inst._defaults.controlType;\n            }\n\n            // prep the timezone options\n            var timezoneList = [-720, -660, -600, -570, -540, -480, -420, -360, -300, -270, -240, -210, -180, -120, -60,\n                0, 60, 120, 180, 210, 240, 270, 300, 330, 345, 360, 390, 420, 480, 525, 540, 570, 600, 630, 660, 690, 720, 765, 780, 840];\n            if (tp_inst._defaults.timezoneList !== null) {\n                timezoneList = tp_inst._defaults.timezoneList;\n            }\n            var tzl = timezoneList.length, tzi = 0, tzv = null;\n            if (tzl > 0 && typeof timezoneList[0] !== 'object') {\n                for (; tzi < tzl; tzi++) {\n                    tzv = timezoneList[tzi];\n                    timezoneList[tzi] = { value: tzv, label: $.timepicker.timezoneOffsetString(tzv, tp_inst.support.iso8601) };\n                }\n            }\n            tp_inst._defaults.timezoneList = timezoneList;\n\n            // set the default units\n            tp_inst.timezone = tp_inst._defaults.timezone !== null ? $.timepicker.timezoneOffsetNumber(tp_inst._defaults.timezone) :\n                ((new Date()).getTimezoneOffset() * -1);\n            tp_inst.hour = tp_inst._defaults.hour < tp_inst._defaults.hourMin ? tp_inst._defaults.hourMin :\n                tp_inst._defaults.hour > tp_inst._defaults.hourMax ? tp_inst._defaults.hourMax : tp_inst._defaults.hour;\n            tp_inst.minute = tp_inst._defaults.minute < tp_inst._defaults.minuteMin ? tp_inst._defaults.minuteMin :\n                tp_inst._defaults.minute > tp_inst._defaults.minuteMax ? tp_inst._defaults.minuteMax : tp_inst._defaults.minute;\n            tp_inst.second = tp_inst._defaults.second < tp_inst._defaults.secondMin ? tp_inst._defaults.secondMin :\n                tp_inst._defaults.second > tp_inst._defaults.secondMax ? tp_inst._defaults.secondMax : tp_inst._defaults.second;\n            tp_inst.millisec = tp_inst._defaults.millisec < tp_inst._defaults.millisecMin ? tp_inst._defaults.millisecMin :\n                tp_inst._defaults.millisec > tp_inst._defaults.millisecMax ? tp_inst._defaults.millisecMax : tp_inst._defaults.millisec;\n            tp_inst.microsec = tp_inst._defaults.microsec < tp_inst._defaults.microsecMin ? tp_inst._defaults.microsecMin :\n                tp_inst._defaults.microsec > tp_inst._defaults.microsecMax ? tp_inst._defaults.microsecMax : tp_inst._defaults.microsec;\n            tp_inst.ampm = '';\n            tp_inst.$input = $input;\n\n            if (tp_inst._defaults.altField) {\n                tp_inst.$altInput = $(tp_inst._defaults.altField);\n                if (tp_inst._defaults.altRedirectFocus === true) {\n                    tp_inst.$altInput.css({\n                        cursor: 'pointer'\n                    }).focus(function () {\n                        $input.trigger(\"focus\");\n                    });\n                }\n            }\n\n            if (tp_inst._defaults.minDate === 0 || tp_inst._defaults.minDateTime === 0) {\n                tp_inst._defaults.minDate = new Date();\n            }\n            if (tp_inst._defaults.maxDate === 0 || tp_inst._defaults.maxDateTime === 0) {\n                tp_inst._defaults.maxDate = new Date();\n            }\n\n            // datepicker needs minDate/maxDate, timepicker needs minDateTime/maxDateTime..\n            if (tp_inst._defaults.minDate !== undefined && tp_inst._defaults.minDate instanceof Date) {\n                tp_inst._defaults.minDateTime = new Date(tp_inst._defaults.minDate.getTime());\n            }\n            if (tp_inst._defaults.minDateTime !== undefined && tp_inst._defaults.minDateTime instanceof Date) {\n                tp_inst._defaults.minDate = new Date(tp_inst._defaults.minDateTime.getTime());\n            }\n            if (tp_inst._defaults.maxDate !== undefined && tp_inst._defaults.maxDate instanceof Date) {\n                tp_inst._defaults.maxDateTime = new Date(tp_inst._defaults.maxDate.getTime());\n            }\n            if (tp_inst._defaults.maxDateTime !== undefined && tp_inst._defaults.maxDateTime instanceof Date) {\n                tp_inst._defaults.maxDate = new Date(tp_inst._defaults.maxDateTime.getTime());\n            }\n            tp_inst.$input.bind('focus', function () {\n                tp_inst._onFocus();\n            });\n\n            return tp_inst;\n        },\n\n        /*\n        * add our sliders to the calendar\n        */\n        _addTimePicker: function (dp_inst) {\n            var currDT = $.trim((this.$altInput && this._defaults.altFieldTimeOnly) ? this.$input.val() + ' ' + this.$altInput.val() : this.$input.val());\n\n            this.timeDefined = this._parseTime(currDT);\n            this._limitMinMaxDateTime(dp_inst, false);\n            this._injectTimePicker();\n            this._afterInject();\n        },\n\n        /*\n        * parse the time string from input value or _setTime\n        */\n        _parseTime: function (timeString, withDate) {\n            if (!this.inst) {\n                this.inst = $.datepicker._getInst(this.$input[0]);\n            }\n\n            if (withDate || !this._defaults.timeOnly) {\n                var dp_dateFormat = $.datepicker._get(this.inst, 'dateFormat');\n                try {\n                    var parseRes = parseDateTimeInternal(dp_dateFormat, this._defaults.timeFormat, timeString, $.datepicker._getFormatConfig(this.inst), this._defaults);\n                    if (!parseRes.timeObj) {\n                        return false;\n                    }\n                    $.extend(this, parseRes.timeObj);\n                } catch (err) {\n                    $.timepicker.log(\"Error parsing the date/time string: \" + err +\n                        \"\\ndate/time string = \" + timeString +\n                        \"\\ntimeFormat = \" + this._defaults.timeFormat +\n                        \"\\ndateFormat = \" + dp_dateFormat);\n                    return false;\n                }\n                return true;\n            } else {\n                var timeObj = $.datepicker.parseTime(this._defaults.timeFormat, timeString, this._defaults);\n                if (!timeObj) {\n                    return false;\n                }\n                $.extend(this, timeObj);\n                return true;\n            }\n        },\n\n        /*\n        * Handle callback option after injecting timepicker\n        */\n        _afterInject: function() {\n            var o = this.inst.settings;\n            if ($.isFunction(o.afterInject)) {\n                o.afterInject.call(this);\n            }\n        },\n\n        /*\n        * generate and inject html for timepicker into ui datepicker\n        */\n        _injectTimePicker: function () {\n            var $dp = this.inst.dpDiv,\n                o = this.inst.settings,\n                tp_inst = this,\n                litem = '',\n                uitem = '',\n                show = null,\n                max = {},\n                gridSize = {},\n                size = null,\n                i = 0,\n                l = 0;\n\n            // Prevent displaying twice\n            if ($dp.find(\"div.ui-timepicker-div\").length === 0 && o.showTimepicker) {\n                var noDisplay = ' ui_tpicker_unit_hide',\n                    html = '<div class=\"ui-timepicker-div' + (o.isRTL ? ' ui-timepicker-rtl' : '') + (o.oneLine && o.controlType === 'select' ? ' ui-timepicker-oneLine' : '') + '\"><dl>' + '<dt class=\"ui_tpicker_time_label' + ((o.showTime) ? '' : noDisplay) + '\">' + o.timeText + '</dt>' +\n                        '<dd class=\"ui_tpicker_time '+ ((o.showTime) ? '' : noDisplay) + '\"><input class=\"ui_tpicker_time_input\" ' + (o.timeInput ? '' : 'disabled') + '/></dd>';\n\n                // Create the markup\n                for (i = 0, l = this.units.length; i < l; i++) {\n                    litem = this.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // Added by Peter Medeiros:\n                    // - Figure out what the hour/minute/second max should be based on the step values.\n                    // - Example: if stepMinute is 15, then minMax is 45.\n                    max[litem] = parseInt((o[litem + 'Max'] - ((o[litem + 'Max'] - o[litem + 'Min']) % o['step' + uitem])), 10);\n                    gridSize[litem] = 0;\n\n                    html += '<dt class=\"ui_tpicker_' + litem + '_label' + (show ? '' : noDisplay) + '\">' + o[litem + 'Text'] + '</dt>' +\n                        '<dd class=\"ui_tpicker_' + litem + (show ? '' : noDisplay) + '\"><div class=\"ui_tpicker_' + litem + '_slider' + (show ? '' : noDisplay) + '\"></div>';\n\n                    if (show && o[litem + 'Grid'] > 0) {\n                        html += '<div style=\"padding-left: 1px\"><table class=\"ui-tpicker-grid-label\"><tr>';\n\n                        if (litem === 'hour') {\n                            for (var h = o[litem + 'Min']; h <= max[litem]; h += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                var tmph = $.datepicker.formatTime(this.support.ampm ? 'hht' : 'HH', {hour: h}, o);\n                                html += '<td data-for=\"' + litem + '\">' + tmph + '</td>';\n                            }\n                        }\n                        else {\n                            for (var m = o[litem + 'Min']; m <= max[litem]; m += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                html += '<td data-for=\"' + litem + '\">' + ((m < 10) ? '0' : '') + m + '</td>';\n                            }\n                        }\n\n                        html += '</tr></table></div>';\n                    }\n                    html += '</dd>';\n                }\n\n                // Timezone\n                var showTz = o.showTimezone !== null ? o.showTimezone : this.support.timezone;\n                html += '<dt class=\"ui_tpicker_timezone_label' + (showTz ? '' : noDisplay) + '\">' + o.timezoneText + '</dt>';\n                html += '<dd class=\"ui_tpicker_timezone' + (showTz ? '' : noDisplay) + '\"></dd>';\n\n                // Create the elements from string\n                html += '</dl></div>';\n                var $tp = $(html);\n\n                // if we only want time picker...\n                if (o.timeOnly === true) {\n                    $tp.prepend('<div class=\"ui-widget-header ui-helper-clearfix ui-corner-all\">' + '<div class=\"ui-datepicker-title\">' + o.timeOnlyTitle + '</div>' + '</div>');\n                    $dp.find('.ui-datepicker-header, .ui-datepicker-calendar').hide();\n                }\n\n                // add sliders, adjust grids, add events\n                for (i = 0, l = tp_inst.units.length; i < l; i++) {\n                    litem = tp_inst.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // add the slider\n                    tp_inst[litem + '_slider'] = tp_inst.control.create(tp_inst, $tp.find('.ui_tpicker_' + litem + '_slider'), litem, tp_inst[litem], o[litem + 'Min'], max[litem], o['step' + uitem]);\n\n                    // adjust the grid and add click event\n                    if (show && o[litem + 'Grid'] > 0) {\n                        size = 100 * gridSize[litem] * o[litem + 'Grid'] / (max[litem] - o[litem + 'Min']);\n                        $tp.find('.ui_tpicker_' + litem + ' table').css({\n                            width: size + \"%\",\n                            marginLeft: o.isRTL ? '0' : ((size / (-2 * gridSize[litem])) + \"%\"),\n                            marginRight: o.isRTL ? ((size / (-2 * gridSize[litem])) + \"%\") : '0',\n                            borderCollapse: 'collapse'\n                        }).find(\"td\").click(function (e) {\n                            var $t = $(this),\n                                h = $t.html(),\n                                n = parseInt(h.replace(/[^0-9]/g), 10),\n                                ap = h.replace(/[^apm]/ig),\n                                f = $t.data('for'); // loses scope, so we use data-for\n\n                            if (f === 'hour') {\n                                if (ap.indexOf('p') !== -1 && n < 12) {\n                                    n += 12;\n                                }\n                                else {\n                                    if (ap.indexOf('a') !== -1 && n === 12) {\n                                        n = 0;\n                                    }\n                                }\n                            }\n\n                            tp_inst.control.value(tp_inst, tp_inst[f + '_slider'], litem, n);\n\n                            tp_inst._onTimeChange();\n                            tp_inst._onSelectHandler();\n                        }).css({\n                            cursor: 'pointer',\n                            width: (100 / gridSize[litem]) + '%',\n                            textAlign: 'center',\n                            overflow: 'hidden'\n                        });\n                    } // end if grid > 0\n                } // end for loop\n\n                // Add timezone options\n                this.timezone_select = $tp.find('.ui_tpicker_timezone').append('<select></select>').find(\"select\");\n                $.fn.append.apply(this.timezone_select,\n                    $.map(o.timezoneList, function (val, idx) {\n                        return $(\"<option />\").val(typeof val === \"object\" ? val.value : val).text(typeof val === \"object\" ? val.label : val);\n                    }));\n                if (typeof(this.timezone) !== \"undefined\" && this.timezone !== null && this.timezone !== \"\") {\n                    var local_timezone = (new Date(this.inst.selectedYear, this.inst.selectedMonth, this.inst.selectedDay, 12)).getTimezoneOffset() * -1;\n                    if (local_timezone === this.timezone) {\n                        selectLocalTimezone(tp_inst);\n                    } else {\n                        this.timezone_select.val(this.timezone);\n                    }\n                } else {\n                    if (typeof(this.hour) !== \"undefined\" && this.hour !== null && this.hour !== \"\") {\n                        this.timezone_select.val(o.timezone);\n                    } else {\n                        selectLocalTimezone(tp_inst);\n                    }\n                }\n                this.timezone_select.change(function () {\n                    tp_inst._onTimeChange();\n                    tp_inst._onSelectHandler();\n                    tp_inst._afterInject();\n                });\n                // End timezone options\n\n                // inject timepicker into datepicker\n                var $buttonPanel = $dp.find('.ui-datepicker-buttonpane');\n                if ($buttonPanel.length) {\n                    $buttonPanel.before($tp);\n                } else {\n                    $dp.append($tp);\n                }\n\n                this.$timeObj = $tp.find('.ui_tpicker_time_input');\n                this.$timeObj.change(function () {\n                    var timeFormat = tp_inst.inst.settings.timeFormat;\n                    var parsedTime = $.datepicker.parseTime(timeFormat, this.value);\n                    var update = new Date();\n                    if (parsedTime) {\n                        update.setHours(parsedTime.hour);\n                        update.setMinutes(parsedTime.minute);\n                        update.setSeconds(parsedTime.second);\n                        $.datepicker._setTime(tp_inst.inst, update);\n                    } else {\n                        this.value = tp_inst.formattedTime;\n                        this.blur();\n                    }\n                });\n\n                if (this.inst !== null) {\n                    var timeDefined = this.timeDefined;\n                    this._onTimeChange();\n                    this.timeDefined = timeDefined;\n                }\n\n                // slideAccess integration: http://trentrichardson.com/2011/11/11/jquery-ui-sliders-and-touch-accessibility/\n                if (this._defaults.addSliderAccess) {\n                    var sliderAccessArgs = this._defaults.sliderAccessArgs,\n                        rtl = this._defaults.isRTL;\n                    sliderAccessArgs.isRTL = rtl;\n\n                    setTimeout(function () { // fix for inline mode\n                        if ($tp.find('.ui-slider-access').length === 0) {\n                            $tp.find('.ui-slider:visible').sliderAccess(sliderAccessArgs);\n\n                            // fix any grids since sliders are shorter\n                            var sliderAccessWidth = $tp.find('.ui-slider-access:eq(0)').outerWidth(true);\n                            if (sliderAccessWidth) {\n                                $tp.find('table:visible').each(function () {\n                                    var $g = $(this),\n                                        oldWidth = $g.outerWidth(),\n                                        oldMarginLeft = $g.css(rtl ? 'marginRight' : 'marginLeft').toString().replace('%', ''),\n                                        newWidth = oldWidth - sliderAccessWidth,\n                                        newMarginLeft = ((oldMarginLeft * newWidth) / oldWidth) + '%',\n                                        css = { width: newWidth, marginRight: 0, marginLeft: 0 };\n                                    css[rtl ? 'marginRight' : 'marginLeft'] = newMarginLeft;\n                                    $g.css(css);\n                                });\n                            }\n                        }\n                    }, 10);\n                }\n                // end slideAccess integration\n\n                tp_inst._limitMinMaxDateTime(this.inst, true);\n            }\n        },\n\n        /*\n        * This function tries to limit the ability to go outside the\n        * min/max date range\n        */\n        _limitMinMaxDateTime: function (dp_inst, adjustSliders) {\n            var o = this._defaults,\n                dp_date = new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay);\n\n            if (!this._defaults.showTimepicker) {\n                return;\n            } // No time so nothing to check here\n\n            if ($.datepicker._get(dp_inst, 'minDateTime') !== null && $.datepicker._get(dp_inst, 'minDateTime') !== undefined && dp_date) {\n                var minDateTime = $.datepicker._get(dp_inst, 'minDateTime'),\n                    minDateTimeDate = new Date(minDateTime.getFullYear(), minDateTime.getMonth(), minDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMinOriginal === null || this.minuteMinOriginal === null || this.secondMinOriginal === null || this.millisecMinOriginal === null || this.microsecMinOriginal === null) {\n                    this.hourMinOriginal = o.hourMin;\n                    this.minuteMinOriginal = o.minuteMin;\n                    this.secondMinOriginal = o.secondMin;\n                    this.millisecMinOriginal = o.millisecMin;\n                    this.microsecMinOriginal = o.microsecMin;\n                }\n\n                if (dp_inst.settings.timeOnly || minDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMin = minDateTime.getHours();\n                    if (this.hour <= this._defaults.hourMin) {\n                        this.hour = this._defaults.hourMin;\n                        this._defaults.minuteMin = minDateTime.getMinutes();\n                        if (this.minute <= this._defaults.minuteMin) {\n                            this.minute = this._defaults.minuteMin;\n                            this._defaults.secondMin = minDateTime.getSeconds();\n                            if (this.second <= this._defaults.secondMin) {\n                                this.second = this._defaults.secondMin;\n                                this._defaults.millisecMin = minDateTime.getMilliseconds();\n                                if (this.millisec <= this._defaults.millisecMin) {\n                                    this.millisec = this._defaults.millisecMin;\n                                    this._defaults.microsecMin = minDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec < this._defaults.microsecMin) {\n                                        this.microsec = this._defaults.microsecMin;\n                                    }\n                                    this._defaults.microsecMin = this.microsecMinOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMin = this.millisecMinOriginal;\n                                this._defaults.microsecMin = this.microsecMinOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMin = this.secondMinOriginal;\n                            this._defaults.millisecMin = this.millisecMinOriginal;\n                            this._defaults.microsecMin = this.microsecMinOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMin = this.minuteMinOriginal;\n                        this._defaults.secondMin = this.secondMinOriginal;\n                        this._defaults.millisecMin = this.millisecMinOriginal;\n                        this._defaults.microsecMin = this.microsecMinOriginal;\n                    }\n                } else {\n                    this._defaults.hourMin = this.hourMinOriginal;\n                    this._defaults.minuteMin = this.minuteMinOriginal;\n                    this._defaults.secondMin = this.secondMinOriginal;\n                    this._defaults.millisecMin = this.millisecMinOriginal;\n                    this._defaults.microsecMin = this.microsecMinOriginal;\n                }\n            }\n\n            if ($.datepicker._get(dp_inst, 'maxDateTime') !== null && $.datepicker._get(dp_inst, 'maxDateTime') !== undefined && dp_date) {\n                var maxDateTime = $.datepicker._get(dp_inst, 'maxDateTime'),\n                    maxDateTimeDate = new Date(maxDateTime.getFullYear(), maxDateTime.getMonth(), maxDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMaxOriginal === null || this.minuteMaxOriginal === null || this.secondMaxOriginal === null || this.millisecMaxOriginal === null) {\n                    this.hourMaxOriginal = o.hourMax;\n                    this.minuteMaxOriginal = o.minuteMax;\n                    this.secondMaxOriginal = o.secondMax;\n                    this.millisecMaxOriginal = o.millisecMax;\n                    this.microsecMaxOriginal = o.microsecMax;\n                }\n\n                if (dp_inst.settings.timeOnly || maxDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMax = maxDateTime.getHours();\n                    if (this.hour >= this._defaults.hourMax) {\n                        this.hour = this._defaults.hourMax;\n                        this._defaults.minuteMax = maxDateTime.getMinutes();\n                        if (this.minute >= this._defaults.minuteMax) {\n                            this.minute = this._defaults.minuteMax;\n                            this._defaults.secondMax = maxDateTime.getSeconds();\n                            if (this.second >= this._defaults.secondMax) {\n                                this.second = this._defaults.secondMax;\n                                this._defaults.millisecMax = maxDateTime.getMilliseconds();\n                                if (this.millisec >= this._defaults.millisecMax) {\n                                    this.millisec = this._defaults.millisecMax;\n                                    this._defaults.microsecMax = maxDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec > this._defaults.microsecMax) {\n                                        this.microsec = this._defaults.microsecMax;\n                                    }\n                                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMax = this.millisecMaxOriginal;\n                                this._defaults.microsecMax = this.microsecMaxOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMax = this.secondMaxOriginal;\n                            this._defaults.millisecMax = this.millisecMaxOriginal;\n                            this._defaults.microsecMax = this.microsecMaxOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMax = this.minuteMaxOriginal;\n                        this._defaults.secondMax = this.secondMaxOriginal;\n                        this._defaults.millisecMax = this.millisecMaxOriginal;\n                        this._defaults.microsecMax = this.microsecMaxOriginal;\n                    }\n                } else {\n                    this._defaults.hourMax = this.hourMaxOriginal;\n                    this._defaults.minuteMax = this.minuteMaxOriginal;\n                    this._defaults.secondMax = this.secondMaxOriginal;\n                    this._defaults.millisecMax = this.millisecMaxOriginal;\n                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                }\n            }\n\n            if (dp_inst.settings.minTime!==null) {\n                var tempMinTime=new Date(\"01/01/1970 \" + dp_inst.settings.minTime);\n                if (this.hour<tempMinTime.getHours()) {\n                    this.hour=this._defaults.hourMin=tempMinTime.getHours();\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else if (this.hour===tempMinTime.getHours() && this.minute<tempMinTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMin<tempMinTime.getHours()) {\n                        this._defaults.hourMin=tempMinTime.getHours();\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else if (this._defaults.hourMin===tempMinTime.getHours()===this.hour && this._defaults.minuteMin<tempMinTime.getMinutes()) {\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMin=0;\n                    }\n                }\n            }\n\n            if (dp_inst.settings.maxTime!==null) {\n                var tempMaxTime=new Date(\"01/01/1970 \" + dp_inst.settings.maxTime);\n                if (this.hour>tempMaxTime.getHours()) {\n                    this.hour=this._defaults.hourMax=tempMaxTime.getHours();\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else if (this.hour===tempMaxTime.getHours() && this.minute>tempMaxTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMax>tempMaxTime.getHours()) {\n                        this._defaults.hourMax=tempMaxTime.getHours();\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else if (this._defaults.hourMax===tempMaxTime.getHours()===this.hour && this._defaults.minuteMax>tempMaxTime.getMinutes()) {\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMax=59;\n                    }\n                }\n            }\n\n            if (adjustSliders !== undefined && adjustSliders === true) {\n                var hourMax = parseInt((this._defaults.hourMax - ((this._defaults.hourMax - this._defaults.hourMin) % this._defaults.stepHour)), 10),\n                    minMax = parseInt((this._defaults.minuteMax - ((this._defaults.minuteMax - this._defaults.minuteMin) % this._defaults.stepMinute)), 10),\n                    secMax = parseInt((this._defaults.secondMax - ((this._defaults.secondMax - this._defaults.secondMin) % this._defaults.stepSecond)), 10),\n                    millisecMax = parseInt((this._defaults.millisecMax - ((this._defaults.millisecMax - this._defaults.millisecMin) % this._defaults.stepMillisec)), 10),\n                    microsecMax = parseInt((this._defaults.microsecMax - ((this._defaults.microsecMax - this._defaults.microsecMin) % this._defaults.stepMicrosec)), 10);\n\n                if (this.hour_slider) {\n                    this.control.options(this, this.hour_slider, 'hour', { min: this._defaults.hourMin, max: hourMax, step: this._defaults.stepHour });\n                    this.control.value(this, this.hour_slider, 'hour', this.hour - (this.hour % this._defaults.stepHour));\n                }\n                if (this.minute_slider) {\n                    this.control.options(this, this.minute_slider, 'minute', { min: this._defaults.minuteMin, max: minMax, step: this._defaults.stepMinute });\n                    this.control.value(this, this.minute_slider, 'minute', this.minute - (this.minute % this._defaults.stepMinute));\n                }\n                if (this.second_slider) {\n                    this.control.options(this, this.second_slider, 'second', { min: this._defaults.secondMin, max: secMax, step: this._defaults.stepSecond });\n                    this.control.value(this, this.second_slider, 'second', this.second - (this.second % this._defaults.stepSecond));\n                }\n                if (this.millisec_slider) {\n                    this.control.options(this, this.millisec_slider, 'millisec', { min: this._defaults.millisecMin, max: millisecMax, step: this._defaults.stepMillisec });\n                    this.control.value(this, this.millisec_slider, 'millisec', this.millisec - (this.millisec % this._defaults.stepMillisec));\n                }\n                if (this.microsec_slider) {\n                    this.control.options(this, this.microsec_slider, 'microsec', { min: this._defaults.microsecMin, max: microsecMax, step: this._defaults.stepMicrosec });\n                    this.control.value(this, this.microsec_slider, 'microsec', this.microsec - (this.microsec % this._defaults.stepMicrosec));\n                }\n            }\n\n        },\n\n        /*\n        * when a slider moves, set the internal time...\n        * on time change is also called when the time is updated in the text field\n        */\n        _onTimeChange: function () {\n            if (!this._defaults.showTimepicker) {\n                return;\n            }\n            var hour = (this.hour_slider) ? this.control.value(this, this.hour_slider, 'hour') : false,\n                minute = (this.minute_slider) ? this.control.value(this, this.minute_slider, 'minute') : false,\n                second = (this.second_slider) ? this.control.value(this, this.second_slider, 'second') : false,\n                millisec = (this.millisec_slider) ? this.control.value(this, this.millisec_slider, 'millisec') : false,\n                microsec = (this.microsec_slider) ? this.control.value(this, this.microsec_slider, 'microsec') : false,\n                timezone = (this.timezone_select) ? this.timezone_select.val() : false,\n                o = this._defaults,\n                pickerTimeFormat = o.pickerTimeFormat || o.timeFormat,\n                pickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;\n\n            if (typeof(hour) === 'object') {\n                hour = false;\n            }\n            if (typeof(minute) === 'object') {\n                minute = false;\n            }\n            if (typeof(second) === 'object') {\n                second = false;\n            }\n            if (typeof(millisec) === 'object') {\n                millisec = false;\n            }\n            if (typeof(microsec) === 'object') {\n                microsec = false;\n            }\n            if (typeof(timezone) === 'object') {\n                timezone = false;\n            }\n\n            if (hour !== false) {\n                hour = parseInt(hour, 10);\n            }\n            if (minute !== false) {\n                minute = parseInt(minute, 10);\n            }\n            if (second !== false) {\n                second = parseInt(second, 10);\n            }\n            if (millisec !== false) {\n                millisec = parseInt(millisec, 10);\n            }\n            if (microsec !== false) {\n                microsec = parseInt(microsec, 10);\n            }\n            if (timezone !== false) {\n                timezone = timezone.toString();\n            }\n\n            var ampm = o[hour < 12 ? 'amNames' : 'pmNames'][0];\n\n            // If the update was done in the input field, the input field should not be updated.\n            // If the update was done using the sliders, update the input field.\n            var hasChanged = (\n                hour !== parseInt(this.hour,10) || // sliders should all be numeric\n                minute !== parseInt(this.minute,10) ||\n                second !== parseInt(this.second,10) ||\n                millisec !== parseInt(this.millisec,10) ||\n                microsec !== parseInt(this.microsec,10) ||\n                (this.ampm.length > 0 && (hour < 12) !== ($.inArray(this.ampm.toUpperCase(), this.amNames) !== -1)) ||\n                (this.timezone !== null && timezone !== this.timezone.toString()) // could be numeric or \"EST\" format, so use toString()\n            );\n\n            if (hasChanged) {\n\n                if (hour !== false) {\n                    this.hour = hour;\n                }\n                if (minute !== false) {\n                    this.minute = minute;\n                }\n                if (second !== false) {\n                    this.second = second;\n                }\n                if (millisec !== false) {\n                    this.millisec = millisec;\n                }\n                if (microsec !== false) {\n                    this.microsec = microsec;\n                }\n                if (timezone !== false) {\n                    this.timezone = timezone;\n                }\n\n                if (!this.inst) {\n                    this.inst = $.datepicker._getInst(this.$input[0]);\n                }\n\n                this._limitMinMaxDateTime(this.inst, true);\n            }\n            if (this.support.ampm) {\n                this.ampm = ampm;\n            }\n\n            // Updates the time within the timepicker\n            this.formattedTime = $.datepicker.formatTime(o.timeFormat, this, o);\n            if (this.$timeObj) {\n                if (pickerTimeFormat === o.timeFormat) {\n                    this.$timeObj.val(this.formattedTime + pickerTimeSuffix);\n                }\n                else {\n                    this.$timeObj.val($.datepicker.formatTime(pickerTimeFormat, this, o) + pickerTimeSuffix);\n                }\n                if (this.$timeObj[0].setSelectionRange) {\n                    var sPos = this.$timeObj[0].selectionStart;\n                    var ePos = this.$timeObj[0].selectionEnd;\n                    this.$timeObj[0].setSelectionRange(sPos, ePos);\n                }\n            }\n\n            this.timeDefined = true;\n            if (hasChanged) {\n                this._updateDateTime();\n                //this.$input.focus(); // may automatically open the picker on setDate\n            }\n        },\n\n        /*\n        * call custom onSelect.\n        * bind to sliders slidestop, and grid click.\n        */\n        _onSelectHandler: function () {\n            var onSelect = this._defaults.onSelect || this.inst.settings.onSelect;\n            var inputEl = this.$input ? this.$input[0] : null;\n            if (onSelect && inputEl) {\n                onSelect.apply(inputEl, [this.formattedDateTime, this]);\n            }\n        },\n\n        /*\n        * update our input with the new date time..\n        */\n        _updateDateTime: function (dp_inst) {\n            dp_inst = this.inst || dp_inst;\n            var dtTmp = (dp_inst.currentYear > 0?\n                new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay) :\n                new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                dt = $.datepicker._daylightSavingAdjust(dtTmp),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay)),\n                dateFmt = $.datepicker._get(dp_inst, 'dateFormat'),\n                formatCfg = $.datepicker._getFormatConfig(dp_inst),\n                timeAvailable = dt !== null && this.timeDefined;\n            this.formattedDate = $.datepicker.formatDate(dateFmt, (dt === null ? new Date() : dt), formatCfg);\n            var formattedDateTime = this.formattedDate;\n\n            // if a slider was changed but datepicker doesn't have a value yet, set it\n            if (dp_inst.lastVal === \"\") {\n                dp_inst.currentYear = dp_inst.selectedYear;\n                dp_inst.currentMonth = dp_inst.selectedMonth;\n                dp_inst.currentDay = dp_inst.selectedDay;\n            }\n\n            /*\n            * remove following lines to force every changes in date picker to change the input value\n            * Bug descriptions: when an input field has a default value, and click on the field to pop up the date picker.\n            * If the user manually empty the value in the input field, the date picker will never change selected value.\n            */\n            //if (dp_inst.lastVal !== undefined && (dp_inst.lastVal.length > 0 && this.$input.val().length === 0)) {\n            //\treturn;\n            //}\n\n            if (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === false) {\n                formattedDateTime = this.formattedTime;\n            } else if ((this._defaults.timeOnly !== true && (this._defaults.alwaysSetTime || timeAvailable)) || (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === true)) {\n                formattedDateTime += this._defaults.separator + this.formattedTime + this._defaults.timeSuffix;\n            }\n\n            this.formattedDateTime = formattedDateTime;\n\n            if (!this._defaults.showTimepicker) {\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput && this._defaults.timeOnly === false && this._defaults.altFieldTimeOnly === true) {\n                this.$altInput.val(this.formattedTime);\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput) {\n                this.$input.val(formattedDateTime);\n                var altFormattedDateTime = '',\n                    altSeparator = this._defaults.altSeparator !== null ? this._defaults.altSeparator : this._defaults.separator,\n                    altTimeSuffix = this._defaults.altTimeSuffix !== null ? this._defaults.altTimeSuffix : this._defaults.timeSuffix;\n\n                if (!this._defaults.timeOnly) {\n                    if (this._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(this._defaults.altFormat, (dt === null ? new Date() : dt), formatCfg);\n                    }\n                    else {\n                        altFormattedDateTime = this.formattedDate;\n                    }\n\n                    if (altFormattedDateTime) {\n                        altFormattedDateTime += altSeparator;\n                    }\n                }\n\n                if (this._defaults.altTimeFormat !== null) {\n                    altFormattedDateTime += $.datepicker.formatTime(this._defaults.altTimeFormat, this, this._defaults) + altTimeSuffix;\n                }\n                else {\n                    altFormattedDateTime += this.formattedTime + altTimeSuffix;\n                }\n                this.$altInput.val(altFormattedDateTime);\n            } else {\n                this.$input.val(formattedDateTime);\n            }\n\n            this.$input.trigger(\"change\");\n        },\n\n        _onFocus: function () {\n            if (!this.$input.val() && this._defaults.defaultValue) {\n                this.$input.val(this._defaults.defaultValue);\n                var inst = $.datepicker._getInst(this.$input.get(0)),\n                    tp_inst = $.datepicker._get(inst, 'timepicker');\n                if (tp_inst) {\n                    if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                        try {\n                            $.datepicker._updateDatepicker(inst);\n                        } catch (err) {\n                            $.timepicker.log(err);\n                        }\n                    }\n                }\n            }\n        },\n\n        /*\n        * Small abstraction to control types\n        * We can add more, just be sure to follow the pattern: create, options, value\n        */\n        _controls: {\n            // slider methods\n            slider: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var rtl = tp_inst._defaults.isRTL; // if rtl go -60->0 instead of 0->60\n                    return obj.prop('slide', null).slider({\n                        orientation: \"horizontal\",\n                        value: rtl ? val * -1 : val,\n                        min: rtl ? max * -1 : min,\n                        max: rtl ? min * -1 : max,\n                        step: step,\n                        slide: function (event, ui) {\n                            tp_inst.control.value(tp_inst, $(this), unit, rtl ? ui.value * -1 : ui.value);\n                            tp_inst._onTimeChange();\n                        },\n                        stop: function (event, ui) {\n                            tp_inst._onSelectHandler();\n                        }\n                    });\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (typeof(opts) === 'string') {\n                            if (opts === 'min' || opts === 'max') {\n                                if (val !== undefined) {\n                                    return obj.slider(opts, val * -1);\n                                }\n                                return Math.abs(obj.slider(opts));\n                            }\n                            return obj.slider(opts);\n                        }\n                        var min = opts.min,\n                            max = opts.max;\n                        opts.min = opts.max = null;\n                        if (min !== undefined) {\n                            opts.max = min * -1;\n                        }\n                        if (max !== undefined) {\n                            opts.min = max * -1;\n                        }\n                        return obj.slider(opts);\n                    }\n                    if (typeof(opts) === 'string' && val !== undefined) {\n                        return obj.slider(opts, val);\n                    }\n                    return obj.slider(opts);\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (val !== undefined) {\n                            return obj.slider('value', val * -1);\n                        }\n                        return Math.abs(obj.slider('value'));\n                    }\n                    if (val !== undefined) {\n                        return obj.slider('value', val);\n                    }\n                    return obj.slider('value');\n                }\n            },\n            // select methods\n            select: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var sel = '<select class=\"ui-timepicker-select ui-state-default ui-corner-all\" data-unit=\"' + unit + '\" data-min=\"' + min + '\" data-max=\"' + max + '\" data-step=\"' + step + '\">',\n                        format = tp_inst._defaults.pickerTimeFormat || tp_inst._defaults.timeFormat;\n\n                    for (var i = min; i <= max; i += step) {\n                        sel += '<option value=\"' + i + '\"' + (i === val ? ' selected' : '') + '>';\n                        if (unit === 'hour') {\n                            sel += $.datepicker.formatTime($.trim(format.replace(/[^ht ]/ig, '')), {hour: i}, tp_inst._defaults);\n                        }\n                        else if (unit === 'millisec' || unit === 'microsec' || i >= 10) { sel += i; }\n                        else {sel += '0' + i.toString(); }\n                        sel += '</option>';\n                    }\n                    sel += '</select>';\n\n                    obj.children('select').remove();\n\n                    $(sel).appendTo(obj).change(function (e) {\n                        tp_inst._onTimeChange();\n                        tp_inst._onSelectHandler();\n                        tp_inst._afterInject();\n                    });\n\n                    return obj;\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    var o = {},\n                        $t = obj.children('select');\n                    if (typeof(opts) === 'string') {\n                        if (val === undefined) {\n                            return $t.data(opts);\n                        }\n                        o[opts] = val;\n                    }\n                    else { o = opts; }\n                    return tp_inst.control.create(tp_inst, obj, $t.data('unit'), $t.val(), o.min>=0 ? o.min : $t.data('min'), o.max || $t.data('max'), o.step || $t.data('step'));\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    var $t = obj.children('select');\n                    if (val !== undefined) {\n                        return $t.val(val);\n                    }\n                    return $t.val();\n                }\n            }\n        } // end _controls\n\n    });\n\n    $.fn.extend({\n        /*\n        * shorthand just to use timepicker.\n        */\n        timepicker: function (o) {\n            o = o || {};\n            var tmp_args = Array.prototype.slice.call(arguments);\n\n            if (typeof o === 'object') {\n                tmp_args[0] = $.extend(o, {\n                    timeOnly: true\n                });\n            }\n\n            return $(this).each(function () {\n                $.fn.datetimepicker.apply($(this), tmp_args);\n            });\n        },\n\n        /*\n        * extend timepicker to datepicker\n        */\n        datetimepicker: function (o) {\n            o = o || {};\n            var tmp_args = arguments;\n\n            if (typeof(o) === 'string') {\n                if (o === 'getDate'  || (o === 'option' && tmp_args.length === 2 && typeof (tmp_args[1]) === 'string')) {\n                    return $.fn.datepicker.apply($(this[0]), tmp_args);\n                } else {\n                    return this.each(function () {\n                        var $t = $(this);\n                        $t.datepicker.apply($t, tmp_args);\n                    });\n                }\n            } else {\n                return this.each(function () {\n                    var $t = $(this);\n                    $t.datepicker($.timepicker._newInst($t, o)._defaults);\n                });\n            }\n        }\n    });\n\n    /*\n    * Public Utility to parse date and time\n    */\n    $.datepicker.parseDateTime = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var parseRes = parseDateTimeInternal(dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings);\n        if (parseRes.timeObj) {\n            var t = parseRes.timeObj;\n            parseRes.date.setHours(t.hour, t.minute, t.second, t.millisec);\n            parseRes.date.setMicroseconds(t.microsec);\n        }\n\n        return parseRes.date;\n    };\n\n    /*\n    * Public utility to parse time\n    */\n    $.datepicker.parseTime = function (timeFormat, timeString, options) {\n        var o = extendRemove(extendRemove({}, $.timepicker._defaults), options || {}),\n            iso8601 = (timeFormat.replace(/\\'.*?\\'/g, '').indexOf('Z') !== -1);\n\n        // Strict parse requires the timeString to match the timeFormat exactly\n        var strictParse = function (f, s, o) {\n\n            // pattern for standard and localized AM/PM markers\n            var getPatternAmpm = function (amNames, pmNames) {\n                var markers = [];\n                if (amNames) {\n                    $.merge(markers, amNames);\n                }\n                if (pmNames) {\n                    $.merge(markers, pmNames);\n                }\n                markers = $.map(markers, function (val) {\n                    return val.replace(/[.*+?|()\\[\\]{}\\\\]/g, '\\\\$&');\n                });\n                return '(' + markers.join('|') + ')?';\n            };\n\n            // figure out position of time elements.. cause js cant do named captures\n            var getFormatPositions = function (timeFormat) {\n                var finds = timeFormat.toLowerCase().match(/(h{1,2}|m{1,2}|s{1,2}|l{1}|c{1}|t{1,2}|z|'.*?')/g),\n                    orders = {\n                        h: -1,\n                        m: -1,\n                        s: -1,\n                        l: -1,\n                        c: -1,\n                        t: -1,\n                        z: -1\n                    };\n\n                if (finds) {\n                    for (var i = 0; i < finds.length; i++) {\n                        if (orders[finds[i].toString().charAt(0)] === -1) {\n                            orders[finds[i].toString().charAt(0)] = i + 1;\n                        }\n                    }\n                }\n                return orders;\n            };\n\n            var regstr = '^' + f.toString()\n                    .replace(/([hH]{1,2}|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n                        var ml = match.length;\n                        switch (match.charAt(0).toLowerCase()) {\n                            case 'h':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'm':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 's':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'l':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'c':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'z':\n                                return '(z|[-+]\\\\d\\\\d:?\\\\d\\\\d|\\\\S+)?';\n                            case 't':\n                                return getPatternAmpm(o.amNames, o.pmNames);\n                            default:    // literal escaped in quotes\n                                return '(' + match.replace(/\\'/g, \"\").replace(/(\\.|\\$|\\^|\\\\|\\/|\\(|\\)|\\[|\\]|\\?|\\+|\\*)/g, function (m) { return \"\\\\\" + m; }) + ')?';\n                        }\n                    })\n                    .replace(/\\s/g, '\\\\s?') +\n                o.timeSuffix + '$',\n                order = getFormatPositions(f),\n                ampm = '',\n                treg;\n\n            treg = s.match(new RegExp(regstr, 'i'));\n\n            var resTime = {\n                hour: 0,\n                minute: 0,\n                second: 0,\n                millisec: 0,\n                microsec: 0\n            };\n\n            if (treg) {\n                if (order.t !== -1) {\n                    if (treg[order.t] === undefined || treg[order.t].length === 0) {\n                        ampm = '';\n                        resTime.ampm = '';\n                    } else {\n                        ampm = $.inArray(treg[order.t].toUpperCase(), $.map(o.amNames, function (x,i) { return x.toUpperCase(); })) !== -1 ? 'AM' : 'PM';\n                        resTime.ampm = o[ampm === 'AM' ? 'amNames' : 'pmNames'][0];\n                    }\n                }\n\n                if (order.h !== -1) {\n                    if (ampm === 'AM' && treg[order.h] === '12') {\n                        resTime.hour = 0; // 12am = 0 hour\n                    } else {\n                        if (ampm === 'PM' && treg[order.h] !== '12') {\n                            resTime.hour = parseInt(treg[order.h], 10) + 12; // 12pm = 12 hour, any other pm = hour + 12\n                        } else {\n                            resTime.hour = Number(treg[order.h]);\n                        }\n                    }\n                }\n\n                if (order.m !== -1) {\n                    resTime.minute = Number(treg[order.m]);\n                }\n                if (order.s !== -1) {\n                    resTime.second = Number(treg[order.s]);\n                }\n                if (order.l !== -1) {\n                    resTime.millisec = Number(treg[order.l]);\n                }\n                if (order.c !== -1) {\n                    resTime.microsec = Number(treg[order.c]);\n                }\n                if (order.z !== -1 && treg[order.z] !== undefined) {\n                    resTime.timezone = $.timepicker.timezoneOffsetNumber(treg[order.z]);\n                }\n\n\n                return resTime;\n            }\n            return false;\n        };// end strictParse\n\n        // First try JS Date, if that fails, use strictParse\n        var looseParse = function (f, s, o) {\n            try {\n                var d = new Date('2012-01-01 ' + s);\n                if (isNaN(d.getTime())) {\n                    d = new Date('2012-01-01T' + s);\n                    if (isNaN(d.getTime())) {\n                        d = new Date('01/01/2012 ' + s);\n                        if (isNaN(d.getTime())) {\n                            throw \"Unable to parse time with native Date: \" + s;\n                        }\n                    }\n                }\n\n                return {\n                    hour: d.getHours(),\n                    minute: d.getMinutes(),\n                    second: d.getSeconds(),\n                    millisec: d.getMilliseconds(),\n                    microsec: d.getMicroseconds(),\n                    timezone: d.getTimezoneOffset() * -1\n                };\n            }\n            catch (err) {\n                try {\n                    return strictParse(f, s, o);\n                }\n                catch (err2) {\n                    $.timepicker.log(\"Unable to parse \\ntimeString: \" + s + \"\\ntimeFormat: \" + f);\n                }\n            }\n            return false;\n        }; // end looseParse\n\n        if (typeof o.parse === \"function\") {\n            return o.parse(timeFormat, timeString, o);\n        }\n        if (o.parse === 'loose') {\n            return looseParse(timeFormat, timeString, o);\n        }\n        return strictParse(timeFormat, timeString, o);\n    };\n\n    /**\n     * Public utility to format the time\n     * @param {string} format format of the time\n     * @param {Object} time Object not a Date for timezones\n     * @param {Object} [options] essentially the regional[].. amNames, pmNames, ampm\n     * @returns {string} the formatted time\n     */\n    $.datepicker.formatTime = function (format, time, options) {\n        options = options || {};\n        options = $.extend({}, $.timepicker._defaults, options);\n        time = $.extend({\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null\n        }, time);\n\n        var tmptime = format,\n            ampmName = options.amNames[0],\n            hour = parseInt(time.hour, 10);\n\n        if (hour > 11) {\n            ampmName = options.pmNames[0];\n        }\n\n        tmptime = tmptime.replace(/(?:HH?|hh?|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n            switch (match) {\n                case 'HH':\n                    return ('0' + hour).slice(-2);\n                case 'H':\n                    return hour;\n                case 'hh':\n                    return ('0' + convert24to12(hour)).slice(-2);\n                case 'h':\n                    return convert24to12(hour);\n                case 'mm':\n                    return ('0' + time.minute).slice(-2);\n                case 'm':\n                    return time.minute;\n                case 'ss':\n                    return ('0' + time.second).slice(-2);\n                case 's':\n                    return time.second;\n                case 'l':\n                    return ('00' + time.millisec).slice(-3);\n                case 'c':\n                    return ('00' + time.microsec).slice(-3);\n                case 'z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, false);\n                case 'Z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, true);\n                case 'T':\n                    return ampmName.charAt(0).toUpperCase();\n                case 'TT':\n                    return ampmName.toUpperCase();\n                case 't':\n                    return ampmName.charAt(0).toLowerCase();\n                case 'tt':\n                    return ampmName.toLowerCase();\n                default:\n                    return match.replace(/'/g, \"\");\n            }\n        });\n\n        return tmptime;\n    };\n\n    /*\n    * the bad hack :/ override datepicker so it doesn't close on select\n    // inspired: http://stackoverflow.com/questions/1252512/jquery-datepicker-prevent-closing-picker-when-clicking-a-date/1762378#1762378\n    */\n    $.datepicker._base_selectDate = $.datepicker._selectDate;\n    $.datepicker._selectDate = function (id, dateStr) {\n        var inst = this._getInst($(id)[0]),\n            tp_inst = this._get(inst, 'timepicker'),\n            was_inline;\n\n        if (tp_inst && inst.settings.showTimepicker) {\n            tp_inst._limitMinMaxDateTime(inst, true);\n            was_inline = inst.inline;\n            inst.inline = inst.stay_open = true;\n            //This way the onSelect handler called from calendarpicker get the full dateTime\n            this._base_selectDate(id, dateStr);\n            inst.inline = was_inline;\n            inst.stay_open = false;\n            this._notifyChange(inst);\n            this._updateDatepicker(inst);\n        } else {\n            this._base_selectDate(id, dateStr);\n        }\n    };\n\n    /*\n    * second bad hack :/ override datepicker so it triggers an event when changing the input field\n    * and does not redraw the datepicker on every selectDate event\n    */\n    $.datepicker._base_updateDatepicker = $.datepicker._updateDatepicker;\n    $.datepicker._updateDatepicker = function (inst) {\n\n        // don't popup the datepicker if there is another instance already opened\n        var input = inst.input[0];\n        if ($.datepicker._curInst && $.datepicker._curInst !== inst && $.datepicker._datepickerShowing && $.datepicker._lastInput !== input) {\n            return;\n        }\n\n        if (typeof(inst.stay_open) !== 'boolean' || inst.stay_open === false) {\n\n            this._base_updateDatepicker(inst);\n\n            // Reload the time control when changing something in the input text field.\n            var tp_inst = this._get(inst, 'timepicker');\n            if (tp_inst) {\n                tp_inst._addTimePicker(inst);\n            }\n        }\n    };\n\n    /*\n    * third bad hack :/ override datepicker so it allows spaces and colon in the input field\n    */\n    $.datepicker._base_doKeyPress = $.datepicker._doKeyPress;\n    $.datepicker._doKeyPress = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if ($.datepicker._get(inst, 'constrainInput')) {\n                var ampm = tp_inst.support.ampm,\n                    tz = tp_inst._defaults.showTimezone !== null ? tp_inst._defaults.showTimezone : tp_inst.support.timezone,\n                    dateChars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat')),\n                    datetimeChars = tp_inst._defaults.timeFormat.toString()\n                            .replace(/[hms]/g, '')\n                            .replace(/TT/g, ampm ? 'APM' : '')\n                            .replace(/Tt/g, ampm ? 'AaPpMm' : '')\n                            .replace(/tT/g, ampm ? 'AaPpMm' : '')\n                            .replace(/T/g, ampm ? 'AP' : '')\n                            .replace(/tt/g, ampm ? 'apm' : '')\n                            .replace(/t/g, ampm ? 'ap' : '') +\n                        \" \" + tp_inst._defaults.separator +\n                        tp_inst._defaults.timeSuffix +\n                        (tz ? tp_inst._defaults.timezoneList.join('') : '') +\n                        (tp_inst._defaults.amNames.join('')) + (tp_inst._defaults.pmNames.join('')) +\n                        dateChars,\n                    chr = String.fromCharCode(event.charCode === undefined ? event.keyCode : event.charCode);\n                return event.ctrlKey || (chr < ' ' || !dateChars || datetimeChars.indexOf(chr) > -1);\n            }\n        }\n\n        return $.datepicker._base_doKeyPress(event);\n    };\n\n    /*\n    * Fourth bad hack :/ override _updateAlternate function used in inline mode to init altField\n    * Update any alternate field to synchronise with the main field.\n    */\n    $.datepicker._base_updateAlternate = $.datepicker._updateAlternate;\n    $.datepicker._updateAlternate = function (inst) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var altField = tp_inst._defaults.altField;\n            if (altField) { // update alternate field too\n                var altFormat = tp_inst._defaults.altFormat || tp_inst._defaults.dateFormat,\n                    date = this._getDate(inst),\n                    formatCfg = $.datepicker._getFormatConfig(inst),\n                    altFormattedDateTime = '',\n                    altSeparator = tp_inst._defaults.altSeparator ? tp_inst._defaults.altSeparator : tp_inst._defaults.separator,\n                    altTimeSuffix = tp_inst._defaults.altTimeSuffix ? tp_inst._defaults.altTimeSuffix : tp_inst._defaults.timeSuffix,\n                    altTimeFormat = tp_inst._defaults.altTimeFormat !== null ? tp_inst._defaults.altTimeFormat : tp_inst._defaults.timeFormat;\n\n                altFormattedDateTime += $.datepicker.formatTime(altTimeFormat, tp_inst, tp_inst._defaults) + altTimeSuffix;\n                if (!tp_inst._defaults.timeOnly && !tp_inst._defaults.altFieldTimeOnly && date !== null) {\n                    if (tp_inst._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(tp_inst._defaults.altFormat, date, formatCfg) + altSeparator + altFormattedDateTime;\n                    }\n                    else {\n                        altFormattedDateTime = tp_inst.formattedDate + altSeparator + altFormattedDateTime;\n                    }\n                }\n                $(altField).val( inst.input.val() ? altFormattedDateTime : \"\");\n            }\n        }\n        else {\n            $.datepicker._base_updateAlternate(inst);\n        }\n    };\n\n    /*\n    * Override key up event to sync manual input changes.\n    */\n    $.datepicker._base_doKeyUp = $.datepicker._doKeyUp;\n    $.datepicker._doKeyUp = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                try {\n                    $.datepicker._updateDatepicker(inst);\n                } catch (err) {\n                    $.timepicker.log(err);\n                }\n            }\n        }\n\n        return $.datepicker._base_doKeyUp(event);\n    };\n\n    /*\n    * override \"Today\" button to also grab the time and set it to input field.\n    */\n    $.datepicker._base_gotoToday = $.datepicker._gotoToday;\n    $.datepicker._gotoToday = function (id) {\n        var inst = this._getInst($(id)[0]);\n        this._base_gotoToday(id);\n        var tp_inst = this._get(inst, 'timepicker');\n        if (!tp_inst) {\n            return;\n        }\n\n        var tzoffset = $.timepicker.timezoneOffsetNumber(tp_inst.timezone);\n        var now = new Date();\n        now.setMinutes(now.getMinutes() + now.getTimezoneOffset() + parseInt(tzoffset, 10));\n        this._setTime(inst, now);\n        this._setDate(inst, now);\n        tp_inst._onSelectHandler();\n    };\n\n    /*\n    * Disable & enable the Time in the datetimepicker\n    */\n    $.datepicker._disableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = false;\n            tp_inst._defaults.showTimepicker = false;\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    $.datepicker._enableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = true;\n            tp_inst._defaults.showTimepicker = true;\n            tp_inst._addTimePicker(inst); // Could be disabled on page load\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create our own set time function\n    */\n    $.datepicker._setTime = function (inst, date) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var defaults = tp_inst._defaults;\n\n            // calling _setTime with no date sets time to defaults\n            tp_inst.hour = date ? date.getHours() : defaults.hour;\n            tp_inst.minute = date ? date.getMinutes() : defaults.minute;\n            tp_inst.second = date ? date.getSeconds() : defaults.second;\n            tp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;\n            tp_inst.microsec = date ? date.getMicroseconds() : defaults.microsec;\n\n            //check if within min/max times..\n            tp_inst._limitMinMaxDateTime(inst, true);\n\n            tp_inst._onTimeChange();\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create new public method to set only time, callable as $().datepicker('setTime', date)\n    */\n    $.datepicker._setTimeDatepicker = function (target, date, withDate) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            this._setDateFromField(inst);\n            var tp_date;\n            if (date) {\n                if (typeof date === \"string\") {\n                    tp_inst._parseTime(date, withDate);\n                    tp_date = new Date();\n                    tp_date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                    tp_date.setMicroseconds(tp_inst.microsec);\n                } else {\n                    tp_date = new Date(date.getTime());\n                    tp_date.setMicroseconds(date.getMicroseconds());\n                }\n                if (tp_date.toString() === 'Invalid Date') {\n                    tp_date = undefined;\n                }\n                this._setTime(inst, tp_date);\n            }\n        }\n\n    };\n\n    /*\n    * override setDate() to allow setting time too within Date object\n    */\n    $.datepicker._base_setDateDatepicker = $.datepicker._setDateDatepicker;\n    $.datepicker._setDateDatepicker = function (target, _date) {\n        var inst = this._getInst(target);\n        var date = _date;\n        if (!inst) {\n            return;\n        }\n\n        if (typeof(_date) === 'string') {\n            date = new Date(_date);\n            if (!date.getTime()) {\n                this._base_setDateDatepicker.apply(this, arguments);\n                date = $(target).datepicker('getDate');\n            }\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        var tp_date;\n        if (date instanceof Date) {\n            tp_date = new Date(date.getTime());\n            tp_date.setMicroseconds(date.getMicroseconds());\n        } else {\n            tp_date = date;\n        }\n\n        // This is important if you are using the timezone option, javascript's Date\n        // object will only return the timezone offset for the current locale, so we\n        // adjust it accordingly.  If not using timezone option this won't matter..\n        // If a timezone is different in tp, keep the timezone as is\n        if (tp_inst && tp_date) {\n            // look out for DST if tz wasn't specified\n            if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                tp_inst.timezone = tp_date.getTimezoneOffset() * -1;\n            }\n            date = $.timepicker.timezoneAdjust(date, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()), tp_inst.timezone);\n            tp_date = $.timepicker.timezoneAdjust(tp_date, $.timepicker.timezoneOffsetString(-tp_date.getTimezoneOffset()), tp_inst.timezone);\n        }\n\n        this._updateDatepicker(inst);\n        this._base_setDateDatepicker.apply(this, arguments);\n        this._setTimeDatepicker(target, tp_date, true);\n    };\n\n    /*\n    * override getDate() to allow getting time too within Date object\n    */\n    $.datepicker._base_getDateDatepicker = $.datepicker._getDateDatepicker;\n    $.datepicker._getDateDatepicker = function (target, noDefault) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            // if it hasn't yet been defined, grab from field\n            if (inst.lastVal === undefined) {\n                this._setDateFromField(inst, noDefault);\n            }\n\n            var date = this._getDate(inst);\n\n            var currDT = null;\n\n            if (tp_inst.$altInput && tp_inst._defaults.altFieldTimeOnly) {\n                currDT = tp_inst.$input.val() + ' ' + tp_inst.$altInput.val();\n            }\n            else if (tp_inst.$input.get(0).tagName !== 'INPUT' && tp_inst.$altInput) {\n                /**\n                 * in case the datetimepicker has been applied to a non-input tag for inline UI,\n                 * and the user has not configured the plugin to display only time in altInput,\n                 * pick current date time from the altInput (and hope for the best, for now, until \"ER1\" is applied)\n                 *\n                 * @todo ER1. Since altInput can have a totally difference format, convert it to standard format by reading input format from \"altFormat\" and \"altTimeFormat\" option values\n                 */\n                currDT = tp_inst.$altInput.val();\n            }\n            else {\n                currDT = tp_inst.$input.val();\n            }\n\n            if (date && tp_inst._parseTime(currDT, !inst.settings.timeOnly)) {\n                date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                date.setMicroseconds(tp_inst.microsec);\n\n                // This is important if you are using the timezone option, javascript's Date\n                // object will only return the timezone offset for the current locale, so we\n                // adjust it accordingly.  If not using timezone option this won't matter..\n                if (tp_inst.timezone != null) {\n                    // look out for DST if tz wasn't specified\n                    if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                        tp_inst.timezone = date.getTimezoneOffset() * -1;\n                    }\n                    date = $.timepicker.timezoneAdjust(date, tp_inst.timezone, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()));\n                }\n            }\n            return date;\n        }\n        return this._base_getDateDatepicker(target, noDefault);\n    };\n\n    /*\n    * override parseDate() because UI 1.8.14 throws an error about \"Extra characters\"\n    * An option in datapicker to ignore extra format characters would be nicer.\n    */\n    $.datepicker._base_parseDate = $.datepicker.parseDate;\n    $.datepicker.parseDate = function (format, value, settings) {\n        var date;\n        try {\n            date = this._base_parseDate(format, value, settings);\n        } catch (err) {\n            // Hack!  The error message ends with a colon, a space, and\n            // the \"extra\" characters.  We rely on that instead of\n            // attempting to perfectly reproduce the parsing algorithm.\n            if (err.indexOf(\":\") >= 0) {\n                date = this._base_parseDate(format, value.substring(0, value.length - (err.length - err.indexOf(':') - 2)), settings);\n                $.timepicker.log(\"Error parsing the date string: \" + err + \"\\ndate string = \" + value + \"\\ndate format = \" + format);\n            } else {\n                throw err;\n            }\n        }\n        return date;\n    };\n\n    /*\n    * override formatDate to set date with time to the input\n    */\n    $.datepicker._base_formatDate = $.datepicker._formatDate;\n    $.datepicker._formatDate = function (inst, day, month, year) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            tp_inst._updateDateTime(inst);\n            return tp_inst.$input.val();\n        }\n        return this._base_formatDate(inst);\n    };\n\n    /*\n    * override options setter to add time to maxDate(Time) and minDate(Time). MaxDate\n    */\n    $.datepicker._base_optionDatepicker = $.datepicker._optionDatepicker;\n    $.datepicker._optionDatepicker = function (target, name, value) {\n        var inst = this._getInst(target),\n            name_clone;\n        if (!inst) {\n            return null;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var min = null,\n                max = null,\n                onselect = null,\n                overrides = tp_inst._defaults.evnts,\n                fns = {},\n                prop,\n                ret,\n                oldVal,\n                $target;\n            if (typeof name === 'string') { // if min/max was set with the string\n                if (name === 'minDate' || name === 'minDateTime') {\n                    min = value;\n                } else if (name === 'maxDate' || name === 'maxDateTime') {\n                    max = value;\n                } else if (name === 'onSelect') {\n                    onselect = value;\n                } else if (overrides.hasOwnProperty(name)) {\n                    if (typeof (value) === 'undefined') {\n                        return overrides[name];\n                    }\n                    fns[name] = value;\n                    name_clone = {}; //empty results in exiting function after overrides updated\n                }\n            } else if (typeof name === 'object') { //if min/max was set with the JSON\n                if (name.minDate) {\n                    min = name.minDate;\n                } else if (name.minDateTime) {\n                    min = name.minDateTime;\n                } else if (name.maxDate) {\n                    max = name.maxDate;\n                } else if (name.maxDateTime) {\n                    max = name.maxDateTime;\n                }\n                for (prop in overrides) {\n                    if (overrides.hasOwnProperty(prop) && name[prop]) {\n                        fns[prop] = name[prop];\n                    }\n                }\n            }\n            for (prop in fns) {\n                if (fns.hasOwnProperty(prop)) {\n                    overrides[prop] = fns[prop];\n                    if (!name_clone) { name_clone = $.extend({}, name); }\n                    delete name_clone[prop];\n                }\n            }\n            if (name_clone && isEmptyObject(name_clone)) { return; }\n            if (min) { //if min was set\n                if (min === 0) {\n                    min = new Date();\n                } else {\n                    min = new Date(min);\n                }\n                tp_inst._defaults.minDate = min;\n                tp_inst._defaults.minDateTime = min;\n            } else if (max) { //if max was set\n                if (max === 0) {\n                    max = new Date();\n                } else {\n                    max = new Date(max);\n                }\n                tp_inst._defaults.maxDate = max;\n                tp_inst._defaults.maxDateTime = max;\n            } else if (onselect) {\n                tp_inst._defaults.onSelect = onselect;\n            }\n\n            // Datepicker will override our date when we call _base_optionDatepicker when\n            // calling minDate/maxDate, so we will first grab the value, call\n            // _base_optionDatepicker, then set our value back.\n            if(min || max){\n                $target = $(target);\n                oldVal = $target.datetimepicker('getDate');\n                ret = this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n                $target.datetimepicker('setDate', oldVal);\n                return ret;\n            }\n        }\n        if (value === undefined) {\n            return this._base_optionDatepicker.call($.datepicker, target, name);\n        }\n        return this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n    };\n\n    /*\n    * jQuery isEmptyObject does not check hasOwnProperty - if someone has added to the object prototype,\n    * it will return false for all objects\n    */\n    var isEmptyObject = function (obj) {\n        var prop;\n        for (prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                return false;\n            }\n        }\n        return true;\n    };\n\n    /*\n    * jQuery extend now ignores nulls!\n    */\n    var extendRemove = function (target, props) {\n        $.extend(target, props);\n        for (var name in props) {\n            if (props[name] === null || props[name] === undefined) {\n                target[name] = props[name];\n            }\n        }\n        return target;\n    };\n\n    /*\n    * Determine by the time format which units are supported\n    * Returns an object of booleans for each unit\n    */\n    var detectSupport = function (timeFormat) {\n        var tf = timeFormat.replace(/'.*?'/g, '').toLowerCase(), // removes literals\n            isIn = function (f, t) { // does the format contain the token?\n                return f.indexOf(t) !== -1 ? true : false;\n            };\n        return {\n            hour: isIn(tf, 'h'),\n            minute: isIn(tf, 'm'),\n            second: isIn(tf, 's'),\n            millisec: isIn(tf, 'l'),\n            microsec: isIn(tf, 'c'),\n            timezone: isIn(tf, 'z'),\n            ampm: isIn(tf, 't') && isIn(timeFormat, 'h'),\n            iso8601: isIn(timeFormat, 'Z')\n        };\n    };\n\n    /*\n    * Converts 24 hour format into 12 hour\n    * Returns 12 hour without leading 0\n    */\n    var convert24to12 = function (hour) {\n        hour %= 12;\n\n        if (hour === 0) {\n            hour = 12;\n        }\n\n        return String(hour);\n    };\n\n    var computeEffectiveSetting = function (settings, property) {\n        return settings && settings[property] ? settings[property] : $.timepicker._defaults[property];\n    };\n\n    /*\n    * Splits datetime string into date and time substrings.\n    * Throws exception when date can't be parsed\n    * Returns {dateString: dateString, timeString: timeString}\n    */\n    var splitDateTime = function (dateTimeString, timeSettings) {\n        // The idea is to get the number separator occurrences in datetime and the time format requested (since time has\n        // fewer unknowns, mostly numbers and am/pm). We will use the time pattern to split.\n        var separator = computeEffectiveSetting(timeSettings, 'separator'),\n            format = computeEffectiveSetting(timeSettings, 'timeFormat'),\n            timeParts = format.split(separator), // how many occurrences of separator may be in our format?\n            timePartsLen = timeParts.length,\n            allParts = dateTimeString.split(separator),\n            allPartsLen = allParts.length;\n\n        if (allPartsLen > 1) {\n            return {\n                dateString: allParts.splice(0, allPartsLen - timePartsLen).join(separator),\n                timeString: allParts.splice(0, timePartsLen).join(separator)\n            };\n        }\n\n        return {\n            dateString: dateTimeString,\n            timeString: ''\n        };\n    };\n\n    /*\n    * Internal function to parse datetime interval\n    * Returns: {date: Date, timeObj: Object}, where\n    *   date - parsed date without time (type Date)\n    *   timeObj = {hour: , minute: , second: , millisec: , microsec: } - parsed time. Optional\n    */\n    var parseDateTimeInternal = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var date,\n            parts,\n            parsedTime;\n\n        parts = splitDateTime(dateTimeString, timeSettings);\n        date = $.datepicker._base_parseDate(dateFormat, parts.dateString, dateSettings);\n\n        if (parts.timeString === '') {\n            return {\n                date: date\n            };\n        }\n\n        parsedTime = $.datepicker.parseTime(timeFormat, parts.timeString, timeSettings);\n\n        if (!parsedTime) {\n            throw 'Wrong time format';\n        }\n\n        return {\n            date: date,\n            timeObj: parsedTime\n        };\n    };\n\n    /*\n    * Internal function to set timezone_select to the local timezone\n    */\n    var selectLocalTimezone = function (tp_inst, date) {\n        if (tp_inst && tp_inst.timezone_select) {\n            var now = date || new Date();\n            tp_inst.timezone_select.val(-now.getTimezoneOffset());\n        }\n    };\n\n    /*\n    * Create a Singleton Instance\n    */\n    $.timepicker = new Timepicker();\n\n    /**\n     * Get the timezone offset as string from a date object (eg '+0530' for UTC+5.5)\n     * @param {number} tzMinutes if not a number, less than -720 (-1200), or greater than 840 (+1400) this value is returned\n     * @param {boolean} iso8601 if true formats in accordance to iso8601 \"+12:45\"\n     * @return {string}\n     */\n    $.timepicker.timezoneOffsetString = function (tzMinutes, iso8601) {\n        if (isNaN(tzMinutes) || tzMinutes > 840 || tzMinutes < -720) {\n            return tzMinutes;\n        }\n\n        var off = tzMinutes,\n            minutes = off % 60,\n            hours = (off - minutes) / 60,\n            iso = iso8601 ? ':' : '',\n            tz = (off >= 0 ? '+' : '-') + ('0' + Math.abs(hours)).slice(-2) + iso + ('0' + Math.abs(minutes)).slice(-2);\n\n        if (tz === '+00:00') {\n            return 'Z';\n        }\n        return tz;\n    };\n\n    /**\n     * Get the number in minutes that represents a timezone string\n     * @param  {string} tzString formatted like \"+0500\", \"-1245\", \"Z\"\n     * @return {number} the offset minutes or the original string if it doesn't match expectations\n     */\n    $.timepicker.timezoneOffsetNumber = function (tzString) {\n        var normalized = tzString.toString().replace(':', ''); // excuse any iso8601, end up with \"+1245\"\n\n        if (normalized.toUpperCase() === 'Z') { // if iso8601 with Z, its 0 minute offset\n            return 0;\n        }\n\n        if (!/^(\\-|\\+)\\d{4}$/.test(normalized)) { // possibly a user defined tz, so just give it back\n            return parseInt(tzString, 10);\n        }\n\n        return ((normalized.substr(0, 1) === '-' ? -1 : 1) * // plus or minus\n            ((parseInt(normalized.substr(1, 2), 10) * 60) + // hours (converted to minutes)\n                parseInt(normalized.substr(3, 2), 10))); // minutes\n    };\n\n    /**\n     * No way to set timezone in js Date, so we must adjust the minutes to compensate. (think setDate, getDate)\n     * @param  {Date} date\n     * @param  {string} fromTimezone formatted like \"+0500\", \"-1245\"\n     * @param  {string} toTimezone formatted like \"+0500\", \"-1245\"\n     * @return {Date}\n     */\n    $.timepicker.timezoneAdjust = function (date, fromTimezone, toTimezone) {\n        var fromTz = $.timepicker.timezoneOffsetNumber(fromTimezone);\n        var toTz = $.timepicker.timezoneOffsetNumber(toTimezone);\n        if (!isNaN(toTz)) {\n            date.setMinutes(date.getMinutes() + (-fromTz) - (-toTz));\n        }\n        return date;\n    };\n\n    /**\n     * Calls `timepicker()` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * n.b. The input value must be correctly formatted (reformatting is not supported)\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the timepicker() call\n     * @return {jQuery}\n     */\n    $.timepicker.timeRange = function (startTime, endTime, options) {\n        return $.timepicker.handleRange('timepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datetimepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @return {jQuery}\n     */\n    $.timepicker.datetimeRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datetimepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.dateRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `method` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.handleRange = function (method, startTime, endTime, options) {\n        options = $.extend({}, {\n            minInterval: 0, // min allowed interval in milliseconds\n            maxInterval: 0, // max allowed interval in milliseconds\n            start: {},      // options for start picker\n            end: {}         // options for end picker\n        }, options);\n\n        // for the mean time this fixes an issue with calling getDate with timepicker()\n        var timeOnly = false;\n        if(method === 'timepicker'){\n            timeOnly = true;\n            method = 'datetimepicker';\n        }\n\n        function checkDates(changed, other) {\n            var startdt = startTime[method]('getDate'),\n                enddt = endTime[method]('getDate'),\n                changeddt = changed[method]('getDate');\n\n            if (startdt !== null) {\n                var minDate = new Date(startdt.getTime()),\n                    maxDate = new Date(startdt.getTime());\n\n                minDate.setMilliseconds(minDate.getMilliseconds() + options.minInterval);\n                maxDate.setMilliseconds(maxDate.getMilliseconds() + options.maxInterval);\n\n                if (options.minInterval > 0 && minDate > enddt) { // minInterval check\n                    endTime[method]('setDate', minDate);\n                }\n                else if (options.maxInterval > 0 && maxDate < enddt) { // max interval check\n                    endTime[method]('setDate', maxDate);\n                }\n                else if (startdt > enddt) {\n                    other[method]('setDate', changeddt);\n                }\n            }\n        }\n\n        function selected(changed, other, option) {\n            if (!changed.val()) {\n                return;\n            }\n            var date = changed[method].call(changed, 'getDate');\n            if (date !== null && options.minInterval > 0) {\n                if (option === 'minDate') {\n                    date.setMilliseconds(date.getMilliseconds() + options.minInterval);\n                }\n                if (option === 'maxDate') {\n                    date.setMilliseconds(date.getMilliseconds() - options.minInterval);\n                }\n            }\n\n            if (date.getTime) {\n                other[method].call(other, 'option', option, date);\n            }\n        }\n\n        $.fn[method].call(startTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), endTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), endTime, 'minDate');\n            }\n        }, options, options.start));\n        $.fn[method].call(endTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), startTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), startTime, 'maxDate');\n            }\n        }, options, options.end));\n\n        checkDates(startTime, endTime);\n\n        selected(startTime, endTime, 'minDate');\n        selected(endTime, startTime, 'maxDate');\n\n        return $([startTime.get(0), endTime.get(0)]);\n    };\n\n    /**\n     * Log error or data to the console during error or debugging\n     * @param  {Object} err pass any type object to log to the console during error or debugging\n     * @return {void}\n     */\n    $.timepicker.log = function () {\n        // Older IE (9, maybe 10) throw error on accessing `window.console.log.apply`, so check first.\n        if (window.console && window.console.log && window.console.log.apply) {\n            window.console.log.apply(window.console, Array.prototype.slice.call(arguments));\n        }\n    };\n\n    /*\n     * Add util object to allow access to private methods for testability.\n     */\n    $.timepicker._util = {\n        _extendRemove: extendRemove,\n        _isEmptyObject: isEmptyObject,\n        _convert24to12: convert24to12,\n        _detectSupport: detectSupport,\n        _selectLocalTimezone: selectLocalTimezone,\n        _computeEffectiveSetting: computeEffectiveSetting,\n        _splitDateTime: splitDateTime,\n        _parseDateTimeInternal: parseDateTimeInternal\n    };\n\n    /*\n    * Microsecond support\n    */\n    if (!Date.prototype.getMicroseconds) {\n        Date.prototype.microseconds = 0;\n        Date.prototype.getMicroseconds = function () { return this.microseconds; };\n        Date.prototype.setMicroseconds = function (m) {\n            this.setMilliseconds(this.getMilliseconds() + Math.floor(m / 1000));\n            this.microseconds = m % 1000;\n            return this;\n        };\n    }\n\n    /*\n    * Keep up with the version\n    */\n    $.timepicker.version = \"1.6.3\";\n\n}));\n","jquery/jquery.parsequery.js":"/**\n * Copyright (c) 2010 Conrad Irwin <conrad@rapportive.com> MIT license.\n * Based loosely on original: Copyright (c) 2008 mkmanning MIT license.\n *\n * Parses CGI query strings into javascript objects.\n *\n * See the README for details.\n **/\ndefine([\n    \"jquery\"\n], function($){\n    $.parseQuery = function (options) {\n\n        var config = {query: window.location.search || \"\"},\n            params = {};\n\n        if (typeof options === 'string') {\n            options = {query: options};\n        }\n        $.extend(config, $.parseQuery, options);\n        config.query = config.query.replace(/^\\?/, '');\n\n        if (config.query.length > 0) {\n            $.each(config.query.split(config.separator), function (i, param) {\n                var pair = param.split('='),\n                    key = config.decode(pair.shift(), null).toString(),\n                    value = config.decode(pair.length ? pair.join('=') : null, key);\n\n                if (config.array_keys.test ? config.array_keys.test(key) : config.array_keys(key)) {\n                    params[key] = params[key] || [];\n                    params[key].push(value);\n                } else {\n                    params[key] = value;\n                }\n            });\n        }\n        return params;\n    };\n    $.parseQuery.decode = $.parseQuery.default_decode = function (string) {\n        return decodeURIComponent((string || \"\").replace(/\\+/g, ' '));\n    };\n    $.parseQuery.array_keys = function () {\n        return false;\n    };\n    $.parseQuery.separator = \"&\";\n});\n","jquery/jquery.cookie.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'js-cookie/cookie-wrapper'\n], function () {\n\n});\n","jquery/jquery-ui-timepicker-addon.js":"/*! jQuery Timepicker Addon - v1.6.3 - 2016-04-20\n* http://trentrichardson.com/examples/timepicker\n* Copyright (c) 2016 Trent Richardson; Licensed MIT */\n(function (factory) {\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery', 'jquery/ui'], factory);\n    } else {\n        factory(jQuery);\n    }\n}(function ($) {\n\n    /*\n    * Lets not redefine timepicker, Prevent \"Uncaught RangeError: Maximum call stack size exceeded\"\n    */\n    $.ui.timepicker = $.ui.timepicker || {};\n    if ($.ui.timepicker.version) {\n        return;\n    }\n\n    /*\n    * Extend jQueryUI, get it started with our version number\n    */\n    $.extend($.ui, {\n        timepicker: {\n            version: \"1.6.3\"\n        }\n    });\n\n    /*\n    * Timepicker manager.\n    * Use the singleton instance of this class, $.timepicker, to interact with the time picker.\n    * Settings for (groups of) time pickers are maintained in an instance object,\n    * allowing multiple different settings on the same page.\n    */\n    var Timepicker = function () {\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[''] = { // Default regional settings\n            currentText: 'Now',\n            closeText: 'Done',\n            amNames: ['AM', 'A'],\n            pmNames: ['PM', 'P'],\n            timeFormat: 'HH:mm',\n            timeSuffix: '',\n            timeOnlyTitle: 'Choose Time',\n            timeText: 'Time',\n            hourText: 'Hour',\n            minuteText: 'Minute',\n            secondText: 'Second',\n            millisecText: 'Millisecond',\n            microsecText: 'Microsecond',\n            timezoneText: 'Time Zone',\n            isRTL: false\n        };\n        this._defaults = { // Global defaults for all the datetime picker instances\n            showButtonPanel: true,\n            timeOnly: false,\n            timeOnlyShowDate: false,\n            showHour: null,\n            showMinute: null,\n            showSecond: null,\n            showMillisec: null,\n            showMicrosec: null,\n            showTimezone: null,\n            showTime: true,\n            stepHour: 1,\n            stepMinute: 1,\n            stepSecond: 1,\n            stepMillisec: 1,\n            stepMicrosec: 1,\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null,\n            hourMin: 0,\n            minuteMin: 0,\n            secondMin: 0,\n            millisecMin: 0,\n            microsecMin: 0,\n            hourMax: 23,\n            minuteMax: 59,\n            secondMax: 59,\n            millisecMax: 999,\n            microsecMax: 999,\n            minDateTime: null,\n            maxDateTime: null,\n            maxTime: null,\n            minTime: null,\n            onSelect: null,\n            hourGrid: 0,\n            minuteGrid: 0,\n            secondGrid: 0,\n            millisecGrid: 0,\n            microsecGrid: 0,\n            alwaysSetTime: true,\n            separator: ' ',\n            altFieldTimeOnly: true,\n            altTimeFormat: null,\n            altSeparator: null,\n            altTimeSuffix: null,\n            altRedirectFocus: true,\n            pickerTimeFormat: null,\n            pickerTimeSuffix: null,\n            showTimepicker: true,\n            timezoneList: null,\n            addSliderAccess: false,\n            sliderAccessArgs: null,\n            controlType: 'slider',\n            oneLine: false,\n            defaultValue: null,\n            parse: 'strict',\n            afterInject: null\n        };\n        $.extend(this._defaults, this.regional['']);\n    };\n\n    $.extend(Timepicker.prototype, {\n        $input: null,\n        $altInput: null,\n        $timeObj: null,\n        inst: null,\n        hour_slider: null,\n        minute_slider: null,\n        second_slider: null,\n        millisec_slider: null,\n        microsec_slider: null,\n        timezone_select: null,\n        maxTime: null,\n        minTime: null,\n        hour: 0,\n        minute: 0,\n        second: 0,\n        millisec: 0,\n        microsec: 0,\n        timezone: null,\n        hourMinOriginal: null,\n        minuteMinOriginal: null,\n        secondMinOriginal: null,\n        millisecMinOriginal: null,\n        microsecMinOriginal: null,\n        hourMaxOriginal: null,\n        minuteMaxOriginal: null,\n        secondMaxOriginal: null,\n        millisecMaxOriginal: null,\n        microsecMaxOriginal: null,\n        ampm: '',\n        formattedDate: '',\n        formattedTime: '',\n        formattedDateTime: '',\n        timezoneList: null,\n        units: ['hour', 'minute', 'second', 'millisec', 'microsec'],\n        support: {},\n        control: null,\n\n        /*\n        * Override the default settings for all instances of the time picker.\n        * @param  {Object} settings  object - the new settings to use as defaults (anonymous object)\n        * @return {Object} the manager object\n        */\n        setDefaults: function (settings) {\n            extendRemove(this._defaults, settings || {});\n            return this;\n        },\n\n        /*\n        * Create a new Timepicker instance\n        */\n        _newInst: function ($input, opts) {\n            var tp_inst = new Timepicker(),\n                inlineSettings = {},\n                fns = {},\n                overrides, i;\n\n            for (var attrName in this._defaults) {\n                if (this._defaults.hasOwnProperty(attrName)) {\n                    var attrValue = $input.attr('time:' + attrName);\n                    if (attrValue) {\n                        try {\n                            inlineSettings[attrName] = eval(attrValue);\n                        } catch (err) {\n                            inlineSettings[attrName] = attrValue;\n                        }\n                    }\n                }\n            }\n\n            overrides = {\n                beforeShow: function (input, dp_inst) {\n                    if ($.isFunction(tp_inst._defaults.evnts.beforeShow)) {\n                        return tp_inst._defaults.evnts.beforeShow.call($input[0], input, dp_inst, tp_inst);\n                    }\n                },\n                onChangeMonthYear: function (year, month, dp_inst) {\n                    // Update the time as well : this prevents the time from disappearing from the $input field.\n                    // tp_inst._updateDateTime(dp_inst);\n                    if ($.isFunction(tp_inst._defaults.evnts.onChangeMonthYear)) {\n                        tp_inst._defaults.evnts.onChangeMonthYear.call($input[0], year, month, dp_inst, tp_inst);\n                    }\n                },\n                onClose: function (dateText, dp_inst) {\n                    if (tp_inst.timeDefined === true && $input.val() !== '') {\n                        tp_inst._updateDateTime(dp_inst);\n                    }\n                    if ($.isFunction(tp_inst._defaults.evnts.onClose)) {\n                        tp_inst._defaults.evnts.onClose.call($input[0], dateText, dp_inst, tp_inst);\n                    }\n                }\n            };\n            for (i in overrides) {\n                if (overrides.hasOwnProperty(i)) {\n                    fns[i] = opts[i] || this._defaults[i] || null;\n                }\n            }\n\n            tp_inst._defaults = $.extend({}, this._defaults, inlineSettings, opts, overrides, {\n                evnts: fns,\n                timepicker: tp_inst // add timepicker as a property of datepicker: $.datepicker._get(dp_inst, 'timepicker');\n            });\n            tp_inst.amNames = $.map(tp_inst._defaults.amNames, function (val) {\n                return val.toUpperCase();\n            });\n            tp_inst.pmNames = $.map(tp_inst._defaults.pmNames, function (val) {\n                return val.toUpperCase();\n            });\n\n            // detect which units are supported\n            tp_inst.support = detectSupport(\n                tp_inst._defaults.timeFormat +\n                (tp_inst._defaults.pickerTimeFormat ? tp_inst._defaults.pickerTimeFormat : '') +\n                (tp_inst._defaults.altTimeFormat ? tp_inst._defaults.altTimeFormat : ''));\n\n            // controlType is string - key to our this._controls\n            if (typeof(tp_inst._defaults.controlType) === 'string') {\n                if (tp_inst._defaults.controlType === 'slider' && typeof($.ui.slider) === 'undefined') {\n                    tp_inst._defaults.controlType = 'select';\n                }\n                tp_inst.control = tp_inst._controls[tp_inst._defaults.controlType];\n            }\n            // controlType is an object and must implement create, options, value methods\n            else {\n                tp_inst.control = tp_inst._defaults.controlType;\n            }\n\n            // prep the timezone options\n            var timezoneList = [-720, -660, -600, -570, -540, -480, -420, -360, -300, -270, -240, -210, -180, -120, -60,\n                0, 60, 120, 180, 210, 240, 270, 300, 330, 345, 360, 390, 420, 480, 525, 540, 570, 600, 630, 660, 690, 720, 765, 780, 840];\n            if (tp_inst._defaults.timezoneList !== null) {\n                timezoneList = tp_inst._defaults.timezoneList;\n            }\n            var tzl = timezoneList.length, tzi = 0, tzv = null;\n            if (tzl > 0 && typeof timezoneList[0] !== 'object') {\n                for (; tzi < tzl; tzi++) {\n                    tzv = timezoneList[tzi];\n                    timezoneList[tzi] = { value: tzv, label: $.timepicker.timezoneOffsetString(tzv, tp_inst.support.iso8601) };\n                }\n            }\n            tp_inst._defaults.timezoneList = timezoneList;\n\n            // set the default units\n            tp_inst.timezone = tp_inst._defaults.timezone !== null ? $.timepicker.timezoneOffsetNumber(tp_inst._defaults.timezone) :\n                ((new Date()).getTimezoneOffset() * -1);\n            tp_inst.hour = tp_inst._defaults.hour < tp_inst._defaults.hourMin ? tp_inst._defaults.hourMin :\n                tp_inst._defaults.hour > tp_inst._defaults.hourMax ? tp_inst._defaults.hourMax : tp_inst._defaults.hour;\n            tp_inst.minute = tp_inst._defaults.minute < tp_inst._defaults.minuteMin ? tp_inst._defaults.minuteMin :\n                tp_inst._defaults.minute > tp_inst._defaults.minuteMax ? tp_inst._defaults.minuteMax : tp_inst._defaults.minute;\n            tp_inst.second = tp_inst._defaults.second < tp_inst._defaults.secondMin ? tp_inst._defaults.secondMin :\n                tp_inst._defaults.second > tp_inst._defaults.secondMax ? tp_inst._defaults.secondMax : tp_inst._defaults.second;\n            tp_inst.millisec = tp_inst._defaults.millisec < tp_inst._defaults.millisecMin ? tp_inst._defaults.millisecMin :\n                tp_inst._defaults.millisec > tp_inst._defaults.millisecMax ? tp_inst._defaults.millisecMax : tp_inst._defaults.millisec;\n            tp_inst.microsec = tp_inst._defaults.microsec < tp_inst._defaults.microsecMin ? tp_inst._defaults.microsecMin :\n                tp_inst._defaults.microsec > tp_inst._defaults.microsecMax ? tp_inst._defaults.microsecMax : tp_inst._defaults.microsec;\n            tp_inst.ampm = '';\n            tp_inst.$input = $input;\n\n            if (tp_inst._defaults.altField) {\n                tp_inst.$altInput = $(tp_inst._defaults.altField);\n                if (tp_inst._defaults.altRedirectFocus === true) {\n                    tp_inst.$altInput.css({\n                        cursor: 'pointer'\n                    }).focus(function () {\n                        $input.trigger(\"focus\");\n                    });\n                }\n            }\n\n            if (tp_inst._defaults.minDate === 0 || tp_inst._defaults.minDateTime === 0) {\n                tp_inst._defaults.minDate = new Date();\n            }\n            if (tp_inst._defaults.maxDate === 0 || tp_inst._defaults.maxDateTime === 0) {\n                tp_inst._defaults.maxDate = new Date();\n            }\n\n            // datepicker needs minDate/maxDate, timepicker needs minDateTime/maxDateTime..\n            if (tp_inst._defaults.minDate !== undefined && tp_inst._defaults.minDate instanceof Date) {\n                tp_inst._defaults.minDateTime = new Date(tp_inst._defaults.minDate.getTime());\n            }\n            if (tp_inst._defaults.minDateTime !== undefined && tp_inst._defaults.minDateTime instanceof Date) {\n                tp_inst._defaults.minDate = new Date(tp_inst._defaults.minDateTime.getTime());\n            }\n            if (tp_inst._defaults.maxDate !== undefined && tp_inst._defaults.maxDate instanceof Date) {\n                tp_inst._defaults.maxDateTime = new Date(tp_inst._defaults.maxDate.getTime());\n            }\n            if (tp_inst._defaults.maxDateTime !== undefined && tp_inst._defaults.maxDateTime instanceof Date) {\n                tp_inst._defaults.maxDate = new Date(tp_inst._defaults.maxDateTime.getTime());\n            }\n            tp_inst.$input.bind('focus', function () {\n                tp_inst._onFocus();\n            });\n\n            return tp_inst;\n        },\n\n        /*\n        * add our sliders to the calendar\n        */\n        _addTimePicker: function (dp_inst) {\n            var currDT = $.trim((this.$altInput && this._defaults.altFieldTimeOnly) ? this.$input.val() + ' ' + this.$altInput.val() : this.$input.val());\n\n            this.timeDefined = this._parseTime(currDT);\n            this._limitMinMaxDateTime(dp_inst, false);\n            this._injectTimePicker();\n            this._afterInject();\n        },\n\n        /*\n        * parse the time string from input value or _setTime\n        */\n        _parseTime: function (timeString, withDate) {\n            if (!this.inst) {\n                this.inst = $.datepicker._getInst(this.$input[0]);\n            }\n\n            if (withDate || !this._defaults.timeOnly) {\n                var dp_dateFormat = $.datepicker._get(this.inst, 'dateFormat');\n                try {\n                    var parseRes = parseDateTimeInternal(dp_dateFormat, this._defaults.timeFormat, timeString, $.datepicker._getFormatConfig(this.inst), this._defaults);\n                    if (!parseRes.timeObj) {\n                        return false;\n                    }\n                    $.extend(this, parseRes.timeObj);\n                } catch (err) {\n                    $.timepicker.log(\"Error parsing the date/time string: \" + err +\n                        \"\\ndate/time string = \" + timeString +\n                        \"\\ntimeFormat = \" + this._defaults.timeFormat +\n                        \"\\ndateFormat = \" + dp_dateFormat);\n                    return false;\n                }\n                return true;\n            } else {\n                var timeObj = $.datepicker.parseTime(this._defaults.timeFormat, timeString, this._defaults);\n                if (!timeObj) {\n                    return false;\n                }\n                $.extend(this, timeObj);\n                return true;\n            }\n        },\n\n        /*\n        * Handle callback option after injecting timepicker\n        */\n        _afterInject: function() {\n            var o = this.inst.settings;\n            if ($.isFunction(o.afterInject)) {\n                o.afterInject.call(this);\n            }\n        },\n\n        /*\n        * generate and inject html for timepicker into ui datepicker\n        */\n        _injectTimePicker: function () {\n            var $dp = this.inst.dpDiv,\n                o = this.inst.settings,\n                tp_inst = this,\n                litem = '',\n                uitem = '',\n                show = null,\n                max = {},\n                gridSize = {},\n                size = null,\n                i = 0,\n                l = 0;\n\n            // Prevent displaying twice\n            if ($dp.find(\"div.ui-timepicker-div\").length === 0 && o.showTimepicker) {\n                var noDisplay = ' ui_tpicker_unit_hide',\n                    html = '<div class=\"ui-timepicker-div' + (o.isRTL ? ' ui-timepicker-rtl' : '') + (o.oneLine && o.controlType === 'select' ? ' ui-timepicker-oneLine' : '') + '\"><dl>' + '<dt class=\"ui_tpicker_time_label' + ((o.showTime) ? '' : noDisplay) + '\">' + o.timeText + '</dt>' +\n                        '<dd class=\"ui_tpicker_time '+ ((o.showTime) ? '' : noDisplay) + '\"><input class=\"ui_tpicker_time_input\" ' + (o.timeInput ? '' : 'disabled') + '/></dd>';\n\n                // Create the markup\n                for (i = 0, l = this.units.length; i < l; i++) {\n                    litem = this.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // Added by Peter Medeiros:\n                    // - Figure out what the hour/minute/second max should be based on the step values.\n                    // - Example: if stepMinute is 15, then minMax is 45.\n                    max[litem] = parseInt((o[litem + 'Max'] - ((o[litem + 'Max'] - o[litem + 'Min']) % o['step' + uitem])), 10);\n                    gridSize[litem] = 0;\n\n                    html += '<dt class=\"ui_tpicker_' + litem + '_label' + (show ? '' : noDisplay) + '\">' + o[litem + 'Text'] + '</dt>' +\n                        '<dd class=\"ui_tpicker_' + litem + (show ? '' : noDisplay) + '\"><div class=\"ui_tpicker_' + litem + '_slider' + (show ? '' : noDisplay) + '\"></div>';\n\n                    if (show && o[litem + 'Grid'] > 0) {\n                        html += '<div style=\"padding-left: 1px\"><table class=\"ui-tpicker-grid-label\"><tr>';\n\n                        if (litem === 'hour') {\n                            for (var h = o[litem + 'Min']; h <= max[litem]; h += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                var tmph = $.datepicker.formatTime(this.support.ampm ? 'hht' : 'HH', {hour: h}, o);\n                                html += '<td data-for=\"' + litem + '\">' + tmph + '</td>';\n                            }\n                        }\n                        else {\n                            for (var m = o[litem + 'Min']; m <= max[litem]; m += parseInt(o[litem + 'Grid'], 10)) {\n                                gridSize[litem]++;\n                                html += '<td data-for=\"' + litem + '\">' + ((m < 10) ? '0' : '') + m + '</td>';\n                            }\n                        }\n\n                        html += '</tr></table></div>';\n                    }\n                    html += '</dd>';\n                }\n\n                // Timezone\n                var showTz = o.showTimezone !== null ? o.showTimezone : this.support.timezone;\n                html += '<dt class=\"ui_tpicker_timezone_label' + (showTz ? '' : noDisplay) + '\">' + o.timezoneText + '</dt>';\n                html += '<dd class=\"ui_tpicker_timezone' + (showTz ? '' : noDisplay) + '\"></dd>';\n\n                // Create the elements from string\n                html += '</dl></div>';\n                var $tp = $(html);\n\n                // if we only want time picker...\n                if (o.timeOnly === true) {\n                    $tp.prepend('<div class=\"ui-widget-header ui-helper-clearfix ui-corner-all\">' + '<div class=\"ui-datepicker-title\">' + o.timeOnlyTitle + '</div>' + '</div>');\n                    $dp.find('.ui-datepicker-header, .ui-datepicker-calendar').hide();\n                }\n\n                // add sliders, adjust grids, add events\n                for (i = 0, l = tp_inst.units.length; i < l; i++) {\n                    litem = tp_inst.units[i];\n                    uitem = litem.substr(0, 1).toUpperCase() + litem.substr(1);\n                    show = o['show' + uitem] !== null ? o['show' + uitem] : this.support[litem];\n\n                    // add the slider\n                    tp_inst[litem + '_slider'] = tp_inst.control.create(tp_inst, $tp.find('.ui_tpicker_' + litem + '_slider'), litem, tp_inst[litem], o[litem + 'Min'], max[litem], o['step' + uitem]);\n\n                    // adjust the grid and add click event\n                    if (show && o[litem + 'Grid'] > 0) {\n                        size = 100 * gridSize[litem] * o[litem + 'Grid'] / (max[litem] - o[litem + 'Min']);\n                        $tp.find('.ui_tpicker_' + litem + ' table').css({\n                            width: size + \"%\",\n                            marginLeft: o.isRTL ? '0' : ((size / (-2 * gridSize[litem])) + \"%\"),\n                            marginRight: o.isRTL ? ((size / (-2 * gridSize[litem])) + \"%\") : '0',\n                            borderCollapse: 'collapse'\n                        }).find(\"td\").click(function (e) {\n                            var $t = $(this),\n                                h = $t.html(),\n                                n = parseInt(h.replace(/[^0-9]/g), 10),\n                                ap = h.replace(/[^apm]/ig),\n                                f = $t.data('for'); // loses scope, so we use data-for\n\n                            if (f === 'hour') {\n                                if (ap.indexOf('p') !== -1 && n < 12) {\n                                    n += 12;\n                                }\n                                else {\n                                    if (ap.indexOf('a') !== -1 && n === 12) {\n                                        n = 0;\n                                    }\n                                }\n                            }\n\n                            tp_inst.control.value(tp_inst, tp_inst[f + '_slider'], litem, n);\n\n                            tp_inst._onTimeChange();\n                            tp_inst._onSelectHandler();\n                        }).css({\n                            cursor: 'pointer',\n                            width: (100 / gridSize[litem]) + '%',\n                            textAlign: 'center',\n                            overflow: 'hidden'\n                        });\n                    } // end if grid > 0\n                } // end for loop\n\n                // Add timezone options\n                this.timezone_select = $tp.find('.ui_tpicker_timezone').append('<select></select>').find(\"select\");\n                $.fn.append.apply(this.timezone_select,\n                    $.map(o.timezoneList, function (val, idx) {\n                        return $(\"<option />\").val(typeof val === \"object\" ? val.value : val).text(typeof val === \"object\" ? val.label : val);\n                    }));\n                if (typeof(this.timezone) !== \"undefined\" && this.timezone !== null && this.timezone !== \"\") {\n                    var local_timezone = (new Date(this.inst.selectedYear, this.inst.selectedMonth, this.inst.selectedDay, 12)).getTimezoneOffset() * -1;\n                    if (local_timezone === this.timezone) {\n                        selectLocalTimezone(tp_inst);\n                    } else {\n                        this.timezone_select.val(this.timezone);\n                    }\n                } else {\n                    if (typeof(this.hour) !== \"undefined\" && this.hour !== null && this.hour !== \"\") {\n                        this.timezone_select.val(o.timezone);\n                    } else {\n                        selectLocalTimezone(tp_inst);\n                    }\n                }\n                this.timezone_select.change(function () {\n                    tp_inst._onTimeChange();\n                    tp_inst._onSelectHandler();\n                    tp_inst._afterInject();\n                });\n                // End timezone options\n\n                // inject timepicker into datepicker\n                var $buttonPanel = $dp.find('.ui-datepicker-buttonpane');\n                if ($buttonPanel.length) {\n                    $buttonPanel.before($tp);\n                } else {\n                    $dp.append($tp);\n                }\n\n                this.$timeObj = $tp.find('.ui_tpicker_time_input');\n                this.$timeObj.change(function () {\n                    var timeFormat = tp_inst.inst.settings.timeFormat;\n                    var parsedTime = $.datepicker.parseTime(timeFormat, this.value);\n                    var update = new Date();\n                    if (parsedTime) {\n                        update.setHours(parsedTime.hour);\n                        update.setMinutes(parsedTime.minute);\n                        update.setSeconds(parsedTime.second);\n                        $.datepicker._setTime(tp_inst.inst, update);\n                    } else {\n                        this.value = tp_inst.formattedTime;\n                        this.blur();\n                    }\n                });\n\n                if (this.inst !== null) {\n                    var timeDefined = this.timeDefined;\n                    this._onTimeChange();\n                    this.timeDefined = timeDefined;\n                }\n\n                // slideAccess integration: http://trentrichardson.com/2011/11/11/jquery-ui-sliders-and-touch-accessibility/\n                if (this._defaults.addSliderAccess) {\n                    var sliderAccessArgs = this._defaults.sliderAccessArgs,\n                        rtl = this._defaults.isRTL;\n                    sliderAccessArgs.isRTL = rtl;\n\n                    setTimeout(function () { // fix for inline mode\n                        if ($tp.find('.ui-slider-access').length === 0) {\n                            $tp.find('.ui-slider:visible').sliderAccess(sliderAccessArgs);\n\n                            // fix any grids since sliders are shorter\n                            var sliderAccessWidth = $tp.find('.ui-slider-access:eq(0)').outerWidth(true);\n                            if (sliderAccessWidth) {\n                                $tp.find('table:visible').each(function () {\n                                    var $g = $(this),\n                                        oldWidth = $g.outerWidth(),\n                                        oldMarginLeft = $g.css(rtl ? 'marginRight' : 'marginLeft').toString().replace('%', ''),\n                                        newWidth = oldWidth - sliderAccessWidth,\n                                        newMarginLeft = ((oldMarginLeft * newWidth) / oldWidth) + '%',\n                                        css = { width: newWidth, marginRight: 0, marginLeft: 0 };\n                                    css[rtl ? 'marginRight' : 'marginLeft'] = newMarginLeft;\n                                    $g.css(css);\n                                });\n                            }\n                        }\n                    }, 10);\n                }\n                // end slideAccess integration\n\n                tp_inst._limitMinMaxDateTime(this.inst, true);\n            }\n        },\n\n        /*\n        * This function tries to limit the ability to go outside the\n        * min/max date range\n        */\n        _limitMinMaxDateTime: function (dp_inst, adjustSliders) {\n            var o = this._defaults,\n                dp_date = new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay);\n\n            if (!this._defaults.showTimepicker) {\n                return;\n            } // No time so nothing to check here\n\n            if ($.datepicker._get(dp_inst, 'minDateTime') !== null && $.datepicker._get(dp_inst, 'minDateTime') !== undefined && dp_date) {\n                var minDateTime = $.datepicker._get(dp_inst, 'minDateTime'),\n                    minDateTimeDate = new Date(minDateTime.getFullYear(), minDateTime.getMonth(), minDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMinOriginal === null || this.minuteMinOriginal === null || this.secondMinOriginal === null || this.millisecMinOriginal === null || this.microsecMinOriginal === null) {\n                    this.hourMinOriginal = o.hourMin;\n                    this.minuteMinOriginal = o.minuteMin;\n                    this.secondMinOriginal = o.secondMin;\n                    this.millisecMinOriginal = o.millisecMin;\n                    this.microsecMinOriginal = o.microsecMin;\n                }\n\n                if (dp_inst.settings.timeOnly || minDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMin = minDateTime.getHours();\n                    if (this.hour <= this._defaults.hourMin) {\n                        this.hour = this._defaults.hourMin;\n                        this._defaults.minuteMin = minDateTime.getMinutes();\n                        if (this.minute <= this._defaults.minuteMin) {\n                            this.minute = this._defaults.minuteMin;\n                            this._defaults.secondMin = minDateTime.getSeconds();\n                            if (this.second <= this._defaults.secondMin) {\n                                this.second = this._defaults.secondMin;\n                                this._defaults.millisecMin = minDateTime.getMilliseconds();\n                                if (this.millisec <= this._defaults.millisecMin) {\n                                    this.millisec = this._defaults.millisecMin;\n                                    this._defaults.microsecMin = minDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec < this._defaults.microsecMin) {\n                                        this.microsec = this._defaults.microsecMin;\n                                    }\n                                    this._defaults.microsecMin = this.microsecMinOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMin = this.millisecMinOriginal;\n                                this._defaults.microsecMin = this.microsecMinOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMin = this.secondMinOriginal;\n                            this._defaults.millisecMin = this.millisecMinOriginal;\n                            this._defaults.microsecMin = this.microsecMinOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMin = this.minuteMinOriginal;\n                        this._defaults.secondMin = this.secondMinOriginal;\n                        this._defaults.millisecMin = this.millisecMinOriginal;\n                        this._defaults.microsecMin = this.microsecMinOriginal;\n                    }\n                } else {\n                    this._defaults.hourMin = this.hourMinOriginal;\n                    this._defaults.minuteMin = this.minuteMinOriginal;\n                    this._defaults.secondMin = this.secondMinOriginal;\n                    this._defaults.millisecMin = this.millisecMinOriginal;\n                    this._defaults.microsecMin = this.microsecMinOriginal;\n                }\n            }\n\n            if ($.datepicker._get(dp_inst, 'maxDateTime') !== null && $.datepicker._get(dp_inst, 'maxDateTime') !== undefined && dp_date) {\n                var maxDateTime = $.datepicker._get(dp_inst, 'maxDateTime'),\n                    maxDateTimeDate = new Date(maxDateTime.getFullYear(), maxDateTime.getMonth(), maxDateTime.getDate(), 0, 0, 0, 0);\n\n                if (this.hourMaxOriginal === null || this.minuteMaxOriginal === null || this.secondMaxOriginal === null || this.millisecMaxOriginal === null) {\n                    this.hourMaxOriginal = o.hourMax;\n                    this.minuteMaxOriginal = o.minuteMax;\n                    this.secondMaxOriginal = o.secondMax;\n                    this.millisecMaxOriginal = o.millisecMax;\n                    this.microsecMaxOriginal = o.microsecMax;\n                }\n\n                if (dp_inst.settings.timeOnly || maxDateTimeDate.getTime() === dp_date.getTime()) {\n                    this._defaults.hourMax = maxDateTime.getHours();\n                    if (this.hour >= this._defaults.hourMax) {\n                        this.hour = this._defaults.hourMax;\n                        this._defaults.minuteMax = maxDateTime.getMinutes();\n                        if (this.minute >= this._defaults.minuteMax) {\n                            this.minute = this._defaults.minuteMax;\n                            this._defaults.secondMax = maxDateTime.getSeconds();\n                            if (this.second >= this._defaults.secondMax) {\n                                this.second = this._defaults.secondMax;\n                                this._defaults.millisecMax = maxDateTime.getMilliseconds();\n                                if (this.millisec >= this._defaults.millisecMax) {\n                                    this.millisec = this._defaults.millisecMax;\n                                    this._defaults.microsecMax = maxDateTime.getMicroseconds();\n                                } else {\n                                    if (this.microsec > this._defaults.microsecMax) {\n                                        this.microsec = this._defaults.microsecMax;\n                                    }\n                                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                                }\n                            } else {\n                                this._defaults.millisecMax = this.millisecMaxOriginal;\n                                this._defaults.microsecMax = this.microsecMaxOriginal;\n                            }\n                        } else {\n                            this._defaults.secondMax = this.secondMaxOriginal;\n                            this._defaults.millisecMax = this.millisecMaxOriginal;\n                            this._defaults.microsecMax = this.microsecMaxOriginal;\n                        }\n                    } else {\n                        this._defaults.minuteMax = this.minuteMaxOriginal;\n                        this._defaults.secondMax = this.secondMaxOriginal;\n                        this._defaults.millisecMax = this.millisecMaxOriginal;\n                        this._defaults.microsecMax = this.microsecMaxOriginal;\n                    }\n                } else {\n                    this._defaults.hourMax = this.hourMaxOriginal;\n                    this._defaults.minuteMax = this.minuteMaxOriginal;\n                    this._defaults.secondMax = this.secondMaxOriginal;\n                    this._defaults.millisecMax = this.millisecMaxOriginal;\n                    this._defaults.microsecMax = this.microsecMaxOriginal;\n                }\n            }\n\n            if (dp_inst.settings.minTime!==null) {\n                var tempMinTime=new Date(\"01/01/1970 \" + dp_inst.settings.minTime);\n                if (this.hour<tempMinTime.getHours()) {\n                    this.hour=this._defaults.hourMin=tempMinTime.getHours();\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else if (this.hour===tempMinTime.getHours() && this.minute<tempMinTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMin=tempMinTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMin<tempMinTime.getHours()) {\n                        this._defaults.hourMin=tempMinTime.getHours();\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else if (this._defaults.hourMin===tempMinTime.getHours()===this.hour && this._defaults.minuteMin<tempMinTime.getMinutes()) {\n                        this._defaults.minuteMin=tempMinTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMin=0;\n                    }\n                }\n            }\n\n            if (dp_inst.settings.maxTime!==null) {\n                var tempMaxTime=new Date(\"01/01/1970 \" + dp_inst.settings.maxTime);\n                if (this.hour>tempMaxTime.getHours()) {\n                    this.hour=this._defaults.hourMax=tempMaxTime.getHours();\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else if (this.hour===tempMaxTime.getHours() && this.minute>tempMaxTime.getMinutes()) {\n                    this.minute=this._defaults.minuteMax=tempMaxTime.getMinutes();\n                } else {\n                    if (this._defaults.hourMax>tempMaxTime.getHours()) {\n                        this._defaults.hourMax=tempMaxTime.getHours();\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else if (this._defaults.hourMax===tempMaxTime.getHours()===this.hour && this._defaults.minuteMax>tempMaxTime.getMinutes()) {\n                        this._defaults.minuteMax=tempMaxTime.getMinutes();\n                    } else {\n                        this._defaults.minuteMax=59;\n                    }\n                }\n            }\n\n            if (adjustSliders !== undefined && adjustSliders === true) {\n                var hourMax = parseInt((this._defaults.hourMax - ((this._defaults.hourMax - this._defaults.hourMin) % this._defaults.stepHour)), 10),\n                    minMax = parseInt((this._defaults.minuteMax - ((this._defaults.minuteMax - this._defaults.minuteMin) % this._defaults.stepMinute)), 10),\n                    secMax = parseInt((this._defaults.secondMax - ((this._defaults.secondMax - this._defaults.secondMin) % this._defaults.stepSecond)), 10),\n                    millisecMax = parseInt((this._defaults.millisecMax - ((this._defaults.millisecMax - this._defaults.millisecMin) % this._defaults.stepMillisec)), 10),\n                    microsecMax = parseInt((this._defaults.microsecMax - ((this._defaults.microsecMax - this._defaults.microsecMin) % this._defaults.stepMicrosec)), 10);\n\n                if (this.hour_slider) {\n                    this.control.options(this, this.hour_slider, 'hour', { min: this._defaults.hourMin, max: hourMax, step: this._defaults.stepHour });\n                    this.control.value(this, this.hour_slider, 'hour', this.hour - (this.hour % this._defaults.stepHour));\n                }\n                if (this.minute_slider) {\n                    this.control.options(this, this.minute_slider, 'minute', { min: this._defaults.minuteMin, max: minMax, step: this._defaults.stepMinute });\n                    this.control.value(this, this.minute_slider, 'minute', this.minute - (this.minute % this._defaults.stepMinute));\n                }\n                if (this.second_slider) {\n                    this.control.options(this, this.second_slider, 'second', { min: this._defaults.secondMin, max: secMax, step: this._defaults.stepSecond });\n                    this.control.value(this, this.second_slider, 'second', this.second - (this.second % this._defaults.stepSecond));\n                }\n                if (this.millisec_slider) {\n                    this.control.options(this, this.millisec_slider, 'millisec', { min: this._defaults.millisecMin, max: millisecMax, step: this._defaults.stepMillisec });\n                    this.control.value(this, this.millisec_slider, 'millisec', this.millisec - (this.millisec % this._defaults.stepMillisec));\n                }\n                if (this.microsec_slider) {\n                    this.control.options(this, this.microsec_slider, 'microsec', { min: this._defaults.microsecMin, max: microsecMax, step: this._defaults.stepMicrosec });\n                    this.control.value(this, this.microsec_slider, 'microsec', this.microsec - (this.microsec % this._defaults.stepMicrosec));\n                }\n            }\n\n        },\n\n        /*\n        * when a slider moves, set the internal time...\n        * on time change is also called when the time is updated in the text field\n        */\n        _onTimeChange: function () {\n            if (!this._defaults.showTimepicker) {\n                return;\n            }\n            var hour = (this.hour_slider) ? this.control.value(this, this.hour_slider, 'hour') : false,\n                minute = (this.minute_slider) ? this.control.value(this, this.minute_slider, 'minute') : false,\n                second = (this.second_slider) ? this.control.value(this, this.second_slider, 'second') : false,\n                millisec = (this.millisec_slider) ? this.control.value(this, this.millisec_slider, 'millisec') : false,\n                microsec = (this.microsec_slider) ? this.control.value(this, this.microsec_slider, 'microsec') : false,\n                timezone = (this.timezone_select) ? this.timezone_select.val() : false,\n                o = this._defaults,\n                pickerTimeFormat = o.pickerTimeFormat || o.timeFormat,\n                pickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;\n\n            if (typeof(hour) === 'object') {\n                hour = false;\n            }\n            if (typeof(minute) === 'object') {\n                minute = false;\n            }\n            if (typeof(second) === 'object') {\n                second = false;\n            }\n            if (typeof(millisec) === 'object') {\n                millisec = false;\n            }\n            if (typeof(microsec) === 'object') {\n                microsec = false;\n            }\n            if (typeof(timezone) === 'object') {\n                timezone = false;\n            }\n\n            if (hour !== false) {\n                hour = parseInt(hour, 10);\n            }\n            if (minute !== false) {\n                minute = parseInt(minute, 10);\n            }\n            if (second !== false) {\n                second = parseInt(second, 10);\n            }\n            if (millisec !== false) {\n                millisec = parseInt(millisec, 10);\n            }\n            if (microsec !== false) {\n                microsec = parseInt(microsec, 10);\n            }\n            if (timezone !== false) {\n                timezone = timezone.toString();\n            }\n\n            var ampm = o[hour < 12 ? 'amNames' : 'pmNames'][0];\n\n            // If the update was done in the input field, the input field should not be updated.\n            // If the update was done using the sliders, update the input field.\n            var hasChanged = (\n                hour !== parseInt(this.hour,10) || // sliders should all be numeric\n                minute !== parseInt(this.minute,10) ||\n                second !== parseInt(this.second,10) ||\n                millisec !== parseInt(this.millisec,10) ||\n                microsec !== parseInt(this.microsec,10) ||\n                (this.ampm.length > 0 && (hour < 12) !== ($.inArray(this.ampm.toUpperCase(), this.amNames) !== -1)) ||\n                (this.timezone !== null && timezone !== this.timezone.toString()) // could be numeric or \"EST\" format, so use toString()\n            );\n\n            if (hasChanged) {\n\n                if (hour !== false) {\n                    this.hour = hour;\n                }\n                if (minute !== false) {\n                    this.minute = minute;\n                }\n                if (second !== false) {\n                    this.second = second;\n                }\n                if (millisec !== false) {\n                    this.millisec = millisec;\n                }\n                if (microsec !== false) {\n                    this.microsec = microsec;\n                }\n                if (timezone !== false) {\n                    this.timezone = timezone;\n                }\n\n                if (!this.inst) {\n                    this.inst = $.datepicker._getInst(this.$input[0]);\n                }\n\n                this._limitMinMaxDateTime(this.inst, true);\n            }\n            if (this.support.ampm) {\n                this.ampm = ampm;\n            }\n\n            // Updates the time within the timepicker\n            this.formattedTime = $.datepicker.formatTime(o.timeFormat, this, o);\n            if (this.$timeObj) {\n                if (pickerTimeFormat === o.timeFormat) {\n                    this.$timeObj.val(this.formattedTime + pickerTimeSuffix);\n                }\n                else {\n                    this.$timeObj.val($.datepicker.formatTime(pickerTimeFormat, this, o) + pickerTimeSuffix);\n                }\n                if (this.$timeObj[0].setSelectionRange) {\n                    var sPos = this.$timeObj[0].selectionStart;\n                    var ePos = this.$timeObj[0].selectionEnd;\n                    this.$timeObj[0].setSelectionRange(sPos, ePos);\n                }\n            }\n\n            this.timeDefined = true;\n            if (hasChanged) {\n                this._updateDateTime();\n                //this.$input.focus(); // may automatically open the picker on setDate\n            }\n        },\n\n        /*\n        * call custom onSelect.\n        * bind to sliders slidestop, and grid click.\n        */\n        _onSelectHandler: function () {\n            var onSelect = this._defaults.onSelect || this.inst.settings.onSelect;\n            var inputEl = this.$input ? this.$input[0] : null;\n            if (onSelect && inputEl) {\n                onSelect.apply(inputEl, [this.formattedDateTime, this]);\n            }\n        },\n\n        /*\n        * update our input with the new date time..\n        */\n        _updateDateTime: function (dp_inst) {\n            dp_inst = this.inst || dp_inst;\n            var dtTmp = (dp_inst.currentYear > 0?\n                new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay) :\n                new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                dt = $.datepicker._daylightSavingAdjust(dtTmp),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.selectedYear, dp_inst.selectedMonth, dp_inst.selectedDay)),\n                //dt = $.datepicker._daylightSavingAdjust(new Date(dp_inst.currentYear, dp_inst.currentMonth, dp_inst.currentDay)),\n                dateFmt = $.datepicker._get(dp_inst, 'dateFormat'),\n                formatCfg = $.datepicker._getFormatConfig(dp_inst),\n                timeAvailable = dt !== null && this.timeDefined;\n            this.formattedDate = $.datepicker.formatDate(dateFmt, (dt === null ? new Date() : dt), formatCfg);\n            var formattedDateTime = this.formattedDate;\n\n            // if a slider was changed but datepicker doesn't have a value yet, set it\n            if (dp_inst.lastVal === \"\") {\n                dp_inst.currentYear = dp_inst.selectedYear;\n                dp_inst.currentMonth = dp_inst.selectedMonth;\n                dp_inst.currentDay = dp_inst.selectedDay;\n            }\n\n            /*\n            * remove following lines to force every changes in date picker to change the input value\n            * Bug descriptions: when an input field has a default value, and click on the field to pop up the date picker.\n            * If the user manually empty the value in the input field, the date picker will never change selected value.\n            */\n            //if (dp_inst.lastVal !== undefined && (dp_inst.lastVal.length > 0 && this.$input.val().length === 0)) {\n            //\treturn;\n            //}\n\n            if (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === false) {\n                formattedDateTime = this.formattedTime;\n            } else if ((this._defaults.timeOnly !== true && (this._defaults.alwaysSetTime || timeAvailable)) || (this._defaults.timeOnly === true && this._defaults.timeOnlyShowDate === true)) {\n                formattedDateTime += this._defaults.separator + this.formattedTime + this._defaults.timeSuffix;\n            }\n\n            this.formattedDateTime = formattedDateTime;\n\n            if (!this._defaults.showTimepicker) {\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput && this._defaults.timeOnly === false && this._defaults.altFieldTimeOnly === true) {\n                this.$altInput.val(this.formattedTime);\n                this.$input.val(this.formattedDate);\n            } else if (this.$altInput) {\n                this.$input.val(formattedDateTime);\n                var altFormattedDateTime = '',\n                    altSeparator = this._defaults.altSeparator !== null ? this._defaults.altSeparator : this._defaults.separator,\n                    altTimeSuffix = this._defaults.altTimeSuffix !== null ? this._defaults.altTimeSuffix : this._defaults.timeSuffix;\n\n                if (!this._defaults.timeOnly) {\n                    if (this._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(this._defaults.altFormat, (dt === null ? new Date() : dt), formatCfg);\n                    }\n                    else {\n                        altFormattedDateTime = this.formattedDate;\n                    }\n\n                    if (altFormattedDateTime) {\n                        altFormattedDateTime += altSeparator;\n                    }\n                }\n\n                if (this._defaults.altTimeFormat !== null) {\n                    altFormattedDateTime += $.datepicker.formatTime(this._defaults.altTimeFormat, this, this._defaults) + altTimeSuffix;\n                }\n                else {\n                    altFormattedDateTime += this.formattedTime + altTimeSuffix;\n                }\n                this.$altInput.val(altFormattedDateTime);\n            } else {\n                this.$input.val(formattedDateTime);\n            }\n\n            this.$input.trigger(\"change\");\n        },\n\n        _onFocus: function () {\n            if (!this.$input.val() && this._defaults.defaultValue) {\n                this.$input.val(this._defaults.defaultValue);\n                var inst = $.datepicker._getInst(this.$input.get(0)),\n                    tp_inst = $.datepicker._get(inst, 'timepicker');\n                if (tp_inst) {\n                    if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                        try {\n                            $.datepicker._updateDatepicker(inst);\n                        } catch (err) {\n                            $.timepicker.log(err);\n                        }\n                    }\n                }\n            }\n        },\n\n        /*\n        * Small abstraction to control types\n        * We can add more, just be sure to follow the pattern: create, options, value\n        */\n        _controls: {\n            // slider methods\n            slider: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var rtl = tp_inst._defaults.isRTL; // if rtl go -60->0 instead of 0->60\n                    return obj.prop('slide', null).slider({\n                        orientation: \"horizontal\",\n                        value: rtl ? val * -1 : val,\n                        min: rtl ? max * -1 : min,\n                        max: rtl ? min * -1 : max,\n                        step: step,\n                        slide: function (event, ui) {\n                            tp_inst.control.value(tp_inst, $(this), unit, rtl ? ui.value * -1 : ui.value);\n                            tp_inst._onTimeChange();\n                        },\n                        stop: function (event, ui) {\n                            tp_inst._onSelectHandler();\n                        }\n                    });\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (typeof(opts) === 'string') {\n                            if (opts === 'min' || opts === 'max') {\n                                if (val !== undefined) {\n                                    return obj.slider(opts, val * -1);\n                                }\n                                return Math.abs(obj.slider(opts));\n                            }\n                            return obj.slider(opts);\n                        }\n                        var min = opts.min,\n                            max = opts.max;\n                        opts.min = opts.max = null;\n                        if (min !== undefined) {\n                            opts.max = min * -1;\n                        }\n                        if (max !== undefined) {\n                            opts.min = max * -1;\n                        }\n                        return obj.slider(opts);\n                    }\n                    if (typeof(opts) === 'string' && val !== undefined) {\n                        return obj.slider(opts, val);\n                    }\n                    return obj.slider(opts);\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    if (tp_inst._defaults.isRTL) {\n                        if (val !== undefined) {\n                            return obj.slider('value', val * -1);\n                        }\n                        return Math.abs(obj.slider('value'));\n                    }\n                    if (val !== undefined) {\n                        return obj.slider('value', val);\n                    }\n                    return obj.slider('value');\n                }\n            },\n            // select methods\n            select: {\n                create: function (tp_inst, obj, unit, val, min, max, step) {\n                    var sel = '<select class=\"ui-timepicker-select ui-state-default ui-corner-all\" data-unit=\"' + unit + '\" data-min=\"' + min + '\" data-max=\"' + max + '\" data-step=\"' + step + '\">',\n                        format = tp_inst._defaults.pickerTimeFormat || tp_inst._defaults.timeFormat;\n\n                    for (var i = min; i <= max; i += step) {\n                        sel += '<option value=\"' + i + '\"' + (i === val ? ' selected' : '') + '>';\n                        if (unit === 'hour') {\n                            sel += $.datepicker.formatTime($.trim(format.replace(/[^ht ]/ig, '')), {hour: i}, tp_inst._defaults);\n                        }\n                        else if (unit === 'millisec' || unit === 'microsec' || i >= 10) { sel += i; }\n                        else {sel += '0' + i.toString(); }\n                        sel += '</option>';\n                    }\n                    sel += '</select>';\n\n                    obj.children('select').remove();\n\n                    $(sel).appendTo(obj).change(function (e) {\n                        tp_inst._onTimeChange();\n                        tp_inst._onSelectHandler();\n                        tp_inst._afterInject();\n                    });\n\n                    return obj;\n                },\n                options: function (tp_inst, obj, unit, opts, val) {\n                    var o = {},\n                        $t = obj.children('select');\n                    if (typeof(opts) === 'string') {\n                        if (val === undefined) {\n                            return $t.data(opts);\n                        }\n                        o[opts] = val;\n                    }\n                    else { o = opts; }\n                    return tp_inst.control.create(tp_inst, obj, $t.data('unit'), $t.val(), o.min>=0 ? o.min : $t.data('min'), o.max || $t.data('max'), o.step || $t.data('step'));\n                },\n                value: function (tp_inst, obj, unit, val) {\n                    var $t = obj.children('select');\n                    if (val !== undefined) {\n                        return $t.val(val);\n                    }\n                    return $t.val();\n                }\n            }\n        } // end _controls\n\n    });\n\n    $.fn.extend({\n        /*\n        * shorthand just to use timepicker.\n        */\n        timepicker: function (o) {\n            o = o || {};\n            var tmp_args = Array.prototype.slice.call(arguments);\n\n            if (typeof o === 'object') {\n                tmp_args[0] = $.extend(o, {\n                    timeOnly: true\n                });\n            }\n\n            return $(this).each(function () {\n                $.fn.datetimepicker.apply($(this), tmp_args);\n            });\n        },\n\n        /*\n        * extend timepicker to datepicker\n        */\n        datetimepicker: function (o) {\n            o = o || {};\n            var tmp_args = arguments;\n\n            if (typeof(o) === 'string') {\n                if (o === 'getDate'  || (o === 'option' && tmp_args.length === 2 && typeof (tmp_args[1]) === 'string')) {\n                    return $.fn.datepicker.apply($(this[0]), tmp_args);\n                } else {\n                    return this.each(function () {\n                        var $t = $(this);\n                        $t.datepicker.apply($t, tmp_args);\n                    });\n                }\n            } else {\n                return this.each(function () {\n                    var $t = $(this);\n                    $t.datepicker($.timepicker._newInst($t, o)._defaults);\n                });\n            }\n        }\n    });\n\n    /*\n    * Public Utility to parse date and time\n    */\n    $.datepicker.parseDateTime = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var parseRes = parseDateTimeInternal(dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings);\n        if (parseRes.timeObj) {\n            var t = parseRes.timeObj;\n            parseRes.date.setHours(t.hour, t.minute, t.second, t.millisec);\n            parseRes.date.setMicroseconds(t.microsec);\n        }\n\n        return parseRes.date;\n    };\n\n    /*\n    * Public utility to parse time\n    */\n    $.datepicker.parseTime = function (timeFormat, timeString, options) {\n        var o = extendRemove(extendRemove({}, $.timepicker._defaults), options || {}),\n            iso8601 = (timeFormat.replace(/\\'.*?\\'/g, '').indexOf('Z') !== -1);\n\n        // Strict parse requires the timeString to match the timeFormat exactly\n        var strictParse = function (f, s, o) {\n\n            // pattern for standard and localized AM/PM markers\n            var getPatternAmpm = function (amNames, pmNames) {\n                var markers = [];\n                if (amNames) {\n                    $.merge(markers, amNames);\n                }\n                if (pmNames) {\n                    $.merge(markers, pmNames);\n                }\n                markers = $.map(markers, function (val) {\n                    return val.replace(/[.*+?|()\\[\\]{}\\\\]/g, '\\\\$&');\n                });\n                return '(' + markers.join('|') + ')?';\n            };\n\n            // figure out position of time elements.. cause js cant do named captures\n            var getFormatPositions = function (timeFormat) {\n                var finds = timeFormat.toLowerCase().match(/(h{1,2}|m{1,2}|s{1,2}|l{1}|c{1}|t{1,2}|z|'.*?')/g),\n                    orders = {\n                        h: -1,\n                        m: -1,\n                        s: -1,\n                        l: -1,\n                        c: -1,\n                        t: -1,\n                        z: -1\n                    };\n\n                if (finds) {\n                    for (var i = 0; i < finds.length; i++) {\n                        if (orders[finds[i].toString().charAt(0)] === -1) {\n                            orders[finds[i].toString().charAt(0)] = i + 1;\n                        }\n                    }\n                }\n                return orders;\n            };\n\n            var regstr = '^' + f.toString()\n                    .replace(/([hH]{1,2}|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n                        var ml = match.length;\n                        switch (match.charAt(0).toLowerCase()) {\n                            case 'h':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'm':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 's':\n                                return ml === 1 ? '(\\\\d?\\\\d)' : '(\\\\d{' + ml + '})';\n                            case 'l':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'c':\n                                return '(\\\\d?\\\\d?\\\\d)';\n                            case 'z':\n                                return '(z|[-+]\\\\d\\\\d:?\\\\d\\\\d|\\\\S+)?';\n                            case 't':\n                                return getPatternAmpm(o.amNames, o.pmNames);\n                            default:    // literal escaped in quotes\n                                return '(' + match.replace(/\\'/g, \"\").replace(/(\\.|\\$|\\^|\\\\|\\/|\\(|\\)|\\[|\\]|\\?|\\+|\\*)/g, function (m) { return \"\\\\\" + m; }) + ')?';\n                        }\n                    })\n                    .replace(/\\s/g, '\\\\s?') +\n                o.timeSuffix + '$',\n                order = getFormatPositions(f),\n                ampm = '',\n                treg;\n\n            treg = s.match(new RegExp(regstr, 'i'));\n\n            var resTime = {\n                hour: 0,\n                minute: 0,\n                second: 0,\n                millisec: 0,\n                microsec: 0\n            };\n\n            if (treg) {\n                if (order.t !== -1) {\n                    if (treg[order.t] === undefined || treg[order.t].length === 0) {\n                        ampm = '';\n                        resTime.ampm = '';\n                    } else {\n                        ampm = $.inArray(treg[order.t].toUpperCase(), $.map(o.amNames, function (x,i) { return x.toUpperCase(); })) !== -1 ? 'AM' : 'PM';\n                        resTime.ampm = o[ampm === 'AM' ? 'amNames' : 'pmNames'][0];\n                    }\n                }\n\n                if (order.h !== -1) {\n                    if (ampm === 'AM' && treg[order.h] === '12') {\n                        resTime.hour = 0; // 12am = 0 hour\n                    } else {\n                        if (ampm === 'PM' && treg[order.h] !== '12') {\n                            resTime.hour = parseInt(treg[order.h], 10) + 12; // 12pm = 12 hour, any other pm = hour + 12\n                        } else {\n                            resTime.hour = Number(treg[order.h]);\n                        }\n                    }\n                }\n\n                if (order.m !== -1) {\n                    resTime.minute = Number(treg[order.m]);\n                }\n                if (order.s !== -1) {\n                    resTime.second = Number(treg[order.s]);\n                }\n                if (order.l !== -1) {\n                    resTime.millisec = Number(treg[order.l]);\n                }\n                if (order.c !== -1) {\n                    resTime.microsec = Number(treg[order.c]);\n                }\n                if (order.z !== -1 && treg[order.z] !== undefined) {\n                    resTime.timezone = $.timepicker.timezoneOffsetNumber(treg[order.z]);\n                }\n\n\n                return resTime;\n            }\n            return false;\n        };// end strictParse\n\n        // First try JS Date, if that fails, use strictParse\n        var looseParse = function (f, s, o) {\n            try {\n                var d = new Date('2012-01-01 ' + s);\n                if (isNaN(d.getTime())) {\n                    d = new Date('2012-01-01T' + s);\n                    if (isNaN(d.getTime())) {\n                        d = new Date('01/01/2012 ' + s);\n                        if (isNaN(d.getTime())) {\n                            throw \"Unable to parse time with native Date: \" + s;\n                        }\n                    }\n                }\n\n                return {\n                    hour: d.getHours(),\n                    minute: d.getMinutes(),\n                    second: d.getSeconds(),\n                    millisec: d.getMilliseconds(),\n                    microsec: d.getMicroseconds(),\n                    timezone: d.getTimezoneOffset() * -1\n                };\n            }\n            catch (err) {\n                try {\n                    return strictParse(f, s, o);\n                }\n                catch (err2) {\n                    $.timepicker.log(\"Unable to parse \\ntimeString: \" + s + \"\\ntimeFormat: \" + f);\n                }\n            }\n            return false;\n        }; // end looseParse\n\n        if (typeof o.parse === \"function\") {\n            return o.parse(timeFormat, timeString, o);\n        }\n        if (o.parse === 'loose') {\n            return looseParse(timeFormat, timeString, o);\n        }\n        return strictParse(timeFormat, timeString, o);\n    };\n\n    /**\n     * Public utility to format the time\n     * @param {string} format format of the time\n     * @param {Object} time Object not a Date for timezones\n     * @param {Object} [options] essentially the regional[].. amNames, pmNames, ampm\n     * @returns {string} the formatted time\n     */\n    $.datepicker.formatTime = function (format, time, options) {\n        options = options || {};\n        options = $.extend({}, $.timepicker._defaults, options);\n        time = $.extend({\n            hour: 0,\n            minute: 0,\n            second: 0,\n            millisec: 0,\n            microsec: 0,\n            timezone: null\n        }, time);\n\n        var tmptime = format,\n            ampmName = options.amNames[0],\n            hour = parseInt(time.hour, 10);\n\n        if (hour > 11) {\n            ampmName = options.pmNames[0];\n        }\n\n        tmptime = tmptime.replace(/(?:HH?|hh?|mm?|ss?|[tT]{1,2}|[zZ]|[lc]|'.*?')/g, function (match) {\n            switch (match) {\n                case 'HH':\n                    return ('0' + hour).slice(-2);\n                case 'H':\n                    return hour;\n                case 'hh':\n                    return ('0' + convert24to12(hour)).slice(-2);\n                case 'h':\n                    return convert24to12(hour);\n                case 'mm':\n                    return ('0' + time.minute).slice(-2);\n                case 'm':\n                    return time.minute;\n                case 'ss':\n                    return ('0' + time.second).slice(-2);\n                case 's':\n                    return time.second;\n                case 'l':\n                    return ('00' + time.millisec).slice(-3);\n                case 'c':\n                    return ('00' + time.microsec).slice(-3);\n                case 'z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, false);\n                case 'Z':\n                    return $.timepicker.timezoneOffsetString(time.timezone === null ? options.timezone : time.timezone, true);\n                case 'T':\n                    return ampmName.charAt(0).toUpperCase();\n                case 'TT':\n                    return ampmName.toUpperCase();\n                case 't':\n                    return ampmName.charAt(0).toLowerCase();\n                case 'tt':\n                    return ampmName.toLowerCase();\n                default:\n                    return match.replace(/'/g, \"\");\n            }\n        });\n\n        return tmptime;\n    };\n\n    /*\n    * the bad hack :/ override datepicker so it doesn't close on select\n    // inspired: http://stackoverflow.com/questions/1252512/jquery-datepicker-prevent-closing-picker-when-clicking-a-date/1762378#1762378\n    */\n    $.datepicker._base_selectDate = $.datepicker._selectDate;\n    $.datepicker._selectDate = function (id, dateStr) {\n        var inst = this._getInst($(id)[0]),\n            tp_inst = this._get(inst, 'timepicker'),\n            was_inline;\n\n        if (tp_inst && inst.settings.showTimepicker) {\n            tp_inst._limitMinMaxDateTime(inst, true);\n            was_inline = inst.inline;\n            inst.inline = inst.stay_open = true;\n            //This way the onSelect handler called from calendarpicker get the full dateTime\n            this._base_selectDate(id, dateStr);\n            inst.inline = was_inline;\n            inst.stay_open = false;\n            this._notifyChange(inst);\n            this._updateDatepicker(inst);\n        } else {\n            this._base_selectDate(id, dateStr);\n        }\n    };\n\n    /*\n    * second bad hack :/ override datepicker so it triggers an event when changing the input field\n    * and does not redraw the datepicker on every selectDate event\n    */\n    $.datepicker._base_updateDatepicker = $.datepicker._updateDatepicker;\n    $.datepicker._updateDatepicker = function (inst) {\n\n        // don't popup the datepicker if there is another instance already opened\n        var input = inst.input[0];\n        if ($.datepicker._curInst && $.datepicker._curInst !== inst && $.datepicker._datepickerShowing && $.datepicker._lastInput !== input) {\n            return;\n        }\n\n        if (typeof(inst.stay_open) !== 'boolean' || inst.stay_open === false) {\n\n            this._base_updateDatepicker(inst);\n\n            // Reload the time control when changing something in the input text field.\n            var tp_inst = this._get(inst, 'timepicker');\n            if (tp_inst) {\n                tp_inst._addTimePicker(inst);\n            }\n        }\n    };\n\n    /*\n    * third bad hack :/ override datepicker so it allows spaces and colon in the input field\n    */\n    $.datepicker._base_doKeyPress = $.datepicker._doKeyPress;\n    $.datepicker._doKeyPress = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if ($.datepicker._get(inst, 'constrainInput')) {\n                var ampm = tp_inst.support.ampm,\n                    tz = tp_inst._defaults.showTimezone !== null ? tp_inst._defaults.showTimezone : tp_inst.support.timezone,\n                    dateChars = $.datepicker._possibleChars($.datepicker._get(inst, 'dateFormat')),\n                    datetimeChars = tp_inst._defaults.timeFormat.toString()\n                            .replace(/[hms]/g, '')\n                            .replace(/TT/g, ampm ? 'APM' : '')\n                            .replace(/Tt/g, ampm ? 'AaPpMm' : '')\n                            .replace(/tT/g, ampm ? 'AaPpMm' : '')\n                            .replace(/T/g, ampm ? 'AP' : '')\n                            .replace(/tt/g, ampm ? 'apm' : '')\n                            .replace(/t/g, ampm ? 'ap' : '') +\n                        \" \" + tp_inst._defaults.separator +\n                        tp_inst._defaults.timeSuffix +\n                        (tz ? tp_inst._defaults.timezoneList.join('') : '') +\n                        (tp_inst._defaults.amNames.join('')) + (tp_inst._defaults.pmNames.join('')) +\n                        dateChars,\n                    chr = String.fromCharCode(event.charCode === undefined ? event.keyCode : event.charCode);\n                return event.ctrlKey || (chr < ' ' || !dateChars || datetimeChars.indexOf(chr) > -1);\n            }\n        }\n\n        return $.datepicker._base_doKeyPress(event);\n    };\n\n    /*\n    * Fourth bad hack :/ override _updateAlternate function used in inline mode to init altField\n    * Update any alternate field to synchronise with the main field.\n    */\n    $.datepicker._base_updateAlternate = $.datepicker._updateAlternate;\n    $.datepicker._updateAlternate = function (inst) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var altField = tp_inst._defaults.altField;\n            if (altField) { // update alternate field too\n                var altFormat = tp_inst._defaults.altFormat || tp_inst._defaults.dateFormat,\n                    date = this._getDate(inst),\n                    formatCfg = $.datepicker._getFormatConfig(inst),\n                    altFormattedDateTime = '',\n                    altSeparator = tp_inst._defaults.altSeparator ? tp_inst._defaults.altSeparator : tp_inst._defaults.separator,\n                    altTimeSuffix = tp_inst._defaults.altTimeSuffix ? tp_inst._defaults.altTimeSuffix : tp_inst._defaults.timeSuffix,\n                    altTimeFormat = tp_inst._defaults.altTimeFormat !== null ? tp_inst._defaults.altTimeFormat : tp_inst._defaults.timeFormat;\n\n                altFormattedDateTime += $.datepicker.formatTime(altTimeFormat, tp_inst, tp_inst._defaults) + altTimeSuffix;\n                if (!tp_inst._defaults.timeOnly && !tp_inst._defaults.altFieldTimeOnly && date !== null) {\n                    if (tp_inst._defaults.altFormat) {\n                        altFormattedDateTime = $.datepicker.formatDate(tp_inst._defaults.altFormat, date, formatCfg) + altSeparator + altFormattedDateTime;\n                    }\n                    else {\n                        altFormattedDateTime = tp_inst.formattedDate + altSeparator + altFormattedDateTime;\n                    }\n                }\n                $(altField).val( inst.input.val() ? altFormattedDateTime : \"\");\n            }\n        }\n        else {\n            $.datepicker._base_updateAlternate(inst);\n        }\n    };\n\n    /*\n    * Override key up event to sync manual input changes.\n    */\n    $.datepicker._base_doKeyUp = $.datepicker._doKeyUp;\n    $.datepicker._doKeyUp = function (event) {\n        var inst = $.datepicker._getInst(event.target),\n            tp_inst = $.datepicker._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            if (tp_inst._defaults.timeOnly && (inst.input.val() !== inst.lastVal)) {\n                try {\n                    $.datepicker._updateDatepicker(inst);\n                } catch (err) {\n                    $.timepicker.log(err);\n                }\n            }\n        }\n\n        return $.datepicker._base_doKeyUp(event);\n    };\n\n    /*\n    * override \"Today\" button to also grab the time and set it to input field.\n    */\n    $.datepicker._base_gotoToday = $.datepicker._gotoToday;\n    $.datepicker._gotoToday = function (id) {\n        var inst = this._getInst($(id)[0]);\n        this._base_gotoToday(id);\n        var tp_inst = this._get(inst, 'timepicker');\n        if (!tp_inst) {\n            return;\n        }\n\n        var tzoffset = $.timepicker.timezoneOffsetNumber(tp_inst.timezone);\n        var now = new Date();\n        now.setMinutes(now.getMinutes() + now.getTimezoneOffset() + parseInt(tzoffset, 10));\n        this._setTime(inst, now);\n        this._setDate(inst, now);\n        tp_inst._onSelectHandler();\n    };\n\n    /*\n    * Disable & enable the Time in the datetimepicker\n    */\n    $.datepicker._disableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = false;\n            tp_inst._defaults.showTimepicker = false;\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    $.datepicker._enableTimepickerDatepicker = function (target) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        $(target).datepicker('getDate'); // Init selected[Year|Month|Day]\n        if (tp_inst) {\n            inst.settings.showTimepicker = true;\n            tp_inst._defaults.showTimepicker = true;\n            tp_inst._addTimePicker(inst); // Could be disabled on page load\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create our own set time function\n    */\n    $.datepicker._setTime = function (inst, date) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var defaults = tp_inst._defaults;\n\n            // calling _setTime with no date sets time to defaults\n            tp_inst.hour = date ? date.getHours() : defaults.hour;\n            tp_inst.minute = date ? date.getMinutes() : defaults.minute;\n            tp_inst.second = date ? date.getSeconds() : defaults.second;\n            tp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;\n            tp_inst.microsec = date ? date.getMicroseconds() : defaults.microsec;\n\n            //check if within min/max times..\n            tp_inst._limitMinMaxDateTime(inst, true);\n\n            tp_inst._onTimeChange();\n            tp_inst._updateDateTime(inst);\n        }\n    };\n\n    /*\n    * Create new public method to set only time, callable as $().datepicker('setTime', date)\n    */\n    $.datepicker._setTimeDatepicker = function (target, date, withDate) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            this._setDateFromField(inst);\n            var tp_date;\n            if (date) {\n                if (typeof date === \"string\") {\n                    tp_inst._parseTime(date, withDate);\n                    tp_date = new Date();\n                    tp_date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                    tp_date.setMicroseconds(tp_inst.microsec);\n                } else {\n                    tp_date = new Date(date.getTime());\n                    tp_date.setMicroseconds(date.getMicroseconds());\n                }\n                if (tp_date.toString() === 'Invalid Date') {\n                    tp_date = undefined;\n                }\n                this._setTime(inst, tp_date);\n            }\n        }\n\n    };\n\n    /*\n    * override setDate() to allow setting time too within Date object\n    */\n    $.datepicker._base_setDateDatepicker = $.datepicker._setDateDatepicker;\n    $.datepicker._setDateDatepicker = function (target, _date) {\n        var inst = this._getInst(target);\n        var date = _date;\n        if (!inst) {\n            return;\n        }\n\n        if (typeof(_date) === 'string') {\n            date = new Date(_date);\n            if (!date.getTime()) {\n                this._base_setDateDatepicker.apply(this, arguments);\n                date = $(target).datepicker('getDate');\n            }\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        var tp_date;\n        if (date instanceof Date) {\n            tp_date = new Date(date.getTime());\n            tp_date.setMicroseconds(date.getMicroseconds());\n        } else {\n            tp_date = date;\n        }\n\n        // This is important if you are using the timezone option, javascript's Date\n        // object will only return the timezone offset for the current locale, so we\n        // adjust it accordingly.  If not using timezone option this won't matter..\n        // If a timezone is different in tp, keep the timezone as is\n        if (tp_inst && tp_date) {\n            // look out for DST if tz wasn't specified\n            if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                tp_inst.timezone = tp_date.getTimezoneOffset() * -1;\n            }\n            date = $.timepicker.timezoneAdjust(date, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()), tp_inst.timezone);\n            tp_date = $.timepicker.timezoneAdjust(tp_date, $.timepicker.timezoneOffsetString(-tp_date.getTimezoneOffset()), tp_inst.timezone);\n        }\n\n        this._updateDatepicker(inst);\n        this._base_setDateDatepicker.apply(this, arguments);\n        this._setTimeDatepicker(target, tp_date, true);\n    };\n\n    /*\n    * override getDate() to allow getting time too within Date object\n    */\n    $.datepicker._base_getDateDatepicker = $.datepicker._getDateDatepicker;\n    $.datepicker._getDateDatepicker = function (target, noDefault) {\n        var inst = this._getInst(target);\n        if (!inst) {\n            return;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n\n        if (tp_inst) {\n            // if it hasn't yet been defined, grab from field\n            if (inst.lastVal === undefined) {\n                this._setDateFromField(inst, noDefault);\n            }\n\n            var date = this._getDate(inst);\n\n            var currDT = null;\n\n            if (tp_inst.$altInput && tp_inst._defaults.altFieldTimeOnly) {\n                currDT = tp_inst.$input.val() + ' ' + tp_inst.$altInput.val();\n            }\n            else if (tp_inst.$input.get(0).tagName !== 'INPUT' && tp_inst.$altInput) {\n                /**\n                 * in case the datetimepicker has been applied to a non-input tag for inline UI,\n                 * and the user has not configured the plugin to display only time in altInput,\n                 * pick current date time from the altInput (and hope for the best, for now, until \"ER1\" is applied)\n                 *\n                 * @todo ER1. Since altInput can have a totally difference format, convert it to standard format by reading input format from \"altFormat\" and \"altTimeFormat\" option values\n                 */\n                currDT = tp_inst.$altInput.val();\n            }\n            else {\n                currDT = tp_inst.$input.val();\n            }\n\n            if (date && tp_inst._parseTime(currDT, !inst.settings.timeOnly)) {\n                date.setHours(tp_inst.hour, tp_inst.minute, tp_inst.second, tp_inst.millisec);\n                date.setMicroseconds(tp_inst.microsec);\n\n                // This is important if you are using the timezone option, javascript's Date\n                // object will only return the timezone offset for the current locale, so we\n                // adjust it accordingly.  If not using timezone option this won't matter..\n                if (tp_inst.timezone != null) {\n                    // look out for DST if tz wasn't specified\n                    if (!tp_inst.support.timezone && tp_inst._defaults.timezone === null) {\n                        tp_inst.timezone = date.getTimezoneOffset() * -1;\n                    }\n                    date = $.timepicker.timezoneAdjust(date, tp_inst.timezone, $.timepicker.timezoneOffsetString(-date.getTimezoneOffset()));\n                }\n            }\n            return date;\n        }\n        return this._base_getDateDatepicker(target, noDefault);\n    };\n\n    /*\n    * override parseDate() because UI 1.8.14 throws an error about \"Extra characters\"\n    * An option in datapicker to ignore extra format characters would be nicer.\n    */\n    $.datepicker._base_parseDate = $.datepicker.parseDate;\n    $.datepicker.parseDate = function (format, value, settings) {\n        var date;\n        try {\n            date = this._base_parseDate(format, value, settings);\n        } catch (err) {\n            // Hack!  The error message ends with a colon, a space, and\n            // the \"extra\" characters.  We rely on that instead of\n            // attempting to perfectly reproduce the parsing algorithm.\n            if (err.indexOf(\":\") >= 0) {\n                date = this._base_parseDate(format, value.substring(0, value.length - (err.length - err.indexOf(':') - 2)), settings);\n                $.timepicker.log(\"Error parsing the date string: \" + err + \"\\ndate string = \" + value + \"\\ndate format = \" + format);\n            } else {\n                throw err;\n            }\n        }\n        return date;\n    };\n\n    /*\n    * override formatDate to set date with time to the input\n    */\n    $.datepicker._base_formatDate = $.datepicker._formatDate;\n    $.datepicker._formatDate = function (inst, day, month, year) {\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            tp_inst._updateDateTime(inst);\n            return tp_inst.$input.val();\n        }\n        return this._base_formatDate(inst);\n    };\n\n    /*\n    * override options setter to add time to maxDate(Time) and minDate(Time). MaxDate\n    */\n    $.datepicker._base_optionDatepicker = $.datepicker._optionDatepicker;\n    $.datepicker._optionDatepicker = function (target, name, value) {\n        var inst = this._getInst(target),\n            name_clone;\n        if (!inst) {\n            return null;\n        }\n\n        var tp_inst = this._get(inst, 'timepicker');\n        if (tp_inst) {\n            var min = null,\n                max = null,\n                onselect = null,\n                overrides = tp_inst._defaults.evnts,\n                fns = {},\n                prop,\n                ret,\n                oldVal,\n                $target;\n            if (typeof name === 'string') { // if min/max was set with the string\n                if (name === 'minDate' || name === 'minDateTime') {\n                    min = value;\n                } else if (name === 'maxDate' || name === 'maxDateTime') {\n                    max = value;\n                } else if (name === 'onSelect') {\n                    onselect = value;\n                } else if (overrides.hasOwnProperty(name)) {\n                    if (typeof (value) === 'undefined') {\n                        return overrides[name];\n                    }\n                    fns[name] = value;\n                    name_clone = {}; //empty results in exiting function after overrides updated\n                }\n            } else if (typeof name === 'object') { //if min/max was set with the JSON\n                if (name.minDate) {\n                    min = name.minDate;\n                } else if (name.minDateTime) {\n                    min = name.minDateTime;\n                } else if (name.maxDate) {\n                    max = name.maxDate;\n                } else if (name.maxDateTime) {\n                    max = name.maxDateTime;\n                }\n                for (prop in overrides) {\n                    if (overrides.hasOwnProperty(prop) && name[prop]) {\n                        fns[prop] = name[prop];\n                    }\n                }\n            }\n            for (prop in fns) {\n                if (fns.hasOwnProperty(prop)) {\n                    overrides[prop] = fns[prop];\n                    if (!name_clone) { name_clone = $.extend({}, name); }\n                    delete name_clone[prop];\n                }\n            }\n            if (name_clone && isEmptyObject(name_clone)) { return; }\n            if (min) { //if min was set\n                if (min === 0) {\n                    min = new Date();\n                } else {\n                    min = new Date(min);\n                }\n                tp_inst._defaults.minDate = min;\n                tp_inst._defaults.minDateTime = min;\n            } else if (max) { //if max was set\n                if (max === 0) {\n                    max = new Date();\n                } else {\n                    max = new Date(max);\n                }\n                tp_inst._defaults.maxDate = max;\n                tp_inst._defaults.maxDateTime = max;\n            } else if (onselect) {\n                tp_inst._defaults.onSelect = onselect;\n            }\n\n            // Datepicker will override our date when we call _base_optionDatepicker when\n            // calling minDate/maxDate, so we will first grab the value, call\n            // _base_optionDatepicker, then set our value back.\n            if(min || max){\n                $target = $(target);\n                oldVal = $target.datetimepicker('getDate');\n                ret = this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n                $target.datetimepicker('setDate', oldVal);\n                return ret;\n            }\n        }\n        if (value === undefined) {\n            return this._base_optionDatepicker.call($.datepicker, target, name);\n        }\n        return this._base_optionDatepicker.call($.datepicker, target, name_clone || name, value);\n    };\n\n    /*\n    * jQuery isEmptyObject does not check hasOwnProperty - if someone has added to the object prototype,\n    * it will return false for all objects\n    */\n    var isEmptyObject = function (obj) {\n        var prop;\n        for (prop in obj) {\n            if (obj.hasOwnProperty(prop)) {\n                return false;\n            }\n        }\n        return true;\n    };\n\n    /*\n    * jQuery extend now ignores nulls!\n    */\n    var extendRemove = function (target, props) {\n        $.extend(target, props);\n        for (var name in props) {\n            if (props[name] === null || props[name] === undefined) {\n                target[name] = props[name];\n            }\n        }\n        return target;\n    };\n\n    /*\n    * Determine by the time format which units are supported\n    * Returns an object of booleans for each unit\n    */\n    var detectSupport = function (timeFormat) {\n        var tf = timeFormat.replace(/'.*?'/g, '').toLowerCase(), // removes literals\n            isIn = function (f, t) { // does the format contain the token?\n                return f.indexOf(t) !== -1 ? true : false;\n            };\n        return {\n            hour: isIn(tf, 'h'),\n            minute: isIn(tf, 'm'),\n            second: isIn(tf, 's'),\n            millisec: isIn(tf, 'l'),\n            microsec: isIn(tf, 'c'),\n            timezone: isIn(tf, 'z'),\n            ampm: isIn(tf, 't') && isIn(timeFormat, 'h'),\n            iso8601: isIn(timeFormat, 'Z')\n        };\n    };\n\n    /*\n    * Converts 24 hour format into 12 hour\n    * Returns 12 hour without leading 0\n    */\n    var convert24to12 = function (hour) {\n        hour %= 12;\n\n        if (hour === 0) {\n            hour = 12;\n        }\n\n        return String(hour);\n    };\n\n    var computeEffectiveSetting = function (settings, property) {\n        return settings && settings[property] ? settings[property] : $.timepicker._defaults[property];\n    };\n\n    /*\n    * Splits datetime string into date and time substrings.\n    * Throws exception when date can't be parsed\n    * Returns {dateString: dateString, timeString: timeString}\n    */\n    var splitDateTime = function (dateTimeString, timeSettings) {\n        // The idea is to get the number separator occurrences in datetime and the time format requested (since time has\n        // fewer unknowns, mostly numbers and am/pm). We will use the time pattern to split.\n        var separator = computeEffectiveSetting(timeSettings, 'separator'),\n            format = computeEffectiveSetting(timeSettings, 'timeFormat'),\n            timeParts = format.split(separator), // how many occurrences of separator may be in our format?\n            timePartsLen = timeParts.length,\n            allParts = dateTimeString.split(separator),\n            allPartsLen = allParts.length;\n\n        if (allPartsLen > 1) {\n            return {\n                dateString: allParts.splice(0, allPartsLen - timePartsLen).join(separator),\n                timeString: allParts.splice(0, timePartsLen).join(separator)\n            };\n        }\n\n        return {\n            dateString: dateTimeString,\n            timeString: ''\n        };\n    };\n\n    /*\n    * Internal function to parse datetime interval\n    * Returns: {date: Date, timeObj: Object}, where\n    *   date - parsed date without time (type Date)\n    *   timeObj = {hour: , minute: , second: , millisec: , microsec: } - parsed time. Optional\n    */\n    var parseDateTimeInternal = function (dateFormat, timeFormat, dateTimeString, dateSettings, timeSettings) {\n        var date,\n            parts,\n            parsedTime;\n\n        parts = splitDateTime(dateTimeString, timeSettings);\n        date = $.datepicker._base_parseDate(dateFormat, parts.dateString, dateSettings);\n\n        if (parts.timeString === '') {\n            return {\n                date: date\n            };\n        }\n\n        parsedTime = $.datepicker.parseTime(timeFormat, parts.timeString, timeSettings);\n\n        if (!parsedTime) {\n            throw 'Wrong time format';\n        }\n\n        return {\n            date: date,\n            timeObj: parsedTime\n        };\n    };\n\n    /*\n    * Internal function to set timezone_select to the local timezone\n    */\n    var selectLocalTimezone = function (tp_inst, date) {\n        if (tp_inst && tp_inst.timezone_select) {\n            var now = date || new Date();\n            tp_inst.timezone_select.val(-now.getTimezoneOffset());\n        }\n    };\n\n    /*\n    * Create a Singleton Instance\n    */\n    $.timepicker = new Timepicker();\n\n    /**\n     * Get the timezone offset as string from a date object (eg '+0530' for UTC+5.5)\n     * @param {number} tzMinutes if not a number, less than -720 (-1200), or greater than 840 (+1400) this value is returned\n     * @param {boolean} iso8601 if true formats in accordance to iso8601 \"+12:45\"\n     * @return {string}\n     */\n    $.timepicker.timezoneOffsetString = function (tzMinutes, iso8601) {\n        if (isNaN(tzMinutes) || tzMinutes > 840 || tzMinutes < -720) {\n            return tzMinutes;\n        }\n\n        var off = tzMinutes,\n            minutes = off % 60,\n            hours = (off - minutes) / 60,\n            iso = iso8601 ? ':' : '',\n            tz = (off >= 0 ? '+' : '-') + ('0' + Math.abs(hours)).slice(-2) + iso + ('0' + Math.abs(minutes)).slice(-2);\n\n        if (tz === '+00:00') {\n            return 'Z';\n        }\n        return tz;\n    };\n\n    /**\n     * Get the number in minutes that represents a timezone string\n     * @param  {string} tzString formatted like \"+0500\", \"-1245\", \"Z\"\n     * @return {number} the offset minutes or the original string if it doesn't match expectations\n     */\n    $.timepicker.timezoneOffsetNumber = function (tzString) {\n        var normalized = tzString.toString().replace(':', ''); // excuse any iso8601, end up with \"+1245\"\n\n        if (normalized.toUpperCase() === 'Z') { // if iso8601 with Z, its 0 minute offset\n            return 0;\n        }\n\n        if (!/^(\\-|\\+)\\d{4}$/.test(normalized)) { // possibly a user defined tz, so just give it back\n            return parseInt(tzString, 10);\n        }\n\n        return ((normalized.substr(0, 1) === '-' ? -1 : 1) * // plus or minus\n            ((parseInt(normalized.substr(1, 2), 10) * 60) + // hours (converted to minutes)\n                parseInt(normalized.substr(3, 2), 10))); // minutes\n    };\n\n    /**\n     * No way to set timezone in js Date, so we must adjust the minutes to compensate. (think setDate, getDate)\n     * @param  {Date} date\n     * @param  {string} fromTimezone formatted like \"+0500\", \"-1245\"\n     * @param  {string} toTimezone formatted like \"+0500\", \"-1245\"\n     * @return {Date}\n     */\n    $.timepicker.timezoneAdjust = function (date, fromTimezone, toTimezone) {\n        var fromTz = $.timepicker.timezoneOffsetNumber(fromTimezone);\n        var toTz = $.timepicker.timezoneOffsetNumber(toTimezone);\n        if (!isNaN(toTz)) {\n            date.setMinutes(date.getMinutes() + (-fromTz) - (-toTz));\n        }\n        return date;\n    };\n\n    /**\n     * Calls `timepicker()` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * n.b. The input value must be correctly formatted (reformatting is not supported)\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the timepicker() call\n     * @return {jQuery}\n     */\n    $.timepicker.timeRange = function (startTime, endTime, options) {\n        return $.timepicker.handleRange('timepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datetimepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @return {jQuery}\n     */\n    $.timepicker.datetimeRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datetimepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `datepicker` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.dateRange = function (startTime, endTime, options) {\n        $.timepicker.handleRange('datepicker', startTime, endTime, options);\n    };\n\n    /**\n     * Calls `method` on the `startTime` and `endTime` elements, and configures them to\n     * enforce date range limits.\n     * @param  {string} method Can be used to specify the type of picker to be added\n     * @param  {Element} startTime\n     * @param  {Element} endTime\n     * @param  {Object} options Options for the `timepicker()` call. Also supports `reformat`,\n     *   a boolean value that can be used to reformat the input values to the `dateFormat`.\n     * @return {jQuery}\n     */\n    $.timepicker.handleRange = function (method, startTime, endTime, options) {\n        options = $.extend({}, {\n            minInterval: 0, // min allowed interval in milliseconds\n            maxInterval: 0, // max allowed interval in milliseconds\n            start: {},      // options for start picker\n            end: {}         // options for end picker\n        }, options);\n\n        // for the mean time this fixes an issue with calling getDate with timepicker()\n        var timeOnly = false;\n        if(method === 'timepicker'){\n            timeOnly = true;\n            method = 'datetimepicker';\n        }\n\n        function checkDates(changed, other) {\n            var startdt = startTime[method]('getDate'),\n                enddt = endTime[method]('getDate'),\n                changeddt = changed[method]('getDate');\n\n            if (startdt !== null) {\n                var minDate = new Date(startdt.getTime()),\n                    maxDate = new Date(startdt.getTime());\n\n                minDate.setMilliseconds(minDate.getMilliseconds() + options.minInterval);\n                maxDate.setMilliseconds(maxDate.getMilliseconds() + options.maxInterval);\n\n                if (options.minInterval > 0 && minDate > enddt) { // minInterval check\n                    endTime[method]('setDate', minDate);\n                }\n                else if (options.maxInterval > 0 && maxDate < enddt) { // max interval check\n                    endTime[method]('setDate', maxDate);\n                }\n                else if (startdt > enddt) {\n                    other[method]('setDate', changeddt);\n                }\n            }\n        }\n\n        function selected(changed, other, option) {\n            if (!changed.val()) {\n                return;\n            }\n            var date = changed[method].call(changed, 'getDate');\n            if (date !== null && options.minInterval > 0) {\n                if (option === 'minDate') {\n                    date.setMilliseconds(date.getMilliseconds() + options.minInterval);\n                }\n                if (option === 'maxDate') {\n                    date.setMilliseconds(date.getMilliseconds() - options.minInterval);\n                }\n            }\n\n            if (date.getTime) {\n                other[method].call(other, 'option', option, date);\n            }\n        }\n\n        $.fn[method].call(startTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), endTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), endTime, 'minDate');\n            }\n        }, options, options.start));\n        $.fn[method].call(endTime, $.extend({\n            timeOnly: timeOnly,\n            onClose: function (dateText, inst) {\n                checkDates($(this), startTime);\n            },\n            onSelect: function (selectedDateTime) {\n                selected($(this), startTime, 'maxDate');\n            }\n        }, options, options.end));\n\n        checkDates(startTime, endTime);\n\n        selected(startTime, endTime, 'minDate');\n        selected(endTime, startTime, 'maxDate');\n\n        return $([startTime.get(0), endTime.get(0)]);\n    };\n\n    /**\n     * Log error or data to the console during error or debugging\n     * @param  {Object} err pass any type object to log to the console during error or debugging\n     * @return {void}\n     */\n    $.timepicker.log = function () {\n        // Older IE (9, maybe 10) throw error on accessing `window.console.log.apply`, so check first.\n        if (window.console && window.console.log && window.console.log.apply) {\n            window.console.log.apply(window.console, Array.prototype.slice.call(arguments));\n        }\n    };\n\n    /*\n     * Add util object to allow access to private methods for testability.\n     */\n    $.timepicker._util = {\n        _extendRemove: extendRemove,\n        _isEmptyObject: isEmptyObject,\n        _convert24to12: convert24to12,\n        _detectSupport: detectSupport,\n        _selectLocalTimezone: selectLocalTimezone,\n        _computeEffectiveSetting: computeEffectiveSetting,\n        _splitDateTime: splitDateTime,\n        _parseDateTimeInternal: parseDateTimeInternal\n    };\n\n    /*\n    * Microsecond support\n    */\n    if (!Date.prototype.getMicroseconds) {\n        Date.prototype.microseconds = 0;\n        Date.prototype.getMicroseconds = function () { return this.microseconds; };\n        Date.prototype.setMicroseconds = function (m) {\n            this.setMilliseconds(this.getMilliseconds() + Math.floor(m / 1000));\n            this.microseconds = m % 1000;\n            return this;\n        };\n    }\n\n    /*\n    * Keep up with the version\n    */\n    $.timepicker.version = \"1.6.3\";\n\n}));\n"}
}});
