require.config({"config": {
        "jsbuild":{"jquery/ui-modules/widgets/tabs.js":"/*!\n * jQuery UI Tabs 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Tabs\n//>>group: Widgets\n//>>description: Transforms a set of container elements into a tab structure.\n//>>docs: http://api.jqueryui.com/tabs/\n//>>demos: http://jqueryui.com/tabs/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/tabs.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../keycode\",\n            \"../safe-active-element\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.tabs\", {\n        version: \"1.13.2\",\n        delay: 300,\n        options: {\n            active: null,\n            classes: {\n                \"ui-tabs\": \"ui-corner-all\",\n                \"ui-tabs-nav\": \"ui-corner-all\",\n                \"ui-tabs-panel\": \"ui-corner-bottom\",\n                \"ui-tabs-tab\": \"ui-corner-top\"\n            },\n            collapsible: false,\n            event: \"click\",\n            heightStyle: \"content\",\n            hide: null,\n            show: null,\n\n            // Callbacks\n            activate: null,\n            beforeActivate: null,\n            beforeLoad: null,\n            load: null\n        },\n\n        _isLocal: ( function() {\n            var rhash = /#.*$/;\n\n            return function( anchor ) {\n                var anchorUrl, locationUrl;\n\n                anchorUrl = anchor.href.replace( rhash, \"\" );\n                locationUrl = location.href.replace( rhash, \"\" );\n\n                // Decoding may throw an error if the URL isn't UTF-8 (#9518)\n                try {\n                    anchorUrl = decodeURIComponent( anchorUrl );\n                } catch ( error ) {}\n                try {\n                    locationUrl = decodeURIComponent( locationUrl );\n                } catch ( error ) {}\n\n                return anchor.hash.length > 1 && anchorUrl === locationUrl;\n            };\n        } )(),\n\n        _create: function() {\n            var that = this,\n                options = this.options;\n\n            this.running = false;\n\n            this._addClass( \"ui-tabs\", \"ui-widget ui-widget-content\" );\n            this._toggleClass( \"ui-tabs-collapsible\", null, options.collapsible );\n\n            this._processTabs();\n            options.active = this._initialActive();\n\n            // Take disabling tabs via class attribute from HTML\n            // into account and update option properly.\n            if ( Array.isArray( options.disabled ) ) {\n                options.disabled = $.uniqueSort( options.disabled.concat(\n                    $.map( this.tabs.filter( \".ui-state-disabled\" ), function( li ) {\n                        return that.tabs.index( li );\n                    } )\n                ) ).sort();\n            }\n\n            // Check for length avoids error when initializing empty list\n            if ( this.options.active !== false && this.anchors.length ) {\n                this.active = this._findActive( options.active );\n            } else {\n                this.active = $();\n            }\n\n            this._refresh();\n\n            if ( this.active.length ) {\n                this.load( options.active );\n            }\n        },\n\n        _initialActive: function() {\n            var active = this.options.active,\n                collapsible = this.options.collapsible,\n                locationHash = location.hash.substring( 1 );\n\n            if ( active === null ) {\n\n                // check the fragment identifier in the URL\n                if ( locationHash ) {\n                    this.tabs.each( function( i, tab ) {\n                        if ( $( tab ).attr( \"aria-controls\" ) === locationHash ) {\n                            active = i;\n                            return false;\n                        }\n                    } );\n                }\n\n                // Check for a tab marked active via a class\n                if ( active === null ) {\n                    active = this.tabs.index( this.tabs.filter( \".ui-tabs-active\" ) );\n                }\n\n                // No active tab, set to false\n                if ( active === null || active === -1 ) {\n                    active = this.tabs.length ? 0 : false;\n                }\n            }\n\n            // Handle numbers: negative, out of range\n            if ( active !== false ) {\n                active = this.tabs.index( this.tabs.eq( active ) );\n                if ( active === -1 ) {\n                    active = collapsible ? false : 0;\n                }\n            }\n\n            // Don't allow collapsible: false and active: false\n            if ( !collapsible && active === false && this.anchors.length ) {\n                active = 0;\n            }\n\n            return active;\n        },\n\n        _getCreateEventData: function() {\n            return {\n                tab: this.active,\n                panel: !this.active.length ? $() : this._getPanelForTab( this.active )\n            };\n        },\n\n        _tabKeydown: function( event ) {\n            var focusedTab = $( $.ui.safeActiveElement( this.document[ 0 ] ) ).closest( \"li\" ),\n                selectedIndex = this.tabs.index( focusedTab ),\n                goingForward = true;\n\n            if ( this._handlePageNav( event ) ) {\n                return;\n            }\n\n            switch ( event.keyCode ) {\n                case $.ui.keyCode.RIGHT:\n                case $.ui.keyCode.DOWN:\n                    selectedIndex++;\n                    break;\n                case $.ui.keyCode.UP:\n                case $.ui.keyCode.LEFT:\n                    goingForward = false;\n                    selectedIndex--;\n                    break;\n                case $.ui.keyCode.END:\n                    selectedIndex = this.anchors.length - 1;\n                    break;\n                case $.ui.keyCode.HOME:\n                    selectedIndex = 0;\n                    break;\n                case $.ui.keyCode.SPACE:\n\n                    // Activate only, no collapsing\n                    event.preventDefault();\n                    clearTimeout( this.activating );\n                    this._activate( selectedIndex );\n                    return;\n                case $.ui.keyCode.ENTER:\n\n                    // Toggle (cancel delayed activation, allow collapsing)\n                    event.preventDefault();\n                    clearTimeout( this.activating );\n\n                    // Determine if we should collapse or activate\n                    this._activate( selectedIndex === this.options.active ? false : selectedIndex );\n                    return;\n                default:\n                    return;\n            }\n\n            // Focus the appropriate tab, based on which key was pressed\n            event.preventDefault();\n            clearTimeout( this.activating );\n            selectedIndex = this._focusNextTab( selectedIndex, goingForward );\n\n            // Navigating with control/command key will prevent automatic activation\n            if ( !event.ctrlKey && !event.metaKey ) {\n\n                // Update aria-selected immediately so that AT think the tab is already selected.\n                // Otherwise AT may confuse the user by stating that they need to activate the tab,\n                // but the tab will already be activated by the time the announcement finishes.\n                focusedTab.attr( \"aria-selected\", \"false\" );\n                this.tabs.eq( selectedIndex ).attr( \"aria-selected\", \"true\" );\n\n                this.activating = this._delay( function() {\n                    this.option( \"active\", selectedIndex );\n                }, this.delay );\n            }\n        },\n\n        _panelKeydown: function( event ) {\n            if ( this._handlePageNav( event ) ) {\n                return;\n            }\n\n            // Ctrl+up moves focus to the current tab\n            if ( event.ctrlKey && event.keyCode === $.ui.keyCode.UP ) {\n                event.preventDefault();\n                this.active.trigger( \"focus\" );\n            }\n        },\n\n        // Alt+page up/down moves focus to the previous/next tab (and activates)\n        _handlePageNav: function( event ) {\n            if ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP ) {\n                this._activate( this._focusNextTab( this.options.active - 1, false ) );\n                return true;\n            }\n            if ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN ) {\n                this._activate( this._focusNextTab( this.options.active + 1, true ) );\n                return true;\n            }\n        },\n\n        _findNextTab: function( index, goingForward ) {\n            var lastTabIndex = this.tabs.length - 1;\n\n            function constrain() {\n                if ( index > lastTabIndex ) {\n                    index = 0;\n                }\n                if ( index < 0 ) {\n                    index = lastTabIndex;\n                }\n                return index;\n            }\n\n            while ( $.inArray( constrain(), this.options.disabled ) !== -1 ) {\n                index = goingForward ? index + 1 : index - 1;\n            }\n\n            return index;\n        },\n\n        _focusNextTab: function( index, goingForward ) {\n            index = this._findNextTab( index, goingForward );\n            this.tabs.eq( index ).trigger( \"focus\" );\n            return index;\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"active\" ) {\n\n                // _activate() will handle invalid values and update this.options\n                this._activate( value );\n                return;\n            }\n\n            this._super( key, value );\n\n            if ( key === \"collapsible\" ) {\n                this._toggleClass( \"ui-tabs-collapsible\", null, value );\n\n                // Setting collapsible: false while collapsed; open first panel\n                if ( !value && this.options.active === false ) {\n                    this._activate( 0 );\n                }\n            }\n\n            if ( key === \"event\" ) {\n                this._setupEvents( value );\n            }\n\n            if ( key === \"heightStyle\" ) {\n                this._setupHeightStyle( value );\n            }\n        },\n\n        _sanitizeSelector: function( hash ) {\n            return hash ? hash.replace( /[!\"$%&'()*+,.\\/:;<=>?@\\[\\]\\^`{|}~]/g, \"\\\\$&\" ) : \"\";\n        },\n\n        refresh: function() {\n            var options = this.options,\n                lis = this.tablist.children( \":has(a[href])\" );\n\n            // Get disabled tabs from class attribute from HTML\n            // this will get converted to a boolean if needed in _refresh()\n            options.disabled = $.map( lis.filter( \".ui-state-disabled\" ), function( tab ) {\n                return lis.index( tab );\n            } );\n\n            this._processTabs();\n\n            // Was collapsed or no tabs\n            if ( options.active === false || !this.anchors.length ) {\n                options.active = false;\n                this.active = $();\n\n                // was active, but active tab is gone\n            } else if ( this.active.length && !$.contains( this.tablist[ 0 ], this.active[ 0 ] ) ) {\n\n                // all remaining tabs are disabled\n                if ( this.tabs.length === options.disabled.length ) {\n                    options.active = false;\n                    this.active = $();\n\n                    // activate previous tab\n                } else {\n                    this._activate( this._findNextTab( Math.max( 0, options.active - 1 ), false ) );\n                }\n\n                // was active, active tab still exists\n            } else {\n\n                // make sure active index is correct\n                options.active = this.tabs.index( this.active );\n            }\n\n            this._refresh();\n        },\n\n        _refresh: function() {\n            this._setOptionDisabled( this.options.disabled );\n            this._setupEvents( this.options.event );\n            this._setupHeightStyle( this.options.heightStyle );\n\n            this.tabs.not( this.active ).attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\",\n                tabIndex: -1\n            } );\n            this.panels.not( this._getPanelForTab( this.active ) )\n                .hide()\n                .attr( {\n                    \"aria-hidden\": \"true\"\n                } );\n\n            // Make sure one tab is in the tab order\n            if ( !this.active.length ) {\n                this.tabs.eq( 0 ).attr( \"tabIndex\", 0 );\n            } else {\n                this.active\n                    .attr( {\n                        \"aria-selected\": \"true\",\n                        \"aria-expanded\": \"true\",\n                        tabIndex: 0\n                    } );\n                this._addClass( this.active, \"ui-tabs-active\", \"ui-state-active\" );\n                this._getPanelForTab( this.active )\n                    .show()\n                    .attr( {\n                        \"aria-hidden\": \"false\"\n                    } );\n            }\n        },\n\n        _processTabs: function() {\n            var that = this,\n                prevTabs = this.tabs,\n                prevAnchors = this.anchors,\n                prevPanels = this.panels;\n\n            this.tablist = this._getList().attr( \"role\", \"tablist\" );\n            this._addClass( this.tablist, \"ui-tabs-nav\",\n                \"ui-helper-reset ui-helper-clearfix ui-widget-header\" );\n\n            // Prevent users from focusing disabled tabs via click\n            this.tablist\n                .on( \"mousedown\" + this.eventNamespace, \"> li\", function( event ) {\n                    if ( $( this ).is( \".ui-state-disabled\" ) ) {\n                        event.preventDefault();\n                    }\n                } )\n\n                // Support: IE <9\n                // Preventing the default action in mousedown doesn't prevent IE\n                // from focusing the element, so if the anchor gets focused, blur.\n                // We don't have to worry about focusing the previously focused\n                // element since clicking on a non-focusable element should focus\n                // the body anyway.\n                .on( \"focus\" + this.eventNamespace, \".ui-tabs-anchor\", function() {\n                    if ( $( this ).closest( \"li\" ).is( \".ui-state-disabled\" ) ) {\n                        this.blur();\n                    }\n                } );\n\n            this.tabs = this.tablist.find( \"> li:has(a[href])\" )\n                .attr( {\n                    role: \"tab\",\n                    tabIndex: -1\n                } );\n            this._addClass( this.tabs, \"ui-tabs-tab\", \"ui-state-default\" );\n\n            this.anchors = this.tabs.map( function() {\n                return $( \"a\", this )[ 0 ];\n            } )\n                .attr( {\n                    tabIndex: -1\n                } );\n            this._addClass( this.anchors, \"ui-tabs-anchor\" );\n\n            this.panels = $();\n\n            this.anchors.each( function( i, anchor ) {\n                var selector, panel, panelId,\n                    anchorId = $( anchor ).uniqueId().attr( \"id\" ),\n                    tab = $( anchor ).closest( \"li\" ),\n                    originalAriaControls = tab.attr( \"aria-controls\" );\n\n                // Inline tab\n                if ( that._isLocal( anchor ) ) {\n                    selector = anchor.hash;\n                    panelId = selector.substring( 1 );\n                    panel = that.element.find( that._sanitizeSelector( selector ) );\n\n                    // remote tab\n                } else {\n\n                    // If the tab doesn't already have aria-controls,\n                    // generate an id by using a throw-away element\n                    panelId = tab.attr( \"aria-controls\" ) || $( {} ).uniqueId()[ 0 ].id;\n                    selector = \"#\" + panelId;\n                    panel = that.element.find( selector );\n                    if ( !panel.length ) {\n                        panel = that._createPanel( panelId );\n                        panel.insertAfter( that.panels[ i - 1 ] || that.tablist );\n                    }\n                    panel.attr( \"aria-live\", \"polite\" );\n                }\n\n                if ( panel.length ) {\n                    that.panels = that.panels.add( panel );\n                }\n                if ( originalAriaControls ) {\n                    tab.data( \"ui-tabs-aria-controls\", originalAriaControls );\n                }\n                tab.attr( {\n                    \"aria-controls\": panelId,\n                    \"aria-labelledby\": anchorId\n                } );\n                panel.attr( \"aria-labelledby\", anchorId );\n            } );\n\n            this.panels.attr( \"role\", \"tabpanel\" );\n            this._addClass( this.panels, \"ui-tabs-panel\", \"ui-widget-content\" );\n\n            // Avoid memory leaks (#10056)\n            if ( prevTabs ) {\n                this._off( prevTabs.not( this.tabs ) );\n                this._off( prevAnchors.not( this.anchors ) );\n                this._off( prevPanels.not( this.panels ) );\n            }\n        },\n\n        // Allow overriding how to find the list for rare usage scenarios (#7715)\n        _getList: function() {\n            return this.tablist || this.element.find( \"ol, ul\" ).eq( 0 );\n        },\n\n        _createPanel: function( id ) {\n            return $( \"<div>\" )\n                .attr( \"id\", id )\n                .data( \"ui-tabs-destroy\", true );\n        },\n\n        _setOptionDisabled: function( disabled ) {\n            var currentItem, li, i;\n\n            if ( Array.isArray( disabled ) ) {\n                if ( !disabled.length ) {\n                    disabled = false;\n                } else if ( disabled.length === this.anchors.length ) {\n                    disabled = true;\n                }\n            }\n\n            // Disable tabs\n            for ( i = 0; ( li = this.tabs[ i ] ); i++ ) {\n                currentItem = $( li );\n                if ( disabled === true || $.inArray( i, disabled ) !== -1 ) {\n                    currentItem.attr( \"aria-disabled\", \"true\" );\n                    this._addClass( currentItem, null, \"ui-state-disabled\" );\n                } else {\n                    currentItem.removeAttr( \"aria-disabled\" );\n                    this._removeClass( currentItem, null, \"ui-state-disabled\" );\n                }\n            }\n\n            this.options.disabled = disabled;\n\n            this._toggleClass( this.widget(), this.widgetFullName + \"-disabled\", null,\n                disabled === true );\n        },\n\n        _setupEvents: function( event ) {\n            var events = {};\n            if ( event ) {\n                $.each( event.split( \" \" ), function( index, eventName ) {\n                    events[ eventName ] = \"_eventHandler\";\n                } );\n            }\n\n            this._off( this.anchors.add( this.tabs ).add( this.panels ) );\n\n            // Always prevent the default action, even when disabled\n            this._on( true, this.anchors, {\n                click: function( event ) {\n                    event.preventDefault();\n                }\n            } );\n            this._on( this.anchors, events );\n            this._on( this.tabs, { keydown: \"_tabKeydown\" } );\n            this._on( this.panels, { keydown: \"_panelKeydown\" } );\n\n            this._focusable( this.tabs );\n            this._hoverable( this.tabs );\n        },\n\n        _setupHeightStyle: function( heightStyle ) {\n            var maxHeight,\n                parent = this.element.parent();\n\n            if ( heightStyle === \"fill\" ) {\n                maxHeight = parent.height();\n                maxHeight -= this.element.outerHeight() - this.element.height();\n\n                this.element.siblings( \":visible\" ).each( function() {\n                    var elem = $( this ),\n                        position = elem.css( \"position\" );\n\n                    if ( position === \"absolute\" || position === \"fixed\" ) {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight( true );\n                } );\n\n                this.element.children().not( this.panels ).each( function() {\n                    maxHeight -= $( this ).outerHeight( true );\n                } );\n\n                this.panels.each( function() {\n                    $( this ).height( Math.max( 0, maxHeight -\n                        $( this ).innerHeight() + $( this ).height() ) );\n                } )\n                    .css( \"overflow\", \"auto\" );\n            } else if ( heightStyle === \"auto\" ) {\n                maxHeight = 0;\n                this.panels.each( function() {\n                    maxHeight = Math.max( maxHeight, $( this ).height( \"\" ).height() );\n                } ).height( maxHeight );\n            }\n        },\n\n        _eventHandler: function( event ) {\n            var options = this.options,\n                active = this.active,\n                anchor = $( event.currentTarget ),\n                tab = anchor.closest( \"li\" ),\n                clickedIsActive = tab[ 0 ] === active[ 0 ],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : this._getPanelForTab( tab ),\n                toHide = !active.length ? $() : this._getPanelForTab( active ),\n                eventData = {\n                    oldTab: active,\n                    oldPanel: toHide,\n                    newTab: collapsing ? $() : tab,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if ( tab.hasClass( \"ui-state-disabled\" ) ||\n\n                // tab is already loading\n                tab.hasClass( \"ui-tabs-loading\" ) ||\n\n                // can't switch durning an animation\n                this.running ||\n\n                // click on active header, but not collapsible\n                ( clickedIsActive && !options.collapsible ) ||\n\n                // allow canceling activation\n                ( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.tabs.index( tab );\n\n            this.active = clickedIsActive ? $() : tab;\n            if ( this.xhr ) {\n                this.xhr.abort();\n            }\n\n            if ( !toHide.length && !toShow.length ) {\n                $.error( \"jQuery UI Tabs: Mismatching fragment identifier.\" );\n            }\n\n            if ( toShow.length ) {\n                this.load( this.tabs.index( tab ), event );\n            }\n            this._toggle( event, eventData );\n        },\n\n        // Handles show/hide for selecting tabs\n        _toggle: function( event, eventData ) {\n            var that = this,\n                toShow = eventData.newPanel,\n                toHide = eventData.oldPanel;\n\n            this.running = true;\n\n            function complete() {\n                that.running = false;\n                that._trigger( \"activate\", event, eventData );\n            }\n\n            function show() {\n                that._addClass( eventData.newTab.closest( \"li\" ), \"ui-tabs-active\", \"ui-state-active\" );\n\n                if ( toShow.length && that.options.show ) {\n                    that._show( toShow, that.options.show, complete );\n                } else {\n                    toShow.show();\n                    complete();\n                }\n            }\n\n            // Start out by hiding, then showing, then completing\n            if ( toHide.length && this.options.hide ) {\n                this._hide( toHide, this.options.hide, function() {\n                    that._removeClass( eventData.oldTab.closest( \"li\" ),\n                        \"ui-tabs-active\", \"ui-state-active\" );\n                    show();\n                } );\n            } else {\n                this._removeClass( eventData.oldTab.closest( \"li\" ),\n                    \"ui-tabs-active\", \"ui-state-active\" );\n                toHide.hide();\n                show();\n            }\n\n            toHide.attr( \"aria-hidden\", \"true\" );\n            eventData.oldTab.attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\"\n            } );\n\n            // If we're switching tabs, remove the old tab from the tab order.\n            // If we're opening from collapsed state, remove the previous tab from the tab order.\n            // If we're collapsing, then keep the collapsing tab in the tab order.\n            if ( toShow.length && toHide.length ) {\n                eventData.oldTab.attr( \"tabIndex\", -1 );\n            } else if ( toShow.length ) {\n                this.tabs.filter( function() {\n                    return $( this ).attr( \"tabIndex\" ) === 0;\n                } )\n                    .attr( \"tabIndex\", -1 );\n            }\n\n            toShow.attr( \"aria-hidden\", \"false\" );\n            eventData.newTab.attr( {\n                \"aria-selected\": \"true\",\n                \"aria-expanded\": \"true\",\n                tabIndex: 0\n            } );\n        },\n\n        _activate: function( index ) {\n            var anchor,\n                active = this._findActive( index );\n\n            // Trying to activate the already active panel\n            if ( active[ 0 ] === this.active[ 0 ] ) {\n                return;\n            }\n\n            // Trying to collapse, simulate a click on the current active header\n            if ( !active.length ) {\n                active = this.active;\n            }\n\n            anchor = active.find( \".ui-tabs-anchor\" )[ 0 ];\n            this._eventHandler( {\n                target: anchor,\n                currentTarget: anchor,\n                preventDefault: $.noop\n            } );\n        },\n\n        _findActive: function( index ) {\n            return index === false ? $() : this.tabs.eq( index );\n        },\n\n        _getIndex: function( index ) {\n\n            // meta-function to give users option to provide a href string instead of a numerical index.\n            if ( typeof index === \"string\" ) {\n                index = this.anchors.index( this.anchors.filter( \"[href$='\" +\n                    $.escapeSelector( index ) + \"']\" ) );\n            }\n\n            return index;\n        },\n\n        _destroy: function() {\n            if ( this.xhr ) {\n                this.xhr.abort();\n            }\n\n            this.tablist\n                .removeAttr( \"role\" )\n                .off( this.eventNamespace );\n\n            this.anchors\n                .removeAttr( \"role tabIndex\" )\n                .removeUniqueId();\n\n            this.tabs.add( this.panels ).each( function() {\n                if ( $.data( this, \"ui-tabs-destroy\" ) ) {\n                    $( this ).remove();\n                } else {\n                    $( this ).removeAttr( \"role tabIndex \" +\n                        \"aria-live aria-busy aria-selected aria-labelledby aria-hidden aria-expanded\" );\n                }\n            } );\n\n            this.tabs.each( function() {\n                var li = $( this ),\n                    prev = li.data( \"ui-tabs-aria-controls\" );\n                if ( prev ) {\n                    li\n                        .attr( \"aria-controls\", prev )\n                        .removeData( \"ui-tabs-aria-controls\" );\n                } else {\n                    li.removeAttr( \"aria-controls\" );\n                }\n            } );\n\n            this.panels.show();\n\n            if ( this.options.heightStyle !== \"content\" ) {\n                this.panels.css( \"height\", \"\" );\n            }\n        },\n\n        enable: function( index ) {\n            var disabled = this.options.disabled;\n            if ( disabled === false ) {\n                return;\n            }\n\n            if ( index === undefined ) {\n                disabled = false;\n            } else {\n                index = this._getIndex( index );\n                if ( Array.isArray( disabled ) ) {\n                    disabled = $.map( disabled, function( num ) {\n                        return num !== index ? num : null;\n                    } );\n                } else {\n                    disabled = $.map( this.tabs, function( li, num ) {\n                        return num !== index ? num : null;\n                    } );\n                }\n            }\n            this._setOptionDisabled( disabled );\n        },\n\n        disable: function( index ) {\n            var disabled = this.options.disabled;\n            if ( disabled === true ) {\n                return;\n            }\n\n            if ( index === undefined ) {\n                disabled = true;\n            } else {\n                index = this._getIndex( index );\n                if ( $.inArray( index, disabled ) !== -1 ) {\n                    return;\n                }\n                if ( Array.isArray( disabled ) ) {\n                    disabled = $.merge( [ index ], disabled ).sort();\n                } else {\n                    disabled = [ index ];\n                }\n            }\n            this._setOptionDisabled( disabled );\n        },\n\n        load: function( index, event ) {\n            index = this._getIndex( index );\n            var that = this,\n                tab = this.tabs.eq( index ),\n                anchor = tab.find( \".ui-tabs-anchor\" ),\n                panel = this._getPanelForTab( tab ),\n                eventData = {\n                    tab: tab,\n                    panel: panel\n                },\n                complete = function( jqXHR, status ) {\n                    if ( status === \"abort\" ) {\n                        that.panels.stop( false, true );\n                    }\n\n                    that._removeClass( tab, \"ui-tabs-loading\" );\n                    panel.removeAttr( \"aria-busy\" );\n\n                    if ( jqXHR === that.xhr ) {\n                        delete that.xhr;\n                    }\n                };\n\n            // Not remote\n            if ( this._isLocal( anchor[ 0 ] ) ) {\n                return;\n            }\n\n            this.xhr = $.ajax( this._ajaxSettings( anchor, event, eventData ) );\n\n            // Support: jQuery <1.8\n            // jQuery <1.8 returns false if the request is canceled in beforeSend,\n            // but as of 1.8, $.ajax() always returns a jqXHR object.\n            if ( this.xhr && this.xhr.statusText !== \"canceled\" ) {\n                this._addClass( tab, \"ui-tabs-loading\" );\n                panel.attr( \"aria-busy\", \"true\" );\n\n                this.xhr\n                    .done( function( response, status, jqXHR ) {\n\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout( function() {\n                            panel.html( response );\n                            that._trigger( \"load\", event, eventData );\n\n                            complete( jqXHR, status );\n                        }, 1 );\n                    } )\n                    .fail( function( jqXHR, status ) {\n\n                        // support: jQuery <1.8\n                        // http://bugs.jquery.com/ticket/11778\n                        setTimeout( function() {\n                            complete( jqXHR, status );\n                        }, 1 );\n                    } );\n            }\n        },\n\n        _ajaxSettings: function( anchor, event, eventData ) {\n            var that = this;\n            return {\n\n                // Support: IE <11 only\n                // Strip any hash that exists to prevent errors with the Ajax request\n                url: anchor.attr( \"href\" ).replace( /#.*$/, \"\" ),\n                beforeSend: function( jqXHR, settings ) {\n                    return that._trigger( \"beforeLoad\", event,\n                        $.extend( { jqXHR: jqXHR, ajaxSettings: settings }, eventData ) );\n                }\n            };\n        },\n\n        _getPanelForTab: function( tab ) {\n            var id = $( tab ).attr( \"aria-controls\" );\n            return this.element.find( this._sanitizeSelector( \"#\" + id ) );\n        }\n    } );\n\n// DEPRECATED\n// TODO: Switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for ui-tab class (now ui-tabs-tab)\n        $.widget( \"ui.tabs\", $.ui.tabs, {\n            _processTabs: function() {\n                this._superApply( arguments );\n                this._addClass( this.tabs, \"ui-tab\" );\n            }\n        } );\n    }\n\n    return $.ui.tabs;\n\n} );\n","jquery/ui-modules/widgets/resizable.js":"/*!\n * jQuery UI Resizable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Resizable\n//>>group: Interactions\n//>>description: Enables resize functionality for any element.\n//>>docs: http://api.jqueryui.com/resizable/\n//>>demos: http://jqueryui.com/resizable/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/resizable.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../disable-selection\",\n            \"../plugin\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.resizable\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"resize\",\n        options: {\n            alsoResize: false,\n            animate: false,\n            animateDuration: \"slow\",\n            animateEasing: \"swing\",\n            aspectRatio: false,\n            autoHide: false,\n            classes: {\n                \"ui-resizable-se\": \"ui-icon ui-icon-gripsmall-diagonal-se\"\n            },\n            containment: false,\n            ghost: false,\n            grid: false,\n            handles: \"e,s,se\",\n            helper: false,\n            maxHeight: null,\n            maxWidth: null,\n            minHeight: 10,\n            minWidth: 10,\n\n            // See #7960\n            zIndex: 90,\n\n            // Callbacks\n            resize: null,\n            start: null,\n            stop: null\n        },\n\n        _num: function( value ) {\n            return parseFloat( value ) || 0;\n        },\n\n        _isNumber: function( value ) {\n            return !isNaN( parseFloat( value ) );\n        },\n\n        _hasScroll: function( el, a ) {\n\n            if ( $( el ).css( \"overflow\" ) === \"hidden\" ) {\n                return false;\n            }\n\n            var scroll = ( a && a === \"left\" ) ? \"scrollLeft\" : \"scrollTop\",\n                has = false;\n\n            if ( el[ scroll ] > 0 ) {\n                return true;\n            }\n\n            // TODO: determine which cases actually cause this to happen\n            // if the element doesn't have the scroll set, see if it's possible to\n            // set the scroll\n            try {\n                el[ scroll ] = 1;\n                has = ( el[ scroll ] > 0 );\n                el[ scroll ] = 0;\n            } catch ( e ) {\n\n                // `el` might be a string, then setting `scroll` will throw\n                // an error in strict mode; ignore it.\n            }\n            return has;\n        },\n\n        _create: function() {\n\n            var margins,\n                o = this.options,\n                that = this;\n            this._addClass( \"ui-resizable\" );\n\n            $.extend( this, {\n                _aspectRatio: !!( o.aspectRatio ),\n                aspectRatio: o.aspectRatio,\n                originalElement: this.element,\n                _proportionallyResizeElements: [],\n                _helper: o.helper || o.ghost || o.animate ? o.helper || \"ui-resizable-helper\" : null\n            } );\n\n            // Wrap the element if it cannot hold child nodes\n            if ( this.element[ 0 ].nodeName.match( /^(canvas|textarea|input|select|button|img)$/i ) ) {\n\n                this.element.wrap(\n                    $( \"<div class='ui-wrapper'></div>\" ).css( {\n                        overflow: \"hidden\",\n                        position: this.element.css( \"position\" ),\n                        width: this.element.outerWidth(),\n                        height: this.element.outerHeight(),\n                        top: this.element.css( \"top\" ),\n                        left: this.element.css( \"left\" )\n                    } )\n                );\n\n                this.element = this.element.parent().data(\n                    \"ui-resizable\", this.element.resizable( \"instance\" )\n                );\n\n                this.elementIsWrapper = true;\n\n                margins = {\n                    marginTop: this.originalElement.css( \"marginTop\" ),\n                    marginRight: this.originalElement.css( \"marginRight\" ),\n                    marginBottom: this.originalElement.css( \"marginBottom\" ),\n                    marginLeft: this.originalElement.css( \"marginLeft\" )\n                };\n\n                this.element.css( margins );\n                this.originalElement.css( \"margin\", 0 );\n\n                // support: Safari\n                // Prevent Safari textarea resize\n                this.originalResizeStyle = this.originalElement.css( \"resize\" );\n                this.originalElement.css( \"resize\", \"none\" );\n\n                this._proportionallyResizeElements.push( this.originalElement.css( {\n                    position: \"static\",\n                    zoom: 1,\n                    display: \"block\"\n                } ) );\n\n                // Support: IE9\n                // avoid IE jump (hard set the margin)\n                this.originalElement.css( margins );\n\n                this._proportionallyResize();\n            }\n\n            this._setupHandles();\n\n            if ( o.autoHide ) {\n                $( this.element )\n                    .on( \"mouseenter\", function() {\n                        if ( o.disabled ) {\n                            return;\n                        }\n                        that._removeClass( \"ui-resizable-autohide\" );\n                        that._handles.show();\n                    } )\n                    .on( \"mouseleave\", function() {\n                        if ( o.disabled ) {\n                            return;\n                        }\n                        if ( !that.resizing ) {\n                            that._addClass( \"ui-resizable-autohide\" );\n                            that._handles.hide();\n                        }\n                    } );\n            }\n\n            this._mouseInit();\n        },\n\n        _destroy: function() {\n\n            this._mouseDestroy();\n            this._addedHandles.remove();\n\n            var wrapper,\n                _destroy = function( exp ) {\n                    $( exp )\n                        .removeData( \"resizable\" )\n                        .removeData( \"ui-resizable\" )\n                        .off( \".resizable\" );\n                };\n\n            // TODO: Unwrap at same DOM position\n            if ( this.elementIsWrapper ) {\n                _destroy( this.element );\n                wrapper = this.element;\n                this.originalElement.css( {\n                    position: wrapper.css( \"position\" ),\n                    width: wrapper.outerWidth(),\n                    height: wrapper.outerHeight(),\n                    top: wrapper.css( \"top\" ),\n                    left: wrapper.css( \"left\" )\n                } ).insertAfter( wrapper );\n                wrapper.remove();\n            }\n\n            this.originalElement.css( \"resize\", this.originalResizeStyle );\n            _destroy( this.originalElement );\n\n            return this;\n        },\n\n        _setOption: function( key, value ) {\n            this._super( key, value );\n\n            switch ( key ) {\n                case \"handles\":\n                    this._removeHandles();\n                    this._setupHandles();\n                    break;\n                case \"aspectRatio\":\n                    this._aspectRatio = !!value;\n                    break;\n                default:\n                    break;\n            }\n        },\n\n        _setupHandles: function() {\n            var o = this.options, handle, i, n, hname, axis, that = this;\n            this.handles = o.handles ||\n                ( !$( \".ui-resizable-handle\", this.element ).length ?\n                    \"e,s,se\" : {\n                        n: \".ui-resizable-n\",\n                        e: \".ui-resizable-e\",\n                        s: \".ui-resizable-s\",\n                        w: \".ui-resizable-w\",\n                        se: \".ui-resizable-se\",\n                        sw: \".ui-resizable-sw\",\n                        ne: \".ui-resizable-ne\",\n                        nw: \".ui-resizable-nw\"\n                    } );\n\n            this._handles = $();\n            this._addedHandles = $();\n            if ( this.handles.constructor === String ) {\n\n                if ( this.handles === \"all\" ) {\n                    this.handles = \"n,e,s,w,se,sw,ne,nw\";\n                }\n\n                n = this.handles.split( \",\" );\n                this.handles = {};\n\n                for ( i = 0; i < n.length; i++ ) {\n\n                    handle = String.prototype.trim.call( n[ i ] );\n                    hname = \"ui-resizable-\" + handle;\n                    axis = $( \"<div>\" );\n                    this._addClass( axis, \"ui-resizable-handle \" + hname );\n\n                    axis.css( { zIndex: o.zIndex } );\n\n                    this.handles[ handle ] = \".ui-resizable-\" + handle;\n                    if ( !this.element.children( this.handles[ handle ] ).length ) {\n                        this.element.append( axis );\n                        this._addedHandles = this._addedHandles.add( axis );\n                    }\n                }\n\n            }\n\n            this._renderAxis = function( target ) {\n\n                var i, axis, padPos, padWrapper;\n\n                target = target || this.element;\n\n                for ( i in this.handles ) {\n\n                    if ( this.handles[ i ].constructor === String ) {\n                        this.handles[ i ] = this.element.children( this.handles[ i ] ).first().show();\n                    } else if ( this.handles[ i ].jquery || this.handles[ i ].nodeType ) {\n                        this.handles[ i ] = $( this.handles[ i ] );\n                        this._on( this.handles[ i ], { \"mousedown\": that._mouseDown } );\n                    }\n\n                    if ( this.elementIsWrapper &&\n                        this.originalElement[ 0 ]\n                            .nodeName\n                            .match( /^(textarea|input|select|button)$/i ) ) {\n                        axis = $( this.handles[ i ], this.element );\n\n                        padWrapper = /sw|ne|nw|se|n|s/.test( i ) ?\n                            axis.outerHeight() :\n                            axis.outerWidth();\n\n                        padPos = [ \"padding\",\n                            /ne|nw|n/.test( i ) ? \"Top\" :\n                                /se|sw|s/.test( i ) ? \"Bottom\" :\n                                    /^e$/.test( i ) ? \"Right\" : \"Left\" ].join( \"\" );\n\n                        target.css( padPos, padWrapper );\n\n                        this._proportionallyResize();\n                    }\n\n                    this._handles = this._handles.add( this.handles[ i ] );\n                }\n            };\n\n            // TODO: make renderAxis a prototype function\n            this._renderAxis( this.element );\n\n            this._handles = this._handles.add( this.element.find( \".ui-resizable-handle\" ) );\n            this._handles.disableSelection();\n\n            this._handles.on( \"mouseover\", function() {\n                if ( !that.resizing ) {\n                    if ( this.className ) {\n                        axis = this.className.match( /ui-resizable-(se|sw|ne|nw|n|e|s|w)/i );\n                    }\n                    that.axis = axis && axis[ 1 ] ? axis[ 1 ] : \"se\";\n                }\n            } );\n\n            if ( o.autoHide ) {\n                this._handles.hide();\n                this._addClass( \"ui-resizable-autohide\" );\n            }\n        },\n\n        _removeHandles: function() {\n            this._addedHandles.remove();\n        },\n\n        _mouseCapture: function( event ) {\n            var i, handle,\n                capture = false;\n\n            for ( i in this.handles ) {\n                handle = $( this.handles[ i ] )[ 0 ];\n                if ( handle === event.target || $.contains( handle, event.target ) ) {\n                    capture = true;\n                }\n            }\n\n            return !this.options.disabled && capture;\n        },\n\n        _mouseStart: function( event ) {\n\n            var curleft, curtop, cursor,\n                o = this.options,\n                el = this.element;\n\n            this.resizing = true;\n\n            this._renderProxy();\n\n            curleft = this._num( this.helper.css( \"left\" ) );\n            curtop = this._num( this.helper.css( \"top\" ) );\n\n            if ( o.containment ) {\n                curleft += $( o.containment ).scrollLeft() || 0;\n                curtop += $( o.containment ).scrollTop() || 0;\n            }\n\n            this.offset = this.helper.offset();\n            this.position = { left: curleft, top: curtop };\n\n            this.size = this._helper ? {\n                width: this.helper.width(),\n                height: this.helper.height()\n            } : {\n                width: el.width(),\n                height: el.height()\n            };\n\n            this.originalSize = this._helper ? {\n                width: el.outerWidth(),\n                height: el.outerHeight()\n            } : {\n                width: el.width(),\n                height: el.height()\n            };\n\n            this.sizeDiff = {\n                width: el.outerWidth() - el.width(),\n                height: el.outerHeight() - el.height()\n            };\n\n            this.originalPosition = { left: curleft, top: curtop };\n            this.originalMousePosition = { left: event.pageX, top: event.pageY };\n\n            this.aspectRatio = ( typeof o.aspectRatio === \"number\" ) ?\n                o.aspectRatio :\n                ( ( this.originalSize.width / this.originalSize.height ) || 1 );\n\n            cursor = $( \".ui-resizable-\" + this.axis ).css( \"cursor\" );\n            $( \"body\" ).css( \"cursor\", cursor === \"auto\" ? this.axis + \"-resize\" : cursor );\n\n            this._addClass( \"ui-resizable-resizing\" );\n            this._propagate( \"start\", event );\n            return true;\n        },\n\n        _mouseDrag: function( event ) {\n\n            var data, props,\n                smp = this.originalMousePosition,\n                a = this.axis,\n                dx = ( event.pageX - smp.left ) || 0,\n                dy = ( event.pageY - smp.top ) || 0,\n                trigger = this._change[ a ];\n\n            this._updatePrevProperties();\n\n            if ( !trigger ) {\n                return false;\n            }\n\n            data = trigger.apply( this, [ event, dx, dy ] );\n\n            this._updateVirtualBoundaries( event.shiftKey );\n            if ( this._aspectRatio || event.shiftKey ) {\n                data = this._updateRatio( data, event );\n            }\n\n            data = this._respectSize( data, event );\n\n            this._updateCache( data );\n\n            this._propagate( \"resize\", event );\n\n            props = this._applyChanges();\n\n            if ( !this._helper && this._proportionallyResizeElements.length ) {\n                this._proportionallyResize();\n            }\n\n            if ( !$.isEmptyObject( props ) ) {\n                this._updatePrevProperties();\n                this._trigger( \"resize\", event, this.ui() );\n                this._applyChanges();\n            }\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n\n            this.resizing = false;\n            var pr, ista, soffseth, soffsetw, s, left, top,\n                o = this.options, that = this;\n\n            if ( this._helper ) {\n\n                pr = this._proportionallyResizeElements;\n                ista = pr.length && ( /textarea/i ).test( pr[ 0 ].nodeName );\n                soffseth = ista && this._hasScroll( pr[ 0 ], \"left\" ) ? 0 : that.sizeDiff.height;\n                soffsetw = ista ? 0 : that.sizeDiff.width;\n\n                s = {\n                    width: ( that.helper.width()  - soffsetw ),\n                    height: ( that.helper.height() - soffseth )\n                };\n                left = ( parseFloat( that.element.css( \"left\" ) ) +\n                    ( that.position.left - that.originalPosition.left ) ) || null;\n                top = ( parseFloat( that.element.css( \"top\" ) ) +\n                    ( that.position.top - that.originalPosition.top ) ) || null;\n\n                if ( !o.animate ) {\n                    this.element.css( $.extend( s, { top: top, left: left } ) );\n                }\n\n                that.helper.height( that.size.height );\n                that.helper.width( that.size.width );\n\n                if ( this._helper && !o.animate ) {\n                    this._proportionallyResize();\n                }\n            }\n\n            $( \"body\" ).css( \"cursor\", \"auto\" );\n\n            this._removeClass( \"ui-resizable-resizing\" );\n\n            this._propagate( \"stop\", event );\n\n            if ( this._helper ) {\n                this.helper.remove();\n            }\n\n            return false;\n\n        },\n\n        _updatePrevProperties: function() {\n            this.prevPosition = {\n                top: this.position.top,\n                left: this.position.left\n            };\n            this.prevSize = {\n                width: this.size.width,\n                height: this.size.height\n            };\n        },\n\n        _applyChanges: function() {\n            var props = {};\n\n            if ( this.position.top !== this.prevPosition.top ) {\n                props.top = this.position.top + \"px\";\n            }\n            if ( this.position.left !== this.prevPosition.left ) {\n                props.left = this.position.left + \"px\";\n            }\n            if ( this.size.width !== this.prevSize.width ) {\n                props.width = this.size.width + \"px\";\n            }\n            if ( this.size.height !== this.prevSize.height ) {\n                props.height = this.size.height + \"px\";\n            }\n\n            this.helper.css( props );\n\n            return props;\n        },\n\n        _updateVirtualBoundaries: function( forceAspectRatio ) {\n            var pMinWidth, pMaxWidth, pMinHeight, pMaxHeight, b,\n                o = this.options;\n\n            b = {\n                minWidth: this._isNumber( o.minWidth ) ? o.minWidth : 0,\n                maxWidth: this._isNumber( o.maxWidth ) ? o.maxWidth : Infinity,\n                minHeight: this._isNumber( o.minHeight ) ? o.minHeight : 0,\n                maxHeight: this._isNumber( o.maxHeight ) ? o.maxHeight : Infinity\n            };\n\n            if ( this._aspectRatio || forceAspectRatio ) {\n                pMinWidth = b.minHeight * this.aspectRatio;\n                pMinHeight = b.minWidth / this.aspectRatio;\n                pMaxWidth = b.maxHeight * this.aspectRatio;\n                pMaxHeight = b.maxWidth / this.aspectRatio;\n\n                if ( pMinWidth > b.minWidth ) {\n                    b.minWidth = pMinWidth;\n                }\n                if ( pMinHeight > b.minHeight ) {\n                    b.minHeight = pMinHeight;\n                }\n                if ( pMaxWidth < b.maxWidth ) {\n                    b.maxWidth = pMaxWidth;\n                }\n                if ( pMaxHeight < b.maxHeight ) {\n                    b.maxHeight = pMaxHeight;\n                }\n            }\n            this._vBoundaries = b;\n        },\n\n        _updateCache: function( data ) {\n            this.offset = this.helper.offset();\n            if ( this._isNumber( data.left ) ) {\n                this.position.left = data.left;\n            }\n            if ( this._isNumber( data.top ) ) {\n                this.position.top = data.top;\n            }\n            if ( this._isNumber( data.height ) ) {\n                this.size.height = data.height;\n            }\n            if ( this._isNumber( data.width ) ) {\n                this.size.width = data.width;\n            }\n        },\n\n        _updateRatio: function( data ) {\n\n            var cpos = this.position,\n                csize = this.size,\n                a = this.axis;\n\n            if ( this._isNumber( data.height ) ) {\n                data.width = ( data.height * this.aspectRatio );\n            } else if ( this._isNumber( data.width ) ) {\n                data.height = ( data.width / this.aspectRatio );\n            }\n\n            if ( a === \"sw\" ) {\n                data.left = cpos.left + ( csize.width - data.width );\n                data.top = null;\n            }\n            if ( a === \"nw\" ) {\n                data.top = cpos.top + ( csize.height - data.height );\n                data.left = cpos.left + ( csize.width - data.width );\n            }\n\n            return data;\n        },\n\n        _respectSize: function( data ) {\n\n            var o = this._vBoundaries,\n                a = this.axis,\n                ismaxw = this._isNumber( data.width ) && o.maxWidth && ( o.maxWidth < data.width ),\n                ismaxh = this._isNumber( data.height ) && o.maxHeight && ( o.maxHeight < data.height ),\n                isminw = this._isNumber( data.width ) && o.minWidth && ( o.minWidth > data.width ),\n                isminh = this._isNumber( data.height ) && o.minHeight && ( o.minHeight > data.height ),\n                dw = this.originalPosition.left + this.originalSize.width,\n                dh = this.originalPosition.top + this.originalSize.height,\n                cw = /sw|nw|w/.test( a ), ch = /nw|ne|n/.test( a );\n            if ( isminw ) {\n                data.width = o.minWidth;\n            }\n            if ( isminh ) {\n                data.height = o.minHeight;\n            }\n            if ( ismaxw ) {\n                data.width = o.maxWidth;\n            }\n            if ( ismaxh ) {\n                data.height = o.maxHeight;\n            }\n\n            if ( isminw && cw ) {\n                data.left = dw - o.minWidth;\n            }\n            if ( ismaxw && cw ) {\n                data.left = dw - o.maxWidth;\n            }\n            if ( isminh && ch ) {\n                data.top = dh - o.minHeight;\n            }\n            if ( ismaxh && ch ) {\n                data.top = dh - o.maxHeight;\n            }\n\n            // Fixing jump error on top/left - bug #2330\n            if ( !data.width && !data.height && !data.left && data.top ) {\n                data.top = null;\n            } else if ( !data.width && !data.height && !data.top && data.left ) {\n                data.left = null;\n            }\n\n            return data;\n        },\n\n        _getPaddingPlusBorderDimensions: function( element ) {\n            var i = 0,\n                widths = [],\n                borders = [\n                    element.css( \"borderTopWidth\" ),\n                    element.css( \"borderRightWidth\" ),\n                    element.css( \"borderBottomWidth\" ),\n                    element.css( \"borderLeftWidth\" )\n                ],\n                paddings = [\n                    element.css( \"paddingTop\" ),\n                    element.css( \"paddingRight\" ),\n                    element.css( \"paddingBottom\" ),\n                    element.css( \"paddingLeft\" )\n                ];\n\n            for ( ; i < 4; i++ ) {\n                widths[ i ] = ( parseFloat( borders[ i ] ) || 0 );\n                widths[ i ] += ( parseFloat( paddings[ i ] ) || 0 );\n            }\n\n            return {\n                height: widths[ 0 ] + widths[ 2 ],\n                width: widths[ 1 ] + widths[ 3 ]\n            };\n        },\n\n        _proportionallyResize: function() {\n\n            if ( !this._proportionallyResizeElements.length ) {\n                return;\n            }\n\n            var prel,\n                i = 0,\n                element = this.helper || this.element;\n\n            for ( ; i < this._proportionallyResizeElements.length; i++ ) {\n\n                prel = this._proportionallyResizeElements[ i ];\n\n                // TODO: Seems like a bug to cache this.outerDimensions\n                // considering that we are in a loop.\n                if ( !this.outerDimensions ) {\n                    this.outerDimensions = this._getPaddingPlusBorderDimensions( prel );\n                }\n\n                prel.css( {\n                    height: ( element.height() - this.outerDimensions.height ) || 0,\n                    width: ( element.width() - this.outerDimensions.width ) || 0\n                } );\n\n            }\n\n        },\n\n        _renderProxy: function() {\n\n            var el = this.element, o = this.options;\n            this.elementOffset = el.offset();\n\n            if ( this._helper ) {\n\n                this.helper = this.helper || $( \"<div></div>\" ).css( { overflow: \"hidden\" } );\n\n                this._addClass( this.helper, this._helper );\n                this.helper.css( {\n                    width: this.element.outerWidth(),\n                    height: this.element.outerHeight(),\n                    position: \"absolute\",\n                    left: this.elementOffset.left + \"px\",\n                    top: this.elementOffset.top + \"px\",\n                    zIndex: ++o.zIndex //TODO: Don't modify option\n                } );\n\n                this.helper\n                    .appendTo( \"body\" )\n                    .disableSelection();\n\n            } else {\n                this.helper = this.element;\n            }\n\n        },\n\n        _change: {\n            e: function( event, dx ) {\n                return { width: this.originalSize.width + dx };\n            },\n            w: function( event, dx ) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return { left: sp.left + dx, width: cs.width - dx };\n            },\n            n: function( event, dx, dy ) {\n                var cs = this.originalSize, sp = this.originalPosition;\n                return { top: sp.top + dy, height: cs.height - dy };\n            },\n            s: function( event, dx, dy ) {\n                return { height: this.originalSize.height + dy };\n            },\n            se: function( event, dx, dy ) {\n                return $.extend( this._change.s.apply( this, arguments ),\n                    this._change.e.apply( this, [ event, dx, dy ] ) );\n            },\n            sw: function( event, dx, dy ) {\n                return $.extend( this._change.s.apply( this, arguments ),\n                    this._change.w.apply( this, [ event, dx, dy ] ) );\n            },\n            ne: function( event, dx, dy ) {\n                return $.extend( this._change.n.apply( this, arguments ),\n                    this._change.e.apply( this, [ event, dx, dy ] ) );\n            },\n            nw: function( event, dx, dy ) {\n                return $.extend( this._change.n.apply( this, arguments ),\n                    this._change.w.apply( this, [ event, dx, dy ] ) );\n            }\n        },\n\n        _propagate: function( n, event ) {\n            $.ui.plugin.call( this, n, [ event, this.ui() ] );\n            if ( n !== \"resize\" ) {\n                this._trigger( n, event, this.ui() );\n            }\n        },\n\n        plugins: {},\n\n        ui: function() {\n            return {\n                originalElement: this.originalElement,\n                element: this.element,\n                helper: this.helper,\n                position: this.position,\n                size: this.size,\n                originalSize: this.originalSize,\n                originalPosition: this.originalPosition\n            };\n        }\n\n    } );\n\n    /*\n     * Resizable Extensions\n     */\n\n    $.ui.plugin.add( \"resizable\", \"animate\", {\n\n        stop: function( event ) {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                pr = that._proportionallyResizeElements,\n                ista = pr.length && ( /textarea/i ).test( pr[ 0 ].nodeName ),\n                soffseth = ista && that._hasScroll( pr[ 0 ], \"left\" ) ? 0 : that.sizeDiff.height,\n                soffsetw = ista ? 0 : that.sizeDiff.width,\n                style = {\n                    width: ( that.size.width - soffsetw ),\n                    height: ( that.size.height - soffseth )\n                },\n                left = ( parseFloat( that.element.css( \"left\" ) ) +\n                    ( that.position.left - that.originalPosition.left ) ) || null,\n                top = ( parseFloat( that.element.css( \"top\" ) ) +\n                    ( that.position.top - that.originalPosition.top ) ) || null;\n\n            that.element.animate(\n                $.extend( style, top && left ? { top: top, left: left } : {} ), {\n                    duration: o.animateDuration,\n                    easing: o.animateEasing,\n                    step: function() {\n\n                        var data = {\n                            width: parseFloat( that.element.css( \"width\" ) ),\n                            height: parseFloat( that.element.css( \"height\" ) ),\n                            top: parseFloat( that.element.css( \"top\" ) ),\n                            left: parseFloat( that.element.css( \"left\" ) )\n                        };\n\n                        if ( pr && pr.length ) {\n                            $( pr[ 0 ] ).css( { width: data.width, height: data.height } );\n                        }\n\n                        // Propagating resize, and updating values for each animation step\n                        that._updateCache( data );\n                        that._propagate( \"resize\", event );\n\n                    }\n                }\n            );\n        }\n\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"containment\", {\n\n        start: function() {\n            var element, p, co, ch, cw, width, height,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                el = that.element,\n                oc = o.containment,\n                ce = ( oc instanceof $ ) ?\n                    oc.get( 0 ) :\n                    ( /parent/.test( oc ) ) ? el.parent().get( 0 ) : oc;\n\n            if ( !ce ) {\n                return;\n            }\n\n            that.containerElement = $( ce );\n\n            if ( /document/.test( oc ) || oc === document ) {\n                that.containerOffset = {\n                    left: 0,\n                    top: 0\n                };\n                that.containerPosition = {\n                    left: 0,\n                    top: 0\n                };\n\n                that.parentData = {\n                    element: $( document ),\n                    left: 0,\n                    top: 0,\n                    width: $( document ).width(),\n                    height: $( document ).height() || document.body.parentNode.scrollHeight\n                };\n            } else {\n                element = $( ce );\n                p = [];\n                $( [ \"Top\", \"Right\", \"Left\", \"Bottom\" ] ).each( function( i, name ) {\n                    p[ i ] = that._num( element.css( \"padding\" + name ) );\n                } );\n\n                that.containerOffset = element.offset();\n                that.containerPosition = element.position();\n                that.containerSize = {\n                    height: ( element.innerHeight() - p[ 3 ] ),\n                    width: ( element.innerWidth() - p[ 1 ] )\n                };\n\n                co = that.containerOffset;\n                ch = that.containerSize.height;\n                cw = that.containerSize.width;\n                width = ( that._hasScroll( ce, \"left\" ) ? ce.scrollWidth : cw );\n                height = ( that._hasScroll( ce ) ? ce.scrollHeight : ch );\n\n                that.parentData = {\n                    element: ce,\n                    left: co.left,\n                    top: co.top,\n                    width: width,\n                    height: height\n                };\n            }\n        },\n\n        resize: function( event ) {\n            var woset, hoset, isParent, isOffsetRelative,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                co = that.containerOffset,\n                cp = that.position,\n                pRatio = that._aspectRatio || event.shiftKey,\n                cop = {\n                    top: 0,\n                    left: 0\n                },\n                ce = that.containerElement,\n                continueResize = true;\n\n            if ( ce[ 0 ] !== document && ( /static/ ).test( ce.css( \"position\" ) ) ) {\n                cop = co;\n            }\n\n            if ( cp.left < ( that._helper ? co.left : 0 ) ) {\n                that.size.width = that.size.width +\n                    ( that._helper ?\n                        ( that.position.left - co.left ) :\n                        ( that.position.left - cop.left ) );\n\n                if ( pRatio ) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                    continueResize = false;\n                }\n                that.position.left = o.helper ? co.left : 0;\n            }\n\n            if ( cp.top < ( that._helper ? co.top : 0 ) ) {\n                that.size.height = that.size.height +\n                    ( that._helper ?\n                        ( that.position.top - co.top ) :\n                        that.position.top );\n\n                if ( pRatio ) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                    continueResize = false;\n                }\n                that.position.top = that._helper ? co.top : 0;\n            }\n\n            isParent = that.containerElement.get( 0 ) === that.element.parent().get( 0 );\n            isOffsetRelative = /relative|absolute/.test( that.containerElement.css( \"position\" ) );\n\n            if ( isParent && isOffsetRelative ) {\n                that.offset.left = that.parentData.left + that.position.left;\n                that.offset.top = that.parentData.top + that.position.top;\n            } else {\n                that.offset.left = that.element.offset().left;\n                that.offset.top = that.element.offset().top;\n            }\n\n            woset = Math.abs( that.sizeDiff.width +\n                ( that._helper ?\n                    that.offset.left - cop.left :\n                    ( that.offset.left - co.left ) ) );\n\n            hoset = Math.abs( that.sizeDiff.height +\n                ( that._helper ?\n                    that.offset.top - cop.top :\n                    ( that.offset.top - co.top ) ) );\n\n            if ( woset + that.size.width >= that.parentData.width ) {\n                that.size.width = that.parentData.width - woset;\n                if ( pRatio ) {\n                    that.size.height = that.size.width / that.aspectRatio;\n                    continueResize = false;\n                }\n            }\n\n            if ( hoset + that.size.height >= that.parentData.height ) {\n                that.size.height = that.parentData.height - hoset;\n                if ( pRatio ) {\n                    that.size.width = that.size.height * that.aspectRatio;\n                    continueResize = false;\n                }\n            }\n\n            if ( !continueResize ) {\n                that.position.left = that.prevPosition.left;\n                that.position.top = that.prevPosition.top;\n                that.size.width = that.prevSize.width;\n                that.size.height = that.prevSize.height;\n            }\n        },\n\n        stop: function() {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                co = that.containerOffset,\n                cop = that.containerPosition,\n                ce = that.containerElement,\n                helper = $( that.helper ),\n                ho = helper.offset(),\n                w = helper.outerWidth() - that.sizeDiff.width,\n                h = helper.outerHeight() - that.sizeDiff.height;\n\n            if ( that._helper && !o.animate && ( /relative/ ).test( ce.css( \"position\" ) ) ) {\n                $( this ).css( {\n                    left: ho.left - cop.left - co.left,\n                    width: w,\n                    height: h\n                } );\n            }\n\n            if ( that._helper && !o.animate && ( /static/ ).test( ce.css( \"position\" ) ) ) {\n                $( this ).css( {\n                    left: ho.left - cop.left - co.left,\n                    width: w,\n                    height: h\n                } );\n            }\n        }\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"alsoResize\", {\n\n        start: function() {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options;\n\n            $( o.alsoResize ).each( function() {\n                var el = $( this );\n                el.data( \"ui-resizable-alsoresize\", {\n                    width: parseFloat( el.width() ), height: parseFloat( el.height() ),\n                    left: parseFloat( el.css( \"left\" ) ), top: parseFloat( el.css( \"top\" ) )\n                } );\n            } );\n        },\n\n        resize: function( event, ui ) {\n            var that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                os = that.originalSize,\n                op = that.originalPosition,\n                delta = {\n                    height: ( that.size.height - os.height ) || 0,\n                    width: ( that.size.width - os.width ) || 0,\n                    top: ( that.position.top - op.top ) || 0,\n                    left: ( that.position.left - op.left ) || 0\n                };\n\n            $( o.alsoResize ).each( function() {\n                var el = $( this ), start = $( this ).data( \"ui-resizable-alsoresize\" ), style = {},\n                    css = el.parents( ui.originalElement[ 0 ] ).length ?\n                        [ \"width\", \"height\" ] :\n                        [ \"width\", \"height\", \"top\", \"left\" ];\n\n                $.each( css, function( i, prop ) {\n                    var sum = ( start[ prop ] || 0 ) + ( delta[ prop ] || 0 );\n                    if ( sum && sum >= 0 ) {\n                        style[ prop ] = sum || null;\n                    }\n                } );\n\n                el.css( style );\n            } );\n        },\n\n        stop: function() {\n            $( this ).removeData( \"ui-resizable-alsoresize\" );\n        }\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"ghost\", {\n\n        start: function() {\n\n            var that = $( this ).resizable( \"instance\" ), cs = that.size;\n\n            that.ghost = that.originalElement.clone();\n            that.ghost.css( {\n                opacity: 0.25,\n                display: \"block\",\n                position: \"relative\",\n                height: cs.height,\n                width: cs.width,\n                margin: 0,\n                left: 0,\n                top: 0\n            } );\n\n            that._addClass( that.ghost, \"ui-resizable-ghost\" );\n\n            // DEPRECATED\n            // TODO: remove after 1.12\n            if ( $.uiBackCompat !== false && typeof that.options.ghost === \"string\" ) {\n\n                // Ghost option\n                that.ghost.addClass( this.options.ghost );\n            }\n\n            that.ghost.appendTo( that.helper );\n\n        },\n\n        resize: function() {\n            var that = $( this ).resizable( \"instance\" );\n            if ( that.ghost ) {\n                that.ghost.css( {\n                    position: \"relative\",\n                    height: that.size.height,\n                    width: that.size.width\n                } );\n            }\n        },\n\n        stop: function() {\n            var that = $( this ).resizable( \"instance\" );\n            if ( that.ghost && that.helper ) {\n                that.helper.get( 0 ).removeChild( that.ghost.get( 0 ) );\n            }\n        }\n\n    } );\n\n    $.ui.plugin.add( \"resizable\", \"grid\", {\n\n        resize: function() {\n            var outerDimensions,\n                that = $( this ).resizable( \"instance\" ),\n                o = that.options,\n                cs = that.size,\n                os = that.originalSize,\n                op = that.originalPosition,\n                a = that.axis,\n                grid = typeof o.grid === \"number\" ? [ o.grid, o.grid ] : o.grid,\n                gridX = ( grid[ 0 ] || 1 ),\n                gridY = ( grid[ 1 ] || 1 ),\n                ox = Math.round( ( cs.width - os.width ) / gridX ) * gridX,\n                oy = Math.round( ( cs.height - os.height ) / gridY ) * gridY,\n                newWidth = os.width + ox,\n                newHeight = os.height + oy,\n                isMaxWidth = o.maxWidth && ( o.maxWidth < newWidth ),\n                isMaxHeight = o.maxHeight && ( o.maxHeight < newHeight ),\n                isMinWidth = o.minWidth && ( o.minWidth > newWidth ),\n                isMinHeight = o.minHeight && ( o.minHeight > newHeight );\n\n            o.grid = grid;\n\n            if ( isMinWidth ) {\n                newWidth += gridX;\n            }\n            if ( isMinHeight ) {\n                newHeight += gridY;\n            }\n            if ( isMaxWidth ) {\n                newWidth -= gridX;\n            }\n            if ( isMaxHeight ) {\n                newHeight -= gridY;\n            }\n\n            if ( /^(se|s|e)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n            } else if ( /^(ne)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.top = op.top - oy;\n            } else if ( /^(sw)$/.test( a ) ) {\n                that.size.width = newWidth;\n                that.size.height = newHeight;\n                that.position.left = op.left - ox;\n            } else {\n                if ( newHeight - gridY <= 0 || newWidth - gridX <= 0 ) {\n                    outerDimensions = that._getPaddingPlusBorderDimensions( this );\n                }\n\n                if ( newHeight - gridY > 0 ) {\n                    that.size.height = newHeight;\n                    that.position.top = op.top - oy;\n                } else {\n                    newHeight = gridY - outerDimensions.height;\n                    that.size.height = newHeight;\n                    that.position.top = op.top + os.height - newHeight;\n                }\n                if ( newWidth - gridX > 0 ) {\n                    that.size.width = newWidth;\n                    that.position.left = op.left - ox;\n                } else {\n                    newWidth = gridX - outerDimensions.width;\n                    that.size.width = newWidth;\n                    that.position.left = op.left + os.width - newWidth;\n                }\n            }\n        }\n\n    } );\n\n    return $.ui.resizable;\n\n} );\n","jquery/ui-modules/widgets/spinner.js":"/*!\n * jQuery UI Spinner 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Spinner\n//>>group: Widgets\n//>>description: Displays buttons to easily input numbers via the keyboard or mouse.\n//>>docs: http://api.jqueryui.com/spinner/\n//>>demos: http://jqueryui.com/spinner/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/spinner.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./button\",\n            \"../version\",\n            \"../keycode\",\n            \"../safe-active-element\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    function spinnerModifier( fn ) {\n        return function() {\n            var previous = this.element.val();\n            fn.apply( this, arguments );\n            this._refresh();\n            if ( previous !== this.element.val() ) {\n                this._trigger( \"change\" );\n            }\n        };\n    }\n\n    $.widget( \"ui.spinner\", {\n        version: \"1.13.2\",\n        defaultElement: \"<input>\",\n        widgetEventPrefix: \"spin\",\n        options: {\n            classes: {\n                \"ui-spinner\": \"ui-corner-all\",\n                \"ui-spinner-down\": \"ui-corner-br\",\n                \"ui-spinner-up\": \"ui-corner-tr\"\n            },\n            culture: null,\n            icons: {\n                down: \"ui-icon-triangle-1-s\",\n                up: \"ui-icon-triangle-1-n\"\n            },\n            incremental: true,\n            max: null,\n            min: null,\n            numberFormat: null,\n            page: 10,\n            step: 1,\n\n            change: null,\n            spin: null,\n            start: null,\n            stop: null\n        },\n\n        _create: function() {\n\n            // handle string values that need to be parsed\n            this._setOption( \"max\", this.options.max );\n            this._setOption( \"min\", this.options.min );\n            this._setOption( \"step\", this.options.step );\n\n            // Only format if there is a value, prevents the field from being marked\n            // as invalid in Firefox, see #9573.\n            if ( this.value() !== \"\" ) {\n\n                // Format the value, but don't constrain.\n                this._value( this.element.val(), true );\n            }\n\n            this._draw();\n            this._on( this._events );\n            this._refresh();\n\n            // Turning off autocomplete prevents the browser from remembering the\n            // value when navigating through history, so we re-enable autocomplete\n            // if the page is unloaded before the widget is destroyed. #7790\n            this._on( this.window, {\n                beforeunload: function() {\n                    this.element.removeAttr( \"autocomplete\" );\n                }\n            } );\n        },\n\n        _getCreateOptions: function() {\n            var options = this._super();\n            var element = this.element;\n\n            $.each( [ \"min\", \"max\", \"step\" ], function( i, option ) {\n                var value = element.attr( option );\n                if ( value != null && value.length ) {\n                    options[ option ] = value;\n                }\n            } );\n\n            return options;\n        },\n\n        _events: {\n            keydown: function( event ) {\n                if ( this._start( event ) && this._keydown( event ) ) {\n                    event.preventDefault();\n                }\n            },\n            keyup: \"_stop\",\n            focus: function() {\n                this.previous = this.element.val();\n            },\n            blur: function( event ) {\n                if ( this.cancelBlur ) {\n                    delete this.cancelBlur;\n                    return;\n                }\n\n                this._stop();\n                this._refresh();\n                if ( this.previous !== this.element.val() ) {\n                    this._trigger( \"change\", event );\n                }\n            },\n            mousewheel: function( event, delta ) {\n                var activeElement = $.ui.safeActiveElement( this.document[ 0 ] );\n                var isActive = this.element[ 0 ] === activeElement;\n\n                if ( !isActive || !delta ) {\n                    return;\n                }\n\n                if ( !this.spinning && !this._start( event ) ) {\n                    return false;\n                }\n\n                this._spin( ( delta > 0 ? 1 : -1 ) * this.options.step, event );\n                clearTimeout( this.mousewheelTimer );\n                this.mousewheelTimer = this._delay( function() {\n                    if ( this.spinning ) {\n                        this._stop( event );\n                    }\n                }, 100 );\n                event.preventDefault();\n            },\n            \"mousedown .ui-spinner-button\": function( event ) {\n                var previous;\n\n                // We never want the buttons to have focus; whenever the user is\n                // interacting with the spinner, the focus should be on the input.\n                // If the input is focused then this.previous is properly set from\n                // when the input first received focus. If the input is not focused\n                // then we need to set this.previous based on the value before spinning.\n                previous = this.element[ 0 ] === $.ui.safeActiveElement( this.document[ 0 ] ) ?\n                    this.previous : this.element.val();\n                function checkFocus() {\n                    var isActive = this.element[ 0 ] === $.ui.safeActiveElement( this.document[ 0 ] );\n                    if ( !isActive ) {\n                        this.element.trigger( \"focus\" );\n                        this.previous = previous;\n\n                        // support: IE\n                        // IE sets focus asynchronously, so we need to check if focus\n                        // moved off of the input because the user clicked on the button.\n                        this._delay( function() {\n                            this.previous = previous;\n                        } );\n                    }\n                }\n\n                // Ensure focus is on (or stays on) the text field\n                event.preventDefault();\n                checkFocus.call( this );\n\n                // Support: IE\n                // IE doesn't prevent moving focus even with event.preventDefault()\n                // so we set a flag to know when we should ignore the blur event\n                // and check (again) if focus moved off of the input.\n                this.cancelBlur = true;\n                this._delay( function() {\n                    delete this.cancelBlur;\n                    checkFocus.call( this );\n                } );\n\n                if ( this._start( event ) === false ) {\n                    return;\n                }\n\n                this._repeat( null, $( event.currentTarget )\n                    .hasClass( \"ui-spinner-up\" ) ? 1 : -1, event );\n            },\n            \"mouseup .ui-spinner-button\": \"_stop\",\n            \"mouseenter .ui-spinner-button\": function( event ) {\n\n                // button will add ui-state-active if mouse was down while mouseleave and kept down\n                if ( !$( event.currentTarget ).hasClass( \"ui-state-active\" ) ) {\n                    return;\n                }\n\n                if ( this._start( event ) === false ) {\n                    return false;\n                }\n                this._repeat( null, $( event.currentTarget )\n                    .hasClass( \"ui-spinner-up\" ) ? 1 : -1, event );\n            },\n\n            // TODO: do we really want to consider this a stop?\n            // shouldn't we just stop the repeater and wait until mouseup before\n            // we trigger the stop event?\n            \"mouseleave .ui-spinner-button\": \"_stop\"\n        },\n\n        // Support mobile enhanced option and make backcompat more sane\n        _enhance: function() {\n            this.uiSpinner = this.element\n                .attr( \"autocomplete\", \"off\" )\n                .wrap( \"<span>\" )\n                .parent()\n\n                // Add buttons\n                .append(\n                    \"<a></a><a></a>\"\n                );\n        },\n\n        _draw: function() {\n            this._enhance();\n\n            this._addClass( this.uiSpinner, \"ui-spinner\", \"ui-widget ui-widget-content\" );\n            this._addClass( \"ui-spinner-input\" );\n\n            this.element.attr( \"role\", \"spinbutton\" );\n\n            // Button bindings\n            this.buttons = this.uiSpinner.children( \"a\" )\n                .attr( \"tabIndex\", -1 )\n                .attr( \"aria-hidden\", true )\n                .button( {\n                    classes: {\n                        \"ui-button\": \"\"\n                    }\n                } );\n\n            // TODO: Right now button does not support classes this is already updated in button PR\n            this._removeClass( this.buttons, \"ui-corner-all\" );\n\n            this._addClass( this.buttons.first(), \"ui-spinner-button ui-spinner-up\" );\n            this._addClass( this.buttons.last(), \"ui-spinner-button ui-spinner-down\" );\n            this.buttons.first().button( {\n                \"icon\": this.options.icons.up,\n                \"showLabel\": false\n            } );\n            this.buttons.last().button( {\n                \"icon\": this.options.icons.down,\n                \"showLabel\": false\n            } );\n\n            // IE 6 doesn't understand height: 50% for the buttons\n            // unless the wrapper has an explicit height\n            if ( this.buttons.height() > Math.ceil( this.uiSpinner.height() * 0.5 ) &&\n                this.uiSpinner.height() > 0 ) {\n                this.uiSpinner.height( this.uiSpinner.height() );\n            }\n        },\n\n        _keydown: function( event ) {\n            var options = this.options,\n                keyCode = $.ui.keyCode;\n\n            switch ( event.keyCode ) {\n                case keyCode.UP:\n                    this._repeat( null, 1, event );\n                    return true;\n                case keyCode.DOWN:\n                    this._repeat( null, -1, event );\n                    return true;\n                case keyCode.PAGE_UP:\n                    this._repeat( null, options.page, event );\n                    return true;\n                case keyCode.PAGE_DOWN:\n                    this._repeat( null, -options.page, event );\n                    return true;\n            }\n\n            return false;\n        },\n\n        _start: function( event ) {\n            if ( !this.spinning && this._trigger( \"start\", event ) === false ) {\n                return false;\n            }\n\n            if ( !this.counter ) {\n                this.counter = 1;\n            }\n            this.spinning = true;\n            return true;\n        },\n\n        _repeat: function( i, steps, event ) {\n            i = i || 500;\n\n            clearTimeout( this.timer );\n            this.timer = this._delay( function() {\n                this._repeat( 40, steps, event );\n            }, i );\n\n            this._spin( steps * this.options.step, event );\n        },\n\n        _spin: function( step, event ) {\n            var value = this.value() || 0;\n\n            if ( !this.counter ) {\n                this.counter = 1;\n            }\n\n            value = this._adjustValue( value + step * this._increment( this.counter ) );\n\n            if ( !this.spinning || this._trigger( \"spin\", event, { value: value } ) !== false ) {\n                this._value( value );\n                this.counter++;\n            }\n        },\n\n        _increment: function( i ) {\n            var incremental = this.options.incremental;\n\n            if ( incremental ) {\n                return typeof incremental === \"function\" ?\n                    incremental( i ) :\n                    Math.floor( i * i * i / 50000 - i * i / 500 + 17 * i / 200 + 1 );\n            }\n\n            return 1;\n        },\n\n        _precision: function() {\n            var precision = this._precisionOf( this.options.step );\n            if ( this.options.min !== null ) {\n                precision = Math.max( precision, this._precisionOf( this.options.min ) );\n            }\n            return precision;\n        },\n\n        _precisionOf: function( num ) {\n            var str = num.toString(),\n                decimal = str.indexOf( \".\" );\n            return decimal === -1 ? 0 : str.length - decimal - 1;\n        },\n\n        _adjustValue: function( value ) {\n            var base, aboveMin,\n                options = this.options;\n\n            // Make sure we're at a valid step\n            // - find out where we are relative to the base (min or 0)\n            base = options.min !== null ? options.min : 0;\n            aboveMin = value - base;\n\n            // - round to the nearest step\n            aboveMin = Math.round( aboveMin / options.step ) * options.step;\n\n            // - rounding is based on 0, so adjust back to our base\n            value = base + aboveMin;\n\n            // Fix precision from bad JS floating point math\n            value = parseFloat( value.toFixed( this._precision() ) );\n\n            // Clamp the value\n            if ( options.max !== null && value > options.max ) {\n                return options.max;\n            }\n            if ( options.min !== null && value < options.min ) {\n                return options.min;\n            }\n\n            return value;\n        },\n\n        _stop: function( event ) {\n            if ( !this.spinning ) {\n                return;\n            }\n\n            clearTimeout( this.timer );\n            clearTimeout( this.mousewheelTimer );\n            this.counter = 0;\n            this.spinning = false;\n            this._trigger( \"stop\", event );\n        },\n\n        _setOption: function( key, value ) {\n            var prevValue, first, last;\n\n            if ( key === \"culture\" || key === \"numberFormat\" ) {\n                prevValue = this._parse( this.element.val() );\n                this.options[ key ] = value;\n                this.element.val( this._format( prevValue ) );\n                return;\n            }\n\n            if ( key === \"max\" || key === \"min\" || key === \"step\" ) {\n                if ( typeof value === \"string\" ) {\n                    value = this._parse( value );\n                }\n            }\n            if ( key === \"icons\" ) {\n                first = this.buttons.first().find( \".ui-icon\" );\n                this._removeClass( first, null, this.options.icons.up );\n                this._addClass( first, null, value.up );\n                last = this.buttons.last().find( \".ui-icon\" );\n                this._removeClass( last, null, this.options.icons.down );\n                this._addClass( last, null, value.down );\n            }\n\n            this._super( key, value );\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this._toggleClass( this.uiSpinner, null, \"ui-state-disabled\", !!value );\n            this.element.prop( \"disabled\", !!value );\n            this.buttons.button( value ? \"disable\" : \"enable\" );\n        },\n\n        _setOptions: spinnerModifier( function( options ) {\n            this._super( options );\n        } ),\n\n        _parse: function( val ) {\n            if ( typeof val === \"string\" && val !== \"\" ) {\n                val = window.Globalize && this.options.numberFormat ?\n                    Globalize.parseFloat( val, 10, this.options.culture ) : +val;\n            }\n            return val === \"\" || isNaN( val ) ? null : val;\n        },\n\n        _format: function( value ) {\n            if ( value === \"\" ) {\n                return \"\";\n            }\n            return window.Globalize && this.options.numberFormat ?\n                Globalize.format( value, this.options.numberFormat, this.options.culture ) :\n                value;\n        },\n\n        _refresh: function() {\n            this.element.attr( {\n                \"aria-valuemin\": this.options.min,\n                \"aria-valuemax\": this.options.max,\n\n                // TODO: what should we do with values that can't be parsed?\n                \"aria-valuenow\": this._parse( this.element.val() )\n            } );\n        },\n\n        isValid: function() {\n            var value = this.value();\n\n            // Null is invalid\n            if ( value === null ) {\n                return false;\n            }\n\n            // If value gets adjusted, it's invalid\n            return value === this._adjustValue( value );\n        },\n\n        // Update the value without triggering change\n        _value: function( value, allowAny ) {\n            var parsed;\n            if ( value !== \"\" ) {\n                parsed = this._parse( value );\n                if ( parsed !== null ) {\n                    if ( !allowAny ) {\n                        parsed = this._adjustValue( parsed );\n                    }\n                    value = this._format( parsed );\n                }\n            }\n            this.element.val( value );\n            this._refresh();\n        },\n\n        _destroy: function() {\n            this.element\n                .prop( \"disabled\", false )\n                .removeAttr( \"autocomplete role aria-valuemin aria-valuemax aria-valuenow\" );\n\n            this.uiSpinner.replaceWith( this.element );\n        },\n\n        stepUp: spinnerModifier( function( steps ) {\n            this._stepUp( steps );\n        } ),\n        _stepUp: function( steps ) {\n            if ( this._start() ) {\n                this._spin( ( steps || 1 ) * this.options.step );\n                this._stop();\n            }\n        },\n\n        stepDown: spinnerModifier( function( steps ) {\n            this._stepDown( steps );\n        } ),\n        _stepDown: function( steps ) {\n            if ( this._start() ) {\n                this._spin( ( steps || 1 ) * -this.options.step );\n                this._stop();\n            }\n        },\n\n        pageUp: spinnerModifier( function( pages ) {\n            this._stepUp( ( pages || 1 ) * this.options.page );\n        } ),\n\n        pageDown: spinnerModifier( function( pages ) {\n            this._stepDown( ( pages || 1 ) * this.options.page );\n        } ),\n\n        value: function( newVal ) {\n            if ( !arguments.length ) {\n                return this._parse( this.element.val() );\n            }\n            spinnerModifier( this._value ).call( this, newVal );\n        },\n\n        widget: function() {\n            return this.uiSpinner;\n        }\n    } );\n\n// DEPRECATED\n// TODO: switch return back to widget declaration at top of file when this is removed\n    if ( $.uiBackCompat !== false ) {\n\n        // Backcompat for spinner html extension points\n        $.widget( \"ui.spinner\", $.ui.spinner, {\n            _enhance: function() {\n                this.uiSpinner = this.element\n                    .attr( \"autocomplete\", \"off\" )\n                    .wrap( this._uiSpinnerHtml() )\n                    .parent()\n\n                    // Add buttons\n                    .append( this._buttonHtml() );\n            },\n            _uiSpinnerHtml: function() {\n                return \"<span>\";\n            },\n\n            _buttonHtml: function() {\n                return \"<a></a><a></a>\";\n            }\n        } );\n    }\n\n    return $.ui.spinner;\n\n} );\n","jquery/ui-modules/widgets/selectable.js":"/*!\n * jQuery UI Selectable 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Selectable\n//>>group: Interactions\n//>>description: Allows groups of elements to be selected with the mouse.\n//>>docs: http://api.jqueryui.com/selectable/\n//>>demos: http://jqueryui.com/selectable/\n//>>css.structure: ../../themes/base/selectable.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.selectable\", $.ui.mouse, {\n        version: \"1.13.2\",\n        options: {\n            appendTo: \"body\",\n            autoRefresh: true,\n            distance: 0,\n            filter: \"*\",\n            tolerance: \"touch\",\n\n            // Callbacks\n            selected: null,\n            selecting: null,\n            start: null,\n            stop: null,\n            unselected: null,\n            unselecting: null\n        },\n        _create: function() {\n            var that = this;\n\n            this._addClass( \"ui-selectable\" );\n\n            this.dragged = false;\n\n            // Cache selectee children based on filter\n            this.refresh = function() {\n                that.elementPos = $( that.element[ 0 ] ).offset();\n                that.selectees = $( that.options.filter, that.element[ 0 ] );\n                that._addClass( that.selectees, \"ui-selectee\" );\n                that.selectees.each( function() {\n                    var $this = $( this ),\n                        selecteeOffset = $this.offset(),\n                        pos = {\n                            left: selecteeOffset.left - that.elementPos.left,\n                            top: selecteeOffset.top - that.elementPos.top\n                        };\n                    $.data( this, \"selectable-item\", {\n                        element: this,\n                        $element: $this,\n                        left: pos.left,\n                        top: pos.top,\n                        right: pos.left + $this.outerWidth(),\n                        bottom: pos.top + $this.outerHeight(),\n                        startselected: false,\n                        selected: $this.hasClass( \"ui-selected\" ),\n                        selecting: $this.hasClass( \"ui-selecting\" ),\n                        unselecting: $this.hasClass( \"ui-unselecting\" )\n                    } );\n                } );\n            };\n            this.refresh();\n\n            this._mouseInit();\n\n            this.helper = $( \"<div>\" );\n            this._addClass( this.helper, \"ui-selectable-helper\" );\n        },\n\n        _destroy: function() {\n            this.selectees.removeData( \"selectable-item\" );\n            this._mouseDestroy();\n        },\n\n        _mouseStart: function( event ) {\n            var that = this,\n                options = this.options;\n\n            this.opos = [ event.pageX, event.pageY ];\n            this.elementPos = $( this.element[ 0 ] ).offset();\n\n            if ( this.options.disabled ) {\n                return;\n            }\n\n            this.selectees = $( options.filter, this.element[ 0 ] );\n\n            this._trigger( \"start\", event );\n\n            $( options.appendTo ).append( this.helper );\n\n            // position helper (lasso)\n            this.helper.css( {\n                \"left\": event.pageX,\n                \"top\": event.pageY,\n                \"width\": 0,\n                \"height\": 0\n            } );\n\n            if ( options.autoRefresh ) {\n                this.refresh();\n            }\n\n            this.selectees.filter( \".ui-selected\" ).each( function() {\n                var selectee = $.data( this, \"selectable-item\" );\n                selectee.startselected = true;\n                if ( !event.metaKey && !event.ctrlKey ) {\n                    that._removeClass( selectee.$element, \"ui-selected\" );\n                    selectee.selected = false;\n                    that._addClass( selectee.$element, \"ui-unselecting\" );\n                    selectee.unselecting = true;\n\n                    // selectable UNSELECTING callback\n                    that._trigger( \"unselecting\", event, {\n                        unselecting: selectee.element\n                    } );\n                }\n            } );\n\n            $( event.target ).parents().addBack().each( function() {\n                var doSelect,\n                    selectee = $.data( this, \"selectable-item\" );\n                if ( selectee ) {\n                    doSelect = ( !event.metaKey && !event.ctrlKey ) ||\n                        !selectee.$element.hasClass( \"ui-selected\" );\n                    that._removeClass( selectee.$element, doSelect ? \"ui-unselecting\" : \"ui-selected\" )\n                        ._addClass( selectee.$element, doSelect ? \"ui-selecting\" : \"ui-unselecting\" );\n                    selectee.unselecting = !doSelect;\n                    selectee.selecting = doSelect;\n                    selectee.selected = doSelect;\n\n                    // selectable (UN)SELECTING callback\n                    if ( doSelect ) {\n                        that._trigger( \"selecting\", event, {\n                            selecting: selectee.element\n                        } );\n                    } else {\n                        that._trigger( \"unselecting\", event, {\n                            unselecting: selectee.element\n                        } );\n                    }\n                    return false;\n                }\n            } );\n\n        },\n\n        _mouseDrag: function( event ) {\n\n            this.dragged = true;\n\n            if ( this.options.disabled ) {\n                return;\n            }\n\n            var tmp,\n                that = this,\n                options = this.options,\n                x1 = this.opos[ 0 ],\n                y1 = this.opos[ 1 ],\n                x2 = event.pageX,\n                y2 = event.pageY;\n\n            if ( x1 > x2 ) {\n                tmp = x2; x2 = x1; x1 = tmp;\n            }\n            if ( y1 > y2 ) {\n                tmp = y2; y2 = y1; y1 = tmp;\n            }\n            this.helper.css( { left: x1, top: y1, width: x2 - x1, height: y2 - y1 } );\n\n            this.selectees.each( function() {\n                var selectee = $.data( this, \"selectable-item\" ),\n                    hit = false,\n                    offset = {};\n\n                //prevent helper from being selected if appendTo: selectable\n                if ( !selectee || selectee.element === that.element[ 0 ] ) {\n                    return;\n                }\n\n                offset.left   = selectee.left   + that.elementPos.left;\n                offset.right  = selectee.right  + that.elementPos.left;\n                offset.top    = selectee.top    + that.elementPos.top;\n                offset.bottom = selectee.bottom + that.elementPos.top;\n\n                if ( options.tolerance === \"touch\" ) {\n                    hit = ( !( offset.left > x2 || offset.right < x1 || offset.top > y2 ||\n                        offset.bottom < y1 ) );\n                } else if ( options.tolerance === \"fit\" ) {\n                    hit = ( offset.left > x1 && offset.right < x2 && offset.top > y1 &&\n                        offset.bottom < y2 );\n                }\n\n                if ( hit ) {\n\n                    // SELECT\n                    if ( selectee.selected ) {\n                        that._removeClass( selectee.$element, \"ui-selected\" );\n                        selectee.selected = false;\n                    }\n                    if ( selectee.unselecting ) {\n                        that._removeClass( selectee.$element, \"ui-unselecting\" );\n                        selectee.unselecting = false;\n                    }\n                    if ( !selectee.selecting ) {\n                        that._addClass( selectee.$element, \"ui-selecting\" );\n                        selectee.selecting = true;\n\n                        // selectable SELECTING callback\n                        that._trigger( \"selecting\", event, {\n                            selecting: selectee.element\n                        } );\n                    }\n                } else {\n\n                    // UNSELECT\n                    if ( selectee.selecting ) {\n                        if ( ( event.metaKey || event.ctrlKey ) && selectee.startselected ) {\n                            that._removeClass( selectee.$element, \"ui-selecting\" );\n                            selectee.selecting = false;\n                            that._addClass( selectee.$element, \"ui-selected\" );\n                            selectee.selected = true;\n                        } else {\n                            that._removeClass( selectee.$element, \"ui-selecting\" );\n                            selectee.selecting = false;\n                            if ( selectee.startselected ) {\n                                that._addClass( selectee.$element, \"ui-unselecting\" );\n                                selectee.unselecting = true;\n                            }\n\n                            // selectable UNSELECTING callback\n                            that._trigger( \"unselecting\", event, {\n                                unselecting: selectee.element\n                            } );\n                        }\n                    }\n                    if ( selectee.selected ) {\n                        if ( !event.metaKey && !event.ctrlKey && !selectee.startselected ) {\n                            that._removeClass( selectee.$element, \"ui-selected\" );\n                            selectee.selected = false;\n\n                            that._addClass( selectee.$element, \"ui-unselecting\" );\n                            selectee.unselecting = true;\n\n                            // selectable UNSELECTING callback\n                            that._trigger( \"unselecting\", event, {\n                                unselecting: selectee.element\n                            } );\n                        }\n                    }\n                }\n            } );\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n            var that = this;\n\n            this.dragged = false;\n\n            $( \".ui-unselecting\", this.element[ 0 ] ).each( function() {\n                var selectee = $.data( this, \"selectable-item\" );\n                that._removeClass( selectee.$element, \"ui-unselecting\" );\n                selectee.unselecting = false;\n                selectee.startselected = false;\n                that._trigger( \"unselected\", event, {\n                    unselected: selectee.element\n                } );\n            } );\n            $( \".ui-selecting\", this.element[ 0 ] ).each( function() {\n                var selectee = $.data( this, \"selectable-item\" );\n                that._removeClass( selectee.$element, \"ui-selecting\" )\n                    ._addClass( selectee.$element, \"ui-selected\" );\n                selectee.selecting = false;\n                selectee.selected = true;\n                selectee.startselected = true;\n                that._trigger( \"selected\", event, {\n                    selected: selectee.element\n                } );\n            } );\n            this._trigger( \"stop\", event );\n\n            this.helper.remove();\n\n            return false;\n        }\n\n    } );\n\n} );\n","jquery/ui-modules/widgets/autocomplete.js":"/*!\n * jQuery UI Autocomplete 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Autocomplete\n//>>group: Widgets\n//>>description: Lists suggested words as the user is typing.\n//>>docs: http://api.jqueryui.com/autocomplete/\n//>>demos: http://jqueryui.com/autocomplete/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/autocomplete.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./menu\",\n            \"../keycode\",\n            \"../position\",\n            \"../safe-active-element\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.autocomplete\", {\n        version: \"1.13.2\",\n        defaultElement: \"<input>\",\n        options: {\n            appendTo: null,\n            autoFocus: false,\n            delay: 300,\n            minLength: 1,\n            position: {\n                my: \"left top\",\n                at: \"left bottom\",\n                collision: \"none\"\n            },\n            source: null,\n\n            // Callbacks\n            change: null,\n            close: null,\n            focus: null,\n            open: null,\n            response: null,\n            search: null,\n            select: null\n        },\n\n        requestIndex: 0,\n        pending: 0,\n        liveRegionTimer: null,\n\n        _create: function() {\n\n            // Some browsers only repeat keydown events, not keypress events,\n            // so we use the suppressKeyPress flag to determine if we've already\n            // handled the keydown event. #7269\n            // Unfortunately the code for & in keypress is the same as the up arrow,\n            // so we use the suppressKeyPressRepeat flag to avoid handling keypress\n            // events when we know the keydown event was used to modify the\n            // search term. #7799\n            var suppressKeyPress, suppressKeyPressRepeat, suppressInput,\n                nodeName = this.element[ 0 ].nodeName.toLowerCase(),\n                isTextarea = nodeName === \"textarea\",\n                isInput = nodeName === \"input\";\n\n            // Textareas are always multi-line\n            // Inputs are always single-line, even if inside a contentEditable element\n            // IE also treats inputs as contentEditable\n            // All other element types are determined by whether or not they're contentEditable\n            this.isMultiLine = isTextarea || !isInput && this._isContentEditable( this.element );\n\n            this.valueMethod = this.element[ isTextarea || isInput ? \"val\" : \"text\" ];\n            this.isNewMenu = true;\n\n            this._addClass( \"ui-autocomplete-input\" );\n            this.element.attr( \"autocomplete\", \"off\" );\n\n            this._on( this.element, {\n                keydown: function( event ) {\n                    if ( this.element.prop( \"readOnly\" ) ) {\n                        suppressKeyPress = true;\n                        suppressInput = true;\n                        suppressKeyPressRepeat = true;\n                        return;\n                    }\n\n                    suppressKeyPress = false;\n                    suppressInput = false;\n                    suppressKeyPressRepeat = false;\n                    var keyCode = $.ui.keyCode;\n                    switch ( event.keyCode ) {\n                        case keyCode.PAGE_UP:\n                            suppressKeyPress = true;\n                            this._move( \"previousPage\", event );\n                            break;\n                        case keyCode.PAGE_DOWN:\n                            suppressKeyPress = true;\n                            this._move( \"nextPage\", event );\n                            break;\n                        case keyCode.UP:\n                            suppressKeyPress = true;\n                            this._keyEvent( \"previous\", event );\n                            break;\n                        case keyCode.DOWN:\n                            suppressKeyPress = true;\n                            this._keyEvent( \"next\", event );\n                            break;\n                        case keyCode.ENTER:\n\n                            // when menu is open and has focus\n                            if ( this.menu.active ) {\n\n                                // #6055 - Opera still allows the keypress to occur\n                                // which causes forms to submit\n                                suppressKeyPress = true;\n                                event.preventDefault();\n                                this.menu.select( event );\n                            }\n                            break;\n                        case keyCode.TAB:\n                            if ( this.menu.active ) {\n                                this.menu.select( event );\n                            }\n                            break;\n                        case keyCode.ESCAPE:\n                            if ( this.menu.element.is( \":visible\" ) ) {\n                                if ( !this.isMultiLine ) {\n                                    this._value( this.term );\n                                }\n                                this.close( event );\n\n                                // Different browsers have different default behavior for escape\n                                // Single press can mean undo or clear\n                                // Double press in IE means clear the whole form\n                                event.preventDefault();\n                            }\n                            break;\n                        default:\n                            suppressKeyPressRepeat = true;\n\n                            // search timeout should be triggered before the input value is changed\n                            this._searchTimeout( event );\n                            break;\n                    }\n                },\n                keypress: function( event ) {\n                    if ( suppressKeyPress ) {\n                        suppressKeyPress = false;\n                        if ( !this.isMultiLine || this.menu.element.is( \":visible\" ) ) {\n                            event.preventDefault();\n                        }\n                        return;\n                    }\n                    if ( suppressKeyPressRepeat ) {\n                        return;\n                    }\n\n                    // Replicate some key handlers to allow them to repeat in Firefox and Opera\n                    var keyCode = $.ui.keyCode;\n                    switch ( event.keyCode ) {\n                        case keyCode.PAGE_UP:\n                            this._move( \"previousPage\", event );\n                            break;\n                        case keyCode.PAGE_DOWN:\n                            this._move( \"nextPage\", event );\n                            break;\n                        case keyCode.UP:\n                            this._keyEvent( \"previous\", event );\n                            break;\n                        case keyCode.DOWN:\n                            this._keyEvent( \"next\", event );\n                            break;\n                    }\n                },\n                input: function( event ) {\n                    if ( suppressInput ) {\n                        suppressInput = false;\n                        event.preventDefault();\n                        return;\n                    }\n                    this._searchTimeout( event );\n                },\n                focus: function() {\n                    this.selectedItem = null;\n                    this.previous = this._value();\n                },\n                blur: function( event ) {\n                    clearTimeout( this.searching );\n                    this.close( event );\n                    this._change( event );\n                }\n            } );\n\n            this._initSource();\n            this.menu = $( \"<ul>\" )\n                .appendTo( this._appendTo() )\n                .menu( {\n\n                    // disable ARIA support, the live region takes care of that\n                    role: null\n                } )\n                .hide()\n\n                // Support: IE 11 only, Edge <= 14\n                // For other browsers, we preventDefault() on the mousedown event\n                // to keep the dropdown from taking focus from the input. This doesn't\n                // work for IE/Edge, causing problems with selection and scrolling (#9638)\n                // Happily, IE and Edge support an \"unselectable\" attribute that\n                // prevents an element from receiving focus, exactly what we want here.\n                .attr( {\n                    \"unselectable\": \"on\"\n                } )\n                .menu( \"instance\" );\n\n            this._addClass( this.menu.element, \"ui-autocomplete\", \"ui-front\" );\n            this._on( this.menu.element, {\n                mousedown: function( event ) {\n\n                    // Prevent moving focus out of the text field\n                    event.preventDefault();\n                },\n                menufocus: function( event, ui ) {\n                    var label, item;\n\n                    // support: Firefox\n                    // Prevent accidental activation of menu items in Firefox (#7024 #9118)\n                    if ( this.isNewMenu ) {\n                        this.isNewMenu = false;\n                        if ( event.originalEvent && /^mouse/.test( event.originalEvent.type ) ) {\n                            this.menu.blur();\n\n                            this.document.one( \"mousemove\", function() {\n                                $( event.target ).trigger( event.originalEvent );\n                            } );\n\n                            return;\n                        }\n                    }\n\n                    item = ui.item.data( \"ui-autocomplete-item\" );\n                    if ( false !== this._trigger( \"focus\", event, { item: item } ) ) {\n\n                        // use value to match what will end up in the input, if it was a key event\n                        if ( event.originalEvent && /^key/.test( event.originalEvent.type ) ) {\n                            this._value( item.value );\n                        }\n                    }\n\n                    // Announce the value in the liveRegion\n                    label = ui.item.attr( \"aria-label\" ) || item.value;\n                    if ( label && String.prototype.trim.call( label ).length ) {\n                        clearTimeout( this.liveRegionTimer );\n                        this.liveRegionTimer = this._delay( function() {\n                            this.liveRegion.html( $( \"<div>\" ).text( label ) );\n                        }, 100 );\n                    }\n                },\n                menuselect: function( event, ui ) {\n                    var item = ui.item.data( \"ui-autocomplete-item\" ),\n                        previous = this.previous;\n\n                    // Only trigger when focus was lost (click on menu)\n                    if ( this.element[ 0 ] !== $.ui.safeActiveElement( this.document[ 0 ] ) ) {\n                        this.element.trigger( \"focus\" );\n                        this.previous = previous;\n\n                        // #6109 - IE triggers two focus events and the second\n                        // is asynchronous, so we need to reset the previous\n                        // term synchronously and asynchronously :-(\n                        this._delay( function() {\n                            this.previous = previous;\n                            this.selectedItem = item;\n                        } );\n                    }\n\n                    if ( false !== this._trigger( \"select\", event, { item: item } ) ) {\n                        this._value( item.value );\n                    }\n\n                    // reset the term after the select event\n                    // this allows custom select handling to work properly\n                    this.term = this._value();\n\n                    this.close( event );\n                    this.selectedItem = item;\n                }\n            } );\n\n            this.liveRegion = $( \"<div>\", {\n                role: \"status\",\n                \"aria-live\": \"assertive\",\n                \"aria-relevant\": \"additions\"\n            } )\n                .appendTo( this.document[ 0 ].body );\n\n            this._addClass( this.liveRegion, null, \"ui-helper-hidden-accessible\" );\n\n            // Turning off autocomplete prevents the browser from remembering the\n            // value when navigating through history, so we re-enable autocomplete\n            // if the page is unloaded before the widget is destroyed. #7790\n            this._on( this.window, {\n                beforeunload: function() {\n                    this.element.removeAttr( \"autocomplete\" );\n                }\n            } );\n        },\n\n        _destroy: function() {\n            clearTimeout( this.searching );\n            this.element.removeAttr( \"autocomplete\" );\n            this.menu.element.remove();\n            this.liveRegion.remove();\n        },\n\n        _setOption: function( key, value ) {\n            this._super( key, value );\n            if ( key === \"source\" ) {\n                this._initSource();\n            }\n            if ( key === \"appendTo\" ) {\n                this.menu.element.appendTo( this._appendTo() );\n            }\n            if ( key === \"disabled\" && value && this.xhr ) {\n                this.xhr.abort();\n            }\n        },\n\n        _isEventTargetInWidget: function( event ) {\n            var menuElement = this.menu.element[ 0 ];\n\n            return event.target === this.element[ 0 ] ||\n                event.target === menuElement ||\n                $.contains( menuElement, event.target );\n        },\n\n        _closeOnClickOutside: function( event ) {\n            if ( !this._isEventTargetInWidget( event ) ) {\n                this.close();\n            }\n        },\n\n        _appendTo: function() {\n            var element = this.options.appendTo;\n\n            if ( element ) {\n                element = element.jquery || element.nodeType ?\n                    $( element ) :\n                    this.document.find( element ).eq( 0 );\n            }\n\n            if ( !element || !element[ 0 ] ) {\n                element = this.element.closest( \".ui-front, dialog\" );\n            }\n\n            if ( !element.length ) {\n                element = this.document[ 0 ].body;\n            }\n\n            return element;\n        },\n\n        _initSource: function() {\n            var array, url,\n                that = this;\n            if ( Array.isArray( this.options.source ) ) {\n                array = this.options.source;\n                this.source = function( request, response ) {\n                    response( $.ui.autocomplete.filter( array, request.term ) );\n                };\n            } else if ( typeof this.options.source === \"string\" ) {\n                url = this.options.source;\n                this.source = function( request, response ) {\n                    if ( that.xhr ) {\n                        that.xhr.abort();\n                    }\n                    that.xhr = $.ajax( {\n                        url: url,\n                        data: request,\n                        dataType: \"json\",\n                        success: function( data ) {\n                            response( data );\n                        },\n                        error: function() {\n                            response( [] );\n                        }\n                    } );\n                };\n            } else {\n                this.source = this.options.source;\n            }\n        },\n\n        _searchTimeout: function( event ) {\n            clearTimeout( this.searching );\n            this.searching = this._delay( function() {\n\n                // Search if the value has changed, or if the user retypes the same value (see #7434)\n                var equalValues = this.term === this._value(),\n                    menuVisible = this.menu.element.is( \":visible\" ),\n                    modifierKey = event.altKey || event.ctrlKey || event.metaKey || event.shiftKey;\n\n                if ( !equalValues || ( equalValues && !menuVisible && !modifierKey ) ) {\n                    this.selectedItem = null;\n                    this.search( null, event );\n                }\n            }, this.options.delay );\n        },\n\n        search: function( value, event ) {\n            value = value != null ? value : this._value();\n\n            // Always save the actual value, not the one passed as an argument\n            this.term = this._value();\n\n            if ( value.length < this.options.minLength ) {\n                return this.close( event );\n            }\n\n            if ( this._trigger( \"search\", event ) === false ) {\n                return;\n            }\n\n            return this._search( value );\n        },\n\n        _search: function( value ) {\n            this.pending++;\n            this._addClass( \"ui-autocomplete-loading\" );\n            this.cancelSearch = false;\n\n            this.source( { term: value }, this._response() );\n        },\n\n        _response: function() {\n            var index = ++this.requestIndex;\n\n            return function( content ) {\n                if ( index === this.requestIndex ) {\n                    this.__response( content );\n                }\n\n                this.pending--;\n                if ( !this.pending ) {\n                    this._removeClass( \"ui-autocomplete-loading\" );\n                }\n            }.bind( this );\n        },\n\n        __response: function( content ) {\n            if ( content ) {\n                content = this._normalize( content );\n            }\n            this._trigger( \"response\", null, { content: content } );\n            if ( !this.options.disabled && content && content.length && !this.cancelSearch ) {\n                this._suggest( content );\n                this._trigger( \"open\" );\n            } else {\n\n                // use ._close() instead of .close() so we don't cancel future searches\n                this._close();\n            }\n        },\n\n        close: function( event ) {\n            this.cancelSearch = true;\n            this._close( event );\n        },\n\n        _close: function( event ) {\n\n            // Remove the handler that closes the menu on outside clicks\n            this._off( this.document, \"mousedown\" );\n\n            if ( this.menu.element.is( \":visible\" ) ) {\n                this.menu.element.hide();\n                this.menu.blur();\n                this.isNewMenu = true;\n                this._trigger( \"close\", event );\n            }\n        },\n\n        _change: function( event ) {\n            if ( this.previous !== this._value() ) {\n                this._trigger( \"change\", event, { item: this.selectedItem } );\n            }\n        },\n\n        _normalize: function( items ) {\n\n            // assume all items have the right format when the first item is complete\n            if ( items.length && items[ 0 ].label && items[ 0 ].value ) {\n                return items;\n            }\n            return $.map( items, function( item ) {\n                if ( typeof item === \"string\" ) {\n                    return {\n                        label: item,\n                        value: item\n                    };\n                }\n                return $.extend( {}, item, {\n                    label: item.label || item.value,\n                    value: item.value || item.label\n                } );\n            } );\n        },\n\n        _suggest: function( items ) {\n            var ul = this.menu.element.empty();\n            this._renderMenu( ul, items );\n            this.isNewMenu = true;\n            this.menu.refresh();\n\n            // Size and position menu\n            ul.show();\n            this._resizeMenu();\n            ul.position( $.extend( {\n                of: this.element\n            }, this.options.position ) );\n\n            if ( this.options.autoFocus ) {\n                this.menu.next();\n            }\n\n            // Listen for interactions outside of the widget (#6642)\n            this._on( this.document, {\n                mousedown: \"_closeOnClickOutside\"\n            } );\n        },\n\n        _resizeMenu: function() {\n            var ul = this.menu.element;\n            ul.outerWidth( Math.max(\n\n                // Firefox wraps long text (possibly a rounding bug)\n                // so we add 1px to avoid the wrapping (#7513)\n                ul.width( \"\" ).outerWidth() + 1,\n                this.element.outerWidth()\n            ) );\n        },\n\n        _renderMenu: function( ul, items ) {\n            var that = this;\n            $.each( items, function( index, item ) {\n                that._renderItemData( ul, item );\n            } );\n        },\n\n        _renderItemData: function( ul, item ) {\n            return this._renderItem( ul, item ).data( \"ui-autocomplete-item\", item );\n        },\n\n        _renderItem: function( ul, item ) {\n            return $( \"<li>\" )\n                .append( $( \"<div>\" ).text( item.label ) )\n                .appendTo( ul );\n        },\n\n        _move: function( direction, event ) {\n            if ( !this.menu.element.is( \":visible\" ) ) {\n                this.search( null, event );\n                return;\n            }\n            if ( this.menu.isFirstItem() && /^previous/.test( direction ) ||\n                this.menu.isLastItem() && /^next/.test( direction ) ) {\n\n                if ( !this.isMultiLine ) {\n                    this._value( this.term );\n                }\n\n                this.menu.blur();\n                return;\n            }\n            this.menu[ direction ]( event );\n        },\n\n        widget: function() {\n            return this.menu.element;\n        },\n\n        _value: function() {\n            return this.valueMethod.apply( this.element, arguments );\n        },\n\n        _keyEvent: function( keyEvent, event ) {\n            if ( !this.isMultiLine || this.menu.element.is( \":visible\" ) ) {\n                this._move( keyEvent, event );\n\n                // Prevents moving cursor to beginning/end of the text field in some browsers\n                event.preventDefault();\n            }\n        },\n\n        // Support: Chrome <=50\n        // We should be able to just use this.element.prop( \"isContentEditable\" )\n        // but hidden elements always report false in Chrome.\n        // https://code.google.com/p/chromium/issues/detail?id=313082\n        _isContentEditable: function( element ) {\n            if ( !element.length ) {\n                return false;\n            }\n\n            var editable = element.prop( \"contentEditable\" );\n\n            if ( editable === \"inherit\" ) {\n                return this._isContentEditable( element.parent() );\n            }\n\n            return editable === \"true\";\n        }\n    } );\n\n    $.extend( $.ui.autocomplete, {\n        escapeRegex: function( value ) {\n            return value.replace( /[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\" );\n        },\n        filter: function( array, term ) {\n            var matcher = new RegExp( $.ui.autocomplete.escapeRegex( term ), \"i\" );\n            return $.grep( array, function( value ) {\n                return matcher.test( value.label || value.value || value );\n            } );\n        }\n    } );\n\n// Live region extension, adding a `messages` option\n// NOTE: This is an experimental API. We are still investigating\n// a full solution for string manipulation and internationalization.\n    $.widget( \"ui.autocomplete\", $.ui.autocomplete, {\n        options: {\n            messages: {\n                noResults: \"No search results.\",\n                results: function( amount ) {\n                    return amount + ( amount > 1 ? \" results are\" : \" result is\" ) +\n                        \" available, use up and down arrow keys to navigate.\";\n                }\n            }\n        },\n\n        __response: function( content ) {\n            var message;\n            this._superApply( arguments );\n            if ( this.options.disabled || this.cancelSearch ) {\n                return;\n            }\n            if ( content && content.length ) {\n                message = this.options.messages.results( content.length );\n            } else {\n                message = this.options.messages.noResults;\n            }\n            clearTimeout( this.liveRegionTimer );\n            this.liveRegionTimer = this._delay( function() {\n                this.liveRegion.html( $( \"<div>\" ).text( message ) );\n            }, 100 );\n        }\n    } );\n\n    return $.ui.autocomplete;\n\n} );\n","jquery/ui-modules/widgets/selectmenu.js":"/*!\n * jQuery UI Selectmenu 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Selectmenu\n//>>group: Widgets\n/* eslint-disable max-len */\n//>>description: Duplicates and extends the functionality of a native HTML select element, allowing it to be customizable in behavior and appearance far beyond the limitations of a native select.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/selectmenu/\n//>>demos: http://jqueryui.com/selectmenu/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/selectmenu.css, ../../themes/base/button.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./menu\",\n            \"../form-reset-mixin\",\n            \"../keycode\",\n            \"../labels\",\n            \"../position\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.selectmenu\", [ $.ui.formResetMixin, {\n        version: \"1.13.2\",\n        defaultElement: \"<select>\",\n        options: {\n            appendTo: null,\n            classes: {\n                \"ui-selectmenu-button-open\": \"ui-corner-top\",\n                \"ui-selectmenu-button-closed\": \"ui-corner-all\"\n            },\n            disabled: null,\n            icons: {\n                button: \"ui-icon-triangle-1-s\"\n            },\n            position: {\n                my: \"left top\",\n                at: \"left bottom\",\n                collision: \"none\"\n            },\n            width: false,\n\n            // Callbacks\n            change: null,\n            close: null,\n            focus: null,\n            open: null,\n            select: null\n        },\n\n        _create: function() {\n            var selectmenuId = this.element.uniqueId().attr( \"id\" );\n            this.ids = {\n                element: selectmenuId,\n                button: selectmenuId + \"-button\",\n                menu: selectmenuId + \"-menu\"\n            };\n\n            this._drawButton();\n            this._drawMenu();\n            this._bindFormResetHandler();\n\n            this._rendered = false;\n            this.menuItems = $();\n        },\n\n        _drawButton: function() {\n            var icon,\n                that = this,\n                item = this._parseOption(\n                    this.element.find( \"option:selected\" ),\n                    this.element[ 0 ].selectedIndex\n                );\n\n            // Associate existing label with the new button\n            this.labels = this.element.labels().attr( \"for\", this.ids.button );\n            this._on( this.labels, {\n                click: function( event ) {\n                    this.button.trigger( \"focus\" );\n                    event.preventDefault();\n                }\n            } );\n\n            // Hide original select element\n            this.element.hide();\n\n            // Create button\n            this.button = $( \"<span>\", {\n                tabindex: this.options.disabled ? -1 : 0,\n                id: this.ids.button,\n                role: \"combobox\",\n                \"aria-expanded\": \"false\",\n                \"aria-autocomplete\": \"list\",\n                \"aria-owns\": this.ids.menu,\n                \"aria-haspopup\": \"true\",\n                title: this.element.attr( \"title\" )\n            } )\n                .insertAfter( this.element );\n\n            this._addClass( this.button, \"ui-selectmenu-button ui-selectmenu-button-closed\",\n                \"ui-button ui-widget\" );\n\n            icon = $( \"<span>\" ).appendTo( this.button );\n            this._addClass( icon, \"ui-selectmenu-icon\", \"ui-icon \" + this.options.icons.button );\n            this.buttonItem = this._renderButtonItem( item )\n                .appendTo( this.button );\n\n            if ( this.options.width !== false ) {\n                this._resizeButton();\n            }\n\n            this._on( this.button, this._buttonEvents );\n            this.button.one( \"focusin\", function() {\n\n                // Delay rendering the menu items until the button receives focus.\n                // The menu may have already been rendered via a programmatic open.\n                if ( !that._rendered ) {\n                    that._refreshMenu();\n                }\n            } );\n        },\n\n        _drawMenu: function() {\n            var that = this;\n\n            // Create menu\n            this.menu = $( \"<ul>\", {\n                \"aria-hidden\": \"true\",\n                \"aria-labelledby\": this.ids.button,\n                id: this.ids.menu\n            } );\n\n            // Wrap menu\n            this.menuWrap = $( \"<div>\" ).append( this.menu );\n            this._addClass( this.menuWrap, \"ui-selectmenu-menu\", \"ui-front\" );\n            this.menuWrap.appendTo( this._appendTo() );\n\n            // Initialize menu widget\n            this.menuInstance = this.menu\n                .menu( {\n                    classes: {\n                        \"ui-menu\": \"ui-corner-bottom\"\n                    },\n                    role: \"listbox\",\n                    select: function( event, ui ) {\n                        event.preventDefault();\n\n                        // Support: IE8\n                        // If the item was selected via a click, the text selection\n                        // will be destroyed in IE\n                        that._setSelection();\n\n                        that._select( ui.item.data( \"ui-selectmenu-item\" ), event );\n                    },\n                    focus: function( event, ui ) {\n                        var item = ui.item.data( \"ui-selectmenu-item\" );\n\n                        // Prevent inital focus from firing and check if its a newly focused item\n                        if ( that.focusIndex != null && item.index !== that.focusIndex ) {\n                            that._trigger( \"focus\", event, { item: item } );\n                            if ( !that.isOpen ) {\n                                that._select( item, event );\n                            }\n                        }\n                        that.focusIndex = item.index;\n\n                        that.button.attr( \"aria-activedescendant\",\n                            that.menuItems.eq( item.index ).attr( \"id\" ) );\n                    }\n                } )\n                .menu( \"instance\" );\n\n            // Don't close the menu on mouseleave\n            this.menuInstance._off( this.menu, \"mouseleave\" );\n\n            // Cancel the menu's collapseAll on document click\n            this.menuInstance._closeOnDocumentClick = function() {\n                return false;\n            };\n\n            // Selects often contain empty items, but never contain dividers\n            this.menuInstance._isDivider = function() {\n                return false;\n            };\n        },\n\n        refresh: function() {\n            this._refreshMenu();\n            this.buttonItem.replaceWith(\n                this.buttonItem = this._renderButtonItem(\n\n                    // Fall back to an empty object in case there are no options\n                    this._getSelectedItem().data( \"ui-selectmenu-item\" ) || {}\n                )\n            );\n            if ( this.options.width === null ) {\n                this._resizeButton();\n            }\n        },\n\n        _refreshMenu: function() {\n            var item,\n                options = this.element.find( \"option\" );\n\n            this.menu.empty();\n\n            this._parseOptions( options );\n            this._renderMenu( this.menu, this.items );\n\n            this.menuInstance.refresh();\n            this.menuItems = this.menu.find( \"li\" )\n                .not( \".ui-selectmenu-optgroup\" )\n                .find( \".ui-menu-item-wrapper\" );\n\n            this._rendered = true;\n\n            if ( !options.length ) {\n                return;\n            }\n\n            item = this._getSelectedItem();\n\n            // Update the menu to have the correct item focused\n            this.menuInstance.focus( null, item );\n            this._setAria( item.data( \"ui-selectmenu-item\" ) );\n\n            // Set disabled state\n            this._setOption( \"disabled\", this.element.prop( \"disabled\" ) );\n        },\n\n        open: function( event ) {\n            if ( this.options.disabled ) {\n                return;\n            }\n\n            // If this is the first time the menu is being opened, render the items\n            if ( !this._rendered ) {\n                this._refreshMenu();\n            } else {\n\n                // Menu clears focus on close, reset focus to selected item\n                this._removeClass( this.menu.find( \".ui-state-active\" ), null, \"ui-state-active\" );\n                this.menuInstance.focus( null, this._getSelectedItem() );\n            }\n\n            // If there are no options, don't open the menu\n            if ( !this.menuItems.length ) {\n                return;\n            }\n\n            this.isOpen = true;\n            this._toggleAttr();\n            this._resizeMenu();\n            this._position();\n\n            this._on( this.document, this._documentClick );\n\n            this._trigger( \"open\", event );\n        },\n\n        _position: function() {\n            this.menuWrap.position( $.extend( { of: this.button }, this.options.position ) );\n        },\n\n        close: function( event ) {\n            if ( !this.isOpen ) {\n                return;\n            }\n\n            this.isOpen = false;\n            this._toggleAttr();\n\n            this.range = null;\n            this._off( this.document );\n\n            this._trigger( \"close\", event );\n        },\n\n        widget: function() {\n            return this.button;\n        },\n\n        menuWidget: function() {\n            return this.menu;\n        },\n\n        _renderButtonItem: function( item ) {\n            var buttonItem = $( \"<span>\" );\n\n            this._setText( buttonItem, item.label );\n            this._addClass( buttonItem, \"ui-selectmenu-text\" );\n\n            return buttonItem;\n        },\n\n        _renderMenu: function( ul, items ) {\n            var that = this,\n                currentOptgroup = \"\";\n\n            $.each( items, function( index, item ) {\n                var li;\n\n                if ( item.optgroup !== currentOptgroup ) {\n                    li = $( \"<li>\", {\n                        text: item.optgroup\n                    } );\n                    that._addClass( li, \"ui-selectmenu-optgroup\", \"ui-menu-divider\" +\n                        ( item.element.parent( \"optgroup\" ).prop( \"disabled\" ) ?\n                            \" ui-state-disabled\" :\n                            \"\" ) );\n\n                    li.appendTo( ul );\n\n                    currentOptgroup = item.optgroup;\n                }\n\n                that._renderItemData( ul, item );\n            } );\n        },\n\n        _renderItemData: function( ul, item ) {\n            return this._renderItem( ul, item ).data( \"ui-selectmenu-item\", item );\n        },\n\n        _renderItem: function( ul, item ) {\n            var li = $( \"<li>\" ),\n                wrapper = $( \"<div>\", {\n                    title: item.element.attr( \"title\" )\n                } );\n\n            if ( item.disabled ) {\n                this._addClass( li, null, \"ui-state-disabled\" );\n            }\n            this._setText( wrapper, item.label );\n\n            return li.append( wrapper ).appendTo( ul );\n        },\n\n        _setText: function( element, value ) {\n            if ( value ) {\n                element.text( value );\n            } else {\n                element.html( \"&#160;\" );\n            }\n        },\n\n        _move: function( direction, event ) {\n            var item, next,\n                filter = \".ui-menu-item\";\n\n            if ( this.isOpen ) {\n                item = this.menuItems.eq( this.focusIndex ).parent( \"li\" );\n            } else {\n                item = this.menuItems.eq( this.element[ 0 ].selectedIndex ).parent( \"li\" );\n                filter += \":not(.ui-state-disabled)\";\n            }\n\n            if ( direction === \"first\" || direction === \"last\" ) {\n                next = item[ direction === \"first\" ? \"prevAll\" : \"nextAll\" ]( filter ).eq( -1 );\n            } else {\n                next = item[ direction + \"All\" ]( filter ).eq( 0 );\n            }\n\n            if ( next.length ) {\n                this.menuInstance.focus( event, next );\n            }\n        },\n\n        _getSelectedItem: function() {\n            return this.menuItems.eq( this.element[ 0 ].selectedIndex ).parent( \"li\" );\n        },\n\n        _toggle: function( event ) {\n            this[ this.isOpen ? \"close\" : \"open\" ]( event );\n        },\n\n        _setSelection: function() {\n            var selection;\n\n            if ( !this.range ) {\n                return;\n            }\n\n            if ( window.getSelection ) {\n                selection = window.getSelection();\n                selection.removeAllRanges();\n                selection.addRange( this.range );\n\n                // Support: IE8\n            } else {\n                this.range.select();\n            }\n\n            // Support: IE\n            // Setting the text selection kills the button focus in IE, but\n            // restoring the focus doesn't kill the selection.\n            this.button.trigger( \"focus\" );\n        },\n\n        _documentClick: {\n            mousedown: function( event ) {\n                if ( !this.isOpen ) {\n                    return;\n                }\n\n                if ( !$( event.target ).closest( \".ui-selectmenu-menu, #\" +\n                    $.escapeSelector( this.ids.button ) ).length ) {\n                    this.close( event );\n                }\n            }\n        },\n\n        _buttonEvents: {\n\n            // Prevent text selection from being reset when interacting with the selectmenu (#10144)\n            mousedown: function() {\n                var selection;\n\n                if ( window.getSelection ) {\n                    selection = window.getSelection();\n                    if ( selection.rangeCount ) {\n                        this.range = selection.getRangeAt( 0 );\n                    }\n\n                    // Support: IE8\n                } else {\n                    this.range = document.selection.createRange();\n                }\n            },\n\n            click: function( event ) {\n                this._setSelection();\n                this._toggle( event );\n            },\n\n            keydown: function( event ) {\n                var preventDefault = true;\n                switch ( event.keyCode ) {\n                    case $.ui.keyCode.TAB:\n                    case $.ui.keyCode.ESCAPE:\n                        this.close( event );\n                        preventDefault = false;\n                        break;\n                    case $.ui.keyCode.ENTER:\n                        if ( this.isOpen ) {\n                            this._selectFocusedItem( event );\n                        }\n                        break;\n                    case $.ui.keyCode.UP:\n                        if ( event.altKey ) {\n                            this._toggle( event );\n                        } else {\n                            this._move( \"prev\", event );\n                        }\n                        break;\n                    case $.ui.keyCode.DOWN:\n                        if ( event.altKey ) {\n                            this._toggle( event );\n                        } else {\n                            this._move( \"next\", event );\n                        }\n                        break;\n                    case $.ui.keyCode.SPACE:\n                        if ( this.isOpen ) {\n                            this._selectFocusedItem( event );\n                        } else {\n                            this._toggle( event );\n                        }\n                        break;\n                    case $.ui.keyCode.LEFT:\n                        this._move( \"prev\", event );\n                        break;\n                    case $.ui.keyCode.RIGHT:\n                        this._move( \"next\", event );\n                        break;\n                    case $.ui.keyCode.HOME:\n                    case $.ui.keyCode.PAGE_UP:\n                        this._move( \"first\", event );\n                        break;\n                    case $.ui.keyCode.END:\n                    case $.ui.keyCode.PAGE_DOWN:\n                        this._move( \"last\", event );\n                        break;\n                    default:\n                        this.menu.trigger( event );\n                        preventDefault = false;\n                }\n\n                if ( preventDefault ) {\n                    event.preventDefault();\n                }\n            }\n        },\n\n        _selectFocusedItem: function( event ) {\n            var item = this.menuItems.eq( this.focusIndex ).parent( \"li\" );\n            if ( !item.hasClass( \"ui-state-disabled\" ) ) {\n                this._select( item.data( \"ui-selectmenu-item\" ), event );\n            }\n        },\n\n        _select: function( item, event ) {\n            var oldIndex = this.element[ 0 ].selectedIndex;\n\n            // Change native select element\n            this.element[ 0 ].selectedIndex = item.index;\n            this.buttonItem.replaceWith( this.buttonItem = this._renderButtonItem( item ) );\n            this._setAria( item );\n            this._trigger( \"select\", event, { item: item } );\n\n            if ( item.index !== oldIndex ) {\n                this._trigger( \"change\", event, { item: item } );\n            }\n\n            this.close( event );\n        },\n\n        _setAria: function( item ) {\n            var id = this.menuItems.eq( item.index ).attr( \"id\" );\n\n            this.button.attr( {\n                \"aria-labelledby\": id,\n                \"aria-activedescendant\": id\n            } );\n            this.menu.attr( \"aria-activedescendant\", id );\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"icons\" ) {\n                var icon = this.button.find( \"span.ui-icon\" );\n                this._removeClass( icon, null, this.options.icons.button )\n                    ._addClass( icon, null, value.button );\n            }\n\n            this._super( key, value );\n\n            if ( key === \"appendTo\" ) {\n                this.menuWrap.appendTo( this._appendTo() );\n            }\n\n            if ( key === \"width\" ) {\n                this._resizeButton();\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this.menuInstance.option( \"disabled\", value );\n            this.button.attr( \"aria-disabled\", value );\n            this._toggleClass( this.button, null, \"ui-state-disabled\", value );\n\n            this.element.prop( \"disabled\", value );\n            if ( value ) {\n                this.button.attr( \"tabindex\", -1 );\n                this.close();\n            } else {\n                this.button.attr( \"tabindex\", 0 );\n            }\n        },\n\n        _appendTo: function() {\n            var element = this.options.appendTo;\n\n            if ( element ) {\n                element = element.jquery || element.nodeType ?\n                    $( element ) :\n                    this.document.find( element ).eq( 0 );\n            }\n\n            if ( !element || !element[ 0 ] ) {\n                element = this.element.closest( \".ui-front, dialog\" );\n            }\n\n            if ( !element.length ) {\n                element = this.document[ 0 ].body;\n            }\n\n            return element;\n        },\n\n        _toggleAttr: function() {\n            this.button.attr( \"aria-expanded\", this.isOpen );\n\n            // We can't use two _toggleClass() calls here, because we need to make sure\n            // we always remove classes first and add them second, otherwise if both classes have the\n            // same theme class, it will be removed after we add it.\n            this._removeClass( this.button, \"ui-selectmenu-button-\" +\n                ( this.isOpen ? \"closed\" : \"open\" ) )\n                ._addClass( this.button, \"ui-selectmenu-button-\" +\n                    ( this.isOpen ? \"open\" : \"closed\" ) )\n                ._toggleClass( this.menuWrap, \"ui-selectmenu-open\", null, this.isOpen );\n\n            this.menu.attr( \"aria-hidden\", !this.isOpen );\n        },\n\n        _resizeButton: function() {\n            var width = this.options.width;\n\n            // For `width: false`, just remove inline style and stop\n            if ( width === false ) {\n                this.button.css( \"width\", \"\" );\n                return;\n            }\n\n            // For `width: null`, match the width of the original element\n            if ( width === null ) {\n                width = this.element.show().outerWidth();\n                this.element.hide();\n            }\n\n            this.button.outerWidth( width );\n        },\n\n        _resizeMenu: function() {\n            this.menu.outerWidth( Math.max(\n                this.button.outerWidth(),\n\n                // Support: IE10\n                // IE10 wraps long text (possibly a rounding bug)\n                // so we add 1px to avoid the wrapping\n                this.menu.width( \"\" ).outerWidth() + 1\n            ) );\n        },\n\n        _getCreateOptions: function() {\n            var options = this._super();\n\n            options.disabled = this.element.prop( \"disabled\" );\n\n            return options;\n        },\n\n        _parseOptions: function( options ) {\n            var that = this,\n                data = [];\n            options.each( function( index, item ) {\n                if ( item.hidden ) {\n                    return;\n                }\n\n                data.push( that._parseOption( $( item ), index ) );\n            } );\n            this.items = data;\n        },\n\n        _parseOption: function( option, index ) {\n            var optgroup = option.parent( \"optgroup\" );\n\n            return {\n                element: option,\n                index: index,\n                value: option.val(),\n                label: option.text(),\n                optgroup: optgroup.attr( \"label\" ) || \"\",\n                disabled: optgroup.prop( \"disabled\" ) || option.prop( \"disabled\" )\n            };\n        },\n\n        _destroy: function() {\n            this._unbindFormResetHandler();\n            this.menuWrap.remove();\n            this.button.remove();\n            this.element.show();\n            this.element.removeUniqueId();\n            this.labels.attr( \"for\", this.ids.element );\n        }\n    } ] );\n\n} );\n","jquery/ui-modules/widgets/progressbar.js":"/*!\n * jQuery UI Progressbar 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Progressbar\n//>>group: Widgets\n/* eslint-disable max-len */\n//>>description: Displays a status indicator for loading state, standard percentage, and other progress indicators.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/progressbar/\n//>>demos: http://jqueryui.com/progressbar/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/progressbar.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.progressbar\", {\n        version: \"1.13.2\",\n        options: {\n            classes: {\n                \"ui-progressbar\": \"ui-corner-all\",\n                \"ui-progressbar-value\": \"ui-corner-left\",\n                \"ui-progressbar-complete\": \"ui-corner-right\"\n            },\n            max: 100,\n            value: 0,\n\n            change: null,\n            complete: null\n        },\n\n        min: 0,\n\n        _create: function() {\n\n            // Constrain initial value\n            this.oldValue = this.options.value = this._constrainedValue();\n\n            this.element.attr( {\n\n                // Only set static values; aria-valuenow and aria-valuemax are\n                // set inside _refreshValue()\n                role: \"progressbar\",\n                \"aria-valuemin\": this.min\n            } );\n            this._addClass( \"ui-progressbar\", \"ui-widget ui-widget-content\" );\n\n            this.valueDiv = $( \"<div>\" ).appendTo( this.element );\n            this._addClass( this.valueDiv, \"ui-progressbar-value\", \"ui-widget-header\" );\n            this._refreshValue();\n        },\n\n        _destroy: function() {\n            this.element.removeAttr( \"role aria-valuemin aria-valuemax aria-valuenow\" );\n\n            this.valueDiv.remove();\n        },\n\n        value: function( newValue ) {\n            if ( newValue === undefined ) {\n                return this.options.value;\n            }\n\n            this.options.value = this._constrainedValue( newValue );\n            this._refreshValue();\n        },\n\n        _constrainedValue: function( newValue ) {\n            if ( newValue === undefined ) {\n                newValue = this.options.value;\n            }\n\n            this.indeterminate = newValue === false;\n\n            // Sanitize value\n            if ( typeof newValue !== \"number\" ) {\n                newValue = 0;\n            }\n\n            return this.indeterminate ? false :\n                Math.min( this.options.max, Math.max( this.min, newValue ) );\n        },\n\n        _setOptions: function( options ) {\n\n            // Ensure \"value\" option is set after other values (like max)\n            var value = options.value;\n            delete options.value;\n\n            this._super( options );\n\n            this.options.value = this._constrainedValue( value );\n            this._refreshValue();\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"max\" ) {\n\n                // Don't allow a max less than min\n                value = Math.max( this.min, value );\n            }\n            this._super( key, value );\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this.element.attr( \"aria-disabled\", value );\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n        },\n\n        _percentage: function() {\n            return this.indeterminate ?\n                100 :\n                100 * ( this.options.value - this.min ) / ( this.options.max - this.min );\n        },\n\n        _refreshValue: function() {\n            var value = this.options.value,\n                percentage = this._percentage();\n\n            this.valueDiv\n                .toggle( this.indeterminate || value > this.min )\n                .width( percentage.toFixed( 0 ) + \"%\" );\n\n            this\n                ._toggleClass( this.valueDiv, \"ui-progressbar-complete\", null,\n                    value === this.options.max )\n                ._toggleClass( \"ui-progressbar-indeterminate\", null, this.indeterminate );\n\n            if ( this.indeterminate ) {\n                this.element.removeAttr( \"aria-valuenow\" );\n                if ( !this.overlayDiv ) {\n                    this.overlayDiv = $( \"<div>\" ).appendTo( this.valueDiv );\n                    this._addClass( this.overlayDiv, \"ui-progressbar-overlay\" );\n                }\n            } else {\n                this.element.attr( {\n                    \"aria-valuemax\": this.options.max,\n                    \"aria-valuenow\": value\n                } );\n                if ( this.overlayDiv ) {\n                    this.overlayDiv.remove();\n                    this.overlayDiv = null;\n                }\n            }\n\n            if ( this.oldValue !== value ) {\n                this.oldValue = value;\n                this._trigger( \"change\" );\n            }\n            if ( value === this.options.max ) {\n                this._trigger( \"complete\" );\n            }\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/button.js":"/*!\n * jQuery UI Button 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Button\n//>>group: Widgets\n//>>description: Enhances a form with themeable buttons.\n//>>docs: http://api.jqueryui.com/button/\n//>>demos: http://jqueryui.com/button/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/button.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n\n            // These are only for backcompat\n            // TODO: Remove after 1.12\n            \"./controlgroup\",\n            \"./checkboxradio\",\n\n            \"../keycode\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.widget( \"ui.button\", {\n        version: \"1.13.2\",\n        defaultElement: \"<button>\",\n        options: {\n            classes: {\n                \"ui-button\": \"ui-corner-all\"\n            },\n            disabled: null,\n            icon: null,\n            iconPosition: \"beginning\",\n            label: null,\n            showLabel: true\n        },\n\n        _getCreateOptions: function() {\n            var disabled,\n\n                // This is to support cases like in jQuery Mobile where the base widget does have\n                // an implementation of _getCreateOptions\n                options = this._super() || {};\n\n            this.isInput = this.element.is( \"input\" );\n\n            disabled = this.element[ 0 ].disabled;\n            if ( disabled != null ) {\n                options.disabled = disabled;\n            }\n\n            this.originalLabel = this.isInput ? this.element.val() : this.element.html();\n            if ( this.originalLabel ) {\n                options.label = this.originalLabel;\n            }\n\n            return options;\n        },\n\n        _create: function() {\n            if ( !this.option.showLabel & !this.options.icon ) {\n                this.options.showLabel = true;\n            }\n\n            // We have to check the option again here even though we did in _getCreateOptions,\n            // because null may have been passed on init which would override what was set in\n            // _getCreateOptions\n            if ( this.options.disabled == null ) {\n                this.options.disabled = this.element[ 0 ].disabled || false;\n            }\n\n            this.hasTitle = !!this.element.attr( \"title\" );\n\n            // Check to see if the label needs to be set or if its already correct\n            if ( this.options.label && this.options.label !== this.originalLabel ) {\n                if ( this.isInput ) {\n                    this.element.val( this.options.label );\n                } else {\n                    this.element.html( this.options.label );\n                }\n            }\n            this._addClass( \"ui-button\", \"ui-widget\" );\n            this._setOption( \"disabled\", this.options.disabled );\n            this._enhance();\n\n            if ( this.element.is( \"a\" ) ) {\n                this._on( {\n                    \"keyup\": function( event ) {\n                        if ( event.keyCode === $.ui.keyCode.SPACE ) {\n                            event.preventDefault();\n\n                            // Support: PhantomJS <= 1.9, IE 8 Only\n                            // If a native click is available use it so we actually cause navigation\n                            // otherwise just trigger a click event\n                            if ( this.element[ 0 ].click ) {\n                                this.element[ 0 ].click();\n                            } else {\n                                this.element.trigger( \"click\" );\n                            }\n                        }\n                    }\n                } );\n            }\n        },\n\n        _enhance: function() {\n            if ( !this.element.is( \"button\" ) ) {\n                this.element.attr( \"role\", \"button\" );\n            }\n\n            if ( this.options.icon ) {\n                this._updateIcon( \"icon\", this.options.icon );\n                this._updateTooltip();\n            }\n        },\n\n        _updateTooltip: function() {\n            this.title = this.element.attr( \"title\" );\n\n            if ( !this.options.showLabel && !this.title ) {\n                this.element.attr( \"title\", this.options.label );\n            }\n        },\n\n        _updateIcon: function( option, value ) {\n            var icon = option !== \"iconPosition\",\n                position = icon ? this.options.iconPosition : value,\n                displayBlock = position === \"top\" || position === \"bottom\";\n\n            // Create icon\n            if ( !this.icon ) {\n                this.icon = $( \"<span>\" );\n\n                this._addClass( this.icon, \"ui-button-icon\", \"ui-icon\" );\n\n                if ( !this.options.showLabel ) {\n                    this._addClass( \"ui-button-icon-only\" );\n                }\n            } else if ( icon ) {\n\n                // If we are updating the icon remove the old icon class\n                this._removeClass( this.icon, null, this.options.icon );\n            }\n\n            // If we are updating the icon add the new icon class\n            if ( icon ) {\n                this._addClass( this.icon, null, value );\n            }\n\n            this._attachIcon( position );\n\n            // If the icon is on top or bottom we need to add the ui-widget-icon-block class and remove\n            // the iconSpace if there is one.\n            if ( displayBlock ) {\n                this._addClass( this.icon, null, \"ui-widget-icon-block\" );\n                if ( this.iconSpace ) {\n                    this.iconSpace.remove();\n                }\n            } else {\n\n                // Position is beginning or end so remove the ui-widget-icon-block class and add the\n                // space if it does not exist\n                if ( !this.iconSpace ) {\n                    this.iconSpace = $( \"<span> </span>\" );\n                    this._addClass( this.iconSpace, \"ui-button-icon-space\" );\n                }\n                this._removeClass( this.icon, null, \"ui-wiget-icon-block\" );\n                this._attachIconSpace( position );\n            }\n        },\n\n        _destroy: function() {\n            this.element.removeAttr( \"role\" );\n\n            if ( this.icon ) {\n                this.icon.remove();\n            }\n            if ( this.iconSpace ) {\n                this.iconSpace.remove();\n            }\n            if ( !this.hasTitle ) {\n                this.element.removeAttr( \"title\" );\n            }\n        },\n\n        _attachIconSpace: function( iconPosition ) {\n            this.icon[ /^(?:end|bottom)/.test( iconPosition ) ? \"before\" : \"after\" ]( this.iconSpace );\n        },\n\n        _attachIcon: function( iconPosition ) {\n            this.element[ /^(?:end|bottom)/.test( iconPosition ) ? \"append\" : \"prepend\" ]( this.icon );\n        },\n\n        _setOptions: function( options ) {\n            var newShowLabel = options.showLabel === undefined ?\n                    this.options.showLabel :\n                    options.showLabel,\n                newIcon = options.icon === undefined ? this.options.icon : options.icon;\n\n            if ( !newShowLabel && !newIcon ) {\n                options.showLabel = true;\n            }\n            this._super( options );\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"icon\" ) {\n                if ( value ) {\n                    this._updateIcon( key, value );\n                } else if ( this.icon ) {\n                    this.icon.remove();\n                    if ( this.iconSpace ) {\n                        this.iconSpace.remove();\n                    }\n                }\n            }\n\n            if ( key === \"iconPosition\" ) {\n                this._updateIcon( key, value );\n            }\n\n            // Make sure we can't end up with a button that has neither text nor icon\n            if ( key === \"showLabel\" ) {\n                this._toggleClass( \"ui-button-icon-only\", null, !value );\n                this._updateTooltip();\n            }\n\n            if ( key === \"label\" ) {\n                if ( this.isInput ) {\n                    this.element.val( value );\n                } else {\n\n                    // If there is an icon, append it, else nothing then append the value\n                    // this avoids removal of the icon when setting label text\n                    this.element.html( value );\n                    if ( this.icon ) {\n                        this._attachIcon( this.options.iconPosition );\n                        this._attachIconSpace( this.options.iconPosition );\n                    }\n                }\n            }\n\n            this._super( key, value );\n\n            if ( key === \"disabled\" ) {\n                this._toggleClass( null, \"ui-state-disabled\", value );\n                this.element[ 0 ].disabled = value;\n                if ( value ) {\n                    this.element.trigger( \"blur\" );\n                }\n            }\n        },\n\n        refresh: function() {\n\n            // Make sure to only check disabled if its an element that supports this otherwise\n            // check for the disabled class to determine state\n            var isDisabled = this.element.is( \"input, button\" ) ?\n                this.element[ 0 ].disabled : this.element.hasClass( \"ui-button-disabled\" );\n\n            if ( isDisabled !== this.options.disabled ) {\n                this._setOptions( { disabled: isDisabled } );\n            }\n\n            this._updateTooltip();\n        }\n    } );\n\n// DEPRECATED\n    if ( $.uiBackCompat !== false ) {\n\n        // Text and Icons options\n        $.widget( \"ui.button\", $.ui.button, {\n            options: {\n                text: true,\n                icons: {\n                    primary: null,\n                    secondary: null\n                }\n            },\n\n            _create: function() {\n                if ( this.options.showLabel && !this.options.text ) {\n                    this.options.showLabel = this.options.text;\n                }\n                if ( !this.options.showLabel && this.options.text ) {\n                    this.options.text = this.options.showLabel;\n                }\n                if ( !this.options.icon && ( this.options.icons.primary ||\n                    this.options.icons.secondary ) ) {\n                    if ( this.options.icons.primary ) {\n                        this.options.icon = this.options.icons.primary;\n                    } else {\n                        this.options.icon = this.options.icons.secondary;\n                        this.options.iconPosition = \"end\";\n                    }\n                } else if ( this.options.icon ) {\n                    this.options.icons.primary = this.options.icon;\n                }\n                this._super();\n            },\n\n            _setOption: function( key, value ) {\n                if ( key === \"text\" ) {\n                    this._super( \"showLabel\", value );\n                    return;\n                }\n                if ( key === \"showLabel\" ) {\n                    this.options.text = value;\n                }\n                if ( key === \"icon\" ) {\n                    this.options.icons.primary = value;\n                }\n                if ( key === \"icons\" ) {\n                    if ( value.primary ) {\n                        this._super( \"icon\", value.primary );\n                        this._super( \"iconPosition\", \"beginning\" );\n                    } else if ( value.secondary ) {\n                        this._super( \"icon\", value.secondary );\n                        this._super( \"iconPosition\", \"end\" );\n                    }\n                }\n                this._superApply( arguments );\n            }\n        } );\n\n        $.fn.button = ( function( orig ) {\n            return function( options ) {\n                var isMethodCall = typeof options === \"string\";\n                var args = Array.prototype.slice.call( arguments, 1 );\n                var returnValue = this;\n\n                if ( isMethodCall ) {\n\n                    // If this is an empty collection, we need to have the instance method\n                    // return undefined instead of the jQuery instance\n                    if ( !this.length && options === \"instance\" ) {\n                        returnValue = undefined;\n                    } else {\n                        this.each( function() {\n                            var methodValue;\n                            var type = $( this ).attr( \"type\" );\n                            var name = type !== \"checkbox\" && type !== \"radio\" ?\n                                \"button\" :\n                                \"checkboxradio\";\n                            var instance = $.data( this, \"ui-\" + name );\n\n                            if ( options === \"instance\" ) {\n                                returnValue = instance;\n                                return false;\n                            }\n\n                            if ( !instance ) {\n                                return $.error( \"cannot call methods on button\" +\n                                    \" prior to initialization; \" +\n                                    \"attempted to call method '\" + options + \"'\" );\n                            }\n\n                            if ( typeof instance[ options ] !== \"function\" ||\n                                options.charAt( 0 ) === \"_\" ) {\n                                return $.error( \"no such method '\" + options + \"' for button\" +\n                                    \" widget instance\" );\n                            }\n\n                            methodValue = instance[ options ].apply( instance, args );\n\n                            if ( methodValue !== instance && methodValue !== undefined ) {\n                                returnValue = methodValue && methodValue.jquery ?\n                                    returnValue.pushStack( methodValue.get() ) :\n                                    methodValue;\n                                return false;\n                            }\n                        } );\n                    }\n                } else {\n\n                    // Allow multiple hashes to be passed on init\n                    if ( args.length ) {\n                        options = $.widget.extend.apply( null, [ options ].concat( args ) );\n                    }\n\n                    this.each( function() {\n                        var type = $( this ).attr( \"type\" );\n                        var name = type !== \"checkbox\" && type !== \"radio\" ? \"button\" : \"checkboxradio\";\n                        var instance = $.data( this, \"ui-\" + name );\n\n                        if ( instance ) {\n                            instance.option( options || {} );\n                            if ( instance._init ) {\n                                instance._init();\n                            }\n                        } else {\n                            if ( name === \"button\" ) {\n                                orig.call( $( this ), options );\n                                return;\n                            }\n\n                            $( this ).checkboxradio( $.extend( { icon: false }, options ) );\n                        }\n                    } );\n                }\n\n                return returnValue;\n            };\n        } )( $.fn.button );\n\n        $.fn.buttonset = function() {\n            if ( !$.ui.controlgroup ) {\n                $.error( \"Controlgroup widget missing\" );\n            }\n            if ( arguments[ 0 ] === \"option\" && arguments[ 1 ] === \"items\" && arguments[ 2 ] ) {\n                return this.controlgroup.apply( this,\n                    [ arguments[ 0 ], \"items.button\", arguments[ 2 ] ] );\n            }\n            if ( arguments[ 0 ] === \"option\" && arguments[ 1 ] === \"items\" ) {\n                return this.controlgroup.apply( this, [ arguments[ 0 ], \"items.button\" ] );\n            }\n            if ( typeof arguments[ 0 ] === \"object\" && arguments[ 0 ].items ) {\n                arguments[ 0 ].items = {\n                    button: arguments[ 0 ].items\n                };\n            }\n            return this.controlgroup.apply( this, arguments );\n        };\n    }\n\n    return $.ui.button;\n\n} );\n","jquery/ui-modules/widgets/menu.js":"/*!\n * jQuery UI Menu 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Menu\n//>>group: Widgets\n//>>description: Creates nestable menus.\n//>>docs: http://api.jqueryui.com/menu/\n//>>demos: http://jqueryui.com/menu/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/menu.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../keycode\",\n            \"../position\",\n            \"../safe-active-element\",\n            \"../unique-id\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.menu\", {\n        version: \"1.13.2\",\n        defaultElement: \"<ul>\",\n        delay: 300,\n        options: {\n            icons: {\n                submenu: \"ui-icon-caret-1-e\"\n            },\n            items: \"> *\",\n            menus: \"ul\",\n            position: {\n                my: \"left top\",\n                at: \"right top\"\n            },\n            role: \"menu\",\n\n            // Callbacks\n            blur: null,\n            focus: null,\n            select: null\n        },\n\n        _create: function() {\n            this.activeMenu = this.element;\n\n            // Flag used to prevent firing of the click handler\n            // as the event bubbles up through nested menus\n            this.mouseHandled = false;\n            this.lastMousePosition = { x: null, y: null };\n            this.element\n                .uniqueId()\n                .attr( {\n                    role: this.options.role,\n                    tabIndex: 0\n                } );\n\n            this._addClass( \"ui-menu\", \"ui-widget ui-widget-content\" );\n            this._on( {\n\n                // Prevent focus from sticking to links inside menu after clicking\n                // them (focus should always stay on UL during navigation).\n                \"mousedown .ui-menu-item\": function( event ) {\n                    event.preventDefault();\n\n                    this._activateItem( event );\n                },\n                \"click .ui-menu-item\": function( event ) {\n                    var target = $( event.target );\n                    var active = $( $.ui.safeActiveElement( this.document[ 0 ] ) );\n                    if ( !this.mouseHandled && target.not( \".ui-state-disabled\" ).length ) {\n                        this.select( event );\n\n                        // Only set the mouseHandled flag if the event will bubble, see #9469.\n                        if ( !event.isPropagationStopped() ) {\n                            this.mouseHandled = true;\n                        }\n\n                        // Open submenu on click\n                        if ( target.has( \".ui-menu\" ).length ) {\n                            this.expand( event );\n                        } else if ( !this.element.is( \":focus\" ) &&\n                            active.closest( \".ui-menu\" ).length ) {\n\n                            // Redirect focus to the menu\n                            this.element.trigger( \"focus\", [ true ] );\n\n                            // If the active item is on the top level, let it stay active.\n                            // Otherwise, blur the active item since it is no longer visible.\n                            if ( this.active && this.active.parents( \".ui-menu\" ).length === 1 ) {\n                                clearTimeout( this.timer );\n                            }\n                        }\n                    }\n                },\n                \"mouseenter .ui-menu-item\": \"_activateItem\",\n                \"mousemove .ui-menu-item\": \"_activateItem\",\n                mouseleave: \"collapseAll\",\n                \"mouseleave .ui-menu\": \"collapseAll\",\n                focus: function( event, keepActiveItem ) {\n\n                    // If there's already an active item, keep it active\n                    // If not, activate the first item\n                    var item = this.active || this._menuItems().first();\n\n                    if ( !keepActiveItem ) {\n                        this.focus( event, item );\n                    }\n                },\n                blur: function( event ) {\n                    this._delay( function() {\n                        var notContained = !$.contains(\n                            this.element[ 0 ],\n                            $.ui.safeActiveElement( this.document[ 0 ] )\n                        );\n                        if ( notContained ) {\n                            this.collapseAll( event );\n                        }\n                    } );\n                },\n                keydown: \"_keydown\"\n            } );\n\n            this.refresh();\n\n            // Clicks outside of a menu collapse any open menus\n            this._on( this.document, {\n                click: function( event ) {\n                    if ( this._closeOnDocumentClick( event ) ) {\n                        this.collapseAll( event, true );\n                    }\n\n                    // Reset the mouseHandled flag\n                    this.mouseHandled = false;\n                }\n            } );\n        },\n\n        _activateItem: function( event ) {\n\n            // Ignore mouse events while typeahead is active, see #10458.\n            // Prevents focusing the wrong item when typeahead causes a scroll while the mouse\n            // is over an item in the menu\n            if ( this.previousFilter ) {\n                return;\n            }\n\n            // If the mouse didn't actually move, but the page was scrolled, ignore the event (#9356)\n            if ( event.clientX === this.lastMousePosition.x &&\n                event.clientY === this.lastMousePosition.y ) {\n                return;\n            }\n\n            this.lastMousePosition = {\n                x: event.clientX,\n                y: event.clientY\n            };\n\n            var actualTarget = $( event.target ).closest( \".ui-menu-item\" ),\n                target = $( event.currentTarget );\n\n            // Ignore bubbled events on parent items, see #11641\n            if ( actualTarget[ 0 ] !== target[ 0 ] ) {\n                return;\n            }\n\n            // If the item is already active, there's nothing to do\n            if ( target.is( \".ui-state-active\" ) ) {\n                return;\n            }\n\n            // Remove ui-state-active class from siblings of the newly focused menu item\n            // to avoid a jump caused by adjacent elements both having a class with a border\n            this._removeClass( target.siblings().children( \".ui-state-active\" ),\n                null, \"ui-state-active\" );\n            this.focus( event, target );\n        },\n\n        _destroy: function() {\n            var items = this.element.find( \".ui-menu-item\" )\n                    .removeAttr( \"role aria-disabled\" ),\n                submenus = items.children( \".ui-menu-item-wrapper\" )\n                    .removeUniqueId()\n                    .removeAttr( \"tabIndex role aria-haspopup\" );\n\n            // Destroy (sub)menus\n            this.element\n                .removeAttr( \"aria-activedescendant\" )\n                .find( \".ui-menu\" ).addBack()\n                .removeAttr( \"role aria-labelledby aria-expanded aria-hidden aria-disabled \" +\n                    \"tabIndex\" )\n                .removeUniqueId()\n                .show();\n\n            submenus.children().each( function() {\n                var elem = $( this );\n                if ( elem.data( \"ui-menu-submenu-caret\" ) ) {\n                    elem.remove();\n                }\n            } );\n        },\n\n        _keydown: function( event ) {\n            var match, prev, character, skip,\n                preventDefault = true;\n\n            switch ( event.keyCode ) {\n                case $.ui.keyCode.PAGE_UP:\n                    this.previousPage( event );\n                    break;\n                case $.ui.keyCode.PAGE_DOWN:\n                    this.nextPage( event );\n                    break;\n                case $.ui.keyCode.HOME:\n                    this._move( \"first\", \"first\", event );\n                    break;\n                case $.ui.keyCode.END:\n                    this._move( \"last\", \"last\", event );\n                    break;\n                case $.ui.keyCode.UP:\n                    this.previous( event );\n                    break;\n                case $.ui.keyCode.DOWN:\n                    this.next( event );\n                    break;\n                case $.ui.keyCode.LEFT:\n                    this.collapse( event );\n                    break;\n                case $.ui.keyCode.RIGHT:\n                    if ( this.active && !this.active.is( \".ui-state-disabled\" ) ) {\n                        this.expand( event );\n                    }\n                    break;\n                case $.ui.keyCode.ENTER:\n                case $.ui.keyCode.SPACE:\n                    this._activate( event );\n                    break;\n                case $.ui.keyCode.ESCAPE:\n                    this.collapse( event );\n                    break;\n                default:\n                    preventDefault = false;\n                    prev = this.previousFilter || \"\";\n                    skip = false;\n\n                    // Support number pad values\n                    character = event.keyCode >= 96 && event.keyCode <= 105 ?\n                        ( event.keyCode - 96 ).toString() : String.fromCharCode( event.keyCode );\n\n                    clearTimeout( this.filterTimer );\n\n                    if ( character === prev ) {\n                        skip = true;\n                    } else {\n                        character = prev + character;\n                    }\n\n                    match = this._filterMenuItems( character );\n                    match = skip && match.index( this.active.next() ) !== -1 ?\n                        this.active.nextAll( \".ui-menu-item\" ) :\n                        match;\n\n                    // If no matches on the current filter, reset to the last character pressed\n                    // to move down the menu to the first item that starts with that character\n                    if ( !match.length ) {\n                        character = String.fromCharCode( event.keyCode );\n                        match = this._filterMenuItems( character );\n                    }\n\n                    if ( match.length ) {\n                        this.focus( event, match );\n                        this.previousFilter = character;\n                        this.filterTimer = this._delay( function() {\n                            delete this.previousFilter;\n                        }, 1000 );\n                    } else {\n                        delete this.previousFilter;\n                    }\n            }\n\n            if ( preventDefault ) {\n                event.preventDefault();\n            }\n        },\n\n        _activate: function( event ) {\n            if ( this.active && !this.active.is( \".ui-state-disabled\" ) ) {\n                if ( this.active.children( \"[aria-haspopup='true']\" ).length ) {\n                    this.expand( event );\n                } else {\n                    this.select( event );\n                }\n            }\n        },\n\n        refresh: function() {\n            var menus, items, newSubmenus, newItems, newWrappers,\n                that = this,\n                icon = this.options.icons.submenu,\n                submenus = this.element.find( this.options.menus );\n\n            this._toggleClass( \"ui-menu-icons\", null, !!this.element.find( \".ui-icon\" ).length );\n\n            // Initialize nested menus\n            newSubmenus = submenus.filter( \":not(.ui-menu)\" )\n                .hide()\n                .attr( {\n                    role: this.options.role,\n                    \"aria-hidden\": \"true\",\n                    \"aria-expanded\": \"false\"\n                } )\n                .each( function() {\n                    var menu = $( this ),\n                        item = menu.prev(),\n                        submenuCaret = $( \"<span>\" ).data( \"ui-menu-submenu-caret\", true );\n\n                    that._addClass( submenuCaret, \"ui-menu-icon\", \"ui-icon \" + icon );\n                    item\n                        .attr( \"aria-haspopup\", \"true\" )\n                        .prepend( submenuCaret );\n                    menu.attr( \"aria-labelledby\", item.attr( \"id\" ) );\n                } );\n\n            this._addClass( newSubmenus, \"ui-menu\", \"ui-widget ui-widget-content ui-front\" );\n\n            menus = submenus.add( this.element );\n            items = menus.find( this.options.items );\n\n            // Initialize menu-items containing spaces and/or dashes only as dividers\n            items.not( \".ui-menu-item\" ).each( function() {\n                var item = $( this );\n                if ( that._isDivider( item ) ) {\n                    that._addClass( item, \"ui-menu-divider\", \"ui-widget-content\" );\n                }\n            } );\n\n            // Don't refresh list items that are already adapted\n            newItems = items.not( \".ui-menu-item, .ui-menu-divider\" );\n            newWrappers = newItems.children()\n                .not( \".ui-menu\" )\n                .uniqueId()\n                .attr( {\n                    tabIndex: -1,\n                    role: this._itemRole()\n                } );\n            this._addClass( newItems, \"ui-menu-item\" )\n                ._addClass( newWrappers, \"ui-menu-item-wrapper\" );\n\n            // Add aria-disabled attribute to any disabled menu item\n            items.filter( \".ui-state-disabled\" ).attr( \"aria-disabled\", \"true\" );\n\n            // If the active item has been removed, blur the menu\n            if ( this.active && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n                this.blur();\n            }\n        },\n\n        _itemRole: function() {\n            return {\n                menu: \"menuitem\",\n                listbox: \"option\"\n            }[ this.options.role ];\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"icons\" ) {\n                var icons = this.element.find( \".ui-menu-icon\" );\n                this._removeClass( icons, null, this.options.icons.submenu )\n                    ._addClass( icons, null, value.submenu );\n            }\n            this._super( key, value );\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this.element.attr( \"aria-disabled\", String( value ) );\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n        },\n\n        focus: function( event, item ) {\n            var nested, focused, activeParent;\n            this.blur( event, event && event.type === \"focus\" );\n\n            this._scrollIntoView( item );\n\n            this.active = item.first();\n\n            focused = this.active.children( \".ui-menu-item-wrapper\" );\n            this._addClass( focused, null, \"ui-state-active\" );\n\n            // Only update aria-activedescendant if there's a role\n            // otherwise we assume focus is managed elsewhere\n            if ( this.options.role ) {\n                this.element.attr( \"aria-activedescendant\", focused.attr( \"id\" ) );\n            }\n\n            // Highlight active parent menu item, if any\n            activeParent = this.active\n                .parent()\n                .closest( \".ui-menu-item\" )\n                .children( \".ui-menu-item-wrapper\" );\n            this._addClass( activeParent, null, \"ui-state-active\" );\n\n            if ( event && event.type === \"keydown\" ) {\n                this._close();\n            } else {\n                this.timer = this._delay( function() {\n                    this._close();\n                }, this.delay );\n            }\n\n            nested = item.children( \".ui-menu\" );\n            if ( nested.length && event && ( /^mouse/.test( event.type ) ) ) {\n                this._startOpening( nested );\n            }\n            this.activeMenu = item.parent();\n\n            this._trigger( \"focus\", event, { item: item } );\n        },\n\n        _scrollIntoView: function( item ) {\n            var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n            if ( this._hasScroll() ) {\n                borderTop = parseFloat( $.css( this.activeMenu[ 0 ], \"borderTopWidth\" ) ) || 0;\n                paddingTop = parseFloat( $.css( this.activeMenu[ 0 ], \"paddingTop\" ) ) || 0;\n                offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n                scroll = this.activeMenu.scrollTop();\n                elementHeight = this.activeMenu.height();\n                itemHeight = item.outerHeight();\n\n                if ( offset < 0 ) {\n                    this.activeMenu.scrollTop( scroll + offset );\n                } else if ( offset + itemHeight > elementHeight ) {\n                    this.activeMenu.scrollTop( scroll + offset - elementHeight + itemHeight );\n                }\n            }\n        },\n\n        blur: function( event, fromFocus ) {\n            if ( !fromFocus ) {\n                clearTimeout( this.timer );\n            }\n\n            if ( !this.active ) {\n                return;\n            }\n\n            this._removeClass( this.active.children( \".ui-menu-item-wrapper\" ),\n                null, \"ui-state-active\" );\n\n            this._trigger( \"blur\", event, { item: this.active } );\n            this.active = null;\n        },\n\n        _startOpening: function( submenu ) {\n            clearTimeout( this.timer );\n\n            // Don't open if already open fixes a Firefox bug that caused a .5 pixel\n            // shift in the submenu position when mousing over the caret icon\n            if ( submenu.attr( \"aria-hidden\" ) !== \"true\" ) {\n                return;\n            }\n\n            this.timer = this._delay( function() {\n                this._close();\n                this._open( submenu );\n            }, this.delay );\n        },\n\n        _open: function( submenu ) {\n            var position = $.extend( {\n                of: this.active\n            }, this.options.position );\n\n            clearTimeout( this.timer );\n            this.element.find( \".ui-menu\" ).not( submenu.parents( \".ui-menu\" ) )\n                .hide()\n                .attr( \"aria-hidden\", \"true\" );\n\n            submenu\n                .show()\n                .removeAttr( \"aria-hidden\" )\n                .attr( \"aria-expanded\", \"true\" )\n                .position( position );\n        },\n\n        collapseAll: function( event, all ) {\n            clearTimeout( this.timer );\n            this.timer = this._delay( function() {\n\n                // If we were passed an event, look for the submenu that contains the event\n                var currentMenu = all ? this.element :\n                    $( event && event.target ).closest( this.element.find( \".ui-menu\" ) );\n\n                // If we found no valid submenu ancestor, use the main menu to close all\n                // sub menus anyway\n                if ( !currentMenu.length ) {\n                    currentMenu = this.element;\n                }\n\n                this._close( currentMenu );\n\n                this.blur( event );\n\n                // Work around active item staying active after menu is blurred\n                this._removeClass( currentMenu.find( \".ui-state-active\" ), null, \"ui-state-active\" );\n\n                this.activeMenu = currentMenu;\n            }, all ? 0 : this.delay );\n        },\n\n        // With no arguments, closes the currently active menu - if nothing is active\n        // it closes all menus.  If passed an argument, it will search for menus BELOW\n        _close: function( startMenu ) {\n            if ( !startMenu ) {\n                startMenu = this.active ? this.active.parent() : this.element;\n            }\n\n            startMenu.find( \".ui-menu\" )\n                .hide()\n                .attr( \"aria-hidden\", \"true\" )\n                .attr( \"aria-expanded\", \"false\" );\n        },\n\n        _closeOnDocumentClick: function( event ) {\n            return !$( event.target ).closest( \".ui-menu\" ).length;\n        },\n\n        _isDivider: function( item ) {\n\n            // Match hyphen, em dash, en dash\n            return !/[^\\-\\u2014\\u2013\\s]/.test( item.text() );\n        },\n\n        collapse: function( event ) {\n            var newItem = this.active &&\n                this.active.parent().closest( \".ui-menu-item\", this.element );\n            if ( newItem && newItem.length ) {\n                this._close();\n                this.focus( event, newItem );\n            }\n        },\n\n        expand: function( event ) {\n            var newItem = this.active && this._menuItems( this.active.children( \".ui-menu\" ) ).first();\n\n            if ( newItem && newItem.length ) {\n                this._open( newItem.parent() );\n\n                // Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n                this._delay( function() {\n                    this.focus( event, newItem );\n                } );\n            }\n        },\n\n        next: function( event ) {\n            this._move( \"next\", \"first\", event );\n        },\n\n        previous: function( event ) {\n            this._move( \"prev\", \"last\", event );\n        },\n\n        isFirstItem: function() {\n            return this.active && !this.active.prevAll( \".ui-menu-item\" ).length;\n        },\n\n        isLastItem: function() {\n            return this.active && !this.active.nextAll( \".ui-menu-item\" ).length;\n        },\n\n        _menuItems: function( menu ) {\n            return ( menu || this.element )\n                .find( this.options.items )\n                .filter( \".ui-menu-item\" );\n        },\n\n        _move: function( direction, filter, event ) {\n            var next;\n            if ( this.active ) {\n                if ( direction === \"first\" || direction === \"last\" ) {\n                    next = this.active\n                        [ direction === \"first\" ? \"prevAll\" : \"nextAll\" ]( \".ui-menu-item\" )\n                        .last();\n                } else {\n                    next = this.active\n                        [ direction + \"All\" ]( \".ui-menu-item\" )\n                        .first();\n                }\n            }\n            if ( !next || !next.length || !this.active ) {\n                next = this._menuItems( this.activeMenu )[ filter ]();\n            }\n\n            this.focus( event, next );\n        },\n\n        nextPage: function( event ) {\n            var item, base, height;\n\n            if ( !this.active ) {\n                this.next( event );\n                return;\n            }\n            if ( this.isLastItem() ) {\n                return;\n            }\n            if ( this._hasScroll() ) {\n                base = this.active.offset().top;\n                height = this.element.innerHeight();\n\n                // jQuery 3.2 doesn't include scrollbars in innerHeight, add it back.\n                if ( $.fn.jquery.indexOf( \"3.2.\" ) === 0 ) {\n                    height += this.element[ 0 ].offsetHeight - this.element.outerHeight();\n                }\n\n                this.active.nextAll( \".ui-menu-item\" ).each( function() {\n                    item = $( this );\n                    return item.offset().top - base - height < 0;\n                } );\n\n                this.focus( event, item );\n            } else {\n                this.focus( event, this._menuItems( this.activeMenu )\n                    [ !this.active ? \"first\" : \"last\" ]() );\n            }\n        },\n\n        previousPage: function( event ) {\n            var item, base, height;\n            if ( !this.active ) {\n                this.next( event );\n                return;\n            }\n            if ( this.isFirstItem() ) {\n                return;\n            }\n            if ( this._hasScroll() ) {\n                base = this.active.offset().top;\n                height = this.element.innerHeight();\n\n                // jQuery 3.2 doesn't include scrollbars in innerHeight, add it back.\n                if ( $.fn.jquery.indexOf( \"3.2.\" ) === 0 ) {\n                    height += this.element[ 0 ].offsetHeight - this.element.outerHeight();\n                }\n\n                this.active.prevAll( \".ui-menu-item\" ).each( function() {\n                    item = $( this );\n                    return item.offset().top - base + height > 0;\n                } );\n\n                this.focus( event, item );\n            } else {\n                this.focus( event, this._menuItems( this.activeMenu ).first() );\n            }\n        },\n\n        _hasScroll: function() {\n            return this.element.outerHeight() < this.element.prop( \"scrollHeight\" );\n        },\n\n        select: function( event ) {\n\n            // TODO: It should never be possible to not have an active item at this\n            // point, but the tests don't trigger mouseenter before click.\n            this.active = this.active || $( event.target ).closest( \".ui-menu-item\" );\n            var ui = { item: this.active };\n            if ( !this.active.has( \".ui-menu\" ).length ) {\n                this.collapseAll( event, true );\n            }\n            this._trigger( \"select\", event, ui );\n        },\n\n        _filterMenuItems: function( character ) {\n            var escapedCharacter = character.replace( /[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\" ),\n                regex = new RegExp( \"^\" + escapedCharacter, \"i\" );\n\n            return this.activeMenu\n                .find( this.options.items )\n\n                // Only match on items, not dividers or other content (#10571)\n                .filter( \".ui-menu-item\" )\n                .filter( function() {\n                    return regex.test(\n                        String.prototype.trim.call(\n                            $( this ).children( \".ui-menu-item-wrapper\" ).text() ) );\n                } );\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/slider.js":"/*!\n * jQuery UI Slider 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Slider\n//>>group: Widgets\n//>>description: Displays a flexible slider with ranges and accessibility via keyboard.\n//>>docs: http://api.jqueryui.com/slider/\n//>>demos: http://jqueryui.com/slider/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/slider.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"./mouse\",\n            \"../keycode\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.slider\", $.ui.mouse, {\n        version: \"1.13.2\",\n        widgetEventPrefix: \"slide\",\n\n        options: {\n            animate: false,\n            classes: {\n                \"ui-slider\": \"ui-corner-all\",\n                \"ui-slider-handle\": \"ui-corner-all\",\n\n                // Note: ui-widget-header isn't the most fittingly semantic framework class for this\n                // element, but worked best visually with a variety of themes\n                \"ui-slider-range\": \"ui-corner-all ui-widget-header\"\n            },\n            distance: 0,\n            max: 100,\n            min: 0,\n            orientation: \"horizontal\",\n            range: false,\n            step: 1,\n            value: 0,\n            values: null,\n\n            // Callbacks\n            change: null,\n            slide: null,\n            start: null,\n            stop: null\n        },\n\n        // Number of pages in a slider\n        // (how many times can you page up/down to go through the whole range)\n        numPages: 5,\n\n        _create: function() {\n            this._keySliding = false;\n            this._mouseSliding = false;\n            this._animateOff = true;\n            this._handleIndex = null;\n            this._detectOrientation();\n            this._mouseInit();\n            this._calculateNewMax();\n\n            this._addClass( \"ui-slider ui-slider-\" + this.orientation,\n                \"ui-widget ui-widget-content\" );\n\n            this._refresh();\n\n            this._animateOff = false;\n        },\n\n        _refresh: function() {\n            this._createRange();\n            this._createHandles();\n            this._setupEvents();\n            this._refreshValue();\n        },\n\n        _createHandles: function() {\n            var i, handleCount,\n                options = this.options,\n                existingHandles = this.element.find( \".ui-slider-handle\" ),\n                handle = \"<span tabindex='0'></span>\",\n                handles = [];\n\n            handleCount = ( options.values && options.values.length ) || 1;\n\n            if ( existingHandles.length > handleCount ) {\n                existingHandles.slice( handleCount ).remove();\n                existingHandles = existingHandles.slice( 0, handleCount );\n            }\n\n            for ( i = existingHandles.length; i < handleCount; i++ ) {\n                handles.push( handle );\n            }\n\n            this.handles = existingHandles.add( $( handles.join( \"\" ) ).appendTo( this.element ) );\n\n            this._addClass( this.handles, \"ui-slider-handle\", \"ui-state-default\" );\n\n            this.handle = this.handles.eq( 0 );\n\n            this.handles.each( function( i ) {\n                $( this )\n                    .data( \"ui-slider-handle-index\", i )\n                    .attr( \"tabIndex\", 0 );\n            } );\n        },\n\n        _createRange: function() {\n            var options = this.options;\n\n            if ( options.range ) {\n                if ( options.range === true ) {\n                    if ( !options.values ) {\n                        options.values = [ this._valueMin(), this._valueMin() ];\n                    } else if ( options.values.length && options.values.length !== 2 ) {\n                        options.values = [ options.values[ 0 ], options.values[ 0 ] ];\n                    } else if ( Array.isArray( options.values ) ) {\n                        options.values = options.values.slice( 0 );\n                    }\n                }\n\n                if ( !this.range || !this.range.length ) {\n                    this.range = $( \"<div>\" )\n                        .appendTo( this.element );\n\n                    this._addClass( this.range, \"ui-slider-range\" );\n                } else {\n                    this._removeClass( this.range, \"ui-slider-range-min ui-slider-range-max\" );\n\n                    // Handle range switching from true to min/max\n                    this.range.css( {\n                        \"left\": \"\",\n                        \"bottom\": \"\"\n                    } );\n                }\n                if ( options.range === \"min\" || options.range === \"max\" ) {\n                    this._addClass( this.range, \"ui-slider-range-\" + options.range );\n                }\n            } else {\n                if ( this.range ) {\n                    this.range.remove();\n                }\n                this.range = null;\n            }\n        },\n\n        _setupEvents: function() {\n            this._off( this.handles );\n            this._on( this.handles, this._handleEvents );\n            this._hoverable( this.handles );\n            this._focusable( this.handles );\n        },\n\n        _destroy: function() {\n            this.handles.remove();\n            if ( this.range ) {\n                this.range.remove();\n            }\n\n            this._mouseDestroy();\n        },\n\n        _mouseCapture: function( event ) {\n            var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,\n                that = this,\n                o = this.options;\n\n            if ( o.disabled ) {\n                return false;\n            }\n\n            this.elementSize = {\n                width: this.element.outerWidth(),\n                height: this.element.outerHeight()\n            };\n            this.elementOffset = this.element.offset();\n\n            position = { x: event.pageX, y: event.pageY };\n            normValue = this._normValueFromMouse( position );\n            distance = this._valueMax() - this._valueMin() + 1;\n            this.handles.each( function( i ) {\n                var thisDistance = Math.abs( normValue - that.values( i ) );\n                if ( ( distance > thisDistance ) ||\n                    ( distance === thisDistance &&\n                        ( i === that._lastChangedValue || that.values( i ) === o.min ) ) ) {\n                    distance = thisDistance;\n                    closestHandle = $( this );\n                    index = i;\n                }\n            } );\n\n            allowed = this._start( event, index );\n            if ( allowed === false ) {\n                return false;\n            }\n            this._mouseSliding = true;\n\n            this._handleIndex = index;\n\n            this._addClass( closestHandle, null, \"ui-state-active\" );\n            closestHandle.trigger( \"focus\" );\n\n            offset = closestHandle.offset();\n            mouseOverHandle = !$( event.target ).parents().addBack().is( \".ui-slider-handle\" );\n            this._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {\n                left: event.pageX - offset.left - ( closestHandle.width() / 2 ),\n                top: event.pageY - offset.top -\n                    ( closestHandle.height() / 2 ) -\n                    ( parseInt( closestHandle.css( \"borderTopWidth\" ), 10 ) || 0 ) -\n                    ( parseInt( closestHandle.css( \"borderBottomWidth\" ), 10 ) || 0 ) +\n                    ( parseInt( closestHandle.css( \"marginTop\" ), 10 ) || 0 )\n            };\n\n            if ( !this.handles.hasClass( \"ui-state-hover\" ) ) {\n                this._slide( event, index, normValue );\n            }\n            this._animateOff = true;\n            return true;\n        },\n\n        _mouseStart: function() {\n            return true;\n        },\n\n        _mouseDrag: function( event ) {\n            var position = { x: event.pageX, y: event.pageY },\n                normValue = this._normValueFromMouse( position );\n\n            this._slide( event, this._handleIndex, normValue );\n\n            return false;\n        },\n\n        _mouseStop: function( event ) {\n            this._removeClass( this.handles, null, \"ui-state-active\" );\n            this._mouseSliding = false;\n\n            this._stop( event, this._handleIndex );\n            this._change( event, this._handleIndex );\n\n            this._handleIndex = null;\n            this._clickOffset = null;\n            this._animateOff = false;\n\n            return false;\n        },\n\n        _detectOrientation: function() {\n            this.orientation = ( this.options.orientation === \"vertical\" ) ? \"vertical\" : \"horizontal\";\n        },\n\n        _normValueFromMouse: function( position ) {\n            var pixelTotal,\n                pixelMouse,\n                percentMouse,\n                valueTotal,\n                valueMouse;\n\n            if ( this.orientation === \"horizontal\" ) {\n                pixelTotal = this.elementSize.width;\n                pixelMouse = position.x - this.elementOffset.left -\n                    ( this._clickOffset ? this._clickOffset.left : 0 );\n            } else {\n                pixelTotal = this.elementSize.height;\n                pixelMouse = position.y - this.elementOffset.top -\n                    ( this._clickOffset ? this._clickOffset.top : 0 );\n            }\n\n            percentMouse = ( pixelMouse / pixelTotal );\n            if ( percentMouse > 1 ) {\n                percentMouse = 1;\n            }\n            if ( percentMouse < 0 ) {\n                percentMouse = 0;\n            }\n            if ( this.orientation === \"vertical\" ) {\n                percentMouse = 1 - percentMouse;\n            }\n\n            valueTotal = this._valueMax() - this._valueMin();\n            valueMouse = this._valueMin() + percentMouse * valueTotal;\n\n            return this._trimAlignValue( valueMouse );\n        },\n\n        _uiHash: function( index, value, values ) {\n            var uiHash = {\n                handle: this.handles[ index ],\n                handleIndex: index,\n                value: value !== undefined ? value : this.value()\n            };\n\n            if ( this._hasMultipleValues() ) {\n                uiHash.value = value !== undefined ? value : this.values( index );\n                uiHash.values = values || this.values();\n            }\n\n            return uiHash;\n        },\n\n        _hasMultipleValues: function() {\n            return this.options.values && this.options.values.length;\n        },\n\n        _start: function( event, index ) {\n            return this._trigger( \"start\", event, this._uiHash( index ) );\n        },\n\n        _slide: function( event, index, newVal ) {\n            var allowed, otherVal,\n                currentValue = this.value(),\n                newValues = this.values();\n\n            if ( this._hasMultipleValues() ) {\n                otherVal = this.values( index ? 0 : 1 );\n                currentValue = this.values( index );\n\n                if ( this.options.values.length === 2 && this.options.range === true ) {\n                    newVal =  index === 0 ? Math.min( otherVal, newVal ) : Math.max( otherVal, newVal );\n                }\n\n                newValues[ index ] = newVal;\n            }\n\n            if ( newVal === currentValue ) {\n                return;\n            }\n\n            allowed = this._trigger( \"slide\", event, this._uiHash( index, newVal, newValues ) );\n\n            // A slide can be canceled by returning false from the slide callback\n            if ( allowed === false ) {\n                return;\n            }\n\n            if ( this._hasMultipleValues() ) {\n                this.values( index, newVal );\n            } else {\n                this.value( newVal );\n            }\n        },\n\n        _stop: function( event, index ) {\n            this._trigger( \"stop\", event, this._uiHash( index ) );\n        },\n\n        _change: function( event, index ) {\n            if ( !this._keySliding && !this._mouseSliding ) {\n\n                //store the last changed value index for reference when handles overlap\n                this._lastChangedValue = index;\n                this._trigger( \"change\", event, this._uiHash( index ) );\n            }\n        },\n\n        value: function( newValue ) {\n            if ( arguments.length ) {\n                this.options.value = this._trimAlignValue( newValue );\n                this._refreshValue();\n                this._change( null, 0 );\n                return;\n            }\n\n            return this._value();\n        },\n\n        values: function( index, newValue ) {\n            var vals,\n                newValues,\n                i;\n\n            if ( arguments.length > 1 ) {\n                this.options.values[ index ] = this._trimAlignValue( newValue );\n                this._refreshValue();\n                this._change( null, index );\n                return;\n            }\n\n            if ( arguments.length ) {\n                if ( Array.isArray( arguments[ 0 ] ) ) {\n                    vals = this.options.values;\n                    newValues = arguments[ 0 ];\n                    for ( i = 0; i < vals.length; i += 1 ) {\n                        vals[ i ] = this._trimAlignValue( newValues[ i ] );\n                        this._change( null, i );\n                    }\n                    this._refreshValue();\n                } else {\n                    if ( this._hasMultipleValues() ) {\n                        return this._values( index );\n                    } else {\n                        return this.value();\n                    }\n                }\n            } else {\n                return this._values();\n            }\n        },\n\n        _setOption: function( key, value ) {\n            var i,\n                valsLength = 0;\n\n            if ( key === \"range\" && this.options.range === true ) {\n                if ( value === \"min\" ) {\n                    this.options.value = this._values( 0 );\n                    this.options.values = null;\n                } else if ( value === \"max\" ) {\n                    this.options.value = this._values( this.options.values.length - 1 );\n                    this.options.values = null;\n                }\n            }\n\n            if ( Array.isArray( this.options.values ) ) {\n                valsLength = this.options.values.length;\n            }\n\n            this._super( key, value );\n\n            switch ( key ) {\n                case \"orientation\":\n                    this._detectOrientation();\n                    this._removeClass( \"ui-slider-horizontal ui-slider-vertical\" )\n                        ._addClass( \"ui-slider-\" + this.orientation );\n                    this._refreshValue();\n                    if ( this.options.range ) {\n                        this._refreshRange( value );\n                    }\n\n                    // Reset positioning from previous orientation\n                    this.handles.css( value === \"horizontal\" ? \"bottom\" : \"left\", \"\" );\n                    break;\n                case \"value\":\n                    this._animateOff = true;\n                    this._refreshValue();\n                    this._change( null, 0 );\n                    this._animateOff = false;\n                    break;\n                case \"values\":\n                    this._animateOff = true;\n                    this._refreshValue();\n\n                    // Start from the last handle to prevent unreachable handles (#9046)\n                    for ( i = valsLength - 1; i >= 0; i-- ) {\n                        this._change( null, i );\n                    }\n                    this._animateOff = false;\n                    break;\n                case \"step\":\n                case \"min\":\n                case \"max\":\n                    this._animateOff = true;\n                    this._calculateNewMax();\n                    this._refreshValue();\n                    this._animateOff = false;\n                    break;\n                case \"range\":\n                    this._animateOff = true;\n                    this._refresh();\n                    this._animateOff = false;\n                    break;\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n        },\n\n        //internal value getter\n        // _value() returns value trimmed by min and max, aligned by step\n        _value: function() {\n            var val = this.options.value;\n            val = this._trimAlignValue( val );\n\n            return val;\n        },\n\n        //internal values getter\n        // _values() returns array of values trimmed by min and max, aligned by step\n        // _values( index ) returns single value trimmed by min and max, aligned by step\n        _values: function( index ) {\n            var val,\n                vals,\n                i;\n\n            if ( arguments.length ) {\n                val = this.options.values[ index ];\n                val = this._trimAlignValue( val );\n\n                return val;\n            } else if ( this._hasMultipleValues() ) {\n\n                // .slice() creates a copy of the array\n                // this copy gets trimmed by min and max and then returned\n                vals = this.options.values.slice();\n                for ( i = 0; i < vals.length; i += 1 ) {\n                    vals[ i ] = this._trimAlignValue( vals[ i ] );\n                }\n\n                return vals;\n            } else {\n                return [];\n            }\n        },\n\n        // Returns the step-aligned value that val is closest to, between (inclusive) min and max\n        _trimAlignValue: function( val ) {\n            if ( val <= this._valueMin() ) {\n                return this._valueMin();\n            }\n            if ( val >= this._valueMax() ) {\n                return this._valueMax();\n            }\n            var step = ( this.options.step > 0 ) ? this.options.step : 1,\n                valModStep = ( val - this._valueMin() ) % step,\n                alignValue = val - valModStep;\n\n            if ( Math.abs( valModStep ) * 2 >= step ) {\n                alignValue += ( valModStep > 0 ) ? step : ( -step );\n            }\n\n            // Since JavaScript has problems with large floats, round\n            // the final value to 5 digits after the decimal point (see #4124)\n            return parseFloat( alignValue.toFixed( 5 ) );\n        },\n\n        _calculateNewMax: function() {\n            var max = this.options.max,\n                min = this._valueMin(),\n                step = this.options.step,\n                aboveMin = Math.round( ( max - min ) / step ) * step;\n            max = aboveMin + min;\n            if ( max > this.options.max ) {\n\n                //If max is not divisible by step, rounding off may increase its value\n                max -= step;\n            }\n            this.max = parseFloat( max.toFixed( this._precision() ) );\n        },\n\n        _precision: function() {\n            var precision = this._precisionOf( this.options.step );\n            if ( this.options.min !== null ) {\n                precision = Math.max( precision, this._precisionOf( this.options.min ) );\n            }\n            return precision;\n        },\n\n        _precisionOf: function( num ) {\n            var str = num.toString(),\n                decimal = str.indexOf( \".\" );\n            return decimal === -1 ? 0 : str.length - decimal - 1;\n        },\n\n        _valueMin: function() {\n            return this.options.min;\n        },\n\n        _valueMax: function() {\n            return this.max;\n        },\n\n        _refreshRange: function( orientation ) {\n            if ( orientation === \"vertical\" ) {\n                this.range.css( { \"width\": \"\", \"left\": \"\" } );\n            }\n            if ( orientation === \"horizontal\" ) {\n                this.range.css( { \"height\": \"\", \"bottom\": \"\" } );\n            }\n        },\n\n        _refreshValue: function() {\n            var lastValPercent, valPercent, value, valueMin, valueMax,\n                oRange = this.options.range,\n                o = this.options,\n                that = this,\n                animate = ( !this._animateOff ) ? o.animate : false,\n                _set = {};\n\n            if ( this._hasMultipleValues() ) {\n                this.handles.each( function( i ) {\n                    valPercent = ( that.values( i ) - that._valueMin() ) / ( that._valueMax() -\n                        that._valueMin() ) * 100;\n                    _set[ that.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n                    $( this ).stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n                    if ( that.options.range === true ) {\n                        if ( that.orientation === \"horizontal\" ) {\n                            if ( i === 0 ) {\n                                that.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                                    left: valPercent + \"%\"\n                                }, o.animate );\n                            }\n                            if ( i === 1 ) {\n                                that.range[ animate ? \"animate\" : \"css\" ]( {\n                                    width: ( valPercent - lastValPercent ) + \"%\"\n                                }, {\n                                    queue: false,\n                                    duration: o.animate\n                                } );\n                            }\n                        } else {\n                            if ( i === 0 ) {\n                                that.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                                    bottom: ( valPercent ) + \"%\"\n                                }, o.animate );\n                            }\n                            if ( i === 1 ) {\n                                that.range[ animate ? \"animate\" : \"css\" ]( {\n                                    height: ( valPercent - lastValPercent ) + \"%\"\n                                }, {\n                                    queue: false,\n                                    duration: o.animate\n                                } );\n                            }\n                        }\n                    }\n                    lastValPercent = valPercent;\n                } );\n            } else {\n                value = this.value();\n                valueMin = this._valueMin();\n                valueMax = this._valueMax();\n                valPercent = ( valueMax !== valueMin ) ?\n                    ( value - valueMin ) / ( valueMax - valueMin ) * 100 :\n                    0;\n                _set[ this.orientation === \"horizontal\" ? \"left\" : \"bottom\" ] = valPercent + \"%\";\n                this.handle.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( _set, o.animate );\n\n                if ( oRange === \"min\" && this.orientation === \"horizontal\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        width: valPercent + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"max\" && this.orientation === \"horizontal\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        width: ( 100 - valPercent ) + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"min\" && this.orientation === \"vertical\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        height: valPercent + \"%\"\n                    }, o.animate );\n                }\n                if ( oRange === \"max\" && this.orientation === \"vertical\" ) {\n                    this.range.stop( 1, 1 )[ animate ? \"animate\" : \"css\" ]( {\n                        height: ( 100 - valPercent ) + \"%\"\n                    }, o.animate );\n                }\n            }\n        },\n\n        _handleEvents: {\n            keydown: function( event ) {\n                var allowed, curVal, newVal, step,\n                    index = $( event.target ).data( \"ui-slider-handle-index\" );\n\n                switch ( event.keyCode ) {\n                    case $.ui.keyCode.HOME:\n                    case $.ui.keyCode.END:\n                    case $.ui.keyCode.PAGE_UP:\n                    case $.ui.keyCode.PAGE_DOWN:\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        event.preventDefault();\n                        if ( !this._keySliding ) {\n                            this._keySliding = true;\n                            this._addClass( $( event.target ), null, \"ui-state-active\" );\n                            allowed = this._start( event, index );\n                            if ( allowed === false ) {\n                                return;\n                            }\n                        }\n                        break;\n                }\n\n                step = this.options.step;\n                if ( this._hasMultipleValues() ) {\n                    curVal = newVal = this.values( index );\n                } else {\n                    curVal = newVal = this.value();\n                }\n\n                switch ( event.keyCode ) {\n                    case $.ui.keyCode.HOME:\n                        newVal = this._valueMin();\n                        break;\n                    case $.ui.keyCode.END:\n                        newVal = this._valueMax();\n                        break;\n                    case $.ui.keyCode.PAGE_UP:\n                        newVal = this._trimAlignValue(\n                            curVal + ( ( this._valueMax() - this._valueMin() ) / this.numPages )\n                        );\n                        break;\n                    case $.ui.keyCode.PAGE_DOWN:\n                        newVal = this._trimAlignValue(\n                            curVal - ( ( this._valueMax() - this._valueMin() ) / this.numPages ) );\n                        break;\n                    case $.ui.keyCode.UP:\n                    case $.ui.keyCode.RIGHT:\n                        if ( curVal === this._valueMax() ) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue( curVal + step );\n                        break;\n                    case $.ui.keyCode.DOWN:\n                    case $.ui.keyCode.LEFT:\n                        if ( curVal === this._valueMin() ) {\n                            return;\n                        }\n                        newVal = this._trimAlignValue( curVal - step );\n                        break;\n                }\n\n                this._slide( event, index, newVal );\n            },\n            keyup: function( event ) {\n                var index = $( event.target ).data( \"ui-slider-handle-index\" );\n\n                if ( this._keySliding ) {\n                    this._keySliding = false;\n                    this._stop( event, index );\n                    this._change( event, index );\n                    this._removeClass( $( event.target ), null, \"ui-state-active\" );\n                }\n            }\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/mouse.js":"/*!\n * jQuery UI Mouse 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Mouse\n//>>group: Widgets\n//>>description: Abstracts mouse-based interactions to assist in creating certain widgets.\n//>>docs: http://api.jqueryui.com/mouse/\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../ie\",\n            \"../version\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    var mouseHandled = false;\n    $( document ).on( \"mouseup\", function() {\n        mouseHandled = false;\n    } );\n\n    return $.widget( \"ui.mouse\", {\n        version: \"1.13.2\",\n        options: {\n            cancel: \"input, textarea, button, select, option\",\n            distance: 1,\n            delay: 0\n        },\n        _mouseInit: function() {\n            var that = this;\n\n            this.element\n                .on( \"mousedown.\" + this.widgetName, function( event ) {\n                    return that._mouseDown( event );\n                } )\n                .on( \"click.\" + this.widgetName, function( event ) {\n                    if ( true === $.data( event.target, that.widgetName + \".preventClickEvent\" ) ) {\n                        $.removeData( event.target, that.widgetName + \".preventClickEvent\" );\n                        event.stopImmediatePropagation();\n                        return false;\n                    }\n                } );\n\n            this.started = false;\n        },\n\n        // TODO: make sure destroying one instance of mouse doesn't mess with\n        // other instances of mouse\n        _mouseDestroy: function() {\n            this.element.off( \".\" + this.widgetName );\n            if ( this._mouseMoveDelegate ) {\n                this.document\n                    .off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                    .off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n            }\n        },\n\n        _mouseDown: function( event ) {\n\n            // don't let more than one widget handle mouseStart\n            if ( mouseHandled ) {\n                return;\n            }\n\n            this._mouseMoved = false;\n\n            // We may have missed mouseup (out of window)\n            if ( this._mouseStarted ) {\n                this._mouseUp( event );\n            }\n\n            this._mouseDownEvent = event;\n\n            var that = this,\n                btnIsLeft = ( event.which === 1 ),\n\n                // event.target.nodeName works around a bug in IE 8 with\n                // disabled inputs (#7620)\n                elIsCancel = ( typeof this.options.cancel === \"string\" && event.target.nodeName ?\n                    $( event.target ).closest( this.options.cancel ).length : false );\n            if ( !btnIsLeft || elIsCancel || !this._mouseCapture( event ) ) {\n                return true;\n            }\n\n            this.mouseDelayMet = !this.options.delay;\n            if ( !this.mouseDelayMet ) {\n                this._mouseDelayTimer = setTimeout( function() {\n                    that.mouseDelayMet = true;\n                }, this.options.delay );\n            }\n\n            if ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n                this._mouseStarted = ( this._mouseStart( event ) !== false );\n                if ( !this._mouseStarted ) {\n                    event.preventDefault();\n                    return true;\n                }\n            }\n\n            // Click event may never have fired (Gecko & Opera)\n            if ( true === $.data( event.target, this.widgetName + \".preventClickEvent\" ) ) {\n                $.removeData( event.target, this.widgetName + \".preventClickEvent\" );\n            }\n\n            // These delegates are required to keep context\n            this._mouseMoveDelegate = function( event ) {\n                return that._mouseMove( event );\n            };\n            this._mouseUpDelegate = function( event ) {\n                return that._mouseUp( event );\n            };\n\n            this.document\n                .on( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                .on( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n            event.preventDefault();\n\n            mouseHandled = true;\n            return true;\n        },\n\n        _mouseMove: function( event ) {\n\n            // Only check for mouseups outside the document if you've moved inside the document\n            // at least once. This prevents the firing of mouseup in the case of IE<9, which will\n            // fire a mousemove event if content is placed under the cursor. See #7778\n            // Support: IE <9\n            if ( this._mouseMoved ) {\n\n                // IE mouseup check - mouseup happened when mouse was out of window\n                if ( $.ui.ie && ( !document.documentMode || document.documentMode < 9 ) &&\n                    !event.button ) {\n                    return this._mouseUp( event );\n\n                    // Iframe mouseup check - mouseup occurred in another document\n                } else if ( !event.which ) {\n\n                    // Support: Safari <=8 - 9\n                    // Safari sets which to 0 if you press any of the following keys\n                    // during a drag (#14461)\n                    if ( event.originalEvent.altKey || event.originalEvent.ctrlKey ||\n                        event.originalEvent.metaKey || event.originalEvent.shiftKey ) {\n                        this.ignoreMissingWhich = true;\n                    } else if ( !this.ignoreMissingWhich ) {\n                        return this._mouseUp( event );\n                    }\n                }\n            }\n\n            if ( event.which || event.button ) {\n                this._mouseMoved = true;\n            }\n\n            if ( this._mouseStarted ) {\n                this._mouseDrag( event );\n                return event.preventDefault();\n            }\n\n            if ( this._mouseDistanceMet( event ) && this._mouseDelayMet( event ) ) {\n                this._mouseStarted =\n                    ( this._mouseStart( this._mouseDownEvent, event ) !== false );\n                if ( this._mouseStarted ) {\n                    this._mouseDrag( event );\n                } else {\n                    this._mouseUp( event );\n                }\n            }\n\n            return !this._mouseStarted;\n        },\n\n        _mouseUp: function( event ) {\n            this.document\n                .off( \"mousemove.\" + this.widgetName, this._mouseMoveDelegate )\n                .off( \"mouseup.\" + this.widgetName, this._mouseUpDelegate );\n\n            if ( this._mouseStarted ) {\n                this._mouseStarted = false;\n\n                if ( event.target === this._mouseDownEvent.target ) {\n                    $.data( event.target, this.widgetName + \".preventClickEvent\", true );\n                }\n\n                this._mouseStop( event );\n            }\n\n            if ( this._mouseDelayTimer ) {\n                clearTimeout( this._mouseDelayTimer );\n                delete this._mouseDelayTimer;\n            }\n\n            this.ignoreMissingWhich = false;\n            mouseHandled = false;\n            event.preventDefault();\n        },\n\n        _mouseDistanceMet: function( event ) {\n            return ( Math.max(\n                    Math.abs( this._mouseDownEvent.pageX - event.pageX ),\n                    Math.abs( this._mouseDownEvent.pageY - event.pageY )\n                ) >= this.options.distance\n            );\n        },\n\n        _mouseDelayMet: function( /* event */ ) {\n            return this.mouseDelayMet;\n        },\n\n        // These are placeholder methods, to be overriden by extending plugin\n        _mouseStart: function( /* event */ ) {},\n        _mouseDrag: function( /* event */ ) {},\n        _mouseStop: function( /* event */ ) {},\n        _mouseCapture: function( /* event */ ) {\n            return true;\n        }\n    } );\n\n} );\n","jquery/ui-modules/widgets/datepicker.js":"/* eslint-disable max-len, camelcase */\n/*!\n * jQuery UI Datepicker 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Datepicker\n//>>group: Widgets\n//>>description: Displays a calendar from an input or inline for selecting dates.\n//>>docs: http://api.jqueryui.com/datepicker/\n//>>demos: http://jqueryui.com/datepicker/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/datepicker.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../keycode\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    $.extend( $.ui, { datepicker: { version: \"1.13.2\" } } );\n\n    var datepicker_instActive;\n\n    function datepicker_getZindex( elem ) {\n        var position, value;\n        while ( elem.length && elem[ 0 ] !== document ) {\n\n            // Ignore z-index if position is set to a value where z-index is ignored by the browser\n            // This makes behavior of this function consistent across browsers\n            // WebKit always returns auto if the element is positioned\n            position = elem.css( \"position\" );\n            if ( position === \"absolute\" || position === \"relative\" || position === \"fixed\" ) {\n\n                // IE returns 0 when zIndex is not specified\n                // other browsers return a string\n                // we ignore the case of nested elements with an explicit value of 0\n                // <div style=\"z-index: -10;\"><div style=\"z-index: 0;\"></div></div>\n                value = parseInt( elem.css( \"zIndex\" ), 10 );\n                if ( !isNaN( value ) && value !== 0 ) {\n                    return value;\n                }\n            }\n            elem = elem.parent();\n        }\n\n        return 0;\n    }\n\n    /* Date picker manager.\n       Use the singleton instance of this class, $.datepicker, to interact with the date picker.\n       Settings for (groups of) date pickers are maintained in an instance object,\n       allowing multiple different settings on the same page. */\n\n    function Datepicker() {\n        this._curInst = null; // The current instance in use\n        this._keyEvent = false; // If the last event was a key event\n        this._disabledInputs = []; // List of date picker inputs that have been disabled\n        this._datepickerShowing = false; // True if the popup picker is showing , false if not\n        this._inDialog = false; // True if showing within a \"dialog\", false if not\n        this._mainDivId = \"ui-datepicker-div\"; // The ID of the main datepicker division\n        this._inlineClass = \"ui-datepicker-inline\"; // The name of the inline marker class\n        this._appendClass = \"ui-datepicker-append\"; // The name of the append marker class\n        this._triggerClass = \"ui-datepicker-trigger\"; // The name of the trigger marker class\n        this._dialogClass = \"ui-datepicker-dialog\"; // The name of the dialog marker class\n        this._disableClass = \"ui-datepicker-disabled\"; // The name of the disabled covering marker class\n        this._unselectableClass = \"ui-datepicker-unselectable\"; // The name of the unselectable cell marker class\n        this._currentClass = \"ui-datepicker-current-day\"; // The name of the current day marker class\n        this._dayOverClass = \"ui-datepicker-days-cell-over\"; // The name of the day hover marker class\n        this.regional = []; // Available regional settings, indexed by language code\n        this.regional[ \"\" ] = { // Default regional settings\n            closeText: \"Done\", // Display text for close link\n            prevText: \"Prev\", // Display text for previous month link\n            nextText: \"Next\", // Display text for next month link\n            currentText: \"Today\", // Display text for current month link\n            monthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n                \"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ], // Names of months for drop-down and formatting\n            monthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\", \"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ], // For formatting\n            dayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ], // For formatting\n            dayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ], // For formatting\n            dayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ], // Column headings for days starting at Sunday\n            weekHeader: \"Wk\", // Column header for week of the year\n            dateFormat: \"mm/dd/yy\", // See format options on parseDate\n            firstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...\n            isRTL: false, // True if right-to-left language, false if left-to-right\n            showMonthAfterYear: false, // True if the year select precedes month, false for month then year\n            yearSuffix: \"\", // Additional text to append to the year in the month headers,\n            selectMonthLabel: \"Select month\", // Invisible label for month selector\n            selectYearLabel: \"Select year\" // Invisible label for year selector\n        };\n        this._defaults = { // Global defaults for all the date picker instances\n            showOn: \"focus\", // \"focus\" for popup on focus,\n            // \"button\" for trigger button, or \"both\" for either\n            showAnim: \"fadeIn\", // Name of jQuery animation for popup\n            showOptions: {}, // Options for enhanced animations\n            defaultDate: null, // Used when field is blank: actual date,\n            // +/-number for offset from today, null for today\n            appendText: \"\", // Display text following the input box, e.g. showing the format\n            buttonText: \"...\", // Text for trigger button\n            buttonImage: \"\", // URL for trigger button image\n            buttonImageOnly: false, // True if the image appears alone, false if it appears on a button\n            hideIfNoPrevNext: false, // True to hide next/previous month links\n            // if not applicable, false to just disable them\n            navigationAsDateFormat: false, // True if date formatting applied to prev/today/next links\n            gotoCurrent: false, // True if today link goes back to current selection instead\n            changeMonth: false, // True if month can be selected directly, false if only prev/next\n            changeYear: false, // True if year can be selected directly, false if only prev/next\n            yearRange: \"c-10:c+10\", // Range of years to display in drop-down,\n            // either relative to today's year (-nn:+nn), relative to currently displayed year\n            // (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)\n            showOtherMonths: false, // True to show dates in other months, false to leave blank\n            selectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable\n            showWeek: false, // True to show week of the year, false to not show it\n            calculateWeek: this.iso8601Week, // How to calculate the week of the year,\n            // takes a Date and returns the number of the week for it\n            shortYearCutoff: \"+10\", // Short year values < this are in the current century,\n            // > this are in the previous century,\n            // string value starting with \"+\" for current year + value\n            minDate: null, // The earliest selectable date, or null for no limit\n            maxDate: null, // The latest selectable date, or null for no limit\n            duration: \"fast\", // Duration of display/closure\n            beforeShowDay: null, // Function that takes a date and returns an array with\n            // [0] = true if selectable, false if not, [1] = custom CSS class name(s) or \"\",\n            // [2] = cell title (optional), e.g. $.datepicker.noWeekends\n            beforeShow: null, // Function that takes an input field and\n            // returns a set of custom settings for the date picker\n            onSelect: null, // Define a callback function when a date is selected\n            onChangeMonthYear: null, // Define a callback function when the month or year is changed\n            onClose: null, // Define a callback function when the datepicker is closed\n            onUpdateDatepicker: null, // Define a callback function when the datepicker is updated\n            numberOfMonths: 1, // Number of months to show at a time\n            showCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)\n            stepMonths: 1, // Number of months to step back/forward\n            stepBigMonths: 12, // Number of months to step back/forward for the big links\n            altField: \"\", // Selector for an alternate field to store selected dates into\n            altFormat: \"\", // The date format to use for the alternate field\n            constrainInput: true, // The input is constrained by the current date format\n            showButtonPanel: false, // True to show button panel, false to not show it\n            autoSize: false, // True to size the input for the date format, false to leave as is\n            disabled: false // The initial disabled state\n        };\n        $.extend( this._defaults, this.regional[ \"\" ] );\n        this.regional.en = $.extend( true, {}, this.regional[ \"\" ] );\n        this.regional[ \"en-US\" ] = $.extend( true, {}, this.regional.en );\n        this.dpDiv = datepicker_bindHover( $( \"<div id='\" + this._mainDivId + \"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\" ) );\n    }\n\n    $.extend( Datepicker.prototype, {\n\n        /* Class name added to elements to indicate already configured with a date picker. */\n        markerClassName: \"hasDatepicker\",\n\n        //Keep track of the maximum number of rows displayed (see #7043)\n        maxRows: 4,\n\n        // TODO rename to \"widget\" when switching to widget factory\n        _widgetDatepicker: function() {\n            return this.dpDiv;\n        },\n\n        /* Override the default settings for all instances of the date picker.\n         * @param  settings  object - the new settings to use as defaults (anonymous object)\n         * @return the manager object\n         */\n        setDefaults: function( settings ) {\n            datepicker_extendRemove( this._defaults, settings || {} );\n            return this;\n        },\n\n        /* Attach the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         * @param  settings  object - the new settings to use for this date picker instance (anonymous)\n         */\n        _attachDatepicker: function( target, settings ) {\n            var nodeName, inline, inst;\n            nodeName = target.nodeName.toLowerCase();\n            inline = ( nodeName === \"div\" || nodeName === \"span\" );\n            if ( !target.id ) {\n                this.uuid += 1;\n                target.id = \"dp\" + this.uuid;\n            }\n            inst = this._newInst( $( target ), inline );\n            inst.settings = $.extend( {}, settings || {} );\n            if ( nodeName === \"input\" ) {\n                this._connectDatepicker( target, inst );\n            } else if ( inline ) {\n                this._inlineDatepicker( target, inst );\n            }\n        },\n\n        /* Create a new instance object. */\n        _newInst: function( target, inline ) {\n            var id = target[ 0 ].id.replace( /([^A-Za-z0-9_\\-])/g, \"\\\\\\\\$1\" ); // escape jQuery meta chars\n            return { id: id, input: target, // associated target\n                selectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection\n                drawMonth: 0, drawYear: 0, // month being drawn\n                inline: inline, // is datepicker inline or not\n                dpDiv: ( !inline ? this.dpDiv : // presentation div\n                    datepicker_bindHover( $( \"<div class='\" + this._inlineClass + \" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\" ) ) ) };\n        },\n\n        /* Attach the date picker to an input field. */\n        _connectDatepicker: function( target, inst ) {\n            var input = $( target );\n            inst.append = $( [] );\n            inst.trigger = $( [] );\n            if ( input.hasClass( this.markerClassName ) ) {\n                return;\n            }\n            this._attachments( input, inst );\n            input.addClass( this.markerClassName ).on( \"keydown\", this._doKeyDown ).\n            on( \"keypress\", this._doKeyPress ).on( \"keyup\", this._doKeyUp );\n            this._autoSize( inst );\n            $.data( target, \"datepicker\", inst );\n\n            //If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)\n            if ( inst.settings.disabled ) {\n                this._disableDatepicker( target );\n            }\n        },\n\n        /* Make attachments based on settings. */\n        _attachments: function( input, inst ) {\n            var showOn, buttonText, buttonImage,\n                appendText = this._get( inst, \"appendText\" ),\n                isRTL = this._get( inst, \"isRTL\" );\n\n            if ( inst.append ) {\n                inst.append.remove();\n            }\n            if ( appendText ) {\n                inst.append = $( \"<span>\" )\n                    .addClass( this._appendClass )\n                    .text( appendText );\n                input[ isRTL ? \"before\" : \"after\" ]( inst.append );\n            }\n\n            input.off( \"focus\", this._showDatepicker );\n\n            if ( inst.trigger ) {\n                inst.trigger.remove();\n            }\n\n            showOn = this._get( inst, \"showOn\" );\n            if ( showOn === \"focus\" || showOn === \"both\" ) { // pop-up date picker when in the marked field\n                input.on( \"focus\", this._showDatepicker );\n            }\n            if ( showOn === \"button\" || showOn === \"both\" ) { // pop-up date picker when button clicked\n                buttonText = this._get( inst, \"buttonText\" );\n                buttonImage = this._get( inst, \"buttonImage\" );\n\n                if ( this._get( inst, \"buttonImageOnly\" ) ) {\n                    inst.trigger = $( \"<img>\" )\n                        .addClass( this._triggerClass )\n                        .attr( {\n                            src: buttonImage,\n                            alt: buttonText,\n                            title: buttonText\n                        } );\n                } else {\n                    inst.trigger = $( \"<button type='button'>\" )\n                        .addClass( this._triggerClass );\n                    if ( buttonImage ) {\n                        inst.trigger.html(\n                            $( \"<img>\" )\n                                .attr( {\n                                    src: buttonImage,\n                                    alt: buttonText,\n                                    title: buttonText\n                                } )\n                        );\n                    } else {\n                        inst.trigger.text( buttonText );\n                    }\n                }\n\n                input[ isRTL ? \"before\" : \"after\" ]( inst.trigger );\n                inst.trigger.on( \"click\", function() {\n                    if ( $.datepicker._datepickerShowing && $.datepicker._lastInput === input[ 0 ] ) {\n                        $.datepicker._hideDatepicker();\n                    } else if ( $.datepicker._datepickerShowing && $.datepicker._lastInput !== input[ 0 ] ) {\n                        $.datepicker._hideDatepicker();\n                        $.datepicker._showDatepicker( input[ 0 ] );\n                    } else {\n                        $.datepicker._showDatepicker( input[ 0 ] );\n                    }\n                    return false;\n                } );\n            }\n        },\n\n        /* Apply the maximum length for the date format. */\n        _autoSize: function( inst ) {\n            if ( this._get( inst, \"autoSize\" ) && !inst.inline ) {\n                var findMax, max, maxI, i,\n                    date = new Date( 2009, 12 - 1, 20 ), // Ensure double digits\n                    dateFormat = this._get( inst, \"dateFormat\" );\n\n                if ( dateFormat.match( /[DM]/ ) ) {\n                    findMax = function( names ) {\n                        max = 0;\n                        maxI = 0;\n                        for ( i = 0; i < names.length; i++ ) {\n                            if ( names[ i ].length > max ) {\n                                max = names[ i ].length;\n                                maxI = i;\n                            }\n                        }\n                        return maxI;\n                    };\n                    date.setMonth( findMax( this._get( inst, ( dateFormat.match( /MM/ ) ?\n                        \"monthNames\" : \"monthNamesShort\" ) ) ) );\n                    date.setDate( findMax( this._get( inst, ( dateFormat.match( /DD/ ) ?\n                        \"dayNames\" : \"dayNamesShort\" ) ) ) + 20 - date.getDay() );\n                }\n                inst.input.attr( \"size\", this._formatDate( inst, date ).length );\n            }\n        },\n\n        /* Attach an inline date picker to a div. */\n        _inlineDatepicker: function( target, inst ) {\n            var divSpan = $( target );\n            if ( divSpan.hasClass( this.markerClassName ) ) {\n                return;\n            }\n            divSpan.addClass( this.markerClassName ).append( inst.dpDiv );\n            $.data( target, \"datepicker\", inst );\n            this._setDate( inst, this._getDefaultDate( inst ), true );\n            this._updateDatepicker( inst );\n            this._updateAlternate( inst );\n\n            //If disabled option is true, disable the datepicker before showing it (see ticket #5665)\n            if ( inst.settings.disabled ) {\n                this._disableDatepicker( target );\n            }\n\n            // Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements\n            // http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height\n            inst.dpDiv.css( \"display\", \"block\" );\n        },\n\n        /* Pop-up the date picker in a \"dialog\" box.\n         * @param  input element - ignored\n         * @param  date\tstring or Date - the initial date to display\n         * @param  onSelect  function - the function to call when a date is selected\n         * @param  settings  object - update the dialog date picker instance's settings (anonymous object)\n         * @param  pos int[2] - coordinates for the dialog's position within the screen or\n         *\t\t\t\t\tevent - with x/y coordinates or\n         *\t\t\t\t\tleave empty for default (screen centre)\n         * @return the manager object\n         */\n        _dialogDatepicker: function( input, date, onSelect, settings, pos ) {\n            var id, browserWidth, browserHeight, scrollX, scrollY,\n                inst = this._dialogInst; // internal instance\n\n            if ( !inst ) {\n                this.uuid += 1;\n                id = \"dp\" + this.uuid;\n                this._dialogInput = $( \"<input type='text' id='\" + id +\n                    \"' style='position: absolute; top: -100px; width: 0px;'/>\" );\n                this._dialogInput.on( \"keydown\", this._doKeyDown );\n                $( \"body\" ).append( this._dialogInput );\n                inst = this._dialogInst = this._newInst( this._dialogInput, false );\n                inst.settings = {};\n                $.data( this._dialogInput[ 0 ], \"datepicker\", inst );\n            }\n            datepicker_extendRemove( inst.settings, settings || {} );\n            date = ( date && date.constructor === Date ? this._formatDate( inst, date ) : date );\n            this._dialogInput.val( date );\n\n            this._pos = ( pos ? ( pos.length ? pos : [ pos.pageX, pos.pageY ] ) : null );\n            if ( !this._pos ) {\n                browserWidth = document.documentElement.clientWidth;\n                browserHeight = document.documentElement.clientHeight;\n                scrollX = document.documentElement.scrollLeft || document.body.scrollLeft;\n                scrollY = document.documentElement.scrollTop || document.body.scrollTop;\n                this._pos = // should use actual width/height below\n                    [ ( browserWidth / 2 ) - 100 + scrollX, ( browserHeight / 2 ) - 150 + scrollY ];\n            }\n\n            // Move input on screen for focus, but hidden behind dialog\n            this._dialogInput.css( \"left\", ( this._pos[ 0 ] + 20 ) + \"px\" ).css( \"top\", this._pos[ 1 ] + \"px\" );\n            inst.settings.onSelect = onSelect;\n            this._inDialog = true;\n            this.dpDiv.addClass( this._dialogClass );\n            this._showDatepicker( this._dialogInput[ 0 ] );\n            if ( $.blockUI ) {\n                $.blockUI( this.dpDiv );\n            }\n            $.data( this._dialogInput[ 0 ], \"datepicker\", inst );\n            return this;\n        },\n\n        /* Detach a datepicker from its control.\n         * @param  target\telement - the target input field or division or span\n         */\n        _destroyDatepicker: function( target ) {\n            var nodeName,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            $.removeData( target, \"datepicker\" );\n            if ( nodeName === \"input\" ) {\n                inst.append.remove();\n                inst.trigger.remove();\n                $target.removeClass( this.markerClassName ).\n                off( \"focus\", this._showDatepicker ).\n                off( \"keydown\", this._doKeyDown ).\n                off( \"keypress\", this._doKeyPress ).\n                off( \"keyup\", this._doKeyUp );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                $target.removeClass( this.markerClassName ).empty();\n            }\n\n            if ( datepicker_instActive === inst ) {\n                datepicker_instActive = null;\n                this._curInst = null;\n            }\n        },\n\n        /* Enable the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         */\n        _enableDatepicker: function( target ) {\n            var nodeName, inline,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            if ( nodeName === \"input\" ) {\n                target.disabled = false;\n                inst.trigger.filter( \"button\" ).\n                each( function() {\n                    this.disabled = false;\n                } ).end().\n                filter( \"img\" ).css( { opacity: \"1.0\", cursor: \"\" } );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                inline = $target.children( \".\" + this._inlineClass );\n                inline.children().removeClass( \"ui-state-disabled\" );\n                inline.find( \"select.ui-datepicker-month, select.ui-datepicker-year\" ).\n                prop( \"disabled\", false );\n            }\n            this._disabledInputs = $.map( this._disabledInputs,\n\n                // Delete entry\n                function( value ) {\n                    return ( value === target ? null : value );\n                } );\n        },\n\n        /* Disable the date picker to a jQuery selection.\n         * @param  target\telement - the target input field or division or span\n         */\n        _disableDatepicker: function( target ) {\n            var nodeName, inline,\n                $target = $( target ),\n                inst = $.data( target, \"datepicker\" );\n\n            if ( !$target.hasClass( this.markerClassName ) ) {\n                return;\n            }\n\n            nodeName = target.nodeName.toLowerCase();\n            if ( nodeName === \"input\" ) {\n                target.disabled = true;\n                inst.trigger.filter( \"button\" ).\n                each( function() {\n                    this.disabled = true;\n                } ).end().\n                filter( \"img\" ).css( { opacity: \"0.5\", cursor: \"default\" } );\n            } else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n                inline = $target.children( \".\" + this._inlineClass );\n                inline.children().addClass( \"ui-state-disabled\" );\n                inline.find( \"select.ui-datepicker-month, select.ui-datepicker-year\" ).\n                prop( \"disabled\", true );\n            }\n            this._disabledInputs = $.map( this._disabledInputs,\n\n                // Delete entry\n                function( value ) {\n                    return ( value === target ? null : value );\n                } );\n            this._disabledInputs[ this._disabledInputs.length ] = target;\n        },\n\n        /* Is the first field in a jQuery collection disabled as a datepicker?\n         * @param  target\telement - the target input field or division or span\n         * @return boolean - true if disabled, false if enabled\n         */\n        _isDisabledDatepicker: function( target ) {\n            if ( !target ) {\n                return false;\n            }\n            for ( var i = 0; i < this._disabledInputs.length; i++ ) {\n                if ( this._disabledInputs[ i ] === target ) {\n                    return true;\n                }\n            }\n            return false;\n        },\n\n        /* Retrieve the instance data for the target control.\n         * @param  target  element - the target input field or division or span\n         * @return  object - the associated instance data\n         * @throws  error if a jQuery problem getting data\n         */\n        _getInst: function( target ) {\n            try {\n                return $.data( target, \"datepicker\" );\n            } catch ( err ) {\n                throw \"Missing instance data for this datepicker\";\n            }\n        },\n\n        /* Update or retrieve the settings for a date picker attached to an input field or division.\n         * @param  target  element - the target input field or division or span\n         * @param  name\tobject - the new settings to update or\n         *\t\t\t\tstring - the name of the setting to change or retrieve,\n         *\t\t\t\twhen retrieving also \"all\" for all instance settings or\n         *\t\t\t\t\"defaults\" for all global defaults\n         * @param  value   any - the new value for the setting\n         *\t\t\t\t(omit if above is an object or to retrieve a value)\n         */\n        _optionDatepicker: function( target, name, value ) {\n            var settings, date, minDate, maxDate,\n                inst = this._getInst( target );\n\n            if ( arguments.length === 2 && typeof name === \"string\" ) {\n                return ( name === \"defaults\" ? $.extend( {}, $.datepicker._defaults ) :\n                    ( inst ? ( name === \"all\" ? $.extend( {}, inst.settings ) :\n                        this._get( inst, name ) ) : null ) );\n            }\n\n            settings = name || {};\n            if ( typeof name === \"string\" ) {\n                settings = {};\n                settings[ name ] = value;\n            }\n\n            if ( inst ) {\n                if ( this._curInst === inst ) {\n                    this._hideDatepicker();\n                }\n\n                date = this._getDateDatepicker( target, true );\n                minDate = this._getMinMaxDate( inst, \"min\" );\n                maxDate = this._getMinMaxDate( inst, \"max\" );\n                datepicker_extendRemove( inst.settings, settings );\n\n                // reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided\n                if ( minDate !== null && settings.dateFormat !== undefined && settings.minDate === undefined ) {\n                    inst.settings.minDate = this._formatDate( inst, minDate );\n                }\n                if ( maxDate !== null && settings.dateFormat !== undefined && settings.maxDate === undefined ) {\n                    inst.settings.maxDate = this._formatDate( inst, maxDate );\n                }\n                if ( \"disabled\" in settings ) {\n                    if ( settings.disabled ) {\n                        this._disableDatepicker( target );\n                    } else {\n                        this._enableDatepicker( target );\n                    }\n                }\n                this._attachments( $( target ), inst );\n                this._autoSize( inst );\n                this._setDate( inst, date );\n                this._updateAlternate( inst );\n                this._updateDatepicker( inst );\n            }\n        },\n\n        // Change method deprecated\n        _changeDatepicker: function( target, name, value ) {\n            this._optionDatepicker( target, name, value );\n        },\n\n        /* Redraw the date picker attached to an input field or division.\n         * @param  target  element - the target input field or division or span\n         */\n        _refreshDatepicker: function( target ) {\n            var inst = this._getInst( target );\n            if ( inst ) {\n                this._updateDatepicker( inst );\n            }\n        },\n\n        /* Set the dates for a jQuery selection.\n         * @param  target element - the target input field or division or span\n         * @param  date\tDate - the new date\n         */\n        _setDateDatepicker: function( target, date ) {\n            var inst = this._getInst( target );\n            if ( inst ) {\n                this._setDate( inst, date );\n                this._updateDatepicker( inst );\n                this._updateAlternate( inst );\n            }\n        },\n\n        /* Get the date(s) for the first entry in a jQuery selection.\n         * @param  target element - the target input field or division or span\n         * @param  noDefault boolean - true if no default date is to be used\n         * @return Date - the current date\n         */\n        _getDateDatepicker: function( target, noDefault ) {\n            var inst = this._getInst( target );\n            if ( inst && !inst.inline ) {\n                this._setDateFromField( inst, noDefault );\n            }\n            return ( inst ? this._getDate( inst ) : null );\n        },\n\n        /* Handle keystrokes. */\n        _doKeyDown: function( event ) {\n            var onSelect, dateStr, sel,\n                inst = $.datepicker._getInst( event.target ),\n                handled = true,\n                isRTL = inst.dpDiv.is( \".ui-datepicker-rtl\" );\n\n            inst._keyEvent = true;\n            if ( $.datepicker._datepickerShowing ) {\n                switch ( event.keyCode ) {\n                    case 9: $.datepicker._hideDatepicker();\n                        handled = false;\n                        break; // hide on tab out\n                    case 13: sel = $( \"td.\" + $.datepicker._dayOverClass + \":not(.\" +\n                        $.datepicker._currentClass + \")\", inst.dpDiv );\n                        if ( sel[ 0 ] ) {\n                            $.datepicker._selectDay( event.target, inst.selectedMonth, inst.selectedYear, sel[ 0 ] );\n                        }\n\n                        onSelect = $.datepicker._get( inst, \"onSelect\" );\n                        if ( onSelect ) {\n                            dateStr = $.datepicker._formatDate( inst );\n\n                            // Trigger custom callback\n                            onSelect.apply( ( inst.input ? inst.input[ 0 ] : null ), [ dateStr, inst ] );\n                        } else {\n                            $.datepicker._hideDatepicker();\n                        }\n\n                        return false; // don't submit the form\n                    case 27: $.datepicker._hideDatepicker();\n                        break; // hide on escape\n                    case 33: $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                        -$.datepicker._get( inst, \"stepBigMonths\" ) :\n                        -$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        break; // previous month/year on page up/+ ctrl\n                    case 34: $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                        +$.datepicker._get( inst, \"stepBigMonths\" ) :\n                        +$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        break; // next month/year on page down/+ ctrl\n                    case 35: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._clearDate( event.target );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // clear on ctrl or command +end\n                    case 36: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._gotoToday( event.target );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // current on ctrl or command +home\n                    case 37: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, ( isRTL ? +1 : -1 ), \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n\n                        // -1 day on ctrl or command +left\n                        if ( event.originalEvent.altKey ) {\n                            $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                                -$.datepicker._get( inst, \"stepBigMonths\" ) :\n                                -$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        }\n\n                        // next month/year on alt +left on Mac\n                        break;\n                    case 38: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, -7, \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // -1 week on ctrl or command +up\n                    case 39: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, ( isRTL ? -1 : +1 ), \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n\n                        // +1 day on ctrl or command +right\n                        if ( event.originalEvent.altKey ) {\n                            $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n                                +$.datepicker._get( inst, \"stepBigMonths\" ) :\n                                +$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n                        }\n\n                        // next month/year on alt +right\n                        break;\n                    case 40: if ( event.ctrlKey || event.metaKey ) {\n                        $.datepicker._adjustDate( event.target, +7, \"D\" );\n                    }\n                        handled = event.ctrlKey || event.metaKey;\n                        break; // +1 week on ctrl or command +down\n                    default: handled = false;\n                }\n            } else if ( event.keyCode === 36 && event.ctrlKey ) { // display the date picker on ctrl+home\n                $.datepicker._showDatepicker( this );\n            } else {\n                handled = false;\n            }\n\n            if ( handled ) {\n                event.preventDefault();\n                event.stopPropagation();\n            }\n        },\n\n        /* Filter entered characters - based on date format. */\n        _doKeyPress: function( event ) {\n            var chars, chr,\n                inst = $.datepicker._getInst( event.target );\n\n            if ( $.datepicker._get( inst, \"constrainInput\" ) ) {\n                chars = $.datepicker._possibleChars( $.datepicker._get( inst, \"dateFormat\" ) );\n                chr = String.fromCharCode( event.charCode == null ? event.keyCode : event.charCode );\n                return event.ctrlKey || event.metaKey || ( chr < \" \" || !chars || chars.indexOf( chr ) > -1 );\n            }\n        },\n\n        /* Synchronise manual entry and field/alternate field. */\n        _doKeyUp: function( event ) {\n            var date,\n                inst = $.datepicker._getInst( event.target );\n\n            if ( inst.input.val() !== inst.lastVal ) {\n                try {\n                    date = $.datepicker.parseDate( $.datepicker._get( inst, \"dateFormat\" ),\n                        ( inst.input ? inst.input.val() : null ),\n                        $.datepicker._getFormatConfig( inst ) );\n\n                    if ( date ) { // only if valid\n                        $.datepicker._setDateFromField( inst );\n                        $.datepicker._updateAlternate( inst );\n                        $.datepicker._updateDatepicker( inst );\n                    }\n                } catch ( err ) {\n                }\n            }\n            return true;\n        },\n\n        /* Pop-up the date picker for a given input field.\n         * If false returned from beforeShow event handler do not show.\n         * @param  input  element - the input field attached to the date picker or\n         *\t\t\t\t\tevent - if triggered by focus\n         */\n        _showDatepicker: function( input ) {\n            input = input.target || input;\n            if ( input.nodeName.toLowerCase() !== \"input\" ) { // find from button/image trigger\n                input = $( \"input\", input.parentNode )[ 0 ];\n            }\n\n            if ( $.datepicker._isDisabledDatepicker( input ) || $.datepicker._lastInput === input ) { // already here\n                return;\n            }\n\n            var inst, beforeShow, beforeShowSettings, isFixed,\n                offset, showAnim, duration;\n\n            inst = $.datepicker._getInst( input );\n            if ( $.datepicker._curInst && $.datepicker._curInst !== inst ) {\n                $.datepicker._curInst.dpDiv.stop( true, true );\n                if ( inst && $.datepicker._datepickerShowing ) {\n                    $.datepicker._hideDatepicker( $.datepicker._curInst.input[ 0 ] );\n                }\n            }\n\n            beforeShow = $.datepicker._get( inst, \"beforeShow\" );\n            beforeShowSettings = beforeShow ? beforeShow.apply( input, [ input, inst ] ) : {};\n            if ( beforeShowSettings === false ) {\n                return;\n            }\n            datepicker_extendRemove( inst.settings, beforeShowSettings );\n\n            inst.lastVal = null;\n            $.datepicker._lastInput = input;\n            $.datepicker._setDateFromField( inst );\n\n            if ( $.datepicker._inDialog ) { // hide cursor\n                input.value = \"\";\n            }\n            if ( !$.datepicker._pos ) { // position below input\n                $.datepicker._pos = $.datepicker._findPos( input );\n                $.datepicker._pos[ 1 ] += input.offsetHeight; // add the height\n            }\n\n            isFixed = false;\n            $( input ).parents().each( function() {\n                isFixed |= $( this ).css( \"position\" ) === \"fixed\";\n                return !isFixed;\n            } );\n\n            offset = { left: $.datepicker._pos[ 0 ], top: $.datepicker._pos[ 1 ] };\n            $.datepicker._pos = null;\n\n            //to avoid flashes on Firefox\n            inst.dpDiv.empty();\n\n            // determine sizing offscreen\n            inst.dpDiv.css( { position: \"absolute\", display: \"block\", top: \"-1000px\" } );\n            $.datepicker._updateDatepicker( inst );\n\n            // fix width for dynamic number of date pickers\n            // and adjust position before showing\n            offset = $.datepicker._checkOffset( inst, offset, isFixed );\n            inst.dpDiv.css( { position: ( $.datepicker._inDialog && $.blockUI ?\n                    \"static\" : ( isFixed ? \"fixed\" : \"absolute\" ) ), display: \"none\",\n                left: offset.left + \"px\", top: offset.top + \"px\" } );\n\n            if ( !inst.inline ) {\n                showAnim = $.datepicker._get( inst, \"showAnim\" );\n                duration = $.datepicker._get( inst, \"duration\" );\n                inst.dpDiv.css( \"z-index\", datepicker_getZindex( $( input ) ) + 1 );\n                $.datepicker._datepickerShowing = true;\n\n                if ( $.effects && $.effects.effect[ showAnim ] ) {\n                    inst.dpDiv.show( showAnim, $.datepicker._get( inst, \"showOptions\" ), duration );\n                } else {\n                    inst.dpDiv[ showAnim || \"show\" ]( showAnim ? duration : null );\n                }\n\n                if ( $.datepicker._shouldFocusInput( inst ) ) {\n                    inst.input.trigger( \"focus\" );\n                }\n\n                $.datepicker._curInst = inst;\n            }\n        },\n\n        /* Generate the date picker content. */\n        _updateDatepicker: function( inst ) {\n            this.maxRows = 4; //Reset the max number of rows being displayed (see #7043)\n            datepicker_instActive = inst; // for delegate hover events\n            inst.dpDiv.empty().append( this._generateHTML( inst ) );\n            this._attachHandlers( inst );\n\n            var origyearshtml,\n                numMonths = this._getNumberOfMonths( inst ),\n                cols = numMonths[ 1 ],\n                width = 17,\n                activeCell = inst.dpDiv.find( \".\" + this._dayOverClass + \" a\" ),\n                onUpdateDatepicker = $.datepicker._get( inst, \"onUpdateDatepicker\" );\n\n            if ( activeCell.length > 0 ) {\n                datepicker_handleMouseover.apply( activeCell.get( 0 ) );\n            }\n\n            inst.dpDiv.removeClass( \"ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4\" ).width( \"\" );\n            if ( cols > 1 ) {\n                inst.dpDiv.addClass( \"ui-datepicker-multi-\" + cols ).css( \"width\", ( width * cols ) + \"em\" );\n            }\n            inst.dpDiv[ ( numMonths[ 0 ] !== 1 || numMonths[ 1 ] !== 1 ? \"add\" : \"remove\" ) +\n            \"Class\" ]( \"ui-datepicker-multi\" );\n            inst.dpDiv[ ( this._get( inst, \"isRTL\" ) ? \"add\" : \"remove\" ) +\n            \"Class\" ]( \"ui-datepicker-rtl\" );\n\n            if ( inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput( inst ) ) {\n                inst.input.trigger( \"focus\" );\n            }\n\n            // Deffered render of the years select (to avoid flashes on Firefox)\n            if ( inst.yearshtml ) {\n                origyearshtml = inst.yearshtml;\n                setTimeout( function() {\n\n                    //assure that inst.yearshtml didn't change.\n                    if ( origyearshtml === inst.yearshtml && inst.yearshtml ) {\n                        inst.dpDiv.find( \"select.ui-datepicker-year\" ).first().replaceWith( inst.yearshtml );\n                    }\n                    origyearshtml = inst.yearshtml = null;\n                }, 0 );\n            }\n\n            if ( onUpdateDatepicker ) {\n                onUpdateDatepicker.apply( ( inst.input ? inst.input[ 0 ] : null ), [ inst ] );\n            }\n        },\n\n        // #6694 - don't focus the input if it's already focused\n        // this breaks the change event in IE\n        // Support: IE and jQuery <1.9\n        _shouldFocusInput: function( inst ) {\n            return inst.input && inst.input.is( \":visible\" ) && !inst.input.is( \":disabled\" ) && !inst.input.is( \":focus\" );\n        },\n\n        /* Check positioning to remain on screen. */\n        _checkOffset: function( inst, offset, isFixed ) {\n            var dpWidth = inst.dpDiv.outerWidth(),\n                dpHeight = inst.dpDiv.outerHeight(),\n                inputWidth = inst.input ? inst.input.outerWidth() : 0,\n                inputHeight = inst.input ? inst.input.outerHeight() : 0,\n                viewWidth = document.documentElement.clientWidth + ( isFixed ? 0 : $( document ).scrollLeft() ),\n                viewHeight = document.documentElement.clientHeight + ( isFixed ? 0 : $( document ).scrollTop() );\n\n            offset.left -= ( this._get( inst, \"isRTL\" ) ? ( dpWidth - inputWidth ) : 0 );\n            offset.left -= ( isFixed && offset.left === inst.input.offset().left ) ? $( document ).scrollLeft() : 0;\n            offset.top -= ( isFixed && offset.top === ( inst.input.offset().top + inputHeight ) ) ? $( document ).scrollTop() : 0;\n\n            // Now check if datepicker is showing outside window viewport - move to a better place if so.\n            offset.left -= Math.min( offset.left, ( offset.left + dpWidth > viewWidth && viewWidth > dpWidth ) ?\n                Math.abs( offset.left + dpWidth - viewWidth ) : 0 );\n            offset.top -= Math.min( offset.top, ( offset.top + dpHeight > viewHeight && viewHeight > dpHeight ) ?\n                Math.abs( dpHeight + inputHeight ) : 0 );\n\n            return offset;\n        },\n\n        /* Find an object's position on the screen. */\n        _findPos: function( obj ) {\n            var position,\n                inst = this._getInst( obj ),\n                isRTL = this._get( inst, \"isRTL\" );\n\n            while ( obj && ( obj.type === \"hidden\" || obj.nodeType !== 1 || $.expr.pseudos.hidden( obj ) ) ) {\n                obj = obj[ isRTL ? \"previousSibling\" : \"nextSibling\" ];\n            }\n\n            position = $( obj ).offset();\n            return [ position.left, position.top ];\n        },\n\n        /* Hide the date picker from view.\n         * @param  input  element - the input field attached to the date picker\n         */\n        _hideDatepicker: function( input ) {\n            var showAnim, duration, postProcess, onClose,\n                inst = this._curInst;\n\n            if ( !inst || ( input && inst !== $.data( input, \"datepicker\" ) ) ) {\n                return;\n            }\n\n            if ( this._datepickerShowing ) {\n                showAnim = this._get( inst, \"showAnim\" );\n                duration = this._get( inst, \"duration\" );\n                postProcess = function() {\n                    $.datepicker._tidyDialog( inst );\n                };\n\n                // DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed\n                if ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) ) {\n                    inst.dpDiv.hide( showAnim, $.datepicker._get( inst, \"showOptions\" ), duration, postProcess );\n                } else {\n                    inst.dpDiv[ ( showAnim === \"slideDown\" ? \"slideUp\" :\n                        ( showAnim === \"fadeIn\" ? \"fadeOut\" : \"hide\" ) ) ]( ( showAnim ? duration : null ), postProcess );\n                }\n\n                if ( !showAnim ) {\n                    postProcess();\n                }\n                this._datepickerShowing = false;\n\n                onClose = this._get( inst, \"onClose\" );\n                if ( onClose ) {\n                    onClose.apply( ( inst.input ? inst.input[ 0 ] : null ), [ ( inst.input ? inst.input.val() : \"\" ), inst ] );\n                }\n\n                this._lastInput = null;\n                if ( this._inDialog ) {\n                    this._dialogInput.css( { position: \"absolute\", left: \"0\", top: \"-100px\" } );\n                    if ( $.blockUI ) {\n                        $.unblockUI();\n                        $( \"body\" ).append( this.dpDiv );\n                    }\n                }\n                this._inDialog = false;\n            }\n        },\n\n        /* Tidy up after a dialog display. */\n        _tidyDialog: function( inst ) {\n            inst.dpDiv.removeClass( this._dialogClass ).off( \".ui-datepicker-calendar\" );\n        },\n\n        /* Close date picker if clicked elsewhere. */\n        _checkExternalClick: function( event ) {\n            if ( !$.datepicker._curInst ) {\n                return;\n            }\n\n            var $target = $( event.target ),\n                inst = $.datepicker._getInst( $target[ 0 ] );\n\n            if ( ( ( $target[ 0 ].id !== $.datepicker._mainDivId &&\n                    $target.parents( \"#\" + $.datepicker._mainDivId ).length === 0 &&\n                    !$target.hasClass( $.datepicker.markerClassName ) &&\n                    !$target.closest( \".\" + $.datepicker._triggerClass ).length &&\n                    $.datepicker._datepickerShowing && !( $.datepicker._inDialog && $.blockUI ) ) ) ||\n                ( $target.hasClass( $.datepicker.markerClassName ) && $.datepicker._curInst !== inst ) ) {\n                $.datepicker._hideDatepicker();\n            }\n        },\n\n        /* Adjust one of the date sub-fields. */\n        _adjustDate: function( id, offset, period ) {\n            var target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            if ( this._isDisabledDatepicker( target[ 0 ] ) ) {\n                return;\n            }\n            this._adjustInstDate( inst, offset, period );\n            this._updateDatepicker( inst );\n        },\n\n        /* Action for current link. */\n        _gotoToday: function( id ) {\n            var date,\n                target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            if ( this._get( inst, \"gotoCurrent\" ) && inst.currentDay ) {\n                inst.selectedDay = inst.currentDay;\n                inst.drawMonth = inst.selectedMonth = inst.currentMonth;\n                inst.drawYear = inst.selectedYear = inst.currentYear;\n            } else {\n                date = new Date();\n                inst.selectedDay = date.getDate();\n                inst.drawMonth = inst.selectedMonth = date.getMonth();\n                inst.drawYear = inst.selectedYear = date.getFullYear();\n            }\n            this._notifyChange( inst );\n            this._adjustDate( target );\n        },\n\n        /* Action for selecting a new month/year. */\n        _selectMonthYear: function( id, select, period ) {\n            var target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            inst[ \"selected\" + ( period === \"M\" ? \"Month\" : \"Year\" ) ] =\n                inst[ \"draw\" + ( period === \"M\" ? \"Month\" : \"Year\" ) ] =\n                    parseInt( select.options[ select.selectedIndex ].value, 10 );\n\n            this._notifyChange( inst );\n            this._adjustDate( target );\n        },\n\n        /* Action for selecting a day. */\n        _selectDay: function( id, month, year, td ) {\n            var inst,\n                target = $( id );\n\n            if ( $( td ).hasClass( this._unselectableClass ) || this._isDisabledDatepicker( target[ 0 ] ) ) {\n                return;\n            }\n\n            inst = this._getInst( target[ 0 ] );\n            inst.selectedDay = inst.currentDay = parseInt( $( \"a\", td ).attr( \"data-date\" ) );\n            inst.selectedMonth = inst.currentMonth = month;\n            inst.selectedYear = inst.currentYear = year;\n            this._selectDate( id, this._formatDate( inst,\n                inst.currentDay, inst.currentMonth, inst.currentYear ) );\n        },\n\n        /* Erase the input field and hide the date picker. */\n        _clearDate: function( id ) {\n            var target = $( id );\n            this._selectDate( target, \"\" );\n        },\n\n        /* Update the input field with the selected date. */\n        _selectDate: function( id, dateStr ) {\n            var onSelect,\n                target = $( id ),\n                inst = this._getInst( target[ 0 ] );\n\n            dateStr = ( dateStr != null ? dateStr : this._formatDate( inst ) );\n            if ( inst.input ) {\n                inst.input.val( dateStr );\n            }\n            this._updateAlternate( inst );\n\n            onSelect = this._get( inst, \"onSelect\" );\n            if ( onSelect ) {\n                onSelect.apply( ( inst.input ? inst.input[ 0 ] : null ), [ dateStr, inst ] );  // trigger custom callback\n            } else if ( inst.input ) {\n                inst.input.trigger( \"change\" ); // fire the change event\n            }\n\n            if ( inst.inline ) {\n                this._updateDatepicker( inst );\n            } else {\n                this._hideDatepicker();\n                this._lastInput = inst.input[ 0 ];\n                if ( typeof( inst.input[ 0 ] ) !== \"object\" ) {\n                    inst.input.trigger( \"focus\" ); // restore focus\n                }\n                this._lastInput = null;\n            }\n        },\n\n        /* Update any alternate field to synchronise with the main field. */\n        _updateAlternate: function( inst ) {\n            var altFormat, date, dateStr,\n                altField = this._get( inst, \"altField\" );\n\n            if ( altField ) { // update alternate field too\n                altFormat = this._get( inst, \"altFormat\" ) || this._get( inst, \"dateFormat\" );\n                date = this._getDate( inst );\n                dateStr = this.formatDate( altFormat, date, this._getFormatConfig( inst ) );\n                $( document ).find( altField ).val( dateStr );\n            }\n        },\n\n        /* Set as beforeShowDay function to prevent selection of weekends.\n         * @param  date  Date - the date to customise\n         * @return [boolean, string] - is this date selectable?, what is its CSS class?\n         */\n        noWeekends: function( date ) {\n            var day = date.getDay();\n            return [ ( day > 0 && day < 6 ), \"\" ];\n        },\n\n        /* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.\n         * @param  date  Date - the date to get the week for\n         * @return  number - the number of the week within the year that contains this date\n         */\n        iso8601Week: function( date ) {\n            var time,\n                checkDate = new Date( date.getTime() );\n\n            // Find Thursday of this week starting on Monday\n            checkDate.setDate( checkDate.getDate() + 4 - ( checkDate.getDay() || 7 ) );\n\n            time = checkDate.getTime();\n            checkDate.setMonth( 0 ); // Compare with Jan 1\n            checkDate.setDate( 1 );\n            return Math.floor( Math.round( ( time - checkDate ) / 86400000 ) / 7 ) + 1;\n        },\n\n        /* Parse a string value into a date object.\n         * See formatDate below for the possible formats.\n         *\n         * @param  format string - the expected format of the date\n         * @param  value string - the date in the above format\n         * @param  settings Object - attributes include:\n         *\t\t\t\t\tshortYearCutoff  number - the cutoff year for determining the century (optional)\n         *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n         *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n         *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n         *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n         * @return  Date - the extracted date value or null if value is blank\n         */\n        parseDate: function( format, value, settings ) {\n            if ( format == null || value == null ) {\n                throw \"Invalid arguments\";\n            }\n\n            value = ( typeof value === \"object\" ? value.toString() : value + \"\" );\n            if ( value === \"\" ) {\n                return null;\n            }\n\n            var iFormat, dim, extra,\n                iValue = 0,\n                shortYearCutoffTemp = ( settings ? settings.shortYearCutoff : null ) || this._defaults.shortYearCutoff,\n                shortYearCutoff = ( typeof shortYearCutoffTemp !== \"string\" ? shortYearCutoffTemp :\n                    new Date().getFullYear() % 100 + parseInt( shortYearCutoffTemp, 10 ) ),\n                dayNamesShort = ( settings ? settings.dayNamesShort : null ) || this._defaults.dayNamesShort,\n                dayNames = ( settings ? settings.dayNames : null ) || this._defaults.dayNames,\n                monthNamesShort = ( settings ? settings.monthNamesShort : null ) || this._defaults.monthNamesShort,\n                monthNames = ( settings ? settings.monthNames : null ) || this._defaults.monthNames,\n                year = -1,\n                month = -1,\n                day = -1,\n                doy = -1,\n                literal = false,\n                date,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                },\n\n                // Extract a number from the string value\n                getNumber = function( match ) {\n                    var isDoubled = lookAhead( match ),\n                        size = ( match === \"@\" ? 14 : ( match === \"!\" ? 20 :\n                            ( match === \"y\" && isDoubled ? 4 : ( match === \"o\" ? 3 : 2 ) ) ) ),\n                        minSize = ( match === \"y\" ? size : 1 ),\n                        digits = new RegExp( \"^\\\\d{\" + minSize + \",\" + size + \"}\" ),\n                        num = value.substring( iValue ).match( digits );\n                    if ( !num ) {\n                        throw \"Missing number at position \" + iValue;\n                    }\n                    iValue += num[ 0 ].length;\n                    return parseInt( num[ 0 ], 10 );\n                },\n\n                // Extract a name from the string value and convert to an index\n                getName = function( match, shortNames, longNames ) {\n                    var index = -1,\n                        names = $.map( lookAhead( match ) ? longNames : shortNames, function( v, k ) {\n                            return [ [ k, v ] ];\n                        } ).sort( function( a, b ) {\n                            return -( a[ 1 ].length - b[ 1 ].length );\n                        } );\n\n                    $.each( names, function( i, pair ) {\n                        var name = pair[ 1 ];\n                        if ( value.substr( iValue, name.length ).toLowerCase() === name.toLowerCase() ) {\n                            index = pair[ 0 ];\n                            iValue += name.length;\n                            return false;\n                        }\n                    } );\n                    if ( index !== -1 ) {\n                        return index + 1;\n                    } else {\n                        throw \"Unknown name at position \" + iValue;\n                    }\n                },\n\n                // Confirm that a literal character matches the string value\n                checkLiteral = function() {\n                    if ( value.charAt( iValue ) !== format.charAt( iFormat ) ) {\n                        throw \"Unexpected literal at position \" + iValue;\n                    }\n                    iValue++;\n                };\n\n            for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                if ( literal ) {\n                    if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                        literal = false;\n                    } else {\n                        checkLiteral();\n                    }\n                } else {\n                    switch ( format.charAt( iFormat ) ) {\n                        case \"d\":\n                            day = getNumber( \"d\" );\n                            break;\n                        case \"D\":\n                            getName( \"D\", dayNamesShort, dayNames );\n                            break;\n                        case \"o\":\n                            doy = getNumber( \"o\" );\n                            break;\n                        case \"m\":\n                            month = getNumber( \"m\" );\n                            break;\n                        case \"M\":\n                            month = getName( \"M\", monthNamesShort, monthNames );\n                            break;\n                        case \"y\":\n                            year = getNumber( \"y\" );\n                            break;\n                        case \"@\":\n                            date = new Date( getNumber( \"@\" ) );\n                            year = date.getFullYear();\n                            month = date.getMonth() + 1;\n                            day = date.getDate();\n                            break;\n                        case \"!\":\n                            date = new Date( ( getNumber( \"!\" ) - this._ticksTo1970 ) / 10000 );\n                            year = date.getFullYear();\n                            month = date.getMonth() + 1;\n                            day = date.getDate();\n                            break;\n                        case \"'\":\n                            if ( lookAhead( \"'\" ) ) {\n                                checkLiteral();\n                            } else {\n                                literal = true;\n                            }\n                            break;\n                        default:\n                            checkLiteral();\n                    }\n                }\n            }\n\n            if ( iValue < value.length ) {\n                extra = value.substr( iValue );\n                if ( !/^\\s+/.test( extra ) ) {\n                    throw \"Extra/unparsed characters found in date: \" + extra;\n                }\n            }\n\n            if ( year === -1 ) {\n                year = new Date().getFullYear();\n            } else if ( year < 100 ) {\n                year += new Date().getFullYear() - new Date().getFullYear() % 100 +\n                    ( year <= shortYearCutoff ? 0 : -100 );\n            }\n\n            if ( doy > -1 ) {\n                month = 1;\n                day = doy;\n                do {\n                    dim = this._getDaysInMonth( year, month - 1 );\n                    if ( day <= dim ) {\n                        break;\n                    }\n                    month++;\n                    day -= dim;\n                } while ( true );\n            }\n\n            date = this._daylightSavingAdjust( new Date( year, month - 1, day ) );\n            if ( date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day ) {\n                throw \"Invalid date\"; // E.g. 31/02/00\n            }\n            return date;\n        },\n\n        /* Standard date formats. */\n        ATOM: \"yy-mm-dd\", // RFC 3339 (ISO 8601)\n        COOKIE: \"D, dd M yy\",\n        ISO_8601: \"yy-mm-dd\",\n        RFC_822: \"D, d M y\",\n        RFC_850: \"DD, dd-M-y\",\n        RFC_1036: \"D, d M y\",\n        RFC_1123: \"D, d M yy\",\n        RFC_2822: \"D, d M yy\",\n        RSS: \"D, d M y\", // RFC 822\n        TICKS: \"!\",\n        TIMESTAMP: \"@\",\n        W3C: \"yy-mm-dd\", // ISO 8601\n\n        _ticksTo1970: ( ( ( 1970 - 1 ) * 365 + Math.floor( 1970 / 4 ) - Math.floor( 1970 / 100 ) +\n            Math.floor( 1970 / 400 ) ) * 24 * 60 * 60 * 10000000 ),\n\n        /* Format a date object into a string value.\n         * The format can be combinations of the following:\n         * d  - day of month (no leading zero)\n         * dd - day of month (two digit)\n         * o  - day of year (no leading zeros)\n         * oo - day of year (three digit)\n         * D  - day name short\n         * DD - day name long\n         * m  - month of year (no leading zero)\n         * mm - month of year (two digit)\n         * M  - month name short\n         * MM - month name long\n         * y  - year (two digit)\n         * yy - year (four digit)\n         * @ - Unix timestamp (ms since 01/01/1970)\n         * ! - Windows ticks (100ns since 01/01/0001)\n         * \"...\" - literal text\n         * '' - single quote\n         *\n         * @param  format string - the desired format of the date\n         * @param  date Date - the date value to format\n         * @param  settings Object - attributes include:\n         *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n         *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n         *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n         *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n         * @return  string - the date in the above format\n         */\n        formatDate: function( format, date, settings ) {\n            if ( !date ) {\n                return \"\";\n            }\n\n            var iFormat,\n                dayNamesShort = ( settings ? settings.dayNamesShort : null ) || this._defaults.dayNamesShort,\n                dayNames = ( settings ? settings.dayNames : null ) || this._defaults.dayNames,\n                monthNamesShort = ( settings ? settings.monthNamesShort : null ) || this._defaults.monthNamesShort,\n                monthNames = ( settings ? settings.monthNames : null ) || this._defaults.monthNames,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                },\n\n                // Format a number, with leading zero if necessary\n                formatNumber = function( match, value, len ) {\n                    var num = \"\" + value;\n                    if ( lookAhead( match ) ) {\n                        while ( num.length < len ) {\n                            num = \"0\" + num;\n                        }\n                    }\n                    return num;\n                },\n\n                // Format a name, short or long as requested\n                formatName = function( match, value, shortNames, longNames ) {\n                    return ( lookAhead( match ) ? longNames[ value ] : shortNames[ value ] );\n                },\n                output = \"\",\n                literal = false;\n\n            if ( date ) {\n                for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                    if ( literal ) {\n                        if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                            literal = false;\n                        } else {\n                            output += format.charAt( iFormat );\n                        }\n                    } else {\n                        switch ( format.charAt( iFormat ) ) {\n                            case \"d\":\n                                output += formatNumber( \"d\", date.getDate(), 2 );\n                                break;\n                            case \"D\":\n                                output += formatName( \"D\", date.getDay(), dayNamesShort, dayNames );\n                                break;\n                            case \"o\":\n                                output += formatNumber( \"o\",\n                                    Math.round( ( new Date( date.getFullYear(), date.getMonth(), date.getDate() ).getTime() - new Date( date.getFullYear(), 0, 0 ).getTime() ) / 86400000 ), 3 );\n                                break;\n                            case \"m\":\n                                output += formatNumber( \"m\", date.getMonth() + 1, 2 );\n                                break;\n                            case \"M\":\n                                output += formatName( \"M\", date.getMonth(), monthNamesShort, monthNames );\n                                break;\n                            case \"y\":\n                                output += ( lookAhead( \"y\" ) ? date.getFullYear() :\n                                    ( date.getFullYear() % 100 < 10 ? \"0\" : \"\" ) + date.getFullYear() % 100 );\n                                break;\n                            case \"@\":\n                                output += date.getTime();\n                                break;\n                            case \"!\":\n                                output += date.getTime() * 10000 + this._ticksTo1970;\n                                break;\n                            case \"'\":\n                                if ( lookAhead( \"'\" ) ) {\n                                    output += \"'\";\n                                } else {\n                                    literal = true;\n                                }\n                                break;\n                            default:\n                                output += format.charAt( iFormat );\n                        }\n                    }\n                }\n            }\n            return output;\n        },\n\n        /* Extract all possible characters from the date format. */\n        _possibleChars: function( format ) {\n            var iFormat,\n                chars = \"\",\n                literal = false,\n\n                // Check whether a format character is doubled\n                lookAhead = function( match ) {\n                    var matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n                    if ( matches ) {\n                        iFormat++;\n                    }\n                    return matches;\n                };\n\n            for ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n                if ( literal ) {\n                    if ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n                        literal = false;\n                    } else {\n                        chars += format.charAt( iFormat );\n                    }\n                } else {\n                    switch ( format.charAt( iFormat ) ) {\n                        case \"d\": case \"m\": case \"y\": case \"@\":\n                            chars += \"0123456789\";\n                            break;\n                        case \"D\": case \"M\":\n                            return null; // Accept anything\n                        case \"'\":\n                            if ( lookAhead( \"'\" ) ) {\n                                chars += \"'\";\n                            } else {\n                                literal = true;\n                            }\n                            break;\n                        default:\n                            chars += format.charAt( iFormat );\n                    }\n                }\n            }\n            return chars;\n        },\n\n        /* Get a setting value, defaulting if necessary. */\n        _get: function( inst, name ) {\n            return inst.settings[ name ] !== undefined ?\n                inst.settings[ name ] : this._defaults[ name ];\n        },\n\n        /* Parse existing date and initialise date picker. */\n        _setDateFromField: function( inst, noDefault ) {\n            if ( inst.input.val() === inst.lastVal ) {\n                return;\n            }\n\n            var dateFormat = this._get( inst, \"dateFormat\" ),\n                dates = inst.lastVal = inst.input ? inst.input.val() : null,\n                defaultDate = this._getDefaultDate( inst ),\n                date = defaultDate,\n                settings = this._getFormatConfig( inst );\n\n            try {\n                date = this.parseDate( dateFormat, dates, settings ) || defaultDate;\n            } catch ( event ) {\n                dates = ( noDefault ? \"\" : dates );\n            }\n            inst.selectedDay = date.getDate();\n            inst.drawMonth = inst.selectedMonth = date.getMonth();\n            inst.drawYear = inst.selectedYear = date.getFullYear();\n            inst.currentDay = ( dates ? date.getDate() : 0 );\n            inst.currentMonth = ( dates ? date.getMonth() : 0 );\n            inst.currentYear = ( dates ? date.getFullYear() : 0 );\n            this._adjustInstDate( inst );\n        },\n\n        /* Retrieve the default date shown on opening. */\n        _getDefaultDate: function( inst ) {\n            return this._restrictMinMax( inst,\n                this._determineDate( inst, this._get( inst, \"defaultDate\" ), new Date() ) );\n        },\n\n        /* A date may be specified as an exact value or a relative one. */\n        _determineDate: function( inst, date, defaultDate ) {\n            var offsetNumeric = function( offset ) {\n                    var date = new Date();\n                    date.setDate( date.getDate() + offset );\n                    return date;\n                },\n                offsetString = function( offset ) {\n                    try {\n                        return $.datepicker.parseDate( $.datepicker._get( inst, \"dateFormat\" ),\n                            offset, $.datepicker._getFormatConfig( inst ) );\n                    } catch ( e ) {\n\n                        // Ignore\n                    }\n\n                    var date = ( offset.toLowerCase().match( /^c/ ) ?\n                            $.datepicker._getDate( inst ) : null ) || new Date(),\n                        year = date.getFullYear(),\n                        month = date.getMonth(),\n                        day = date.getDate(),\n                        pattern = /([+\\-]?[0-9]+)\\s*(d|D|w|W|m|M|y|Y)?/g,\n                        matches = pattern.exec( offset );\n\n                    while ( matches ) {\n                        switch ( matches[ 2 ] || \"d\" ) {\n                            case \"d\" : case \"D\" :\n                                day += parseInt( matches[ 1 ], 10 ); break;\n                            case \"w\" : case \"W\" :\n                                day += parseInt( matches[ 1 ], 10 ) * 7; break;\n                            case \"m\" : case \"M\" :\n                                month += parseInt( matches[ 1 ], 10 );\n                                day = Math.min( day, $.datepicker._getDaysInMonth( year, month ) );\n                                break;\n                            case \"y\": case \"Y\" :\n                                year += parseInt( matches[ 1 ], 10 );\n                                day = Math.min( day, $.datepicker._getDaysInMonth( year, month ) );\n                                break;\n                        }\n                        matches = pattern.exec( offset );\n                    }\n                    return new Date( year, month, day );\n                },\n                newDate = ( date == null || date === \"\" ? defaultDate : ( typeof date === \"string\" ? offsetString( date ) :\n                    ( typeof date === \"number\" ? ( isNaN( date ) ? defaultDate : offsetNumeric( date ) ) : new Date( date.getTime() ) ) ) );\n\n            newDate = ( newDate && newDate.toString() === \"Invalid Date\" ? defaultDate : newDate );\n            if ( newDate ) {\n                newDate.setHours( 0 );\n                newDate.setMinutes( 0 );\n                newDate.setSeconds( 0 );\n                newDate.setMilliseconds( 0 );\n            }\n            return this._daylightSavingAdjust( newDate );\n        },\n\n        /* Handle switch to/from daylight saving.\n         * Hours may be non-zero on daylight saving cut-over:\n         * > 12 when midnight changeover, but then cannot generate\n         * midnight datetime, so jump to 1AM, otherwise reset.\n         * @param  date  (Date) the date to check\n         * @return  (Date) the corrected date\n         */\n        _daylightSavingAdjust: function( date ) {\n            if ( !date ) {\n                return null;\n            }\n            date.setHours( date.getHours() > 12 ? date.getHours() + 2 : 0 );\n            return date;\n        },\n\n        /* Set the date(s) directly. */\n        _setDate: function( inst, date, noChange ) {\n            var clear = !date,\n                origMonth = inst.selectedMonth,\n                origYear = inst.selectedYear,\n                newDate = this._restrictMinMax( inst, this._determineDate( inst, date, new Date() ) );\n\n            inst.selectedDay = inst.currentDay = newDate.getDate();\n            inst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();\n            inst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();\n            if ( ( origMonth !== inst.selectedMonth || origYear !== inst.selectedYear ) && !noChange ) {\n                this._notifyChange( inst );\n            }\n            this._adjustInstDate( inst );\n            if ( inst.input ) {\n                inst.input.val( clear ? \"\" : this._formatDate( inst ) );\n            }\n        },\n\n        /* Retrieve the date(s) directly. */\n        _getDate: function( inst ) {\n            var startDate = ( !inst.currentYear || ( inst.input && inst.input.val() === \"\" ) ? null :\n                this._daylightSavingAdjust( new Date(\n                    inst.currentYear, inst.currentMonth, inst.currentDay ) ) );\n            return startDate;\n        },\n\n        /* Attach the onxxx handlers.  These are declared statically so\n         * they work with static code transformers like Caja.\n         */\n        _attachHandlers: function( inst ) {\n            var stepMonths = this._get( inst, \"stepMonths\" ),\n                id = \"#\" + inst.id.replace( /\\\\\\\\/g, \"\\\\\" );\n            inst.dpDiv.find( \"[data-handler]\" ).map( function() {\n                var handler = {\n                    prev: function() {\n                        $.datepicker._adjustDate( id, -stepMonths, \"M\" );\n                    },\n                    next: function() {\n                        $.datepicker._adjustDate( id, +stepMonths, \"M\" );\n                    },\n                    hide: function() {\n                        $.datepicker._hideDatepicker();\n                    },\n                    today: function() {\n                        $.datepicker._gotoToday( id );\n                    },\n                    selectDay: function() {\n                        $.datepicker._selectDay( id, +this.getAttribute( \"data-month\" ), +this.getAttribute( \"data-year\" ), this );\n                        return false;\n                    },\n                    selectMonth: function() {\n                        $.datepicker._selectMonthYear( id, this, \"M\" );\n                        return false;\n                    },\n                    selectYear: function() {\n                        $.datepicker._selectMonthYear( id, this, \"Y\" );\n                        return false;\n                    }\n                };\n                $( this ).on( this.getAttribute( \"data-event\" ), handler[ this.getAttribute( \"data-handler\" ) ] );\n            } );\n        },\n\n        /* Generate the HTML for the current state of the date picker. */\n        _generateHTML: function( inst ) {\n            var maxDraw, prevText, prev, nextText, next, currentText, gotoDate,\n                controls, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin,\n                monthNames, monthNamesShort, beforeShowDay, showOtherMonths,\n                selectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate,\n                cornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows,\n                printDate, dRow, tbody, daySettings, otherMonth, unselectable,\n                tempDate = new Date(),\n                today = this._daylightSavingAdjust(\n                    new Date( tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate() ) ), // clear time\n                isRTL = this._get( inst, \"isRTL\" ),\n                showButtonPanel = this._get( inst, \"showButtonPanel\" ),\n                hideIfNoPrevNext = this._get( inst, \"hideIfNoPrevNext\" ),\n                navigationAsDateFormat = this._get( inst, \"navigationAsDateFormat\" ),\n                numMonths = this._getNumberOfMonths( inst ),\n                showCurrentAtPos = this._get( inst, \"showCurrentAtPos\" ),\n                stepMonths = this._get( inst, \"stepMonths\" ),\n                isMultiMonth = ( numMonths[ 0 ] !== 1 || numMonths[ 1 ] !== 1 ),\n                currentDate = this._daylightSavingAdjust( ( !inst.currentDay ? new Date( 9999, 9, 9 ) :\n                    new Date( inst.currentYear, inst.currentMonth, inst.currentDay ) ) ),\n                minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                drawMonth = inst.drawMonth - showCurrentAtPos,\n                drawYear = inst.drawYear;\n\n            if ( drawMonth < 0 ) {\n                drawMonth += 12;\n                drawYear--;\n            }\n            if ( maxDate ) {\n                maxDraw = this._daylightSavingAdjust( new Date( maxDate.getFullYear(),\n                    maxDate.getMonth() - ( numMonths[ 0 ] * numMonths[ 1 ] ) + 1, maxDate.getDate() ) );\n                maxDraw = ( minDate && maxDraw < minDate ? minDate : maxDraw );\n                while ( this._daylightSavingAdjust( new Date( drawYear, drawMonth, 1 ) ) > maxDraw ) {\n                    drawMonth--;\n                    if ( drawMonth < 0 ) {\n                        drawMonth = 11;\n                        drawYear--;\n                    }\n                }\n            }\n            inst.drawMonth = drawMonth;\n            inst.drawYear = drawYear;\n\n            prevText = this._get( inst, \"prevText\" );\n            prevText = ( !navigationAsDateFormat ? prevText : this.formatDate( prevText,\n                this._daylightSavingAdjust( new Date( drawYear, drawMonth - stepMonths, 1 ) ),\n                this._getFormatConfig( inst ) ) );\n\n            if ( this._canAdjustMonth( inst, -1, drawYear, drawMonth ) ) {\n                prev = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-prev ui-corner-all\",\n                        \"data-handler\": \"prev\",\n                        \"data-event\": \"click\",\n                        title: prevText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"e\" : \"w\" ) )\n                            .text( prevText )\n                    )[ 0 ].outerHTML;\n            } else if ( hideIfNoPrevNext ) {\n                prev = \"\";\n            } else {\n                prev = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-prev ui-corner-all ui-state-disabled\",\n                        title: prevText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"e\" : \"w\" ) )\n                            .text( prevText )\n                    )[ 0 ].outerHTML;\n            }\n\n            nextText = this._get( inst, \"nextText\" );\n            nextText = ( !navigationAsDateFormat ? nextText : this.formatDate( nextText,\n                this._daylightSavingAdjust( new Date( drawYear, drawMonth + stepMonths, 1 ) ),\n                this._getFormatConfig( inst ) ) );\n\n            if ( this._canAdjustMonth( inst, +1, drawYear, drawMonth ) ) {\n                next = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-next ui-corner-all\",\n                        \"data-handler\": \"next\",\n                        \"data-event\": \"click\",\n                        title: nextText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .addClass( \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"w\" : \"e\" ) )\n                            .text( nextText )\n                    )[ 0 ].outerHTML;\n            } else if ( hideIfNoPrevNext ) {\n                next = \"\";\n            } else {\n                next = $( \"<a>\" )\n                    .attr( {\n                        \"class\": \"ui-datepicker-next ui-corner-all ui-state-disabled\",\n                        title: nextText\n                    } )\n                    .append(\n                        $( \"<span>\" )\n                            .attr( \"class\", \"ui-icon ui-icon-circle-triangle-\" +\n                                ( isRTL ? \"w\" : \"e\" ) )\n                            .text( nextText )\n                    )[ 0 ].outerHTML;\n            }\n\n            currentText = this._get( inst, \"currentText\" );\n            gotoDate = ( this._get( inst, \"gotoCurrent\" ) && inst.currentDay ? currentDate : today );\n            currentText = ( !navigationAsDateFormat ? currentText :\n                this.formatDate( currentText, gotoDate, this._getFormatConfig( inst ) ) );\n\n            controls = \"\";\n            if ( !inst.inline ) {\n                controls = $( \"<button>\" )\n                    .attr( {\n                        type: \"button\",\n                        \"class\": \"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all\",\n                        \"data-handler\": \"hide\",\n                        \"data-event\": \"click\"\n                    } )\n                    .text( this._get( inst, \"closeText\" ) )[ 0 ].outerHTML;\n            }\n\n            buttonPanel = \"\";\n            if ( showButtonPanel ) {\n                buttonPanel = $( \"<div class='ui-datepicker-buttonpane ui-widget-content'>\" )\n                    .append( isRTL ? controls : \"\" )\n                    .append( this._isInRange( inst, gotoDate ) ?\n                        $( \"<button>\" )\n                            .attr( {\n                                type: \"button\",\n                                \"class\": \"ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all\",\n                                \"data-handler\": \"today\",\n                                \"data-event\": \"click\"\n                            } )\n                            .text( currentText ) :\n                        \"\" )\n                    .append( isRTL ? \"\" : controls )[ 0 ].outerHTML;\n            }\n\n            firstDay = parseInt( this._get( inst, \"firstDay\" ), 10 );\n            firstDay = ( isNaN( firstDay ) ? 0 : firstDay );\n\n            showWeek = this._get( inst, \"showWeek\" );\n            dayNames = this._get( inst, \"dayNames\" );\n            dayNamesMin = this._get( inst, \"dayNamesMin\" );\n            monthNames = this._get( inst, \"monthNames\" );\n            monthNamesShort = this._get( inst, \"monthNamesShort\" );\n            beforeShowDay = this._get( inst, \"beforeShowDay\" );\n            showOtherMonths = this._get( inst, \"showOtherMonths\" );\n            selectOtherMonths = this._get( inst, \"selectOtherMonths\" );\n            defaultDate = this._getDefaultDate( inst );\n            html = \"\";\n\n            for ( row = 0; row < numMonths[ 0 ]; row++ ) {\n                group = \"\";\n                this.maxRows = 4;\n                for ( col = 0; col < numMonths[ 1 ]; col++ ) {\n                    selectedDate = this._daylightSavingAdjust( new Date( drawYear, drawMonth, inst.selectedDay ) );\n                    cornerClass = \" ui-corner-all\";\n                    calender = \"\";\n                    if ( isMultiMonth ) {\n                        calender += \"<div class='ui-datepicker-group\";\n                        if ( numMonths[ 1 ] > 1 ) {\n                            switch ( col ) {\n                                case 0: calender += \" ui-datepicker-group-first\";\n                                    cornerClass = \" ui-corner-\" + ( isRTL ? \"right\" : \"left\" ); break;\n                                case numMonths[ 1 ] - 1: calender += \" ui-datepicker-group-last\";\n                                    cornerClass = \" ui-corner-\" + ( isRTL ? \"left\" : \"right\" ); break;\n                                default: calender += \" ui-datepicker-group-middle\"; cornerClass = \"\"; break;\n                            }\n                        }\n                        calender += \"'>\";\n                    }\n                    calender += \"<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix\" + cornerClass + \"'>\" +\n                        ( /all|left/.test( cornerClass ) && row === 0 ? ( isRTL ? next : prev ) : \"\" ) +\n                        ( /all|right/.test( cornerClass ) && row === 0 ? ( isRTL ? prev : next ) : \"\" ) +\n                        this._generateMonthYearHeader( inst, drawMonth, drawYear, minDate, maxDate,\n                            row > 0 || col > 0, monthNames, monthNamesShort ) + // draw month headers\n                        \"</div><table class='ui-datepicker-calendar'><thead>\" +\n                        \"<tr>\";\n                    thead = ( showWeek ? \"<th class='ui-datepicker-week-col'>\" + this._get( inst, \"weekHeader\" ) + \"</th>\" : \"\" );\n                    for ( dow = 0; dow < 7; dow++ ) { // days of the week\n                        day = ( dow + firstDay ) % 7;\n                        thead += \"<th scope='col'\" + ( ( dow + firstDay + 6 ) % 7 >= 5 ? \" class='ui-datepicker-week-end'\" : \"\" ) + \">\" +\n                            \"<span title='\" + dayNames[ day ] + \"'>\" + dayNamesMin[ day ] + \"</span></th>\";\n                    }\n                    calender += thead + \"</tr></thead><tbody>\";\n                    daysInMonth = this._getDaysInMonth( drawYear, drawMonth );\n                    if ( drawYear === inst.selectedYear && drawMonth === inst.selectedMonth ) {\n                        inst.selectedDay = Math.min( inst.selectedDay, daysInMonth );\n                    }\n                    leadDays = ( this._getFirstDayOfMonth( drawYear, drawMonth ) - firstDay + 7 ) % 7;\n                    curRows = Math.ceil( ( leadDays + daysInMonth ) / 7 ); // calculate the number of rows to generate\n                    numRows = ( isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows ); //If multiple months, use the higher number of rows (see #7043)\n                    this.maxRows = numRows;\n                    printDate = this._daylightSavingAdjust( new Date( drawYear, drawMonth, 1 - leadDays ) );\n                    for ( dRow = 0; dRow < numRows; dRow++ ) { // create date picker rows\n                        calender += \"<tr>\";\n                        tbody = ( !showWeek ? \"\" : \"<td class='ui-datepicker-week-col'>\" +\n                            this._get( inst, \"calculateWeek\" )( printDate ) + \"</td>\" );\n                        for ( dow = 0; dow < 7; dow++ ) { // create date picker days\n                            daySettings = ( beforeShowDay ?\n                                beforeShowDay.apply( ( inst.input ? inst.input[ 0 ] : null ), [ printDate ] ) : [ true, \"\" ] );\n                            otherMonth = ( printDate.getMonth() !== drawMonth );\n                            unselectable = ( otherMonth && !selectOtherMonths ) || !daySettings[ 0 ] ||\n                                ( minDate && printDate < minDate ) || ( maxDate && printDate > maxDate );\n                            tbody += \"<td class='\" +\n                                ( ( dow + firstDay + 6 ) % 7 >= 5 ? \" ui-datepicker-week-end\" : \"\" ) + // highlight weekends\n                                ( otherMonth ? \" ui-datepicker-other-month\" : \"\" ) + // highlight days from other months\n                                ( ( printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent ) || // user pressed key\n                                ( defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime() ) ?\n\n                                    // or defaultDate is current printedDate and defaultDate is selectedDate\n                                    \" \" + this._dayOverClass : \"\" ) + // highlight selected day\n                                ( unselectable ? \" \" + this._unselectableClass + \" ui-state-disabled\" : \"\" ) +  // highlight unselectable days\n                                ( otherMonth && !showOtherMonths ? \"\" : \" \" + daySettings[ 1 ] + // highlight custom dates\n                                    ( printDate.getTime() === currentDate.getTime() ? \" \" + this._currentClass : \"\" ) + // highlight selected day\n                                    ( printDate.getTime() === today.getTime() ? \" ui-datepicker-today\" : \"\" ) ) + \"'\" + // highlight today (if different)\n                                ( ( !otherMonth || showOtherMonths ) && daySettings[ 2 ] ? \" title='\" + daySettings[ 2 ].replace( /'/g, \"&#39;\" ) + \"'\" : \"\" ) + // cell title\n                                ( unselectable ? \"\" : \" data-handler='selectDay' data-event='click' data-month='\" + printDate.getMonth() + \"' data-year='\" + printDate.getFullYear() + \"'\" ) + \">\" + // actions\n                                ( otherMonth && !showOtherMonths ? \"&#xa0;\" : // display for other months\n                                    ( unselectable ? \"<span class='ui-state-default'>\" + printDate.getDate() + \"</span>\" : \"<a class='ui-state-default\" +\n                                        ( printDate.getTime() === today.getTime() ? \" ui-state-highlight\" : \"\" ) +\n                                        ( printDate.getTime() === currentDate.getTime() ? \" ui-state-active\" : \"\" ) + // highlight selected day\n                                        ( otherMonth ? \" ui-priority-secondary\" : \"\" ) + // distinguish dates from other months\n                                        \"' href='#' aria-current='\" + ( printDate.getTime() === currentDate.getTime() ? \"true\" : \"false\" ) + // mark date as selected for screen reader\n                                        \"' data-date='\" + printDate.getDate() + // store date as data\n                                        \"'>\" + printDate.getDate() + \"</a>\" ) ) + \"</td>\"; // display selectable date\n                            printDate.setDate( printDate.getDate() + 1 );\n                            printDate = this._daylightSavingAdjust( printDate );\n                        }\n                        calender += tbody + \"</tr>\";\n                    }\n                    drawMonth++;\n                    if ( drawMonth > 11 ) {\n                        drawMonth = 0;\n                        drawYear++;\n                    }\n                    calender += \"</tbody></table>\" + ( isMultiMonth ? \"</div>\" +\n                        ( ( numMonths[ 0 ] > 0 && col === numMonths[ 1 ] - 1 ) ? \"<div class='ui-datepicker-row-break'></div>\" : \"\" ) : \"\" );\n                    group += calender;\n                }\n                html += group;\n            }\n            html += buttonPanel;\n            inst._keyEvent = false;\n            return html;\n        },\n\n        /* Generate the month and year header. */\n        _generateMonthYearHeader: function( inst, drawMonth, drawYear, minDate, maxDate,\n                                            secondary, monthNames, monthNamesShort ) {\n\n            var inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear,\n                changeMonth = this._get( inst, \"changeMonth\" ),\n                changeYear = this._get( inst, \"changeYear\" ),\n                showMonthAfterYear = this._get( inst, \"showMonthAfterYear\" ),\n                selectMonthLabel = this._get( inst, \"selectMonthLabel\" ),\n                selectYearLabel = this._get( inst, \"selectYearLabel\" ),\n                html = \"<div class='ui-datepicker-title'>\",\n                monthHtml = \"\";\n\n            // Month selection\n            if ( secondary || !changeMonth ) {\n                monthHtml += \"<span class='ui-datepicker-month'>\" + monthNames[ drawMonth ] + \"</span>\";\n            } else {\n                inMinYear = ( minDate && minDate.getFullYear() === drawYear );\n                inMaxYear = ( maxDate && maxDate.getFullYear() === drawYear );\n                monthHtml += \"<select class='ui-datepicker-month' aria-label='\" + selectMonthLabel + \"' data-handler='selectMonth' data-event='change'>\";\n                for ( month = 0; month < 12; month++ ) {\n                    if ( ( !inMinYear || month >= minDate.getMonth() ) && ( !inMaxYear || month <= maxDate.getMonth() ) ) {\n                        monthHtml += \"<option value='\" + month + \"'\" +\n                            ( month === drawMonth ? \" selected='selected'\" : \"\" ) +\n                            \">\" + monthNamesShort[ month ] + \"</option>\";\n                    }\n                }\n                monthHtml += \"</select>\";\n            }\n\n            if ( !showMonthAfterYear ) {\n                html += monthHtml + ( secondary || !( changeMonth && changeYear ) ? \"&#xa0;\" : \"\" );\n            }\n\n            // Year selection\n            if ( !inst.yearshtml ) {\n                inst.yearshtml = \"\";\n                if ( secondary || !changeYear ) {\n                    html += \"<span class='ui-datepicker-year'>\" + drawYear + \"</span>\";\n                } else {\n\n                    // determine range of years to display\n                    years = this._get( inst, \"yearRange\" ).split( \":\" );\n                    thisYear = new Date().getFullYear();\n                    determineYear = function( value ) {\n                        var year = ( value.match( /c[+\\-].*/ ) ? drawYear + parseInt( value.substring( 1 ), 10 ) :\n                            ( value.match( /[+\\-].*/ ) ? thisYear + parseInt( value, 10 ) :\n                                parseInt( value, 10 ) ) );\n                        return ( isNaN( year ) ? thisYear : year );\n                    };\n                    year = determineYear( years[ 0 ] );\n                    endYear = Math.max( year, determineYear( years[ 1 ] || \"\" ) );\n                    year = ( minDate ? Math.max( year, minDate.getFullYear() ) : year );\n                    endYear = ( maxDate ? Math.min( endYear, maxDate.getFullYear() ) : endYear );\n                    inst.yearshtml += \"<select class='ui-datepicker-year' aria-label='\" + selectYearLabel + \"' data-handler='selectYear' data-event='change'>\";\n                    for ( ; year <= endYear; year++ ) {\n                        inst.yearshtml += \"<option value='\" + year + \"'\" +\n                            ( year === drawYear ? \" selected='selected'\" : \"\" ) +\n                            \">\" + year + \"</option>\";\n                    }\n                    inst.yearshtml += \"</select>\";\n\n                    html += inst.yearshtml;\n                    inst.yearshtml = null;\n                }\n            }\n\n            html += this._get( inst, \"yearSuffix\" );\n            if ( showMonthAfterYear ) {\n                html += ( secondary || !( changeMonth && changeYear ) ? \"&#xa0;\" : \"\" ) + monthHtml;\n            }\n            html += \"</div>\"; // Close datepicker_header\n            return html;\n        },\n\n        /* Adjust one of the date sub-fields. */\n        _adjustInstDate: function( inst, offset, period ) {\n            var year = inst.selectedYear + ( period === \"Y\" ? offset : 0 ),\n                month = inst.selectedMonth + ( period === \"M\" ? offset : 0 ),\n                day = Math.min( inst.selectedDay, this._getDaysInMonth( year, month ) ) + ( period === \"D\" ? offset : 0 ),\n                date = this._restrictMinMax( inst, this._daylightSavingAdjust( new Date( year, month, day ) ) );\n\n            inst.selectedDay = date.getDate();\n            inst.drawMonth = inst.selectedMonth = date.getMonth();\n            inst.drawYear = inst.selectedYear = date.getFullYear();\n            if ( period === \"M\" || period === \"Y\" ) {\n                this._notifyChange( inst );\n            }\n        },\n\n        /* Ensure a date is within any min/max bounds. */\n        _restrictMinMax: function( inst, date ) {\n            var minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                newDate = ( minDate && date < minDate ? minDate : date );\n            return ( maxDate && newDate > maxDate ? maxDate : newDate );\n        },\n\n        /* Notify change of month/year. */\n        _notifyChange: function( inst ) {\n            var onChange = this._get( inst, \"onChangeMonthYear\" );\n            if ( onChange ) {\n                onChange.apply( ( inst.input ? inst.input[ 0 ] : null ),\n                    [ inst.selectedYear, inst.selectedMonth + 1, inst ] );\n            }\n        },\n\n        /* Determine the number of months to show. */\n        _getNumberOfMonths: function( inst ) {\n            var numMonths = this._get( inst, \"numberOfMonths\" );\n            return ( numMonths == null ? [ 1, 1 ] : ( typeof numMonths === \"number\" ? [ 1, numMonths ] : numMonths ) );\n        },\n\n        /* Determine the current maximum date - ensure no time components are set. */\n        _getMinMaxDate: function( inst, minMax ) {\n            return this._determineDate( inst, this._get( inst, minMax + \"Date\" ), null );\n        },\n\n        /* Find the number of days in a given month. */\n        _getDaysInMonth: function( year, month ) {\n            return 32 - this._daylightSavingAdjust( new Date( year, month, 32 ) ).getDate();\n        },\n\n        /* Find the day of the week of the first of a month. */\n        _getFirstDayOfMonth: function( year, month ) {\n            return new Date( year, month, 1 ).getDay();\n        },\n\n        /* Determines if we should allow a \"next/prev\" month display change. */\n        _canAdjustMonth: function( inst, offset, curYear, curMonth ) {\n            var numMonths = this._getNumberOfMonths( inst ),\n                date = this._daylightSavingAdjust( new Date( curYear,\n                    curMonth + ( offset < 0 ? offset : numMonths[ 0 ] * numMonths[ 1 ] ), 1 ) );\n\n            if ( offset < 0 ) {\n                date.setDate( this._getDaysInMonth( date.getFullYear(), date.getMonth() ) );\n            }\n            return this._isInRange( inst, date );\n        },\n\n        /* Is the given date in the accepted range? */\n        _isInRange: function( inst, date ) {\n            var yearSplit, currentYear,\n                minDate = this._getMinMaxDate( inst, \"min\" ),\n                maxDate = this._getMinMaxDate( inst, \"max\" ),\n                minYear = null,\n                maxYear = null,\n                years = this._get( inst, \"yearRange\" );\n            if ( years ) {\n                yearSplit = years.split( \":\" );\n                currentYear = new Date().getFullYear();\n                minYear = parseInt( yearSplit[ 0 ], 10 );\n                maxYear = parseInt( yearSplit[ 1 ], 10 );\n                if ( yearSplit[ 0 ].match( /[+\\-].*/ ) ) {\n                    minYear += currentYear;\n                }\n                if ( yearSplit[ 1 ].match( /[+\\-].*/ ) ) {\n                    maxYear += currentYear;\n                }\n            }\n\n            return ( ( !minDate || date.getTime() >= minDate.getTime() ) &&\n                ( !maxDate || date.getTime() <= maxDate.getTime() ) &&\n                ( !minYear || date.getFullYear() >= minYear ) &&\n                ( !maxYear || date.getFullYear() <= maxYear ) );\n        },\n\n        /* Provide the configuration settings for formatting/parsing. */\n        _getFormatConfig: function( inst ) {\n            var shortYearCutoff = this._get( inst, \"shortYearCutoff\" );\n            shortYearCutoff = ( typeof shortYearCutoff !== \"string\" ? shortYearCutoff :\n                new Date().getFullYear() % 100 + parseInt( shortYearCutoff, 10 ) );\n            return { shortYearCutoff: shortYearCutoff,\n                dayNamesShort: this._get( inst, \"dayNamesShort\" ), dayNames: this._get( inst, \"dayNames\" ),\n                monthNamesShort: this._get( inst, \"monthNamesShort\" ), monthNames: this._get( inst, \"monthNames\" ) };\n        },\n\n        /* Format the given date for display. */\n        _formatDate: function( inst, day, month, year ) {\n            if ( !day ) {\n                inst.currentDay = inst.selectedDay;\n                inst.currentMonth = inst.selectedMonth;\n                inst.currentYear = inst.selectedYear;\n            }\n            var date = ( day ? ( typeof day === \"object\" ? day :\n                    this._daylightSavingAdjust( new Date( year, month, day ) ) ) :\n                this._daylightSavingAdjust( new Date( inst.currentYear, inst.currentMonth, inst.currentDay ) ) );\n            return this.formatDate( this._get( inst, \"dateFormat\" ), date, this._getFormatConfig( inst ) );\n        }\n    } );\n\n    /*\n     * Bind hover events for datepicker elements.\n     * Done via delegate so the binding only occurs once in the lifetime of the parent div.\n     * Global datepicker_instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.\n     */\n    function datepicker_bindHover( dpDiv ) {\n        var selector = \"button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a\";\n        return dpDiv.on( \"mouseout\", selector, function() {\n            $( this ).removeClass( \"ui-state-hover\" );\n            if ( this.className.indexOf( \"ui-datepicker-prev\" ) !== -1 ) {\n                $( this ).removeClass( \"ui-datepicker-prev-hover\" );\n            }\n            if ( this.className.indexOf( \"ui-datepicker-next\" ) !== -1 ) {\n                $( this ).removeClass( \"ui-datepicker-next-hover\" );\n            }\n        } )\n            .on( \"mouseover\", selector, datepicker_handleMouseover );\n    }\n\n    function datepicker_handleMouseover() {\n        if ( !$.datepicker._isDisabledDatepicker( datepicker_instActive.inline ? datepicker_instActive.dpDiv.parent()[ 0 ] : datepicker_instActive.input[ 0 ] ) ) {\n            $( this ).parents( \".ui-datepicker-calendar\" ).find( \"a\" ).removeClass( \"ui-state-hover\" );\n            $( this ).addClass( \"ui-state-hover\" );\n            if ( this.className.indexOf( \"ui-datepicker-prev\" ) !== -1 ) {\n                $( this ).addClass( \"ui-datepicker-prev-hover\" );\n            }\n            if ( this.className.indexOf( \"ui-datepicker-next\" ) !== -1 ) {\n                $( this ).addClass( \"ui-datepicker-next-hover\" );\n            }\n        }\n    }\n\n    /* jQuery extend now ignores nulls! */\n    function datepicker_extendRemove( target, props ) {\n        $.extend( target, props );\n        for ( var name in props ) {\n            if ( props[ name ] == null ) {\n                target[ name ] = props[ name ];\n            }\n        }\n        return target;\n    }\n\n    /* Invoke the datepicker functionality.\n       @param  options  string - a command, optionally followed by additional parameters or\n                        Object - settings for attaching new datepicker functionality\n       @return  jQuery object */\n    $.fn.datepicker = function( options ) {\n\n        /* Verify an empty collection wasn't passed - Fixes #6976 */\n        if ( !this.length ) {\n            return this;\n        }\n\n        /* Initialise the date picker. */\n        if ( !$.datepicker.initialized ) {\n            $( document ).on( \"mousedown\", $.datepicker._checkExternalClick );\n            $.datepicker.initialized = true;\n        }\n\n        /* Append datepicker main container to body if not exist. */\n        if ( $( \"#\" + $.datepicker._mainDivId ).length === 0 ) {\n            $( \"body\" ).append( $.datepicker.dpDiv );\n        }\n\n        var otherArgs = Array.prototype.slice.call( arguments, 1 );\n        if ( typeof options === \"string\" && ( options === \"isDisabled\" || options === \"getDate\" || options === \"widget\" ) ) {\n            return $.datepicker[ \"_\" + options + \"Datepicker\" ].\n            apply( $.datepicker, [ this[ 0 ] ].concat( otherArgs ) );\n        }\n        if ( options === \"option\" && arguments.length === 2 && typeof arguments[ 1 ] === \"string\" ) {\n            return $.datepicker[ \"_\" + options + \"Datepicker\" ].\n            apply( $.datepicker, [ this[ 0 ] ].concat( otherArgs ) );\n        }\n        return this.each( function() {\n            if ( typeof options === \"string\" ) {\n                $.datepicker[ \"_\" + options + \"Datepicker\" ]\n                    .apply( $.datepicker, [ this ].concat( otherArgs ) );\n            } else {\n                $.datepicker._attachDatepicker( this, options );\n            }\n        } );\n    };\n\n    $.datepicker = new Datepicker(); // singleton instance\n    $.datepicker.initialized = false;\n    $.datepicker.uuid = new Date().getTime();\n    $.datepicker.version = \"1.13.2\";\n\n    return $.datepicker;\n\n} );\n","jquery/ui-modules/widgets/accordion.js":"/*!\n * jQuery UI Accordion 1.13.2\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Accordion\n//>>group: Widgets\n/* eslint-disable max-len */\n//>>description: Displays collapsible content panels for presenting information in a limited amount of space.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/accordion/\n//>>demos: http://jqueryui.com/accordion/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/accordion.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n    \"use strict\";\n\n    if ( typeof define === \"function\" && define.amd ) {\n\n        // AMD. Register as an anonymous module.\n        define( [\n            \"jquery\",\n            \"../version\",\n            \"../keycode\",\n            \"../unique-id\",\n            \"../widget\"\n        ], factory );\n    } else {\n\n        // Browser globals\n        factory( jQuery );\n    }\n} )( function( $ ) {\n    \"use strict\";\n\n    return $.widget( \"ui.accordion\", {\n        version: \"1.13.2\",\n        options: {\n            active: 0,\n            animate: {},\n            classes: {\n                \"ui-accordion-header\": \"ui-corner-top\",\n                \"ui-accordion-header-collapsed\": \"ui-corner-all\",\n                \"ui-accordion-content\": \"ui-corner-bottom\"\n            },\n            collapsible: false,\n            event: \"click\",\n            header: function( elem ) {\n                return elem.find( \"> li > :first-child\" ).add( elem.find( \"> :not(li)\" ).even() );\n            },\n            heightStyle: \"auto\",\n            icons: {\n                activeHeader: \"ui-icon-triangle-1-s\",\n                header: \"ui-icon-triangle-1-e\"\n            },\n\n            // Callbacks\n            activate: null,\n            beforeActivate: null\n        },\n\n        hideProps: {\n            borderTopWidth: \"hide\",\n            borderBottomWidth: \"hide\",\n            paddingTop: \"hide\",\n            paddingBottom: \"hide\",\n            height: \"hide\"\n        },\n\n        showProps: {\n            borderTopWidth: \"show\",\n            borderBottomWidth: \"show\",\n            paddingTop: \"show\",\n            paddingBottom: \"show\",\n            height: \"show\"\n        },\n\n        _create: function() {\n            var options = this.options;\n\n            this.prevShow = this.prevHide = $();\n            this._addClass( \"ui-accordion\", \"ui-widget ui-helper-reset\" );\n            this.element.attr( \"role\", \"tablist\" );\n\n            // Don't allow collapsible: false and active: false / null\n            if ( !options.collapsible && ( options.active === false || options.active == null ) ) {\n                options.active = 0;\n            }\n\n            this._processPanels();\n\n            // handle negative values\n            if ( options.active < 0 ) {\n                options.active += this.headers.length;\n            }\n            this._refresh();\n        },\n\n        _getCreateEventData: function() {\n            return {\n                header: this.active,\n                panel: !this.active.length ? $() : this.active.next()\n            };\n        },\n\n        _createIcons: function() {\n            var icon, children,\n                icons = this.options.icons;\n\n            if ( icons ) {\n                icon = $( \"<span>\" );\n                this._addClass( icon, \"ui-accordion-header-icon\", \"ui-icon \" + icons.header );\n                icon.prependTo( this.headers );\n                children = this.active.children( \".ui-accordion-header-icon\" );\n                this._removeClass( children, icons.header )\n                    ._addClass( children, null, icons.activeHeader )\n                    ._addClass( this.headers, \"ui-accordion-icons\" );\n            }\n        },\n\n        _destroyIcons: function() {\n            this._removeClass( this.headers, \"ui-accordion-icons\" );\n            this.headers.children( \".ui-accordion-header-icon\" ).remove();\n        },\n\n        _destroy: function() {\n            var contents;\n\n            // Clean up main element\n            this.element.removeAttr( \"role\" );\n\n            // Clean up headers\n            this.headers\n                .removeAttr( \"role aria-expanded aria-selected aria-controls tabIndex\" )\n                .removeUniqueId();\n\n            this._destroyIcons();\n\n            // Clean up content panels\n            contents = this.headers.next()\n                .css( \"display\", \"\" )\n                .removeAttr( \"role aria-hidden aria-labelledby\" )\n                .removeUniqueId();\n\n            if ( this.options.heightStyle !== \"content\" ) {\n                contents.css( \"height\", \"\" );\n            }\n        },\n\n        _setOption: function( key, value ) {\n            if ( key === \"active\" ) {\n\n                // _activate() will handle invalid values and update this.options\n                this._activate( value );\n                return;\n            }\n\n            if ( key === \"event\" ) {\n                if ( this.options.event ) {\n                    this._off( this.headers, this.options.event );\n                }\n                this._setupEvents( value );\n            }\n\n            this._super( key, value );\n\n            // Setting collapsible: false while collapsed; open first panel\n            if ( key === \"collapsible\" && !value && this.options.active === false ) {\n                this._activate( 0 );\n            }\n\n            if ( key === \"icons\" ) {\n                this._destroyIcons();\n                if ( value ) {\n                    this._createIcons();\n                }\n            }\n        },\n\n        _setOptionDisabled: function( value ) {\n            this._super( value );\n\n            this.element.attr( \"aria-disabled\", value );\n\n            // Support: IE8 Only\n            // #5332 / #6059 - opacity doesn't cascade to positioned elements in IE\n            // so we need to add the disabled class to the headers and panels\n            this._toggleClass( null, \"ui-state-disabled\", !!value );\n            this._toggleClass( this.headers.add( this.headers.next() ), null, \"ui-state-disabled\",\n                !!value );\n        },\n\n        _keydown: function( event ) {\n            if ( event.altKey || event.ctrlKey ) {\n                return;\n            }\n\n            var keyCode = $.ui.keyCode,\n                length = this.headers.length,\n                currentIndex = this.headers.index( event.target ),\n                toFocus = false;\n\n            switch ( event.keyCode ) {\n                case keyCode.RIGHT:\n                case keyCode.DOWN:\n                    toFocus = this.headers[ ( currentIndex + 1 ) % length ];\n                    break;\n                case keyCode.LEFT:\n                case keyCode.UP:\n                    toFocus = this.headers[ ( currentIndex - 1 + length ) % length ];\n                    break;\n                case keyCode.SPACE:\n                case keyCode.ENTER:\n                    this._eventHandler( event );\n                    break;\n                case keyCode.HOME:\n                    toFocus = this.headers[ 0 ];\n                    break;\n                case keyCode.END:\n                    toFocus = this.headers[ length - 1 ];\n                    break;\n            }\n\n            if ( toFocus ) {\n                $( event.target ).attr( \"tabIndex\", -1 );\n                $( toFocus ).attr( \"tabIndex\", 0 );\n                $( toFocus ).trigger( \"focus\" );\n                event.preventDefault();\n            }\n        },\n\n        _panelKeyDown: function( event ) {\n            if ( event.keyCode === $.ui.keyCode.UP && event.ctrlKey ) {\n                $( event.currentTarget ).prev().trigger( \"focus\" );\n            }\n        },\n\n        refresh: function() {\n            var options = this.options;\n            this._processPanels();\n\n            // Was collapsed or no panel\n            if ( ( options.active === false && options.collapsible === true ) ||\n                !this.headers.length ) {\n                options.active = false;\n                this.active = $();\n\n                // active false only when collapsible is true\n            } else if ( options.active === false ) {\n                this._activate( 0 );\n\n                // was active, but active panel is gone\n            } else if ( this.active.length && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n\n                // all remaining panel are disabled\n                if ( this.headers.length === this.headers.find( \".ui-state-disabled\" ).length ) {\n                    options.active = false;\n                    this.active = $();\n\n                    // activate previous panel\n                } else {\n                    this._activate( Math.max( 0, options.active - 1 ) );\n                }\n\n                // was active, active panel still exists\n            } else {\n\n                // make sure active index is correct\n                options.active = this.headers.index( this.active );\n            }\n\n            this._destroyIcons();\n\n            this._refresh();\n        },\n\n        _processPanels: function() {\n            var prevHeaders = this.headers,\n                prevPanels = this.panels;\n\n            if ( typeof this.options.header === \"function\" ) {\n                this.headers = this.options.header( this.element );\n            } else {\n                this.headers = this.element.find( this.options.header );\n            }\n            this._addClass( this.headers, \"ui-accordion-header ui-accordion-header-collapsed\",\n                \"ui-state-default\" );\n\n            this.panels = this.headers.next().filter( \":not(.ui-accordion-content-active)\" ).hide();\n            this._addClass( this.panels, \"ui-accordion-content\", \"ui-helper-reset ui-widget-content\" );\n\n            // Avoid memory leaks (#10056)\n            if ( prevPanels ) {\n                this._off( prevHeaders.not( this.headers ) );\n                this._off( prevPanels.not( this.panels ) );\n            }\n        },\n\n        _refresh: function() {\n            var maxHeight,\n                options = this.options,\n                heightStyle = options.heightStyle,\n                parent = this.element.parent();\n\n            this.active = this._findActive( options.active );\n            this._addClass( this.active, \"ui-accordion-header-active\", \"ui-state-active\" )\n                ._removeClass( this.active, \"ui-accordion-header-collapsed\" );\n            this._addClass( this.active.next(), \"ui-accordion-content-active\" );\n            this.active.next().show();\n\n            this.headers\n                .attr( \"role\", \"tab\" )\n                .each( function() {\n                    var header = $( this ),\n                        headerId = header.uniqueId().attr( \"id\" ),\n                        panel = header.next(),\n                        panelId = panel.uniqueId().attr( \"id\" );\n                    header.attr( \"aria-controls\", panelId );\n                    panel.attr( \"aria-labelledby\", headerId );\n                } )\n                .next()\n                .attr( \"role\", \"tabpanel\" );\n\n            this.headers\n                .not( this.active )\n                .attr( {\n                    \"aria-selected\": \"false\",\n                    \"aria-expanded\": \"false\",\n                    tabIndex: -1\n                } )\n                .next()\n                .attr( {\n                    \"aria-hidden\": \"true\"\n                } )\n                .hide();\n\n            // Make sure at least one header is in the tab order\n            if ( !this.active.length ) {\n                this.headers.eq( 0 ).attr( \"tabIndex\", 0 );\n            } else {\n                this.active.attr( {\n                    \"aria-selected\": \"true\",\n                    \"aria-expanded\": \"true\",\n                    tabIndex: 0\n                } )\n                    .next()\n                    .attr( {\n                        \"aria-hidden\": \"false\"\n                    } );\n            }\n\n            this._createIcons();\n\n            this._setupEvents( options.event );\n\n            if ( heightStyle === \"fill\" ) {\n                maxHeight = parent.height();\n                this.element.siblings( \":visible\" ).each( function() {\n                    var elem = $( this ),\n                        position = elem.css( \"position\" );\n\n                    if ( position === \"absolute\" || position === \"fixed\" ) {\n                        return;\n                    }\n                    maxHeight -= elem.outerHeight( true );\n                } );\n\n                this.headers.each( function() {\n                    maxHeight -= $( this ).outerHeight( true );\n                } );\n\n                this.headers.next()\n                    .each( function() {\n                        $( this ).height( Math.max( 0, maxHeight -\n                            $( this ).innerHeight() + $( this ).height() ) );\n                    } )\n                    .css( \"overflow\", \"auto\" );\n            } else if ( heightStyle === \"auto\" ) {\n                maxHeight = 0;\n                this.headers.next()\n                    .each( function() {\n                        var isVisible = $( this ).is( \":visible\" );\n                        if ( !isVisible ) {\n                            $( this ).show();\n                        }\n                        maxHeight = Math.max( maxHeight, $( this ).css( \"height\", \"\" ).height() );\n                        if ( !isVisible ) {\n                            $( this ).hide();\n                        }\n                    } )\n                    .height( maxHeight );\n            }\n        },\n\n        _activate: function( index ) {\n            var active = this._findActive( index )[ 0 ];\n\n            // Trying to activate the already active panel\n            if ( active === this.active[ 0 ] ) {\n                return;\n            }\n\n            // Trying to collapse, simulate a click on the currently active header\n            active = active || this.active[ 0 ];\n\n            this._eventHandler( {\n                target: active,\n                currentTarget: active,\n                preventDefault: $.noop\n            } );\n        },\n\n        _findActive: function( selector ) {\n            return typeof selector === \"number\" ? this.headers.eq( selector ) : $();\n        },\n\n        _setupEvents: function( event ) {\n            var events = {\n                keydown: \"_keydown\"\n            };\n            if ( event ) {\n                $.each( event.split( \" \" ), function( index, eventName ) {\n                    events[ eventName ] = \"_eventHandler\";\n                } );\n            }\n\n            this._off( this.headers.add( this.headers.next() ) );\n            this._on( this.headers, events );\n            this._on( this.headers.next(), { keydown: \"_panelKeyDown\" } );\n            this._hoverable( this.headers );\n            this._focusable( this.headers );\n        },\n\n        _eventHandler: function( event ) {\n            var activeChildren, clickedChildren,\n                options = this.options,\n                active = this.active,\n                clicked = $( event.currentTarget ),\n                clickedIsActive = clicked[ 0 ] === active[ 0 ],\n                collapsing = clickedIsActive && options.collapsible,\n                toShow = collapsing ? $() : clicked.next(),\n                toHide = active.next(),\n                eventData = {\n                    oldHeader: active,\n                    oldPanel: toHide,\n                    newHeader: collapsing ? $() : clicked,\n                    newPanel: toShow\n                };\n\n            event.preventDefault();\n\n            if (\n\n                // click on active header, but not collapsible\n                ( clickedIsActive && !options.collapsible ) ||\n\n                // allow canceling activation\n                ( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n                return;\n            }\n\n            options.active = collapsing ? false : this.headers.index( clicked );\n\n            // When the call to ._toggle() comes after the class changes\n            // it causes a very odd bug in IE 8 (see #6720)\n            this.active = clickedIsActive ? $() : clicked;\n            this._toggle( eventData );\n\n            // Switch classes\n            // corner classes on the previously active header stay after the animation\n            this._removeClass( active, \"ui-accordion-header-active\", \"ui-state-active\" );\n            if ( options.icons ) {\n                activeChildren = active.children( \".ui-accordion-header-icon\" );\n                this._removeClass( activeChildren, null, options.icons.activeHeader )\n                    ._addClass( activeChildren, null, options.icons.header );\n            }\n\n            if ( !clickedIsActive ) {\n                this._removeClass( clicked, \"ui-accordion-header-collapsed\" )\n                    ._addClass( clicked, \"ui-accordion-header-active\", \"ui-state-active\" );\n                if ( options.icons ) {\n                    clickedChildren = clicked.children( \".ui-accordion-header-icon\" );\n                    this._removeClass( clickedChildren, null, options.icons.header )\n                        ._addClass( clickedChildren, null, options.icons.activeHeader );\n                }\n\n                this._addClass( clicked.next(), \"ui-accordion-content-active\" );\n            }\n        },\n\n        _toggle: function( data ) {\n            var toShow = data.newPanel,\n                toHide = this.prevShow.length ? this.prevShow : data.oldPanel;\n\n            // Handle activating a panel during the animation for another activation\n            this.prevShow.add( this.prevHide ).stop( true, true );\n            this.prevShow = toShow;\n            this.prevHide = toHide;\n\n            if ( this.options.animate ) {\n                this._animate( toShow, toHide, data );\n            } else {\n                toHide.hide();\n                toShow.show();\n                this._toggleComplete( data );\n            }\n\n            toHide.attr( {\n                \"aria-hidden\": \"true\"\n            } );\n            toHide.prev().attr( {\n                \"aria-selected\": \"false\",\n                \"aria-expanded\": \"false\"\n            } );\n\n            // if we're switching panels, remove the old header from the tab order\n            // if we're opening from collapsed state, remove the previous header from the tab order\n            // if we're collapsing, then keep the collapsing header in the tab order\n            if ( toShow.length && toHide.length ) {\n                toHide.prev().attr( {\n                    \"tabIndex\": -1,\n                    \"aria-expanded\": \"false\"\n                } );\n            } else if ( toShow.length ) {\n                this.headers.filter( function() {\n                    return parseInt( $( this ).attr( \"tabIndex\" ), 10 ) === 0;\n                } )\n                    .attr( \"tabIndex\", -1 );\n            }\n\n            toShow\n                .attr( \"aria-hidden\", \"false\" )\n                .prev()\n                .attr( {\n                    \"aria-selected\": \"true\",\n                    \"aria-expanded\": \"true\",\n                    tabIndex: 0\n                } );\n        },\n\n        _animate: function( toShow, toHide, data ) {\n            var total, easing, duration,\n                that = this,\n                adjust = 0,\n                boxSizing = toShow.css( \"box-sizing\" ),\n                down = toShow.length &&\n                    ( !toHide.length || ( toShow.index() < toHide.index() ) ),\n                animate = this.options.animate || {},\n                options = down && animate.down || animate,\n                complete = function() {\n                    that._toggleComplete( data );\n                };\n\n            if ( typeof options === \"number\" ) {\n                duration = options;\n            }\n            if ( typeof options === \"string\" ) {\n                easing = options;\n            }\n\n            // fall back from options to animation in case of partial down settings\n            easing = easing || options.easing || animate.easing;\n            duration = duration || options.duration || animate.duration;\n\n            if ( !toHide.length ) {\n                return toShow.animate( this.showProps, duration, easing, complete );\n            }\n            if ( !toShow.length ) {\n                return toHide.animate( this.hideProps, duration, easing, complete );\n            }\n\n            total = toShow.show().outerHeight();\n            toHide.animate( this.hideProps, {\n                duration: duration,\n                easing: easing,\n                step: function( now, fx ) {\n                    fx.now = Math.round( now );\n                }\n            } );\n            toShow\n                .hide()\n                .animate( this.showProps, {\n                    duration: duration,\n                    easing: easing,\n                    complete: complete,\n                    step: function( now, fx ) {\n                        fx.now = Math.round( now );\n                        if ( fx.prop !== \"height\" ) {\n                            if ( boxSizing === \"content-box\" ) {\n                                adjust += fx.now;\n                            }\n                        } else if ( that.options.heightStyle !== \"content\" ) {\n                            fx.now = Math.round( total - toHide.outerHeight() - adjust );\n                            adjust = 0;\n                        }\n                    }\n                } );\n        },\n\n        _toggleComplete: function( data ) {\n            var toHide = data.oldPanel,\n                prev = toHide.prev();\n\n            this._removeClass( toHide, \"ui-accordion-content-active\" );\n            this._removeClass( prev, \"ui-accordion-header-active\" )\n                ._addClass( prev, \"ui-accordion-header-collapsed\" );\n\n            // Work around for rendering bug in IE (#5421)\n            if ( toHide.length ) {\n                toHide.parent()[ 0 ].className = toHide.parent()[ 0 ].className;\n            }\n            this._trigger( \"activate\", null, data );\n        }\n    } );\n\n} );\n","jquery/ui-modules/vendor/jquery-color/jquery.color.js":"/*!\n * jQuery Color Animations v2.2.0\n * https://github.com/jquery/jquery-color\n *\n * Copyright OpenJS Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * Date: Sun May 10 09:02:36 2020 +0200\n */\n\n( function( root, factory ) {\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\" ], factory );\n\t} else if ( typeof exports === \"object\" ) {\n\t\tmodule.exports = factory( require( \"jquery\" ) );\n\t} else {\n\t\tfactory( root.jQuery );\n\t}\n} )( this, function( jQuery, undefined ) {\n\n\tvar stepHooks = \"backgroundColor borderBottomColor borderLeftColor borderRightColor \" +\n\t\t\"borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor\",\n\n\tclass2type = {},\n\ttoString = class2type.toString,\n\n\t// plusequals test for += 100 -= 100\n\trplusequals = /^([\\-+])=\\s*(\\d+\\.?\\d*)/,\n\n\t// a set of RE's that can match strings and generate color tuples.\n\tstringParsers = [ {\n\t\t\tre: /rgba?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ],\n\t\t\t\t\texecResult[ 3 ],\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /rgba?\\(\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ] * 2.55,\n\t\t\t\t\texecResult[ 2 ] * 2.55,\n\t\t\t\t\texecResult[ 3 ] * 2.55,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ], 16 ),\n\t\t\t\t\texecResult[ 4 ] ?\n\t\t\t\t\t\t( parseInt( execResult[ 4 ], 16 ) / 255 ).toFixed( 2 ) :\n\t\t\t\t\t\t1\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ] + execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ] + execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ] + execResult[ 3 ], 16 ),\n\t\t\t\t\texecResult[ 4 ] ?\n\t\t\t\t\t\t( parseInt( execResult[ 4 ] + execResult[ 4 ], 16 ) / 255 )\n\t\t\t\t\t\t\t.toFixed( 2 ) :\n\t\t\t\t\t\t1\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /hsla?\\(\\s*(\\d+(?:\\.\\d+)?)\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tspace: \"hsla\",\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ] / 100,\n\t\t\t\t\texecResult[ 3 ] / 100,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t} ],\n\n\t// jQuery.Color( )\n\tcolor = jQuery.Color = function( color, green, blue, alpha ) {\n\t\treturn new jQuery.Color.fn.parse( color, green, blue, alpha );\n\t},\n\tspaces = {\n\t\trgba: {\n\t\t\tprops: {\n\t\t\t\tred: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tgreen: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tblue: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\thsla: {\n\t\t\tprops: {\n\t\t\t\thue: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"degrees\"\n\t\t\t\t},\n\t\t\t\tsaturation: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t},\n\t\t\t\tlightness: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\tpropTypes = {\n\t\t\"byte\": {\n\t\t\tfloor: true,\n\t\t\tmax: 255\n\t\t},\n\t\t\"percent\": {\n\t\t\tmax: 1\n\t\t},\n\t\t\"degrees\": {\n\t\t\tmod: 360,\n\t\t\tfloor: true\n\t\t}\n\t},\n\tsupport = color.support = {},\n\n\t// element for support tests\n\tsupportElem = jQuery( \"<p>\" )[ 0 ],\n\n\t// colors = jQuery.Color.names\n\tcolors,\n\n\t// local aliases of functions called often\n\teach = jQuery.each;\n\n// determine rgba support immediately\nsupportElem.style.cssText = \"background-color:rgba(1,1,1,.5)\";\nsupport.rgba = supportElem.style.backgroundColor.indexOf( \"rgba\" ) > -1;\n\n// define cache name and alpha properties\n// for rgba and hsla spaces\neach( spaces, function( spaceName, space ) {\n\tspace.cache = \"_\" + spaceName;\n\tspace.props.alpha = {\n\t\tidx: 3,\n\t\ttype: \"percent\",\n\t\tdef: 1\n\t};\n} );\n\n// Populate the class2type map\njQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n\tfunction( _i, name ) {\n\t\tclass2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n\t} );\n\nfunction getType( obj ) {\n\tif ( obj == null ) {\n\t\treturn obj + \"\";\n\t}\n\n\treturn typeof obj === \"object\" ?\n\t\tclass2type[ toString.call( obj ) ] || \"object\" :\n\t\ttypeof obj;\n}\n\nfunction clamp( value, prop, allowEmpty ) {\n\tvar type = propTypes[ prop.type ] || {};\n\n\tif ( value == null ) {\n\t\treturn ( allowEmpty || !prop.def ) ? null : prop.def;\n\t}\n\n\t// ~~ is an short way of doing floor for positive numbers\n\tvalue = type.floor ? ~~value : parseFloat( value );\n\n\t// IE will pass in empty strings as value for alpha,\n\t// which will hit this case\n\tif ( isNaN( value ) ) {\n\t\treturn prop.def;\n\t}\n\n\tif ( type.mod ) {\n\n\t\t// we add mod before modding to make sure that negatives values\n\t\t// get converted properly: -10 -> 350\n\t\treturn ( value + type.mod ) % type.mod;\n\t}\n\n\t// for now all property types without mod have min and max\n\treturn Math.min( type.max, Math.max( 0, value ) );\n}\n\nfunction stringParse( string ) {\n\tvar inst = color(),\n\t\trgba = inst._rgba = [];\n\n\tstring = string.toLowerCase();\n\n\teach( stringParsers, function( _i, parser ) {\n\t\tvar parsed,\n\t\t\tmatch = parser.re.exec( string ),\n\t\t\tvalues = match && parser.parse( match ),\n\t\t\tspaceName = parser.space || \"rgba\";\n\n\t\tif ( values ) {\n\t\t\tparsed = inst[ spaceName ]( values );\n\n\t\t\t// if this was an rgba parse the assignment might happen twice\n\t\t\t// oh well....\n\t\t\tinst[ spaces[ spaceName ].cache ] = parsed[ spaces[ spaceName ].cache ];\n\t\t\trgba = inst._rgba = parsed._rgba;\n\n\t\t\t// exit each( stringParsers ) here because we matched\n\t\t\treturn false;\n\t\t}\n\t} );\n\n\t// Found a stringParser that handled it\n\tif ( rgba.length ) {\n\n\t\t// if this came from a parsed string, force \"transparent\" when alpha is 0\n\t\t// chrome, (and maybe others) return \"transparent\" as rgba(0,0,0,0)\n\t\tif ( rgba.join() === \"0,0,0,0\" ) {\n\t\t\tjQuery.extend( rgba, colors.transparent );\n\t\t}\n\t\treturn inst;\n\t}\n\n\t// named colors\n\treturn colors[ string ];\n}\n\ncolor.fn = jQuery.extend( color.prototype, {\n\tparse: function( red, green, blue, alpha ) {\n\t\tif ( red === undefined ) {\n\t\t\tthis._rgba = [ null, null, null, null ];\n\t\t\treturn this;\n\t\t}\n\t\tif ( red.jquery || red.nodeType ) {\n\t\t\tred = jQuery( red ).css( green );\n\t\t\tgreen = undefined;\n\t\t}\n\n\t\tvar inst = this,\n\t\t\ttype = getType( red ),\n\t\t\trgba = this._rgba = [];\n\n\t\t// more than 1 argument specified - assume ( red, green, blue, alpha )\n\t\tif ( green !== undefined ) {\n\t\t\tred = [ red, green, blue, alpha ];\n\t\t\ttype = \"array\";\n\t\t}\n\n\t\tif ( type === \"string\" ) {\n\t\t\treturn this.parse( stringParse( red ) || colors._default );\n\t\t}\n\n\t\tif ( type === \"array\" ) {\n\t\t\teach( spaces.rgba.props, function( _key, prop ) {\n\t\t\t\trgba[ prop.idx ] = clamp( red[ prop.idx ], prop );\n\t\t\t} );\n\t\t\treturn this;\n\t\t}\n\n\t\tif ( type === \"object\" ) {\n\t\t\tif ( red instanceof color ) {\n\t\t\t\teach( spaces, function( _spaceName, space ) {\n\t\t\t\t\tif ( red[ space.cache ] ) {\n\t\t\t\t\t\tinst[ space.cache ] = red[ space.cache ].slice();\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t} else {\n\t\t\t\teach( spaces, function( _spaceName, space ) {\n\t\t\t\t\tvar cache = space.cache;\n\t\t\t\t\teach( space.props, function( key, prop ) {\n\n\t\t\t\t\t\t// if the cache doesn't exist, and we know how to convert\n\t\t\t\t\t\tif ( !inst[ cache ] && space.to ) {\n\n\t\t\t\t\t\t\t// if the value was null, we don't need to copy it\n\t\t\t\t\t\t\t// if the key was alpha, we don't need to copy it either\n\t\t\t\t\t\t\tif ( key === \"alpha\" || red[ key ] == null ) {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tinst[ cache ] = space.to( inst._rgba );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// this is the only case where we allow nulls for ALL properties.\n\t\t\t\t\t\t// call clamp with alwaysAllowEmpty\n\t\t\t\t\t\tinst[ cache ][ prop.idx ] = clamp( red[ key ], prop, true );\n\t\t\t\t\t} );\n\n\t\t\t\t\t// everything defined but alpha?\n\t\t\t\t\tif ( inst[ cache ] && jQuery.inArray( null, inst[ cache ].slice( 0, 3 ) ) < 0 ) {\n\n\t\t\t\t\t\t// use the default of 1\n\t\t\t\t\t\tif ( inst[ cache ][ 3 ] == null ) {\n\t\t\t\t\t\t\tinst[ cache ][ 3 ] = 1;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( space.from ) {\n\t\t\t\t\t\t\tinst._rgba = space.from( inst[ cache ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t},\n\tis: function( compare ) {\n\t\tvar is = color( compare ),\n\t\t\tsame = true,\n\t\t\tinst = this;\n\n\t\teach( spaces, function( _, space ) {\n\t\t\tvar localCache,\n\t\t\t\tisCache = is[ space.cache ];\n\t\t\tif ( isCache ) {\n\t\t\t\tlocalCache = inst[ space.cache ] || space.to && space.to( inst._rgba ) || [];\n\t\t\t\teach( space.props, function( _, prop ) {\n\t\t\t\t\tif ( isCache[ prop.idx ] != null ) {\n\t\t\t\t\t\tsame = ( isCache[ prop.idx ] === localCache[ prop.idx ] );\n\t\t\t\t\t\treturn same;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn same;\n\t\t} );\n\t\treturn same;\n\t},\n\t_space: function() {\n\t\tvar used = [],\n\t\t\tinst = this;\n\t\teach( spaces, function( spaceName, space ) {\n\t\t\tif ( inst[ space.cache ] ) {\n\t\t\t\tused.push( spaceName );\n\t\t\t}\n\t\t} );\n\t\treturn used.pop();\n\t},\n\ttransition: function( other, distance ) {\n\t\tvar end = color( other ),\n\t\t\tspaceName = end._space(),\n\t\t\tspace = spaces[ spaceName ],\n\t\t\tstartColor = this.alpha() === 0 ? color( \"transparent\" ) : this,\n\t\t\tstart = startColor[ space.cache ] || space.to( startColor._rgba ),\n\t\t\tresult = start.slice();\n\n\t\tend = end[ space.cache ];\n\t\teach( space.props, function( _key, prop ) {\n\t\t\tvar index = prop.idx,\n\t\t\t\tstartValue = start[ index ],\n\t\t\t\tendValue = end[ index ],\n\t\t\t\ttype = propTypes[ prop.type ] || {};\n\n\t\t\t// if null, don't override start value\n\t\t\tif ( endValue === null ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// if null - use end\n\t\t\tif ( startValue === null ) {\n\t\t\t\tresult[ index ] = endValue;\n\t\t\t} else {\n\t\t\t\tif ( type.mod ) {\n\t\t\t\t\tif ( endValue - startValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue += type.mod;\n\t\t\t\t\t} else if ( startValue - endValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue -= type.mod;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tresult[ index ] = clamp( ( endValue - startValue ) * distance + startValue, prop );\n\t\t\t}\n\t\t} );\n\t\treturn this[ spaceName ]( result );\n\t},\n\tblend: function( opaque ) {\n\n\t\t// if we are already opaque - return ourself\n\t\tif ( this._rgba[ 3 ] === 1 ) {\n\t\t\treturn this;\n\t\t}\n\n\t\tvar rgb = this._rgba.slice(),\n\t\t\ta = rgb.pop(),\n\t\t\tblend = color( opaque )._rgba;\n\n\t\treturn color( jQuery.map( rgb, function( v, i ) {\n\t\t\treturn ( 1 - a ) * blend[ i ] + a * v;\n\t\t} ) );\n\t},\n\ttoRgbaString: function() {\n\t\tvar prefix = \"rgba(\",\n\t\t\trgba = jQuery.map( this._rgba, function( v, i ) {\n\t\t\t\tif ( v != null ) {\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\t\t\t\treturn i > 2 ? 1 : 0;\n\t\t\t} );\n\n\t\tif ( rgba[ 3 ] === 1 ) {\n\t\t\trgba.pop();\n\t\t\tprefix = \"rgb(\";\n\t\t}\n\n\t\treturn prefix + rgba.join() + \")\";\n\t},\n\ttoHslaString: function() {\n\t\tvar prefix = \"hsla(\",\n\t\t\thsla = jQuery.map( this.hsla(), function( v, i ) {\n\t\t\t\tif ( v == null ) {\n\t\t\t\t\tv = i > 2 ? 1 : 0;\n\t\t\t\t}\n\n\t\t\t\t// catch 1 and 2\n\t\t\t\tif ( i && i < 3 ) {\n\t\t\t\t\tv = Math.round( v * 100 ) + \"%\";\n\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t} );\n\n\t\tif ( hsla[ 3 ] === 1 ) {\n\t\t\thsla.pop();\n\t\t\tprefix = \"hsl(\";\n\t\t}\n\t\treturn prefix + hsla.join() + \")\";\n\t},\n\ttoHexString: function( includeAlpha ) {\n\t\tvar rgba = this._rgba.slice(),\n\t\t\talpha = rgba.pop();\n\n\t\tif ( includeAlpha ) {\n\t\t\trgba.push( ~~( alpha * 255 ) );\n\t\t}\n\n\t\treturn \"#\" + jQuery.map( rgba, function( v ) {\n\n\t\t\t// default to 0 when nulls exist\n\t\t\tv = ( v || 0 ).toString( 16 );\n\t\t\treturn v.length === 1 ? \"0\" + v : v;\n\t\t} ).join( \"\" );\n\t},\n\ttoString: function() {\n\t\treturn this._rgba[ 3 ] === 0 ? \"transparent\" : this.toRgbaString();\n\t}\n} );\ncolor.fn.parse.prototype = color.fn;\n\n// hsla conversions adapted from:\n// https://code.google.com/p/maashaack/source/browse/packages/graphics/trunk/src/graphics/colors/HUE2RGB.as?r=5021\n\nfunction hue2rgb( p, q, h ) {\n\th = ( h + 1 ) % 1;\n\tif ( h * 6 < 1 ) {\n\t\treturn p + ( q - p ) * h * 6;\n\t}\n\tif ( h * 2 < 1 ) {\n\t\treturn q;\n\t}\n\tif ( h * 3 < 2 ) {\n\t\treturn p + ( q - p ) * ( ( 2 / 3 ) - h ) * 6;\n\t}\n\treturn p;\n}\n\nspaces.hsla.to = function( rgba ) {\n\tif ( rgba[ 0 ] == null || rgba[ 1 ] == null || rgba[ 2 ] == null ) {\n\t\treturn [ null, null, null, rgba[ 3 ] ];\n\t}\n\tvar r = rgba[ 0 ] / 255,\n\t\tg = rgba[ 1 ] / 255,\n\t\tb = rgba[ 2 ] / 255,\n\t\ta = rgba[ 3 ],\n\t\tmax = Math.max( r, g, b ),\n\t\tmin = Math.min( r, g, b ),\n\t\tdiff = max - min,\n\t\tadd = max + min,\n\t\tl = add * 0.5,\n\t\th, s;\n\n\tif ( min === max ) {\n\t\th = 0;\n\t} else if ( r === max ) {\n\t\th = ( 60 * ( g - b ) / diff ) + 360;\n\t} else if ( g === max ) {\n\t\th = ( 60 * ( b - r ) / diff ) + 120;\n\t} else {\n\t\th = ( 60 * ( r - g ) / diff ) + 240;\n\t}\n\n\t// chroma (diff) == 0 means greyscale which, by definition, saturation = 0%\n\t// otherwise, saturation is based on the ratio of chroma (diff) to lightness (add)\n\tif ( diff === 0 ) {\n\t\ts = 0;\n\t} else if ( l <= 0.5 ) {\n\t\ts = diff / add;\n\t} else {\n\t\ts = diff / ( 2 - add );\n\t}\n\treturn [ Math.round( h ) % 360, s, l, a == null ? 1 : a ];\n};\n\nspaces.hsla.from = function( hsla ) {\n\tif ( hsla[ 0 ] == null || hsla[ 1 ] == null || hsla[ 2 ] == null ) {\n\t\treturn [ null, null, null, hsla[ 3 ] ];\n\t}\n\tvar h = hsla[ 0 ] / 360,\n\t\ts = hsla[ 1 ],\n\t\tl = hsla[ 2 ],\n\t\ta = hsla[ 3 ],\n\t\tq = l <= 0.5 ? l * ( 1 + s ) : l + s - l * s,\n\t\tp = 2 * l - q;\n\n\treturn [\n\t\tMath.round( hue2rgb( p, q, h + ( 1 / 3 ) ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h - ( 1 / 3 ) ) * 255 ),\n\t\ta\n\t];\n};\n\n\neach( spaces, function( spaceName, space ) {\n\tvar props = space.props,\n\t\tcache = space.cache,\n\t\tto = space.to,\n\t\tfrom = space.from;\n\n\t// makes rgba() and hsla()\n\tcolor.fn[ spaceName ] = function( value ) {\n\n\t\t// generate a cache for this space if it doesn't exist\n\t\tif ( to && !this[ cache ] ) {\n\t\t\tthis[ cache ] = to( this._rgba );\n\t\t}\n\t\tif ( value === undefined ) {\n\t\t\treturn this[ cache ].slice();\n\t\t}\n\n\t\tvar ret,\n\t\t\ttype = getType( value ),\n\t\t\tarr = ( type === \"array\" || type === \"object\" ) ? value : arguments,\n\t\t\tlocal = this[ cache ].slice();\n\n\t\teach( props, function( key, prop ) {\n\t\t\tvar val = arr[ type === \"object\" ? key : prop.idx ];\n\t\t\tif ( val == null ) {\n\t\t\t\tval = local[ prop.idx ];\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = clamp( val, prop );\n\t\t} );\n\n\t\tif ( from ) {\n\t\t\tret = color( from( local ) );\n\t\t\tret[ cache ] = local;\n\t\t\treturn ret;\n\t\t} else {\n\t\t\treturn color( local );\n\t\t}\n\t};\n\n\t// makes red() green() blue() alpha() hue() saturation() lightness()\n\teach( props, function( key, prop ) {\n\n\t\t// alpha is included in more than one space\n\t\tif ( color.fn[ key ] ) {\n\t\t\treturn;\n\t\t}\n\t\tcolor.fn[ key ] = function( value ) {\n\t\t\tvar local, cur, match, fn,\n\t\t\t\tvtype = getType( value );\n\n\t\t\tif ( key === \"alpha\" ) {\n\t\t\t\tfn = this._hsla ? \"hsla\" : \"rgba\";\n\t\t\t} else {\n\t\t\t\tfn = spaceName;\n\t\t\t}\n\t\t\tlocal = this[ fn ]();\n\t\t\tcur = local[ prop.idx ];\n\n\t\t\tif ( vtype === \"undefined\" ) {\n\t\t\t\treturn cur;\n\t\t\t}\n\n\t\t\tif ( vtype === \"function\" ) {\n\t\t\t\tvalue = value.call( this, cur );\n\t\t\t\tvtype = getType( value );\n\t\t\t}\n\t\t\tif ( value == null && prop.empty ) {\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( vtype === \"string\" ) {\n\t\t\t\tmatch = rplusequals.exec( value );\n\t\t\t\tif ( match ) {\n\t\t\t\t\tvalue = cur + parseFloat( match[ 2 ] ) * ( match[ 1 ] === \"+\" ? 1 : -1 );\n\t\t\t\t}\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = value;\n\t\t\treturn this[ fn ]( local );\n\t\t};\n\t} );\n} );\n\n// add cssHook and .fx.step function for each named hook.\n// accept a space separated string of properties\ncolor.hook = function( hook ) {\n\tvar hooks = hook.split( \" \" );\n\teach( hooks, function( _i, hook ) {\n\t\tjQuery.cssHooks[ hook ] = {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tvar parsed, curElem,\n\t\t\t\t\tbackgroundColor = \"\";\n\n\t\t\t\tif ( value !== \"transparent\" && ( getType( value ) !== \"string\" || ( parsed = stringParse( value ) ) ) ) {\n\t\t\t\t\tvalue = color( parsed || value );\n\t\t\t\t\tif ( !support.rgba && value._rgba[ 3 ] !== 1 ) {\n\t\t\t\t\t\tcurElem = hook === \"backgroundColor\" ? elem.parentNode : elem;\n\t\t\t\t\t\twhile (\n\t\t\t\t\t\t\t( backgroundColor === \"\" || backgroundColor === \"transparent\" ) &&\n\t\t\t\t\t\t\tcurElem && curElem.style\n\t\t\t\t\t\t) {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tbackgroundColor = jQuery.css( curElem, \"backgroundColor\" );\n\t\t\t\t\t\t\t\tcurElem = curElem.parentNode;\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvalue = value.blend( backgroundColor && backgroundColor !== \"transparent\" ?\n\t\t\t\t\t\t\tbackgroundColor :\n\t\t\t\t\t\t\t\"_default\" );\n\t\t\t\t\t}\n\n\t\t\t\t\tvalue = value.toRgbaString();\n\t\t\t\t}\n\t\t\t\ttry {\n\t\t\t\t\telem.style[ hook ] = value;\n\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t// wrapped to prevent IE from throwing errors on \"invalid\" values like 'auto' or 'inherit'\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t\tjQuery.fx.step[ hook ] = function( fx ) {\n\t\t\tif ( !fx.colorInit ) {\n\t\t\t\tfx.start = color( fx.elem, hook );\n\t\t\t\tfx.end = color( fx.end );\n\t\t\t\tfx.colorInit = true;\n\t\t\t}\n\t\t\tjQuery.cssHooks[ hook ].set( fx.elem, fx.start.transition( fx.end, fx.pos ) );\n\t\t};\n\t} );\n\n};\n\ncolor.hook( stepHooks );\n\njQuery.cssHooks.borderColor = {\n\texpand: function( value ) {\n\t\tvar expanded = {};\n\n\t\teach( [ \"Top\", \"Right\", \"Bottom\", \"Left\" ], function( _i, part ) {\n\t\t\texpanded[ \"border\" + part + \"Color\" ] = value;\n\t\t} );\n\t\treturn expanded;\n\t}\n};\n\n// Basic color names only.\n// Usage of any of the other color names requires adding yourself or including\n// jquery.color.svg-names.js.\ncolors = jQuery.Color.names = {\n\n\t// 4.1. Basic color keywords\n\taqua: \"#00ffff\",\n\tblack: \"#000000\",\n\tblue: \"#0000ff\",\n\tfuchsia: \"#ff00ff\",\n\tgray: \"#808080\",\n\tgreen: \"#008000\",\n\tlime: \"#00ff00\",\n\tmaroon: \"#800000\",\n\tnavy: \"#000080\",\n\tolive: \"#808000\",\n\tpurple: \"#800080\",\n\tred: \"#ff0000\",\n\tsilver: \"#c0c0c0\",\n\tteal: \"#008080\",\n\twhite: \"#ffffff\",\n\tyellow: \"#ffff00\",\n\n\t// 4.2.3. \"transparent\" color keyword\n\ttransparent: [ null, null, null, 0 ],\n\n\t_default: \"#ffffff\"\n};\n\n} );\n","jquery/patches/jquery-ui-sortable.js":"/*!\n * jQuery UI Sortable\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Patch for sortable widget.\n     * Can safely remove only when jQuery UI is upgraded to >= 1.13.1.\n     * Fixes:\n     * https://github.com/jquery/jquery-ui/pull/2008\n     * https://github.com/jquery/jquery-ui/pull/2009\n     */\n    var sortablePatch = {\n        /** @inheritdoc */\n        _mouseDrag: function (event) {\n            var i, item, itemElement, intersection,\n                o = this.options;\n\n            //Compute the helpers position\n            this.position = this._generatePosition(event);\n            this.positionAbs = this._convertPositionTo(\"absolute\");\n\n            //Set the helper position\n            if (!this.options.axis || this.options.axis !== \"y\") {\n                this.helper[0].style.left = this.position.left + \"px\";\n            }\n            if (!this.options.axis || this.options.axis !== \"x\") {\n                this.helper[0].style.top = this.position.top + \"px\";\n            }\n\n            //Do scrolling\n            if (o.scroll) {\n                if (this._scroll(event) !== false) {\n\n                    //Update item positions used in position checks\n                    this._refreshItemPositions(true);\n\n                    if ($.ui.ddmanager && !o.dropBehaviour) {\n                        $.ui.ddmanager.prepareOffsets(this, event);\n                    }\n                }\n            }\n\n            this.dragDirection = {\n                vertical: this._getDragVerticalDirection(),\n                horizontal: this._getDragHorizontalDirection()\n            };\n\n            //Rearrange\n            for (i = this.items.length - 1; i >= 0; i--) {\n\n                //Cache variables and intersection, continue if no intersection\n                item = this.items[i];\n                itemElement = item.item[0];\n                intersection = this._intersectsWithPointer(item);\n                if (!intersection) {\n                    continue;\n                }\n\n                // Only put the placeholder inside the current Container, skip all\n                // items from other containers. This works because when moving\n                // an item from one container to another the\n                // currentContainer is switched before the placeholder is moved.\n                //\n                // Without this, moving items in \"sub-sortables\" can cause\n                // the placeholder to jitter between the outer and inner container.\n                if (item.instance !== this.currentContainer) {\n                    continue;\n                }\n\n                // Cannot intersect with itself\n                // no useless actions that have been done before\n                // no action if the item moved is the parent of the item checked\n                if (itemElement !== this.currentItem[0] &&\n                    this.placeholder[intersection === 1 ?\n                        \"next\" : \"prev\"]()[0] !== itemElement &&\n                    !$.contains(this.placeholder[0], itemElement) &&\n                    (this.options.type === \"semi-dynamic\" ?\n                            !$.contains(this.element[0], itemElement) :\n                            true\n                    )\n                ) {\n\n                    this.direction = intersection === 1 ? \"down\" : \"up\";\n\n                    if (this.options.tolerance === \"pointer\" ||\n                        this._intersectsWithSides(item)) {\n                        this._rearrange(event, item);\n                    } else {\n                        break;\n                    }\n\n                    this._trigger(\"change\", event, this._uiHash());\n                    break;\n                }\n            }\n\n            //Post events to containers\n            this._contactContainers(event);\n\n            //Interconnect with droppables\n            if ($.ui.ddmanager) {\n                $.ui.ddmanager.drag(this, event);\n            }\n\n            //Call callbacks\n            this._trigger(\"sort\", event, this._uiHash());\n\n            this.lastPositionAbs = this.positionAbs;\n            return false;\n\n        },\n\n        /** @inheritdoc */\n        refreshPositions: function (fast) {\n\n            // Determine whether items are being displayed horizontally\n            this.floating = this.items.length ?\n                this.options.axis === \"x\" || this._isFloating(this.items[0].item) :\n                false;\n\n            // This has to be redone because due to the item being moved out/into the offsetParent,\n            // the offsetParent's position will change\n            if (this.offsetParent && this.helper) {\n                this.offset.parent = this._getParentOffset();\n            }\n\n            this._refreshItemPositions(fast);\n\n            var i, p;\n\n            if (this.options.custom && this.options.custom.refreshContainers) {\n                this.options.custom.refreshContainers.call(this);\n            } else {\n                for (i = this.containers.length - 1; i >= 0; i--) {\n                    p = this.containers[i].element.offset();\n                    this.containers[i].containerCache.left = p.left;\n                    this.containers[i].containerCache.top = p.top;\n                    this.containers[i].containerCache.width =\n                        this.containers[i].element.outerWidth();\n                    this.containers[i].containerCache.height =\n                        this.containers[i].element.outerHeight();\n                }\n            }\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        _contactContainers: function (event) {\n            var i, j, dist, itemWithLeastDistance, posProperty, sizeProperty, cur, nearBottom,\n                floating, axis,\n                innermostContainer = null,\n                innermostIndex = null;\n\n            // Get innermost container that intersects with item\n            for (i = this.containers.length - 1; i >= 0; i--) {\n\n                // Never consider a container that's located within the item itself\n                if ($.contains(this.currentItem[0], this.containers[i].element[0])) {\n                    continue;\n                }\n\n                if (this._intersectsWith(this.containers[i].containerCache)) {\n\n                    // If we've already found a container and it's more \"inner\" than this, then continue\n                    if (innermostContainer &&\n                        $.contains(\n                            this.containers[i].element[0],\n                            innermostContainer.element[0])) {\n                        continue;\n                    }\n\n                    innermostContainer = this.containers[i];\n                    innermostIndex = i;\n\n                } else {\n\n                    // container doesn't intersect. trigger \"out\" event if necessary\n                    if (this.containers[i].containerCache.over) {\n                        this.containers[i]._trigger(\"out\", event, this._uiHash(this));\n                        this.containers[i].containerCache.over = 0;\n                    }\n                }\n\n            }\n\n            // If no intersecting containers found, return\n            if (!innermostContainer) {\n                return;\n            }\n\n            // Move the item into the container if it's not there already\n            if (this.containers.length === 1) {\n                if (!this.containers[innermostIndex].containerCache.over) {\n                    this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash(this));\n                    this.containers[innermostIndex].containerCache.over = 1;\n                }\n            } else {\n\n                // When entering a new container, we will find the item with the least distance and\n                // append our item near it\n                dist = 10000;\n                itemWithLeastDistance = null;\n                floating = innermostContainer.floating || this._isFloating(this.currentItem);\n                posProperty = floating ? \"left\" : \"top\";\n                sizeProperty = floating ? \"width\" : \"height\";\n                axis = floating ? \"pageX\" : \"pageY\";\n\n                for (j = this.items.length - 1; j >= 0; j--) {\n                    if (!$.contains(\n                        this.containers[innermostIndex].element[0], this.items[j].item[0])\n                    ) {\n                        continue;\n                    }\n                    if (this.items[j].item[0] === this.currentItem[0]) {\n                        continue;\n                    }\n\n                    cur = this.items[j].item.offset()[posProperty];\n                    nearBottom = false;\n                    if (event[axis] - cur > this.items[j][sizeProperty] / 2) {\n                        nearBottom = true;\n                    }\n\n                    if (Math.abs(event[axis] - cur) < dist) {\n                        dist = Math.abs(event[axis] - cur);\n                        itemWithLeastDistance = this.items[j];\n                        this.direction = nearBottom ? \"up\" : \"down\";\n                    }\n                }\n\n                //Check if dropOnEmpty is enabled\n                if (!itemWithLeastDistance && !this.options.dropOnEmpty) {\n                    return;\n                }\n\n                if (this.currentContainer === this.containers[innermostIndex]) {\n                    if (!this.currentContainer.containerCache.over) {\n                        this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash());\n                        this.currentContainer.containerCache.over = 1;\n                    }\n                    return;\n                }\n\n                if (itemWithLeastDistance) {\n                    this._rearrange(event, itemWithLeastDistance, null, true);\n                } else {\n                    this._rearrange(event, null, this.containers[innermostIndex].element, true);\n                }\n                this._trigger(\"change\", event, this._uiHash());\n                this.containers[innermostIndex]._trigger(\"change\", event, this._uiHash(this));\n                this.currentContainer = this.containers[innermostIndex];\n\n                //Update the placeholder\n                this.options.placeholder.update(this.currentContainer, this.placeholder);\n\n                //Update scrollParent\n                this.scrollParent = this.placeholder.scrollParent();\n\n                //Update overflowOffset\n                if (this.scrollParent[0] !== this.document[0] &&\n                    this.scrollParent[0].tagName !== \"HTML\") {\n                    this.overflowOffset = this.scrollParent.offset();\n                }\n\n                this.containers[innermostIndex]._trigger(\"over\", event, this._uiHash(this));\n                this.containers[innermostIndex].containerCache.over = 1;\n            }\n\n        }\n    }\n\n    return function () {\n        var majorVersion = parseInt($.ui.version.split('.')[0]),\n            minorVersion = parseInt($.ui.version.split('.')[1]),\n            patchVersion = parseInt($.ui.version.split('.')[2])\n\n        if (majorVersion === 1 && minorVersion === 13 && patchVersion > 0 ||\n            majorVersion === 1 && minorVersion >= 14 ||\n            majorVersion >= 2\n        ) {\n            console.warn('jQuery ui sortable patch is no longer necessary, and should be removed');\n        }\n\n        $.widget('ui.sortable', $.ui.sortable, sortablePatch);\n    };\n\n});\n","jquery/spectrum/tinycolor.js":"// This file is autogenerated. v1.6.0\n// It's here at this path for backwards compatibility for links to it\n// but the npm package now exports both CJS and ESM.\n// See https://github.com/bgrins/TinyColor/ for instructions.\n(function (global, factory) {\n    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n        typeof define === 'function' && define.amd ? define(factory) :\n            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.tinycolor = factory());\n})(this, (function () { 'use strict';\n\n    function _typeof(obj) {\n        \"@babel/helpers - typeof\";\n\n        return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) {\n            return typeof obj;\n        } : function (obj) {\n            return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj;\n        }, _typeof(obj);\n    }\n\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    var trimLeft = /^\\s+/;\n    var trimRight = /\\s+$/;\n    function tinycolor(color, opts) {\n        color = color ? color : \"\";\n        opts = opts || {};\n\n        // If input is already a tinycolor, return itself\n        if (color instanceof tinycolor) {\n            return color;\n        }\n        // If we are called as a function, call using new instead\n        if (!(this instanceof tinycolor)) {\n            return new tinycolor(color, opts);\n        }\n        var rgb = inputToRGB(color);\n        this._originalInput = color, this._r = rgb.r, this._g = rgb.g, this._b = rgb.b, this._a = rgb.a, this._roundA = Math.round(100 * this._a) / 100, this._format = opts.format || rgb.format;\n        this._gradientType = opts.gradientType;\n\n        // Don't let the range of [0,255] come back in [0,1].\n        // Potentially lose a little bit of precision here, but will fix issues where\n        // .5 gets interpreted as half of the total, instead of half of 1\n        // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n        if (this._r < 1) this._r = Math.round(this._r);\n        if (this._g < 1) this._g = Math.round(this._g);\n        if (this._b < 1) this._b = Math.round(this._b);\n        this._ok = rgb.ok;\n    }\n    tinycolor.prototype = {\n        isDark: function isDark() {\n            return this.getBrightness() < 128;\n        },\n        isLight: function isLight() {\n            return !this.isDark();\n        },\n        isValid: function isValid() {\n            return this._ok;\n        },\n        getOriginalInput: function getOriginalInput() {\n            return this._originalInput;\n        },\n        getFormat: function getFormat() {\n            return this._format;\n        },\n        getAlpha: function getAlpha() {\n            return this._a;\n        },\n        getBrightness: function getBrightness() {\n            //http://www.w3.org/TR/AERT#color-contrast\n            var rgb = this.toRgb();\n            return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n        },\n        getLuminance: function getLuminance() {\n            //http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef\n            var rgb = this.toRgb();\n            var RsRGB, GsRGB, BsRGB, R, G, B;\n            RsRGB = rgb.r / 255;\n            GsRGB = rgb.g / 255;\n            BsRGB = rgb.b / 255;\n            if (RsRGB <= 0.03928) R = RsRGB / 12.92;else R = Math.pow((RsRGB + 0.055) / 1.055, 2.4);\n            if (GsRGB <= 0.03928) G = GsRGB / 12.92;else G = Math.pow((GsRGB + 0.055) / 1.055, 2.4);\n            if (BsRGB <= 0.03928) B = BsRGB / 12.92;else B = Math.pow((BsRGB + 0.055) / 1.055, 2.4);\n            return 0.2126 * R + 0.7152 * G + 0.0722 * B;\n        },\n        setAlpha: function setAlpha(value) {\n            this._a = boundAlpha(value);\n            this._roundA = Math.round(100 * this._a) / 100;\n            return this;\n        },\n        toHsv: function toHsv() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            return {\n                h: hsv.h * 360,\n                s: hsv.s,\n                v: hsv.v,\n                a: this._a\n            };\n        },\n        toHsvString: function toHsvString() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            var h = Math.round(hsv.h * 360),\n                s = Math.round(hsv.s * 100),\n                v = Math.round(hsv.v * 100);\n            return this._a == 1 ? \"hsv(\" + h + \", \" + s + \"%, \" + v + \"%)\" : \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \" + this._roundA + \")\";\n        },\n        toHsl: function toHsl() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            return {\n                h: hsl.h * 360,\n                s: hsl.s,\n                l: hsl.l,\n                a: this._a\n            };\n        },\n        toHslString: function toHslString() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            var h = Math.round(hsl.h * 360),\n                s = Math.round(hsl.s * 100),\n                l = Math.round(hsl.l * 100);\n            return this._a == 1 ? \"hsl(\" + h + \", \" + s + \"%, \" + l + \"%)\" : \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \" + this._roundA + \")\";\n        },\n        toHex: function toHex(allow3Char) {\n            return rgbToHex(this._r, this._g, this._b, allow3Char);\n        },\n        toHexString: function toHexString(allow3Char) {\n            return \"#\" + this.toHex(allow3Char);\n        },\n        toHex8: function toHex8(allow4Char) {\n            return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);\n        },\n        toHex8String: function toHex8String(allow4Char) {\n            return \"#\" + this.toHex8(allow4Char);\n        },\n        toRgb: function toRgb() {\n            return {\n                r: Math.round(this._r),\n                g: Math.round(this._g),\n                b: Math.round(this._b),\n                a: this._a\n            };\n        },\n        toRgbString: function toRgbString() {\n            return this._a == 1 ? \"rgb(\" + Math.round(this._r) + \", \" + Math.round(this._g) + \", \" + Math.round(this._b) + \")\" : \"rgba(\" + Math.round(this._r) + \", \" + Math.round(this._g) + \", \" + Math.round(this._b) + \", \" + this._roundA + \")\";\n        },\n        toPercentageRgb: function toPercentageRgb() {\n            return {\n                r: Math.round(bound01(this._r, 255) * 100) + \"%\",\n                g: Math.round(bound01(this._g, 255) * 100) + \"%\",\n                b: Math.round(bound01(this._b, 255) * 100) + \"%\",\n                a: this._a\n            };\n        },\n        toPercentageRgbString: function toPercentageRgbString() {\n            return this._a == 1 ? \"rgb(\" + Math.round(bound01(this._r, 255) * 100) + \"%, \" + Math.round(bound01(this._g, 255) * 100) + \"%, \" + Math.round(bound01(this._b, 255) * 100) + \"%)\" : \"rgba(\" + Math.round(bound01(this._r, 255) * 100) + \"%, \" + Math.round(bound01(this._g, 255) * 100) + \"%, \" + Math.round(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n        },\n        toName: function toName() {\n            if (this._a === 0) {\n                return \"transparent\";\n            }\n            if (this._a < 1) {\n                return false;\n            }\n            return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n        },\n        toFilter: function toFilter(secondColor) {\n            var hex8String = \"#\" + rgbaToArgbHex(this._r, this._g, this._b, this._a);\n            var secondHex8String = hex8String;\n            var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n            if (secondColor) {\n                var s = tinycolor(secondColor);\n                secondHex8String = \"#\" + rgbaToArgbHex(s._r, s._g, s._b, s._a);\n            }\n            return \"progid:DXImageTransform.Microsoft.gradient(\" + gradientType + \"startColorstr=\" + hex8String + \",endColorstr=\" + secondHex8String + \")\";\n        },\n        toString: function toString(format) {\n            var formatSet = !!format;\n            format = format || this._format;\n            var formattedString = false;\n            var hasAlpha = this._a < 1 && this._a >= 0;\n            var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"hex4\" || format === \"hex8\" || format === \"name\");\n            if (needsAlphaFormat) {\n                // Special case for \"transparent\", all other non-alpha formats\n                // will return rgba when there is transparency.\n                if (format === \"name\" && this._a === 0) {\n                    return this.toName();\n                }\n                return this.toRgbString();\n            }\n            if (format === \"rgb\") {\n                formattedString = this.toRgbString();\n            }\n            if (format === \"prgb\") {\n                formattedString = this.toPercentageRgbString();\n            }\n            if (format === \"hex\" || format === \"hex6\") {\n                formattedString = this.toHexString();\n            }\n            if (format === \"hex3\") {\n                formattedString = this.toHexString(true);\n            }\n            if (format === \"hex4\") {\n                formattedString = this.toHex8String(true);\n            }\n            if (format === \"hex8\") {\n                formattedString = this.toHex8String();\n            }\n            if (format === \"name\") {\n                formattedString = this.toName();\n            }\n            if (format === \"hsl\") {\n                formattedString = this.toHslString();\n            }\n            if (format === \"hsv\") {\n                formattedString = this.toHsvString();\n            }\n            return formattedString || this.toHexString();\n        },\n        clone: function clone() {\n            return tinycolor(this.toString());\n        },\n        _applyModification: function _applyModification(fn, args) {\n            var color = fn.apply(null, [this].concat([].slice.call(args)));\n            this._r = color._r;\n            this._g = color._g;\n            this._b = color._b;\n            this.setAlpha(color._a);\n            return this;\n        },\n        lighten: function lighten() {\n            return this._applyModification(_lighten, arguments);\n        },\n        brighten: function brighten() {\n            return this._applyModification(_brighten, arguments);\n        },\n        darken: function darken() {\n            return this._applyModification(_darken, arguments);\n        },\n        desaturate: function desaturate() {\n            return this._applyModification(_desaturate, arguments);\n        },\n        saturate: function saturate() {\n            return this._applyModification(_saturate, arguments);\n        },\n        greyscale: function greyscale() {\n            return this._applyModification(_greyscale, arguments);\n        },\n        spin: function spin() {\n            return this._applyModification(_spin, arguments);\n        },\n        _applyCombination: function _applyCombination(fn, args) {\n            return fn.apply(null, [this].concat([].slice.call(args)));\n        },\n        analogous: function analogous() {\n            return this._applyCombination(_analogous, arguments);\n        },\n        complement: function complement() {\n            return this._applyCombination(_complement, arguments);\n        },\n        monochromatic: function monochromatic() {\n            return this._applyCombination(_monochromatic, arguments);\n        },\n        splitcomplement: function splitcomplement() {\n            return this._applyCombination(_splitcomplement, arguments);\n        },\n        // Disabled until https://github.com/bgrins/TinyColor/issues/254\n        // polyad: function (number) {\n        //   return this._applyCombination(polyad, [number]);\n        // },\n        triad: function triad() {\n            return this._applyCombination(polyad, [3]);\n        },\n        tetrad: function tetrad() {\n            return this._applyCombination(polyad, [4]);\n        }\n    };\n\n    // If input is an object, force 1 into \"1.0\" to handle ratios properly\n    // String input requires \"1.0\" as input, so 1 will be treated as 1\n    tinycolor.fromRatio = function (color, opts) {\n        if (_typeof(color) == \"object\") {\n            var newColor = {};\n            for (var i in color) {\n                if (color.hasOwnProperty(i)) {\n                    if (i === \"a\") {\n                        newColor[i] = color[i];\n                    } else {\n                        newColor[i] = convertToPercentage(color[i]);\n                    }\n                }\n            }\n            color = newColor;\n        }\n        return tinycolor(color, opts);\n    };\n\n    // Given a string or object, convert that input to RGB\n    // Possible string inputs:\n    //\n    //     \"red\"\n    //     \"#f00\" or \"f00\"\n    //     \"#ff0000\" or \"ff0000\"\n    //     \"#ff000000\" or \"ff000000\"\n    //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n    //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n    //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n    //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n    //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n    //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n    //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n    //\n    function inputToRGB(color) {\n        var rgb = {\n            r: 0,\n            g: 0,\n            b: 0\n        };\n        var a = 1;\n        var s = null;\n        var v = null;\n        var l = null;\n        var ok = false;\n        var format = false;\n        if (typeof color == \"string\") {\n            color = stringInputToObject(color);\n        }\n        if (_typeof(color) == \"object\") {\n            if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {\n                rgb = rgbToRgb(color.r, color.g, color.b);\n                ok = true;\n                format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n            } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {\n                s = convertToPercentage(color.s);\n                v = convertToPercentage(color.v);\n                rgb = hsvToRgb(color.h, s, v);\n                ok = true;\n                format = \"hsv\";\n            } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {\n                s = convertToPercentage(color.s);\n                l = convertToPercentage(color.l);\n                rgb = hslToRgb(color.h, s, l);\n                ok = true;\n                format = \"hsl\";\n            }\n            if (color.hasOwnProperty(\"a\")) {\n                a = color.a;\n            }\n        }\n        a = boundAlpha(a);\n        return {\n            ok: ok,\n            format: color.format || format,\n            r: Math.min(255, Math.max(rgb.r, 0)),\n            g: Math.min(255, Math.max(rgb.g, 0)),\n            b: Math.min(255, Math.max(rgb.b, 0)),\n            a: a\n        };\n    }\n\n    // Conversion Functions\n    // --------------------\n\n    // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n    // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n    // `rgbToRgb`\n    // Handle bounds / percentage checking to conform to CSS color spec\n    // <http://www.w3.org/TR/css3-color/>\n    // *Assumes:* r, g, b in [0, 255] or [0, 1]\n    // *Returns:* { r, g, b } in [0, 255]\n    function rgbToRgb(r, g, b) {\n        return {\n            r: bound01(r, 255) * 255,\n            g: bound01(g, 255) * 255,\n            b: bound01(b, 255) * 255\n        };\n    }\n\n    // `rgbToHsl`\n    // Converts an RGB color value to HSL.\n    // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n    // *Returns:* { h, s, l } in [0,1]\n    function rgbToHsl(r, g, b) {\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n        var max = Math.max(r, g, b),\n            min = Math.min(r, g, b);\n        var h,\n            s,\n            l = (max + min) / 2;\n        if (max == min) {\n            h = s = 0; // achromatic\n        } else {\n            var d = max - min;\n            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n            switch (max) {\n                case r:\n                    h = (g - b) / d + (g < b ? 6 : 0);\n                    break;\n                case g:\n                    h = (b - r) / d + 2;\n                    break;\n                case b:\n                    h = (r - g) / d + 4;\n                    break;\n            }\n            h /= 6;\n        }\n        return {\n            h: h,\n            s: s,\n            l: l\n        };\n    }\n\n    // `hslToRgb`\n    // Converts an HSL color value to RGB.\n    // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n    // *Returns:* { r, g, b } in the set [0, 255]\n    function hslToRgb(h, s, l) {\n        var r, g, b;\n        h = bound01(h, 360);\n        s = bound01(s, 100);\n        l = bound01(l, 100);\n        function hue2rgb(p, q, t) {\n            if (t < 0) t += 1;\n            if (t > 1) t -= 1;\n            if (t < 1 / 6) return p + (q - p) * 6 * t;\n            if (t < 1 / 2) return q;\n            if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;\n            return p;\n        }\n        if (s === 0) {\n            r = g = b = l; // achromatic\n        } else {\n            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n            var p = 2 * l - q;\n            r = hue2rgb(p, q, h + 1 / 3);\n            g = hue2rgb(p, q, h);\n            b = hue2rgb(p, q, h - 1 / 3);\n        }\n        return {\n            r: r * 255,\n            g: g * 255,\n            b: b * 255\n        };\n    }\n\n    // `rgbToHsv`\n    // Converts an RGB color value to HSV\n    // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n    // *Returns:* { h, s, v } in [0,1]\n    function rgbToHsv(r, g, b) {\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n        var max = Math.max(r, g, b),\n            min = Math.min(r, g, b);\n        var h,\n            s,\n            v = max;\n        var d = max - min;\n        s = max === 0 ? 0 : d / max;\n        if (max == min) {\n            h = 0; // achromatic\n        } else {\n            switch (max) {\n                case r:\n                    h = (g - b) / d + (g < b ? 6 : 0);\n                    break;\n                case g:\n                    h = (b - r) / d + 2;\n                    break;\n                case b:\n                    h = (r - g) / d + 4;\n                    break;\n            }\n            h /= 6;\n        }\n        return {\n            h: h,\n            s: s,\n            v: v\n        };\n    }\n\n    // `hsvToRgb`\n    // Converts an HSV color value to RGB.\n    // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n    // *Returns:* { r, g, b } in the set [0, 255]\n    function hsvToRgb(h, s, v) {\n        h = bound01(h, 360) * 6;\n        s = bound01(s, 100);\n        v = bound01(v, 100);\n        var i = Math.floor(h),\n            f = h - i,\n            p = v * (1 - s),\n            q = v * (1 - f * s),\n            t = v * (1 - (1 - f) * s),\n            mod = i % 6,\n            r = [v, q, p, p, t, v][mod],\n            g = [t, v, v, q, p, p][mod],\n            b = [p, p, t, v, v, q][mod];\n        return {\n            r: r * 255,\n            g: g * 255,\n            b: b * 255\n        };\n    }\n\n    // `rgbToHex`\n    // Converts an RGB color to hex\n    // Assumes r, g, and b are contained in the set [0, 255]\n    // Returns a 3 or 6 character hex\n    function rgbToHex(r, g, b, allow3Char) {\n        var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];\n\n        // Return a 3 character hex if possible\n        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n        }\n        return hex.join(\"\");\n    }\n\n    // `rgbaToHex`\n    // Converts an RGBA color plus alpha transparency to hex\n    // Assumes r, g, b are contained in the set [0, 255] and\n    // a in [0, 1]. Returns a 4 or 8 character rgba hex\n    function rgbaToHex(r, g, b, a, allow4Char) {\n        var hex = [pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16)), pad2(convertDecimalToHex(a))];\n\n        // Return a 4 character hex if possible\n        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);\n        }\n        return hex.join(\"\");\n    }\n\n    // `rgbaToArgbHex`\n    // Converts an RGBA color to an ARGB Hex8 string\n    // Rarely used, but required for \"toFilter()\"\n    function rgbaToArgbHex(r, g, b, a) {\n        var hex = [pad2(convertDecimalToHex(a)), pad2(Math.round(r).toString(16)), pad2(Math.round(g).toString(16)), pad2(Math.round(b).toString(16))];\n        return hex.join(\"\");\n    }\n\n    // `equals`\n    // Can be called with any tinycolor input\n    tinycolor.equals = function (color1, color2) {\n        if (!color1 || !color2) return false;\n        return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n    };\n    tinycolor.random = function () {\n        return tinycolor.fromRatio({\n            r: Math.random(),\n            g: Math.random(),\n            b: Math.random()\n        });\n    };\n\n    // Modification Functions\n    // ----------------------\n    // Thanks to less.js for some of the basics here\n    // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n    function _desaturate(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.s -= amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n    function _saturate(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.s += amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n    function _greyscale(color) {\n        return tinycolor(color).desaturate(100);\n    }\n    function _lighten(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.l += amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n    function _brighten(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var rgb = tinycolor(color).toRgb();\n        rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));\n        rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));\n        rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));\n        return tinycolor(rgb);\n    }\n    function _darken(color, amount) {\n        amount = amount === 0 ? 0 : amount || 10;\n        var hsl = tinycolor(color).toHsl();\n        hsl.l -= amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n    // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n    // Values outside of this range will be wrapped into this range.\n    function _spin(color, amount) {\n        var hsl = tinycolor(color).toHsl();\n        var hue = (hsl.h + amount) % 360;\n        hsl.h = hue < 0 ? 360 + hue : hue;\n        return tinycolor(hsl);\n    }\n\n    // Combination Functions\n    // ---------------------\n    // Thanks to jQuery xColor for some of the ideas behind these\n    // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n    function _complement(color) {\n        var hsl = tinycolor(color).toHsl();\n        hsl.h = (hsl.h + 180) % 360;\n        return tinycolor(hsl);\n    }\n    function polyad(color, number) {\n        if (isNaN(number) || number <= 0) {\n            throw new Error(\"Argument to polyad must be a positive number\");\n        }\n        var hsl = tinycolor(color).toHsl();\n        var result = [tinycolor(color)];\n        var step = 360 / number;\n        for (var i = 1; i < number; i++) {\n            result.push(tinycolor({\n                h: (hsl.h + i * step) % 360,\n                s: hsl.s,\n                l: hsl.l\n            }));\n        }\n        return result;\n    }\n    function _splitcomplement(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [tinycolor(color), tinycolor({\n            h: (h + 72) % 360,\n            s: hsl.s,\n            l: hsl.l\n        }), tinycolor({\n            h: (h + 216) % 360,\n            s: hsl.s,\n            l: hsl.l\n        })];\n    }\n    function _analogous(color, results, slices) {\n        results = results || 6;\n        slices = slices || 30;\n        var hsl = tinycolor(color).toHsl();\n        var part = 360 / slices;\n        var ret = [tinycolor(color)];\n        for (hsl.h = (hsl.h - (part * results >> 1) + 720) % 360; --results;) {\n            hsl.h = (hsl.h + part) % 360;\n            ret.push(tinycolor(hsl));\n        }\n        return ret;\n    }\n    function _monochromatic(color, results) {\n        results = results || 6;\n        var hsv = tinycolor(color).toHsv();\n        var h = hsv.h,\n            s = hsv.s,\n            v = hsv.v;\n        var ret = [];\n        var modification = 1 / results;\n        while (results--) {\n            ret.push(tinycolor({\n                h: h,\n                s: s,\n                v: v\n            }));\n            v = (v + modification) % 1;\n        }\n        return ret;\n    }\n\n    // Utility Functions\n    // ---------------------\n\n    tinycolor.mix = function (color1, color2, amount) {\n        amount = amount === 0 ? 0 : amount || 50;\n        var rgb1 = tinycolor(color1).toRgb();\n        var rgb2 = tinycolor(color2).toRgb();\n        var p = amount / 100;\n        var rgba = {\n            r: (rgb2.r - rgb1.r) * p + rgb1.r,\n            g: (rgb2.g - rgb1.g) * p + rgb1.g,\n            b: (rgb2.b - rgb1.b) * p + rgb1.b,\n            a: (rgb2.a - rgb1.a) * p + rgb1.a\n        };\n        return tinycolor(rgba);\n    };\n\n    // Readability Functions\n    // ---------------------\n    // <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)\n\n    // `contrast`\n    // Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)\n    tinycolor.readability = function (color1, color2) {\n        var c1 = tinycolor(color1);\n        var c2 = tinycolor(color2);\n        return (Math.max(c1.getLuminance(), c2.getLuminance()) + 0.05) / (Math.min(c1.getLuminance(), c2.getLuminance()) + 0.05);\n    };\n\n    // `isReadable`\n    // Ensure that foreground and background color combinations meet WCAG2 guidelines.\n    // The third argument is an optional Object.\n    //      the 'level' property states 'AA' or 'AAA' - if missing or invalid, it defaults to 'AA';\n    //      the 'size' property states 'large' or 'small' - if missing or invalid, it defaults to 'small'.\n    // If the entire object is absent, isReadable defaults to {level:\"AA\",size:\"small\"}.\n\n    // *Example*\n    //    tinycolor.isReadable(\"#000\", \"#111\") => false\n    //    tinycolor.isReadable(\"#000\", \"#111\",{level:\"AA\",size:\"large\"}) => false\n    tinycolor.isReadable = function (color1, color2, wcag2) {\n        var readability = tinycolor.readability(color1, color2);\n        var wcag2Parms, out;\n        out = false;\n        wcag2Parms = validateWCAG2Parms(wcag2);\n        switch (wcag2Parms.level + wcag2Parms.size) {\n            case \"AAsmall\":\n            case \"AAAlarge\":\n                out = readability >= 4.5;\n                break;\n            case \"AAlarge\":\n                out = readability >= 3;\n                break;\n            case \"AAAsmall\":\n                out = readability >= 7;\n                break;\n        }\n        return out;\n    };\n\n    // `mostReadable`\n    // Given a base color and a list of possible foreground or background\n    // colors for that base, returns the most readable color.\n    // Optionally returns Black or White if the most readable color is unreadable.\n    // *Example*\n    //    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:false}).toHexString(); // \"#112255\"\n    //    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:true}).toHexString();  // \"#ffffff\"\n    //    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"large\"}).toHexString(); // \"#faf3f3\"\n    //    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"small\"}).toHexString(); // \"#ffffff\"\n    tinycolor.mostReadable = function (baseColor, colorList, args) {\n        var bestColor = null;\n        var bestScore = 0;\n        var readability;\n        var includeFallbackColors, level, size;\n        args = args || {};\n        includeFallbackColors = args.includeFallbackColors;\n        level = args.level;\n        size = args.size;\n        for (var i = 0; i < colorList.length; i++) {\n            readability = tinycolor.readability(baseColor, colorList[i]);\n            if (readability > bestScore) {\n                bestScore = readability;\n                bestColor = tinycolor(colorList[i]);\n            }\n        }\n        if (tinycolor.isReadable(baseColor, bestColor, {\n            level: level,\n            size: size\n        }) || !includeFallbackColors) {\n            return bestColor;\n        } else {\n            args.includeFallbackColors = false;\n            return tinycolor.mostReadable(baseColor, [\"#fff\", \"#000\"], args);\n        }\n    };\n\n    // Big List of Colors\n    // ------------------\n    // <https://www.w3.org/TR/css-color-4/#named-colors>\n    var names = tinycolor.names = {\n        aliceblue: \"f0f8ff\",\n        antiquewhite: \"faebd7\",\n        aqua: \"0ff\",\n        aquamarine: \"7fffd4\",\n        azure: \"f0ffff\",\n        beige: \"f5f5dc\",\n        bisque: \"ffe4c4\",\n        black: \"000\",\n        blanchedalmond: \"ffebcd\",\n        blue: \"00f\",\n        blueviolet: \"8a2be2\",\n        brown: \"a52a2a\",\n        burlywood: \"deb887\",\n        burntsienna: \"ea7e5d\",\n        cadetblue: \"5f9ea0\",\n        chartreuse: \"7fff00\",\n        chocolate: \"d2691e\",\n        coral: \"ff7f50\",\n        cornflowerblue: \"6495ed\",\n        cornsilk: \"fff8dc\",\n        crimson: \"dc143c\",\n        cyan: \"0ff\",\n        darkblue: \"00008b\",\n        darkcyan: \"008b8b\",\n        darkgoldenrod: \"b8860b\",\n        darkgray: \"a9a9a9\",\n        darkgreen: \"006400\",\n        darkgrey: \"a9a9a9\",\n        darkkhaki: \"bdb76b\",\n        darkmagenta: \"8b008b\",\n        darkolivegreen: \"556b2f\",\n        darkorange: \"ff8c00\",\n        darkorchid: \"9932cc\",\n        darkred: \"8b0000\",\n        darksalmon: \"e9967a\",\n        darkseagreen: \"8fbc8f\",\n        darkslateblue: \"483d8b\",\n        darkslategray: \"2f4f4f\",\n        darkslategrey: \"2f4f4f\",\n        darkturquoise: \"00ced1\",\n        darkviolet: \"9400d3\",\n        deeppink: \"ff1493\",\n        deepskyblue: \"00bfff\",\n        dimgray: \"696969\",\n        dimgrey: \"696969\",\n        dodgerblue: \"1e90ff\",\n        firebrick: \"b22222\",\n        floralwhite: \"fffaf0\",\n        forestgreen: \"228b22\",\n        fuchsia: \"f0f\",\n        gainsboro: \"dcdcdc\",\n        ghostwhite: \"f8f8ff\",\n        gold: \"ffd700\",\n        goldenrod: \"daa520\",\n        gray: \"808080\",\n        green: \"008000\",\n        greenyellow: \"adff2f\",\n        grey: \"808080\",\n        honeydew: \"f0fff0\",\n        hotpink: \"ff69b4\",\n        indianred: \"cd5c5c\",\n        indigo: \"4b0082\",\n        ivory: \"fffff0\",\n        khaki: \"f0e68c\",\n        lavender: \"e6e6fa\",\n        lavenderblush: \"fff0f5\",\n        lawngreen: \"7cfc00\",\n        lemonchiffon: \"fffacd\",\n        lightblue: \"add8e6\",\n        lightcoral: \"f08080\",\n        lightcyan: \"e0ffff\",\n        lightgoldenrodyellow: \"fafad2\",\n        lightgray: \"d3d3d3\",\n        lightgreen: \"90ee90\",\n        lightgrey: \"d3d3d3\",\n        lightpink: \"ffb6c1\",\n        lightsalmon: \"ffa07a\",\n        lightseagreen: \"20b2aa\",\n        lightskyblue: \"87cefa\",\n        lightslategray: \"789\",\n        lightslategrey: \"789\",\n        lightsteelblue: \"b0c4de\",\n        lightyellow: \"ffffe0\",\n        lime: \"0f0\",\n        limegreen: \"32cd32\",\n        linen: \"faf0e6\",\n        magenta: \"f0f\",\n        maroon: \"800000\",\n        mediumaquamarine: \"66cdaa\",\n        mediumblue: \"0000cd\",\n        mediumorchid: \"ba55d3\",\n        mediumpurple: \"9370db\",\n        mediumseagreen: \"3cb371\",\n        mediumslateblue: \"7b68ee\",\n        mediumspringgreen: \"00fa9a\",\n        mediumturquoise: \"48d1cc\",\n        mediumvioletred: \"c71585\",\n        midnightblue: \"191970\",\n        mintcream: \"f5fffa\",\n        mistyrose: \"ffe4e1\",\n        moccasin: \"ffe4b5\",\n        navajowhite: \"ffdead\",\n        navy: \"000080\",\n        oldlace: \"fdf5e6\",\n        olive: \"808000\",\n        olivedrab: \"6b8e23\",\n        orange: \"ffa500\",\n        orangered: \"ff4500\",\n        orchid: \"da70d6\",\n        palegoldenrod: \"eee8aa\",\n        palegreen: \"98fb98\",\n        paleturquoise: \"afeeee\",\n        palevioletred: \"db7093\",\n        papayawhip: \"ffefd5\",\n        peachpuff: \"ffdab9\",\n        peru: \"cd853f\",\n        pink: \"ffc0cb\",\n        plum: \"dda0dd\",\n        powderblue: \"b0e0e6\",\n        purple: \"800080\",\n        rebeccapurple: \"663399\",\n        red: \"f00\",\n        rosybrown: \"bc8f8f\",\n        royalblue: \"4169e1\",\n        saddlebrown: \"8b4513\",\n        salmon: \"fa8072\",\n        sandybrown: \"f4a460\",\n        seagreen: \"2e8b57\",\n        seashell: \"fff5ee\",\n        sienna: \"a0522d\",\n        silver: \"c0c0c0\",\n        skyblue: \"87ceeb\",\n        slateblue: \"6a5acd\",\n        slategray: \"708090\",\n        slategrey: \"708090\",\n        snow: \"fffafa\",\n        springgreen: \"00ff7f\",\n        steelblue: \"4682b4\",\n        tan: \"d2b48c\",\n        teal: \"008080\",\n        thistle: \"d8bfd8\",\n        tomato: \"ff6347\",\n        turquoise: \"40e0d0\",\n        violet: \"ee82ee\",\n        wheat: \"f5deb3\",\n        white: \"fff\",\n        whitesmoke: \"f5f5f5\",\n        yellow: \"ff0\",\n        yellowgreen: \"9acd32\"\n    };\n\n    // Make it easy to access colors via `hexNames[hex]`\n    var hexNames = tinycolor.hexNames = flip(names);\n\n    // Utilities\n    // ---------\n\n    // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n    function flip(o) {\n        var flipped = {};\n        for (var i in o) {\n            if (o.hasOwnProperty(i)) {\n                flipped[o[i]] = i;\n            }\n        }\n        return flipped;\n    }\n\n    // Return a valid alpha value [0,1] with all invalid values being set to 1\n    function boundAlpha(a) {\n        a = parseFloat(a);\n        if (isNaN(a) || a < 0 || a > 1) {\n            a = 1;\n        }\n        return a;\n    }\n\n    // Take input from [0, n] and return it as [0, 1]\n    function bound01(n, max) {\n        if (isOnePointZero(n)) n = \"100%\";\n        var processPercent = isPercentage(n);\n        n = Math.min(max, Math.max(0, parseFloat(n)));\n\n        // Automatically convert percentage into number\n        if (processPercent) {\n            n = parseInt(n * max, 10) / 100;\n        }\n\n        // Handle floating point rounding errors\n        if (Math.abs(n - max) < 0.000001) {\n            return 1;\n        }\n\n        // Convert into [0, 1] range if it isn't already\n        return n % max / parseFloat(max);\n    }\n\n    // Force a number between 0 and 1\n    function clamp01(val) {\n        return Math.min(1, Math.max(0, val));\n    }\n\n    // Parse a base-16 hex value into a base-10 integer\n    function parseIntFromHex(val) {\n        return parseInt(val, 16);\n    }\n\n    // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n    // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n    function isOnePointZero(n) {\n        return typeof n == \"string\" && n.indexOf(\".\") != -1 && parseFloat(n) === 1;\n    }\n\n    // Check to see if string passed in is a percentage\n    function isPercentage(n) {\n        return typeof n === \"string\" && n.indexOf(\"%\") != -1;\n    }\n\n    // Force a hex value to have 2 characters\n    function pad2(c) {\n        return c.length == 1 ? \"0\" + c : \"\" + c;\n    }\n\n    // Replace a decimal with it's percentage value\n    function convertToPercentage(n) {\n        if (n <= 1) {\n            n = n * 100 + \"%\";\n        }\n        return n;\n    }\n\n    // Converts a decimal to a hex value\n    function convertDecimalToHex(d) {\n        return Math.round(parseFloat(d) * 255).toString(16);\n    }\n    // Converts a hex value to a decimal\n    function convertHexToDecimal(h) {\n        return parseIntFromHex(h) / 255;\n    }\n    var matchers = function () {\n        // <http://www.w3.org/TR/css3-values/#integers>\n        var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n        // <http://www.w3.org/TR/css3-values/#number-value>\n        var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n        // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n        var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n        // Actual matching.\n        // Parentheses and commas are optional, but not required.\n        // Whitespace can take the place of commas or opening paren\n        var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        return {\n            CSS_UNIT: new RegExp(CSS_UNIT),\n            rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n            rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n            hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n            hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n            hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n            hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n            hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n            hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n        };\n    }();\n\n    // `isValidCSSUnit`\n    // Take in a single string / number and check to see if it looks like a CSS unit\n    // (see `matchers` above for definition).\n    function isValidCSSUnit(color) {\n        return !!matchers.CSS_UNIT.exec(color);\n    }\n\n    // `stringInputToObject`\n    // Permissive string parsing.  Take in a number of formats, and output an object\n    // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n    function stringInputToObject(color) {\n        color = color.replace(trimLeft, \"\").replace(trimRight, \"\").toLowerCase();\n        var named = false;\n        if (names[color]) {\n            color = names[color];\n            named = true;\n        } else if (color == \"transparent\") {\n            return {\n                r: 0,\n                g: 0,\n                b: 0,\n                a: 0,\n                format: \"name\"\n            };\n        }\n\n        // Try to match string input using regular expressions.\n        // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n        // Just return an object and let the conversion functions handle that.\n        // This way the result will be the same whether the tinycolor is initialized with string or object.\n        var match;\n        if (match = matchers.rgb.exec(color)) {\n            return {\n                r: match[1],\n                g: match[2],\n                b: match[3]\n            };\n        }\n        if (match = matchers.rgba.exec(color)) {\n            return {\n                r: match[1],\n                g: match[2],\n                b: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hsl.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                l: match[3]\n            };\n        }\n        if (match = matchers.hsla.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                l: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hsv.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                v: match[3]\n            };\n        }\n        if (match = matchers.hsva.exec(color)) {\n            return {\n                h: match[1],\n                s: match[2],\n                v: match[3],\n                a: match[4]\n            };\n        }\n        if (match = matchers.hex8.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                a: convertHexToDecimal(match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if (match = matchers.hex6.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        if (match = matchers.hex4.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1] + \"\" + match[1]),\n                g: parseIntFromHex(match[2] + \"\" + match[2]),\n                b: parseIntFromHex(match[3] + \"\" + match[3]),\n                a: convertHexToDecimal(match[4] + \"\" + match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if (match = matchers.hex3.exec(color)) {\n            return {\n                r: parseIntFromHex(match[1] + \"\" + match[1]),\n                g: parseIntFromHex(match[2] + \"\" + match[2]),\n                b: parseIntFromHex(match[3] + \"\" + match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        return false;\n    }\n    function validateWCAG2Parms(parms) {\n        // return valid WCAG2 parms for isReadable.\n        // If input parms are invalid, return {\"level\":\"AA\", \"size\":\"small\"}\n        var level, size;\n        parms = parms || {\n            level: \"AA\",\n            size: \"small\"\n        };\n        level = (parms.level || \"AA\").toUpperCase();\n        size = (parms.size || \"small\").toLowerCase();\n        if (level !== \"AA\" && level !== \"AAA\") {\n            level = \"AA\";\n        }\n        if (size !== \"small\" && size !== \"large\") {\n            size = \"small\";\n        }\n        return {\n            level: level,\n            size: size\n        };\n    }\n\n    return tinycolor;\n\n}));\n","jquery/spectrum/spectrum.js":"// Spectrum Colorpicker v1.8.1\n// https://github.com/bgrins/spectrum\n// Author: Brian Grinstead\n// License: MIT\n\n(function (factory) {\n    \"use strict\";\n\n    if (typeof define === 'function' && define.amd) { // AMD\n        define(['jquery'], factory);\n    }\n    else if (typeof exports == \"object\" && typeof module == \"object\") { // CommonJS\n        module.exports = factory(require('jquery'));\n    }\n    else { // Browser\n        factory(jQuery);\n    }\n})(function($, undefined) {\n    \"use strict\";\n\n    var defaultOpts = {\n\n            // Callbacks\n            beforeShow: noop,\n            move: noop,\n            change: noop,\n            show: noop,\n            hide: noop,\n\n            // Options\n            color: false,\n            flat: false,\n            showInput: false,\n            allowEmpty: false,\n            showButtons: true,\n            clickoutFiresChange: true,\n            showInitial: false,\n            showPalette: false,\n            showPaletteOnly: false,\n            hideAfterPaletteSelect: false,\n            togglePaletteOnly: false,\n            showSelectionPalette: true,\n            localStorageKey: false,\n            appendTo: \"body\",\n            maxSelectionSize: 7,\n            cancelText: \"cancel\",\n            chooseText: \"choose\",\n            togglePaletteMoreText: \"more\",\n            togglePaletteLessText: \"less\",\n            clearText: \"Clear Color Selection\",\n            noColorSelectedText: \"No Color Selected\",\n            preferredFormat: false,\n            className: \"\", // Deprecated - use containerClassName and replacerClassName instead.\n            containerClassName: \"\",\n            replacerClassName: \"\",\n            showAlpha: false,\n            theme: \"sp-light\",\n            palette: [[\"#ffffff\", \"#000000\", \"#ff0000\", \"#ff8000\", \"#ffff00\", \"#008000\", \"#0000ff\", \"#4b0082\", \"#9400d3\"]],\n            selectionPalette: [],\n            disabled: false,\n            offset: null\n        },\n        spectrums = [],\n        IE = !!/msie/i.exec( window.navigator.userAgent ),\n        rgbaSupport = (function() {\n            function contains( str, substr ) {\n                return !!~('' + str).indexOf(substr);\n            }\n\n            var elem = document.createElement('div');\n            var style = elem.style;\n            style.cssText = 'background-color:rgba(0,0,0,.5)';\n            return contains(style.backgroundColor, 'rgba') || contains(style.backgroundColor, 'hsla');\n        })(),\n        replaceInput = [\n            \"<div class='sp-replacer'>\",\n            \"<div class='sp-preview'><div class='sp-preview-inner'></div></div>\",\n            \"<div class='sp-dd'>&#9660;</div>\",\n            \"</div>\"\n        ].join(''),\n        markup = (function () {\n\n            // IE does not support gradients with multiple stops, so we need to simulate\n            //  that for the rainbow slider with 8 divs that each have a single gradient\n            var gradientFix = \"\";\n            if (IE) {\n                for (var i = 1; i <= 6; i++) {\n                    gradientFix += \"<div class='sp-\" + i + \"'></div>\";\n                }\n            }\n\n            return [\n                \"<div class='sp-container sp-hidden'>\",\n                \"<div class='sp-palette-container'>\",\n                \"<div class='sp-palette sp-thumb sp-cf'></div>\",\n                \"<div class='sp-palette-button-container sp-cf'>\",\n                \"<button type='button' class='sp-palette-toggle'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-picker-container'>\",\n                \"<div class='sp-top sp-cf'>\",\n                \"<div class='sp-fill'></div>\",\n                \"<div class='sp-top-inner'>\",\n                \"<div class='sp-color'>\",\n                \"<div class='sp-sat'>\",\n                \"<div class='sp-val'>\",\n                \"<div class='sp-dragger'></div>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-clear sp-clear-display'>\",\n                \"</div>\",\n                \"<div class='sp-hue'>\",\n                \"<div class='sp-slider'></div>\",\n                gradientFix,\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>\",\n                \"</div>\",\n                \"<div class='sp-input-container sp-cf'>\",\n                \"<input class='sp-input' type='text' spellcheck='false'  />\",\n                \"</div>\",\n                \"<div class='sp-initial sp-thumb sp-cf'></div>\",\n                \"<div class='sp-button-container sp-cf'>\",\n                \"<a class='sp-cancel' href='#'></a>\",\n                \"<button type='button' class='sp-choose'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\"\n            ].join(\"\");\n        })();\n\n    function paletteTemplate (p, color, className, opts) {\n        var html = [];\n        for (var i = 0; i < p.length; i++) {\n            var current = p[i];\n            if(current) {\n                var tiny = tinycolor(current);\n                var c = tiny.toHsl().l < 0.5 ? \"sp-thumb-el sp-thumb-dark\" : \"sp-thumb-el sp-thumb-light\";\n                c += (tinycolor.equals(color, current)) ? \" sp-thumb-active\" : \"\";\n                var formattedString = tiny.toString(opts.preferredFormat || \"rgb\");\n                var swatchStyle = rgbaSupport ? (\"background-color:\" + tiny.toRgbString()) : \"filter:\" + tiny.toFilter();\n                html.push('<span title=\"' + formattedString + '\" data-color=\"' + tiny.toRgbString() + '\" class=\"' + c + '\"><span class=\"sp-thumb-inner\" style=\"' + swatchStyle + ';\"></span></span>');\n            } else {\n                var cls = 'sp-clear-display';\n                html.push($('<div />')\n                    .append($('<span data-color=\"\" style=\"background-color:transparent;\" class=\"' + cls + '\"></span>')\n                        .attr('title', opts.noColorSelectedText)\n                    )\n                    .html()\n                );\n            }\n        }\n        return \"<div class='sp-cf \" + className + \"'>\" + html.join('') + \"</div>\";\n    }\n\n    function hideAll() {\n        for (var i = 0; i < spectrums.length; i++) {\n            if (spectrums[i]) {\n                spectrums[i].hide();\n            }\n        }\n    }\n\n    function instanceOptions(o, callbackContext) {\n        var opts = $.extend({}, defaultOpts, o);\n        opts.callbacks = {\n            'move': bind(opts.move, callbackContext),\n            'change': bind(opts.change, callbackContext),\n            'show': bind(opts.show, callbackContext),\n            'hide': bind(opts.hide, callbackContext),\n            'beforeShow': bind(opts.beforeShow, callbackContext)\n        };\n\n        return opts;\n    }\n\n    function spectrum(element, o) {\n\n        var opts = instanceOptions(o, element),\n            flat = opts.flat,\n            showSelectionPalette = opts.showSelectionPalette,\n            localStorageKey = opts.localStorageKey,\n            theme = opts.theme,\n            callbacks = opts.callbacks,\n            resize = throttle(reflow, 10),\n            visible = false,\n            isDragging = false,\n            dragWidth = 0,\n            dragHeight = 0,\n            dragHelperHeight = 0,\n            slideHeight = 0,\n            slideWidth = 0,\n            alphaWidth = 0,\n            alphaSlideHelperWidth = 0,\n            slideHelperHeight = 0,\n            currentHue = 0,\n            currentSaturation = 0,\n            currentValue = 0,\n            currentAlpha = 1,\n            palette = [],\n            paletteArray = [],\n            paletteLookup = {},\n            selectionPalette = opts.selectionPalette.slice(0),\n            maxSelectionSize = opts.maxSelectionSize,\n            draggingClass = \"sp-dragging\",\n            shiftMovementDirection = null;\n\n        var doc = element.ownerDocument,\n            body = doc.body,\n            boundElement = $(element),\n            disabled = false,\n            container = $(markup, doc).addClass(theme),\n            pickerContainer = container.find(\".sp-picker-container\"),\n            dragger = container.find(\".sp-color\"),\n            dragHelper = container.find(\".sp-dragger\"),\n            slider = container.find(\".sp-hue\"),\n            slideHelper = container.find(\".sp-slider\"),\n            alphaSliderInner = container.find(\".sp-alpha-inner\"),\n            alphaSlider = container.find(\".sp-alpha\"),\n            alphaSlideHelper = container.find(\".sp-alpha-handle\"),\n            textInput = container.find(\".sp-input\"),\n            paletteContainer = container.find(\".sp-palette\"),\n            initialColorContainer = container.find(\".sp-initial\"),\n            cancelButton = container.find(\".sp-cancel\"),\n            clearButton = container.find(\".sp-clear\"),\n            chooseButton = container.find(\".sp-choose\"),\n            toggleButton = container.find(\".sp-palette-toggle\"),\n            isInput = boundElement.is(\"input\"),\n            isInputTypeColor = isInput && boundElement.attr(\"type\") === \"color\" && inputTypeColorSupport(),\n            shouldReplace = isInput && !flat,\n            replacer = (shouldReplace) ? $(replaceInput).addClass(theme).addClass(opts.className).addClass(opts.replacerClassName) : $([]),\n            offsetElement = (shouldReplace) ? replacer : boundElement,\n            previewElement = replacer.find(\".sp-preview-inner\"),\n            initialColor = opts.color || (isInput && boundElement.val()),\n            colorOnShow = false,\n            currentPreferredFormat = opts.preferredFormat,\n            clickoutFiresChange = !opts.showButtons || opts.clickoutFiresChange,\n            isEmpty = !initialColor,\n            allowEmpty = opts.allowEmpty && !isInputTypeColor;\n\n        function applyOptions() {\n\n            if (opts.showPaletteOnly) {\n                opts.showPalette = true;\n            }\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n\n            if (opts.palette) {\n                palette = opts.palette.slice(0);\n                paletteArray = $.isArray(palette[0]) ? palette : [palette];\n                paletteLookup = {};\n                for (var i = 0; i < paletteArray.length; i++) {\n                    for (var j = 0; j < paletteArray[i].length; j++) {\n                        var rgb = tinycolor(paletteArray[i][j]).toRgbString();\n                        paletteLookup[rgb] = true;\n                    }\n                }\n            }\n\n            container.toggleClass(\"sp-flat\", flat);\n            container.toggleClass(\"sp-input-disabled\", !opts.showInput);\n            container.toggleClass(\"sp-alpha-enabled\", opts.showAlpha);\n            container.toggleClass(\"sp-clear-enabled\", allowEmpty);\n            container.toggleClass(\"sp-buttons-disabled\", !opts.showButtons);\n            container.toggleClass(\"sp-palette-buttons-disabled\", !opts.togglePaletteOnly);\n            container.toggleClass(\"sp-palette-disabled\", !opts.showPalette);\n            container.toggleClass(\"sp-palette-only\", opts.showPaletteOnly);\n            container.toggleClass(\"sp-initial-disabled\", !opts.showInitial);\n            container.addClass(opts.className).addClass(opts.containerClassName);\n\n            reflow();\n        }\n\n        function initialize() {\n\n            if (IE) {\n                container.find(\"*:not(input)\").attr(\"unselectable\", \"on\");\n            }\n\n            applyOptions();\n\n            if (shouldReplace) {\n                boundElement.after(replacer).hide();\n            }\n\n            if (!allowEmpty) {\n                clearButton.hide();\n            }\n\n            if (flat) {\n                boundElement.after(container).hide();\n            }\n            else {\n\n                var appendTo = opts.appendTo === \"parent\" ? boundElement.parent() : $(opts.appendTo);\n                if (appendTo.length !== 1) {\n                    appendTo = $(\"body\");\n                }\n\n                appendTo.append(container);\n            }\n\n            updateSelectionPaletteFromStorage();\n\n            offsetElement.on(\"click.spectrum touchstart.spectrum\", function (e) {\n                if (!disabled) {\n                    toggle();\n                }\n\n                e.stopPropagation();\n\n                if (!$(e.target).is(\"input\")) {\n                    e.preventDefault();\n                }\n            });\n\n            if(boundElement.is(\":disabled\") || (opts.disabled === true)) {\n                disable();\n            }\n\n            // Prevent clicks from bubbling up to document.  This would cause it to be hidden.\n            container.click(stopPropagation);\n\n            // Handle user typed input\n            textInput.change(setFromTextInput);\n            textInput.on(\"paste\", function () {\n                setTimeout(setFromTextInput, 1);\n            });\n            textInput.keydown(function (e) { if (e.keyCode == 13) { setFromTextInput(); } });\n\n            cancelButton.text(opts.cancelText);\n            cancelButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                revert();\n                hide();\n            });\n\n            clearButton.attr(\"title\", opts.clearText);\n            clearButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                isEmpty = true;\n                move();\n\n                if(flat) {\n                    //for the flat style, this is a change event\n                    updateOriginalInput(true);\n                }\n            });\n\n            chooseButton.text(opts.chooseText);\n            chooseButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                if (IE && textInput.is(\":focus\")) {\n                    textInput.trigger('change');\n                }\n\n                if (isValid()) {\n                    updateOriginalInput(true);\n                    hide();\n                }\n            });\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n            toggleButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                opts.showPaletteOnly = !opts.showPaletteOnly;\n\n                // To make sure the Picker area is drawn on the right, next to the\n                // Palette area (and not below the palette), first move the Palette\n                // to the left to make space for the picker, plus 5px extra.\n                // The 'applyOptions' function puts the whole container back into place\n                // and takes care of the button-text and the sp-palette-only CSS class.\n                if (!opts.showPaletteOnly && !flat) {\n                    container.css('left', '-=' + (pickerContainer.outerWidth(true) + 5));\n                }\n                applyOptions();\n            });\n\n            draggable(alphaSlider, function (dragX, dragY, e) {\n                currentAlpha = (dragX / alphaWidth);\n                isEmpty = false;\n                if (e.shiftKey) {\n                    currentAlpha = Math.round(currentAlpha * 10) / 10;\n                }\n\n                move();\n            }, dragStart, dragStop);\n\n            draggable(slider, function (dragX, dragY) {\n                currentHue = parseFloat(dragY / slideHeight);\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n                move();\n            }, dragStart, dragStop);\n\n            draggable(dragger, function (dragX, dragY, e) {\n\n                // shift+drag should snap the movement to either the x or y axis.\n                if (!e.shiftKey) {\n                    shiftMovementDirection = null;\n                }\n                else if (!shiftMovementDirection) {\n                    var oldDragX = currentSaturation * dragWidth;\n                    var oldDragY = dragHeight - (currentValue * dragHeight);\n                    var furtherFromX = Math.abs(dragX - oldDragX) > Math.abs(dragY - oldDragY);\n\n                    shiftMovementDirection = furtherFromX ? \"x\" : \"y\";\n                }\n\n                var setSaturation = !shiftMovementDirection || shiftMovementDirection === \"x\";\n                var setValue = !shiftMovementDirection || shiftMovementDirection === \"y\";\n\n                if (setSaturation) {\n                    currentSaturation = parseFloat(dragX / dragWidth);\n                }\n                if (setValue) {\n                    currentValue = parseFloat((dragHeight - dragY) / dragHeight);\n                }\n\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n\n                move();\n\n            }, dragStart, dragStop);\n\n            if (!!initialColor) {\n                set(initialColor);\n\n                // In case color was black - update the preview UI and set the format\n                // since the set function will not run (default color is black).\n                updateUI();\n                currentPreferredFormat = opts.preferredFormat || tinycolor(initialColor).format;\n\n                addColorToSelectionPalette(initialColor);\n            }\n            else {\n                updateUI();\n            }\n\n            if (flat) {\n                show();\n            }\n\n            function paletteElementClick(e) {\n                if (e.data && e.data.ignore) {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n                }\n                else {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n\n                    updateOriginalInput(true);\n                    if (opts.hideAfterPaletteSelect) {\n                        hide();\n                    }\n                }\n\n                return false;\n            }\n\n            var paletteEvent = IE ? \"mousedown.spectrum\" : \"click.spectrum touchstart.spectrum\";\n            paletteContainer.on(paletteEvent, \".sp-thumb-el\", paletteElementClick);\n            initialColorContainer.on(paletteEvent, \".sp-thumb-el:nth-child(1)\", { ignore: true }, paletteElementClick);\n        }\n\n        function updateSelectionPaletteFromStorage() {\n\n            if (localStorageKey && window.localStorage) {\n\n                // Migrate old palettes over to new format.  May want to remove this eventually.\n                try {\n                    var oldPalette = window.localStorage[localStorageKey].split(\",#\");\n                    if (oldPalette.length > 1) {\n                        delete window.localStorage[localStorageKey];\n                        $.each(oldPalette, function(i, c) {\n                            addColorToSelectionPalette(c);\n                        });\n                    }\n                }\n                catch(e) { }\n\n                try {\n                    selectionPalette = window.localStorage[localStorageKey].split(\";\");\n                }\n                catch (e) { }\n            }\n        }\n\n        function addColorToSelectionPalette(color) {\n            if (showSelectionPalette) {\n                var rgb = tinycolor(color).toRgbString();\n                if (!paletteLookup[rgb] && $.inArray(rgb, selectionPalette) === -1) {\n                    selectionPalette.push(rgb);\n                    while(selectionPalette.length > maxSelectionSize) {\n                        selectionPalette.shift();\n                    }\n                }\n\n                if (localStorageKey && window.localStorage) {\n                    try {\n                        window.localStorage[localStorageKey] = selectionPalette.join(\";\");\n                    }\n                    catch(e) { }\n                }\n            }\n        }\n\n        function getUniqueSelectionPalette() {\n            var unique = [];\n            if (opts.showPalette) {\n                for (var i = 0; i < selectionPalette.length; i++) {\n                    var rgb = tinycolor(selectionPalette[i]).toRgbString();\n\n                    if (!paletteLookup[rgb]) {\n                        unique.push(selectionPalette[i]);\n                    }\n                }\n            }\n\n            return unique.reverse().slice(0, opts.maxSelectionSize);\n        }\n\n        function drawPalette() {\n\n            var currentColor = get();\n\n            var html = $.map(paletteArray, function (palette, i) {\n                return paletteTemplate(palette, currentColor, \"sp-palette-row sp-palette-row-\" + i, opts);\n            });\n\n            updateSelectionPaletteFromStorage();\n\n            if (selectionPalette) {\n                html.push(paletteTemplate(getUniqueSelectionPalette(), currentColor, \"sp-palette-row sp-palette-row-selection\", opts));\n            }\n\n            paletteContainer.html(html.join(\"\"));\n        }\n\n        function drawInitial() {\n            if (opts.showInitial) {\n                var initial = colorOnShow;\n                var current = get();\n                initialColorContainer.html(paletteTemplate([initial, current], current, \"sp-palette-row-initial\", opts));\n            }\n        }\n\n        function dragStart() {\n            if (dragHeight <= 0 || dragWidth <= 0 || slideHeight <= 0) {\n                reflow();\n            }\n            isDragging = true;\n            container.addClass(draggingClass);\n            shiftMovementDirection = null;\n            boundElement.trigger('dragstart.spectrum', [ get() ]);\n        }\n\n        function dragStop() {\n            isDragging = false;\n            container.removeClass(draggingClass);\n            boundElement.trigger('dragstop.spectrum', [ get() ]);\n        }\n\n        function setFromTextInput() {\n\n            var value = textInput.val();\n\n            if ((value === null || value === \"\") && allowEmpty) {\n                set(null);\n                move();\n                updateOriginalInput();\n            }\n            else {\n                var tiny = tinycolor(value);\n                if (tiny.isValid()) {\n                    set(tiny);\n                    move();\n                    updateOriginalInput(true);\n                }\n                else {\n                    textInput.addClass(\"sp-validation-error\");\n                }\n            }\n        }\n\n        function toggle() {\n            if (visible) {\n                hide();\n            }\n            else {\n                show();\n            }\n        }\n\n        function show() {\n            var event = $.Event('beforeShow.spectrum');\n\n            if (visible) {\n                reflow();\n                return;\n            }\n\n            boundElement.trigger(event, [ get() ]);\n\n            if (callbacks.beforeShow(get()) === false || event.isDefaultPrevented()) {\n                return;\n            }\n\n            hideAll();\n            visible = true;\n\n            $(doc).on(\"keydown.spectrum\", onkeydown);\n            $(doc).on(\"click.spectrum\", clickout);\n            $(window).on(\"resize.spectrum\", resize);\n            replacer.addClass(\"sp-active\");\n            container.removeClass(\"sp-hidden\");\n\n            reflow();\n            updateUI();\n\n            colorOnShow = get();\n\n            drawInitial();\n            callbacks.show(colorOnShow);\n            boundElement.trigger('show.spectrum', [ colorOnShow ]);\n        }\n\n        function onkeydown(e) {\n            // Close on ESC\n            if (e.keyCode === 27) {\n                hide();\n            }\n        }\n\n        function clickout(e) {\n            // Return on right click.\n            if (e.button == 2) { return; }\n\n            // If a drag event was happening during the mouseup, don't hide\n            // on click.\n            if (isDragging) { return; }\n\n            if (clickoutFiresChange) {\n                updateOriginalInput(true);\n            }\n            else {\n                revert();\n            }\n            hide();\n        }\n\n        function hide() {\n            // Return if hiding is unnecessary\n            if (!visible || flat) { return; }\n            visible = false;\n\n            $(doc).off(\"keydown.spectrum\", onkeydown);\n            $(doc).off(\"click.spectrum\", clickout);\n            $(window).off(\"resize.spectrum\", resize);\n\n            replacer.removeClass(\"sp-active\");\n            container.addClass(\"sp-hidden\");\n\n            callbacks.hide(get());\n            boundElement.trigger('hide.spectrum', [ get() ]);\n        }\n\n        function revert() {\n            set(colorOnShow, true);\n            updateOriginalInput(true);\n        }\n\n        function set(color, ignoreFormatChange) {\n            if (tinycolor.equals(color, get())) {\n                // Update UI just in case a validation error needs\n                // to be cleared.\n                updateUI();\n                return;\n            }\n\n            var newColor, newHsv;\n            if (!color && allowEmpty) {\n                isEmpty = true;\n            } else {\n                isEmpty = false;\n                newColor = tinycolor(color);\n                newHsv = newColor.toHsv();\n\n                currentHue = (newHsv.h % 360) / 360;\n                currentSaturation = newHsv.s;\n                currentValue = newHsv.v;\n                currentAlpha = newHsv.a;\n            }\n            updateUI();\n\n            if (newColor && newColor.isValid() && !ignoreFormatChange) {\n                currentPreferredFormat = opts.preferredFormat || newColor.getFormat();\n            }\n        }\n\n        function get(opts) {\n            opts = opts || { };\n\n            if (allowEmpty && isEmpty) {\n                return null;\n            }\n\n            return tinycolor.fromRatio({\n                h: currentHue,\n                s: currentSaturation,\n                v: currentValue,\n                a: Math.round(currentAlpha * 1000) / 1000\n            }, { format: opts.format || currentPreferredFormat });\n        }\n\n        function isValid() {\n            return !textInput.hasClass(\"sp-validation-error\");\n        }\n\n        function move() {\n            updateUI();\n\n            callbacks.move(get());\n            boundElement.trigger('move.spectrum', [ get() ]);\n        }\n\n        function updateUI() {\n\n            textInput.removeClass(\"sp-validation-error\");\n\n            updateHelperLocations();\n\n            // Update dragger background color (gradients take care of saturation and value).\n            var flatColor = tinycolor.fromRatio({ h: currentHue, s: 1, v: 1 });\n            dragger.css(\"background-color\", flatColor.toHexString());\n\n            // Get a format that alpha will be included in (hex and names ignore alpha)\n            var format = currentPreferredFormat;\n            if (currentAlpha < 1 && !(currentAlpha === 0 && format === \"name\")) {\n                if (format === \"hex\" || format === \"hex3\" || format === \"hex6\" || format === \"name\") {\n                    format = \"rgb\";\n                }\n            }\n\n            var realColor = get({ format: format }),\n                displayColor = '';\n\n            //reset background info for preview element\n            previewElement.removeClass(\"sp-clear-display\");\n            previewElement.css('background-color', 'transparent');\n\n            if (!realColor && allowEmpty) {\n                // Update the replaced elements background with icon indicating no color selection\n                previewElement.addClass(\"sp-clear-display\");\n            }\n            else {\n                var realHex = realColor.toHexString(),\n                    realRgb = realColor.toRgbString();\n\n                // Update the replaced elements background color (with actual selected color)\n                if (rgbaSupport || realColor.alpha === 1) {\n                    previewElement.css(\"background-color\", realRgb);\n                }\n                else {\n                    previewElement.css(\"background-color\", \"transparent\");\n                    previewElement.css(\"filter\", realColor.toFilter());\n                }\n\n                if (opts.showAlpha) {\n                    var rgb = realColor.toRgb();\n                    rgb.a = 0;\n                    var realAlpha = tinycolor(rgb).toRgbString();\n                    var gradient = \"linear-gradient(left, \" + realAlpha + \", \" + realHex + \")\";\n\n                    if (IE) {\n                        alphaSliderInner.css(\"filter\", tinycolor(realAlpha).toFilter({ gradientType: 1 }, realHex));\n                    }\n                    else {\n                        alphaSliderInner.css(\"background\", \"-webkit-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-moz-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-ms-\" + gradient);\n                        // Use current syntax gradient on unprefixed property.\n                        alphaSliderInner.css(\"background\",\n                            \"linear-gradient(to right, \" + realAlpha + \", \" + realHex + \")\");\n                    }\n                }\n\n                displayColor = realColor.toString(format);\n            }\n\n            // Update the text entry input as it changes happen\n            if (opts.showInput) {\n                textInput.val(displayColor);\n            }\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            drawInitial();\n        }\n\n        function updateHelperLocations() {\n            var s = currentSaturation;\n            var v = currentValue;\n\n            if(allowEmpty && isEmpty) {\n                //if selected color is empty, hide the helpers\n                alphaSlideHelper.hide();\n                slideHelper.hide();\n                dragHelper.hide();\n            }\n            else {\n                //make sure helpers are visible\n                alphaSlideHelper.show();\n                slideHelper.show();\n                dragHelper.show();\n\n                // Where to show the little circle in that displays your current selected color\n                var dragX = s * dragWidth;\n                var dragY = dragHeight - (v * dragHeight);\n                dragX = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragWidth - dragHelperHeight, dragX - dragHelperHeight)\n                );\n                dragY = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragHeight - dragHelperHeight, dragY - dragHelperHeight)\n                );\n                dragHelper.css({\n                    \"top\": dragY + \"px\",\n                    \"left\": dragX + \"px\"\n                });\n\n                var alphaX = currentAlpha * alphaWidth;\n                alphaSlideHelper.css({\n                    \"left\": (alphaX - (alphaSlideHelperWidth / 2)) + \"px\"\n                });\n\n                // Where to show the bar that displays your current selected hue\n                var slideY = (currentHue) * slideHeight;\n                slideHelper.css({\n                    \"top\": (slideY - slideHelperHeight) + \"px\"\n                });\n            }\n        }\n\n        function updateOriginalInput(fireCallback) {\n            var color = get(),\n                displayColor = '',\n                hasChanged = !tinycolor.equals(color, colorOnShow);\n\n            if (color) {\n                displayColor = color.toString(currentPreferredFormat);\n                // Update the selection palette with the current color\n                addColorToSelectionPalette(color);\n            }\n\n            if (isInput) {\n                boundElement.val(displayColor);\n            }\n\n            if (fireCallback && hasChanged) {\n                callbacks.change(color);\n                boundElement.trigger('change', [ color ]);\n            }\n        }\n\n        function reflow() {\n            if (!visible) {\n                return; // Calculations would be useless and wouldn't be reliable anyways\n            }\n            dragWidth = dragger.width();\n            dragHeight = dragger.height();\n            dragHelperHeight = dragHelper.height();\n            slideWidth = slider.width();\n            slideHeight = slider.height();\n            slideHelperHeight = slideHelper.height();\n            alphaWidth = alphaSlider.width();\n            alphaSlideHelperWidth = alphaSlideHelper.width();\n\n            if (!flat) {\n                container.css(\"position\", \"absolute\");\n                if (opts.offset) {\n                    container.offset(opts.offset);\n                } else {\n                    container.offset(getOffset(container, offsetElement));\n                }\n            }\n\n            updateHelperLocations();\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            boundElement.trigger('reflow.spectrum');\n        }\n\n        function destroy() {\n            boundElement.show();\n            offsetElement.off(\"click.spectrum touchstart.spectrum\");\n            container.remove();\n            replacer.remove();\n            spectrums[spect.id] = null;\n        }\n\n        function option(optionName, optionValue) {\n            if (optionName === undefined) {\n                return $.extend({}, opts);\n            }\n            if (optionValue === undefined) {\n                return opts[optionName];\n            }\n\n            opts[optionName] = optionValue;\n\n            if (optionName === \"preferredFormat\") {\n                currentPreferredFormat = opts.preferredFormat;\n            }\n            applyOptions();\n        }\n\n        function enable() {\n            disabled = false;\n            boundElement.attr(\"disabled\", false);\n            offsetElement.removeClass(\"sp-disabled\");\n        }\n\n        function disable() {\n            hide();\n            disabled = true;\n            boundElement.attr(\"disabled\", true);\n            offsetElement.addClass(\"sp-disabled\");\n        }\n\n        function setOffset(coord) {\n            opts.offset = coord;\n            reflow();\n        }\n\n        initialize();\n\n        var spect = {\n            show: show,\n            hide: hide,\n            toggle: toggle,\n            reflow: reflow,\n            option: option,\n            enable: enable,\n            disable: disable,\n            offset: setOffset,\n            set: function (c) {\n                set(c);\n                updateOriginalInput();\n            },\n            get: get,\n            destroy: destroy,\n            container: container\n        };\n\n        spect.id = spectrums.push(spect) - 1;\n\n        return spect;\n    }\n\n    /**\n     * checkOffset - get the offset below/above and left/right element depending on screen position\n     * Thanks https://github.com/jquery/jquery-ui/blob/master/ui/jquery.ui.datepicker.js\n     */\n    function getOffset(picker, input) {\n        var extraY = 0;\n        var dpWidth = picker.outerWidth();\n        var dpHeight = picker.outerHeight();\n        var inputHeight = input.outerHeight();\n        var doc = picker[0].ownerDocument;\n        var docElem = doc.documentElement;\n        var viewWidth = docElem.clientWidth + $(doc).scrollLeft();\n        var viewHeight = docElem.clientHeight + $(doc).scrollTop();\n        var offset = input.offset();\n        var offsetLeft = offset.left;\n        var offsetTop = offset.top;\n\n        offsetTop += inputHeight;\n\n        offsetLeft -=\n            Math.min(offsetLeft, (offsetLeft + dpWidth > viewWidth && viewWidth > dpWidth) ?\n                Math.abs(offsetLeft + dpWidth - viewWidth) : 0);\n\n        offsetTop -=\n            Math.min(offsetTop, ((offsetTop + dpHeight > viewHeight && viewHeight > dpHeight) ?\n                Math.abs(dpHeight + inputHeight - extraY) : extraY));\n\n        return {\n            top: offsetTop,\n            bottom: offset.bottom,\n            left: offsetLeft,\n            right: offset.right,\n            width: offset.width,\n            height: offset.height\n        };\n    }\n\n    /**\n     * noop - do nothing\n     */\n    function noop() {\n\n    }\n\n    /**\n     * stopPropagation - makes the code only doing this a little easier to read in line\n     */\n    function stopPropagation(e) {\n        e.stopPropagation();\n    }\n\n    /**\n     * Create a function bound to a given object\n     * Thanks to underscore.js\n     */\n    function bind(func, obj) {\n        var slice = Array.prototype.slice;\n        var args = slice.call(arguments, 2);\n        return function () {\n            return func.apply(obj, args.concat(slice.call(arguments)));\n        };\n    }\n\n    /**\n     * Lightweight drag helper.  Handles containment within the element, so that\n     * when dragging, the x is within [0,element.width] and y is within [0,element.height]\n     */\n    function draggable(element, onmove, onstart, onstop) {\n        onmove = onmove || function () { };\n        onstart = onstart || function () { };\n        onstop = onstop || function () { };\n        var doc = document;\n        var dragging = false;\n        var offset = {};\n        var maxHeight = 0;\n        var maxWidth = 0;\n        var hasTouch = ('ontouchstart' in window);\n\n        var duringDragEvents = {};\n        duringDragEvents[\"selectstart\"] = prevent;\n        duringDragEvents[\"dragstart\"] = prevent;\n        duringDragEvents[\"touchmove mousemove\"] = move;\n        duringDragEvents[\"touchend mouseup\"] = stop;\n\n        function prevent(e) {\n            if (e.stopPropagation) {\n                e.stopPropagation();\n            }\n            if (e.preventDefault) {\n                e.preventDefault();\n            }\n            e.returnValue = false;\n        }\n\n        function move(e) {\n            if (dragging) {\n                // Mouseup happened outside of window\n                if (IE && doc.documentMode < 9 && !e.button) {\n                    return stop();\n                }\n\n                var t0 = e.originalEvent && e.originalEvent.touches && e.originalEvent.touches[0];\n                var pageX = t0 && t0.pageX || e.pageX;\n                var pageY = t0 && t0.pageY || e.pageY;\n\n                var dragX = Math.max(0, Math.min(pageX - offset.left, maxWidth));\n                var dragY = Math.max(0, Math.min(pageY - offset.top, maxHeight));\n\n                if (hasTouch) {\n                    // Stop scrolling in iOS\n                    prevent(e);\n                }\n\n                onmove.apply(element, [dragX, dragY, e]);\n            }\n        }\n\n        function start(e) {\n            var rightclick = (e.which) ? (e.which == 3) : (e.button == 2);\n\n            if (!rightclick && !dragging) {\n                if (onstart.apply(element, arguments) !== false) {\n                    dragging = true;\n                    maxHeight = $(element).height();\n                    maxWidth = $(element).width();\n                    offset = $(element).offset();\n\n                    $(doc).on(duringDragEvents);\n                    $(doc.body).addClass(\"sp-dragging\");\n\n                    move(e);\n\n                    prevent(e);\n                }\n            }\n        }\n\n        function stop() {\n            if (dragging) {\n                $(doc).off(duringDragEvents);\n                $(doc.body).removeClass(\"sp-dragging\");\n\n                // Wait a tick before notifying observers to allow the click event\n                // to fire in Chrome.\n                setTimeout(function() {\n                    onstop.apply(element, arguments);\n                }, 0);\n            }\n            dragging = false;\n        }\n\n        $(element).on(\"touchstart mousedown\", start);\n    }\n\n    function throttle(func, wait, debounce) {\n        var timeout;\n        return function () {\n            var context = this, args = arguments;\n            var throttler = function () {\n                timeout = null;\n                func.apply(context, args);\n            };\n            if (debounce) clearTimeout(timeout);\n            if (debounce || !timeout) timeout = setTimeout(throttler, wait);\n        };\n    }\n\n    function inputTypeColorSupport() {\n        return $.fn.spectrum.inputTypeColorSupport();\n    }\n\n    /**\n     * Define a jQuery plugin\n     */\n    var dataID = \"spectrum.id\";\n    $.fn.spectrum = function (opts, extra) {\n\n        if (typeof opts == \"string\") {\n\n            var returnValue = this;\n            var args = Array.prototype.slice.call( arguments, 1 );\n\n            this.each(function () {\n                var spect = spectrums[$(this).data(dataID)];\n                if (spect) {\n                    var method = spect[opts];\n                    if (!method) {\n                        throw new Error( \"Spectrum: no such method: '\" + opts + \"'\" );\n                    }\n\n                    if (opts == \"get\") {\n                        returnValue = spect.get();\n                    }\n                    else if (opts == \"container\") {\n                        returnValue = spect.container;\n                    }\n                    else if (opts == \"option\") {\n                        returnValue = spect.option.apply(spect, args);\n                    }\n                    else if (opts == \"destroy\") {\n                        spect.destroy();\n                        $(this).removeData(dataID);\n                    }\n                    else {\n                        method.apply(spect, args);\n                    }\n                }\n            });\n\n            return returnValue;\n        }\n\n        // Initializing a new instance of spectrum\n        return this.spectrum(\"destroy\").each(function () {\n            var options = $.extend({}, $(this).data(), opts);\n            var spect = spectrum(this, options);\n            $(this).data(dataID, spect.id);\n        });\n    };\n\n    $.fn.spectrum.load = true;\n    $.fn.spectrum.loadOpts = {};\n    $.fn.spectrum.draggable = draggable;\n    $.fn.spectrum.defaults = defaultOpts;\n    $.fn.spectrum.inputTypeColorSupport = function inputTypeColorSupport() {\n        if (typeof inputTypeColorSupport._cachedResult === \"undefined\") {\n            var colorInput = $(\"<input type='color'/>\")[0]; // if color element is supported, value will default to not null\n            inputTypeColorSupport._cachedResult = colorInput.type === \"color\" && colorInput.value !== \"\";\n        }\n        return inputTypeColorSupport._cachedResult;\n    };\n\n    $.spectrum = { };\n    $.spectrum.localization = { };\n    $.spectrum.palettes = { };\n\n    $.fn.spectrum.processNativeColorInputs = function () {\n        var colorInputs = $(\"input[type=color]\");\n        if (colorInputs.length && !inputTypeColorSupport()) {\n            colorInputs.spectrum({\n                preferredFormat: \"hex6\"\n            });\n        }\n    };\n\n    // TinyColor v1.1.2\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    (function() {\n\n        var trimLeft = /^[\\s,#]+/,\n            trimRight = /\\s+$/,\n            tinyCounter = 0,\n            math = Math,\n            mathRound = math.round,\n            mathMin = math.min,\n            mathMax = math.max,\n            mathRandom = math.random;\n\n        var tinycolor = function(color, opts) {\n\n            color = (color) ? color : '';\n            opts = opts || { };\n\n            // If input is already a tinycolor, return itself\n            if (color instanceof tinycolor) {\n                return color;\n            }\n            // If we are called as a function, call using new instead\n            if (!(this instanceof tinycolor)) {\n                return new tinycolor(color, opts);\n            }\n\n            var rgb = inputToRGB(color);\n            this._originalInput = color;\n            this._r = rgb.r;\n            this._g = rgb.g;\n            this._b = rgb.b;\n            this._a = rgb.a;\n            this._roundA = mathRound(1000 * this._a) / 1000;\n            this._format = opts.format || rgb.format;\n            this._gradientType = opts.gradientType;\n\n            // Don't let the range of [0,255] come back in [0,1].\n            // Potentially lose a little bit of precision here, but will fix issues where\n            // .5 gets interpreted as half of the total, instead of half of 1\n            // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n            if (this._r < 1) { this._r = mathRound(this._r); }\n            if (this._g < 1) { this._g = mathRound(this._g); }\n            if (this._b < 1) { this._b = mathRound(this._b); }\n\n            this._ok = rgb.ok;\n            this._tc_id = tinyCounter++;\n        };\n\n        tinycolor.prototype = {\n            isDark: function() {\n                return this.getBrightness() < 128;\n            },\n            isLight: function() {\n                return !this.isDark();\n            },\n            isValid: function() {\n                return this._ok;\n            },\n            getOriginalInput: function() {\n                return this._originalInput;\n            },\n            getFormat: function() {\n                return this._format;\n            },\n            getAlpha: function() {\n                return this._a;\n            },\n            getBrightness: function() {\n                var rgb = this.toRgb();\n                return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n            },\n            setAlpha: function(value) {\n                this._a = boundAlpha(value);\n                this._roundA = mathRound(1000 * this._a) / 1000;\n                return this;\n            },\n            toHsv: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n            },\n            toHsvString: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n                return (this._a == 1) ?\n                    \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                    \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n            },\n            toHsl: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n            },\n            toHslString: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n                return (this._a == 1) ?\n                    \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                    \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n            },\n            toHex: function(allow3Char) {\n                return rgbToHex(this._r, this._g, this._b, allow3Char);\n            },\n            toHexString: function(allow3Char) {\n                return '#' + this.toHex(allow3Char);\n            },\n            toHex8: function() {\n                return rgbaToHex(this._r, this._g, this._b, this._a);\n            },\n            toHex8String: function() {\n                return '#' + this.toHex8();\n            },\n            toRgb: function() {\n                return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n            },\n            toRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                    \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n            },\n            toPercentageRgb: function() {\n                return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n            },\n            toPercentageRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                    \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n            },\n            toName: function() {\n                if (this._a === 0) {\n                    return \"transparent\";\n                }\n\n                if (this._a < 1) {\n                    return false;\n                }\n\n                return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n            },\n            toFilter: function(secondColor) {\n                var hex8String = '#' + rgbaToHex(this._r, this._g, this._b, this._a);\n                var secondHex8String = hex8String;\n                var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n                if (secondColor) {\n                    var s = tinycolor(secondColor);\n                    secondHex8String = s.toHex8String();\n                }\n\n                return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n            },\n            toString: function(format) {\n                var formatSet = !!format;\n                format = format || this._format;\n\n                var formattedString = false;\n                var hasAlpha = this._a < 1 && this._a >= 0;\n                var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"name\");\n\n                if (needsAlphaFormat) {\n                    // Special case for \"transparent\", all other non-alpha formats\n                    // will return rgba when there is transparency.\n                    if (format === \"name\" && this._a === 0) {\n                        return this.toName();\n                    }\n                    return this.toRgbString();\n                }\n                if (format === \"rgb\") {\n                    formattedString = this.toRgbString();\n                }\n                if (format === \"prgb\") {\n                    formattedString = this.toPercentageRgbString();\n                }\n                if (format === \"hex\" || format === \"hex6\") {\n                    formattedString = this.toHexString();\n                }\n                if (format === \"hex3\") {\n                    formattedString = this.toHexString(true);\n                }\n                if (format === \"hex8\") {\n                    formattedString = this.toHex8String();\n                }\n                if (format === \"name\") {\n                    formattedString = this.toName();\n                }\n                if (format === \"hsl\") {\n                    formattedString = this.toHslString();\n                }\n                if (format === \"hsv\") {\n                    formattedString = this.toHsvString();\n                }\n\n                return formattedString || this.toHexString();\n            },\n\n            _applyModification: function(fn, args) {\n                var color = fn.apply(null, [this].concat([].slice.call(args)));\n                this._r = color._r;\n                this._g = color._g;\n                this._b = color._b;\n                this.setAlpha(color._a);\n                return this;\n            },\n            lighten: function() {\n                return this._applyModification(lighten, arguments);\n            },\n            brighten: function() {\n                return this._applyModification(brighten, arguments);\n            },\n            darken: function() {\n                return this._applyModification(darken, arguments);\n            },\n            desaturate: function() {\n                return this._applyModification(desaturate, arguments);\n            },\n            saturate: function() {\n                return this._applyModification(saturate, arguments);\n            },\n            greyscale: function() {\n                return this._applyModification(greyscale, arguments);\n            },\n            spin: function() {\n                return this._applyModification(spin, arguments);\n            },\n\n            _applyCombination: function(fn, args) {\n                return fn.apply(null, [this].concat([].slice.call(args)));\n            },\n            analogous: function() {\n                return this._applyCombination(analogous, arguments);\n            },\n            complement: function() {\n                return this._applyCombination(complement, arguments);\n            },\n            monochromatic: function() {\n                return this._applyCombination(monochromatic, arguments);\n            },\n            splitcomplement: function() {\n                return this._applyCombination(splitcomplement, arguments);\n            },\n            triad: function() {\n                return this._applyCombination(triad, arguments);\n            },\n            tetrad: function() {\n                return this._applyCombination(tetrad, arguments);\n            }\n        };\n\n        // If input is an object, force 1 into \"1.0\" to handle ratios properly\n        // String input requires \"1.0\" as input, so 1 will be treated as 1\n        tinycolor.fromRatio = function(color, opts) {\n            if (typeof color == \"object\") {\n                var newColor = {};\n                for (var i in color) {\n                    if (color.hasOwnProperty(i)) {\n                        if (i === \"a\") {\n                            newColor[i] = color[i];\n                        }\n                        else {\n                            newColor[i] = convertToPercentage(color[i]);\n                        }\n                    }\n                }\n                color = newColor;\n            }\n\n            return tinycolor(color, opts);\n        };\n\n        // Given a string or object, convert that input to RGB\n        // Possible string inputs:\n        //\n        //     \"red\"\n        //     \"#f00\" or \"f00\"\n        //     \"#ff0000\" or \"ff0000\"\n        //     \"#ff000000\" or \"ff000000\"\n        //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n        //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n        //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n        //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n        //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n        //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n        //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n        //\n        function inputToRGB(color) {\n\n            var rgb = { r: 0, g: 0, b: 0 };\n            var a = 1;\n            var ok = false;\n            var format = false;\n\n            if (typeof color == \"string\") {\n                color = stringInputToObject(color);\n            }\n\n            if (typeof color == \"object\") {\n                if (color.hasOwnProperty(\"r\") && color.hasOwnProperty(\"g\") && color.hasOwnProperty(\"b\")) {\n                    rgb = rgbToRgb(color.r, color.g, color.b);\n                    ok = true;\n                    format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"v\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.v = convertToPercentage(color.v);\n                    rgb = hsvToRgb(color.h, color.s, color.v);\n                    ok = true;\n                    format = \"hsv\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"l\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.l = convertToPercentage(color.l);\n                    rgb = hslToRgb(color.h, color.s, color.l);\n                    ok = true;\n                    format = \"hsl\";\n                }\n\n                if (color.hasOwnProperty(\"a\")) {\n                    a = color.a;\n                }\n            }\n\n            a = boundAlpha(a);\n\n            return {\n                ok: ok,\n                format: color.format || format,\n                r: mathMin(255, mathMax(rgb.r, 0)),\n                g: mathMin(255, mathMax(rgb.g, 0)),\n                b: mathMin(255, mathMax(rgb.b, 0)),\n                a: a\n            };\n        }\n\n\n        // Conversion Functions\n        // --------------------\n\n        // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n        // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n        // `rgbToRgb`\n        // Handle bounds / percentage checking to conform to CSS color spec\n        // <http://www.w3.org/TR/css3-color/>\n        // *Assumes:* r, g, b in [0, 255] or [0, 1]\n        // *Returns:* { r, g, b } in [0, 255]\n        function rgbToRgb(r, g, b){\n            return {\n                r: bound01(r, 255) * 255,\n                g: bound01(g, 255) * 255,\n                b: bound01(b, 255) * 255\n            };\n        }\n\n        // `rgbToHsl`\n        // Converts an RGB color value to HSL.\n        // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n        // *Returns:* { h, s, l } in [0,1]\n        function rgbToHsl(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, l = (max + min) / 2;\n\n            if(max == min) {\n                h = s = 0; // achromatic\n            }\n            else {\n                var d = max - min;\n                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n\n                h /= 6;\n            }\n\n            return { h: h, s: s, l: l };\n        }\n\n        // `hslToRgb`\n        // Converts an HSL color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hslToRgb(h, s, l) {\n            var r, g, b;\n\n            h = bound01(h, 360);\n            s = bound01(s, 100);\n            l = bound01(l, 100);\n\n            function hue2rgb(p, q, t) {\n                if(t < 0) t += 1;\n                if(t > 1) t -= 1;\n                if(t < 1/6) return p + (q - p) * 6 * t;\n                if(t < 1/2) return q;\n                if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n                return p;\n            }\n\n            if(s === 0) {\n                r = g = b = l; // achromatic\n            }\n            else {\n                var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n                var p = 2 * l - q;\n                r = hue2rgb(p, q, h + 1/3);\n                g = hue2rgb(p, q, h);\n                b = hue2rgb(p, q, h - 1/3);\n            }\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHsv`\n        // Converts an RGB color value to HSV\n        // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n        // *Returns:* { h, s, v } in [0,1]\n        function rgbToHsv(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, v = max;\n\n            var d = max - min;\n            s = max === 0 ? 0 : d / max;\n\n            if(max == min) {\n                h = 0; // achromatic\n            }\n            else {\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n                h /= 6;\n            }\n            return { h: h, s: s, v: v };\n        }\n\n        // `hsvToRgb`\n        // Converts an HSV color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hsvToRgb(h, s, v) {\n\n            h = bound01(h, 360) * 6;\n            s = bound01(s, 100);\n            v = bound01(v, 100);\n\n            var i = math.floor(h),\n                f = h - i,\n                p = v * (1 - s),\n                q = v * (1 - f * s),\n                t = v * (1 - (1 - f) * s),\n                mod = i % 6,\n                r = [v, q, p, p, t, v][mod],\n                g = [t, v, v, q, p, p][mod],\n                b = [p, p, t, v, v, q][mod];\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHex`\n        // Converts an RGB color to hex\n        // Assumes r, g, and b are contained in the set [0, 255]\n        // Returns a 3 or 6 character hex\n        function rgbToHex(r, g, b, allow3Char) {\n\n            var hex = [\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            // Return a 3 character hex if possible\n            if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n                return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n            }\n\n            return hex.join(\"\");\n        }\n        // `rgbaToHex`\n        // Converts an RGBA color plus alpha transparency to hex\n        // Assumes r, g, b and a are contained in the set [0, 255]\n        // Returns an 8 character hex\n        function rgbaToHex(r, g, b, a) {\n\n            var hex = [\n                pad2(convertDecimalToHex(a)),\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            return hex.join(\"\");\n        }\n\n        // `equals`\n        // Can be called with any tinycolor input\n        tinycolor.equals = function (color1, color2) {\n            if (!color1 || !color2) { return false; }\n            return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n        };\n        tinycolor.random = function() {\n            return tinycolor.fromRatio({\n                r: mathRandom(),\n                g: mathRandom(),\n                b: mathRandom()\n            });\n        };\n\n\n        // Modification Functions\n        // ----------------------\n        // Thanks to less.js for some of the basics here\n        // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n        function desaturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s -= amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function saturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s += amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function greyscale(color) {\n            return tinycolor(color).desaturate(100);\n        }\n\n        function lighten (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l += amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        function brighten(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var rgb = tinycolor(color).toRgb();\n            rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n            rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n            rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n            return tinycolor(rgb);\n        }\n\n        function darken (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l -= amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n        // Values outside of this range will be wrapped into this range.\n        function spin(color, amount) {\n            var hsl = tinycolor(color).toHsl();\n            var hue = (mathRound(hsl.h) + amount) % 360;\n            hsl.h = hue < 0 ? 360 + hue : hue;\n            return tinycolor(hsl);\n        }\n\n        // Combination Functions\n        // ---------------------\n        // Thanks to jQuery xColor for some of the ideas behind these\n        // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n        function complement(color) {\n            var hsl = tinycolor(color).toHsl();\n            hsl.h = (hsl.h + 180) % 360;\n            return tinycolor(hsl);\n        }\n\n        function triad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function tetrad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function splitcomplement(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n                tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n            ];\n        }\n\n        function analogous(color, results, slices) {\n            results = results || 6;\n            slices = slices || 30;\n\n            var hsl = tinycolor(color).toHsl();\n            var part = 360 / slices;\n            var ret = [tinycolor(color)];\n\n            for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n                hsl.h = (hsl.h + part) % 360;\n                ret.push(tinycolor(hsl));\n            }\n            return ret;\n        }\n\n        function monochromatic(color, results) {\n            results = results || 6;\n            var hsv = tinycolor(color).toHsv();\n            var h = hsv.h, s = hsv.s, v = hsv.v;\n            var ret = [];\n            var modification = 1 / results;\n\n            while (results--) {\n                ret.push(tinycolor({ h: h, s: s, v: v}));\n                v = (v + modification) % 1;\n            }\n\n            return ret;\n        }\n\n        // Utility Functions\n        // ---------------------\n\n        tinycolor.mix = function(color1, color2, amount) {\n            amount = (amount === 0) ? 0 : (amount || 50);\n\n            var rgb1 = tinycolor(color1).toRgb();\n            var rgb2 = tinycolor(color2).toRgb();\n\n            var p = amount / 100;\n            var w = p * 2 - 1;\n            var a = rgb2.a - rgb1.a;\n\n            var w1;\n\n            if (w * a == -1) {\n                w1 = w;\n            } else {\n                w1 = (w + a) / (1 + w * a);\n            }\n\n            w1 = (w1 + 1) / 2;\n\n            var w2 = 1 - w1;\n\n            var rgba = {\n                r: rgb2.r * w1 + rgb1.r * w2,\n                g: rgb2.g * w1 + rgb1.g * w2,\n                b: rgb2.b * w1 + rgb1.b * w2,\n                a: rgb2.a * p  + rgb1.a * (1 - p)\n            };\n\n            return tinycolor(rgba);\n        };\n\n\n        // Readability Functions\n        // ---------------------\n        // <http://www.w3.org/TR/AERT#color-contrast>\n\n        // `readability`\n        // Analyze the 2 colors and returns an object with the following properties:\n        //    `brightness`: difference in brightness between the two colors\n        //    `color`: difference in color/hue between the two colors\n        tinycolor.readability = function(color1, color2) {\n            var c1 = tinycolor(color1);\n            var c2 = tinycolor(color2);\n            var rgb1 = c1.toRgb();\n            var rgb2 = c2.toRgb();\n            var brightnessA = c1.getBrightness();\n            var brightnessB = c2.getBrightness();\n            var colorDiff = (\n                Math.max(rgb1.r, rgb2.r) - Math.min(rgb1.r, rgb2.r) +\n                Math.max(rgb1.g, rgb2.g) - Math.min(rgb1.g, rgb2.g) +\n                Math.max(rgb1.b, rgb2.b) - Math.min(rgb1.b, rgb2.b)\n            );\n\n            return {\n                brightness: Math.abs(brightnessA - brightnessB),\n                color: colorDiff\n            };\n        };\n\n        // `readable`\n        // http://www.w3.org/TR/AERT#color-contrast\n        // Ensure that foreground and background color combinations provide sufficient contrast.\n        // *Example*\n        //    tinycolor.isReadable(\"#000\", \"#111\") => false\n        tinycolor.isReadable = function(color1, color2) {\n            var readability = tinycolor.readability(color1, color2);\n            return readability.brightness > 125 && readability.color > 500;\n        };\n\n        // `mostReadable`\n        // Given a base color and a list of possible foreground or background\n        // colors for that base, returns the most readable color.\n        // *Example*\n        //    tinycolor.mostReadable(\"#123\", [\"#fff\", \"#000\"]) => \"#000\"\n        tinycolor.mostReadable = function(baseColor, colorList) {\n            var bestColor = null;\n            var bestScore = 0;\n            var bestIsReadable = false;\n            for (var i=0; i < colorList.length; i++) {\n\n                // We normalize both around the \"acceptable\" breaking point,\n                // but rank brightness constrast higher than hue.\n\n                var readability = tinycolor.readability(baseColor, colorList[i]);\n                var readable = readability.brightness > 125 && readability.color > 500;\n                var score = 3 * (readability.brightness / 125) + (readability.color / 500);\n\n                if ((readable && ! bestIsReadable) ||\n                    (readable && bestIsReadable && score > bestScore) ||\n                    ((! readable) && (! bestIsReadable) && score > bestScore)) {\n                    bestIsReadable = readable;\n                    bestScore = score;\n                    bestColor = tinycolor(colorList[i]);\n                }\n            }\n            return bestColor;\n        };\n\n\n        // Big List of Colors\n        // ------------------\n        // <http://www.w3.org/TR/css3-color/#svg-color>\n        var names = tinycolor.names = {\n            aliceblue: \"f0f8ff\",\n            antiquewhite: \"faebd7\",\n            aqua: \"0ff\",\n            aquamarine: \"7fffd4\",\n            azure: \"f0ffff\",\n            beige: \"f5f5dc\",\n            bisque: \"ffe4c4\",\n            black: \"000\",\n            blanchedalmond: \"ffebcd\",\n            blue: \"00f\",\n            blueviolet: \"8a2be2\",\n            brown: \"a52a2a\",\n            burlywood: \"deb887\",\n            burntsienna: \"ea7e5d\",\n            cadetblue: \"5f9ea0\",\n            chartreuse: \"7fff00\",\n            chocolate: \"d2691e\",\n            coral: \"ff7f50\",\n            cornflowerblue: \"6495ed\",\n            cornsilk: \"fff8dc\",\n            crimson: \"dc143c\",\n            cyan: \"0ff\",\n            darkblue: \"00008b\",\n            darkcyan: \"008b8b\",\n            darkgoldenrod: \"b8860b\",\n            darkgray: \"a9a9a9\",\n            darkgreen: \"006400\",\n            darkgrey: \"a9a9a9\",\n            darkkhaki: \"bdb76b\",\n            darkmagenta: \"8b008b\",\n            darkolivegreen: \"556b2f\",\n            darkorange: \"ff8c00\",\n            darkorchid: \"9932cc\",\n            darkred: \"8b0000\",\n            darksalmon: \"e9967a\",\n            darkseagreen: \"8fbc8f\",\n            darkslateblue: \"483d8b\",\n            darkslategray: \"2f4f4f\",\n            darkslategrey: \"2f4f4f\",\n            darkturquoise: \"00ced1\",\n            darkviolet: \"9400d3\",\n            deeppink: \"ff1493\",\n            deepskyblue: \"00bfff\",\n            dimgray: \"696969\",\n            dimgrey: \"696969\",\n            dodgerblue: \"1e90ff\",\n            firebrick: \"b22222\",\n            floralwhite: \"fffaf0\",\n            forestgreen: \"228b22\",\n            fuchsia: \"f0f\",\n            gainsboro: \"dcdcdc\",\n            ghostwhite: \"f8f8ff\",\n            gold: \"ffd700\",\n            goldenrod: \"daa520\",\n            gray: \"808080\",\n            green: \"008000\",\n            greenyellow: \"adff2f\",\n            grey: \"808080\",\n            honeydew: \"f0fff0\",\n            hotpink: \"ff69b4\",\n            indianred: \"cd5c5c\",\n            indigo: \"4b0082\",\n            ivory: \"fffff0\",\n            khaki: \"f0e68c\",\n            lavender: \"e6e6fa\",\n            lavenderblush: \"fff0f5\",\n            lawngreen: \"7cfc00\",\n            lemonchiffon: \"fffacd\",\n            lightblue: \"add8e6\",\n            lightcoral: \"f08080\",\n            lightcyan: \"e0ffff\",\n            lightgoldenrodyellow: \"fafad2\",\n            lightgray: \"d3d3d3\",\n            lightgreen: \"90ee90\",\n            lightgrey: \"d3d3d3\",\n            lightpink: \"ffb6c1\",\n            lightsalmon: \"ffa07a\",\n            lightseagreen: \"20b2aa\",\n            lightskyblue: \"87cefa\",\n            lightslategray: \"789\",\n            lightslategrey: \"789\",\n            lightsteelblue: \"b0c4de\",\n            lightyellow: \"ffffe0\",\n            lime: \"0f0\",\n            limegreen: \"32cd32\",\n            linen: \"faf0e6\",\n            magenta: \"f0f\",\n            maroon: \"800000\",\n            mediumaquamarine: \"66cdaa\",\n            mediumblue: \"0000cd\",\n            mediumorchid: \"ba55d3\",\n            mediumpurple: \"9370db\",\n            mediumseagreen: \"3cb371\",\n            mediumslateblue: \"7b68ee\",\n            mediumspringgreen: \"00fa9a\",\n            mediumturquoise: \"48d1cc\",\n            mediumvioletred: \"c71585\",\n            midnightblue: \"191970\",\n            mintcream: \"f5fffa\",\n            mistyrose: \"ffe4e1\",\n            moccasin: \"ffe4b5\",\n            navajowhite: \"ffdead\",\n            navy: \"000080\",\n            oldlace: \"fdf5e6\",\n            olive: \"808000\",\n            olivedrab: \"6b8e23\",\n            orange: \"ffa500\",\n            orangered: \"ff4500\",\n            orchid: \"da70d6\",\n            palegoldenrod: \"eee8aa\",\n            palegreen: \"98fb98\",\n            paleturquoise: \"afeeee\",\n            palevioletred: \"db7093\",\n            papayawhip: \"ffefd5\",\n            peachpuff: \"ffdab9\",\n            peru: \"cd853f\",\n            pink: \"ffc0cb\",\n            plum: \"dda0dd\",\n            powderblue: \"b0e0e6\",\n            purple: \"800080\",\n            rebeccapurple: \"663399\",\n            red: \"f00\",\n            rosybrown: \"bc8f8f\",\n            royalblue: \"4169e1\",\n            saddlebrown: \"8b4513\",\n            salmon: \"fa8072\",\n            sandybrown: \"f4a460\",\n            seagreen: \"2e8b57\",\n            seashell: \"fff5ee\",\n            sienna: \"a0522d\",\n            silver: \"c0c0c0\",\n            skyblue: \"87ceeb\",\n            slateblue: \"6a5acd\",\n            slategray: \"708090\",\n            slategrey: \"708090\",\n            snow: \"fffafa\",\n            springgreen: \"00ff7f\",\n            steelblue: \"4682b4\",\n            tan: \"d2b48c\",\n            teal: \"008080\",\n            thistle: \"d8bfd8\",\n            tomato: \"ff6347\",\n            turquoise: \"40e0d0\",\n            violet: \"ee82ee\",\n            wheat: \"f5deb3\",\n            white: \"fff\",\n            whitesmoke: \"f5f5f5\",\n            yellow: \"ff0\",\n            yellowgreen: \"9acd32\"\n        };\n\n        // Make it easy to access colors via `hexNames[hex]`\n        var hexNames = tinycolor.hexNames = flip(names);\n\n\n        // Utilities\n        // ---------\n\n        // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n        function flip(o) {\n            var flipped = { };\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    flipped[o[i]] = i;\n                }\n            }\n            return flipped;\n        }\n\n        // Return a valid alpha value [0,1] with all invalid values being set to 1\n        function boundAlpha(a) {\n            a = parseFloat(a);\n\n            if (isNaN(a) || a < 0 || a > 1) {\n                a = 1;\n            }\n\n            return a;\n        }\n\n        // Take input from [0, n] and return it as [0, 1]\n        function bound01(n, max) {\n            if (isOnePointZero(n)) { n = \"100%\"; }\n\n            var processPercent = isPercentage(n);\n            n = mathMin(max, mathMax(0, parseFloat(n)));\n\n            // Automatically convert percentage into number\n            if (processPercent) {\n                n = parseInt(n * max, 10) / 100;\n            }\n\n            // Handle floating point rounding errors\n            if ((math.abs(n - max) < 0.000001)) {\n                return 1;\n            }\n\n            // Convert into [0, 1] range if it isn't already\n            return (n % max) / parseFloat(max);\n        }\n\n        // Force a number between 0 and 1\n        function clamp01(val) {\n            return mathMin(1, mathMax(0, val));\n        }\n\n        // Parse a base-16 hex value into a base-10 integer\n        function parseIntFromHex(val) {\n            return parseInt(val, 16);\n        }\n\n        // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n        // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n        function isOnePointZero(n) {\n            return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n        }\n\n        // Check to see if string passed in is a percentage\n        function isPercentage(n) {\n            return typeof n === \"string\" && n.indexOf('%') != -1;\n        }\n\n        // Force a hex value to have 2 characters\n        function pad2(c) {\n            return c.length == 1 ? '0' + c : '' + c;\n        }\n\n        // Replace a decimal with it's percentage value\n        function convertToPercentage(n) {\n            if (n <= 1) {\n                n = (n * 100) + \"%\";\n            }\n\n            return n;\n        }\n\n        // Converts a decimal to a hex value\n        function convertDecimalToHex(d) {\n            return Math.round(parseFloat(d) * 255).toString(16);\n        }\n        // Converts a hex value to a decimal\n        function convertHexToDecimal(h) {\n            return (parseIntFromHex(h) / 255);\n        }\n\n        var matchers = (function() {\n\n            // <http://www.w3.org/TR/css3-values/#integers>\n            var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n            // <http://www.w3.org/TR/css3-values/#number-value>\n            var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n            // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n            var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n            // Actual matching.\n            // Parentheses and commas are optional, but not required.\n            // Whitespace can take the place of commas or opening paren\n            var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n            var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n            return {\n                rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n                rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n                hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n                hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n                hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n                hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n                hex3: /^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n                hex6: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n                hex8: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n            };\n        })();\n\n        // `stringInputToObject`\n        // Permissive string parsing.  Take in a number of formats, and output an object\n        // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n        function stringInputToObject(color) {\n\n            color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n            var named = false;\n            if (names[color]) {\n                color = names[color];\n                named = true;\n            }\n            else if (color == 'transparent') {\n                return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n            }\n\n            // Try to match string input using regular expressions.\n            // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n            // Just return an object and let the conversion functions handle that.\n            // This way the result will be the same whether the tinycolor is initialized with string or object.\n            var match;\n            if ((match = matchers.rgb.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3] };\n            }\n            if ((match = matchers.rgba.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsl.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3] };\n            }\n            if ((match = matchers.hsla.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsv.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3] };\n            }\n            if ((match = matchers.hsva.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3], a: match[4] };\n            }\n            if ((match = matchers.hex8.exec(color))) {\n                return {\n                    a: convertHexToDecimal(match[1]),\n                    r: parseIntFromHex(match[2]),\n                    g: parseIntFromHex(match[3]),\n                    b: parseIntFromHex(match[4]),\n                    format: named ? \"name\" : \"hex8\"\n                };\n            }\n            if ((match = matchers.hex6.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1]),\n                    g: parseIntFromHex(match[2]),\n                    b: parseIntFromHex(match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n            if ((match = matchers.hex3.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1] + '' + match[1]),\n                    g: parseIntFromHex(match[2] + '' + match[2]),\n                    b: parseIntFromHex(match[3] + '' + match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n\n            return false;\n        }\n\n        window.tinycolor = tinycolor;\n    })();\n\n    $(function () {\n        if ($.fn.spectrum.load) {\n            $.fn.spectrum.processNativeColorInputs();\n        }\n    });\n\n});\n"}
}});
